/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __kicker_h__
#define __kicker_h__

#include <kuniqueapplication.h>
#include <kicontheme.h>
class PanelKMenu;
class KGlobalAccel;
class PanelPopupButton;

class Kicker : public KUniqueApplication
{
    Q_OBJECT
    K_DCOP

public:
    Kicker();
    ~Kicker();

k_dcop:
    void configure();
    void restart();
    void addExtension( const QString &desktopFile );
    void popupKMenu( const QPoint &globalPos );
    void clearQuickStartMenu();
    void configLaunched();
    bool highlightMenuItem( const QString &menuId );
    void showKMenu();

public:
    // "dimension" refers to the height of a horizontal panel, or the
    // width of a vertical panel
    enum { MIN_DIMENSION=24,              // minumum panel dimension
           MAX_DIMENSION=128,             // maximum panel dimension
           // the default dimension when a custom panel size is chosen
           DEFAULT_CUSTOM_DIMENSION=56,
           // the maximum icon size to use for a panel button.  DO NOT change
           // this to a larger value just because larger icons may be
           // available.  The purpose of this constant is to prevent the
           // panel from wasting tons of space.  If a panel is larger than
           // this value, it will have rectangular buttons instead of square
           // buttons.  See bug #42278 for details.
           MAX_ICON_DIMENSION=KIcon::SizeLarge
    };
    
    static Kicker* kicker();

    bool isImmutable() const;
    PanelKMenu* KMenu() { return kMenu; }

    PanelPopupButton* KButton() { return kButton; }
    void setKButton(PanelPopupButton *button) { kButton = button; }

    static QStringList configModules(bool controlCenter);

    int maxButtonDim() const;
    int maxIconDim() const; 
    int iconMargin(int iconDim) const;
    bool conserveSpace() const; 

public slots:
    void slotLaunchConfig();
    void slotLaunchConfig(const QString& configPath);

signals:
    void configurationChanged();

private slots:
    void slotSettingsChanged( int );
    void slotKMenuAccel();
    void slotDesktopAccel();
    void slotRestart();
    void slotSetKMenuItemActive();
    void slotDesktopResized();

private:
    PanelKMenu*    kMenu;
    KGlobalAccel*  keys;
    QString        m_panelConfiged;
    PanelPopupButton* kButton;
};

#endif
