/* Copyright (C) EPSON SOFTWARE DEVELOPMENT LABORATORY 1999, 2000, 2001, 2002
                            Maintenance by EPSON KOWA

   Ghostscript printer driver for EPSON ESC/Page-Color

   This software is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility
   to anyone for the consequences of using it or for whether it serves any
   particular purpose or works at all, unless he says so in writing.  Refer
   to the GNU General Public License for full details.

   Everyone is granted permission to copy, modify and redistribute
   this software, but only under the conditions described in the GNU
   General Public License.  A copy of this license is supposed to have been
   given to you along with this software so you can know your rights and
   responsibilities.  It should be in a file named COPYING.  Among other
   things, the copyright notice and this notice must be preserved on all
   copies.
 */

/*$Id: gdevescv.c,v 1.4 2002/07/30 18:53:21 easysw Exp $ */
/* Vector Version of ESC/Page-Color driver */

/*
ռ
    ܥɥ饤Фκˤꡢgdevlips( 翹ͤ)򻲹ͤˤ
    ĺޤ
*/
/*
   Ghostscript 5.10/5.50 ΥХˤĤ

   Ghostscript 5.10/5.50  Vector driver  setlinewidth ؿˤ
   Хޤ襹뤬ѹˤäѹ
   ʤФʤޤ󤬡Ghostscript 5.10/5.50 ǤϥθΤ
   ˺Ƥޤ
   Υɥ饤ФϤΥХ򤹤뤿˥ʬǽƤޤ

 */

#include <stdlib.h>
#include <unistd.h>

#include "math_.h"
#include "gx.h"
#include "gserrors.h"
#include "gsmatrix.h"
#include "gsparam.h"
#include "gxdevice.h"
#include "gscspace.h"
#include "gsutil.h"
#include "gdevvec.h"
#if GS_VERSION_MAJOR == 5
#include "gdevpstr.h"
#endif
#include "ghost.h"
#include "gzstate.h"
#include "imemory.h"
#include "igstate.h"
#include "gdevescv.h"
#include "gspath.h"
#include "gzpath.h"

/* ---------------- Device definition ---------------- */

/* Device procedures */
private dev_proc_open_device(escv_open);
private dev_proc_output_page(escv_output_page);
private dev_proc_close_device(escv_close);
private dev_proc_copy_mono(escv_copy_mono);
private dev_proc_copy_color(escv_copy_color);
private dev_proc_put_params(escv_put_params);
private dev_proc_get_params(escv_get_params);
private dev_proc_fill_mask(escv_fill_mask);
private dev_proc_begin_image(escv_begin_image);


#define	X_DPI		600
#define	Y_DPI		600
#define	VCACHE		0x3FF

typedef struct gx_device_escv_s {
    gx_device_vector_common;

    bool		manualFeed;			/* Use manual feed */ 
    int			cassetFeed;			/* Input Casset */ 
    bool		RITOff;				/* RIT Control */
    bool		Collate;			/*  */
    int			toner_density;			/* ȥʡǻ */
    bool		toner_saving;			/* ȥʡ */
    int			prev_paper_size;
    int			prev_paper_width;
    int			prev_paper_height;
    int			prev_num_copies;		/* */
    int			prev_feed_mode;
    int			orientation;			/*  */
    bool		faceup;				/* ե */
    char		MediaType;			/*  */

    bool		first_page;
    bool		Duplex;				/* ξ̰ */
    bool		Tumble;				/* Ȥ */
    int			ncomp;				/* */
    int			MaskReverse;			/* ȿž */
    int			MaskState;			/* */
    bool		c4map;				/* 4bit ColorMap */
    bool		c8map;				/* 8bit ColorMap */
    int			prev_x;
    int			prev_y;
    gx_color_index	prev_color;
    gx_color_index	current_color;			/* Current Color */

    /* for Font Downloading */
    gx_bitmap_id	id_cache[VCACHE + 1];

    floatp		lwidth;
    long		cap;
    long		join;
    long		reverse_x;
    long		reverse_y;
    gs_matrix		xmat;
    int			bx, by;
    int			w, h;
    int			roll;
    float		sx, sy;
    long		dd;
} gx_device_escv;


gs_public_st_suffix_add0_final(st_device_escv, gx_device_escv,
      "gx_device_escv", device_escv_enum_ptrs, device_escv_reloc_ptrs,
			       gx_device_finalize, st_device_vector);

/*
** ͤ 0 Ȥ,׻꤫襨ꥢ
**  0.001 ȤƤ
*/
#define escv_device_full_body(dtype, pprocs, dname, stype, w, h, xdpi, ydpi, \
			      ncomp, depth, mg, mc, dg, dc, lm, bm, rm, tm)\
        std_device_part1_(dtype, pprocs, dname, stype, open_init_closed),\
        dci_values(ncomp, depth, mg, mc, dg, dc),\
        std_device_part2_(w, h, xdpi, ydpi),\
	offset_margin_values(0.001, 0.001, lm, 0, 0, tm), \
        std_device_part3_()


#define escv_device_body(name)	\
  escv_device_full_body(gx_device_escv, 0, name, \
				&st_device_escv,\
/* width & height */		ESCPAGE_DEFAULT_WIDTH, ESCPAGE_DEFAULT_HEIGHT,\
/* default resolution */	X_DPI, Y_DPI,\
/* color info */		3, 24, 255, 255, 256, 256,\
				ESCPAGE_LEFT_MARGIN_DEFAULT,\
				ESCPAGE_BOTTOM_MARGIN_DEFAULT,\
				ESCPAGE_RIGHT_MARGIN_DEFAULT,\
				ESCPAGE_TOP_MARGIN_DEFAULT)


#define escv_procs	\
{\
	escv_open,				/* open_device */\
	gx_default_get_initial_matrix,		/* get_initial_matrix */\
	NULL,					/* sync_output */\
	escv_output_page,			/* output_page */\
	escv_close,				/* close_device */\
	gx_default_rgb_map_rgb_color,		/* map_rgb_color */\
        gx_default_rgb_map_color_rgb,		/* map_color_rgb */\
	gdev_vector_fill_rectangle,		/* fill_rectangle */\
	NULL,					/* tile_rectangle */\
	escv_copy_mono,				/* dev_t_proc_copy_mono */\
	escv_copy_color,			/* dev_t_proc_copy_color */\
	NULL,					/* draw_line */\
	NULL,					/* get_bits */\
	escv_get_params,			/* dev_t_proc_get_params */\
	escv_put_params,			/* dev_t_proc_put_params */\
	NULL,					/* map_cmyk_color */\
	NULL,					/* get_xfont_procs */\
	NULL,					/* get_xfont_device */\
	NULL,					/* map_rgb_alpha_color */\
	gx_page_device_get_page_device,		/* dev_t_proc_get_page_device */\
	NULL,					/* get_alpha_bits */\
	NULL,					/* copy_alpha */\
	NULL,					/* get_band */\
	NULL,					/* copy_rop */\
	gdev_vector_fill_path,			/* fill_path */\
	gdev_vector_stroke_path,		/* stroke_path */\
	escv_fill_mask,				/* fill_mask */\
	gdev_vector_fill_trapezoid,		/* fill_trapezoid */\
	gdev_vector_fill_parallelogram,		/* fill_parallelogram */\
	gdev_vector_fill_triangle,		/* fill_triangle */\
	NULL,	/****** WRONG ******/		/* draw_thin_line */\
	escv_begin_image,			/* begin_image */\
	NULL,					/* image_data */\
	NULL,					/* end_image */\
	NULL,					/* strip_tile_rectangle */\
	NULL					/******strip_copy_rop******/\
}


#define	escv_init_code			\
    vector_initial_values,\
    ESCPAGE_MANUALFEED_DEFAULT,\
    ESCPAGE_CASSETFEED_DEFAULT,\
    ESCPAGE_RIT_DEFAULT,		/* RIT */\
    FALSE,				/* Collate */\
    0,					/* toner_density */\
    FALSE,				/* toner_saving */\
    0, 0, 0, 0, -1,\
    0,					/* orientation */\
    ESCPAGE_FACEUP_DEFAULT,\
    ESCPAGE_MEDIATYPE_DEFAULT,\
    0,					/* first_page */\
    0,					/* Duplex */\
    ESCPAGE_TUMBLE_DEFAULT,\
    0,					/* ncomp */\
    0,					/* MaskReverse */\
    0,					/* MaskState */\
    TRUE,				/* 4bits Color Map */\
    TRUE,				/* 8bits Color Map */\
    0,					/* prev_x */\
    0,					/* prev_y */\
    0,					/* prev_color */\
    0,					/* current_color */\
    {0},				/* id_cache */\
    3,					/* lwidth */\
    0,					/* cap */\
    3,					/* join */\
    0,0,				/* reverse x, y */\
    {0,0,0,0,0,0},			/* matrix */\
    0,0,				/* x, y */\
    0,0,				/* width, hight */\
    0,					/* roll */\
    0,0,				/* scale x, y */\
    0					/* */


gx_device_escv far_data gs_lp8000c_device =
{
    escv_device_body("lp8000c"),
    escv_procs,
    escv_init_code
};


gx_device_escv far_data gs_lp8200c_device =
{
    escv_device_body("lp8200c"),
    escv_procs,
    escv_init_code
};

gx_device_escv far_data gs_lp8300c_device =
{
    escv_device_body("lp8300c"),
    escv_procs,
    escv_init_code
};

gx_device_escv far_data gs_lp8500c_device =
{
    escv_device_body("lp8500c"),
    escv_procs,
    escv_init_code
};

gx_device_escv far_data gs_lp8800c_device =
{
    escv_device_body("lp8800c"),
    escv_procs,
    escv_init_code
};

gx_device_escv far_data gs_lp3000c_device =
{
    escv_device_body("lp3000c"),
    escv_procs,
    escv_init_code
};

gx_device_escv far_data gs_alc8600_device =
{
    escv_device_body("alc8600"),
    escv_procs,
    escv_init_code
};

gx_device_escv far_data gs_alc8500_device =
{
    escv_device_body("alc8500"),
    escv_procs,
    escv_init_code
};

gx_device_escv far_data gs_alc2000_device =
{
    escv_device_body("alc2000"),
    escv_procs,
    escv_init_code
};

gx_device_escv far_data gs_alc4000_device =
{
    escv_device_body("alc4000"),
    escv_procs,
    escv_init_code
};

/* Vector device implementation */
private int escv_beginpage(P1(gx_device_vector * vdev));
private int escv_setfillcolor(P2(gx_device_vector * vdev, const gx_drawing_color * pdc));
private int escv_setstrokecolor(P2(gx_device_vector * vdev, const gx_drawing_color * pdc));
private int escv_setdash(P4(gx_device_vector * vdev, const float *pattern, 
			      uint count, floatp offset));
private int escv_setflat(P2(gx_device_vector * vdev, floatp flatness));
private int escv_setlogop(P3(gx_device_vector * vdev, gs_logical_operation_t lop, 
			       gs_logical_operation_t diff));
private int escv_vector_dorect(gx_device_vector * vdev, fixed x0, fixed y0, fixed x1,
			       fixed y1, gx_path_type_t type);
private int escv_vector_dopath(gx_device_vector * vdev, const gx_path * ppath,
			       gx_path_type_t type);
private int escv_beginpath(P2(gx_device_vector * vdev, gx_path_type_t type));
private int escv_moveto(P6(gx_device_vector * vdev, floatp x0, floatp y0,
			   floatp x, floatp y, gx_path_type_t type));
private int escv_lineto(P6(gx_device_vector * vdev, floatp x0, floatp y0,
			   floatp x, floatp y, gx_path_type_t type));
private int escv_curveto(P10(gx_device_vector * vdev, floatp x0, floatp y0,
			       floatp x1, floatp y1, floatp x2, floatp y2,
			       floatp x3, floatp y3, gx_path_type_t type));
private int escv_closepath(P6(gx_device_vector * vdev, floatp x, floatp y,
				floatp x_start, floatp y_start, gx_path_type_t type));

private int escv_endpath(P2(gx_device_vector * vdev, gx_path_type_t type));
private int escv_setlinewidth(gx_device_vector * vdev, floatp width);
private int escv_setlinecap(gx_device_vector * vdev, gs_line_cap cap);
private int escv_setlinejoin(gx_device_vector * vdev, gs_line_join join);
private int escv_setmiterlimit(gx_device_vector * vdev, floatp limit);

private void escv_write_begin(gx_device *, int, int, int, int, int, int, int, int);
private void escv_write_data(gx_device *, int, char *, int, int, int);
private void escv_write_end(gx_device *, int);


private const gx_device_vector_procs escv_vector_procs =
{
	/* Page management */
    escv_beginpage,
	/* Imager state */
    escv_setlinewidth,
    escv_setlinecap,
    escv_setlinejoin,
    escv_setmiterlimit,
    escv_setdash,
    escv_setflat,
    escv_setlogop,
	/* Other state */
    escv_setfillcolor,	/* fill & stroke colors are the same */
    escv_setstrokecolor,
	/* Paths */
    escv_vector_dopath,
    escv_vector_dorect,
    escv_beginpath,
    escv_moveto,
    escv_lineto,
    escv_curveto,
    escv_closepath,
    escv_endpath
};

/* ---------------- Utilities ---------------- */

/* Put a string on a stream.
   This function is copy of `pputs' in gdevpstr.c */
private int
lputs(stream * s, const char *str)
{
    uint	len = strlen(str);
    uint	used;
    int		status;

    status = sputs(s, (const byte *)str, len, &used);

    return (status >= 0 && used == len ? 0 : EOF);
}

/* Write a string on a stream. */
private void
put_bytes(stream * s, const byte * data, uint count)
{
    uint used;

    sputs(s, data, count, &used);
}


private int
escv_range_check(gx_device * dev)
{
    int width = dev->MediaSize[0];
    int height = dev->MediaSize[1];
    int xdpi = dev->x_pixels_per_inch;
    int ydpi = dev->y_pixels_per_inch;

    /* Paper Size Check */
    if (width <= height) {	/* portrait */
	if ((width < ESCPAGE_WIDTH_MIN || width > ESCPAGE_WIDTH_MAX ||
	     height < ESCPAGE_HEIGHT_MIN || height > ESCPAGE_HEIGHT_MAX) &&
	    !(width == ESCPAGE_LEDGER_WIDTH && height == ESCPAGE_LEDGER_HEIGHT))
	    return_error(gs_error_rangecheck);
    } else {			/* landscape */
	if ((width < ESCPAGE_HEIGHT_MIN || width > ESCPAGE_HEIGHT_MAX ||
	     height < ESCPAGE_WIDTH_MIN || height > ESCPAGE_WIDTH_MAX) &&
	    !(width == ESCPAGE_LEDGER_HEIGHT && height == ESCPAGE_LEDGER_WIDTH))
	    return_error(gs_error_rangecheck);
    }

    /* Resolution Check */
    if (xdpi != ydpi)
	return_error(gs_error_rangecheck);
    else {
	if ((xdpi < ESCPAGE_DPI_MIN || xdpi > ESCPAGE_DPI_MAX) && xdpi != ESCPAGE_DPI_SUPERFINE)
	    return_error(gs_error_rangecheck);
    }

    return 0;
}


/* ---------------- Vector device implementation ---------------- */

int
escv_vector_dopath(gx_device_vector * vdev, const gx_path * ppath,
		   gx_path_type_t type)
{
    bool do_close = (type & gx_path_type_stroke) != 0;
    gs_fixed_rect rect;
    gs_point scale;
    double x_start = 0, y_start = 0, x_prev = 0, y_prev = 0;
    bool first = true;
    gs_path_enum cenum;
    int code;

    stream	*s = gdev_vector_stream(vdev);
    char	obuf[128];

    if (gx_path_is_rectangle(ppath, &rect))
	return (*vdev_proc(vdev, dorect)) (vdev, rect.p.x, rect.p.y, rect.q.x, rect.q.y, type);
    scale = vdev->scale;
    code = (*vdev_proc(vdev, beginpath)) (vdev, type);
    gx_path_enum_init(&cenum, ppath);

    for (;;) {
	double	x, y;
	fixed	vs[6];
	int	pe_op, cnt;
	segment *pseg;


	pe_op = gx_path_enum_next(&cenum, (gs_fixed_point *) vs);

      sw:switch (pe_op) {
	    case 0:		/* done */
		return (*vdev_proc(vdev, endpath)) (vdev, type);

	    case gs_pe_moveto:
		x = fixed2float(vs[0]) / scale.x;
		y = fixed2float(vs[1]) / scale.y;

		/* ֥ѥ̿ p1 */
		(void)sprintf(obuf, ESC_GS "0;%d;%dmvpG", (int)x, (int)y);
		lputs(s, obuf);

		if (first)
		    x_start = x, y_start = y, first = false;
		break;

	    case gs_pe_lineto:
		cnt = 1;
		for (pseg = cenum.pseg; pseg != 0 && pseg->type == s_line; cnt++, pseg = pseg->next);

		(void)sprintf(obuf, ESC_GS "0;%d", cnt);
		lputs(s, obuf);

		do {
		    (void)sprintf(obuf, ";%d;%d", (int)(fixed2float(vs[0]) / scale.x), (int)(fixed2float(vs[1]) / scale.y));
		    lputs(s, obuf);

		    pe_op = gx_path_enum_next(&cenum, (gs_fixed_point *) vs);
		} while (pe_op == gs_pe_lineto);

		/* ѥݥ饤̿ */
		lputs(s, "lnpG");

		goto sw;

	    case gs_pe_curveto:
		cnt = 1;
		for (pseg = cenum.pseg; pseg != 0 && pseg->type == s_curve; cnt++, pseg = pseg->next);
		(void)sprintf(obuf, ESC_GS "0;%d", cnt * 3);
		lputs(s, obuf);

		do {
		    (void)sprintf(obuf, ";%d;%d;%d;%d;%d;%d",
				  (int)(fixed2float(vs[0]) / scale.x), (int)(fixed2float(vs[1]) / scale.y),
				  (int)(fixed2float(vs[2]) / scale.x), (int)(fixed2float(vs[3]) / scale.y),
				  (int)(fixed2float(vs[4]) / scale.x), (int)(fixed2float(vs[5]) / scale.y));
		    lputs(s, obuf);

		    pe_op = gx_path_enum_next(&cenum, (gs_fixed_point *) vs);
		} while (pe_op == gs_pe_curveto);

		/* ٥ */
		lputs(s, "bzpG");

		goto sw;

	    case gs_pe_closepath:
		x = x_start, y = y_start;
		if (do_close) {
		    lputs(s, ESC_GS "clpG");
		    break;
		}

		pe_op = gx_path_enum_next(&cenum, (gs_fixed_point *) vs);
		if (pe_op != 0) {
		    lputs(s, ESC_GS "clpG");

		    if (code < 0)
			return code;
		    goto sw;
		}
		return (*vdev_proc(vdev, endpath)) (vdev, type);
	    default:		/* can't happen */
		return_error(gs_error_unknownerror);
	}
	if (code < 0)
	    return code;
	x_prev = x, y_prev = y;
    }
}


int
escv_vector_dorect(gx_device_vector * vdev, fixed x0, fixed y0, fixed x1,
		   fixed y1, gx_path_type_t type)
{
    int		code;
    char	obuf[128];
    gs_point	scale;
    stream	*s = gdev_vector_stream(vdev);

    code = (*vdev_proc(vdev, beginpath))(vdev, type);
    if (code < 0)
	return code;

    scale = vdev->scale;

    (void)sprintf(obuf, ESC_GS "0;%d;%d;%d;%d;0;0rrpG", (int)(fixed2float(x0) / scale.x), (int)(fixed2float(y0) / scale.y), (int)(fixed2float(x1) / scale.x), (int)(fixed2float(y1) / scale.y));
    lputs(s, obuf);

#if 0
    /* Ghostscript ¦ΥХ closepath ƤǤʤΤǽ碌롣 */

    /*  (*vdev_proc(vdev, closepath))() Ƥ֤٤ */
    lputs(s, ESC_GS "clpG");
#endif

    return (*vdev_proc(vdev, endpath))(vdev, type);
}


/* ---------- */


typedef struct {
    int		width;			/* paper width (unit: point) */
    int		height;			/* paper height (unit: point) */
    int		escpage;		/* number of papersize in ESC/PAGE */
    char	*name;			/* Paper Name */
} EPaperTable;

private const EPaperTable ePaperTable[21] =
{
    {933, 1369, 72, "A3PLUS"},		/*A3 NOBI */
    {842, 1190, 13, "A3"},		/* A3 */
    {595, 842, 14, "A4"},		/* A4 */
    {421, 595, 15, "A5"},		/* A5 */
    {709, 1002, 24, "B4"},		/* B4 */
    {501, 709, 25, "B5"},		/* B5 */
    {612, 792, 30, "LT"},		/* Letter */
    {396, 612, 31, "HLT"},		/* Half Letter */
    {612, 1008, 32, "LGL"},		/* Legal */
    {522, 756, 33, "EXE"},		/*Executive */
    {612, 936, 34, "GLG"},		/*Government Legal */
    {576, 756, 35, "GLT"},		/*Government Letter */
    {792, 1224, 36, "B"},		/* Ledger */
    {593, 935, 37, "F4"},		/*F4 */
    {284, 419, 38, "POSTCARD"},		/*PostCard */
    {279, 540, 80, "MON"},		/*Monarch */
    {297, 684, 81, "C10"},		/*Commercial 10 */
    {312, 624, 90, "DL"},		/*DL */
    {298, 666, 64, "YOU4"},             /*Envelope */
    {0, 0, -1, NULL}			/*Undefined */
};

private int

escv_beginpage(gx_device_vector * vdev)
{
    gx_device_escv	*const pdev = (gx_device_escv *)vdev;
    /* gdev_vector_stream ϻѶػ */
    stream		*s = vdev->strm;
    char		ebuf[1024];
    int			w, h;
    EPaperTable		*pt;
    int                 MaxRes;
    int                 Local;
    int                 Duplex;
    int                 FaceUp;

    if (pdev -> first_page) {

	if (strcmp(pdev->dname, "lp8000c") == 0 || \
	    strcmp(pdev->dname, "lp8200c")  == 0 ) {
	    MaxRes = RES600;
	    Local  = JPN;
	    Duplex = FALSE;
	    FaceUp = TRUE;
	} else if (strcmp(pdev->dname, "lp8300c") == 0 || \
	    strcmp(pdev->dname, "lp8500c")  == 0 || \
	    strcmp(pdev->dname, "lp8800c")  == 0 ) {
	    MaxRes = RES600;
	    Local  = JPN;
	    Duplex = TRUE;
	    FaceUp = TRUE;
	} else if (strcmp(pdev->dname, "lp3000c") == 0) {
	    MaxRes = RES600;
	    Local  = JPN;
	    Duplex = TRUE;
	    FaceUp = FALSE;
	} else if (strcmp(pdev->dname, "alc8500") == 0 || \
	    strcmp(pdev->dname, "alc8600")  == 0 ) {
	    MaxRes = RES600;
	    Local  = ENG;
	    Duplex = TRUE;
	    FaceUp = TRUE;
	} else if (strcmp(pdev->dname, "alc2000") == 0) {
	    MaxRes = RES600;
	    Local  = ENG;
	    Duplex = TRUE;
	    FaceUp = FALSE;
	} else if (strcmp(pdev->dname, "alc4000") == 0) {
	    MaxRes = RES1200;
	    Local  = ENG;
	    Duplex = TRUE;
	    FaceUp = FALSE;
	} else {
	    MaxRes = RES600;
	    Local  = JPN;
	    Duplex = FALSE;
	    FaceUp = FALSE;
	}

	lputs(s, "\033\001@EJL \012@EJL SJ ID=\"Ghostscript\"\012");
	lputs(s, "@EJL SE LA=ESC/PAGE\012");
	lputs(s, "@EJL SET");
	/* Resolusion */
	if (vdev->x_pixels_per_inch == 1200){
	    if (MaxRes == 1200){
	    	lputs(s, " RS=1200");
	    } else {
	    	lputs(s, " RS=FN");
	    }
	} else if (vdev->x_pixels_per_inch == 600) {
	    lputs(s, " RS=FN");
	} else {
	    lputs(s, " RS=QK");
	}

	/* Output Unit */
	if ((pdev->faceup && FaceUp) || (pdev->MediaType && FaceUp)) {
	    lputs(s, " OU=FU");
	} else {
	    lputs(s, " OU=FD");
	}

	/* Paper unit */
        if (pdev->MediaType){
	    if (Local == ENG){
		lputs(s, " PU=1");
	    } else {
		lputs(s, " PU=15");
	    }
	}else{
	    if (pdev->manualFeed) {
		if (Local == ENG){
		    lputs(s, " PU=1");
		} else {
	            lputs(s, " PU=15");
		}
	    } else if (pdev->cassetFeed) {
	        (void)sprintf(ebuf, " PU=%d", pdev->cassetFeed);
	        lputs(s, ebuf);
	    } else {
	        lputs(s, " PU=AU");
	    }
	}

	if (Duplex && pdev->Duplex) {
	    /* ξ̰ */
	    lputs(s, " DX=ON");

	    /* Ȥ */
	    if (pdev->Tumble) {
		lputs(s, " BD=SE");
	    } else {
		lputs(s, " BD=LE");
	    }
	}

	/*  */
	if (pdev->NumCopies) {
	    if (pdev->NumCopies >= 1000) {
		pdev->NumCopies = 999;
	    }

	    /* lp8000c Ǥ QT Ȥʤ */
	    if (strcmp(pdev->dname, "lp8000c") == 0) {
		(void)sprintf(ebuf, " QT=1 CO=%d", pdev->NumCopies);
	    } else {
                if (pdev->Collate) {
		    /* QT ꤷ CO  1 */
		    (void)sprintf(ebuf, " QT=%d CO=1", pdev->NumCopies);
	        } else {
		    /* QT ꤷʤä QT  1 */
		    (void)sprintf(ebuf, " QT=1 CO=%d", pdev->NumCopies);
		}
	    }
	    lputs(s, ebuf);
	} else {
	    lputs(s, " QT=1 CO=1");
	}

	if (pdev->toner_density) {
	    (void)sprintf(ebuf, " DL=%d", pdev->toner_density);
	    lputs(s, ebuf);
	}

	if (pdev->orientation) {
	    lputs(s, " OR=LA");
	}

	if (pdev->toner_saving) {
	    lputs(s, " SN=ON");
	}

	if (pdev->RITOff) {
	    lputs(s, " RI=OFF");
	} else {
	    lputs(s, " RI=ON");
	}

	if (pdev->MediaType == 1) {
	    lputs(s, " PK=TH");
	} else if (pdev->MediaType == 2) {
	    lputs(s, " PK=TR");
	} else {
	    lputs(s, " PK=NM");
	}

	if (pdev->MediaSize[0] < pdev->MediaSize[1]) {
	    w = pdev->MediaSize[0];
	    h = pdev->MediaSize[1];
	} else {
	    w = pdev->MediaSize[1];
	    h = pdev->MediaSize[0];
	}

	for (pt = ePaperTable; pt->escpage > 0; pt++)
	    if (pt->width == w && pt->height == h)
		break;
	if (pt->name == NULL) {
	    lputs(s, " PS=A4");
	} else {
	    (void)sprintf(ebuf, " PS=%s", pt->name);
	    lputs(s, ebuf);
	}

	lputs(s, " ZO=OFF EC=ON SZ=OFF SL=YES TO=0 LO=0\012");
	lputs(s, "@EJL EN LA=ESC/PAGE-COLOR\012");

#define	START_CODE1	ESC_GS "1tsE" ESC_GS "0alfP" ESC_GS "0affP" ESC_GS "0;0;0clfP" ESC_GS "0pmP" ESC_GS "1024ibI" ESC_GS "2cmE" ESC_GS "0bcI" ESC_GS "1;10mlG"

#define	LP8000_CODE	ESC_GS "0pddO" ESC_GS "0;0mmE" ESC_GS "2csE" ESC_GS "0;1;3cmmE" ESC_GS "0;1raE" ESC_GS "0;2;4ccmE"

#define	LP8200_CODE	ESC_GS "0pddO" ESC_GS "0;0cmmE" ESC_GS "1;2;3ccmE" ESC_GS "2;2;3ccmE" ESC_GS "3;2;4ccmE" ESC_GS "1;1raE" ESC_GS "2;1raE" ESC_GS "3;1raE"

	lputs(s, ESC_GS "rhE");

	if (strcmp(vdev -> dname, "lp8000c") == 0) {
	    lputs(s, LP8000_CODE);
	} else {
	    lputs(s, LP8200_CODE);
	}

#if 1	/* default */
	put_bytes(s, ESC_GS "7;0;2;0cam{E\012\000\000\000\000\000\000", 20);
	lputs(s, ESC_GS "0;0cmmE" ESC_GS "0;0loE");
#else	
	put_bytes(s, ESC_GS "7;0;2;3cam{E\012\000\000\000\000\000\000", 20);
	lputs(s, ESC_GS "1cmmE" ESC_GS "0;0loE");
#endif
        if (vdev->x_pixels_per_inch == 1200) {
            /* 1200 dpi */
            lputs(s, ESC_GS "0;0.06muE");
            lputs(s, ESC_GS "3;1200;1200drE" ESC_GS "2;1200;1200drE" ESC_GS "1;1200;1200drE" ESC_GS "0;1200;1200drE");
        } else if (vdev->x_pixels_per_inch == 600) {
	    /* 600 dpi */
	    lputs(s, ESC_GS "0;0.12muE");
	    lputs(s, ESC_GS "3;600;600drE" ESC_GS "2;600;600drE" ESC_GS "1;600;600drE" ESC_GS "0;600;600drE");
	} else {
	    /* 300 dpi */
	    lputs(s, ESC_GS "0;0.24muE");
	    lputs(s, ESC_GS "3;300;300drE" ESC_GS "2;300;300drE" ESC_GS "1;300;300drE" ESC_GS "0;300;300drE");
	}

	lputs(s, START_CODE1);
	lputs(s, ESC_GS "8;1;2;2;2plr{E");
	put_bytes(s, "\377\377\377\377\000\000\000\000", 8);

	lputs(s, ESC_GS "0sarG");		/* кɸ */
	lputs(s, ESC_GS "2;204wfE");		/* rop  */
    }
    
    return 0;
}


private int
escv_setlinewidth(gx_device_vector * vdev, floatp width)
{
    stream			*s = gdev_vector_stream(vdev);
    gx_device_escv *const	pdev = (gx_device_escv *) vdev;
    char			obuf[64];

#if GS_VERSION_MAJOR == 5
    /* Scale ݤƤΤ, Ghostscript 5.10/5.50 ΥХΤ */
    floatp xscale, yscale;

    xscale = fabs(igs->ctm.xx);
    yscale = fabs(igs->ctm.xy);

    if (xscale == 0 || yscale > xscale)		/* if portrait */
	width = ceil(width * yscale);
    else
	width = ceil(width * xscale);
#endif

    if (width < 1) width = 1;

    /* ESC/Page ǤüܹϣĤΥޥɤˤʤäƤ뤿ݻƤ */
    pdev -> lwidth = width;

    (void)sprintf(obuf, ESC_GS "%d;%d;%dlwG", (int)(pdev -> lwidth), (int)(pdev -> cap), (int)(pdev -> join));
    lputs(s, obuf);

    return 0;
}


private int
escv_setlinecap(gx_device_vector * vdev, gs_line_cap cap)
{
    stream			*s = gdev_vector_stream(vdev);
    gx_device_escv *const	pdev = (gx_device_escv *) vdev;
    char			obuf[64];

    /* ESC/Page ǤüܹϣĤΥޥɤˤʤäƤ뤿ݻƤ */
    pdev -> cap = cap;

    if (pdev -> cap >= 3) return -1;

    (void)sprintf(obuf, ESC_GS "%d;%d;%dlwG", (int)(pdev -> lwidth), (int)(pdev -> cap), (int)(pdev -> join));
    lputs(s, obuf);

    return 0;
}


private int
escv_setlinejoin(gx_device_vector * vdev, gs_line_join join)
{
    stream			*s = gdev_vector_stream(vdev);
    gx_device_escv *const	pdev = (gx_device_escv *) vdev;
    char			obuf[64];

    /* ESC/Page ǤüܹϣĤΥޥɤˤʤäƤ뤿ݻƤ */
    switch (join) {
    case 0:
	pdev -> join = 3;		/* miter */
	break;
    case 1:
	pdev -> join = 1;		/* round */
	break;
    case 2:
	pdev -> join = 2;		/* bevel */
	break;
    default:
	return -1;
    }

    (void)sprintf(obuf, ESC_GS "%d;%d;%dlwG", (int)(pdev -> lwidth), (int)(pdev -> cap), (int)(pdev -> join));
    lputs(s, obuf);

    return 0;
}


private int
escv_setmiterlimit(gx_device_vector * vdev, floatp limit)
{
    stream			*s = gdev_vector_stream(vdev);
    gx_device_escv *const	pdev = (gx_device_escv *) vdev;
    char			obuf[128];

    /* ޥߥåͤꤹˤ lwG ˤ ܹ(n3)  3 ˤʤäƤ
    ** ɬפ롣
    */
    if (pdev -> join != 3) {
	/* ŪܹԤ */
	pdev -> join = 3;
	(void)sprintf(obuf, ESC_GS "%d;%d;%dlwG", (int)(pdev -> lwidth), (int)(pdev -> cap), (int)(pdev -> join));
	lputs(s, obuf);
    }

    (void)sprintf(obuf, ESC_GS "1;%dmlG", (int)limit);
    lputs(s, obuf);

    return 0;
}


private int
escv_setfillcolor(gx_device_vector * vdev, const gx_drawing_color * pdc)
{
    stream			*s = gdev_vector_stream(vdev);
    gx_device_escv *const	pdev = (gx_device_escv *) vdev;
    gx_color_index		color = gx_dc_pure_color(pdc);
    char			obuf[64];

    if (!gx_dc_is_pure(pdc)) return_error(gs_error_rangecheck);
    pdev->current_color = color;

    /* ѥϣλ꡿åɥѥ */
    (void)sprintf(obuf, ESC_GS "1;2;3;%d;%d;%dfpE",
		  (unsigned char)(color >> 16 & 0xff),
		  (unsigned char)(color >> 8 & 0xff),
		  (unsigned char)(color & 0xff));
    lputs(s, obuf);
    lputs(s, ESC_GS "3;2;1;0;0cpE" ESC_GS "1;2;1;0;0cpE" ESC_GS "5;2;1;0;0cpE");

    return 0;
}


private int
escv_setstrokecolor(gx_device_vector * vdev, const gx_drawing_color * pdc)
{
    stream			*s = gdev_vector_stream(vdev);
    gx_device_escv *const	pdev = (gx_device_escv *) vdev;
    gx_color_index		color = gx_dc_pure_color(pdc);
    char			obuf[64];

    if (!gx_dc_is_pure(pdc)) return_error(gs_error_rangecheck);

    if (vdev->color_info.depth == 24) {

	pdev->current_color = color;
	/* ѥϣο꡿åɥѥ */
	(void)sprintf(obuf, ESC_GS "1;2;3;%d;%d;%dfpE" ESC_GS "2;2;1;0;0cpE",
		      (unsigned char)(color >> 16 & 0xff),
		      (unsigned char)(color >> 8 & 0xff),
		      (unsigned char)(color & 0xff));
	lputs(s, obuf);

    }
    return 0;
}


/* ̿ */
private int
escv_setdash(gx_device_vector * vdev, const float *pattern, uint count, floatp offset)
{
    stream			*s = gdev_vector_stream(vdev);
    int				i;
    char			obuf[64];

#if GS_VERSION_MAJOR == 5
    float			scale, xscale, yscale;
    /* Scale ݤƤΤ, Ghostscript 5.10/5.50 ΥХΤ */
    xscale = fabs(igs->ctm.xx);
    yscale = fabs(igs->ctm.xy);

    if (xscale == 0)		/* if portrait */
	scale = yscale;
    else
	scale = xscale;
#endif

    if (count == 0){
	/*  */
	lputs(s, ESC_GS "0;0lpG");
	return 0;
    }
    
    /* offset ʳξԲĤȤֵ */
    if (offset != 0) return -1;

    if (count) {
	if (count == 1) {
#if GS_VERSION_MAJOR == 5
	    (void)sprintf(obuf, ESC_GS "1;%d;%ddlG", 
			  (int)(pattern[0] * scale / vdev->x_pixels_per_inch + 0.5),
			  (int)(pattern[0] * scale / vdev->x_pixels_per_inch + 0.5));
#else
	    (void)sprintf(obuf, ESC_GS "1;%d;%ddlG", pattern[0], pattern[0]);
#endif
	    lputs(s, obuf);
	} else {
	    /* pattern ˣäԲĤȤֵ */
	    for (i = 0; i < count; ++i) {
		if (pattern[i] == 0) return -1;
	    }

	    lputs(s, ESC_GS "1");
	    for (i = 0; i < count; ++i) {
#if GS_VERSION_MAJOR == 5
		(void)sprintf(obuf, ";%d", (int)(pattern[i] * scale / vdev->x_pixels_per_inch + 0.5));

#else
		(void)sprintf(obuf, ";%d", pattern[i]);
#endif
		lputs(s, obuf);
	    }
	    lputs(s, "dlG");
	}
	lputs(s, ESC_GS "1;1lpG");
    }
    return 0;
}


/* ѥʿٻ */
private int
escv_setflat(gx_device_vector * vdev, floatp flatness)
{
    return 0;
}


private int
escv_setlogop(gx_device_vector * vdev, gs_logical_operation_t lop,
		gs_logical_operation_t diff)
{
/****** SHOULD AT LEAST DETECT SET-0 & SET-1 ******/
    return 0;
}


private int
escv_beginpath(gx_device_vector * vdev, gx_path_type_t type)
{
    stream		*s = gdev_vector_stream(vdev);

    /* ѥ۳̿ */
    if (type & gx_path_type_clip) {
	lputs(s, ESC_GS "1bgpG");		/* åϿ */
    } else {
	lputs(s, ESC_GS "0bgpG");		/* Ͽ */
    }
    return 0;
}


private int
escv_moveto(gx_device_vector * vdev,
	    floatp x0, floatp y0, floatp x1, floatp y1, gx_path_type_t type)
{
    stream	*s = gdev_vector_stream(vdev);
    char	obuf[64];

    /* ֥ѥ̿ */
    (void)sprintf(obuf, ESC_GS "0;%d;%dmvpG", (int)x1, (int)y1);
    lputs(s, obuf);

    return 0;
}


private int
escv_lineto(gx_device_vector * vdev,
	    floatp x0, floatp y0, floatp x1, floatp y1, gx_path_type_t type)
{
    stream	*s = gdev_vector_stream(vdev);
    char	obuf[64];

    (void)sprintf(obuf, ESC_GS "0;1;%d;%dlnpG", (int)x1, (int)y1);
    lputs(s, obuf);

    return 0;
}


private int
escv_curveto(gx_device_vector * vdev, floatp x0, floatp y0,
	   floatp x1, floatp y1, floatp x2, floatp y2, floatp x3, floatp y3,
	       gx_path_type_t type)
{
    stream	*s = gdev_vector_stream(vdev);
    char	obuf[128];

    /* ٥ */
    (void)sprintf(obuf, ESC_GS "0;3;%d;%d;%d;%d;%d;%dbzpG",
		  (int)x1, (int)y1, (int)x2, (int)y2, (int)x3, (int)y3);
    lputs(s, obuf);

    return 0;
}


private int
escv_closepath(gx_device_vector * vdev, floatp x, floatp y,
		 floatp x_start, floatp y_start, gx_path_type_t type)
{
    stream	*s = gdev_vector_stream(vdev);

    lputs(s, ESC_GS "clpG");
    return 0;
}


private int
escv_endpath(gx_device_vector * vdev, gx_path_type_t type)
{
    stream	*s = gdev_vector_stream(vdev);

    if (type & gx_path_type_fill || type & gx_path_type_clip) {
	/* default ǽ뤬ϤƤ */
	lputs(s, ESC_GS "clpG");
    }

    /* ѥ */
    lputs(s, ESC_GS "enpG");

    /* ѥ */
    if (type & gx_path_type_clip) {

	/* å׻
	** åפˤ gx_path_type_winding_number, gx_path_type_even_odd ȽǤ
	** ɬפȻפ gs ¦ղäƤʤ 
	** Ȥꤢ gx_path_type_even_odd ǥեȤˤ롣
	*/
	lputs(s, ESC_GS "1;2capG");
    } else if (type & gx_path_type_fill) {

	/* ɤĤ֤§ */
	if (type & gx_path_type_even_odd) {
	    lputs(s, ESC_GS "0;2drpG");		/* ɤĤ֤ */
	} else {
	    lputs(s, ESC_GS "0;1drpG");		/* ɤĤ֤ */
	}
    } else {	
	lputs(s, ESC_GS "0;0drpG");		/* س */
    }

    return 0;
}

/* ---------------- Driver procedures ---------------- */

/* ------ Open/close/page ------ */

/* Open the device. */
private int
escv_open(gx_device * dev)
{
    gx_device_vector	*const vdev = (gx_device_vector *) dev;
    gx_device_escv	*const pdev = (gx_device_escv *) dev;
    int			code;
    /*    char		*error, *path;*/
    float               width, height;

    code = escv_range_check(dev);
    if (code < 0) return code;

    vdev->v_memory = dev->memory;
    /****** VERY WRONG ******/
    vdev->vec_procs = &escv_vector_procs;

    code = gdev_vector_open_file_bbox(vdev, 512, true);
    if (code < 0) return code;

    gdev_vector_init(vdev);
    pdev->first_page = true;

    if(pdev->orientation){
/*    pdev->Margins[1] = pdev->width - pdev->height + dev->HWMargins[0];
 */
      pdev->Margins[1] = (pdev->width - pdev->height) * \
      X_DPI / vdev->x_pixels_per_inch;

      width = dev->MediaSize[0];
      height  = dev->MediaSize[1];
      dev->MediaSize[0] = height;
      dev->MediaSize[1] = width;
    }

    return 0;
}


/* Wrap up ("output") a page. */
private int
escv_output_page(gx_device * dev, int num_copies, int flush)
{
    gx_device_vector *const vdev = (gx_device_vector *) dev;
    gx_device_escv *const pdev = (gx_device_escv *) dev;
    stream *s = gdev_vector_stream(vdev);

    /* ,ü,ܹƤ */
    lputs(s, ESC_GS "3;0;0lwG" ESC_GS "1;10mlG" ESC_FF);

    sflush(s);
    vdev->in_page = false;
    pdev->first_page = false;

    gdev_vector_reset(vdev);

    return 0;
}


private int
escv_close(gx_device *dev)
{
    gx_device_vector	*const vdev = (gx_device_vector *) dev;
    FILE		*f = vdev->file;

    /* λɤϷǤ */
    (void)fprintf(f, ESC_GS "rhE" "\033\001@EJL \012@EJL EJ \012\033\001@EJL \012");

    gdev_vector_close_file(vdev);

    return 0;
}

/* Close the device. */
/* Note that if this is being called as a result of finalization, */
/* the stream may no longer exist; but the file will still be open. */

/* ---------------- Get/put parameters ---------------- */

/* Get parameters. */
private int
escv_get_params(gx_device * dev, gs_param_list * plist)
{
    gx_device_escv	*const pdev = (gx_device_escv *) dev;
    int			code;
    int			ncode;

    code = gdev_vector_get_params(dev, plist);
    if (code < 0) return code;

    if ((ncode = param_write_bool(plist, ESCPAGE_OPTION_MANUALFEED, &pdev->manualFeed)) < 0)
	code = ncode;

    if ((ncode = param_write_int(plist, ESCPAGE_OPTION_CASSETFEED, &pdev->cassetFeed)) < 0)
	code = ncode;

    if ((ncode = param_write_bool(plist, ESCPAGE_OPTION_RIT, &pdev->RITOff)) < 0)
	code = ncode;

    if ((ncode = param_write_bool(plist, ESCPAGE_OPTION_COLLATE, &pdev->Collate)) < 0)
        code = ncode;

    if ((ncode = param_write_int(plist, ESCPAGE_OPTION_TONERDENSITY, &pdev->toner_density)) < 0)
        code = ncode;

    if ((ncode = param_write_bool(plist, ESCPAGE_OPTION_LANDSCAPE, &pdev->orientation)) < 0)
        code = ncode;

    if ( param_write_bool(plist, ESCPAGE_OPTION_TONERSAVING, &pdev->toner_saving)< 0)
        code = ncode;

    if ((ncode = param_write_bool(plist, ESCPAGE_OPTION_DUPLEX, &pdev->Duplex)) < 0)
	code = ncode;

    if ((ncode = param_write_bool(plist, ESCPAGE_OPTION_DUPLEX_TUMBLE, &pdev->Tumble)) < 0)
	code = ncode;

    if ((ncode = param_write_bool(plist, ESCPAGE_OPTION_FACEUP, &pdev->faceup)) < 0)
	code = ncode;

    if ((ncode = param_write_int(plist, ESCPAGE_OPTION_MEDIATYPE, &pdev->MediaType)) < 0)
	code = ncode;

    return code;
}


/* Put parameters. */
private int
escv_put_params(gx_device * dev, gs_param_list * plist)
{
    gx_device_escv	*const pdev = (gx_device_escv *) dev;
    int			ecode = 0;
    int			code;
    gs_param_name	param_name;
    gs_param_string	pmedia;
    bool		mf = pdev->manualFeed;
    int			cass = pdev->cassetFeed;
    bool		tum = pdev->Tumble;
    bool		collate = pdev->Collate;
    int			toner_density = pdev->toner_density;
    bool		toner_saving = pdev->toner_saving;
    bool		landscape = pdev->orientation;
    bool		faceup = pdev->faceup;
    bool		duplex = pdev->Duplex;
    bool		RITOff = pdev->RITOff;
    int			old_bpp = dev->color_info.depth;
    int			bpp = 0;

    if ((code = param_read_bool(plist, (param_name = ESCPAGE_OPTION_MANUALFEED), &mf)) < 0) {
	param_signal_error(plist, param_name, ecode = code);
    }
    switch (code = param_read_int(plist, (param_name = ESCPAGE_OPTION_CASSETFEED), &cass)) {
	case 0:
	    if (cass < -1 || cass > 15)
		ecode = gs_error_limitcheck;
	    else
		break;
	    goto casse;
	default:
	    ecode = code;
	  casse:param_signal_error(plist, param_name, ecode);
	case 1:
	    break;
    }

    if((code = param_read_bool(plist, (param_name = ESCPAGE_OPTION_COLLATE), &collate)) < 0) {
	param_signal_error(plist, param_name, ecode = code);
    }

    if ((code = param_read_bool(plist, (param_name = ESCPAGE_OPTION_RIT), &RITOff)) < 0) {
	param_signal_error(plist, param_name, ecode = code);
    }

    switch (code = param_read_string(plist, (param_name = ESCPAGE_OPTION_MEDIATYPE), &pmedia)) {
	case 0:
	    if (pmedia.size > ESCPAGE_MEDIACHAR_MAX)
		ecode = gs_error_limitcheck;
	    else {		/* Check the validity of ``MediaType'' characters */

		if (strcmp(pmedia.data, "TRANS") == 0) {
		    pdev->MediaType = 2;
		} else if (strcmp(pmedia.data, "THICK") == 0) {
		    pdev->MediaType = 1;
		} else {
		    ecode = gs_error_rangecheck;
		    goto pmediae;
		}
	    }
	    break;
	    goto pmediae;
	default:
	    ecode = code;
	  pmediae:param_signal_error(plist, param_name, ecode);
	case 1:
	    pdev->MediaType = 0;
	    pmedia.data = 0;
	    break;
    }

    switch (code = param_read_int(plist,
                                  (param_name = ESCPAGE_OPTION_TONERDENSITY), &toner_density)) {
    case 0:
            if (toner_density < 0 || toner_density > 5)
                ecode = gs_error_rangecheck;
            else
                break;
            goto tden;
    default:
	ecode = code;
tden:
	param_signal_error(plist, param_name, ecode);
    case 1:
	break;
    }

    switch (code = param_read_bool(plist, (param_name = ESCPAGE_OPTION_TONERSAVING), &toner_saving)) {
    case 0:
	break;
    default:
	if ((code = param_read_null(plist, param_name)) == 0) {
	    break;
	}
	ecode = code;
	param_signal_error(plist, param_name, ecode);
    case 1:
	break;   
    }

    if ((code = param_read_bool(plist, (param_name = ESCPAGE_OPTION_DUPLEX), &duplex)) < 0)
	param_signal_error(plist, param_name, ecode = code);

    if ((code = param_read_bool(plist, (param_name = ESCPAGE_OPTION_DUPLEX_TUMBLE), &tum)) < 0)
	param_signal_error(plist, param_name, ecode = code);

    if ((code = param_read_bool(plist, (param_name = ESCPAGE_OPTION_LANDSCAPE), &landscape)) < 0)
	param_signal_error(plist, param_name, ecode = code);

    if ((code = param_read_bool(plist, (param_name = ESCPAGE_OPTION_FACEUP), &faceup)) < 0) {
	param_signal_error(plist, param_name, ecode = code);
    }


    switch (code = param_read_int(plist, (param_name = "BitsPerPixel"), &bpp)) {
	case 0:
	    if (bpp != 8 && bpp != 24)
		ecode = gs_error_rangecheck;
	    else
		break;
	    goto bppe;
	default:
	    ecode = code;
	  bppe:param_signal_error(plist, param_name, ecode);
	case 1:
	    break;
    }

    if (bpp != 0) {
	dev->color_info.depth = bpp;
	dev->color_info.num_components = ((bpp == 8) ? 1 : 3);
	dev->color_info.max_gray = (bpp > 8 ? 255 : 1000);
	dev->color_info.max_color = (bpp > 8 ? 255 : 1000);
	dev->color_info.dither_grays = (bpp > 8 ? 256 : 5);
	dev->color_info.dither_colors = (bpp > 8 ? 256 : 2);
	dev_proc(pdev, map_rgb_color) = ((bpp == 8) ? gx_default_gray_map_rgb_color : gx_default_rgb_map_rgb_color);
	dev_proc(pdev, map_color_rgb) = ((bpp == 8) ? gx_default_gray_map_color_rgb : gx_default_rgb_map_color_rgb);
    }

    if (ecode < 0) return ecode;
    code = gdev_vector_put_params(dev, plist);
    if (code < 0) return code;

    pdev->manualFeed = mf;
    pdev->cassetFeed = cass;
    pdev->faceup = faceup;
    pdev->RITOff = RITOff;
    pdev->orientation = landscape;
    pdev->toner_density = toner_density;
    pdev->toner_saving = toner_saving;
    pdev->Collate = collate;
    pdev->Duplex = duplex;
    pdev->Tumble = tum;

    if (bpp != 0 && bpp != old_bpp && pdev->is_open)
	return gs_closedevice(dev);

    return 0;
}

/* ---------------- Images ---------------- */


private int
escv_copy_mono(gx_device * dev, const byte * data,
	int data_x, int raster, gx_bitmap_id id, int x, int y, int w, int h,
	   gx_color_index zero, gx_color_index one)
{
    gx_device_escv *const	pdev = (gx_device_escv *) dev;
    gx_device_vector *const	vdev = (gx_device_vector *) dev;
    stream			*s = gdev_vector_stream(vdev);
    gx_drawing_color		color;
    int				code = 0;
    gx_color_index		c_color = 0;
    char			obuf[128];
    int				depth = 1;

    if (id != gs_no_id && zero == gx_no_color_index && one != gx_no_color_index && data_x == 0) {
	gx_drawing_color dcolor;

	color_set_pure(&dcolor, one);
	escv_setfillcolor(vdev, &dcolor);
    }

    if (zero == gx_no_color_index) {

        if (one == gx_no_color_index) return 0;
	if (pdev->MaskState != 1) {
	    lputs(s, ESC_GS "2;184wfE" ESC_GS "3;184wfE" ESC_GS "5;184wfE");
            pdev->MaskState = 1;   
        }	
	c_color = one;

    } else if (one == gx_no_color_index)
	/* 1bit Ʃ ӥåȿžzero  */
    {
	if (pdev->MaskState != 1) {
	    lputs(s, ESC_GS "3;184wfE" ESC_GS "5;184wfE");
	    pdev->MaskState = 1;
	}
	c_color = zero;
    } else if (one == vdev->white) {

	if (pdev->MaskState != 0) {
	    lputs(s, ESC_GS "3;204wfE" ESC_GS "5;204wfE");
	    pdev->MaskState = 0;
	}
	c_color = zero;
    } else {

        if (pdev->MaskState != 1) {
	    lputs(s, ESC_GS "3;184wfE" ESC_GS "5;184wfE");
            pdev->MaskState = 1;
        }
	color_set_pure(&color, one);
	code = gdev_vector_update_fill_color((gx_device_vector *) pdev, &color);

	/* ̲ᤷʲο̵̣ */
    }
    if (code < 0) return 0;

    /* ѥϣλ꡿åɥѥ */
    (void)sprintf(obuf, ESC_GS "1;2;3;%d;%d;%dfpE",
		  (unsigned char)(c_color >> 16 & 0xff),
		  (unsigned char)(c_color >> 8 & 0xff),
		  (unsigned char)(c_color & 0xff));
    lputs(s, obuf);

    lputs(s, ESC_GS "5;2;1;0;0cpE");

    escv_write_begin(dev, depth, (int)x, (int)y, w, h, w, h, 0);
    {
	int		i, j;
	uint		width_bytes = (w + 7) >> 3;
	uint		num_bytes = width_bytes * h; 

	byte *buf = gs_alloc_bytes(vdev->memory, num_bytes, "escv_copy_mono(buf)");

	if (data_x % 8 == 0) {
	    for (i = 0; i < h; ++i) {
		memcpy(buf + i * width_bytes, data + (data_x >> 3) + i * raster, width_bytes);
	    }
	} else {
	    for (i = 0; i < h; ++i) {
		for (j = 0; j < width_bytes; j++) {
		    *(buf + i * width_bytes + j) =
			*(data + (data_x >> 3) + i * raster + j) << (data_x % 8) |
			*(data + (data_x >> 3) + i * raster + j + 1) >> (8 - data_x % 8);
		}
	    }
	}

	escv_write_data(dev, depth, buf, num_bytes, w, h);
	gs_free_object(vdev->memory, buf, "escv_copy_mono(buf)");
    }
    escv_write_end(dev, depth);
    return 0;
}


/* Copy a color bitmap. */
private int
escv_copy_color(gx_device * dev,
		  const byte * data, int data_x, int raster, gx_bitmap_id id,
		  int x, int y, int w, int h)
{
    gx_device_escv	*const pdev = (gx_device_escv *) dev;
    gx_device_vector	*const vdev = (gx_device_vector *) dev;

    stream		*s = gdev_vector_stream(vdev);
    int			depth = dev->color_info.depth;
    int			num_components = (depth < 24 ? 1 : 3);
    uint		width_bytes = w * num_components;

    if (pdev->MaskState != 0) {
	lputs(s, ESC_GS "3;204wfE" ESC_GS "5;204wfE");
	pdev->MaskState = 0;
    }

    escv_write_begin(dev, depth, (int)x, (int)y, w, h, w, h, 0);

    {
	int		i;
	uint		num_bytes = width_bytes * h;
	byte		*buf = gs_alloc_bytes(vdev->memory, num_bytes, "escv_copy_color(buf)");

	for (i = 0; i < h; ++i) {
	    memcpy(buf + i * width_bytes, data + ((data_x * depth) >> 3) + i * raster, width_bytes);
	}

	escv_write_data(dev, depth, buf, num_bytes, w, h);
	gs_free_object(vdev->memory, buf, "escv_copy_color(buf)");
    }

    escv_write_end(dev, depth);
    return 0;
}


/* Fill a mask. */
private int
escv_fill_mask(gx_device * dev,
		 const byte * data, int data_x, int raster, gx_bitmap_id id,
		 int x, int y, int w, int h,
		 const gx_drawing_color * pdcolor, int depth,
		 gs_logical_operation_t lop, const gx_clip_path * pcpath)
{
    gx_device_vector 		*vdev = (gx_device_vector *) dev;
    gx_device_escv 		*pdev = (gx_device_escv *) dev;
    stream			*s = gdev_vector_stream(vdev);

    if (w <= 0 || h <= 0) return 0;
    
    if (depth > 1 ||
	gdev_vector_update_fill_color(vdev, pdcolor) < 0 ||
	gdev_vector_update_clip_path(vdev, pcpath) < 0 ||
	gdev_vector_update_log_op(vdev, lop) < 0
	) 
	return gx_default_fill_mask(dev, data, data_x, raster, id,
				    x, y, w, h, pdcolor, depth, lop, pcpath);
    
#if 0
    (*dev_proc(vdev->bbox_device, fill_mask))
	((gx_device *) vdev->bbox_device, data, data_x, raster, id,
	 x, y, w, h, pdcolor, depth, lop, pcpath);
#endif

    if (pdev->MaskState != 1) {

	lputs(s, ESC_GS "3;184wfE" ESC_GS "5;184wfE");
	pdev->MaskState = 1;
    }

    if (id != gs_no_id && data_x == 0 && depth == 1) {
	char		obuf[128];
	int		i;
	uint		width_bytes = (w + 7) >> 3;
	uint		num_bytes = width_bytes * h;
	byte		*buf;

	if (pdev -> id_cache[id & VCACHE] != id) {

	    buf = gs_alloc_bytes(vdev->memory, num_bytes, "escv_fill_mask(buf)");

	    /* cache entry */
	    for (i = 0; i < h; ++i) {
		memcpy(buf + i * width_bytes, data + (data_x >> 3) + i * raster, width_bytes);
	    }

	    (void)sprintf(obuf, ESC_GS "%d;%d;%d;%d;0db{F", num_bytes, (int)(id & VCACHE), w, h);
	    lputs(s, obuf);
	    put_bytes(s, buf, num_bytes);

	    gs_free_object(vdev->memory, buf, "escv_fill_mask(buf)");
	    pdev -> id_cache[id & VCACHE] = id;
	}

	(void)sprintf(obuf, ESC_GS "%dX" ESC_GS "%dY", x, y);
	lputs(s, obuf);
	(void)sprintf(obuf, ESC_GS "%ddbF", id & VCACHE);
	lputs(s, obuf);

	return 0;
    }

    escv_write_begin(dev, depth, (int)x, (int)y, w, h, w, h, 0);
    {
	int		i;
	uint		width_bytes = (w + 7) >> 3;
	uint		num_bytes = width_bytes * h;
	byte		*buf = gs_alloc_bytes(vdev->memory, num_bytes, "escv_fill_mask(buf)");

	for (i = 0; i < h; ++i) {
	    memcpy(buf + i * width_bytes, data + (data_x >> 3) + i * raster, width_bytes);
	}

	escv_write_data(dev, depth, buf, num_bytes, w, h);
	escv_write_end(dev, depth);
	gs_free_object(vdev->memory, buf, "escv_fill_mask(buf)");
    }

    return 0;
}

/* ---------------- High-level images ---------------- */

private image_enum_proc_plane_data(escv_image_plane_data);
private image_enum_proc_end_image(escv_image_end_image);
private const gx_image_enum_procs_t escv_image_enum_procs =
{
    escv_image_plane_data, escv_image_end_image
};


/* Start processing an image. */
private int
escv_begin_image(gx_device * dev,
		   const gs_imager_state * pis, const gs_image_t * pim,
		   gs_image_format_t format, const gs_int_rect * prect,
	      const gx_drawing_color * pdcolor, const gx_clip_path * pcpath,
		   gs_memory_t * mem, gx_image_enum_common_t **pinfo)
{
    gx_device_vector *const	vdev = (gx_device_vector *) dev;
    gx_device_escv *const	pdev = (gx_device_escv *) dev;
    stream			*s = gdev_vector_stream((gx_device_vector *) pdev);
    gdev_vector_image_enum_t	*pie = 
	gs_alloc_struct(mem, gdev_vector_image_enum_t, &st_vector_image_enum, "escv_begin_image");
    const gs_color_space	*pcs = pim->ColorSpace;
    gs_color_space_index	index;
    int				num_components = 1;
    bool can_do = prect == 0 &&
      (pim->format == gs_image_format_chunky ||
       pim->format == gs_image_format_component_planar);

    gs_matrix			imat;
    int				code;
    int				ty, bx, by, cx, cy, dx, dy, sx, sy;

    if (pie == 0) return_error(gs_error_VMerror);
    pie->memory = mem;
    code = gdev_vector_begin_image(vdev, pis, pim, format, prect,
				   pdcolor, pcpath, mem, &escv_image_enum_procs, pie);
    if (code < 0) return code;
    
    *pinfo = (gx_image_enum_common_t *) pie;

    if (!pim->ImageMask) {
	index = gs_color_space_get_index(pcs);
	num_components = gs_color_space_num_components(pcs);

	if (pim->CombineWithColor) {	    
	    can_do = false;
	} else {
	    switch (index) {
		case gs_color_space_index_DeviceGray:
		    if ((pim->Decode[0] != 0 || pim->Decode[1] != 1)
			&& (pim->Decode[0] != 1 || pim->Decode[1] != 0))
			can_do = false;
		    break;
		case gs_color_space_index_DeviceRGB:
		    if (pim->Decode[0] != 0 || pim->Decode[1] != 1 ||
			pim->Decode[2] != 0 || pim->Decode[3] != 1 ||
			pim->Decode[4] != 0)
			can_do = false;
		    break;
		default:
		    can_do = false;
	    }
	}
    }
    if (!can_do) {
	return gx_default_begin_image(dev, pis, pim, format, prect,
				      pdcolor, pcpath, mem, &pie->default_info);
    }
    
    if (pim->ImageMask || (pim->BitsPerComponent == 1 && num_components == 1)) {
	if (pim->Decode[0] > pim->Decode[1]) {
	    pdev->MaskReverse = 1;
	} else {
	    lputs(s, ESC_GS "8;1;2;2;2plr{E");
	    put_bytes(s, "\000\000\000\000\377\377\377\377", 8);
	    pdev->MaskReverse = 0;
	}
    }

    /* Write the image/colorimage/imagemask preamble. */
    gs_matrix_invert(&pim->ImageMatrix, &imat);
    gs_matrix_multiply(&imat, &ctm_only(pis), &imat);

    ty = imat.ty;
    bx = imat.xx * pim->Width + imat.yx * pim->Height + imat.tx;
    by = imat.xy * pim->Width + imat.yy * pim->Height + imat.ty;
    cx = imat.yx * pim->Height + imat.tx;
    cy = imat.yy * pim->Height + imat.ty;
    dx = imat.xx * pim->Width + imat.tx;
    dy = imat.xy * pim->Width + imat.ty;

    sx = bx - (int)imat.tx;
    sy = by - (int)imat.ty;

    /* Ȥꤢΰ֤˼ޤ褦˶Ū˺ɸѹ롣 */
    pdev -> roll = 0;
    pdev -> reverse_x = pdev -> reverse_y = 0;
    if (imat.tx > bx) {
	pdev -> reverse_x = 1;
	sx = -sx;
	imat.tx = bx;
    }

    if (imat.ty > by) {
	pdev -> reverse_y = 1;
	sy = -sy;
	imat.ty = by;
    }

    (void)memcpy(&pdev -> xmat, &imat, sizeof(gs_matrix));
    pdev -> sx = sx;
    pdev -> sy = sy;
    pdev -> h = pim->Height;
    pdev -> w = pim->Width;
    pdev -> dd = 0;
    pdev -> bx = 0;
    pdev -> by = 0;

    if (ty == cy) {
	/* žˤĤƤϸ̤GS ¦εǽѤ */
	return -1;
    }

    if (pim->ImageMask) {
	pdev->ncomp = 1;

	/* ̿ - Ʃ */
	if (pdev->MaskState != 1) {

	    lputs(s, ESC_GS "3;184wfE" ESC_GS "5;184wfE");
	    pdev->MaskState = 1;
	}

    } else {

	/* ̿ - ɤ */
	if (pdev->MaskState != 0) {

	    lputs(s, ESC_GS "3;204wfE" ESC_GS "5;204wfE");
	    pdev->MaskState = 0;
	}
	pdev->ncomp = num_components;
    }

    if (pdev -> reverse_y) return 0;

    escv_write_begin(dev, pie->bits_per_pixel, (int)imat.tx, (int)imat.ty, pie->width, pie->height, sx, sy, pdev -> roll);
    
    return 0;
}


/* Process the next piece of an image. */
private int
#if GS_VERSION_MAJOR >= 6
escv_image_plane_data(gx_image_enum_common_t *info, const gx_image_plane_t *planes, int height, int *rows_used)
#else
escv_image_plane_data(gx_device *dev, gx_image_enum_common_t *info, const gx_image_plane_t *planes, int height)
#endif
{
#if GS_VERSION_MAJOR >= 6
    gx_device *dev = info->dev;
#endif
    gx_device_vector *const	vdev = (gx_device_vector *) dev;
    gx_device_escv *const	pdev = (gx_device_escv *) dev;
    gdev_vector_image_enum_t	*pie = (gdev_vector_image_enum_t *) info;

    int				y;
    int				plane;
    int				width_bytes, tbyte;
    byte			*buf;

    if (pie->default_info) return gx_image_plane_data(pie->default_info, planes, height);

    gx_image_plane_data(pie->bbox_info, planes, height);

    {

#if GS_VERSION_MAJOR >= 6
	if (height == 260)
	    height = 1;
#endif
	width_bytes = (pie->width * pie->bits_per_pixel / pdev->ncomp + 7) / 8 * pdev->ncomp;
	tbyte = width_bytes * height;
	buf = gs_alloc_bytes(vdev->memory, tbyte, "escv_image_data(buf)");

	if (pdev -> reverse_y) {

	    if (pdev -> h == height) {
#if 1
		if(tbyte == 1){
		      pdev->w += pdev->sx / 2048;
		      height  += pdev->sy / 2048;
	        }
#endif


		escv_write_begin(dev, pie->bits_per_pixel, (int)pdev -> xmat.tx, (int)pdev -> xmat.ty, pdev -> w, height, (int)pdev -> sx, (int)pdev -> sy, pdev -> roll);

	    } else {
		float	yy, sy;

		yy = (pdev -> h * pdev->xmat.yy) - (pdev -> dd * pdev -> xmat.yy) - (height * pdev -> xmat.yy);
		if (yy == 0) {
		    yy = (pdev -> h * pdev->xmat.yx) - (pdev -> dd * pdev -> xmat.yx) - (height * pdev -> xmat.yx);
		}

		if (pdev -> by) {
		    sy = (int)pdev -> xmat.ty - (int)yy;
		    sy = pdev -> by - (int)sy;
		} else {
		    sy = height * pdev -> xmat.yy + 0.5;
		}
		if (sy < 0) {
		    sy = -sy;
		}

		escv_write_begin(dev, pie->bits_per_pixel, (int)pdev -> xmat.tx, (int)pdev -> xmat.ty - (int)yy, pdev -> w, height, (int)pdev -> sx, (int)sy, pdev -> roll);

		pdev -> by = (int)pdev -> xmat.ty - (int)yy;
	    }
	}
	pdev -> dd += height;

	for (plane = 0; plane < pie->num_planes; ++plane) {

	    for (y = 0; y < height; ++y) {

		int     bit, w;
		char    *p, *d, c;

                p = planes[plane].data + ((planes[plane].data_x * pie->bits_per_pixel) >> 3) + y * planes[plane].raster;
		if (pdev -> reverse_y) {

		    d = buf + (height - y) * width_bytes;

		    if (!pdev -> reverse_x) {
			(void)memcpy(buf + (height - y - 1) * width_bytes,
				     planes[plane].data + ((planes[plane].data_x * pie->bits_per_pixel) >> 3)
				     + y * planes[plane].raster, width_bytes);

		    }

		} else {

		    d = buf + (y + 1) * width_bytes;

		    if (!pdev -> reverse_x) {

			(void)memcpy(buf + y * width_bytes,
				     planes[plane].data + ((planes[plane].data_x * pie->bits_per_pixel) >> 3)
				     + y * planes[plane].raster, width_bytes);

		    }
		}
		if (pdev -> reverse_x) {
		    if (pie->bits_per_pixel == 1) {
			for (w = 0; w < width_bytes; w++) {
			    c = 0;
			    for (bit = 0; bit < 8; bit++) {
				if (*p & 1 << (7 - bit)) {
				    c |= 1 << bit;
				}
			    }
			    p++;
			    *--d = c;
			}
		    } else if (pie->bits_per_pixel == 8){
			for (w = 0; w < width_bytes; w++) {
			    *--d = *p++;
			}
		    } else {
			for (w = 0; w < width_bytes / 3; w++) {
			    *--d = *(p + 2);
			    *--d = *(p + 1);
			    *--d = *p;
			    p += 3;
			}
		    }
		}
	    }
	}

#if 1
	if(tbyte == 1){
	    int t;
	    gs_free_object(vdev->memory, buf, "esmv_image_data(buf)");
	    if(pdev->sx > pdev->sy){
	        tbyte = 1;
	    } else {
		if(pdev->sx < pdev->sy){
	            tbyte = tbyte * height;
  	        } else {
	            tbyte = 1;
	        }
	    }
	    buf = gs_alloc_bytes(vdev->memory, tbyte, "esmv_image_data(buf)");
	    for(t = 0; t < tbyte; t++){
	        buf[t] = 0x00;
	    }
	}
#endif

	escv_write_data(dev, pie->bits_per_pixel, buf, tbyte, pdev -> w, height);

	if (pdev -> reverse_y) {
	    escv_write_end(dev, pie->bits_per_pixel);
	}

	gs_free_object(vdev->memory, buf, "escv_image_data(buf)");
    }
    return (pie->y += height) >= pie->height;
}


private int
#if GS_VERSION_MAJOR >= 6
escv_image_end_image(gx_image_enum_common_t * info, bool draw_last)
#else
escv_image_end_image(gx_device *dev, gx_image_enum_common_t * info, bool draw_last)
#endif
{
#if GS_VERSION_MAJOR >= 6
    gx_device *dev = info->dev;
#endif
    gx_device_vector		*const vdev = (gx_device_vector *) dev;
    gx_device_escv		*const pdev = (gx_device_escv *) dev;
    gdev_vector_image_enum_t	*pie = (gdev_vector_image_enum_t *) info;
    stream			*s = gdev_vector_stream((gx_device_vector *)pdev);
    int				code;

    if (!(pdev -> reverse_y)) {
	escv_write_end(dev, pie->bits_per_pixel);
    }

    pdev->reverse_x = pdev->reverse_y = 0;
    if (pdev->MaskReverse == 0) {
	lputs(s, ESC_GS "8;1;2;2;2plr{E");
	put_bytes(s, "\377\377\377\377\000\000\000\000", 8);
    }
    pdev->MaskReverse = -1;

    code = gdev_vector_end_image(vdev, (gdev_vector_image_enum_t *) pie, draw_last, pdev->white);
    return code;
}


private void escv_write_begin(gx_device *dev, int bits, int x, int y, int sw, int sh, int dw, int dh, int roll)
{
    gx_device_vector *const     vdev = (gx_device_vector *) dev;
    gx_device_escv *const       pdev = (gx_device_escv *)dev;
    stream			*s = gdev_vector_stream((gx_device_vector *)pdev);
    char                        obuf[128], *tmp, *p;
    int				i, comp;

    (void)sprintf(obuf, ESC_GS "%dX" ESC_GS "%dY", x, y);
    lputs(s, obuf);

    comp = 0;

    if (bits == 1) {
	(void)sprintf(obuf, ESC_GS "2;201;1;%d;%d;%d;%d;%d;%dscrI", comp, sw, sh, dw, dh, roll);
    } else if (bits == 4) {
	if (pdev -> c4map) {
	    /* 顼ޥåϿ */
	    lputs(s, ESC_GS "64;2;2;16;16plr{E");
	    p = tmp = gs_alloc_bytes(vdev->memory, 64, "escv_write_begin(tmp4)");
	    for (i = 0; i < 16; i++) {
		*p++ = i << 4;
		*p++ = i << 4;
		*p++ = i << 4;
		*p++ = i << 4;
	    }
	    put_bytes(s, tmp, 64);
	    gs_free_object(vdev->memory, tmp, "escv_write_begin(tmp4)");
	    pdev -> c4map = FALSE;
	}
	(void)sprintf(obuf, ESC_GS "2;203;2;%d;%d;%d;%d;%d;%dscrI", comp, sw, sh, dw, dh, roll);
    } else if (bits == 8) {
	if (pdev -> c8map) {
	    /* 顼ޥåϿ */
	    lputs(s, ESC_GS "1024;4;2;256;256plr{E");
	    p = tmp = gs_alloc_bytes(vdev->memory, 1024, "escv_write_begin(tmp)");
	    for (i = 0; i < 256; i++) {
		*p++ = i;
		*p++ = i;
		*p++ = i;
		*p++ = i;
	    }
	    put_bytes(s, tmp, 1024);
	    gs_free_object(vdev->memory, tmp, "escv_write_begin(tmp)");
	    pdev -> c8map = FALSE;
	}
	(void)sprintf(obuf, ESC_GS "2;204;4;%d;%d;%d;%d;%d;%dscrI", comp, sw, sh, dw, dh, roll);
    } else {
	/* 24 bit */
	(void)sprintf(obuf, ESC_GS "2;102;0;%d;%d;%d;%d;%d;%dscrI", comp, sw, sh, dw, dh, roll);
    }    
    lputs(s, obuf);

    return;
}


private void escv_write_data(gx_device *dev, int bits, char *buf, int bsize, int w, int ras)
{
    gx_device_vector *const     vdev = (gx_device_vector *) dev;
    gx_device_escv *const       pdev = (gx_device_escv *) dev;
    stream			*s = gdev_vector_stream((gx_device_vector *)pdev);
    char                        obuf[128];
    int				size;
    char			/**tmp,*/ *tmps, *p, tmp;

    if (bits == 12) {
	p = tmps = gs_alloc_bytes(vdev->memory, bsize * 2, "escv_write_data(tmp)");
#if 0
	for (size = 0; size < bsize; size++) {
	    if((buf[size] & 0xF0) == 0xF0){
	        *p++ = 0xFF;
	    }else{
	        *p++ = buf[size] & 0xF0;
	    }
	    if((buf[size] << 4 & 0xF0) == 0xF0){
	        *p++ = 0xFF;
	    }else{
	        *p++ = buf[size] << 4;
	    }
	}
#else
	for (size = 0; size < bsize; size++) {
	        tmp = buf[size] & 0xF0;
	        *p++ = (tmp + (tmp >> 4 & 0x0F));
	        tmp = buf[size] << 4;
	        *p++ = (tmp + (tmp >> 4 & 0x0F));
	}

#endif
	bsize = bsize * 2;
	buf = tmps;
    }

    (void)sprintf(obuf, ESC_GS "%d;%dcu{I", bsize, ras);
    lputs(s, obuf);
    put_bytes(s, buf, bsize);

    if (bits == 12) {
      gs_free_object(vdev->memory, tmps, "escv_write_data(tmp)");
    }
    return;
}


private void escv_write_end(gx_device *dev, int bits)
{
    gx_device_escv *const       pdev = (gx_device_escv *) dev;
    stream			*s = gdev_vector_stream((gx_device_vector *)pdev);

    lputs(s, ESC_GS "ecrI");
    return;
}

