// $Id: roundangle.cpp,v 1.18 2003/01/12 22:42:19 nhasan Exp $

#include <kdebug.h>
#include <qpainter.h>

#include <klocale.h>

#include "roundangle.h"

#define ROUNDNESS (40)

Roundangle::Roundangle() : Tool( i18n( "Round Angle" ) )
{
  drawing= FALSE;
  props= Tool::HasLineProperties | Tool::HasFillProperties;
}

void Roundangle::activating()
{
kdDebug(4400) << "Roundangle::activating() hook called\n" << endl;
  canvas->setCursor(crossCursor);
}

void Roundangle::mousePressEvent(QMouseEvent *e)
{
kdDebug(4400) << "Roundangle::mousePressEvent() handler called\n" << endl;
  
  if (isActive()) {
    if (drawing) {
      kdDebug(4400) << "RubberLine: Warning Left Button press received when pressed\n" << endl;
    }
    else {
      startx= (e->pos()).x();
      starty= (e->pos()).y();
      activeButton= e->button();
      lastx= startx;
      lasty= starty;
      drawing= TRUE;
    } 
  }
  if (!isActive()) {
kdWarning(4400) << "Warning event received when inactive (ignoring)\n" << endl;
  }
}

void Roundangle::mouseMoveEvent(QMouseEvent *e)
{
  int x,y;
  QPainter paint;

  if (isActive()) {
    x= (e->pos()).x();
    y= (e->pos()).y();

    if ((lastx != x) || (lasty != y)) {
      if (drawing) {
	paint.begin(canvas->zoomedPixmap());

	if (activeButton == LeftButton)
	  paint.setPen(leftpen);
	else
	  paint.setPen(rightpen);

	paint.setRasterOp(DEFAULT_RASTER_OP);

	// Erase old roundangle
	paint.drawRoundRect(startx, starty, lastx-startx, lasty-starty, 
			    ROUNDNESS, ROUNDNESS);
	// Draw new roundangle
	paint.drawRoundRect(startx, starty, x-startx, y-starty,
			    ROUNDNESS, ROUNDNESS);

	lastx= x;
	lasty= y;

	paint.end();
	canvas->repaint(0);
      }
    }
  }
  else {
kdWarning(4400) << "Warning event received when inactive (ignoring)\n" << endl;
  }
}

void Roundangle::mouseReleaseEvent(QMouseEvent *e)
{
  int x,y;
  QPainter paint;

kdDebug(4400) << "Roundangle::mouseReleaseEvent() handler called\n" << endl;

  if (isActive() && (e->button() == activeButton)) {
    canvas->markModified();
    x= (e->pos()).x();
    y= (e->pos()).y();

    // Erase old line
    paint.begin(canvas->zoomedPixmap());

    if (activeButton == LeftButton)
      paint.setPen(leftpen);
    else
      paint.setPen(rightpen);

    paint.setRasterOp(DEFAULT_RASTER_OP);
    paint.drawRoundRect(startx, starty, lastx-startx, lasty-starty,
			ROUNDNESS, ROUNDNESS);

    paint.end();

    paint.begin(canvas->pixmap());

    if (activeButton == LeftButton) {
      paint.setPen(leftpen);
      paint.setBrush(leftbrush);
    }
    else {
      paint.setPen(rightpen);
      paint.setBrush(rightbrush);
    }

    paint.setWorldMatrix(canvas->zoomMatrix());
    paint.setRasterOp(CopyROP);
    // Draw new roundangle
    paint.drawRoundRect(startx, starty, x-startx, y-starty, ROUNDNESS, ROUNDNESS);
    paint.end();
    drawing= FALSE;
    canvas->updateZoomed();
    canvas->repaint(0);
  }
  else {
kdWarning(4400) << "Warning event received when inactive (ignoring)\n" << endl;
  }
}

const char* Roundangle::pixmap() const
{
    return "roundangle";
}

#include "roundangle.moc"

