#include "field.h"
#include "field.moc"

#include <qwhatsthis.h>

#include <klocale.h>
#include <kgamelcd.h>

#include "board.h"
#include "prefs.h"
#include "piece.h"


KSField::KSField(QWidget *parent)
    : Field(parent)
{
    connect(board, SIGNAL(removedLinesUpdated(uint, uint)),
            SLOT(removedLinesUpdated(uint, uint)));
}

void KSField::removedLinesUpdated(uint index, uint removed)
{
    bool detailed = ( removedList->size()==4 );
    uint i = (detailed ? index : 0);
    KGameLCD *lcd = static_cast<KGameLCD *>(removedList->lcd(i));
    uint nb = (detailed ? removed : board->nbRemoved());
    lcd->displayInt(nb);
    if (nb) lcd->highlight();
}

void KSField::settingsChanged()
{
    Field::settingsChanged();
    bool b = Prefs::oldRotationStyle();
    static_cast<KSPieceInfo &>(Piece::info()).setOldRotationStyle(b);

    b = Prefs::showDetailedRemoved();
    if ( b && removedList->size()!=4 ) {
        removedList->clear();
        QWhatsThis::add(removedList,
                        i18n("Display the number of lines removed "
                             "simultaneously."));
        for (uint i=0; i<4; i++) {
            KGameLCD *lcd = new KGameLCD(5, removedList);
            removedList->append(lcd);
            lcd->setLeadingString(QString::number(i+1));
            uint nb = static_cast<const KSBoard *>(board)->nbRemovedLines(i);
            lcd->displayInt(nb);
            lcd->show();
        }
    }
    if ( !b && removedList->size()!=1 ) {
        removedList->clear();
        QWhatsThis::remove(removedList);
        KGameLCD *lcd = new KGameLCD(5, removedList);
        removedList->append(lcd);
        lcd->displayInt( board->nbRemoved() );
        lcd->show();
    }
}
