/***************************************************************************
                            KFileViewSignaler.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KFILEVIEWSIGNALER_H
#define KFILEVIEWSIGNALER_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QObject.h>

/**

 internal class to make easier to use signals possible

 @short 
 internal class to make easier to use signals possible

*/
@class KFileViewItem; 

@class KFileItem; 

@interface KFileViewSignaler : QObject 

/** 
 Call this method when an item is selected (depends on single click /
 double click configuration). Emits the appropriate signal.

*/
- activate: (KFileItem*)item;

/** 
 emits the highlighted signal for item. Call this in your view class
 whenever the selection changes.
     
*/
- highlightFile: (KFileItem*)i;
- activateMenu: (KFileItem*)i pos: (QPoint*)pos;
- changeSorting: (int)sorting;
@end

/** Override these methods in subclasses of KFileViewSignaler to customise event handling behaviour */
@protocol KFileViewSignalerEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
