/***************************************************************************
                            HTMLBodyElement.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef HTMLBODYELEMENT_H
#define HTMLBODYELEMENT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/HTMLElement.h>

/**

 The HTML document body. This element is always present in the DOM
 API, even if the tags are not present in the source document. See
 the <a
 href="http://www.w3.org/TR/REC-html40/struct/global.-[html edef]-BODY">
 BODY element definition </a> in HTML 4.0.

 
 @short 
 The HTML document body.
*/

@interface HTMLBodyElement : HTMLElement 
- init;
- copyWithZone: (NSZone *) zone;
- initWithDOMNode: (DOMNode*)other;
- (void) dealloc;

/** 
 Color of active links (after mouse-button down, but before
 mouse-button up). See the <a
 href="http://www.w3.org/TR/REC-html40/struct/global.-[html adef]-alink">
 alink attribute definition </a> in HTML 4.0. This attribute is
 deprecated in HTML 4.0.

     
*/
- (NSString *) aLink;

/** 
 see @ref aLink
     
*/
- setALink: (NSString *)arg1;

/** 
 URI of the background texture tile image. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/global.-[html adef]-background">
 background attribute definition </a> in HTML 4.0. This
 attribute is deprecated in HTML 4.0.

     
*/
- (NSString *) background;

/** 
 see @ref background
     
*/
- setBackground: (NSString *)arg1;

/** 
 Document background color. See the <a
 href="http://www.w3.org/TR/REC-html40/present/graphics.-[html adef]-bgcolor">
 bgcolor attribute definition </a> in HTML 4.0. This attribute
 is deprecated in HTML 4.0.

     
*/
- (NSString *) bgColor;

/** 
 see @ref bgColor
     
*/
- setBgColor: (NSString *)arg1;

/** 
 Color of links that are not active and unvisited. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/global.-[html adef]-link">
 link attribute definition </a> in HTML 4.0. This attribute is
 deprecated in HTML 4.0.

     
*/
- (NSString *) link;

/** 
 see @ref link
     
*/
- setLink: (NSString *)arg1;

/** 
 Document text color. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/global.-[html adef]-text">
 text attribute definition </a> in HTML 4.0. This attribute is
 deprecated in HTML 4.0.

     
*/
- (NSString *) text;

/** 
 see @ref text
     
*/
- setText: (NSString *)arg1;

/** 
 Color of links that have been visited by the user. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/global.-[html adef]-vlink">
 vlink attribute definition </a> in HTML 4.0. This attribute is
 deprecated in HTML 4.0.

     
*/
- (NSString *) vLink;

/** 
 see @ref vLink
     
*/
- setVLink: (NSString *)arg1;
@end

#endif
