/***************************************************************************
                            DCOPObjectProxy.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef DCOPOBJECTPROXY_H
#define DCOPOBJECTPROXY_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 You must use a proxy if you want to dispatch method calls for
 object IDs which dont have (yet) a corresponding @ref DCOPObject.
 This is somewhat like virtual object references in CORBA.

 @author Matthias Ettrich <ettrich@kde.org>
 
 @short 
 You must use a proxy if you want to dispatch method calls for
 object IDs which dont have (yet) a corresponding @ref DCOPObject.
*/
@class DCOPClient; 
@class QByteArray; 

@interface  DCOPObjectProxy : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/** 
 Creates a new proxy.
     
*/
- init;

/** 
 Obsolete, do not use. DCOP clients know about object proxies
 automatically.

     
*/
- initWithDCOPClient: (DCOPClient*)arg1;

/** 
 Destroy the proxy.
     
*/
- (void) dealloc;

/** 
 Reimplement this method to dispatch method calls.

 This method is called of all proxies if the @ref DCOPClient
 knows no object with the id @p obj. If the first proxy returns
 @p true, the @ref DCOPClient will no longer call other proxies.

 The object id @p obj may be empty for app-wide function calls no
 associated with any object.
     
*/
- (BOOL) process: (NSString *)obj fun: (NSString *)fun data: (QByteArray*)data replyType: (NSString *)replyType replyData: (QByteArray*)replyData;
@end

#endif
