//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QMetaObject;
import org.kde.qt.QtSupport;
import org.kde.qt.QObject;

/**

 Base class for any "viewer" part.
 This class takes care of network transparency for you,
 in the simplest way (synchronously).
 To use the built-in network transparency, you only need to implement
 openFile(), not openURL().
 To prevent network transparency, or to implement it another way
 (e.g. asynchronously), override openURL().
 KParts Application can use the signals to show feedback while the URL is being loaded.
 ReadOnlyPart handles the window caption by setting it to the current URL
 (set in openURL(), and each time the part is activated).
 If you want another caption, set it in openFile() and
 (if the part might ever be used with a part manager) in guiActivateEvent()
  See {@link ReadOnlyPartSignals} for signals emitted by ReadOnlyPart
		@short    Base class for any "viewer" part.

*/
public class ReadOnlyPart extends Part  {
	protected ReadOnlyPart(Class dummy){super((Class) null);}
	public native QMetaObject metaObject();
	public native String className();
	/**	
		 Constructor
		 See also Part for the setXXX methods to call.
		   		@short    Constructor  See also Part for the setXXX methods to call.
	*/
	/**	
		 Call this to turn off the progress info dialog used by
		 the internal KIO job. Use this if you provide another way
		 of displaying progress info (e.g. a statusbar), using the
		 signals emitted by this class, and/or those emitted by
		 the Job given by started.
		   		@short    Call this to turn off the progress info dialog used by  the internal KIO job.
	*/
	public native void setProgressInfoEnabled(boolean show);
	/**	
		 Returns whether the part shows the progress info dialog used by internal
		 KIO job.
		   		@short    Returns whether the part shows the progress info dialog used by internal  KIO job.
	*/
	public native boolean isProgressInfoEnabled();
	public native void showProgressInfo(boolean show);
	/**	
		  Returns the currently in part used URL.
				@return The current used URL.
   
		@short     Returns the currently in part used URL.
	*/
	public native KURL url();
	/**	
		 Called when closing the current url (e.g. document), for instance
		 when switching to another url (note that openURL() calls it
		 automatically in this case).
		 If the current URL is not fully loaded yet, aborts loading.
		 Deletes the temporary file used when the url is remote.
				@return always true, but the return value exists for reimplementations
   
		@short    Called when closing the current url (e.
	*/
	public native boolean closeURL();
	/**	
		 Initiate sending data to this part.
		 This is an alternative to openURL, which allows the user of the part
		 to load the data itself, and send it progressively to the part.
			@param url the URL representing this data. Although not directly used,
		 every ReadOnlyPart has a URL (see url()), so this simply sets it.
			@param mimeType the type of data that is going to be sent to this part.
				@return true if the part supports progressive loading and accepts data, false otherwise.
   
		@short    Initiate sending data to this part.
	*/
	public native boolean openStream(String mimeType, KURL url);
	/**	
		 Send some data to the part. openStream must have been called previously,
		 and must have returned true.
				@return true if the data was accepted by the part. If false is returned,
 the application should stop sending data, and doesn't have to call closeStream.
   
		@short    Send some data to the part.
	*/
	public native boolean writeStream(byte[] data);
	/**	
		 Terminate the sending of data to the part.
		 With some data types (text, html...) closeStream might never actually be called,
		 in the case of continuous streams, for instance plain text or HTML data.
		   		@short    Terminate the sending of data to the part.
	*/
	public native boolean closeStream();
	/**	
		 Only reimplement openURL if you don't want synchronous network transparency
		 Otherwise, reimplement openFile() only .
			 If you reimplement it, don't forget to set the caption, usually with
		 emit setWindowCaption( url.prettyURL() );
		   		@short    Only reimplement openURL if you don't want synchronous network transparency  Otherwise, reimplement openFile() only .
	*/
	public native boolean openURL(KURL url);
}
