//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QMetaObject;
import org.kde.qt.QtSupport;
import org.kde.qt.QObject;
import org.kde.qt.QObject;

/**

 Child process invocation, monitoring and control.
 <li><b>General usage and features:</b></li>
 This class allows a KDE application to start child processes without having
 to worry about UNX signal handling issues and zombie process reaping.
 Basically, this class distinguishes three different ways of running
 child processes:

	<li>
	DontCare -- The child process is invoked and both the child
	 process and the parent process continue concurrently.
	</li>
	 The process is started in an own session (see setsid(2)).

	<li>
	NotifyOnExit -- The child process is invoked and both the
	 child and the parent process run concurrently.
	</li>
	 When the child process exits, the KProcess instance
 corresponding to it emits the Qt signal processExited().
 Since this signal is <b>not</b> emitted from within a UNX
 signal handler, arbitrary function calls can be made.
 Be aware: When the KProcess object gets destructed, the child
 process will be killed if it is still running!
 This means in particular, that it usually makes no sense to use
 a KProcess on the stack with NotifyOnExit.

	<li>
	OwnGroup -- like NotifyOnExit, but the child process is started
	 in an own process group (and an own session, FWIW). The behavior of
	 kill() changes to killing the whole process group - this makes
	 this mode useful for implementing primitive job management. It can be
	 used to work around broken wrapper scripts that don't propagate signals
	 to the "real" program. However, use this with care, as you disturb the
	 shell's job management if your program is started from the command line.
	</li>
	
	<li>
	Block -- The child process starts and the parent process
	 is suspended until the child process exits. (<b>Really</b> not recommended
	 for programs with a GUI.)
	 In this mode the parent can read the child's output, but can't send it any
	 input.
	</li>
	 KProcess also provides several functions for determining the exit status
 and the pid of the child process it represents.
 Furthermore it is possible to supply command-line arguments to the process
 in a clean fashion (no null-terminated stringlists and such...)
 A small usage example:
 <pre>
   KProcess proc = new KProcess;
   proc << "my_executable";
   proc << "These" << "are" << "the" << "command" << "line" << "args";
   QApplication.connect(proc, SIGNAL("processExited(KProcess )"),
                         pointer_to_my_object, SLOT("my_objects_slot(KProcess )"));
   proc.start();
 </pre>
 This will start "my_executable" with the commandline arguments "These"...
 When the child process exits, the slot will be invoked.
 <li><b>Communication with the child process:</b></li>
 KProcess supports communication with the child process through
 stdin/stdout/stderr.
 The following functions are provided for getting data from the child
 process or sending data to the child's stdin (For more information,
 have a look at the documentation of each function):

	<li>
	writeStdin()
	  -- Transmit data to the child process' stdin. When all data was sent, the
	 signal wroteStdin() is emitted.
	</li>
	
	<li>
	When data arrives at stdout or stderr, the signal receivedStdout()
	 resp. receivedStderr() is emitted.
	</li>
	
	<li>
	You can shut down individual communication channels with
	 closeStdin(), closeStdout(), and closeStderr(), resp.
	</li>
	 See {@link KProcessSignals} for signals emitted by KProcess
		@author Christian Czezatke e9025461@student.tuwien.ac.at

		@short    Child process invocation, monitoring and control.
		@see KProcIO

*/
public class KProcess extends QObject  {
	protected KProcess(Class dummy){super((Class) null);}
	/**	
		 More or less intuitive constants for use with setPriority().
		   		@short    More or less intuitive constants for use with setPriority().
	*/
	public static final int PrioLowest = 20;
	public static final int PrioLow = 10;
	public static final int PrioLower = 5;
	public static final int PrioNormal = 0;
	public static final int PrioHigher = -5;
	public static final int PrioHigh = -10;
	public static final int PrioHighest = -19;

	/**	
		 Modes in which the communication channel can be opened.
			 If communication for more than one channel is required,
		 the values have to be or'ed together, for example to get
		 communication with stdout as well as with stdin, you would
		 specify <code>Stdin</code> | <code>Stdout</code>
			 If <code>NoRead</code> is specified in conjunction with <code>Stdout</code>,
		 no data is actually read from <code>Stdout</code> but only
		 the signal receivedStdout(int fd, int &len) is emitted.
		   		@short    Modes in which the communication channel can be opened.
	*/
	public static final int NoCommunication = 0;
	public static final int Stdin = 1;
	public static final int Stdout = 2;
	public static final int Stderr = 4;
	public static final int AllOutput = 6;
	public static final int All = 7;
	public static final int NoRead = 8;

	/**	
		 Run-modes for a child process.
		   		@short    Run-modes for a child process.
	*/
	public static final int DontCare = 0;
	public static final int NotifyOnExit = 1;
	public static final int Block = 2;
	public static final int OwnGroup = 3;

	public native QMetaObject metaObject();
	public native String className();
	/**	
		 Constructor
				@short    Constructor
	*/
	public KProcess(QObject parent, String name) {
		super((Class) null);
		newKProcess(parent,name);
	}
	private native void newKProcess(QObject parent, String name);
	public KProcess(QObject parent) {
		super((Class) null);
		newKProcess(parent);
	}
	private native void newKProcess(QObject parent);
	/**	
		 Constructor
		   		@short    Constructor
	*/
	public KProcess() {
		super((Class) null);
		newKProcess();
	}
	private native void newKProcess();
	/**	
		 Sets the executable and the command line argument list for this process.
			 For example, doing an "ls -l /usr/local/bin" can be achieved by:
		  <pre>
		  KProcess p;
		  ...
		  p << "ls" << "-l" << "/usr/local/bin"
		  </pre>
			@param arg the argument to add
				@return a reference to this KProcess

		@short    Sets the executable and the command line argument list for this process.
	*/
	public native KProcess op_write(String arg);
	/**	
		 Sets the executable and the command line argument list for this process,
		 in a single method call, or add a list of arguments.
			@param args the arguments to add
				@return a reference to this KProcess

		@short    Sets the executable and the command line argument list for this process,  in a single method call, or add a list of arguments.
	*/
	public native KProcess op_write(String[] args);
	/**	
		 Clear a command line argument list that has been set by using
		 operator<<.
		  		@short    Clear a command line argument list that has been set by using  operator<<.
	*/
	public native void clearArguments();
	/**	
		  Starts the process.
		  For a detailed description of the
		  various run modes and communication semantics, have a look at the
		  general description of the KProcess class. Note that if you use
		 setUsePty( Stdout | Stderr, \<boolean\> ), you cannot use Stdout | Stderr
		  here - instead, use Stdout only to receive the mixed output.
			  The following problems could cause this function to
		    return false:
		
			<li>
			The process is already running.
			</li>
			
			<li>
			The command line argument list is empty.
			</li>
			
			<li>
			The the <code>comm</code> parameter is incompatible with the selected pty usage.
			</li>
			
			<li>
			The starting of the process failed (could not fork).
			</li>
			
			<li>
			The executable was not found.
			</li>
				@param runmode The Run-mode for the process.
			@param comm Specifies which communication links should be
		  established to the child process (stdin/stdout/stderr). By default,
		  no communication takes place and the respective communication
		  signals will never get emitted.
				@return true on success, false on error
  (see above for error conditions)

		@short     Starts the process.
	*/
	public native boolean start(int runmode, int comm);
	public native boolean start(int runmode);
	public native boolean start();
	/**	
		 Stop the process (by sending it a signal).
			@param signo The signal to send. The default is SIGTERM.
				@return true if the signal was delivered successfully.
  
		@short    Stop the process (by sending it a signal).
	*/
	public native boolean kill(int signo);
	public native boolean kill();
	/**	
		 Checks whether the process is running.
				@return true if the process is (still) considered to be running
  
		@short    Checks whether the process is running.
	*/
	public native boolean isRunning();
	/**	 Returns the process id of the process.
			 If it is called after
		 the process has exited, it returns the process id of the last
		  child process that was created by this instance of KProcess.
			  Calling it before any child process has been started by this
		  KProcess instance causes pid() to return 0.
				@return the pid of the process or 0 if no process has been started yet.

		@short   Returns the process id of the process.
	*/
	public native int pid();
	/**	
		 Suspend processing of data from stdout of the child process.
		   		@short    Suspend processing of data from stdout of the child process.
	*/
	public native void suspend();
	/**	
		 Resume processing of data from stdout of the child process.
		   		@short    Resume processing of data from stdout of the child process.
	*/
	public native void resume();
	/**	
		 Suspend execution of the current thread until the child process dies
		 or the timeout hits. This function is not recommended for programs
		 with a GUI.
			@param timeout timeout in seconds. -1 means wait indefinitely.
				@return true if the process exited, false if the timeout hit.

		@short    Suspend execution of the current thread until the child process dies  or the timeout hits.
	*/
	public native boolean waitThread(int timeout);
	public native boolean waitThread();
	/**	
		 Checks whether the process exited cleanly.
				@return true if the process has already finished and has exited
  "voluntarily", ie: it has not been killed by a signal.
   
		@short    Checks whether the process exited cleanly.
	*/
	public native boolean normalExit();
	/**	
		 Checks whether the process was killed by a signal.
				@return true if the process has already finished and has not exited
 "voluntarily", ie: it has been killed by a signal.

		@short    Checks whether the process was killed by a signal.
	*/
	public native boolean signalled();
	/**	
		 Checks whether a killed process dumped core.
				@return true if signalled() returns true and the process
 dumped core. Note that on systems that don't define the
 WCOREDUMP macro, the return value is always false.

		@short    Checks whether a killed process dumped core.
	*/
	public native boolean coreDumped();
	/**	
		 Returns the exit status of the process.
				@return the exit status of the process. Note that this value
 is not valid if normalExit() returns false.
   
		@short    Returns the exit status of the process.
	*/
	public native int exitStatus();
	/**	
		 Returns the signal the process was killed by.
				@return the signal number that caused the process to exit.
 Note that this value is not valid if signalled() returns false.

		@short    Returns the signal the process was killed by.
	*/
	public native int exitSignal();
	/**	
			 Transmit data to the child process' stdin.
			 This function may return false in the following cases:
		
			<li>
			The process is not currently running.
			</li>
			
			<li>
			Communication to stdin has not been requested in the start() call.
			</li>
			
			<li>
			Transmission of data to the child process by a previous call to
			 writeStdin() is still in progress.
			</li>
				 Please note that the data is sent to the client asynchronously,
		 so when this function returns, the data might not have been
		 processed by the child process.
			 If all the data has been sent to the client, the signal
		 wroteStdin() will be emitted.
			 Please note that you must not free <code>buffer</code> or call writeStdin()
		 again until either a wroteStdin() signal indicates that the
		 data has been sent or a processExited() signal shows that
		 the child process is no longer alive.
			@param buffer the buffer to write. Do not free or modify it until
		 you get a wroteStdin() or processExited() signal
			@param buflen the length of the buffer
				@return false if an error has occurred

		@short   	 Transmit data to the child process' stdin.
	*/
	public native boolean writeStdin(String buffer, int buflen);
	/**	
		 Shuts down the Stdin communication link. If no pty is used, this
		 causes "EOF" to be indicated on the child's stdin file descriptor.
				@return false if no Stdin communication link exists (any more).
   
		@short    Shuts down the Stdin communication link.
	*/
	public native boolean closeStdin();
	/**	
		 Shuts down the Stdout communication link. If no pty is used, any further
		 attempts by the child to write to its stdout file descriptor will cause
		 it to receive a SIGPIPE.
				@return false if no Stdout communication link exists (any more).
   
		@short    Shuts down the Stdout communication link.
	*/
	public native boolean closeStdout();
	/**	
		 Shuts down the Stderr communication link. If no pty is used, any further
		 attempts by the child to write to its stderr file descriptor will cause
		 it to receive a SIGPIPE.
				@return false if no Stderr communication link exists (any more).
   
		@short    Shuts down the Stderr communication link.
	*/
	public native boolean closeStderr();
	/**	
		 Deletes the optional utmp entry and closes the pty.
			 Make sure to shut down any communication links that are using the pty
		 before calling this function.
				@return false if the pty is not open (any more).
   
		@short    Deletes the optional utmp entry and closes the pty.
	*/
	public native boolean closePty();
	/**	
		 Calls the above four close functions in a row.
		   		@short    Calls the above four close  functions in a row.
	*/
	public native void closeAll();
	/**	
		 Lets you see what your arguments are for debugging.
				@return the list of arguments
   
		@short    Lets you see what your arguments are for debugging.
	*/
	// const QValueList<QCString>& args(); >>>> NOT CONVERTED
	/**	
		 Controls whether the started process should drop any
		 setuid/setgid privileges or whether it should keep them.
		 Note that this function is mostly a dummy, as the KDE libraries
		 currently refuse to run with setuid/setgid privileges.
			 The default is false: drop privileges
			@param keepPrivileges true to keep the privileges
		   		@short    Controls whether the started process should drop any  setuid/setgid privileges or whether it should keep them.
	*/
	public native void setRunPrivileged(boolean keepPrivileges);
	/**	
		 Returns whether the started process will drop any
		 setuid/setgid privileges or whether it will keep them.
				@return true if the process runs privileged
   
		@short    Returns whether the started process will drop any  setuid/setgid privileges or whether it will keep them.
	*/
	public native boolean runPrivileged();
	/**	
		 Adds the variable <code>name</code> to the process' environment.
		 This function must be called before starting the process.
			@param name the name of the environment variable
			@param value the new value for the environment variable
		   		@short    Adds the variable <code>name</code> to the process' environment.
	*/
	public native void setEnvironment(String name, String value);
	/**	
		 Changes the current working directory (CWD) of the process
		 to be started.
		 This function must be called before starting the process.
			@param dir the new directory
		   		@short    Changes the current working directory (CWD) of the process  to be started.
	*/
	public native void setWorkingDirectory(String dir);
	/**	
		 Specify whether to start the command via a shell or directly.
		 The default is to start the command directly.
		 If <code>useShell</code> is true <code>shell</code> will be used as shell, or
		 if shell is empty, /bin/sh will be used.
			 When using a shell, the caller should make sure that all filenames etc.
		 are properly quoted when passed as argument.
			@param useShell true if the command should be started via a shell
			@param shell the path to the shell that will execute the process, or
		              0 to use /bin/sh. Use getenv("SHELL") to use the user's
		              default shell, but note that doing so is usually a bad idea
		              for shell compatibility reasons.
				@short    Specify whether to start the command via a shell or directly.
		@see #quote
	*/
	public native void setUseShell(boolean useShell, String shell);
	public native void setUseShell(boolean useShell);
	/**	
		 Detaches KProcess from child process. All communication is closed.
		 No exit notification is emitted any more for the child process.
		 Deleting the KProcess will no longer kill the child process.
		 Note that the current process remains the parent process of the
		 child process.
		   		@short    Detaches KProcess from child process.
	*/
	public native void detach();
	/**	
		 Specify whether to create a pty (pseudo-terminal) for running the
		 command.
		 This function should be called before starting the process.
			@param comm for which stdio handles to use a pty. Note that it is not
		  allowed to specify Stdout and Stderr at the same time both here and to
		 start (there is only one pty, so they cannot be distinguished).
			@param addUtmp true if a utmp entry should be created for the pty
				@short    Specify whether to create a pty (pseudo-terminal) for running the  command.
	*/
	public native void setUsePty(int comm, boolean addUtmp);
	/**	
		 Obtains the pty object used by this process. The return value is
		 valid only after setUsePty() was used to associate at least one
		 standard I/O stream to a pty. The pty is open only while the process
		 is running.
				@return a pointer to the pty object

		@short    Obtains the pty object used by this process.
	*/
	// KPty* pty(); >>>> NOT CONVERTED
	/**	
		 Sets the scheduling priority of the process.
			@param prio the new priority in the range -20 (high) to 19 (low).
				@return false on error; see setpriority(2) for possible reasons.

		@short    Sets the scheduling priority of the process.
	*/
	public native boolean setPriority(int prio);
	/**	
		 This function can be used to quote an argument string such that
		 the shell processes it properly. This is e. g. necessary for
		 user-provided file names which may contain spaces or quotes.
		 It also prevents expansion of wild cards and environment variables.
			@param arg the argument to quote
				@return the quoted argument

		@short    This function can be used to quote an argument string such that  the shell processes it properly.
	*/
	public static native String quote(String arg);
	/**	
		 Sets up the environment according to the data passed via
		 setEnvironment()
		   		@short    Sets up the environment according to the data passed via  setEnvironment()
	*/
	protected native void setupEnvironment();
	/**	
		 This function is called from start() right before a fork() takes
		 place. According to the <code>comm</code> parameter this function has to initialize
		 the in, out and err data members of KProcess.
			 This function should return 1 if setting the needed communication channels
		 was successful.
			 The default implementation is to create UNIX STREAM sockets for the
		 communication, but you could reimplement this function to establish a
		 TCP/IP communication for network communication, for example.
		   		@short    This function is called from start() right before a fork() takes  place.
	*/
	protected native int setupCommunication(int comm);
	/**	
		 Called right after a (successful) fork() on the parent side. This function
		 will usually do some communications cleanup, like closing in[0],
		 out[1] and out[1].
			 Furthermore, it must also create the QSocketNotifiers innot,
		 outnot and errnot and connect their Qt signals to the respective
		 KProcess slots.
			 For a more detailed explanation, it is best to have a look at the default
		 implementation in kprocess.cpp.
		   		@short    Called right after a (successful) fork() on the parent side.
	*/
	protected native int commSetupDoneP();
	/**	
		 Called right after a (successful) fork(), but before an exec() on the child
		 process' side. It usually duplicates the in[0], out[1] and
		 err[1] file handles to the respective standard I/O handles.
		   		@short    Called right after a (successful) fork(), but before an exec() on the child  process' side.
	*/
	protected native int commSetupDoneC();
	/**	
		 Immediately called after a successfully started process in NotifyOnExit
		 mode has exited. This function normally calls commClose()
		 and emits the processExited() signal.
			@param state the exit code of the process as returned by waitpid()
		   		@short    Immediately called after a successfully started process in NotifyOnExit  mode has exited.
	*/
	protected native void processHasExited(int state);
	/**	
		 Cleans up the communication links to the child after it has exited.
		 This function should act upon the values of pid() and runs.
		 See the kprocess.cpp source for details.
		
			<li>
			If pid() returns zero, the communication links should be closed
			  only.
			</li>
			
			<li>
			if pid() returns non-zero and runs is false, all data
			  immediately available from the communication links should be processed
			  before closing them.
			</li>
			
			<li>
			if pid() returns non-zero and runs is true, the communication
			  links should be monitored for data until the file handle returned by
			  KProcessController.theKProcessController.notifierFd() becomes ready
			  for reading - when it triggers, runs should be reset to false, and
			  the function should be immediately left without closing anything.
			</li>
				 The previous semantics of this function are forward-compatible, but should
		 be avoided, as they are prone to race conditions and can cause KProcess
		 (and thus the whole program) to lock up under certain circumstances. At the
		 end the function closes the communication links in any case. Additionally
		
			<li>
			if runs is true, the communication links are monitored for data
			  until all of them have returned EOF. Note that if any system function is
			  interrupted (errno == EINTR) the polling loop should be aborted.
			</li>
			
			<li>
			if runs is false, all data immediately available from the
			  communication links is processed.
			   
			</li>		@short    Cleans up the communication links to the child after it has exited.
	*/
	protected native void commClose();
	/**	
		 Specify the actual executable that should be started (first argument to execve)
		 Normally the the first argument is the executable but you can
		 override that with this function.
		   		@short    Specify the actual executable that should be started (first argument to execve)  Normally the the first argument is the executable but you can  override that with this function.
	*/
	protected native void setBinaryExecutable(String filename);
	/**	
		 Called by slotChildOutput() this function copies data arriving from
		 the child process' stdout to the respective buffer and emits the signal
		 receivedStdout().
		   		@short    Called by slotChildOutput() this function copies data arriving from  the child process' stdout to the respective buffer and emits the signal  receivedStdout().
	*/
	protected native int childOutput(int fdno);
	/**	
		 Called by slotChildError() this function copies data arriving from
		 the child process' stderr to the respective buffer and emits the signal
		 receivedStderr().
		   		@short    Called by slotChildError() this function copies data arriving from  the child process' stderr to the respective buffer and emits the signal  receivedStderr().
	*/
	protected native int childError(int fdno);
	/**	
		 This slot gets activated when data from the child's stdout arrives.
		 It usually calls childOutput().
			@param fdno the file descriptor for the output
		  		@short    This slot gets activated when data from the child's stdout arrives.
	*/
	protected native void slotChildOutput(int fdno);
	/**	
		 This slot gets activated when data from the child's stderr arrives.
		 It usually calls childError().
			@param fdno the file descriptor for the output
		  		@short    This slot gets activated when data from the child's stderr arrives.
	*/
	protected native void slotChildError(int fdno);
	/**	
		 Called when another bulk of data can be sent to the child's
		 stdin. If there is no more data to be sent to stdin currently
		 available, this function must disable the QSocketNotifier innot.
			@param dummy ignore this argument
		   		@short    Called when another bulk of data can be sent to the child's  stdin.
	*/
	protected native void slotSendData(int dummy);
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
