/***************************************************************************
                            kde_KPreviewWidgetBase.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KPREVIEWWIDGETBASE
#define KDE_KPREVIEWWIDGETBASE

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 Abstract baseclass for all preview widgets which shall be used via
 KFileDialog::setPreviewWidget(const KPreviewWidgetBase *).
 Ownership will be transferred to KFileDialog, so you have to create
 the preview with "new" and let KFileDialog delete it.

 Just derive your custom preview widget from KPreviewWidgetBase and implement
 all the pure virtual methods. The slot showPreview(const KURL &) is called
 every time the file selection changes.

 @author Frerich Raabe <raabe@kde.org>
 
 @short Abstract baseclass for all preview widgets.

*/

/** *
 This slot is called everytime the user selects another file in the
 file dialog. Implement the stuff necessary to reflect the change here.

*/
#ifdef __cplusplus
extern   "C" {
#endif
void kde_KPreviewWidgetBase_showPreview(kde_KPreviewWidgetBase* instPointer,kde_KURL* url);

/** *
 Reimplement this to clear the preview. This is called when e.g. the
 selection is cleared or when multiple selections exist, or the directory
 is changed.
     
*/
void kde_KPreviewWidgetBase_clearPreview(kde_KPreviewWidgetBase* instPointer);

#ifdef __cplusplus
}
#endif
#endif
