/***************************************************************************
                            kde_KCrash.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KCRASH
#define KDE_KCRASH

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 This class handles segmentation-faults.
 By default it displays a  message-box saying the application crashed.
 This default can be overridden by setting a custom crash handler with
 @ref setCrashHandler().
 If a function is specified with @ref setEmergencySaveFunction() it will
 be called by the default crash handler, giving the application a chance
 to save its data.
 
 @short *
 This class handles segmentation-faults.
*/

/** *
 This function type is a pointer to a crash handler function.
 The function's argument is the number of the signal.
   
*/
#ifdef __cplusplus
extern   "C" {
#endif

/** *
 The default crash handler.

*/
void kde_KCrash_defaultCrashHandler( int signal);

/** *
 Install a function to be called in case a SIGSEGV is caught.

*/

/** *
 Returns the installed crash handler.

*/

/** *
 Installs a function which should try to save the applications data.
 It is the crash handlers responsibility to call this function.
 Therefore, if no crash handler is set, the default crash handler
 is installed to ensure the save function is called.

*/

/** *
 Return the currently set emergency save function.

*/

/** *
 Sets the application @p path which should be passed to
 Dr. Konqi, our nice crash display application.

*/
void kde_KCrash_setApplicationPath( qt_QString * path);

/** *
 Sets the application name @p name which should be passed to
 Dr. Konqi, our nice crash display application.

*/
void kde_KCrash_setApplicationName( qt_QString * name);

#ifdef __cplusplus
}
#endif
#endif
