/***************************************************************************
                            kde_HTMLObjectElement.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_HTMLOBJECTELEMENT
#define KDE_HTMLOBJECTELEMENT

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 Generic embedded object. Note. In principle, all properties on the
 object element are read-write but in some environments some
 properties may be read-only once the underlying object is
 instantiated. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.html#edef-OBJECT">
 OBJECT element definition </a> in HTML 4.0.

 
 @short *
 Generic embedded object.
*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_HTMLObjectElement * kde_new_HTMLObjectElement();
kde_HTMLObjectElement * kde_new_HTMLObjectElement1(kde_HTMLObjectElement* other);
kde_HTMLObjectElement * kde_new_HTMLObjectElement2(kde_DOMNode* other);
void kde_del_HTMLObjectElement( kde_HTMLObjectElement* p );

/** *
 Returns the <code> FORM </code> element containing this
 control. Returns null if this control is not within the context
 of a form.

     
*/
kde_HTMLFormElement* kde_HTMLObjectElement_form(kde_HTMLObjectElement* instPointer);

/** *
 Applet class file. See the <code> code </code> attribute for
 HTMLAppletElement.

     
*/
kde_DOMString* kde_HTMLObjectElement_code(kde_HTMLObjectElement* instPointer);

/** *
 see @ref code
     
*/
void kde_HTMLObjectElement_setCode(kde_HTMLObjectElement* instPointer,kde_DOMString* arg1);

/** *
 Aligns this object (vertically or horizontally) with respect to
 its surrounding text. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-align-IMG">
 align attribute definition </a> in HTML 4.0. This attribute is
 deprecated in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLObjectElement_align(kde_HTMLObjectElement* instPointer);

/** *
 see @ref align
     
*/
void kde_HTMLObjectElement_setAlign(kde_HTMLObjectElement* instPointer,kde_DOMString* arg1);

/** *
 Space-separated list of archives. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-archive-OBJECT">
 archive attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLObjectElement_archive(kde_HTMLObjectElement* instPointer);

/** *
 see @ref archive
     
*/
void kde_HTMLObjectElement_setArchive(kde_HTMLObjectElement* instPointer,kde_DOMString* arg1);

/** *
 Width of border around the object. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-border">
 border attribute definition </a> in HTML 4.0. This attribute is
 deprecated in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLObjectElement_border(kde_HTMLObjectElement* instPointer);

/** *
 see @ref border
     
*/
void kde_HTMLObjectElement_setBorder(kde_HTMLObjectElement* instPointer,kde_DOMString* arg1);

/** *
 Base URI for <code> classid </code> , <code> data </code> , and
 <code> archive </code> attributes. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-codebase-OBJECT">
 codebase attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLObjectElement_codeBase(kde_HTMLObjectElement* instPointer);

/** *
 see @ref codeBase
     
*/
void kde_HTMLObjectElement_setCodeBase(kde_HTMLObjectElement* instPointer,kde_DOMString* arg1);

/** *
 Content type for data downloaded via <code> classid </code>
 attribute. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-codetype">
 codetype attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLObjectElement_codeType(kde_HTMLObjectElement* instPointer);

/** *
 see @ref codeType
     
*/
void kde_HTMLObjectElement_setCodeType(kde_HTMLObjectElement* instPointer,kde_DOMString* arg1);

/** *
 A URI specifying the location of the object's data. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-data">
 data attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLObjectElement_data(kde_HTMLObjectElement* instPointer);

/** *
 see @ref data
     
*/
void kde_HTMLObjectElement_setData(kde_HTMLObjectElement* instPointer,kde_DOMString* arg1);

/** *
 Declare (for future reference), but do not instantiate, this
 object. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-declare">
 declare attribute definition </a> in HTML 4.0.

     
*/
int kde_HTMLObjectElement_declare(kde_HTMLObjectElement* instPointer);

/** *
 see @ref declare
     
*/
void kde_HTMLObjectElement_setDeclare(kde_HTMLObjectElement* instPointer,int arg1);

/** *
 Override height. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-height-IMG">
 height attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLObjectElement_height(kde_HTMLObjectElement* instPointer);

/** *
 see @ref height
     
*/
void kde_HTMLObjectElement_setHeight(kde_HTMLObjectElement* instPointer,kde_DOMString* arg1);

/** *
 Horizontal space to the left and right of this image, applet,
 or object. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-hspace">
 hspace attribute definition </a> in HTML 4.0. This attribute is
 deprecated in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLObjectElement_hspace(kde_HTMLObjectElement* instPointer);

/** *
 see @ref hspace
     
*/
void kde_HTMLObjectElement_setHspace(kde_HTMLObjectElement* instPointer,kde_DOMString* arg1);

/** *
 Form control or object name when submitted with a form. See the
 <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-name-INPUT">
 name attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLObjectElement_name(kde_HTMLObjectElement* instPointer);

/** *
 see @ref name
     
*/
void kde_HTMLObjectElement_setName(kde_HTMLObjectElement* instPointer,kde_DOMString* arg1);

/** *
 Message to render while loading the object. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-standby">
 standby attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLObjectElement_standby(kde_HTMLObjectElement* instPointer);

/** *
 see @ref standby
     
*/
void kde_HTMLObjectElement_setStandby(kde_HTMLObjectElement* instPointer,kde_DOMString* arg1);

/** *
 Index that represents the element's position in the tabbing
 order. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-tabindex">
 tabindex attribute definition </a> in HTML 4.0.

     
*/
long kde_HTMLObjectElement_tabIndex(kde_HTMLObjectElement* instPointer);

/** *
 see @ref tabIndex
     
*/
void kde_HTMLObjectElement_setTabIndex(kde_HTMLObjectElement* instPointer,long arg1);

/** *
 Content type for data downloaded via <code> data </code>
 attribute. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-type-OBJECT">
 type attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLObjectElement_type(kde_HTMLObjectElement* instPointer);

/** *
 see @ref type
     
*/
void kde_HTMLObjectElement_setType(kde_HTMLObjectElement* instPointer,kde_DOMString* arg1);

/** *
 Use client-side image map. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-usemap">
 usemap attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLObjectElement_useMap(kde_HTMLObjectElement* instPointer);

/** *
 see @ref useMap
     
*/
void kde_HTMLObjectElement_setUseMap(kde_HTMLObjectElement* instPointer,kde_DOMString* arg1);

/** *
 Vertical space above and below this image, applet, or object.
 See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-vspace">
 vspace attribute definition </a> in HTML 4.0. This attribute is
 deprecated in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLObjectElement_vspace(kde_HTMLObjectElement* instPointer);

/** *
 see @ref vspace
     
*/
void kde_HTMLObjectElement_setVspace(kde_HTMLObjectElement* instPointer,kde_DOMString* arg1);

/** *
 Override width. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-width-IMG">
 width attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLObjectElement_width(kde_HTMLObjectElement* instPointer);

/** *
 see @ref width
     
*/
void kde_HTMLObjectElement_setWidth(kde_HTMLObjectElement* instPointer,kde_DOMString* arg1);

/** *
 Introduced in DOM Level 2

 Returns the document this iframe contains, if there is any and
 it is available, a Null document otherwise. The attribute is
 read-only.

*/
kde_Document* kde_HTMLObjectElement_contentDocument(kde_HTMLObjectElement* instPointer);

#ifdef __cplusplus
}
#endif
#endif
