/*
 * Copyright (C) 2003 Julian Rockey <kde@jrockey.com>
 */

#include "kdedcoptest.h"
#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>

static const char *description =
    I18N_NOOP("A KDE KPart Application");

static const char *version = "0.1";

static KCmdLineOptions options[] =
{
//    { "+[URL]", I18N_NOOP( "Document to open." ), 0 },
    { 0, 0, 0 }
};

int main(int argc, char **argv)
{
    KAboutData about("kdedcoptest", I18N_NOOP("KDEDcopTest"), version, description,
                     KAboutData::License_GPL, "(C) 2003 Julian Rockey", 0, 0, "kde@jrockey.com");
    about.addAuthor( "Julian Rockey", 0, "kde@jrockey.com" );
    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions( options );
    KApplication app;
    KDEDcopTest *mainWin = 0;

    if (app.isRestored())
    {
        RESTORE(KDEDcopTest);
    }
    else
    {
        // no session.. just start up normally
        KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

        // TODO: do something with the command line args here

        mainWin = new KDEDcopTest();
        app.setMainWidget( mainWin );
        mainWin->show();

        args->clear();
    }

    int ret = app.exec();

    delete mainWin;
    return ret;
}
