// Copyright (c) 2003 Charles Samuels <charles@kde.org>
// See the file COPYING for redistribution terms.

#include "view.h"
#include "oblique.h"

#include <noatun/app.h>

#include <kstdaction.h>
#include <klocale.h>
#include <kedittoolbar.h>
#include <kfiledialog.h>
#include <qlabel.h>

View::View(Oblique *oblique, Query *query)
	: KMainWindow(0, 0)
{
	mTree = new Tree(oblique, query, this);
	setCentralWidget(mTree);
	mTree->show();

	new KAction(i18n("Add &Files..."), "queue", 0, this, SLOT(addFiles()), actionCollection(), "add_files");
	new KAction(i18n("&Reload"), "reload", 0, oblique, SLOT(reload()), actionCollection(), "reload");
	{
		QLabel *l = new QLabel(i18n("&Jump:"), 0, "kde toolbar widget");
		l->setBackgroundMode( Qt::PaletteButton );
		l->setAlignment(
				(QApplication::reverseLayout() ? Qt::AlignRight : Qt::AlignLeft) |
		                   Qt::AlignVCenter | Qt::ShowPrefix
			);
		l->adjustSize();
		new KWidgetAction(l, i18n("&Jump:"), KShortcut(ALT + Key_J), 0, 0, actionCollection(), "jump_label");

		LineEditAction *jumpAction = new LineEditAction(i18n("Jump Bar"), 0, 0, actionCollection(), "jump_text");
		l->setBuddy(jumpAction->lineEdit());
		connect(jumpAction->lineEdit(), SIGNAL(textChanged(const QString&)), SLOT(jumpTextChanged(const QString&)));
	}

	KStdAction::configureToolbars(this, SLOT(configureToolBars()), actionCollection());

	applyMainWindowSettings(KGlobal::config(), "Oblique View");
	createGUI("obliqueui.rc");
}

void View::configureToolBars()
{
	saveMainWindowSettings(KGlobal::config(), "Oblique View");
	KEditToolbar dlg(actionCollection(), "obliqueui.rc");
	connect(&dlg, SIGNAL(newToolbarConfig()), SLOT(newToolBarConfig()));
	dlg.exec();
}

void View::newToolBarConfig()
{
	createGUI("obliqueui.rc");
	applyMainWindowSettings(KGlobal::config(), "Oblique View");
}

void View::closeEvent(QCloseEvent*)
{
	hide();
}


void View::addFiles()
{
	KURL::List files=KFileDialog::getOpenURLs(":mediadir", napp->mimeTypes(), this, i18n("Select Files to Add"));

	for(KURL::List::Iterator it=files.begin(); it!=files.end(); ++it)
		mTree->oblique()->addFile(KURL(*it));
}

void View::jumpTextChanged(const QString &text)
{
	mTree->setLimit(text);
}


LineEditAction::LineEditAction(const QString &text, const QObject *reciever, const char *slot, KActionCollection *parent, const char *name)
	: KWidgetAction(new KLineEdit(0), text, KShortcut(0), reciever, slot, parent, name)
{
	setAutoSized(true);
}

#include "view.moc"

