/*
 *  Copyright (C) 2000, 2001, 2002 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "bookmarks-add-dialog.h"
#include "popup-commands.h"
#include "galeon-action.h"
#include "galeon-shell.h"
#include "galeon-embed-popup.h"

static GaleonWindow *
get_window_from_popup (GaleonPopup *popup)
{
	return GALEON_WINDOW (g_object_get_data(G_OBJECT(popup), "GaleonWindow"));
}

void popup_cmd_new_window (GtkAction *action, 
			   GaleonPopup *popup)
{
	GaleonEmbedEvent *info;
	GaleonTab *tab;
	const GValue *value;

	tab = galeon_window_get_active_tab (get_window_from_popup (popup));
	
	info = galeon_popup_get_event (popup);
	
	galeon_embed_event_get_property (info, "link", &value);
	
	galeon_shell_new_tab (galeon_shell, NULL, tab, 
			      g_value_get_string (value), 
			      GALEON_NEW_TAB_IN_NEW_WINDOW);
}

void popup_cmd_new_tab (GtkAction *action, 
			GaleonPopup *popup)
{
	GaleonEmbedEvent *info;
	GaleonTab *tab;
	GaleonWindow *window;
	const GValue *value;

	window = get_window_from_popup (popup);
	g_return_if_fail (window != NULL);
	
	tab = galeon_window_get_active_tab (window);
	
	info = galeon_popup_get_event (popup);
	
	galeon_embed_event_get_property (info, "link", &value);
	
	galeon_shell_new_tab (galeon_shell, window, tab, 
			      g_value_get_string (value), 
			      GALEON_NEW_TAB_IN_EXISTING_WINDOW);
}

void popup_cmd_image_in_new_tab (GtkAction *action, 
				 GaleonPopup *popup)
{
	GaleonEmbedEvent *info;
	GaleonTab *tab;
	GaleonWindow *window;
	const GValue *value;

	window = get_window_from_popup (popup);
	g_return_if_fail (window != NULL);
	
	tab = galeon_window_get_active_tab (window);
	
	info = galeon_popup_get_event (popup);
	
	galeon_embed_event_get_property (info, "image", &value);
	
	galeon_shell_new_tab (galeon_shell, window, tab, 
			      g_value_get_string (value), 
			      GALEON_NEW_TAB_IN_EXISTING_WINDOW);
}

void popup_cmd_image_in_new_window (GtkAction *action, 
				    GaleonPopup *popup)
{
	GaleonEmbedEvent *info;
	GaleonTab *tab;
	const GValue *value;

	tab = galeon_window_get_active_tab (get_window_from_popup (popup));
	
	info = galeon_popup_get_event (popup);
	
	galeon_embed_event_get_property (info, "image", &value);
	
	galeon_shell_new_tab (galeon_shell, NULL, tab, 
			      g_value_get_string (value), 
			      GALEON_NEW_TAB_IN_NEW_WINDOW);
}

void popup_cmd_image_block_site(GtkAction *action, 
				GaleonPopup *popup)
{
	GaleonEmbedEvent *info;
	GaleonEmbedShell *embed_shell;
	const GValue *value;
	PermissionActionType perm_action;

	embed_shell = galeon_shell_get_embed_shell(galeon_shell);
	
	info = galeon_popup_get_event(popup);
	
	galeon_embed_event_get_property(info, "image", &value);

	galeon_embed_shell_test_permission(embed_shell,
					   g_value_get_string(value),
					   IMAGES_PERMISSION,
					   &perm_action);
	if (perm_action == DENY_ACTION)
	{
		galeon_embed_shell_set_permission(embed_shell,
						  g_value_get_string(value),
						  IMAGES_PERMISSION,
						  TRUE);
	}
	else
	{
		galeon_embed_shell_set_permission(embed_shell,
						  g_value_get_string(value),
						  IMAGES_PERMISSION,
						  FALSE);
	}
}

void popup_cmd_add_bookmark (GtkAction *action, 
			     GaleonPopup *popup)
{
	GaleonEmbedEvent *info = galeon_popup_get_event (popup);
	const GValue *link_title;
	const GValue *link;
	const GValue *link_is_smart;
	const GValue *link_rel;
	const GValue *link_text;
	const char *title;
	const char *location;
	const char *smart_loc;
	gboolean smart_site = FALSE;
	GbBookmarkSet *set;
	GbSite *b;
	GaleonDialog *dialog;
	GSList *list = NULL;

	GaleonWindow *window = get_window_from_popup(popup);
	g_return_if_fail (window != NULL);

	galeon_embed_event_get_property (info, "link", &link);
	galeon_embed_event_get_property (info, "link_title", &link_title);
	galeon_embed_event_get_property (info, "link_is_smart", &link_is_smart);
	galeon_embed_event_get_property (info, "link_rel", &link_rel);
	galeon_embed_event_get_property (info, "link_text", &link_text);
	
	title      = g_value_get_string (link_title);
	location   = g_value_get_string (link);
	smart_loc  = g_value_get_string (link_rel);
	smart_site = g_value_get_int (link_is_smart);

	g_return_if_fail (location);
	
	if (title == NULL || title[0] == '\0')
	{
		title = g_value_get_string (link_text);
	}

	if (title == NULL || title[0] == '\0')
	{
		title = location;
	}

	set = galeon_shell_get_bookmark_set (galeon_shell);
	g_return_if_fail (set);

	if (!smart_site)
	{
		b = gb_site_new (set, title, location);
	}
	else
	{
		b = GB_SITE (gb_smart_site_new (set, title, 
						location, smart_loc));
		/* TODO add image saving support */
	}

	list = g_slist_append(list, b);

	dialog = gb_add_dialog_new(GTK_WIDGET(window), set, list);

	galeon_dialog_show(dialog);
}

void popup_cmd_frame_in_new_tab (GtkAction *action, 
				 GaleonPopup *popup)
{
	GaleonTab *tab;
	GaleonWindow *window;
	GaleonEmbed *embed;
	char *location;
	
	window = get_window_from_popup (popup);
	g_return_if_fail (window != NULL);

	tab = galeon_window_get_active_tab (window);

	embed = galeon_window_get_active_embed (window);
	
	galeon_embed_get_location (embed, FALSE, FALSE, &location);
	
	galeon_shell_new_tab (galeon_shell, window, tab, 
			      location, 
			      GALEON_NEW_TAB_IN_EXISTING_WINDOW);

	g_free (location);
}

void popup_cmd_frame_in_new_window (GtkAction *action, 
				    GaleonPopup *popup)
{
	GaleonTab *tab;
	GaleonEmbed *embed;
	GaleonWindow *window;
	char *location;
	
	window = get_window_from_popup (popup);
	g_return_if_fail (window != NULL);
	
	tab = galeon_window_get_active_tab (window);

	embed = galeon_window_get_active_embed (window);
	
	galeon_embed_get_location (embed, FALSE, FALSE, &location);
	
	galeon_shell_new_tab (galeon_shell, NULL, tab, 
			      location, 
			      GALEON_NEW_TAB_IN_NEW_WINDOW);

	g_free (location);	
}

void popup_cmd_add_frame_bookmark (GtkAction *action, 
				   GaleonPopup *popup)
{
	GaleonTab *tab;
	GaleonEmbed *embed;
	char *location;
	char *title;
	GbSite *b;
	GbBookmarkSet *set;
	GaleonDialog *dialog;
	GSList *list = NULL;

	GaleonWindow *window = get_window_from_popup(popup);
	g_return_if_fail(window != NULL);

	set = galeon_shell_get_bookmark_set(galeon_shell);
	g_return_if_fail(set);
	
	tab = galeon_window_get_active_tab(window);

	embed = galeon_window_get_active_embed(window);
	
	galeon_embed_get_location(embed, FALSE, FALSE, &location);

	galeon_embed_get_title(embed, &title);

	b = gb_site_new (set, title, location);

	g_free(location);
	g_free(title);

	list = g_slist_append(list, b);

	dialog = gb_add_dialog_new(GTK_WIDGET(window), set, list);

	galeon_dialog_show(dialog);
}

void popup_cmd_view_source (GtkAction *action, 
			    GaleonPopup *popup)
{
	GaleonWindow *window;
	GaleonEmbed *embed;

	window = get_window_from_popup (popup);
	embed = galeon_popup_get_embed (popup);

	galeon_shell_new_tab_from_embed
		(galeon_shell, window, embed, NULL,
		 GALEON_NEW_TAB_VIEW_SOURCE);
}
