.\" -*- nroff -*-
.tr \(ts"
.TH RAST 1
.SH NAME
rast \- translate output of sgmls to RAST format
.SH SYNOPSIS
.B rast
[
.BI \-o output_file
]
[
.I input_file
]
.SH DESCRIPTION
.I Rast
translates the output of sgmls to the format of a RAST result.
RAST is the Reference Application for SGML Testing defined in the Proposed
American National Standard on Conformance Testing for Standard Generalized
Markup Language (SGML) Systems (X3.190-199X).
.I Rast
reads from
.I input_file
or from standard input if
.I input_file
is not specified.
It writes to
.I output_file
or to standard output if
.I output_file
is not specified;
use of the
.B \-o
option avoids the need for
.I rast
to use a temporary file.
.LP
Note that the
.B -c
option of
.I sgmls
can generate a capacity report in RACT format.
.SH BUGS
Production [9] in clause 14.5.5 of the draft standard is clearly wrong;
.I rast
corrects it by appending
.RI `,\ LE '.
An alternative way to correct it would be to delete the
.RB `, \(tsEND-ENTITY\(ts '.
.LP
In production [18] in clause 14.5.9,
.RI ` markup\ data +'
should be
.RI ` markup\ data *'
since internal sdata entities need not contain any characters (14.5.11),
and
.I markup\ data
cannot be empty (14.5.9, 14.5.12).
.LP
The RAST result for the example in Annex B.4 is incorrect.
The line
.B G03-A1=
should be immediately followed by a line
.BR !g03-e1! .
(The problem with production [9] also applies to this example.)
.LP
.I Rast
outputs a newline after
.B #ERROR
in order to avoid producing files with partial lines.
.SH "SEE ALSO"
.IR sgmls (1)
.br
.I
Conformance Testing for Standard Generalized Markup Language (SGML) Systems,
(X3.190-199X), Draft July 1991
