/*
 * tools_p.cpp
 *
 * Copyright (c) 2001, 2002, 2003 Frerich Raabe <raabe@kde.org>
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. For licensing and distribution details, check the
 * accompanying file 'COPYING'.
 */
#include "tools_p.h"

#include <kcharsets.h>
#include <kglobal.h>

#include <qdom.h>

QString RSS::decodeEntities(const QString &s)
{
	QString result = s;
	result.replace(QString::fromLatin1("&amp"), QString::fromLatin1("&"));
	for (int p = result.find(QString::fromLatin1("&")); p >= 0; p = result.find(QString::fromLatin1("&"), p)) {
		int q = result.find(QString::fromLatin1(";"), p++);
		if (q != -1)
			result.replace(p - 1, q - p + 2, KGlobal::charsets()->fromEntity(result.mid(p, q - p))); 
	}
	return result;
}

QString RSS::extractNode(const QDomNode &parent, const QString &elemName, bool entities)
{
	QString result;
	QDomNode node = parent.namedItem(elemName);
	if (!node.isNull()) {
		result = node.toElement().text().simplifyWhiteSpace();
		if (entities)
			result = RSS::decodeEntities(result);
		if (result.isEmpty())
			result = QString::null;
	}
	return result;
}

// vim:noet:ts=4
