/* AMD pp. 249 - 251
 * Two factors crossed, another nested within
 * levels of one crossed factor
 */

#include <dap.h>

void main()
{ 
  infile("amd249.dat", " ")
    {
      char a[2], b[2], c[2];
      double y, y2[2];
      input("b c a y2");
      outset("amd249", "a b c y");
      skip(1);
      while (step())
        {
          y = y2[0];
          output();
          y = y2[1];
          output();
        }
    }

  sort("amd249", "a b c", "");
  means("amd249.srt", "y", "N MEAN VAR", "a b c");

  effects("amd249.srt.mns", "y a b c", "a b a*b c*b a*c*b", "");

  ftest("amd249.srt.mns.con", "y a b c", "a", "a*b*c", "");
  lsmeans("amd249.srt.mns.tst", "LSD", 0.05, "y a b c", "a", "", "7.3");

  ftest("amd249.srt.mns.con", "y a b c", "b", "b*c a*b*c", "");
  lsmeans("amd249.srt.mns.tst", "LSD", 0.05, "y a b c", "b", "", "7.3");

  ftest("amd249.srt.mns.con", "y a b c", "a*b", "a*b*c", "");
  ftest("amd249.srt.mns.con", "y a b c", "c*b", "a*b*c", "");
  ftest("amd249.srt.mns.con", "y a b c", "a*c*b", "", "");
}
