BEGIN;
SELECT _v.register_patch('exchange-0003', NULL, NULL);
SET search_path TO exchange;
CREATE FUNCTION create_table_kyc_targets(
  IN partition_suffix TEXT DEFAULT NULL
)
RETURNS VOID
LANGUAGE plpgsql
AS $$
DECLARE
  my_rec RECORD;
  my_payto TEXT;
  my_is_wallet BOOL;
  wtc CURSOR FOR
   SELECT
     access_token
    ,target_pub
    ,h_normalized_payto
    ,aml_program_lock_timeout
    ,payto_uri
     FROM exchange.wire_targets;
BEGIN
  PERFORM create_partitioned_table(
    'CREATE TABLE %I'
      '(kyc_target_serial_id BIGINT GENERATED BY DEFAULT AS IDENTITY'
      ',h_normalized_payto BYTEA PRIMARY KEY CHECK(LENGTH(h_normalized_payto)=32)'
      ',access_token BYTEA CHECK(LENGTH(access_token)=32)'
      ' DEFAULT random_bytea(32)'
      ',target_pub BYTEA CHECK(LENGTH(target_pub)=32) DEFAULT NULL'
      ',aml_program_lock_timeout INT8 DEFAULT NULL'
      ',is_wallet BOOL'
    ') %s ;'
    ,'kyc_targets'
    ,'PARTITION BY HASH (h_normalized_payto)'
    ,partition_suffix
  );
  PERFORM comment_partitioned_table(
     'All identities for KYC purposes based on normalized payto URIs'
    ,'kyc_targets'
    ,partition_suffix
  );
  PERFORM comment_partitioned_column(
     'high-entropy random value that is used as a bearer token used to authenticate access to the KYC SPA and its state (without requiring a signature)'
    ,'access_token'
    ,'kyc_targets'
    ,NULL
  );
  PERFORM comment_partitioned_column(
     'Public key of a merchant instance or reserve to authenticate access; NULL if KYC is not allowed for the account (if there was no incoming KYC wire transfer yet); updated, thus NOT available to the auditor'
    ,'target_pub'
    ,'kyc_targets'
    ,NULL
  );
  PERFORM comment_partitioned_column(
     'hash over the normalized payto URI for this account; used for KYC operations'
    ,'h_normalized_payto'
    ,'kyc_targets'
    ,NULL
  );
  PERFORM comment_partitioned_column(
     'If non-NULL, an AML program should be running and it holds a lock on this account, thus other AML programs should not be started concurrently. Given the possibility of crashes, the lock automatically expires at the time value given in this column. At that time, the lock can be considered stale.'
    ,'aml_program_lock_timeout'
    ,'kyc_targets'
    ,NULL
  );
  PERFORM comment_partitioned_column(
     'True if this KYC account is for a wallet, false if it is for a bank account'
    ,'is_wallet'
    ,'kyc_targets'
    ,NULL
  );
  FOR my_rec IN wtc
  LOOP
    my_payto = my_rec.payto_uri;
    my_is_wallet
      = (LOWER (SUBSTRING (my_payto, 22)) =
         'payto://taler-reserve/') OR
        (LOWER (SUBSTRING (my_payto, 27)) =
         'payto://taler-reserve-http/');
    INSERT INTO kyc_targets
      (h_normalized_payto
      ,access_token
      ,target_pub
      ,aml_program_lock_timeout
      ,is_wallet
      ) VALUES (
       my_rec.h_normalized_payto
      ,my_rec.access_token
      ,my_rec.target_pub
      ,my_rec.aml_program_lock_timeout
      ,my_is_wallet
      )
      ON CONFLICT DO NOTHING;
  END LOOP;
END $$;
CREATE FUNCTION constrain_table_kyc_targets(
  IN partition_suffix TEXT
)
RETURNS void
LANGUAGE plpgsql
AS $$
DECLARE
  table_name TEXT DEFAULT 'kyc_targets';
BEGIN
  table_name = concat_ws('_', table_name, partition_suffix);
  EXECUTE FORMAT (
    'ALTER TABLE ' || table_name ||
    ' ADD CONSTRAINT ' || table_name || '_kyc_target_serial_id_key'
    ' UNIQUE (kyc_target_serial_id)'
  );
  EXECUTE FORMAT (
    'ALTER TABLE ' || table_name ||
    ' ADD CONSTRAINT ' || table_name || '_kyc_target_access_token_unique'
    ' UNIQUE (access_token)'
  );
END
$$;
INSERT INTO exchange_tables
    (name
    ,version
    ,action
    ,partitioned
    ,by_range)
  VALUES
    ('kyc_targets'
    ,'exchange-0003'
    ,'create'
    ,TRUE
    ,FALSE),
    ('kyc_targets'
    ,'exchange-0003'
    ,'constrain'
    ,TRUE
    ,FALSE);
CREATE FUNCTION foreign_table_legitimization_measures3()
RETURNS void
LANGUAGE plpgsql
AS $$
DECLARE
  table_name TEXT DEFAULT 'legitimization_measures';
BEGIN
  EXECUTE FORMAT (
    'ALTER TABLE ' || table_name ||
    ' DROP CONSTRAINT ' || table_name || '_foreign_key_access_token');
  EXECUTE FORMAT (
    'ALTER TABLE ' || table_name ||
    ' ADD CONSTRAINT ' || table_name || '_foreign_key_access_token'
    ' FOREIGN KEY (access_token)'
    ' REFERENCES kyc_targets (access_token)'
    '  ON DELETE CASCADE');
END
$$;
INSERT INTO exchange_tables
    (name
    ,version
    ,action
    ,partitioned
    ,by_range)
  VALUES
    ('legitimization_measures3'
    ,'exchange-0003'
    ,'foreign'
    ,TRUE
    ,FALSE);
CREATE FUNCTION foreign_table_legitimization_outcomes3()
RETURNS void
LANGUAGE plpgsql
AS $$
DECLARE
  table_name TEXT DEFAULT 'legitimization_outcomes';
BEGIN
  EXECUTE FORMAT (
    'ALTER TABLE ' || table_name ||
    ' ADD CONSTRAINT ' || table_name || '_foreign_key_h_payto'
    ' FOREIGN KEY (h_payto)'
    ' REFERENCES kyc_targets (h_normalized_payto)'
    '  ON DELETE CASCADE');
END
$$;
INSERT INTO exchange_tables
    (name
    ,version
    ,action
    ,partitioned
    ,by_range)
  VALUES
    ('legitimization_outcomes3'
    ,'exchange-0003'
    ,'foreign'
    ,TRUE
    ,FALSE);
CREATE FUNCTION foreign_table_legitimization_processes3()
RETURNS void
LANGUAGE plpgsql
AS $$
DECLARE
  table_name TEXT DEFAULT 'legitimization_processes';
BEGIN
  EXECUTE FORMAT (
    'ALTER TABLE ' || table_name ||
    ' ADD CONSTRAINT ' || table_name || '_foreign_key_h_payto'
    ' FOREIGN KEY (h_payto)'
    ' REFERENCES kyc_targets (h_normalized_payto)'
    '  ON DELETE CASCADE');
END
$$;
INSERT INTO exchange_tables
    (name
    ,version
    ,action
    ,partitioned
    ,by_range)
  VALUES
    ('legitimization_processes3'
    ,'exchange-0003'
    ,'foreign'
    ,TRUE
    ,FALSE);
CREATE FUNCTION alter_table_wire_targets3()
RETURNS VOID
LANGUAGE plpgsql
AS $$
BEGIN
  ALTER TABLE wire_targets
    DROP COLUMN access_token,
    DROP COLUMN aml_program_lock_timeout,
    DROP COLUMN target_pub;
END $$;
CREATE FUNCTION foreign_table_wire_targets3()
RETURNS void
LANGUAGE plpgsql
AS $$
DECLARE
  table_name TEXT DEFAULT 'wire_targets';
BEGIN
  EXECUTE FORMAT (
    'ALTER TABLE ' || table_name ||
    ' ADD CONSTRAINT ' || table_name || '_fk_kyc_targets'
    ' FOREIGN KEY (h_normalized_payto) REFERENCES kyc_targets (h_normalized_payto)'
  );
END
$$;
INSERT INTO exchange_tables
    (name
    ,version
    ,action
    ,partitioned
    ,by_range)
  VALUES
    ('wire_targets3'
    ,'exchange-0003'
    ,'alter'
    ,TRUE
    ,FALSE),
    ('wire_targets3'
    ,'exchange-0003'
    ,'foreign'
    ,TRUE
    ,FALSE);
CREATE FUNCTION master_table_reserves_out3()
RETURNS void
LANGUAGE plpgsql
AS $$
BEGIN
  DROP TABLE IF EXISTS reserves_out;
END $$;
COMMENT ON FUNCTION master_table_reserves_out3()
  IS 'Deletes the obsolete reserves_out table.';
INSERT INTO exchange_tables
    (name
    ,version
    ,action
    ,partitioned
    ,by_range)
  VALUES
    ('reserves_out3'
    ,'exchange-0003'
    ,'master'
    ,TRUE
    ,FALSE);
COMMIT;
