# GNU Solfege - ear training for GNOME
# Copyright (C) 2000, 2001, 2002, 2003, 2004  Tom Cato Amundsen
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import gtk
import sys

class TracebackWindow(gtk.Dialog):
    def __init__(self):
        gtk.Dialog.__init__(self)
        self.set_default_size(630, 400)
        self.vbox.set_border_width(8)
        label = gtk.Label(_("GNU Solfege message window"))
        label.set_name('Heading2')
        self.vbox.pack_start(label, False)
        label = gtk.Label(_("Please report to bug-solfege@gnu.org if the content of the message make you believe you have found a bug."))
        label.set_line_wrap(True)
        self.vbox.pack_start(label, False)
        scrollwin = gtk.ScrolledWindow()
        scrollwin.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
        self.vbox.pack_start(scrollwin)
        self.g_text = gtk.TextView()
        scrollwin.add(self.g_text)
        self.g_close = gtk.Button(stock='gtk-close')
        self.action_area.pack_start(self.g_close)
        self.g_close.connect('clicked', lambda w: self.hide())
    def write(self, txt):
        if "DeprecationWarning:" in txt:
            print txt
            return
        sys.stdout.write(txt)
        self.show_all()
        buffer = self.g_text.get_buffer()
        buffer.insert(buffer.get_end_iter(), txt)
        self.set_focus(self.g_close)
    def flush(self, *v):
        pass
    def close(self, *v):
        pass
