# GNU Solfege - ear training for GNOME
# Copyright (C) 2000, 2001, 2002, 2003, 2004  Tom Cato Amundsen
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin ST, Fifth Floor, Boston, MA  02110-1301  USA
#

# gnome emu

import gtk
from uiconsts import *
import uiconsts
from src import gu

class App(gtk.Window):
    def __init__(self, a, b):
        gtk.Window.__init__(self, gtk.WINDOW_TOPLEVEL)
        self._cid = 4
        self.__vbox = gtk.VBox()
        self.add(self.__vbox)
        self.__menubox = gu.bHBox(self.__vbox, False)
        self.__toolbarbox = gu.bHBox(self.__vbox, False)
        self.__contentsbox = gu.bVBox(self.__vbox)
        self.__appbarbox = gu.bHBox(self.__vbox, False)
        self.__dockitems = {}
    def show(self):
        self.__vbox.show()
        self.__menubox.show()
        self.__toolbarbox.show()
        self.__contentsbox.show()
        self.__appbarbox.show()
        gtk.Window.show(self)
    def set_statusbar(self, bar):
        self.__appbarbox.pack_start(bar)
        bar.show()
        self.__appbar = bar
    def set_contents(self, c):
        self.__contentsbox.pack_start(c)
    def set_menus(self, menu):
        hdlbox = gtk.HandleBox()
        hdlbox.show()
        self.__dockitems['Menubar'] = hdlbox

        self.__menubox.pack_start(hdlbox, True, True)
        hdlbox.add(menu)
        menu.show()
    def add_toolbar(self, toolbar, name, behavior, placement, band_num,
                    band_position, offset):
        hdlbox = gtk.HandleBox()
        hdlbox.show()
        self.__dockitems[name] = hdlbox
        self.__toolbarbox.pack_start(hdlbox)
        self.__toolbarbox.reorder_child(hdlbox, offset)
        hdlbox.add(toolbar)
        toolbar.show()
    def get_dock_item_by_name(self, name):
        return self.__dockitems[name]

class GnomeCanvas(gtk.Label):
    def __init__(self):
        gtk.Label.__init__(self, "Not on windows")
        self.show()
    def root(self): pass

class _ContribDialog(gtk.Dialog):
    def __init__(self, name, authors, documenters, translators):
        gtk.Dialog.__init__(self, 'About %s' % name, None, 0, ('gtk-close', 1))
        nb = gtk.Notebook()
        nb.set_border_width(uiconsts.PAD)
        self.vbox.pack_start(nb)
        vbox = gtk.VBox()
        vbox.set_border_width(uiconsts.PAD)
        for s in authors:
            l = gtk.Label(s)
            l.set_alignment(0, 0)
            vbox.pack_start(l, False)
        nb.append_page(vbox, gtk.Label(_('Written by')))
        vbox = gtk.VBox()
        vbox.set_border_width(uiconsts.PAD)
        for s in documenters:
            l = gtk.Label(s)
            l.set_alignment(0, 0)
            vbox.pack_start(l, False)
        nb.append_page(vbox, gtk.Label(_('Documented by')))
        vbox = gtk.VBox()
        vbox.set_border_width(uiconsts.PAD)
        l = gtk.Label(translators)
        l.set_alignment(0, 0)
        vbox.pack_start(l, False)
        nb.append_page(vbox, gtk.Label(_('Translated by')))
        self.get_children()[0].get_children()[-1].get_children()[0].grab_focus()

class About(gtk.Dialog):
    def __init__(self, name, version, copyright, text, authors,
             documenters, translators, pixmap):
        gtk.Dialog.__init__(self, 'About %s' % name, None, 0)
        self.add_button(_('C_redits'), 2)
        self.add_button(gtk.STOCK_CLOSE, 1)
        self.m_name = name
        self.m_authors = authors
        self.m_documenters = documenters
        self.m_translators = translators

        self.vbox.set_border_width(uiconsts.PAD_SMALL)
        self.vbox.set_spacing(uiconsts.PAD)
        im = gtk.Image()
        im.set_from_pixbuf(pixmap)
        self.vbox.pack_start(im)

        label = gtk.Label('<span size="xx-large">%s %s</span>' % (name, version))
        label.set_use_markup(1)
        self.vbox.pack_start(label)

        label = gtk.Label(text)
        label.set_line_wrap(gtk.WRAP_WORD)
        self.vbox.pack_start(label)

        s = copyright.replace("<", "&lt;").replace(">", "&gt;")
        label = gtk.Label('<span size="smaller">%s</span>' % s)
        label.set_use_markup(1)
        self.vbox.pack_start(label)
        self.get_children()[0].get_children()[-1].get_children()[0].grab_focus()
    def run(self):
        self.show_all()
        while 1:
            i = gtk.Dialog.run(self)
            if i == 1:
               break
            if i == 2:
                self.run_contributers_dialog()
        self.hide()
        return i
    def run_contributers_dialog(self):
        d = _ContribDialog(self.m_name, self.m_authors,
                           self.m_documenters, self.m_translators)
        d.show_all()
        d.run()
        d.destroy()
