##
##  move -- Move files with simultan substitution
##  Copyright (c) 1999 Ralf S. Engelschall <rse@engelschall.com>
##  Originally written for shtool
##
##  This file is part of shtool and free software; you can redistribute
##  it and/or modify it under the terms of the GNU General Public
##  License as published by the Free Software Foundation; either version
##  2 of the License, or (at your option) any later version.
##
##  This file is distributed in the hope that it will be useful,
##  but WITHOUT ANY WARRANTY; without even the implied warranty of
##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
##  General Public License for more details.
##
##  You should have received a copy of the GNU General Public License
##  along with this program; if not, write to the Free Software
##  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
##  USA, or contact Ralf S. Engelschall <rse@engelschall.com>.
##

str_tool="move"
str_usage="[-v] [-t] [-e] [-p] <src-file> <dst-file>"
arg_spec="2"
opt_spec="vtep"

. ./sh.common

src="$1"
dst="$2"

#   consistency checks
if [ ".$src" = . -o ".$dst" = . ]; then
    echo "$msgprefix:Error: Invalid arguments" 1>&2
    exit 1
fi
if [ ".$src" = ".$dst" ]; then
    echo "$msgprefix:Error: Source and destination files are the same" 1>&2
    exit 1
fi
expsrc="$src"
if [ ".$opt_e" = .yes ]; then
    expsrc="`echo $expsrc`"
fi
if [ ".$opt_e" = .yes ]; then
    if [ ".`echo "$src" | sed -e 's;^.*\\*.*$;;'`" = ".$src" ]; then
        echo "$msgprefix:Error: Source doesn't contain wildcard ('*'): $dst" 1>&2
        exit 1
    fi
    if [ ".`echo "$dst" | sed -e 's;^.*%[1-9].*$;;'`" = ".$dst" ]; then
        echo "$msgprefix:Error: Destination doesn't contain substitution ('%N'): $dst" 1>&2
        exit 1
    fi
    if [ ".$expsrc" = ".$src" ]; then
        echo "$msgprefix:Error: Sources not found or no asterisk : $src" 1>&2
        exit 1
    fi
else
    if [ ! -r "$src" ]; then
        echo "$msgprefix:Error: Source not found: $src" 1>&2
        exit 1
    fi
fi

#   determine substitution patterns
if [ ".$opt_e" = .yes ]; then
    srcpat=`echo "$src" | sed -e 's/\\./\\\\./g' -e 's/;/\\;/g' -e 's;\\*;\\\\(.*\\\\);g'`
    dstpat=`echo "$dst" | sed -e 's;%\([1-9]\);\\\\\1;g'`
fi

#   iterate over source(s)
for onesrc in $expsrc; do
    if [ .$opt_e = .yes ]; then
        onedst=`echo $onesrc | sed -e "s;$srcpat;$dstpat;"`
    else
        onedst="$dst"
    fi
    errorstatus=0
    if [ ".$opt_v" = .yes ]; then
        echo "$onesrc -> $onedst"
    fi
    if [ ".$opt_p" = .yes ]; then
        if [ -r $onedst ]; then
            if cmp -s $onesrc $onedst; then
                if [ ".$opt_t" = .yes ]; then
                    echo "rm -f $onesrc" 1>&2
                fi
                rm -f $onesrc || errorstatus=$?
            else
                if [ ".$opt_t" = .yes ]; then
                    echo "mv -f $onesrc $onedst" 1>&2
                fi
                mv -f $onesrc $onedst || errorstatus=$?
            fi
        else
            if [ ".$opt_t" = .yes ]; then
                echo "mv -f $onesrc $onedst" 1>&2
            fi
            mv -f $onesrc $onedst || errorstatus=$?
        fi
    else
        if [ ".$opt_t" = .yes ]; then
            echo "mv -f $onesrc $onedst" 1>&2
        fi
        mv -f $onesrc $onedst || errorstatus=$?
    fi
    if [ $errorstatus -ne 0 ]; then
        break;
    fi
done
exit $errorstatus

