/*  Motti -- a strategy game
    Copyright (C) 1999-2010 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
// otti.cpp: dfinit le point d'entre pour l'application console.
//
#include <vector>
#include "StdAfx.h"
#include "BoardTest.h"
#include "MapManagerTest.h"
#include "MottiRulesManagerTest.h"
#include "StringDrawerTest.h"
#include "GameManagerTest.h"

#include <iostream>
#ifdef WIN32
#include <windows.h>
#endif 
#include "MapManager.h"
#include "GameManager.h"
#include "StringDrawer.h"
#include "SerializerTest.h"
#include "MapGenerator.h"
int launchTest();

#ifdef WIN32
int _tmain(int argc, _TCHAR* argv[])
{
	return launchTest();
}
#else
int main(int argc, char *argv[])
{
	return launchTest();
}	
#endif
#ifdef WIN32
int CALLBACK WinMain( HINSTANCE hInstance,  HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow
){
	
	
	return launchTest();

}
#endif



int launchTest(){

	BoardTest bTest;
	int nbBug = bTest.testAll();
	MapManagerTest mAmpTest;
	nbBug +=mAmpTest.testAll();
	MottiRulesManagerTest mMottiRule;
	nbBug += mMottiRule.testAll();
	StringDrawerTest strdra;
	nbBug += strdra.testAll();
	GameManagerTest gamManTest;
	nbBug +=gamManTest.testAll();
	SerializerTest test;
	nbBug += test.testAll();
#ifdef WIN32
	Sleep(50);
#endif
	return nbBug;
}


