/*  Motti -- a strategy game
    Copyright (C) 1999-2010 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "StdAfx.h"
#include "EditLineBoxElement.h"


EditLineBoxElement::EditLineBoxElement(int maxChar,std::string label):BoxElement(EDITLINE)
{
	maxChar_=maxChar;
	label_=label;
	value_="";
}


EditLineBoxElement::~EditLineBoxElement(void)
{
}

std::string EditLineBoxElement::getValue(){
	return value_;
}
void EditLineBoxElement::setValue(std::string val){
	if ( (int)value_.size()-1>maxChar_) 
		return;
	value_=val;
}
std::string EditLineBoxElement::getLabel(){
	return label_;
}

int EditLineBoxElement::getMaxChar(){
	return maxChar_;
}
