/* matutil.h

   written by Don Robert Maszle
   18 September 1992

   Copyright (c) 1992-2004.  Don Maszle, Frederic Bois.  All rights reserved.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

   -- Revisions -----
     Logfile:  %F%
    Revision:  %I%
        Date:  %G%
     Modtime:  %U%
      Author:  @a
   -- SCCS  ---------

*/

#ifndef _MATUTIL_H_
#define _MATUTIL_H_

#include "hungtype.h"

/* ----------------------------------------------------------------------------
   Prototypes */

int    Cholesky (PDOUBLE *prgdVariance, PDOUBLE *prgdComponent, long lNparams);

void   ColumnMeans (long cRows, long cCols, double **x, double *x_bar);

double **InitdMatrix (long cVectors, long cElemsEach);

long   **InitlMatrix (long cVectors, long cElemsEach);

double *InitdVector (long cVectors);

int    *InitiVector (long cVectors);

long   *InitlVector (long cVectors);

double **InitpdVector (long cVectors);

double *LogTransformArray (long nElems, double *rgdSrc, double *rgdDes);

/* End */

#endif /* _MATUTIL_H_ */




