/**
 * GNU LibreJS - A browser add-on to block nonfree nontrivial JavaScript.
 * *
 * Copyright (C) 2011, 2012 Loic J. Duros
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see  <http://www.gnu.org/licenses/>.
 *
 */

var timer = require("sdk/timers");

var {Cc, Ci, Cu, Cm, Cr} = require("chrome");
var {XPCOMUtils} = Cu.import("resource://gre/modules/XPCOMUtils.jsm");


// ensure xhr won't create an infinite loop
// with html content.
var urlTester = require("html_script_finder/url_seen_tester").urlSeenTester;
var urlHandler = require("url_handler/url_handler");
const scriptsCached = require("script_entries/scripts_cache").scriptsCached;

var request = {
  
  url: null,

  channel: null,

  script: null,
  
  responseCallback: null,
  
  /**
   * init
   */
  init: function (script, callback) {

	  this.script = script;

	  // set initial url
	  this.url = this.script.url;
	  
	  this.responseCallback = callback;

	  var iOService = Cc["@mozilla.org/network/io-service;1"]
          .getService(Ci.nsIIOService);

	  this.channel = iOService.newChannel(this.url, null, null);


  },

  request: function () {

	  var that = this;
	  
	  
	  
	  var responseReceived = function (data) {
	    that.responseCallback(that.script, data);
	  };
	  
	  this.channel.asyncOpen({
	    QueryInterface: XPCOMUtils.generateQI([Ci.nsIRequestObserver, Ci.nsIStreamListener]),
	    
	    data: "",

      charset: null,

	    onStartRequest: function(request, context) {
        this.charset = request.contentCharset || "UTF-8";
      },

	    onDataAvailable: function (request, context, stream, offset, count) {
		    try {	

          
          var binaryInputStream = Cc["@mozilla.org/binaryinputstream;1"]
                .createInstance(Ci.nsIBinaryInputStream);
          binaryInputStream.setInputStream(stream);
          var data = binaryInputStream.readBytes(count);
		      this.data += data;


		    } catch (x) {
		      console.log('error in request', x, x.lineNumber);
		    }

	    },

	    onStopRequest: function (request, context, result) {
        try {
          if (this.charset.toLowerCase() != "utf-8") {
            var uConv = Cc["@mozilla.org/intl/utf8converterservice;1"]
                  .createInstance(Ci.nsIUTF8ConverterService);

            this.data = uConv.convertStringToUTF8(this.data, this.charset, true);
          }
        } catch (e) {
          
          console.log("Issue with nsIUTF8ConverterService", e);
          console.log("Charset was", this.charset);
          
        }
        responseReceived(this.data);
	    }
	    
	  }, null);

  }


};

exports.request = function (script, callback) {
  var obj = Object.create(request);
  obj.init(script, callback);
  return obj;
};