
;;; d-tidy-html-files.el

;; Copyright (C) 2014-2015 Davin Pearson

;; Emacs Lisp Archive Entry
;; Filename: d-tidy-html-files.el
;; Author/Maintainer: Davin Pearson <http://davin.50webs.com>
;; Keywords: tidy html files functionality
;; Version: 1.0

;;; Commentary:

;; This file is not part of GNU Emacs.

;;; Limitation of Warranty

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or (at
;; your option) any later version.
;;
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs, see the file COPYING.  If not, see:
;;
;; <http://www.gnu.org/licenses/gpl-3.0.txt>.


;;; Known Bugs:

;; None so far!

;;; Code:

(message "*filename*=%s" *filename*)

(require 'cl)

(assert (boundp '*filename*))
(assert *filename*)

;;(setq *filename* "~/hairy-lemon/output/50webs-com/activism.html")

(if (not (fboundp 'read-only-mode))
    (defun read-only-mode (&optional arg)
      "P"
      (toggle-read-only arg)))

(progn
  (find-file *filename*)
  (read-only-mode -1)
  (goto-char (point-min))
  (while (looking-at "[ \t\r\n]")
    (delete-char 1))
  (when (search-forward "-->" nil t)
    (forward-line 1)
    (beginning-of-line)
    (while (looking-at "[ \t\r\n]")
      (delete-char 1))
    (condition-case err
      (save-buffer 0)
      (error "error message: %s" err))
    (kill-buffer nil)
    ))
