/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.CompilationException;
import gnu.jel.Library;
import java.lang.reflect.Member;
import junit.framework.TestCase;

public class LibraryDotOPTest
extends TestCase {
    Library ldot;

    public LibraryDotOPTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        Class[] stl = new Class[1];
        Class[] dynl = new Class[1];
        Class[] dotl = new Class[2];
        stl[0] = Class.forName("java.lang.Math");
        dynl[0] = Class.forName("java.util.Random");
        dotl[0] = Class.forName("java.util.Hashtable");
        dotl[1] = Class.forName("java.util.Vector");
        this.ldot = new Library(stl, dynl, dotl);
    }

    public void tearDown() throws Exception {
    }

    public void testHashtableSize() throws Exception {
        Class[] params = new Class[]{};
        Class<?> htable = Class.forName("java.util.Hashtable");
        Member mf = this.ldot.getMember(htable, "size", params);
        LibraryDotOPTest.assertTrue(mf != null && mf.equals(htable.getMethod("size", params)));
    }

    public void testVectorSize() throws Exception {
        Class[] params = new Class[]{};
        Class<?> vctr = Class.forName("java.util.Vector");
        Member mf = this.ldot.getMember(vctr, "size", params);
        LibraryDotOPTest.assertTrue(mf != null && mf.equals(vctr.getMethod("size", params)));
    }

    public void testSizeNoLeak() throws Exception {
        Class[] params = new Class[]{};
        try {
            Member mf = this.ldot.getMember(null, "size", params);
            LibraryDotOPTest.assertTrue(false);
        }
        catch (CompilationException exc) {
            LibraryDotOPTest.assertTrue(true);
        }
    }
}

