/* Generated By: Java; tab-width&JavaCC: Do not edit this line. EC.java */
package gnu.jel.generated;

import gnu.jel.*;
import gnu.jel.reflect.Member;
import java.io.StringReader;
import gnu.jel.debug.Debug;
import java.util.Stack;

public class EC implements ECConstants { /* EC stands for ExpressionCompiler */
  TypesStack typesStk=null;
  Stack paramOPs=null;
  OPlist list=null;
  Token errToken=null;
  Library lib=null;

  public OPlist parse(Class resType, Library lib)
    throws CompilationException {

    // checks of the assumptions made later
    if (Debug.enabled)
      Debug.assert(((MINUS-PLUS)==1) && ((NE-EQ)==1) && ((GE-LT)==1) &&
                   ((GT-GE)==1) && ((LE-GT)==1) && ((RS-LS)==1) &&
                   ((RUS-RS)==1) && ((DIVIDE-MULTIPLY)==1) &&
                   ((REMAINDER-DIVIDE)==1) && ((LOGCOMPL-BWCOMPL)==1));

    this.lib=lib;
    typesStk=new TypesStack();
    paramOPs=new Stack();
    list=new OPlist();
    try {
      expression(resType);
    } catch (CompilationException exc) {
      if (Debug.enabled)
        Debug.assert(errToken!=null,"Error token is not set.");
      exc.setColumn(errToken.beginColumn);
      throw exc;
    } catch (ParseException pe) {
      throw new CompilationException(pe.currentToken.next.beginColumn,
                                     pe.currentToken.next.kind==0?1:2,
                                     pe.currentToken.next);
    } catch (TokenMgrError tme) {
      throw new CompilationException(tme.col,tme.isEOF?1:3,
                                     new Character(tme.encountered));
    };
    return list;
  }


  private void notePar() {
    if (list.size()>0)
      paramOPs.push(list.getLast());
    else
      paramOPs.push(null);
  }

  private void genDVCall(String varName)
    throws CompilationException {
    String typeName=lib.getDVTypeName(varName);
    notePar(); // placeholder for "this" reference
    int paramsStart=typesStk.size();
    list.addLast(new OPload(typesStk,varName));
    notePar();
    functionCall(null,"get"+typeName+"Property",paramsStart);
  }


  private void functionCall(Class resolveInClass,String name,int paramsStart)
    throws CompilationException {
    // collect params
    int np=typesStk.size()-paramsStart;
    Class[] params=new Class[np];
    OP[] paramsOPs=new OP[np];
    for(int i=np-1;i>=0;i--) {
      params[i]=typesStk.pop();
      paramsOPs[i]=(OP)paramOPs.pop();
    };

    // find method
    Member m=null;
    if (resolveInClass!=null) {
      m=lib.getMember(resolveInClass,name,params);
    } else
      m=lib.getMember(name,params);


    // put "this" pointer in place
    if (resolveInClass==null) {
      OP thisOP=(OP)paramOPs.pop();
      if ((m.getModifiers() & 0x0008)==0) {
        // insert loading of "this" pointer
        OP op=new OPcall(typesStk,1,(new Object[0]).getClass());
        if (thisOP==null)
          list.addFirst(op);
        else
          list.addAfter(thisOP,op);
        thisOP=op;
        paramOPs.push(op);
        int classID=lib.getDynamicMethodClassID(m);
        op=new OPload(typesStk,Integer.TYPE,new Integer(classID));
        list.addAfter(thisOP,op); thisOP=op;
        paramOPs.push(op);
        op=new OPbinary(typesStk,paramOPs,19,list);
        list.addAfter(thisOP,op); thisOP=op;
        paramOPs.push(thisOP);
      };
    };

    // restore params & param ops
    for(int i=0;i<np;i++) {
      typesStk.push(params[i]);
      paramOPs.push(paramsOPs[i]);
    };
    list.addLast(new OPcall(typesStk,paramOPs,m,list,
                            lib.isStateless(m)));
  }


  private void binOP(int code,Token errToken) throws CompilationException {
    this.errToken=errToken;
    notePar();
    list.addLast(new OPbinary(typesStk,paramOPs,code,list));
  }

  final public void expression(Class resultType) throws ParseException, CompilationException {
 Token x;
    conditional();
    x = jj_consume_token(0);
      errToken=x;
      // remove TSB at return if present
      if (typesStk.peekID()==10)
        list.addLast(new OPunary(typesStk,11,null,false));

      if (resultType!=null)
        list.addLast(new OPunary(typesStk,TypesStack.typeID(resultType),
                                 resultType,false));

      list.addLast(new OPunary(typesStk,3)); // add the "return" instr.

      if (Debug.enabled)
        Debug.assert(typesStk.size()==0,
                     "Words left in stack while parsing.");
  }

  final public void conditional() throws ParseException, CompilationException {
  OPlist oldList=null;
  OPlist trueList=null;
  int stackSizeBeforeBranch=0;
  int stackSizeAfterFirstBranch=0;
  Token x;
    lor();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 39:
      x = jj_consume_token(39);
    stackSizeBeforeBranch=typesStk.size();
    oldList=list;
    list=new OPlist();
      conditional();
      jj_consume_token(40);
    stackSizeAfterFirstBranch=typesStk.size();
    trueList=list;
    list=new OPlist();
      conditional();
    errToken=x;
    if (Debug.enabled)
      Debug.assert((typesStk.size()==stackSizeAfterFirstBranch+1) &&
                   (stackSizeAfterFirstBranch==stackSizeBeforeBranch+1),
                   "Stack in conditional branches is not balanced.");
    OP opcond=new OPcondtnl(typesStk,oldList,trueList,list);
    list=oldList;
    list.addLast(opcond);
      break;
    default:
      jj_la1[0] = jj_gen;
      ;
    }
  }

  final public void lor() throws ParseException, CompilationException {
 Token x;
    land();
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LOR:
        ;
        break;
      default:
        jj_la1[1] = jj_gen;
        break label_1;
      }
      x = jj_consume_token(LOR);
                    notePar();
      land();
    binOP(18,x);
    }
  }

  final public void land() throws ParseException, CompilationException {
 Token x;
    bor();
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LAND:
        ;
        break;
      default:
        jj_la1[2] = jj_gen;
        break label_2;
      }
      x = jj_consume_token(LAND);
                    notePar();
      bor();
         binOP(17,x);
    }
  }

  final public void bor() throws ParseException, CompilationException {
 Token x;
    bxor();
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OR:
        ;
        break;
      default:
        jj_la1[3] = jj_gen;
        break label_3;
      }
      x = jj_consume_token(OR);
                   notePar();
      bxor();
          binOP(6,x);
    }
  }

  final public void bxor() throws ParseException, CompilationException {
 Token x;
    band();
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case XOR:
        ;
        break;
      default:
        jj_la1[4] = jj_gen;
        break label_4;
      }
      x = jj_consume_token(XOR);
                    notePar();
      band();
          binOP(7,x);
    }
  }

  final public void band() throws ParseException, CompilationException {
 Token x;
    equality();
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AND:
        ;
        break;
      default:
        jj_la1[5] = jj_gen;
        break label_5;
      }
      x = jj_consume_token(AND);
                        notePar();
      equality();
              binOP(5,x);
    }
  }

  final public void equality() throws ParseException, CompilationException {
 Token x;
    relation();
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EQ:
      case NE:
        ;
        break;
      default:
        jj_la1[6] = jj_gen;
        break label_6;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EQ:
        x = jj_consume_token(EQ);
        break;
      case NE:
        x = jj_consume_token(NE);
        break;
      default:
        jj_la1[7] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                                notePar();
      relation();
              binOP(8+x.kind-EQ,x);
    }
  }

  final public void relation() throws ParseException, CompilationException {
 Token x;
    shift();
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LT:
      case GE:
      case GT:
      case LE:
        ;
        break;
      default:
        jj_la1[8] = jj_gen;
        break label_7;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LT:
        x = jj_consume_token(LT);
        break;
      case GE:
        x = jj_consume_token(GE);
        break;
      case GT:
        x = jj_consume_token(GT);
        break;
      case LE:
        x = jj_consume_token(LE);
        break;
      default:
        jj_la1[9] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                      notePar();
      shift();
           binOP(10+x.kind-LT,x);
    }
  }

  final public void shift() throws ParseException, CompilationException {
 Token x;
    sum();
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LS:
      case RS:
      case RUS:
        ;
        break;
      default:
        jj_la1[10] = jj_gen;
        break label_8;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LS:
        x = jj_consume_token(LS);
        break;
      case RS:
        x = jj_consume_token(RS);
        break;
      case RUS:
        x = jj_consume_token(RUS);
        break;
      default:
        jj_la1[11] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
                    notePar();
      sum();
         binOP(14+x.kind-LS,x);
    }
  }

  final public void sum() throws ParseException, CompilationException {
 Token x;
    term();
    label_9:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
        ;
        break;
      default:
        jj_la1[12] = jj_gen;
        break label_9;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
        x = jj_consume_token(PLUS);
        break;
      case MINUS:
        x = jj_consume_token(MINUS);
        break;
      default:
        jj_la1[13] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
            notePar();
      term();
          binOP(x.kind-PLUS,x);
    }
  }

  final public void term() throws ParseException, CompilationException {
 Token x;
    unary();
    label_10:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MULTIPLY:
      case DIVIDE:
      case REMAINDER:
        ;
        break;
      default:
        jj_la1[14] = jj_gen;
        break label_10;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MULTIPLY:
        x = jj_consume_token(MULTIPLY);
        break;
      case DIVIDE:
        x = jj_consume_token(DIVIDE);
        break;
      case REMAINDER:
        x = jj_consume_token(REMAINDER);
        break;
      default:
        jj_la1[15] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
            notePar();
      unary();
           binOP(2+x.kind-MULTIPLY,x);
    }
  }

  final public void unary() throws ParseException, CompilationException {
  Token x;
  Token type_to;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MINUS:
      x = jj_consume_token(MINUS);
      element();
    errToken=x;
    list.addLast(new OPunary(typesStk,0));
      break;
    case BWCOMPL:
    case LOGCOMPL:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BWCOMPL:
        x = jj_consume_token(BWCOMPL);
        break;
      case LOGCOMPL:
        x = jj_consume_token(LOGCOMPL);
        break;
      default:
        jj_la1[16] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      element();
    errToken=x;
    list.addLast(new OPunary(typesStk,1+x.kind-BWCOMPL));
      break;
    default:
      jj_la1[17] = jj_gen;
      if (jj_2_1(3)) {
        jj_consume_token(41);
        type_to = jj_consume_token(ID);
        jj_consume_token(42);
        element();
    errToken=type_to;
    int typeID=0;
    while ((typeID<8) &&
           !type_to.image.equals(TypesStack.specialTypes[typeID].toString()))
      typeID++;

    if (typeID>=8) // The type name is unknown.
      {if (true) throw new CompilationException(-1,4,type_to.image);}

    list.addLast(new OPunary(typesStk,typeID,null,true));
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case FALSE:
        case TRUE:
        case INTEGER_LITERAL:
        case FLOATING_POINT_LITERAL:
        case CHARACTER_LITERAL:
        case STRING_LITERAL:
        case ID:
        case 41:
          element();
          break;
        default:
          jj_la1[18] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
  }

  final public void element() throws ParseException, CompilationException {
  StringBuffer accumulator=null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TRUE:
      jj_consume_token(TRUE);
             list.addLast(new OPload(typesStk,Boolean.TRUE));
      break;
    case FALSE:
      jj_consume_token(FALSE);
             list.addLast(new OPload(typesStk,Boolean.FALSE));
      break;
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
    case ID:
    case 41:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
        literal();
        break;
      case 41:
        jj_consume_token(41);
        conditional();
        jj_consume_token(42);
        break;
      case ID:
        invocation(accumulator=new StringBuffer(), false);
        break;
      default:
        jj_la1[19] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_11:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DOT:
          ;
          break;
        default:
          jj_la1[20] = jj_gen;
          break label_11;
        }
        jj_consume_token(DOT);
        invocation(accumulator!=null?accumulator:(accumulator=new StringBuffer()),
                       true);
      }
   if ((accumulator!=null) && accumulator.length()>0)
     genDVCall(accumulator.toString());
      break;
    default:
      jj_la1[21] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void invocation(StringBuffer accumulator,
                boolean afterDot) throws ParseException, CompilationException {
  int paramsStart=0;
  Class resolveIn=null;
  Token x,id;
    id = jj_consume_token(ID);
    if (!afterDot) {
      accumulator.append(id.image);

      // check if such DV exists, if no -- abort match
      if (lib.getDVTypeName(id.image)==null) accumulator.setLength(0);
    } else {
      if (accumulator.length()>0) {
        int oldLen=accumulator.length();
        accumulator.append('.');
        accumulator.append(id.image);

        // if the accumulated+'.'+new does not match, load what had 
        // had already matched and abort match
        if (lib.getDVTypeName(accumulator.toString())==null) {
          accumulator.setLength(oldLen); // back up
          errToken=id;
          genDVCall(accumulator.toString());
          accumulator.setLength(0); // this name will be tried as method
        };
      };
      if (accumulator.length()==0) resolveIn=typesStk.peek();
    }
    if (accumulator.length()==0) {
      // start prepating a call to an object's method x.image
      notePar(); // placeholder for "this" reference
      paramsStart=typesStk.size();
    };
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 41:
      x = jj_consume_token(41);
        if (accumulator.length()>0) {
          // error variable must have no parameters
          errToken=x;
          {if (true) throw new CompilationException(-1,26,null);}

          // this is the place to hack in the abort of match and check
          // if the last matched name can be called as a method
        };
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MINUS:
      case BWCOMPL:
      case LOGCOMPL:
      case FALSE:
      case TRUE:
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case ID:
      case 41:
        conditional();
                      notePar();
        label_12:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case 43:
            ;
            break;
          default:
            jj_la1[22] = jj_gen;
            break label_12;
          }
          jj_consume_token(43);
          conditional();
                                                       notePar();
        }
        break;
      default:
        jj_la1[23] = jj_gen;
        ;
      }
      jj_consume_token(42);
      break;
    default:
      jj_la1[24] = jj_gen;
      ;
    }
        if (accumulator.length()==0) {
          // generate the method invocation
          errToken=id;
          functionCall(resolveIn,id.image,paramsStart);
        };
    label_13:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 44:
        ;
        break;
      default:
        jj_la1[25] = jj_gen;
        break label_13;
      }
      x = jj_consume_token(44);
        if (accumulator.length()>0) {
          // load the DV
          genDVCall(accumulator.toString());
          accumulator.setLength(0);
        };
        notePar();
      conditional();
      x = jj_consume_token(45);
            binOP(19,x);
    }
  }

  final public void literal() throws ParseException, CompilationException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER_LITERAL:
      jj_consume_token(INTEGER_LITERAL);
                     {
    errToken=token;
    String svalue=token.image.toUpperCase();
    long value=0;
    boolean makelong=svalue.endsWith("L");
    if (makelong) svalue=svalue.substring(0,svalue.length()-1);

    try {
      if ( svalue.startsWith("0x") || svalue.startsWith("0X") ) {
        // Hexadecimal number
        svalue=svalue.substring(2);
        value=Long.parseLong(svalue,16);
      } else if (token.image.startsWith("0")) {
        // Octal number
        value=Long.parseLong(svalue,8);
      } else {
        // Decimal number
        value=Long.parseLong(svalue,10);
      };
    } catch (NumberFormatException e) {
      {if (true) throw new CompilationException(-1,13,token.image);} // Overflow ?
    };

    Object val=null;
    if (!makelong) { // Check ranges
      if (value<=127) val=new Byte((byte)value);
      else if (value<=32767) val=new Short((short)value);
      else if (value<=2147483647) val=new Integer((int)value);
      else {if (true) throw new CompilationException(-1,14,token.image);}
    } else {
      val=new Long(value);
    };

    list.addLast(new OPload(typesStk,val));
  }
      break;
    case FLOATING_POINT_LITERAL:
      jj_consume_token(FLOATING_POINT_LITERAL);
                            {
  errToken=token;
  char lc=Character.toUpperCase(token.image.charAt(token.image.length()-1));
  boolean makeFloat = (lc=='F');
  String svalue=token.image;
  if ((lc=='D') || (lc=='F')) {
    svalue=svalue.substring(0,svalue.length()-1);
  };
  Double value=null;
  try {
    value=new Double(svalue);
  } catch (NumberFormatException e) {
    // Overflow ? Will produce infinity.
  };
  if (makeFloat)
    list.addLast(new OPload(typesStk,new Float(value.floatValue())));
  else
    list.addLast(new OPload(typesStk,value));
  }
      break;
    case CHARACTER_LITERAL:
      jj_consume_token(CHARACTER_LITERAL);
                       {
  errToken=token;
  String sval=token.image.substring(1,token.image.length()-1);
  if (sval.length()==1)
    list.addLast(new OPload(typesStk,new Character(sval.charAt(0))));
  else { // escape or number
    char ec=sval.charAt(1);
    try {
      switch (ec) {
      case 'n': ec='\n'; break;
      case 't': ec='\t'; break;
      case 'b': ec='\b'; break;
      case 'r': ec='\r'; break;
      case 'f': ec='\f'; break;
      case '\\': ec='\\'; break;
      case '\'': ec='\''; break;
      case '\"': ec='"'; break;
      default:
        ec=(char) Integer.parseInt(sval.substring(1),8);
      };
    } catch (NumberFormatException e) {/* Can't be */};
    list.addLast(new OPload(typesStk,new Character(ec)));
  };
  }
      break;
    case STRING_LITERAL:
      jj_consume_token(STRING_LITERAL);
                    {
  String sval=token.image.substring(1,token.image.length()-1);
  StringBuffer unescaped=new StringBuffer(sval.length());
  for(int i=0;i<sval.length();i++) {
    char ec=sval.charAt(i);
    if (ec=='\\') { // escape
      ec=sval.charAt(++i);
      switch (ec) {
      case 'n': ec='\n'; break;
      case 't': ec='\t'; break;
      case 'b': ec='\b'; break;
      case 'r': ec='\r'; break;
      case 'f': ec='\f'; break;
      case '\\': ec='\\'; break;
      case '\'': ec='\''; break;
      case '\"': ec='"'; break;
      default:
        int nval=0;
        while ((i<sval.length()) && ((ec=sval.charAt(i))>='0') && (ec<='7')) {
          nval=nval<<3+(ec-'0');
          i++;
        };
        i--;
        ec=(char)nval;
      };
    };
    unescaped.append(ec);
  };
  list.addLast(new OPload(typesStk,unescaped.toString()));
  }
      break;
    default:
      jj_la1[26] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_1();
    jj_save(0, xla);
    return retval;
  }

  final private boolean jj_3_1() {
    if (jj_scan_token(41)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(42)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  public ECTokenManager token_source;
  ASCII_CharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[27];
  final private int[] jj_la1_0 = {0x0,0x8000,0x2000,0x4000,0x10000,0x1000,0x60000,0x60000,0x780000,0x780000,0x3800000,0x3800000,0x30,0x30,0xe00,0xe00,0x180,0x1a0,0x1c000000,0x10000000,0x40,0x1c000000,0x0,0x1c0001a0,0x0,0x0,0x10000000,};
  final private int[] jj_la1_1 = {0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x21d,0x21d,0x0,0x21d,0x800,0x21d,0x200,0x1000,0xd,};
  final private JJCalls[] jj_2_rtns = new JJCalls[1];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  public EC(java.io.InputStream stream) {
    jj_input_stream = new ASCII_CharStream(stream, 1, 1);
    token_source = new ECTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 27; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 27; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public EC(java.io.Reader stream) {
    jj_input_stream = new ASCII_CharStream(stream, 1, 1);
    token_source = new ECTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 27; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 27; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public EC(ECTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 27; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(ECTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 27; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    return (jj_scanpos.kind != kind);
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration enum = jj_expentries.elements(); enum.hasMoreElements();) {
        int[] oldentry = (int[])(enum.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  final public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[46];
    for (int i = 0; i < 46; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 27; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 46; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

  final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 1; i++) {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
          }
        }
        p = p.next;
      } while (p != null);
    }
    jj_rescan = false;
  }

  final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

};
