var browserTests = [
["foo[]bar",
    [["insertorderedlist",""]],
    "<ol><li>foo[]bar</li></ol>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["foo[bar]baz",
    [["insertorderedlist",""]],
    "<ol><li>foo[bar]baz</li></ol>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["foo<br>[bar]",
    [["insertorderedlist",""]],
    "foo<ol><li>[bar]</li></ol>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["f[oo<br>b]ar<br>baz",
    [["insertorderedlist",""]],
    "<ol><li>f[oo</li><li>b]ar</li></ol>baz",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["<p>[foo]<br>bar</p>",
    [["insertorderedlist",""]],
    "<ol><li>[foo]</li></ol><p>bar</p>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["[foo<ol><li>bar]</ol>baz",
    [["insertorderedlist",""]],
    "<ol><li>[foo</li><li>bar]</li></ol>baz",
    [true],
    {"insertorderedlist":[true,false,"",false,true,""]}],
["foo<ol><li>[bar</ol>baz]",
    [["insertorderedlist",""]],
    "foo<ol><li>[bar</li><li>baz]</li></ol>",
    [true],
    {"insertorderedlist":[true,false,"",false,true,""]}],
["[foo<ul><li>bar]</ul>baz",
    [["insertorderedlist",""]],
    "<ol><li>[foo</li><li>bar]</li></ol>baz",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["foo<ul><li>[bar</ul>baz]",
    [["insertorderedlist",""]],
    "foo<ol><li>[bar</li><li>baz]</li></ol>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["foo<ul><li>[bar</ul><ol><li>baz]</ol>quz",
    [["insertorderedlist",""]],
    "foo<ol><li>[bar</li><li>baz]</li></ol>quz",
    [true],
    {"insertorderedlist":[true,false,"",false,true,""]}],
["foo<ol><li>[bar</ol><ul><li>baz]</ul>quz",
    [["insertorderedlist",""]],
    "foo<ol><li>[bar</li><li>baz]</li></ol>quz",
    [true],
    {"insertorderedlist":[true,false,"",false,true,""]}],
["<table><tbody><tr><td>foo<td>b[a]r<td>baz</table>",
    [["insertorderedlist",""]],
    "<table><tbody><tr><td>foo</td><td><ol><li>b[a]r</li></ol></td><td>baz</td></tr></tbody></table>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["<table><tbody><tr><td>fo[o<td>b]ar<td>baz</table>",
    [["insertorderedlist",""]],
    "<table><tbody><tr><td><ol><li>fo[o</li></ol></td><td><ol><li>b]ar</li></ol></td><td>baz</td></tr></tbody></table>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["{<table><tr><td>foo<td>bar<td>baz</table>}",
    [["insertorderedlist",""]],
    "<ol><li>{<table><tbody><tr><td>foo</td><td>bar</td><td>baz</td></tr></tbody></table>}</li></ol>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["<p>foo<p>[bar]<p>baz",
    [["defaultparagraphseparator","div"],["insertorderedlist",""]],
    "<p>foo</p><ol><li>[bar]</li></ol><p>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,false,"",false,true,""]}],
["<p>foo<p>[bar]<p>baz",
    [["defaultparagraphseparator","p"],["insertorderedlist",""]],
    "<p>foo</p><ol><li>[bar]</li></ol><p>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,false,"",false,true,""]}],
["<p>foo<blockquote>[bar]</blockquote><p>baz",
    [["insertorderedlist",""]],
    "<p>foo</p><blockquote><ol><li>[bar]</li></ol></blockquote><p>baz</p>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["<dl><dt>foo<dd>[bar]<dt>baz<dd>quz</dl>",
    [["insertorderedlist",""]],
    "<dl><dt>foo</dt><dd><ol><li>[bar]</li></ol></dd><dt>baz</dt><dd>quz</dd></dl>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["<dl><dt>foo<dd>bar<dt>[baz]<dd>quz</dl>",
    [["insertorderedlist",""]],
    "<dl><dt>foo</dt><dd>bar</dd><dt><ol><li>[baz]</li></ol></dt><dd>quz</dd></dl>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["<p>[foo<p>bar]<p>baz",
    [["defaultparagraphseparator","div"],["insertorderedlist",""]],
    "<ol><li>[foo</li><li>bar]</li></ol><p>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,false,"",false,true,""]}],
["<p>[foo<p>bar]<p>baz",
    [["defaultparagraphseparator","p"],["insertorderedlist",""]],
    "<ol><li>[foo</li><li>bar]</li></ol><p>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,false,"",false,true,""]}],
["<p>[foo<blockquote>bar]</blockquote><p>baz",
    [["defaultparagraphseparator","div"],["insertorderedlist",""]],
    "<ol><li>[foo</li><ol><li>bar]</li></ol></ol><p>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,false,"",false,true,""]}],
["<p>[foo<blockquote>bar]</blockquote><p>baz",
    [["defaultparagraphseparator","p"],["insertorderedlist",""]],
    "<ol><li>[foo</li><ol><li>bar]</li></ol></ol><p>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,false,"",false,true,""]}],
["<dl><dt>[foo<dd>bar]<dt>baz<dd>quz</dl>",
    [["insertorderedlist",""]],
    "<dl><dt><ol><li>[foo</li></ol></dt><dd><ol><li>bar]</li></ol></dd><dt>baz</dt><dd>quz</dd></dl>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["<dl><dt>foo<dd>[bar<dt>baz]<dd>quz</dl>",
    [["insertorderedlist",""]],
    "<dl><dt>foo</dt><dd><ol><li>[bar</li></ol></dd><dt><ol><li>baz]</li></ol></dt><dd>quz</dd></dl>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["<p>[foo<blockquote><p>bar]<p>baz</blockquote>",
    [["defaultparagraphseparator","div"],["insertorderedlist",""]],
    "<ol><li>[foo</li><ol><li>bar]</li></ol></ol><blockquote><p>baz</p></blockquote>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,false,"",false,true,""]}],
["<p>[foo<blockquote><p>bar]<p>baz</blockquote>",
    [["defaultparagraphseparator","p"],["insertorderedlist",""]],
    "<ol><li>[foo</li><ol><li>bar]</li></ol></ol><blockquote><p>baz</p></blockquote>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo<li>[bar]<li>baz</ol>",
    [["defaultparagraphseparator","div"],["insertorderedlist",""]],
    "<ol><li>foo</li></ol><div>[bar]</div><ol><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li>foo<li>[bar]<li>baz</ol>",
    [["defaultparagraphseparator","p"],["insertorderedlist",""]],
    "<ol><li>foo</li></ol><p>[bar]</p><ol><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li>foo</ol>[bar]",
    [["insertorderedlist",""]],
    "<ol><li>foo</li><li>[bar]</li></ol>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["[foo]<ol><li>bar</ol>",
    [["insertorderedlist",""]],
    "<ol><li>[foo]</li><li>bar</li></ol>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo</ol>[bar]<ol><li>baz</ol>",
    [["insertorderedlist",""]],
    "<ol><li>foo</li><li>[bar]</li><li>baz</li></ol>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["<ol><ol><li>[foo]</ol></ol>",
    [["insertorderedlist",""]],
    "<ol><li>[foo]</li></ol>",
    [true],
    {"insertorderedlist":[false,true,"",false,true,""]}],
["<ol><li>[foo]<br>bar<li>baz</ol>",
    [["defaultparagraphseparator","div"],["insertorderedlist",""]],
    "<div>[foo]<br>bar</div><ol><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li>[foo]<br>bar<li>baz</ol>",
    [["defaultparagraphseparator","p"],["insertorderedlist",""]],
    "<p>[foo]<br>bar</p><ol><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li>foo<br>[bar]<li>baz</ol>",
    [["defaultparagraphseparator","div"],["insertorderedlist",""]],
    "<div>foo<br>[bar]</div><ol><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li>foo<br>[bar]<li>baz</ol>",
    [["defaultparagraphseparator","p"],["insertorderedlist",""]],
    "<p>foo<br>[bar]</p><ol><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li><div>[foo]</div>bar<li>baz</ol>",
    [["defaultparagraphseparator","div"],["insertorderedlist",""]],
    "<div>[foo]</div><div>bar</div><ol><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li><div>[foo]</div>bar<li>baz</ol>",
    [["defaultparagraphseparator","p"],["insertorderedlist",""]],
    "<div>[foo]</div><p>bar</p><ol><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li>foo<ol><li>[bar]<li>baz</ol><li>quz</ol>",
    [["insertorderedlist",""]],
    "<ol><li>foo</li><li>[bar]</li><ol><li>baz</li></ol><li>quz</li></ol>",
    [true],
    {"insertorderedlist":[false,true,"",false,true,""]}],
["<ol><li>foo<ol><li>bar<li>[baz]</ol><li>quz</ol>",
    [["insertorderedlist",""]],
    "<ol><li>foo</li><ol><li>bar</li></ol><li>[baz]</li><li>quz</li></ol>",
    [true],
    {"insertorderedlist":[false,true,"",false,true,""]}],
["<ol><li>foo</li><ol><li>[bar]<li>baz</ol><li>quz</ol>",
    [["insertorderedlist",""]],
    "<ol><li>foo</li><li>[bar]</li><ol><li>baz</li></ol><li>quz</li></ol>",
    [true],
    {"insertorderedlist":[false,true,"",false,true,""]}],
["<ol><li>foo</li><ol><li>bar<li>[baz]</ol><li>quz</ol>",
    [["insertorderedlist",""]],
    "<ol><li>foo</li><ol><li>bar</li></ol><li>[baz]</li><li>quz</li></ol>",
    [true],
    {"insertorderedlist":[false,true,"",false,true,""]}],
["<ol><li>[foo]<ol><li>bar</ol><li>baz</ol>",
    [["defaultparagraphseparator","div"],["insertorderedlist",""]],
    "<div>[foo]</div><ol><ol><li>bar</li></ol><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li>[foo]<ol><li>bar</ol><li>baz</ol>",
    [["defaultparagraphseparator","p"],["insertorderedlist",""]],
    "<p>[foo]</p><ol><ol><li>bar</li></ol><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li>[foo]</li><ol><li>bar</ol><li>baz</ol>",
    [["defaultparagraphseparator","div"],["insertorderedlist",""]],
    "<div>[foo]</div><ol><ol><li>bar</li></ol><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li>[foo]</li><ol><li>bar</ol><li>baz</ol>",
    [["defaultparagraphseparator","p"],["insertorderedlist",""]],
    "<p>[foo]</p><ol><ol><li>bar</li></ol><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li>foo<li>[bar]<ol><li>baz</ol><li>quz</ol>",
    [["defaultparagraphseparator","div"],["insertorderedlist",""]],
    "<ol><li>foo</li></ol><div>[bar]</div><ol><ol><li>baz</li></ol><li>quz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li>foo<li>[bar]<ol><li>baz</ol><li>quz</ol>",
    [["defaultparagraphseparator","p"],["insertorderedlist",""]],
    "<ol><li>foo</li></ol><p>[bar]</p><ol><ol><li>baz</li></ol><li>quz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li>foo<li>[bar]</li><ol><li>baz</ol><li>quz</ol>",
    [["defaultparagraphseparator","div"],["insertorderedlist",""]],
    "<ol><li>foo</li></ol><div>[bar]</div><ol><ol><li>baz</li></ol><li>quz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li>foo<li>[bar]</li><ol><li>baz</ol><li>quz</ol>",
    [["defaultparagraphseparator","p"],["insertorderedlist",""]],
    "<ol><li>foo</li></ol><p>[bar]</p><ol><ol><li>baz</li></ol><li>quz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li>foo<ol><li>bar<li>baz</ol><li>[quz]</ol>",
    [["defaultparagraphseparator","div"],["insertorderedlist",""]],
    "<ol><li>foo<ol><li>bar</li><li>baz</li></ol></li></ol><div>[quz]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li>foo<ol><li>bar<li>baz</ol><li>[quz]</ol>",
    [["defaultparagraphseparator","p"],["insertorderedlist",""]],
    "<ol><li>foo<ol><li>bar</li><li>baz</li></ol></li></ol><p>[quz]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li>foo</li><ol><li>bar<li>baz</ol><li>[quz]</ol>",
    [["defaultparagraphseparator","div"],["insertorderedlist",""]],
    "<ol><li>foo</li><ol><li>bar</li><li>baz</li></ol></ol><div>[quz]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li>foo</li><ol><li>bar<li>baz</ol><li>[quz]</ol>",
    [["defaultparagraphseparator","p"],["insertorderedlist",""]],
    "<ol><li>foo</li><ol><li>bar</li><li>baz</li></ol></ol><p>[quz]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li>foo<li>[bar<li>baz]</ol>",
    [["defaultparagraphseparator","div"],["insertorderedlist",""]],
    "<ol><li>foo</li></ol><div>[bar</div><div>baz]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li>foo<li>[bar<li>baz]</ol>",
    [["defaultparagraphseparator","p"],["insertorderedlist",""]],
    "<ol><li>foo</li></ol><p>[bar</p><p>baz]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li>[foo<ol><li>bar]</ol><li>baz</ol>",
    [["defaultparagraphseparator","div"],["insertorderedlist",""]],
    "<div>[foo</div><ol><li>bar]</li><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,true,"",true,false,""]}],
["<ol><li>[foo<ol><li>bar]</ol><li>baz</ol>",
    [["defaultparagraphseparator","p"],["insertorderedlist",""]],
    "<p>[foo</p><ol><li>bar]</li><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,true,"",true,false,""]}],
["<ol><li>foo<ol><li>b[ar</ol><li>b]az</ol>",
    [["defaultparagraphseparator","div"],["insertorderedlist",""]],
    "<ol><li>foo</li><li>b[ar</li></ol><div>b]az</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,true,"",true,false,""]}],
["<ol><li>foo<ol><li>b[ar</ol><li>b]az</ol>",
    [["defaultparagraphseparator","p"],["insertorderedlist",""]],
    "<ol><li>foo</li><li>b[ar</li></ol><p>b]az</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,true,"",true,false,""]}],
["<ol><li>[foo<ol><li>bar</ol><li>baz]</ol><p>extra",
    [["defaultparagraphseparator","div"],["insertorderedlist",""]],
    "<div>[foo</div><ol><li>bar</li></ol><div>baz]</div><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,true,"",true,false,""]}],
["<ol><li>[foo<ol><li>bar</ol><li>baz]</ol><p>extra",
    [["defaultparagraphseparator","p"],["insertorderedlist",""]],
    "<p>[foo</p><ol><li>bar</li></ol><p>baz]</p><p>extra</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,true,"",true,false,""]}],
["<ol><li>[foo]<ol><li>bar</ol>baz</ol>",
    [["defaultparagraphseparator","div"],["insertorderedlist",""]],
    "<div>[foo]</div><ol><ol><li>bar</li></ol><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li>[foo]<ol><li>bar</ol>baz</ol>",
    [["defaultparagraphseparator","p"],["insertorderedlist",""]],
    "<p>[foo]</p><ol><ol><li>bar</li></ol><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li>foo<ol><li>[bar]</ol>baz</ol>",
    [["insertorderedlist",""]],
    "<ol><li>foo</li><li>[bar]</li><li>baz</li></ol>",
    [true],
    {"insertorderedlist":[false,true,"",false,true,""]}],
["<ol><li>foo<ol><li>bar</ol>[baz]</ol>",
    [["defaultparagraphseparator","div"],["insertorderedlist",""]],
    "<ol><li>foo</li><ol><li>bar</li></ol></ol><div>[baz]</div>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li>foo<ol><li>bar</ol>[baz]</ol>",
    [["defaultparagraphseparator","p"],["insertorderedlist",""]],
    "<ol><li>foo</li><ol><li>bar</li></ol></ol><p>[baz]</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,true,"",false,false,""]}],
["<ol><li>[foo<ol><li>bar]</ol>baz</ol>",
    [["defaultparagraphseparator","div"],["insertorderedlist",""]],
    "<div>[foo</div><ol><li>bar]</li><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,true,"",true,false,""]}],
["<ol><li>[foo<ol><li>bar]</ol>baz</ol>",
    [["defaultparagraphseparator","p"],["insertorderedlist",""]],
    "<p>[foo</p><ol><li>bar]</li><li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,true,"",true,false,""]}],
["<ul><li>foo<li>[bar]<li>baz</ul>",
    [["insertorderedlist",""]],
    "<ul><li>foo</li></ul><ol><li>[bar]</li></ol><ul><li>baz</li></ul>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["<ul><li>foo</ul>[bar]",
    [["insertorderedlist",""]],
    "<ul><li>foo</li></ul><ol><li>[bar]</li></ol>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["[foo]<ul><li>bar</ul>",
    [["insertorderedlist",""]],
    "<ol><li>[foo]</li></ol><ul><li>bar</li></ul>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["<ul><li>foo</ul>[bar]<ul><li>baz</ul>",
    [["insertorderedlist",""]],
    "<ul><li>foo</li></ul><ol><li>[bar]</li></ol><ul><li>baz</li></ul>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["<ul><ul><li>[foo]</ul></ul>",
    [["insertorderedlist",""]],
    "<ol><ol><li>[foo]</li></ol></ol>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["<ul><li>[foo]<br>bar<li>baz</ul>",
    [["insertorderedlist",""]],
    "<ol><li>[foo]<br>bar</li></ol><ul><li>baz</li></ul>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["<ul><li>foo<br>[bar]<li>baz</ul>",
    [["insertorderedlist",""]],
    "<ol><li>foo<br>[bar]</li></ol><ul><li>baz</li></ul>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["<ul><li><div>[foo]</div>bar<li>baz</ul>",
    [["insertorderedlist",""]],
    "<ol><li><div>[foo]</div>bar</li></ol><ul><li>baz</li></ul>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["<ul><li>foo<ul><li>[bar]<li>baz</ul><li>quz</ul>",
    [["insertorderedlist",""]],
    "<ul><li>foo</li><ol><li>[bar]</li></ol><ul><li>baz</li></ul><li>quz</li></ul>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["<ul><li>foo<ul><li>bar<li>[baz]</ul><li>quz</ul>",
    [["insertorderedlist",""]],
    "<ul><li>foo</li><ul><li>bar</li></ul><ol><li>[baz]</li></ol><li>quz</li></ul>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["<ul><li>foo</li><ul><li>[bar]<li>baz</ul><li>quz</ul>",
    [["insertorderedlist",""]],
    "<ul><li>foo</li><ol><li>[bar]</li></ol><ul><li>baz</li></ul><li>quz</li></ul>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["<ul><li>foo</li><ul><li>bar<li>[baz]</ul><li>quz</ul>",
    [["insertorderedlist",""]],
    "<ul><li>foo</li><ul><li>bar</li></ul><ol><li>[baz]</li></ol><li>quz</li></ul>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["<ul><li>[foo]<ul><li>bar</ul><li>baz</ul>",
    [["insertorderedlist",""]],
    "<ol><li>[foo]</li></ol><ul><ul><li>bar</li></ul><li>baz</li></ul>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["<ul><li>[foo]</li><ul><li>bar</ul><li>baz</ul>",
    [["insertorderedlist",""]],
    "<ol><li>[foo]</li></ol><ul><ul><li>bar</li></ul><li>baz</li></ul>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["<ul><li>foo<li>[bar]<ul><li>baz</ul><li>quz</ul>",
    [["insertorderedlist",""]],
    "<ul><li>foo</li></ul><ol><li>[bar]</li></ol><ul><ul><li>baz</li></ul><li>quz</li></ul>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["<ul><li>foo<li>[bar]</li><ul><li>baz</ul><li>quz</ul>",
    [["insertorderedlist",""]],
    "<ul><li>foo</li></ul><ol><li>[bar]</li></ol><ul><ul><li>baz</li></ul><li>quz</li></ul>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["<ul><li>foo<ul><li>bar<li>baz</ul><li>[quz]</ul>",
    [["insertorderedlist",""]],
    "<ul><li>foo<ul><li>bar</li><li>baz</li></ul></li></ul><ol><li>[quz]</li></ol>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["<ul><li>foo</li><ul><li>bar<li>baz</ul><li>[quz]</ul>",
    [["insertorderedlist",""]],
    "<ul><li>foo</li><ul><li>bar</li><li>baz</li></ul></ul><ol><li>[quz]</li></ol>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["<ul><li>foo<li>[bar<li>baz]</ul>",
    [["insertorderedlist",""]],
    "<ul><li>foo</li></ul><ol><li>[bar</li><li>baz]</li></ol>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["<ul><li>[foo<ul><li>bar]</ul><li>baz</ul>",
    [["insertorderedlist",""]],
    "<ol><li>[foo</li><ol><li>bar]</li></ol></ol><ul><li>baz</li></ul>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["<ul><li>foo<ul><li>b[ar</ul><li>b]az</ul>",
    [["insertorderedlist",""]],
    "<ul><li>foo</li></ul><ol><ol><li>b[ar</li></ol><li>b]az</li></ol>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["<ul><li>[foo<ul><li>bar</ul><li>baz]</ul><p>extra",
    [["insertorderedlist",""]],
    "<ol><li>[foo</li><ol><li>bar</li></ol><li>baz]</li></ol><p>extra</p>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["<ul><li>[foo]<ul><li>bar</ul>baz</ul>",
    [["insertorderedlist",""]],
    "<ol><li>[foo]</li></ol><ul><ul><li>bar</li></ul><li>baz</li></ul>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["<ul><li>foo<ul><li>[bar]</ul>baz</ul>",
    [["insertorderedlist",""]],
    "<ul><li>foo</li><ol><li>[bar]</li></ol><li>baz</li></ul>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["<ul><li>foo<ul><li>bar</ul>[baz]</ul>",
    [["insertorderedlist",""]],
    "<ul><li>foo</li><ul><li>bar</li></ul></ul><ol><li>[baz]</li></ol>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["<ul><li>[foo<ul><li>bar]</ul>baz</ul>",
    [["insertorderedlist",""]],
    "<ol><li>[foo</li><ol><li>bar]</li></ol></ol><ul><li>baz</li></ul>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["foo<ol><li>bar</ol><ul><li>[baz]</ul>quz",
    [["insertorderedlist",""]],
    "foo<ol><li>bar</li><li>[baz]</li></ol>quz",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["foo<ol><li>bar</ol><ul><li>[baz</ul>quz]",
    [["insertorderedlist",""]],
    "foo<ol><li>bar</li><li>[baz</li><li>quz]</li></ol>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["foo<ul><li>[bar]</ul><ol><li>baz</ol>quz",
    [["insertorderedlist",""]],
    "foo<ol><li>[bar]</li><li>baz</li></ol>quz",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["[foo<ul><li>bar]</ul><ol><li>baz</ol>quz",
    [["insertorderedlist",""]],
    "<ol><li>[foo</li><li>bar]</li><li>baz</li></ol>quz",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["[foo]<blockquote>bar</blockquote>baz",
    [["insertorderedlist",""]],
    "<ol><li>[foo]</li></ol><blockquote>bar</blockquote>baz",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["foo<blockquote>[bar]</blockquote>baz",
    [["insertorderedlist",""]],
    "foo<blockquote><ol><li>[bar]</li></ol></blockquote>baz",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["[foo<blockquote>bar]</blockquote>baz",
    [["insertorderedlist",""]],
    "<ol><li>[foo</li><ol><li>bar]</li></ol></ol>baz",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo</ol><blockquote>[bar]</blockquote>baz",
    [["insertorderedlist",""]],
    "<ol><li>foo</li><ol><li>[bar]</li></ol></ol>baz",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["[foo]<blockquote><ol><li>bar</ol></blockquote>baz",
    [["insertorderedlist",""]],
    "<ol><li>[foo]</li></ol><blockquote><ol><li>bar</li></ol></blockquote>baz",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["foo<blockquote>[bar]<br>baz</blockquote>",
    [["insertorderedlist",""]],
    "foo<blockquote><ol><li>[bar]</li></ol>baz</blockquote>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["[foo<blockquote>bar]<br>baz</blockquote>",
    [["insertorderedlist",""]],
    "<ol><li>[foo</li><ol><li>bar]</li></ol></ol><blockquote>baz</blockquote>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo</ol><blockquote>[bar]<br>baz</blockquote>",
    [["insertorderedlist",""]],
    "<ol><li>foo</li><ol><li>[bar]</li></ol></ol><blockquote>baz</blockquote>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["<p>[foo]<blockquote><p>bar</blockquote><p>baz",
    [["defaultparagraphseparator","div"],["insertorderedlist",""]],
    "<ol><li>[foo]</li></ol><blockquote><p>bar</p></blockquote><p>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,false,"",false,true,""]}],
["<p>[foo]<blockquote><p>bar</blockquote><p>baz",
    [["defaultparagraphseparator","p"],["insertorderedlist",""]],
    "<ol><li>[foo]</li></ol><blockquote><p>bar</p></blockquote><p>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,false,"",false,true,""]}],
["<p>foo<blockquote><p>[bar]</blockquote><p>baz",
    [["defaultparagraphseparator","div"],["insertorderedlist",""]],
    "<p>foo</p><blockquote><ol><li>[bar]</li></ol></blockquote><p>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,false,"",false,true,""]}],
["<p>foo<blockquote><p>[bar]</blockquote><p>baz",
    [["defaultparagraphseparator","p"],["insertorderedlist",""]],
    "<p>foo</p><blockquote><ol><li>[bar]</li></ol></blockquote><p>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,false,"",false,true,""]}],
["<p>[foo<blockquote><p>bar]</blockquote><p>baz",
    [["defaultparagraphseparator","div"],["insertorderedlist",""]],
    "<ol><li>[foo</li><ol><li>bar]</li></ol></ol><p>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,false,"",false,true,""]}],
["<p>[foo<blockquote><p>bar]</blockquote><p>baz",
    [["defaultparagraphseparator","p"],["insertorderedlist",""]],
    "<ol><li>[foo</li><ol><li>bar]</li></ol></ol><p>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo</ol><blockquote><p>[bar]</blockquote><p>baz",
    [["defaultparagraphseparator","div"],["insertorderedlist",""]],
    "<ol><li>foo</li><ol><li>[bar]</li></ol></ol><p>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo</ol><blockquote><p>[bar]</blockquote><p>baz",
    [["defaultparagraphseparator","p"],["insertorderedlist",""]],
    "<ol><li>foo</li><ol><li>[bar]</li></ol></ol><p>baz</p>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,false,"",false,true,""]}],
["<ul id=abc><li>foo<li>[bar]<li>baz</ul>",
    [["insertorderedlist",""]],
    "<ul id=\"abc\"><li>foo</li></ul><ol><li>[bar]</li></ol><ul><li>baz</li></ul>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["<ul style=color:blue><li>foo<li>[bar]<li>baz</ul>",
    [["stylewithcss","true"],["insertorderedlist",""]],
    "<ul style=\"color:rgb(0, 0, 255)\"><li>foo</li></ul><ol><li><span style=\"color:rgb(0, 0, 255)\">[bar]</span></li></ol><ul style=\"color:rgb(0, 0, 255)\"><li>baz</li></ul>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"insertorderedlist":[false,false,"",false,true,""]}],
["<ul style=color:blue><li>foo<li>[bar]<li>baz</ul>",
    [["stylewithcss","false"],["insertorderedlist",""]],
    "<ul style=\"color:rgb(0, 0, 255)\"><li>foo</li></ul><ol><li><font color=\"#0000ff\">[bar]</font></li></ol><ul style=\"color:rgb(0, 0, 255)\"><li>baz</li></ul>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"insertorderedlist":[false,false,"",false,true,""]}],
["<ul style=text-indent:1em><li>foo<li>[bar]<li>baz</ul>",
    [["stylewithcss","true"],["insertorderedlist",""]],
    "<ul style=\"text-indent:1em\"><li>foo</li></ul><ol><li>[bar]</li></ol><ul style=\"text-indent:1em\"><li>baz</li></ul>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"insertorderedlist":[false,false,"",false,true,""]}],
["<ul style=text-indent:1em><li>foo<li>[bar]<li>baz</ul>",
    [["stylewithcss","false"],["insertorderedlist",""]],
    "<ul style=\"text-indent:1em\"><li>foo</li></ul><ol><li>[bar]</li></ol><ul style=\"text-indent:1em\"><li>baz</li></ul>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"insertorderedlist":[false,false,"",false,true,""]}],
["<ul id=abc><li>[foo]<li>bar<li>baz</ul>",
    [["insertorderedlist",""]],
    "<ol><li>[foo]</li></ol><ul id=\"abc\"><li>bar</li><li>baz</li></ul>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["<ul style=color:blue><li>[foo]<li>bar<li>baz</ul>",
    [["stylewithcss","true"],["insertorderedlist",""]],
    "<ol><li><span style=\"color:rgb(0, 0, 255)\">[foo]</span></li></ol><ul style=\"color:rgb(0, 0, 255)\"><li>bar</li><li>baz</li></ul>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"insertorderedlist":[false,false,"",false,true,""]}],
["<ul style=color:blue><li>[foo]<li>bar<li>baz</ul>",
    [["stylewithcss","false"],["insertorderedlist",""]],
    "<ol><li><font color=\"#0000ff\">[foo]</font></li></ol><ul style=\"color:rgb(0, 0, 255)\"><li>bar</li><li>baz</li></ul>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"insertorderedlist":[false,false,"",false,true,""]}],
["<ul style=text-indent:1em><li>[foo]<li>bar<li>baz</ul>",
    [["insertorderedlist",""]],
    "<ol><li>[foo]</li></ol><ul style=\"text-indent:1em\"><li>bar</li><li>baz</li></ul>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["<ul id=abc><li>foo<li>bar<li>[baz]</ul>",
    [["insertorderedlist",""]],
    "<ul id=\"abc\"><li>foo</li><li>bar</li></ul><ol><li>[baz]</li></ol>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["<ul style=color:blue><li>foo<li>bar<li>[baz]</ul>",
    [["stylewithcss","true"],["insertorderedlist",""]],
    "<ul style=\"color:rgb(0, 0, 255)\"><li>foo</li><li>bar</li></ul><ol><li><span style=\"color:rgb(0, 0, 255)\">[baz]</span></li></ol>",
    [true,true],
    {"stylewithcss":[false,false,"",false,true,""],"insertorderedlist":[false,false,"",false,true,""]}],
["<ul style=color:blue><li>foo<li>bar<li>[baz]</ul>",
    [["stylewithcss","false"],["insertorderedlist",""]],
    "<ul style=\"color:rgb(0, 0, 255)\"><li>foo</li><li>bar</li></ul><ol><li><font color=\"#0000ff\">[baz]</font></li></ol>",
    [true,true],
    {"stylewithcss":[false,true,"",false,false,""],"insertorderedlist":[false,false,"",false,true,""]}],
["<ul style=text-indent:1em><li>foo<li>bar<li>[baz]</ul>",
    [["insertorderedlist",""]],
    "<ul style=\"text-indent:1em\"><li>foo</li><li>bar</li></ul><ol><li>[baz]</li></ol>",
    [true],
    {"insertorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo</ol> <p>[bar]",
    [["defaultparagraphseparator","div"],["insertorderedlist",""]],
    "<ol><li>foo</li> <li>[bar]</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo</ol> <p>[bar]",
    [["defaultparagraphseparator","p"],["insertorderedlist",""]],
    "<ol><li>foo</li> <li>[bar]</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,false,"",false,true,""]}],
["<p>[foo]</p> <ol><li>bar</ol>",
    [["defaultparagraphseparator","div"],["insertorderedlist",""]],
    "<ol><li>[foo]</li> <li>bar</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,false,"",false,true,""]}],
["<p>[foo]</p> <ol><li>bar</ol>",
    [["defaultparagraphseparator","p"],["insertorderedlist",""]],
    "<ol><li>[foo]</li> <li>bar</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo</ol> <p>[bar]</p> <ol><li>baz</ol>",
    [["defaultparagraphseparator","div"],["insertorderedlist",""]],
    "<ol><li>foo</li> <li>[bar]</li> <li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"p",false,false,"div"],"insertorderedlist":[false,false,"",false,true,""]}],
["<ol><li>foo</ol> <p>[bar]</p> <ol><li>baz</ol>",
    [["defaultparagraphseparator","p"],["insertorderedlist",""]],
    "<ol><li>foo</li> <li>[bar]</li> <li>baz</li></ol>",
    [true,true],
    {"defaultparagraphseparator":[false,false,"div",false,false,"p"],"insertorderedlist":[false,false,"",false,true,""]}]
]
