.ig \"-*- nroff -*-
Copyright (C) 1994, 1995 Free Software Foundation, Inc.

Permission is granted to make and distribute verbatim copies of
this manual provided the copyright notice and this permission notice
are preserved on all copies.

Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided that the
entire resulting derived work is distributed under the terms of a
permission notice identical to this one.

Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be included in
translations approved by the Free Software Foundation instead of in
the original English.
..
.\" Like TP, but if specified indent is more than half
.\" the current line-length - indent, use the default indent.
.de Tp
.ie \\n(.$=0:((0\\$1)*2u>(\\n(.lu-\\n(.iu)) .TP
.el .TP "\\$1"
..
.TH GROLJ4 @MAN1EXT@ "@MDATE@" "Groff Version @VERSION@"
.SH NAME
grolj4 \- groff driver for HP Laserjet 4 family
.SH SYNOPSIS
.B grolj4
[
.B \-lv
] [
.BI \-c n
] [
.BI \-p paper_size
] [
.BI \-w n
] [
.BI \-F dir
] [
.IR files \|.\|.\|.
]
.SH DESCRIPTION
.B grolj4
is a driver for
.B groff
that produces output in PCL5 format suitable for an HP Laserjet 4 printer.
.LP
There is an additional drawing command available:
.TP
.BI \eD'R\  dh\ dv '
Draw a rule (solid black rectangle), with one corner
at the current position, and the diagonally opposite corner
at the current position 
.RI +( dh , dv ).
Afterwards the current position will be at the opposite corner.  This
generates a PCL fill rectangle command, and so will work on
printers that do not support HPGL/2 unlike the other
.B \eD
commands.
.SH OPTIONS
.TP
.BI \-c n
Print
.I n
copies of each page.
.TP
.B \-l
Print the document with a landscape orientation.
.TP
.BI \-p size
Set the paper size to
.IR size ,
which must be one of
letter, legal, executive, a4, com10, monarch, c5, b5, dl.
.TP
.B \-v
Print the version number.
.TP
.BI \-w n
Set the default line thickness to
.I n
thousandths of an em. 
.TP
.BI \-F dir
Search directory
.IB dir /devlj4
for font and device description files.
.SH FILES
.TP
.B @FONTDIR@/devlj4/DESC
Device description file.
.TP
.B @FONTDIR@/devlj4/ F
Font description file for font
.IR F .
.TP
.B @MACRODIR@/tmac.lj4
Macros for use with
.BR grolj4 .
.SH BUGS
Small dots.
.SH "SEE ALSO"
.BR groff (@MAN1EXT@),
.BR @g@troff (@MAN1EXT@),
.BR @g@eqn (@MAN1EXT@),
.BR groff_out (@MAN5EXT@),
.BR groff_font (@MAN5EXT@),
.BR groff_char (@MAN7EXT@),
