/* 
 *    Programmed By: Mohammed Isam Mohammed [mohammed_isam1984@yahoo.com]
 *    Copyright 2014 (c)
 * 
 *    file: mouse.c
 *    This file is part of the GnuDOS project.
 *
 *    GnuDOS is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    GnuDOS is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with GnuDOS.  If not, see <http://www.gnu.org/licenses/>.
 */    
#include "kbd.h"
#include "mouse.h"
#include "gpm.h"

int my_handler(Gpm_Event *event, void *data) 
{
 printf("Event Type: %d at x=%d y=%d\n", event->type, event->x, event->y);
 button = event->type;
 pos.x = event->x;
 pos.y = event->y;
 mouse_handler(button, pos);
}

void restore_mouse() 
{
  if(X_IS_RUNNING) fprintf(stdout, "\e[?1000l");
  else Gpm_Close();
}

int init_mouse() 
{
  if(X_IS_RUNNING) 
  {
    fprintf(stdout, "\e[?1000h");
  }
  else 
  {
    Gpm_Connect conn;
    int c;
    conn.eventMask = ~0;
    conn.defaultMask = 0;
    conn.minMod = 0;
    conn.maxMod = ~0;
    if(Gpm_Open(&conn, 0) == -1)
      return 0;
      //printf("Cannot connect to mouse server\n");  
    gpm_handler = my_handler;
  }
  button = 0;
  pos.x = 0;
  pos.y = 0;
}
