/* 
 *    Programmed By: Mohammed Isam Mohammed [mohammed_isam1984@yahoo.com]
 *    Copyright 2018 (c)
 * 
 *    file: module_c.c
 *    This file is part of mino.
 *
 *    mino is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    mino is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with mino.  If not, see <http://www.gnu.org/licenses/>.
 */    
#include "modules.h"

char *ext_c[] = { "c", "h" };
char *keyword_c[] = {
      //basic C language keywords
      "auto",
      "break",
      "case",
      "char",
      "const",
      "continue",
      "default",
      "do",
      "double",
      "else",
      "enum",
      "extern",
      "float",
      "for",
      "goto",
      "if",
      "int",
      "long",
      "register",
      "return",
      "short",
      "signed",
      "sizeof",
      "static",
      "struct",
      "switch",
      "typedef",
      "union",
      "unsigned",
      "void",
      "volatile",
      "while",
      //math function names
      "acos",
      "asin",
      "atan",
      "atan2",
      "cos",
      "cosh",
      "sin",
      "sinh",
      "tan",
      "tanh",
      "exp",
      "frexp",
      "ldexp",
      "log",
      "log10",
      "modf",
      "pow",
      "sqrt",
      "ceil",
      "fabs",
      "floor",
      "fmod",
      //file function names
      "clearerr",
      "fclose",
      "feof",
      "ferror",
      "fflush",
      "fgetpos",
      "fopen",
      "fread",
      "freopen",
      "fseek",
      "fsetpos",
      "ftell",
      "fwrite",
      "remove",
      "rename",
      "rewind",
      "setbuf",
      "setvbuf",
      "tmpfile",
      "tmpnam",
      //printf function names
      "fprintf",
      "printf",
      "sprintf",
      "vfprintf",
      "vprintf",
      "vsprintf",
      "fscanf",
      "scanf",
      "sscanf",
      "fgetc",
      "fgets",
      "fputc",
      "fputs",
      "getc",
      "getchar",
      "gets",
      "putc",
      "putchar",
      "puts",
      "ungetc",
      "perror",
      //stdlib function names
      "atof",
      "atoi",
      "atol",
      "strtod",
      "strtol",
      "strtoul",
      "calloc",
      "free",
      "malloc",
      "realloc",
      "abort",
      "atexit",
      "exit",
      "getenv",
      "system",
      "bsearch",
      "qsort",
      "abs",
      "div",
      "labs",
      "ldiv",
      "rand",
      "srand",
      "mblen",
      "mbstowcs",
      "mbtowc",
      "wcstombs",
      "wctomb",
      //string function names
      "memchr",
      "memcmp",
      "memcpy",
      "memmove",
      "memset",
      "strcat",
      "strncat",
      "strchr",
      "strcmp",
      "strcoll",
      "strcpy",
      "strncpy",
      "strcspn",
      "strerror",
      "strlen",
      "strpbrk",
      "strrchr",
      "strspn",
      "strstr",
      "strtok",
      "strxfrm",
      //time function names
      "asctime",
      "clock",
      "ctime",
      "difftime",
      "gmtime",
      "localtime",
      "mktime",
      "strftime",
      "time",
      ////////
      "stdin",
      "stdout",
      "stderr",
};

struct modulestruct module_c =
{
    .extsCount      = 2,
    .exts           = ext_c,
    .keywordCount   = 156,
    .keywords       = keyword_c,
    .mlCommentStart = "/*",
    .mlCommentEnd   = "*/",
    .slCommentStart = "//",
    .caseSensitive  = 1,
};
