/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef _SOC_QUALCOMM_SC7280_GPIO_H_
#define _SOC_QUALCOMM_SC7280_GPIO_H_

#include <types.h>
#include <soc/addressmap.h>
#include <soc/gpio_common.h>

#define PIN(index, func1, func2, func3, func4) \
GPIO##index##_ADDR = TLMM_TILE_BASE + (index * TLMM_GPIO_OFF_DELTA), \
GPIO##index##_FUNC_##func1 = 1, \
GPIO##index##_FUNC_##func2 = 2, \
GPIO##index##_FUNC_##func3 = 3, \
GPIO##index##_FUNC_##func4 = 4

enum {
	PIN(0, QUP0_L0, RES_2, RES_3, RES_4),
	PIN(1, QUP0_L1, RES_2, RES_3, RES_4),
	PIN(2, QUP0_L2, QUP0_L4, RES_3, RES_4),
	PIN(3, QUP0_L3, QUP0_L5, RES_3, RES_4),
	PIN(4, QUP0_L0, RES_2, RES_3, RES_4),
	PIN(5, QUP0_L1, RES_2, RES_3, RES_4),
	PIN(6, QUP0_L2, QUP0_L6, RES_3, RES_4),
	PIN(7, USB_AUDIO_INT_N__SBU_SW_OE, QUP0_L3, RES_3, RES_4),
	PIN(8, QUP0_L0, RES_2, RES_3, RES_4),
	PIN(9, QUP0_L1, RES_2, RES_3, RES_4),
	PIN(10, QUP0_L2, RES_2, RES_3, RES_4),
	PIN(11, QUP0_L3, RES_2, RES_3, RES_4),
	PIN(12, QUP0_L0, QSPI_DATA_0, RES_3, RES_4),
	PIN(13, QUP0_L1, QSPI_DATA_1, RES_3, RES_4),
	PIN(14, QUP0_L2, QSPI_CLK, RES_3, RES_4),
	PIN(15, QUP0_L3, QSPI_CS_N_0, RES_3, RES_4),
	PIN(16, QUP0_L0, QSPI_DATA_2, RES_3, RES_4),
	PIN(17, QUP0_L1, QSPI_DATA_3, RES_3, RES_4),
	PIN(18, QUP0_L2, RES_2, RES_3, RES_4),
	PIN(19, QUP0_L3, QSPI_CS_N_1, RES_3, RES_4),
	PIN(20, QUP0_L0, CCI_TIMER_0, RES_3, RES_4),
	PIN(21, QUP0_L1, CCI_TIMER_1, RES_3, RES_4),
	PIN(22, QUP0_L2, RES_2, RES_3, RES_4),
	PIN(23, QUP0_L3, RES_2, RES_3, RES_4),
	PIN(24, QUP0_L0, RES_2, RES_3, RES_4),
	PIN(25, QUP0_L1, RES_2, RES_3, RES_4),
	PIN(26, QUP0_L2, RES_2, RES_3, RES_4),
	PIN(27, QUP0_L3, RES_2, RES_3, RES_4),
	PIN(28, QUP0_L0, RES_2, RES_3, RES_4),
	PIN(29, QUP0_L1, RES_2, RES_3, RES_4),
	PIN(30, QUP0_L2, RES_2, RES_3, RES_4),
	PIN(31, QUP0_L3, RES_2, RES_3, RES_4),
	PIN(32, QUP1_L0, RES_2, RES_3, RES_4),
	PIN(33, QUP1_L1, RES_2, RES_3, RES_4),
	PIN(34, QUP1_L2, RES_2, RES_3, RES_4),
	PIN(35, QUP1_L3, RES_2, RES_3, RES_4),
	PIN(36, QUP1_L0, RES_2, RES_3, RES_4),
	PIN(37, QUP1_L1, RES_2, RES_3, RES_4),
	PIN(38, QUP1_L2, QUP1_L6, RES_3, RES_4),
	PIN(39, QUP1_L3, RES_2, RES_3, RES_4),
	PIN(40, QUP1_L0, RES_2, RES_3, RES_4),
	PIN(41, QUP1_L1, RES_2, RES_3, RES_4),
	PIN(42, QUP1_L2, RES_2, RES_3, RES_4),
	PIN(43, QUP1_L3, RES_2, RES_3, RES_4),
	PIN(44, QUP1_L0, RES_2, RES_3, RES_4),
	PIN(45, QUP1_L1, RES_2, RES_3, RES_4),
	PIN(46, QUP1_L2, RES_2, RES_3, RES_4),
	PIN(47, QUP1_L3, DP_HOT_PLUG_DETECT, RES_3, RES_4),
	PIN(48, QUP1_L0, RES_2, RES_3, RES_4),
	PIN(49, QUP1_L1, RES_2, RES_3, RES_4),
	PIN(50, QUP1_L2, QUP1_L6, RES_3, RES_4),
	PIN(51, QUP1_L3, RES_2, RES_3, RES_4),
	PIN(52, QUP1_L0, RES_2, RES_3, RES_4),
	PIN(53, QUP1_L1, RES_2, RES_3, RES_4),
	PIN(54, QUP1_L2, QUP1_L5, RES_3, RES_4),
	PIN(55, QUP1_L3, QUP1_L4, RES_3, RES_4),
	PIN(56, QUP1_L0, RES_2, RES_3, RES_4),
	PIN(57, QUP1_L1, RES_2, RES_3, RES_4),
	PIN(58, QUP1_L2, RES_2, RES_3, RES_4),
	PIN(59, QUP1_L3, RES_2, RES_3, RES_4),
	PIN(60, QUP1_L0, EDP_HOT_PLUG_DETECT, RES_3, RES_4),
	PIN(61, QUP1_L1, SD_WRITE_PROTECT, RES_3, RES_4),
	PIN(62, QUP1_L2, QUP1_L4, RES_3, RES_4),
	PIN(63, QUP1_L3, QUP1_L5, RES_3, RES_4),
	PIN(64, CAM_MCLK0, RES_2, RES_3, RES_4),
	PIN(65, CAM_MCLK1, RES_2, RES_3, RES_4),
	PIN(66, CAM_MCLK2, RES_2, RES_3, RES_4),
	PIN(67, CAM_MCLK3, RES_2, RES_3, RES_4),
	PIN(68, CAM_MCLK4, RES_2, RES_3, RES_4),
	PIN(69, CCI_I2C_SDA0, RES_2, RES_3, RES_4),
	PIN(70, CCI_I2C_SCL0, RES_2, RES_3, RES_4),
	PIN(71, CCI_I2C_SDA1, RES_2, RES_3, RES_4),
	PIN(72, CCI_I2C_SCL1, RES_2, RES_3, RES_4),
	PIN(73, CCI_I2C_SDA2, RES_2, RES_3, RES_4),
	PIN(74, CCI_I2C_SCL2, RES_2, RES_3, RES_4),
	PIN(75, CCI_I2C_SDA3, RES_2, RES_3, RES_4),
	PIN(76, CCI_I2C_SCL3, GCC_GP1_CLK_MIRB, RES_3, RES_4),
	PIN(77, CCI_TIMER2, GCC_GP2_CLK_MIRB, RES_3, RES_4),
	PIN(78, CCI_TIMER3, CCI_ASYNC_IN1, GCC_GP3_CLK_MIRB, RES_4),
	PIN(79, CCI_TIMER4, CCI_ASYNC_IN2, RES_3, RES_4),
	PIN(80, RES_1, RES_2, RES_3, RES_4),
	PIN(81, RES_1, RES_2, RES_3, RES_4),
	PIN(82, RES_1, RES_2, RES_3, RES_4),
	PIN(83, RES_1, RES_2, RES_3, RES_4),
	PIN(84, USB2PHY_AC_EN0, RES_2, RES_3, RES_4),
	PIN(85, USB2PHY_AC_EN1, RES_2, RES_3, RES_4),
	PIN(86, RES_1, RES_2, RES_3, RES_4),
	PIN(87, RES_1, RES_2, RES_3, RES_4),
	PIN(88, RES_1, RES_2, RES_3, RES_4),
	PIN(89, RES_1, RES_2, RES_3, RES_4),
	PIN(90, RES_1, RES_2, RES_3, RES_4),
	PIN(91, RES_1, RES_2, RES_3, RES_4),
	PIN(92, RES_1, RES_2, RES_3, RES_4),
	PIN(93, CAM_MCLK5, CCI_ASYNC_IN0, RES_3, RES_4),
	PIN(94, LPASS_SLIMBUS_CLK, RES_2, RES_3, RES_4),
	PIN(95, LPASS_SLIMBUS_DATA0, RES_2, RES_3, RES_4),
	PIN(96, PRI_MI2S_MCLK, RES_2, RES_3, RES_4),
	PIN(97, MI2S0_SCK, RES_2, RES_3, RES_4),
	PIN(98, MI2S0_DATA0, RES_2, RES_3, RES_4),
	PIN(99, MI2S0_DATA1, RES_2, RES_3, RES_4),
	PIN(100, MI2S0_WS, RES_2, RES_3, RES_4),
	PIN(101, MI2S2_SCK, RES_2, RES_3, RES_4),
	PIN(102, MI2S2_DATA0, RES_2, RES_3, RES_4),
	PIN(103, MI2S2_WS, RES_2, RES_3, RES_4),
	PIN(104, MI2S2_DATA1, RES_2, RES_3, RES_4),
	PIN(105, SEC_MI2S_MCLK, MI2S1_DATA1, RES_3, GCC_GP1_CLK_MIRA),
	PIN(106, MI2S1_SCK, GCC_GP2_CLK_MIRA, RES_3, RES_4),
	PIN(107, MI2S1_DATA0, GCC_GP3_CLK_MIRA, RES_3, RES_4),
	PIN(108, MI2S1_WS, RES_2, RES_3, RES_4),
	PIN(109, RES_1, RES_2, RES_3, RES_4),
	PIN(110, RES_1, RES_2, RES_3, RES_4),
	PIN(111, RES_1, RES_2, RES_3, RES_4),
	PIN(112, RES_1, RES_2, RES_3, RES_4),
	PIN(113, RES_1, RES_2, RES_3, RES_4),
	PIN(114, RES_1, RES_2, RES_3, RES_4),
	PIN(115, RES_1, RES_2, RES_3, RES_4),
	PIN(116, RES_1, RES_2, RES_3, RES_4),
	PIN(117, RES_1, RES_2, RES_3, RES_4),
	PIN(118, RES_1, RES_2, RES_3, RES_4),
	PIN(119, RES_1, RES_2, RES_3, RES_4),
	PIN(120, RES_1, RES_2, RES_3, RES_4),
	PIN(121, RES_1, RES_2, RES_3, RES_4),
	PIN(122, RES_1, RES_2, RES_3, RES_4),
	PIN(123, RES_1, RES_2, RES_3, RES_4),
	PIN(124, RES_1, RES_2, RES_3, RES_4),
	PIN(125, RES_1, RES_2, RES_3, RES_4),
	PIN(126, RES_1, RES_2, RES_3, RES_4),
	PIN(127, RES_1, RES_2, RES_3, RES_4),
	PIN(128, RES_1, RES_2, RES_3, RES_4),
	PIN(129, RES_1, RES_2, RES_3, RES_4),
	PIN(130, RES_1, RES_2, RES_3, RES_4),
	PIN(131, RES_1, RES_2, RES_3, RES_4),
	PIN(132, RES_1, RES_2, RES_3, RES_4),
	PIN(133, RES_1, RES_2, RES_3, RES_4),
	PIN(134, RES_1, RES_2, RES_3, RES_4),
	PIN(135, RES_1, RES_2, RES_3, RES_4),
	PIN(136, RES_1, RES_2, RES_3, RES_4),
	PIN(137, RES_1, RES_2, RES_3, RES_4),
	PIN(138, RES_1, RES_2, RES_3, RES_4),
	PIN(139, RES_1, RES_2, RES_3, RES_4),
	PIN(140, USB_PHY_PS, RES_2, RES_3, RES_4),
	PIN(141, RES_1, RES_2, RES_3, RES_4),
	PIN(142, RES_1, RES_2, RES_3, RES_4),
	PIN(143, RES_1, RES_2, RES_3, RES_4),
	PIN(144, RES_1, RES_2, RES_3, RES_4),
	PIN(145, RES_1, RES_2, RES_3, RES_4),
	PIN(146, RES_1, RES_2, RES_3, RES_4),
	PIN(147, RES_1, RES_2, RES_3, RES_4),
	PIN(148, RES_1, RES_2, RES_3, RES_4),
	PIN(149, RES_1, RES_2, RES_3, RES_4),
	PIN(150, RES_1, RES_2, RES_3, RES_4),
	PIN(151, RES_1, RES_2, RES_3, RES_4),
	PIN(152, RES_1, RES_2, RES_3, RES_4),
	PIN(153, RES_1, RES_2, RES_3, RES_4),
	PIN(154, RES_1, RES_2, RES_3, RES_4),
	PIN(155, RES_1, RES_2, RES_3, RES_4),
	PIN(156, RES_1, RES_2, RES_3, RES_4),
	PIN(157, RES_1, RES_2, RES_3, RES_4),
	PIN(158, RES_1, RES_2, RES_3, RES_4),
	PIN(159, RES_1, RES_2, RES_3, RES_4),
	PIN(160, RES_1, RES_2, RES_3, RES_4),
	PIN(161, RES_1, RES_2, RES_3, RES_4),
	PIN(162, RES_1, RES_2, RES_3, RES_4),
	PIN(163, RES_1, RES_2, RES_3, RES_4),
	PIN(164, RES_1, RES_2, RES_3, RES_4),
	PIN(165, RES_1, RES_2, RES_3, RES_4),
	PIN(166, RES_1, RES_2, RES_3, RES_4),
	PIN(167, RES_1, RES_2, RES_3, RES_4),
	PIN(168, RES_1, RES_2, RES_3, RES_4),
	PIN(169, RES_1, RES_2, RES_3, RES_4),
	PIN(170, RES_1, RES_2, RES_3, RES_4),
	PIN(171, RES_1, RES_2, RES_3, RES_4),
	PIN(172, RES_1, RES_2, RES_3, RES_4),
	PIN(173, RES_1, RES_2, RES_3, RES_4),
	PIN(174, RES_1, RES_2, RES_3, RES_4),
};

#endif /* _SOC_QUALCOMM_SC7280_GPIO_H_ */
