#
# $Id: tkgnats.cf.t,v 1.3 1993/11/16 22:19:34 jason Exp $
#
# The site configuration file for TkGnats
#
# This file is sourced by the TkGnats scripts
# to obtain various configuration variables.
#

###
### This section is configured by the Makefile.
### You should change this via the Makefile. Do not edit it directly
###

set TkGnats(GNATS_SITE)		wxsystems; ##GNATS_SITE##
				# The name of your site. To be used by
				# tksendpr to find your category list.

set TkGnats(GNATS_ADDR)		wx-bugs@wx.gtegsc.com; ##GNATS_ADDR##
				# The default mail address for 
				# PR submissions to go to.

set TkGnats(TKGNATS_GNATS_ADDR)	 tkgnats-bugs@wx.gtegsc.com;
				# The mail address for 
				# tkgnats PR submissions to go to.
				# used with tksendpr -tkgnats

set TkGnats(Submitter-Id)	$TkGnats(GNATS_SITE);
				# GNATS Submitter-Id for arriving
				# reports at TkGnats(GNATS_ADDR)

set GNATS_ROOT 			/usr/local/gnats; ##GNATS_ROOT##
set LIBDIR			/usr/local/lib; ##LIBDIR##

set TkGnats(lib) 		./; ##TKGNATSLIB##
set TkGnats(pr-edit)		$LIBDIR/gnats/pr-edit
set TkGnats(pr-addr)		$LIBDIR/gnats/pr-addr
set TkGnats(CategoriesFile)	$LIBDIR/gnats/$TkGnats(GNATS_SITE)

###
### Switch which turns on-off use of special REGEXP aware version
### of query-pr. Set this to zero if using the stock GNATS query-pr
###
set TkGnats(RegexAwareQuerypr) 1
##set TkGnats(RegexAwareQuerypr) 0

###
###
###
set TkGnats(FilterDirectory) $LIBDIR/tkgnats-filters
				# directory that contains this systems
				# tkquery output filters (used in the filters
				# menu). if not defined, the menu is not 
				# presented at all

###
### Definitions for various support programs used by tkgnats
###

## set TkGnats(pr_editor)	"xterm -e edit-pr %s"
set TkGnats(pr_editor)		"tkeditpr %s"
				# Format string used for editing a pr. 
				# the %s defines the pr to edit

set TkGnats(PSPreviewer)	"ghostview %s"
				# PostScript previewer for printed reports

set TkGnats(Mailer)		/bin/mail
				# Mailer to use for send prs, etc..

set TkGnats(MailReader)		"mailtool -Mi 240"
				# Mail reader to used by tkgnats script.
				# Commenting this out will cause the
				# 'Mail System' button to be omitted
				# from the tkgnats window

#set TkGnats(InfoReader) 	"xinfo";  # usable but not as nice
set TkGnats(InfoReader)		"tkinfo"; 
				# Info Reader to use
				# tkinfo expects INFOPATH set something like 
				# "setenv INFOPATH /usr/local/info"
				# you can get tkinfo from the Tcl archive

set TkGnats(PSPrintSpooler)	"lpr"
				# PostScript print spooler (from stdin)
				# Note: spaces must be put in between 
				# pipe characters if you use pipes

set TkGnats(PlainPrintSpooler) "fmt -s -75 | lpr"
				# Plain text print spooler (from stdin)
				# Note: spaces must be put in between 
				# pipe characters if you use pipes

#
# TkGnats(LogName)
# The login name for the user.
# 	- first check USER env var
# 	- then try LOGNAME
# 	- then try running whoami
#
if {[info exists env(USER)]} {
    set TkGnats(LogName) $env(USER)
} else {
    if {[info exists env(LOGNAME)]} {
	set TkGnats(LogName) $env(LOGNAME)
    } {
	set TkGnats(LogName) [exec whoami]
    }
}

set TkGnats(TextWrap)		none
				#
				# Type of wrapping to use on multiline
				# text fields
				#


###
### End
###
