.TH XKIBITZ 1 "1 December 1993"
.SH NAME
xkibitz \- allow multiple people to interact in an xterm
.SH SYNOPSIS
.B xkibitz
[
.I program args...
]
.br
.SH INTRODUCTION
.B xkibitz
allows users in separate xterms to share one shell (or any program
that runs in an xterm).  Uses include:
.RS
.TP 4
\(bu
A novice user can ask an expert user for help.  Using
.BR xkibitz ,
the expert can see what the user is doing, and offer advice or
show how to do it right.
.TP
\(bu
By running
.B xkibitz
and then starting a full-screen editor, people may carry out a
conversation, retaining the ability to scroll backwards,
save the entire conversation, or even edit it while in progress.
.TP
\(bu
People can team up on games, document editing, or other cooperative
tasks where each person has strengths and weaknesses that complement one
another.
.TP
\(bu
If you want to have a large number of people do an on-line code
walk-through, you can sit two in front of each workstation, and then
connect them all together while you everyone looks at code together
in the editor.
.SH USAGE
To start
.BR xkibitz ,
one user (the master) runs xkibitz with no arguments.

.B xkibitz
starts a new shell (or another program, if given on the command
line).  The user can interact normally with the shell, or 
upon entering an escape (described when xkibitz starts) can add
users to the interaction.

To add users, enter "+ display" where display is the X display name.
If there is no ":X.Y" in the display name, ":0.0" is assumed.
The master user must have permission to access each display.
Each display is assigned
a tag \- a small integer which can be used to reference the display.

To show the current tags and displays, enter "=".

To drop a display, enter "- tag" where tag is the display's tag
according to the "=" command.

To return to the shared shell, enter "return".  Then the keystrokes of
all users become the input of the shell.  Similarly, all users receive
the output from the shell.

To terminate
.B xkibitz
it suffices to terminate the shell itself.  For example, if any user
types ^D (and the shell accepts this to be EOF), the shell terminates
followed by
.BR xkibitz .

Normally, all characters are passed uninterpreted.  However, in the 
escape dialogue the user talks directly to the
.B xkibitz
interpreter.  Any
.BR Expect (1)
or
.BR Tcl (3)
commands may also be given.
Also, job control may be used while in the interpreter, to, for example,
suspend or restart
.BR xkibitz .

Various processes
can produce various effects.  For example, you can emulate a multi-way write(1)
session with the command:

	xkibitz sleep 1000000
.PP
.SH ARGUMENTS
.B xkibitz
understands a few special arguments.
Each should be separated by whitespace.
If the arguments themselves takes arguments,
these should also be separated by whitespace.

.B \-escape
sets the escape character.  The default escape character is ^].

.B \-display
adds a display much like the "+" command.  Multiple \-display flags
can be given.  For example, to start up xkibitz with three addition
displays:

	xkibitz -display mercury -display fox -display dragon:1.0


.SH CAVEATS
Due to limitations in both X and UNIX, resize propagation is weak.

When the master user resizes the xterm, all the other xterms are logically
resized.  
Unfortunately, xkibitz cannot force the physical xterm size to correspond
with the logical xterm sizes.

The other users are free to resize their xterm but their sizes are not
propagated.  The master can check the logical sizes with the "=" command.

Deducing the window size is a non-portable operation.  The code is known
to work for recent versions of SunOS, AIX, Unicos, and HPUX.  Send back
mods if you add support for anything else.
.SH SEE ALSO
.BR Tcl (3),
.BR libexpect (3)
.BR kibitz (1)
.br
.I
"kibitz \- Connecting Multiple Interactive Programs Together", \fRby Don Libes,
Software \- Practice & Experience, John Wiley & Sons, West Sussex, England,
Vol. 23, No. 5, May, 1993.
.SH AUTHOR
Don Libes, National Institute of Standards and Technology
