%{!?release: %define release 0}
%{!?version: %define version 2.0.4}

%{!?uses_stdcpp:  %define uses_stdcpp 1}

Name: ucommon
Summary: "ucommon" - Portable C++ runtime for threads and sockets
Version: %{version}
Release: %{release}%{?dist}
License: lgplv3+
URL: http://www.gnu.org/software/commoncpp
Group: Development/Libraries
Source0: http://www.gnutelephony.org/dist/tarballs/ucommon-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
BuildRequires: gcc-c++
BuildRequires: doxygen graphviz-gd 

%description
uCommon is a lightweight C++ library to facilitate using C++ design patterns
even for very deeply embedded applications, such as for systems using uClibc
along with POSIX threading support. For this reason, UCommon disables language
features that consume memory or introduce runtime overhead. UCommon introduces
some design patterns from Objective-C, such as reference counted objects,
memory pools, and smart pointers. UCommon introduces some new concepts for
handling of thread locking and synchronization.

%define _libname libucommon2
%define _devname libucommon-devel

%package -n %{_libname}
Group: System/Libraries
Summary: Runtime library for portable C++ threading and sockets
Provides: %{name} = %{version}-%{release}

%package -n %{_devname}
Requires: %{_libname} = %{version}
Group: Development/Libraries
Summary: Headers and static link library
Provides: %{name}-devel = %{version}-%{release}

%package doc
Group: Documentation
Summary: Generated class documentation for ucommon

%description -n %{_libname}
This package contains the runtime library needed by applications that use 
GNU uCommon.

%description -n %{_devname}
Static link and header files for building applications that use uCommon.

%description doc
Generated class documentation for GNU uCommon library from header files, 
html browsable.

%changelog

%prep
%setup
%build

%if %{uses_stdcpp}
%configure CXXFLAGS="$RPM_OPT_FLAGS"
%else
%configure --disable-stdcpp CXXFLAGS="$RPM_OPT_FLAGS" 
%endif
%{__make} %{?_smp_mflags} 
%{__make} doxy

%install

%makeinstall
%{__strip} %{buildroot}/%{_libdir}/lib*.so.*.*

%clean
%{__rm} -rf %{buildroot}

%files -n %{_libname}
%defattr(-,root,root,-)
%doc AUTHORS README COPYING COPYING.LESSER INSTALL NEWS BUILDS SUPPORT ChangeLog
%{_libdir}/*.so.*

%files -n %{_devname}
%defattr(-,root,root,-)
%{_libdir}/*.a
%{_libdir}/*.so
%{_libdir}/*.la
%dir %{_includedir}/ucommon
%{_includedir}/ucommon/*.h
%{_libdir}/pkgconfig/*.pc
%attr(0755,root,root) %{_bindir}/ucommon-config

%files doc
%defattr(-,root,root,-)
%doc doc/html/*

%post -n %{_libname} -p /sbin/ldconfig

%postun -n %{_libname} -p /sbin/ldconfig

