/* LocaleInformation_mt.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_mt extends ListResourceBundle
{
  private static final String currenciesDisplayNameKeys = "MTL";

  private static final String currenciesDisplayNameValues = "Lira Maltija";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "\u00A6");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "\u00A6");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "MTL";

  private static final String currenciesSymbolValues = "Lm";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "\u00A6");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "\u00A6");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[] shortMonths = {
    "Jan",
    "Fra",
    "Mar",
    "Apr",
    "Mej",
    "\u0120un",
    "Lul",
    "Awi",
    "Set",
    "Ott",
    "Nov",
    "Di\u010b",
    null,
  };

  private static final String[] months = {
    "Jannar",
    "Frar",
    "Marzu",
    "April",
    "Mejju",
    "\u0120unju",
    "Lulju",
    "Awissu",
    "Settembru",
    "Ottubru",
    "Novembru",
    "Di\u010bembru",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "\u0126ad",
    "Tne",
    "Tli",
    "Erb",
    "\u0126am",
    "\u0120im",
    "Sib",
  };

  private static final String[] weekdays = {
    null,
    "Il-\u0126add",
    "It-Tnejn",
    "It-Tlieta",
    "L-Erbg\u0127a",
    "Il-\u0126amis",
    "Il-\u0120img\u0127a",
    "Is-Sibt",
  };

  private static final String[] eras = {
    "QK",
    "WK",
  };

  private static final String[][] zoneStrings =
  {
    {  "Europe/Malta", "CET", "\u0126in \u010aentrali Ewropew", "CEST", "\u0126in \u010aentrali Ewropew tas-Sajf"},
  };

  private static final String territoriesKeys = "TL\u00A6TK\u00A6TJ\u00A6TH\u00A6TG\u00A6TF\u00A6GY\u00A6TD\u00A6TC\u00A6GW\u00A6GU\u00A6GT\u00A6GS\u00A6GR\u00A6GQ\u00A6GP\u00A6SZ\u00A6SY\u00A6GN\u00A6GM\u00A6GL\u00A6SV\u00A6ST\u00A6GI\u00A6GH\u00A6SR\u00A6GF\u00A6GE\u00A6SO\u00A6GD\u00A6SN\u00A6SM\u00A6GB\u00A6SL\u00A6GA\u00A6SK\u00A6SJ\u00A6SI\u00A6SH\u00A6SG\u00A6SE\u00A6SD\u00A6SC\u00A6SB\u00A6SA\u00A6FR\u00A6FO\u00A6FM\u00A6RW\u00A6FK\u00A6RU\u00A6FJ\u00A6FI\u00A6RO\u00A6RE\u00A6ET\u00A6ES\u00A6ER\u00A6EH\u00A6EG\u00A6EE\u00A6EC\u00A6DZ\u00A6QA\u00A6DO\u00A6PY\u00A6DM\u00A6PW\u00A6DK\u00A6DJ\u00A6PT\u00A6PS\u00A6PR\u00A6DE\u00A6PN\u00A6PM\u00A6PL\u00A6PK\u00A6PH\u00A6PG\u00A6PF\u00A6CZ\u00A6PE\u00A6CY\u00A6CX\u00A6CV\u00A6PA\u00A6CU\u00A6CR\u00A6CO\u00A6CN\u00A6CM\u00A6CL\u00A6CK\u00A6CI\u00A6CH\u00A6CG\u00A6CF\u00A6CD\u00A6CC\u00A6OM\u00A6CA\u00A6BZ\u00A6BY\u00A6BW\u00A6BV\u00A6BT\u00A6BS\u00A6BR\u00A6NZ\u00A6BO\u00A6BN\u00A6BM\u00A6NU\u00A6BJ\u00A6BI\u00A6BH\u00A6NR\u00A6BG\u00A6BF\u00A6NP\u00A6BE\u00A6NO\u00A6BD\u00A6BB\u00A6ZW\u00A6NL\u00A6BA\u00A6NI\u00A6NG\u00A6NF\u00A6AZ\u00A6NE\u00A6NC\u00A6AW\u00A6ZM\u00A6NA\u00A6AU\u00A6AT\u00A6AS\u00A6AR\u00A6AQ\u00A6MZ\u00A6AO\u00A6MY\u00A6AN\u00A6MX\u00A6AM\u00A6MW\u00A6AL\u00A6MV\u00A6ZA\u00A6MU\u00A6MT\u00A6AI\u00A6MS\u00A6MR\u00A6AG\u00A6MQ\u00A6AF\u00A6MP\u00A6AE\u00A6MO\u00A6AD\u00A6MN\u00A6MM\u00A6ML\u00A6MK\u00A6YU\u00A6YT\u00A6MH\u00A6MG\u00A6MD\u00A6MC\u00A6MA\u00A6YE\u00A6LY\u00A6LV\u00A6LU\u00A6LT\u00A6LS\u00A6LR\u00A6LK\u00A6LI\u00A6LC\u00A6LB\u00A6LA\u00A6KZ\u00A6KY\u00A6KW\u00A6KR\u00A6KP\u00A6KN\u00A6KM\u00A6KI\u00A6WS\u00A6KH\u00A6KG\u00A6KE\u00A6WF\u00A6JP\u00A6JO\u00A6JM\u00A6VU\u00A6VN\u00A6VI\u00A6VG\u00A6VE\u00A6VC\u00A6VA\u00A6IT\u00A6IS\u00A6IR\u00A6IQ\u00A6UZ\u00A6IO\u00A6UY\u00A6IN\u00A6IL\u00A6US\u00A6IE\u00A6ID\u00A6UM\u00A6UG\u00A6UA\u00A6HU\u00A6HT\u00A6HR\u00A6TZ\u00A6HN\u00A6HM\u00A6TW\u00A6TV\u00A6HK\u00A6TT\u00A6TR\u00A6TO\u00A6TN\u00A6TM";

  private static final String territoriesValues = "Timor tal-Lvant\u00A6Tokelaw\u00A6Ta\u0121ikistan\u00A6Tajlandja\u00A6Togo\u00A6Territorji Fran\u010bi\u017ci ta' Nofsinhar\u00A6Gujana\u00A6\u010aad\u00A6Turks and Caicos Islands\u00A6Ginea-Bissaw\u00A6Gwam\u00A6Gwatemala\u00A6South Georgia and the South Sandwich Islands\u00A6Gre\u010bja\u00A6Ginea Ekwatorjali\u00A6Gwadelupe\u00A6Swa\u017ciland\u00A6Sirja\u00A6Gineja\u00A6Gambja\u00A6Grinlandja\u00A6El Salvador\u00A6Sao Tome and Principe\u00A6Gibraltar\u00A6Gana\u00A6Surinam\u00A6Gujana Fran\u010bi\u017ca\u00A6\u0120or\u0121ja\u00A6Somalja\u00A6Grenada\u00A6Senegal\u00A6San Marino\u00A6Ingilterra\u00A6Sierra Leone\u00A6Gabon\u00A6Slovakkja\u00A6Svalbard and Jan Mayen\u00A6Slovenja\u00A6Saint Helena\u00A6Singapor\u00A6\u017bvezja\u00A6Sudan\u00A6Seychelles\u00A6Solomon Islands\u00A6G\u0127arabja Sawdita\u00A6Franza\u00A6G\u017cejjer Faroe\u00A6Mikronesja\u00A6Rwanda\u00A6Falkland Islands\u00A6Russja\u00A6Fi\u0121i\u00A6Finlandja\u00A6Rumanija\u00A6R\u00e9union\u00A6Etijopja\u00A6Spanja\u00A6Eritreja\u00A6Sahara tal-Punent\u00A6E\u0121ittu\u00A6Estonja\u00A6Ekwador\u00A6Al\u0121erija\u00A6Qatar\u00A6Republikka Domenikana\u00A6Paragwaj\u00A6Dominika\u00A6Palau\u00A6Danimarka\u00A6\u0120ibuti\u00A6Portugall\u00A6Palestinian Territory\u00A6Puerto Rico\u00A6\u0120ermanja\u00A6Pitcairn\u00A6Saint Pierre and Miquelon\u00A6Polonja\u00A6Pakistan\u00A6Filippini\u00A6Papwa-Ginea \u0120dida\u00A6Polinesja Fran\u010bi\u017ca\u00A6Repubblika \u010aeka\u00A6Peru\u00A6\u010aipru\u00A6Christmas Island\u00A6Kape Verde\u00A6Panama\u00A6Kuba\u00A6Kosta Rika\u00A6Kolumbja\u00A6\u010aina\u00A6Kamerun\u00A6\u010aili\u00A6Cook Islands\u00A6Kosta ta' l-Avorju\u00A6Svizzera\u00A6Kongo\u00A6Repubblika Afrikana \u010aentrali\u00A6Democratic Republic of the Congo\u00A6Cocos (Keeling) Islands\u00A6Oman\u00A6Kanada\u00A6Beli\u017ce\u00A6Bjelorussja\u00A6Botswana\u00A6Bouvet Island\u00A6Butan\u00A6Ba\u0127amas\u00A6Bra\u017cil\u00A6New Zealand\u00A6Bolivja\u00A6Brunej\u00A6Bermuda\u00A6Niue\u00A6Benin\u00A6Burundi\u00A6Ba\u0127rajn\u00A6Nauru\u00A6Bulgarija\u00A6Burkina Faso\u00A6Nepal\u00A6Bel\u0121ju\u00A6Norve\u0121ja\u00A6Bangladexx\u00A6Barbados\u00A6\u017bimbabwe\u00A6Olanda\u00A6Bo\u017cnija \u0126er\u017cegovina\u00A6Nikaragwa\u00A6Ni\u0121erja\u00A6Norfolk Island\u00A6A\u017cerbaj\u0121an\u00A6Ni\u0121er\u00A6New Caledonia\u00A6Aruba\u00A6\u017bambja\u00A6Namibja\u00A6Awstralja\u00A6Awstrija\u00A6Samoa Amerikana\u00A6Ar\u0121entina\u00A6Antarctica\u00A6Mo\u017cambik\u00A6Angola\u00A6Malasja\u00A6Antilles Olandi\u017ci\u00A6Messiku\u00A6Armenja\u00A6Malawi\u00A6Albanija\u00A6Maldives\u00A6Afrika t'Isfel\u00A6Mawrizju\u00A6Malta\u00A6Angwilla\u00A6Montserrat\u00A6Mawritanja\u00A6Antigua and Barbuda\u00A6Martinik\u00A6Afganistan\u00A6G\u017cejjer Marjana ta' Fuq\u00A6Emirati G\u0127arab Maqg\u0127uda\u00A6Macao S.A.R., China\u00A6Andorra\u00A6Mongolja\u00A6Mjanmar\u00A6Mali\u00A6Ma\u010bedonja\u00A6Jugoslavja\u00A6Majotte\u00A6G\u017cejjer ta' Marshall\u00A6Madagaskar\u00A6Maldova\u00A6Monako\u00A6Marokk\u00A6Jemen\u00A6Libja\u00A6Latvja\u00A6Lussemburgu\u00A6Litwanja\u00A6Lesoto\u00A6Liberja\u00A6Sri Lanka\u00A6Liechtenstein\u00A6Saint Lucia\u00A6Libanu\u00A6Laos\u00A6Ka\u017cakstan\u00A6Cayman Islands\u00A6Kuwajt\u00A6Koreja t'Isfel\u00A6Koreja ta' Fuq\u00A6Saint Kitts and Nevis\u00A6Komoros\u00A6Kiribati\u00A6Samoa\u00A6Kambodja\u00A6Kirgistan\u00A6Kenja\u00A6Wallis and Futuna\u00A6\u0120appun\u00A6\u0120ordan\u00A6\u0120amajka\u00A6Vanwatu\u00A6Vjetnam\u00A6U.S. Virgin Islands\u00A6British Virgin Islands\u00A6Venezwela\u00A6Saint Vincent and the Grenadines\u00A6Vatikan\u00A6Italja\u00A6Islanda\u00A6Iran\u00A6Iraq\u00A6U\u017cbekistan\u00A6British Indian Ocean Territory\u00A6Urugwaj\u00A6Indja\u00A6I\u017crael\u00A6Stati Uniti\u00A6Irlanda\u00A6Indone\u017cja\u00A6United States Minor Outlying Islands\u00A6Uganda\u00A6Ukraina\u00A6Ungerija\u00A6\u0126aiti\u00A6Kroazja\u00A6Tan\u017canija\u00A6\u0126onduras\u00A6Heard Island and McDonald Islands\u00A6Tajwan\u00A6Tuvalu\u00A6\u0126ong Kong S.A.R., \u010aina\u00A6Trinidad u Tobago\u00A6Turkija\u00A6Tonga\u00A6Tune\u017c\u00A6Turkmenistan";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "\u00A6");
    Enumeration values = new StringTokenizer(territoriesValues, "\u00A6");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "gwi\u00A6akk\u00A6eka\u00A6ijo\u00A6xh\u00A6sux\u00A6sus\u00A6mis\u00A6loz\u00A6tog\u00A6pon\u00A6min\u00A6suk\u00A6wo\u00A6lol\u00A6kut\u00A6mic\u00A6wa\u00A6kum\u00A6zap\u00A6cus\u00A6jbo\u00A6doi\u00A6vo\u00A6oto\u00A6vi\u00A6vai\u00A6rar\u00A6ve\u00A6rap\u00A6raj\u00A6ota\u00A6nzi\u00A6nap\u00A6uz\u00A6uga\u00A6tmh\u00A6nai\u00A6nah\u00A6ur\u00A6fat\u00A6uk\u00A6egy\u00A6ug\u00A6fan\u00A6ssa\u00A6mga\u00A6bat\u00A6nyo\u00A6bas\u00A6nyn\u00A6nym\u00A6hmn\u00A6ban\u00A6osa\u00A6bal\u00A6ty\u00A6bai\u00A6tw\u00A6srr\u00A6tli\u00A6tlh\u00A6tt\u00A6ts\u00A6bad\u00A6tr\u00A6to\u00A6tn\u00A6tl\u00A6tk\u00A6ti\u00A6th\u00A6kru\u00A6tg\u00A6byn\u00A6te\u00A6kro\u00A6csb\u00A6ta\u00A6tkl\u00A6efi\u00A6sw\u00A6sv\u00A6su\u00A6krc\u00A6st\u00A6ss\u00A6sr\u00A6sq\u00A6men\u00A6crp\u00A6so\u00A6afh\u00A6sn\u00A6sm\u00A6sl\u00A6grc\u00A6sk\u00A6grb\u00A6si\u00A6sh\u00A6crh\u00A6afa\u00A6sg\u00A6se\u00A6sd\u00A6udm\u00A6sc\u00A6sa\u00A6rw\u00A6nwc\u00A6ru\u00A6mdr\u00A6ro\u00A6rn\u00A6rm\u00A6mdf\u00A6tiv\u00A6ady\u00A6zun\u00A6kpe\u00A6qu\u00A6tig\u00A6son\u00A6cpp\u00A6sog\u00A6ada\u00A6kos\u00A6hit\u00A6cpf\u00A6cpe\u00A6him\u00A6kok\u00A6hil\u00A6got\u00A6gor\u00A6gon\u00A6din\u00A6nub\u00A6pt\u00A6ps\u00A6fur\u00A6phn\u00A6goh\u00A6snk\u00A6cop\u00A6yap\u00A6ach\u00A6yao\u00A6phi\u00A6pl\u00A6ace\u00A6pi\u00A6pa\u00A6bug\u00A6iba\u00A6sms\u00A6bua\u00A6mas\u00A6smn\u00A6os\u00A6map\u00A6or\u00A6man\u00A6smj\u00A6smi\u00A6mak\u00A6om\u00A6mai\u00A6oj\u00A6mag\u00A6mad\u00A6sma\u00A6oc\u00A6nso\u00A6btk\u00A6myv\u00A6dgr\u00A6ny\u00A6myn\u00A6nv\u00A6kmb\u00A6nr\u00A6gmh\u00A6no\u00A6nn\u00A6nl\u00A6root\u00A6ng\u00A6sla\u00A6ne\u00A6nd\u00A6cmc\u00A6tet\u00A6nb\u00A6na\u00A6ter\u00A6tem\u00A6my\u00A6lez\u00A6mt\u00A6peo\u00A6ms\u00A6mr\u00A6fro\u00A6mo\u00A6frm\u00A6mn\u00A6jrb\u00A6ml\u00A6mk\u00A6mi\u00A6mh\u00A6mg\u00A6mwr\u00A6bra\u00A6den\u00A6lv\u00A6lu\u00A6del\u00A6lt\u00A6lo\u00A6ln\u00A6li\u00A6ewo\u00A6lg\u00A6lb\u00A6la\u00A6jpr\u00A6vot\u00A6sit\u00A6ky\u00A6kw\u00A6kv\u00A6ku\u00A6sio\u00A6ks\u00A6kr\u00A6awa\u00A6ko\u00A6kn\u00A6km\u00A6kl\u00A6kk\u00A6rom\u00A6kj\u00A6sid\u00A6ki\u00A6kg\u00A6non\u00A6ka\u00A6mus\u00A6roa\u00A6nog\u00A6mun\u00A6mul\u00A6jv\u00A6gil\u00A6znd\u00A6shn\u00A6fon\u00A6xal\u00A6aus\u00A6kho\u00A6ja\u00A6khi\u00A6pau\u00A6chy\u00A6tai\u00A6iu\u00A6pap\u00A6it\u00A6sgn\u00A6is\u00A6kha\u00A6chr\u00A6pam\u00A6pal\u00A6chp\u00A6io\u00A6cho\u00A6chn\u00A6chm\u00A6tyv\u00A6bnt\u00A6pag\u00A6ik\u00A6chk\u00A6ii\u00A6haw\u00A6lam\u00A6ig\u00A6chg\u00A6sga\u00A6paa\u00A6ie\u00A6id\u00A6lah\u00A6day\u00A6chb\u00A6ia\u00A6lad\u00A6hz\u00A6hai\u00A6dar\u00A6hy\u00A6ath\u00A6hu\u00A6ht\u00A6dak\u00A6hr\u00A6ho\u00A6hi\u00A6dyu\u00A6he\u00A6ast\u00A6ha\u00A6wen\u00A6gv\u00A6gu\u00A6sem\u00A6sel\u00A6iro\u00A6gn\u00A6gl\u00A6arw\u00A6gez\u00A6art\u00A6gd\u00A6ira\u00A6ga\u00A6arp\u00A6arn\u00A6fy\u00A6bla\u00A6gem\u00A6ypk\u00A6arc\u00A6fr\u00A6fo\u00A6cel\u00A6fj\u00A6fi\u00A6ff\u00A6tvl\u00A6ceb\u00A6fa\u00A6eu\u00A6sco\u00A6et\u00A6es\u00A6eo\u00A6en\u00A6el\u00A6tut\u00A6niu\u00A6tup\u00A6ee\u00A6tum\u00A6mos\u00A6dz\u00A6nic\u00A6lus\u00A6fiu\u00A6dv\u00A6nia\u00A6moh\u00A6luo\u00A6lun\u00A6apa\u00A6lui\u00A6hup\u00A6bin\u00A6de\u00A6lua\u00A6bik\u00A6was\u00A6und\u00A6war\u00A6da\u00A6dum\u00A6wal\u00A6mno\u00A6wak\u00A6sat\u00A6cy\u00A6sas\u00A6kbd\u00A6cv\u00A6cu\u00A6mni\u00A6cs\u00A6sam\u00A6cr\u00A6sal\u00A6dua\u00A6co\u00A6sai\u00A6mnc\u00A6sah\u00A6kaw\u00A6inh\u00A6gba\u00A6sad\u00A6ch\u00A6ine\u00A6bho\u00A6enm\u00A6kar\u00A6inc\u00A6ce\u00A6gay\u00A6ca\u00A6umb\u00A6syr\u00A6kam\u00A6tsi\u00A6ang\u00A6kac\u00A6cau\u00A6kab\u00A6kaa\u00A6bs\u00A6car\u00A6br\u00A6bo\u00A6bn\u00A6bm\u00A6gaa\u00A6cai\u00A6bi\u00A6bh\u00A6bg\u00A6be\u00A6cad\u00A6ba\u00A6zu\u00A6zen\u00A6pro\u00A6hsb\u00A6az\u00A6ay\u00A6av\u00A6as\u00A6dsb\u00A6ar\u00A6ilo\u00A6elx\u00A6zh\u00A6an\u00A6pra\u00A6am\u00A6new\u00A6ak\u00A6za\u00A6af\u00A6ae\u00A6ab\u00A6aa\u00A6yo\u00A6alg\u00A6ale\u00A6mkh\u00A6yi\u00A6dra\u00A6ber\u00A6nds\u00A6bem\u00A6bej\u00A6tpi";

  private static final String languagesValues = "Gwi\u010bin\u00A6Akkadjen\u00A6Ekajuk\u00A6I\u0121o\u00A6\u0126o\u017ca\u00A6Sumerjan\u00A6Susu\u00A6Lingwi O\u0127ra\u00A6Lo\u017ci\u00A6Tonga (Njasa)\u00A6Ponpejan\u00A6Minangkabaw\u00A6Sukuma\u00A6Wolof\u00A6Mongo\u00A6Kutenaj\u00A6Mikmek\u00A6Walloon\u00A6Kumiku\u00A6\u017bapotek\u00A6Kuxtiku (O\u0127ra)\u00A6Lojban\u00A6Dogri\u00A6Volapuk\u00A6Lingwi Otomjani\u00A6Vjetnami\u017c\u00A6Vai\u00A6Rarotongani\u00A6Venda\u00A6Rapanwi\u00A6Ra\u0121astani\u00A6Tork (Imperu Ottoman)\u00A6N\u017cima\u00A6Neapolitan\u00A6U\u017cbek\u00A6Ugaritiku\u00A6Tamaxek\u00A6Indjan tal-Amerika ta' Fuq (O\u0127ra)\u00A6Na\u0127watil\u00A6Urdu\u00A6Fanti\u00A6Ukranjan\u00A6E\u0121izzjan (Antik)\u00A6Wigur\u00A6Fang\u00A6Nilo-Sa\u0127aram\u00A6Irlandi\u017c, Medjevali (900-1200)\u00A6Baltiku (O\u0127ra)\u00A6Njoro\u00A6Basa\u00A6Nyankole\u00A6Njamwe\u017ci\u00A6\u0126mong\u00A6Balini\u017c\u00A6Osa\u0121jan\u00A6Balu\u010bi\u00A6Ta\u0127itjan\u00A6Lingwi Bamileke\u00A6Twi\u00A6Serer\u00A6Tlingit\u00A6Klingon\u00A6Tatar\u00A6Tsonga\u00A6Banda\u00A6Tork\u00A6Tongan (G\u017cejjer ta' Tonga)\u00A6Zwana\u00A6Tagalog\u00A6Turkmeni\u00A6Tigrinja\u00A6Tajlandi\u017c\u00A6Kurusk\u00A6Ta\u0121ik\u00A6Blin\u00A6Telugu\u00A6Kru\u00A6Kashubian\u00A6Tamil\u00A6Tokelau\u00A6Efik\u00A6Swa\u0127ili\u00A6Svedi\u017c\u00A6Sundani\u017c\u00A6Karachay-Balkar\u00A6Soto, t'Isfel\u00A6Swati\u00A6Serb\u00A6Albani\u017c\u00A6Mende\u00A6Kreoli u Pi\u0121ini (O\u0127ra)\u00A6Somali\u00A6Afri\u0127ili\u00A6Xona\u00A6Samojan\u00A6Slav\u00A6Grieg, Antik (to 1453)\u00A6Slovakk\u00A6\u0120erbo\u00A6Sin\u0127ali\u017c\u00A6Serbo-Kroat\u00A6Crimean Turkish; Crimean Tatar\u00A6Afro-Asjatiku (O\u0127ra)\u00A6Sango\u00A6Sami ta' Fuq\u00A6Sindi\u00A6Udmurt\u00A6Sardinjan\u00A6Sanskrit\u00A6Kinjarwanda\u00A6Classical Newari\u00A6Russu\u00A6Mandar\u00A6Rumen\u00A6Rundi\u00A6Reto-Romanz\u00A6Moksha\u00A6Tiv\u00A6Adyghe\u00A6\u017buni\u00A6Kpelle\u00A6Ke\u010bwa\u00A6Tigre\u00A6Songaj\u00A6Creoles and pidgins, Portuguese-based (Other)\u00A6Sogdien\u00A6Adangme\u00A6Kosrejan\u00A6\u0126ittit\u00A6Kreoli u Pi\u0121ini, Bba\u017cat fuq il-Fran\u010bi\u017c (O\u0127ra)\u00A6Kreoli u Pi\u0121ini, Bba\u017cat fuq l-Ingli\u017c (O\u0127ra)\u00A6\u0126ima\u010bali\u00A6Konkani\u00A6Hiligaynon\u00A6Gotiku\u00A6Gorontalo\u00A6Gondi\u00A6Dinka\u00A6Lingwi Nubjani\u00A6Portugi\u017c\u00A6Paxtun\u00A6Frijuljan\u00A6Feni\u010bju\u00A6\u0120ermaniku, Antik Pulit (ca. 750-1050)\u00A6Soninke\u00A6Koptiku\u00A6Japese\u00A6Akoli\u00A6Jao\u00A6Filippin (O\u0127ra)\u00A6Pollakk\u00A6A\u010bini\u017c\u00A6Pali\u00A6Pun\u0121abi\u00A6Bugini\u017c\u00A6Iban\u00A6Skolt Sami\u00A6Burjat\u00A6Masaj\u00A6Inari Sami\u00A6Ossettiku\u00A6Awstronesjan\u00A6Orija\u00A6Mandingwan\u00A6Lule Sami\u00A6Sami languages (Other)\u00A6Makasar\u00A6Oromo (Afan)\u00A6Majtili\u00A6O\u0121ibwa\u00A6Maga\u0127i\u00A6Maduri\u017c\u00A6Southern Sami\u00A6Provenzal (wara 1500)\u00A6Soto, ta' Fuq\u00A6Batak\u00A6Erzya\u00A6Dogrib\u00A6\u010ai\u010bewa; Njan\u0121a\u00A6Majan\u00A6Nava\u0127o\u00A6Kimbundu\u00A6Ndebele, t'Isfel\u00A6\u0120ermaniku, Medjevali Pulit (ca. 1050-1500)\u00A6Norve\u0121i\u017c\u00A6Ninorsk Norve\u0121i\u017c\u00A6Olandi\u017c\u00A6G\u0127erq\u00A6Ndonga\u00A6Slavic (Other)\u00A6Nepali\u017c\u00A6Ndebele, ta' Fuq\u00A6Lingwi \u010aamiki\u00A6Tetum\u00A6Bokmahal Norve\u0121i\u017c\u00A6Nawuru\u00A6Tereno\u00A6Timne\u00A6Burmi\u017c\u00A6Le\u017cgjan\u00A6Malti\u00A6Persjan Antik (ca. 600-400 Q.K.)\u00A6Malajan\u00A6Marati\u00A6Fran\u010bi\u017c, Antik (842-ca. 1400)\u00A6Moldavjan\u00A6Fran\u010bi\u017c, Medjevali (ca. 1400-1600)\u00A6Mongoljan\u00A6Lhudi-G\u0127arbi\u00A6Malajalam\u00A6Ma\u010bedonjan\u00A6Maori\u00A6Marxall\u00A6Malaga\u017ci\u00A6Marwari\u00A6Braj\u00A6Slav\u00A6Latvjan (Lettix)\u00A6Luba-Katanga\u00A6Delawerjan\u00A6Litwanjan\u00A6Lao\u00A6Lingaljan\u00A6Limburgish\u00A6Ewondo\u00A6Ganda\u00A6Let\u017cburgi\u017c\u00A6Latin\u00A6Lhudi-Persjan\u00A6Votik\u00A6Sino-Tibetjani (O\u0127ra)\u00A6Kirgi\u017c\u00A6Korniku\u00A6Komi\u00A6Kurdi\u017c\u00A6Lingwi Suwjani\u00A6Kaxmiri\u00A6Kanuri\u00A6Awad\u0127i\u00A6Korejan\u00A6Kannada\u00A6Kmer\u00A6Kalallisut\u00A6Ka\u017cak\u00A6\u017bingaru\u00A6Kuanyama\u00A6Sidamo\u00A6Kikuju\u00A6Kongo\u00A6Skandinav, Antik\u00A6\u0120or\u0121jan\u00A6Kriek\u00A6Romanz (O\u0127ra)\u00A6Nogai\u00A6Lingwi tal-Munda\u00A6Lingwi Diversi\u00A6\u0120avani\u017c\u00A6Gilbertjan\u00A6\u017bande\u00A6Xan\u00A6Fon\u00A6Kalmyk\u00A6Lingwi Awstraljani\u00A6Kotani\u017c\u00A6\u0120appuni\u017c\u00A6Kojsan\u00A6Palawjan\u00A6Xajenn\u00A6Tai (O\u0127ra)\u00A6Inukitut\u00A6Papjamento\u00A6Taljan\u00A6Lingwa tas-Sinjali\u00A6I\u017clandi\u017c\u00A6Kasi\u00A6\u010aerokij\u00A6Pampamga\u00A6Pa\u0127lavi\u00A6\u010aipewjan\u00A6Ido\u00A6\u010aostaw\u00A6\u0120argon ta\u010b-\u010ainuk\u00A6Mari\u00A6Tuvinjan\u00A6Bantu\u00A6Pangasinjan\u00A6Inupjak\u00A6\u010aukese\u00A6Sichuan Yi\u00A6\u0126awajjan\u00A6Lamba\u00A6Igbo\u00A6\u010aagataj\u00A6Irlandi\u017c, Antik (sa l-900)\u00A6Papwan (O\u0127ra)\u00A6Interlingue\u00A6Indone\u017cjan\u00A6Landa\u00A6Dajak\u00A6\u010aib\u010ba\u00A6Interlingua\u00A6Ladino\u00A6\u0126erero\u00A6\u0126ajda\u00A6Dargwa\u00A6Armenjan\u00A6Lingwi Atabaskani\u00A6Ungeri\u017c\u00A6Haitian\u00A6Dakota\u00A6Kroat\u00A6\u0126iri Motu\u00A6\u0126indi\u00A6Djula\u00A6Ebrajk\u00A6Asturian\u00A6\u0126awsa\u00A6Lingwi Sorbjani\u00A6Manks\u00A6Gu\u0121arati\u00A6Semitiku\u00A6Selkup\u00A6Lingwi Irogwjani\u00A6Gwarani\u00A6Gallegjan\u00A6Arawak\u00A6Geez\u00A6Artifi\u010bjali (O\u0127ra)\u00A6Galliku Sko\u010b\u010bi\u017c\u00A6Iranjan\u00A6Irlandi\u017c\u00A6Arapa\u0127o\u00A6Arawkanjan\u00A6Fri\u017cjan\u00A6Siksika\u00A6\u0120ermaniku (O\u0127ra)\u00A6Lingwi Jupi\u010bi\u00A6Aramajk\u00A6Fran\u010bi\u017c\u00A6Fawri\u017c\u00A6Keltiku (O\u0127ra)\u00A6Fi\u0121i\u00A6Finlandi\u017c\u00A6Fula\u0127\u00A6Tuvalu\u00A6Sibwano\u00A6Persjan\u00A6Bask\u00A6Sko\u010b\u010bi\u017c\u00A6Estonjan\u00A6Spanjol\u00A6Esperanto\u00A6Ingli\u017c\u00A6Grieg\u00A6Altajk (O\u0127ra)\u00A6Nijuwejan\u00A6Tupi languages\u00A6Ewe\u00A6Tumbuka\u00A6Mossi\u00A6D\u017congka\u00A6Ni\u0121erjan - Kordofanjan\u00A6Luxaj\u00A6Finno - Ugrijan\u00A6Dive\u0127i\u00A6Nijas\u00A6Mo\u0127ak\u00A6Luwa\u00A6Lunda\u00A6Lingwi Apa\u010bi\u00A6Luwisinu\u017c\u00A6\u0126upa\u00A6Bini\u00A6\u0120ermani\u017c\u00A6Luba-Luluwa\u00A6Bikol\u00A6Waxo\u00A6Indeterminat\u00A6Waraj\u00A6Dani\u017c\u00A6Olandi\u017c, Medjevali (ca. 1050-1350)\u00A6Walamo\u00A6Lingwi Manobo\u00A6Lingwi Wakaxani\u00A6Santali\u00A6Welx\u00A6Saska\u00A6Kabardian\u00A6\u010auvax\u00A6Slaviku tal-Knisja\u00A6Manipuri\u00A6\u010aek\u00A6Samritan\u00A6Krij\u00A6Salixan\u00A6Dwala\u00A6Korsiku\u00A6Indjan tal-Amerika t'Isfel (O\u0127ra)\u00A6Man\u010burjan\u00A6Jakut\u00A6Kawi\u00A6Ingush\u00A6Gbaja\u00A6Sandawe\u00A6\u010aamorro\u00A6Indo-Ewropew\u00A6Bojpuri\u00A6Ingli\u017c, Medjevali (1100-1500)\u00A6Karen\u00A6Indjan (O\u0127ra)\u00A6\u010ae\u010ben\u00A6Gajo\u00A6Katalan\u00A6Umbundu\u00A6Sirjan\u00A6Kamba\u00A6Zimxjan\u00A6Ingli\u017c, Antik (ca.450-1100)\u00A6Ka\u010bin\u00A6Kawkasu (O\u0127ra)\u00A6Kabuljan\u00A6Kara-Kalpak\u00A6Bosnijan\u00A6Karib\u00A6Brenton\u00A6Tibetjan\u00A6Bengali\u00A6Bambara\u00A6Ga\u00A6Amerika \u010aentrali (O\u0127ra)\u00A6Bislama\u00A6Bi\u0127ari\u00A6Bulgaru\u00A6Belarussu\u00A6Kaddo\u00A6Baxkir\u00A6\u017bulu\u00A6\u017benaga\u00A6Provenzal, Antik (sa l-1500)\u00A6Upper Sorbian\u00A6A\u017cerbaj\u0121ani\u00A6Ajmara\u00A6Avarik\u00A6Assamese\u00A6Lower Sorbian\u00A6G\u0127arbi\u00A6Iloko\u00A6Elamit\u00A6\u010aini\u017c\u00A6Aragonese\u00A6Lingwi Prakriti\u00A6Am\u0127ariku\u00A6Newari\u00A6Akan\u00A6\u017bwang\u00A6Afrikans\u00A6Avestan\u00A6Abka\u017cjan\u00A6Afar\u00A6Joruba\u00A6Lingwi Algonqwinjani\u00A6Aleut\u00A6Mon-Kmer (O\u0127ra)\u00A6Jiddix\u00A6Dravidjan (O\u0127ra)\u00A6Beber\u00A6\u0120ermani\u017c Komuni; Sassonu Komuni\u00A6Bemba\u00A6Beja\u00A6Tok Pisin";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "\u00A6");
    Enumeration values = new StringTokenizer(languagesValues, "\u00A6");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "eras", eras },
    { "shortDateFormat", "dd/MM/yyyy" },
    { "mediumDateFormat", "dd MMM yyyy" },
    { "longDateFormat", "d 'ta''' MMMM yyyy" },
    { "fullDateFormat", "EEEE, d 'ta''' MMMM yyyy" },
    { "zoneStrings", zoneStrings },
    { "territories", territories },
    { "languages", languages },
  };

  public Object[][] getContents() { return contents; }
}
