#ifndef REROUTE_H
#define REROUTE_H

#define DEMANDE_REROUTAGE	0x81
#define REROUTE_LEN_MAX		65

#define PARAM_REROUTAGE		0x81
#define LENPARAM_REROUTAGE	0x01

#define TYPEREROUTAGE_MIN	0x01
#define TYPEREROUTAGE_MAX	0x06
#define REROUTAGE_NAS_GTX	0x01
#define REROUTAGE_NAB_GTX	0x02
#define REROUTAGE_ANNUAIRE	0x03
#define REROUTAGE_NTR_NAS	0x04
#define REROUTAGE_INDEFINI	0x05
#define REROUTAGE_NONTRANSPARENT	0x06

#define PARAM_NOCASCADE		0x82
#define LENPARAM_NOCASCADE	0x00

#define PARAM_NUM		0x83
#define LENPARAM_NUM		-1		// Variable

#define PARAM_NAB		0x84
#define LENPARAM_NAB		-1		// Variable

#define PARAM_CONTEXTE_DCB	0x85
#define LENPARAM_CONTEXTE_DCB	-1		// Variable

#define PARAM_CONTEXTE_ASCII	0x95
#define LENPARAM_CONTEXTE_ASCII	-1		// Variable

#define CODAGE_ASCII		0x04
#define CODAGE_HEXA		0x00

#define PARAM_DONNEES_RETOUR	0x86
#define LENPARAM_DONNEES_RETOUR	-1		// Variable

#define PARAM_NAS_RETOUR	0x87
#define LENPARAM_NAS_RETOUR	-1		// Variable

#define PARAM_NO_POSSIBILITE	0x96
#define LENPARAM_NO_POSSIBILITE	0x00

#define PARAM_NO_ID_APPELANT	0x97
#define LENPARAM_NO_ID_APPELANT	0x00

#define PARAM_ID_DEP		0x98
#define LENPARAM_ID_DEP		0x00

#define NAS_LEN			9
#define CTX_LEN			24

typedef	struct
{
	int len;	
	int typereroutage;
	int cascade;
	int typenum;
	int typectx;
	unsigned char ctx[CTX_LEN + 1];
	unsigned char donneesretour[CTX_LEN + 1];
	unsigned char nasretour[NAS_LEN + 1];
	unsigned char numero[NAS_LEN + 1];
	int posinterdit;
	int transmetid;
} reroutage_t;

int encodeNas(unsigned char *pt, unsigned char *num);
int decodeNas(unsigned char *pt, int len, char *out);
void dumpCommande(unsigned char  *com, int len);
int makeTrame(reroutage_t *r, unsigned char *pt);
void dumpReroute(reroutage_t *r);
int setRetour(reroutage_t *r, unsigned char *donnees);
int setNasRetour(reroutage_t *r, unsigned char *numero);
int setNumero(reroutage_t *r, int typeCodage,  unsigned char *numero);
int setContexte(reroutage_t *r, int typeCodage,  unsigned char *donnees);
int setTransmitId(reroutage_t *r, int type);
int setType(reroutage_t *r, int type);
int setNoPossibilite(reroutage_t *r, int type);
void setCascade(reroutage_t *r, int type);
void initReroute(reroutage_t *r);

#endif // REROUTE_H
