// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "driver.h"

#ifdef	CCXX_NAMESPACES
using namespace std;
namespace ost {
#endif

VPBTone::VPBTone(VPBTrunk *trunk, int h) :
Service((Trunk *)trunk, keythreads.priAudio()), TimerPort()
{
	handle = h;
	reset = false;
	trk = trunk; // DR
}

VPBTone::~VPBTone()
{
	char buffer[12];

	// DR - make sure Run() thread has finished before we delete object
	if(reset)
	{
		vpb_play_terminate(handle);		
		yield();
	}

	terminate();
}

void VPBTone::run(void)
{
	char name[33];
	int len = 0;
	phTone *tone = trk->getTone();
// data.tone.tone;
	timeout_t sync, max = keythreads.getStepInterval();
	unsigned size = tone->getDuration() * 8;
	char *ptr = (char *)tone->getSamples();

	trunk->getName(name);
	vpb_play_buf_start(handle, VPB_MULAW);

	setCancel(cancelDeferred);
	while(trk->data.tone.loops--)
	{	
		setTimer(trk->data.tone.wakeup);
		if(vpb_play_buf_sync(handle, ptr, size) != VPB_OK)
			break;
		
                while((sync = getTimer()) && !trk->stopped)
                {
                        if(sync > max)
                                sync = max;
                        Thread::sleep(sync);
                }
                Thread::yield();
	}
	vpb_play_buf_finish(handle);
	reset = false;
	success();
}

bool VPBTrunk::toneHandler(TrunkEvent *event)
{
	switch(event->id)
	{
	case TRUNK_STOP_STATE:
		if(thread)
		{
			stopped = true;
			vpb_play_terminate(handle);	
			return true;
		}
		endTimer();
		stopServices();
		handler = &VPBTrunk::stepHandler;
		return true;
	case TRUNK_EXIT_STATE:
		if(!thread)
			return true;
		endTimer();
		stopServices();
		handler = &VPBTrunk::stepHandler;
		return true;
	case TRUNK_SERVICE_SUCCESS:
	case TRUNK_SERVICE_FAILURE:
		if(!stopped)
			trunkSignal(TRUNK_SIGNAL_STEP);
		exitThread();
		return true;
	case TRUNK_ENTER_STATE:
		stopped = false;
		enterState("tone");
		flags.dsp = DSP_MODE_VOICE;
		status[id] = 't';
		setDTMFDetect();
		thread = new VPBTone(this, handle);
		thread->start();
		return true;
	}
	return false;
}

#ifdef	CCXX_NAMESPACES
};
#endif
