#! /bin/sh
# -*- ksh -*-

# This program checks that a2ps handles correctly the page ranges

: ${SRCDIR=.}

# The options to run with
# There are 7 pages to print formfeed.txt.  Use it twice to test
# Page selection of several files.
# Do not use compact mode to check that the pages are anyway correctly
# generated
# Get the first 2, the last 2, and 1 in the middle (one of each file)
# And one which is far too big
OPT="-C2mq --compact=no -a-2,4,7-8,13-,99"

# The testing file
IN_NAME=formfeed.txt

# Outputs
OUT_NAME=pages.ps

# Set up other vars
. $SRCDIR/defs || exit 1

# Run the test
$CHK $OPT $TST_FILE $TST_FILE -P awkout > $CHK_FILE
if test -f $REF_FILE; then :; else
  eval $REF $OPT $TST_FILE $TST_FILE -P awkout > $REF_FILE
fi

# Return the verdict
cmp $REF_FILE $CHK_FILE 2> /dev/null || exit 1

# Now check that some invalid values are rejected
$CHK $FILE -o- --pages=1-2d > /dev/null 2>&1 && exit 1
$CHK $FILE -o- --pages=tocd > /dev/null 2>&1 && exit 1
$CHK $FILE -o- --pages=1,d > /dev/null 2>&1 && exit 1

# Check the behavior when -a is reset
$CHK $FILE -o- --pages=1-2 --pages < /dev/null > /dev/null 2>&1 || exit 1
exit 0
