;;; ja-dic.el --- dictionary for Japanese input method  -*- lexical-binding:t -*-
;;	Generated by the command `skkdic-convert'
;;	Original SKK dictionary file: ../../../leim/SKK-DIC/SKK-JISYO.L

;; This file is part of GNU Emacs.

;;; Start of the header of the original SKK dictionary.

;; -*- mode: fundamental; coding: euc-jp -*-
;; Large size dictionary for SKK system
;; Copyright (C) 1988-1995, 1997, 1999-2014
;;
;; Masahiko Sato <masahiko@kuis.kyoto-u.ac.jp>
;; Hironobu Takahashi <takahasi@tiny.or.jp>,
;; Masahiro Doteguchi, Miki Inooka,
;; Yukiyoshi Kameyama <kameyama@kuis.kyoto-u.ac.jp>,
;; Akihiko Sasaki, Dai Ando, Junichi Okukawa,
;; Katsushi Sato and Nobuhiro Yamagishi
;; NAKAJIMA Mikio <minakaji@osaka.email.ne.jp>
;; MITA Yuusuke <clefs@mail.goo.ne.jp>
;; SKK Development Team <skk@ring.gr.jp>
;;
;; Maintainer: SKK Development Team <skk@ring.gr.jp>
;; Keywords: japanese
;;
;; This dictionary is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License as
;; published by the Free Software Foundation; either version 2, or
;; (at your option) any later version.
;;
;; This dictionary is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with Daredevil SKK, see the file COPYING.  If not, write to
;; the Free Software Foundation Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.
;;
;; ACKNOWLEDGEMENT
;;
;; この辞書は、SKK 原作者の佐藤雅彦先生が、第 1 版作成のために東北大学
;; 電気通信研究所佐藤研究室 (当時) の学生さん達とともに scratch から作
;; 成されたのをその起源とし、その後、無数のユーザからのユーザ辞書の提
;; 供やフォームによる追加・校閲によって今尚日々メンテナンスされている日
;; 本で最大規模の、GPL による copy free の辞書です。
;;
;; この辞書の作成にご尽力頂いた全ての方に感謝すると共に、これをお読み
;; のあなたのご協力を是非ともお待ちしております。
;;
;;   http://openlab.ring.gr.jp/skk/registdic.cgi
;;
;; にアクセスし、フォームに是非あなたの新語・誤登録指摘・コメントを書
;; いて下さい。
;;
;; また、実際に辞書の編集をしてみたいという方は、
;;
;;   http://openlab.ring.gr.jp/skk/cvs-ja.html#account
;;
;; をご覧の上、cvs account の発行申し込みをして下さい。
;;
;; 辞書の編集方針は skk/dic/READMEs/committers.txt をご参照下さい。
;; そこに記載のない事項、またその変更については、その都度 SKK Openlab
;; ML で話し合いで決められます。
;;
;; okuri-ari entries.

;;; Code:

(eval-when-compile (require 'ja-dic-cnv))

;; Setting okuri-ari entries.
(skkdic-set-okuri-ari
"をs 惜"
"ゐr 居"
"われらg 我等"
"われしr 我知"
"われw 我"
"われt 我"
"われr 我"
"われn 我"
"われm 我"
"われh 我"
"われg 我"
"わるよi 悪酔"
"わるびr 悪怯"
"わるだくm 悪巧"
"わるすg 悪過"
"わるがしこs 悪賢"
"わるがしこk 悪賢"
"わるがしこi 悪賢"
"わるがしこg 悪賢"
"わるs 悪 惡"
"わるk 悪 惡"
"わるi 悪 惡"
"わるg 悪 惡"
"わるb 悪"
"わりもどs 割り戻 割戻"
"わりふt 割り振 割振"
"わりふr 割り振 割振"
"わりふn 割り振 割振"
"わりふc 割り振 割振"
"わりびk 割引 割り引"
"わりびi 割り引 割引"
"わりつk 割り付 割付"
"わりだs 割り出 割出"
"わりこn 割り込 割込"
"わりこm 割り込 割込"
"わりきt 割り切 割切"
"わりきr 割り切 割切"
"わりきn 割り切 割切"
"わりきc 割り切 割切"
"わりいr 割り入"
"わりあt 割り当 割当"
"わりあi 割り合 割合"
"わりt 割"
"わりs 割"
"わりn 割"
"わりk 割"
"わらぶk 藁葺"
"わらいなk 笑い泣"
"わらいとb 笑い飛"
"わらいつづk 笑い続"
"わらいだs 笑い出"
"わらいじn 笑い死"
"わらいころg 笑い転"
"わらいこk 笑い転"
"わらいくずr 笑い崩"
"わらいかえs 笑い返"
"わらw 笑 嗤"
"わらu 笑 嗤"
"わらt 笑 嗤"
"わらo 笑 嗤"
"わらk 笑 嗤"
"わらi 笑 嗤"
"わらh 笑 嗤"
"わらe 笑 嗤"
"わらc 笑 嗤"
"わめきちr 喚き散"
"わめきたt 喚き立"
"わめk 喚 叫"
"わめi 喚 叫"
"わびずまi 侘住"
"わびしs 侘"
"わびしk 侘"
"わびしi 侘"
"わびしg 侘"
"わびs 侘"
"わびr 侘"
"わのr 輪乗"
"わななk 戦慄"
"わななi 戦慄"
"わなg 輪投"
"わとj 和綴"
"わづらh 煩"
"わだかまt 蟠"
"わだかまr 蟠"
"わだかまn 蟠"
"わだかまc 蟠"
"わたりあるk 渡り歩"
"わたりあるi 渡り歩"
"わたりあw 渡り合"
"わたりあu 渡り合"
"わたりあt 渡り合"
"わたりあo 渡り合"
"わたりあi 渡り合"
"わたりあe 渡り合"
"わたりあc 渡り合"
"わたしこn 渡し込"
"わたしこm 渡し込"
"わたしw 私"
"わたしt 私"
"わたしn 私"
"わたしm 私"
"わたしh 私"
"わたしg 私"
"わたくしw 私"
"わたくしt 私"
"わたくしn 私"
"わたくしm 私"
"わたくしh 私"
"わたくしg 私"
"わたt 渡 亘 亙 渉 航"
"わたs 渡"
"わたr 渡 亘 亙 渉 航"
"わたn 渡 亘 亙 渉 航"
"わたc 渡 亘 亙 渉 航"
"わせだどおr 早稲田通"
"わずらw 煩 患"
"わずらu 患 煩"
"わずらt 患 煩"
"わずらo 患 煩"
"わずらi 患 煩"
"わずらe 患 煩"
"わずらc 患 煩"
"わずk 僅 微 纔 毫"
"わすれはt 忘れ果"
"わすれさt 忘れ去"
"わすれさr 忘れ去"
"わすれさn 忘れ去"
"わすれさc 忘れ去"
"わすれがたs 忘れ難"
"わすれがたk 忘れ難"
"わすれがたi 忘れ難"
"わすれがたg 忘れ難"
"わすr 忘"
"わしづかm 鷲掴"
"わしw 儂"
"わしt 儂"
"わしn 儂"
"わしm 儂"
"わしh 儂"
"わしg 儂"
"わざわi 災 禍 厄"
"わざt 態"
"わけなs 訳無"
"わけなk 訳無"
"わけなi 訳無"
"わけしr 訳知"
"わけいt 分け入"
"わけいr 分け入"
"わけいn 分け入"
"わけいc 分け入"
"わけあたe 分け与"
"わけあw 分け合"
"わけあu 分け合"
"わけあt 分け合"
"わけあo 分け合"
"わけあi 分け合"
"わけあe 分け合"
"わけあc 分け合"
"わけt 分"
"わけr 分"
"わけn 分"
"わけc 分"
"わくぐm 枠組"
"わぎr 輪切"
"わきまe 弁"
"わきでz 湧き出 涌き出"
"わきでy 湧き出 涌き出"
"わきでt 湧き出 涌き出"
"わきでs 湧き出 涌き出"
"わきでr 湧き出 涌き出"
"わきでn 湧き出 涌き出"
"わきでm 湧き出 涌き出"
"わきでc 湧き出 涌き出"
"わきづk 脇付"
"わきだs 湧き出"
"わきたt 沸き立 湧き立 涌き立"
"わきたc 沸き立 湧き立 涌き立"
"わきがたm 脇固"
"わきかえt 沸き返"
"わきかえr 沸き返"
"わきかえn 沸き返"
"わきかえc 沸き返"
"わきおこt 沸き起"
"わきおこr 沸き起"
"わきおこn 沸き起"
"わきおこc 沸き起"
"わきおk 沸き起 湧き起"
"わきあg 湧き上 沸き上"
"わかわかs 若々"
"わかりやすs 分かり易 判り易 理解り易"
"わかりやすk 分かり易 判り易 理解り易"
"わかりやすi 分かり易 判り易 理解り易"
"わかりやすg 分かり易 判り易 理解り易"
"わかりにくs 分かり難"
"わかりにくk 分かり難"
"わかりにくi 分かり難"
"わかりにくg 分かり難"
"わかりきt 分かり切"
"わかりきr 分かり切"
"わかりきn 分かり切"
"わかりきc 分かり切"
"わかづくr 若作"
"わかちあw 分かち合"
"わかちあu 分かち合"
"わかちあt 分かち合"
"わかちあo 分かち合"
"わかちあi 分かち合"
"わかちあe 分かち合"
"わかちあc 分かち合"
"わかがえt 若返"
"わかがえr 若返"
"わかがえn 若返"
"わかがえc 若返"
"わかy 若"
"わかt 判 分 解 別 頒 觧 理解"
"わかs 若 稚"
"わかr 別 判 解 分 理解 訣 觧"
"わかn 解 判 分 理解 觧"
"わかk 若 稚"
"わかi 若 稚"
"わかg 若 稚"
"わかc 解 判 分 理解 觧"
"わt 割"
"わs 和"
"わr 割 破"
"わn 割"
"わk 分 湧 沸 涌 訳"
"わi 湧 沸 涌"
"わg 我"
"わc 割"
"わb 詫 侘"
"ろんz 論"
"ろんj 論"
"ろくがどr 録画撮"
"ろくs 録"
"ろくn 碌"
"ろうをおs 労を惜"
"ろうs 労 弄 聾"
"れんらくいただk 連絡頂"
"れんらくいただi 連絡頂"
"れんらくいたs 連絡致"
"れんきゅうあk 連休明"
"れっs 列"
"れいれいs 麗々"
"れいぎただs 礼儀正"
"れいn 例"
"るいs 類"
"りんt 凛"
"りりs 凛々 凛凛 律々"
"りようくだs 利用下"
"りようs 利用"
"りょこううかがi 旅行伺"
"りょうほうとt 両方取"
"りょうほうとr 両方取"
"りょうほうとn 両方取"
"りょうほうとc 両方取"
"りょうびらk 両開"
"りょうひらk 両開"
"りょうしょうくだs 了承下"
"りょうかいs 了解"
"りょうs 領 諒"
"りゅうこうおくr 流行遅"
"りゃくs 略"
"りまわr 利回"
"りばらi 利払"
"りづm 理詰"
"りつk 利付"
"りっs 律"
"りだすk 利助"
"りさg 利下"
"りぐi 利食"
"りくつぬk 理屈抜"
"りくつどおr 理屈通"
"りくつづk 陸続"
"りくつp 理屈"
"りくあg 陸揚"
"りくs 戮"
"りきn 力"
"りきm 力"
"りかいs 理解"
"りおt 利落"
"りあg 利上"
"りs 利"
"らんぎr 乱切"
"らんs 濫"
"らっs 拉"
"らくがk 落書"
"らくs 楽"
"らくn 楽"
"らくd 楽"
"らうs 労"
"よんd 読ん"
"よわりはt 弱り果"
"よわりきt 弱り切"
"よわりきr 弱り切"
"よわりきn 弱り切"
"よわりきc 弱り切"
"よわよわs 弱々"
"よわふくm 弱含"
"よわたr 世渡"
"よわすg 弱過"
"よわt 弱"
"よわs 弱"
"よわr 弱"
"よわn 弱"
"よわm 弱"
"よわk 弱"
"よわi 弱"
"よわg 弱"
"よわc 弱"
"よろしk 宜"
"よろこんd 喜ん"
"よろこびいさn 喜び勇"
"よろこびいさm 喜び勇"
"よろこn 喜 悦 歓 慶"
"よろこb 喜 悦 歓 慶"
"よろs 宜"
"よろm 蹌踉"
"よるおそs 夜遅"
"よるおそk 夜遅"
"よるおそi 夜遅"
"よるおそg 夜遅"
"よりわk 選り分"
"よりぬk 選り抜"
"よりぬi 選り抜"
"よりによt 選りに選"
"よりどr 選り取"
"よりつk 寄付"
"よりつi 寄付"
"よりだs 選り出"
"よりそw 寄り添"
"よりそu 寄り添"
"よりそt 寄り添"
"よりそo 寄り添"
"よりそi 寄り添"
"よりそe 寄り添"
"よりそc 寄り添"
"よりごのm 選り好"
"よりきt 寄り切"
"よりきr 寄り切"
"よりきn 寄り切"
"よりきc 寄り切"
"よりかk 寄り掛"
"よりあわs 縒り合"
"よりあつm 寄り集"
"よりあw 縒り合 寄り合"
"よりあu 寄り合"
"よりあt 寄り合"
"よりあo 寄り合"
"よりあi 寄り合"
"よりあe 寄り合"
"よりあc 寄り合"
"よめとr 嫁取"
"よめいr 嫁入"
"よみわk 読み分"
"よみやすs 読み易"
"よみやすk 読み易"
"よみやすi 読み易"
"よみやすg 読み易"
"よみまちがw 読み間違"
"よみまちがu 読み間違"
"よみまちがt 読み間違"
"よみまちがo 読み間違"
"よみまちがi 読み間違"
"よみまちがe 読み間違"
"よみまちがc 読み間違"
"よみふけt 読み耽"
"よみふけr 読み耽"
"よみふけn 読み耽"
"よみふけc 読み耽"
"よみはじm 読み始"
"よみにくs 読み難"
"よみにくk 読み難"
"よみにくi 読み難"
"よみにくg 読み難"
"よみながs 読み流"
"よみなおs 読み直"
"よみなr 読み慣"
"よみとおs 読み通"
"よみとt 読み取 読取"
"よみとr 読み取 読取"
"よみとn 読み取 読取"
"よみとk 読み解"
"よみとi 読み解"
"よみとc 読み取 読取"
"よみとb 読み飛"
"よみづらs 読み辛"
"よみづらk 読み辛"
"よみづらi 読み辛"
"よみづらg 読み辛"
"よみつづk 読み続"
"よみちがe 読み違"
"よみちr 読み散"
"よみだs 読み出 読出"
"よみすすn 読み進"
"よみすすm 読み進"
"よみすごs 読み過"
"よみすt 読み捨"
"よみこn 読み込 読込 詠み込"
"よみこm 読み込 読込 詠み込"
"よみくらb 読み比 読み較"
"よみくだs 読み下 訓み下"
"よみきt 読み切 読切"
"よみきr 読み切 読切"
"よみきn 読み切 読切"
"よみきk 読み聞"
"よみきc 読み切 読切"
"よみがえt 甦 蘇 蘓"
"よみがえr 甦 蘇 蘓"
"よみがえn 甦 蘇 蘓"
"よみがえc 甦 蘇 蘓"
"よみがe 蘇 蘓"
"よみかえs 読み返"
"よみかk 読み書"
"よみかe 読み替"
"よみおとs 読み落"
"よみおw 読み終"
"よみおt 読み落"
"よみおe 読み終"
"よみあやまt 読み誤"
"よみあやまr 読み誤"
"よみあやまn 読み誤"
"よみあやまc 読み誤"
"よみあさt 読み漁"
"よみあさr 読み漁"
"よみあさn 読み漁"
"よみあさc 読み漁"
"よみあw 読み合"
"よみあk 読み飽"
"よみあg 読み上"
"よみs 嘉"
"よみd 読み"
"よまわr 夜回"
"よふかs 夜更"
"よふk 夜更"
"よびよs 呼び寄 呼寄"
"よびもどs 呼び戻"
"よびならw 呼び習"
"よびとm 呼び止"
"よびつづk 呼び続"
"よびつk 呼び付 呼付"
"よびだs 呼び出 呼出"
"よびたt 呼び立"
"よびすt 呼び捨"
"よびさm 呼び覚"
"よびこn 呼び込"
"よびこm 呼び込"
"よびかわs 呼び交"
"よびかえs 呼び返"
"よびかw 呼び交"
"よびかk 呼び掛 呼掛"
"よびおk 呼び起"
"よびあつm 呼び集"
"よばi 夜這"
"よにg 夜逃"
"よなよn 夜な夜"
"よなおs 世直"
"よなr 世慣 世馴"
"よなk 夜泣"
"よどおs 夜通"
"よどn 淀 澱"
"よどm 淀 澱"
"よとおr 四通"
"よていどおr 予定通"
"よづr 夜釣"
"よつg 世継"
"よっぱらw 酔っ払"
"よっぱらu 酔っ払"
"よっぱらt 酔っ払"
"よっぱらo 酔っ払"
"よっぱらi 酔っ払"
"よっぱらe 酔っ払"
"よっぱらc 酔っ払"
"よってたt 拠って立"
"よっかk 寄っ掛"
"よっt 四"
"よだt 夜立 弥立"
"よだc 弥立"
"よそよそs 余所余所"
"よそほu 裝"
"よそおw 装 粧 裝"
"よそおu 装 粧 裝"
"よそおt 装 裝 粧"
"よそおo 装 粧 裝"
"よそおi 装 裝 粧"
"よそおh 裝"
"よそおe 装 粧 裝"
"よそおc 装 粧 裝"
"よそうどおr 予想通"
"よそうs 予想"
"よそw 装"
"よそu 装"
"よそt 装"
"よそo 装"
"よそi 装"
"よそh 装"
"よそe 寄 比 装"
"よそc 装"
"よせつk 寄せ付"
"よせこz 寄せ来"
"よせこy 寄せ来"
"よせこs 寄せ来"
"よせこr 寄せ来"
"よせこn 寄せ来"
"よせこi 寄せ来"
"よせくr 寄せ来"
"よせくn 寄せ来"
"よせきy 寄せ来"
"よせきt 寄せ来"
"よせきs 寄せ来"
"よせきn 寄せ来"
"よせきm 寄せ来"
"よせきd 寄せ来"
"よせきc 寄せ来"
"よせがk 寄せ書 寄書"
"よせあつm 寄せ集"
"よせあw 寄せ合"
"よせあu 寄せ合"
"よせあt 寄せ合"
"よせあo 寄せ合"
"よせあi 寄せ合"
"よせあe 寄せ合"
"よせあc 寄せ合"
"よすg 良過"
"よじのぼt 攀じ上"
"よじのぼr 攀じ上"
"よじのぼn 攀じ上"
"よじのぼc 攀じ上"
"よじt 捩"
"よじr 捩"
"よじn 捩"
"よじk 捩"
"よじc 捩"
"よしなs 由無"
"よしなk 由無"
"よしなi 由無"
"よしなg 由無"
"よしあs 善し悪"
"よごs 汚"
"よごr 汚"
"よこわr 横割"
"よこばしt 横走"
"よこばしr 横走"
"よこばしn 横走"
"よこばしc 横走"
"よこばi 横這"
"よこならb 横並"
"よこながs 横流"
"よこどr 横取"
"よことb 横跳"
"よこづk 横付"
"よこっとb 横っ飛 横っ跳"
"よこだおs 横倒"
"よこずk 横好"
"よこすべr 横滑"
"よこしまs 邪"
"よこしまn 邪"
"よこしまd 邪"
"よこくどおr 予告通"
"よこぎt 横切"
"よこぎr 横切"
"よこぎn 横切"
"よこぎc 横切"
"よこがk 横書"
"よこt 横"
"よこs 寄越 遣 横"
"よくぶかs 欲深"
"よくぶかk 欲深"
"よくぶかi 欲深"
"よくぶかg 欲深"
"よくばt 欲張"
"よくばr 欲張"
"よくばn 欲張"
"よくばc 欲張"
"よくs 浴"
"よくb 欲"
"よぎなk 余儀無"
"よぎt 過"
"よぎr 過"
"よぎn 余儀 過"
"よぎc 過"
"よかr 善か"
"ようりょうよk 要領良"
"ようよu 漸"
"ようやk 漸"
"ようむk 用向"
"ようちあさがk 夜討ち朝駆"
"ようだt 用立"
"ようたs 用足"
"ようずm 用済"
"ようじんぶかs 用心深"
"ようじんぶかk 用心深"
"ようじんぶかi 用心深"
"ようじんぶかg 用心深"
"ようしゃねがu 容赦願"
"ようしゃねがi 容赦願"
"ようしゃくだs 容赦下"
"よういs 用意"
"よういn 容易"
"よういd 容易"
"ようt 夜討 杳"
"ようs 要 擁 様"
"ようn 様 陽 樣"
"ようh 要"
"ようd 様"
"よいどm 酔い止"
"よいつぶs 酔い潰"
"よいつぶr 酔い潰"
"よいっぱr 宵っ張"
"よいしr 酔い痴"
"よいざm 酔い覚 酔い醒 酔醒"
"よいごs 宵越"
"よあるk 夜歩"
"よあそb 夜遊"
"よあk 夜明"
"よz 攀"
"よw 酔 醉"
"よu 酔 醉"
"よt 酔 四 寄 因 選 依 拠 ４ 醉 撚 縒 憑"
"よs 寄 良 善 止 好 酔 佳 醉 譱"
"よr 寄 依 拠 因 撚 縒 選 憑"
"よp 酔"
"よo 酔 醉"
"よn 読 呼 詠 訓 世 丗 讀 寄 依 拠 因 撚 縒 選 憑 喚"
"よm 読 詠 訓 讀"
"よk 良 善 除 避 好 能 寄 譱 酔 佳 醉"
"よj 攀"
"よi 良 酔 好 善 佳 醉 譱"
"よg 善 良 酔 好 佳 醉 譱"
"よe 酔 醉"
"よc 酔 醉 寄 依 拠 因 撚 縒 選 憑"
"よb 呼 喚"
"よa 良"
"ゆわかs 湯沸"
"ゆわえつk 結わえ付"
"ゆわk 湯沸"
"ゆれうごk 揺れ動"
"ゆれうごi 揺れ動"
"ゆるしがたs 許し難"
"ゆるしがたk 許し難"
"ゆるしがたi 許し難"
"ゆるしがたg 許し難"
"ゆるしあw 許し合"
"ゆるしあu 許し合"
"ゆるしあt 許し合"
"ゆるしあo 許し合"
"ゆるしあi 許し合"
"ゆるしあe 許し合"
"ゆるしあc 許し合"
"ゆるぎなs 揺るぎ無"
"ゆるぎなk 揺るぎ無"
"ゆるぎなi 揺るぎ無"
"ゆるがs 忽"
"ゆるy 緩"
"ゆるs 許 赦 聴 緩"
"ゆるr 緩"
"ゆるn 緩 弛"
"ゆるm 緩 弛"
"ゆるk 緩"
"ゆるi 緩 揺"
"ゆるg 揺 緩"
"ゆるb 弛 緩"
"ゆりもどs 揺り戻"
"ゆりかえs 揺り返"
"ゆりおこs 揺り起"
"ゆりおt 揺り落"
"ゆりおk 揺り起"
"ゆりうごk 揺り動"
"ゆゆs 由々 由由 忌々"
"ゆめみz 夢見"
"ゆめみy 夢見"
"ゆめみt 夢見"
"ゆめみs 夢見"
"ゆめみr 夢見"
"ゆめみn 夢見"
"ゆめみm 夢見"
"ゆめみk 夢見"
"ゆめみc 夢見"
"ゆめn 夢"
"ゆみひk 弓引"
"ゆみひi 弓引"
"ゆみけずr 弓削"
"ゆびづかi 指使"
"ゆびさs 指差"
"ゆびおr 指折"
"ゆどおs 湯通"
"ゆとうよm 湯桶読"
"ゆですg 茹で過"
"ゆであg 茹で上"
"ゆづt 讓"
"ゆづr 讓"
"ゆだt 茹"
"ゆだr 茹"
"ゆだn 委 茹"
"ゆだc 茹"
"ゆたk 豊 豐"
"ゆずりわたs 譲り渡"
"ゆずりうk 譲り受"
"ゆずりあw 譲り合"
"ゆずりあu 譲り合"
"ゆずりあt 譲り合"
"ゆずりあo 譲り合"
"ゆずりあi 譲り合"
"ゆずりあe 譲り合"
"ゆずりあc 譲り合"
"ゆずt 譲 讓"
"ゆずr 譲 讓"
"ゆずn 譲 讓"
"ゆずc 譲 讓"
"ゆすりとt 強請り取"
"ゆすりとr 強請り取"
"ゆすりとn 強請り取"
"ゆすりとc 強請り取"
"ゆすぶt 揺振"
"ゆすぶr 揺振"
"ゆすぶn 揺振"
"ゆすぶc 揺振"
"ゆすt 強請 揺"
"ゆすr 強請 揺"
"ゆすn 強請 揺"
"ゆすi 濯"
"ゆすg 濯"
"ゆすc 強請 揺"
"ゆざm 湯冷"
"ゆさぶt 揺さ振 揺振"
"ゆさぶr 揺さ振 揺振"
"ゆさぶn 揺さ振 揺振"
"ゆさぶc 揺さ振 揺振"
"ゆきわたt 行き渡"
"ゆきわたr 行き渡"
"ゆきわたn 行き渡"
"ゆきわたc 行き渡"
"ゆきまつr 雪祭"
"ゆきなやn 行き悩"
"ゆきなやm 行き悩"
"ゆきどm 行き止"
"ゆきどk 雪解"
"ゆきとどk 行き届"
"ゆきとどi 行き届"
"ゆきづm 行き詰"
"ゆきつk 行き着 行き付"
"ゆきつi 行き着"
"ゆきちがw 行き違"
"ゆきちがu 行き違"
"ゆきちがt 行き違"
"ゆきちがo 行き違"
"ゆきちがi 行き違"
"ゆきちがe 行き違"
"ゆきちがc 行き違"
"ゆきだおr 行き倒"
"ゆきすg 行き過 行過"
"ゆききd 行き来"
"ゆきがk 行き掛"
"ゆきかよw 行き通"
"ゆきかよu 行き通"
"ゆきかよt 行き通"
"ゆきかよo 行き通"
"ゆきかよi 行き通"
"ゆきかよe 行き通"
"ゆきかよc 行き通"
"ゆきかえr 行き帰"
"ゆきかw 行き交"
"ゆきかu 行き交"
"ゆきかt 行き交"
"ゆきかo 行き交"
"ゆきかi 行き交"
"ゆきかe 行き交"
"ゆきかc 行き交"
"ゆきおr 雪下"
"ゆきあたt 行き当"
"ゆきあたr 行き当"
"ゆきあたn 行き当"
"ゆきあたc 行き当"
"ゆきあw 行き合"
"ゆきあu 行き合"
"ゆきあt 行き当 行き合 行当"
"ゆきあo 行き合"
"ゆきあk 雪明"
"ゆきあi 行き合"
"ゆきあe 行き合"
"ゆきあc 行き合"
"ゆがn 歪"
"ゆがm 歪"
"ゆがk 湯掻"
"ゆがi 湯掻"
"ゆかs 床"
"ゆえなs 故無"
"ゆえなk 故無"
"ゆえなi 故無"
"ゆえなg 故無"
"ゆえn 故"
"ゆうりn 有利"
"ゆうやk 夕焼"
"ゆうめいすg 有名過"
"ゆうまぐr 夕間暮"
"ゆうびんうk 郵便受"
"ゆうばr 夕晴"
"ゆうばe 夕映"
"ゆうすずm 夕涼"
"ゆうしょうあらそi 優勝争"
"ゆうしゅうn 優秀"
"ゆうぐr 夕暮"
"ゆうきづk 勇気付"
"ゆうs 有"
"ゆうn 優"
"ゆうb 夕"
"ゆいつk 結い付"
"ゆいしょただs 由緒正"
"ゆいあg 結い上"
"ゆあg 湯上"
"ゆw 結"
"ゆu 結"
"ゆt 結 揺 汰 淘 搖"
"ゆs 揺 搖"
"ゆr 揺 汰 淘 搖"
"ゆo 結"
"ゆn 揺 汰 淘 搖"
"ゆk 行 逝 往 征 徃"
"ゆi 結"
"ゆh 結"
"ゆg 湯"
"ゆe 結"
"ゆd 茹"
"ゆc 結 揺 汰 淘 搖"
"やんごとなs 止事無"
"やんごとなk 止事無"
"やんごとなi 止事無"
"やわらかk 柔"
"やわs 柔"
"やわr 柔 軟 和"
"やわn 柔"
"やわk 柔"
"やわi 柔"
"やわg 柔"
"やわd 柔"
"やりのこs 遣り残 やり残"
"やりぬk 遣り抜 やり抜"
"やりぬi 遣り抜 やり抜"
"やりなおs 遣り直 やり直"
"やりとr 遣り取"
"やりとg 遣り遂 やり遂"
"やりつくs 遣り尽"
"やりつk 遣り付"
"やりっぱなs 遣りっ放"
"やりだs 遣り出 やり出"
"やりそんz 遣り損 やり損"
"やりそんj 遣り損 やり損"
"やりそこなw 遣り損 やり損"
"やりそこなu 遣り損 やり損"
"やりそこなt 遣り損 やり損"
"やりそこなo 遣り損 やり損"
"やりそこなi 遣り損 やり損"
"やりそこなe 遣り損 やり損"
"やりそこなc 遣り損 やり損"
"やりそこn 遣り損 やり損"
"やりすごs 遣り過 やり過"
"やりすg 遣り過 やり過"
"やりこなs 遣り熟"
"やりこn 遣り込 やり込"
"やりこm 遣り込 やり込"
"やりきr 遣り切 やり切"
"やりかえs 遣り返 やり返"
"やりおe 遣り終 やり終"
"やりあw やり合 遣り合"
"やりあu 遣り合 やり合"
"やりあt やり合 遣り合"
"やりあo やり合 遣り合"
"やりあi やり合 遣り合"
"やりあe やり合"
"やりあc 遣り合 やり合"
"やめr 止め"
"やむをえz 止むを得"
"やむをえn 止むを得"
"やむをえm 止むを得"
"やむごとなs 止事無"
"やむごとなk 止事無"
"やむごとなi 止事無"
"やみとりひk 闇取り引"
"やみつk 病み付"
"やみつi 病み付"
"やみがたs 止み難"
"やみがたk 止み難"
"やみがたi 止み難"
"やみがたg 止み難"
"やみあがr 病み上"
"やみあg 病み上"
"やまわk 山分"
"やまもr 山盛"
"やまむk 山向"
"やままw 山回"
"やまぶかs 山深"
"やまぶかk 山深"
"やまぶかi 山深"
"やまぶかg 山深"
"やまびらk 山開"
"やまのぼr 山登"
"やまづm 山積"
"やまぞi 山沿"
"やまそだt 山育"
"やまごe 山越"
"やまくずs 山崩"
"やまくずr 山崩"
"やまあるk 山歩"
"やまs 疚 疾"
"やぶれr 殕"
"やぶりすt 破り捨"
"やぶにらm 藪睨"
"やぶさk 吝"
"やぶt 破 敗"
"やぶr 破 敗"
"やぶn 破 敗"
"やぶk 破"
"やぶi 破"
"やぶc 破 敗"
"やはr 柔 軟 和 矢張"
"やはi 柔"
"やにさg 脂下"
"やどなs 宿無"
"やどさがs 宿探"
"やどかr 宿借"
"やどt 宿"
"やどs 宿"
"やどr 宿"
"やどn 宿"
"やどc 宿"
"やといいr 雇い入"
"やとw 雇 傭"
"やとu 雇 傭"
"やとt 雇 傭"
"やとo 雇 傭"
"やとi 雇 傭"
"やとh 雇 傭"
"やとe 雇 傭"
"やとc 雇 傭"
"やつざk 八つ裂"
"やつあたr 八つ当"
"やつs 窶"
"やつr 窶"
"やってのk 遣って退"
"やっつk 遣っ付"
"やっt 八 漸"
"やせほそt 痩せ細"
"やせほそr 痩せ細"
"やせほそn 痩せ細"
"やせほそc 痩せ細"
"やせおとろe 痩せ衰"
"やすものがi 安物買"
"やすみあk 休み明"
"やすすg 安過"
"やすくにどおr 靖国通"
"やすうけあi 安請け合 安請合"
"やすうr 安売"
"やすあがt 安上"
"やすあがr 安上"
"やすあがn 安上"
"やすあがc 安上"
"やすあg 安上"
"やすu 安 易 廉"
"やすs 安 易 廉"
"やすr 安"
"やすp 安"
"やすn 休 安"
"やすm 休 安 易 廉"
"やすk 安 易 廉"
"やすi 安 易 廉"
"やすg 安 易 廉"
"やじt 野次"
"やじr 野次"
"やじn 野次"
"やじc 野次"
"やしなw 養 豢"
"やしなu 養 豢"
"やしなt 養 豢"
"やしなo 養 豢"
"やしなi 養 豢"
"やしなh 養"
"やしなe 養 豢"
"やしなc 養 豢"
"やさしi 優し 易し"
"やさs 優 易"
"やけのこt 焼け残"
"やけのこr 焼け残"
"やけのこn 焼け残"
"やけのこc 焼け残"
"やけただr 焼け爛"
"やけしn 焼け死"
"やけこg 焼け焦"
"やけおt 焼け落"
"やけおc 焼け落"
"やぐらなg 櫓投"
"やくわr 役割"
"やくよk 厄除"
"やくまわr 役回"
"やくひんくさs 薬品臭"
"やくひんくさk 薬品臭"
"やくひんくさi 薬品臭"
"やくひんくさg 薬品臭"
"やくばらi 厄払"
"やくはらi 厄祓"
"やくはらh 厄祓"
"やくにたt 役に立"
"やくにたc 役に立"
"やくづk 役付"
"やくだt 役立"
"やくだc 役立"
"やくたt 役立"
"やくそくどおr 約束通"
"やくs 訳 約 扼 譯"
"やくn 役"
"やきもどs 焼戻 焼き戻"
"やきはらw 焼き払"
"やきはらu 焼き払"
"やきはらt 焼き払"
"やきはらo 焼き払"
"やきはらi 焼き払"
"やきはらe 焼き払"
"やきはらc 焼き払"
"やきなまs 焼き鈍 焼鈍"
"やきなおs 焼き直 焼直"
"やきつくs 焼き尽"
"やきつk 焼き付 焼き尽 焼付"
"やきつi 焼き付 焼付"
"やきすt 焼き捨"
"やきすg 焼き過"
"やきしm 焼き締 焼締"
"やきころs 焼き殺"
"やきこn 焼き込"
"やきこm 焼き込"
"やききt 焼き切"
"やききr 焼き切"
"やききn 焼き切"
"やききc 焼き切"
"やきいr 焼き入 焼入"
"やきあg 焼き上"
"やがt 軈"
"やかまs 喧"
"やうやu 漸"
"やうやk 漸"
"やt 遣 演 殺 八"
"やs 痩 瘠"
"やr 遣 演 殺 破"
"やn 止 病 遣 演 殺 已 熄"
"やm 止 辞 病 已 熄 罷 辭"
"やk 焼 妬 灼 燒"
"やi 焼 妬 燒 灼"
"やc 遣 演 殺"
"もんなs 文無"
"もんどりうt 翻筋斗打"
"もんどりうc 翻筋斗打"
"もんぜんばらi 門前払"
"もんくなs 文句無"
"もろもろn 諸"
"もろs 脆"
"もろk 脆"
"もろi 脆"
"もろg 脆"
"もれだs 漏れ出"
"もれきk 洩れ聞 漏れ聞"
"もれきi 洩れ聞 漏れ聞"
"もりつk 盛り付"
"もりたt 守り立"
"もりさg 盛り下"
"もりこn 盛り込"
"もりこm 盛り込"
"もりかえs 盛り返"
"もりあわs 盛合"
"もりあがt 盛り上"
"もりあがr 盛り上"
"もりあがn 盛り上"
"もりあがc 盛り上"
"もりあw 盛り合"
"もりあg 盛り上 盛上"
"もりs 守"
"もらいっぱなs 貰いっ放"
"もらいそこn 貰い損"
"もらいうk 貰い受"
"もらw 貰"
"もらu 貰"
"もらt 貰"
"もらo 貰"
"もらi 貰"
"もらe 貰"
"もらc 貰"
"もよおs 催"
"もようがe 模様替"
"もよr 最寄"
"もよi 催"
"もやw 舫"
"もやu 舫"
"もやt 舫"
"もやo 舫"
"もやi 舫"
"もやe 舫"
"もやc 舫"
"もみほぐs 揉み解"
"もみつぶs 揉み潰"
"もみだs 揉み出"
"もみこn 揉み込"
"もみこm 揉み込"
"もみけs 揉み消 もみ消"
"もみあw 揉み合"
"もみあu 揉み合"
"もみあt 揉み合"
"もみあo 揉み合"
"もみあi 揉み合"
"もみあc 揉み合"
"ものわびs 物侘"
"ものわすr 物忘"
"ものやわr 物柔"
"ものものs 物々 物物"
"ものもうs 物申"
"ものもt 物持"
"ものもc 物持"
"ものめずらs 物珍"
"ものみだかs 物見高"
"ものみだかk 物見高"
"ものみだかi 物見高"
"ものみだかg 物見高"
"ものほs 物干 物欲"
"ものなr 物慣"
"ものたr 物足"
"ものずk 物好"
"ものすごs 物凄"
"ものすごk 物凄"
"ものすごi 物凄"
"ものすごg 物凄"
"ものしずk 物静"
"ものしr 物知"
"ものさびs 物寂 物淋"
"ものごi 物乞"
"ものぐるo 物狂"
"ものぐさs 懶"
"ものぐさk 懶"
"ものぐさi 懶"
"ものぐさg 懶"
"ものがなs 物悲"
"ものがたt 物語"
"ものがたr 物語"
"ものがたn 物語"
"ものがたc 物語"
"ものかk 物書"
"ものかi 物書"
"ものおもi 物思"
"ものおぼe 物覚"
"ものおz 物怖"
"ものおj 物怖"
"ものうs 物憂 懶"
"ものうk 物憂 懶"
"ものうi 物憂 懶"
"ものうg 物憂 懶"
"ものいw 物言"
"ものいu 物言"
"ものいr 物入"
"ものいi 物言"
"ものいe 物言"
"ものs 物"
"もぬk 蛻"
"もどってこz 戻って来"
"もどってこy 戻って来"
"もどってこs 戻って来"
"もどってこr 戻って来"
"もどってこn 戻って来"
"もどってこi 戻って来"
"もどってくr 戻って来"
"もどってくn 戻って来"
"もどってきy 戻って来"
"もどってきt 戻って来"
"もどってきs 戻って来"
"もどってきn 戻って来"
"もどってきm 戻って来"
"もどってきd 戻って来"
"もどってきc 戻って来"
"もどt 戻"
"もどs 戻"
"もどr 戻"
"もどn 戻"
"もどk 擬"
"もどc 戻"
"もとめあw 求め合"
"もとめあu 求め合"
"もとめあt 求め合"
"もとめあo 求め合"
"もとめあi 求め合"
"もとめあe 求め合"
"もとめあc 求め合"
"もとどおr 元通"
"もとづk 基"
"もとづi 基"
"もとうr 元売"
"もとz 基"
"もとt 悖 戻 基"
"もとr 悖 戻"
"もとn 元 基 悖 戻 求 許 下"
"もとm 求"
"もとk 元"
"もとh 許"
"もとd 基 下 元 許"
"もとc 悖 戻"
"もてはやs 持て囃 持て栄"
"もてなs 持て成"
"もてあまs 持て余"
"もてあそn 弄 玩 翫"
"もてあそb 弄 玩 翫"
"もつれこn 縺れ込"
"もつれこm 縺れ込"
"もつれあw 縺れ合"
"もつれあu 縺れ合"
"もつれあt 縺れ合"
"もつれあo 縺れ合"
"もつれあi 縺れ合"
"もつれあe 縺れ合"
"もつれあc 縺れ合"
"もつr 縺"
"もっぱr 専 專"
"もっとm 最 尤"
"もってまわt 持って回"
"もってまわr 持って回"
"もってまわn 持って回"
"もってまわc 持って回"
"もってこz 持って来"
"もってこy 持って来"
"もってこs 持って来"
"もってこr 持って来"
"もってこn 持って来"
"もってこi 持って来"
"もってくr 持って来"
"もってくn 持って来"
"もってきy 持って来"
"もってきt 持って来"
"もってきs 持って来"
"もってきn 持って来"
"もってきm 持って来"
"もってきd 持って来"
"もってきc 持って来"
"もってかえt 持って帰"
"もってかえr 持って帰"
"もってかえn 持って帰"
"もってかえc 持って帰"
"もっていt 持って行"
"もっていk 持って行"
"もっていc 持って行"
"もったいぶt 勿体振"
"もったいぶr 勿体振"
"もったいぶn 勿体振"
"もったいぶc 勿体振"
"もったいなs 勿体無"
"もったいなk 勿体無"
"もったいなi 勿体無"
"もったいなg 勿体無"
"もっt 以"
"もぢr 捩"
"もちよt 持ち寄"
"もちよr 持ち寄"
"もちよn 持ち寄"
"もちよc 持ち寄"
"もちまわt 持ち回 持回"
"もちまわr 持ち回 持回"
"もちまわn 持ち回 持回"
"もちまわc 持ち回 持回"
"もちはこn 持ち運"
"もちはこb 持ち運"
"もちにg 持逃 持ち逃"
"もちなおs 持ち直"
"もちつづk 持ち続"
"もちだs 持ち出 持出"
"もちさt 持ち去"
"もちさr 持ち去"
"もちさn 持ち去"
"もちさc 持ち去"
"もちこたe 持ち堪"
"もちこs 持ち越 持越"
"もちこn 持ち込 持込"
"もちこm 持ち込 持込"
"もちぐさr 持ち腐"
"もちくずs 持ち崩"
"もちきr 持ち切"
"もちかえt 持ち帰"
"もちかえr 持ち帰"
"もちかえn 持ち帰"
"もちかえc 持ち帰"
"もちかk 持ち掛"
"もちかe 持ち替"
"もちいt 用い"
"もちあわs 持ち合 持合"
"もちあるk 持ち歩"
"もちあるi 持ち歩"
"もちあw 持ち合"
"もちあu 持ち合"
"もちあt 持ち合"
"もちあo 持ち合"
"もちあi 持ち合 持合"
"もちあg 持ち上"
"もちあc 持ち合"
"もちw 用"
"もちi 用"
"もだs 黙"
"もだe 悶"
"もたれあw 凭れ合"
"もたれあu 凭れ合"
"もたれあt 凭れ合"
"もたれあo 凭れ合"
"もたれあi 凭れ合"
"もたれあe 凭れ合"
"もたれあc 凭れ合"
"もたらs 齎"
"もたr 凭 靠"
"もたg 擡"
"もじまちがi 文字間違"
"もじばk 文字化"
"もじどおr 文字通"
"もじおt 文字落"
"もじt 捩"
"もじr 捩"
"もじn 捩"
"もじc 捩"
"もしm 若し"
"もしk 若し"
"もぐりこn 潜り込"
"もぐりこm 潜り込"
"もぐt 潜 潛 濳"
"もぐr 潜 潛 濳"
"もぐn 潜 潛 濳"
"もぐc 潜 潛 濳"
"もくろn 目論"
"もくろm 目論"
"もくs 黙 目"
"もぎとt もぎ取"
"もぎとr もぎ取"
"もぎとn もぎ取"
"もぎとc もぎ取"
"もがr 虎落 強請"
"もがk 藻掻"
"もがi 藻掻"
"もえひろg 燃え広"
"もえでz 萌え出"
"もえでy 萌え出"
"もえでt 萌え出"
"もえでs 萌え出"
"もえでr 萌え出"
"もえでn 萌え出"
"もえでm 萌え出"
"もえでc 萌え出"
"もえつk 燃え尽"
"もえだs 燃え出 萌え出"
"もえたぎt 燃え滾"
"もえたぎr 燃え滾"
"もえたぎn 燃え滾"
"もえたぎc 燃え滾"
"もえたt 燃え立 萌え立"
"もえたc 燃え立 萌え立"
"もえさかt 燃え盛"
"もえさかr 燃え盛"
"もえさかn 燃え盛"
"もえさかc 燃え盛"
"もえうつt 燃え移"
"もえうつr 燃え移"
"もえうつn 燃え移"
"もえうつc 燃え移"
"もえいd 萌え出"
"もえあg 燃え上"
"もうしわたs 申し渡"
"もうしわけなs 申し訳無"
"もうしわけなk 申し訳無"
"もうしわけなi 申し訳無"
"もうしわk 申し分"
"もうしぶんなs 申し分無"
"もうしぶんなk 申し分無"
"もうしぶんなi 申し分無"
"もうしひらk 申し開"
"もうしひらi 申し開"
"もうしのb 申し述"
"もうしでz 申し出"
"もうしでy 申し出"
"もうしでt 申し出"
"もうしでs 申し出"
"もうしでr 申し出"
"もうしでn 申し出"
"もうしでm 申し出"
"もうしでc 申し出"
"もうしつたe 申し伝 申伝"
"もうしつk 申し付"
"もうしたt 申し立 申立"
"もうしそe 申し添"
"もうしこs 申し越"
"もうしこn 申し込 申込"
"もうしこm 申し込 申込"
"もうしかn 申し兼"
"もうしおくt 申し送 申送"
"もうしおくr 申し遅 申し送 申送"
"もうしおくn 申し送 申送"
"もうしおくc 申し送 申送"
"もうしうk 申し受"
"もうしいr 申し入 申入"
"もうしあわs 申し合"
"もうしあw 申し合"
"もうしあg 申し上"
"もうs 申"
"もうk 設 儲"
"もうd 詣"
"もy 燃 萌 萠"
"もt 持 盛 以 保 漏 洩"
"もs 若 燃 模"
"もr 盛 漏 洩 守"
"もn 揉 盛 漏 洩"
"もm 揉"
"もe 燃 萌 萠"
"もc 持 保 盛 漏 洩"
"めんぼくなs 面目無"
"めんぼくなk 面目無"
"めんぼくなi 面目無"
"めんばs 面罵"
"めんどくさs 面倒臭"
"めんどくさk 面倒臭"
"めんどくさi 面倒臭"
"めんどくさg 面倒臭"
"めんどうくさs 面倒臭"
"めんどうくさk 面倒臭"
"めんどうくさi 面倒臭"
"めんどうくさg 面倒臭"
"めんくらw 面喰"
"めんくらu 面喰"
"めんくらt 面喰"
"めんくらo 面喰"
"めんくらi 面喰"
"めんくらe 面喰"
"めんくらc 面喰"
"めんくr 面喰 面食"
"めんくi 面食"
"めんきょとr 免許取"
"めんz 免"
"めんs 面"
"めんj 免"
"めりこn めり込 減り込"
"めりこm 減り込 めり込"
"めもt メモ"
"めもr メモ"
"めもn メモ"
"めもc メモ"
"めめs 女々 女女"
"めまぐるs 目紛"
"めべr 目減"
"めぶk 芽吹"
"めぶi 芽吹"
"めばr 目張"
"めばe 芽生"
"めぬきどおr 目抜き通"
"めぬk 目抜"
"めどおs 目通"
"めとt 娶"
"めとr 娶"
"めとn 娶"
"めとc 娶"
"めでたs 目出度"
"めでたk 目出度"
"めでたi 目出度"
"めでたg 目出度"
"めでt 目出"
"めづらs 珍 珎"
"めづm 目詰"
"めつk 目付 眼付"
"めったうt 滅多打 メッタ打"
"めったn 滅多"
"めっs 滅"
"めだt 目立"
"めだc 目立"
"めずらs 珍 珎"
"めじろどおr 目白通"
"めじろおs 目白押"
"めしはなt 召し放"
"めしはなc 召し放"
"めしとt 召し捕 召し取"
"めしとr 召し捕 召し取"
"めしとn 召し捕 召し取"
"めしとc 召し捕 召し取"
"めしつかw 召し使"
"めしつかu 召し使"
"めしつかt 召し使"
"めしつかo 召し使"
"めしつかi 召し使"
"めしつかe 召し使"
"めしつかc 召し使"
"めしだs 召し出"
"めしかかe 召し抱"
"めしいr 召し入"
"めしあg 召し上"
"めしi 盲"
"めざわr 目障"
"めざまs 目覚"
"めざとs 目敏"
"めざとk 目敏"
"めざとi 目敏"
"めざとg 目敏"
"めざs 目指 目刺"
"めざm 目覚 目醒"
"めぐろどおr 目黒通"
"めぐりめぐt 巡り巡"
"めぐりあw 巡り合 巡り会 回り合 巡り逢"
"めぐりあu 巡り会 巡り合 巡り逢"
"めぐりあt 巡り会 巡り合 巡り逢"
"めぐりあo 巡り会 巡り合 巡り逢"
"めぐりあi 巡り会 巡り合 巡り逢"
"めぐりあe 巡り会 巡り合 巡り逢"
"めぐりあc 巡り会 巡り合 巡り逢"
"めぐt 巡 廻 回 繞 繚"
"めぐs 愛"
"めぐr 巡 廻 回 繞 繚"
"めぐn 恵 惠 巡 廻 回 繞 繚 萌"
"めぐm 恵 萌 惠"
"めぐk 愛"
"めぐc 巡 廻 回 繞 繚"
"めくれあg 捲れ上"
"めくるめk 目眩"
"めくるめi 目眩"
"めくらまs 目眩"
"めくらうt 盲打"
"めくらm 目眩"
"めくばs 目配"
"めくばr 目配"
"めくt 捲"
"めくr 捲"
"めくn 捲"
"めくc 捲"
"めきk 目利"
"めがk 目掛"
"めかしこn 粧し込"
"めかしこm 粧し込"
"めかくs 目隠"
"めかs 粧"
"めおs 目押"
"めうつr 目移"
"めいわくかk 迷惑掛"
"めいじどおr 明治通"
"めいきゅういr 迷宮入"
"めいうt 銘打"
"めいうc 銘打"
"めいz 命 銘"
"めいt 滅入"
"めいs 瞑"
"めいr 滅入"
"めいn 滅入"
"めいj 命 銘"
"めいc 滅入"
"めあわs 娶"
"めあたらs 目新"
"めあw 妻合"
"めあt 目当"
"めあk 目明"
"めs 召"
"めr 減"
"めn 目"
"めg 芽"
"めd 愛 賞 目"
"めb 目"
"むりじi 無理強"
"むりp 無理"
"むりn 無理"
"むらなk ムラ無"
"むらg 群 叢 簇"
"むねんg 無念"
"むねやk 胸焼"
"むねあg 棟上"
"むにきs 無に帰"
"むなさわg 胸騒"
"むなs 虚 空"
"むとどk 無届"
"むづかt 憤"
"むづかs 難"
"むづかr 憤"
"むづかn 憤"
"むづかc 憤"
"むつみあw 睦み合"
"むつみあu 睦み合"
"むつみあt 睦み合"
"むつみあo 睦み合"
"むつみあi 睦み合"
"むつみあc 睦み合"
"むつかs 難"
"むつn 睦"
"むつm 睦"
"むつb 睦"
"むっt 六"
"むちうt 鞭打 鞭"
"むちうc 鞭打 鞭"
"むだなk 無駄無"
"むだづかi 無駄遣 無駄使"
"むだn 無駄"
"むだd 無駄"
"むせびなk 咽び泣 噎び泣"
"むせびなi 咽び泣 噎び泣"
"むせかえt 噎せ返 噎返 蒸返"
"むせかえr 噎せ返 噎返"
"むせかえn 噎せ返 噎返 蒸返"
"むせかえc 噎せ返 噎返 蒸返"
"むせp 咽"
"むせn 咽 噎"
"むせb 咽 噎"
"むずがゆs むず痒"
"むずがゆk むず痒"
"むずがゆi むず痒"
"むずがゆg むず痒"
"むずかt 憤"
"むずかs 難"
"むずかr 憤"
"むずかn 憤"
"むずかc 憤"
"むすびなおs 結び直"
"むすびつk 結び付"
"むすびつi 結び付"
"むすn 結 掬"
"むすb 結 掬"
"むしりとt 毟り取"
"むしりとr 毟り取"
"むしりとn 毟り取"
"むしりとc 毟り取"
"むしよk 虫除"
"むしゃぶりつk 武者振り付"
"むしゃぶりつi 武者振り付"
"むしゃぶr 武者振"
"むしぼs 虫干"
"むしふうj 虫封"
"むしばn 蝕 蠹 蠧"
"むしばm 蝕 蠹 蠧"
"むしとr 虫取"
"むしくi 虫食"
"むしかえs 蒸し返"
"むしあつs 蒸し暑"
"むしあつk 蒸し暑"
"むしあつi 蒸し暑"
"むしあつg 蒸し暑"
"むしt 毟"
"むしs 無視"
"むしr 寧 毟"
"むしn 毟"
"むしc 毟"
"むさぼりよn 貪り読"
"むさぼりよm 貪り読"
"むさぼりくw 貪り食 貪り喰"
"むさぼりくu 貪り食 貪り喰"
"むさぼりくt 貪り食 貪り喰"
"むさぼりくo 貪り食 貪り喰"
"むさぼりくi 貪り食 貪り喰"
"むさぼりくe 貪り食 貪り喰"
"むさぼりくc 貪り食 貪り喰"
"むさぼt 貪"
"むさぼr 貪"
"むさぼn 貪"
"むさぼc 貪"
"むさくるs むさ苦"
"むごt 惨 酷"
"むごs 惨 酷"
"むごk 惨 酷"
"むごi 惨 酷"
"むごg 惨 酷"
"むこu 向 向こ"
"むけなおs 向け直"
"むくw 報 酬"
"むくu 報 酬"
"むくt 報 酬"
"むくr 剥"
"むくo 報 酬"
"むくn 浮腫"
"むくm 浮腫"
"むくi 報 酬"
"むくe 報 酬"
"むくc 報 酬"
"むきなおt 向き直"
"むきなおr 向き直"
"むきなおn 向き直"
"むきなおc 向き直"
"むきとt 剥き取"
"むきとr 剥き取"
"むきとn 剥き取"
"むきとc 剥き取"
"むきだs 剥き出"
"むきあw 向き合"
"むきあu 向き合"
"むきあt 向き合"
"むきあo 向き合"
"むきあi 向き合"
"むきあe 向き合"
"むきあc 向き合"
"むかしなつk 昔懐"
"むかしきk 昔聞"
"むかしきi 昔聞"
"むかえとt 迎え取"
"むかえとr 迎え取"
"むかえとn 迎え取"
"むかえとc 迎え取"
"むかえうt 迎え撃"
"むかえうc 迎え撃"
"むかえいr 迎え入"
"むかいあw 向かい合 向い合"
"むかいあu 向かい合 向い合"
"むかいあt 向かい合 向い合"
"むかいあo 向かい合 向い合"
"むかいあi 向かい合 向い合"
"むかいあe 向かい合 向い合"
"むかいあc 向かい合 向い合"
"むかw 向 対"
"むかu 向 対"
"むかt 向 対"
"むかo 向 対"
"むかi 向 向か 対"
"むかh 迎 対 邀"
"むかe 迎 邀 向 対"
"むかc 向 対"
"むt 六"
"むs 蒸 咽 噎"
"むr 群 蒸"
"むk 向 剥"
"むi 向 剥"
"みわたs 見渡"
"みわすr 見忘"
"みわk 見分"
"みれんt 未練"
"みれんg 未練"
"みよr 身寄"
"みょうs 妙"
"みょうn 妙"
"みょうd 妙"
"みやまいr 宮参"
"みやぶt 見破"
"みやぶr 見破"
"みやぶn 見破"
"みやぶc 見破"
"みやびy 雅"
"みやびs 雅"
"みやびn 雅"
"みやびd 雅"
"みやづかe 宮仕"
"みやすs 見易"
"みやすk 見易"
"みやすi 見易"
"みやすg 見易"
"みやこおt 都落"
"みやt 見遣"
"みやr 見遣"
"みやn 見遣"
"みやc 見遣"
"みやb 雅"
"みゃくうt 脈打 脈搏"
"みゃくうc 脈打 脈搏"
"みもだe 身悶"
"みもt 身持"
"みめよs 見目好"
"みめよk 見目好"
"みめよi 見目好"
"みめよg 見目好"
"みめうるわs 見目麗"
"みむk 見向"
"みむi 見向"
"みみよr 耳寄"
"みみなr 耳慣 耳鳴 耳馴"
"みみざわr 耳障"
"みみざとs 耳聡"
"みみざとk 耳聡"
"みみざとi 耳聡"
"みみざとg 耳聡"
"みみかk 耳掻"
"みみうt 耳打"
"みみあたらs 耳新"
"みまわt 見回"
"みまわs 見回"
"みまわr 見回"
"みまわn 見回"
"みまわc 見回"
"みまもt 見守"
"みまもr 見守"
"みまもn 見守"
"みまもc 見守"
"みまちがw 見間違"
"みまちがu 見間違"
"みまちがt 見間違"
"みまちがo 見間違"
"みまちがi 見間違"
"みまちがe 見間違"
"みまちがc 見間違"
"みまがw 見紛"
"みまがu 見紛"
"みまがt 見紛"
"みまがo 見紛"
"みまがi 見紛"
"みまがe 見紛"
"みまがc 見紛"
"みまかt 身罷 薨"
"みまかr 身罷 薨"
"みまかn 身罷 薨"
"みまかc 身罷 薨"
"みまw 見舞"
"みまu 見舞"
"みまt 見舞"
"みまo 見舞"
"みまi 見舞"
"みまh 見舞"
"みまe 見舞"
"みまc 見舞"
"みぶるi 身震"
"みぶr 身振"
"みひらk 見開"
"みひらi 見開"
"みばe 見栄 見映"
"みはるk 見霽"
"みはらs 見晴"
"みはらi 未払"
"みはなs 見放"
"みはっt 見張"
"みはじm 見始 観始"
"みはからi 見計"
"みはかr 見計"
"みはt 見張 見果 瞠"
"みはr 見張 見晴 瞠"
"みはn 見張 瞠"
"みはc 見張 瞠"
"みのまわr 身の回"
"みのこs 見残"
"みのがs 見逃"
"みのt 実 稔"
"みのr 実 稔"
"みのn 実 稔"
"みのg 見逃"
"みのc 実 稔"
"みねうt 峰打"
"みぬk 見抜"
"みぬi 見抜"
"みにつk 身に付"
"みにつi 身に付"
"みにくs 醜 見難 儖"
"みにくk 醜 見難 儖"
"みにくi 醜 見難 儖"
"みにくg 醜 見難 儖"
"みにいt 見に行"
"みにいk 見に行"
"みにいc 見に行"
"みならw 見習 見倣"
"みならu 見習 見倣"
"みならt 見習 見倣"
"みならo 見習 見倣"
"みならi 見習 見倣"
"みならe 見習 見倣"
"みならc 見習 見倣"
"みなみむk 南向"
"みなごろs 皆殺"
"みなぎt 漲"
"みなぎr 漲"
"みなぎn 漲"
"みなぎc 漲"
"みなおなz 皆同"
"みなおなj 皆同"
"みなおs 見直"
"みなs 見做 看做 皆"
"みなr 見慣 見馴"
"みなg 身投"
"みとめがたs 認め難"
"みとめがたk 認め難"
"みとめがたi 認め難"
"みとめがたg 認め難"
"みとめあw 認め合"
"みとめあu 認め合"
"みとめあt 認め合"
"みとめあo 認め合"
"みとめあi 認め合"
"みとめあe 認め合"
"みとめあc 認め合"
"みとどk 見届"
"みとがm 見咎"
"みとおs 見通"
"みとうs 見透 見通"
"みとt 看取 見取"
"みとr 看取 見惚 見取 見蕩"
"みとn 看取 見取"
"みとm 認"
"みとc 看取 見取"
"みてとt 見て取"
"みてとr 見て取"
"みてとn 見て取"
"みてとc 見て取"
"みてこz 見て来"
"みてこy 見て来"
"みてこs 見て来"
"みてこr 見て来"
"みてこn 見て来"
"みてこi 見て来"
"みてくr 見て来 見て呉"
"みてくn 見て来"
"みてきy 見て来"
"みてきt 見て来"
"みてきs 見て来"
"みてきn 見て来"
"みてきm 見て来"
"みてきd 見て来"
"みてきc 見て来"
"みていt 見て行"
"みていk 見て行"
"みていc 見て行"
"みづらs 見辛"
"みづらk 見辛"
"みづらi 見辛"
"みづらg 見辛"
"みづくろi 身繕"
"みづかr 自"
"みつもt 見積"
"みつもr 見積"
"みつもn 見積"
"みつもc 見積"
"みつめなおs 見つめ直 見詰め直"
"みつめあw 見つめ合 見詰め合"
"みつめあu 見つめ合 見詰め合"
"みつめあt 見つめ合 見詰め合"
"みつめあo 見つめ合 見詰め合"
"みつめあi 見つめ合 見詰め合"
"みつめあe 見つめ合 見詰め合"
"みつめあc 見つめ合 見詰め合"
"みつづk 見続"
"みつぞろi 三つ揃"
"みつけだs 見つけ出 見付け出"
"みつくろw 見繕"
"みつくろu 見繕"
"みつくろt 見繕"
"みつくろo 見繕"
"みつくろi 見繕"
"みつくろh 見繕"
"みつくろe 見繕"
"みつくろc 見繕"
"みつくs 見尽"
"みつかr 見付か"
"みつs 密"
"みつn 密"
"みつm 見積 見詰 凝視 瞶"
"みつk 見付"
"みつi 貢"
"みつg 貢"
"みつd 密"
"みっt 三"
"みぢかn 身近"
"みちゆk 道行"
"みちむk 道向"
"みちみt 満ち満"
"みちびきだs 導き出"
"みちびk 導"
"みちびi 導"
"みちづr 道連"
"みちたr 満ち足"
"みちがw 見違"
"みちがu 見違"
"みちがt 見違"
"みちがo 見違"
"みちがi 見違"
"みちがe 見違"
"みちがc 見違"
"みちあふr 満ち溢"
"みだれとn 乱れ飛"
"みだれとb 乱れ飛"
"みだれうt 乱れ打"
"みだしなm 身嗜"
"みだs 乱 見出 紊 亂"
"みだr 乱 淫 猥 妄 濫 紊 亂"
"みたt 見立"
"みたs 満 充"
"みそんj 見損"
"みそづk 味噌漬"
"みそこn 見損"
"みそいたm 味噌炒"
"みそr 見逸"
"みそm 見初"
"みそi 禊"
"みそg 禊"
"みせびらk 店開"
"みせつk 見せ付"
"みせじまi 店仕舞"
"みせがまe 店構"
"みせかk 見せ掛"
"みせあw 見せ合"
"みせあu 見せ合"
"みせあt 見せ合"
"みせあo 見せ合"
"みせあi 見せ合"
"みせあe 見せ合"
"みせあc 見せ合"
"みずわr 水割"
"みずもr 水漏"
"みずみずs 瑞々 瑞瑞 水々 水水"
"みずまわr 水回"
"みずまs 水増"
"みずまk 水撒"
"みずぶとr 水太"
"みずびたs 水浸"
"みずはk 水捌"
"みずだs 水出"
"みずたまr 水溜"
"みずたk 水炊"
"みずぜm 水攻 水責"
"みずくさs 水臭"
"みずくさk 水臭"
"みずくさi 水臭"
"みずくさg 水臭"
"みずきr 水切"
"みずがr 水涸"
"みずかr 自"
"みずいr 水入"
"みずあらi 水洗"
"みずあそb 水遊"
"みずあかとr 水垢取"
"みずあg 水揚"
"みずあb 水浴"
"みずp 水"
"みすぼr 見窄"
"みすごs 見過"
"みすかs 見透"
"みすt 見捨 見棄 ミス"
"みすr ミス"
"みすn ミス"
"みすk 見透"
"みすg 見過"
"みすe 見据 視据"
"みすc ミス"
"みじんぎr 微塵切"
"みじろi 身動"
"みじろg 身動"
"みじかすg 短過"
"みじかs 短 身近"
"みじかn 身近"
"みじかm 短"
"みじかk 短 身近"
"みじかi 短 身近"
"みじかg 短 身近"
"みじm 惨 慘"
"みじk 短"
"みしりおk 見知り置"
"みしりおi 見知り置"
"みしt 見知"
"みしr 見知"
"みしn 見知"
"みしc 見知"
"みさだm 見定"
"みさげはt 見下げ果"
"みさg 見下"
"みごろs 見殺"
"みごもt 身籠 妊"
"みごもr 身籠 妊"
"みごもn 身籠 妊"
"みごもc 身籠 妊"
"みごたe 見応"
"みごしらe 身拵"
"みこs 見越"
"みこn 見込"
"みこm 見込"
"みぐるs 見苦"
"みくらb 見比 見較"
"みくだs 見下"
"みぎまわr 右回"
"みぎどなr 右隣"
"みぎぞろe 右揃"
"みぎそろe 右揃"
"みぎきk 右利"
"みぎがk 右書"
"みぎs 右"
"みきわm 見極"
"みきt 見切"
"みきr 見切"
"みきn 見切"
"みきk 見聞"
"みきc 見切"
"みがわr 身代"
"みがまe 身構"
"みがたm 身固"
"みがきぬk 磨き抜"
"みがきぬi 磨き抜"
"みがきたt 磨き立"
"みがきあg 磨き上"
"みがk 磨 研"
"みがi 磨 研"
"みかわs 見交"
"みかぎt 見限"
"みかぎr 見限"
"みかぎn 見限"
"みかぎc 見限"
"みかえt 見返"
"みかえs 見返"
"みかえr 見返"
"みかえn 見返"
"みかえc 見返"
"みかw 見交"
"みかn 見兼"
"みかk 見掛"
"みおわt 見終"
"みおわr 見終"
"みおわn 見終"
"みおわc 見終"
"みおぼe 見覚"
"みおとs 見落"
"みおとr 見劣"
"みおくt 見送"
"みおくr 見送"
"みおくn 見送"
"みおくc 見送"
"みおw 見終"
"みおt 見落"
"みおr 見下"
"みおe 見終 観終"
"みえみe 見え見"
"みえっぱr 見栄っ張"
"みえすk 見え透"
"みえすi 見え透"
"みえかくr 見え隠"
"みうしなw 見失"
"みうしなu 見失"
"みうしなt 見失"
"みうしなo 見失"
"みうしなi 見失"
"みうしなe 見失"
"みうしなc 見失"
"みうごk 身動"
"みうr 身売"
"みうk 見受"
"みいだs 見出"
"みいt 見入 魅入"
"みいr 見入 魅入 実入"
"みいn 見入 魅入"
"みいc 見入 魅入"
"みあわs 見合"
"みあやまt 見誤"
"みあやまr 見誤"
"みあやまn 見誤"
"みあやまc 見誤"
"みあたt 見当"
"みあたr 見当"
"みあたn 見当"
"みあたc 見当"
"みあw 見合"
"みあu 見合"
"みあt 見当 見合"
"みあo 見合"
"みあk 見飽"
"みあi 見合"
"みあg 見上"
"みあe 見合"
"みあc 見合"
"みz 見 観 視 診 看 觀"
"みy 見 観 視 診 看 觀"
"みw 見 身 観 視 診 看 觀"
"みu 見 観 視 診 看 觀"
"みt 満 充 見 観 視 診 看 盈 三 滿 觀"
"みs 見 魅 観 視 診 看 觀"
"みr 見 観 視 診 看 觀"
"みp 見 観 視 診 看 觀"
"みo 見 観 視 診 看 觀"
"みn 見 観 視 看 身 診 觀"
"みm 見 観 視 診 看 觀"
"みk 見 観 視 診 看 觀"
"みj 身 見 観 視 診 看 觀"
"みi 見 観 視 診 看 觀"
"みh 見 観 視 診 看 觀"
"みg 見 観 視 診 看 觀"
"みe 見 観 視 診 看 觀"
"みd 見 観 視 診 看 觀"
"みc 見 満 滿 観 視 診 看 觀"
"みb 見 観 視 診 看 觀"
"みa 見 観 視 診 看 觀"
"まんまるs 真ん丸"
"まんまるn 真ん丸"
"まんまるk 真ん丸"
"まんまるi 真ん丸"
"まんまるd 真ん丸"
"まんがかk 漫画描"
"まんz 慢"
"まんj 慢"
"まゐr 參"
"まわりもt 回り持"
"まわりまわt 回り回"
"まわりこn 回り込"
"まわりこm 回り込"
"まわしいr 回し入"
"まわt 回 廻 周 囘 巡"
"まわs 回 廻 周 囘"
"まわr 回 周 廻 巡 囘"
"まわn 回 周 廻 巡 囘"
"まわc 回 周 廻 巡 囘"
"まろy 円"
"まろn 転"
"まろm 円 丸"
"まろb 転"
"まれs 稀 希"
"まれn 稀 希"
"まれd 稀 希"
"まるやk 丸焼"
"まるもうk 丸儲"
"まるめこn 丸め込"
"まるめこm 丸め込"
"まるみe 丸見"
"まるなg 丸投"
"まるだs 丸出"
"まるがかe 丸抱"
"まるがr 丸刈"
"まるかじr 丸齧"
"まるうつs 丸写"
"まるあらi 丸洗"
"まるs 丸 円 圓 槫"
"まるm 丸 円 圓 槫"
"まるk 丸 円 圓 槫"
"まるi 丸 円 圓 槫"
"まよいこn 迷い込"
"まよいこm 迷い込"
"まよw 迷"
"まよu 迷 紕"
"まよt 迷"
"まよo 迷"
"まよk 魔除"
"まよi 迷"
"まよh 迷"
"まよe 迷"
"まよc 迷"
"まやかs 瞞"
"まもりぬk 守り抜"
"まもりぬi 守り抜"
"まもりとおs 守り通"
"まもりつづk 守り続"
"まもなs 間も無"
"まもなk 間も無"
"まもなi 間も無"
"まもなg 間も無"
"まもt 守 護 防"
"まもr 守 護 防"
"まもn 守 護 防"
"まもc 守 護 防"
"まめy 忠実"
"まむk 真向"
"まみr 塗"
"まみe 見"
"ままn 儘"
"まほうつかi 魔法使"
"まぶs 眩 塗"
"まびk 間引"
"まびi 間引"
"まばらs 疎"
"まばらn 疎"
"まばらd 疎"
"まばゆs 目映 眩"
"まばゆk 目映 眩"
"まばゆi 目映 眩"
"まばゆg 目映 眩"
"まばたk 瞬"
"まばたi 瞬"
"まばr 疎"
"まはs 回 廻"
"まのあt 目の当"
"まのb 間延"
"まねきよs 招き寄"
"まねきいr 招き入"
"まねz 真似"
"まねy 真似"
"まねt 真似"
"まねs 真似"
"まねr 真似"
"まねn 真似"
"まねm 真似"
"まねk 招 真似"
"まねi 招"
"まねc 真似"
"まねb 学"
"まねa 真似"
"まぬがr 免"
"まぬかr 免"
"まぬk 間抜"
"まにうk 真に受"
"まにあわs 間に合"
"まにあw 間に合"
"まにあu 間に合"
"まにあt 間に合"
"まにあo 間に合"
"まにあi 間に合"
"まにあe 間に合"
"まにあc 間に合"
"まなざs 眼差 目差"
"まなn 学 學 斈"
"まなb 学 學 斈"
"まどろn 微睡"
"まどろm 微睡"
"まどがk 窓掛"
"まどかk 窓掛"
"まどw 惑 悗"
"まどu 惑 悗"
"まどt 惑 悗"
"まどr 間取"
"まどo 惑 悗"
"まどk 円"
"まどi 惑 悗"
"まどh 惑"
"まどe 惑 悗"
"まどc 惑 悗"
"まとわりつk 纏わり付"
"まとわりつi 纏わり付"
"まとめがi まとめ買"
"まとはずr 的外"
"まといつk 纏い付"
"まといつi 纏い付"
"まとw 纏 繚"
"まとu 纏 繚"
"まとt 纏 繚"
"まとo 纏 繚"
"まとm 纏 纒"
"まとi 纏 繚"
"まとh 纏"
"まとe 纏 繚"
"まとc 纏 繚"
"まづs 不味"
"まづk 不味"
"まづi 不味"
"まづg 不味"
"まつりあg 祭り上"
"まつまえづk 松前漬"
"まつかざr 松飾"
"まつw 纏"
"まつt 祭 奉 祀 纏"
"まつr 祭 祀 奉 纏"
"まつn 祭 祀 奉 纏"
"まつh 纏"
"まつc 祭 祀 奉 纏"
"まっぷたt 真っ二"
"まっとu 全"
"まったいr 真っ平"
"まったs 全"
"まったk 全"
"まっすg 真っ直"
"まっしろs 真っ白"
"まっしろk 真っ白"
"まっしろi 真っ白"
"まっしろg 真っ白"
"まっさかr 真っ盛"
"まっこうくさs 抹香臭"
"まっこうくさk 抹香臭"
"まっこうくさi 抹香臭"
"まっこうくさg 抹香臭"
"まっくろs 真っ黒"
"まっくろk 真っ黒"
"まっくろi 真っ黒"
"まっくろg 真っ黒"
"まちわb 待ち侘"
"まちゆk 街行"
"まちぼうk 待ち惚"
"まちぶs 待ち伏"
"まちはずr 街外 町外"
"まちのぞn 待ち望"
"まちのぞm 待ち望"
"まちのr 街乗"
"まちどおs 待ち遠"
"まちづくr 町作"
"まちこg 待ち焦"
"まちくたびr 待ち草臥"
"まちきr 待ち切"
"まちがw 間違"
"まちがu 間違"
"まちがt 間違"
"まちがo 間違"
"まちがi 間違"
"まちがe 間違"
"まちがc 間違"
"まちかまe 待ち構"
"まちかn 待ち兼"
"まちうk 待ち受 待受"
"まちあわs 待合 待ち合わ"
"まちあぐn 待ち倦"
"まちあぐm 待ち倦"
"まちあw 待ち合 待合"
"まちあk 待ち明"
"まちあi 待ち合 待合"
"まだるs 間怠"
"まだるk 間怠"
"まだるi 間怠"
"まだるg 間怠"
"まだらs 斑"
"まだらn 斑"
"まだらd 斑"
"まだs 未だ"
"またたk 瞬"
"またたi 瞬"
"またぎこs 跨ぎ越"
"またぎk 又聞"
"またがt 跨"
"またがs 又貸"
"またがr 跨 又借"
"またがn 跨"
"またがc 跨"
"またm 又"
"またi 跨"
"またh 又"
"またg 跨"
"まぜっかえs 混ぜっ返"
"まぜこn 混ぜ込"
"まぜこm 混ぜ込"
"まぜがk 交ぜ書 混ぜ書"
"まぜかえs 混ぜ返 雑ぜ返"
"まぜあわs 混ぜ合"
"まぜあw 混ぜ合"
"まずs 貧 不味 マズ"
"まずk 不味 マズ"
"まずi 不味 マズ"
"まずg 不味 マズ"
"まじろi 瞬"
"まじろg 瞬"
"まじりあw 混じり合"
"まじりあu 混じり合"
"まじりあt 混じり合"
"まじりあo 混じり合"
"まじりあi 混じり合"
"まじりあe 混じり合"
"まじりあc 混じり合"
"まじめすg 真面目過"
"まじなi 呪"
"まじきr 間仕切"
"まじw 交"
"まじt 混"
"まじr 混"
"まじn 混"
"まじk 間近"
"まじh 交 雑"
"まじe 交 雑"
"まじc 混"
"ましまs 在 坐"
"ましt 況し"
"まざりあw 混ざり合"
"まざりあu 混ざり合"
"まざりあt 混ざり合"
"まざりあo 混ざり合"
"まざりあi 混ざり合"
"まざりあe 混ざり合"
"まざりあc 混ざり合"
"まさぐt 弄"
"まさぐr 弄"
"まさぐn 弄"
"まさぐc 弄"
"まさt 勝 優"
"まさs 正"
"まさr 勝 優"
"まさn 正 勝 優"
"まさc 勝 優"
"まごびk 孫引"
"まごu 紛"
"まことs 実 真"
"まことn 誠 真 実"
"まげのb 曲げ伸"
"まけつづk 負け続"
"まけこs 負け越"
"まぐまだm マグマ溜"
"まぐr 紛"
"まくりあg 捲り上"
"まくらs 枕"
"まくひk 幕引"
"まくしたt 捲し立 まくし立"
"まくしあg 捲し上"
"まくぎr 幕切"
"まくあk 幕開"
"まくt 捲"
"まくr 捲"
"まくn 捲"
"まくc 捲"
"まぎれこn 紛れ込"
"まぎれこm 紛れ込"
"まぎr 紛"
"まきわr 薪割"
"まきもどs 巻き戻 巻戻"
"まきなおs 蒔き直 巻き直"
"まきつk 巻き付 巻付"
"まきつi 巻き付 巻付"
"まきちらs 撒き散ら"
"まきちr 撒き散"
"まきぞe 巻き添"
"まきこn 巻き込"
"まきこm 巻き込"
"まきかえs 巻き返"
"まきおこs 巻き起 捲き起 巻起"
"まきおk 巻き起 捲き起 巻起"
"まきあg 巻き上"
"まがりきt 曲がり切"
"まがりきr 曲がり切"
"まがりきn 曲がり切"
"まがりきc 曲がり切"
"まがまがs 禍々 禍禍 兇々 曲々"
"まがw 紛 擬"
"まがu 紛 擬"
"まがt 曲 紛 擬 枉 彎 弯"
"まがs 間貸"
"まがr 曲 間借 枉 彎 弯"
"まがo 紛 擬"
"まがn 曲 枉 彎 弯"
"まがi 紛 擬"
"まがh 紛"
"まがe 紛 擬"
"まがc 紛 擬 曲 枉 彎 弯"
"まかりまちがw 罷り間違"
"まかりまちがu 罷り間違"
"まかりまちがt 罷り間違"
"まかりまちがo 罷り間違"
"まかりまちがi 罷り間違"
"まかりまちがe 罷り間違"
"まかりまちがc 罷り間違"
"まかりなt 罷り成"
"まかりなr 罷り成"
"まかりなn 罷り成"
"まかりなc 罷り成"
"まかりとおt 罷り通"
"まかりとおr 罷り通"
"まかりとおn 罷り通"
"まかりとおc 罷り通"
"まかりでz 罷り出"
"まかりでt 罷り出"
"まかりでr 罷り出"
"まかりでn 罷り出"
"まかなw 賄"
"まかなu 賄"
"まかなt 賄"
"まかなo 賄"
"まかなi 賄"
"まかなh 賄"
"まかなe 賄"
"まかなc 賄"
"まかせっきr 任せっ切"
"まかせきt 任せ切"
"まかせきr 任せ切"
"まかせきn 任せ切"
"まかせきc 任せ切"
"まかt 罷"
"まかs 任 委"
"まかr 罷"
"まかn 罷"
"まかc 罷"
"まえわたs 前渡"
"まえもっt 前以"
"まえむk 前向"
"まえぶr 前触"
"まえふr 前振"
"まえばらi 前払"
"まえづk 前付"
"まえだおs 前倒"
"まえがs 前貸"
"まえがr 前借"
"まえがk 前書"
"まえかk 前掛"
"まえおk 前置"
"まえおi 前置"
"まえうr 前売"
"まえいわi 前祝"
"まうs 申"
"まうk 設 儲"
"まうd 詣"
"まいもどt 舞い戻"
"まいもどr 舞い戻"
"まいもどn 舞い戻"
"まいもどc 舞い戻"
"まいちt 舞い散"
"まいちr 舞い散"
"まいちn 舞い散"
"まいちc 舞い散"
"まいたt 舞い立"
"まいたc 舞い立"
"まいこn 舞い込"
"まいこm 舞い込"
"まいくるw 舞い狂"
"まいくるu 舞い狂"
"まいくるt 舞い狂"
"まいくるo 舞い狂"
"まいくるi 舞い狂"
"まいくるe 舞い狂"
"まいくるc 舞い狂"
"まいおどt 舞い踊"
"まいおどr 舞い踊"
"まいおどn 舞い踊"
"まいおどc 舞い踊"
"まいおt 舞い落"
"まいおr 舞い降"
"まいおc 舞い落"
"まいあg 舞い上 舞上"
"まいt 参 參 詣"
"まいr 参 詣 參"
"まいn 参 詣 參"
"まいc 参 詣 參"
"まあたらs 真新"
"まあi 間合"
"まz 混 先 交 雑"
"まw 舞"
"まu 舞"
"まt 待 舞 俟"
"まs 増 摩 益 在 坐"
"まr 放"
"まo 舞"
"まn 間"
"まk 負 巻 撒 蒔 播 捲 敗 卷"
"まj 混 交 雑"
"まi 舞 巻 撒 蒔 散 播 卷"
"まh 舞"
"まg 曲 枉"
"まe 舞"
"まd 未"
"まc 待 舞 俟"
"ぽんびk ぽん引"
"ぽしゃt ポシャ"
"ぽしゃr ポシャ"
"ぽしゃn ポシャ"
"ぽしゃc ポシャ"
"ぼんおどr 盆踊"
"ぼんあk 盆明"
"ぼろs ボロ"
"ぼろk ボロ"
"ぼろi ボロ"
"ぼろg ボロ"
"ぼっs 没"
"ぼこt ボコ"
"ぼこr ボコ"
"ぼこn ボコ"
"ぼこc ボコ"
"ぼくw 僕"
"ぼくt 僕"
"ぼくs 卜"
"ぼくn 僕"
"ぼくm 僕"
"ぼくh 僕"
"ぼくg 僕"
"ぼかs 暈"
"ぼうよm 棒読"
"ぼうびk 棒引"
"ぼうだt 棒立"
"ぼうそうs 暴走"
"ぼうきr 棒切"
"ぼうえいs 防衛"
"ぼうy 坊"
"ぼs 干 乾"
"ぼr 惚 掘 彫"
"ぼm 誉 褒"
"ぼk 呆 惚 暈"
"ほんよm 本読"
"ほんみょうおなz 本名同"
"ほんみょうおなj 本名同"
"ほんぶr 本降"
"ほんどおr 本通"
"ほんどm 本泊"
"ほんとb 本飛"
"ほんづかi 本使"
"ほんすべr 本滑"
"ほんぎm 本決 本極"
"ほんw 本"
"ほろよi 微酔"
"ほろびゆk 滅び行"
"ほろびさt 滅び去"
"ほろびさr 滅び去"
"ほろびさn 滅び去"
"ほろびさc 滅び去"
"ほろにがs ほろ苦"
"ほろにがk ほろ苦"
"ほろにがi ほろ苦"
"ほろにがg ほろ苦"
"ほろn 滅 亡"
"ほろb 滅 亡"
"ほれぼr 惚れ惚"
"ほれなおs 惚れ直"
"ほれこn 惚れ込"
"ほれこm 惚れ込"
"ほりぬk 掘り抜"
"ほりぬi 掘り抜"
"ほりだs 掘り出 彫り出"
"ほりすすn 掘り進"
"ほりすすm 掘り進"
"ほりさg 掘り下"
"ほりこn 彫り込 掘り込 掘込 彫込"
"ほりこm 彫り込 掘り込 掘込 彫込"
"ほりくずs 掘り崩"
"ほりかえs 掘り返"
"ほりおk 掘り起"
"ほりあt 掘り当"
"ほりあg 彫り上 掘り上"
"ほめたたe 褒め称 誉め称"
"ほめたt 誉め立"
"ほめそやs 誉称 褒称 褒め称"
"ほめごろs 誉め殺 褒め殺"
"ほめあg 誉め上"
"ほまれたかs 誉れ高"
"ほまれたかk 誉れ高"
"ほまれたかi 誉れ高"
"ほまれたかg 誉れ高"
"ほまれおおk 誉大"
"ほまr 誉 譽"
"ほほばt 頬張"
"ほほばr 頬張"
"ほほばn 頬張"
"ほほばc 頬張"
"ほほえみかえs 微笑み返"
"ほほえn 微笑"
"ほほえm 微笑 頬笑"
"ほふt 屠"
"ほふr 屠"
"ほふn 屠"
"ほふc 屠"
"ほのみe 仄見"
"ほのじろs 仄白"
"ほのじろm 仄白"
"ほのじろk 仄白"
"ほのじろi 仄白"
"ほのじろg 仄白"
"ほのぐらs 仄暗"
"ほのぐらk 仄暗"
"ほのぐらi 仄暗"
"ほのぐらg 仄暗"
"ほのm 仄"
"ほのk 仄 側"
"ほねやすm 骨休"
"ほねばt 骨張"
"ほねばr 骨張"
"ほねばn 骨張"
"ほねばc 骨張"
"ほねぬk 骨抜"
"ほねなs 骨無"
"ほねつg 骨接"
"ほねぐm 骨組"
"ほねおt 骨折"
"ほねおr 骨折"
"ほねおn 骨折"
"ほねおc 骨折"
"ほねp 骨"
"ほどよs 程良"
"ほどよk 程良"
"ほどよi 程良"
"ほどよg 程良"
"ほどとおs 程遠"
"ほどとおk 程遠"
"ほどとおi 程遠"
"ほどとおg 程遠"
"ほどちかs 程近"
"ほどちかk 程近"
"ほどちかi 程近"
"ほどちかg 程近"
"ほどこs 施"
"ほどn 程"
"ほどk 解"
"ほどi 解"
"ほとんd 殆"
"ほとばしt 迸"
"ほとばしr 迸"
"ほとばしn 迸"
"ほとばしc 迸"
"ほとn 殆"
"ほてt 火照 熱"
"ほてr 火照 熱"
"ほてn 火照 熱"
"ほてc 火照 熱"
"ほつr 解"
"ほっぽりだs ほっぽり出"
"ほっつきあるk ほっつき歩"
"ほっつきあるi ほっつき歩"
"ほっs 欲"
"ほだs 絆"
"ほそながs 細長"
"ほそながk 細長"
"ほそながi 細長"
"ほそながg 細長"
"ほそぎr 細切"
"ほそy 細"
"ほそt 細"
"ほそs 細"
"ほそr 細"
"ほそn 細"
"ほそm 細"
"ほそk 細"
"ほそi 細"
"ほそg 細"
"ほそc 細"
"ほじくりだs 穿り出"
"ほじくりかえs 穿り返"
"ほじくt 穿"
"ほじくr 穿"
"ほじくn 穿"
"ほじくc 穿"
"ほじt 穿"
"ほじr 穿"
"ほじn 穿"
"ほじc 穿"
"ほしふr 星降"
"ほしうらなi 星占"
"ほしいままs 恣 縦"
"ほしいままn 恣 縦"
"ほしいままd 恣 縦"
"ほしs 欲"
"ほしk 欲"
"ほしi 欲し 欲"
"ほしg 欲"
"ほごあずかr 保護預"
"ほころn 綻"
"ほころb 綻"
"ほこりたかs 誇り高"
"ほこりたかk 誇り高"
"ほこりたかi 誇り高"
"ほこりたかg 誇り高"
"ほこりp 埃"
"ほこt 誇"
"ほこr 誇"
"ほこn 誇"
"ほこc 誇"
"ほぐs 解"
"ほぐr 解"
"ほがr 朗 朖"
"ほかn 他"
"ほおばt 頬張"
"ほおばr 頬張"
"ほおばn 頬張"
"ほおばc 頬張"
"ほおt 放"
"ほおr 放"
"ほおn 放"
"ほおc 放"
"ほえたt 吠え立"
"ほうりなg 放り投"
"ほうりだs 放り出"
"ほうりこn 放り込"
"ほうりこm 放り込"
"ほうりあg 放り上"
"ほうむりさt 葬り去"
"ほうむりさr 葬り去"
"ほうむりさn 葬り去"
"ほうむりさc 葬り去"
"ほうむt 葬"
"ほうむr 葬"
"ほうむn 葬"
"ほうむc 葬"
"ほうふn 豊富"
"ほうっておk 放って置"
"ほうっておi 放って置"
"ほうっt 放"
"ほうこくいたs 報告致"
"ほうz 報 奉 封 焙"
"ほうw 方"
"ほうt 放 抛 方"
"ほうs 保 焙"
"ほうr 放 抛"
"ほうn 放 抛 方"
"ほうm 方"
"ほうk 呆 惚"
"ほうj 報 奉 焙"
"ほうh 方"
"ほうg 方"
"ほうc 放 抛"
"ほt 掘 放 彫"
"ほs 欲 干 乾 補 保"
"ほr 掘 彫 惚 耄 恍 抛 放"
"ほn 掘 彫"
"ほm 褒 誉 賞 襃 譽"
"ほe 吠 吼 咆 哮"
"ほc 掘 彫"
"べんじたt 弁じ立"
"べんz 弁"
"べんs 便"
"べんj 弁"
"べとつk べと付"
"べとつi べと付"
"べつずr 別刷"
"べつうr 別売"
"べつあつかi 別扱"
"べつs 別"
"べつn 別"
"べつd 別"
"べたぬr べた塗"
"べたつk べた付"
"べたつi べた付"
"べいこくぎらi 米国嫌"
"べs 可"
"べk 可"
"べi 可"
"へんにゅうs 編入"
"へんそうくだs 返送下"
"へんじくだs 返事下"
"へんこういたs 変更致"
"へんこうs 変更"
"へんかんg 変換"
"へんかs 変化"
"へんz 変"
"へんt 変"
"へんs 偏 貶 変 變"
"へんn 変 變"
"へんj 変"
"へんd 変 變"
"へりくだt 謙 遜"
"へりくだr 謙 遜"
"へりくだn 謙 遜"
"へりくだc 謙 遜"
"へらs 減ら"
"へめぐt 経巡 経回 歴回"
"へめぐr 経巡 経回 歴回"
"へめぐn 経巡 経回 歴回"
"へめぐc 経巡 経回 歴回"
"へぼs ヘボ"
"へぼk ヘボ"
"へぼi ヘボ"
"へぼg ヘボ"
"へばりつk へばり付"
"へばりつi へばり付"
"へつらw 諂 諛"
"へつらu 諂 諛"
"へつらt 諂 諛"
"へつらo 諂 諛"
"へつらi 諂 諛"
"へつらh 諛 諂"
"へつらe 諂 諛"
"へつらc 諂 諛"
"へだたt 隔"
"へだたr 隔"
"へだたn 隔"
"へだたc 隔"
"へだt 隔"
"へたりこn へたり込"
"へたりこm へたり込"
"へたn 下手"
"へそまg 臍曲"
"へしおt 圧し折 へし折"
"へしおr 圧し折 へし折"
"へしおn 圧し折 へし折"
"へしおc 圧し折 へし折"
"へこn 凹"
"へこm 凹"
"へいわn 平和"
"へあg 経上"
"へz 経 經 歴"
"へy 経 歴 經"
"へt 減 経 經 歴"
"へs 圧 減 経 歴 經"
"へr 減 経 歴 經"
"へn 経 經 減 歴"
"へm 経 歴 經"
"へk 経 歴 經"
"へj 経 歴 經"
"へi 剥 折"
"へg 剥 折"
"へd 経 歴 經"
"へc 減 経 歴 經"
"ぶんなぐt 打ん殴 ぶん殴"
"ぶんなぐr ぶん殴 打ん殴"
"ぶんなぐn ぶん殴 打ん殴"
"ぶんなぐc ぶん殴 打ん殴"
"ぶんせつくぎr 文節区切"
"ぶんかつばらi 分割払"
"ぶんかつs 分割"
"ぶんs 分"
"ぶるi 震"
"ぶりかえs ぶり返"
"ぶらさg ぶら下"
"ぶひんとr 部品取"
"ぶばt 武張"
"ぶばr 武張"
"ぶばn 武張"
"ぶばc 武張"
"ぶどまr 歩留"
"ぶどm 歩留"
"ぶとt 太"
"ぶとr 太"
"ぶとn 太"
"ぶとc 太"
"ぶつぎr ぶつ切"
"ぶっとおs ぶっ通 打っ通"
"ぶっとn 打っ飛"
"ぶっとb 打っ飛"
"ぶったぎt ぶった切 ぶった斬 打っ手切"
"ぶったぎr ぶった切 ぶった斬 打っ手切"
"ぶったぎn ぶった切 ぶった斬 打っ手切"
"ぶったぎc ぶった切 ぶった斬 打っ手切"
"ぶっこわs ぶっ壊"
"ぶっころs ぶっ殺 ブッ殺 打っ殺"
"ぶっこn 打っ込 ぶっ込"
"ぶっこm 打っ込 ぶっ込"
"ぶっかk 打っ掛 ぶっ掛"
"ぶちこわs ぶち壊 打ち壊 ブチ壊"
"ぶちころs 打ち殺 ブチ殺 ぶち殺"
"ぶちこn 打ち込"
"ぶちこm 打ち込"
"ぶちぎr ブチ切"
"ぶちきr ブチ切"
"ぶちかm 打ち噛"
"ぶちあg 打ち上"
"ぶきみg 不気味"
"ぶかs 深"
"ぶかk 深"
"ぶかi 深"
"ぶかg 深"
"ぶあつs ぶ厚 分厚 部厚"
"ぶあつk ぶ厚 分厚 部厚"
"ぶあつi 分厚 部厚 ぶ厚"
"ぶあつg 分厚 部厚 ぶ厚"
"ぶt 撲 打 撃 振"
"ぶs 撫 伏"
"ぶr 振"
"ぶn 振"
"ぶk 拭 吹 葺"
"ぶc 振"
"ふんばt 踏ん張"
"ふんばr 踏ん張"
"ふんばn 踏ん張"
"ふんばc 踏ん張"
"ふんづm 糞詰"
"ふんづk 踏ん付"
"ふんぞりかえt 踏ん反り返"
"ふんぞりかえr 踏ん反り返"
"ふんぞりかえn 踏ん反り返"
"ふんぞりかえc 踏ん反り返"
"ふんぞt 踏ん反"
"ふんぞr 踏ん反"
"ふんぞn 踏ん反"
"ふんぞc 踏ん反"
"ふんじばt ふん縛"
"ふんじばr ふん縛"
"ふんじばn ふん縛"
"ふんじばc ふん縛"
"ふんぎt 踏ん切"
"ふんぎr 踏ん切"
"ふんぎn 踏ん切"
"ふんぎc 踏ん切"
"ふんs 扮"
"ふわたr 不渡"
"ふわk 腑分"
"ふろあg 風呂上"
"ふれまわt 触れ回"
"ふれまわr 触れ回"
"ふれまわn 触れ回"
"ふれまわc 触れ回"
"ふれこn 触れ込"
"ふれこm 触れ込"
"ふれあるk 触れ歩"
"ふれあるi 触れ歩"
"ふれあw 触れ合 触合"
"ふれあu 触れ合 触合"
"ふれあt 触れ合 触合"
"ふれあo 触れ合 触合"
"ふれあi 触れ合 触合"
"ふれあe 触れ合 触合"
"ふれあc 触れ合 触合"
"ふるまw 振る舞 振舞"
"ふるまu 振る舞 振舞"
"ふるまt 振る舞 振舞"
"ふるまo 振る舞 振舞"
"ふるまi 振舞 振る舞"
"ふるまh 振舞"
"ふるまe 振舞 振る舞"
"ふるまc 振る舞 振舞"
"ふるぼk 古惚"
"ふるすg 古過"
"ふるくさs 古臭"
"ふるくさk 古臭"
"ふるくさi 古臭"
"ふるくさg 古臭"
"ふるえあg 震え上"
"ふるいわk 篩い分"
"ふるいたt 奮い立 奮い起"
"ふるいたc 奮い立 奮い起"
"ふるいおとs 篩い落 振るい落 振い落"
"ふるいおこs 奮い起"
"ふるいおt 振るい落 篩い落"
"ふるいおk 奮い起"
"ふるw 震 奮 振 揮 篩"
"ふるu 奮 振 揮 震 篩 古 旧 故 舊"
"ふるt 奮 振 揮 震 篩"
"ふるs 古 旧 故 舊"
"ふるo 奮 振 揮 震 篩"
"ふるm 古 旧 故 舊"
"ふるk 古 旧 故 舊"
"ふるi 古 旧 震 奮 振 故 舊 揮 篩"
"ふるh 揮 振 震 奮 篩"
"ふるg 古 旧 故 舊"
"ふるe 震 顫 奮 振 揮 篩"
"ふるc 奮 振 揮 震 篩"
"ふるb 古"
"ふりわk 振り分"
"ふりやn 降り止"
"ふりやm 降り止"
"ふりむk 振り向"
"ふりむi 振り向"
"ふりみだs 振り乱"
"ふりまわs 振り回"
"ふりまz 振り混"
"ふりまk 振り撒"
"ふりまi 振り撒"
"ふりほどk 振り解"
"ふりほどi 振り解"
"ふりはらw 振り払"
"ふりはらu 振り払"
"ふりはらt 振り払"
"ふりはらo 振り払"
"ふりはらi 振り払"
"ふりはらe 振り払"
"ふりはらc 振り払"
"ふりのこs 降り残"
"ふりぬk 振り抜 振抜"
"ふりぬi 振り抜 振抜"
"ふりにg 振り逃"
"ふりつもt 降り積"
"ふりつもr 降り積"
"ふりつもn 降り積"
"ふりつもc 降り積"
"ふりつのt 降り募"
"ふりつのr 降り募"
"ふりつのn 降り募"
"ふりつのc 降り募"
"ふりつづk 降り続"
"ふりつづi 降り続"
"ふりつm 降り積"
"ふりつk 振り付 振付"
"ふりだs 振り出 降り出 振出"
"ふりたs 振り足"
"ふりそぼt 降り濡"
"ふりそそi 降り注"
"ふりそそg 降り注"
"ふりすt 振り捨"
"ふりしぼt 振り絞"
"ふりしぼr 振り絞"
"ふりしぼn 振り絞"
"ふりしぼc 振り絞"
"ふりしきt 降り頻"
"ふりしきr 降り頻"
"ふりしきn 降り頻"
"ふりしきc 降り頻"
"ふりさけみz 振り放け見"
"ふりさけみy 振り放け見"
"ふりさけみt 振り放け見"
"ふりさけみs 振り放け見"
"ふりさけみr 振り放け見"
"ふりさけみn 振り放け見"
"ふりさけみm 振り放け見"
"ふりさけみk 振り放け見"
"ふりさけみc 振り放け見"
"ふりさk 振り放"
"ふりこn 振り込 降り込 振込"
"ふりこm 振り込 振込 降り込 降り籠"
"ふりきt 振り切"
"ふりきr 振り切"
"ふりきn 振り切"
"ふりきc 振り切"
"ふりかぶt 振り被"
"ふりかぶr 振り被"
"ふりかぶn 振り被"
"ふりかぶc 振り被"
"ふりかざs 振り翳"
"ふりかえt 振り返 振返"
"ふりかえr 振り返 振返"
"ふりかえn 振り返 振返"
"ふりかえc 振り返 振返"
"ふりかk 降り掛 振り掛"
"ふりかe 振り替"
"ふりおとs 振り落"
"ふりおt 振り落"
"ふりあおi 振り仰"
"ふりあおg 振り仰"
"ふりあg 振り上 振上"
"ふゆやすm 冬休"
"ふゆばr 冬晴"
"ふゆきとどk 不行届"
"ふゆがr 冬枯"
"ふやs 増や 殖や"
"ふむk 不向"
"ふみわk 踏み分"
"ふみはずs 踏み外"
"ふみぬk 踏み抜 踏み貫"
"ふみぬi 踏み抜 踏み貫"
"ふみにじt 踏み躙"
"ふみにじr 踏み躙"
"ふみにじn 踏み躙"
"ふみにじc 踏み躙"
"ふみならs 踏み均"
"ふみなr 踏み鳴"
"ふみとどm 踏み止 踏み留"
"ふみつぶs 踏み潰"
"ふみつk 踏み付 踏付"
"ふみちr 踏み散"
"ふみだs 踏み出"
"ふみたおs 踏み倒"
"ふみしm 踏み締"
"ふみころs 踏み殺"
"ふみこn 踏み込 踏込"
"ふみこm 踏み込 踏込"
"ふみこe 踏み越"
"ふみきt 踏み切"
"ふみきr 踏み切"
"ふみきn 踏み切"
"ふみきc 踏み切"
"ふみかたm 踏み固"
"ふみおこなw 踏み行"
"ふみおこなu 踏み行"
"ふみおこなt 踏み行"
"ふみおこなo 踏み行"
"ふみおこなi 踏み行"
"ふみおこなc 踏み行"
"ふみいt 踏み入"
"ふみいr 踏み入"
"ふみいn 踏み入"
"ふみいc 踏み入"
"ふみあr 踏み荒"
"ふまe 踏ま"
"ふぶk 吹雪 乱吹"
"ふぶi 吹雪 乱吹"
"ふばらi 不払"
"ふぬk 腑抜"
"ふなよi 船酔"
"ふなもr 舟盛"
"ふなのr 船乗"
"ふなづm 船積"
"ふなr 不慣"
"ふとどk 不届"
"ふとt 太 肥"
"ふとs 太"
"ふとr 太 肥"
"ふとn 太 肥"
"ふとm 太"
"ふとk 太"
"ふとi 太"
"ふとg 太"
"ふとc 太 肥"
"ふでづかi 筆遣"
"ふでたt 筆立"
"ふでおr 筆下"
"ふでいr 筆入"
"ふてぶてs 太々"
"ふてくさt 不貞腐 ふて腐"
"ふてくさr 不貞腐 ふて腐"
"ふてくさn 不貞腐 ふて腐"
"ふてくさc 不貞腐 ふて腐"
"ふつくm 恚 慍 憤"
"ふつかよi 二日酔"
"ふつうn 普通"
"ふつk 恚 憤"
"ふっとn 吹っ飛"
"ふっとb 吹っ飛"
"ふってわk 降って湧"
"ふってわi 降って湧"
"ふっきr 吹っ切"
"ふっかk 吹っ掛"
"ふちどt 縁取"
"ふちどr 縁取"
"ふちどn 縁取"
"ふちどc 縁取"
"ふだんづかi 普段使"
"ふたりk 二人"
"ふたとおr 二通"
"ふたたb 再"
"ふたしk 不確"
"ふたt 二 弍"
"ふぞろi 不揃"
"ふせi 防 拒"
"ふせg 防 拒"
"ふずくm 慍 憤"
"ふすb 燻"
"ふしまわs 節回"
"ふしづk 節付"
"ふしくれだt 節榑立"
"ふしくれだc 節榑立"
"ふしおがn 伏し拝"
"ふしおがm 伏し拝"
"ふしあw 不仕合"
"ふざけt 巫山戯"
"ふざけr 巫山戯"
"ふざけn 巫山戯"
"ふざけc 巫山戯"
"ふさわs 相応"
"ふさぎこn 塞ぎ込 鬱ぎ込"
"ふさぎこm 塞ぎ込 鬱ぎ込"
"ふさw 相応"
"ふさu 相応"
"ふさt 相応"
"ふさo 相応"
"ふさi 塞 相応 鬱"
"ふさg 塞 鬱"
"ふさc 相応"
"ふけゆk 更け行"
"ふけこn 老け込"
"ふけこm 老け込"
"ふけt 耽"
"ふけr 耽"
"ふけn 耽"
"ふけc 耽"
"ふくろばr 袋貼"
"ふくろとj 袋綴"
"ふくろだたk 袋叩"
"ふくれあg 膨れ上"
"ふくぶくs 福々"
"ふくざつすg 複雑過"
"ふくy 膨 脹"
"ふくs 服 復 伏 覆"
"ふくr 膨 脹"
"ふくn 含"
"ふくm 含"
"ふきわたt 吹き渡"
"ふきわたr 吹き渡"
"ふきわたn 吹き渡"
"ふきわたc 吹き渡"
"ふきよs 吹き寄"
"ふきやn 吹き止"
"ふきやm 吹き止"
"ふきぬk 吹き抜 吹抜"
"ふきながs 吹き流"
"ふきなr 吹き鳴"
"ふきとおs 吹き通"
"ふきとt 拭き取"
"ふきとr 拭き取"
"ふきとn 吹き飛 拭き取"
"ふきとc 拭き取"
"ふきとb 吹き飛"
"ふきでz 吹き出 噴き出"
"ふきでy 吹き出 噴き出"
"ふきでt 吹き出 噴き出"
"ふきでs 吹き出 噴き出"
"ふきでr 吹き出 噴き出"
"ふきでn 吹き出 噴き出"
"ふきでm 吹き出 噴き出"
"ふきでk 吹き出 噴き出"
"ふきでc 吹き出 噴き出"
"ふきつづk 吹き続"
"ふきつk 吹き付"
"ふきちr 吹き散"
"ふきだまt 吹き溜"
"ふきだまr 吹き溜"
"ふきだまn 吹き溜"
"ふきだまc 吹き溜"
"ふきだt 吹き溜"
"ふきだs 吹き出 噴き出"
"ふきだr 吹き溜"
"ふきだn 吹き溜"
"ふきだm 吹き溜"
"ふきだc 吹き溜"
"ふきすさn 吹き荒"
"ふきすさb 吹き荒"
"ふきさらs 吹き曝"
"ふきさm 吹き冷"
"ふきこn 吹き込"
"ふきこm 吹き込"
"ふきけs 吹き消 拭き消"
"ふききよm 拭き清"
"ふきかえs 吹き返"
"ふきかk 吹き掛"
"ふきかe 吹替 吹き替 葺き替"
"ふきおr 吹き下 葺き下"
"ふきあr 吹き荒"
"ふきあg 吹き上"
"ふがひなs 腑甲斐無"
"ふがひなk 腑甲斐無"
"ふがひなi 腑甲斐無"
"ふがひなg 腑甲斐無"
"ふがいなs 腑甲斐無"
"ふがいなk 腑甲斐無"
"ふがいなi 腑甲斐無"
"ふがいなg 腑甲斐無"
"ふかよm 深読"
"ふかなさk 深情"
"ふかすg 深過"
"ふかおi 深追"
"ふかいr 深入"
"ふかs 深 蒸 更 潭"
"ふかm 深 潭"
"ふかk 深 潭"
"ふかi 深 潭"
"ふかg 深 潭"
"ふえふk 笛吹"
"ふうじこn 封じ込"
"ふうじこm 封じ込"
"ふうしゃがたm 風車固"
"ふうぎt 封切"
"ふうがわr 風変"
"ふうz 封"
"ふうs 諷 風"
"ふうn 風"
"ふうj 封"
"ふうd 風"
"ふいr 不入"
"ふあんていd 不安定"
"ふy 増 殖"
"ふt 振 降"
"ふs 付 伏 臥 附 匐 賦"
"ふr 振 触 降 経 觝 觸 經 狂"
"ふn 踏 蹈 履 振 降 践"
"ふm 踏 履 践 蹈"
"ふk 吹 拭 噴 老 更 葺 深"
"ふi 吹 拭 噴 葺"
"ふe 増 殖"
"ふc 振 降"
"びんぼうくさs 貧乏臭"
"びんぼうくさk 貧乏臭"
"びんぼうくさi 貧乏臭"
"びんぼうくさg 貧乏臭"
"びんじょうねあg 便乗値上"
"びろs 広"
"びろk 広"
"びろi 広"
"びろg 広"
"びらk 開"
"びょうよm 秒読"
"びょううt 鋲打"
"びょううc 鋲打"
"びみょうn 微妙"
"びびt ビビ"
"びびr ビビ"
"びびn ビビ"
"びびc ビビ"
"びたt 浸"
"びたr 浸"
"びたn 浸"
"びたc 浸"
"びk 引 弾"
"びi 引 弾"
"ひんよk 品良"
"ひんむk 引ん剥"
"ひんむi 引ん剥"
"ひんs 瀕 貧"
"ひわたr 火渡"
"ひわr 干割"
"ひろせどおr 広瀬通"
"ひろすg 広過"
"ひろいよm 拾い読"
"ひろいだs 拾い出"
"ひろいあつm 拾い集"
"ひろいあg 拾い上"
"ひろy 広"
"ひろw 拾 広"
"ひろu 拾 広"
"ひろt 拾 広"
"ひろs 広 廣 拾 博 宏 弘"
"ひろo 拾 広"
"ひろm 広 弘 廣 博 宏"
"ひろk 広 宏 博 廣 拾 弘"
"ひろi 広 拾 博 宏 弘 廣"
"ひろg 広 拡 展 廣 擴 博 宏 弘 拾"
"ひろe 拾 広"
"ひろc 拾 広"
"ひれふs 平伏"
"ひるやすm 昼休"
"ひるすg 昼過"
"ひるさがr 昼下"
"ひるさg 昼下"
"ひるがえt 翻 飜"
"ひるがえs 翻 飜"
"ひるがえr 翻 飜"
"ひるがえn 翻 飜"
"ひるがえc 翻 飜"
"ひるn 怯"
"ひるm 怯"
"ひりだs 放り出"
"ひらめk 閃"
"ひらめi 閃"
"ひらとj 平綴"
"ひらづm 平積"
"ひらきなおt 開き直"
"ひらきなおr 開き直"
"ひらきなおn 開き直"
"ひらきなおc 開き直"
"ひらあやまr 平謝"
"ひらt 平"
"ひらk 開 拓 啓"
"ひらi 開 拓 啓"
"ひらb 平"
"ひよわs ひ弱"
"ひよわk ひ弱"
"ひよわi ひ弱"
"ひよわg ひ弱"
"ひよt 日和"
"ひよr 日和"
"ひよn 日和"
"ひよc 日和"
"ひょうよm 票読"
"ひょうへんs 豹変"
"ひょうばんわるs 評判悪"
"ひょうばんわるk 評判悪"
"ひょうばんわるi 評判悪"
"ひょうばんわるg 評判悪"
"ひょうばんよs 評判良"
"ひょうばんよk 評判良"
"ひょうばんよi 評判良"
"ひょうばんよg 評判良"
"ひょうばんどおr 評判通"
"ひょうじょうゆたk 表情豊"
"ひょうじs 表示"
"ひょうしぬk 拍子抜"
"ひょうぐm 表組"
"ひょうs 表 評"
"ひやとi 日雇"
"ひやかs 素見"
"ひやy 冷"
"ひやs 冷"
"ひやk 日焼 冷"
"ひゃっぽゆずt 百歩譲"
"ひゃっぽゆずr 百歩譲"
"ひゃっぽゆずc 百歩譲"
"ひゃくしょうよm 百姓読"
"ひもとk 紐解 繙"
"ひもとi 繙 紐解"
"ひまつぶs 暇潰"
"ひまs 日増 暇 閑 隙"
"ひまn 閑 隙"
"ひまd 閑 隙"
"ひふk 火吹"
"ひびわr 罅割 ひび割"
"ひびきわたt 響き渡"
"ひびきわたr 響き渡"
"ひびきわたn 響き渡"
"ひびきわたc 響き渡"
"ひびきあw 響き合"
"ひびきあu 響き合"
"ひびきあt 響き合"
"ひびきあo 響き合"
"ひびきあi 響き合"
"ひびきあe 響き合"
"ひびきあc 響き合"
"ひびk 響"
"ひびi 響"
"ひのいr 日の入"
"ひのb 日延"
"ひねりつぶs 捻り潰"
"ひねりだs 捻り出"
"ひねくりまわs 捻くり回"
"ひねt 捻 撚 陳 拈 捫"
"ひねr 捻 撚 陳 拈 捫"
"ひねn 捻 撚 陳 拈 捫"
"ひねk 捻"
"ひねc 捻 撚 陳 拈 捫"
"ひにくt 皮肉"
"ひにくr 皮肉"
"ひにくn 皮肉"
"ひにくc 皮肉"
"ひなあそb 雛遊"
"ひなb 鄙"
"ひどu 酷 非道"
"ひどs 酷 非道"
"ひどr 日取"
"ひどk 酷 非道"
"ひどi 酷 非道"
"ひどg 酷 非道"
"ひとりよg 独り善"
"ひとりだt 独り立"
"ひとりじm 一人占 独り占"
"ひとりごt 独り言"
"ひとりごc 独り言"
"ひとりぐr 一人暮"
"ひとりあるk 一人歩"
"ひとりあt 一人当"
"ひとりk 一人"
"ひとよs 人寄"
"ひとよn 人呼"
"ひとやすm 一休"
"ひとやくかw 一役買"
"ひとやくかu 一役買"
"ひとやくかt 一役買"
"ひとやくかo 一役買"
"ひとやくかi 一役買"
"ひとやくかe 一役買"
"ひとやくかc 一役買"
"ひとめぼr 一目惚"
"ひとみしr 人見知"
"ひとまわr 一回"
"ひとまかs 人任"
"ひとまt 人待"
"ひとふでがk 一筆書"
"ひとひねr 一捻"
"ひとばらi 人払"
"ひとはだぬi 一肌脱"
"ひとはだぬg 一肌脱"
"ひとはたらk 一働"
"ひとはしr 一走"
"ひとねむr 一眠"
"ひとねいr 一寝入"
"ひとにぎr 一握"
"ひとなつk 人懐"
"ひとなm 人並"
"ひとどおr 人通"
"ひととおr 一通"
"ひととうr 一通"
"ひとづきあi 人付き合"
"ひとづかi 人使"
"ひとつづk 一続"
"ひとちがi 人違"
"ひとだすk 人助"
"ひとだかr 人集"
"ひとたまr 一溜"
"ひとたたk 一叩"
"ひとたm 一溜"
"ひとそろe 一揃"
"ひとずk 人好"
"ひとしr 人知"
"ひとさわg 人騒 一騒"
"ひとさらi 人攫"
"ひとさがs 人探 人捜"
"ひとごろs 人殺"
"ひとごm 人込 人混"
"ひとこいs 人恋"
"ひとくぎr 一区切"
"ひとくi 人喰 人食"
"ひとぎらi 人嫌"
"ひとぎk 人聞"
"ひときr 一切"
"ひとがんばr 一頑張"
"ひとかかe 一抱"
"ひとかi 人買"
"ひとおもi 一思"
"ひとえn 偏"
"ひといきいr 一息入"
"ひとあじちがw 一味違"
"ひとあじちがu 一味違"
"ひとあじちがt 一味違"
"ひとあじちがo 一味違"
"ひとあじちがi 一味違"
"ひとあじちがe 一味違"
"ひとあじちがc 一味違"
"ひとあしはやk 一足早"
"ひとあしはやi 一足早"
"ひとあしちがi 一足違"
"ひとあしおそk 一足遅"
"ひとあしおそi 一足遅"
"ひとあt 一当"
"ひとあr 一荒"
"ひとt 一 壱 弌 壹 １ 1"
"ひとs 等 均 斉"
"ひとr 独 孤 獨"
"ひとm 一"
"ひでt 日照"
"ひでr 日照"
"ひでn 日照"
"ひでc 日照"
"ひづk 日付"
"ひつようn 必要"
"ひつk 火付"
"ひっぱりまわs 引っ張り回"
"ひっぱりだs 引っ張り出 引っぱり出"
"ひっぱりこn 引っ張り込"
"ひっぱりこm 引っ張り込"
"ひっぱりあg 引っ張り上"
"ひっぱたk 引っ叩"
"ひっぱたi 引っ叩"
"ひっぱt 引っ張 引張"
"ひっぱr 引っ張 引張"
"ひっぱn 引っ張 引張"
"ひっぱg 引っ剥"
"ひっぱc 引っ張 引張"
"ひっとらe 引っ捕"
"ひっつk 引っ付"
"ひっつi 引っ付"
"ひったくt 引っ手繰"
"ひったくr 引っ手繰"
"ひったくn 引っ手繰"
"ひったくc 引っ手繰"
"ひったt 引っ立"
"ひっさらw 引っ攫"
"ひっさらu 引っ攫"
"ひっさらt 引っ攫"
"ひっさらo 引っ攫"
"ひっさらi 引っ攫"
"ひっさらe 引っ攫"
"ひっさらc 引っ攫"
"ひっさg 提 引っ提 引っ下"
"ひっこぬk 引っこ抜"
"ひっこぬi 引っこ抜"
"ひっこしづかr 引越疲"
"ひっこs 引っ越 引越"
"ひっこn 引っ込 引込"
"ひっこm 引っ込 引込"
"ひっくるm 引っ括"
"ひっくりかえt 引っくり返 ひっくり返 引っ繰り返"
"ひっくりかえs 引っくり返 ひっくり返 引っ繰り返"
"ひっくりかえr 引っくり返 ひっくり返 引っ繰り返"
"ひっくりかえn 引っくり返 ひっくり返 引っ繰り返"
"ひっくりかえc 引っくり返 ひっくり返 引っ繰り返"
"ひっくくt 引っ括"
"ひっくくr 引っ括"
"ひっくくn 引っ括"
"ひっくくc 引っ括"
"ひっきりなs 引っ切り無"
"ひっきt 引っ切"
"ひっきr 引っ切"
"ひっきn 引っ切"
"ひっきc 引っ切"
"ひっかぶt 引っ被"
"ひっかぶr 引っ被"
"ひっかぶn 引っ被"
"ひっかぶc 引っ被"
"ひっかかt 引掛 引っ掛"
"ひっかかr 引っ掛 引掛"
"ひっかかn 引っ掛 引掛"
"ひっかかc 引っ掛 引掛"
"ひっかえs 引っ返"
"ひっかk 引っ掛 引っ掻"
"ひっかi 引っ掻"
"ひっかe 引っ替"
"ひっs 筆 必"
"ひだるs 饑"
"ひだるk 饑"
"ひだるi 饑"
"ひだるg 饑"
"ひだりよt 左四"
"ひだりよr 左寄"
"ひだりむk 左向"
"ひだりまわr 左回"
"ひだりまk 左巻"
"ひだりきk 左利"
"ひだりs 左"
"ひだまr 日溜"
"ひだt 肥立"
"ひだs 養"
"ひだm 日溜"
"ひたはしt 直走"
"ひたはしr 直走"
"ひたはしn 直走"
"ひたはしc 直走"
"ひたかくs 直隠"
"ひたt 浸"
"ひたs 浸 漬"
"ひたr 浸"
"ひたn 浸"
"ひたc 浸"
"ひそy 密 秘"
"ひそn 潜 潛 濳 顰"
"ひそm 潜 顰 潛 濳"
"ひそk 密 秘 祕"
"ひぜm 火攻 火責"
"ひずn 歪"
"ひずm 歪"
"ひじょうn 非常"
"ひじかk 肘掛"
"ひしゃi 拉"
"ひしゃg 拉"
"ひしめk 犇"
"ひしめi 犇"
"ひしm 犇"
"ひしi 拉 柆"
"ひしg 拉 柆"
"ひざまづk 跪"
"ひざまづi 跪"
"ひざまずk 跪"
"ひざまずi 跪"
"ひざかk 膝掛"
"ひざs 日射 日差"
"ひさしぶr 久し振"
"ひさかたぶr 久方振"
"ひさs 久 尚"
"ひさi 鬻 販"
"ひさg 鬻 販 拉 提"
"ひけs 火消"
"ひぐr 日暮"
"ひくすg 低過"
"ひくs 低"
"ひくm 低"
"ひくk 低"
"ひくi 低"
"ひくg 低"
"ひきわたs 引き渡 引渡"
"ひきわr 碾き割 挽き割"
"ひきわk 引き分 引分"
"ひきよs 引き寄"
"ひきもどs 引き戻"
"ひきむすn 引き結"
"ひきむすb 引き結"
"ひきまわs 引き回"
"ひきはらw 引き払"
"ひきはらu 引き払"
"ひきはらt 引き払"
"ひきはらo 引き払"
"ひきはらi 引き払"
"ひきはらe 引き払"
"ひきはらc 引き払"
"ひきはなs 引き離"
"ひきはi 引き剥"
"ひきはg 引き剥"
"ひきのb 引き伸 引き延"
"ひきぬk 引き抜"
"ひきぬi 引き抜"
"ひきにg 轢き逃"
"ひきなおs 引き直"
"ひきなr 弾き鳴"
"ひきとおs 引き通"
"ひきとt 引き取 引取"
"ひきとr 引き取 引取"
"ひきとn 引き取 引取"
"ひきとm 引き止"
"ひきとc 引き取 引取"
"ひきつづk 引き続 引続"
"ひきつづi 引き続 引続"
"ひきつt 引き攣"
"ひきつr 引き連 引き攣"
"ひきつn 引き攣"
"ひきつk 引き付 引付"
"ひきつi 引き継 引継"
"ひきつg 引き継 引継"
"ひきつc 引き攣"
"ひきちぎt 引き千切"
"ひきちぎr 引き千切"
"ひきちぎn 引き千切"
"ひきちぎc 引き千切"
"ひきちがi 引き違 引違"
"ひきだs 引き出 引出 弾き出"
"ひきたおs 引き倒 引倒"
"ひきたt 引き立 引立"
"ひきたc 引き立 引立"
"ひきずりまわs 引きずり回 引き摺り回"
"ひきずりだs 引きずり出 引き摺り出"
"ひきずりこn 引きずり込 引き摺り込"
"ひきずりこm 引きずり込 引き摺り込"
"ひきずりおr 引きずり下"
"ひきずt 引き摺"
"ひきずr 引き摺"
"ひきずn 引き摺"
"ひきずc 引き摺"
"ひきしめr 引き締め"
"ひきしぼt 引き絞"
"ひきしぼr 引き絞"
"ひきしぼn 引き絞"
"ひきしぼc 引き絞"
"ひきしm 引き締 引締"
"ひきさt 引き去"
"ひきさr 引き去"
"ひきさn 引き去"
"ひきさk 引き裂"
"ひきさi 引き裂"
"ひきさg 引き下 引下"
"ひきさc 引き去"
"ひきころs 轢き殺"
"ひきこn 引き込"
"ひきこm 引き込 引込"
"ひきくらb 引き比"
"ひきがたt 弾き語"
"ひきがたr 弾き語"
"ひきがたn 弾き語"
"ひきがたc 弾き語"
"ひきかえs 引き返"
"ひきかe 引き換 引き替 引換 引替"
"ひきおとs 引き落"
"ひきおこs 引き起 引き起こ"
"ひきおr 引き下"
"ひきおk 引き起 惹き起"
"ひきうつs 引き写"
"ひきうk 引き受 引受"
"ひきいr 引き入"
"ひきあわs 引き合"
"ひきあw 引き合"
"ひきあu 引き合"
"ひきあt 引き当 引当 引き合"
"ひきあo 引き合"
"ひきあi 引き合 引合"
"ひきあg 引き上 引き揚 引上"
"ひきあe 引き合"
"ひきあc 引き合"
"ひきw 率"
"ひきi 率"
"ひがしむk 東向"
"ひがえr 日帰"
"ひがw 日替 日変"
"ひがn 僻"
"ひがm 僻"
"ひがk 日掛"
"ひかりかがやk 光り輝 光輝"
"ひかりかがやi 光り輝 光輝"
"ひからb 干涸 乾涸"
"ひかt 光"
"ひかr 光"
"ひかn 光"
"ひかe 控"
"ひかc 光"
"ひえこn 冷え込"
"ひえこm 冷え込"
"ひえきt 冷え切"
"ひえきr 冷え切"
"ひえきn 冷え切"
"ひえきc 冷え切"
"ひいr 火入"
"ひいd 秀"
"ひあそb 火遊"
"ひあg 干上 乾上"
"ひy 冷"
"ひt 引 放"
"ひs 比 秘 引"
"ひr 干 放"
"ひp 引"
"ひn 陳 非 冷 放"
"ひm 秘 祕"
"ひk 引 弾 挽 退 碾 轢 曳 牽 索 惹 魅 彈"
"ひi 引 弾 挽 索 彈 退 碾 轢 曳 牽 惹 魅"
"ひe 冷"
"ひc 放"
"ぱらw 払"
"ぱらu 払"
"ぱらt 払"
"ぱらo 払"
"ぱらi 払"
"ぱらe 払"
"ぱらc 払"
"ぱにくt パニク"
"ぱにくr パニク"
"ぱにくn パニク"
"ぱにくc パニク"
"ぱにk パニ"
"ぱなs 放"
"ぱしt 走"
"ぱしr 走"
"ぱしn 走"
"ぱしc 走"
"ぱくt パク"
"ぱくr パク"
"ぱくn パク"
"ぱくc パク"
"ぱt 張"
"ぱr 張"
"ぱn 張"
"ぱc 張"
"ばんごうづk 番号付"
"ばんくるw 番狂"
"ばれz バレ"
"ばれy バレ"
"ばれt バレ"
"ばれs バレ"
"ばれr バレ"
"ばれn バレ"
"ばれm バレ"
"ばれk バレ"
"ばれc バレ"
"ばらまk 散蒔 ばら撒"
"ばらまi ばら撒 散蒔"
"ばらs バラ"
"ばらk 散"
"ばらi 払 祓 拂"
"ばやs 早"
"ばやk 早"
"ばやi 早"
"ばやg 早"
"ばなしs 話"
"ばなr 離"
"ばつぐんd 抜群"
"ばっs 罰"
"ばちがi 場違"
"ばちあたr 罰当"
"ばちあt 罰当"
"ばたらk 働"
"ばたくさs バタ臭"
"ばたくさk バタ臭"
"ばたくさi バタ臭"
"ばたくさg バタ臭"
"ばしt 走"
"ばしr 走"
"ばしn 走"
"ばしc 走"
"ばさn 挟"
"ばさm 挟"
"ばくs 縛"
"ばかよb 馬鹿呼"
"ばかばかs 馬鹿馬鹿 バカバカ"
"ばかたかs 馬鹿高 バカ高"
"ばかたかk 馬鹿高 バカ高"
"ばかたかi 馬鹿高 バカ高"
"ばかたかg 馬鹿高 バカ高"
"ばかくさs 馬鹿臭"
"ばかくさk 馬鹿臭"
"ばかくさi 馬鹿臭"
"ばかくさg 馬鹿臭"
"ばかt 馬鹿"
"ばかs 魅"
"ばかr 許 馬鹿"
"ばかg 馬鹿"
"ばいちかs 倍近"
"ばいちかk 倍近"
"ばいちかi 倍近"
"ばいちかg 倍近"
"ばいs 倍 陪"
"ばあいわk 場合分"
"ばあt 場当"
"ばt 張 貼"
"ばs 馳"
"ばr 張 晴 貼"
"ばn 張 貼"
"ばk 化"
"ばi 這"
"ばc 張 貼"
"はんびらk 半開"
"はんとしちかs 半年近"
"はんとしちかk 半年近"
"はんとしちかi 半年近"
"はんとしちかg 半年近"
"はんていがt 判定勝"
"はんていがc 判定勝"
"はんだづk 半田付"
"はんだずk 半田付"
"はんそくまk 反則負"
"はんごろs 半殺"
"はんぐm 版組"
"はんかくさs 半可臭"
"はんかくさk 半可臭"
"はんかくさi 半可臭"
"はんかくさg 半可臭"
"はんえいs 反映"
"はんz 判"
"はんs 反"
"はんj 判"
"はわたr 刃渡"
"はれわたt 晴れ渡"
"はれわたr 晴れ渡"
"はれわたn 晴れ渡"
"はれわたc 晴れ渡"
"はればr 晴れ晴"
"はれあg 腫れ上"
"はるやすm 春休"
"はるm 春"
"はるk 遥 遼 遙"
"はりわたs 張り渡"
"はりめぐr 張り巡"
"はりまわs 張り回"
"はりつけr 貼り付け"
"はりつm 張り詰"
"はりつk 貼り付 張り付"
"はりつi 張り付 貼り付"
"はりだs 張り出 貼り出"
"はりたおs 張り倒 撲り倒"
"はりさs 針刺"
"はりさk 張り裂"
"はりこn 張り込 貼り込 はり込"
"はりこm 張り込 貼り込 はり込"
"はりきt 張り切"
"はりきr 張り切"
"はりきn 張り切"
"はりきc 張り切"
"はりかe 貼り替 張り替"
"はりあわs 貼り合"
"はりあw 貼り合 張り合"
"はりあu 張り合"
"はりあt 張り合"
"はりあo 張り合"
"はりあi 張合 張り合"
"はりあg 張り上"
"はりあe 張り合"
"はりあc 張り合"
"はらへt 腹減"
"はらへr 腹減"
"はらへn 腹減"
"はらへc 腹減"
"はらばi 腹這"
"はらちがi 腹違"
"はらだt 腹立"
"はらたt 腹立"
"はらたc 腹立"
"はらごしらe 腹拵"
"はらぐろs 腹黒"
"はらぐろk 腹黒"
"はらぐろi 腹黒"
"はらぐろg 腹黒"
"はらきr 腹切"
"はらがまe 腹構"
"はらいわたs 払い渡"
"はらいもどs 払い戻 払戻"
"はらいのk 払い除"
"はらいだs 払出"
"はらいさg 払い下 払下"
"はらいこn 払い込 払込"
"はらいこm 払い込 払込"
"はらいきよm 祓い清"
"はらいs 腹癒"
"はらw 払 拂 祓 掃 禳"
"はらu 払 祓 掃 禳 拂"
"はらt 払 拂 祓 掃 禳"
"はらo 払 拂 祓 掃 禳"
"はらn 孕"
"はらm 孕"
"はらi 払 祓 拂 掃 禳"
"はらh 掃 払 祓 拂"
"はらe 払 拂 祓 掃 禳"
"はらc 払 祓 掃 禳 拂"
"はよu 早"
"はゆs 映"
"はゆk 映"
"はゆi 映"
"はゆg 映"
"はやりたt 逸り立"
"はやだs 早出"
"はやすg 早過 速過"
"はやしたt 囃し立"
"はやざk 早咲"
"はやぐi 早食"
"はやがわr 早変"
"はやがえr 早帰"
"はやおくr 早送"
"はやおk 早起"
"はやうt 早打"
"はやいものがt 早い者勝"
"はやt 流行 逸 早"
"はやs 速 早 囃 疾 捷"
"はやr 流行 逸 早"
"はやn 流行 逸 早"
"はやm 早 速"
"はやk 早 速 疾 捷"
"はやi 早 速 疾 捷"
"はやg 早 速 疾 捷"
"はやc 流行 逸 早"
"はもt ハモ"
"はもr ハモ"
"はもn ハモ"
"はもc ハモ"
"はめこn 嵌め込"
"はめこm 嵌め込"
"はめz ハメ"
"はめy ハメ"
"はめt ハメ"
"はめs ハメ"
"はめr ハメ"
"はめn ハメ"
"はめm ハメ"
"はめk ハメ"
"はめc ハメ"
"はみでz はみ出 食み出"
"はみでy はみ出 食み出"
"はみでt はみ出 食み出"
"はみでs はみ出 食み出"
"はみでr はみ出 食み出"
"はみでn はみ出 食み出"
"はみでm はみ出 食み出"
"はみでk はみ出 食み出"
"はみでc はみ出 食み出"
"はみだs はみ出 食み出"
"はみがk 歯磨"
"はまべちかs 浜辺近"
"はまべちかk 浜辺近"
"はまべちかi 浜辺近"
"はまべちかg 浜辺近"
"はまちかs 浜近"
"はまちかk 浜近"
"はまちかi 浜近"
"はまちかg 浜近"
"はまt 嵌 填"
"はまr 嵌 填"
"はまn 嵌 填"
"はまc 嵌 填"
"はべt 侍"
"はべr 侍"
"はべn 侍"
"はべc 侍"
"はぶr 羽振"
"はぶk 省 羽振"
"はぶi 省"
"はふr 放"
"はびこt 蔓延"
"はびこr 蔓延"
"はびこn 蔓延"
"はびこc 蔓延"
"はばよs 幅寄"
"はばひろs 幅広"
"はばひろk 幅広"
"はばひろi 幅広"
"はばひろg 幅広"
"はばたk 羽搏 羽撃"
"はばたi 羽搏 羽撃"
"はばかt 憚"
"はばかr 憚"
"はばかn 憚"
"はばかc 憚"
"はばn 阻 難"
"はばm 阻 難"
"はねまわt 跳ね回"
"はねまわr 跳ね回"
"はねまわn 跳ね回"
"はねまわc 跳ね回"
"はねのk 撥ね除"
"はねっかえr 跳ねっ返"
"はねかえt 跳ね返"
"はねかえs 跳ね返 撥ね返"
"はねかえr 跳ね返"
"はねかえn 跳ね返"
"はねかえc 跳ね返"
"はねおk 跳ね起"
"はねあg 跳ね上"
"はぬk 歯脱"
"はなればなr 離れ離"
"はならb 歯並"
"はなもt 鼻持"
"はなびe 花冷"
"はなひらk 花開"
"はなひらi 花開"
"はなばなs 華々 花々 華華"
"はなはだs 甚"
"はなはd 甚"
"はなづm 鼻詰"
"はなつまm 鼻抓"
"はなじろn 鼻白"
"はなじろm 鼻白"
"はなしつづk 話し続"
"はなしだs 話し出 話出"
"はなしずk 話好"
"はなしこn 話し込"
"はなしこm 話し込"
"はなしがi 放し飼"
"はなしかk 話し掛"
"はなしあw 話し合"
"はなしあu 話し合"
"はなしあt 話し合"
"はなしあo 話し合"
"はなしあi 話し合"
"はなしあe 話し合"
"はなしあc 話し合"
"はなしs 話"
"はなざかr 花盛"
"はなさk 花咲"
"はなぐもr 花曇"
"はなうr 花売"
"はなy 華 花"
"はなt 放"
"はなs 話 離 放"
"はなr 離 放"
"はなc 放"
"はどm 歯止"
"はではでs 派手派手"
"はてしなs 果てし無"
"はてしなk 果てし無"
"はてしなi 果てし無"
"はてs 果て"
"はづs 外"
"はづr 外"
"はづn 弾 勢 彈"
"はづm 弾 勢 彈"
"はづk 辱 恥"
"はつのr 初乗"
"はつすべr 初滑"
"はつかおあw 初顔合"
"はつうr 初売"
"はっぽうふさg 八方塞"
"はっせいs 発生"
"はっこうs 発行"
"はっきs 発揮"
"はっs 発 發"
"はっp 葉っ"
"はちきr はち切"
"はちうe 鉢植"
"はちあw 鉢合"
"はだざわr 肌触"
"はだざむs 肌寒"
"はだざむk 肌寒"
"はだざむi 肌寒"
"はだざむg 肌寒"
"はださむs 肌寒"
"はださむk 肌寒"
"はださむi 肌寒"
"はださむg 肌寒"
"はだかk 肌掛"
"はだあi 肌合"
"はだk 開"
"はたらきすg 働き過"
"はたらきかk 働き掛"
"はたらk 働"
"はたらi 働"
"はたふr 旗振"
"はたたk 羽撃"
"はたたi 羽撃"
"はたけちがi 畑違"
"はたきこn 叩き込"
"はたきこm 叩き込"
"はたあg 旗揚"
"はたs 果"
"はたk 叩"
"はたi 叩"
"はせさんz 馳せ参"
"はせさんj 馳せ参"
"はせいs 派生"
"はずかしm 辱"
"はずかs 恥 恥ずか"
"はずs 外"
"はずr 外"
"はずn 弾 勢 彈"
"はずm 弾 勢 機 彈"
"はずk 恥"
"はすむかi 斜向"
"はすうきりあg 端数切上"
"はじけとn 弾け飛"
"はじけとb 弾け飛"
"はじきとb 弾き飛"
"はじきだs 弾き出"
"はじきかえs 弾き返"
"はじいt 恥じ入"
"はじいr 恥じ入"
"はじいn 恥じ入"
"はじいc 恥じ入"
"はじm 初 始 創 甫"
"はじk 弾"
"はじi 弾"
"はしをr 端折"
"はしわたs 橋渡"
"はしりまわt 走り回"
"はしりまわr 走り回"
"はしりまわn 走り回"
"はしりまわc 走り回"
"はしりぬk 走り抜"
"はしりぬi 走り抜"
"はしりつづk 走り続"
"はしりだs 走り出"
"はしりすg 走り過"
"はしりさt 走り去"
"はしりさr 走り去"
"はしりさn 走り去"
"はしりさc 走り去"
"はしりこn 走り込"
"はしりこm 走り込"
"はしりがk 走り書"
"はしょt 端折"
"はしょr 端折"
"はしょn 端折"
"はしょc 端折"
"はしゃi 燥"
"はしゃg 燥"
"はしたs 端"
"はしたn 端"
"はしたd 端"
"はしぞm 箸初"
"はしおt 端折"
"はしおr 端折"
"はしおn 端折"
"はしおk 箸置"
"はしおc 端折"
"はしt 走 端 奔 赱 迸"
"はしr 走 迸 奔 赱"
"はしn 走 迸 奔 赱"
"はしc 走 迸 奔 赱"
"はざわr 歯触"
"はさみこn 挟み込"
"はさみこm 挟み込"
"はさみうt 挟み撃"
"はさみうc 挟み撃"
"はさn 挟 夾 挾 剪 鋏"
"はさm 挟 夾 剪 鋏 挾"
"はごたe 歯応"
"はこびだs 運び出"
"はこびこn 運び込"
"はこびこm 運び込"
"はこいr 箱入"
"はこn 運"
"はこb 運"
"はげましあw 励まし合"
"はげましあu 励まし合"
"はげましあt 励まし合"
"はげましあo 励まし合"
"はげましあi 励まし合"
"はげましあe 励まし合"
"はげましあc 励まし合"
"はげまs 励ま"
"はげおt 剥げ落"
"はげおc 剥げ落"
"はげあg 禿げ上"
"はげs 激 烈 劇"
"はげn 励 勵"
"はげm 励 勵"
"はぐくn 育 毓"
"はぐくm 育 毓"
"はぐr 逸"
"はくおs 箔押"
"はくs 博"
"はぎとt 剥ぎ取"
"はぎとr 剥ぎ取"
"はぎとn 剥ぎ取"
"はぎとc 剥ぎ取"
"はぎしr 歯軋"
"はぎあわs 接ぎ合"
"はぎあw 接ぎ合"
"はぎr 歯切 端切"
"はきもどs 吐き戻"
"はきちがe 履き違"
"はきちr 吐き散"
"はきだs 掃き出 吐き出 はき出"
"はきだi 掃き出"
"はきすt 吐き捨"
"はきさしもどs 破棄差戻"
"はききよm 掃き清"
"はがれおt 剥がれ落"
"はがれおc 剥がれ落"
"はがゆs 歯痒 齒痒"
"はがゆk 歯痒 齒痒"
"はがゆi 歯痒 齒痒"
"はがゆg 歯痒 齒痒"
"はがs 剥"
"はがr 剥"
"はがi 羽交"
"はかりしr 計り知"
"はかりかn 計り兼"
"はかりうr 量り売"
"はかまいr 墓参"
"はかばかs 捗々"
"はかなs 儚 果敢無 果無"
"はかなn 果無"
"はかなm 果無"
"はかなk 儚 果敢無 果無"
"はかなi 儚 果敢無 果無"
"はかなg 儚 果敢無 果無"
"はかどt 捗"
"はかどr 捗"
"はかどn 捗"
"はかどc 捗"
"はかt 図 測 計 諮 謀 圖 量 企"
"はかr 図 測 計 量 諮 謀 企 圖"
"はかn 図 測 計 量 諮 謀 企 圖"
"はかc 図 測 計 量 諮 謀 企 圖"
"はおt 羽織"
"はおr 羽織"
"はおn 羽織"
"はおc 羽織"
"はえぬk 生え抜"
"はえそろw 生え揃"
"はえそろu 生え揃"
"はえそろt 生え揃"
"はえそろo 生え揃"
"はえそろi 生え揃"
"はえそろe 生え揃"
"はえそろc 生え揃"
"はえかわt 生え変"
"はえかわr 生え変"
"はえかわn 生え変"
"はえかわc 生え変"
"はえかw 生え変"
"はえe 早 速"
"はいりこn 入り込"
"はいりこm 入り込"
"はいよt 這い寄"
"はいよr 這い寄"
"はいよn 這い寄"
"はいよc 這い寄"
"はいまわt 這い回"
"はいまわr 這い回"
"はいまわn 這い回"
"はいまわc 這い回"
"はいのぼt 這い上 這い登"
"はいのぼr 這い上 這い登"
"はいのぼn 這い上 這い登"
"はいのぼc 這い上 這い登"
"はいでz 這い出"
"はいでy 這い出"
"はいでt 這い出"
"はいでs 這い出"
"はいでr 這い出"
"はいでn 這い出"
"はいでm 這い出"
"はいでc 這い出"
"はいつくばt 這い蹲"
"はいつくばr 這い蹲"
"はいつくばn 這い蹲"
"はいつくばc 這い蹲"
"はいちがe 配置換"
"はいだs 這い出"
"はいずりまわt 這いずり回"
"はいずりまわr 這いずり回"
"はいずりまわn 這いずり回"
"はいずりまわc 這いずり回"
"はいこn 這い込"
"はいこm 這い込"
"はいあg 這い上"
"はいt 入 這入"
"はいs 排 廃 拝 配"
"はいr 入 這入"
"はいn 入 這入"
"はいc 入 這入"
"はあくd 把握"
"はz 恥 爆 羞 耻"
"はy 生 栄 映 早 榮"
"はw 這 歯 齒 匍"
"はu 這 匍"
"はt 果 貼 張 這 匍"
"はs 馳 派"
"はr 貼 張 晴 腫 脹 霽 膨"
"はo 這 匍"
"はn 跳 撥 食 刎 貼 張"
"はm 食 嵌 填"
"はk 掃 吐 捌 履 穿 帚 菷 刷 佩 着 帶"
"はj 恥 羞 愧 慙 耻"
"はi 吐 履 這 掃 匍 穿 帚 菷 刷 佩 剥 矧"
"はg 剥 禿 矧"
"はe 生 映 栄 榮 暎 這 匍"
"はd 恥 愧 慙 羞 耻"
"はc 這 匍 貼 張"
"はb 羽"
"のろけt 惚気"
"のろけr 惚気"
"のろけn 惚気"
"のろけc 惚気"
"のろくさs 鈍臭"
"のろくさk 鈍臭"
"のろくさi 鈍臭"
"のろくさg 鈍臭"
"のろw 呪 詛 咒"
"のろu 呪 詛 咒"
"のろt 呪 詛 咒"
"のろs 呪 鈍"
"のろo 呪 詛 咒"
"のろk 呪 鈍"
"のろi 呪 鈍 詛 咒"
"のろg 呪 鈍"
"のろe 呪 詛 咒"
"のろc 呪 詛 咒"
"のりまわs 乗り回"
"のりづk 糊付"
"のりつぶs 乗り潰"
"のりつづk 乗り続"
"のりつk 乗り付"
"のりつi 乗り継"
"のりつg 乗り継"
"のりだs 乗り出"
"のりそこなw 乗り損"
"のりそこなu 乗り損"
"のりそこなt 乗り損"
"のりそこなo 乗り損"
"のりそこなi 乗り損"
"のりそこなe 乗り損"
"のりそこなc 乗り損"
"のりすごs 乗り過"
"のりすt 乗り捨"
"のりこs 乗り越"
"のりこn 乗り込"
"のりこm 乗り込"
"のりこe 乗り越 乗り超"
"のりくn 乗り組 乗組"
"のりくm 乗り組 乗組"
"のりきt 乗り切"
"のりきr 乗り切"
"のりきn 乗り切"
"のりきc 乗り切"
"のりかかt 乗り掛"
"のりかかr 乗り掛"
"のりかかn 乗り掛"
"のりかかc 乗り掛"
"のりかk 乗り掛"
"のりかe 乗り換 乗換 乗り替 乗替"
"のりおくr 乗り遅"
"のりうつt 乗り移"
"のりうつr 乗り移"
"のりうつn 乗り移"
"のりうつc 乗り移"
"のりいt 乗り入"
"のりいr 乗り入 乗入"
"のりいn 乗り入"
"のりいc 乗り入"
"のりあわs 乗り合"
"のりあw 乗り合"
"のりあu 乗り合"
"のりあt 乗り合"
"のりあo 乗り合"
"のりあi 乗り合"
"のりあe 乗り合"
"のりあc 乗り合"
"のりs 糊"
"のやk 野焼"
"のめりこn のめり込"
"のめりこm のめり込"
"のみほs 飲み干 飲み乾"
"のみはじm 飲み始"
"のみなおs 飲み直"
"のみつぶr 飲み潰"
"のみつづk 飲み続"
"のみたおs 飲み倒"
"のみたr 飲み足"
"のみすg 飲み過"
"のみこn 飲み込 飲込 呑み込"
"のみこm 飲み込 飲込 呑み込"
"のみくらb 飲み比"
"のみくだs 飲み下"
"のみあるk 飲み歩"
"のみあるi 飲み歩"
"のみあk 飲み明 飲み飽"
"のぼりつm 上り詰 登り詰"
"のぼせあg 逆上せ上"
"のぼt 登 昇 上 騰"
"のぼs 上 逆上 上気"
"のぼr 登 上 昇 騰"
"のぼn 登 上 昇 騰"
"のぼc 登 上 昇 騰"
"のべつまくなs のべつ幕無"
"のぶとs 野太"
"のぶとk 野太"
"のぶとi 野太"
"のぶとg 野太"
"のびなやn 伸び悩"
"のびなやm 伸び悩"
"のびきt 伸び切 延び切"
"のびきr 伸び切 延び切"
"のびきn 伸び切 延び切"
"のびきc 伸び切 延び切"
"のびあg 伸び上"
"のばなs 野放"
"のばs 延"
"ののしりあw 罵り合"
"ののしりあu 罵り合"
"ののしりあt 罵り合"
"ののしりあo 罵り合"
"ののしりあi 罵り合"
"ののしりあe 罵り合"
"ののしりあc 罵り合"
"ののしt 罵"
"ののしr 罵"
"ののしn 罵"
"ののしc 罵"
"ののs 罵"
"のづm 野積"
"のっぴk 退っ引"
"のっとt 乗っ取 則"
"のっとr 乗っ取 則 法"
"のっとn 乗っ取 則"
"のっとc 乗っ取 則"
"のちぞe 後添"
"のちn 後"
"のたれじn 野垂れ死"
"のたまわk 曰"
"のたまw 宣 曰"
"のたまu 宣 曰"
"のたまt 宣 曰"
"のたまo 宣 曰"
"のたまi 宣 曰"
"のたまh 宣 曰"
"のたまe 宣 曰"
"のたまc 宣 曰"
"のたうちまわt のたうち回"
"のたうちまわr のたうち回"
"のたうちまわn のたうち回"
"のたうちまわc のたうち回"
"のぞみみz 望み見"
"のぞみみy 望み見"
"のぞみみt 望み見"
"のぞみみs 望み見"
"のぞみみr 望み見"
"のぞみみn 望み見"
"のぞみみm 望み見"
"のぞみみk 望み見"
"のぞみみc 望み見"
"のぞきみz 覗き見"
"のぞきみy 覗き見"
"のぞきみt 覗き見"
"のぞきみs 覗き見"
"のぞきみr 覗き見"
"のぞきみn 覗き見"
"のぞきみm 覗き見"
"のぞきみk 覗き見"
"のぞきみc 覗き見"
"のぞきこn 覗き込"
"のぞきこm 覗き込"
"のぞs 除 覗"
"のぞn 望 臨"
"のぞm 望 臨"
"のぞk 除 覗 覘 臨"
"のぞi 除 覗 覘 臨"
"のぞg 除 覗"
"のしあるk 伸し歩"
"のしあるi 伸し歩"
"のしあg 伸し上"
"のざらs 野晒"
"のこりわずk 残り僅"
"のこりすくn 残り少"
"のこt 残 殘 遺"
"のこs 残 遺 殘"
"のこr 残 遺 殘"
"のこn 残 遺 殘"
"のこc 残 遺 殘"
"のけぞt のけ反 仰け反"
"のけぞr 仰け反 のけ反"
"のけぞn 仰け反 のけ反"
"のけぞc 仰け反 のけ反"
"のきなm 軒並"
"のがs 逃 迯"
"のがr 逃 遁 逸 迯"
"のうなs 能無"
"のt 乗 載 乘"
"のs 載 乗 伸 熨 乘"
"のr 乗 載 伸 乘"
"のn 飲 呑 嚥 飮 乗 載 乘"
"のm 飲 呑 嚥 飮"
"のk 退 除 乗 載"
"のi 退"
"のg 逃 迯"
"のc 乗 載 乘"
"のb 伸 述 延 陳"
"ねんばらi 年払"
"ねんごr 懇"
"ねんおs 念押"
"ねんいr 念入"
"ねんz 念 拈"
"ねんj 念"
"ねりまz 練り混"
"ねりなおs 練り直"
"ねりこn 練り込"
"ねりこm 練り込"
"ねりかたm 練り固 煉り固"
"ねりあるk 練り歩"
"ねりあるi 練り歩"
"ねりあw 練り合"
"ねらいすm 狙い澄"
"ねらいうt 狙い撃"
"ねらいうc 狙い撃"
"ねらw 狙"
"ねらu 狙"
"ねらt 狙"
"ねらo 狙"
"ねらi 狙"
"ねらe 狙"
"ねらc 狙"
"ねもこr 懇"
"ねめまわs 睨め回"
"ねめつk 睨め付"
"ねむりこn 眠り込"
"ねむりこm 眠り込"
"ねむt 眠 睡"
"ねむs 眠"
"ねむr 眠 睡"
"ねむn 眠 睡"
"ねむk 眠"
"ねむi 眠"
"ねむg 眠"
"ねむc 眠 睡"
"ねみだr 寝乱"
"ねまわs 根回"
"ねぼk 寝惚 寝呆"
"ねぶかs 根深"
"ねぶかk 根深"
"ねぶかi 根深"
"ねぶかg 根深"
"ねぶt 舐 眠"
"ねぶr 舐 眠"
"ねぶn 舐 眠"
"ねぶm 値踏"
"ねぶc 舐 眠"
"ねびk 値引"
"ねびi 値引"
"ねびe 寝冷"
"ねばりぬk 粘り抜"
"ねばりぬi 粘り抜"
"ねばりづよs 粘り強"
"ねばりづよk 粘り強"
"ねばりづよi 粘り強"
"ねばりづよg 粘り強"
"ねばりつk 粘り着"
"ねばりつi 粘り着"
"ねばつk 粘着"
"ねばつi 粘着"
"ねばt 粘"
"ねばr 粘"
"ねばn 粘"
"ねばk 粘"
"ねばc 粘"
"ねなおs 寝直"
"ねなs 根無"
"ねとt 寝取"
"ねとr 寝取"
"ねとn 寝取"
"ねとm 寝泊"
"ねとc 寝取"
"ねづよs 根強"
"ねづよk 根強"
"ねづよi 根強"
"ねづよg 根強"
"ねづかr 寝疲"
"ねづm 根詰"
"ねづk 根付"
"ねづi 根付"
"ねつp 熱"
"ねつk 寝付"
"ねつi 寝付"
"ねっちゅうs 熱中"
"ねっしんd 熱心"
"ねっs 熱"
"ねっk 根っ"
"ねちがe 寝違"
"ねだt 強請"
"ねだr 強請"
"ねだn 強請"
"ねだm 寝溜"
"ねだc 強請"
"ねたs 妬"
"ねたn 妬 嫉"
"ねたm 妬 嫉"
"ねたk 妬"
"ねたg 妬"
"ねずみとr 鼠取"
"ねすごs 寝過"
"ねすg 寝過"
"ねじまg 捻じ曲 捩じ曲 ねじ曲"
"ねじふs 捻じ伏 捩じ伏 ねじ伏"
"ねじこn 捩じ込 ねじ込"
"ねじこm 捩じ込 ねじ込"
"ねじきt 捩じ切"
"ねじきr 捩じ切"
"ねじきn 捩じ切"
"ねじきc 捩じ切"
"ねじあg 捩じ上"
"ねじt 捻 捩"
"ねじr 捻 捩"
"ねじn 捻 捩"
"ねじk 拗"
"ねじc 捻 捩"
"ねしずm 寝静"
"ねざs 根差"
"ねざm 寝覚"
"ねさg 値下"
"ねころn 寝転"
"ねころg 寝転"
"ねころb 寝転"
"ねこかわいg 猫可愛"
"ねこn 寝込"
"ねこm 寝込"
"ねぐるs 寝苦"
"ねくずr 値崩"
"ねぎらw 労 犒"
"ねぎらu 労 犒"
"ねぎらt 労 犒"
"ねぎらo 労 犒"
"ねぎらi 労 犒"
"ねぎらe 労 犒"
"ねぎらc 労 犒"
"ねぎt 値切"
"ねぎr 値切"
"ねぎn 値切"
"ねぎc 値切"
"ねがえt 寝返"
"ねがえr 寝返"
"ねがえn 寝返"
"ねがえc 寝返"
"ねがいでz 願い出"
"ねがいでy 願い出"
"ねがいでt 願い出"
"ねがいでs 願い出"
"ねがいでr 願い出"
"ねがいでn 願い出"
"ねがいでm 願い出"
"ねがいでk 願い出"
"ねがいでc 願い出"
"ねがいさg 願い下"
"ねがw 願 希"
"ねがu 願 希"
"ねがt 願 希"
"ねがo 願 希"
"ねがi 願 希"
"ねがh 願"
"ねがe 願 希"
"ねがc 願 希"
"ねかしつk 寝かし付"
"ねおk 寝起"
"ねえs 姉"
"ねうごk 値動"
"ねうt 値打"
"ねうc 値打"
"ねいt 寝入"
"ねいr 寝入"
"ねいn 寝入"
"ねいc 寝入"
"ねあらi 値洗"
"ねあがr 値上 根上"
"ねあk 寝明"
"ねあg 値上"
"ねz 寝 捻 捩 寢"
"ねy 寝 寢"
"ねw 寝 寢"
"ねu 寝 寢"
"ねt 寝 練 寢 錬 煉 粘"
"ねs 寝 寢"
"ねr 寝 練 錬 煉 粘 寢"
"ねp 寝 寢"
"ねo 寝 寢"
"ねn 寝 寢 練 錬 煉 粘"
"ねm 寝 睨 寢"
"ねk 寝 根 寢"
"ねj 捻 捩 寝 寢"
"ねi 寝 寢"
"ねh 寝 寢"
"ねg 寝 寢"
"ねe 寝 寢"
"ねd 寝 寢"
"ねc 寝 練 錬 煉 粘 寢"
"ねb 寝 寢"
"ねa 寝 寢"
"ぬるs 微温 温"
"ぬるn 温"
"ぬるm 微温 温"
"ぬるk 微温 温"
"ぬるi 微温 温"
"ぬるg 微温 温"
"ぬりわk 塗り分"
"ぬりなおs 塗り直"
"ぬりつぶs 塗り潰"
"ぬりつk 塗り付"
"ぬりこn 塗り込"
"ぬりこm 塗り込"
"ぬりかたm 塗り固"
"ぬりかe 塗り替 塗替"
"ぬめt 滑"
"ぬめr 滑"
"ぬめn 滑"
"ぬめc 滑"
"ぬのきr 布切"
"ぬのうr 布売"
"ぬすみみz 盗み見"
"ぬすみみy 盗み見"
"ぬすみみt 盗み見"
"ぬすみみs 盗み見"
"ぬすみみr 盗み見"
"ぬすみみn 盗み見"
"ぬすみみm 盗み見"
"ぬすみみk 盗み見"
"ぬすみみc 盗み見"
"ぬすみとt 盗み取"
"ぬすみとr 盗み取"
"ぬすみとn 盗み取"
"ぬすみとc 盗み取"
"ぬすみだs 盗み出"
"ぬすみぐi 盗み食"
"ぬすみぎk 盗み聞"
"ぬすみぎi 盗み聞"
"ぬすn 盗 偸 盜"
"ぬすm 盗 偸 盜"
"ぬけでz 抜け出"
"ぬけでy 抜け出"
"ぬけでt 抜け出"
"ぬけでs 抜け出"
"ぬけでr 抜け出"
"ぬけでn 抜け出"
"ぬけでm 抜け出"
"ぬけでc 抜け出"
"ぬけだs 抜け出 脱け出"
"ぬけがk 抜け駆"
"ぬけおt 抜け落"
"ぬけおc 抜け落"
"ぬぐいさt 拭い去"
"ぬぐいさr 拭い去"
"ぬぐいさn 拭い去"
"ぬぐいさc 拭い去"
"ぬぐw 拭"
"ぬぐu 拭"
"ぬぐt 拭"
"ぬぐo 拭"
"ぬぐi 拭"
"ぬぐe 拭"
"ぬぐc 拭"
"ぬくs 温"
"ぬくn 温"
"ぬくm 温"
"ぬくk 温"
"ぬくi 温"
"ぬくg 温"
"ぬぎっぱなs 脱ぎっ放"
"ぬぎすt 脱ぎ捨"
"ぬきんでy 抜きん出"
"ぬきんでt 抜きん出"
"ぬきんでr 抜きん出"
"ぬきんでn 抜きん出"
"ぬきんでm 抜きん出"
"ぬきはなt 抜き放"
"ぬきとおs 貫き通"
"ぬきとt 抜き取"
"ぬきとr 抜き取"
"ぬきとn 抜き取"
"ぬきとc 抜き取"
"ぬきでz 抜き出"
"ぬきでy 抜き出"
"ぬきでt 抜き出"
"ぬきでs 抜き出"
"ぬきでr 抜き出"
"ぬきでn 抜き出"
"ぬきでm 抜き出"
"ぬきでk 抜き出"
"ぬきでc 抜き出"
"ぬきだs 抜き出"
"ぬきずr 抜き刷"
"ぬきさt 抜き去"
"ぬきさs 抜き差"
"ぬきさr 抜き去"
"ぬきさn 抜き去"
"ぬきさc 抜き去"
"ぬきがたs 抜き難"
"ぬきがたk 抜き難"
"ぬきがたi 抜き難"
"ぬきがたg 抜き難"
"ぬきうt 抜き打 抜き撃 抜打"
"ぬきあw 抜き合"
"ぬきあu 抜き合"
"ぬきあt 抜き合"
"ぬきあo 抜き合"
"ぬきあi 抜き合"
"ぬきあe 抜き合"
"ぬきあc 抜き合"
"ぬきn 抽 擢"
"ぬかるn 泥濘"
"ぬかるm 泥濘"
"ぬかばたらk 糠働"
"ぬかずk 額突"
"ぬかずi 額突"
"ぬかr 泥濘"
"ぬいとt 縫取 縫い取"
"ぬいとr 縫取 縫い取"
"ぬいとn 縫取 縫い取"
"ぬいとj 縫い閉"
"ぬいとc 縫取 縫い取"
"ぬいつk 縫い付"
"ぬいこn 縫い込"
"ぬいこm 縫い込"
"ぬいあわs 縫い合"
"ぬいあw 縫い合"
"ぬいあg 縫い上"
"ぬw 抜 縫"
"ぬu 縫"
"ぬt 塗 縫"
"ぬr 塗 濡"
"ぬo 縫"
"ぬn 塗"
"ぬk 抜 貫 脱 拔"
"ぬi 抜 脱 縫 貫 拔"
"ぬg 脱"
"ぬe 縫"
"ぬc 縫 塗"
"にんめいs 任命"
"にんげんばなr 人間離"
"にんげんくさs 人間臭"
"にんげんくさk 人間臭"
"にんげんくさi 人間臭"
"にんげんくさg 人間臭"
"にんげんぎらi 人間嫌"
"にんげんr 人間"
"にんきうすs 人気薄"
"にんきうすk 人気薄"
"にんきうすi 人気薄"
"にんきうすg 人気薄"
"にんz 任"
"にんj 任"
"にわかs 俄"
"にわかn 俄"
"にわかd 俄"
"にわk 俄"
"にらみつk 睨み付"
"にらみかえs 睨み返"
"にらみあw 睨み合"
"にらみあu 睨み合"
"にらみあt 睨み合"
"にらみあo 睨み合"
"にらみあi 睨み合"
"にらみあe 睨み合"
"にらみあc 睨み合"
"にらn 睨 眈"
"にらm 睨 眈"
"によt 似寄"
"によr 似寄"
"によn 似寄"
"によc 似寄"
"にゅうりょくまt 入力待"
"にゅうりょくまc 入力待"
"にまいげr 二枚蹴"
"にぼs 煮干"
"にほんじんごのm 日本人好"
"にほんざs 二本差"
"にほんごふきかe 日本語吹替"
"にほんごうt 日本語打"
"にほんごうc 日本語打"
"にぶt 鈍"
"にぶs 鈍"
"にぶr 鈍"
"にぶn 鈍"
"にぶk 鈍"
"にぶi 鈍"
"にぶg 鈍"
"にぶc 鈍"
"にふくm 煮含"
"にばんせんj 二番煎"
"にはじm 煮始"
"にぬk 煮抜"
"にぬi 煮抜"
"になw 担 擔"
"になu 担 擔"
"になt 担 擔"
"になo 担 擔"
"になi 担 擔"
"になe 担 擔"
"になc 担 擔"
"にとおr 二通"
"にとk 煮溶"
"にづくr 荷造"
"につまt 煮詰"
"につまr 煮詰"
"につまn 煮詰"
"につまc 煮詰"
"につm 煮詰"
"につk 煮付"
"にちょうなg 二丁投"
"にちしゅくやすm 日祝休"
"にだs 煮出"
"にたt 煮立"
"にたk 煮炊"
"にたc 煮立"
"にじりよt 躙り寄"
"にじりよr 躙り寄"
"にじりよn 躙り寄"
"にじりよc 躙り寄"
"にじりでy 躙り出"
"にじりでt 躙り出"
"にじりでs 躙り出"
"にじりでr 躙り出"
"にじりでn 躙り出"
"にじりでm 躙り出"
"にじゅううつs 二重写"
"にじみでy 滲み出"
"にじみでt 滲み出"
"にじみでr 滲み出"
"にじみでn 滲み出"
"にじみでm 滲み出"
"にじみだs 滲み出"
"にじt 躙"
"にじr 躙"
"にじn 滲 躙"
"にじm 滲"
"にじc 躙"
"にしむk 西向"
"にしm 煮染"
"にごt 濁"
"にごs 濁"
"にごr 濁"
"にごn 濁"
"にごc 濁"
"にころg 煮転"
"にこy 柔 和"
"にこn 煮込"
"にこm 煮込"
"にげまわt 逃げ回"
"にげまわr 逃げ回"
"にげまわn 逃げ回"
"にげまわc 逃げ回"
"にげまどw 逃げ惑"
"にげまどu 逃げ惑"
"にげまどt 逃げ惑"
"にげまどo 逃げ惑"
"にげまどi 逃げ惑"
"にげまどe 逃げ惑"
"にげまどc 逃げ惑"
"にげだs 逃げ出"
"にげさt 逃げ去"
"にげさr 逃げ去"
"にげさn 逃げ去"
"にげさc 逃げ去"
"にげこn 逃げ込"
"にげこm 逃げ込"
"にげきt 逃げ切"
"にげきr 逃げ切"
"にげきn 逃げ切"
"にげきc 逃げ切"
"にげかくr 逃げ隠"
"にげかえt 逃げ帰"
"にげかえr 逃げ帰"
"にげかえn 逃げ帰"
"にげかえc 逃げ帰"
"にげおくr 逃げ遅"
"にげおおs 逃げ果"
"にげおt 逃げ落"
"にげおc 逃げ落"
"にげうs 逃げ失"
"にくみあw 憎み合"
"にくみあu 憎み合"
"にくみあt 憎み合"
"にくみあo 憎み合"
"にくみあi 憎み合"
"にくみあe 憎み合"
"にくみあc 憎み合"
"にくばなr 肉離"
"にくにくs 憎々"
"にくづk 肉付"
"にくづi 肉付"
"にくずr 荷崩 煮崩"
"にくおどt 肉踊"
"にくおどr 肉踊"
"にくおどn 肉踊"
"にくおどc 肉踊"
"にくt 憎"
"にくs 憎 難 悪"
"にくr 憎"
"にくn 憎"
"にくm 憎"
"にくk 憎 難 悪"
"にくi 憎 難 悪"
"にくg 憎 難 悪"
"にぎわw 賑"
"にぎわu 賑"
"にぎわt 賑"
"にぎわo 賑"
"にぎわi 賑"
"にぎわe 賑"
"にぎわc 賑"
"にぎりつぶs 握り潰"
"にぎりしm 握り締"
"にぎはh 賑"
"にぎにぎs 賑々 賑賑"
"にぎy 賑"
"にぎw 賑"
"にぎt 握"
"にぎr 握"
"にぎn 握"
"にぎc 握"
"にきr 煮切"
"にがわらi 苦笑"
"にがりきt 苦り切"
"にがりきr 苦り切"
"にがりきn 苦り切"
"にがりきc 苦り切"
"にがみばしt 苦み走"
"にがみばしr 苦み走"
"にがみばしn 苦み走"
"にがみばしc 苦み走"
"にがにがs 苦々"
"にがs 苦 逃"
"にがr 苦"
"にがp 苦"
"にがm 苦"
"にがk 苦"
"にがi 苦"
"にがg 苦"
"にかよw 似通"
"にかよu 似通"
"にかよt 似通"
"にかよo 似通"
"にかよi 似通"
"にかよe 似通"
"にかよc 似通"
"におうだt 仁王立"
"においたt 匂い立"
"においたc 匂い立"
"におy 匂"
"におw 匂 臭"
"におu 匂 臭"
"におt 匂 臭"
"におr 荷下"
"におo 匂 臭"
"におi 匂 臭"
"におe 匂 臭"
"におc 匂 臭"
"にえたぎt 煮え滾"
"にえたぎr 煮え滾"
"にえたぎn 煮え滾"
"にえたぎc 煮え滾"
"にえたt 煮え立"
"にえたc 煮え立"
"にえくりかえt 煮え繰り返"
"にえくりかえr 煮え繰り返"
"にえくりかえn 煮え繰り返"
"にえくりかえc 煮え繰り返"
"にえきt 煮え切"
"にえきr 煮え切"
"にえきn 煮え切"
"にえきc 煮え切"
"にえs 贄"
"にいt 兄"
"にいs 兄"
"にあw 似合"
"にあu 似合"
"にあt 似合"
"にあo 似合"
"にあi 似合"
"にあg 荷揚 煮上"
"にあe 似合"
"にあc 似合"
"にz 似 煮"
"にy 煮 似"
"にw 似 煮"
"にu 似 煮"
"にt 似 煮"
"にs 似 煮"
"にr 似 煮"
"にp 似 煮"
"にo 似 煮"
"にn 似 荷 煮"
"にm 似 煮"
"にk 煮 似"
"にj 似 煮"
"にi 似 煮"
"にh 似 煮"
"にg 逃 迯 似 煮"
"にe 煮 似"
"にd 似 煮"
"にc 似 煮"
"にb 似 煮"
"にa 似 煮"
"なんばんづk 南蛮漬"
"なんなn 垂"
"なんなk 難無"
"なんとおr 何通"
"なんz 難 何"
"なんt 何"
"なんr 何"
"なんn 何"
"なんk 何"
"なんj 難 何"
"なんd 何"
"なわばr 縄張"
"なれなれs 馴々"
"なれそm 馴れ初"
"なれしたs 慣れ親"
"なれあw 馴れ合"
"なれあu 馴れ合"
"なれあt 馴れ合"
"なれあo 馴れ合"
"なれあi 馴れ合"
"なれあe 馴れ合"
"なれあc 馴れ合"
"なるべk 成る可"
"なりわたt 鳴り渡"
"なりわたr 鳴り渡"
"なりわたn 鳴り渡"
"なりわたc 鳴り渡"
"なりゆk 成り行 成行"
"なりやn 鳴り止"
"なりやm 鳴り止"
"なりふr 形振"
"なりひびk 鳴り響"
"なりひびi 鳴り響"
"なりはt 成り果"
"なりだs 鳴り出"
"なりたt 成り立 成立"
"なりたc 成り立 成立"
"なりすm 成り済"
"なりさg 成り下"
"なりきt 成り切"
"なりきr 成り切"
"なりきn 成り切"
"なりきc 成り切"
"なりかわt 成り代"
"なりかわr 成り代"
"なりかわn 成り代"
"なりかわc 成り代"
"なりかw 成り代 成り変"
"なりあg 成り上"
"ならべたt 並べ立"
"ならべかe 並べ替 並べ換 並べ変"
"ならびたt 並び立"
"ならびたc 並び立"
"ならびかe 並び換"
"ならづk 奈良漬"
"ならいおぼe 習い覚"
"ならw 習 慣 倣 肄"
"ならu 習 倣 肄"
"ならt 習 倣 肄"
"ならs 均"
"ならo 習 倣 肄"
"ならn 並 列 竝 双"
"ならi 習 倣 肄"
"ならh 習"
"ならe 習 倣 肄"
"ならc 習 倣 肄"
"ならb 並 列 双 竝"
"なよs 名寄"
"なやみおおk 悩み多"
"なやn 悩 惱"
"なやm 悩 惱"
"なめらk 滑"
"なめまわs 舐め回 嘗め回"
"なめとt 舐め取"
"なめとr 舐め取"
"なめとn 舐め取"
"なめとc 舐め取"
"なめつくs 舐め尽 嘗め尽"
"なめつk 嘗め尽 舐め尽"
"なめずt 舐"
"なめずr 舐"
"なめずn 舐"
"なめずc 舐"
"なめあw 舐め合"
"なめあu 舐め合"
"なめあt 舐め合"
"なめあo 舐め合"
"なめあi 舐め合"
"なめあg 舐め上"
"なめあe 舐め合"
"なめあc 舐め合"
"なめs 鞣"
"なめr 滑"
"なみはずr 並外 並み外"
"なみのr 波乗"
"なみだもろs 涙脆"
"なみだもろk 涙脆"
"なみだもろi 涙脆"
"なみだもろg 涙脆"
"なみだt 波立"
"なみだs 涙"
"なみだg 涙"
"なみだc 波立"
"なみうt 波打"
"なみうc 波打"
"なみいt 並み居"
"なみいr 並み居"
"なみs 蔑"
"なまやさs 生易"
"なまやk 生焼"
"なまめs 艶"
"なまめk 艶"
"なまめi 艶"
"なまめg 艶"
"なまぬるs 生温"
"なまぬるk 生温"
"なまぬるi 生温"
"なまぬるg 生温"
"なまにe 生煮"
"なまなまs 生々 生生"
"なまっちろs 生っ白"
"なまっちろk 生っ白"
"なまっちろi 生っ白"
"なまっちろg 生っ白"
"なまじろs 生白"
"なまじろk 生白"
"なまじろi 生白"
"なまじろg 生白"
"なまじi 憖"
"なまじh 憖"
"なまごろs 生殺"
"なまぐさs 生臭 腥"
"なまぐさk 生臭 腥"
"なまぐさi 生臭 腥"
"なまぐさg 生臭 腥"
"なまくr 鈍"
"なまがわk 生乾"
"なまえまk 名前負"
"なまえつk 名前付"
"なまあたたk 生暖"
"なまt 訛 鈍 譌"
"なまs 生"
"なまr 鈍 訛 譌"
"なまn 鈍 訛 譌 生"
"なまm 生"
"なまk 怠 懶"
"なまd 生"
"なまc 鈍 訛 譌"
"なほs 治 直"
"なべt 並べ"
"なぶりごろs 嬲り殺"
"なぶりころs 嬲り殺"
"なぶt 嬲 嫐"
"なぶr 嬲 嫐"
"なぶn 嬲 嫐"
"なぶc 嬲 嫐"
"なびk 靡"
"なびi 靡"
"なのりでz 名乗り出"
"なのりでy 名乗り出"
"なのりでt 名乗り出"
"なのりでs 名乗り出"
"なのりでr 名乗り出"
"なのりでn 名乗り出"
"なのりでm 名乗り出"
"なのりでk 名乗り出"
"なのりでc 名乗り出"
"なのt 名乗 名宣 名告"
"なのr 名乗 名告 名宣"
"なのn 名乗 名告 名宣"
"なのm 斜"
"なのc 名乗 名告 名宣"
"なにひとt 何一"
"なにはさておk 何は扨措"
"なにはさておi 何は扨措"
"なにげなs 何気無"
"なにげなk 何気無"
"なにげなi 何気無"
"なにげなg 何気無"
"なにげn 何気"
"なにくw 何食 何喰"
"なにかんがe 何考"
"なにかt 何彼"
"なにw 何"
"なにt 何"
"なにs 何"
"なにn 何"
"なにm 何"
"なにk 何"
"なにg 何"
"ななまがr 七曲"
"ななころびやおk 七転び八起"
"ななこおr 斜子織 魚子織"
"ななt 七"
"ななs 名無"
"ななm 斜"
"なでまわs 撫で回"
"なでつk 撫で付"
"なでさすt 撫で擦"
"なでさすr 撫で擦"
"なでさすn 撫で擦"
"なでさすc 撫で擦"
"なであg 撫で上"
"なづけt 名付け"
"なづn 泥"
"なづm 泥"
"なづk 名付"
"なつやすm 夏休"
"なつむk 夏向"
"なつまつr 夏祭"
"なつかs 懐 懷"
"なつk 懐 懷"
"なっとくいただk 納得頂"
"なっとくいただi 納得頂"
"なっとくいt 納得行"
"なっとくいk 納得行"
"なっとくいc 納得行"
"なっとくs 納得"
"なだれこn 雪崩れ込 傾れ込 なだれ込"
"なだれこm 雪崩れ込 傾れ込 なだれ込"
"なだめすかs 宥め賺"
"なだかs 名高"
"なだかk 名高"
"なだかi 名高"
"なだかg 名高"
"なだt 名立"
"なだr 雪崩 傾"
"なだm 宥"
"なぞらu 準 擬 准 凖"
"なぞらh 準 擬 准 凖"
"なぞらe 準 擬 准"
"なぞとk 謎解"
"なぞかk 謎掛"
"なぞm 謎"
"なぜn 何故"
"なずらu 準 擬 准 凖"
"なずらh 準 擬 准 凖"
"なずn 泥"
"なずm 泥"
"なすりつk 擦り付"
"なすt 擦"
"なすr 擦"
"なすn 擦"
"なすc 擦"
"なじみぶかs 馴染み深"
"なじみぶかk 馴染み深"
"なじみぶかi 馴染み深"
"なじみぶかg 馴染み深"
"なじt 詰"
"なじr 詰"
"なじn 馴染 詰"
"なじm 馴染"
"なじc 詰"
"なしとg 成し遂 為し遂"
"なしくずs 済し崩 なし崩"
"なしえz 為し得"
"なしえy 為し得"
"なしえt 為し得"
"なしえs 為し得"
"なしえr 為し得"
"なしえn 為し得"
"なしえm 為し得"
"なしえc 為し得"
"なしうr 為し得"
"なしうb 為し得"
"なざs 名指"
"なさけぶかs 情深 情け深"
"なさけぶかk 情深 情け深"
"なさけぶかi 情け深 情深"
"なさけぶかg 情け深 情深"
"なさけなs 情無 情け無"
"なさけなk 情無 情け無"
"なさけなi 情無 情け無"
"なさけなg 情無 情け無"
"なさけしr 情け知"
"なさk 情"
"なごりおs 名残惜"
"なごやk 和や"
"なごy 和"
"なごr 名残"
"なごn 和"
"なごm 和"
"なげわたs 投げ渡"
"なげやt 投げ遣"
"なげやr 投げ遣"
"なげやn 投げ遣"
"なげやc 投げ遣"
"なげづr 投げ釣"
"なげつk 投げ付"
"なげだs 投げ出"
"なげすt 投げ捨"
"なげこn 投げ込 投込"
"なげこm 投げ込 投込"
"なげきかなs 嘆き悲"
"なげかえs 投げ返"
"なげかk 投げ掛"
"なげおt 投げ落"
"なげおr 投げ下"
"なげうt 抛 擲"
"なげうc 抛 擲"
"なげいr 投げ入"
"なげあw 投げ合"
"なげあu 投げ合"
"なげあt 投げ合"
"なげあo 投げ合"
"なげあi 投げ合"
"なげあg 投げ上"
"なげあe 投げ合"
"なげあc 投げ合"
"なげk 嘆 歎 慨"
"なげi 嘆 歎 慨"
"なげe 長"
"なけr 泣け"
"なぐりつk 殴り付"
"なぐりたおs 殴り倒"
"なぐりころs 殴り殺"
"なぐりこn 殴り込"
"なぐりこm 殴り込"
"なぐりかk 殴り掛"
"なぐりあw 殴り合"
"なぐりあu 殴り合"
"なぐりあt 殴り合"
"なぐりあo 殴り合"
"なぐりあi 殴り合"
"なぐりあe 殴り合"
"なぐりあc 殴り合"
"なぐさめあw 慰め合"
"なぐさめあu 慰め合"
"なぐさめあt 慰め合"
"なぐさめあo 慰め合"
"なぐさめあi 慰め合"
"なぐさめあe 慰め合"
"なぐさめあc 慰め合"
"なぐさn 慰"
"なぐさm 慰"
"なぐt 殴 撲 毆 擲"
"なぐr 殴 撲 擲 毆"
"なぐn 殴 撲 擲 毆"
"なぐc 殴 撲 擲 毆"
"なくなk 泣く泣"
"なぎはらw 薙ぎ払"
"なぎはらu 薙ぎ払"
"なぎはらt 薙ぎ払"
"なぎはらo 薙ぎ払"
"なぎはらi 薙ぎ払"
"なぎはらe 薙ぎ払"
"なぎはらc 薙ぎ払"
"なぎたおs 薙ぎ倒"
"なきわめk 泣き喚"
"なきわめi 泣き喚"
"なきわかr 泣き別"
"なきやn 泣き止 鳴き止"
"なきやm 泣き止 鳴き止"
"なきふs 泣き伏"
"なきはらs 泣き腫"
"なきはr 泣き腫"
"なきねいr 泣き寝入"
"なきぬr 泣き濡"
"なきつづk 泣き続"
"なきつくs 泣き尽"
"なきつかr 泣き疲"
"なきつk 泣き付"
"なきつi 泣き付"
"なきだs 泣き出"
"なきたt 泣き立"
"なきそぼt 泣き濡"
"なきしずn 泣き沈"
"なきしずm 泣き沈"
"なきしきt 鳴き頻 泣き頻"
"なきしきr 鳴き頻 泣き頻"
"なきしきn 鳴き頻 泣き頻"
"なきしきc 鳴き頻 泣き頻"
"なきさけn 泣き叫"
"なきさけb 泣き叫"
"なきくらs 泣き暮"
"なきくずr 泣き崩"
"なきくr 泣き暮"
"なきかわs 鳴き交"
"なきかw 鳴き交"
"なきかr 泣き嗄"
"なきおとs 泣き落 泣落"
"なきおt 泣き落"
"なきあk 泣き明"
"ながれゆk 流れ行"
"ながれでy 流れ出"
"ながれでt 流れ出"
"ながれでs 流れ出"
"ながれでr 流れ出"
"ながれでn 流れ出"
"ながれでm 流れ出"
"ながれつづk 流れ続"
"ながれだs 流れ出"
"ながれこn 流れ込"
"ながれこm 流れ込"
"ながれおt 流れ落"
"ながれおc 流れ落"
"ながれあるk 流れ歩"
"ながれあるi 流れ歩"
"ながらh 存"
"ながらe 存"
"ながもt 長持"
"ながもc 長持"
"ながめやt 眺め遣"
"ながめやr 眺め遣"
"ながめやn 眺め遣"
"ながめやc 眺め遣"
"ながほそs 長細"
"ながほそk 長細"
"ながほそi 長細"
"ながほそg 長細"
"ながびs 長引"
"ながびk 長引"
"ながびi 長引"
"ながびg 長引"
"ながながs 長々"
"ながつづk 長続"
"ながすぎr 長過"
"ながすg 長過"
"ながしつづk 流し続"
"ながしさt 流し去"
"ながしさr 流し去"
"ながしさn 流し去"
"ながしさc 流し去"
"ながしこn 流し込"
"ながしこm 流し込"
"ながしうt 流し打"
"ながしうc 流し打"
"ながいk 長生"
"ながt 長"
"ながs 流 長 永"
"ながr 流 長 永 乍 存"
"ながm 眺 長 詠"
"ながk 長 永"
"ながi 長 永"
"ながg 長 永"
"ながb 長"
"なかよs 仲良"
"なかよk 仲良"
"なかまわr 仲間割"
"なかまはずr 仲間外"
"なかまいr 仲間入"
"なかぬk 中抜"
"なかづr 中吊"
"なかだるm 中弛"
"なかだt 仲立"
"なかだc 仲立"
"なかたがi 仲違"
"なかじm 中締"
"なかおt 中落"
"なかおs 中押"
"なかt 中"
"なかr 勿 莫"
"なかn 中"
"なかb 半"
"なおよs 尚良"
"なおっt 直"
"なおt 直 治"
"なおs 直 治 癒"
"なおr 直 治"
"なおn 直 治"
"なおc 直 治"
"なうt 名う"
"ないまz 綯い交"
"ないがしr 蔑"
"なz 撫"
"なw 綯"
"なu 綯"
"なt 鳴 成 綯 生 為 爲"
"なs 無 成 為 生 做 爲 亡"
"なr 慣 鳴 成 生 馴 為 熟 狎 爲"
"なo 綯"
"なn 鳴 成 生 為 爲"
"なm 並 舐 嘗 無 竝"
"なk 泣 鳴 亡 失 無 啼 哭 涕 嚶 啾"
"なi 無 泣 鳴 亡 綯 凪 啼 哭 涕 嚶 啾 薙"
"なh 綯"
"なg 投 凪 薙 無"
"なe 萎 痿 綯"
"なd 撫 名"
"なc 綯 鳴 成 生 為 爲"
"なb 並"
"どんづまr どん詰"
"どんづm どん詰"
"どんくさs 鈍臭"
"どんくさk 鈍臭"
"どんくさi 鈍臭"
"どんくさg 鈍臭"
"どんs 鈍"
"どわすr 度忘"
"どろよk 泥除"
"どろくさs 泥臭"
"どろくさk 泥臭"
"どろくさi 泥臭"
"どろくさg 泥臭"
"どよm 響 響動"
"どもt 吃"
"どもr 吃 土盛"
"どもn 吃"
"どもc 吃"
"どなりつk 怒鳴り付"
"どなりちr 怒鳴り散"
"どなりたt 怒鳴り立"
"どなりこn 怒鳴り込"
"どなりこm 怒鳴り込"
"どなりあw 怒鳴り合"
"どなりあu 怒鳴り合"
"どなりあt 怒鳴り合"
"どなりあo 怒鳴り合"
"どなりあi 怒鳴り合"
"どなりあe 怒鳴り合"
"どなりあc 怒鳴り合"
"どなt 怒鳴"
"どなr 怒鳴"
"どなn 怒鳴"
"どなc 怒鳴"
"どすぐろs どす黒 ドス黒"
"どすぐろk どす黒 ドス黒"
"どすぐろi どす黒 ドス黒"
"どすぐろg どす黒 ドス黒"
"どしゃぶr 土砂降"
"どしゃくづr 土砂崩"
"どしがたs 度し難"
"どしがたk 度し難"
"どしがたi 度し難"
"どしがたg 度し難"
"どこm 何処"
"どこk 何処"
"どくどくs 毒々"
"どくづk 毒突"
"どくづi 毒突"
"どくけs 毒消"
"どくいr 毒入"
"どくs 毒"
"どおs 遠 通"
"どおr 通"
"どおm 遠"
"どおk 遠"
"どおi 遠"
"どおg 遠"
"どうようn 同様"
"どうまわr 胴回"
"どうせきs 同席"
"どうじょうやぶr 道場破"
"どうじn 同時"
"どうじm 胴締"
"どうけt 道化"
"どうけr 道化"
"どうけn 道化"
"どうけc 道化"
"どうぐだt 道具立"
"どうきづk 動機付"
"どうあg 胴上"
"どうz 動 同"
"どうr 通"
"どうj 動 同"
"どあi 度合"
"どt 取 録"
"どs 度"
"どr 取 録 何"
"どn 何 取 録"
"どm 止 留"
"どk 退 解 融"
"どi 退"
"どc 取 録"
"とんぼがえr 蜻蛉返"
"とんでゆk 飛んで行"
"とんでいt 飛んで行"
"とんでいk 飛んで行"
"とんでいc 飛んで行"
"とんがt 尖"
"とんがr 尖"
"とんがn 尖"
"とんがc 尖"
"とろs トロ"
"とろk 蕩 盪 トロ"
"とろi トロ"
"とろg トロ"
"とりわすr 取り忘"
"とりわk 取り分 取分"
"とりよs 取り寄 取寄 鳥寄"
"とりやm 取り止"
"とりもなおs 取りも直"
"とりもどs 取り戻"
"とりもt 取り持"
"とりもc 取り持"
"とりむすn 取り結"
"とりむすb 取り結"
"とりみだs 取り乱"
"とりまわs 取り回 取回"
"とりまとm 取り纏"
"とりまぎr 取り紛"
"とりまz 取り混"
"とりまk 取り巻 取巻"
"とりまi 取り巻 取巻"
"とりひろg 取り広"
"とりひk 取り引 取引"
"とりはらw 取り払"
"とりはらu 取り払"
"とりはらt 取り払"
"とりはらo 取り払"
"とりはらi 取り払"
"とりはらe 取り払"
"とりはらc 取り払"
"とりはずs 取り外 取外"
"とりはこn 取り運"
"とりはこb 取り運"
"とりはかt 取り計"
"とりはかr 取り計"
"とりはかn 取り計"
"とりはかc 取り計"
"とりのぞk 取り除 取除"
"とりのぞi 取り除 取除"
"とりのこs 取り残"
"とりのがs 取り逃"
"とりのk 取り除"
"とりにg 取り逃"
"とりなおs 取り直 録り直 撮り直"
"とりなs 執り成 取り成"
"とりつぶs 取り潰 取潰"
"とりつくろw 取り繕 取繕"
"とりつくろu 取り繕 取繕"
"とりつくろt 取り繕 取繕"
"とりつくろo 取り繕 取繕"
"とりつくろi 取り繕 取繕"
"とりつくろe 取り繕 取繕"
"とりつくろc 取り繕 取繕"
"とりつくs 取り尽"
"とりつk 取り付 取付 取り尽 取り憑"
"とりつi 取り付 取り次 取り憑 取付 取次"
"とりつg 取り次 取次"
"とりちがe 取り違"
"とりちr 取り散"
"とりだs 取り出 取出"
"とりたt 取り立 取立"
"とりそろe 取り揃"
"とりそこn 取り損"
"とりすがt 取り縋"
"とりすがr 取り縋"
"とりすがn 取り縋"
"とりすがc 取り縋"
"とりすm 取り澄"
"とりしらb 取調 取り調"
"とりしまt 取締 取り締"
"とりしまr 取締 取り締 取り締ま"
"とりしまn 取締 取り締"
"とりしまc 取締 取り締"
"とりしきt 取り仕切"
"とりしきr 取り仕切"
"とりしきn 取り仕切"
"とりしきc 取り仕切"
"とりしm 取り締 取締"
"とりさばk 取り捌"
"とりさばi 取り捌"
"とりさt 取り去"
"とりさr 取り去"
"とりさn 取り去"
"とりさg 取り下"
"とりさc 取り去"
"とりこわs 取り壊 取壊"
"とりころs 取り殺"
"とりこぼs 取り零"
"とりこs 取り越"
"とりこn 取り込 取込"
"とりこm 取り込 取込"
"とりけs 取り消 取消"
"とりくずs 取り崩 取崩"
"とりくn 取り組"
"とりくm 取り組 取組"
"とりきt 取り切"
"とりきr 取り切"
"とりきn 取り切"
"とりきm 取り決 取り極"
"とりきc 取り切"
"とりかわs 取り交 取交"
"とりかたm 取り固"
"とりかこn 取り囲"
"とりかこm 取り囲"
"とりかえs 取り返"
"とりかw 取り交 取交"
"とりかk 取り掛"
"とりかe 取り替 取り換"
"とりおとs 取り落"
"とりおさe 取り抑"
"とりおこなw 執り行"
"とりおこなu 執り行"
"とりおこなt 執り行"
"とりおこなo 執り行"
"とりおこなi 執り行"
"とりおこなe 執り行"
"とりおこなc 執り行"
"とりおs 取り押"
"とりおk 取り置"
"とりおi 取り置"
"とりえz 取り得"
"とりえy 取り得"
"とりえt 取り得"
"とりえs 取り得"
"とりえr 取り得"
"とりえn 取り得"
"とりえm 取り得"
"とりえc 取り得"
"とりうr 取り得"
"とりうb 取り得"
"とりいそi 取り急"
"とりいそg 取り急"
"とりいt 取り入 取入"
"とりいr 取り入 取入"
"とりいn 取り入 取入"
"とりいc 取り入 取入"
"とりあわs 取り合"
"とりあらそw 取り争"
"とりあらそu 取り争"
"とりあらそt 取り争"
"とりあらそo 取り争"
"とりあらそi 取り争"
"とりあらそe 取り争"
"とりあらそc 取り争"
"とりあつかw 取り扱 取扱"
"とりあつかu 取り扱 取扱"
"とりあつかt 取り扱 取扱"
"とりあつかo 取り扱 取扱"
"とりあつかi 取り扱 取扱"
"とりあつかe 取り扱 取扱"
"とりあつかc 取り扱 取扱"
"とりあつm 取り集"
"とりあw 取り合 取合"
"とりあu 取り合 取合"
"とりあt 取り合 取合"
"とりあo 取り合 取合"
"とりあi 取り合 取合"
"とりあg 取り上 採り上"
"とりあe 取り敢 取り合 取合"
"とりあc 取り合 取合"
"とらぶt トラブ"
"とらぶr トラブ"
"とらぶn トラブ"
"とらぶc トラブ"
"とらがr 虎刈"
"とらw 囚 捕 捉"
"とらk 蕩 盪"
"とらh 囚 捉 捕"
"とらe 捉 捕 把"
"ともばたらk 共働"
"ともなw 伴"
"ともなu 伴"
"ともなt 伴"
"ともなo 伴"
"ともなi 伴"
"ともなh 伴"
"ともなe 伴"
"ともなc 伴"
"ともだおr 共倒"
"ともぐi 共食"
"ともかせg 共稼"
"ともえなg 巴投"
"ともt 灯 点 燈"
"ともs 灯 点 燈"
"ともr 灯 点 燈"
"ともn 共 伴 倶 灯 点 燈"
"ともc 灯 点 燈"
"とめおk 留め置"
"とめおi 留め置"
"とむらw 弔 訪"
"とむらu 弔 訪"
"とむらt 弔 訪"
"とむらo 弔 訪"
"とむらi 弔 訪"
"とむらe 弔 訪"
"とむらc 弔 訪"
"とみn 頓"
"とまりこn 泊まり込"
"とまりこm 泊まり込"
"とまどw 戸惑"
"とまどu 戸惑"
"とまどt 戸惑"
"とまどo 戸惑"
"とまどi 戸惑"
"とまどe 戸惑"
"とまどc 戸惑"
"とまt 止 泊 停 留 佇"
"とまr 泊 止 停 留"
"とまn 泊 止 停 留"
"とまc 泊 止 停 留"
"とぼしi 乏し"
"とぼs 乏 点"
"とぼk 惚 恍"
"とほのk 遠退"
"とほs 通 徹 遠"
"とほk 遠"
"とほi 遠"
"とほg 遠"
"とぶらh 弔 訪"
"とびまわt 飛び回"
"とびまわr 飛び回"
"とびまわn 飛び回"
"とびまわc 飛び回"
"とびはn 飛び跳"
"とびのt 飛び乗"
"とびのr 飛び乗"
"とびのn 飛び乗"
"とびのk 飛び退 跳び退"
"とびのi 飛び退 跳び退"
"とびのc 飛び乗"
"とびぬk 飛び抜"
"とびとb 飛び飛"
"とびでz 飛び出"
"とびでy 飛び出"
"とびでt 飛び出"
"とびでs 飛び出"
"とびでr 飛び出"
"とびでn 飛び出"
"とびでm 飛び出"
"とびでk 飛び出"
"とびでc 飛び出"
"とびつk 飛び付"
"とびつi 飛び付"
"とびちt 飛び散"
"とびちr 飛び散"
"とびちn 飛び散"
"とびちc 飛び散"
"とびだs 飛び出 飛出"
"とびたt 飛び立"
"とびたc 飛び立"
"とびすさt 飛び退"
"とびすさr 飛び退"
"とびすさn 飛び退"
"とびすさc 飛び退"
"とびさt 飛び去"
"とびさr 飛び去"
"とびさn 飛び去"
"とびさc 飛び去"
"とびこs 飛び越"
"とびこn 飛び込 飛込"
"とびこm 飛び込 飛込"
"とびこe 飛び越 跳び越 飛越 跳越"
"とびかw 飛び交"
"とびかu 飛び交"
"とびかt 飛び交"
"とびかo 飛び交"
"とびかi 飛び交"
"とびかe 飛び交"
"とびかc 飛び交"
"とびおr 飛び降 飛び下"
"とびおk 飛び起"
"とびうつt 飛び移"
"とびうつr 飛び移"
"とびうつn 飛び移"
"とびうつc 飛び移"
"とびいt 飛び入 飛入"
"とびいr 飛び入 飛入"
"とびいn 飛び入 飛入"
"とびいc 飛び入 飛入"
"とびあるk 飛び歩"
"とびあるi 飛び歩"
"とびあg 飛び上 跳び上"
"とばs 飛"
"となりあw 隣り合 隣合"
"となりあu 隣合 隣り合"
"となりあt 隣り合 隣合"
"となりあo 隣合 隣り合"
"となりあi 隣合 隣り合"
"となりあe 隣合 隣り合"
"となりあc 隣合 隣り合"
"となr 隣 鄰"
"となh 唱 称"
"となe 唱 称 稱"
"とどろk 轟 軣"
"とどろi 轟 軣"
"とどまt 滞"
"とどこおt 滞 滯"
"とどこおr 滞 滯"
"とどこおn 滞 滯"
"とどこおc 滞 滯"
"とどけでz 届け出"
"とどけでy 届け出"
"とどけでt 届け出 届出"
"とどけでs 届け出"
"とどけでr 届け出 届出"
"とどけでn 届け出 届出"
"とどけでm 届け出"
"とどけでk 届け出"
"とどけでc 届け出 届出"
"とどm 留 止 停 畄"
"とどk 届 屆"
"とどi 届 屆"
"ととのえr 整"
"ととのw 整 調 斉"
"ととのu 整 調 斉"
"ととのt 整 調 斉"
"ととのo 整 調 斉"
"ととのi 整 調 斉"
"ととのh 整 斉 調"
"ととのe 整 調 斉"
"ととのc 整 調 斉"
"とてm 迚"
"とつi 嫁"
"とつg 嫁"
"とっぱらw 取っ払"
"とっぱらu 取っ払"
"とっぱらt 取っ払"
"とっぱらo 取っ払"
"とっぱらi 取っ払"
"とっぱらe 取っ払"
"とっぱらc 取っ払"
"とってつk 取って付"
"とってかわt 取って代"
"とってかわr 取って代"
"とってかわn 取って代"
"とってかわc 取って代"
"とってかえs 取って返"
"とってかw 取って代"
"とっておk 取って置"
"とっておi 取って置"
"とっつかm 取っ捕"
"とっつk 取っ付"
"とっつi 取っ付"
"とっしんs 突進"
"とっくみあw 取っ組み合"
"とっくみあu 取っ組み合"
"とっくみあt 取っ組み合"
"とっくみあo 取っ組み合"
"とっくみあi 取っ組み合"
"とっくみあe 取っ組み合"
"とっくみあc 取っ組み合"
"とっくn 取っ組"
"とっくm 取っ組"
"とっかかt 取っ掛"
"とっかかr 取っ掛"
"とっかかn 取っ掛"
"とっかかc 取っ掛"
"とっかk 取っ掛"
"とっかe 取っ替"
"とっk 疾っ"
"とだe 途絶 跡絶"
"とじまr 戸締"
"とじこもt 閉じ籠"
"とじこもr 閉じ籠"
"とじこもn 閉じ籠"
"とじこもc 閉じ籠"
"とじこn 綴じ込"
"とじこm 閉じ込 綴じ込"
"とじあw 綴じ合"
"とじm 戸締"
"としよt 年寄"
"としよr 年寄"
"としよn 年寄"
"としよc 年寄"
"としとt 年取"
"としとr 年取"
"としとn 年取"
"としとc 年取"
"としこs 年越"
"としおi 年老"
"としあk 年明"
"とざs 鎖 閉"
"ところてんつk 心太突"
"ところせまs 所狭"
"ところせu 所狭"
"ところせs 所狭"
"ところせk 所狭"
"ところかまw 所構"
"とこずr 床擦"
"とこs 常"
"とげとげs 刺々 刺刺"
"とけだs 溶け出"
"とけこn 溶け込"
"とけこm 溶け込"
"とけあw 溶け合"
"とけあu 溶け合"
"とけあt 溶け合"
"とけあo 溶け合"
"とけあi 溶け合"
"とけあc 溶け合"
"とくべつあつかi 特別扱"
"とくべつn 特別"
"とくばらi 特払"
"とくちょうづk 特徴付"
"とくs 得 督"
"とくn 特 得"
"とくj 得"
"とくd 得"
"とぎれr 途切れ"
"とぎすm 研ぎ澄"
"とぎr 途切 跡切"
"ときほぐs 溶き解"
"ときふs 説き伏"
"ときはなt 解き放"
"ときはなs 解き放"
"ときはなc 解き放"
"ときつk 説き付"
"ときおよn 説き及"
"ときおよb 説き及"
"ときあk 解き明 説き明"
"ときn 時"
"ときm 時"
"とがめだt 咎め立"
"とがt 尖"
"とがr 尖"
"とがn 尖"
"とがm 咎"
"とがc 尖"
"とおりぬk 通り抜"
"とおりすi 通り過"
"とおりすg 通り過"
"とおりこs 通り越"
"とおりがk 通り掛"
"とおりかかt 通り掛"
"とおりかかr 通り掛"
"とおりかかn 通り掛"
"とおりかかc 通り掛"
"とおまわs 遠回"
"とおまわr 遠回"
"とおまk 遠巻"
"とおぼe 遠吠"
"とおのr 遠乗"
"とおのk 遠退 遠の"
"とおのi 遠退"
"とおすg 遠過"
"とおz 遠"
"とおt 通 透 徹"
"とおs 通 遠 徹 透"
"とおr 通 透 徹"
"とおn 遠 通 透 徹"
"とおm 遠"
"とおk 遠"
"とおi 遠"
"とおg 遠"
"とおc 通 透 徹"
"とうろくs 登録"
"とうとu 疾う疾"
"とうとs 尊 貴"
"とうとn 尊 貴"
"とうとk 尊 貴"
"とうとi 尊 貴"
"とうとg 尊 貴"
"とうとb 尊 貴"
"とうぜんn 当然"
"とうすg 遠過"
"とうじつうr 当日売"
"とうこうs 投稿"
"とうけつs 凍結"
"とうz 投"
"とうt 通"
"とうs 通 父"
"とうr 通"
"とうn 当"
"とうj 投"
"といなおs 問い直 問直"
"といつm 問い詰 問詰"
"といただs 問い質"
"といかえs 問い返"
"といかk 問い掛 問掛"
"といあわs 問合 問い合わ"
"といあw 問い合 問合"
"とz 閉 綴 閇"
"とw 問 訪"
"とu 問 疾 訪"
"とt 取 採 撮 録 盗 捕 脱 獲 摂 執 穫 秉"
"とs 賭"
"とr 取 撮 採 摂 捕 獲 録 執 盗 穫 脱 秉"
"とp 取"
"とo 問 訪"
"とn 飛 富 跳 翔 取 撮 採 摂 捕 獲 録 執 盗 穫 秉 冨 脱"
"とm 止 泊 富 留 停 冨 畄"
"とk 解 説 溶 融 疾 梳 熔 鎔 觧"
"とj 閉 綴 閇"
"とi 問 解 説 研 觧 訪 溶 梳 熔 鎔 磨 砥"
"とh 問"
"とg 遂 研 磨 砥"
"とe 問 訪"
"とd 綴 閉"
"とc 取 撮 採 摂 捕 獲 録 執 盗 穫 秉 脱"
"とb 飛 跳 翔"
"でんちぎr 電池切"
"でんげんぬk 電源抜"
"でんげんぎr 電源切"
"でんげんいr 電源入"
"でやすs 出易"
"でやすk 出易"
"でやすi 出易"
"でやすg 出易"
"でもどt 出戻"
"でもどr 出戻"
"でもどn 出戻"
"でもどc 出戻"
"でむかe 出迎"
"でむk 出向"
"でむi 出向"
"でまわt 出回"
"でまわr 出回"
"でまわn 出回"
"でまわc 出回"
"でまかs 出任"
"でばらw 出払"
"でばらu 出払"
"でばらt 出払"
"でばらo 出払"
"でばらi 出払"
"でばらe 出払"
"でばらc 出払"
"でばt 出張"
"でばr 出張"
"でばn 出張"
"でばc 出張"
"ではらw 出払"
"ではらu 出払"
"ではらt 出払"
"ではらo 出払"
"ではらi 出払"
"ではらc 出払"
"ではじm 出始"
"ではいr 出入"
"でにくs 出難"
"でにくk 出難"
"でにくi 出難"
"でにくg 出難"
"でなおs 出直"
"でてゆk 出て行"
"でてこz 出て来"
"でてこy 出て来"
"でてこs 出て来"
"でてこr 出て来"
"でてこn 出て来"
"でてこi 出て来"
"でてくr 出て来"
"でてくn 出て来"
"でてきy 出て来"
"でてきt 出て来"
"でてきs 出て来"
"でてきn 出て来"
"でてきm 出て来"
"でてきd 出て来"
"でてきc 出て来"
"でていt 出て行"
"でていk 出て行"
"でていc 出て行"
"でづっぱr 出突っ張"
"でつづk 出続"
"でつくs 出尽"
"でつk 出尽"
"でっぱなs 出っ放"
"でっぱt 出張 出っ張"
"でっぱr 出っ張 出張"
"でっぱn 出っ張 出張"
"でっぱc 出っ張 出張"
"でっちあg 捏ち上 でっち上"
"でだs 出出"
"でたt 出立"
"でぞm 出初"
"でそろw 出揃"
"でそろu 出揃"
"でそろt 出揃"
"でそろo 出揃"
"でそろi 出揃"
"でそろe 出揃"
"でそろc 出揃"
"ですg 出過"
"でしいr 弟子入"
"でくわs 出会"
"でくw 出喰 出食"
"でぎt 出切"
"でぎr 出切"
"でぎn 出切"
"でぎc 出切"
"できばe 出来栄 出来映"
"できなs 出来無"
"できなk 出来無"
"できなi 出来無"
"できなg 出来無"
"できだかばらi 出来高払"
"できそこn 出来損"
"できすg 出来過"
"できあi 出来合"
"できあg 出来上"
"できz 出来"
"できy 出来"
"できw 出来"
"できu 出来"
"できt 出来"
"できs 出来"
"できr 出来"
"できp 出来"
"できo 出来"
"できn 出来"
"できm 出来"
"できk 出来"
"できj 出来"
"できi 出来"
"できh 出来"
"できg 出来"
"できe 出来"
"できd 出来"
"できc 出来"
"できb 出来"
"できa 出来"
"でかせg 出稼"
"でかけr 出掛け"
"でかs 出来 デカ"
"でかm デカ"
"でかk 出掛 デカ"
"でかi デカ"
"でかg デカ"
"でおくr 出遅"
"でいr 出入"
"であるk 出歩"
"であるi 出歩"
"であw 出会 出逢 出合"
"であu 出会 出逢 出合"
"であt 出会 出逢 出合"
"であo 出会 出逢 出合"
"であi 出会 出逢 出合"
"であe 出会 出逢 出合"
"であc 出会 出逢 出合"
"でz 出"
"でy 出"
"でw 出"
"でu 出"
"でt 出 照"
"でs 出"
"でr 出 照"
"でp 出"
"でo 出"
"でn 出 照"
"でm 出"
"でk 出"
"でj 出"
"でi 出"
"でh 出"
"でg 出"
"でe 出"
"でd 出"
"でc 出 照"
"でb 出"
"でa 出"
"てんぷいたs 添付致"
"てんびk 天引"
"てんぱt テンパ"
"てんぱr テンパ"
"てんぱn テンパ"
"てんぱc テンパ"
"てんばいかいもどs 転売買戻"
"てんとr 点取"
"てんたかk 天高"
"てんこもr 天こ盛"
"てんかいs 展開"
"てんz 転 点"
"てんj 転 点"
"てをだs 手を出"
"てわたs 手渡"
"てわk 手分"
"てれくさs 照れ臭"
"てれくさk 照れ臭"
"てれくさi 照れ臭"
"てれくさg 照れ臭"
"てりはe 照り映"
"てりつk 照り付"
"てりこn 照り込"
"てりこm 照り込"
"てりかがやk 照り輝"
"てりかがやi 照り輝"
"てりかえs 照り返"
"てらしあわs 照らし合 照し合"
"てらしあw 照らし合 照し合"
"てらw 衒"
"てらu 衒"
"てらt 衒"
"てらs 照"
"てらo 衒"
"てらi 衒"
"てらh 衒"
"てらe 衒"
"てらc 衒"
"てやわらk 手柔"
"てやわr 手柔"
"てもどr 手戻"
"てもt 手持"
"てもc 手持"
"てむk 手向"
"てまわs 手回"
"てまねk 手招"
"てまどt 手間取"
"てまどr 手間取"
"てまどn 手間取"
"てまどc 手間取"
"てほどk 手解"
"てぶr 手振 手ぶ"
"てびろs 手広"
"てびろk 手広"
"てびろi 手広"
"てびかe 手控"
"てびk 手引"
"てひどs 手酷"
"てひどk 手酷"
"てひどi 手酷"
"てひどg 手酷"
"てばやs 手早"
"てばやk 手早"
"てばやi 手早"
"てばやg 手早"
"てばなs 手放 手離"
"てはじm 手始"
"てぬるs 手緩"
"てぬるk 手緩"
"てぬるi 手緩"
"てぬるg 手緩"
"てぬk 手抜"
"てにはいt 手に入"
"てにはいr 手に入"
"てにはいn 手に入"
"てにはいc 手に入"
"てにいr 手に入"
"てならi 手習"
"てなずk 手懐"
"てなおs 手直"
"てなr 手慣"
"てどr 手取"
"てとりあしとr 手取り足取"
"てとr 手取"
"てづよs 手強"
"てづよk 手強"
"てづよi 手強"
"てづよg 手強"
"てづまr 手詰"
"てづくr 手作"
"てづかm 手掴"
"てづm 手詰"
"てつやあk 徹夜明"
"てつづk 手続"
"てつだw 手伝"
"てつだu 手伝"
"てつだt 手伝"
"てつだo 手伝"
"てつだi 手伝"
"てつだe 手伝"
"てつだc 手伝"
"てつk 手付"
"てっとりばやs 手っ取り早"
"てっとりばやk 手っ取り早"
"てっとりばやi 手っ取り早"
"てっとりばやg 手っ取り早"
"てっとr 手っ取"
"てっs 徹"
"てぢかn 手近"
"てちがi 手違"
"てだすk 手助"
"てだt 手立 手出"
"てだs 手出"
"てだr 手練"
"てすr 手摺"
"てじm 手締"
"てざわr 手触"
"てざs 手差"
"てさばk 手捌"
"てさぐr 手探"
"てさs 手差"
"てさg 手提"
"てごわs 手強"
"てごわk 手強"
"てごわi 手強"
"てごわg 手強"
"てごたh 手應"
"てごたe 手応 手應"
"てこずt 梃摺"
"てこずr 梃摺"
"てこずn 梃摺"
"てこずc 梃摺"
"てこいr 梃入 テコ入"
"てくらg 手暗"
"てくばr 手配"
"てぎわよs 手際良"
"てぎわよk 手際良"
"てぎわよi 手際良"
"てぎr 手切"
"てきびs 手厳"
"てきとうn 適当"
"てきs 適 敵"
"てきn 的"
"てきd 的"
"てがたs 手堅"
"てがたk 手堅"
"てがたi 手堅"
"てがたg 手堅"
"てがかr 手掛"
"てがk 手書 手掛 手懸"
"ておくr 手遅"
"ておt 手落"
"ておs 手押"
"ておi 手負"
"ておc 手落"
"てうt 手打"
"ていよk 体良"
"ていたs 手痛"
"ていたk 手痛"
"ていたi 手痛"
"ていたg 手痛"
"ていせいいたs 訂正致"
"ていしいたs 停止致"
"ていぎづk 定義付"
"ていきょうs 提供"
"ていs 呈 挺 訂 締"
"ていr 手入"
"てあらs 手荒"
"てあらk 手荒 手粗"
"てあらi 手洗 手荒"
"てあらg 手荒"
"てあぶr 手焙"
"てあつs 手厚"
"てあつk 手厚"
"てあつi 手厚"
"てあつg 手厚"
"てあw 手合"
"てあt 手当"
"てあm 手編"
"てあi 手合"
"てあg 手上"
"てz 手"
"てt 照"
"てr 照"
"てn 手 照"
"てm 手"
"てg 手"
"てd 手"
"てc 照"
"づらs 辛"
"づらk 辛"
"づらi 辛"
"づらg 辛"
"づよs 強"
"づよk 強"
"づよi 強"
"づよg 強"
"づとm 勤"
"づつn 包"
"づつm 包"
"づたi 伝"
"づくs 尽"
"づくr 作 造 做"
"づきあi 付き合"
"づかr 疲"
"づかi 遣 使"
"づr 連 釣 吊"
"づm 積 詰"
"づk 付 漬 突"
"づi 付"
"つんぼs 聾"
"つんぼn 聾"
"つんぼd 聾"
"つんざk 劈"
"つんざi 劈"
"つれもどt 連れ戻"
"つれもどs 連れ戻"
"つれもどr 連れ戻"
"つれもどn 連れ戻"
"つれもどc 連れ戻"
"つれまわs 連れ回"
"つれてゆk 連れて行"
"つれてこz 連れて来"
"つれてこy 連れて来"
"つれてこs 連れて来"
"つれてこr 連れて来"
"つれてこn 連れて来"
"つれてこi 連れて来"
"つれてくr 連れて来"
"つれてくn 連れて来"
"つれてきy 連れて来"
"つれてきt 連れて来"
"つれてきs 連れて来"
"つれてきn 連れて来"
"つれてきm 連れて来"
"つれてきd 連れて来"
"つれてきc 連れて来"
"つれていt 連れて行"
"つれていk 連れて行"
"つれていc 連れて行"
"つれだt 連れ立"
"つれだs 連れ出"
"つれだc 連れ立"
"つれそw 連れ添"
"つれそu 連れ添"
"つれそt 連れ添"
"つれそo 連れ添"
"つれそi 連れ添"
"つれそe 連れ添"
"つれそc 連れ添"
"つれさt 連れ去"
"つれさr 連れ去"
"つれさn 連れ去"
"つれさc 連れ去"
"つれこn 連れ込 連込"
"つれこm 連れ込 連込"
"つれかえt 連れ帰"
"つれかえr 連れ帰"
"つれかえn 連れ帰"
"つれかえc 連れ帰"
"つれあi 連れ合"
"つるしあg 吊るし上"
"つるs 吊"
"つるn 交尾 連"
"つるm 連 交尾"
"つりだs 釣り出 吊り出"
"つりさg 吊り下"
"つりこn 釣り込"
"つりこm 釣り込"
"つりあw 釣り合 釣合"
"つりあu 釣り合 釣合"
"つりあt 釣り合 釣合"
"つりあo 釣り合 釣合"
"つりあi 釣り合 釣合"
"つりあg 釣り上 吊り上 釣上"
"つりあe 釣り合 釣合"
"つりあc 釣り合 釣合"
"つらよごs 面汚"
"つらぬきとおs 貫き通"
"つらぬk 貫"
"つらぬi 貫"
"つらがまe 面構"
"つらあt 面当"
"つらs 辛 ツラ"
"つらn 連 列"
"つらk 辛 ツラ"
"つらi 辛 ツラ"
"つらg 辛 ツラ"
"つよすg 強過"
"つよs 強"
"つよm 強"
"つよk 強"
"つよi 強"
"つよg 強"
"つゆはらi 露払"
"つやがたr 艶語"
"つやy 艶"
"つやp 艶"
"つもりつm 積もり積"
"つもt 積"
"つもr 積"
"つもn 積"
"つもc 積"
"つめよt 詰め寄"
"つめよr 詰め寄"
"つめよn 詰め寄"
"つめよc 詰め寄"
"つめたs 冷"
"つめたk 冷"
"つめたi 冷"
"つめたg 冷"
"つめこn 詰め込"
"つめこm 詰め込"
"つめかk 詰め掛"
"つめかe 詰め替"
"つめあわs 詰め合 詰合"
"つめあw 詰め合"
"つめt 冷 詰"
"つめr 詰"
"つめn 詰"
"つむt 瞑"
"つむr 瞑"
"つむn 瞑"
"つむi 紡"
"つむg 紡"
"つむc 瞑"
"つみまs 積み増 積増"
"つみほr 罪滅"
"つみぶかs 罪深"
"つみぶかk 罪深"
"つみぶかi 罪深"
"つみぶかg 罪深"
"つみのこs 積み残 積残"
"つみなおs 積み直 積直"
"つみとt 摘み取"
"つみとr 摘み取"
"つみとn 摘み取"
"つみとc 摘み取"
"つみつくr 罪作"
"つみだs 積み出"
"つみたt 積立 積み立"
"つみこn 積み込"
"つみこm 積み込"
"つみかさn 積み重 積重"
"つみかe 積み替 積替"
"つみおr 積み降"
"つみあg 積み上 積上"
"つみs 罪"
"つみn 罪"
"つみd 罪"
"つまみだs 撮み出"
"つまみぐi 撮み食"
"つまびr 詳 審"
"つまびk 爪弾"
"つまびi 爪弾"
"つまはじk 爪弾"
"つまどt 褄取"
"つまどr 褄取"
"つまどn 褄取"
"つまどc 褄取"
"つまづk 躓"
"つまづi 躓"
"つまずk 躓"
"つまずi 躓"
"つまさきだt 爪先立"
"つまさきだc 爪先立"
"つまt 詰"
"つまs 倹 約"
"つまr 詰"
"つまn 撮 摘 抓 詰"
"つまm 摘 抓 撮"
"つぼn 蕾 窄"
"つぼm 蕾 窄"
"つぶらs 円"
"つぶらn 円"
"つぶらd 円"
"つぶよr 粒選"
"つぶやk 呟"
"つぶやi 呟"
"つぶひとt 粒一"
"つぶだt 粒立"
"つぶだc 粒立"
"つぶぞろi 粒揃"
"つぶしあw 潰し合"
"つぶしあu 潰し合"
"つぶしあt 潰し合"
"つぶしあo 潰し合"
"つぶしあi 潰し合"
"つぶしあe 潰し合"
"つぶしあc 潰し合"
"つぶt 瞑"
"つぶs 潰"
"つぶr 潰 瞑 円"
"つぶn 瞑"
"つぶc 瞑"
"つひe 潰 費 幣"
"つばめがえs 燕返"
"つばs 唾"
"つのt 募"
"つのr 募"
"つのn 募"
"つのc 募"
"つねt 抓"
"つねr 抓"
"つねn 常 抓"
"つねc 抓"
"つなわたr 綱渡"
"つなひk 綱引"
"つなぎなおs 繋ぎ直"
"つなぎとm 繋ぎ止"
"つなぎこn 繋ぎ込"
"つなぎこm 繋ぎ込"
"つなぎかe 継ぎ換"
"つながt 繋"
"つながr 繋"
"つながn 繋"
"つながc 繋"
"つなi 繋 継 繼"
"つなg 繋 継 繼"
"つどw 集"
"つどu 集"
"つどt 集"
"つどo 集"
"つどi 集"
"つどh 集"
"つどe 集"
"つどc 集"
"つとめあg 勤め上"
"つとn 夙"
"つとm 努 務 勤 勉 力"
"つづりあw 綴り合"
"つづまy 約"
"つづt 綴"
"つづr 綴"
"つづn 綴"
"つづm 約"
"つづk 続 續"
"つづi 続 續"
"つづc 綴"
"つつみこn 包み込"
"つつみこm 包み込"
"つつみかくs 包み隠"
"つつまs 慎"
"つつぬk 筒抜"
"つつしみぶかs 慎み深"
"つつしみぶかk 慎み深"
"つつしみぶかi 慎み深"
"つつしみぶかg 慎み深"
"つつしn 慎 謹 愼"
"つつしm 慎 謹 愼"
"つつがなs 恙無"
"つつがなk 恙無"
"つつがなi 恙無"
"つつがなg 恙無"
"つつs 慎 謹"
"つつn 包 慎 裹 障 恙"
"つつm 包 慎 裹 障 恙"
"つつk 突 突突"
"つつi 突 突突"
"つっぷs 突っ伏"
"つっぱなs 突っ放"
"つっぱしt 突っ走"
"つっぱしr 突っ走"
"つっぱしn 突っ走"
"つっぱしc 突っ走"
"つっぱt 突っ張 突張"
"つっぱr 突っ張 突張"
"つっぱn 突っ撥 突っ張 突張"
"つっぱc 突っ張 突張"
"つっつk 突っ突"
"つっつi 突っ突"
"つったt 突っ立"
"つったc 突っ立"
"つっこn 突っ込 突込"
"つっこm 突っ込 突込"
"つっきt 突っ切"
"つっきr 突っ切"
"つっきn 突っ切"
"つっきc 突っ切"
"つっかえs 突っ返"
"つっかk 突っ掛"
"つっかh 支 閊"
"つっかe 支 閊"
"つちふr 霾 土降"
"つちかw 培"
"つちかu 培"
"つちかt 培"
"つちかo 培"
"つちかi 培"
"つちかe 培"
"つちかc 培"
"つだw 伝 傳"
"つだu 伝 傳"
"つだt 伝 傳"
"つだo 伝 傳"
"つだi 伝 傳"
"つだe 伝 傳"
"つだc 伝 傳"
"つたなs 拙"
"つたなk 拙"
"つたなi 拙"
"つたなg 拙"
"つたえきk 伝え聞"
"つたえきi 伝え聞"
"つたw 伝 傳"
"つたu 伝 傳"
"つたt 伝 傳"
"つたo 伝 傳"
"つたi 伝 傳"
"つたh 伝 傳"
"つたe 伝 傳"
"つたc 伝 傳"
"つずr 綴"
"つじつまあw 辻褄合"
"つごうよs 都合良"
"つごうよk 都合良"
"つごうよi 都合良"
"つこうまつt 仕"
"つこうまつr 仕"
"つこu 使"
"つげしr 告げ知"
"つけわすr 付け忘"
"つけまわs 付け回"
"つけねらw 付け狙"
"つけねらu 付け狙"
"つけねらt 付け狙"
"つけねらo 付け狙"
"つけねらi 付け狙"
"つけねらe 付け狙"
"つけねらc 付け狙"
"つけっぱなs 付けっ放"
"つけだs 付け出"
"つけたs 付け足"
"つけこn 付け込 漬け込"
"つけこm 付け込 漬け込"
"つけくわw 付け加"
"つけくわe 付け加"
"つけかe 付け替"
"つけいt 付け入"
"つけいr 付け入"
"つけいn 付け入"
"つけいc 付け入"
"つけあわs 付け合"
"つけあw 付け合"
"つけあg 付け上"
"つぐなw 償"
"つぐなu 償"
"つぐなt 償"
"つぐなo 償"
"つぐなi 償"
"つぐなe 償"
"つぐなc 償"
"つぐn 噤 鉗"
"つぐm 噤 鉗"
"つくろw 繕"
"つくろu 繕"
"つくろt 繕"
"つくろo 繕"
"つくろi 繕"
"つくろh 繕"
"つくろe 繕"
"つくろc 繕"
"つくりはじm 作り始"
"つくりなおs 作り直 造り直 創り直"
"つくりつづk 作り続"
"つくりつk 作り付"
"つくりだs 作り出 創り出"
"つくりそこn 作り損"
"つくりこn 作り込"
"つくりこm 作り込"
"つくりかe 作り替 作り変 創り変"
"つくりおk 作り置"
"つくりおi 作り置"
"つくりあg 作り上"
"つくらh 繕"
"つくばt 蹲"
"つくばr 蹲"
"つくばn 蹲"
"つくばc 蹲"
"つくt 作 創 造 做"
"つくs 尽 盡 殲 殱"
"つくr 作 創 造 做"
"つくn 捏 作 創 造 做"
"つくc 作 創 造 做"
"つぎわk 注ぎ分"
"つぎたs 継ぎ足 注ぎ足"
"つぎこn つぎ込 注ぎ込"
"つぎこm つぎ込 注ぎ込"
"つぎn 次"
"つきやぶt 突き破"
"つきやぶr 突き破"
"つきやぶn 突き破"
"つきやぶc 突き破"
"つきまとw 付き纏"
"つきまとu 付き纏"
"つきまとt 付き纏"
"つきまとo 付き纏"
"つきまとi 付き纏"
"つきまとe 付き纏"
"つきまとc 付き纏"
"つきばらi 月払"
"つきはなs 突き放"
"つきはじm 月初 月始"
"つきはt 尽き果"
"つきぬk 突き抜"
"つきとおs 突き通"
"つきとm 突き止"
"つきとb 突き飛"
"つきでy 突き出"
"つきでt 突き出"
"つきでr 突き出"
"つきでn 突き出"
"つきでm 突き出"
"つきづk 付き付"
"つきつm 突き詰"
"つきつk 突き付"
"つきっきr 付きっ切"
"つきだs 突き出 突出"
"つきたt 突き立"
"つきそw 付き添 付添"
"つきそu 付き添 付添"
"つきそt 付き添 付添"
"つきそo 付き添 付添"
"つきそi 付き添 付添"
"つきそe 付き添 付添"
"つきそc 付き添 付添"
"つきすすn 突き進"
"つきすすm 突き進"
"つきしたがw 付き従"
"つきしたがu 付き従"
"つきしたがt 付き従"
"つきしたがo 付き従"
"つきしたがi 付き従"
"つきしたがe 付き従"
"つきしたがc 付き従"
"つきさs 突き刺"
"つきころs 突き殺"
"つきくずs 突き崩"
"つきぎr 月切"
"つきぎm 月極"
"つきがk 月掛"
"つきかえs 突き返"
"つきおとs 突き落"
"つきおくr 月遅"
"つきおt 突き落"
"つきうごk 突き動 衝き動"
"つきあわs 突き合"
"つきあw 突き合 付き合 付合"
"つきあu 付き合 付合"
"つきあt 付き合 突き当 付合"
"つきあo 付き合 付合"
"つきあk 月明"
"つきあi 付き合 付合"
"つきあg 突き上"
"つきあe 付き合 付合"
"つきあc 付き合 付合"
"つきm 拒"
"つがw 番"
"つがu 番"
"つがt 番"
"つがo 番"
"つがi 番"
"つがh 番"
"つがe 番"
"つがc 番"
"つかれはt 疲れ果"
"つかれきt 疲れ切"
"つかれきr 疲れ切"
"つかれきn 疲れ切"
"つかれきc 疲れ切"
"つかみとt 掴み取"
"つかみとr 掴み取"
"つかみとn 掴み取"
"つかみとc 掴み取"
"つかみだs 掴み出"
"つかみあw 掴み合"
"つかみあu 掴み合"
"つかみあt 掴み合"
"つかみあo 掴み合"
"つかみあi 掴み合"
"つかみあc 掴み合"
"つかまつt 仕"
"つかまつr 仕"
"つかまつn 仕"
"つかまつc 仕"
"つかさどt 司 掌"
"つかさどr 司 掌"
"つかさどn 司 掌"
"つかさどc 司 掌"
"つかうまつt 仕"
"つかうまつr 仕"
"つかうまつn 仕"
"つかうまつc 仕"
"つかいわk 使い分"
"つかいやすs 使い易"
"つかいやすk 使い易"
"つかいやすi 使い易"
"つかいやすg 使い易"
"つかいまわs 使い回"
"つかいふるs 使い古"
"つかいばしr 使い走"
"つかいはじm 使い始"
"つかいはt 使い果"
"つかいのこs 使い残"
"つかいにくs 使い難"
"つかいにくk 使い難"
"つかいにくi 使い難"
"つかいにくg 使い難"
"つかいなr 使い慣 使い馴"
"つかいづらs 使い辛"
"つかいづらk 使い辛"
"つかいづらi 使い辛"
"つかいづらg 使い辛"
"つかいつづk 使い続"
"つかいつk 使い尽"
"つかいだs 使い出"
"つかいすt 使い捨"
"つかいこなs 使い熟"
"つかいこn 使い込"
"つかいこm 使い込"
"つかいきt 使い切"
"つかいきr 使い切"
"つかいきn 使い切"
"つかいきc 使い切"
"つかいおw 使い終"
"つかいおe 使い終"
"つかw 使 遣"
"つかu 使 遣"
"つかt 使 遣"
"つかr 疲"
"つかo 使 遣"
"つかn 掴 束 把 攫"
"つかm 掴 捕 捉 把 攫"
"つかi 使 遣"
"つかh 遣 仕 使 支 閊"
"つかe 使 仕 支 閊 障 遣"
"つかc 使 遣"
"つうほうs 通報"
"つうじあw 通じ合"
"つうじあu 通じ合"
"つうじあt 通じ合"
"つうじあo 通じ合"
"つうじあi 通じ合"
"つうじあe 通じ合"
"つうじあc 通じ合"
"つうz 通"
"つうj 通"
"ついやs 費 費や"
"ついてまわt 付いて回"
"ついてまわr 付いて回"
"ついてまわn 付いて回"
"ついてまわc 付いて回"
"ついえさt 潰え去"
"ついえさr 潰え去"
"ついえさn 潰え去"
"ついえさc 潰え去"
"ついy 費"
"ついt 就 ツイ"
"ついn 遂 対"
"ついe 潰 費 弊"
"ついd 序"
"ついb 啄"
"つt 釣 吊 突 攣"
"つr 連 釣 吊 攣"
"つn 積 摘 詰 釣 吊 攣"
"つm 詰 積 摘"
"つk 付 着 突 漬 尽 就 点 吐 衝 憑 撞 搗 尾 築 附 浸 盡 點"
"つi 付 着 突 継 憑 次 就 附 点 繼 吐 衝 撞 搗 築 點 注 接 嗣 椄 支"
"つg 継 注 次 告 接 嗣 椄 繼"
"つc 釣 吊 攣"
"ぢs 持"
"ちんさg 賃下"
"ちんがs 賃貸"
"ちんがr 賃借"
"ちんあg 賃上"
"ちりばm 鏤"
"ちりぢr 散り散"
"ちょんぎt ちょん切"
"ちょんぎr ちょん切"
"ちょんぎn ちょん切"
"ちょんぎc ちょん切"
"ちょくせんみとおs 直線見通"
"ちょくせついt 直接行"
"ちょくせついk 直接行"
"ちょくせついc 直接行"
"ちょくn 直"
"ちょくd 直"
"ちょうむすb 蝶結"
"ちょうどよs 丁度良"
"ちょうどよk 丁度良"
"ちょうどよi 丁度良"
"ちょうどよg 丁度良"
"ちょうしわるs 調子悪"
"ちょうしわるk 調子悪"
"ちょうしわるi 調子悪"
"ちょうしわるg 調子悪"
"ちょうしよs 調子良"
"ちょうしよk 調子良"
"ちょうしよi 調子良"
"ちょうしよg 調子良"
"ちょうけs 帳消"
"ちょうz 長"
"ちょうs 徴 朝 弔 寵"
"ちょうj 長"
"ちゅうもんとr 注文取"
"ちゅうづr 宙吊"
"ちゅうちょなk 躊躇無"
"ちゅうしs 中止"
"ちゅうこうr 中古売"
"ちゅうがえr 宙返"
"ちゅうかんあたr 中間辺"
"ちゅうおうよs 中央寄"
"ちゅうおうどおr 中央通"
"ちゅういぶかs 注意深"
"ちゅういぶかk 注意深"
"ちゅういぶかi 注意深"
"ちゅういぶかg 注意深"
"ちゅういがk 注意書"
"ちゅういs 注意"
"ちゅうs 注 註 誅 沖 冲"
"ちゃのm 茶飲"
"ちゃづk 茶漬"
"ちゃくばらi 着払"
"ちゃくs 着"
"ちゃくm 茶汲"
"ちゃかs 茶化"
"ちゃうk 茶請"
"ちゃいろs 茶色"
"ちゃいろp 茶色"
"ちゃいろk 茶色"
"ちゃいろi 茶色"
"ちゃいろg 茶色"
"ちゃp 茶"
"ちまよw 血迷"
"ちまよu 血迷"
"ちまよt 血迷"
"ちまよo 血迷"
"ちまよi 血迷"
"ちまよe 血迷"
"ちまよc 血迷"
"ちばなr 乳離"
"ちばしt 血走"
"ちばしr 血走"
"ちばしn 血走"
"ちばしc 血走"
"ちぬt 釁 血塗"
"ちぬr 血塗 釁"
"ちぬn 血塗 釁"
"ちぬc 血塗 釁"
"ちなまぐさs 血腥 血生臭"
"ちなまぐさk 血腥 血生臭"
"ちなまぐさi 血腥 血生臭"
"ちなまぐさg 血腥 血生臭"
"ちなn 因"
"ちなm 因"
"ちつじょだt 秩序立"
"ちつじょだc 秩序立"
"ちっt 些"
"ちぢみこn 縮み込"
"ちぢみこm 縮み込"
"ちぢみあg 縮み上"
"ちぢr 縮"
"ちぢn 縮"
"ちぢm 縮"
"ちぢk 縮"
"ちちばなr 乳離"
"ちちくりあw 乳繰り合"
"ちちくりあu 乳繰り合"
"ちちくりあt 乳繰り合"
"ちちくりあo 乳繰り合"
"ちちくりあi 乳繰り合"
"ちちくりあe 乳繰り合"
"ちちくりあc 乳繰り合"
"ちちくさs 乳臭"
"ちちくさk 乳臭"
"ちちくさi 乳臭"
"ちちくさg 乳臭"
"ちちくt 乳繰"
"ちちくr 乳繰"
"ちちくn 乳繰"
"ちちくc 乳繰"
"ちちおやごろs 父親殺"
"ちぞm 血染"
"ちじn 縮"
"ちじm 縮"
"ちこu 近"
"ちぎt 千切 契"
"ちぎr 千切 契"
"ちぎn 千切 契"
"ちぎc 千切 契"
"ちがw 違 交"
"ちがu 違 交"
"ちがt 違 交"
"ちがo 違 交"
"ちがi 違 交"
"ちがh 違 交"
"ちがe 違 交"
"ちがc 違 交"
"ちからもt 力持"
"ちからもc 力持"
"ちからまかs 力任"
"ちからなs 力無"
"ちからなk 力無"
"ちからなi 力無"
"ちからづよs 力強"
"ちからづよk 力強"
"ちからづよi 力強"
"ちからづよg 力強"
"ちからづk 力付"
"ちからつk 力尽"
"ちからぞe 力添"
"ちかよt 近寄"
"ちかよs 近寄"
"ちかよr 近寄"
"ちかよn 近寄"
"ちかよc 近寄"
"ちかづs 近付"
"ちかづk 近付"
"ちかづi 近付"
"ちかづg 近付"
"ちかすg 近過"
"ちかいあw 誓い合"
"ちかいあu 誓い合"
"ちかいあt 誓い合"
"ちかいあo 誓い合"
"ちかいあi 誓い合"
"ちかいあe 誓い合"
"ちかいあc 誓い合"
"ちかw 誓 盟"
"ちかu 誓 盟"
"ちかt 誓 盟"
"ちかs 近 親 誓"
"ちかo 誓 盟"
"ちかk 近 誓"
"ちかi 近 誓 盟"
"ちかh 誓 盟"
"ちかg 近 誓"
"ちかe 誓 盟"
"ちかd 近"
"ちかc 誓 盟"
"ちいさn 小さ"
"ちいさk 小"
"ちいs 小"
"ちt 散"
"ちs 小 治"
"ちr 散"
"ちn 散"
"ちk 小"
"ちg 血"
"ちc 散"
"ちb 禿"
"だんどr 段取"
"だんとr 段取"
"だんづk 段付"
"だんちがi 段違"
"だんせいむk 男性向"
"だんじこn 談じ込"
"だんじこm 談じ込"
"だんぐm 段組"
"だんくm 段組"
"だんz 断 談 弾"
"だんj 断 談 弾"
"だれかれかまw 誰彼構"
"だれw 誰"
"だれt 誰"
"だれn 誰"
"だれm 誰"
"だれk 誰"
"だれg 誰"
"だれd 誰"
"だるs ダル 怠 懶"
"だるk 怠 懶 ダル"
"だるi 怠 懶 ダル"
"だるg 怠 懶 ダル"
"だよr 便 頼"
"だめづm 駄目詰"
"だめおs 駄目押"
"だめp 駄目"
"だまりこn 黙り込"
"だまりこm 黙り込"
"だましこn 騙し込"
"だましこm 騙し込"
"だましうt 騙し討"
"だまt 黙 默"
"だまs 騙"
"だまr 黙 溜 默"
"だまn 黙 默"
"だまc 黙 默"
"だべt 駄弁"
"だべr 駄弁"
"だべn 駄弁"
"だべc 駄弁"
"だぶt ダブ"
"だぶr ダブ"
"だぶn ダブ"
"だぶc ダブ"
"だっs 脱"
"だっk 抱っ"
"だだっぴろs だだっ広"
"だだっぴろk だだっ広"
"だだっぴろi だだっ広"
"だだっぴろg だだっ広"
"だしぬk 出し抜"
"だしぬi 出し抜"
"だしっぱなs 出しっ放"
"だししぶt 出し渋"
"だししぶr 出し渋"
"だししぶn 出し渋"
"だししぶc 出し渋"
"だしきt 出し切"
"だしきr 出し切"
"だしきn 出し切"
"だしきc 出し切"
"だしおs 出し惜"
"だしいr 出し入"
"だしあw 出し合"
"だしあu 出し合"
"だしあt 出し合"
"だしあo 出し合"
"だしあi 出し合"
"だしあe 出し合"
"だしあc 出し合"
"だくs 諾"
"だきよs 抱き寄"
"だきとt 抱き取"
"だきとr 抱き取"
"だきとn 抱き取"
"だきとm 抱き留"
"だきとc 抱き取"
"だきつk 抱き付"
"だきつi 抱き付"
"だきすくm 抱き竦"
"だきしm 抱き締"
"だきこn 抱き込"
"だきこm 抱き込"
"だきかかe 抱き抱"
"だきおこs 抱き起"
"だきおr 抱き下"
"だきあわs 抱き合"
"だきあw 抱き合"
"だきあu 抱き合"
"だきあt 抱き合"
"だきあo 抱き合"
"だきあi 抱き合"
"だきあg 抱き上"
"だきあe 抱き合"
"だきあc 抱き合"
"だおs 倒"
"だおr 倒"
"だいめいどおr 題名通"
"だいぶちがu 大分違"
"だいびk 代引"
"だいなs 台無"
"だいっきらi 大っ嫌"
"だいたいおなz 大体同"
"だいたいおなj 大体同"
"だいすk 大好"
"だいきらi 大嫌"
"だいs 題"
"だt 立 建"
"だs 出 堕"
"だr 垂"
"だm 溜 澑"
"だk 抱 炊"
"だi 抱"
"だc 立"
"たんせいこm 丹精込"
"たんじゅんn 単純"
"たんいじかんあt 単位時間当"
"たんz 嘆 歎"
"たんn 単 單"
"たんj 嘆 歎"
"たをr 手折"
"たをm 撓"
"たわむr 戯 戲"
"たわぶr 戯"
"たわいなs たわい無"
"たわいなk たわい無"
"たわいなi たわい無"
"たわw 撓"
"たわn 撓"
"たわm 撓"
"たわk 戯"
"たれながs 垂れ流"
"たれさg 垂れ下"
"たれこn 垂れ込"
"たれこm 垂れ込 垂れ籠"
"たるs タル"
"たるn 弛"
"たるm 弛"
"たるk タル"
"たるi タル"
"たるg タル"
"たらしこn 誑し込"
"たらしこm 誑し込"
"たらいまわs 盥回"
"たらz 足ら"
"たらs 誑 蕩"
"たよりなs 頼り無"
"たよりなk 頼り無"
"たよりなi 頼り無"
"たよt 頼 便"
"たよr 頼 便"
"たよn 頼 便"
"たよc 頼 便"
"たゆたw 揺蕩"
"たゆたu 揺蕩"
"たゆたt 揺蕩"
"たゆたo 揺蕩"
"たゆたi 揺蕩"
"たゆたh 揺蕩"
"たゆたe 揺蕩"
"たゆたc 揺蕩"
"たゆn 弛"
"たゆm 弛"
"たやすs 容易"
"たやすk 容易"
"たやすi 容易"
"たやすg 容易"
"たもちつづk 保ち続"
"たもt 保"
"たもc 保"
"ためらw 躊躇 猶豫"
"ためらu 躊躇 猶豫"
"ためらt 躊躇 猶豫"
"ためらo 躊躇 猶豫"
"ためらi 躊躇 猶豫"
"ためらh 躊躇 猶豫"
"ためらe 躊躇 猶豫"
"ためらc 躊躇 猶豫"
"ためしずr 試し刷"
"ためこn 溜め込"
"ためこm 溜め込"
"ためs 試"
"ためn 為 爲"
"ためd 為"
"たむろs 屯"
"たむk 手向"
"たまわt 賜 承"
"たまわr 賜 承"
"たまわn 賜 承"
"たまわc 賜 承"
"たまりかn 堪り兼"
"たまよk 弾除"
"たまつk 玉突"
"たまだs 玉出"
"たまげt 魂消"
"たまげr 魂消"
"たまげn 魂消"
"たまげc 魂消"
"たまぎr 弾切 魂消"
"たまきt 玉木"
"たまいr 玉入"
"たまw 賜 給"
"たまu 給 賜"
"たまt 溜 澑 給 賜 堪"
"たまs 偶"
"たまr 溜 堪 澑"
"たまo 給 賜"
"たまn 偶 溜 堪 澑"
"たまi 給 賜"
"たまh 給 賜"
"たまe 給 賜"
"たまc 給 賜 溜 澑"
"たべはじm 食べ始"
"たべのこs 食べ残"
"たべつづk 食べ続"
"たべつくs 食べ尽"
"たべちr 食べ散"
"たべそこn 食べ損"
"たべすg 食べ過"
"たべくらb 食べ比"
"たべきt 食べ切"
"たべきr 食べ切"
"たべきn 食べ切"
"たべきc 食べ切"
"たべかk 食べ掛"
"たべおw 食べ終"
"たべおe 食べ終"
"たべあわs 食べ合"
"たべあるk 食べ歩"
"たべあるi 食べ歩"
"たべあw 食べ合"
"たべあk 食べ飽"
"たべt 食べ"
"たべr 食べ"
"たぶらk 誑"
"たふとs 貴 尊"
"たふとm 貴 尊"
"たふとk 貴 尊"
"たふとi 貴 尊"
"たふとg 貴 尊"
"たふs 倒"
"たふr 倒 斃"
"たびゆk 旅行"
"たびなr 旅慣"
"たびだt 旅立"
"たびだc 旅立"
"たびかさn 度重"
"たびs 旅"
"たばなs 手放"
"たばさn 手挟 手挾"
"たばさm 手挟 手挾"
"たばかt 謀"
"たばかr 謀"
"たばかn 謀"
"たばかc 謀"
"たばn 束"
"たはむr 戲"
"たのもs 頼も"
"たのみこn 頼み込"
"たのみこm 頼み込"
"たのs 楽 愉 娯 樂"
"たのn 頼 恃"
"たのm 頼 恃"
"たねまk 種蒔 種播"
"たねぎr 種切"
"たねあかs 種明"
"たねあk 種明"
"たにまわr 谷回"
"たなびk 棚引"
"たなびi 棚引"
"たなざらs 店晒"
"たなおろs 棚卸"
"たなあg 棚上"
"たどりつk 辿り着"
"たどりつi 辿り着"
"たどt 辿 到"
"たどr 辿"
"たどn 辿"
"たどc 辿"
"たとh 喩 譬"
"たとe 例 喩 譬"
"たでくu 蓼食"
"たてめぐt 立て巡"
"たてめぐr 立て巡"
"たてめぐn 立て巡"
"たてめぐc 立て巡"
"たてまつt 奉"
"たてまつr 奉"
"たてまつn 奉"
"たてまつc 奉"
"たてまs 建増 建て増"
"たてなおs 立て直 建て直 立直 建直"
"たてとおs 立て通"
"たてつづk 立て続"
"たてつk 建て付 楯突 建付 盾突"
"たてつi 楯突 盾突"
"たてこもt 立て籠"
"たてこもr 立て籠"
"たてこもn 立て籠"
"たてこもc 立て籠"
"たてこn 立て込 建て込"
"たてこm 立て込 建て込"
"たてぐm 縦組"
"たてきt 立て切 閉て切"
"たてきr 立て切 閉て切"
"たてきn 立て切 閉て切"
"たてきc 立て切 閉て切"
"たてがk 縦書"
"たてかk 立て掛"
"たてかe 立て替 建て替 建替 立替"
"たづさh 攜 携"
"たづくr 田作"
"たづn 尋 訊 訪"
"たっとs 尊 貴"
"たっとn 尊 貴"
"たっとk 尊 貴"
"たっとi 尊 貴"
"たっとg 尊 貴"
"たっとb 尊 貴"
"たっせいs 達成"
"たっs 達 逹"
"たちよt 立ち寄 立寄"
"たちよr 立ち寄 立寄"
"たちよn 立ち寄 立寄"
"たちよm 立ち読 立読"
"たちよc 立ち寄 立寄"
"たちゆk 立ち行"
"たちもどt 立ち戻"
"たちもどr 立ち戻"
"たちもどn 立ち戻"
"たちもどc 立ち戻"
"たちむk 立ち向"
"たちまわt 立ち回"
"たちまわr 立ち回"
"たちまわn 立ち回"
"たちまわc 立ち回"
"たちまt 忽"
"たちまj 立ち交"
"たちふさg 立ち塞"
"たちはたらk 立ち働"
"たちはたらi 立ち働"
"たちのぼt 立ち上"
"たちのぼr 立ち上"
"たちのぼn 立ち上"
"たちのぼc 立ち上"
"たちのk 立ち退 立退"
"たちのi 立ち退 立退"
"たちならn 立ち並"
"たちならb 立ち並"
"たちなおt 立ち直"
"たちなおr 立ち直"
"たちなおn 立ち直"
"たちなおc 立ち直"
"たちどおs 立ち通"
"たちどm 立ち止"
"たちとおs 立ち通"
"たちつづk 立ち続"
"たちつくs 立ち尽"
"たちっぱなs 立ちっ放"
"たちすくn 立ち竦"
"たちすくm 立ち竦"
"たちさt 立ち去"
"たちさr 立ち去"
"たちさn 立ち去"
"たちさg 立ち下"
"たちさc 立ち去"
"たちこn 立ち込"
"たちこm 立ち籠 立ち込"
"たちぐi 立食"
"たちくらn 立ち眩"
"たちくらm 立ち眩 立ち暗"
"たちぎk 立ち聞"
"たちきt 断ち切 裁ち切 截ち切"
"たちきr 断ち切 裁ち切 截ち切"
"たちきn 断ち切 裁ち切 截ち切"
"たちきk 立ち聞"
"たちきi 立ち聞"
"たちきc 断ち切 裁ち切 截ち切"
"たちがr 立枯 立ち枯"
"たちかえt 立ち返"
"たちかえr 立ち返"
"たちかえn 立ち返"
"たちかえc 立ち返"
"たちかw 立ち代"
"たちおくr 立ち後 立ち遅"
"たちうt 太刀打"
"たちいたt 立ち至"
"たちいたr 立ち至"
"たちいたn 立ち至"
"たちいたc 立ち至"
"たちいt 立ち入 立入"
"たちいr 立ち入 立入"
"たちいn 立ち入 立入"
"たちいc 立ち入 立入"
"たちあるk 立ち歩"
"たちあるi 立ち歩"
"たちあらわr 立ち現"
"たちあげr 立ち上げ"
"たちあw 立会 立ち会 立ち合 立合"
"たちあu 立ち会 立ち合 立合 立会"
"たちあt 立ち合 立ち会 立合 立会"
"たちあo 立ち会 立ち合 立合 立会"
"たちあi 立合 立会 立ち会 立ち合"
"たちあg 立ち上 起ち上 立上"
"たちあe 立会 立ち会 立ち合 立合"
"たちあc 立ち会 立ち合 立合 立会"
"ただよw 漂"
"ただよu 漂"
"ただよt 漂"
"ただよo 漂"
"ただよi 漂"
"ただよh 漂"
"ただよe 漂"
"ただよc 漂"
"ただたんn 只単"
"ただt 直"
"ただs 正 但 質 糺 匡"
"ただr 爛 糜"
"ただc 直"
"たたみこn 畳み込"
"たたみこm 畳み込"
"たたみかk 畳み掛"
"たたづm 佇"
"たたっきt 叩っ斬"
"たたっきr 叩っ斬"
"たたっきn 叩っ斬"
"たたっきc 叩っ斬"
"たたずn 佇 彳"
"たたずm 佇 彳"
"たたきふs 叩き伏"
"たたきなおs 叩き直"
"たたきつぶs 叩き潰"
"たたきつk 叩き付 叩きつ"
"たたきだs 叩き出"
"たたきこわs 叩き壊"
"たたきころs 叩き殺"
"たたきこn 叩き込"
"たたきこm 叩き込"
"たたききt 叩き切"
"たたききr 叩き切"
"たたききn 叩き切"
"たたききc 叩き切"
"たたきかえs 叩き返"
"たたきおとs 叩き落"
"たたきおこs 叩き起"
"たたきおk 叩き起"
"たたきうt 叩き売"
"たたきうr 叩き売"
"たたきうn 叩き売"
"たたきうc 叩き売"
"たたきあg 叩き上"
"たたかw 戦 闘 戰 鬪 斗"
"たたかu 戦 闘 斗 戰 鬪"
"たたかt 戦 闘 戰 鬪 斗"
"たたかo 戦 闘 斗 戰 鬪"
"たたかi 戦 闘 戰 鬪 斗"
"たたかh 戰 鬪"
"たたかe 戦 闘 戰 斗 鬪"
"たたかc 戦 闘 斗 戰 鬪"
"たたえt 湛"
"たたえr 湛"
"たたえn 湛"
"たたえc 湛"
"たたt 祟"
"たたr 祟"
"たたn 祟 畳 疊 疉 疂"
"たたm 畳 疊 疉 疂"
"たたk 叩 敲"
"たたi 叩 敲"
"たたh 称 湛"
"たたe 称 讃 湛 賛"
"たたc 祟"
"たそがr 黄昏"
"たずねいt 尋ね入"
"たずねいr 尋ね入"
"たずねいn 尋ね入"
"たずねいc 尋ね入"
"たずねあるk 訪ね歩"
"たずねあるi 訪ね歩"
"たずねあt 尋ね当"
"たずさわt 携"
"たずさわr 携"
"たずさわn 携"
"たずさわc 携"
"たずさw 携 攜"
"たずさe 携 攜"
"たずn 尋 訪 訊"
"たすけあw 助け合"
"たすけあu 助け合"
"たすけあt 助け合"
"たすけあo 助け合"
"たすけあi 助け合"
"たすけあe 助け合"
"たすけあc 助け合"
"たすきぞr 襷反"
"たすきがk 襷掛"
"たすかr 助か"
"たすk 助 援 扶 佐"
"たしょうちがu 多少違"
"たしょうちがt 多少違"
"たしょうちがi 多少違"
"たしょうちがe 多少違"
"たしょうたかs 多少高"
"たしょうたかk 多少高"
"たしょうたかi 多少高"
"たしょうたかg 多少高"
"たしょうおくr 多少遅"
"たしなn 嗜"
"たしなm 嗜 窘"
"たしかめあw 確かめ合"
"たしかめあu 確かめ合"
"たしかめあt 確かめ合"
"たしかめあo 確かめ合"
"たしかめあi 確かめ合"
"たしかめあe 確かめ合"
"たしかめあc 確かめ合"
"たしあわs 足し合"
"たしあw 足し合"
"たしk 確 慥"
"たけりたt 猛り立"
"たけりたc 猛り立"
"たけりくるw 猛り狂"
"たけりくるu 猛り狂"
"たけりくるt 猛り狂"
"たけりくるo 猛り狂"
"たけりくるi 猛り狂"
"たけりくるc 猛り狂"
"たけなわs 酣 闌"
"たけなわn 闌 酣"
"たけなわd 酣 闌"
"たけだけs 猛々 猛猛"
"たけしたどおr 竹下通"
"たけt 猛 哮"
"たけs 猛"
"たけr 猛 哮"
"たけn 猛 哮"
"たけk 猛"
"たけi 猛"
"たけc 猛 哮"
"たけb 猛 建 誥"
"たぐりよs 手繰り寄"
"たぐりこn 手繰り込"
"たぐりこm 手繰り込"
"たぐu 比 類"
"たぐt 手繰"
"たぐr 手繰"
"たぐn 手繰"
"たぐi 類"
"たぐh 比 類"
"たぐc 手繰"
"たくわe 蓄 貯 畜"
"たくらn 企"
"たくらm 企"
"たくまs 逞"
"たくはh 蓄 貯"
"たくs 託 托"
"たくr 綰"
"たくn 巧"
"たくm 巧"
"たぎt 滾 激"
"たぎr 滾 激"
"たぎn 滾 激"
"たぎc 滾 激"
"たきつk 焚き付 焚付"
"たきしm 薫き染"
"たきこn 炊き込 炊込 薫き込"
"たきこm 炊き込 炊込 薫き込"
"たきあわs 炊き合"
"たきあw 炊き合"
"たきあg 炊き上"
"たがやs 耕 畊 畉"
"たがいちがi 互い違"
"たがw 違"
"たがu 違"
"たがt 違"
"たがo 違"
"たがi 互 違"
"たがh 違"
"たがe 違"
"たがc 違"
"たかをくくt 高を括"
"たかをくくr 高を括"
"たかをくくn 高を括"
"たかをくくc 高を括"
"たからさがs 宝探"
"たかぶt 昂"
"たかぶr 昂 昂ぶ 亢ぶ"
"たかぶn 昂"
"たかぶc 昂"
"たかのぞm 高望"
"たかなt 高鳴"
"たかなr 高鳴"
"たかなn 高鳴"
"たかなc 高鳴"
"たかどm 高止"
"たかてr 高照"
"たかすg 高過"
"たかt 集"
"たかs 高"
"たかr 集 高"
"たかn 高 集"
"たかm 高"
"たかk 高"
"たかi 高"
"たかg 高"
"たかc 集"
"たかb 高"
"たおれふs 倒れ伏 倒れ臥"
"たおれこn 倒れ込"
"たおれこm 倒れ込"
"たおれr 殕"
"たおしこn 倒し込"
"たおしこm 倒し込"
"たおy 嫋"
"たおt 手折"
"たおs 倒"
"たおr 倒 手折 斃 仆"
"たおn 手折"
"たおc 手折"
"たえまなs 絶え間無"
"たえまなk 絶え間無"
"たえまなi 絶え間無"
"たえはt 絶え果"
"たえぬk 耐え抜"
"たえぬi 耐え抜"
"たえだe 絶え絶"
"たえしのn 堪え忍"
"たえしのb 堪え忍"
"たえきt 耐え切"
"たえきr 耐え切"
"たえきn 耐え切"
"たえきc 耐え切"
"たえがたs 耐え難"
"たえがたk 耐え難"
"たえがたi 耐え難"
"たえがたg 耐え難"
"たえかn 堪え兼"
"たえいt 絶え入"
"たえいr 絶え入"
"たえいn 絶え入"
"たえいc 絶え入"
"たえz 絶え"
"たえn 妙"
"たうe 田植"
"たいへんよs 大変良"
"たいへんよk 大変良"
"たいへんよi 大変良"
"たいへんよg 大変良"
"たいへんもうs 大変申"
"たいへんおそs 大変遅"
"たいへんおそk 大変遅"
"たいへんおそi 大変遅"
"たいへんおそg 大変遅"
"たいげんどm 体言止"
"たいおうづk 対応付"
"たいおうs 対応"
"たいあたr 体当"
"たいあt 体当"
"たいs 対 大 体 對 帯"
"たいr 平"
"たあいなs 他愛無"
"たあいなk 他愛無"
"たあいなi 他愛無"
"たy 絶"
"たt 立 建 断 絶 経 裁 発 起 截 勃 点 閉 斷 發 經 強"
"たs 足 誰 逹"
"たr 垂 足 埀"
"たn 他 足"
"たm 貯 溜 矯 撓 揉 澑"
"たk 炊 焚 長 薫 闌"
"たi 炊 焚 薫"
"たh 他 堪 耐"
"たe 耐 絶 堪"
"たc 立 断 経 建 斷 絶 裁 発 起 截 勃 發 經 足"
"たb 食 賜 給"
"ぞんじあg 存じ上"
"ぞんz 存"
"ぞんj 存"
"ぞろi 揃"
"ぞろe 揃"
"ぞくs 属 俗"
"ぞくp 俗"
"ぞくn 俗"
"ぞくd 俗"
"ぞうさなs 造作無"
"ぞうさなk 造作無"
"ぞうさなi 造作無"
"ぞうs 蔵"
"ぞt 反"
"ぞr 反"
"ぞn 反"
"ぞm 初 染"
"ぞi 沿"
"ぞe 添"
"ぞc 反"
"そんざいs 存在"
"そんz 損"
"そんs 損 存"
"そんn 損"
"そんj 損"
"そんd 損"
"そろばんだかs 算盤高"
"そろばんだかk 算盤高"
"そろばんだかi 算盤高"
"そろばんだかg 算盤高"
"そろw 揃"
"そろu 揃"
"そろt 揃"
"そろo 揃"
"そろi 揃"
"そろh 揃"
"そろe 揃"
"そろc 揃"
"それとなk 其と無"
"そりこn 剃り込"
"そりこm 剃り込"
"そりかえt 反り返"
"そりかえr 反り返"
"そりかえn 反り返"
"そりかえc 反り返"
"そりおとs 剃り落"
"そらんz 諳"
"そらんj 諳"
"そらとぼk 空惚"
"そらとb 空飛"
"そらぞらs 空々"
"そよi 戦"
"そよg 戦"
"そめわk 染め分 染分"
"そめぬk 染め抜"
"そめぬi 染め抜"
"そめなおs 染め直"
"そめだs 染め出"
"そめこn 染め込"
"そめこm 染め込"
"そめあg 染め上"
"そむk 背 叛"
"そむi 背 叛"
"そぼふt そぼ降"
"そぼふr そぼ降"
"そぼふn そぼ降"
"そぼふc そぼ降"
"そぼt 濡"
"そぶr 素振"
"そびえたt 聳え立"
"そびえたc 聳え立"
"そびe 聳"
"そばだt 峙"
"そねn 妬 嫉 猜"
"そねm 妬 嫉 猜"
"そなえつk 備え付"
"そなw 備 具"
"そなh 供 具 備"
"そなe 供 備 具"
"そとむk 外向"
"そとまわr 外回"
"そとづk 外付"
"そとつk 外付"
"そとがk 外掛"
"そでぐr 袖刳"
"そっけなs 素っ気無"
"そっけなk 素っ気無"
"そっけなi 素っ気無"
"そだてあg 育て上"
"そだt 育 毓"
"そだr 具足"
"そだc 育 毓"
"そぞr 漫"
"そそりたt 聳り立 そそり立"
"そそりたc 聳り立 そそり立"
"そそばしt 遽走"
"そそばしr 遽走"
"そそばしn 遽走"
"そそばしc 遽走"
"そそのかs 唆 嗾"
"そそぎこn 注ぎ込"
"そそぎこm 注ぎ込"
"そそi 注 雪 濯 灌"
"そそg 注 灌 濯 雪"
"そしきだt 組織立"
"そしt 謗 誹 譏 讒 詆"
"そしr 謗 誹 素知 そ知 譏 讒 詆"
"そしn 謗 誹 譏 讒 詆"
"そしc 謗 誹 譏 讒 詆"
"そこびe 底冷"
"そこぬk 底抜"
"そこなw 損 害"
"そこなu 損 害"
"そこなt 損 害"
"そこなo 損 害"
"そこなi 損 害"
"そこなh 損"
"そこなe 損 害"
"そこなc 損 害"
"そこしt 底知"
"そこしr 底知"
"そこしn 底知"
"そこしc 底知"
"そこいr 底入"
"そこあg 底上"
"そこn 損 害"
"そぐw 似"
"そぐu 似"
"そぐt 似"
"そぐo 似"
"そぐi 似"
"そぐe 似"
"そぐc 似"
"そくs 即 則 促"
"そぎとt 削ぎ取"
"そぎとr 削ぎ取"
"そぎとn 削ぎ取"
"そぎとc 削ぎ取"
"そぎおとs 削ぎ落"
"そうろu 候"
"そうりょうちゃくばらi 送料着払"
"そうらw 候"
"そうらi 候"
"そうらe 候"
"そうめいs 聡明"
"そうめいd 聡明"
"そうふいただk 送付頂"
"そうふいたs 送付致"
"そうなm 総嘗"
"そうとうn 相当"
"そうていs 想定"
"そうだんくだs 相談下"
"そうだt 総立"
"そうぞうs 騒々"
"そうそu 然う然"
"そうけだt 総毛立"
"そうけだc 総毛立"
"そうくずr 総崩"
"そうz 総"
"そうs 奏 草 相"
"そうn 躁"
"そうj 総"
"そうd 躁"
"そいとg 添い遂"
"そあくn 粗悪"
"そw 沿 添 副"
"そu 沿 添 副"
"そt 沿 添 剃 反 副"
"そs 素"
"そr 剃 逸 反 其"
"そo 沿 添 副"
"そn 其 素 剃 反"
"そm 染 初"
"そi 沿 添 副 削 殺"
"そh 沿 添 副"
"そg 削 殺"
"そe 添 沿 副"
"そd 素"
"そc 沿 添 副 剃 反"
"ぜんだt 膳立"
"ぜんk 前"
"ぜひきk 是非聞"
"ぜひきi 是非聞"
"ぜにうしなi 銭失"
"ぜっくs 絶句"
"ぜっs 絶"
"ぜいぬk 税抜"
"ぜいこm 税込"
"ぜm 責 攻"
"せんもんかむk 専門家向"
"せんまいどおs 千枚通"
"せんまいづk 千枚漬"
"せんびk 線引"
"せんぬk 栓抜"
"せんにんぎr 千人斬"
"せんなs 詮無"
"せんなk 詮無"
"せんなi 詮無"
"せんなg 詮無"
"せんたくばさm 洗濯挟"
"せんたくs 選択"
"せんぞがえr 先祖返 先祖帰"
"せんじつm 煎じ詰"
"せんさいs 繊細"
"せんさいn 繊細"
"せんさいd 繊細"
"せんかたなs 詮方無"
"せんかたなk 詮方無"
"せんかたなi 詮方無"
"せんかたなg 詮方無"
"せんz 詮 煎 先"
"せんs 宣 僭 撰"
"せんj 煎 先"
"せわずk 世話好"
"せわs 忙"
"せりまk 競り負"
"せりだs 迫り出"
"せりかt 競り勝"
"せりかc 競り勝"
"せりおとs 競り落"
"せりあw 競り合"
"せりあu 競り合"
"せりあt 競り合"
"せりあo 競り合"
"せりあi 競り合"
"せりあg 競り上 迫り上"
"せりあe 競り合"
"せりあc 競り合"
"せもたr 背凭"
"せめよs 攻め寄"
"せめほろb 攻め滅"
"せめのぼt 攻め上"
"せめのぼr 攻め上"
"せめのぼn 攻め上"
"せめのぼc 攻め上"
"せめぬk 攻め抜"
"せめぬi 攻め抜"
"せめつづk 攻め続 責め続"
"せめたt 攻め立 責め立"
"せめさいなn 責め苛"
"せめさいなm 責め苛"
"せめころs 責め殺"
"せめこn 攻め込"
"せめこm 攻め込"
"せめぎあw 鬩ぎ合"
"せめぎあu 鬩ぎ合"
"せめぎあt 鬩ぎ合"
"せめぎあo 鬩ぎ合"
"せめぎあi 鬩ぎ合"
"せめぎあe 鬩ぎ合"
"せめぎあc 鬩ぎ合"
"せめきt 攻め切"
"せめきr 攻め切"
"せめきn 攻め切"
"せめきc 攻め切"
"せめおとs 攻め落 責め落"
"せめおt 攻め落"
"せめいt 攻め入"
"せめいr 攻め入"
"せめいn 攻め入"
"せめいc 攻め入"
"せめあぐn 攻め倦"
"せめあぐm 攻め倦"
"せめあw 攻め合 責め合"
"せめあu 攻め合 責め合"
"せめあt 攻め合 責め合"
"せめあo 攻め合 責め合"
"せめあi 攻め合 責め合"
"せめあe 攻め合 責め合"
"せめあc 攻め合 責め合"
"せめr 攻め"
"せめi 鬩"
"せめg 鬩"
"せまりこz 迫り来"
"せまりこy 迫り来"
"せまりこs 迫り来"
"せまりこr 迫り来"
"せまりこn 迫り来"
"せまりこi 迫り来"
"せまりくr 迫り来"
"せまりくn 迫り来"
"せまりきy 迫り来"
"せまりきt 迫り来"
"せまりきs 迫り来"
"せまりきn 迫り来"
"せまりきm 迫り来"
"せまりきd 迫り来"
"せまりきc 迫り来"
"せまっくるs 狭っ苦"
"せますg 狭過"
"せまくるs 狭苦"
"せまt 迫 逼"
"せまs 狭 狹"
"せまr 迫 逼"
"せまn 迫 逼"
"せまm 狭 狹"
"せまk 狭 狹"
"せまi 狭 狹"
"せまg 狭 狹"
"せまc 迫 逼"
"せぶm 瀬踏"
"せばm 狭 狹"
"せはs 忙"
"せのb 背伸"
"せなかあw 背中合"
"せつめいしょどおr 説明書通"
"せつめいs 説明"
"せつぞくs 接続"
"せつs 切"
"せつn 切"
"せつk 責付"
"せつi 責付"
"せつd 切"
"せっぱつまt 切羽詰"
"せっぱつまr 切羽詰"
"せっぱつまn 切羽詰"
"せっぱつまc 切羽詰"
"せっぱつm 切羽詰"
"せっていまちがi 設定間違"
"せっていs 設定"
"せっつk 責付"
"せっつi 責付"
"せっしょくs 接触"
"せっきんs 接近"
"せっきょうたr 説教垂"
"せっきょうくさs 説教臭"
"せっきょうくさk 説教臭"
"せっきょうくさi 説教臭"
"せっきょうくさg 説教臭"
"せっs 接"
"せちがらs 世知辛"
"せちがらk 世知辛"
"せちがらi 世知辛"
"せちがらg 世知辛"
"せせらわらw せせら笑 嘲笑"
"せせらわらu 嘲笑 せせら笑"
"せせらわらt せせら笑 嘲笑"
"せせらわらo せせら笑 嘲笑"
"せせらわらi せせら笑 嘲笑"
"せせらわらe せせら笑 嘲笑"
"せせらわらc 嘲笑 せせら笑"
"せけんずr 世間擦"
"せきばらi 咳払"
"せきにんもt 責任持"
"せきにんとt 責任取"
"せきにんとr 責任取"
"せきにんとn 責任取"
"せきにんとc 責任取"
"せきとm 堰き止 塞き止 せき止"
"せきたt 急き立"
"せききt 急き切"
"せききr 急き切"
"せききn 急き切"
"せききc 急き切"
"せきがe 席替"
"せおいこn 背負い込 背負込"
"せおいこm 背負い込 背負込"
"せおw 背負"
"せおu 背負"
"せおt 背負"
"せおo 背負"
"せおi 背負"
"せおe 背負"
"せおc 背負"
"せうs 抄"
"せいびs 整備"
"せいちょうs 成長"
"せいだs 精出"
"せいぞろi 勢揃"
"せいせいs 生成"
"せいげんつk 制限付"
"せいかくs 正確"
"せいかくn 正確"
"せいs 制 征 製 省"
"せいn 聖"
"せz 為"
"せy 為"
"せt 競 迫 糶"
"せr 迫 競 糶"
"せn 迫 競 糶"
"せm 攻 責"
"せk 急 咳 堰 塞"
"せi 急 咳 堰 塞"
"せg 背"
"せc 迫 競 糶"
"ずわr 座"
"ずれこn ずれ込"
"ずれこm ずれ込"
"ずれz ズレ"
"ずれy ズレ"
"ずれt ズレ"
"ずれs ズレ"
"ずれr ズレ"
"ずれn ズレ"
"ずれm ズレ"
"ずれk ズレ"
"ずれc ズレ"
"ずるs 狡"
"ずるk 狡"
"ずるi 狡"
"ずるg 狡"
"ずりおt ずり落"
"ずりおc ずり落"
"ずぶぬr ずぶ濡"
"ずぶとs 図太"
"ずぶとk 図太"
"ずぶとi 図太"
"ずぶとg 図太"
"ずぬk 頭抜 図抜"
"ずどr 図取"
"ずつk 頭突"
"ずうずうs 図々"
"ずs 誦"
"ずr 刷"
"ずm 済 住 濟"
"ずk 好 尽 付"
"すんづm 寸詰"
"すわりなおs 座り直"
"すわりこn 座り込"
"すわりこm 座り込"
"すわt 座 坐"
"すわr 座 坐"
"すわn 座 坐"
"すわc 座 坐"
"すれちがw すれ違 擦れ違"
"すれちがu すれ違 擦れ違"
"すれちがt すれ違 擦れ違"
"すれちがo すれ違 擦れ違"
"すれちがi すれ違 擦れ違"
"すれちがe すれ違 擦れ違"
"すれちがc すれ違 擦れ違"
"すれあw 擦れ合"
"すれあu 擦れ合"
"すれあt 擦れ合"
"すれあo 擦れ合"
"すれあi 擦れ合"
"すれあe 擦れ合"
"すれあc 擦れ合"
"するどs 鋭"
"するどk 鋭"
"するどi 鋭"
"するどg 鋭"
"すりよt 擦り寄 摩り寄"
"すりよr 擦り寄 摩り寄"
"すりよn 擦り寄 摩り寄"
"すりよc 擦り寄 摩り寄"
"すりむk 擦り剥 擦剥"
"すりむi 擦剥 擦り剥"
"すりへt 磨り減"
"すりへr 磨り減"
"すりへn 磨り減"
"すりへc 磨り減"
"すりぬk 擦り抜 すり抜 擦抜 擦り拔"
"すりぬi 擦り抜 すり抜 擦抜 擦り拔"
"すりつぶs すり潰 磨り潰 摺り潰"
"すりつk 擦り付"
"すりこn 刷り込 摺り込 摩り込 刷込"
"すりこm 刷り込 摺り込 摩り込 刷込"
"すりくだk 擂り碎 擂り砕"
"すりくだi 擂り砕 擂り碎"
"すりきt 擦り切 摺り切 摩り切"
"すりきr 擦り切 摺り切 摩り切"
"すりきn 擦り切 摺り切 摩り切"
"すりきc 擦り切 摺り切 摩り切"
"すりかわr 掏り替"
"すりかw 掏り替"
"すりかe 摩り替 すり替 掏り替"
"すりあわs 擦り合 摺り合"
"すりあw 擦り合 摺り合"
"すりあg 刷り上"
"すやk 素焼"
"すもぐr 素潜"
"すみわたt 澄み渡"
"すみわたr 澄み渡"
"すみわたn 澄み渡"
"すみわたc 澄み渡"
"すみわk 棲み分 住み分"
"すみやk 炭焼"
"すみなs 住み成"
"すみなr 住み慣 住み馴"
"すみつk 住み着"
"すみつi 住み着"
"すみこn 住み込 住込"
"すみこm 住み込 住込"
"すみくr 住み暮"
"すみきt 澄み切"
"すみきr 澄み切"
"すみきn 澄み切"
"すみきc 澄み切"
"すみy 速"
"すまu 住ま"
"すまi 住ま"
"すまh 住ま"
"すぼn 窄"
"すぼm 窄"
"すべりどm 滑り止"
"すべりだs 滑り出"
"すべりこn 滑り込"
"すべりこm 滑り込"
"すべりおt 滑り落"
"すべりおc 滑り落"
"すべからk 須"
"すべt 滑 全 総 總 辷"
"すべr 滑 辷"
"すべn 滑 辷"
"すべc 滑 辷"
"すぶr 素振"
"すばらs 素晴"
"すばやs 素早"
"すばやk 素早"
"すばやi 素早"
"すばやg 素早"
"すばなr 巣離"
"すばr 素晴"
"すなわt 即 則 乃"
"すなわc 即"
"すなどt 漁"
"すなどr 漁"
"すなどn 漁"
"すなどc 漁"
"すどまr 素泊"
"すどおs 素通"
"すどおr 素通"
"すどm 素泊"
"すでn 既"
"すてさt 捨て去"
"すてさr 捨て去"
"すてさn 捨て去"
"すてさc 捨て去"
"すてきt 捨て切"
"すてきr 捨て切"
"すてきn 捨て切"
"すてきd 素敵"
"すてきc 捨て切"
"すてがたs 捨て難"
"すてがたk 捨て難"
"すてがたi 捨て難"
"すてがたg 捨て難"
"すておk 捨て置"
"すておi 捨て置"
"すてr 捨て"
"すづk 酢漬"
"すっぽぬk すっぽ抜"
"すっぱぬk 素っ破抜 すっぱ抜 スッパ抜"
"すっぱぬi 素っ破抜 すっぱ抜 スッパ抜"
"すっとぼk 素っ恍"
"すっとn すっ飛 素っ飛"
"すっとb すっ飛 素っ飛"
"すだt 巣立"
"すだc 巣立"
"すたt 廃 頽 廢"
"すたr 廃 頽 廢"
"すたn 廃 頽 廢"
"すたc 廃 頽 廢"
"すそわk 裾分"
"すそとr 裾取"
"すずなr 鈴生"
"すずy 涼"
"すずs 涼 凉"
"すずr 漫"
"すずn 涼 凉"
"すずm 涼 凉"
"すすりなk 啜り泣"
"すすりなi 啜り泣"
"すすりこn 啜り込"
"すすりこm 啜り込"
"すすりあg 啜り上"
"すすみでy 進み出"
"すすみでt 進み出"
"すすみでr 進み出"
"すすみでn 進み出"
"すすみでm 進み出"
"すすt 啜"
"すすr 啜"
"すすn 進 啜"
"すすm 進 勧 薦 奨 勸"
"すすk 煤"
"すすi 濯 漱 雪 啌"
"すすg 濯 漱 雪 啌"
"すすc 啜"
"すすb 煤"
"すじちがi 筋違"
"すじがねいr 筋金入"
"すじあi 筋合"
"すじt 捩"
"すじr 捩"
"すじn 捩"
"すじc 捩"
"すさt 退"
"すさr 退"
"すさn 荒 退 遊 進"
"すさm 凄 荒 遊 進"
"すさc 退"
"すさb 荒 遊 進"
"すごもr 巣篭"
"すごすg 凄過"
"すごしやすs 過ごし易"
"すごしやすk 過ごし易"
"すごしやすi 過ごし易"
"すごしやすg 過ごし易"
"すごs 過 凄"
"すごm 凄"
"すごk 凄"
"すごi 凄"
"すごg 凄"
"すこぶr 頗"
"すこy 健"
"すこs 少"
"すげなs 素気無"
"すげなk 素気無"
"すげなi 素気無"
"すげなg 素気無"
"すげかe 挿げ替 すげ替"
"すげn 素気"
"すぐりぬk 選り抜"
"すぐりぬi 選り抜"
"すぐt 選"
"すぐs 過"
"すぐr 優 勝 選 秀"
"すぐn 直 選"
"すぐc 選"
"すくなs 少 尠 寡"
"すくなk 少 少な 尠 寡"
"すくなi 少 少な 尠 寡"
"すくなg 少 尠 寡"
"すくいなg 掬い投"
"すくいだs 救い出"
"すくいあg 掬い上"
"すくw 救 掬 巣喰 済 抄"
"すくu 救 掬 巣喰 済 抄 巣く"
"すくt 救 掬 巣喰 済 抄"
"すくo 救 掬 巣喰 済 抄"
"すくn 少 竦 窘"
"すくm 竦 窘"
"すくi 救 掬 巣喰 済 抄"
"すくh 掬 救 済 抄"
"すくe 救 掬 巣喰 済 抄"
"すくc 救 掬 巣喰 済 抄"
"すぎゆk 過ぎ行"
"すぎさt 過ぎ去"
"すぎさr 過ぎ去"
"すぎさn 過ぎ去"
"すぎさc 過ぎ去"
"すぎn 過ぎ"
"すきとおt 透き通 透き徹"
"すきとおs 透き通"
"すきとおr 透き通 透き徹"
"すきとおn 透き通 透き徹"
"すきとおc 透き通 透き徹"
"すきとt 梳き取"
"すきとr 梳き取"
"すきとn 梳き取"
"すきとc 梳き取"
"すきずk 好き好"
"すきこのn 好き好"
"すきこのm 好き好"
"すきこn 漉き込 鋤き込"
"すきこm 漉き込 鋤き込"
"すききらi 好き嫌"
"すきかえs 鋤き返"
"すきあw 好き合"
"すきあu 好き合"
"すきあt 好き合"
"すきあo 好き合"
"すきあi 好き合"
"すきあe 好き合"
"すきあc 好き合"
"すがりつk 縋り付"
"すがりつi 縋り付"
"すがすがs 清々"
"すがt 縋"
"すがr 縋 末枯 尽"
"すがn 縋"
"すがm 眇"
"すがc 縋"
"すかしみz 透かし見"
"すかしみy 透かし見"
"すかしみt 透かし見"
"すかしみs 透かし見"
"すかしみr 透かし見"
"すかしみn 透かし見"
"すかしみm 透かし見"
"すかしみc 透かし見"
"すかs 透 賺"
"すえひろg 末広"
"すえながs 末永 末長"
"すえながk 末永 末長"
"すえながi 末永 末長"
"すえつk 据え付 据付"
"すえたのm 末頼"
"すえおそr 末恐"
"すえおk 据え置 据置"
"すえおi 据え置 据置"
"すいよs 吸い寄"
"すいとt 吸い取"
"すいとr 吸い取"
"すいとn 吸い取"
"すいとc 吸い取"
"すいつづk 吸い続"
"すいつk 吸い付"
"すいつi 吸い付"
"すいだs 吸い出 吸出"
"すいすg 吸い過"
"すいこn 吸い込"
"すいこm 吸い込"
"すいあg 吸い上"
"すいs 粋"
"すいn 粋"
"すいd 粋"
"すあg 素揚"
"すw 吸 据 喫"
"すu 吸 喫"
"すt 捨 吸 刷 棄 喫 擦 摺 擂 磨 掏 摩 剃"
"すs 酸"
"すr 擦 刷 為 摺 擂 磨 掏 摩 剃 爲"
"すp 酸"
"すo 吸 喫"
"すn 済 住 棲 澄 拗 濟 擦 刷 摺 擂 磨 掏 摩 剃 爲 清 栖 澂"
"すm 住 済 棲 澄 清 栖 濟 澂 為"
"すk 好 空 透 漉 梳 鋤 抄 剥 耡 酸"
"すi 酸 吸 空 喫 好 梳 透 済 濟 漉 鋤 抄 剥 耡"
"すg 過 直"
"すe 据 吸 饐 喫"
"すc 吸 喫 擦 刷 摺 擂 磨 掏 摩 剃"
"すb 統 総 總"
"じんどt 陣取"
"じんどr 陣取"
"じんどn 陣取"
"じんどc 陣取"
"じんとr 陣取"
"じわr 地割"
"じょさいなs 如才無"
"じょさいなk 如才無"
"じょさいなi 如才無"
"じょうやとi 常雇"
"じょうほうくだs 情報下"
"じょうだんぬk 冗談抜"
"じょうせきどおr 定石通"
"じょうさs 状差"
"じょうけんづk 条件付"
"じょうz 乗 乘"
"じょうs 城"
"じょうn 上 状"
"じょうj 乗 乘"
"じょうd 状"
"じょs 除 叙 序 恕"
"じゆうさんかd 自由参加"
"じゆうd 自由"
"じゅんばんまt 順番待"
"じゅんばんまc 順番待"
"じゅんじょよs 順序良"
"じゅんじょよk 順序良"
"じゅんじょよi 順序良"
"じゅんじょだt 順序立"
"じゅんぐr 順繰"
"じゅんおくr 順送"
"じゅんz 準 殉 准 凖"
"じゅんs 純"
"じゅんn 順 純"
"じゅんj 準 殉 准 凖"
"じゅんd 純"
"じゅつごよb 述語呼"
"じゅくs 熟"
"じゅうりょうあg 重量挙"
"じゅうらいどおr 従来通"
"じゅうぶんn 十分"
"じゅうぶんd 十分"
"じゅうばこよm 重箱読"
"じゅうなんn 柔軟"
"じゅうだいn 重大"
"じゅうじがたm 十字固"
"じゅs 誦 呪"
"じゅn 得"
"じゃらs 戯"
"じゃまくさs 邪魔臭"
"じゃまくさk 邪魔臭"
"じゃまくさi 邪魔臭"
"じゃまくさg 邪魔臭"
"じゃっかんことn 若干異"
"じゃr 戯"
"じむてづづk 事務手続"
"じまんt 自慢"
"じべt 地べ"
"じひぶかs 慈悲深"
"じひぶかk 慈悲深"
"じひぶかi 慈悲深"
"じひぶかg 慈悲深"
"じひびk 地響"
"じばk 字化"
"じなr 地鳴"
"じてんしゃのr 自転車乗"
"じてんd 時点"
"じづたi 地伝"
"じづm 字詰"
"じつづk 地続"
"じつn 実"
"じつh 実"
"じっぱひとからg 十把一絡"
"じっこうs 実行"
"じっt 凝"
"じだいおくr 時代遅 時代後"
"じずm 字詰"
"じしょひk 辞書引"
"じさg 字下"
"じこt 事故"
"じこr 事故"
"じこn 事故"
"じこm 仕込"
"じこc 事故"
"じくばr 字配"
"じきはずr 時期外"
"じきs 直"
"じきn 直"
"じきd 直"
"じがたm 地固"
"じかんぎr 時間切"
"じかんおくr 時間遅"
"じかづk 直付"
"じかがk 直書"
"じかn 直"
"じかk 仕掛"
"じあまr 字余"
"じs 持 辞 侍"
"じr 焦"
"じn 死 染"
"じm 染"
"じk 敷"
"じg 字"
"しんぼうづよs 辛抱強"
"しんぼうづよk 辛抱強"
"しんぼうづよi 辛抱強"
"しんぴてきd 神秘的"
"しんぱいなs 心配無"
"しんぱいなk 心配無"
"しんぱいなi 心配無"
"しんぱいなg 心配無"
"しんちょうs 新調"
"しんじんぶかs 信心深"
"しんじんぶかk 信心深"
"しんじんぶかi 信心深"
"しんじんぶかg 信心深"
"しんじゅくどおr 新宿通"
"しんじつづk 信じ続"
"しんじこn 信じ込"
"しんじこm 信じ込"
"しんじがたs 信じ難"
"しんじがたk 信じ難"
"しんじがたi 信じ難"
"しんじがたg 信じ難"
"しんじt 信じ"
"しんじr 信じ"
"しんしんともn 心身共"
"しんこうs 進行"
"しんけんd 真剣"
"しんきくさs 辛気臭 心気臭"
"しんきくさk 辛気臭 心気臭"
"しんきくさi 辛気臭 心気臭"
"しんきくさg 辛気臭 心気臭"
"しんいr 新入"
"しんz 信 進 死ん"
"しんn 真"
"しんj 信"
"しをr 萎"
"しわよs 皺寄"
"しわぶk 咳"
"しわぶi 咳"
"しわがr 嗄"
"しわs 吝"
"しわk 仕分 仕訳 吝"
"しわi 吝"
"しわg 吝"
"しろぬr 白塗"
"しろぬk 白抜"
"しろうとくさs 素人臭"
"しろうとくさk 素人臭"
"しろうとくさi 素人臭"
"しろうとくさg 素人臭"
"しろうとかんがe 素人考"
"しろうとp 素人"
"しろu 白"
"しろs 白"
"しろp 白"
"しろm 白"
"しろk 白"
"しろi 白"
"しろg 白"
"しれわたt 知れ渡"
"しれわたr 知れ渡"
"しれわたn 知れ渡"
"しれわたc 知れ渡"
"しるs 記 著 印 徴 誌 識 標 示"
"しるk 著"
"しるi 著"
"しるg 著"
"しりぬぐi 尻拭"
"しりぬk 知り抜"
"しりぬi 知り抜"
"しりつくs 知り尽"
"しりつk 知り尽"
"しりぞk 退 斥"
"しりぞi 退 斥"
"しりさがr 尻下"
"しりさg 尻下"
"しりごm 尻込"
"しりこそばゆi 尻擽"
"しりきr 尻切"
"しりあw 知り合"
"しりあu 知り合"
"しりあt 知り合"
"しりあo 知り合"
"しりあi 知り合 知合"
"しりあg 尻上"
"しりあe 知り合"
"しりあc 知り合"
"しらべあg 調べ上"
"しらべr 調べ"
"しらぬぞんz 知らぬ存"
"しらちゃk 白茶"
"しらじらs 白々"
"しらz 知ら"
"しらs 報 知ら"
"しらn 白"
"しらm 白"
"しらk 白"
"しらg 白 精"
"しらb 調"
"しようくだs 使用下"
"しようs 使用"
"しようd 使用"
"しょりs 処理"
"しょぼs ショボ"
"しょぼk ショボ"
"しょぼi ショボ"
"しょぼg ショボ"
"しょってたt 背負って立"
"しょってたc 背負って立"
"しょっきあらi 食器洗"
"しょっきr 初っ切"
"しょっからs 塩っ辛"
"しょっからm 塩っ辛"
"しょっからk 塩っ辛"
"しょっからi 塩っ辛"
"しょっからg 塩っ辛"
"しょたいじm 所帯染"
"しょじs 所持"
"しょしんしゃむk 初心者向"
"しょざいなs 所在無"
"しょざいなk 所在無"
"しょざいなi 所在無"
"しょげこn 悄気込"
"しょげこm 悄気込"
"しょげかえt 悄気返"
"しょげかえr 悄気返"
"しょげかえn 悄気返"
"しょげかえc 悄気返"
"しょげt 悄気"
"しょげr 悄気"
"しょげn 悄気"
"しょげc 悄気"
"しょくs 食 属 嘱"
"しょきばらi 暑気払"
"しょきかs 初期化"
"しょうろうながs 精霊流"
"しょうめんきt 正面切"
"しょうめんきr 正面切"
"しょうめんきn 正面切"
"しょうめんきc 正面切"
"しょうめいずm 証明済"
"しょうめいs 証明"
"しょうぶづよs 勝負強"
"しょうぶづよk 勝負強"
"しょうぶづよi 勝負強"
"しょうぶづよg 勝負強"
"しょうぶつよk 勝負強"
"しょうどうがi 衝動買"
"しょうだt 章立"
"しょうじんおt 精進落"
"しょうじいr 招じ入 請じ入"
"しょうこだt 証拠立"
"しょうこしらb 証拠調"
"しょうこr 性懲"
"しょうぎだおs 将棋倒"
"しょうがつやすm 正月休"
"しょうかいいただk 紹介頂"
"しょうかいいたs 紹介致"
"しょうz 生 請"
"しょうs 称 証 賞 抄 頌 生"
"しょうj 生 招 請"
"しょいこn 背負い込"
"しょいこm 背負い込"
"しょw 背負"
"しょu 背負"
"しょt 背負"
"しょs 処 署 書"
"しょp 塩"
"しょo 背負"
"しょi 背負"
"しょh 背負"
"しょe 背負"
"しょc 背負"
"しゅんs 旬"
"しゅんn 旬"
"しゅんd 旬"
"しゅびよk 首尾良"
"しゅつりょくs 出力"
"しゅっせばらi 出世払"
"しゅくs 祝"
"しゅうりがk 修理書"
"しゅうねんぶかs 執念深"
"しゅうねんぶかk 執念深"
"しゅうねんぶかi 執念深"
"しゅうねんぶかg 執念深"
"しゅうねs 執念"
"しゅうねk 執念"
"しゅうねi 執念"
"しゅうかんおくr 週間遅"
"しゅうあk 週明"
"しゅうs 執 修"
"しゅt 主"
"しゃれこn 洒落込"
"しゃれこm 洒落込"
"しゃれt 洒落"
"しゃれr 洒落"
"しゃれn 洒落"
"しゃれc 洒落"
"しゃらくさs 洒落臭"
"しゃらくさk 洒落臭"
"しゃらくさi 洒落臭"
"しゃらくさg 洒落臭"
"しゃべりだs 喋り出"
"しゃべt 喋 諜"
"しゃべr 喋 諜"
"しゃべn 喋 諜"
"しゃべk 喋"
"しゃべc 喋 諜"
"しゃぶりつk しゃぶり付"
"しゃぶりつi しゃぶり付"
"しゃっきんとr 借金取"
"しゃちほこばt 鯱張"
"しゃちほこばr 鯱張"
"しゃちほこばn 鯱張"
"しゃちほこばc 鯱張"
"しゃしんうつr 写真写"
"しゃしゃりでz しゃしゃり出"
"しゃしゃりでt しゃしゃり出"
"しゃしゃりでr しゃしゃり出"
"しゃしゃりでn しゃしゃり出"
"しゃこいr 車庫入"
"しゃくりあg しゃくり上"
"しゃくt 抉 決 刳"
"しゃくs 癪"
"しゃくr 抉 決 刳"
"しゃくn 抉 決 刳 癪"
"しゃくd 癪"
"しゃくc 抉 決 刳"
"しゃがr 嗄"
"しゃs 謝"
"しもやk 霜焼"
"しもがr 霜枯"
"しめわすr 閉め忘"
"しめつk 締め付 締付"
"しめだs 締め出 閉め出"
"しめしあわs 示し合"
"しめしあw 示し合"
"しめこn 締め込"
"しめこm 締め込"
"しめくくt 締め括"
"しめくくr 締め括"
"しめくくn 締め括"
"しめくくc 締め括"
"しめきt 締め切 閉め切 締切"
"しめきr 締め切 閉め切 締切"
"しめきn 締め切 閉め切 締切"
"しめきc 締め切 閉め切 締切"
"しめいs 指名"
"しめあg 締め上"
"しめt 湿 〆 濕"
"しめs 示 湿 濕"
"しめr 湿 〆 濕"
"しめp 湿 濕"
"しめn 湿 〆 濕"
"しめc 湿 〆 濕"
"しむk 仕向"
"しみとおt 沁み透"
"しみとおr 沁み透"
"しみとおn 沁み透"
"しみとおc 沁み透"
"しみでz 滲み出 染み出"
"しみでy 滲み出 染み出"
"しみでt 滲み出 染み出"
"しみでs 滲み出 染み出"
"しみでr 滲み出 染み出"
"しみでn 滲み出 染み出"
"しみでm 滲み出 染み出"
"しみでc 滲み出 染み出"
"しみつk 染み付"
"しみつi 染み付"
"しみだs 染み出 滲み出"
"しみこn 染み込"
"しみこm 染み込"
"しみいt 染み入"
"しみいr 染み入"
"しみいn 染み入"
"しみいc 染み入"
"しみt 沁"
"しみr 沁"
"しみn 沁"
"しみc 沁"
"しまながs 島流"
"しまいこn 仕舞い込"
"しまいこm 仕舞い込"
"しまw 仕舞 終 了 蔵"
"しまu 仕舞 終 了 蔵"
"しまt 仕舞 了 終 蔵 閉"
"しまr 閉"
"しまo 仕舞 終 了 蔵"
"しまn 閉"
"しまi 終 仕舞 了 蔵"
"しまe 仕舞 終 了 蔵"
"しまc 仕舞 終 了 蔵 閉"
"しぼりだs 絞り出 搾り出"
"しぼりこn 絞り込"
"しぼりこm 絞り込"
"しぼりあg 絞り上"
"しぼt 絞 搾"
"しぼr 絞 搾"
"しぼn 萎 凋 絞 搾"
"しぼm 萎 凋"
"しぼc 絞 搾"
"しぶt 渋 澁 澀"
"しぶs 渋 澁 澀"
"しぶr 渋 澁 澀"
"しぶn 渋 澁 澀"
"しぶm 渋"
"しぶk 渋 澁 澀"
"しぶi 渋 澁 澀"
"しぶg 渋 澁 澀"
"しぶc 渋 澁 澀"
"しびr 痺"
"しばりつk 縛り付"
"しばりあg 縛り上"
"しばらk 暫"
"しばたk 瞬"
"しばたi 瞬"
"しばかr 柴刈 芝刈"
"しばいじm 芝居染"
"しばt 縛"
"しばs 暫"
"しばr 縛 暫 凍"
"しばn 縛"
"しばc 縛"
"しはらw 支払"
"しはらu 支払"
"しはらt 支払"
"しはらo 支払"
"しはらi 支払"
"しはらe 支払"
"しはらc 支払"
"しのびわらi 忍び笑"
"しのびよt 忍び寄"
"しのびよr 忍び寄"
"しのびよn 忍び寄"
"しのびよc 忍び寄"
"しのびなk 忍び泣"
"しのびなi 忍び泣"
"しのびこn 忍び込"
"しのびこm 忍び込"
"しのびがたs 忍び難"
"しのびがたk 忍び難"
"しのびがたi 忍び難"
"しのびがたg 忍び難"
"しのびいt 忍び入"
"しのびいr 忍び入"
"しのびいn 忍び入"
"しのびいc 忍び入"
"しのばずどおr 不忍通"
"しのつk 篠突"
"しのごn 四の五"
"しのn 忍 偲"
"しのi 凌"
"しのg 凌"
"しのb 偲 忍"
"しにわかr 死に別"
"しにものぐるi 死に物狂"
"しにはt 死に果"
"しにたe 死に絶"
"しにぞこn 死に損"
"しにそこn 死に損"
"しにくs 為難 爲難"
"しにくk 為難 爲難"
"しにくi 為難 爲難"
"しにくg 為難 爲難"
"しにきr 死に切"
"しにかk 死に掛"
"しにおくr 死に遅"
"しにいそi 死に急"
"しにいそg 死に急"
"しなだr 撓垂"
"しなぞろi 品揃"
"しなぞろe 品揃"
"しなさだm 品定"
"しなぎr 品切"
"しながe 品換"
"しなおs 仕直"
"しなw 撓"
"しなu 撓"
"しなt 撓"
"しなs 為做"
"しなr 撓"
"しなo 撓"
"しなn 撓"
"しなi 撓"
"しなh 撓"
"しなe 撓"
"しなc 撓"
"しなb 萎"
"しとy 淑"
"しとm 仕留 爲留"
"しとg 仕遂 為遂"
"しでかs 為出来"
"しでk 仕出 為出"
"してやt 為て遣"
"してやr 為て遣"
"してやn 為て遣"
"してやc 為て遣"
"してきどおr 指摘通"
"してきs 指摘"
"していs 指定"
"しづらs 仕辛"
"しづらk 仕辛"
"しづらi 仕辛"
"しづらg 仕辛"
"しづr 垂 埀"
"しづn 沈 鎭 靜"
"しづm 沈 鎭 靜"
"しつりょうあたr 質量当"
"しつらe 設"
"しつけr 躾"
"しつk 仕付 躾"
"しっとぶかs 嫉妬深"
"しっとぶかk 嫉妬深"
"しっとぶかi 嫉妬深"
"しっとぶかg 嫉妬深"
"しったかぶt 知ったか振"
"しったかぶr 知ったか振"
"しったかぶn 知ったか振"
"しったかぶc 知ったか振"
"しっかt 確 聢"
"しっかr 確"
"しっs 失 執"
"しちめんどうくさs 七面倒臭"
"しちめんどうくさk 七面倒臭"
"しちめんどうくさi 七面倒臭"
"しちめんどうくさg 七面倒臭"
"しちながr 質流"
"しちうk 質請"
"しちいr 質入"
"しだいしだいn 次第次第"
"しだs 仕出"
"しだr 垂 枝垂"
"しだk 拉"
"しだi 拉"
"したよs 下寄"
"したよm 下読"
"したむk 下向"
"したまわt 下回"
"したまわr 下回"
"したまわn 下回"
"したまわc 下回"
"したばたらk 下働"
"したばe 下生"
"したぬr 下塗"
"したどt 下取"
"したどr 下取"
"したどn 下取"
"したどc 下取"
"したとr 下取"
"したてひねr 下手捻"
"したてなおs 仕立て直"
"したてなg 下手投"
"したてだしなg 下手出し投"
"したてあg 仕立て上"
"したづm 下積"
"したつk 下付"
"したったr 舌っ足"
"したたりおt 滴り落"
"したたりおc 滴り落"
"したたt 滴"
"したたr 滴 舌足"
"したたn 滴"
"したたm 認"
"したたk 強"
"したたc 滴"
"したしらb 下調"
"したしみぶかs 親しみ深"
"したしみぶかk 親しみ深"
"したしみぶかi 親しみ深"
"したしみぶかg 親しみ深"
"したしm 親し 親"
"したざわr 舌触"
"したごしらe 下拵"
"したがw 従 随 順 从 從 啝"
"したがu 従 随 順 从 從 啝"
"したがt 従 随 順 从 從 啝"
"したがo 従 随 順 从 從 啝"
"したがk 下書"
"したがi 従 随 順 从 從 啝"
"したがh 従 随 順 从 從 啝"
"したがe 従 随 順 从 從 啝"
"したがc 従 随 順 从 從 啝"
"したうt 舌打"
"したうk 下請"
"したw 慕"
"したu 慕"
"したt 仕立 慕"
"したs 親"
"したo 慕"
"したn 下"
"したk 下"
"したi 慕"
"したh 慕"
"したe 慕"
"したc 慕"
"しそんz 仕損 為損"
"しそんj 仕損 為損"
"しぜんn 自然"
"しずみこn 沈み込"
"しずみこm 沈み込"
"しずまりかえt 静まり返"
"しずまりかえr 静まり返"
"しずまりかえn 静まり返"
"しずまりかえc 静まり返"
"しずy 静"
"しずr 垂"
"しずn 沈 沒"
"しずm 沈 静 鎮 靜 鎭 沒"
"しずk 静 靜"
"しじょうむk 市場向"
"しじどおr 指示通"
"しさいr 子細"
"しさs 示唆"
"しごとはじm 仕事始"
"しごとだかばらi 仕事高払"
"しごk 扱"
"しごi 扱"
"しこうs 而"
"しこt 凝 痼"
"しこr 凝 痼"
"しこn 仕込 凝 痼"
"しこm 仕込"
"しこc 凝 痼"
"しげt 茂 繁 楙"
"しげs 繁"
"しげr 茂 繁 楙"
"しげn 茂 繁 楙"
"しげm 茂"
"しげk 繁"
"しげc 茂 繁 楙"
"しけt 湿気 時化"
"しけr 湿気 時化"
"しけp 湿気"
"しけn 湿気 時化"
"しけc 湿気 時化"
"しぐr 時雨"
"しくn 仕組"
"しくm 仕組"
"しきんぐr 資金繰"
"しきわm 爲極"
"しきりなおs 仕切り直"
"しきはm 爲極"
"しきつm 敷き詰"
"しきt 仕切 頻"
"しきr 仕切 頻"
"しきn 仕切 頻"
"しきc 仕切 頻"
"しがみつk しがみ付"
"しがみつi しがみ付"
"しかりつk 叱り付"
"しかたなs 仕方無"
"しかたなk 仕方無"
"しかたなi 仕方無"
"しかたなg 仕方無"
"しかしながr 然し乍 併し乍 乍"
"しかくばt 四角張"
"しかくばr 四角張"
"しかくばn 四角張"
"しかくばc 四角張"
"しかくs 四角"
"しかくk 四角"
"しかくi 四角"
"しかえs 仕返"
"しかt 叱 確 聢"
"しかs 然 併 而"
"しかr 叱 然"
"しかn 為兼 し兼 叱 爲兼"
"しかm 顰"
"しかk 仕掛 仕懸"
"しかc 叱"
"しおやk 塩焼"
"しおほs 爲果"
"しおづk 塩漬"
"しおだm 潮溜"
"しおたr 潮垂"
"しおくt 仕送 爲送"
"しおくr 仕送 爲送"
"しおくn 仕送 爲送"
"しおくc 仕送 爲送"
"しおからs 塩辛"
"しおからk 塩辛"
"しおからi 塩辛"
"しおからg 塩辛"
"しおおs 爲果"
"しおr 萎 撓 枝折 霑 責"
"しおk 仕置 爲置"
"しおi 仕置 爲置"
"しおe 為終"
"しうt 仕打"
"しいれr 仕入れ"
"しいたg 虐"
"しいt 強い"
"しいs 弑"
"しいr 仕入"
"しあわs 幸 倖 仕合"
"しあがt 仕上が 仕上"
"しあがr 仕上"
"しあがn 仕上"
"しあがc 仕上"
"しあw 仕合 為合 爲合"
"しあu 為合 爲合"
"しあt 為合 爲合"
"しあo 為合 爲合"
"しあi 為合 爲合"
"しあg 仕上"
"しあe 為合 爲合"
"しあc 為合 爲合"
"しy 為"
"しt 知 為 識 領 痴"
"しs 死 資 歯 齒 為"
"しr 知 識 領 痴 為"
"しn 死 知 為 識 領 痴 染 沁 凍 滲 浸"
"しm 占 閉 締 染 絞 沁 凍 滲 浸 〆 緊 閇 為"
"しk 敷 如 若 及"
"しi 強 敷 誣 如 若 及"
"しh 強 誣"
"しc 為 知 識"
"ざんねんg 残念"
"ざわt 騒"
"ざらs 晒 曝"
"ざつs 雑"
"ざつn 雑"
"ざつd 雑"
"ざかr 盛"
"ざいせきs 在籍"
"ざs 座 差 坐"
"ざr 戯"
"ざm 覚 醒 冷"
"ざk 咲 裂"
"ざi 咲 裂"
"ざe 冴"
"さんまいおr 三枚下"
"さんびょうしそろt 三拍子揃"
"さんせいいたs 賛成致"
"さんすくm 三竦"
"さんしょうくだs 参照下"
"さんしゅうくだs 参集下"
"さんけづk 産気付"
"さんけづi 産気付"
"さんかくだs 参加下"
"さんかいたs 参加致"
"さんかs 参加"
"さんz 参 散"
"さんs 産 算 参 賛 讃"
"さんj 参 散"
"さわぎだs 騒ぎ出"
"さわぎたt 騒ぎ立"
"さわy 爽"
"さわt 触 障 觸"
"さわr 触 障 觸"
"さわn 触 障 觸"
"さわi 騒 騷"
"さわg 騒 騷"
"さわc 触 障 觸"
"さりゆk 去り行"
"さらけだs 曝け出"
"さらあらi 皿洗"
"さらw 攫 浚 掠 復習 渫 濬"
"さらu 攫 浚 掠 復習 渫 濬"
"さらt 攫 浚 掠 復習 渫 濬"
"さらs 晒 曝"
"さらo 攫 浚 掠 復習 渫 濬"
"さらn 更 然ら"
"さらk 曝"
"さらi 攫 浚 掠 復習 渫 濬"
"さらh 浚 渫 復習"
"さらe 浚 渫 攫 掠 復習 濬"
"さらc 攫 浚 掠 復習 渫 濬"
"さらb 然ら"
"さやばしt 鞘走"
"さやばしr 鞘走"
"さやばしn 鞘走"
"さやばしc 鞘走"
"さやあt 鞘当"
"さめやr 覚め遣 醒め遣 冷め遣"
"さめr 寤"
"さむすg 寒過"
"さむざむs 寒々"
"さむu 寒"
"さむs 寒"
"さむm 寒"
"さむk 寒"
"さむi 寒"
"さむg 寒"
"さみs 寂 淋"
"さまよw 彷徨 さ迷 彷"
"さまよu 彷徨 さ迷 彷"
"さまよt 彷徨 さ迷 彷"
"さまよo 彷徨 さ迷 彷"
"さまよi 彷徨 さ迷 彷"
"さまよe 彷徨 さ迷 彷"
"さまよc 彷徨 さ迷 彷"
"さまたg 妨 碍"
"さまざまn 様々"
"さまがわr 様変"
"さまがw 様変"
"さまs 冷 醒"
"さぼt サボ"
"さぼr サボ"
"さぼn サボ"
"さぼc サボ"
"さぶらw 候"
"さぶらu 候"
"さぶらt 候"
"さぶらo 候"
"さぶらi 候"
"さぶらe 候"
"さぶらc 候"
"さびどm 錆止"
"さびつk 錆付 錆び付"
"さびつi 錆び付 錆付"
"さびs 寂 淋 寞 寥"
"さびr 寂"
"さばおr 鯖折"
"さばk 裁 捌"
"さばi 裁 捌"
"さながr 宛"
"さとがえr 里帰"
"さとうづk 砂糖漬"
"さとt 悟 覚"
"さとs 諭 聡 悟 訓 説 敏 慧"
"さとr 悟 覚"
"さとn 悟 覚"
"さとk 聡 敏 慧"
"さとi 聡 敏 慧"
"さとg 聡 敏 慧"
"さとc 悟 覚"
"さとb 俚"
"さておk 扨置 扨措"
"さておi 扨置 扨措"
"さついr 札入"
"さっぴk 差っ引"
"さっぴi 差っ引"
"さっちs 察知"
"さっきだt 殺気立"
"さっきだc 殺気立"
"さっt 颯"
"さっs 察"
"さちうすs 幸薄"
"さちうすk 幸薄"
"さちうすi 幸薄"
"さちうすg 幸薄"
"さだm 定"
"さだk 定"
"さぞy 嘸"
"さぞk 嘸"
"さそいだs 誘い出"
"さそいこn 誘い込"
"さそいこm 誘い込"
"さそいあわs 誘い合"
"さそいあw 誘い合"
"さそw 誘"
"さそu 誘 哘"
"さそt 誘"
"さそo 誘"
"さそi 誘"
"さそe 誘"
"さそc 誘"
"さずk 授"
"さすらw 流離"
"さすらu 流離"
"さすらt 流離"
"さすらo 流離"
"さすらi 流離"
"さすらe 流離"
"さすらc 流離"
"さすt 擦 摩"
"さすr 擦 摩"
"さすn 擦 摩"
"さすc 擦 摩"
"さしわたs 差し渡 差渡"
"さしもどs 差し戻 差戻"
"さしむかi 差向"
"さしむk 差し向"
"さしまわs 差し回"
"さしまねk 麾"
"さしまねi 麾"
"さしひかe 差し控 差控"
"さしひk 差し引 差引"
"さしひi 差し引 差引"
"さしはさn 差し挟 挟 挿"
"さしはさm 差し挟 挟 挿"
"さしのぼt 差し上 差し昇"
"さしのぼr 差し上 差し昇"
"さしのぼn 差し上 差し昇"
"さしのぼc 差し上 差し昇"
"さしのb 差し延 差し伸"
"さしぬi 刺し縫"
"さしとおs 刺し通"
"さしとm 差し止 差止"
"さしでg 差し出"
"さしづm 差し詰"
"さしつらぬk 刺し貫"
"さしつらぬi 刺し貫"
"さしつかw 差し遣"
"さしつかe 差し支 差支"
"さしちがe 差し違 刺し違"
"さしだs 差し出 差出"
"さしたt 差し立"
"さしせまt 差し迫"
"さしせまr 差し迫"
"さしせまn 差し迫"
"さしせまc 差し迫"
"さしずm 差し詰 差詰"
"さししめs 指し示"
"さしさわt 差し障 差障"
"さしさわr 差し障 差障"
"さしさわn 差し障 差障"
"さしさわc 差し障 差障"
"さしころs 刺し殺"
"さしこn 差し込 射し込 差込"
"さしこm 差し込 射し込 差込 指し込"
"さしきt 指切 指し切"
"さしきr 指切 指し切"
"さしきn 指切 指し切"
"さしきc 指切 指し切"
"さしかわs 差し交"
"さしかw 差し交"
"さしかk 差し掛"
"さしかe 差し替 差し換 挿し替"
"さしおさe 差押"
"さしおs 差し押"
"さしおk 差し置"
"さしおi 差し置"
"さしいそi 差し急"
"さしいそg 差し急"
"さしいr 差し入 挿し入 差入"
"さしあたt 差し当"
"さしあたr 差し当"
"さしあw 差し合"
"さしあu 差し合"
"さしあt 差し当 差し合"
"さしあo 差し合"
"さしあi 差し合"
"さしあg 差し上"
"さしあe 差し合"
"さしあc 差し合"
"ささわr 障"
"ささやk 囁"
"ささやi 囁"
"ささげもt 捧げ持"
"ささげもc 捧げ持"
"ささくれだt ささくれ立"
"ささくれだc ささくれ立"
"ささえあw 支え合"
"ささえあu 支え合"
"ささえあt 支え合"
"ささえあo 支え合"
"ささえあi 支え合"
"ささえあe 支え合"
"ささえあc 支え合"
"ささy 細"
"ささi 捧"
"ささg 捧"
"ささe 支"
"さげわたs 下げ渡"
"さげどm 下げ止"
"さげすn 蔑 貶"
"さげすm 蔑 貶"
"さけよi 酒酔"
"さけのm 酒飲"
"さけづk 酒漬"
"さけずk 酒好"
"さけくさs 酒臭"
"さけくさk 酒臭"
"さけくさi 酒臭"
"さけくさg 酒臭"
"さけn 叫"
"さけb 叫"
"さぐりだs 探り出"
"さぐりあw 探り合"
"さぐりあu 探り合"
"さぐりあt 探り当 探り合"
"さぐりあo 探り合"
"さぐりあi 探り合"
"さぐりあe 探り合"
"さぐりあc 探り合"
"さぐt 探"
"さぐr 探"
"さぐn 探"
"さぐc 探"
"さくづk 作付"
"さくせいいたs 作成致"
"さくせいs 作成"
"さくs 策"
"さきわたs 先渡"
"さきよm 先読"
"さきゆk 先行"
"さきものがi 先物買"
"さきみだr 咲き乱"
"さきまわr 先回"
"さきほこt 咲き誇"
"さきほこr 咲き誇"
"さきほこn 咲き誇"
"さきほこc 咲き誇"
"さきぶr 先触"
"さきばらi 先払"
"さきばしt 先走"
"さきばしr 先走"
"さきばしn 先走"
"さきばしc 先走"
"さきのこt 咲き残"
"さきのこr 咲き残"
"さきのこn 咲き残"
"さきのこc 咲き残"
"さきのb 先延"
"さきどr 先取"
"さきだt 先立"
"さきだc 先立"
"さきこぼr 咲き溢"
"さきがk 先駆"
"さきおくt 先送"
"さきおくr 先送"
"さきおくn 先送"
"さきおくc 先送"
"さきうt 先打"
"さきうr 先売"
"さきいt 先行"
"さきいk 先行"
"さきいc 先行"
"さきt 先"
"さきn 先"
"さきg 先"
"さがしまわt 捜し回 探し回"
"さがしまわr 探し回 捜し回"
"さがしまわn 探し回 捜し回"
"さがしまわc 探し回 捜し回"
"さがしだs 探し出 捜し出"
"さがしあt 探し当 捜し当"
"さがt 下"
"さがs 探 捜 搜"
"さがr 下 下が"
"さがn 下"
"さがc 下"
"さかもr 酒盛"
"さかむs 酒蒸"
"さかまk 逆巻"
"さかまi 逆巻"
"さかのぼt 遡 溯 泝 逆昇"
"さかのぼr 遡 溯 泝 逆昇 逆のぼ"
"さかのぼn 遡 溯 泝 逆昇"
"さかのぼc 遡 溯 泝 逆昇"
"さかなつr 魚釣"
"さかなかk 魚懸"
"さかなy 魚"
"さかだt 逆立"
"さかうらm 逆恨"
"さかあg 逆上"
"さかt 盛"
"さかs 逆 賢"
"さかr 逆 盛"
"さかn 盛"
"さかe 栄 盛 榮"
"さかc 盛"
"さえわたt 冴え渡 さえ渡"
"さえわたr 冴え渡 さえ渡"
"さえわたn 冴え渡 さえ渡"
"さえわたc 冴え渡 さえ渡"
"さえずt 囀 哢"
"さえずr 囀 哢"
"さえずn 囀 哢"
"さえずc 囀 哢"
"さえぎt 遮 峺"
"さえぎr 遮 峺"
"さえぎn 遮 峺"
"さえぎc 遮 峺"
"さいわいs 幸"
"さいわいn 幸"
"さいわいd 幸"
"さいわi 幸"
"さいばしt 才走"
"さいばしr 才走"
"さいばしn 才走"
"さいばしc 才走"
"さいはt 最果"
"さいなn 苛 嘖 呵"
"さいなm 苛 嘖 呵"
"さいこうn 最高"
"さいげんs 再現"
"さいきばしt 才気走"
"さいきばしr 才気走"
"さいきばしn 才気走"
"さいきばしc 才気走"
"さいかいs 再開"
"さいt 最"
"さいs 際 賽"
"さいn 際"
"さt 去"
"さs 差 刺 指 挿 射 鎖 注 点 止 然 捺 螫 插"
"さr 去 然 曝"
"さn 去"
"さm 覚 冷 醒 褪 然 覺"
"さk 咲 避 割 裂"
"さi 咲 裂 割 削"
"さg 下 提 差"
"さe 冴 冱"
"さc 去"
"さb 錆 寂 銹 荒"
"ごわつk 強付"
"ごわつi 強付"
"ごわt 強"
"ごろうz 御覧"
"ごろうj 御覧"
"ごろあw 語呂合"
"ごろs 殺 頃"
"ごろn 頃"
"ごろd 頃"
"ごれんらくねがw 御連絡願"
"ごれんらくねがu 御連絡願"
"ごれんらくねがt 御連絡願"
"ごれんらくねがo 御連絡願"
"ごれんらくねがi 御連絡願"
"ごれんらくねがe 御連絡願"
"ごれんらくねがc 御連絡願"
"ごれんらくいただk 御連絡戴 御連絡頂"
"ごれんらくいただi 御連絡戴 御連絡頂"
"ごりようくだs 御利用下 ご利用下"
"ごりかいくだs 御理解下"
"ごりかいいただk 御理解頂"
"ごりおs ゴリ押"
"ごらんくだs 御覧下"
"ごようはじm 御用始"
"ごようしゃくだs 御容赦下"
"ごようおさm 御用納"
"ごめんくだs 御免下"
"ごまかs 誤魔化 胡麻化"
"ごぶがr 五分刈"
"ごばらi 後払"
"ごのm 好"
"ごとうひょうくだs 御投票下"
"ごとs 如 若"
"ごとn 毎"
"ごとk 如 若"
"ごったがえs ごった返"
"ごちゅういくだs 御注意下"
"ごたe 応"
"ごぞんz 御存"
"ごぞんj 御存"
"ごしらe 拵"
"ごしようくだs 御使用下"
"ごしどうねがi 御指導願"
"ごしどうくだs 御指導下"
"ごしてきくだs 御指摘下"
"ござt 御座"
"ござr 御座"
"ござn 御座"
"ござi 御座"
"ごさんしょうくだs 御参照下"
"ごさんかくだs 御参加下"
"ごくつぶs 穀潰"
"ごきょうりょくくだs 御協力下"
"ごきょうじねがi 御教示願"
"ごきょうじくだs 御教示下"
"ごきょうじいただk 御教示頂"
"ごきょうじいただi 御教示頂"
"ごきたいくだs 御期待下"
"ごかつようくだs 御活用下"
"ごかくにんくだs 御確認下"
"ごえんりょくだs 御遠慮下"
"ごえs 肥"
"ごうじょっぱr 強情っ張"
"ごうs 号"
"ごいっぽうねがw 御一報願"
"ごいっぽうねがu 御一報願"
"ごいっぽうねがt 御一報願"
"ごいっぽうねがo 御一報願"
"ごいっぽうねがi 御一報願"
"ごいっぽうねがe 御一報願"
"ごいっぽうねがc 御一報願"
"ごいっぽうくだs 御一報下"
"ごいちどくくだs 御一読下"
"ごあんしんくだs 御安心下"
"ごs 越 期 伍"
"ごk 極"
"ごe 越 超"
"こんまk 根負"
"こんばんh 今晩"
"こんにちh 今日"
"こんくらb 根競"
"こんきよk 根気良"
"こんz 混"
"こんj 混"
"こわばt 強張"
"こわばr 強張"
"こわばn 強張"
"こわばc 強張"
"こわづくr 声作"
"こわすg 怖過"
"こわs 壊 怖 恐 毀 壞 強"
"こわr 壊 毀 壞"
"こわk 怖 恐 小分 強"
"こわi 怖 恐 強"
"こわg 怖 恐 強"
"こわb 硬"
"ころしあw 殺し合"
"ころしあu 殺し合"
"ころしあt 殺し合"
"ころしあo 殺し合"
"ころしあi 殺し合"
"ころしあe 殺し合"
"ころしあc 殺し合"
"ころげこn 転げ込"
"ころげこm 転げ込"
"ころがりこn 転がり込"
"ころがりこm 転がり込"
"ころがりおt 転がり落"
"ころがりおc 転がり落"
"ころs 殺"
"ころn 転 轉"
"ころg 転 轉"
"ころb 転 轉"
"こりかたm 凝り固"
"こらえきt 堪え切"
"こらえきr 堪え切"
"こらえきn 堪え切"
"こらえきc 堪え切"
"こらe 堪 怺"
"こやすs 小安"
"こやすk 小安"
"こやすi 小安"
"こやすg 小安"
"こやs 肥や"
"こもどr 小戻"
"こもt 籠 篭 隠"
"こもr 篭 籠 子守 隠"
"こもn 篭 籠 隠"
"こもc 篭 籠 隠"
"こめつk 米搗"
"こむらがえr 腓返"
"こむずかs 小難"
"こみだs 小見出"
"こみいt 込み入 混み入"
"こみいr 込み入"
"こみいn 込み入"
"こみいc 込み入"
"こみあw 混み合"
"こみあu 混み合"
"こみあt 混み合"
"こみあo 混み合"
"こみあi 混み合"
"こみあg 込み上"
"こみあe 混み合"
"こみあc 混み合"
"こまわr 小回 コマ割"
"こまりはt 困り果"
"こまりぬk 困り抜"
"こまりぬi 困り抜"
"こまりきt 困り切"
"こまりきr 困り切"
"こまりきn 困り切"
"こまりきc 困り切"
"こまむすb 細結"
"こまねk 拱"
"こまねi 拱"
"こまぬk 拱"
"こまぬi 拱"
"こまづかi 小間使"
"こまつかi 小間使"
"こまたすくi 小股掬"
"こまぐm 駒組"
"こまぎr 細切 小間切"
"こまかi 細か"
"こまy 細 濃"
"こまt 困"
"こまs 細"
"こまr 困"
"こまn 困"
"こまm 小ま"
"こまk 細"
"こまi 細"
"こまg 細"
"こまc 困"
"こぼt 毀"
"こぼs 零 溢 毀"
"こぼr 溢 零 毀"
"こほr 凍 氷"
"こぶr 小振 小降"
"こびりつk こびり付"
"こびりつi こびり付"
"こびへつらw 媚び諂"
"こびへつらu 媚び諂"
"こびへつらt 媚び諂"
"こびへつらo 媚び諂"
"こびへつらi 媚び諂"
"こびへつらc 媚び諂"
"こばなr 子離"
"こばしr 小走"
"こばn 拒"
"こばm 拒"
"こはずk 小恥"
"こはz 小恥"
"このn 好"
"このm 好"
"こねまわs 捏ね回"
"こねくりまわs こねくり回"
"こねあg 捏ね上"
"こにくs 小憎"
"こにくr 小憎"
"こにくk 小憎"
"こにくi 小憎"
"こにくg 小憎"
"こなs 熟"
"こなr 熟"
"こなk 子泣"
"こどもむk 子供向"
"こどもづr 子供連"
"こどもずk 子供好"
"こどもじm 子供染"
"こどもあつかi 子供扱"
"こどもr 子供"
"こどもp 子供"
"ことわりきr 断り切"
"ことわりがk 断り書"
"ことわt 断 斷 判"
"ことわr 断 判 斷"
"ことわn 断 判 斷"
"ことわc 断 判 斷"
"ことよs 事寄 言寄"
"こともなg 事も無"
"ことほどさようn 事程左様"
"ことほi 寿"
"ことほg 言祝 寿"
"ことばどおr 言葉通"
"ことばづかi 言葉遣 言葉使"
"ことばあそb 言葉遊"
"ことはじm 事始"
"ことなt 異"
"ことなr 異"
"ことなn 異"
"ことなc 異"
"こととh 言問"
"ことづt 言伝 言傳"
"ことづk 言付 託"
"ことたt 事足"
"ことたr 事足"
"ことたn 事足"
"ことたc 事足"
"ことずk 託"
"ことごとs 事々"
"ことごとk 悉 尽 盡"
"ことこまy 事細"
"ことこまk 事細"
"ことぎr 事切"
"こときr 事切"
"ことかk 事欠"
"ことかi 事欠"
"ことえr 言選"
"こといm 言忌"
"ことあたらs 事新"
"ことあg 言挙"
"ことw 断 斷"
"ことn 異 殊"
"こてなg 小手投"
"こてしらb 小手調"
"こづかi 小遣"
"こづr 子連"
"こづk 小突"
"こづi 小突"
"こつあg 骨揚"
"こっぴどs こっ酷"
"こっぴどk こっ酷"
"こっぴどi こっ酷"
"こっぴどg こっ酷"
"こっぱz 小っ恥 こっ恥"
"こだわt 拘 拘泥"
"こだわr 拘 拘泥"
"こだわn 拘 拘泥"
"こだわc 拘 拘泥"
"こだまs 谺"
"こだかs 小高"
"こだかk 小高"
"こだかi 小高"
"こだかg 小高"
"こだs 小出"
"こたh 堪 答 應"
"こたe 答 応 堪 應"
"こぞt 挙"
"こぞr 挙"
"こぞn 挙"
"こぞc 挙"
"こそだt 子育"
"こそi 刮"
"こそg 刮"
"こぜわs 小忙"
"こせいゆたk 個性豊"
"こすりつk 擦り付"
"こすっからs 狡っ辛"
"こすっからk 狡っ辛"
"こすっからi 狡っ辛"
"こすっからg 狡っ辛"
"こすからs 狡辛"
"こすからk 狡辛"
"こすからi 狡辛"
"こすからg 狡辛"
"こすt 擦 錯"
"こすs 狡"
"こすr 擦 錯"
"こすn 擦 錯"
"こすk 狡"
"こすi 狡"
"こすg 濃過 狡"
"こすc 擦 錯"
"こじあk 抉じ開"
"こじt 抉"
"こじs 誇示"
"こじr 抉 拗"
"こじn 抉"
"こじc 抉"
"こしらh 拵"
"こしらe 拵"
"こしまわr 腰回"
"こしぬk 腰抜"
"こしなg 腰投"
"こしづk 腰付"
"こしくだk 腰砕"
"こしかk 腰掛"
"こざかs 小賢"
"こさむs 小寒"
"こさむk 小寒"
"こさむi 小寒"
"こさむg 小寒"
"こごろs 子殺"
"こごえはt 凍え果"
"こごえじn 凍え死"
"こごえしn 凍え死"
"こごt 凝"
"こごr 凝"
"こごn 凝 屈"
"こごm 屈"
"こごe 凍"
"こごc 凝"
"こころよs 快"
"こころよk 快"
"こころよi 快"
"こころよg 快"
"こころゆるs 心許"
"こころゆk 心行"
"こころやすs 心安"
"こころやすr 心安"
"こころやすk 心安"
"こころやすi 心安"
"こころやすg 心安"
"こころやさs 心優"
"こころもとなs 心許無"
"こころもとなk 心許無"
"こころもとなi 心許無"
"こころもとなg 心許無"
"こころもt 心持"
"こころもc 心持"
"こころみだr 心乱"
"こころみr 試み"
"こころまどi 心惑"
"こころまt 心待"
"こころまc 心待"
"こころぼそs 心細"
"こころぼそk 心細"
"こころぼそi 心細"
"こころぼそg 心細"
"こころぶとs 心太"
"こころひk 心魅"
"こころのこr 心残"
"こころにくs 心憎"
"こころにくk 心憎"
"こころにくi 心憎"
"こころにくg 心憎"
"こころなs 心無"
"こころなk 心無"
"こころなi 心無"
"こころなg 心無"
"こころづよs 心強"
"こころづよk 心強"
"こころづよi 心強"
"こころづよg 心強"
"こころづくs 心尽"
"こころづかi 心遣 心使"
"こころづk 心付"
"こころしずk 心静"
"こころざs 志"
"こころさみs 心淋"
"こころさびs 心淋 心寂"
"こころぐるs 心苦"
"こころくばr 心配"
"こころがまe 心構"
"こころがk 心掛"
"こころおだy 心穏"
"こころおきなs 心置き無"
"こころおきなk 心置き無"
"こころおきなi 心置き無"
"こころおt 心落"
"こころおk 心置"
"こころおi 心置"
"こころえz 心得"
"こころえy 心得"
"こころえt 心得"
"こころえs 心得"
"こころえr 心得"
"こころえn 心得"
"こころえm 心得"
"こころえk 心得"
"こころえc 心得"
"こころうごk 心動"
"こころいr 心入"
"こころあたたm 心温 心暖"
"こころあたr 心当"
"こころあt 心当"
"こころs 心"
"こころm 試"
"こころh 心"
"こころg 心"
"ここのt 九"
"ここちよs 心地良 心地好"
"ここちよk 心地良 心地好"
"ここちよi 心地良 心地好"
"ここちよg 心地良 心地好"
"ここn 個々 茲 爰 是"
"こげくさs 焦げ臭"
"こげくさk 焦げ臭"
"こげくさi 焦げ臭"
"こげくさg 焦げ臭"
"こけらおとs 柿落"
"こけむs 苔生"
"こけt コケ"
"こけr コケ"
"こけn コケ"
"こけc コケ"
"こぐらs 小暗 木暗"
"こぐらk 小暗 木暗"
"こぐらi 小暗 木暗"
"こぐらg 小暗 木暗"
"こくt 告"
"こくs 酷 刻"
"こくr 告"
"こくn 告 酷"
"こくd 酷"
"こくc 告"
"こぎつk 漕ぎ着"
"こぎだs 漕ぎ出"
"こぎたなs 小汚"
"こぎたなk 小汚"
"こぎたなi 小汚"
"こぎたなg 小汚"
"こきみよs 小気味良 小気味好"
"こきみよk 小気味良 小気味好"
"こきみよi 小気味良 小気味好"
"こきみよg 小気味良"
"こきつかw 扱き使"
"こきつかu 扱き使"
"こきつかt 扱き使"
"こきつかo 扱き使"
"こきつかi 扱き使"
"こきつかe 扱き使"
"こきつかc 扱き使"
"こきざm 小刻"
"こきおr 扱き下"
"こがらs 木枯"
"こがs 焦"
"こがr 焦 木枯"
"こかs 転 倒"
"こおりづk 氷漬"
"こおりつk 凍り付"
"こおりつi 凍り付"
"こおりけずr 氷削"
"こおt 凍 氷"
"こおr 凍 氷"
"こおn 凍 氷"
"こおc 凍 氷"
"こえふとt 肥え太"
"こえふとr 肥え太"
"こえふとn 肥え太"
"こえふとc 肥え太"
"こえだs 声出"
"こえたかk 声高"
"こえがわr 声変"
"こえかk 声掛"
"こえt 超"
"こうるさs 小煩"
"こうるさk 小煩"
"こうるさi 小煩"
"こうるさg 小煩"
"こうりょs 考慮"
"こうむt 被 蒙"
"こうむr 被 蒙"
"こうむn 被 蒙"
"こうむc 被 蒙"
"こうだいn 広大"
"こうそくn 高速"
"こうせいn 公正"
"こうしきr 抗し切"
"こうごうs 神々"
"こうごk 小動"
"こうげきs 攻撃"
"こうきゅうとr 高給取"
"こうz 講 高 困 昂 嵩 考"
"こうs 抗 航"
"こうr 小売"
"こうj 講 高 昂 嵩 困"
"こうb 香 芳"
"こいねがはk 希"
"こいねがw 希 乞い願 冀 庶幾"
"こいねがu 希 乞い願 冀 庶幾"
"こいねがt 希 乞い願 冀 庶幾"
"こいねがo 希 乞い願 冀 庶幾"
"こいねがi 希 乞い願 冀 庶幾"
"こいねがe 希 乞い願 冀 庶幾"
"こいねがc 希 乞い願 冀 庶幾"
"こいしたw 恋い慕"
"こいしたu 恋い慕"
"こいしたt 恋い慕"
"こいしたo 恋い慕"
"こいしたi 恋い慕"
"こいしたe 恋い慕"
"こいしたc 恋い慕"
"こいおおk 恋多"
"こいs 恋 戀"
"こz 来 來 徠"
"こy 肥 来 越 來 徠"
"こw 請 乞 恋 戀"
"こu 乞 請 恋 斯 買 戀"
"こt 凝"
"こs 越 超 漉 濾 来 濃 鼓 糊 來 徠"
"こr 凝 懲 来 此 樵 來 徠"
"こo 乞 請 恋 戀"
"こn 込 来 混 捏 此 來 徠 凝"
"こm 込 混 籠 篭"
"こk 濃 扱 転 放 痩 倒"
"こi 濃 乞 来 漕 請 來 徠 恋 戀 扱 放"
"こh 乞 請 戀"
"こg 漕 焦 扱 濃"
"こe 越 超 肥 踰 乞 請 恋 戀"
"こd 子 小"
"こc 凝"
"こb 媚"
"げんなおs 験直"
"げんつk 原付"
"げんだいかなづかi 現代仮名遣"
"げんじつばなr 現実離"
"げんさくどおr 原作通"
"げんきよk 元気良"
"げんきづk 元気付"
"げんz 減"
"げんs 減"
"げんn 現"
"げんj 減"
"げびt 下卑"
"げびr 下卑"
"げぎらi 毛嫌"
"げきs 激 檄"
"げs 解 觧"
"げr 蹴"
"げn 実"
"けんとうはずr 見当外"
"けんとうちがi 見当違"
"けんとうs 検討"
"けんしょうずm 検証済"
"けんいづk 権威付"
"けんz 献"
"けんs 検 験"
"けんj 献"
"けわw 化粧"
"けわu 化粧"
"けわt 化粧"
"けわs 険 峻 險"
"けわo 化粧"
"けわi 化粧"
"けわe 化粧"
"けわc 化粧"
"けりとb 蹴飛"
"けりたおs 蹴り倒"
"けりころs 蹴り殺"
"けりこn 蹴り込"
"けりこm 蹴り込"
"けりいr 蹴り入"
"けりあg 蹴り上"
"けやぶt 蹴破"
"けやぶr 蹴破"
"けやぶn 蹴破"
"けやぶc 蹴破"
"けむt 煙 烟"
"けむs 煙"
"けむr 煙 烟"
"けむn 煙 烟"
"けむk 煙"
"けむi 煙"
"けむg 煙"
"けむc 煙 烟"
"けみs 閲"
"けぶかs 毛深"
"けぶかk 毛深"
"けぶかi 毛深"
"けぶかg 毛深"
"けぶt 煙 烟"
"けぶs 煙"
"けぶr 煙 烟"
"けぶn 煙 烟"
"けぶk 煙"
"けぶi 煙"
"けぶg 煙"
"けぶc 煙 烟"
"けばだt 毛羽立"
"けばだc 毛羽立"
"けばs ケバ"
"けばk ケバ"
"けばi ケバ"
"けばg ケバ"
"けはh 化粧"
"けなs 貶"
"けなm 毛並"
"けどt 気取"
"けどr 気取"
"けどn 気取"
"けどc 気取"
"けとb 蹴飛"
"けづくろi 毛繕"
"けづr 削 梳"
"けつろんづk 結論付"
"けつまずk 蹴躓"
"けつまずi 蹴躓"
"けっとb 蹴っ飛"
"けっていづk 決定付"
"けっていいたs 決定致"
"けっていs 決定"
"けっしゅうs 結集"
"けっs 決 結"
"けちくさs ケチ臭 けち臭"
"けちくさk ケチ臭 けち臭"
"けちくさi ケチ臭 けち臭"
"けちくさg ケチ臭 けち臭"
"けちr 蹴散"
"けだるs 気怠"
"けだるk 気怠"
"けだるi 気怠"
"けだるg 気怠"
"けだかs 気高"
"けだかk 気高"
"けだかi 気高"
"けだかg 気高"
"けだs 蓋"
"けたはずr 桁外"
"けたちがi 桁違"
"けたちがh 桁違"
"けたぐr 蹴手繰"
"けたおs 蹴倒"
"けたt 蹴立"
"けずりとt 削り取"
"けずりとr 削り取"
"けずりとn 削り取"
"けずりとc 削り取"
"けずt 削 梳"
"けずr 削 梳"
"けずn 削 梳"
"けずc 削 梳"
"けしわすr 消し忘"
"けしとn 消し飛"
"けしとm 消し止"
"けしとb 消し飛"
"けしさt 消し去"
"けしさr 消し去"
"けしさn 消し去"
"けしさc 消し去"
"けしこn 消し込"
"けしこm 消し込"
"けしきb 気色"
"けしかk 嗾"
"けさがたm 袈裟固"
"けこn 蹴込"
"けこm 蹴込"
"けぎらi 毛嫌"
"けがs 汚 穢 涜"
"けがr 汚 穢"
"けかえs 蹴返"
"けおとs 蹴落"
"けおt 蹴落"
"けおs 気圧"
"けうとs 気疎"
"けうとk 気疎"
"けうとi 気疎"
"けうとg 気疎"
"けいとうだt 系統立"
"けいじs 掲示"
"けいしきばt 形式張"
"けいしきばr 形式張"
"けいしきばn 形式張"
"けいしきばc 形式張"
"けいさんだかs 計算高"
"けいさんだかk 計算高"
"けいさんだかi 計算高"
"けいさんだかg 計算高"
"けいこくs 警告"
"けいけんゆたk 経験豊"
"けいけんs 経験"
"けいきよk 景気良"
"けいきづk 景気付"
"けいかいn 軽快"
"けいえいs 経営"
"けいs 敬 詣 啓 慶"
"けあg 蹴上"
"けy 蹴"
"けt 蹴"
"けs 消 怪 決"
"けr 蹴"
"けn 蹴 異"
"けc 蹴"
"ぐんs 軍"
"ぐろs 黒 グロ"
"ぐろk 黒 グロ"
"ぐろi 黒 グロ"
"ぐろg 黒 グロ"
"ぐるs 苦"
"ぐるm 包"
"ぐるi 狂"
"ぐらs 暮"
"ぐちt 愚痴"
"ぐちr 愚痴"
"ぐちp 愚痴"
"ぐちn 愚痴"
"ぐちc 愚痴"
"ぐずt 愚図"
"ぐずr 愚図"
"ぐずn 愚図"
"ぐずc 愚図"
"ぐさr 腐"
"ぐうs 遇 寓"
"ぐあi 具合"
"ぐs 具"
"ぐr 暮"
"ぐn 組"
"ぐm 組"
"ぐi 食"
"くんよm 訓読"
"くんづk 君付"
"くんだr 下"
"くわわt 加わ"
"くわだt 企"
"くわずぎらi 食わず嫌"
"くわえこn 咥え込 銜え込"
"くわえこm 咥え込 銜え込"
"くわw 加"
"くわs 詳 精 委"
"くわr 区割"
"くわk 区分"
"くわe 加 咥 銜"
"くろびかr 黒光"
"くろぬr 黒塗"
"くろすg 黒過"
"くろこg 黒焦"
"くろz 黒"
"くろu 黒 玄"
"くろs 黒 玄 梍"
"くろp 黒"
"くろm 黒"
"くろk 黒 玄 梍"
"くろi 黒 玄 梍"
"くろg 黒 玄 梍"
"くれゆk 暮れ行"
"くれなずn 暮れ泥"
"くれなずm 暮れ泥"
"くれかk 暮れ掛"
"くるめk 眩"
"くるめi 眩"
"くるしみぬk 苦しみ抜"
"くるしみぬi 苦しみ抜"
"くるしまぎr 苦し紛"
"くるw 狂"
"くるu 狂"
"くるt 狂"
"くるs 苦"
"くるo 狂"
"くるn 包"
"くるm 包"
"くるi 狂"
"くるh 狂"
"くるe 狂"
"くるc 狂"
"くりもどs 繰り戻 繰戻"
"くりひろg 繰り広"
"くりのb 繰り延 繰延"
"くりぬk 刳り貫"
"くりぬi 刳り貫"
"くりだs 繰り出"
"くりさg 繰り下"
"くりこs 繰り越 繰越"
"くりこn 繰り込"
"くりこm 繰り込"
"くりかえs 繰り返 繰返"
"くりかe 繰替"
"くりいr 繰り入"
"くりあわs 繰り合"
"くりあw 繰り合"
"くりあg 繰り上 繰上"
"くらすg 暗過"
"くらざらe 蔵浚"
"くらがe 鞍替"
"くらいどr 位取"
"くらいづk 位付"
"くらいつk 食らい付 喰らい付"
"くらいつi 食らい付 喰らい付"
"くらいこn 食らい込 喰らい込"
"くらいこm 食らい込 喰らい込"
"くらいs 位"
"くらu 喰ら 食ら"
"くらt 食"
"くらs 暮 暗 昏 冥 暝 眛 罔"
"くらn 眩 暗"
"くらm 眩 晦 暗 昏 冥 暝 眛 罔"
"くらk 暗 昏 冥 暝 眛 罔"
"くらi 暗 昏 冥 暝 罔 眛"
"くらg 暗 昏 冥 暝 眛 罔"
"くらe 喰ら"
"くらb 比 較 競"
"くゆr 燻 薫"
"くやしなk 悔し泣"
"くやs 悔 口惜"
"くやn 悔"
"くやm 悔"
"くもゆk 雲行"
"くもがくr 雲隠"
"くもt 曇"
"くもr 曇"
"くもn 曇"
"くもc 曇"
"くみわk 組分 組み分"
"くみふs 組み伏"
"くみとt 汲み取"
"くみとr 汲み取"
"くみとn 汲み取"
"くみとc 汲み取"
"くみつk 組付 組み付"
"くみつi 組み付"
"くみだs 汲み出"
"くみたてr 組み立て"
"くみたt 組み立 組立"
"くみしやすs 与し易"
"くみしやすk 与し易"
"くみしやすi 与し易"
"くみしやすg 与し易"
"くみこn 組み込 組込"
"くみこm 組込 組み込"
"くみかわs 酌み交"
"くみかw 酌み交"
"くみかe 組替 組み換 組み替 組換"
"くみおk 汲み置 汲置"
"くみおi 汲み置 汲置"
"くみいr 組み入 組入"
"くみあわs 組合 組み合 組み合わ"
"くみあw 組み合 組合"
"くみあg 汲み上 組み上 組上"
"くみs 与 與"
"くまどt 隈取"
"くまどr 隈取"
"くまどn 隈取"
"くまどc 隈取"
"くぼn 窪 凹"
"くぼm 窪 凹"
"くべつs 区別"
"くびりころs 縊り殺"
"くびひねr 首捻"
"くびなg 首投"
"くびっぴk 首っ引"
"くびくくr 首縊"
"くびがたm 首固"
"くびt 首 括 縊"
"くびr 括 縊"
"くびn 括 縊"
"くびc 括 縊"
"くばt 配"
"くばr 配"
"くばn 配"
"くばc 配"
"くはh 加 銜"
"くどきおt 口説き落"
"くどs 諄"
"くどk 口説 諄"
"くどi 口説 諄"
"くどg 諄"
"くづほr 頽"
"くづs 崩"
"くつろi 寛"
"くつろg 寛"
"くつずr 靴擦"
"くつがへs 覆"
"くつがへr 覆"
"くつがえt 覆"
"くつがえs 覆"
"くつがえr 覆"
"くつがえn 覆"
"くつがえc 覆"
"くっつk くっ付"
"くっつi くっ付"
"くっt 食"
"くっs 屈"
"くちをs 口惜"
"くちよごs 口汚"
"くちやかまs 口喧"
"くちぶr 口振"
"くちふうj 口封"
"くちばしt 口走"
"くちばしr 口走"
"くちばしn 口走"
"くちばしc 口走"
"くちはばt 口幅"
"くちはt 朽ち果"
"くちなおs 口直"
"くちなs 口無"
"くちなr 口馴 口慣"
"くちどr 口取"
"くちどm 口止"
"くちづk 口付"
"くちだs 口出"
"くちぞe 口添"
"くちずさn 口遊"
"くちずさm 口遊"
"くちすすi 漱 嗽"
"くちすすg 漱 嗽"
"くちさびs 口寂"
"くちごもt 口籠"
"くちごもr 口籠"
"くちごもn 口籠"
"くちごもc 口籠"
"くちごたe 口答"
"くちごm 口籠"
"くちぎたなs 口穢"
"くちぎたなk 口穢"
"くちぎたなi 口穢"
"くちぎたなg 口穢"
"くちきr 口切"
"くちきk 口利"
"くちおs 口惜"
"くちうるさs 口煩"
"くちうるさk 口煩"
"くちうるさi 口煩"
"くちうるさg 口煩"
"くちうつs 口移"
"くちあたr 口当"
"くちあt 口当"
"くちz 口"
"くだけちt 砕け散"
"くだけちr 砕け散"
"くだけちn 砕け散"
"くだけちc 砕け散"
"くだt 下 降"
"くだs 下 降"
"くだr 下 降"
"くだn 下 降"
"くだk 砕 碎"
"くだi 砕 碎"
"くだc 下 降"
"くたびr 草臥"
"くたs 腐"
"くそあつs 糞暑 クソ暑 くそ暑"
"くそあつk 糞暑 クソ暑 くそ暑"
"くそあつi 糞暑 クソ暑 くそ暑"
"くそあつg 糞暑 クソ暑 くそ暑"
"くせn 癖"
"くずれさt 崩れ去"
"くずれさr 崩れ去"
"くずれさn 崩れ去"
"くずれさc 崩れ去"
"くずれおt 崩れ落"
"くずれおc 崩れ落"
"くずきr 葛切"
"くずおr 頽"
"くずs 崩"
"くずr 崩"
"くすりづk 薬漬"
"くすりうr 薬売"
"くすぶt 燻"
"くすぶr 燻 燻ぶ"
"くすぶn 燻"
"くすぶc 燻"
"くすぐt 擽"
"くすぐr 擽"
"くすぐn 擽"
"くすぐc 擽"
"くすs 奇"
"くすk 奇"
"くすi 奇"
"くすg 擽 奇"
"くすb 燻"
"くじびk 籤引"
"くじk 挫"
"くじi 挫"
"くしざs 串刺"
"くしけづr 梳"
"くしけずt 梳"
"くしけずr 梳"
"くしけずn 梳"
"くしけずc 梳"
"くさわk 草分"
"くさりはt 腐り果"
"くさぶかs 草深"
"くさぶかk 草深"
"くさぶかi 草深"
"くさぶかg 草深"
"くさふかs 草深"
"くさふかk 草深"
"くさふかi 草深"
"くさふかg 草深"
"くさとr 草取"
"くさかr 草刈"
"くさt 腐"
"くさs 臭"
"くさr 腐 鏈"
"くさn 腐"
"くさm 臭"
"くさk 臭"
"くさi 臭"
"くさg 臭"
"くさc 腐"
"くぐりぬk 潜り抜 くぐり抜"
"くぐt 潜 潛"
"くぐr 潜 潛"
"くぐn 潜 潛"
"くぐc 潜 潛"
"くくりつk 括り付"
"くくりあg 括り上"
"くくt 括"
"くくr 括"
"くくn 括"
"くくm 銜 含"
"くくc 括"
"くぎづk 釘付"
"くぎt 区切"
"くぎr 区切"
"くぎn 区切"
"くぎc 区切"
"くえこn 崩え込"
"くえこm 崩え込"
"くうきいr 空気入"
"くいやぶt 食い破"
"くいやぶr 食い破"
"くいやぶn 食い破"
"くいやぶc 食い破"
"くいのこs 食い残"
"くいにg 食い逃"
"くいとm 食い止 喰い止"
"くいつぶs 食い潰"
"くいつなi 食い繋"
"くいつなg 食い繋"
"くいつくs 食い尽"
"くいつm 食い詰"
"くいつk 食い尽 食い付"
"くいつi 食い付"
"くいちぎt 食い千切"
"くいちぎr 食い千切"
"くいちぎn 食い千切"
"くいちぎc 食い千切"
"くいちがw 食い違 喰い違"
"くいちがu 食い違 喰い違"
"くいちがt 食い違 喰い違"
"くいちがo 食い違 喰い違"
"くいちがi 食い違 喰い違"
"くいちがe 食い違 喰い違"
"くいちがc 食い違 喰い違"
"くいちr 食い散"
"くいたr 食い足"
"くいすg 食い過 喰い過"
"くいしばt 食い縛 喰い縛"
"くいしばr 食い縛 喰い縛"
"くいしばn 食い縛 喰い縛"
"くいしばc 食い縛 喰い縛"
"くいさg 食い下"
"くいころs 食い殺"
"くいこn 食い込 喰い込"
"くいこm 食い込 喰い込"
"くいきt 食い切"
"くいきr 食い切"
"くいきn 食い切"
"くいきc 食い切"
"くいいt 食い入 喰い入"
"くいいr 食い入 喰い入"
"くいいn 食い入 喰い入"
"くいいc 食い入 喰い入"
"くいあわs 食い合"
"くいあらたm 悔い改"
"くいあw 食い合"
"くいあr 食い荒"
"くいあk 食い飽"
"くy 悔"
"くw 食 喰"
"くu 食 喰"
"くt 食 朽 喰 繰 刳"
"くs 奇 屈"
"くr 来 繰 暮 食 喰 呉 刳 來 徠 眩"
"くo 食 喰"
"くn 組 汲 酌 苦 来 繰 刳 來 徠"
"くm 組 汲 酌"
"くk 絎"
"くi 食 喰 悔"
"くh 食"
"くg 絎"
"くe 食 喰"
"くc 朽 喰 食 繰 刳"
"くb 焼"
"ぎんz 吟"
"ぎんj 吟"
"ぎりだt 義理立"
"ぎりがたs 義理堅"
"ぎりがたk 義理堅"
"ぎりがたi 義理堅"
"ぎりがたg 義理堅"
"ぎらi 嫌"
"ぎょりんがかr 魚鱗懸"
"ぎょちょうどm 魚鳥止"
"ぎょうぎょうs 仰々 仰仰"
"ぎょうz 行"
"ぎょs 御"
"ぎゅうじt 牛耳"
"ぎゅうじr 牛耳"
"ぎゅうじn 牛耳"
"ぎゅうじc 牛耳"
"ぎゃっこうs 逆行"
"ぎゃくもどr 逆戻"
"ぎゃくむk 逆向"
"ぎゃくまわr 逆回"
"ぎゃくびk 逆引"
"ぎゃくばr 逆張"
"ぎゃくじょうs 逆上"
"ぎゃくじゅうじがたm 逆十字固"
"ぎゃくs 逆"
"ぎゃくn 逆"
"ぎゃくd 逆"
"ぎむづk 義務付"
"ぎt 切"
"ぎs 擬 議 義 偽"
"ぎr 切 斬"
"ぎn 切 義 偽"
"ぎm 決"
"ぎd 義 偽"
"ぎc 切"
"きんとうわr 均等割"
"きんちょうs 緊張"
"きんじえz 禁じ得"
"きんじえn 禁じ得"
"きんz 禁"
"きんj 禁"
"きをつk 気を付"
"きわどs 際疾"
"きわどk 際疾"
"きわどi 際疾"
"きわどg 際疾"
"きわだt 際立"
"きわだc 際立 極立"
"きわm 極 究 窮"
"きわd 際"
"きろくやぶr 記録破"
"きれこn 切れ込"
"きれこm 切れ込"
"きれいずk 綺麗好"
"きれあg 切れ上"
"きれz キレ"
"きれt キレ"
"きれs キレ"
"きれr キレ"
"きれn キレ"
"きれm キレ"
"きれk キレ"
"きれc キレ"
"きりわk 切り分"
"きりもどs 切り戻"
"きりもr 切り盛"
"きりもm 錐揉"
"きりまわs 切り回"
"きりまz 切り混"
"きりふs 切り伏 斬り伏"
"きりふk 霧吹"
"きりひろg 切り広"
"きりひらk 切り開 切開"
"きりひらi 切り開 切開"
"きりはなs 切り離 切離"
"きりはr 切り貼"
"きりぬk 切り抜 切抜"
"きりぬi 切り抜 切抜"
"きりなおs 切り直"
"きりどおs 切り通 切通"
"きりとおs 切り通 切通"
"きりとt 切り取 切取"
"きりとr 切り取 切取"
"きりとn 切り取 切取"
"きりとc 切り取 切取"
"きりづk 切り漬"
"きりつm 切り詰"
"きりつk 切り付 斬り付"
"きりだs 切り出 切出"
"きりたおs 切り倒 斬り倒"
"きりたt 切り立"
"きりたc 切り立"
"きりそろe 切り揃"
"きりすt 切り捨 斬り捨 切捨 斬捨"
"きりさk 切り裂 斬り裂"
"きりさi 切り裂 斬り裂"
"きりさg 切り下 切下"
"きりころs 切り殺 斬り殺"
"きりこn 切り込 切込 斬り込"
"きりこm 切り込 切込 斬り込"
"きりくずs 切り崩"
"きりきざn 切り刻"
"きりきざm 切り刻"
"きりかえs 切り返"
"きりかえr 切り換え"
"きりかw 切り替 切替"
"きりかk 斬り掛 切り掛"
"きりかe 切り替 切替 切り換 切換"
"きりおとs 切り落"
"きりおt 切り落"
"きりおr 切り下"
"きりうr 切り売"
"きりあw 斬り合"
"きりあu 斬り合"
"きりあt 斬り合"
"きりあo 斬り合"
"きりあi 斬り合"
"きりあg 切り上 切上"
"きりあe 斬り合"
"きりあc 斬り合"
"きらめk 煌"
"きらめi 煌"
"きらw 嫌"
"きらu 嫌"
"きらt 嫌"
"きらo 嫌"
"きらm 煌"
"きらi 嫌"
"きらh 嫌"
"きらe 嫌"
"きらc 嫌"
"きらb 燦"
"きよs 清 浄"
"きよr 清"
"きよm 清 浄"
"きよk 清 浄"
"きよi 清 浄"
"きよg 清 浄"
"きょぜつs 拒絶"
"きょくりょくさk 極力避"
"きょくs 曲 局"
"きょうりょくくだs 協力下"
"きょうみぶかs 興味深"
"きょうみぶかk 興味深"
"きょうみぶかi 興味深"
"きょうみぶかg 興味深"
"きょうだいn 強大"
"きょうじゅくだs 教授下"
"きょうじくだs 教示下"
"きょうしゅくs 恐縮"
"きょうざm 興醒"
"きょうかしょどおr 教科書通"
"きょうかぎr 今日限"
"きょうz 興"
"きょうs 供 饗 狂"
"きょうn 今日"
"きょうm 今日"
"きょうj 興"
"きょうh 今日"
"きゅうしょげr 急所蹴"
"きゅうしゅうs 吸収"
"きゅうs 窮 給 休 急 仇"
"きゅうn 急"
"きゅうd 急"
"きやすs 気安"
"きやすm 気休"
"きやすk 気安"
"きやすi 気安"
"きやすg 気安"
"きやs 着痩"
"きゃくよs 客寄"
"きゃくひk 客引"
"きゃくあつかi 客扱"
"きもちわるs 気持ち悪 気持悪"
"きもちわるk 気持ち悪 気持悪"
"きもちわるi 気持ち悪 気持悪"
"きもちわるg 気持ち悪 気持悪"
"きもちよs 気持ち良"
"きもちよk 気持ち良"
"きもちよi 気持ち良"
"きもちよg 気持ち良"
"きもだめs 肝試"
"きもいr 肝煎"
"きもt 気持"
"きもs キモ"
"きもk キモ"
"きもi キモ"
"きもg キモ"
"きもc 気持"
"きめつk 決め付"
"きめこまk 木目細 きめ細 肌理細"
"きめこn 決め込"
"きめこm 決め込 木目込"
"きむづかs 気難"
"きむずかs 気難"
"きみわるs 気味悪"
"きみわるk 気味悪"
"きみわるi 気味悪"
"きみわるg 気味悪"
"きみw 君"
"きみt 君"
"きみn 君"
"きみm 君"
"きみh 君"
"きみg 君"
"きまわs 着回"
"きまりわるs 決まり悪"
"きまりわるk 決まり悪"
"きまりわるi 決まり悪"
"きまりわるg 決まり悪"
"きまぐr 気紛"
"きまt 決 極"
"きまr 極 決"
"きまn 極 決"
"きまc 極 決"
"きぼういたs 希望致"
"きぶくr 着脹"
"きふるs 着古"
"きふよm 棋譜読"
"きびしi 厳し"
"きびs 厳 嚴"
"きばt 気張"
"きばr 気張 気晴"
"きばn 気張"
"きばc 気張"
"きはどs 際疾"
"きはどk 際疾"
"きはどi 際疾"
"きはどg 際疾"
"きはz 気恥"
"きはm 窮"
"きのぼr 木登"
"きのうs 機能"
"きのr 気乗"
"きぬk 気抜"
"きにいt 気に入"
"きにいr 気に入"
"きにいn 気に入"
"きにいc 気に入"
"きなくさs きな臭 キナ臭"
"きなくさk きな臭 キナ臭"
"きなくさi きな臭 キナ臭"
"きなくさg きな臭 キナ臭"
"きながs 着流"
"きなr 着慣 生成"
"きどおs 着通"
"きどうs 起動"
"きどt 気取"
"きどr 気取"
"きどn 気取"
"きどc 気取"
"きていどおr 規定通"
"きていt 着て行"
"きていk 着て行"
"きていc 着て行"
"きづかw 気遣"
"きづかu 気遣"
"きづかt 気遣"
"きづかr 気疲"
"きづかo 気遣"
"きづかi 気遣"
"きづかe 気遣"
"きづかc 気遣"
"きづm 気詰"
"きづk 気付 築 気附"
"きづi 気付 築 気附"
"きつs キツ"
"きつk 気付 着付 キツ"
"きつi キツ"
"きつg キツ"
"きってすt 斬って捨"
"きっかk 切っ掛"
"きっs 喫"
"きちがいじm 気違い染"
"きちがi 気違"
"きだt 気立"
"きたむk 北向"
"きたなs 汚 穢"
"きたなr 汚"
"きたなk 汚 穢"
"きたなi 汚 穢"
"きたなg 汚 穢"
"きたえぬk 鍛え抜"
"きたえぬi 鍛え抜"
"きたえあg 鍛え上"
"きたいどおr 期待通"
"きたいくだs 期待下"
"きたいs 期待"
"きたt 来 來"
"きたs 来 來"
"きたr 来 來"
"きたn 汚"
"きたe 鍛"
"きそづk 基礎付"
"きそくただs 規則正"
"きそいあw 競い合"
"きそいあu 競い合"
"きそいあt 競い合"
"きそいあo 競い合"
"きそいあi 競い合"
"きそいあe 競い合"
"きそいあc 競い合"
"きそw 競 竸"
"きそu 競 竸"
"きそt 競 竸"
"きそo 競 竸"
"きそi 競 竸"
"きそh 競"
"きそe 競 竸"
"きそc 競 竸"
"きぜわs 気忙"
"きせかe 着せ替"
"きずつけあw 傷付け合"
"きずつけあu 傷付け合"
"きずつけあt 傷付け合"
"きずつけあo 傷付け合"
"きずつけあi 傷付け合"
"きずつけあe 傷付け合"
"きずつけあc 傷付け合"
"きずつk 傷付"
"きずつi 傷付"
"きずきあg 築き上"
"きずかi 気遣"
"きずt 傷"
"きずk 築 気付"
"きずi 築"
"きじよm 記事読"
"きしょくわるs 気色悪"
"きしょくわるk 気色悪"
"きしょくわるi 気色悪"
"きしょくわるg 気色悪"
"きしちかk 岸近"
"きしt 軋 轢"
"きしr 軋 轢"
"きしn 軋 轢"
"きしm 軋"
"きしc 軋 轢"
"きざわr 気障"
"きざみつk 刻み付"
"きざみこn 刻み込"
"きざみこm 刻み込"
"きざs 兆"
"きざp 気障"
"きざn 刻"
"きざm 刻"
"きさいs 記載"
"きさk 気さ"
"きこしめs 聞こし召"
"きこn 着込"
"きこm 着込"
"きけんn 危険"
"きぐm 木組"
"きくばr 気配"
"きくs 掬"
"ききわすr 聞き忘"
"ききわk 聞き分"
"ききよs 聴き良"
"ききよk 聴き良"
"ききよi 聴き良"
"ききよg 聴き良"
"ききやすs 聞き易"
"ききやすk 聞き易"
"ききやすi 聞き易"
"ききやすg 聞き易"
"ききもr 聞き漏 聞き洩"
"ききまちがi 聞き間違"
"ききまちがe 聞き間違"
"ききほr 聞き惚 聴き惚"
"ききはじm 聴き始 聞き始"
"ききのがs 聞き逃 聞逃"
"ききのg 聞き逃"
"ききにくs 聞き難"
"ききにくk 聞き難"
"ききにくi 聞き難"
"ききにくg 聞き難"
"ききながs 聞き流 聴き流"
"ききなおs 聞き直 聴き直"
"ききなr 聞き慣 聞き馴"
"ききとどk 聞き届"
"ききとがm 聞き咎"
"ききとおs 聴き通 聞き通"
"ききとt 聞き取 聴き取 聞取"
"ききとr 聞き取 聴き取 聞取"
"ききとn 聞き取 聴き取 聞取"
"ききとc 聞き取 聴き取 聞取"
"ききつづk 聞き続 聴き続"
"ききつk 聞き付"
"ききちがe 聞き違"
"ききだs 聞き出 効き出"
"ききたがe 聞き違"
"ききそこn 聞き損"
"ききせまt 鬼気迫"
"ききせまr 鬼気迫"
"ききせまn 鬼気迫"
"ききせまc 鬼気迫"
"ききずt 聞き捨"
"ききすg 効き過"
"ききしt 聞き知"
"ききしr 聞き知"
"ききしn 聞き知"
"ききしc 聞き知"
"ききこn 聞き込 聴き込"
"ききこm 聞き込 聴き込"
"ききぐるs 聞き苦"
"ききくらb 聞き比 聴き比 聴き較 聞き較"
"ききがk 聞き書"
"ききかじt 聞き齧"
"ききかじr 聞き齧"
"ききかじn 聞き齧"
"ききかじc 聞き齧"
"ききかえs 聞き返"
"ききおよn 聞き及"
"ききおよb 聞き及"
"ききおぼe 聞き覚"
"ききおとs 聞き落"
"ききおt 聞き落"
"ききおe 聞き終 聴き終"
"ききいt 聞き入 聴き入"
"ききいr 聞き入 聴き入"
"ききいn 聞き入 聴き入"
"ききいc 聞き入 聴き入"
"ききあやまt 聞き誤"
"ききあやまr 聞き誤"
"ききあやまn 聞き誤"
"ききあやまc 聞き誤"
"ききあk 聞き飽 聴き飽"
"きがるs 気軽"
"きがるk 気軽"
"きがるi 気軽"
"きがるg 気軽"
"きがまe 気構"
"きがつk 気が付 気が附"
"きがつi 気が付 気が附"
"きがかr 気掛"
"きがn 気兼"
"きがe 着替"
"きかざt 着飾"
"きかざr 着飾"
"きかざn 着飾"
"きかざc 着飾"
"きかe 着替 着換"
"きおくちがi 記憶違"
"きおくr 気後"
"きおいたt 気負い立 競い立"
"きおいたc 気負い立 競い立"
"きおいこn 気負い込"
"きおいこm 気負い込"
"きおw 気負"
"きおu 気負"
"きおt 気負 気落"
"きおo 気負"
"きおi 気負"
"きおe 気負"
"きおc 気負"
"きえはt 消え果"
"きえさt 消え去"
"きえさr 消え去"
"きえさn 消え去"
"きえさc 消え去"
"きえうs 消え失"
"きえいt 消え入"
"きえいr 消え入"
"きえいn 消え入"
"きえいc 消え入"
"きいろs 黄色"
"きいろp 黄色"
"きいろm 黄色"
"きいろk 黄色"
"きいろi 黄色"
"きいろg 黄色"
"きあいはいt 気合入"
"きあいはいr 気合入"
"きあいはいn 気合入"
"きあいはいc 気合入"
"きあいいr 気合入"
"きあi 気合"
"きz 着 著 気 氣"
"きy 消 来 來 徠 着 著"
"きw 気 氣 着 著"
"きu 着 著"
"きt 来 切 着 斬 著 來 徠 伐 剪 截 鑽"
"きs 着 来 記 期 帰 來 徠 歸 皈 著"
"きr 切 着 斬 伐 剪 截 鑽 著"
"きp 着 著"
"きo 着 著"
"きn 気 来 着 機 氣 著 來 徠 切 斬 伐 剪 截 鑽"
"きm 決 来 極 着 気 黄 决 來 徠 氣 著"
"きk 聞 聴 効 利 訊 尋 着 聽 效 切 著"
"きj 着 著"
"きi 聞 聴 効 利 尋 訊 效 聽 着 著"
"きh 気 氣 着 著"
"きg 気 氣 着 著"
"きe 消 着 著"
"きd 気 氣 来 來 徠 着 著"
"きc 切 来 來 徠 着 斬 伐 剪 截 鑽 著"
"きb 黄 着 著"
"きa 着 著"
"がんばりぬk 頑張り抜"
"がんばりぬi 頑張り抜"
"がんばりとおs 頑張り通"
"がんばt 頑張"
"がんばr 頑張"
"がんばn 頑張"
"がんばc 頑張"
"がんつk ガン付"
"がんぜなs 頑是無"
"がんぜなk 頑是無"
"がんぜなi 頑是無"
"がんぜなg 頑是無"
"がわr 変 替 代"
"がわk 乾"
"がらあk がら空 ガラ空"
"がらs 辛"
"がらm 絡"
"がらk 辛"
"がらi 辛"
"がらg 辛"
"がよi 通"
"がまんできn 我慢出来"
"がまんづよs 我慢強"
"がまんづよk 我慢強"
"がまんづよi 我慢強"
"がまんづよg 我慢強"
"がなりたt がなり立"
"がとu 難"
"がっしょうひねr 合掌捻"
"がっしょうづくr 合掌造"
"がっこうがえr 学校帰"
"がっs 合"
"がたs 難"
"がたr 語"
"がたm 固"
"がたk 難"
"がたi 難"
"がたg 難"
"がぞうとr 画像取"
"がさn 重"
"がけくずr 崖崩"
"がかr 係"
"がえんz 肯"
"がえんj 肯"
"がえs 返"
"がえr 帰 返 歸 皈"
"がえn 肯"
"がいs 害 概"
"がw 代 変 替"
"がt 勝"
"がs 貸 賀"
"がr 刈 狩 借"
"がk 書 駆 掛"
"がi 買"
"がe 替 換"
"かんれんづk 関連付"
"かんれんz 関連"
"かんれんs 関連"
"かんれんd 関連"
"かんやどr 神宿"
"かんべんねがw 勘弁願"
"かんべんねがu 勘弁願"
"かんべんねがt 勘弁願"
"かんべんねがo 勘弁願"
"かんべんねがi 勘弁願"
"かんべんねがe 勘弁願"
"かんべんねがc 勘弁願"
"かんばしt 甲走"
"かんばしr 甲走"
"かんばしn 甲走"
"かんばしc 甲走"
"かんばs 芳 香 馨"
"かんのんびらk 観音開"
"かんねんs 観念"
"かんづm 缶詰"
"かんづk 感付"
"かんづi 感付"
"かんちがi 勘違"
"かんだかs 甲高 疳高"
"かんだかk 甲高 疳高"
"かんだかi 甲高 疳高"
"かんだかg 甲高 疳高"
"かんたんすg 簡単過"
"かんせいs 完成"
"かんすうよb 関数呼"
"かんじょうてきすg 感情的過"
"かんじょうだかs 勘定高"
"かんじょうだかk 勘定高"
"かんじょうだかi 勘定高"
"かんじょうだかg 勘定高"
"かんじやすs 感じ易"
"かんじやすk 感じ易"
"かんじやすi 感じ易"
"かんじやすg 感じ易"
"かんじまz 漢字混"
"かんじとt 感じ取"
"かんじとr 感じ取"
"かんじとn 感じ取"
"かんじとc 感じ取"
"かんじつづk 感じ続"
"かんじいt 感じ入"
"かんじいr 感じ入"
"かんじいn 感じ入"
"かんじいc 感じ入"
"かんしんs 感心"
"かんしゃいたs 感謝致"
"かんしゃs 感謝"
"かんげいいたs 歓迎致"
"かんけいs 関係"
"かんぐt 勘繰"
"かんぐr 勘繰"
"かんぐn 勘繰"
"かんぐc 勘繰"
"かんきわm 感極"
"かんきr 缶切"
"かんがみr 鑑み"
"かんがえぶかs 考え深"
"かんがえぶかk 考え深"
"かんがえぶかi 考え深"
"かんがえぶかg 考え深"
"かんがえぬk 考え抜"
"かんがえぬi 考え抜"
"かんがえなおs 考え直"
"かんがえつk 考え付"
"かんがえつi 考え付"
"かんがえちがi 考え違"
"かんがえだs 考え出"
"かんがえすg 考え過"
"かんがえこn 考え込"
"かんがえこm 考え込"
"かんがえおよn 考え及"
"かんがえおよb 考え及"
"かんがえあわs 考え併"
"かんがえあw 考え合"
"かんがいぶかs 感慨深"
"かんがいぶかk 感慨深"
"かんがいぶかi 感慨深"
"かんがいぶかg 感慨深"
"かんがm 鑑 鑒"
"かんがh 考"
"かんがe 考 稽 勘 攷"
"かんかつちがi 管轄違"
"かんいr 缶入"
"かんz 感 観"
"かんt 冠"
"かんs 関 冠 姦 刊 緘 神 關"
"かんj 感"
"かんg 勘"
"かんd 感 勘"
"かわりはt 変わり果"
"かわりつづk 変わり続"
"かわむk 皮剥"
"かわばたどおr 川端通"
"かわづr 川釣"
"かわぞi 川沿"
"かわくだr 川下"
"かわきr 皮切"
"かわいs 可哀 可愛"
"かわいr 可愛"
"かわいk 可愛"
"かわいi 可愛"
"かわいg 可愛"
"かわt 変 變 代 換 替"
"かわs 交 躱"
"かわr 変 代 換 替 變"
"かわn 変 代 換 替 變"
"かわk 乾 渇"
"かわi 乾 渇"
"かわc 変 代 換 替 變"
"かろy 軽 輕"
"かろu 辛"
"かろn 軽"
"かれんn 可憐"
"かれはt 枯れ果"
"かれw 彼"
"かれt 涸 彼"
"かれr 彼 涸"
"かれn 涸 彼"
"かれm 彼"
"かれh 彼"
"かれg 彼"
"かれc 涸"
"かるすg 軽過"
"かるがるs 軽々 軽軽"
"かるu 軽 輕"
"かるs 軽 輕"
"かるm 軽 輕"
"かるk 軽 輕"
"かるi 軽 輕"
"かるg 軽 輕"
"かりわたs 仮渡"
"かりぬi 仮縫"
"かりとt 刈り取 刈取"
"かりとr 刈り取 刈取"
"かりとn 刈り取 刈取"
"かりとc 刈り取 刈取"
"かりっぱなs 借りっ放"
"かりだs 借り出 駆り出 狩り出"
"かりたおs 借り倒"
"かりたt 駆り立"
"かりそm 仮初"
"かりずまi 仮住"
"かりずm 借り住 仮住"
"かりさしおさe 仮差押"
"かりこs 借り越 借越"
"かりこn 狩り込 刈り込 刈込"
"かりこm 狩り込 刈り込 刈込"
"かりきt 借り切"
"かりきr 借り切"
"かりきn 借り切"
"かりきc 借り切"
"かりかs 借り貸"
"かりかe 借り換 借換"
"かりうk 借り受"
"かりいr 借り入 刈り入 借入 刈入"
"かりあつm 駆り集"
"かりあg 借り上 刈り上"
"かりn 仮"
"からめとt 搦め捕"
"からめとr 搦め捕"
"からめとn 搦め捕"
"からめとc 搦め捕"
"からむs 空蒸"
"からみつk 絡み付"
"からみつi 絡み付"
"からみあw 絡み合"
"からみあu 絡み合"
"からみあt 絡み合"
"からみあo 絡み合"
"からみあi 絡み合"
"からみあe 絡み合"
"からみあc 絡み合"
"からまわr 空回"
"からぶt 空振"
"からぶr 空振"
"からぶk 乾拭"
"からづm 空積"
"からだk 空焚"
"からたけわr 幹竹割"
"からすg 辛過"
"からさわg 空騒"
"からくt 絡繰"
"からくr 絡繰"
"からくn 絡繰"
"からくc 絡繰"
"からうr 空売"
"からあg 空揚"
"からs 辛 枯ら 鹹"
"からp 空"
"からn 絡"
"からm 絡 辛 搦 鹹"
"からk 辛 鹹"
"からi 辛 鹹"
"からg 絡 紮 辛 鹹"
"かよわs か弱"
"かよわk か弱"
"かよわi か弱"
"かよわg か弱"
"かよいつづk 通い続"
"かよいつm 通い詰"
"かよいあw 通い合"
"かよいあu 通い合"
"かよいあt 通い合"
"かよいあo 通い合"
"かよいあi 通い合"
"かよいあe 通い合"
"かよいあc 通い合"
"かよw 通"
"かよu 通"
"かよt 通"
"かよo 通"
"かよi 通"
"かよe 通"
"かよc 通"
"かゆs 痒 癢"
"かゆm 痒"
"かゆk 痒 癢"
"かゆi 痒 癢"
"かゆg 痒 癢"
"かやぶk 茅葺"
"かやr 蚊遣"
"かもしだs 醸し出"
"かもs 醸 釀"
"かもr 鴨"
"かむt 被 冠"
"かむr 被 冠"
"かむn 被 冠"
"かむc 被 冠"
"かみわk 噛み分"
"かみゆi 髪結"
"かみづm 紙詰"
"かみつぶs 噛み潰"
"かみつk 噛み付"
"かみつi 噛み付"
"かみちぎt 噛み千切"
"かみちぎr 噛み千切"
"かみちぎn 噛み千切"
"かみちぎc 噛み千切"
"かみだのm 神頼"
"かみしほうがたm 上四方固"
"かみしm 噛み締"
"かみころs 噛み殺"
"かみくだk 噛み砕"
"かみくだi 噛み砕"
"かみきt 噛み切"
"かみきr 噛み切 紙切 髪切"
"かみきn 噛み切"
"かみきc 噛み切"
"かみかざr 髪飾"
"かみかくs 神隠"
"かみおr 神降"
"かみあわs 噛み合"
"かみあw 噛み合"
"かみあu 噛み合"
"かみあt 噛み合"
"かみあo 噛み合"
"かみあi 噛み合"
"かみあe 噛み合"
"かみあc 噛み合"
"かみs 神"
"かみg 神"
"かまびすs 喧"
"かまw 構"
"かまu 構"
"かまt 構"
"かまo 構"
"かまk 感"
"かまi 構"
"かまh 構"
"かまe 構"
"かまc 構"
"かぼそs か細"
"かぼそk か細"
"かぼそi か細"
"かぼそg か細"
"かへt 歸 皈"
"かへr 歸 皈"
"かぶわk 株分"
"かぶりつk 齧り付"
"かぶりつi 齧り付"
"かぶt 被 齧"
"かぶs 被"
"かぶr 被 気触 齧"
"かぶn 被 齧"
"かぶk 傾"
"かぶi 傾"
"かぶc 被 齧"
"かびくさs 黴臭 カビ臭"
"かびくさk カビ臭 黴臭"
"かびくさi 黴臭 カビ臭"
"かびくさg 黴臭 カビ臭"
"かびz 黴"
"かびy 黴"
"かびt 黴"
"かびs 黴"
"かびr 黴"
"かびn 黴"
"かびm 黴"
"かびk 黴"
"かびc 黴"
"かばw 庇"
"かばu 庇"
"かばt 庇"
"かばo 庇"
"かばi 庇"
"かばe 庇"
"かばc 庇"
"かはらi 過払"
"かはs 交"
"かのうn 可能"
"かねもうk 金儲"
"かねもt 金持"
"かねもc 金持"
"かねまわr 金回"
"かねばらi 金払"
"かねづかi 金遣"
"かねそなe 兼ね備"
"かねあw 兼ね合"
"かねあi 兼ね合 兼合"
"かねz 兼"
"かねy 兼"
"かねt 予 兼"
"かねs 兼"
"かねr 兼"
"かねn 兼"
"かねm 兼"
"かねc 兼"
"かにばさm 蟹挟"
"かならz 必"
"かなづかi 仮名遣"
"かなしばr 金縛"
"かなぐりすt かなぐり捨"
"かなぎr 金切"
"かなきr 金切"
"かながk 仮名書"
"かなw 叶 敵 適"
"かなu 叶 敵 適"
"かなt 叶 適 敵"
"かなs 悲 哀 愛"
"かなo 叶 敵 適"
"かなi 叶 敵 適"
"かなe 叶 敵 適"
"かなd 奏"
"かなc 叶 敵 適"
"かどk 角"
"かていs 仮定"
"かつぎだs 担ぎ出"
"かつぎこn 担ぎ込"
"かつぎこm 担ぎ込"
"かつぎあg 担ぎ上"
"かつt 嘗"
"かつi 担 擔"
"かつg 担 擔"
"かつe 餓"
"かっぱらw 掻っ払"
"かっぱらu 掻っ払"
"かっぱらt 掻っ払"
"かっぱらo 掻っ払"
"かっぱらi 掻っ払"
"かっぱらc 掻っ払"
"かっとn かっ飛"
"かっとb かっ飛"
"かってでz 買って出"
"かってでy 買って出"
"かってでt 買って出"
"かってでr 買って出"
"かってでn 買って出"
"かってでm 買って出"
"かってこz 買って来"
"かってこy 買って来"
"かってこs 買って来"
"かってこr 買って来"
"かってこn 買って来"
"かってこi 買って来"
"かってくr 買って来"
"かってくn 買って来"
"かってきy 買って来"
"かってきt 買って来"
"かってきs 買って来"
"かってきn 買って来"
"かってきm 買って来"
"かってきd 買って来"
"かってきc 買って来"
"かっさらw 掻っ攫"
"かっさらu 掻っ攫"
"かっさらt 掻っ攫"
"かっさらo 掻っ攫"
"かっさらi 掻っ攫"
"かっさらc 掻っ攫"
"かっさばk 掻っ捌"
"かっさばi 掻っ捌"
"かっこわるs 格好悪"
"かっこわるk 格好悪"
"かっこわるi 格好悪"
"かっこわるg 格好悪"
"かっこうわるs 格好悪"
"かっこうわるk 格好悪"
"かっこうわるi 格好悪"
"かっこうわるg 格好悪"
"かっこうよs 格好良"
"かっこうよk 格好良"
"かっこうよi 格好良"
"かっこn 掻っ込"
"かっこm 掻っ込"
"かっくr かっ喰 かっ食"
"かっきづk 活気付"
"かっきづi 活気付"
"かっs 渇"
"かちまk 勝ち負"
"かちほこt 勝ち誇"
"かちほこr 勝ち誇"
"かちほこn 勝ち誇"
"かちほこc 勝ち誇"
"かちのこt 勝ち残"
"かちのこr 勝ち残"
"かちのこn 勝ち残"
"かちのこc 勝ち残"
"かちぬk 勝ち抜 勝抜"
"かちぬi 勝ち抜 勝抜"
"かちにg 勝ち逃"
"かちとt 勝ち取"
"かちとr 勝ち取"
"かちとn 勝ち取"
"かちとc 勝ち取"
"かちつづk 勝ち続"
"かちっぱなs 勝ちっ放"
"かちすすn 勝ち進"
"かちすすm 勝ち進"
"かちこs 勝ち越"
"かちおt 搗ち落"
"かちおc 搗ち落"
"かちえz 勝ち得 贏ち得"
"かちえy 勝ち得 贏ち得"
"かちえt 勝ち得 贏ち得"
"かちえs 勝ち得 贏ち得"
"かちえr 勝ち得 贏ち得"
"かちえn 勝ち得 贏ち得"
"かちえm 勝ち得 贏ち得"
"かちえk 勝ち得 贏ち得"
"かちえc 勝ち得 贏ち得"
"かちあw 搗ち合"
"かちあu 搗ち合"
"かちあt 搗ち合"
"かちあo 搗ち合"
"かちあi 搗ち合"
"かちあg 勝ち上 搗ち上"
"かちあc 搗ち合"
"かたわらいたs 傍ら痛"
"かたわらいたk 傍ら痛"
"かたわらいたi 傍ら痛"
"かたわらいたg 傍ら痛"
"かたわr 傍 片割"
"かたりつづk 語り続"
"かたりつたe 語り伝"
"かたりつくs 語り尽"
"かたりつk 語り尽"
"かたりつi 語り継"
"かたりつg 語り継"
"かたりだs 語り出"
"かたりきk 語り聞"
"かたりかk 語り掛"
"かたりあw 語り合"
"かたりあu 語り合"
"かたりあt 語り合"
"かたりあo 語り合"
"かたりあk 語り明"
"かたりあi 語り合"
"かたりあe 語り合"
"かたりあc 語り合"
"かたよt 偏 片寄"
"かたよs 片寄"
"かたよr 偏 片寄"
"かたよn 偏 片寄"
"かたよc 偏 片寄"
"かたむすb 片結"
"かたむk 傾"
"かたむi 傾"
"かたべr 片減"
"かたぶk 傾"
"かたぶi 傾"
"かたびらk 片開"
"かたひらk 片開"
"かたばかr 形許"
"かたはらいたs 片腹痛"
"かたはらいたk 片腹痛"
"かたはらいたi 片腹痛"
"かたはらいたg 片腹痛"
"かたなs 形無"
"かたどおr 型通"
"かたどt 象"
"かたどr 象 模 方取"
"かたどn 象"
"かたどc 象"
"かたづくr 形作"
"かたづk 片付 型付"
"かたづi 片付"
"かたつk 型付 肩付"
"かたちづくt 形作"
"かたちづくr 形作"
"かたちづくn 形作"
"かたちづくc 形作"
"かたたたk 肩叩"
"かたたがe 方違"
"かたすk 肩透"
"かたすg 硬過"
"かたじけなs 忝 辱"
"かたじけなk 忝 辱"
"かたじけなi 忝 辱"
"かたじけなg 忝 辱"
"かたこr 肩凝"
"かたぐるs 堅苦"
"かたくるs 堅苦"
"かたくn 頑"
"かたがわr 肩代"
"かたがw 肩代"
"かたかk 肩掛"
"かたおもi 片思 片想"
"かたおs 型押"
"かたえびがたm 片海老固"
"かたいr 肩入"
"かたy 片"
"かたt 語 騙"
"かたs 硬 固 堅 難 片"
"かたr 語 騙"
"かたp 片"
"かたn 語 騙"
"かたm 固 硬 堅 傾 難"
"かたk 固 硬 堅 難"
"かたi 固 硬 堅 難"
"かたg 傾 固 硬 堅 難"
"かたd 片"
"かたc 語 騙"
"かぞくづr 家族連"
"かぞくあw 家族合"
"かぞえたt 数え立"
"かぞえきt 数え切"
"かぞえきr 数え切"
"かぞえきn 数え切"
"かぞえきc 数え切"
"かぞえいr 数え入"
"かぞえあg 数え上"
"かぞe 数 數"
"かそけs 幽"
"かそけk 幽"
"かぜむk 風向"
"かぜとおs 風通"
"かぜあt 風当"
"かせぎだs 稼ぎ出"
"かせi 稼"
"かせg 稼"
"かずすくn 数少"
"かずしr 数知"
"かずかぎりなs 数限り無"
"かずかぎりなk 数限り無"
"かずかぎりなi 数限り無"
"かずかぎr 数限"
"かずおおs 数多"
"かずおおk 数多"
"かずおおi 数多"
"かずおおg 数多"
"かずあw 数合"
"かずあt 数当"
"かずk 被"
"かずi 被"
"かすめとt 掠め取"
"かすめとr 掠め取"
"かすめとn 掠め取"
"かすめとc 掠め取"
"かすみわたt 霞み渡"
"かすみわたr 霞み渡"
"かすみわたn 霞み渡"
"かすみわたc 霞み渡"
"かすがどおr 春日通"
"かすt 掠 擦"
"かすr 擦 掠"
"かすn 霞 擦 掠 翳"
"かすm 霞 掠 翳"
"かすk 微 幽"
"かすc 擦 掠"
"かじりつk 齧り付"
"かじりつi 齧り付"
"かじょうがk 箇条書"
"かじかn 悴"
"かじかm 悴"
"かじt 齧 噛 囓"
"かじr 齧 囓 噛"
"かじn 齧 囓 噛"
"かじc 齧 囓 噛"
"かしまs 姦"
"かしつk 貸し付 貸付"
"かしだs 貸し出 貸出"
"かしずk 傅"
"かしずi 傅"
"かししぶt 貸し渋"
"かししぶr 貸し渋"
"かししぶn 貸し渋"
"かししぶc 貸し渋"
"かしこs 賢 畏"
"かしこm 畏"
"かしこk 賢 畏"
"かしこi 賢 畏"
"かしこg 賢 畏"
"かしきt 貸し切 貸切"
"かしきr 貸し切 貸切"
"かしきn 貸し切 貸切"
"かしきc 貸し切 貸切"
"かしかr 貸し借"
"かしi 傾 炊 爨"
"かしg 炊 爨 傾"
"かざりつk 飾り付"
"かざりたt 飾り立"
"かざむk 風向"
"かざとおs 風通"
"かざt 飾 餝 錺"
"かざs 翳"
"かざr 飾 錺 餝"
"かざn 飾 錺 餝"
"かざc 飾 錺 餝"
"かさばt 嵩張"
"かさばr 嵩張"
"かさばn 嵩張"
"かさばc 嵩張"
"かさねあw 重ね合"
"かさねあu 重ね合"
"かさねあt 重ね合"
"かさねあo 重ね合"
"かさねあi 重ね合"
"かさねあe 重ね合"
"かさねあc 重ね合"
"かさなりあw 重なり合"
"かさなりあu 重なり合"
"かさなりあt 重なり合"
"かさなりあo 重なり合"
"かさなりあi 重なり合"
"かさなりあe 重なり合"
"かさなりあc 重なり合"
"かさなt 重な"
"かさn 重 嵩"
"かさm 嵩"
"かこつk 託"
"かこくn 苛酷"
"かこいこn 囲い込"
"かこいこm 囲い込"
"かこw 囲 圍"
"かこu 囲 圍"
"かこt 託 囲 喞 圍"
"かこo 囲 圍"
"かこn 囲 圍"
"かこm 囲 圍"
"かこi 囲 圍"
"かこe 囲 圍"
"かこc 囲 圍"
"かげふm 影踏"
"かげきすg 過激過"
"かげt 翳 陰"
"かげr 翳 陰"
"かげn 翳 陰"
"かげc 翳 陰"
"かけわたs 架け渡 掛け渡"
"かけよt 駆け寄"
"かけよr 駆け寄"
"かけよn 駆け寄"
"かけよc 駆け寄"
"かけもt 掛け持 掛持"
"かけもc 掛け持 掛持"
"かけめぐt 駆け巡"
"かけめぐr 駆け巡"
"かけめぐn 駆け巡"
"かけめぐc 駆け巡"
"かけまわt 駆け回"
"かけまわr 駆け回"
"かけまわn 駆け回"
"かけまわc 駆け回"
"かけひk 駆け引 駆引"
"かけのぼt 駈け登"
"かけのぼr 駈け登"
"かけのぼn 駈け登"
"かけのぼc 駈け登"
"かけぬk 駆け抜"
"かけどおs 駆け通"
"かけてゆk 駆けて行"
"かけていt 駈けて行 駆けて行"
"かけていk 駆けて行 駈けて行"
"かけていc 駆けて行 駈けて行"
"かけつけt 駆け付け"
"かけつk 駆け付"
"かけちがw 掛け違"
"かけちがu 掛け違"
"かけちがt 掛け違"
"かけちがo 掛け違"
"かけちがi 掛け違"
"かけちがc 掛け違"
"かけだs 駆け出 駆出 掛け出 掛出"
"かけずりまわt 駆けずり回"
"かけずりまわr 駆けずり回"
"かけずりまわn 駆けずり回"
"かけずりまわc 駆けずり回"
"かけすt 掛け捨"
"かけこn 駆け込 駆込 駈け込 駈込"
"かけこm 駆け込 駆込 駈け込 駈込"
"かけかe 掛け替 掛替"
"かけおt 駆け落 駆落"
"かけおr 駆け下 駆け降 駈け降 駈け下"
"かけおc 駆け落 駆落"
"かけあわs 掛け合"
"かけあw 掛け合"
"かけあu 懸合 掛合 懸け合 掛け合"
"かけあg 駆け上 駈け上"
"かけt 翔"
"かけr 翔"
"かけn 翔"
"かけc 翔"
"かぐわs 芳 香 馨"
"かくりs 隔離"
"かくまw 匿"
"かくまu 匿"
"かくまt 匿"
"かくまo 匿"
"かくまi 匿"
"かくまe 匿"
"かくまc 匿"
"かくほs 確保"
"かくばt 角張"
"かくばr 角張"
"かくばn 角張"
"かくばc 角張"
"かくのごとk 斯くの如"
"かくのうs 格納"
"かくにんねがi 確認願"
"かくにんくだs 確認下"
"かくにんおよb 確認及"
"かくにんs 確認"
"かくていs 確定"
"かくづk 格付"
"かくちょうたかs 格調高"
"かくちょうたかk 格調高"
"かくちょうたかi 格調高"
"かくちょうたかg 格調高"
"かくだいs 拡大"
"かくしもt 隠し持"
"かくしどr 隠し撮"
"かくしとおs 隠し通"
"かくしきばr 格式張"
"かくしきt 隠し切"
"かくしきr 隠し切"
"かくしきn 隠し切"
"かくしきc 隠し切"
"かくさg 格下"
"かくぎr 角切"
"かくがr 角刈"
"かくおt 角落"
"かくあg 格上"
"かくt 確 斯く"
"かくs 隠 画 匿 劃 隱"
"かくr 隠 隱"
"かくm 匿"
"かぎわk 嗅ぎ分"
"かぎりなs 限り無"
"かぎりなk 限り無"
"かぎりなi 限り無"
"かぎまわt 嗅ぎ回"
"かぎまわr 嗅ぎ回"
"かぎまわn 嗅ぎ回"
"かぎまわc 嗅ぎ回"
"かぎつk 嗅ぎ付"
"かぎだs 嗅ぎ出"
"かぎざk 鉤裂"
"かぎあt 嗅ぎ当"
"かぎt 限"
"かぎr 限"
"かぎn 限"
"かぎc 限"
"かきわすr 書き忘"
"かきわk 掻き分 書き分 かき分"
"かきよごs 書き汚"
"かきやすs 書き易"
"かきやすk 書き易"
"かきやすi 書き易"
"かきやすg 書き易"
"かきもどs 書き戻 書戻"
"かきもr 書き漏"
"かきむしt 掻き毟"
"かきむしr 掻き毟"
"かきむしn 掻き毟"
"かきむしc 掻き毟"
"かきみだs 掻き乱"
"かきまわs 掻き回"
"かきまちがi 書き間違"
"かきまちがe 書き間違"
"かきまz かき混 掻き混"
"かきはじm 書き始"
"かきのこs 書き残"
"かきぬk 書き抜"
"かきぬi 書き抜"
"かきならs 掻き均"
"かきならb 書き並"
"かきながs 書き流"
"かきなおs 書き直"
"かきなr かき鳴 掻き鳴 書き慣"
"かきとどm 書き留"
"かきとt 書き取 書取"
"かきとr 書き取 書取"
"かきとn 書き取 書取"
"かきとm 書き留"
"かきとc 書き取 書取"
"かきとb 書き飛"
"かきつらn 書き連"
"かきつづt 書き綴"
"かきつづr 書き綴"
"かきつづn 書き綴"
"かきつづk 書き続"
"かきつづc 書き綴"
"かきつたe 書き伝"
"かきつくs 書き尽"
"かきつk 書き尽 書き付"
"かきつi 書き継"
"かきつg 書き継"
"かきちr 書き散"
"かきだs 書き出 書出 かき出 掻き出"
"かきたt 書き立"
"かきたs 書き足"
"かきたr 書き足"
"かきたm 書き溜"
"かきぞm 書き初"
"かきそんz 書き損"
"かきそんj 書き損"
"かきそこn 書き損"
"かきそe 書き添"
"かきすt 書き捨 かき捨 掻き捨"
"かきしるs 書き記"
"かきこn 書き込 書込 掻き込"
"かきこm 書き込 書込 掻き込"
"かきけs かき消 掻き消"
"かきくわe 書き加"
"かきくもt 掻き曇"
"かきくもr 掻き曇"
"かきくもn 掻き曇"
"かきくもc 掻き曇"
"かきくどk 掻き口説"
"かきくどi 掻き口説"
"かきくだs 書き下"
"かきくずs 書き崩"
"かききt 掻き切"
"かききr 掻き切"
"かききn 掻き切"
"かききe 掻き消 かき消"
"かききc 掻き切"
"かきかえr 書き換え"
"かきかw 書き変"
"かきかe 書き換 書換 書き替 書き変"
"かきおろs 書下 描き下ろ"
"かきおよn 書き及"
"かきおよb 書き及"
"かきおとs 書き落"
"かきおさm 書き納"
"かきおこs 書き起"
"かきおくt 書き送"
"かきおくr 書き送"
"かきおくn 書き送"
"かきおくc 書き送"
"かきおt 書き落"
"かきおr 書き下 書下"
"かきおk 書き起 書き置 書置"
"かきおi 書き置 書置"
"かきおe 書き終"
"かきうつs 書き写"
"かきいだk 掻き抱"
"かきいだi 掻き抱"
"かきいr 書き入"
"かきあらわs 書き表"
"かきあらたm 書き改"
"かきあやまt 書き誤"
"かきあやまr 書き誤"
"かきあやまn 書き誤"
"かきあやまc 書き誤"
"かきあつm かき集 掻き集"
"かきあg 書き上"
"かがよu 耀"
"かがよh 耀"
"かがやきわたt 輝き渡"
"かがやきわたr 輝き渡"
"かがやきわたn 輝き渡"
"かがやきわたc 輝き渡"
"かがやk 輝 耀 赫"
"かがやi 輝 耀 赫"
"かがみこn 屈み込"
"かがみこm 屈み込"
"かがt 縢"
"かがr 縢"
"かがn 屈 縢"
"かがm 屈"
"かがc 縢"
"かかわりあw 関わり合 係わり合"
"かかわりあu 関わり合 係わり合"
"かかわりあt 関わり合 係わり合"
"かかわりあo 関わり合 係わり合"
"かかわりあi 関わり合 係わり合"
"かかわりあe 関わり合 係わり合"
"かかわりあc 関わり合 係わり合"
"かかわt 拘 係 関"
"かかわr 係 拘 関"
"かかわn 係 拘 関"
"かかわc 係 拘 関"
"かかりつk 掛かり付"
"かかりすg 掛り過"
"かかえこn 抱え込"
"かかえこm 抱え込"
"かかw 関 係 拘 關"
"かかt 掛 係 罹"
"かかr 係 掛 罹"
"かかn 係 掛 罹"
"かかg 掲"
"かかe 抱"
"かかc 係 掛 罹"
"かおりたかs 香り高"
"かおりたかk 香り高"
"かおりたかi 香り高"
"かおりたかg 香り高"
"かおりたt 香り立"
"かおりたc 香り立"
"かおむk 顔向"
"かおみしr 顔見知"
"かおまk 顔負"
"かおぶr 顔触"
"かおつk 顔付"
"かおだt 顔立"
"かおだs 顔出"
"かおあわs 顔合"
"かおあw 顔合"
"かおt 薫 香 馨"
"かおr 香 薫 馨"
"かおn 香 薫 馨"
"かおc 香 薫 馨"
"かえりざk 返り咲"
"かえりざi 返り咲"
"かえりがk 帰り掛"
"かえりうt 返り討"
"かえりm 省 顧"
"かえってこz 帰って来 返って来"
"かえってこy 帰って来 返って来"
"かえってこs 帰って来 返って来"
"かえってこr 帰って来 返って来"
"かえってこn 帰って来 返って来"
"かえってこi 帰って来 返って来"
"かえってくr 帰って来 返って来"
"かえってくn 帰って来 返って来"
"かえってきy 帰って来 返って来"
"かえってきt 帰って来 返って来"
"かえってきs 帰って来 返って来"
"かえってきn 帰って来 返って来"
"かえってきm 帰って来 返って来"
"かえってきd 帰って来 返って来"
"かえってきc 帰って来 返って来"
"かえすがえs 返す返"
"かえがたs 代え難"
"かえがたk 代え難"
"かえがたi 代え難"
"かえがたg 代え難"
"かえz 替 換"
"かえy 替 換"
"かえt 帰 返 却 反 還 歸 皈 孵 替 換 卻"
"かえs 返 帰 還 孵 反 歸 皈 替 換"
"かえr 帰 返 還 孵 反 替 換 歸 皈"
"かえn 帰 返 還 孵 反 替 換 歸 皈"
"かえm 替 換"
"かえc 帰 歸 皈 返 還 孵 反 替 換"
"かいもどs 買戻 買い戻"
"かいもとm 買い求"
"かいまみz 垣間見"
"かいまみy 垣間見"
"かいまみt 垣間見"
"かいまみs 垣間見"
"かいまみr 垣間見"
"かいまみn 垣間見"
"かいまみm 垣間見"
"かいまみk 垣間見"
"かいまみe 垣間見"
"かいまみc 垣間見"
"かいほうs 解放"
"かいびかe 買い控"
"かいのs 買い乗"
"かいなおs 買い直"
"かいなr 飼い馴"
"かいなd 掻い撫"
"かいどくd 買い得"
"かいとt 買い取 買取"
"かいとr 買い取 買取"
"かいとn 買い取 買取"
"かいとc 買い取 買取"
"かいつまn 掻い摘"
"かいつまm 掻い摘"
"かいつづk 買い続"
"かいつk 買い付 買付"
"かいだs 買い出"
"かいたたk 買い叩"
"かいたたi 買い叩"
"かいたs 買い足"
"かいそろe 買い揃"
"かいせつs 開設"
"かいしょうなs 甲斐性無"
"かいしゃがえr 会社帰"
"かいしぶt 買い渋"
"かいしぶr 買い渋"
"かいしぶn 買い渋"
"かいしぶc 買い渋"
"かいしm 買い占 買占"
"かいささe 買い支"
"かいさいいたs 開催致"
"かいごろs 飼い殺"
"かいこs 買い越"
"かいこn 買い込"
"かいこm 買い込"
"かいけつs 解決"
"かいぐi 買い食"
"かいくぐt 掻い潜"
"かいくぐr 掻い潜"
"かいくぐn 掻い潜"
"かいくぐc 掻い潜"
"かいきt 買い切"
"かいきr 買い切"
"かいきn 買い切"
"かいきc 買い切"
"かいがんまわr 海岸回"
"かいがんちかs 海岸近"
"かいがんちかk 海岸近"
"かいがんちかi 海岸近"
"かいがんちかg 海岸近"
"かいがいs 甲斐甲斐"
"かいかぶt 買い被"
"かいかぶr 買い被"
"かいかぶn 買い被"
"かいかぶc 買い被"
"かいかe 買い替 買い換 買替"
"かいおk 買い置"
"かいおi 買い置"
"かいうk 買い受"
"かいいr 買い入 買入"
"かいあたe 買い与"
"かいあさt 買い漁"
"かいあさr 買い漁"
"かいあさn 買い漁"
"かいあさc 買い漁"
"かいあおt 買い煽"
"かいあおr 買い煽"
"かいあおn 買い煽"
"かいあおc 買い煽"
"かいあw 貝合"
"かいあg 買い上"
"かいt 解 觧"
"かいs 解 介 会 會 觧"
"かあs 母"
"かw 変 代 交 替 買 換 飼 變 支"
"かu 買 飼 交 支"
"かt 勝 買 飼 刈 狩 且 駆 交 克 糅 苅 驅 支 上 搗"
"かs 貸 化 課 科 嫁 架 和 仮 呵 藉 淅"
"かr 借 枯 狩 刈 駆 涸 嗄 仮 上 苅 驅"
"かo 買 飼 交 支"
"かn 兼 噛 彼 狩 刈 駆 咬 嚼 醸 上 苅 驅"
"かm 噛 咬 嚼 醸"
"かk 書 掛 欠 駆 賭 掻 描 画 架 駈 翔 斯 懸 繋 闕 舁 畫 缺 驅"
"かi 買 書 描 飼 画 欠 掻 嗅 交 畫 缺 支 闕 舁"
"かh 替 換 交 支 飼 代 買 變"
"かg 嗅"
"かe 変 替 代 換 買 飼 易 變 交 支"
"かc 勝 買 飼 交 支 克 狩 刈 駆 苅 驅 搗"
"かb 黴"
"おんよm 音読"
"おんびk 音引"
"おんなたらs 女誑"
"おんなずk 女好"
"おんなざかr 女盛"
"おんなくさs 女臭"
"おんなくさk 女臭"
"おんなくさi 女臭"
"おんなくさg 女臭"
"おんなぎらi 女嫌"
"おんなs 女"
"おんなr 女"
"おんなp 女"
"おんなj 同"
"おんきs 恩着"
"おんがえs 恩返"
"おわらi お笑"
"おわたs お渡"
"おわすr お忘"
"おわかs お若"
"おわかr お別"
"おわかk お若"
"おわかi お若"
"おわかg お若"
"おわt 終 畢"
"おわs 御座 在"
"おわr 終 畢 終わ"
"おわn 終 畢"
"おわc 終 畢"
"おろそk 疎"
"おろおぼe 疎覚"
"おろs 卸 下"
"おろk 愚"
"おれまがt 折れ曲"
"おれまがr 折れ曲"
"おれまがn 折れ曲"
"おれまがc 折れ曲"
"おれまg 折れ曲"
"おれw 俺"
"おれt 俺"
"おれn 俺"
"おれm 俺"
"おれh 俺"
"おれg 俺"
"おりよk 折良"
"おりめただs 折り目正"
"おりまz 織り交"
"おりまg 折り曲"
"おりなs 織り成"
"おりとt 折り取 折取"
"おりとr 折り取 折取"
"おりとn 折り取 折取"
"おりとc 折り取 折取"
"おりだs 織り出"
"おりたたn 折り畳 折畳"
"おりたたm 折り畳 折畳"
"おりたt 降り立 下り立"
"おりたc 降り立 下り立"
"おりこn 折り込 織り込 折込 織込"
"おりこm 折り込 織り込 折込 織込"
"おりかさn 折り重"
"おりかえs 折り返 折返"
"おりいt 折り入"
"おりいr 折り入"
"おりいn 折り入"
"おりいc 折り入"
"おりあw 折り合 折合"
"おりあu 折り合 折合"
"おりあt 折り合 折合"
"おりあs 折悪"
"おりあo 折り合 折合"
"おりあi 折り合 折合"
"おりあe 折り合 折合"
"おりあc 折り合 折合"
"おりs 折"
"およろこb お慶"
"およびがたs 及び難"
"およびがたk 及び難"
"およびがたi 及び難"
"およびがたg 及び難"
"およぎこn 泳ぎ込"
"およぎこm 泳ぎ込"
"およs 凡 お寄"
"およr お寄"
"およn 及"
"およm 御読"
"およi 泳 游"
"およg 泳 游"
"およb 及"
"おやゆずr 親譲"
"おやすs お安"
"おやすm お休"
"おやすk お安"
"おやすi お安"
"おやm お止"
"おもんみz 惟"
"おもんみy 惟"
"おもんみt 惟"
"おもんみs 惟"
"おもんみr 惟"
"おもんみn 惟"
"おもんみm 惟"
"おもんみc 惟"
"おもんぱかt 慮"
"おもんぱかr 慮"
"おもんぱかn 慮"
"おもんぱかc 慮"
"おもんばかt 慮"
"おもんばかr 慮"
"おもんばかn 慮"
"おもんばかc 慮"
"おもわせぶr 思わせ振"
"おももt 面持"
"おもむきぶかs 趣深"
"おもむきぶかk 趣深"
"おもむきぶかi 趣深"
"おもむきぶかg 趣深"
"おもむk 赴 趣"
"おもむi 赴 趣"
"おもみづk 重み付"
"おもはゆs 面映"
"おもはゆk 面映"
"おもはゆi 面映"
"おもはゆg 面映"
"おもはy 面映"
"おもねt 阿"
"おもねr 阿"
"おもねn 阿"
"おもねc 阿"
"おもとm お求"
"おもてむk 表向"
"おもてどおr 表通"
"おもてだt 表立"
"おもてだc 表立"
"おもてがk 表書"
"おもてあm 表編"
"おもだt 主立 重立"
"おもだc 重立"
"おもすぎr 重過ぎ"
"おもすg 重過"
"おもしろおかs 面白可笑"
"おもしろu 面白"
"おもしろs 面白"
"おもしろm 面白"
"おもしろk 面白"
"おもしろi 面白"
"おもしろg 面白"
"おもざs 面差"
"おもぐるs 重苦"
"おもくるs 重苦"
"おもおもs 重々 重重"
"おもいわずらw 思い煩"
"おもいわずらu 思い煩"
"おもいわずらt 思い煩"
"おもいわずらo 思い煩"
"おもいわずらi 思い煩"
"おもいわずらe 思い煩"
"おもいわずらc 思い煩"
"おもいやt 思い遣"
"おもいやr 思い遣"
"おもいやn 思い遣"
"おもいやc 思い遣"
"おもいめぐr 思い巡"
"おもいみだr 思い乱"
"おもいのこs 思い残"
"おもいなやn 思い悩"
"おもいなやm 思い悩"
"おもいなおs 思い直"
"おもいなs 思い做"
"おもいどおr 思い通"
"おもいとどm 思い止"
"おもいでぶかs 思い出深 想い出深"
"おもいでぶかk 思い出深 想い出深"
"おもいでぶかi 思い出深 想い出深"
"おもいでぶかg 思い出深 想い出深"
"おもいつづk 思い続 想い続"
"おもいつm 思い詰"
"おもいつk 思い付"
"おもいつi 思い付"
"おもいっきr 思いっ切"
"おもいちがi 思い違"
"おもいちがe 思い違"
"おもいだs 思い出"
"おもいたt 思い立"
"おもいたc 思い立"
"おもいすごs 思い過"
"おもいすg 思い過"
"おもいしt 思い知"
"おもいしr 思い知"
"おもいしn 思い知"
"おもいしc 思い知"
"おもいさだm 思い定"
"おもいこn 思い込"
"おもいこm 思い込"
"おもいくらb 思い比"
"おもいきt 思い切"
"おもいきr 思い切"
"おもいきn 思い切"
"おもいきc 思い切"
"おもいかえs 思い返"
"おもいかn 思い兼"
"おもいおよn 思い及"
"おもいおよb 思い及"
"おもいおもi 思い思"
"おもいおk 思い起"
"おもいえがk 思い描"
"おもいえがi 思い描"
"おもいうk 思い浮"
"おもいいたt 思い至"
"おもいいたr 思い至"
"おもいいたn 思い至"
"おもいいたc 思い至"
"おもいいr 思い入"
"おもいあまt 思い余"
"おもいあまr 思い余"
"おもいあまn 思い余"
"おもいあまc 思い余"
"おもいあt 思い当"
"おもいあg 思い上"
"おもy 重"
"おもw 思 想 念 憶"
"おもu 思 想 念 憶 重"
"おもt 思 重 御持 お持 想 念 憶"
"おもs 重"
"おもr 重"
"おもo 思 想 念 憶"
"おもn 重 主"
"おもm 重"
"おもk 重"
"おもi 思 重 想 念 憶"
"おもh 思 想"
"おもg 重"
"おもe 思 想 念 憶"
"おもd 重"
"おもc 思 御持 お持 想 念 憶"
"おめざm お目覚"
"おめs お召"
"おめn 御目"
"おむかe お迎"
"おみまi 御見舞"
"おみのがs お見逃"
"おみとおs 御見通 お見通"
"おみうk お見受"
"おみe お見"
"おまわr お巡"
"おまもr 御守"
"おまちがi お間違"
"おまちがe お間違"
"おまかs お任"
"おまいr 御参"
"おまt お待"
"おまk 御負"
"おぼろs 朧"
"おぼろn 朧"
"おぼろg 朧"
"おぼろd 朧"
"おぼれじn 溺れ死"
"おぼつかなs 覚束無"
"おぼつかなk 覚束無"
"おぼつかなi 覚束無"
"おぼつかなg 覚束無"
"おぼしめs 思し召 思召"
"おぼえなおs 覚え直"
"おぼえこn 覚え込"
"おぼえこm 覚え込"
"おぼy 覚"
"おぼw 憶"
"おぼt 覚"
"おぼs 思 覚"
"おぼr 溺"
"おぼe 覚 憶 覺"
"おほm お褒"
"おほh 被 覆"
"おぶw 負"
"おぶu 負"
"おぶt 負"
"おぶo 負"
"おぶi 負"
"おぶe 負"
"おぶc 負"
"おびやk 脅"
"おびただs 夥"
"おびきよs 誘き寄"
"おびきだs 誘き出"
"おびk 誘"
"おびi 誘"
"おびe 怯 脅"
"おひとよs 御人好"
"おひさs 御久 お久"
"おはらi お祓 お払"
"おはよu お早"
"おはなs お話"
"おのぼr 御上"
"おののk 戦"
"おののi 戦"
"おのずかr 自"
"おのずt 自"
"おのずk 自"
"おのおのn 各"
"おのz 自"
"おのr 己"
"おのg 己"
"おねがi お願 御願"
"おねうt お値打"
"おにあi お似合"
"おなやm お悩"
"おながr お流"
"おなz 同"
"おなk お亡 お泣"
"おなj 同"
"おなi 同"
"おどろきいt 驚き入"
"おどろきいr 驚き入"
"おどろきいn 驚き入"
"おどろきいc 驚き入"
"おどろk 驚 愕 駭"
"おどろi 驚 愕 駭"
"おどりでy 躍り出"
"おどりでt 躍り出"
"おどりでr 躍り出"
"おどりでn 躍り出"
"おどりでm 躍り出"
"おどりだs 踊り出"
"おどりこn 踊り込"
"おどりこm 踊り込"
"おどりくるw 踊り狂"
"おどりくるu 踊り狂"
"おどりくるt 踊り狂"
"おどりくるo 踊り狂"
"おどりくるi 踊り狂"
"おどりくるe 踊り狂"
"おどりくるc 踊り狂"
"おどりかk 躍り掛"
"おどりあk 踊り明"
"おどしとt 脅し取"
"おどしとr 脅し取"
"おどしとn 脅し取"
"おどしとc 脅し取"
"おどt 踊 踴 躍"
"おどs 脅 威 縅"
"おどr 踊 躍 踴"
"おどn 踊 躍 踴"
"おどk 脅 戯 嚇"
"おどc 踊 躍 踴"
"おとろe 衰"
"おとりよs お取り寄 お取寄"
"おとりおk お取り置"
"おとなw 訪"
"おとなu 訪"
"おとなt 訪"
"おとなs 大人 音無"
"おとなp 大人"
"おとなo 訪"
"おとなi 訪"
"おとなe 訪"
"おとなc 訪"
"おとどk 御届 お届"
"おとだs 音出"
"おとずr 訪"
"おとしこn 落とし込"
"おとしこm 落とし込"
"おとしいr 陥 陷"
"おとしm 貶"
"おとこざかr 男盛"
"おとこくさs 男臭"
"おとこくさk 男臭"
"おとこくさi 男臭"
"おとこくさg 男臭"
"おとこr 男"
"おとこp 男"
"おとぎr 音切"
"おとがm お咎"
"おとおs お通"
"おとあw 音合"
"おとz 訪"
"おとt 劣"
"おとs 落"
"おとr 劣"
"おとn 劣"
"おとm お泊"
"おとc 劣"
"おでむかe お出迎"
"おてもt お手持"
"おてあw お手合"
"おてあg お手上 御手上"
"おつとm お勤"
"おつくr お作 お造"
"おつきあi お付き合"
"おつかr お疲"
"おつかi お使"
"おつうj お通"
"おつs 乙"
"おつn 乙"
"おつg 御告"
"おつd 乙"
"おっぴろg おっ広"
"おっぱらw 追っ払"
"おっぱらu 追っ払"
"おっぱらt 追っ払"
"おっぱらo 追っ払"
"おっぱらi 追っ払"
"おっぱらe 追っ払"
"おっぱらc 追っ払"
"おっぱじm おっ始"
"おっつk 追っ付"
"おっちn おっ死"
"おったt 押っ立 追っ立 おっ立"
"おったc 押っ立 おっ立"
"おっしゃt 仰 仰有"
"おっしゃr 仰 仰有"
"おっしゃn 仰 仰有"
"おっしゃi 仰 仰有"
"おっしゃc 仰 仰有"
"おっかぶs 押っ被"
"おっかk 追っ掛"
"おっt 追っ"
"おちぶr 零落 落魄"
"おちばたk 落葉焚"
"おちのb 落ち延"
"おちつきはらw 落ち着き払"
"おちつきはらu 落ち着き払"
"おちつきはらt 落ち着き払"
"おちつきはらo 落ち着き払"
"おちつきはらi 落ち着き払"
"おちつきはらc 落ち着き払"
"おちつk 落ち着 落着"
"おちつi 落ち着 落着"
"おちこn 落ち込"
"おちこm 落ち込"
"おちくぼn 落ち窪"
"おちくぼm 落ち窪"
"おちいt 陥 陷 落ち入 落入"
"おちいr 陥 落ち入 落入 陷"
"おちいn 陥 陷 落ち入 落入"
"おちいc 陥 陷 落ち入 落入"
"おちあw 落ち合"
"おちあu 落ち合"
"おちあt 落ち合"
"おちあo 落ち合"
"おちあi 落ち合"
"おちあe 落ち合"
"おちあc 落ち合"
"おちr 落 堕ち 墜ち 落ち"
"おちi 陥"
"おだやk 穏"
"おだy 穏 穩"
"おだt 煽"
"おだs お出"
"おためs お試"
"おたずn お尋"
"おたすk お助"
"おたけb 雄叫"
"おたがi 御互 お互"
"おたかs 御高 お高"
"おたかk お高 御高"
"おたかi 御高 お高"
"おたかg 御高 お高"
"おたb お食"
"おぞまs 悍 鈍 悍ま"
"おぞけだt 怖気立"
"おぞけだc 怖気立"
"おぞm 悍 鈍"
"おそろs 恐"
"おそろi お揃"
"おそれおののk 恐れ戦"
"おそれおののi 恐れ戦"
"おそれおおs 畏れ多 恐れ多"
"おそれおおk 畏れ多 恐れ多"
"おそれおおi 畏れ多 恐れ多"
"おそれいt 恐れ入"
"おそれいr 恐れ入"
"おそれいn 恐れ入"
"おそれいc 恐れ入"
"おそれr 怐"
"おそまk 遅蒔"
"おそなe お供"
"おそすg 遅過"
"おそざk 遅咲"
"おそいこz 襲い来"
"おそいこy 襲い来"
"おそいこs 襲い来"
"おそいこr 襲い来"
"おそいこn 襲い来"
"おそいこi 襲い来"
"おそいくr 襲い来"
"おそいくn 襲い来"
"おそいきy 襲い来"
"おそいきt 襲い来"
"おそいきs 襲い来"
"おそいきn 襲い来"
"おそいきm 襲い来"
"おそいきd 襲い来"
"おそいきc 襲い来"
"おそいかk 襲い掛"
"おそw 教 襲"
"おそu 襲"
"おそt 襲"
"おそs 遅 遲"
"おそr 恐 怖 畏 虞 懼 惧"
"おそo 襲"
"おそm 遅 遲"
"おそk 遅 遲"
"おそi 遅 襲 遲"
"おそh 襲"
"おそg 遅 遲"
"おそe 襲"
"おそc 襲"
"おぜんだt 御膳立"
"おせe 遅"
"おすすm お勧"
"おすm お住"
"おじけづk 怖気付"
"おじけづi 怖気付"
"おじk 怖"
"おしわk 押し分"
"おしよs 押し寄"
"おしやぶt 押し破"
"おしやぶr 押し破"
"おしやぶn 押し破"
"おしやぶc 押し破"
"おしやt 押し遣"
"おしやr 押し遣"
"おしやn 押し遣"
"おしやc 押し遣"
"おしもどs 押し戻"
"おしみなs 惜しみ無"
"おしみなk 惜しみ無"
"おしみなi 惜しみ無"
"おしまg 押し曲"
"おしひろg 押し広"
"おしひらk 押し開"
"おしひらi 押し開"
"おしひしi 押し拉"
"おしひしg 押し拉"
"おしはらi お支払"
"おしはかt 推し量"
"おしはかr 推し量"
"おしはかn 推し量"
"おしはかc 推し量"
"おしのk 押し退"
"おしながs 押し流"
"おしながk お品書"
"おしなb 押し並"
"おしとどm 押し止"
"おしとおs 押し通"
"おしとm 押し止"
"おしてしr 推して知"
"おしつまt 押し詰"
"おしつまr 押し詰"
"おしつまn 押し詰"
"おしつまc 押し詰"
"おしつぶs 押し潰 圧し潰"
"おしつつn 押し包"
"おしつつm 押し包"
"おしつk 押し付"
"おしだまt 押し黙"
"おしだまr 押し黙"
"おしだまn 押し黙"
"おしだまc 押し黙"
"おしだs 押し出"
"おしたおs 押し倒"
"おしたt 押し立"
"おしせまt 押し迫"
"おしせまr 押し迫"
"おしせまn 押し迫"
"おしせまc 押し迫"
"おしすすm 推し進 押し進"
"おしさg 押し下"
"おしころs 押し殺 圧し殺"
"おしこn 押し込 押込"
"おしこm 押し込 押込"
"おしきt 押し切"
"おしきs 御仕着"
"おしきr 押し切"
"おしきn 押し切"
"おしきc 押し切"
"おしかくs 押し隠"
"おしかえs 押し返"
"おしかr お叱"
"おしかk 押し掛"
"おしえさとs 教え諭"
"おしえこn 教え込"
"おしえこm 教え込"
"おしえあw 教え合"
"おしえあu 教え合"
"おしえあt 教え合"
"おしえあo 教え合"
"おしえあi 教え合"
"おしえあe 教え合"
"おしえあc 教え合"
"おしうr 押し売 押売"
"おしいだk 押し抱"
"おしいだi 押し抱"
"おしいt 押し入"
"おしいr 押し入"
"おしいn 押し入"
"おしいc 押し入"
"おしあわs お幸"
"おしあw 押し合"
"おしあu 押し合"
"おしあt 押し当 押し合"
"おしあo 押し合"
"おしあk 押し開"
"おしあi 押し合"
"おしあg 押し上"
"おしあc 押し合"
"おしr 御知 お知"
"おしg 惜し"
"おしe 教"
"おさわg お騒"
"おさむs 御寒 お寒"
"おさむk 御寒 お寒"
"おさむi 御寒 お寒"
"おさむg 御寒 お寒"
"おさなs 幼 稚"
"おさなk 幼 稚"
"おさなi 幼 稚"
"おさなg 稚 幼"
"おさっs 御察"
"おさそいあw お誘い合"
"おさえつk 押さえ付 抑え付 押え付"
"おさえこn 押さえ込 抑え込"
"おさえこm 押さえ込 抑え込"
"おさえきt 抑え切 押さえ切 押え切"
"おさえきr 抑え切 押さえ切 押え切"
"おさえきn 抑え切 押さえ切 押え切"
"おさえきc 抑え切 押さえ切 押え切"
"おさn 幼"
"おさm 収 納 治 修 收"
"おさe 抑 押 圧 壓"
"おごりたかb 驕り高"
"おごそk 厳 嚴"
"おごt 奢 驕 傲"
"おごr 奢 驕 傲"
"おごn 奢 驕 傲"
"おごc 奢 驕 傲"
"おこりえz 起こり得"
"おこりえy 起こり得"
"おこりえt 起こり得"
"おこりえs 起こり得"
"おこりえr 起こり得"
"おこりえn 起こり得"
"おこりえm 起こり得"
"おこりえc 起こり得"
"おこりうr 起こり得"
"おこりうb 起こり得"
"おこぼr お零"
"おこのm お好"
"おこなw 行 行な"
"おこなu 行 行な"
"おこなt 行"
"おこなo 行"
"おこなi 行 行な"
"おこなh 行"
"おこなe 行"
"おこなc 行"
"おことわr お断"
"おこたt 怠"
"おこたr 怠"
"おこたn 怠"
"おこたc 怠"
"おこt 怒 起 興"
"おこs 興 起 熾 遣 お越 起こ"
"おこr 怒 興 起"
"おこn 行 怒 興 起"
"おこg 烏滸 痴"
"おこc 怒 興 起"
"おけr 於け"
"おくりむかe 送り迎"
"おくりなおs 送り直"
"おくりとどk 送り届"
"おくりつk 送り付"
"おくりだs 送り出"
"おくりたおs 送り倒"
"おくりこn 送り込"
"おくりこm 送り込"
"おくりかえs 送り返"
"おくゆかs 奥床"
"おくゆk 奥行"
"おくぶかs 奥深"
"おくぶかk 奥深"
"おくぶかi 奥深"
"おくぶかg 奥深"
"おくふかs 奥深"
"おくふかk 奥深"
"おくふかi 奥深"
"おくふかg 奥深"
"おくy お悔"
"おくt 送 贈"
"おくs 臆 奥"
"おくr 送 贈 遅 後 遲"
"おくn 送 贈"
"おくc 送 贈"
"おぎなw 補"
"おぎなu 補"
"おぎなt 補"
"おぎなo 補"
"おぎなi 補"
"おぎなe 補"
"おぎなc 補"
"おきわたs 沖渡"
"おきわすr 置き忘"
"おきびk 置き引"
"おきぬk 起き抜"
"おきにいr お気に入"
"おきなおt 起き直"
"おきなおs 起き直"
"おきなおr 起き直"
"おきなおn 起き直"
"おきなおc 起き直"
"おきてやぶr 掟破"
"おきづk お気付"
"おきだs 起き出"
"おきたt 起き立"
"おきたc 起き立"
"おきざr 置き去"
"おきがk 置き掛"
"おきかえt 置き換え"
"おきかえr 置き換え"
"おきかw 置き換 置き変 置き代"
"おきかe 置き換 置換"
"おきあg 起き上"
"おきm お決"
"おきk 御聞 お聞"
"おがみたおs 拝み倒"
"おがn 拝 拜"
"おがm 拝 拜"
"おかまi お構"
"おかぼr 岡惚 傍惚"
"おかどちがi 御門違 お門違"
"おかっぴk 岡っ引"
"おかたi お堅"
"おかえs 御返"
"おかえr お帰"
"おかいもとm お買い求"
"おかいあg お買い上"
"おかw お変 お代"
"おかs 犯 侵 冒 可笑 奇"
"おかk お掛 お書"
"おおわらi 大笑"
"おおよろこb 大喜"
"おおよs 凡"
"おおもうk 大儲"
"おおもr 大盛"
"おおもi お思"
"おおむn 概"
"おおみだs 大見出"
"おおまわr 大回"
"おおまちがi 大間違"
"おおまk 大負"
"おおまg 大曲"
"おおぶr 大振 大降"
"おおばんぶるまi 大盤振舞 大盤振る舞"
"おおにぎw 大賑"
"おおどおr 大通"
"おおとのごもr 大殿籠"
"おおづm 大詰"
"おおちがi 大違"
"おおせつk 仰せ付"
"おおすぎt 大過ぎ"
"おおすg 多過"
"おおしe 御教 お教"
"おおさわg 大騒"
"おおぐi 大食"
"おおくr 御送 お送"
"おおきすg 大き過"
"おおがかr 大掛"
"おおがk 大掛"
"おおうりだs 大売出"
"おおうつs 大写"
"おおうk 大受"
"おおいつくs 覆い尽"
"おおいつk 覆い尽"
"おおいそがs 大忙"
"おおいそg 大急"
"おおいかぶs 覆い被"
"おおいかくs 覆い隠"
"おおあばr 大暴"
"おおあt 大当"
"おおあr 大荒"
"おおz 大 応 應"
"おおw 覆 被 蔽 蓋 掩 奄"
"おおu 覆 被 蔽 蓋 掩 多 奄"
"おおt 覆 被 蔽 蓋 掩 奄"
"おおs 多 仰 雄々 夛 果"
"おおr 大 多"
"おおo 覆 被 蔽 蓋 掩 奄"
"おおm 多 大 夛"
"おおk 大 多 夛"
"おおj 応 應"
"おおi 多 大 覆 夛 被 蔽 蓋 掩 奄"
"おおh 被 覆"
"おおg 大 多 覆 夛"
"おおe 覆 被 蔽 蓋 掩 奄"
"おおc 覆 被 蔽 蓋 掩 奄"
"おえらi お偉"
"おうぼしゃりまわr 応募者利回"
"おうぼくだs 応募下"
"おうばんぶるまi 椀飯振舞 椀飯振る舞"
"おうこうs 横行"
"おうかがi お伺"
"おうz 応 應"
"おうr お売"
"おうj 応 應"
"おいわi お祝"
"おいろなおs 御色直"
"おいやt 追い遣"
"おいやr 追い遣"
"おいやn 追い遣"
"おいやc 追い遣"
"おいもとm 追い求"
"おいまわs 追い回 追回"
"おいはらw 追い払"
"おいはらu 追い払"
"おいはらt 追い払"
"おいはらo 追い払"
"おいはらi 追い払"
"おいはらe 追い払"
"おいはらc 追い払"
"おいのr お祈"
"おいぬk 追い抜"
"おいぬi 追い抜"
"おいつづk 追い続"
"おいつかw 追い使"
"おいつかu 追い使"
"おいつかt 追い使"
"おいつかo 追い使"
"おいつかi 追い使"
"おいつかe 追い使"
"おいつかc 追い使"
"おいつm 追い詰"
"おいつk 追い付"
"おいつi 追い付"
"おいちr 追い散"
"おいだs 追い出 追出"
"おいたt 生い立 追い立"
"おいそがs お忙"
"おいすがt 追い縋"
"おいすがr 追い縋"
"おいすがn 追い縋"
"おいすがc 追い縋"
"おいしげt 生い茂"
"おいしげr 生い茂"
"おいしげn 生い茂"
"おいしげc 生い茂"
"おいこs 追い越"
"おいこn 追い込 老い込 追込"
"おいこm 追い込 老い込 追込"
"おいかけまわs 追い掛け回"
"おいかえs 追い返"
"おいかr お怒"
"おいかk 追い掛"
"おいおとs 追い落"
"おいおt 追い落"
"おいうt 追い討 追い打 追い撃"
"おいあg 追い上"
"おいt 於"
"おいs 美味"
"おいd お出"
"おあずk お預"
"おあi 御会 お会"
"おz 怖"
"おw 終 追 負 逐"
"おu 追 負 生 逐"
"おt 落 追 折 負 堕 墜 織 居 墮 逐"
"おs 押 惜 推 圧 捺 壓"
"おr 降 下 折 織 居 堕"
"おp 追"
"おo 追 逐 負"
"おn 折 織"
"おm 怖 追"
"おk 起 置 於 追 落 措 擱 大"
"おj 怖"
"おi 追 負 老 置 於 生 措 逐"
"おh 負 追 生"
"おe 終 負 追 逐"
"おd 怖"
"おc 落 堕 墜 追 負 逐 折 織"
"おb 帯 帶"
"えんりょぶかs 遠慮深"
"えんりょぶかk 遠慮深"
"えんりょぶかi 遠慮深"
"えんりょぶかg 遠慮深"
"えんりょくだs 遠慮下"
"えんむすb 縁結"
"えんばらi 円払"
"えんどおs 縁遠"
"えんどおk 縁遠"
"えんどおi 縁遠"
"えんどおg 縁遠"
"えんだt 円建"
"えんじわk 演じ分"
"えんじきt 演じ切"
"えんじきr 演じ切"
"えんじきn 演じ切"
"えんじきc 演じ切"
"えんきr 縁切"
"えんz 演"
"えんj 演"
"えろs エロ"
"えろk エロ"
"えろi エロ"
"えろg エロ"
"えりわk 選り分"
"えりぬk 選り抜"
"えりぬi 選り抜"
"えりごのm 選り好"
"えりぐr 襟刳"
"えらびぬk 選び抜"
"えらびぬi 選び抜"
"えらびとr 選び取"
"えらびだs 選び出"
"えらs 偉"
"えらn 選 択 撰"
"えらk 偉"
"えらi 偉"
"えらg 偉"
"えらb 選 撰 択 偉"
"えびぞt 海老反"
"えびぞr 海老反"
"えびぞn 海老反"
"えびぞc 海老反"
"えびがたm 海老固"
"えとk 絵解"
"えづk 餌付"
"えつk 絵付"
"えだわかr 枝分"
"えだわk 枝分"
"えだぶr 枝振"
"えだがr 枝刈"
"えだかr 枝刈"
"えぐりだs 抉り出"
"えぐt 抉 刔"
"えぐr 抉 刔"
"えぐn 抉 刔"
"えぐk 刳"
"えぐi 刳"
"えぐc 抉 刔"
"えきうr 駅売"
"えきs 益"
"えがたs 得難"
"えがたk 得難"
"えがたi 得難"
"えがたg 得難"
"えがきつづk 描き続"
"えがきだs 描き出"
"えがききt 描き切"
"えがききr 描き切"
"えがききn 描き切"
"えがききc 描き切"
"えがk 描"
"えがi 描"
"えかk 絵描"
"えいz 映 詠"
"えいr 絵入"
"えいj 映 詠"
"えz 得 獲"
"えy 得 獲"
"えt 得 獲 選"
"えs 得 獲"
"えr 得 獲 選"
"えn 得 笑 獲 選"
"えm 笑 得 獲"
"えk 得 獲"
"えc 得 獲 選"
"うんわるs 運悪"
"うんわるk 運悪"
"うんわるi 運悪"
"うんわるg 運悪"
"うんよk 運良"
"うんめいづk 運命付"
"うんだめs 運試"
"うわむk 上向"
"うわむi 上向"
"うわまわt 上回"
"うわまわr 上回"
"うわまわn 上回"
"うわまわc 上回"
"うわばk 上履"
"うわのs 上乗"
"うわのr 上乗"
"うわぬr 上塗"
"うわてひねr 上手捻"
"うわてなg 上手投"
"うわてだしなg 上手出し投"
"うわづm 上積"
"うわずt 上擦"
"うわずr 上擦"
"うわずn 上擦"
"うわずm 上澄"
"うわずc 上擦"
"うわすべr 上滑"
"うわさどおr 噂通"
"うわさs 噂"
"うわがk 上書"
"うわかk 上書"
"うわz 上"
"うわt 浮"
"うわm 上"
"うろたe 狼狽"
"うろおぼe うろ覚 空覚 疎覚"
"うれゆk 売行"
"うれのこt 売れ残"
"うれのこr 売れ残"
"うれのこn 売れ残"
"うれのこc 売れ残"
"うれしがなs 嬉し悲"
"うれえr 慯"
"うれu 憂 愁 患"
"うれs 嬉"
"うれi 憂 愁 患"
"うれe 憂 愁 患"
"うるわs 麗 美 愛"
"うるさs 煩 五月蝿 騒"
"うるさk 煩 五月蝿 騒"
"うるさi 煩 五月蝿 騒"
"うるさg 煩 五月蝿 騒"
"うるおw 潤"
"うるおu 潤"
"うるおt 潤"
"うるおs 潤"
"うるおo 潤"
"うるおi 潤"
"うるおe 潤"
"うるおc 潤"
"うるn 潤"
"うるm 潤"
"うりわたs 売り渡 売渡"
"うりはらw 売り払"
"うりはらu 売り払"
"うりはらt 売り払"
"うりはらo 売り払"
"うりはらi 売り払"
"うりはらe 売り払"
"うりはらc 売り払"
"うりぬk 売り抜"
"うりとb 売り飛"
"うりつづk 売り続"
"うりつくs 売り尽"
"うりつk 売り付"
"うりだs 売り出 売出"
"うりしぶt 売り渋"
"うりしぶr 売り渋"
"うりしぶn 売り渋"
"うりしぶc 売り渋"
"うりさばk 売り捌"
"うりさばi 売り捌"
"うりこs 売り越"
"うりこn 売り込"
"うりこm 売り込"
"うりきt 売り切"
"うりきr 売り切"
"うりきn 売り切"
"うりきc 売り切"
"うりかi 売り買"
"うりおs 売り惜 売惜"
"うりいそi 売り急"
"うりいそg 売り急"
"うりあるk 売り歩"
"うりあるi 売り歩"
"うりあg 売り上 売上"
"うりあb 売り浴"
"うらわかs うら若"
"うらわかk うら若"
"うらわかi うら若"
"うらわかg うら若"
"うらやまs 羨"
"うらやn 羨"
"うらやm 羨"
"うらなw 占 卜"
"うらなu 占 卜"
"うらなt 占 卜"
"うらなo 占 卜"
"うらなk 心泣"
"うらなi 占 卜"
"うらなg 裏投"
"うらなe 占 卜"
"うらなc 占 卜"
"うらどおr 裏通"
"うらどr 裏取"
"うらづk 裏付"
"うらさびs 心淋 心寂"
"うらごs 裏漉"
"うらぎt 裏切"
"うらぎr 裏切"
"うらぎn 裏切"
"うらぎc 裏切"
"うらがなs 心悲"
"うらがえt 裏返"
"うらがえs 裏返"
"うらがえr 裏返"
"うらがえn 裏返"
"うらがえc 裏返"
"うらがk 裏書"
"うらかえs 裏返"
"うらうt 裏打"
"うらうc 裏打"
"うらあm 裏編"
"うらr 麗"
"うらn 恨 怨 憾"
"うらm 恨 怨 憾"
"うらd 裏"
"うやまw 敬"
"うやまu 敬"
"うやまt 敬"
"うやまo 敬"
"うやまi 敬"
"うやまe 敬"
"うやまc 敬"
"うやうやs 恭"
"うめもどs 埋め戻"
"うめつくs 埋め尽"
"うめつk 埋め尽"
"うめたt 埋め立"
"うめこn 埋め込 埋込"
"うめこm 埋め込 埋込"
"うめあわs 埋め合"
"うめあw 埋め合"
"うめk 呻"
"うめi 呻"
"うみわk 産み分"
"うみづr 海釣"
"うみつk 産み付"
"うみだs 生み出 産み出"
"うみそだt 産み育"
"うみおとs 産み落 生み落"
"うみおt 産み落 生み落"
"うまれもt 生まれ持"
"うまれつk 生まれ付"
"うまれつi 生まれ付"
"うまれそだt 生まれ育 生れ育"
"うまれかわt 生れ変"
"うまれかわr 生れ変"
"うまれかわn 生れ変"
"うまれかわc 生れ変"
"うまれかw 生まれ変"
"うまれおt 生まれ落"
"うまれおc 生まれ落"
"うまれあわs 生まれ合"
"うまれあw 生まれ合"
"うまのr 馬乗"
"うまs 旨 巧 美味 上手 美 甘"
"うまr 生"
"うまm 旨 美味 甘 美"
"うまk 上手 旨 巧 美味 甘 美"
"うまi 上手 旨 美味 巧 甘 美"
"うまg 上手 旨 美味 巧 甘 美"
"うべなw 諾"
"うべなu 諾"
"うべなt 諾"
"うべなo 諾"
"うべなi 諾"
"うべなe 諾"
"うべなc 諾"
"うぶs 初"
"うぶn 初"
"うぶd 初"
"うばいとt 奪い取"
"うばいとr 奪い取"
"うばいとn 奪い取"
"うばいとc 奪い取"
"うばいつk 奪い尽"
"うばいさt 奪い去"
"うばいさr 奪い去"
"うばいさn 奪い去"
"うばいさc 奪い去"
"うばいかえs 奪い返"
"うばいあw 奪い合"
"うばいあu 奪い合"
"うばいあt 奪い合"
"うばいあo 奪い合"
"うばいあi 奪い合"
"うばいあe 奪い合"
"うばいあc 奪い合"
"うばw 奪"
"うばu 奪"
"うばt 奪"
"うばo 奪"
"うばi 奪"
"うばe 奪"
"うばc 奪"
"うのm 鵜呑 鵜飲"
"うぬぼr 自惚 己惚"
"うなだr 項垂"
"うなずきかえs 頷き返"
"うなずきあw 頷き合"
"うなずきあu 頷き合"
"うなずきあt 頷き合"
"うなずきあo 頷き合"
"うなずきあi 頷き合"
"うなずきあe 頷き合"
"うなずきあc 頷き合"
"うなずk 頷"
"うなずi 頷"
"うながs 促"
"うなt 唸"
"うなs 魘"
"うなr 唸"
"うなn 唸"
"うなc 唸"
"うとs 疎 踈"
"うとn 疎"
"うとm 疎"
"うとk 疎 踈"
"うとi 疎 踈"
"うとg 疎 踈"
"うでだめs 腕試"
"うでたてふs 腕立て伏"
"うでぐm 腕組"
"うできk 腕利"
"うでがたm 腕固"
"うでおs 腕押"
"うつりゆk 移り行"
"うつりこn 写り込 映り込"
"うつりこm 映り込 写り込"
"うつりかわt 移り変"
"うつりかわr 移り変"
"うつりかわn 移り変"
"うつりかわc 移り変"
"うつりかw 移り変"
"うつむk 俯"
"うつむi 俯"
"うつぶs 俯 うつ伏"
"うつしとt 写し取"
"うつしとr 写し取"
"うつしとn 写し取"
"うつしとc 写し取"
"うつしだs 映し出 写し出"
"うつしこn 写し込"
"うつしこm 写し込"
"うつくs 美"
"うつt 移 写 映 遷 冩 寫 暎 伝染"
"うつs 移 写 映 寫 冩 暎 鬱"
"うつr 移 映 写 虚 空 伝染 遷 寫 冩 暎"
"うつn 移 映 写 伝染 遷 寫 冩 暎 鬱"
"うつk 虚 空"
"うつd 鬱"
"うつc 移 映 写 伝染 遷 寫 冩 暎"
"うっとうs 鬱陶 欝陶"
"うってでz 打って出"
"うってでy 打って出"
"うってでt 打って出"
"うってでs 打って出"
"うってでr 打って出"
"うってでn 打って出"
"うってでm 打って出"
"うってでk 打って出"
"うってでc 打って出"
"うってかわt 打って変"
"うってかわr 打って変"
"うってかわn 打って変"
"うってかわc 打って変"
"うっちゃt 打っ棄 打っ遣"
"うっちゃr 打っ棄 打っ遣"
"うっちゃn 打っ棄 打っ遣"
"うっちゃc 打っ棄 打っ遣"
"うったえかk 訴え掛"
"うったe 訴"
"うっすr 薄"
"うちわもm 内輪揉"
"うちわたs 内渡"
"うちよs 打ち寄"
"うちやぶt 打ち破 討ち破"
"うちやぶr 打ち破 討ち破"
"うちやぶn 打ち破 討ち破"
"うちやぶc 打ち破 討ち破"
"うちもr 討ち漏"
"うちまわr 内回"
"うちまちがi 打ち間違"
"うちまちがe 打ち間違"
"うちまk 打ち負"
"うちほろb 討ち滅"
"うちふt 打ち振"
"うちふr 打ち振"
"うちふn 打ち振"
"うちふc 打ち振"
"うちひしi 打ち拉"
"うちひしg 打ち拉"
"うちはらw 打ち払"
"うちはらu 打ち払"
"うちはらt 打ち払"
"うちはらo 打ち払"
"うちはらi 打ち払"
"うちはらe 打ち払"
"うちはらc 打ち払"
"うちはなs 打ち放"
"うちはたs 討ち果"
"うちはt 討ち果"
"うちぬk 打ち抜 撃ち抜 打抜"
"うちぬi 打ち抜 撃ち抜 打抜"
"うちながm 打ち眺"
"うちなおs 打ち直"
"うちなr 打ち鳴"
"うちどm 打ち止 打止"
"うちとおs 打ち通"
"うちとt 打ち取 討ち取"
"うちとr 打ち取 討ち取"
"うちとn 打ち取 討ち取"
"うちとk 打ち解"
"うちとc 打ち取 討ち取"
"うちつづk 打ち続"
"うちつk 打ち付"
"うちっぱなs 打ちっ放"
"うちだs 打ち出"
"うちたおs 打ち倒"
"うちたt 打ち立"
"うちそんj 打ち損"
"うちすt 打ち捨"
"うちじn 討ち死"
"うちさわi 打ち騒"
"うちさわg 打ち騒"
"うちこわs 打ち壊"
"うちころs 打ち殺"
"うちこn 打ち込 撃ち込 打込"
"うちこm 打ち込 撃ち込 打込"
"うちけs 打ち消 打消"
"うちくだk 打ち砕"
"うちくだi 打ち砕"
"うちくずs 打ち崩"
"うちきょうz 打ち興"
"うちきょうj 打ち興"
"うちきt 打ち切 打切"
"うちきr 打ち切 打切"
"うちきn 打ち切 打切"
"うちきc 打ち切 打切"
"うちがk 内掛"
"うちかえs 打ち返"
"うちかt 打ち勝 打ち克"
"うちかr 打ち枯"
"うちかk 打ち掛 打掛 打ち欠"
"うちかi 打ち欠"
"うちかc 打ち勝 打ち克"
"うちおとs 打ち落 撃ち落"
"うちおt 打ち落 撃ち落"
"うちおr 打ち下"
"うちいt 討ち入"
"うちいr 討ち入"
"うちいn 討ち入"
"うちいc 討ち入"
"うちあわs 打合 打ち合"
"うちあw 打ち合 打合 撃ち合"
"うちあu 打ち合 撃ち合"
"うちあt 打ち合 撃ち合"
"うちあo 打ち合 撃ち合"
"うちあk 打ち明"
"うちあi 撃ち合 打ち合"
"うちあg 打ち上 打上"
"うちあe 打ち合 撃ち合"
"うちあc 打ち合 撃ち合"
"うたれづよs 打たれ強"
"うたれづよk 打たれ強"
"うたれづよi 打たれ強"
"うたれづよg 打たれ強"
"うたぐりぶかs 疑り深"
"うたぐりぶかk 疑り深"
"うたぐりぶかi 疑り深"
"うたぐりぶかg 疑り深"
"うたぐt 疑"
"うたぐr 疑"
"うたぐn 疑"
"うたぐc 疑"
"うたがいなs 疑い無"
"うたがいなk 疑い無"
"うたがいなi 疑い無"
"うたがw 疑"
"うたがu 疑"
"うたがt 疑"
"うたがo 疑"
"うたがi 疑"
"うたがe 疑"
"うたがc 疑"
"うたいはじm 歌い始"
"うたいつづk 歌い続"
"うたいだs 歌い出"
"うたいあk 歌い明"
"うたいあg 歌い上 謳い上"
"うたw 歌 唄 謳 謡 唱 謠 謌 詠"
"うたu 歌 唄 謳 詠 唱 謡 謠 謌"
"うたt 歌 唄 謳 謡 唱 謌 詠 謠"
"うたo 歌 唄 謳 謡 唱 謠 謌 詠"
"うたi 歌 謳 唄 謡 謌 唱 謠 詠"
"うたe 歌 唄 謡 謌 唱 謳 謠 詠"
"うたc 歌 唄 謳 唱 謡 謠 謌 詠"
"うそぶk 嘯"
"うそぶi 嘯"
"うそくさs 嘘臭"
"うそくさk 嘘臭"
"うそくさi 嘘臭"
"うそくさg 嘘臭"
"うせつまt 右折待"
"うせつまc 右折待"
"うずまk 渦巻"
"うずまi 渦巻"
"うずたかs 堆"
"うずたかk 堆"
"うずたかi 堆"
"うずたかg 堆"
"うずくまt 蹲 踞"
"うずくまr 蹲 踞"
"うずくまn 蹲 踞"
"うずくまc 蹲 踞"
"うずくm 蹲"
"うずm 埋"
"うずk 疼"
"うずi 疼"
"うすわらi 薄笑"
"うすらさむs 薄ら寒"
"うすらさむk 薄ら寒"
"うすらさむi 薄ら寒"
"うすらさむg 薄ら寒"
"うすよごr 薄汚"
"うすすg 薄過"
"うすぐらs 薄暗"
"うすぐらk 薄暗"
"うすぐらi 薄暗"
"うすぐらg 薄暗"
"うすくらg 薄暗"
"うすぎたなs 薄汚"
"うすぎたなk 薄汚"
"うすぎたなi 薄汚"
"うすぎたなg 薄汚"
"うすぎr 薄切"
"うすきみわるs 薄気味悪"
"うすきみわるk 薄気味悪"
"うすきみわるi 薄気味悪"
"うすきみわるg 薄気味悪"
"うすあきなi 薄商"
"うすあおs 薄青"
"うすあおm 薄青"
"うすあおk 薄青"
"うすあおi 薄青"
"うすあおg 薄青"
"うすs 薄"
"うすr 薄"
"うすp 薄"
"うすm 薄"
"うすk 薄"
"うすi 薄"
"うすg 薄"
"うしろむk 後ろ向 後向"
"うしろづk 後ろ付"
"うしろぐらs 後ろ暗"
"うしろぐらk 後ろ暗"
"うしろぐらi 後ろ暗"
"うしろぐらg 後ろ暗"
"うしみt 丑三"
"うしなw 失 喪"
"うしなu 失 喪"
"うしなt 失 喪"
"うしなo 失 喪"
"うしなi 失 喪"
"うしなe 失 喪"
"うしなc 失 喪"
"うしおi 牛追"
"うしr 後"
"うしn 失"
"うざs ウザ"
"うざk ウザ"
"うざi ウザ"
"うざg ウザ"
"うさんくさs 胡散臭"
"うさんくさk 胡散臭"
"うさんくさi 胡散臭"
"うさんくさg 胡散臭"
"うごめk 蠢 蠕"
"うごめi 蠢 蠕"
"うごきまわt 動き回"
"うごきまわr 動き回"
"うごきまわn 動き回"
"うごきまわc 動き回"
"うごきはじm 動き始"
"うごきだs 動き出"
"うごk 動"
"うごi 動"
"うけわたs 受け渡 受渡"
"うけもどs 受け戻"
"うけもt 受け持 受持"
"うけもc 受け持"
"うけながs 受け流"
"うけとt 受け取 受取"
"うけとr 受け取 受取"
"うけとn 受け取 受取"
"うけとm 受け止"
"うけとc 受け取 受取"
"うけつk 受け付 受付"
"うけつi 受け継 受継"
"うけつg 受け継 受継"
"うけたまわt 承"
"うけたまわr 承"
"うけたまわn 承"
"うけたまわc 承"
"うけたまw 受け賜"
"うけこたe 受け答"
"うけがw 肯"
"うけがu 肯"
"うけがt 肯"
"うけがo 肯"
"うけがi 肯"
"うけがe 肯"
"うけがc 肯"
"うけおw 請け負 請負"
"うけおu 請け負 請負"
"うけおt 請け負 請負"
"うけおo 請け負 請負"
"うけおi 請け負 請負"
"うけおe 請け負 請負"
"うけおc 請け負 請負"
"うけうr 受け売 受売 請け売 請売"
"うけいr 受け入 受入 受け容"
"うけあw 請け合 受け合"
"うけあu 請け合 受け合"
"うけあt 請け合 受け合"
"うけあo 請け合 受け合"
"うけあi 請け合 請合 受け合"
"うけあe 請け合 受け合"
"うけあc 請け合 受け合"
"うきぼr 浮き彫"
"うきでz 浮き出"
"うきでy 浮き出"
"うきでt 浮き出"
"うきでs 浮き出"
"うきでr 浮き出"
"うきでn 浮き出"
"うきでm 浮き出"
"うきでk 浮き出"
"うきでc 浮き出"
"うきだs 浮き出"
"うきたt 浮き立"
"うきたc 浮き立"
"うきしずm 浮き沈"
"うきがs 浮貸"
"うきうk 浮き浮"
"うきあしだt 浮き足立 浮足立"
"うきあしだc 浮き足立 浮足立"
"うきあg 浮き上"
"うがちすg 穿ち過"
"うがいs 嗽"
"うがt 穿 鑿"
"うがc 穿 鑿"
"うかれさわi 浮かれ騒"
"うかれさわg 浮かれ騒"
"うかびでy 浮かび出"
"うかびでt 浮かび出"
"うかびでs 浮かび出"
"うかびでr 浮かび出"
"うかびでn 浮かび出"
"うかびでm 浮かび出"
"うかびあg 浮かび上"
"うかがいしt 窺い知"
"うかがいしr 窺い知"
"うかがいしn 窺い知"
"うかがいしc 窺い知"
"うかがw 伺 窺 覘"
"うかがu 伺 窺 覘"
"うかがt 伺 窺 覘"
"うかがo 伺 窺 覘"
"うかがi 伺 窺 覘"
"うかがe 伺 窺 覘"
"うかがc 伺 窺 覘"
"うかt 合格"
"うかr 合格 浮か"
"うかn 浮 合格"
"うかc 合格"
"うかb 浮"
"うおつr 魚釣"
"うえよs 上寄"
"うえつk 植え付 上付 植付"
"うえこn 植え込 植込"
"うえこm 植え込 植込"
"うえd 上"
"ういろううr 外郎売"
"ういういs 初々"
"うz 埋"
"うw 植"
"うt 打 撃 討 売 射 撲 搏 攵 攴 賣"
"うs 失 憂"
"うr 売 熟 得 賣"
"うn 生 産 膿 売 賣 倦 績"
"うm 埋 生 産 倦 膿 績"
"うk 受 浮 請 憂 承 享 泛"
"うi 浮 憂 泛"
"うg 憂"
"うe 植 飢"
"うd 茹"
"うc 打 討 撃 売 射 撲 搏 攵 攴 賣"
"うb 得"
"いんしょうぶかs 印象深"
"いんしょうぶかk 印象深"
"いんしょうぶかi 印象深"
"いんしょうぶかg 印象深"
"いんしょうづk 印象付"
"いんきくさs 陰気臭"
"いんきくさk 陰気臭"
"いんきくさi 陰気臭"
"いんきくさg 陰気臭"
"いんs 因 飲 淫"
"いんn 陰"
"いわばしr 石走"
"いわw 祝"
"いわu 祝"
"いわt 祝"
"いわr 謂"
"いわo 祝"
"いわk 曰"
"いわi 祝"
"いわe 祝"
"いわc 祝"
"いわb 言わ"
"いろわk 色分"
"いろよi 色好"
"いろめきたt 色めき立"
"いろめきたc 色めき立"
"いろどt 彩"
"いろどr 彩 色取"
"いろどn 彩"
"いろどc 彩"
"いろづかi 色使"
"いろづk 色付"
"いろづi 色付"
"いろちがi 色違"
"いろだs 色出"
"いろこs 色濃"
"いろこk 色濃"
"いろこi 色濃"
"いろけづk 色気付"
"いろけづi 色気付"
"いろおt 色落"
"いろあわs 色合"
"いろあw 色合"
"いろあs 色褪"
"いろあi 色合"
"いろp 色"
"いろn 色"
"いろm 色"
"いれわすr 入れ忘"
"いれまz 入れ混"
"いれなおs 入れ直"
"いれちがw 入れ違"
"いれちがu 入れ違"
"いれちがt 入れ違"
"いれちがo 入れ違"
"いれちがi 入れ違"
"いれちがc 入れ違"
"いれたt 入れ立"
"いれこn 入れ込"
"いれこm 入れ込"
"いれぐi 入れ食"
"いれかw 入れ替 入れ換"
"いれかe 入れ替 入れ換"
"いれあg 入れ揚"
"いりみだr 入り乱"
"いりまj 入り交"
"いりびたt 入り浸"
"いりびたr 入り浸"
"いりびたn 入り浸"
"いりびたc 入り浸"
"いりつk 煎り付 炒り付"
"いりたt 入り立"
"いりたc 入り立"
"いりこn 入り込"
"いりこm 入り込"
"いりくn 入り組"
"いりくm 入り組"
"いらだt 苛立"
"いらだc 苛立"
"いらいらしi 苛苛し"
"いらw 弄 苛 綺"
"いらu 弄 苛 綺"
"いらt 苛 弄 綺"
"いらs 貸"
"いらo 弄 苛 綺"
"いらi 弄 苛 綺"
"いらh 苛 弄"
"いらe 応 答 弄 苛 綺"
"いらd 苛"
"いらc 弄 苛 綺"
"いやまs 弥増 いや増"
"いやしくm 苟"
"いやしm 卑し"
"いやおうなs 否応無"
"いやおうなk 否応無"
"いやおうなi 否応無"
"いやs 癒 卑 賤 医 嫌 厭"
"いやr 嫌"
"いやn 嫌 厭"
"いやm 厭"
"いやg 嫌"
"いやd 嫌 厭"
"いもほr 芋掘 藷掘"
"いもはg 芋接"
"いもつg 芋継"
"いもざs 芋刺"
"いみぶかs 意味深"
"いみぶかk 意味深"
"いみぶかi 意味深"
"いみぶかg 意味深"
"いみづk 意味付"
"いみきらw 忌み嫌"
"いみきらu 忌み嫌"
"いみきらt 忌み嫌"
"いみきらo 忌み嫌"
"いみきらi 忌み嫌"
"いみきらe 忌み嫌"
"いみきらc 忌み嫌"
"いみあi 意味合"
"いみs 意味"
"いまわs 忌"
"いまひとt 今一"
"いましばらk 今暫"
"いましm 戒 縛 誡 警"
"いまいまs 忌々"
"いまy 今"
"いまs 今 在 坐"
"いまn 今"
"いまd 未"
"いぶりだs 燻り出"
"いぶかt 訝"
"いぶかs 訝"
"いぶかr 訝"
"いぶかn 訝"
"いぶかc 訝"
"いぶt 燻"
"いぶs 燻"
"いぶr 燻"
"いぶn 燻"
"いぶk 息吹 気吹"
"いぶi 息吹 気吹"
"いぶc 燻"
"いびつs 歪"
"いびつn 歪"
"いびつd 歪"
"いばt 威張"
"いばr 威張"
"いばn 威張"
"いばc 威張"
"いのちもe 命燃"
"いのちびろi 命拾"
"いのちとr 命取"
"いのちごi 命乞"
"いのちがk 命懸"
"いのこt 居残"
"いのこr 居残"
"いのこn 居残"
"いのこc 居残"
"いのt 祈"
"いのr 祈"
"いのn 祈"
"いのc 祈"
"いねむr 居眠"
"いねかr 稲刈"
"いぬじn 犬死"
"いぬk 居抜 射貫"
"いぬi 居抜 射貫"
"いならn 居並"
"いならb 居並"
"いななk 嘶"
"いななi 嘶"
"いなかじm 田舎染"
"いなかくさs 田舎臭"
"いなかくさk 田舎臭"
"いなかくさi 田舎臭"
"いなかくさg 田舎臭"
"いなおt 居直"
"いなおr 居直"
"いなおn 居直"
"いなおc 居直"
"いなy 否"
"いなn 否"
"いなm 否"
"いなk 否"
"いどn 挑"
"いどm 挑"
"いとなn 営 營"
"いとなm 営 營"
"いとけなs 稚 幼"
"いとけなk 稚 幼"
"いとけなi 稚 幼"
"いとけなg 稚 幼"
"いとw 厭"
"いとu 厭"
"いとt 厭"
"いとs 愛"
"いとo 愛 厭"
"いとm 射止"
"いとk 幼"
"いとi 厭"
"いとe 厭"
"いとc 厭"
"いでたt 出で立"
"いてつk 凍て付 凍てつ"
"いてつi 凍て付"
"いづらs 居辛"
"いづらk 居辛"
"いづらi 居辛"
"いづらg 居辛"
"いつわt 偽 僞"
"いつわr 偽 僞"
"いつわn 偽 僞"
"いつわc 偽 僞"
"いつのまn 何時の間"
"いつづk 居続"
"いつくしn 慈"
"いつくしm 慈"
"いつくs 慈"
"いつz 何時"
"いつt 五"
"いつm 何時"
"いつk 居着 何時"
"いつi 居着"
"いっぽんだt 一本立"
"いっぱんn 一般"
"いってんばr 一点張"
"いってこz 行って来"
"いってこy 行って来"
"いってこs 行って来"
"いってこr 行って来"
"いってこn 行って来"
"いってこi 行って来"
"いってくr 行って来"
"いってくn 行って来"
"いってきy 行って来"
"いってきt 行って来"
"いってきs 行って来"
"いってきn 行って来"
"いってきm 行って来"
"いってきk 言って聞"
"いってきd 行って来"
"いってきc 行って来"
"いっそうs 一掃"
"いっせいn 一斉"
"いっしょn 一緒"
"いっしむくi 一矢報"
"いっこだt 一戸建"
"いっきよm 一気読"
"いっきn 一気"
"いっかつs 一括"
"いっs 逸"
"いちりんざs 一輪挿"
"いちやづk 一夜漬"
"いちもんなs 一文無"
"いちもくおk 一目置"
"いちもくおi 一目置"
"いちはやs 逸速 逸早 いち速 いち早 一早 一速"
"いちはやk 一早 逸早 逸速 いち速 いち早 一速"
"いちはやi いち速 いち早 一早 逸早 一速 逸速"
"いちとr 位置取"
"いちづk 位置付"
"いちずk 位置付"
"いちじるs 著"
"いちぎm 位置決"
"いちがいn 一概"
"いちおs 一押"
"いちs 位置"
"いだk 抱 懐"
"いだi 抱 懐"
"いたわt 労"
"いたわs 労"
"いたわr 労"
"いたわn 労"
"いたわc 労"
"いためつk 痛め付"
"いたみどm 痛み止"
"いたみいt 痛み入"
"いたみいr 痛み入"
"いたみいn 痛み入"
"いたみいc 痛み入"
"いたぶt 甚振"
"いたぶr 甚振"
"いたぶn 甚振"
"いたぶc 甚振"
"いたばさm 板挟"
"いただk 頂 戴"
"いただi 頂 戴"
"いたずらn 徒"
"いたすg 痛過"
"いたしかゆs 痛し痒"
"いたがゆs 痛痒"
"いたがゆk 痛痒"
"いたがゆi 痛痒"
"いたがゆg 痛痒"
"いたいたs 痛々"
"いたw 労"
"いたt 至 到 致"
"いたs 致 痛 イタ"
"いたr 至 到 致"
"いたn 痛 傷 悼 至 到 致 愴 慯"
"いたm 痛 傷 炒 悼 愴 慯"
"いたk 痛 イタ"
"いたi 痛 イタ"
"いたg 痛 イタ"
"いたc 至 到 致"
"いぞr 居反"
"いそがs 忙"
"いそs 勤"
"いそi 急"
"いそg 急"
"いずr 何 孰"
"いずm 居住"
"いすわt 居座"
"いすわr 居座"
"いすわn 居座"
"いすわc 居座"
"いすくm 射竦"
"いじわるs 意地悪"
"いじわるk 意地悪"
"いじわるi 意地悪"
"いじわるg 意地悪"
"いじりまわs 弄り回"
"いじょうn 異常"
"いじっぱr 意地っ張"
"いじくりまわs 弄くり回"
"いじきたなs 意地汚"
"いじきたなk 意地汚"
"いじきたなi 意地汚"
"いじきたなg 意地汚"
"いじt 弄"
"いじs 維持"
"いじr 弄"
"いじn 弄"
"いじm 苛"
"いじk 弄"
"いじc 弄"
"いしょうあw 衣装合"
"いしゅがえs 意趣返"
"いしやk 石焼"
"いしなg 石投"
"いしとr 石取"
"いしづくr 石造"
"いしぐm 石組"
"いしきs 意識"
"いざなw 誘"
"いざなu 誘"
"いざなt 誘"
"いざなo 誘"
"いざなi 誘"
"いざなe 誘"
"いざなc 誘"
"いざt 躄 膝行"
"いざr 躄 膝行"
"いざn 躄 膝行"
"いざc 躄 膝行"
"いさみたt 勇み立"
"いさみたc 勇み立"
"いささk 些 聊"
"いさぎよs 潔"
"いさぎよk 潔"
"いさぎよi 潔"
"いさぎよg 潔"
"いさかw 諍"
"いさかu 諍"
"いさかt 諍"
"いさかo 諍"
"いさかi 諍"
"いさかe 諍"
"いさかc 諍"
"いさいかまw 委細構"
"いさn 勇 諫 諌"
"いさm 勇 諫 諌"
"いごk 動"
"いごi 動"
"いこうs 移行"
"いこw 憩 憇"
"いこu 憩 憇"
"いこt 憩 憇"
"いこo 憩 憇"
"いこn 鋳込 射込"
"いこm 鋳込 射込"
"いこi 憩 憇"
"いこe 憩 憇"
"いこc 憩 憇"
"いけどt 生け捕"
"いけどr 生け捕"
"いけどn 生け捕"
"いけどc 生け捕"
"いけすk いけ好"
"いけn 不可"
"いくとおr 幾通"
"いくt 幾"
"いくr 幾"
"いぎもうしたt 異議申立"
"いぎぶかs 意義深"
"いぎぶかk 意義深"
"いぎぶかi 意義深"
"いぎぶかg 意義深"
"いぎたなs 寝穢"
"いぎたなk 寝穢"
"いぎたなi 寝穢"
"いぎたなg 寝穢"
"いきわたt 行き渡"
"いきわたr 行き渡"
"いきわたn 行き渡"
"いきわたc 行き渡"
"いきわかr 生き別"
"いきりたt 熱り立"
"いきりたc 熱り立"
"いきまk 息巻"
"いきまi 息巻"
"いきのこt 生き残"
"いきのこr 生き残"
"いきのこn 生き残"
"いきのこc 生き残"
"いきのb 生き延"
"いきぬk 息抜 生き抜"
"いきぬi 生き抜"
"いきなやn 行き悩"
"いきなやm 行き悩"
"いきながらe 生き存"
"いきながr 生き長 生き永"
"いきどおt 憤"
"いきどおr 憤"
"いきどおn 憤"
"いきどおc 憤"
"いきどm 行き止"
"いきとどk 行き届"
"いきとどi 行き届"
"いきてゆk 生きて行"
"いきていt 生きて行"
"いきていk 生きて行"
"いきていc 生きて行"
"いきづかi 息遣 息使"
"いきづm 行き詰 息詰"
"いきづk 息衝"
"いきづi 息衝"
"いきつづk 生き続"
"いきつk 行き着 行き付"
"いきつi 行き着"
"いきつg 息継"
"いきちがw 行き違"
"いきちがu 行き違"
"いきちがt 行き違"
"いきちがo 行き違"
"いきちがi 行き違"
"いきちがe 行き違"
"いきちがc 行き違"
"いきだおr 行き倒"
"いきたe 息絶"
"いきせききt 息せき切 息急き切"
"いきせききr 息急き切 息せき切"
"いきせききn 息急き切 息せき切"
"いきせききc 息急き切 息せき切"
"いきせk 息急"
"いきすg 行き過 行過"
"いきごn 意気込"
"いきごm 意気込"
"いきぐるs 息苦"
"いきぎr 息切"
"いきがかt 行き掛"
"いきがかr 行き掛"
"いきがかn 行き掛"
"いきがかc 行き掛"
"いきがk 行き掛"
"いきかよw 行き通"
"いきかよu 行き通"
"いきかよt 行き通"
"いきかよo 行き通"
"いきかよi 行き通"
"いきかよe 行き通"
"いきかよc 行き通"
"いきかえt 生き返"
"いきかえr 生き返 行き帰"
"いきかえn 生き返"
"いきかえc 生き返"
"いきかw 行き交"
"いきかu 行き交"
"いきかt 行き交"
"いきかo 行き交"
"いきかi 行き交"
"いきかe 行き交"
"いきかc 行き交"
"いきおいよk 勢い良"
"いきおいづk 勢い付"
"いきおいづi 勢い付"
"いきおいこn 勢い込"
"いきおいこm 勢い込"
"いきおいあまt 勢い余"
"いきおいあまr 勢い余"
"いきおいあまc 勢い余"
"いきおi 勢"
"いきうつs 生き写"
"いきうm 生き埋"
"いきいそi 生き急"
"いきいそg 生き急"
"いきいk 生き生"
"いきあたt 行き当"
"いきあたr 行き当"
"いきあたn 行き当"
"いきあたc 行き当"
"いきあw 行き合"
"いきあu 行き合"
"いきあt 行き当 行き合 行当"
"いきあo 行き合"
"いきあi 行き合"
"いきあe 行き合"
"いきあc 行き合"
"いきs 息 粋 粹"
"いきr 熱"
"いきn 息 粋 粹"
"いきm 息"
"いきg 粋 意気"
"いきd 粋 粹"
"いがみあw 啀み合"
"いがみあu 啀み合"
"いがみあt 啀み合"
"いがみあo 啀み合"
"いがみあi 啀み合"
"いがみあe 啀み合"
"いがみあc 啀み合"
"いがいt 意外"
"いがいn 意外"
"いがいd 意外"
"いがn 啀"
"いがm 啀"
"いかんなk 遺憾無"
"いかりくるw 怒り狂"
"いかりくるu 怒り狂"
"いかりくるt 怒り狂"
"いかりくるo 怒り狂"
"いかりくるi 怒り狂"
"いかりくるe 怒り狂"
"いかりくるc 怒り狂"
"いかしきt 活かし切"
"いかしきr 活かし切"
"いかしきn 活かし切"
"いかしきc 活かし切"
"いかがw 如何"
"いかおなz 以下同"
"いかおなj 以下同"
"いかt 怒 厳 忿"
"いかr 怒 忿"
"いかn 以下 何如 如何 怒 忿"
"いかm 厳"
"いかk 射掛"
"いかg 如何"
"いかd 如何"
"いかc 怒 忿"
"いえどm 雖"
"いえr 癒え"
"いいわたs 言い渡 言渡"
"いいわすr 言い忘"
"いいわk 言い分"
"いいよどn 言い淀"
"いいよどm 言い淀"
"いいよt 言い寄"
"いいよr 言い寄"
"いいよn 言い寄"
"いいよc 言い寄"
"いいもr 言い漏"
"いいまわs 言い回"
"いいまちがw 言い間違"
"いいまちがu 言い間違"
"いいまちがt 言い間違"
"いいまちがo 言い間違"
"いいまちがi 言い間違"
"いいまちがe 言い間違"
"いいまちがc 言い間違"
"いいまぎr 言い紛"
"いいまk 言い負"
"いいまg 言い曲"
"いいふるs 言い古"
"いいふくm 言い含"
"いいふr 言い触"
"いいひろm 言い広"
"いいひらk 言い開"
"いいひらi 言い開"
"いいはなt 言い放"
"いいはなc 言い放"
"いいはじm 言い始"
"いいはt 言い張"
"いいはr 言い張"
"いいはn 言い張"
"いいはc 言い張"
"いいのこs 言い残"
"いいのがr 言い逃"
"いいのk 言い退"
"いいぬk 言い抜"
"いいにくs 言い難"
"いいにくk 言い難"
"いいにくi 言い難"
"いいにくg 言い難"
"いいならw 言い習"
"いいなおs 言い直"
"いいとおs 言い通"
"いいづらs 言い辛"
"いいづらk 言い辛"
"いいづらi 言い辛"
"いいづらg 言い辛"
"いいつのt 言い募"
"いいつのr 言い募"
"いいつのn 言い募"
"いいつのc 言い募"
"いいつづk 言い続"
"いいつたe 言い伝"
"いいつくろw 言い繕"
"いいつくろu 言い繕"
"いいつくろt 言い繕"
"いいつくろo 言い繕"
"いいつくろi 言い繕"
"いいつくろc 言い繕"
"いいつくs 言い尽"
"いいつk 言い尽 言い付"
"いいつi 言い継"
"いいつg 言い継"
"いいっぱなs 言いっ放"
"いいちがe 言い違"
"いいちr 言い散"
"いいだs 言い出"
"いいたがe 言い違"
"いいたt 言い立"
"いいたs 言い足"
"いいたr 言い足"
"いいそんj 言い損"
"いいそこn 言い損"
"いいそe 言い添"
"いいすt 言い捨"
"いいすg 言い過"
"いいしぶt 言い渋"
"いいしぶr 言い渋"
"いいしぶn 言い渋"
"いいしぶc 言い渋"
"いいしt 言い知"
"いいしr 言い知"
"いいしn 言い知"
"いいしc 言い知"
"いいこm 言い籠"
"いいけs 言い消"
"いいくるm 言い包"
"いいきt 言い切"
"いいきr 言い切"
"いいきn 言い切"
"いいきk 言い聞"
"いいきc 言い切"
"いいがたs 言い難"
"いいがたk 言い難"
"いいがたi 言い難"
"いいがたg 言い難"
"いいがk 言い掛"
"いいかわs 言い交"
"いいかえs 言い返"
"いいかえr 言い替え"
"いいかw 言い交"
"いいかn 言い兼"
"いいかk 言い掛"
"いいかe 言い換 言い替"
"いいおよn 言い及"
"いいおよb 言い及"
"いいおとs 言い落"
"いいおくt 言い送"
"いいおくr 言い送"
"いいおくn 言い送"
"いいおくc 言い送"
"いいおw 言い終"
"いいおk 言い置"
"いいおi 言い置"
"いいおe 言い終"
"いいあるk 言い歩"
"いいあるi 言い歩"
"いいあらわs 言い表"
"いいあらたm 言い改"
"いいあらそw 言い争"
"いいあらそu 言い争"
"いいあらそt 言い争"
"いいあらそo 言い争"
"いいあらそi 言い争"
"いいあらそe 言い争"
"いいあらそc 言い争"
"いいあやまt 言い誤"
"いいあやまr 言い誤"
"いいあやまn 言い誤"
"いいあやまc 言い誤"
"いいあw 言い合"
"いいあu 言い合"
"いいあt 言い当 言い合"
"いいあo 言い合"
"いいあi 言い合"
"いいあe 言い合"
"いいあc 言い合"
"いあわs 居合"
"いあw 居合"
"いあu 居合"
"いあt 居合"
"いあo 居合"
"いあi 居合"
"いあe 居合"
"いあc 居合"
"いz 居 射 鋳 将 率 鑄"
"いy 癒 居 射 言 鋳 将 率 鑄"
"いw 言 云 謂 射 居 鋳 将 率 鑄"
"いu 言 云 謂 射 居 鋳 将 率 鑄"
"いt 言 行 入 居 射 云 炒 煎 凍 要 逝 謂 鋳 将 率 熬 鑄 往"
"いs 医 逸 射 居 鋳 将 率 鑄"
"いr 入 射 要 居 炒 煎 鋳 容 淹 挿 将 率 熬 鑄"
"いp 射 居 鋳 将 率 鑄"
"いo 言 云 謂 射 居 鋳 将 率 鑄"
"いn 居 異 去 要 往 入 射 炒 煎 鋳 将 率 熬 鑄 忌 斎"
"いm 忌 居 斎 射 鋳 将 率 鑄"
"いk 行 生 活 逝 往 射 居 鋳 将 率 鑄 良 好 善 可"
"いj 射 居 鋳 将 率 鑄"
"いi 言 良 云 可 好 善 謂 射 居 鋳 将 率 鑄"
"いh 云 言 射 居 鋳 将 率 鑄"
"いg 射 居 鋳 将 率 鑄"
"いe 言 癒 云 謂 射 居 鋳 将 率 鑄"
"いd 出 射 居 鋳 将 率 鑄"
"いc 言 行 云 謂 入 射 要 居 炒 煎 鋳 将 率 熬 鑄 逝 往"
"いb 射 居 鋳 将 率 鑄"
"いa 射 居 鋳 将 率 鑄"
"あんないいたs 案内致"
"あんぜんd 安全"
"あんしんくだs 安心下"
"あんしんs 安心"
"あんz 案 按"
"あんn 暗"
"あんk 餡"
"あんj 案 按"
"あんd 編ん"
"あわれn 憐"
"あわれm 憐"
"あわびむすb 鮑結"
"あわだt 泡立 粟立"
"あわだc 泡立 粟立"
"あわただs 慌 遽"
"あわせよn 併せ読"
"あわせよm 併せ読"
"あわせもt 合わせ持"
"あわせもc 合わせ持"
"あわせのn 併せ呑"
"あわせのm 併せ呑"
"あわおどr 阿波踊"
"あわあわs 淡淡 淡々"
"あわt 慌 周章"
"あわs 併 合 淡"
"あわr 哀 憐 恤 閔"
"あわk 淡"
"あわi 淡"
"あわg 淡"
"あれはt 荒れ果"
"あれくるw 荒れ狂"
"あれくるu 荒れ狂"
"あれくるt 荒れ狂"
"あれくるo 荒れ狂"
"あれくるi 荒れ狂"
"あれくるe 荒れ狂"
"あれくるc 荒れ狂"
"あるきまわt 歩き回"
"あるきまわr 歩き回"
"あるきまわn 歩き回"
"あるきまわc 歩き回"
"あるきつづk 歩き続"
"あるきつかr 歩き疲"
"あるきだs 歩き出"
"あるきさt 歩き去"
"あるきさr 歩き去"
"あるきさn 歩き去"
"あるきさc 歩き去"
"あるk 歩"
"あるi 歩 或"
"ありふr 有り触"
"ありつk 有り付"
"ありつi 有り付"
"ありきたr 在り来"
"ありがとu 有り難 有難"
"ありがたy 有り難 有難"
"ありがたs 有り難 有難"
"ありがたm 有り難 有難"
"ありがたk 有り難 有難"
"ありがたi 有り難 有難"
"ありがたg 有り難 有難"
"ありえz 有り得"
"ありえy 有り得"
"ありえt 有り得"
"ありえs 有り得"
"ありえr 有り得"
"ありえn 有り得"
"ありえm 有り得"
"ありえk 有り得"
"ありえc 有り得"
"ありうr 有り得"
"ありうb 有り得"
"ありあわs 有り合"
"ありあまt 有り余"
"ありあまr 有り余"
"ありあまn 有り余"
"ありあまc 有り余"
"ありあw 有り合 在り合"
"ありk 歩"
"あらわs 表 現 著 顕 露"
"あらわr 表 現 顕"
"あらわn 露 顕"
"あらわd 露 顕"
"あらだt 荒立"
"あらたn 新"
"あらたm 改 革 検 更"
"あらそw 争 爭"
"あらそu 争 爭"
"あらそt 争 爭"
"あらそo 争 爭"
"あらそi 争 爭"
"あらそe 争 爭 競"
"あらそc 争 爭"
"あらすg 粗過"
"あらさがs 粗探"
"あらけずr 荒削"
"あらがw 抗 諍 争 爭"
"あらがu 抗 諍 争 爭"
"あらがt 抗 諍 争 爭"
"あらがo 抗 諍 争 爭"
"あらがk 荒書"
"あらがi 抗 諍 争 爭"
"あらがe 抗 諍 争 爭"
"あらがc 抗 諍 争 爭"
"あらかせg 荒稼"
"あらかじm 予 豫"
"あらいながs 洗い流"
"あらいなおs 洗い直"
"あらいだs 洗い出"
"あらいきよm 洗い清"
"あらいおとs 洗い落"
"あらいおt 洗い落"
"あらいあg 洗い上"
"あらあらs 荒々"
"あらz 非"
"あらw 表 現 洗"
"あらu 洗"
"あらt 新 洗"
"あらs 粗 荒 麁"
"あらr 荒"
"あらp 荒 粗"
"あらo 洗"
"あらk 荒 粗 麁"
"あらj 非"
"あらi 洗 荒 粗 麁"
"あらg 荒 粗 麁"
"あらe 洗"
"あらc 洗"
"あらb 荒"
"あゆみよt 歩み寄"
"あゆみよr 歩み寄"
"あゆみよn 歩み寄"
"あゆみよc 歩み寄"
"あゆみつづk 歩み続"
"あゆn 歩"
"あゆm 歩"
"あやまt 誤 過 謝 謬"
"あやまr 謝 誤 謬"
"あやまn 謝 誤 謬"
"あやまc 過 誤 謝 謬"
"あやつt 操"
"あやつr 操"
"あやつn 操"
"あやつc 操"
"あやかt 肖"
"あやかr 肖"
"あやかn 肖"
"あやかc 肖"
"あやu 危"
"あやs 怪 妖 恠"
"あやm 殺 危 怪"
"あやb 危"
"あめふt 雨降"
"あめふr 雨降"
"あめふn 雨降"
"あめふc 雨降"
"あめあg 雨上"
"あみだs 編み出"
"あみこn 編み込"
"あみこm 編み込"
"あみかk 網掛"
"あみうt 網打"
"あみあg 編み上 編上"
"あまやどr 雨宿"
"あまもよi 雨催"
"あまもr 雨漏"
"あまねs 遍 普"
"あまねk 遍 普"
"あまとb 天飛"
"あまてr 天照"
"あまつさe 剰"
"あまっさe 剰"
"あまだr 雨垂"
"あまずp 甘酸"
"あますg 甘過"
"あまごi 雨乞"
"あまくだt 天下 天降"
"あまくだr 天下 天降"
"あまくだn 天下 天降"
"あまくだc 天下 天降"
"あまぎごe 天城越"
"あまがけt 天翔"
"あまがけr 天翔"
"あまがけn 天翔"
"あまがけc 天翔"
"あまからs 甘辛"
"あまからk 甘辛"
"あまからi 甘辛"
"あまからg 甘辛"
"あまかけt 天翔"
"あまかけr 天翔"
"あまかけn 天翔"
"あまかけc 天翔"
"あまy 甘"
"あまt 余 甘 餘"
"あまs 余 甘 餘"
"あまr 余 餘"
"あまn 甘 余 餘 天"
"あまm 甘"
"あまk 甘"
"あまi 甘"
"あまg 甘"
"あまe 甘"
"あまc 甘 余 餘"
"あほくさs 阿呆臭"
"あほくさk 阿呆臭"
"あほくさi 阿呆臭"
"あほくさg 阿呆臭"
"あほうくさs 阿呆臭"
"あほうくさk 阿呆臭"
"あほうくさi 阿呆臭"
"あほうくさg 阿呆臭"
"あほr 阿呆"
"あぶりだs 炙り出"
"あぶらじm 油染"
"あぶらあg 油揚"
"あぶらk 脂 油"
"あぶらg 脂"
"あぶなs 危"
"あぶなm 危"
"あぶなk 危"
"あぶなi 危"
"あぶなg 危"
"あぶt 焙 炙 炮"
"あぶr 炙 焙 溢 炮"
"あぶn 危 炙 焙 炮"
"あぶc 炙 焙 炮"
"あふれでy 溢れ出"
"あふれでt 溢れ出"
"あふれでs 溢れ出"
"あふれでr 溢れ出"
"あふれでn 溢れ出"
"あふれでm 溢れ出"
"あふれだs 溢れ出"
"あふれかえt 溢れ返"
"あふれかえr 溢れ返"
"あふれかえn 溢れ返"
"あふれかえc 溢れ返"
"あふr 溢"
"あびせかk 浴びせ掛"
"あびs 浴"
"あばれまわt 暴れ回"
"あばれまわr 暴れ回"
"あばれまわn 暴れ回"
"あばれまわc 暴れ回"
"あばれだs 暴れ出"
"あばきたt 暴き立"
"あばr 暴"
"あばk 暴 発"
"あばi 暴 発"
"あはなt 畔放"
"あなほr 穴掘"
"あなねらi 穴狙"
"あなどt 侮"
"あなどr 侮"
"あなどn 侮"
"あなどc 侮"
"あなずr 侮"
"あながt 強"
"あなうm 穴埋"
"あなあk 穴開"
"あともどr 後戻"
"あとまわs 後回"
"あとばらi 後払"
"あとづk 後付 跡付"
"あとつg 跡継"
"あとずさt 後退"
"あとずさr 後退"
"あとずさn 後退"
"あとずさc 後退"
"あとすこs 後少"
"あとくさr 後腐"
"あとかたづk 後片付 後片づ"
"あとおs 後押"
"あとおi 後追"
"あとu 能"
"あとd 後 跡"
"あでy 艶"
"あてはまt 当て嵌"
"あてはまr 当て嵌"
"あてはまn 当て嵌"
"あてはまc 当て嵌"
"あてはm 当て嵌"
"あてながk 宛て名書"
"あてつk 当て付"
"あてこすt 当て擦"
"あてこすr 当て擦"
"あてこすn 当て擦"
"あてこすc 当て擦"
"あてこn 当て込"
"あてこm 当て込"
"あてt 宛"
"あつらh 誂"
"あつらe 誂"
"あつまt 集 集ま"
"あつまr 集 集ま"
"あつまn 集"
"あつまc 集"
"あつすg 暑過 熱過 厚過"
"あつぐるs 暑苦"
"あつくるs 暑苦"
"あつぎr 厚切"
"あつかw 扱"
"あつかu 扱"
"あつかt 扱"
"あつかo 扱"
"あつかi 扱"
"あつかe 扱"
"あつかc 扱"
"あつu 暑 熱 厚 篤"
"あつs 暑 厚 熱 圧 篤"
"あつm 集 厚 熱 暑 蒐 聚 輯 纂"
"あつk 熱 暑 厚 篤 扱"
"あつi 熱 暑 厚 篤"
"あつg 暑 熱 厚 篤"
"あつb 厚"
"あったm 温 暖"
"あったk 暖 温"
"あっけなi 呆気な"
"あっs 圧"
"あだうt 仇討 仇打"
"あだp 婀娜"
"あたりちr 当たり散 当り散"
"あたりかまw 辺り構"
"あたらしi 新し"
"あたらs 新"
"あたまわr 頭割"
"あたまだs 頭出"
"あたまがk 頭書"
"あたまうt 頭打"
"あたためなおs 温め直 暖め直"
"あたためあw 温め合 暖め合"
"あたためあu 温め合 暖め合"
"あたためあt 温め合 暖め合"
"あたためあo 温め合 暖め合"
"あたためあi 温め合 暖め合"
"あたためあe 温め合 暖め合"
"あたためあc 温め合 暖め合"
"あたたかs 暖"
"あたたかk 暖"
"あたたかi 暖"
"あたたかg 暖"
"あたたm 温 暖"
"あたたk 暖 温"
"あたかm 恰 宛"
"あたいs 価 値 價"
"あたw 能"
"あたu 能"
"あたt 当 中"
"あたr 辺 当 中 新 邊 邉"
"あたo 能"
"あたn 当 中"
"あたi 能"
"あたh 与"
"あたe 与 與 能"
"あたc 当 中"
"あそんd 遊ん"
"あそびほうk 遊び呆 遊び惚"
"あそびすg 遊び過"
"あそびあるk 遊び歩"
"あそびあるi 遊び歩"
"あそびあk 遊び明"
"あそn 遊 游"
"あそb 遊 游"
"あせにぎt 汗握"
"あせにぎr 汗握"
"あせにぎn 汗握"
"あせにぎc 汗握"
"あせくさs 汗臭"
"あせくさk 汗臭"
"あせくさi 汗臭"
"あせくさg 汗臭"
"あせt 焦"
"あせs 汗"
"あせr 焦"
"あせn 焦"
"あせc 焦"
"あせb 汗"
"あずけいr 預け入"
"あずかりしt 与り知"
"あずかりしr 与り知"
"あずかt 与 預"
"あずかr 与 預"
"あずかn 与 預"
"あずかc 与 預"
"あずk 預"
"あじわいぶかs 味わい深"
"あじわいぶかk 味わい深"
"あじわいぶかi 味わい深"
"あじわいぶかg 味わい深"
"あじつk 味付"
"あじちがi 味違"
"あじだs 味出"
"あじけなs 味気無"
"あじけなk 味気無"
"あじけなi 味気無"
"あじけなg 味気無"
"あじけs 味消"
"あじきなs 味気無"
"あじきなk 味気無"
"あじきなi 味気無"
"あじきなg 味気無"
"あじw 味"
"あじt アジ"
"あじs 味"
"あじr アジ"
"あじn 味 アジ"
"あじd 味"
"あじc アジ"
"あしまわs 足回"
"あしまわr 足回"
"あしぶm 足踏"
"あしふm 足踏"
"あしばらi 足払"
"あしなr 足慣"
"あしなm 足並"
"あしどr 足取"
"あしとr 足取"
"あしでまとi 足手纏"
"あしてまとi 足手纏"
"あしたs 晨"
"あししげk 足繁"
"あしがらm 足搦"
"あしがたm 足固"
"あしがかr 足掛"
"あしかk 足掛"
"あしk 悪 惡"
"あざわらw 嘲笑"
"あざわらu 嘲笑"
"あざわらt 嘲笑"
"あざわらo 嘲笑"
"あざわらi 嘲笑"
"あざわらe 嘲笑"
"あざわらc 嘲笑"
"あざやk 鮮"
"あざむk 欺"
"あざむi 欺"
"あざなw 糾"
"あざなu 糾"
"あざなt 糾"
"あざなo 糾"
"あざなi 糾"
"あざなe 糾"
"あざなc 糾"
"あざけt 嘲"
"あざけr 嘲"
"あざけn 嘲"
"あざけc 嘲"
"あざy 鮮"
"あさやk 朝焼"
"あさはやs 朝早"
"あさはやk 朝早"
"あさはやi 朝早"
"あさはやg 朝早"
"あさづk 浅漬"
"あさすg 浅過"
"あさぐろs 浅黒"
"あさぐろk 浅黒"
"あさぐろi 浅黒"
"あさぐろg 浅黒"
"あさがえr 朝帰"
"あさおk 朝起"
"あさいr 浅煎"
"あさt 漁"
"あさs 浅 淺"
"あさr 漁"
"あさp 朝"
"あさn 漁"
"あさm 浅 淺"
"あさk 浅 淺"
"あさi 浅 淺"
"あさg 浅 淺"
"あさc 漁"
"あこがr 憧 憬"
"あこu 赤"
"あげつらw 論"
"あげつらu 論"
"あげつらt 論"
"あげつらo 論"
"あげつらi 論"
"あげつらe 論"
"あげつらc 論"
"あげおr 上げ下"
"あげあしとr 揚げ足取"
"あげt 上"
"あけわたs 明け渡 明渡"
"あけひろg 開け広 明け広"
"あけはなt 開け放"
"あけはなs 開け放"
"あけっぴろg 開けっ広 明けっ広"
"あけっぱなs 開けっ放 明けっ放"
"あけたt 開け閉"
"あけくれr 明け暮れ"
"あけくr 明け暮"
"あぐn 倦"
"あぐm 倦"
"あくめいたかs 悪名高"
"あくめいたかk 悪名高"
"あくめいたかi 悪名高"
"あくめいたかg 悪名高"
"あくみょうだかs 悪名高"
"あくみょうだかk 悪名高"
"あくみょうだかi 悪名高"
"あくみょうだかg 悪名高"
"あくがr 憧"
"あくr 明く"
"あきれはt 呆れ果"
"あきれかえt 呆れ返"
"あきれかえr 呆れ返"
"あきれかえn 呆れ返"
"あきれかえc 呆れ返"
"あきらめきt 諦め切"
"あきらめきr 諦め切"
"あきらめきn 諦め切"
"あきらめきc 諦め切"
"あきらm 諦"
"あきらk 明"
"あきやすm 秋休"
"あきばr 秋晴"
"あきなw 商 賈"
"あきなu 商 賈"
"あきなt 商 賈"
"あきなo 商 賈"
"あきなi 商 賈"
"あきなe 商 賈"
"あきなc 商 賈"
"あきたt 飽き足"
"あきたr 飽き足"
"あきたn 飽き足"
"あきたc 飽き足"
"あきr 明 呆 顕 煥"
"あがりこn 上がり込"
"あがりこm 上がり込"
"あがなw 贖 購"
"あがなu 贖 購"
"あがなt 贖 購"
"あがなo 贖 購"
"あがなi 贖 購"
"あがなe 贖 購"
"あがなc 贖 購"
"あがt 上 騰 挙が 揚が 上が"
"あがr 上 騰 挙が 揚が 上が"
"あがn 上 騰"
"あがm 崇"
"あがk 足掻"
"あがi 足掻"
"あがc 上 騰"
"あかるすg 明る過"
"あかるs 明"
"あかるm 明"
"あかるk 明"
"あかるi 明"
"あかるg 明"
"あからm 赧"
"あかぬk 垢抜"
"あかちゃk 赤茶"
"あかじm 垢染"
"あかしだt 証立"
"あかぐろs 赤黒"
"あかぐろk 赤黒"
"あかぐろi 赤黒"
"あかぐろg 赤黒"
"あかs 証 赤 朱 證 紅 赫"
"あかr 明 灯 赤 明か"
"あかp 赤"
"あかn 赤"
"あかm 赤 紅 朱"
"あかk 赤 紅 朱 赫"
"あかi 赤 紅 朱 赫"
"あかg 赤 紅 朱 赫"
"あおりたt 煽り立"
"あおむk 仰向"
"あおむi 仰向"
"あおびかr 青光"
"あおばどおr 青葉通"
"あおたがi 青田買"
"あおじろs 青白 蒼白"
"あおじろm 青白 蒼白"
"あおじろk 青白 蒼白"
"あおじろi 青白 蒼白"
"あおじろg 青白 蒼白"
"あおぐろs 青黒 黝"
"あおぐろm 青黒 黝"
"あおぐろk 青黒 黝"
"あおぐろi 青黒 黝"
"あおぐろg 青黒 黝"
"あおくさs 青臭"
"あおくさm 青臭"
"あおくさk 青臭"
"あおくさi 青臭"
"あおくさg 青臭"
"あおぎみz 仰ぎ見"
"あおぎみy 仰ぎ見"
"あおぎみt 仰ぎ見"
"あおぎみs 仰ぎ見"
"あおぎみr 仰ぎ見"
"あおぎみn 仰ぎ見"
"あおぎみm 仰ぎ見"
"あおぎみk 仰ぎ見"
"あおぎみc 仰ぎ見"
"あおy 青"
"あおu 青 蒼 碧"
"あおt 煽 呷"
"あおs 青 蒼 碧"
"あおr 煽 呷"
"あおp 青"
"あおn 煽 呷"
"あおm 青 蒼 碧"
"あおk 青 蒼 碧"
"あおi 青 蒼 碧 仰 扇"
"あおg 仰 扇 青 蒼 碧"
"あおc 煽 呷"
"あえt 敢 敢え"
"あえi 喘"
"あえg 喘"
"あいわs 相和"
"あいようs 愛用"
"あいみたがi 相身互"
"あいみz 相見"
"あいみy 相見"
"あいみt 相見"
"あいみs 相見"
"あいみr 相見"
"あいみn 相見"
"あいみm 相見"
"あいみc 相見"
"あいまt 相俟"
"あいぼr 相惚"
"あいひとs 相等"
"あいはんs 相反"
"あいはn 相食"
"あいはm 相食"
"あいのr 相乗"
"あいなかb 相半"
"あいなt 相成"
"あいなr 相成"
"あいなn 相成"
"あいなc 相成"
"あいともなw 相伴"
"あいともなu 相伴"
"あいともなt 相伴"
"あいともなo 相伴"
"あいともなi 相伴"
"あいともなc 相伴"
"あいてどt 相手取"
"あいてどr 相手取"
"あいてどn 相手取"
"あいてどc 相手取"
"あいつらn 相連"
"あいつとm 相勤"
"あいつうz 相通"
"あいつうj 相通"
"あいつi 相次 相継"
"あいつg 相次 相継"
"あいたいs 相対"
"あいそわらi 愛想笑"
"あいそよk 愛想良"
"あいそづk 愛想尽"
"あいじょうぶかs 愛情深"
"あいじょうぶかk 愛情深"
"あいじょうぶかi 愛情深"
"あいじょうぶかg 愛情深"
"あいしあw 愛し合"
"あいしあu 愛し合"
"あいしあt 愛し合"
"あいしあo 愛し合"
"あいしあi 愛し合"
"あいしあe 愛し合"
"あいしあc 愛し合"
"あいさつがわr 挨拶代"
"あいことn 相異"
"あいかわr 相変"
"あいかw 相変"
"あいうt 相討 相打"
"あいいr 相容"
"あいs 愛"
"あいr 愛"
"あいk 愛"
"あいi 相"
"あw 合 会 併 逢 遭 會 遇"
"あu 合 会 遭 逢 遇 會"
"あt 当 宛 充 会 合 有 在 遭 逢 該 當 會 遇"
"あs 褪 悪 惡"
"あr 荒 有 在 或"
"あo 合 会 會 遭 逢 遇"
"あn 編 彼 有 在 浴"
"あm 編 浴"
"あk 開 飽 空 明 厭 倦 飫 有"
"あi 合 会 空 開 逢 遭 會 遇 飽 明 厭 倦 飫"
"あh 合 會"
"あg 上 挙 揚 擧"
"あe 会 合 逢 敢 和 韲 遭 會 遇"
"あc 合 会 遭 逢 遇 會 有 在"
"あb 浴"
)

;; Setting postfix entries.
(skkdic-set-postfix
"いき 行"
"がかり 係"
"がく 学"
"がわ 川"
"しゃ 社"
"しゅう 集"
"しょう 賞 城"
"じょう 城"
"せん 線"
"だけ 岳"
"ちゃく 着"
"てん 店"
"とうげ 峠"
"どおり 通り"
"やま 山"
"ばし 橋"
"はつ 発"
"もく 目"
"ゆき 行"
"あん 案"
"あんだ 安打"
"い 位"
"う 宇"
"えき 駅"
"えだ 枝"
"えん えん 円"
"えんさつ 円札"
"おうふく 往復"
"おく 億"
"おくえん 億円"
"おくねんまえ 億年前"
"おり 折"
"おん 音"
"か 荷 架 顆 価 日"
"かい Ｆ 階 回"
"かいせい 回生"
"かいせん 回戦 回線"
"かいだて 階建て 階建"
"かいてん 回転"
"かいはつ 開発"
"かいぶん 回分"
"かいめ 回目"
"かかん 日間"
"かく 画 格"
"かくけい 角形"
"かげつ 箇月 カ月 ヶ月"
"かこく カ国"
"かさね 重"
"かしょ カ所 個所 ヶ所 箇所"
"かじょう カ条"
"かっけい 角形"
"かねん カ年"
"かぶ 株"
"かぶん 日分"
"かめ 日目"
"かもく 科目"
"からむ カラム"
"かん 貫 管 缶 冠 巻"
"がい 階"
"がいだて 階建て 階建"
"がた 型"
"がつ 月"
"がつごう 月号"
"がつちゅう 月中"
"がつまつ 月末"
"がめん 画面"
"がん 貫"
"き 基 機 期"
"きゃく 客 脚"
"きゅう 球 級"
"きょう 強"
"きょうか 教科"
"きょく 局 曲"
"きれ 切"
"きろ ｋ Ｋ kbyte kg Km キロ"
"きろばいと kbytes kb"
"きん 斤 禁 金"
"ぎが Ｇ"
"ぎょう 行"
"ぎょうめ 行目"
"ぎん 斤"
"く 口 句 区"
"くち 口"
"くみ 組"
"ぐ 具"
"ぐらむ グラム"
"け ヶ"
"けいとう 系統"
"けた 桁"
"けん 鍵 間 軒 件"
"けんめ 軒目"
"げん 軒 弦 元 限"
"げんそく 原則"
"げんめ 限目"
"こ コ ヶ 戸 個"
"こう 校 項"
"こうかんけい 項関係"
"こく 石"
"こし 腰"
"こま 齣 コマ"
"こり 梱"
"こん 献"
"ご 語"
"ごう 號 合 号"
"ごうかん 号缶 号館"
"ごうき 号機"
"ごうしつ 号室"
"ごうしゃ 号車"
"ごうせん 号線"
"ごく 石"
"さ 差"
"さい 才 歳"
"さお 棹"
"さく 作"
"さつ 刷 札 冊"
"さつめ 冊目"
"さら 皿"
"さん 山"
"し 死 子 氏"
"しあい 試合"
"しき 色 式"
"しってん 失点"
"しつ 室"
"しな 品"
"しゃ 社 者"
"しゃく 尺"
"しゅ 首 種"
"しゅう 輯 周 集 週"
"しゅうかん 週間"
"しゅうかんご 週間後"
"しゅうねん 周年"
"しゅるい 種類"
"しょう 床 勝 章"
"しょうめん 正面"
"しょく 食 色"
"しん 進"
"しんすう 進数"
"しんほう 進法"
"じ 寺 児 字 次 時"
"じかい 次会"
"じかん 時間"
"じかんはん 時間半"
"じかんめ 時間目"
"じく 軸"
"じげん 次元"
"じごろ 時頃"
"じしけん 次試験"
"じたこうしき 次多項式"
"じはん 時半"
"じほうていしき 次方程式"
"じみゃく 次脈"
"じゃく 尺 弱"
"じゅう 重"
"じゅん 巡"
"じゅんめ 巡目"
"じょ 女"
"じょう 帖 錠 乗 条 畳"
"じよせん 次予選"
"すう 数"
"すうか 数花"
"すうせい 数性"
"すじ 筋"
"すてーじ ステージ"
"すてっぷ ステップ"
"すん 寸"
"ず 図"
"ずん 寸"
"せい 世 声"
"せいき 世紀"
"せいりょく 勢力"
"せき 石 席 隻"
"せたい 世帯"
"せだい 世代"
"せだいめ 世代目"
"せっと セット"
"せつ 節"
"せん 銭 線 選 千"
"せんえん 千円"
"せんち センチ cm"
"せんまん 千万"
"ぜん 膳"
"そう 漕 双 艘 相 層"
"そうさ 走査"
"そく 束 速 足"
"そろい 揃"
"ぞく 属"
"たい 体"
"たく 択"
"たば 束"
"たま 玉"
"たん 反"
"だ 駄 打"
"だい 大 題 代 台"
"だいめ 代目 台目"
"ださ 打差"
"だすう 打数"
"だてん 打点"
"だん 段"
"だんかい 段階"
"だんぐみ 段組み"
"だんめ 段目"
"ち 値"
"ちーむ チーム"
"ちっぷ チップ"
"ちゃく 着"
"ちょ 著"
"ちょう 張 挺 丁 兆"
"ちょうえん 兆円"
"ちょうめ 丁目"
"つ ツ つ"
"つい 対"
"つう 通"
"つうめ 通目"
"つがい 番"
"つき 月"
"つつみ 包"
"つぶ 粒"
"つぼ 坪"
"つめ つ目"
"て 手"
"てい 訂"
"ていばん 訂版"
"てん 店 点"
"てんせっと 点セット"
"と 斗"
"とう 灯 党 頭 等"
"とうしん 頭身"
"とおり 通り"
"とん 噸"
"ど ℃ ° 度"
"どめ 度目"
"なん 男"
"にち 日"
"にちかん 日間"
"にちぶん 日分"
"にん 人"
"にんぐみ 人組"
"にんぶん 人分"
"にんめ 人目"
"ねん 年"
"ねんかん 年間"
"ねんご 年後"
"ねんせい 年生"
"ねんだい 年代"
"ねんど 年度"
"ねんはん 年半"
"ねんぶん 年分"
"ねんまえ 年前"
"ねんめ 年目"
"はい 杯 敗"
"はいめ 杯目"
"はく 拍 泊"
"はこ 箱"
"はしら 柱"
"はち 鉢"
"はつ 発"
"はり 張 張り 針"
"はん 翻 版 犯"
"ばい 杯 倍"
"ばいすう 倍数"
"ばいたい 倍体"
"ばいと バイト"
"ばん 番 晩"
"ばんがい 番街"
"ばんだい 番台"
"ばんち 番地"
"ばんて 番手"
"ばんどおり 番通り"
"ばんめ 番目"
"ぱーせんと ％"
"ぱい 杯 敗"
"ぱく 泊 拍"
"ぱこ 箱"
"ぱっく パック"
"ぱつ 発"
"ぱん 犯 版"
"ひき 匹"
"ひゃくねん 百年"
"ひょう 俵 票"
"ひん 品"
"び 尾"
"びーと ビート"
"びき 匹"
"びっと ビット"
"びょう 票 秒"
"びょうかん 秒間"
"びょうし 拍子"
"びん 便"
"ぴき 匹"
"ぴょう 俵 票"
"ぴん 品"
"ふ 符"
"ふぃーと 呎"
"ふく 幅 服"
"ふくろ 袋"
"ふり 振 振り"
"ふん 分"
"ふんかん 分間"
"ぶ 分 部"
"ぶおんぷ 分音符"
"ぶきゅうふ 分休符"
"ぶもん 部門"
"ぶんかつ 分割"
"ぶんや 分野"
"ぷ 符"
"ぷく 服 幅"
"ぷん 分"
"ぷんかん 分間"
"へい 瓶"
"へるつ Hz"
"へん 遍 篇 辺 片 編"
"べん 遍"
"ぺーじ 頁 ページ"
"ぺん 篇 編 遍 辺 片"
"ほ 歩"
"ほう 包"
"ほん 本"
"ほんだて 本立て"
"ほんば 本場"
"ぼん 本"
"ぽ 歩"
"ぽん 本"
"ぽんど £ ポンド"
"まい 枚"
"まいぐみ 枚組"
"まいぶん 枚分"
"まいめ 枚目"
"まいる 哩"
"まき 巻き"
"まく 幕"
"まくもの 幕物"
"ます 枡 マス"
"まん 万"
"まんえん 万円"
"まんごく 万石"
"まんねん 万年"
"みり 粍 mm"
"むね 棟"
"めーとる メートル"
"めい 名"
"めいさま 名様"
"めが メガ Mbyte"
"めん 面"
"もう 毛"
"もじ 文字"
"もじめ 文字目"
"もん 文 門 問"
"や 夜"
"よう 葉"
"り 里 人"
"りーる リール"
"りゅう 粒"
"りょう 両"
"りょうへんせい 両編成"
"りん 厘 輪"
"りんか 輪花"
"るい 塁 類"
"るいだ 塁打"
"れつ 裂 列"
"れつめ 列目"
"れん 連"
"れんきゅう 連休"
"れんしょう 連勝"
"れんそう 連装"
"れんだ 連打"
"れんちゃん 連荘"
"れんぱい 連敗"
"れんぱつ 連発"
"れんぷ 連符"
"ろう 浪"
"ろばん 路盤"
"わ 把 羽 話"
"わり 割"
"わりびき 割り引き 割引"
"わりまし 割増"
"あい 愛"
"あじ 味"
"あつ 圧"
"あて 宛"
"あと 後 痕 跡"
"あまり 余り"
"あん 案"
"い 医 委"
"いか 以下"
"いがい 以外"
"いき 行 行き 域"
"いくさ 軍"
"いこう 以降"
"いご 以後"
"いじょう 以上"
"いぜん 以前"
"いち 市"
"いっしき 一式"
"いっしょく 一色"
"いったい 一帯"
"いっぱ 一派"
"いっぱい 一杯"
"いない 以内"
"いらい 以来"
"いろ 色"
"いん 因 印 員"
"うえ 上"
"うじ 氏"
"うす 薄"
"うまれ 生まれ"
"うら 裏"
"え 会 絵"
"えいぎょうしょ 営業所"
"えき 液 益 駅"
"えん 宴 炎 塩 園"
"おう 王"
"おき 置き 沖"
"おもて 表"
"おやかた 親方"
"おり 織"
"おん 音"
"か 禍 歌 可 家 課 科 下 化"
"かい 解 海 階 回 界 会"
"かいし 開始"
"かぎり 限り"
"かく 角 核 格"
"かぜ 風"
"かた 過多 型 方"
"かてい 過程"
"かのう 可能"
"かぶ 下部"
"かん 缶 管 艦 刊 官 館 間 観 感"
"かんきょう 環境"
"かんび 完備"
"が 画"
"がい 外 街"
"がお 顔"
"がかり 係"
"がく 額 学"
"がくと 学徒"
"がしら 頭"
"がた 方 形 型"
"がっか 学科"
"がま 釜 窯"
"がみ 紙"
"がら 柄"
"がわ 皮 革 側"
"がん 眼"
"き 紀 忌 旗 鬼 記 期 機 器"
"きかん 期間"
"きごう 記号"
"きじゅん 基準"
"きち 基地"
"きのう 機能"
"きゃく 客"
"きゅう 宮 級"
"きょう 郷 境 卿 狂 強 教"
"きょく 局"
"きん 金 菌 禁 筋"
"きんこう 近郊"
"きんし 禁止"
"きんぺん 近辺"
"ぎ 技 着 儀"
"ぎみ 気味"
"ぎょう 業"
"ぎん 銀"
"く 苦 区"
"くみ 組"
"くらい 位"
"くん 訓 君"
"ぐ 具"
"ぐう 宮"
"ぐち 口"
"ぐつ 靴"
"ぐみ 組み 組"
"ぐん 軍 群 郡"
"け 家"
"けい 刑 計 型 形 系"
"けいさつしょ 警察署"
"けいすう 係数"
"けいゆ 経由"
"けいゆう 経由"
"けん 兼 県 拳 研 券 圏 権"
"けんじん 県人"
"げ 下 気"
"げい 芸"
"げき 劇"
"げん 源 減"
"げんしょう 現象"
"げんてい 限定"
"こ 庫 個"
"こう 稿 口 高 工 港"
"こうい 行為"
"こうか 効果"
"こうき 後期"
"こうこう 高校"
"こうざ 講座"
"こうじょ 控除"
"こうない 構内"
"こうにん 公認"
"こうりつ 効率"
"こく 国"
"こつ 骨"
"こゆう 固有"
"こん 婚"
"ご 語 後"
"ごう 郷 号"
"ごえ 声"
"ごと 事 毎"
"ごろ 頃"
"さ 差"
"さい 祭 斎 才 歳"
"さいかい 再開"
"さき 先"
"さく 作 策"
"さま 様"
"さん 酸 山 産"
"ざ 座"
"ざい 財 材 罪 剤"
"ざいじゅう 在住"
"ざけ 酒"
"ざま 様"
"ざら 皿"
"ざん 残"
"し 詞 子 司 死 士 史 師 視 紙 誌 氏 市"
"しかく 資格"
"しき 職 式"
"ししゃ 支社"
"しじょう 市場"
"しせつ 施設"
"した 下"
"しだい 次第"
"しつ 質 室"
"してん 支店"
"しぶ 支部"
"しぼう 志望"
"しゃ 車 者"
"しゅ 腫 酒 手 主"
"しゅう 衆 臭 宗 州 集"
"しゅうだん 集団"
"しゅうへん 周辺"
"しゅうりょう 終了"
"しゅぎ 主義"
"しゅぎしゃ 主義者"
"しゅしょう 首相"
"しゅっしん 出身"
"しゅどう 主導"
"しょ 署 所 書"
"しょう 匠 相 小 賞 商 省 証 症"
"しょうがい 障害"
"しょき 初期"
"しょく 職 食 色"
"しょとう 初頭"
"しよう 仕様"
"しん 審 心"
"じ 地 辞 路 時"
"じかん 次官"
"じく 軸"
"じこう 事項"
"じしん 自身"
"じたい 自体"
"じだい 時代"
"じてん 辞典"
"じま 島"
"じゃく 尺 弱"
"じゅう 中"
"じゅく 塾"
"じゅつ 術"
"じゅん 順"
"じょ 所"
"じょう 嬢 場 状 上"
"じょうきょう 状況"
"じょうしょう 上昇"
"じょうせい 情勢"
"じょうたい 状態"
"じょうぶ 上部"
"じょし 女史"
"じる 汁"
"じん 陣 人"
"す 酢"
"すい 水"
"すう 数"
"すえ 末"
"すじ 筋"
"すんぜん 寸前"
"ず 酢 図"
"ずく 尽く"
"ずみ 済"
"せい 生 製 制 性"
"せいけん 政権"
"せいど 制度"
"せき 席 籍"
"せつ 説"
"せん 船 専 選 腺 線 戦"
"せんこう 先行 専攻"
"せんしゅう 専修"
"せんせい 先生"
"せんよう 専用"
"ぜい 勢 税"
"ぜん 善 膳 前 然"
"ぜんき 前期"
"ぜんご 前後"
"ぜんしゅう 全集"
"ぜんたい 全体"
"そ 素"
"そう 奏 僧 槽 相 層"
"そうそう 早々"
"そうとう 相当"
"そうほう 双方"
"そく 則"
"そだち 育ち"
"そつ 卒"
"そん 尊 損"
"ぞい 沿"
"ぞう 贈 蔵 増 像"
"ぞく 族"
"ぞん 損"
"たい 対 態 隊 帯"
"たいおう 対応"
"たいこう 大綱 対抗"
"たいしょう 対象"
"たいせい 体制 態勢"
"たく 宅"
"たけ 茸"
"たち 達"
"たて 立て"
"たん 譚"
"たんい 単位"
"たんとう 担当"
"だ 打"
"だい 代 大 台"
"だいがく 大学"
"だか 高"
"だけ 岳"
"だん 団 談"
"ち 知 地 値"
"ちく 地区"
"ちほう 地方"
"ちゃ 茶"
"ちゃく 着"
"ちゅう 注 中"
"ちゅうし 中止"
"ちょ 著"
"ちょう 庁 帳 超 調 長 町"
"ちょうか 超過"
"ちょく 直"
"ちょくご 直後"
"ちょくぜん 直前"
"ちん 賃"
"つい 対"
"つう 痛 通"
"つき 付 付き"
"づき 付き"
"づら 面"
"づれ 連れ"
"てい 体 艇 亭 邸"
"ていか 低下"
"ていし 停止"
"ていしょく 定食"
"ていど 程度"
"てき 的"
"てん 展 点"
"で 出"
"でん 伝 殿"
"と 徒 都"
"とう 棟 党 等"
"とうしょ 当初"
"とうじ 当時"
"とうりょう 当量"
"とくゆう 特有"
"とどけ 届"
"とも 共"
"ど 土 度"
"どう 堂 道"
"どうし 同士"
"どうぜん 同然"
"どき 時"
"どくじ 独自"
"どくとく 独特"
"どころ 所"
"どの 殿"
"ども 共"
"どん 丼"
"ない 内"
"ないぞう 内蔵"
"なか 仲"
"ながら 乍ら"
"など 等"
"なみ 並 並み"
"なり 也"
"に 煮 似"
"ぬし 主"
"ね 音"
"ねがい 願"
"ねつ 熱"
"のう 能"
"は 波 派"
"はい 拝 杯"
"はく 泊 博"
"はだ 肌"
"はつ 初 発"
"はば 幅"
"はん 藩 版 班 半"
"はんい 範囲"
"ば 場"
"ばい 倍"
"ばつ 閥"
"ばなし 話"
"ばん 判 盤 版"
"ひ 費 比"
"ひつ 筆"
"ひょう 評 票 表"
"ひん 品"
"び 美 日"
"びょう 病"
"ふ 府"
"ふう 風"
"ふか 不可"
"ふきん 付近"
"ふじん 夫人"
"ふぜい 風情"
"ふのう 不能"
"ふん 墳"
"ぶ 部"
"ぶつ 物"
"ぶり 振り"
"ぶん 文 分"
"へい 兵"
"へき 癖 壁"
"へん 篇 編"
"べ 辺 部"
"べつ 別"
"べん 弁"
"ほ 舗 補"
"ほう 砲 法"
"ほうめん 方面"
"ほど 程"
"ほんい 本位"
"ぼ 簿"
"ぼう 帽 房 坊 某"
"ぼうし 防止"
"ぼく 木"
"ぼん 本"
"ま 魔 間"
"まい 枚"
"まえ 前"
"まち 町"
"まっき 末期"
"まつ 末"
"まで 迄"
"まる 丸"
"み 味"
"みすい 未遂"
"みん 民"
"むき 向き"
"むけ 向け"
"むひ 無比"
"むら 村"
"め 目"
"めい 名"
"めいぎ 名義"
"めん 面"
"もう 網"
"もく 目"
"もと 元"
"もの 者 物"
"もん 門 紋"
"や 野 屋"
"やく 薬 訳 役"
"やす 安"
"ゆ 油 湯"
"ゆえ 故"
"ゆき 行 行き"
"よ 余"
"よう 様 用"
"ようご 用語"
"ようひん 用品"
"よく 浴 翼 欲"
"よこ 横"
"よてい 予定"
"よぼう 予防"
"より 寄り"
"らい 来"
"らん 欄"
"り 理 吏 裏 裡"
"りつ 律 立 率"
"りゃく 略"
"りゅう 瘤 流"
"りょう 陵 領 量 料"
"りょく 力"
"るい 類"
"れい 令 例"
"れき 暦 歴"
"ろ 路 炉"
"ろう 郎"
"ろく 録"
"ろん 論"
"わ 羽"
"わき 脇"
"わく 枠"
"わざ 技"
"わん 湾"
)

;; Setting prefix entries.
(skkdic-set-prefix
"あ 亜"
"あい 愛 相"
"あお 青"
"あか 赤"
"あき 空き"
"あつ 厚"
"あの 彼の"
"あら 現 新 粗"
"ある 或る"
"あん 暗"
"い 居 伊 異"
"いき 活"
"いく 幾"
"いくさ 軍"
"いじょう 異常"
"いち 一"
"いちじ 一次 一時"
"いちだい 一大"
"いちばん 一番"
"いちぶ 一部"
"いっさい 一切"
"いっしゅ 一種"
"いっそう 一層"
"いったい 一体"
"いっぱん 一般"
"いふ 異父"
"いぼ 異母"
"いん 陰 印"
"う 右"
"うえ 上"
"うき 浮"
"うす 薄"
"うち 内"
"うら 裏"
"うわ 上"
"え 得"
"えい 嬰 英"
"えんか 塩化"
"お 牡 御"
"おうよう 応用"
"おお 大"
"おく 奥"
"おす 雄 牡"
"おそ 遅"
"おに 鬼"
"おもて 表"
"おや 親"
"おろし 卸"
"おん 御"
"か 加 過 可"
"かい 下位 怪 皆 改 開"
"かき 掻き"
"かく 斯く 角 核 各"
"かし 貸 華氏 貸し"
"かしょう 過小 過少"
"かせい 仮性"
"かそう 仮想"
"かた 片"
"かの 彼 彼の"
"かみ 上"
"から 唐 空"
"かり 仮"
"かん 韓 缶 環 完 間"
"かんい 簡易"
"かんせつ 間接"
"かんぜん 完全"
"がい 外"
"がいかく 外郭"
"がいとう 該当"
"がくせい 学生"
"き 着 奇 稀 希 黄 貴"
"きかん 季刊"
"きしょう 稀少 希少"
"きそ 基礎"
"きた 北"
"きゅう 九 急 旧"
"きょ 虚"
"きょう 共 京 強"
"きょうか 強化"
"きょうせい 強制"
"きょうどう 共同"
"きょうゆう 共有"
"きょく 曲"
"きょくしょ 局所"
"きん 筋 禁"
"きんし 禁止"
"きんじ 近似"
"きんだい 近代"
"ぎ 擬 偽 義"
"ぎじ 擬似 疑似"
"ぎゃく 逆"
"ぎょく 玉"
"く 区 九"
"くそ 糞"
"くろ 黒"
"ぐん 郡 軍"
"けい 経 軽 計"
"けいたい 携帯"
"けっこう 結構"
"けん 兼 嫌 県"
"けんりつ 県立"
"げき 激"
"げっかん 月刊"
"げん 元 減 原 現"
"げんかい 限界"
"げんこう 現行"
"げんし 原始"
"げんだい 現代"
"げんてい 限定"
"こ 孤 古 故 仔 子 小"
"こう 後 広 好 抗 公 高"
"こうかい 公開"
"こうき 後期"
"こうきゅう 高級"
"こうきょう 公共"
"こうしき 公式"
"こうしょう 公称"
"こうてき 公的"
"こうとう 高等"
"こうにん 公認"
"こうよう 公用"
"こうりつ 公立"
"こくさい 国際"
"こだい 古代"
"この 斯の 此の"
"これ 此れ 是 之"
"こん 今"
"ご 五 後 誤 御"
"ごう 豪"
"ごうか 豪華"
"ごうせい 合成"
"ごくごく 極々 極極"
"ごご 午後"
"ごぜん 午前"
"さ 左"
"さい 歳 最 再"
"さいきん 最近"
"さいこう 最高"
"さいさい 再々"
"さいしゅう 最終"
"さいしょう 最小"
"さいしん 最新"
"さいたん 最短"
"さいだい 最大"
"さいちょう 最長"
"さいてい 最低"
"さく 昨"
"さん 三"
"さんか 酸化"
"ざい 在"
"ざん 残"
"し 始 私"
"しじょう 史上"
"しせつ 私設"
"した 下"
"しち 七"
"してき 私的"
"しも 下"
"しゅ 主"
"しゅう 終 週 州"
"しゅうかん 週刊"
"しゅうし 終始"
"しゅうだん 集団"
"しゅく 祝"
"しゅせき 首席"
"しゅどう 手動"
"しゅよう 主要"
"しゆう 市有 私有"
"しょ 初 諸"
"しょう 正 少 省 小"
"しょうしょう 少々"
"しょうすう 少数"
"しょうみ 正味"
"しょかん 所管"
"しょき 初期"
"しょく 続"
"しょとう 初等"
"しら 白"
"しりつ 市立 私立"
"しろ 白"
"しん 親 真 新"
"しんき 新規"
"しんせい 真性"
"しんそこ 心底"
"しんにん 新任"
"じ 次"
"じあ 次亜"
"じか 直"
"じき 直"
"じこ 自己"
"じしゅ 自主"
"じしょう 自称"
"じせき 次席"
"じぜん 事前"
"じっこう 実効"
"じつ 実"
"じどう 自動"
"じゃく 弱"
"じゅ 従"
"じゅう 十 従 重"
"じゅうだい 重大"
"じゅん 准 順 純 準"
"じゅんすい 純粋"
"じゅんせい 純正"
"じゆう 自由"
"じょ 助"
"じょう 娘 上"
"じょうい 上位"
"じょうにん 常任"
"じょし 女子"
"じんこう 人工"
"じんぞう 人造"
"すいさんか 水酸化"
"すいてい 推定"
"すう 数"
"ずいぶん 随分"
"せい 性 西 製 静 成 聖 正"
"せいき 正規"
"せいよう 西洋"
"せっし 摂氏"
"せん 千 先"
"せんこう 先行"
"せんざい 潜在"
"せんしゅう 先週"
"せんよう 専用"
"ぜったい 絶対"
"ぜつ 絶"
"ぜん 全 前"
"ぜんえい 前衛"
"ぜんき 前期"
"ぜんこく 全国"
"そ 粗"
"そう 双 総"
"そうがく 総額"
"そうき 早期"
"そうご 相互"
"そうごう 総合"
"そうたい 相対"
"そうとう 相当"
"そく 即"
"そと 外"
"その 其の"
"それ 其れ"
"ぞう 贈 増"
"た 他 多"
"たい 耐 対"
"たいおう 対応"
"たいしょう 対象"
"たいそう 大層"
"たいてい 大抵"
"たいへん 大変"
"たいりょう 大量"
"たか 高"
"たじゅう 多重"
"たた 多々"
"ただ 唯"
"たて 縦"
"たぶん 多分"
"たん 淡 単 短"
"たんい 単位"
"たんき 短期"
"だ 駄"
"だい 大 第"
"だいたい 大体"
"だつ 脱"
"だん 断 団"
"だんし 男子"
"ちか 地下"
"ちく 築"
"ちち 父"
"ちゃ 茶"
"ちゅう 駐 中"
"ちゅうかん 中間"
"ちゅうき 中期"
"ちゅうしん 中心"
"ちょう 長 超"
"ちょうき 長期"
"ちょく 直"
"ちょくせつ 直接"
"ちょっけい 直径"
"ちん 珍"
"つうさん 通算"
"つき 月"
"てい 低"
"ていき 定期"
"ていきゅう 低級"
"てき 敵"
"てってい 徹底"
"でん 伝"
"でんき 電気"
"でんし 電子"
"でんどう 電動"
"と 渡 都"
"とう 等 東 当"
"とうがい 当該"
"とうよう 東洋"
"とくしゅ 特殊"
"とくべつ 特別"
"とこ 常"
"とび 飛び"
"とも 共"
"ど 度"
"どう 如何 道 動 同"
"どうじ 同時"
"どく 毒 独"
"どの 何の"
"ない 内"
"ないぞう 内蔵"
"なお 猶 尚"
"なか 中"
"なが 長"
"なな 七"
"なに 何"
"なま 生"
"なん 南 難 何"
"に 煮 二"
"にし 西"
"にじ 二次"
"にせ 偽"
"にち 日"
"にちじょう 日常"
"にっかん 日刊"
"にほん 日本"
"ね 寝"
"ねつ 熱"
"ねん 年"
"の 野"
"のう 濃"
"のべ 延 延べ"
"はい 灰"
"はち 八"
"はつ 初"
"はは 母"
"はや 早"
"はん 汎 半 反"
"はんけい 半径"
"ひ 干 乾 非 被"
"ひい 曾"
"ひかく 比較"
"ひかくてき 比較的"
"ひがし 東"
"ひじょう 非常"
"ひだり 左"
"ひっ 引っ"
"ひと 一"
"ひょうじゅん 標準"
"ひら 平"
"び 美 微"
"ふ 府 負 不"
"ふく 複 副"
"ふくごう 複合"
"ふじん 婦人"
"ふせい 不正"
"ふだん 普段"
"ふつ 仏"
"ふてん 付点"
"ふと 太"
"ふとう 不当"
"ふほう 不法"
"ふる 古"
"ぶっ 打っ"
"ぶん 分"
"へい 平 閉"
"へいほう 平方"
"へん 変"
"べい 米"
"べつ 別"
"ほう 邦 訪"
"ほく 北"
"ほそ 細"
"ほど 程"
"ほん 本"
"ぼう 某"
"ぼつ 没"
"ぼん 凡"
"ま 魔 真"
"まい 毎"
"まっき 末期"
"まま 継"
"まる 丸"
"まるまる 丸々"
"まん 満"
"み 見 御 未"
"みぎ 右"
"みなみ 南"
"む 無"
"むき 無機"
"むげん 無限"
"むじん 無人"
"むめい 無名"
"め 女 雌 牝"
"めい 明 名"
"めいもく 名目"
"めす 雌 牝"
"もう 猛"
"もと 元"
"もの 物"
"やかん 夜間"
"やく 約"
"やす 安"
"やみ 闇"
"やや 漸 稍"
"ゆう 有 優"
"ゆうき 有機"
"ゆうげん 有限"
"ゆうこう 有効"
"ゆうじん 有人"
"ゆうめい 有名"
"よ 夜 四"
"よう 幼 養 陽 洋 要"
"よく 翌"
"よこ 横"
"よん 四"
"らい 来"
"らん 乱"
"り 離"
"りっぽう 立方"
"りゃく 略"
"りゅうか 硫化"
"りょう 良 両"
"れい 冷"
"れつ 劣"
"れん 連"
"れんたい 連帯"
"ろ 露"
"ろう 老"
"ろく 六"
"わ 和"
"わか 若"
"わき 脇"
"わる 悪"
)

;; Setting okuri-nasi entries.
(skkdic-set-okuri-nasi
"ー 〜"
"あ 嗚 明 安 襾 哇 娃 椏 亞 唖 痾 婀 阿 彼 吾 亜"
"あーくとう アーク灯"
"あーくほうでん アーク放電"
"あーくようせつ アーク溶接"
"あーくろ アーク炉"
"あーけーどがい アーケード街"
"あーさーおう アーサー王"
"あーすせん アース線"
"あーちがた アーチ型"
"あーちきょう アーチ橋"
"あーとし アート紙"
"あーとてん アート展"
"あーべるぐん アーベル群"
"あーりあじん アーリア人"
"ああ あゝ 唖唖 噫 嗚呼"
"あい 饗 会 姶 穢 阨 藹 娃 隘 欸 噫 靉 瞹 曖 挨 埃 哀 亜衣 合 間 藍 相 愛"
"あいあい 靄靄 藹藹 相合 靄々 藹々"
"あいあいがさ 相合い傘 相合傘"
"あいいく 愛育"
"あいいそ 相磯"
"あいいろ 藍色"
"あいいん 合印 愛飲"
"あいうえおじゅん あいうえお順 アイウエオ順"
"あいうち 相撃ち 相討ち"
"あいうら 相浦"
"あいえ 藍絵"
"あいえき 愛液"
"あいえん 愛煙"
"あいえんきえん 合縁奇縁"
"あいおい 相生"
"あいか 哀歌"
"あいかぎ 合い鍵 合鍵"
"あいかた 合方 相方"
"あいかわ 合川 鮎川 愛川 相川"
"あいかわらず 相変わらず"
"あいかん 哀歓 哀感"
"あいが 相賀"
"あいがみ 藍紙 間紙"
"あいがも 間鴨 合鴨"
"あいがん 哀願 愛玩"
"あいがんけん 愛玩犬"
"あいき 愛機"
"あいきどう 合気道"
"あいきゃく 相客"
"あいきゅう 哀泣"
"あいきょう 愛郷 愛敬 愛嬌"
"あいきょうげん 間狂言"
"あいぎ 間着 合着"
"あいぎょう 愛楽 愛敬"
"あいぎん 愛吟"
"あいくち 合い口 合口 匕首"
"あいぐま 藍隈"
"あいけい 愛敬"
"あいけん 愛犬"
"あいこ アイ子 愛顧 藍子 愛子"
"あいこう 愛校 愛甲 愛好"
"あいこうだいめいでん 愛工大名電"
"あいこく 哀哭 愛国"
"あいことば 合い言葉 合言葉"
"あいこんか アイコン化"
"あいご 愛語 愛護"
"あいごま 合い駒 合駒"
"あいさい 愛妻"
"あいさつ 挨拶"
"あいさわ 相沢"
"あいざわ 会沢 相澤 相沢"
"あいし 愛子 哀詩 間紙 哀史"
"あいしーかーど ＩＣカード"
"あいしーたぐ ＩＣタグ"
"あいしかた 愛し方"
"あいしゃ 愛社 愛車"
"あいしゅう 愛執 哀愁"
"あいしょ 愛書"
"あいしょう 合性 愛誦 哀傷 愛妾 愛唱 愛称 相性"
"あいしんかくら 愛新覺羅 愛新覚羅"
"あいしんせいき アイシン精機"
"あいじ 愛児"
"あいじゃく 愛著"
"あいじょう 哀情 愛嬢 愛情"
"あいじん 愛人"
"あいすみちょう 愛住町"
"あいず 会津 相図 合図"
"あいずみ 藍住"
"あいせき 合席 哀惜 愛惜 相席"
"あいせつ 哀切"
"あいぜつ 哀絶"
"あいぜん 愛染"
"あいそ 愛相 相曽 相磯 哀訴 愛想"
"あいそう 愛想"
"あいそく 愛息"
"あいそづかし 愛想尽かし"
"あいそん 愛孫"
"あいぞう 愛蔵 愛憎"
"あいぞめ 藍染め"
"あいたい 靉靆 相対"
"あいたしゅぎ 愛他主義"
"あいだ 英田 合田 会田 藍田 愛田 相田 間"
"あいだい 愛大"
"あいだがら 間柄"
"あいだじゅう 間中"
"あいち 相知 愛知"
"あいちがくせんだい 愛知学泉大"
"あいちゃく 合着 愛着"
"あいちょう 愛重 哀調 愛鳥 愛聴"
"あいつ 彼奴"
"あいつぎ 相次"
"あいづ 会津"
"あいづき 相築"
"あいづち 相鎚 相づち 相槌"
"あいづま 逢妻"
"あいて 相手"
"あいとう 哀悼"
"あいどお 間遠"
"あいどく 愛読"
"あいなめ 鮎並 鮎魚女"
"あいにく 生憎"
"あいぬご アイヌ語"
"あいぬみんぞく アイヌ民族"
"あいねずみ 藍鼠"
"あいの 愛野"
"あいのこ 合いの子 間の子"
"あいのす 愛の巣"
"あいのて 合の手 合いの手 間の手"
"あいのむち 愛の鞭"
"あいは 愛葉"
"あいはら 合原 藍原 愛原 粟飯原 相原"
"あいはん 相判 合判"
"あいば 相場 相庭 饗場 相羽 愛馬"
"あいばら 合原 相原"
"あいびき 合い引き 合挽 合挽き 逢い引き 逢引"
"あいびょう 愛猫"
"あいぴーでんわ ＩＰ電話"
"あいふ 合符"
"あいふく 合服 間服"
"あいふだ 合札"
"あいぶ 愛撫"
"あいべ 相部"
"あいべつ 哀別 愛別"
"あいぼ 愛慕"
"あいぼう 相棒"
"あいぼし 相星"
"あいぼれ 相惚れ"
"あいま 合い間 合間"
"あいまい 曖昧"
"あいまいやど 曖昧宿"
"あいまって 相俟って"
"あいみ 亜衣実 愛美"
"あいみたがい 相身互い"
"あいみつもり 合い見積もり"
"あいみるちゃ 藍海松茶"
"あいもと 相本"
"あいもん 合文"
"あいやく 相役"
"あいやど 相宿"
"あいやぶし あいや節"
"あいやま 相山"
"あいよう 愛用"
"あいよく 愛慾 愛欲"
"あいよし 相吉"
"あいら 吾平 姶良"
"あいらく 哀楽"
"あいり 愛里"
"あいりん 愛輪"
"あいるらんど 愛蘭"
"あいれん 愛憐 哀憐 愛恋"
"あいろ 文色 隘路"
"あいろんだい アイロン台"
"あいわ 哀話"
"あう 櫻 媼 奧 桜 奥 央"
"あうん 阿吽"
"あえ 阿江"
"あえぎ 喘ぎ"
"あえて 敢えて"
"あえば 饗庭"
"あえもの 韲え物 和え物"
"あえり 愛絵理"
"あえん 亜鉛"
"あえんか 亜鉛華"
"あお 碧 蒼 青"
"あおあお 蒼々 蒼蒼 青青 青々"
"あおあざ 青アザ 青痣"
"あおあらし 青嵐"
"あおい 碧 青井 葵"
"あおいきといき 青息吐息"
"あおいけ 青池"
"あおいし 青石"
"あおいとり 青い鳥"
"あおいのうえ 葵の上 葵上"
"あおいはな 青い花"
"あおいまつり 葵祭"
"あおいめ 青い目"
"あおいもく アオイ目"
"あおいもん 葵紋"
"あおいろ 青色"
"あおうま 青馬 白馬"
"あおえ 青絵 青江"
"あおおに 青鬼"
"あおかち 青褐"
"あおかび 青かび 青カビ 青黴"
"あおかん 青かん 青姦"
"あおがい 青貝"
"あおがえる 青蛙"
"あおがき 青垣"
"あおがく 青山学院大学 青学"
"あおがしま 青ヶ島"
"あおがり 青刈り"
"あおき 青木"
"あおきいさお 青木功"
"あおきがはら 青木ヶ原"
"あおきこ 青木湖"
"あおきん 青金"
"あおぎいろ 青黄色"
"あおぎり 榮 青桐"
"あおくさ 青草"
"あおくび 青首"
"あおげ 青毛"
"あおこーなー 青コーナー"
"あおさ 石蓴"
"あおさぎ 青鷺"
"あおさび 青錆"
"あおさぶらい 青侍"
"あおざかな 青魚"
"あおざむらい 青侍"
"あおしお 青潮"
"あおしか 青鹿"
"あおしま 青嶋 青島"
"あおじ 青地"
"あおじそ 青ジソ 青紫蘇"
"あおじゃしん 青写真"
"あおじる 青汁"
"あおすじ 青筋"
"あおせざかな 青背魚"
"あおせん 青線"
"あおそ 青苧 青麻"
"あおぞら 蒼空 青空"
"あおた 青田"
"あおたがり 青田刈 青田刈り"
"あおたけ 青竹"
"あおたん 青丹 青痰 青短"
"あおだけ 青竹"
"あおだたみ 青畳"
"あおだま 青玉"
"あおち 青地"
"あおちゃ 青茶"
"あおと 青戸 青砥"
"あおな 青菜"
"あおなし 青梨"
"あおに 青丹 青二"
"あおにび 青鈍"
"あおぬま 青沼"
"あおね 青嶺"
"あおねおんせん 青根温泉"
"あおねぎ 青ネギ 青葱"
"あおねこ 青猫"
"あおの 青野"
"あおはた 青旗"
"あおば 青葉"
"あおばえ 青蠅"
"あおばどおり 青葉通"
"あおばん 青盤 青版"
"あおひげ 青髯 青髭"
"あおひょう 青票"
"あおびかり 青光り"
"あおびょうし 青標紙"
"あおぶさ 青房"
"あおほん 青本"
"あおまめ 青豆"
"あおみ 青身 青み"
"あおみどり 青緑"
"あおみどろ 水綿 青味泥"
"あおむぎ 青麦"
"あおむけ 仰向け"
"あおむし 青虫"
"あおむらさき 青紫"
"あおめ 青眼"
"あおもと 青本"
"あおもの 青物"
"あおもり 青森"
"あおもん 青門"
"あおや 青屋 青谷"
"あおやき 青焼"
"あおやぎ 青柳"
"あおやなぎ 青柳"
"あおやま 青山"
"あおり 煽り"
"あか 絳 淦 閼伽 亜科 垢 赤"
"あかあお 赤青"
"あかあか 明々 赤々"
"あかあざ 赤痣"
"あかあり 赤蟻"
"あかい 赤井"
"あかいえか 赤家蚊"
"あかいくつ 赤い靴"
"あかいけ 赤池"
"あかいし 赤石"
"あかいぬ 赤犬"
"あかいはね 赤い羽根"
"あかいろ 赤色"
"あかいわ 赤磐 赤岩"
"あかいわし 赤鰯"
"あかうお 赤魚"
"あかうま 赤馬"
"あかえ 赤絵"
"あかえだ 赤枝"
"あかえび 赤蝦"
"あかお 赤尾"
"あかおか 赤岡"
"あかおすぎ 赤尾杉"
"あかおに 赤鬼"
"あかおまな 赤御魚"
"あかかげ 赤影"
"あかかぶ 赤蕪"
"あかがい 赤貝"
"あかがしら 赤頭"
"あかがね 銅"
"あかがねいろ 銅色"
"あかがみ 赤紙"
"あかがり 赤狩 赤狩り"
"あかがわ 赤川"
"あかきゃべつ 赤キャベツ"
"あかぎ 赤木 赤城"
"あかぎいろ 赤黄色"
"あかぎつね 赤狐"
"あかぎぬ 赤衣"
"あかぎれ 皹 皸"
"あかくら 赤倉"
"あかくろ 赤黒"
"あかぐつ 赤靴"
"あかぐま 赤熊"
"あかぐみ 赤組 紅組"
"あかげ 赤毛"
"あかげら 赤啄木鳥"
"あかげわしゅ 褐毛和種"
"あかこーなー 赤コーナー"
"あかご 赤児 赤子"
"あかごめ 赤米"
"あかさか 赤坂"
"あかさき 赤碕 赤崎"
"あかさび 赤錆"
"あかざ 藜"
"あかざか アカザ科"
"あかざかな 赤魚"
"あかざき 赤崎"
"あかざとう 赤砂糖"
"あかざわ 赤澤 赤沢"
"あかざん 赤残"
"あかし 絳し 証し 赤司 證 灯 証 明石"
"あかしお 赤潮"
"あかしな 明科"
"あかしば 赤芝"
"あかしま 暴"
"あかしや 明石家"
"あかしやき 明石焼"
"あかしろ 赤白"
"あかじ 赤地 赤字"
"あかじそ 赤紫蘇"
"あかすり 垢擦り"
"あかず 赤酢"
"あかずのま 開かずの間"
"あかせがわげんぺい 赤瀬川原平"
"あかせん 赤線"
"あかぞめえもん 赤染衛門"
"あかたにせん 赤谷線"
"あかたん 赤丹 赤短"
"あかだな 閼伽棚"
"あかだま 赤玉"
"あかだまつち 赤玉土"
"あかちゃ 赤茶"
"あかちゃん 赤ちゃん"
"あかちん 赤チン"
"あかっぱじ 赤っ恥"
"あかつか 赤塚"
"あかつき 曉 閼伽坏 垢付き 暁"
"あかつきがた 暁方"
"あかつきづくよ 暁月夜"
"あかつきやみ 暁闇"
"あかつち 赭土 赭 赤土"
"あかつつみ 赤堤"
"あかてん 赤点"
"あかでみーしょう アカデミー賞"
"あかでん 赤電"
"あかとき 暁"
"あかときづくよ 暁月夜"
"あかとんぼ 赤とんぼ"
"あかどう 赤胴"
"あかどまり 赤泊"
"あかな 赤名"
"あかに 赤丹"
"あかにし 赤螺"
"あかぬけ 垢抜け"
"あかぬま 赤沼"
"あかね 朱子 茜"
"あかねいろ 茜色"
"あかねか アカネ科"
"あかねぐも 茜雲"
"あかねこ 赤猫"
"あかねさす 茜さす"
"あかねもく アカネ目"
"あかのたにん 赤の他人"
"あかのひろば 赤の広場"
"あかはじ 赤恥"
"あかはた 旃 赤旗"
"あかはだ 赤肌 赤膚"
"あかはだか 赤裸"
"あかはな 赤鼻"
"あかはに 赤埴"
"あかはね 赤羽"
"あかはら 赤腹"
"あかばこ 赤箱"
"あかばな 赤花"
"あかばね 赤羽"
"あかばん 赤盤"
"あかひげ 赤髭"
"あかひと 赤人"
"あかひら 赤平"
"あかびら 赤平"
"あかぴーまん 赤ピーマン"
"あかふく 赤福"
"あかふくもち 赤福餅"
"あかふだ 赤札"
"あかぶさ 赤房"
"あかぺん 赤ペン"
"あかほ 赤穂"
"あかほり 赤堀"
"あかほん 赤本"
"あかぼう 赤帽"
"あかぼし 明星 赤星"
"あかぼり 赤堀"
"あかま 赤間"
"あかまい 赤米"
"あかまつ 赤松"
"あかまど 赤窓"
"あかまる 赤丸"
"あかまんま 赤飯"
"あかみ 赤み 赤身"
"あかみず 閼伽水 赤水"
"あかみそ 赤みそ"
"あかみどり 赤緑"
"あかむし 赤虫"
"あかむらさき 赤紫"
"あかめ 赤目"
"あかめいも 赤芽芋"
"あかめがしわ 赤芽柏"
"あかもん 赤門"
"あかゆ 赤湯"
"あかゆき 赤雪"
"あから 赤ら"
"あからく 赤楽"
"あからしま 暴"
"あからんぷ 赤ランプ"
"あかり 燈 明り 灯 灯り 明かり"
"あかりまど 明り窓 明かり窓"
"あかるみ 明るみ"
"あかれんが 赤レンガ"
"あかわいん 赤ワイン"
"あかん 阿寒"
"あかんこ 阿寒湖"
"あかんぼう 赤ん坊"
"あがおか 阿賀岡"
"あがた 県"
"あがつま 我妻 吾妻"
"あがない 贖 贖い"
"あがの 阿賀野"
"あがほ 英賀保"
"あがり 上り 上がり"
"あがりかまち 上がり框"
"あがりがまち 上がり框"
"あがりしょう 上がり性"
"あがりた 揚田"
"あがわ 吾川 阿川"
"あき 朖 晰 晢 龝 穐 晶紀 晄 璋 安岐 彬 顕 朗 彰 哲 亮 晃 暁 昭 晶 章 明 光 亜樹 亜季 亜紀 亜希 空き 空 安芸 秋"
"あきあかね 秋茜"
"あきあき 厭き厭き 飽き飽き"
"あきあじ 秋味"
"あきいこう 秋以降"
"あきう 秋保"
"あきうみ 明生"
"あきえ 亜紀恵 晃枝 秋絵 昭江 秋江 章江 明恵"
"あきお 彬生 明央 晃夫 亜希夫 晶夫 秋雄 秋男 秋夫 暁生 彰夫 明雄 明男 昭男 章夫 昭雄 明夫 昭夫"
"あきおか 秋岡"
"あきおみ 明臣"
"あきかず 彰一"
"あきかぜ 秋風"
"あきかわ 秋川"
"あきかん 空き罐 空缶"
"あきがせ 秋ケ瀬"
"あきがわ 秋川"
"あきぎり 秋霧"
"あきぐち 秋口"
"あきけいば 秋競馬"
"あきげしき 秋景色"
"あきこ 亜以子 朱子 亜樹子 亜季子 朗子 顕子 彰子 暁子 昭子 章子 晃子 明子 晶子 亜希子"
"あきごう 秋号"
"あきごえ 秋肥"
"あきごろ 秋頃"
"あきさと 穐里"
"あきさば 秋鯖"
"あきさめ 秋雨"
"あきさわ 秋澤"
"あきざくら 秋桜"
"あきしぐれ 秋時雨"
"あきしの 秋篠"
"あきしのでら 秋篠寺"
"あきしののみや 秋篠宮"
"あきしま 安芸島 昭島"
"あきしょう 飽き性"
"あきしょせん 秋初戦"
"あきじかん 空時間"
"あきす 空巣 空き巣"
"あきすえ 秋末"
"あきぞら 秋空"
"あきた 飽田 秋田"
"あきたいぬ 秋田犬"
"あきたけん 秋田犬"
"あきたに 秋谷"
"あきだい 秋大"
"あきち 空地"
"あきつ 安芸津 蜻蛉 秋津"
"あきつぐ 明二"
"あきつしま 秋津島"
"あきづき 秋月"
"あきと 彰人"
"あきとし 秋利 晃年 明敏 彰俊"
"あきとも 秋友"
"あきな 明菜"
"あきない 商い"
"あきなが 秋永"
"あきなぎ 秋奈祇"
"あきなす 秋茄子"
"あきなり 章成 秋成"
"あきなる 秋成"
"あきの 昭乃 秋野"
"あきのこえ 秋の声"
"あきのそら 秋の空"
"あきのひ 秋の日"
"あきのよ 秋の夜"
"あきのよのながものがたり 秋夜長物語"
"あきのり 晧則 晃紀 彰則 昭徳 明紀 昭則 昭憲 明憲 明徳"
"あきは 秋葉"
"あきはばら 秋葉原"
"あきば 秋庭 秋場 秋葉"
"あきばけい アキバ系"
"あきばこ 空箱"
"あきばれ 秋晴 秋晴れ"
"あきひこ 祥彦 晶彦 暁彦 秋彦 彰彦 昭彦 明彦"
"あきひさ 顕尚 彰久"
"あきひで 彰英"
"あきひと 祥仁 明仁 昭仁"
"あきひろ 碩宏 哲裕 彰広 暁宏 章広 晃広 晃宏 明裕 章浩 章裕 昭浩 明大 昭弘 章博 明浩 明広 章弘 晃弘 昭博 章宏 彰宏 明弘 昭宏 明宏"
"あきびえ 秋冷え"
"あきびより 秋日和"
"あきびん 空ビン 空瓶"
"あきふく 秋服"
"あきふみ 晶文 章文 明文"
"あきふゆ 秋冬"
"あきぶもん 空部門"
"あきべや 空部屋"
"あきほ 秋保 秋穂 明穂"
"あきま 秋間"
"あきまき 秋蒔き"
"あきまつり 秋祭 秋祭り"
"あきまで 秋迄"
"あきまる 秋丸"
"あきみ 秋生"
"あきみず 秋水"
"あきみち 明倫"
"あきみつ 章充 彬光"
"あきむら 秋村"
"あきめ 秋芽"
"あきめくら 明き盲"
"あきもと 秋本 秋元"
"あきもの 秋物"
"あきものがたり 秋物語"
"あきもよう 秋模様"
"あきや 明き家 空屋 空き家 空家"
"あきやさい 秋野菜"
"あきやしき 空屋敷"
"あきやす 彰康"
"あきやすみ 秋休み"
"あきやま 秋山"
"あきゅーせいでん 阿Ｑ正伝"
"あきゅう 秋保"
"あきゆき 昭如"
"あきょう 阿嬌 阿膠"
"あきよ 晃代 明代"
"あきようりょう 空容量"
"あきよし 彰芳 明吉 昭良 明良 昭義 秋吉"
"あきよしどう 秋芳洞"
"あきら 朖 昜 晄 璋 滉 顯 晧 曉 日明 洸 彬 亨 顕 旭 鑑 啓 朗 聡 亮 暁 彰 晃 昭 陽 晶 輝 章 明 光"
"あきらか 昿 曠 明か 明らか"
"あきらめ 諦め"
"あきりすと 空きリスト"
"あきりょういき 空領域"
"あきれ 呆れ"
"あきれがお あきれ顔"
"あきれすけん アキレス腱"
"あきんど 商人"
"あきんどやど 商人宿"
"あぎ 顎 吾君 阿魏 亜木 阿木"
"あぎと 顎門 鰓 顎"
"あぎなし 顎無し"
"あぎに 阿耆尼"
"あぎょう あ行 ア行"
"あく 空 惡 堊 齷 軛 阿久 渥 幄 握 灰汁 悪"
"あくあらい 灰汁洗い"
"あくい 阿久井 悪意"
"あくいん 悪因"
"あくいんあっか 悪因悪果"
"あくいんしょう 悪印象"
"あくうん 悪運"
"あくえいきょう 悪影響"
"あくえき 悪疫"
"あくえきしつ 悪液質"
"あくえん 悪縁"
"あくかんきょう 悪環境"
"あくかんじょう 悪感情"
"あくぎ 悪戯"
"あくぎゃく 悪虐 悪逆"
"あくぎょう 悪業 悪行"
"あくげんた 悪源太"
"あくこうか 悪効果"
"あくごう 悪業"
"あくさい 悪才 悪妻"
"あくさく 齷齪"
"あくざいりょう 悪材料"
"あくしつ 悪疾 悪質"
"あくしゃ 幄舎"
"あくしゅ 悪趣 悪手 握手"
"あくしゅう 悪習 悪臭"
"あくしょ 悪所 悪書"
"あくしょう 悪性"
"あくしん 悪心"
"あくじ 悪事"
"あくじき 悪食"
"あくじゅんかん 悪循環"
"あくじょ 悪女"
"あくじょう 悪尉"
"あくじょうけん 悪条件"
"あくせい 悪声 悪政 悪性"
"あくせく 齷齪"
"あくせすかいせき アクセス解析"
"あくせすけん アクセス権"
"あくせすじょうきょう アクセス状況"
"あくせすすう アクセス数"
"あくせん 悪戦 悪銭"
"あくせんときごう アクセント記号"
"あくぜい 悪税"
"あくそう 悪僧 悪相"
"あくそうきゅう 悪送球"
"あくた 芥"
"あくたい 悪態"
"あくたがわ 芥川"
"あくたれ 悪たれ"
"あくたろう 悪太郎"
"あくだいかん 悪代官"
"あくだま 悪玉"
"あくだまこれすてろーる 悪玉コレステロール"
"あくち 悪血"
"あくちしき 悪知識"
"あくちにうむけいれつ アクチニウム系列"
"あくつ 圷 阿久津"
"あくてん 悪天"
"あくてんこう 悪天候"
"あくと 悪徒 踵"
"あくとう 悪投 悪党"
"あくとく 悪徳"
"あくどう 悪道 悪童"
"あくなき 飽くなき"
"あくにち 悪日"
"あくにん 悪人"
"あくね 阿久根"
"あくねん 悪念"
"あくねんぴ 悪燃費"
"あくのはな 悪の華"
"あくはつとほ 握髪吐哺"
"あくば 悪罵"
"あくひつ 悪筆"
"あくひょう 悪評"
"あくび 欠 悪日 欠伸"
"あくびょう 悪病"
"あくびょうどう 悪平等"
"あくふ 握斧"
"あくふう 悪風"
"あくぶん 悪文"
"あくへい 悪弊"
"あくへき 悪癖"
"あくへん 悪変"
"あくほう 悪報 悪法"
"あくぼくとうせん 悪木盗泉"
"あくま 悪魔"
"あくまで 飽く迄"
"あくみ 飽海"
"あくみょう 悪名"
"あくむ 悪夢"
"あくめい 悪名"
"あくもん 悪問"
"あくやく 悪役"
"あくゆう 阿久悠 悪友"
"あくよう 悪用"
"あくらつ 悪辣"
"あくりゅう 悪竜"
"あくりょう 悪霊"
"あくりょく 握力"
"あくりるえのぐ アクリル絵具 アクリル絵の具"
"あくりるじゅし アクリル樹脂"
"あくりるせい アクリル製"
"あくる 明くる"
"あくるあさ 明くる朝"
"あくるひ 明くる日"
"あくれい 悪例"
"あくろ 悪路"
"あぐい 安食 安居院 阿久比"
"あぐさ 阿草"
"あぐに 粟国"
"あぐら 趺坐 胡床 胡坐 胡座"
"あぐらなべ 安愚楽鍋"
"あぐり 亜久里"
"あぐん 亜群"
"あけ 明 曉 暁 明け 朱"
"あけお 暁生"
"あけがらす 明烏"
"あけこ 朱子"
"あけしめ 開け閉め"
"あけすけ 明け透け"
"あけたて 開け閉て"
"あけち 明智"
"あけちこごろう 明智小五郎"
"あけっぴろげ 開けっ広げ"
"あけに 明荷"
"あけの 明野"
"あけのみょうじょう 明けの明星"
"あけはま 明浜"
"あけび 通草 木通"
"あけびか アケビ科"
"あけぼの 曙"
"あけぼのいろ 曙色"
"あけぼのばし 曙橋"
"あけみ 明珠 明海 朱実 暁美 朱美 明美"
"あげ 安芸 上 揚 揚げ 上げ"
"あげあし 挙足 揚足 挙げ足 上足 上げ足 揚げ足"
"あげあぶら 揚げ油"
"あげいた 上げ板"
"あげお 上尾"
"あげかじ 上げ舵"
"あげぎょうざ 揚餃子"
"あげく 揚句 挙げ句 挙句"
"あげくだし 上げ下し"
"あげくのはて 挙げ句の果て 挙句の果て"
"あげしお 上潮 上げ潮"
"あげぞこ 上底 上げ底"
"あげだい 揚代"
"あげだし 揚出し"
"あげだま 揚玉 揚げ玉"
"あげち 揚地 上地"
"あげつらい 論い"
"あげど 揚戸 揚げ戸"
"あげどうふ 揚豆腐"
"あげなべ 揚げ鍋"
"あげの 揚野"
"あげは 揚羽"
"あげはちょう 揚羽蝶"
"あげはま 揚げ浜 揚浜"
"あげば 揚場"
"あげばり 幄"
"あげぱん 揚げパン"
"あげぶた 上げ蓋"
"あげまい 上米"
"あげまき 総角 揚巻"
"あげまつ 上松"
"あげもち 揚げ餅"
"あげや 揚屋"
"あこ 亜子 彼所 亜古 吾子"
"あこう 赤魚 亜綱 赤穂"
"あこうだい 阿候鯛 赤魚鯛"
"あこがれ 憬れ 憧れ"
"あこぎ 阿漕"
"あこそ 阿古曾 阿古曽"
"あこめ 袙 衵"
"あこや 阿古屋"
"あこやがい 阿古屋貝"
"あご 飛魚 阿児 顎"
"あごひげ 鬚 顎鬚"
"あごひも 顎紐"
"あごわん 英虞湾"
"あさ 淺 安佐 厚狭 阿佐 晨 浅 麻 朝"
"あさあめ 朝雨"
"あさい 淺井 朝井 浅井"
"あさいち 朝イチ 朝一 朝市"
"あさいと 麻絲 麻糸"
"あさいり 浅炒り 浅煎り"
"あさえだ 浅枝 朝枝"
"あさお 朝雄 浅尾 麻生"
"あさおか 浅丘 麻丘 朝岡 朝丘"
"あさおき 朝起き"
"あさおり 麻織"
"あさか 朝加 浅香 安積 朝霞"
"あさかげ 朝影"
"あさかぜ 朝風"
"あさかのみや 朝香宮"
"あさかわ 朝川 浅川"
"あさが 朝賀 浅賀"
"あさがえり 朝帰り"
"あさがお 蕣 朝顔"
"あさがけ 朝駆"
"あさがすみ 朝霞"
"あさがた 朝型 朝方"
"あさがみ 麻上"
"あさがや 阿佐谷 阿佐ヶ谷"
"あさき 麻木"
"あさきた 安佐北"
"あさぎ 浅木 麻木 浅黄 浅葱"
"あさぎぬ 麻衣"
"あさぎり 朝霧"
"あさくさ 浅草"
"あさくち 浅口"
"あさくら 麻倉 浅倉 朝倉"
"あさぐつ 浅沓"
"あさけ 朝明"
"あさげ 朝餉"
"あさげいこ 朝稽古"
"あさこ 亜抄子 あさ子 浅子 朝子 麻子"
"あさご 朝来"
"あさごはん 朝ごはん 朝ご飯 朝御飯"
"あさざけ 朝酒"
"あさしお 朝潮"
"あさしな 浅科"
"あさしも 朝霜"
"あさしゃん 朝シャン"
"あさしろ 麻城"
"あさじ 朝事 浅茅 朝地"
"あさじう 浅茅生"
"あさじうの 浅茅生の"
"あさじえ 浅知恵"
"あさすおう 浅蘇芳"
"あさせ 浅瀬"
"あさぞら 朝空"
"あさだ 阿佐田 朝田 麻田 浅田"
"あさだあきら 浅田彰"
"あさだあめ 浅田飴"
"あさだき 浅炊き"
"あさだち 朝立ち"
"あさぢ 浅茅"
"あさぢえ 浅知恵"
"あさって 明後日"
"あさっぱら 朝っ腹 朝っぱら"
"あさつき 胡葱 浅葱"
"あさつゆ 朝露"
"あさづきよ 朝月夜"
"あさづくよ 朝月夜"
"あさづけ 浅漬け 浅漬"
"あさづま 朝妻"
"あさてい 朝定"
"あさで 浅傷 浅手 朝出"
"あさと 麻人 朝戸"
"あさどやゆんた 安里屋ユンタ"
"あさどら 朝ドラ"
"あさなぎ 朝凪"
"あさなべ 浅鍋"
"あさなゆうな 朝な夕な"
"あさなわ 麻縄"
"あさぬの 麻布"
"あさぬま 浅沼"
"あさね 朝寝"
"あさの 浅野"
"あさのは 麻の葉"
"あさのぶ 朝信"
"あさのみ 麻の実"
"あさはか 浅はか"
"あさはなだ 浅縹"
"あさはやく 朝早く"
"あさはら 麻原 浅原"
"あさば 浅羽 浅場"
"あさばん 朝晩"
"あさひ 朝陽 旭 朝日"
"あさひかせい 旭化成"
"あさひかわ 旭川"
"あさひがおか 旭が丘 旭ケ丘 旭ヶ丘"
"あさひがらす 旭硝子"
"あさひがわ 旭川"
"あさひぎんこう あさひ銀行"
"あさひく 旭区"
"あさひこうよう 朝日航洋"
"あさひそのらま 朝日ソノラマ"
"あさひだい 旭台"
"あさひだけ 旭岳"
"あさひつうしんしゃ 旭通信社"
"あさひな 朝日奈 朝比奈"
"あさひなたかし 朝比奈隆"
"あさひまち 旭町"
"あさひや 旭屋"
"あさひる 朝昼"
"あさびん 朝便"
"あさふく 浅福"
"あさぶ 麻布 麻生"
"あさぶき 麻吹"
"あさぶくろ 麻袋"
"あさぶろ 朝風呂"
"あさほうそう 朝放送"
"あさぼらけ 朝ぼらけ"
"あさま 朝間 浅間"
"あさまつ 朝松"
"あさみ 亜左美 朝美 麻見 亜沙美 浅見 あさ美 麻美"
"あさみぞ 麻溝"
"あさみどり 浅緑"
"あさみなみ 安佐南"
"あさみや 麻宮 朝宮"
"あさむし 浅蒸し 浅虫"
"あさむらさき 浅紫"
"あさめし 朝メシ 朝飯"
"あさもや 朝靄"
"あさやけ 朝焼け"
"あさやま 浅山 朝山"
"あさゆ 朝湯"
"あさゆう 朝夕"
"あさり 漁り 鯏 蜊 朝里 浅利 浅蜊"
"あさりじる アサリ汁 あさり汁"
"あされん 朝練"
"あざ 黶 痣 字"
"あざい 浅井"
"あざな 字名 字"
"あざぶ 麻布"
"あざみ 薊"
"あざみうま 薊馬"
"あざやか 鮮か 鮮やか"
"あざらし 海豹"
"あざわらい 嘲笑い"
"あし 悪し 蘆 葭 葦 芦 脚 足"
"あしあと 足跡"
"あしいろ 足色"
"あしうら 足裏"
"あしお 足尾"
"あしおざん 足尾山"
"あしおと 脚音 跫 足音"
"あしおり 足折"
"あしか 葦鹿 海驢"
"あしかが 足利"
"あしかがうじみつ 足利氏満"
"あしかがしげうじ 足利成氏"
"あしかがただふゆ 足利直冬"
"あしかがただよし 足利直義"
"あしかがまさとも 足利政知"
"あしかがもちうじ 足利持氏"
"あしかがもとうじ 足利基氏"
"あしかがよしあきら 足利義詮"
"あしかがよしかず 足利義量"
"あしかがよしずみ 足利義澄"
"あしかがよしたね 足利義稙"
"あしかがよしてる 足利義輝"
"あしかがよしのり 足利義教"
"あしかがよしひさ 足利義尚"
"あしかがよしひで 足利義栄"
"あしかがよしまさ 足利義政"
"あしかがよしみ 足利義視"
"あしかがよしみつ 足利義満"
"あしかがよしもち 足利義持"
"あしかけ 足掛 足掛け"
"あしかせ 鐐 桎 足枷"
"あしからず 悪しからず"
"あしかり 芦刈"
"あしかわ 芦川"
"あしがかり 足がかり 足掛り 足掛かり"
"あしがた 足形 足型"
"あしがため 足固め"
"あしがなえ 足鼎"
"あしがら 足柄"
"あしがらかみ 足柄上"
"あしがらしも 足柄下"
"あしがらみ 足搦み"
"あしがる 足軽"
"あしがわ 芦川"
"あしき 悪しき"
"あしきしゅうきゅう ア式蹴球"
"あしきた 葦北 芦北"
"あしきょう 芦響"
"あしきり 足切り"
"あしくせ 足癖"
"あしくび 足首"
"あしぐみ 足組み"
"あしげ 葦毛 足蹴 芦毛"
"あしげい 足芸"
"あしこぎ 足漕ぎ"
"あしこし 脚腰 足腰"
"あしごしらえ 足拵え"
"あしさき 脚先 足先"
"あしさばき 足捌き"
"あしざわ 芦澤 芦沢"
"あしざわり 足触り"
"あししげく 足繁く"
"あししろ 足代"
"あしずもう 足相撲"
"あしずり 足摺"
"あしずりみさき 足摺岬"
"あしそこ 足底"
"あしぞこばん 足底板"
"あした 晨 朝 明日"
"あしたか 愛鷹"
"あしたば 鹹草 明日葉"
"あしだ 芦田"
"あしだい 足代"
"あしだひとし 芦田均"
"あしつき 足付き 足付"
"あしつぎ 足継ぎ"
"あしづかい 足遣い"
"あしづけ 足付"
"あしてまとい 足手纏い"
"あしで 葦手 足手"
"あしでまとい 足手纏い"
"あしとり 足取り"
"あしどめ 足留め 足止 足止め"
"あしどり 足鳥 足取り"
"あしな 芦品 蘆名 足名 芦名"
"あしなえ 蹇 跛"
"あしなが 足長"
"あしなみ 足並 足並み"
"あしならし 足慣らし"
"あしぬけ 足抜け"
"あしのこ 芦ノ湖"
"あしのこう 足の甲"
"あしはこび 足運び"
"あしはら 蘆原 葦原 芦原"
"あしはらのなかつくに 葦原の中つ国"
"あしば 足場"
"あしばや 足早"
"あしばらい 足払い"
"あしひきの 足引きの"
"あしび 馬酔木"
"あしびょうし 足拍子"
"あしふき 足拭き"
"あしぶえ 葦笛"
"あしぶね 葦船 葦舟"
"あしぶみ 足踏 足踏み"
"あしへん 足偏"
"あしべ 芦部 芦辺"
"あしべつ 芦別"
"あしぼね 足骨"
"あしまえ 足前"
"あしまかせ 足任せ"
"あしまわり 足回り"
"あしめ 走目"
"あしもと 脚元 足許 足下 足元"
"あしもの 脚物"
"あしもり 足守"
"あしゃ 唖者"
"あしや 芦谷 芦屋"
"あしやす 芦安"
"あしやすめ 足休め"
"あしゅ 亜種"
"あしゅう 阿州"
"あしゅら 阿修羅"
"あしゆ 脚湯 足湯"
"あしゆび 趾 足指"
"あしょろ 足寄"
"あしよわ 足弱"
"あしろ 安代"
"あしわざ 足業 足技"
"あしわだ 足和田"
"あしわら 葦原"
"あじ 庵治 鰺 鯵 味"
"あじあ 亞細亞 亜細亜"
"あじあかいはつぎんこう アジア開発銀行"
"あじあかっこく アジア各国"
"あじあけい アジア系"
"あじあしょこく アジア諸国"
"あじあじん アジア人"
"あじあぞう アジア象"
"あじあたいかい アジア大会"
"あじあてき アジア的"
"あじおう 味皇"
"あじおか 味岡"
"あじおんち 味オンチ 味音痴"
"あじか 簣"
"あじから 味方"
"あじがさわ 鯵ヶ沢"
"あじがわ 安治川"
"あじき 味気"
"あじきこう 味紀行"
"あじけ 味気"
"あじけない 味気ない"
"あじさい 紫陽花"
"あじさか 鯵坂"
"あじじまん 味自慢"
"あじす 阿知須"
"あじそんびょう アジソン病"
"あじつけ 味付 味付け"
"あじとみ 安次富"
"あじどころ 味処"
"あじな 芦品 阿品"
"あじのもと 味の素"
"あじふめい 味不明"
"あじま 安島"
"あじみ 味見"
"あじむ 安心院"
"あじゃら 戯"
"あじゃり 阿闍梨"
"あじろ 安代 足代 網代"
"あじわい 味わい"
"あす 明日"
"あすか 飛鳥 明日香"
"あすかい 飛鳥井"
"あすかでら 飛鳥寺"
"あすけ 足助"
"あすけかんちゃ 足助寒茶"
"あすこ 彼所"
"あすこるびんさん アスコルビン酸"
"あすぢゅう 明日中"
"あすてかぶんめい アステカ文明"
"あすなろ 翌檜"
"あすぱらぎんさん アスパラギン酸"
"あすぺくとひ アスペクト比"
"あすら 阿修羅"
"あすわ 足羽"
"あずかり 預り 預かり"
"あずき 小豆"
"あずきがゆ 小豆粥"
"あずきもち 小豆餅"
"あずけ 預け"
"あずけあい 預合"
"あずさ 梓"
"あずさがわ 梓川"
"あずさみこ 梓巫女"
"あずさゆみ 梓弓"
"あずち 堋 安土"
"あずま 東 吾嬬 吾妻"
"あずまあそび 東遊 東遊び"
"あずまおとこ 東男"
"あずまかがみ 東鑑 吾妻鏡"
"あずまくだり 東下り"
"あずまことば 東言葉"
"あずまふじ 東富士"
"あずまや 阿亭 四阿 東屋"
"あずみ 杏美 安住 安曇"
"あずみの 安曇野"
"あせ 阿瀬 汗"
"あせい 阿世"
"あせかき 汗かき 汗掻き"
"あせだく 汗だく"
"あせちるさりちるさん アセチルサリチル酸"
"あせっかき 汗っかき 汗っ掻き"
"あせとり 汗取り"
"あせび 馬酔木"
"あせふき 汗拭き"
"あせぼ 馬酔木"
"あせまみれ 汗塗れ"
"あせみ 馬酔木"
"あせみず 汗水"
"あせみどろ 汗みどろ"
"あせも 汗疹"
"あせり 焦り"
"あせんやく 阿仙薬"
"あぜ 畦 畔"
"あぜくら 校倉"
"あぜくらづくり 校倉造"
"あぜぬり 畦塗り"
"あぜみち 畦道"
"あぜん 唖然"
"あそ 阿曽 安蘇 阿蘇"
"あそう 阿僧 麻生"
"あそうぎ 阿僧祇"
"あそこ 彼所 彼処"
"あそび 遊び"
"あそびうた 遊び唄 遊び歌"
"あそびがね 遊び金"
"あそびぐせ 遊び癖"
"あそびぐるま 遊び車"
"あそびげ 遊び毛"
"あそびごころ 遊び心"
"あそびにん 遊人"
"あそびべ 遊部"
"あそびめ 遊び女 遊女"
"あそみ 朝臣"
"あそん 朝臣"
"あぞく 亜属"
"あた 咫"
"あたい 値い 價 私 価 値"
"あたいせんきん 値千金"
"あたいていぎ 値定義"
"あたいひょう 値表"
"あたいよび 値呼び"
"あたえかた 与え方"
"あたか 恰 宛 安宅"
"あたかも 宛 宛も 恰も"
"あたがわ 熱川"
"あたく 安宅"
"あたくし 私"
"あたけ 安宅"
"あたご 愛宕"
"あたし 私"
"あたたかみ 暖かみ"
"あたま 頭"
"あたまいがい 頭以外"
"あたまうち 頭打ち"
"あたまかず 頭数"
"あたまかぶ 頭株"
"あたまがみ 頭紙"
"あたまがわ 頭側"
"あたまきん 頭金"
"あたまごし 頭越し"
"あたまごなし 頭ごなし"
"あたまだし 頭出し"
"あたまでっかち 頭でっかち"
"あたまわり 頭割 頭割り"
"あたみ 熱海"
"あたらし 新子"
"あたらしや 新屋"
"あたり 邉 邊 辺 当り 辺り 当たり"
"あたりがね 当り鉦"
"あたりくじ 当たり籤"
"あたりどし 当たり年"
"あたりばち 当り鉢 当たり鉢"
"あたりやく 当役"
"あたる 中 鼎"
"あたん 亜炭"
"あだ 讎 讐 婀娜 徒 仇"
"あだい 亜大"
"あだうち 仇討 仇討ち"
"あだごと 徒事"
"あだざくら 徒桜"
"あだしごと 徒し事"
"あだしの 化野 徒野"
"あだたら 安達太良"
"あだち 足達 安達 足立"
"あだて 当"
"あだな あだ名 綽名 徒名 仇名 渾名"
"あだなみ 徒波"
"あだばな 徒花"
"あだもの 徒物"
"あだゆめ 徒夢"
"あだん 阿檀 ア段"
"あち 窪地 閼 阿智 彼方"
"あちら 彼方"
"あちわ 阿知波"
"あっか 悪貨 悪化"
"あっかい 圧潰 圧壊"
"あっかく 圧覚"
"あっかどご アッカド語"
"あっかん 悪漢 圧巻"
"あっかんじょう 悪感情"
"あっき 悪鬼 悪気"
"あっく 悪口"
"あっけ 呆気"
"あっけい 悪計"
"あっけし 厚岸"
"あっけない 呆気ない"
"あっこう 悪口"
"あっさい 圧砕"
"あっさく 圧搾"
"あっさつ 圧殺"
"あっさぶ 厚沢部"
"あっし 私 圧死"
"あっしゅく 圧縮"
"あっしゅくがす 圧縮ガス"
"あっしゅくふぁいる 圧縮ファイル"
"あっしょう 圧勝"
"あっせい 圧制 圧政"
"あっせつ 圧接 圧雪"
"あっせん 斡旋"
"あっそう 圧送"
"あっち 彼方"
"あっちゃく 圧着"
"あっつう 圧痛"
"あってん 圧点"
"あっと ＠"
"あっとう 圧倒"
"あっとこ 厚床"
"あっばーすちょう アッバース朝"
"あっぱい 圧排"
"あっぱく 圧迫"
"あっぱれ 遖 天晴 天晴れ"
"あっぴ 安比"
"あっぷく 圧伏 圧服"
"あつ 乢 閼 敦 惇 淳 壓 遏 斡 軋 篤 熱 暑 厚 圧"
"あつあつ 熱々"
"あついた 圧板"
"あつえん 圧延"
"あつお 敦男 厚雄 淳夫 敦夫"
"あつかい 扱 扱い"
"あつかいさき 扱先"
"あつかいてん 扱店"
"あつかべ 厚壁"
"あつかん 熱燗"
"あつがま 厚釜"
"あつがみ 厚紙"
"あつがり 暑がり"
"あつき 敦紀"
"あつぎ 厚着 厚木"
"あつぎないろん 厚木ナイロン"
"あつぎぬ 厚衣"
"あつけし 厚岸"
"あつこ 亜都子 惇子 篤子 厚子 あつ子 敦子 温子 淳子"
"あつさ 厚さ 暑さ"
"あつし 充史 篤司 敦志 淳史 敦司 敦士 厚志 篤志 敦史 篤史 陸 厚 篤 敦 淳"
"あつしば 厚芝"
"あつじ 厚地"
"あつじょう 圧条"
"あつぜつし 圧舌子"
"あつぞこ 厚底"
"あつた 厚田 熱田"
"あつたか 篤孝"
"あつつぐ 淳嗣"
"あつで 厚手"
"あつでん 圧電"
"あつでんき 圧電気"
"あつにゅう 圧入"
"あつぬり 厚塗"
"あつのぶ 篤信"
"あつひこ 淳彦 篤彦 敦彦"
"あつひと 厚人"
"あつひろ 厚宏 淳裕 敦弘"
"あつび 熱火"
"あつへいこお 圧平衡"
"あつべつ 厚別"
"あつま 厚真"
"あつまり 集り 集まり"
"あつみ 厚見 淳美 渥美 温海 厚み 厚味"
"あつみつ 圧密"
"あつめ 熱目 厚目 熱め 厚め"
"あつもの 羹"
"あつもり 敦盛"
"あつもりそう 敦盛草"
"あつや 篤哉"
"あつやき 厚焼"
"あつやきたまご 厚焼き卵"
"あつゆ 熱湯"
"あつゆき 篤幸 淳之 敦之"
"あつよう 厚様"
"あつらえ 誂え"
"あつりょく 壓力 圧力"
"あつりょくなべ 圧力鍋"
"あつれき 軋轢"
"あつろう 淳良 篤郎"
"あづかりきん 預かり金"
"あづち 安土"
"あづま 東 我妻 吾妻"
"あづまや 東谷"
"あて 貴 当て 宛"
"あてうま 当て馬"
"あてがいぶち 宛行扶持"
"あてぎ 当て木"
"あてこすり 当て擦り"
"あてこと 当て事"
"あてさき 宛て先 宛先"
"あてじ 宛て字 宛字 あて字"
"あてずいりょう 当て推量"
"あてずっぽう 当てずっぽう"
"あてつ 阿哲"
"あてど 当て所"
"あてな 宛て名 宛名"
"あてながき 宛名書"
"あてぬの 当て布"
"あてね 雅典"
"あてはつ 宛発"
"あてびと 貴人"
"あてみ 当て身"
"あてらざわ 左沢"
"あてるい 阿弖流為"
"あで 艶"
"あですがた 艶姿"
"あでのしんさんりんさん アデノシン三リン酸"
"あでやか 艶やか"
"あと 踪 蹟 痕 跡 後"
"あとあし 後脚 後足"
"あとあじ 後味"
"あとあと 後後 後々"
"あといっこ 後一個"
"あといっぽ 後一歩"
"あとう 阿党 阿東"
"あとうた 後歌"
"あとうだ 阿刀田"
"あとおい 後追 後追い"
"あとおし 後押し"
"あとかいぎ 後会議"
"あとかた 跡かた 跡形"
"あとかたづけ 後片付 後かたづけ 後片付け"
"あとかわ 後川"
"あとがき 後書 後書き"
"あとがね 後金"
"あとがま 後釜"
"あときん 後金"
"あとくされ 後腐れ"
"あとくち 後口"
"あとこうてい 後工程"
"あとさき 後先"
"あとさく 後作"
"あとざん 後産"
"あとしまつ 後始末"
"あとしょり 後処理"
"あとすうねん 後数年"
"あとずさり 後退り"
"あとぜめ 後攻め"
"あとぞめ 後染め"
"あとだし 後出し"
"あとち 跡地"
"あとぢえ 後知恵"
"あとつぎ 跡継 後継 後継ぎ 跡継ぎ"
"あとづけ 後付 後付け"
"あととり 跡取り"
"あとのまつり 後の祭 後の祭り"
"あとのり 後ノリ 後乗り"
"あとはん 後版"
"あとばらい 後払い"
"あとばん 後番"
"あとぴーせい アトピー性"
"あとべ 跡部"
"あとまわし 後回し"
"あとみ 跡見"
"あとみや 後宮"
"あとめ 跡目"
"あともどり 後戻り"
"あとやく 後厄"
"あとり 花鶏"
"あど 亜土"
"あどがわ 安曇川"
"あどりあかい アドリア海"
"あどれすちょう アドレス帳"
"あな 坑 孔 穴"
"あなあき 穴開き"
"あなあきせん 穴明き銭"
"あなあけ 穴開け"
"あない 穴井 案内"
"あなうま 穴馬"
"あなうめ 穴埋め"
"あなかんむり 穴冠"
"あながち 強ち"
"あながま 穴窯"
"あながわ 穴川"
"あなきょうだい 穴兄弟"
"あなぐま 穴熊"
"あなぐら 窖 穴蔵"
"あなご 穴子"
"あなし 阿梨"
"あなた 貴女 彼方 貴方"
"あなたがた あなた方"
"あなたたち あなた達"
"あなだ 穴田"
"あなとう 穴党"
"あなどり 侮り"
"あなにんき 穴人気"
"あなば 穴馬 穴場"
"あなぶき 穴吹"
"あなほり 穴掘り"
"あなぼこ 穴ぼこ"
"あなみず 穴水"
"あなやま 穴山"
"あなよそう 穴予想"
"あなろぐかいせん アナログ回線"
"あなろぐどけい アナログ時計"
"あなろぐばん アナログ盤"
"あなろぐほうそう アナログ放送"
"あなん 阿南"
"あなんだ 阿難陀"
"あに 阿仁 豈 兄"
"あにい 兄い"
"あにうえ 兄上"
"あにき 兄貴"
"あにぎみ 兄君"
"あにさま 兄様"
"あにじゃ 兄者"
"あにでし 兄弟子"
"あにめえ アニメ絵"
"あにめえいが アニメ映画"
"あにめか アニメ化"
"あにや 安仁屋"
"あによめ 嫂 兄嫁"
"あね 姐 姉"
"あねうえ 姉上"
"あねおとうと 姉弟"
"あねがこうじ 姉小路"
"あねがさき 姉ヶ崎"
"あねがわ 姉川"
"あねき 姉貴"
"あねぎみ 姉君"
"あねご 姐御 姉御"
"あねさき 姉崎"
"あねさま 姉様"
"あねさん 姉さん 姐さん"
"あねざき 姉崎"
"あねじゃ 姉者"
"あねたい 姉帯"
"あねむこ 姉婿"
"あのう 安濃 穴太"
"あのかた あの方 彼の方"
"あのくたら 阿耨多羅"
"あのこ あの娘 あの子"
"あのころ あの頃"
"あのつ 安濃津"
"あのてこのて あの手この手"
"あのひ あの日"
"あのへん あの辺"
"あのよ 彼の世 あの世"
"あのよう 彼の様"
"あはなち 畔放ち 畔放"
"あば 網端 浮子 阿波"
"あばしり 網走"
"あばしりこ 網走湖"
"あばずれ 阿婆擦れ"
"あばた 痘痕"
"あばら 肋"
"あばらぼね あばら骨 肋骨"
"あばれ 暴れ"
"あばれうま 暴れ馬"
"あばれんぼう 暴れん坊"
"あぱらちあさんみゃく アパラチア山脈"
"あひかけ 足腰"
"あひる 阿比留 鶩 家鴨"
"あび 阿比 阿鼻"
"あびき 網引"
"あびこ 安彦 我孫子"
"あびせたおし 浴びせ倒し"
"あびだつま 阿毘達磨"
"あびる 阿比留"
"あふ 押 凹 阿父 亜父"
"あふち 楝 樗"
"あふりか 阿弗利加"
"あふりかけい アフリカ系"
"あふりかじん アフリカ人"
"あふりかぞう アフリカ象"
"あふりかたいりく アフリカ大陸"
"あふりかとういつきこう アフリカ統一機構"
"あぶ 阿武 虻"
"あぶく 泡"
"あぶくぜに 泡銭"
"あぶくま 阿武隈"
"あぶしんべるしんでん アブシンベル神殿"
"あぶた 虻田"
"あぶな 危な"
"あぶなえ 危絵"
"あぶはち 虻蜂"
"あぶはちとらず 虻蜂取らず"
"あぶみ 鐙"
"あぶみがわら 鐙瓦"
"あぶみこつ 鐙骨"
"あぶら 膏 脂 油"
"あぶらあか 油垢 脂垢"
"あぶらあげ 油揚 油揚げ"
"あぶらあせ 脂汗"
"あぶらいし 油石"
"あぶらいため 油炒め"
"あぶらいろ 油色"
"あぶらえ 油絵"
"あぶらえのぐ 油絵の具"
"あぶらかす 油糟 油粕"
"あぶらかわ 油川"
"あぶらがに 油蟹"
"あぶらがみ 油紙"
"あぶらぐすり 脂薬 膏薬"
"あぶらぐち 油口"
"あぶらげ 油揚"
"あぶらこし 油漉し"
"あぶらさし 油注し 油差し"
"あぶらざめ 油鮫"
"あぶらざら 油皿"
"あぶらしょう 脂性"
"あぶらぜみ 油蝉"
"あぶらだ 油田"
"あぶらつち 油土"
"あぶらつぼ 油壷 油壺"
"あぶらづけ 油漬け 油漬"
"あぶらとり 脂取り"
"あぶらどおし 油通し"
"あぶらな 薹 油菜"
"あぶらなか アブラナ科"
"あぶらぬき 油抜き"
"あぶらねんど 油粘土"
"あぶらひ 油日"
"あぶらひき 油引き"
"あぶらぶん 油分"
"あぶらみ 油身 脂身"
"あぶらむし 蜚 油虫"
"あぶらめ 油女"
"あぶらもと 油本"
"あぶらや 油屋"
"あぶらやけ 油焼け"
"あぶり 焙り 炙り"
"あぶれもの 溢れ者"
"あへん 鴉片 阿片"
"あへんくつ 阿片窟"
"あべ 阿武 阿倍 安部 安倍 阿部"
"あべかわ 安倍川"
"あべかわもち 安倍川餅"
"あべた 安部田"
"あべの 阿部野 阿倍野"
"あべのなかまろ 阿倍仲麻呂"
"あべまき 阿部槙"
"あほ 阿呆"
"あほう 阿房 阿呆"
"あほうどり 信天翁"
"あほだらきょう 阿呆陀羅経"
"あぼ 阿母 英保 安保"
"あぼう 安房"
"あぼがどろていすう アボガドロ定数"
"あぼし 網干"
"あぽくりんせん アポクリン腺"
"あぽろてき アポロ的"
"あぽろんてき アポロン的"
"あま 塰 蜑 雨 天 甘 亜麻 海女 海士 海人 尼"
"あまあし 雨脚 雨足"
"あまいけ 雨池 天池"
"あまいた 天板"
"あまいと 亜麻糸"
"あまうけ 雨受け"
"あまえ 甘え"
"あまえび 甘えび 甘エビ 甘海老"
"あまえんぼ 甘えん坊"
"あまえんぼう 甘えん坊"
"あまお 雨尾"
"あまおおい 雨覆い"
"あまおと 雨音"
"あまおとめ 天少女"
"あまかす 甘糟 甘粕"
"あまかぜ 雨風"
"あまかみ 甘噛み"
"あまから 甘辛"
"あまかわ 甘皮 天川"
"あまかんむり 雨冠"
"あまがい 雨海 天海"
"あまがえる 雨蛙"
"あまがき 甘柿"
"あまがさ 雨ガサ 雨がさ 雨笠 雨傘"
"あまがさき 尼崎"
"あまがせ 天ケ瀬 天瀬"
"あまがっぱ 雨ガッパ 雨合羽"
"あまがみ 甘噛み"
"あまき 天木"
"あまぎ 亜麻木 雨着 甘木 天城"
"あまぎみ 尼君"
"あまぎり 雨霧"
"あまくさ 天草"
"あまくだり 天降り 天下り"
"あまくち 甘口"
"あまくぼ 天久保"
"あまぐ 雨具"
"あまぐつ 雨靴"
"あまぐも 雨雲"
"あまぐり 甘栗"
"あまこ 尼子"
"あまごい 雨乞い"
"あまさ 甘さ"
"あまざけ 甘酒"
"あまざらし 雨晒し 雨曝し"
"あまし 蔗"
"あましょく 甘食"
"あまじ 天路"
"あまじお 甘塩"
"あまじみ 雨染み"
"あますところ 余す所"
"あまず 甘酢"
"あまずあえ 甘酢和え"
"あまぞら 雨空"
"あまた 天田 数多"
"あまだ 天田"
"あまだい 甘鯛"
"あまだな 天棚"
"あまだれ 雨だれ 雨垂れ"
"あまち 天池 天地"
"あまちゃ 甘茶"
"あまちゃづる 甘茶蔓"
"あまちゃん 甘ちゃん"
"あまったれ 甘ったれ"
"あまつ 天津"
"あまつかぜ 天つ風"
"あまつかみ 天つ神 天津神"
"あまつくに 天津国"
"あまつさえ 剰え"
"あまつじ 天辻"
"あまつつみ 天つ罪 天津罪"
"あまつばめ 雨燕"
"あまつぶ 雨粒"
"あまづ 天津"
"あまてらすおおみかみ 天照大御神 天照大神"
"あまでら 尼寺"
"あまとう 甘党"
"あまとぶや 天飛ぶや"
"あまど 雨戸"
"あまどい 雨樋"
"あまどり 天鳥"
"あまどりのみこと 天鳥命"
"あまなっとう 甘納豆"
"あまなつ 甘夏"
"あまに 甘煮"
"あまぬま 天沼"
"あまね 周"
"あまの 雨野 天野"
"あまのいわと 天の磐戸 天の岩戸"
"あまのかぐやま 天香久山"
"あまのがわ 天の河 天の川"
"あまのじゃく 天の邪鬼 天邪鬼"
"あまのはしだて 天の橋立 天橋立"
"あまのはら 天の原"
"あまのむらくものつるぎ 天叢雲剣"
"あまのり 甘海苔"
"あまぶた 雨蓋"
"あまべ 海部"
"あまほうし 尼法師"
"あまみ 甘み 奄美 甘味"
"あまみず 雨水"
"あまみそ 甘味噌"
"あまみや 天宮 雨宮"
"あまめ 甘目 甘め"
"あまも 甘藻"
"あまもと 天本"
"あまもよい 雨催い 雨催"
"あまもよう 雨模様"
"あまもり 雨漏 雨森 雨漏り"
"あまやか 甘やか"
"あまやどり 雨宿り"
"あまよ 雨夜"
"あまよけ 雨避け 雨除け"
"あまり 甘利 余り"
"あまるべ 餘部 余部"
"あまるめ 余目"
"あまんざ 甘座"
"あみ 糠蝦 罔 网 醤蝦 阿見 亜美 阿弥 網"
"あみあげぐつ 編上靴 編み上げ靴"
"あみあぶら 網油"
"あみうち 網打ち"
"あみえ 網江"
"あみかけ 網掛 網かけ 網掛け"
"あみかんり 網管理"
"あみがさ 編み笠 編笠"
"あみがしら 罔頭"
"あみき 編み機"
"あみぎょぎょう 網漁業"
"あみこ 安見子"
"あみこみ 編み込み"
"あみしま 網島"
"あみしろ 網代"
"あみじ 編地"
"あみじゃくし 網杓子"
"あみじょう 網状"
"あみせいぎょ 網制御"
"あみせつぞく 網接続"
"あみたいつ 網タイツ"
"あみだ 阿弥陀"
"あみだくじ 阿弥陀籤"
"あみだな 網棚"
"あみてん 網点"
"あみど 網戸"
"あみなか 網中"
"あみの 網野"
"あみのき アミノ基"
"あみのさん アミノ酸"
"あみのとう アミノ糖"
"あみのめ 網の目"
"あみはま 網浜"
"あみはり 網張"
"あみはん 網版"
"あみばり 編針 編み針"
"あみびと 網人"
"あみぼう 編棒 編み棒"
"あみぼし 網干"
"あみめ 編目 編み目 網目"
"あみもと 網元"
"あみもの 編物 編み物"
"あみや 網屋"
"あみやき 網焼 網焼き"
"あみわたり 網渡"
"あむ 虻"
"あむろ 安室"
"あめ 豆汁 天 飴 雨"
"あめあがり 雨上がり"
"あめあし 雨脚 雨足"
"あめあられ 雨あられ 雨霰"
"あめいせんそう 蛙鳴蝉噪"
"あめいろ 飴色"
"あめおとこ 雨男"
"あめおんな 雨女"
"あめかぜ 雨風"
"あめかんむり 雨冠"
"あめがし 飴菓子"
"あめこう アメ公"
"あめざいく 飴細工"
"あめしゃ アメ車"
"あめたいさく 雨対策"
"あめたいふう 雨台風"
"あめだま 飴玉"
"あめつち 天地"
"あめつぶ 雨粒"
"あめつゆ 雨露"
"あめに 飴煮"
"あめのもり 雨森"
"あめふらし 雨虎 雨降"
"あめふり 雨ふり 雨降り"
"あめみや 雨宮"
"あめもよう 雨模様"
"あめや 飴屋"
"あめやよこちょう アメヤ横丁"
"あめよこ アメ横"
"あめよほう 雨予報"
"あめりか 米 亞米利加 亜米利加"
"あめりかえいが アメリカ映画"
"あめりかえいご アメリカ英語"
"あめりかがっしゅうこく アメリカ合衆国"
"あめりかぐん アメリカ軍"
"あめりかさん アメリカ産"
"あめりかしき アメリカ式"
"あめりかしじょう アメリカ市場"
"あめりかしゃ アメリカ車"
"あめりかじん アメリカ人"
"あめりかせい アメリカ製"
"あめりかたいりく アメリカ大陸"
"あめりかてき アメリカ的"
"あめりかぶんか アメリカ文化"
"あめんぼ 飴坊 水黽 水馬"
"あも 餅 母"
"あもい 廈門 厦門"
"あもく 亜目"
"あもん 亜門"
"あや 禮 漢 亜也 亜矢 亜弥 彪 礼 絢 彩 文 綾"
"あやいがさ 綾藺笠"
"あやいと 綾糸"
"あやう 危"
"あやうじ 漢氏"
"あやうた 綾歌"
"あやおり 綾織り 綾織"
"あやか 綾香 彩香"
"あやかみ 綾上"
"あやがみ 綾上"
"あやぎく 綾菊"
"あやぎぬ 綺 綾絹"
"あやこ 操子 亜也子 亜弥子 章子 絢子 亜矢子 文子 彩子 綾子"
"あやし 怪し 愛子"
"あやしろ 綾城"
"あやせ 綾世 綾瀬"
"あやたり 綾足"
"あやだけ 綾竹"
"あやつ 彼奴"
"あやつか 綾塚"
"あやつじ 綾辻"
"あやつり 操"
"あやつりにんぎょう 操人形 操り人形"
"あやとも 文友"
"あやとり 綾取り"
"あやね 綾音"
"あやの 綾野 綾乃"
"あやのこうじ 綾小路"
"あやのみや 礼宮"
"あやはな 彩花"
"あやふみ 礼史"
"あやべ 綾部"
"あやま 阿山"
"あやまち 誤ち 過ち"
"あやまり 謝り 謬り 誤り"
"あやむら 文村"
"あやめ 文目 菖蒲"
"あやめいけ あやめ池"
"あやめか アヤメ科"
"あやめもく アヤメ目"
"あゆ 東風 阿諛 鮎"
"あゆかわ 鮎川"
"あゆこ 亜佑子"
"あゆさわ 鮎澤"
"あゆざわ 鮎澤"
"あゆつり 鮎釣り"
"あゆづり 鮎釣り"
"あゆみ 天弓 彩友美 歩 亜弓 歩美 歩み"
"あゆみあし 歩み足"
"あゆみいた 歩み板"
"あゆむ 渉"
"あら 荒 粗 新"
"あらい 新居 荒井 新井"
"あらいおけ 洗い桶"
"あらいかた 洗い方"
"あらいがえ 洗い替え"
"あらいがき 洗柿"
"あらいがみ 洗い髪"
"あらいぐま 浣熊 洗熊"
"あらいざらい 洗い浚い"
"あらいざらし 洗い晒し"
"あらいし 荒石"
"あらいしゅ 洗朱"
"あらいじゅく 新井宿"
"あらいそ 荒磯"
"あらいだし 洗い出し"
"あらいど 荒井戸"
"あらいはり 洗い張り"
"あらいば 洗い場"
"あらいもの 洗い物"
"あらいわ 荒岩"
"あらうま 荒馬"
"あらうみ 荒海"
"あらお 荒生 荒尾"
"あらおり 粗織"
"あらか 殿"
"あらかじめ 豫 豫め 予 予め"
"あらかせぎ 荒稼ぎ"
"あらかた 粗方"
"あらかね 粗金 鉱"
"あらかべ 粗壁 荒壁"
"あらかわ 粗皮 荒川"
"あらかん 阿羅漢"
"あらがき 荒書き 新垣"
"あらがね 荒金 粗金 鉱"
"あらき 荒木"
"あらきだ 荒木田"
"あらきどんさん アラキドン酸"
"あらきの 新木野"
"あらぎも 荒肝"
"あらぎょう 荒行"
"あらぎり 荒切り 粗切り"
"あらくさ 荒草"
"あらくち 新口"
"あらくれ 荒くれ"
"あらけ 有明"
"あらけずり 粗削り 荒削り"
"あらこ 荒子"
"あらごし 粗漉し"
"あらごと 荒事"
"あらごなし 荒ごなし"
"あらさがし 粗捜し あら探し 粗探し"
"あらさき 荒崎"
"あらさわ 荒澤 荒沢"
"あらし 荒らし 嵐"
"あらしがおか 嵐ヶ丘"
"あらしごと 荒仕事"
"あらしね 荒稲"
"あらしやま 嵐山"
"あらじお 粗塩"
"あらじる あら汁 粗汁"
"あらすかはんとう アラスカ半島"
"あらすじ 粗筋"
"あらず 非ず"
"あらぜき 荒関"
"あらそい 争い"
"あらた 新 新太 荒田 新田 新た"
"あらたけ 荒武"
"あらたに 荒谷"
"あらため 改め"
"あらためて 改めて"
"あらだき あら炊き"
"あらち 新血"
"あらちゃ 荒茶"
"あらづくり 粗造り"
"あらて 新手"
"あらと 荒砥"
"あらどこ 新床"
"あらなみ 荒波"
"あらなわ 荒縄"
"あらぬの 粗布"
"あらねつ 粗熱"
"あらの 曠野 荒野"
"あらはた 荒畑"
"あらはま 荒浜"
"あらばち 新鉢"
"あらひとがみ 荒人神 現人神"
"あらびあ 亞剌比亞 亜拉毘亜 亜剌比亜"
"あらびあご アラビア語"
"あらびあじん アラビア人"
"あらびあすうじ アラビア数字"
"あらびあせきゆ アラビア石油"
"あらびあもじ アラビア文字"
"あらびき 粗碾き 粗引き 粗挽き"
"あらふか 荒深"
"あらふね 荒船"
"あらぶけい アラブ系"
"あらぶじん アラブ人"
"あらほうし 荒法師"
"あらぼとけ 新仏"
"あらぼん 新盆"
"あらまき 新巻 荒牧 荒巻"
"あらまきじゃけ 新巻鮭"
"あらまさ 新政"
"あらまた 荒俣"
"あらまち 荒町"
"あらまつ 荒松"
"あらむご アラム語"
"あらむしゃ 荒武者"
"あらむしろ 粗筵 荒筵"
"あらむもじ アラム文字"
"あらめ 荒布 荒目"
"あらもと 荒本"
"あらもの 荒物"
"あらや 新谷 新屋"
"あらやしき 阿頼耶識 新屋敷"
"あらやま 荒山"
"あらゆ 新湯"
"あらゆる ∀ 凡"
"あららぎ 塔 蘭"
"あららぎは アララギ派"
"あらり 粗利"
"あらりえき 荒利益"
"あらりょうじ 荒療治"
"あらりょうち 荒療治"
"あられ 霰"
"あられしょうが 霰生薑"
"あらわ 露わ 表 現 顕 露"
"あらわざ 荒業 荒技"
"あらわし 荒鷲"
"あらわしかた 表し方"
"あらわれ 顕れ 表れ 現れ"
"あらん 亜欄 亜蘭"
"あり 袵 衽 有り 阿梨 有 蟻"
"ありーなせき アリーナ席"
"ありあけ 有明"
"ありあけころしあむ 有明コロシアム"
"ありあけのつき 有明の月"
"ありあけひめしらうお 有明姫白魚"
"ありあり 在り在り"
"ありう 有り得"
"ありえ 有家"
"ありか 在り処 在処"
"ありかた 在り方 あり方"
"ありかべ 蟻壁 有壁"
"ありかわ 有川"
"ありが 有我 有賀"
"ありがた 有り難 有難"
"ありがたみ ありがた味"
"ありがとう 有り難う 有難う"
"ありがね 有り金"
"ありき 有木"
"ありきたり 在り来り"
"ありくい 食蟻獣 蟻食"
"ありくら 有倉"
"ありさ 亜利沙"
"ありさか 有坂"
"ありさま 有様"
"ありさわ 有澤 有沢"
"ありさん 阿里山"
"ありざ 有座"
"ありしひ 在りし日"
"ありしま 有島"
"ありしまたけお 有島武郎"
"ありしゃかい 蟻社会"
"ありしよ 在りし世"
"ありじごく 蟻地獄"
"ありす 有栖"
"ありすがわのみや 有栖川宮"
"ありた 有田"
"ありたま 有玉"
"ありたやき 有田焼"
"ありだ 有田"
"ありったけ 有りっ丈"
"ありつぎ 有次"
"ありつね 有恒"
"ありづか 垤 蟻塚"
"ありてい 有態 有体"
"ありとう 有藤"
"ありとも 有朋"
"ありなが 有永"
"ありのとうぐさもく アリノトウグサ目"
"ありのまま 有りの儘"
"ありのみ 有りの実"
"ありはた 有畠"
"ありはら 有原 在原"
"ありま 有馬"
"ありまさ 有正"
"ありみ 有里巳"
"ありみつ 有光"
"ありむら 有村"
"ありもと 有本"
"ありもり 有森"
"ありもんじ 有文字"
"ありや 有家"
"ありやま 有山"
"ありゅーしゃんれっとう アリューシャン列島"
"ありゅう 亜流"
"ありゅうさんがす 亜硫酸ガス"
"ありよし 有吉"
"ありわら 在原"
"ある ∃ 亜留 或 或る"
"あるあさ 或る朝 ある朝"
"あるいは 或は 或いは"
"あるかなし 有るか無し"
"あるかりいおんすい アルカリイオン水"
"あるかりか アルカリ化"
"あるかりかんでんち アルカリ乾電池"
"あるかりせい アルカリ性"
"あるかりちょうせき アルカリ長石"
"あるかりでんち アルカリ電池"
"あるかりど アルカリ土 アルカリ度"
"あるかりどじょう アルカリ土壌"
"あるかりどるいきんぞく アルカリ土類金属"
"あるが 有賀"
"あるき 歩き"
"あるきたばこ 歩きタバコ"
"あるきめですのげんり アルキメデスの原理"
"あるきるき アルキル基"
"あるぎんさん アルギン酸"
"あるこーるいぞんしょう アルコール依存症"
"あるこーるいんりょう アルコール飲料"
"あるこーるちゅうどく アルコール中毒"
"あるこーるどすう アルコール度数"
"あるこーるぶん アルコール分"
"あることないこと 有る事無い事"
"あるござ アルゴ座"
"あるしゅ ある種"
"あるじ 主"
"あるじもうけ 饗設け"
"あるぜんちん 亞爾然丁"
"あるたみらどうくつ アルタミラ洞窟"
"あるちゅう アル中"
"あるつはいまーびょう アルツハイマー病"
"あるとき 或る時 ある時"
"あるときばらい 有る時払い"
"あるところ ある所"
"あるとし 或る年 ある年"
"あるばいとだい アルバイト代"
"あるばいとりょう アルバイト料"
"あるばん ある晩"
"あるひ 或る日 ある日"
"あるひと 或る人 ある人"
"あるふぁ Α α"
"あるふぁー Α α"
"あるふぁせい α星"
"あるふぁせん アルファ線 α線"
"あるふぁは α波"
"あるふぁばん α版"
"あるふぁべっとじゅん アルファベット順"
"あるふぁほうかい α崩壊"
"あるふぁりゅうし α粒子"
"あるぷすでんき アルプス電気"
"あるへいとう 有平糖"
"あるみかん アルミ缶"
"あるみせい アルミ製"
"あるみなべ アルミ鍋"
"あるみはく アルミ箔"
"あるよ 或る夜 ある夜"
"あれ 荒れ"
"あれい 唖鈴 亜鈴"
"あれこれ 彼此 彼是"
"あれしょう 荒れ性"
"あれち 荒地"
"あれつ あ列 ア列"
"あれの 荒れ野"
"あれほど 彼程"
"あれら 彼等"
"あれるぎーせい アレルギー性"
"あれるぎーたいしつ アレルギー体質"
"あろかっせんものがたり 鴉鷺合戦物語"
"あろじ 主"
"あわ 慌 安房 阿波 粟 泡"
"あわあわ 淡々 淡淡"
"あわい 間"
"あわいい 粟飯"
"あわこうぞう 泡構造"
"あわさ 粟佐"
"あわさか 泡坂"
"あわしま 淡島"
"あわじ 淡路"
"あわじしま 淡路島"
"あわじょう 泡状"
"あわず 粟津"
"あわせ 合わせ 袷"
"あわせいれつ 泡整列"
"あわせかがみ 合せ鏡 合わせ鏡"
"あわせじょうゆ 合せ醤油"
"あわせず 合せ酢"
"あわせて 併せて"
"あわせみそ 合せ味噌"
"あわせめ 合せ目"
"あわせもの 合せ物"
"あわた 粟田"
"あわたてき 泡立て器"
"あわだち 泡立 泡立ち"
"あわだちそう 泡立草"
"あわだてき 泡立て器"
"あわつ 粟津"
"あわつぶ 泡粒 粟粒"
"あわづ 粟津"
"あわづはら 粟津原"
"あわてもの 慌て者"
"あわの 阿波野 粟野"
"あわばこ 泡箱"
"あわひめ 泡姫"
"あわび 蚫 鰒 鮑"
"あわびむすび 鮑結び"
"あわぶろ 泡風呂"
"あわみどり 淡緑"
"あわむらさき 淡紫"
"あわめし 粟飯"
"あわもり 泡盛"
"あわや 粟谷 淡谷 粟屋"
"あわゆき 沫雪 泡雪 淡雪"
"あわゆきかん 泡雪羹"
"あわゆきたまご 泡雪卵"
"あわら 芦原"
"あわれ 哀れ"
"あわれみ 憐れみ 哀れみ"
"あん 閼 行 杏 菴 罨 鮟 晏 鞍 按 黯 諳 闇 暗 安 庵 餡 案"
"あんあんり 暗々裏 暗々裡"
"あんい 安易"
"あんいつ 安佚 安逸"
"あんうつ 暗鬱"
"あんうん 暗雲"
"あんえい 暗翳 晏嬰 暗影 安永"
"あんか 案下 行火 安価"
"あんかけ 餡掛 餡掛け"
"あんかん 暗槓 安閑"
"あんが 安臥"
"あんがい 案外"
"あんき 晏起 諳記 暗鬼 安危 安気 安徽 暗記"
"あんきも 鮟肝"
"あんきょ 安居 暗渠"
"あんぎゃ 行脚"
"あんぎょう 安行"
"あんくん 暗君"
"あんぐ 暗愚"
"あんぐう 行宮"
"あんけーとちょうさ アンケート調査"
"あんけーとようし アンケート用紙"
"あんけい 安慶"
"あんけん 案件"
"あんけんさつ 暗剣殺"
"あんげん 安元"
"あんこ 暗刻 安固 餡こ"
"あんこー 暗刻"
"あんこう 鱇 鮟 暗刻 安康 鮟鱇"
"あんこうなべ 鮟鱇鍋"
"あんこがた 鮟鱇形"
"あんこく 闇黒 安国 暗黒"
"あんころもち 餡ころ餅"
"あんご 暗語 安吾 安居"
"あんごう 暗合 暗号"
"あんごうかぎ 暗号鍵"
"あんさつ 暗殺"
"あんさん 兄さん"
"あんざ 安座"
"あんざい 安齊 安在 安齋 安斎 安斉 安西"
"あんざん 鞍山 暗算 安産"
"あんざんがん 安山岩"
"あんし 晏子 暗視"
"あんししょく 暗紫色"
"あんしつ 庵室 暗室"
"あんしゅ 按手 庵主"
"あんしゅう 暗愁"
"あんしゅつ 案出"
"あんしょ 暗所"
"あんしょう 諳誦 暗誦 暗礁 暗証 暗唱"
"あんしょく 暗色"
"あんしん 安心"
"あんじ 案じ 暗示"
"あんじゅ 杏樹 庵主"
"あんじゅう 安住"
"あんじょ 晏如"
"あんじょう 安生 鞍上 安城"
"あんじょく 鞍褥"
"あんじん 安心"
"あんじんりゅうみょう 安心立命"
"あんじんりょうみょう 安心立命"
"あんず 杏子 杏"
"あんせい 安政 安静"
"あんせいのたいごく 安政の大獄"
"あんぜん 暗然 安全"
"あんぜんとう 安全燈"
"あんぜんぱい 安全牌"
"あんぜんぴん 安全ピン"
"あんそく 安息"
"あんそくこう 安息香"
"あんそっこう 安息香"
"あんたい 安泰"
"あんたく 安宅"
"あんたくせいろ 安宅正路"
"あんたん 暗澹"
"あんだ 安打"
"あんち 庵地 安地 安置"
"あんちゃく 安着"
"あんちゃん 兄ちゃん"
"あんちゅう 闇中 暗中"
"あんちょく 安直"
"あんちん 安珍"
"あんてい 安貞 安定"
"あんていばん 安定板"
"あんていりくかい 安定陸塊"
"あんてん 鞍点 暗転"
"あんでぱんだんてん アンデパンダン展"
"あんでるせんどうわ アンデルセン童話"
"あんとう 暗闘 安東"
"あんとく 安徳"
"あんど ∧ ∩ 安堵"
"あんどう 安東 安藤"
"あんどく 暗読"
"あんどろめだざ アンドロメダ座"
"あんどん 闇鈍 行燈 行灯"
"あんな 安和 杏奈"
"あんない 案内"
"あんないばん 案内板"
"あんなか 安中"
"あんなん 安南"
"あんに 暗に"
"あんにん 杏仁"
"あんねい 安寧"
"あんねん 安念"
"あんの 安野 庵野"
"あんのう 鞍嚢"
"あんのじょう 案の定"
"あんのん 安穏"
"あんば 鞍馬"
"あんばい 按排 案配 按配 塩梅"
"あんばこ 暗箱"
"あんぱち 安八"
"あんぱん あんパン 餡パン"
"あんひつ 安謐"
"あんぴ 安否"
"あんぶ 鞍部 暗部"
"あんぶん 案分 案文 按分"
"あんぷ 暗譜"
"あんぼれらか アンボレラ科"
"あんぽ 安保"
"あんぽう 罨法"
"あんぽんたん 安本丹"
"あんま 按摩"
"あんまく 暗幕"
"あんまん 餡饅"
"あんみつ 餡蜜"
"あんみん 安眠"
"あんめん 暗面"
"あんもく 暗黙"
"あんもち 餡餅"
"あんもにあすい アンモニア水"
"あんもん 案文"
"あんや 闇夜 暗夜"
"あんやく 暗躍"
"あんゆ 暗喩"
"あんらく 安楽"
"あんり 杏里"
"あんりゅう 暗流"
"あんろくざん 安禄山"
"い 李 僞 偽 忌 鑄 鋳 斐 如 ゐ 五 囗 醫 鰄 饐 頤 肄 矣 懿 恚 已 噫 揖 鮪 猪 胆 詑 莞 堰 移 畏 易 依 遺 怡 貽 詒 苡 以 彜 彝 彙 爲 為 猗 倚 椅 渭 謂 矮 逶 痿 萎 蔚 熨 尉 慰 囲 圍 幃 緯 偉 違 韋 唯 惟 帷 維 痍 洟 姨 夷 亥 威 射 居 衣 委 伊 井 位 医 異 意 胃"
"いーじすかん イージス艦"
"いーすと ＥＡＳＴ"
"いーすときん イースト菌"
"いーた Η η"
"いーふぁん 一翻"
"いあ 依阿"
"いあい 畏愛 遺愛 居合い 居合"
"いあいごし 居合腰"
"いあく 帷幄"
"いあつ 威壓 威圧"
"いあん 慰安"
"いあんふ 慰安婦"
"いい 唯々 依倚 依違 依依 猪井 伊井 井伊 猪 謂 飯"
"いいあい 言い合い"
"いいあらそい 言い争い"
"いいうり 言売"
"いいお 飯尾"
"いいおか 飯岡"
"いいかえ 言い換え"
"いいかお 好い顔"
"いいかげん 好い加減 いい加減"
"いいかた 言い方"
"いいがかり 言い掛り 言いがかり 言い掛かり"
"いいき 好い気 いい気 異域"
"いいぎり 椅"
"いいくら 飯倉"
"いいぐさ 言い種 言い草"
"いいこ いい子"
"いいこと いい事"
"いいさか 飯坂"
"いいざか 飯坂"
"いいざま 言い様"
"いいざわ 飯沢"
"いいし 飯石"
"いいじま 飯嶋 飯島"
"いいじょう 言い条"
"いいすぎ 言い過ぎ"
"いいすて 言い捨て"
"いいずか 飯塚"
"いいたいほうだい 言いたい放題"
"いいたか 飯高"
"いいたがわ 飯田川"
"いいたて 飯館"
"いいだ 飯田"
"いいだか 飯高"
"いいだくだく 唯唯諾諾"
"いいだこ 飯蛸"
"いいだしっぺ 言い出しっぺ"
"いいつけ 言い付け"
"いいつたえ 言い伝え"
"いいづか 飯塚"
"いいづな 飯綱"
"いいで 飯豊"
"いいとし いい歳 いい年 好い年"
"いいなおすけ 井伊直弼"
"いいなが 稲永"
"いいなずけ 許嫁 許婚"
"いいなり 言いなり 言い成り"
"いいなん 飯南"
"いいぬま 飯沼"
"いいね 言い値"
"いいの 飯野"
"いいのがれ 言い逃れ"
"いいはま 飯浜"
"いいはん 一翻"
"いいぶん 言い分"
"いいぼし 飯干"
"いいま 飯間"
"いいまちがい 言い間違い"
"いいまわし 言回し 言い回し"
"いいむら 飯村"
"いいもり 飯森 飯盛"
"いいや 否"
"いいやま 飯山"
"いいよう 言い様"
"いいわけ 言訳 言い訳"
"いいわたし 言渡し 言い渡し"
"いいん 伊尹 医員 医院 委員"
"いいんかいとうせっちがいしゃ 委員会等設置会社"
"いうこと 言う事"
"いうち 井内"
"いうなれば 言うなれば"
"いうら 井浦"
"いぇん 円 ￥"
"いえ 彌 伊江 家"
"いえい 遺詠 家居 遺影"
"いえいえ 家々"
"いえいがい 家以外"
"いえがた 家型"
"いえがまえ 家構え"
"いえがら 家柄"
"いえき 胃液"
"いえしま 家島"
"いえじ 家路"
"いえじゅう 家中"
"いえすじ 家筋"
"いえずすかい イエズス会"
"いえせいど 家制度"
"いえだ 家田"
"いえつき 家付 家付き"
"いえづくり 家作り 家造り"
"いえで 家出"
"いえどころ 家所"
"いえども 雖 雖も"
"いえなが 家永"
"いえなみ 家並 家並み"
"いえねこ 家猫"
"いえばと 家鳩"
"いえみつ 家光"
"いえもち 家持ち 家茂"
"いえもと 家元"
"いえやしき 家屋敷"
"いえやす 家康"
"いえやま 家山"
"いえよう 家様"
"いえらいしゃん 夜来香"
"いえん 以遠 胃炎"
"いお 五百 魚"
"いおう S 硫黄"
"いおうじ 医王寺"
"いおうじま 伊王島"
"いおうせん 硫黄泉"
"いおうとう 硫黄島"
"いおえ 五百枝 五百重"
"いおか 井岡"
"いおた Ι ι"
"いおち 庵地"
"いおにあしき イオニア式"
"いおの 魚野"
"いおのめ 魚の目"
"いおはら 庵原"
"いおり 伊織 菴 庵"
"いおりてん 庵点"
"いおん 遺恩 倚音 異音"
"いおんか イオン化"
"いおんけっしょう イオン結晶"
"いおんけつごう イオン結合"
"いおんこうかん イオン交換"
"いおんはんけい イオン半径"
"いおんびん イ音便"
"いか ≦ 伊香 医家 位下 異化 烏賊 医科 如何 以下"
"いかい 伊貝 猪飼 位階 異界"
"いかいよう 胃かいよう 胃潰瘍"
"いかが 如何"
"いかがく 医化学"
"いかく 威赫 居角 位格 威嚇"
"いかくちょう 胃拡張"
"いかけ 鋳掛 鋳掛け"
"いかざき 五十崎"
"いかすい 胃下垂"
"いかすみ いか墨 烏賊墨 イカ墨"
"いかずち 霹 霆 雷"
"いかた 伊方"
"いかたる 胃カタル"
"いかだ 桴 筏"
"いかだい 筏井"
"いかつ 威喝"
"いかづち 雷"
"いかてん イカ天"
"いかな 如何な"
"いかなご 玉筋魚"
"いかなる 如何なる"
"いかに 如何に"
"いかにも 如何にも"
"いかの 以下の"
"いかのぼり 凧"
"いかひか 異花被花"
"いかほ 伊香保"
"いかめら 胃カメラ"
"いかやき いか焼き イカ焼き"
"いからし 五十嵐"
"いかり 怒 怒り 碇 錨"
"いかりがせき 碇ヶ関"
"いかりがた 怒り肩"
"いかりそう 碇草"
"いかりど 錨戸"
"いかる 鵤 斑鳩"
"いかるが 斑鳩"
"いかるがのみや 斑鳩宮"
"いかわ 井河 居川 井川"
"いかわだに 伊川谷"
"いかん 異観 偉観 尉官 医官 衣冠 遺憾 移管 如何"
"いかんそく 維管束"
"いかんとも 如何とも"
"いかんなく 遺憾無く"
"いが 毬 伊賀"
"いがい 貽貝 遺骸 意外 以外"
"いがき 斎垣"
"いがく 医学"
"いがぐり 毬栗"
"いがぐりあたま いがぐり頭 毬栗頭"
"いがさてつどう 井笠鉄道"
"いがしら 井頭"
"いがた 范 鎔 井形 鋳型"
"いがっか 医学科"
"いがみ 井上"
"いがみあい 啀み合い"
"いがや 井ヶ谷"
"いがやき 伊賀焼"
"いがらし 五十嵐"
"いがり 猪狩"
"いがわ 居川 井川"
"いがん 胃ガン 胃がん 依願 胃癌"
"いき 粹 生 委棄 囲気 位記 生き 行き 行 壱岐 遺棄 意気 閾 域 粋 息"
"いきあたりばったり 行き当たりばったり"
"いきいき 活き活き"
"いきうお 活き魚"
"いきうま 生き馬"
"いきうめ 生埋め 生き埋め"
"いきえ 生き餌"
"いきおい 勢い"
"いきか 閾下"
"いきかん 異機間"
"いきがい 生きがい 域外"
"いきがかり 行き掛り 行き掛かり"
"いきがみ 生き神"
"いきき 一箕 往き来 行き来"
"いきぎも 生き胆 生き肝"
"いきぎれ 息切れ"
"いきごみ 意気ごみ 意気込み"
"いきさき 行先"
"いきさつ 経緯"
"いきさわ 生澤"
"いきざかな 生き魚"
"いきしな 行きしな"
"いきす 伊岐須"
"いきすぎ 行過ぎ"
"いきすじ 粋筋"
"いきち 域値 生血 生き血 閾値"
"いきつき 生月"
"いきつぎ 息継ぎ"
"いきづかい 息づかい 息遣い"
"いきづまり 行き詰まり"
"いきどおり 憤り"
"いきな 生名"
"いきない 域内"
"いきなり 行成り 行き成り"
"いきぬき 息抜 息抜き"
"いきのした 息の下"
"いきのね 息の根"
"いきのまつばら 生の松原"
"いきはじ 生き恥"
"いきば 行場"
"いきびん 生きビン"
"いきぼとけ 生き仏"
"いきみ 生き身"
"いきもの 生物"
"いきやすめ 息休め"
"いきょ 依拠"
"いきょう 井京 異香 異境 異郷 異教"
"いきょく 異曲 委曲 医局"
"いきりょう 生き霊 生霊"
"いぎ 猪木 威儀 異義 異議 意義"
"いぎす 伊岐須"
"いぎなし 異議なし"
"いぎょう い行 イ行 易行 遺業 医業 異形 偉業"
"いぎりす 英吉利"
"いぎりすぐん イギリス軍"
"いぎりすせい イギリス製"
"いぎりすぶんがく イギリス文学"
"いく 生 毓 粥 鬻 礇 燠 郁 畏懼 幾 育"
"いくい 生井"
"いくいな 生稲"
"いくえ 育江 郁恵 幾重"
"いくえい 育英"
"いくお 幾夫 幾雄 郁生 育男 郁雄 郁夫"
"いくきゅう 育休"
"いくこ 郁久子 以玖子 幾久子 育子 郁子"
"いくさ 戰 軍 戦"
"いくさか 生坂"
"いくさがみ 軍神"
"いくさき 行く先"
"いくさち 生幸"
"いくさば 軍場"
"いくさひょうじょう 軍評定"
"いくさびと 軍人"
"いくさぶぎょう 軍奉行"
"いくさぶね 軍船"
"いくさぼし 軍星"
"いくさものがたり 軍物語"
"いくしま 生島"
"いくしゅ 育種"
"いくじ 意気地 育児"
"いくじなし 意気地なし"
"いくじのう 育児嚢"
"いくすう 育雛"
"いくすじ 幾筋"
"いくせい 育成"
"いくせん 幾千"
"いくそ 幾十"
"いくそう 幾層"
"いくぞう 幾三 郁三"
"いくた 生田 幾多"
"いくたはら 生田原"
"いくたび 幾度"
"いくたま 生玉"
"いくたり 幾人"
"いくつ 幾つ"
"いくつか 幾つか"
"いくつき 幾月"
"いくとせ 幾年"
"いくど 幾度"
"いくどうおん 異口同音"
"いくにち 幾日"
"いくにん 幾人"
"いくねん 幾年"
"いくの 生野"
"いくは 的"
"いくはら 幾原"
"いくばく 幾何 幾許"
"いくひと 生人"
"いくひろ 郁博"
"いくび 猪首"
"いくびょう 育苗"
"いくびょうばこ 育苗箱"
"いくぶん いく分 幾分"
"いくほど 幾程"
"いくま 伊玖磨"
"いくまん 幾万"
"いくみ 育巳"
"いくもう 育毛"
"いくや 育也 郁哉"
"いくゆう 育友"
"いくよ 育代 郁代 幾夜 幾代 幾世"
"いくら 居倉 伊倉 幾ら"
"いくらか 幾らか"
"いくらどん イクラ丼"
"いくりん 育林"
"いくん 異訓 遺訓"
"いぐ 伊具"
"いぐさ 伊草 井草 藺草"
"いぐさもく イグサ目"
"いぐすり 胃薬"
"いぐち 井口"
"いぐるみ 弑 弋"
"いぐん 威軍"
"いけ 池"
"いけい 医系 異型 異形 畏敬"
"いけいざい 違警罪"
"いけいちょう 衣掛町"
"いけいのねん 畏敬の念"
"いけいれん 胃痙攣"
"いけうお 活け魚 生け魚 活魚"
"いけうち 池内"
"いけうら 池浦"
"いけえ 池江"
"いけお 池尾"
"いけがき 生け垣 生垣"
"いけがみ 池上"
"いけがめ 池亀"
"いけがや 池ケ谷 池谷"
"いけがわ 池川"
"いけごえ 池越え"
"いけさか 池坂"
"いけざわ 生澤 池沢 池澤"
"いけした 池下"
"いけしょうじ 池庄司"
"いけじり 池尻"
"いけす 生簀 生け簀"
"いけずみ 埋け炭 活け炭"
"いけた 井桁"
"いけたに 池谷"
"いけだ 池田"
"いけだやじけん 池田屋事件"
"いけつき 池月"
"いけつつみ 池堤"
"いけづくり 生け造り 生け作り 活け作り 活け造り"
"いけど 池戸"
"いけどり 生け捕り"
"いけなが 池永"
"いけなみ 池波"
"いけにえ 犧 牲 犠 犠牲 生け贄 生贄"
"いけの 池乃 池野"
"いけのうえ 池ノ上"
"いけのはた 池の端"
"いけのぼう 池の坊 池坊"
"いけはぎ 生剥"
"いけはら 池原"
"いけばな 生花 活花 挿花 活け花 生け花"
"いけび 埋け火"
"いけぶくろ 池袋"
"いけべ 池辺"
"いけぽちゃ 池ポチャ"
"いけみず 池水"
"いけみや 池宮"
"いけもと 池本"
"いけもり 池森"
"いけや 池谷"
"いけやま 池山"
"いけわき 池脇"
"いけん 威権 遺賢 異見 違憲 意見"
"いけんばこ 意見箱"
"いげた 井桁"
"いげん 威嚴 遺言 異言 威厳"
"いげんびょう 医原病"
"いこ 遺孤 依怙"
"いこーる ≠ ≒ ＝"
"いこい 憩 憩い"
"いこう 維綱 胃腔 偉効 異香 偉功 衣桁 移項 威光 遺稿 遺構 意向 移行 以降"
"いこく 異国"
"いこじ 意固地"
"いこつ 遺骨"
"いこま 居駒 生駒"
"いこみ 鋳込み"
"いこみき 已己巳己"
"いこん 意根 遺恨"
"いご 伊語 囲碁 以後"
"いごう 意業 伊号"
"いごころ 居心"
"いごん 遺言"
"いさ 諌 伊佐 異差"
"いさい 偉才 異彩 異才 委細"
"いさお 勇雄 烈 勳 勲男 勇夫 功 勲"
"いさおし 功 勲"
"いさか 伊坂 井坂"
"いさかい 諍 諍い"
"いさき 鶏魚 伊佐木"
"いさく 遺作"
"いさこ いさ子"
"いさご 砂 沙 砂子 砂金"
"いささか 些か 聊か"
"いさつ 縊殺"
"いさな 小魚 細小魚 鯨魚 勇魚"
"いさはや 諌早 諫早"
"いさはら 井佐原"
"いさみ 勇"
"いさみあし 勇足 勇み足"
"いさみはだ 勇み肌"
"いさむ 勳 勲 勇"
"いさやま 諌山"
"いさり 漁"
"いさりび 漁火"
"いさわ 伊澤 井澤 伊沢 井沢 石和"
"いさん 違算 胃散 胃酸 遺産"
"いざい 偉材 異材"
"いざかや 居酒屋"
"いざき 伊崎 井崎"
"いざけ 居酒"
"いざなぎ 伊弉諾 伊邪那岐"
"いざなぎのみこと 伊弉諾尊 伊邪那岐命"
"いざなみ 伊弉冉 伊邪那美"
"いざやしょ イザヤ書"
"いざよい 十六夜"
"いざよいのつき 十六夜の月"
"いざり 躄"
"いざりうお 躄魚"
"いざわ 伊澤 伊沢 井沢"
"いし 遺思 頤指 頤使 遺子 遺址 縊死 遺志 意志 意思 医師 石"
"いしあたま 石頭"
"いしい 石井"
"いしいも 石芋"
"いしうす 石臼"
"いしうち 石打"
"いしおか 石岡"
"いしおざん 石尾山"
"いしかべ 石壁"
"いしかめ 石亀"
"いしかり 石狩"
"いしかりなべ 石狩鍋"
"いしかわ 石河 石川"
"いしかわじゅん 石川淳"
"いしがき 石垣"
"いしがに 石蟹"
"いしがね 石金"
"いしがま 石鎌 石釜 石窯"
"いしがみ 石上 石神"
"いしがめ 石亀"
"いしがわら 石瓦"
"いしき 臀 伊敷 意識"
"いしきのながれ 意識の流れ"
"いしきりば 石切り場 石切場"
"いしきれべる 意識レベル"
"いしく 石工"
"いしくに 石國"
"いしくら 石倉"
"いしくれ 石塊"
"いしぐみ 石組 石組み"
"いしぐろ 石黒"
"いしぐろけん 石黒賢"
"いしけり 石蹴り"
"いしげ 石下 石毛"
"いしこ 石子"
"いしこし 石越"
"いしころ 石ころ 石塊"
"いしごう 石郷"
"いしごおり 石氷"
"いしざか 石坂"
"いしざき 石崎"
"いしざら 石皿"
"いしざわ 石沢 石澤"
"いしした 石下"
"いししょう 異嗜症"
"いしじ 石地"
"いしじま 石嶋 石島"
"いしず 石津"
"いしずえ 礎"
"いしずか 石塚"
"いしずけ 石附"
"いしずみ 石炭"
"いしそね 石曽根"
"いしぞね 石曽根"
"いしだ 石田"
"いしだい 石鯛"
"いしだか 石高"
"いしだかみち 石高道"
"いしだたみ 甃 石畳"
"いしだん 石段"
"いしつ 遺失 異質"
"いしつか 石塚"
"いしつぶて 石つぶて 石礫"
"いしつみ 石積み"
"いしづ 石津"
"いしづえ 礎"
"いしづか 石塚"
"いしづき 石突 石突き 鐓"
"いしづくり 石作り 石造り"
"いしづけ 石附"
"いしづみ 石積み"
"いしでら 石寺"
"いしとうろう 石燈篭"
"いしとび 石飛"
"いしどう 石堂"
"いしどうろう 石灯籠"
"いしどこ 石床"
"いしどりや 石鳥谷"
"いしなぎ 石投"
"いしなげ 石投げ"
"いしなべ 石鍋"
"いしぬき 石貫"
"いしの 石野"
"いしのまき 石巻"
"いしのみ 石鑿"
"いしのもり 石之森"
"いしはた 石畑"
"いしはま 石浜"
"いしはら 石原"
"いしはり 石播"
"いしば 石場"
"いしばい 石灰"
"いしばし 石橋"
"いしばち 石鉢"
"いしばり 石張り"
"いしびつ 石櫃"
"いしぶし 石伏"
"いしぶみ 石文 碑"
"いしへん 石偏"
"いしべ 石辺 石部"
"いしべい 石塀"
"いしべきんきち 石部金吉"
"いしぼとけ 石仏"
"いしま 石間"
"いしまき 石巻"
"いしまつ 石松"
"いしまる 石丸"
"いしみ 石見"
"いしみち 石道"
"いしみつ 石光"
"いしみね 石嶺"
"いしむら 石村"
"いしむれ 石牟礼"
"いしむろ 石室"
"いしめ 石目"
"いしもた 石母田"
"いしもだ 石母田"
"いしもち 石首魚 石持"
"いしもと 石元 石本"
"いしもり 石森"
"いしゃ 慰藉 慰謝 医者"
"いしや 石屋"
"いしやかわしゃこ 石屋川車庫"
"いしやき 石焼き 石焼"
"いしやきいも 石焼芋 石焼き芋"
"いしやま 石山"
"いしやまざか 石山坂"
"いしやまでら 石山寺"
"いしゅ 縊首 遺珠 意趣 異株 異種"
"いしゅう 伊州 遺習 蝟集 異臭"
"いしゅうち 意趣討ち"
"いしゅく 委縮 蝟縮 畏縮 萎縮"
"いしゅつ 移出"
"いしゅばらし 意趣晴らし"
"いしゆみ 石弓 弩"
"いしょ 緯書 移書 異書 医書 遺書"
"いしょう 遺詔 囲障 異称 意匠 衣裳 衣装"
"いしょうがえ 衣装替"
"いしょうけーす 衣装ケース"
"いしょうだな 衣装棚"
"いしょうだんす 衣装箪笥"
"いしょく 依嘱 異食 衣食 異色 委嘱 移植"
"いしょくごて 移植ごて 移植鏝"
"いしょくじゅう 衣食住"
"いしょくどうげん 医食同源"
"いしわおんせん 石和温泉"
"いしわた 石渡 石綿"
"いしわたり 石渡"
"いしわら 石原"
"いしわり 石割り 石割"
"いしん 異心 遺臣 以深 威信 維新"
"いしんでんしん 以心伝心"
"いしんりき 維新力"
"いじ 依恃 意字 依次 医治 異事 遺事 異時 位次 異字 遺児 医事 意地 維持"
"いじち 伊地知"
"いじっぱり 意地っ張り"
"いじめ 苛め"
"いじめっこ いじめっ子"
"いじめられっこ いじめられっ子 苛められっ子"
"いじゃく 胃弱"
"いじゅう 移住"
"いじゅういん 伊集院"
"いじゅうけん 居住権"
"いじゅつ 医術"
"いじょう ≧ 囲繞 移乗 委譲 移譲 異状 異常 以上"
"いじょうふ 偉丈夫"
"いじょうぷりおん 異常プリオン"
"いじょく 居職"
"いじら 伊自良"
"いじり 井尻"
"いじるし 井印"
"いじわる 意地悪"
"いじん 異人 偉人"
"いす 柞 倚子 椅子"
"いすい 渭水"
"いすう 異数 位数"
"いすか 交喙"
"いすけ 伊介"
"いすず いすゞ"
"いすずがわ 五十鈴川"
"いすとりげーむ 椅子取りゲーム"
"いすのき 柞"
"いすばい 柞灰"
"いすみ 伊角 夷隅"
"いすみぐんし 夷隅郡市"
"いすらえるぐん イスラエル軍"
"いすらむきょう イスラム教"
"いすらむけん イスラム圏"
"いすらむぶんか イスラム文化"
"いすらむほう イスラム法"
"いすらむれき イスラム暦"
"いず 伊津 伊豆"
"いずい 泉井"
"いずかた 何方"
"いずきゅう 伊豆急"
"いずくんぞ 焉んぞ 焉"
"いずこ 何処"
"いずし 出石"
"いずしま 出島"
"いずしやき 出石焼"
"いずた 泉田"
"いずち 何方"
"いずつ 井筒"
"いずぬま 伊豆沼"
"いずはら 厳原"
"いずまい 居住い 居住まい 居ずまい"
"いずみ 偉津美 五住 湶 出水 和泉 泉"
"いずみおおつ 泉大津"
"いずみかわ 泉川"
"いずみがおか 泉ヶ丘"
"いずみがたけ 泉ヶ岳"
"いずみがわ 泉川"
"いずみきょうか 泉鏡花"
"いずみく 泉区"
"いずみごう 泉郷"
"いずみさき 泉崎"
"いずみさの 泉佐野"
"いずみたに 泉谷"
"いずみだ 泉田"
"いずみちゅうおう 泉中央"
"いずみどの 泉殿"
"いずみや 泉谷"
"いずみやま 泉山"
"いずも 出雲"
"いずもざき 出雲崎"
"いずものくに 出雲国"
"いずれ 孰れ 何れ"
"いずれか 何れか"
"いせ 伊勢"
"いせい 遺精 遺制 為政 異星 以西 威勢 異性"
"いせいけん 遺生研"
"いせえび 伊勢エビ"
"いせおきつ 伊勢奥津"
"いせき 偉績 遺蹟 井関 移籍 遺跡"
"いせさき 伊勢左木 伊勢崎"
"いせざき 伊勢佐木 伊勢崎"
"いせたん 伊勢丹"
"いせだ 伊勢田"
"いせつ 異説 移設"
"いせはら 伊勢原"
"いせまいり 伊勢参り"
"いせもと 伊勢本"
"いせり 井芹"
"いせん 胃腺 以浅 伊仙 緯線"
"いせんこう 胃穿孔"
"いせんじょう 胃洗浄"
"いぜき 井関"
"いぜな 伊是名"
"いぜん 已然 依然 以前"
"いそ 五十 磯"
"いそう 遺草 意想 移相 異相 位相 移送"
"いそうお 磯魚"
"いそうろう 居候"
"いそがい 磯貝"
"いそがみ 磯上"
"いそぎあし 急ぎ足"
"いそぎんちゃく 磯巾着"
"いそく 夷則"
"いそご 磯子"
"いそざお 磯竿"
"いそざき 磯崎"
"いそし 勤し"
"いそしぎ 磯鷸"
"いそじ 五十 磯路"
"いそじまん 磯自慢"
"いそじん 磯陣"
"いそだ 礒田 磯田"
"いそっぷものがたり イソップ物語"
"いそづり 磯釣り"
"いそていえん 磯庭園"
"いそとし 五十年"
"いそなみ 磯波"
"いその 磯野"
"いそぶし 磯節"
"いそべ 磯辺 磯部"
"いそほものがたり 伊曾保物語"
"いそま 磯間"
"いそまつ 磯松"
"いそまつもく イソマツ目"
"いそみち 磯道"
"いそむら 磯村"
"いそめ 磯蚯蚓"
"いそもじ 急文字"
"いそや 磯谷"
"いそやま 礒山 磯山"
"いそん 依存"
"いそんひん 易損品"
"いぞう 以蔵 遺贈"
"いぞく 異俗 異族 遺族"
"いぞり 居反り"
"いぞん 異存 依存"
"いぞんせき 依存積"
"いぞんわ 依存和"
"いた 痛 板"
"いたあつ 板厚"
"いたい 板井 異体 遺体"
"いたいいたいびょう イタイイタイ病"
"いたいけ 幼気"
"いたいし 板石"
"いたいめ 痛い目"
"いたかぶ 板株"
"いたかべ 板壁"
"いたがき 板垣"
"いたがこい 板囲い"
"いたがね 鈑 板金"
"いたがみ 板紙"
"いたがらす 板ガラス 板硝子"
"いたきれ 板切れ"
"いたく 依託 委託"
"いたくら 板倉"
"いたけだか 居丈高"
"いたこ 板子 潮来"
"いたこぶし 潮来節"
"いたご 板子"
"いたさと 板里"
"いたさん 板さん"
"いたざい 板材"
"いたざき 板崎"
"いたしかた 致し方"
"いたしかゆし 痛し痒し"
"いたしゃ 痛車"
"いたしんどう 板振動"
"いたじき 板敷"
"いたじょう 板状"
"いたずき 病"
"いたずら 徒ら 徒 悪戯"
"いたずらに 徒に"
"いたずり 板摺り"
"いただき 戴き 頂 頂き"
"いただきます 戴きます"
"いただたみ 板畳"
"いただに 板谷"
"いたち 鼬"
"いたちうお 鼬魚"
"いたちごっこ 鼬ごっこ"
"いたちょう 板長"
"いたちょこ 板チョコ"
"いたって 至って"
"いたつき 板付き"
"いたづけ 板付"
"いたづら 惡戲 悪戯"
"いたで 痛手"
"いたでん イタ電"
"いたど 板戸"
"いたどこ 板床"
"いたどり 板取"
"いたに 猪谷"
"いたの 板野"
"いたのま 板の間"
"いたのり 板海苔"
"いたはし 板橋"
"いたば 板場"
"いたばさみ 板挟み"
"いたばし 板橋"
"いたばね 板発条"
"いたばり 板張 板張り"
"いたひょうめん 板表面"
"いたびさし 板廂 板庇"
"いたびょうし 板表紙"
"いたぶんこ 板文庫"
"いたべい 板塀"
"いたま 板間"
"いたまえ 板前"
"いたみ 痛み 伊丹"
"いたみどめ 痛み止め"
"いたみわけ 傷み分け"
"いため 炒め 板目"
"いためし イタ飯"
"いためなべ 炒め鍋"
"いためん 板面"
"いたもち 板持"
"いたや 板矢 板屋 板谷"
"いたやがい 板屋貝"
"いたやなぎ 板柳"
"いたやね 板屋根"
"いたよせ 板寄"
"いたらぬ 至らぬ"
"いたり 至り"
"いたりー 伊太利"
"いたりあ 伊太利屋 伊太利亜"
"いたりあご イタリア語"
"いたりあさん イタリア産"
"いたりあじん イタリア人"
"いたりあせい イタリア製"
"いたりあぶんがく イタリア文学"
"いたりありょうり イタリア料理"
"いたりっくたい イタリック体"
"いたる 格 到 至"
"いたるところ 到る所 至る所"
"いたれりつくせり 至れり尽せり 至れり尽くせり"
"いたわさ 板わさ 板山葵"
"いたわり 功 板割 板割り 労り"
"いたん 医療技術短期大学部 医短 異端"
"いたんちょう イ短調"
"いだ 委佗 伊田 井田"
"いだい 医大 偉大"
"いだいさ 偉大さ"
"いだし 出"
"いだしぐるま 出車"
"いだつ 遺脱"
"いだてん 韋駄天"
"いだん イ段"
"いち Ｉ 1 １ 依遅 伊知 壹 弌 壱 市 位置 一"
"いちあく 一握"
"いちあくのすな 一握の砂"
"いちあん 一案"
"いちい 一葦 一井 市井 櫟 一意 一位"
"いちいたいすい 一衣帯水"
"いちいち 一一 一々"
"いちいん 一院 一因 一員"
"いちいんとうてい 一韻到底"
"いちう 一宇"
"いちえ 一会"
"いちえいが 一映画"
"いちえねるぎー 位置エネルギー"
"いちえん 一円"
"いちえんだま 一円玉"
"いちおう 一往 一応"
"いちおうふく 一往復"
"いちおく 一億"
"いちおし 一推し 一押し"
"いちおん 一音"
"いちかい 市貝"
"いちかいいん 一会員"
"いちかいそう 一階層"
"いちかたい 一方井"
"いちかたりゅう 都方流 一方流"
"いちかばちか 一か八か"
"いちから 一から"
"いちかわ 市川"
"いちかわふさえ 市川房枝"
"いちかんたい 一艦隊"
"いちがい 一概"
"いちがいに 一概に"
"いちがお 市ヶ尾"
"いちがくしょう 一楽章"
"いちがくせい 一学生"
"いちがくねん 一学年"
"いちがしら 市頭"
"いちがっき 一学期"
"いちがつ 睦月 １月 一月"
"いちがめん 一画面"
"いちがや 市ケ谷 市谷 市ヶ谷"
"いちがん 一丸 一眼"
"いちがんれふ 一眼レフ"
"いちき 市來 一木 市来"
"いちきしゅ 一機種"
"いちぎ 一義"
"いちぎゅうめいち 一牛鳴地"
"いちぎょう １行 一行"
"いちく 移築"
"いちくら 肆"
"いちぐう 一遇 一隅"
"いちぐん 一軍 一群"
"いちけいたい 一形態"
"いちけいとう 一系統"
"いちけん 一研"
"いちけんしき 一見識"
"いちけんとう 一検討"
"いちげ 市毛"
"いちげい 一芸"
"いちげき 一撃"
"いちげつさんしゅう 一月三舟"
"いちげん 壱源 一弦 一限 一元 一見 一言"
"いちげんきん 一弦琴"
"いちげんさん 一見さん"
"いちこ 伊智子 神巫 巫子 市子 一子"
"いちこう 一高"
"いちこうさつ 一考察"
"いちこうもく 一項目"
"いちこくみん 一国民"
"いちこし 市越"
"いちこじん 一個人"
"いちこたい 一個体"
"いちこつ 壱越"
"いちご 莓 一語 一期 苺"
"いちごあじ イチゴ味"
"いちごいちじゅう 一伍一什"
"いちごいろ 苺色"
"いちごう 壱号 一合 一号"
"いちごがり いちご狩り"
"いちごん 一言"
"いちさんかしゃ 一参加者"
"いちざ 一座"
"いちし 一志"
"いちしじん 一私人"
"いちしちょうしゃ 一視聴者"
"いちしみん 一市民"
"いちしゅうきょう 一宗教"
"いちしゅぞく 一種族"
"いちしゅほう 一手法"
"いちしょうじょ 一少女"
"いちしょうじょう 一症状"
"いちしんきょう 一神教"
"いちじ １次 １時 一児 一事 一字 一次 一時"
"いちじく 一軸 無花果"
"いちじさんぴん 一次産品"
"いちじつ 一日"
"いちじつさんしゅう 一日三秋"
"いちじのがれ 一時逃れ"
"いちじふぁいる 一時ファイル"
"いちじふさいり 一事不再理"
"いちじま 市嶋 市島"
"いちじみゃく 一次脈"
"いちじゅ 一樹"
"いちじゅう 一汁 一重"
"いちじゅういっさい 一汁一菜"
"いちじゅん 一旬 一順 一巡"
"いちじょ 一女 一助"
"いちじょう 一城 一畳 一定 一場 一条"
"いちじょうじ 一乗寺"
"いちじん 一陣"
"いちじんえい 一陣営"
"いちじんぶつ 一人物"
"いちすぎ 一杉"
"いちず 一頭 一途"
"いちせ 一瀬"
"いちせいぶつ 一生物"
"いちせいぶん 一成分"
"いちせたい 一世帯"
"いちぜん 一膳"
"いちそうさ 一走査"
"いちそくめん 一側面"
"いちぞく 一族"
"いちぞくろうどう 一族郎党"
"いちぞん 一存"
"いちたいいち 一対一"
"いちたいた 一対多"
"いちたに 市谷"
"いちたへん 一夕偏"
"いちたろう 市太郎 一太郎"
"いちたんご 一単語"
"いちだ 伊地田 市田 一朶 一打"
"いちだい 一台 一代 一大"
"いちだいじ 一大事"
"いちだくせんきん 一諾千金"
"いちだん 一団 一段"
"いちだんらく 一段落"
"いちちほうとし 一地方都市"
"いちぢ 伊知地"
"いちづけ 位置づけ"
"いちてんき 一転機"
"いちとくせい 一特性"
"いちとし 一都市"
"いちど １度 一度"
"いちどう 一道 一堂 一同"
"いちどき 一時"
"いちどく 一読"
"いちな 一名"
"いちなん 一難"
"いちに 一二"
"いちにち １日 一日"
"いちにちいちぜん 一日一善"
"いちにちのばし 一日延ばし"
"いちにょ 一如"
"いちにん 一人 一任"
"いちにんしょう 一人称"
"いちにんとうせん 一人当千"
"いちねん 一念 一年"
"いちねんそう 一年草"
"いちの 市野"
"いちのう 一能"
"いちのおり 一の折"
"いちのき 一の樹"
"いちのぎく 市乃菊 市之菊"
"いちのくら 一の倉 一ノ倉 一ノ蔵"
"いちのせ 一野瀬 一の瀬 市之瀬 一瀬 一ノ瀬"
"いちのせき 一ノ関 一関"
"いちのちょう 一の町"
"いちのつかさ 市司"
"いちのへ 一戸"
"いちのぼう 一の坊"
"いちのみや 一ノ宮 一の宮 一宮"
"いちのもと 檪本 櫟本"
"いちのや 一の矢"
"いちはさま 一迫"
"いちはざま 一迫"
"いちはし 市橋"
"いちはた 一畑"
"いちはつ 鳶尾"
"いちはな 一端"
"いちはやく いち早く"
"いちはら 市原"
"いちはらの 市原野"
"いちば 市庭 一馬 一場 市場"
"いちばい 一倍"
"いちばた 一畑"
"いちばつひゃっかい 一罰百戒"
"いちばん 壱番 一番"
"いちばんいや 一番嫌"
"いちばんおく 一番奥"
"いちばんそこ 一番底"
"いちばんそと 一番外"
"いちばんとく 一番得"
"いちばんどり 一番鶏"
"いちばんのり 一番乗"
"いちばんはし 一番端"
"いちばんひだり 一番左"
"いちばんぼし 一番星"
"いちばんみぎ 一番右"
"いちばんやり 一番槍"
"いちばんらく 一番楽"
"いちひめ 市姫"
"いちひめにたろう 一姫二太郎"
"いちびょう 一秒"
"いちびょうそくさい 一病息災"
"いちびん 一便"
"いちぶ 一分 一部"
"いちぶつ 一物"
"いちぶん 一聞 一分 一文"
"いちへいし 一兵士"
"いちへんせい 一編成"
"いちべくとる 位置ベクトル"
"いちべつ 一別 一瞥"
"いちぺーじ 一頁 一ページ"
"いちほうこう 一方向"
"いちほうし 一法師"
"いちほうほう 一方法"
"いちぼう 一望"
"いちぼく 一木"
"いちぼくいっそう 一木一草"
"いちまい 一枚"
"いちまいいた 一枚板"
"いちまいいわ 一枚岩"
"いちまいがい 一枚貝"
"いちまつ 一松 一抹 市松"
"いちまん 一萬 一万"
"いちまんえん 壱萬圓 壱万円"
"いちみ 一味"
"いちみゃく 一脈"
"いちむら 一村 市村"
"いちめ 市女"
"いちめい 一命 一名"
"いちめがさ 市女笠"
"いちめん 一面"
"いちめんしき 一面識"
"いちもう 一毛 一望"
"いちもうだじん 一網打尽"
"いちもく 一目"
"いちもくさん 一目散"
"いちもじ １文字 一文字"
"いちもつ 逸物 一物"
"いちもん 一問 一文 一門"
"いちもんいっとう 一問一答"
"いちもんきなか 一文半銭"
"いちや 一夜"
"いちやく 一役 一躍"
"いちやづけ 一夜漬"
"いちやなぎ 一柳"
"いちゅう 移駐 意中"
"いちゆう 一揖"
"いちょ 遺著"
"いちょう 威張 異聴 鴨脚樹 移牒 異朝 公孫樹 移調 医長 銀杏 胃腸"
"いちょういも 銀杏芋"
"いちょうこう イチョウ綱"
"いちょうちょう イ長調"
"いちよ 市代"
"いちよう 一葉 一様"
"いちようそ 一要素"
"いちようらいふく 一陽来復"
"いちよく 一翼"
"いちよし 市吉"
"いちらん 壹覽 一蘭 一覧"
"いちらんせい 一卵性"
"いちり 一里 一利 一理"
"いちりいちがい 一利一害"
"いちりき 一力"
"いちりつ 一率 市立 一律"
"いちりづか 一里塚"
"いちりの 一里野"
"いちりゅう 一留 一粒 一流"
"いちりゅうば 一流馬"
"いちりょう 一両"
"いちりょういき 一領域"
"いちりょうじつ 一両日"
"いちりようしゃ 一利用者"
"いちりん 一輪"
"いちりんか 一輪花"
"いちりんざし 一輪挿し"
"いちる 一縷"
"いちるい 一類 一塁"
"いちれい 一礼 一例"
"いちれつ 一列"
"いちれん 一蓮 一連"
"いちろ 一路"
"いちろう 市郎 一朗 一郎 一浪"
"いちろうた 一朗太"
"いちろくぎんこう 一六銀行"
"いちろん 一論"
"いちわ 一羽 一話"
"いちわり 一割"
"いちわりびき 一割引"
"いっ 逸"
"いっか 一顆 一下 一価 一和 一課 一過 一家"
"いっかい １Ｆ １回 一塊 一階 一回 一介"
"いっかいてん 一回転"
"いっかく 一獲 一劃 一廓 一攫 一郭 一画 一角"
"いっかくじゅう 一角獣"
"いっかげつ １か月 １ヶ月 一箇月 一カ月 一ヶ月"
"いっかげん 一家言"
"いっかごん 一家言"
"いっかしょ 一か所 一ヶ所 一カ所 一箇所"
"いっかつ 一喝 一括"
"いっかん 一管 一巻 一貫 一環"
"いっき 一輝 一機 一季 一騎 逸機 一期 一揆 一気"
"いっきいちゆう 一喜一憂"
"いっきうち 一騎打 一騎討ち"
"いっきかせい 一気呵成"
"いっきく 一掬"
"いっきつうかん 一気通貫"
"いっきとうせん 一騎当千"
"いっきに 一気に"
"いっきのみ 一気飲み"
"いっきゃく 一脚"
"いっきゅう 一球 一休 一級"
"いっきょ 逸居 一挙"
"いっきょいちどう 一挙一動"
"いっきょう 一驚 一興"
"いっきょく 一局 一極 一曲"
"いっきょりょうどく 一挙両得"
"いっきん 一金 一斤"
"いっく 一区 一句"
"いっけい 一型 一景 一系 一計"
"いっけいあくせんと 一型アクセント"
"いっけつ 溢血 一決 一穴"
"いっけん 一間 一軒 一件 一見"
"いっけんしき 一見識"
"いっけんや 一軒家"
"いっけんやど 一軒宿"
"いっこ 一ヶ 一箇 一己 一顧 一戸 一個"
"いっこう 溢口 一鉤 一稿 一幸 一項 一考 一向 一行"
"いっこく 一国 一刻"
"いっこくにせいど 一国二制度"
"いっこてん 一壺天"
"いっこん 一献"
"いっこんぞめ 一斤染"
"いっさ 一茶"
"いっさい 一済 一際 一歳 一再 一妻 一切"
"いっさいきょう 一切経"
"いっさいてん 一斎点"
"いっさく 一昨 一作 一策"
"いっさくじつ 一昨日"
"いっさつ 一札 一冊"
"いっさんか 一酸化"
"いっし 逸史 一死 一紙 一志 一指 一子 一糸 一矢"
"いっしあい 一試合"
"いっしき 一色 一式"
"いっしつ 一失 逸失 一室"
"いっしどうじん 一視同仁"
"いっしゃ 一者 一社"
"いっしゃせん 一車線"
"いっしゃせんり 一瀉千里"
"いっしゅ 一首 一種"
"いっしゅう 一週 壱州 一蹴 一周"
"いっしゅく 一宿"
"いっしゅつ 逸出"
"いっしゅん 一瞬"
"いっしょ 佚書 逸書 一所 一書 一緒"
"いっしょう 一勝 一章 一将 一笑 一升 一生"
"いっしょうがい 一生涯"
"いっしょうせつ 一小節"
"いっしょうびん 一升瓶"
"いっしょうもの 一生もの 一生モノ"
"いっしょく 一食 一色"
"いっしょくそくはつ 一触即発"
"いっしょくた 一緒くた"
"いっしん 一針 一審 一身 一心 一新"
"いっしんいったい 一進一退"
"いっしんきょう 一神教"
"いっしんとう 一親等"
"いっしんろん 一神論"
"いっすい 一穂 一炊 溢水 一睡"
"いっすん 一寸"
"いっすんぼうし 一寸法師"
"いっせ 一瀬 一世"
"いっせい 一誠 一成 一生 一世 一声 一斉"
"いっせいに 一斉に"
"いっせき 一夕 一席 一隻 一石"
"いっせつ 一説 一節"
"いっせつたしょう 一殺多生"
"いっせつな 一刹那"
"いっせん 一洗 一煎 一千 一閃 一銭 一戦 一線"
"いっそ 一層 不如 一噌"
"いっそう 一左右 逸走 一双 一掃 一層"
"いっそく 一束 一足"
"いったい 一隊 一帯 一体"
"いったいいち 一対一"
"いったいだれ 一体誰"
"いったいなに 一体何"
"いったく 一卓 一択"
"いったん 一たん 一箪 一短 一反 一端 一旦"
"いっち 一致"
"いっちはんかい 一知半解"
"いっちゃく 一着"
"いっちゅう 一籌 一中"
"いっちゅうぶし 一中節"
"いっちゅうや 一昼夜"
"いっちょう 一張 一長 一兆 一朝 一聴 一丁"
"いっちょういっし 一張一弛"
"いっちょうめ １丁目"
"いっちょうら 一張羅"
"いっちょくせん 一直線"
"いっちょまえ 一丁前"
"いっつい 一対"
"いっつう 一通"
"いって 一手"
"いってい 一定"
"いっていじ 一丁字"
"いってき 一擲 一滴"
"いってこい 行って来い"
"いってつ 一徹"
"いってん 一天 一転 一点"
"いっと 一兎 一都 一斗 一途"
"いっとう 一灯 一統 一投 一刀 一党 一頭 一等"
"いっとうさい 一刀斉"
"いっとうしん 一等親"
"いっとうせい 一等星"
"いっとうぼり 一刀彫り 一刀彫"
"いっとき 一時"
"いっとく 一得"
"いっとさんけん 一都三県"
"いっぱ 一波 一派"
"いっぱい 一敗 一杯"
"いっぱく 一白 一拍 一泊"
"いっぱし 一端"
"いっぱつ 一髪 一発"
"いっぱつどり 一発録り"
"いっぱん 一斑 一半 一飯 一班 一版 一般"
"いっぱんうけ 一般受"
"いっぱんむき 一般向"
"いっぱんゆーざ 一般ユーザ"
"いっぱんゆーざー 一般ユーザー"
"いっぴ １日"
"いっぴき 一匹"
"いっぴきおおかみ 一匹狼"
"いっぴつ 一筆"
"いっぴょう 一瓢 一票"
"いっぴん 逸品 一品"
"いっぴんいっしょう 一顰一笑"
"いっぷ 一夫"
"いっぷいっぷ 一夫一婦"
"いっぷう 一封 一風"
"いっぷく 一腹 一幅 一服"
"いっぷん １分 一分"
"いっぺい 一兵 一平"
"いっぺき 一碧"
"いっぺん 一偏 一篇 一遍 一編 一辺 一片 一変"
"いっぺんとう 一辺倒"
"いっぽ 一歩"
"いっぽう 一法 一報 一方"
"いっぽん 一本"
"いっぽんあし 一本足"
"いっぽんがたな 一本刀"
"いっぽんぎ 一本気"
"いっぽんさ 一本鎖"
"いっぽんすぎ 一本杉"
"いっぽんぜおい 一本背負い 一本背負"
"いっぽんまつ 一本松"
"いっぽんみち 一本道"
"いっぽんやり 一本槍"
"いっぽんゆび 一本指"
"いつ 伍 乙 弌 壹 壱 五 一 鴪 聿 鎰 溢 軼 佚 逸 厳 稜威 何時"
"いつう 胃痛"
"いつお 逸生 厳夫"
"いつか ５日 何時か 五日"
"いつき 樹 五紀 五月 五木 斎"
"いつきだ 五木田"
"いつきめ 斎女"
"いつくしま 厳島"
"いつくしみ 慈しみ"
"いつこ 伊都子"
"いつごろ いつ頃"
"いつざい 逸材"
"いつしか 何時しか"
"いつじ 軼事 逸事"
"いつぞんそうしょ 佚存叢書"
"いつだつ 逸脱"
"いつつ ５つ 五つ"
"いつつばし 五橋"
"いつつぼし 五つ星"
"いつでも 何時でも"
"いつとものふみ 五部書"
"いつねんごう 逸年号"
"いつはし 五橋"
"いつぶつ 逸物"
"いつぶん 佚文 逸聞 逸文"
"いつまでぐさ 常春藤"
"いつまでも 何時迄も"
"いつみ 逸美 逸見"
"いつも 何時も"
"いつらく 逸楽"
"いつわ 五輪 五和 逸話"
"いつわり 偽り"
"いづ 伊津"
"いづつ 井筒"
"いづな 飯綱"
"いづはら 出原 厳原"
"いづぶち 出渕"
"いづれ 孰れ 何れ"
"いて 射手"
"いてき 夷狄"
"いてん 移点 移転"
"いで 出澤 井手 井出 出"
"いであろん イデア論"
"いでい 出居"
"いでさわ 出沢 出澤"
"いでたち 出で立ち"
"いでみつ 出光"
"いでむら 出村"
"いでゆ 出湯 出で湯"
"いでん 位田 異伝 遺伝"
"いでんあるごりずむ 遺伝アルゴリズム"
"いと 怡土 縷 異図 絲 伊都 意図 糸"
"いとーよーかどう イトーヨーカ堂"
"いとい 糸井"
"いといがわ 糸魚川"
"いとう 伊富 伊富魚 依投 以東 伊東 伊藤"
"いとうお 糸魚"
"いとうちゅう 伊藤忠"
"いとうはむ 伊藤ハム"
"いとうまん 伊藤萬"
"いとおり 糸織"
"いとが 糸賀"
"いときり 糸切り"
"いときりば 糸切歯 糸切り歯"
"いとく 懿徳 威徳 遺徳"
"いとくず 糸屑"
"いとぐち 緒 糸口"
"いとぐら 糸倉"
"いとぐるま 糸車"
"いとこ 従妹 従姉 従弟 従兄 従姉妹 従兄弟"
"いとこおおおじ 従兄弟大小父"
"いとこおおおば 従兄弟大小母"
"いとこん 糸コン"
"いとこんにゃく 糸コンニャク 糸こんにゃく 糸蒟蒻"
"いとさき 糸崎"
"いとざき 糸崎"
"いとざくら 糸桜"
"いとしご いとし子 愛し子"
"いとしま 糸島"
"いとじり 糸尻"
"いとすぎ 糸杉"
"いとぞこ 糸底"
"いとたけ 糸竹"
"いとたに 糸谷"
"いとだ 糸田"
"いとちゅう 伊藤忠"
"いとづくり 糸作り"
"いとでんわ 糸電話"
"いととじ 糸綴じ"
"いととんぼ 糸蜻蛉"
"いとなみ 営み"
"いとぬき 糸貫"
"いとのこ 糸鋸"
"いとのこぎり 糸鋸"
"いとひきあじ 糸引鰺"
"いとへん 糸偏"
"いとま 遑 暇"
"いとまき 糸巻"
"いとまごい 暇乞い"
"いとまん 糸満"
"いとめ 厭目 糸目"
"いとやま 糸山"
"いとゆう 糸遊"
"いとよ 糸魚"
"いとようじ 糸楊枝"
"いとより 糸縒り 糸撚り"
"いとよりだい 糸縒鯛"
"いど 異土 緯度 井戸"
"いどう 医道 異同 異動 移動"
"いどうだな 移動棚"
"いどころ 拠所 居所"
"いどし 亥年"
"いどばた 井戸端"
"いどべい 井戸塀"
"いどほり 井戸掘り"
"いどみず 井戸水"
"いな 稻 維那 伊南 伊那 伊奈 稲 否"
"いない 稲井 以内"
"いなえ 稲枝"
"いなお 稲生 稲尾"
"いなおおせどり 稲負鳥"
"いなおか 稲岡"
"いなおり 居直り"
"いなか 田舎"
"いなかざむらい 田舎侍"
"いなかず 稲数"
"いなかだて 田舎館"
"いなかっぺ 田舎っぺ"
"いなかみち 田舎道"
"いなかわ 稲川"
"いながき 稲垣"
"いながけ 稲掛"
"いながわ 稲川 猪名川"
"いなき 稲城 稲木"
"いなぎ 稲置 稲木 稲城"
"いなぐら 稲倉"
"いなげ 稲毛"
"いなこ 稲子"
"いなこと 異な事"
"いなご 蝗"
"いなさ 引佐"
"いなさく 稲作"
"いなさやま 稲佐山"
"いなざわ 稲沢"
"いなしき 稲敷"
"いなしろ 稲城"
"いなず 稲津"
"いなずま 電 霆 稲妻"
"いなせ 粹"
"いなたま 稲魂"
"いなだ 鰍 稲田"
"いなだき 頂"
"いなだま 稲魂"
"いなち 稲地"
"いなつき 稲築"
"いなつぎ 稲継"
"いなづ 稲津"
"いなづま 稲妻"
"いななが 稲永"
"いななき 嘶き"
"いなにわ 稲庭"
"いなの 稲野"
"いなば 稲場 因幡 稲葉"
"いなひさ 稲久"
"いなびかり 稲光"
"いなぶ 稲武"
"いなぶし 伊那節"
"いなぶね 稲舟"
"いなべ 員弁"
"いなほ 稲穂"
"いなみ 伊波 印南 稲美 井波"
"いなみね 稲嶺"
"いなむし 蝗"
"いなむら 稲村"
"いなもと 稲元"
"いなもり 稲盛 稲森"
"いなや 否や"
"いなよし 稲吉"
"いなり 稲荷"
"いなりずし 稲荷鮨"
"いなりだ 稲荷田"
"いなわしろ 猪苗代"
"いなわしろこ 猪苗代湖"
"いなん 以南"
"いにしえ 古え 古"
"いにゅう 移入"
"いにょう 遺尿 囲繞"
"いにん 委任"
"いぬ 戌 狗 犬"
"いぬい 戌亥 犬井 乾"
"いぬいもん 乾門"
"いぬかい 犬養 犬飼"
"いぬかいつよし 犬養毅"
"いぬかき 犬かき 犬掻き"
"いぬかみ 犬上"
"いぬがみ 犬神"
"いぬがみぐん 犬上郡"
"いぬくい 犬食い"
"いぬくぼう 犬公方"
"いぬぐい 犬喰い 犬食い"
"いぬころ 犬ころ"
"いぬごや 犬小屋"
"いぬざくら 犬桜"
"いぬじに 犬死に"
"いぬじにん 犬神人"
"いぬぞり 犬ぞり 犬橇"
"いぬたで 犬蓼"
"いぬちくしょう 犬畜生"
"いぬっころ 犬っころ"
"いぬつか 犬塚"
"いぬどし 戌年"
"いぬなき 犬鳴"
"いぬにく 犬肉"
"いぬねこ 犬猫"
"いぬのふぐり 犬の陰嚢"
"いぬは 犬派"
"いぬばしり 犬走 犬走り"
"いぬぶえ 犬笛"
"いぬぶし 犬伏"
"いぬぼう 犬棒"
"いぬぼうさき 犬吠埼 犬吠崎"
"いぬぼうざき 犬吠埼"
"いぬまる 犬丸"
"いぬめ 犬目"
"いぬやま 犬山"
"いぬよう 犬用"
"いね 禾 伊根 稻 稲"
"いねか 稲科 イネ科"
"いねかり 稲刈 稲刈り"
"いねだ 稲田"
"いねなが 稲永"
"いねの 稲野"
"いねみつ 稲光"
"いねもく イネ目"
"いねん 為念"
"いの 猪野 井野 伊野 猪"
"いのいちばん いの一番"
"いのう 衣嚢 稲生 伊能 異能"
"いのうえ 井之上 井上"
"いのうえてつじろう 井上哲次郎"
"いのうえやすし 井上靖"
"いのうただたか 伊能忠敬"
"いのおか 猪岡"
"いのかしら 井の頭"
"いのがしら 井の頭"
"いのき 猪木"
"いのくち 井口"
"いのくま 猪熊"
"いのぐち 井口 井ノ口"
"いのこ 豕 猪の子"
"いのこずち 牛膝"
"いのこへん 豕偏"
"いのさか 猪坂"
"いのしかちょう 猪鹿蝶"
"いのしし 猯 豕 亥 猪"
"いのししどし 亥年"
"いのししなべ 猪鍋"
"いのした 井下"
"いのせ 猪瀬"
"いのち 生命 命"
"いのちからがら 命辛辛 命辛々"
"いのちがけ 命がけ 命懸け"
"いのちごい 命乞い"
"いのちしらず 命知らず"
"いのちづな 命綱"
"いのちとり 命取り"
"いのちのつな 命の綱"
"いのちびろい 命拾い"
"いのなか 井の中"
"いのはら 猪原"
"いのふ 胃の腑"
"いのぶた 猪豚"
"いのべ 井ノ部"
"いのま 猪摩"
"いのまた 猪股 猪俣"
"いのまま 意のまま"
"いのめ 猪の目"
"いのり 祷 祈り"
"いのる 祷"
"いは 伊波"
"いはい 違背 位牌"
"いはく 曰く 医博 威迫"
"いはつ 衣鉢 遺髪"
"いはら 庵原 伊原 井原"
"いはん 違犯 違反"
"いば 井場 伊庭 射場"
"いばく 帷幕"
"いばしんえん 意馬心猿"
"いばら 井原 荊 棘 茨"
"いばらき 茨木 茨城"
"いばらぎ 茨城"
"いばらぎえき 茨木駅"
"いばらぎし 茨木市"
"いばらぎてん 茨木店"
"いばらのみち 茨の道"
"いばらももく イバラモ目"
"いばり 尿"
"いばん 異版"
"いひょう 違表 依憑 意表"
"いひん 遺品"
"いび 依微 威部 萎靡 揖斐"
"いびき 鼾"
"いびつ 飯櫃 歪"
"いびつなり 飯櫃形"
"いびょう 胃病"
"いふ 依附 委付 異父 畏怖"
"いふう 異風 遺風 威風"
"いふうどうどう 威風堂堂"
"いふく 威服 異腹 衣服"
"いぶ ＥＶＥ 伊武 威武 慰撫"
"いぶか 井深"
"いぶき 伊吹 息吹"
"いぶくろ 胃袋"
"いぶしぎん 燻し銀"
"いぶすき 指宿"
"いぶせ 井伏"
"いぶつ 遺物 異物"
"いぶり 胆振"
"いぶん 遺聞 遺文 異聞 異文"
"いぷしろん Ε ε"
"いぷしろんせんい ε遷移"
"いへき 胃壁"
"いへや 伊平屋"
"いへん 韋編 異変"
"いへんさんぜつ 韋編三絶"
"いべ 井部 伊部"
"いべんとれつ イベント列"
"いほう 異法 遺法 遺芳 異方 移封 彙報 異邦 違法"
"いほうこぴー 違法コピー"
"いほく 以北"
"いほん 異本"
"いぼ 贅 肬 揖保 疣 異母"
"いぼう 依傍 威望"
"いぼく 遺墨"
"いぼじ 疣痔"
"いぼだい 疣鯛"
"いま 居間 今"
"いまい 今井"
"いまいけ 今池"
"いまいじょう 今以上"
"いまいずみ 今泉"
"いまいち 今イチ 今市 今一"
"いまいっぽ 今一歩"
"いまいで 今出"
"いまいま 今今"
"いまおか 今岡"
"いまかがみ 今鏡"
"いまかれ 今彼"
"いまがね 今金"
"いまがわ 今川"
"いまがわやき 今川焼"
"いまき 今来"
"いまげんざい 今現在"
"いまこまち 今小町"
"いまころ 今頃"
"いまごろ 今ごろ 今頃"
"いまさき 今崎"
"いまさっき 今さっき"
"いまさと 今里"
"いまさら 今さら 今更"
"いまし 汝"
"いましがた 今しがた 今し方"
"いましばらく 今暫く"
"いましま 今嶋"
"いましめ 警め 誡め 縛め 戒め"
"いまじぶん 今時分"
"いまじょう 今城 今庄"
"いますこし 今少し"
"いまず 今津"
"いまぜき 今関"
"いまだ 今田 未 未だ"
"いまだて 今立"
"いまだに 未だに"
"いまち 井街"
"いまちづき 居待月"
"いまづ 今津"
"いまで 今出"
"いまど 今戸"
"いまどうしん 今道心"
"いまどき 今どき 今時"
"いまなお 今猶 今なお 今尚"
"いまなか 今仲 今中"
"いまなが 今永"
"いまに 今仁"
"いまにし 今西"
"いまにしきんじ 今西錦司"
"いまはし 今橋"
"いまはん 今半"
"いまばやし 今林"
"いまばり 今治"
"いまひと 今仁"
"いまひとつ 今一つ"
"いまふう 今風"
"いまふく 今福"
"いまふじ 今藤"
"いまべっぷ 今別府"
"いまべつ 今別"
"いままで 今まで 今迄"
"いまみち 今道"
"いまみや 今宮"
"いまむら 今村"
"いまむらさき 今紫"
"いまもって 今以て"
"いまものがたり 今物語"
"いまや 今や"
"いまやま 今山"
"いまよう 今様"
"いまよううた 今様歌"
"いまよし 今吉"
"いまりやき 伊万里焼"
"いまりゅう 今流"
"いまる 井丸"
"いまわ 今際"
"いまわだい 今話題"
"いまわの 忌野"
"いまわのきわ 今際の際"
"いみ 意味"
"いみあい 意味合 意味合い"
"いみあけ 忌み明け 忌明け"
"いみき 忌寸"
"いみことば 忌言葉 忌み詞 忌み言葉"
"いみしん 意味深"
"いみず 射水"
"いみな 諱"
"いみなし 意味無"
"いみび 忌み日 斎日 忌日"
"いみもの 忌み物 忌物 斎物"
"いみや 井宮"
"いみょう 異名"
"いみん 移民"
"いむ 諱 異夢 医務"
"いむら 井村"
"いめ 夢"
"いめーじけんさく イメージ検索"
"いめい 違名 威名 遺命 依命 異名"
"いも 妹 藷 薯 芋"
"いもあらし 芋嵐"
"いもあん 芋あん 芋餡"
"いもうと 妹"
"いもうとふうふ 妹夫婦"
"いもうとぶん 妹分"
"いもうとむこ 妹婿"
"いもうとやく 妹役"
"いもお 妹尾"
"いもかけどうふ 芋掛豆腐 芋掛け豆腐"
"いもかわ 芋川"
"いもがい 芋貝"
"いもがしら 芋頭"
"いもがま 芋竈"
"いもがゆ 芋粥"
"いもがら 芋幹 芋茎"
"いもざし 芋刺し"
"いもじ 湯文字 鋳物師"
"いもじょうちゅう 藷焼酎 芋焼酎"
"いもじる 芋汁"
"いもすけ 芋助"
"いもせ 妹背"
"いもたれ 胃もたれ"
"いもだい 芋台"
"いもちびょう 稲熱病"
"いもちゃしゃく 芋茶杓"
"いもつぎ 芋継ぎ"
"いもづる 芋蔓"
"いもづるしき 芋づる式"
"いもでんがく 芋田楽"
"いもと 妹 井元 井本"
"いもなっとう 芋納豆"
"いもに 芋煮"
"いもになべ 芋煮鍋"
"いもの 鋳物"
"いものこ 芋の子"
"いもはぎ 芋接ぎ"
"いもばん 芋版"
"いもびな 芋雛"
"いもほり 藷掘り 芋掘り"
"いもぼう 芋棒"
"いもむし 芋虫"
"いもめいげつ 芋名月"
"いもめし 芋飯"
"いもめじ 芋目地"
"いももと 芋本"
"いもようかん 芋羊羹"
"いもり 井森 井守"
"いもるい 芋類"
"いもん 慰問"
"いや 否 彌 弥 祖谷 厭 嫌"
"いやいとこ 弥従姉妹 弥従兄弟"
"いやいや 否否 嫌嫌 否々 嫌々"
"いやおう 否応"
"いやがうえにも 弥が上にも"
"いやがおう 否が応"
"いやがらせ 嫌がらせ"
"いやき 嫌気"
"いやく 依約 違約 意訳 医薬"
"いやけ 嫌気"
"いやけい 祖谷渓"
"いやし 癒やし 鄙 癒し"
"いやしくも 苟も"
"いやち 忌地"
"いやちこ 灼然"
"いやなが 彌永"
"いやま 井山"
"いやみ 厭み 厭味 嫌み 嫌味"
"いゆう 畏友"
"いよ 壱与 伊代 伊予"
"いよいよ 愈 愈々"
"いよう 偉容 威容 医用 異様"
"いよかん 伊予柑"
"いよく 意欲"
"いよこ 伊代子"
"いよじ 五代嗣"
"いよたに 伊豫谷"
"いよだ 伊與田"
"いよてつ 伊予鉄"
"いよぶし 伊予節"
"いら 苛"
"いらい 依頼 以来"
"いらいら 苛苛 苛々"
"いらいらかん イライラ感"
"いらえ 応え 答え"
"いらか 甍"
"いらくぐん イラク軍"
"いらくさ 刺草 蕁麻"
"いらくさもく イラクサ目"
"いらくじん イラク人"
"いらくせんそう イラク戦争"
"いらこ 伊良湖"
"いらこみさき 伊良湖岬"
"いらご 伊良湖"
"いらごみさき 伊良湖岬"
"いらだち 苛立ち"
"いらつ 苛つ"
"いらつこ 郎子"
"いらつめ 郎女"
"いらぶ 伊良部"
"いらべ 伊良部"
"いらぼ 伊羅保"
"いらん 伊蘭"
"いらんいらくせんそう イランイラク戦争"
"いらんくう 囲卵腔"
"いらんじん イラン人"
"いり 熬り 炒り 伊理 杁 圦 入 入り"
"いりあい 入相 入会"
"いりうち 入内"
"いりうみ 入海"
"いりえ 入り江 入江"
"いりおもて 西表"
"いりかさやま 入笠山"
"いりがい 入貝"
"いりき 入来"
"いりぐち 入口"
"いりこ 熬り子 熬海鼠 煎り粉 炒り粉 海参"
"いりごめ 煎り米 炒り米"
"いりさ 入佐"
"いりさく 入作"
"いりさわ 入澤"
"いりざけ 煎り酒"
"いりしお 入潮"
"いりすみ 入角 入隅"
"いりた 入田"
"いりたはま 入田浜"
"いりたまご 煎り卵 炒り卵"
"いりどうふ 煎り豆腐"
"いりなか 杁中"
"いりの 入野"
"いりはま 入浜 入り浜"
"いりひ 入り日"
"いりふね 入り船 入船"
"いりべ 入部"
"いりまじり 入交"
"いりまめ 煎豆 炒り豆"
"いりむこ 入り婿"
"いりもや 入母屋"
"いりもやづくり 入母屋造"
"いりや 入谷"
"いりやま 入山"
"いりゅう 遺留 移流 慰留"
"いりゅうぎり 移流霧"
"いりょう 衣糧 衣料 医療"
"いりょうみす 医療ミス"
"いりょく 意力 偉力 威力"
"いりよう 入用"
"いりわけ 入り訳"
"いるい 彙類 異類 衣類"
"いるか 鯆 海豚"
"いるかせ 忽"
"いるま 入間"
"いれ 入れ"
"いれい 違例 威令 慰霊 異例"
"いれいひ 慰霊碑"
"いれかえ 入換 入れ換え 入替"
"いれかた 淹れ方"
"いれき 入木"
"いれぐい 入れ食い"
"いれこ 入籠 入れ子"
"いれこみ 入込"
"いれずみ 文身 刺青 入れ墨"
"いれつ 威烈 い列 イ列"
"いれば 入歯 入れ歯"
"いれふだ 入れ札"
"いれぼくろ 入れ黒子"
"いれもの 容れ物"
"いろ 艷 色"
"いろあい 色相 色合 色合い"
"いろあく 色悪"
"いろあげ 色揚げ"
"いろあわせ 色合せ 色合わせ"
"いろいがい 色以外"
"いろいと 色糸"
"いろいろ 色いろ 色色 色々"
"いろう 胃瘻 遺漏 慰労"
"いろうざき 石廊崎"
"いろうつり 色移り"
"いろえ 色絵"
"いろえんぴつ 色鉛筆"
"いろおち 色落ち"
"いろおとこ 色男"
"いろおび 色帯"
"いろおんど 色温度"
"いろおんな 色女"
"いろか 色香"
"いろかず 色数"
"いろかわ 色川"
"いろかんけい 色関係"
"いろがたき 色敵"
"いろがみ 色紙"
"いろがら 色柄"
"いろがらす 色ガラス"
"いろがわり 色変り"
"いろきちがい 色気違い"
"いろきろく 色記録"
"いろくうかん 色空間"
"いろくさ 色草"
"いろくず 鱗"
"いろぐすり 色釉"
"いろぐるい 色狂い"
"いろぐろ 色黒"
"いろけ 色気"
"いろこ 色子"
"いろこい 色恋"
"いろこう 色校"
"いろこうせい 色校正"
"いろごと 色事"
"いろごのみ 色好み"
"いろさいげん 色再現"
"いろざと 色里"
"いろざんげ 色懺悔"
"いろしすう 色指数"
"いろしてい 色指定"
"いろしゅうさ 色収差"
"いろしんごう 色信号"
"いろじかけ 色仕掛け"
"いろじょうほう 色情報"
"いろじろ 色白"
"いろすう 色数"
"いろずり 色刷 色刷り"
"いろたいおう 色対応"
"いろだま 色玉"
"いろちがい 色違い"
"いろつき 色付き"
"いろつや 色艶"
"いろづかい 色遣い 色使い"
"いろづけ 色付 色付け"
"いろとりどり 色取り取り"
"いろどめ 色止め"
"いろどり 色鳥 色取り 彩り 彩"
"いろなおし 色直し"
"いろね 色音"
"いろは 以呂波 伊呂波"
"いろはいち 色配置"
"いろはうた 伊呂波歌"
"いろはじるいしょう 色葉字類抄"
"いろはんてん 色反転"
"いろばんごう 色番号"
"いろひょうじ 色表示"
"いろふごう 色符号"
"いろふん 色粉"
"いろぶみ 色文"
"いろぶんかい 色分解"
"いろほうしき 色方式"
"いろほせい 色補正"
"いろぼうしょ 色奉書"
"いろぼけ 色ボケ"
"いろまち 色街 色町"
"いろみ 色見"
"いろむら 色斑"
"いろめ 色目"
"いろめい 色名"
"いろめがね 色眼鏡"
"いろもの 色物"
"いろり 鈩 鑪 囲炉裏"
"いろりったい 色立体"
"いろりばた 囲炉裏端"
"いろわけ 色分 色分け"
"いろん 異論"
"いろんな 色んな"
"いわ 巖 磐 違和 岩"
"いわあな 岩穴"
"いわい 岩韋 磐井 岩井 祝い 祝"
"いわいうた 頌 祝唄 祝歌 祝い歌 祝い唄"
"いわいごと 祝事"
"いわいざけ 祝酒"
"いわいずみ 岩泉"
"いわいはら 岩井原"
"いわいべどき 祝部土器"
"いわうち 岩内"
"いわえのぐ 岩絵の具 岩絵具"
"いわお 岩生 岩雄 磐 岩夫 岩尾 岩男 巖 巌"
"いわおおじ 岩大路"
"いわおか 岩岡"
"いわかげ 岩陰"
"いわかど 岩角"
"いわかべ 岩壁"
"いわかみ 岩上"
"いわかめ 岩亀"
"いわかわ 岩川"
"いわがき 岩牡蠣"
"いわがに 岩蟹"
"いわき 岩鬼 岩木 磐城 岩城"
"いわきり 岩切"
"いわぎ 岩城"
"いわく 曰 曰く"
"いわくに 岩国"
"いわくま 岩熊"
"いわくら 岩鞍 岩倉"
"いわぐみ 岩組み 岩組"
"いわぐんじょう 岩群青"
"いわさ 岩佐"
"いわさき 岩崎"
"いわさわ 岩沢"
"いわし 鰛 鰮 鰯"
"いわしぐも 鰯雲"
"いわした 岩下"
"いわしみず 岩清水"
"いわしみずはちまんぐう 石清水八幡宮"
"いわしみずものがたり 石清水物語"
"いわしみづ 岩清水"
"いわしろ 岩城 岩代"
"いわずもがな 言わずもがな"
"いわせ 石瀬 岩瀬"
"いわた 磐田 岩田"
"いわたき 岩滝"
"いわたけ 岩茸 岩岳"
"いわたに 岩谷"
"いわだけ 岩岳"
"いわだたみ 岩畳"
"いわだな 岩棚"
"いわだぬき 岩狸"
"いわつう 岩通"
"いわつか 岩塚"
"いわつき 岩月 岩槻"
"いわつばめ 岩燕"
"いわつぼ 岩壺"
"いわて 岩手"
"いわてんじょう 岩天井"
"いわで 岩出"
"いわと 石門 磐戸 岩戸"
"いわとくせん 岩徳線"
"いわど 岩戸"
"いわな 岩魚"
"いわない 岩内"
"いわなみ 岩浪 岩波"
"いわにちせん 岩日線"
"いわぬま 岩沼"
"いわね 岩根"
"いわの 岩野"
"いわのり 岩海苔"
"いわはし 岩橋"
"いわはだ 岩肌"
"いわはな 岩端 岩鼻"
"いわはら 岩原"
"いわば 謂わば 言わば 岩場"
"いわばやし 岩林"
"いわひろ 岩廣"
"いわふじ 岩藤"
"いわふね 岩舟 岩船"
"いわぶえ 石笛"
"いわぶき 岩蕗"
"いわぶち 岩淵 岩渕"
"いわぶろ 岩風呂"
"いわほり 岩堀"
"いわま 岩間"
"いわまつ 岩松"
"いわみ 岩見 岩美 石見"
"いわみさわ 岩見沢"
"いわみざわ 岩見沢"
"いわみず 岩水"
"いわみだ 岩見田"
"いわみね 岩峰"
"いわむら 岩村"
"いわむろ 石室 岩室"
"いわめ 岩女 岩女魚"
"いわもと 岩本"
"いわや 巌谷 岩谷 石屋 窟 岩屋"
"いわやま 岩山"
"いわゆる 所謂"
"いわれ 謂れ"
"いわんや 況んや"
"いん 隱 酳 贇 廴 允 蔭 寅 尹 胤 堙 湮 殞 隕 韵 音 蚓 引 飮 飲 茵 氤 姻 咽 霪 婬 淫 慇 殷 因 隠 陰 院 員 韻 印"
"いんあつ 印圧"
"いんい 因依 陰萎"
"いんいおん 陰イオン"
"いんいつ 淫佚 淫逸 隠逸"
"いんいん 殷々"
"いんいんめつめつ 陰陰滅滅 陰々滅々"
"いんう 淫雨"
"いんうつ 陰鬱"
"いんえい 陰翳 印影 陰影"
"いんおう 印欧"
"いんか 陰窩 允可 陰火 印花 印可 印加 引火"
"いんかか 隠花果"
"いんかく 陰核"
"いんかしょくぶつ 隠花植物"
"いんかていこく インカ帝国"
"いんかぶんめい インカ文明"
"いんかろん 因果論"
"いんかん 隠閑 殷鑑 印鑑"
"いんが 陰画 印画 因果"
"いんがい 員外 院外"
"いんき 印記 陰気"
"いんきょ 殷墟 允許 隠居"
"いんきょう 韻鏡 印僑"
"いんきょく 陰極"
"いんきん 引磬 陰金 印金"
"いんぎ 院議"
"いんぎゃく 淫虐"
"いんぎょう 隠形 印形"
"いんぎょうてんのう 允恭天皇"
"いんぎん 慇懃"
"いんくぎれ インク切れ"
"いんくつぼ インク壺"
"いんぐ 淫具"
"いんぐらんど 英蘭"
"いんぐらんどぎんこう イングランド銀行"
"いんけい 陰茎"
"いんけん 隠見 隠顕 引見 陰険"
"いんげ 院家"
"いんげん 隠元"
"いんげんまめ 隠元豆"
"いんこ 鸚哥"
"いんこう 淫荒 印行 淫行 咽喉"
"いんこく 印刻 陰刻"
"いんご 韻語 淫語 隠語"
"いんごう 引業 因業 院号"
"いんさいだーとりひき インサイダー取引"
"いんさつ 印刷"
"いんさん 陰惨"
"いんざい 印西 印材"
"いんし 淫祀 淫祠 院試 印紙 因子"
"いんしつ 陰湿"
"いんしゅ 飲酒"
"いんしゅう 隠州 因州 因襲 因習"
"いんしょ 音書 淫書 韻書 引書 印書"
"いんしょう 陰証 引照 引証 印章 印象"
"いんしょく 飲食"
"いんしん 殷賑 陰唇"
"いんじ 韻字 印璽 印字"
"いんじゃ 隠者"
"いんじゅ 印綬 院主"
"いんじゅう 陰獣"
"いんじゅん 因循"
"いんじょ 淫女"
"いんじょう 引摂 引接"
"いんすい 淫水 飲水 引水"
"いんすう 引数 因数 員数"
"いんずう 員数"
"いんせい 隕星 隠栖 隠棲 院政 陰性 院生"
"いんせき 殞石 姻戚 引責 隕石"
"いんせつ 引接"
"いんせん 隠線 陰線"
"いんぜい 印税"
"いんぜみ 院ゼミ"
"いんぜん 院宣 隠然"
"いんそう 印相"
"いんそつ 院卒 引率"
"いんぞう 印相"
"いんぞく 姻族"
"いんたい 院体 隠退 引退"
"いんだすぶんめい インダス文明"
"いんち 韻致 引致 吋"
"いんちょう 院庁 院長"
"いんちん 影青"
"いんてい 陰梃"
"いんてつ 隕鉄"
"いんてん 院展"
"いんでぃあんざ インディアン座"
"いんでぃかまい インディカ米"
"いんとう 淫蕩 咽頭"
"いんとうかじょ 隠頭花序"
"いんとく 隠匿"
"いんとん 隠遁"
"いんど 印度"
"いんどう 犬童 陰道 引導"
"いんどこうろ インド航路"
"いんどじん インド人"
"いんどぞう インド象"
"いんどてつがく インド哲学"
"いんどねしあご インドネシア語"
"いんどよーろっぱごぞく インドヨーロッパ語族"
"いんどよう インド洋"
"いんどりょうり インド料理"
"いんどわた インド綿"
"いんない 印内 院内"
"いんなみ 印南"
"いんに 陰に 因位"
"いんにく 印肉"
"いんにゅうし 院入試"
"いんにょう 廴繞 飲尿"
"いんにん 隠忍"
"いんねん 因縁"
"いんのう 陰嚢"
"いんのしま 因島"
"いんのしょう 院庄"
"いんば 印旛"
"いんばい 淫売"
"いんばぬま 印旛沼"
"いんばん 印判"
"いんぱ 院派 印パ"
"いんぱるすおうとう インパルス応答"
"いんび 韻尾 隠微 淫靡"
"いんびさ 淫靡さ"
"いんびせん 因美線"
"いんぴ 隠秘 隠避"
"いんふらせいび インフラ整備"
"いんぶ 陰部"
"いんぶん 陰文 韻文"
"いんぷ 陰阜 殷富 淫婦 印譜"
"いんぷく 隠伏"
"いんべん 員弁"
"いんぺい 隠蔽"
"いんぼ 韻母"
"いんぼう 陰謀"
"いんぽん 淫本 淫奔 印本 院本"
"いんみょう 因明"
"いんむ 淫夢"
"いんめい 因明"
"いんめつ 堙滅 湮滅 隠滅"
"いんめん 隠面 印面"
"いんめんちょうしょ 員面調書"
"いんもう 陰毛"
"いんもん 陰文 陰門"
"いんゆ 引喩 隠喩"
"いんよう 陰陽 飲用 引用"
"いんようし 引用始"
"いんよく 淫欲"
"いんらく 淫楽"
"いんらん 淫乱"
"いんりつ 韻律"
"いんりょう 飲料"
"いんりょく 引力"
"いんれい 引例"
"いんれき 陰暦"
"いんれつ 陰裂"
"いんろう 印篭 印籠"
"いんわい 淫猥"
"う 菟 胡 憂 饂 夘 生 烏 嫗 傴 齲 禹 兎 芋 盂 紆 迂 宇 于 挧 羽 卯 有 鵜 得 右 雨"
"うーかーぴーちゅー 五加皮酒"
"うーはん 武漢"
"うーろん 烏龍"
"うーろんちゃ ウーロン茶"
"うぃ ヰ ゐ"
"うぃーん 維納"
"うぃーんがくだん ウィーン学団"
"うぃり 干莉"
"うい 宇井 有為 初"
"ういきょう 茴香"
"ういぐるご ウイグル語"
"ういこうぶり 初冠"
"ういご 初子"
"ういざん 初産"
"ういじん 初陣"
"ういち 宇一"
"ういまご 初孫"
"ういるすせいかんえん ウイルス性肝炎"
"ういるすびょう ウイルス病"
"ういろう 外郎"
"ういろううり 外郎売"
"ういろうまめ 外郎豆"
"ううろんちゃ 烏龍茶"
"うぇ ヱ ゑ"
"うぇぶじょう ウェブ上"
"うぇるたーきゅう ウェルター級"
"うえ ↑ 植 飢え 上"
"うええだ 上枝"
"うえおか 植岡"
"うえがはら 上ヶ原"
"うえがめん 上画面"
"うえがわ 上側"
"うえき 植え木 植木"
"うえきざん 植木算"
"うえきばち 植え木鉢 植木鉢"
"うえくさ 植草"
"うえくぼ 上窪"
"うえこみ 植込 植込み 植え込み"
"うえさか 上坂"
"うえさま 上様"
"うえさんかく 上三角"
"うえしき 上式"
"うえした 上下"
"うえしば 植芝"
"うえしま 上島"
"うえじ 植字"
"うえじに 餓死 餓え死に 飢え死に"
"うえじま 上島"
"うえす 上須 上江洲"
"うえすぎ 上杉"
"うえすぎてるとら 上杉輝虎"
"うえすぎまさとら 上杉政虎"
"うえぞの 上園"
"うえた 植田"
"うえたけ 植竹"
"うえたに 上谷"
"うえだ 植田 上田"
"うえちゅうだん 上中段"
"うえつ 羽越"
"うえつかた 上つ方"
"うえつき 上付き"
"うえつけ 植え付け 植付け"
"うえづけ 上付"
"うえなか 植中"
"うえにし 上西"
"うえの 植野 上野"
"うえのおのこ 上の男"
"うえのはら 上野原"
"うえはま 上浜"
"うえはら 植原 上原"
"うえはらせい 上原成"
"うえはんぶん 上半分"
"うえひら 植平"
"うえびと 上人"
"うえほうこう 上方向"
"うえほんまち 上本町"
"うえほんまちろくちょうめ 上本町六丁目"
"うえまち 上町"
"うえまつ 上松 植松"
"うえむき 上向き"
"うえむら 植村 上村"
"うえもと 植本"
"うえもり 上森"
"うえもん 右衛門"
"うえもんのかみ 右衛門督"
"うえもんのじょう 右衛門尉"
"うえや 上矢 ↑"
"うえやじるし 上矢印"
"うえやま 上山"
"うえろく 上本町六丁目"
"うえわらわ 上童"
"うえん 迂遠 有縁"
"うぉーるがい ウォール街"
"うお 宇夫 魚"
"うおい 魚井"
"うおいちば 魚市場"
"うおうさおう 右往左往"
"うおかす 魚滓"
"うおがし 魚河岸"
"うおごころ 魚心"
"うおざ 魚座"
"うおざき 魚崎"
"うおざききたちょう 魚崎北町"
"うおしま 魚島"
"うおじょうゆ 魚醤油"
"うおすき 魚鋤"
"うおずみ 魚住"
"うおせ 魚瀬"
"うおぜっきょう 魚説経"
"うおぜっぽう 魚説法"
"うおそうめん 魚素麺"
"うおたか 魚鷹"
"うおだな 魚店"
"うおつか 魚塚"
"うおつきりん 魚付き林"
"うおつり 魚釣り"
"うおづ 魚津"
"うおに 魚荷"
"うおにかわ 魚膠"
"うおぬま 魚沼"
"うおのがわ 魚野川"
"うおのめ 魚の目"
"うおびしお 魚醤"
"うおへん 魚偏"
"うおみ 魚見"
"うおみそ 魚味噌"
"うおみつ 魚光"
"うおや 魚屋"
"うおんず 雨温図"
"うおんびん ウ音便"
"うか 雨下 羽化"
"うかい 有界 鵜飼い 鵜飼 迂回"
"うかがい 窺 伺い 伺"
"うかがいしょ 伺書"
"うかじ 宇梶"
"うかつ 迂濶 迂闊"
"うかとうせん 羽化登仙"
"うかぬかお 浮かぬ顔"
"うかのみたま 稲魂"
"うかみ 窺見 斥候"
"うから 親族"
"うかれ 浮かれ"
"うかれめ 浮かれ女"
"うかわ 鵜川"
"うかん 有漢"
"うかんむり ウ冠"
"うがい 鵜飼 嗽"
"うがいぐすり 嗽薬 うがい薬"
"うがき 宇垣"
"うがく 有学"
"うがちすぎ 穿ち過ぎ"
"うがん 烏桓 烏丸 右眼 右岸"
"うき 憂き 泛子 浮子 浮 浮き 雨期 雨季 右記"
"うきあし 浮足 浮き足"
"うきいし 浮き石 浮石"
"うきうお 浮魚 浮き魚"
"うきえ 浮江"
"うきおり 浮織"
"うきがや 浮ヶ谷"
"うきくさ 萍 浮き草 浮草"
"うきぐ 浮具"
"うきぐも 浮雲"
"うきごし 浮き腰 浮腰"
"うきしずみ 浮き沈み"
"うきしま 浮き島 浮島"
"うきしろものがたり 浮城物語"
"うきす 浮巣"
"うきせいこう 雨奇晴好"
"うきた 浮田"
"うきだま 浮き玉"
"うきつ 浮津"
"うきどっく 浮きドック 浮ドック"
"うきな 浮き名 浮名"
"うきはし 浮き橋 浮橋"
"うきばし 浮橋"
"うきふね 浮船 浮舟"
"うきぶくろ 鰾 浮袋 浮き袋"
"うきぼり 浮彫り 浮彫 浮き彫り"
"うきみ 憂き身 浮き実 浮身 浮き身"
"うきょう 右京"
"うきょく 迂曲"
"うきよ 憂き世 浮き世 浮世"
"うきわ 浮輪 浮き輪"
"うぎょう う行 ウ行"
"うく 宇久"
"うくらいな 烏克蘭"
"うぐ 迂愚"
"うぐい 石斑魚 鯏"
"うぐいす 鴬 鶯"
"うぐいすいろ 鶯色"
"うぐいすざわ 鴬沢 鶯沢"
"うぐいすじょう ウグイス嬢 鶯嬢"
"うぐいすだに 鴬谷"
"うぐいすだにえき 鶯谷駅"
"うぐいすちゃ 鶯茶"
"うぐいすな 鶯菜"
"うぐいすばり 鶯張り"
"うぐいすぶえ 鶯笛"
"うぐいすもち 鶯餅"
"うぐら 葎"
"うけ 請け 受け 受 筌 槽 食 有卦"
"うけあい 受合い 請合い 受け合い 請け合い"
"うけい 誓約 右傾"
"うけいれ 受入れ 受入"
"うけうり 請売り 受売り"
"うけおい 請負"
"うけぎ 受け木"
"うけぐち 受口"
"うけごし 受け腰"
"うけしょ 受書 請書"
"うけつけ 受付け 受付"
"うけて 受手"
"うけとり 受取り 受取"
"うけにぬし 受荷主"
"うけにん 請人"
"うけのみたま 稲魂"
"うけはらい 受払い 受払"
"うけばこ 凵 受け箱 受箱"
"うけばらい 受払"
"うけぶみ 請文"
"うけみ 受身 受け身"
"うけもち 受持ち"
"うけやど 請宿"
"うけら 朮"
"うけわたし 受渡し 受渡"
"うけん 宇検"
"うげつ 雨月"
"うげん 迂言 右舷"
"うこう 宇高"
"うこうけん 宇航研"
"うこうこつ 烏口骨"
"うこぎ 五加木 五加"
"うこさべん 右顧左眄"
"うこっけい 烏骨鶏"
"うこん 鬱金 右近"
"うご 羽後 雨後"
"うごう 烏合"
"うごうのしゅう 烏合の衆"
"うごき 動き"
"うさ 憂さ 右左 宇佐"
"うさぎ 莵 菟 兔 卯 兎"
"うさぎうま 驢 兎馬"
"うさぎがり 兎狩り"
"うさぎごや ウサギ小屋 兎小屋"
"うさぎざ 兎座"
"うさぎだいら 兎平"
"うさぎとび 兎飛び 兎跳び"
"うさぎどし 卯年"
"うさせつ 右左折"
"うさばらし 憂さ晴らし"
"うさみ 宇沙美 宇佐見 宇佐美"
"うさわ 宇沢"
"うさん 胡散"
"うさんくさい 胡散臭い"
"うざき 宇崎"
"うざく 鰻ざく"
"うざわ 宇澤 宇沢 鵜澤 鵜沢"
"うし 齲歯 丑 牛"
"うしお 牛尾 潮"
"うしおい 牛追い"
"うしおいうた 牛追い唄"
"うしおしゅっぱん 潮出版"
"うしおじる 潮汁"
"うしおだ 潮田"
"うしおでんき ウシオ電機"
"うしおに 牛鬼"
"うしかい 牛飼 牛飼い"
"うしかいめんじょうのうしょう 牛海綿状脳症"
"うしがえる 牛蛙"
"うしき 牛木"
"うしく 牛久"
"うしくぬま 牛久沼"
"うしごめ 牛込"
"うしごや 牛小屋"
"うしじま 牛嶋 牛島"
"うしじろう 牛次郎"
"うした 牛田"
"うしづ 牛津"
"うしとら 丑寅 艮"
"うしどし 丑年"
"うしね 牛根"
"うしの 牛野"
"うしのこく 丑の刻"
"うしのこくまいり 丑の刻参り"
"うしのひ 丑の日"
"うしばえ 牛蠅"
"うしぶか 牛深"
"うしへん 牛偏"
"うしぼり 牛堀"
"うしまど 牛窓"
"うしまる 牛丸"
"うしみつ 丑三つ"
"うしみつどき 丑三つ刻"
"うしや 牛屋"
"うしゅう 羽州"
"うしょう 有性 有生 羽觴 右相 鵜匠"
"うしょうべん 右少弁"
"うしらん 烏糸欄"
"うしろ 後 後ろ"
"うしろあし 後ろ足"
"うしろあわせ 後ろ合せ"
"うしろかげ 後ろ影"
"うしろかわ 後川"
"うしろがみ 後髪 後ろ髪"
"うしろがわ 後側"
"うしろきず 後ろ疵 後ろ傷"
"うしろざま 後ろ方"
"うしろすがた 後姿 後ろ姿"
"うしろだて 後ろだて 後立 後ろ楯 後ろ盾"
"うしろで 後ろ手"
"うしろはんぶん 後半分"
"うしろほうこう 後方向"
"うしろみ 後ろ身 後見"
"うしろむき 後向き"
"うしろめ 後目"
"うしろゆび 後ろ指"
"うしわかまる 牛若丸"
"うしわた 牛渡"
"うしん 有心"
"うしんしつ 右心室"
"うしんふぜん 右心不全"
"うしんぼう 右心房"
"うじ 蛆 宇治 氏"
"うじい 雲林院"
"うじいえ 氏家"
"うじかばね 氏姓"
"うじがみ 氏神"
"うじこ 氏子"
"うじさと 氏郷"
"うじじゅうじょう 宇治十帖"
"うじすじょう 氏素姓 氏素性"
"うじでら 氏寺"
"うじな 宇品"
"うじはら 氏原"
"うじびと 氏人"
"うじふさ 氏房"
"うじむし ウジ虫 蛆虫"
"うじょう 雨上 鵜匠 羽状 有情"
"うじょうしょう 右丞相"
"うじょうみゃく 羽状脈"
"うす 舂 有珠 碓 薄 臼"
"うすあお 淡青 薄青"
"うすあじ 薄味"
"うすい 薄井 碓井 碓氷 臼井 雨水"
"うすいこう 雨水溝"
"うすいた 薄板"
"うすいろ 薄色"
"うすうす 薄薄 薄々"
"うすかべ 薄壁"
"うすかわ 薄皮"
"うすがすみ 薄霞"
"うすがた 薄型"
"うすがみ 薄紙"
"うすき 薄 臼杵"
"うすぎ 薄着"
"うすぎぬ 薄絹 薄衣"
"うすぎり 薄霧"
"うすくち 薄口"
"うすくちしょうゆ 淡口醤油"
"うすくれない 薄紅"
"うすぐも 薄雲"
"うすぐもり うす曇り 薄曇り 薄曇"
"うすげ 薄毛"
"うすごおり 薄氷"
"うすごろも 薄衣"
"うすざいしき 薄彩色"
"うすざん 有珠山"
"うすじ 薄地"
"うすじお 薄塩"
"うすずみ 薄墨"
"うすた 薄田"
"うすだ 臼田"
"うすだいこ 臼太鼓"
"うすだたみ 薄畳"
"うすちゃ 薄茶"
"うすっぺら 薄っぺら"
"うすづき 薄月"
"うすづきよ 薄月夜"
"うすで 薄手"
"うすにく 薄肉"
"うすぬり 薄塗"
"うすねず 薄鼠"
"うすのろ 薄鈍"
"うすはなだ 薄縹"
"うすば 薄葉 薄刃"
"うすばかげろう 薄羽蜉蝣"
"うすび 薄日"
"うすびょう 護田鳥尾"
"うすべお 護田鳥尾"
"うすべに 薄紅"
"うすべり 薄縁"
"うすぼんやり 薄ぼんやり"
"うすまく 薄膜"
"うすみどり 薄緑"
"うすむらさき 薄紫"
"うすめ 薄め 薄目"
"うすもの 羅 薄物"
"うすやき 薄焼"
"うすやみ 薄闇"
"うすゆき 薄雪"
"うすよう 薄様 薄葉"
"うすら 薄ら"
"うすらひ 薄ら氷"
"うず 烏頭 右図 渦"
"うずい 渦位"
"うずき 宇津木 疼き"
"うずくまる 蹲 踞"
"うずしお 渦潮"
"うずでんりゅう 渦電流"
"うずど 渦度"
"うずの 鶉野"
"うずば 渦場"
"うずべくご ウズベク語"
"うずまき 渦巻き 渦巻"
"うずまさ 太秦"
"うずみび 埋み火"
"うずむし 渦虫"
"うずゆそう 渦輸送"
"うずら 鶉"
"うずらいし 鶉石"
"うずらたまご うずら卵 鶉卵"
"うずらの 鶉野"
"うせい 迂生"
"うせつ 雨雪 右折"
"うせもの 失せ物"
"うせんけい 右線形"
"うせんせい 右旋性"
"うぜん 羽前"
"うそ 獺 嘯 鷽 嘘"
"うそいつわり 嘘偽り"
"うそうそ 嘘々"
"うそく 右側"
"うそさむ うそ寒"
"うそじ 嘘字"
"うそっぱち 嘘っ八 嘘っぱち"
"うそつき 嘘つき 嘘吐き"
"うそなき 嘘泣き"
"うそはっけんき 嘘発見機 嘘発見器"
"うそはっぴゃく 嘘八百"
"うそふき 嘯"
"うそぶえ 嘯笛"
"うぞうむぞう 有象無象"
"うた 謳 宇田 謌 詩 唄 歌"
"うたあわせ 歌合"
"うたい 謠 謡"
"うたいかた 歌い方"
"うたいがい 歌以外"
"うたいぞめ 謡初"
"うたいて 歌い手"
"うたいぼん 謡本"
"うたいめ 歌い女"
"うたいもの 謡い物 歌い物"
"うたいもんく 歌文句 謳文句 謡い文句 歌い文句 謳い文句"
"うたいり 歌入り"
"うたいれ 歌入れ"
"うたうたい 歌歌い 歌唄い"
"うたうら 歌占"
"うたえもん 歌右衛門"
"うたかい 歌会"
"うたかいはじめ 歌会始"
"うたかた 泡沫"
"うたがい 疑い"
"うたがいなく 疑い無く"
"うたがき 歌垣"
"うたがっせん 歌合戦"
"うたがわ 歌川"
"うたがわくによし 歌川国芳"
"うたぎれ 歌切"
"うたぐち 歌口"
"うたげ 讌 宴"
"うたこ 歌子 詩子"
"うたことば 歌詞"
"うたごえ 歌声"
"うたごころ 歌心"
"うたしない 歌志内"
"うたしろ 歌代"
"うたせゆ 打たせ湯"
"うたた 転"
"うたたね 転た寝 転寝 うたた寝"
"うただ 宇多田"
"うたつ 宇多津 歌津"
"うたづ 宇多津"
"うたづかさ 雅楽寮"
"うたて 転"
"うたの 宇多野 歌野 菟田野"
"うたのかみ 雅楽頭"
"うたのつかさ 雅楽寮"
"うたのやまい 歌の病"
"うたばん 歌伴"
"うたばんぐみ 歌番組"
"うたひめ 歌姫"
"うたびと 歌人"
"うたほん 歌本"
"うたまい 歌舞"
"うたまいのつかさ 雅楽寮 楽官"
"うたまくら 歌枕"
"うたまる 歌丸"
"うたまろ 歌麿"
"うたもの 唄物 歌物"
"うたものがたり 歌物語"
"うたよ 詩代 歌代"
"うたよみ 歌詠み"
"うたん 右端"
"うだ 宇陀 宇田"
"うだい 宇内 宇大"
"うだいしょう 右大将"
"うだいじん 右大臣"
"うだいべん 右大弁"
"うだち 卯建"
"うだつ 卯建"
"うだてんのう 宇多天皇"
"うだん ウ段"
"うち 裡 欝 鬱 中 家 打ち 内"
"うちあい 打ち合い"
"うちあげ 内上げ 内揚 内揚げ 打上げ"
"うちあげはなび 打上花火"
"うちあみ 打ち網 打網"
"うちあわせ 打ち合せ 打合せ"
"うちい 内井"
"うちいけ 内池"
"うちいで 打出"
"うちいり 内入り 討入り 討ち入り"
"うちいわい 内祝い 内祝"
"うちうち 内々"
"うちうみ 内海"
"うちうら 内裏 内浦"
"うちかぎ 内鍵"
"うちかけ 裲襠 打掛け 打ち掛け 打掛"
"うちかた 内潟 内方"
"うちかわ 内川"
"うちかんだ 内神田"
"うちがけ 内掛け"
"うちがし 打菓子"
"うちがた 内型"
"うちがたな 打ち刀 打刀"
"うちがま 内釜"
"うちがわ 内側"
"うちき 内木 内気"
"うちきず 打傷 打ち傷"
"うちきり 打切 打切り"
"うちきん 内金"
"うちぎ 袿"
"うちぎぬ 打衣"
"うちくび 打首 打ち首"
"うちぐるま 内車"
"うちけし 打消し"
"うちげいこ 内稽古"
"うちげば 内ゲバ"
"うちげんかん 内玄関"
"うちこ 打粉 内子 打ち粉"
"うちこし 打越"
"うちこば 内木場"
"うちこわし 打ち毀し"
"うちさいわい 内幸"
"うちさぶらい 内侍"
"うちざた 内沙汰"
"うちじに 討死に 討ち死に 討死"
"うちじゅう 家中"
"うちぜい 内税"
"うちそで 内袖"
"うちた 打田"
"うちだ 内田"
"うちだんねつ 内断熱"
"うちちがい 打違い"
"うちっぱなし 打ちっ放し"
"うちつくに 内つ国"
"うちづま 内妻"
"うちづら 内面"
"うちて 打手 討手"
"うちで 打出"
"うちでし 内弟子"
"うちでのこづち 打出の小槌 打ち出の小槌"
"うちとびら 内扉"
"うちど 内戸"
"うちどい 内樋"
"うちどめ 打止 打止め 打ち止め"
"うちなかはら 内中原"
"うちなだ 内灘"
"うちにわ 内庭"
"うちぬき 打抜 打抜き"
"うちねこ 内猫"
"うちの 内野"
"うちのうら 内之浦"
"うちのみ 内海"
"うちのり 内のり 内法"
"うちはし 内橋"
"うちはちもんじ 内八文字"
"うちはなし 打ち放し 打放し"
"うちはら 内原"
"うちばば 内馬場"
"うちばらい 内払い"
"うちばり 梁 内張り"
"うちひとり 内一人"
"うちひょうじ 内表示"
"うちひら 内平"
"うちびらき 内開き"
"うちふづめ 打歩詰め"
"うちぶ 打歩"
"うちぶくろ 内袋"
"うちぶた 内蓋"
"うちぶろ 内風呂"
"うちべんけい 内弁慶"
"うちぼう 内房"
"うちぼり 内壕 内濠 内堀"
"うちぽけっと 内ポケット"
"うちまき 内巻 内巻き"
"うちまく 内幕"
"うちまご 内孫"
"うちまた 内股"
"うちまたごうやく 内股膏薬"
"うちまど 内窓"
"うちまわり 内回り"
"うちみ 打見 打ち身"
"うちみず 打ち水"
"うちみや 内宮"
"うちむき 内向き"
"うちむそう 内無双"
"うちむら 内村"
"うちもうこ 内蒙古"
"うちもと 内一"
"うちもの 打物"
"うちもも 内腿 内股"
"うちやま 内山"
"うちやまだ 内山田"
"うちゅう 雨中 宇宙"
"うちゅういち 宇宙一"
"うちゅうかん 右中間"
"うちゅうじん 宇宙塵"
"うちゅうすてーしょん 宇宙ステーション"
"うちゅうべん 右中弁"
"うちゆ 内湯"
"うちょうてん 有頂天"
"うちょく 右直"
"うちら 内良"
"うちわ 団扇 内輪"
"うちわうけ 内輪受"
"うちわく 内枠"
"うちわけ 内訳"
"うちわたし 内渡し"
"うっかい 鬱懐"
"うっかりもの うっかり者"
"うっき 鬱気"
"うっくつ 鬱屈"
"うっけつ 鬱結 欝血 うっ血 鬱血"
"うっこ 鬱乎"
"うっこん 鬱金"
"うっこんこう 鬱金香"
"うっさん 鬱散"
"うっすら 薄ら"
"うっせい 鬱生"
"うっせき 欝積 うっ積 鬱積"
"うっそう 鬱葱 欝蒼 鬱蒼"
"うっそく 鬱塞"
"うったい 鬱滞"
"うったえ 訴え"
"うっちゃり 打っ棄り"
"うっちょう 鬱鬯"
"うって 討手"
"うっとう 欝陶 鬱陶"
"うっぷん 欝憤 鬱憤"
"うっぷんばらし 鬱憤晴らし"
"うつ 蔚 欝 鬱"
"うつい 鬱伊"
"うついく 鬱郁"
"うつう 鬱紆"
"うつうつ 鬱鬱 鬱々"
"うつお 靫 空"
"うつおう 鬱懊 鬱泱 鬱怏"
"うつおぶね 空舟"
"うつき 宇津喜 宇津木"
"うつぎ 宇津木"
"うつぎみ 鬱気味"
"うつく 美"
"うつくしがおか 美しが丘"
"うつくしがはら 美ヶ原"
"うつけ 虚け 空け"
"うつけもの 呆気者"
"うつし 写 写し"
"うつしみ 現し身 現身"
"うつしよ 現世"
"うつじゅう 鬱情"
"うつじょう 鬱情"
"うつじょうたい 鬱状態"
"うつせ 虚"
"うつせがい 虚貝"
"うつせみ 現身 空蝉"
"うつぜん 鬱然"
"うつそみ 現身"
"うつつ 現"
"うつて 打つ手"
"うつのみや 宇都宮"
"うつばり 梁"
"うつびょう うつ病 鬱病"
"うつぶせ 俯せ"
"うつほ 空"
"うつほぶね 空舟"
"うつほものがたり 宇津保物語"
"うつぼ 空穂 靫 靱 靭 笂"
"うつぼかずら 靫葛"
"うつぼぐさ 靫草"
"うつぼつ 鬱勃"
"うつぼものがたり 宇津保物語"
"うつみ 宇都美 慈 内海"
"うつみや 宇津宮"
"うつむきかげん 俯き加減"
"うつも 鬱茂"
"うつもん 鬱悶"
"うつゆう 鬱邑 鬱悒"
"うつよく 鬱抑"
"うつり 映り 写り"
"うつりかわり 移り変り 移り変わり"
"うつりが 移り香"
"うつりぎ 移り気"
"うつりごし 移り腰"
"うつりつ 鬱律"
"うつりょうとう 鬱陵島"
"うつろ 空ろ 宇津呂 虚 虚ろ"
"うつろい 移ろい"
"うつわ 噐 器"
"うつわもの 器物"
"うづ 宇津"
"うづき 宇津木 卯月"
"うづきゅうめいがん 宇津救命丸"
"うて 右手"
"うてき 雨滴"
"うてな 萼 台"
"うてん 雨天"
"うで 腕"
"うでおし 腕押し"
"うでかざり 腕飾り"
"うできき 腕利き"
"うでぎ 腕木"
"うでくらべ 腕比べ"
"うでぐみ 腕組み"
"うでじまん 腕自慢"
"うでずく 腕尽く 腕ずく"
"うでずもう 腕相撲"
"うでぞろい 腕揃い"
"うでたて 腕立"
"うでたてふせ 腕立て伏せ"
"うでだめし 腕試し"
"うでっぷし 腕っ節"
"うでづく 腕尽く"
"うでどけい 腕時計"
"うでぶし 腕節"
"うでまえ 腕前"
"うでまくら 腕枕"
"うでまくり 腕まくり 腕捲り"
"うでわ 腕輪"
"うと 宇土 宇都"
"うとう 宇籐 宇藤"
"うとく 宇徳 有徳"
"うとろ 宇登呂"
"うど 独活"
"うどし 卯年"
"うどじんぐう 鵜戸神宮"
"うどねり 内舎人"
"うどの 鵜殿"
"うどり 羽鳥"
"うどん 饂飩"
"うどんげ 優曇華"
"うどんこ うどん粉 饂飩粉"
"うどんや うどん屋"
"うな 項 鰻"
"うない 宇内"
"うなかみ 海上"
"うながし 令"
"うなぎ 鰻"
"うなぎどんぶり 鰻丼"
"うなぎのぼり うなぎ上り うなぎ登り 鰻上り 鰻登り"
"うなぎめし 鰻飯"
"うなぎや 鰻屋"
"うなぎりょうり 鰻料理"
"うなさか 海境"
"うなじ 項"
"うなじゅう 鰻重"
"うなぞこ 海底"
"うなづき 宇奈月"
"うなでん ウナ電"
"うなどん うな丼 鰻丼"
"うなばら 海原"
"うなり 唸り"
"うに 海胆 雲丹"
"うにょう 右繞"
"うぬ 汝 己"
"うぬぼれ 己惚れ 自惚れ"
"うね 畴 畆 疇 有年 宇根 畦 畝"
"うねおか 宇根岡"
"うねおり 畝織"
"うねかわ 畝川"
"うねび 畝傍"
"うねま 畝間"
"うねめ 采女"
"うねもと 畝本"
"うの 宇能 鵜野 宇野"
"うのう 右脳"
"うのき 卯野木 宇野木 卯木 鵜木"
"うのけ 宇ノ気"
"うのはな 卯の花"
"うのみ 鵜呑 鵜呑み"
"うのめたかのめ 鵜の目鷹の目"
"うは 右派"
"うば 乳母 姥"
"うばい 烏梅 優婆夷"
"うばいあい 奪い合い"
"うばいし 姥石"
"うばがい 姥貝"
"うばぐるま 乳母車"
"うばざくら 姥桜"
"うばすて 姥捨て 姥捨"
"うばすてやま 姨捨山"
"うばそく 優婆塞"
"うばめがし 姥目樫"
"うひょう 雨氷"
"うひょうえ 右兵衛"
"うひょうえのかみ 右兵衛督"
"うひょうえのじょう 右兵衛尉"
"うびょう 宇廟"
"うふさま 右府様"
"うぶ 生 有部 初心 初 産"
"うぶぎ 産衣 産着"
"うぶぎぬ 産衣"
"うぶげ 産毛"
"うぶこ 産子"
"うぶご 産子"
"うぶごえ 産声"
"うぶごや 産小屋"
"うぶすな 産土"
"うぶすながみ 産土神"
"うぶね 鵜舟"
"うぶめ 産女"
"うぶや 産屋"
"うぶやま 産山"
"うぶゆ 産湯"
"うぷしろん Υ υ"
"うへん 羽片 右辺"
"うべ 宜 宇部"
"うべこう 宇部興"
"うべんかん 右弁官"
"うほ 禹歩"
"うほう 右方"
"うま 旨 午 馬"
"うまあぶ 馬虻"
"うまいち 馬市"
"うまいり 馬入"
"うまうま 旨々"
"うまおい 馬追い"
"うまかたぶし 馬方節"
"うまき 鰻巻き"
"うまくさ 秣"
"うまくち 甘口"
"うまこ 馬子"
"うまこし 馬越"
"うまご 孫"
"うまごめ 馬込"
"うまごや 馬小屋"
"うまごやし 馬肥やし 苜蓿"
"うまさけ 旨酒 味酒"
"うまじ 馬路"
"うまじしん 馬自身"
"うまじたい 馬自体"
"うまじるし 馬標 馬印"
"うまずめ 不生女 石女"
"うまずら 馬面"
"うまたち 馬達"
"うまたて 馬立"
"うまたん 馬単"
"うまづら 馬面"
"うまづらはぎ 馬面剥"
"うまとび 馬飛び 馬跳び"
"うまどし 午年"
"うまに 馬荷 旨煮 甘煮"
"うまぬし 馬主"
"うまの 馬野"
"うまのかみ 馬頭 右馬頭"
"うまのすけ 右馬助"
"うまのすずくさか ウマノスズクサ科"
"うまのすずくさもく ウマノスズクサ目"
"うまのはなむけ 餞"
"うまのほね 馬の骨"
"うまのり 馬乗り"
"うまはし 馬橋"
"うまば 馬場"
"うまばえ 馬蠅"
"うまばしら 馬柱"
"うまばん 馬番"
"うまふざい 馬不在"
"うまぶね 馬槽"
"うまへん 馬偏"
"うまみ 旨み 旨味"
"うまみち 馬道"
"うまや 廏 廐 馬屋 厩"
"うまやごえ 厩肥"
"うまやどのおうじ 厩戸皇子"
"うまら 茨"
"うまれ 生 生れ 生まれ"
"うまれつき 生まれつき"
"うまれどし 生まれ年"
"うまれん 馬連"
"うみ 宇美 生 膿 海"
"うみいぐあな 海イグアナ"
"うみいちめん 海一面"
"うみうお 海魚"
"うみうし 海牛"
"うみうま 海馬"
"うみかぜ 海風"
"うみがみ 海神"
"うみがめ 海亀"
"うみがわ 海側"
"うみぎり 海霧"
"うみさち 海幸"
"うみざかな 海魚"
"うみしばうら 海芝浦"
"うみせんやません 海千山千"
"うみそだち 海育ち"
"うみぞい 海沿い"
"うみだし 海田市"
"うみち 膿血"
"うみつばめ 海燕"
"うみづき 産み月"
"うみづり 海釣 海釣り"
"うみて 海手"
"うみどり 海鳥"
"うみなり 海鳴り"
"うみねこ 海猫"
"うみの 海野"
"うみのいえ 海の家"
"うみのおや 産みの親 生みの親"
"うみのくるしみ 生みの苦しみ 産みの苦しみ"
"うみのさち 海の幸"
"うみのなかみち 海の中道"
"うみのひ 海の日"
"うみはら 海腹"
"うみびらき 海開き"
"うみへび 海蛇"
"うみべ 海辺"
"うみべり 海縁"
"うみほたる 海蛍"
"うみぼうず 海坊主"
"うみやま 海山"
"うむ 孳 有無"
"うむき 蛤"
"うめ 楳 梅"
"うめあわせ 埋め合せ 埋め合わせ"
"うめがえ 梅枝"
"うめがえもち 梅枝餅"
"うめがおか 梅が丘"
"うめがき 梅垣"
"うめがしま 梅ヶ島"
"うめがたに 梅ヶ谷"
"うめがわ 梅川"
"うめき 呻き 埋木"
"うめきち 梅吉"
"うめくさ 埋草 埋め草"
"うめこ 梅子"
"うめこうじ 梅小路"
"うめこぶちゃ 梅昆布茶"
"うめこみ 埋め込み"
"うめさお 梅棹"
"うめさわ 梅沢"
"うめざき 梅崎"
"うめざわ 梅澤 梅沢"
"うめしゅ 梅酒"
"うめず 梅図 梅津 楳図 梅酢"
"うめぞの 梅園"
"うめぞめ 梅染"
"うめた 梅田"
"うめたて 埋立て 埋立 埋め立て"
"うめたに 梅谷"
"うめだ 楳田 梅田"
"うめだきた 梅田北"
"うめづ 梅津"
"うめづけ 梅漬 梅漬け"
"うめにしき 梅錦"
"うめの 梅野"
"うめはら 梅原"
"うめばち 梅鉢"
"うめびしお 梅醤"
"うめぼし 梅干 梅干し"
"うめみ 梅見"
"うめみや 梅宮"
"うめむら 梅村"
"うめむろ 梅室"
"うめもと 梅本"
"うめもどき 梅擬"
"うめもり 梅森"
"うめやま 梅山"
"うも 芋"
"うもう 羽毛"
"うもうだ 羽毛田"
"うもん 宇門"
"うや 礼 雨夜"
"うやく 烏薬"
"うやま 宇山"
"うやむや 有耶無耶"
"うゆう 烏有"
"うよ 紆餘 紆余"
"うよう 右葉"
"うよく 羽翼 右翼"
"うら 錙 心 裡 占 浦 裏"
"うらあみ 裏編み"
"うらうえ 裏表"
"うらうす 浦臼"
"うらうち 裏打"
"うらうつり 裏移り"
"うらえ 浦江"
"うらえり 裏襟"
"うらおもて 裏表"
"うらかすみ 浦霞"
"うらかぜ 裏風 浦風"
"うらかた 裏方"
"うらかみ 浦上"
"うらかわ 浦川 浦河"
"うらが 浦賀"
"うらがお 裏顔"
"うらがき 裏書"
"うらがすみ 浦霞"
"うらがすみぜん 浦霞禅"
"うらがね 裏金"
"うらがみ 裏紙 浦上"
"うらがわ 裏皮 裏革 浦川 裏側"
"うらぎり 裏切"
"うらぐち 裏口"
"うらけい 裏罫"
"うらけん 裏拳"
"うらげい 裏芸"
"うらこう 浦港"
"うらごえ 裏声"
"うらごし 裏漉し"
"うらさ 浦佐"
"うらさく 裏作"
"うらさわ 浦沢"
"うらしの 嬉野"
"うらしま 浦島"
"うらしまそう 浦島草"
"うらじ 裏地"
"うらじおすとっく 浦鹽斯徳"
"うらじゃけ 裏ジャケ"
"うらじろ 裏白"
"うらじろがし 裏白樫"
"うらじろど 裏白戸"
"うらすじ 裏筋"
"うらずみ 裏住み"
"うらせ 浦瀬"
"うらぜん 浦禅"
"うらそえ 浦添"
"うらぞこ 浦底"
"うらた 浦田"
"うらだな 裏店"
"うらち 浦地"
"うらづけ 裏付"
"うらて 裏手"
"うらどら 裏ドラ"
"うらない 卦 卜い 占い"
"うらなみ 浦波"
"うらなり 末生り 末成り"
"うらにし 浦西"
"うらにわ 裏庭"
"うらの 浦野"
"うらはく 裏拍"
"うらはず 末筈 末弭"
"うらはま 浦浜"
"うらはら 裏原 裏腹"
"うらば 裏葉"
"うらばなし 裏話"
"うらばん 裏番"
"うらびでお 裏ビデオ"
"うらぶた 裏蓋"
"うらべ 裏部 浦辺 浦部 占部 卜部"
"うらべかねよし 卜部兼好"
"うらほ 裏帆"
"うらほろ 浦幌"
"うらぼん 裏盆 盂蘭盆"
"うらまち 裏町"
"うらまど 裏窓"
"うらみ 浦見 憾み 怨み 恨み"
"うらみごと 怨み言 恨み言"
"うらみち 裏道"
"うらみっこ 恨みっこ"
"うらみつらみ 恨みつらみ"
"うらみぶし 怨み節 恨み節"
"うらむ 怏"
"うらめ 裏目"
"うらめい 裏銘"
"うらめし 浦飯"
"うらめん 裏面"
"うらもと 浦本"
"うらもの 裏物"
"うらもん 裏紋 裏門"
"うらやす 浦安"
"うらやま 裏山 浦山"
"うらら 麗 麗ら"
"うららか 麗らか"
"うらる 烏拉"
"うらるあるたいごぞく ウラルアルタイ語族"
"うらるごぞく ウラル語族"
"うらわ 浦和"
"うらわざ 裏技"
"うらわみなみ 浦和南"
"うらんけいれつ ウラン系列"
"うらんのうしゅく ウラン濃縮"
"うり 売り 瓜"
"うりあげ 売上げ 売上"
"うりいえ 売り家"
"うりう 瓜生"
"うりか ウリ科"
"うりかけ 売り掛け 売掛"
"うりかた 売方"
"うりきれ 売切 売切れ"
"うりぎょく 売り玉 売玉"
"うりぐい 売り食い"
"うりぐすり 売り薬 売薬"
"うりけはい 売気配"
"うりこ 売子 売り子"
"うりことば 売言葉"
"うりこひめ 瓜子姫"
"うりごえ 売声"
"うりざね 瓜核 瓜実"
"うりそうば 売相場"
"うりだし 売出 売出し"
"うりだて 売建て 売建"
"うりだてぎょく 売建玉"
"うりち 売地"
"うりづら 瓜連"
"うりて 売手"
"うりぬし 売主"
"うりね 売り値 売値"
"うりの 売野"
"うりば 売場"
"うりふたつ 瓜二つ"
"うりぼう 瓜坊"
"うりみばえ 瓜実蠅"
"うりもく ウリ目"
"うりもの 売物"
"うりや 売り家"
"うりゅ 雨龍"
"うりゅう 雨龍 瓜生 雨竜"
"うりゅうの 瓜生野"
"うりょう 雨量"
"うりよね 売り米 糶"
"うりわたし 売渡し 売渡"
"うりん 雨林"
"うりんけ 羽林家"
"うる 宇留"
"うるい 潤"
"うるう 閏"
"うるうづき 閏月"
"うるうどし 閏年"
"うるうび 閏日"
"うるうびょう 閏秒"
"うるおい 潤い"
"うるか 潤香"
"うるき 夏枯草 売木"
"うるごめ 粳米"
"うるさ 煩"
"うるさがた うるさ型"
"うるし 漆"
"うるしえ 漆絵"
"うるしじ 漆地"
"うるしぬり 漆塗 漆塗り"
"うるしね 粳稲 粳"
"うるしねんぐ 漆年貢"
"うるしはら 漆原"
"うるしばた 漆畑"
"うるしま 漆島"
"うるしまけ 漆負け"
"うるしやま 漆山"
"うるた 粳田"
"うるち 粳"
"うるちまい うるち米 粳米"
"うるとらしー ウルトラＣ"
"うるむち 烏魯木斉"
"うるめ 潤目"
"うるめいわし 潤目鰯"
"うれ 売れ 末"
"うれあし 売れ足"
"うれい 騷 恙 愁い 憂い"
"うれう 悄"
"うれえ 愁え 憂え"
"うれし 嬉し"
"うれしがらせ 嬉しがらせ"
"うれしなみだ 嬉し涙"
"うれしの 嬉野"
"うれたんじゅし ウレタン樹脂"
"うれつ う列 ウ列"
"うれゆき 売行 売行き"
"うろ 虚 空洞 洞 空 有漏 迂路 烏鷺 雨露"
"うろう 傴僂"
"うろおぼえ 疎覚え うろ覚え"
"うろくず 鱗"
"うろこ 鱗"
"うろこがた 鱗形"
"うろこぐも 鱗雲"
"うろこじょう 鱗状"
"うろん 胡乱"
"うわ 宇和 上"
"うわあご 上顎"
"うわえ 上絵"
"うわえだ 上枝"
"うわえのぐ 上絵の具"
"うわがき 上書 上書き"
"うわがけ 上掛け"
"うわがまち 上框"
"うわがみ 上紙"
"うわがわ 上側"
"うわき 浮気"
"うわきごころ 浮気心"
"うわきしょう 浮気性"
"うわぎ 上衣 上着"
"うわくちびる 上唇"
"うわぐすり 上薬 釉薬 釉"
"うわぐつ 上靴"
"うわごえ 上声"
"うわごと 譫言"
"うわさ 噂"
"うわさのたね 噂の種"
"うわさばなし 噂話"
"うわざら 上皿"
"うわじまひがし 宇和島東"
"うわすべり 上滑り"
"うわずみ 上住 上澄み"
"うわぜい 上背"
"うわぞこ 上底"
"うわだな 上棚"
"うわちょうし 上調子"
"うわぢょうし 上調子"
"うわっちょうし 上っ調子"
"うわっつら 上っ面"
"うわっぱり 上っ張り"
"うわつき 上付き"
"うわつら 上面"
"うわづつみ 上包み"
"うわづみ 上積み"
"うわて 上手"
"うわなり 嫐"
"うわに 上荷"
"うわにぶね 上荷船"
"うわぬり 上塗り"
"うわね 上値"
"うわの 宇和野"
"うわのせ 上乗せ"
"うわのそら 上の空"
"うわのだい 上の台"
"うわのり 上乗り"
"うわばき 上履き"
"うわばみ 蠎蛇 蟒蛇"
"うわばり 上張り"
"うわひ 上翳"
"うわぶたしき 上蓋式"
"うわべ 上辺"
"うわまい 上米"
"うわまえ 上前"
"うわみ 宇和海 上身"
"うわみぞ 上溝"
"うわみの 上蓑"
"うわむき 上向き"
"うわめ 上目"
"うわめづかい 上目遣い"
"うわもの 上物"
"うわや 上屋"
"うわやく 上役"
"うわん 右腕"
"うん 曇 黄 褞 蘊 薀 慍 繧 吽 耘 紜 云 暈 雲 運"
"うんう 雲雨"
"うんえい 運営"
"うんえん 雲煙"
"うんえんかがん 雲煙過眼"
"うんか 浮塵子 雲霞"
"うんかい 雲海"
"うんかく 雲客 雲鶴"
"うんかん 雲漢"
"うんが 運河"
"うんき 温気 運気"
"うんきゅう 運弓 運休"
"うんけい 雲形 運慶"
"うんけいじょうぎ 雲型定規"
"うんげいせん 雲芸線"
"うんげん 繧繝"
"うんこう 暈光 運航 運行"
"うんこうまえてんけん 運行前点検"
"うんこく 雲谷"
"うんごうむしゅう 雲合霧集"
"うんさん 雲散"
"うんざん 運算"
"うんし 運指"
"うんしだい 運次第"
"うんしゅう 雲集 雲州 温州"
"うんしょうむさん 雲消霧散"
"うんしょく 暈色 慍色"
"うんしん 雲身 運針"
"うんしんげっせい 雲心月性"
"うんじゃく 雲雀"
"うんじゅ 琅珠"
"うんじょう 運上 雲上"
"うんじょうびと 雲上人"
"うんすい 雲水"
"うんせい 運星 運勢"
"うんぜん 雲仙"
"うんそう 運送"
"うんそく 運足"
"うんだい 雲台"
"うんだめし 運試し"
"うんちく 薀蓄 蘊蓄"
"うんちゃん 運ちゃん"
"うんちゅうはっかく 雲中白鶴"
"うんちょう 雲頂"
"うんちん 運賃"
"うんちんばこ 運賃箱"
"うんてい 雲梯"
"うんてん 運転"
"うんでい 雲泥"
"うんでいのさ 雲泥の差"
"うんどう 運動"
"うんどうえねるぎー 運動エネルギー"
"うんどうかく 運動覚"
"うんどんこん 運鈍根"
"うんなん 雲南"
"うんぬん 云云 云々"
"うんの 海野"
"うんのう 暈ノウ 雲衲 蘊奥"
"うんのじゅうざ 海野十三"
"うんぱん 雲版 運搬"
"うんぴつ 運筆"
"うんぴょう 雲表"
"うんぷう 雲風"
"うんぷてんぷ 運否天賦"
"うんぼ 雲母"
"うんまかせ 運任せ"
"うんむ 雲霧"
"うんめい 運命"
"うんめん 温麺"
"うんも 雲母"
"うんゆ 運輸"
"うんよう 運用"
"うんようがかり 運用掛"
"うんりゅう 雲竜"
"うんりゅうがた 雲龍型"
"うんりょう 雲量"
"え 杖 猥 懷 衞 繪 畫 惠 會 囘 回 衛 笑 榎 依 衣 慧 恵 枝 荏 得 会 柄 重 餌 江 画 絵"
"えーがた Ａ型"
"えーきゅう Ａ級"
"えーげかい エーゲ海"
"えーげぶんめい エーゲ文明"
"えーた Η η"
"えーばん Ａ判"
"えーびーがた ＡＢ型"
"えーぶいきき ＡＶ機器"
"えーぶいじょゆう ＡＶ女優"
"えーめん Ａ面"
"えあわせ 絵合 絵合わせ"
"えい 海鷂魚 頴娃 衡 娃 衞 縊 殪 咏 翳 裔 營 榮 蠑 塋 瑩 瀛 贏 楹 盈 暎 瑛 叡 睿 曵 曳 洩 潁 頴 穎 珱 瓔 纓 嬰 郢 栄 営 衛 詠 泳 永 鋭 影 映 英"
"えいい 栄位 嬰イ 衛尉 営為 鋭意"
"えいいち 詠一 榮一 英一 栄一"
"えいいん 影印"
"えいえい 永々 英英 営営 営々"
"えいえん 永延 永遠"
"えいおん 嬰音"
"えいか 穎果 詠歌"
"えいかく 鋭角"
"えいかん 永観 栄冠"
"えいが 栄画 栄華 映画"
"えいがく 栄学 英学"
"えいがないえいが 映画内映画"
"えいがものがたり 栄花物語"
"えいき 盈虧 永記 英気 鋭気"
"えいきち 永吉 栄吉"
"えいきゅう 永久"
"えいきゅうし 永久歯"
"えいきょ 盈虚"
"えいきょう 永享 影響"
"えいきょく 郢曲"
"えいぎょう 営業"
"えいぎょうばたけ 営業畑"
"えいぎょうまん 営業マン"
"えいぎん 詠吟"
"えいぐん 英軍"
"えいけい 鋭形 英系"
"えいけつ 永訣 英傑"
"えいけん 英検"
"えいげつ 盈月"
"えいげん 永源"
"えいこ 江威子 暎子 永子 瑛子 映子 英子 栄子 栄枯"
"えいこう 曳光 営口 栄幸 栄孝 曳行 曳航 栄光"
"えいこうだん 曳光弾"
"えいこく 英国"
"えいこさくけん 永小作権"
"えいこん 英魂"
"えいご 英五 英語"
"えいごう 永劫"
"えいさい 穎才 栄西 英才"
"えいさく 栄策 英作 栄作"
"えいさつ 縊殺"
"えいざぶろう 栄三郎"
"えいざん 叡山"
"えいし 詠史 英姿 衛視 衛士 英資 英詩 英紙"
"えいしき 英式"
"えいしゃ 影写 営舎 泳者 映写"
"えいしゃく 栄爵"
"えいしゅ 英主"
"えいしゅう 瀛州"
"えいしゅつ 詠出 映出"
"えいしゅん 英俊"
"えいしょ 営所 英書"
"えいしょう 永承 永正 詠唱"
"えいしょうぼん 影鈔本 影照本"
"えいしょく 栄職"
"えいしん 詠進 栄進"
"えいじ 英児 永二 英嗣 永治 鋭二 英史 栄次 英志 英次 栄二 英司 栄治 英治 英二 嬰児 英字"
"えいじつ 永日"
"えいじゅ 衛戍"
"えいじゅう 永住"
"えいじょく 栄辱"
"えいじろう 英辞郎"
"えいじん 英人"
"えいすう 英数"
"えいすけ 栄介 英輔 英介"
"えいせい 衞星 衞生 永逝 永生 永世 衛星 衛生"
"えいせいだい 衛星第"
"えいせいてれび 衛星テレビ"
"えいせん 鋭尖 曳船"
"えいぜん 営繕"
"えいそ 永祚"
"えいそう 営倉 詠草 営巣"
"えいぞう 栄蔵 英三 栄三 営造 影像 映像"
"えいぞく 永続"
"えいた 英太"
"えいたい 永代"
"えいたつ 英達 栄達"
"えいたろう 永太朗 栄太郎"
"えいたん 詠歎 詠嘆"
"えいだ 英田 栄田"
"えいだい 英題 永代"
"えいだいさんぎょう 永大産業"
"えいだつ 穎脱"
"えいだん 帝都高速度交通営団 営団 英断"
"えいち 睿智 叡知 英智 叡智 英知"
"えいちょう 永長"
"えいてい 営庭"
"えいてん 栄典 栄転"
"えいでん 営田 叡電"
"えいと 嬰ト"
"えいとう 衛陶"
"えいとく 永徳"
"えいどう 栄道 泳動"
"えいどく 英独"
"えいに 嬰ニ"
"えいにち 英日"
"えいにん 永仁"
"えいねん 永年"
"えいのう 営農"
"えいは 嬰ハ"
"えいはつ 映発"
"えいばん 英盤"
"えいびん 鋭敏"
"えいふう 英風"
"えいふく 永福"
"えいふつ 英仏"
"えいぶつ 詠物"
"えいぶん 叡聞 英文"
"えいへ 嬰ヘ"
"えいへい 衛兵"
"えいへいじ 永平寺"
"えいべい 英米"
"えいべつ 永別"
"えいほ 嬰ホ"
"えいほう 英法 鋭鋒 永保 泳法"
"えいまい 英邁"
"えいまん 永万"
"えいみ 詠美"
"えいみん 永眠"
"えいめい 英名 英明"
"えいめいかん 穎明館"
"えいもり 栄森"
"えいもん 営門"
"えいや 永夜"
"えいやく 英訳"
"えいゆう 英雄"
"えいよ 栄誉"
"えいよう 営養 栄耀 栄養"
"えいようし 栄養枝"
"えいらく 永楽"
"えいらん 英蘭"
"えいり 栄利 絵入り 鋭利 営利"
"えいりきょうげんぼん 絵入狂言本"
"えいりゃく 永暦"
"えいりょ 叡慮"
"えいりょう 英領"
"えいりん 英鈴 営林 映倫"
"えいれい 英霊"
"えいろ 嬰ロ"
"えいろく 永禄"
"えいわ 永和 英和"
"えいん 会陰"
"えうぽまちあか エウポマチア科"
"ええた Η η"
"えかき 絵書き 絵描き"
"えかきうた 絵書き歌"
"えがお 笑顔"
"えがきて 描き手"
"えがしら 江頭"
"えがたい 得難い"
"えがみ 江上"
"えがら 絵柄"
"えがわ 江川"
"えがわすぐる 江川卓"
"えき 伯 依帰 奕 亦 蜴 易 驛 懌 繹 掖 腋 疫 役 益 液 駅"
"えきあつぷれす 液圧プレス"
"えきあんない 駅案内"
"えきいん 駅員"
"えきうら 駅裏"
"えきうり 駅売り"
"えきえき 液液"
"えきおん 液温"
"えきか 腋花 液果 腋下 腋窩 液化"
"えきかかりいん 駅係員"
"えきかがす 液化ガス"
"えきかん 駅間"
"えきが 腋芽"
"えきがく 易学 疫学"
"えきがわ 駅側"
"えきき 疫鬼"
"えききょう 易経"
"えききん 益金"
"えきぎゅう 役牛"
"えきけん 益軒"
"えきげしゃ 駅下車"
"えきこうない 駅構内"
"えきごと 駅毎"
"えきざい 液剤"
"えきしせつ 駅施設"
"えきしゃ 易者 駅舎"
"えきしゃさんゆう 益者三友"
"えきしゅう 腋臭"
"えきしゅうへん 駅周辺"
"えきしょう 液晶"
"えきしょうてれび 液晶テレビ"
"えきしょうでぃすぷれい 液晶ディスプレイ"
"えきしょうぱねる 液晶パネル"
"えきしょうもにたー 液晶モニター"
"えきじたい 駅自体"
"えきじゅう 益獣 液汁"
"えきじょう 液状"
"えきす 越幾斯"
"えきすう 駅数"
"えきせい 腋生 駅制 易姓 液性"
"えきせん 易占"
"えきぜんぶ 駅全部"
"えきそう 液相"
"えきたい 液体"
"えきだん 易断"
"えきちく 役畜"
"えきちゅう 益虫 液中"
"えきちょう 益鳥 駅長"
"えきてい 駅逓"
"えきてき 液滴"
"えきでん 驛傳 駅伝"
"えきとう 駅頭"
"えきどめ 駅止め 駅止"
"えきない 駅内"
"えきね 駅寝"
"えきばいてん 駅売店"
"えきばしゃ 駅馬車"
"えきひ 液肥"
"えきひょうじ 駅表示"
"えきびょう 疫病"
"えきびょうがみ 疫病神"
"えきびる 駅ビル"
"えきふ 役夫"
"えきふきん 駅付近"
"えきべつ 駅別"
"えきべん 液便 駅弁"
"えきほう 液胞"
"えきほんや 駅本屋"
"えきまえ 駅前"
"えきむ 役務"
"えきめい 駅名"
"えきめいばん 駅名板"
"えきめいひょう 駅名標"
"えきもれ 液漏れ"
"えきや 駅家"
"えきゆう 益友"
"えきらん 液卵"
"えきり 疫痢"
"えきりようしゃ 駅利用者"
"えきりんぼん 易林本"
"えきれい 疫癘 液冷"
"えきろ 駅路"
"えぎ 江木"
"えぎぬ 絵絹"
"えぎょう え行 エ行"
"えくぼ 靨"
"えぐち 江口"
"えぐみ 刳味 絵組み 絵組"
"えけい 恵瓊"
"えげ 会下"
"えこ 依怙"
"えこう 回向"
"えこだ 江古田"
"えことば 絵詞"
"えこん 慧根"
"えこんて 絵コンテ"
"えごうらい 絵高麗"
"えごころ 絵心"
"えごのり 恵胡海苔"
"えごま 荏胡麻"
"えごよみ 絵暦"
"えさ 餌"
"えさか 江坂"
"えさき 江崎"
"えさぎ 餌木"
"えさし 江指 枝幸 江差 江刺"
"えさだい 餌代"
"えさづり 餌釣り"
"えさば 餌場"
"えさばこ 餌箱"
"えさや 餌屋"
"えさん 恵山"
"えざ 会座"
"えざき 江崎"
"えざきぐりこ 江崎グリコ"
"えざら 絵皿"
"えざわ 江澤 江沢"
"えし 画師 壊死 絵師"
"えしき 会式"
"えしゃく 会釈"
"えしゃじょうり 会者定離"
"えじ 江地 衛士"
"えじき 餌食"
"えじぷと 埃及"
"えじぷとご エジプト語"
"えじぷとじん エジプト人"
"えじま 江嶋 江島"
"えすえすせいやく エスエス製薬"
"えすえぬひ ＳＮ比"
"えすえふしょうせつ ＳＦ小説"
"えすがた 絵姿"
"えすきもーけん エスキモー犬"
"えすきょく Ｓ極"
"えすさいず Ｓサイズ"
"えすじ Ｓ字"
"えすせき Ｓ席"
"えすは Ｓ波"
"えすびーしょくひん ヱスビー食品 エスビー食品"
"えず 絵図"
"えずみ 江角"
"えずりこ 江釣子"
"えせ 似而非 似非"
"えそ 狗母魚 壊疽"
"えそらごと 絵空事"
"えぞ 蝦夷"
"えぞう 絵像"
"えぞえ 江副"
"えぞしか 蝦夷鹿"
"えぞまつ 蝦夷松"
"えぞら 江面"
"えた 穢多"
"えたい 得体"
"えたじま 江田島"
"えだ 荏田 江田 枝"
"えだうち 枝打ち"
"えだかり 枝刈り"
"えだがり 枝刈り"
"えだがわ 枝川"
"えだがわり 枝変わり"
"えだきりばさみ 枝切り鋏"
"えだげ 枝毛"
"えだじょう 枝状"
"えだずみ 枝炭"
"えだせん 枝線"
"えだち 役"
"えだなみ 枝並"
"えだにく 枝肉"
"えだにょう 支繞"
"えだの 枝野"
"えだは 枝葉"
"えだばり 枝針"
"えだばん 枝番"
"えだぶり 枝振り"
"えだまつ 枝松"
"えだまめ 枝豆"
"えだみち 枝道 岐路"
"えだわかれ 枝わかれ 枝分かれ"
"えだん エ段"
"えち 乢"
"えちがわ 愛知川"
"えちご 越後"
"えちぜん 越前"
"えちぜんがに 越前蟹"
"えちぜんみさき 越前岬"
"えちぜんやき 越前焼"
"えっか 越夏"
"えっきょう 越境"
"えっくすきゃく Ｘ脚"
"えっくすじく Ｘ軸"
"えっくすせん Ｘ線"
"えっけん 越権 謁見"
"えっしゅう 越州"
"えっせいしゅう エッセイ集"
"えっそ 越訴"
"えっちゅう 越中"
"えっちゅうふんどし 越中褌"
"えっとう 越冬"
"えっふぇるとう エッフェル塔"
"えっぷく 悦服"
"えっぺい 閲兵"
"えつ 斉魚 鉞 越 戉 粤 謁 噎 咽 閲 悦"
"えつお 悦夫"
"えつけ 絵付け"
"えつこ 絵津子 えつ子 恵津子 英津子 悦子"
"えつじ 悦次 悦司"
"えつたろう 悦太郎"
"えつづみ 兄鼓"
"えつどく 閲読"
"えつなん 越南"
"えつねん 越年"
"えつねんそう 越年草"
"えつもくしょう 悦目抄"
"えつや 悦哉 悦也"
"えつよ 悦代"
"えつらく 悦楽"
"えつらん 閲覧"
"えつり 桟"
"えつれき 閲歴"
"えつろう 悦朗"
"えづくり 絵作り"
"えづけ 餌付け"
"えづら 絵面"
"えて 得手"
"えてき 絵的"
"えてこう 猿猴 エテ公 猿公"
"えてして 得てして"
"えてんらく 越天楽"
"えでほん 絵手本"
"えと 江渡 干支"
"えとう 恵藤 江頭 衛藤 江藤"
"えとき 絵解き"
"えとく 会得"
"えとり 餌取り"
"えとるりあご エトルリア語"
"えとるりあじん エトルリア人"
"えとろふ 択捉"
"えど 穢土 江戸"
"えどがろう 江戸家老"
"えどくら 江戸蔵"
"えどさき 江戸崎"
"えどさんざ 江戸三座"
"えどざき 江戸崎"
"えどむらさき 江戸紫"
"えな 絵奈 胞衣 恵那"
"えなが 柄長"
"えなざくら 恵那櫻"
"えなつ 江夏"
"えなみ 榎並"
"えなめるがわ エナメル革"
"えなめるしつ エナメル質"
"えなめるせん エナメル線"
"えなり 江成"
"えなんじ 淮南子"
"えに 縁"
"えにし 縁"
"えにっき 絵日記"
"えにわ 恵庭"
"えぬえちけいほーる ＮＨＫホール"
"えぬかっけい Ｎ角形"
"えぬきょう Ｎ響"
"えぬきょく Ｎ極"
"えぬこ Ｎ個"
"えぬじげん Ｎ次元"
"えぬま 江沼"
"えねるぎーぐん エネルギー群"
"えねるぎーげん エネルギー源"
"えねるぎーこうりつ エネルギー効率"
"えねるぎーしょう エネルギー省"
"えねるぎーせいさく エネルギー政策"
"えねるぎーそんしつ エネルギー損失"
"えねるぎーもんだい エネルギー問題"
"えの 榎"
"えのき 榎木 榎"
"えのきたけ 榎茸"
"えのきだ 榎田"
"えのきど 榎戸"
"えのぐ 絵具 絵の具"
"えのこ 狗"
"えのしま 江の島 江ノ島"
"えのぞの 榎園"
"えのでん 江の電"
"えのと 榎戸"
"えのもと 榎本"
"えはがき 絵はがき 絵葉書"
"えはた 江幡 江畑"
"えはだ 絵肌"
"えはら 荏原 江原"
"えばた 江端"
"えばら 荏原 江原"
"えばらこ 桧原湖"
"えひめ 愛媛"
"えび 葡萄 鰕 蛯 蝦 海老"
"えびいも 海老芋 蝦芋"
"えびお 海老尾"
"えびがため 海老固め"
"えびがに 海老蟹"
"えびさわ 海老澤 海老沢"
"えびす 貊 狄 胡 蛭子 戎 夷 恵比寿 恵比須"
"えびすぐさ 夷草 恵比須草"
"えびすこう 恵比須講"
"えびすごころ 夷心"
"えびすのうお 恵比須の魚"
"えびすばし 戎橋"
"えびぞり 海老反り"
"えびづか 海老塚"
"えびづる 蝦蔓"
"えびてん 海老天 エビ天"
"えびな 蛯名 蝦名 海老名"
"えびね 恵比根"
"えびはら 蛯原 海老原"
"えびふらい 海老フライ"
"えびら 箙"
"えふ 衛府"
"えふだ 絵札"
"えふで 絵筆"
"えぶっし 絵仏師"
"えぷろんすがた エプロン姿"
"えべ 江辺"
"えべつ 江別"
"えほう 恵方 吉方"
"えほうまき 恵方巻"
"えほん 絵本"
"えぼうしょ 絵奉書"
"えぼし 烏帽子"
"えぼしおや 烏帽子親"
"えぼだい えぼ鯛"
"えぽ ＥＰＯ"
"えぽきしじゅし エポキシ樹脂"
"えま 江馬 絵麻 絵馬"
"えまき 絵巻"
"えみ 江民 笑 恵実 栄美 江見 映見 絵美 恵美 笑み"
"えみか 恵美香"
"えみこ 絵己子 栄美子 江美子 英美子 絵美子 恵美子"
"えみし 蝦夷"
"えみや 円宮 江美弥"
"えむかえ 江迎"
"えむさいず Ｍサイズ"
"えむら 江村"
"えめらるどいろ エメラルド色"
"えもじ 絵文字"
"えもと 柄本 絵本 江本"
"えもの 得物 獲物"
"えものがたり 絵物語"
"えもん 衣文 衣紋 衛門"
"えもんかけ 衣紋掛 衣紋掛け"
"えやみ 疫病み 瘧"
"えよう 栄耀"
"えら 江良 腮 鰓"
"えらーおん エラー音"
"えらーしょり エラー処理"
"えらーりつ エラー率"
"えらあな 鰓孔"
"えらこきゅう 鰓呼吸"
"えらさ 偉さ"
"えらびかた 選び方"
"えらぶた 鰓蓋"
"えらぶつ 偉物 豪物"
"えり 衣理 愛莉 惠理 枝里 絵莉 江利 衣里 愛理 英理 恵利 恵里 絵理 恵理 絵里 衿 襟"
"えりあか 襟垢"
"えりあし 襟足"
"えりうら 襟裏"
"えりか 江利香 惠理香 絵里花 恵理香"
"えりかざり 襟飾り"
"えりがみ 襟髪"
"えりくび 襟首"
"えりぐり 襟刳り"
"えりこ 悦吏子 絵梨子 江利子 英里子 英理子 江里子 恵里子 江梨子 絵理子 恵理子 えり子"
"えりごのみ えり好み 選り好み"
"えりさ 恵利沙"
"えりさき 襟先"
"えりしょう 衿章 襟章"
"えりすぐり 選りすぐり"
"えりぜきゅう エリゼ宮"
"えりぜに 撰り銭"
"えりだぬすざ エリダヌス座"
"えりな 江理奈"
"えりぬき 選り抜き"
"えりはば 襟幅"
"えりまき 襟巻"
"えりまわり 襟回り 襟周り"
"えりみ 恵里美"
"えりもと 襟元"
"えりもみさき 襟裳岬"
"えるえるさいず ＬＬサイズ"
"えるさいず Ｌサイズ"
"えれつ え列 エ列"
"えろがぞう エロ画像"
"えろほん エロ本"
"えん ￥ 閼 覃 渊 渕 圜 圓 鹽 艷 衍 淵 鳶 垣 演 櫞 掾 檐 簷 寃 冤 蜿 婉 鴛 怨 宛 閹 淹 掩 奄 蜒 筵 延 薗 轅 袁 遠 猿 爰 湲 媛 援 悁 捐 讌 臙 嚥 燕 黶 魘 厭 烟 煙 炎 閻 焔 偃 堰 沿 鉛 篶 嫣 焉 艶 宴 苑 園 塩 縁 円"
"えんあん 塩安"
"えんい 遠位"
"えんいた 縁板"
"えんいん 援引 延引 遠因"
"えんう 煙雨"
"えんうり 円売り"
"えんうん 煙雲"
"えんうんどう 円運動"
"えんえい 遠泳"
"えんえき 演繹"
"えんえきぎ 演繹木"
"えんえん 蜿蜿 奄奄 炎炎 延延 蜿々 蜿蜒 奄々 炎々 延々"
"えんお 厭悪"
"えんおう 閻王 延応 鴛鴦"
"えんか 烟霞 縁家 煙霞 怨歌 円価 艶歌 煙火 円貨 嚥下 塩化 演歌"
"えんかい 遠海 延会 沿海 宴会"
"えんかいしょく 鉛灰色"
"えんかく 遠隔 沿革"
"えんかつ 円滑"
"えんかてつ 塩化鉄"
"えんかどう 塩化銅"
"えんかびにる 塩化ビニル"
"えんかる 遠軽"
"えんかわ 圓川"
"えんかわせ 円為替"
"えんかん 鉛管 煙管 円環"
"えんかんぎょ 塩乾魚"
"えんかんさん 円換算"
"えんかんすう 円関数"
"えんがい 掩蓋 鉛害 円蓋 煙害 円買い 円外 塩害"
"えんがく 縁覚"
"えんがる 遠軽"
"えんがわ 縁側"
"えんがん 遠眼 沿岸"
"えんがんぎょ 沿岸魚"
"えんき 円規 塩基 延期"
"えんきごう 円記号"
"えんきどう 円軌道"
"えんきゅう 円丘 円球 延久"
"えんきょう 円鏡 延慶 燕京 延享"
"えんきょく 婉曲"
"えんきょり 遠距離"
"えんきり 縁切り"
"えんきりでら 縁切り寺 縁切寺"
"えんきん 遠近"
"えんぎ 演戯 延喜 演義 縁起 演技"
"えんぎょ 塩魚"
"えんくう 円空"
"えんぐみ 縁組"
"えんぐらふ 円グラフ"
"えんぐん 援軍"
"えんけい 冤刑 燕京 遠景 円形"
"えんけん 偃蹇"
"えんげ 嚥下"
"えんげい 園藝 演芸 園芸"
"えんげき 演劇"
"えんげつ 偃月"
"えんげつとう 偃月刀"
"えんげるけいすう エンゲル係数"
"えんげん 怨言 延元 淵源"
"えんこ ⌒ 塩湖 円弧 縁故"
"えんこう 猿猴 円光 援交"
"えんこうきんこう 遠交近攻"
"えんこうじばん 円光寺版"
"えんこうるい 円口類"
"えんこく 遠国"
"えんこさい 縁故債"
"えんこん 怨恨"
"えんご 婉語 掩護 縁語 援護"
"えんごく 遠国"
"えんごさく 延胡索"
"えんさ 怨嗟"
"えんさき 縁先"
"えんさつ 円札"
"えんさん 演算 塩酸"
"えんざ 円坐 縁坐 縁座 宴座 円座"
"えんざい 寃罪 冤罪"
"えんざん 鉛槧 圓山 遠山 塩山 演算"
"えんし 艶姿 遠視"
"えんしつ 煙室"
"えんしゃ 園舎 演者"
"えんしゃっかん 円借款"
"えんしゅう 円宗 怨讐 円周 遠州 演習"
"えんしゅうりん 演習林"
"えんしゅつ 演出"
"えんしょ 縁書 艶書 炎暑"
"えんしょう 遠称 煙硝 円生 袁紹 艶笑 延焼 炎症"
"えんしょうじ 円勝寺"
"えんしょく 怨色 焔色 炎色"
"えんしょくせい 演色性"
"えんしん 円唇 円心 遠心 延伸"
"えんじ 槐 衍字 燕脂 臙脂 園児"
"えんじつてん 遠日点"
"えんじて 演じ手"
"えんじゃ 縁者 演者"
"えんじゃく 燕雀"
"えんじゅ 槐"
"えんじゅく 円熟"
"えんじゅつ 演述"
"えんじゅんれつ 円順列"
"えんじょ 援助"
"えんじょう 遠城 円状 炎上"
"えんじょうじ 円城寺"
"えんじん 閹人 厭人 煙塵 遠人 円陣 猿人"
"えんじんおん エンジン音"
"えんすい 鉛錘 塩水 円錐"
"えんすいこ 塩水湖"
"えんずい 延髄"
"えんずいぎり 延髄斬"
"えんせい 縁生 厭世 延性 遠征"
"えんせいがい 袁世凱"
"えんせき 遠戚 塩析 遠赤 宴席 縁石"
"えんせきもんだい 円積問題"
"えんせん 塩泉 厭戦 沿線"
"えんせんず 円線図"
"えんぜつ 演舌 演説"
"えんぜん 宛然 婉然 嫣然 艶然"
"えんそ 塩酢 遠祖 塩素"
"えんそう 燕巣 演奏"
"えんそうば 円相場"
"えんそく 遠足"
"えんそくこ 堰塞湖"
"えんぞう 円蔵 塩蔵"
"えんた 苑田 遠田"
"えんたい 淹滞 掩体 延滞"
"えんたく 円卓"
"えんたん 鉛丹"
"えんたんい 円単位"
"えんだ 苑田 遠田"
"えんだい 円台 縁台 演台 遠大 演題"
"えんだか 円高"
"えんだて 円建て"
"えんだま 円玉"
"えんだん 演壇 縁談"
"えんち 園池 遠地 園地"
"えんちくでんち 鉛蓄電池"
"えんちゃく 延着"
"えんちゅう 円柱"
"えんちょう 円頂 園長 延長"
"えんちょうきゅう 円頂丘"
"えんちょく 鉛直"
"えんちん 遠沈"
"えんつづき 縁続き"
"えんてい 園丁 堰堤 園庭"
"えんてつ 遠鉄"
"えんてん 遠点 炎天"
"えんてんかつだつ 円転滑脱"
"えんでん 塩田"
"えんとう 煙筒 円頭 遠島 遠投 円筒"
"えんとく 延徳"
"えんとつ 煙突"
"えんど 塩度"
"えんどう 筵道 羨道 豌豆 沿道 遠藤"
"えんどうまめ 豌豆豆"
"えんどおい 縁遠い"
"えんどく 煙毒 鉛毒"
"えんどる 円ドル"
"えんない 円内 園内"
"えんにち 縁日"
"えんにゅう 衍入"
"えんにょう 延繞"
"えんねつ 炎熱"
"えんねん 延年"
"えんのう 延納"
"えんのぎょうじゃ 役行者"
"えんのした 縁の下"
"えんのすけ 猿之助"
"えんば 焉馬"
"えんばく 燕麦"
"えんばん 鉛版 円板 円盤"
"えんぱく 鉛白 延泊"
"えんぱつ 延発"
"えんび 塩ビ 燕尾"
"えんぴ 円匙 猿臂"
"えんぴつ 鉛筆"
"えんぴつけずり 鉛筆削り"
"えんぶ 円舞 演武 演舞"
"えんぶん 艶文 艶聞 延文 塩分"
"えんぶんれん 遠文連"
"えんぷく 艶福"
"えんぷん 円墳"
"えんへんこう 円偏光"
"えんべつ 遠別"
"えんぺい 援兵 掩蔽"
"えんぺん 縁辺"
"えんぼう 怨望 遠謀 遠望"
"えんぽう 演報 延宝 遠方"
"えんぽん 艶本 円本"
"えんま 絵馬 閻魔"
"えんまく 煙幕"
"えんまん 円満"
"えんみらい 遠未来"
"えんむ 煙霧"
"えんむすび 縁結び"
"えんめい 艶名 延命"
"えんもく 演目"
"えんもくとじ 鳶目兎耳"
"えんや 艶冶 塩冶"
"えんやす 円安"
"えんゆ 縁由"
"えんゆう 円融"
"えんゆうかい 宴遊会 園遊会"
"えんゆうさんだい 円融三諦"
"えんよう 艶容 遠洋 援用"
"えんらい 遠雷 遠来"
"えんらく 宴楽 円楽 猿楽"
"えんり 厭離"
"えんりゃく 延暦"
"えんりゅう 淹留"
"えんりょ 遠慮"
"えんりん 園林"
"えんる 遠流"
"えんるい 縁類 塩類"
"えんれい 延齢 艶麗"
"えんれいそう 延齢草"
"えんろ 遠路"
"お 織 桜 穂 朗 郎 勇 将 央 夫 和 生 乎 塢 嗚 淤 唹 於 麻 苧 悪 男 牡 雄 小 緒 汚 御 尾"
"おーがた Ｏ型"
"おーきゃく Ｏ脚"
"おーすとらりあ 濠太剌利"
"おーすとらりあさん オーストラリア産"
"おーすとらりあじん オーストラリア人"
"おーすとらりあたいりく オーストラリア大陸"
"おーすとりあ 墺太利"
"おーすとりあじん オーストリア人"
"おーすとろねしあごぞく オーストロネシア語族"
"おーとましゃ オートマ車"
"おーとむぎ オート麦"
"おーなーめい オーナー名"
"おーぷんかかく オープン価格"
"おーぷんせん オープン戦"
"おーむ 王蟲 Ω"
"おーやんふぃふぃ 欧陽菲菲"
"おーるすたーせん オールスター戦"
"おーれ ＯＲＥ"
"おあ ∨ ∪"
"おあいそ お愛想"
"おあいて 御相手 お相手"
"おあいにくさま 御生憎様"
"おあがり お上がり"
"おあげ お揚げ"
"おあし 御足"
"おあじ お味"
"おあずかり お預 お預り"
"おあずけ お預け"
"おあそび お遊び"
"おあふとう オアフ島"
"おあらため お改め"
"おい 及 老い 追 笈 甥"
"おいうち 追撃ち 追打ち 追討ち 追い撃ち 追い打ち 追い討ち"
"おいえ 尾家"
"おいえげい 御家藝 御家芸 お家芸"
"おいえそうどう 御家騒動"
"おいえりゅう 御家流"
"おいおい 追々 追い追い"
"おいかぜ 追風 追い風"
"おいかわ 生川 追川 及川"
"おいがつお 追い鰹"
"おいけ 御池"
"おいこし 追越し 追越 追い越し"
"おいこみ 追込み 追込 追い込み"
"おいこみうま 追込み馬 追い込み馬"
"おいこん 追いコン"
"おいごえ 追肥 追い肥"
"おいさき 生い先"
"おいしゃ お医者"
"おいしゃさん お医者さん"
"おいしょう 追証"
"おいしょうこきん 追証拠金"
"おいしんぼ 美味しんぼ"
"おいせん 追銭 追い銭"
"おいそぎ お急ぎ"
"おいたち 生立ち 生い立ち"
"おいたて 追立て"
"おいだき 追炊き 追い焚 追い炊き"
"おいだし 追出 追出し 追い出し"
"おいだしこんぱ 追い出しコンパ"
"おいち お市 尾市"
"おいっこ 甥っ子"
"おいつ 老津"
"おいつおわれつ 追いつ追われつ"
"おいて 於 追風 於て"
"おいてきぼり 置いてきぼり"
"おいてけぼり 置いてけ堀"
"おいで 御出で お出で"
"おいとま お暇 御暇"
"おいのこぶみ 笈の小文"
"おいのり お祈り"
"おいはぎ 追い剥ぎ 追剥"
"おいはま 追浜 生浜"
"おいばね 追羽根"
"おいばらい 追い払い"
"おいべ 及部"
"おいぼし 追星"
"おいぼれ 老いぼれ"
"おいまつ 老松"
"おいまわし 追回し 追い回し 追廻"
"おいみどり 老緑"
"おいめ 負い目"
"おいめい 甥姪"
"おいらく 老いらく"
"おいらせ 奥入瀬"
"おいらん 花魁"
"おいろ 御色"
"おいろけ お色気"
"おいろなおし お色直し"
"おいわ お岩"
"おいわい 御祝い 御祝 お祝い"
"おいわけ 追分"
"おいわけぶし 追分節"
"おう 悒 邑 姶 鏖 蓊 瓮 浤 泓 鴬 媼 凹 鸚 罌 嚶 櫻 桜 汪 枉 旺 徃 往 閘 鴨 押 澳 懊 墺 襖 奧 奥 謳 甌 毆 殴 歐 嘔 鴎 鞅 秧 泱 殃 怏 央 應 応 惶 凰 皇 横 黄 翁 欧 王"
"おうあ 歐亞 欧亜"
"おうあん 応安"
"おうあんせき 王安石"
"おうい 王威 横位 王位"
"おういつ 汪溢 横溢"
"おういん 桜蔭 押韻 押印"
"おういんご 欧印語"
"おういんし 押韻詩"
"おうう 奥羽"
"おううん 桜雲"
"おうえ 黄衣"
"おうえい 応永"
"おうえん 応援"
"おうお 大魚"
"おうおう 怏怏 汪々 怏々 往々"
"おうか 櫻花 王化 欧化 応化 押下 謳歌 桜花"
"おうかがい お伺い"
"おうかく 凹角 旺角"
"おうかくまく 横膈膜 横隔膜"
"おうかざい 横架材"
"おうかしょうば 桜花賞馬"
"おうかっしょく 黄褐色"
"おうかん 往還 王冠"
"おうが 横臥"
"おうがい 鴎外"
"おうがく 王学"
"おうがた 凹型"
"おうき 応器 嘔気"
"おうきゅう 王宮 応急"
"おうぎ 横議 奥儀 奥義 扇"
"おうぎがた 扇形"
"おうぎがやつ 扇ヶ谷"
"おうぎさわ 扇沢"
"おうぎし 王羲之"
"おうぎじょう 扇状"
"おうぎや 扇谷"
"おうぎょく 黄玉"
"おうけ 王家"
"おうけつ 甌穴"
"おうけとり お受け取り"
"おうけん 王権"
"おうげ 応化"
"おうこ 往古"
"おうこう 往航 王后 王公 王侯 横行"
"おうこうかっぼ 横行闊歩"
"おうこく 王国"
"おうご 鶯語 朷"
"おうごん 黄金"
"おうごんちゅう 黄金虫"
"おうさか 逢坂"
"おうさだはる 王貞治"
"おうさつ 鏖殺 殴殺 応札"
"おうさま 王様"
"おうざ 王座"
"おうし 黄紙 横死 牡牛 雄牛"
"おうしかん 欧氏管"
"おうしき 黄鐘"
"おうしつ 王室"
"おうしゃ 王者"
"おうしゃじょう 王舎城"
"おうしゅ 応手"
"おうしゅう 歐州 歐洲 欧洲 奥州 応酬 押収 欧州"
"おうしょ 押書"
"おうしょう 鞅掌 応鐘 応召 王将"
"おうしょうくん 王昭君"
"おうしょく 応嘱 黄色"
"おうしん 往信 往診"
"おうじ 欧字 王地 往事 王寺 往時 皇子 王子"
"おうじつ 往日"
"おうじつせい 横日性"
"おうじゃ 王者"
"おうじゃく 往昔"
"おうじゅ 応需"
"おうじゅく 黄熟"
"おうじゅほうしょう 黄綬褒章"
"おうじょ 皇女 王女"
"おうじょう 応情 王城 往生"
"おうじょうぎわ 往生際"
"おうじょうけん 応用情報学研究センター"
"おうじん 応身"
"おうじんてんのう 応神天皇"
"おうす 御薄"
"おうすい 王水"
"おうすう 応数"
"おうせ 逢瀬"
"おうせい 黄精 応制 王制 王政 旺盛"
"おうせいもう 黄青盲"
"おうせき 往昔"
"おうせつ 応接"
"おうせん 鏖戦 横線 応戦"
"おうぜん 汪然"
"おうぜんじ 王禅寺"
"おうそ 応訴"
"おうそう 押送"
"おうそうじ 大掃除"
"おうそうだん 応相談"
"おうぞく 王族"
"おうた 桜多 御歌"
"おうたい 横隊 黄体 応対"
"おうたいほるもん 黄体ホルモン"
"おうだ 殴打"
"おうだく 黄濁 応諾"
"おうだつ 横奪"
"おうだん 黄丹 黄胆 応談 黄疸 横断"
"おうだんきょう 横断橋"
"おうち 尾内 欒 邑智 相知 お家 楝 樗"
"おうちゃく 横着"
"おうちょう 応長 王朝"
"おうて 王手 追手"
"おうてい 奥底"
"おうてき 横笛"
"おうてっこう 黄鉄鉱"
"おうてん 横転"
"おうでん 応電"
"おうと 王都 嘔吐"
"おうとう 櫻桃 王党 王統 鴨東 桜桃 応答"
"おうとく 応徳"
"おうとつ 凹凸"
"おうど 王土 黄土"
"おうどう 横動 黄道 黄銅 横道 王道"
"おうどうこう 黄道光 黄銅鉱"
"おうな 嫗 媼"
"おうなつ 押捺"
"おうに 黄丹"
"おうにん 応仁"
"おうにんのらん 応仁の乱"
"おうねつびょう 黄熱病"
"おうねん 往年"
"おうのう 応能 懊悩"
"おうはん 往反 凹版 黄斑"
"おうばい 黄梅"
"おうばく 黄蘗 黄檗"
"おうばん 黄幡"
"おうばんが 凹版画"
"おうばんぶるまい 椀飯振る舞い 椀飯振舞い 椀飯振舞"
"おうひ 横被 横披 応否 奥秘 王妃"
"おうびゃく 黄白"
"おうびりん 桜美林"
"おうふ 王父"
"おうふう 欧風"
"おうふく 往復"
"おうふくびんた 往復ビンタ"
"おうぶつ 応用物理 応物"
"おうぶん 応分 欧文"
"おうぶんしゃ 旺文社"
"おうへい 横柄"
"おうへん 王偏 往反 往返 応変 黄変"
"おうべい 欧米"
"おうべいば 欧米馬"
"おうほう 應報 応保 往訪 王法 応報"
"おうぼ 王母 応募"
"おうぼう 王法 横暴"
"おうぼばこ 応募箱"
"おうま 黄麻 お馬 逢魔"
"おうまがとき 逢魔が刻"
"おうみ 青海 近江"
"おうみしおつ 近江塩津"
"おうみしおづ 近江塩津"
"おうみしま 青海島"
"おうみちょうしじょう 近江町市場"
"おうむ 王蟲 雄武 鸚鵡"
"おうむがい 鸚鵡貝"
"おうむがえし おうむ返し"
"おうむしんりきょう オウム真理教"
"おうむびょう オウム病"
"おうめ 青梅"
"おうめい 王命"
"おうめん 凹面"
"おうめんきょう 凹面鏡"
"おうもう 王莽"
"おうもんきん 横紋筋"
"おうゆう 鴎友"
"おうよう 應用 鷹揚 応用"
"おうようしゅう 欧陽脩"
"おうようめい 王陽明"
"おうら 邑楽"
"おうらい 往来"
"おうりつ 王立"
"おうりゅう 横流"
"おうりょう 押領 横領"
"おうりょうき 応量器"
"おうりょうし 押領使"
"おうりょく 応力"
"おうりょくこう 鴨緑江"
"おうりょくしょく 黄緑色"
"おうりん 黄燐"
"おうれつ 横列"
"おうれつか 横裂果"
"おうれん 黄連 黄蓮"
"おうれんあか オウレン亜科"
"おうれんず 凹レンズ"
"おうろ 欧露 往路"
"おうわ 応和"
"おえ 汚穢 小江"
"おえかき お絵書き お絵かき お絵描き"
"おえつ 嗚咽"
"おえどにほんばし お江戸日本橋"
"おえらがた 御偉方 お偉方"
"おお 夛 多 大"
"おおあえ 大饗"
"おおあかじ 大赤字"
"おおあきない 大商い"
"おおあきんど 大商人"
"おおあさ 大麻 大朝"
"おおあざ 大字"
"おおあし 大足"
"おおあじ 大味"
"おおあせ 大汗"
"おおあたま 巨頭 大頭"
"おおあたり 大当たり 大当り"
"おおあな 大穴"
"おおあね 大姉"
"おおあばれ 大暴れ"
"おおあま 大甘"
"おおあまのおうじ 大海人皇子"
"おおあみ 大網"
"おおあめ 大雨"
"おおあらい 大洗"
"おおあり 大有り"
"おおありくい 大蟻食"
"おおあれ 大荒れ"
"おおあわ 粱"
"おおあわて 大慌て"
"おおい 大炊 大飯 大井 覆い"
"おおいえ 大家"
"おおいけ 大池"
"おおいし 大石"
"おおいしだ 大石田"
"おおいずみ 大泉"
"おおいそ 大磯"
"おおいそがし 大忙し"
"おおいそぎ 大急ぎ"
"おおいた 大板 大分"
"おおいち 大市"
"おおいちばん 大一番"
"おおいちもんじ 大一文字"
"おおいちょう 大堰町 大銀杏"
"おおいと 大糸"
"おおいど 大井戸"
"おおいなる 大いなる"
"おおいに 大いに"
"おおいぬざ 大犬座"
"おおいのかみ 大炊頭"
"おおいばり 大威張り"
"おおいり 大入 大入り"
"おおいりぶくろ 大入袋 大入り袋"
"おおいわ 大岩"
"おおう 奥羽"
"おおうえ 大上"
"おおうずまき 大渦巻"
"おおうそ 大ウソ 大嘘"
"おおうたどころ 大歌所"
"おおうだ 大宇陀"
"おおうち 大内"
"おおうちがり 大内刈り"
"おおうちどおり 大内通"
"おおうつし 大写し"
"おおうなばら 大海原"
"おおうら 大浦"
"おおうらわざ 大裏技"
"おおうりだし 大売出し 大売り出し"
"おおえ 大兄 大江"
"おおえど 大江戸"
"おおえのき 大榎"
"おおえのまさふさ 大江匡房"
"おおおか 大岡"
"おおおく 大奥"
"おおおじ 従祖父 大伯父 大叔父"
"おおおとこ 大男"
"おおおば 従祖母 大伯母 大叔母"
"おおおみ 大臣"
"おおおやぶん 大親分"
"おおおんな 大女"
"おおかがみ 大鏡"
"おおかじ 大鍛冶 大火事"
"おおかぜ 大風"
"おおかた 大片 大方"
"おおかたびら 大帷子"
"おおかながい 大金書 大金貝"
"おおかぶぬし 大株主"
"おおかべ 大壁"
"おおかみ 大神 狼"
"おおかみうお 狼魚"
"おおかみおとこ 狼男"
"おおかみおんな 狼女"
"おおかみざ 狼座"
"おおかみしょうねん 狼少年"
"おおかめ 狼"
"おおかれ 多かれ"
"おおかれすくなかれ 多かれ少なかれ"
"おおかわ 大革 大鼓 大河 大川"
"おおかわばた 大川畑"
"おおかわら 大河原"
"おおかん 大缶"
"おおかんだ 大神田"
"おおが 大鋸 大賀"
"おおがい 大貝 頁"
"おおがえし 大返し"
"おおがかり 大がかり 大掛り 大掛かり"
"おおがき 大書 大柿 大垣"
"おおがけ 大駆"
"おおがた 大潟 大方 大形 大型"
"おおがたぎょ 大型魚"
"おおがたけいさんきせんたー 大型計算機センター"
"おおがたけん 大型犬"
"おおがたじゅう 大型獣"
"おおがたば 大型馬"
"おおがたまど 大型窓"
"おおがち 大勝ち"
"おおがね 大鐘 大金"
"おおがねもち 大金持"
"おおがみ 大神"
"おおがめ 鰲"
"おおがら 大柄"
"おおがらす 大鴉"
"おおがわら 大河原"
"おおき 大城 大木"
"おおきい 大きい"
"おおきさ 大きさ"
"おおきさいのみや 皇太后宮"
"おおきすめらみこと 太上天皇"
"おおきた 大北"
"おおきど 大木戸"
"おおきな 大きな"
"おおきに 大きに"
"おおきみ 大君"
"おおきめ 大きめ 大き目"
"おおぎ 仰木 青木 扇"
"おおぎがた 扇型"
"おおぎがはら 扇ヶ原"
"おおぎし 大岸"
"おおぎたに 扇谷"
"おおぎばし 扇橋"
"おおぎまち 扇町"
"おおぎみ 大宜味"
"おおぎょう 大形 大仰"
"おおぎり 大切り 大喜利"
"おおく 多く"
"おおくずれ 大崩れ"
"おおくち 大口"
"おおくちばかま 大口袴"
"おおくに 大国"
"おおくにぬしのかみ 大国主神"
"おおくにぬしのみこと 大国主命"
"おおくび 衽"
"おおくびえ 大首絵"
"おおくぼ 大窪 大久保"
"おおくま 逢隈 大隈 大熊"
"おおくら 大蔵 大倉"
"おおくり お送り"
"おおくわ 大桑"
"おおぐい 大喰い 大食い"
"おおぐし 大串"
"おおぐす 大楠"
"おおぐち 大口"
"おおぐまざ 大熊座"
"おおぐれ 大暮"
"おおぐろ 大黒"
"おおけが 大ケガ 大けが 大怪我"
"おおげさ 大げさ 大袈裟"
"おおげんか 大喧嘩"
"おおこうち 大河内"
"おおこし 大越"
"おおこめ 大米"
"おおご 大湖 大胡"
"おおごえ 大越 大声"
"おおごし 大腰"
"おおごしょ 大御所"
"おおごと 大事"
"おおごま 大駒"
"おおごんはくぶつかん 黄金博物館"
"おおさ 大佐"
"おおさか 逢坂 大坂 大阪"
"おおさかがす 大阪ガス"
"おおさかせめんと 大阪セメント"
"おおさかほか 大阪他"
"おおさき 大崎"
"おおさこ 大迫"
"おおさじ 大さじ 大匙"
"おおさと 大郷 大里"
"おおさま 王様"
"おおさめ お納め"
"おおさわ 大澤 大沢"
"おおさわぎ 大騒ぎ"
"おおさわの 大沢野"
"おおさんしょううお 大山椒魚"
"おおさんばし 大桟橋 大棧橋"
"おおざけ 大酒"
"おおざけのみ 大酒飲み"
"おおざっぱ 大雑把"
"おおざと 大里"
"おおざはた 大座畑"
"おおざら 大皿"
"おおし 凡"
"おおしお 大塩 大潮"
"おおしか 大鹿"
"おおしけ 大時化"
"おおしげ 大重"
"おおしこうちのみつね 凡河内躬恒"
"おおしごと 大仕事"
"おおした 大下"
"おおしば 大芝 大柴"
"おおしま 大嶋 大島"
"おおしまつむぎ 大島紬"
"おおしまぶし 大島節"
"おおしみず 大清水"
"おおしょうぎ 大将棋"
"おおしょうぶ 大勝負"
"おおしろ 大城"
"おおじ 王寺 祖父 大路"
"おおじか 麋 大鹿"
"おおじしん 大地震"
"おおじだい 大時代"
"おおじぬし 大地主"
"おおじま 大島"
"おおじょたい 大世帯 大所帯"
"おおす 大須"
"おおすか 大須賀"
"おおすが 大須賀"
"おおすぎ 大杉"
"おおすぎさかえ 大杉栄"
"おおすじ 大筋"
"おおすず 大鈴"
"おおすみ 大角 大住 大隅"
"おおず 大洲"
"おおずもう 大相撲"
"おおずわ 大諏訪"
"おおせ 仰せ 大瀬"
"おおせいだされしょ 被仰出書"
"おおせざき 大瀬崎"
"おおせと 大瀬戸"
"おおぜい 大勢"
"おおぜき 大関"
"おおそうじ 大掃除"
"おおそうどう 大騒動"
"おおそが 大曽我"
"おおそこ 大底"
"おおそと 大外"
"おおそとがり 大外刈 大外刈り"
"おおそね 大曽根"
"おおその 大園"
"おおぞこ 大底"
"おおぞね 大曽根"
"おおぞら 大空"
"おおぞん 大損"
"おおた 大田 太田"
"おおたか 大鷹 大高"
"おおたがき 大田垣"
"おおたき 王滝 大瀧 大多喜 大滝"
"おおたくひがしゆきがや 大田区東雪谷"
"おおたぐろ 太田黒"
"おおたけ 大丈 大武 大嶽 大竹"
"おおたけしのぶ 大竹しのぶ"
"おおたち 大立"
"おおたちまわり 大立ち回り"
"おおたてもの 大立者"
"おおたに 大谷"
"おおたにやき 大谷焼"
"おおたま 大玉"
"おおたわら 大田原"
"おおだ 大田"
"おおだい 大台"
"おおだいこ 大太鼓"
"おおだか 大高"
"おおだけ 大岳"
"おおだこ 大ダコ 大凧"
"おおだすかり 大助かり"
"おおだち 大館 大立"
"おおだて 大館"
"おおだてもの 大立て者 大立者"
"おおだな 大店"
"おおだま 大玉"
"おおだんな 大旦那"
"おおち 邑智"
"おおちがい 大違い"
"おおっぴら 大っぴら"
"おおつ 大津"
"おおつか 大束 大塚"
"おおつかあきら 大塚明"
"おおつかさ 大学寮"
"おおつが 大津賀"
"おおつき 大規 大津寄 大附 大槻 大月"
"おおつごもり 大晦日 大晦"
"おおつち 大槌"
"おおつなみ 大津波"
"おおつの 大角"
"おおつぶ 大粒"
"おおつぼ 大壺 大坪"
"おおつま 大妻"
"おおつる 大鶴"
"おおづ 大津"
"おおづかみ 大掴み"
"おおづくり 大作り"
"おおづつ 大筒"
"おおづな 大綱"
"おおづめ 大詰 大詰め"
"おおて 大手"
"おおてい 大体"
"おおてすーぱー 大手スーパー"
"おおてら 大寺"
"おおてる 大照"
"おおてんじょう 大天井"
"おおで 大手"
"おおでき 大出来"
"おおとう 大任 大塔"
"おおとかげ 大蜥蜴"
"おおとね 大利根"
"おおとの 大殿"
"おおとのごもり 大殿籠り"
"おおとも 大友 大伴"
"おおともい 弁"
"おおともいのつかさ 弁官"
"おおともそうりん 大友宗麟"
"おおとよ 大豊"
"おおとり 鵬 鴻 鳳 大鳥"
"おおとりい 大鳥居"
"おおとろ 大トロ"
"おおど 大戸"
"おおどう 大胴"
"おおどうぐ 大道具"
"おおどおり 大通 大通り"
"おおどけい 大時計"
"おおどころ 大所"
"おおどしま 大年増"
"おおどまり 大泊"
"おおな 大名"
"おおなえ 大苗"
"おおなかぐろ 大中黒"
"おおなかとみのよしのぶ 大中臣能宣"
"おおなき 大泣き"
"おおなた 大ナタ 大鉈"
"おおなべ 大鍋"
"おおなみ 大浪 大波"
"おおなめ 大滑"
"おおなめまつり 大嘗祭"
"おおなんじ 大汝"
"おおにえ 大嘗"
"おおにぎわい 大賑わい"
"おおにし 大西"
"おおにた 大仁田"
"おおにもつ 大荷物"
"おおにわ 大庭"
"おおにんずう 大人数"
"おおぬき 大貫"
"おおぬま 大沼"
"おおね 大根"
"おおねじめ 大根占"
"おおねた 大ネタ"
"おおねだ 大根田"
"おおの 大野"
"おおのくに 大乃国"
"おおのみ 大野見"
"おおのやすまろ 太安万侶"
"おおはさ 大迫"
"おおはざま 大間"
"おおはし 大橋"
"おおはしゃぎ 大はしゃぎ"
"おおはじ 大恥"
"おおはずれ 大ハズレ 大外れ"
"おおはた 大畠 大畑"
"おおはなび 大花火"
"おおはば 大幅"
"おおはま 大濱 大浜"
"おおはやり 大流行り 大流行"
"おおはら 大原"
"おおはらい 大祓"
"おおはらえ 大祓"
"おおはらの 大原野"
"おおはり 大梁"
"おおはる 大治"
"おおば 祖母 大羽 大庭 大場 大葉"
"おおばか 大バカ 大馬鹿"
"おおばかもの 大莫迦者"
"おおばくち 大博打"
"おおばけ 大化け"
"おおばこ 大葉子 車前草 車前 大箱"
"おおばたけ 大畠"
"おおばな 大花"
"おおばやし 大林"
"おおばん 大版 大盤 大番 大判"
"おおばんくるわせ 大番狂わせ"
"おおばんぶるまい 大盤振舞 大盤振る舞い"
"おおばんやき 大判焼"
"おおひさ 大久"
"おおひと 大仁"
"おおひやき 大樋焼"
"おおひら 大衡 大平"
"おおひろ 大広"
"おおびき 大引"
"おおびけ 大引け"
"おおびゃくしょう 大百姓"
"おおびん 大壜 大瓶"
"おおふか 大深"
"おおふく 大福"
"おおふな 大船"
"おおふなと 大船渡"
"おおふね 大舟"
"おおふろしき 大風呂敷"
"おおぶ 大府"
"おおぶくろ 大袋"
"おおぶたい 大舞台"
"おおぶち 大淵 大渕"
"おおぶね 大船"
"おおぶり 大降り 大振り"
"おおぶろしき 大風呂敷"
"おおべや 大部屋"
"おおほ 大穂"
"おおほり 大濠 大堀"
"おおほん 大本"
"おおぼうしょ 大奉書"
"おおぼけ 大ぼけ 大ボケ 大歩危"
"おおぼし 大星"
"おおぼね 大骨"
"おおぼら 大ボラ"
"おおぽか 大ポカ"
"おおま 大間"
"おおまえ 大前"
"おおまか 大まか"
"おおまがき 大間書"
"おおまがとき 大禍時"
"おおまがり 大曲"
"おおまき 大蒔"
"おおまけ 大負け"
"おおまじめ 大真面目"
"おおまた 大股"
"おおまち 大町"
"おおまつ 大松"
"おおまと 大的"
"おおまど 大窓"
"おおまぬけ 大間抜"
"おおまま 大間々"
"おおまみゅうだ 大豆生田"
"おおまゆ 大眉"
"おおまわり 大回り"
"おおまんどころ 大政所"
"おおみ 大身 大見"
"おおみえ 大見得"
"おおみか 大甕"
"おおみかみ 大御神"
"おおみき 大御酒"
"おおみしま 大三島"
"おおみず 大水"
"おおみそか 大晦日"
"おおみぞ 大溝"
"おおみち 大道"
"おおみつ 大光"
"おおみなと 大湊"
"おおみね 大峰"
"おおみや 大宮"
"おおみやすんどころ 大御息所"
"おおみよ 大御代"
"おおみら 薤"
"おおみわじんじゃ 大神神社"
"おおむ 御"
"おおむかし 大昔"
"おおむぎ 大麦"
"おおむこう 大向う 大向こう"
"おおむた 大牟田"
"おおむね 大旨 大棟 概 概ね"
"おおむら 大村"
"おおむらさき 大紫"
"おおむらじ 大連"
"おおむろ 大室"
"おおめ 多目 多め 大目"
"おおめし 大飯"
"おおめしぐらい 大飯食らい"
"おおめだま 大目玉"
"おおめつけ 大目付"
"おおもじ 大文字"
"おおもと 大元 大本"
"おおもの 大物"
"おおもめ 大揉め"
"おおもも 大桃"
"おおもり 大森 大盛 大盛り"
"おおもん 大門"
"おおや 大宅 大矢 大谷 大屋 大家"
"おおやかず 大矢数"
"おおやぎ 大谷木 大八木"
"おおやけ 大宅 公"
"おおやけごと 公事"
"おおやけど 大火傷"
"おおやしろ 大社"
"おおやしろづくり 大社造"
"おおやす 大保"
"おおやすうり 大安売 大安売り"
"おおやね 大屋根"
"おおやの 大矢野"
"おおやま 大山"
"おおやまざき 大山崎"
"おおやまだ 大山田"
"おおやまと 大倭 大日本"
"おおやまねこ 大山猫"
"おおやん 欧陽"
"おおゆ 大湯"
"おおゆか 大床"
"おおゆき 大雪"
"おおゆみ 大弓"
"おおよう 大様"
"おおよせ 大寄せ 大寄"
"おおよそ 大凡 凡そ"
"おおよど 大淀"
"おおよろこび 大喜び"
"おおよわり 大弱り"
"おおらか 多らか 大らか"
"おおわ 大輪"
"おおわき 大脇"
"おおわく 大和久 大枠"
"おおわざ 大技"
"おおわし 大鷲"
"おおわだ 大輪田 大和田"
"おおわだばく 大和田獏"
"おおわに 大鰐"
"おおわらい 大笑い"
"おおわらわ 大童"
"おおん 御"
"おおんべ 大嘗"
"おか 崗 峻 阜 陵 岳 陸 岡 丘"
"おかあさま 御母様 お母さま お母様"
"おかあさん お母さん"
"おかあちゃん お母ちゃん"
"おかい 汚怪 小粥"
"おかいあげ お買上げ お買上 お買い上げ"
"おかいけい お会計"
"おかいどく お買い得"
"おかいもの お買い物"
"おかうち 岡内"
"おかえ 岡江"
"おかえし 御返し お返し"
"おかえり お帰り"
"おかお お顔"
"おかかえ 御抱え お抱え"
"おかがき 岡垣"
"おかがみ 岡上"
"おかくら 岡倉"
"おかぐら 御神楽"
"おかげ 御蔭 御陰 お蔭 お陰"
"おかげん 御加減 お加減"
"おかさか 岡坂"
"おかさん 岡三"
"おかざき 丘咲 岡崎"
"おかざわ 岡澤"
"おかざわちょう 岡沢町"
"おかし お菓子"
"おかしま 岡島"
"おかしら 尾頭"
"おかじま 岡嶋 岡島"
"おかじょうき 陸蒸気"
"おかず 御菜 御数"
"おかせっけい 岡設計"
"おかぞえ 岡添"
"おかた 岡田 御方 お方"
"おかたに 岡谷"
"おかだ 岡田"
"おかだい 岡大"
"おかだせん 岡多線"
"おかだま 丘珠"
"おかちまち 御徒町"
"おかって お勝手"
"おかっぴき 岡っ引き"
"おかつ 雄勝"
"おかづり 陸釣"
"おかと 岡登"
"おかど 尾角"
"おかどちがい お門違い 御門違い"
"おかどめ 岡留"
"おかね お金"
"おかの 岡野"
"おかのり 陸海苔"
"おかはし 岡橋"
"おかはち 岡八"
"おかはら 岡原"
"おかはる 岡原"
"おかばしょ 岡場所"
"おかばやし 岡林"
"おかひさ 岡久"
"おかひじき 陸鹿尾菜"
"おかひら 岡平"
"おかふじ 岡藤"
"おかぶ 御株 お株 雄株"
"おかべ 岡部"
"おかぼ 陸稲"
"おかぼれ 傍惚れ 岡惚れ"
"おかま お釜 御釜"
"おかまい 御構い"
"おかみ 傍見 御内儀 お内儀 岡見 お上 女将 御上"
"おかみさん お内儀さん"
"おかむら 岡村"
"おかむろ 岡室"
"おかめ 阿亀 お亀 傍目"
"おかめはちもく 岡目八目 傍目八目"
"おかもち 岡持ち 岡持"
"おかもと 岡元 岡本"
"おかや 岡谷"
"おかやす 岡安"
"おかやま 岡山"
"おかやまひがし 岡山東"
"おかゆ 小粥 お粥"
"おからだ お身体"
"おかわり お変り お代り お変わり お代わり"
"おかん 惡寒 お母ん お燗 悪寒"
"おかんがえ お考え"
"おかんじょう お勘定"
"おかんむり 御冠"
"おが 大鋸 男鹿"
"おがい 小粥"
"おがくず 大鋸屑"
"おがさ 小笠"
"おがさか 小賀坂"
"おがさはら 小笠原"
"おがさわら 小笠原"
"おがた 緒形 小形 小方 尾形 緒方"
"おがつ 雄勝"
"おがの 小鹿野"
"おがひき 大鋸挽き"
"おがみ 男神 尾上"
"おがや 小萱"
"おがゆ 小粥"
"おがら 麻幹"
"おがわ 尾河 尾川 緒川 小河 小川"
"おがわな 小川名"
"おき 熈 煕 興 お気 起き 置き 澳 熾 燠 隠岐 沖"
"おきあい 沖合い 沖合"
"おきあがりこぼし 起き上がり小法師"
"おきあじ 沖鰺"
"おきあみ 沖醤蝦 置き網 置網"
"おきあゆ 置鮎"
"おきいし 置石 置き石"
"おきうお 沖魚"
"おきかえ 置換え 置き換え"
"おきがさ 置き傘"
"おきがる お気軽 御気軽"
"おきくら 沖倉"
"おきぐすり 置き薬"
"おきこうぎょう 沖工業"
"おきことば 沖言葉"
"おきご 置き碁"
"おきごたつ 置き炬燵"
"おきさわら 沖鰆"
"おきざり 置き去り"
"おきじ 置字"
"おきす 沖洲"
"おきそ 小木曽"
"おきた 小木田 沖田"
"おきたそうじ 沖田総司"
"おきたま 置賜"
"おきち お吉"
"おきつ 興津"
"おきつうしん 沖通信"
"おきつち 置き土"
"おきづけ 沖漬け 沖漬"
"おきて 沖手 諚 掟"
"おきてがき 掟書"
"おきてがみ 置手紙"
"おきでんき 沖電気"
"おきとちょう 置戸町"
"おきどけい 置時計"
"おきどこ 置き床 置床"
"おきな 奥菜 翁"
"おきなあめ 翁飴"
"おきなか 沖中"
"おきなかし 沖仲士 沖仲仕"
"おきなごうし 翁格子"
"おきなわ 沖繩 沖縄"
"おきにいり お気に入り"
"おきのしま 沖ノ島 隠岐島"
"おきのとりしま 沖ノ鳥島"
"おきのどく お気の毒"
"おきのどくさま お気の毒さま"
"おきば 置場"
"おきひ 置肥 置き肥"
"おきび 燠火 熾火"
"おきふじ 沖藤"
"おきぶみ 置文"
"おきまつしま 沖松島"
"おきまり 御決り 御決まり お決まり"
"おきみ 沖美"
"おきみやげ 置土産"
"おきめ 沖目"
"おきもじ 御気文字"
"おきもち お気持"
"おきもと 沖本"
"おきもの 置物"
"おきゃく お客"
"おきゃくさま お客さま 御客様"
"おきゃくさん お客さん"
"おきゃん お侠 御侠"
"おきや 置屋"
"おきゅう お灸"
"おきょう お経"
"おきらく お気楽"
"おきわすれ 置忘れ"
"おきわたし 沖渡し"
"おぎ 蒹 尾木 小木 小城 荻"
"おぎうえ 荻上"
"おぎえぶし 荻江節"
"おぎくぼ 荻窪"
"おぎしま 荻島"
"おぎそ 小木曽"
"おぎた 小木田 荻田"
"おぎつ 荻津"
"おぎにしき 小城錦"
"おぎの 荻布 荻野"
"おぎのしき オギノ式"
"おぎのめ 荻目"
"おぎはら 荻原"
"おぎゅう 荻生"
"おぎょう お行 オ行"
"おぎろ 頤"
"おぎわら 荻原"
"おく 奧 檍 臆 憶 屋 尾久 邑久 億 奥"
"おくい 奥居 奥井"
"おくいり 奥入"
"おくう 屋烏"
"おくえん 億円"
"おくか 屋下 奥処"
"おくかい 億回"
"おくかわ 奥川"
"おくがい 屋外"
"おくがき 奥書"
"おくがた 奥方"
"おくぎ 奥儀 奥義"
"おくこ 億個"
"おくさき 奥崎"
"おくさま 奥様"
"おくさわ 奥澤 奥沢"
"おくさん 奥さん"
"おくしゃ 屋舎"
"おくしょん 億ション"
"おくしり 奥尻"
"おくしりとう 奥尻島"
"おくじょう 屋上"
"おくじょうおく 屋上屋"
"おくすり お薬"
"おくせ 奥瀬"
"おくせつ 臆説 憶説"
"おくそく 臆測 憶測"
"おくそこ 奥底"
"おくたに 奥谷"
"おくたんい 億単位"
"おくだ 奥田"
"おくだいら 奥平"
"おくだて 奥立"
"おくだん 臆断"
"おくち お口 奥地"
"おくちょう 億兆"
"おくつ 奥津"
"おくつき 奥つ城"
"おくづけ 奥付"
"おくて 晩稲 晩生 奥手"
"おくで 奥出"
"おくでら 奥寺"
"おくでん 奥伝"
"おくとみ 奥富"
"おくど 奥土"
"おくない 奥内 屋内"
"おくないぷーる 屋内プール"
"おくなが 奥永"
"おくに お国 阿国 御国"
"おくにし 奥西"
"おくにん 億人"
"おくぬき 奥貫"
"おくねん 億年"
"おくの 奥乃 奥野"
"おくのいん 奥の院"
"おくのて 奥の手"
"おくのほそみち 奥の細道"
"おくのま 奥の間"
"おくはら 奥原"
"おくば 奥歯"
"おくびょう 臆病"
"おくぶ 奥部"
"おくほ 奥穂"
"おくまん 億万"
"おくみ 袵 衽"
"おくむら 奥村"
"おくめ 奥目"
"おくめん 臆面"
"おくもと 納本 奥本"
"おくやま 奥山"
"おくやみ お悔やみ"
"おくゆき 奥行"
"おくら お蔵 憶良 御蔵"
"おくり 送り"
"おくりあし 送り足"
"おくりおおかみ 送り狼"
"おくりさき 贈り先"
"おくりたおし 送り倒し"
"おくりな 贈り名 諡"
"おくりぬし 送主 贈り主"
"おくりばんと 送りバント"
"おくりび 送り火"
"おくりもの 賻 饋 贈りもの 贈物 贈り物"
"おくれ 遅れ"
"おくれげ 後れ毛"
"おくればせ 遅馳 遅れ馳せ"
"おくればせながら 遅ればせながら"
"おくわざ 奥技"
"おぐさ 小草"
"おぐし 御髪 小串"
"おぐち 尾口 小口"
"おぐに 小国"
"おぐま 小熊"
"おぐら 小椋 小倉"
"おぐらあん 小倉餡"
"おぐらけい 小椋佳"
"おぐり 小栗"
"おぐるま 小車"
"おぐろ 小黒"
"おけ 桶"
"おけいこ お稽古"
"おけがやぬま 桶ケ谷沼"
"おけがわ 桶川"
"おけしょう お化粧"
"おけつ 悪血"
"おけと 置戸"
"おけどう 桶胴"
"おけはざま 桶狭間"
"おけや 桶屋"
"おけら 朮 螻蛄"
"おける 於ける"
"おげひん お下品"
"おげれつ お下劣"
"おげんき 御元気 お元気"
"おこ お子 烏滸 痴"
"おこう 汚行 お香"
"おこうでん 御香典"
"おこえ 御声"
"おこげ 御焦げ お焦げ"
"おこころ 御心"
"おこさま お子さま"
"おこさまらんち お子様ランチ"
"おこさん お子さん"
"おこし 小越 お越し"
"おこぜ 虎魚"
"おこたえ 御答え お答え"
"おこたち 御子達"
"おこちゃま お子ちゃま"
"おこっぺ 興部"
"おこと お箏 お琴"
"おことてん 乎古止点"
"おことば 御言葉"
"おことわり お断わり お断り"
"おこない 行ない 行い"
"おこのぎ 小此木"
"おこのみ お好み"
"おこぼれ お零れ"
"おこめ 御米 お米"
"おこり 起り 瘧"
"おこりいし 瘧石"
"おこりかた 怒り方"
"おこりんぼう 怒りん坊"
"おこわ 御強"
"おごうりかん 小郡間"
"おごおり 小郡"
"おごし 生越"
"おごせ 越生"
"おごそか 厳か"
"おごと 雄琴"
"おごのり 海髪海苔 於胡海苔"
"おごり 傲り 驕り 奢り"
"おさ 訳語 通事 筬 長"
"おさいせん お賽銭"
"おさいふ お財布"
"おさいほう お裁縫"
"おさえ 押え 押さえ 抑え"
"おさか 苧坂 尾坂 小坂"
"おさかな お魚"
"おさがり 御下り 御下がり お下がり"
"おさき お先 御先"
"おさきに お先に"
"おさきぼう 御先棒"
"おさぎ 兎"
"おさくひん 御作品"
"おさけ お酒"
"おさけび 雄叫び"
"おさげ 御下げ お下げ"
"おさげがみ お下げ髪"
"おさしみ お刺身"
"おさそい お誘い"
"おさたがき 御沙汰書"
"おさたけ 尾佐竹"
"おさだ 長田"
"おさだまり 御定まり"
"おさだめがき 御定書"
"おさつ お札"
"おさと 長都 御里 お里"
"おさな 幼"
"おさない 幼い 長内 小山内"
"おさないころ 幼い頃"
"おさないみえこ 小山内美江子"
"おさながお 幼顔"
"おさなご 幼な子 幼子"
"おさなごころ 幼心"
"おさなさ 幼さ"
"おさなづま 幼妻"
"おさなともだち 幼友達"
"おさななじみ 幼なじみ 幼馴染み 幼馴染"
"おさなものがたり 幼物語"
"おさふね 長船"
"おさべ 長部"
"おさまり 納まり 収まり"
"おさみ 修美"
"おさむ 納 治虫 収 理 治 修"
"おさめ 納め"
"おさめこみ 納込"
"おさめつくるつかさ 修理職"
"おさめふだ 納め札"
"おさら お皿"
"おさらぎ 大佛 大仏"
"おさる お猿"
"おさわがせ お騒がせ"
"おさん お産"
"おさんかた 御三方"
"おさんぽ お散歩"
"おざ 尾座"
"おざき 尾前 小崎 尾崎"
"おざきゆたか 尾崎豊"
"おざく 小作"
"おざさ 小笹"
"おざしき 御座敷 お座敷"
"おざしきうた 御座敷唄"
"おざなり 御座なり"
"おざわ 尾沢 小澤 小沢"
"おし 忍 鴛 押し 御師 鴛鴦 唖"
"おしあい 押し合い 押合い"
"おしあいへしあい 押合い圧し合い 押し合い圧し合い"
"おしあげ 押上"
"おしあわせ お幸せ"
"おしい 押井"
"おしいれ 押入"
"おしうり 押売 押売り"
"おしえ 教え 押絵"
"おしえご 教え子"
"おしお 押尾"
"おしおき 御仕置 お仕置き"
"おしか 牡鹿"
"おしかく 押角"
"おしかけ 押し掛け"
"おしかせん 男鹿線"
"おしかた 押方"
"おしかり お叱り 御叱り"
"おしかわ 押川"
"おしがし 押し貸し"
"おしがた 押型"
"おしがみ 押紙"
"おしき 折敷"
"おしきせ 御仕着せ"
"おしきり 押切"
"おしくま 押熊"
"おしくも 惜しくも"
"おしくらまんじゅう 押し競饅頭"
"おしげ 惜しげ"
"おしこみ 押込み"
"おしごと お仕事"
"おしずし 押鮨 押し鮨"
"おしたおし 押し倒し"
"おしだ 押田"
"おしち お七"
"おしちや 御七夜"
"おして 押手"
"おしどり 鴦 鴛鴦"
"おしながき お品書き"
"おしね 晩稲"
"おしの 忍野"
"おしのはっかい 忍野八海"
"おしのび 御忍び"
"おしはらい お支払い"
"おしば 押葉 押し葉"
"おしばい お芝居"
"おしばこ 押箱 押し箱"
"おしばな 押花 押し花"
"おしぴん 押しピン"
"おしぶち 押し縁 押縁"
"おしべ 雄蕊"
"おしほり 押堀"
"おしぼたん 押ボタン 押しボタン"
"おしぼり 御絞り"
"おしま 小島 渡島"
"おしまい 御仕舞 お仕舞い 御仕舞い"
"おしまずき 几"
"おしみ 惜しみ"
"おしみず 押水"
"おしむぎ 押麦 押し麦"
"おしむらくは 惜しむらくは"
"おしめ 繦 襁 御湿 押目 襁褓"
"おしめり 御湿り お湿り"
"おしもんどう 押問答"
"おしゃか 御釈迦 お釈迦"
"おしゃく 御酌 お酌"
"おしゃべり お喋り"
"おしゃまんべ 長万部"
"おしゃらく 御洒落"
"おしゃれ おシャレ 御洒落 お洒落"
"おしゅう 汚臭"
"おしょう 和尚"
"おしょうがつ お正月"
"おしょく 汚職"
"おしょくじ 御食事 お食事"
"おしらせ お知らせ"
"おしり お尻"
"おしるこ お汁粉"
"おしろ お城"
"おしろい 白粉"
"おしろいばな 白粉花"
"おしわり 押割り"
"おしん 悪心"
"おしんこ お新香 御新香"
"おじ 祖父 老翁 小父 伯父 叔父"
"おじい お爺"
"おじいさん お祖父さん お爺さん"
"おじいちゃん お爺ちゃん"
"おじか 小値賀 牡鹿"
"おじかせん 男鹿線"
"おじかん お時間"
"おじき 伯父貴 叔父貴"
"おじぎ 御辞儀"
"おじぎそう 御辞儀草 含羞草"
"おじけ 怖気"
"おじさん 小父さん 伯父さん 叔父さん"
"おじま 尾島 小島"
"おじゃま 御邪魔 お邪魔"
"おじゃまむし お邪魔虫"
"おじゅう 御重"
"おじゅけん お受験"
"おじょう お嬢 御嬢"
"おじょうさん 御嬢さん お嬢さん"
"おじょうず お上手 御上手"
"おじょうちゃん お嬢ちゃん"
"おじょく 汚辱"
"おじろ 尾白"
"おす ♂ お酢 牡 雄"
"おすい 汚水"
"おすいぬ 牡犬 オス犬 雄犬"
"おすいもじ 御推文字"
"おすいもの お吸い物"
"おすうし 雄牛"
"おすうま 牡馬"
"おすかぶ 雄株"
"おすがた 御姿"
"おすき お好き"
"おすごし お過ごし"
"おすし お寿司"
"おすすめ お薦め お勧め"
"おすそわけ おすそ分け 御裾分け お裾分け"
"おすたかやま 御巣鷹山"
"おすだ 小須田"
"おすとめす 雄と雌"
"おすねこ オス猫 牡猫 雄猫"
"おすまい お住い"
"おすまし 御澄まし"
"おすまんご オスマン語"
"おすみ お済み"
"おすみつき 御墨付き 御墨付 お墨付き"
"おすめす 牡牝 雄雌"
"おず 小津"
"おせ 尾瀬"
"おせいぼ 御歳暮 お歳暮"
"おせおせ 押せ押せ"
"おせき お席"
"おせざき 大瀬崎"
"おせじ 御世辞 お世辞"
"おせち 御節"
"おせっかい 御節介 お節介"
"おせつ お説"
"おせわ 御世話 お世話"
"おせん 汚染"
"おせんち おセンチ"
"おぜ 小瀬 尾瀬"
"おぜき 小関 尾関"
"おぜぬま 尾瀬沼"
"おぜん 御膳 お膳"
"おそ 遲 獺 悪阻 遅"
"おそい 襲"
"おそうざい お惣菜"
"おそうしき 御葬式 お葬式"
"おそうじ お掃除"
"おそかれはやかれ 遅かれ早かれ"
"おそくとも 遅くとも"
"おそざくら 遅桜"
"おそし 遅し"
"おそで 遅出"
"おそなえ 御供え お供え"
"おそなえもち 御供え餅"
"おそね 遅寝"
"おそば 遅場 御側"
"おそばん 遅版 遅番"
"おそびん 遅便"
"おそまき 遅蒔き"
"おそまつ 御粗末 お粗末"
"おそまつさま お粗末さま"
"おそめ お染 遅目 遅め"
"おそらく 恐らく"
"おそらくは 恐らくは"
"おそる 惶"
"おそるおそる 恐る恐る"
"おそるべき 恐るべき"
"おそるべし 恐るべし"
"おそれ 畏れ 恐れ 虞"
"おそれざん 恐山"
"おそれる 惶"
"おそろい お揃い"
"おそん 汚損"
"おぞうに お雑煮"
"おぞけ 怖気"
"おぞんそう オゾン層"
"おた 織田"
"おたから 御宝 お宝"
"おたがい お互い"
"おたがいさま 御互い様"
"おたく 御宅 お宅"
"おたけび 雄叫び"
"おたじま 小田嶋 小田島"
"おたずね お尋ね"
"おたち お発ち"
"おたちだい 御立ち台 お立ち台"
"おたっし 御達し お達し"
"おたな 御店"
"おたねにんじん 御種人参"
"おたのしみ お楽しみ"
"おたのしみぶくろ お楽しみ袋"
"おたび 御旅"
"おたふく 阿多福 お多福"
"おたべ 小田部"
"おたま 御玉 お玉"
"おたまじゃくし 蝌蚪"
"おたまや 霊屋"
"おため 御為"
"おためごかし 御為倒し"
"おためし お試し"
"おたより お便り"
"おたり 小谷"
"おたる 小樽"
"おたんじょうび お誕生日"
"おだ 纓田 織田 小田"
"おだい 小田井 御代 御題 お代 お題"
"おだいじに お大事に"
"おだいじん お大尽"
"おだいとう 尾岱沼"
"おだいば 御台場"
"おだいら 小平"
"おだうらくさい 織田有楽斎"
"おだか 尾高 小高"
"おだきゅう 小田急"
"おだぎ 小田木"
"おだぎり 小田桐 小田切"
"おだく 汚濁"
"おだくら 小田倉"
"おだけ 雄竹"
"おだしま 小田嶋"
"おだじま 尾田島 小田嶋"
"おだて 煽て"
"おだなか 小田中"
"おだに 小谷"
"おだのぶひで 織田信秀"
"おだぶつ お陀仏 御陀仏"
"おだまき 苧環"
"おだまきむし 小田巻蒸し"
"おだまり お黙り"
"おだやか 穏やか"
"おだわら 小田原"
"おだわらぢょうちん 小田原提灯"
"おだん オ段"
"おち 遠 彼方 尾知 越知 落 落ち 越智"
"おちあい 落合"
"おちあゆ 落ち鮎"
"おちいし 落石"
"おちうお 落魚 落ち魚"
"おちうど 落人"
"おちえ 御知恵"
"おちかた 墜ち方 落方 遠方"
"おちから 御力 お力"
"おちからぞえ お力添え"
"おちくぼものがたり 落窪物語"
"おちけん 落研"
"おちこち 遠近"
"おちこぼれ 落ちこぼれ"
"おちこみ 落ちこみ"
"おちご 御稚児"
"おちち お乳"
"おちつき 落着き 落ち着き"
"おちど 越度 落度"
"おちば 落ち葉 落葉"
"おちばたき 落葉焚き 落ち葉焚き"
"おちびと 落人"
"おちぼ 落ち穂 落穂"
"おちぼひろい 落穂拾い"
"おちみず 落ち水 落水"
"おちむしゃ 落武者"
"おちゃ 御茶 お茶"
"おちゃくみ お茶汲み"
"おちゃっぱ お茶っ葉"
"おちゃづけ お茶漬"
"おちゃづけのり 御茶漬海苔"
"おちゃのこ 御茶の子"
"おちゃのこさいさい 御茶の子さいさい"
"おちゃのま 御茶乃間 お茶の間"
"おちゃのみず 御茶の水 御茶ノ水 お茶の水"
"おちゃのみば お茶飲み場"
"おちゅうげん お中元 御中元"
"おちゅうしゃ お注射"
"おちょうし お銚子"
"おちょうしもの お調子者"
"おちょこ お猪口 御猪口"
"おちょぼぐち おちょぼ口"
"おぢや 小千谷"
"おっか 屋下"
"おっかあ おっ母"
"おっかけ 追っ掛け 追っかけ"
"おっかさん おっ母さん"
"おっきな 大っきな"
"おっくう 億劫"
"おっくご オック語"
"おっくすふぉーどだいがく オックスフォード大学"
"おっそ 越訴"
"おって 追って 追っ手 追手"
"おってがき 追而書"
"おっと 良人 夫"
"おっとう おっ父"
"おっとせい 膃肭臍"
"おっとりがたな 押っ取り刀"
"おっぱま 追浜"
"おっぽ 尾っぽ"
"おつ 膃 榲 乙"
"おつあん 乙案"
"おつうじ お通じ"
"おつかい お使い"
"おつかれさま 御疲れ様 お疲れさま お疲れ様"
"おつがわ 乙川"
"おつき 御付き"
"おつきあい お付き合い"
"おつきさま お月さま お月様"
"おつくり お作り 御作り お造り 御造り"
"おつけ 御付け"
"おつげ 御告げ お告げ"
"おつざいよう 乙剤用"
"おつしゅ 乙種"
"おつじ 尾辻"
"おつたえ お伝え"
"おつつ 現"
"おつとめ 御勤め お勤め"
"おつにょう 乙繞"
"おつぼね お局"
"おつや 御通夜 お通夜"
"おつゆ 御汁"
"おつり 御釣り お釣 お釣り"
"おづ 小津"
"おづき 小月"
"おづつ 尾筒"
"おて 御手 お手"
"おてあげ お手あげ"
"おてあらい お手洗 お手洗い 御手洗"
"おてかず お手数"
"おてがる お手軽"
"おてだま お手玉"
"おてつだい お手伝い"
"おてて お手々"
"おてなみはいけん 御手並拝見 お手並み拝見"
"おてのもの 御手の物 お手の物"
"おてまえ お点前"
"おてもと お手許"
"おてら お寺"
"おてん 汚点"
"おてんき お天気"
"おてんとうさま お天道様"
"おてんとさま 御天道様 お天道様"
"おてんば 御転婆 お転婆"
"おでい 汚泥"
"おでかけ お出掛け お出かけ"
"おでき 御出来"
"おでし 御弟子"
"おでら 小寺"
"おでん 御田"
"おでんだね おでん種"
"おでんわ お電話"
"おと 遠 彼方 乙 音"
"おとあわせ 音合せ 音合わせ"
"おといあわせ お問い合わせ"
"おといち 音一"
"おといれ 音入れ"
"おとうさま 御父様 お父様"
"おとうさん お父さん"
"おとうす 音薄"
"おとうちゃん お父ちゃん"
"おとうと 弟"
"おとうとでし 弟弟子"
"おとうとぶん 弟分"
"おとうとよめ 弟嫁"
"おとおし お通し 御通し"
"おとおんかい 音音階"
"おとかず 音数"
"おとかわ 乙川"
"おとかんきょう 音環境"
"おとがい 頤"
"おとがめ お咎め"
"おとき 御斎"
"おとぎ 御伽"
"おとぎばなし お伽話 おとぎ話"
"おとぎりそう 弟切草"
"おとぎりそうもく オトギリソウ目"
"おとく お得"
"おとくい お得意"
"おとくうかん 音空間"
"おとくに 乙訓"
"おとくよう お徳用"
"おとけんしゅつ 音検出"
"おとこ ♂ 漢 男"
"おとこあいて 男相手"
"おとこあそび 男遊び"
"おとこうぞう 音構造"
"おとこうん 男運"
"おとこえし 男郎花"
"おとこおとこ 男男"
"おとこおや 男親"
"おとこおんな 男女"
"おとこかんけい 男関係"
"おとこがみ 男神"
"おとこがわ 男側"
"おとこきょうだい 男兄弟"
"おとこぎ 侠気 男気"
"おとこぎみ 男君"
"おとこぎらい 男嫌い"
"おとこぐせ 男癖"
"おとこぐみ 男組"
"おとこぐるい 男狂い"
"おとこげ 男気"
"おとこげいしゃ 男芸者"
"おとこことば 男言葉"
"おとこごころ 男心"
"おとこごろし 男殺し"
"おとこざか 男坂"
"おとこざかり 男盛り"
"おとこしゃかい 男社会"
"おとこしゅう 男衆"
"おとこじゅく 男塾"
"おとこじょたい 男所帯"
"おとこずき 男好き"
"おとこたち 男達"
"おとこだて 男伊達"
"おとこっけ 男っ気"
"おとこっぷり 男っ振り"
"おとこで 男手"
"おとこともだち 男友達"
"おとこどうし 男同士"
"おとこども 男共"
"おとこなき 男泣き"
"おとこなまえ 男名前"
"おとこのこ 男のコ 男の子"
"おとこのひと 男の人"
"おとこばら 男腹"
"おとこひとり 男一人"
"おとこべや 男部屋"
"おとこべんじょ 男便所"
"おとこまえ 男前"
"おとこまさり 男勝 男勝り"
"おとこみこ 男御子"
"おとこみち 男道"
"おとこみょうり 男冥利"
"おとこもじ 男文字"
"おとこもの 男物"
"おとこやく 男役"
"おとこやま 男山"
"おとこやもめ 男鰥"
"おとこゆ 男湯"
"おとさた 音沙汰"
"おとし 落とし お歳 落し お年 御歳 御年"
"おとしあな 陥穽 落し穴 落とし穴"
"おとしがけ 落し懸け 落とし懸け"
"おとしげき 音刺激"
"おとしご 落し子 落とし子"
"おとしだね 落し胤 落とし胤"
"おとしだま おとし玉 御年玉 お年玉"
"おとしなちょう 音更町"
"おとしぶた 落し蓋 落とし蓋"
"おとしぶみ 落書 落とし文 落し文"
"おとしんごう 音信号"
"おとじたい 音自体"
"おとじょうほう 音情報"
"おとじろう 音二郎"
"おとずれ 訪れ"
"おとせってい 音設定"
"おとそ お屠蘇"
"おとそしき 音組織"
"おとだ 音田"
"おとだし 音出し"
"おとっつぁん お父っつぁん"
"おとつい 一昨日"
"おとつづみ 弟鼓"
"おとづくり 音作り"
"おとてき 音的"
"おとと 弟"
"おととい 一昨日"
"おととし 一昨年"
"おととび 音飛び"
"おととり 音取 音取り"
"おとどけ お届け"
"おとどけさき お届先"
"おとどまち 大殿町"
"おとな 大人"
"おとなし 音無し 音無"
"おとなり 御隣 お隣り お隣"
"おとなりさん お隣さん"
"おとにゅうりょく 音入力"
"おとは 乙葉"
"おとひと 弟"
"おとひめ 乙姫"
"おとふけ 音更"
"おとふじ 乙藤"
"おとべ 乙部"
"おとべつ 音別"
"おとむすめ 乙娘"
"おとめ 夫妻 夫婦 少女 乙女"
"おとめご 乙女子 少女子"
"おとめごころ 乙女心"
"おとも 御伴 お伴 御供 お供"
"おともだち お友だち お友達"
"おともれ 音洩れ"
"おとよめ 弟嫁"
"おとり 劣り 囮"
"おとりあつかい お取扱い お取り扱い"
"おとりおき お取り置き"
"おとりこみちゅう お取り込み中"
"おとりそうさ 囮捜査"
"おとりはからい お取計らい お取り計らい"
"おとりひき お取り引き"
"おとりよせ お取寄せ お取り寄せ"
"おとろえ 衰え"
"おとわ 音羽"
"おどき 男時"
"おどけ 戯け"
"おどし 脅し 縅"
"おどしゃ 御土砂"
"おどり 踊り"
"おどりぐい 踊り食い"
"おどりこ 踊り子"
"おどれ 己"
"おどろ 棘"
"おどろき 駭き 愕き 驚き"
"おな 女"
"おない 尾内 小内"
"おないぎ 御内儀"
"おないどし 同い歳 同い年"
"おなか 御中 お腹"
"おなかま お仲間"
"おなが 翁長 尾長"
"おながざる 尾長猿"
"おながどり 尾長鶏"
"おながれ 御流れ お流れ"
"おながわ 女川"
"おなご 女子"
"おなさけ 御情け"
"おなじ 仝 〃 ヾ ヽ ゞ ゝ 々 同じ"
"おなじく 々 同じく"
"おなじみ お馴染み お馴染"
"おなはま 小名浜"
"おなべ 小鍋"
"おなまえ 御名前 お名前"
"おなみ 男波"
"おなみだちょうだい お涙頂戴"
"おなもみ 葹"
"おなやみ お悩み"
"おなり 御成"
"おなれそめ 御馴染"
"おなんどいろ 御納戸色"
"おに 鬼"
"おにあい お似合い"
"おにいさま お兄様"
"おにいさん お兄さん"
"おにいた 鬼板"
"おにいちゃん お兄ちゃん"
"おにうだ 鬼生田"
"おにかわ 鬼可愛"
"おにがしま 鬼ヶ島"
"おにがらやき 鬼殻焼"
"おにがわ 鬼皮"
"おにがわら 鬼瓦"
"おにぎり 御握り お握り"
"おにく 尾肉 お肉"
"おにぐも 鬼蜘蛛"
"おにぐるま 鬼車"
"おにこうべ 鬼首"
"おにご 鬼子"
"おにごっこ 鬼ごっこ"
"おにごろし 鬼殺し"
"おにざわ 鬼沢"
"おにし 鬼石"
"おにつか 鬼塚 鬼束"
"おにづか 鬼塚"
"おにはは 鬼母"
"おにば 鬼歯"
"おにばば 鬼婆"
"おにび 鬼火"
"おにへい 鬼平"
"おにぼし 鬼星"
"おにまる 鬼丸"
"おにまろ 鬼磨呂"
"おにむすめ 鬼娘"
"おにもつ お荷物"
"おによめ 鬼嫁"
"おにわばん 御庭番"
"おにわやき 御庭焼"
"おぬま 小沼"
"おね 尾根"
"おねうち お値打ち"
"おねえ お姉"
"おねえさま お姉さま"
"おねえさん お姉さん"
"おねえちゃん お姉ちゃん"
"おねがい お願い"
"おねじ 雄螺子"
"おねだん お値段"
"おねば 大根葉"
"おねみち 尾根道"
"おの 尾野 小野 己 斧"
"おのうえ 尾上"
"おのうえおんせんえき 小野上温泉駅"
"おのえ 尾上"
"おのお 小野尾"
"おのおか 小野岡"
"おのおの 各 各各 各々"
"おのかわ 小野川"
"おのが 己が"
"おのがじし 己がじし"
"おのがみ 小野上"
"おのがわこ 小野川湖"
"おのき 小野木"
"おのぎ 小野木"
"おのこ 男の子 男 男子"
"おのさと 小野里"
"おのざき 小野崎"
"おのざわ 小野沢"
"おのず 自ず"
"おのずか 小野塚"
"おのずから 自ずから 自ら"
"おのずと 自と 自ずと"
"おのぞみ お望み"
"おのだ 小野田"
"おのだせめんと 小野田セメント"
"おのづか 小野塚"
"おのでら 小野寺"
"おののいもこ 小野妹子"
"おののたかむら 小野篁"
"おののとうふう 小野道風"
"おのぼりさん お上りさん"
"おのみ 尾の身"
"おのみち 尾道"
"おのれ 己"
"おは 尾羽"
"おはぎ 御萩"
"おはぐろ お歯黒 御歯黒 鉄漿"
"おはぐろどぶ 御歯黒溝"
"おはこ 十八番"
"おはこびさん お運びさん"
"おはし 御箸 お箸"
"おはせ 生長谷 小長谷"
"おはだ お肌"
"おはち お鉢 御鉢"
"おはつ 御初 お初"
"おはな お鼻 お花"
"おはなし お話"
"おはなばたけ 御花畑"
"おはなみ お花見"
"おはやし お囃子"
"おはやめ お早め"
"おはよう お早う"
"おはら 尾原 大原 小原"
"おはらい 御祓 お祓い 御祓い"
"おはらいばこ お払い箱"
"おはらぶし おはら節"
"おはりこ 御針子"
"おば 小母 小場 尾羽 伯母 叔母"
"おばあ お婆"
"おばあさん お祖母さん お婆さん"
"おばあちゃん お婆ちゃん"
"おばか おバカ"
"おばけ 尾羽毛 お化け"
"おばさん 小母さん 伯母さん 叔母さん"
"おばしま 欄"
"おばすて 姨捨"
"おばた 小俣 小畑 小幡"
"おばな 尾花 雄花"
"おばなざわ 尾花沢"
"おばね 尾羽"
"おばま 小浜"
"おばら 小原"
"おひきうけ お引受け"
"おひきたて お引き立て"
"おひさしぶり お久し振り お久しぶり"
"おひさま 御日様 お日さま お日様"
"おひざもと 御膝下 お膝元"
"おひたき 御火焚"
"おひたし 御浸し お浸し"
"おひつ お櫃 御櫃"
"おひつじ 牡羊"
"おひと お人 御人"
"おひとかた お一方"
"おひとつ お一つ"
"おひとよし お人好し 御人好し"
"おひとり お一人"
"おひなさま 御雛様"
"おひねり お捻り 御捻り"
"おひま 御暇 お暇"
"おひめさま お姫様"
"おひゃくど 御百度"
"おひや 御冷や"
"おひら 御平"
"おひらき 御開き お開き"
"おひる お昼"
"おひるころ お昼頃"
"おひるね お昼寝"
"おひれ 尾ひれ 尾鰭"
"おひろめ 御披露目 お披露目"
"おび 帶 小尾 飫肥 帯"
"おびあげ 帯揚げ"
"おびいた 帯板"
"おびえ 怯え"
"おびかわ 帯革 帯川"
"おびがき 帯書"
"おびがね 帯金"
"おびがみ 帯紙"
"おびきおく 帯記憶"
"おびきん 帯筋"
"おびぎょうれつ 帯行列"
"おびぐらふ 帯グラフ"
"おびこうこく 帯広告"
"おびした 帯下"
"おびじ 帯地"
"おびじめ 帯締め"
"おびじょう 帯状"
"おびつ 帯津 小櫃"
"おびと 首"
"おびとけ 帯解"
"おびどめ 帯留め"
"おびなた 大日方"
"おびなど 帯等"
"おびのこ 帯鋸"
"おびはば 帯幅"
"おびばんぐみ 帯番組"
"おびひろ 帯広"
"おびひろはくようこうこう 帯広柏葉高校"
"おびふう 帯封"
"おびぶん 帯文"
"おびまくら 帯枕"
"おびもの 佩物"
"おびら 小平"
"おびれ 尾鰭"
"おふぃすがい オフィス街"
"おふかい オフ会"
"おふく 御福"
"おふくろ 御袋 お袋"
"おふせ 御布施"
"おふせっといんさつ オフセット印刷"
"おふたかた 御二方"
"おふたり 御二人 お二人"
"おふだ 御札"
"おふでさき 御筆先"
"おふみ 御文"
"おふゆ 雄冬"
"おふる お古"
"おふれ お触れ 御触れ"
"おふれがき 御触書"
"おふろ お風呂"
"おぶき 小吹"
"おぶくろ 尾袋"
"おぶさ 綬"
"おぶし 雄節 男節"
"おぶじぇくとしこう オブジェクト指向"
"おぶせ 小布施"
"おぶち 尾駮 小渕"
"おぶちざわ 小淵沢"
"おぶつ 汚物"
"おぶね 小舟"
"おぷしょんとりひき オプション取引"
"おへや お部屋"
"おへんじ 御返事 お返事"
"おへんろ お遍路"
"おべんきょう お勉強"
"おべんとう お弁当"
"おべんとうばこ お弁当箱"
"おぺ 手術"
"おぺらかしゅ オペラ歌手"
"おぺらざ オペラ座"
"おほ 凡"
"おほしさま お星さま お星様"
"おぼう お坊"
"おぼうさん お坊さん"
"おぼえ 憶え 覚え"
"おぼえがき 覚書"
"おぼえず 覚えず"
"おぼこむすめ おぼこ娘"
"おぼし 思し 男星"
"おぼしめし 思し召し"
"おぼっちゃま お坊ちゃま 御坊ちゃま"
"おぼっちゃん お坊ちゃん 御坊ちゃん"
"おぼつかな 覚束無"
"おぼろ 朦 朧"
"おぼろぐも 朧雲"
"おぼろげ 朧げ"
"おぼろづき 朧月"
"おぼろづきよ 朧月夜"
"おぼろづくよ 朧月夜"
"おぼろどうふ 朧豆腐"
"おぼろよ 朧夜"
"おぼん お盆"
"おまい 御前"
"おまいり 御参り お参り"
"おまえ 御前 お前"
"おまえさん お前さん 御前さん"
"おまえざき 御前崎"
"おまかせ お任せ"
"おまけ 御負け"
"おまけつき おまけ付き オマケ付き"
"おまごさん お孫さん"
"おまた 尾股 尾又 小俣"
"おまち お待ち 雄町"
"おまちがい お間違い"
"おまちどおさま 御待ち遠様"
"おまつり 御祭り お祭り 御祭"
"おまな 御真魚"
"おまもり 御守り お守り"
"おまる 御虎子"
"おまわり お巡り"
"おまわりさん お巡りさん"
"おまんま 御飯"
"おみ 御神 尾美 麻績 臣"
"おみあい お見合い"
"おみあし 御御足"
"おみおくり お見送り"
"おみおつけ 御御御付け"
"おみがわ 小見川"
"おみき お神酒 御神酒"
"おみくじ 御神籤"
"おみくろん Ο ο"
"おみこし お神輿 御神輿"
"おみごと 御見事 お見事"
"おみず 御水 お水"
"おみせ 御店 お店"
"おみそれ 御見逸 御見逸れ"
"おみつもり 御見積"
"おみとおし 御見通し お見通し"
"おみな 女 嫗"
"おみなえし 女郎花"
"おみぬぐい 御身拭い"
"おみね 小峰"
"おみまい 御見舞い 御見舞 お見舞 お見舞い"
"おみみ お耳"
"おみや お宮 御宮"
"おみやげ 御土産 お土産"
"おみやまいり お宮参り"
"おむかい お向かい"
"おむかえ 御迎え"
"おむこさん お婿さん"
"おむすび 御結び お結び"
"おむつ 御襁褓 繦"
"おむな 嫗"
"おむろ 御室"
"おめ お目 御目"
"おめあて お目あて"
"おめい 汚名"
"おめいこう 御命講"
"おめいし お名刺"
"おめえ 御前"
"おめえさん 御前さん"
"おめが Ω ω"
"おめがね お眼鏡 御眼鏡"
"おめざめ お目覚め"
"おめし 御召"
"おめずおくせず 怖めず臆せず"
"おめんじょう 御免状"
"おも 重 面 主"
"おもい 思 重茂 想い 思い"
"おもいかねのかみ 思兼神"
"おもいがわ 思川"
"おもいきや 思いきや"
"おもいすごし 思い過し 思い過ごし"
"おもいっきり 思いっ切り 思いっきり"
"おもいなし 思い做し"
"おもいのたけ 思いの丈"
"おもいのほか 思いの外"
"おもいびと 思い人"
"おもいやり 思いやり"
"おもうさま 思う様"
"おもうしこみ お申込み お申し込み"
"おもうぞんぶん 思う存分"
"おもうつぼ 思う壷 思う壺"
"おもおも 重重 重々"
"おもかげ 於母影 俤 面影"
"おもかじ 面舵"
"おもがい 面懸 面繋 羈"
"おもがわり 面変り"
"おもげぎょ 本懸魚"
"おもご 面河"
"おもさ 重さ"
"おもざし 面差し"
"おもし 重し 重石"
"おもしろ 面白"
"おもしろい 面白い"
"おもしろさ 面白さ"
"おもしろみ 面白み"
"おもたに 面谷"
"おもだか 沢瀉 面高"
"おもだかもく オモダカ目"
"おもだち 面立ち"
"おもち お餅"
"おもちかえり お持ち帰り"
"おもちゃ 玩具"
"おもちゃばこ おもちゃ箱 玩具箱"
"おもちゃや おもちゃ屋"
"おもづかい 主遣い"
"おもづら 羈"
"おもて 面 表"
"おもてあみ 表編み"
"おもてうら 表裏"
"おもてかた 表方"
"おもてがえ 表替え"
"おもてがき 表書"
"おもてがまえ 表構え"
"おもてがわ 表側"
"おもてぐち 表口"
"おもてぐみ 表組"
"おもてけい 表罫"
"おもてごう 表郷"
"おもてさく 表作"
"おもてざた 表ざた"
"おもてじ 表地"
"おもてだな 表店"
"おもてはく 表拍"
"おもてぶた 表蓋"
"おもてむき 表向"
"おもてめい 表銘"
"おもてもん 表紋 表門"
"おもてやま 表山"
"おもと 万年青 御許"
"おもな 主な"
"おもなが 面長"
"おもに 主に 重荷"
"おもの 佩物 御物"
"おものがわ 雄物川"
"おもばば 重馬場"
"おもぶき 趣"
"おもみ 重味 重み"
"おもむき 趣き 趣"
"おもむけ 趣"
"おもむろ 徐"
"おもむろに 徐に"
"おもめ 重め"
"おももち 面持 面持ち"
"おもや 母屋"
"おもゆ 重湯"
"おもらし お漏らし"
"おもり お守り 重り 錘"
"おもわ 面輪"
"おもわく 思わく 思惑"
"おもわすれ 面忘れ"
"おもわず 思わず"
"おもわせぶり 思わせ振り"
"おもわれびと 思われ人"
"おや 親"
"おやいし 首石 親石"
"おやいず 小柳津"
"おやいづ 小柳津"
"おやいで 小柳出"
"おやいぬ 親犬"
"おやいも 親芋"
"おやおもい 親思い"
"おやかぎ 親鍵"
"おやかく 親核"
"おやかた お館 親方"
"おやかぶ 親株"
"おやがいしゃ 親会社"
"おやがかり 親掛り 親掛かり"
"おやがみ 祖神"
"おやがめ 親亀"
"おやがわり 親代り 親代わり"
"おやき 親器 親機"
"おやきじ 親記事"
"おやきゅうだん 親球団"
"おやきょうだい 親兄弟"
"おやきょく 親局"
"おやぎ 親木"
"おやぎみ 親君"
"おやく 御役 お役"
"おやくごめん お役ご免"
"おやくそく 御約束 お約束"
"おやくそくどおり お約束どおり"
"おやけ 小宅"
"おやこ 親娘 父娘 母娘 父子 母子 親子"
"おやこうこう 親孝行"
"おやこたか 親子鷹"
"おやこどんぶり 親子丼"
"おやこなべ 親子鍋"
"おやご 親御"
"おやごころ 親心"
"おやざと 親里"
"おやしお 親潮"
"おやしらず 親知らず 親不知"
"おやじ 親字 親仁 親爺 親父"
"おやじしん 親自身"
"おやすみ お休み"
"おやせたい 親世帯"
"おやたち 親達"
"おやだ 親田"
"おやだいだい 親代々 親代代"
"おやだま 親玉"
"おやつ 御八つ"
"おやつだい おやつ代"
"おやといがいこくじん 御雇外国人"
"おやど 御宿"
"おやどけい 親時計"
"おやどり 親鳥"
"おやなぎ 小柳"
"おやにらみ 親睨"
"おやねこ 親猫"
"おやばか 親バカ 親馬鹿"
"おやばなれ 親離れ"
"おやばら 親腹"
"おやばれ 親バレ"
"おやひとりこひとり 親一人子一人"
"おやふこう 親不孝"
"おやぶね 親船"
"おやぶん 親分"
"おやべ 小矢部"
"おやぼね 親骨"
"おやま 女方 お山 御山 女形 尾山 雄山 小山"
"おやまだ 小山田"
"おやまのたいしょう 御山の大将"
"おやみ 小止み"
"おやむすめ 親娘"
"おやもじ 親文字"
"おやもと 親元"
"おやゆずり 親譲り"
"おやゆび 拇 親指"
"おゆ お湯"
"おゆうぎ お遊戯"
"おゆずり 御譲り"
"おゆび 拇"
"おゆるし お許し"
"おゆわり 御湯割り"
"およぎ 泳ぎ"
"およずれ 妖"
"およずれごと 妖言"
"およそ 凡そ"
"およばずながら 及ばず乍ら"
"およばれ 御呼ばれ"
"および お呼び 御呼び 指 及 及び"
"およびごし 及び腰"
"およめ お嫁"
"およめさん お嫁さん"
"およろこび お慶び お喜び"
"おら 己"
"おらんだ 和蘭"
"おらんだご オランダ語"
"おらんだじん オランダ人"
"おり 織り 折り 織 折 澱 檻"
"おりーぶいろ オリーブ色"
"おりーぶゆ オリーブ油"
"おりあい 折合い 折り合い"
"おりあしく 折悪しく"
"おりいと 織糸 織り糸"
"おりお 折尾"
"おりおり 折折 折々"
"おりおんざ オリオン座"
"おりおんせいうん オリオン星雲"
"おりかさ 織笠 折笠"
"おりかた 折形"
"おりかも 氈"
"おりから 折柄"
"おりがさ 織笠"
"おりがみ 折紙"
"おりき 織機"
"おりきど 折木戸"
"おりくち 下り口 降り口"
"おりくちしのぶ 折口信夫"
"おりぐち 下り口 降り口"
"おりけい 折罫"
"おりこみ 折込み 折込"
"おりこみずみ 織込み済み"
"おりごとう オリゴ糖"
"おりしげ 折茂"
"おりしも 折しも"
"おりじなるきょく オリジナル曲"
"おりじなるばん オリジナル版"
"おりた 織田"
"おりたたみ 折畳み 折り畳み"
"おりたて 折立"
"おりちょう 折丁"
"おりづめ 折詰め 折詰"
"おりづる 折鶴 折り鶴"
"おりど 折り戸 折戸"
"おりはし 折橋"
"おりはら 織原 折原"
"おりば 降り場"
"おりばこ 折り箱 折箱"
"おりひめ 織姫"
"おりひめぼし 織姫星"
"おりふし 折節"
"おりべ 織部"
"おりべやき 織部焼"
"おりほん 折本"
"おりめ 織目 折目"
"おりも 折茂 織茂"
"おりもと 織元"
"おりもの 下り物 織物"
"おりもん 織文"
"おりや 織屋"
"おりやま 折山"
"おりょうり お料理"
"おりよく 折よく 折良く"
"おりんぴっくき オリンピック旗"
"おりんぴっくしゅもく オリンピック種目"
"おるすばん お留守番"
"おるせーびじゅつかん オルセー美術館"
"おるどびすき オルドビス紀"
"おれ 折れ 俺"
"おれい お礼 御礼"
"おれいごえ お礼肥"
"おれいまいり 御礼参り"
"おれおれさぎ おれおれ詐欺"
"おれくぎ 折れ釘"
"おれさま オレ様 俺様"
"おれじしん 俺自身"
"おれせん 折線"
"おれたち 俺達"
"おれっち 俺っち"
"おれつ お列 オ列"
"おれら 俺ら 俺等"
"おれんじいろ オレンジ色"
"おれんち 俺ん家 俺んち"
"おろ 疎 悪露"
"おろおぼえ 疎覚え"
"おろか 疎か 愚か"
"おろし 下ろし 卸し 颪 卸"
"おろしうり 卸売"
"おろしがね 下ろし金"
"おろししょう 卸商"
"おろしどんや 卸問屋"
"おろしね 卸値"
"おろしまち 卸町"
"おろそか 疎か"
"おろち 大蛇"
"おわ 尾羽"
"おわい 汚穢"
"おわかれ お別れ"
"おわせ 尾鷲"
"おわだ 小和田"
"おわび お詫び"
"おわらい お笑い"
"おわらいぐさ お笑い草 お笑い種"
"おわらぶし おわら節"
"おわり 終り 終わり 終 尾張"
"おわりあさひ 尾張旭"
"おわりごろ 終頃"
"おわりね 終値"
"おわん お碗"
"おん 隱 穩 瘟 園 遠 隠 穏 怨 御 温 音 恩"
"おんあい 恩愛"
"おんあつ 音圧"
"おんあつれべる 音圧レベル"
"おんい 恩威"
"おんいき 音域"
"おんいん 音韻"
"おんえい 恩栄"
"おんえん 恩怨"
"おんか 恩暇 恩仮 恩化 音価"
"おんかい 音階"
"おんかく 温覚"
"おんかた 御方"
"おんかみ 御髪 御神"
"おんかん 音感"
"おんが 音画 温雅 遠賀"
"おんがえし 恩返し"
"おんがく 音楽"
"おんがくいん 音楽院"
"おんがくのとも 音樂之友 音楽之友"
"おんがくばたけ 音楽畑"
"おんがっか 音学家"
"おんがっかい 音楽会"
"おんがっかん 音楽館"
"おんがな 音仮名"
"おんがん 温顔"
"おんき 恩紀 遠忌"
"おんきごう 音記号"
"おんきゅう 恩給"
"おんきょう 音強 音響"
"おんぎ 恩誼 御義 音義 恩義"
"おんぎょう 隠形"
"おんぎょく 音曲"
"おんくん 音訓"
"おんぐう 恩遇"
"おんぐすとろーむ Å"
"おんぐん 音群"
"おんけい 音型 恩恵"
"おんけつ 温血"
"おんけん 穏健"
"おんげん 音源"
"おんげんがわ 音現側"
"おんこ 恩顧"
"おんこう 恩幸 恩光 音効 音高 温厚"
"おんこうろん 音講論"
"おんこちしん 温故知新"
"おんごく 遠国"
"おんさ 音叉"
"おんさく 音作"
"おんさん 音産"
"おんざ 穏座"
"おんし 恩私 恩旨 音詩 恩賜 恩師"
"おんしっぷ 温湿布"
"おんしつ 温室 音質"
"おんしつこうかがす 温室効果ガス"
"おんしつど 温湿度"
"おんしゃ 音写 恩赦 御社"
"おんしゃく 恩借"
"おんしゅう 恩讎 恩讐 温州"
"おんしょう 恩奨 恩詔 恩賞 温床"
"おんしょうちょう 音象徴"
"おんしょく 慍色 温色 音色"
"おんしらず 恩知らず"
"おんしん 音信"
"おんじ 遠志 音字 陰地"
"おんじき 飲食"
"おんじゃく 温石"
"おんじゃくめん 温石綿"
"おんじゅ 飲酒"
"おんじゅうとんこう 温柔敦厚"
"おんじゅかい 飲酒戒"
"おんじゅく 御宿"
"おんじゅつ 恩恤"
"おんじゅん 音順 温順"
"おんじょう 音情 恩情 温情 音場 音声"
"おんじん 恩人"
"おんすい 温水"
"おんすいぷーる 温水プール"
"おんすう 音数"
"おんず 音図"
"おんせい 音声"
"おんせいさんぷる 音声サンプル"
"おんせき 恩錫"
"おんせつ 音節"
"おんせん 音栓 音線 温泉"
"おんせんじるし 温泉印"
"おんせんたまご 温泉卵"
"おんせんつあー 温泉ツアー"
"おんせんぷーる 温泉プール"
"おんせんまーく 温泉マーク"
"おんせんやど 温泉宿"
"おんそ 音素"
"おんそく 音束 音速"
"おんぞ 御衣"
"おんぞう 音像"
"おんぞうえく 怨憎会苦"
"おんぞうし 御曹子 御曹司"
"おんぞん 温存"
"おんた 音多"
"おんたい 恩貸 温帯 御大"
"おんたいしょう 御大将"
"おんたく 恩沢"
"おんたけ 御岳"
"おんたけさんえき 御嶽山駅"
"おんだ 音田 恩田"
"おんだい 音大"
"おんだん 温暖"
"おんち 恩地 音痴"
"おんちく 音蓄"
"おんちけん 音知研"
"おんちゅう 音注 御中"
"おんちょう 音長 音調 温調 恩寵"
"おんつう 音通"
"おんてい 温低 音程"
"おんてき 怨敵"
"おんてん 温点 恩典"
"おんでこざ 鬼太鼓座"
"おんと 音吐"
"おんとう 温湯 穏当"
"おんど 音戸 音頭 温度"
"おんどく 音読"
"おんどこ 温床"
"おんどり 雄鳥 雄鶏"
"おんどる 温突"
"おんな ♀ 音奈 恩名 恩納 女"
"おんなあそび 女遊び"
"おんない 恩愛"
"おんなうん 女運"
"おんなおや 女親"
"おんなかんけい 女関係"
"おんながた 女方 女形"
"おんながみ 女神"
"おんながわ 女側"
"おんなきょうし 女教師"
"おんなきょうだい 女姉妹"
"おんなぎみ 女君"
"おんなぎらい 女嫌い"
"おんなぐせ 女癖"
"おんなぐるい 女狂い"
"おんなけいず 婦系図"
"おんなげいしゃ 女芸者"
"おんなことば 女言葉"
"おんなこども 女子供"
"おんなころしあぶらのじごく 女殺油地獄"
"おんなごころ 女心"
"おんなごろし 女殺し"
"おんなさんのみや 女三の宮"
"おんなざか 女坂"
"おんなざかり 女盛り"
"おんなざちょう 女座長"
"おんなししょ 女四書"
"おんなしまい 女姉妹"
"おんなしゃかい 女社会"
"おんなしゅう 女衆"
"おんなしゅじん 女主人"
"おんなじ 同じ"
"おんなじしん 女自身"
"おんなじょたい 女所帯"
"おんなずき 女好き"
"おんなずもう 女相撲"
"おんなせんし 女戦士"
"おんなそうばし 女相場師"
"おんなたいこ 女太鼓"
"おんなたち 女達"
"おんなたらし 女誑 女誑し 女たらし"
"おんなだいがく 女大学"
"おんなだて 女伊達"
"おんなっけ 女っ気"
"おんなっぷり 女っ振り"
"おんなで 女手"
"おんなともだち 女友達"
"おんなどうし 女同士"
"おんなどうらく 女道楽"
"おんなども 女共"
"おんななまえ 女名前"
"おんなにのみや 女二の宮"
"おんなのこ 女のコ 女の子"
"おんなのひと 女の人"
"おんなばら 女腹"
"おんなばん 女版"
"おんなひとり 女一人"
"おんなへん 女偏"
"おんなべや 女部屋"
"おんなべんごし 女弁護士"
"おんなべんじょ 女便所"
"おんなみこ 女御子"
"おんなみや 女宮"
"おんなめ 妾"
"おんなもじ 女文字"
"おんなもの 女物"
"おんなやく 女役"
"おんなやもめ 女寡"
"おんなゆ 女湯"
"おんにん 穏忍"
"おんねつ 温熱"
"おんねん 怨念"
"おんのじ 御の字"
"おんはいすい 温排水"
"おんば 穏婆 音場"
"おんばしらまつり 御柱祭"
"おんばひがさ 乳母日傘"
"おんばん 音盤"
"おんぱ 恩波 音波"
"おんひ 音飛"
"おんひょう 音標"
"おんび 音尾"
"おんびき 音引き"
"おんびん 音便 穏便"
"おんぴょう 音表"
"おんぴょうもじ 音標文字"
"おんぶきごう 音部記号"
"おんぷ ♪ 音譜 音符"
"おんぷう 温風"
"おんべつ 音別"
"おんぼう 隠亡 御坊"
"おんみ 御身"
"おんみつ 隠密"
"おんみょう 陰陽"
"おんみょうじ 陰陽師"
"おんめい 恩命 恩名 音名"
"おんもと 御許"
"おんもの 佩物"
"おんやく 音訳"
"おんやさい 温野菜"
"おんよう 恩養 温容 陰陽"
"おんようじ 陰陽師"
"おんよく 温浴"
"おんよみ 音読み 音読"
"おんり 厭離 遠離"
"おんりつ 音律"
"おんりょう 温良 怨霊 音量"
"おんる 遠流"
"おんれい 恩礼 御礼"
"おんれつ 音列"
"おんわ 穏和 温和"
"か 苟 墟 彼 耶 鹿 罅 戈 啝 馨 禾 謌 哥 軻 訶 舸 渮 柯 呵 荷 苛 珂 河 何 笳 痂 珈 枷 袈 茄 架 賀 嘉 跏 迦 伽 加 蝸 窩 堝 咼 禍 渦 假 遐 葭 霞 蝦 暇 崋 譁 嘩 華 顆 踝 夥 菓 卦 掛 佳 價 賈 厦 廈 寡 譌 訛 靴 嫁 稼 ヶ ヵ 个 個 箇 蝌 萪 科 貨 家 香 夏 仮 火 花 過 価 果 課 歌 日 下 可 化 蚊"
"かーきいろ カーキ色"
"かーどがいしゃ カード会社"
"かーどけっさい カード決済"
"かーどしき カード式"
"かーどはさん カード破産"
"かーびんじゅう カービン銃"
"かーぼんし カーボン紙"
"かーようひん カー用品"
"かあ 母"
"かあさま 母様"
"かあさん 母さん"
"かあちゃん 母ちゃん"
"かあつ 加圧"
"かあつすいがたげんしろ 加圧水型原子炉"
"かい Χ χ 垣 交い 飼い 飼 買い 街 醢 峡 褂 榿 椢 恠 夬 咼 匯 丐 喙 乖 潰 枴 拐 獪 會 繪 絵 詼 恢 灰 迴 蛔 茴 徊 廻 囘 邂 觧 懈 廨 蠏 蟹 疥 畍 价 芥 介 槐 嵬 傀 瑰 魁 誨 晦 悔 諧 楷 揩 偕 皆 懷 壞 懐 壊 誡 械 戒 歌意 下意 開 櫂 隗 塊 海 界 階 改 下位 甲斐 快 怪 貝 解 回 会"
"かいあく 改悪"
"かいあげ 買上げ"
"かいあわせ 貝合せ 貝合わせ"
"かいい 介意 海尉 魁偉 会意 階位 怪異"
"かいいき 海域"
"かいいぬ 飼犬 飼い犬"
"かいいれ 買入 買入れ"
"かいいん 改印 海員 開院 会員"
"かいいんかーど 会員カード"
"かいう 海芋"
"かいうん 海雲 海運 開運"
"かいえい 開映"
"かいえき 改易"
"かいえだ 海江田"
"かいえん 海淵 快演 開宴 海燕 怪演 海塩 開園 開演"
"かいえんたい 海援隊"
"かいおうせい 海王星"
"かいおうまる 海王丸"
"かいおん 介音 開音 回音 快音"
"かいおんじ 海音寺"
"かいか 槐花 開果 怪火 開化 開架 階下 開花"
"かいかい 恢恢 開会"
"かいかいいん 会会員"
"かいかえ 買替え 買換え 買い換え"
"かいかく 開核 改革"
"かいかけ 買掛"
"かいかた 買方"
"かいかつ 開豁 快活"
"かいかつどう 会活動"
"かいかわ 會川"
"かいかん 快漢 怪漢 開管 会舘 會舘 開巻 開館 会館 快感"
"かいが 繪畫 怪訝 絵画"
"かいがい 海外"
"かいがいつあー 海外ツアー"
"かいがいむけ 海外向"
"かいがいろけ 海外ロケ"
"かいがく 開学"
"かいがね 胛"
"かいがもり 貝が森 貝ヶ森"
"かいがら 貝殻"
"かいがらぶし 貝殻節"
"かいがん 開眼 海岸"
"かいがんどおり 海岸通"
"かいき 回歸 買気 改軌 買い気 皆既 回忌 快気 会規 開基 会期 怪奇 回帰"
"かいきいわい 快気祝"
"かいきゃく 開脚"
"かいきゅう 開球 海丘 懐旧 階級"
"かいきょ 開渠 快挙"
"かいきょう 契経 懐郷 開経 開胸 回教 海況 海峡"
"かいきょく 開局"
"かいきり 買切り"
"かいきん 開襟 皆勤 解禁"
"かいぎ 解義 回議 海技 懐疑 会議"
"かいぎじろく 会議事録"
"かいぎゃく 詼謔 諧謔"
"かいぎょ 怪魚 海魚"
"かいぎょう 改行 開業"
"かいぎょく 買い玉 買玉"
"かいく 皆苦 化育 海区"
"かいくうかん 解空間"
"かいくん 回訓"
"かいぐ 戒具"
"かいぐい 買い食い"
"かいぐさ 飼草 飼い草"
"かいぐん 海軍"
"かいけい 快慶 会稽 塊茎 海景 会計"
"かいけいざん 会稽山"
"かいけいのはじ 会稽の恥"
"かいけいりろん 階型理論"
"かいけおんせん 皆生温泉"
"かいけつ 魁傑 怪傑 快傑 解決"
"かいけつびょう 壊血病"
"かいけはい 買気配"
"かいけん 海研 開顕 懐剣 改憲 会見"
"かいげつ 海月"
"かいげん 戒厳 改元 開眼"
"かいこ 解顧 蚕儚 回雇 廻顧 蠶 懐古 回顧 蚕 解雇"
"かいこう 開項 蟹行 海口 開高 怪光 回行 海港 回航 海溝 改稿 邂逅 開港 開口 開校 開講"
"かいこうしゃ 偕行社"
"かいこうしょく 灰黄色"
"かいこうたけし 開高健"
"かいこうたん 開口端"
"かいこく 廻国 回国 海国 会告 戒告 開国"
"かいこくへいだん 海国兵談"
"かいこだな 蚕棚"
"かいことば 買言葉"
"かいこま 甲斐駒"
"かいこん 塊根 悔恨 開梱 開墾"
"かいご 解語 諧語 改悟 戒護 開悟 悔悟 介護"
"かいごう 蟹螯 開合 改号 会合"
"かいごけん 介護犬"
"かいごろし 飼い殺し"
"かいさ 海佐 階差"
"かいさい 皆済 快哉 開催"
"かいさいと 下位サイト"
"かいさく 開鑿 怪作 開作 改作 快作 開削"
"かいさつ 開札 改札"
"かいさん 開山 海産 解散"
"かいざい 介在"
"かいざいく 貝細工"
"かいざん 改ざん 開山 海山 改竄"
"かいし 芥子 界紙 会試 戒師 怪死 海市 懐紙 海士 会誌 開始"
"かいしき 下意識 解式 開式"
"かいしつ 開室"
"かいしめ 買占め"
"かいしゃ 會社 膾炙 会社"
"かいしゃく 解釋 介錯 解釈"
"かいしゃづとめ 会社勤め"
"かいしゃもち 会社もち"
"かいしゅ 拐取"
"かいしゅう 回收 会衆 改宗 改修 回収"
"かいしゅうばこ 回収箱"
"かいしゅん 買春 悔悛 改悛 回春"
"かいしょ 回書 会所 甲斐性 楷書 開所"
"かいしょう 廻章 回章 海相 会商 海嘯 介紹 海将 海商 海象 甲斐性 快勝 改称 解消"
"かいしょく 海食 解職 快食 会食"
"かいしょくがい 海食崖"
"かいしょくどう 海食洞"
"かいしろ 垣代"
"かいしん 戒心 改進 海進 開進 改新 快心 回心 回診 改心 会心"
"かいしんげき 快進撃"
"かいじ 快事 解字 怪事 海自 海事 開示"
"かいじつ 晦日 会日"
"かいじむきょく 会事務局"
"かいじゃり 海砂利"
"かいじゅ 解呪 槐樹"
"かいじゅう 晦渋 懐柔 海獣 怪獣"
"かいじゅんびかい 会準備会"
"かいじょ 介助 解除"
"かいじょう 解錠 階状 塊上 廻状 回状 階乗 塊状 開城 開錠 階上 開場 海上 会場"
"かいじょうえ 戒定慧"
"かいじょけん 介助犬"
"かいじり 海尻"
"かいじん 灰塵 灰燼 海人 海神 怪人"
"かいすい 海水"
"かいすいおん 海水温"
"かいすいぎょ 海水魚"
"かいすいぱんつ 海水パンツ"
"かいすう 階数 回数"
"かいず 海津 海図"
"かいずか 貝塚"
"かいせ 貝瀬"
"かいせい 魁星 海棲 改製 改姓 海星 開成 回生 快晴 改正"
"かいせいあん 開盛庵"
"かいせいしゃ 偕成社"
"かいせいそう 海成層"
"かいせき 階席 会席 懐石 解析"
"かいせきぎ 解析木"
"かいせつ 回雪 回折 開設 解説"
"かいせつじま 回折縞"
"かいせつりつ 会設立"
"かいせん 回船 界線 回戦 廻船 疥癬 回旋 会戦 開栓 海戦 改選 開戦 海鮮 回線"
"かいせんだん 回線断"
"かいせんどんや 廻船問屋"
"かいぜいやくしょ 改税約書"
"かいぜつ 快絶"
"かいぜん 改善"
"かいそ 海鼠 開祖 改組"
"かいそう 回走 海曹 潰走 回漕 改葬 会葬 回送 快走 海草 海藻 回想 改装 階層"
"かいそうば 買相場"
"かいそく 快足 会則 快速"
"かいそくば 快速馬"
"かいそん 海損 海村"
"かいぞう 海三 海象 解像 改造"
"かいぞえ 介添え 介添"
"かいぞく 回族 海賊"
"かいぞくおとこ 海賊男"
"かいた 頴田 海田"
"かいたい 拐帯 戒体 懐胎 解体"
"かいたく 開拓"
"かいたん 海単"
"かいだ 快打 改田 貝田 海田 開田"
"かいだい 開題 海内 解題 改題"
"かいだか 階高"
"かいだく 快諾"
"かいだこ 貝蛸"
"かいだし 買出し"
"かいだて 買建て 階建て 買建 階建"
"かいだめ 買い貯め 買いだめ"
"かいだん 快談 戒壇 解団 怪談 会談 階段"
"かいだんし 快男子"
"かいだんじ 快男児"
"かいち 垣内 嘉一"
"かいちく 改築"
"かいちゅう 懷中 蛔蟲 界中 蛔虫 改鋳 懐中 回虫 海中"
"かいちょう 諧調 開張 回腸 開庁 怪鳥 海鳥 開帳 階調 快調 会長"
"かいちょうおん 海潮音"
"かいちょうせき 灰長石"
"かいちょく 回勅"
"かいちん 開陳"
"かいつう 開通"
"かいつけ 買付け 買付"
"かいつぶり 鳰"
"かいづ 海津"
"かいづか 貝塚"
"かいて 買手"
"かいてい 海程 階梯 開廷 海底 改定 改訂"
"かいていにまんり 海底二万里"
"かいてき 会的 快適"
"かいてん 廻轉 廻天 廻転 開店 回転"
"かいてんいわい 開店祝"
"かいてんどあ 回転ドア"
"かいてんば 回転刃"
"かいてんばん 回転板"
"かいてんまど 回転窓"
"かいてんやき 回転焼"
"かいでん 海田 皆伝"
"かいと 垣内"
"かいとう 海濤 灰陶 快盗 解党 解糖 快刀 開頭 快投 会頭 怪盗 解凍 解答 回答"
"かいとり 貝取り 貝取 買取り 買取"
"かいど 灰土 開度"
"かいどう 皆藤 怪童 海棠 会同 会堂 海堂 海道 街道"
"かいどく 会読 回読 買得 買い得 解読"
"かいどり 飼鳥"
"かいな 腕"
"かいなげ 腕挙げ"
"かいなで 掻い撫で"
"かいなひねり 腕捻り"
"かいなん 海南 海難"
"かいなんとう 海南島"
"かいにゅう 介入"
"かいにん 懐妊 解任"
"かいにんそう 海人草 海仁草"
"かいぬし 飼主 買主"
"かいぬま 海沼 貝沼"
"かいね 買い値 買値"
"かいねこ 飼猫 飼い猫"
"かいのう 戒能"
"かいは 会派"
"かいはい 改廃"
"かいはく 灰白"
"かいはつ 解発 開発"
"かいはつぐるーぷ 開発グループ"
"かいはつぶだい 開発部第"
"かいはら 開原"
"かいはん 解版 開板 改版"
"かいば 飼葉 飼い葉 海馬"
"かいばおけ 飼葉桶 飼い葉桶"
"かいばしら 貝柱"
"かいばつ 皆伐 海抜"
"かいばら 開原 貝原 海原 柏原"
"かいばん 改番 改版"
"かいひ 廻避 海彼 開扉 会費 回避"
"かいひば 回避馬"
"かいひょう 回表 界標 解氷 海氷 開票"
"かいひん 海浜"
"かいび 快美"
"かいびかえ 買い控え"
"かいびゃく 開闢"
"かいふ 海部 回付 開府"
"かいふう 海風 開封"
"かいふうそう 懐風藻"
"かいふかい 快不快"
"かいふき 貝吹"
"かいふく 開福 恢復 快復 開腹 回復"
"かいぶつ 怪物"
"かいぶつせいむ 開物成務"
"かいぶん 怪聞 回分 回文 灰分"
"かいぶんだけ 開聞岳"
"かいへい 皆兵 開平 海兵 開閉"
"かいへき 界壁"
"かいへん 拐騙 貝偏 壊変 海辺 改編 改変"
"かいべくとる 解ベクトル"
"かいべん 快弁 快便"
"かいぺーじ 改頁"
"かいぺいじ 改頁"
"かいほ 海保"
"かいほう 廻報 潰崩 改封 壊崩 懐抱 戒法 快報 海堡 開方 開法 海北 海法 回報 快方 介抱 解法 会報 解放 開放"
"かいほうせき 海泡石"
"かいほつ 開発"
"かいぼ 介母"
"かいぼう 海膨 海防 解剖"
"かいぼん 海盆"
"かいま 垣間"
"かいまい 買米 廻米 回米"
"かいまいしほう 買米仕法"
"かいまき 掻巻"
"かいまく 開幕"
"かいまみ 垣間見"
"かいまわりひん 買回り品"
"かいみ 快味"
"かいみょう 戒名"
"かいみん 快眠"
"かいむ 怪夢 海霧 会務 皆無"
"かいめ 回目"
"かいめい 晦暝 晦明 晦冥 階名 開明 改名 解明"
"かいめいじゅう 開明獣"
"かいめつ 潰滅 壊滅"
"かいめん 海綿 界面 海面"
"かいもうぶ 回盲部"
"かいもく 皆目"
"かいもどし 買戻し 買い戻し"
"かいもの 買いもの 買物"
"かいものかご 買い物かご 買い物カゴ 買い物篭 買い物籠"
"かいものぶくろ 買物袋 買い物袋"
"かいもん 階紋 海門 開聞 開門"
"かいもんきょくろ 槐門棘路"
"かいや 海谷"
"かいやく 改訳 解約"
"かいやくご 華夷訳語"
"かいゆ 快癒"
"かいゆう 回游 会友 灰釉 回遊"
"かいゆうかん 海遊館"
"かいゆうぎょ 回游魚 回遊魚"
"かいよう 海容 潰瘍 海洋"
"かいよね 買い米 糴"
"かいらい 界雷 傀儡"
"かいらぎ 梅花皮 鰄"
"かいらく 皆楽 海楽 偕楽 快楽"
"かいらん 廻覽 介卵 潰乱 解纜 壊乱 回覧"
"かいらんばん 回覧板"
"かいり 浬 海里 解離 乖離"
"かいりき 怪力"
"かいりく 海陸"
"かいりつ 介立 戒律"
"かいりゅう 開立 海流"
"かいりょう 改良"
"かいりょくしょく 灰緑色"
"かいりょくらんしん 怪力乱神"
"かいる 蛙"
"かいるい 貝類"
"かいれい 瑰麗 回礼 海嶺"
"かいれき 回暦 回歴 改暦"
"かいれつ 開裂"
"かいれつか 開裂果"
"かいろ 懐炉 海路 回路"
"かいろう 貝楼 海老 廻廊 回廊"
"かいろうどうけつ 偕老同穴"
"かいわ 會話 諧和 貝輪 海和 会話"
"かいわい 界隈"
"かいわれ 貝割 貝割れ"
"かいわれな 貝割れ菜"
"かいわん 怪腕 海湾"
"かいん 禍因 課員 下院"
"かう 斯う"
"かうん 家運"
"かうんたーせき カウンター席"
"かえ 華絵 佳枝 替 替え"
"かえい 嘉永"
"かえうた 替歌 替え歌"
"かえき 課役"
"かえぎ 替着"
"かえし 反し 返し"
"かえしうた 返歌"
"かえしうま 返馬"
"かえしぬい 返し縫い"
"かえしょうぞく 替装束"
"かえしん 替え芯"
"かえじ 替字"
"かえすかたな 返す刀"
"かえすがえす 返す返す"
"かえすがえすも 返す返すも"
"かえだま 替玉 替え玉"
"かえち 替地"
"かえって 反って 却って"
"かえつ 嘉悦 加越"
"かえつのうてつどう 加越能鉄道"
"かえで 替手 槭樹 楓"
"かえでぞく カエデ属"
"かえば 替え刃 替刃"
"かえもん 替紋"
"かえり 返り 帰り"
"かえりうち 返り討ち"
"かえりぎわ 帰り際"
"かえりぐるま 帰り車"
"かえりしな 帰りしな"
"かえりち 返値 返り血"
"かえりびと 帰人 帰り人"
"かえりみ 顧み"
"かえりみち 帰り路 帰り道"
"かえりやま 帰山"
"かえる 蛙"
"かえるあし 蛙足"
"かえるとび 蛙跳び 蛙飛び"
"かえん 花園 火焔 火炎"
"かえんざん 火焔山"
"かえんびん 火炎瓶"
"かお 顏 貌 顔"
"かおあわせ 顔合せ 顔合わせ"
"かおいろ 顔色"
"かおう 嘉応 鹿央 花押 花王"
"かおかたち 顔形 顔容 顔貌"
"かおく 家屋"
"かおこうげき 顔攻撃"
"かおじゃしん 顔写真"
"かおじゅう 顔中"
"かおそり 顔剃り"
"かおだし 顔出し"
"かおだち 顔立ち"
"かおぢゅう 顔中"
"かおつき 顔付き"
"かおつなぎ 顔繋ぎ"
"かおづくり 顔作り"
"かおなじみ 顔馴染み"
"かおはんぶん 顔半分"
"かおぱす 顔パス"
"かおぶれ 顔触れ 顔ぶれ"
"かおまけ 顔負け"
"かおみ 顔見"
"かおみしり 顔見知り"
"かおみせ 顔見世 顔見せ"
"かおむけ 顔向け"
"かおもじ 顔文字"
"かおやく 顔役"
"かおよごし 顔汚し"
"かおよせ 顔寄せ"
"かおり 佳央里 薫理 佳央理 歌織 香里 香織 薫り 香り 香"
"かおりまい 香り米"
"かおる 郁 馨 香 薫"
"かおるこ 薫子"
"かおん 訛音 加温"
"かか 窩家 仮果 花下 嬶"
"かかあ 嚊 嬶"
"かかあてんか 嚊天下"
"かかあでんか 嚊天下"
"かかい 歌会 課会 可解 花会 河海 下階 科会 下界"
"かかえ 抱え"
"かかおし カカオ脂"
"かかく 蝸角 貨客 家格 過客 価格"
"かかさま 母様"
"かかし 案山子"
"かかたいしょう 呵呵大笑 呵々大笑"
"かかぢ 香々地"
"かかと 踵"
"かかとおとし かかと落とし 踵落とし 踵落し"
"かかみがはら 各務原"
"かかり 掛 係り 係"
"かかりあい 掛り合い"
"かかりいん 係員"
"かかりかん 係官"
"かかりじょし 係助詞"
"かかりちょう 掛長 係長"
"かかりつけ 掛り付け 掛かり付け"
"かかりなし 係無"
"かかわらず 係わらず 拘らず 拘わらず"
"かかわり 係わり 関わり"
"かかわりあい 関わり合い"
"かかん 華翰 下澣 下浣 下瞰 禍患 夏官 河漢 加冠 花間 日間 可換 花冠 果敢"
"かかんかん 可換環"
"かかんぷ 火浣布"
"かが 火蛾 加我 鹿賀 夏芽 花芽 加賀"
"かがい 禍害 花街 加害 課外"
"かがく 家学 歌学 下顎 価額 化学 科学"
"かがくかいだい 科学会第"
"かがくかん 科学舘"
"かがくじょうたつ 下学上達"
"かがくてつがっかい 科学哲学会"
"かがくばたけ 科学畑"
"かがくぱるぷ 化学パルプ"
"かがっか 化学科 科学科"
"かがっかい 科学会"
"かがっかん 化学館"
"かがふり 冠"
"かがみ 鑒 鏡味 香我美 加賀見 加賀美 各務 鑑 鏡"
"かがみいし 鏡石"
"かがみいた 鏡板"
"かがみいわ 鏡岩"
"かがみえ 鏡絵"
"かがみがた 鏡形"
"かがみじごく 鏡地獄"
"かがみじし 鏡獅子"
"かがみつくりべ 鏡作部"
"かがみぬま 鏡沼"
"かがみの 鏡野"
"かがみのくに 鏡の国"
"かがみのま 鏡の間"
"かがみばり 鏡張り"
"かがみびらき 鏡開き"
"かがみもじ 鏡文字"
"かがみもち 鏡餅"
"かがみやま 鏡山"
"かがみわり 鏡割り"
"かがや 加賀谷"
"かがやき 輝き"
"かがり 炬 篝"
"かがりび 炬火 篝火"
"かがわ 嘉川 加川 賀川 香川"
"かがん 過雁 花顔 河岸"
"かき 夏記 家記 硴 蛎 蠣 堵 書き 書 牡蛎 火器 火気 花卉 花期 花器 牡蠣 垣 夏期 夏季 柿 下記"
"かきあげ 掻上げ 書上げ 掻揚げ 掻き揚げ かき揚げ"
"かきあぶら 牡蠣油"
"かきいれ 書入れ"
"かきいろ 柿色"
"かきうち 垣内"
"かきえもん 柿右衛門"
"かきお 柿生"
"かきおか 柿岡"
"かきおき 書置 書置き"
"かきおろし 書下し 書下ろし 描き下ろし"
"かきかえ 書換え 書換 書き換え"
"かきからちょう 蛎殻町"
"かきがら 牡蠣殻"
"かきがらちょう 蠣殻町"
"かきがらばい 牡蠣殻灰"
"かきがらぶき 牡蠣殻葺き"
"かききず 掻き傷"
"かきぎ 柿木"
"かきくだし 書き下し"
"かきくだしぶん 書下し文"
"かきぐせ 書き癖"
"かきことば 書言葉"
"かきこみ 書きこみ 書込 書込み"
"かきごおり 欠氷 かき氷"
"かきざき 硴崎 蠣崎 柿崎"
"かきした 柿下"
"かきしぶ 柿渋"
"かきすて 書捨て 掻き捨て"
"かきそんじ 書き損じ"
"かきぞめ 書初め"
"かきた 垣田 柿田"
"かきたかわ 柿田川"
"かきたに 垣谷 柿谷"
"かきだがわ 柿田川"
"かきちょう 蠣殻町"
"かきつ 嘉吉"
"かきつけ 書付け 書付"
"かきつばた 燕子花 杜若"
"かきて 描き手"
"かきとめ 書留"
"かきとり 書取り 書取"
"かきどなり 垣隣"
"かきなべ 蛎鍋 牡蠣鍋"
"かきなみ 柿並"
"かきぬま 柿沼"
"かきね 牆 墻 垣根"
"かきの 垣野 柿野"
"かきのうち 垣野内"
"かきのき 柿木"
"かきのたね 柿の種"
"かきのたみ 部曲 民部"
"かきのへた 柿の蔕"
"かきのもと 柿本"
"かきはちねん 柿八年"
"かきはら 垣原 柿原"
"かきはん 書き判 花押 書判"
"かきべ 部曲 民部"
"かきほん 書本"
"かきまみ 垣間見"
"かきもく カキ目"
"かきもじ 書文字"
"かきもち 欠餅 柿餅"
"かきもと 柿本"
"かきゃくせん 貨客船"
"かきや 垣屋"
"かきやすさ 書き易さ"
"かきやまぶし 柿山伏"
"かきゅう 苛求 下丘 可及 火急 加給 過給 火球 下級"
"かきょ 河渠 火炬 家居 科挙"
"かきょう 歌境 嘉慶 家郷 家教 華僑 佳境 架橋"
"かきょういん 花京院"
"かきょく 佳曲 歌曲"
"かきわき 垣脇"
"かきわけ 書分け"
"かきわり 書割"
"かきん 瑕瑾 家禽 課金"
"かきんど 火金土"
"かぎ 「」 『』 」 「 』 『 科技 鈎 鉤 鍵"
"かぎあな 鍵穴"
"かぎかっこ 】 【 」 「 』 『 かぎ括弧 鉤括弧"
"かぎかっことじ 」 』"
"かぎがた 鉤形 鍵形"
"かぎぐすり 嗅ぎ薬"
"かぎざき 鉤裂き"
"かぎし 鍵師"
"かぎじゅうじ 鉤十字"
"かぎたば 鍵束"
"かぎたばこ 嗅煙草 嗅ぎタバコ"
"かぎだい 東京都立科学技術大学"
"かぎちょう 科学技術庁 鍵長"
"かぎっこ 鍵っ子"
"かぎづめ 鈎爪 鉤爪"
"かぎの 鍵野"
"かぎばな 鉤鼻"
"かぎばり 鉤針"
"かぎばりあみ 鉤針編み"
"かぎほっく 鉤ホック"
"かぎもと 鍵本"
"かぎゃく 苛虐 加虐 可逆"
"かぎや 鍵屋"
"かぎゅう 蝸牛"
"かぎょう カ行 か行 課業 下行 稼業 家業"
"かぎり 限 限り"
"かく ∠ 恁く 劃 畫 覈 壑 埆 馘 較 革 撹 攪 覺 覚 骼 茖 貉 狢 擱 挌 恪 咯 喀 客 霍 蠖 矍 癨 攫 寉 鶴 幗 膕 掴 愨 殼 殻 擴 拡 嚇 赫 膈 隔 槨 椁 廓 郭 獲 穫 加来 賀来 斯く 佳句 閣 確 画 角 各 格 核"
"かくあげ 格上げ"
"かくい 角井 隔意 各位"
"かくいえ 各家"
"かくいつ 劃一 画一"
"かくいん 閣員 各員 角印 客員"
"かくう 架空"
"かくうえ 格上"
"かくえい 角榮 角栄"
"かくえき 赫奕 各駅"
"かくえきていしゃ 隔駅停車"
"かくおうざん 覚王山"
"かくおち 角落"
"かくおび 角帯"
"かくおん 核音 各音"
"かくか 核果 角化 各課"
"かくかい 郭隗 角回 角界 各階 各回 各界"
"かくかく 赫赫 赫々 各々"
"かくかっこ 】 【 〕 〔 ］ ［"
"かくかん 各間 各艦 各巻"
"かくがい 核外 閣外 格外"
"かくがた 角形 角型"
"かくがっこ 】 【 〕 〔 ］ ［ 角括弧"
"かくがり 角刈 角刈り"
"かくがわ 角川"
"かくがん 各眼"
"かくき 各機 各期"
"かくきー 各キー"
"かくきょく 各曲 各局"
"かくぎ 閣議"
"かくぎょう 角行 各行"
"かくく 各区"
"かくぐう 角隅"
"かくぐるーぷ 各グループ"
"かくけーす 各ケース"
"かくけい 角形"
"かくけん 核研 各県"
"かくげき 核撃"
"かくげっかん 隔月刊"
"かくげつ 客月 隔月 各月"
"かくげん 確言 格言"
"かくこ 加久子 各戸 確固"
"かくこう 各校 各項"
"かくこく 各国"
"かくご 客語 恪勤 各語 覚悟"
"かくごう 各号"
"かくごしっく 角ゴシック"
"かくごび 格語尾"
"かくごん 恪勤"
"かくさ 隔差 較差 格差"
"かくさく 画策"
"かくさげ 格下げ"
"かくさん 核酸 拡散"
"かくざ 擱坐 擱座"
"かくざい 角材"
"かくざとう 角砂糖"
"かくざら 角皿"
"かくし 隠し 客死 核子 各氏 各紙 各市 各誌"
"かくしぇるたー 核シェルター"
"かくしかめら 隠しカメラ"
"かくしき 格式"
"かくしきばる 格式張る"
"かくしご 隠し子"
"かくした 格下"
"かくしだま 隠し玉"
"かくしつ 革質 各室 確執 角質"
"かくして 斯くして"
"かくしとりで 隠し砦"
"かくしどり 隠し撮り"
"かくしぬの 隠し布"
"かくしはい 格支配"
"かくしまいく 隠しマイク"
"かくしゃ 覚者 各車 各社"
"かくしゃかん 各者間"
"かくしゃく 矍鑠"
"かくしゅ 獲取 攫取 馘首 鶴首 核種 各種"
"かくしゅう 客愁 各週 確執 隔週"
"かくしゅうほう 隔週報"
"かくしゅく 拡縮"
"かくしょ 角所 各署 各所"
"かくしょう 各賞 各章 各省 確証"
"かくしょく 各色"
"かくしん 隔心 客心 確診 核心 革新 確信"
"かくじ 覚治 各自"
"かくじく 各軸"
"かくじだいてき 画時代的"
"かくじつ 隔日 確実"
"かくじゅ 鶴寿"
"かくじゅいん 鶴寿院"
"かくじゅう 拡充"
"かくじょし 格助詞"
"かくじん 核仁 各人"
"かくすい 角錐"
"かくすう 画数"
"かくず 各図"
"かくせい 革正 客星 鶴声 廓清 郭清 隔世 拡声 覚醒"
"かくせいざい 覚せい剤"
"かくせいのかん 隔世の感"
"かくせき 各席"
"かくせつ 確説 各節"
"かくせん 各線"
"かくぜつ 隔絶"
"かくぜん 劃然 廓然 確然 画然"
"かくそう 核相 各層"
"かくぞう 覚三"
"かくた 角田"
"かくたい 革帯 各隊"
"かくたに 角谷"
"かくたる 確たる"
"かくたん 喀痰"
"かくだ 角田"
"かくだい 拡大"
"かくだいきょう 拡大鏡"
"かくだん 各段 格段"
"かくち 確知 覚知 隔地 各地"
"かくちく 角逐"
"かくちゅう 角柱"
"かくちょう 各町 格調 拡張"
"かくつう 格通 各通"
"かくつき 隔月 各月"
"かくつけ 格付"
"かくづけ 格付け"
"かくて 斯くて"
"かくてい 画定 各停 確定"
"かくていきばいばい 確定期売買"
"かくていきょしゅつがたねんきん 確定拠出型年金"
"かくてん 各点 各店"
"かくでーた 核データ"
"かくでん 各伝"
"かくとう 角藤 角灯 確答 挌闘 各棟 各党 格闘"
"かくとか 殻斗果"
"かくとく 獲得"
"かくど 赫怒 客土 確度 角度"
"かくどう 覚道"
"かくない 閣内 核内"
"かくなみ 角波"
"かくに 角煮"
"かくにん 確認"
"かくねん 客年 核燃 隔年 各年"
"かくの 角野"
"かくのーど 各ノード"
"かくのう 格納"
"かくのかさ 核の傘"
"かくのごとく 斯くの如く"
"かくのだて 角館"
"かくのふゆ 核の冬"
"かくは 各派"
"かくはく 攫搏"
"かくはん 各版 各般 撹拌 各班 攪拌 拡販"
"かくば 各馬"
"かくばしら 角柱"
"かくばん 各晩"
"かくひつ 擱筆"
"かくひょう 各表"
"かくひょうしき 格標識"
"かくびき 画引き"
"かくびん 各便 角瓶"
"かくふ 角歩"
"かくふく 拡幅"
"かくぶ 各部"
"かくぶつ 杜父魚 格物"
"かくぶん 確聞 各文"
"かくぶんぽう 格文法"
"かくへき 隔壁"
"かくへん 確変 各辺"
"かくへんか 格変化"
"かくべつ 各別 格別"
"かくほ 確保"
"かくほう 確報"
"かくぼう 角帽"
"かくま 角間"
"かくまき 角巻"
"かくまく 隔膜 角膜"
"かくまち 各街"
"かくまる 革マル 角丸"
"かくみさいる 核ミサイル"
"かくむ 各務"
"かくめ 各目"
"かくめい 革命"
"かくめん 各面"
"かくも 斯くも"
"かくもん 各問"
"かくや 覚弥 隔夜"
"かくやく 核薬 赫奕 確約"
"かくやす 格安"
"かくよう 各様"
"かくよく 鶴翼"
"かくら 加倉"
"かくらい 加倉井"
"かくらん 霍乱 各欄 撹乱 攪乱"
"かくり 核理 郭李 隔離"
"かくりつ 格律 格率 確率 確立"
"かくりつもでる 確率モデル"
"かくりょう 閣僚"
"かくりょく 核力 角力"
"かくりん 鶴林"
"かくれ 隠れ"
"かくれい 鶴唳"
"かくれいわ 礁"
"かくれうお 隠れ魚"
"かくれが 隠れ家"
"かくれつ 各列"
"かくれみの 隠れ蓑"
"かくれやど 隠れ宿"
"かくれんぼう 隠れん坊"
"かくろん 確論 各論"
"かくわ 各話"
"かくん 家君 家訓"
"かぐ 下愚 家具"
"かぐう 仮寓"
"かぐやひめ 輝夜姫 かぐや姫"
"かぐやま 香久山 香具山"
"かぐら 神楽"
"かぐらうた 神楽歌"
"かぐらお 神楽男"
"かぐらざか 神楽坂"
"かぐらづき 神楽月"
"かぐらぶえ 神楽笛"
"かぐん 加群 下郡"
"かけ × 欠け 賭 掛 賭け"
"かけあい 掛け合い"
"かけあし 駈け足 駆足 駆け足"
"かけい 科刑 下掲 家兄 嘉慶 火刑 花形 花茎 筧 家系 家計"
"かけうり 掛け売り 掛売り 掛売"
"かけおち 駆落 駆落ち 駆け落ち"
"かけかえ 掛替え"
"かけがい 掛買い"
"かけがえ 掛替 掛替え 掛け替え"
"かけがね 掛け金"
"かけがわ 掛川"
"かけきん 賭金 掛け金 掛金"
"かけことば 掛詞"
"かけこみ 掛込み 掛け込み 駈け込み 駆込み 駆け込み"
"かけこみでら 駆込み寺 駆け込み寺"
"かけごう 懸け香 懸香 掛け香 掛香"
"かけごえ 掛聲 掛声 かけ声 掛け声"
"かけごと 賭事"
"かけごや 掛小屋 掛け小屋"
"かけざかな 懸魚 懸け魚"
"かけざん 掛算 掛け算 かけ算"
"かけした 掛下"
"かけしょうぎ 賭将棋"
"かけじ 懸け路 掛け字 掛字 欠字"
"かけじく 掛軸 掛け軸"
"かけす 懸巣"
"かけすて 掛け捨て"
"かけず 掛け図 掛図"
"かけそば 掛け蕎麦"
"かけぞり 掛け反り"
"かけだおれ 掛倒れ"
"かけだし 掛出し 掛け出し 駆出し 駆け出し"
"かけちがい 掛違い 掛け違い"
"かけっこ 駆けっこ"
"かけつ 可欠 可決"
"かけつかばし 掛塚橋"
"かけど 掛戸"
"かけどけい 掛時計 掛け時計"
"かけなげ 掛け投げ"
"かけね 掛値 掛け値"
"かけのうお 懸けの魚"
"かけはし 棧 梯 懸橋 掛橋 懸け橋 掛け橋 架け橋"
"かけはた 欠畑 欠端"
"かけひ 懸け樋 筧"
"かけひき 駆引き 駆け引き"
"かけふ 掛布"
"かけふだ 掛札"
"かけぶとん 掛け布団 掛布団"
"かけべり 掛減り"
"かけまーじゃん 賭麻雀"
"かけまま 欠真間"
"かけめ 欠目 掛目 掛け目"
"かけもち 掛持ち 掛け持ち"
"かけもの 掛け物 掛物"
"かけや 掛合"
"かけら 欠けら 破片 欠片"
"かけり 翔"
"かけりつ 掛率"
"かける 掛ける ＊ ×"
"かけん 科学計測研究所 化研 科研 家憲"
"かけんひ 科学研究費"
"かげ 景 鹿毛 翳 蔭 陰 影"
"かげうら 影浦"
"かげえ 影画 影絵"
"かげかつ 景勝"
"かげき 歌劇 過激"
"かげききょう 蔭桔梗"
"かげきよ 景清"
"かげぐち 蔭口 陰口"
"かげごと 陰言"
"かげさわ 影沢"
"かげしばい 陰芝居"
"かげぜん 陰膳"
"かげつ 荷月 箇月 ケ月 か月 ヵ月 カ月 ヶ月 花月"
"かげとものみち 山陽道"
"かげどうろう 影灯籠"
"かげばら 陰腹"
"かげひこ 景彦"
"かげひなた 陰日向"
"かげふみ 影踏み"
"かげぼうし 影法師"
"かげぼし 陰干し"
"かげま 陰間"
"かげまぢゃや 陰間茶屋"
"かげまる 影丸"
"かげみつ 景光"
"かげむしゃ 影武者"
"かげもと 影本"
"かげやま 陰山 蔭山 景山 影山"
"かげゆ 勘解由"
"かげり 翳り"
"かげろう 蜻蛉 蜉蝣 陽炎"
"かげん ⊃ 訛言 過現 過言 仮言 寡言 嘉言 仮現 嘉元 下元 下弦 加減 下限"
"かげんめいほう 仮言命法"
"かこ 水手 水夫 苛湖 加挙 加古 過去"
"かこい 囲い"
"かこう 嘉肴 加功 華甲 歌稿 佳肴 花梗 河港 火工 花香 仮構 架構 下行 火口 化工 下降 河口 加工"
"かこうおんけい 下降音形"
"かこうがん 花崗岩"
"かこうきゅう 火口丘"
"かこうげん 火口原"
"かこうこ 河口湖 火口湖"
"かこうせき 河口堰"
"かこうぜき 河口堰"
"かこうづけ 加工付"
"かこうなべ 加工鍋"
"かこうにく 加工肉"
"かこうにゅう 加工乳"
"かこく 禾穀 苛刻 ヶ国 カ国 河谷 苛酷 過酷"
"かこくぼん 家刻本"
"かこぜ 過去世"
"かこつ 化骨"
"かこみきじ 囲み記事"
"かころぐ 過去ログ"
"かこん 仮根 禍根"
"かご 訛語 歌語 華語 花後 篭 加護 駕籠 過誤 籠"
"かごう 加号 化合"
"かごかき 駕籠舁き"
"かごさか 籠坂"
"かごしま 鹿児島"
"かごせ 篭瀬 籠瀬"
"かごそう 夏枯草"
"かごたに 篭谷 籠谷"
"かごと 託言"
"かごのとり 籠の鳥"
"かごはら 篭原"
"かごみみ 籠耳"
"かごめ 籠目"
"かごん 過言"
"かさ 疽 加佐 暈 瘡 嵩 笠 傘"
"かさあげ 嵩上げ"
"かさい 家栽 河西 加西 笠井 葛西 家妻 歌才 家宰 果菜 花菜 家裁 火災"
"かさいがん 火砕岩"
"かさいし 笠石"
"かさいぜんぞう 葛西善蔵"
"かさいぶつ 火砕物"
"かさいりゅう 火砕流"
"かさおか 笠岡"
"かさかき 瘡掻き"
"かさかけ 笠懸"
"かさがたけ 笠ヶ岳"
"かさぎ 笠置 笠木"
"かさく 仮作 家作 寡作 佳作"
"かさくら 笠倉"
"かさぐも 笠雲"
"かささ 笠沙"
"かささぎ 鵲"
"かさしま 笠島"
"かさじぞう 笠地蔵"
"かさじま 笠島"
"かさじょう 傘状"
"かさたて 傘立て 傘立"
"かさだか 嵩高"
"かさつ 苛察"
"かさでら 笠寺"
"かさど 笠戸"
"かさなり 重なり"
"かさぬい 笠縫"
"かさね 襲 重ね"
"かさねがき 重ね描き"
"かさねつぎ 重ね継ぎ"
"かさねて 重ねて"
"かさねどり 重ね録り"
"かさねのいろめ 襲の色目"
"かさのり 傘海苔"
"かさはら 笠原"
"かさぶくろ 傘袋"
"かさぶた 痂 瘡蓋"
"かさま 笠間"
"かさまつ 笠松"
"かさみ 嵩"
"かさり 笠利"
"かさん 加餐 家産 可算 加算"
"かざ 風"
"かざあな 風穴"
"かざい 夏材 歌材 貨財 花材 家財"
"かざいれ 風入れ"
"かざおと 風音"
"かざおれ 風折れ"
"かざかみ 風上"
"かざきり 風切り"
"かざきりば 風切羽"
"かざきりばね 風切り羽"
"かざぐも 風雲"
"かざぐるま 風車"
"かざごえ 風声 風邪声"
"かざし 挿頭"
"かざしも 風下"
"かざと 風戸"
"かざとおし 風通し"
"かざはな 風花"
"かざはや 風早"
"かざばな 風花"
"かざま 風間"
"かざまち 風街"
"かざまつり 風祭り 風祭"
"かざまど 風窓"
"かざみ 風見"
"かざみどり 風見鶏"
"かざむき 風向 風向き"
"かざり 飾り"
"かざりけ 飾り気"
"かざりけい 飾り罫"
"かざりだけ 飾り竹"
"かざりだな 飾り棚"
"かざりっけ 飾りっ気"
"かざりぬい 飾り縫い"
"かざりばね 飾り羽"
"かざりひも 飾り紐"
"かざりまど 飾窓 飾り窓"
"かざわ 鹿沢"
"かざん 加算 華山 火山"
"かざんがす 火山ガス"
"かざんがん 火山岩"
"かざんだん 火山弾"
"かざんてんのう 花山天皇"
"かざんとう 火山島"
"かざんばい 火山灰"
"かざんみゃく 火山脈"
"かざんむげん 可算無限"
"かざんれき 火山礫"
"かし 嫁資 槝 橿 下士 花糸 貸し 貸 下賜 仮死 華氏 河岸 樫 下肢 瑕疵 可視 歌詞 菓子"
"かしあげ 借上"
"かしい 香椎"
"かしお 加塩"
"かしおか 柏岡"
"かしおけいさんき カシオ計算機"
"かしおぺあざ カシオペア座"
"かしおぺやざ カシオペヤ座"
"かしかーど 歌詞カード"
"かしかた 貸方"
"かしかぶ 貸株"
"かしき 炊き 爨 花式 下式"
"かしきり 貸切"
"かしきん 貸金"
"かしく 畏"
"かしこ 彼処 畏 賢"
"かしこう 可視光"
"かしこし 貸越"
"かしこじまかん 賢島間"
"かしこどころ 賢所"
"かしざお 貸竿"
"かししつ 貸室"
"かししぶり 貸し渋り"
"かしずき 傅き"
"かしずきびと 傅き人"
"かしせき 貸席"
"かしだ 樫田"
"かしだおれ 貸倒"
"かしだし 貸出"
"かしち 貸地"
"かしちん 貸賃"
"かしつ 呵叱 加執 火室 加湿 過失"
"かしつかさ 菓子司"
"かしつけ 貸付"
"かして 貸手"
"かしぬし 貸主"
"かしの 柏野"
"かしはがし 貸し剥がし"
"かしはら 樫原 橿原"
"かしば 香芝"
"かしばこ 菓子箱"
"かしぱん 菓子パン"
"かしびる 貸しビル"
"かしぶね 貸舟"
"かしぶんさん 家資分散"
"かしほん 貸本"
"かしま 加嶋 加島 嘉島 鹿嶋 鹿島 貸間"
"かしまた 樫又"
"かしまだ 鹿島田"
"かしまやり 鹿島槍"
"かしみせ 貸し店"
"かしむら 鹿志村 樫村"
"かしも 加子母"
"かしもと 貸元"
"かしもり 樫森"
"かしゃ 火車 華奢 貨車 加者"
"かしゃがた 花車形 花車方"
"かしゃく 苛責 仮借 呵責"
"かしゃばば 火車婆"
"かしや 貸家"
"かしやま 樫山"
"かしゅ 佳酒 火酒 歌手"
"かしゅう 加集 何首烏 賀集 河州 家集 加州 歌集"
"かしゅういも 何首烏芋"
"かしゅく 可縮"
"かしょ 花書 過所 歌書 家書 華胥 過書 カ所 ヶ所 個所 箇所"
"かしょう 迦葉 過賞 加商 嘉承 嘉祥 花床 寡少 華宵 過昇 火傷 河床 火床 仮象 過小 過少 歌唱 仮称"
"かしょうさんぜん 菓匠三全"
"かしょく 河蝕 河食 稼穡 火食 貨殖 家職 仮植 華燭 過食"
"かしょくのてん 華燭の典"
"かしょくぶ 可食部"
"かしら 頭"
"かしらいも 頭芋"
"かしらがき 頭書"
"かしらもじ 頭文字"
"かしりょう 貸料"
"かしろ 嘉代"
"かしわ 栢 柏"
"かしわぎ 柏木"
"かしわくら 柏倉"
"かしわざき 柏崎"
"かしわし 柏市"
"かしわで 膳夫 膳 拍手 柏手"
"かしわば 柏葉"
"かしわばら 柏原"
"かしわぶち 柏渕"
"かしわほうめん 柏方面"
"かしわまち 柏町"
"かしわもち 柏餅"
"かしわら 柏原"
"かしん 禍心 下臣 花唇 仮身 歌神 河神 下唇 花神 火神 加振 花心 家臣 過信"
"かしんれいげつ 嘉辰令月"
"かじ 鍛治 加冶 加地 加治 嘉事 加持 花時 柁 楫 梶 舵 鍛冶 火事 家事"
"かじい 梶井"
"かじうら 梶浦"
"かじお 梶尾"
"かじか 梶賀 鮖 杜父魚 河鹿 鰍"
"かじかがえる 河鹿蛙"
"かじかざわ 鰍沢"
"かじかわ 加冶川 舵川"
"かじがや 梶ケ谷"
"かじき 加治木 旗魚 梶木"
"かじきまぐろ 梶木鮪"
"かじく 仮軸 花軸"
"かじし 華字紙"
"かじせいけい 下自成蹊"
"かじた 梶田"
"かじたに 梶谷"
"かじつ 佳日 花実 夏日 過日 果実"
"かじつはん 夏日斑"
"かじづか 舵柄"
"かじとり 舵取り"
"かじの 梶野"
"かじのき 梶の木"
"かじはら 梶原"
"かじま 梶真 鹿嶋 鹿島"
"かじもと 梶本"
"かじゃ 冠者"
"かじや 梶谷"
"かじやちょう 加治屋町"
"かじゅ 花樹 果樹"
"かじゅう 過重 加重 荷重 果汁"
"かじゅうち 可住地"
"かじゅうりょう 下重量"
"かじゅく 過熟 家塾"
"かじゅし 果樹試"
"かじょ 歌女 家女 花序 加除"
"かじょう 下情 渦状 家常 河上 箇条 過剰"
"かじょうがき 個条書き 箇条書"
"かじわら 梶原"
"かじん 寡人 佳人 家人 歌人"
"かす 滓 糟 粕"
"かすい 仮睡 火水 河水 下垂 加水"
"かすいもく 火水木"
"かすう 仮数 価数"
"かすかべ 春日部"
"かすかわ 粕川"
"かすが 春日"
"かすがい 春日居 鎹 春日井"
"かすがづくり 春日造"
"かすがの 春日野"
"かすがのつぼね 春日局"
"かすがばる 春日原"
"かすけーどせつぞく カスケード接続"
"かすじる 粕汁"
"かすず 糟酢 粕酢"
"かすたに 糟谷"
"かすたむか カスタム化"
"かすだ 粕田"
"かすづけ 糟漬 粕漬"
"かすとり 糟取り 粕取り"
"かすとりざっし カストリ雑誌"
"かすとりしゅ カストリ酒"
"かすなべ 粕鍋"
"かすぴかい カスピ海"
"かすみ 香純 香住 香澄 霞"
"かすみあみ 霞網"
"かすみがうら 霞浦 霞ヶ浦"
"かすみがせき 霞ケ関 霞ヶ関 霞が関"
"かすみがせきびる 霞が関ビル"
"かすみさい 霞祭"
"かすみさんしょううお 霞山椒魚"
"かすみそう 霞草"
"かすみのめ 霞目"
"かすや 糟谷 粕屋 粕谷"
"かすり 綛 纃 緕 飛白 絣"
"かすりきず 擦り傷 かすり傷"
"かすれ 掠れ"
"かず 香鶴 一寿 數 一 和 下図 数"
"かずあき 和晶 一章 和晃 一晃 一彰 一明 和昭 和明"
"かずあわせ 数合わせ"
"かずい 花蘂 花蕊"
"かずえ 一枝 和枝 和恵 一恵 主計"
"かずえのかみ 主計頭"
"かずえりょう 主計寮"
"かずお 一穂 和郎 和生 和雄 一男 一雄 和男 一生 一夫 和夫"
"かずおか 数岡"
"かずおみ 和臣"
"かずかず 数数 数々"
"かずき 被衣 一起 一喜 和紀 一機 和樹 一樹"
"かずこ 加寿子 加純子 数子 佳寿子 量子 和子"
"かずさ 上総"
"かずし 一志 数史 和士 一至 一司 和司 和志"
"かずしげ 一繁 和茂 一茂 和重"
"かずしれず 数知れず"
"かずじたい 数自体"
"かずすけ 一助"
"かずたか 一任 和貴 一貴 一隆"
"かずてる 一晃 一輝"
"かずと 和人 一人"
"かずとき 和時"
"かずとし 和淑 数敏 一世 一寿 一敏 一利 和利 和敏"
"かずなり 一成"
"かずね 和音"
"かずの 数野"
"かずのこ 鯑 数の子"
"かずのみや 和宮"
"かずのり 主紀 千典 一孔 一範 一紀 一憲 和紀 和憲 和徳 和典 和則"
"かずひこ 和比古 一彦 和彦"
"かずひさ 数久 一寿 一久 和久"
"かずひで 一英 和秀 和英 一秀"
"かずひと 和仁 和人 一仁 一人"
"かずひろ 一寛 一広 一裕 一洋 和裕 和浩 一宏 和広 一浩 一弘 一博 和博 和宏 和弘"
"かずふみ 一文 和史"
"かずほ 一穂"
"かずほど 数程"
"かずま 數間 和磨 一磨 和馬"
"かずまさ 和昌 一昌 和政 数正 一正 和正"
"かずまる 一丸"
"かずまろ 和麻呂"
"かずみ 香樹実 一巳 香津美 和実 一三 一味 和巳 一美 和美"
"かずみち 一路"
"かずもと 一元"
"かずもの 数物"
"かずや 数也 一八 和弥 一弥 一哉 和哉 一也 和也"
"かずやす 一泰"
"かずゆき 数幸 和恭 一行 和行 一之 一幸 和之 和幸"
"かずよ 和世 一代 和代"
"かずよし 和芳 和由 和好 和美 和良 一義 和義"
"かずら 鬘 蔓 葛"
"かずらばし 蔓橋"
"かずらもの 鬘物"
"かずわり 数割"
"かせ 加世 加瀬 加勢 綛 枷"
"かせい 苛政 火成 歌聖 化政 河清 火勢 家政 苛性 仮性 加勢 化成 火星"
"かせいかり 苛性カリ"
"かせいがん 火成岩"
"かせいそーだ 苛性ソーダ"
"かせいたい 仮声帯"
"かせいふ 家政婦"
"かせき 可積 化石"
"かせぎ 鹿 稼ぎ"
"かせだ 加世田"
"かせつ 佳節 架設 仮設 仮説"
"かせつきょう 仮設橋"
"かせづえ 鹿杖"
"かせやま 鹿背山"
"かせん 貨泉 火箭 加線 火線 歌仙 化繊 寡占 架線 下線 河川"
"かせんしき 河川敷"
"かせんじ 架線事"
"かせんじき 河川敷"
"かせんちゅう 架線柱"
"かぜ 風邪 風"
"かぜあたり 風当り 風当たり"
"かぜい 苛税 寡勢 課税"
"かぜおき 風興"
"かぜおと 風音"
"かぜかじゅう 風荷重"
"かぜきた 風北"
"かぜぐすり カゼ薬 風邪薬"
"かぜけ 風邪気"
"かぜたいふう 風台風"
"かぜたち 風立"
"かぜつかい 風使い"
"かぜとおし 風通し"
"かぜのたに 風の谷"
"かぜのたより 風の便り"
"かぜのぼん 風の盆"
"かぜまかせ 風任せ"
"かぜまち 風待ち"
"かぜまつり 風祭り 風祭"
"かぜむき 風向き"
"かぜよけ 風よけ"
"かぜん 果然"
"かそ 火鼠 可塑 過疎"
"かそう 価層 仮相 仮葬 家相 火葬 仮装 下層 仮想"
"かそううん 下層雲"
"かそうかい 可想界"
"かそうてき 仮想敵"
"かそく 仮足 可測 加速"
"かそり 加曽利"
"かぞ 數 数 加須"
"かぞう 架蔵 家蔵 加増"
"かぞえ 数え"
"かぞえうた 数え歌"
"かぞえどし 数え年"
"かぞく 華族 家族"
"かぞくおん 下属音"
"かぞくそう 家族葬"
"かた 沫 夥多 潟 片 過多 形 型 方 肩"
"かたあし 片足"
"かたあて 肩当て"
"かたあやまり 型誤り"
"かたい 難 歌体 過怠 化体 下腿"
"かたいと 片糸"
"かたいれ 肩入 肩入れ"
"かたうで 片腕"
"かたうど 方人"
"かたえ 傍"
"かたお 片尾"
"かたおか 片岡"
"かたおし 型押し"
"かたおち 型落ち"
"かたおや 片親"
"かたかいそう 型階層"
"かたかけ 肩掛 肩掛け"
"かたかなご カタカナ語"
"かたかなひょうき カタカナ表記"
"かたかま 片鎌"
"かたかんせつ 肩関節"
"かたがい 片貝"
"かたがき 肩書き 肩書"
"かたがた 旁々 旁 方々"
"かたがため 肩固め"
"かたがみ 型紙"
"かたがみてつどう 片上鉄道"
"かたがわ 片側"
"かたがわり 肩代り 肩代わり"
"かたき 敵 仇"
"かたきうち 敵討 敵討ち 仇討ち"
"かたきやく 敵役"
"かたぎ 形木 堅気 気質"
"かたぎし 片岸"
"かたぎぬ 肩衣"
"かたぎのしゅう 堅気の衆"
"かたぎり 片桐"
"かたく 花托 仮託 火宅 家宅"
"かたくずれ 型くずれ 型崩れ"
"かたくち 片口"
"かたくちいわし 片口鰯"
"かたくな 頑な 頑"
"かたくら 片倉"
"かたくり 片栗"
"かたくりこ 片栗粉"
"かたくるし 堅苦し"
"かたぐち 肩口 片口"
"かたぐるま 肩車"
"かたけんさ 型検査"
"かたげんご 型言語"
"かたこ 片子"
"かたこい 片恋"
"かたこう 型鋼 型項 形鋼"
"かたこと 片言"
"かたこり 肩こり 肩凝り"
"かたごし 肩越し"
"かたさき 肩先"
"かたしき 型式"
"かたしすてむ 型システム"
"かたしていし 型指定子"
"かたしな 片品"
"かたしろ 形代"
"かたじょうほう 型情報"
"かたじん 堅人"
"かたすいろん 型推論"
"かたすかし 肩透し 肩透かし"
"かたすみ 片隅"
"かたず 固唾"
"かたずみ 堅炭"
"かたせ 片瀬"
"かたせんげん 型宣言"
"かたそで 片袖"
"かたぞめ 型染め"
"かたた 堅田"
"かたたいけい 型体系"
"かたたがえ 方違え"
"かたたそう 型多相"
"かたたたき 肩叩き"
"かたたち 方達"
"かたち 型 貌 容 形"
"かたちじたい 形自体"
"かたちぜんたい 形全体"
"かたちづくり 形作り"
"かたちんば 片跛"
"かたっぱし 片っ端"
"かたっぽ 片っぽ 片っ方"
"かたつ 可達 下達"
"かたつう 肩痛"
"かたつき 可達木 型つき 肩付き 肩付 型付"
"かたつけ 型付 型付け"
"かたつばさ 肩翼"
"かたつぶり 蝸牛"
"かたつむり 蝸 蝸牛"
"かたづ 固唾"
"かたづけ 型付け"
"かたて 片手"
"かたていぎ 型定義"
"かたていすう 型定数"
"かたておち 片手落"
"かたで 堅手"
"かたとき 片時"
"かたどおり 型通り"
"かたな 刀"
"かたなかじ 刀鍛冶"
"かたながり 刀狩り 刀狩"
"かたなきず 刀疵 刀傷"
"かたなし 形無し"
"かたなめい 刀銘"
"かたなや 刀屋"
"かたならし 肩慣らし"
"かたにく 肩肉"
"かたぬき 型抜 型抜き"
"かたの 片野 交野"
"かたは 片羽 片刃"
"かたはい 片肺"
"かたはし 片端"
"かたはじ 片端"
"かたはだ 片肌"
"かたはば 肩幅"
"かたはま 片浜"
"かたはら 片腹"
"かたばかり 形許り"
"かたばみ 酢漿草"
"かたばみか カタバミ科"
"かたばん 型版 型板 型番"
"かたぱっと 肩パット"
"かたぱん 堅パン"
"かたひがし 潟東"
"かたひざ 片膝"
"かたひじ 片肘 肩肘"
"かたひと 方人"
"かたひも 肩紐"
"かたひら 片平"
"かたびら 帷子"
"かたびらのつじ 帷子ノ辻"
"かたふち 片淵"
"かたぶつ 堅物"
"かたぶとり 固太り"
"かたへん 方偏"
"かたへんかん 型変換"
"かたへんすう 型変数"
"かたほ 片帆"
"かたほう 片方"
"かたほとり 片辺"
"かたぼう 片棒"
"かたま 片間"
"かたまち 片町"
"かたまり 固まり 塊"
"かたまりにく 塊肉"
"かたみ 片見 片身 肩身 形見"
"かたみだし 肩見出し"
"かたみち 片道"
"かたみみ 片耳"
"かたみわけ 形見わけ"
"かたむき 傾き"
"かため 堅め 固め 片眼 片目"
"かためい 型名"
"かためん 片面"
"かたもちばり 片持ち梁"
"かたもと 片本"
"かたもの 型物"
"かたもみ 肩揉み"
"かたもり 容保"
"かたや 片や"
"かたやき 固焼き"
"かたやぶり 型破り"
"かたやま 片山"
"かたやません 片山潜"
"かたやまづ 片山津"
"かたやまてつ 片山哲"
"かたゆで 固茹で"
"かたよせ 片寄"
"かたより 偏り"
"かたらい 語らい"
"かたり 騙り 語り"
"かたりぐさ 語り種 語り草"
"かたりろん 型理論"
"かたりん 片輪"
"かたる 拐"
"かたろーす 肩ロース"
"かたわ 片端 片輪"
"かたわき 片脇"
"かたわら 旁 傍 傍ら"
"かたわれ 片割れ"
"かたん 可鍛 荷担 加担 下端"
"かたんいと カタン糸"
"かだ 伽陀 華佗 華陀"
"かだい 歌題 架台 仮題 過大 課題"
"かだん 下段 華壇 果断 歌壇 花壇"
"かち 徒歩 褐 磆 可知 加地 徒 勝 勝ち 価値"
"かちあげ 搗ち上げ"
"かちいくさ 歩兵 勝ち戦"
"かちいろ 勝色 褐色"
"かちいろおどし 褐色縅"
"かちうま 勝ち馬 勝馬"
"かちうん 勝運"
"かちえ 褐衣 勝絵"
"かちおでら 勝尾寺"
"かちかちやま かちかち山"
"かちかぶり 褐冠"
"かちがしら 徒士頭"
"かちき 勝ち気 勝気"
"かちぎぬ 褐衣"
"かちぎね 搗ち杵"
"かちく 家畜"
"かちぐり 搗ち栗"
"かちこし 勝ち越し"
"かちすう 勝数"
"かちてん 勝点"
"かちどき 勝ちどき 勝ち鬨 勝鬨"
"かちなのり 勝名乗り"
"かちぬき 勝抜き"
"かちぼし 勝星 勝ち星"
"かちめ 勝目"
"かちゅう 花柱 華中 火中 渦中 家中"
"かちょ 家猪"
"かちょう 課徴 可聴 家長 花鳥 科長 蚊帳 課長"
"かちょうせん 花蝶扇"
"かちょうづき 課長付"
"かちょうのみや 華頂宮"
"かちん 餅 褐"
"かぢ 加治 加地 鍛冶"
"かっ 渇 合"
"かっか 各課 角化 閣下"
"かっかい 角界 各回 各界"
"かっかく 赫々"
"かっかざん 活火山"
"かっかそうよう 隔靴掻痒"
"かっかんてき 客観的"
"かっき 客気 画期 各期 活気"
"かっきてき 劃期的"
"かっきゅう 割球"
"かっきょ 割拠"
"かっきょう 活況"
"かっきょく 各曲 各局"
"かっきん 恪勤"
"かっくう 滑空"
"かっけ 脚気"
"かっけい 角形 活計"
"かっけた 各桁"
"かっけつ 喀血"
"かっこ “” ‘’ （） 「」 ｛｝ 《》 〈〉 〔〕 ［］ 【】 『』 ” “ ’ ‘ ） （ 」 「 ｝ ｛ 》 《 〉 〈 〕 〔 ］ ［ 】 【 』 『 格好 羯鼓 確乎 各戸 各個 括弧 確固"
"かっこう 割腔 角行 滑行 郭公 滑降 恰好 格好"
"かっこうほう 滑腔砲"
"かっこく 各国"
"かっこくぼん 活刻本"
"かっことじ 】 》 〉"
"かっこない カッコ内"
"かっこん 葛根"
"かっこんとう 葛根湯"
"かっさい 喝采 葛西"
"かっさつ 活殺"
"かっしき 喝食"
"かっしゃ 滑車 活写"
"かっしょう 滑翔"
"かっしょく 褐色"
"かっすい 活水 渇水"
"かっせい 活性"
"かっせいたん 活性炭"
"かっせき 滑席 滑石"
"かっせん 合戰 活栓 割線 活線 合戦"
"かっそう 割創 褐藻 滑走"
"かった 刈田 勝田"
"かったい 乞丐 癩"
"かったつ 豁達 闊達"
"かったん 褐炭"
"かっちゃく 活着"
"かっちゅう 甲冑"
"かっちゅうぎょ 甲冑魚"
"かって 勝手"
"かってつけ 勝手付"
"かっとう 葛藤"
"かっとわり カット割り"
"かっぱ Κ κ 川童 喝破 合羽 河童"
"かっぱつ 活溌 活発"
"かっぱつはっち 活溌溌地"
"かっぱまき カッパ巻き かっぱ巻き 河童巻"
"かっぱん 活版"
"かっぱんずり 活版刷"
"かっぱんびょう 褐斑病"
"かっぷ ∪ 割賦"
"かっぷく 割腹 恰幅"
"かっぷめん カップ麺"
"かっぺい 勝平"
"かっぽ 濶歩 闊歩"
"かっぽう 活法 割烹"
"かつ ∩ ∧ 剋 克 捷 勝 恰 戞 戛 黠 劼 鞨 蠍 蝎 羯 曷 褐 葛 渇 磆 猾 滑 豁 瞎 轄 割 蛞 聒 刮 筈 括 濶 闊 活 且 且つ 喝"
"かつあい 割愛"
"かつあき 勝章 勝昭 克明"
"かつい 勝井"
"かついち 勝一"
"かつうら 勝浦"
"かつえ 勝恵 勝江"
"かつえき 滑液"
"かつお 松魚 堅魚 勝生 克夫 勝夫 勝雄 勝男 鰹"
"かつおうり 鰹売り"
"かつおぎ 堅魚木 鰹木"
"かつおだし 鰹出汁"
"かつおどり 鰹鳥"
"かつおぶし かつお節 鰹節"
"かつかいしゅう 勝海舟"
"かつかざん 活火山"
"かつかじゅう 活荷重"
"かつかつ 戛々 戛戛"
"かつかわ 勝川"
"かつがん 活眼"
"かつき 克己 勝木 香月"
"かつきち 勝吉"
"かつぎ 被"
"かつぎや 担ぎ屋"
"かつぎょ 活魚"
"かつくら 勝鞍 勝倉"
"かつげき 活劇"
"かつこ 克子 勝子"
"かつご 活語"
"かつごう 渇仰"
"かつさい 勝斉"
"かつざい 滑剤"
"かつし 克史 克志 且 勝志 克"
"かつしか 葛飾"
"かつしま 勝島"
"かつしろう 勝四郎"
"かつしんたろう 勝新太郎"
"かつじ 功至 勝次 勝治 活字"
"かつじょう 割譲"
"かつじょうほう 活情報"
"かつじん 活人"
"かつぜつ 活舌 滑舌"
"かつぜん 戛然 豁然"
"かつぞう 勝三"
"かつた 勝田"
"かつたに 勝谷"
"かつたろう 勝太郎"
"かつだんそう 活断層"
"かつて 曽て 曾て 嘗て"
"かつとし 克年 克俊 克敏 勝俊 勝敏 勝利"
"かつどう 活動"
"かつどん カツ丼"
"かつなり 勝成"
"かつぬま 勝沼"
"かつの 鹿角 勝野"
"かつのぶ 克亘"
"かつのり 勝典 克則 克典 勝則"
"かつはた 勝畑"
"かつば 活馬"
"かつひこ 捷彦 勝彦 克彦"
"かつひさ 克久 勝久"
"かつひで 勝秀"
"かつひと 克仁"
"かつひら 勝平"
"かつひろ 勝寛 克裕 克宏 克博 勝宏 勝洋 克弘 勝浩 勝広 克洋 勝弘"
"かつふみ 克文"
"かつぶし 鰹節"
"かつぶつ 活仏"
"かつべ 勝部"
"かつべん 活弁"
"かつぼう 渇望"
"かつま 克馬 勝間"
"かつまく 滑膜"
"かつまさ 克正 勝正"
"かつまた 勝股 勝亦 勝間田 勝俣 勝又 且つ又"
"かつみ 香津美 克実 勝見 克美 勝己 勝巳 克巳 勝美 克己"
"かつもく 割目 刮目"
"かつもと 勝元 勝本"
"かつや 勝弥 克弥 勝谷 勝哉 克哉 勝也 克也"
"かつやく 括約 活躍"
"かつやくば 活躍馬"
"かつやま 勝山"
"かつゆき 勝征 勝幸 勝行 克行 克幸 克之 勝之"
"かつよう 活用"
"かつようじゅ 闊葉樹"
"かつよし 克善 克能 勝吉 克義 勝義"
"かつより 勝頼"
"かつら 蘰 鬘 桂"
"かつらお 葛尾"
"かつらか カツラ科"
"かつらかわ 桂川"
"かつらがわ 桂川"
"かつらぎ 桂木 葛城"
"かつらく 滑落"
"かつらさんし 桂三枝"
"かつらたろう 桂太郎"
"かつらだ 桂田"
"かつらのみや 桂宮"
"かつらはま 桂浜"
"かつらばやし 桂林"
"かつらぶんちん 桂文珍"
"かつらむき 桂剥き"
"かつらゆみ 桂由美"
"かつらりきゅう 桂離宮"
"かつりょく 活力"
"かつれい 割礼"
"かつれき 活歴"
"かつれん 勝連"
"かつろ 活路"
"かつろう 克朗"
"かづき 香月"
"かづけ 日付"
"かづさ 加津佐"
"かづの 鹿角"
"かづみ 香津美"
"かて 粮 糅 糧"
"かてい 河堤 嘉禎 下底 河底 仮定 課程 過程 家庭"
"かてつ 科哲"
"かててくわえて 糅てて加えて"
"かてん 火点 加点"
"かでな 嘉手納"
"かでん 訛伝 瓜田 架電 荷電 家伝 家電"
"かでんし 価電子"
"かでんしょ 花伝書"
"かでんりゅう 渦電流"
"かと 科斗 蝌蚪 過度 加登 過渡"
"かとう 裹頭 賀藤 加登 加東 河東 寡頭 花筒 過当 可撓 加糖 果糖 下等 加藤"
"かとうぎ 加藤木"
"かとうともさぶろう 加藤友三郎"
"かとうぶし 河東節"
"かときち 加ト吉"
"かとく 稼得 嘉徳 家督"
"かとくたい 科特隊"
"かとり 鹿取 香取 蚊取り"
"かとりせんこう 蚊取線香"
"かとりなひこ 楫取魚彦"
"かとん 火遁"
"かとんぼ 蚊蜻蛉"
"かど └ ┌ ┐ ┘ 柧 賀戸 火度 下土 加登 過渡 廉 門 過度 角"
"かどいけ 門池"
"かどう 可導 火動 火道 渦動 歌道 華道 可動 稼働 稼動"
"かどうかん 仮導管"
"かどうきょう 架道橋 可動橋"
"かどうぜき 可動堰"
"かどおか 角岡"
"かどかど 廉々"
"かどかり 下土狩"
"かどかわ 角革 角川"
"かどがき 門垣"
"かどがまえ 門構え"
"かどがわ 門川"
"かどく 可読"
"かどくら 門倉"
"かどぐち 門口"
"かどさき 門崎"
"かどさわ 門澤"
"かどた 角田 門田"
"かどち 角地"
"かどちがい 門違い"
"かどづけ 門付け 門付"
"かどで 門出"
"かどなか 門仲"
"かどなが 門長"
"かどの 門野"
"かどばしら 門柱"
"かどばやし 門林"
"かどばん 角番 カド番"
"かどび 門火"
"かどふだ 門札"
"かどべ 門辺 門部"
"かどべや 角部屋"
"かどま 門真"
"かどまつ 角松 門松"
"かどみせ 角店"
"かどや 門屋 角屋"
"かどわき 門脇"
"かな 假名 華菜 華奈 香奈 佳奈 加奈 金 哉 仮名"
"かなあしのう 金足農"
"かなあみ 金網"
"かない 金井 科内 課内 家内"
"かないけ 金池"
"かないし 金石"
"かないろ 金色"
"かなう 叶"
"かなえ 彜 彝 鬲 香苗 鼎"
"かなおか 金岡"
"かなかな 蜩"
"かなかん 仮名漢 かな漢"
"かながき 金垣 カナ書き"
"かながきろぶん 仮名垣魯文"
"かながた 金型"
"かながわ 金川 神奈川"
"かなきりごえ 金切り声"
"かなぎ 金木 金城"
"かなくぎ 金釘"
"かなくず 金屑"
"かなくそ 金屎"
"かなぐ 金具"
"かなぐさり 金鎖"
"かなぐし 金串"
"かなけ 金気 鉄気"
"かなこ 称子 嘉奈子 佳那子 香奈子 佳奈子 可奈子 加奈子"
"かなさき 金崎"
"かなさし 金指"
"かなざき 加奈崎"
"かなざわ 金澤 金沢"
"かなしき 鉄敷 金敷"
"かなしばり 金縛り"
"かなしま 金島"
"かなしみ 愛しみ 哀しみ 悲しみ"
"かなじょ 仮名序"
"かなた 華薙刀 彼方"
"かなたに 金谷"
"かなだ 片田 金田 加奈陀"
"かなだこく カナダ国"
"かなださん カナダ産"
"かなだじん カナダ人"
"かなだらい 金盥"
"かなちゅう 神奈中"
"かなつじ 金辻"
"かなつぼ 金壺"
"かなつぼまなこ 金壺眼"
"かなづ 金津"
"かなづかい 仮名遣い"
"かなづち 鉄鎚 金鎚 金槌"
"かなてこ 鉄梃"
"かなで 奏で 金出"
"かなでほん 仮名手本"
"かなとこ 鉄床 金床"
"かなとこぐも 鉄床雲"
"かなばち 金鉢"
"かなばん 金版"
"かなぶつ 金仏"
"かなへび 蛇舅母 金蛇"
"かなぼう 鉄棒 金棒"
"かなまじり 仮名混じり かな交じり かな混じり"
"かなまち 金町"
"かなまり 鋺"
"かなまる 金丸"
"かなまるしん 金丸信"
"かなみつ 金光"
"かなむら 金村"
"かなめ 要"
"かなめいし 要石"
"かなめちょう 要町"
"かなもと 金本"
"かなもの 金物"
"かなもり 金森"
"かなや 金屋 金谷"
"かなやま 金山"
"かならず 必らず 必ず"
"かならずしも 必ずしも"
"かならずや 必ずや"
"かなり 金成 可成"
"かなりあいろ カナリア色"
"かなわ 鉄輪"
"かなん 伽南 火難 華南 河南"
"かに 蠏 可児 蟹"
"かにあるき カニ歩き"
"かにえ 蟹江"
"かにく 果肉"
"かにくそ 蟹屎"
"かにこうせん 蟹工船"
"かにざ 蟹座"
"かにせいうん 蟹星雲"
"かにた 蟹田"
"かにたま かに玉 蟹玉"
"かにばさみ 蟹挟み"
"かにみそ 蟹味噌"
"かにもじ 蟹文字"
"かにゅう 加入"
"かにわ 樺"
"かぬき 香貫"
"かぬま 鹿沼"
"かぬまつち 鹿沼土"
"かね 鉄漿 兼 鉦 鐘 金"
"かねあい 兼合 兼合い 兼ね合い"
"かねあまり 金余り"
"かねいがい 金以外"
"かねいし 金石"
"かねいそ 金磯"
"かねおか 兼岡 金岡"
"かねかし 金貸 金貸し"
"かねかんじょう 金勘定"
"かねがさき 金ヶ崎"
"かねがね 兼ね兼ね 予予 予々"
"かねがふち 鐘淵"
"かねきち 兼吉"
"かねきよ 兼清"
"かねくいむし 金食い虫"
"かねぐら 金蔵"
"かねぐり 金繰り"
"かねこ 金児 兼子 金子"
"かねごえ 金肥"
"かねざき 鐘崎 金崎"
"かねざわ 金沢"
"かねしげ 金重"
"かねしたけんせつ 金下建設"
"かねしだい 金次第"
"かねしま 金嶋"
"かねしろちょう 金城町"
"かねじゃく 矩尺 曲尺"
"かねずく 金尽く 金ずく"
"かねぞう 兼蔵"
"かねた 兼太 金田"
"かねたか 兼貴"
"かねたに 金谷"
"かねだ 金田"
"かねだか 金高"
"かねつ 火熱 金津 過熱 加熱"
"かねづか 金塚"
"かねづかい 金使い 金遣い"
"かねづまり 金詰り 金詰まり"
"かねづる 金づる 金蔓"
"かねて 予て"
"かねと 兼人"
"かねなし 金無し"
"かねなり 金成"
"かねはた 金畑"
"かねはま 金浜"
"かねはら 金原"
"かねばこ 金箱"
"かねばなれ 金離れ"
"かねひさ 金久"
"かねひと 兼人"
"かねへん 金偏"
"かねぼう 鐘紡"
"かねまき 鐘巻 金巻"
"かねまち 金町"
"かねまつ 兼松"
"かねまる 金丸"
"かねまわり 金回り"
"かねみつ 金光"
"かねみゆしょう カネミ油症"
"かねめ 金目"
"かねもうけ 金儲け"
"かねもち 金持ち"
"かねもと 金元 兼元 金本"
"かねもり 兼森"
"かねや 金谷"
"かねやま 兼山 金山"
"かねらか カネラ科"
"かねん ヶ年 可燃"
"かねんせいがす 可燃性ガス"
"かの 彼 鹿野 狩野 彼の"
"かのあし 鹿足"
"かのい 鹿井"
"かのう 叶 加能 嘉納 狩野 加納 化膿 可能"
"かのうざん 鹿野山"
"かのうじごろう 嘉納治五郎"
"かのえ 庚"
"かのえいぬ 庚戌"
"かのえうま 庚午"
"かのえさる 庚申"
"かのえたつ 庚辰"
"かのえとら 庚寅"
"かのえね 庚子"
"かのこ 鹿の子"
"かのこうお 鹿の子魚"
"かのこそう 鹿の子草"
"かのこもち 鹿の子餅"
"かのしし 鹿"
"かのじょ 彼女"
"かのじょら 彼女等"
"かのせ 鹿瀬"
"かのと 辛"
"かのとい 辛亥"
"かのとう 辛卯"
"かのとうし 辛丑"
"かのととり 辛酉"
"かのとひつじ 辛未"
"かのとみ 辛巳"
"かのや 鹿屋"
"かのんほう カノン砲"
"かはい 加配"
"かはいじく 下胚軸"
"かはく 下拍 下膊 仮泊"
"かはつ 仮髪"
"かはん 過般 可搬 下半 過半 河畔"
"かはんしん 下半身"
"かば 椛 河馬 蒲 樺"
"かばいだて 庇い立て"
"かばいて 庇い手"
"かばいろ 蒲色 樺色"
"かばさん 加波山"
"かばしま 樺嶋"
"かばしら 蚊柱"
"かばた 椛田"
"かばつ 可罰"
"かばと 樺戸"
"かばね 姓 屍"
"かばねがき 姓書"
"かばのき 樺の木"
"かばのり 樺海苔"
"かばやき 蒲焼き 蒲焼"
"かばやま 樺山"
"かばん 花盤 鞄"
"かばんご 鞄語"
"かばんもち 鞄持ち"
"かひ 下卑 下肥 下皮 下婢 化肥 痂皮 花被 果皮 歌碑 可否"
"かひつ 加筆"
"かひょう 苛評 華表 下表"
"かひん 河浜 佳品"
"かび 黴 華美"
"かびどく 黴毒"
"かびょう 歌病"
"かびん 過敏 花瓶"
"かふ 家扶 花布 家父 寡夫 家譜 下付 寡婦"
"かふう 下風 歌風 荷風 家風"
"かふきゅう 過不及"
"かふく 禍福 下腹"
"かふん 花粉"
"かぶ （株） 歌舞 蕪 下部 株"
"かぶか 株価"
"かぶき 冠木 歌舞伎"
"かぶけん 株券"
"かぶしき 株式"
"かぶしきがいしゃ 株式會社"
"かぶせ 被せ"
"かぶだか 株高"
"かぶだち 株立ち"
"かぶつ 果物"
"かぶと 加太 甲 兜"
"かぶとうお 兜魚"
"かぶとえび 兜海老"
"かぶとがに 兜蟹"
"かぶとちょう 兜町"
"かぶとに 兜煮"
"かぶとのお 兜の緒"
"かぶとむし 兜虫 甲虫"
"かぶとやき 兜焼き"
"かぶとやま 甲山"
"かぶなかま 株仲間"
"かぶぬし 株主"
"かぶばいきゃく 株売却"
"かぶま 株間"
"かぶや 株屋"
"かぶやす 株安"
"かぶら 鏑 蕪"
"かぶらき 鏑木"
"かぶらぎ 鏑木"
"かぶり 頭"
"かぶりつき 齧り付き"
"かぶりもの 被り物"
"かぶれ 気触れ"
"かぶれんじょう 歌舞練場"
"かぶろ 禿"
"かぶわけ 株分け"
"かぶん 可分 寡聞 過分"
"かぶんすう 仮分数"
"かぷせるか カプセル化"
"かへい 貨弊 歌病 寡兵 加平 花柄 貨幣"
"かへいた 嘉平太"
"かへえ 嘉兵衛"
"かへん 佳篇 佳編 カ変 花片 河辺 下辺 可変"
"かべ 可部 壁"
"かべあつ 壁厚"
"かべいた 壁板"
"かべいちめん 壁一面"
"かべかけ 壁掛 壁掛け"
"かべがみ 壁紙"
"かべがわ 壁側"
"かべぎわ 壁際"
"かべこうぞう 壁構造"
"かべごし 壁越し"
"かべざい 壁材"
"かべしき 壁式"
"かべしたじ 壁下地"
"かべしろ 壁代"
"かべしんぶん 壁新聞"
"かべつち 壁土"
"かべどこ 壁床"
"かべぬり 壁塗り"
"かべもと 河部本"
"かべよう 壁用"
"かべりょう 壁量"
"かべん 花弁"
"かほ 香穂 果歩 嘉穂 花穂 花圃"
"かほう 苛法 過褒 加俸 嘉保 家法 火砲 果報 加法 家宝 下方"
"かほうこう 下方向"
"かほく 可北 香北 鹿北 華北 河北"
"かほど 斯程"
"かほり 佳保里"
"かぼう 苛暴"
"かぼく 華墨 家僕 嘉木 佳木 下木 花木"
"かぼちゃ 南瓜"
"かぽじにくしゅ カポジ肉腫"
"かま 罐 窰 釡 竃 蒲 缶 竈 窯 鎌 釜"
"かまあげ 釜揚げ"
"かまあと 窯跡"
"かまい 釜井"
"かまいし 釜石"
"かまいたち 鎌鼬"
"かまいり 釜煎り"
"かまえ 鎌江 釜江 蒲江 構え"
"かまがさき 釜ケ崎"
"かまがた 鎌形"
"かまがや 鎌谷 鎌ヶ谷"
"かまがり 蒲刈"
"かまきり 杜父魚 鎌切 螳螂 蟷螂"
"かまくび 鎌首"
"かまくら 鎌倉"
"かまくらこ 鎌倉湖"
"かまくらぼり 鎌倉彫"
"かまし 釜師"
"かまじゅうもんじ 鎌十文字"
"かまじるし 窯印"
"かます 梭魚 梭子魚 叺"
"かまた 蒲田 鎌田"
"かまたき 缶焚き 釜炊き"
"かまたり 鎌足"
"かまだ 鎌田"
"かまだし 窯出し"
"かまち 蒲地 蒲池 框"
"かまとと 蒲魚"
"かまとり 鎌取"
"かまど 竈 竃"
"かまどがみ 竈神"
"かまはら 鎌原"
"かまば 窯場"
"かまふさ 釜房"
"かまべ 鎌部"
"かまぼこ 蒲鉾"
"かまめ 鴎"
"かまめし 釜飯"
"かまもと 鎌本 釜本 窯元"
"かまやり 鎌槍"
"かまゆで 釜茹で"
"かまわぬ 鎌輪奴"
"かみ 督 長官 髮 帋 祇 可美 香美 加美 佳味 守 上 加味 髪 紙 神"
"かみあげ 髪上げ"
"かみあぶら 髪油"
"かみあらい 髪洗い"
"かみありづき 神在月"
"かみあわせ 噛み合せ 噛み合わせ"
"かみい 神居"
"かみいいざか 上飯坂"
"かみいいだ 上飯田"
"かみいけだい 上池台"
"かみいしづ 上石津"
"かみいしはら 上石原"
"かみいずみ 神泉 上泉"
"かみいそ 上磯"
"かみいた 上板"
"かみいち 上一 上市"
"かみいな 上伊那"
"かみいれ 紙入れ"
"かみいろ 髪色"
"かみうけな 上浮穴"
"かみうま 上馬"
"かみうら 上浦"
"かみえしゅう 上江洲"
"かみお 神尾"
"かみおおおか 上大岡"
"かみおか 上岡 神岡"
"かみおだいえき 上小田井駅"
"かみおぼろ 上尾幌"
"かみおむつ 紙オムツ"
"かみおろし 神降ろし"
"かみかくし 神隠 神隠し"
"かみかざり 髪飾り"
"かみかせだ 上加世田"
"かみかぜ 神風"
"かみかたち 髪形"
"かみかつ 上勝"
"かみかやく 紙火薬"
"かみかわ 神川 上川"
"かみかわち 上河内"
"かみかんむり 髪冠"
"かみがかり 神憑 神懸 神がかり 神憑り 神懸り 神懸かり"
"かみがき 神垣"
"かみがしら 髪頭"
"かみがた 紙型 髪形 上方 髪型"
"かみがみ 神々"
"かみがもじんじゃ 上賀茂神社"
"かみがや 神ケ谷"
"かみき 上期"
"かみきず 咬み傷 噛み傷"
"かみきた 上北"
"かみきたざわ 上北沢"
"かみきり 髪切り"
"かみきりむし 髪切虫 天牛"
"かみきれ 紙切 紙切れ"
"かみぎし 神岸"
"かみぎょう 上京"
"かみぎれ 紙切れ"
"かみぎわ 髪際"
"かみくいしき 上九一色"
"かみくず 紙くず 紙屑"
"かみくち 神口"
"かみくぼ 上窪"
"かみくまもとえきまえ 上熊本駅前"
"かみぐち 上口"
"かみぐみ 上組"
"かみけーす 紙ケース"
"かみこ 紙子 紙衣 神子"
"かみこうす 上口洲"
"かみこうち 上高地"
"かみこしき 上甑"
"かみこっぷ 紙コップ"
"かみこま 上駒"
"かみこんしき 紙婚式"
"かみごうり 上郡"
"かみごおり 上郡"
"かみごとう 上五島"
"かみさいばら 上斉原"
"かみさかえまち 上栄町"
"かみさと 上郷 上里"
"かみさま 神さま 上様 神様"
"かみさん カミさん 上さん"
"かみさんごう 上参郷"
"かみざ 上座"
"かみざき 神崎"
"かみざら 紙皿"
"かみざわ 上澤"
"かみしつ 髪質 紙質"
"かみしばい 紙芝居"
"かみしひ 上志比"
"かみしほうがため 上四方固め"
"かみしほろ 上士幌"
"かみしま 上島"
"かみしも 裃 上下"
"かみしゃちょう 神社長"
"かみしろ 上代 神城 神代"
"かみじま 神島 上島"
"かみじゃけ 紙ジャケ"
"かみじゃけっと 紙ジャケット"
"かみじゅうじょう 上十条"
"かみじょう 神城 上条 上條"
"かみす 神栖"
"かみすき 紙漉き"
"かみすぎ 上杉"
"かみすながわ 上砂川"
"かみすわ 上諏訪"
"かみずもう 紙相撲"
"かみずる 上水流"
"かみせい 紙製"
"かみせっけん 紙石鹸"
"かみぜに 紙銭"
"かみそうやぎ 上草柳"
"かみそり 剃刀"
"かみた 神田 上田"
"かみたいせん 神大戦"
"かみたいら 上平"
"かみたかい 上高井"
"かみたから 上宝"
"かみたばこ 噛みタバコ"
"かみだい 紙代"
"かみだな 神棚"
"かみだのみ 神頼み"
"かみつ 上津 花蜜 過密"
"かみつか 神塚"
"かみつかさ 上司"
"かみつが 上都賀"
"かみつしま 上対馬"
"かみつな 上綱"
"かみつふさ 上総"
"かみつぶて 紙礫"
"かみつるま 上鶴間"
"かみつれか カミツレ花"
"かみづか 神塚"
"かみづかさ 主神"
"かみづつみ 紙包み"
"かみづまり 紙詰まり"
"かみづる 上水流"
"かみて 上手"
"かみてーぷ 紙テープ"
"かみで 上出"
"かみでっぽう 紙鉄砲"
"かみとばぐち 上鳥羽口"
"かみとり 神取"
"かみとんだ 上富田"
"かみどめ 髪留め"
"かみなか 上那賀 上中"
"かみなが 神長 神永 髪長"
"かみなづき 神無月"
"かみなべ 神鍋"
"かみなり 雷"
"かみなりうお 雷魚"
"かみなりおやじ 雷親父"
"かみなりぐも 雷雲"
"かみなりさま 雷様"
"かみなりちゅういほう 雷注意報"
"かみなりもん 雷門"
"かみに 上二"
"かみにいかわ 上新川"
"かみにし 上西"
"かみにんぎょう 紙人形"
"かみぬま 上沼"
"かみねんど 紙粘土"
"かみのかわ 上三川"
"かみのく 上の句"
"かみのくに 上ノ国"
"かみのけ 髪の毛"
"かみのけざ 髪座"
"かみのげ 上野毛"
"かみのこ 神の子"
"かみのせき 上関"
"かみのほ 上之保"
"かみのみや 上の宮"
"かみのやま 上山"
"かみはやし 神林"
"かみはら 神原"
"かみはんき 上半期"
"かみばいたい 紙媒体"
"かみばこ 紙箱"
"かみばやし 上林"
"かみばり 紙貼り 紙張り"
"かみぱっく 紙パック"
"かみぱるぷ 紙パルプ"
"かみひこうき 紙飛行機"
"かみひとえ 紙一重"
"かみふうせん 紙ふうせん 紙風船"
"かみふくおか 上福岡"
"かみふぶき 紙吹雪"
"かみふらの 上富良野"
"かみぶくろ 紙袋"
"かみぶた 紙蓋"
"かみぶんしょ 紙文書"
"かみへい 上閉伊"
"かみほとけ 神仏"
"かみまい 神舞"
"かみまえづ 上前津"
"かみまき 紙巻き 紙巻"
"かみまち 上町"
"かみみず 上水"
"かみみぞ 上溝"
"かみみね 上峰"
"かみむ 上無"
"かみむかえ 神迎え"
"かみむら 神村 上村"
"かみもと 神本"
"かみもの 神物"
"かみや 神屋 上谷 紙屋 神谷"
"かみやいん 紙屋院"
"かみやく 上屋久"
"かみやしき 上屋敷"
"かみやしろ 上社"
"かみやすり 紙鑢"
"かみやどり 神宿り"
"かみやま 上山 神山"
"かみやまだ 上山田"
"かみゆい 髪結 髪結い"
"かみゆいどこ 髪結床 髪結い床"
"かみゆうべつ 上湧別"
"かみよ 神世 神余 神代"
"かみら 韮"
"かみわざ 神技 神業 神事"
"かみん 夏眠 仮眠"
"かみんちゅ 神人"
"かむ 家務"
"かむい 神居"
"かむいこたん 神居古潭"
"かむくら 神座"
"かむだち 麹"
"かむながら 随神"
"かむら 嘉村"
"かむり 冠"
"かむろ 禿"
"かむわざ 神事"
"かめ 龜 日目 甕 瓶 亀"
"かめあり 亀有"
"かめい 亀井 下命 下名 課名 家名 科名 仮名 加盟"
"かめいし 亀石"
"かめいど 亀戸"
"かめいの 亀井野"
"かめうら 亀卜"
"かめお 亀夫"
"かめおか 亀岡"
"かめかん 甕棺"
"かめがた 亀型"
"かめきち 亀吉"
"かめさき 亀崎"
"かめじま 亀島"
"かめじろう 亀次郎"
"かめたろう 亀太郎"
"かめだ 亀田"
"かめの 亀野"
"かめのこ 亀の子"
"かめのこう 亀の甲"
"かめのすけ 亀之助"
"かめぶし 亀節"
"かめまん 亀萬"
"かめむし 亀虫"
"かめや 亀谷 亀屋"
"かめやま 亀山"
"かめやまこ 亀山湖"
"かめらめせん カメラ目線"
"かめれおんざ カメレオン座"
"かめん 下面 仮面"
"かも 鳬 鳧 賀茂 加茂 鴨"
"かもい 鴨井 神威 鴨居"
"かもいけ 鴨池"
"かもう 蒲生"
"かもうり 氈瓜"
"かもえ 鴨江"
"かもえない 神恵内"
"かもがた 鴨方"
"かもがわ 鴨川"
"かもく 課目 寡黙 科目"
"かもくきん 火木金"
"かもくとうりしゅうせい 科目等履修生"
"かもくど 火木土"
"かもぐつ 鴨沓"
"かもしか 羚羊"
"かもした 鴨下"
"かもしだ 鴨志田"
"かもじ 髪文字 母文字 髢"
"かもじま 鴨島"
"かもだ 加守田"
"かもつ 貨物"
"かもつる 賀茂鶴"
"かもづる 賀茂鶴"
"かもと 鹿本"
"かもなくふかもなく 可もなく不可もなく"
"かもなべ 鴨鍋"
"かもなんばん 鴨南蛮"
"かもにく 鴨肉"
"かもねぎ 鴨葱"
"かものちょうめい 鴨長明"
"かものまぶち 賀茂真淵"
"かものみや 鴨宮"
"かもみや 鴨宮"
"かもめ 鴎"
"かもり 掃部"
"かもん 渦紋 下問 家門 花紋 厦門 嘉門 家紋"
"かもんのかみ 掃部頭"
"かや 加耶 栢 加悦 伽耶 榧 茅 萱 蚊帳"
"かやく 可約 加薬 課役 化薬 火薬"
"かやくめし 加薬飯"
"かやぐむ 伽耶琴"
"かやしま 萱嶋 萱島"
"かやつ 彼奴"
"かやつりぐさ 蚊帳吊草"
"かやつりぐさもく カヤツリグサ目"
"かやと 茅戸"
"かやね 茅根"
"かやの 栢野 茅野 萱野"
"かやのみや 賀陽宮"
"かやはら 栢原"
"かやば 茅場"
"かやぶき 茅葺き"
"かやべ 茅部"
"かやま 加山 香山"
"かやもり 萱森"
"かやり 蚊遣り"
"かゆ 糜 粥"
"かゆかん 粥羹"
"かゆみ 痒み"
"かゆみどめ 痒み止め"
"かよ 香代 加代 佳世 嘉代 佳代"
"かよい 通い"
"かよう 仮葉 可容 斯樣 加養 加陽 可溶 花葉 斯様 賀陽 歌謡 火曜"
"かようせい 可用性"
"かよく 寡欲"
"かよこ 夏代子 加世子 佳世子 香代子 加代子 佳代子"
"かよちょう 駕輿丁"
"から → 〜 掛落 伽羅 殼 韓 漢 辛 柄 唐 殻 空"
"からーいんさつ カラー印刷"
"からーえきしょう カラー液晶"
"からーか カラー化"
"からーしゃしん カラー写真"
"からーばん カラー版"
"からーひょうじ カラー表示"
"からあげ 唐揚 から揚げ"
"からあし 空足"
"からあや 唐綾"
"からい 柄井 渦雷 空井 花蕾"
"からいと 唐糸"
"からいばり 空威張り"
"からいも 唐芋 唐薯"
"からいり 乾煎り"
"からうす 碓"
"からうた 唐歌"
"からうま 空馬"
"からうり カラ売り"
"からえ 唐絵"
"からおり 唐織"
"からかさ 唐傘 傘"
"からかさまつ 傘松"
"からかぜ 乾風 空風"
"からかね 唐銅 唐金"
"からかみ 唐紙"
"からかわ 唐川"
"からがし カラ貸し"
"からがら 辛々 辛辛"
"からき 唐木"
"からぎぬ 唐衣"
"からぎょう 空行"
"からくさ 唐草"
"からくさがわら 唐草瓦"
"からくじ 空籤"
"からくだもの 唐菓子"
"からくち 辛口"
"からくら 唐鞍"
"からくり 絡繰り 機関"
"からくれない 韓紅"
"からくわ 唐桑"
"からけん 空券"
"からげいき 空景気"
"からげんき カラ元気"
"からこ 唐子"
"からことば 唐語 韓語"
"からこまげ 唐子髷"
"からこるむ 和林"
"からころも 唐衣"
"からさき 唐崎"
"からさわ 柄沢 唐澤 唐沢"
"からざお 連枷"
"からざけ 乾鮭"
"からし 芥子 辛子"
"からしあえ 芥子和え"
"からしづけ 芥子漬"
"からしな 芥子菜"
"からしま 辛島"
"からしゅっちょう カラ出張"
"からす 香良洲 鴉 烏"
"からすあげは 烏揚羽"
"からすがい 烏貝"
"からすき 唐鋤 犂"
"からすぐち カラス口 烏口"
"からすざ 烏座"
"からすてんぐ 烏天狗"
"からすば 烏羽"
"からすびしゃく 烏柄杓"
"からすま 烏丸"
"からすまる 烏丸"
"からすみ 唐墨"
"からすむぎ カラス麦 烏麦"
"からすやま 烏山"
"からせき 空咳"
"からぜき 空咳"
"からたけ 漢竹 唐竹"
"からたけわり 幹竹割り"
"からたち 枳殻"
"からたに 柄谷"
"からだ 軆 體 躰 躯 身体 体"
"からだき 空焚き"
"からだじたい 体自体"
"からだじゅう 体中"
"からだぜんたい 体全体"
"からだつき 身体つき 体つき 体付き"
"からだづくり 体作り"
"からだのみ 空頼み"
"からちゃ 枯茶 唐茶 空茶"
"からっかぜ からっ風 乾っ風 空っ風"
"からっけつ 空っ穴"
"からっぽ 空っぽ"
"からつ 唐津"
"からつき 殻付き"
"からつきたまご 殻付卵"
"からつば 空唾"
"からつやき 唐津焼"
"からづみ 空積み"
"からづり 空釣"
"からて 空手"
"からてばか 空手バカ"
"からでっぽう 空鉄砲"
"からと 唐櫃"
"からとう 辛党"
"からなし 唐梨"
"からなみだ 空涙"
"からに 空荷"
"からにしき 唐錦"
"からはし 唐橋"
"からばこ 空箱"
"からびん 空瓶"
"からふと 樺太"
"からふとけん 樺太犬"
"からぶき 乾拭き"
"からぶみ 漢書"
"からぶり 空振"
"からぼり 空堀"
"からまーぞふのきょうだい カラマーゾフの兄弟"
"からまつ 落葉松 唐松"
"からまつそうあか カラマツソウ亜科"
"からみ 空身 辛み 辛味 絡み"
"からみそ 辛味噌"
"からみもち 辛味餅"
"からむし 苧 苧麻"
"からめ 辛目 辛め"
"からめて 搦め手 搦手"
"からもの 唐物"
"からものだて 唐物点"
"からもん 唐門"
"からやま 唐山"
"からよう 唐様"
"からん 下欄"
"かり 獵 假 苅 鳫 鴈 猟 刈 借り 狩り 加里 雁 狩 仮"
"かりあげ 刈上げ 刈り上げ 借上げ"
"かりいれ 刈入れ 刈り入れ 借入れ 借入"
"かりうえ 仮植え"
"かりうけ 借受け 借受"
"かりうけきん 仮受金"
"かりうた 仮歌"
"かりうど 猟人 狩人"
"かりうむえん カリウム塩"
"かりえき 仮駅"
"かりおや 仮親"
"かりかえ 借換え 借り換え 借換"
"かりかえさい 借換債"
"かりかた 借方"
"かりかつよう カリ活用"
"かりかぶ 借株 刈株"
"かりがね 雁が音 雁金"
"かりぎ 借着"
"かりぎぬ 狩衣"
"かりくび 雁首"
"かりくら 狩競 狩座"
"かりぐみ 仮組"
"かりこ 雁子"
"かりこし 借り越し 借越"
"かりこみ 苅込 刈込み 刈込 刈り込み"
"かりさかとうげ 雁坂峠"
"かりしっこうのせんげん 仮執行の宣言"
"かりすませい カリスマ性"
"かりすまてき カリスマ的"
"かりずまい 仮住い 仮住まい"
"かりそめ 仮初め 苟且"
"かりた 刈田 苅田"
"かりだ 刈田"
"かりだな 仮棚"
"かりちん 借賃"
"かりっぱなし 借りっ放し"
"かりて 借手"
"かりていも 訶梨帝母"
"かりでん 仮伝"
"かりとり 刈取 刈取り 刈り取り"
"かりどめ 仮止め"
"かりに 仮に"
"かりにはいえん カリニ肺炎"
"かりにも 仮にも"
"かりぬい 仮縫い"
"かりね 仮寝"
"かりはく 仮泊"
"かりば 狩場"
"かりばし 仮橋"
"かりばら 借腹 借り腹"
"かりばらい 仮払"
"かりびと 猟人 狩り人"
"かりぶかい カリブ海"
"かりぶしん 仮普請"
"かりほ 刈穂"
"かりまた 雁股"
"かりめん 仮免"
"かりもがり 殯"
"かりもの 借物"
"かりゃく 下略 嘉暦"
"かりや 借家 借り家 苅屋 狩谷 雁屋 仮屋 刈谷"
"かりやく 仮訳"
"かりやす 刈安"
"かりやど 仮宿"
"かりやま 狩山"
"かりゅう 河流 火竜 渦流 加硫 花柳 顆粒 下流"
"かりゅうど 猟人 狩人"
"かりょう 下僚 科料 加療 過料"
"かりょうびんが 迦陵頻伽"
"かりょく 夏緑 火力"
"かりょくりん 夏緑林"
"かりわ 刈羽"
"かりわく 仮枠"
"かりん 火輪 可憐 花櫚 華鈴 花梨"
"かりんとう 花林糖"
"かる 狩 苅 刈 輕 軽"
"かるい 科類"
"かるいさわ 軽井沢"
"かるいざわ 軽井沢"
"かるいし 軽石"
"かるかや 苅萱 刈萱"
"かるかん 軽羹"
"かるがも 軽鴨"
"かるがる 軽軽 軽々"
"かるくち 軽口"
"かるさ 軽さ"
"かるた 骨牌 歌留多"
"かるでらこ カルデラ湖"
"かるはずみ 軽はずみ"
"かるひと 狩人"
"かるぼきしるき カルボキシル基"
"かるぼんさん カルボン酸"
"かるま 業"
"かるまい 軽米"
"かるみ 軽み"
"かるめ 軽目 軽め"
"かるら 迦楼羅"
"かるわざ 軽業"
"かれ 涸 嗄れ 枯れ 彼"
"かれーあじ カレー味"
"かれーこ カレー粉"
"かれーどん カレー丼"
"かれーなんばん カレー南蛮"
"かれーや カレー屋"
"かれあて 彼宛"
"かれい 遐齢 鰔 家例 佳例 佳麗 嘉例 過冷 家令 餉 鰈 加齢 華麗"
"かれいい 乾飯 餉"
"かれいろ 枯色"
"かれえだ 枯枝"
"かれおばな 枯尾花"
"かれがし 彼某"
"かれがれ 離れ離れ"
"かれがわ 涸れ川"
"かれき 枯木 枯れ木"
"かれくさ 枯れ草"
"かれこれ 彼此"
"かれさわ 涸沢"
"かれさんすい 枯山水"
"かれし 彼氏"
"かれじしん 彼自身"
"かれせんすい 枯れ山水 枯山水"
"かれだに 涸れ谷"
"かれつ 苛烈"
"かれの 枯野"
"かれは 枯れ葉 枯葉"
"かれひとり 彼一人"
"かれら 彼ら 彼等"
"かれん 苛斂 可憐"
"かろ 火炉"
"かろう 家老 過労"
"かろうじて 辛うじて"
"かろきょう 下路橋"
"かろく 嘉禄"
"かろこん 瓜呂根"
"かろとうせん 夏炉冬扇"
"かろやか 軽やか"
"かろん 歌論"
"かわ 巛 側 革 皮 河 川"
"かわあそび 川遊び"
"かわい 可哀 可愛 川相 川井 河井 川合 河合"
"かわいい 可愛い"
"かわいげ 可愛げ"
"かわいそう 可哀想"
"かわいだ 川井田"
"かわいで 河出"
"かわいろ 革色"
"かわうえ 川上"
"かわうお 川魚"
"かわうそ 川獺 獺"
"かわうち 河内 川内"
"かわうら 河浦 川浦"
"かわおと 川音"
"かわおび 革帯"
"かわかぜ 川風"
"かわかつ 川勝"
"かわかみ 河上 川上"
"かわがり 川狩 川狩り"
"かわがわ 川側"
"かわき 渇き 乾き"
"かわきた 河北 川北"
"かわきゅう 川久"
"かわきり 皮切り"
"かわぎし 河岸 川岸"
"かわぎぬ 皮衣 裘"
"かわぎり 川霧"
"かわくぼ 川久保"
"かわくら 川倉"
"かわぐ 革具"
"かわぐち 河口 川口"
"かわぐちこ 河口湖"
"かわぐつ 革沓 皮靴 革靴"
"かわけ 河毛"
"かわげ 河芸"
"かわごえ 川越え 川越"
"かわごけそうもく カワゴケソウ目"
"かわごし 川越し"
"かわごろも 皮衣 裘"
"かわさき 川嵜 河崎 川崎"
"かわさと 川里"
"かわざかな 川魚"
"かわざんよう 皮算用"
"かわしげ 川重"
"かわしま 河嶋 河島 川嶋 川島"
"かわしも 川下"
"かわじ 川治 川路"
"かわじま 川島"
"かわじゃん 革ジャン"
"かわじょうき 川蒸気"
"かわじり 川尻"
"かわすぎ 川杉"
"かわすじ 川筋"
"かわすずみ 川涼み"
"かわすみ 川澄"
"かわず 川津 河津 蛙"
"かわずいくさ 蛙軍"
"かわせ 川背 河瀬 川瀬 為替"
"かわせい 革製"
"かわせいひん 皮製品"
"かわせみ 魚狗 翡 翡翠 川蝉"
"かわせりすく 為替リスク"
"かわせれーと 為替レート"
"かわそう 革装"
"かわそえ 川副"
"かわぞい 河沿 川沿い"
"かわぞえ 河添 川添"
"かわぞこ 河底 川底"
"かわた 河田 川田"
"かわたけ 川竹 河竹"
"かわたな 川棚"
"かわたび 川旅 川渡"
"かわたろう 河太郎"
"かわだ 河田 川田"
"かわだいら 川平"
"かわち 河内"
"かわちや 河内谷"
"かわつ 川津"
"かわつき 皮付き"
"かわづ 川津 河津"
"かわづくり 皮作り"
"かわづはな 川津花"
"かわづら 川面"
"かわづり 川釣り"
"かわてつ 川鉄"
"かわてぶくろ 革手袋 皮手袋"
"かわで 河出"
"かわと 川人"
"かわとう 川東 川藤"
"かわどこ 川床 河床"
"かわな 川奈 川名"
"かわなか 川中"
"かわながれ 川流れ"
"かわなざき 川奈崎"
"かわなべ 川鍋 河鍋 川辺"
"かわなみ 川波"
"かわなり 川成"
"かわにし 河西 川西"
"かわにな 河貝子 川蜷"
"かわぬま 河沼"
"かわね 川根"
"かわねずみ 川鼠"
"かわの 川野 河野"
"かわのえ 川之江"
"かわのかみ 河の神"
"かわのべ 河之邊"
"かわのり 川海苔"
"かわはぎ 皮剥"
"かわはた 河鰭"
"かわはば 川幅"
"かわはま 川浜"
"かわはら 河原 川原"
"かわば 川場"
"かわばた 川幡 河鰭 河端 川畑 川端"
"かわばり 皮張り 革張り"
"かわぱん 革パン"
"かわひがし 河東 川東"
"かわひと 川人"
"かわひも 皮紐 革紐"
"かわひら 川平"
"かわびょうし 革表紙"
"かわびらき 川開き"
"かわふく 川副 川福"
"かわふじ 川藤"
"かわぶくろ 革袋 皮袋"
"かわぶち 川淵"
"かわぶね 川舟 川船"
"かわべ 川連 河邊 川邉 河部 川邊 川部 河辺 川辺"
"かわべり 川縁"
"かわほね 河骨"
"かわほり 蝙蝠"
"かわまえちょう 川前町"
"かわます 河鱒"
"かわまた 川股 川又 川俣"
"かわみ 川見"
"かわみなみ 川南"
"かわみや 河宮"
"かわむかい 川向い 川向かい"
"かわむき 皮剥き"
"かわむこう 川向こう 川向う"
"かわむら 河村 川村"
"かわも 川面"
"かわもと 川元 河本 川本"
"かわもり 川森 川守"
"かわや 廁 厠"
"かわやなぎ 川柳"
"かわゆおんせん 川湯温泉"
"かわゆか 川床"
"かわよう 川用 革用"
"かわよけ 川除"
"かわよろい 革鎧"
"かわら 磧 香春 川原 河原 瓦"
"かわらい 河原井"
"かわらがはま 瓦ケ浜"
"かわらがま 瓦窯"
"かわらけ 土器"
"かわらざき 河原崎"
"かわらし 瓦師"
"かわらせんべい 瓦煎餅"
"かわらたけ 瓦茸"
"かわらだ 河原田"
"かわらばん かわら版 瓦版"
"かわらふじ 河原藤"
"かわらぶき 瓦葺 瓦葺き"
"かわらべい 瓦塀"
"かわらや 瓦屋"
"かわらやき 瓦焼き 瓦焼"
"かわらやね 瓦屋根"
"かわり 替り 替わり 代り 変り 変わり 代わり"
"かわりだね 変わり種"
"かわりばえ 代わり映え"
"かわりばんこ 代り番こ 代わり番こ"
"かわりびな 変り雛 変わり雛"
"かわりみ 変り身 変わり身"
"かわりやく 代役"
"かわるがわる 代る代る 代わる代わる"
"かわわ 川和"
"かわわせん 河和線"
"かわん 下腕"
"かん 潤 康 關 卷 啣 舘 神 鰥 豢 蒄 莟 艱 羮 羹 盥 淦 戡 宦 厂 丱 甲 桓 侃 堪 涵 凾 函 瀚 翰 陷 陥 皖 莞 煥 渙 喚 換 奐 繝 澗 嫻 嫺 簡 揀 柬 諌 諫 轗 緘 撼 憾 鹹 喊 咸 罕 竿 澣 幹 駻 稈 桿 捍 悍 旱 骭 杆 扞 奸 肝 汗 干 酣 邯 篏 疳 鉗 拑 箝 嵌 坩 柑 甘 瞰 橄 敢 鸛 驩 讙 懽 浣 潅 灌 鑵 罐 觀 勸 勧 歡 歓 歛 款 坎 寰 鐶 還 環 樌 慣 貫 鑒 鑑 艦 監 姦 寛 看 患 緩 乾 寒 槓 閑 関 癇 燗 刊 韓 漢 棺 菅 管 館 官 冠 完 巻 観 感 間 勘 缶"
"かんあく 奸悪"
"かんあけ 寒明け"
"かんあつ 缶圧 感圧"
"かんあみ 観阿弥"
"かんあん 勘案"
"かんい 簡意 換位 寛衣 官医 敢為 漢医 冠位 官位 簡易"
"かんいしょく 肝移植"
"かんいち 乾一 貫一"
"かんいといれ 簡易トイレ"
"かんいほけんほーる 簡易保険ホール"
"かんいり 缶入"
"かんいん 完飲 官印 官員 館員 姦淫"
"かんう 寒雨 甘雨 冠羽 換羽 関羽"
"かんうていそうしょ 甘雨亭叢書"
"かんうん 閑雲"
"かんえい 完泳 官営 寛永"
"かんえいにち 漢英日"
"かんえつ 簡閲 観閲 関越"
"かんえん 寛延 肝炎"
"かんおう 観応 陥凹 観桜 感応"
"かんおけ 棺桶"
"かんおん 幹音 感恩 感温 感音 漢音"
"かんおんじ 観音寺"
"かんか 旱戈 柑果 轗軻 鰥寡 坩堝 乾果 干戈 閑暇 換価 管下 看過 感化"
"かんかい 勧戒 感懐 緩解 官界 寛解"
"かんかいかんちょう 管海官庁"
"かんかいん 感化院"
"かんかく 　 看客 間隔 感覚"
"かんかつ 奸黠 管割 寛闊 管轄"
"かんかん 灌灌 汗簡 感官 閑々 寛々"
"かんかんがくがく 侃侃諤諤 侃々諤々"
"かんかんしき 観艦式"
"かんかんでり かんかん照り"
"かんが 漢画 閑雅 官衙"
"かんがい 潅がい 潅漑 寒害 干害 管外 館外 灌漑 感慨"
"かんがえ 考え"
"かんがく 侃諤 関学 勧学 漢学 管楽 官学"
"かんがくいん 勧学院"
"かんがっき 管楽器"
"かんがん 肝ガン 肝がん 汗顔 宦官 肝癌"
"かんき 官紀 官記 寒期 勘気 刊記 乾期 乾季 間期 寒気 歓喜 喚起 換気"
"かんきこう 換気孔"
"かんきせん 換気扇"
"かんきち 乾吉"
"かんきつ 柑橘"
"かんきのう 肝機能"
"かんきゃく 閑却 観客"
"かんきゅう 感泣 官給 緩急"
"かんきょ 官許 閑居"
"かんきょう 寒郷 乾薑 干姜 漢鏡 喚叫 緩頬 感興 艦橋 環境"
"かんきょうこう 環境光"
"かんきょうせん 関京戦"
"かんきょうほるもん 環境ホルモン"
"かんきょく 寒極"
"かんきん 官金 看経 桿菌 換金 監禁"
"かんぎ 寛喜"
"かんぎく 観菊 寒菊"
"かんぎてん 歓喜天"
"かんぎゅうじゅうとう 汗牛充棟"
"かんぎょ 鹹魚 乾魚 干魚 還御"
"かんぎょう 鑑行 寒行 勧業 官業"
"かんぎん 感吟 閑吟 勧銀"
"かんく 寒苦 艱苦 甘苦 管区"
"かんくう 管腔 関空"
"かんくろう 官九郎"
"かんぐり 勘繰り"
"かんぐん 官軍"
"かんけ 菅家"
"かんけい 還啓 簡勁 換刑 寛刑 環形 姦計 奸計 関係"
"かんけいあり 関係有"
"かんけいしょかんちょう 関係諸官庁"
"かんけつ 間歇 観血 間欠 簡潔 完結"
"かんけつせん 間欠泉"
"かんけつば 汗血馬"
"かんけん 換券 官権 管見 官憲"
"かんげ 勧化"
"かんげい 歓迎"
"かんげいこ 寒稽古"
"かんげき 間隙 観劇 感激"
"かんげざい 緩下剤"
"かんげつ 寒月 観月"
"かんげん 諌言 寛元 管絃 諫言 甘言 換言 管弦 還元"
"かんげんえん 還元焔"
"かんげんがく 管弦楽"
"かんげんとう 還元糖"
"かんこ 鹹湖 喚呼 歓呼"
"かんこーひー 缶コーヒー"
"かんこう 刊稿 勧降 甘汞 箝口 還向 寛厚 勘考 桓公 艦攻 寛弘 緘口 款項 漢口 漢江 緩行 完工 官公 感光 慣行 敢行 刊行 観光"
"かんこうざい 環孔材"
"かんこうじゅ 官公需"
"かんこうせい 緩効性"
"かんこうば 勧工場"
"かんこうばい 寒紅梅 緩勾配"
"かんこうばす 観光バス"
"かんこうびざ 観光ビザ"
"かんこうへん 肝硬変"
"かんこうりつびょういん 官公立病院"
"かんこうろう 官公労"
"かんこく 官刻 寒国 勧告 韓国"
"かんこつ 顴骨 寛骨"
"かんこつきゅう 寛骨臼"
"かんこつだったい 換骨奪胎"
"かんこどり かんこ鳥 閑古鳥"
"かんこぴ 完コピ"
"かんこん 冠婚"
"かんご 款語 歓娯 閑語 韓語 監護 漢語 看護"
"かんごう 冠号 勘合 嵌合 巻号"
"かんごうしゅうらく 環濠集落"
"かんごえ 寒肥"
"かんごく 監獄"
"かんごふ 看護夫 看護婦"
"かんごりん 漢語林"
"かんさ 鑑査 間差 感作 監査"
"かんさい 艦載 寛斎 簡裁 完済 関西"
"かんさいけん 関西圈"
"かんさいば 関西馬"
"かんさいぺいんと 関西ペイント"
"かんさいぼう 幹細胞"
"かんさく 姦策 奸策 間作"
"かんさくめい 関作命"
"かんさつ 鑑札 監察 観察"
"かんさついん 監察院"
"かんさん 甘酸 閑散 換算"
"かんざい 寒剤 管財"
"かんざき 神埼 神崎"
"かんざけ 燗酒"
"かんざし 簪"
"かんざぶろう 勘三郎"
"かんざまし 燗冷まし"
"かんざらし 寒晒し"
"かんざん 換算"
"かんざんじ 舘山寺"
"かんざんじっとく 寒山拾得"
"かんし 敢死 諫死 諫止 環視 幹枝 官司 管子 干支 看視 鉗子 冠詞 漢詩 監視"
"かんしかめら 監視カメラ"
"かんしき 環式 鑑識 乾式"
"かんしききょう 漢式鏡"
"かんししょう 監視哨"
"かんしち 環七"
"かんしつ 乾漆 乾湿 間質"
"かんしつせいはいえん 間質性肺炎"
"かんして 関して"
"かんしぼう 肝脂肪"
"かんしゃ 甘蔗 患者 檻車 官社 観者 官舎 感謝"
"かんしゃく 疳積 官爵 癇癪"
"かんしゃくだま かんしゃく玉 癇癪玉"
"かんしゃめん 緩斜面"
"かんしゅ 凾手 函手 感取 観取 緩手 肝腫 関手 巻首 監守 艦種 艦首 看取 看守"
"かんしゅう 甘州 観衆 慣習 監修"
"かんしゅく 甘粛"
"かんしょ 甘薯 甘蔗 寒暑 漢書 官署"
"かんしょう 簡捷 癇性 勧賞 感賞 冠賞 冠称 観象 官省 冠省 寛正 観照 管掌 環礁 緩衝 勧奨 完勝 感傷 干渉 観賞 鑑賞"
"かんしょうぎょ 観賞魚"
"かんしょうじま 干渉縞"
"かんしょく 寒食 閑職 間色 寒色 官職 完食 間食 感触"
"かんしょとう 甘蔗糖"
"かんしん 姦臣 甘心 寒心 感震 奸臣 歓心 汗疹 感心 関心"
"かんしんじ 関心事"
"かんしんせい 完新世"
"かんじ 完児 冠辞 換字 官寺 完治 完爾 莞爾 寛治 感じ 監事 幹事 漢字"
"かんじき 橇"
"かんじぎょう 閑事業"
"かんじこーど 漢字コード"
"かんじざい 観自在"
"かんじだしょう カンジダ症"
"かんじつげつ 閑日月"
"かんじどりる 漢字ドリル"
"かんじゃ 観者 間者 冠者 患者"
"かんじゃく 閑寂"
"かんじゅ 官需 貫首 貫主 感受 甘受"
"かんじゅーす 缶ジュース"
"かんじゅうしき 間充織"
"かんじゅく 慣熟 完熟"
"かんじゅん 間順"
"かんじょ 感書 閑所 寛恕 緩徐 官女 漢書"
"かんじょう 感状 冠状 完乗 灌頂 管状 艦上 勧請 環状 勘定 感情"
"かんじょうか 管状花"
"かんじょうたい 桿状体"
"かんじょうみゃく 冠静脈"
"かんじょうれっせき 環状列石"
"かんじん 韓人 漢人 寛仁 閑人 勧進 官人 肝腎 肝心"
"かんじんかなめ 肝心要"
"かんすい 漢水 鹹水 潅水 灌水 冠水 完遂"
"かんすいきんぞく 関水金属"
"かんすいぎょ 鹹水魚 寒水魚"
"かんすいせき 寒水石"
"かんすう 函數 函数 巻数 関数"
"かんすうかん 関数環"
"かんすうじ 漢数字"
"かんすぼん 巻子本"
"かんする 関する"
"かんず 貫首 貫主"
"かんせい 関西 乾生 感声 監製 喊声 甘井 甘精 喚声 間性 官制 陥穽 乾性 官製 寛政 慣性 管制 閑静 歓声 感性 完成"
"かんせいてんそる 慣性テンソル"
"かんせいとう 管制塔"
"かんせいのかいかく 寛政の改革"
"かんせいめい 官姓名"
"かんせいもーめんと 慣性モーメント"
"かんせき 寛晰 艦籍 漢籍"
"かんせつ 環節 官設 冠雪 間接 関節"
"かんせつきょう 関節鏡"
"かんせつきょうしか 関節鏡視下"
"かんせん 官撰 官選 艦戦 乾癬 汗腺 艦船 幹線 観戦 感染"
"かんぜ 観世"
"かんぜい 勧説 関税"
"かんぜいじょうきょ 関税譲許"
"かんぜつ 冠絶"
"かんぜん 煥然 間然 敢然 勧善 完全"
"かんぜんか 完全花"
"かんぜんに 完全に"
"かんそ 簡素"
"かんそう 間想 閑窓 完奏 観相 観想 乾草 歓送 換装 間奏 完走 乾燥 感想"
"かんそうげい 歓送迎"
"かんそうこ 乾倉庫"
"かんそうらん 乾燥卵"
"かんそく 管束 患側 緩速 観測"
"かんそん 寒村"
"かんそんみんぴ 官尊民卑"
"かんぞう 鑑三 甘草 肝臓"
"かんぞういろ 萱草色"
"かんぞうがん 肝臓ガン 肝臓がん 肝臓癌"
"かんぞく 姦賊 奸賊 漢族"
"かんた 幹太"
"かんたい 鑑隊 冠体 款待 緩怠 冠帯 桿体 艦体 簡体 寒帯 歓待 艦隊"
"かんたく 乾拓 干拓"
"かんたろう 勘太郎"
"かんたん 簡短 簡單 感歎 邯鄲 肝胆 感嘆 簡単"
"かんだ 関田 苅田 神田"
"かんだい 棺台 漢代 関大 寛大"
"かんだか 甲高"
"かんだち 神立"
"かんだつ 神立"
"かんだまつり 神田祭"
"かんだん 閑談 間断 寒暖 歓談"
"かんち 姦智 奸知 閑地 奸智 官治 監置 寒地 換地 関知 完治 感知"
"かんちがい 勘違い"
"かんちく 漢竹 寒竹 患畜"
"かんちつ 巻帙"
"かんちばん 感知板"
"かんちゃく 緩着"
"かんちゃん 嵌張"
"かんちゅう 冠注 勘注 管中 寒中"
"かんちょう 勧懲 官長 灌頂 間諜 完調 管長 干潮 浣腸 艦長 官庁 館長"
"かんつ 槓子"
"かんつい 完遂"
"かんつう 姦通 貫通"
"かんつうとびら 貫通扉"
"かんつばき 寒椿"
"かんづかさ 主神"
"かんづくり 寒造り"
"かんづめ 罐詰 缶詰"
"かんてい 勘亭 艦艇 官邸 鑑定"
"かんていしょく 艦底色"
"かんてき 看的 観的"
"かんてくすとせい 間テクスト性"
"かんてつ 官鉄 肝蛭 関鉄 完徹 貫徹"
"かんてん 官展 旱天 干天 寒天 観点"
"かんてんきち 歓天喜地"
"かんてんのじう 干天の慈雨"
"かんてんぼうき 観天望気"
"かんでん 乾田 関電 感電"
"かんでんち 乾電池"
"かんと 官途"
"かんとう 冠頭 完答 竿灯 間道 敢闘 竿頭 完投 巻頭 関東"
"かんとうい 貫頭衣"
"かんとういち 関東一"
"かんとうからー 巻頭カラー"
"かんとうぐん 關東軍"
"かんとうげん 巻頭言"
"かんとうし 間投詞"
"かんとうじょし 間投助詞"
"かんとうだき 関東炊き"
"かんとうば 関東馬"
"かんとうろーむ 関東ローム"
"かんとく 寛徳 感得 監督"
"かんとくえん 関特演"
"かんとん 嵌頓 広東"
"かんとんご 廣東語"
"かんとんめん 広東麺"
"かんど 神戸 感度"
"かんどう 貫道 官道 間道 完動 勘当 感動"
"かんどうみゃく 肝動脈 冠動脈"
"かんどうもの 感動モノ"
"かんどころ 勘所"
"かんどっく 乾ドック"
"かんどり 神取"
"かんな 寛和 鉋"
"かんない 幹内 艦内 関内 管内 館内"
"かんながら 随神"
"かんなぎ 覡 巫"
"かんなくず 鉋屑"
"かんなぜん 看話禅"
"かんなづき 神無月"
"かんなな 環七"
"かんなべ 神辺"
"かんなみ 函南"
"かんなめさい 神嘗祭"
"かんなり 金成"
"かんなん 患難 艱難"
"かんにち 韓日"
"かんにゅう 観入 嵌入 陥入 貫入"
"かんにょ 官女"
"かんにょう 凵繞"
"かんにん 寛仁 官人 堪忍"
"かんにんぶくろ 堪忍袋"
"かんぬき 貫木 閂"
"かんぬし 神主"
"かんねい 姦佞 奸佞"
"かんねつ 乾熱 感熱"
"かんねん 観念"
"かんの 冠野 管野 神野 菅野"
"かんのう 感能 肝脳 還納 間脳 完納 感応 官能"
"かんのき 閂"
"かんのすが 管野スガ"
"かんのむし 疳の虫"
"かんのん 観音"
"かんのんぎょう 観音経"
"かんのんざき 観音崎"
"かんのんちく 観音竹"
"かんはっしゅう 関八州"
"かんはつ 間髪"
"かんば 燗場 駻馬 汗馬 悍馬 樺"
"かんばい 観梅 寒梅 完売"
"かんばいこ 寒梅粉"
"かんばく 艦爆"
"かんばせ 顔"
"かんばっじ 缶バッジ"
"かんばつ 簡抜 干魃 旱魃 間伐"
"かんばのろう 汗馬の労"
"かんばめい 冠馬名"
"かんばやし 神林 上林"
"かんばら 神原 蒲原"
"かんばん 燗番 乾板 看板"
"かんばんむすめ 看板娘"
"かんぱ 看破 寒波"
"かんぱい 完敗 乾杯"
"かんぱく 関白"
"かんぱけ 完パケ"
"かんぱち 間八 環八"
"かんぱつ 渙発 煥発 間髪"
"かんぱん 干犯 乾板 乾パン 甲板"
"かんび 完美 巻尾 艦尾 甘美 完備"
"かんびーる 缶ビール"
"かんびょう 看病"
"かんびん 簡便"
"かんぴ 乾皮 官費 韓非"
"かんぴしょう 柑皮症"
"かんぴょう 乾瓢 干瓢 鑑評"
"かんぴょうき 間氷期"
"かんふー 功夫"
"かんふぜん 肝不全"
"かんふるちゅうしゃ カンフル注射"
"かんぶ 官武 患部 幹部"
"かんぶくろ 紙袋"
"かんぶつ 干物 奸物 観仏 灌仏 換物 官物 乾物"
"かんぶつえ 潅仏会"
"かんぶり 寒鰤 寒ブリ"
"かんぶりあき カンブリア紀"
"かんぶん 寛文 漢文"
"かんぷ 姦夫 姦婦 官府 関釜 乾布 完膚 還付"
"かんぷう 寒風 完封"
"かんぷうかい 観楓会"
"かんぷうざん 寒風山"
"かんぷく 官服 感服"
"かんぷん 感奮"
"かんべ 神部 神戸"
"かんべえ 勘兵衛"
"かんべつ 鑑別"
"かんべに 寒紅"
"かんべん 簡便 勘弁"
"かんぺい 干貝 勘平 寛平"
"かんぺいしき 観兵式"
"かんぺいしゃ 官幣社"
"かんぺき 完ぺき 癇癖 完璧"
"かんぺん 官辺"
"かんぼう 姦謀 奸謀 冠帽 監房 感冒 観望 官房"
"かんぼく 翰墨 潅木 灌木"
"かんぼじあ 柬蒲寨"
"かんぼつ 陥没"
"かんぽ 簡保"
"かんぽう 咸豐 汗疱 観法 艦砲 寛保 館報 官報 漢方"
"かんぽうのまじわり 管鮑の交わり"
"かんぽん 韓本 監本 官本 完本 刊本"
"かんまき 上牧"
"かんまく 間膜"
"かんまつ 巻末"
"かんまん 干満 緩慢"
"かんみ 寛美 鹹味 甘味"
"かんみどころ 甘味処"
"かんみゃく 間脈"
"かんみょう 漢名"
"かんみん 官民"
"かんみんぞく 漢民族"
"かんむ 官務 桓武"
"かんむり 冠"
"かんむりざ 冠座"
"かんむりょう 感無量"
"かんめ 貫目"
"かんめい 官命 漢名 艦名 官名 簡明 感銘"
"かんめん 管面 乾麺"
"かんもう 冠毛 換毛"
"かんもく 緘黙"
"かんもじ 閑文字"
"かんもち 寒餅"
"かんもん 環紋 喚問 関門"
"かんもんきょう 関門橋"
"かんもんじ 閑文字"
"かんや 寒夜"
"かんやく 漢薬 簡約 漢訳 完訳 監訳"
"かんやどり 神宿り"
"かんゆ 換喩 肝油"
"かんゆう 姦雄 奸雄 官有 勧誘"
"かんゆうりん 官有林"
"かんよ 干与 関与"
"かんよう 簡要 観洋 咸陽 漢陽 官窯 間葉 観葉 官用 慣用 涵養 肝要 寛容"
"かんようよみ 慣用読"
"かんら 甘楽"
"かんらい 寒雷"
"かんらく 乾酪 歓楽 陥落"
"かんらん 觀覽 橄欖 甘藍 観覧"
"かんらんがん 橄欖岩"
"かんらんざん 橄欖山"
"かんり 官吏 監理 管理"
"かんりがえ 管理換"
"かんりがかり 管理掛"
"かんりこすと 管理コスト"
"かんりさいと 管理サイト"
"かんりつ 官立"
"かんりのーど 管理ノード"
"かんりぽすと 監理ポスト"
"かんりゃく 簡略"
"かんりゅう 緩流 潅流 乾溜 環流 寒流 貫流 還流 韓流"
"かんりょう 管領 官僚 完了"
"かんりん 寒林 官林 翰林"
"かんりんまる 咸臨丸"
"かんるい 感涙"
"かんれい 艦齢 管領 寒冷 慣例"
"かんれいしゃ 寒冷紗"
"かんれき 官歴 還暦"
"かんれきいわい 還暦祝"
"かんれん 關聯 関連"
"かんれんづけ 関連付"
"かんろ 寒露 管路 甘露"
"かんろく 環六 勘六 貫禄"
"かんろくじしょ 干禄字書"
"かんわ 官話 閑話 漢和 緩和"
"かんわきゅうだい 閑話休題"
"かんわざ 神事"
"かんわざまい 神事舞"
"が ケ 畫 訛 河 果 衙 瓦 雅 臥 訝 呀 芽 牙 鵝 鵞 莪 娥 哦 餓 峩 峨 俄 駕 賀 伽 ヶ ヵ 蛾 我 画"
"がーどした ガード下"
"がい 既 愾 礙 碍 盖 葢 蓋 艾 乂 睚 啀 涯 崕 崖 駭 孩 垓 骸 該 咳 劾 亥 磑 皚 剴 鎧 凱 漑 概 慨 買い 賀意 我意 甲斐 階 街 外 害"
"がいあく 害悪"
"がいあつ 外圧"
"がいい 外囲 害意 外衣"
"がいいん 外印 外陰 外因"
"がいうちゅう 外宇宙"
"がいえん 外炎 外薗 外園 外延 外縁 外苑"
"がいえんひがしどおり 外苑東通り"
"がいか 蓋果 外化 凱歌 外貨"
"がいかい 外海 外界"
"がいかく 外廓 外殻 外角 外郭"
"がいかさい 外貨債"
"がいかつ 概括"
"がいかひ 外果皮"
"がいかん 外患 外環 概観 外観"
"がいがい 皚々"
"がいがんきん 外眼筋"
"がいき 外気"
"がいきおん 外気温"
"がいきゃく 外客"
"がいきゅう 鎧球"
"がいきょ 街渠"
"がいきょう 外筐 外教 概況"
"がいきょく 外局"
"がいきん 外勤"
"がいきんこん 外菌根"
"がいぎょ 害魚"
"がいく 街衢 街区"
"がいくうかん 外空間"
"がいけい 外傾 概形 外径 外形"
"がいけん 外圏 外見"
"がいげん 概言"
"がいげんご 外言語"
"がいこう 外寇 外項 外港 外向 外光 外構 外交"
"がいこうせん 外航船"
"がいこうるい 外肛類"
"がいこきゅう 外呼吸"
"がいこく 外国"
"がいこくさい 外国債"
"がいこくさんば 外国産馬"
"がいこくば 外国馬"
"がいこっかく 外骨格"
"がいこつ 蓋骨 外骨 骸骨"
"がいこん 外婚"
"がいご 外語"
"がいごう 外合"
"がいごうないじゅう 外剛内柔"
"がいさい 外債"
"がいさん 概算"
"がいざい 外材 外在"
"がいし 芥子 外姉 外使 外紙 外史 碍子 外資"
"がいして 概して"
"がいしゃ 害者 会社 外車"
"がいしゅう 鎧袖 外周"
"がいしゅういっしょく 鎧袖一触"
"がいしゅうき 概周期"
"がいしゅっけつ 外出血"
"がいしゅつ 外出"
"がいしょ 外書"
"がいしょう 外渉 街娼 外商 外傷 外相"
"がいしょく 外食"
"がいしん 害心 外申 外心 外信"
"がいじ 孩児 外耳 外事 外字"
"がいじつせい 概日性"
"がいじつりずむ 概日リズム"
"がいじゅ 外需"
"がいじゅう 害獣"
"がいじゅうないごう 外柔内剛"
"がいじょう 街上"
"がいじん 外陣 外人"
"がいじんおんな 外人女"
"がいすう 概数"
"がいず 概図"
"がいせい 慨世 蓋世 外声 外征 外生"
"がいせいき 外性器"
"がいせき 外戚 外積"
"がいせつ 外接 概説"
"がいせん 街宣 外線 凱旋"
"がいぜん 慨然 蓋然"
"がいそう 外層 外挿 咳嗽 外装"
"がいそく 概則 外足 外側"
"がいそくど 外測度"
"がいそふ 外祖父"
"がいそぼ 外祖母"
"がいそん 外孫"
"がいたい 外帯"
"がいため 外為"
"がいたれ 外タレ"
"がいたん 慨歎 外端 慨嘆"
"がいだ 咳唾"
"がいだい 外大"
"がいだて 階建て 階建"
"がいだん 街談"
"がいち 外地"
"がいちゅう 外注 害虫"
"がいちょう 外朝 害鳥"
"がいちょうどう 外聴道"
"がいてき 外敵 外的"
"がいてん 外点 外典 外転"
"がいでん 外電 外伝"
"がいとう 街燈 外灯 外套 街灯 街頭 該当"
"がいとうまく 外套膜"
"がいどう 外道"
"がいどく 害毒"
"がいねん 外燃 概念"
"がいはいよう 外胚葉"
"がいはおん 外破音"
"がいはく 駭魄 該博 外泊"
"がいはつてき 外発的"
"がいはん 外板 外販"
"がいはんぼし 外反拇指 外反拇趾 外反母趾"
"がいばつてき 外罰的"
"がいばん 外盤"
"がいひ 外被 外皮"
"がいひょう 概評"
"がいひん 外賓"
"がいびぶん 外微分"
"がいふうしゃ 凱風社"
"がいぶ 外侮 外部"
"がいぶつ 外物"
"がいぶん 外聞 外分"
"がいぶんぴつ 外分泌"
"がいへき 外壁"
"がいへきあつ 外壁厚"
"がいへん 外篇 外編"
"がいほう 概包 外報"
"がいぼう 外貌"
"がいまい 外米"
"がいむ 外務"
"がいめん 外面"
"がいもう 外毛"
"がいもん 外門"
"がいや 外野"
"がいゆう 外憂 外遊"
"がいよう 艾葉 外葉 外洋 外用 概要"
"がいようぎょ 外洋魚"
"がいようづ 概要図"
"がいらい 外来"
"がいらいぎょ 外来魚"
"がいらん 外乱"
"がいりゃく 概略"
"がいりょく 外力"
"がいりん 外輪"
"がいりんざん 外輪山"
"がいろ 街路"
"がいろじゅ 街路樹"
"がいろん 概論"
"がいわくせい 外惑星"
"がいわん 蓋碗"
"がいん 画因 雅音 画院"
"がう 號"
"がうすぶんぷ ガウス分布"
"がえ 換"
"がえし 返し"
"がえり 帰り"
"がえん 賀宴"
"がお 顏 顔"
"がおう 画王"
"がおか ヶ丘"
"がおんしつ 画音質"
"がか 画架 雅歌 画家"
"がかい 雅懐 画会 瓦解"
"がかく 畫角 画角"
"がかり 掛 係"
"がが 峨峨 峨々"
"ががく 画学 雅楽"
"ががくりょう 雅楽寮"
"ががっき 雅楽器"
"ががんぼ 大蚊"
"がき 書き 瓦器 垣 餓鬼"
"がきだな 餓鬼棚"
"がきょう 画境"
"がぎ 画技"
"がぎじょうぶ 鉤状部"
"がぎょ 駕御"
"がぎょう が行 ガ行 画業"
"がく 樂 斈 學 壑 鰐 鍔 諤 齶 鄂 愕 咢 嶽 岳 顎 萼 楽 学 額"
"がくあじさい 額紫陽花"
"がくい 学位"
"がくいり 額入り"
"がくいん 楽員 学院"
"がくえん 学園"
"がくおん 楽音"
"がくかんせつ 顎関節"
"がくがい 学外"
"がくきょうかい 学協会"
"がくぎょ 鰐魚"
"がくぎょう 学業"
"がくぐん 学群"
"がくげい 学芸"
"がくげき 楽劇"
"がくこつ 顎骨"
"がくさい 楽才 学才 学祭 学際"
"がくさん 学参"
"がくざら 額皿"
"がくし 楽師 学資 学士"
"がくしいん 学士院"
"がくしき 学指揮 楽式 学識"
"がくしゃ 学舎 学者"
"がくしゅ 楽手"
"がくしゅう 学修 学習"
"がくしゅうあるごりずむ 学習アルゴリズム"
"がくしゅういん 学習院"
"がくしゅうさいくる 学習サイクル"
"がくしゅうさんぷる 学習サンプル"
"がくしゅうづくえ 学習机"
"がくしょ 楽書 楽所"
"がくしょう 楽匠 学匠 学生 楽章"
"がくしょく 学殖 学食"
"がくしん 学術審議会 学術振興会 学振"
"がくじ 学事"
"がくじゅつ 学術"
"がくじょう 学術情報センター 学情"
"がくじん 楽人"
"がくせい 楽聖 学制 学生"
"がくせいかばん 学生鞄"
"がくせいむき 学生向"
"がくせいりょう 学生寮"
"がくせき 学籍"
"がくせつ 楽節 学説"
"がくぜん 愕然"
"がくそ 楽所"
"がくそう 学聡 楽箏 学窓 楽想 学僧 額装"
"がくそく 学則"
"がくそつ 学卒"
"がくたい 楽隊"
"がくだいこ 楽太鼓"
"がくだん 楽壇 楽団"
"がくち 学知"
"がくちょう 楽調 楽長 学長"
"がくてき 学的"
"がくてん 楽典"
"がくでん 学田"
"がくと 学都 学徒"
"がくとう 咢筒 学統 学頭"
"がくとく 学徳"
"がくどう 額堂 学道 楽堂 学堂 学童"
"がくない 学内"
"がくにん 楽人 学人"
"がくねん 学年"
"がくの 嶽野"
"がくのはな 額の花"
"がくは 楽派 学派"
"がくばす 学バス"
"がくばつ 学閥"
"がくひ 岳飛 学費"
"がくびわ 楽琵琶"
"がくふ 岳父 学府 楽譜"
"がくふう 学風"
"がくぶ 学部"
"がくぶち 額縁"
"がくへん がく片 萼片"
"がくほう 学報"
"がくぼう 学帽"
"がくぼく 学僕"
"がくむ 学務"
"がくめい 学名"
"がくめん 楽面 額面"
"がくめんわれ 額面割れ"
"がくもん 学問"
"がくもんのじゆう 学問の自由"
"がくもんのすすめ 学問のすゝめ"
"がくや 嶽野 楽屋"
"がくゆう 学友"
"がくゆうきょうかい 楽友協会"
"がくよう 岳陽"
"がくようひん 学用品"
"がくらん 学らん 学ラン"
"がくり 楽理 学理"
"がくりょう 学寮"
"がくりょく 学力"
"がくるい 学類"
"がくれい 学齢"
"がくれき 学歴"
"がくれん 学連"
"がくろく 岳麓"
"がくわり 学割"
"がけ 垳 掛け 崖"
"がけい 芽型 雅兄"
"がけくずれ 崖崩れ"
"がけした 崖下"
"がけっぷち 崖っ淵 崖っ縁"
"がけん 我見"
"がげき 画劇"
"がげん 雅言"
"がこう 画稿 画工"
"がこうそう 鵞口瘡"
"がご 雅語"
"がごう 雅号"
"がさ 笠 傘"
"がさい 画才"
"がさいれ ガサ入れ"
"がさくちゅう 画策中"
"がさん 臥蚕 画讃 画賛"
"がさんび 臥蚕眉"
"がざい 画材"
"がし 菓子 樫 画紙 画師 賀詞 餓死"
"がしつ 画室 画質"
"がしゅ 画趣 雅趣"
"がしゅう 賀州 我執 画集"
"がしゅん 賀春"
"がしょ 賀書"
"がしょう 雅称 臥床 画商 賀正"
"がしら 頭"
"がしんしょうたん 臥薪嘗胆"
"がじゅん 雅馴"
"がじょう 芽条 画帖 賀状 牙城"
"がじょえんかんこう 雅叙園観光"
"がじん 牙人 画人 雅人"
"がじんかって 我侭勝手"
"がす 瓦斯"
"がすあっせつ ガス圧接"
"がすあつ ガス圧"
"がすえそ ガス壊疽"
"がすか ガス化"
"がすかくさん ガス拡散"
"がすかん ガス管"
"がすがいしゃ ガス会社"
"がすがま ガス釜"
"がすきき ガス機器"
"がすきぐ ガス器具"
"がすけつ ガス欠"
"がすしき ガス式"
"がすしつ ガス室"
"がすじゅう ガス銃"
"がすじょう ガス状"
"がすせん ガス栓"
"がすだい ガス台 ガス代"
"がすだん ガス弾"
"がすちゅうどく ガス中毒"
"がすでん ガス田"
"がすとう ガス燈 ガス灯"
"がすぬき ガス抜き"
"がすばくはつ ガス爆発"
"がすぶろ ガス風呂"
"がすぶんせき ガス分析"
"がすもれ ガス漏れ"
"がすようせつ ガス溶接"
"がすりょうきん ガス料金"
"がすろ ガス炉"
"がせい 画聖"
"がせき 瓦石"
"がせつ 我説"
"がせんし 画仙紙"
"がぜん 瓦全 俄然"
"がそ 画素"
"がそう 芽層 我相 画僧 画層"
"がそりんしゃ ガソリン車"
"がそりんぜい ガソリン税"
"がそりんだい ガソリン代"
"がぞう 画像"
"がぞく 雅俗"
"がた 難 潟 形 型 方"
"がたおち がた落ち"
"がたこう 型鋼 形鋼"
"がたさ 難さ"
"がたな 刀"
"がたり 語り"
"がだい 画題"
"がだん 画壇"
"がち 勝ち 雅致"
"がちしょう 賀知章"
"がちょう 鵝鳥 画帳 鵞鳥 画調"
"がちりん 月輪"
"がっ 合"
"がっか 学課 学科"
"がっかい 楽界 学界 学会"
"がっかせん 顎下腺"
"がっかぜんきょういん 学科全教員"
"がっかん 楽官 学監 学環 学館"
"がっき 学期 楽器"
"がっきずき 楽器好き"
"がっきゅう 学究 学級"
"がっきゅうき 学休期"
"がっきょく 楽曲"
"がっく 楽句 学区"
"がっくうてんし 月宮天子"
"がっけい 学兄 学系"
"がっけん 学研"
"がっこう 學校 学校"
"がっこうちゅう 顎口虫"
"がっこつ 顎骨"
"がっさい 合切 合財"
"がっさいぶくろ 合切袋"
"がっさく 合作"
"がっさつ 合冊"
"がっさん 月山 合算"
"がっしゅう 合衆"
"がっしゅく 合宿"
"がっしょう 合従 合焦 合掌 合唱"
"がっせい 合生"
"がっせん 合戦"
"がっそう 合葬 合奏"
"がったい 合體 合体"
"がっち 合致"
"がっちゃく 合着"
"がって 勝手"
"がってつ 合綴"
"がってん 合點 月天 合点"
"がっとげん ガット弦"
"がっぴ 月日"
"がっぴつ 合筆"
"がっぴょう 合評"
"がっぺい 合併"
"がっぽう 合邦"
"がっぽん 合本"
"がつ 歹 月"
"がつお 鰹"
"がつころ 月頃"
"がつごう 月号"
"がつすえ 月末"
"がつちゅう 月中"
"がつど 月度"
"がつばん 月版"
"がつぶん 月分"
"がつへん 歹偏"
"がつまつ 月末"
"がてん 合点"
"がでんいんすい 我田引水"
"がと 賀戸 画図"
"がとう 臥榻 餓島"
"がな 仮名"
"がに 蟹"
"がにまた がに股 ガニ股 蟹股"
"がにゅうどう 我入道"
"がね 鐘 金"
"がはく 画伯"
"がばん 画板"
"がひつ 画筆"
"がひん 訝賓"
"がび 峨眉 蛾眉"
"がびょう 臥病 画鋲"
"がふ 楽府 画譜 画布"
"がふう 画風"
"がふく 画幅"
"がぶのみ ガブ飲み がぶ飲み"
"がぶん 雅文"
"がへい 画餅"
"がべい 画餅"
"がぺん 鵞ペン"
"がほ 牙保"
"がほう 芽胞 画法 画報"
"がぼう 画舫"
"がま 蝦蟆 蝦蟇 鎌 窯 釜 蟇 蒲"
"がまがえる 蝦蟇"
"がまぐち がま口"
"がまごうり 蒲郡"
"がまごおり 蒲郡"
"がまもく ガマ目"
"がまん 我慢"
"がまんくらべ 我慢比べ"
"がみ 髮 上 神 紙 髪 雅味"
"がむしゃら 我武者羅"
"がめい 雅名 画名"
"がめん 画面"
"がめんさいず 画面サイズ"
"がめんはし 画面端"
"がめんみぎ 画面右"
"がも 賀茂"
"がもう 蒲生"
"がもん 衙門"
"がゆう 雅遊"
"がよい 通い"
"がようし 画用紙"
"がよく 我欲"
"がら 瓦落 殻 柄"
"がらあき ガラ空き がら空き"
"がらあわせ 柄合せ 柄合わせ"
"がらがらへび がらがら蛇 ガラガラ蛇"
"がらく 雅楽"
"がらくたぶんこ 我楽多文庫"
"がらす 鴉 烏 硝子"
"がらすいた ガラス板"
"がらすえ ガラス絵"
"がらすかん ガラス管"
"がらすき がら空き"
"がらすこうげい ガラス工芸"
"がらすごし ガラス越し"
"がらすざら ガラス皿"
"がらすしつ ガラス質"
"がらすせい ガラス製"
"がらすせんい ガラス繊維"
"がらすたい ガラス体"
"がらすだま ガラス玉"
"がらすど 硝子戸 ガラス戸"
"がらすばり ガラス張り"
"がらすびん 硝子瓶 ガラス瓶"
"がらすまど 硝子窓 ガラス窓"
"がらすめん ガラス綿 ガラス面"
"がらすよう ガラス用"
"がらっと ガラっと"
"がらみ 搦み"
"がらもの 柄物"
"がらん 伽藍"
"がらんじん 伽藍神"
"がり 我利"
"がりばん がり版 ガリ版"
"がりべん ガリ勉"
"がりゅう 画竜 我流"
"がりょう 画料 雅量 画竜 臥竜"
"がりょうてんせい 画龍点睛"
"がりょく 画力"
"がりれいへんかん ガリレイ変換"
"がりん 芽鱗"
"がれーせん ガレー船"
"がれき 瓦礫"
"がろう 餓狼 画廊"
"がろん 画論"
"がわ 巛 革 皮 河 川 側"
"がわいた 側板"
"がわら 河原 瓦"
"がわり 代わり"
"がん 貫 嚴 厳 頷 含 阮 元 翫 玩 鳫 鴈 偐 贋 龕 眼 岸 丸 巖 巌 嵒 岩 顏 顔 頑 雁 癌 願"
"がんあつ 眼圧"
"がんい ⊃ 願意 含意"
"がんいりょう 癌医療"
"がんえん 顔淵 岩塩"
"がんか ガン化 がん化 癌化 眼窩 眼下 眼科"
"がんかい 顔回 眼界 岩塊"
"がんかけ 願掛け"
"がんきゅう 眼球"
"がんきょう 頑強 眼鏡"
"がんきん 眼筋 元金"
"がんぎ 雁木"
"がんぎょう 元慶"
"がんくつ 岩窟 巌窟"
"がんくび 雁首"
"がんぐ 頑愚 玩具"
"がんぐばこ 玩具箱"
"がんけい 眼径 眼形"
"がんけん 癌研 頑健 眼瞼"
"がんけんしん がん検診 ガン検診 癌検診"
"がんこ 頑固"
"がんこう 眼孔 雁行 眼光"
"がんこうしゅてい 眼高手低"
"がんさ 眼差"
"がんさい 岩滓"
"がんさいぼう ガン細胞 がん細胞 癌細胞"
"がんさく 贋作"
"がんさつ 贋札"
"がんざい 丸剤"
"がんし 眼視"
"がんしき 眼識"
"がんしつ 眼疾"
"がんしぼう 癌死亡"
"がんしゃ 顔射"
"がんしゅ 癌腫 願主"
"がんしゅう 含羞"
"がんしょ 雁書 願書"
"がんしょう 翫賞 岩漿 岩床 岩礁"
"がんしょく 顔色"
"がんしん 眼振"
"がんじ 雁字 元治"
"がんじがらめ 雁字搦め"
"がんじつ 元日"
"がんじょう 頑丈"
"がんじろう 鴈治郎"
"がんじん 鑑真"
"がんすい 含水"
"がんせい 眼睛 眼精"
"がんせき 岩石"
"がんせん 頑癬"
"がんぜ 頑是"
"がんぜん 眼前"
"がんそ 元祖"
"がんそう 含嗽"
"がんぞう 贋造"
"がんたい 眼帯"
"がんたろう 巌太郎"
"がんたん 元旦"
"がんだい 岩大"
"がんだて 願立て"
"がんだれ 雁垂 厂"
"がんちく 含蓄"
"がんちゅう 眼中"
"がんちょう 元朝"
"がんちりょう ガン治療 がん治療 癌治療"
"がんつう 眼痛"
"がんてい 眼底"
"がんとくせん 岩徳線"
"がんどう 龕灯"
"がんどうがえし 強盗返し"
"がんねん 元年"
"がんのすけ 雁之助"
"がんばり 頑張り"
"がんばん 岩盤"
"がんぱい 眼杯"
"がんぱく 雁帛"
"がんびょう 眼病"
"がんぴ 雁皮"
"がんぶつ 玩物 贋物"
"がんぶつそうし 玩物喪志"
"がんぷく 眼福"
"がんぺい 贋幣 眼柄"
"がんぺき 巌壁 岩壁 岸壁"
"がんほけん ガン保険 癌保険"
"がんぼう 眼房 顔貌 願望"
"がんぽん 元本"
"がんま Γ γ"
"がんません ガンマ線 γ線"
"がんみ 含味 玩味"
"がんみつとう 含蜜糖"
"がんめい 頑冥 頑迷"
"がんめいふれい 頑冥不霊"
"がんめん 顔面"
"がんもう 願望"
"がんもく 眼目"
"がんもどき 雁擬き"
"がんもん 雁門 願文"
"がんやく 丸薬"
"がんゆ 含油"
"がんゆう 含有"
"がんよう 顔容"
"がんよくせい がん抑制 癌抑制"
"がんよぼう ガン予防 癌予防"
"がんらい 元来"
"がんり 元利"
"がんりき 願力 眼力"
"がんりゅうじま 巌流島"
"がんりょう 含量 顔料"
"がんりょく 眼力"
"がんれつ 雁列"
"がんろう 玩弄"
"き 猗 倚 聞 歸 皈 徠 來 噐 酒 城 姫 馗 逵 譏 覬 虧 麾 榿 枳 暉 悸 屓 喟 卉 祁 徽 綺 畸 掎 嵜 崎 竒 剞 碕 寄 驥 冀 麒 騏 稘 祺 淇 朞 箕 其 碁 棊 棋 欹 欷 晞 唏 稀 希 禧 熹 憙 僖 嬉 喜 氣 气 愾 汽 跂 岐 妓 伎 饋 瞶 櫃 匱 覊 羈 羇 熈 煕 熙 肌 机 几 飢 饑 畿 幾 燬 毀 毅 曁 旡 跪 詭 鰭 耆 龜 亀 槻 窺 餽 愧 諱 幃 癸 揆 揮 輝 弃 棄 圻 祈 杞 起 己 企 帰 軌 規 既 季 紀 騎 来 着 危 旗 貴 鬼 生 忌 基 機 器 期 記 奇 樹 黄 木 気"
"きー Χ χ"
"きーきょく キー局"
"きーせん 妓生"
"きーち キー値"
"きーるん 基隆"
"きあ 騎亜"
"きあい 木藍 気合い 気合"
"きあけ 忌明け"
"きあたり 気当たり"
"きあつ 気圧"
"きあん 机案 几案 起案"
"きい 城井 忌諱 貴意 奇異 紀伊"
"きいたふう 利いた風"
"きいち 喜市 輝一 喜一"
"きいちご 木莓 木苺"
"きいちばいいち 帰一倍一"
"きいちほう 帰一法"
"きいちほうげん 鬼一法眼"
"きいっぽん 生一本"
"きいつ 帰一"
"きいと 生糸"
"きいとん 喜頓"
"きいれ 喜入"
"きいろ 黄色"
"きいん 気韻 基因 棋院 起因"
"きう 喜雨 祈雨 気宇"
"きうえ 木植"
"きうえはら 木上原"
"きうけ 気受け"
"きうち 木内"
"きうつ 気鬱"
"きうつり 季移り 気移り"
"きうま 木馬"
"きうら 木裏 木浦"
"きうん 気運 機運"
"きえ 消え 気恵 帰依"
"きえい 帰営 機影 気鋭"
"きえき 気液"
"きえこ 喜恵子"
"きえつ 喜悦"
"きえん 気焔 気炎 奇縁 機縁"
"きおい 紀尾井 気負い"
"きおう 棋王 既往"
"きおうじんじゃ 鬼王神社"
"きおく 記憶"
"きおくくらす 記憶クラス"
"きおくぼ 記憶薄"
"きおくれ 気遅れ 気後れ"
"きおち 気落 気落ち"
"きおも 気重"
"きおもて 木表"
"きおん 気音 基音 気温"
"きか 貴課 季夏 奇禍 机下 旗下 奇貨 貴下 貴家 麾下 気化 帰化 幾何"
"きかい 毀壊 棋界 気塊 貴会 喜界 奇怪 器械 機会 機械"
"きかいあぶら 機械油"
"きかいあみ 機械編み"
"きかいいん 既会員"
"きかいけん 機械研究所"
"きかいぱるぷ 機械パルプ"
"きかく 企劃 規格 企画"
"きかくぶづけ 企画部付"
"きかげき 喜歌劇"
"きかた 着方"
"きかつ 飢渇"
"きかでーた 幾何データ"
"きかわ 木川"
"きかん 饋還 貴簡 器管 貴艦 汽罐 亀鑑 帰館 帰艦 貴官 奇観 軌間 旗艦 気管 既刊 季刊 器官 帰還 基幹 機関 期間"
"きかんき 利かん気"
"きかんし 気管支"
"きかんしきょう 気管支鏡"
"きかんじゅう 機関銃"
"きかんぼう 利かん坊 聞かん坊"
"きが 帰臥 起臥 気賀 飢餓"
"きがい 気愾 気概 危害"
"きがいしゅうしゅく 期外収縮"
"きがえ 着替 着替え"
"きがかり 気がかり 気掛り 気掛かり"
"きがく 貴学 器楽"
"きがしら 木頭"
"きがす 木ガス 希ガス"
"きがた 木方 木型"
"きがね 気兼 気兼ね"
"きがまえ 気構え"
"きがみ 生紙"
"きがらちゃ 黄枯茶"
"きがる 気軽"
"きがわ 木川"
"きがん 奇岩 祈願"
"きき 暉暉 奇鰭 諱忌 記旗 奇気 騏驥 起期 汽機 喜気 飢鬼 帰期 奇奇 窺基 効き 輝輝 気気 喜々 嬉嬉 忌諱 毀棄 記紀 器機 嬉々 鬼気 危機 機器"
"ききあし 利き足"
"ききあわせ 聞合せ"
"ききうで 利腕 利き腕"
"ききおう 騏鬼翁"
"ききおさめ 聞き納め"
"ききおぼえ 聞き覚え"
"ききかいかい 奇奇怪怪 奇々怪々"
"ききかた 聞き方"
"ききがき 聞書き 聞き書き 聞書"
"きききりん 樹木希林"
"ききこみ 聞き込み"
"ききごこち 聞き心地"
"ききごたえ 聞き応え"
"ききざけ 利酒 利き酒"
"ききしょ 聞書"
"ききじょうず 聞き上手"
"ききすて 聞き捨て"
"ききずて 聞き捨て"
"ききせまる 鬼気迫る"
"ききちがえ 聞き違え"
"ききつたえ 聞き伝え"
"ききて 利き手 聴き手 聞き手"
"ききとり 聴取り 聞取り 聴き取り 聞き取り"
"ききどころ 利き所 聞き所 聴き所"
"ききべた 聞き下手"
"ききまちがい 聞き間違い"
"ききみみ 利き耳 聞耳 聞き耳"
"ききみょうみょう 奇々妙々 奇奇妙妙"
"ききめ 效 利目 効目 利き目"
"ききもの 聴きもの 聞き物"
"ききゃく 棄却"
"ききゃくるい 鰭脚類"
"ききやく 聞き役"
"ききゅう 冀求 企及 帰休 危急 希求 気球"
"ききょ 起居 寄居"
"ききょう 帰敬 棄教 奇矯 気胸 帰京 帰郷 桔梗"
"ききょうもく キキョウ目"
"ききょく 枳棘 鰭棘 棊局 棋局 危局 器局 貴局"
"ききょらい 帰去来"
"ききよう 聞き様"
"ききわけ 聞分け 聞き分け"
"ききん 饑饉 寄金 飢饉 基金"
"きぎ 気気 嬉戯 機宜 樹々 木々"
"きぎく 黄菊"
"きぎけん 機技研"
"きぎしつ 基技室"
"きぎぬ 生絹"
"きぎょ 綺語"
"きぎょう 起行 鬼形 機業 起業 企業"
"きぎょうようざいさん 企業用財産"
"きぎれ 木切れ"
"きく 掬 鞠 鞫 椈 危懼 崎嶇 起句 規矩 菊"
"きくあな 菊穴"
"きくあわせ 菊合わせ 菊合せ"
"きくい 喜久井"
"きくいし 菊石"
"きくいずみ 喜久泉"
"きくいただき 菊戴"
"きくいちもんじ 菊一文字"
"きくいも 菊芋"
"きくえい 菊栄"
"きくお 紀久男 菊男 菊雄 喜久男 喜久雄"
"きくおか 菊岡"
"きくか 菊鹿 キク科 菊科"
"きくかせき 菊花石"
"きくかもん 菊花紋"
"きくかわ 掬川 菊川"
"きくがわ 菊川"
"きくこ 起久子 貴久子 菊子 喜久子"
"きくごろう 菊五郎"
"きくさと 喜久里"
"きくざ 菊座"
"きくざけ 菊酒"
"きくじ 喜久治"
"きくじゅんじょう 規矩準縄"
"きくじん 麹塵"
"きくすい 菊水"
"きくず 木屑"
"きくずみ 菊炭"
"きくぞう 木久蔵"
"きくた 菊田"
"きくち 菊地 菊池"
"きくちかん 菊池寛"
"きくちよ 菊千代"
"きくづき 菊月"
"きくづくり 菊作り"
"きくとうだい 菊灯台"
"きくな 菊菜 菊名"
"きくならく 聞くならく"
"きくに 喜国"
"きくにんぎょう 菊人形"
"きくね 菊音"
"きくの 菊野"
"きくのすけ 菊之助"
"きくのはな 菊の花"
"きくのり 菊海苔"
"きくはら 菊原"
"きくばり 気くばり 気配り"
"きくばん 菊判"
"きくひめ 菊姫"
"きくびし 菊菱"
"きくま 菊間"
"きくまさ 菊政"
"きくまさむね 菊政宗"
"きくみ 菊見"
"きくみみ 聞く耳"
"きくもく キク目"
"きくもん 菊門"
"きくや 菊屋"
"きくゆうかい 菊友会"
"きくよう 菊陽"
"きくらげ 木耳"
"きくん 貴君"
"きぐ 危ぐ 機具 危惧 器具"
"きぐう 寄寓 奇遇"
"きぐすり 生薬"
"きぐち 木口"
"きぐつ 木靴"
"きぐみ 気組み 木組み"
"きぐらい 気位"
"きぐるみ 着ぐるみ"
"きぐろう 気苦労"
"きけい 畸計 畸型 奇計 詭計 奇景 畸形 貴兄 奇形"
"きけいぎょ 奇形魚"
"きけいしき 木形式"
"きけつ 既決 帰結"
"きけつしゅう 既決囚"
"きけもの 利け者"
"きけん 貴顕 気圏 棄権 危険"
"きげき 喜劇"
"きげきつい 機撃墜"
"きげつ 亀月 虧月"
"きげん 奇言 危言 奇幻 紀元 機嫌 起源 期限"
"きげんぎれ 期限切 期限切れ"
"きこ 紀子 旗鼓 騎虎"
"きこう 奇巧 奇功 希覯 奇効 騎甲 寄航 機巧 起稿 帰航 稀覯 季候 騎行 貴校 貴公 気孔 機甲 帰港 奇行 機工 起工 気功 寄港 寄稿 気候 紀行 機構"
"きこうしすてむ 気候システム"
"きこうしすてむけんきゅうせんたー 気候システム研究センター"
"きこうせんたー 気候センター"
"きこうぞう 木構造"
"きこうでん 乞巧奠"
"きこうりょうへい 機甲猟兵"
"きこえ 聞え 聞こえ"
"きこえよがし 聞こえよがし"
"きこく 枳穀 鬼哭 貴国 帰国"
"きこし 木越"
"きこつ 奇骨 気骨"
"きこない 木古内"
"きこなし 着こなし"
"きこり 樵夫 樵"
"きこん 機根 気根 既婚"
"きご 基語 寄語 奇語 綺語 木子 季語"
"きごう ＿ ￣ ー 〇 ｜ ’ ‘ ！ ？ ； ： ・ ． ， 。 、 ＆ ％ ＄ ￥ 〜 ＼ ／ ＠ ＊ ＃ ＞ ＜ ＝ − ＋ 】 【 』 『 」 「 》 《 〉 〈 ｝ ｛ ］ ［ 〕 〔 ） （ ± ÷ × ∫ ∵ ∴ ≫ ≪ ≧ ≦ ≠ ≒ ≡ ⌒ ∠ ∽ ∝ ∞ ¬ ∨ ∧ ∩ ∪ ＾ ¨ ｀ ´ ” “ ゜ ゛ 々 仝 〃 ゞ ゝ ヾ ヽ ↓ ↑ ← → ▼ ▽ ▲ △ ◆ ◇ ■ □ ◎ ● ○ ★ ☆ ♭ ♯ ♪ Ц ‰ Å ‡ † ¶ § £ ¢ ″ ′ ° ℃ 〒 ※ ♀ ♂ ‖ ‐ — 〓 ‥ … ヶ 〆 揮毫 記号"
"きごうもーど 記号モード"
"きごころ 気心"
"きごし 木越"
"きさ 吉舎 蚶"
"きさい 既済 騎西 奇祭 奇才 鬼才 起債 記載"
"きさいち 私市"
"きさかた 象潟"
"きさかぶんきてん 木坂分岐点"
"きさき 気先 妃 后"
"きさく 詭策 既作 喜作 奇策 気さく"
"きさご 細螺"
"きささげ 楸"
"きさつ 貴札"
"きさぬき 木佐貫"
"きさぶろう 喜三郎"
"きさま 貴様"
"きさらぎ 更衣 衣更着 如月"
"きさらづ 木更津"
"きさわ 木沢"
"きさん 帰参 帰山 起算"
"きさんじ 気散じ"
"きざ 刻 跪坐 起坐 気障"
"きざい 器財 基剤 器材 機材"
"きざき 稀崎 木崎"
"きざきこ 木崎湖"
"きざくら 黄桜"
"きざけ 生酒"
"きざさ 季笹"
"きざし 萌 兆 兆し"
"きざはし 階"
"きざみ 刻 刻み"
"きざみあし 刻み足"
"きざら 木皿"
"きざわり 気障り"
"きざんかん 機山館"
"きし 来住 愧死 奇士 気死 貴志 起死 貴紙 貴誌 旗幟 棋士 騎士 岸"
"きしかたゆくすえ 来し方行く末"
"きしかわ 貴志川"
"きしかん 既弛緩 既視感"
"きしがみ 岸上"
"きしけいこ 岸恵子"
"きしじま 岸島"
"きしたに 岸谷"
"きしだ 岸田"
"きしつ 気室 器質 基質 気質"
"きしね 岸根"
"きしの 岸野"
"きしば 岸場"
"きしべ 岸部 岸辺"
"きしぼじん 鬼子母神"
"きしま 杵島"
"きしみ 軋み"
"きしめん 棊子麺"
"きしもじん 鬼子母神"
"きしもと 岸本"
"きしゃ 騎射 喜捨 帰社 貴社 汽車 記者"
"きしゃく 稀釈 希釈"
"きしゃくらぶ 記者クラブ"
"きしやじま 岸屋島"
"きしゅ 起首 鬼手 期種 奇手 貴種 気腫 寄主 期首 機首 旗手 騎手 機種"
"きしゅう 羇愁 奇臭 箕帚 貴酬 既収 季秋 奇習 既習 貴州 紀州 奇襲"
"きしゅういぬ 紀州犬"
"きしゅううめ 紀州梅"
"きしゅうてん 起終点"
"きしゅく 耆宿 鬼宿 岐宿 寄宿"
"きしゅくしゃ 寄宿舎"
"きしゅつ 既出"
"きしゅへん 機種変"
"きしゅん 季春"
"きしょ 貴書 希書 稀書 寄書 奇書 貴所 期初"
"きしょう 氣象 毀傷 旗章 起請 奇勝 徽章 記章 気性 稀少 希少 起床 気象"
"きしょうてんけつ 起承転結"
"きしょうてんごう 起承転合"
"きしょうなん 気性難"
"きしょうぼり 起請彫り"
"きしょく 旗色 寄食 喜色 貴職 機織 気色"
"きしり 軋り"
"きしろ 木城"
"きしわだ 岸和田"
"きしん 忌辰 帰心 貴紳 貴信 紀信 寄進 鬼神"
"きしんせん 姫神線"
"きしんへいだん 機神兵団"
"きじ 素地 奇事 棄児 木地 雉 生地 記事"
"きじく 機軸 基軸"
"きじつ 枳実 記実 忌日 期日"
"きじばと 雉鳩"
"きじま 木嶋 貴島 木島"
"きじまだいら 木島平"
"きじもと 雉本"
"きじゃく 着尺"
"きじゃくし 木杓子"
"きじゅ 耆儒 喜寿"
"きじゅう 帰住 帰従 器什 寄住 騎銃 奇獣 機銃"
"きじゅうき 起重機"
"きじゅつ 既述 奇術 記述"
"きじゅん 帰順 規準 基準"
"きじょ 貴女 鬼女 機序"
"きじょう 騎上 木城 軌条 気丈 機上 机上 騎乗"
"きじょうのくうろん 机上の空論"
"きじょうば 騎乗馬"
"きじょうぶ 気丈夫"
"きじょうゆ 生醤油"
"きじるし き印 キ印"
"きじん 畸人 貴人 奇人 鬼神"
"きじんぶ 基人部"
"きす 木須 鱚"
"きすい 気水 既遂 汽水"
"きすいこ 汽水湖"
"きすう 機数 帰趨 基数 奇数"
"きすうほう 記数法"
"きすが 貴家"
"きすき 木次"
"きすぎ 来生"
"きすみ 木栖"
"きず 痍 岐津 生酢 木酢 疵 瑕 傷"
"きずあと 傷痕 傷跡"
"きずい 気随 奇瑞"
"きずいしょう 黄水晶"
"きずいせん 黄水仙"
"きずかい 気遣い"
"きずき 杵築"
"きずきがみ 生漉紙"
"きずくり 木造"
"きずぐすり 傷薬"
"きずぐち 傷口"
"きずな 紲 絆"
"きずもの 疵物 傷物"
"きせ 吉瀬 木瀬 黄瀬"
"きせい 棋勢 祈誓 規整 紀勢 期生 規正 期成 気勢 棋聖 既製 奇声 寄生 既成 帰省 規制"
"きせいこん 寄生根"
"きせいじゅう 寄生獣"
"きせいちゅう 寄生虫"
"きせいらっしゅ 帰省ラッシュ"
"きせかえにんぎょう 着せ替え人形"
"きせき 寄迹 棋石 帰籍 貴戚 基石 碁石 鬼籍 帰責 奇石 輝石 貴石 奇蹟 軌跡 奇跡"
"きせせん 紀勢線"
"きせつ 気節 奇説 既設 季節"
"きせる 煙管"
"きせん 帰仙 帰船 帰線 黄線 機船 機先 貴賤 棋戦 基線 汽船"
"きせんいでん 帰先遺伝"
"きぜつ 奇絶 気絶"
"きぜわ 生世話"
"きぜん 喟然 毅然"
"きそ 稀疎 木祖 木曾 木曽 起訴 基礎"
"きそう 竸 貴僧 吉左右 寄贈 帰巣 基層 奇想 気相 起草"
"きそうかん 気送管"
"きそがため 基礎固め"
"きそく 羈束 気息 規則"
"きそこまこうげん 木曽駒高原"
"きそざき 木曾岬"
"きそたに 木曽谷"
"きそだに 木曽谷"
"きそつ 既卒"
"きそば 生蕎麦"
"きそぶし 木曾節"
"きそん 帰村 毀損 既存"
"きぞう 寄蔵 寄贈"
"きぞく 貴族 帰属"
"きぞくいん 貴族院"
"きぞん 既存"
"きた 喜田 木田 喜多 北"
"きたあいき 北相木"
"きたあいづ 北会津"
"きたあきた 北秋田"
"きたあげお 北上尾"
"きたあずみ 北安曇"
"きたあだち 北足立"
"きたあまべ 北海部"
"きたあめりか 北アメリカ"
"きたあやせ 北綾瀬"
"きたありま 北有馬"
"きたい 鬼胎 奇胎 奇体 奇態 危殆 基体 北井 稀代 気体 機体 期待"
"きたいずみ 北泉"
"きたいたみ 北伊丹"
"きたいちがらす 北一硝子"
"きたいっき 北一輝"
"きたいば 期待馬"
"きたいばらき 北茨城"
"きたいばらぎし 北茨城市"
"きたいぼ 期待薄"
"きたうおぬま 北魚沼"
"きたうち 北内"
"きたうら 北浦"
"きたうらわ 北浦和"
"きたうわ 北宇和"
"きたえ 鍛え"
"きたえき 北駅"
"きたえだ 北枝"
"きたお 北尾"
"きたおおさか 北大阪"
"きたおおじ 北大路"
"きたおおつか 北大塚"
"きたおか 北岡"
"きたおかざき 北岡崎"
"きたおく 北奥"
"きたおね 北尾根"
"きたおり 北折"
"きたかいがん 北海岸"
"きたかいきせん 北回帰線"
"きたかしま 北鹿島"
"きたかすかべ 北春日部"
"きたかぜ 北風"
"きたかた 北方"
"きたかたらーめん 喜多方ラーメン"
"きたかちどき 北勝閧"
"きたかつしか 北葛飾"
"きたかつらぎ 北葛城"
"きたかべ 北壁"
"きたかまくら 北鎌倉"
"きたかみ 北上"
"きたかるいざわ 北軽井沢"
"きたかわ 北川"
"きたかわち 北河内"
"きたかん 北館"
"きたかんとう 北関東"
"きたかんばら 北蒲原"
"きたがき 北垣"
"きたがた 北方"
"きたがわ 北河 北川 北側"
"きたきつね 北狐"
"きたきゅうしゅう 北九州"
"きたきりすずめ 着た切り雀"
"きたきんき 北近畿"
"きたく 貴宅 北区 寄託 帰宅"
"きたくりはま 北久里浜"
"きたくわだ 北桑田"
"きたぐち 北口"
"きたぐに 北国"
"きたぐんま 北群馬"
"きたけ 木竹 着丈"
"きたこう 北港"
"きたこうじ 北小路"
"きたこし 北越"
"きたこま 北巨摩"
"きたこまつ 北小松"
"きたごう 北郷"
"きたさいたま 北埼玉"
"きたさく 北佐久"
"きたさわとうげ 北沢峠"
"きたざと 北里"
"きたざわ 北澤 北沢"
"きたしおばら 北塩原"
"きたしが 北志賀"
"きたしたら 北設楽"
"きたしながわえき 北品川駅"
"きたしなの 北信濃"
"きたしょく 北食"
"きたしらかわ 北白川"
"きたしらかわのみや 北白川宮"
"きたしんち 北新地"
"きたじま 喜多嶋 北嶋 北島"
"きたじょう 喜多條"
"きたすぎ 北杉"
"きたすな 北砂"
"きたせん 北線"
"きたせんじゅ 北千住"
"きたせんぞく 北千束"
"きたせんだい 北仙台"
"きたせんり 北千里"
"きたそうま 北相馬"
"きたぞの 北園"
"きたたいせいよう 北大西洋"
"きたたいへいよう 北太平洋"
"きたたかき 北高来"
"きたたかぎ 北高来"
"きたたちばな 北橘"
"きたたに 北谷"
"きたたま 北多摩"
"きただ 北田"
"きただい 北代"
"きただいとう 北大東"
"きただけ 北岳"
"きたちく 北地区"
"きたちしま 北千島"
"きたちょうせん 北朝鮮"
"きたつがる 北津軽"
"きたつる 北都留"
"きたとしま 北豊島"
"きたとだ 北戸田"
"きたど 北戸"
"きたどの 北殿"
"きたなか 北中"
"きたなかぐすく 北中城"
"きたならしの 北習志野"
"きたに 木谷"
"きたにほん 北日本"
"きたね 北根"
"きたの 北野"
"きたのうみ 北の湖"
"きたのかた 北の方"
"きたのたけし 北野武"
"きたのまる 北の丸"
"きたはし 北橋"
"きたはた 北波多"
"きたはちおうじ 北八王子"
"きたはっこうだ 北八甲田"
"きたはま 北浜"
"きたはら 北原"
"きたはんきゅう 北半球"
"きたはんぶん 北半分"
"きたばたけ 北畑 北畠"
"きたばやし 北林"
"きたひろしま 北広島"
"きたべっぷ 北別府"
"きたほ 北穂"
"きたほっかいどう 北北海道"
"きたまえぶね 北前船"
"きたまくら 北枕"
"きたまち 北町"
"きたまつ 北松"
"きたまつど 北松戸"
"きたまど 北窓"
"きたまわり 北回り"
"きたみ 喜多見 北見"
"きたみざわ 北見沢"
"きたみち 北道"
"きたみまき 北御牧"
"きたむき 北向き"
"きたむら 北村"
"きたむろ 北牟婁"
"きため 北目"
"きたもうこ 北蒙古"
"きたもと 北本"
"きたもり 北森"
"きたもりお 北杜夫"
"きたもろかた 北諸県"
"きたもん 北門"
"きたや 北谷"
"きたやま 北山"
"きたやまさ 北山佐"
"きたゆき 北行"
"きたよーろっぱ 北ヨーロッパ"
"きたより 北寄り"
"きたら 喜多羅"
"きたる 来る"
"きたろう 喜太郎 鬼太郎"
"きたわき 北脇"
"きたん 綺譚 忌憚 奇譚"
"きたんかいきょう 紀淡海峡"
"きたんさく 木探索"
"きだ 段 貴田 喜田 木田"
"きだい 貴台 気大 季題 機台 基台 希代 稀代"
"きだち 木質 木立ち 木太刀"
"きだて 気立 気だて 気立て"
"きだまり 木田余"
"きだん 綺譚 基壇 気団 綺談 奇談"
"きち 窺知 貴地 危地 機智 機知 既知 吉 基地"
"きちえもん 吉右衛門"
"きちがい 気狂い 気違い"
"きちく 鬼畜"
"きちじ 吉事"
"きちじつ 吉日"
"きちじま 吉島"
"きちじょう 吉上 吉祥"
"きちじょうそう 吉祥草"
"きちじょうてん 吉祥天"
"きちすう 吉数"
"きちぞう 吉蔵"
"きちのすけ 吉之助"
"きちむ 吉夢"
"きちゃ 黄茶"
"きちゃく 帰着"
"きちゅう 基柱 忌中 機中 期中"
"きちょ 貴著"
"きちょう 綺帳 帰庁 几帳 帰朝 機長 記帳 基調 貴重"
"きちれい 吉例"
"きちろう 吉郎"
"きちん 木賃"
"きちんやど 木賃宿"
"きっか 橘花 菊華 菊花"
"きっかい 奇っ怪"
"きっかけ 切っ掛け"
"きっかしょうば 菊花賞馬"
"きっかわ 菊川 吉川"
"きっきゅうじょ 鞠躬如"
"きっきょ 拮据"
"きっきょう 喫驚 吉凶 吃驚"
"きっきん 吃緊 喫緊"
"きっくつ 佶屈"
"きっこう 亀甲 拮抗"
"きっこうかっこ 〕 〔"
"きっこうでん 乞巧奠"
"きっこうまん 亀甲萬"
"きっさ 喫茶"
"きっさき 切尖 切先 切っ先"
"きっしょ 吉書"
"きっしょう 吉祥"
"きっしょういん 吉祥院"
"きっしょく 喫食"
"きっすい 吃水 喫水 生粋"
"きっせき 詰責"
"きっせん 吉仙"
"きっそう 吉左右 吉相"
"きっそうこん 吉草根"
"きっそうさん 吉草酸"
"きったか 橘高"
"きったて 切立"
"きったはった 切った張った"
"きったんもじ 契丹文字"
"きっちょう 吉兆"
"きっちょむ 吉四六"
"きっつけ 切付"
"きって 切手"
"きっと 吃度 急度 吉都 屹度"
"きっぷ 気っ風 気風 切符"
"きっぽう 吉方 吉報"
"きつ 迄 訖 屹 吃 乞 桔 佶 拮 橘 吉 喫 詰"
"きつえん 喫煙"
"きつえんこーなー 喫煙コーナー"
"きつおん 吃音"
"きつかわ 橘川"
"きつき 杵築"
"きつけ 気附 気付 気付け"
"きつけぐすり 気付け薬"
"きつご 吃語"
"きつぜん 屹然"
"きつつき 啄木鳥"
"きつと 吉都"
"きつね 狐"
"きつねいろ 狐色"
"きつねうどん 狐饂飩"
"きつねけん 狐拳"
"きつねそば 狐蕎麦"
"きつねつき 狐憑き"
"きつねづか 狐塚"
"きつねのまごか キツネノマゴ科"
"きつねび 狐火"
"きつねものがたり 狐物語"
"きつむ 吉夢"
"きつもん 詰問"
"きつりつ 屹立"
"きつりん 吉林"
"きつるばみ 黄橡"
"きつれがわ 喜連川"
"きづ 岐津 木津"
"きづかい 氣遣い 気遣い"
"きづかれ 気疲れ"
"きづき 木築 木月 杵築"
"きづく 気附"
"きづくり 木造り 木造"
"きづけ 気附 気付"
"きづた 木蔦"
"きづち 木槌"
"きづまり 気詰り 気詰まり"
"きて 来手"
"きてい 汽艇 旗亭 基底 既定 規程 規定"
"きていぎ 既定義"
"きていすういじょう 規定数以上"
"きていまく 基底膜"
"きていもく 奇蹄目"
"きているい 奇蹄類"
"きてき 汽笛"
"きてれつ 奇天烈"
"きてん 気転 輝点 貴店 機転 基点 起点"
"きでら 紀寺"
"きでん 紀伝 起電 記伝 機電 貴殿"
"きと 企図 帰途"
"きとう 貴答 木頭 木藤 紀藤 鬼頭 帰島 帰投 亀頭 祈祷 気筒"
"きとく 既得 危篤 奇特"
"きど 希土 喜怒 鬼怒 城戸 木戸 輝度"
"きどう 奇童 奇道 詭道 棋道 鬼道 綺堂 気道 軌道 機動 起動"
"きどうしき 軌道敷"
"きどうしゃ 気動車"
"きどうじき 軌道敷"
"きどく 奇特 既読"
"きどころ 木所"
"きどせん 木戸錢"
"きどり 木取り 気取り"
"きない 畿内 機内"
"きなが 気長"
"きなぐさみ 気慰み"
"きなこ 黄な粉 黄粉"
"きなこもち 黄な粉餅"
"きなさ 鬼無里"
"きなし 木梨"
"きなべ 汽鍋"
"きなり 生成り"
"きなん 危難 紀南 貴男"
"きにち 帰日 忌日"
"きにゅう 記入"
"きにゅうみす 記入ミス"
"きにょう 鬼繞"
"きにら 黄ニラ 黄韮"
"きにん 帰任 貴人"
"きにんだたみ 貴人畳"
"きにんだて 貴人点"
"きぬ 帛 衣 絹"
"きぬいと 絹糸"
"きぬうんも 絹雲母"
"きぬえ 絹枝"
"きぬおり 絹織"
"きぬかつぎ 衣被ぎ 衣被"
"きぬかわ 衣川"
"きぬがさ 衣笠"
"きぬがわ 鬼怒川"
"きぬぎぬ 衣衣 後朝 衣々"
"きぬけ 気抜け"
"きぬげ 絹毛"
"きぬごし 絹ごし 絹漉し"
"きぬさや 絹莢"
"きぬじ 絹地"
"きぬずれ 衣擦れ"
"きぬた 碪 砧"
"きぬたこつ 砧骨"
"きぬのみち 絹の道"
"きぬばり 絹張り 絹針"
"きぬもの 絹物"
"きぬや 絹屋"
"きぬわた 絹綿"
"きね 木根 杵"
"きねしま 杵嶋"
"きねずみ 木鼠"
"きねづか 杵柄"
"きねや 杵屋"
"きねん 紀年 祈念 記念"
"きねんさい 祈年祭"
"きねんじゅ 記念樹"
"きねんひ 記念碑"
"きねんひてきけっさく 記念碑的傑作"
"きの 紀 木野"
"きのう 気嚢 既納 帰農 帰納 昨日 機能"
"きのうち 城内 木之内 木内"
"きのうほうのかてい 帰納法の仮定"
"きのうゆにっと 機能ユニット"
"きのえ 木江 甲"
"きのえいぬ 甲戌"
"きのえうま 甲午"
"きのえさる 甲申"
"きのえたつ 甲辰"
"きのえとら 甲寅"
"きのえね 甲子"
"きのかわ 紀ノ川 紀の川"
"きのくに 紀伊國"
"きのくにや 紀之國屋 紀伊国屋"
"きのこ 木の子 菌 蕈 茸"
"きのこがり 茸狩 茸狩り"
"きのこぐも 茸雲"
"きのこじる きのこ汁 キノコ汁 茸汁"
"きのこめし 茸飯"
"きのこるい きのこ類 茸類"
"きのさき 城ノ崎 城崎"
"きのした 樹下 木の下 木ノ下 木下"
"きのしたけいすけ 木下恵介"
"きのしたりげん 木下利玄"
"きのせい 気のせい 気の所為"
"きのつらゆき 紀貫之"
"きのと 乙"
"きのとい 乙亥"
"きのとう 乙卯"
"きのとうし 乙丑"
"きのととり 乙酉"
"きのとひつじ 乙未"
"きのとみ 乙巳"
"きのとものり 紀友則"
"きのどく 気の毒"
"きのね 木の根"
"きのはら 木之原"
"きのぼり 木登り"
"きのぼりうお 木登魚"
"きのみ 木の実"
"きのみきのまま 着の身着の侭 着の身着の儘"
"きのみや 来宮"
"きのめ 木の芽"
"きのめあえ 木の芽和え"
"きのもと 木之元 木ノ本"
"きのり 気乗り"
"きは 際"
"きはい 跪拝"
"きはいち 既配置"
"きはく 気魄 稀薄 気迫 希薄"
"きはた 木幡"
"きはだ 木膚 蘗 檗 黄肌 黄蘗 木肌"
"きはだまぐろ 黄肌鮪"
"きはち 喜八"
"きはっぴょう 既発表"
"きはつ 輝発 既発 揮発"
"きはつばい 既発売"
"きはつゆ 揮發油"
"きはら 樹原 木原"
"きはん 機搬 羈絆 軌範 帰阪 帰帆 規範"
"きはんせん 機帆船"
"きはんりょく 既判力"
"きば 木場 騎馬 牙"
"きばい 木灰"
"きばく 起爆"
"きばこ 木箱"
"きばしら 木柱"
"きばたらき 気ばたらき 気働き"
"きばち 木鉢"
"きばつ 奇抜"
"きばや 気早"
"きばらい 既払い"
"きばらし 気晴し 気晴らし"
"きばん 機番 基板 基盤"
"きばんごう 記番号"
"きばんし 生半紙"
"きばんてきぎじゅつ 基盤的技術"
"きひ 貴妃 基肥 忌避"
"きひつ 起筆"
"きひょう 起票"
"きひろ 帰広"
"きひん 気稟 貴賓 気品"
"きび 綺靡 驥尾 吉備 稷 黍 機微"
"きびき 忌引き 忌引"
"きびす 踵"
"きびたき 黄鶲"
"きびだんご 黍団子"
"きびつじんじゃ 吉備津神社"
"きびなご 黍魚子"
"きびのまきび 吉備真備"
"きびもち 黍餅"
"きびゅうほう 帰謬法"
"きびょう 奇病"
"きびん 機敏"
"きふ 基布 貴腐 棋譜 寄附 寄付"
"きふう 棋風 気風"
"きふく 帰服 起伏"
"きふだ 木札"
"きふね 貴船"
"きふほう 記譜法"
"きぶ 基部"
"きぶかわ 貴生川"
"きぶく 忌服"
"きぶくれ 着脹れ 着膨れ"
"きぶさい 気塞い"
"きぶし 木歩士"
"きぶしねんど 木節粘土"
"きぶっせい 気ぶっせい"
"きぶつ 奇物 木仏 器物"
"きぶとり 着太り"
"きぶね 貴船"
"きぶん 奇聞 紀文 気分"
"きぶんよし 気分良"
"きへい 喜平 機兵 奇兵 騎兵"
"きへき 奇癖"
"きへん 机辺 木偏"
"きべら 木べら 木ベラ 木箆"
"きべん 詭弁"
"きほう 危峰 機鋒 気胞 紀宝 木方 季報 記法 既報 気泡 貴方"
"きほうざい 起泡剤"
"きほく 輝北"
"きほん 基本"
"きほんきゅう 基本給"
"きほんさーびす 基本サービス"
"きほんそふと 基本ソフト"
"きぼ 鬼簿 規模"
"きぼう 企望 既望 欺罔 希望"
"きぼうほう 喜望峰"
"きぼく 亀卜"
"きぼし 木星"
"きぼつ 鬼没"
"きぼね 気骨"
"きぼり 木彫り"
"きまえ 気前"
"きまかせ 気任せ"
"きまぐれ 気まぐれ 気紛れ"
"きまじめ 生真面目"
"きまた 木俣"
"きまち 木町"
"きまちどおり 木町通"
"きまつ 期末"
"きまつてすと 期末テスト"
"きまま 気まま 気儘"
"きまめ 黄豆 生豆"
"きまよい 気迷い"
"きまり 決り 決まり"
"きまりて 極り手"
"きみ 鬼魅 黄み 辟 生美 喜美 貴美 希美 公 黄身 気味 君"
"きみあき 公明"
"きみいがい 君以外"
"きみいでら 紀三井寺"
"きみえ 希己枝 君江 君枝"
"きみお 喜三雄 喜三男 公雄 公男"
"きみか 公佳"
"きみがよ 君が代"
"きみこ きみ子 紀美子 喜美子 君子 公子 季美子 季実子"
"きみしま 君嶋 君島"
"きみじか 気短"
"きみじしん 君自身"
"きみじま 君嶋 君島"
"きみた 君田"
"きみたか 公尚 君孝 公高"
"きみたち 君達"
"きみち 季道"
"きみつ 君津 気密 機密"
"きみとし 公稔"
"きみどり 木緑 黄緑"
"きみなお 公尚"
"きみのり 公典 公紀"
"きみひこ 仁彦 公彦"
"きみひと 公人"
"きみひろ 公広 公裕 公宏 公博"
"きみゃく 気脈"
"きみやす 公保"
"きみやま 君山"
"きみょう 帰命 奇妙"
"きみょうきてれつ 奇妙きてれつ"
"きみよ 君代"
"きみら 君等"
"きみわる 気味悪"
"きみん 飢民 棄民"
"きむ 金 帰無"
"きむいるそん 金日成"
"きむすめ 生娘"
"きむち 沈菜"
"きむら 木邑 木村"
"きむらもとお 木村資生"
"きめ 決め 肌理 木目"
"きめい 記明 貴名 記銘 記名"
"きめいがっき 気鳴楽器"
"きめたおし 極め倒し"
"きめだし 極め出し"
"きめだま 決め球"
"きめん 貴面 鬼面"
"きめんがに 鬼面蟹"
"きも 胆 肝"
"きもあえ 肝和え"
"きもいり 肝煎り 肝煎 肝いり"
"きもう 欺罔 起毛"
"きもうとかく 亀毛兎角"
"きもすい 肝吸"
"きもだめし 肝試し"
"きもち 気持ち 気持"
"きもったま 肝っ玉"
"きもつき 肝付"
"きもと 樹本 木元 木本"
"きもの 着物"
"きものすがた 着物姿"
"きもべつ 喜茂別"
"きもぽん 肝ポン"
"きもん 気門 奇門 旗門 奇問 鬼門"
"きゃ 迦 伽 脚"
"きゃく 攫 卻 却 脚 客"
"きゃくあし 客足"
"きゃくあしらい 客あしらい"
"きゃくあつかい 客扱い"
"きゃくい 客位"
"きゃくいり 客入り"
"きゃくいん 脚韻 客員"
"きゃくうけ 客受け"
"きゃくえん 客演"
"きゃくおうたい 客応対"
"きゃくかしゃく 客貨車区"
"きゃくがわ 客側"
"きゃくご 客語"
"きゃくさき 脚先 客先"
"きゃくさま 客様"
"きゃくし 客死"
"きゃくしき 格式 脚式"
"きゃくしつ 脚質 客室"
"きゃくしゃ 客舎 客車"
"きゃくしょう 客星"
"きゃくしょうばい 客商売"
"きゃくしょく 脚色"
"きゃくじん 客神 客人"
"きゃくすじ 客筋"
"きゃくせい 客星"
"きゃくせき 客席"
"きゃくせん 脚線 客船"
"きゃくぜん 客膳"
"きゃくぜんいん 客全員"
"きゃくそう 客僧 客層"
"きゃくたい 客体"
"きゃくだたみ 客畳"
"きゃくだね 客種"
"きゃくちゅう 脚註 客注 脚注"
"きゃくでん 客電 客殿"
"きゃくとり 客取り"
"きゃくど 客土"
"きゃくどうし 客同士"
"きゃくどめ 客止め"
"きゃくひき 客引き"
"きゃくぶ 脚部"
"きゃくぶん 客分"
"きゃくほん 脚本"
"きゃくま 客間"
"きゃくゆそう 客輸送"
"きゃくよう 客用"
"きゃくよせ 客寄 客寄せ"
"きゃくよせぱんだ 客寄せパンダ"
"きゃくらい 客来"
"きゃくりょく 脚力"
"きゃしゃ 花車 華奢"
"きゃたつ 脚立"
"きゃっか 脚下 却下"
"きゃっかん 客観"
"きゃっき 客気"
"きゃっこう 脚光"
"きゃっしゅふろーけいさんしょ キャッシュフロー計算書"
"きゃっぷ ∩"
"きゃつ 彼奴"
"きゃのんはんばい キヤノン販売"
"きゃのんほう キャノン砲"
"きゃはん 脚絆"
"きゃべつばたけ キャベツ畑"
"きゃら 伽羅"
"きゃらくたーしょうひん キャラクター商品"
"きゃらめるあじ キャラメル味"
"きゃりあぐみ キャリア組"
"きゃん 侠"
"きゃんせるまち キャンセル待ち"
"きゃんせるりょう キャンセル料"
"きゃんぷじょう キャンプ場"
"きゃんぷち キャンプ地"
"きゃんぺーんきかん キャンペーン期間"
"きゃんぺーんちゅう キャンペーン中"
"きや 紀谷 木屋"
"きやく 奇薬 既訳 既約 規約"
"きやす 喜安"
"きやすさ 気安さ"
"きやすめ 気休め"
"きやせ 着痩せ"
"きやま 基山 木山"
"きやみ 気病み"
"きやむ 喜屋武"
"きやり 木遣り"
"きやん 喜屋武"
"きゅーば 玖瑪"
"きゅう 扱 ９ 舊 鬮 糺 嗅 泣 朽 臼 邱 皀 歙 翕 樛 摎 貅 恷 烋 岌 笈 汲 吸 及 逑 裘 救 求 躬 穹 窮 弓 赳 糾 蚯 丘 疚 柩 久 鳩 究 仇 宮 九 休 給 球 級 灸 旧 急"
"きゅうあい 求愛"
"きゅうあく 旧悪"
"きゅうあん 久安"
"きゅうい 九位 級位 球威"
"きゅういん 吸飲 吸引"
"きゅうえき 旧駅"
"きゅうえん 吸煙 求縁 旧怨 旧縁 休煙 球宴 休演 休園 救援"
"きゅうおん 旧恩 球音 吸音"
"きゅうか 求家 急火 毬果 急下 球果 旧家 休暇"
"きゅうかーぶ 急カーブ"
"きゅうかい 旧懐 求解 球界 休会"
"きゅうかいうら 九回裏"
"きゅうかく 吸角 球殻 嗅覚"
"きゅうかざん 休火山"
"きゅうかつ 裘葛 久闊"
"きゅうかぶ 旧株"
"きゅうかん 旧慣 休閑 旧館 吸汗 急患 休刊 休館"
"きゅうかんちょう 九官鳥"
"きゅうかんび 休肝日"
"きゅうが 休芽"
"きゅうがく 休学"
"きゅうがた 旧型"
"きゅうき 旧記 給気 吸気"
"きゅうきてき 求基的"
"きゅうきゃく 旧客"
"きゅうきゅう 急求 汲々 救急"
"きゅうきゅうにょりつりょう 急急如律令"
"きゅうきゅうばこ 救急箱"
"きゅうきょ 急きょ 鳩居 旧居 急遽"
"きゅうきょう 窮境 究竟 旧教"
"きゅうきょく 窮極 究極"
"きゅうきん 給金 球菌"
"きゅうぎ 球戯 球技"
"きゅうぎゅう 九牛"
"きゅうぎゅうのいちもう 九牛の一毛"
"きゅうぎょう 休業"
"きゅうくつ 窮屈"
"きゅうぐ 弓具"
"きゅうけい 急啓 宮刑 球茎 弓形 求刑 球形 休憩"
"きゅうけつ 灸穴 宮闕 給血 吸血"
"きゅうげき 急劇 旧劇 急激"
"きゅうげん 給源 急減"
"きゅうこ 旧故 舅姑"
"きゅうこう 九江 躬行 旧稿 救荒 休航 休耕 旧交 吸光 休校 休講 急行"
"きゅうこうだい 九州工業大学 久工大 九工大"
"きゅうこうでん 休耕田"
"きゅうこうび 休稿日"
"きゅうこく 急告 救国"
"きゅうこん 窮困 求婚 球根"
"きゅうご 救護"
"きゅうごう 鳩合 糾合"
"きゅうごく 旧国"
"きゅうごしらえ 急拵え"
"きゅうさい 旧債 休載 救済"
"きゅうさいぼう 嗅細胞"
"きゅうさか 急坂"
"きゅうさく 窮策 久作 旧作"
"きゅうさつ 旧札"
"きゅうさんだい 九産大"
"きゅうざか 急坂"
"きゅうざひょう 球座標"
"きゅうざぶろう 究三郎"
"きゅうし 急施 旧詩 仇視 弓矢 急駛 旧史 窮死 旧址 宮址 旧師 急使 灸師 九死 九紫 球史 臼歯 給紙 急死 休止"
"きゅうしき 旧識 旧式"
"きゅうしち 久七"
"きゅうしつ 宮室 吸湿"
"きゅうしゃ 柩車 廐舎 鳩舎 急斜 旧車 厩舎"
"きゅうしゅ 九首 級酒 鳩首 旧主"
"きゅうしゅう 旧習 急襲 吸収 九州"
"きゅうしゅうきた 九州北"
"きゅうしゅうさんば 九州産馬"
"きゅうしゅつ 休出 救出"
"きゅうしゅん 球春 急峻"
"きゅうしょ 究所 急所"
"きゅうしょう 急症 求償 旧称"
"きゅうしょく 休職 求職 給食"
"きゅうしょくせんたー 給食センター"
"きゅうしろう 久四郎"
"きゅうしん 急信 球心 急診 旧臣 丘疹 求心 球審 急進 急伸 休診"
"きゅうしんけい 嗅神経"
"きゅうじ 救治 灸治 旧辞 旧時 九字 旧字 球児 給仕 給餌"
"きゅうじつ 休日"
"きゅうじゅ 久寿"
"きゅうじゅう 九十"
"きゅうじゅつ 救恤 弓術"
"きゅうじょ 宮女 救助"
"きゅうじょう 九条 宮場 弓状 球上 弓場 宮城 窮状 球状 休場 球場"
"きゅうじょうひ 嗅上皮"
"きゅうじん 窮盡 吸塵 旧人 求人"
"きゅうす 急須"
"きゅうすい 汲水 吸水 給水"
"きゅうすいとう 給水塔"
"きゅうすう 級数"
"きゅうすうわ 級数和"
"きゅうず 旧図"
"きゅうせい 球聖 救世 九星 旧制 急逝 旧姓 急性"
"きゅうせいかいはくずいえん 急性灰白髄炎"
"きゅうせいき 九世紀"
"きゅうせき 休戚 求積 旧跡"
"きゅうせつ 急設 旧説"
"きゅうせん 求仙 弓箭 旧線 急戦 休戦"
"きゅうせんどう 球泉洞"
"きゅうぜん 翕然"
"きゅうぜんじつ 休前日"
"きゅうそ 泣訴 窮鼠"
"きゅうそう 九索 穹蒼 給送 急送"
"きゅうそうがっき 弓奏楽器"
"きゅうそく 吸息 球速 休息 急速"
"きゅうそだい 窮措大"
"きゅうぞう 九蔵 久蔵 吸蔵 急造 旧蔵 急増"
"きゅうたい 裘代 旧態 球体"
"きゅうたく 旧宅"
"きゅうたま 九玉"
"きゅうたろう 久太郎"
"きゅうたん 急湍"
"きゅうだい 九州大学 久大 九大 旧題 及第"
"きゅうだん 給弾 糺彈 糾彈 糺弾 糾弾 球団"
"きゅうだんしん 球団新"
"きゅうち 九地 旧地 旧知 窮地"
"きゅうちしん 求知心"
"きゅうちゃき 給茶器"
"きゅうちゃく 吸着"
"きゅうちゅう 吸虫 宮中"
"きゅうちゅうぎ 九柱戯"
"きゅうちゅうぼうじゅうだいじけん 宮中某重大事件"
"きゅうちょ 旧著"
"きゅうちょう 急調 窮鳥 急潮 級長"
"きゅうちょうてき 求頂的"
"きゅうつい 急追"
"きゅうつう 窮通"
"きゅうてい 休廷 宮廷"
"きゅうていたいりょ 九鼎大呂"
"きゅうてき 旧敵 仇敵"
"きゅうてん 急轉 灸点 九天 急転"
"きゅうてんぽ 急テンポ"
"きゅうでん 休電 給田 九電 給電 宮殿"
"きゅうと 旧都"
"きゅうとう 旧套 旧冬 急騰 給湯"
"きゅうどう 球道 求道 旧道 弓道"
"きゅうどうかく 九同角"
"きゅうない 球内"
"きゅうなん 急難 救難"
"きゅうにし 旧西"
"きゅうにゅう 吸入"
"きゅうねつ 急熱 吸熱"
"きゅうねん 九年 旧年"
"きゅうは 急派 旧派"
"きゅうはい 九拝 朽廃"
"きゅうはいき 給排気"
"きゅうはいきけい 吸排気系"
"きゅうはいすいせつび 給排水設備"
"きゅうはく 休拍 休泊 急迫 窮迫"
"きゅうはちこう 旧八高"
"きゅうはん 旧藩 急坂 旧版"
"きゅうはんどる 急ハンドル"
"きゅうはんぼん 求版本"
"きゅうば 九馬 急場"
"きゅうばい 急売"
"きゅうばく 旧幕"
"きゅうばつ 救抜"
"きゅうばん 旧盤 旧版 吸盤"
"きゅうひ 厩肥 給費"
"きゅうひき 九匹"
"きゅうひつ 休筆"
"きゅうひん 救貧"
"きゅうひんいん 救貧院"
"きゅうび 九尾 鳩尾"
"きゅうびのねこ 九尾の猫"
"きゅうびょう 急病"
"きゅうびん 急便"
"きゅうぴっち 急ピッチ"
"きゅうふ 宮阜 旧譜 休符 給付"
"きゅうふう 旧風"
"きゅうぶれーき 急ブレーキ"
"きゅうぶん 給分 旧聞"
"きゅうへい 弓兵 旧弊"
"きゅうへん 急変"
"きゅうべえ 久兵衛"
"きゅうべつ 級別"
"きゅうほう 臼砲 急報 旧法"
"きゅうほうじ 久宝寺"
"きゅうぼ 急募"
"きゅうぼう 窮乏"
"きゅうぼくふんしょう 朽木糞牆"
"きゅうぼん 旧盆"
"きゅうま 久馬"
"きゅうみん 救民 窮民 休眠"
"きゅうみんが 休眠芽"
"きゅうむ 急務"
"きゅうむいん 厩務員"
"きゅうめい 窮命 及明 求明 糺明 糾明 旧名 究明 救命"
"きゅうめいぶい 救命ブイ"
"きゅうめいぼーと 救命ボート"
"きゅうめん 球面"
"きゅうもん 糺問 宮門"
"きゅうや 久弥"
"きゅうやく 旧訳 旧約"
"きゅうゆ 給油"
"きゅうゆう 級友 旧友"
"きゅうよ 窮餘 窮余 給与"
"きゅうよう 休用 給養 球陽 急用 休養"
"きゅうようあけ 休養明"
"きゅうらい 救癩 旧来"
"きゅうらぎ 厳木"
"きゅうらく 及落 急落"
"きゅうり 窮理 究理 胡瓜"
"きゅうりうお 胡瓜魚"
"きゅうりゅう 九流 九竜 九龍 穹窿 急流"
"きゅうりょう 休漁 旧領 丘陵 給料"
"きゅうれい 急冷"
"きゅうれき 旧暦"
"きゅうろう 旧臘"
"きゅうろばん 九路盤"
"きゅうわ 九羽"
"きゅうわり 九割"
"きゆう 喜憂 嬉遊 既有 杞憂"
"きょ 舉 擧 筥 歔 嘘 墟 踞 倨 鋸 鉅 苣 秬 炬 距 渠 拒 醵 遽 據 拠 許 去 挙 居 巨 虚"
"きょあく 巨悪"
"きょい 虚位"
"きょう 棘 烱 炯 疆 僵 彊 襁 繦 頃 皀 鍄 亰 誑 經 竅 梟 抂 徼 廾 荊 矜 梗 驚 恭 怯 叫 叶 杏 馨 香 姜 羌 陜 莢 篋 筴 狹 狭 挾 挟 峽 峡 侠 夾 驕 轎 嬌 蕎 矯 喬 僑 嚮 饗 響 洶 恟 匈 胸 兇 筺 筐 匡 兢 竸 競 恊 脅 鞏 跫 恐 享 亨 鏡 竟 刧 劫 况 況 兄 拱 供 共 郷 卿 協 橋 境 凶 興 教 経 狂 強 京 今日"
"きょうあい 狭隘"
"きょうあく 梟悪 強悪 兇悪 凶悪"
"きょうあつ 強圧"
"きょうあん 教案"
"きょうい 教委 強意 胸囲 驚異 脅威"
"きょういく 教育"
"きょういくしゃしんしょ 教育社新書"
"きょういくてれび 教育テレビ"
"きょういくまま 教育ママ"
"きょういくようけいさんきせんたー 教育用計算機センター"
"きょういくろーん 教育ローン"
"きょういぞん 共依存"
"きょういち 京一 恭一"
"きょういも 京芋"
"きょういん 教員"
"きょうう 強雨"
"きょううん 凶運 強運"
"きょうえい 胸泳 競映 鏡映 競泳 共栄"
"きょうえいたんかー 共栄タンカー"
"きょうえき 共役 共益"
"きょうえつ 恐悦"
"きょうえん 嬌艶 協演 狂宴 饗宴 競演 共演"
"きょうおう 響應 響応 胸奥 狂王 供応 饗応"
"きょうおん 強音 跫音"
"きょうおんな 京女"
"きょうか 莢果 凶禍 橋架 鏡花 供花 狂歌 教化 教科 強化"
"きょうかい 疆界 協會 胸懐 教誨 境界 教会 協会"
"きょうかがらす 強化ガラス"
"きょうかく 脅嚇 胸膈 匡郭 夾角 狭角 侠客 胸郭"
"きょうかたびら 経帷子"
"きょうかつ 恐喝"
"きょうかね 京兼"
"きょうかべ 京壁"
"きょうかまい 強化米"
"きょうかようとしょ 教科用図書"
"きょうかん 峡間 驕悍 郷貫 兇漢 胸間 郷関 凶漢 胸管 経巻 叫喚 共感 教官"
"きょうかんかく 共感覚"
"きょうかんかくてきひゆ 共感覚的比喩"
"きょうかんふくいんしょ 共観福音書"
"きょうが 狂画 恭賀"
"きょうがい 驚駭 境界 境涯"
"きょうがく 共学 教学 驚愕"
"きょうがしま 経が島"
"きょうがせ 京ヶ瀬"
"きょうがね 京兼"
"きょうがのこむすめどうじょうじ 京鹿子娘道成寺"
"きょうがま 京釜"
"きょうき 彊毅 強毅 兇器 共起 侠気 狭軌 強記 驚喜 狂喜 凶器 狂気"
"きょうきゃく 橋脚"
"きょうきゅう 匡救 供給"
"きょうきょ 僑居"
"きょうきょう 兢々 恐々"
"きょうきん 頬筋 胸襟 胸筋"
"きょうぎ 供犠 経木 狭義 教義 競技 協議"
"きょうぎゅうびょう 狂牛病"
"きょうぎょう 競業 協業"
"きょうぎょうしんしょう 教行信証"
"きょうぎょうひし 競業避止"
"きょうく 恐懼 狂句 教区"
"きょうくう 胸腔"
"きょうくん 教訓"
"きょうぐ 狂愚 教具"
"きょうぐう 僑寓 境遇"
"きょうけ 京家 教化"
"きょうけい 教計 共形 恭敬"
"きょうけつ 供血"
"きょうけん 恭謙 教権 鏡検 狂犬 強肩 強権 強健"
"きょうげき 挾撃 矯激 挟撃 京劇"
"きょうげべつでん 教外別伝"
"きょうげん 狂言"
"きょうこ 鞏固 協子 教子 香子 享子 響子 杏子 今日子 恭子 京子 強固"
"きょうこう 向後 恐惶 凶荒 胸甲 興行 強攻 凶行 胸腔 教皇 恐慌 強硬 強行"
"きょうこうせいしょうがい 恐慌性障害"
"きょうこく 狭谷 教国 郷国 強国 峡谷"
"きょうこつ 軽忽 侠骨 胸骨 頬骨"
"きょうこは 狂虎派"
"きょうご 教護"
"きょうごいん 教護院"
"きょうごう 強剛 校合 強豪 競合"
"きょうごく 京極"
"きょうさ 教唆"
"きょうさい 境栽 凶歳 恐妻 共催 共済"
"きょうさく 警策 凶作 競作 共作 狭窄"
"きょうさつ 恐察"
"きょうさん 京産 強酸 共産 協賛"
"きょうさんだい 京都産業大学"
"きょうざい 共在 教材"
"きょうざつ 夾雑"
"きょうざぶろう 恭三郎"
"きょうざめ 興覚め 興醒め"
"きょうし 享祀 郷試 教旨 教使 狂詩 狂死 供試 教師"
"きょうしありがくしゅう 教師あり学習"
"きょうしき 胸式 京職"
"きょうしつ 狂疾 教室"
"きょうしなし 教師なし"
"きょうしゃ 狭斜 驕奢 狂者 香車 強者"
"きょうしゅ 兇手 強手 凶手 拱手 強取 興趣 教主"
"きょうしゅう 共終 嬌羞 強襲 郷愁 教習"
"きょうしゅく 強縮 恐縮"
"きょうしゅつ 供出"
"きょうしょ 郷書 競書 挟書 校書 教書"
"きょうしょう 強将 嬌笑 夾鐘 胸章 協商 京商 狭小"
"きょうしょうてん 共焦点"
"きょうしょく 強食 共食 教職"
"きょうしろう 狂四郎"
"きょうしん 強心 驕心 狭心 強震 狂信 共振"
"きょうしんか 共進化"
"きょうしんかい 共進会"
"きょうじ 挾持 狂児 鏡次 享治 恭治 恭司 恭二 享持 香匙 香箸 挟持 矜恃 経師 凶事 脇侍 共時 矜持 教示"
"きょうじく 橋軸"
"きょうじつ 凶日"
"きょうじま 京嶋"
"きょうじゃく 怯弱 強弱"
"きょうじゃくあくせんと 強弱アクセント"
"きょうじゅ 享受 教授"
"きょうじゅう 凶獣"
"きょうじゅうごう 共重合"
"きょうじゅつ 供述"
"きょうじゅつろくしゅしょ 供述録取書"
"きょうじゅん 恭順"
"きょうじょ 狂女 共助"
"きょうじょう 兇状 凶状 教場 教条 橋上"
"きょうじん 兇刃 凶刃 強靱 狂人 強靭"
"きょうす 香車"
"きょうすい 狂酔 供水 胸水"
"きょうすいびょう 恐水病"
"きょうすけ 恭助 京助 恭輔 京介 恭介"
"きょうず 京津"
"きょうせい 嬌聲 狭正 匡正 叫声 強盛 凶星 共棲 強勢 強請 教生 嬌声 共生 矯正 強制"
"きょうせいいん 矯正院"
"きょうせき 共石"
"きょうせつ 教説"
"きょうせら 京セラ"
"きょうせん 共線 胸腺"
"きょうぜん 饗膳"
"きょうそ 教祖"
"きょうそう 強壯 凶相 狂躁 狂想 競漕 狂騒 強壮 競走 競争"
"きょうそうきょく 協奏曲"
"きょうそうこうきょうきょく 協奏交響曲"
"きょうそうば 競争馬 競走馬"
"きょうそく 脇息 教則"
"きょうそくびでお 教則ビデオ"
"きょうそん 共存"
"きょうぞう 享三 経蔵 鏡像 胸像"
"きょうぞめ 京染"
"きょうぞん 共存"
"きょうたい 嬌態 狂態 筐体"
"きょうたいいき 狭帯域"
"きょうたく 教卓 供託"
"きょうたる 京樽"
"きょうたん 驚嘆"
"きょうだ 怯懦 強打"
"きょうだい 京都大学 兄姉 姉妹 姉弟 兄妹 京大 橋台 鏡台 強大 兄弟"
"きょうだいきけん 京大基研"
"きょうだいまいこんくらぶ 京大マイコンクラブ"
"きょうだる 京樽"
"きょうだん 兇彈 兇弾 凶弾 教壇 教団"
"きょうち 協治 境地"
"きょうちくとう 夾竹桃"
"きょうちゅう 胸中"
"きょうちゅうじゃく 強中弱"
"きょうちょ 共著"
"きょうちょう 凶兆 共聴 協調 強調"
"きょうちょく 強直"
"きょうぢゅう 今日中"
"きょうつい 胸椎"
"きょうつう 胸痛 共通"
"きょうづか 京塚 経塚"
"きょうづくえ 経机"
"きょうづせん 京津線"
"きょうづつ 経筒"
"きょうてい 協提 筐底 胸底 教程 競艇 協定"
"きょうてき 狂的 強敵"
"きょうてん 狂癲 教典 経典"
"きょうてんどうち 驚天動地"
"きょうでん 敬田 強電"
"きょうでんしゃ 共電社"
"きょうと 教徒 京都"
"きょうとう 京濤 驚倒 郷党 鏡筒 共闘 教頭"
"きょうとうほ 橋頭堡"
"きょうとく 京徳 享徳"
"きょうとせらみっく 京都セラミック"
"きょうとたいしょうてん 京都大賞典"
"きょうとみなみ 京都南"
"きょうど 彊弩 強弩 匈奴 郷土 強度"
"きょうどう 嚮導 鏡胴 教導 共働 経堂 協働 協同 共同"
"きょうどうこう 共同溝"
"きょうどまり 今日泊"
"きょうな 京菜"
"きょうなんちょう 境南町"
"きょうにん 杏仁"
"きょうねつ 狂熱"
"きょうねん 凶年 享年"
"きょうの 京野"
"きょうのすけ 恭之助"
"きょうは 教派"
"きょうはく 強拍 強迫 脅迫"
"きょうはん 橋畔 教範 共犯"
"きょうばい 競売"
"きょうばし 京橋"
"きょうばん 夾板 響板"
"きょうひしょう 強皮症"
"きょうふ 京麩 教父 恐怖"
"きょうふう 驚風 矯風 狂風 京風 強風"
"きょうふくぶ 胸腹部"
"きょうぶ 胸部"
"きょうぶしょう 教部省"
"きょうぶん 凶聞 狂文"
"きょうぶんさん 共分散"
"きょうへい 恭兵 京平 恭平 強兵"
"きょうへき 胸壁"
"きょうへん 兇変 凶変 共変 共編"
"きょうへんどう 共変動"
"きょうべん 強弁 教鞭"
"きょうほ 享保 競歩"
"きょうほう 凶報 教法 享保"
"きょうほうのかいかく 享保の改革"
"きょうほん 狂奔 経本 教本"
"きょうぼう 教坊 兇暴 強暴 共謀 狂暴 凶暴"
"きょうぼうさ 狂暴さ"
"きょうぼく 経木 喬木"
"きょうま 京間"
"きょうまい 供米 京舞"
"きょうまく 鞏膜 莢膜 強膜 胸膜"
"きょうまる 京丸"
"きょうまん 驕慢"
"きょうみ 興味"
"きょうみざい 矯味剤"
"きょうみとうげ 京見峠"
"きょうみぶかい 興味深い"
"きょうむ 凶夢 教務"
"きょうむかかり 教務係"
"きょうむら 京村"
"きょうむらさき 京紫"
"きょうめい 響鳴 嬌名 共鳴"
"きょうめいばん 共鳴板"
"きょうめん 共面 鏡面"
"きょうもう 狂妄"
"きょうもと 京本"
"きょうもん 拱門 教門 狂文 経文"
"きょうや 京哉"
"きょうやき 京焼"
"きょうやく 供役 協約 共訳 共役"
"きょうやくきょく 共役極"
"きょうゆ 教諭"
"きょうゆう 亨有 侠勇 梟雄 享有 共有"
"きょうゆうせい 共優性"
"きょうよ 供与"
"きょうよう 孝養 強要 供用 共用 教養"
"きょうらい 敬礼 向来"
"きょうらく 京洛 享楽"
"きょうらん 供卵 供覧 狂乱"
"きょうり 胸裡 教理 郷里"
"きょうりき 強力 経力"
"きょうりきこ 強力粉"
"きょうりつ 共立"
"きょうりつせん 京立戦"
"きょうりゅう 恐龍 恐竜"
"きょうりょう 狭量 橋梁"
"きょうりょく 強力 協力"
"きょうりょくこ 強力粉"
"きょうりん 杏林"
"きょうれい 強冷 教令"
"きょうれき 教歴"
"きょうれつ 強烈"
"きょうれん 教錬 狂恋 教練"
"きょうろ 狭路"
"きょうろう 拱廊"
"きょうろく 享禄"
"きょうろん 経論"
"きょうわ 享和 興和 共和 協和"
"きょうわせい 共和政"
"きょうわん 峡湾"
"きょえい 巨影 虚栄"
"きょおく 巨億"
"きょか 炬火 許嫁 許可"
"きょかいきゅう 巨蟹宮"
"きょかん 巨艦 居館 巨漢"
"きょかんけつ 許冠傑"
"きょがく 巨額"
"きょがん 炬眼 巨岩"
"きょき 歔欷"
"きょきょじつじつ 虚虚実実 虚々実々"
"きょきん 醵金 拠金"
"きょぎ 虚偽"
"きょぎょう 虚業"
"きょく 跼 洫 勗 亟 旭 蕀 棘 巨躯 極 局 曲"
"きょくあて 局宛"
"きょくあな 局アナ"
"きょくい 極意"
"きょくいん 局員"
"きょくう 虚空 極右"
"きょくうた 曲歌"
"きょくえん 曲宴"
"きょくかい 曲解"
"きょくかく 極角"
"きょくかん 曲管 曲間"
"きょくかんち 極寒地"
"きょくがい 局外"
"きょくがく 曲学"
"きょくがわ 局側"
"きょくきぼ 局規模"
"きょくぎ 曲技"
"きょくぎめ 曲決め"
"きょくけいしき 極形式"
"きょくけん 極圏"
"きょくげい 曲芸"
"きょくげん 局限 極言 極限"
"きょくこうしんくう 極高真空"
"きょくさ 極左"
"きょくさく 曲作"
"きょくざい 局在"
"きょくざひょう 極座標"
"きょくし 極至 局紙 旭志 曲師"
"きょくしゃ 曲射 局舎"
"きょくしゅう 曲集"
"きょくしょ 局所"
"きょくしょう 極少 極小"
"きょくしょかん 局所環"
"きょくしん 極真"
"きょくじ 曲事"
"きょくじく 極軸"
"きょくじつ 旭日"
"きょくじゅん 曲順"
"きょくすい 曲水"
"きょくすいのえん 曲水の宴"
"きょくすう 極数 局数 曲数"
"きょくせい 極星 極性"
"きょくせき 跼蹐"
"きょくせつ 曲説 曲節 曲折"
"きょくせん 局線 曲線"
"きょくせんひょう 曲線標"
"きょくそう 曲想"
"きょくたい 極体"
"きょくたん 極端"
"きょくだい 極大"
"きょくだん 曲弾"
"きょくち 極値 極致 局地 極地"
"きょくちゅう 局中 曲中"
"きょくちょう 曲調 局長"
"きょくちょうたんぱ 極超短波"
"きょくちょく 曲直"
"きょくつき 曲付"
"きょくてき 極的"
"きょくてん 極点"
"きょくてんせきち 跼天蹐地"
"きょくとう 曲頭 極東"
"きょくど 極度"
"きょくどうざん 旭道山"
"きょくどめ 局止め 局留 局留め"
"きょくない 局内"
"きょくは 棘波"
"きょくはつ 局発"
"きょくば 曲馬"
"きょくばん 曲番 局番"
"きょくひ 棘皮"
"きょくひつ 曲筆"
"きょくび 極微"
"きょくびき 曲弾き"
"きょくふ 曲譜"
"きょくふう 曲風"
"きょくぶ 局部"
"きょくほう 局方"
"きょくほく 極北"
"きょくむき 極向き"
"きょくめ 曲目"
"きょくめい 局名 曲名"
"きょくめん 局免 曲面 局面"
"きょくめんきょ 局免許"
"きょくもく 極目 曲目"
"きょくや 極夜"
"きょくやく 曲約"
"きょくよう 極洋"
"きょくりつ 曲率"
"きょくりょう 極量"
"きょくりょく 極力"
"きょくろん 曲論 極論"
"きょけつ 虚血"
"きょけん 巨犬"
"きょげい 巨鯨"
"きょげつ 去月"
"きょげん 虚言"
"きょこう 挙行 虚構"
"きょこうせんだん 虚航船団"
"きょこく 挙国"
"きょこつ 距骨"
"きょこん 巨根 虚根 許婚"
"きょご 虚語"
"きょごう 倨傲"
"きょさい 巨細"
"きょさいぼう 巨細胞"
"きょさつ 巨刹"
"きょざい 巨材 巨財"
"きょし 巨資 挙止 巨視 鋸歯"
"きょしき 挙式"
"きょしちょうざ 巨嘴鳥座"
"きょしつ 居室"
"きょしゅ 挙手"
"きょしゅう 去秋 虚舟 去就"
"きょしゅつ 醵出 拠出"
"きょしゅん 去春"
"きょしょ 居所"
"きょしょう 虚証 裾礁 去声 挙証 巨匠"
"きょしょく 巨食 拒食 虚飾"
"きょしん 許慎 巨神 虚心"
"きょじ 虚字 虚辞 挙示"
"きょじつ 虚実"
"きょじゃく 虚弱"
"きょじゅ 巨樹"
"きょじゅう 巨獣 居住"
"きょじょう 許状 居城"
"きょじん 虚人 巨神 巨人"
"きょじんのほし 巨人の星"
"きょすう 虚数"
"きょせい 去声 虚勢 巨星 去勢"
"きょせき 巨石"
"きょせつ 虚説"
"きょせん 巨船 巨泉"
"きょぜつ 拒絶"
"きょぜん 遽然"
"きょそ 挙措"
"きょそく 虚足"
"きょぞう 虚象 巨象 巨像 虚像"
"きょた 許多"
"きょたい 巨体"
"きょたく 居宅"
"きょたん 虚誕 去痰"
"きょだい 巨大"
"きょだいあり 巨大蟻"
"きょだく 許諾"
"きょだつ 虚脱"
"きょだん 鋸断"
"きょちゅうちょうてい 居中調停"
"きょっかい 極海 曲解"
"きょっかん 極官 極冠"
"きょっきゅう 曲球"
"きょっけい 極刑"
"きょっけん 極圏"
"きょっこう 旭光 極光"
"きょてん 拠点"
"きょでん 虚伝"
"きょとう 挙党 巨塔 巨頭"
"きょどう 挙動"
"きょなん 鋸南"
"きょにゅう 巨乳"
"きょにんか 許認可"
"きょねん 去年"
"きょねんくれ 去年暮"
"きょはく 巨擘"
"きょひ 許否 巨費 拒否"
"きょふ 巨富"
"きょぶ 虚部"
"きょぶん 虚聞"
"きょへい 挙兵"
"きょへん 巨篇 巨編"
"きょほ 巨歩"
"きょほう 虚報 巨砲 巨峰"
"きょぼく 巨木"
"きょまん 巨万"
"きょむ 虚夢 虚無"
"きょめい 虚名"
"きょもう 虚妄"
"きょゆう 許由"
"きょゆうそうほ 許由巣父"
"きょよう 挙用 許容"
"きょらい 去来"
"きょらいしょう 去来抄"
"きょり 巨利 距離"
"きょりそう 距離走"
"きょりゅう 去留 居留"
"きょれい 虚礼"
"きょんじゅ 慶州"
"きよ 清 寄予 奇与 毀誉 季代 喜世 喜代 寄与"
"きよあき 清朗 清昭 清明"
"きよい 清井"
"きよう 記要 貴陽 紀陽 機用 紀要 起用 器用"
"きようけん 崎陽軒"
"きようやく 稀用薬"
"きようら 清浦"
"きよえ 清栄"
"きよおか 清岡"
"きよか 清佳"
"きよかず 清一 清和"
"きよかわ 清川"
"きよがき 清書"
"きよき 清木"
"きよくに 清久仁"
"きよくら 清倉"
"きよこ 希世子 希代子 貴代子 紀代子 喜代子 聖子 清子"
"きよさと 清里"
"きよざわ 清沢"
"きよし 僖良 清茂 喜好 潔司 喜代志 清史 清司 清志 澄 潔 淳 清"
"きよしげ 清滋 清重"
"きよしろう 清志朗"
"きよじ 喜代治"
"きよす 清洲"
"きよすみ 清住"
"きよずり 清刷 清刷り"
"きよせ 木寄せ 清瀬"
"きよたか 清天 清高 清孝 清貴 清隆"
"きよたき 清竜 清滝"
"きよたけ 清武"
"きよたに 清谷"
"きよだ 清田"
"きよつか 清塚"
"きよつぐ 清次"
"きよと 清人"
"きよとし 清利"
"きよぬま 浄沼"
"きよね 清音"
"きよの 清野"
"きよのぶ 清信"
"きよのり 清典"
"きよはら 清原"
"きよはらい 清祓"
"きよはらえ 清祓"
"きよはらのふかやぶ 清原深養父"
"きよはらのもとすけ 清原元輔"
"きよはる 清晴 清治"
"きよひこ 清彦"
"きよひと 清人"
"きよひめ 清姫"
"きよひら 清衡"
"きよひろ 恭弘 清博 清宏"
"きよぶき 清拭き"
"きよまさ 清正"
"きよまつ 清松"
"きよみ 貴予美 紀代美 聖美 喜代美 清見 清美"
"きよみがた 清見潟"
"きよみず 清水"
"きよみずでら 清水寺"
"きよみずやき 清水焼"
"きよもと 清元"
"きよもとぶし 清元節"
"きよもり 清盛"
"きよゆき 聖之 清之"
"きよら 清ら"
"きよらか 清らか"
"きよわ 気弱"
"きら 吉良 綺羅"
"きらーさいぼう キラー細胞"
"きらい 記頼 帰来 嫌い 機雷"
"きらいげん 機雷原"
"きらいほう 鬼雷砲"
"きらく 帰洛 喜楽 気楽"
"きらずり 雲母刷"
"きらびき 雲母引"
"きらぼし きら星 キラ星 綺羅星"
"きらめき 煌めき"
"きらら 雲母"
"きらわれもの 嫌われ者"
"きらん 貴覧"
"きり 雰 棋理 切 切り 錐 霧 桐"
"きりあい 斬り合い"
"きりあげ 切上げ"
"きりあぶら 桐油"
"きりあめ 霧雨"
"きりいし 切石"
"きりいちよう 桐一葉"
"きりうじ 切蛆"
"きりうり 切売り"
"きりえ 切絵"
"きりおとし 切落"
"きりか 霧化"
"きりかえ 切換え 切換 切り換え 切替え 切替"
"きりかき 切り欠き"
"きりかけ 切掛"
"きりかぶ 檮 切株"
"きりかみ 切髪 切紙"
"きりが 霧賀"
"きりきず 斬傷 切傷 切り傷"
"きりきり 吉里吉里"
"きりきりまい きりきり舞い"
"きりぎし 切岸"
"きりぎりす 螽斯 蛬 蟋蟀"
"きりくず 切りくず"
"きりくずし 切り崩し"
"きりくち 切口"
"きりぐも 霧雲"
"きりこ 切り子 桐子 切子"
"きりこうじょう 切口上"
"きりこみ 斬り込み 切込 切込み"
"きりさきじゃっく 切り裂きジャック"
"きりさげ 切下げ"
"きりさと 霧里"
"きりさめ 霧雨"
"きりざい 桐材"
"きりしたん 吉利支丹 切支丹"
"きりしま 桐嶋 桐島 霧島"
"きりじょう 霧状"
"きりすて 切捨 切捨て 切り捨て"
"きりすと 基督"
"きりすときょう キリスト教"
"きりすとしゃ キリスト者"
"きりずみ 切炭 切り炭"
"きりた 桐田"
"きりたけ 桐竹"
"きりたっぷ 霧多布"
"きりたに 桐谷"
"きりたんぽ 切りたんぽ"
"きりだし 切出し"
"きりつ 紀律 起立 規律"
"きりつせいちょうせつしょうがい 起立性調節障害"
"きりつぼ 桐壷 桐壺"
"きりづま 切妻"
"きりづまづくり 切妻造"
"きりづみ 霧積"
"きりと 桐戸"
"きりとおし 切通し 切通"
"きりとり 切取 切取り"
"きりどおし 切通し 切通 切り通し"
"きりどおしざか 切通坂"
"きりなみ 霧浪"
"きりにしき 起利錦"
"きりぬき 切抜き"
"きりの 桐野"
"きりのう 切能"
"きりは 切り羽 切羽 切り刃 切刃"
"きりはた 切畑"
"きりはら 桐原"
"きりはり 切り貼り"
"きりばこ 霧箱"
"きりばな 切花 切り花"
"きりばり 切り貼り"
"きりひとは 桐一葉"
"きりび 鑽り火 切り火"
"きりふ 切斑 切符"
"きりふき 霧吹き"
"きりふだ 切札 切り札"
"きりふりこうげん 霧降高原"
"きりぶち 桐渕"
"きりぼし 切干し"
"きりみ 切身 切り身"
"きりみせ 切見世"
"きりもち 切餅 切り餅"
"きりもと 桐本"
"きりもどし 切り戻し"
"きりもみ 錐揉み"
"きりもり 切盛り"
"きりゃく 機略"
"きりや 桐谷"
"きりやま 桐山"
"きりゅう 旗旒 寄留 霧生 桐生 気流"
"きりゅういん 鬼龍院"
"きりょ 羈旅 羇旅"
"きりょう 着料 帰寮 器量"
"きりょく 氣力 棋力 気力"
"きりるもじ キリル文字"
"きりん 麒麟"
"きるい 帰塁"
"きるかえあすてるか キルカエアステル科"
"きれ 切 裂 喜連 切れ"
"きれい 奇麗 綺麗"
"きれいずき 綺麗好き"
"きれじ 切字 切れ痔 布地 裂地"
"きれっぱし 切れっ端"
"きれつ 奇列 亀裂"
"きれなが 切れ長"
"きれはし 切れ端"
"きれん 喜連"
"きろ 岐路 帰路"
"きろう 棄老"
"きろく 記録"
"きろくぶ 季肋部"
"きろくやぶり 記録破り"
"きろぐらむ 瓩"
"きろすう キロ数"
"きろめーとる 粁"
"きろりっとる 竏"
"きろわっとじ キロワット時"
"きわ 奇話 紀和 際"
"きわく 木枠"
"きわた 木棉"
"きわだ 黄肌 黄蘗"
"きわまりづき 極月"
"きわみ 極み"
"きわむ 究"
"きわめ 窮め 極め"
"きわめいん 極印"
"きわめがき 極書"
"きわめつき 極めつき"
"きわめつけ 極めつけ"
"きわめて 極めて"
"きわめふだ 極札"
"きわもの 際物"
"きをつけ 気を付け"
"きん 今 鈞 釁 衾 箟 箘 窘 緊 琴 錦 巾 饉 覲 瑾 懃 僅 勤 謹 擒 檎 禽 釿 掀 忻 听 芹 欽 欣 斤 噤 衿 襟 磬 均 近 筋 禁 菌 金"
"きんあ 金鴉"
"きんあか 金赤"
"きんあつ 禁圧"
"きんい 金位 近医 近位"
"きんいき 禁域"
"きんいぎょくしょく 錦衣玉食"
"きんいち 錦一 金一 欽一 欣一"
"きんいっぷう 金一封"
"きんいつ 均一"
"きんいろ 金色"
"きんいん 近因 金印 金員"
"きんうん 金運"
"きんうんも 金雲母"
"きんえい 近詠 近影"
"きんえき 菌液"
"きんえん 禁苑 筋炎 近縁 禁煙"
"きんおうむけつ 金甌無欠"
"きんか 槿花 近火 金花 金華 金貨"
"きんかい 勤快 禁戒 欣快 金海 琴海 金塊 近海"
"きんかいぎょ 近海魚"
"きんかいわかしゅう 金槐和歌集"
"きんかぎょくじょう 金科玉条"
"きんかく 巾幗 金閣"
"きんかくし 金隠し"
"きんかくびょう 菌核病"
"きんかざん 金華山"
"きんかん 金橘 金冠 金環 金柑 金管 近刊"
"きんかんしょく 金環蝕"
"きんかんばん 金看板"
"きんが 謹賀"
"きんがいしんたく 金外信託"
"きんがく 勤学 金額"
"きんがま 錦窯"
"きんがみ 金紙"
"きんがん 近眼"
"きんがんきょう 近眼鏡"
"きんき 近幾 琴棋 金器 欣喜 錦旗 金気 禁忌 近畿"
"きんきゅう 緊急"
"きんきょ 近居"
"きんきょう 禁教 近況"
"きんきょく 琴曲"
"きんきょり 近距離"
"きんきん 欣々 近々 僅々"
"きんぎゅうきゅう 金牛宮"
"きんぎょ 金魚"
"きんぎょう 近業"
"きんぎょく 金玉"
"きんぎょくきん 金玉均"
"きんぎょすくい 金魚掬い"
"きんぎょそう 金魚草"
"きんぎょだま 金魚玉"
"きんぎょばち 金魚鉢"
"きんぎん 金銀"
"きんぎんか 金銀花"
"きんぎんどう 金銀銅"
"きんく 金口 金句 勤苦 禁句"
"きんぐち 金口"
"きんぐん 禁軍 筋群"
"きんけい 錦鶏 筋系 金鶏 謹啓 近景"
"きんけいちょう 金鶏鳥"
"きんけつ 金欠"
"きんけん 金属材料研究所 金研 勤倹 金権 近県 金券"
"きんけんしょっぷ 金券ショップ"
"きんげん 謹言 謹厳 金言"
"きんげんせんい 筋原繊維"
"きんげんだい 近現代"
"きんげんてい 金原亭"
"きんこ 金海鼠 金鼓 近古 今古 金粉 禁錮 禁固 金庫"
"きんこう 金鉤 金坑 欣幸 金口 金鉱 金工 均衡 近郊"
"きんこうけい 近交系"
"きんこうどう 金港堂"
"きんこうぼくぜつ 金口木舌"
"きんこうもくぜつ 金口木舌"
"きんこく 近国 謹告"
"きんこつ 筋骨"
"きんこん 菌根"
"きんこんいちばん 緊褌一番"
"きんこんしき 金婚式"
"きんご 金吾"
"きんごう 近郷 金剛"
"きんごく 禁獄 近国"
"きんごろう 金語楼"
"きんさ 金砂 僅差"
"きんさく 金作 金策 近作"
"きんさつ 禁札"
"きんさん 菌傘"
"きんざ 金座"
"きんざい 近在"
"きんざいけん 金材研"
"きんざん 金山"
"きんざんじみそ 径山寺味噌"
"きんし 金紫 金史 金鵄 金枝 金糸 錦糸 菌糸 近視 禁止"
"きんしじゃく 金糸雀"
"きんしじょう 金市場"
"きんしたまご 金糸卵 錦糸卵"
"きんしつ 琴瑟 均質"
"きんしゃ 禽舎 金砂"
"きんしゃち 金鯱"
"きんしゅ 金主 金種 筋腫 禁酒"
"きんしゅう 菌褶 金繍 錦繍"
"きんしゅく 緊縮"
"きんしょ 琴書 謹書 禁書"
"きんしょう 擒縦 筋少 近称 金章 金将 金消 金賞 僅少"
"きんしょうけん 金証券"
"きんしょうしょ 金証書"
"きんしょく 金食"
"きんしろう 金四郎"
"きんしん 近信 近臣 謹慎 近親"
"きんしんしゅうこう 錦心繍口"
"きんじ 禁児 欽司 金治 金次 欣二 近事 近侍 金字 金地 近時 ≒ 近似"
"きんじがね 金地金"
"きんじき 禁色"
"きんじく 近軸"
"きんじし 金獅子"
"きんじす 筋ジス"
"きんじすとろふぃー 筋ジストロフィー"
"きんじつ 近日"
"きんじて 禁じ手"
"きんじとう 金字塔"
"きんじゅ 近習"
"きんじゅう 近什 禽獣 近習"
"きんじょ 近所"
"きんじょう 謹上 錦上 近状 今上 禁城 金城"
"きんじょうとうち 金城湯池"
"きんじょがっぺき 近所合壁"
"きんじょづきあい 近所付き合い"
"きんじん 金人"
"きんす 金子"
"きんすじ 金筋"
"きんすなご 金砂子"
"きんせい 均斉 均整 謹製 禁制 金星 近世"
"きんせいせき 菫青石"
"きんせき 金石"
"きんせきがい 近赤外"
"きんせつ 近接"
"きんせつかく 近接覚"
"きんせん 謹選 金線 琴線 金銭"
"きんせんうん 金銭運"
"きんせんか 金盞花"
"きんせんとれーど 金銭トレード"
"きんぜい 禁制"
"きんぜつ 禁絶"
"きんぜん 欣然"
"きんそう 巾箱 筋層"
"きんそうば 金相場"
"きんそく 緊束 禁足 禁則"
"きんぞう 金造 金蔵"
"きんぞく 勤続 金属"
"きんぞくいおん 金属イオン"
"きんぞくきじだい 金属器時代"
"きんぞくくず 金属屑"
"きんぞくすいそかぶつ 金属水素化物"
"きんぞくばっと 金属バット"
"きんぞくばん 金属板"
"きんぞくふん 金属粉"
"きんぞくぼう 金属棒"
"きんた 金太"
"きんたい 近体 勤怠"
"きんたま 金玉"
"きんたろうあめ 金太郎飴"
"きんたん 金丹"
"きんだ 勤惰"
"きんだい 金大 近大 近代"
"きんだいし 近代詩"
"きんだいち 金田一"
"きんだか 金高"
"きんだく 欣諾"
"きんだち 公達"
"きんだみ 金彩"
"きんだん 金談 禁男 禁断"
"きんだんのかじつ 禁断の果実"
"きんち 近地"
"きんちゃ 金茶"
"きんちゃく 近着 巾着"
"きんちゅう 禁中"
"きんちょ 近著"
"きんちょう 謹聽 禁鳥 禽鳥 金鳥 金長 謹聴 金打 緊張"
"きんちょく 謹直"
"きんつば 金鍔"
"きんつま 金妻"
"きんて 禁手"
"きんてい 緊締 欽定 謹呈"
"きんていやくせいしょ 欽定訳聖書"
"きんてき 金的"
"きんてつ 金鉄 近鉄"
"きんてん 均沾 均霑 近点"
"きんでい 金泥"
"きんでん 金殿 筋電"
"きんでんせい 均田制"
"きんと 筋斗"
"きんとう 金湯 公任 近東 均等"
"きんとき 金時"
"きんときまめ 金時豆"
"きんとれ 筋トレ"
"きんとん 金団"
"きんど 金土"
"きんどう 金藤 金道"
"きんどけい 金時計"
"きんなみ 金並"
"きんなら 緊那羅"
"きんにく 筋肉"
"きんにっせい 金日成"
"きんねこ 金猫"
"きんねん 近年"
"きんねんまれ 近年稀"
"きんのう 金納 勤皇"
"きんのすけ 金之助"
"きんのたまご 金の卵"
"きんはんげん 禁反言"
"きんば 金歯 金馬"
"きんばえ 金蠅"
"きんばく 緊縛"
"きんばつ 禁伐"
"きんばり 金張り"
"きんばん 勤番"
"きんぱ 金波"
"きんぱい 金盃 金牌 金杯"
"きんぱく 窘迫 金帛 謹白 金箔 緊迫"
"きんぱち 金八"
"きんぱつ 金髪"
"きんぱら 金原"
"きんひん 経行"
"きんびょうぶ 金屏風"
"きんぴ 金皮 金肥"
"きんぴか 金ぴか"
"きんぴょう 勤評"
"きんぴら 金平"
"きんぴん 金品"
"きんぶすま 金襖"
"きんぶち 金縁"
"きんぶん 均分 金文"
"きんぶんしょうしょ 今文尚書"
"きんぷう 金風"
"きんぷん 金粉"
"きんべん 勤勉"
"きんぺいばい 金瓶梅"
"きんぺき 金碧"
"きんぺん 近辺"
"きんほんい 金本位"
"きんぼ 欽慕"
"きんぼう 近傍"
"きんぼし 金星"
"きんぼたん 金ボタン"
"きんぽ 金浦"
"きんぽう 禁法 金峰"
"きんぽうげ 金鳳花"
"きんぽうげあか キンポウゲ亜科"
"きんぽうげか キンポウゲ科"
"きんぽうげもく キンポウゲ目"
"きんま 蒟醤 木馬"
"きんまく 筋膜"
"きんまんか 金満家"
"きんみつ 緊密"
"きんみゃく 金脈"
"きんみらい 近未来"
"きんむ 勤務"
"きんむく 金無垢"
"きんめ 斤目 金眼"
"きんめい 金明"
"きんめいちく 金明竹"
"きんめいてんのう 欽明天皇"
"きんめだい 金目鯛"
"きんめだりすと 金メダリスト"
"きんめだる 金メダル"
"きんめっき 金鍍金 金メッキ"
"きんもーる 金モール"
"きんもくせい 金木犀"
"きんもじ 金文字"
"きんもつ 禁物"
"きんもん 金紋 金文 禁門"
"きんや 金弥 欣哉 謹也 欽也 欣也 禁野"
"きんやっかん 金約款"
"きんゆ 禁輸"
"きんゆう 金融"
"きんゆうさい 金融債"
"きんよう 緊要 金曜"
"きんようしゅう 金葉集"
"きんようわかしゅう 金葉和歌集"
"きんよく 金欲 禁欲"
"きんらい 近来"
"きんらめ 金ラメ"
"きんらん 金蘭 金襴"
"きんらんそう 金蘭荘"
"きんらんで 金襴手"
"きんり 禁裏 金利"
"きんりゅう 金竜"
"きんりょう 禁猟 金陵 禁漁 斤量"
"きんりょく 金力 筋力"
"きんりん 錦林 近隣"
"きんる 近流 金縷"
"きんるい 菌類"
"きんるざいく 金鏤細工"
"きんれい 金鈴 禁令"
"きんれんか 金蓮花"
"きんろう 金狼 勤労"
"きんろうかんしゃのひ 勤労感謝の日"
"きんわ 謹話"
"ぎ 城 木 気 僞 祁 沂 巍 祇 擬 欺 艤 羲 礒 曦 嶬 蟻 犧 犠 戲 戯 萓 宜 誼 伎 妓 着 技 偽 議 疑 魏 儀 義"
"ぎあく 偽悪"
"ぎあひ ギア比"
"ぎあん 議案"
"ぎいち 義一"
"ぎいん 偽印 議院 議員"
"ぎえん 義捐 義援"
"ぎおう 祇王"
"ぎおん 擬音 祇園"
"ぎおんまつり 祇園祭"
"ぎか 偽花 偽果 技家 技科"
"ぎかい 議会"
"ぎかく 擬革"
"ぎかん 技管 議官 技官"
"ぎが 巍峨 偽画 儀我 戯画"
"ぎがく 伎楽"
"ぎがん 義眼"
"ぎき 義気 儀軌"
"ぎきょ 義挙"
"ぎきょう 偽経 義侠"
"ぎきょく 戯曲"
"ぎきん 義金"
"ぎぎ 魏魏 擬議 疑義"
"ぎぎゃく 戯謔"
"ぎく 疑懼"
"ぎくん 義訓"
"ぎぐん 義軍"
"ぎけい 偽計 義兄"
"ぎけいき 義経記"
"ぎけつ 議決"
"ぎけん 技研"
"ぎげ 義解"
"ぎげい 伎芸 技芸"
"ぎげいてん 伎芸天"
"ぎこ 擬古"
"ぎこう 技工 技巧"
"ぎごく 疑獄"
"ぎごしょく 魏呉蜀"
"ぎさく 戯作 偽作"
"ぎさん 蟻酸"
"ぎし 岸 魏史 偽史 擬死 義子 義肢 義士 義姉 義歯 技士 技師"
"ぎしき 儀式"
"ぎしゅ 技手 義手"
"ぎしゅう 蟻集"
"ぎしょ 戯書 義疏 魏書 偽書"
"ぎしょう 擬傷 宜昌 偽称 偽証"
"ぎしょうだに 棋将谷"
"ぎしわじんでん 魏志倭人伝"
"ぎしん 義心 疑心"
"ぎしんごう 偽信号"
"ぎしんなんぼくちょうじだい 魏晋南北朝時代"
"ぎじ 擬餌 擬似 疑似 議事"
"ぎじえ 擬似餌 疑似餌"
"ぎじえさ 擬似餌"
"ぎじばり 擬餌鉤 疑似針"
"ぎじゅく 義塾"
"ぎじゅつ 技術"
"ぎじゅついん 技術院"
"ぎじゅつばたけ 技術畑"
"ぎじょ 伎女 祇女 妓女"
"ぎじょう 技情 儀杖 儀仗 戯場 議定 議場"
"ぎじん 義人 擬人"
"ぎせい 義勢 儀制 擬製 擬声 擬制 犠牲"
"ぎせいふらい 犠牲フライ"
"ぎせき 妓籍 議席"
"ぎせん 義戰 岐セン 義戦 擬戦"
"ぎぜつ 義絶"
"ぎぜん 巍然 偽善"
"ぎそう 義爪 儀装 擬装 艤装 偽装"
"ぎそうかん 蟻走感"
"ぎそく 擬足 儀則 偽足 義足"
"ぎぞう 偽造"
"ぎぞく 義賊"
"ぎたい 義体 擬態"
"ぎたん 技短 義丹"
"ぎだ 犠打"
"ぎだい 技大 議題"
"ぎだゆう 義太夫"
"ぎだゆうぶし 義太夫節"
"ぎちょう 議長"
"ぎっくりごし ぎっくり腰"
"ぎっしゃ 牛車"
"ぎっちょう 毬杖"
"ぎつう 技通"
"ぎてい 議定 義弟"
"ぎてん 疑点 儀典 偽典"
"ぎとう 蟻塔"
"ぎどうさんしのはは 儀同三司母"
"ぎなん 岐南"
"ぎにんしん 偽妊娠"
"ぎぬ 衣"
"ぎねん 疑念"
"ぎねんごう 偽年号"
"ぎねんりん 偽年輪"
"ぎのう 技能"
"ぎのざ 宜野座"
"ぎのわん 宜野湾"
"ぎはん 偽版"
"ぎひ 犠飛"
"ぎひつ 偽筆"
"ぎひょう 戯評 儀表 技評"
"ぎふ 義父 岐阜"
"ぎふぢょうちん 岐阜提灯"
"ぎふとけん ギフト券"
"ぎふとよう ギフト用"
"ぎふん 義憤"
"ぎぶつ 偽物"
"ぎぶつほう 擬物法"
"ぎぶん 戯文"
"ぎぶんしょ 偽文書"
"ぎへい 義兵"
"ぎべん 擬娩"
"ぎほう 技報 技法"
"ぎぼ 義母"
"ぎぼし 擬宝珠"
"ぎまい 義妹"
"ぎまん 欺慢 欺瞞"
"ぎみ 君 気味"
"ぎみん 義民"
"ぎむ 義務"
"ぎむづけ 義務づけ"
"ぎめい 偽名"
"ぎもう 欺罔"
"ぎもん 疑問"
"ぎゃ 伽"
"ぎゃく 謔 瘧 虐 逆"
"ぎゃくい 逆位"
"ぎゃくうん 逆運"
"ぎゃくえん 逆縁"
"ぎゃくがわ 逆側"
"ぎゃくがわせ 逆為替"
"ぎゃくぎれ 逆ギレ"
"ぎゃくけい 逆形"
"ぎゃくげん 逆元"
"ぎゃくこう 逆向 逆光"
"ぎゃくさつ 虐殺"
"ぎゃくさん 逆算"
"ぎゃくざや 逆鞘"
"ぎゃくし 虐使"
"ぎゃくしべん 逆止弁"
"ぎゃくしゅ 逆修"
"ぎゃくしゅう 逆襲"
"ぎゃくしん 逆心 逆臣 逆進"
"ぎゃくしんぐる 逆シングル"
"ぎゃくじゅん 逆順"
"ぎゃくじょう 逆上"
"ぎゃくすう 逆数"
"ぎゃくせい 逆成 虐政"
"ぎゃくせいせっけん 逆性石鹸"
"ぎゃくせつ 逆接 逆説"
"ぎゃくそう 逆送 逆相 逆走"
"ぎゃくそこ 逆底"
"ぎゃくぞう 逆像"
"ぎゃくぞく 逆賊"
"ぎゃくたい 虐待"
"ぎゃくたん 逆探"
"ぎゃくちょう 逆調 逆潮"
"ぎゃくて 逆手"
"ぎゃくてん 逆転"
"ぎゃくてんまけ 逆転負"
"ぎゃくと 逆徒"
"ぎゃくぱたーん 逆パターン"
"ぎゃくひ 逆比"
"ぎゃくびき 逆引"
"ぎゃくふぃるた 逆フィルタ"
"ぎゃくふう 逆風"
"ぎゃくへん 逆辺 逆片"
"ぎゃくめ 逆目"
"ぎゃくもど 逆戻"
"ぎゃくよう 逆用"
"ぎゃくり 逆理"
"ぎゃくりゅう 逆流"
"ぎゃくりゅうせいしょくどうえん 逆流性食道炎"
"ぎゃっきょう 逆境"
"ぎゃっこう 逆光 逆行"
"ぎゃんぶるせい ギャンブル性"
"ぎやく 偽薬"
"ぎゅう 牛"
"ぎゅういんばしょく 牛飲馬食"
"ぎゅうえき 牛疫"
"ぎゅうかく 牛角"
"ぎゅうかわ 牛革"
"ぎゅうぎゅうづめ ギュウギュウ詰め ぎゅうぎゅう詰め"
"ぎゅうご 牛後"
"ぎゅうし 牛脂"
"ぎゅうしゃ 牛車 牛舎"
"ぎゅうしんてい 牛心亭"
"ぎゅうじ 牛耳"
"ぎゅうじょ 牛女"
"ぎゅうすじ 牛スジ 牛筋"
"ぎゅうたん 牛タン"
"ぎゅうてつ 牛鉄"
"ぎゅうとう 牛痘 牛刀"
"ぎゅうどん 牛丼"
"ぎゅうなべ 牛鍋"
"ぎゅうにく 牛肉"
"ぎゅうにゅう 牛乳"
"ぎゅうにゅうびん 牛乳壜 牛乳ビン"
"ぎゅうば 牛馬"
"ぎゅうひ 求肥 牛皮"
"ぎゅうひれ 牛ヒレ"
"ぎゅうふん 牛糞"
"ぎゅうほ 牛歩"
"ぎゅうめし 牛飯"
"ぎゅうもつ 牛モツ"
"ぎゅうもも 牛モモ"
"ぎゅうらく 牛楽 牛酪"
"ぎゆう 義勇"
"ぎょ 圉 圄 馭 禦 漁 御 魚"
"ぎょーざ 餃子"
"ぎょい 御衣 御意"
"ぎょいこう 御衣香"
"ぎょう 繞 痙 驍 蟯 翹 澆 嶢 僥 曉 暁 堯 尭 形 凝 仰 御宇 業 行"
"ぎょうあん 暁闇"
"ぎょういこう 行以降"
"ぎょういち 行位置"
"ぎょううん 暁雲"
"ぎょうかい 凝塊 業界"
"ぎょうかいがん 凝灰岩"
"ぎょうかく 仰角 行革"
"ぎょうかん 行間"
"ぎょうかんかく 行間隔"
"ぎょうが 仰臥"
"ぎょうがく 行学"
"ぎょうき 行基"
"ぎょうきょう 業況"
"ぎょうぎ 凝議 行儀"
"ぎょうくぎり 行区切り"
"ぎょうけい 行啓 行刑"
"ぎょうけつ 凝血 凝結"
"ぎょうこ 凝固"
"ぎょうこう 暁光 僥倖 行幸"
"ぎょうこつ 行乞"
"ぎょうさ 業作"
"ぎょうさい 業際"
"ぎょうさくじょ 行削除"
"ぎょうざ 餃子"
"ぎょうし 凝脂 仰視 凝視"
"ぎょうした 行下"
"ぎょうしてい 行指定"
"ぎょうしゃ 業社 業者"
"ぎょうしゅ 業種"
"ぎょうしゅう 凝聚 凝集"
"ぎょうしゅく 凝縮"
"ぎょうしょ 行書"
"ぎょうしょう 驍将 行商"
"ぎょうしょく 暁色"
"ぎょうしんせい 暁新世"
"ぎょうじ 行司 行事"
"ぎょうじゃ 行者"
"ぎょうじゅう 行住"
"ぎょうじょう 行上 行状"
"ぎょうじん 行人"
"ぎょうすう 行数"
"ぎょうずい 行水"
"ぎょうせい 暁星 行政"
"ぎょうせいいん 行政院"
"ぎょうせいばつ 行政罰"
"ぎょうせき 凝析 業績"
"ぎょうせん 暁泉"
"ぎょうせんとう 行先頭"
"ぎょうぜん 凝然"
"ぎょうぜんご 行前後"
"ぎょうそう 行草 形相"
"ぎょうそうにゅう 行挿入"
"ぎょうぞう 行三"
"ぎょうたい 凝滞 業態"
"ぎょうたん 行端"
"ぎょうたんい 行単位"
"ぎょうだ 行田"
"ぎょうちゃく 凝着"
"ぎょうちゅう 行中 蟯虫"
"ぎょうつう 暁通"
"ぎょうてん 暁天 仰天"
"ぎょうとう 行頭"
"ぎょうとく 行徳"
"ぎょうどう 行道"
"ぎょうない 行内"
"ぎょうにんべん 行人偏"
"ぎょうねん 行年"
"ぎょうはんい 行範囲"
"ぎょうばんごう 行番号"
"ぎょうぶ 行歩 刑部"
"ぎょうぶんかつ 行分割"
"ぎょうへんしゅう 行編集"
"ぎょうほう 行法"
"ぎょうほうこう 行方向"
"ぎょうぼう 仰望"
"ぎょうまつ 行末"
"ぎょうむ 暁霧 業務"
"ぎょうめ 行目"
"ぎょうゆう 驍勇"
"ぎょうよう 杏葉"
"ぎょうよく 楽欲"
"ぎょうりつ 凝立"
"ぎょうれつ 行列"
"ぎょうれつせき 行列積"
"ぎょえい 御影 魚影"
"ぎょえん 魚塩 御苑"
"ぎょか 魚蝦 御歌"
"ぎょかい 魚会 魚貝 魚介"
"ぎょかく 漁獲"
"ぎょかん 御感"
"ぎょがん 魚眼"
"ぎょがんれんず 魚眼レンズ"
"ぎょき 御忌 漁期"
"ぎょきょう 漁況 漁協"
"ぎょぎょう 漁業"
"ぎょく 魚鼓 閠 嶷 漁区 玉"
"ぎょくおん 玉音"
"ぎょくがん 玉顔"
"ぎょくさい 玉砕"
"ぎょくざ 玉座"
"ぎょくしょう 玉漿 玉将"
"ぎょくじ 玉璽"
"ぎょくずい 玉髄"
"ぎょくせい 玉成"
"ぎょくせき 玉石"
"ぎょくせん 玉泉"
"ぎょくせんどう 玉泉洞"
"ぎょくたい 玉体"
"ぎょくだい 玉代 玉台"
"ぎょくとう 玉頭 玉東"
"ぎょくはい 玉杯"
"ぎょくはく 玉帛"
"ぎょくひ 玉臂"
"ぎょくへん 玉篇"
"ぎょくもん 玉門"
"ぎょくもんかん 玉門関"
"ぎょくよう 玉葉"
"ぎょくりんじ 玉林寺"
"ぎょくろ 玉露"
"ぎょくろう 玉楼"
"ぎょぐ 漁具"
"ぎょぐん 魚群"
"ぎょけい 御慶 魚形"
"ぎょげんき 魚玄機"
"ぎょこ 魚鼓"
"ぎょこう 魚膠 漁港"
"ぎょさん 魚山"
"ぎょざ 御座"
"ぎょし 魚翅 漁史 御寝 御旨 御史"
"ぎょしゃ 漁者 馭者 御者"
"ぎょしゅ 魚種"
"ぎょしゅう 漁舟"
"ぎょしょう 漁礁 魚醤 魚礁"
"ぎょしょく 漁色"
"ぎょしん 御寝 魚信"
"ぎょじ 御璽"
"ぎょじょう 漁場"
"ぎょすい 魚水"
"ぎょせい 御製"
"ぎょせん 御撰 漁船"
"ぎょそう 魚巣 魚倉 魚艙 魚層"
"ぎょそん 漁村"
"ぎょぞく 魚族"
"ぎょたい 魚袋 魚体"
"ぎょたく 魚柝 魚拓"
"ぎょたん 魚探"
"ぎょだい 御題"
"ぎょちょう 魚鳥"
"ぎょちょうどめ 魚鳥止め"
"ぎょちょうひ 魚腸肥"
"ぎょっかん 玉冠"
"ぎょっき 玉器"
"ぎょっけい 玉茎"
"ぎょっこう 玉鉤 玉稿"
"ぎょてい 魚梯"
"ぎょでん 魚田"
"ぎょと 魚肚"
"ぎょとうゆ 魚灯油"
"ぎょどう 魚動 魚道"
"ぎょにく 魚肉"
"ぎょのう 魚脳"
"ぎょはん 魚飯"
"ぎょば 漁場"
"ぎょばん 魚板"
"ぎょひ 魚肥"
"ぎょひょう 魚鰾"
"ぎょび 魚尾"
"ぎょびょう 魚苗"
"ぎょふ 魚符 御府 漁夫"
"ぎょふく 魚腹"
"ぎょふん 魚粉"
"ぎょぶつ 御物"
"ぎょべつ 魚鼈"
"ぎょほう 漁法"
"ぎょぼく 魚木"
"ぎょみ 魚味"
"ぎょみん 漁民"
"ぎょめい 御名"
"ぎょもう 魚網 漁網"
"ぎょもくえんせき 魚目燕石"
"ぎょもつ 御物"
"ぎょもん 魚紋 魚文"
"ぎょゆ 魚油"
"ぎょらい 魚雷"
"ぎょらん 魚籃 魚卵"
"ぎょりゅう 魚竜 魚龍"
"ぎょりょう 魚綾 御綾 漁猟"
"ぎょりょうしゃくば 魚竜爵馬"
"ぎょりん 魚鱗"
"ぎょりんがかり 魚鱗懸かり 魚鱗懸り"
"ぎょりんずさつ 魚鱗図冊"
"ぎょりんせん 魚鱗癬"
"ぎょるい 魚類"
"ぎょれい 魚麗"
"ぎょれん 魚連"
"ぎょろ 魚魯"
"ぎょろう 魚蝋 漁撈 漁労"
"ぎょろめ ぎょろ目"
"ぎよう 偽葉 儀容"
"ぎようせい 疑陽性 偽陽性"
"ぎらい 儀礼"
"ぎり 切り 切 斬り 義理"
"ぎりしあ 希臘"
"ぎりしあご ギリシア語"
"ぎりしあしんわ ギリシア神話"
"ぎりしあてつがく ギリシア哲学"
"ぎりしゃ 希臘"
"ぎりしゃご ギリシャ語"
"ぎりしゃしんわ ギリシャ神話"
"ぎりしゃじん ギリシャ人"
"ぎりしゃせいきょうかい ギリシャ正教会"
"ぎりしゃてつがく ギリシャ哲学"
"ぎりしゃもじ ギリシャ文字"
"ぎりちょこ 義理チョコ"
"ぎりょう 技倆 議了 技量"
"ぎれ 切 裂"
"ぎれい 儀礼"
"ぎれつ 義烈"
"ぎれん 技連 議連"
"ぎろう 妓楼"
"ぎろん 議論"
"ぎわ 羲和 際"
"ぎわく 疑惑"
"ぎわだん 義和団"
"ぎわん 義腕"
"ぎん 斤 憖 崟 垠 岑 吟 銀"
"ぎんいち 銀一"
"ぎんいろ 銀色"
"ぎんうち 銀打"
"ぎんえい 吟詠"
"ぎんえいでん 銀英伝"
"ぎんえん 銀塩"
"ぎんか 銀花 銀貨"
"ぎんかい 銀塊"
"ぎんかいしょく 銀灰色"
"ぎんかく 銀閣"
"ぎんかくじみち 銀閣寺道"
"ぎんかん 銀漢"
"ぎんが 銀河"
"ぎんがてつどうのよる 銀河鉄道の夜"
"ぎんがみ 銀紙"
"ぎんき 銀器"
"ぎんきょう 銀鏡"
"ぎんぎつね 銀狐"
"ぎんぎょ 銀魚"
"ぎんこう 銀鉤 銀坑 銀鉱 吟行 銀行"
"ぎんこうかん 銀交換"
"ぎんこんしき 銀婚式"
"ぎんざ 銀座"
"ぎんざどおり 銀座通"
"ぎんざん 銀山"
"ぎんし 銀糸"
"ぎんしゃ 銀砂"
"ぎんしゃり 銀舎利 銀シャリ"
"ぎんしゅ 銀朱"
"ぎんしょう 吟嘯 吟誦 銀章 銀将 吟唱 銀賞"
"ぎんしょく 銀燭"
"ぎんしょっき 銀食器"
"ぎんじ 銀字 銀地 銀二 銀次"
"ぎんじょう 吟醸"
"ぎんす 銀子"
"ぎんすいしょう 銀水晶"
"ぎんすじ 銀筋"
"ぎんすなご 銀砂子"
"ぎんずいしょう 銀水晶"
"ぎんせい 銀星 吟声 銀製"
"ぎんせかい 銀世界"
"ぎんせつ 銀雪"
"ぎんせん 銀銭 銀川 銀線 銀泉"
"ぎんぞう 銀蔵"
"ぎんだま 銀玉"
"ぎんだまでっぽう 銀玉鉄砲"
"ぎんだら 銀鱈"
"ぎんでい 銀泥"
"ぎんどけい 銀時計"
"ぎんなん 銀杏"
"ぎんねこ 銀猫"
"ぎんねず 銀鼠"
"ぎんねずみ 銀鼠"
"ぎんのさじ 銀の匙"
"ぎんはくしょく 銀白色"
"ぎんば 銀歯"
"ぎんばん 銀盤"
"ぎんばんしゃしん 銀板写真"
"ぎんぱ 銀波"
"ぎんぱい 銀盃 銀杯"
"ぎんぱく 銀箔"
"ぎんぱつ 銀髪"
"ぎんぶち 銀縁"
"ぎんぶら 銀ぶら 銀ブラ"
"ぎんぷん 銀粉"
"ぎんぷんちょう 銀粉蝶"
"ぎんべえ 銀兵衛"
"ぎんほんい 銀本位"
"ぎんぼし 銀星"
"ぎんぽ 銀宝"
"ぎんまく 銀幕"
"ぎんみ 吟味"
"ぎんむく 銀無垢"
"ぎんめだりすと 銀メダリスト"
"ぎんめだる 銀メダル"
"ぎんめっき 銀メッキ 銀鍍金"
"ぎんめん 銀面"
"ぎんもくせい 銀木犀"
"ぎんもじ 銀文字"
"ぎんゆう 吟遊"
"ぎんよく 銀翼"
"ぎんらん 銀蘭"
"ぎんりょうそう 銀竜草"
"ぎんりん 銀鈴 銀輪 銀鱗"
"ぎんれい 銀鈴 銀嶺"
"く ９ 功 庫 宮 久 工 口 供 桍 鳩 紅 垢 玖 来 窶 柧 吁 矩 衢 瞿 懼 惧 貢 倶 孔 吼 鉤 煦 枸 怐 劬 拘 駒 狗 區 嶇 驅 駈 駆 躯 九 句 区 苦"
"くーにゃん 姑娘"
"くーぽんけん クーポン券"
"くーりー 苦力"
"くい 九位 久井 悔 杙 句意 悔い 杭"
"くいあげ 食い上げ"
"くいあわせ 食合せ 食い合せ 食い合わせ"
"くいいじ 食い意地"
"くいうち 杭打ち"
"くいき 区域"
"くいきそ 杭基礎"
"くいけ 食い気"
"くいしろ 食い代"
"くいしんぼう 食いしん坊"
"くいずばんぐみ クイズ番組"
"くいぜ 株 杭"
"くいぞめ 食い初め"
"くいたん 杭端"
"くいだおれ 食い倒れ"
"くいだめ 食い溜め"
"くいちがい 食い違い"
"くいで 食い出"
"くいとう 杭頭"
"くいどうらく 喰い道楽 食い道楽 食道楽"
"くいな 秧鶏 水鶏"
"くいにげ 食い逃げ"
"くいのこし 食い残し"
"くいぶち 食扶持 食い扶持"
"くいぶん 食い分"
"くいほうだい 喰い放題 食い放題"
"くいもの 喰い物 食い物"
"くいん 庫院"
"くう 刧 劫 φ 腔 空"
"くうあつ 空圧"
"くうい 空尉 空位"
"くういき 空域"
"くうかい 空回 空界 空海"
"くうかぶ 空株"
"くうかん 空間"
"くうかんち 空閑地"
"くうかんひずみ 空間歪"
"くうが 空牙"
"くうがん 空観"
"くうき 空気"
"くうきあな 空気穴"
"くうきじゅう 空気銃"
"くうきょ 空虚"
"くうぎょう 空行"
"くうくうじゃくじゃく 空々寂々 空空寂寂"
"くうくうばくばく 空々漠々 空空漠漠"
"くうぐん 空軍"
"くうけい 空閨"
"くうけん 空拳"
"くうげき 空隙"
"くうげん 空言"
"くうこう 空孔 空港"
"くうこく 空谷"
"くうご 空語"
"くうさ 空佐"
"くうさい 空際"
"くうさつ 空撮"
"くうし 空士"
"くうしつ 空室"
"くうしゃ 空車"
"くうしゅう 空襲"
"くうしゅうごう 空集合"
"くうしょ 空所"
"くうしょう 空将"
"くうじ 空自"
"くうじゃく 空寂"
"くうせい 空制"
"くうせき 空席"
"くうせつ 空節 空説"
"くうせん 空戦"
"くうぜん 空前"
"くうそ 空疎"
"くうそう 空曹 空想"
"くうそうきょり 空走距離"
"くうそくぜしき 空即是色"
"くうたい 空諦"
"くうたいくう 空対空"
"くうたいち 空対地"
"くうだん 空談"
"くうち 空地"
"くうちゅう 空中"
"くうちゅうぶらんこ 空中ブランコ"
"くうちょう 空腸 空調"
"くうてい 空挺"
"くうてがた 空手形"
"くうてん 空転"
"くうでん 空電"
"くうとりひき 空取引"
"くうどう 空洞"
"くうにゅうりょく 空入力"
"くうねんぴ 空燃費"
"くうはく 　 空白"
"くうばく 空漠 空爆"
"くうひ 空飛 空費"
"くうびん 空便"
"くうふく 空腹"
"くうぶん 空文"
"くうほう 空包 空胞 空砲"
"くうぼ 空母"
"くうぼうそう 空乏層"
"くうむ 空無"
"くうめい 空名"
"くうもじ 空文字"
"くうや 空夜 空也"
"くうやくわず 食うや食わず"
"くうゆ 空輸"
"くうらん 空欄"
"くうり 空理"
"くうりき 空力"
"くうりく 空陸"
"くうりすと 空リスト"
"くうりょくてき 空力的"
"くうれい 空冷"
"くうれつ 空列"
"くうろ 空路"
"くうろん 空論"
"くえ 柵 垢穢 九絵 九会"
"くえい 区営"
"くえき 駆役 苦役"
"くえん 枸櫞"
"くえんさん クエン酸"
"くおん 久遠"
"くおんじつじょう 久遠実成"
"くか 探湯 久賀"
"くかい 苦海 苦界 区会 句会"
"くかく 区劃 区画"
"くかた 久方"
"くかたち 誓湯 探湯"
"くかつよう ク活用"
"くかん 苦艱 躯幹 区間"
"くが 玖賀 玖珂 久我 陸"
"くがい 公界 苦界 区外"
"くがいそう 九蓋草"
"くがく 苦学"
"くがたち 誓湯 探湯"
"くがつ 長月 ９月 九月"
"くがつひめ 九月姫"
"くがみらくづめ 苦髪楽爪"
"くがら 句柄"
"くき 莖 九鬼 久喜 茎"
"くきざき 茎崎"
"くきしゅうぞう 九鬼周造"
"くきまきひげ 茎巻鬚"
"くきもと 久木元"
"くきゅう 区急"
"くきょう 句境 苦境"
"くぎ 供犠 区議 釘"
"くぎあな 釘穴"
"くぎうち 釘打ち 釘打"
"くぎかくし 釘隠し"
"くぎし 釘師"
"くぎちょうせい 釘調整"
"くぎづけ 釘付け"
"くぎどめ 釘止め"
"くぎに 釘煮"
"くぎぬき 釘貫 釘抜き"
"くぎの 久木野"
"くぎみや 釘宮"
"くぎもと 釘本"
"くぎょう 恭敬 公卿 苦行"
"くぎり 句切 句切り 区切"
"くぎれ 句切れ"
"くぎん 苦吟"
"くく 煦々 区区 九九 区々"
"くくりぞめ 纐"
"くぐ 莎草"
"くぐい 鵠"
"くぐつ 裹 傀儡"
"くぐつめ 傀儡女"
"くぐの 久々野"
"くぐりど 潜り戸"
"くけい 区系 矩形"
"くけいばん 矩形板"
"くけいまど 矩形窓"
"くけつ 口訣"
"くけん 区検"
"くげ 久下 公卿 公家"
"くげぬま 鵠沼"
"くげん 苦患 苦言"
"くこ 枸杞"
"くこう 句稿"
"くこうぞう 句構造"
"くご 箜篌 供御"
"くごう 口業 久郷"
"くごほう く語法 ク語法"
"くさ 日 艸 種 草"
"くさい Ξ ξ"
"くさいきれ 草いきれ"
"くさいもの 臭い物"
"くさいろ 草色"
"くさうお 草魚"
"くさえんじゅ 草槐"
"くさお 草尾"
"くさか 久坂 日下"
"くさかい 草開 草皆"
"くさかり 草苅 草刈り 草刈"
"くさかりがま 草刈り鎌"
"くさかんむり 草冠"
"くさがき 草垣"
"くさがみ 草上"
"くさき 草木"
"くさく 句作"
"くさぐさ 種種 種々"
"くさけいば 草競馬"
"くさずもう 草相撲"
"くさせんり 草千里"
"くさぞうし 草双紙"
"くさたいかい 草大会"
"くさたけ 草丈"
"くさだんご 草団子"
"くさち 草地"
"くさつ 草津"
"くさつぶし 草津節"
"くさとり 草取り"
"くさなぎ 草薙"
"くさなぎのつるぎ 草薙剣"
"くさの 草野"
"くさのしんぺい 草野心平"
"くさのね 草の根"
"くさのは 草の葉"
"くさは 草葉"
"くさはら 草原"
"くさば 草葉 草場"
"くさばな 草花"
"くさばのかげ 草葉の陰"
"くさび 楔"
"くさびがた 楔形"
"くさびら 草片 菌 茸"
"くさぶえ 草笛"
"くさぶし 草臥し"
"くさま 日馬 草間"
"くさまくら 草枕"
"くさみ 臭み"
"くさむしり 草毟り"
"くさむら 草叢 叢"
"くさめ 嚔"
"くさもち 草餅"
"くさや 草屋"
"くさやきゅう 草野球"
"くさやなぎ 草柳"
"くさやね 草屋根"
"くさよもぎ 藾"
"くさり 鏈 鎖"
"くさりあみ 鎖編み"
"くさりかたびら 鎖帷子"
"くさりがま 鎖鎌"
"くさりじょう 鎖状"
"くされ 腐れ"
"くされえん 腐れ縁"
"くさわい 種"
"くさわけ 草分 草分け"
"くざい 句材"
"くし 梳 髪 酒 口詩 苦使 苦死 句誌 口四 櫛 駆使 串"
"くしー Ξ ξ"
"くしあげ 串揚げ"
"くしかつ 串カツ"
"くしがた 櫛型 櫛形"
"くしがはま 櫛ケ浜"
"くしきの 串木野"
"くしくも 奇しくも"
"くしくらげ 櫛水母"
"くしげ 櫛笥"
"くしさし 串刺"
"くしざし くし刺し 串刺 串刺し"
"くしだ 串田 櫛田"
"くしだんご 串団子"
"くしなだひめ 奇稲田姫"
"くしはら 櫛原 串原"
"くしびき 櫛引"
"くしま 久嶋 串間"
"くしまうみ 久島海"
"くしめ 櫛目"
"くしもと 串本"
"くしもとぶし 串本節"
"くしゃ 倶舎"
"くしゃみ 嚔"
"くしやき 串焼 串焼き"
"くしやま 串山"
"くしゅう 句集"
"くしょ 区処"
"くしょう 苦笑"
"くしら 串良"
"くしりょうり 串料理"
"くしろ 釧 釧路"
"くしん 苦辛 苦心"
"くじ 籖 九時 九字 公事 鬮 籤 久慈"
"くじうん くじ運 籤運"
"くじびき くじ引き 籤引き"
"くじまと 鬮的"
"くじゃく 孔雀"
"くじゅ 口授"
"くじゅう 久住 苦汁 苦渋"
"くじゅうくり 九十九里"
"くじゅうくりはま 九十九里浜"
"くじょ 駆除"
"くじょう 宮絛 九条 苦情"
"くじら 鯀 鯨"
"くじらあぶら 鯨油"
"くじらい 鯨井"
"くじらおか 鯨岡"
"くじらざ 鯨座"
"くじらじゃく 鯨尺"
"くじらじる 鯨汁"
"くじらひげ 鯨鬚"
"くじらまく 鯨幕"
"くじらりょうり 鯨料理"
"くじん 苦参"
"くす 玖珠 樟 楠"
"くすいこ 公出挙"
"くすう 句数"
"くすおか 楠岡"
"くすこ 薬子"
"くすし 薬師"
"くすだ 楠田"
"くすだま くす玉 薬玉"
"くすね 藥煉 天鼠矢 薬煉"
"くすのき 樟 楠木 楠"
"くすのきあか クスノキ亜科"
"くすのきか クスノキ科"
"くすのきまさしげ 楠正成"
"くすのせ 楠瀬"
"くすのは 樟葉"
"くすのもり 楠ノ森"
"くすはら 楠原"
"くすび 鐃"
"くすみ 楠見"
"くすもと 楠元 楠本"
"くすやま 楠山"
"くすり 藥 薬"
"くすりうり 薬売り"
"くすりがけ 釉掛 釉掛け"
"くすりし 薬師"
"くすりづけ 薬漬け"
"くすりのつかさ 薬司 典薬寮"
"くすりばこ 薬箱"
"くすりぶくろ 薬袋"
"くすりぶろ 薬風呂"
"くすりみず 薬水"
"くすりや 薬屋"
"くすりゆ 薬湯"
"くすりゆび 薬指"
"くすんごぶ 九寸五分"
"くず 葛 屑"
"くずいと 屑糸"
"くずいも 葛芋"
"くずう 葛生"
"くずおか 葛岡"
"くずかご 屑篭 屑籠"
"くずきじ 屑記事"
"くずきり 葛切 葛切り"
"くずこ 葛粉"
"くずごめ 屑米"
"くずしがき 崩し書き"
"くずしじ 崩し字"
"くずてつ 屑鉄"
"くずは 葛葉 楠葉"
"くずはら 葛原"
"くずひろい 屑拾い"
"くずまい 屑米"
"くずまき 葛巻"
"くずみ 久住"
"くずもち 葛餅"
"くずもの 屑物"
"くずや 屑屋"
"くずゆ 葛湯"
"くずりゅう 九頭竜"
"くずりゅうこ 九頭竜湖"
"くずれ 崩れ"
"くせ 久世 救世 曲 癖"
"くせい 区政"
"くせげ くせ毛 癖毛"
"くせごと 曲事"
"くせつ 苦節"
"くせなおし 癖直し"
"くせまい 曲舞"
"くせもの 癖者 曲者"
"くせん 苦戦"
"くせんてい 駆潜艇"
"くぜ 久瀬 久世"
"くぜち 口説"
"くぜつ 口舌 口説"
"くそ 屎 糞"
"くそう 九想 九相"
"くそがき 糞ガキ"
"くそぢから クソ力 糞力"
"くそばえ 糞蠅"
"くそぶくろ 糞袋"
"くそまじめ クソ真面目"
"くそむし 糞虫"
"くたい 苦諦 躯体"
"くたかけ 鶏"
"くたにやき 九谷焼"
"くたばりぞこない くたばり損ない"
"くたびれもうけ 草臥れ儲け"
"くたんもん 狗蜑門"
"くだ 管"
"くだい 句題"
"くだぎつね 管狐"
"くだけ 砕け"
"ください 下さい"
"くだされたく 被下度"
"くだされもの 下され物"
"くだしぐすり 下し薬"
"くだしぶみ 下文"
"くだたま 管玉"
"くだばしら 管柱"
"くだまつ 下松"
"くだもの 果物"
"くだものないふ 果物ナイフ"
"くだら 百濟 百済"
"くだり 条 件 下り"
"くだりげぎょ 降り懸魚"
"くだりざか 下り坂"
"くだりむね 降り棟"
"くだん 件 九段"
"くだんきた 九段北"
"くち 口"
"くちあたり 口当り 口当たり"
"くちいがい 口以外"
"くちいれ 口入れ"
"くちうつし 口移し"
"くちうら 口占 口裏"
"くちえ 口絵"
"くちおも 口重"
"くちかず 口数"
"くちかせ 口枷"
"くちがき 口書"
"くちがため 口固め"
"くちがたり 口語り"
"くちがね 口金"
"くちがる 口軽"
"くちき 口木 朽ち木 朽木"
"くちきき 口利き"
"くちきり 口切り"
"くちく 苦竹 駆逐"
"くちぐせ 口ぐせ 口癖"
"くちぐち 口々"
"くちぐるま 口車"
"くちげんか 口喧嘩"
"くちことば 口言葉 口詞"
"くちこみ 口コミ"
"くちごたえ 口答え"
"くちさき 吻 口先"
"くちざわり 口触り"
"くちしのぎ 口凌ぎ"
"くちじお 口塩"
"くちじゃみせん 口三味線"
"くちじょうず 口上手"
"くちすう 口数"
"くちすぎ 口過ぎ"
"くちせん 口銭"
"くちぞえ 口添え"
"くちた 口田"
"くちたっしゃ 口達者"
"くちだし 口出し"
"くちだっしゃ 口達者"
"くちづけ 口付け 口づけ"
"くちづたえ 口伝え"
"くちづて 口伝 口伝て"
"くちとり 口取"
"くちど 口疾"
"くちどけ 口溶け"
"くちどめ 口止め"
"くちなおし 口直し"
"くちなし 口無し 山梔子 梔 梔子"
"くちならし 口慣らし"
"くちなわ 蛇"
"くちぬの 口布"
"くちのつ 口之津"
"くちのは 朽葉 口の端"
"くちのまち 口ノ町"
"くちは 朽葉"
"くちはっちょう 口八丁"
"くちば 朽ち葉 朽葉"
"くちばし 喙 嘴"
"くちばや 口早"
"くちぱく 口パク"
"くちひげ 髭 口髭"
"くちび 口火"
"くちびょうし 口拍子"
"くちびる 口唇 脣 唇"
"くちふうじ 口封じ"
"くちぶえ 口笛"
"くちぶり 口ぶり 口振り"
"くちへん 口偏"
"くちへんとう 口返答"
"くちべた 口下手"
"くちべに 口紅"
"くちべらし 口減らし"
"くちほど 口ほど 口程"
"くちまえ 口前"
"くちまかせ 口任せ"
"くちまね 口真似"
"くちむろ 口むろ"
"くちもと 口許 口元"
"くちゃ 苦茶"
"くちやくそく 口約束"
"くちゅう 苦衷 駆虫"
"くちょう 句調 区長 口調"
"くちよごし 口汚し"
"くちよせ 口寄せ"
"くちわ 口和"
"くちわき 口脇"
"くちわる 口悪"
"くっき 崛起"
"くっきょう 倔強 究竟 屈強"
"くっきょく 屈曲"
"くっきん 屈筋"
"くっこうせい 屈光性"
"くっさく 掘鑿 掘削"
"くっさめ 嚔"
"くっし 屈指"
"くっしゃろこ 屈斜路湖"
"くっしん 掘進 屈伸"
"くっせい 屈性"
"くっせつ 屈折"
"くっそう 屈葬"
"くったく 屈託"
"くっちせい 屈地性"
"くっちゃん 倶知安"
"くっぷく 屈伏 屈服"
"くつ 崛 倔 窟 掘 屈 鞋 履 沓 靴"
"くつあと 靴跡"
"くつう 苦痛"
"くつおと 靴音"
"くつかけ 沓掛"
"くつかぶり 沓冠"
"くつかむり 沓冠"
"くつかわ 沓川"
"くつがた 靴型 沓形"
"くつき 朽木"
"くつこ 口籠"
"くつこうぶり 沓冠"
"くつさわ 沓沢"
"くつざわ 沓沢 沓澤"
"くつした 沓下 くつ下 靴下"
"くつしたどめ 靴下留め"
"くつじゅう 屈従"
"くつじょく 屈辱"
"くつずれ 靴擦れ"
"くつぞこ 靴底"
"くつてん 靴店"
"くつね 狐"
"くつばこ 靴箱"
"くつばみ 轡"
"くつひも 靴紐"
"くつみ 九津見 久津見"
"くつみがき 靴磨き"
"くつや 靴屋"
"くつわ 銜 轡"
"くつわだ 轡田"
"くつわむし 轡虫"
"くづめらくがみ 苦爪楽髪"
"くてん 九天 区点 句点"
"くてんこーど 区点コード"
"くで 湫"
"くでん 口伝"
"くとう 久東 句読 苦闘"
"くとうじょ 旧唐書"
"くど 苦土"
"くどう 区道 久道 宮藤 工藤 駆動"
"くどうし 句動詞"
"くどお 久遠"
"くどき 口説き"
"くどきぶし 口説節"
"くどく 功徳"
"くどやま 九度山"
"くどん 瞿曇"
"くない 苦無 工内 宮内 区内"
"くながい 婚"
"くなこく 狗奴国"
"くなしり 国後"
"くなり 九那里"
"くなん 苦難"
"くに 久邇 六合 國 圀 訓 邦 国"
"くにあき 国明 国昭 邦昭 邦明"
"くにい 國井 国井"
"くにいっき 国一揆"
"くにいり 国入り"
"くにうみ 国生み"
"くにえだ 國枝 国枝"
"くにお 邦央 久仁雄 邦生 國雄 国雄 国夫 国男 邦男 邦雄 邦夫"
"くにおもて 国表"
"くにかず 邦和"
"くにかた 國方"
"くにかね 国包"
"くにがえ 国替え 国替"
"くにがまえ 国構え"
"くにがみ 国頭"
"くにがら 国柄"
"くにがろう 国家老"
"くにがわ 国側"
"くにきだ 国木田"
"くにきょうかい 国協会"
"くにく 狗肉 苦肉"
"くにくのさく 苦肉の策"
"くにぐに 国々"
"くにこ 都子 くに子 久仁子 邦子"
"くにこう 国高"
"くにことば 国言葉"
"くにさか 国坂"
"くにさき 国東"
"くにさだ 國貞 国貞"
"くにさわ 国沢"
"くにざかい 国境"
"くにざね 国実"
"くにざむらい 国侍"
"くにしげ 国重"
"くにしま 国島"
"くにしゅどう 国主導"
"くにじ 邦次"
"くにじま 国島"
"くにじゅう 国中"
"くにせん 国線"
"くにぜんたい 国全体"
"くにたいこう 国対抗"
"くにたち 国立"
"くにたみ 国人 国民"
"くにだ 国田"
"くにつかみ 地祇 国つ神 国津神"
"くにつつみ 国つ罪"
"くにつな 国綱"
"くにづくり 国造り"
"くにてがた 国手形"
"くにとみ 国富"
"くにとも 邦朋 國友 国友"
"くにとり 国取り"
"くにとりものがたり 国盗物語"
"くになまり 国訛 国訛り"
"くになり 邦成"
"くにのとこたちのみこと 国常立尊"
"くにのぶ 国信"
"くにのみや 久邇宮"
"くにのみやつこ 国造"
"くにはま 国浜"
"くにはる 邦明 邦治"
"くにばんごう 国番号"
"くにひこ 國彦 国彦 邦彦"
"くにひさ 国久 邦久"
"くにひと 邦仁"
"くにひろ 訓弘 国博 邦宏 邦洋 国広"
"くにびと 国人"
"くにふじ 國藤"
"くにふみ 邦文"
"くにぶり 国風 国振り"
"くにべつ 国別"
"くにまさ 邦匡 国政"
"くにまつ 國松"
"くにまつり 国祭"
"くにみ 国見"
"くにみつ 州光 國光 国光"
"くにむね 國宗"
"くにもち 国持"
"くにもと 国本"
"くにものがたり 国物語"
"くにやき 国焼"
"くにやしょてん 国屋書店"
"くにやす 国泰 國安 国安"
"くにゆき 邦之"
"くにゆずり 国譲り"
"くによし 國義 邦義 國吉 国吉"
"くぬが 陸"
"くぬぎ 功力 栩 椪 椢 椡 櫪 功刀 檪 橡 椚 櫟"
"くねつ 苦熱"
"くねん 九年"
"くねんぼ 九年母"
"くの 久野"
"くのいち くノ一"
"くのう 功能 久能 苦悩"
"くのうざん 久能山"
"くのぎ 櫟"
"くのくら 玄倉"
"くのじてん くの字点"
"くのへ 九戸"
"くはい 苦杯"
"くはら 久原"
"くば 玖場 久場"
"くひ 句碑"
"くび 馘首 馘 頚 頸 首"
"くびおけ 首桶"
"くびかざり 珞 頸飾り 首飾 首飾り"
"くびかせ 首枷"
"くびき 頚城 軛"
"くびきり 首切 首切り"
"くびくくり 首縊り"
"くびさ 首差"
"くびしめ 首締"
"くびじっけん 首実検"
"くびす 跟 踵"
"くびすじ 首筋"
"くびぞくちょう 狗尾続貂"
"くびったけ 首ったけ 首っ丈"
"くびっぴき 首っ引き"
"くびつり 首吊 首吊り"
"くびづか 首塚"
"くびなが 首長"
"くびながりゅう 首長竜"
"くびなげ 首投げ"
"くびね 首根"
"くびねっこ 首根っこ"
"くびひき 首引き 首引"
"くびひねり 首捻り"
"くびふり 首振り"
"くびまわり 頸廻り 首回り"
"くびら 宮毘羅"
"くびれ 括れ"
"くびわ 首輪"
"くふう 句風 工夫"
"くぶ 九分 区部"
"くぶん 区分"
"くぶんでん 口分田"
"くへ 柵"
"くへんとう 苦扁桃"
"くべつ 区別"
"くほう 句法"
"くほんぶつ 九品仏"
"くぼ 玖保 凹 窪 久保"
"くぼう 久宝 公方"
"くぼかわ 久保川 窪川"
"くぼがみ 久保上"
"くぼき 久保木"
"くぼさわ 久保沢"
"くぼた 窪田 久保田"
"くぼち くぼ地 窪地"
"くぼづか 窪塚"
"くぼでら 窪寺 久保寺"
"くぼの 窪野"
"くぼや 窪谷"
"くま 久万 球磨 隈 熊"
"くまい 熊井"
"くまいざさ 九枚笹"
"くまいし 熊石"
"くまいでん 供米田"
"くまがい 熊谷"
"くまがね 熊ヶ根"
"くまがや 熊谷"
"くまくす 熊楠"
"くまくら 熊倉"
"くまぐす 熊楠"
"くまげ 熊毛"
"くまげら 熊啄木鳥"
"くまこう 熊公"
"くまさか 熊坂"
"くまさき 熊崎"
"くまさわ 熊沢"
"くまざさ 隈笹 熊笹"
"くまざわ 熊沢"
"くまぜみ 熊蝉"
"くまそ 熊襲"
"くまたか 熊鷹"
"くまだ 隈田 熊田"
"くまだい 熊大"
"くまつづら 熊葛"
"くまつづらか クマツヅラ科"
"くまで 熊手"
"くまとり 熊取"
"くまどり 隈取り"
"くまなく 隈なく 隈無く"
"くまねこ 熊猫"
"くまの 熊野"
"くまのい 熊の胆 熊胆"
"くまのなだ 熊野灘"
"くまはち 熊八"
"くまばち 熊蜂"
"くまもと 隈本 熊本"
"くまやま 熊山"
"くまらじゅう 鳩摩羅什"
"くまんばち 熊ん蜂"
"くみ 公美 久美 与 苦味 組"
"くみあい 組合"
"くみあげ 九美上 組上げ 組み上げ"
"くみあわせ 組み合せ 組合せ 組み合わせ"
"くみいれ 組入れ"
"くみいん 組員"
"くみうた 組歌"
"くみえ 久美恵"
"くみおき 汲置き 汲み置き"
"くみかえ 組替え 組換え 組み替え 組み換え"
"くみかた 組み方"
"くみがしら 組頭"
"くみきょく 組曲"
"くみこ 玖海子 クミ子 公美子 久美子"
"くみこみ 組込 組み込み"
"くみした 組下"
"くみしゃしん 組写真"
"くみたい 組対"
"くみたいそう 組体操"
"くみたて 組立て 組み立て 組立"
"くみだし 汲み出し"
"くみちがい 組み違い"
"くみちょう 組長"
"くみつ 口密"
"くみつけ 組付け 組み付け 組付"
"くみて 組手 組み手"
"くみとり 汲み取り"
"くみはば 組幅"
"くみはま 久美浜"
"くみはん 組み版 組版"
"くみばん 組版"
"くみひも 組紐"
"くみみほん 組見本"
"くみめい 組名"
"くみもの 組物"
"くみやしき 組屋敷"
"くみやま 久御山"
"くみわけ 組分け 組み分け"
"くみん 区民"
"くむら 久村"
"くめ 粂 久米"
"くめい 苦鳴 区名"
"くめうた 久米歌"
"くめうち 粂内"
"くめた 久米田"
"くめだ 久米田"
"くめなん 久米南"
"くめの 粂野"
"くめのせんにん 久米の仙人"
"くめひろし 久米宏"
"くめん 工面"
"くも 蜘 蜘蛛 雲"
"くもあし 雲脚"
"くもあひ 雲合"
"くもい 雲居 雲井"
"くもいのかり 雲井の雁"
"くもおとこ 蜘蛛男"
"くもかすみ 雲霞"
"くもがくれ 雲隠 雲隠れ"
"くもがた 雲形"
"くもがたじょうぎ 雲型定規"
"くもがみ 雲紙"
"くもきり 雲霧"
"くもすけ 雲助"
"くもつ 貢物 供物"
"くもとりやま 雲取山"
"くものい 雲乃井"
"くものいと 蜘蛛の糸"
"くものうえ 雲の上"
"くものうえびと 雲の上人"
"くものこ 蜘蛛の子"
"くものす クモの巣 蜘蛛の巣"
"くもま 雲間"
"くもまく クモ膜 くも膜 蜘蛛膜"
"くもまくかしゅっけつ クモ膜下出血 蜘蛛膜下出血"
"くもゆき 雲行 雲行き"
"くもり 曇 曇り"
"くもりぞら 曇り空"
"くもりどめ 曇り止め"
"くもん 久門 公文 苦悶"
"くやく 旧訳"
"くやし 悔し"
"くやしなみだ 悔し涙"
"くやま 久山"
"くやみ 悔み 悔やみ"
"くやみごと 悔み言"
"くゆう 区有"
"くよう 九曜 供養"
"くようせい 九曜星"
"くようとう 供養塔"
"くら 峅 藏 庫 鞍 倉 蔵"
"くらあく 暗悪"
"くらい 位"
"くらいあんとがわ クライアント側"
"くらいし 倉石"
"くらいだおれ 位倒れ"
"くらいどり 位取り"
"くらいまけ 位負け"
"くらいり 蔵入"
"くらいれ 倉入"
"くらうち 蔵内"
"くらうつし 倉移"
"くらうど 蔵人"
"くらかけ 倉掛"
"くらかげ 鞍掛"
"くらかた 倉片 倉方"
"くらがえ 鞍替 鞍替え"
"くらがり 暗がり 闇"
"くらがりとうげ 暗峠"
"くらき 倉木"
"くらく 苦楽"
"くらくえんぐち 苦楽園口"
"くらげ 鮓 水母 海月"
"くらさ 暗さ"
"くらさき 倉崎"
"くらさわ 倉沢"
"くらざらえ 蔵浚え"
"くらし 暮し 暮らし"
"くらしき 倉敷"
"くらしげ 倉茂 倉重"
"くらした 蔵下"
"くらしっくおんがく クラシック音楽"
"くらしな 倉品"
"くらしま 倉島"
"くらすかい クラス会"
"くらすがえ クラス替え"
"くらすたーばくだん クラスター爆弾"
"くらすべつ クラス別"
"くらた 鞍田 蔵田 倉田"
"くらたけ 倉岳"
"くらたや 蔵田家"
"くらだし 庫出し 蔵出し"
"くらち 倉知"
"くらづくり 蔵造り"
"くらて 鞍手"
"くらとみ 倉富"
"くらに 倉荷"
"くらの 蔵野"
"くらのうち 蔵之内"
"くらのすけ 内蔵助"
"くらはし 倉橋"
"くらはら 倉原"
"くらばらい 蔵払い"
"くらびらき 蔵開き"
"くらふとし クラフト紙"
"くらぶ 倶楽部"
"くらぶいん クラブ員"
"くらぶかつどう クラブ活動"
"くらぶけい クラブ系"
"くらぶち 倉淵"
"くらべ 倉部"
"くらべもの 較べ物 比べ物"
"くらぼね 鞍橋"
"くらま 蔵間 鞍馬"
"くらまい 蔵米"
"くらまえ 藏前 蔵前"
"くらまごけ 鞍馬苔"
"くらまた 倉又"
"くらまち 蔵町"
"くらめ 暗め"
"くらもち 倉持"
"くらもと 倉元 蔵本 倉本 蔵元"
"くらやしき 蔵屋敷"
"くらやみ 暗闇"
"くらよし 倉吉"
"くらら 苦参"
"くらわたし 倉渡し"
"くらんど 蔵人"
"くり 繰り 繰 涅 庫裡 庫裏 栗"
"くりーにんぐし クリーニング師"
"くりーにんぐや クリーニング屋"
"くりーむいろ クリーム色"
"くりーむじょう クリーム状"
"くりーむに クリーム煮"
"くりあげ 繰上げ"
"くりあん 栗あん 栗餡"
"くりいし 栗石"
"くりいれ 繰入れ 繰入"
"くりいろ 涅色 栗色"
"くりうめ 栗梅"
"くりお 栗生"
"くりかえ 繰替え"
"くりかえし 仝 〃 ヾ ヽ ゞ ゝ 々 繰りかえし 繰返し"
"くりかた 栗形"
"くりかのこ 栗鹿の子"
"くりから 倶利迦羅 倶利伽羅"
"くりからもんもん 倶利迦羅紋紋"
"くりき 功力"
"くりきんとん 栗金団"
"くりげ 栗毛"
"くりここくさい 栗子国際"
"くりこし 繰越し 繰り越し 繰越"
"くりことば 繰言葉"
"くりこま 栗駒"
"くりごと 繰言 繰り言"
"くりごはん 栗ご飯 栗御飯"
"くりさげ 繰下げ"
"くりさわ 栗沢"
"くりしま 栗島"
"くりす 栗栖"
"くりすますしょうせん クリスマス商戦"
"くりすますろーずあか クリスマスローズ亜科"
"くりた 栗太 栗田"
"くりっくかん クリック感"
"くりつ 栗津 区立"
"くりど 繰り戸"
"くりねずみ 栗鼠"
"くりの 栗野"
"くりのべ 繰延べ 繰延"
"くりはし 栗橋"
"くりはま 久里浜"
"くりはら 久利原 栗原"
"くりはらこまき 栗原小巻"
"くりはらん 栗葉蘭"
"くりばやし 栗林"
"くりひろい 栗拾い"
"くりまんじゅう 栗饅頭"
"くりみあせんそう クリミア戦争"
"くりめし 栗飯"
"くりもと 栗源 栗本"
"くりもどし 繰戻"
"くりや 廚 厨"
"くりやがわ 栗谷川 厨川"
"くりやま 栗山"
"くりゅう 九龍"
"くりょ 苦慮"
"くりようかん 栗羊羹"
"くりん 九厘 九輪"
"くる 久留"
"くるい 狂い"
"くるいざき 狂咲"
"くるいじに 狂い死に"
"くるしまぎれ 苦し紛れ"
"くるしみ 苦しみ"
"くるす 来須"
"くるすがわ 来栖川"
"くるすの 栗栖野"
"くるとし 来る年"
"くるひ 来る日"
"くるびょう 佝僂病"
"くるぶし 踝"
"くるま 俥 車"
"くるまいがい 車以外"
"くるまいす 車いす 車イス 車椅子"
"くるまいぞんしゃかい 車依存社会"
"くるまいちだいぶん 車一台分"
"くるまいど 車井戸"
"くるまえび 車蝦 車エビ 車海老"
"くるまかんけい 車関係"
"くるまかんれん 車関連"
"くるまがえし 車返し"
"くるまがわ 車側"
"くるまこうにゅうじ 車購入時"
"くるまさんぎょう 車産業"
"くるまざ 車座"
"くるまざき 車折"
"くるまざっし 車雑誌"
"くるましゃかい 車社会"
"くるまじ 車路"
"くるまじたい 車自体"
"くるまぜんたい 車全体"
"くるまたに 車谷"
"くるまだ 車田"
"くるまだい 車代"
"くるまちん 車賃"
"くるまつうがく 車通学"
"くるまづか 車塚"
"くるまとう 車糖"
"くるまどうし 車同志 車同士"
"くるまどおり 車通り"
"くるまどめ 車止 車止め"
"くるまぶんか 車文化"
"くるまへん 車偏"
"くるまや 車屋"
"くるまやど 車宿"
"くるまやま 車山"
"くるまゆうせん 車優先"
"くるまゆり 車百合"
"くるまよい 車酔 車酔い"
"くるまよう 車用"
"くるまよせ 車寄せ"
"くるまりよう 車利用"
"くるみ 包み 胡桃"
"くるみざわ 胡桃沢"
"くるみもく クルミ目"
"くるめ 久留米"
"くるり 枢"
"くるる 枢"
"くるわ 曲輪 廓 郭"
"くるわことば 郭言葉"
"くれ 暮 塊 暮れ 呉"
"くれーしゃげき クレー射撃"
"くれーぷや クレープ屋"
"くれーむしょり クレーム処理"
"くれおーるご クレオール語"
"くれがし 某"
"くれぐれ 呉呉 暮々 呉々"
"くれし 呉市"
"くれじっとがいしゃ クレジット会社"
"くれじっとけっさい クレジット決済"
"くれせん 呉線"
"くれたけ 呉竹"
"くれたぶんめい クレタ文明"
"くれない 紅"
"くれないぞめ 紅染"
"くれないのぶた 紅の豚"
"くれはかがく 呉羽化学"
"くれはとり 呉織"
"くればやし 暮林 紅林"
"くれむつ 暮六つ"
"くれよんしゃ クレヨン社"
"くろ 玄 畔 黒"
"くろーんびょう クローン病"
"くろあめ 黒飴"
"くろあん 黒あん 黒餡"
"くろいあめ 黒い雨"
"くろいきり 黒い霧"
"くろいし 黒石"
"くろいそ 黒磯"
"くろいつふぇるとやこぶびょう クロイツフェルトヤコブ病"
"くろいと 黒糸"
"くろいぬ 黒犬"
"くろいろ 黒色"
"くろいわ 黒岩"
"くろいわるいこう 黒岩涙香"
"くろう 苦労"
"くろうしょう 苦労性"
"くろうじ 黒氏"
"くろうたどり 黒歌鳥"
"くろうと 玄人"
"くろうとはだし 玄人跣"
"くろうど 蔵人"
"くろうどのごい 蔵人の五位"
"くろうま 黒馬"
"くろうめもどきもく クロウメモドキ目"
"くろうるし 黒漆"
"くろえ 黒江"
"くろおとこ 黒男"
"くろおび 黒帯"
"くろかび 黒かび 黒カビ 黒黴"
"くろかみ 黒髪"
"くろかわ 黒革 黒河 黒川"
"くろがしら 黒頭"
"くろがね 鐵 黒銀 黒鉄 鉄"
"くろがも 黒鴨"
"くろき 黒木"
"くろぎ 黒木"
"くろくま 黒熊"
"くろくも 黒雲"
"くろぐろ 黒々"
"くろけい 黒系"
"くろげ 黒毛"
"くろこ 黒子"
"くろこま 黒駒"
"くろご 黒衣 黒子"
"くろごめ 黒米 玄米"
"くろさ 黒さ"
"くろさか 黒坂"
"くろさき 黒崎"
"くろさわ 黒澤 黒沢"
"くろさわあきら 黒沢明 黒澤明"
"くろざとう 黒砂糖"
"くろしお 黒潮"
"くろしかく ■"
"くろしま 黒島"
"くろしろ 黒白"
"くろじ 黒地 黒字"
"くろじゅす 黒襦子"
"くろす 黒須"
"くろすそう クロス装"
"くろすみ 黒住"
"くろず 黒酢"
"くろずみ 黒住"
"くろせ 黒瀬"
"くろせん 黒線"
"くろた 黒田"
"くろたき 黒滝"
"くろだ 黒田"
"くろだい 黒鯛"
"くろだけ 黒岳"
"くろだな 黒棚"
"くろだに 黒谷"
"くろだぶし 黒田節"
"くろだま 黒玉"
"くろち 黒地"
"くろちく 黒竹"
"くろちゃ 黒茶"
"くろぢ 黒地"
"くろつち 黒土"
"くろつるばみ 黒橡"
"くろづか 黒塚"
"くろづる 黒鶴"
"くろてん 黒貂"
"くろとう 黒糖"
"くろとり 黒鳥"
"くろど 黒戸"
"くろぬり 畔塗り"
"くろねこ 黒猫"
"くろねずみ 黒鼠"
"くろの 黒野"
"くろは 黒羽"
"くろば 黒羽"
"くろばこ 黒箱"
"くろばね 黒羽"
"くろばん 黒番"
"くろぱん 黒パン"
"くろひげ 黒髭"
"くろひめ 黒姫"
"くろひょう 黒豹"
"くろびーる 黒ビール"
"くろびかり 黒光り"
"くろびし 黒菱"
"くろふく 黒服"
"くろふね 黒船"
"くろぶさ 黒房"
"くろぶし 踝"
"くろぶた 黒豚"
"くろぶち 黒駁 黒斑 黒縁"
"くろべ 黒部"
"くろべこ 黒部湖"
"くろほね 黒保根"
"くろほん 黒本"
"くろぼし ★ ● 黒星"
"くろまく 黒幕"
"くろます 黒鱒"
"くろまつ 黒松"
"くろまにょんじん クロマニョン人"
"くろまめ 黒豆"
"くろまる ● 黒丸"
"くろみ 黒み"
"くろみかずら 黒御鬘"
"くろみさ 黒ミサ"
"くろみつ 黒蜜"
"くろみや 黒宮"
"くろむぎ 黒麦"
"くろむらさき 黒紫"
"くろめ 黒眼 黒目"
"くろも 黒藻"
"くろもの 黒物"
"くろもん 黒門"
"くろや 黒屋"
"くろやき 黒焼"
"くろやなぎ 黒柳"
"くろやま 黒山"
"くろゆめ 黒夢"
"くろよんだむ 黒四ダム"
"くろらく 黒楽"
"くろろ 枢"
"くろわく 黒枠"
"くろわし 黒鷲"
"くろん 句論"
"くろんぼう 黒ん坊"
"くわ 久和 钁 桑 鍬"
"くわい 慈姑"
"くわいろ 桑色"
"くわえ 銜え 加え"
"くわえたばこ 銜えタバコ"
"くわおり 桑折"
"くわかど 桑門"
"くわがた 鍬形"
"くわがたいし 鍬形石"
"くわがたむし 鍬形虫"
"くわき 桑木"
"くわこ 桑子"
"くわこう 桑港"
"くわご 桑蚕"
"くわずぎらい 食わず嫌い"
"くわせもの 食わせ物 食わせ者"
"くわぞめ 桑染"
"くわた 桑田"
"くわたに 桑谷"
"くわだ 桑田"
"くわだて 企 企て"
"くわちゃ 桑茶"
"くわづる 桑鶴"
"くわな 桑名"
"くわの 桑野"
"くわはた 桑畑"
"くわはら 桑原"
"くわばら 桑原"
"くわむら 桑村"
"くわもと 桑本"
"くわやま 桑山"
"くわり 桑理"
"くん 皹 皸 葷 桾 裙 醺 燻 熏 薫 勳 勲 訓 君"
"くんい 勲位"
"くんいく 薫育 訓育"
"くんえん 薫煙 燻煙"
"くんおん 君恩"
"くんか 薫化 訓化 君家"
"くんかい 訓解 訓戒"
"くんがな 訓仮名"
"くんき 勲記"
"くんげん 訓言"
"くんこ 訓詁"
"くんこう 君侯 君公 薫香 勲功"
"くんこく 君国 訓告"
"くんし 君子"
"くんしゃく 訓釈 勲爵"
"くんしゅ 葷酒 君主"
"くんしゅせい 君主政"
"くんしょう 勲章"
"くんしらん 君子蘭"
"くんしん 君臣"
"くんじ 訓辞 訓示"
"くんじゅ 群衆"
"くんじょう 薫蒸 燻蒸"
"くんずほぐれつ 組んず解れつ"
"くんせい 薫製 燻製"
"くんせん 薫染"
"くんそく 君側"
"くんだり 下り 下"
"くんちゅう 訓註 訓注"
"くんちょう 君寵"
"くんづけ 君付 君付け"
"くんてん 訓点"
"くんでん 訓電"
"くんとう 勲等 薫陶"
"くんどう 訓導"
"くんどく 訓読"
"くんねっぷ 訓子府"
"くんのう 君王"
"くんぷ 君父"
"くんぷう 薫風"
"くんみん 君民"
"くんみんせいおん 訓民正音"
"くんめい 君命"
"くんもう 訓蒙"
"くんやん 崑央"
"くんゆ 訓諭"
"くんよみ 訓読み"
"くんりん 君臨"
"くんれい 訓令"
"くんれん 訓練"
"くんわ 訓話"
"ぐ 狗 麌 虞 壷 壺 弘 禺 倶 颶 惧 具 愚"
"ぐあい 工合 具合い 具合"
"ぐあむとう グアム島"
"ぐあん 具案 愚案"
"ぐいのみ ぐい飲み"
"ぐう 藕 嵎 隅 遇 寓 偶 宮"
"ぐうい 寓意"
"ぐういん 偶因"
"ぐうえい 偶詠"
"ぐうえん 宮宛"
"ぐうかく 隅角"
"ぐうかん 偶感"
"ぐうかんすう 偶関数"
"ぐうき 偶奇"
"ぐうきょ 寓居"
"ぐうげん 寓言"
"ぐうご 偶語"
"ぐうさく 偶作"
"ぐうじ 宮司"
"ぐうじん 偶人"
"ぐうすう 偶数"
"ぐうすうづき 偶数月"
"ぐうせい 偶成"
"ぐうぜん 偶然"
"ぐうぞう 偶像"
"ぐうちかん 偶置換"
"ぐうていもく 偶蹄目"
"ぐうているい 偶蹄類"
"ぐうのね ぐうの音"
"ぐうはつ 偶発"
"ぐうもく 寓目"
"ぐうゆ 寓喩"
"ぐうゆう 偶有"
"ぐうりょく 偶力"
"ぐうれつ 偶列"
"ぐうわ 寓話"
"ぐかく 具格"
"ぐかんしょう 愚管抄"
"ぐがん 具眼"
"ぐきょ 愚挙"
"ぐけい 愚計 愚形 愚兄"
"ぐけん 愚見"
"ぐげん 具現"
"ぐこう 供香 愚公 愚考 愚行"
"ぐさ 草 種"
"ぐさい 供祭 愚妻"
"ぐさく 愚作 愚策"
"ぐざい Ξ ξ 具材"
"ぐし 串 愚姉"
"ぐしかみ 具志頭"
"ぐしかわ 具志川"
"ぐしけん 具志堅"
"ぐしゃ 愚者"
"ぐしょ 具書 愚書"
"ぐしょう 具象"
"ぐしん 愚神 供進 具申"
"ぐじょ 愚女"
"ぐじょう 郡上"
"ぐじん 愚人"
"ぐすくべ 城辺"
"ぐすり 薬"
"ぐず 愚図"
"ぐせ 癖"
"ぐせい 愚生"
"ぐせつ 愚説"
"ぐせぼさつ 救世菩薩"
"ぐぜい 弘誓"
"ぐそ 糞"
"ぐそう 愚僧"
"ぐそく 愚息 具足"
"ぐそくかい 具足戒"
"ぐたい 具体"
"ぐち 口 愚痴"
"ぐちょく 愚直"
"ぐちん 具陳"
"ぐつ 靴"
"ぐてい 愚弟"
"ぐとう 愚答"
"ぐどう 求道"
"ぐどん 愚鈍"
"ぐねつむこう グネツム綱"
"ぐのう 愚能"
"ぐのこっちょう 愚の骨頂"
"ぐはん 虞犯"
"ぐび 具備"
"ぐびじん 虞美人"
"ぐびじんそう 虞美人草"
"ぐふ 愚婦 愚父 愚夫"
"ぐふう 颶風"
"ぐふとくく 求不得苦"
"ぐぶ 弘布 供奉"
"ぐぶつ 愚物"
"ぐほう 求法"
"ぐぼ 愚母"
"ぐまい 愚妹 愚昧"
"ぐみ 茱萸 胡頽子 萸 茱 組"
"ぐみん 愚民"
"ぐもん 愚問"
"ぐもんじほう 求聞持法"
"ぐゆう 具有"
"ぐら 鞍 倉 蔵"
"ぐらい 位"
"ぐらたんざら グラタン皿"
"ぐらにゅーとう グラニュー糖"
"ぐらびあし グラビア誌"
"ぐらふか グラフ化"
"ぐらふし グラフ誌"
"ぐらふりろん グラフ理論"
"ぐらみーしょう グラミー賞"
"ぐらむ 瓦"
"ぐらむすう グラム数"
"ぐり 栗"
"ぐりーんしゃ グリーン車"
"ぐりあさいぼう グリア細胞"
"ぐりむどうわ グリム童話"
"ぐるーう゛かん グルーヴ感"
"ぐるーぶかん グルーブ感"
"ぐるーぷきぎょう グループ企業"
"ぐるーぷめい グループ名"
"ぐるい 狂い"
"ぐるかへい グルカ兵"
"ぐるぐるまき ぐるぐる巻き グルグル巻き"
"ぐるたみんさん グルタミン酸"
"ぐるたみんさんなとりうむ グルタミン酸ナトリウム"
"ぐるま 車"
"ぐるみ 包み"
"ぐるめ 包"
"ぐるり 周"
"ぐれ 昏"
"ぐれーじ グレー地"
"ぐれごりうすれき グレゴリウス暦"
"ぐれごりおせいか グレゴリオ聖歌"
"ぐれごりおれき グレゴリオ暦"
"ぐれつ 愚劣"
"ぐれん 紅蓮"
"ぐれんたい 愚連隊"
"ぐれんな 紅蓮奈"
"ぐろ 黒"
"ぐろーばるか グローバル化"
"ぐろう 愚老 愚弄"
"ぐろん 愚論"
"ぐわい 具合"
"ぐん 麕 羣 軍 群 郡"
"ぐんい 軍医"
"ぐんいち 軍一"
"ぐんえい 軍営 群栄"
"ぐんえき 軍役"
"ぐんか 群化 軍靴 軍歌"
"ぐんかく 群鶴 軍拡"
"ぐんかん 軍鑑 軍艦"
"ぐんかんどり 軍艦鳥"
"ぐんかんまき 軍艦巻"
"ぐんがく 軍楽 軍学"
"ぐんき 軍紀 軍規 軍機 軍旗 軍記"
"ぐんきょ 群居"
"ぐんぎ 群議"
"ぐんけ 郡家"
"ぐんけい 軍鶏"
"ぐんけん 軍犬"
"ぐんこう 軍功 軍港"
"ぐんこく 軍国"
"ぐんこん 群婚"
"ぐんさい 軍才"
"ぐんさん 軍産"
"ぐんざん 群山"
"ぐんし 軍史 軍使 軍士 軍師"
"ぐんしゅう 群聚 群衆 群集"
"ぐんしゅく 軍縮"
"ぐんしょ 軍書 群書"
"ぐんしょう 群小"
"ぐんしょく 軍職"
"ぐんしん 群臣 軍神"
"ぐんじ 群司 軍二 郡司 軍事"
"ぐんじゅ 軍需"
"ぐんじょう 群生 群青"
"ぐんじん 軍陣 軍人"
"ぐんすい 軍帥"
"ぐんすう 群数"
"ぐんせい 群棲 群星 軍制 軍政 群生"
"ぐんせき 軍籍"
"ぐんせん 軍船"
"ぐんぜい 軍勢"
"ぐんぜさんぎょう グンゼ産業"
"ぐんぜんたい 群全体"
"ぐんそう 軍装 軍曹"
"ぐんそく 軍足"
"ぐんそくど 群速度"
"ぐんそつ 軍卒"
"ぐんぞう 群像"
"ぐんぞく 軍属"
"ぐんたい 群体 軍隊"
"ぐんだい 郡代 群大"
"ぐんだり 軍荼利"
"ぐんだん 軍談 群団 軍団"
"ぐんちえん 群遅延"
"ぐんちゅう 軍中"
"ぐんちょう 軍長 郡長"
"ぐんて 軍手"
"ぐんてい 軍偵"
"ぐんていすう 群定数"
"ぐんと 軍都"
"ぐんとう 群盗 軍刀 群島"
"ぐんない 郡内"
"ぐんば 軍馬"
"ぐんばい 軍配"
"ぐんばつ 軍閥"
"ぐんぱつ 群発"
"ぐんび 軍備"
"ぐんぴ 軍費"
"ぐんぴょう 群氷 軍票 軍兵"
"ぐんぶ 群舞 郡部 軍部"
"ぐんぷ 軍夫"
"ぐんぷく 軍服"
"ぐんぼう 軍帽"
"ぐんぽう 群峰 軍法"
"ぐんま 群馬"
"ぐんみん 軍民"
"ぐんむ 軍務"
"ぐんもう 群盲"
"ぐんもん 軍門"
"ぐんやく 軍役"
"ぐんゆう 群游 群雄"
"ぐんよう 軍用"
"ぐんようけん 軍用犬"
"ぐんらく 群落"
"ぐんりつ 軍律"
"ぐんりゃく 軍略"
"ぐんりゅうせい 群流星"
"ぐんりょ 軍旅"
"ぐんれい 軍令"
"ぐんれき 軍歴"
"ぐんろん 群論"
"け 消 祁 氣 假 迦 乖 掛 華 花 仮 化 懸 袈 恠 怪 蹴 ヶ 褻 卦 家 気 毛"
"けーきざら ケーキ皿"
"けーきづくり ケーキ作り"
"けーきや ケーキ屋"
"けーすべつ ケース別"
"けーてん Ｋ点"
"けあがり 蹴上がり"
"けあげ 蹴上げ 蹴上"
"けあし 毛足"
"けあな 毛孔 毛穴"
"けい 掛 佳 彑 匸 冂 攜 憇 詣 稽 景 携 掲 憩 慶 兄 係 醯 笄 瓊 檠 枅 憬 夐 荊 境 卿 競 傾 頃 盻 兮 煢 螢 蛍 綮 啓 繋 磬 馨 謦 警 敬 楔 挈 契 經 逕 徑 輕 莖 脛 痙 勁 剄 閨 挂 奎 鮭 罫 畦 桂 硅 珪 圭 黥 勍 迥 冏 絅 烱 炯 惠 恵 慧 鷄 鶏 谿 蹊 溪 渓 奚 繼 継 頚 頸 径 茎 京 経 軽 計 系 型 形 刑"
"けいあい 敬愛"
"けいあつ 傾圧"
"けいあん 慶庵 桂庵 慶安"
"けいい 慶伊 軽易 敬意 経緯"
"けいいち 蛍一 螢一 佳一 桂一 慶一 敬一 恵一 啓一 圭一"
"けいいちろう 圭一朗"
"けいいん 契印"
"けいうん 慶雲"
"けいえい 継泳 形影 警衛 経営"
"けいえいなん 経営難"
"けいえん 閨怨 敬遠"
"けいえんじだい 桂園時代"
"けいおう 慶応 慶應 京王"
"けいおういなだつつみ 京王稲田堤"
"けいおうかく 京王閣"
"けいおん 軽音"
"けいおんき 警音器"
"けいか 軽過 圭花 計科 京華 桂花 経過"
"けいかい 啓開 軽快 警戒"
"けいかく 形覚 計畫 圭角 計画"
"けいかぼく 珪化木"
"けいかん 鶏姦 荊冠 渓間 桂冠 鶏冠 頚管 警官 景観"
"けいが 慶賀"
"けいがい 荊芥 傾蓋 競買 謦咳 境外 形骸"
"けいがいぎんが 系外銀河"
"けいがく 啓学 経学"
"けいがん 鶏眼 炯眼 慧眼"
"けいき 恵輝 圭樹 軽機 継起 刑期 慶喜 掲記 計器 契機 景気"
"けいきち 啓吉"
"けいきゅう 警急 京急"
"けいきゅうひば 軽裘肥馬"
"けいきょ 軽挙"
"けいきょう 景教 景況"
"けいきょく 荊棘"
"けいきん 頸筋"
"けいぎ 経義"
"けいく 警句"
"けいぐ 刑具 敬具"
"けいぐん 鶏群"
"けいけい 軽軽 烱々 炯々 軽々"
"けいけつ 経穴 経血"
"けいけつせき 鶏血石"
"けいけん 經驗 敬虔 経験"
"けいけんあり 経験有"
"けいけんば 経験馬"
"けいげつ 桂月"
"けいげん 軽減"
"けいこ 珪子 奎子 蛍子 華子 景子 敬子 佳子 啓子 桂子 圭子 慶子 恵子 稽古"
"けいこう 螢光 馨香 径行 鶏口 携行 経口 蛍光 傾向"
"けいこうがくえん 啓光学園"
"けいこうてんのう 景行天皇"
"けいこうとう 蛍光燈"
"けいこく 谿谷 溪谷 傾国 経国 渓谷 警告"
"けいこくとう 警告燈"
"けいこつ 軽忽 頚骨 脛骨"
"けいご 警語 圭悟 啓吾 警護 警固 敬語"
"けいごう 契合"
"けいさい 掲載"
"けいさいるい 茎菜類"
"けいさく 計策 啓作"
"けいさつ 警察"
"けいさつけん 警察犬"
"けいさん ＞ ≦ ＜ ≠ ＝ ＋ × ± ÷ ≧ 珪酸 経産 計算"
"けいさんかんむり 卦算冠"
"けいさんだい 京産大"
"けいさんどりる 計算ドリル"
"けいざい 軽罪 経済"
"けいざいしょう 経財相"
"けいざいぶろっく 経済ブロック"
"けいざぶろう 啓三郎"
"けいし 経始 景士 啓示 圭史 啓史 圭司 罫紙 継嗣 刑死 京師 継子 兄姉 桂枝 警視 軽視"
"けいしき 型式 形式"
"けいしせい 警視正"
"けいしつ 閨室 継室 軽質 憩室 形質"
"けいしゃ 珪砂 軽車 鶏舎 傾斜"
"けいしゅ 警手 景趣"
"けいしゅう 慶周 軽舟 閨秀 慶州"
"けいしゅく 痙縮 慶祝"
"けいしゅつ 掲出"
"けいしょ 経書"
"けいしょう 卿相 景象 形勝 形象 景勝 軽症 軽傷 警鐘 敬称 継承"
"けいしょく 軽食"
"けいしょくほう 警職法"
"けいしん 茎針 軽震 軽信 京神 恵信 敬信 敬神 京津"
"けいじ 景示 圭児 桂治 啓次 恵司 慶治 敬治 敬司 圭二 啓治 敬二 啓司 啓二 圭司 兄事 形而 繋辞 継時 経時 計時 慶事 啓示 掲示 刑事"
"けいじつ 頃日"
"けいじばつ 刑事罰"
"けいじばん 掲示板"
"けいじゅ 継受 圭樹"
"けいじゅう 軽重"
"けいじゅん 軽巡"
"けいじょう 敬譲 警乗 啓上 刑場 京城 経常 計上 形状"
"けいじょうみゃく 頸静脈 頚静脈"
"けいじょし 係助詞"
"けいじろう 啓次朗 恵二郎 圭次郎 慶次郎"
"けいす 磬子"
"けいすい 型推 軽水"
"けいすう 計數 計数 係数"
"けいすけ 慶裕 桂輔 啓典 景介 惠介 慶輔 佳佑 啓助 啓輔 啓祐 圭祐 敬介 佳祐 圭介 啓介"
"けいず 系図"
"けいずい 頸髄"
"けいずかい 系図買 窩主買"
"けいせい 景星 傾性 警醒 刑政 形声 痙性 警世 経世 傾城 京成 形勢 形成"
"けいせき 珪石 形跡"
"けいせつ 螢雪 蛍雪"
"けいせつのこう 蛍雪の功"
"けいせん ╂ ┸ ┥ ┰ ┝ ┿ ┷ ┨ ┯ ┠ ╋ ┻ ┫ ┳ ┣ ┗ ┛ ┓ ┏ ┃ ━ ┼ ┴ ┤ ┬ ├ └ ┘ ┐ ┌ │ ─ 恵泉 繋船 係船 経線 罫線"
"けいせんそへん ╂ ┸ ┥ ┰ ┝ ┿ ┷ ┨ ┯ ┠ ╋ ┻ ┫ ┳ ┣ ┗ ┛ ┓ ┏ ┃ ━ ┼ ┴ ┤ ┬ ├ └ ┘ ┐ ┌ │ ─ ─│┌┐┘└├┬┤┴┼━┃┏┓┛┗┣┳┫┻╋┠┯┨┷┿┝┰┥┸╂"
"けいぜつ 鶏舌"
"けいそ 形素 硅素 刑訴 珪素 ケイ素"
"けいそう 軽躁 継走 慶早 珪藻 勁草 計装 係争 軽装 形相"
"けいそうど 軽鬆土"
"けいそく 計測"
"けいそくせん 鶏足山"
"けいそつ 輕率 軽卒 軽率"
"けいそん 恵存"
"けいぞう 経三 佳三 恵造 慶三 圭三 啓三 恵三 敬三 恵贈 形像"
"けいぞく 繼續 係属 継続"
"けいぞん 桂損 恵存"
"けいた 圭太 慶太"
"けいたい 敬体 継体 形体 形態 携帯"
"けいたく 恵沢"
"けいだ 慶田"
"けいだい 掲題 継代 慶大 境内"
"けいだいじょう 慶大情"
"けいだんれん 経団連"
"けいちつ 経膣 啓蟄"
"けいちゅう 契沖 閨中 傾注"
"けいちょう 憩潮 敬弔 敬重 計帳 軽佻 茎頂 慶長 軽重 傾聴 慶弔"
"けいちょうのえき 慶長の役"
"けいつい 頸椎 頚椎"
"けいてい 逕庭 径庭 係蹄 兄弟"
"けいてき 警笛"
"けいてん 慶典 啓典 経典"
"けいてんあいじん 敬天愛人"
"けいでんき 継電器"
"けいと 慶人 毛糸"
"けいとう 鷄頭 恵投 鶏頭 継投 傾倒 系統"
"けいとうじゅ 系統樹"
"けいとくくうこう 啓徳空港"
"けいとくちん 景徳鎮"
"けいとせい 計都星"
"けいとだま 毛糸玉"
"けいとら 軽トラ"
"けいとらっく 軽トラック"
"けいど 傾度 経度 軽度"
"けいどう 傾動"
"けいどうみゃく 頸動脈 頚動脈"
"けいない 系内"
"けいなわ 京奈和"
"けいなん 荊南 慶南"
"けいにく 鶏肉"
"けいねん 経年"
"けいのじょう 蛍之丞"
"けいはい 軽輩 珪肺"
"けいはく 敬白 軽薄"
"けいはつ 啓発"
"けいはん 京阪"
"けいはんしん 京阪神"
"けいはんな 京阪奈"
"けいば 競馬"
"けいばい 啓培 競売"
"けいばく 繋縛"
"けいばつ 警抜 閨閥 刑罰"
"けいばほう 競馬報"
"けいひ 荊扉 桂皮 経費"
"けいひつ 警蹕"
"けいひょうほう 景表法"
"けいひん 京浜 景品"
"けいび 軽微 警備"
"けいびき 罫引"
"けいびん 慧敏 軽便"
"けいふ 継父 系譜"
"けいふうまる 啓風丸"
"けいふく 京福 慶福 敬服"
"けいふぼ 継父母"
"けいふん 軽粉 鶏糞"
"けいぶ 軽侮 頚部 頸部 警部"
"けいぶつ 景物"
"けいぶつし 景物詩"
"けいぶん 慶文"
"けいぶんしゃ 勁文社"
"けいべつ 軽蔑"
"けいべん 軽便"
"けいほ 警保"
"けいほう 刑法 警報"
"けいほうこう 径方向"
"けいほく 京北"
"けいぼ 景慕 敬慕 継母"
"けいぼう 圭膀 閨房 警防 警棒"
"けいま 桂馬"
"けいまい 兄妹"
"けいみょう 軽妙"
"けいみん 傾眠"
"けいむ 刑務 警務"
"けいめい 経明 鶏鳴 啓明"
"けいめいくとう 鶏鳴狗盗"
"けいめん 軽免"
"けいもう 啓蒙"
"けいやく 契約"
"けいやくのしっぱい 契約の失敗"
"けいゆ 軽油 経由"
"けいゆう 系由 経由"
"けいよ 刑余 恵与"
"けいよう 繋養 京葉 茎葉 掲揚 形容"
"けいよん 軽四"
"けいら 軽羅 警ら 警邏"
"けいらく 京洛 経絡"
"けいらん 鶏卵"
"けいり 警吏 刑吏 計理 経理"
"けいりがかり 経理掛"
"けいりく 刑戮"
"けいりつ 刑律"
"けいりひかえ 経理控"
"けいりゃく 経略 計略"
"けいりゅう 谿流 憩流 稽留 掛留 繋留 係留 渓流"
"けいりゅうおん 継留音"
"けいりゅうざお 渓流竿"
"けいりょう 計量 軽量"
"けいりょうかっぷ 計量カップ"
"けいりょうすぷーん 計量スプーン"
"けいりょうてんそる 計量テンソル"
"けいりょうば 軽量馬"
"けいりん 経綸 桂林 競輪"
"けいりんどう 啓林堂"
"けいるい 繋累 係累"
"けいれい 敬礼"
"けいれき 経歴"
"けいれつ 勁烈 系列"
"けいれん 痙攣"
"けいろ 径路 毛色 経路"
"けいろう 敬老"
"けいろうのひ 敬老の日"
"けいろく 鶏肋"
"けいわ 計和"
"けいわんしょうこうぐん 頸腕症候群"
"けう 希有 稀有"
"けうら 毛裏"
"けおり 毛織り 毛織"
"けかえし 蹴返し"
"けが 怪我"
"けがい 化外"
"けがに 毛蟹"
"けがにん ケガ人 けが人"
"けがれ 穢 汚れ 穢れ"
"けがわ 毛皮"
"けぎ 化儀"
"けぎょう 加行"
"けぎらい 毛嫌い"
"けげん 化現 怪訝"
"けこ 花籠"
"けこう 華香 花香"
"けこみ 蹴込み 蹴込"
"けご 毛蚕"
"けごろも 裘 毛衣"
"けごん 華嚴 華厳"
"けごんぎょう 華厳経"
"けごんのたき 華厳滝"
"けさ 畩 袈裟 今朝"
"けさがけ 袈裟懸け"
"けさがため 袈裟固め"
"けさき 毛先"
"けし 消し 芥子 罌粟"
"けしいん 消印"
"けしからぬ 怪しからぬ"
"けしからん 怪しからん"
"けしき 気色 景色"
"けしこみ 消込"
"けしごむ 消しゴム"
"けしずみ 消炭 消し炭"
"けしずみぐろ 消し炭黒"
"けして 決して"
"けしむらさき 滅紫"
"けしもく ケシ目"
"けしょう 化生 化粧"
"けしょういた 化粧板"
"けしょうがけ 化粧掛"
"けしょうじお 化粧塩"
"けしょうだち 化粧裁ち"
"けしょうだな 化粧棚"
"けしょうだんす 化粧箪笥"
"けしょうばこ 化粧箱"
"けしょうばん 化粧板"
"けしん 化身"
"けじらみ 毛虱"
"けすじ 毛筋"
"けずね 毛脛"
"けずりくず 削り屑"
"けずりぶし 削り節"
"けせん 気仙"
"けせんぬま 気仙沼"
"けそう 懸想"
"けそうびと 懸想人"
"けそうぶみ 懸想文"
"けぞめ 毛染め"
"けぞり 毛剃り"
"けた 桁"
"けたい 仮諦 化体 懈怠"
"けたいくそ 卦体糞"
"けたいち 桁位置"
"けたおち 桁落ち"
"けたか 気高"
"けたぐり 蹴手繰り"
"けたごと 桁毎"
"けたすう 桁数"
"けたちがい 桁違い"
"けたはずれ けた外れ 桁外れ"
"けたばし 桁橋"
"けたひょうじ 桁表示"
"けため 桁目"
"けたゆき 桁行"
"けだかい 気高い"
"けだし 蓋し"
"けだま 毛玉"
"けだもの 獣"
"けち 吝"
"けちえん 結縁"
"けちみゃく 血脈"
"けちょう 怪鳥"
"けちんぼう けちん坊"
"けっか 決河 闕下 結跏 欠課 結果"
"けっかい 欠壊 決潰 血塊 決壊 結界"
"けっかおーらい 結果オーライ"
"けっかく 欠格 結核"
"けっかりすと 結果リスト"
"けっかん 缺陷 穴間 欠巻 欠陥 血管"
"けっき 蹶起 血気 決起"
"けっきゅう 結球 血球"
"けっきょ 穴居"
"けっきょく 結局"
"けっきん 欠勤"
"けっく 結句"
"けっけいもじ 楔形文字"
"けっこう 欠行 結好 欠航 血行 決行 結構"
"けっこうしょく 血紅色"
"けっこうむかし 結構昔"
"けっこん 血痕 結婚"
"けっこんいわい 結婚祝"
"けっさい 潔斎 決裁 決済"
"けっさいようよきん 決済用預金"
"けっさく 結紮 結索 傑作"
"けっさくせん 傑作撰"
"けっさくば 傑作馬"
"けっさつ 結紮"
"けっさん 決算"
"けっし 血祀 傑士 決死"
"けっしきそ 血色素"
"けっしつ 欠失"
"けっして 決して"
"けっしゃ 結社"
"けっしゅ 血腫"
"けっしゅう 血臭 結集"
"けっしゅつ 傑出"
"けっしょ 欠所 闕所 血書"
"けっしょう 結漿 血笑 血症 血漿 結晶 決勝"
"けっしょうだん 決勝弾"
"けっしょうとーなめんと 決勝トーナメント"
"けっしょうばん 血小板"
"けっしょく 欠食 血色"
"けっしん 結審 決心"
"けっせい 血清 結成"
"けっせき 血石 結石 欠席"
"けっせつ 結節"
"けっせん 決戰 決選 血戦 結線 血栓 決戦"
"けっそう 傑僧 血相"
"けっそうこん 纈草根"
"けっそく 欠測 結束"
"けっそん 欠損"
"けったく 結託"
"けったん 血痰"
"けっちゃく 結着 決着"
"けっちゅう 桀紂 血中"
"けっちょう 結腸"
"けっちん 血沈"
"けってい 決定"
"けっていき 決定木"
"けっていぎ 決定木"
"けっていそしき 結締組織"
"けってき 闕腋"
"けってん 缺點 欠点"
"けっとう 結党 血糖 決闘 血統"
"けっぱい 欠配"
"けっぱく 潔白"
"けっぱつ 結髪"
"けっぱん 血斑 血判"
"けっぴょう 結氷"
"けっぴん 欠品"
"けっぷん 血粉"
"けっぺい 血餅"
"けっぺき 潔癖"
"けっぺきしょう 潔癖性"
"けっぽう 欠報 血泡"
"けっぽん 欠本"
"けつ 譎 訐 孑 亅 潔 頁 襭 纈 頡 桔 結 歇 闕 蹶 獗 厥 蕨 缺 刔 抉 决 訣 夬 竭 碣 偈 桀 杰 傑 尻 穴 血 決 欠"
"けつあつ 血圧"
"けつい 決意"
"けついん 闕員 欠員"
"けつえき 血液"
"けつえきのうかんもん 血液脳関門"
"けつえん 結縁 血縁"
"けつおう 傑王"
"けつがん 頁岩"
"けつぎ 決義 決疑 決議"
"けつげん 結言"
"けつご 結語"
"けつごう 欠号 結合"
"けつごうえねるぎー 結合エネルギー"
"けつごうしき 結合織"
"けつごうてすと 結合テスト"
"けつごうみゃく 結合脈"
"けつじ 闕字 結辞 欠字"
"けつじつ 結実"
"けつじゅう 結集"
"けつじょ 闕如 欠除 欠如"
"けつじょう 決定 結縄 楔状 欠場"
"けつじん 傑人"
"けつぜい 血税"
"けつぜん 孑然 蹶然 決然"
"けつぞう 結像"
"けつぞく 血族"
"けつだん 結団 決断"
"けつにく 血肉"
"けつにょう 血尿"
"けつね 狐"
"けつばん 欠番"
"けつび 結尾"
"けつぶつ 傑物"
"けつぶん 結文"
"けつべつ 訣別 決別"
"けつべん 血便"
"けつぼう 欠亡 欠乏"
"けつまく 結膜"
"けつまつ 結末"
"けつみゃく 血脈"
"けつめい 決明 結盟 血盟"
"けつゆうびょう 血友病"
"けつらく 欠落"
"けつりゅう 血瘤 血流"
"けつりょう 血量 結了"
"けつるい 血涙"
"けつれい 欠礼"
"けつれつ 決裂"
"けつろ 血路 結露"
"けつろん 結論"
"けづか 毛塚"
"けづくろい 毛繕い"
"けづな 毛綱"
"けづめ 蹴爪 距"
"けづや 毛艶"
"けと 化土"
"けとう 毛唐"
"けとば 言葉"
"けどう 化導"
"けどういん 祁答院"
"けない 化内 家内"
"けなげ 健気"
"けなしだいら 毛無平"
"けなみ 毛並 毛並み"
"けに 化尼"
"けにん 化人"
"けぬき 毛抜 鑷 毛抜き"
"けねん 懸念"
"けのび 蹴伸び"
"けはい 気配"
"けはいね 気配値"
"けはえぐすり 毛生え薬"
"けはひ 気配 化粧"
"けば 毛羽"
"けばり 毛鉤"
"けびいし 検非違使"
"けびき 罫引 毛引き"
"けびきおどし 毛引縅"
"けびょう 仮病"
"けふぇうすざ ケフェウス座"
"けぶ 烟 煙"
"けぶつ 化仏"
"けぶり 気振り"
"けほう 化法"
"けぼうき 毛箒"
"けぼうし 毛帽子"
"けぼうず 毛坊主"
"けぼり 毛彫"
"けまうち 毛馬内"
"けまり 蹴鞠"
"けみがわ 検見川"
"けみがわはま 検見川浜"
"けむ 烟 煙"
"けむし 毛虫"
"けむり 烟 煙"
"けもの 獸 獣"
"けものぞく 獣族"
"けものへん 獣偏"
"けものみち 獣道"
"けもん 仮門"
"けやき 槻 欅"
"けやりむし 毛槍虫"
"けら 螻蛄"
"けらい 家来"
"けらく 快楽"
"けらば 螻蛄羽"
"けらまれっとう 慶良間列島"
"けり 蹴り 鳧"
"けりょう 家領 仮令"
"けれんみ ケレン味 外連味"
"けろくろ 蹴轆轤"
"けわい 化粧"
"けん 舉 擧 鉉 眩 搴 顯 顕 黔 騫 虔 繝 甄 愆 幵 妍 凵 繭 肩 牽 憲 監 絢 獻 献 顴 權 萱 諠 暄 愃 喧 蹇 謇 譴 遣 縣 懸 筧 硯 俔 見 蜷 綣 眷 椦 圈 卷 劵 捲 惓 倦 巻 鵑 羂 狷 涓 娟 絹 釼 剱 劒 劔 劍 驗 險 檢 儉 瞼 臉 嶮 鹸 験 険 検 倹 鰹 慳 樫 堅 賢 歉 慊 謙 嫌 鍵 健 建 乾 間 犬 研 圏 腱 軒 拳 権 兼 剣 県 券 件"
"けんあい 兼愛 眷愛"
"けんあく 険悪"
"けんあん 検案 懸案"
"けんい 健胃 権威"
"けんいき 県域 圏域"
"けんいち 乾一 剣一 堅一 建一 研一 謙一 憲一 賢一 健一"
"けんいちろう 顕一郎 健一朗"
"けんいん 検印 牽引"
"けんうん 絹雲 巻雲"
"けんえい 顕栄 献詠 建永 兼営 県営"
"けんえき 権益 検疫"
"けんえつ 憲悦 検閲"
"けんえん 嫌厭 倦厭 犬猿 嫌煙"
"けんお 嫌惡 嫌悪"
"けんおう 賢王 県央"
"けんおうどう 圏央道"
"けんおん 建音 検温"
"けんか 鹸化 堅果 県花 献花 県下 喧嘩"
"けんかい 研開 狷介 県会 見解"
"けんかうり 喧嘩売"
"けんかく 見覚 懸隔 剣客"
"けんかごし 喧嘩腰"
"けんかしょくぶつ 顕花植物"
"けんかまつり 喧嘩祭"
"けんかん 兼官 顕官 建艦"
"けんが 懸下 懸河"
"けんがい 遣外 懸崖 県外 圏外"
"けんがく 兼学 研学 建学 見学"
"けんがみね 剣ヶ峰"
"けんがん 検眼"
"けんき 顕貴 嫌忌 建機 嫌気"
"けんきち 賢吉 健吉"
"けんきゃく 剣客 健脚"
"けんきゅう 建久 研究"
"けんきゅういん 研究院"
"けんきゅうきょうりょくがかり 研究協力掛"
"けんきゅうぐるーぷ 研究グループ"
"けんきゅうしょだい 研究所第"
"けんきゅうだい 研究第"
"けんきょ 検挙 謙虚"
"けんきょう 牽強 検鏡 県境"
"けんきん 兼勤 献金"
"けんぎ 剣技 嫌疑 建議 県議"
"けんぎゅう 犬牛 牽牛"
"けんぎゅうせい 牽牛星"
"けんぎょう 顕教 検校 兼業"
"けんぐ 賢愚"
"けんぐん 建軍"
"けんけい 賢兄 県警"
"けんけつ 欠缺 献血"
"けんけんがくがく 喧々諤々 喧喧諤諤"
"けんけんごうごう 喧喧囂囂 喧々囂々"
"けんけんひきゅう 蹇蹇匪躬"
"けんけんふくよう 拳拳服膺"
"けんげき 剣劇 剣戟"
"けんげん 献言 乾元 建言 権原 顕現 権限"
"けんこ 腱固 眷顧"
"けんこう 驗效 堅甲 箝口 堅硬 兼行 権衡 軒昂 健康"
"けんこううん 健康運"
"けんこうこつ 肩胛骨 肩甲骨"
"けんこうせい 嫌光性"
"けんこうらんど 健康ランド"
"けんこく 懸谷 圏谷 建国"
"けんこくきねんのひ 建国記念の日"
"けんこつ 顴骨"
"けんこん 乾坤"
"けんご 建悟 顕吾 健五 憲吾 健悟 研吾 謙吾 健吾 謙語 堅固"
"けんごう 喧囂 堅剛 剣豪"
"けんごし 牽牛子"
"けんごしづかこふん 牽牛子塚古墳"
"けんさ 検査"
"けんさい 県債 県際 賢才 賢妻"
"けんさいん 検査院"
"けんさき 剣先"
"けんさく 憲冊 憲作 羂索 建策 献策 研削 検索"
"けんさくえんじん 検索エンジン"
"けんさくしすてむ 検索システム"
"けんさくふぉーむ 検索フォーム"
"けんさくまど 検索窓"
"けんさつ 賢察 検札 検察"
"けんさん 建盞 県産 研鑽"
"けんざい 顕在 健在 建材"
"けんざかい 県境"
"けんざぶろう 健三郎"
"けんざん 験算 乾山 検算 剣山 見参"
"けんざんやき 乾山焼"
"けんし 賢史 堅紙 献詞 研資 研紙 繭糸 県史 絹糸 検屍 検視 検死 犬歯 剣士"
"けんしき 見識"
"けんしゃ 検車 見者 県社"
"けんしゃく 献酌"
"けんしゅ 賢主 券種 堅守 犬種"
"けんしゅう 献酬 兼修 検収 研修"
"けんしゅうこ 検修庫"
"けんしゅつ 顕出 検出"
"けんしょ 嶮所 険所 賢所 見所"
"けんしょう 謙称 顕賞 剣匠 兼掌 腱鞘 見性 肩章 顕正 健勝 顕彰 憲章 懸賞 検証"
"けんしょうば 顕彰馬"
"けんしょく 顕職 兼職"
"けんしん 健晋 剣心 献進 検真 堅信 見神 謙信 検針 献身 健診 検診"
"けんじ 研仁 研児 健至 憲志 顕二 健爾 憲嗣 拳児 健士 健之 建司 剣持 賢児 謙司 研治 建治 謙治 賢次 憲二 謙二 健児 賢司 憲治 研二 憲司 健次 賢二 健司 健治 健二 賢治 謙辞 検字 献辞 顕示 検事 堅持"
"けんじせい 検事正"
"けんじつ 兼日 堅実"
"けんじゃ 賢者"
"けんじゃく 間尺"
"けんじゃのいし 賢者の石"
"けんじゅ 犬儒"
"けんじゅう 拳銃"
"けんじゅつ 剣術"
"けんじょ 賢女"
"けんじょう 喧擾 堅城 見城 謙譲 健常 献上"
"けんじろう 顕次郎"
"けんじん 堅陣 賢臣 県人 賢人"
"けんすい 硯水 建水 懸垂"
"けんすう 検数 間数 軒数 件数"
"けんすけ 堅助 研介 健輔 謙介 健介"
"けんず 検図"
"けんずいし 遣隋使"
"けんせい 県政 県勢 県西 剣聖 憲政 権勢 牽制"
"けんせいだい 顕生代"
"けんせき 譴責"
"けんせきうん 絹積雲 巻積雲"
"けんせつ 兼摂 建設"
"けんせん 健羨"
"けんぜい 県税"
"けんぜつ 懸絶"
"けんぜみ 研ゼミ"
"けんぜん 建前 顕然 健全"
"けんぜんいちにょ 拳禅一如 剣禅一如"
"けんそ 倹素 嶮岨 険阻"
"けんそう 建掃 険相 賢崇 剣槍 喧噪 喧騒"
"けんそううん 巻層雲"
"けんそく 検束 検測"
"けんそん 謙遜"
"けんぞう 剣三 研造 健造 健蔵 賢三 謙三 健三 建造"
"けんぞく 眷族 眷属"
"けんた 健太"
"けんたい 謙退 剣帯 肩帯 兼帯 献体 検体 倦怠"
"けんたうるすざ ケンタウルス座"
"けんたろう 謙太朗 謙多郎 謙太郎"
"けんたん 検痰 県短 兼担 健啖"
"けんだい 賢台 建大 兼題 県大 見台"
"けんだか 権高"
"けんだく 懸濁"
"けんだっぱ 乾闥婆"
"けんだま 拳玉 剣玉 けん玉"
"けんち 見知 検地 見地 検知"
"けんちく 建築"
"けんちゃ 献茶"
"けんちゅう 繭紬 検注 絹紬"
"けんちょ 顕著"
"けんちょう 検聴 懸吊 健聴 県鳥 建長 堅調 県庁"
"けんちょうじ 健聴耳"
"けんちんじる けんちん汁 巻繊汁"
"けんてい 賢弟 献呈 検定"
"けんていがいきょうかしょ 検定外教科書"
"けんていふ 献呈譜"
"けんてき 硯滴"
"けんてつ 建鐵 賢哲 建鉄"
"けんてん 圏点"
"けんてんし 権天使"
"けんでん 喧伝"
"けんでんき 検電器"
"けんと 建都 憲人 健人 県都"
"けんとう 喧鬧 賢答 軒灯 県東 献灯 拳闘 見当 健闘 検討"
"けんとうし 遣唐使"
"けんとうしき 見当識"
"けんとうせん 遣唐船"
"けんとく 見得 建徳 乾徳"
"けんとくこう 謙徳公"
"けんとし ケント紙"
"けんどう 権道 県道 剣道"
"けんどうしき 献堂式"
"けんどじゅうらい 捲土重来"
"けんどちょうらい 捲土重來 捲土重来"
"けんどん 慳貪"
"けんない 県内 圏内"
"けんなく 見惑"
"けんなん 険難 剣難 県南"
"けんにょう 検尿"
"けんにん 建仁 堅忍 検認 兼任"
"けんのう 献納 権能"
"けんのん 険呑 険難 剣呑"
"けんはんしゃ 腱反射"
"けんば 犬馬"
"けんばいき 券売機"
"けんばく 懸瀑"
"けんばん 鍵板 検番 見番 鍵盤"
"けんぱ 検波"
"けんぱい 献盃 献杯"
"けんぱく 絹帛 建白"
"けんぱくどうい 堅白同異"
"けんひ 県費"
"けんび 兼備 顕微"
"けんびきょう 顕微鏡"
"けんびし 剣菱"
"けんぴ 建碑 県費"
"けんぴつ 健筆"
"けんぴょう 懸氷 堅氷"
"けんぴん 検品"
"けんぶ 兼部 剣舞"
"けんぶち 剣淵"
"けんぶつ 見物"
"けんぶりっじだいがく ケンブリッジ大学"
"けんぶん 見分 検分 見聞"
"けんぷ 乾符 賢婦 絹布"
"けんぷう 検封"
"けんぷじん 賢夫人"
"けんべつ 軒別 県別"
"けんべん 検便"
"けんぺい 兼併 権柄 憲兵"
"けんぺいりつ 建坪率 建ぺい率 建蔽率"
"けんぺん 権変 券片"
"けんほく 県北"
"けんぼ 賢母"
"けんぼう 絹紡 権謀 健忘"
"けんぼうし 絹紡糸"
"けんぼく 県木"
"けんぽ 兼補 健歩 健保"
"けんぽう 剣鋒 肩峰 建保 剣法 拳法 憲法"
"けんぽういん 憲法院"
"けんぽうじゅうしちじょう 憲法十七条"
"けんぽうだいきゅうじょう 憲法第九条"
"けんぽく 県北"
"けんぽん 献本 絹本"
"けんま 研摩 研磨"
"けんまく 劍幕 権幕 剣幕"
"けんまこくげき 肩摩轂撃"
"けんまこん 研磨痕"
"けんみ 検見"
"けんみつ 顕密"
"けんみん 建民 県民"
"けんみんし 遣明使"
"けんむ 建武 兼務"
"けんめ 件目"
"けんめい 県名 賢明 懸命 件名"
"けんめいしゅぎ 顕名主義"
"けんめん 券面"
"けんめんちょうしょ 検面調書"
"けんもち 犬持 剣持 堅持"
"けんもつ 献物 監物"
"けんもん 権門 検問 見聞"
"けんや 顕也 健弥 賢也"
"けんやく 倹約"
"けんやくせい 検約性"
"けんゆう 県有"
"けんゆうかん 健友館"
"けんゆうしゃ 硯友社"
"けんよう 建窯 顕要 顕揚 険要 兼用"
"けんようすい 懸壅垂"
"けんらん 絢爛"
"けんり 権利"
"けんりおち 権利落"
"けんりしち 権利質"
"けんりしょうてん 権利章典"
"けんりつ 建立 県立"
"けんりゃく 建暦"
"けんりゅう 劍竜 剣竜"
"けんりゅうけい 検流計"
"けんりょ 賢慮"
"けんりょう 見料 検量"
"けんりょく 権力"
"けんりよう 券利用"
"けんるい 堅塁"
"けんれい 県令"
"けんれいもんいん 建礼門院"
"けんれん 拳攣 眷恋 研連 県連"
"けんれんはん 牽連犯"
"けんろう 堅牢"
"けんろく 兼六"
"けんろん 圏論"
"けんわ 健和"
"けんわく 見惑"
"けんわんちょくひつ 懸腕直筆"
"げ 拐 睨 牙 觧 解 夏 偈 気 毛 外 下"
"げーじりゅうし ゲージ粒子"
"げーとぼーるじょう ゲートボール場"
"げーむか ゲーム化"
"げーむき ゲーム機"
"げーむさ ゲーム差"
"げーむせい ゲーム性"
"げーむちゅう ゲーム中"
"げーむのりろん ゲームの理論"
"げーむめい ゲーム名"
"げーむよう ゲーム用"
"げーむりろん ゲーム理論"
"げい 皃 囈 藝 麑 霓 貎 睨 猊 倪 迎 黥 鯨 芸"
"げいいき 芸域"
"げいいん 鯨飲"
"げいか 猊下"
"げいかい 芸界"
"げいかく 芸格"
"げいきょう 芸境"
"げいぎ 芸妓"
"げいげき 迎撃"
"げいげきみさいる 迎撃ミサイル"
"げいこ 藝子 稽古 芸子"
"げいこうだい 芸工大"
"げいご 囈語"
"げいごう 迎合"
"げいごと 芸事"
"げいざ 猊座"
"げいしゃ 迎車 芸者"
"げいしゅう 芸州"
"げいしゅん 迎春"
"げいしょうぎ 芸娼妓"
"げいじゅつ 藝術 芸術"
"げいじゅついん 芸術院"
"げいせい 芸西"
"げいせつ 迎接"
"げいたいかい 芸大会"
"げいたっしゃ 芸達者"
"げいたん 芸短"
"げいだい 芸大"
"げいだん 芸談"
"げいとう 藝當 芸当"
"げいどう 芸道"
"げいにく 鯨肉"
"げいにん 芸人"
"げいのう 芸濃 芸能"
"げいのうかいいり 芸能界入"
"げいは 鯨波"
"げいひん 迎賓"
"げいび 芸備"
"げいびけい 猊鼻渓"
"げいふう 芸風"
"げいぶん 芸文"
"げいほく 芸北"
"げいめい 芸名"
"げいゆ 鯨油"
"げいれき 芸歴"
"げいん 外印"
"げか 外科"
"げかい 外界 下回 下界"
"げかん 下澣 下浣 解官 外官 下官 下疳 下巻"
"げかんぱん 下甲板"
"げき 逆 鬩 郤 鷁 闃 屐 隙 戟 檄 外記 撃 激 劇"
"げきあせ 激汗"
"げきあま 激甘"
"げきえいが 劇映画"
"げきえつ 激越"
"げきおん 激音"
"げきおんがく 劇音楽"
"げきか 劇化 激化"
"げきかい 劇界"
"げきから 激辛"
"げきが 劇画"
"げきくうかん 劇空間"
"げきけん 撃剣"
"げきげん 激減"
"げきこう 激昂"
"げきこみ 激混"
"げきご 激語"
"げきさい 撃砕"
"げきさく 劇作"
"げきさっか 劇作家"
"げきさん 激賛"
"げきざる 外記猿"
"げきし 劇詩"
"げきしゃ 激写"
"げきしゅ 鷁首"
"げきしゅう 劇臭 激臭"
"げきしょ 劇暑 激暑"
"げきしょう 激奨 激症 激賞 劇症"
"げきしょく 激職"
"げきしん 撃針 激震"
"げきじゃく 激弱"
"げきじょう 撃攘 激情 劇場"
"げきじん 激甚"
"げきす 鷁首"
"げきせん 激戦"
"げきぜつ 鴃舌"
"げきぜん 闃然"
"げきそう 激走"
"げきぞう 激増"
"げきたい 撃退"
"げきたく 撃柝"
"げきだん 劇談 劇壇 劇団"
"げきちゅう 劇中"
"げきちん 撃沈"
"げきちんは 撃沈破"
"げきつい 撃墜"
"げきつう 劇痛 劇通 激痛"
"げきてき 劇的"
"げきてつ 撃鉄"
"げきとう 激闘"
"げきとつ 激突"
"げきど 激怒"
"げきどう 激動"
"げきどく 劇毒"
"げきなみだ 激涙"
"げきは 撃破"
"げきはく 激白"
"げきはつ 激発"
"げきはつぶつはれつざい 激発物破裂罪"
"げきばん 劇伴"
"げきひょう 劇評"
"げきぶつ 劇物"
"げきぶん 檄文"
"げきへん 激変"
"げきむ 劇務 激務"
"げきめつ 撃滅"
"げきやく 劇薬"
"げきやす 激安"
"げきやば 激ヤバ"
"げきょう 外教"
"げきりゅう 激流"
"げきりょく 撃力"
"げきりん 逆鱗"
"げきれい 激励"
"げきれつ 劇烈 激烈"
"げきろう 激浪"
"げきろん 激論"
"げぎ 外儀"
"げぎょ 懸魚"
"げくう 外宮"
"げぐう 外宮"
"げけつ 下血"
"げげ 解夏"
"げこ 下戸"
"げこう 還向 下向 下校"
"げこく 下刻"
"げこくじょう 下剋上"
"げこん 下根"
"げごく 下獄"
"げさく 下策 下作 外戚 戯作"
"げざ 下座"
"げざい 下剤"
"げざかな 下魚 下肴"
"げざん 下山"
"げし 夏至"
"げしき 景色"
"げしゃ 下車"
"げしゃく 外戚"
"げしゅく 下宿"
"げしゅにん 下手人"
"げしょ 外書 下書"
"げしょう 化粧"
"げじ 下知"
"げじく 牙軸"
"げじげじ 蚰蜒"
"げじゅ 偈頌"
"げじゅん 下旬"
"げじょ 下女"
"げじょう 下乗 下城"
"げじん 外陣"
"げす 下種 下司 下衆"
"げすい 下水"
"げすとじん ゲスト陣"
"げすとよう ゲスト用"
"げせわ 下世話"
"げせん 牙籤 下賤 下賎 下船"
"げそう 下僧"
"げそく 下足"
"げそくばこ 下足箱"
"げた 〓 下駄"
"げたばき 下駄履き"
"げたばこ 下駄箱"
"げたん 下端"
"げだい 外題"
"げだつ 解脱"
"げだん 下段"
"げち 下知"
"げっか 激化 月下"
"げっかこう 月下香"
"げっかん 月刊 月間"
"げっきゅう 月球 月給"
"げっきん 月琴"
"げっけい 月卿 月桂 月計 月経"
"げっけいじゅ 月桂樹"
"げっこう 激高 激昂 月光"
"げっこうちゅう 月光蟲"
"げっさん 月産"
"げっし 齧齒 齧歯"
"げっしゃ 月謝"
"げっしゅう 月収"
"げっしゅつ 月出"
"げっしょ 月初"
"げっしょう 月照 月商"
"げっしょく 月色 月蝕 月食"
"げっしるい げっ歯類"
"げっすいきん 月水金"
"げっすう 月数"
"げっせかい 月世界"
"げっせき 月夕"
"げっそう 月相"
"げったん 月旦"
"げっちょうせき 月長石"
"げっとう 月桃"
"げっぴょう 月評 月表"
"げっぷ 月賦"
"げっぺい 月餅"
"げっぽ 月歩"
"げっぽう 月俸 月報"
"げつ 蘖 囓 齧 月"
"げつうん 月暈"
"げつえい 月影"
"げつか 月火"
"げつかん 月間"
"げつがく 月額"
"げつげつかすいもくきんきん 月月火水木金金"
"げつご 月後"
"げつじ 月次"
"げつど 月度"
"げつない 月内"
"げつぶん 月分"
"げつまえ 月前"
"げつまつ 月末"
"げつまつじつ 月末日"
"げつめい 月明"
"げつめん 月面"
"げつもく 月木"
"げつや 月夜"
"げつよ 月余"
"げつよう 月曜"
"げつようよる 月曜夜"
"げつらい 月来"
"げつり 月利"
"げつりん 月輪"
"げつれい 月齢 月例"
"げて 下手"
"げてん 外典 下天"
"げとう 夏油"
"げどう 下道 外道"
"げどく 解毒"
"げなん 下男"
"げに 実に"
"げにん 解任 下人"
"げねつ 解熱"
"げはん 下阪"
"げば 下馬"
"げばぼう ゲバ棒"
"げひ 下卑"
"げひん 下品"
"げび 下卑"
"げぶみ 解文"
"げぶん 外文"
"げへん 下篇 下編"
"げほう 外法"
"げぼく 下僕"
"げめん 外面"
"げもん 解文"
"げや 下屋 下野"
"げらく 下落"
"げらずり ゲラ刷 ゲラ刷り"
"げり 下痢"
"げりどめ 下痢止め"
"げりべん 下痢便"
"げりゃく 下略"
"げりらせん ゲリラ戦"
"げりらてき ゲリラ的"
"げるか ゲル化"
"げるじょう ゲル状"
"げるちん ゲル沈"
"げるまんごは ゲルマン語派"
"げれつ 下劣"
"げろ 下呂"
"げろう 下臈 下郎 外郎"
"げん 嫌 芫 愿 广 訝 顏 彦 偐 諺 衒 眩 痃 呟 玄 儼 嚴 厳 眼 限 監 幻 軒 験 舷 絃 弦 元 原 源 減 言 現"
"げんあつ 減圧"
"げんあん 現案 原案"
"げんい 原意"
"げんいち 源一 元一"
"げんいん 現員 減員 原因"
"げんうん 眩暈"
"げんえい 元永 幻影"
"げんえき 減益 原液 現役"
"げんえきば 現役馬"
"げんえん 原猿 減煙 減塩"
"げんおう 玄奥 元応"
"げんおん 現音 原音"
"げんか 原歌 弦歌 絃歌 喧嘩 厳科 言下 現価 減価 現下 原価"
"げんかい 幻海 幻界 顕界 諺解 幻怪 言海 玄海 厳戒 限界"
"げんかいなだ 玄海灘 玄界灘"
"げんかく 幻覚 厳格"
"げんかくせいぶつ 原核生物"
"げんかつぎ ゲン担ぎ 験担ぎ"
"げんかわれ 原価割れ"
"げんかん 阮咸 減感 厳寒 玄関"
"げんかんまっと 玄関マット"
"げんが 原画"
"げんがい 限外 言外"
"げんがく 絃楽 衒学 弦楽 減額"
"げんがっき 絃楽器 弦楽器"
"げんがっきょく 弦楽曲"
"げんき 原基 原器 元亀 元気"
"げんきじるし 元気印"
"げんきゃく 減却"
"げんきゅう 原級 元久 減給 言及"
"げんきょ 原拠"
"げんきょう 元凶 現況"
"げんきょく 減極 原局 元曲 限局 原曲"
"げんきよし 元気良"
"げんきん 厳禁 現金"
"げんきんばらい 現金払"
"げんぎ 玄義 原義"
"げんぎょ 懸魚 言語"
"げんぎょう 現業"
"げんぎん 現銀"
"げんく 原句"
"げんくう 源空"
"げんくん 厳君 元勲"
"げんけい 厳刑 現形 減軽 元型 減刑 現計 原形 原型"
"げんけいしつまく 原形質膜"
"げんけん 原券 原研"
"げんげつ 弦月 限月"
"げんこ 儼乎 拳固"
"げんこう 原鉱 元后 元亨 原口 弦高 元弘 減耗 言行 減光 元寇 原稿 現行"
"げんこうしゃ 玄光社"
"げんこうしゃくしょ 元亨釈書"
"げんこく 玄穀 厳酷 現国 原告"
"げんこつ 拳骨"
"げんこん 眼根 現今"
"げんご 玄語 諺語 源語 幻語 源後 源吾 原語 言語"
"げんごう 減号 元号"
"げんごげーむ 言語ゲーム"
"げんごとう 言語島"
"げんごろう 源五郎"
"げんさい 衒妻 幻妻 現妻 減殺 減債"
"げんさきとりひき 現先取引"
"げんさく 減作 原作"
"げんさくどうぶつ 原索動物"
"げんさつ 減殺"
"げんさん 減産 減算 原産"
"げんざい 原罪 現在"
"げんざいやく 現在約"
"げんざぶろう 源三郎"
"げんざん 減算"
"げんし 元祀 元史 元始 原詩 原紙 減資 幻視 原資 原始 原子"
"げんしじだい 原史時代"
"げんしせい 原始星"
"げんしち 源七"
"げんしつ 言質 原質 玄室"
"げんしとう 原始島"
"げんしゃ 減車"
"げんしゃく 現尺"
"げんしゃほう 現写法"
"げんしゅ 原酒 原種 元首 厳守"
"げんしゅう 現収 幻臭 減収"
"げんしゅく 減縮 厳粛"
"げんしゅつ 幻出 現出"
"げんしょ 厳暑 原初 原書"
"げんしょう 現症 減少 現象"
"げんしょうてんのう 元正天皇"
"げんしょく 減食 減色 原色 現職"
"げんしりきこうがっか 原子力工学科"
"げんしりん 原始林"
"げんしろう 源四郎"
"げんしん 現身 原審 原信"
"げんしんごう 元信号"
"げんじ 玄二 現示 源治 原字 現時 言辞 元治 源氏"
"げんじつ 現実"
"げんじてきしょうひ 衒示的消費"
"げんじな 源氏名"
"げんじばこ 源氏箱"
"げんじほう 限時法"
"げんじゃく 減弱"
"げんじゅう 幻獣 現住 厳重"
"げんじゅうろう 幻十郎"
"げんじゅつ 幻術"
"げんじょう 現成 玄奘 現場 原状 現状"
"げんじろう 源二郎"
"げんじん 減尽 幻人 眩人 原人"
"げんすい 減水 元帥 減衰"
"げんすう 元数 現数 減数"
"げんすん 原寸"
"げんず 原図"
"げんせ 現世"
"げんせい 現姓 現勢 現生 原生 現世 厳正"
"げんせいりん 原生林"
"げんせき 言責 原籍 原石"
"げんせつ 言説"
"げんせん 言泉 原潜 源泉 厳選"
"げんぜい 減税"
"げんぜん 儼然 現前 厳然"
"げんそ 原素 元素"
"げんそう 現送 舷窓 玄宗 幻想"
"げんそく 舷側 減速 原則"
"げんそん 厳存 玄孫 減損 現存"
"げんぞう 幻像 原像 現像"
"げんぞく 還俗"
"げんぞん 現存"
"げんた 玄太 元太 源太"
"げんたい 原態 原隊 減退"
"げんたつ 厳達"
"げんたろう 厳太郎"
"げんたん 減反"
"げんだ 源田"
"げんだい 原題 現代"
"げんだいかなづかい 現代仮名遣"
"げんだいし 現代詩"
"げんだか 現高"
"げんち 玄地 言質 現地"
"げんちがし 現地貸"
"げんちづま 現地妻"
"げんちゃ 原チャ"
"げんちゃり 原チャリ"
"げんちゅう 原註 原注 原虫 元中"
"げんちょ 原著"
"げんちょう 現調 弦長 幻聴"
"げんつき 原付"
"げんてい 舷梯 限定"
"げんてん 原典 減点 原点"
"げんとう 舷灯 幻灯 幻燈 厳冬"
"げんとく 験徳 元徳 玄徳"
"げんとして 厳として"
"げんど 限度"
"げんどう 原動 言動"
"げんな 元和"
"げんない 源内"
"げんなおし 験直し"
"げんなま 現ナマ 現生"
"げんに 現に"
"げんにほんご 源日本語"
"げんにん 元仁 現認 現任"
"げんのう 言翁 玄応 源翁 玄翁 玄能"
"げんのしょうこ 現の証拠"
"げんば 玄蕃 現場"
"げんばく 玄麦 原爆"
"げんばくどーむ 原爆ドーム"
"げんばつ 厳罰"
"げんばん 原盤 原版"
"げんぱい 減配"
"げんぱく 玄白"
"げんぱつ 原発"
"げんぱつせいめんえきふぜんしょうこうぐん 原発性免疫不全症候群"
"げんぱつそう 原発巣"
"げんぱん 原版"
"げんびん 減便"
"げんぴ 厳秘 元妃 原皮"
"げんぴょう 原票"
"げんぴん 原品 現品"
"げんぶ 玄武"
"げんぶがん 玄武岩"
"げんぶつ 原物 現物"
"げんぶん 言文 元文 原文"
"げんぶんそう 弦分奏"
"げんぷ 現夫 原譜 厳父"
"げんぷう 厳封"
"げんぷく 元服"
"げんぺい 源平"
"げんぺいとうきつ 源平藤橘"
"げんぼ 原簿"
"げんぼく 原木"
"げんぼん 原本"
"げんぽう 現法 減俸 減法"
"げんぽん 原本"
"げんま 玄馬 幻魔 減摩"
"げんまい 玄米"
"げんまいぱん 玄米パン"
"げんまき 弦巻"
"げんまつ 原末"
"げんまん 拳万"
"げんみつ 厳密"
"げんみょう 玄妙"
"げんむ 幻梦 幻夢"
"げんめ 限目"
"げんめい 厳命 言明"
"げんめいがっき 弦鳴楽器"
"げんめいてんのう 元明天皇"
"げんめつ 減滅 幻滅"
"げんめん 原綿 減免"
"げんもう 原毛 減耗"
"げんもく 眩目"
"げんもん 厳門"
"げんや 幻夜 原野"
"げんゆ 原油"
"げんゆう 現有"
"げんよう 幻幼 原葉 幻妖 現用"
"げんり 原理"
"げんりつ 厳律"
"げんりゃく 元暦"
"げんりゅう 原流 源流"
"げんりゅうち 限流値"
"げんりょう 限量 減量 原料"
"げんりょく 減力"
"げんろう 元老"
"げんろういん 元老院"
"げんろく 元禄"
"げんろん 原論 言論"
"げんろんのじゆう 言論の自由"
"げんわ 元和"
"げんわく 眩惑 幻惑"
"こ 濾 濃 ⌒ 来 黄 木 炬 虚 去 杞 己 粐 辜 蠱 箍 滸 賈 股 拠 冱 冴 胯 瓠 桍 夸 刳 跨 誇 袴 滬 扈 瞽 皷 鼓 顧 雇 壷 壺 徠 來 虍 琥 乕 虎 觚 柧 呱 菰 狐 孤 錮 痼 涸 凅 餬 蝴 葫 楜 瑚 糊 鴣 詁 蛄 罟 怙 沽 估 鈷 胡 枯 姑 乎 呼 女 娘 兒 児 仔 ヶ 个 箇 固 戸 庫 湖 弧 粉 古 故 個 小 子"
"こーかさす 高加索"
"こーすじょう コース上"
"こーすりょうり コース料理"
"こーちじん コーチ陣"
"こーつ 刻子"
"こーとし コート紙"
"こーどか コード化"
"こーどしんこう コード進行"
"こーどふ コード譜"
"こーどへんかん コード変換"
"こーひー 珈琲"
"こーひーてん コーヒー店"
"こーひーまめ 珈琲豆 コーヒー豆"
"こーひーや コーヒー屋"
"こーらすぶ コーラス部"
"こーりゃん 高粱"
"こーるしじょう コール市場"
"こーるてん コール天"
"こーんゆ コーン油"
"こあきない 小商い"
"こあくつ 小圷"
"こあくとう 小悪党"
"こあくま 小悪魔"
"こあげ 小揚"
"こあざ 小字"
"こあし 小足"
"こあじ 小鰺 小味 小アジ"
"こあたま 小頭"
"こあたり 小当り 小当たり"
"こあな 小穴"
"こあみ 小網"
"こあゆ 小鮎"
"こあら 古荒"
"こい 戀 請い 湖衣 古意 濃 鯉 故意 恋"
"こいうた 恋唄 恋歌"
"こいうらない 恋占い"
"こいえ 小家"
"こいおおき 恋多き"
"こいかぜ 恋風"
"こいがくぼ 恋ヶ窪"
"こいがたき 恋敵"
"こいがわ 鯉川"
"こいき 小意気 小粋"
"こいくち 濃い口 濃口"
"こいぐち 鯉口"
"こいけ 菰池 小池"
"こいけだ 小池田"
"こいこ 恋子"
"こいこく 鯉濃"
"こいごころ 恋心"
"こいし 恋し 礫 小石"
"こいしかわ 小石川"
"こいしわら 小石原"
"こいじ 恋路"
"こいずみ 古泉 小泉"
"こいそ 小磯"
"こいた 小板"
"こいち 小市"
"こいちじかん 小一時間"
"こいちゃ 濃茶"
"こいづま 恋妻"
"こいで 小出"
"こいと 小糸"
"こいなか 恋仲"
"こいにょうぼう 恋女房"
"こいぬ 小犬 仔犬 子犬"
"こいぬま 濃沼 鯉沼"
"こいねこ 恋猫"
"こいねず 濃鼠"
"こいのたきのぼり 鯉の滝登り"
"こいのぼり 鯉幟"
"こいのやまい 恋の病"
"こいひとよ 恋一夜"
"こいひめ 湖衣姫"
"こいびと 恋人"
"こいぶち 鯉渕 鯉淵"
"こいぶみ 恋文"
"こいほう 古医方"
"こいまり 古伊万里"
"こいむらさき 濃紫"
"こいめ 濃いめ 濃い目"
"こいも 子芋 小芋"
"こいものがたり 恋物語"
"こいもよう 恋模様"
"こいやみ 恋病み"
"こいわ 小岩"
"こいわい 小岩井"
"こいわずらい 恋患い 恋煩い"
"こいん 雇員"
"こいんたい 古印体"
"こう 湊 衝 河 頁 昴 嵩 神 格 棡 剛 崗 岡 尻 鏗 薨 耿 羔 纐 磽 爻 烋 汞 嫦 膠 衡 庚 巷 興 撹 蚣 冦 寇 槹 昊 杲 皋 皐 肓 淆 肴 肯 扣 釦 叩 黌 鑛 簧 礦 曠 廣 壙 黄 闔 溘 盍 猴 喉 鱇 慷 糠 康 鴿 洽 峇 蛤 閤 恰 袷 熕 槓 貢 仰 昂 胱 絖 洸 晄 恍 滉 幌 晃 隍 鍠 遑 蝗 煌 湟 惶 徨 凰 皇 靠 誥 窖 晧 皓 浩 閘 胛 狎 呷 匣 岬 鬨 閧 哄 洪 攷 攻 絎 桁 鴻 訌 肛 缸 矼 扛 虹 紅 箜 椌 啌 倥 腔 控 頏 吭 伉 亢 杭 坑 遘 覯 冓 篝 搆 媾 購 溝 構 亘 亙 恆 恒 睾 倖 幸 逅 詬 后 垢 嚆 藁 塙 槁 鎬 稾 犒 敲 縞 慌 荒 峺 哽 梗 更 耗 畊 耕 鵁 餃 佼 蛟 皎 狡 效 咬 傚 鮫 郊 絞 効 交 弘 絋 昿 砿 肱 紘 浤 宏 勾 鈎 鉤 怐 佝 拘 吼 哮 酵 絳 降 巧 向 国府 乞 斯う 航 抗 鉱 候 侯 講 鋼 綱 膏 孔 光 好 後 稿 港 江 工 厚 硬 広 高 行 校 口 香 甲 劫 功 孝 考 項 公"
"こうあ 興亜"
"こうあっしつ 高圧室"
"こうあっしゅく 高圧縮"
"こうあつ 光圧 降圧 高圧"
"こうあつがす 高圧ガス"
"こうあん 甲案 康安 弘安 公案 公安 考案"
"こうあんてんのう 孝安天皇"
"こうい 口胃 校異 校尉 攻囲 皇位 校医 更衣 好位 高位 厚意 好意 行為"
"こういき 高域 広域"
"こういしょう 後遺症"
"こういち 高1 高１ 講一 興市 耿一 晃市 康市 鉱一 航一 巧一 幸市 好一 高一 剛一 孝市 興一 康一 功一 弘一 晃一 宏一 孝一 耕一 幸一 光一 公一 浩一"
"こういちろう 宏一良 幸一朗 晃一朗 鴻一郎"
"こういってん 紅一点"
"こういつ 後逸"
"こういど 高緯度"
"こういろ 香色"
"こういん 皇胤 勾引 荒淫 後胤 拘引 後印 光陰 工員 行員 公印"
"こうう 項羽 降雨"
"こううつざい 抗うつ剤 抗鬱剤"
"こううつやく 抗うつ薬 抗鬱薬"
"こううりん 後右輪"
"こううん 光暈 皇運 航運 行雲 耕耘 好運 幸運"
"こううんかく 光雲閣"
"こううんき 耕運機"
"こううんてんだい 高運転台"
"こうえ 黄衣 香会"
"こうえい 光影 康永 後裔 後衛 公営 光栄"
"こうえいば 公営馬"
"こうえいへい 紅衛兵"
"こうえき 公役 交易 公益"
"こうえつ 光悦 校閲"
"こうえねけん 高エネルギー物理学研究所 高エネルギー研究所 高エネ研"
"こうえねるぎー 高エネルギー"
"こうえん 溘焉 香烟 香煙 巧演 講筵 光焔 光炎 紅焔 紅炎 宏遠 後縁 高塩 光塩 口演 好演 高遠 後援 公演 講演 公園"
"こうえんじ 高円寺"
"こうえんでびゅー 公園デビュー"
"こうお 好悪"
"こうおう 康応"
"こうおつ 甲乙"
"こうおつつけ 甲乙付"
"こうおつへい 甲乙丙"
"こうおつへいてい 甲乙丙丁"
"こうおん 高恩 皇恩 厚恩 硬音 口音 喉音 構音 恒温 高音 高温"
"こうか 孔果 甲賀 膠化 功科 黄禍 高歌 紅霞 弘化 晃華 降嫁 校下 光華 考課 紅花 公課 工科 硬貨 高架 降下 硬化 校歌 高価 効果"
"こうかーど 好カード"
"こうかい 後回 狡獪 叩解 鋼塊 香会 江海 紅海 黄海 公海 降灰 公会 高階 更改 航海 後悔 公開"
"こうかいかいゆう 降海回遊"
"こうかいかぎ 公開鍵"
"こうかいがた 降海型"
"こうかいぞうど 高解像度"
"こうかいてん 高回転"
"こうかかいゆう 降河回遊"
"こうかがく 光化学"
"こうかがくすもっぐ 光化学スモッグ"
"こうかきかえ 項書換え"
"こうかきょう 高架橋"
"こうかぎょ 降河魚"
"こうかく 攻殻 厚角 後覚 岬角 高閣 交角 光覚 紅鶴 高角 甲殻 口角 広角 降格"
"こうかくじゅう 甲殻獣"
"こうかくてんのう 光格天皇"
"こうかくりつ 高確率"
"こうかくるい 甲殼類"
"こうかくれんず 広角レンズ"
"こうかじゅう 高荷重"
"こうかっせい 高活性"
"こうかつ 広闊 口渇 狡猾"
"こうかふこうか 幸か不幸か"
"こうかみ 鴻上"
"こうかもんいんのべっとう 皇嘉門院別当"
"こうかろりー 高カロリー"
"こうかん 槓桿 槓杆 肛姦 校勘 光環 後患 向寒 浩瀚 江漢 皇漢 好漢 交感 巷間 公刊 公館 交歓 鋼管 高官 好感 交換"
"こうかんけい 項関係"
"こうかんじり 交換尻"
"こうかんとれーど 交換トレード"
"こうかんど 高感度"
"こうかんばり 交換針"
"こうかんまく 交換膜"
"こうが 江河 光画 高雅 黄河 甲賀"
"こうがい 慷概 慷慨 坑外 構外 港外 笄 鉱害 光害 梗概 口蓋 口外 校外 公害 郊外"
"こうがいじ 紅孩児"
"こうがいすい 口蓋垂"
"こうがいはん 口蓋帆"
"こうがいびる 笄蛭"
"こうがいわげ 笄髷"
"こうがく 溝壑 皇学 好学 向学 後学 高額 光学 工学"
"こうがくいん 工学院"
"こうがくじ 光学事"
"こうがくねん 高学年"
"こうがくれき 高学歴"
"こうがしつ 高画質"
"こうがしゃ 恒河沙"
"こうがっか 工学課 工学科"
"こうがっかい 工学会"
"こうがん 紅顔 厚顔 睾丸"
"こうがんざい 抗ガン剤 抗がん剤 抗癌剤"
"こうき 高機 好輝 幸毅 浩貴 光樹 幸喜 弘毅 康熈 公起 校紀 校規 口器 好期 衡機 広軌 後気 紅旗 康煕 好気 興起 公器 綱紀 降旗 皇紀 校旗 香気 好奇 工機 光輝 好機 高貴 工期 後記 後期"
"こうきあつ 高気圧"
"こうきかく 高規格"
"こうきち 厚吉 耕吉 光吉 康吉 孝吉 幸吉"
"こうきでん 弘徽殿"
"こうきど 高輝度"
"こうきみつ 高気密"
"こうきゃく 後脚"
"こうきゅう 購求 攻究 皇宮 好球 硬球 降給 降級 光球 鋼球 公休 講究 考究 後宮 高給 恒久 高級"
"こうきゅうぎょ 高級魚"
"こうきゅうし 後臼歯"
"こうきゅうすいせい 高吸水性"
"こうきゅうぶらんど 高級ブランド"
"こうきょ 鉤距 公許 溝渠 薨去 皇居"
"こうきょう 荒凶 口供 広狭 鋼橋 高教 好況 交響 公共"
"こうきょうがく 交響楽"
"こうきょうさーびす 公共サービス"
"こうきょうし 交響詩"
"こうきょうどぶんぷ 光強度分布"
"こうきょうのふくし 公共の福祉"
"こうきょうようり 公教要理"
"こうきょく 鉤曲"
"こうきん 行金 咬筋 黄巾 口琴 拘禁 公金 抗菌"
"こうきんのらん 黄巾の乱"
"こうきんり 高金利"
"こうぎ 高誼 好誼 恒偽 後魏 巧技 公議 後戯 交誼 厚誼 公儀 広義 抗議 講義"
"こうぎいん 工業技術院 工技院"
"こうぎけん 航技研"
"こうぎじゅつぶ 光技術部"
"こうぎでも 抗議デモ"
"こうぎょ 香魚"
"こうぎょう 鴻業 功業 航業 鋼業 興行 興業 鉱業 工業"
"こうぎょく 鋼玉 硬玉 紅玉"
"こうぎょくしゃ 攻玉社"
"こうぎょくてんのう 皇極天皇"
"こうぎわ 髪際"
"こうぎん 興銀"
"こうく 鉤矩 鉱区 工区 校区"
"こうくう 高空 口腔 航空"
"こうくうがん 口腔癌"
"こうくつ 後屈"
"こうくり 高勾麗 高句麗"
"こうくん 校訓"
"こうぐ 校具 耕具 香具 工具"
"こうぐう 后宮 皇宮 厚遇"
"こうぐち 坑口 高口"
"こうぐん 蝗軍 皇軍 行軍"
"こうけい 皇系 項型 皇兄 肯綮 好形 口形 後経 後景 後傾 黄経 後継 口径 光景"
"こうけいしつ 後形質"
"こうけいしゃなん 後継者難"
"こうけいば 後継馬"
"こうけち 纐纈"
"こうけっとう 高血糖"
"こうけつ 絞結 紅血 膏血 纐纈 硬結 高潔"
"こうけつあつ 高血圧"
"こうけん 甲券 後験 硬券 光顕 後件 効験 高見 工研 公権 高検 後見 貢献"
"こうけんてんのう 孝謙天皇"
"こうげ 香華 高下"
"こうげーむ 好ゲーム"
"こうげい 虹霓 工藝 工芸"
"こうげき 攻撃"
"こうげきだま 攻撃玉"
"こうげきへり 攻撃ヘリ"
"こうげつ 香月"
"こうげん 口減 抗言 鉤玄 康元 巧言 高言 広言 荒原 膠原 抗原 公言 光源 高原"
"こうげんがく 考現学"
"こうげんさい 公現祭"
"こうげんてんのう 孝元天皇"
"こうこ 香粉 後顧 好個 江湖 好古 考古 公庫"
"こうこう 鉤校 交媾 硬膏 浩浩 鉱坑 後項 硬鋼 膏肓 後考 後行 耿々 皎々 皓々 工高 港口 坑口 口腔 後攻 煌々 孝行 航行 高校"
"こうこうがい 硬口蓋"
"こうこうぎょう 鉱工業"
"こうこうさ 光行差"
"こうこうせい 向光性 好光性"
"こうこうてい 高高低"
"こうこうてんのう 光孝天皇"
"こうこうど 高々度 高高度"
"こうこうむすめ 孝行娘"
"こうこうや 好々爺 好好爺"
"こうこうりつ 高効率"
"こうこく 皇國 廣告 侯国 鴻鵠 抗告 興国 皇国 公国 公告 広告"
"こうこくとう 広告塔"
"こうこすと 高コスト"
"こうこつ 甲骨 硬骨 恍惚"
"こうこつかん 硬骨漢"
"こうこつぎょ 硬骨魚"
"こうこん 後根"
"こうご 庚午 向後 口語 交互"
"こうごう 媾合 交合 校合 香合 咬合 皇后"
"こうごうせい 光合成"
"こうごかん 高互換"
"こうごき 小動き"
"こうごきたい 乞御期待"
"こうごし 口語詩"
"こうごねんじゃく 庚午年籍"
"こうごのうみんせんそう 甲午農民戦争"
"こうさ 巧詐 甲佐 較差 交叉 公差 黄砂 考査 交差"
"こうさい 口才 高斎 公済 甲西 香西 香菜 後妻 虹彩 光彩 公債 高裁 交際"
"こうさいかい 弘済会"
"こうさいどう 廣済堂"
"こうさいぼう 膠細胞"
"こうさいりくり 光彩陸離"
"こうさいりんどう 弘西林道"
"こうさか 香阪 江坂 上阪 幸坂 上坂 神坂 香坂 高坂"
"こうさき 神前"
"こうさく 鉤索 鋼索 耕筰 幸作 耕作 交錯 工作"
"こうさつ 高察 高札 絞殺 考察"
"こうさん 高3 高３ 高三 公散 考算 恒産 鉱産 抗酸 好酸 興産 降参 公算"
"こうさんきんびょうけんきゅうじょ 抗酸菌病研究所"
"こうざ 硬座 高座 口座 講座"
"こうざい 絞罪 香西 功罪 鋼材"
"こうざいしっそく 高材疾足"
"こうざき 神崎"
"こうざつ 交雑"
"こうざつぎょ 交雑魚"
"こうざひきおとし 口座引落"
"こうざぶろう 幸三郎"
"こうざん 鑛山 恒山 衡山 後産 江山 甲山 鉱山 高山"
"こうし 合志 鉤止 講士 郊祀 皓歯 更始 皇嗣 工師 後嗣 黄紙 鉱滓 考試 犢 紅紫 甲子 高師 後翅 後肢 皇子 孝子 公子 高士 仔牛 嚆矢 公使 厚志 公司 孔子 子牛 公私 光子 格子 行使 講師"
"こうしいん 考試院"
"こうしき 項式 講式 硬式 公式"
"こうしきさいと 公式サイト"
"こうしけご 孔子家語"
"こうしけっしょう 高脂血症"
"こうしけつしょう 高脂血症"
"こうしじま 格子縞"
"こうしせい 高姿勢"
"こうしそうにく 行尸走肉"
"こうしちょうりつ 高視聴率"
"こうしつ 膠質 後室 高質 皇室 硬質"
"こうしつど 高湿度"
"こうしつようざいさん 皇室用財産"
"こうしど 格子戸"
"こうしびょう 孔子廟"
"こうしぼう 高脂肪"
"こうしまど 格子窓"
"こうしゃ 稿者 後車 公舎 巧者 降車 後者 校舎 公社"
"こうしゃく 侯爵 講釈 公爵"
"こうしゃほう 高射砲"
"こうしゅ 鉤取 後手 巧手 校主 工手 絞首 好手 公主 好守 甲種 攻守"
"こうしゅう 紅萩 後周 抗州 興収 杭州 甲州 広州 口臭 公衆 講習"
"こうしゅうえき 高収益"
"こうしゅうおんど 江州音頭"
"こうしゅうせい 光周性"
"こうしゅうせき 高集積"
"こうしゅうといれ 公衆トイレ"
"こうしゅうにゅう 高収入"
"こうしゅうは 高周波"
"こうしゅうはねつれん 高周波熱錬"
"こうしゅく 拘縮"
"こうしゅそう 攻守走"
"こうしゅつ 後出"
"こうしゅつよう 高出葉"
"こうしゅつりょく 高出力"
"こうしゅん 香春"
"こうしょ 口書 公書 好処 高書 校書 購書 講書 向暑 公署 高所"
"こうしょう 光昭 康正 巧匠 洪鐘 好尚 口誦 黄鐘 後章 高唱 行賞 公娼 高承 咬傷 公傷 公章 工匠 厚相 口承 哄笑 工廠 鉱床 工商 公証 校章 考証 高尚 公称 交渉"
"こうしょうきょくく 鉤章棘句"
"こうしょうじ 光照寺"
"こうしょうてんのう 孝昭天皇"
"こうしょうど 高照度"
"こうしょく 後蜀 降職 紅色 黄色 交織 更埴 好色 公職"
"こうしょくいちだいおとこ 好色一代男"
"こうしょくいちだいおんな 好色一代女"
"こうしょくかん 好色漢"
"こうしょとく 高所得"
"こうしろう 幸四郎"
"こうしん 後晋 紅唇 貢進 恒真 恒心 孝心 昂進 高進 功臣 後身 庚申 口唇 亢進 後進 交信 行進 更新"
"こうしんえつ 甲信越"
"こうしんくう 高真空"
"こうしんげがき 江岑夏書"
"こうしんじゅつ 降神術"
"こうしんじょ 興信所"
"こうしんちぇっく 更新チェック"
"こうしんちほう 甲信地方"
"こうしんづか 庚申塚"
"こうしんどう 高振動"
"こうしんらい 高信頼"
"こうしんりょう 香辛料"
"こうしんりょく 向心力"
"こうしんろく 興信録"
"こうじ 考爾 香次 晧司 功志 吼児 滉二 剛次 浩仁 虹児 広二 厚二 貢司 甲児 皓司 耕次 功児 恒治 幸志 光次 宏次 康次 弘司 広治 弘二 公司 光二 浩次 浩志 耕二 孝次 浩治 宏治 幸次 孝二 耕治 康司 耕司 康治 弘治 孝司 晃司 康二 幸二 光司 幸司 孝治 幸治 浩司 浩二 鉤餌 交事 好餌 柑子 後事 公事 好事 糀 小路 高次 麹 公示 工事"
"こうじえん 広辞苑"
"こうじかい 高磁界"
"こうじき 光磁気"
"こうじきょく 航時局"
"こうじきん 麹菌"
"こうじく 向軸 光軸"
"こうじつ 後日 好日 口実"
"こうじつせい 向日性"
"こうじつびきゅう 曠日弥久"
"こうじば 高磁場"
"こうじまおおし 好事魔多し"
"こうじまち 麹町"
"こうじもーど 高次モード"
"こうじゅ 皇寿 坑儒 口授"
"こうじゅうしん 高重心"
"こうじゅうりょく 高重力"
"こうじゅく 黄熟"
"こうじゅつ 公述 講述 口述 後述"
"こうじゅん 後順 恒順 孝順 公準 交詢 降順"
"こうじゅんい 高順位"
"こうじゅんしゃ 交殉社"
"こうじゅんど 高純度"
"こうじょ 後序 孝女 公序 公女 皇女 控除"
"こうじょう 鉤縄 皇城 交情 光条 甲状 恒常 厚情 攻城 荒城 口上 工場 向上"
"こうじょうせいしゅこうぎょう 工場制手工業"
"こうじょうせんほるもん 甲状腺ホルモン"
"こうじょうのつき 荒城の月"
"こうじょうわたし 工場渡"
"こうじろ 神代"
"こうじん 紅塵 黄塵 後陣 後人 高人 後塵 工人 荒神 幸甚 行人 公人"
"こうじんしゃ 工人舎"
"こうすい 交綏 鉱水 幸水 硬水 降水 香水"
"こうすいい 高水位"
"こうすいおん 高水温"
"こうすいじゅん 高水準"
"こうすいびん 香水瓶"
"こうすう 恒数 項数 校数 工数 口数"
"こうすけ 江介 廣祐 広介 功介 宏祐 宏介 幸輔 康祐 耕助 耕輔 康介"
"こうすたーと 好スタート"
"こうず 国府津 高津 神津 好事 公図 構図"
"こうずい 洪水"
"こうずけ 上野"
"こうずけのすけ 上野介"
"こうずしま 神津島"
"こうせ 興世"
"こうせい 佼正 貢成 煌星 行星 耕生 幸生 高生 江青 甦生 佼成 甲西 校生 抗生 好晴 高声 硬性 較正 向性 江西 広西 鋼製 恒星 厚生 更正 更生 後生 後世 攻勢 校正 公正 構成"
"こうせいきょく 交声曲"
"こうせいぎんこう 恒生銀行"
"こうせいさい 高精細"
"こうせいしんやく 向精神薬"
"こうせいずり 校正刷 校正刷り"
"こうせいせつ 後成説"
"こうせいちょう 高成長"
"こうせいど 高精度"
"こうせいのう 高性能"
"こうせいのか 高性能化"
"こうせき 鑛石 講席 洪積 行跡 口跡 光跡 航跡 鉱石 功績"
"こうせきうん 高積雲"
"こうせつ 紅雪 講説 後節 高説 交接 巧拙 巷説 公設 降雪"
"こうせん 工業高等専門学校 工銭 工船 工繊 口銭 交線 黄泉 工専 高専 鋼線 公選 鉱泉 好戦 交戦 抗戦 光線"
"こうせんさく 鋼線索"
"こうせんじゅう 光線銃"
"こうせんりょう 高線量"
"こうぜい 行成"
"こうぜつ 高舌 後舌 口舌"
"こうぜん 紅髯 煌然 皓然 昂然 浩然 公然"
"こうぜんじ 光善寺"
"こうぜんのき 浩然の気"
"こうそ 貢租 江蘇 皇祖 高祖 公租 公訴 控訴 酵素"
"こうそう 皇宗 厚葬 鉱層 公葬 高燥 宏壮 広壮 厚層 降霜 紅藻 高宗 航送 後奏 後送 好走 高僧 香草 抗争 高層 構想"
"こうそううん 高層雲"
"こうそうさせい 高操作性"
"こうそうば 好走馬"
"こうそうびる 高層ビル"
"こうそうぼく 高草木"
"こうそく 高足 航測 光束 梗塞 校則 光速 拘束 高速"
"こうそくい 拘束衣"
"こうそくだん 高速弾"
"こうそくばす 高速バス"
"こうそつ 高卒"
"こうそふ 高祖父"
"こうそぼ 高祖母"
"こうそん 荒村 皇孫"
"こうぞ 楮"
"こうぞう 肯三 行三 弘蔵 孝蔵 孝三 耕造 浩三 耕三 幸三 構造"
"こうぞがみ 楮紙"
"こうぞく 航続 皇族 後続"
"こうぞくば 後続馬"
"こうた 恒太 晃太 幸田 小歌 小唄"
"こうたい 剛体 交替 抗体 後退 交代"
"こうたいあつ 高耐圧"
"こうたいか 鋼体化"
"こうたいごう 皇太后"
"こうたいし 皇太子"
"こうたいしひ 皇太子妃"
"こうたいそん 皇太孫"
"こうたいよう 向太陽"
"こうたく 光澤 光沢"
"こうたくみん 江沢民"
"こうたけ 革茸"
"こうたつ 公達"
"こうたに 甲谷"
"こうたり 神足"
"こうたろう 輝太郎 晃太朗 廣太郎 高太郎 弘太郎 孝太郎 浩太郎 幸太郎 耕太郎 光太郎"
"こうたん 浩嘆 浩歎 荒誕 降誕 後端"
"こうたんせい 抗堪性"
"こうたんぱく 高タンパク"
"こうだ 黄田 古宇田 好田 光田 行田 国府田 國府田 香田 甲田 神田 幸田 叩打 好打 巧打"
"こうだい 洪大 香台 航大 工大 高大 高台 宏大 浩大 後代 広大"
"こうだえき 江田駅"
"こうだおん 後打音"
"こうだか 甲高"
"こうだく 黄濁"
"こうだて 劫立て"
"こうだりつ 高打率"
"こうだん 高談 降段 光弾 降壇 巷談 講壇 高段 講談 後段 公団"
"こうだんし 皇男子"
"こうだんねつ 高断熱"
"こうち 狡智 公地 巧遅 狡知 好地 高置 後置 幸地 巧緻 拘置 公知 河内 高地 耕地 高知"
"こうちがり 小内刈り"
"こうちく 構築"
"こうちせい 向地性"
"こうちゃ 紅茶"
"こうちゃく 降着 膠着"
"こうちゅう 甲冑 蝗虫 工注 校註 校注 甲虫 口中"
"こうちゅうきゅう 好中球"
"こうちゅうじつ 高忠実"
"こうちょ 高著 光緒 好著"
"こうちょう 腔腸 弘長 硬調 高調 高張 高潮 公聴 紅潮 校長 好調"
"こうちょく 交直 硬直"
"こうちん 工賃"
"こうちんぎん 高賃金"
"こうつ 刻子"
"こうつい 項対"
"こうつう 交通"
"こうつうほういはん 交通法違反"
"こうづ 高津 国府津"
"こうづき 神月 上月 香月"
"こうづけ 上野"
"こうづけのすけ 上野介"
"こうづしま 神津島"
"こうてい 鉤悌 公廷 考訂 更訂 孝悌 後庭 校定 皇弟 航程 黄帝 高弟 公定 校訂 公邸 校庭 高低 行程 肯定 皇帝 工程"
"こうていあくせんと 高低アクセント"
"こうていえき 口蹄疫"
"こうていてい 高低低"
"こうていぺんぎん 皇帝ペンギン"
"こうてき 好適 公的"
"こうてつ 更迭 鋼鉄"
"こうてん 好点 皇天 高点 後天 光点 後転 公転 荒天 交点 好天 好転"
"こうてんし 告天子"
"こうで 小腕"
"こうでい 膠泥 拘泥"
"こうでら 香寺"
"こうでん 公電 光電 香奠 香典"
"こうでんあつ 高電圧"
"こうでんしゃ 弘電社 高電社"
"こうでんそくこう 光電測光"
"こうでんち 光電池"
"こうでんぱ 光電波"
"こうと 狡兎 皇都"
"こうとう 昂騰 降等 高踏 叩頭 紅灯 公党 皇統 恒等 口答 後頭 勾当 江東 喉頭 好投 高騰 口頭 高等"
"こうとうがい 喉頭蓋"
"こうとうがん 喉頭癌"
"こうとうきょう 喉頭鏡"
"こうとうふ 皇統譜"
"こうとうほういん 高等法院"
"こうとうむけい 荒唐無稽"
"こうとく 行徳 康徳 公徳 神徳 光徳 幸徳 孝徳 高徳"
"こうとくてん 高得点"
"こうとりい 公取委"
"こうど 公度 荒土 耕土 黄土 光度 硬度 高度"
"こうどう 皇道 高堂 孝道 黄道 黄銅 坑道 香道 公道 講堂 行動"
"こうどうかん 弘道館 講道館"
"こうどうきちにち 黄道吉日"
"こうどうぱたーん 行動パターン"
"こうどく 鉱毒 講読 購読"
"こうない 坑内 港内 口内 構内 校内"
"こうなご 小女子"
"こうなん 後難 香南 硬軟 甲南 港南 江南"
"こうに 高2 高２ 高二"
"こうにち 抗日"
"こうにゅう 購入"
"こうにん 降任 弘仁 高人 後任 公認"
"こうにんてんのう 光仁天皇"
"こうねい 康寧"
"こうねつ 光熱 高熱"
"こうねつすいりょう 光熱水料"
"こうねん 降年 高年 行年 光年 後年"
"こうねんき 更年期"
"こうねんしょうど 高燃焼度"
"こうねんぴ 高燃費"
"こうねんぽう 高年俸"
"こうねんれい 高年齢"
"こうの 香野 幸野 甲野 河野"
"こうのいけ 鴻池"
"こうのう 後脳 貢納 後納 功能 効能"
"こうのうど 高濃度"
"こうのうりつ 高能率"
"こうのす 鴻巣"
"こうのすけ 幸之助"
"こうのとり 鸛"
"こうのもの 香の物"
"こうのもろなお 高師直"
"こうは 光波 硬派"
"こうはい 向拝 向背 興廃 好配 光背 降灰 後背 高配 荒廃 交配 後輩"
"こうはいかぶ 後配株"
"こうはいとう 高配当"
"こうはく 広博 厚薄 工博 黄白 紅白"
"こうはた 光畑"
"こうはつ 好発 後発"
"こうはません 興浜線"
"こうはまみなみせん 興浜南線"
"こうはら 香原"
"こうはん 江畔 撹拌 攪拌 甲板 鋼鈑 孔版 紅斑 広汎 鋼板 公判 広範 後半"
"こうはんてい 公判廷"
"こうば 工場"
"こうばい 公倍 黄梅 公売 紅梅 勾配 購買"
"こうばいりつ 高倍率"
"こうばく 宏漠 荒漠 広漠"
"こうばこ 香箱"
"こうばし 香箸"
"こうばな 香花"
"こうばん 甲板 工番 降番 項番 鋼板 降板 交番"
"こうひ 向日 黄扉 高飛 高庇 高批 侯妃 后妃 公妃 公比 口碑 皇妃 校費 工費 公費"
"こうひじゅう 高比重"
"こうひすたみんざい 抗ヒスタミン剤"
"こうひつ 硬筆"
"こうひょう 公評 降雹 高評 講評 公表 好評"
"こうひょうき 後氷期"
"こうひょうげん 項表現"
"こうひん 公賓"
"こうひんい 高品位"
"こうひんしつ 高品質"
"こうひんど 高頻度"
"こうび 後備 後尾 交尾"
"こうびょうげんせい 高病原性"
"こうびん 幸便 後便"
"こうふ 弘布 坑夫 鉱夫 江府 工夫 甲府 公布 交付"
"こうふう 校風"
"こうふうせいげつ 光風霽月"
"こうふか 高負荷"
"こうふく 口腹 降服 口福 降伏 幸福"
"こうふくし 高福祉"
"こうふくしこうふたん 高福祉高負担"
"こうふくじ 洪福寺 興福寺"
"こうふくまく 後腹膜"
"こうふみなみ 甲府南"
"こうふん 亢憤 亢奮 紅粉 公憤 昂奮 口吻 興奮"
"こうぶ 荒蕪 公武 光武 後部"
"こうぶだいがっこう 工部大学校"
"こうぶつ 貢物 鉱物 好物"
"こうぶり 冠"
"こうぶん 後文 告文 行文 公文 構文"
"こうぶんかい 高分解"
"こうぶんき 構文木"
"こうぶんぎ 構文木"
"こうぶんし 高分子"
"こうぶんしまく 高分子膜"
"こうぶんしゃ 光文社"
"こうぶんてんのう 弘文天皇"
"こうぶんとう 構文糖"
"こうぶんどう 弘文堂"
"こうぶんぷ 項分布"
"こうぷれー 好プレー"
"こうへい 衡平 高平 恒平 幸平 耕平 康平 浩平 工兵 公平"
"こうへいれつ 高並列"
"こうへき 厚壁 後壁"
"こうへん 口辺 後篇 後編"
"こうへんさいぼう 孔辺細胞"
"こうべ 首 頭 神戸"
"こうべきいと 神戸生絲"
"こうべぎゅう 神戸牛"
"こうべつ 皇別 項別"
"こうべん 口弁 抗弁"
"こうほ 黄埔 好捕 候補"
"こうほう 廣報 康保 後報 弘報 公法 航法 構法 高峰 公報 後方 工法 広報"
"こうほく 江北 港北"
"こうほね 川骨 河骨"
"こうほば 候補馬"
"こうほん 広本 校本 稿本"
"こうぼ 酵母 公募"
"こうぼう 鉤芒 好防 高望 香房 光芒 公房 弘法 興亡 攻防 工房"
"こうぼく 坑木 公僕 香木 高木"
"こうぼくしかい 槁木死灰"
"こうま 黄麻 好摩 小馬 仔馬 子馬"
"こうまい 高邁"
"こうまく 硬膜"
"こうまつがく 考末学"
"こうまん 高慢"
"こうみ 小海 香味"
"こうみつ 高密"
"こうみゃく 鉱脈"
"こうみょう 功名 高名 光明 巧妙"
"こうみょうじ 弘明寺"
"こうみん 皇民 公民"
"こうむ 校務 工務 公務"
"こうむら 甲村 高村"
"こうめ 小梅"
"こうめい 工明 高明 孝明 校名 光明 孔明 公明 高名"
"こうめいいけ 光明池"
"こうめいてい 孝明帝"
"こうめん 垢面 後面"
"こうもう 噛耗 膏盲 咬耗 鴻毛 孔孟 紅毛"
"こうもく 綱目 項目"
"こうもくてん 広目天"
"こうもつ 貢物"
"こうもと 孝本 甲本 河本"
"こうもり 幸森 蝙蝠"
"こうもりがさ 蝙蝠傘"
"こうもん 粫門 孔紋 孔門 告文 後門 閘門 校門 黄門 肛門"
"こうや 狗也 甲夜 功也 幸也 郊野 紺屋 高野 広野 曠野 荒野"
"こうやうち 高野内"
"こうやぎ 香焼"
"こうやぎれ 高野切"
"こうやく 膏薬 口約 公約"
"こうやさい 後夜祭"
"こうやせん 交野線"
"こうやちょう 公冶長"
"こうやひじり 高野聖"
"こうやま 光山 高山"
"こうやまき 高野槙"
"こうゆ 膏油 膏腴 香湯 鉱油 香油"
"こうゆう 孔融 校友 公有 交遊 交友"
"こうゆうしょう 交遊抄"
"こうゆうせんど 高優先度"
"こうよ 公誉"
"こうよう 宏陽 衡陽 行洋 江陽 甲陽 光洋 孝養 後葉 綱要 昂揚 広葉 黄葉 紅葉 公用 効用 高揚"
"こうようじゅ 硬葉樹 広葉樹"
"こうようじゅりん 硬葉樹林"
"こうようりょう 高容量"
"こうよく 高翼"
"こうら 甲良 甲羅"
"こうらい 光来 後来 高麗"
"こうらいしば 高麗芝"
"こうらく 攻落 好楽 後楽 行楽"
"こうらん 撹乱 撹亂 攪亂 鉤欄 勾欄 攪乱 高欄 香蘭 紅蘭 高覧"
"こうり 冰 氷 公吏 功利 行李 公理 高利 小売り 小売"
"こうりえん 香里園"
"こうりがし 高利貸"
"こうりき 高力"
"こうりつ 工率 後立 高率 公立 効率"
"こうりつよし 効率良"
"こうりね 小売値"
"こうりゃく 康暦 後略 攻略"
"こうりやま 郡山"
"こうりゅう 亢竜 幸流 蛟竜 蛟龍 紅龍 後流 勾留 拘留 興隆 交流"
"こうりゅうぎょ 降流魚"
"こうりゅうじ 広隆寺"
"こうりょ 行旅 考慮"
"こうりょう 講料 宏量 広量 亢竜 蛟竜 口糧 荒寥 高粱 公領 広陵 稿料 衡量 考量 校了 荒涼 綱領 光量 香料"
"こうりょく 抗力 効力"
"こうりん 光輪 光琳 光臨 後輪 降臨"
"こうりんぎょ 硬鱗魚"
"こうりんぼう 香林坊"
"こうるい 降涙 柑類 紅涙"
"こうれい 交霊 降霊 好例 高齢 恒例"
"こうれいさい 皇霊祭"
"こうれいてんのう 孝霊天皇"
"こうれつ 項列 後列"
"こうれべる 高レベル"
"こうれん 鉤連 拘攣"
"こうろ 鈩 香露 紅炉 公路 行路 高炉 香炉 航路"
"こうろう 絳蝋 高樓 高楼 功労"
"こうろうい 公労委"
"こうろうしょう 厚労相 厚労省"
"こうろうたて 功労盾"
"こうろうほう 公労法"
"こうろうむ 紅楼夢"
"こうろかん 鴻臚館"
"こうろく 高禄 公録"
"こうろぜん 黄櫨染"
"こうろん 抗論 高論 硬論 公論 口論"
"こうろんおつばく 甲論乙駁"
"こうわ 高話 興和 康和 弘和 講和 講話"
"こうわほう 口話法"
"こうわん 港湾"
"こうん 孤雲"
"こえ 聲 越 肥 声"
"こえい 孤影"
"こえいもん 虎衛門"
"こえおけ 肥桶"
"こえがかり 声掛り"
"こえがら 声柄"
"こえがわり 声変り 声変わり"
"こえき 固液"
"こえしつ 声質"
"こえじ 越路"
"こえずか 肥塚"
"こえたご 肥担桶"
"こえだ 小枝"
"こえだか 声高"
"こえだめ 肥だめ 肥溜め"
"こえつぼ 肥壺"
"こえづか 肥塚"
"こえなかじま 越中島"
"こえん 故縁 小縁 故園 古園"
"こえんゆう 小円遊"
"こおう 呼応"
"こおうこんらい 古往今来"
"こおとこ 小男"
"こおどり 小躍り"
"こおに 小鬼"
"こおもて 小面"
"こおり 冰 桑折 郡 氷"
"こおりがし 氷菓子"
"こおりざとう 氷砂糖"
"こおりだ 凍田"
"こおりづけ 氷漬け"
"こおりづめ 氷詰め"
"こおりどうふ 凍り豆腐"
"こおりぶぎょう 郡奉行"
"こおりまくら 氷枕"
"こおりみず 氷水"
"こおりみつ 氷蜜"
"こおりや 氷屋"
"こおりやま 郡山"
"こおろぎ 蛩 蟋蟀"
"こおんな 小女"
"こか 瓠果 糊化 古歌 固化"
"こかいがわ 小貝川"
"こかく 孤客 呼格 古格 顧客"
"こかげ 小蔭 小陰 木蔭 木陰"
"こかじ 小鍛冶"
"こかた 子方"
"こかつ 涸渇 枯渇"
"こかつじぼん 古活字本"
"こかぶ 子株"
"こかべ 小壁"
"こかわ 胡川 粉河"
"こかん 股間"
"こかんきょう 古環境"
"こかんせつ 股関節"
"こかんぼん 古刊本"
"こが 個我 古画 古雅 古河 古賀"
"こがい 個飼い 小買い 蚕飼い 庫外 子飼い 小粥 小貝 戸外"
"こがいしゃ 小会社"
"こがいな 小腕"
"こがお 小顔"
"こがき 小書き 小書"
"こがく 古学 古楽"
"こがくれ 木隠れ"
"こがしら 小頭"
"こがた 小形 小型"
"こがたけん 小型犬"
"こがたな 小刀"
"こがたばす 小型バス"
"こがっき 古楽器"
"こがね 小金 黄金"
"こがねい 小金井"
"こがねはら 小金原"
"こがねむし 黄金虫"
"こがめ 子亀"
"こがら 小雀 小柄"
"こがらし 木枯 凩 木枯し 木枯らし"
"こがれじに 焦れ死に"
"こがわ 古川"
"こがわせ 小為替"
"こがん 個眼 孤雁 湖岸"
"こき 子器 古器 古記 古期 古稀 古希 呼気 子機"
"こきいろ 濃色"
"こきお 古希男"
"こきざみ 小刻み"
"こきでん 弘徽殿"
"こきでんのにょうご 弘徽殿の女御"
"こきみ 小気味"
"こきむらさき 濃紫"
"こきゃく 顧客"
"こきゅう 固給 故旧 故宮 胡弓 呼吸"
"こきゅうこん 呼吸根"
"こきょう 古経 故郷"
"こきん 胡琴 古琴 古今"
"こきんちょう 胡錦鳥"
"こぎ 狐疑 古義 小木"
"こぎって 小切手"
"こぎつね 小狐 子狐"
"こぎて 漕ぎ手"
"こぎみ 小君 故君 子君"
"こぎょ 枯魚"
"こぎれ 小切れ"
"こぎれい 小綺麗"
"こく 詰 棘 釛 哭 谷 國 圀 梏 鵠 槲 斛 轂 穀 尅 剋 克 古句 石 黒 国 刻 告 酷"
"こくあく 酷悪"
"こくい 国威 黒衣"
"こくいっこく 刻一刻"
"こくいん 黒印 刻印"
"こくう 穀雨 虚空"
"こくうん 国運 黒雲"
"こくえ 黒衣"
"こくえい 黒影 国営"
"こくえき 国益"
"こくえん 黒鉛 黒煙"
"こくおう 国王"
"こくおん 国恩"
"こくかっしょく 黒褐色"
"こくが 国衙"
"こくがい 国外"
"こくがく 國學 国学"
"こくがくいん 国学院 國學院"
"こくぎ 国議 国技"
"こくぐう 酷遇"
"こくぐら 穀倉"
"こくぐん 国郡 国軍"
"こくけん 国研"
"こくけんばん 黒鍵盤"
"こくげき 国劇"
"こくげん 刻限"
"こくこ 国庫"
"こくこうしりつ 国公私立"
"こくこうりつ 国公立"
"こくこく 刻刻 刻々"
"こくご 国語"
"こくごう 国号"
"こくさい 國際 国祭 国債 国際"
"こくさいおりんぴっくいいんかい 国際オリンピック委員会"
"こくさいこうき 国際光器"
"こくさく 国策"
"こくさん 国産"
"こくさんぎゅう 国産牛"
"こくさんまい 国産米"
"こくし 国使 国師 国試 国士 国史 国司 酷使"
"こくしかん 国子監 国士舘"
"こくしつ 黒漆"
"こくしびょう 黒死病"
"こくしゅ 国手 国守 国主"
"こくしゅう 刻舟"
"こくしょ 黒書 国初 国書 酷暑"
"こくしょう 国掌 濃漿 國生 国章 国生"
"こくしょく 穀食 黒色"
"こくじ 国璽 刻時 告辞 国字 国事 刻字 酷似 告示"
"こくじょう 国情"
"こくじょうじごく 黒縄地獄"
"こくじょく 国辱"
"こくじん 国人 黒人"
"こくじんれいか 黒人霊歌"
"こくすい 国粋"
"こくせい 国勢 国政"
"こくせき 刻石 国籍"
"こくせつ 国設"
"こくせん 刻線 国選"
"こくせんや 国姓爺"
"こくぜ 国是"
"こくぜい 酷税 国税"
"こくそ 告訴"
"こくそう 国喪 穀倉 国葬"
"こくぞうむし 穀象虫"
"こくぞく 国賊"
"こくた 穀田"
"こくたい 國軆 黒体 国対 国体"
"こくたに 古九谷"
"こくたん 黒炭 黒檀"
"こくだい 国大"
"こくだか 石高"
"こくち 国恥 告知"
"こくちょう 黒鳥 国鳥"
"こくつぶ 穀粒"
"こくてい 国定"
"こくてつ 国鉄"
"こくてん 国典 黒点"
"こくてんし 告天子"
"こくでん 国電"
"こくと 国都"
"こくとう 黒糖"
"こくど 黒奴 黒土 国土"
"こくどう 国道"
"こくどしゃ 国土舎"
"こくない 国内"
"こくないしょう 黒内障"
"こくないそうせいさん 国内総生産"
"こくないつあー 国内ツアー"
"こくないむけ 国内向"
"こくなん 国難"
"こくにん 国人"
"こくね 古久根"
"こくねつ 酷熱"
"こくはく 穀帛 刻薄 酷薄 告白"
"こくはつ 黒髪 告発"
"こくはん 刻板 刻版"
"こくはんびょう 黒斑病"
"こくばん 黒板"
"こくひ 国費"
"こくひょう 黒表 酷評"
"こくひん 国賓"
"こくび 小首"
"こくびゃく 黒白"
"こくふ 国父 国府 国富"
"こくふう 国風"
"こくふうはくう 黒風白雨"
"こくふく 克復 克服"
"こくふだ 国府田"
"こくふん 穀粉"
"こくぶ 国府 国分"
"こくぶん 国分 告文 国文"
"こくぶんぽう 国文法"
"こくへいしゃ 国幣社"
"こくへん 黒変"
"こくべつ 告別"
"こくほ 国歩 国保"
"こくほう 國寶 国法 国宝"
"こくほん 刻本"
"こくぼ 国母 小久保"
"こくぼう 国防"
"こくぼうそうしょう 国防総省"
"こくまい 黒米"
"こくみん 国民"
"こくみんかいほけん 国民皆保険"
"こくみんしゃこうそう 国民車構想"
"こくみんそうししゅつ 国民総支出"
"こくみんそうせいさん 国民総生産"
"こくみんそうせばんごうせい 国民総背番号制"
"こくむ 国務"
"こくむいん 国務院"
"こくめい 刻銘 克明 国名"
"こくも 国母"
"こくもつ 穀物"
"こくもり 石盛"
"こくやく 国躍 国訳"
"こくゆ 告諭"
"こくゆう 国有"
"こくゆうりん 国有林"
"こくようせき 黒曜石"
"こくら 小倉"
"こくらきた 小倉北"
"こくらみなみ 小倉南"
"こくり 国利"
"こくりつ 国立"
"こくりみんぷく 国利民福"
"こくりゅう 穀粒 黒竜 黒龍"
"こくりゅうこう 黒竜江"
"こくりょう 国領"
"こくりょく 国力"
"こくるい 穀類"
"こくれい 穀霊"
"こくれつ 酷烈"
"こくれん 國聯 国連"
"こくろう 国労"
"こくろん 国論"
"こくん 古訓"
"こぐし 小串"
"こぐすり 粉薬"
"こぐち 木口 小口"
"こぐちがき 小口書"
"こぐちぼり 木口彫"
"こぐま 黒熊 子熊 小熊"
"こぐれ 小暮"
"こぐん 孤軍"
"こけ 虚仮 苔"
"こけい 固型 孤閨 古形 固形"
"こけいさんしょう 虎渓三笑"
"こけいすーぷ 固形スープ"
"こけいろ 苔色"
"こけおどし 虚仮威し"
"こけしのぶ 苔忍"
"こけしょくぶつ 苔植物"
"こけつ 虎穴 固結"
"こけでら 苔寺"
"こけにわ 苔庭"
"こけむしるい 苔虫類"
"こけもも 苔桃"
"こけら 柿"
"こけらおとし 柿落し"
"こけらぶき 柿葺き"
"こけん 狐拳 估券 古賢 孤剣 沽券"
"こげ 焦げ"
"こげき 罅隙"
"こげちゃ 焦茶"
"こげつ 木月 孤月 鼓月 湖月"
"こげめし 焦げ飯"
"こげら 小啄木"
"こげん 古諺 古言"
"こげんてい 古言梯"
"ここ 茲 呱々 爰 個個 此処 個々"
"ここああじ ココア味"
"ここあいろ ココア色"
"ここう 餬口 股肱 糊口 虎口 戸口 孤高"
"ここく 故国"
"ここち 心地"
"ここちよし 心地好"
"ここに 爰に 茲に 是に 此処に 個々に"
"ここぬか 九日"
"ここの 九"
"ここのえ 九重"
"ここのか ９日 九日"
"ここのそじ 九十"
"ここのつ 九つ"
"ここまい 古々米"
"ここらへん ここら辺"
"こころ 心"
"こころあたり 心当り 心当たり"
"こころあて 心当て"
"こころいき 心意気"
"こころいっぱい 心一杯"
"こころいれ 心入れ"
"こころいわい 心祝い"
"こころえ 心得"
"こころおき 心置き"
"こころおきなく 心置きなく 心置き無く"
"こころおくれ 心後れ"
"こころおち 心落ち"
"こころおぼえ 心覚え"
"こころから 心から"
"こころがけ 心掛け"
"こころがまえ 心構え"
"こころがら 心柄"
"こころがわり 心変り 心変わり"
"こころくばり 心配り"
"こころぐみ 心組み"
"こころざし 志"
"こころざま 心様"
"こころしずか 心静か"
"こころじょうぶ 心丈夫"
"こころぞえ 心添え"
"こころだのみ 心頼み"
"こころだま 心魂"
"こころだましい 心魂"
"こころづかい 心遣い"
"こころづくし 心尽し 心尽くし"
"こころづけ 心付け"
"こころづもり 心積り 心積もり"
"こころづよ 心強"
"こころな 心無"
"こころなし 心無 心成し 心なし 心做し 心無し"
"こころね 心根"
"こころのうち 心の内"
"こころのこり 心残り"
"こころのそこ 心の底"
"こころのやみ 心の闇"
"こころばえ 心延え"
"こころばせ 心馳せ"
"こころぶと 心太"
"こころまかせ 心任せ"
"こころまち 心待ち"
"こころみ 試 試み"
"こころもち 心もち 心持 心持ち"
"こころもと 心元 心許"
"こころやすだて 心安立て"
"こころやり 心遣り"
"こころゆ 心ゆ"
"ここん 古今"
"ここんちょもんじゅう 古今著聞集"
"こご 古語"
"こごう 小督 呼号 古豪"
"こごえ 小声"
"こごし 小腰"
"こごしょう 子児姓"
"こごた 小牛田"
"こごと 小言"
"こごめ 粉米"
"こごもり 子籠り"
"こごもりざけ 子籠り鮭"
"こごり 凝り"
"こさい 小才 湖西"
"こさか 小坂"
"こさかい 小堺"
"こさかた 小坂田"
"こさかだ 小坂田"
"こさく 古作 小作"
"こさくのう 小作農"
"こささ 小笹"
"こさざ 小佐々"
"こさじ 小さじ 小匙"
"こさつ 故殺 古刹"
"こさはら 古佐原"
"こさめ 小雨"
"こさん 古参"
"こさんじ 小三治"
"こさんば 小三馬"
"こざ 胡坐 古座"
"こざい 古材"
"こざいく 小細工"
"こざかい 小坂井"
"こざかいなだ 小境灘"
"こざかな 小肴 小魚"
"こざき 駒崎 小崎"
"こざくら 小桜"
"こざけ 醴"
"こざさ 小笹"
"こざさはら 小笹原"
"こざしき 跨座式 小座敷"
"こざね 小札"
"こざら 小皿"
"こざる 子猿 小猿"
"こざわ 涸沢"
"こざん 孤山 故山"
"こし 越 虎子 古詩 古史 虎視 古志 枯死 輿 古紙 腰"
"こしあて 腰当"
"こしあん 漉餡 漉し餡"
"こしいた 腰板"
"こしいれ 輿入れ"
"こしお 小潮"
"こしおび 腰帯"
"こしおれ 腰折れ"
"こしかけ 腰掛 腰掛け"
"こしかた 来し方"
"こしかべ 腰壁"
"こしかわ 越川"
"こしが 越賀"
"こしがみ 漉紙"
"こしがや 越谷"
"こしき 濾し器 漉し器 轂 甑 古式"
"こしきぶのないし 小式部内侍"
"こしきり 越桐"
"こしぎんちゃく 腰巾着"
"こしくだけ 腰砕け"
"こしぐるま 腰車"
"こしぐるわ 腰曲輪"
"こしごえ 腰越"
"こしじ 越路"
"こしじそう 越路荘"
"こしたやみ 木下闇"
"こしだ 越田"
"こしだか 腰高"
"こしつ 痼疾 鼓室 固執 個室"
"こしつき 腰付き"
"こしづか 越塚"
"こしなか 越中"
"こしなげ 腰投げ"
"こしなげし 腰長押"
"こしなわ 腰縄"
"こしぬけ 腰抜け"
"こしぬの 腰布"
"こしの 越廼"
"こしのかんばい 越乃寒梅"
"こしのぎ 小鎬"
"こしのくに 越の国"
"こしのもの 腰の物"
"こしば 古柴 小柴"
"こしばい 小芝居"
"こしひも 腰紐"
"こしぼそ 腰細"
"こしぼね 腰骨"
"こしまき 腰巻"
"こしまど 腰窓"
"こしまわり 腰回り"
"こしみず 輿水 小清水"
"こしみの 腰蓑"
"こしみはる 越美晴"
"こしむら 越村"
"こしもと 越元 腰元"
"こしゃきょう 古写経"
"こしゃく 小癪"
"こしゃほん 古写本"
"こしやね 越屋根"
"こしやまそう 越山荘"
"こしゅ 鼓手 戸主 固守 古酒"
"こしゅう 故習 個集 孤舟 孤愁 呼集 固執"
"こしゅく 固縮"
"こしゅつ 庫出"
"こしゆ 腰湯"
"こしょ 古書"
"こしょう 壺漿 壷漿 壺觴 楜 誇称 孤松 扈従 小性 古称 小姓 胡椒 湖沼 呼称 故障"
"こしょうか コショウ科"
"こしょうがつ 小正月"
"こしょうぎ 小将棋"
"こしょうにん 小商人"
"こしょうもく コショウ目"
"こしょく 孤食 個食 古色"
"こしょし 古書肆"
"こしょり 呼処理"
"こしよわ 腰弱"
"こしらえ 拵え"
"こしろ 小代 古代"
"こしわざ 腰技"
"こしん 孤身 湖心"
"こしんとう 古神道"
"こじ 虎児 虎子 古字 固持 居士 固辞 古寺 誇示 孤児 故事"
"こじいん 孤児院"
"こじか 子鹿 小鹿"
"こじき 乞食 古事記"
"こじしざ 小獅子座"
"こじつ 故実"
"こじてきしょうひ 誇示的消費"
"こじま 戸島 小嶋 古島 児島 小島"
"こじゅ 古樹"
"こじゅう 扈従"
"こじゅうと 小舅 小姑"
"こじゅうとめ 小姑"
"こじょう 小尉 孤城 弧状 湖上 古城"
"こじょうるり 古浄瑠璃"
"こじり 小尻 鐺"
"こじれ 拗れ"
"こじろう 小次郎"
"こじわ 小ジワ 小皺 小じわ"
"こじん 古人 故人 個人"
"こじんおいぬき 個人追抜"
"こじんこじん 個人々々"
"こじんさいと 個人サイト"
"こじんむけこくさい 個人向け国債"
"こじんより 個人寄"
"こすい 鼓吹 湖水"
"こすう 戸数 個数"
"こすぎ 小杉"
"こすけがわ 小助川"
"こすげ 小菅"
"こすだ 小須田"
"こすとげん コスト減"
"こすとさくげん コスト削減"
"こすとぞう コスト増"
"こすとだか コスト高"
"こすとめん コスト面"
"こすど 小須戸"
"こすみ 小角"
"こすもしょうけん コスモ証券"
"こすもす 秋桜"
"こすもせきゆ コスモ石油"
"こすり 錯"
"こずえ 杪 梢"
"こせ 小瀬 巨勢"
"こせい 糊精 古制 古生 個性"
"こせいせん 湖西線"
"こせがれ 小悴 小倅"
"こせき 古蹟 古関 小関 古昔 古跡 戸籍"
"こせつ 古説 古拙"
"こせん 姑洗 弧線 古銭"
"こせんきょう 跨線橋"
"こせんじょう 古戦場"
"こせんすい 枯山水"
"こぜい 小勢"
"こぜき 小関"
"こぜつ 孤絶"
"こぜに 小銭"
"こぜりあい 小競合 小競り合い"
"こそう 鼓譟 鼓騒 枯燥 古層 古箏 枯草 固相"
"こそく 呼息 姑息"
"こそし 古曽志"
"こそで 小袖"
"こそとがり 小外刈り"
"こそどろ コソ泥 こそ泥"
"こそめつけ 古染付"
"こそん 孤村"
"こぞ 去年"
"こぞう 子象 小僧"
"こぞく 故俗 古俗"
"こぞっこ 小僧っ子"
"こぞって 挙って"
"こぞの 小園"
"こたい 固態 古体 鼓隊 個体 固体"
"こたえ 堪え 答え 答"
"こたえられない 堪えられない"
"こたか 小鷹 小高"
"こたけ 小竹"
"こたち 子達"
"こたつ 炬燵"
"こたに 小谷"
"こたび 此度"
"こたろう 虎太郎 小太郎"
"こたん 古淡 枯淡"
"こだい 誇大 古代"
"こだいぎれ 古代裂"
"こだいこ 小太鼓"
"こだいぞめ 古代染"
"こだいまい 古代米"
"こだいむらさき 古代紫"
"こだいら 小平"
"こだか 小高"
"こだから 子宝"
"こだくさん 子沢山"
"こだくみ 木匠 木工"
"こだし 小出し"
"こだち 木立ち 小太刀 木立"
"こだつの 小立野"
"こだて 木楯 小楯 戸建て 戸建"
"こだと 古田土"
"こだな 蚕棚"
"こだなか 小田中"
"こだぬき 子狸"
"こだね 子種"
"こだま 兒玉 児玉 小玉 谺 木霊"
"こだわり 拘泥り 拘泥"
"こち 牛尾魚 乞 此方 故知 故地 鯒 東風"
"こちじ 越路"
"こちじき 古地磁気"
"こちず 古地図"
"こちゃく 固着"
"こちゅう 壺中"
"こちょう 孤蝶 弧長 古調 鼓腸 蝴蝶 胡蝶 誇張"
"こちょうせん 古朝鮮"
"こちょうのゆめ 胡蝶の夢"
"こちょうらん 胡蝶蘭"
"こちら 此方"
"こちり 古地理"
"こっ 国"
"こっか 』 ］ ） 】 刻下 黒化 國家 骨化 国花 国歌 国家"
"こっかい 告解 黒海 国会"
"こっかく 骨骼 骨格"
"こっかくき 骨角器"
"こっかたいこっか 国家対国家"
"こっかっしょく 黒褐色"
"こっかん 国漢 骨幹 酷寒"
"こっき 国記 黒旗 克己 国旗"
"こっきふくれい 克己復礼"
"こっきゅう 黒球"
"こっきょう 国共 国教 国境"
"こっきん 国禁"
"こっく 刻苦"
"こっくちょう コック長"
"こっくん 国訓"
"こっけい 酷刑 滑稽"
"こっけいせつ 国慶節"
"こっけん 国研 国憲 黒鍵 国権"
"こっこ 国庫"
"こっこう 国光 国交"
"こっこうりつ 国公立"
"こっこく 刻々"
"こっし 骨子"
"こっしゅ 骨腫"
"こっせつ 骨節 骨折"
"こっそう 骨相"
"こったん 骨炭"
"こっち 此方"
"こっちょう 骨頂"
"こっとい 特牛"
"こっとう 骨董"
"こっとうてきかち 骨董的価値"
"こっぱ 木ッ端 木端 木っ端"
"こっぱい 骨灰 骨牌"
"こっぷざ コップ座"
"こっぷん 骨粉"
"こっぺん 骨片"
"こっぽう 骨法"
"こつ 兀 乞 笏 惚 忽 榾 骨"
"こつあげ 骨揚げ"
"こつえん 忽焉"
"こつがい 乞丐"
"こつがら 骨柄"
"こつくり 木造"
"こつさいぼう 骨細胞"
"こつざい 骨材"
"こつじき 乞食"
"こつじょ 忽如"
"こつじょう 骨状"
"こつずい 骨髄"
"こつずいばんく 骨髄バンク"
"こつぜん 忽然"
"こつぜんと 忽然と"
"こつそしき 骨組織"
"こつそしょうしょう 骨粗鬆症"
"こつつぼ 骨壷 骨壺"
"こつづみ 小鼓"
"こつでんどう 骨伝導"
"こつにく 骨肉"
"こつねん 忽然"
"こつねんれい 骨年齢"
"こつばん 骨盤"
"こつひろい 骨拾い"
"こつぶ 小粒"
"こつぼ 小壺"
"こつまく 骨膜"
"こつみ 木積"
"こつみつど 骨密度"
"こつりつ 骨立"
"こつりん 骨鱗"
"こつるせん 小鶴線"
"こづか 小塚 小柄"
"こづかい 小使 小使い 小遣い"
"こづかいせん 小遣銭"
"こづくり 小作り 木造り"
"こづけ 小付 小付け"
"こづち 小槌"
"こづつ 小筒"
"こづつみ 小包"
"こづめ 小爪"
"こづる 小鶴"
"こて 鐺 籠手 鏝 小手"
"こてい 小体 湖底 固定"
"こていきゅう 固定給"
"こていたん 固定端"
"こていまど 固定窓"
"こてがわ 古手川"
"こてき 鼓笛"
"こてさし 小手指"
"こてつ 小鉄"
"こてん 古点 個展 古典"
"こでら 小寺"
"こでん 古伝"
"こと 亊 古渡 糊塗 古都 殊 異 箏 琴 言 事"
"ことあげ 言挙げ"
"こといみ 言忌み"
"ことう 厚東 小藤 湖東 古刀 孤島"
"ことえり 言選り"
"ことかぜごうき 琴風豪規"
"ことがうめ 琴ヶ梅"
"ことがら 事柄"
"ことぎれ 事切れ"
"ことく 古徳"
"ことこまか 事細か"
"ことごと 異事 事々"
"ことごとく 尽く 悉く"
"ことさら 殊更"
"ことざ 琴座"
"ことし 今年"
"ことしあき 今年秋"
"ことしくれ 今年暮"
"ことしだけ 今年竹"
"ことしぢゅう 今年中"
"ことしなついこう 今年夏以降"
"ことしはる 今年春"
"ことしろ 事代"
"ことじ 琴柱"
"ことじたい 事自体"
"ことだま 言霊"
"ことづけ 事付 託け 言付け"
"ことづて 言傳て 言伝て 言伝"
"ことてん 事典"
"ことてんざん 琴天山"
"ことでん 琴電"
"こととい 言問"
"こととき 異時"
"ことなかれ 事勿れ"
"ことなし 事無"
"ことなりごすう 異なり語数"
"ことに 異に 琴似 殊に"
"ことにしき 琴錦"
"ことね 琴音"
"ことの 琴野 琴乃"
"ことのついで 事の序"
"ことのは 言の葉"
"ことのほか 殊の外"
"ことはじめ 事始め 事始"
"ことはら 異腹"
"ことば 辞 詞 言葉"
"ことばかず 言葉数"
"ことばがき 詞書"
"ことばがり 言葉狩り"
"ことばじち 言葉質"
"ことばじり 言葉尻"
"ことばづかい 言葉遣い"
"ことばのあや 言葉の綾"
"ことひら 琴平"
"ことふじ 琴富士"
"ことぶき 壽 寿"
"ことぶきそう 寿荘"
"ことぶきたいしゃ 寿退社"
"ことぶきたいしょく 寿退職"
"ことぶきや 壽屋 寿屋"
"ことべっぷ 琴別府"
"ことほぎ 言寿ぎ 言祝ぎ 寿"
"ことほどさように 事程左様に"
"ことまき 異巻"
"ことみ 琴美"
"こともなげ 事も無げ"
"こともの 異者"
"ことり 小鳥"
"ことわけ 事訳"
"ことわざ 諺"
"ことわり 断り 理"
"こど 弧度"
"こどう 小胴 鼓胴 古銅 古道 鼓動"
"こどうきょう 跨道橋"
"こどうぐ 小道具"
"こどく 蠱毒 孤独"
"こどまり 小泊"
"こども 小人 子ども 子供"
"こどもごころ 子供心"
"こどもずき 子供好き"
"こどものひ こどもの日"
"こな 小名 粉"
"こない 庫内"
"こないだ 此間"
"こなおしろい 粉白粉"
"こなか 小中"
"こなかい 小仲井"
"こなかだい 小仲台"
"こなから 二合半"
"こながい 小長井"
"こなきじじい 子泣爺 子泣き爺"
"こなぐすり 粉薬"
"こなごな 粉々"
"こなざとう 粉砂糖"
"こなし 小梨"
"こなじょう 粉状"
"こなせっけん 粉せっけん 粉石鹸"
"こなた 此方"
"こなちーず 粉チーズ"
"こなちゃ 粉茶"
"こなつ 小夏"
"こなふき 粉吹き"
"こなべ 小鍋"
"こなまいき 小生意気"
"こなみ 嫡妻 前妻 小波"
"こなみじん 粉微塵"
"こなみるく 粉ミルク"
"こなや 粉屋"
"こなゆき 粉雪"
"こなら 枹"
"こならい 小習"
"こなわ 小縄"
"こなん 湖南"
"こにきし 王"
"こにし 小西"
"こにしき 小錦"
"こにしろく 小西六"
"こにもつ 小荷物"
"こにんずう 小人数"
"こぬか 小糠"
"こぬかあめ 小糠雨"
"こぬき 小貫"
"こぬま 小沼"
"こねこ 小猫 子ネコ 仔猫 子猫"
"こねずみ 濃鼠 子鼠 小鼠"
"こねた 小ネタ"
"この 此 斯の 此の"
"このーど 子ノード"
"このあいだ 此の間 この間"
"このうえ この上"
"このうら 金浦"
"このえ 近衛"
"このえちょう 近江町"
"このえひでまろ 近衛秀麿"
"このえふみまろ 近衛文麿"
"このかた 此方 この方"
"このかみ 兄"
"このかん この間"
"このこ この子"
"このこうべ 兄部"
"このころ この頃"
"このご 此期 この期"
"このごろ 此頃 この頃"
"このさい この際"
"このしゅ この種"
"このしろ 鮗"
"このたび 此の度 此度 この度"
"このて この手"
"このてん この点"
"このとき この時"
"このとし この年"
"このは 木の葉"
"このはちょう 木の葉蝶"
"このはな 此花"
"このはなのさくやびめ 木花開耶姫"
"このへん 此邊 この辺"
"このまえ この前"
"このみ 木實 好 この身 好み 木の実"
"このみち 此路 この道"
"このめ 木の芽"
"このよ 此の世 この世"
"このわた 海鼠腸"
"このんで 好んで"
"こはぎ 小萩"
"こはく 琥珀"
"こはぜ 鞐"
"こはた 戸畑 古畑 小幡 木幡"
"こはだ 木膚 木皮 樸 小鰭 木肌"
"こはつ 孤発"
"こはな 裔"
"こはば 小幅"
"こはま 小濱"
"こはまちょう 小浜町"
"こはら 小原"
"こはり 小梁 小針"
"こはる 小春"
"こはん 個販 孤帆 古版 湖畔"
"こはんとき 小半時"
"こはんにち 小半日"
"こば 胡馬 古場 古馬 古葉 木場"
"こばい 故買"
"こばか 小馬鹿"
"こばく 固縛"
"こばこ 小箱"
"こばし 小橋"
"こばしら 小柱"
"こばしり 小走り"
"こばた 小旗 小幡"
"こばたけ 小畑"
"こばち 小鉢"
"こばな 小鼻 小花"
"こばなし 小咄 小噺 小話"
"こばね 小羽根"
"こばやかわ 小早川"
"こばやかわひであき 小早川秀秋"
"こばやし 古林 小林"
"こばやしあきら 小林旭"
"こばやしたきじ 小林多喜二"
"こばら 小腹"
"こばり 小針"
"こばん 小判"
"こばんざめ 小判鮫"
"こばんそう 小判草"
"こひ 古碑"
"こひき 粉引"
"こひしつ 古皮質"
"こひじ 泥"
"こひつ 古筆"
"こひつぎれ 古筆切"
"こひつじ 小羊 仔羊 子羊"
"こひなた 小日向"
"こひやま 小桧山"
"こひょう 小兵 個票"
"こひるいまき 小比類巻"
"こび 狐媚 媚び 媚"
"こびき 木挽"
"こびじゅつ 古美術"
"こびちゃ 媚茶"
"こびと 小人"
"こびな 小雛"
"こびゃくしょう 小百姓"
"こびら 小平"
"こびん 小壜 小瓶"
"こぴーき コピー機"
"こぴーしょうひん コピー商品"
"こぴーひん コピー品"
"こぴーようし コピー用紙"
"こふ 誇負 古布"
"こふう 古風"
"こふきいも 粉吹芋 粉吹き芋"
"こふく 古服 胡服 鼓腹"
"こふくげきじょう 鼓腹撃壤 鼓腹撃壌"
"こふじ 小藤"
"こふみ 湖吹美"
"こふん 古墳"
"こぶ 昆布 鼓舞 瘤"
"こぶうし 瘤牛"
"こぶくろ 子袋 小袋"
"こぶさ 小房"
"こぶし 小節 古武士 辛夷 拳"
"こぶしいも 拳芋"
"こぶしょうしょ 戸部尚書"
"こぶじめ 昆布締め"
"こぶじゅつ 古武術"
"こぶた 子豚"
"こぶちざわ 小淵沢"
"こぶつ 個物 古仏 古物"
"こぶつき コブ付き 瘤付き"
"こぶつしょう 故物商"
"こぶとり 小肥り 小太り"
"こぶどう 古武道"
"こぶね 小船 小舟"
"こぶへい こぶ平"
"こぶまき 昆布巻"
"こぶみ 小文"
"こぶら 腓"
"こぶり 小降り 小振り"
"こぶん 子分 古文"
"こぶんけん 古文献"
"こへい 雇聘 雇兵 古兵"
"こへん 子偏 湖辺"
"こべ 小部"
"こべつ 戸別 個別"
"こほう 孤峰 古方"
"こほうそう 個包装"
"こほく 湖北"
"こほり 氷"
"こほん 孤本 古本 小本"
"こぼう 顧望"
"こぼうしょ 小奉書"
"こぼうず 小坊主"
"こぼく 枯木 古木"
"こぼくかんがん 枯木寒巌"
"こぼけ 小歩危"
"こぼとけ 小仏"
"こぼね 子骨 小骨"
"こぼり 古保里 小堀"
"こぼれ 毀れ 零れ"
"こぼれだね こぼれ種 零れ種"
"こぼればなし こぼれ話"
"こま 高麗 狛 細 齣 小間 独楽 駒"
"こまあみ 細編み"
"こまあらし 駒嵐"
"こまい 氷魚 氷下魚 小舞 駒井 古米"
"こまいずみ 駒泉"
"こまいぬ 狛 狛犬"
"こまえ 駒枝 駒絵 小前 狛江"
"こまおくり 駒送り コマ送り"
"こまおと 駒音"
"こまおとし 齣落 齣落とし"
"こまか 細か"
"こまがく 高麗楽"
"こまがた 駒形"
"こまがたけ 駒ヶ岳"
"こまがだけ 駒ヶ岳"
"こまがね 駒ヶ根"
"こまがみね 駒ヶ峯"
"こまがわなかの 駒川中野"
"こまき 駒木 小牧"
"こまぎれ 小間切れ 細切れ"
"こまく 鼓膜"
"こまくさ 駒草"
"こまくら 木枕 小枕"
"こまぐみ 駒組み"
"こまげた 駒下駄"
"こまごま 細々"
"こまごめ 駒込"
"こまさい 駒祭"
"こまざき 駒崎"
"こまざわ 駒沢"
"こますう コマ数"
"こませ 駒瀬"
"こまぞん 駒損"
"こまた 小俣 小股"
"こまたすくい 小股掬い"
"こまたんい 駒単位"
"こまだ 駒田"
"こまだい 駒台 駒大"
"こまち 小町"
"こまちむすめ 小町娘"
"こまちや 小町谷"
"こまつ 小松"
"こまつざき 小松崎"
"こまつしま 小松島"
"こまつだ 小松田"
"こまつな 小松菜"
"こまつのみや 小松宮"
"こまつばら 小松原"
"こまと 小的"
"こまど 小窓"
"こまどく 駒得"
"こまどり 駒鳥"
"こまねずみ 独楽鼠"
"こまば 駒場"
"こまばりょう 駒場寮"
"こまぶえ 狛笛 高麗笛"
"こまみや 駒宮"
"こまむすび 細結び"
"こまむら 駒村"
"こまめ 小忠実 細目 小まめ"
"こまやか 細やか"
"こまりもの 困り物 困り者"
"こまりょう 駒寮"
"こまる 小丸"
"こまわり 小回り"
"こまんどめい コマンド名"
"こみ 込 込み"
"こみかた 混み方"
"こみかど 小御門"
"こみだし 小見出し"
"こみち 子径 徑 蹊 径 小路 小道 小径"
"こみちしょぼう 径書房"
"こみっくし コミック誌"
"こみなと 小湊"
"こみね 小峯 小峰"
"こみの 小美濃"
"こみみ 小耳"
"こみや 小宮"
"こみやま 込山"
"こむ 込"
"こむかい 小向"
"こむぎ 小麦"
"こむぎこ 小麦粉"
"こむし 小虫"
"こむすび 小結"
"こむすめ 小娘"
"こむそう 虚無僧"
"こむた 小牟田"
"こむら 木叢 古村 小村 腓"
"こむらがえり 腓返り"
"こむらさき 小紫 濃紫"
"こむろ 小室"
"こむろぶし 小室節"
"こめ ※ 個目 米"
"こめあぶら 米油"
"こめい 顧命 呼名 古名"
"こめいじ 古明地"
"こめいち 米市"
"こめかみ 蟀谷"
"こめがふくろ 米ヶ袋"
"こめぐら 米蔵"
"こめこ 米粉"
"こめこうじ 米麹"
"こめこめ 米米"
"こめしょうぐん 米将軍"
"こめじょうちゅう 米焼酎"
"こめじるし ※"
"こめす 米酢"
"こめそうどう 米騒動"
"こめそうば 米相場"
"こめたに 米谷"
"こめだ 米田"
"こめだわら 米俵"
"こめつが 米栂"
"こめつき 米搗き"
"こめつぶ 米粒"
"こめづくり 米作り"
"こめてん 米店"
"こめどいや 米問屋"
"こめどころ 米所"
"こめぬか 米ぬか 米糠"
"こめの 米野"
"こめぱん 米パン"
"こめひゃっぴょう 米百俵"
"こめひょう 米兵"
"こめびつ 米びつ 米櫃"
"こめぶくろ 米袋"
"こめへん 米偏"
"こめみそ 米味噌"
"こめや 米屋"
"こめん 湖面"
"こめんとぎょう コメント行"
"こめんとらん コメント欄"
"こも 薦 菰"
"こもがい 熊川"
"こもく 小目"
"こもごも 交 交々"
"こもじ 小文字"
"こもだ 小茂田 菰田"
"こもち 子持"
"こもちけい 子持罫"
"こもちづき 小望月"
"こもどし 小戻し"
"こもどり 小戻り"
"こもの 薦野 菰野 小者 小物"
"こものいれ 小物入"
"こもり 隠り 籠り 木守 古森 小森 子守"
"こもりうた 子守り唄 子守り歌 子守歌 子守唄"
"こもりや 小森谷"
"こもれび 木洩日 木洩れ陽 木洩れ日 木漏れ日"
"こもろ 小諸"
"こもん 古文 小紋 顧問"
"こもんじょ 古文書"
"こや 昆陽 木屋 小屋"
"こやいけ 昆陽池"
"こやく 子役"
"こやくにん 小役人"
"こやけ 小焼け"
"こやさこ 小屋迫"
"こやさん 姑射山"
"こやし 肥やし"
"こやす 子安"
"こやすがい 子安貝"
"こやすみ 小休み"
"こやだいら 小屋平"
"こやち 小谷内"
"こやつ 此奴"
"こやつら 此奴等"
"こやづ 小谷津"
"こやづか 小屋束"
"こやなぎ 小柳"
"こやなぎるみこ 小柳ルミ子"
"こやね 小屋根"
"こやの 小谷野"
"こやばり 小屋梁"
"こやま 湖山 古山 小山"
"こやみ 小止み"
"こやり 小槍"
"こゆ 児湯"
"こゆい 小結"
"こゆう 個有 固有"
"こゆうざ 小遊三"
"こゆうべくとる 固有ベクトル"
"こゆき 粉雪 小雪"
"こゆび 小指"
"こゆみ 小弓"
"こゆるぎ 小揺るぎ"
"こよい 今宵"
"こよう 雇傭 小用 古謡 雇用"
"こようたい 固溶体"
"こようほう 胡耀邦"
"こよみ 暦"
"こより 紙撚り"
"こら 児等 子等"
"こらい 古来"
"こらえしょう 堪え性"
"こらむきじ コラム記事"
"こらむしゅう コラム集"
"こらむらん コラム欄"
"こり 梱 凝り 狐狸"
"こりーけん コリー犬"
"こりこう 小利口"
"こりごり 懲り懲り"
"こりしょう 凝り性"
"こりつ 孤立"
"こりゅう 古流"
"こりょ 顧慮"
"こりょう 糊料 湖陵"
"こりょうり 小料理"
"こりんとしき コリント式"
"こりんとしょ コリント書"
"こるい 孤塁"
"こるくいろ コルク色"
"こるくそう コルク層"
"こるくぬき コルク抜き"
"これ 斯れ 旃 惟 此 是 之 此れ"
"これい 古礼 古例"
"これいじょう これ以上"
"これお 是雄"
"これかた 是方"
"これき 古暦"
"これさだ 是定"
"これしき 是しき 是式"
"これだけ 是だけ"
"これとう 惟任"
"こればかり 是許"
"これほど 是程"
"これまで 是迄"
"これみつ 惟光"
"これみよがし これ見よがし 此れ見よがし"
"これら 此れ等 是等"
"これらきん コレラ菌"
"ころ 転 頃"
"ころあい 頃合 頃合い"
"ころいどようえき コロイド溶液"
"ころう 狐狼 孤老 故老 虎狼 固陋 古老"
"ころく 小六"
"ころし 殺し"
"ころしあい 殺し合い"
"ころび 転び"
"ころも 衣"
"ころもあげ 衣揚げ"
"ころもがえ 更衣 衣更え 衣替え"
"ころもがわ 衣川"
"ころもで 衣手"
"ころもへん 衣偏"
"ころんびあ 哥倫比亞"
"ころんびあだいがく コロンビア大学"
"ころんびあとくべつく コロンビア特別区"
"こわ 聲 声 強"
"こわいい 強飯"
"こわいろ 聲色 声色"
"こわき 小脇"
"こわきえん 小湧園"
"こわく 蠱惑"
"こわくだに 小涌谷"
"こわけ 小分け"
"こわごわ 怖々"
"こわさき 声先"
"こわざ 小技"
"こわざし 声差し"
"こわたり 古渡り"
"こわだ 古和田"
"こわだか 聲高 声高"
"こわだんぱん 強談判"
"こわっぱ 小童"
"こわづくり 声作り"
"こわね 聲音 声音"
"こわめし 強飯"
"こわもて 強持て 強面"
"こわり 小割り 小割"
"こわれ 壊れ"
"こゑ 聲"
"こん 獻 献 壼 琴 建 近 袞 滾 溷 鶤 琿 渾 蒟 菎 崑 棍 鯀 鯤 昆 跟 狠 很 恨 艮 悃 梱 困 昏 坤 金 魂 墾 懇 婚 痕 根 今 混 紺"
"こんい 懇意"
"こんいつ 混一"
"こんいろ 紺色"
"こんいん 根因 婚姻"
"こんおん 根音"
"こんか 婚家 今夏"
"こんかい 今回"
"こんかん 根冠 根幹"
"こんが 混芽"
"こんがいこうしょう 婚外交渉"
"こんがいし 婚外子"
"こんがいれんあい 婚外恋愛"
"こんがすり 紺絣"
"こんがみ 紺紙"
"こんがん 懇願"
"こんき 根基 婚期 今期 今季 根気"
"こんきゃく 困却"
"こんきゅう 困窮"
"こんきょ 根拠"
"こんぎ 婚儀"
"こんく 金口 困苦"
"こんくらべ 根比べ 根競べ"
"こんけい 根系 根茎"
"こんけつ 混結 混血"
"こんげつ 今月"
"こんげん 根元 根源"
"こんこう 渾淆 金光 混淆 混交"
"こんこん 渾渾 昏昏 滾滾 滾々 昏々 懇々"
"こんご 今後"
"こんごう 根号 今号 金剛 混合"
"こんごういん 金剛院"
"こんごうき 混合気"
"こんごうきょう 金剛経"
"こんごうざわ 金剛沢"
"こんごうしゃ 金剛砂"
"こんごうしょ 金剛杵"
"こんごうせん 混合栓"
"こんごうづえ 金剛杖"
"こんごうぶじ 金剛峰寺"
"こんごうりき 金剛力"
"こんさい 根菜 混載"
"こんさく 混作"
"こんざい 混在"
"こんざつ 混雑"
"こんざん 崑山"
"こんし 婚資 紺紙"
"こんしーずん 今シーズン"
"こんしゅう 今秋 今週"
"こんしゅご 混種語"
"こんしゅん 今春"
"こんしょ 懇書"
"こんしょう 混晶"
"こんしょく 混食 混織 混植 混色"
"こんしょくこう 混色光"
"こんしろ 紺白"
"こんしん 根針 渾心 今身 混信 懇親 渾身"
"こんじ 恨事 金字 今時 紺地 今次 根治"
"こんじき 金色"
"こんじゃく 今昔"
"こんじゅほうしょう 紺綬褒章"
"こんじょう 懇情 紺青 今生 根性"
"こんじょうなし 根性無"
"こんじょうよう 根状葉"
"こんじょうわる 根性悪"
"こんす 公司"
"こんすい 昏睡"
"こんすたんちのーぷる 君府"
"こんず 漿"
"こんせい 根生 懇請 混生 金精 今世 混声 混成"
"こんせき 今夕 痕跡"
"こんせつ 今節 懇切"
"こんせん 混線 混戦"
"こんせんだいち 根釧台地"
"こんぜ 今世"
"こんぜつ 根絶"
"こんぜん 混然 婚前 渾然"
"こんぜんせい 婚前姓"
"こんそう 混走"
"こんそうりゅう 混相流"
"こんそくちゅうるい 根足虫類"
"こんたん 根端 魂胆"
"こんだ 今田 金田"
"こんだく 溷濁 混濁"
"こんだて 献立"
"こんだん 懇談"
"こんち 根治"
"こんちくしょう 此畜生"
"こんちゃ 紺茶"
"こんちゅう 昆蟲 昆虫"
"こんちょう 根調 今朝"
"こんてい 根柢 根底"
"こんてなせん コンテナ船"
"こんてんぎ 渾天儀"
"こんでい 金泥"
"こんでん 墾田"
"こんとう 昏倒 今冬"
"こんとく 懇篤"
"こんとん 渾沌 混沌"
"こんど 今度"
"こんどう 金藤 金銅 金堂 近藤 混同"
"こんどういさみ 近藤勇"
"こんなん 困難"
"こんにち 今日"
"こんにちは 今日は"
"こんにゃく 菎蒻 蒟蒻"
"こんにゃくいも こんにゃく芋 蒟蒻芋"
"こんにゅう 混入"
"こんねん 今年"
"こんの 昆野 金野 紺野 今野"
"こんばい 困憊"
"こんばん 今晩"
"こんばんは 今晩は"
"こんぱい 困憊"
"こんぱく 魂魄"
"こんぱくとか コンパクト化"
"こんぱすざ コンパス座"
"こんぱるりゅう 金春流"
"こんぱん 今般"
"こんひ 根被"
"こんびにけっさい コンビニ決済"
"こんびにべんとう コンビニ弁当"
"こんぴら 金比羅"
"こんぶ 昆布"
"こんぶまき 昆布巻"
"こんぷとんこうか コンプトン効果"
"こんへんちょう 混変調"
"こんぺいとう 金米糖 金平糖"
"こんぺき 紺碧"
"こんぼう こん棒 懇望 混紡 棍棒"
"こんぽう 梱包"
"こんぽん 根本"
"こんま ， 今間"
"こんまけ 根負け"
"こんめい 昆明 昏迷 混迷"
"こんもう 懇望 根毛"
"こんや 紺谷 紺屋 今夜"
"こんやく 婚約"
"こんゆう 渾融 今夕"
"こんよう 昆陽 混用"
"こんよく 混浴"
"こんらい 今来"
"こんらん 混乱"
"こんりゅう 根瘤 根粒 建立"
"こんりん 金輪"
"こんりんざい 金輪際"
"こんる 近流"
"こんるり 紺瑠璃"
"こんれい 婚礼"
"こんろ 焜炉"
"こんろん 崑崘 昆倫 崑崙"
"こんわ 混和 懇話"
"こんわく 困惑"
"ご 宕 庫 5 ５ 兒 壷 壺 炬 篌 沍 冴 忤 蜈 茣 齬 珸 牾 晤 寤 唔 梧 胡 瑚 醐 檎 后 午 娯 互 伍 吾 悟 護 豆汁 豆油 児 子 呉 期 五 碁 誤 御 後 語"
"ごーとご ゴート語"
"ごーとぞく ゴート族"
"ごあいきょう ご愛敬 ご愛嬌 御愛敬 御愛嬌"
"ごあいこ 御愛顧 ご愛顧"
"ごあいさつ 御挨拶 ご挨拶"
"ごあいよう 御愛用 ご愛用"
"ごあく 五悪"
"ごあんしん 御安心"
"ごあんない 御案内 ご案内"
"ごい 五噫 伍井 戀 恋 五井 五位 語意 語彙"
"ごいけん 御意見 ご意見"
"ごいけんばこ ご意見箱"
"ごいこう 御意向"
"ごいさぎ 五位鷺"
"ごいし 碁石"
"ごいぞく 御遺族"
"ごいたい 御遺体"
"ごいち 吾一"
"ごいちどうさま 御一同様"
"ごいちどく 御一読"
"ごいっこう 御一考 御一行"
"ごいっしょ 御一緒 ご一緒"
"ごいっしん 御一新"
"ごいっちょう 御一聴"
"ごいっぽう 御一報"
"ごいのくろうど 五位の蔵人"
"ごいらい 御依頼 ご依頼"
"ごいりよう 御入用"
"ごいん 五韻 後院 五音 誤飲"
"ごいんかん 五員環"
"ごいんきょ 御隠居"
"ごう 軣 號 刧 盒 哈 囂 噛 鼇 熬 遨 敖 嗷 傲 強 劫 拷 毫 郷 壕 濠 豪 剛 轟 業 号 合"
"ごうい 合意"
"ごういつ 合一"
"ごういん 業因 強引"
"ごうう 豪雨"
"ごうおん 合音 号音 轟音"
"ごうか 業果 劫火 業火 豪華"
"ごうかい 豪快"
"ごうかいなべ 豪快鍋"
"ごうかく 合格"
"ごうかくいわい 合格祝"
"ごうかん 合巻 合歓 強姦 号館"
"ごうがい 號外 号外"
"ごうがしゃ 恒河沙"
"ごうがん 傲岸"
"ごうき 剛己 豪毅 剛気 豪鬼 豪気 剛毅 号機"
"ごうきゅう 強弓 剛球 号泣"
"ごうきょう 剛強"
"ごうきん 合金"
"ごうぎ 豪儀 豪気 合議"
"ごうく 業垢 合区 業苦"
"ごうぐら 郷倉"
"ごうけ 郷家"
"ごうけい 豪渓 合計"
"ごうけつ 豪傑"
"ごうけつじ 豪血寺"
"ごうけん 剛堅 合憲 剛健"
"ごうげい 傲睨"
"ごうこ 江湖"
"ごうこう 毫光"
"ごうこうおん 合口音"
"ごうこうぞう 剛構造"
"ごうこく 号哭 合刻"
"ごうこん 合コン"
"ごうご 傲語 豪語"
"ごうごう 囂々 轟々 囂囂"
"ごうし 郷司 合志 郷士 合資 合祀"
"ごうししょう 合指症"
"ごうしつ 号室"
"ごうしゃ 号車 郷社 豪奢"
"ごうしゅ 強酒"
"ごうしゅう 江州 豪州"
"ごうしょ 劫初"
"ごうしょう 業障 江商 合焦 号証 豪商"
"ごうしん 剛心"
"ごうじ 合字 剛司"
"ごうじょう 剛情 強盛 強情"
"ごうじょっぱり 強情っ張り"
"ごうすう 号数"
"ごうせい 合生 合性 強請 豪勢 剛性 合成"
"ごうせいかわ 合成革"
"ごうせいごむ 合成ゴム"
"ごうせっとう 強窃盗"
"ごうせつ 豪雪"
"ごうせん 合線 号線 合繊"
"ごうぜん 轟然 傲然"
"ごうそ 強訴"
"ごうそう 合装 豪壮"
"ごうそっきゅう 剛速球"
"ごうぞく 豪族"
"ごうた 剛太"
"ごうたい 剛体"
"ごうたいぼう 剛体棒"
"ごうたん 剛胆 豪胆"
"ごうだ 剛田 郷田 合田"
"ごうだつ 強奪"
"ごうだん 強談"
"ごうだんしょう 江談抄"
"ごうち 合致 碁打ち 郷地"
"ごうちゃく 合着"
"ごうちょく 剛直"
"ごうちん 轟沈"
"ごうつ 江津"
"ごうつくばり 業突張 業突く張り"
"ごうづ 江津"
"ごうてい 豪邸"
"ごうてき 強的 豪的 号笛"
"ごうてんじょう 格天井"
"ごうとう 豪宕 鼇頭 号棟 強盗"
"ごうとくじ 豪徳寺"
"ごうど 神戸"
"ごうどう ≡ 合同"
"ごうな 寄居虫"
"ごうの 郷野"
"ごうのう 豪農"
"ごうのうら 郷ノ浦"
"ごうのもの 剛の者"
"ごうはら 郷原 業腹"
"ごうはん 合板"
"ごうばつ 劫罰"
"ごうばん 合板"
"ごうひ 合肥 合皮 合否"
"ごうひつ 合筆"
"ごうびょう 業病"
"ごうびん 合瓶"
"ごうふ 豪富"
"ごうふく 剛愎 剛腹"
"ごうぶち 格縁"
"ごうぶん 合文"
"ごうへき 剛壁"
"ごうへん 合片"
"ごうべん 合弁"
"ごうべんか 合弁花"
"ごうほう 業報 号俸 豪放 号砲 合法"
"ごうほうどらっぐ 合法ドラッグ"
"ごうぼう 号棒"
"ごうま 格間 業魔 降魔"
"ごうまい 豪邁"
"ごうまつ 劫末 毫末"
"ごうまん 傲慢"
"ごうめ 号目 合目"
"ごうめい 合名"
"ごうも 毫も"
"ごうもう 毫毛 剛毛"
"ごうもくてき 合目的"
"ごうもん 拷問"
"ごうゆう 傲遊 遨遊 豪雄 合有 豪勇 剛勇 豪遊"
"ごうよく 強慾 強欲"
"ごうり 毫釐 合理"
"ごうりき 剛力 強力 合力"
"ごうりせい 郷里制"
"ごうりゃく 劫掠"
"ごうりゅう 合流"
"ごうりゅうば 剛竜馬"
"ごうりょく 合力"
"ごうれい 号令"
"ごうわん 剛腕"
"ごうん 五運 五雲 五蘊"
"ごえ 肥 聲 声 越え"
"ごえい 護衛"
"ごえいか 御詠歌"
"ごえいてん 御栄転 ご栄転"
"ごえつ 呉越"
"ごえもん 五右衛門"
"ごえん 後宴 誤嚥 ご縁 御縁"
"ごえんじょ 御援助 ご援助"
"ごえんりょ 御遠慮"
"ごおう 牛王 牛黄 五黄"
"ごおうぼ 御応募 ご応募"
"ごおり 氷"
"ごおん ご恩 五陰 呉音 五音 御恩 語音"
"ごおんこ 御恩顧 ご恩顧"
"ごおんじょうく 五陰盛苦"
"ごか 五霞 五箇 五加"
"ごかい 五階 五回 碁界 碁会 五戒 誤解"
"ごかいせつ 御解説"
"ごかいそう 御会葬 ご会葬"
"ごかいちょう 御開帳"
"ごかいとう 御回答 ご回答"
"ごかく 互格 牛角 五角 互角"
"ごかくにん 御確認 ご確認"
"ごかご 御加護"
"ごかしょう 五個荘"
"ごかせ 五ヶ瀬"
"ごかぞく 御家族 ご家族"
"ごかって 御勝手"
"ごかつやく 御活躍 ご活躍"
"ごかつよう 御活用"
"ごかてい 御家庭 ご家庭"
"ごかひ 五加皮"
"ごかぼう 五家宝"
"ごかん 五官 語間 後漢 語幹 語感 五感 互換"
"ごかんおう 五冠王"
"ごかんしん 御関心"
"ごかんじょ 御寛恕 ご寛恕"
"ごかんそう 御感想 ご感想"
"ごかんべん 御勘弁"
"ごかんよう 御寛容 ご寛容"
"ごがく 五岳 語学"
"ごがつ 皐月 ５月 五月"
"ごがん 護岸"
"ごき 呉器 語基 御器 御忌 語気 誤記"
"ごきおく 御記憶"
"ごきかぶり 御器噛"
"ごきげん 御機嫌 ご機嫌"
"ごきげんよう 御機嫌よう"
"ごきしちどう 五畿七道"
"ごきそ 御器所"
"ごきたい 御期待 ご期待"
"ごきにゅう 御記入 ご記入"
"ごきぼう 御希望 ご希望"
"ごきゃく 五脚"
"ごきゅう 誤球 御給"
"ごきゅうけい 御休憩"
"ごきょう 五経 五橋"
"ごきょうさん 御協賛"
"ごきょうじ 御教示 ご教示"
"ごきょうじゅ 御教授"
"ごきょうだい 御兄弟"
"ごきょうみ 御興味"
"ごきょうりょく 御協力 ご協力"
"ごきょうろん 護教論"
"ごきょか 御許可"
"ごきんじょ 御近所 ご近所"
"ごぎ 語義"
"ごぎゃく 五逆"
"ごぎゅう 呉牛"
"ごぎょう 御形 五行"
"ごぎろん 御議論"
"ごく 石 国 五区 獄 極 語句"
"ごくあく 極悪"
"ごくい 獄衣 極意"
"ごくいちぶ 極一部"
"ごくいん 極印"
"ごくう 御供 悟空"
"ごくかん 極寒"
"ごくけい 極刑"
"ごくげつ 極月"
"ごくごく 極々"
"ごくさい 極彩"
"ごくさむ 極寒"
"ごくし 獄死"
"ごくしゃ 獄舎"
"ごくしゅう 極宗 獄囚"
"ごくしょ 極暑"
"ごくしょう 極小"
"ごくしょうすう 極少数"
"ごくしょうりょう 極少量"
"ごくしょき 極初期"
"ごくしん 極信"
"ごくじょう 極上"
"ごくそう 獄窓"
"ごくそく 獄則 極促"
"ごくそつ 獄卒"
"ごくちゅう 獄中"
"ごくつぶし 穀潰し"
"ごくていおん 極低温"
"ごくていそく 極低速"
"ごくどう 極道"
"ごくない 獄内"
"ごくひ 極秘"
"ごくひん 極貧"
"ごくび 極微"
"ごくふつう 極普通"
"ごくぶと 極太"
"ごくぼそ 極細"
"ごくぼそびき 極細挽き"
"ごくもん 獄門"
"ごくもんとう 獄門島"
"ごくや 獄屋"
"ごくやす 極安"
"ごくらく 極楽"
"ごくらくちょう 極楽鳥"
"ごくり 獄吏"
"ごくろう 御苦労 ご苦労"
"ごくろうさま ご苦労さま"
"ごぐん 語群"
"ごけ 碁笥 後家"
"ごけい 五刑 語形 互恵"
"ごけいけん 御経験"
"ごけた 五桁"
"ごけだおし 後家倒し"
"ごけっこん 御結婚 ご結婚"
"ごけっせき 御欠席 ご欠席"
"ごけつ 五傑"
"ごけにん 御家人"
"ごけん 護憲"
"ごけんきゅう 御研究"
"ごけんこう 御健康"
"ごけんしょう 御健勝 ご健勝"
"ごけんそん 御謙遜"
"ごけんとう 御健闘 御検討 ご検討"
"ごげん 御監 五眼 五絃 語原 五弦 御見 語源"
"ごこ 五胡"
"ごこう 五更 五劫 五光 五香 後光"
"ごこうい 御厚意 御好意 ご厚意 ご好意"
"ごこうえん 御講演"
"ごこうぎ 御高誼 ご高誼 御厚誼 ご厚誼"
"ごこうごみん 五公五民"
"ごこうし 御厚志 ご厚志"
"ごこうしゆい 五劫思惟"
"ごこうしょう ご高承"
"ごこうじょう 御厚情 ご厚情"
"ごこうせい 語構成"
"ごこうにゅう 御購入"
"ごこうはい 御高配 ご高配"
"ごこうらん 御高覧 ご高覧"
"ごこうりょ 御考慮"
"ごこく 後刻 護国 五穀"
"ごこじゅうろっこく 五胡十六国"
"ごこち 心地"
"ごころ 心"
"ごこん 五根 語根"
"ごこんじょう 御懇情 ご懇情"
"ごご 語語 語々 午后 午後"
"ごごう 五合"
"ごごち 心地"
"ごごん 五言"
"ごさ 誤差"
"ごさい 五歳 五菜 五彩 後妻"
"ごさいてんのう 後西天皇"
"ごさく 吾作"
"ごさしゅう 御査収"
"ごさた 御沙汰"
"ごさつ 誤殺"
"ごさぼう 誤差棒"
"ごさん 午餐 誤算"
"ごさんか 御参加 ご参加"
"ごさんかた 御三方"
"ごさんけ 御三家"
"ごさんこう 御参考"
"ごさんしゅう 御参集"
"ごさんしょう 御参照"
"ごさんどう 御賛同 ご賛同"
"ごさんれつ 御参列 ご参列"
"ござ 後座 御座 茣蓙 蓙"
"ございしょ 御在所"
"ござそうろう 御座候"
"ごし 越し 語詞 語誌 語史 呉子 五子 腰 五指"
"ごしえん 御支援 ご支援"
"ごしき 五色"
"ごしじ 御指示"
"ごしそく ご子息"
"ごしちご 五七五"
"ごしちちょう 五七調"
"ごしっくしょうせつ ゴシック小説"
"ごしっくたい ゴシック体"
"ごしっくようしき ゴシック様式"
"ごしつぎ 御質疑"
"ごしつもん 御質問 ご質問"
"ごしてい 御指定"
"ごしてき 御指摘 ご指摘"
"ごしどう 御指導 ご指導"
"ごしなん 御指南"
"ごしま 五島"
"ごしめい 御指名"
"ごしゃ 誤写 誤射"
"ごしゃく 五爵 語釈"
"ごしゅ 語種 御酒 五種"
"ごしゅいんせん 御朱印船"
"ごしゅう 後周 互酬"
"ごしゅうぎ ご祝儀 御祝儀"
"ごしゅうぎぶくろ 御祝儀袋 ご祝儀袋"
"ごしゅうしょうさま 御愁傷様"
"ごしゅうしん 御執心 ご執心"
"ごしゅうち 御周知"
"ごしゅうにん 御就任 ご就任"
"ごしゅこう 御趣向"
"ごしゅし 御主旨"
"ごしゅじん 御主人 ご主人"
"ごしゅちょう 御主張"
"ごしゅっしん 御出身"
"ごしゅっせき 御出席 ご出席"
"ごしゅつえん 御出演"
"ごしゅみ 御趣味"
"ごしゅん 呉春"
"ごしょ 五所 御所"
"ごしょいずみ 御所泉"
"ごしょう 五章 五障 誤称 後生"
"ごしょうかい 御照会 ご照会 御紹介 ご紹介"
"ごしょうたい 御招待 ご招待"
"ごしょうだく 御承諾"
"ごしょうち 御承知 ご承知"
"ごしょうのう 御笑納"
"ごしょうみ 御賞味"
"ごしょうらん 御笑覧"
"ごしょがわら 五所川原"
"ごしょく 誤植 五色"
"ごしょくじ 御食事"
"ごしょぐるま 御所車"
"ごしょの 御所野"
"ごしょのうら 御所浦"
"ごしょまと 御所的"
"ごしょめい 御署名"
"ごしょもう 御所望"
"ごしよう 御使用 ご使用"
"ごしん 誤信 誤審 誤診 護身"
"ごしんえい 御真影"
"ごしんせつ 御親切"
"ごしんぞ 御新造"
"ごしんぞう 御新造"
"ごしんたい 御神体"
"ごしんたく 御神託 ご神託"
"ごしんとう 御神灯"
"ごしんぱい 御心配 ご心配"
"ごしんぷ 御親父"
"ごしんぼく 御神木"
"ごしんもじ 御親文字 御心文字"
"ごじ ５時 五次 五時 護持 誤字"
"ごじあい 御自愛 ご自愛"
"ごじさん ご持参"
"ごじしん 御自身"
"ごじせい 御時世 ご時世"
"ごじたく 御自宅"
"ごじつ 後日"
"ごじてん 語辞典"
"ごじひ ご慈悲 御慈悲"
"ごじぶん 御自分"
"ごじまん 御自慢"
"ごじゅう 五十 五重"
"ごじゅうかた 五十肩"
"ごじゅうから 五十雀"
"ごじゅうさんつぎ 五十三次"
"ごじゅうしょ 御住所 ご住所"
"ごじゅうのとう 五重塔"
"ごじゅつ 後述"
"ごじゅん 語順"
"ごじゅんせつ 五旬節"
"ごじゅんび 御準備"
"ごじゆう 御自由"
"ごじょ 互除 語序 互助"
"ごじょう 誤乗 互譲 五常 五條 五条"
"ごじょうざか 五条坂"
"ごじょうだん 御冗談"
"ごじょうめ 五城目"
"ごじょくあくせ 五濁悪世"
"ごじょげん 御助言"
"ごじょりょく 御助力"
"ごじる 豆汁 呉汁"
"ごじん 五塵 吾人 御仁"
"ごじんか 御神火"
"ごじんたい 御神体"
"ごじんりょく 御尽力"
"ごす 呉須"
"ごすい 五衰 午睡"
"ごすいさつ 御推察"
"ごすいしょう 御推奨"
"ごすいせん 御推薦"
"ごすいもじ 御推文字"
"ごすう 語数"
"ごすけ 吾助"
"ごすん 五寸"
"ごすんくぎ 五寸釘"
"ごすんつぼね 五寸局"
"ごず 牛頭"
"ごずいい 御随意"
"ごずみ 後炭"
"ごせ 後世 御所"
"ごせい 五牲 五清 五聖 語勢 五声 五星 碁聖 後世 悟性 互生"
"ごせいうん 御盛運 ご盛運"
"ごせいえい 御盛栄 御清栄 ご清栄"
"ごせいえん 御声援"
"ごせいきゅう 御請求 ご請求"
"ごせいぎょう 御盛業 ご盛業"
"ごせいこう 御成功"
"ごせいこん 御成婚"
"ごせいしょう 御清勝 ご清勝 御清祥 ご清祥"
"ごせいたん 御生誕"
"ごせいどうどう 五世同堂"
"ごせいばいしきもく 御成敗式目"
"ごせいほう 後世方"
"ごせいらん 御清覧"
"ごせつめい 御説明"
"ごせん 五千 五線 五泉 互選"
"ごせんぞ 御先祖 ご先祖"
"ごせんたく 御宣託"
"ごせんふ 五線譜"
"ごせんもん 御専門"
"ごぜ 瞽女"
"ごぜん 御膳 御前 午前"
"ごそ 語素"
"ごそう 誤想 五艘 互層 護送"
"ごそうぞう 御想像"
"ごそうだん 御相談 ご相談"
"ごそうふ 御送付 ご送付"
"ごそくもじ 御息文字"
"ごそくろう 御足労 ご足労"
"ごそつぎょう 御卒業"
"ごそんがん 御尊顔"
"ごそんじ 御存じ"
"ごそんぷ 御尊父"
"ごぞう 五臓"
"ごぞく 五族 語族"
"ごぞんじ 御存じ 御存知 ご存じ ご存知"
"ごぞんち 御存知"
"ごたい 五体"
"ごたいおう 御対応"
"ごたいそう 御大層 ご大層"
"ごたいめん 御対面"
"ごたえ 応え"
"ごたく 五択 御託"
"ごたくせん ご託宣 御託宣"
"ごたしょう 御多祥 ご多祥"
"ごたぶん 御多分 ご多分"
"ごたぼう 御多忙 ご多忙"
"ごたま 五玉"
"ごたようちゅう 御多用中 ご多用中"
"ごたん 五反"
"ごたんい 語単位"
"ごたんだ 五反田"
"ごたんとう 五炭糖 御担当"
"ごだい 伍代 五大 五代"
"ごだいこ 五大湖"
"ごだいさん 五台山"
"ごだいじっこく 五代十国"
"ごだつ 誤脱"
"ごだん 誤断 後段 五段"
"ごち 五智"
"ごちそう 御馳走 ご馳走"
"ごちそうさま 御馳走さま ごちそう様 ご馳走さま"
"ごちゃく 五着 御着"
"ごちゅう 語註 語注 語中"
"ごちゅうい 御注意 ご注意"
"ごちゅうこく 御忠告"
"ごちゅうもく 御注目"
"ごちゅうもん 御注文 ご注文"
"ごちょう 語長 伍長 語調"
"ごっかん 極官 極寒"
"ごったに ごった煮"
"ごって 毎"
"ごっぽう 業報"
"ごつうち 御通知 ご通知"
"ごつごう 御都合 ご都合"
"ごつぼ 五坪"
"ごづめづ 牛頭馬頭"
"ごて 鏝 後手"
"ごてい 五鼎 五帝"
"ごていあん 御提案"
"ごていきょう 御提供"
"ごていしゅ 御亭主"
"ごていしゅつ 御提出"
"ごていじ 御提示"
"ごていせい 御訂正"
"ごていねい 御丁寧 ご丁寧"
"ごてがち 後手勝"
"ごてん 御殿"
"ごてんい 御典医"
"ごでん 誤伝"
"ごでんじゅ 御伝授"
"ごと 亊 琴 如 五斗 言 事 毎"
"ごとう 呉島 後唐 五頭 五嶋 語頭 五島 後藤 誤答"
"ごとうしゃく 五等爵"
"ごとうしょ 御当所"
"ごとうじょう 御登場"
"ごとうち 御当地"
"ごとうちゃく 御到着 ご到着"
"ごとうろん 御討論"
"ごとおび 五十日"
"ごとく 悟得 五徳"
"ごとし ゴト師 如し"
"ごとに 毎に"
"ごど 五度"
"ごどう 悟道"
"ごどうはい 御同輩"
"ごどうはん 御同伴"
"ごどうやく 御同役"
"ごどく 誤読"
"ごないぎ 御内儀"
"ごないしょ 御内書"
"ごなん 御難"
"ごにゅう 悟入 五入"
"ごにゅうかい 御入会"
"ごにゅうきん ご入金"
"ごにゅうじょう 御入場"
"ごにん 五人 誤認"
"ごねどく ゴネ得 ごね得"
"ごねん 五年 御念"
"ごのう 御悩"
"ごのうせん 五能線"
"ごのへ 五戸"
"ごのみ 好み"
"ごは 語派"
"ごはい 御拝 向拝 誤配"
"ごはいさつ 御拝察"
"ごはいりょ 御配慮 ご配慮"
"ごはさん 御破算 ご破算"
"ごはっちゅう 御発注"
"ごはってん 御発展 ご発展"
"ごはっと ご法度 御法度"
"ごはっぴょう 御発表"
"ごはつげん 御発言"
"ごはん 御判 誤判 ご飯 御飯"
"ごはんえい 御繁栄 ご繁栄"
"ごはんじょう 御繁盛 ご繁盛"
"ごはんだん 御判断"
"ごば 後場"
"ごばく 誤爆"
"ごばん 五番 碁盤"
"ごひき 五匹"
"ごひつ 五筆"
"ごひはん 御批判"
"ごひひょう 御批評"
"ごひゃく 五百"
"ごび 語尾"
"ごびゅう 誤謬"
"ごびょう 御廟"
"ごふ 五府 後夫 護符"
"ごふう 碁風"
"ごふうじゅうう 五風十雨"
"ごふうふ 御夫婦"
"ごふく 五福 呉服"
"ごふこう 御不幸"
"ごふさい 御夫妻"
"ごふざい 御不在"
"ごふじょう 御不浄"
"ごふじん 御夫人 御婦人"
"ごふたん 御負担"
"ごふない 御府内"
"ごふべん 御不便"
"ごふまん 御不満"
"ごふめい 御不明"
"ごふん 五分 胡粉"
"ごぶ 五部 五分"
"ごぶがゆ 五分粥"
"ごぶがり 五分刈り"
"ごぶさた 御無沙汰 ご無沙汰"
"ごぶじ 御無事"
"ごぶつ 五仏 御物"
"ごぶつぜん 御仏前"
"ごぶらんおり ゴブラン織"
"ごぶれい 御無礼"
"ごぶん 五分 誤聞"
"ごへい 御幣 語弊"
"ごへん 互変"
"ごへんきゃく 御返却"
"ごへんこう 御変更"
"ごへんじ 御返事 ご返事"
"ごへんそう 御返送 ご返送"
"ごへんとう 御返答"
"ごべん 五弁"
"ごべんたつ 御鞭撻"
"ごほう 午砲 護法 御報 誤報 語法"
"ごほうこく 御報告 ご報告"
"ごほうし 御芳志 ご芳志 御奉仕 ご奉仕"
"ごほうじ 御法事"
"ごほうじん 護法神"
"ごほうぜん 御宝前"
"ごほうねん 御放念 ご放念"
"ごほうび 御褒美 ご褒美"
"ごほうめい 御芳名 ご芳名"
"ごほく 吾北"
"ごほん 御本"
"ごほんぎ 五本木"
"ごほんぞん 御本尊"
"ごほんゆび 五本指"
"ごほんらい 語本来"
"ごぼう 牛蒡 御坊"
"ごぼうせい 五芒星"
"ごぼどう 御母堂"
"ごま 独楽 駒 護摩 胡麻"
"ごまあえ 胡麻和え"
"ごまあぶら ゴマ油 ごま油 胡麻油"
"ごまあん 胡麻餡"
"ごまがら 胡麻殻"
"ごましお 胡麻塩"
"ごましおあたま 胡麻塩頭"
"ごますり 胡麻擂り"
"ごまだけ 胡麻竹"
"ごまだれ 胡麻垂れ"
"ごまつ 語末"
"ごまのはい 護摩の灰"
"ごまのはぐさか ゴマノハグサ科"
"ごまふあざらし 胡麻斑海豹"
"ごまよごし 胡麻汚し"
"ごまん 五万"
"ごまんえつ 御満悦"
"ごまんきつ 御満喫"
"ごみ 込 埖 護美 塵芥 芥 五味 塵"
"ごみあくた 塵芥"
"ごみおか 五味岡"
"ごみしょり ゴミ処理"
"ごみすて ゴミ捨て"
"ごみずのおてんのう 後水尾天皇"
"ごみだし ゴミ出し"
"ごみはつでん ごみ発電"
"ごみばこ ゴミ箱"
"ごみひろい ゴミ拾い"
"ごみぶくろ ゴミ袋"
"ごみぶん 御身分"
"ごみむし 歩行虫"
"ごみゃく 語脈"
"ごみょう 五明"
"ごみんかん 護民官"
"ごむ 護謨"
"ごむいた ゴム板"
"ごむいん ゴム印"
"ごむかん ゴム管"
"ごむぐつ ゴム靴"
"ごむこうぎょう ゴム工業"
"ごむしょくぶつ ゴム植物"
"ごむじょう ゴム状"
"ごむせい ゴム製"
"ごむぞうり ゴム草履"
"ごむぞこ ゴム底"
"ごむたい 御無体"
"ごむだん ゴム弾"
"ごむてぶくろ ゴム手袋"
"ごむとび ゴム跳び"
"ごむなが ゴム長"
"ごむのき ゴムの木"
"ごむのり ゴム糊"
"ごむひも ゴム紐"
"ごむふうせん ゴム風船"
"ごむまり ゴム毬"
"ごむよう 御無用"
"ごめ 米 込"
"ごめい 五名 五明"
"ごめいさつ 御明察 ご明察"
"ごめいとう 御名答"
"ごめいふく ご冥福 御冥福"
"ごめいわく 御迷惑 ご迷惑"
"ごめん 御免"
"ごめんこうむる 蒙御免"
"ごめんどう 御面倒"
"ごめんなさい 御免なさい"
"ごもく 五目"
"ごもくめし 五目飯"
"ごもち 御物"
"ごもっとも 御尤も"
"ごもつ 御物"
"ごもるてがか ゴモルテガ科"
"ごもん 五門 御紋 御門"
"ごもんぜき 御門跡"
"ごや 午夜 五夜 後夜 小屋"
"ごやく 語訳 誤訳"
"ごゆ 御油"
"ごゆうじん 御友人"
"ごゆうよ 御猶予"
"ごよう 五葉 ご用 誤用 御用"
"ごようい 御用意"
"ごようきき 御用聞 御用聞き"
"ごようきゅう 御要求"
"ごようけんせつ 五洋建設"
"ごようしゃ 御容赦 ご容赦"
"ごようじん 御用心"
"ごようす 御様子"
"ごようたし 御用達"
"ごようたつ 御用達"
"ごようだつ 御用達"
"ごようぢょうちん 御用提灯"
"ごようぼう 御要望 ご要望"
"ごようまつ 五葉松"
"ごようめい 御用命 ご用命"
"ごようろん 語用論"
"ごよく 五欲"
"ごよさん ご予算"
"ごよてい 御予定"
"ごよやく 御予約"
"ごらいこう ご来光 御来光"
"ごらいごう 御来迎"
"ごらいじょう 御来場 ご来場"
"ごらいてん 御来店 ご来店"
"ごらいりん 御来臨 ご来臨"
"ごらく 娯楽"
"ごらん 御覧 ご覧"
"ごり 石伏魚 鮴"
"ごりおし ゴリ押し ごり押し"
"ごりかい 御理解 ご理解"
"ごりしょう 御利生"
"ごりっぱ 御立派 ご立派"
"ごりっぷく ご立腹"
"ごりむちゅう 五里霧中"
"ごりやく ご利益 御利益"
"ごりゅう 五竜"
"ごりゅうい 御留意"
"ごりゅうせい 御隆盛 ご隆盛"
"ごりょう 御寮 後梁 御霊 御料 御領 御陵"
"ごりょうかい 御了解"
"ごりょうかく 五稜郭"
"ごりょうけ 御両家"
"ごりょうしょう 御了承 ご了承"
"ごりょうしん 御両親 ご両親"
"ごりょうにん 御両人"
"ごりょうば 御猟場"
"ごりょうめい 御両名"
"ごりょこう 御旅行"
"ごりよう 御利用 ご利用"
"ごりん 五倫 五厘 五輪"
"ごるい 語類"
"ごるふじょう ゴルフ場"
"ごれい 誤例 語例"
"ごれいぜん 御霊前"
"ごれんらく 御連絡 ご連絡"
"ごろ 頃 語呂"
"ごろー ＧＯＲＯ"
"ごろあわせ 語呂合せ"
"ごろう ＧＯＲＯ 伍朗 悟朗 悟郎 五郎"
"ごろうじん 御老人"
"ごろく 五六 語録"
"ごろね ゴロ寝 ごろ寝"
"ごろはち 五郎八"
"ごろべえ 五郎兵衛"
"ごろも 衣"
"ごわり 五割"
"ごん 權 嚴 金 諢 魂 勤 艮 厳 権 言"
"ごんか 言下"
"ごんきょう 権教"
"ごんぎょう 勤行"
"ごんく 言句"
"ごんくーるしょう ゴンクール賞"
"ごんぐ 欣求"
"ごんげ 権化"
"ごんげん 権現"
"ごんげんづくり 権現造"
"ごんご 言語"
"ごんじゃ 権者"
"ごんじょう 言上"
"ごんずい 権瑞"
"ごんぞう 権造"
"ごんだ 権田"
"ごんてき 権的"
"ごんどう 権藤"
"ごんどうくじら 巨頭鯨"
"ごんのそち 権帥"
"ごんべえ 権兵衛"
"ごんべん 言偏"
"ごんりょう 艮陵"
"さ 狹 狭 簑 蓑 早 挫 嗄 再 些 茶 唆 梭 詐 做 作 乍 扠 叉 柤 渣 査 嗟 槎 瑳 搓 蹉 磋 嵳 嵯 娑 莎 裟 紗 沙 砂 瑣 鎖 佐 左 差"
"さーかすだん サーカス団"
"さーくるかつどう サークル活動"
"さーばがわ サーバ側"
"さーびすがかり サービス係"
"さーびすぎょう サービス業"
"さーびすざんぎょう サービス残業"
"さーびすせいしん サービス精神"
"さーびすないよう サービス内容"
"さーびすめい サービス名"
"さーびすもう サービス網"
"さーびすよう サービス用"
"さーびすりょう サービス料"
"さあや 紗綾"
"さい 責 切 殺 財 衰 悽 凄 霽 蔡 纔 猜 樶 灑 洒 晒 西 濟 済 齊 斉 儕 齋 靫 釵 砦 柴 淬 碎 砕 縡 宰 寨 塞 犲 豺 顋 腮 鰓 偲 摧 催 崔 綵 彩 採 采 載 裁 栽 哉 差違 佐井 妻 細 斎 災 菜 祭 債 骰子 賽 犀 才 歳 再 最 差異 際"
"さいあい 最愛"
"さいあく 最悪"
"さいあん 再案"
"さいいき 西域"
"さいいち 才一"
"さいいちろう 斉一郎"
"さいいん 斎院 催淫 西院"
"さいう 最右 細雨"
"さいうん 彩雲"
"さいえい 細纓 再映"
"さいえき 歳役"
"さいえん 再縁 最遠 才媛 再演 菜園"
"さいおう 再往 再応 塞翁 最奥"
"さいおうがうま 塞翁が馬"
"さいおく 最奥"
"さいおん 蔡温"
"さいおんじ 西恩寺 西園寺"
"さいおんじきんもち 西園寺公望"
"さいおんじこう 西園寺公"
"さいか 雑賀 彩花 再嫁 載貨 西下 採火 裁可 災禍 最下"
"さいかい 斎戒 際会 西海 再会 再開"
"さいかく 西鶴 才覚"
"さいかや さいか屋"
"さいかわ 斉川 犀川"
"さいかん 災患 彩管 祭官 才幹 菜館 細管 再刊"
"さいかんさんゆう 歳寒三友"
"さいが 齋賀 雑賀"
"さいがい 際涯 最外 災害"
"さいがいきゅうじょけん 災害救助犬"
"さいがく 才学"
"さいがわ 犀川"
"さいき 彩木 妻木 斎木 斉木 佐伯 債鬼 再記 催奇 祭器 才気 再帰 再起"
"さいきけいせい 催奇形性"
"さいきせい 最輝星"
"さいきゅう 鰓弓 最急"
"さいきょ 再挙 裁許"
"さいきょう 歳刑 埼京 西京 最強"
"さいきょうづけ 西京漬"
"さいきょうやき 西京焼"
"さいきん 細菌 最近"
"さいぎ 再議 猜疑 祭儀"
"さいぎょう 西行"
"さいく 細工"
"さいくつ 採掘"
"さいくん 細君"
"さいぐ 祭具"
"さいぐう 斎宮"
"さいぐさ 三枝"
"さいけい 歳計 再掲"
"さいけいこく 最恵国"
"さいけつ 裁決 採決 採血"
"さいけん 細見 再見 再建 債権 債券"
"さいけんしゃ 再検者"
"さいげい 才芸"
"さいげつ 歳月"
"さいげん 際限 再現"
"さいこ 採子 才子 柴胡 西湖 最古"
"さいこう 砕鉱 斉衡 再校 再構 採鉱 細孔 再興 催行 採光 再考 最高"
"さいこうしん 最高神"
"さいこく 催告"
"さいこくぼん 再刻本"
"さいころ 賽子 骰子"
"さいこん 再建 細根 菜根 再婚"
"さいご 西醐 最期 最後"
"さいごう 西郷"
"さいごく 西国"
"さいごっぺ 最後屁 最後っ屁"
"さいごのしんぱん 最後の審判"
"さいごまで 最後まで"
"さいごん 西貢"
"さいさ 最左 歳差"
"さいさい 彩々 再再 歳歳 再載 再々 歳々"
"さいさうんどう 才差運動"
"さいさき 幸先"
"さいさん 再三 採算"
"さいさんらいん 採算ライン"
"さいさんわれ 採算割れ"
"さいし 孥 載祀 再思 斉志 再四 才子 再試 祭司 祭祀 妻子"
"さいしき 才識 祭式 彩色"
"さいしつ 才質 妻室 祭室"
"さいして 際して"
"さいしゅ 歳首 祭主 採種 採取"
"さいしゅう 採集 最終"
"さいしゅうけい 最終景"
"さいしゅうとう 済州島"
"さいしゅつ 歳出"
"さいしゅんかん 再春館"
"さいしょ 才所 細書 最所 税所 最初"
"さいしょう 妻妾 最勝 宰相 最少 最小"
"さいしょうぎ 最小木"
"さいしょく 才色 彩飾 菜食 彩色"
"さいしん 西神 砕身 祭神 最深 再審 再診 細心 最新"
"さいしんにゅーす 最新ニュース"
"さいじ 斎次 歳次 細事 斉次 西寺 細字 祭事 催事 歳児"
"さいじき 斎食 歳時記"
"さいじつ 斎日 祭日"
"さいじゃく 最弱"
"さいじょ 細叙 斎女 妻女 才女"
"さいじょう 齋城 祭場 西條 西城 西条 斎場 最上"
"さいじょうじじょうかい 最小2乗解"
"さいじん 才人 祭神"
"さいすいき 採水器"
"さいすん 採寸"
"さいずべつ サイズ別"
"さいせい 祭政 歳星 採精 済世 最盛 再製 済生 再生"
"さいせいばり 再生針"
"さいせき 載籍 採石 砕石"
"さいせっき 細石器"
"さいせつ 歳殺 細説 再説 細節 砕屑"
"さいせつがん 砕屑岩"
"さいせん 西線 細線 再戦 賽銭 再選"
"さいせんばこ 賽銭箱"
"さいぜん 菜膳 截然 最前 最善"
"さいそ 菜蔬 再訴"
"さいそう 彩層 採草 再送"
"さいそく 催促 細則 最速"
"さいぞう 才蔵"
"さいた 齊田 才田 斉田 斎田 財田 最多"
"さいたい 妻帯 臍帯"
"さいたいけつ 臍帯血"
"さいたく 採択"
"さいたま 埼玉"
"さいたまし さいたま市"
"さいたらぶし 斎太郎節"
"さいたる 最たる"
"さいたん 採炭 最短"
"さいたんしゅすう 最短手数"
"さいだ 斎田 斉田"
"さいだい 埼大 歳代 細大 最大"
"さいだいじ 西大寺"
"さいだん 截断 採暖 細断 裁断 祭壇"
"さいち 佐一 細緻 最遅 才知"
"さいちく 再築"
"さいちゅう 最中"
"さいちょう 再調 最澄 最長"
"さいてい 再訂 裁定 最低"
"さいていらいん 最低ライン"
"さいてき 最適"
"さいてん 祭天 西天 再転 採点 祭典"
"さいでん 祭殿"
"さいと 西都"
"さいとう 齊藤 齋藤 斉藤 斎藤"
"さいとうもきち 斎藤茂吉"
"さいとく 才徳"
"さいど 済度 彩度 再度"
"さいどう 細動"
"さいどうふう 砕動風"
"さいどうみゃく 細動脈"
"さいどく 再読"
"さいない 最内"
"さいなん 最南 済南 災難"
"さいにち 斎日"
"さいにゅう 再入 歳入"
"さいにょう 採尿"
"さいにょうかん 細尿管"
"さいにん 再任 再認"
"さいねん 西念 再燃"
"さいのう 塞納 臍嚢 採納 才能"
"さいのかわら 賽の河原"
"さいのめ 賽の目"
"さいは 歳破"
"さいはい 儕輩 再拝 采配"
"さいはく 西伯"
"さいはつ 再発"
"さいはん 最汎 再犯 再版 再販"
"さいばい 栽培"
"さいばし 菜箸"
"さいばら 催馬楽"
"さいばん 歳晩 採番 裁判"
"さいひ 歳費 採否"
"さいひつ 才筆 細筆"
"さいひょう 細評 細氷 砕氷"
"さいひんこく 最貧国"
"さいひんち 最頻値"
"さいび 最微 最美 細微"
"さいふ 宰府 採譜 財布"
"さいふく 祭服"
"さいぶ 西部 細部"
"さいぶつ 才物"
"さいぶん 祭文 細分"
"さいぶんかつ 細分割"
"さいへん 砕片 細片 再編"
"さいべつ 細別"
"さいほう 細胞 再報 採訪 裁縫 西方"
"さいほうばこ 裁縫箱"
"さいほく 最北"
"さいぼう 才望 細棒 細胞"
"さいぼうかい 細胞塊"
"さいぼうしん 細胞診"
"さいぼうまく 細胞膜"
"さいぽすと 再ポスト"
"さいまつ 歳末"
"さいみつ 最密 細密"
"さいみゃく 細脈"
"さいみょうじ 斎明寺"
"さいみん 細民 済民 催眠"
"さいみんちょうたい 細明朝体"
"さいむ 債務"
"さいめい 才名 斉明"
"さいめいちょう 細明朝"
"さいもく 細目"
"さいもつ 賽物 祭物 済物"
"さいもと 斉本"
"さいもん 彩紋 祭文 柴門 彩文"
"さいもんふみ 柴門ふみ"
"さいやく 災厄"
"さいやす 最安"
"さいゆ 採油"
"さいゆう 采邑 再遊 彩釉 最尤 西遊"
"さいよ 宰予"
"さいよう 細腰 採用"
"さいらい 再来"
"さいらんけい 採卵鶏"
"さいり 犀利 再履"
"さいりゃく 才略"
"さいりゅう 細流 細粒"
"さいりょう 才量 宰領 裁量 最良"
"さいりょく 才力"
"さいりん 再臨"
"さいるい 催涙"
"さいるいがす 催涙ガス"
"さいるいすぷれー 催涙スプレー"
"さいるいだん 催涙弾"
"さいれい 祭礼"
"さいれつ 鰓裂"
"さいろう 豺狼"
"さいろく 載録 採録 再録"
"さいろん 細論 再論"
"さいわ 再話"
"さいわい 幸 倖 幸い"
"さいわいく 幸区"
"さいわいちょう 幸町"
"さいわいびし 幸菱"
"さいわき 才脇"
"さいわん 才腕"
"さいんいり サイン入り"
"さいんかい サイン会"
"さいんぼん サイン本"
"さう 然"
"さうなしつ サウナ室"
"さうなぶろ サウナ風呂"
"さえ 冴"
"さえき 冴木 差益 佐伯"
"さえぐさ 三枝"
"さえこ 左枝子 冴虎 佐栄子 沙絵子 小枝子 さえ子 冴子"
"さえざえ 冴々 冴え冴え"
"さえじま 冴島"
"さえずり 囀り"
"さえだ 佐枝"
"さえつ 査閲"
"さえど 佐江戸"
"さえば 冴羽"
"さえみ 三絵美 冴美"
"さえもん 左衛門"
"さえもんのかみ 左衛門督"
"さえもんのじょう 左衛門尉"
"さえん 差延 茶園"
"さお 杆 佐保 棹 竿"
"さおう 沙翁"
"さおううおう 左往右往"
"さおだけ 竿竹"
"さおとめ 五月女 早乙女"
"さおぶち 竿縁"
"さおもの 棹物"
"さおり 小緒里 佐織 早織 里織 小織 沙織"
"さおん 差音"
"さか 阪 酒 茶菓 逆 坂"
"さかあがり 逆上がり"
"さかい 境井 酒伊 酒居 左海 阪井 坂井 酒井 界 堺 境"
"さかいがわ 境川"
"さかいし 堺市"
"さかいすじ 堺筋"
"さかいだ 境田"
"さかいだかきえもん 酒井田柿右衛門"
"さかいちょう 堺町"
"さかいで 坂出"
"さかいまさあき 堺正章"
"さかいみなと 境港"
"さかいめ 境目"
"さかいり 酒煎り"
"さかうえ 坂上"
"さかうち 坂内"
"さかうらみ 逆怨み 逆恨み"
"さかえ 榮 栄 栄え"
"さかえだ 栄田"
"さかえだに 栄谷"
"さかえまち 栄町"
"さかお 阪尾"
"さかおとし 逆落し 逆落とし"
"さかかく 坂角"
"さかがみ 逆髪 阪上 坂上"
"さかがめ 酒甕"
"さかがわ 坂川"
"さかき 坂木 賢木 坂城 榊"
"さかきた 坂北"
"さかきばら 榊原"
"さかくら 阪倉 坂倉"
"さかぐせ 酒癖"
"さかぐち 阪口 坂口"
"さかぐら 酒蔵"
"さかげ 逆毛"
"さかこし 坂越"
"さかことば 逆言葉"
"さかさ 逆 逆さ"
"さかさい 逆井"
"さかさま 逆様"
"さかざき 坂崎"
"さかし 賢し"
"さかしお 酒塩 逆潮"
"さかした 阪下 坂下"
"さかしま 逆 倒 逆しま"
"さかしら 賢しら"
"さかしろ 酒代"
"さかずき 柧 觚 盞 盃 杯"
"さかずめ 坂詰"
"さかた 阪田 酒田 坂田"
"さかたに 阪谷"
"さかだい 酒代"
"さかだち 逆立 酒断ち 逆立ち"
"さかだる 酒樽"
"さかづき 盃 杯"
"さかづくり 酒造り"
"さかて 酒手 逆手"
"さかと 坂戸"
"さかとったり 逆とったり"
"さかど 坂戸"
"さかな 肴 魚"
"さかなかけ 魚懸け"
"さかなが 阪長"
"さかなし 坂梨"
"さかなたち 魚達"
"さかなだな 魚店"
"さかなっけ 魚っ気"
"さかなつき 魚突き"
"さかなつり 魚釣 魚釣り"
"さかなで 逆撫で"
"さかなふらい 魚フライ"
"さかなへん 魚偏"
"さかなぼうちょう 魚包丁"
"さかなや 魚屋"
"さかなやそうごろう 魚屋宗五郎"
"さかなりょうり 魚料理"
"さかに 酒煮"
"さかにわ 坂庭"
"さかね 坂根"
"さかの 坂野"
"さかのうえ 坂上"
"さかはぎ 逆剥"
"さかば 酒場"
"さかばた 酒旗"
"さかばやし 酒林"
"さかびき 逆引き"
"さかびたり 酒浸り"
"さかびん 酒瓶"
"さかぶね 酒槽"
"さかべ 酒部 坂部"
"さかほ 逆帆"
"さかほぎ 坂祝"
"さかぼうき 酒箒"
"さかま 坂間"
"さかまきおんせん 逆巻温泉 坂巻温泉"
"さかまち 坂町"
"さかまつげ 逆睫毛"
"さかまんじゅう 酒饅頭"
"さかみず 逆水 酒水"
"さかみち 坂路 坂道"
"さかむけ 逆剥け"
"さかむし 酒蒸 酒蒸し"
"さかむら 坂村"
"さかめ 逆目"
"さかもぎ 逆茂木"
"さかもと 阪元 酒本 坂元 阪本 坂本"
"さかもときゅう 坂本九"
"さかもり 酒盛 酒盛り"
"さかもりうた 酒盛り唄"
"さかや 酒屋"
"さかやき 月代"
"さかゆめ 逆夢"
"さかり 盛 盛り"
"さかわ 坂和 栄和 佐川"
"さかわがわ 酒匂川"
"さかん 差換 主典 佐官 盛ん 茶館 左官"
"さが 嵯峨 佐賀 性"
"さがいこうい 詐害行為"
"さがえ 寒河江"
"さがく 差額"
"さがしかた 探し方"
"さがしもの 捜し物 探し物"
"さがた 嵯峨田"
"さがね 嵯峨根"
"さがの 嵯峨野"
"さがのせき 佐賀関"
"さがみ 相模"
"さがみこ 相模湖"
"さがみはら 相模原"
"さがら 相良 相楽"
"さがり 下がり"
"さがる 下ル"
"さがわ 佐川"
"さがん 左眼 砂岩 左岸"
"さき 早記 碕 嵜 尖 埼 咲 沙貴 早岐 沙樹 早紀 前 左記 崎 先"
"さきいき 先行き"
"さきいと 先糸"
"さきえ 咲恵"
"さきおくり 先送り"
"さきおととい 一昨々日 一昨昨日"
"さきおととし 一昨々年 一昨昨年"
"さきおり 裂織"
"さきがいけん 先買権"
"さきがけ 先掛 先駆け 魁"
"さきがし 先貸し"
"さきがり 先借り"
"さきぎり 先限"
"さきぐあい 咲具合 咲き具合"
"さきぐい 先食い"
"さきこ 沙樹子 佐紀子 咲子"
"さきごう 先号"
"さきごろ 先頃"
"さきさか 向坂"
"さきさま 先様"
"さきざき 先先 先崎 先々"
"さきしましょとう 先島諸島"
"さきぞなえ 先備え"
"さきた 咲田 崎田"
"さきだか 先高"
"さきだって 先達て 先立って"
"さきち 佐吉"
"さきっちょ 先っちょ"
"さきっぽ 先っぽ"
"さきづけ 先付け"
"さきて 先手"
"さきと 崎戸"
"さきどり 先取り"
"さきどりとっけん 先取特権"
"さきに 曩に 前に 先に"
"さきのばし 先延ばし"
"さきのり 先乗 先乗り"
"さきはま 咲浜 崎浜"
"さきばしり 先走り"
"さきばらい 先払 先払い"
"さきばん 先番"
"さきぶれ 先触れ"
"さきほど 先ほど 先程"
"さきぼう 先棒"
"さきぼそり 先細り"
"さきまけ 先負"
"さきまわり 先回り"
"さきみ 咲美"
"さきもの 先物"
"さきものがい 先物買"
"さきもり 防人"
"さきや 崎谷"
"さきやす 先安"
"さきやま 咲山 崎山"
"さきゅう 砂丘"
"さきゆき 先行き"
"さきょう 左京"
"さきよみ 先読 先読み"
"さきわけ 咲分け"
"さきわたし 先渡し"
"さきわれ 先割れ"
"さきわれすぷーん 先割れスプーン"
"さきん 差金 砂金"
"さぎ 詐偽 鷺 詐欺"
"さぎさか 匂坂"
"さぎさわ 鷺沢"
"さぎし サギ師"
"さぎしち 鷺七"
"さぎそう 鷺草"
"さぎちょう 三毬杖 左義長"
"さぎぬま 鷺沼"
"さぎょう さ行 サ行 作業"
"さぎょうい 作業衣"
"さぎょうづくえ 作業机"
"さぎょうみす 作業ミス"
"さぎり 狭霧"
"さく 乍 辟 册 冊 齪 捉 嘖 簀 做 鑿 縒 筴 錯 索 削 筰 炸 柞 酢 窄 咋 昨 搾 槊 朔 佐久 作 柵 策"
"さくい 作意 作為"
"さくいおん 錯イオン"
"さくいん 索引"
"さくえん 錯塩"
"さくおう 策応"
"さくおとこ 作男"
"さくか 朔果 さく果 昨夏"
"さくかんとく 作監督"
"さくが 作画"
"さくがた 作型"
"さくがら 作柄"
"さくがん 鑿岩 削岩"
"さくき 昨季"
"さくぎ 昨木"
"さくぎょう 昨暁"
"さくぎれ 索切"
"さくぐ 索具"
"さくげき 作劇"
"さくげつ 昨月"
"さくげん 溯源 遡源 削減"
"さくこん 昨今"
"さくご 錯語 索語 錯誤"
"さくごえ 柵越え"
"さくさく 嘖々 昨々"
"さくさくかん サクサク感"
"さくさん 酢酸"
"さくざつ 錯雑"
"さくし 索師 柵址 策試 錯視 策士 作詩 作詞"
"さくしーずん 昨シーズン"
"さくしゃ 作者"
"さくしゅ 搾取"
"さくしゅう 昨週 作州 昨秋"
"さくしゅつ 作出"
"さくしゅん 昨春"
"さくしょ 策書 索書"
"さくじ 作事 作字"
"さくじつ 朔日 昨日"
"さくじゅう 搾汁"
"さくじょ 削除"
"さくじょう 作条 索条 柵状"
"さくず 作図"
"さくせい 鑿井 作製 作成"
"さくせき 昨夕"
"さくせつ 錯節 作設"
"さくせん 作戰 作戦"
"さくぜん 索然"
"さくそう 錯綜"
"さくぞう 作蔵"
"さくぞうぶ 作像部"
"さくたい 錯体"
"さくたき 作滝"
"さくたろう 朔太郎"
"さくだい 作題"
"さくだん 炸弾"
"さくちゅう 作中"
"さくちょう 錯聴 作調 昨朝"
"さくつけ 作付け 作付"
"さくづ 作図"
"さくづけ 作付け 作付"
"さくて 作手"
"さくてい 作庭 策定"
"さくてき 索敵"
"さくとう 作刀 作東 昨冬 作陶"
"さくど 作土"
"さくどう 索道 策動"
"さくなみ 作並"
"さくにゅう 搾乳"
"さくねん 昨年"
"さくねんあき 昨年秋"
"さくねんなつ 昨年夏"
"さくねんはる 昨年春"
"さくのべ 作延"
"さくはつ 炸発"
"さくばく 索寞 索莫 索漠"
"さくばん 昨晩"
"さくひこんぜ 昨非今是"
"さくひょう 作表"
"さくひん 作品"
"さくふ 作譜"
"さくふう 朔風 作風"
"さくぶつ 作物"
"さくぶん 作文"
"さくへんきょく 作編曲"
"さくほう 昨報 作法 冊封"
"さくぼう 朔望 策謀"
"さくぼうげつ 朔望月"
"さくま 削磨 作間"
"さくましょうざん 佐久間象山"
"さくみ 作見 朔美"
"さくめ 作目"
"さくめい 錯迷 策命"
"さくもつ 作物"
"さくもん 策問 作文"
"さくや 咲耶 昨夜"
"さくやく 炸薬"
"さくやま 咲山 作山"
"さくゆ 搾油"
"さくゆう 昨夕"
"さくら 櫻 紗倉 砂倉 佐久良 佐倉 桜"
"さくらい 櫻井 桜井"
"さくらいろ 桜色"
"さくらうお 桜魚"
"さくらえ 桜江"
"さくらえび 桜蝦"
"さくらおか 桜丘"
"さくらかわ 桜川"
"さくらがい 桜貝"
"さくらがおか 櫻ヶ丘 桜ケ丘 桜丘 桜ヶ丘"
"さくらがほう 櫻画報"
"さくらがみ 桜紙"
"さくらがわ 桜川"
"さくらぎ 桜樹 桜木"
"さくらぎちょう 櫻木町"
"さくらぐみ 桜組"
"さくらこ 桜子"
"さくらこうじ 桜小路"
"さくらざわ 桜沢"
"さくらしんまち 桜新町"
"さくらじま 桜島"
"さくらじょうすい 桜上水"
"さくらぜんせん 桜前線"
"さくらそう 桜草"
"さくらそうか サクラソウ科"
"さくらそうもく サクラソウ目"
"さくらだ 桜田"
"さくらだい 桜台 桜鯛"
"さくらだもんがいのへん 桜田門外の変"
"さくらぢゃや 桜茶屋"
"さくらづき 桜月"
"さくらづけ 桜漬"
"さくらづつみ 桜堤"
"さくらどおり 桜通"
"さくらなべ 桜鍋"
"さくらなみき 桜並木"
"さくらにく 桜肉"
"さくらのその 桜の園"
"さくらのみや 桜宮"
"さくらば 櫻庭 桜庭"
"さくらばし 桜橋"
"さくらばな 桜花"
"さくらひめぜんでんあけぼのぞうし 桜姫全伝曙草紙"
"さくらふじ 桜富士"
"さくらふぶき 桜吹雪"
"さくらま 桜間"
"さくらまち 桜町"
"さくらまつり 桜祭"
"さくらまんかい 桜満開"
"さくらむし 桜蒸し"
"さくらもち 桜餅"
"さくらもと 桜本"
"さくらもよう 桜模様"
"さくらゆ 桜湯"
"さくらん 錯乱"
"さくらんぼ 桜桃"
"さくらんぼう 桜ん坊 桜桃"
"さくりつ 冊立"
"さくりゃく 策略"
"さくれい 作例"
"さくれつ 錯列 炸裂"
"さくろう 索郎"
"さくわ 索話 作話"
"さぐち 佐口"
"さぐん 鎖群"
"さけ 鮭 酒"
"さけい 左傾"
"さけうりば 酒売場"
"さけかす 酒粕"
"さけかわ 鮭川"
"さけくせ 酒癖"
"さけぐせ 酒癖"
"さけずき 酒好き"
"さけづくり 酒造り"
"さけづけ 酒漬け"
"さけてん 酒店"
"さけに 酒煮"
"さけのみ 酒飲 酒飲み"
"さけびごえ 叫び声"
"さけびたり 酒浸り"
"さけびん 酒瓶"
"さけみ 酒見"
"さけめ 裂目 裂け目"
"さけよい 酒酔い"
"さける 辟"
"さけるい 酒類"
"さけん 差遣"
"さげ 下げ"
"さげあし 下げ足"
"さげあま 下げ尼"
"さげお 下げ緒"
"さげかじ 下げ舵"
"さげがみ 垂髪 下げ髪"
"さげしお 下げ潮"
"さげしぶり 下げ渋り"
"さげすみ 貶み 蔑み"
"さげふだ 下げ札"
"さげもどし 下げ戻し"
"さげん 瑣言 左舷"
"さこ 逧 佐古 迫"
"さこう 鎖港 砂鉱 鎖交 佐甲 酒向 酒匂"
"さこうべん 左顧右眄"
"さこえ 迫江"
"さこく 鎖国"
"さこだ 迫田"
"さこつ 鎖骨"
"さこん 左近"
"さごし 青箭魚"
"さごじょう 沙悟浄"
"さごろも 狭衣"
"ささ 小竹 酒 些々 佐々 篠 笹"
"ささあめ 笹飴"
"ささい 瑣細 些細"
"ささえ 支え 小筒 竹筒"
"ささお 笹尾"
"ささおか 佐佐岡 笹岡"
"ささかまぼこ 笹蒲鉾"
"ささかみ 笹神"
"ささかわ 笹川"
"ささがわ 笹川"
"ささき 笹氣 笹木 佐々木"
"ささぎ 大角豆"
"ささくら 笹倉"
"ささぐり 篠栗"
"ささげ 大角豆 捧げ"
"ささげつつ 捧げ銃"
"ささこ 笹子"
"ささこもち 笹子餅"
"ささざき 笹崎"
"ささざわ 笹沢"
"ささした 笹下"
"ささじま 笹島"
"ささずし 笹寿司"
"ささせ 笹瀬"
"ささたけ 篠竹 笹竹"
"ささたに 笹谷"
"ささだ 笹田"
"ささだんご 笹団子"
"ささつ 査察"
"ささつせん 笹津線"
"ささづか 笹塚"
"ささど 笹戸"
"ささぬま 笹沼"
"ささの 笹野"
"ささのうち 笹之内"
"ささのは 笹の葉"
"ささはら 佐々原 笹原"
"ささぶね 笹舟"
"ささべ 笹部"
"ささべり 笹縁"
"ささまき 笹巻"
"ささみ 笹身"
"ささめ 私語"
"ささめき 私語"
"ささめきごと 私語"
"ささめごと 私語"
"ささめゆき 細雪"
"ささもと 篠本 笹本"
"ささもり 笹森"
"ささや 笹屋 笹谷"
"ささやか 細やか"
"ささやき 囁き"
"ささやま 笹山 篠山"
"ささゆり 笹百合"
"ささら 簓"
"ささりんどう 笹竜胆"
"ささわら 笹原"
"ささわり 障り"
"さざ 佐々"
"さざえ 蠑螺"
"さざえさん サザエさん"
"さざなみ 細波 小波 さざ波 漣"
"さざれ 細"
"さざんか 山茶花"
"さし 刺し 渣滓 左史 左思 砂嘴 沙市"
"さしあい 差し合い"
"さしあし 差脚 差し足"
"さしあたり 差し当り 差し当たり"
"さしあみ 刺し網 刺網"
"さしいれ 差入れ 差入 差し入れ"
"さしうま 差し馬"
"さしえ 插繪 插絵 挿し絵 挿絵"
"さしおさえ 差し押え 差押え 差押 差し押さえ"
"さしかえ 差替 差し替え"
"さしかけ 差掛け 指し掛け"
"さしがさ 差し傘"
"さしがね 指矩 指金 差し金 差金"
"さしき 鎖式 挿木 佐敷 挿し木"
"さしきず 刺し傷"
"さしぐし 挿し櫛"
"さしげ 差し毛"
"さしこ 刺子 刺し子"
"さしこみ 差込み 差し込み"
"さしさわり 差障り 差し障り"
"さししょうぎ 指し将棋 指将棋"
"さしず 指図"
"さしずめ 差詰め 差し詰め"
"さしたる 然したる"
"さしだ 指田"
"さしだしにん 差出人"
"さしちがえ 差し違え"
"さしつかえ 差支え 差し支え"
"さして 差し手 指し手"
"さしで 差し出"
"さしでん 左氏伝"
"さしとめ 差止め 差止 差し止め"
"さしどめ 差止め"
"さしなわ 差し縄"
"さしにない 差し担い"
"さしね さし値 指し値 指値"
"さしの 指野"
"さしば 差歯 差し歯"
"さしばし 刺し箸"
"さしばな 挿花"
"さしひき 差引き 差し引き 差引"
"さしほ 挿し穂 挿穂"
"さしま 猿島"
"さしみ 差し身 刺身"
"さしみず 差水 差し水"
"さしみぼうちょう 刺し身包丁"
"さしむかい 差向い"
"さしめ 挿し芽"
"さしもどし 差戻し 差し戻し"
"さしもの 指物"
"さしゅ 叉手 詐取"
"さしゅう 佐州 査収"
"さしゅうごう 差集合"
"さしゆうご 左支右吾"
"さしょう 瑣小 左相 些少 詐称 査証"
"さしょうべん 左少弁"
"さしりょう 差し料 差料"
"さしわたし 差渡し"
"さしんしつ 左心室"
"さしんぼう 左心房"
"さじ 佐冶 佐治 瑣事 些事 匙"
"さじかげん 匙加減"
"さじき 桟敷"
"さじま 佐島"
"さじゅう 茶頭"
"さじゅつ 詐術"
"さじょう 叉状 鎖錠 砂状 砂上 鎖状"
"さじょうしょう 左丞相"
"さじょうど 砂壌土"
"さじん 茶人 砂塵"
"さす 扠首 砂州"
"さすが 遉 流石"
"さすけ 佐助"
"さすだ 佐須田"
"さすまた 指叉 刺股"
"さすらい 流離"
"さすれば 然爲れば"
"さず 左図"
"さずかりもの 授かり物"
"させ 佐瀬"
"させい 嗄声"
"させき 砂石 沙石"
"させつ 左折"
"させぼ 佐世保"
"させん 鎖線 左遷"
"させんけい 左線形"
"させんせい 左旋性"
"さぜん 作善"
"さそ 誘"
"さそいみず 誘い水"
"さそう 笹生 佐宗"
"さそく 左側"
"さそり 蝎 蠍"
"さそりおとこ 蠍男"
"さそりざ 蠍座"
"さそん 差損"
"さぞ 嘸"
"さぞかし 嘸かし"
"さぞや 嘸や"
"さた 沙多 佐屋 佐多 沙汰"
"さたけ 佐武 佐竹"
"さたみさき 佐多岬"
"さたやみ 沙汰止み"
"さたろう 佐太郎"
"さたん 嗟歎 左袒 嗟嘆 左端"
"さだ 偵 禎 佐田 貞 定"
"さだあき 禎章 貞明"
"さだい 佐大"
"さだいえ 定家"
"さだいしょう 左大将"
"さだいじん 左大臣"
"さだいべん 左大弁"
"さだえ 貞江"
"さだお 貞郎 定男 貞男 定雄 定夫 貞雄 貞夫"
"さだおか 定岡"
"さだおき 貞煕"
"さだか 定か"
"さだかた 貞方 定方"
"さだかつ 定勝"
"さだき 貞木 定樹 貞樹"
"さだきち 定吉"
"さだこ 貞子"
"さだつぐ 貞次"
"さだとし 定利 貞俊"
"さだのぶ 定伸"
"さだはる 貞治"
"さだひこ 定彦 貞彦"
"さだひろ 定宏 貞広"
"さだまつ 定松 貞松"
"さだまりごと 定まり事"
"さだみさき 佐田岬"
"さだみち 貞通"
"さだみつ 貞光"
"さだめ 宿命 定め"
"さだめがき 定書"
"さだめし 定めし"
"さだやす 定康"
"さだゆき 貞行"
"さだよし 貞芳"
"さだん 左段"
"さち 佐知 倖 幸"
"さちえ 佐智恵"
"さちお 佐千男 幸夫 幸雄"
"さちこ 佐知子 早智子 佐智子 祥子 幸子"
"さちゅう 砂中 沙中 左註 左注"
"さちゅうかん 左中間"
"さちゅうべん 左中弁"
"さちよ 祥代"
"さっ 早"
"さっか 擦過 作歌 昨夏 作家"
"さっかーじょう サッカー場"
"さっかーせんしゅ サッカー選手"
"さっかーぶ サッカー部"
"さっかぎょ 溯河魚"
"さっかく 錯角 錯覚"
"さっかしょう 擦過傷"
"さっかん 錯簡 作監"
"さっき 数奇 先刻 昨季 殺気"
"さっきゅう 遡及 早急"
"さっきょう 作凶 作況"
"さっきょく 作曲"
"さっきん 殺菌"
"さっく 作句"
"さっこう 作興"
"さっこん 昨今"
"さっさ 佐々"
"さっさじっちく 佐々十竹"
"さっし 刷子 察し 冊子"
"さっしど サッシ戸"
"さっしまど サッシ窓"
"さっしゅう 薩州"
"さっしょう 殺生 殺傷"
"さっしん 殺身 刷新"
"さっすい 撒水"
"さっすう 冊数"
"さっせい 殺青 殺生"
"さっせつ 殺節"
"さっそう 颯爽"
"さっそく 早速"
"さっそざい 殺鼠剤"
"さっち 察知"
"さっちも 三進も"
"さっちゅう 殺虫"
"さっちょう 薩長"
"さって 幸手"
"さっと 颯と"
"さっとう 殺到"
"さっとに さっと煮"
"さっぱ 拶双魚 撒播"
"さっぱりかん さっぱり感"
"さっぱん 刷版"
"さっぷ 撒布"
"さっぷうけい 殺風景"
"さっぽう 殺法"
"さっぽろ 札幌"
"さっぽろみなみこうこう 札幌南高校"
"さっぽん 刷本"
"さつ 册 撒 薩 拶 撮 紮 扎 箚 刹 颯 擦 察 殺 刷 冊 札"
"さつい 殺意"
"さついれ 札入れ"
"さつう 茶通"
"さつうばこ 茶通箱"
"さつえい 撮影"
"さつえいせんそう 薩英戦争"
"さつがい 殺害"
"さつき 早月 佐月 五月 皐 皐月"
"さつきあめ 五月雨"
"さつきがおか 五月丘"
"さつきしょうば 皐月賞馬"
"さつきだ 五月田"
"さつきばれ 五月晴 五月晴れ"
"さつきやみ 五月闇"
"さつげんがっき 擦弦楽器"
"さつこう 殺光"
"さつしょぶん 殺処分"
"さつじん 殺陣 殺人"
"さつすう 冊数"
"さつぞう 撮像"
"さつたば 札束"
"さつなん 薩南"
"さつぬません 札沼線"
"さつばつ 殺伐"
"さつびら 札片"
"さつま 薩摩"
"さつまいも 甘藷 さつま芋 薩摩芋"
"さつまのかみ 薩摩守"
"さつまやき 薩摩焼"
"さつめ 冊目"
"さつもん 擦文"
"さつゆう 殺熊"
"さつよう 撮要"
"さつりく 殺戮"
"さづか 佐塚"
"さて 偖 扨"
"さてい 査定"
"さておき 扨措き"
"さてつ 蹉跌 砂鉄"
"さてん 茶店"
"さてんじ サテン地"
"さで 叉手"
"さでん 佐伝"
"さと 聰 理 聡 智 郷 里"
"さとい 里居"
"さといも 里芋"
"さといもか サトイモ科"
"さといももく サトイモ目"
"さとう 左道 佐東 左党 茶湯 差等 佐藤 砂糖"
"さとういり 砂糖入"
"さとうきび 砂糖黍"
"さとうづけ 砂糖漬"
"さとうにしき 佐藤錦"
"さとうみず 砂糖水"
"さとえ さと江"
"さとおさ 里長"
"さとおや 里親"
"さとかた 里方"
"さとがえり 里帰り"
"さとこ 砂登子 沙都子 佐登子 郷子 理子 里子 智子 聡子"
"さとことば 里言葉"
"さとご 里子"
"さとごころ 里心"
"さとざくら 里桜"
"さとし 覚志 智嗣 理史 覺 里志 叡 聡史 悟史 聡志 智志 智史 聰 訓 諭 慧 覚 賢 悟 敏 恵 哲 聖 智 知 理 聡"
"さとしょう 里庄"
"さとだ 里田"
"さとなか 里中"
"さとひろ 理洋"
"さとふか 里深"
"さとぼう 里坊"
"さとみ 聡巳 沙都美 悟美 恵規 聡美 里見 智美 里美"
"さとみつ 理満"
"さとむら 里村"
"さとやま 里山"
"さとゆき 里雪"
"さとり 悟り"
"さとる 逹 覺 了 覚 聡 哲 暁 智 悟 知 達"
"さど 砂土 佐渡"
"さどう 茶頭 佐道 左道 差動 茶道 作動"
"さどおけさ 佐渡おけさ"
"さどがしま 佐渡島"
"さどがや 佐渡谷"
"さどく 査読"
"さどわら 佐土原"
"さない 左内 佐内"
"さなえ 差波江 早植 早生 早苗"
"さなか 最中"
"さながら 宛ら"
"さなき 鐸"
"さなぎ 佐薙 蛹"
"さなぎゆ 蛹油"
"さなげ 猿投"
"さなごうち 佐那河内"
"さなだ 真田"
"さなだひも 真田紐"
"さなだむし 真田虫"
"さなみ 佐奈美"
"さなる 佐鳴"
"さぬき 佐貫 讃岐"
"さぬま 砂沼"
"さね 札 核 実"
"さねあつ 実篤"
"さねちか 実近"
"さねとう 實藤 実藤"
"さねとみ 実美"
"さねはる 実治"
"さねもりものがたり 実盛物語"
"さの 佐野"
"さのう 佐納 砂嚢 左脳"
"さのかわ 佐野川"
"さのさか 佐野坂"
"さのさぶし さのさ節"
"さは 左派"
"さはい 差配"
"さはち 皿鉢"
"さはら 薩哈剌 佐原"
"さはん 茶飯"
"さはんじ 茶飯事"
"さば 鯆 生飯 佐波 鯖"
"さばえ 五月蠅 鯖江"
"さばおり 鯖折り"
"さばかん 鯖缶"
"さばき 捌き 裁き 捌"
"さばきやく 捌役"
"さばく 佐幕 沙漠 砂漠"
"さばぐも 鯖雲"
"さばし 佐橋"
"さばずし 鯖寿司 鯖鮨"
"さばひい 虱目魚"
"さばぶし 鯖節"
"さひょうえ 左兵衛"
"さひょうえのかみ 左兵衛督"
"さひょうえのじょう 左兵衛尉"
"さび 皺 鏥 銹 寂 錆"
"さびいろ 錆色"
"さびえ 錆絵"
"さびしがりや 淋しがり屋 寂しがり屋"
"さびしろ 淋代"
"さびどめ 錆び止め さび止め 錆止め"
"さびねず 錆鼠"
"さびょう 詐病"
"さびれ 寂れ"
"さぶ 佐武"
"さぶしょ 三仏生"
"さぶまりんとっきょ サブマリン特許"
"さぶらい 侍"
"さぶろう 三朗 三郎"
"さぶん 差分"
"さへん サ変 左辺"
"さべつ 差別"
"さべん 左弁"
"さほ 沙穂 左保 佐保"
"さほう 差法 左方 作法"
"さほこ 佐保子"
"さほど 然程"
"さぼう 詐謀 茶房 砂防"
"さぼうだむ 砂防ダム"
"さぼてん 覇王樹 仙人掌"
"さぼてんもく サボテン目"
"さぽーとじょうほう サポート情報"
"さま 樣 様"
"さまかた 様方"
"さまかたち 様形"
"さまがわり 様変り 様変わり"
"さまさま 様様 様々"
"さまざま 様様 様々"
"さまたげ 妨げ"
"さまつ 些末 瑣末"
"さまづけ 様付け"
"さまに 様似"
"さまのかみ 左馬頭"
"さまのすけ 左馬助"
"さまほん 様本"
"さみ 沙弥 三味"
"さみしがりや 寂しがり屋 淋しがり屋"
"さみず 三水"
"さみだれ 五月雨"
"さみだれぐも 五月雨雲"
"さむ 作務 寒"
"さむえ 作務衣"
"さむかぜ 寒風"
"さむかわ 寒川"
"さむがり 寒がり"
"さむがわ 寒川"
"さむけ 寒気"
"さむげたん 参鶏湯"
"さむさ 寒さ"
"さむざむ 寒々"
"さむぞら 寒空"
"さむよ 寒夜"
"さむらい 士 侍"
"さめ 雨 鮫"
"さめいし 鮫石"
"さめかわ 鮫川"
"さめがい 醒ケ井"
"さめがわ 沙皮 鮫皮"
"さめこもん 鮫小紋"
"さめしま 鮫島"
"さめじま 鮫島"
"さめす 鮫州"
"さめはだ 鮫膚 鮫肌"
"さも 然も"
"さもじ 左文字 杓文字"
"さもん 砂紋 沙門 左門 査問"
"さもんじ 左文字"
"さや 匣鉢 佐屋 紗綾 沙耶 莢 鞘"
"さやあて 鞘当 鞘当て"
"さやいんげん 莢隠元"
"さやえんどう 莢豌豆"
"さやか 沙也加"
"さやく 鎖鑰"
"さやこ 彩也子 清子"
"さやどう 鞘堂"
"さやま 茶山 佐山 狭山"
"さやまめ 莢豆"
"さやよせ 鞘寄せ"
"さゆ 素湯 白湯"
"さゆう ←→ 左右"
"さゆうぎゃく 左右逆"
"さゆうたん 左右端"
"さゆうどう 左右動"
"さゆり 沙由里 早百合 小百合"
"さよ 小夜"
"さよう 然様 左葉 左用 佐用 左様 作用"
"さようなら 左様なら"
"さよく 左翼"
"さよこ 紗世子 沙夜子 佐代子 小夜子"
"さよならがち サヨナラ勝ち"
"さよならまけ サヨナラ負け"
"さより 細魚"
"さら 沙羅 更 皿"
"さらあらい 皿洗い"
"さらい 復習 渫い 浚い 作礼 杷"
"さらいげつ 再来月"
"さらいしゅう 再来週"
"さらいねん 再来年"
"さらう 攫"
"さらうどん 皿うどん 皿饂飩"
"さらえ 杷"
"さらかず 皿数"
"さらがた 皿型"
"さらきん サラ金"
"さらこばち 皿小鉢"
"さらさ 更紗"
"さらさら 更々"
"さらし 晒し 曝し 晒"
"さらしあん 晒し餡"
"さらしくび 晒し首"
"さらしこ 晒し粉"
"さらしな 更科 更級"
"さらしなこ 更科粉"
"さらしや 晒屋"
"さらじゅ 娑羅樹 沙羅樹"
"さらす 晒"
"さらせにあもく サラセニア目"
"さらそうじゅ 娑羅双樹"
"さらだあぶら サラダ油"
"さらだな サラダ菜"
"さらだゆ サラダ油"
"さらち 更地"
"さらなる 更なる"
"さらに 更に"
"さらぬ 然らぬ"
"さらば 然らば"
"さらばち 皿鉢"
"さらべつ 更別"
"さらまわし 皿回し"
"さらまんだ 沙羅曼蛇"
"さらやしき 皿屋敷"
"さらやま 皿山"
"さらゆ 新湯"
"さり 紗理"
"さりぎわ 去り際"
"さりじょう 去り状"
"さりちるさん サリチル酸"
"さりとて 然りとて"
"さりょう 査領 茶寮"
"さる 去る 沙流 申 猿"
"さるお 猿尾"
"さるかい 猿飼"
"さるがき 桾"
"さるがく 猿学 申楽 猿楽"
"さるぎ 猿木"
"さるくら 猿倉"
"さるぐつわ 猿轡"
"さるぐんだん 猿軍団"
"さるげ 猿毛"
"さるげんとどくさか サルゲントドクサ科"
"さること 然ること"
"さるしばい 猿芝居"
"さるすべり 百日紅"
"さるた 猿田"
"さるたひこ 猿田彦"
"さるぢえ 猿知恵"
"さるとび 猿飛"
"さるどし 申年"
"さるのこしかけ 胡孫眼"
"さるはし 猿橋"
"さるばし 猿橋"
"さるふぁざい サルファ剤"
"さるふつ 猿払"
"さるまた 猿股"
"さるまね 猿真似"
"さるまわし 猿回し"
"さるめんかじゃ 猿面冠者"
"さるめんかんじゃ 猿面冠者"
"さるや 猿谷"
"さるやま 猿山"
"さるわか 猿若"
"さるわたり 猿渡"
"されい 茶礼"
"されき 砂礫"
"されこうべ 髑髏"
"さろま 佐呂間"
"さわ 佐波 佐和 茶話 澤 沢"
"さわい 沢井 澤井"
"さわいずみ 沢泉"
"さわいり 沢入"
"さわうち 澤内 沢内"
"さわおか 澤岡"
"さわがに 沢蟹"
"さわき 澤木 沢木"
"さわぎ 騒ぎ"
"さわぎうた 騒ぎ唄"
"さわくり 沢栗"
"さわぐち 沢口"
"さわこ 佐和子"
"さわざき 沢崎 澤崎"
"さわすぎ 沢杉"
"さわた 佐和田"
"さわたり 沢渡"
"さわだ 澤多 沢田 澤田"
"さわち 皿鉢"
"さわとうげ 沢峠"
"さわの 沢野"
"さわのぼり 沢登 澤登 沢登り"
"さわはた 澤幡"
"さわべ 沢辺"
"さわまつ 沢松"
"さわむら 澤村 沢村"
"さわもと 澤本"
"さわや 澤谷 沢弥"
"さわやか 爽やか"
"さわやなぎ 沢柳"
"さわやま 沢山"
"さわら 早良 佐原 椹 鰆"
"さわらび 早蕨"
"さわり 障り 触り"
"さわわたり 沢渡"
"さわん 左腕"
"さん 3 ３ 餐 傘 斬 芟 爨 潸 汕 嶄 蒜 蠶 蚕 繖 撒 棧 戔 簒 纂 燦 粲 跚 刪 珊 衫 杉 彡 驂 參 慘 惨 鑚 鑽 纉 攅 讚 贊 讃 賛 参 散 桟 算 三 山 産 酸"
"さんあい 三愛"
"さんい 産衣 三位 賛意"
"さんいち 三一"
"さんいつ 散佚 散逸"
"さんいん 産院 参院 山陰"
"さんう 山雨"
"さんえ 三衣 三会 三慧"
"さんえい 三栄"
"さんえいっぱつ 三衣一鉢"
"さんえき 三駅 酸液"
"さんえん 三遠 山塩"
"さんえんしゅぎ 三猿主義"
"さんおう 三桜"
"さんおんとう 三温糖"
"さんか 山窩 山河 山下 山火 惨禍 讃歌 賛歌 産科 傘下 酸化 参加"
"さんかい 三回 三階 散開 参会 山塊 山海 散会"
"さんかいめ ３回目"
"さんかえん 酸化焔"
"さんかきんたい 山河襟帯"
"さんかぎんでんち 酸化銀電池"
"さんかく 贊畫 ∵ ∴ ▼ ▲ ▽ △ 参画 三角"
"さんかくいた 三角板"
"さんかくきん 三角巾"
"さんかくこーなー 三角コーナー"
"さんかくす 三角州"
"さんかくとう 三角塔"
"さんかくふらすこ 三角フラスコ"
"さんかくまど 三角窓"
"さんかしゅう 山家集"
"さんかた 三方"
"さんかてつ 酸化鉄"
"さんかどう 酸化銅"
"さんかなまり 酸化鉛"
"さんかば 参加馬"
"さんかまく 酸化膜"
"さんかめいが 三化螟蛾"
"さんかん 三澣 三浣 散官 算勘 参看 三竿 三管 三韓 三関 三冠 三巻 山間 参観"
"さんかんがく 産官学"
"さんかんけい 三環系"
"さんかんしおん 三寒四温"
"さんかんば 三冠馬"
"さんが 参賀 山河"
"さんがい 惨害 三界 三階"
"さんがいぶし 三階節"
"さんがく 散楽 産額 算額 産学 山岳"
"さんがくたび 山岳旅"
"さんがくりん 山岳林"
"さんがつ 弥生 ３月 三月"
"さんがにち 三箇日 三ヶ日 三が日"
"さんがね 三ケ根"
"さんがねさん 三ヶ根山"
"さんがわら 桟瓦"
"さんがん 三観 三眼 三願"
"さんき 三機 山気 算機"
"さんきち 三吉"
"さんきゃく 山脚 三脚"
"さんきゅう 山九 三級 産休"
"さんきょ 山居"
"さんきょう 三協 三強 三共 三峡 山峡"
"さんきん 三禁"
"さんきんこうたい 参勤交代"
"さんぎ 算木 参議"
"さんぎいん 参議院"
"さんぎょう 鑽仰 三業 蚕業 三行 産業"
"さんぎょうすぱい 産業スパイ"
"さんく 三区 惨苦 産駒"
"さんぐ 蚕具"
"さんぐう 三宮 参宮"
"さんぐん 三軍"
"さんけ 産気 三家"
"さんけい 三計 散形 算計 三景 参詣 山系 産経"
"さんけいえん 三渓園"
"さんけいかじょ 繖形花序"
"さんけいみち 参詣道"
"さんけた 三桁"
"さんけつ 三傑 酸欠"
"さんけつしょう 酸血症"
"さんけん 三研 三権 産研 三軒 散見"
"さんげ 山下 散華"
"さんげき 惨劇"
"さんげさんげ 懺悔懺悔"
"さんげたん 參鶏湯"
"さんげつ 山月"
"さんげん 山弦 三弦 三絃 三元"
"さんげんじゃや 三軒茶屋"
"さんげんぢゃや 三軒茶屋"
"さんこ 三顧 三鈷"
"さんこう 鑽孔 三后 三考 三興 三晃 三江 三高 三項 参向 三皇 散光 三光 山行 参考"
"さんこうざい 散孔材"
"さんこうすいちょう 山高水長"
"さんこうちょう 三光鳥"
"さんこく 惨酷"
"さんこつ 散骨"
"さんこのれい 三顧の礼"
"さんご 珊瑚 産後"
"さんごう 三劫 三綱 参號 三業 山号 三合 三郷 三号"
"さんごく 三石 三国"
"さんごくし 三國志 三国志"
"さんごしょう サンゴ礁 珊瑚礁"
"さんごじゅ 珊瑚樹"
"さんさ 三叉"
"さんさい 三歳 三菜 三彩 三才 山菜"
"さんさく 散策"
"さんさつ 三冊"
"さんさん 珊々 三三 燦々 三々"
"さんさんくど 三三九度"
"さんさんごご 三三五五 三々五々"
"さんさんななびょうし 三三七拍子"
"さんざい 散剤 散財 散在"
"さんざし 山査子"
"さんざん 惨々 散散 三山 散々"
"さんし 三史 産仔 三思 三誌 三子 蚕糸 三枝"
"さんしぇん 三弦"
"さんしき 三色 算式"
"さんしすいめい 山紫水明"
"さんした 三下"
"さんしつ 散失 産室 蚕室"
"さんしゃ 三舎 山車 三社 三者"
"さんしゃく 参酌"
"さんしゃしょうけい 三斜晶系"
"さんしゅ 三種"
"さんしゅう 三周 纂輯 山州 参州 讃州 三舟 三州 参集"
"さんしゅうしゃ 三修社"
"さんしゅつ 産出 算出"
"さんしゅつふくよう ３出複葉 三出複葉"
"さんしゅのじんぎ 三種の神器"
"さんしょ 山椒"
"さんしょう 酸漿 三焦 三賞 三省 三唱 山椒 三章 参照"
"さんしょううお 鯢 山椒魚"
"さんしょく 蚕食 三食 三色"
"さんしょくすみれ 三色菫"
"さんしろういけ 三四郎池"
"さんしん 参進 三伸 三身 三審 参審 三進 三信 三線 三振"
"さんしんだつしゅ 三振奪取"
"さんしんびる 三信ビル"
"さんじ 三時 ３次 三次 産児 讃辞 賛辞 参事 惨事"
"さんじく 三軸"
"さんじゃく 三尺"
"さんじゃくだま 三尺玉"
"さんじゃまつり 三社祭"
"さんじゅ 傘寿"
"さんじゅう 卅 三十 三重"
"さんじゅうさんげんどう 三十三間堂"
"さんじゅうのとう 三重塔"
"さんじゅうろっけい 三十六計"
"さんじゅつ 算術"
"さんじゅん 相俊"
"さんじょ 刪除 産所 三女 賛助"
"さんじょう 三乗 三條 三条 山上 惨状 参上"
"さんじょうき 三畳紀"
"さんじょく 産褥"
"さんじん 山人"
"さんすい 撒水 散水 山水"
"さんすいせん 散水栓"
"さんすう 算数"
"さんすうかじゅぎょう 算数科授業"
"さんすくみ 三竦み"
"さんすくりっとご サンスクリット語"
"さんすんだま 三寸玉"
"さんず 三途"
"さんずい 三水"
"さんずのかわ 三途の川"
"さんずん 三寸"
"さんずんふりつ 三寸不律"
"さんせ 三施"
"さんせい 惨悽 惨凄 三精 参政 三聖 三省 三星 産生 山西 三世 酸性 賛成"
"さんせいう 酸性雨"
"さんせいこ 酸性湖"
"さんせいむ 酸性霧"
"さんせき 山積"
"さんせく 三セク"
"さんせつこん 三節棍"
"さんせん 三遷 山川 三選 三線 参戦"
"さんせんべん 三尖弁"
"さんぜ 三世"
"さんぜん 三千 参禅 燦然 産前"
"さんぜんいん 三千院"
"さんぜんじょう 三千丈"
"さんそ O 酸素"
"さんそう 惨愴 酸愴 散層 三索 山僧 三層 三相 山荘"
"さんそうけん 産総研"
"さんそぼんべ 酸素ボンベ"
"さんそん 散村 山村"
"さんぞう 三蔵"
"さんぞく 山賊"
"さんぞくなべ 山賊鍋"
"さんぞん 三尊"
"さんたい 三台 算体 三諦 三態 三体"
"さんたいせい 三台星"
"さんたく 三択"
"さんたん 三歎 三嘆 山丹 讃歎 讃嘆 惨澹 賛嘆 惨憺"
"さんたんか 山丹花"
"さんたんとう 三炭糖"
"さんだ 三田"
"さんだい 産大 三題 三台 三代 三大 散大 参内"
"さんだいばなし 三題噺"
"さんだつ 簒奪"
"さんだゆう 三太夫"
"さんだん 霰弾 三段 散弾 算段"
"さんだんがまえ 三段構え"
"さんだんきょう 三段峡"
"さんだんげり 三段蹴り"
"さんだんじゅう 散弾銃"
"さんだんとび 三段跳び 三段跳"
"さんだんばら 三段腹"
"さんち 三値 山地 産地"
"さんちゃ 三軒茶屋"
"さんちゃく 三着 参着"
"さんちゃほう 三家和"
"さんちゅう 山中"
"さんちゅうごえ 山中越"
"さんちょう 三鳥 山頂"
"さんちょく 産直"
"さんつう 産痛 三通"
"さんづくり 彡旁"
"さんづけ さん付け"
"さんてい 算程 刪定 算定"
"さんてつ 鑽鉄 三鉄"
"さんてん … 散点 山巓 三点"
"さんてんせいやく 参天製薬"
"さんてんりーだー …… … 三点リーダー"
"さんでん 参殿 三伝 散田"
"さんと 三斗 三都"
"さんとう 算当 山刀 三東 三頭 三党 三等 山東 三島"
"さんとうか 山頭火"
"さんとうきょうでん 山東京伝"
"さんとうさい 山東菜"
"さんとく 三徳"
"さんとのふ 三都の賦"
"さんど 酸度 三度"
"さんどう 参堂 三道 散瞳 産道 山道 参道 賛同"
"さんどがさ 三度笠"
"さんどく 三毒"
"さんどぬり 三度塗"
"さんどまめ 三度豆"
"さんない 三内 山内"
"さんなん 山南 三男"
"さんにゅう 酸乳 算入 参入"
"さんにん ３人 三人"
"さんにんたび 三人旅"
"さんにんむすめ 三人娘"
"さんねん ３年 三年"
"さんねんざか 三年坂"
"さんのう 山王"
"さんのうまつり 山王祭"
"さんのつぎ 三の次"
"さんのつづみ 三の鼓"
"さんのへ 三戸"
"さんのまる 三の丸"
"さんのみや 三の宮 三宮"
"さんはい 山廃"
"さんば 散飯 生飯 三羽 三馬 産婆"
"さんばい 三杯 三倍"
"さんばいぞうじょうしゅ 三倍増醸酒"
"さんばがらす 三羽烏"
"さんばがわ 三波川"
"さんばし 棧橋 桟橋"
"さんばそう 三番叟"
"さんばば 三婆"
"さんばん 三番"
"さんぱ 撒播 散播 三派"
"さんぱい 贊拜 三拝 酸敗 産廃 惨敗 参拝"
"さんぱく 三拍 三泊"
"さんぱくがん 三白眼"
"さんぱつ 三発 散発 散髪"
"さんび 酸鼻 讃美 賛美"
"さんびき 三匹"
"さんびゃく 三百"
"さんびゃくにんまち 三百人町"
"さんぴ 賛否"
"さんぴょう 散票"
"さんぴん 三一"
"さんふじんか 産婦人科"
"さんふらんしすこ 桑港"
"さんぶ 三分 三部 山武"
"さんぶつ 讃仏 産物"
"さんぶん 三分 散文"
"さんぶんし 散文詩"
"さんぷ 算譜 参府 撒布 産婦 散布"
"さんぷう 杉風"
"さんぷく 三伏 山腹"
"さんぷくつい 三幅対"
"さんぷるばん サンプル盤"
"さんぷん 三分"
"さんべつ 産別"
"さんべんしゅ 三鞭酒"
"さんぺい 三平 散兵"
"さんぺき 三碧"
"さんぼう 三宝 三方 参謀"
"さんぼうかん 三宝柑"
"さんぼく 山北 三木"
"さんぼん ≡ 三本"
"さんぼんあし 三本足"
"さんぼんぎ 三本木"
"さんぼんじめ 三本締め"
"さんぼんすぎ 三本杉"
"さんぼんだて 三本建"
"さんぼんばしら 三本柱"
"さんぼんまつ 三本松"
"さんぼんゆび 三本指"
"さんぽ 刪補 三歩 散歩"
"さんぽう 纂法 山砲 三方 三宝 算法"
"さんぽういん 三宝院"
"さんぽみち 散歩道"
"さんま 秋刀魚"
"さんまい 産米 三枚 三昧"
"さんまきめ 三巻目"
"さんまん 三万 散漫"
"さんみ 三位 酸味"
"さんみつ 三密"
"さんみゃく 三藐 山脈"
"さんみょう 三明"
"さんみんしゅぎ 三民主義"
"さんめい 賛明 三名 山名"
"さんめん 三面"
"さんめんきょう 三面鏡"
"さんめんろっぴ 三面六臂"
"さんもうさく 三毛作"
"さんもく 三目"
"さんもん 三門 三文 山門"
"さんもんおぺら 三文オペラ"
"さんもんきょう 三門峡"
"さんや 三夜 山谷 山野"
"さんやく 纂訳 散薬 山薬 三役"
"さんやそう 山野草"
"さんゆ 産油"
"さんゆうかん 三遊間"
"さんゆうてい 三遊亭"
"さんよ 三余 贊譽 參與 参与"
"さんよう 三様 算用 山容 三洋 山陽"
"さんようしょうかい 三陽商会"
"さんようちゅう 三葉虫"
"さんらーたん 酸辣湯"
"さんらい 三礼"
"さんらく 惨落 三楽"
"さんらん 燦爛 産卵 散乱"
"さんらんけい 産卵鶏"
"さんらんこう 散乱光"
"さんらんばこ 産卵箱"
"さんり 三里"
"さんりく 三陸"
"さんりつ 簒立"
"さんりづか 三里塚"
"さんりゃく 三略"
"さんりゅう 山流 三流"
"さんりゅうしゅ 散粒種"
"さんりょう 算料 三稜 山陵 山稜 産量"
"さんりょうきょう 三稜鏡"
"さんりん 山林 三輪"
"さんりんぼう 三隣亡"
"さんる 三流"
"さんるい 三塁"
"さんれい 山霊 山嶺"
"さんれいごしん 三令五申"
"さんれつ 惨烈 三裂 参列"
"さんれん 三連"
"さんれんぷく 三連複"
"さんろう 参籠"
"さんろうた 三朗太"
"さんろく 山麓"
"さんわ 三話 三羽 三和"
"さんわり 三割"
"ざ 藏 蔵 左 坐 挫 座"
"ざーさい 搾菜"
"ざい 濟 劑 戝 才 済 西 斉 座位 剤 材 罪 在 財"
"ざいあく 罪悪"
"ざいい 在位"
"ざいえい 在英"
"ざいえき 在役"
"ざいおう 在欧"
"ざいか 在荷 罪過 罪科 財貨"
"ざいかい 在会 財界"
"ざいかた 在方"
"ざいかん 在館 在官 在監 在韓"
"ざいがい 在外"
"ざいがく 在学"
"ざいきゅう 罪咎"
"ざいきょう 在郷 在京"
"ざいきん 在勤"
"ざいぎょう 罪業"
"ざいく 細工"
"ざいけ 在家"
"ざいけい 財経 財形"
"ざいけいほうていしゅぎ 罪刑法定主義"
"ざいげん 財源"
"ざいこ 財庫 在庫"
"ざいこう 在広 在校"
"ざいこく 在国"
"ざいごう 在郷 罪業"
"ざいさん 財産"
"ざいしつ 罪質 在室 材質"
"ざいしゃ 在社"
"ざいしゅう 罪囚"
"ざいしゅく 在宿"
"ざいしょ 在所"
"ざいしょう 罪証 罪障"
"ざいしょく 在職"
"ざいじゅう 在住"
"ざいじょう 罪状"
"ざいす 座椅子"
"ざいせ 財施 在世"
"ざいせい 在世 財政"
"ざいせいなん 財政難"
"ざいせき 在昔 罪跡 罪責 材積 在席 在籍"
"ざいせん 在仙"
"ざいぜん 財前"
"ざいぞく 在俗"
"ざいたい 罪体"
"ざいたく 在宅"
"ざいたくけあ 在宅ケア"
"ざいたくびじねす 在宅ビジネス"
"ざいたくわーく 在宅ワーク"
"ざいだん 財団"
"ざいちゅう 在中"
"ざいちょう 在庁"
"ざいつ 財津"
"ざいてい 在廷"
"ざいてん 在天"
"ざいとう 在島 財投"
"ざいとうさい 財投債"
"ざいに 在荷"
"ざいにち 在日"
"ざいにほんだいかんみんこくみんだん 在日本大韓民国民団"
"ざいにほんちょうせんじんそうれんごうかい 在日本朝鮮人総連合会"
"ざいにん 罪人 在任"
"ざいのう 財嚢"
"ざいはく 財帛"
"ざいば 在場"
"ざいばつ 財閥"
"ざいふ 在府"
"ざいふつ 在仏"
"ざいぶつ 財物"
"ざいべい 在米"
"ざいほう 罪報 財宝"
"ざいま 在間"
"ざいむ 財務"
"ざいめい 在銘 罪名"
"ざいめつ 罪滅"
"ざいもく 材木"
"ざいもくざかいがん 材木座海岸"
"ざいもくや 材木谷"
"ざいもつ 財物"
"ざいや 在野"
"ざいよく 財欲"
"ざいらい 在来"
"ざいらんようぼうし 剤乱用防止"
"ざいりゅう 在留"
"ざいりょう 在寮 材料"
"ざいりょく 財力"
"ざいん 座員"
"ざう 座右"
"ざえ 才"
"ざえもん 左衛門"
"ざお 棹 竿"
"ざおう 蔵王"
"ざか 坂 座下"
"ざかり 盛り"
"ざが 坐臥 座臥"
"ざがく 座学"
"ざがしら 座頭"
"ざがね 座金"
"ざき 咲き 嵜 崎"
"ざきょう 座興"
"ざぎょう ざ行 ザ行 座業"
"ざくぎり ざく切り"
"ざくつ 座屈"
"ざくら 桜"
"ざくろ 石榴 榴 柘榴"
"ざくろいし 石榴石 柘榴石"
"ざけ 酒"
"ざこ 座古 雑喉 雑魚"
"ざこう 座高"
"ざこうじ 座光寺"
"ざこつ 座骨 挫骨 坐骨"
"ざこね 雑寝 雑魚寝"
"ざさ 笹 坐作 座作"
"ざざい 坐剤"
"ざし 差し 坐視 座視"
"ざしき 座敷"
"ざしきろう 座敷牢"
"ざしきわらし 座敷童"
"ざしつ 座室"
"ざしゅ 座種"
"ざしょ 座所"
"ざしょう 坐礁 挫傷 座礁"
"ざしょく 坐食 座食"
"ざす 座主"
"ざせき 座席"
"ざせつ 挫折"
"ざぜん 座前 坐禅 座禅"
"ざそう 座葬"
"ざぞう 座像"
"ざた 沙汰"
"ざたく 座卓"
"ざだん 座談"
"ざちゅう 座中"
"ざちょう 座長"
"ざっか 雑貨"
"ざっかん 雑感"
"ざっき 雑記"
"ざっきゅう 雑給"
"ざっきょ 雑居"
"ざっきょびる 雑居ビル"
"ざっきん 雑菌"
"ざっけん 雑件"
"ざっこう 雑考"
"ざっこく 雑穀"
"ざっこん 雑婚"
"ざっさん 雑纂"
"ざっし 雑誌"
"ざっしゅ 雑修 雑酒 雑種"
"ざっしゅうにゅう 雑収入"
"ざっしょ 雑書"
"ざっしょく 雑色 雑食"
"ざっせつ 雑説 雑節"
"ざっそう 雑想 雑草"
"ざっそく 雑則"
"ざっそん 雑損"
"ざっそんしつ 雑損失"
"ざった 雑多"
"ざっちょ 雑著"
"ざっとう 雑沓 雑踏"
"ざっぱ 雑破 雑把"
"ざっぱい 雑輩 雑俳"
"ざっぱく 雑駁"
"ざっぴ 雑費"
"ざっぴつ 雑筆"
"ざっぽう 雑報"
"ざつ 雜 襍 雑"
"ざつえい 雑詠"
"ざつえき 雑益 雑役"
"ざつおん 雑音"
"ざつかぶ 雑株"
"ざつがく 雑学"
"ざつき 座付"
"ざつきゅうよ 雑給与"
"ざつぎ 雑技"
"ざつぎょ 雑魚"
"ざつぎょう 雑業"
"ざつげい 雑芸"
"ざつごん 雑言"
"ざつさぎょう 雑作業"
"ざつしゅうにゅう 雑収入"
"ざつしょとく 雑所得"
"ざつじ 雑事"
"ざつぜん 雑然"
"ざつそんしつ 雑損失"
"ざつだい 雑題"
"ざつだん 雑談"
"ざつねん 雑念"
"ざつのう 雑嚢"
"ざつはいすい 雑排水"
"ざつぶつ 雑物"
"ざつぶん 雑文"
"ざつぼく 雑木"
"ざつみんとう 雑民党"
"ざつむ 雑務"
"ざつよう 雑用"
"ざつろく 雑録"
"ざつわ 雑話"
"ざてんし 座天使"
"ざとう 座頭"
"ざとうくじら 座頭鯨"
"ざね 実"
"ざはい 座配"
"ざはき 座掃き"
"ざひょう 座標"
"ざぶ 座部"
"ざぶとん 座蒲団 座布団"
"ざぶろう 三郎"
"ざぼうき 座箒"
"ざま 座間"
"ざまみ 座間見"
"ざめ 鮫"
"ざめつ 挫滅"
"ざめん 座面"
"ざもち 座持ち"
"ざもと 座元"
"ざやく 坐薬 座薬"
"ざゆう 座右"
"ざゆうのめい 座右の銘"
"ざよく 座浴"
"ざら 皿"
"ざらがみ ざら紙"
"ざらば ざら場"
"ざらめ 粗目"
"ざらめゆき 粗目雪"
"ざり 座利"
"ざりがに 蜊蛄"
"ざる 猿 笊"
"ざるご 笊碁"
"ざるそば 笊蕎麦"
"ざれ 戯れ"
"ざれい 坐礼 座礼"
"ざれうた 戯歌 戯れ歌"
"ざれごと 戯事 戯れ言 戯言"
"ざれつ 座列 坐列"
"ざわ 澤 沢"
"ざん 慘 殘 竄 懴 懺 巉 讒 鏨 慚 慙 嶄 塹 暫 斬 参 惨 算 山 残"
"ざんあつけい 残圧計"
"ざんい 残遺"
"ざんえい 残映"
"ざんかい 慚悔"
"ざんかん 斬姦 残寒 斬奸"
"ざんがい 斬刈 残害 残骸"
"ざんがく 残額"
"ざんがん 巉巌"
"ざんき 慙悸 残機 残基 慙愧 慚愧"
"ざんきゅう 残丘 斬級"
"ざんきょう 残響"
"ざんきりょう 残気量"
"ざんきん 残金"
"ざんぎゃく 残虐"
"ざんぎょう 残業"
"ざんぎょうでい 残業デイ"
"ざんぎり 散切り"
"ざんぎりあたま 散切り頭"
"ざんくろう 斬九郎"
"ざんけい 斬刑"
"ざんけつ 残闕 残欠"
"ざんけん 残件"
"ざんげ 懺悔"
"ざんげつ 残月"
"ざんげん 讒言"
"ざんこう 残肴 残香 残光"
"ざんこく 残酷"
"ざんこん 残痕"
"ざんごう 塹壕"
"ざんさ 残差 残渣"
"ざんさい 斬衰 残滓 残債"
"ざんさつ 斬殺 惨殺"
"ざんさへいほうわ 残差平方和"
"ざんざい 斬罪"
"ざんし 慙死 惨死 残滓"
"ざんしゃ 讒者"
"ざんしゅ 斬首"
"ざんしょ 残暑"
"ざんしょう 残照"
"ざんしん 嶄新 残心 斬新"
"ざんじ 暫時"
"ざんじつろく 残日録"
"ざんじんざんば 斬人斬馬"
"ざんすう 残数"
"ざんせき 残席"
"ざんせつ 残雪"
"ざんぜつ 嶄絶"
"ざんぜん 嶄然"
"ざんそ 讒訴"
"ざんそん 残存"
"ざんぞう 残像"
"ざんぞん 残存"
"ざんだか 残高"
"ざんち 残置"
"ざんてい 暫定"
"ざんてき 残敵"
"ざんてつけん 斬鉄剣"
"ざんとう 残党"
"ざんとうがり 残党狩り"
"ざんにょう 残尿"
"ざんにん 惨忍 残忍"
"ざんねん 残年 残念"
"ざんばつ 斬伐"
"ざんぱい 惨敗"
"ざんぱつ 斬髪"
"ざんぱん 残飯"
"ざんぴん 残品"
"ざんぶ 残部"
"ざんぶつ 残物"
"ざんぶん 残分"
"ざんぺん 残片"
"ざんぼう 残亡 讒謗"
"ざんぽん 槧本 残本"
"ざんまい 三昧"
"ざんむ 残夢 残務"
"ざんよ 殘餘 残余"
"ざんりゅう 残留"
"ざんりょう 残料 残量"
"ざんるい 残塁"
"し 岐 知 只 柿 時 自 示 次 衰 芝 之 此 姉 刺 仔 匙 茨 梓 駛 釶 齎 豕 肆 耜 翅 痣 滓 摯 揣 恃 徙 妛 咫 侈 漬 賜 脂 紫 孜 弑 試 鷙 贄 耆 嗜 啻 偲 思 謚 諡 茲 絲 梔 巵 卮 竢 俟 厶 嗤 蚩 錙 輜 緇 獅 篩 笶 矢 泗 駟 貲 觜 嘴 呰 髭 厮 廝 斯 舐 帋 砥 祗 祇 祀 屎 巳 尸 屍 趾 沚 阯 址 祉 弛 施 幟 熾 姿 粢 瓷 恣 咨 資 諮 祠 覗 笥 飼 嗣 伺 肢 枝 支 志 仕 旨 指 齒 歯 雌 糸 使 止 至 視 始 四 子 私 史 誌 紙 司 氏 市 士 師 詞 詩 死"
"しーあは シーア派"
"しーがた Ｃ型"
"しーくきょう シーク教"
"しーぐあず 西瓜子"
"しーげんご Ｃ言語"
"しーずんちゅう シーズン中"
"しーた Θ θ"
"しーたは θ波"
"しーどけん シード権"
"しーどこう シード校"
"しーるざい シール材"
"しあ 四阿"
"しあい 四愛 至愛 私愛 仕合 試合"
"しあいうん 試合運"
"しあがり 仕上り 仕上がり"
"しあく 四悪"
"しあくしゅ 四悪趣"
"しあげ 仕上 仕上げ"
"しあさって 明明後日 明々後日"
"しあつ 指圧"
"しあわせ 幸福 仕合せ 倖せ 幸せ"
"しあわせぶとり 幸せ太り"
"しあわせよし 仕合はせ吉し"
"しあん 私案 試案 思案"
"しあんか シアン化"
"しあんなげくび 思案投首"
"しい 尿 肆意 詩意 四維 紫衣 示威 四位 私意 四囲 椎 思惟 恣意"
"しいえき 志井駅"
"しいお 椎尾"
"しいか 詩歌"
"しいがもと 椎本"
"しいき 篩域 椎木 市域"
"しいぎゃく 弑逆"
"しいく 飼育"
"しいざかな 強肴"
"しいじ 椎路"
"しいそさん 尸位素餐"
"しいた Θ θ"
"しいたけ 椎茸"
"しいだ 椎田 志井田"
"しいち 視位置"
"しいて 強いて"
"しいな 椎菜 秕 粃 椎名"
"しいなまこと 椎名誠"
"しいなりんぞう 椎名麟三"
"しいの 椎野"
"しいのき 椎の木"
"しいば 椎葉"
"しいら 粃"
"しいる 罔"
"しいれ 仕入 仕入れ"
"しいれね 仕入値 仕入れ値"
"しいん 市隠 指印 私印 子音 死因 試飲"
"しう 糸雨 四有 死有 紫芋"
"しう゛ぁ 湿婆"
"しうち 仕打 仕打ち"
"しうと 舅"
"しうとめ 姑"
"しうら 市浦"
"しうん 紫雲"
"しうんてん 試運転"
"しぇるへんすう シェル変数"
"しえ 四衛 紫衣"
"しえい 私営 市営"
"しえき 私益 使役"
"しえしえ 謝謝"
"しえん 試演 紫煙 私怨 支援"
"しえんかたんそ 四塩化炭素"
"しお 鹽 入 史生 志雄 汐 潮 塩"
"しおあい 潮合"
"しおあじ 塩味"
"しおい 塩井"
"しおいがい 塩以外"
"しおいり 塩入"
"しおう 雌黄 四王"
"しおうち 塩内"
"しおうてん 四王天"
"しおかげん 塩加減"
"しおかぜ 汐風 潮風"
"しおから 塩辛"
"しおかり 塩狩"
"しおかわ 塩川"
"しおがま 塩竃 塩竈 塩釜"
"しおき 仕置き 仕置"
"しおぎ 塩木"
"しおくみ 潮汲み 汐汲み 汐汲"
"しおくり 仕送り"
"しおけ 塩気"
"しおけむり 潮煙"
"しおこさじ 塩小匙"
"しおこしょう 塩コショウ 塩胡椒"
"しおこんぶ 塩昆布"
"しおさい 潮騒"
"しおさば 塩鯖"
"しおさめ 爲納め 仕納め"
"しおざかい 潮境"
"しおざかな 塩魚"
"しおざき 潮崎 塩崎"
"しおざけ 塩鮭"
"しおざわ 塩澤 塩沢"
"しおじ 塩路 汐路 潮路"
"しおじゃけ 塩鮭"
"しおじり 塩尻"
"しおじる 塩汁 潮汁"
"しおず 塩津"
"しおずか 塩塚"
"しおせ 塩瀬"
"しおせんべい 塩煎餅"
"しおた 潮田 塩田"
"しおたに 塩谷"
"しおだ 潮田 塩田"
"しおだし 塩出し"
"しおだち 塩断ち"
"しおだまり 潮溜まり"
"しおち 潮地"
"しおつぐ 塩次"
"しおづけ 塩漬け 塩漬"
"しおづる 塩鶴"
"しおで 塩出"
"しおどき 潮時"
"しおどめ 汐留"
"しおなり 潮鳴り"
"しおに 塩煮"
"しおぬき 塩抜き"
"しおの 塩野"
"しおのえ 塩江"
"しおのぎ 塩野義"
"しおのみさき 潮岬"
"しおのみち 塩の道"
"しおのや 塩谷"
"しおはま 塩浜"
"しおはら 塩原"
"しおばら 塩原"
"しおひ 潮干"
"しおひがり 潮干狩 潮干狩り"
"しおふき 潮吹き"
"しおぶた 塩豚"
"しおぶね 塩船"
"しおぶろ 塩風呂"
"しおべつ 塩別"
"しおま 潮間"
"しおまねき 望潮 潮招き"
"しおまめ 塩豆"
"しおみ 潮見 塩見"
"しおみず 潮水 塩水"
"しおみだい 汐見台"
"しおむら 塩村"
"しおもと 塩本"
"しおもの 塩物"
"しおもみ 塩揉み"
"しおや 塩屋 塩谷"
"しおやき 塩焼き 塩焼"
"しおやけ 潮焼け"
"しおゆ 潮湯 塩湯"
"しおらーめん 塩ラーメン"
"しおり 詩央里 枝折 撓 栞"
"しおりど 枝折戸"
"しおん 至恩 師恩 歯音 私怨 紫苑 子音"
"しか 詩歌 知客 四科 餝 爾 飾 然 翅果 賜暇 詞華 紙価 詩家 子夏 志賀 私家 雌花 史家 市価 歯科 鹿"
"しかい 此界 尸解 死灰 四界 志怪 斯界 四海 死海 市会 視界 司会"
"しかえし 仕返し"
"しかおい 鹿追"
"しかかり 仕掛 仕掛り"
"しかく ◇ ◆ □ ■ 詩客 視角 刺客 死角 四角 視覚 資格"
"しかくきゅう 資格給"
"しかくごうま 四角号碼"
"しかくすい 四角錐"
"しかくぼ 鹿窪"
"しかけ 仕懸 仕掛 仕掛け"
"しかご 市俄古"
"しかさわぐち 鹿沢口"
"しかざわ 鹿沢"
"しかざん 死火山"
"しかし 私窩子 併し 然し"
"しかして 然して 而して"
"しかしゅう 詞花集"
"しかしょ 四ヶ所"
"しかじか 然然 云云 然々 云々"
"しかじゅう 死荷重"
"しかず 若かず 如かず"
"しかた 志方 仕方"
"しかたに 鹿谷"
"しかっけい 四角形"
"しかっしょく 紫褐色"
"しかつ 師勝 死活"
"しかと 聢 聢と 確と"
"しかど 鹿戸"
"しかの 鹿野"
"しかのしま 志賀島"
"しかのみならず 加之"
"しかばね 屍"
"しかべ 鹿部"
"しかま 志鎌 色麻 飾磨"
"しかまた 鹿又"
"しかまち 鹿町"
"しかみ 爾見 鹿見"
"しかめっつら しかめっ面 顰めっ面"
"しかめつら 顰め面"
"しかめん 死仮面"
"しかも 然も 而も"
"しからずんば 然らずんば"
"しからば 然らば"
"しかり 呵り 叱り 尓 然り"
"しかりべつ 然別"
"しかりべつこ 然別湖"
"しかるべき 然る可き"
"しかれども 然れども"
"しかれば 然れば"
"しかん 糸管 士関 詩巻 枝幹 篩管 師管 史官 祠官 屍姦 子癇 使館 支管 止観 視感 支間 私感 歯冠 視姦 仕官 歯間 史観 弛緩 士官"
"しかんけん 資環研"
"しかんしきかごうぶつ 脂環式化合物"
"しかんたざ 只管打坐"
"しが 齒牙 四賀 歯牙 志賀 滋賀"
"しがい 屍骸 紫外 死骸 市外 市街"
"しがいこう 紫外光"
"しがき 志垣"
"しがく 斯学 試楽 志学 詩学 歯学 史学 私学"
"しがごえ 志賀越"
"しがさと 滋賀里"
"しがしゅう 詩画集"
"しがじく 詩画軸"
"しがっか 歯学科"
"しがつ 卯月 ４月 四月"
"しがなおや 志賀直哉"
"しがらき 紫香楽 信楽"
"しがらきのみやあと 紫香楽宮跡"
"しがらきやき 信楽焼"
"しがらみ 柵"
"しがん 史眼 此岸 志願"
"しき 市気 惻 鋪 拭 敷 織 色 識 志岐 磯城 志木 私記 屍鬼 志気 史記 子規 紙器 死期 始期 士気 指揮 四季 式"
"しきい 閾 敷居"
"しきいき 識域 識閾"
"しきいし 舗石 敷石"
"しきいた 敷板"
"しきいち しきい値 閾値"
"しきうつし 敷写し"
"しきか 色価"
"しきかい 色界"
"しきかいぞうど 色解像度"
"しきかく 色覚"
"しきかん 色感"
"しきがく 式楽"
"しきがし 式菓子"
"しきがみ 識神 敷紙 式神"
"しきがわ 敷皮"
"しきがわら 敷き瓦 甃 敷瓦"
"しききん 敷金"
"しきけ 式家"
"しきけん 識見"
"しきこう 式項"
"しきこうぞう 式構造"
"しきご 識語"
"しきさい 四季菜 色彩"
"しきさしんごう 色差信号"
"しきさんば 式三番"
"しきし 色紙"
"しきしだい 式次第"
"しきしま 磯城島 敷島"
"しきしゃ 識者"
"しきしゅ 色種"
"しきしゅうさ 色収差"
"しきしん 色神"
"しきじ 式次 式辞 識字"
"しきじかん 職事官"
"しきじたい 式自体"
"しきじつ 式日"
"しきじゃく 色弱"
"しきじょう 色情 式場"
"しきじん 識神 式神"
"しきすう 色数"
"しきせ 為着せ 四季施 仕着せ"
"しきせん 敷銭"
"しきそ 式素 色素"
"しきそう 色相"
"しきそうかん 色相環"
"しきそくぜくう 色即是空"
"しきそせいかんぴしょう 色素性乾皮症"
"しきた 敷田"
"しきたま 敷玉"
"しきたり 爲來り 仕來り 仕来り"
"しきだ 敷田"
"しきだい 式台"
"しきち 敷地"
"しきちゅう 式中"
"しきちょう 色聴 色調"
"しきてい 式亭"
"しきてき 式的"
"しきてん 式典"
"しきど 色度"
"しきどう 色道"
"しきないしゃ 式内社"
"しきにん 識認"
"しきね 敷寝 式根"
"しきねん 式年"
"しきばん 色板"
"しきばんごう 式番号"
"しきひょう 色票"
"しきふ 敷布"
"しきふく 式服"
"しきふくはんそうは 色副搬送波"
"しきふね 式船"
"しきぶ 式部"
"しきぶとん 敷き布団 敷布団"
"しきぶん 式文"
"しきへんけい 式変形"
"しきべつ 識別"
"しきほう 式法 色法 四季報"
"しきぼう 式帽 指揮棒"
"しきま 色魔"
"しきみ 櫁 樒"
"しきみか シキミ科"
"しきみもどきか シキミモドキ科"
"しきめ 式女"
"しきめい 色名"
"しきもう 色盲"
"しきもく 式目"
"しきもの 敷き物 敷物"
"しきもりいのすけ 式守伊之助"
"しきゃく 刺客 支脚"
"しきやみ 頻闇"
"しきゅう 死球 四球 至急 子宮 支給"
"しきゅうがん 子宮ガン 子宮がん 子宮癌"
"しきゅうけいかん 子宮頸管"
"しきゅうしき 始球式"
"しきゅうたい 糸球体"
"しきゅうたいのう 糸球体嚢"
"しきゆう 色釉"
"しきょ 死去"
"しきょう 至境 詩興 詩境 示教 試供 詩経 司教 市況"
"しきょうい 市教委"
"しきょく 四極 詩曲 支局"
"しきよく 色欲"
"しきり 陣 頻 頻り 仕切り"
"しきりかべ 仕切壁 仕切り壁"
"しきりきん 仕切金"
"しきりしょ 仕切書"
"しきりとびら 仕切扉"
"しきりに 頻"
"しきりねだん 仕切値段"
"しきりばいばい 仕切売買"
"しきりょう 識量 式量 敷料"
"しきりょく 識力"
"しきろう 識浪"
"しきわら 敷藁"
"しきん 試金 死菌 賜金 紫金 至近 資金"
"しきんあつめ 資金集め"
"しきんぐり 資金繰り"
"しきんじょう 紫禁城"
"しきんだん 至近彈 至近弾"
"しきんなん 資金難"
"しきんまえわたし 資金前渡"
"しぎ 信貴 私議 指技 仕儀 思議 鷸 鴫 市議"
"しぎこ 鴫子"
"しぎの 鴫野"
"しぎゃく 弑逆 嗜虐"
"しぎやき 鴫焼き"
"しぎょ 仔魚"
"しぎょう 施行 詩業 斯業 紙業 士業 仕業 執行 施業 始業"
"しぎょく 紫玉"
"しぎょくえん 紫玉苑"
"しぎん 歯齦 市銀 詩吟"
"しく 珠玖 四苦 死苦 詩句 市区"
"しくうかん 視空間"
"しくかつよう シク活用"
"しくきょう シク教"
"しくつ 試掘"
"しくはちがい 四衢八街"
"しくみ 仕組 仕組み"
"しくんし 士君子"
"しぐさ 仕種 仕草"
"しぐま Σ σ"
"しぐれ 時雨"
"しぐん 市郡"
"しけ 師家 時化"
"しけい 歯茎 司計 支系 紙型 詩形 詩型 私刑 市警 死刑"
"しけいしゅう 死刑囚"
"しけつ 止血"
"しけん 四間 私権 私見 試験"
"しけんかんべいびー 試験管ベイビー"
"しげ 楙 卯 滋 繁 恵 茂 成 重"
"しげあき 繁明 成章 重昭 重明"
"しげい 重井 至芸"
"しげえだ 重枝"
"しげお 恵雄 惠雄 繁生 滋男 滋生 滋雄 成雄 滋夫 茂生 成夫 繁夫 重男 繁男 重夫 茂夫 繁雄 茂男 重雄 茂雄"
"しげかず 繁一 茂和 重一"
"しげかつ 重勝"
"しげがき 茂垣"
"しげき 枝隙 茂喜 滋樹 重樹 繁樹 茂樹 詩劇 史劇 刺戟 刺激"
"しげきいき 刺激閾"
"しげく 繁く"
"しげこ シゲ子 滋子 茂子"
"しげさだ 繁定"
"しげさと 重里"
"しげし 茂志"
"しげしげ 繁繁 繁々"
"しげじ 茂司"
"しげぞう 茂三"
"しげた 重田"
"しげたか 重高 重隆"
"しげたけ 重武"
"しげつぐ 重継"
"しげとし 恵俊 成俊"
"しげとも 成伴"
"しげなが 重永"
"しげなり 重成"
"しげの 滋野 重野"
"しげのぶ 滋延 茂伸 重信"
"しげのり 卯典 繁徳 茂典 繁則 茂則 重則 重徳"
"しげはら 重原"
"しげはる 重治"
"しげひこ 茂彦 重彦"
"しげひろ 繁弘 重博 重宏 重弘 茂弘"
"しげふみ 重文"
"しげまさ 茂昌"
"しげまつ 重松"
"しげみ 茂実 成美 茂美 茂見 繁み 茂み"
"しげみち 茂道"
"しげみつ 重光"
"しげむら 重村"
"しげもり 繁盛 重森"
"しげや 茂哉"
"しげやす 成康"
"しげやま 繁山 茂山"
"しげゆき 滋之 繁行 繁之 茂行 重行 茂之"
"しげよし 誠良 重義"
"しげり 成里"
"しげる 楙 繁 滋 茂"
"しげん 死言 始源 始原 至言 資源"
"しげんえねるぎーちょう 資源エネルギー庁"
"しげんかん 始原環"
"しげんごみ 資源ゴミ"
"しげんすう 四元数"
"しこ 四庫 指呼 四股 醜 鬼"
"しこう 篩孔 市郊 視紅 至幸 四光 私行 支考 詩稿 伺候 私好 私考 市交 紙工 歯垢 至高 嗜好 試行 志向 指向 施工 施行 思考"
"しこうか 指甲花"
"しこうして 而して"
"しこく 市國 紫黒 四国"
"しこたん 色丹"
"しこたんとう 色丹島"
"しこつ 死骨 歯骨 趾骨 篩骨 肢骨 指骨"
"しこつおきな 醜つ翁"
"しこつこ 支笏湖"
"しこつとうやこくりつこうえん 支笏洞爺国立公園"
"しこな 醜名 四股名"
"しこのみたて 醜の御楯"
"しこみ 仕込み"
"しこみづえ 仕込み杖"
"しこめ 醜女"
"しこり 痼り 痼 凝り 凝"
"しころ 鍜 錣 錏"
"しこん 私恨 詩魂 紫金 紫根 士魂 紫紺 歯根"
"しご 識語 詩語 私語 死語 死後"
"しごう 詩豪 紫合 諡号"
"しごき 扱き"
"しごぎ 子午儀"
"しごく 司獄 至極"
"しごころ 詩心"
"しごせん 子午線"
"しごと 仕事"
"しごとうた 仕事唄"
"しごとうん 仕事運"
"しごときゅう 仕事給"
"しごとさがし 仕事探し"
"しごとざん 仕事算"
"しごとだかばらい 仕事高払い"
"しごとづくえ 仕事机"
"しごとばこ 仕事箱"
"しごとぶり 仕事ぶり"
"しごめん 子午面"
"しさ 示差 視差 示唆"
"しさい 詩才 仔細 子細 市債 司祭"
"しさいぼう 篩細胞 刺細胞 視細胞"
"しさく 詩作 思索 試作 施策"
"しさつ 刺殺 視察"
"しさつおん 歯擦音"
"しさん 四三 私産 四散 試算 資産"
"しさんじかい 市参事会"
"しざ 視座"
"しざい 詩材 資財 死罪 私財 資材"
"しざわ 志沢"
"しざん 死産 試算"
"しざんけつが 屍山血河"
"しし 孜孜 尿 猪 獅 貎 肉 宍 祠祀 史詩 孜々 子思 支子 私史 詩史 師子 師資 嗣子 死屍 詩誌 志士 四肢 獅子"
"ししいでん 紫宸殿"
"ししうち 猪内"
"ししおどし 鹿威し"
"ししき 始式 司式"
"ししきゅう 四死球"
"ししく 獅子吼"
"ししくい 宍喰"
"ししそんそん 子々孫々"
"ししつ 支質 歯質 私室 紙質 脂質 資質"
"ししづか 宍塚"
"ししとう 獅子唐"
"ししど 宍戸"
"ししばな 獅子鼻"
"ししまい 獅子舞"
"ししむら 臠 肉叢"
"ししゃ 視射 四捨 詩社 試射 試写 使者 支社 死者"
"ししゃく 子爵"
"ししゃざい 止瀉剤"
"ししゃのしょ 死者の書"
"ししゃも 柳葉魚"
"ししゅ 錙銖 四趣 詩酒 四衆 詩趣 旨趣 旨酒 四種 死守"
"ししゅう 刺しゅう 志州 屍臭 四周 死臭 刺繍 詩集"
"ししゅうえん 歯周炎"
"ししゅうき 思秋期"
"ししゅうびょう 歯周病"
"ししゅうへん 市周辺"
"ししゅく 四宿 止宿 私淑"
"ししゅつ 支出"
"ししゅんき 思春期"
"ししょ 死所 私書 四書 詩書 支署 史書 司書 支所"
"ししょう 至小 師承 嗤笑 指掌 四生 私娼 詞章 詩抄 刺傷 視床 市章 死傷 支障 師匠"
"ししょうくつ 私娼窟"
"ししょうじ 指小辞"
"ししょく 紙燭 嗜食 試食"
"ししょしょうしょ 私署証書"
"ししょばこ 私書箱"
"ししよう 試使用"
"ししん 使臣 四診 詩神 指診 至心 詩心 私心 視診 私信 指針"
"ししんけい 歯神経 視神経"
"ししんせい 始新世"
"ししんでん 紫宸殿"
"ししんもーど 私信モード"
"しじ 指似 死児 指事 四時 榻 師事 私事 指示 支持"
"しじく 詩軸 視軸"
"しじつ 子実 史実"
"しじつがん 資治通鑑"
"しじぼう 指示棒"
"しじま 四十万 黙 静寂"
"しじみ 蜆"
"しじみがい 蜆貝"
"しじみじる シジミ汁 しじみ汁 蜆汁"
"しじみちょう 蜆蝶"
"しじゃく 枝雀"
"しじゅ 紫綬"
"しじゅう 止住 四獣 四重 四十 始終"
"しじゅうかた 四十肩"
"しじゅうから 四十雀"
"しじゅうくにち 四十九日"
"しじゅうしちし 四十七士"
"しじゅうしょう 四重唱"
"しじゅうはって 四十八手"
"しじゅく 私塾"
"しじゅつ 四術 師術 施術"
"しじゅん 示準 咨詢 至純 諮詢"
"しじゅんせつ 四旬節"
"しじょ 子女"
"しじょう 施錠 至情 矢状 歯状 四條 四条 支城 市上 糸状 私情 詩情 紙上 誌上 至上 試乗 史上 市場"
"しじょうきょう 私情協"
"しじょうなわて 四條畷 四条畷"
"しじょうのあい 至上の愛"
"しじょうのしっぱい 市場の失敗"
"しじょうりすく 市場リスク"
"しじょうれい 市条例"
"しじん 資人 至人 士人 四神 私人 詩人"
"しすい 市水 酒々井 泗水 止水"
"しすう 紙数 指数"
"しすてむか システム化"
"しすてむかいはつ システム開発"
"しすてむかんり システム管理"
"しすてむこうがく システム工学"
"しすてむしょうがい システム障害"
"しすてむせっけい システム設計"
"しすてむてちょう システム手帳"
"しすてむりろん システム理論"
"しず 志津 靜 静"
"しずい 雌蕊 歯髄"
"しずえ 志津恵 静枝 静江 下枝"
"しずお 靜生 鎮雄 静男 静夫 静雄"
"しずおか 靜岡 静岡"
"しずか 靜か 静か 閑か 静佳 静香 静"
"しずかごぜん 静御前"
"しずがたけ 賤ヶ岳"
"しずぎん 静銀"
"しずく 滴 雫"
"しずくいし 雫石"
"しずけさ 静けさ"
"しずこ 志津子 静子"
"しずごころ 静心"
"しずしず 静々"
"しずたに 閑谷"
"しずだい 静大"
"しずない 静内"
"しずのめ 賤の女"
"しずのや 賤の屋"
"しずみうお 沈み魚"
"しずめ 鎮め 沈め"
"しずや 靜谷 静谷"
"しずりだい 静理大"
"しずる 静流"
"しずわ 後輪"
"しせい 志誠 私生 氏姓 資性 詩聖 至聖 雌性 四声 私製 至誠 市勢 死生 施政 刺青 市制 市政 市井 姿勢"
"しせいかん 司政官"
"しせいしき 示性式"
"しせいだい 始生代"
"しせいどう 資生堂"
"しせいはだ 脂性肌"
"しせき 枝跡 咫尺 史籍 史蹟 歯石 史跡"
"しせつ 士節 師説 詩節 私説 使節 私設 施設"
"しせん 詩箋 私撰 死戦 私戦 私選 脂腺 詩仙 死線 支線 四川 視線"
"しぜい 市税"
"しぜん 至善 自然"
"しぜんこう 自然光"
"しぜんしんろん 自然神論"
"しぜんそう 自然葬"
"しそ 紫蘇 始祖"
"しそう 祀竈 祀竃 私送 指嗾 詩僧 詩草 使嗾 視奏 師僧 宍粟 詩想 志操 死相 歯槽 試奏 試走 思想"
"しそうのうろう 歯槽膿漏"
"しそうのじゆう 思想の自由"
"しそか シソ科"
"しそく 脂燭 紙燭 四足 四則 子息"
"しそちょう 始祖鳥"
"しそつ 士卒"
"しそまき 紫蘇巻"
"しそもく シソ目"
"しそん 至尊 子孫"
"しぞう 私蔵 死蔵"
"しぞく 士族 氏族"
"した 舖 舐 舍 ↓ 簧 舌 下"
"したあご 下顎"
"したあじ 下味"
"したあらい 下洗い"
"したい 死體 姿体 詩体 四諦 死胎 屍体 姿態 肢体 死体"
"したいあん 施耐庵"
"したいふ 士大夫"
"したうけ 下請 下請け"
"したうち 舌打 舌打ち"
"したえ 下絵"
"したえだ 下枝"
"したえのぐ 下絵の具"
"したおび 下帯"
"したか 志鷹"
"したかた 下方"
"したがき 下書 下書き"
"したがって 従って"
"したがり 下刈り"
"したがわ 下側"
"したきりすずめ 舌切り雀"
"したぎ 下着"
"したぎすがた 下着姿"
"したく 私宅 仕度 支度"
"したくさ 下草"
"したくちびる 下唇"
"したぐつ 襪"
"したぐみ 下組み"
"したぐら 下鞍"
"したけんぶん 下検分"
"したげいこ 下稽古"
"したごころ 下心"
"したごしらえ 下ごしらえ 下拵え"
"したごろも 下衣"
"したさき 舌先"
"したさんかく 下三角"
"したざわり 舌触り"
"したし 親し"
"したしい 親"
"したしく 親しく"
"したしごと 下仕事"
"したしょく 下職"
"したしらべ 下調 下調べ"
"したじ 下地"
"したじき 下敷き 下敷"
"したじゅんび 下準備"
"したず 下図"
"したそうだん 下相談"
"したぞめ 下染め"
"したたか 健か 強か"
"したため 認め"
"したたらず 舌足らず"
"しただ 下田"
"しただい 舌代"
"したったらず 舌っ足らず"
"したっぱ 下っぱ 下端 下っ端"
"したっぱら 下っ腹"
"したつ 示達"
"したつき 下付き"
"したつけ 下付"
"したつづみ 舌鼓"
"したつゆ 下露"
"したづかい 舌使い"
"したづつみ 舌鼓"
"したづみ 下積み"
"したて 仕立 仕立て 下手"
"したてん ．"
"したで 下手"
"したどり 下取 下取り"
"したなげ 下投げ"
"したなめずり 舌舐めずり"
"したに 下荷"
"したぬり 下塗 下塗り"
"したね 下値"
"したの 下野"
"したのね 舌の根"
"したはら 下腹"
"したはんぶん 下半分"
"したば 下葉 下端"
"したばえ 下生え 下生"
"したばかま 下袴"
"したばき 下履 下穿き 下履き"
"したばたらき 下働き"
"したばなし 下話"
"したばり 下張り"
"したひも 下紐"
"したび 下樋 下火"
"したほうこう 下方向"
"したまえ 下前"
"したまえば 下前歯"
"したまち 下町"
"したみ 下身 下見"
"したみいた 下見板"
"したみず 下水"
"したみち 下道"
"したむき 下向き"
"しため 下目"
"したや 下屋 下矢 ↓ 下谷"
"したやく 下訳 下役"
"したやしき 下屋敷"
"したやじるし 下矢印 ↓"
"したゆで 下茹で"
"したよみ 下読み"
"したら 設楽"
"したりがお したり顔"
"したん 枝端 肢端 始端 紫檀"
"しだ 齒朶 羊齒 歯朶 信太 志太 志田 羊歯 試打"
"しだい 詩題 至大 四大 私大 次第"
"しだいに 次第に"
"しだし 仕出し"
"しだしょくぶつ シダ植物"
"しだら 設楽"
"しだれざくら 垂れ桜 枝垂れ桜"
"しだれやなぎ 垂れ柳 枝垂れ柳"
"しだわら 志俵"
"しだん 指彈 詩壇 史談 指弾 師団"
"しだんしょ 示談書"
"しち 叱 至智 至知 四知 私地 貭 死地 七 質"
"しちいれ 質入れ"
"しちいれうらがき 質入裏書"
"しちいれしょうけん 質入証券"
"しちうけ 質請け"
"しちかいき 七回忌"
"しちかく 視知覚"
"しちがしゅく 七ヶ宿"
"しちがつ 文月 ７月 七月"
"しちがはま 七ヶ浜"
"しちく 飼畜 糸竹 紫竹"
"しちぐさ 質種 質草"
"しちけい 七経"
"しちけん 質権"
"しちげんきん 七弦琴"
"しちごさん 七五三"
"しちごちょう 七五調"
"しちごん 七言"
"しちさん 七三"
"しちしちにち 七七日"
"しちしとう 七支刀"
"しちしゃ 七社"
"しちしょ 七書"
"しちしょう 七生"
"しちじ 七時"
"しちじしき 七事式"
"しちじゅう 七十 七重"
"しちじゅうしち 七十七"
"しちじゅうにんやくせいしょ 七十人訳聖書"
"しちじゅうほうじゅ 七重宝樹"
"しちじょう 七丈 七城 七条"
"しちずんどけい シチズン時計"
"しちせい 七星"
"しちせき 七赤"
"しちだね 質種"
"しちだん 七段"
"しちてんはっき 七転八起"
"しちてんばっとう 七転八倒"
"しちとく 七徳"
"しちど 七度"
"しちどうがらん 七堂伽藍"
"しちながれ 質流れ"
"しちならべ 七並べ"
"しちなん 七難"
"しちにん 七人"
"しちねん 七年"
"しちのへ 七戸"
"しちふく 七福"
"しちふくじん 七福神"
"しちふくせい 七福星"
"しちふだ 質札"
"しちぶ 七分"
"しちぶしゅう 七部集"
"しちへんげ 七変化"
"しちほ 七歩"
"しちほう 七宝"
"しちほのさい 七歩の才"
"しちほん 七本"
"しちみ 七味"
"しちめんちょう 七面鳥"
"しちめんどう しち面倒 七面倒"
"しちゃく 試着"
"しちや 七夜 質屋"
"しちゅう 仔虫 死中 司厨 支柱 市中"
"しちゅうこん 支柱根"
"しちゅうしんぶ 市中心部"
"しちゅうすいめい 四柱推命"
"しちょう 鷙鳥 至重 詩調 弛張 使庁 紙帳 四丁 征 仕丁 輜重 士長 師長 市朝 死兆 思潮 市庁 支庁 市町 視聴 試聴 市長"
"しちょうかく 視聴覚"
"しちょうしゃ 市庁舎"
"しちょうそん 市町村"
"しちょく 司直"
"しちょっけい 視直径"
"しちよう 七曜"
"しちようせい 七曜星"
"しちり 七里"
"しちりん 七輪"
"しちろう 七郎"
"しっか 叱呵 膝窩 膝下 失火"
"しっかい 悉皆"
"しっかく 失格"
"しっかつ 失活"
"しっかと 聢と 確と"
"しっかり 聢り 確り"
"しっかりもの しっかり者"
"しっかん 失官 失陥 疾患"
"しっき 漆器 湿気"
"しっきゃく 失脚"
"しっきん 失禁"
"しっく 疾駆"
"しっくい 漆喰"
"しっけ 湿気"
"しっけい 失計 失敬"
"しっけつ 失血"
"しっけん 失権 執権 識見"
"しっこ 疾呼"
"しっこう 膝行 失行 失効 執行"
"しっこく 桎梏 漆黒"
"しっこし 尻腰"
"しっこんごう 執金剛"
"しっさく 失錯 失策"
"しっしき 湿式"
"しっしっ 叱叱"
"しっしょ 失書"
"しっしょう 湿生 失笑"
"しっしょく 失職"
"しっしん 失神 湿疹"
"しっせい 叱声 叱正 執政 湿生 失政 湿性"
"しっせいしょう 失声症"
"しっせき 叱斥 失跡 叱責"
"しっそ 質素"
"しっそう 執奏 失踪 疾走"
"しっそく 失速"
"しった 叱咤"
"しったい 失対 失態"
"しったか 知ったか"
"しったつ 執達"
"しったるた 悉達多"
"しったん 悉曇"
"しっち 失地 湿地"
"しっちゃく 失着"
"しっちゃくご 漆着語"
"しっちゅう 集註 失注 集注"
"しっちょう 室長 失調"
"しっちんまんぽう 七珍万宝"
"しっつい 失墜"
"しって 尻手"
"しってん 質点 失点"
"しってんばっとう 七転八倒"
"しっと 嫉妬"
"しっとう 失投 失当 執刀"
"しっぱい 失敗"
"しっぴ 櫛比 失費"
"しっぴつ 執筆"
"しっぷ 湿布"
"しっぷう 疾風"
"しっぷうもくう 櫛風沐雨"
"しっぺい 竹篦 疾病"
"しっぺがえし しっぺ返し"
"しっぽ 尻尾"
"しっぽう 七宝"
"しっぽうとう 七宝塔"
"しっぽうやき 七宝焼"
"しっぽく 卓袱"
"しつ 出 隲 貭 蛭 執 叱 櫛 蟋 悉 膝 漆 隰 濕 湿 嫉 疾 失 瑟 室 質"
"しつい 視追 執意 失意"
"しついん 室員"
"しつう 四通 私通 止痛 歯痛"
"しつおか 室岡"
"しつおん 室温"
"しつかい 室会"
"しつかん 質感"
"しつかんせつ 膝関節"
"しつがい 膝蓋 室外"
"しつぎ 質疑"
"しつぎょう 失業"
"しつけ 仕付け 仕付 躾"
"しつけいと 仕付け糸"
"しつげい 漆芸"
"しつげん 失言 湿原"
"しつご 失語"
"しつじ 執事"
"しつじつ 質実"
"しつじゅん 湿潤"
"しつぜつ 湿舌"
"しつちょう 室長"
"しつてき 質的"
"しつてん 質点"
"しつでん 湿田"
"しつでんち 湿電池"
"しつど 湿度"
"しつどう 室堂"
"しつどくしょう 失読症"
"しつない 室内"
"しつないがく 室内楽"
"しつないこう 室内光"
"しつないぷーる 室内プール"
"しつにん 失認"
"しつねん 失念"
"しつば 叱罵"
"しつばん 湿板"
"しつばんごう 室番号"
"しつぼう 失望"
"しつぼく 質樸 質朴"
"しつむ 悉無 執務"
"しつめい 室名 失明"
"しつもん 質問"
"しつもんしほう 質問紙法"
"しつもんぜめ 質問責め"
"しつもんばこ 質問箱"
"しつよう 執拗"
"しつらえ 設え"
"しつらく 失楽"
"しつりょう 質料 室料 質量"
"しつれい 失礼"
"しつれん 失恋"
"しつろ 失路"
"しづ 志津"
"しづえ 志津恵"
"しづか 謐"
"しづき 志築 志筑"
"しづく 滴 雫"
"して 爲手 支手 仕手"
"してい 仕丁 私邸 視程 姉弟 子弟 師弟 指定"
"してかた シテ方"
"してき 至適 詩的 史的 私的 指摘"
"してつ 私鉄"
"してとう シテ島"
"してん 祀天 祀典 支点 始点 支店 視点"
"してんし 熾天使"
"してんのう 四天王"
"しで 垂 椣 四手 死出"
"しでのたび 死出の旅"
"しでのやま 死出の山"
"しではら 幣原"
"しではらきじゅうろう 幣原喜重郎"
"しでむし 埋葬虫"
"しでん 市電 師伝 史伝 紫電"
"しでんかい 紫電改"
"しと 尿 司徒 死都 使徒 使途"
"しとう 私党 紫藤 指頭 私闘 至当 死闘"
"しとうかん 四等官"
"しとぎ 粢"
"しとぎょうでん 使徒行伝"
"しとく 四徳 至徳"
"しとづつ 尿筒"
"しとど 鵐"
"しとね 茵 褥"
"しとみ 蔀"
"しとみや 蔀屋"
"しとめにん 仕留人"
"しとやか 淑やか"
"しど 私度 示度 志度"
"しどう 示導 詩道 師道 斯道 至道 四道 祠堂 士道 私道 市道 始動 指導"
"しどく 屍毒 死毒 試読"
"しどちょうせい 視度調整"
"しどり 倭文"
"しな 科 支那 品"
"しない 竹刀 市内"
"しないざん シナイ山"
"しないはんとう シナイ半島"
"しなうす 品薄"
"しなかず 品数"
"しながき 品書 品書き"
"しながら 品柄"
"しながれ 品枯れ"
"しながわ 品川"
"しながわくひがししながわ 品川区東品川"
"しなぎれ 品切 品切れ"
"しなこ 信成子"
"しなさだめ 品定め"
"しなじな 品々"
"しなぞろえ 品揃え"
"しなだ 品田"
"しなだい 品代"
"しなだま 品玉"
"しなちく 支那竹"
"しなつるせん 品鶴線"
"しなの 品野 品濃 信濃"
"しなのき 科の木"
"しなぶれ 品触れ"
"しなもじ 品文字"
"しなもの 品物"
"しなん 至難 指南"
"しに 死に"
"しにいし 死に石"
"しにいたるやまい 死に至る病"
"しにかけ 死に掛け"
"しにがね 死に金"
"しにがみ 死に神 死神"
"しにぎわ 死に際"
"しにく 視肉 屍肉 死肉 歯肉"
"しにしょうぞく 死装束"
"しにすがた 死に姿"
"しにせ 老舗"
"しにぞこない 死に損い 死に損ない"
"しにどころ 死に処"
"しにはじ 死に恥"
"しにばな 死に花"
"しにひょう 死票"
"しにびと 死に人"
"しにみ 死に身"
"しにみず 死に水"
"しにゅう 刺入"
"しにょう 支繞 し尿 屎尿"
"しにん 死人 視認"
"しねん 思念"
"しの 詩乃 信乃 紫乃 志野 志乃 篠"
"しのう 四能 司農 詩嚢 子嚢"
"しのうきん 志納金"
"しのうくんれんし 視能訓練士"
"しのうけい 司農卿"
"しのうこうしょう 士農工商"
"しのかわ 篠河 篠川"
"しのがき 篠垣"
"しのき 篠木"
"しのぎ 凌 篠木 凌ぎ 鎬"
"しのぎじ 鎬地"
"しのぎづくり 鎬造り"
"しのくりせん 篠栗線"
"しのごの 四の五の"
"しのざき 篠崎"
"しのしま 篠島"
"しのしょうにん 死の商人"
"しのすけ 志の輔"
"しのたけ 篠竹"
"しのだ 信太 信田 篠田"
"しのだけ 篠竹"
"しのだずし 信太鮨"
"しのだまき 信太巻"
"しのづか 篠塚"
"しののい 篠ノ井"
"しののめ 東雲"
"しののめぶし 東雲節"
"しのはい 死の灰"
"しのはら 篠原"
"しのばず 不忍"
"しのばずのいけ 不忍池"
"しのび 忍 忍び"
"しのびあい 忍び逢い"
"しのびあし 忍び足"
"しのびで 忍び手"
"しのびねものがたり 忍音物語"
"しのびのもの 忍ノ者"
"しのぶ 紫伸 偲 信夫 忍"
"しのぶえ 篠笛"
"しのぶぐさ 荵 忍草"
"しのみや 四ノ宮 篠宮 四宮"
"しのむら 篠村"
"しのもと 篠本"
"しのやま 篠山"
"しのろ 篠路"
"しは 支派"
"しはい 紙牌 紙背 賜杯 支配"
"しはいぎ 支配木"
"しはく 糸帛"
"しはす 師走"
"しはちへい 詩八病"
"しはつ 始発"
"しはらい 支払 支払い"
"しはん 屍斑 私版 死斑 紫斑 四半 師範 市販"
"しば 死馬 斯波 司馬 柴 芝"
"しばい 芝居"
"しばいぎ 芝居気"
"しばいけ 芝池"
"しばいじゃや 芝居茶屋"
"しばいたい 四倍体"
"しばいぢゃや 芝居茶屋"
"しばいっけ 芝居っ気"
"しばいぬ 柴犬"
"しばうら 芝浦"
"しばえび 青蝦 芝蝦 芝エビ 芝海老"
"しばかり 柴刈 柴刈り 芝刈 芝刈り"
"しばかわ 芝川"
"しばがき 柴垣"
"しばき 柴木"
"しばくさ 芝草"
"しばけいけん 芝経験"
"しばこうえん 芝公園"
"しばこうだい 芝工大"
"しばさき 柴崎"
"しばざかな 芝魚"
"しばざき 柴崎"
"しばざくら 芝桜"
"しばし 暫 暫し"
"しばした 芝下"
"しばしば 屡々 屡"
"しばす 始バス 市バス"
"しばせん 司馬遷"
"しばた 柴多 芝田 新発田 柴田"
"しばち 芝地"
"しばづけ 柴漬 柴漬け"
"しばの 芝野 柴野"
"しばはし 柴橋"
"しばはま 芝浜"
"しばはら 芝原 柴原"
"しばふ 芝生"
"しばぶね 柴舟"
"しばまた 柴又"
"しばまち 柴町"
"しばみや 柴宮"
"しばめ 芝目"
"しばやま 芝山 柴山"
"しばらく 暫く"
"しばり 縛り"
"しばりくび 縛り首"
"しばん 篩板 指板"
"しばんむし 死番虫"
"しひ 施肥 市費 詩碑 私費"
"しひつ 史筆 紙筆"
"しひゃくしびょう 四百四病"
"しひょう 四表 私評 師表 死票 指標"
"しび 至微"
"しびと 死人"
"しびとばな 死人花"
"しびょう 詩病 祠廟 死病"
"しびょうし 四拍子"
"しびれ 痺 痺れ"
"しびん 溲瓶 尿瓶"
"しふ 詩賦 師傅 紙布 師父"
"しふう 詩風"
"しふく 私腹 雌伏 紙幅 私服 至福"
"しふとじす シフトJIS"
"しふん 紙粉 私憤 脂粉"
"しぶ 澀 澁 ４分 篩部 師部 四部 四分 市部 渋 支部"
"しぶあき ４分空"
"しぶい 渋井"
"しぶいち 四分一"
"しぶえ 渋江"
"しぶかわ 渋川 渋皮"
"しぶがき 渋柿"
"しぶがきたい シブがき隊"
"しぶがみ 渋紙"
"しぶき 繁吹 渋木 沫 飛沫"
"しぶくさ 渋草"
"しぶこう 渋公"
"しぶさ 澁佐"
"しぶさわ 澁澤 渋沢"
"しぶさわたつひこ 渋沢竜彦"
"しぶし 志布志"
"しぶしぶ 渋々"
"しぶた 渋田"
"しぶたに 渋谷"
"しぶちゃ 渋茶"
"しぶつ 死物 私物"
"しぶとうげ 渋峠"
"しぶぬき 渋抜き"
"しぶみ 渋み"
"しぶみがわ 渋海川"
"しぶや 澁谷 渋谷"
"しぶやく 澁谷區"
"しぶり 仕振り"
"しぶりばら 渋り腹"
"しぶろく 四分六"
"しぶん 支分 死文 士分 四分 詩文"
"しぶんごれつ 四分五裂"
"しへい 私兵 子平 紙幣"
"しへき 四壁"
"しへん 四辺 詩編 紙片 詩篇"
"しべ 蕋 蘂 蕊"
"しべちゃ 標茶"
"しべつ 標別 標津 士別 死別"
"しべとろ 蕊取"
"しべりあ 西伯利亞"
"しべん 思弁 至便 支弁"
"しほ 鹽 汐 潮 試補 紫穂 詩穂 志帆 志穂 志保"
"しほう 死法 視法 市報 子法 詩法 刺胞 紫峰 私法 至宝 四方 司法"
"しほうしゅうしゅうせい 司法修習生"
"しほうだい し放題 仕放題"
"しほうちく 四方竹"
"しほこ 志保子"
"しほこう 支保工"
"しほさゐ 潮騒"
"しほどき 潮時"
"しほひ 潮干"
"しほふき 潮吹き"
"しほろ 士幌"
"しほん 紙本 資本"
"しほんばしら 四本柱"
"しぼ 皺 私募 思慕"
"しぼう 子房 志望 脂肪 死亡"
"しぼうかん 脂肪肝"
"しぼうた 柴生田"
"しぼく 司牧"
"しぼつ 死歿 死没"
"しぼり 絞り"
"しぼりかす 搾り滓 絞り滓"
"しぼりじる 搾り汁"
"しま 志真 揣摩 嶌 志麻 四万 志摩 嶋 縞 島"
"しまあじ 縞鰺"
"しまい 了い 仕舞 仕舞い 終い 姉妹"
"しまいさき 縞伊佐木"
"しまうた 島唄"
"しまうち 島内"
"しまうちゅう 島宇宙"
"しまお 嶋尾 島尾"
"しまおか 島岡"
"しまか 縞蚊"
"しまかげ 島陰 島影"
"しまかぜ 島風"
"しまがくれ 島隠れ"
"しまがはら 島ヶ原"
"しまがら 縞柄"
"しまき 島木"
"しまきんぺん 島近辺"
"しまぐに 島国"
"しまこ 志麻子"
"しまこうさく 島耕作"
"しまこうぞう 縞構造"
"しまさき 嶋崎 島崎"
"しまざき 嶋崎 島崎"
"しましま 縞々"
"しまじ 島地"
"しまじょう 縞状"
"しまじり 島尻"
"しまず 島津"
"しませ 島瀬"
"しません 島線"
"しませんき 島戦記"
"しまぜんぶ 島全部"
"しまたに 嶋谷 島谷"
"しまだ 嶋田 島田"
"しまだい 縞鯛"
"しまつ 嶋津 始末"
"しまづ 嶋津 島津"
"しまづたい 島伝い"
"しまてつ 島鉄"
"しまとう 島藤"
"しまなか 嶋中 島中"
"しまながし 島流し"
"しまね 島根"
"しまの 嶋野 島野"
"しまのうち 島之内"
"しまのせき 島ノ関"
"しまばら 島原"
"しまひ 仕舞ひ"
"しまぶくろ 島袋"
"しまほうめん 島方面"
"しままき 島牧"
"しままつ 島松"
"しまみや 嶋宮"
"しまむら 嶋村 島村"
"しまめ 縞目"
"しまめのう 縞瑪瑙"
"しまもと 島本"
"しまもよう 縞模様"
"しまもり 島森 島守"
"しまや 島谷"
"しまやま 島山"
"しまり 締 締り 締まり"
"しまりす 縞栗鼠"
"しまわき 嶋脇"
"しまんとがわ 四万十川"
"しみ 蠹魚 汚点 凍み 染み 詩味 衣魚 紙魚"
"しみじみ 沁々 染々"
"しみず 紫水 志水 清水"
"しみずいくたろう 清水幾太郎"
"しみずかわ 清水川"
"しみずさわ 清水沢"
"しみずだいら 清水平"
"しみずだに 清水谷"
"しみずぬま 清水沼"
"しみずはら 清水原"
"しみずひがし 清水東"
"しみもち 凍み餅"
"しみゃく 支脈"
"しみょう 至妙"
"しみん 士民 嗜眠 市民"
"しみんてきじゆう 市民的自由"
"しみんびょうどう 四民平等"
"しむかっぷ 占冠"
"しむけ 仕向け 仕向"
"しむら 志村"
"しめ 示 締 志免 注連 〆 締め"
"しめい 死命 指命 紙名 誌名 市名 使命 指名 氏名"
"しめいすいせん 指名推選"
"しめかざり 七五三飾り 標飾り"
"しめがね 締金"
"しめきり 〆切り 〆切 締切り 締切"
"しめぐ 締具"
"しめこみ 締込み"
"しめさば 締め鯖"
"しめし 示し"
"しめしばい 湿し灰"
"しめじ 湿地"
"しめすへん 示偏"
"しめだいこ 締太鼓"
"しめつ 死滅"
"しめつけ 締めつけ 締付け"
"しめて 締めて 〆て"
"しめなわ 標縄 七五三縄 注連縄"
"しめの 示野"
"しめび 締日"
"しめむら 示村"
"しめり 湿り"
"しめりけ 湿り気"
"しめりゆき 湿り雪"
"しめわざ 締技"
"しめん 四面 誌面 紙面"
"しめんそか 四面楚歌"
"しも 下 霜"
"しもあがた 下県"
"しもあな 霜穴"
"しもい 下位 下井"
"しもいち 下一 下市"
"しもう 刺毛"
"しもうさ 下総"
"しもうま 下馬"
"しもお 下尾"
"しもおか 下岡"
"しもかた 下方"
"しもかわ 下川"
"しもがこい 霜囲い"
"しもがも 下鴨"
"しもがれ 霜枯れ"
"しもき 下期"
"しもきた 下北"
"しもぎょう 下京"
"しもく 四木"
"しもくに 下國"
"しもぐち 下口"
"しもげ 下毛"
"しもこうべ 下河辺"
"しもこしき 下甑"
"しもごう 下郷"
"しもごえ 下肥"
"しもごおり 下郡"
"しもさか 下坂"
"しもざ 下座"
"しもざき 霜崎"
"しもざと 下里"
"しもざわ 下沢"
"しもしき 下敷"
"しもしん 下新"
"しもじ 下地"
"しもじま 下嶋"
"しもじも 下下 下々"
"しもじゅう 下重"
"しもじょう 下城 下条 下條"
"しもぞの 下薗 下園"
"しもたや 仕舞た屋 仕舞屋"
"しもだ 下田"
"しもだいら 下平"
"しもだて 下館"
"しもちしま 下地島"
"しもちゃ 下家"
"しもちゅういほう 霜注意報"
"しもつ 下津"
"しもつい 下津井"
"しもつかた 下つ方"
"しもつき 霜月"
"しもつけ 下野"
"しもつじ 下辻"
"しもつふさ 下総"
"しもつま 下妻"
"しもづま 下妻"
"しもて 下手"
"しもと 笞 楚"
"しもとり 霜取 下鳥 霜取り 霜鳥"
"しもどけ 霜融け 霜解け"
"しもなか 下中"
"しもなり 下成"
"しもに 下二"
"しもにた 下仁田"
"しもにたねぎ 下仁田葱"
"しもねた 下ネタ"
"しもの 下野"
"しものく 下の句"
"しものせき 下関"
"しもばしら 霜柱"
"しもばやし 下林"
"しもひろ 下廣"
"しもふさ 下総"
"しもふり 霜降 霜降り"
"しもぶくれ 下脹れ 下膨れ"
"しもへい 下閉伊"
"しもべ 下僕 僕 下部"
"しもみち 下道"
"しもみのち 下水内"
"しもむ 下無"
"しもむら 下村"
"しもやけ 霜焼け"
"しもやなぎ 下柳"
"しもやま 霜山 下山"
"しもよ 霜夜"
"しもよけ 霜除け"
"しもよし 下吉"
"しもん 市門 子門 試問 指紋 諮問"
"しもんじ 指文字"
"しゃ 冩 寫 瀉 柘 卸 炙 這 斜 西 洒 舍 捨 娑 沙 砂 紗 蔗 鷓 遮 赦 赭 奢 煮 舎 謝 射 写 社 者 車"
"しゃーぷ ＃ ♯"
"しゃあ 西"
"しゃい 差異 斜位 謝意"
"しゃいん 社印 社員"
"しゃいんりょう 社員寮"
"しゃうん 社運"
"しゃえい 写影 射影"
"しゃおう 沙翁"
"しゃおく 社屋"
"しゃおん 謝恩 遮音"
"しゃおんもじ 写音文字"
"しゃか 社歌 釈迦"
"しゃかい 社会"
"しゃかいあく 社会悪"
"しゃかいなべ 社会鍋"
"しゃかく 斜格 社格 射角 車格"
"しゃかくきん 斜角筋"
"しゃかっこう 斜滑降"
"しゃかむに 釈迦牟尼"
"しゃかん 舎監 車間"
"しゃが 車駕"
"しゃがい 舎飼い 車外 社外"
"しゃがいひ 社外秘"
"しゃがく 写楽"
"しゃがれごえ 嗄れ声"
"しゃがん 赭顔 斜眼"
"しゃがんたい 遮眼帯"
"しゃき 社規 社旗"
"しゃきしゃきかん シャキシャキ感"
"しゃきゅう 社給"
"しゃきょう 写経"
"しゃきょり 射距離"
"しゃきん 謝金"
"しゃぎ 謝儀"
"しゃぎぬ 紗衣"
"しゃぎょう 社業"
"しゃく 炸 蹟 赤 石 綽 錫 借 昔 鑠 爍 蜥 皙 斫 釋 釈 嚼 爵 芍 妁 灼 杓 勺 癪 笏 酌 尺"
"しゃくい 爵位"
"しゃくぎ 釈義"
"しゃくざい 借財"
"しゃくし 釈子 杓子"
"しゃくしな 杓子菜"
"しゃくしゃく 灼灼 綽綽 灼々 綽々"
"しゃくしょ 借書"
"しゃくじ 借字"
"しゃくじい 石神井"
"しゃくじょう 錫杖"
"しゃくすん 尺寸"
"しゃくせん 借銭"
"しゃくぜん 灼然 釈然"
"しゃくそん 釈尊"
"しゃくだま 尺玉"
"しゃくち 尺地 借地"
"しゃくちょうくう 釈迢空"
"しゃくちん 借賃"
"しゃくとりむし 尺蠖 尺取虫"
"しゃくど 赤土 尺度"
"しゃくどう 赤銅"
"しゃくなが 尺長"
"しゃくなげ 石南花 石楠花"
"しゃくにゅう 借入"
"しゃくねつ 灼熱"
"しゃくのたね 癪の種"
"しゃくはち 尺八"
"しゃくびょうし 笏拍子"
"しゃくふ 酌婦"
"しゃくぶく 折伏"
"しゃくほう 釈放"
"しゃくま 借間"
"しゃくめい 綽名 釈明"
"しゃくもん 借問"
"しゃくや 借家"
"しゃくやく 芍薬"
"しゃくよう 借用"
"しゃくらん 借覧"
"しゃくりょう 酌量 借料"
"しゃくん 社訓"
"しゃぐま 赭熊 赤熊"
"しゃけ 社家 鮭"
"しゃけい 舎兄 斜傾 斜頚 斜頸"
"しゃけいよう 写経用"
"しゃけつ 瀉血"
"しゃけん 写研 車券 車検"
"しゃけんぎれ 車検切"
"しゃげき 射撃"
"しゃこ 鷓鴣 蝦蛄 車庫"
"しゃこう 斜交 射幸 射倖 斜行 遮光 車高 社交"
"しゃこうし 斜行枝"
"しゃこうだんす 社交ダンス"
"しゃこうばん 遮光板"
"しゃこく 社告"
"しゃこたん 積丹"
"しゃさい 社債 車載"
"しゃさつ 射殺"
"しゃさん 社参"
"しゃざい 斜材 謝罪"
"しゃし 奢肆 奢恣 奢侈 斜視 社史"
"しゃしつ 車室"
"しゃしゃく 車借"
"しゃしゃらくらく 洒洒落落 洒々落々"
"しゃしゅ 叉手 社主 射手 車種"
"しゃしゅつ 射出"
"しゃしょ 赦書"
"しゃしょう 蔗漿 社章 捨象 車掌"
"しゃしょく 社稷 赭色 社食 写植"
"しゃしょゆう 社所有"
"しゃしん 捨身 写真"
"しゃしんいり 写真入"
"しゃしんちょう 写真帖"
"しゃじ 写字 斜字 社寺 謝辞"
"しゃじく 車軸"
"しゃじくも 車軸藻"
"しゃじつ 社日 写実"
"しゃじゅう 車重"
"しゃじゅつ 射術"
"しゃじょう 赦状 謝状 射場 車上"
"しゃじん 舎人"
"しゃせい 社製 写生 射精"
"しゃせいご 写声語"
"しゃせきしゅう 沙石集"
"しゃせつ 社説"
"しゃせん 社線 斜線 車線"
"しゃぜ 社是"
"しゃぜつ 謝絶"
"しゃぜん 社前"
"しゃそう 斜走 社葬 車窓"
"しゃそく 社足 社則 車速"
"しゃぞう 写像"
"しゃたい 斜体 車体"
"しゃたく 社宅"
"しゃたんぶ 車端部"
"しゃだい 車台 社台"
"しゃだつ 洒脱"
"しゃだん 射断 しゃ断 社団 遮断"
"しゃだんぼう 遮断棒"
"しゃち 鯱"
"しゃちがわら 鯱瓦"
"しゃちく 洒竹 社畜"
"しゃちほこ 鯱鉾 鯱"
"しゃちほこがわら 鯱瓦"
"しゃちゅう 社中 車中"
"しゃちょう 車長 社長"
"しゃちょうせき 斜長石"
"しゃっか 借家"
"しゃっかく 尺蠖"
"しゃっかん 借款"
"しゃっかんさい 借換債"
"しゃっかんほう 尺貫法"
"しゃっきょう 釈教 石橋"
"しゃっきん 借金"
"しゃっきんおとこ 借金男"
"しゃっく 赤口"
"しゃっくり 吃逆"
"しゃっけい 借景"
"しゃっこう 灼光 笏康 赤光 赤口"
"しゃっこつ 尺骨"
"しゃてい 舎弟 射程"
"しゃてき 射的"
"しゃでん 社殿"
"しゃとう 車頭 社頭 斜塔"
"しゃど 赭土 斜度"
"しゃどう 車道"
"しゃな 紗那"
"しゃない 車内 社内"
"しゃないほう 社内報"
"しゃないむけ 社内向"
"しゃにくさい 謝肉祭"
"しゃにち 社日"
"しゃにむに 遮二無二"
"しゃにゅう 西入"
"しゃねつ 遮熱"
"しゃはば 車幅"
"しゃはん 社販 車販 這般"
"しゃば 車馬 娑婆"
"しゃばくじょう 射爆場"
"しゃばん 社判 車番"
"しゃひ 舎費 社費"
"しゃび 奢靡"
"しゃふ 写譜 車夫"
"しゃふう 社風"
"しゃふく 車幅"
"しゃふつ 煮沸"
"しゃぶんれつ 斜分裂"
"しゃへい 遮へい 遮蔽"
"しゃへいばん 遮蔽板"
"しゃへん 斜辺"
"しゃべつ 差別"
"しゃべり 喋り"
"しゃほ 社保"
"しゃほう 車砲 斜方"
"しゃほたん 社保短"
"しゃほん 写本"
"しゃぼんだま しゃぼん玉 シャボン玉"
"しゃまく 紗幕"
"しゃみ 三味 沙弥"
"しゃみんとう 社民党"
"しゃみんれん 社民連"
"しゃむ 暹羅 社務"
"しゃむねこ シャム猫"
"しゃめい 社命 車名 社名"
"しゃめん 赦免 斜面"
"しゃも 軍鶏"
"しゃもじ 杓文字"
"しゃもん 借問 沙門"
"しゃもんおり 斜文織"
"しゃゆう 社友 社有"
"しゃよう 斜陽 社用"
"しゃらく 酒楽 洒落 写楽"
"しゃらじゅ 娑羅樹"
"しゃらそうじゅ 娑羅双樹"
"しゃり 射利 斜里 舎利"
"しゃりき 車力"
"しゃりとう 舎利塔"
"しゃりほつ 舎利弗"
"しゃりょう 社領 車輛 車輌 車両"
"しゃりょうばんごうひょう 車両番号標"
"しゃりん 車輪"
"しゃりんのした 車輪の下"
"しゃれ 洒落"
"しゃれい 車齢 謝礼"
"しゃれき 車歴 社歴"
"しゃれこうべ 髑髏"
"しゃれっけ 洒落っ気"
"しゃれつ 斜列 車列"
"しゃわーしつ シャワー室"
"しゃんそんかしゅ シャンソン歌手"
"しゃんたん 上湯"
"しゃんつぁい 香菜"
"しゃんはい 上海"
"しゃんはいがに 上海蟹"
"しゃんぱん 三鞭酒"
"しゃんぷーだい シャンプー台"
"しや 子夜 視野"
"しやく 試訳 試薬"
"しやくしょ 市役所"
"しやけ 初宿"
"しゅ 撞 麈 鬚 繻 殳 椶 棕 須 衆 修 銖 蛛 洙 侏 珠 殊 株 諏 娶 娵 趣 取 狩 守 踵 腫 酒 首 手 朱 種 主"
"しゅーぱい 数牌"
"しゅーまい 焼売"
"しゅい 種衣 主位 主意 趣意 首位"
"しゅいがため 首位固め"
"しゅいち 主一"
"しゅいろ 朱色"
"しゅいん 手印 手淫 朱印 主因"
"しゅう 踵 朱 嗅 蹤 慫 溲 繍 羞 執 舟 襲 拾 祝 螽 泅 鍬 鰍 鞦 甃 湫 楸 愀 啾 萩 愁 穐 秋 楢 逎 遒 酋 摺 褶 慴 習 醜 蒐 售 讎 讐 葺 緝 楫 輯 駲 酬 洲 銹 綉 秀 鷲 蹴 就 岫 袖 蓚 脩 修 收 収 驟 聚 衆 囚 宗 周 終 臭 週 集 州"
"しゅうあく 醜悪"
"しゅうあし 週足"
"しゅうい 周位 衆意 秋意 就位 拾遺 周囲"
"しゅういち 周一 秀一 修一 週一"
"しゅういつ 秀逸"
"しゅういん 秋陰 執印 衆院"
"しゅうう 驟雨 秋雨"
"しゅううん 舟運"
"しゅうえい 秀英"
"しゅうえいしゃ 集英社"
"しゅうえき 周易 就役 収益"
"しゅうえつ 収悦"
"しゅうえん 終鴛 秀演 終宴 周縁 就園 終演 終焉"
"しゅうえんそうち 集煙装置"
"しゅうお 羞悪"
"しゅうおん 収音 集音"
"しゅうおんらい 周恩来"
"しゅうか 衆化 衆寡 集貨 秀歌 臭化 集荷"
"しゅうかい 聚會 聚会 醜怪 集塊 周回 集会"
"しゅうかいどう 秋海棠"
"しゅうかく 収獲 臭覚 収穫"
"しゅうかさい 愁華祭"
"しゅうかつ 就活"
"しゅうかへいげつ 羞花閉月"
"しゅうかん 醜漢 秋官 終巻 終刊 収監 週刊 週間 習慣"
"しゅうがく 宗学 修学 就学"
"しゅうがくいん 修学院"
"しゅうがわり 週替わり"
"しゅうき 終帰 宗規 秋気 周忌 終期 秋期 臭気 秋季 周期"
"しゅうきじ 集記事"
"しゅうきほう 集気法"
"しゅうきゃく 集客"
"しゅうきゅう 秋宮 週給 蹴球 週休"
"しゅうきょう 秋興 州境 宗教"
"しゅうきょく 周極 終極 褶曲 終曲 終局"
"しゅうきょくせい 周極星"
"しゅうきん 集金"
"しゅうきんぶくろ 集金袋"
"しゅうぎ 宗義 衆議 祝儀"
"しゅうぎいん 衆議院"
"しゅうぎく 秋菊"
"しゅうぎぶくろ 祝儀袋"
"しゅうぎょう 終業 修業 就業"
"しゅうぎょこうか 集魚効果"
"しゅうぎわしょ 集義和書"
"しゅうぎん 秀吟"
"しゅうく 秀句"
"しゅうぐ 衆愚"
"しゅうぐん 州軍"
"しゅうけい 修景 集計"
"しゅうけつ 終結 集結"
"しゅうけん 舟券 集権"
"しゅうけんてき 集圏的"
"しゅうげき 襲撃"
"しゅうげつ 秋月"
"しゅうげん 祝言"
"しゅうこ 収子 修子"
"しゅうこう 秋向 衆口 醜行 収公 舟航 舟行 周行 周航 修好 集光 就航"
"しゅうこうきょう 集光鏡"
"しゅうこうてん 周口店"
"しゅうこうれんず 集光レンズ"
"しゅうこつ 収骨"
"しゅうごう 秋毫 聚合 習合 集合"
"しゅうごうか 集合果"
"しゅうごうご 輯合語"
"しゅうごうじごく 衆合地獄"
"しゅうごろう 脩五郎 周五郎"
"しゅうさ 収差"
"しゅうさい 集載 州際 秀才 収載"
"しゅうさく 秀策 周作 習作 秀作"
"しゅうさつ 集札"
"しゅうさん 聚散 シュウ酸 蓚酸 集散 衆参"
"しゅうさんき 周産期"
"しゅうさんしゅぎ 集産主義"
"しゅうざい 秋材 集材"
"しゅうざかい 州境"
"しゅうざん 周山"
"しゅうし 修史 宗旨 終止 終始 修士 収支"
"しゅうしいちねん 修士壱年"
"しゅうしがえ 宗旨替え"
"しゅうしき 終式"
"しゅうしゃ 終車"
"しゅうしゅう 集収 集輯 啾啾 拾集 啾々 蒐集 収拾 収集"
"しゅうしゅく 収縮"
"しゅうしゅぼうかん 袖手傍観"
"しゅうしょ 周書 衆庶 集書"
"しゅうしょう 秋宵 周章 修証 就床 愁傷 終章"
"しゅうしょく 襲職 愁色 秋色 修飾 就職"
"しゅうしょくいわい 就職祝"
"しゅうしょくなん 就職難"
"しゅうしん 集信 終審 執心 修身 終身 就寝"
"しゅうじ 宗司 秀次 修次 秀司 周二 秀治 修治 修司 修二 集字 週次 修辞 習字"
"しゅうじつ 秋日 週日 終日"
"しゅうじゃく 執着"
"しゅうじゅ 収受"
"しゅうじゅうろう 宗十郎"
"しゅうじゅく 習熟"
"しゅうじょ 醜女"
"しゅうじょう 醜状 衆生"
"しゅうじょく 就褥"
"しゅうじん 衆人 集塵 囚人"
"しゅうすい 秋水 集水"
"しゅうすけ 秀介"
"しゅうすじ 主筋"
"しゅうせい 銹錆 醜声 輯成 宗制 衆星 終世 秋晴 衆生 修成 秋声 終生 修整 習性 集成 修正"
"しゅうせいなし 修正無"
"しゅうせいよう 修正要"
"しゅうせき 就籍 集積"
"しゅうせん 終戰 鞦韆 臭腺 集線 周旋 終戦"
"しゅうぜい 州税 収税"
"しゅうぜつ 愁絶 秀絶"
"しゅうぜん 愁然 修繕"
"しゅうそ 愁訴 宗祖 臭素"
"しゅうそう 愀愴 終相 秋霜"
"しゅうそく 終熄 周速 集束 終息 収束"
"しゅうそつ 修卒"
"しゅうそん 集村"
"しゅうぞう 収三 脩三 秀三 修三 修造 収蔵"
"しゅうぞく 習俗"
"しゅうたい 醜態"
"しゅうたいせい 集大成"
"しゅうたろう 秀太郎"
"しゅうたん 愁嘆 終端"
"しゅうだつ 収奪"
"しゅうだん 終段 集団"
"しゅうち 周緻 習知 終値 周智 衆知 羞恥 周知"
"しゅうちく 修築"
"しゅうちゃく 祝着 終着 執着"
"しゅうちゅう 集註 集注 集中"
"しゅうちょう 周長 酋長"
"しゅうちん 袖珍"
"しゅうちんばん 聚珍版"
"しゅうづら 主面"
"しゅうてい 修訂 舟艇"
"しゅうてん 秋天 終点"
"しゅうてんえん 周転円"
"しゅうでん 集電 終電"
"しゅうと 修斗 囚徒 宗徒 衆徒 舅 州都 姑"
"しゅうとう 周東 秋冬 周到"
"しゅうとく 修徳 拾得 収得 修得 習得"
"しゅうとめ 姑"
"しゅうどう 衆道 州道 摺動 修道"
"しゅうどういん 修道院"
"しゅうない 週内"
"しゅうにゅう 収入"
"しゅうにん 就任"
"しゅうねん 終年 執念 周年"
"しゅうねんぶかく 執念深く"
"しゅうのう 終脳 就農 収納"
"しゅうのうだな 収納棚"
"しゅうのうぶくろ 収納袋"
"しゅうは 秋波 周波 宗派"
"しゅうはい 集配"
"しゅうはいしん 集配信"
"しゅうはすうさんぷりんぐ 周波数サンプリング"
"しゅうはつ 終発"
"しゅうばく 就縛"
"しゅうばす 終バス"
"しゅうばつ 舟筏 秀抜"
"しゅうばん 終板 週番 終盤"
"しゅうひ 周皮"
"しゅうひょう 衆評 集票"
"しゅうび 秀眉 愁眉 秀美"
"しゅうふ 醜婦"
"しゅうふう 宗風 秋風"
"しゅうふく 修復"
"しゅうふつ 修祓"
"しゅうぶん 醜聞 秋分"
"しゅうぶんのひ 秋分の日"
"しゅうへい 衆兵 修平 周平 州兵"
"しゅうへき 皺襞 周壁 習癖"
"しゅうへん 周辺"
"しゅうほ 修補"
"しゅうほう 秀芳 秋芳 秀峰 州法 週報"
"しゅうほうどう 秋芳洞"
"しゅうぼう 醜貌 衆望"
"しゅうまい 焼売"
"しゅうまく 終幕"
"しゅうまつ 終末 週末"
"しゅうみ 臭味"
"しゅうみつ 周密"
"しゅうみん 衆民 就眠"
"しゅうむ 宗務"
"しゅうめ 周目 週目"
"しゅうめい 醜名 襲名"
"しゅうもく 衆目"
"しゅうもん 宗門"
"しゅうや 秋夜 秀哉 終夜"
"しゅうやく 集約"
"しゅうゆ 終油"
"しゅうゆう 周遊"
"しゅうゆうかん 修猷館"
"しゅうよう 襲用 修養 収用 収容"
"しゅうら 修羅"
"しゅうらい 襲来"
"しゅうらく 聚落 集落"
"しゅうらん 収攬 秀蘭"
"しゅうり 修理"
"しゅうりつ 州立 収率"
"しゅうりゅう 周流"
"しゅうりょう 秋涼 収量 修了 終了"
"しゅうりょく 衆力"
"しゅうりん 秋林 秋霖"
"しゅうるし 朱漆"
"しゅうれい 週令 周礼 秋冷 終礼 秀麗"
"しゅうれん 收斂 習練 収斂 修練"
"しゅうろう 秀郎 秀朗 周郎 就労"
"しゅうろうびざ 就労ビザ"
"しゅうろく 集録 収録"
"しゅうろん 衆論 宗論 修論"
"しゅうわ 秀和"
"しゅうわい 醜穢 収賄"
"しゅえ 集会 修慧 衆会"
"しゅえい 輸贏 守衛"
"しゅえん 主煙 酒宴 主演"
"しゅおう 手応"
"しゅおん 主恩 主音"
"しゅか 種化 主家 酒家"
"しゅかい 首魁"
"しゅかく 酒客 主客 主格"
"しゅかん 首巻 主幹 主管 主観"
"しゅかんざっしゅ 種間雑種"
"しゅが 主芽 珠芽 主我"
"しゅがいねん 種概念"
"しゅがき 朱書き 朱書"
"しゅがん 主眼"
"しゅき 酒旗 首記 主基 朱記 手旗 主機 酒気 酒器 手記"
"しゅきおび 酒気帯び"
"しゅきゃく 主客 主脚"
"しゅきゅう 首級 守旧"
"しゅきょう 酒興 主教"
"しゅきん 手巾"
"しゅぎ 手技 主義"
"しゅぎょう 執行 修業 修行"
"しゅぎょく 珠玉"
"しゅく 戚 倏 夙 粥 蹙 菽 槭 俶 淑 叔 蓿 縮 肅 粛 珠久 宿 祝"
"しゅくあ 宿痾"
"しゅくあく 宿悪"
"しゅくあん 宿案"
"しゅくい 宿意 祝意"
"しゅくうん 宿運"
"しゅくえい 宿営"
"しゅくえき 宿駅"
"しゅくえん 祝筵 宿怨 宿縁 祝宴"
"しゅくが 祝賀"
"しゅくがく 宿学"
"しゅくがわ 夙川"
"しゅくがわら 宿河原"
"しゅくがん 宿願"
"しゅくき 淑気"
"しゅくぎ 祝儀"
"しゅくぐち 宿口"
"しゅくぐん 粛軍"
"しゅくけい 粛啓"
"しゅくけいえん 縮景園"
"しゅくげん 縮減"
"しゅくこ 祝子"
"しゅくこんそう 宿根草"
"しゅくごう 宿業 縮合"
"しゅくさい 祝祭"
"しゅくさつ 粛殺 縮刷"
"しゅくざい 宿罪"
"しゅくし 宿紙 宿志 祝詞"
"しゅくしゃ 縮砂 縮写 宿舎"
"しゅくしゃく 縮尺"
"しゅくしゅ 宿主"
"しゅくしゅく 粛粛 粛々"
"しゅくしょ 宿所"
"しゅくしょう 祝捷 祝勝 縮小"
"しゅくしん 粛慎"
"しゅくじ 祝辞"
"しゅくじつ 祝日"
"しゅくじょ 淑女"
"しゅくすい 宿酔"
"しゅくず 縮図"
"しゅくせ 宿世"
"しゅくせい 祝聖 宿星 粛正 粛清"
"しゅくせつ 宿雪 祝節"
"しゅくぜん 宿善 粛然"
"しゅくたい 縮退"
"しゅくだい 宿題"
"しゅくちょく 宿直"
"しゅくてき 宿敵"
"しゅくてん 祝典"
"しゅくでん 祝電"
"しゅくとう 粛党 祝祷"
"しゅくとく 淑徳"
"しゅくどう 縮瞳"
"しゅくにっちょく 宿日直"
"しゅくはい 祝杯"
"しゅくはく 宿泊"
"しゅくはくぷらん 宿泊プラン"
"しゅくば 宿場"
"しゅくびょう 宿病"
"しゅくふく 祝福"
"しゅくぶん 祝文"
"しゅくへい 宿弊"
"しゅくべつ 祝別"
"しゅくべん 宿便"
"しゅくほう 祝砲"
"しゅくぼう 宿望 宿坊"
"しゅくまる 宿丸"
"しゅくみょう 宿命"
"しゅくめい 宿命"
"しゅくもう 縮毛"
"しゅくや 夙夜"
"しゅくやく 縮約"
"しゅくよう 宿曜"
"しゅくりょう 宿料"
"しゅくろう 宿老"
"しゅくん 殊勲 主君"
"しゅぐう 殊遇"
"しゅけい 主刑 主系 主計"
"しゅけいかん 主計監"
"しゅけいせい 種形成"
"しゅけいりょう 主計寮"
"しゅけいれつせい 主系列星"
"しゅけん 主権"
"しゅけんざいみん 主権在民"
"しゅげい 手芸"
"しゅげた 主桁"
"しゅげん 修験"
"しゅげんじゃ 修験者"
"しゅこ 朱子"
"しゅこう 殊功 珠孔 手稿 手交 首肯 手工 酒肴 趣向"
"しゅこつ 手骨"
"しゅこん 酒魂 主根"
"しゅこんかんしょうこうぐん 手根管症候群"
"しゅご 主語 守護"
"しゅごう 酒豪"
"しゅごしん 守護神"
"しゅごじん 守護神"
"しゅごせい 守護星"
"しゅごれい 守護霊"
"しゅさ 主鎖 種差 主査"
"しゅさい 主祭 主菜 主宰 主催"
"しゅさん 酒盞"
"しゅざ 主座 首座"
"しゅざい 首罪 主剤 取材"
"しゅざん 珠算"
"しゅし 酒肆 繻竢 銖錙 殊死 朱子 手指 種子 主旨 趣旨"
"しゅしきぼん 手識本"
"しゅしゃ 種車 手写 取捨"
"しゅしゃかい 種社会"
"しゅしゅ 守株 種々"
"しゅしゅつ 輸出"
"しゅしょ 首書 手書 朱書"
"しゅしょう 修正 酒漿 首将 首唱 手掌 主唱 殊勝 主将 首相"
"しゅしょく 手燭 酒色 酒食 主食"
"しゅしん 珠心 朱唇 酒神 主神 主審"
"しゅしんか 種進化"
"しゅじ 主餌 主辞 朱字 主事"
"しゅじい 主治医"
"しゅじく 主軸"
"しゅじつ 手実 種実 主日"
"しゅじゃく 朱雀"
"しゅじゅ 種種 侏儒 種々"
"しゅじゅう 主従"
"しゅじゅつ 主述 手術"
"しゅじょう 主情 主上 衆生"
"しゅじん 主人"
"しゅじんこう 主人公"
"しゅす 繻子"
"しゅすい 取水"
"しゅすいとう 取水塔"
"しゅすう 種数"
"しゅすじ 主筋"
"しゅずみ 朱墨"
"しゅせい 首星 主星 守成 守勢 酒精"
"しゅせき 手蹟 酒石 手跡 酒席 首席 主席"
"しゅせきえい 酒石英"
"しゅせつ 守節 主節"
"しゅせん 酒戦 守戦 酒仙 主戦"
"しゅせんど 守銭奴"
"しゅぜい 主税 酒税"
"しゅぜいりょう 主税寮"
"しゅぜん 鬚髯 修善 修禅 主膳 酒膳"
"しゅぜんたい 種全体"
"しゅそ 首座 主訴"
"しゅそう 主相"
"しゅそうじゅつ 手相術"
"しゅそりょうたん 首鼠両端"
"しゅぞう 酒蔵 酒造"
"しゅぞく 種族"
"しゅたい 主体"
"しゅたく 手沢"
"しゅたる 主たる"
"しゅだい 主代 腫大 首題 主題"
"しゅだつ 須達"
"しゅだん 手段"
"しゅち 恤 趣致 主値 主知"
"しゅちく 種畜"
"しゅちにくりん 酒池肉林"
"しゅちゅう 主柱 手中"
"しゅちょ 主著"
"しゅちょう 殊寵 主潮 主調 主徴 朱鳥 腫脹 首長 主張"
"しゅっか 出火 出荷"
"しゅっかん 出棺"
"しゅっきょ 卒去"
"しゅっきょう 出京 出郷"
"しゅっきん 出金 出勤"
"しゅっけ 出家"
"しゅっけっせき 出欠席"
"しゅっけつ 出欠 出血"
"しゅっこ 出庫"
"しゅっこう 出講 出稿 出航 出港 出向"
"しゅっこく 出国"
"しゅっこつ 倏忽"
"しゅっこんそう 宿根草"
"しゅっさつ 出札"
"しゅっさん 出産"
"しゅっさんいわい 出産祝"
"しゅっし 出仕 出資"
"しゅっしゃ 出車 出射 出社"
"しゅっしょ 出処 出所"
"しゅっしょう 出生"
"しゅっしょうぜんしんだん 出生前診断"
"しゅっしょく 出食 出色"
"しゅっしん 出身"
"しゅっすい 出穂 出水"
"しゅっせ 出瀬 出世"
"しゅっせい 出精 出征 出生"
"しゅっせいぜんしんだん 出生前診断"
"しゅっせいまえしんだん 出生前診断"
"しゅっせうお 出世魚"
"しゅっせき 出席"
"しゅっそう 出槽 出走"
"しゅっそうば 出走馬"
"しゅっそうよていば 出走予定馬"
"しゅったい 出来"
"しゅったいきん 出退勤"
"しゅったつ 出立"
"しゅったん 出炭"
"しゅっちょう 出超 出張"
"しゅっちん 出陳"
"しゅってい 出艇 出廷"
"しゅってん 出典 出店 出展"
"しゅっとう 出頭"
"しゅっぱつ 出発"
"しゅっぱん 出帆 出版"
"しゅっぱんのじゆう 出版の自由"
"しゅっぱんふ 出版譜"
"しゅっぴ 出費"
"しゅっぴつ 出筆"
"しゅっぴん 出品"
"しゅっぷ 出府"
"しゅっぺい 出兵"
"しゅっぽん 出奔"
"しゅつ 卆 恤 蟀 出"
"しゅつえき 出役"
"しゅつえじぷとき 出エジプト記"
"しゅつえん 出捐 出演"
"しゅつが 出駕 出芽"
"しゅつがん 出願"
"しゅつぎょ 出御"
"しゅつけっせき 出欠席"
"しゅつげき 出撃"
"しゅつげん 出現"
"しゅつごく 出獄"
"しゅつざん 出山"
"しゅつじ 出自"
"しゅつじょう 出定 出状 出場"
"しゅつじょうこうご 出定後語"
"しゅつじょうば 出場馬"
"しゅつじん 出陣"
"しゅつだい 出題"
"しゅつど 出土"
"しゅつどう 出動"
"しゅつにゅう 出入"
"しゅつのう 出納"
"しゅつば 出馬"
"しゅつぼつ 出没"
"しゅつむ 出務"
"しゅつもくよそう 出目予想"
"しゅつもん 出門"
"しゅつらい 出来"
"しゅつらん 出藍"
"しゅつり 出離"
"しゅつりょう 出猟 出漁"
"しゅつりょく 出力"
"しゅつりょくくらす 出力クラス"
"しゅつりょくたん 出力端"
"しゅつるい 出塁"
"しゅてん 主典 主点 朱点"
"しゅてんどうじ 手天童子 酒呑童子"
"しゅでい 朱泥"
"しゅでん 主殿"
"しゅでんりょう 主殿寮"
"しゅと 酒徒 首途 首都"
"しゅとう 首藤 手套 酒盗 手刀 種痘"
"しゅとく 取得"
"しゅとして 主として"
"しゅどう 衆道 主動 首藤 主導 手動"
"しゅどく 酒毒"
"しゅにく 酒肉 朱肉"
"しゅにん 主任"
"しゅぬり 朱塗り"
"しゅのう 主脳 首脳"
"しゅのうはんたい 酒嚢飯袋"
"しゅはい 酒盃 手背 酒杯"
"しゅはく 手搏"
"しゅはん 酒飯 首班 主犯"
"しゅば 種馬"
"しゅばい 酒売"
"しゅひ 種肥 珠皮 種皮 守秘"
"しゅひつ 朱筆 主筆"
"しゅひん 主賓"
"しゅび 首尾 守備"
"しゅびがため 守備固め"
"しゅびき 朱引き 朱引"
"しゅびょう 種苗"
"しゅびよく 首尾よく"
"しゅふ 首府 主夫 主婦"
"しゅふく 首服"
"しゅぶ 主部 首部"
"しゅぶつ 主物"
"しゅぶん 主文"
"しゅへい 珠柄 守兵 手兵"
"しゅへき 酒癖"
"しゅべつ 種別"
"しゅほ 酒保"
"しゅほう 修法 主峰 主砲 手法"
"しゅぼ 酒母"
"しゅぼう 酒坊 主謀 首謀 酒房"
"しゅぼくてん 朱墨点"
"しゅぼば 種牡馬"
"しゅまい 酒米"
"しゅまつ 朱抹"
"しゅみ 須弥 趣味"
"しゅみせん 須弥山"
"しゅみだん 須弥壇"
"しゅみゃく 主脈"
"しゅむ 主務"
"しゅめ 主馬"
"しゅめーるご シュメール語"
"しゅめーるじん シュメール人"
"しゅめい 主命 種名"
"しゅめもり 主メモリ"
"しゅもーど 主モード"
"しゅもく 撞木 種目"
"しゅもくざめ 撞木鮫"
"しゅもくづえ 撞木杖"
"しゅもつ 腫物"
"しゅもん 朱門"
"しゅやく 主薬 主役"
"しゅゆ 須臾"
"しゅよう 須要 主用 腫瘍 主要"
"しゅよく 主翼"
"しゅら 修羅"
"しゅらい 周礼"
"しゅらん 酒乱"
"しゅり 修理 首里"
"しゅりけん 手裏剣"
"しゅりはんどく 周利槃特"
"しゅりゅう 腫瘤 主流"
"しゅりゅうえん 主流煙"
"しゅりゅうだん 手榴弾"
"しゅりょう 酒量 首領 狩猟"
"しゅりょうけん 狩猟犬"
"しゅりょうじゅう 狩猟銃 狩猟獣"
"しゅりょく 主力"
"しゅりょくこう 主力行"
"しゅるい 酒類 種類"
"しゅれいもん 守礼門"
"しゅれん 手練"
"しゅろ 椶櫚 棕櫚"
"しゅろう 酒楼"
"しゅろちく 棕櫚竹"
"しゅわ 手話"
"しゅわん 手腕"
"しゅわんさいぼう シュワン細胞"
"しゅん 筍 濬 墫 蠢 惷 儁 雋 逡 皴 浚 悛 駿 竣 峻 俊 蕣 舜 瞬 春 旬"
"しゅんい 春意"
"しゅんいち 峻一 俊一"
"しゅんいちろう 俊一朗"
"しゅんう 春雨"
"しゅんえい 俊英"
"しゅんか 春歌 春霞 春夏"
"しゅんかしょり 春化処理"
"しゅんかどう 春華堂"
"しゅんかん 笋干 笋羹 筍干 春官 春寒 瞬間"
"しゅんかんそうずしまものがたり 俊寛僧都島物語"
"しゅんが 春画"
"しゅんき 峻輝 春気 春機 春期 春季"
"しゅんきち 駿吉"
"しゅんきゅう 春宮"
"しゅんきょ 峻拒"
"しゅんきょう 春興"
"しゅんきんしょう 春琴抄"
"しゅんぎく 春菊"
"しゅんぎょ 旬魚"
"しゅんぎょう 春業 春暁"
"しゅんけい 春景"
"しゅんけつ 俊傑"
"しゅんけん 峻嶮 峻険"
"しゅんげざい 峻下剤"
"しゅんげつ 春月"
"しゅんげん 峻厳"
"しゅんこう 竣功 春光 竣工"
"しゅんこく 瞬刻"
"しゅんさい 俊才"
"しゅんさつ 瞬殺"
"しゅんざい 春材"
"しゅんしゅう 春愁 俊秀"
"しゅんしょ 春初"
"しゅんしょう 春宵"
"しゅんしょく 春色"
"しゅんしん 春心 舜臣"
"しゅんじ 俊司 俊次 俊治 俊二 瞬時"
"しゅんじつ 春日"
"しゅんじゅう 春秋"
"しゅんじゅん 逡巡"
"しゅんじょう 春情"
"しゅんすい 旬粋"
"しゅんすけ 俊亮 俊輔 俊介"
"しゅんせい 俊成 竣成"
"しゅんせつ 春雪 春節 浚渫"
"しゅんぜん 春前"
"しゅんそく 瞬息 駿足 俊足"
"しゅんぞう 俊三"
"しゅんたろう 俊太郎"
"しゅんだん 春暖 瞬断"
"しゅんちょう 春鳥"
"しゅんつ 順子"
"しゅんてい 瞬停"
"しゅんてつ 俊哲"
"しゅんでい 春泥"
"しゅんでん 瞬電"
"しゅんとう 春闘"
"しゅんどう 春藤 蠢動"
"しゅんば 駿馬"
"しゅんぱつりょく 瞬発力"
"しゅんびん 俊敏"
"しゅんぶん 春分"
"しゅんぶんのひ 春分の日"
"しゅんぷう 春風"
"しゅんぷく 春服"
"しゅんべつ 峻別"
"しゅんぼう 俊髦"
"しゅんぽん 春本"
"しゅんみん 春眠"
"しゅんむ 春夢"
"しゅんめ 駿馬"
"しゅんや 春夜"
"しゅんよう 春陽"
"しゅんらい 春雷"
"しゅんらん 春蘭"
"しゅんれい 峻嶺"
"しゅんれつ 峻烈"
"しゅんろう 隼朗 春郎 隼郎 俊朗"
"しゆう 子游 詩友 師友 市有 私有 雌雄"
"しゆうりん 私有林"
"しょ 苜 處 蜍 胥 嶼 墅 黍 杵 雎 苴 砠 狙 岨 且 藷 薯 渚 曙 蔗 庶 暑 処 緒 諸 署 書 初 所"
"しょーろんぽう 小籠包"
"しょあく 諸悪"
"しょあくまくさ 諸悪莫作"
"しょい 所為 所謂"
"しょいこ 背負子"
"しょいちねん 初一念"
"しょいり 初入"
"しょいん 書淫 署員 所員 書院"
"しょいんづくり 書院造"
"しょいんぼん 初印本"
"しょう 鯖 錆 精 清 青 政 正 生 星 姓 猩 聲 声 井 愴 上 腫 橡 象 稱 證 鷦 餉 舂 浹 庠 燮 剿 秤 筱 篠 咲 誦 椒 渉 陞 昇 捷 承 尚 湫 愀 鍬 廂 湘 鈔 炒 竦 悚 摺 慴 翔 憧 鐘 觴 殤 慯 傷 聳 樅 従 燒 焼 鬆 淞 訟 枩 松 蕭 瀟 嘯 裳 掌 甞 嘗 霄 銷 逍 誚 稍 悄 峭 蛸 鞘 肖 硝 消 梢 宵 哨 韶 邵 劭 詔 紹 照 沼 招 召 橸 晶 猖 倡 菖 娼 唱 昌 瘴 璋 嶂 障 樟 彰 憔 蕉 礁 樵 焦 薔 艢 檣 墻 牆 鍾 衝 霎 妾 顳 懾 囁 敞 厰 廠 鏘 漿 將 獎 奬 奨 醤 蒋 妝 牀 爿 装 荘 祥 詳 償 粧 庄 笑 勝 匠 床 升 昭 頌 鉦 簫 笙 性 抄 相 省 章 症 証 称 少 小 商 将 賞"
"しょうあい 鍾愛"
"しょうあく 小悪 性悪 掌握"
"しょうあじあ 小アジア"
"しょうあつ 昇圧"
"しょうあん 硝安 承安 正安"
"しょうい 焼夷 傷痍 小異 少尉"
"しょういだん 燒夷彈 焼夷弾"
"しょういち 小1 小１ 小一 昭市 省一 庄一 章一 祥一 昇一 彰一 昌一 昭一 正一"
"しょういん 小飲 承引 小引 正院 松蔭 証印 勝因"
"しょうう 請雨 生有 少雨 小雨"
"しょううん 昌運 勝運"
"しょうえ 庄衛"
"しょうえい 庄衛 昌栄 庄栄 昭栄 頌栄"
"しょうえいしゃ 翔泳社"
"しょうえき 小駅 昌益 省益 漿液"
"しょうえきち 承役地"
"しょうえね 省エネ"
"しょうえねるぎー 省エネルギー"
"しょうえん 瘴煙 鞘炎 招宴 庄園 小円 小宴 硝煙 小園 荘園 消炎"
"しょうえんじ 生臙脂"
"しょうお 尚夫"
"しょうおう 蕉翁 商鞅 正応 承応 勝央 照応"
"しょうおく 小屋"
"しょうおん 昇温 消音"
"しょうか 小舸 昌華 証果 漿果 銷夏 消夏 小過 正嘉 娼家 小家 小花 硝化 頌歌 商科 商家 昇華 唱歌 消火 消化"
"しょうかい 小海 哨戒 詳解 商会 照会 紹介"
"しょうかいしんご 捷解新語"
"しょうかいせき 蒋介石"
"しょうかく 省画 衝角 翔鶴 昇格"
"しょうかこう 松花江"
"しょうかせいかいよう 消化性潰瘍"
"しょうかせん 松果腺 消火栓"
"しょうかそんじゅく 松下村塾"
"しょうかたい 松果体"
"しょうかっこ ） （"
"しょうかどう 松花堂"
"しょうかぶ 正株"
"しょうかぼう 裳華房"
"しょうかわ 荘川"
"しょうかん 少閑 小閑 松幹 消閑 招喚 荘官 小缶 小官 小寒 将官 娼館 商館 召還 召喚 償還"
"しょうかんしゅう 商慣習"
"しょうかんろん 傷寒論"
"しょうが 薑 生薑 小雅 小我 唱歌 生姜"
"しょうがい 生害 障礙 障碍 渉外 傷害 生涯 障害"
"しょうがいば 障害馬"
"しょうがく 正覚 商学 小額 奨学 少額 小学"
"しょうがつ 正月"
"しょうがもく ショウガ目"
"しょうがやき 生姜焼"
"しょうがわ 庄川"
"しょうがん 賞玩 賞翫"
"しょうき 焼燬 匠気 将器 詳記 小器 鍾馗 正機 商機 笑気 瘴気 勝機 正気"
"しょうきく 松菊"
"しょうきち 昭吉 正吉 小吉"
"しょうきゃく 正客 消却 償却 焼却"
"しょうきゅう 小球 承久 昇級 昇給"
"しょうきょ 消去"
"しょうきょう 小凶 商況 正慶"
"しょうきょうれんごう 勝共連合"
"しょうきょく 唱曲 小曲 消極"
"しょうきん 渉禽 償金 正金 賞金"
"しょうきんくび 賞金首"
"しょうぎ 牀几 勝義 小義 象棋 娼妓 床几 省議 商議 将棋"
"しょうぎさし 将棋指し"
"しょうぎだおし 将棋倒し"
"しょうぎばん 将棋板"
"しょうぎまつり 将棋祭"
"しょうぎょ 松魚 椒魚"
"しょうぎょう 聖教 商業"
"しょうぎょうびる 商業ビル"
"しょうぎん 商銀"
"しょうく 小躯 章句"
"しょうくうかん 商空間"
"しょうくうとう 照空灯"
"しょうぐん 小郡 将軍"
"しょうぐんづか 将軍塚"
"しょうけい 捷勁 小逕 商計 松径 少頃 祥慶 紹継 小慧 少憩 祥啓 尚絅 上卿 捷径 小経 小憩 勝景 昌慶 正慶 鐘形 晶系 小景 象形 憧憬 小径 承継 小計"
"しょうけつ 燒結 猖獗 焼結"
"しょうけん 證券 商権 正見 小見 正絹 商圏 証券"
"しょうけんとりひきとうかんしいいんかい 証券取引等監視委員会"
"しょうけんろう 笑犬樓 笑犬楼"
"しょうげ 障礙 障碍"
"しょうげき 小隙 笑劇 衝撃"
"しょうげん 詳言 承元 正元 象限 将監 証言"
"しょうこ 證拠 宵子 抄子 省子 しょう子 昌己 荘子 章子 昌子 晶子 尚子 聖子 翔子 祥子 商估 商賈 小戸 鉦鼓 称呼 尚古 証拠"
"しょうこあつめ 証拠集め"
"しょうこう 銷耗 照校 昭晃 小功 焼光 消耗 昇汞 召公 少考 小稿 小考 商港 消光 紹興 商高 症候 焼香 小康 将校 昇降 商工"
"しょうこうい 商行為"
"しょうこうだ 昇降舵"
"しょうこうつうしょう 昭光通商"
"しょうこうてん 昇交点"
"しょうこうてんのう 称光天皇"
"しょうこうねつ 猩紅熱"
"しょうこうほ 賞候補"
"しょうこうろーん 商工ローン"
"しょうこうろう 小紅楼"
"しょうこく 生国 相国 小国"
"しょうこつ 掌骨 踵骨"
"しょうこり 性懲り"
"しょうこん 招魂 性根 傷痕 商魂"
"しょうご 笑語 小語 小5 小５ 小五 尚五 祥悟 昌吾 翔吾 昭吾 祥吾 正吾 省吾 証悟 正午"
"しょうごいん 聖護院"
"しょうごう 稱號 正業 照合 商号 称号"
"しょうごうさくせん 捷号作戰"
"しょうごく 生国 小国"
"しょうごん 荘厳"
"しょうさ 小差 照査 証左 少佐"
"しょうさい 小祭 小才 省際 商才 詳細"
"しょうさいことう 小柴胡湯"
"しょうさかん 小属"
"しょうさく 昇作 小策"
"しょうさつ 小冊 笑殺 省察"
"しょうさん 少産 賞讃 消散 小三 勝算 称賛 硝酸 小3 小３ 賞賛"
"しょうざい 商材 小罪"
"しょうざき 庄崎"
"しょうざぶろう 正三郎"
"しょうざんかん 勝山館"
"しょうし 少史 頌詩 小詩 賞賜 昇志 少死 賞詞 尚士 抄紙 省資 将士 尚志 硝子 生死 小史 笑止 少子 焼死 証紙"
"しょうしつ 銷失 焼失 消失"
"しょうしもく 鞘翅目"
"しょうしゃ 抄写 哨舎 傷者 瀟洒 小社 照射 勝者 商社"
"しょうしゃく 小尺 焼灼"
"しょうしゅ 漿酒"
"しょうしゅう 召集 招集 消臭"
"しょうしゅうかん 商習慣"
"しょうしゅうごう 商集合"
"しょうしゅつ 晶出 抄出"
"しょうしゅん 頌春"
"しょうしょ 召書 抄書 鈔書 哨所 小暑 尚書 詔書 証書"
"しょうしょう 悚悚 詔召 小哨 蕭牆 鏘鏘 省掌 小升 商聖 小祥 昌昌 彰彰 章章 昭昭 悄々 悄悄 少小 瀟湘 小照 将相 晶晶 蕭々 蕭蕭 少少 小将 小々 小小 少将 少々"
"しょうしょく 粧飾 小職 少食 小食"
"しょうしん 衝心 焦心 小身 焼身 正真 小心 傷心 昇進"
"しょうしんげ 正信偈"
"しょうしんさいん 賞審査員"
"しょうしんよくよく 小心翼翼"
"しょうじ 祥之 捷二 彰治 祥治 昇二 尚司 昇治 将司 勝治 昭司 章司 昇司 尚史 正次 庄子 昌二 昭次 荘司 章二 昭治 正二 東海林 昭二 正治 庄司 賞辞 頌辞 尚侍 少時 小事 小字 精進 小児 生死 小路 消磁 正時 障子 商事"
"しょうじき 正直"
"しょうじこ 精進湖"
"しょうじそくねはん 生死即涅槃"
"しょうじつ 消日"
"しょうじま 生島"
"しょうじゃ 盛者 精舎 生者"
"しょうじゃく 小弱 正雀"
"しょうじゅ 聖衆 松樹"
"しょうじゅう 小獣 聖衆 小銃"
"しょうじゅしょうしゃ 賞受賞者"
"しょうじゅつ 賞恤 詳述"
"しょうじゅん 照準 昇順"
"しょうじょ 小序 翔女 消除 少女"
"しょうじょあにめ 少女アニメ"
"しょうじょう 霄壌 招状 蕭条 商状 清浄 猩猩 猩々 掌上 掌状 小乗 賞状 症状"
"しょうじょうせぜ 生々世々 生生世世"
"しょうじょうひ 猩々緋"
"しょうじょうみゃく 掌状脈"
"しょうじょうるてん 生々流転 生生流転"
"しょうじょまんが 少女マンガ"
"しょうじろう 章治郎 彰二郎 象二郎"
"しょうじん 生身 焼尽 消尽 小人 精進"
"しょうじんあげ 精進揚"
"しょうすい 少水 消衰 将帥 松翠 小水 憔悴"
"しょうすう 勝数 小数 少数"
"しょうすうしい 小四喜"
"しょうすけ 昭助 正助 庄助"
"しょうず 小豆"
"しょうずい 祥瑞"
"しょうせい 称制 勝勢 照星 小成 将星 笑声 招請 焼成 小生"
"しょうせいこん 招婿婚"
"しょうせき 鐘石 硝石 証跡"
"しょうせきのうほうしょう 掌蹠膿疱症"
"しょうせっかい 消石灰"
"しょうせつ 章節 消雪 小雪 詳説 小節 小説"
"しょうせん 省線 商船 商戦"
"しょうせんきょう 昇仙峡"
"しょうぜつ 勝絶"
"しょうぜん 哨然 小全 竦然 悚然 蕭然 性善 小善 悄然 承前"
"しょうそ 勝訴"
"しょうそう 悄愴 傷愴 焦躁 少壮 尚早 焦燥"
"しょうそういん 正倉院"
"しょうそく 消息"
"しょうそつ 小卒 将卒"
"しょうそん 焼損"
"しょうぞう 小像 正像 省造 捷三 彰三 勝三 尚三 正蔵 正三 昭三 省三 肖像"
"しょうぞういん 正倉院"
"しょうぞく 装束"
"しょうた 章太 正太 翔太"
"しょうたい 請待 商体 昌泰 消退 小体 小隊 招待 正体"
"しょうたいば 招待馬"
"しょうたく 妾宅 沼沢"
"しょうたろう 承太郎 昭太郎"
"しょうたん 賞嘆"
"しょうたんい 章単位"
"しょうだ 掌打 庄田 正田"
"しょうだい 掌大 昭代 正代 小代 昌代 唱題 章題 商大 招提"
"しょうだいやき 小岱焼 小代焼"
"しょうだく 承諾"
"しょうだて 章立て"
"しょうだん 笑談 昇段 商談"
"しょうち 召致 小知 勝地 招致 承知"
"しょうちく 小竹 松竹"
"しょうちくばい 松竹梅"
"しょうちのすけ 承知の助"
"しょうちゃんぼう 正ちゃん帽"
"しょうちゅう 掌中 正中 焼酎 小中"
"しょうちょ 小著"
"しょうちょう 省疔 正長 消長 小腸 省庁 象徴"
"しょうちょうし 象徴詩"
"しょうちょく 詔勅"
"しょうちん 銷沈 消沈"
"しょうつき 祥月"
"しょうてい 小亭 小弟 掌底"
"しょうていぎょくはく 鐘鼎玉帛"
"しょうてき 小敵"
"しょうてきほう 小滴法"
"しょうてすと 小テスト"
"しょうてつものがたり 正徹物語"
"しょうてん 声点 消点 衝天 小篆 小店 聖天 笑点 昇天 焦点 商店"
"しょうでん 招電 召電 小電 昭電 詳伝 省電 昇殿 小伝"
"しょうでんしゃ 祥伝社"
"しょうと 商都 省都"
"しょうとう 昇騰 檣頭 鐘塔 消燈 松濤 小刀 消灯"
"しょうとうしょう 小頭症"
"しょうとく 称徳 承徳 生得 正徳 聖徳"
"しょうとつ 衝突"
"しょうとつこん 衝突痕"
"しょうとり 証取 商取"
"しょうとりひき 商取引"
"しょうど 焼土 焦土 照度"
"しょうどう 聳動 章動 晶洞 聖道 小道 唱道 唱導 正道 衝動"
"しょうどうとく 商道徳"
"しょうどく 誦読 消毒"
"しょうどくかい 抄読会"
"しょうどしま 小豆島"
"しょうどじま 小豆島"
"しょうない 渉内 荘内 省内 庄内"
"しょうなり 小なり ＜ ≦"
"しょうなん 小難 沼南 湘南"
"しょうに 少弐 小2 小２ 小二 小児"
"しょうにがん 小児ガン 小児がん 小児癌"
"しょうにく 正肉"
"しょうにゅう 鍾乳"
"しょうにゅうどう 鐘乳洞 鍾乳洞"
"しょうにん 小人 昇任 聖人 上人 証人 商人 承認"
"しょうね 性根"
"しょうねつ 焦熱"
"しょうねん 正念 生年 少年"
"しょうねんいん 少年院"
"しょうねんまんが 少年マンガ"
"しょうの 笙野 庄野"
"しょうのう 笑納 小農 樟脳 小脳"
"しょうのすけ 庄之助"
"しょうは 小破 消波"
"しょうはい 招牌 少牌 賞杯 賞牌 勝敗"
"しょうはく 蕭白 松柏"
"しょうはち 正八"
"しょうはぶろっく 消波ブロック"
"しょうはん 小藩"
"しょうばい 商売"
"しょうばいおんな 商売女"
"しょうばいがたき 商売敵"
"しょうばいぎ 商売気"
"しょうばたけ 正畠"
"しょうばつ 賞罰"
"しょうばら 庄原"
"しょうばん 承盤 相伴 床版 床板"
"しょうばんごう 章番号"
"しょうひ 消費"
"しょうひしゃせんたー 消費者センター"
"しょうひつ 省筆"
"しょうひょう 賞表 証憑 証票 商標"
"しょうひん 小品 賞品 商品"
"しょうび 薔薇 賞美 焦眉"
"しょうびのきゅう 焦眉の急"
"しょうびょう 傷病"
"しょうびん 小瓶 翡翠"
"しょうふ 娼婦"
"しょうふう 蕉風"
"しょうふうろうげつ 嘯風弄月"
"しょうふく 慴伏 承伏 妾腹 小幅 承服 招福"
"しょうふくてい 笑福亭"
"しょうふだ 正札"
"しょうぶ 尚武 菖蒲 正夫 勝負"
"しょうぶうん 勝負運"
"しょうぶかん 勝負勘"
"しょうぶつ 正物 生仏"
"しょうぶぱんつ 勝負パンツ"
"しょうぶん 昌文 小文 性分"
"しょうぶんかん 松文館"
"しょうぶんしゃ 晶文社 昭文社"
"しょうへい 招へい 哨兵 傷兵 承平 章平 笑瓶 小兵 省平 昭平 将兵 昇平 正平 昌平 招聘"
"しょうへいが 障屏画"
"しょうへいこう 昌平黌"
"しょうへき 墻壁 牆壁 晶癖 障壁"
"しょうへん 爿偏 小篇 掌篇 小変 小編 掌編 小片"
"しょうべつ 小別"
"しょうべん 少弁 小便"
"しょうほーる 小ホール"
"しょうほう 捷報 勝報 承保 小胞 唱法 正保 詳報 商法"
"しょうほうじ 正法地"
"しょうほうてん 商法典"
"しょうほく 勝北"
"しょうほん 証本 小本 正本 抄本"
"しょうぼ 召募"
"しょうぼう 焼亡 小房 正法 消防"
"しょうま 消磨"
"しょうまく 漿膜"
"しょうまつ 章末"
"しょうまる 正丸"
"しょうまん 正満 小満"
"しょうみ 正味 賞味"
"しょうみつ 詳密"
"しょうみゃく 小脈"
"しょうみょう 唱名 称名 小名 声明"
"しょうむ 商務"
"しょうむてんのう 聖武天皇"
"しょうめい 證明 正銘 鐘銘 章名 召命 照明 証明"
"しょうめいおわり 証明終"
"しょうめいぎ 証明木"
"しょうめいしすてむ 証明システム"
"しょうめいだん 照明弾"
"しょうめいとう 照明燈"
"しょうめつ 生滅 消滅"
"しょうめん 生面 小面 正面"
"しょうめんきって 正面切って"
"しょうめんまど 正面窓"
"しょうもう 睫毛 消耗"
"しょうもつ 抄物"
"しょうもの 抄物"
"しょうもん 掌紋 蕉門 小問 声聞 正文 証文"
"しょうもんき 将門記"
"しょうや 庄屋"
"しょうやく 硝薬 小役 抄訳 生薬"
"しょうやま 正山 庄山"
"しょうゆ 醤油"
"しょうゆう 小勇 少輔"
"しょうゆさし 醤油差し"
"しょうゆづけ 醤油漬"
"しょうゆらーめん 醤油ラーメン"
"しょうよ 賞与"
"しょうよう 縦容 賞用 賞揚 従容 慫慂 小葉 照葉 称揚 逍遥 小用 商用"
"しょうようじゅ 照葉樹"
"しょうようびざ 商用ビザ"
"しょうよく 小欲"
"しょうよん 小4 小４ 小四"
"しょうら 初裏"
"しょうらい 請来 松籟 招来 生来 将来"
"しょうらん 照覧 笑覧"
"しょうり 小吏 捷利 小利 掌理 勝利"
"しょうりき 正力"
"しょうりつ 聳立 勝率"
"しょうりゃく 商略 承暦 正暦 省略"
"しょうりゅう 小流 昇竜 昇龍"
"しょうりゅうぎょ 昇流魚"
"しょうりょ 焦慮"
"しょうりょう 将領 商量 聖霊 精霊 松陵 渉猟 小量 少量"
"しょうりょうだな 精霊棚"
"しょうりょうぶね 精霊舟"
"しょうりょく 省力"
"しょうりん 少林 松林"
"しょうるい 生類"
"しょうるいあわれみのれい 生類憐みの令"
"しょうれい 勝令 瘴癘 省令 奨励 症例"
"しょうれんげ 青蓮華"
"しょうろ 捷路 松露"
"しょうろう 精霊 鐘楼"
"しょうろうびょうし 生老病死"
"しょうろく 小6 小６ 小六 詳録 小禄 抄録"
"しょうろん 詳論 小論"
"しょうろんぽう 小籠包"
"しょうわ 倡和 承和 笑話 唱和 庄和 小話 正和 昭和"
"しょうわしぇるせきゆ 昭和シェル石油"
"しょうわしんざん 昭和新山"
"しょうわり 章割り"
"しょうわる 性悪"
"しょうわん 小彎"
"しょえ 所依 初会"
"しょえん 諸縁 所縁 初演"
"しょおう 諸王"
"しょおく 書屋"
"しょおもて 初表"
"しょおり 初折"
"しょか 諸家 書家 書架 初夏"
"しょかい 所懷 所懐 初会 初回"
"しょかつ 諸葛 所轄"
"しょかつりょう 諸葛亮"
"しょかん 書函 初寒 初巻 書巻 初刊 書翰 書館 所感 書簡 所管"
"しょかんせん 書簡箋"
"しょかんたいしょうせつ 書簡体小説"
"しょかんばこ 書簡箱"
"しょが 書画"
"しょがい 書外 所外"
"しょがかり 諸掛り 諸掛"
"しょがく 所学 初学 諸学"
"しょがん 所願"
"しょき 書櫃 所記 暑気 書紀 所期 書記 初期"
"しょきあたり 暑気中り"
"しょきかんちょう 書記官鳥"
"しょきゅう 書笈 雎鳩 初給 初球 初級"
"しょきょう 書経"
"しょぎ 所議"
"しょぎしょ 枌所"
"しょぎょう 所行 諸行 所業"
"しょく 喰 昃 寔 贖 織 餝 飾 穡 嗇 謖 稷 禝 軾 拭 稙 殖 植 埴 矚 燭 囑 嘱 屬 属 蝕 觸 触 蜀 初句 色 職 食"
"しょくあたり 食中り"
"しょくあつ 触圧"
"しょくあん 職安"
"しょくい 職位"
"しょくいき 職域"
"しょくいく 食育"
"しょくいん 職印 職員"
"しょくえ 触穢"
"しょくえん 食鹽 食塩"
"しょくおや 職親"
"しょくかい 職階"
"しょくがい 食害"
"しょくがん 食玩"
"しょくぎょう 職業"
"しょくぎょうせんたくのじゆう 職業選択の自由"
"しょくぎれ 食切れ"
"しょくぐん 職群"
"しょくげん 飾言 食言"
"しょくご 食後"
"しょくごせんわかしゅう 続後撰和歌集"
"しょくさい 食彩 植栽"
"しょくさいぼう 食細胞"
"しょくさいりん 植栽林"
"しょくさつ 喰殺"
"しょくさよう 食作用"
"しょくさん 殖産"
"しょくさんじん 蜀山人"
"しょくざい 殖財 贖罪 食材"
"しょくし 食指"
"しょくしつ 職質"
"しょくしないしんのう 式子内親王"
"しょくしゅ 蝕手 触手 職種"
"しょくしょう 職掌 食傷"
"しょくしん 触診"
"しょくじ 植字 食餌 食事"
"しょくじゅ 植樹"
"しょくじゅう 職住"
"しょくじょ 織女"
"しょくじょせい 織女星"
"しょくじん 蝕甚 食尽 食人"
"しょくす 食酢"
"しょくせい 職制 食性 植生"
"しょくせいかつ 食生活"
"しょくせき 職責"
"しょくせつ 触接"
"しょくせんき 食洗機"
"しょくぜん 食膳 食前"
"しょくそ 職組"
"しょくそう 食草"
"しょくたい 飾帯 食滞"
"しょくたく 囑託 嘱託 食卓"
"しょくたん 職短"
"しょくだい 燭臺 燭台"
"しょくち 初口 諸口 触知"
"しょくちゅう 食虫"
"しょくちゅうどく 食中毒"
"しょくちょう 職長"
"しょくつう 食通"
"しょくてん 触点"
"しょくど 埴土"
"しょくどう 食道 食堂"
"しょくどうがん 食道ガン 食道がん 食道癌"
"しょくどうけんだんわしつ 食堂兼談話室"
"しょくどうらく 食道楽"
"しょくにく 食肉"
"しょくにん 職人"
"しょくにんだましい 職人魂"
"しょくのう 色濃 職能"
"しょくのうきゅう 職能給"
"しょくはこうしゅうにあり 食在広州"
"しょくはつ 触発"
"しょくば 職場"
"しょくばい 触媒"
"しょくばいどく 触媒毒"
"しょくぱん 食パン"
"しょくひ 植皮 食費"
"しょくひん 食品"
"しょくひんうり 食品売"
"しょくひんがい 食品害"
"しょくふ 織布"
"しょくぶつ 食物 植物"
"しょくぶつほるもん 植物ホルモン"
"しょくぶん 職分"
"しょくぶんか 食文化"
"しょくへんこうせい 食変光星"
"しょくべに 食紅"
"しょくほう 織豊 触法"
"しょくぼう 嘱望"
"しょくみ 食味"
"しょくみん 殖民 植民"
"しょくみんせい 植民星"
"しょくむ 職務"
"しょくむきゅう 職務給"
"しょくめい 職名"
"しょくもう 植毛"
"しょくもく 属目 嘱目"
"しょくもつ 食物"
"しょくやすみ 食休み"
"しょくゆう 贖宥"
"しょくよう 食用"
"しょくようあぶら 食用油"
"しょくようがえる 食用蛙"
"しょくようぎく 食用菊"
"しょくようじょう 食養生"
"しょくよく 食欲"
"しょくらい 触雷"
"しょくりょう 食糧 食料"
"しょくりょうなん 食糧難"
"しょくりょうひんうり 食料品売"
"しょくりん 植林"
"しょくるいご 触塁後"
"しょくれき 職歴"
"しょくれんせい 食連星"
"しょくろく 食禄"
"しょくわん 触腕"
"しょくん 諸君"
"しょぐう 諸遇 処遇"
"しょけ 所化"
"しょけい 書契 初経 諸兄 処刑"
"しょけつ 処決"
"しょけん 書見 諸賢 初見 所見"
"しょげい 諸芸"
"しょげつ 初月"
"しょげん 初弦 初元 緒言 諸元"
"しょこ 書賈 書庫"
"しょこう 初更 初項 諸公 初校 曙光 初稿 諸侯"
"しょこく 初刻 諸国"
"しょこん 初婚"
"しょご 諸語"
"しょごう 初号"
"しょさ 所作"
"しょさい 書債 所載 書斎"
"しょさく 諸作"
"しょさつ 書札 書冊 初刷"
"しょさん 初産 所産"
"しょさんべつ 初山別"
"しょざ 初座"
"しょざい 所在"
"しょざん 初産 諸山"
"しょし 書笥 諸誌 書司 所思 書史 諸姉 諸士 所司 庶子 諸子 書士 書肆 初志 諸氏 書誌"
"しょしき 諸式 書式"
"しょしつ 書室"
"しょしゃ 諸車 諸社 書写"
"しょしゅ 書手 諸種"
"しょしゅう 諸宗 諸州 初秋 所収"
"しょしゅつ 庶出 所出 初出"
"しょしゅん 初春"
"しょしょ 諸書 処処 処々 所々 処暑 諸所 諸処"
"しょしょう 書証 諸将 所掌"
"しょしん 諸臣 初審 書信 所信 初診 初心"
"しょしんしゃまーく 初心者マーク"
"しょしんりょう 初診療"
"しょじ 書字 諸事 所持"
"しょじゃく 書籍"
"しょじゅん 初旬"
"しょじょ 処女"
"しょじょう 諸嬢 書状"
"しょじょまく 処女膜"
"しょじょりん 処女林"
"しょじん 庶人"
"しょずみ 初炭"
"しょずり 初刷"
"しょせい 庶政 書聖 処世 諸政 初生 書生"
"しょせいぶし 書生節"
"しょせき 書蹟 書跡 書籍"
"しょせつ 所説 諸説"
"しょせつふんぷん 諸説紛紛"
"しょせん 諸戦 書泉 緒戦 初戦 所詮"
"しょせんぐらんで 書泉グランデ"
"しょせんぶっくたわー 書泉ブックタワー"
"しょせんぶっくまーと 書泉ブックマート"
"しょぜい 諸税"
"しょそう 初相 書窓 所相 諸相"
"しょそく 初速"
"しょそん 書損 諸尊"
"しょぞう 所蔵"
"しょぞく 所属"
"しょぞん 所存"
"しょたい 所帯 書体"
"しょたいけん 初体験"
"しょたいめん 初対面"
"しょだい 初台 書題 初代"
"しょだち 初太刀"
"しょだな 書棚"
"しょだん 書壇 処断 初段"
"しょち 書痴 処置"
"しょちつ 書帙"
"しょちゅう 書中 暑中"
"しょちゅうおみまいもうしあげます 暑中お見舞い申し上げます"
"しょちゅうきゅう 初中級"
"しょちゅうとう 初中等 初・中等"
"しょちょう 初潮 署長 所長"
"しょっかい 職階"
"しょっかいきゅう 職階給"
"しょっかく 食客 触角 触覚"
"しょっかん 食管 食間 触感 食感"
"しょっき 織機 食器"
"しょっきあらい 食器洗い"
"しょっきだな 食器棚"
"しょっきゅう 触球 職級"
"しょっきり 初っ切り"
"しょっくし ショック死"
"しょっくりょうほう ショック療法"
"しょっけん 食券 職権"
"しょっこう 燭光 職工"
"しょっぱな 初端 初っ端"
"しょづくえ 書机"
"しょて 初手"
"しょてい 所定"
"しょてん 所天 諸天 諸点 書店"
"しょでん 書伝 所伝 初伝"
"しょとう 書套 初唐 ショ糖 蔗糖 初冬 初等 初頭 諸島"
"しょとく 所得"
"しょどう 所動 諸道 初動 書道"
"しょない 署内 所内"
"しょなぬか 初七日"
"しょなのか 初七日"
"しょにち 初日"
"しょにゅう 初乳"
"しょにん 諸人 初任"
"しょにんきゅう 初任給"
"しょねつ 暑熱"
"しょねん 初年"
"しょは 諸派"
"しょはつ 初発"
"しょはん 初犯 諸般 初版"
"しょばだい ショバ代"
"しょばつ 処罰"
"しょばん 初盤 初版"
"しょひ 書皮 諸費"
"しょひょう 書票 諸表 書評"
"しょびょう 諸病"
"しょふ 書譜"
"しょふう 書風"
"しょふく 書幅"
"しょぶつ 庶物 諸物 諸仏"
"しょぶん 処分"
"しょへき 書癖"
"しょへん 初篇 所変 初編"
"しょほ 書舗 初歩"
"しょほう 諸方 諸法 書法 処方"
"しょほうかいくう 諸法皆空"
"しょほうせん 処方せん 処方箋"
"しょほん 諸本"
"しょぼう 書房"
"しょみん 庶民"
"しょむ 庶務"
"しょむかかり 庶務掛"
"しょむがかり 庶務掛"
"しょめい 書名 署名"
"しょめいあつめ 署名集め"
"しょめん 書面"
"しょもう 所望"
"しょもく 書目"
"しょもつ 書物"
"しょや 初夜"
"しょやく 初訳"
"しょゆう 所由 所有"
"しょよ 所与"
"しょよう 初陽 初葉 所用 所要"
"しょり 処理"
"しょりゅう 諸流 庶流"
"しょりょう 緒量 諸量 所領"
"しょりょうぶ 書陵部"
"しょりん 書林"
"しょるい 書類"
"しょれい 諸礼 諸例 書例"
"しょろう 所労 初老"
"しょろん 諸論 書論 緒論 所論"
"しょわけ 諸訳"
"しょんずい 祥瑞"
"しょんべん 小便"
"しよ 賜与 施与"
"しよう 飼葉 子葉 止揚 脂溶 枝葉 飼養 施用 私用 試用 仕様 使用"
"しようがき 仕様書"
"しようしょう 子葉鞘"
"しようそ 篩要素"
"しよく 私欲"
"しら 調 白"
"しらあえ 白和え"
"しらあわ 白沫 白泡"
"しらい 白井"
"しらいし 白石"
"しらいた 白板"
"しらいち 白市"
"しらいと 白糸"
"しらうお 白魚"
"しらうめ 白梅"
"しらえ 白江"
"しらおい 白老"
"しらおか 白岡"
"しらかた 白潟 白方"
"しらかば 白樺"
"しらかばこ 白樺湖"
"しらかばばやし 白樺林"
"しらかべ 白壁"
"しらかみ 白神"
"しらかゆ 白粥"
"しらかわ 白河 白川"
"しらかわよふね 白川夜船"
"しらが 白髪"
"しらがあたま 白髪頭"
"しらがぞめ 白髪染 白髪染め"
"しらがた 白潟"
"しらがねぎ 白髪ネギ 白髪葱"
"しらがみ 白神"
"しらき 白木"
"しらきばる 白木原"
"しらぎ 新羅"
"しらぎく 白菊"
"しらぎぬ 白絹"
"しらく 刺絡"
"しらくび 白首"
"しらくも 白癬 白雲"
"しらくら 白倉"
"しらけ 白け"
"しらこ 白子"
"しらこばと 白子鳩"
"しらさか 白坂"
"しらさき 白崎"
"しらさぎ 白鷺"
"しらさや 白鞘"
"しらさわ 白沢"
"しらじ 白地"
"しらじしきうらがき 白地式裏書"
"しらじら 白々"
"しらす 白洲 白須 白州 白砂 白子"
"しらすな 白砂"
"しらすぼし しらす干し"
"しらず 不知 知らず"
"しらずしらず 知らず識らず"
"しらずみ 白炭"
"しらせ 白瀬 報せ 知らせ"
"しらた 白太"
"しらたか 白鷹"
"しらたき 白滝"
"しらたま 白珠 白玉"
"しらたまこ 白玉粉"
"しらちゃ 白茶"
"しらつち 白土"
"しらつゆ 白露"
"しらつる 白鶴"
"しらと 白都 白戸 白土"
"しらとり 白取 白鳥"
"しらなみ 白浪 白波"
"しらに 白煮"
"しらぬい 不知火"
"しらぬいまい 不知火舞"
"しらぬいものがたり 白縫譚 白縫物語"
"しらぬか 白糠"
"しらぬぞんぜぬ 知らぬ存ぜぬ"
"しらぬひ 不知火"
"しらぬり 白塗り"
"しらね 白根"
"しらは 白刃 白羽"
"しらはい 白灰"
"しらはし 白橋"
"しらはた 白幡 白旗"
"しらはのや 白羽の矢"
"しらはま 白濱 白浜"
"しらひげ 白鬚 白髭"
"しらびょうし 白拍子"
"しらふ 素面"
"しらふじ 白藤"
"しらべ 調 調べ"
"しらほ 白帆 白保"
"しらほね 白骨"
"しらみ 蝨 虱"
"しらみつぶし 虱潰し"
"しらみね 白峰"
"しらみぼん 虱本"
"しらやき 白焼き 白焼"
"しらやなぎ 白柳"
"しらやま 白山"
"しらゆ 白湯"
"しらゆき 白雪"
"しらゆきひめ 白雪姫"
"しらゆり 白百合"
"しらんかお 知らん顔"
"しらんぷり 知らん振り"
"しり 臀 私利 尻"
"しりーずもの シリーズ物"
"しりあい 知合 知合い 知り合い"
"しりあがり 尻上り 尻上がり"
"しりあて 尻当 尻当て"
"しりあな 尻穴"
"しりあるせつぞく シリアル接続"
"しりあるばんごう シリアル番号"
"しりうち 知内"
"しりうま 尻馬"
"しりお 尻尾"
"しりおし 尻押し"
"しりおも 尻重"
"しりがい 鞦"
"しりがる 尻軽"
"しりがるおんな 尻軽女"
"しりきしない 尻岸内"
"しりきれ 尻切れ"
"しりくち 尻口 後口"
"しりげ 尻毛"
"しりこだま 尻子玉"
"しりごみ 後込み しり込み 尻込み"
"しりさがり 尻下り 尻下がり"
"しりすぼみ 尻窄み"
"しりっぺた 尻っぺた"
"しりつ 市立 私立"
"しりつぼみ 尻つぼみ 尻窄み"
"しりてえき 尻手駅"
"しりとり 尻取り"
"しりぬぐい 尻拭い"
"しりぬけ 尻抜け"
"しりびと 知り人"
"しりびれ 尻鰭"
"しりべ 後志"
"しりべし 後志"
"しりべつがわ 尻別川"
"しりめ 後目 尻目"
"しりめつれつ 支離滅裂"
"しりもち 尻持ち 尻もち 尻餅"
"しりゃく 史略"
"しりやき 尻焼"
"しりゅう 緇流 支流"
"しりょ 思慮"
"しりょう 私領 思量 思料 死霊 試料 史料 飼料 資料"
"しりょうあつめ 資料集め"
"しりょうず 指了図"
"しりょうてきかち 資料的価値"
"しりょく 死力 資力 視力"
"しりん 歯輪 四隣"
"しりんだーじょう シリンダー錠"
"しる 知 什 汁"
"しるけ 汁気"
"しるけんり 知る権利"
"しるこ 汁粉"
"しるし 著し 記 誌 証 首 首級 験 徴 標 印"
"しるしばた 標旗"
"しるしばんてん 印半纏"
"しるとがん シルト岩"
"しるばーせいこう シルバー精工"
"しるひと 知る人"
"しるべ 導 標"
"しるまし 怪 徴"
"しるもの 汁物"
"しるよし 知る由"
"しるるき シルル紀"
"しれい 使令 死霊 司令 指令"
"しれいとう 司令塔"
"しれごと 痴れ言"
"しれつ 歯列 熾烈"
"しれとこ 知床"
"しれとこごこ 知床五湖"
"しれもの 痴れ者"
"しれん 思恋 試錬 試煉 試練"
"しろ 子路 支路 代 城 白"
"しろあお 白青"
"しろあと 城跡"
"しろあり 白アリ 白蟻"
"しろあわ 白沫 白泡"
"しろあん 白あん 白餡"
"しろい 白井"
"しろいし 白石"
"しろいと 白糸"
"しろいぬ 白犬"
"しろいめ 白い目"
"しろいもの 白い物"
"しろいろしんこく 白色申告"
"しろいわ 白岩"
"しろう 梔蝋 死狼 支朗 司朗 詩郎 四朗 士朗 司郎 士郎 史朗 志郎 史郎 四郎 屍蝋 脂漏"
"しろうお 素魚 白魚"
"しろうさぎ 白兎"
"しろうず 白水"
"しろうと 素人"
"しろうとみ 素人見"
"しろうとむき 素人向"
"しろうま 白馬"
"しろうり 白瓜"
"しろおび 白帯"
"しろかき 代掻き"
"しろかぜ 城風"
"しろかっこ 『"
"しろかね 白金"
"しろかねそうあか シロカネソウ亜科"
"しろかび 白かび 白黴 白カビ"
"しろかわ 城川"
"しろかん 白缶"
"しろがしら 白頭"
"しろがね 白金 白銀 銀"
"しろがらす 白烏"
"しろき 白木"
"しろぎつね 白狐"
"しろぎぬ 白絹"
"しろく 四緑"
"しろくじちゅう 四六時中"
"しろくじら 白鯨"
"しろくばん 四六判"
"しろくび 白首"
"しろくま 白熊"
"しろくら 白倉"
"しろくろ 白黒"
"しろぐつ 白靴"
"しろぐみ 白組"
"しろこ 白子"
"しろこっか 』"
"しろさ 白さ"
"しろさき 白崎"
"しろさわ 代沢 白沢"
"しろざけ 白酒"
"しろざとう 白砂糖"
"しろしか 白鹿"
"しろした 白下 城下"
"しろしたとう 白下糖"
"しろじ 白字 白地"
"しろすな 白砂"
"しろず 白酢"
"しろずみ 白炭"
"しろた 白田 代田 城田"
"しろたえ 白妙"
"しろたく 白タク"
"しろたけ 白武"
"しろたなせん 白棚線"
"しろたに 城谷"
"しろたま 白珠"
"しろだ 白田"
"しろだすき 白襷"
"しろだま 白玉"
"しろちゃ 白茶"
"しろぢ 白地"
"しろつち 白土"
"しろとり 白鳥"
"しろなまず 白癜"
"しろなんばー 白ナンバー"
"しろぬかちょう 白糠町"
"しろぬき 白抜"
"しろね 白根"
"しろねぎ 白ネギ 白葱"
"しろねこ 白猫"
"しろねずみ 白鼠"
"しろの 城野"
"しろはた 白旗"
"しろばい 白バイ"
"しろばかま 白袴"
"しろばこ 白箱"
"しろばん 白番"
"しろひげ 白髭"
"しろひとり 白灯蛾"
"しろひょう 白票"
"しろふく 白服"
"しろふだや 白札屋"
"しろぶさ 白房"
"しろぶち 白縁"
"しろへび 白蛇"
"しろべえ 四郎兵衛"
"しろぼし ☆ ○ 白星"
"しろま 城間"
"しろまく 白幕"
"しろまだら 白斑"
"しろまる 〇 ○ 白丸"
"しろみ 白み 城見 白身"
"しろみざかな 白身魚"
"しろみず 白水"
"しろむらさき 白紫"
"しろめ 白眼 白目"
"しろもち 白餅"
"しろもと 城本"
"しろもの 白物 代物"
"しろもん 白門"
"しろや 城谷"
"しろやなぎ 白柳"
"しろやま 白山 城山"
"しろわいん 白ワイン"
"しろん 至論 詩論 私論 史論 試論"
"しわ 皴 襞 紫波 私話 詩話 史話 皺"
"しわがれごえ 嗄れ声"
"しわく 思惑"
"しわくちゃ 皺くちゃ"
"しわけ 仕分 仕分け 仕訳"
"しわざ 爲業 為業 仕業"
"しわしわ 皺々 皺皺"
"しわす 師走"
"しわひめ 志波姫"
"しわほう 指話法 視話法"
"しわよせ 皴寄せ しわ寄せ 皺寄せ"
"しわんぼう 吝ん坊"
"しをさめ 爲納め 仕納め"
"しをり 栞"
"しん 寢 晉 愼 眞 津 請 齔 讖 譛 譖 襯 縉 簪 甄 瀋 沁 晨 斟 怎 忱 岑 哂 矧 辛 薪 蔘 滲 疹 袗 軫 畛 呻 紳 伸 申 鍼 箴 臻 蓁 榛 蜃 脣 唇 宸 震 賑 振 娠 辰 駸 浸 侵 鷏 鷆 瞋 嗔 槙 慎 寝 森 針 審 診 進 深 晋 秦 清 神 身 信 親 真 新 臣 心 芯"
"しんあい 深愛 信愛 親愛"
"しんあいなる 親愛なる"
"しんあさひ 新旭"
"しんあん 新案"
"しんい 襯衣 身位 鍼医 神位 神異 深意 瞋恚 寝衣 心意 神意 神威 真意"
"しんいき 震域 神域"
"しんいち 震一 眞市 申一 信市 真市 紳一 晋一 新市 眞一 進一 新一 慎一 信一 伸一 真一"
"しんいちろう 振一朗 辰一郎"
"しんいも 新芋 新藷"
"しんいん 神韻 真因 心因"
"しんうおのめ 新魚目"
"しんうち 真打ち 真打"
"しんうん 進運"
"しんえい 信栄 神栄 新栄 親英 真影 親衛 新鋭"
"しんえき 新駅"
"しんえつ 親閲 信越"
"しんえん 真猿 親縁 神苑 真円 深遠 深淵"
"しんおう 深奥 震央"
"しんおん 震音 唇音 心音"
"しんか 心窩 真果 神火 神化 臣下 真価 深化 進化"
"しんかい 深回 神階 新貝 神界 新海 新開 深海"
"しんかいぎょ 深海魚"
"しんかいてい 深海底"
"しんかく 真核 神格"
"しんかげりゅう 新陰流"
"しんかしゃ 新華社"
"しんかしょてん 新華書店"
"しんかぶ 新株"
"しんかぶひきうけけんつきしゃさい 新株引受権付社債"
"しんかまはらえき 新蒲原駅"
"しんから 心から"
"しんかわ 新川"
"しんかん 深感 心肝 宸翰 深閑 森閑 信管 新歓 震撼 神官 新館 新刊"
"しんかんこんぱ 新歓コンパ"
"しんが 真我"
"しんがい 新谷 震駭 辛亥 心外 侵害"
"しんがいねん 真概念"
"しんがお 新顔"
"しんがく 心学 信学 新学 神学 進学"
"しんがた 新型"
"しんがっかい 信学会"
"しんがっこう 神学校 進学校"
"しんがぽーる 新嘉坡"
"しんがら 新柄"
"しんがり 殿"
"しんがん 心願 心眼 真贋"
"しんき 蜃気 新機 振起 神気 神器 神姫 辛気 心気 新期 新奇 心機 新規"
"しんきこうしん 心悸亢進"
"しんきち 進吉 真吉 信吉 新吉"
"しんきゅう 賑給 審級 進級 新旧 鍼灸"
"しんきゅういん 鍼灸院"
"しんきゅうめん 真球面"
"しんきょ 新居"
"しんきょう 新彊 心胸 進境 新疆 信教 新京 新教 心境"
"しんきょうせん 神京戦"
"しんきょうのじゆう 信教の自由"
"しんきょく 神曲 新曲"
"しんきろう 蜃気楼"
"しんきん 伸筋 親近 真菌 信金 心筋"
"しんぎ 心木 進木 真義 新義 神技 新技 信義 真偽 審議"
"しんぎたい 心技体"
"しんぎょう 心経 信楽"
"しんぎょうそう 真行草"
"しんぎろん 神義論"
"しんぎん 呻吟"
"しんく 辛苦 深紅 真紅"
"しんくい 身口意"
"しんくう 真空"
"しんくみ 信組"
"しんくん 神君"
"しんぐ 神具 寝具"
"しんぐう 信宮 新宮"
"しんぐるばん シングル盤"
"しんぐん 新軍 進軍"
"しんけ 新家"
"しんけい 針形 唇形 神経"
"しんけいがしゅ 神経芽腫"
"しんけいがす 神経ガス"
"しんけいこん 神経根"
"しんけいしつまい 新形質米"
"しんけいしゅうもう 神経集網"
"しんけいしょう 神経鞘"
"しんけいそう 神経叢"
"しんけいだん 神経弾"
"しんけいどく 神経毒"
"しんけいはい 神経胚"
"しんけいばん 神経板"
"しんけいぱるす 神経パルス"
"しんけつ 心血 審決"
"しんけん 震研 神拳 神権 新券 神剣 進研 親権 真剣"
"しんけんぜみ 進研ゼミ"
"しんげき 新劇 進撃"
"しんげつ 心月 新月"
"しんげん 森厳 信玄 箴言 進言 震源"
"しんげんこう 信玄公"
"しんげんぶくろ 信玄袋"
"しんこ 真個 新香 新古"
"しんこう 辰功 侵行 深交 進航 侵寇 親好 神工 深厚 進貢 新晃 進講 深更 新香 真興 真光 神鋼 新光 神幸 深耕 深紅 進攻 侵攻 親交 信仰 新興 振興 進行"
"しんこうき 神皇記"
"しんこきゅう 深呼吸"
"しんこく 親告 新刻 新穀 神国 申告 深刻"
"しんこだ 新小田"
"しんこっちょう 真骨頂"
"しんこん 親懇 身根 身魂 心魂 心根 新婚"
"しんご 讖語 神語 晋午 紳悟 進悟 伸悟 信悟 新語 晋吾 真悟 伸吾 新吾 信吾 真吾 慎吾"
"しんごう 賑給 身業 新郷 神郷 信号"
"しんごうたいざつおんひ 信号対雑音比"
"しんごん 真言"
"しんさ 辰砂 審査"
"しんさーびす 新サービス"
"しんさい 神采 薪柴 神彩 親祭 親裁 神祭 新妻 震災"
"しんさいばし 心斎橋"
"しんさく 進作 晋作 振作 真作 新作"
"しんさつ 新札 診察"
"しんさん 神算 新参 辛酸"
"しんざ 神座 新座"
"しんざい 浸剤 深在 心材 芯材"
"しんざき 新崎"
"しんざつおん 心雑音"
"しんざわ 新澤 新沢"
"しんざん 心算 新参 深山 神山"
"しんし 唇歯 参差 神祠 新史 新市 神士 振子 進士 浸漬 真摯 紳士"
"しんしき 神式 新式"
"しんしさ 真摯さ"
"しんしっかん 心疾患"
"しんしつ 心室 寝室"
"しんしのつ 新篠津"
"しんしほしゃ 唇歯輔車"
"しんしゃ 親炙 辰砂 深謝 新社 新車"
"しんしゃく 新釈 斟酌"
"しんしゅ 神酒 新手 進取 新酒 新種"
"しんしゅう 新秋 新修 神州 侵襲 真宗 信州"
"しんしゅく 新宿 伸縮"
"しんしゅつ 侵出 神出 滲出 新出 浸出 進出"
"しんしゅん 新春"
"しんしょ 讖書 親署 心緒 神書 真書 信書 親書 新書"
"しんしょう 財産 紳商 心性 真症 志ん生 神将 信証 身上 新梢 身障 心証 辛勝 心象"
"しんしょうひつばつ 信賞必罰"
"しんしょうぼうだい 針小棒大"
"しんしょく 神色 浸蝕 侵蝕 神職 新色 寝食 浸食 侵食"
"しんしろ 新城"
"しんしん 伸身 信心 津津 心神 深々 津々 新々 新進 心身"
"しんしんこうじゃく 心神耗弱"
"しんしんどう 駸々堂"
"しんじ 鍼治 神字 神餌 伸自 愼二 晋次 晋二 晋司 眞治 新治 信司 新司 伸次 伸司 慎治 信治 慎司 信次 伸治 真治 信二 真二 慎二 伸二 真司 宍道 真字 心耳 心事 信士 進士 新字 神事"
"しんじかさがけ 神事笠懸"
"しんじこ 宍道湖"
"しんじつ 信実 真実"
"しんじまい 神事舞"
"しんじゃ 心者 信者"
"しんじゃが 新じゃが 新ジャガ"
"しんじゅ 親授 神授 新樹 真珠"
"しんじゅう 臣従 神獣 心中"
"しんじゅうるい 真獣類"
"しんじゅうろう 真十郎"
"しんじゅがい 真珠貝"
"しんじゅく 新宿"
"しんじゅこんしき 真珠婚式"
"しんじゅつ 鍼術 神術 心術 申述"
"しんじゅぶつ 神儒仏"
"しんじゅん 浸潤"
"しんじょ 神助 晋書 寝所"
"しんじょう 新條 進上 真情 新城 新庄 身上 信条 心情"
"しんじょうさい 新嘗祭"
"しんじょはら 新所原"
"しんじろう 慎次郎"
"しんじん 審訊 真人 神人 審尋 深甚 信心 新人"
"しんすい 薪水 深水 進水 心酔 浸水"
"しんすいのろう 薪水の労"
"しんすう 芯数 真数 進数"
"しんすけ 紳介 信輔 慎介 紳助 信介 伸介"
"しんずい 心髄 神髄 真髄"
"しんせい 晨星 辰星 親征 神政 親政 新姓 心性 神性 新政 新製 新制 真性 真正 新星 神聖 新生 申請"
"しんせいがん 深成岩"
"しんせいしゃ 新声社"
"しんせいでん 神制電"
"しんせかい 真世界"
"しんせき 臣籍 真跡 真蹟 浸漬 親戚"
"しんせつ 深切 真説 新説 新雪 深雪 親切 新設"
"しんせつぎ 親切気"
"しんせつごかし 親切ごかし"
"しんせん 神僊 震顫 神占 浸染 伸線 深浅 神饌 心線 新選 振戦 芯線 神仙 神泉 新線 新鮮"
"しんせんぐみ 新撰組"
"しんぜ 信施"
"しんぜん 森然 浸染 神前 親善"
"しんぜんび 真善美"
"しんそ 親疎 信組"
"しんそう 伸葬 神葬 真草 眞相 深窓 新装 深層 真相"
"しんそく 神足 神速"
"しんそこ 真底 心底"
"しんそつ 真率 新卒"
"しんぞ 新造"
"しんぞう 新三 心像 神像 新造 心臓"
"しんぞうまっさーじ 心臓マッサージ"
"しんぞうやぶり 心臓破り"
"しんぞく 神族 親族"
"しんた 心太 新太"
"しんたい 真諦 新体 神体 進退 身体"
"しんたいうかがい 進退伺"
"しんたいし 新体詩"
"しんたいのじゆう 身体の自由"
"しんたいぷ 新タイプ"
"しんたいようじ 真太陽時"
"しんたいりょうなん 進退両難"
"しんたく 神託 新宅 信託"
"しんたつ 申達 進達"
"しんたに 新谷"
"しんたろう 辰太郎 信太郎 慎太郎"
"しんたん 晨旦 心胆 震旦 薪炭"
"しんだい 神代 信大 神大 身代 新台 寝台"
"しんだけ 新竹"
"しんだつ 侵奪"
"しんだん 診断"
"しんち 深智 深知 神智 真智 新知 新治 真値 心地 新地"
"しんちく 新竹 新築"
"しんちくいっこだて 新築一戸建"
"しんちゃ 新茶"
"しんちゃく 新着"
"しんちゃくめーる 新着メール"
"しんちゅう 鉐 親中 進駐 真鍮 心中"
"しんちゅういた 真鍮板"
"しんちゅうぼう 真鍮棒"
"しんちょ 心緒 新著"
"しんちょう 晨朝 深長 志ん朝 清朝 伸張 新調 伸長 新潮 身長 慎重"
"しんちょく 神勅 進捗"
"しんちん 深沈 新陳"
"しんつう 心痛"
"しんづ 新津"
"しんて 新手"
"しんてい 新帝 新艇 心底 新訂 進呈"
"しんていし 心停止"
"しんてき 神笛 神的 心的"
"しんてつ 神鉄"
"しんてら 新寺"
"しんてん 秦篆 神典 親展 伸展 進展"
"しんてんおう 信天翁"
"しんてんそう 伸展葬"
"しんてんちょう 新天町"
"しんてんどうち 震天動地"
"しんでん 親電 震電 神伝 心電 寝殿 新田 神殿"
"しんでんづくり 寝殿造"
"しんと 新渡 信徒 新都"
"しんとう 神灯 震盪 神統 榛東 滲透 新刀 振盪 神東 真藤 新棟 親等 新党 心頭 神道 浸透"
"しんとく 新得 神徳"
"しんとみ 新富"
"しんど 震怒 心土 進度 深度 震度"
"しんどう 真藤 新堂 新藤 進藤 伸銅 神道 新道 神童 震動 振動"
"しんどうばん 振動板"
"しんどうまく 振動膜"
"しんどく 真読"
"しんない 唇内 新内 心内"
"しんないがいめん 新内外綿"
"しんないぶし 新内節"
"しんないまくえん 心内膜炎"
"しんに 真に 瞋恚"
"しんにち 新日 親日"
"しんにっこう 新日鉱"
"しんにってつ 新日本製鉄株式会社 新日鐵"
"しんにゅう 之繞 浸入 新入 進入 侵入"
"しんにょ 信女 真如"
"しんにょう 之繞"
"しんにん 親任 信認 信任 新任"
"しんぬり 真塗"
"しんね 新値 心根"
"しんねた 新ネタ"
"しんねつ 身熱"
"しんねん 軫念 新年 信念"
"しんの 新野 神野"
"しんのう 新皇 心王 心嚢 神農 親王"
"しんのうとう 秦皇島"
"しんのすけ 進之助 信之介 新之助 慎之介"
"しんのぞう 心の臓"
"しんはんにん 真犯人"
"しんば 神馬 新馬"
"しんばし 新橋"
"しんばしら 真柱 心柱"
"しんばた 新畑"
"しんばつ 神罰"
"しんばら 新原"
"しんばり 心張り"
"しんばりぼう 心張り棒"
"しんばん 新盤 新番 新版"
"しんぱ 新派"
"しんぱい 神拝 心肺 心配"
"しんぱいしょう 心配性"
"しんぱく 心搏 心拍"
"しんぱち 新八"
"しんぱつ 深発 進発"
"しんぱん 神判 親藩 侵犯 新版 信販 審判"
"しんび 審美"
"しんぴ 心皮 真否 真皮 神秘"
"しんぴつ 親筆 宸筆 真筆"
"しんぴょう 信憑"
"しんぴょうろん 新評論"
"しんぴん 神品 新品"
"しんふがい 申不害"
"しんふぜん 心不全"
"しんふり 進振 進振り"
"しんぶ 神武 深部"
"しんぶつ 心仏 真物 神仏"
"しんぶぶんしゅうごう 真部分集合"
"しんぶん 新聞"
"しんぶんすう 真分数"
"しんぶんだね 新聞種"
"しんぷ 親父 神父 新婦 新譜"
"しんぷう 新風"
"しんぷく 臣服 心腹 信服 心服 振幅"
"しんぷくじ 真福寺"
"しんべい 親米"
"しんべん 唇弁"
"しんぺい 慎平 晋平 新平 親兵 神兵 新兵"
"しんぺん 新篇 神変 新編 身辺"
"しんほう 心法 進法"
"しんほく 真北"
"しんぼ 真保 新保"
"しんぼう 心法 辛棒 深謀 伸坊 心棒 心房 信望 辛抱"
"しんぼうしゃ 信奉者"
"しんぼく 臣僕 神木 親睦"
"しんぼち 新発意"
"しんぼとけ 新仏"
"しんぼり 新堀"
"しんぽ 進歩"
"しんぽう 信奉 新法 新報"
"しんぽん 新本"
"しんまい 新米"
"しんまえ 新前"
"しんまく 心膜"
"しんまち 新町"
"しんまつ 新松"
"しんみ 新見 辛味 新味 親身"
"しんみせ 新店"
"しんみち 新道"
"しんみつ 身密 深密 親密"
"しんみなと 新湊"
"しんみょう 新名 身命 神妙"
"しんみん 臣民"
"しんむら 新村"
"しんめ 神馬 新芽"
"しんめい 神命 深名 身命 神名 新明 神明"
"しんめいだい 真命題"
"しんめいづくり 神明造"
"しんめにゅー 新メニュー"
"しんめん 新免"
"しんめんばー 新メンバー"
"しんめんぼく 真面目"
"しんめんもく 真面目"
"しんもつ 神物 進物"
"しんもの 新物"
"しんもり 新森"
"しんもん 讖文 心門 真門 神文 真文 神門 審問"
"しんや 真家 信矢 眞哉 伸弥 晋哉 新家 新也 真哉 信哉 進也 真矢 晋也 伸也 信也 真也 深夜"
"しんやあにめ 深夜アニメ"
"しんやく 信約 神薬 新訳 新約 新薬"
"しんやま 新山"
"しんゆ 新湯"
"しんゆう 深憂 心友 親友"
"しんゆにっと 新ユニット"
"しんよ 神輿"
"しんよう 新陽 針葉 瀋陽 信用"
"しんようがし 信用貸し"
"しんようじゅ 針葉樹"
"しんようりすく 信用リスク"
"しんら 森羅"
"しんらい 神来 新来 信頼"
"しんらいのげんそく 信頼の原則"
"しんらつ 辛辣"
"しんらまんぞう 森羅万象"
"しんらん 親鸞"
"しんり 心裏 心裡 審理 真理 心理"
"しんりつ 震慄"
"しんりてすと 心理テスト"
"しんりゃく 侵掠 侵略"
"しんりゅう 神竜 神龍"
"しんりょ 神慮 深慮"
"しんりょう 新涼 神領 診療"
"しんりょうないか 心療内科"
"しんりょく 真緑 心力 神力 深緑 新緑"
"しんりん 親臨 森林"
"しんるーる 新ルール"
"しんるい 親類"
"しんるいぶん 進塁分"
"しんれい 振鈴 新例 浸礼 神霊 心霊"
"しんれいしょり 深冷処理"
"しんれき 新暦"
"しんれつ 進列"
"しんろ 針路 進路"
"しんろう 滲漏 辛労 身廊 心労 新郎"
"しんろく 神鹿 新録"
"しんろん 新論"
"しんわ 新和 親和 神話"
"じ 只 以 爺 寿 知 仁 史 嗣 士 冶 治 除 仕 至 司 子 兒 弍 二 辭 膩 瓷 怩 岻 亊 似 茲 孳 磁 滋 慈 珥 餌 耳 祀 示 塒 蒔 畤 恃 峙 持 侍 轜 粫 而 迩 邇 尓 爾 璽 柱 児 路 寺 次 自 事 時 痔 辞 地 字"
"じーぱん Ｇパン"
"じーめん Ｇメン"
"じあ 次亜"
"じあい 試合 地合い 時合 地合 慈愛 自愛"
"じあげ 地上 地上げ"
"じあぞか ジアゾ化"
"じあまり 字余り"
"じあめ 地雨"
"じあん 治安 事案"
"じい 事彙 磁位 辞彙 字彙 次位 侍医 示威 辞意 爺 自慰"
"じいがたけ 爺ヶ岳"
"じいき 寺域"
"じいこう 時以降"
"じいさま 爺様"
"じいさん 祖父さん 爺さん"
"じいしき 自意識"
"じいた 地板"
"じいぱん Ｇパン"
"じいや 爺や"
"じいろ 地色"
"じいん 次韻 寺院"
"じう 時雨 慈雨"
"じうえ 地植え"
"じうた 地歌"
"じうたい 地謡"
"じうん 時運"
"じぇーぽっぷ Ｊポップ"
"じぇーりーぐ Ｊリーグ"
"じぇっとき ジェット機"
"じぇっとふんしゃ ジェット噴射"
"じえい 侍衛 自衛 自営"
"じえん 慈円 自演"
"じお 塩"
"じおう 地黄"
"じおり 地織"
"じおん 字音"
"じおんじ 慈恩寺"
"じか 自歌 時課 磁荷 耳科 字化 磁化 時下 直 時価 自家"
"じかい 次会 辞海 字解 持戒 耳介 自壊 自戒 磁界 次回"
"じかうち 直打ち"
"じかく 時隔 耳殻 寺格 字画 痔核 自覚"
"じかけ 仕掛 仕掛け"
"じかじゅせい 自花受精"
"じかず 字数"
"じかせん 耳下腺"
"じかた 地方"
"じかたび 地下足袋"
"じかだん 直談"
"じかだんぱん 直談判"
"じかつ 自活"
"じかづけ 直付け"
"じかづみ 直積"
"じかとりひき 直取引"
"じかに 直に"
"じかばき 直履き 直穿き"
"じかび 直火"
"じかまき 直播き"
"じかやき 直焼き"
"じかろ 地火炉"
"じかん 耳間 耳管 字間 次官 時間"
"じかんきゅう 時間休 時間給"
"じかんぎれ 時間切れ"
"じかんそう 時間走"
"じかんまち 時間待"
"じかんまど 時間窓"
"じが 自画 自我"
"じがい 自害"
"じがお 地顔"
"じがく 自学"
"じがため 地固め"
"じがね 地金"
"じがみ 地紙 地神"
"じがん 慈顔"
"じき 瓷器 敷 喰 食 自記 自棄 時機 自機 時季 直 磁器 磁気 次期 時期"
"じきあらし 磁気嵐"
"じきかーど 磁気カード"
"じきさん 直参"
"じきしょ 直書"
"じきじき 直々"
"じきじきに 直々に"
"じきじょう 直状"
"じきせつ 直説"
"じきそ 直訴"
"じきそう 直奏"
"じきだん 直談"
"じきだんぱん 直談判"
"じきてーぷ 磁気テープ"
"じきでぃすく 磁気ディスク"
"じきでし 直弟子"
"じきでん 直伝"
"じきとう 直答"
"じきとりひき 直取引"
"じきに 直に"
"じきひつ 直筆"
"じきふ 食封"
"じきへっど 磁気ヘッド"
"じきぼう 次期防"
"じきみや 直宮"
"じきもの 直物"
"じきもん 直門"
"じきゅう 自救 持久 自給 時給"
"じきゅうそう 持久走"
"じきょ 辞去"
"じきょう 持経 耳鏡 自供"
"じきょうげん 地狂言"
"じきょうじゃ 持経者"
"じきょく 磁極 自局 時局"
"じきらん 直覧"
"じきわ 直話"
"じぎ 辞儀 児戯 字義 時宜"
"じぎゃく 自虐"
"じぎょう 事行 次行 事業"
"じぎわ 地際"
"じく 忸 衂 衄 宍 竺 舳 磁区 字句 軸"
"じくあし 軸足"
"じくう 時空"
"じくうい 時空意"
"じくうけ 軸受け 軸受"
"じくかん 時区間 軸間"
"じくがい 軸外"
"じくぎ 軸木"
"じくぐみ 軸組"
"じくこてい 軸固定"
"じくさく 軸索"
"じくじ 忸怩"
"じくじゅう 軸重"
"じくじょう 軸上"
"じくじょうほう 軸情報"
"じくすう 軸数"
"じくずれ 地崩れ"
"じくせい 軸性"
"じくせいぶん 軸成分"
"じくせん 軸線"
"じくそう 軸装"
"じくそうかん 軸相関"
"じくたいしょう 軸対称"
"じくない 軸内"
"じくはら 軸原"
"じくばこ 軸箱"
"じくばり 字配り"
"じくほうこう 軸方向"
"じくまわり 軸回"
"じくもの 軸物"
"じくや 軸屋"
"じくりつ 軸率"
"じくりゅう 軸流"
"じくろ 舳艫"
"じくん 二君 字訓"
"じぐ 治具"
"じぐち 地口"
"じぐん 自軍"
"じけ 寺家"
"じけい 自警 次兄 慈恵 字型 字形"
"じけいれつ 時系列"
"じけつ 自決"
"じけん 事件"
"じげ 地下 自解 地毛"
"じげん 辞源 示顕 示現 事言 字源 時限 次元"
"じげんそう 次元窓"
"じこ 事故 自己"
"じこあぴーる 自己アピール"
"じこう 事行 耳孔 時好 時候 自校 時効 次項 事項"
"じこうしき 字光式"
"じこく 二黒 自国 時刻"
"じこくてん 持国天"
"じこしん 自己新"
"じこぴーあーる 自己PR 自己ＰＲ"
"じこべすと 自己ベスト"
"じこまん 自己満"
"じこみ 仕込み"
"じこむどうちゃく 自己無撞着"
"じころ 時頃"
"じご 耳語 持碁 爾後 事後"
"じごう 自業 寺号 次号"
"じごえ 地声"
"じごく 地獄"
"じごくだに 地獄谷"
"じごくへん 地獄変"
"じごくみみ 地獄耳"
"じごろ 時頃"
"じごろう 滋悟郎"
"じさ 橲 時差"
"じさいと 自サイト"
"じさく 治作 次作 自作"
"じさくのう 自作農"
"じさげ 字下げ"
"じさつ 自殺"
"じさばら 橲原"
"じさぶろう 治三朗"
"じさぼけ 時差ボケ"
"じさん 自参 自讃 自賛 持参"
"じざい 自在"
"じざいてん 自在天"
"じざかい 地境"
"じざけ 地酒"
"じし 自恣 侍史 慈氏 獅子 示指 次子 自死"
"じしき 次式"
"じしつ 地質 自失 痔疾 自室"
"じしゃ 轜車 辞謝 侍者 自車 寺社 自社"
"じしゃく 磁石"
"じしゅ 寺主 時衆 字種 自首 自主"
"じしゅう 時衆 自修 時宗 自習 次週"
"じしゅうよう 磁州窯"
"じしゅうようきょうざい 自習用教材"
"じしゅく 自粛"
"じしゅとれ 自主トレ"
"じしょ 璽書 自書 字書 自署 地所 辞書"
"じしょう 自象 時尚 自性 治承 自照 時鐘 時称 自傷 次章 事象 自称"
"じしょうぎ 持将棋"
"じしょうじ 慈照寺"
"じしょく 辞色 自食 辞職"
"じしん 地神 侍臣 磁心 時針 磁針 地震 自信 自身"
"じしんどう 地震動"
"じしんなし 自信無"
"じじ 自恃 時々 爺 時事"
"じじい 爺"
"じじかい 次々回"
"じじく 耳軸"
"じじこっこく 時時刻刻"
"じじさま 爺様"
"じじつ 時日 事実"
"じじねた 時事ネタ"
"じじばば 祖父祖母 爺婆"
"じじぶつぶつ 事事物物"
"じじゃく 示寂 自若"
"じじゅう 侍従 自重"
"じじゅん 次順 耳順"
"じじょ 自叙 自序 二女 侍女 自助 次女"
"じじょう ２乗 磁場 治定 自乗 自浄 二乗 次条 事情"
"じじょうこん 自乗根"
"じじょうじばく 自縄自縛"
"じじょうわ ２乗和 自乗和 二乗和"
"じじん 自尽 時人 自刃 自陣"
"じすい 自炊"
"じすう 次数 時数 字数"
"じすべり 地すべり 地滑り"
"じず 次図"
"じずめ 字詰め"
"じずら 字面"
"じせい 自製 辞世 自省 時制 時勢 時世 自制 磁性 自生"
"じせいふん 磁性粉"
"じせき 耳石 事蹟 事跡 自席 事績 次席 自責"
"じせきのねん 自責の念"
"じせつ 持説 次節 自説 時節"
"じせん 次戦 自選 自薦"
"じせんき 自戦記"
"じせんよう 耳栓用"
"じぜん 次善 慈善 事前"
"じそ 自訴"
"じそう 自掃 寺僧 時相 事相 次走 自走"
"じそく 自足 磁束 時速"
"じそくき 自速機"
"じそん 児孫 自存 自損 自尊"
"じぞう 地蔵"
"じぞうぼん 地蔵盆"
"じぞく 持続"
"じた 舌 自他"
"じたい 字體 字体 辞退 事態 自体"
"じたく 仕度 支度 自宅"
"じたくけんじむしょ 自宅兼事務所"
"じたつ 示達"
"じたん 時短"
"じだ 次打 耳朶"
"じだい 事大 地代 次代 時代"
"じだいおくれ 時代後れ"
"じだいぎれ 時代裂"
"じだいまつり 時代祭"
"じだらく 自堕落"
"じだん 次段 示談"
"じだんだ 地団太 地団駄"
"じち 自治"
"じちゅう 自注 自註"
"じちょ 自著"
"じちょう 次丁 自嘲 自重 次長"
"じちよう 実用"
"じちろう 自治労"
"じちん 自沈"
"じちんさい 地鎮祭"
"じっ 十"
"じっか 実科 実家"
"じっかい 実解 十誡 十界 十階 十戒"
"じっかん 甲乙丙丁戊己庚辛壬癸 十干 実感"
"じっき 実記 実機"
"じっきょう 実教 実況"
"じっきんしょう 十訓抄"
"じっくんしょう 十訓抄"
"じっけい 実系 実形 実景 実兄 実刑"
"じっけつ 十傑"
"じっけん 實驗 実検 実見 実権 実験"
"じっけんせい 実験星"
"じっけんづくえ 実験机"
"じっけんでーた 実験データ"
"じっこ 十個"
"じっこう 実効 実行"
"じっこん 昵懇 実根 入魂"
"じっさ 実査"
"じっさい 実際"
"じっさいに 実際に"
"じっさぎょう 実作業"
"じっさく 実作"
"じっし 実視 十指 実姉 実子 実施"
"じっしつ 実質"
"じっしゃ 実者 実車 実写"
"じっしゃかい 実社会"
"じっしゅ 十種"
"じっしゅう 実収 実習"
"じっしゅうねん 十周年"
"じっしょう 十漿 実正 実証"
"じっしん １０進 十進 実身 実親"
"じっすう 実数"
"じっすん 実寸"
"じっせい 日星 実勢"
"じっせいかつ 實生活 実生活"
"じっせかい 実世界"
"じっせき 実績"
"じっせきあり 実績有"
"じっせきば 実績馬"
"じっせつ 実説"
"じっせん 実線 実戦 実践"
"じっそう 十層 実相 実装"
"じっそく 実測"
"じっそん 実損"
"じったい 実体 実態"
"じったいきょう 実体鏡"
"じったいけん 実体験"
"じっち 実地"
"じっちゃく 実着"
"じっちゅう 十中"
"じっちょう 十兆"
"じっちょうりょく 実張力"
"じっちょく 実直"
"じっつう 十通"
"じって 十手"
"じってい 実体 実弟"
"じっていほう 実定法"
"じってつ 十哲"
"じっとく 十徳 拾得"
"じっぱ 十羽 十把"
"じっぴ 実否 実費"
"じっぴき 十匹"
"じっぷ 実父"
"じっぷん 十分"
"じっぺんしゃいっく 十返舎一九"
"じっぽ 十歩"
"じっぽう 実法 十方 実包"
"じっぽん 日本"
"じつ 實 昵 日 実"
"じつい 実意 実委"
"じついん 実員 実印"
"じつう 耳痛"
"じつえき 実益"
"じつえん 実演"
"じつおや 実親"
"じつおん 実音"
"じつかた 実方"
"じつかぶ 実株"
"じつかわ 実川"
"じつがい 実害"
"じつがく 実額 実学"
"じつぎ 実技"
"じつぎょう 実業"
"じつぎょうのにほん 実業之日本"
"じつげつ 日月"
"じつげん 実現"
"じつご 実語"
"じつざい 実在"
"じつじ 実耳 実字"
"じつじきゅうぜ 実事求是"
"じつじく 実軸"
"じつじゅ 実需"
"じつじょう 実状 実情"
"じつぞう 実像"
"じつぞん 実存"
"じつだん 実弾"
"じつづき 地続き"
"じつどう 実動 実働"
"じつに 実に"
"じつねん 実年"
"じつねんろん 実念論"
"じつのところ 実の所"
"じつは 実は"
"じつばい 実売"
"じつぶ 実部"
"じつぶつ 実物"
"じつぼ 地坪 実母"
"じつまい 実妹"
"じつむ 実夢 実務"
"じつめい 実名"
"じつやく 実役"
"じつよう 実葉 実用"
"じつようかどうむき 実用化動向"
"じつり 実理 実利"
"じつりょく 実力"
"じつりょくてすと 実力テスト"
"じつりょくば 実力馬"
"じつれい 実例"
"じつれき 実歴"
"じつれん 実連"
"じつろう 実労"
"じつろく 実録"
"じつわ 実話"
"じづめ 字詰 字詰め"
"じづら 字面"
"じてい 時程 自邸"
"じていすう 時定数"
"じてき 自適"
"じてっこう 磁鉄鉱"
"じてん 辭典 字典 自転 次点 事典 時点 辞典"
"じてんしゃ 自轉車"
"じでん 自伝"
"じでんてきさくひん 自伝的作品"
"じとう 字統 時祷 寺塔 自答 自党 地頭"
"じとうてんのう 持統天皇"
"じとく 自涜 自得"
"じとり 地鶏"
"じどう 侍童 耳道 児童 自動"
"じどうかいけつ 自動解結"
"じどうぎれ 自動切"
"じどうしゃろーん 自動車ローン"
"じどうどあ 自動ドア"
"じどうひきおとし 自動引落"
"じどうぽるの 児童ポルノ"
"じどうまき 自動巻"
"じどうまど 自動窓"
"じどうりつ 自同律"
"じどり 自撮り 地取り 地鶏"
"じない 耳内 寺内 地内"
"じならし 地均し"
"じならび 字並び"
"じなり 地鳴り"
"じなん 二男 次男"
"じなんきょく 磁南極"
"じにけいすう ジニ係数"
"じにん 神人 自任 自認 辞任"
"じぬし 地主"
"じねずみ 地鼠"
"じねつ 地熱"
"じねん 自然"
"じねんじょ 自然生 自然薯"
"じのかみ 地の神"
"じのし 地伸し"
"じのぶん 地の文"
"じのり 地乗り"
"じは 自派"
"じはい 字牌"
"じはく 自白"
"じはだ 地肌"
"じはつ 次発 自発"
"じはば 字幅"
"じはん 次版 自販 事犯 時半"
"じはんころ 時半頃"
"じば 磁場 地場"
"じばいせき 自賠責"
"じばく 地縛 自縛 自爆"
"じばくてろ 自爆テロ"
"じばくれい 自縛霊 地縛霊"
"じばつ 治罰"
"じばつてき 自罰的"
"じばら 自腹"
"じばん 次版 地盤"
"じぱい 字牌"
"じひ 自費 慈悲"
"じひしんちょう 慈悲心鳥"
"じひつ 自筆"
"じひつふ 自筆譜"
"じひびき 地響き"
"じひょう 恃憑 時評 耳標 次表 辞表"
"じひょうき 字表記"
"じび 耳鼻"
"じびーる 地ビール"
"じびき 地引 字引"
"じびきあみ 地曳き網 地曳網 地引網 地引き網"
"じびょう 持病"
"じふ 慈父 自負"
"じふく 地幅 時服 地覆"
"じふてりあきん ジフテリア菌"
"じふぶき 地吹雪"
"じふへん 時不変"
"じふん 時分 自刎 自噴"
"じふんせい 自噴井"
"じぶ 治部"
"じぶく 地幅 地覆"
"じぶくろ 地袋"
"じぶつ 事物"
"じぶもん 自部門"
"じぶん 時分 自分"
"じぶんかつ 時分割"
"じぶんさがし 自分探し"
"じぶんたち 自分たち"
"じへい 時弊 自閉"
"じへん 事變 時変 事変"
"じべた 地べた"
"じべん 自弁"
"じぺーじ 次頁"
"じほう 次鋒 寺宝 時報"
"じほく 磁北"
"じぼ 慈母 字母"
"じぼう 自暴"
"じぼしん 地母神"
"じま 嶌 嶋 縞 島"
"じまい 仕舞い 仕舞"
"じまえ 自前 時前"
"じまく 字幕"
"じまひ 仕舞い"
"じまま 自儘"
"じまわり 地回り 地廻り"
"じまん 自慢"
"じみ 滋味 地味"
"じみち 地道"
"じみん 自民"
"じむ 時務 寺務 事務"
"じむし 地虫"
"じむづくえ 事務机"
"じむれべる 事務レベル"
"じめい 字名 自明"
"じめいきん 自鳴琴"
"じめいのり 自明の理"
"じめつ 自滅"
"じめん 字面 地面"
"じもく 除目 耳目"
"じもくじ 甚目寺"
"じもつ 持物"
"じもと 地元"
"じもの 地物"
"じもよう 地模様"
"じもん 字紋 次問 地文 地紋 寺門 自問"
"じゃ 闍 麝 者 蛇 邪"
"じゃーじゃーめん ジャージャー麺"
"じゃあく 邪悪"
"じゃいなきょう ジャイナ教"
"じゃいん 邪淫"
"じゃいんかい 邪淫戒"
"じゃかご 蛇籠"
"じゃかん 蛇管"
"じゃがいも ジャガ芋 じゃが芋"
"じゃき 邪鬼 邪気"
"じゃきょう 邪教"
"じゃきょく 邪曲"
"じゃく 着 鉐 搦 雀 惹 寂 尺 若 弱"
"じゃくおん 弱音"
"じゃくきょうちゅう 弱強中"
"じゃくご 著語"
"じゃくさん 弱酸"
"じゃくし 弱志 杓子 弱視"
"じゃくしつ 弱質"
"じゃくしゃ 弱者"
"じゃくしゅう 若州"
"じゃくしょう 弱小"
"じゃくしん 弱震"
"じゃくじょう 寂静"
"じゃくそつ 弱卒"
"じゃくたい 弱体"
"じゃくちゅう 若冲"
"じゃくちゅうきょう 弱中強"
"じゃくちょう 寂聴"
"じゃくてき 弱敵"
"じゃくてん 弱点"
"じゃくでん 弱電"
"じゃくにくきょうしょく 弱肉強食"
"じゃくねん 弱年 寂然 若年"
"じゃくねんれい 若年齢"
"じゃくはい 弱輩 若輩"
"じゃくはく 弱拍"
"じゃくはん 雀斑"
"じゃくまく 寂寞"
"じゃくめつ 寂滅"
"じゃくめついらく 寂滅為楽"
"じゃくやく 雀躍"
"じゃくら 雀羅"
"じゃくらんはん 雀卵斑"
"じゃくれい 弱齢 若齢"
"じゃくれいしゃ 弱冷車"
"じゃぐち 蛇口"
"じゃけ 鮭"
"じゃけがい ジャケ買い"
"じゃけん 邪剣 邪慳 邪見 邪険"
"じゃこ 雑魚"
"じゃこう 蛇行 麝香"
"じゃこうじか 麝香鹿"
"じゃこうそう 麝香草"
"じゃこうねこ 麝香猫"
"じゃこばんは ジャコバン派"
"じゃし 邪視"
"じゃしゅう 邪宗"
"じゃしん 蛇身 邪心 邪神"
"じゃじゃうま じゃじゃ馬"
"じゃじゅつ 邪術"
"じゃすい 邪推"
"じゃずきっさ ジャズ喫茶"
"じゃずけん ジャズ研"
"じゃせい 邪正"
"じゃせつ 邪説"
"じゃそく 蛇足"
"じゃっか 弱化"
"じゃっかん 弱冠 若干"
"じゃっかんき 若干気"
"じゃっき 弱起 惹起"
"じゃっく 惹句"
"じゃっけん 弱肩"
"じゃっこう 弱行 寂光"
"じゃっこういん 寂光院"
"じゃっこく 弱国"
"じゃとう 蛇頭"
"じゃどう 邪道"
"じゃねん 邪念"
"じゃのひげ 蛇の鬚"
"じゃのめ 蛇の目"
"じゃはな 謝花"
"じゃばら 蛇腹"
"じゃひ 邪飛"
"じゃび 蛇皮"
"じゃほう 邪法"
"じゃぽにかまい ジャポニカ米"
"じゃま 邪魔"
"じゃみせん 三味線"
"じゃむし 蛇虫"
"じゃもん 蛇紋"
"じゃもんがん 蛇紋岩"
"じゃよく 邪欲"
"じゃらい 射礼"
"じゃり 砂利"
"じゃりじき 砂利敷き"
"じゃりせん ジャリ銭"
"じゃりみち 砂利路 砂利道"
"じゃりゅう 邪龍"
"じゃれん 邪恋"
"じゃわ 爪哇"
"じゃわご ジャワ語"
"じゃん 醤 雀"
"じゃんき 雀鬼"
"じゃんくや ジャンク屋"
"じゃんごう 雀豪"
"じゃんし 雀師 雀士"
"じゃんそう 雀荘"
"じゃんたく 雀卓"
"じゃんぱい 雀牌"
"じゃんぷだい ジャンプ台"
"じゃんぷりょく ジャンプ力"
"じゃんぼき ジャンボ機"
"じやき 地焼 地焼き"
"じやく 持薬"
"じゅ 壽 讎 讐 鷲 就 従 戍 聚 愀 珠 襦 懦 孺 濡 嬬 儒 需 豎 竪 咒 呪 綬 寿 樹 授 受"
"じゅあつ 受圧"
"じゅあん 樹庵 寿庵"
"じゅい 儒医 呪医"
"じゅいしゃ 受遺者"
"じゅいち 寿一"
"じゅいん 樹陰 呪印 入院"
"じゅう 廿 獸 从 從 縱 縦 澀 澁 渋 拾 狃 柱 什 充 絨 戎 鞣 蹂 糅 揉 柔 汁 住 従 十 重 中 銃 獣"
"じゅうあく 十悪"
"じゅうあつ 重圧"
"じゅうい 重囲 十位 獣医"
"じゅういおん 重イオン"
"じゅういち 十一"
"じゅういちがつ 霜月 １１月"
"じゅういつ 充溢"
"じゅういん 充員"
"じゅうえき 汁液 獣疫"
"じゅうえん 柔婉 重縁 十円"
"じゅうおう 十王 縦横"
"じゅうおうむぐう 縦横無隅"
"じゅうおく 十億"
"じゅうおん 重音"
"じゅうか 重科 従価 銃火 住家"
"じゅうかい 重解"
"じゅうかく 縦隔"
"じゅうかん 重患 獣姦 縦貫"
"じゅうかんきょう 住環境"
"じゅうがい 獣害"
"じゅうがつ 神無月 １０月 十月"
"じゅうがん 銃眼"
"じゅうき 重器 住基 銃器 重機 什器"
"じゅうきせい 銃規制"
"じゅうきち 重吉"
"じゅうきねっと 住基ネット"
"じゅうきゅう 十九"
"じゅうきょ 住居"
"じゅうきょようせんざい 住居用洗剤"
"じゅうぎょう 従業"
"じゅうく 重苦"
"じゅうぐん 従軍"
"じゅうけい 銃刑 従系 重刑 従兄 重慶"
"じゅうけつ 充血"
"じゅうけん 重検 銃剣 住建"
"じゅうけんどう 柔剣道"
"じゅうげき 銃撃"
"じゅうげん 重言"
"じゅうこ 住戸"
"じゅうこう 獣行 重項 銃口 重工 重厚"
"じゅうこうげき 銃攻撃"
"じゅうこうぞう 柔構造"
"じゅうこく 縦谷 重刻"
"じゅうこつ 獸骨 獣骨"
"じゅうこん 重婚 重根"
"じゅうご 十五 銃後"
"じゅうごう 重合"
"じゅうさいぼう 柔細胞"
"じゅうさつ 重殺 重刷 銃殺"
"じゅうさん 十三"
"じゅうさんづか 十三塚"
"じゅうざ 銃座"
"じゅうざい 縦材 重罪"
"じゅうし 従祀 獣脂 従姉 銃士 重視"
"じゅうしちげん 十七絃"
"じゅうしちし 十七史"
"じゅうしちもじ 十七文字"
"じゅうしまつ 十姉妹"
"じゅうしゃ 従者"
"じゅうしやま 十四山"
"じゅうしゅつ 重出"
"じゅうしょ 住所"
"じゅうしょう 銃床 重唱 重賞 重傷 重症"
"じゅうしょうしゅぎ 重商主義"
"じゅうしょく 重職 住職"
"じゅうしん 獣心 獣身 従心 住心 銃身 重臣 重心"
"じゅうじ 住持 十時 十字 従事"
"じゅうじつ 充実"
"じゅうじゃく 柔弱"
"じゅうじゅう 重々"
"じゅうじゅつ 柔術"
"じゅうじゅん 重巡 柔順 従順"
"じゅうじょう 重畳 十条"
"じゅうじょうせいし 十條製紙"
"じゅうじん 獣神 獣人"
"じゅうすい 重水"
"じゅうすう 十数"
"じゅうせい 重星 獣性 銃声"
"じゅうせき 重石 重責"
"じゅうせん 住専 縦線"
"じゅうぜい 重税"
"じゅうぜん 十善 十全 従前"
"じゅうそ 重祚"
"じゅうそう 従僧 住僧 銃創 重装 重奏 十三 重曹 重層 縦走"
"じゅうそく 充塞 充足"
"じゅうそしき 柔組織"
"じゅうそつ 従卒"
"じゅうぞう 重像 十三"
"じゅうぞく 従属"
"じゅうたい 獣帯 銃隊 紐帯 縦隊 重態 重体 渋滞"
"じゅうたく 住宅"
"じゅうたくろーん 住宅ローン"
"じゅうたん 絨緞 絨毯"
"じゅうだい 重代 十大 十代 重大"
"じゅうだん 銃彈 十段 銃弾 縦断"
"じゅうちん 重鎮"
"じゅうつうざい 縦通材"
"じゅうてい 重訂 従弟"
"じゅうてき 獣的"
"じゅうてん 充填 重点"
"じゅうでん 充電"
"じゅうでんち 充電池"
"じゅうとう 充棟 重盗 住棟 充当"
"じゅうとうほう 銃刀法"
"じゅうとく 重篤"
"じゅうとこうだん 住都公団"
"じゅうど 重度"
"じゅうどう 柔道"
"じゅうなん 柔軟"
"じゅうに １２ 十二"
"じゅうにがつ 極月 師走"
"じゅうにく 獣肉"
"じゅうにし 子丑寅卯辰巳午未申酉戌亥 十二支"
"じゅうにしちょう 十二指腸"
"じゅうにしちょうがん 十二指腸癌"
"じゅうにじんしょう 十二神将"
"じゅうにてん 十二天"
"じゅうにひとえ 十二単"
"じゅうにん 十人 重任 住人"
"じゅうねん 十念 十年"
"じゅうのうしゅぎ 重農主義"
"じゅうはち 十八"
"じゅうはちきん １８禁"
"じゅうはっしりゃく 十八史略"
"じゅうはっぱん 十八般"
"じゅうはん 従犯 重犯 重版"
"じゅうばい 十倍"
"じゅうばこ 重箱"
"じゅうばつ 重罰"
"じゅうばん 十番 重版"
"じゅうひ 柔皮 獣皮"
"じゅうびょう 重病"
"じゅうふく 重複"
"じゅうぶ 十分"
"じゅうぶつ 従物"
"じゅうぶん 重文 充分 十分"
"じゅうへい 従兵"
"じゅうべえ 十平衛"
"じゅうべん 重弁"
"じゅうべんか 重弁花"
"じゅうほう 什宝 重砲 銃砲 重宝"
"じゅうほうでん 充放電"
"じゅうぼう 住房"
"じゅうぼく 従僕"
"じゅうまい 従妹 十枚"
"じゅうまん 十万 充満"
"じゅうまんおくど 十万億土"
"じゅうみん 住民"
"じゅうめい 十名"
"じゅうめん 従免 渋面"
"じゅうもう 柔毛 獣毛 絨毛"
"じゅうもうまく 絨毛膜"
"じゅうもつ 什物"
"じゅうや 十夜"
"じゅうやく 重厄 重訳 十薬 重役"
"じゅうゆ 重油"
"じゅうよう 充用 重用 重要"
"じゅうよく 獣欲"
"じゅうよん 十四"
"じゅうらい 従来"
"じゅうらん 縦覧"
"じゅうり 重利"
"じゅうりょう 銃猟 十両 従量 重量"
"じゅうりょうあげ 重量挙げ"
"じゅうりょく 重力"
"じゅうりょくれんず 重力レンズ"
"じゅうりん 蹂躪 蹂躙"
"じゅうるい 獣類"
"じゅうれつ 縦列"
"じゅうれん 重連"
"じゅうろう 十郎"
"じゅうろうた 十郎太"
"じゅうろく 十六"
"じゅうろくしん １６進"
"じゅうわり 十割"
"じゅえい 樹影 寿永"
"じゅえき 樹液 受益"
"じゅおん 受音"
"じゅか 樹香 儒家 樹下"
"じゅかい 授戒 受戒 樹海"
"じゅかせきじょう 樹下石上"
"じゅかん 入棺 樹間 樹幹 樹冠"
"じゅがく 儒学"
"じゅがん 呪願"
"じゅき 授記"
"じゅきしゃ 受寄者"
"じゅきぶつ 受寄物"
"じゅきゅう 受給 需給"
"じゅきょう 授亨 受教 儒教"
"じゅぎょう 受業 授業"
"じゅく 宿 孰 受苦 熟 塾"
"じゅくいん 塾員"
"じゅくぎ 熟議"
"じゅくこう 塾高 塾講 熟考"
"じゅくご 熟語"
"じゅくし 熟思 熟柿 熟視"
"じゅくじ 熟字"
"じゅくじょ 熟女"
"じゅくすい 熟睡"
"じゅくせい 塾生 熟成"
"じゅくたつ 熟達"
"じゅくだん 熟談"
"じゅくち 熟知"
"じゅくちょう 塾長"
"じゅくとう 塾頭"
"じゅくど 熟度"
"じゅくどく 熟読"
"じゅくない 塾内"
"じゅくねん 熟年"
"じゅくみん 熟眠"
"じゅくらん 熟覧"
"じゅくりょ 熟慮"
"じゅくれん 熟練"
"じゅくん 受勲"
"じゅけい 綬鶏 受継 受刑 樹形"
"じゅけつしゃ 受血者"
"じゅけん 授権 受検 受験"
"じゅげ 頌偈"
"じゅげむ 寿限無"
"じゅげん 呪言"
"じゅこう 珠光 受光 樹高 受講"
"じゅこん 樹根"
"じゅごん 儒艮 呪禁"
"じゅさつ 呪殺"
"じゅさん 授産"
"じゅし 儒子 豎子 孺子 呪師 樹枝 樹脂"
"じゅしゃ 儒者"
"じゅしゅ 樹種"
"じゅしょ 儒書"
"じゅしょう 受傷 綬章 受章 授賞 受賞"
"じゅしん 受身 樹心 受診 受信"
"じゅしんたん 受信端"
"じゅしんばこ 受信箱"
"じゅじ 誦持"
"じゅじゅ 受授 授受"
"じゅじゅつ 呪術"
"じゅじょう 樹状 樹上"
"じゅすい 入水"
"じゅすいそう 受水槽"
"じゅず 数珠"
"じゅずだま 数珠玉"
"じゅせい 儒生 寿星 授精 樹勢 受精"
"じゅせいはい 受精胚"
"じゅせいらん 受精卵"
"じゅせん 受洗"
"じゅぜん 受禅"
"じゅそ 呪咀 受訴 呪詛"
"じゅそう 樹霜 樹相"
"じゅぞう 受像 受贈"
"じゅたい 受胎"
"じゅたく 受託"
"じゅだい 入内"
"じゅだく 受諾"
"じゅちゅう 受注"
"じゅちょう 受聴"
"じゅっかい 十誡 十階 述懐 十戒"
"じゅっかいき 十回忌"
"じゅっかいてん 十回転"
"じゅっかんじゅうにし 十干十二支"
"じゅっきゅう 恤救"
"じゅっけい 術計"
"じゅっこ 十個"
"じゅっこう 熟考"
"じゅっさく 述作 術策"
"じゅっし 十指"
"じゅっしゅうねん 十周年"
"じゅっしん １０進 十進"
"じゅっすう 術数"
"じゅっちゅう 十中 術中"
"じゅっつう 十通"
"じゅって 十手"
"じゅっとく 十徳 拾得"
"じゅっぱ 十羽 十把"
"じゅっぴき 十匹"
"じゅっぷん 十分"
"じゅっぽ 十歩"
"じゅつ 恤 戌 朮 述 術"
"じゅつかい 述懐"
"じゅつぎ 術技"
"じゅつご 術語 術後 述語"
"じゅつし 術師 術士"
"じゅつしき 術式"
"じゅつしゃ 術者"
"じゅつぜん 術前"
"じゅつちゅう 術中"
"じゅつてき 術的"
"じゅつぶ 述部"
"じゅつほう 術法"
"じゅつり 術理"
"じゅでん 受電"
"じゅどう 受動"
"じゅなん 受難"
"じゅにく 受肉"
"じゅにゅう 授乳"
"じゅにゅうふ 授乳婦"
"じゅにん 受忍"
"じゅねーぶ 壽府"
"じゅねーぶぐんしゅくかいぎ ジュネーブ軍縮会議"
"じゅのう 受納"
"じゅはい 受配"
"じゅばく 呪縛"
"じゅばん 襦袢"
"じゅひ 樹皮"
"じゅひょう 樹氷"
"じゅひょうげん 樹氷原"
"じゅふ 授付 呪符"
"じゅふく 寿福"
"じゅふん 受粉"
"じゅふんじゅ 受粉樹"
"じゅぶつ 儒仏 呪物"
"じゅへい 寿平"
"じゅへんでん 受変電"
"じゅほう 呪法"
"じゅみょう 寿命"
"じゅめい 受命"
"じゅもく 樹木"
"じゅもん 呪文"
"じゅよ 授与"
"じゅよう 受容 需要"
"じゅらい 入来"
"じゅらき ジュラ紀"
"じゅらく 入洛 聚楽"
"じゅらくだい 聚楽第"
"じゅらくやき 聚楽焼"
"じゅり 寿理 珠理 朱里 樹理 樹里 受理"
"じゅりつ 樹立"
"じゅりょう 授領 受療 受領"
"じゅりょく 呪力"
"じゅりん 樹林"
"じゅれい 樹苓 寿齢 樹齢"
"じゅろう 入牢"
"じゅろうじん 寿老人"
"じゅわ 受話"
"じゅん 篤 詢 荀 笋 筍 洵 恂 徇 殉 旬 循 楯 盾 隼 凖 准 蓴 遵 諄 惇 醇 淳 閏 潤 馴 巡 準 純 順"
"じゅんあい 純愛"
"じゅんあつ 順圧"
"じゅんあんくうこう 順安空港"
"じゅんい 遵依 準尉 准尉 準位 順位"
"じゅんいち 遵一 准一 潤一 順一 淳一 純一"
"じゅんいつ 純一"
"じゅんいん 準員"
"じゅんえき 準駅 純益"
"じゅんえつ 巡閲"
"じゅんえん 順縁 巡演 順延"
"じゅんおう 順応"
"じゅんおん 純音"
"じゅんか 醇化 馴化 順化 純化"
"じゅんかい 巡回"
"じゅんかつ 潤滑"
"じゅんかん 准看 旬間 旬刊 循環"
"じゅんきゅう 準急"
"じゅんきょ 準拠"
"じゅんきょう 順境 殉教"
"じゅんきん 純金"
"じゅんぎゃく 順逆"
"じゅんぎょう 巡行 巡業"
"じゅんぎん 純銀"
"じゅんぐり 順繰り"
"じゅんぐん 準群"
"じゅんけい 巡警 順慶 純系"
"じゅんけつ 準決 純血 純潔"
"じゅんけん 純絹 巡見 巡検"
"じゅんげつ 旬月"
"じゅんげん 純減"
"じゅんこ ＪＵＮＫＯ 純乎 醇乎 惇子 準子 絢子 潤子 淳子 順子 純子"
"じゅんこう 純項 巡幸 順行 順光 巡行 巡航"
"じゅんこうみさいる 巡航ミサイル"
"じゅんこく 殉国"
"じゅんさ 巡査"
"じゅんさい 蓴菜"
"じゅんさいあか ジュンサイ亜科"
"じゅんさつ 巡察"
"じゅんざや 順鞘"
"じゅんし 潤史 荀子 殉死 巡視"
"じゅんしゃく 巡錫"
"じゅんしゅ 巡酒 循守 順修 巡守 巡狩 醇酒 順守 遵守"
"じゅんしょう 順昭 准将"
"じゅんしょく 純色 潤色 殉職"
"じゅんしん 順心 純心 純真"
"じゅんじ 洵二 淳嗣 純治 順司 純次 純司 順次 純二 順二 順治 淳司 淳二"
"じゅんじつ 閏日 旬日"
"じゅんじゅん 循循 恂恂 諄諄 順順 準々 諄々 順々"
"じゅんじょ 順序"
"じゅんじょう 純情"
"じゅんじょづけ 順序付"
"じゅんすい 純水 純粋"
"じゅんすいし 純粋詩"
"じゅんせい 醇正 順清 準星 準正 純正"
"じゅんせつ 順接"
"じゅんせん 準線"
"じゅんぜん 純然"
"じゅんそう 順走"
"じゅんそく 準則"
"じゅんそん 純損"
"じゅんぞう 淳三 純増"
"じゅんたいじょし 準体助詞"
"じゅんたく 潤沢"
"じゅんち 馴致"
"じゅんちょう 順潮 順調"
"じゅんて 順手"
"じゅんてき 準的"
"じゅんてん 順天"
"じゅんとう 順当"
"じゅんとく 潤徳 順徳"
"じゅんど 純度"
"じゅんな 純名"
"じゅんなてんのう 淳和天皇"
"じゅんなま 純生"
"じゅんなん 殉難"
"じゅんにんてんのう 淳仁天皇"
"じゅんねん 閏年"
"じゅんのう 順応"
"じゅんのすけ 純之介 順之介 淳之介"
"じゅんばん 順番"
"じゅんぱい 潤肺 巡拝"
"じゅんぱく 純白"
"じゅんび 準備"
"じゅんびょう 閏秒"
"じゅんぴつりょう 潤筆料"
"じゅんぶん 純分"
"じゅんぷう 醇風 淳風 順風"
"じゅんぺい 順平"
"じゅんぼく 淳朴 純朴"
"じゅんぽう 遵奉 順法 遵法 旬報"
"じゅんまい 純米"
"じゅんめ 順目 巡目"
"じゅんめん 純綿"
"じゅんもう 純毛"
"じゅんや 潤哉 順彌 潤也 純也"
"じゅんゆう 巡遊"
"じゅんよ 閏余 旬余"
"じゅんよう 巡洋 準用"
"じゅんら 巡邏"
"じゅんらん 巡覧"
"じゅんり 純理 純利"
"じゅんりょう 純量 順良 純良"
"じゅんれい 巡礼"
"じゅんれいやど 巡礼宿"
"じゅんれき 巡歴"
"じゅんれつ 順列"
"じゅんろ 順路"
"じゆう 事由 自由"
"じゆうがおか 自由が丘"
"じゆうし 自由詩"
"じゆうたん 自由端"
"じゆうのめがみ 自由の女神"
"じゆうれん 自由練"
"じょ 杼 莇 耡 鋤 舒 抒 蜍 除 徐 敘 敍 叙 汝 茹 絮 洳 恕 如 女 所 助 序"
"じょい 叙位 女医"
"じょいん 女陰"
"じょう 星 生 盛 成 貞 疂 疉 疊 塲 繩 縄 蟐 嬲 嫋 仍 娘 擾 冗 躡 聶 茸 條 絛 滌 饒 蕘 遶 繞 烝 拯 蒸 丞 諚 定 乘 剩 剰 靜 淨 瀞 静 浄 釀 讓 穰 驤 襄 禳 攘 孃 壤 醸 譲 穣 壌 仗 杖 丈 尉 判官 常 城 帖 畳 嬢 条 乗 状 場 錠 情 上"
"じょうあい 情合 情愛"
"じょうあつ 常圧"
"じょうい 上医 上衣 上意 譲位 情意 攘夷 上位"
"じょういうち 上意討ち"
"じょういき 浄域"
"じょういち 譲一"
"じょういば 上位馬"
"じょういん 畳韻 冗員 剰員 上院 乗員"
"じょううち 常打"
"じょうえ 浄穢 浄衣"
"じょうえい 貞永 上映"
"じょうえつ 上謁 上越"
"じょうえん 情炎 上演"
"じょうおう 貞応 女王"
"じょうおく 場屋"
"じょうおん 上音 常温"
"じょうか 上下 情科 情火 浄火 情歌 城下 浄化"
"じょうかい 浄界 場開 上界 常会 上階"
"じょうかく 定格 城廓 城閣 娘核 城郭"
"じょうかた 城方"
"じょうかまち 城下街"
"じょうかるび 上カルビ"
"じょうかん 上澣 冗官 常関 上浣 条款 上燗 乗艦 城館 上官 情感 上巻"
"じょうがい 城外 場外"
"じょうがく 上顎"
"じょうがくら 城ケ倉"
"じょうがさき 城ケ崎"
"じょうがしま 城ヶ島"
"じょうがん 情願 貞観"
"じょうがんじがわ 常願寺川"
"じょうき 情機 蒸氣 常規 常軌 条規 上気 蒸気 上記"
"じょうきがま 蒸気缶"
"じょうきぎり 蒸気霧"
"じょうきげん 上喜元"
"じょうきゃく 常客 上客 乗客"
"じょうきゃくるい 橈脚類"
"じょうきゅう 上丘 承久 上級"
"じょうきゅうしゃむけ 上級者向"
"じょうきょう 情教 常況 貞享 情況 上京 状況"
"じょうきょうてきにんち 状況的認知"
"じょうきん 常勤"
"じょうぎ 情宜 情義 情誼 定規"
"じょうぎょう 常行"
"じょうく 畳句 冗句"
"じょうくう 上空"
"じょうぐう 上宮"
"じょうけい 杖刑 常形 場景 常経 上計 上掲 情景"
"じょうけん 情研 條件 条件"
"じょうけんづけ 条件付"
"じょうけんば 条件馬"
"じょうげ 上下"
"じょうげさゆう ↑↓←→"
"じょうげどう 上下動"
"じょうげん 貞元 上元 上弦 上限"
"じょうこ 上戸 杖鼓 上古"
"じょうこう 上行 上向 情工 情交 上皇 乗降 条項"
"じょうこうしゃ 乗工社"
"じょうこく 上告"
"じょうこしゃそ 城狐社鼠"
"じょうこん 定根 条痕 乗根 上根"
"じょうこんばん 条痕板"
"じょうご 常語 剰語 冗語 畳語 漏斗 上戸"
"じょうごう 乗号"
"じょうごわ 情強"
"じょうさい 条西 攘災 城西 城砦 城塞"
"じょうさいぼう 嬢細胞"
"じょうさく 縄索 城柵 上作 上策"
"じょうさし 状差 状差し"
"じょうさま 嬢様 上様"
"じょうさん 乗算 蒸散"
"じょうざ 常座 定座 上座"
"じょうざい 剰剤 杖罪 浄罪 常在 浄財 錠剤"
"じょうざん 常山 乗算"
"じょうざんけい 定山渓"
"じょうし 上巳 情子 情シ 上士 情死 上使 城市 上梓 上肢 城址 上司"
"じょうしき 常式 上式 定式 常識"
"じょうした 城下"
"じょうしつ 上質"
"じょうしゃ 浄写 盛者 乗車"
"じょうしゃとびら 乗車扉"
"じょうしゅ 情趣 城主"
"じょうしゅう 城州 常州 上州 常習"
"じょうしゅく 定宿"
"じょうしょ 条書 情処 情緒 浄書 上書"
"じょうしょう 上声 丞相 常勝 上昇"
"じょうしょく 常食"
"じょうしん 上進 浄心 上申 上唇 上新"
"じょうしんこ 上新粉"
"じょうしんでんてつ 上信電鉄"
"じょうじ 常児 丈嗣 条二 畳字 丈治 情事 丈二 貞治 常時 譲二"
"じょうじせいたい 常磁性体"
"じょうじつ 情実"
"じょうじま 城島"
"じょうじゅ 上寿 譲受 成就"
"じょうじゅう 常住"
"じょうじゅつ 杖術 上述"
"じょうじゅん 上旬"
"じょうじょ 乗除"
"じょうじょう 擾擾 穣穣 常情 嫋嫋 畳畳 条条 烝烝 常状 常常 上乗 上上 情状 上場 上々"
"じょうじょうきち 上々吉"
"じょうじょざん 乗除算"
"じょうじん 成尋 情人 常人"
"じょうすい 定水 上水 浄水"
"じょうすいち 浄水池"
"じょうすう 剰数 定数 条数 常数 乗数"
"じょうすうけん 情数研"
"じょうすけ 譲介"
"じょうず 上図 上手"
"じょうせい 上声 状勢 上清 上製 城西 醸成 情勢"
"じょうせいほん 情制本"
"じょうせき 攘斥 城蹟 鐘石 乗積 上積 定席 定跡 城跡 上席 定石"
"じょうせきもん 縄蓆文"
"じょうせつ 常設"
"じょうせついん 浄雪院"
"じょうせん 上船 情宣 乗船"
"じょうせんしょくたい 常染色体"
"じょうぜつ 饒舌"
"じょうぜん 定禅"
"じょうぜんじどおり 定禅寺通"
"じょうぜんみずのごとし 上善如水"
"じょうそ 上疏 上訴"
"じょうそう 情想 上奏 常総 情操 上層"
"じょうそく 常則"
"じょうぞう 醸造"
"じょうた 饒多"
"じょうたい 上腿 情態 常体 常態 上体 状態"
"じょうたいべくとる 状態ベクトル"
"じょうたつ 上達"
"じょうたん 上端"
"じょうだい 城代 上代"
"じょうだま 上玉"
"じょうだん 上段 冗談"
"じょうだんぬき 冗談抜"
"じょうち 情致 情痴 城地 常置 上地 上知 上智"
"じょうちゃく 蒸着"
"じょうちゃくまく 蒸着膜"
"じょうちゃん 嬢ちゃん"
"じょうちゅう 城中 静注 焼酎 常駐"
"じょうちゅうげ 上中下"
"じょうちょ 情緒"
"じょうちょう 上聴 情調 上長 場長 冗長"
"じょうちょく 常直"
"じょうつう 情通"
"じょうてい 上底 上帝 上程"
"じょうてもの 上手物"
"じょうてん 上天"
"じょうでんけん 情電研"
"じょうと 譲渡"
"じょうとう 上道 上棟 常套 城東 上等"
"じょうとく 常徳"
"じょうとくい 常得意"
"じょうど 浄土"
"じょうどう 杖道 成道 常道 情動"
"じょうどうきょく 常動曲"
"じょうどうしょう 常同症"
"じょうどがはま 浄土ヶ浜"
"じょうない 城内 場内"
"じょうなん 城南"
"じょうにん 常人 常任"
"じょうねつ 情熱"
"じょうねん 情念"
"じょうの 上の"
"じょうのう 上納"
"じょうのうち 城之内"
"じょうはく 上拍 上膊 上白"
"じょうはつ 蒸発"
"じょうはな 城端"
"じょうはり 浄玻璃"
"じょうはん 上半 畳半"
"じょうはんしんはだか 上半身裸"
"じょうば 乗馬"
"じょうばこ 状箱"
"じょうばん 定盤 常磐"
"じょうひ 冗費 上皮"
"じょうひょう 上平 上表"
"じょうひん 上品"
"じょうび 常備"
"じょうびさい 常備菜"
"じょうびたき 尉鶲"
"じょうびぶん 常微分"
"じょうふ 丈夫 上布 情夫 情婦"
"じょうふく 浄福 条幅"
"じょうぶ 上部 丈夫"
"じょうぶくろ 状袋"
"じょうぶつ 成仏"
"じょうぶん 冗文 上聞 上文 上分 条文"
"じょうへい 城兵"
"じょうへき 城壁"
"じょうへん 上篇 上編 城辺 上辺"
"じょうほ 譲歩"
"じょうほう 城寳 城堡 城宝 常法 乗法 定法 上方 情報"
"じょうほうじ 浄法寺"
"じょうほうせんたー 情報センター"
"じょうほうだい 情報第"
"じょうほうばん 情報板"
"じょうほうめでぃあ 情報メディア"
"じょうほく 常北 城北"
"じょうぼう 上房"
"じょうぼく 縄墨 上木"
"じょうぼん 常凡"
"じょうぼんれんだいじ 上品蓮台寺"
"じょうまい 上米"
"じょうまえ 錠前"
"じょうまん 冗漫"
"じょうみ 情味"
"じょうみの 上ミノ"
"じょうみゃく 静脈"
"じょうみゃくけつ 静脈血"
"じょうみょう 定命"
"じょうみん 常民"
"じょうむ 乗務 常務"
"じょうめん 尉面 上面"
"じょうもう 上毛"
"じょうもく 条目"
"じょうもの 上物"
"じょうもん 定紋 城門 縄文"
"じょうもんしきどき 縄文式土器"
"じょうもんすぎ 縄文杉"
"じょうや 長夜 常夜"
"じょうやく 定役 条約"
"じょうやとい 常雇い"
"じょうやとう 常夜燈"
"じょうやど 常宿 定宿"
"じょうゆ 上諭 醤油"
"じょうゆいしきろん 成唯識論"
"じょうゆう 城邑"
"じょうよ 剩餘 丈余 譲与 剰余"
"じょうよう 上陽 常陽 城陽 乗用 常用"
"じょうよく 情慾 情欲"
"じょうらく 常楽 上洛"
"じょうらくかい 情洛会"
"じょうらん 上覧 擾乱 上欄"
"じょうり 杖履 常理 情理 条里 条理"
"じょうりく 上陸"
"じょうりつ 乗率"
"じょうりゃく 上略"
"じょうりゅう 蒸溜 蒸留 上流"
"じょうりゅうさいと 上流サイト"
"じょうりょう 丈量"
"じょうりょく 常緑"
"じょうりょくじゅ 常緑樹"
"じょうるり 浄瑠璃"
"じょうるりひめものがたり 浄瑠璃姫物語"
"じょうれい 浄霊 上例 常例 条令 条例"
"じょうれん 定連 常連"
"じょうれんさん 常連さん"
"じょうろ 女郎 如露 如雨露"
"じょうろう 上臘 上臈 城楼"
"じょうろきょう 上路橋"
"じょうろく 丈六"
"じょうろん 諍論"
"じょうわ 貞和 情話"
"じょうわん 上腕"
"じょえん 助演"
"じょおう 女王"
"じょおうあり 女王蟻"
"じょおうばち 女王蜂"
"じょおん 助音"
"じょか 序歌"
"じょかい 叙階"
"じょかく 除核"
"じょかん 女官"
"じょがい 除外"
"じょがいば 除外馬"
"じょがく 女楽"
"じょがくいん 女学院"
"じょがくえん 女学園"
"じょがくせい 女学生"
"じょがっかん 女学館"
"じょがっこう 女學校 女学校"
"じょきゃく 除却"
"じょきゅう 女給"
"じょきょ 除去"
"じょきょう 助教"
"じょきょく 序曲"
"じょきん 助勤 除菌"
"じょく 褥 蓐 縟 溽 辱"
"じょくしょ 溽暑"
"じょくせ 濁世"
"じょくそう 辱創 蓐瘡 褥瘡"
"じょくち 辱知"
"じょくふ 褥婦"
"じょくれい 縟礼"
"じょくん 叙勲"
"じょけい 叙景 女系"
"じょけつ 女傑"
"じょけん 女権"
"じょけんはんけつ 除権判決"
"じょげん 序言 助言"
"じょこう 除光 女皇 女工 徐行"
"じょこつ 鋤骨"
"じょご 助語"
"じょごう 除号"
"じょさい 如才 助祭"
"じょさん 除算"
"じょさんし 助産師"
"じょざい 助材 助剤"
"じょざん 除算"
"じょし 序詩 序詞 助詞 女史 女子"
"じょしき 女色"
"じょしちゅうせい 女子中生"
"じょしつ 除湿"
"じょしといれ 女子トイレ"
"じょしぷろ 女子プロ"
"じょしべん 女子便"
"じょしゃく 叙爵"
"じょしゅ 助手"
"じょしゅう 除臭 徐州 女囚"
"じょしょう 女将 序章"
"じょしょく 女色"
"じょしりょう 女子寮"
"じょしん 女神 女真"
"じょじ 序次 助辞 助字 叙事 女児"
"じょじし 叙事詩"
"じょじゅつ 叙述"
"じょじょ 序々 徐々"
"じょじょう 如上 抒情 叙情"
"じょじょうし 叙情詩 抒情詩"
"じょじょうふ 女丈夫"
"じょじょに 徐々に"
"じょすい 除水 如水"
"じょすう 助数 除数 序数"
"じょせい 助勢 女婿 女声 助成 女性"
"じょせいと 女生徒"
"じょせいほるもん 女性ホルモン"
"じょせき 除斥 除籍"
"じょせつ 絮説 叙説 序説 除雪"
"じょせん 女専"
"じょそう 除装 助奏 序奏 助走 除草 女装"
"じょそんだんぴ 女尊男卑"
"じょたい 所帯 女体 除隊"
"じょたんぱく 除蛋白"
"じょちゅう 除虫 女中"
"じょちゅうぎく 除虫菊"
"じょちょう 助長"
"じょつう 除痛"
"じょてい 女帝"
"じょてんいん 女店員"
"じょどう 女童"
"じょなん 女難"
"じょにだん 序二段"
"じょにん 叙任"
"じょのくち 序ノ口 序の口"
"じょはきゅう 序破急"
"じょばす 女バス"
"じょばん 序番 序盤"
"じょひ 女卑"
"じょひょう 除表 除票"
"じょぶん 序文"
"じょへん 徐変"
"じょほう 叙法 除法"
"じょまく 序幕 除幕"
"じょみゃく 徐脈"
"じょめい 助命 除名"
"じょめいてんのう 舒明天皇"
"じょもう 除毛"
"じょや 除夜"
"じょやく 助役"
"じょやなべ 除夜鍋"
"じょやのかね 除夜の鐘"
"じょゆう 女優"
"じょりゅう 女流"
"じょりょく 助力"
"じょれい 除霊"
"じょれつ 序列"
"じょろう 女郎"
"じょろうぐも 女郎蜘蛛"
"じょろん 序論"
"じょんがらぶし じょんがら節"
"じよ 時余 爾余 自余"
"じよう 自養 次葉 自用 滋養"
"じらい 爾来 地雷"
"じらいげん 地雷原"
"じらいや 児雷也"
"じり 尻 自利 事理"
"じりき 地力 自力"
"じりだか ジリ高 じり高"
"じりつ 持律 侍立 而立 自律 自立"
"じりひん じり貧 ジリ貧"
"じりゃく 治暦"
"じりやす ジリ安 じり安"
"じりゅう 自流 時流"
"じりゅうち 自留地"
"じりょう 寺領"
"じりょく 恃力 磁力"
"じりょくかいそう 自力回送"
"じりょくきゅうさい 自力救済"
"じりん 字林 辞林"
"じる 汁"
"じるい 字類"
"じるいしょう 字類抄"
"じるし 印"
"じれい 辞礼 自励 辞令 事例"
"じれき 事歴"
"じれつ 字列"
"じれん 自連"
"じろ 字路"
"じろう 子郎 治朗 次朗 二朗 治郎 二郎 次郎 耳漏 痔瘻"
"じろちょう 次郎長"
"じろん 時論 持論"
"じろんどは ジロンド派"
"じわり 地割り 地割"
"じわれ 地割れ"
"じん 稔 進 臣 塵 糂 甚 靱 仭 仞 靭 刄 刃 荏 恁 壬 尽 侭 儘 贐 盡 燼 蕁 潯 尋 訊 迅 神 腎 仁 陣 人"
"じんあい 塵埃 仁愛"
"じんい 人意 人為"
"じんいしょく 腎移植"
"じんいち 塵一 仁一"
"じんいん 人員"
"じんう 腎盂"
"じんえい 陣営"
"じんえん 人煙 腎炎"
"じんか 人家"
"じんかい 燼灰 塵界 人海 人界 塵芥"
"じんかいは 塵芥破"
"じんかく 人格"
"じんかくしん 人格神"
"じんかん 腎管 人感 人勧 人間"
"じんがい 塵外 人外"
"じんがさ 陣笠"
"じんき 神亀"
"じんきのう 腎機能"
"じんきょ 人居 腎虚"
"じんきょう 人境"
"じんぎ 人技 神祇 神器 仁義"
"じんぎすかん 成吉思汗"
"じんく 神供 甚句"
"じんくん 人君"
"じんぐう 神供 神功 神宮"
"じんぐうしちょう 神宮司庁"
"じんけい 仁兄 仁恵 陣形"
"じんけっせき 腎結石"
"じんけつ 人傑"
"じんけん 人絹 人件 人権"
"じんげん 人言"
"じんこ 神庫 仁子"
"じんこう 塵垢 櫁 樒 人皇 沈香 人工 人口"
"じんこううみ 人工海"
"じんこうえさ 人工餌"
"じんこうき 塵功記 塵劫記"
"じんこうこ 人工湖"
"じんこうしば 人工芝"
"じんこうじ 人工耳"
"じんこうすな 人工砂"
"じんこうとう 人工島"
"じんこうにゅう 人工乳"
"じんこうむのう 人工無脳"
"じんこうゆき 人工雪"
"じんこうりん 人工林"
"じんこつ 人骨"
"じんご 人後 人語"
"じんごうき 塵劫記"
"じんごけいうん 神護景雲"
"じんごじ 神護寺"
"じんごろう 甚五郎"
"じんさい 人災"
"じんざい 人財 人材"
"じんざいなん 人材難"
"じんざぶろう 甚三郎"
"じんし 尋思 人士"
"じんしっかんかんじゃ 腎疾患患者"
"じんしゅ 人種"
"じんしょ 陣所"
"じんしょう 人証 腎症"
"じんしん 人臣 壬申 人心 人身"
"じんしんのじゆう 人身の自由"
"じんじ 仁慈 神事 人事"
"じんじいん 人事院"
"じんじがかり 人事掛"
"じんじつ 人日 尽日"
"じんじゃ 神社"
"じんじゅ 仁寿 人寿"
"じんじゅう 人獣"
"じんじゅつ 仁術"
"じんじょ 仁恕"
"じんじょう 晨朝 尋常"
"じんじん 仁人"
"じんすい 腎水 尽瘁"
"じんすけ 甚介"
"じんずう 神通"
"じんせい 靭性 仁政 人声 人世 人性 人生"
"じんせいとうにょう 腎性糖尿"
"じんせき 神石 人跡"
"じんせん 仁山 仁川 人選"
"じんせんぬま 神仙沼"
"じんぜん 荏苒 人前"
"じんぜんじ 秦泉寺"
"じんそく 迅速"
"じんぞう 人造 腎臓"
"じんぞうこ 人造湖"
"じんたい 靱帯 靭帯 人体"
"じんたん 仁丹"
"じんだい 神代 甚大"
"じんだいこ 陣太鼓"
"じんだいじ 深大寺"
"じんだいめいし 人代名詞"
"じんち 人智 人知 陣地"
"じんちく 人畜"
"じんちゅう 人中 尽忠 陣中"
"じんちょう 晨朝 刃長"
"じんちょうげ 沈丁花"
"じんつう 陣痛"
"じんつうがわ 神通川"
"じんつうりき 神通力"
"じんてい 人定"
"じんてき 人的"
"じんてん 人天"
"じんとう 陣頭 人頭"
"じんとうせき 腎透析"
"じんとく 仁篤 仁徳 人徳"
"じんとり 陣取 神取 陣取り"
"じんど 塵土"
"じんどう 仁道 人道"
"じんどくせい 腎毒性"
"じんない 陣内"
"じんなん 神南"
"じんにく 人肉"
"じんにゅう 人乳"
"じんにょう 人尿"
"じんにん 神人"
"じんのうしょうとうき 神皇正統記"
"じんはい 塵肺"
"じんば 陣場 神馬 人馬"
"じんばおり 陣羽織"
"じんぱい じん肺 塵肺"
"じんぱち 甚八"
"じんぴ じん皮 深秘 人肥 靭皮"
"じんぴん 人品"
"じんふぜん 腎不全"
"じんぶつ 人物"
"じんぶん 人文"
"じんぷう 陣風 仁風"
"じんぷく 尋腹"
"じんぷん 人糞"
"じんべい 甚平"
"じんべえ 甚兵衛"
"じんぺい 甚平 仁平"
"じんほけん 人保険"
"じんぼ 神保"
"じんぼあきら 神保彰"
"じんぼう 神保 人望"
"じんぼつ 陣没"
"じんぽ 神保"
"じんぽんしゅぎ 人本主義"
"じんまく 陣幕"
"じんましん 蕁麻疹"
"じんみゃく 人脈"
"じんみん 人民"
"じんみんだいかいどう 人民大会堂"
"じんみんへい 人民幣"
"じんむ 神武"
"じんむちょう 神武朝"
"じんめい 神名 神明 人命 人名"
"じんめん 人面"
"じんめんいわ 人面岩"
"じんめんそ 人面疽"
"じんもう 人毛"
"じんもん 陣門 訊問 尋問"
"じんや 陣屋"
"じんよう 陣容"
"じんよく 人欲"
"じんらい 人籟 迅雷"
"じんりき 尽力 人力"
"じんりきしゃ 俥"
"じんりゅう 神竜"
"じんりょく 人力 尽力"
"じんりん 人倫"
"じんるい 人類"
"じんれつ 陣列"
"じんろう 塵労 人狼"
"じんろく 甚六"
"じんわ 人和"
"す 棲 過 壽 寿 籔 数 諏 笥 主 守 洲 州 子 栖 鬆 簀 醋 須 簾 酢 巣 素"
"すーあんこ 四暗刻"
"すーあんこー 四暗刻"
"すーつすがた スーツ姿"
"すーぷざら スープ皿"
"すーぷに スープ煮"
"すーほんぱい 四風牌"
"すあげ 素揚げ"
"すあし 素足"
"すあな 巣穴"
"すあま 素甘"
"すあらい 酢洗い"
"すい 酸い 埀 穂 出 帥 綏 彗 榱 衰 燧 邃 遂 陲 捶 誰 騅 推 隹 醉 粹 萃 瘁 忰 悴 翆 翠 膵 酔 吹 炊 睡 垂 錘 錐 水 粋"
"すいあげ 吸上げ"
"すいあつ 水圧"
"すいい 水位 推移"
"すいいき 水域"
"すいう 水宇"
"すいうん 衰運 水雲 水運"
"すいえい 水泳"
"すいえん 翠煙 炊煙 水鉛 垂涎 水煙 膵炎"
"すいおん 水温"
"すいか 水和 水禍 水瓜 翠霞 酔歌 誰何 垂下 水火 西瓜"
"すいかい 水界 水塊"
"すいかずら 忍冬"
"すいかわり スイカ割り"
"すいかん 吹管 酔漢 水干 水管"
"すいが 睡臥 酔臥"
"すいがい 水害"
"すいがら 吸いがら 吸い殻 吸殻"
"すいがん 水眼 膵がん 酔眼 膵癌"
"すいき 水気"
"すいきゃく 醉客 酔客"
"すいきゅう 推究 水球"
"すいきょ 推挙"
"すいきょう 酔郷 粋狂 酔狂"
"すいきん 水金 水禽"
"すいきんくつ 水琴窟"
"すいぎゅう 水牛"
"すいぎょ 水魚"
"すいぎょう 水行"
"すいぎょうざ 水餃子"
"すいぎょく 水玉 翠玉"
"すいぎん 水銀"
"すいぎんちゅう 水銀柱"
"すいくち 吸口 吸い口"
"すいくん 垂訓"
"すいぐん 水軍"
"すいぐんせん 水郡線"
"すいけい 錐形 推計 水系"
"すいけん 推件 酔拳 水圏"
"すいげい 酔鯨"
"すいげつ 水月"
"すいげん 酔言 水源"
"すいこ 出挙 水滸 推古"
"すいこう 垂鉤 推考 水行 水耕 推敲 遂行"
"すいこうしゃ 水光社 水交社"
"すいこうねつひ 水光熱費"
"すいこみ 吸い込み"
"すいご 垂語 酔語"
"すいごう 水濠 水郷"
"すいさい 水砕 水災 水彩"
"すいさつ 推察"
"すいさん 推讃 水酸 推参 炊爨 推算 水産"
"すいさんかぶついおん 水酸化物イオン"
"すいざん 衰残"
"すいし 垂死 水死"
"すいしつ 水質"
"すいしゃ 水車"
"すいしゅ 水腫"
"すいしょ 粋書 水書"
"すいしょう 水漿 推称 推賞 水晶 推奨"
"すいしょうこんしき 水晶婚式"
"すいしょうだま 水晶玉"
"すいしょく 衰色 水色"
"すいしん 垂心 水深 推進"
"すいじ 垂示 炊事"
"すいじゃく 垂迹 衰弱"
"すいじゅん 水準"
"すいじゅんかん 水循環"
"すいじょう 錐状 穂状 水上"
"すいじょうき 水蒸気"
"すいじょうは 水上葉"
"すいじん 酔人 粋人 水神"
"すいじんしょう 水腎症"
"すいす 瑞西"
"すいすせい スイス製"
"すいず 水津"
"すいせい 水声 衰勢 水成 水勢 水棲 水生 水星 彗星 水性"
"すいせいがん 水成岩"
"すいせいぺん 水性ペン"
"すいせいむし 酔生夢死"
"すいせき 燧石 水石"
"すいせん 垂線 水栓 水洗 水仙 推薦"
"すいせんじゅか スイセンジュ科"
"すいせんちゅう 水栓柱"
"すいせんといれ 水洗トイレ"
"すいせんば 推薦馬"
"すいぜいてんのう 綏靖天皇"
"すいぜん 吹禅 垂涎"
"すいぜんじ 水前寺"
"すいぜんのまと 垂涎の的"
"すいそ H 水素"
"すいそいおん 水素イオン"
"すいそう 水そう 垂層 水葬 水層 水草 吹奏 水槽"
"すいそうがく 吹奏楽"
"すいそがす 水素ガス"
"すいそく 推測"
"すいそん 水損"
"すいぞう 酔象 膵臓"
"すいぞうがん 膵臓がん 膵臓癌"
"すいぞくえん 水族園"
"すいぞくかん 水族館"
"すいた 吹田"
"すいたい 衰頽 酔態 推戴 錐体 衰退"
"すいだし 吸い出し 吸出し"
"すいだん 推断"
"すいち 推知"
"すいちゅう 水柱 水中"
"すいちゅうか 水中花"
"すいちゅうは 水中葉"
"すいちゅうよくせん 水中翼船"
"すいちょう 推重 水鳥"
"すいちょうこうけい 翠帳紅閨"
"すいちょく ⊥ 垂直"
"すいづ 水津"
"すいてい 水底 推定"
"すいてき 水滴"
"すいてん 水天"
"すいでん 水田"
"すいと 水都"
"すいとう 膵島 水痘 水筒 水稲 出納"
"すいとうしょう 水頭症"
"すいとりがみ 吸取り紙 吸い取り紙"
"すいとん 水遁 水団"
"すいどう 隧道 水道"
"すいどうきょう 水道橋"
"すいどうせん 水道栓"
"すいどうめーたー 水道メーター"
"すいなん 水難"
"すいにょう 夊繞"
"すいにん 推認"
"すいにんてんのう 垂仁天皇"
"すいのう 水嚢"
"すいのみ 吸飲み 吸い飲み"
"すいは 水波"
"すいはん 水飯 垂範 炊飯"
"すいはんきゅう 水半球"
"すいはんじゃー 炊飯ジャー"
"すいばいか 水媒花"
"すいばく 水爆"
"すいばら 杉原 水原"
"すいばん 推挽 水盤"
"すいひ 水肥 水簸"
"すいひつ 水筆"
"すいび 粋美 翠微 衰微"
"すいふ 炊フ 炊夫 炊婦 水府 水夫"
"すいふく 推服"
"すいふくべ 吸い瓢"
"すいふよう 酔芙蓉"
"すいぶん 水分"
"すいへい 水兵 水平"
"すいへいたぶ 水平タブ"
"すいへいどう 水平動"
"すいへいばん 水平板"
"すいへん 水辺"
"すいほ 推歩 酔歩"
"すいほう 水胞 水疱 水泡"
"すいぼう 酔眸 衰亡 水防"
"すいぼく 水墨"
"すいぼつ 水没"
"すいま 水魔 睡魔"
"すいまつ 水沫"
"すいみつ 水蜜 水密"
"すいみつとう 水蜜桃"
"すいみつひ 水密扉"
"すいみゃく 水脈"
"すいみん 酔眠 睡眠"
"すいみんじむこきゅうしょうこうぐん 睡眠時無呼吸症候群"
"すいむ 水霧 睡夢 酔夢"
"すいめい 吹鳴 水明"
"すいめつ 衰滅"
"すいめん 睡眠 錐面 水面"
"すいもく 水木"
"すいもじ 推文字"
"すいもの 吸物 吸い物"
"すいものわん 吸い物椀"
"すいもん 水紋 水門"
"すいもんがく 水文学"
"すいやく 水薬"
"すいよ 睡余 酔余"
"すいよう 水溶 水曜"
"すいようえき 水様液"
"すいよく 水浴"
"すいらい 水雷"
"すいらん 翠嵐"
"すいり 水利 推理"
"すいりがく 水理学"
"すいりきがく 水力学"
"すいりく 水陸"
"すいりゅう 垂柳 水竜 水流"
"すいりゅうし 水龍士"
"すいりょう 推量 水量"
"すいりょく 翠緑 推力 水力"
"すいれい 水冷"
"すいれん 水練 睡蓮"
"すいれんあか スイレン亜科"
"すいれんか スイレン科"
"すいろ 水路"
"すいろん 水論 推論"
"すいわ 水和"
"すう 四 數 樞 枢 陬 菘 嵩 崇 鄒 芻 雛 趨 数"
"すうあんこ 四暗刻"
"すうあんこう 四暗刻"
"すうい 趨異"
"すうぇーでん 瑞典"
"すうぇーでんご スウェーデン語"
"すうぇーでんじん スウェーデン人"
"すうえき 数駅"
"すうおく 数億"
"すうおん 数音"
"すうかい 数回"
"すうかいけん 数理解析研究所 数解研"
"すうかん 数巻"
"すうがく 数学"
"すうがくきごう ⊥ ⌒ ∠ ¬ ∨ ∧ ∩ ∪ ⊃ ⊂ ⊇ ⊆ ∋ ∈ ≫ ≪ ≧ ≦ ≠ ≒ ∽ ≡ ∬ ∫ √ ∇ Δ ∂ ∃ ∀ ⇔ ⇒ ∵ ∴ ∝ ∞ ÷ × ±"
"すうがくばたけ 数学畑"
"すうがくもでる 数学モデル"
"すうき 枢機 数期 数基 数機 数奇"
"すうきょうきょう 数教協"
"すうきょく 数局 数曲"
"すうぎょう 数行"
"すうけい 崇敬"
"すうけた 数桁"
"すうけん 数理解析研究所 数研 数軒 数件"
"すうげき 数撃"
"すうこ 数戸 数個"
"すうこう 趨向 数項 数校 崇高"
"すうこく 数刻"
"すうご 数語"
"すうごう 数号"
"すうさく 数作"
"すうさつ 数冊"
"すうざん 嵩山"
"すうし 数詞"
"すうしいほう 四喜和"
"すうしき 数式"
"すうしきもーど 数式モード"
"すうしゃ 数社"
"すうしゅ 数種"
"すうしゅう 数周 数週"
"すうしゅん 数瞬"
"すうじ 数次 数字"
"すうじく 樞軸 枢軸"
"すうじっかい 数十回"
"すうじっかしょ 数十箇所"
"すうじっぽん 数十本"
"すうじつ 数日"
"すうじゅう 数十"
"すうじゅっかい 数十回"
"すうじゅっき 数十機"
"すうじゅっさつ 数十冊"
"すうじゅっしゅるい 数十種類"
"すうじゅっぽん 数十本"
"すうじょう 数条"
"すうせい 趨勢"
"すうせみ 数セミ"
"すうせん 数戦 数千"
"すうた 数多"
"すうたい 素謡 数体"
"すうだい 数台"
"すうだいまえ 数代前"
"すうだん 数段"
"すうち 数値"
"すうちでーた 数値データ"
"すうちもでる 数値モデル"
"すうつう 数通"
"すうて 数手"
"すうていれきしょ 崇禎暦書"
"すうてき 数滴 数的"
"すうてん 数店 数点"
"すうとう 数頭 数等"
"すうど 数度"
"すうどく 数独"
"すうどん 素饂飩"
"すうにち 数日"
"すうにん 数人"
"すうねん 数年"
"すうねんほどまえ 数年程前"
"すうはい 崇拝"
"すうはつ 数発"
"すうば 数馬"
"すうばい 数倍"
"すうぱい 数牌"
"すうひき 数匹"
"すうひゃく 数百"
"すうひゃっかい 数百階"
"すうひゃっき 数百機"
"すうひょう 数票 数表"
"すうびょう 数秒"
"すうふん 数分"
"すうぶつ 崇仏 数物"
"すうほ 数歩"
"すうほう 崇奉"
"すうほん 数本"
"すうまい 数枚"
"すうまん 数万"
"すうみつ 枢密"
"すうみついん 枢密院"
"すうみり 数ミリ"
"すうめい 数名"
"すうもん 数問"
"すうよう 枢要"
"すうり 数理情報科学 数理"
"すうりけん 数理解析研究所"
"すうりしすてむ 数理システム"
"すうりもでる 数理モデル"
"すうりょう 数量"
"すうれい 数例"
"すうれつ 数列"
"すうろん 数論"
"すうわ 数話"
"すうわり 数割"
"すえ 据 須恵 裔 甄 陶 末"
"すえあし 末足 末脚"
"すえいし 末石"
"すえお 季雄 末男"
"すえおか 末岡"
"すえおき 据置 据え置き 据置き"
"すえかね 末包"
"すえかわ 末川"
"すえき 末木 陶器"
"すえきち 末吉"
"すえごろ 末頃"
"すえざき 末崎"
"すえじ 末治"
"すえじま 末島"
"すえぜん 据え膳"
"すえたに 末谷"
"すえっこ 末っ子"
"すえつぐ 末次"
"すえつけ 据付け 据え付け 据付"
"すえつむはな 末摘花"
"すえなが 末永"
"すえの 末野"
"すえはず 末筈 末弭"
"すえひろ 末弘 末広"
"すえひろがり 末広がり"
"すえまさ 末政"
"すえまつ 末松"
"すえみつ 末光"
"すえむすめ 末娘"
"すえもの 陶物"
"すえやす 末安"
"すえよし 末善 末吉"
"すおう 素襖 素袍 蘇方 須王 蘇枋 蘇芳 周防"
"すおうなだ 周防灘"
"すかがわ 須賀川"
"すかさず 透かさず"
"すかし 透かし"
"すかしぼり 透かし彫り"
"すかゆ 酢ケ湯 酸ヶ湯"
"すからーせき スカラー積"
"すからーば スカラー場"
"すからざ スカラ座"
"すかんぴん 素寒貧"
"すかんぽ 酸模"
"すが 管 須ヶ 須賀 菅"
"すがい 酢貝 須貝 菅井"
"すがえ 菅江"
"すがお 菅尾 素顔"
"すがさわ 菅澤"
"すがすが 清々"
"すがすがしさ 清々しさ"
"すがた 菅田 姿"
"すがたえ 姿絵"
"すがたかたち 姿形"
"すがたずし 姿寿司"
"すがたに 姿煮"
"すがたみ 姿見"
"すがたやき 姿焼き 姿焼"
"すがたり 素語り"
"すがだいら 菅平"
"すがぬま 菅沼"
"すがの 菅野"
"すがはら 菅原"
"すがむら 管村"
"すがめ 眇"
"すがも 巣鴨"
"すがもと 菅本"
"すがや 菅谷"
"すがわ 須川"
"すがわら 管原 菅原"
"すがわらのみちざね 菅原道真"
"すき 犁 好き 須木 鍬 耒 犂 漉 数寄 鋤 隙"
"すきーいた スキー板"
"すきーきゃく スキー客"
"すきーぐつ スキー靴"
"すきーじょう スキー場"
"すきうつし 透き写し"
"すきぎ 透木"
"すきぐし 篦 梳櫛"
"すきごころ 好き心"
"すきずき 好きずき"
"すきっぱら 空きっ腹"
"すきなべ 鋤鍋"
"すきばら 空腹"
"すきま 透き間 すき間 隙間"
"すきみ 剥き身 透見 透き見"
"すきや 数奇屋"
"すきやき すき焼き 鋤焼"
"すきやづくり 数寄屋造 数寄屋造り"
"すきやばし 数寄屋橋"
"すきやぼうず 数寄屋坊主"
"すぎ 過ぎ 椙 杉"
"すぎうち 杉内"
"すぎうら 杉浦"
"すぎえ 杉江"
"すぎおか 杉岡"
"すぎかふん スギ花粉 杉花粉"
"すぎかわ 杉皮"
"すぎがき 杉垣"
"すぎき 杉木"
"すぎさき 杉崎"
"すぎさわ 杉沢"
"すぎざい 杉材"
"すぎざき 杉崎"
"すぎした 杉下"
"すぎた 杉田"
"すぎたこ 杉タコ"
"すぎたに 杉谷"
"すぎつま 杉妻"
"すぎと 杉戸"
"すぎとう 杉藤"
"すぎど 杉戸"
"すぎなみ 杉並"
"すぎなみき 杉並木"
"すぎぬま 杉沼"
"すぎの 杉野"
"すぎのした 杉之下"
"すぎのはら 杉ノ原"
"すぎのり 杉海苔"
"すぎはら 杉原"
"すぎばし 杉箸"
"すぎばやし 杉林"
"すぎまち 杉町"
"すぎむら 杉村"
"すぎもと 杉本"
"すぎやま 椙山 杉山"
"すぎりょうたろう 杉良太郎"
"すぎわら 杉原"
"すく 秀句 少"
"すくい 救い"
"すくいあみ 掬い網"
"すくいなげ 掬い投げ"
"すくいのて 救いの手"
"すくごう 宿業"
"すくせ 宿世"
"すくな 少な"
"すくない 少ない"
"すくなからず 少なからず"
"すくなくとも 少なくとも"
"すくなめ 少なめ"
"すくね 宿禰"
"すくも 糘 粭 宿毛"
"すくよう 宿曜"
"すくらんぶるこうさてん スクランブル交差点"
"すぐ 直ぐ"
"すぐき 酸茎"
"すぐきな 酸茎菜"
"すぐさま 直ぐ樣"
"すぐは 直刃"
"すぐり 酸塊 村主"
"すぐる 俊 英 勝 卓"
"すぐれもの 優れ物"
"すけ 典侍 次官 丞 甫 輔 亮 佑 祐 資 佐 介 助"
"すけーとぐつ スケート靴"
"すけーとじょう スケート場"
"すけかつ 資勝"
"すけがわ 助川"
"すけさこ 助迫"
"すけすけ 透け透け"
"すけそうだら 助惣鱈"
"すけだち 助太刀"
"すけっと 助人 助っ人"
"すけて 助手"
"すけとうだら 介党鱈"
"すけのぶ 助信"
"すけばん スケ番"
"すけべえ 助兵衛"
"すけべごころ スケベ心"
"すけむね 助宗"
"すけやす 祐安"
"すけよし 祐好"
"すけろく 助六"
"すけん 素見"
"すげ 素気 菅"
"すげかわ 菅河"
"すげがさ 菅笠"
"すげぬま 菅沼"
"すこし 少し"
"すこしも 少しも"
"すこっとらんど 蘇格蘭"
"すこぶる 頗 頗る"
"すこやか 健やか"
"すこらがく スコラ学"
"すこらてつがく スコラ哲学"
"すこんぶ 酢昆布"
"すご 凄"
"すごい 凄い"
"すごう 菅生"
"すごうで 凄腕"
"すごさ 凄さ"
"すごしかた 過ごし方"
"すごみ 凄味 凄み"
"すごもり 巣籠り 巣籠"
"すごろく 双六"
"すさ 須佐"
"すさか 須坂"
"すさき 洲崎 須崎"
"すさのおのみこと 素戔嗚尊 須佐之男命"
"すさびごと 遊び事"
"すさまじさ 凄まじさ"
"すさみ 須佐美"
"すざい 巣材"
"すざか 須坂"
"すざき 寿崎 洲崎"
"すざく 朱雀"
"すざくいん 朱雀院"
"すざわ 須沢"
"すし 鮓 鮨 寿司"
"すしだね 鮨種"
"すしめし 鮨飯 寿司飯"
"すしや 鮨屋"
"すしゅんてんのう 崇峻天皇"
"すじ 筋"
"すじあい 筋合 筋合い"
"すじかい 筋違い 筋交い"
"すじがき 筋書き 筋書"
"すじがね 筋金"
"すじきり 筋切り"
"すじぐも 筋雲"
"すじこ 筋子"
"すじだて 筋立"
"すじちがい 筋違い"
"すじにく 筋肉"
"すじぼね 筋骨"
"すじぼり 筋彫り"
"すじみち 筋道"
"すじむかい 筋向かい 筋向い"
"すじむこう 筋向う 筋向こう"
"すじめ 酢締め 筋目"
"すじゃく 朱雀"
"すじや 筋屋"
"すじょう 素場 素姓 巣状 素性"
"すじょうゆ 酢醤油"
"すじんてんのう 崇神天皇"
"すす 煤"
"すすいろ 煤色"
"すすき 芒 薄"
"すすきた 薄田"
"すすきの 薄野"
"すすけ 煤け"
"すすたけ 煤竹"
"すすはき 煤掃き"
"すすはらい 煤払い"
"すすみかた 進み方"
"すすみぐあい 進み具合"
"すすむ 晉 奨 晋 進"
"すすめ 勧め"
"すすめかた 進め方"
"すすりなき 啜り泣き"
"すず 鑾 珠洲 篶 篠 錫 鈴"
"すずい 鈴井"
"すずおき 鈴置"
"すずか 鈴香 鈴鹿"
"すずかけ 鈴懸"
"すずかぜ 涼風"
"すずき 鱸 鈴木"
"すずきかんたろう 鈴木貫太郎"
"すずきだいせつ 鈴木大拙"
"すずぐち 鈴口"
"すずこんしき 錫婚式"
"すずし 生絹"
"すずしま 鈴嶋"
"すずしろ 蘿蔔"
"すずたけ 篠竹"
"すずたに 鈴谷"
"すずたん 鈴丹"
"すずな 菘 鈴菜"
"すずなり 鈴生り 鈴なり"
"すずのすけ 鈴之助"
"すずはく 錫箔"
"すずひこ 鈴彦"
"すずみ 涼み"
"すずみぶね 涼み船"
"すずむし 鈴虫"
"すずむら 鈴村"
"すずめ 雀"
"すずめいろ 雀色"
"すずめが 雀蛾 天蛾"
"すずめがおか 雀ヶ丘"
"すずめばち 雀蜂"
"すずや 鈴谷"
"すずやま 鈴山"
"すずよ 鈴世"
"すずらん 鈴蘭"
"すずり 硯"
"すずりいし 硯石"
"すずりばこ 硯箱"
"すずりや 硯屋"
"すずろ 漫ろ"
"すそ 裾"
"すそあげ 裾上げ"
"すそとり 裾取り"
"すその 裾野"
"すそはらい 裾払い"
"すそもよう 裾模様"
"すそよけ 裾除け"
"すそわけ 裾分け"
"すたーがた スター型"
"すたーせんしゅ スター選手"
"すたじおろくおん スタジオ録音"
"すたまご 酢卵"
"すためんおち スタメン落ち"
"すたり 廃り"
"すたれ 廃れ"
"すたんどせき スタンド席"
"すたんふぉーどだいがく スタンフォード大学"
"すたんれーでんき スタンレー電気"
"すだ 巣田 須田"
"すだこ 酢蛸"
"すだち 酸橘 酢橘 巣立ち"
"すだつ 須達"
"すだま 魑魅 須玉"
"すだれ 簾"
"すちーるかん スチール缶"
"すちーるげん スチール弦"
"すっきりかん すっきり感 スッキリ感"
"すったもんだ 擦った揉んだ"
"すっとんきょう 素頓狂"
"すっぱ 素っ破 透波 素破"
"すっぱだか 素っ裸"
"すっぽぬけ すっぽ抜け"
"すっぽん 鼈"
"すづけ 酢漬 酢漬け"
"すてーじいしょう ステージ衣装"
"すてありんさん ステアリン酸"
"すていし 捨て石"
"すていぬ 捨て犬"
"すていん 捨印 捨て印"
"すてうり 捨て売り"
"すてがね 捨て金"
"すてき 素的 素敵"
"すてご 棄て子 棄て児 捨子 捨て子"
"すてごま 捨て駒"
"すてぜに 捨て銭"
"すてぜりふ 捨て台詞"
"すてどころ 捨て所"
"すてね 捨て値"
"すてねこ 捨て猫"
"すてはい 捨て牌 捨牌"
"すてば 捨て場"
"すてばち 捨て鉢"
"すてぱい 捨牌 捨て牌"
"すてみ 捨て身"
"すてやく 捨役"
"すてんれすこう ステンレス鋼"
"すてんれすせい ステンレス製"
"すで 已 既 素手"
"すでに 已に 既に"
"すとーりーせい ストーリー性"
"すとあてつがく ストア哲学"
"すとあは ストア派"
"すとう 周東 須藤"
"すとく 崇徳"
"すとくいん 崇徳院"
"すとけん スト権"
"すとっぷだか ストップ高"
"すとっぷやす ストップ安"
"すとやぶり スト破り"
"すとらいきけん ストライキ権"
"すとりーとけい ストリート系"
"すとれすかいしょう ストレス解消"
"すとれすはっさん ストレス発散"
"すどう 須藤"
"すどうふ 酢豆腐"
"すどおし 素通し"
"すどおり 素通り"
"すどまり 素泊り 素泊まり"
"すな 沙 砂"
"すなあそび 砂遊び"
"すなあらし 砂嵐"
"すないろ 砂色"
"すなえ 砂絵"
"すなお 淳 砂緒 素直"
"すなおとこ 砂男"
"すなかけばばあ 砂掛婆"
"すなかぶり 砂被り"
"すなかべ 砂壁"
"すなかわ 砂川"
"すなが 須永"
"すながわ 砂川"
"すなぎも 砂肝"
"すなくら 砂倉"
"すなけし 砂ケシ"
"すなけむり 砂煙"
"すなこ 砂子"
"すなご 沙子 砂子"
"すなざら 砂皿"
"すなじ 砂地"
"すなずり 砂摩り 砂摺り"
"すなだ 砂田"
"すなち 砂地"
"すなっくがし スナック菓子"
"すなっぷしゃしん スナップ写真"
"すなつぶ 砂粒"
"すなづるあか スナヅル亜科"
"すなどけい 砂時計"
"すなどりねこ 漁り猫"
"すなぬき 砂抜き"
"すなのおんな 砂の女"
"すなはち 則ち 即ち"
"すなはま 砂浜"
"すなはら 砂原"
"すなば 砂場"
"すなばこ 砂箱"
"すなぶくろ 砂嚢 砂袋"
"すなぶろ 砂風呂"
"すなぼこり 砂埃"
"すなみ 巣南 角南"
"すなむし 砂蟲"
"すなめり 砂滑 鯆"
"すなやま 砂山"
"すなゆ 砂湯"
"すなわち 曽ち 曾ち 乃ち 則ち 即ち"
"すなわら 砂原"
"すにん 数人"
"すね 臑 脛"
"すねあて 臑当て 脛当て"
"すねお スネ夫"
"すねかじり 臑かじり 臑齧り"
"すねげ スネ毛 すね毛"
"すねもの 拗ね者"
"すのこ 簀の子"
"すのはら 須野原 春原"
"すのまた 墨俣"
"すのもの 酢の物"
"すはだ 素肌"
"すはだか 素裸"
"すはま 洲浜 州浜"
"すはら 寿原 栖原 須原"
"すばこ 巣箱"
"すばなし 素話"
"すばなれ 巣離れ"
"すばやさ 素早さ"
"すばやし 素囃子"
"すばる 昴"
"すぱいえいせい スパイ衛星"
"すぱっと スパッと"
"すぱるたきょういく スパルタ教育"
"すぱるたしき スパルタ式"
"すびき 巣引"
"すびつ 炭櫃"
"すぴーどいはん スピード違反"
"すぴーどかん スピード感"
"すぴーどきょう スピード狂"
"すぶた 酢豚"
"すぶり 素振り"
"すぷらいんきょくせん スプライン曲線"
"すぷれーかん スプレー缶"
"すべ 術"
"すべからく 須く 須らく"
"すべがみ 皇神"
"すべすべ 滑滑 滑々"
"すべて 總 総 凡て 総て 全て"
"すべての ∀"
"すべらがみ 皇神"
"すべり 辷"
"すべりこみ 滑り込み"
"すべりだい すべり台 滑り台"
"すべりだし 滑り出し"
"すべりどめ 滑り止め"
"すぺいん 西班牙"
"すぺいんご スペイン語"
"すぺいんじん スペイン人"
"すぺいんりょうり スペイン料理"
"すぺくとるかいせき スペクトル解析"
"すぺくとるがた スペクトル型"
"すぺくとるせん スペクトル線"
"すぺくとるぶんせき スペクトル分析"
"すほん 素本"
"すぼし 素干し"
"すぼり 素掘り"
"すぽーついがく スポーツ医学"
"すぽーつがり スポーツ刈り"
"すぽーつし スポーツ誌 スポーツ紙"
"すぽーつしんぶん スポーツ新聞"
"すぽーつしんりがく スポーツ心理学"
"すぽーつせんしゅ スポーツ選手"
"すぽこん スポ根"
"すぽっとようせつ スポット溶接"
"すぽんじじょう スポンジ状"
"すま 須万 須磨"
"すまい 相撲 住い 住居 営 住まい"
"すまき 簀巻 簀巻き"
"すましじる すまし汁 澄まし汁"
"すまた 寸又 素股"
"すまたきょう 寸又峡"
"すまない 済まない"
"すみ 濟 澂 澄 寿 住 純 陬 須見 須美 済み 済 角 墨 炭 隅"
"すみいし 隅石"
"すみいろ 墨色"
"すみうち 墨打ち"
"すみえ スミ恵 純恵 寿美江 澄江 墨絵"
"すみお 純雄 澄雄 澄夫"
"すみか 鈴美香 住化 住み処 住み家 棲み家 住みか 住処"
"すみかえ 住替え"
"すみかわ 澄川"
"すみがま 炭窯"
"すみきん 住金"
"すみぎん 住銀"
"すみこ 寿美子 純子 澄子"
"すみこみ 住込み 住み込み"
"すみごこち 住み心地"
"すみさわ 隅沢"
"すみしょう 住商"
"すみじ 墨字"
"すみずみ 隅々"
"すみそ 酢味噌"
"すみそあえ 酢味噌和え"
"すみぞめ 墨染"
"すみた 角田 住田"
"すみだ 住田 隅田 墨田"
"すみだん 須弥壇"
"すみっこ 隅っこ"
"すみつき 墨付"
"すみつきかっこ 】 【 隅付き括弧"
"すみつぎ 墨継ぎ"
"すみつぼ 墨壺"
"すみてまえ 炭手前"
"すみでん 住電"
"すみと 澄人"
"すみとも 住友"
"すみともせめんと 住友セメント"
"すみながし 墨流し"
"すみなわ 墨縄"
"すみぬり 墨塗り"
"すみの 墨野 角野"
"すみのえ 住江 住之江"
"すみのくら 角倉"
"すみのどう 住道"
"すみひき 墨引き"
"すみひら 住平"
"すみび 炭火"
"すみびやき 炭火焼"
"すみぶくろ 墨袋"
"すみぶと 墨太"
"すみません 済みません"
"すみむね 隅棟"
"すみもと 住元 住本"
"すみや 墨屋 住谷 隅谷 角屋"
"すみやか 澄みやか 速やか"
"すみやき 炭焼 炭焼き"
"すみよ 純代"
"すみよう 住用"
"すみよし 澄義 住吉"
"すみよしづくり 住吉造"
"すみれ 菫"
"すみれいろ 菫色"
"すみれもく スミレ目"
"すみわけ 棲み分け"
"すめかみ 皇神"
"すめがみ 皇神"
"すめし 酢飯"
"すめらぎ 皇 天皇"
"すめん 素面"
"すもう 角力 相撲"
"すもうぢゃや 相撲茶屋"
"すもうとり 相撲とり 相撲取"
"すもぐり 素潜り"
"すもと 須本 栖本 洲本"
"すものがたり 素物語"
"すもも 酸桃 李"
"すもん 守門"
"すや 須屋"
"すやき 素焼 素焼き"
"すやま 隅山 須山 巣山 陶山"
"すよう 須要"
"すら ／"
"すらいどせい スライド制"
"すらっしゅ ／"
"すらむか スラム化"
"すらむがい スラム街"
"すり 修理 掏摸 刷 摺"
"すりあがり 刷り上がり"
"すりあし 摺り足"
"すりいろ 刷色"
"すりえ 擂り餌"
"すりかえ すり替え 掏り替え"
"すりがらす 磨りガラス"
"すりきず 擦り傷 擦傷"
"すりきり 擦切り 擦り切り"
"すりこぎ 摺子木 擂粉木 擂り粉木"
"すりこみ 刷込み 刷り込み"
"すりごま 擂り胡麻"
"すりっとこう スリット光"
"すりっとぞう スリット像"
"すりつぶ すり潰"
"すりぬけ すり抜け"
"すりのかみ 修理大夫"
"すりはく 摺箔"
"すりばち すり鉢 摺鉢 擂り鉢 擂鉢"
"すりほん 刷本"
"すりみ 擂り身 摺身"
"すりむか スリム化"
"すりもの 刷物 刷り物"
"する 駿"
"するが 駿河"
"するどさ 鋭さ"
"するめ 鯣"
"するめいか するめイカ 鯣烏賊"
"すれ 擦れ"
"すれすれ 摩々 擦々"
"すれちがい すれ違い"
"すろうにん 素浪人"
"すわ 須羽 諏訪"
"すわこ 諏訪湖"
"すわっぷとりひき スワップ取引"
"すわとう 汕頭"
"すわひりご スワヒリ語"
"すわみなみ 諏訪南"
"すわやり 楚割 魚条"
"すわり 座り"
"すん 寸"
"すんいん 寸陰"
"すんか 寸暇"
"すんけい 寸勁"
"すんげき 寸隙 寸劇"
"すんげん 寸言"
"すんこく 寸刻"
"すんごう 寸毫"
"すんし 寸志"
"すんしゃく 寸尺 寸借"
"すんしゅう 駿州"
"すんしょ 寸書"
"すんしんしゃくたい 寸進尺退"
"すんじ 寸時"
"すんずん 寸寸"
"すんぜん 寸前"
"すんぜんしゃくま 寸善尺魔"
"すんたらず 寸足らず"
"すんだい 駿台"
"すんだん 寸断"
"すんち 寸地"
"すんづまり 寸詰り 寸詰まり"
"すんてつ 寸鉄"
"すんで 既"
"すんとう 駿東"
"すんど 寸土"
"すんどめ 寸止め"
"すんにーは スンニー派"
"すんには スンニ派"
"すんばとうじん 寸馬豆人"
"すんひょう 寸評"
"すんびょう 寸秒 寸描"
"すんぴょう 寸評"
"すんぶん 寸分"
"すんぷ 駿府"
"すんぽう 寸法"
"すんれつ 寸裂"
"すんわ 寸話"
"ず 讎 讐 寿 鶴 津 事 豆 逗 廚 厨 圖 酢 頭 図"
"ずあん 図案"
"ずい 蕋 蘂 蕊 惴 瑞 髓 膸 隧 隨 随 隋 髄"
"ずいい 随意"
"ずいいち 随一"
"ずいいてきしょうひ 随意的消費"
"ずいいん 随員"
"ずいうん 瑞運 瑞雲"
"ずいえき 髄液"
"ずいえん 隋圜 随縁"
"ずいおう 瑞応"
"ずいかく 瑞鶴"
"ずいかん 随感"
"ずいき 芋茎 随喜"
"ずいきまつり 芋茎祭 瑞饋祭"
"ずいこう 瑞光 随行"
"ずいしつ 髄質"
"ずいしょ 隨處 隋書 随所"
"ずいしょう 瑞祥"
"ずいじ 随時"
"ずいじゅう 随従"
"ずいじゅん 随順"
"ずいじょう 髄状"
"ずいじん 随身"
"ずいせい 瑞星"
"ずいせつ 瑞雪"
"ずいせんじ 瑞泉寺"
"ずいそう 瑞相 随想"
"ずいだい 隋代"
"ずいだん 随談"
"ずいちょう 瑞鳥 瑞兆"
"ずいどう 隧道"
"ずいのう 髄脳"
"ずいはん 随伴"
"ずいひつ 隨筆 随筆"
"ずいぶん 隨分 随分"
"ずいぶんむかし 随分昔"
"ずいほうしょう 瑞宝章"
"ずいほうでん 瑞鳳殿"
"ずいまく 髄膜"
"ずいむ 瑞夢"
"ずいむし 螟虫"
"ずいり 図入り"
"ずうたい 図体"
"ずえ 図会 図絵"
"ずか 図化"
"ずかい 図解"
"ずかん 図鑑"
"ずかんそくねつ 頭寒足熱"
"ずが 図画"
"ずがい 頭蓋"
"ずがく 図学"
"ずがら 図柄"
"ずきょう 誦経"
"ずきん 頭巾"
"ずく 尽 尽く 木菟"
"ずけ 附 付"
"ずけい ◆ 徒刑 図形"
"ずけらん 瑞慶覧"
"ずけん 図研"
"ずこう 図功 頭香 頭光 図工"
"ずさくせい 図作成"
"ずさん 杜撰"
"ずざい 徒罪"
"ずざん 杜撰"
"ずし 呪師 図師 鮨 寿司 厨子 逗子 図示"
"ずしき 図式"
"ずしゅう 豆州"
"ずしょ 調所 図書"
"ずしょうりゃく 図省略"
"ずしょのかみ 図書頭"
"ずしょりょう 図書寮"
"ずしん 図心"
"ずじ 図示"
"ずじゅう 頭重"
"ずじょう 図上 頭上"
"ずせつ 図説"
"ずぞう 図像"
"ずたずた 寸寸 寸々"
"ずだ 頭陀"
"ずだけ 図竹"
"ずだぶくろ 頭陀袋"
"ずだやくしゅ 喘息薬種"
"ずちゅう 図中"
"ずつう 頭痛"
"ずつき 頭突き"
"ずてき 図的"
"ずどり 図取り"
"ずのう 図嚢 頭脳"
"ずはん 図版"
"ずばん 図番 図版"
"ずひょう 図表"
"ずふ 図譜"
"ずぶぬれ ズブ濡れ ずぶ濡れ"
"ずぶねり 頭捻り"
"ずへい 図柄"
"ずべこう ずべ公 ズベ公"
"ずほう 修法 図法"
"ずぼし 図星"
"ずぼんした ズボン下"
"ずぼんつり ズボン吊り"
"ずみ 濟 済み 桷 済"
"ずめ 詰"
"ずめん 図面"
"ずもう 相撲"
"ずよう 図様"
"ずり 刷"
"ずりょう 受領"
"ずろく 図録"
"ずわいがに ずわい蟹 ズワイ蟹"
"ずわり 座り"
"ずん 寸"
"ずんどう 寸胴"
"ずんどうなべ 寸胴鍋"
"せ 丗 畆 衰 勢 脊 畝 施 瀬 背 世"
"せーぬ 折奴 塞納"
"せーらーふく セーラー服"
"せあぶら 背油 背脂"
"せい 聲 丗 貰 歳 省 鉦 犀 掣 撕 嘶 萋 悽 淒 凄 棲 栖 穽 井 齊 齏 韲 躋 擠 臍 齎 腥 惺 醒 誓 逝 晟 筬 誠 甥 旌 牲 蜻 菁 睛 情 瀞 錆 鯖 靖 清 請 靜 静 晴 青 婿 整 征 政 勢 西 斉 盛 成 背 声 星 所為 世 製 制 聖 正 精 姓 性 生"
"せいあ 井蛙"
"せいあい 聖愛 性愛"
"せいあく 性悪"
"せいあつ 静圧 制圧"
"せいあん 西安 成案"
"せいい 凄異 征夷 勢威 誠意"
"せいいき 整域 声域 西域 聖域"
"せいいく 成育 生育"
"せいいち 誠市 誓一 正一 聖一 精一 清一 誠一"
"せいいちろう 晴一郎"
"せいいっぱい 精いっぱい 精一杯"
"せいいつ 斉一"
"せいいん 正員 成員 成因"
"せいう 晴雨"
"せいうち 海象"
"せいうん 盛運 青雲 星雲"
"せいうんのこころざし 青雲の志"
"せいえい 盛栄 清栄 精鋭"
"せいえき 精液"
"せいえつ 凄咽 誠悦"
"せいえん 凄艶 正円 西遠 製塩 声援"
"せいおう 聖王 西欧"
"せいおん 正音 整音 生温 声音 静音 清音 静穏"
"せいか 正貨 惺窩 斉家 成香 青華 声価 西夏 正佳 世家 聖化 正価 製靴 精化 正課 生化 青花 清華 聖火 盛夏 聖歌 生家 青果 生花 製菓 精華 成果"
"せいかい 精解 制海 青海 盛会 政界 正解"
"せいかく 政客 正格 製革 精確 正確 性格"
"せいかくづけ 性格付"
"せいかさんぎょう 西華産業"
"せいかたんでん 臍下丹田"
"せいかっこう 背恰好 背格好"
"せいかつ 正割 生活"
"せいかつかん 生活環"
"せいかつきゅう 生活給"
"せいかつなん 生活難"
"せいかなし 成果無"
"せいかりれー 聖火リレー"
"せいかん 盛観 西漢 清閑 精管 製管 製罐 製缶 制汗 星間 青函 静観 精悍 性感 生還"
"せいかんうん 星間雲"
"せいかんとんねる 青函トンネル"
"せいかんろん 征韓論"
"せいが 静臥 青蛾 聖画 星河 清雅 精華"
"せいがいは 青海波"
"せいがいふ 聖骸布"
"せいがく 声学 聖楽 聖学 静学 星学 声楽"
"せいがん 制ガン 制癌 青眼 正眼 晴眼 誓願 西岸 請願"
"せいき 盛基 誠紀 制機 聖記 星紀 清規 成規 青旗 旌旗 正気 成樹 精器 製機 西紀 盛期 生起 精機 精気 生気 性器 正規 世紀"
"せいきち 清吉"
"せいきまつ 聖飢魔II"
"せいきゅう 生休 制球 性急 請求"
"せいきょ 盛挙 逝去"
"せいきょう 生活協同組合 清興 政教 精強 聖教 正教 盛況 生協"
"せいきょうと 清教徒"
"せいきょく 声曲 正極 政局"
"せいきょくかい 制極界"
"せいきん 精勤 生菌"
"せいきんは 星菫派"
"せいぎ 声義 西魏 盛儀 精義 生技 性戯 性技 正義"
"せいぎかん 正義漢"
"せいぎゃく 正逆"
"せいぎょ 井魚 制禦 生魚 成魚 制御"
"せいぎょう 聖業 成業 盛業 正業 生業"
"せいぎょく 青玉"
"せいぎょしすてむ 制御システム"
"せいぎょたく 制御卓"
"せいぎょぼう 制御棒"
"せいく 成句 聖句"
"せいくう 制空"
"せいくらべ 背比べ"
"せいくん 請訓 正訓"
"せいぐ 性具"
"せいぐん 西軍"
"せいけ 清家"
"せいけい 正系 正経 星系 西経 成蹊 政経 生計 成型 成形 整形"
"せいけつ 清潔"
"せいけん 生研 制憲 精検 聖賢 政見 正拳 成犬 聖剣 生検 政権"
"せいけんだつしゅ 政権奪取"
"せいけんづき 正拳突き"
"せいげん 聖言 誓言 正弦 制限"
"せいげんさいぼう 精原細胞"
"せいこ 西湖 聖子"
"せいこう 星光 悽惶 成稿 清高 西行 正項 精鋼 政綱 生工 生硬 精鉱 西郊 盛行 正孔 性行 精工 性交 精巧 製鋼 性向 成功"
"せいこううき 晴好雨奇"
"せいこううどく 晴耕雨読"
"せいこうとうてい 西高東低"
"せいこうほう 正攻法"
"せいこく 精穀 正鵠"
"せいこつ 整骨"
"せいこん 精根 聖痕 精魂 成婚"
"せいご 勢語 清悟 精吾 清吾 正吾 成語 正誤 生後"
"せいごう 正合 正号 正剛 整合"
"せいごうせい 生合成"
"せいごん 誓言"
"せいさ 性差 精査"
"せいさい 生彩 正妻 精彩 制裁 精細"
"せいさいぼう 精細胞"
"せいさく 精索 清作 製作 制作 政策"
"せいさつ 精察 制札 省察"
"せいさつよだつ 生殺与奪"
"せいさん 悽惨 製産 成算 正餐 聖餐 制酸 青酸 凄惨 精算 清算 生産"
"せいさんかり 青酸カリ"
"せいさんらいん 生産ライン"
"せいざ 正坐 静坐 静座 正座 星座"
"せいざい 製材 製剤"
"せいざいかい 政財界"
"せいざいかん 政・財・官 政財官"
"せいざえもん 清左衛門"
"せいざぶろう 征三郎 清三郎"
"せいざん 青山"
"せいし 西詩 正矢 生歯 誓紙 聖旨 静思 西施 青紫 正使 誓詞 青史 聖史 誠史 姓氏 勢至 整枝 清史 製糸 正史 正視 制止 精子 製紙 生死 静止"
"せいしき 制式 整式 清拭 正式"
"せいしつ 正室 声質 性質"
"せいしゃ 精射 斉射 生者"
"せいしゅ 清酒"
"せいしゅう 勢州 青州 清秀"
"せいしゅく 静肅 整粛 静淑 星宿 静粛"
"せいしゅん 静瞬 青春"
"せいしょ 整書 盛暑 青書 正書 成書 誓書 清書 聖書"
"せいしょう 精詳 制勝 精漿 星章 政商 正賞 清勝 西湘 清祥 斉唱"
"せいしょうき 西廂記"
"せいしょうなごん 清少納言"
"せいしょうねん 青少年"
"せいしょく 星蝕 清色 生色 製織 声色 生食 青色 聖職 生殖"
"せいしょくし 生殖枝"
"せいしょくそう 生殖巣"
"せいしろう 誠志郎"
"せいしん 成心 誠信 生新 西晋 星辰 政審 西進 聖心 制振 清新 清心 誠心 精神"
"せいしんかん 正心館"
"せいしんしゃ 青心社"
"せいしんちゅうおう 西神中央"
"せいじ 斎次 聖次 星史 整司 静二 征士 青嗣 征司 成治 成二 征爾 聖二 征二 青児 征治 聖司 清次 精二 清司 清二 清治 誠治 誠二 誠司 政事 盛事 斉次 製磁 盛時 正字 正時 青磁 生時 政治"
"せいじしゅう 政治囚"
"せいじつ 凄日 誠実"
"せいじは 静磁波"
"せいじゃ 正邪 聖者"
"せいじゃく 静寂"
"せいじゅ 誠樹 聖寿"
"せいじゅう 西戎 成獣 聖獣"
"せいじゅうろう 清十郎"
"せいじゅく 成熟"
"せいじゅくらん 成熟卵"
"せいじゅん 正順 正準 清純"
"せいじょ 西序 正女 整除 成女 聖所 整序 聖女"
"せいじょう 聖上 星条 星状 成城 政情 性情 性状 清浄 正常"
"せいじょううえ 正条植え"
"せいじん 西人 星人 聖人 成人"
"せいじんのひ 成人の日"
"せいすい 精粋 静水 清水 整水 聖水 盛衰"
"せいすいき 製水器"
"せいすいせき 青水石"
"せいすう 正数 整数"
"せいすけ 清助 誠亮"
"せいず 星図 製図"
"せいずい 精髄"
"せいずばん 製図板"
"せいせい 悽悽 凄凄 正声 整斉 征西 西征 整正 済済 済々 生々 正々 清々 精製 生成"
"せいせいこうこう 悽悽惶惶"
"せいせいさんさん 凄凄惨惨"
"せいせいりょうりょう 凄凄涼涼"
"せいせいるてん 生生流転"
"せいせき 聖跡 聖石 聖蹟 成績"
"せいせっかい 生石灰"
"せいせつ 正節 正接"
"せいせん 聖戰 腥羶 精銭 成選 西遷 聖遷 征戦 政戦 精線 製銑 性腺 井泉 清泉 精選 聖戦 生鮮"
"せいぜい 精精 精々"
"せいぜつ 悽絶 凄絶"
"せいぜつさ 凄絶さ"
"せいぜん 悽然 井然 凄然 西漸 性善 正善 生前 整然"
"せいぜんそう 生前葬"
"せいそ 成素 凄楚 整礎 世祖 精粗 清楚"
"せいそう 斉奏 凄愴 悽愴 清爽 正相 盛装 成層 星霜 政争 精巣 正装 清掃"
"せいそうき 西廂記"
"せいそうねん 青荘年"
"せいそく 悽惻 栖息 棲息 正則 生息"
"せいそんぽ 生損保"
"せいぞう 誓三 清蔵 清三 西蔵 聖像 製造"
"せいぞく 聖俗 正続"
"せいぞろい 勢ぞろい 勢揃い"
"せいぞん 生存"
"せいた 清太 清田 背板"
"せいたい 正体 青黛 臍帯 正対 静態 聖体 政体 成体 声帯 整体 生体 生態"
"せいたいこう 西太后"
"せいたいまく 生体膜"
"せいたか 背高"
"せいたかのっぽ 背高のっぽ"
"せいたく 請託"
"せいたん 製炭 西端 生誕"
"せいたんきょく 聖譚曲"
"せいたんさい 聖誕祭"
"せいだい 聖代 正大 盛大"
"せいだく 清濁"
"せいだん 聖壇 清談 政談 星団"
"せいち 正置 整治 正値 静置 整地 精緻 聖地 生地"
"せいちあんこう 生知安行"
"せいちく 成竹"
"せいちゃ 製茶"
"せいちゃく 正嫡 正着"
"せいちゃくりつ 生着率"
"せいちゅう 精虫 誠忠 掣肘 正中 成虫"
"せいちょう 清張 清帳 聖寵 整調 正庁 清朝 性徴 声調 清聴 静聴 正調 政調 政庁 成鳥 整腸 清澄 生長 成長"
"せいつう 精通"
"せいてい 正丁 聖帝 静定 制定"
"せいていし 斉停止"
"せいていすう 整定数"
"せいてき 清適 正嫡 政敵 静的 性的"
"せいてつ 製鐵 製鉄"
"せいてん 征典 星点 盛典 性典 青天 正典 聖典 晴天"
"せいてんたいせい 斉天大聖"
"せいてんのへきれき 青天の霹靂"
"せいでん 星電 井田 聖殿 聖伝 正殿 正伝 静電"
"せいと 星斗 征途 聖都 聖徒 成都 生徒"
"せいとう 征東 盛唐 青鞜 征討 製陶 精糖 製糖 正答 正統 正当 政党"
"せいとうやじん 斉東野人"
"せいとく 盛徳 政徳 成徳 聖徳 生得"
"せいとん 整頓"
"せいど 西土 精度 制度"
"せいどう 精銅 声道 聖道 生動 正堂 政道 青銅 制動 正道 聖堂"
"せいどうにゅう 制導入"
"せいどく 西独 精読"
"せいどしゃ 青土社"
"せいどみにこ 聖ドミニコ"
"せいどん 晴曇"
"せいなる 聖なる"
"せいなん 勢南 西南"
"せいなんせい 西南西"
"せいにく 精肉"
"せいにゅう 生乳"
"せいねい 西寧"
"せいねいてんのう 清寧天皇"
"せいねん 盛年 生年 成年 青年"
"せいの 清野"
"せいのう 西濃 性能"
"せいのすけ 誠之助"
"せいは 制覇"
"せいはい 儕輩 成敗 聖杯"
"せいはく 生魄 製箔 清白 精薄 精白"
"せいはくしょく 青白色"
"せいはくじ 青白磁"
"せいはくまい 精白米"
"せいはつ 整髪"
"せいはん 正反 正犯 整版 製版"
"せいばい 成敗"
"せいばく 精麦"
"せいばつ 征伐"
"せいばん 製番"
"せいぱん 製パン"
"せいひ 請罷 政費 青皮 正比 正妃 西肥 西彼 性比 正否 成否"
"せいひこ 聖彦"
"せいひつ 省筆 聖櫃 静謐"
"せいひょう 旌表 青票 製表 星表 製氷"
"せいひょうい 生標委"
"せいひん 正賓 精品 清貧 製品"
"せいび 精微 精美 星美 整備"
"せいびづくえ 整備机"
"せいびどうしゅっぱん 成美堂出版"
"せいびょう 聖廟 性病"
"せいふ 正負 政府"
"せいふう 西風 清風"
"せいふぇろもん 性フェロモン"
"せいふく 正服 清福 正副 整復 征服 制服"
"せいふくすがた 制服姿"
"せいふのしっぱい 政府の失敗"
"せいふほしょうさい 政府保証債"
"せいふまい 政府米"
"せいふん 製粉"
"せいぶ 声部 西武 西部"
"せいぶつ 静物 生物"
"せいぶん 精分 成文 正文 成分"
"せいぶんかい 生分解"
"せいぶんどうしんこうしゃ 誠文堂新光社"
"せいへい 政柄 生兵 正兵 静平 精兵 清平 生平"
"せいへき 青碧 性癖"
"せいへん 正編 政変"
"せいべえ 清兵衛"
"せいべつ 生別 聖別 性別"
"せいほ 生保"
"せいほう 青峰 正方 正法 西方 製法"
"せいほく 西北"
"せいほくせい 西北西"
"せいほるもん 性ホルモン"
"せいほん 正本 製本"
"せいほんき 製本噐"
"せいぼ 清保 声母 生母 聖母 歳暮"
"せいぼう 声望 制帽"
"せいぼさいぼう 精母細胞"
"せいぼつ 生歿 生没"
"せいま 製麻"
"せいまい 精米"
"せいまく 成膜"
"せいみつ 精密"
"せいみや 清宮"
"せいみょう 精妙"
"せいみん 済民"
"せいむ 星霧 性夢 世務 政務"
"せいむてんのう 成務天皇"
"せいむにっか 聖務日課"
"せいめい 声名 盛名 性命 晴明 清明 姓名 声明 生命"
"せいめいけん 生命工学工業技術研究所"
"せいめん 製麺"
"せいもう 性毛 製網"
"せいもく 井目"
"せいもん 声門 誓文 声紋 正門"
"せいや 青夜 星谷 靖也 生也 聖矢 星矢 誠也 征野 晴夜 清夜 星夜 聖夜"
"せいやく 生薬 誓約 成約 製薬 制約"
"せいやこう 星野光"
"せいゆ 聖油 製油 精油"
"せいゆう 清遊 西遊 西友 声優"
"せいゆうかい 政友会"
"せいゆうすとあー 西友ストアー"
"せいよう 正用 整容 静養 西洋"
"せいようけん 精養軒"
"せいようなし 西洋梨"
"せいよく 制欲 性欲"
"せいら 聖良"
"せいらい 性来 生来"
"せいらん 清覧 青蘭 青藍 晴嵐 青嵐"
"せいり 生理 整理"
"せいりだな 整理棚"
"せいりつ 声律 正立 成立"
"せいりぽすと 整理ポスト"
"せいりゃく 政略"
"せいりゅう 精留 成龍 青竜 青龍 整流 清流"
"せいりゅうとう 青竜刀"
"せいりゅうばん 整流板"
"せいりょ 征旅"
"せいりょう 青龍 凄寥 凄涼 精良 清陵 青陵 星稜 星陵 声量 清涼"
"せいりょく 精力 勢力"
"せいりょくしょく 青緑色"
"せいりん 青林"
"せいるい 声涙 生類"
"せいれい 悽戻 正例 清麗 制令 生霊 精励 聖隷 蜻蛉 聖霊 精霊 政令"
"せいれき 西暦"
"せいれつ 星列 清冽 整列"
"せいれん 製練 清廉 精練 製錬 精錬"
"せいれんじこ 青蓮寺湖"
"せいろ 蒸篭 征露 蒸籠"
"せいろう 精蝋 青楼 清朗 聖篭 蒸籠 蒸篭 晴朗"
"せいろがん 征露丸 正露丸"
"せいろく 西麓"
"せいろん 政論 正論"
"せいわ 勢和 西和 清和"
"せう 詔 肖 紹 笑 照 焦 焼 消 招 抄 召"
"せうお 瀬魚"
"せお 妹尾 瀬尾"
"せおい 背負"
"せおいなげ 背負い投げ"
"せおと 瀬音"
"せおよぎ 背泳ぎ"
"せかい 世界"
"せかいいち 世界一"
"せかいしん 世界新"
"せかいじゅ 世界樹"
"せかいちゃんぴおん 世界チャンピオン"
"せかっこう 背恰好 背格好"
"せがき 施餓鬼"
"せがしら 瀬頭"
"せがみ 瀬上"
"せがれ 悴 伜 倅"
"せがわ 瀬河 背革 瀬川"
"せき 晢 威 × 關 潟 螫 蓆 跖 蹠 碩 戚 寂 錫 裼 迹 跡 藉 惜 昔 鶺 蹐 瘠 脊 磧 勣 蹟 績 蜥 皙 淅 晰 析 斥 汐 夕 瀬木 赤 石 隻 堰 関 籍 責 積 咳 席"
"せきあい 惜愛"
"せきあく 積悪"
"せきい 赤衣 赤緯"
"せきいん 石印"
"せきうち 関内"
"せきうら 関浦"
"せきうん 積雲"
"せきえい 隻影 石英"
"せきえん 積怨"
"せきお 世紀夫"
"せきおう 石黄"
"せきか 石果 赤化 石化"
"せきかえ 席替え"
"せきかく 刺客"
"せきかっしょく 赤褐色"
"せきかわ 関川"
"せきかん 石棺"
"せきがい 赤外"
"せきがいこう 赤外光"
"せきがえ 席替え"
"せきがきゅう 赤芽球"
"せきがく 碩学"
"せきがね 関金"
"せきがはら 関ケ原 関ヶ原"
"せきがわ 関川"
"せきがん 隻眼 赤岩"
"せきく 隻句"
"せきくうかん 積空間"
"せきぐち 関口"
"せきぐん 赤軍"
"せきこ 潟湖"
"せきこう 積項 赤光"
"せきこく 石斛"
"せきご 隻語"
"せきさい 積載"
"せきさいぼう 石細胞"
"せきさく 脊索"
"せきさん 積算"
"せきざい 石材"
"せきざわ 関沢"
"せきし 赤子 積志"
"せきしつ 赤漆 石質 石室"
"せきしま 関島"
"せきしゅ 隻手"
"せきしゅう 石州"
"せきしゅうごう ∩ 積集合"
"せきしゅつ 析出"
"せきしゅん 惜春"
"せきしょ 尺書 関所"
"せきしょう 石勝"
"せきしょうし 赤松子"
"せきしょく 赤色"
"せきしょくこう 赤色光"
"せきしょくてろ 赤色テロ"
"せきしょくとう 赤色燈"
"せきしょやぶり 関所破り"
"せきしん 赤心"
"せきじ 昔時 席次"
"せきじつ 昔日"
"せきじま 関島"
"せきじゅう 石絨 石獣"
"せきじゅうじ 赤十字"
"せきじゅん 石筍 席順"
"せきじょ 石女"
"せきじょう 惜譲 関上 関城 席上"
"せきじょうし 赤縄子"
"せきすい 積水"
"せきすいはうす 積水ハウス"
"せきすう 隻数 席数"
"せきずい 脊髄"
"せきずいろう 脊髄癆"
"せきせい 石製"
"せきせつ 赤雪 積雪"
"せきせん 関銭"
"せきぜん 寂然 積善 関前"
"せきぜんかい 責善会"
"せきそう 積層"
"せきそうひん 積送品"
"せきぞう 石造 石像"
"せきぞく 石鏃"
"せきた 関田"
"せきたに 関谷"
"せきたん 石炭"
"せきたんがす 石炭ガス"
"せきたんがら 石炭殻"
"せきだ 雪駄 席駄"
"せきだい 席代 席題"
"せきちく 石竹"
"せきちゅう 石柱 脊柱"
"せきちん 赤沈"
"せきつい 脊椎"
"せきついがわわんしょう 脊椎側湾症"
"せきづか 関塚"
"せきてい 席亭 石庭"
"せきてっこう 赤鉄鉱"
"せきとう 石塔"
"せきとり 関取"
"せきど 関戸"
"せきどう 赤道"
"せきどうはんりゅう 赤道反流"
"せきどめ 咳止め"
"せきにん 責任"
"せきにんのがれ 責任逃れ"
"せきね 関根"
"せきねつ 赤熱"
"せきねん 昔年 積年"
"せきの 関野"
"せきのみや 関宮"
"せきのやま 関の山"
"せきはい 惜敗"
"せきはん 赤飯"
"せきばく 寂莫 寂寞"
"せきばらい 咳払い"
"せきばん 石盤 石板 石版"
"せきひ 石碑"
"せきひつ 石櫃 石筆"
"せきひん 赤貧"
"せきふ 石斧"
"せきふだ 関札 席札"
"せきぶつ 石仏"
"せきぶん ∬ ∫ 石文 積分"
"せきぶんかん 積文館"
"せきへい 積弊"
"せきへき 赤壁"
"せきへきのたたかい 赤壁の戦い"
"せきへきのふ 赤壁賦"
"せきべ 関部"
"せきべつ 惜別"
"せきほうたい 赤報隊"
"せきほうへんい 赤方偏移"
"せきほく 石北"
"せきほん 石本"
"せきぼく 石墨"
"せきまえ 関前"
"せきまち 関町"
"せきみず 関水"
"せきむ 夕霧 責務"
"せきめ 関目"
"せきめん 石綿 赤面"
"せきめんし 石綿糸"
"せきめんはい 石綿肺"
"せきもと 関本"
"せきもり 関守"
"せきもん 責問"
"せきや 関屋 関谷"
"せきやど 関宿"
"せきやま 関山"
"せきゆ 石油"
"せきゆがす 石油ガス"
"せきゆしょっく 石油ショック"
"せきゆすとーぶ 石油ストーブ"
"せきゆゆしゅつこくきこう 石油輸出国機構"
"せきら 赤裸"
"せきらら 赤裸裸 赤裸々"
"せきらんうん 積乱雲"
"せきり 石理 赤痢"
"せきりつ 積率"
"せきりゅう 石榴"
"せきりょう 責了 脊梁 寂寥 席料"
"せきりょく 赤緑 斥力"
"せきりん 赤燐"
"せきるい 石塁"
"せきれい 鶺鴒"
"せきれき 石礫"
"せきろう 石蝋"
"せきわ 積和"
"せきわけ 関脇"
"せきわん 隻腕"
"せぎょう 施業 施行"
"せぎん 世銀"
"せくしょん §"
"せくたすう セクタ数"
"せくとしゅぎ セクト主義"
"せぐち 瀬口"
"せぐめんとか セグメント化"
"せぐめんとじょうほう セグメント情報"
"せけん 世間"
"せけんぎ 世間気"
"せけんずれ 世間擦れ"
"せけんち 世間智"
"せこ 瀬虎 世古 瀬古 世故"
"せこう 施行 施工"
"せさい 世才"
"せし セ氏"
"せしゅ 施主"
"せしゅう 世襲"
"せじ 世辞 世事"
"せじざい 世自在"
"せじざいおうぶつ 世自在王仏"
"せじゅつ 施術"
"せじょう 世上 世情 施錠"
"せじり 瀬尻"
"せじん 世塵 世人"
"せすじ 背筋"
"せすなき セスナ機"
"せせつ 世説"
"せせらわらい せせら笑い"
"せぜ 世々"
"せそう 世相"
"せそん 世尊"
"せぞく 世俗"
"せた 勢多 瀬田"
"せたい 世態 世帯"
"せたか 瀬高"
"せたがや 世田谷"
"せたけ 背丈"
"せたな 瀬棚"
"せだ 瀬田"
"せだい 世代"
"せち 褻 窃 折 世智 世知 節"
"せちえ 節会"
"せちだ 雪駄"
"せちばる 世知原"
"せちみ 節忌"
"せちょう 背丁"
"せぢか 瀬近"
"せっ 接"
"せっか 赤禍 接架 石貨 石火 赤化 雪花 石化"
"せっかい 雪塊 石塊 節介 切開 石灰"
"せっかいがん 石灰岩"
"せっかく 切角 石核 石槨 刺客 折角"
"せっかはんりゅう 折花攀柳"
"せっかん 切換 摂関 折檻 石棺"
"せっき 赤旗 節季 節気 石器"
"せっきゃく 隻脚 接客"
"せっきょう 説経 説教"
"せっきょうぶし 説経節"
"せっきょく 積極"
"せっきん 接近"
"せっきんせん 接近戰"
"せっく 隻句 節供 節句"
"せっくつ 石窟"
"せっけ 摂家"
"せっけい 雪溪 切形 雪景 雪渓 設計"
"せっけいみす 設計ミス"
"せっけいもじ 楔形文字"
"せっけっきゅう 赤血球"
"せっけん 節倹 席捲 接見 席巻 石鹸"
"せっけんばこ 石鹸箱"
"せっけんまく 石鹸膜"
"せっこう 石工 浙江 拙攻 斥候 拙稿 石膏"
"せっこく 石斛"
"せっこつ 接骨"
"せっこついん 接骨院"
"せっさ 切磋"
"せっさく 拙策 拙作 切削"
"せっさたくま 切瑳琢磨"
"せっし ℃ 窃視 切歯 摂氏"
"せっしかた 接し方"
"せっしゃ 拙者 接写"
"せっしゅ 截取 拙守 節酒 窃取 接種 摂取"
"せっしゅう 摂州 雪舟 接収"
"せっしょう 摂政 殺生 折衝"
"せっしょうかい 殺生戒"
"せっしょく 接觸 節食 摂食 接触"
"せっしん 接心 切診"
"せっすい 節水"
"せっせい 摂制 拙生 摂生 節制"
"せっせん 雪山 雪線 切線 折線 接線 接戦"
"せっそう 拙走 節奏 拙僧 切創 節操"
"せっそく 節足 拙速"
"せっそん 折損"
"せった 雪駄"
"せったい 摂待 接待"
"せったく 拙宅"
"せっち 接地 設置"
"せっちゃく 接着"
"せっちゅう 折中 雪中 折衷"
"せっちゅうじ 接中辞"
"せっちょ 拙著"
"せっちょうしゅう 節用集"
"せっちん 雪隠"
"せっつ 摂津"
"せっつう 切通"
"せってい 設定"
"せっていふぁいる 設定ファイル"
"せってん 節点 接点"
"せっとう 竊盜 接頭 窃盗"
"せっとく 説得"
"せっとはんばい セット販売"
"せっともの セット物"
"せっぱ 説破 切羽"
"せっぱく 雪白 切迫"
"せっぱん 折半"
"せっぴ 切皮 雪庇"
"せっぴつ 拙筆"
"せっぴょう 雪氷"
"せっぷ 雪膚 節婦"
"せっぷう 雪風"
"せっぷく 説服 説伏 折伏 切腹"
"せっぷん 接吻"
"せっぺん 雪片 切片"
"せっぽう 説法"
"せつ 晰 § 卩 屑 鱈 褻 薛 楔 啜 刹 殺 截 拙 攝 摂 洩 絏 緤 紲 渫 泄 椄 接 晢 浙 折 竊 窃 切 設 雪 節 説"
"せつあい 切愛"
"せつい 切意 褻衣"
"せついっさいうぶ 説一切有部"
"せつえい 拙詠 雪影 設営"
"せつえん 節煙"
"せつお 節雄 節男 節夫"
"せつかん 節間"
"せつがい 雪害"
"せつがん 切願 接眼 接岸"
"せつがんれんず 接眼レンズ"
"せつぎ 拙技 節義"
"せつくうかん 接空間"
"せつぐう 接遇"
"せつけいしき 節形式"
"せつけいもじ 楔形文字"
"せつげつか 雪月花"
"せつげん 切言 接舷 雪原 節減"
"せつこ 説乎 節子"
"せつこうぞう 節構造"
"せつごう 接合"
"せつざん 雪山"
"せつしゅうごう 節集合"
"せつじ 接辞 説示"
"せつじつ 切実"
"せつじゅ 接受"
"せつじゅつ 説述"
"せつじょ 切除"
"せつじょう 雪上"
"せつじょく 雪辱"
"せつせつ 切切 切々"
"せつぜい 節税"
"せつぜん 切前 截然"
"せつぞう 雪像"
"せつぞく 接続"
"せつぞくさーびす 接続サービス"
"せつたんい 節単位"
"せつだい 設題"
"せつだん 截断 切断"
"せつてん 節点"
"せつでん 節電"
"せつど 節度"
"せつどう 雪洞 摂動"
"せつな 刹那"
"せつない 切ない"
"せつなん 摂南"
"せつに 切に"
"せつび 折尾 接尾 設備"
"せつぶん 拙文 説文 節分"
"せつへいめん 接平面"
"せつぼう 切望"
"せつめい 説明"
"せつめん 接面 雪面"
"せつもん 説文 設問"
"せつや 摂也"
"せつやく 拙訳 節約"
"せつゆ 説諭"
"せつよう 切要 窃用 節用"
"せつようすい 雪溶水"
"せつよく 節欲"
"せつり 切離 節理 摂理"
"せつりつ 設立"
"せつりゅう 設立"
"せつれつ 拙劣"
"せつろん 切論 拙論"
"せつわ 説話"
"せと 瀬戸"
"せとう 瀬藤"
"せとうち 瀬戸内"
"せとがらつ 瀬戸唐津"
"せとぎわ 瀬戸際"
"せとぐろ 瀬戸黒"
"せとせ 瀬戸瀬"
"せとだ 瀬戸田"
"せど 背戸"
"せどう 世道"
"せどうか 旋頭歌"
"せどり 糶取り 競取り 瀬取り 背取り"
"せどりぶね 瀬取り船"
"せな 瀬女"
"せなか 背中"
"せなかあわせ 背中合せ"
"せにく 背肉"
"せにゅう 施入"
"せぬき 背抜き"
"せの 瀬野"
"せのう 瀬能"
"せのお 妹尾"
"せのきみ 背の君"
"せのび 背伸 背伸び"
"せはば 背幅"
"せばた 瀬端"
"せばんごう 背番号"
"せひ 施肥"
"せひょう 世評"
"せびょうし 背表紙"
"せびらき 背開き"
"せびれ 背鰭"
"せびろ 背広"
"せびろすがた 背広姿"
"せぴあいろ セピア色"
"せふ 渉 捷 妾"
"せふり 背振"
"せぶし 背節"
"せぶみ 瀬踏み"
"せぼね 背骨"
"せま 瀬間"
"せまきもん 狭き門"
"せまめ 狭め"
"せみ 蝉"
"せみおれ 蝉折れ"
"せみくじら 背美鯨"
"せみしぐれ 蝉時雨"
"せみなーしつ セミナー室"
"せみね 瀬峰"
"せみまる 蝉丸"
"せむ 世務"
"せむごぞく セム語族"
"せむし 傴僂"
"せむぞく セム族"
"せむら 瀬村"
"せめ 責め 責 攻め"
"せめあい 攻め合い"
"せめぎあい 鬩ぎ合い"
"せめく 責苦"
"せめぐ 責具"
"せめんとがわら セメント瓦"
"せめんとしつ セメント質"
"せもじ 背文字"
"せもたれ 背もたれ 背凭れ"
"せもつ 施物"
"せもん 背紋"
"せや 瀬谷"
"せやく 施薬"
"せやくいん 施薬院"
"せやま 瀬山"
"せゆう 施釉"
"せよ 施与"
"せら 世良 世羅"
"せらにし 世羅西"
"せり 世利 糶 競 芹 競り"
"せりあげ 競上げ"
"せりか 芹科 セリ科 芹香"
"せりかわ 芹川"
"せりざわ 芹澤 芹沢"
"せりざわかも 芹沢鴨"
"せりだし 迫り出し"
"せりふ 科白 台詞"
"せりもく セリ目"
"せりもち 迫持"
"せりょう 芹生 施療"
"せるが セル画"
"せろ 世路"
"せろん 世論"
"せわ 世話"
"せわた 背腸"
"せわびと 世話人"
"せわり 背割り 背割"
"せん 銛 喘 閃 薦 羨 穿 旋 染 釧 茜 舩 陝 鐫 燹 涎 暹 尠 吮 刋 舛 簽 僉 潺 孱 餞 錢 踐 践 賎 賤 綫 牋 箋 濺 淺 浅 籖 籤 殱 殲 孅 纎 纖 繊 槧 斬 荐 栫 顫 羶 氈 擅 譫 蟾 贍 瞻 亘 宣 磚 甎 槫 專 栴 旃 倩 闡 戰 嬋 蝉 煽 扇 翦 剪 揃 擶 箭 煎 沾 苫 占 韆 僊 遷 疝 仙 濳 潛 僣 僭 潜 銓 痊 詮 筌 筅 跣 銑 洗 癬 蘚 鮮 巛 川 仟 阡 湶 腺 泉 饌 撰 選 尖 先 船 専 銭 千 栓 戦 線"
"せんあえんこう 閃亜鉛鉱"
"せんい 瞻依 船医 線維 戦意 遷移 繊維"
"せんいき 戦域"
"せんいし 繊維糸"
"せんいつ 専一"
"せんいばん 繊維板"
"せんいん 船員"
"せんうん 戦雲"
"せんえい 千映 尖鋭 鮮鋭 先鋭"
"せんえき 戦役"
"せんえつ 僭越"
"せんえん 潺湲 遷延 千円"
"せんおう 擅横 僭王 先王 専横"
"せんおうしょく 鮮黄色"
"せんおく 千億"
"せんおん 顫音"
"せんおんそく 遷音速"
"せんか 戰火 戰果 線化 仙家 撰歌 選歌 泉下 銭貨 選科 選果 戦禍 戦果 戦火 専科"
"せんかい 仙界 先回 千回 浅海 旋回"
"せんかく 先覚 尖閣 線画"
"せんかこ 線過去"
"せんかし 泉貨紙"
"せんかじゅう 線荷重"
"せんかた 爲ん方 為ん方 詮方"
"せんかち 先勝"
"せんかわ 仙川 千川"
"せんかん 戰艦 潺湲 潜函 線間 専管 選管 戦艦"
"せんかんき 戦間期"
"せんかんぶりあじだい 先カンブリア時代"
"せんが 千賀 線画"
"せんがい 船外 選外"
"せんがいきょう 山海経"
"せんがき 線描き"
"せんがく 先学 浅学"
"せんがくじ 泉岳寺"
"せんがわ 仙川"
"せんがん 先願 腺癌 千貫 洗眼 洗顔"
"せんき 疝気 先期 戦旗 戦機 戦記"
"せんきち 詮吉"
"せんきゃく 船客 先客"
"せんきゃくばんらい 千客万来"
"せんきゅう 仙宮 選球"
"せんきょ 占居 船渠 占拠 選挙"
"せんきょう 泉郷 船橋 戦況 宣教"
"せんきょかー 選挙カー"
"せんきょく 選局 戦局 選曲"
"せんきん 千鈞 千金"
"せんぎ 僉議 先議 詮議"
"せんぎく 千菊"
"せんぎょ 鮮魚"
"せんぎょう 瞻仰 賤業 専業"
"せんく 選句 線区 先駆"
"せんくち 先口"
"せんくん 先君 戦訓"
"せんぐ 船具"
"せんぐう 遷宮"
"せんぐらふ 線グラフ"
"せんぐん 線群"
"せんぐんばんば 千軍万馬"
"せんけ 仙家 千家"
"せんけい 戦形 尖形 船型 扇形 線型 線形"
"せんけいわ 線形和"
"せんけつ 潜血 鮮血 専決 先決"
"せんけつごう 線結合"
"せんけん 選鉱製錬研究所 選研 擅権 仙建 嬋娟 先件 淺見 浅見 先験 専権 先見 先遣"
"せんけんさそうち 線検査装置"
"せんけんのめい 先見の明"
"せんげ 宣下 遷化"
"せんげつ 繊月 先月"
"せんげん ∨ 浅間 先言 選言 譫言 泉源 線源 宣言"
"せんげんだい 千間台"
"せんげんばんご 千言万語"
"せんこ 千古"
"せんこう 銑鋼 詮衡 踐行 浅紅 繊巧 先皇 旋光 銓衡 先考 専行 せん孔 鮮紅 潜降 選鉱 先公 潜航 染工 戦功 潜行 選好 穿孔 先攻 閃光 線香 選考 専攻 先行"
"せんこうげん 線光源"
"せんこうば 先行馬"
"せんこく 先刻 宣告"
"せんこつ 仙骨"
"せんご 譫語 戰後 選語 先後 戦後"
"せんごう 瞻仰"
"せんごく 戰國 仙石 千石 戦国"
"せんごくぶね 千石船"
"せんさ 千差"
"せんさい 浅才 先妻 戦災 繊細"
"せんさいちゃ 仙斎茶"
"せんさく 穿鑿 詮索"
"せんさま 先様"
"せんざい 煎剤 前栽 宣材 千載 千歳 洗剤 潜在"
"せんざき 先崎"
"せんざん 仙山"
"せんざんこう 穿山甲"
"せんざんばんすい 千山万水"
"せんし 戰死 擅恣 千士 千思 戦志 賤視 先師 先史 穿刺 戦史 戦死 戦士"
"せんしきめん 線織面"
"せんしたい 戰死體"
"せんしつ 線質 船室 泉質"
"せんしばんこう 千紫万紅"
"せんしばんたい 千姿万態"
"せんしゃ 戰車 占者 洗車 戦車"
"せんしゃく 浅酌"
"せんしゅ 繊手 専守 僭主 船種 線種 船主 腺腫 船首 先取 選手"
"せんしゅう 撰修 撰集 千秋 選集 泉州 専修 先週"
"せんしゅうばんぜい 千秋万歳"
"せんしゅうらく 千秋楽"
"せんしゅかい 千趣会"
"せんしゅけんじゃ 選手権者"
"せんしゅつ 選出"
"せんしゅつば 選出馬"
"せんしゅん 浅春"
"せんしょ 戦書 選書"
"せんしょう 戰捷 尠少 戦賞 僭上 賤称 先蹤 戦捷 僭称 選奨 戦傷 先勝 戦勝"
"せんしょく 染織 染色"
"せんしん 千進 潜心 撰進 線審 専心 先進"
"せんしんせい 鮮新世"
"せんしんばんく 千辛万苦"
"せんじ 戰時 戦事 煎じ 潜時 宣旨 戦時"
"せんじいない 千字以内"
"せんじぐすり 煎じ薬"
"せんじつ 先日"
"せんじのつかい 宣旨の使"
"せんじます 宣旨升"
"せんじもん 千字文"
"せんじゃ 千社 撰者 選者"
"せんじゃく 繊弱"
"せんじゃふだ 千社札"
"せんじゅ 専修 千種 仙寿 千手 千住"
"せんじゅう 煎汁 専従 先住"
"せんじゅうしょう 撰集抄"
"せんじゅつ 戰術 撰述 仙術 占術 先述 戦術"
"せんじょ 剪除"
"せんじょう 戰場 繊条 煽情 扇情 洗滌 線条 千丈 千畳 扇状 仙丈 線状 線上 船上 戦場 洗浄"
"せんじょうこん 線条痕"
"せんじょうじき 千畳敷"
"せんじょうだん 扇状弾"
"せんじょうばんたい 千状万態"
"せんじん 戦陣 戦塵 千尋 先陣 先人"
"せんす 扇子"
"せんすい 線錐 仙水 泉水 潜水"
"せんすいふ 潜水夫"
"せんず 線図"
"せんずるところ 詮ずる所"
"せんせい 陝西 潜勢 専政 占星 専制 宣誓 先制 先生"
"せんせき 仙籍 仙石 船籍 戦跡 戦績"
"せんせきぶん 線積分"
"せんせつ 洗雪"
"せんせん 戰々 宣戰 戰線 閃々 戦々 先々 先占 宣戦 戦線"
"せんせんきょうきょう 戦戦兢兢 戦戦恐恐"
"せんせんげつ 先々月"
"せんぜい 蝉蛻"
"せんぜん 戰前 戦前"
"せんそ 線素 践祚"
"せんそう 戰爭 先走 船艙 船窓 線装 船倉 戦争"
"せんそうじ 浅草寺"
"せんそく 跣足 線束 戦速 栓塞 船側 洗足"
"せんぞ 先祖"
"せんぞい 線沿 線沿い"
"せんぞう 仙三 線増 潜蔵 潜像"
"せんぞがえり 先祖返り"
"せんぞく 洗足 専属"
"せんぞくいけ 洗足池"
"せんたーがい センター街"
"せんたーしけん センター試験"
"せんたーない センター内"
"せんたい 浅堆 蘚苔 船隊 選対 船体 戦隊"
"せんたいしょう 線対称"
"せんたく 宣託 撰択 洗濯 選択"
"せんたくいた 洗濯板"
"せんたくかご 洗濯カゴ 洗濯籠"
"せんたくし 選択肢"
"せんたくねっと 洗濯ネット"
"せんたくばさみ 洗濯バサミ 洗濯挟み"
"せんたろう 煎太郎"
"せんたん 戦端 尖端 先端"
"せんたんかがくぎじゅつけんきゅうせんたー 先端科学技術研究センター"
"せんだ 煎田 仙田 千田"
"せんだい 千台 川内 先帝 船台 先代 仙台"
"せんだいいち 仙台一"
"せんだいざか 仙台坂"
"せんだいひら 仙台平"
"せんだいまつど 専大松戸"
"せんだがや 千駄谷 千駄ヶ谷"
"せんだぎ 千駄木"
"せんだち 先達"
"せんだって 先達て"
"せんだつ 蝉脱 先達"
"せんだん 擅断 専断 栴檀 剪断 船団"
"せんだんりょく せん断力"
"せんち 泉地 糎 戦地"
"せんちぐらむ 甅"
"せんちめーとる 糎"
"せんちゃ 煎茶"
"せんちゃく 先着"
"せんちゅう 線虫 船中 戦中"
"せんちょう 千兆 線長 船長"
"せんちょうがん 閃長岩"
"せんちりっとる 竰"
"せんつい 仙椎"
"せんつう 千通 疝痛"
"せんて 先手"
"せんてい 撰定 泉亭 船艇 先帝 船底 剪定 選定"
"せんていこう 選帝侯"
"せんていどき 尖底土器"
"せんていば 選定馬"
"せんてつ 鮮鉄 仙鉄 先哲 銑鉄"
"せんてん 尖点 旋転 千点 先天"
"せんでき 洗滌"
"せんでん 宣伝"
"せんと ¢ 仙都 遷都"
"せんとう 戰闘 銭刀 専当 船灯 船頭 剪刀 先登 宣統 千灯 尖頭 仙洞 千頭 尖塔 銭湯 戦闘 先頭"
"せんとうそう 仙洞草"
"せんとうてい 宣統帝"
"せんとらるがらす セントラル硝子"
"せんど 千度 先途 尖度 先度 鮮度"
"せんどう 顫動 千同 羨道 千堂 煽動 扇動 仙道 船頭 先導"
"せんどうか 旋頭歌"
"せんどうし 線同士"
"せんない 線内 船内"
"せんなん 仙南 泉南"
"せんにく 鮮肉"
"せんにち 千日"
"せんにゅう 仙入 穿入 先入 潜入"
"せんにゅうけん 先入見"
"せんにょ 仙女"
"せんにん 先任 千人 仙人 選任 専任"
"せんにんしょう 仙人掌"
"せんにんばり 千人針"
"せんにんりき 千人力"
"せんぬき 栓抜き"
"せんねつ 潜熱"
"せんねん 先年 千年 専念"
"せんのう 先皇 先王 洗脳"
"せんはた 千畑"
"せんはば 線幅"
"せんはら 千原"
"せんば 仙葉 千羽 仙波 船場"
"せんばい 専売"
"せんばいけん 先買権"
"せんばがん 選馬眼"
"せんばこき 千把扱き"
"せんばつ 選抜"
"せんばづる 千羽鶴"
"せんばやしかん 千林間"
"せんばん 先晩 先番 旋盤 千万"
"せんぱい 戦敗 先輩"
"せんぱく 銭帛 浅薄 船舶"
"せんぱつ 染髪 洗髪 先発"
"せんぱつし 先発枝"
"せんぱん 戰犯 戦犯 先般"
"せんひき 線引 線引き"
"せんひゃく 千百"
"せんび 戦備 船尾"
"せんびき 線引 線引き"
"せんびょう 線描"
"せんびょうし 戦病死"
"せんびょうしつ 腺病質"
"せんびん 先便 船便"
"せんぴ 先非 鮮卑 戦費"
"せんぴつ 染筆"
"せんぴょう 先表 線表 選評 戦評"
"せんぶ 旋舞 宣撫 先負"
"せんぶり 千振"
"せんぶん 撰文 千分 線分"
"せんぷ 先夫 先負 戦斧 宣布"
"せんぷう 旋風"
"せんぷうき 扇風機"
"せんぷく 先腹 船幅 船腹 線幅 潜伏"
"せんぷくが 潜伏芽"
"せんぷくりん 千輻輪"
"せんべい 煎餅"
"せんべつ 餞別 選別"
"せんべん 先鞭"
"せんべんばんか 千変万化"
"せんぺい 先兵 尖兵"
"せんぺんいちりつ 千編一律 千篇一律"
"せんぺんばんか 千変万化"
"せんほく 泉北"
"せんぼう 懺法 羨望"
"せんぼうきょう 潜望鏡"
"せんぼく 占卜 仙北 泉北"
"せんぼつ 潜没 戦歿 戦没"
"せんぼん 千本"
"せんぼんざくら 千本桜"
"せんぼんはま 千本浜"
"せんぽう 尖峰 占法 旋法 先鋒 戦法 先方"
"せんぽく 泉北"
"せんまい 洗米 千枚"
"せんまいづけ 千枚漬"
"せんまいどおし 千枚通し"
"せんまけ 先負"
"せんまや 千厩"
"せんまん 千万"
"せんみつ 繊密"
"せんみつど 線密度"
"せんみょう 宣命"
"せんみん 賎民 賤民 選民"
"せんむ 占夢 専務"
"せんめい 闡明 宣明 線名 船名 鮮明"
"せんめつ 剪滅 殱滅 殲滅"
"せんめん 線面 扇面 洗面"
"せんもう 剪毛 腺毛 譫妄 旋毛 線毛 繊毛"
"せんもうせん 釧網線"
"せんもうちゅう 旋毛虫"
"せんもうほんせん 釧網本線"
"せんもじ 線文字"
"せんもん 羨門 泉門 専門"
"せんや 先夜 戦野 千夜"
"せんやく 煎薬 仙薬 先約"
"せんゆう 先憂 戦友 専有 占有"
"せんよう 閃耀 宣揚 占用 専用"
"せんようそ 線要素"
"せんようば 専用馬"
"せんらん 戦乱"
"せんり 戦利 千里"
"せんりこう 千里膏"
"せんりつ 先立 戦慄 旋律"
"せんりはまかいがん 千里浜海岸"
"せんりはんきゅうほてる 千里阪急ホテル"
"せんりゃく 戦略"
"せんりゅう 千流 潜龍 川柳"
"せんりょ 千慮 浅慮"
"せんりょう 選良 千両 線量 染料 占領"
"せんりょうか センリョウ科"
"せんりょうばこ 千両箱"
"せんりょく 鮮緑 浅緑 戦力"
"せんりょくがん 閃緑岩"
"せんりん 線輪"
"せんりんかく 線輪郭"
"せんるい 蘚類"
"せんれい 繊麗 鮮麗 船齢 先例 洗礼"
"せんれき 戦歴"
"せんれつ 戦列 鮮烈"
"せんれん 洗煉 洗錬 洗練"
"せんれんけつ 線連結"
"せんろ 線路"
"せんろう 船楼"
"せんろぎわ 線路際"
"せんろしき 線路敷"
"せんわく 煽惑"
"ぜ 是"
"ぜーた Ζ ζ"
"ぜあみ 世阿弥"
"ぜい 噬 筮 脆 説 贅 勢 税"
"ぜいいん 税印"
"ぜいか 脆化"
"ぜいかん 税関"
"ぜいがく 税額"
"ぜいきん 税金"
"ぜいげん 贅言 税源"
"ぜいこみ 税込み 税込"
"ぜいご 贅語"
"ぜいしゅう 税収"
"ぜいしゅうにゅう 税収入"
"ぜいしょうめい 税証明"
"ぜいじゃく 脆弱"
"ぜいせい 脆性 税制"
"ぜいたく 贅沢"
"ぜいちく 筮竹"
"ぜいちょう 税調"
"ぜいにく ぜい肉 贅肉"
"ぜいぬき 税抜き 税抜"
"ぜいびき 税引き"
"ぜいびきまえとうきりえき 税引前当期利益"
"ぜいふたん 税負担"
"ぜいぶつ 贅物"
"ぜいべつ 税別"
"ぜいほう 税法"
"ぜいむ 税務"
"ぜいり 税吏 税理"
"ぜいりつ 税率"
"ぜいろく 贅六"
"ぜえた Ζ"
"ぜえろく 贅六"
"ぜがい 是界"
"ぜがひでも 是が非でも"
"ぜき 關 関"
"ぜげん 女衒"
"ぜせい 是正"
"ぜぜ 膳所"
"ぜぜひひ 是々非々 是是非非"
"ぜっか 絶家 舌禍 絶佳 舌下"
"ぜっかい 絶海"
"ぜっきょう 絶境 絶叫"
"ぜっきん 舌筋"
"ぜっく 絶句"
"ぜっけ 絶家"
"ぜっけい 絶景"
"ぜっこう 舌耕 舌口 絶交 絶好"
"ぜっこつ 舌骨"
"ぜっこん 舌根"
"ぜっさん 絶讚 絶讃 絶賛"
"ぜっしょう 絶勝 絶唱"
"ぜっしょく 絶食"
"ぜっせい 絶世"
"ぜっせん 舌尖 舌戦 舌先"
"ぜっそく 絶息"
"ぜったい 絶体 舌苔 絶対"
"ぜったいあく 絶対悪"
"ぜったいぱす 絶対パス"
"ぜったいまけ 絶対負"
"ぜったん 舌端"
"ぜっちょう 絶頂"
"ぜっとう 絶島 舌頭 絶倒"
"ぜっとき Ｚ旗"
"ぜっとじく Ｚ軸"
"ぜっとへんかん Ｚ変換"
"ぜっぱい 舌背"
"ぜっぱん 絶版"
"ぜっぴつ 絶筆"
"ぜっぴん 絶品"
"ぜっふうん 絶不運"
"ぜっふちょう 絶不調"
"ぜっぺき 絶壁"
"ぜっぽう 舌鋒"
"ぜつ 説 舌 絶"
"ぜつあい 絶愛"
"ぜつあつし 舌圧子"
"ぜついき 絶域"
"ぜついん 舌咽"
"ぜつえん 絶遠 舌炎 絶縁"
"ぜつえんてーぷ 絶縁テープ"
"ぜつおん 舌音"
"ぜつがん 舌癌"
"ぜつぎ 舌技 絶技"
"ぜつげん 絶弦 絶絃"
"ぜつご 絶後"
"ぜつじょうか 舌状花"
"ぜつだい 絶待 舌代 絶大"
"ぜつび 絶美"
"ぜつぼう 絶望"
"ぜつみょう 絶妙"
"ぜつむ 絶無"
"ぜつめい 絶命"
"ぜつめつ 絶滅"
"ぜつめん 舌面"
"ぜつりん 絶倫"
"ぜに 錢 銭"
"ぜにあおい 銭葵"
"ぜにうしない 銭失い"
"ぜにかね 銭金"
"ぜにかんじょう 銭勘定"
"ぜにがた 銭形"
"ぜにがめ 銭亀"
"ぜにげば 銭ゲバ"
"ぜにごけ 銭苔"
"ぜにずく 銭尽く"
"ぜにたかぐみ 錢高組"
"ぜにだいこ 銭太鼓"
"ぜにばこ 銭箱 銭函"
"ぜにもうけ 銭儲け"
"ぜにん 是認"
"ぜねらるせきゆ ゼネラル石油"
"ぜひ 是非"
"ぜひとも 是非とも"
"ぜみ 蝉"
"ぜみしつ ゼミ室"
"ぜみしりょう ゼミ資料"
"ぜめ 攻め"
"ぜらちんしつ ゼラチン質"
"ぜりーじょう ゼリー状"
"ぜりふ 台詞"
"ぜろ 〇 零"
"ぜろいんし 零因子"
"ぜろかいとう ゼロ回答"
"ぜろきんり ゼロ金利"
"ぜろくうかん 零空間"
"ぜろげん 零元"
"ぜろさい ゼロ歳"
"ぜろじ ０次"
"ぜろせいちょう ゼロ成長"
"ぜろせん ゼロ戦 零戦"
"ぜろてん 零点 ゼロ点"
"ぜん 禪 蝉 譱 繕 嶄 漸 蠕 喘 髯 苒 冉 千 然 禅 膳 全 前 善"
"ぜんあく 善悪"
"ぜんあつ 全圧 前圧"
"ぜんい 禅位 前位 善意"
"ぜんいき 全域"
"ぜんいち 善一"
"ぜんいつ 全一"
"ぜんいん 善因 禅院 全員"
"ぜんえい 全英 前衛"
"ぜんえいおんがっか 前衛音楽家"
"ぜんえき 全駅"
"ぜんえん 千円 全円 全縁 前縁"
"ぜんおう 全欧"
"ぜんおん 全音"
"ぜんか 善果 漸化 全家 全科 全課 前科"
"ぜんかい 全潰 全解 全階 全回 全会 全壊 全快 全開 前回"
"ぜんかく 禅客 前核 全角"
"ぜんかん 善感 前官 全艦 前巻 前漢 全館 全巻"
"ぜんかんちゅういぎむ 善管注意義務"
"ぜんがく 禅学 前額 全学 全額"
"ぜんき 前季 全機 全期 前記 前期"
"ぜんきち 善吉"
"ぜんきゃく 前脚"
"ぜんきゅう 冉求 全休"
"ぜんきょうれん 全共連"
"ぜんきょく 全極 全局 全曲"
"ぜんきん 漸近 前金"
"ぜんぎ 前戯"
"ぜんぎょう 前行"
"ぜんぎん 全銀"
"ぜんぎんきょう 全銀協"
"ぜんく 全区 前駆"
"ぜんくつ 前屈"
"ぜんくろう 善九郎"
"ぜんぐん 前群 全郡 全軍"
"ぜんけ 禅家"
"ぜんけい 全系 全形 前景 前傾 前掲 全景"
"ぜんけつ 全血"
"ぜんけん 全検 前件 全権 全県"
"ぜんげつ 前月"
"ぜんげん 善言 漸減 前言"
"ぜんこ 前古 全戸"
"ぜんこう 善行 全高 全校 前項"
"ぜんこうじ 善光寺"
"ぜんこく 全国"
"ぜんこくいち 全国一"
"ぜんこっく 全国区"
"ぜんこん 前根 善根"
"ぜんご 禅語 善吾 漸悟 善後 前後"
"ぜんごう 善業 全豪 前号"
"ぜんごぎゃく 前後逆"
"ぜんごどう 前後動"
"ぜんさい 前妻 前菜"
"ぜんさく 前作"
"ぜんさつ 禅刹"
"ぜんさりん 前左輪"
"ぜんざ 前座"
"ぜんざい 善哉"
"ぜんざん 前残 全山"
"ぜんざんじ 前山寺"
"ぜんし 全姿 全姉 禅師 前翅 前肢 全紙 前史 全市"
"ぜんしーずん 前シーズン"
"ぜんしつ 禅室 前室"
"ぜんしつきんえん 全室禁煙"
"ぜんしゃ 漸写 全射 前車 全車 全社 前者"
"ぜんしゃく 前借"
"ぜんしゃふべん 善者不辯 善者不弁"
"ぜんしゅ 髯鬚 善趣"
"ぜんしゅう 膳羞 全州 全周 禅宗 前週 全集"
"ぜんしゅつ 前出"
"ぜんしょ 善書 全所 善処 全書"
"ぜんしょう ∀ 前檣 全称 全章 前生 前哨 前章 全焼 全勝"
"ぜんしょうとう 前照灯"
"ぜんしょうば 全勝馬"
"ぜんしょく 前蜀 前職"
"ぜんしろう 善四郎"
"ぜんしん 前審 善心 前信 前震 善神 漸進 前身 前進 全身"
"ぜんしんせい 漸新世"
"ぜんじ 善事 善司 禅師 漸次"
"ぜんじく 全軸"
"ぜんじたい 前時代"
"ぜんじつ 全日 前日"
"ぜんじゅつ 前述"
"ぜんじゅん 前順"
"ぜんじょ 全女"
"ぜんじょう 善場 禅譲 禅定 前条"
"ぜんじょうに 禅定尼"
"ぜんじろう 善二郎 善次郎"
"ぜんじん 前人 全人"
"ぜんじんかいぎ 善人会議"
"ぜんすう 全数"
"ぜんず 全図"
"ぜんせ 前世"
"ぜんせい 全勢 前世 善政 全盛"
"ぜんせいせつ 前成説"
"ぜんせき 前席 全席"
"ぜんせつ 前説 前節"
"ぜんせん 全戦 善戦 全線 前線"
"ぜんぜつ 前舌"
"ぜんぜん 全々 前前 前々 全然"
"ぜんぜんげつ 前々月"
"ぜんぜんじつ 前々日"
"ぜんそ 髯蘇"
"ぜんそう 全奏 全層 禅僧 前奏 前走"
"ぜんそく 全速 喘息"
"ぜんそん 全村 全損"
"ぜんぞう 漸増"
"ぜんたい 全隊 全体"
"ぜんたろう 善太郎"
"ぜんたん 前端"
"ぜんだい 前代"
"ぜんだおん 前打音"
"ぜんだて 膳立て"
"ぜんだな 膳棚"
"ぜんだま 善玉"
"ぜんだまこれすてろーる 善玉コレステロール"
"ぜんだん 全段 前段"
"ぜんち 全知 全地 前置 全治"
"ぜんちく 善竹"
"ぜんちしき 善知識"
"ぜんちゅう 蠕虫"
"ぜんちゅううら 全中裏"
"ぜんちょ 前著"
"ぜんちょう 全町 前兆 全長"
"ぜんつう 全通"
"ぜんつうじ 善通寺"
"ぜんてい 前庭 前提"
"ぜんていそう 前庭窓"
"ぜんてき 全的 全摘"
"ぜんてつ 前轍"
"ぜんてん 全点 前転 全天 全店"
"ぜんでら 禅寺"
"ぜんでん 前殿"
"ぜんと 全都 前途"
"ぜんとう 漸騰 全頭 全島 前頭"
"ぜんど 髯奴 全土"
"ぜんどう 禅道 禅堂 善道 善導 蠕動 全道"
"ぜんな 禅那"
"ぜんなん 善男"
"ぜんに 禅尼"
"ぜんにち 全日"
"ぜんにゅう 全入"
"ぜんにょ 善女"
"ぜんにん 前任 善人"
"ぜんねん 前年"
"ぜんねんわれ 前年割れ"
"ぜんのーど 全ノード"
"ぜんのう 前脳 全脳 全納 全農 全能 前納"
"ぜんのすけ 善之助"
"ぜんはい 前胚 全廃"
"ぜんはく 前膊"
"ぜんはくぎゅう 冉伯牛"
"ぜんはん 全版 前半"
"ぜんはんころ 前半頃"
"ぜんば 全馬 前場"
"ぜんばん 前版 全判"
"ぜんぱい 全敗 全廃"
"ぜんぱく 全泊 前泊"
"ぜんぱん 前半 全般"
"ぜんひょう 全票 全表"
"ぜんび 全備 善美"
"ぜんびけ 前引け"
"ぜんびん 前便 全便"
"ぜんぴ 前非"
"ぜんぴょう 全豹 前表"
"ぜんぴん 全品"
"ぜんふくじこうえん 善福寺公園"
"ぜんふつ 全仏"
"ぜんふれんけつ 全不連結"
"ぜんぶ 膳部 前部 全部"
"ぜんぶん 前文 全文"
"ぜんぷ 前夫"
"ぜんぷく 全幅"
"ぜんぷれ 全プレ"
"ぜんへい 全閉"
"ぜんべい 全米"
"ぜんべいいち 全米一"
"ぜんぺーじ 前頁"
"ぜんぺい 全閉"
"ぜんぺき 前壁"
"ぜんぺん 全篇 前篇 全編 前編"
"ぜんぼう 全貌"
"ぜんぼうず 禅坊主"
"ぜんぽう 前方"
"ぜんぽうこうえんふん 前方後円墳"
"ぜんぽうじ 善宝寺"
"ぜんぽうやく 前方約"
"ぜんぽん 善本"
"ぜんまい 發条 全妹 撥条 発条 薇"
"ぜんまく 善悪"
"ぜんみ 禅味"
"ぜんみん 全民"
"ぜんめい 喘鳴"
"ぜんめつ 全滅"
"ぜんめん 前面 全面"
"ぜんもう 全毛 全盲"
"ぜんもん 禅門 前門 前問 全問"
"ぜんもんどう 禅問答"
"ぜんや 善也 前夜"
"ぜんやく 善役 前約 全訳"
"ぜんゆ 全癒"
"ぜんゆう 善友"
"ぜんゆうれん 全遊連"
"ぜんよう 冉雍 善用 前葉 全容"
"ぜんよく 前翼"
"ぜんら 全裸"
"ぜんらく 漸落"
"ぜんらなんどう 全羅南道"
"ぜんらほくどう 全羅北道"
"ぜんらん 全卵"
"ぜんりつ 全律"
"ぜんりつせん 前立腺"
"ぜんりつせんがん 前立腺ガン 前立腺がん 前立腺癌"
"ぜんりゃく 全略 前略"
"ぜんりゅうふん 全粒粉"
"ぜんりょう 全寮 全量 善良"
"ぜんりょく 全力"
"ぜんりん 禅林 善隣 前輪"
"ぜんれい 全零 全霊 全例 前例"
"ぜんれいちゅう 全冷中"
"ぜんれき 前歴"
"ぜんれつ 全裂 前列"
"ぜんろう 全労"
"ぜんろうさい 全労済"
"ぜんわ 禅話 全話"
"ぜんわん 全湾 前弯 前腕"
"そ 想 鼠 鼡 踈 麁 礎 甦 蘓 蘇 酥 蔬 疏 醋 措 酢 胙 祚 囎 噌 曽 曾 訴 泝 愬 溯 遡 塑 齟 詛 疽 沮 徂 咀 岨 姐 爼 俎 阻 狙 組 租 祖 粗 楚 疎 素"
"そーすいため ソース炒め"
"そーすに ソース煮"
"そーず 索子"
"そーだ 曹達"
"そーだすい ソーダ水"
"そーぷじょう ソープ嬢"
"そーらんぶし ソーラン節"
"そあく 粗悪"
"そあん 素案"
"そい 添い 粗衣"
"そいずみ 祖泉"
"そいちち 添い乳"
"そいね 添寝 添い寝"
"そいん 疎音 訴因 素因"
"そう 瀧 滝 漿 将 左右 然 然う 笙 炒 爪 窗 窓 爽 喪 桑 扱 鯵 赱 梍 掫 妝 嗾 剏 匝 蹌 艙 瘡 滄 搶 愴 蒼 鎗 槍 倉 創 髞 譟 澡 懆 噪 藻 燥 操 繰 歃 搜 嫂 叟 痩 捜 愡 怱 匆 偬 葱 惣 諍 筝 箏 崢 爭 争 菷 箒 帚 掃 裝 莊 弉 奘 壯 壮 庄 踪 淙 綜 崇 宗 甑 贈 曽 曾 噌 樔 勦 巣 箱 廂 孀 霜 輳 湊 奏 艸 屮 竃 竈 籔 薮 叢 蔟 簇 騷 蚤 掻 笊 抓 嗽 漱 插 挿 聰 總 聡 艚 遭 糟 漕 曹 槽 雙 双 艘 早 送 騒 葬 走 装 荘 草 宋 想 躁 僧 相 総 層"
"そうあい 相愛"
"そうあん 僧庵 操安 創案 草庵 草案"
"そうい 創痍 僧位 僧衣 相異 総意 創意 相違"
"そういち 宗市 聡一 壮一 宗一"
"そういちろう 惣一郎"
"そういっそう 層一層"
"そういん 挿引 掃引 総員 僧院"
"そううつ 躁鬱"
"そううん 曾雲 叢雲 層雲"
"そううんきょう 層雲峡"
"そうえん 蒼鉛 操演 装苑 桑園 荘園"
"そうえんふん 双円墳"
"そうおう 相応"
"そうおく 草屋"
"そうおん 相恩 宋音 噪音 騒音"
"そうおんれべる 騒音レベル"
"そうか 総嫁 送荷 葬歌 痩果 挿花 総科 僧伽 喪家 装荷 相加 層化 装花 創価 草加"
"そうかい 僧階 掃海 滄海 蒼海 壮快 爽快 総会"
"そうかいじょう 層階状"
"そうかいそうでん 滄海桑田"
"そうかく 双角 総角 総画"
"そうかせい 走化性"
"そうかつ 総轄 総括"
"そうかん 送棺 層間 相姦 送還 総監 壮観 相関 創刊"
"そうが 草画 爪牙 挿画 装画"
"そうがい 霜害 窓外"
"そうがかり 総掛り"
"そうがく 宋学 奏楽 総額"
"そうがな 草仮名"
"そうがわ 総革"
"そうがん 双眼"
"そうき 装軌 送気 総記 想起 早期"
"そうきがん 早期癌"
"そうきば 双牙"
"そうきへい 槍騎兵"
"そうきゃく 双脚"
"そうきゅう 躁急 蒼穹 送球 早急"
"そうきゅうるい 双弓類"
"そうきょ 巣居 壮挙"
"そうきょう 曾鞏"
"そうきょういく 早教育"
"そうきょく 双極 双曲 箏曲 総局"
"そうきん 鎗金 送金"
"そうきんるい 藻菌類"
"そうぎ 争議 葬儀"
"そうぎゃ 僧伽"
"そうぎょ 草魚 双魚"
"そうぎょう 早暁 僧形 操業 創業"
"そうぎり 総桐"
"そうぎん 相銀"
"そうく 痩躯 走狗"
"そうくう 蒼空"
"そうくうかん 相空間"
"そうくつ 巣窟"
"そうくん 宗薫"
"そうぐ 僧供 装具"
"そうぐう 遭遇"
"そうぐち 荘口"
"そうぐん 総軍"
"そうけ 宗家"
"そうけい 早慶 早計 総計"
"そうけいめい 早慶明"
"そうけつ 総結"
"そうけん 想見 創見 双肩 総見 壮健 送検 創建 総研"
"そうげい 送迎"
"そうげいばす 送迎バス"
"そうげつ 草月"
"そうげん 荘厳 創元 草原"
"そうげんたいご 壮言大語"
"そうこ 操觚 倉庫"
"そうこう 綜絖 相好 蒼惶 曹洪 艙口 倉口 糟糠 爪甲 霜降 操行 走向 奏効 奏功 送稿 草稿 壮行 装甲 走行"
"そうこうしゅ 走攻守"
"そうこうせい 走光性"
"そうこうのつま 糟糠の妻"
"そうこうばん 装甲鈑 装甲板"
"そうこく 宗国 相剋 相克"
"そうこしょう 双虎掌"
"そうこすと 総コスト"
"そうこつ 痩骨"
"そうこほうし 桑弧蓬矢"
"そうこん 愴恨 草根 早婚"
"そうご 双吾 總吾 総吾 壮語 相互"
"そうごう 相好 綜合 総合"
"そうごうてすと 総合テスト"
"そうごりんく 相互リンク"
"そうごん 荘厳"
"そうさ 匝瑳 走査 捜査 操作"
"そうさい 相殺 葬祭 総裁"
"そうさく 捜索 創作"
"そうさたく 操作卓"
"そうさつ 相殺"
"そうさらすう 総皿数"
"そうざい 惣菜"
"そうざらい 総浚い"
"そうざん 早産"
"そうし 宗祀 宋詞 曾子 繰糸 宗師 宋史 壮志 双紙 双糸 壮士 宗子 荘子 相思 創始 総司 草紙 草子 冊子 双子"
"そうしかいめい 創氏改名"
"そうしき 相識 葬式"
"そうしち 惣七"
"そうしつ 喪失"
"そうしもく 総翅目 双翅目"
"そうしゃ 喪車 双射 葬車 壮者 操車 掃射 走者 奏者"
"そうしゃえき 総社駅"
"そうしゅ 操守 漕手 双手 宗主"
"そうしゅう 総州 相州 荘周 爽秋 早秋 総集"
"そうしゅつ 簇出 走出 早出 送出 創出"
"そうしゅつし 走出枝"
"そうしゅん 早春"
"そうしゅんふ 早春賦"
"そうしょ 奏書 宋書 草書 双書 叢書"
"そうしょう 相称 創唱 相承 宗匠 争訟 相生 創傷 総称"
"そうしょく 僧職 草食 装飾"
"そうしょくか 装飾花"
"そうしょくきょう 装飾経"
"そうしょくじゅう 草食獣"
"そうしょだい 叢書第"
"そうしん 双親 壮心 喪心 装身 総身 喪神 痩身 送信"
"そうしんき 捜神記"
"そうしんぼたん 送信ボタン"
"そうじ ∽ 操持 挿耳 宗司 荘司 僧寺 荘子 送辞 走時 双児 相似 掃除"
"そうじうお 掃除魚"
"そうじうんそう 相次運送"
"そうじくけっしょう 双軸結晶"
"そうじじ 総持寺"
"そうじつ 桑実"
"そうじつはい 桑実胚"
"そうじて 総じて"
"そうじでら 総持寺"
"そうじふ 掃除婦 掃除夫"
"そうじめ 総締め"
"そうじゃ 壮者 総社"
"そうじゅ 奏授 双樹 送受"
"そうじゅう 層重 操縦"
"そうじゅうかん 操縦竿 操縦桿"
"そうじゅく 早熟"
"そうじゅくば 早熟馬"
"そうじゅしん 送受信"
"そうじゅつ 槍術"
"そうじゅん 走順 宗純"
"そうじょ 層序"
"そうじょう 僧上 早場 双調 総状 相生 騒擾 奏上 僧正 層状 相乗"
"そうじょうせき 相乗積"
"そうじょうたい 躁状態"
"そうじろう 宗次郎"
"そうじん 騒人"
"そうすい 送水 総帥"
"そうすう 曹嵩 双数 層数 総数"
"そうすかん 総好かん 総すかん 総スカン"
"そうず 索子 挿図 僧都"
"そうせい 簇生 早成 双生 葬制 奏請 双星 走性 早逝 叢生 早世 創世 創製 創生 創成"
"そうせいじ 早生児"
"そうせき 踪跡 僧籍 漱石"
"そうせきうん 層積雲"
"そうせきちんりゅう 漱石枕流"
"そうせつ 霜雪 総説 創設"
"そうせん 操船"
"そうぜい 総勢"
"そうぜつ 壮絶"
"そうぜん 愴然 蒼然 騒然"
"そうぜんじ 崇禅寺"
"そうそ 曾祖"
"そうそう 愴愴 蹌蹌 鏘鏘 簇簇 淙淙 怱怱 匆匆 層層 蒼蒼 総総 早早 錚錚 草草 蹌々 淙々 愴々 怱々 鏘々 匆々 簇々 総々 蒼々 層々 滄桑 送葬 喪葬 草叢 曹操 錚々 草創 草々 葬送 早々"
"そうそうのへん 滄桑の変"
"そうそく 相即 総則"
"そうそつ 怱卒 倉卒"
"そうそふ 曾祖父"
"そうそぼ 曾祖母"
"そうそん 曾孫"
"そうぞう 莊三 送像 総総 総々 想像 創造"
"そうぞうしん 創造神"
"そうぞく 相續 宗族 僧俗 装束 相続"
"そうたい 僧体 草体 総隊 双対 早退 相対 総体"
"そうたいぱす 相対パス"
"そうたつ 宗達 送達"
"そうたん 操短"
"そうだ 崇田 曹達 左右田 宗田 早田 操舵"
"そうだい 早稲田大学 相待 早大 総代 壮大"
"そうだいいん 早大院"
"そうだか 総高"
"そうだがつお 宗太鰹"
"そうだつ 争奪"
"そうだん 早弾 僧団 装弾 相談"
"そうち 葬地 送致 装置"
"そうちゃく 早着 装着"
"そうちょう 宗澄 双調 宋朝 荘重 曹長 総長 早朝"
"そうつい 相対 双対"
"そうつう 相通"
"そうてい 装釘 壮丁 送呈 漕艇 装幀 装丁 想定"
"そうてつ 蒼鉄 相鉄"
"そうてん 操典 総点 装填 蒼天 争点"
"そうてんい 層転移 相転移"
"そうで 総出"
"そうでん 叢伝 相伝 送電"
"そうと 壮図 壮途 僧徒"
"そうとう 総当 掃蕩 想到 争闘 相等 双頭 掃討 総統 相当"
"そうとうざん 相当算"
"そうとうしゅう 曹洞宗"
"そうとく 総督"
"そうとめ 早乙女"
"そうどう 僧堂 草堂 相同 騒動"
"そうどうし 相動詞"
"そうどうせん 双胴船"
"そうない 層内"
"そうなめ 総嘗め 総ナメ 総なめ"
"そうなん 遭難"
"そうに 僧尼"
"そうにゅう 総入 挿入"
"そうにょう 爪繞 走繞"
"そうにんかん 奏任官"
"そうねん 早年 想念 壮年"
"そうは 掻爬 争覇 走破"
"そうはい 送配"
"そうはく 糟粕 蒼白"
"そうはくそ 曾伯祖"
"そうはち 壮八"
"そうはつ 総髪 早発 双発 創発"
"そうはん 相反"
"そうば 相場"
"そうばい 層倍 早梅"
"そうばつ 挿抜"
"そうばな 総花"
"そうばん 早晩"
"そうひ 曹丕"
"そうひょう 総評"
"そうひん 送品"
"そうび 薔薇 壮美 装備"
"そうびしゃ 創美社"
"そうびょう 宗廟 躁病"
"そうびん 双鬢 聡敏"
"そうふ 奏譜 孀婦 総譜 送付"
"そうふう 送風"
"そうふく 僧服"
"そうぶ 創部 総武"
"そうぶだい 相武台"
"そうぶん 処分 奏文 奏聞 宋文"
"そうへい 操兵 僧兵"
"そうへいこう 相平衡"
"そうへき 双璧"
"そうべつ 壮瞥 層別 送別"
"そうほ 宗歩 相補"
"そうほう 遭逢 宗豊 総包 葬法 双峰 総苞 走法 奏法 双方"
"そうほさ 相補鎖"
"そうほん 装本 草本"
"そうぼう 怱忙 想望 僧帽 蒼茫 蒼氓 僧房 僧坊 相貌 双眸"
"そうぼり 総掘り"
"そうま 相馬"
"そうまい 草昧 相米"
"そうまぎょふう 相馬御風"
"そうまくり 総捲り"
"そうまとう 走馬燈 走馬灯"
"そうみ 総身"
"そうむ 創夢 双務 総務"
"そうむかかり 総務掛"
"そうむがかり 総務掛"
"そうむら 荘村"
"そうめい 聰明 早明 聡明"
"そうめいきょく 奏鳴曲"
"そうめつ 剿滅 掃滅"
"そうめん 索麺 創面 双面 素麺"
"そうもく 総目 草木"
"そうもくばい 草木灰"
"そうもじ 草文字"
"そうもん 艸門 僧門 桑門 奏聞 相聞 惣門 総門"
"そうや 宗谷"
"そうやく 草薬 装薬 創薬"
"そうやま 相山"
"そうやみさき 宗谷岬"
"そうゆ 総湯"
"そうゆう 曾遊 総有"
"そうよう 相擁 掻痒 装用"
"そうよく 双翼"
"そうらく 相楽"
"そうらん 奏覧 総攬 争乱 騒乱 総覧"
"そうり 總理 層理 総理"
"そうりきょうせい 相利共生"
"そうりつ 総立 創立"
"そうりゅう 宗留 総流 蒼竜 双龍 蒼龍 層流"
"そうりゅうざん 早流産"
"そうりゅうでん 創竜伝"
"そうりょ 僧侶"
"そうりょう 爽涼 惣領 総領 総量 送料"
"そうりょうこみ 送料込"
"そうりょく 走力 総力"
"そうりん 僧林 霜林 総輪 叢林 双輪 相輪 装輪"
"そうりんかんけい 相隣関係"
"そうりんしゃ 相隣者"
"そうるい 草類 走塁 藻類"
"そうるび 総ルビ"
"そうれい 壮齢 葬礼 壮麗"
"そうれつ 壮烈 葬列"
"そうれん 操練"
"そうろ 草露 走路"
"そうろう 層楼 蹌踉 早老 早漏 候"
"そうろうてい 滄浪亭"
"そうろうぶん 候文"
"そうろん 争論 総論"
"そうわ Σ 送話 挿話 総和"
"そうわく 総枠"
"そうわん 双腕"
"そえ 儲 貮 酘 添 副 添え"
"そえいし 添石"
"そえうた 諷歌"
"そえかみ 添上"
"そえがき 添書"
"そえき 素液"
"そえぎ 添木 添え木"
"そえしょ 添書"
"そえじ 添字"
"そえじま 副島"
"そえじょう 添状"
"そえだ 添田"
"そえぢ 添乳"
"そえつどうしゅう 楚越同舟"
"そえの 添野"
"そえばしら 添え柱"
"そえぶみ 添文"
"そえや 添谷"
"そえん 疎遠"
"そお 囎唹 赭"
"そおに 赭土"
"そか 粗菓"
"そかい 素懐 租界 疎開"
"そかぎょ 遡河魚 溯河魚"
"そかく 阻隔 素核 疎隔 組閣"
"そかつ 疎闊"
"そが 疎画 曾我 蘇我 曽我"
"そがい 阻碍 鼠害 疎外 阻害"
"そがく 訴額"
"そがん 訴願"
"そきゃく 阻却"
"そきゅう 遡求 遡及 訴求"
"そきゅうこう 遡及効"
"そぎ 枌"
"そぎぎり 削ぎ切り"
"そぎょう 礎業 祖業"
"そぎょうれつ 疎行列"
"そく 蔟 喞 塞 捉 促 仄 束 熄 息 惻 測 側 則 足 速 即"
"そくあつ 側圧"
"そくい 側位 測位 即位"
"そくいん 仄韻 惻隠"
"そくえい 即詠"
"そくえん 測鉛"
"そくおう 即応"
"そくおん 側音 促音"
"そくおんき 足温器"
"そくが 側芽 側臥"
"そくき 測器"
"そくぎれ 即切れ"
"そくぎん 即吟"
"そくこつ 足骨"
"そくこん 側根"
"そくさ 側鎖"
"そくさい 息災"
"そくさん 速算"
"そくざ 即座"
"そくし 側視 足趾 側枝 即死"
"そくしつ 側室"
"そくしゃ 即車 速写 速射"
"そくしゅう 束脩"
"そくしょくけい 測色計"
"そくしん 測深 即身 促進"
"そくしんすい 測深錘"
"そくしんぜぶつ 即心是仏"
"そくしんそくぶつ 即心即仏"
"そくしんねんぶつ 即心念仏"
"そくしんぶつ 即身仏"
"そくしんらん 束心蘭"
"そくじ 即事 即自 即時"
"そくじく 側軸"
"そくじつ 即日"
"そくじょ 息女"
"そくすい 測錘"
"そくせい 仄声 即製 側生 速成 促成"
"そくせいはん 即成犯"
"そくせき 足蹠 足跡 即席"
"そくせきめん 即席麺"
"そくせん 測線 側線 塞栓"
"そくせんそっけつ 速戦即決"
"そくそう 惻愴"
"そくそく 測々 惻々 促々 惻惻 促促"
"そくたい 束帯"
"そくたつ 速達"
"そくだい 即題"
"そくだく 即諾"
"そくだん 速断 即断"
"そくち 即値 測地"
"そくちゅうせいし 速中性子"
"そくづみ 即詰"
"そくづめ 即詰"
"そくてい 足底 測定"
"そくてん 側転 測点"
"そくてんきょし 則天去私"
"そくてんぶこう 則天武后"
"そくとう 側倒 速答 足刀 側頭 即答"
"そくど 束度 測度 速度"
"そくどう 速動 側道"
"そくどく 速読"
"そくのう 即納"
"そくは 側波"
"そくはく 束帛 促迫"
"そくはっしん 速発進"
"そくはつ 束髪 即発"
"そくはら 束原"
"そくはん 測範"
"そくはんかい 即販会"
"そくばい 即買 即売"
"そくばく 若干 幾許 束縛"
"そくばん 測板"
"そくひつ 速筆"
"そくひにょいち 即非如一"
"そくび 素首 足尾"
"そくぶ 側部"
"そくぶつ 即物"
"そくぶん 仄聞"
"そくへき 側壁"
"そくへん 側辺"
"そくほ 速歩"
"そくほう 側方 速報"
"そくまく 側膜"
"そくみゃく 側脈"
"そくみょう 即妙"
"そくめつ 熄滅"
"そくめん 側面"
"そくもん 足紋"
"そくよく 足浴"
"そくよくせい 側抑制"
"そくりき 足力"
"そくりゅう 測流"
"そくりょう 測量"
"そくりょく 速力"
"そくろ 側路"
"そくろう 側廊 足労"
"そくろん 束論"
"そくわん 側弯"
"そけい 鼠蹊 祖型 鼠径"
"そけつごう 疎結合"
"そけん 訴件 素絹 素見 訴権"
"そげき 狙撃"
"そげん 溯源 遡源"
"そこ 其所 其処 底"
"そこあげ 底上げ"
"そこい 底意"
"そこいた 底板"
"そこいれ 底入れ"
"そこう 鼠口 粗稿 遡航 粗鋼 遡行 素行"
"そこうお 底魚"
"そこうけん 租鉱権"
"そこうち 底打ち"
"そこく 祖国"
"そこくら 底倉"
"そこじゃり 底砂利"
"そこせんよう 底専用"
"そこち 底地"
"そこぢから 底力"
"そこつ 粗忽"
"そこつち 底土"
"そこづみ 底積み"
"そこなし 底なし 底無し"
"そこなしぬま 底なし沼 底無し沼"
"そこなだれ 底雪崩"
"そこに 底荷"
"そこぬけ 底抜け"
"そこね 底値"
"そこば 幾許 若干"
"そこばく 幾許 若干"
"そこひ 底翳 内障"
"そこびえ 底冷え"
"そこびかり 底光り"
"そこびき 底引 底引き"
"そこびきあみ 底曳き網 底引網 底曳網 底引き網"
"そこら 其処ら"
"そこらじゅう そこら中"
"そご 祖語 齟齬"
"そさい 蔬菜"
"そさつ 粗擦"
"そざい 礎材 素材"
"そざつ 粗雑"
"そし 素志 粗視 祖師 素子 阻止"
"そしがや 祖師ヶ谷"
"そしき 素式 組織"
"そしたいよう 麁枝大葉"
"そしつ 素質"
"そして 然して"
"そしな 粗品"
"そしゃく 租借 咀嚼"
"そしゅ 粗酒"
"そしゅう 蘇州"
"そしょう 酢漿 粗鬆 訴訟"
"そしょく 疎植 蘇軾 素食 粗食"
"そしらぬ 素知らぬ そ知らぬ"
"そしり 誹り 謗り"
"そしりぐさ 謗り種"
"そしん 蘇秦 祖神"
"そじ 十路 措辞 楚辞 素地"
"そじゅつ 祖述"
"そじゅん 蘇洵"
"そじょう 爼上 溯上 俎上 訴状 遡上"
"そすい 疏水 疎水"
"そすう 素数"
"そせい 疎性 甦生 粗製 素性 塑性 蘇生 組成"
"そせき 組積 礎石"
"そせきぞう 組積造"
"そせつ 素雪"
"そせん 祖先"
"そぜい 租税"
"そそ 素々 楚々 楚楚"
"そそう 楚愴 沮喪 阻喪 祖宗 粗相"
"そそぎ 曽々木"
"そそぎぐち 注ぎ口"
"そそん 祖孫"
"そぞう 塑像"
"そぞろ 漫"
"そぞろあるき 漫ろ歩き"
"そた 曽田"
"そだ 麁朶 粗朶 曽田"
"そだい 措大 粗大"
"そだいごみ 粗大ゴミ"
"そだち 育ち"
"そだて 育て"
"そだてのおや 育ての親"
"そち 埣 其方 帥 措置"
"そちゃ 粗茶"
"そっか 足下"
"そっかん 速乾"
"そっき 速記 測器"
"そっきしゃ 測機舎"
"そっきゅう 速急 即急 速球"
"そっきょ 卒去 測距"
"そっきょう 即興"
"そっきょうし 即興詩"
"そっきん 速筋 即金 側近"
"そっくび 素っ首"
"そっけ 素気"
"そっけつ 即決"
"そっこう 即行 測光 側溝 速効 即効 速攻"
"そっこうき 測高器"
"そっこうじょ 測候所"
"そっこく 即刻"
"そっこつ 足骨"
"そっこん 即今"
"そっせん 率先"
"そっちゅう 卒中"
"そっちょく 卒直 率直"
"そって 沿って"
"そっとう 卒倒"
"そっぱ 反歯 反っ歯"
"そっぷがた ソップ形"
"そっぽ 外方"
"そっぽう 外方"
"そつ 猝 卆 率 卒"
"そつい 訴追"
"そつう 疏通 疎通"
"そつえん 卒園"
"そつぎょう 卒業"
"そつぎょうあるばむ 卒業アルバム"
"そつぎょういわい 卒業祝"
"そつけん 卒研"
"そつご 卒後"
"そつじ 卒爾"
"そつじゅ 卒寿"
"そつぜん 率然 卒然"
"そつだん 卒団"
"そつどく 卒読"
"そつぶ 卒部"
"そつろん 卒論"
"そてい 措定"
"そてつ 蘇轍 蘇鉄"
"そてつこう ソテツ綱"
"そてつしだもく ソテツシダ目"
"そてん 素点"
"そで 袖"
"そであみ 袖網"
"そでかんばん 袖看板"
"そでがうら 袖ケ浦 袖ヶ浦"
"そでがき 袖垣"
"そでがらみ 袖搦み"
"そでがわら 袖瓦"
"そでき 袖木"
"そでぐち 袖口"
"そでぐり 袖刳り"
"そでしょう 袖章"
"そでたけ 袖丈"
"そでだたみ 袖畳み"
"そでつけ 袖付け"
"そでなし 袖無し"
"そでのした 袖の下"
"そではば 袖幅"
"そでべい 袖塀"
"そでまく 袖幕"
"そでやま 袖山"
"そでんか 素電荷"
"そと 外"
"そとあし 外足"
"そといた 外板"
"そとう 蘇東 粗糖"
"そとうば 蘇東坡 卒塔婆"
"そとうみ 外海"
"そとうら 外浦"
"そとおもて 外表"
"そとかわ 外皮"
"そとかん 外環"
"そとがこい 外囲い"
"そとがた 外型"
"そとがま 外釜"
"そとがまえ 外構え"
"そとがわ 外側"
"そとさぶらい 外侍"
"そとぜい 外税"
"そとづけ 外付"
"そとづつ 外筒"
"そとづら 外面"
"そとで 外出"
"そととびら 外扉"
"そとどい 外樋"
"そとねこ 外猫"
"そとのり 外法"
"そとば 率堵婆 率塔婆 卒都婆 外葉 外刃 卒塔婆"
"そとばき 外履き"
"そとばこ 外箱"
"そとぶた 外蓋"
"そとぼう 外房"
"そとぼり 外壕 外濠 外堀"
"そとま 外間"
"そとまき 外巻"
"そとまご 外孫"
"そとまた 外股"
"そとまど 外窓"
"そとみ 外見"
"そとめ 外海 外目"
"そとものみち 山陰道"
"そともも 外腿 外股"
"そとやま 外山"
"そとゆ 外湯"
"そとわく 外枠"
"そどう 粗銅"
"そどうめい 蘇同盟 ソ同盟"
"そどく 素読"
"そなえ 供え 備え"
"そなえつけ 備付け 備付"
"そなえもの 供物"
"そなた 其方"
"そなたけいしき ソナタ形式"
"そに 曾爾"
"そにーぎんこう ソニー銀行"
"そにちは 疎日派"
"そにん 訴人"
"そね 埆 埣 曽祢 曾根 曽根"
"そねおか 曽根岡"
"そねざき 曾根崎 曽根崎"
"そねつ 粗熱"
"そねのよしただ 曾禰好忠"
"そねみ 嫉み"
"その 薗 曾野 其 其の 苑 園"
"そのあと その後"
"そのう 園生"
"そのうえ その上"
"そのうち その内"
"そのお 園生"
"そのかた その方"
"そのかわ 園川"
"そのかん その間"
"そのき その気"
"そのぎ 彼杵"
"そのぐち 薗口 園口"
"そのこ 苑子 園子 その子"
"そのころ その頃"
"そのご その後"
"そのさい その際"
"そのじつ 其の実"
"そのた 其の他 その他"
"そのだ 苑田 薗田 園田"
"そのつき 其月"
"そのて その手"
"そのてん その点"
"そのとき その時"
"そのとし その年"
"そのな その名"
"そののち その後"
"そのば その場"
"そのばかぎり 其の場限り"
"そのばしのぎ 其の場凌ぎ"
"そのひぐらし その日暮らし"
"そのぶん その分"
"そのへん その辺"
"そのべ 園部"
"そのほう 其の方 その方"
"そのほか その他"
"そのまえ その前"
"そのまま 其の儘"
"そのみち 其の道"
"そのむら 園村"
"そのもの その物"
"そのやま 園山"
"そはん 組版"
"そはんのう 素反応"
"そば 岨 傍 側 蕎麦"
"そばお 曽場尾"
"そばかす 蕎麦滓"
"そばがき 蕎麦がき 蕎麦掻き"
"そばがら 蕎麦殻"
"そばこ そば粉 蕎麦粉"
"そばつゆ 蕎麦汁"
"そばづかえ 側仕え"
"そばはら 側腹"
"そばめ 側目 側妻 側女"
"そばや そば屋"
"そばやく 側役"
"そばようにん 側用人"
"そばん 礎盤"
"そひつ 粗筆"
"そびえとれんぽう ソビエト連邦"
"そびょう 粗描 祖廟 素描"
"そびょうばんが 素描版画"
"そびら 背"
"そふ 祖父"
"そふえ 祖父江"
"そふく 粗服"
"そふけん ソフ研"
"そふとうぇあかがく ソフトウェア科学"
"そふとぶ ソフト部"
"そふとぼーるぶ ソフトボール部"
"そふとぼう ソフト帽"
"そふとめい ソフト名"
"そふとめん ソフト麺 ソフト面"
"そふぼ 祖父母"
"そぶ 蘇武"
"そぶえ 祖父江"
"そぶり 素振り"
"そぶん 処分"
"そへん 素片"
"そほう 粗放"
"そほうか 素封家"
"そほに 赭土"
"そほん 粗笨 祖本"
"そぼ 祖母"
"そぼう 粗暴"
"そぼく 粗樸 粗朴 素朴"
"そま 杣"
"そまぎ 杣木"
"そまつ 粗末"
"そまびと 杣人"
"そまみち 杣道"
"そみつ 疎密 粗密"
"そみや 曽宮"
"そみんしょうらい 蘇民将来"
"そむく 乖"
"そめ 染 染め"
"そめい 疏明 染井 疎明"
"そめき 染木 染め木"
"そめたろう 染太郎"
"そめち 染地"
"そめつけ 染付け"
"そめのすけ 染乃助"
"そめもの 染物"
"そめもよう 染模様"
"そめや 染屋 染谷"
"そめわけ 染分け"
"そめん 粗面"
"そめんがん 粗面岩"
"そも 抑"
"そもじ 其文字"
"そもそも 抑 抑抑 抑々"
"そや 粗野"
"そやつ 其奴"
"そやま 曽山"
"そよう 蘇陽 素養"
"そようちょう 租庸調"
"そよかぜ そよ風 微風"
"そよご 冬青"
"そら 空"
"そらあい 空合い 空合"
"そらい 徂徠"
"そらいろ 空色"
"そらおぼえ 空覚え"
"そらぎき 空聞き"
"そらぐみ 宙組"
"そらごと 虚言 空言"
"そらせいもん 空誓文"
"そらだのみ 空頼み"
"そらち 空知"
"そらなき 空泣き"
"そらなみだ 空涙"
"そらに 空似"
"そらね 空寝 空音"
"そらほうこう 空方向"
"そらまめ 蚕豆 空豆"
"そらみみ 空耳"
"そらみみのおか 空耳の丘"
"そらめ 空目"
"そらものがたり 空物語"
"そらもよう 空模様"
"そらゆめ 空夢"
"そらよみ 空読み"
"そらわらい 空笑い"
"そり 轌 艝 橇 反り"
"そりあと 剃り跡"
"そりじたおん 反舌音"
"そりた 返田"
"そりのこし 剃り残し"
"そりはし 反橋"
"そりまち 反町"
"そりみ 反り身"
"そりゃく 疎略 粗略"
"そりゅうし 素粒子"
"そりん 疎林"
"それ 其れ 其"
"それい 祖霊"
"それがし 某"
"それがしかれがし 某彼某"
"それぞれ 其々 夫夫 其其 夫々"
"それとなく 其と無く"
"それどころ 其処"
"それほど それ程"
"それゆえ それ故"
"それら 其れ等"
"それん 蘇連 蘇聯 ソ聯 ソ連"
"それんぽう ソ聯邦 ソ連邦"
"そろい 揃 揃い"
"そろいぶみ 揃い踏み"
"そろう 粗漏 疎漏"
"そろえ 揃え"
"そろばん 十露盤 算盤"
"そわ 岨 曽和"
"そん 鱒 噂 蹲 樽 邨 忖 拵 遜 巽 存 孫 尊 村 損"
"そんい 尊意"
"そんえい 尊詠 尊影 村営"
"そんえき 損益"
"そんか 尊下 尊家"
"そんかい 村会 損壊"
"そんがい 村外 損害"
"そんがん 尊顔"
"そんき 損気 尊貴"
"そんきょ 蹲踞"
"そんきり 損切り"
"そんきん 損金"
"そんぎ 存疑 村議"
"そんぎり 損切り"
"そんけい 尊兄 尊敬"
"そんけん 孫権"
"そんげん 尊厳"
"そんこう 存稿 損耗"
"そんごう 尊号"
"そんごくう 孫悟空"
"そんざい ∃ 存在"
"そんざいとじかん 存在と時間"
"そんし 尊司 損紙 尊子 尊師 孫子"
"そんしつ 損失"
"そんしゃ 村社"
"そんしゃさんゆう 損者三友"
"そんしゅ 尊守"
"そんしょ 尊書"
"そんしょう 尊勝 尊称 損傷"
"そんしょく 遜色"
"そんしん 尊信"
"そんじゃ 尊者"
"そんじゅく 村塾"
"そんじょう 尊攘"
"そんすう 尊崇"
"そんせい 村制 村勢 村政"
"そんぜい 村税"
"そんぜん 尊前"
"そんそせっしょう 樽俎折衝"
"そんぞう 尊像"
"そんぞく 尊属 存続"
"そんたい 尊体"
"そんたく 尊宅 忖度"
"そんだい 尊大"
"そんち 存置"
"そんちょう 村長 尊重"
"そんてん 尊天"
"そんとく 損得"
"そんどう 尊堂 村道"
"そんない 村内"
"そんのう 尊王 尊皇"
"そんぱい 存廃"
"そんぴ 村費 尊卑 存否"
"そんぴぶんみゃく 尊卑分脈"
"そんぶ 孫武"
"そんぶん 孫文"
"そんぷ 尊父"
"そんぷうし 村夫子"
"そんぼう 損亡 存亡"
"そんぽ 損保"
"そんぽう 尊報 尊奉"
"そんみん 村民"
"そんめい 尊命 尊名"
"そんもう 損亡 損耗 存亡"
"そんゆう 損友 村邑 村有"
"そんよう 尊容"
"そんらく 村落"
"そんらん 尊覧"
"そんり 村里"
"そんりつ 村立 存立"
"そんりょ 尊慮"
"そんりょう 損料"
"ぞ 祖 曽 曾"
"ぞい 沿 沿い"
"ぞう 曽 曾 噌 三 臟 藏 雜 襍 賍 臧 梍 慥 憎 僧 贓 臓 雑 蔵 贈 造 増 象 像"
"ぞうあい 憎愛"
"ぞうあく 造悪 増悪"
"ぞうい 贈位"
"ぞういん 増員"
"ぞうえい 造営 造影"
"ぞうえき 増益"
"ぞうえん 増援 造園"
"ぞうお 憎悪"
"ぞうか 増価 造化 造花 増加"
"ぞうかん 増感 増刊"
"ぞうかんすう 像関数"
"ぞうがく 増額"
"ぞうがめ 象亀"
"ぞうがん 造龕 象眼 象嵌"
"ぞうき 造機 雑木 臓器"
"ぞうきばやし 雑木林"
"ぞうきゅう 増給"
"ぞうきょう 増強"
"ぞうきん 雑巾"
"ぞうけい 造詣 造型 造形"
"ぞうけつ 増血 増結 造血"
"ぞうげ 象牙"
"ぞうげい 雑芸"
"ぞうげのとう 象牙の塔"
"ぞうげん 造言 雑言 増減"
"ぞうこく 増石"
"ぞうご 造語"
"ぞうごう 贈号"
"ぞうごん 雑言"
"ぞうさ 雑作 造作"
"ぞうさく 増作 造作"
"ぞうさつ 増刷"
"ぞうさん 増産"
"ぞうざい 造材"
"ぞうざん 造山"
"ぞうし 双紙 草紙 草子 増資"
"ぞうしがや 雑司ヶ谷"
"ぞうしき 雑色"
"ぞうしゃ 増車"
"ぞうしゅ 造酒"
"ぞうしゅう 贈収 増収"
"ぞうしゅつ 造出"
"ぞうしょ 蔵書"
"ぞうしょう 贈賞 増床 蔵相"
"ぞうしょうさんご 造礁珊瑚"
"ぞうしょく 増殖"
"ぞうしん 増進"
"ぞうじ 造次 造字 造寺"
"ぞうじょう 増上"
"ぞうじょうてん 増長天"
"ぞうじょうまん 増上慢"
"ぞうじるし 象印"
"ぞうす 蔵主"
"ぞうすい 増水 雑炊"
"ぞうせい 増生 増勢 造成"
"ぞうせいき 蔵精器 造精器"
"ぞうせつ 雑説 造設 増設"
"ぞうせつとびら 増設扉"
"ぞうせん 造船"
"ぞうぜい 増勢 増税"
"ぞうそく 増速"
"ぞうぞう 造像"
"ぞうたん 増炭 増反"
"ぞうだ 造田"
"ぞうだい 増大"
"ぞうちく 増築"
"ぞうちぜい 増地税"
"ぞうちょう 増徴 増長"
"ぞうちょうてん 増長天"
"ぞうてい 増訂 贈呈"
"ぞうてん 像点"
"ぞうとう 造塔 贈答"
"ぞうとく 蔵匿"
"ぞうに 雑煮"
"ぞうにん 雑人"
"ぞうねん 増粘"
"ぞうは 増派"
"ぞうはい 増配"
"ぞうはくざい 増白剤"
"ぞうはつ 増発"
"ぞうはん 増版 蔵版 造反"
"ぞうばい 増倍"
"ぞうひ 象皮"
"ぞうひょう 雑兵"
"ぞうび 増備"
"ぞうびん 増便"
"ぞうふ 臓腑"
"ぞうふく 増幅"
"ぞうぶつ 贓物 造仏 造物"
"ぞうぶん 増分"
"ぞうへい 造兵 造幣"
"ぞうへいしょう 造兵廠"
"ぞうほ 増補"
"ぞうほう 増俸"
"ぞうほうたい 造胞体"
"ぞうほん 造本 蔵本"
"ぞうぼう 像法"
"ぞうぼく 雑木"
"ぞうまえ 像前"
"ぞうむし 象虫"
"ぞうめんわんきょく 像面湾曲"
"ぞうもう 増毛"
"ぞうもつ 雑物 臓物"
"ぞうよ 贈与"
"ぞうよう 雑徭 雑用"
"ぞうらんき 蔵卵器 造卵器"
"ぞうり 草履"
"ぞうりむし 草履虫"
"ぞうりょう 増量"
"ぞうりょく 増力"
"ぞうりん 造林"
"ぞうわい 贈賄"
"ぞうわく 増枠"
"ぞえ 添"
"ぞく 足 束 屬 續 粟 俗 属 賊 族 続"
"ぞくあく 俗悪"
"ぞくうけ 俗受け"
"ぞくえい 続映"
"ぞくえん 俗縁 続演"
"ぞくおん 属音"
"ぞくか 俗化"
"ぞくかい 続開 俗界"
"ぞくがいこん 族外婚"
"ぞくがく 俗学"
"ぞくがら 続柄"
"ぞくがん 俗眼"
"ぞくぎいん 族議員"
"ぞくぐ 属具"
"ぞくぐん 賊軍"
"ぞくけ 俗気"
"ぞくげん 続弦 俗諺 俗言"
"ぞくご 俗語"
"ぞくさい 続載"
"ぞくさんへんど 粟散辺土"
"ぞくし 賊子 続紙"
"ぞくしち 属七"
"ぞくしゅ 俗手"
"ぞくしゅう 俗衆 俗習 俗臭 属州"
"ぞくしゅつ 続出"
"ぞくしょ 俗書"
"ぞくしょう 族称 俗称"
"ぞくしん 俗心 賊臣 俗信 続伸"
"ぞくじ 俗耳 俗事 俗字"
"ぞくじょう 俗情"
"ぞくじん 族人 俗塵 属人 俗人"
"ぞくする ∋ ∈"
"ぞくせ 俗世"
"ぞくせい 簇生 族生 俗姓 族制 俗世 属性"
"ぞくせき 族籍"
"ぞくせつ 俗説"
"ぞくぞく 続々"
"ぞくたい 俗体 俗諦"
"ぞくだん 俗談"
"ぞくち 俗知 属地"
"ぞくちょう 俗調 属調 族長"
"ぞくでん 俗伝"
"ぞくと 賊徒"
"ぞくとう 続騰 属島 続投"
"ぞくないこん 族内婚"
"ぞくに 俗に"
"ぞくねん 俗念"
"ぞくはい 俗輩"
"ぞくはく 粟帛"
"ぞくはつ 続発"
"ぞくばなれ 俗離れ"
"ぞくふ 族譜"
"ぞくぶつ 俗物"
"ぞくぶん 俗文"
"ぞくへい 賊兵"
"ぞくへん 続篇 続編"
"ぞくほう 続報"
"ぞくみょう 俗名"
"ぞくむ 俗務"
"ぞくめい 賊名 俗名 属名"
"ぞくめつ 族滅"
"ぞくよう 俗用 俗謡"
"ぞくらく 続落"
"ぞくり 属吏 俗吏"
"ぞくりゅう 俗流 粟粒"
"ぞくりょう 俗了 属僚 属領"
"ぞくろん 続論 俗論"
"ぞくわおん 属和音"
"ぞこ 底"
"ぞっか 俗家 俗化"
"ぞっかい 俗解 続開 俗界"
"ぞっかく 属格"
"ぞっかん 俗間 属官 続刊"
"ぞっきぼん ぞっき本"
"ぞっきや ぞっき屋"
"ぞっきょう 俗境"
"ぞっきょく 俗曲"
"ぞっこう 続稿 続行"
"ぞっこく 属国"
"ぞの 薗 園"
"ぞめ 初め"
"ぞら 空"
"ぞろあすたーきょう ゾロアスター教"
"ぞろい 揃い"
"ぞろめ ぞろ目 ゾロ目"
"ぞん 存 損"
"ぞんい 存意"
"ぞんがい 存外"
"ぞんじ 存じ 存知"
"ぞんじょう 存生"
"ぞんせい 存星"
"ぞんち 存知"
"ぞんぢ 存知"
"ぞんねん 存念"
"ぞんぶん 存分"
"ぞんめい 存命"
"た 岔 朶 躱 蛇 它 咤 佗 侘 詑 詫 夛 汰 手 太 多 田 他"
"たーすーしー 大四喜"
"たあい 他愛"
"たあちゃ 他家"
"たあはい 多牌"
"たい 體 軆 躰 對 頽 諦 黛 待 戴 替 貸 玳 代 袋 岱 帶 滯 滞 腿 褪 退 碓 堆 抬 擡 紿 駘 殆 颱 台 苔 怠 汰 太 大 靆 隶 逮 泰 田居 田井 耐 胎 帯 態 体 対 鯛 隊 他意"
"たいあたり 体当り 体当たり"
"たいあつ 耐圧"
"たいあん 泰安 対案 大安"
"たいい 大医 胎位 退位 大尉 大意 体位"
"たいいき 大域 帯域"
"たいいく 体育"
"たいいくのひ 体育の日"
"たいいち 対一 太一"
"たいいほう 対位法"
"たいいん 退隠 太陰 退院 隊員"
"たいいんいわい 退院祝"
"たいう 大雨"
"たいえい 退嬰 大栄"
"たいえき 退役 体液"
"たいえつ 大悦"
"たいえん 退園 対円"
"たいおう 對應 対欧 滞欧 対応"
"たいおとし 体落とし"
"たいおん 体温"
"たいか 耐過 袋果 滞貨 帯化 大廈 大厦 大過 大化 大火 退化 耐火 大家 対価"
"たいかい 大海 退会 大会"
"たいかいしん 大会新"
"たいかく 台閣 対格 対角 体格"
"たいかん 大旱 大患 大官 大鑑 対艦 退館 戴冠 体幹 退官 耐寒 大観 体感"
"たいかんみんこく 大韓民国"
"たいが 大牙 胎芽 大我 大雅 大河"
"たいがい 大外 体外 対外 大概"
"たいがく 退学"
"たいがため 体固め"
"たいがどらま 大河ドラマ"
"たいがん 対顔 大願 対岸"
"たいき 対気 大樹 隊旗 大器 待機 大気"
"たいきおん 帯気音"
"たいきこう 大気光"
"たいきしゃ 大氣社"
"たいきだいじゅんかんもでる 大気大循環モデル"
"たいきゃく 退却"
"たいきゅう 耐久"
"たいきょ 大虚 太虚 退居 大挙 退去"
"たいきょう 滞京 胎教 体協"
"たいきょく 大極 太極 大曲 大局 対極 対局"
"たいきろく タイ記録"
"たいきん 退勤 大金"
"たいぎ 体技 大儀 大義"
"たいぎご 対義語"
"たいぎゃく 大逆"
"たいぎょ 大魚"
"たいぎょう 怠業 大業"
"たいく 体躯"
"たいくう 体腔 滞空 対空"
"たいくうだん 対空弾"
"たいくつ 退屈"
"たいくつおとこ 退屈男"
"たいくん 大君"
"たいぐ 大愚"
"たいぐう 対偶 待遇"
"たいぐん 大郡 大軍 大群"
"たいけ 大家"
"たいけい 腿頚 隊型 体刑 隊形 大慶 大計 大兄 体形 大系 体型 体系"
"たいけいどうぶつ 袋形動物"
"たいけつ 対決"
"たいけん 帯剣 大圏 大賢 大権 大剣 体験"
"たいけんれぽーと 体験レポート"
"たいげ 帯下"
"たいげん 大言 体言 体現"
"たいげんどめ 体言止め"
"たいこ 大呼 鯛子 奈子 大戸 太古 太鼓"
"たいこう 体育講義 体講 帯鉤 褪紅 退紅 大江 大興 大行 退校 大功 体腔 太后 対校 耐候 体高 太閤 退行 対向 大公 大綱 対抗"
"たいこうぎょ 大口魚"
"たいこうたいごう 太皇太后"
"たいこうち 太鼓打"
"たいこうはんしゃ 対光反射"
"たいこうば 対抗馬"
"たいこうぼう 太公望"
"たいこく 大国"
"たいこばら 太鼓腹"
"たいこへん 大古編"
"たいこもち 太鼓持 幇間"
"たいこやき 太鼓焼"
"たいご 大語 隊伍 対語 大悟 タイ語"
"たいごう 対合"
"たいごく 大獄"
"たいさ 大佐 大差"
"たいさい 体菜 太歳 大才 大祭"
"たいさいじつ 大祭日"
"たいさいぼう 体細胞"
"たいさく 大作 対策"
"たいさつ 大冊"
"たいさなし 大差無"
"たいさん 耐酸 退散"
"たいさんこう 耐酸鋼"
"たいざ 対坐 胎座 退座 対座"
"たいざい 大罪 滞在"
"たいざいがたりょこう 滞在型旅行"
"たいざん 鯛山 岱山 太山 大山 泰山"
"たいし 対し 太始 大史 太史 大志 大師 太子 大使"
"たいしきちょう 太食調"
"たいしこう 太史公"
"たいした 大した"
"たいしつ 対質 耐湿 退室 体質"
"たいして 大して"
"たいしぼう 体脂肪"
"たいしゃ 代赭 対者 大赦 大社 退社 代謝"
"たいしゃく 帝釈 貸借"
"たいしゃくきょう 帝釈峡"
"たいしゃくてん 帝釈天"
"たいしゃづくり 大社造"
"たいしゅ 対手 大酒 太守"
"たいしゅう 対州 大周 体臭 大衆"
"たいしゅうかん 大修館"
"たいしゅうぎょ 大衆魚"
"たいしゅつ 体出 貸出 帯出 退出"
"たいしょ 台書 対蹠 太初 大所 大暑 大書 退所 対処"
"たいしょう 胎生 大詔 大捷 隊商 対症 大笑 大勝 対称 対照 大将 大賞 大正 対象"
"たいしょういけ 大正池"
"たいしょうごと 大正琴"
"たいしょうやど 隊商宿"
"たいしょく 耐蝕 耐食 褪色 大食 退色 体色 退職"
"たいしょくかん 大食漢"
"たいしょせい 耐暑性"
"たいしん 太信 大身 大震 大信 対審 対震 耐震"
"たいしんりっぽうこうし 体心立方格子"
"たいじ 胎仔 帯磁 泰二 泰次 泰司 大治 太地 対自 対峙 胎児 退治"
"たいじく 体軸"
"たいじゅ 大儒 大樹"
"たいじゅう 体重"
"たいじゅく 退塾"
"たいじゅつ 体術"
"たいじゅん 泰淳"
"たいじゅんかん 体循環"
"たいじょう 帯状 退場"
"たいじん 泰人 タイ人 大人 対陣 退陣 対人"
"たいすい 退水 大酔 大水 耐水"
"たいすう 大数 対数"
"たいすうのほうそく 大数の法則"
"たいすけ 泰佑 泰祐 退助 泰介"
"たいする 対する"
"たいずし 鯛鮨"
"たいせい 体性 大声 頽勢 退勢 泰西 大青 胎生 対生 大政 大聖 大勢 体勢 耐性 態勢 大成 体制"
"たいせいぎょ 胎生魚"
"たいせいどう 大盛堂"
"たいせいよう 大西洋"
"たいせいようがん 大西洋岸"
"たいせき 対席 堆石 大石 滞積 対蹠 退席 堆積 体積"
"たいせきがん 堆積岩"
"たいせつ 体節 大雪 大切"
"たいせつさ 大切さ"
"たいせん 大戰 大船 苔癬 対潜 大戦 対戦"
"たいせんげーむ 対戦ゲーム"
"たいせんちゅうるい 苔蘚虫類"
"たいぜい 大勢"
"たいぜん 泰然 大全"
"たいぜんくつ 体前屈"
"たいそ 太祖"
"たいそう 太簇 大葬 大喪 太宗 大宗 大層 体操"
"たいそうのれい 大喪の礼"
"たいそく 大息 体側"
"たいそしき 体組織"
"たいぞう 太造 諦三 大造 大蔵 泰蔵 泰造 泰三 胎蔵 退蔵"
"たいた 対他"
"たいだ 怠惰"
"たいだん 退団 対談"
"たいち 多一 太一 対地 対置"
"たいちゅう 台中 対中"
"たいちょ 大著"
"たいちょう 退潮 退庁 体長 隊長 体調"
"たいちよう 退治用"
"たいてい 退廷 大帝 大抵"
"たいてき 対敵 大敵"
"たいてろ 対テロ"
"たいてん 退転 大典 退店"
"たいでん 帯電"
"たいと 大都 泰斗"
"たいとう 体当 頽唐 駘蕩 台糖 擡頭 対当 帯刀 台東 台頭 対等"
"たいとく 大徳 体得"
"たいとるせん タイトル戦"
"たいど 胎土 大度 態度"
"たいどう 帯同 胎動"
"たいどく 胎毒"
"たいどる 対ドル"
"たいない 隊内 対内 胎内 体内"
"たいなん 台南"
"たいにし 対西"
"たいにち 滞日 対日"
"たいにん 体認 大任 退任"
"たいねつ 耐熱"
"たいねつがらす 耐熱ガラス"
"たいねん 耐年"
"たいのう 怠納 滞納"
"たいは 大破"
"たいはい 頽廢 大盃 頽廃 退廃 大敗"
"たいはく 太白"
"たいはくせい 太白星"
"たいはん 大藩 大半"
"たいばつ 体罰"
"たいばん 胎盤"
"たいひ 貸費 待避 退避 堆肥 対比"
"たいひごう 待避壕"
"たいひつとくしょ 大筆特書"
"たいひょう 体表"
"たいびょう 大病"
"たいびょうせい 耐病性"
"たいふ 大輔 大夫"
"たいふう 颱風 台風"
"たいふうせい 耐風性"
"たいふく 太腹 大腹 大幅"
"たいぶ 退部 体部 大部"
"たいぶつ 対物"
"たいぶつれんず 対物レンズ"
"たいぶん 大分"
"たいぶんすう 帯分数"
"たいへい 大平 大兵 泰平 太平"
"たいへいざん 太平山"
"たいへいよう 太平洋"
"たいへいらく 太平楽"
"たいへん 大篇 大編 対辺 大変"
"たいべい 滞米 対米"
"たいべつ 大別"
"たいべん 胎便 大弁"
"たいぺい 台北"
"たいほ 退歩 逮捕"
"たいほう 大鵬 大峰 大宝 大豊 大砲"
"たいほうぐん 帯方郡"
"たいほく 台北"
"たいぼ 太母"
"たいぼう 体貌 耐乏 大望 待望"
"たいぼく 大木"
"たいま 対馬 当麻 大麻"
"たいまい 玳瑁 タイ米 大枚"
"たいまつ 松明"
"たいまん 怠慢"
"たいみつ 台密"
"たいむ 隊務"
"たいめい 泰明 岱明 待命 台命 大命"
"たいめいがっき 体鳴楽器"
"たいめし 鯛飯"
"たいめん 泰緬 体面 対面"
"たいもう 大望 大網 体毛"
"たいや 逮夜"
"たいやき 鯛焼"
"たいやく 大厄 大約 大役 対訳"
"たいゆーろ 対ユーロ"
"たいゆう 大邑 大勇 大雄"
"たいよ 貸与"
"たいよう 大陽 太洋 大用 耐用 大要 体用 態様 大洋 太陽"
"たいようけいしょうてんたい 太陽系小天体"
"たいようこう 太陽光"
"たいようしん 太陽神"
"たいよく 大欲"
"たいら 平ら 平"
"たいらか 平らか"
"たいらがい 平貝"
"たいらのかねもり 平兼盛"
"たいらのきよもり 平清盛"
"たいらのまさかど 平将門"
"たいらん 頽瀾 台覧 大乱"
"たいり 大利"
"たいりく 大陸"
"たいりくだな 大陸棚"
"たいりつ 対立"
"たいりゃく 大略"
"たいりゅう 対流 滞留"
"たいりょ 大呂"
"たいりょう 大猟 退寮 大漁 大量"
"たいりょうばた 大漁旗"
"たいりょうぶし 大漁節"
"たいりょうり タイ料理"
"たいりょく 耐力 体力"
"たいりょくかべ 耐力壁"
"たいりん 台臨 大倫 大輪"
"たいるい 苔類"
"たいるばり タイル貼り タイル張り"
"たいれい 胎齢 耐冷 大礼"
"たいれつ 隊列"
"たいろ 対露 退路"
"たいろう 大老"
"たいろん 対論"
"たいわ 対和 大和 対話"
"たいわん 台湾"
"たいん 多淫"
"たう Τ τ 多雨"
"たうえ 田上 田植え 田植"
"たうた 田歌"
"たうち 田打ち 田内"
"たうら 田浦"
"たうりゅうし τ粒子"
"たうんし タウン誌"
"たえ 栲 妙"
"たえこ 多恵子 妙子"
"たえず 絶えず"
"たえだえ 絶え絶え"
"たえて 絶えて"
"たえま 絶えま 当麻 絶え間"
"たお 嵶 垰 田尾"
"たおか 田岡"
"たおやか 嫋やか"
"たおやめ 手弱女"
"たおれ 倒れ"
"たか 孚 尭 嵩 亨 臣 崇 敬 孝 宇 貴 隆 任 尚 多価 多寡 高 鷹"
"たかあき 孝哲 学聡 貴昭 貴章 隆明 孝明"
"たかあし 高足"
"たかあしがに 高足蟹"
"たかあら 高荒"
"たかい 高井 他界"
"たかいし 高石"
"たかいずみ 高泉"
"たかいち 隆一 高市"
"たかいびき 高鼾"
"たかうじ 尊氏"
"たかうち 高内"
"たかえだ 高枝"
"たかお 鷹生 孚夫 貴朗 尚夫 崇夫 貴士 貴夫 高夫 貴生 貴男 貴雄 隆男 孝男 隆雄 高雄 孝夫 隆夫 孝雄 高尾"
"たかおか 高岳 高丘 高岡"
"たかおざん 高尾山"
"たかか 多花果"
"たかかげ 隆景"
"たかかず 剛和 剛一"
"たかかわ 高河"
"たかが 高が"
"たかがき 高垣"
"たかがみね 鷹峯"
"たかがり 鷹狩"
"たかき 孝紀 高樹 高来 高木"
"たかぎ 鷹木 都木 高来 喬木 高樹 高城 高木"
"たかぎし 高岸"
"たかぎわ 高際"
"たかく 高久 多角"
"たかくしょうじょう 他覚症状"
"たかくら 高蔵 高倉"
"たかくらけん 高倉健"
"たかくわ 高鍬 高桑"
"たかこ 堂子 多賀子 高子 敬子 隆子 多香子 孝子 貴子"
"たかこう 高高"
"たかさ 高さ"
"たかさか 高坂"
"たかさき 高崎"
"たかさご 高砂"
"たかさと 高郷"
"たかさわ 高澤 高沢"
"たかざわ 高沢"
"たかし 多加史 恭士 隆資 尚司 岳史 敬史 敬士 卓史 高司 高師 隆士 高士 貴士 尚史 高史 孝史 洪 崇 卓 貴 敬 尚 高 大 孝 隆 崇史 尚志 貴司 孝志 孝司 貴史 貴志 喬 隆司 隆史 隆志 高志 鷹師"
"たかしお 高汐 高潮"
"たかしな 高品 高科"
"たかしま 鷹島 高嶋 高島"
"たかしまだいら 高島平"
"たかしろ 鷹城 高城"
"たかじょう 高城 鷹匠"
"たかす 高須 鷹栖 高鷲"
"たかすぎ 高杉"
"たかすみ 高住"
"たかずみ 敬済"
"たかせ 高瀬"
"たかせい 多花性"
"たかせぶね 高瀬舟"
"たかた 田方 高田"
"たかだ 高田"
"たかだい 高台"
"たかだか 高々"
"たかだて 高館"
"たかだま 高玉"
"たかちほきょう 高千穂峽 高千穂峡"
"たかちほのみね 高千穂峰"
"たかつ 高津"
"たかつか 高塚"
"たかつかさ 鷹司"
"たかつき 高坏 高月 高槻"
"たかつぐ 高嗣"
"たかて 高手"
"たかとう 高藤 高遠"
"たかとうりき 貴闘力"
"たかとお 高遠"
"たかとき 高時"
"たかとし 孝寿 隆利 孝利 孝俊 隆俊"
"たかとび 高跳び"
"たかとみ 孝富 高富"
"たかとも 鷹友"
"たかとり 高鳥 高取"
"たかとりこうじょう 鷹取工場"
"たかとりやき 高取焼"
"たかどの 楼 高殿"
"たかな 高菜"
"たかなお 高尚 高直"
"たかなか 高中"
"たかなし 小鳥遊 高梨"
"たかなべ 高鍋"
"たかなみ 高浪 高波"
"たかなわ 高縄 高輪"
"たかに 高荷"
"たかにし 高西"
"たかね 高音 高根 高嶺 高値"
"たかねざわ 高根沢"
"たかねのはな 高嶺の花"
"たかねびけ 高値引け"
"たかの 高乃 鷹野 高野"
"たかのす 鷹の巣 鷹巣"
"たかのつめ 鷹の爪"
"たかのなみ 貴ノ浪"
"たかのは 鷹羽"
"たかのはな 貴ノ花"
"たかのはら 高の原"
"たかのばし タカノ橋"
"たかのふじ 孝乃富士"
"たかのぶ 敬信 貴信 孝信"
"たかのり 敬則 孝規 敬典 崇徳 隆典 孝憲 孝典 高徳 孝徳 隆則 孝則"
"たかは 鷹派 高羽 タカ派"
"たかはぎ 高萩"
"たかはし 高梁 高橋"
"たかはしこれきよ 高橋是清"
"たかはしでいしゅう 高橋泥舟"
"たかはしみちつな 高橋三千綱"
"たかはしゆいち 高橋由一"
"たかはた 高畑 高畠"
"たかはたふどう 高幡不動"
"たかはな 高花 高鼻"
"たかはなだ 貴花田"
"たかはま 高濱 高浜"
"たかはまきょし 高浜虚子"
"たかはら 高原"
"たかはる 高春 高原"
"たかば 高場"
"たかばた 高機"
"たかばたけ 高畠"
"たかばなし 高話"
"たかばやし 高林"
"たかひく 高低"
"たかひこ 高彦 孝彦 貴彦 隆彦"
"たかひさ 高尚 隆久 貴久"
"たかひで 貴英"
"たかひと 隆人 隆仁 貴仁"
"たかひら 高平"
"たかひろ 隆啓 敬弘 高裕 崇博 高宏 孝洋 貴宏 隆広 隆寛 隆浩 孝広 貴浩 貴広 高広 孝宏 孝浩 貴大 貴博 隆宏 隆博 貴裕 隆弘"
"たかふだ 高札"
"たかふみ 孝史 孝文 貴史 貴文 隆史 隆文"
"たかべ 高部"
"たかまがはら 高天原"
"たかまくら 高枕"
"たかまさ 隆征 隆政 高政 孝昌 孝政"
"たかまつ 高松"
"たかまつづかこふん 高松塚古墳"
"たかまつのみや 高松宮"
"たかまつのみやはい 高松宮盃"
"たかまど 高窓"
"たかまどのみや 高円宮"
"たかまのはら 高天原"
"たかまる 鷹丸"
"たかみ 孝美 高み 高見"
"たかみくら 高御座"
"たかみさわ 高見沢"
"たかみざわ 高見沢"
"たかみす 高見州"
"たかみすぎ 隆三杉"
"たかみず 高水"
"たかみち 尊道 孝通 隆道"
"たかみつ 隆充 貴光"
"たかみね 嵩嶺 高嶺 高峰"
"たかみねじょうきち 高峰譲吉"
"たかみや 高宮"
"たかむこのくろまろ 高向玄理"
"たかむしろ 簟"
"たかむね 高宗"
"たかむら 竹叢 高村 篁"
"たかむらこううん 高村光雲"
"たかむらものがたり 篁物語"
"たかめ 高め 高目"
"たかもと 高本"
"たかもり 高盛 鷹森 隆盛 高森"
"たかや 隆弥 隆也 高谷 高屋"
"たかやす 貴康 高安"
"たかやなぎ 高柳"
"たかやま 鷹山 高山"
"たかゆか 高床"
"たかゆき 能之 敬行 尊之 高幸 崇行 高之 高行 貴幸 崇之 敬之 貴行 孝幸 隆幸 孝行 隆行 隆之 貴之 孝之"
"たかよし 隆克 貴良 高好 孝佳 高良 隆吉 孝義 孝允 隆義"
"たから 寳 寶 財 宝"
"たからい 宝井"
"たからか 高らか"
"たからがい 宝貝"
"たからがいけ 宝が池"
"たからくじ 宝くじ"
"たからさがし 宝探し"
"たからしゅぞう 寳酒造 宝酒造"
"たからじま 宝島"
"たからずか 宝塚"
"たからずかきねんば 宝塚記念馬"
"たからだ 宝田"
"たからだま 宝玉"
"たからづか 宝塚"
"たからづかきねんば 宝塚記念馬"
"たからばこ 宝箱"
"たからぶね 宝船"
"たからべ 財部"
"たからまち 宝町"
"たからもと 宝本"
"たからもの 宝物"
"たかん 多環 多感"
"たかんしょう 多汗症"
"たが 多賀 他我 箍"
"たがい 違い 互 互い"
"たがいせん 互い先 互先"
"たがいに 互いに"
"たがき 田垣"
"たがく 多額"
"たがしら 田頭"
"たがた 田方"
"たがね 鏨"
"たがひ 互 違ひ"
"たがみ 田上"
"たがや 多賀谷"
"たがらす 田烏"
"たがりゅう 多賀竜"
"たがろぐご タガログ語"
"たがわ 多川 田河 田川"
"たがん 多眼"
"たき 多喜 多紀 瀑 瀧 多岐 滝"
"たきあせ 滝汗"
"たきあわせ 炊き合せ 炊き合わせ"
"たきい 滝井"
"たきうち 瀧内 滝内"
"たきお 多喜夫 滝尾"
"たきかわ 瀧川 滝川"
"たきがわ 瀧川 滝川"
"たきぎ 焚き木 薪"
"たきぎのう 薪能"
"たきぐち 焚き口 瀧口 滝口"
"たきこみごはん 炊込みご飯"
"たきさわ 滝澤 滝沢"
"たきざわ 瀧沢 滝澤 滝沢"
"たきた 瀧田 滝田"
"たきたて 炊き立て"
"たきだ 瀧田"
"たきだし 炊出し 炊き出し"
"たきつけ 焚付け 焚き付け"
"たきつせ 滝つ瀬"
"たきつぼ 滝壺 滝壷"
"たきなみ 滝波"
"たきね 滝根"
"たきの 多喜乃 瀧野 滝野"
"たきはら 滝原"
"たきひろ 滝広"
"たきび 焚火 焚き火"
"たきもと 瀧本 滝本"
"たきもの 薫物 焚き物 焚物"
"たきや 滝谷"
"たきやま 瀧山 滝山"
"たきゅう 田久"
"たきょう 他郷 田京"
"たきょく 多極 他局"
"たきれんたろう 滝廉太郎"
"たぎ 多義"
"たぎょう た行 タ行"
"たぎり 田切"
"たく 柘 度 魄 謫 磔 啅 倬 拆 柝 琢 啄 戳 擢 濯 澤 沢 鈬 鐸 擇 択 托 託 拓 多久 卓 宅"
"たくあき 卓明"
"たくあつかい 宅扱い"
"たくあん 沢庵"
"たくい 宅井"
"たくいつ 択一"
"たくえつ 卓越"
"たくお 拓雄 卓雄 卓夫"
"たくき 琢己"
"たくけい 磔刑"
"たくげん 託言"
"たくさい 卓才"
"たくさり 田鎖"
"たくさん 沢山"
"たくし 托子 度支 卓史 拓志 卓子"
"たくしき 卓識"
"たくしゅつ 卓出"
"たくしょ 謫所"
"たくしょう 托生"
"たくしょく 拓殖"
"たくしろう 卓四郎"
"たくしん 託身 宅診"
"たくじ 琢爾 拓嗣 拓史 卓爾 卓治 卓司 託児"
"たくじょう 卓上"
"たくじょうかれんだー 卓上カレンダー"
"たくじょうち 卓状地"
"たくせつ 卓説"
"たくせん 託宣"
"たくぜつ 卓絶"
"たくそう 拓宋 託送"
"たくぞう 卓造 卓三"
"たくだいいちこう 拓大一高"
"たくち 宅地"
"たくちたてものとりひきぎょうほう 宅地建物取引業法"
"たくちなみかぜい 宅地並課税"
"たくと 琢人"
"たくないよう 宅内用"
"たくはい 宅配"
"たくはつ 托鉢"
"たくばつ 択抜 卓抜"
"たくふ 卓布"
"たくほん 拓本"
"たくぼ 田窪 田久保"
"たくぼく 啄木"
"たくま 託間 宅間 詫間 琢磨"
"たくみ 巧み 琢弥 琢美 琢巳 卓己 拓美 内匠 拓海 巧 匠"
"たくみのかみ 内匠頭"
"たくや 卓弥 卓哉 琢也 卓也 拓哉 拓也"
"たくよう 托葉"
"たくら 田倉"
"たくらく 拓落"
"たくらみ 企み"
"たくらん 托卵"
"たくりつ 卓立"
"たくろう 卓朗 拓郎"
"たくろうしょ 託老所 宅老所"
"たくろく 宅録"
"たくろん 卓論"
"たくわえ 貯え 蓄え"
"たくわん 沢庵"
"たぐい 畴 疇 類い 類"
"たぐいまれ 類い稀 類稀"
"たぐうち タグ打ち"
"たぐす 田楠"
"たぐち 田口"
"たぐり 田栗"
"たぐん 多群"
"たけ 斌 威 毅 雄 健 武 他家 嶽 岳 茸 丈 竹"
"たけい 他系 竹居 多形 武居 竹井 武井 多型"
"たけいし 武石"
"たけいち 武一 竹市 武市"
"たけうち 武内 竹内"
"たけうま 竹馬"
"たけお 丈生 武朗 岳生 竹夫 岳男 竹男 竹雄 毅雄 竹生 威雄 健生 健郎 竹尾 健夫 武男 丈夫 武夫 武雄"
"たけおか 竹岡"
"たけかご 竹籠"
"たけかず 丈和"
"たけかわ 竹河 武川 竹川"
"たけかんむり 竹冠"
"たけがき 竹垣"
"たけがた 竹形"
"たけがはら 竹ヶ原"
"たけがり 茸狩"
"たけがわ 竹河"
"たけき 健樹"
"たけくに 武邦"
"たけくらべ 丈比べ"
"たけぐし 竹串"
"たけぐち 竹口"
"たけこ 武子"
"たけこし 竹腰 竹越"
"たけさか 竹坂"
"たけざいく 竹細工"
"たけざお 竹竿"
"たけざき 竹崎"
"たけざわ 竹沢 竹澤"
"たけし 毅之 毅史 威志 竹志 丈司 武嗣 武石 岳史 健史 健志 丈史 剛史 武司 武史 武志 威 剛志 武士 英 岳 毅 豪 猛 剛 健 武"
"たけした 竹下"
"たけしたのぼる 竹下登"
"たけしば 竹芝"
"たけしま 武島 竹島"
"たけしょぼう 竹書房"
"たけじ 武治"
"たけじろう 竹次郎"
"たけすえ 武居"
"たけすだれ 竹簾"
"たけぞえ 竹添"
"たけぞの 竹園"
"たけた 竹田"
"たけたに 竹谷"
"たけだ 竹田 武田"
"たけだのみや 竹田宮"
"たけち 武智 武市"
"たけつ 多血"
"たけつぐ 健嗣"
"たけづつ 竹筒"
"たけと 竹人 丈人 健人 岳人"
"たけとし 壮聡 武俊"
"たけとみ 武富 竹富"
"たけとも 斌友"
"たけとよ 武豊"
"たけとり 竹取"
"たけとりのおきな 竹取翁"
"たけとんぼ 竹蜻蛉 竹トンボ 竹とんぼ"
"たけなお 武直"
"たけなか 武中 竹中"
"たけなが 丈長"
"たけなみ 竹並"
"たけなり 丈成 雄成"
"たけなわ 武縄 竹縄 闌 酣"
"たけの 武野 竹野"
"たけのうち 竹之内 竹内"
"たけのこ 笋 筍 竹の子"
"たけのこめし 筍飯"
"たけのだい 竹の台"
"たけのはま 竹野浜"
"たけのぶ 健伸 武信"
"たけのり 健雅 武範 武憲"
"たけはし 竹橋"
"たけはな 竹花"
"たけはら 武原 竹原"
"たけはる 毅治 丈晴"
"たけばし 竹箸 竹橋"
"たけばやし 竹林"
"たけひこ 建彦 竹彦 剛彦 毅彦 健彦 雄彦 武彦"
"たけひご 竹ひご 竹籤"
"たけひさ 竹久 武久"
"たけひで 武秀 武英"
"たけひと 雄人 武仁 武人"
"たけひら 竹平"
"たけひろ 毅寛 威博 武裕 雄洋 威裕 竹広 武大"
"たけふ 竹生 武生"
"たけふさ 竹房"
"たけふじ 武富士 武藤"
"たけふみ 武文"
"たけぶえ 竹笛"
"たけべ 竹部 武部 建部"
"たけべら 竹篦"
"たけぼうき 竹箒"
"たけまえ 竹前"
"たけまさ 竹政"
"たけまつ 竹松"
"たけみ 武三 武見"
"たけみつ 竹光 武満"
"たけみや 武宮 竹宮"
"たけむら 竹叢 竹群 武村 竹村"
"たけもち 威望"
"たけもと 武元 武本 竹本"
"たけもり 竹森"
"たけや 竹弥 武谷 竹屋"
"たけやぶ 竹薮"
"たけやま 武山 竹山"
"たけやり 武鑓 竹槍"
"たけゆき 岳之 健幸"
"たけよし 建美 武吉"
"たけん 他見 他県"
"たげい 多芸"
"たげん 他言 多言 多元"
"たこ 胝 鱆 鮹 章魚 多古 胼胝 凧 蛸"
"たこあげ 凧揚げ"
"たこあし 蛸足 タコ足"
"たこいと 凧糸"
"たこう 多項 他行 多幸 多孔 他校"
"たこく 他国"
"たこくかん 多国間"
"たこじま 蛸島"
"たこなぐり タコ殴り"
"たこのきもく タコノキ目"
"たこべや 蛸部屋 タコ部屋"
"たこやき 蛸焼 タコ焼 たこ焼"
"たこん 多恨"
"たご 他語 多語 多湖 多胡 田子"
"たごう 田郷"
"たごさく 田吾作"
"たごのうら 田子の浦"
"たごん 多言 他言"
"たさい 多妻 多才 多彩"
"たさいと 他サイト"
"たさか 田坂"
"たさき 田崎"
"たさく 多作"
"たさつ 他殺"
"たさん 多産"
"たざ 打坐"
"たざい 多罪"
"たざいたいせい 多剤耐性"
"たざき 田崎"
"たざけ 田酒"
"たざわ 田澤 田沢"
"たざわこ 田沢湖"
"たざわぬま 田沢沼"
"たざん 他山"
"たざんのいし 他山の石"
"たし 多肢 多死 多指 多士 足し 他紙 他誌"
"たしか 慥か 確か"
"たしき 多識"
"たしさいさい 多士済済 多士済々"
"たしざん 足算 足し算"
"たしつ 咤叱 多湿"
"たしなみ 嗜み"
"たしま 田嶋"
"たしゃ 他車 多謝 他社 他者"
"たしゃく 他借"
"たしゅ 他種 多種"
"たしゅう 他州 他宗"
"たしゅせんゆう 他主占有"
"たしゅつ 他出"
"たしょ 他書 他諸 他所"
"たしょう 多祥 多生 他生 他称 多少"
"たしょうなん 多少難"
"たしょく 多食 多色"
"たしょくずり 他色刷 多色刷 多色刷り"
"たしろ 田代"
"たしん 他心 多芯"
"たしんきょう 多神教"
"たしんろん 多神論"
"たじ 多事 他事"
"たじか 田近"
"たじつ 他日"
"たじま 田嶌 田嶋 田島 但馬"
"たじみ 多治見"
"たじめ 田治米"
"たじゅう 多汁 多重"
"たじゅうこ 多重呼"
"たじょう 多情"
"たじり 田尻"
"たじん 多人"
"たす ＋ 足す"
"たすう 多数"
"たすうけつ 多数決"
"たすき 襷"
"たすきがけ 襷掛け"
"たすきぞり 襷反り"
"たすく 弼 匡 輔 相 佑"
"たすけ 多助 太助 助け"
"たすけあい 助け合い"
"たすけぶね 助け船"
"たず 田鶴"
"たずき 活計 方便"
"たずな 手綱"
"たずね 尋ね"
"たずねびと 尋ね人"
"たせい 多声"
"たせきてき 他責的"
"たせん 多選 他薦"
"たぜい 多勢"
"たそ 誰そ"
"たそう 多相 多層"
"たそうこうぞうなべ 多層構造鍋"
"たそうなべ 多層鍋"
"たそがれ 黄昏"
"たそがれづき 黄昏月"
"たそがれどり 黄昏鳥"
"たそく 多足"
"たぞえ 田副 田添"
"たた 多々"
"たたい 田々井 田多井 多態 多体 多胎"
"たたいた 多対多"
"たたえ 湛え"
"たたかい 闘い 戦い"
"たたき 叩き 三和土"
"たたきいし 叩き石"
"たたきだい たたき台"
"たたすく 他タスク"
"たたずまい 佇まい"
"たたど 多々戸"
"たたに 田谷"
"たたません 田玉線"
"たたみ 疉 疂 疊 畳"
"たたみいわし 畳鰯"
"たたみおもて 畳表"
"たたみがえ 畳替え"
"たたみがみ 畳紙"
"たたみこみ 畳み込み"
"たたみじき 畳敷 畳敷き"
"たたみつき 畳付き 畳付"
"たたみてん 畳店"
"たたみはんぶん 畳半分"
"たたみばり 畳針"
"たたみべや 畳部屋"
"たたみま 畳間"
"たたみめ 畳み目 畳目"
"たたみもの 畳物"
"たたら 多田羅 多々良 蹈鞴 踏鞴"
"たたり 祟 祟り"
"たたん 多端 他端"
"ただ 惟 但 匡 忠 伊 維 直 正 無料 多田 只 唯"
"ただあき 理顕 忠明"
"ただい 他大 多大"
"ただいま 唯今 ただ今 只今"
"ただお 維男 忠男 忠雄 忠夫"
"ただおか 忠岡"
"ただおき 忠興"
"ただき 只木 但木"
"ただくま 只熊"
"ただけん タダ券 只券"
"ただごと 唯事 徒事 ただ事 只事"
"ただごとうた 徒言歌"
"ただし 正し 惟史 禎 匡 貞 是 忠 直 正 理 匡史 忠史 忠志 忠司 尚志 但し"
"ただしがき 但書き 但し書 ただし書き 但書"
"ただす 匡"
"ただすつかさ 弾正台"
"ただせん 太多線"
"ただたか 匡孝"
"ただただ 唯唯 只只 唯々 只々"
"ただちに 直ちに"
"ただとし 正利 忠利"
"ただなか ただ中 只中"
"ただの 唯野 只野"
"ただのぶ 忠信"
"ただのり 匡孝 忠則 忠度 只乗り"
"ただはる 忠治"
"ただばたらき タダ働き 只働き"
"ただひこ 伊彦 忠彦"
"ただひさ 正久"
"ただひら 忠平"
"ただひろ 忠浩 忠博 忠広 忠宏 忠弘"
"ただびと 徒人 直人 只人"
"ただふみ 能文 忠文"
"ただまさ 忠正"
"ただみ 只見"
"ただみち 直道 忠道"
"ただもと 忠元"
"ただもの 只者"
"ただゆき 忠幸 忠之 忠行"
"ただよし 忠央 忠儀 忠吉 忠良 忠義"
"ただれ 爛れ"
"ただわか 唯若"
"ただん 多段"
"たち 立ち 逹 舘 城 性質 多智 多知 多値 立 館 質 大刀 太刀 達"
"たちあい 立合 立ち合い 立会 立ち会い"
"たちあおい 立葵"
"たちあがり 立上り"
"たちあげ 起ち上げ"
"たちあらい 大刀洗"
"たちい 起ち居 立居 立ち居"
"たちいり 立入り 立入"
"たちうお 太刀魚"
"たちうち 立射ち"
"たちうり 立売"
"たちえり 立襟 立ち襟"
"たちおうじょう 立往生"
"たちおくれ 立ち後れ"
"たちかけ 太刀掛"
"たちかた 裁ち方"
"たちかわ 太刀川 立川"
"たちがみ 舘上"
"たちがれ 立枯れ 立ち枯れ"
"たちき 立木"
"たちぎ 立木"
"たちぎえ 立消え 立ち消え"
"たちぎき 立聞き 立ち聞き"
"たちくいやき 立杭焼"
"たちくらみ 立ち眩み"
"たちぐい 立食い 立ち食い"
"たちぐいそば 立ち食いそば"
"たちざわ 立澤 立沢"
"たちしょん 立ちション"
"たちじゃこうそう 立麝香草"
"たちすがた 立ち姿"
"たちせきとっきゅうけん 立席特急券"
"たちぬい 裁ち縫い"
"たちのうお 太刀の魚"
"たちのき 立ち退き"
"たちのきりょう 立退き料 立退料"
"たちのみ 立ち飲み"
"たちはら 立原"
"たちはらみちぞう 立原道造"
"たちば 立羽 立場"
"たちばさみ 裁ち鋏"
"たちばな 立花 橘"
"たちばなわん 橘湾"
"たちひ 立飛"
"たちまち 怱ち 立待ち 忽 立町 忽ち"
"たちまちづき 立待月"
"たちまわり 立回り"
"たちみ 立見 立ち見"
"たちめい 太刀銘"
"たちもち 太刀持"
"たちもの 裁ち物 断ち物"
"たちもり 館盛"
"たちや 達谷"
"たちやく 立役"
"たちやま 立山"
"たちよみ 立読み"
"たちわざ 立技"
"たちんぼう 立ちん坊"
"たっかん 達観"
"たっきゅう 宅急 卓球"
"たっきょ 謫居"
"たっけい 磔刑"
"たっけん 達見 卓見 宅建"
"たっこう 卓効"
"たっし 達し"
"たっしき 達識"
"たっしゃ 達者"
"たっせい 達成"
"たった 立田"
"たったいま たった今"
"たっちゅう 塔頭"
"たっぱ 立端"
"たっぴ 龍飛 竜飛"
"たっぴつ 達筆"
"たっぴみさき 竜飛岬"
"たつ 斬 闥 燵 韃 撻 逹 達 立 辰 竜 龍"
"たつあき 達明"
"たつい 達意"
"たついち 辰一"
"たつお 立雄 竜生 竜雄 竜夫 龍男 辰男 龍夫 龍雄 達郎 達男 辰雄 辰夫 達雄 達夫"
"たつおか 竜岡 龍岡 立岡"
"たつおき 辰興"
"たつかわ 達川 立川"
"たつき 活計 方便 立木"
"たつきち 辰吉"
"たつきよ 達清"
"たつくち 辰口"
"たつぐち 辰口"
"たつごう 竜郷"
"たつし 辰史 達史 達志"
"たつしま 立嶋"
"たつじ 辰司 辰二 龍司 達司 達治"
"たつじん 達人"
"たつせ 立つ瀬"
"たつた 立田 竜田 龍田"
"たつたか 辰敬"
"たつとし 達俊 達利"
"たつとり 立つ鳥"
"たつどし 辰年"
"たつなみ 立浪"
"たつなり 達就"
"たつにしき 龍錦"
"たつの 竜野 龍野 辰野"
"たつのくち 竜ノ口 辰口"
"たつのにし 竜野西"
"たつのひげ 竜の鬚"
"たつのり 辰範 達就 達徳 辰則 辰徳"
"たつひこ 達彦 龍彦"
"たつひろ 達弘"
"たつぶん 達文"
"たつべん 達弁"
"たつま 辰馬 竜馬"
"たつまき 竜巻"
"たつみ 竜実 辰爾 立見 辰己 辰巳 巽"
"たつや 立弥 立矢 立哉 辰哉 龍也 辰也 達哉 竜也 達也"
"たつやま 竜山 龍山"
"たつゆき 達行 達之"
"たつるはま 田鶴浜"
"たつろう 達朗 達郎"
"たつんど 達人"
"たづくり 手作り 田作り"
"たづこ 田鶴子"
"たづな 覊 手綱"
"たづら 田面"
"たて ┃ │ 縱 蓼 舘 館 建 立て 立 竪 経 殺陣 楯 盾 縦"
"たてあき 賢明"
"たてあな 縦穴 竪穴"
"たていし 建石 立石"
"たていた 立て板 立板"
"たていと 經 経 経糸 縦糸"
"たていわ 館岩"
"たてうち 館内 舘内"
"たてうま 立馬"
"たてうり 建売り 建て売り 建売"
"たてえぼし 立烏帽子"
"たてお 建郎 立夫 建夫"
"たておか 楯岡"
"たておき 縦置"
"たてかえ 立替え 立替 建替 建替え 建て替え"
"たてかた 建方 建て方"
"たてかわ 立川"
"たてかん 立て看 立看"
"たてかんばん 立看板"
"たてがた 竪型 縦型"
"たてがみ 鬣"
"たてき 建樹"
"たてぎょうじ 立行司"
"たてぎょく 建玉"
"たてぐ 建具"
"たてぐみ 縦組"
"たてけい 縦系"
"たてこう 竪坑 立坑"
"たてこし 館腰"
"たてごと 竪琴"
"たてさわ 立澤"
"たてざ 楯座"
"たてざん 竪桟"
"たてしお 立て塩 立塩"
"たてしな 立科 蓼科"
"たてしほうがため 縦四方固め"
"たてじく 縦軸"
"たてじま 縦縞"
"たてじょう 楯状"
"たてじわ 縦皺"
"たてすくろーる 縦スクロール"
"たてすじ 縦筋"
"たてずな 立砂"
"たてせん │ ｜ 縦線"
"たてだし 点出し"
"たてちゃ 立茶 点茶"
"たてつけ 建てつけ 立付け 建付け 建て付け 建付"
"たてつぼ 立坪 建坪"
"たてづめ 立て爪 立爪"
"たてどい 竪樋 縦樋"
"たてなおし 建て直し"
"たてなが 縦長"
"たてなみ 縦波"
"たてぬき 経緯"
"たてね 建値"
"たての 館野 舘野 立野"
"たてはば 縦幅"
"たてはら 立原"
"たてばい 縦倍"
"たてばやし 館林"
"たてひこ 建彦"
"たてひざ 立て膝"
"たてふ 縦歩"
"たてふだ 立札 立て札"
"たてぶえ 竪笛 縦笛"
"たてべ 建部"
"たてほり 縦堀"
"たてぼう │ ｜ 縦棒"
"たてまえ 立前 点前 建て前 建前"
"たてまさ 建正"
"たてまし 建増し 建て増し"
"たてまち 立町"
"たてまつ 立松"
"たてむら 舘村"
"たてめ 縦目"
"たてもの 建物"
"たてや 建家 建屋"
"たてやくしゃ 立役者"
"たてやま 楯山 立山 館山"
"たてやまでらおんせん 舘山寺温泉"
"たてよこ 縦横"
"たてわき 帯刀"
"たてわりぎょうせい 縦割行政"
"たてん 多点 他店"
"たで 蓼"
"たでか タデ科"
"たでず 蓼酢"
"たでもく タデ目"
"たと 田刀 田堵"
"たとう 多党 多投 他党 多頭"
"たとうかい 多島海"
"たとうがみ 畳紙"
"たとうたい 多糖体"
"たとえ 縦令 仮令 縦 譬え 喩え 例え"
"たとえうた 喩え歌 譬え歌"
"たとえごと 譬え言"
"たとえづくし 譬喩尽"
"たとえば 例えば"
"たとへば 例へば"
"たとみ 田富"
"たど 多度"
"たどう 他動"
"たどく 多読"
"たどころ 田所"
"たどつ 多度津"
"たどん 炭団"
"たな 店 棚"
"たなあげ 棚上げ"
"たなあみ 田名網"
"たないけ 種池"
"たないた 棚板"
"たなうえ 棚上"
"たなえ 田苗"
"たなおろし 店卸し 店卸 棚卸し 棚卸"
"たなおろししさん たな卸資産"
"たなか 田仲 田中"
"たなかきぬよ 田中絹代"
"たなかだて 田中館"
"たなき 棚木"
"たなくら 棚倉"
"たなぐも 棚雲"
"たなぐら 棚倉"
"たなこ 店子"
"たなごおり 棚氷"
"たなごころ 掌"
"たなさき 手先 店前"
"たなざらし 棚晒し 店晒し"
"たなざわ 棚沢"
"たなし 田無"
"たなそこ 手底"
"たなだ 棚田"
"たなちん 店賃"
"たなはし 棚橋"
"たなばた 七夕"
"たなばただけ 七夕竹"
"たなばたまつり 七夕祭"
"たなべ 田邉 田辺"
"たなべはじめ 田辺元"
"たなぼた 棚ボタ 棚ぼた 棚牡丹"
"たなみ 棚見"
"たなもの 店者"
"たなわ 手縄"
"たなん 多難"
"たに 峪 溪 谿 渓 谷"
"たにあい 谷間"
"たにあし 谷脚"
"たにい 溪井 谷井"
"たにうち 谷内"
"たにえ 谷江"
"たにえき 谷駅"
"たにおおつか 谷大塚"
"たにおか 谷岡"
"たにおり 谷折り"
"たにかぜ 谷風"
"たにかわ 谷川"
"たにがき 谷垣"
"たにがみ 谷上"
"たにがわ 谿 谷側 谷川"
"たにがわがん 谷川雁"
"たにく 多肉"
"たにくけい 多肉茎"
"たにぐち 谷口"
"たにぐみ 谷汲"
"たにごえ 谷越え"
"たにざき 谷崎"
"たにざわ 谷沢"
"たにし 田螺"
"たにしげ 谷繁"
"たにじま 谷島"
"たにすじ 谷筋"
"たにせ 谷瀬"
"たにぞこ 谷底"
"たにた 谷田"
"たにだ 谷田"
"たになか 谷中"
"たにの 谷野"
"たにはら 谷原"
"たにふじ 谷藤"
"たにま 渓間 谷間"
"たにまち 谷町"
"たにまちきゅうちょうめ 谷町九丁目"
"たにみず 谷水"
"たにむら 谷村"
"たにもと 谷本"
"たにやま 谷山"
"たにょう 多尿"
"たにわき 谷脇"
"たにん 他人"
"たにんどんぶり 他人丼"
"たぬき 田貫 貍 狸"
"たぬきうどん 狸饂飩"
"たぬきおしょう 狸和尚"
"たぬきおやじ 狸親父"
"たぬきこうじ 狸小路"
"たぬきざか 狸坂"
"たぬきじる 狸汁"
"たぬきそば 狸蕎麦"
"たぬきねいり 狸寝入り"
"たぬきばばあ 狸婆"
"たぬきばやし 狸囃子"
"たぬし 田主"
"たぬま 田沼"
"たぬまおきつぐ 田沼意次"
"たね 多根 種子 胤 種"
"たねあかし 種明し 種明かし"
"たねあき 種明"
"たねあぶら 種油"
"たねい 種井"
"たねいた 種板"
"たねいち 種市"
"たねいも 種芋"
"たねうし 種牛"
"たねうま 種馬"
"たねおみ 種臣"
"たねかわ 種川"
"たねがしま 種子島"
"たねぎれ 種切れ"
"たねごえ 種肥"
"たねせん 種銭"
"たねだ 種田"
"たねつけ 種付け"
"たねつけりょう 種付料"
"たねとし 種敏"
"たねとり 種取り"
"たねなし 種無し"
"たねばん 種板"
"たねび 種火"
"たねほん 種本"
"たねまき 種まき 種播き 種蒔き"
"たねむら 種村"
"たねもの 種物"
"たねもみ 種籾"
"たねん 他念 他年 多年"
"たねんそう 多年草"
"たの 多野 田野 他の"
"たのう 多能"
"たのうえ 田上"
"たのうら 田浦"
"たのかみ 田の神"
"たのしさ 愉しさ 楽しさ"
"たのしみ 愉しみ 楽しみ"
"たのなか 田野中"
"たのはた 田野畑"
"たのみごと 頼み事"
"たのみのつな 頼みの綱"
"たのもし 頼もし 頼母子"
"たのもしこう 頼母子講"
"たはた 田畑"
"たはつ 多発"
"たはら 田原"
"たば 田場 他馬 束"
"たばい 多売"
"たばこ 莨 煙草"
"たばこぜい たばこ税"
"たばこぼん 煙草盆"
"たばた 太幡 田端 田畑"
"たばつてき 他罰的"
"たばね 束ね"
"たばねがみ 束ね髪"
"たばねばしら 束ね柱"
"たばやま 丹波山"
"たばら 田原"
"たばる 田原"
"たばるざか 田原坂"
"たひら 田平"
"たび 足袋 旅 度"
"たびかせぎ 旅稼ぎ"
"たびがらす 旅鴉 旅烏"
"たびげいにん 旅芸人"
"たびこうぎょう 旅興行"
"たびごころ 旅心"
"たびごろも 旅衣"
"たびさき 旅先"
"たびじ 旅路"
"たびじたく 旅支度"
"たびすがた 旅姿"
"たびそう 旅僧"
"たびたび 度度 度々"
"たびだち 旅立ち"
"たびづかれ 旅疲れ"
"たびどり 旅鳥"
"たびのそら 旅の空"
"たびびと 旅人"
"たびまわり 旅回り"
"たびょう 多病"
"たびら 田平"
"たびらこ 田平子"
"たふ 佗負 多夫"
"たぶ 椨 他部"
"たぶーし タブー視"
"たぶさ 髻"
"たぶせ 田布施"
"たぶち 田淵 田渕"
"たぶつ 他物"
"たぶね 田舟"
"たぶのき 椨"
"たぶふ タブ譜"
"たぶろいどし タブロイド紙"
"たぶろいどばん タブロイド判"
"たぶん 他聞 多聞 多分"
"たぶんわたし 多分私"
"たべ 多辺 田部"
"たべあるき 食べ歩き"
"たべあわせ 食べ合せ 食べ合わせ"
"たべおさめ 食べ納め"
"たべかた 食べ方"
"たべごたえ 食べ応え"
"たべごろ 食べ頃"
"たべざかり 食べ盛り"
"たべすぎ 食べ過ぎ"
"たべずぎらい 食べず嫌い"
"たべで 食べ出"
"たべのこし 食べ残し"
"たべほうだい 食べ放題"
"たべもの 食物 食べ物"
"たべん 多弁"
"たほう 多峰 多方 他方"
"たほうにょらい 多宝如来"
"たぼ 髱"
"たぼう 多望 多忙"
"たま 靈 彈 田万 珪 適 偶 霊 珠 多摩 弾 球 玉"
"たまい 玉井"
"たまいし 玉石"
"たまいれ 玉入れ"
"たまえ 玉恵 玉江"
"たまお 玉緒"
"たまおき 玉置"
"たまかがみ 玉鏡"
"たまかけ 玉掛け 玉掛"
"たまかし 玉柏"
"たまかしき 玉貸機"
"たまかず 玉数"
"たまかずら 玉鬘"
"たまかわ 玉川"
"たまがき 玉垣"
"たまがわ 玉川"
"たまがわさきこ 玉川紗己子"
"たまき 玉城 玉置 玉木 環"
"たまきず 弾傷"
"たまぎぬ 玉衣"
"たまぎれ 弾切れ"
"たまくしげ 玉櫛笥"
"たまぐしりょう 玉串料"
"たまぐすく 玉城"
"たまこ 多摩湖"
"たまこし 玉越"
"たまご 玉子 卵"
"たまごいろ 卵色"
"たまごがた 卵型 卵形"
"たまごがら 卵殻"
"たまごごはん 卵ご飯"
"たまござけ 卵酒"
"たまごとじ 卵綴じ 卵とじ"
"たまごどうふ 卵豆腐"
"たまごどん 卵丼"
"たまごどんぶり 卵丼 玉子丼"
"たまごはだ 卵肌"
"たまごまき 玉子巻 卵巻き 卵巻"
"たまごやき 卵焼 卵焼き"
"たまごりょうり 卵料理"
"たまごるい 卵類"
"たまごろも 玉衣"
"たまさか 適さか 偶さか"
"たまさきじんじゃ 玉前神社"
"たまさと 玉里"
"たまさぶろう 玉三郎"
"たましい 魄 魂"
"たましま 玉島"
"たまじゃり 玉砂利"
"たますじ 玉筋 球筋"
"たますだれ 玉簾"
"たまずさ 玉梓"
"たまたいしょう 玉大賞"
"たまたま 適 偶々 偶"
"たまだ 玉田"
"たまち 田町"
"たまつき 球撞き 玉撞き 玉突 玉突き"
"たまつくり 玉造り 玉作 玉造"
"たまつしま 玉津島"
"たまつつみ 玉堤"
"たまつばき 玉椿"
"たまづつみ 玉堤"
"たまてばこ 玉手箱"
"たまで 玉手"
"たまど 玉戸"
"たまな 玉名"
"たまなわ 玉那覇 玉縄"
"たまに 偶に"
"たまにきず 玉に瑕"
"たまねぎ 玉ネギ 玉ねぎ 玉葱"
"たまの 玉野"
"たまのあせ 玉の汗"
"たまのい 玉井"
"たまのうてな 玉の台"
"たまのうら 玉之浦"
"たまのお 玉の緒"
"たまのおぐし 玉の小櫛"
"たまのこし 玉の輿"
"たまのり 玉乗り"
"たまはがね 玉鋼"
"たまはし 玉橋"
"たまはら 玉原"
"たまばはき 玉箒"
"たまひめ 玉姫"
"たまひろい 球拾い"
"たまぶくろ 玉袋"
"たまぶさ 玉総"
"たまぶち 玉縁"
"たまほ 玉穂"
"たまほり 玉堀"
"たままき 玉牧"
"たままつり 霊祭 魂祭"
"たままゆ 玉繭"
"たまみ 珠美"
"たまみず 玉水"
"たまみそ 玉味噌"
"たまむし 玉虫"
"たまむら 玉村"
"たまもと 玉本"
"たまもの 賚 賜 賜物"
"たまものまえ 玉藻前"
"たまや 玉屋"
"たまやま 玉山"
"たまゆ 玉湯"
"たまゆら 玉響"
"たまよ 多満代 たま代"
"たまよけ 弾除け"
"たまらない 堪らない"
"たまり 玉利 玉里 澑 溜"
"たまりじょうゆ 溜まり醤油"
"たまりば 溜り場 たまり場 溜まり場"
"たまる 田丸"
"たまれいえん 多磨霊園"
"たみ 多美 民"
"たみあき 民朗"
"たみえ 民江"
"たみお 民男 民雄 民夫 民生"
"たみおか 民岡"
"たみき 民喜"
"たみくさ 民草"
"たみこ たみ子"
"たみのつかさ 民部省"
"たみや 田宮"
"たみるご タミル語"
"たむけ 手向け"
"たむし 田虫"
"たむら 屯 党 田邑 田村"
"たむろ 屯"
"たむろじょ 屯所"
"ため 爲 澑 溜 溜め 為"
"ためいき ため息 溜め息 溜息"
"ためいけ 溜め池 ため池 溜池"
"ためうち 溜め撃ち"
"ためがき 為書き 為書"
"ためきよ 為清"
"ためぐち タメ口"
"ためし 樣 様 例 試し"
"ためしげ 爲成"
"ためしざん 試し算"
"ためつすがめつ 矯めつ眇めつ"
"ためなが 為永"
"ために 為に"
"ためひろ 為広"
"ためらい 躊躇い"
"ためらいきず 躊躇い傷"
"ためん 多面 他面"
"たも 玉網"
"たもうさく 多毛作"
"たもうしょう 多毛症"
"たもうるい 多毛類"
"たもがわ 田茂川"
"たもくてきほーる 多目的ホール"
"たもつ 保"
"たもと 田本 袂"
"たもり 田森 田守"
"たもろこ 田諸子"
"たもん 大紋 他門 多聞"
"たもんてん 多聞天"
"たや 多屋 田谷 田屋"
"たやす 田安"
"たやま 田山"
"たやまかたい 田山花袋"
"たゆ 斬"
"たゆう 大輔 大夫 太夫"
"たゆうこ 太夫子"
"たよう 他用 多用 多様"
"たよく 多欲"
"たより 便り"
"たよりがい 頼り甲斐"
"たら 大口魚 膤 鰔 太良 鱈"
"たらい 盥"
"たらいまわし 盥回し"
"たらぎ 多良木"
"たらこ 鱈子"
"たらじる 鱈汁"
"たらず 足らず"
"たらちね 垂乳根"
"たらばがに 多羅波蟹 鱈場蟹"
"たらふく 鱈腹"
"たらま 多良間"
"たらみ 多良見"
"たり 足り"
"たりかつよう タリ活用"
"たりき 他力"
"たりつ 他律"
"たりゅう 他流"
"たりょう 多量"
"たる 垂 樽"
"たるい 樽井 垂井"
"たるがた 樽型"
"たるき 架 樽木 榱 椽 垂木"
"たるざかな 樽魚"
"たるざけ 樽酒"
"たるだい 樽代"
"たるとがた タルト型"
"たるなま 樽生"
"たるひ 垂氷"
"たるほ 足穂"
"たるみ 弛み 垂水"
"たるみず 垂水"
"たれ 誰 垂れ"
"たれいしき 他励式"
"たれかべ 垂れ壁"
"たれがし 誰某"
"たれがみ 垂れ髪"
"たれぎぬ 垂れ絹"
"たれつ 多列"
"たれつき タレ付き"
"たれまく 垂幕"
"たれみず 垂水"
"たれみみ 垂れ耳"
"たれめ たれ目 タレ目"
"たろいも タロ芋"
"たろう 多郎 太良 田老 太朗 太郎"
"たわ 嵶 撓"
"たわい 他愛"
"たわけ 白痴 田分け 戯け"
"たわけもの たわけ者"
"たわごと 戯言"
"たわし 束子"
"たわだいら 多和平"
"たわぶれうた 戯れ歌"
"たわみ 撓み"
"たわむれ 戯 戯れ"
"たわむれごと 戯れ言"
"たわら 太原 田原 俵"
"たわらまち 俵万智"
"たわらやそうたつ 俵屋宗達"
"たわれうた 戯れ歌"
"たわわ 撓わ"
"たん 彖 賺 貪 站 攤 蛋 綻 誕 鄲 褝 襌 殫 憚 單 箪 澹 憺 膽 胆 靼 袒 疸 旦 擔 担 坦 但 譚 覃 潭 酖 眈 耽 槫 摶 慱 亶 檀 壇 餤 啗 啖 毯 緞 椴 鍛 猯 湍 湛 堪 探 丹 淡 炭 短 歎 嘆 反 痰 端 単"
"たんあつ 鍛圧"
"たんあな 単穴"
"たんい 單位 短衣 単為 単位"
"たんいち 単一"
"たんいつ 単一"
"たんいべくとる 単位ベクトル"
"たんいん 貪婬 貪淫 探韻"
"たんえ 丹絵"
"たんおん 短音 単音"
"たんか 單價 単果 譚歌 丹霞 丹花 啖呵 担架 炭化 短歌 単価"
"たんかい 坦懐"
"たんかか 単花果"
"たんかく 短角"
"たんかくそうしょ 丹鶴叢書"
"たんかだいがく 単科大学"
"たんかん 単漢 単管 単館 胆管 短観"
"たんがら 炭殻"
"たんがん 歎願 単願 単眼 嘆願"
"たんき 単記 単機 単騎 短気 短期"
"たんきゃく 単脚"
"たんきゅう 単球 探究 探求"
"たんきょく 端局 単極"
"たんきょりば 短距離馬"
"たんきょりらんなー 短距離ランナー"
"たんきよ たん清"
"たんきん 単金 鍛金"
"たんぎょく 単玉"
"たんぎん 断金"
"たんく 短句 短躯"
"たんぐすてんこう タングステン鋼"
"たんぐつ 短靴"
"たんけい 短形 短径"
"たんけん 短見 短剣 探険 探検"
"たんけんふ ‡ †"
"たんげ 丹下"
"たんげい 端倪"
"たんげさぜん 丹下左膳"
"たんげん 端厳 単元"
"たんこう 単向 単溝 炭鑛 短光 単行 鍛鋼 湛江 単項 鍛工 単鉤 探鉱 淡黄 淡紅 単孔 炭坑 炭鉱"
"たんこうのうりょく 堪航能力"
"たんこうぶし 炭坑節"
"たんこうほんみしゅうろく 単行本未収録"
"たんこぶ たん瘤"
"たんころ 単コロ"
"たんこん 単婚"
"たんこんたい 担根体"
"たんご 端午 丹後 単語"
"たんごのせっく 端午の節句"
"たんごん 端厳"
"たんさ 丹砂 探査"
"たんさい 短才 単彩 淡彩"
"たんさく 探策 単作 探索"
"たんさくぎ 探索木"
"たんさわこ 丹沢湖"
"たんさん 単三 単産 炭酸"
"たんさんあんこてい 炭酸暗固定"
"たんさんいり 炭酸入"
"たんさんかり 炭酸カリ"
"たんさんがす 炭酸ガス"
"たんさんせん 炭酸泉"
"たんざ 単坐 端坐 端座 単座"
"たんざく 短冊"
"たんざわ 丹沢"
"たんざん 湛山"
"たんし 箪食 短枝 単子 単糸 淡紫 短資 譚詩 短詩 端子"
"たんしお タン塩"
"たんしき 単式"
"たんしきん 担子菌"
"たんしこしょう 箪食瓠漿"
"たんしつ 炭質"
"たんしゃ 丹砂 単写 単射 単車"
"たんしゃしょうけい 単斜晶系"
"たんしゅう 騨州 端舟 淡州 但州 丹州"
"たんしゅく 短縮"
"たんしゅくけい 短縮茎"
"たんしゅん 探春"
"たんしょ 端書 探書 端緒 短所"
"たんしょう 短章 短小 探勝 単勝"
"たんしょうとう 探照燈 探照灯"
"たんしょうはんだん 単称判断"
"たんしょく 貪食 淡色 単色"
"たんしょくこう 単色光"
"たんしょくし 探触子"
"たんしようしょくぶつこう 単子葉植物綱"
"たんしん 探針 短針 単身 短信"
"たんじ 単耳 丹治"
"たんじく 短軸 単軸"
"たんじつ 短日"
"たんじゃく 短尺"
"たんじゅう 短銃 胆汁"
"たんじゅん 単順 単純"
"たんじゅんせん 単純泉"
"たんじゅんばり 単純梁"
"たんじゅんみす 単純ミス"
"たんじょう 誕生"
"たんじょういわい 誕生祝"
"たんじょうけん 端条件"
"たんじん 炭塵"
"たんす 箪笥"
"たんすい 淡水"
"たんすいかぶつ 炭水化物"
"たんすいこ 淡水湖"
"たんすいしゃ 炭水車"
"たんすう 単数"
"たんすよきん タンス預金"
"たんせい 単声 単性 嘆声 淡青 丹青 端整 端正 丹精"
"たんせいか 単性花"
"たんせき 嘆惜 痰咳 旦夕 胆石"
"たんせつ 鍛接"
"たんせん 段銭 単線"
"たんぜい 担税"
"たんぜん 淡然 端然 丹前"
"たんそ C 嘆訴 歎訴 炭疽 炭素"
"たんそう 単奏 担送 単走 炭層 単層 単相"
"たんそく 探測 歎息 短足 嘆息"
"たんそこう 炭素鋼"
"たんそさ 炭素鎖"
"たんそぼう 炭素棒"
"たんぞう 胆臓 鍛造"
"たんたい 担体 単体"
"たんたいてすと 単体テスト"
"たんたかばし 反高橋"
"たんたん 坦々 湛々 眈眈 眈々 淡淡 淡々"
"たんたんめん 担担麺 担々麺"
"たんだ 短打 単打"
"たんだい 探題 短大"
"たんち 丹治 探知"
"たんちゃめぶし 谷茶前節"
"たんちょ 単著 端緒"
"たんちょう 単頂 丹頂 探鳥 短調 単調"
"たんちょうづる 丹頂鶴"
"たんつば 痰唾"
"たんつぼ 痰壺 痰壷"
"たんづつ 短筒"
"たんてい 単蹄 短艇 端艇 探偵"
"たんていちょう 探偵帖"
"たんてき 胆摘 端的"
"たんてつ 鍛鉄"
"たんてん 端点"
"たんでき 耽溺"
"たんでん 炭田 丹田"
"たんとう 探湯 単刀 丹東 但東 短刀 担当"
"たんとうがかりめい 担当係名"
"たんどう 胆道"
"たんどうがん 胆道癌"
"たんどく 單獨 耽読 丹毒 単独"
"たんどくこう 単独行"
"たんな 丹那"
"たんなる 単なる"
"たんなん 丹南"
"たんに 単二 歎異 単に"
"たんにしょう 歎異抄"
"たんにん 担任"
"たんにんさん タンニン酸"
"たんねん 端然 単年 丹念"
"たんの 端野 丹野"
"たんのう 端脳 単能 胆嚢 堪能"
"たんのはら 旦野原"
"たんば 丹羽 丹波"
"たんばい 単売"
"たんばいろ 胆礬色"
"たんばやき 丹波焼"
"たんばら 丹原"
"たんばん 胆礬 単板"
"たんぱ 短波"
"たんぱく 淡泊 淡白 蛋白"
"たんぱくしつ タンパク質"
"たんぱくにょう 蛋白尿"
"たんぱつ 短髪 単発"
"たんぱらじお 短波ラジオ"
"たんぱん 短パン"
"たんび 度 歎美 嘆美 耽美"
"たんぴ 単肥"
"たんぴょう 単票 短評"
"たんぴん 単品"
"たんふく 単複"
"たんぶ 反歩 端部"
"たんぶん 探聞 単文 短文"
"たんぶんしまく 単分子膜"
"たんぷく 単複"
"たんべん 単弁"
"たんべんか 単弁花"
"たんぺい 短兵"
"たんぺいきゅう 短兵急"
"たんぺん 短辺 短篇 短編"
"たんぺんせいか 短編成化"
"たんほう 探訪"
"たんほうせい 単峰性"
"たんぼ 田んぼ 田圃"
"たんぼう 探訪"
"たんぼく 単木"
"たんぽ 担保"
"たんぽつきしゃさい 担保付社債"
"たんぽぽ 蒲公英"
"たんまち 反町"
"たんまつ 端末"
"たんまつまど 端末窓"
"たんみ 澹味 淡味 単味"
"たんみん 蜑民 蛋民 短眠"
"たんむ 坦務"
"たんめい 短命"
"たんめん 単面 湯麺 端面"
"たんもう 短毛"
"たんもの 反物"
"たんや 短夜"
"たんやく 丹薬"
"たんゆう 胆勇"
"たんよう 単葉"
"たんよく 貪欲"
"たんよん 単四"
"たんらく 短絡"
"たんらん 貪婪"
"たんり 単利 単離"
"たんりつ 単立"
"たんりゃく 胆略"
"たんりゅう 単粒"
"たんりゅうしゅ 短粒種"
"たんりょ 短慮"
"たんりょうたい 単量体"
"たんりょく 胆力 淡緑"
"たんりょくぼん 丹緑本"
"たんれい 淡麗 端麗"
"たんれつ 単列"
"たんれん 単連 鍛練 鍛錬"
"たんろ 単路"
"たんろくぼん 丹緑本"
"たんわく 単枠"
"だ 出 墮 雫 荼 陏 橢 拏 拿 娜 朶 騨 唾 佗 沱 鴕 駝 柁 舵 陀 蛇 楕 惰 堕 儺 懦 妥 田 兌 打 駄"
"だい 梯 岱 戴 弟 内 廼 迺 餒 臺 醍 代 台 題 第 大"
"だいあく 大悪"
"だいあん 代案"
"だいあんじ 大安寺"
"だいい 大尉 題意 代位"
"だいいき 大域"
"だいいし 台石"
"だいいち 第1 第１ 第一"
"だいいちこうしょう 第一興商"
"だいいちせめんと 第一セメント"
"だいいちだん 第１弾 第一弾"
"だいいちほてる 第一ホテル"
"だいいっかん 第一勘 第一感 第一款"
"だいいっしゅ 第1種"
"だいいっしょう 第1章"
"だいいっぱん 第1版"
"だいいべんと 大イベント"
"だいいん 代印 代員"
"だいうん 大運"
"だいえ 大会"
"だいえい 題詠 大永 大映 大栄"
"だいえいていこく 大英帝国"
"だいえいはくぶつかん 大英博物館"
"だいえっとしょくひん ダイエット食品"
"だいえつ 大越"
"だいえり 台襟"
"だいえん 大円"
"だいおう 大黄 大王"
"だいおん 大陰 大音 大恩"
"だいか 台下 代価"
"だいかいれい 大海令"
"だいかえ 代替"
"だいかく 大覚"
"だいかし 代貸し"
"だいかっこ ］ ［"
"だいかつ 大喝"
"だいかん 大缶 大巻 大韓 大寒 代官"
"だいかんきょほう 大艦巨砲"
"だいかんそう 大観荘"
"だいがえ 代替 代替え"
"だいがく 大學 大学"
"だいがくいも 大学芋"
"だいがくのーと 大学ノート"
"だいがくのかみ 大学頭"
"だいがす 大ガス"
"だいがわり 代替り 代替わり"
"だいがん 大願"
"だいき 乃毅 代機 大機"
"だいきち 大吉"
"だいきゅう 大弓 代休"
"だいきょう 大京 大凶"
"だいきょういん 大教院"
"だいきん 大金 代金"
"だいきんこうぎょう ダイキン工業"
"だいぎ 代議 台木"
"だいぎん 大吟"
"だいく 第九 大工"
"だいけい 大計センター 大型計算機センター 大型計算機 大計 大慶 台形"
"だいけつ 代決"
"だいけん 大建 大検"
"だいげん 代言 題言"
"だいこ 太鼓"
"だいこう 乃公 代講 大幸 代行"
"だいこく 大黒"
"だいこくちょう 大国町"
"だいこくてん 大黒天"
"だいこくばしら 大黒柱"
"だいこん 大根"
"だいこんあし 大根足"
"だいこんな 大根菜"
"だいこんは 大根葉"
"だいこんば 大根葉"
"だいご 第５ 大悟 大吾 大子 醍醐 第五"
"だいごう 題号"
"だいごかい 大語界"
"だいごくでん 大極殿"
"だいさ 大佐"
"だいさーびす 大サービス"
"だいさい 大祭"
"だいさく 大作 代作"
"だいさん 第III 第3 第３ 代参 第三"
"だいさんかん 第三款"
"だいさんせくたー 第三セクター"
"だいさんだん 第３弾 第三弾"
"だいざ 台座"
"だいざい 大罪 題材"
"だいざわ 代沢"
"だいし 第四 題詩 題詞 大姉 大史 大志 大師 台詞 台紙"
"だいしいちばん 大死一番"
"だいしだい 大市大"
"だいしっこう 代執行"
"だいしゃ 代車 台車"
"だいしゅ 大衆"
"だいしゅうそうぞく 代襲相続"
"だいしょ 代書"
"だいしょう 大将 代将 大聖 大証 代償 大小"
"だいしょうざん 大翔山"
"だいしょうてん 大賞典"
"だいしょうほう 大翔鳳"
"だいしょっく 大ショック"
"だいしん 代診"
"だいしんいん 大審院"
"だいじ 題辞 大弐 大慈 大寺 題字 大治 大字 大事"
"だいじせん 大辞泉"
"だいじほう 大字報"
"だいじゃ 大蛇"
"だいじゅ 大樹"
"だいじょう 大嘗 台状 大丈 台上 大乗"
"だいじょうかん 太政官"
"だいじょうかんちょう 太政官牒"
"だいじょうきょう 大乗経"
"だいじょうだいじん 太政大臣"
"だいじょうてんのう 太上天皇"
"だいじり 台尻"
"だいじん 大尽 大神 大臣"
"だいじんどう 大仁堂"
"だいす 台子"
"だいすーしー 大四喜"
"だいすう 大数 台数 代数"
"だいすけ 大亮 大祐 大助 大介 大輔"
"だいすたー 大スター"
"だいず 大豆"
"だいずばたけ 大豆畑"
"だいせーる 大セール"
"だいせきはん 大赤斑"
"だいせつ 大雪"
"だいせん 大山 台船 大仙"
"だいぜん 大膳"
"だいそう 体操 代奏 代走"
"だいそうげんのちいさないえ 大草原の小さな家"
"だいそうしょう 大僧正"
"だいそつ 大卒"
"だいそれた 大それた"
"だいぞう 大蔵"
"だいた 台田 代田"
"だいたい 大腿 大隊 大体 代替"
"だいたいえねるぎー 代替エネルギー"
"だいたいしとうきん 大腿四頭筋"
"だいたいふろん 代替フロン"
"だいたん 大胆"
"だいだ 代打"
"だいだい 代代 大々 代々 橙"
"だいだいいろ だいだい色 橙色"
"だいだいず 橙酢"
"だいだんえん 大団圓"
"だいち 代置 大値 代地 台地 大地"
"だいちゅう 大中"
"だいちゅうおう 台中央"
"だいちょう 大腸 台帳"
"だいちょうがん 大腸ガン 大腸がん"
"だいっきらい 大っ嫌い"
"だいてつ 大哲"
"だいてん 題点 大篆 大典"
"だいてんし 大転子"
"だいてんほう 大店法"
"だいてんもく 台天目"
"だいてんりっちほう 大店立地法"
"だいと 大都"
"だいとう 大盗 大唐 大刀 大塔 大東"
"だいとく 大徳"
"だいどう 大道 大同"
"だいどうし 代動詞"
"だいどうみゃくえんしょうこうぐん 大動脈炎症候群"
"だいどく 大毒 代読"
"だいどころ 台所"
"だいなし 台無 台無し"
"だいなな 第七"
"だいななかい 第７回"
"だいなり 大なり ≧ ＞"
"だいなりいこーる ≧"
"だいなん 大難"
"だいに 第2 第２ 大弐 第二"
"だいにかん 第二款"
"だいにぎ 第二義"
"だいにだん 第二弾"
"だいにち 大日"
"だいにちきょう 大日経"
"だいにちざかり 大日盛"
"だいにゅーす 大ニュース"
"だいにゅう 代入"
"だいにん 代任 大人 代人"
"だいの 大の"
"だいのう 代納 大脳"
"だいのおとこ 大の男"
"だいのはら 台原"
"だいはち 大八"
"だいはちぐるま 大八車"
"だいはちしあい 第八試合"
"だいはつこうぎょう ダイハツ工業"
"だいはつねはんぎょう 大般涅槃経"
"だいば 台場"
"だいばーげん 大バーゲン"
"だいばかり 台秤"
"だいばだった 提婆達多"
"だいばん 台盤"
"だいぱにっく 大パニック"
"だいひ 大悲"
"だいひっと 大ヒット"
"だいひつ 代筆"
"だいひょう 大兵 代表"
"だいひょうさんこま 代表産駒"
"だいひょうば 代表馬"
"だいひん 代品"
"だいびき 代引き 代引"
"だいぴんち 大ピンチ"
"だいふ 代父"
"だいふぁん 大ファン"
"だいふく 大福"
"だいふくもち 大福餅"
"だいふだ 台札"
"だいぶ 大夫 大部 大分"
"だいぶーむ 大ブーム"
"だいぶきん 台布巾"
"だいぶつ 代物 大仏"
"だいぶむかし 大分昔"
"だいぶれいく 大ブレイク"
"だいぶん 大分"
"だいへん 代返"
"だいへんらく 大変楽"
"だいべん 大弁 大便 代弁"
"だいほーる 大ホール"
"だいほう 大宝"
"だいほうけんせつ 大豊建設"
"だいほん 台本"
"だいぼ 代母"
"だいぼう 大坊"
"だいま 大間"
"だいまる 大丸"
"だいみてい 題未定"
"だいみょう 大名"
"だいみょうちく 大名竹"
"だいみんていこく 大明帝国"
"だいめ 台目 代目"
"だいめい 大明 題名"
"だいめいし 代名詞"
"だいめいどうし 代名動詞"
"だいもう 大網"
"だいもく 題目"
"だいもつ 代物 大物"
"だいもん 大紋 代紋 大問 大門"
"だいもんじやき 大文字焼"
"だいや ◇ ◆ 大谷"
"だいやく 代役"
"だいやるしき ダイヤル式"
"だいよう 大用 大葉 代用"
"だいよん 第4 第４ 第四"
"だいよんかん 第四款"
"だいよんかんひょうき 第四間氷期"
"だいら 平"
"だいらく 大楽"
"だいり 大利 大理 内裏 代理"
"だいりーがー 大リーガー"
"だいりーぐ 大リーグ"
"だいりき 大力"
"だいりくれい 大陸令"
"だいりはは 代理母"
"だいりびな 内裏雛"
"だいりぼ 代理母"
"だいりょう 代料 大領"
"だいりょうはいきしゃかい 大量廃棄社会"
"だいりょうふくせい 大量複製"
"だいれん 大連"
"だいろうさ 大労作"
"だいろく 第６ 第六"
"だいろっかい 第６回 第六回"
"だいろっかん 第六感"
"だいろっき 第六期"
"だいろっきょく 第六局"
"だいわ 台輪 大和"
"だいわく 台枠"
"だいわん 大彎"
"だうへいきん ダウ平均"
"だうん 朶雲"
"だうんしょう ダウン症"
"だうんろーどはんばい ダウンロード販売"
"だえき 唾液"
"だえん 橢圓 橢円 楕円"
"だえんこ 楕円弧"
"だおれ 倒れ"
"だか 高"
"だかい 打開"
"だかつ 蛇蠍 蛇蝎"
"だかん 朶翰 打感 蛇管 兌換"
"だがー †"
"だがく 打楽"
"だがっき 打楽器"
"だき 惰気 舵機 唾棄"
"だきあわせ 抱き合わせ"
"だきごこち 抱き心地"
"だきに 荼枳尼"
"だきにてん 荼枳尼天 荼吉尼天"
"だきにんぎょう 抱き人形"
"だきばしら 抱き柱 抱柱"
"だきまくら 抱き枕"
"だきみょうが 抱茗荷"
"だきゅう 打球"
"だきょう 妥協"
"だぎょう だ行 ダ行"
"だく 駄句 濁 諾"
"だくい 諾意"
"だくおん 濁音"
"だくおんぷ ゛"
"だくしゅ 濁酒"
"だくしょく 濁色"
"だくすい 濁水"
"だくせ 濁世"
"だくせい 濁世"
"だくだく 諾々"
"だくてん ゛ 濁点"
"だくどけい 濁度計"
"だくひ 諾否"
"だくりゅう 濁流"
"だけ 竹 嶽 岳"
"だけつ 妥結"
"だけん 駄犬 打鍵"
"だげき 打撃"
"だげん 打弦"
"だこ 凧 蛸"
"だこう 蛇行"
"だこうとうてい 打高投低"
"だこく 打刻"
"だごく 堕獄"
"ださ 打差"
"ださく 駄作"
"ださん 打算"
"だざい 堕罪 太宰"
"だざいおさむ 太宰治"
"だざいふ 大宰府"
"だし 出し 山車 出汁"
"だしがら 出し殻"
"だしじる だし汁"
"だしまきたまご だし巻き卵 出し巻き卵"
"だしもの 演し物"
"だしゃ 打者"
"だしゅ 舵手"
"だしん 打診"
"だじゃく 懦弱"
"だじゃれ 駄洒落"
"だじゅん 打順"
"だじょうかん 太政官"
"だじょうだいじん 太政大臣"
"だじょうてんのう 太上天皇"
"だすう 打数"
"だせい 打製 惰性"
"だせき 打席"
"だせん 打線"
"だそく 蛇足"
"だたい だ体 堕胎"
"だたみ 畳"
"だだ 駄々"
"だだいこ 大太鼓"
"だだもれ だだ漏れ ダダ漏れ"
"だだゆき 忠幸"
"だち 逹 達 太刀 立ち"
"だちょう 鴕鳥 駝鳥"
"だちん 駄賃"
"だっ 脱"
"だっか 脱化"
"だっかい 脱会 奪回"
"だっかく 奪格"
"だっかん 脱簡 奪還"
"だっき 妲己"
"だっきゃく 脱却"
"だっきゅう 脱臼"
"だっこ 抱っこ"
"だっこう 脱肛 脱稿"
"だっこく 脱穀"
"だっこん 脱魂"
"だっさい 獺祭"
"だっさいぎょ 獺祭魚"
"だっさん 脱酸"
"だっし 脱脂"
"だっしにゅう 脱脂乳"
"だっしめん 脱脂綿"
"だっしゅ 奪首 奪取"
"だっしゅう 脱臭"
"だっしゅつ 脱出"
"だっしょく 脱色"
"だっすい 脱水"
"だっせん 脱線"
"だっそ 脱疽"
"だっそう 脱走"
"だったい 奪胎 脱退"
"だったん 脱炭 韃靼"
"だっちつ 脱窒"
"だっちゃく 脱着"
"だっちょう 脱調 脱腸"
"だっと 脱兎"
"だっとう 脱刀 脱党"
"だっぱん 脱藩"
"だっぴ 脱皮"
"だっぷん 脱糞"
"だっぽう 脱法"
"だつ 怛 妲 獺 奪 脱"
"だつあにゅうおう 脱亜入欧"
"だつあろん 脱亜論"
"だつい 脱衣"
"だつえい 脱営"
"だつえん 脱塩"
"だつご 脱語 脱誤"
"だつごく 脱獄"
"だつさら 脱サラ"
"だつさんしん 奪三振"
"だつしゅりつ 奪取率"
"だつじ 脱字"
"だつぜい 脱税"
"だつぜん 脱然"
"だつぞく 脱俗"
"だつぶん 脱文"
"だつほうこうい 脱法行為"
"だつぼう 脱帽"
"だつめい 脱盟"
"だつもう 脱毛"
"だつらく 脱落"
"だつり 脱離"
"だつりゃく 奪掠 奪略"
"だつりゅう 脱硫"
"だつりょく 脱力"
"だつりん 脱輪"
"だつろう 脱牢 脱漏"
"だて 舘 点 館 建て 立て 伊達"
"だておとこ 伊達男"
"だておんな 伊達女"
"だてすがた 伊達姿"
"だてまき 伊達巻"
"だてん 打点"
"だてんし 堕天使"
"だでん 打電"
"だとう 打倒 妥当"
"だな 棚"
"だに 駄荷 谷 壁蝨"
"だにえるしょ ダニエル書"
"だね 種"
"だは 打破"
"だはく 打拍"
"だば 駄馬"
"だひつ 惰筆"
"だび 荼毘"
"だびらひろ 太平広"
"だふや だふ屋 ダフ屋"
"だぶつ 陀仏"
"だぶるだがー ‡"
"だぶん 駄文"
"だべん 駄弁"
"だほ 拿捕"
"だほう 打法"
"だほん 駄本"
"だぼう 打棒"
"だぼく 打撲"
"だぼくしょう 打撲傷"
"だぼはぜ だぼ鯊"
"だぼら 駄法螺"
"だま 弾 球 玉"
"だまし 騙し"
"だましい 魂"
"だましうち 騙し討ち"
"だまり 溜り"
"だみ 彩 濃"
"だみえ 彩絵 濃絵"
"だみごえ だみ声 ダミ声 濁声"
"だみん 惰眠"
"だむこ ダム湖"
"だむだむだん ダムダム弾"
"だめ 溜め 駄目"
"だめおし ダメ押し"
"だめだし ダメ出し"
"だめにんげん ダメ人間"
"だめん 打面"
"だもの 駄物"
"だより 便り"
"だら 鱈"
"だらく 堕落"
"だらに 陀羅尼"
"だりつ 打率"
"だりょく 惰力 打力"
"だりん 舵輪"
"だる 樽"
"だるま 達磨"
"だれ 誰"
"だれあて 誰宛"
"だれか 誰か"
"だれかさん 誰かさん"
"だれかば 誰カバ"
"だれかれ 誰彼"
"だれそれ 誰某"
"だれだれ 誰々 誰誰"
"だれひとり 誰一人"
"だれもかも 誰も彼も"
"だれもかれも 誰も彼も"
"だん 灘 旦 團 斷 彈 騨 椴 男 檀 壇 断 煖 暖 弾 団 談 段"
"だんあつ 彈壓 弾圧"
"だんあん 断案"
"だんい 段位"
"だんいた 段板"
"だんいほうしょく 暖衣飽食"
"だんいん 団員"
"だんう 弾雨"
"だんうん 断雲"
"だんえん 団円"
"だんおち 檀越"
"だんおつ 檀越"
"だんおん 弾音"
"だんおんたい 暖温帯"
"だんか 檀家"
"だんかい 暖海 団塊 段階"
"だんかいじゅにあ 団塊ジュニア"
"だんかいのせだい 団塊の世代"
"だんかん 段間 断簡"
"だんがい 彈劾 弾劾 断崖"
"だんがん 彈丸 弾丸"
"だんき 弾機 団旗 断機 暖機 暖気"
"だんきゅう 檀弓 段級 段丘"
"だんきろく 団鬼六"
"だんきん 断琴 断金 弾琴"
"だんぎ 談議 談義"
"だんぎょ 団魚"
"だんぎり 段切り"
"だんぎれ 段切れ"
"だんくみ 段組"
"だんくん 檀君"
"だんぐみ 段組"
"だんけい 男系"
"だんけつ 団結"
"だんげん 断弦 断言"
"だんこ 断乎 断固"
"だんこう 断口 断交 団交 断行"
"だんこん 弾痕 男根"
"だんご 団子"
"だんごう 談合"
"だんごうざか 談合坂"
"だんごく 暖国"
"だんござか 団子坂"
"だんごばな だんご鼻 団子鼻"
"だんごむし 団子虫"
"だんさ 段差"
"だんさい 断裁"
"だんざい 断罪"
"だんし 断嘴 弾糸 弾子 弾指 檀紙 談志 男子"
"だんしきょう 弾指頃"
"だんしすいちく 弾糸吹竹"
"だんしち 団七"
"だんしつ 煖室 暖室"
"だんしといれ 男子トイレ"
"だんしべん 男子便"
"だんしゃ 檀車"
"だんしゃく 男爵"
"だんしゅ 檀主 断首 断種 断酒"
"だんしゅう 団集 男囚"
"だんしゅん 暖春"
"だんしょ 壇所"
"だんしょう 男妾 男娼 断章 談笑"
"だんしょうしゅぎ 断章取義"
"だんしょく 男色 暖色"
"だんしりょう 男子寮"
"だんしん 弾芯"
"だんじ 男児"
"だんじき 断食"
"だんじきづき 断食月"
"だんじく 段軸"
"だんじて 断じて"
"だんじゅうろう 團十郎"
"だんじょ 男女"
"だんじょう 弾正 壇上"
"だんじり 檀尻"
"だんすい 断水"
"だんすう 弾数 段数"
"だんすきょうしつ ダンス教室"
"だんせい 男声 弾性 男性"
"だんせいばん 弾性板"
"だんせいほるもん 男性ホルモン"
"だんせいむけ 男性向"
"だんせん 断線"
"だんぜつ 断絶"
"だんぜん 断然"
"だんそう 弾奏 断想 弾倉 男装 断層"
"だんそうがい 断層崖"
"だんそん 男尊"
"だんぞう 檀像"
"だんぞく 断続"
"だんたい 彈帶 弾帯 暖帯 団体"
"だんたにさんぎょう 段谷産業"
"だんだ 段田"
"だんだん 段々"
"だんだんばたけ 段段畑 段々畑"
"だんち 暖地 団地"
"だんちがい 段違い"
"だんちく 暖竹 葮竹"
"だんちづま 団地妻"
"だんちゃく 彈着 弾着"
"だんちょう 断腸 団長"
"だんてい 断定"
"だんと 檀徒"
"だんとう 彈頭 弾頭 暖冬"
"だんとうだい 断頭台"
"だんとつ 断トツ"
"だんどう 彈道 弾道"
"だんどうだん 弾道弾"
"だんどうみさいる 弾道ミサイル"
"だんどり 段取り"
"だんな 檀那 旦那"
"だんなでら 檀那寺"
"だんにゅう 断乳"
"だんねつ 断熱"
"だんねん 断念"
"だんのうら 壇ノ浦"
"だんばしご 段梯子"
"だんばな 段鼻"
"だんばん 檀板"
"だんぱつ 断髪"
"だんぱん 談判"
"だんびら 段平"
"だんぴ 断臂"
"だんぴつ 断筆"
"だんふみ 檀ふみ"
"だんぺん 断片"
"だんぼーる 段ボール"
"だんぼーるばこ 段ボール箱"
"だんぼう 煖房 暖房"
"だんまく 彈幕 段幕 弾幕"
"だんまつま 断末摩 断末魔"
"だんまり 黙り"
"だんみん 断眠"
"だんめ 段目"
"だんめつ 断滅"
"だんめん 断面"
"だんもの 段物"
"だんやく 彈藥 弾薬"
"だんゆう 男優"
"だんらく 談楽 段落"
"だんらん 檀欒 団らん 団欒"
"だんりゅう 団粒 暖流"
"だんりょく 弾力"
"だんりん 談林 檀林"
"だんれいぼう 暖冷房"
"だんれつ 断裂"
"だんろ 煖爐 煖炉 暖炉"
"だんろん 談論"
"だんろんぽう 段論法"
"だんわ 談話"
"ち 岻 夊 家 千 胝 黹 褫 夂 乳 薙 茅 置 黐 魑 躓 質 耻 恥 弛 馳 穉 稚 遲 遅 輊 緻 致 笞 治 踟 蜘 癡 痴 智 知 値 池 地 血"
"ちー 吃"
"ちーずやき チーズ焼き"
"ちーちゃ 起家"
"ちーほー 地和"
"ちーむない チーム内"
"ちーむめい チーム名"
"ちあい 血合い 血合"
"ちあき 千章 千昌 千亜紀 千明 千秋 千晶"
"ちあゆ 稚鮎"
"ちあん 治安"
"ちい 地維 地異 地衣 地位"
"ちいお 千五百"
"ちいき 値域 地域"
"ちいく 智育 知育"
"ちいさな 小さな"
"ちいといつ 七対子"
"ちいほ 千五百"
"ちいほう 地和"
"ちいみ 血忌"
"ちいん 知音"
"ちうみ 血膿"
"ちぇーんてん チェーン店"
"ちぇこすろばきあ 捷克"
"ちぇろくみきょく チェロ組曲"
"ちえ 知惠 千英 知衣 千重 知慧 知江 千枝 知重 千絵 知枝 智慧 智恵 知恵"
"ちえきけん 地役権"
"ちえくらべ 知恵競べ 知恵比べ"
"ちえこ 千枝子 知恵子 千恵子 智恵子"
"ちえこしょう 智恵子抄"
"ちえのわ 知恵の輪"
"ちえぶくろ 知恵袋"
"ちえみ 智栄美 千絵美 千恵美 智恵美 智枝美"
"ちえん 地縁 遅延"
"ちおも 乳母"
"ちおや 乳親"
"ちおりゅうさん チオ硫酸"
"ちおん 地温"
"ちおんいん 知恩院"
"ちか 親 知可 知華 智加 智香 知佳 知夏 智佳 千夏 値化 治下 近 地価 地下"
"ちかい 邇 知解 近井 誓い 地塊 地界 地階"
"ちかお 知馨夫 親雄 周夫"
"ちかく 近く 地核 地殻 知覚"
"ちかけい 地下茎"
"ちかげ 千影"
"ちかこ 渠睦子 千嘉子 智加子 千加子 ちか子 知可子 智香子 睦子 千香子 千賀子"
"ちかごと 誓言"
"ちかごろ 近頃"
"ちかざわ 近澤"
"ちかし 迩 近し"
"ちかじか 近々"
"ちかずみ 近角"
"ちかだ 近田"
"ちかぢか 近々"
"ちかって 誓って"
"ちかてつ 地下鉄"
"ちかば 近場"
"ちかひろ 近廣 近広"
"ちかま 近間"
"ちかまつ 近松"
"ちかまつもんざえもん 近松門左衛門"
"ちかまわり 近回り"
"ちかみち 近道"
"ちかめ 近目"
"ちかやま 近山"
"ちから 千賀良 主税 税 力"
"ちからいがい 力以外"
"ちからいし 力石"
"ちからいっぱい 力一杯"
"ちからいと 力糸"
"ちからおとし 力落し 力落とし"
"ちからかげん 力加減"
"ちからかんけい 力関係"
"ちからがみ 力紙"
"ちからがわ 力革"
"ちからくらべ 力競べ 力比べ"
"ちからこぶ 力こぶ 力瘤"
"ちからさ 力差"
"ちからしごと 力仕事"
"ちからじこく 力時刻"
"ちからじまん 力自慢"
"ちからずく 力尽く 力ずく"
"ちからずもう 力相撲"
"ちからせいぎょ 力制御"
"ちからせいぶん 力成分"
"ちからぞえ 力添え"
"ちからだけ 力竹"
"ちからだのみ 力頼み"
"ちからだめし 力試し"
"ちからづよい 力強い"
"ちからてき 力的"
"ちからぬけ 力抜け"
"ちからぶそく 力不足"
"ちからまかせ 力任せ"
"ちからまけ 力負け"
"ちからみず 力水"
"ちからもち 力持 力餅 力持ち"
"ちからわざ 力業 力技"
"ちかろう 地下牢"
"ちかん 遅緩 地官 弛緩 置換 痴漢"
"ちが 違 千賀"
"ちがい 違い 地外 稚貝"
"ちがいだな 違い棚"
"ちがいほうけん 治外法権"
"ちがえ 違え"
"ちがく 地学"
"ちがさき 茅ヶ崎"
"ちがっか 地学科"
"ちがや 茅"
"ちき 飭 稙 稚気 知己"
"ちきしょう 畜生"
"ちきゅう 恥丘 地球"
"ちきゅうさみっと 地球サミット"
"ちきゅうしょう 地球照"
"ちきゅうみさき 地球岬"
"ちきょう 地峡"
"ちきょうだい 乳兄弟"
"ちきん 遅筋"
"ちぎ 杠 鎮木 知木 千木 遅疑 地祇"
"ちぎょ 池魚 稚魚"
"ちぎょう 知行"
"ちぎり 千切 契 契り"
"ちぎれぐも 千切れ雲"
"ちぎん 地銀"
"ちく 矗 逐 筑 馳駆 蓄 畜 竹 築 地区"
"ちくあん 竹安"
"ちくい 築井"
"ちくいち 逐一"
"ちくおんき 蓄音機"
"ちくかん 竹竿 竹簡"
"ちくきょう 地区協"
"ちくきん 竹琴"
"ちくけん 畜犬"
"ちくご 逐語 築後 筑後"
"ちくさ 千種"
"ちくさく 竹柵"
"ちくさつ 畜殺"
"ちくさん 畜産"
"ちくざい 蓄財 竹材"
"ちくし 竹枝 竹紙 筑紫"
"ちくしの 筑紫野"
"ちくしゃ 畜舎"
"ちくしゅ 畜主"
"ちくしゅう 筑州"
"ちくしょう 蓄妾 畜生"
"ちくじ 逐次"
"ちくじょう 逐条 築上 築城"
"ちくせき 蓄積"
"ちくぜん 竹善 筑前"
"ちくそう 竹叢 竹窓 竹槍"
"ちくぞう 蓄蔵 築造"
"ちくちく 矗々"
"ちくてい 築庭 築堤"
"ちくてん 逐電"
"ちくでん 逐電 蓄電"
"ちくでんち 蓄電池"
"ちくとうぼくせつ 竹頭木屑"
"ちくねつ 蓄熱"
"ちくねん 逐年"
"ちくのう 蓄膿"
"ちくは 竹葉"
"ちくはく 竹帛"
"ちくば 竹馬"
"ちくひ 竹扉 竹皮"
"ちくひせん 筑肥線"
"ちくび 乳首"
"ちくふじん 竹夫人"
"ちくほ 筑穂"
"ちくほう 筑豊"
"ちくま 筑摩"
"ちくまがわ 千曲川"
"ちくよう 畜養"
"ちくら 千倉"
"ちくりん 竹林"
"ちくるい 畜類"
"ちくれい 蓄冷"
"ちくろく 逐鹿"
"ちくわ 竹輪"
"ちくわふ 竹輪麩"
"ちくわぶ 竹輪麩"
"ちくん 治勲"
"ちぐ 知愚 智愚 値遇 痴愚"
"ちぐう 値遇 知遇"
"ちぐさ 乳草 千草 千種"
"ちぐしん 痴愚神"
"ちけい 笞刑 地景 智計 地形"
"ちけっとだい チケット代"
"ちけむり 血煙"
"ちけん 智剣 治権 智見 地券 地圏 知県 地検 治験 知見"
"ちけんしゃ 地権者"
"ちげなべ チゲ鍋"
"ちこう 地窖 地皇 知行 地溝 恥垢 遅効"
"ちこうしひょう 遅行指標"
"ちこうふう 地衡風"
"ちこうりゅう 地衡流"
"ちこく 治国 遅刻"
"ちこつ 恥骨"
"ちご 稚子 乳児 児 稚児"
"ちさ 知砂 千沙 智佐"
"ちさい 地裁"
"ちさき 地先"
"ちさく 千咲"
"ちさこ 知紗子 千佐子"
"ちさと 千里"
"ちさん 治産 遅参 地産 治山"
"ちざい 笞罪 知財"
"ちざけ 血酒"
"ちし 致仕 智歯 地史 地誌 致死"
"ちしお 血汐 血潮"
"ちしき 智識 知識"
"ちしきべーす 知識ベース"
"ちしつ 知悉 地質"
"ちしぶき 血しぶき 血飛沫"
"ちしま 千島"
"ちしまざさ 千島笹"
"ちしゃ 苣 痴者 萵苣 治者 智者 知者"
"ちしょ 地所"
"ちしょう 地象 智将 知将 治承 池沼 致傷 地消"
"ちしる 乳汁"
"ちしろ 千代"
"ちしん 池心 地心"
"ちしんじ 遅進児"
"ちじ 知事"
"ちじき 地磁気"
"ちじく 地軸"
"ちじつ 遅日"
"ちじゅつ 治術"
"ちじゅんほう 置閏法"
"ちじょ 痴女"
"ちじょう 笞杖 痴情 地上"
"ちじょうい 知情意"
"ちじょうけい 地上茎"
"ちじょく 恥辱"
"ちじん 地神 痴人 地人 知人"
"ちすい 池水 治水"
"ちすいかふう 地水火風"
"ちすじ 血筋"
"ちすわ 千須和"
"ちず 千寿 智頭 地図"
"ちずこ 知寿子 千寿子 千鶴子"
"ちせ 知世"
"ちせい 痴性 治世 地勢 知性"
"ちせいがく 地政学"
"ちせき 治績 地積"
"ちせこ 智勢子"
"ちせつ 稚拙"
"ちそ 地租"
"ちそう 地相 馳走 地層"
"ちそく 知足 遅速"
"ちぞめ 血染め"
"ちた 知多"
"ちたい 痴態 遅滞 地帯"
"ちたいかん 地対艦"
"ちたいくう 地対空"
"ちたいち 地対地"
"ちたいりょく 地耐力"
"ちたつ 笞撻 遅達"
"ちたね 千種"
"ちたび 千度"
"ちだ 千田"
"ちだい 地代"
"ちだまり 血溜り 血溜まり"
"ちだらけ 血だらけ"
"ちだるま 血ダルマ 血だるま 血達磨"
"ちち 致知 義父 遅々 乳 父"
"ちちいろ 乳色"
"ちちうえ 父上"
"ちちうし 乳牛"
"ちちおや 父親"
"ちちかた 父方"
"ちちがた 父方"
"ちちぎみ 父君"
"ちちくさ 乳草"
"ちちくび 乳首"
"ちちこ 父娘 父子"
"ちちご 父御"
"ちちしぼり 乳搾り"
"ちちしる 乳汁"
"ちちじま 父島"
"ちちとこ 父と子"
"ちちなしご 父無し子"
"ちちのひ 父の日"
"ちちはる 斉斉哈爾"
"ちちばなれ 乳離れ"
"ちちぶ 秩父"
"ちちぶのみや 秩父宮"
"ちちまつ 千々松"
"ちちむすめ 父娘"
"ちちもみ 乳揉み"
"ちちゃく 遅着"
"ちちゅう 地中"
"ちちょう 地調"
"ちぢ 千々"
"ちぢみ 縮み 縮"
"ちぢみおり 縮織"
"ちぢれ 縮れ"
"ちぢれげ 縮れ毛"
"ちぢわ 千々石"
"ちっか 窒化"
"ちっかい 蟄懐"
"ちっかこう 窒化鋼"
"ちっかん 竹竿 竹簡"
"ちっかんもん 竹管文"
"ちっきょ 蟄居"
"ちっこう 築港"
"ちっし 窒死"
"ちっそ N 窒素"
"ちっそがす 窒素ガス"
"ちっそく 窒息"
"ちっと 些と"
"ちっとも 些とも"
"ちっぷく 蟄伏"
"ちっぷべつ 秩父別"
"ちつ 腟 蟄 窒 秩 帙 膣"
"ちついり 帙入り"
"ちつえん 膣炎"
"ちつがいしゃせい 膣外射精"
"ちつけいれん 膣痙攣"
"ちつじょ 秩序"
"ちつせん 膣栓"
"ちつづき 血続き"
"ちつない 膣内"
"ちつぶんぴつえき 膣分泌液"
"ちつへき 膣壁"
"ちつみ 千津美"
"ちづ 地図"
"ちづか 千束"
"ちづこ 千鶴子"
"ちづる 千鶴"
"ちてい 地底"
"ちていこ 地底湖"
"ちてき 知的"
"ちてつ 地鉄"
"ちてん 地点"
"ちてんし 智天使"
"ちてんじょう 血天井"
"ちと 些と 少と"
"ちとく 地徳 知得"
"ちとせ 千登世 千歳"
"ちとせあめ 千歳飴"
"ちとせづる 千歳鶴"
"ちどう 治道"
"ちどうせつ 地動説"
"ちどめ 血止め"
"ちどり 鵆 千鳥"
"ちどりあし 千鳥足"
"ちどりがふち 千鳥ヶ淵"
"ちどん 遅鈍"
"ちな 知名"
"ちなつ 千夏"
"ちなみ 因"
"ちなみに 因みに"
"ちにく 血肉"
"ちにち 知日"
"ちねつ 地熱"
"ちねん 知念"
"ちの 千野 茅野"
"ちのあせ 血の汗"
"ちのあめ 血の雨"
"ちのいけ 血の池"
"ちのう 智能 知能"
"ちのうてすと 知能テスト"
"ちのうみ 血の海"
"ちのけ 血の気"
"ちのしお 地の塩"
"ちのなみだ 血の涙"
"ちのね 茅根"
"ちのみご 乳呑み児 乳飲み児 乳飲み子"
"ちのめぐり 血の巡り"
"ちのり 地の利 血糊"
"ちのわ 茅の輪"
"ちはい 遅配"
"ちはつ 薙髪 遅発"
"ちはや 千早"
"ちはら 茅原 千原"
"ちはらい 遅払い"
"ちはる 智春 千春"
"ちはん 池畔"
"ちば 地場 千葉"
"ちばな 知花"
"ちばなれ 乳離れ"
"ちばひがし 千葉東"
"ちばん 地番"
"ちひ 地被"
"ちひつ 遅筆"
"ちひょう 地表"
"ちひろ 馳浩 知宏 千紘 千裕 千尋"
"ちびっこ ちびっ子"
"ちふすきん チフス菌"
"ちふみ 千文"
"ちふゆ 千冬"
"ちぶ 知夫 恥部"
"ちぶくら 乳脹"
"ちぶくろ 乳袋 血袋"
"ちぶさ 乳房"
"ちぶつ 地球物理 地物"
"ちへい 治平 地平"
"ちへど 血反吐"
"ちへん 地変"
"ちべっとご チベット語"
"ちべっとじん チベット人"
"ちべっとぶっきょう チベット仏教"
"ちべん 智辯"
"ちほ 智保 千穂 地歩"
"ちほう 痴呆 地方"
"ちほうさい 地方債"
"ちほうば 地方馬"
"ちぼう 知謀 智謀"
"ちぼしん 地母神"
"ちまき 粡 千巻き 千巻 茅巻き 茅巻 粽"
"ちまた 衢 岐 巷"
"ちまつり 血祭 血祭り"
"ちまなこ 血眼"
"ちまみれ 血まみれ 血塗れ"
"ちまめ 血豆"
"ちみ 魑魅 地味"
"ちみち 血道"
"ちみつ 緻密"
"ちみどろ 血みどろ"
"ちみゃく 地脈"
"ちみん 治民"
"ちむさーちょい 尖沙咀"
"ちむら 地村"
"ちめい 知命 致命 知名 地名"
"ちめいしょう 致命傷"
"ちもう 恥毛"
"ちもく 地目"
"ちもじ 血文字"
"ちもよう 血模様"
"ちゃ 咤 茶"
"ちゃーしゅー 叉焼 焼豚"
"ちゃーしゅーめん チャーシュー麺 叉焼麺"
"ちゃーたーき チャーター機"
"ちゃーたーびん チャーター便"
"ちゃーはん 炒飯"
"ちゃーめん 炒麺"
"ちゃあはん 炒飯"
"ちゃいなふく チャイナ服"
"ちゃいれ 茶入"
"ちゃいろ 茶色"
"ちゃう 茶宇"
"ちゃうじま 茶宇縞"
"ちゃうす 茶臼"
"ちゃえん 茶圓 茶園"
"ちゃお 找"
"ちゃおず 餃子"
"ちゃか 茶化 茶菓"
"ちゃかい 茶会"
"ちゃかぶき 茶香服"
"ちゃがま 茶釜"
"ちゃがゆ 茶粥"
"ちゃがら 茶殻"
"ちゃき 茶木 茶器"
"ちゃきん 茶巾"
"ちゃく 摘 嫡 着"
"ちゃくい 着意 着衣"
"ちゃくいえい 着衣泳"
"ちゃくえき 着駅"
"ちゃくかくにん 着確認"
"ちゃくがい 着外"
"ちゃくがん 着岸 着眼"
"ちゃくこう 着工"
"ちゃくごえ 着声"
"ちゃくさ 着差"
"ちゃくさい 嫡妻 着彩"
"ちゃくざ 着座"
"ちゃくし 嫡子"
"ちゃくしつ 嫡室"
"ちゃくしゅ 着手"
"ちゃくしゅつ 嫡出"
"ちゃくしょう 着床"
"ちゃくしょうぜんしんだん 着床前診断"
"ちゃくしょうまえしんだん 着床前診断"
"ちゃくしょく 着色"
"ちゃくしん 着信"
"ちゃくじ 着磁"
"ちゃくじこく 着時刻"
"ちゃくじつ 着実"
"ちゃくじゅん 着順"
"ちゃくすい 着水"
"ちゃくせい 着生"
"ちゃくせいこん 着生根"
"ちゃくせき 着席"
"ちゃくせつ 着雪"
"ちゃくせん 着船"
"ちゃくそう 着装 着想"
"ちゃくそん 嫡孫"
"ちゃくたい 着帯"
"ちゃくだつ 着脱"
"ちゃくだん 着彈 着弾"
"ちゃくち 着地"
"ちゃくちゃく 着着 着々"
"ちゃくてい 着挺"
"ちゃくてん 着点"
"ちゃくでん 着電"
"ちゃくとう 着到"
"ちゃくなん 嫡男"
"ちゃくに 着荷"
"ちゃくにん 着任"
"ちゃくはつ 着発"
"ちゃくば 着馬"
"ちゃくばらい 着払 着払い"
"ちゃくひつ 着筆"
"ちゃくひょう 着氷"
"ちゃくふく 着服"
"ちゃくぼ 嫡母"
"ちゃくぼう 着帽"
"ちゃくみ 茶くみ"
"ちゃくめろ 着メロ"
"ちゃくもく 着目"
"ちゃくよう 着用"
"ちゃくりく 着陸"
"ちゃくりゅう 嫡流"
"ちゃぐ 茶具"
"ちゃけ 茶家"
"ちゃこし 茶漉し"
"ちゃさじ 茶匙"
"ちゃしつ 茶室"
"ちゃしぶ 茶渋"
"ちゃしゃく 茶杓"
"ちゃじ 茶事"
"ちゃじしちしき 茶事七式"
"ちゃじゅ 茶寿"
"ちゃじゅう 茶頭"
"ちゃじん 茶人"
"ちゃせき 茶席"
"ちゃせん 茶せん 茶筌 茶筅"
"ちゃたく 茶托"
"ちゃたてむし 茶立て虫 茶柱虫 茶立虫"
"ちゃたん 北谷"
"ちゃだい 茶代"
"ちゃだな 茶棚"
"ちゃだんす 茶箪笥"
"ちゃちゃ 茶茶 茶々"
"ちゃっか 着花 着荷 着果 着火"
"ちゃっかん 着艦"
"ちゃっきりぶし ちゃっきり節"
"ちゃっきん 着金"
"ちゃっけん 着剣"
"ちゃっこ 着呼"
"ちゃっこう 着香 着工"
"ちゃつう 茶通"
"ちゃつぼ 茶壷 茶壺"
"ちゃつみ 茶摘み"
"ちゃづけ 茶漬"
"ちゃづつ 茶筒"
"ちゃてい 茶庭"
"ちゃてん 茶店"
"ちゃとう 茶湯"
"ちゃどう 茶道"
"ちゃどころ 茶所"
"ちゃない 茶内"
"ちゃにわ 茶庭"
"ちゃのこ 茶の子"
"ちゃのはら 茶之原"
"ちゃのほん 茶の本"
"ちゃのま 茶の間"
"ちゃのみ 茶飲み"
"ちゃのゆ 茶の湯"
"ちゃはる 察哈爾"
"ちゃば 茶葉"
"ちゃばこ 茶箱"
"ちゃばこだて 茶箱点て"
"ちゃばしら 茶柱"
"ちゃばたけ 茶畠 茶畑"
"ちゃばな 茶花"
"ちゃばなし 茶話"
"ちゃばね 茶羽"
"ちゃばら 茶腹"
"ちゃばん 茶番"
"ちゃぱつ 茶髪"
"ちゃびん 茶瓶"
"ちゃぶ 卓袱"
"ちゃぶうとう 茶封筒"
"ちゃぶくろ 茶袋"
"ちゃぷすい 雑砕"
"ちゃほ 茶舗"
"ちゃぼうき 茶箒"
"ちゃま 茶魔"
"ちゃまめ 茶豆"
"ちゃみ 茶見 茶美 茶味"
"ちゃみず 茶水"
"ちゃみせ 茶店"
"ちゃめ 茶目"
"ちゃめし 茶飯"
"ちゃめっけ 茶目っ気"
"ちゃや 茶屋"
"ちゃやま 茶山"
"ちゃやみち 茶屋道"
"ちゃわ 茶話"
"ちゃわん 茶碗"
"ちゃわんむし 茶碗蒸"
"ちゃんご 杖鼓"
"ちゃんすー 江蘇"
"ちゃんすう 昌洙"
"ちゃんた 全帯"
"ちゃんづけ ちゃん付け"
"ちやこ 千夜子"
"ちゅ 丶"
"ちゅーれんぱおとう 九連宝灯 九連宝燈"
"ちゅう ※ 晝 蟲 寵 鍮 籀 冢 胄 冑 紬 抽 紐 丑 廚 厨 綢 稠 惆 衷 冲 沖 仲 畴 疇 鑄 鋳 儔 躊 籌 肘 酎 紂 誅 柱 註 駐 忠 昼 虫 宙 注 中"
"ちゅうあい 忠愛"
"ちゅうあいてんのう 仲哀天皇"
"ちゅうあつ 中厚"
"ちゅうい 中位 中尉 注意"
"ちゅういがく 中医学"
"ちゅういき 中域"
"ちゅういち 中1 中１ 忠一 中一"
"ちゅういほう 注意報"
"ちゅういん 中陰"
"ちゅうう 中有"
"ちゅうえい 中映 中衛"
"ちゅうえつせんそう 中越戦争"
"ちゅうおう 紂王 中欧 中央"
"ちゅうおうあじあ 中央アジア"
"ちゅうおうあめりか 中央アメリカ"
"ちゅうおういり 中央入"
"ちゅうおうば 中央馬"
"ちゅうおうひがしせん 中央東線"
"ちゅうおうみゃく 中央脈"
"ちゅうおし 中押 中押し"
"ちゅうおん 中音 中温"
"ちゅうか 鋳貨 中夏 中華"
"ちゅうかい 鋳塊 厨芥 注解 仲介"
"ちゅうかいぎしつ 中会議室"
"ちゅうかいてんいき 中回転域"
"ちゅうかく 中隔 中核"
"ちゅうかすーぷ 中華スープ"
"ちゅうかっこ 中かっこ ］ ［ ｝ ｛ 中括弧"
"ちゅうかどんぶり 中華丼"
"ちゅうかなべ 中華鍋"
"ちゅうかはん 中華飯"
"ちゅうかひ 中果皮"
"ちゅうかめん 中華麺"
"ちゅうから 中辛"
"ちゅうかん 中澣 中浣 忠諫 中缶 中環 中巻 昼間 中間"
"ちゅうかんぎ 中間木"
"ちゅうかんだな 中間棚"
"ちゅうかんてすと 中間テスト"
"ちゅうかんとびら 中間扉"
"ちゅうがい 虫害 中外"
"ちゅうがえり 宙返り"
"ちゅうがく 中学"
"ちゅうがた 中形 中型"
"ちゅうがたぎょ 中型魚"
"ちゅうがたけん 中型犬"
"ちゅうがっこう 中学校"
"ちゅうがん 中観"
"ちゅうき 抽気 註記 中気 駐機 注記 中期"
"ちゅうきち 忠吉 中吉"
"ちゅうきぼ 中規模"
"ちゅうきぼうず 中規模渦"
"ちゅうきゅう 仲弓 誅求 中級"
"ちゅうきゅうしゃむけ 中級者向"
"ちゅうきょう 中凶 中共 中京"
"ちゅうきょうしば 中京芝"
"ちゅうきょうしん 中教審"
"ちゅうきょうてんのう 仲恭天皇"
"ちゅうきょく 中曲"
"ちゅうきょり 中距離"
"ちゅうきょりば 中距離馬"
"ちゅうきん 忠勤 鋳金 駐禁"
"ちゅうきんせい 中近世"
"ちゅうきんとう 中近東"
"ちゅうぎ 忠義"
"ちゅうぎょ 虫魚"
"ちゅうぎんじょう 中吟醸"
"ちゅうくう 宙空 中空"
"ちゅうくうしまく 中空糸膜"
"ちゅうくらい 中くらい 中位"
"ちゅうくん 忠君"
"ちゅうぐう 中宮"
"ちゅうぐん 中郡"
"ちゅうけい 中繼 仲兄 中啓 中計 中継"
"ちゅうけん 中研 忠犬 中堅"
"ちゅうけんほ 駐建保"
"ちゅうげきじょう 中劇場"
"ちゅうげん 中間 中言 忠言 中原 中元"
"ちゅうこ 中戸 中古"
"ちゅうこう 昼行 昼光 鋳鋼 中耕 忠孝 中興 中公 中高"
"ちゅうこうぎしつ 中講義室"
"ちゅうこうのそ 中興の祖"
"ちゅうこうもく 中項目"
"ちゅうこく 忠告"
"ちゅうこくふぁんど 中国ファンド"
"ちゅうこん 中根"
"ちゅうごく 中國 中国"
"ちゅうごくかがくいん 中国科学院"
"ちゅうごし 中腰"
"ちゅうごしっくたい 中ゴシック体"
"ちゅうさ 中佐"
"ちゅうさい 中祭 仲裁"
"ちゅうさいしき 中彩色"
"ちゅうさかん 中属"
"ちゅうさつ 駐箚 誅殺"
"ちゅうさん 中3 中３ 注参 昼餐 中産 中三"
"ちゅうざ 中座"
"ちゅうざい 駐在"
"ちゅうざお 中棹"
"ちゅうざら 中皿"
"ちゅうざん 中山"
"ちゅうし 忠死 忠士 注視 中止"
"ちゅうしこく 中四国"
"ちゅうしつ 中執"
"ちゅうしつし 中質紙"
"ちゅうしゃ 注瀉 駐車 注射"
"ちゅうしゃく 註釈 注釈"
"ちゅうしゃしん 注射針"
"ちゅうしゃとう 注射筒"
"ちゅうしゃばり 注射針"
"ちゅうしゃめん 中斜面"
"ちゅうしゅう 中周 仲秋 中秋"
"ちゅうしゅこつ 中手骨"
"ちゅうしゅつ 抽出"
"ちゅうしょ 中書 籀書 中所"
"ちゅうしょう 中生 中将 中称 抽象 中小 中傷"
"ちゅうしょうきぎょうとうきょうどうくみあい 中小企業等協同組合"
"ちゅうしょうぎ 中将棋"
"ちゅうしょく 中食 昼食"
"ちゅうしん 柱心 中震 忠心 注進 衷心 忠臣 中心"
"ちゅうしんぐら 忠臣蔵"
"ちゅうしんせい 中新世"
"ちゅうしんちゅう 中心柱"
"ちゅうじ 忠二 忠司 忠治 中耳"
"ちゅうじく 中軸"
"ちゅうじつ 忠実"
"ちゅうじてん 中辞典"
"ちゅうじゅん 中旬"
"ちゅうじょ 中所 忠恕"
"ちゅうじょう 衷情 柱状 中條 中条 中将"
"ちゅうじょうきゅうしゃ 中上級者"
"ちゅうじょうだん 中上段"
"ちゅうじょうひめ 中将姫"
"ちゅうじょっき 中ジョッキ"
"ちゅうじん 中人"
"ちゅうすい 虫垂 注水"
"ちゅうすう 中枢"
"ちゅうすけ 忠輔"
"ちゅうず 中主"
"ちゅうせい 中正 忠誠 中性 中世"
"ちゅうせいしせい 中性子星"
"ちゅうせいだい 中生代"
"ちゅうせいどうぶつ 中生動物"
"ちゅうせいびし 中性微子"
"ちゅうせいぶ 中西部"
"ちゅうせき 柱石 沖積"
"ちゅうせっきじだい 中石器時代"
"ちゅうせつ 忠節"
"ちゅうせん 抽籤 抽選"
"ちゅうせんきょく 中選挙区"
"ちゅうせんば 抽籤馬"
"ちゅうぜい 中背"
"ちゅうぜつ 中舌 中絶"
"ちゅうぜんじ 中禅寺"
"ちゅうぜんじこ 中禅寺湖"
"ちゅうそ 註疏 柱礎 注疏"
"ちゅうそう 中倉 抽送 中宗 中層"
"ちゅうそううん 中層雲"
"ちゅうそく 中速"
"ちゅうそくこつ 中足骨"
"ちゅうそっこつ 中足骨"
"ちゅうそつ 中卒"
"ちゅうそん 虫損 中尊"
"ちゅうぞう 鑄像 中僧 宙三 忠三 鋳造"
"ちゅうた 宙太"
"ちゅうたい 中諦 柱体 紐帯 中台 中隊 中退"
"ちゅうたんぱ 中短波"
"ちゅうたんぺん 中短編"
"ちゅうだい 中台 中大"
"ちゅうだな 中棚"
"ちゅうだん 中団 中段 中断"
"ちゅうち 中置"
"ちゅうちゅうたいし 駐中大使"
"ちゅうちょ 躊躇"
"ちゅうちょう 中朝 注腸"
"ちゅうちょうき 中長期"
"ちゅうちょうきょり 中長距離"
"ちゅうっぱら 中っ腹"
"ちゅうづり 宙釣り 宙吊り"
"ちゅうてい 中低"
"ちゅうていど 中程度"
"ちゅうてつ 中鉄 鋳鉄"
"ちゅうてん 冲点 沖点 宙天 沖天 ・ 中天 中点"
"ちゅうでん 中伝 中電"
"ちゅうと 中図 中途"
"ちゅうとう 柱棟 中闘 仲冬 中唐 偸盗 柱頭 中等 中東"
"ちゅうとうかい 偸盗戒"
"ちゅうとし 中都市"
"ちゅうとろ 中トロ"
"ちゅうとん 駐屯"
"ちゅうど 中度"
"ちゅうどう 中動 中堂 中道"
"ちゅうどく 中毒"
"ちゅうどしま 中年増"
"ちゅうなごん 中納言"
"ちゅうなん 仲南"
"ちゅうなんべい 中南米"
"ちゅうに 中2 中２ 中二"
"ちゅうにく 中肉"
"ちゅうにち 駐日 中日"
"ちゅうにゅう 注入"
"ちゅうにん 中人"
"ちゅうねん 中年"
"ちゅうねんおとこ 中年男"
"ちゅうのう 中濃 中脳"
"ちゅうのうそーす 中濃ソース"
"ちゅうのり 宙乗り"
"ちゅうは 中破 中波"
"ちゅうはい 酎ハイ"
"ちゅうはいじく 中胚軸"
"ちゅうはいよう 中胚葉"
"ちゅうはば 中幅"
"ちゅうはん 中半 昼飯"
"ちゅうばい 虫媒"
"ちゅうばいか 虫媒花"
"ちゅうばこ 中箱"
"ちゅうばち 中鉢"
"ちゅうばつ 誅罰 誅伐"
"ちゅうばん 注番 中判 中盤"
"ちゅうひ 中飛 中皮"
"ちゅうび 中火"
"ちゅうびん 中瓶"
"ちゅうふう 中風"
"ちゅうふく 中腹"
"ちゅうぶ 中風 中部"
"ちゅうぶう 中風"
"ちゅうぶらり 宙ぶらり"
"ちゅうぶらりん 宙ぶらりん"
"ちゅうぶる 中古"
"ちゅうぶん 籀文 中文"
"ちゅうぶんるい 中分類"
"ちゅうへい 駐兵"
"ちゅうへん 中辺 中篇 中編"
"ちゅうべい 駐米 中米"
"ちゅうべん 中弁"
"ちゅうほーる 中ホール"
"ちゅうほしゃ 仲保者"
"ちゅうほん 中本"
"ちゅうぼう 中坊 厨房"
"ちゅうぼうえん 中望遠"
"ちゅうぼうしょ 中奉書"
"ちゅうぼく 忠僕"
"ちゅうぼそ 中細"
"ちゅうま 中馬"
"ちゅうまど 中窓"
"ちゅうみつ 稠密"
"ちゅうむしょう 中務省"
"ちゅうめん 中免 柱面"
"ちゅうもく 注目"
"ちゅうもくひょう 中目標"
"ちゅうもん 註文 中門 注文"
"ちゅうもんふぉーむ 注文フォーム"
"ちゅうや 中夜 中也 昼夜"
"ちゅうゆ 注油"
"ちゅうゆう 忠勇"
"ちゅうよう 中葉 中庸"
"ちゅうようとっき 虫様突起"
"ちゅうりき 中力"
"ちゅうりきこ 中力粉"
"ちゅうりつ 中立"
"ちゅうりゃく 中略"
"ちゅうりゅう 駐留 中流"
"ちゅうりゅうど 中粒度"
"ちゅうりょ 仲呂"
"ちゅうりょうきゅう 中量級"
"ちゅうりょく 中力 注力"
"ちゅうりん 駐輪"
"ちゅうる 中流"
"ちゅうるい 忠類"
"ちゅうれい 昼礼"
"ちゅうれつ 中裂"
"ちゅうろ 中露"
"ちゅうろう 中臈 柱廊 中老"
"ちゅうろうい 中労委"
"ちゅうろく 中肋"
"ちゅうろん 中論"
"ちゅうわ 中和"
"ちゅちぇしそう チュチェ思想"
"ちゅつ 黜"
"ちゅん 中"
"ちゅんもう 屯蒙"
"ちゅんりー 春麗"
"ちゆ 治癒"
"ちゆう 知勇 知友"
"ちゆき 千幸"
"ちょ 杼 竚 佇 紵 苧 墸 躇 豬 潴 瀦 楮 儲 箸 猪 緒 樗 貯 著"
"ちょいやく ちょい役 チョイ役"
"ちょう 金魚蝨 魚蝨 微 塚 冢 輙 輒 貼 吊 釣 頂 重 弔 鼎 髫 糶 昶 鬯 肇 齠 迢 貂 鵈 樢 蔦 膓 暢 甼 廰 廳 疔 聽 聴 雕 鯛 稠 凋 彫 澂 徴 懲 澄 楪 喋 牒 諜 誂 窕 晁 佻 銚 跳 眺 挑 萇 漲 悵 脹 張 嘲 潮 朝 趙 寵 帖 帳 鳥 調 挺 庁 丁 町 兆 腸 蝶 超 長"
"ちょうあい 帳合い 丁合い 帳合 丁合 寵愛"
"ちょうあく 懲悪"
"ちょうあし 蝶足"
"ちょうあつ 調圧"
"ちょうあん 長安"
"ちょうい 弔意 弔慰 潮位"
"ちょういき 町域"
"ちょういち 長一"
"ちょういちりゅうほてる 超一流ホテル"
"ちょういん 調印"
"ちょううらんげんそ 超ウラン元素"
"ちょううんぼう 朝雲暮雨"
"ちょうえい 町営"
"ちょうえき 腸液 懲役"
"ちょうえつ 超越"
"ちょうえん 長円 兆円 腸炎"
"ちょうおん ー 調音 聴音 潮音 長音"
"ちょうか 弔歌 長夏 町家 長歌 長靴 釣果 超過"
"ちょうかい 嘲詼 鳥海 潮解 聴解 朝会 懲戒 町会"
"ちょうかいぼへん 朝改暮変"
"ちょうかく 弔客 張角 頂角 長角 聴覚"
"ちょうかたる 腸カタル"
"ちょうかん 長寛 長巻 聴感 鳥瞰 腸管 長官 朝刊"
"ちょうかんかく 聴感覚"
"ちょうかんまく 腸間膜"
"ちょうが 頂芽"
"ちょうがい 鳥害 町外"
"ちょうがいふじ 超涯不次"
"ちょうがく 重学 調楽"
"ちょうがくりょう 張学良"
"ちょうがた 蝶形"
"ちょうがん 腸癌"
"ちょうき 弔旗 寵姫 長期"
"ちょうきち 長吉"
"ちょうきゃく 弔客"
"ちょうきゅう 超球 長久"
"ちょうきゅうめい 長久命"
"ちょうきょ 聴許"
"ちょうきょう 長享 調教"
"ちょうきょり 長距離"
"ちょうきょりそう 長距離走"
"ちょうきょりば 長距離馬"
"ちょうきょりばす 長距離バス"
"ちょうきょりらんなー 長距離ランナー"
"ちょうきん 超勤 彫金"
"ちょうぎ 嘲戯 朝儀 張儀 朝議 町議"
"ちょうぎゃく 嘲謔"
"ちょうぎょ 釣魚"
"ちょうぎん 朝銀"
"ちょうく 長句 長躯 長駆"
"ちょうくうかん 聴空間"
"ちょうぐう 寵遇"
"ちょうけい 蝶形 長計 長形 長径 長兄"
"ちょうけいか 蝶形花"
"ちょうけいてんのう 長慶天皇"
"ちょうけし 帳消し"
"ちょうけつ 長欠"
"ちょうけん 朝権 聴検 朝憲 長絹 朝見 長剣"
"ちょうげん 超限 超弦 長元 調弦"
"ちょうこう 嘲詬 調貢 釣鉤 超高 長講 調香 朝貢 長考 潮紅 釣行 徴候 調光 聴講 長江 兆候"
"ちょうこうさ 潮候差"
"ちょうこうぜつ 長広舌"
"ちょうこく 肇国 超克 彫刻"
"ちょうこくぐざ 彫刻具座"
"ちょうこくしつざ 彫刻室座"
"ちょうこくとう 彫刻刀"
"ちょうこつ 腸骨"
"ちょうこん 長恨"
"ちょうご 釣語 鳥語 長後"
"ちょうごう 調号 調合"
"ちょうごんか 長恨歌"
"ちょうさ 潮差 長沙 調査"
"ちょうさい 兆載 弔祭"
"ちょうさん 張三 逃散"
"ちょうさんど 長三度"
"ちょうさんぼし 朝三暮四"
"ちょうさんわおん 長三和音"
"ちょうざ 長座"
"ちょうざい 聴罪 調剤"
"ちょうざめ 蝶鮫"
"ちょうざんぞう 長残像"
"ちょうし 冢祀 弔詩 弔詞 長詩 聴視 長姉 長子 銚子 調子"
"ちょうしつ 彫漆 調湿"
"ちょうしぶえ 調子笛"
"ちょうしゃ 聴者 庁舎"
"ちょうしゃく 長尺"
"ちょうしゃてい 長射程"
"ちょうしゅ 長酒 頭首 町衆 聴取"
"ちょうしゅう 長洲 張州 町衆 徴集 釣舟 長州 聴衆 徴収"
"ちょうしゅうかく 聴衆各"
"ちょうしゅうき 長周期"
"ちょうしゅつ 超出"
"ちょうしゅん 長春"
"ちょうしょ 弔書 調所 調書 長所"
"ちょうしょう 寵妾 徴証 長嘯 長承 弔鐘 嘲笑"
"ちょうしょく 調色 朝食"
"ちょうしん 調進 寵臣 朝臣 長針 聴診 長身"
"ちょうしんけい 聴神経"
"ちょうしんるこつ 彫心鏤骨"
"ちょうじ 懲治 長治 丁字 丁子 弔辞 寵児 弔事"
"ちょうじあぶら 丁子油"
"ちょうじかん 長時間"
"ちょうじく 長軸"
"ちょうじつ 長日"
"ちょうじつせい 超日性"
"ちょうじゃ 長者"
"ちょうじゃがさき 長者ヶ崎"
"ちょうじゃく 長尺"
"ちょうじゅ 長寿"
"ちょうじゅう 聴従 鳥獣"
"ちょうじゅうろう 長十郎"
"ちょうじゅみょう 長寿命"
"ちょうじゅん 超準"
"ちょうじょ 長女"
"ちょうじょう 超乗 牒状 長上 長城 重畳 超常 頂上"
"ちょうじり 帳尻"
"ちょうじろう 長次郎"
"ちょうじん 超神 釣人 鳥人 超人"
"ちょうすいろ 長水路"
"ちょうすけ 長介"
"ちょうず 手水"
"ちょうずばち 手水鉢"
"ちょうせい 調声 頂生 長逝 朝政 長征 町制 町政 長生 調性 調製 調整"
"ちょうせいきゅう 調整給"
"ちょうせいち 調整池"
"ちょうせき 腸石 彫石 長石 潮汐"
"ちょうせつ 調節"
"ちょうせん 庁宣 腸腺 腸線 貂蝉 朝鮮 挑戦"
"ちょうせんあめ 朝鮮飴"
"ちょうせんそうれん 朝鮮総連"
"ちょうぜい 町税 徴税"
"ちょうぜつ 超絶"
"ちょうぜん 長髯 超然"
"ちょうそ 徴租 重祚 彫塑"
"ちょうそう 鳥葬"
"ちょうそかべ 長宗我部"
"ちょうそがべ 長宗我部"
"ちょうそく 長足"
"ちょうそくき 調速機"
"ちょうそん 長孫 町村"
"ちょうぞう 長蔵 彫像"
"ちょうぞく 超俗"
"ちょうたい 調帯 長体"
"ちょうたいそく 長大息"
"ちょうたく 彫琢"
"ちょうたつ 暢達 調達"
"ちょうたつこすと 調達コスト"
"ちょうたろう 長太郎"
"ちょうたん 頂端 超短 長短"
"ちょうたんい 兆単位"
"ちょうたんそく 長嘆息"
"ちょうだ 長蛇 長打"
"ちょうだい 朝大 鳥大 長大 頂戴"
"ちょうだつ 超脱"
"ちょうだのれつ 長蛇の列"
"ちょうだん 跳弾"
"ちょうちかく 聴知覚"
"ちょうちふす 腸チフス"
"ちょうちゃく 打擲"
"ちょうちゅう 頂肘"
"ちょうちょ 蝶々"
"ちょうちょう 蝶蝶 喋々 蝶々 長調 町長"
"ちょうちょううお 蝶々魚 蝶蝶魚"
"ちょうちょうなんなん 喋々喃々 喋喋喃喃"
"ちょうちょうはっし 丁々発止"
"ちょうちょうぼぼ 朝々暮々 朝朝暮暮"
"ちょうちん 提灯"
"ちょうつがい 蝶番"
"ちょうづけ 丁付け 丁付"
"ちょうづめ 腸詰"
"ちょうづら 帳面"
"ちょうてい 超低 長堤 調定 朝廷 調停"
"ちょうていきょくほ 長汀曲浦"
"ちょうてき 朝敵"
"ちょうてじゅん 長手順"
"ちょうてつ 澄徹"
"ちょうてん 長点 頂点"
"ちょうでん 長電 弔電"
"ちょうと 長途"
"ちょうとう 長刀"
"ちょうとく 長徳"
"ちょうど 調度 丁度"
"ちょうどう 庁堂 町道"
"ちょうどういん 朝堂院"
"ちょうどうけん 聴導犬"
"ちょうな 鐇 手斧"
"ちょうない 腸内 町内"
"ちょうなん 嘲難 長南 長男"
"ちょうにゅう 調乳"
"ちょうにん 町人"
"ちょうねくたい 蝶ネクタイ"
"ちょうねんげつ 長年月"
"ちょうねんてん 腸捻転"
"ちょうねんまく 腸粘膜"
"ちょうの 蝶野"
"ちょうのつぼ 町坪"
"ちょうは 調波 長波"
"ちょうはい 停廃 朝拝"
"ちょうはずれ 帳外れ"
"ちょうはつ 挑撥 調髪 徴発 長髪 挑発"
"ちょうはながた 蝶花形"
"ちょうはん 丁半"
"ちょうはんげんき 長半減期"
"ちょうば 嘲罵 跳馬 帳場"
"ちょうばいか 鳥媒花"
"ちょうばく 帳幕"
"ちょうばつ 懲罰"
"ちょうばん 丁番"
"ちょうひ 張飛"
"ちょうひもりろん 超紐理論"
"ちょうひょう 帳表 徴憑 徴表 帳票"
"ちょうび 掉尾"
"ちょうびけい 長尾鶏"
"ちょうびょう 長病"
"ちょうびるい 長鼻類"
"ちょうふ 長府 調布 貼付"
"ちょうふく 重複"
"ちょうぶ 町歩 頂部"
"ちょうぶく 調伏"
"ちょうぶつ 長物"
"ちょうぶん 弔文 長文"
"ちょうへい 長兵 長平 徴兵"
"ちょうへいそく 腸閉塞"
"ちょうへき 腸壁"
"ちょうへん 長辺 長篇 長編"
"ちょうへんせい 長編成"
"ちょうほ 調歩"
"ちょうほう 弔砲 調法 長方 長保 諜報 重宝"
"ちょうほん 張本"
"ちょうぼ 徴募 帳簿"
"ちょうぼいん 長母音"
"ちょうぼう 眺望"
"ちょうぼん 超凡"
"ちょうまつ 長松"
"ちょうまる 朝丸"
"ちょうみ 調味"
"ちょうみつ 稠密"
"ちょうみん 兆民 町民"
"ちょうむ 庁務"
"ちょうむすび 蝶結び"
"ちょうめ 丁目"
"ちょうめい 朝命 澄明 長明 長命 町名"
"ちょうめいれいご 長命令語"
"ちょうめん 帖面 帳面"
"ちょうもう 長毛"
"ちょうもく 鳥目"
"ちょうもくひじ 長目飛耳"
"ちょうもつ 寵物"
"ちょうもと 帳元"
"ちょうもん 長門 頂門 弔問 聴聞"
"ちょうもんのいっしん 頂門の一針"
"ちょうや 聴野 長夜"
"ちょうやく 調薬 重訳 超訳 跳躍"
"ちょうやくにん 町役人"
"ちょうゆう 町有"
"ちょうよう 町陽 長幼 朝陽 重陽 徴用 重用"
"ちょうようのじょ 長幼の序"
"ちょうらい 頂礼 朝来"
"ちょうらく 長楽 凋落"
"ちょうり 嘲詈 蝶理 調理"
"ちょうりつ 調律 町立"
"ちょうりなべ 調理鍋"
"ちょうりゃく 長暦 調略"
"ちょうりゅう 潮流"
"ちょうりゅうしゅ 長粒種"
"ちょうりゅうまい 長粒米"
"ちょうりょう 潮陵 跳梁"
"ちょうりょく 潮力 張力 聴力"
"ちょうるい 鳥類"
"ちょうれい 長齢 凋零 町礼 朝礼"
"ちょうれいか 張麗華"
"ちょうれいぼかい 朝令暮改"
"ちょうれん 長連 調練"
"ちょうろ 朝露"
"ちょうろう 嘲弄 長老"
"ちょうろぎ 草石蚕"
"ちょうろく 長禄"
"ちょうわ 長和 調和"
"ちょき 猪牙"
"ちょきぶね 猪牙舟"
"ちょきん 貯金"
"ちょきんばこ 貯金箱"
"ちょく 陟 躅 稙 敕 飭 捗 猪口 勅 直"
"ちょくえい 直衛 直営"
"ちょくえん 直掩"
"ちょくおう 直往"
"ちょくおん 直音"
"ちょくか 直下"
"ちょくがん 勅願"
"ちょくげき 直撃"
"ちょくげきだん 直撃弾"
"ちょくげん 直言"
"ちょくご 勅語 直後"
"ちょくさ 直鎖"
"ちょくさい 勅裁 直裁 直截"
"ちょくし 勅旨 勅使 直視"
"ちょくしゃ 直写 直射"
"ちょくしゅつ 直出"
"ちょくしょ 勅書"
"ちょくしょう 勅詔"
"ちょくしん 直進"
"ちょくじ 植字 直示"
"ちょくじつ 直実"
"ちょくじゅ 勅授"
"ちょくじょ 直叙"
"ちょくじょう 勅諚 勅定 直情 直上"
"ちょくせい 直生"
"ちょくせき 直積"
"ちょくせつ 直説 直截 直接"
"ちょくせつこう 直接光"
"ちょくせつばち 直接鉢"
"ちょくせん 勅撰 直線"
"ちょくぜい 直税"
"ちょくぜん 直前"
"ちょくそう 直送"
"ちょくぞく 直属"
"ちょくたつ 直達"
"ちょくだい 勅題"
"ちょくちょう 直腸"
"ちょくちょうがん 直腸ガン 直腸がん"
"ちょくつう 直通"
"ちょくで 直出"
"ちょくとう 直答 勅答 直刀"
"ちょくどう 直動 直道"
"ちょくどく 直読"
"ちょくにゅう 直入"
"ちょくにん 勅任"
"ちょくはい 直配"
"ちょくはん 勅版 直播 直販"
"ちょくばい 直売"
"ちょくひつ 直筆"
"ちょくふ 直付"
"ちょくほう 直方"
"ちょくめい 勅命"
"ちょくめん 直面"
"ちょくもう 直毛"
"ちょくやく 直訳"
"ちょくゆ 勅諭 直喩"
"ちょくりつ 直立"
"ちょくりつけい 直立茎"
"ちょくりつし 直立枝"
"ちょくりゅう 直流"
"ちょくれい 直隷 勅令"
"ちょくれつ 直列"
"ちょくろ 直路"
"ちょくわ 直和"
"ちょげん 緒言"
"ちょこ 猪口"
"ちょこあじ チョコ味"
"ちょこう 著効"
"ちょこざい 猪口才"
"ちょこれーと 貯古齢糖"
"ちょこれーといろ チョコレート色"
"ちょさく 著作"
"ちょさくけんじゃ 著作権者"
"ちょさくけんぽうじょう 著作権法上"
"ちょし 楮紙"
"ちょしゃ 著者"
"ちょしょ 著書"
"ちょじゅつ 著述"
"ちょすい 貯水"
"ちょすいち 貯水池"
"ちょすかべ 長宗我部"
"ちょせん 緒戦"
"ちょぞう 著増 貯蔵"
"ちょぞうこん 貯蔵根"
"ちょたん 貯炭"
"ちょだい 著大"
"ちょちく 貯蓄"
"ちょっか 直下"
"ちょっかい 直快"
"ちょっかく ⊥ 直覚 直角"
"ちょっかっこう 直滑降"
"ちょっかつ 直轄"
"ちょっかん 直諫 直管 直観 直感"
"ちょっかんひりつ 直間比率"
"ちょっき 直帰"
"ちょっきゅう 直球"
"ちょっきょ 勅許"
"ちょっきん 直近"
"ちょっけい 直系 直径"
"ちょっけいやく 直径約"
"ちょっけつ 直結"
"ちょっこう ⊥ 直航 直交 直行"
"ちょっこうわ 直交和"
"ちょっこん 直根"
"ちょっと 一寸"
"ちょっとみ 一寸見"
"ちょとつ 猪突"
"ちょはっかい 猪八戒"
"ちょびひげ ちょび髭"
"ちょぶん 著聞"
"ちょへん 著変"
"ちょぼ 樗蒲 点"
"ちょぼいち 樗蒲一"
"ちょぼがたり 点語り"
"ちょぼく 貯木 樗木"
"ちょま 苧麻"
"ちょめい 著明 著名"
"ちょめちょめ ××"
"ちょりつ 佇立"
"ちょりゅう 貯留"
"ちょろぎ 甘露子 草石蚕"
"ちょろく 著録"
"ちょろん 緒論"
"ちょんがー 総角"
"ちょんぼ 錯和"
"ちょんまげ 丁髷"
"ちょんりま 千里馬"
"ちよ 千夜 千代"
"ちよかわ 千代川"
"ちよくら 千代倉"
"ちよこ 千代子"
"ちよだ 千代田"
"ちよの 千代乃"
"ちよろず 千万"
"ちらく 地落 地絡"
"ちらし 散らし"
"ちらしずし 散らし鮨 ちらし寿司"
"ちらん 治乱 知覧"
"ちり 智利 知里 塵 地理"
"ちりあくた 塵芥"
"ちりいん 地理院"
"ちりがみ チリ紙 ちり紙 塵紙"
"ちりぎわ 散り際"
"ちりけ 身柱"
"ちりぢり 散り散り"
"ちりとり 塵取"
"ちりなべ ちり鍋"
"ちりはま 千里浜"
"ちりひじ 塵泥"
"ちりほこり 塵埃"
"ちりましほ 知里真志保"
"ちりめん 縮緬"
"ちりゃく 治略 智略 知略"
"ちりゅう 知立"
"ちりょ 智慮 知慮"
"ちりょう 治療"
"ちりょく 地力 知力"
"ちれい 地霊"
"ちれき 地歴"
"ちろう 遅漏"
"ちろうい 地労委"
"ちわ 痴話"
"ちわく 地惑"
"ちわり 地割り 地割"
"ちわんぞく チワン族"
"ちん 鎭 珎 趁 抻 闖 碪 砧 椿 鎮 陳 亭 鴆 枕 沈 狆 朕 賃 珍"
"ちんあげ 賃上げ"
"ちんあつ 鎮圧"
"ちんあん 珍案"
"ちんいーそー 清一色"
"ちんうつ 沈鬱"
"ちんか 鎮火 沈下"
"ちんかきょう 沈下橋"
"ちんかさい 鎮花祭"
"ちんがいざい 鎮咳剤"
"ちんがし 賃貸し"
"ちんがり 賃借り"
"ちんき 丁幾 珍奇"
"ちんきゃく 珍客"
"ちんきゅう 陳宮"
"ちんきん 賃金 沈金"
"ちんぎょ 珍魚"
"ちんぎょらくがん 沈魚落雁"
"ちんぎん 沈吟 賃銀 賃金"
"ちんぐるま 稚児車"
"ちんけいやく 鎮痙薬"
"ちんげい 珍芸"
"ちんげんさい 青梗菜"
"ちんこう 沈香 鎮江 沈降"
"ちんこん 鎮魂"
"ちんこんきしん 鎮魂帰神"
"ちんご 珍語 陳呉 鎮護"
"ちんさ 沈渣"
"ちんさげ 賃下げ"
"ちんざ 鎮座"
"ちんざんそう 椿山荘"
"ちんし 沈思"
"ちんしごと 賃仕事"
"ちんしゃ 陳謝"
"ちんしゃく 賃借"
"ちんしゃち 沈砂池"
"ちんしゅ 珍手 珍種"
"ちんしょ 砧杵 陳書 珍書"
"ちんしょう 沈鐘 沈床"
"ちんしょうごこう 陳勝呉広"
"ちんじ 椿事 珍事"
"ちんじゃおろーす 青椒肉絲"
"ちんじゃおろーすー 青椒肉絲"
"ちんじゅ 珍寿 鎮守"
"ちんじゅう 珍獣 珍重"
"ちんじゅつ 陳述"
"ちんじょう 陳状 枕上 陳情"
"ちんすい 沈水"
"ちんせい 鎮星 沈静 鎮静"
"ちんせき 枕席 珍籍 珍石 沈積"
"ちんせつ 沈設 珍説"
"ちんせん 賃銭 沈潜 沈船"
"ちんぜい 鎮西"
"ちんそ 賃租"
"ちんそうだん 珍走団"
"ちんぞう 珍蔵"
"ちんたい 沈滞 賃貸"
"ちんたいあぱーと 賃貸アパート"
"ちんたいしゃく 賃貸借"
"ちんたいまんしょん 賃貸マンション"
"ちんたお 青島"
"ちんだい 鎮台"
"ちんだるげんしょう チンダル現象"
"ちんだん 沈檀 珍談"
"ちんちゃく 沈着"
"ちんちょう 珍鳥 珍重"
"ちんちょうげ 沈丁花"
"ちんちん 沈々"
"ちんつう 沈痛 鎮痛"
"ちんてい 鎮定"
"ちんでき 沈溺"
"ちんでん 沈澱 沈殿"
"ちんとう 珍答 枕頭"
"ちんとうご 陳套語"
"ちんとうびょう 沈頭鋲"
"ちんどうしき 沈胴式"
"ちんどく 鴆毒"
"ちんどんや ちんどん屋 チンドン屋"
"ちんにゅう 闖入"
"ちんねん 珍念"
"ちんば 跛"
"ちんばん 珍盤"
"ちんぱん 青幇"
"ちんぴ 陳皮"
"ちんぴん 珍品"
"ちんぶ 鎮撫"
"ちんぶつ 珍物"
"ちんぶん 珍聞"
"ちんぷ 陳腐"
"ちんぷれー 珍プレー"
"ちんぷんかん 珍糞漢 珍紛漢"
"ちんぷんかんぷん 珍紛漢紛"
"ちんべん 陳弁"
"ちんぺい 陳平"
"ちんぺん 枕辺"
"ちんぼつ 沈没"
"ちんぽう 珍宝"
"ちんぽこ 似指"
"ちんぽん 珍本"
"ちんみ 珍味"
"ちんみょう 珍妙"
"ちんめい 珍名"
"ちんめん 沈湎"
"ちんもく 沈黙"
"ちんもん 珍問"
"ちんようざい 鎮痒剤"
"ちんらおとう 清老頭"
"ちんりつ 賃率"
"ちんりょう 賃料"
"ちんりん 沈淪"
"ちんれつ 陳列"
"ちんれつだな 陳列棚"
"ちんれつまど 陳列窓"
"ちんろうどう 賃労働"
"ぢ 地 痔"
"ぢあけ 地上げ"
"ぢえ 知恵"
"ぢか 近 直"
"ぢから 力"
"ぢくぢ 忸怩"
"ぢぐち 地口"
"ぢげ 地下"
"ぢごく 地獄"
"ぢさん 持参"
"ぢざけ 地酒"
"ぢしん 地震"
"ぢぞく 持続"
"ぢだい 地代"
"ぢとり 地鶏"
"ぢどり 地鶏"
"ぢば 地場"
"ぢばく 地縛"
"ぢひびき 地響き"
"ぢふぶき 地吹雪"
"ぢみ 地味"
"ぢみち 地道"
"ぢめん 地面"
"ぢもと 地元"
"ぢゃわん 茶碗"
"ぢゅう 中"
"ぢょうし 調子"
"っこ っ子"
"つ ツ つ 積 付 通 都 津"
"つーいーそー 字一色"
"つーばいふぉー ２×４"
"つーぱい 字牌"
"つーもー 自摸"
"つぁいちぇん 再見"
"つい 築 對 遂 墜 堆 椎 縋 槌 鎚 終 追 対"
"ついう 堆烏"
"ついえ 毅"
"ついおく 追憶"
"ついか 追加"
"ついかい 追懐"
"ついかん 追完"
"ついかんばん 椎間板"
"ついかんばんへるにあ 椎間板ヘルニア"
"ついがいねん 対概念"
"ついき 立木 鎚起 築城 追記"
"ついきそ 追起訴"
"ついきゅう 追給 椎弓 追究 追及 追求"
"ついきん 追金"
"ついぎご 対義語"
"ついく 対句"
"ついげき 追撃"
"ついげんそう 対幻想"
"ついこう 追考 追行"
"ついこうちゅう 遂行中"
"ついこく 堆黒"
"ついこつ 椎骨"
"ついご 対語"
"ついごう 追号"
"ついし 追諡 追思 墜死 追試"
"ついしけん 追試験"
"ついしゅ 堆朱 追修"
"ついしゅつ 追出"
"ついしょう 追従"
"ついしょうめつ 対消滅"
"ついしん 追伸"
"ついじ 築墻 築地"
"ついじっけん 追実験"
"ついじべい 築地塀"
"ついじゅう 追従"
"ついじゅく 追熟"
"ついじん 追尋"
"ついすう 対数"
"ついずい 追随"
"ついせいせい 対生成"
"ついせき 追惜 追跡"
"ついせん 対線"
"ついぜん 追善"
"ついそ 追訴"
"ついそう 追送 追想 追走"
"ついそうけん 追送検"
"ついぞ 終ぞ"
"ついぞう 追贈"
"ついたい 椎体"
"ついたいけん 追体験"
"ついたち １日 朔日 一日"
"ついたて 衝立"
"ついだつ 追奪"
"ついちょう 追徴"
"ついて 就て 就いて"
"ついで 序 尋いで 次いで 序で"
"ついでに 序でに"
"ついとう 追討 追悼"
"ついとつ 追突"
"ついな 都維那 追儺"
"ついに 終に 遂に"
"ついにん 追認"
"ついのう 追納"
"ついのすみか 終の住み処 終の栖"
"ついひ 追肥"
"ついび 追尾"
"ついふく 追復 追捕"
"ついぶ 追捕"
"ついほ 追捕 追補"
"ついほう 追放"
"ついぼ 追慕"
"ついらく 墜落"
"ついろく 追録"
"つう 痛 通"
"つういいそう 字一色"
"つういん 痛飲 通院"
"つううん 通運"
"つうえん 通園"
"つうか 通貨 通過"
"つうかい 痛悔 通快 通解 痛快"
"つうかく 通客 痛覚"
"つうかん 通観 通巻 通関 痛感"
"つうがく 通学"
"つうき 通気 通期"
"つうきこう 通気孔"
"つうきゅう 通級"
"つうきん 通勤"
"つうきんらっしゅ 通勤ラッシュ"
"つうぎょう 通暁"
"つうく 痛苦"
"つうけい 通計"
"つうけん 東北大学電気通信研究所 電気通信研究所 通研"
"つうげき 痛撃"
"つうげん 痛言"
"つうこう 通功 通工 通交 通好 通航 通行"
"つうこうどめ 通行止 通行止め"
"つうこく 痛哭 通告"
"つうこん 痛恨"
"つうこんじ 痛恨事"
"つうご 通語"
"つうごう 通号"
"つうごのみ 通好み"
"つうさん 通産 通算"
"つうさんげつ 通算月"
"つうさんしょう 通商産業省"
"つうし 通史"
"つうしき 通式"
"つうしゃく 通釈"
"つうしょ 通書 通所"
"つうしょう 通商 通称"
"つうしん 痛心 通信"
"つうしんがたじゅしんき 通信型受信機"
"つうしんけーぶる 通信ケーブル"
"つうしんし 通信使"
"つうじ 通じ 通辞 通詞 通事 通時"
"つうじかい 通字解"
"つうじゅく 通塾"
"つうじょう 通常"
"つうじょうだん 通常弾"
"つうじん 通人"
"つうすい 通水"
"つうせい 通性"
"つうせき 痛惜"
"つうせつ 痛切 通説"
"つうそう 通奏"
"つうそうけん 通総研"
"つうそく 通則"
"つうぞく 通俗"
"つうたつ 通達"
"つうたん 痛歎 痛嘆"
"つうだ 痛打"
"つうち 通知"
"つうちょう 通牒 通帳"
"つうてい 通底"
"つうてん 痛点"
"つうてんかく 通天閣"
"つうでん 通電"
"つうどう 通導 通洞"
"つうどく 通読"
"つうねん 通念 通年"
"つうはん 通販"
"つうば 痛罵"
"つうばん 通番"
"つうぱい 字牌"
"つうひ 通臂 通費"
"つうふう 通風 痛風"
"つうふん 痛憤"
"つうぶん 通分"
"つうへい 通弊"
"つうほう 通宝 通報"
"つうぼう 痛棒 通謀"
"つうめ 通目"
"つうめい 通名"
"つうや 通夜"
"つうやく 通約 通訳"
"つうゆう 通有"
"つうよう 痛痒 通用"
"つうらい 通来"
"つうらん 通覧"
"つうりき 通力"
"つうれい 通例"
"つうれつ 痛烈"
"つうろ 通路"
"つうろん 痛論 通論"
"つうわ 通話"
"つえ 丈 拐 杖"
"つえはしら 杖柱"
"つか 冢 束 塚 柄"
"つかあな 塚穴"
"つかい 遣い 使い"
"つかいし 束石"
"つかいすて 使い棄て 使い捨て"
"つかいっぱしり 使いっ走り"
"つかいで 使いで"
"つかいばしり 使い走り"
"つかいふるし 使い古し"
"つかいみち 使い途 使い道"
"つかいもの 使いもの"
"つかえ 仕え"
"つかがしら 柄頭"
"つかくち 塚口"
"つかぐち 塚口"
"つかこし 塚越"
"つかごし 塚越"
"つかさ 寮 阜 曹 丘 官 首 長 元 司"
"つかさびと 官人"
"つかさめし 司召"
"つかしま 塚島"
"つかずはなれず 付かず離れず"
"つかたに 塚谷"
"つかだ 束田 塚田"
"つかぬこと 付かぬ事"
"つかの 塚野"
"つかのあいだ 束の間"
"つかのま 束の間"
"つかのめ 塚目"
"つかはら 束原 塚原"
"つかみ 掴み"
"つかみほん 束見本"
"つかむ 攫 搏"
"つかもと 塚本"
"つかれ 疲れ"
"つかわれかた 使われ方"
"つが 都賀 栂"
"つがい 津飼 番い 番"
"つがいけ 栂池"
"つがいまい 番舞"
"つがる 津軽"
"つがるぬり 津軽塗"
"つがわ 対川 津川"
"つがん 通鑑"
"つき 憑き 欟 築 尽き 突き 付き 付 槻 坏 月"
"つきあい 付合 付合い 付き合い"
"つきあげぐん 築上郡"
"つきあし 月足"
"つきあたま 月頭"
"つきあたり 突当り"
"つきあわせ 突き合せ 突合せ"
"つきいち 月イチ 月一"
"つきうま 付き馬"
"つきおか 月岡"
"つきかげ 月影"
"つきかず 月数"
"つきがさ 月暈"
"つきがせ 月ヶ瀬"
"つきがた 月形"
"つきがわり 月代り 月替わり"
"つききず 突き傷"
"つきぎめ 月極め"
"つきぎめちゅうしゃじょう 月極駐車場"
"つきぎり 月限"
"つきぐみ 月組"
"つきげ 鴾毛 月毛"
"つきこ 月子"
"つきごと 月毎"
"つきごめ 搗き米"
"つきごろ 月頃"
"つきさっぷ 月寒"
"つきさむ 月寒"
"つきしま 月島"
"つきしろ 月白"
"つきじ 築地"
"つきじろ 月白"
"つきすう 月数"
"つきずえ 月末"
"つきそい 付添い 付添"
"つきたおし 突き倒し"
"つきたて 月舘"
"つきだし 突出し"
"つきだて 月舘 築館"
"つきっきり 付きっ切り"
"つきづき 月々"
"つきなみ 槻並 月次 月並"
"つきの 月野"
"つきのいり 月の入り"
"つきのき 槻木"
"つきのさわり 月の障り"
"つきので 月の出"
"つきのみ 突き鑿"
"つきのもの 月の物"
"つきのわ 月の輪"
"つきのわぐま 月輪熊"
"つきばん 月番"
"つきひ 月日"
"つきひめ 月姫"
"つきびと 付人 付き人"
"つきへん 月偏"
"つきべつ 月別"
"つきぼし 月星"
"つきまいり 月参り"
"つきみ 月見"
"つきみそう 月見草"
"つきもの つき物 付物"
"つきもり 月森"
"つきやく 月役"
"つきやま 築山"
"つきゆきはな 月雪花"
"つきゆび 突き指"
"つきよ 月夜"
"つきよだ 月夜田"
"つきよの 月夜野"
"つきわり 月割"
"つぎ 次"
"つぎお 次夫 次雄 次男"
"つぎがみ 継紙"
"つぎき 継木 継ぎ木 接木"
"つぎきれ 継切"
"つぎくち 注ぎ口"
"つぎぐち 注ぎ口"
"つぎしきし 継色紙"
"つぎつぎ 次々"
"つぎて 接手 継ぎ手 継手"
"つぎのすけ 継之助"
"つぎのま 次の間"
"つぎはぎ 継ぎ接ぎ"
"つぎぶし 次節"
"つぎほ 接ぎ穂"
"つぎめ 継目 継ぎ目"
"つぎもの 継ぎ物"
"つく 津久 筑"
"つくい 津久井"
"つくいこ 津久井湖"
"つくいはま 津久井浜"
"つくえ 机"
"つくえがた 机型"
"つくし 土筆 筑紫"
"つくしごと 筑紫箏"
"つくだ 附田 佃"
"つくだじま 佃島"
"つくだに 佃煮"
"つくつくぼうし つくつく法師"
"つくづく 熟々 熟"
"つくで 作手"
"つくと 津久戸"
"つくね 築根"
"つくば 筑波"
"つくばい 蹲踞"
"つくばし つくば市"
"つくばだいがくだい 筑波大学第"
"つくばね 筑波嶺"
"つくぼう 突棒"
"つくみ 津久見"
"つくも 九十九"
"つくもがみ 九十九髪 付喪神"
"つくよ 月夜"
"つくよみ 月讀み 月読み"
"つくり 造り 旁 傍 作り"
"つくりうた 作り唄 作り歌"
"つくりざかや 造酒屋 造り酒屋"
"つくろい 繕 繕い"
"つぐ 嗣 継 津具"
"つぐお 嗣雄"
"つぐとし 次利"
"つぐとも 嗣朋 嗣智"
"つぐない 償い"
"つぐのぶ 嗣信"
"つぐみ 鶫"
"つぐも 津雲"
"つけ 付け 附け 漬 漬け 付"
"つけあい 付合"
"つけあわせ 付け合せ"
"つけいた ツケ板 付け板"
"つけうま 付け馬"
"つけかえ 付替"
"つけく 付句"
"つけぐすり 付け薬"
"つけげ 付け毛"
"つけこみちょう 付込帳"
"つけさげ 付下げ"
"つけじる 付汁"
"つけたり 付けたり"
"つけだけ 付竹"
"つけち 付知"
"つけづめ 付け爪"
"つけな 漬菜"
"つけね 付け値 付け根"
"つけばしら 付け柱 付柱"
"つけひげ 付け髭"
"つけび 付け火"
"つけびと 付け人"
"つけぶみ 付け文"
"つけもの 漬物"
"つけものいし 漬物石"
"つけやきば 付焼き刃 付焼刃"
"つげ 都祁 告げ 柘 柘植"
"つごう 都合"
"つごもり 晦日 晦"
"つさか 津坂"
"つざき 津崎"
"つし 都志 津市"
"つしま 津嶋 對馬 津島 対馬"
"つしまかなめ 津島要"
"つしまなか 津島中"
"つじ 旋毛 辻"
"つじい 辻井"
"つじうら 辻占"
"つじうらない 辻占い"
"つじおか 辻岡"
"つじかわ 辻川"
"つじがどう 辻ヶ堂"
"つじぎみ 辻君"
"つじぎり 辻斬り"
"つじぐるま 辻車"
"つじげいにん 辻芸人"
"つじさわ 辻沢"
"つじした 辻下"
"つじせっぽう 辻説法"
"つじた 辻田"
"つじつじ 辻々"
"つじつま 辻褄"
"つじどう 辻堂"
"つじの 辻野"
"つじばしゃ 辻馬車"
"つじむら 辻村"
"つじもと 辻元 辻本"
"つずき 都築"
"つた 樢 蔦"
"つたえ 伝え"
"つたかずら 蔦葛"
"つたき 津滝"
"つたない 拙い"
"つたや 蔦屋"
"つだ 津田"
"つだぬま 津田沼"
"つち 壌 椎 鎚 槌 土"
"つちい 土居 土井"
"つちいじり 土弄り"
"つちいっき 土一揆"
"つちいろ 土色"
"つちうら 土浦"
"つちおと 槌音"
"つちかべ 土壁"
"つちかわ 土川"
"つちがた 土型"
"つちくれ 土くれ 土塊"
"つちぐも 蝪 土蜘蛛"
"つちぐら 土倉"
"つちぐり 土栗"
"つちけいろ 土気色"
"つちけむり 土煙"
"つちこ 土子"
"つちこつ 槌骨"
"つちざき 土崎"
"つちた 土田"
"つちだ 槌田 土田"
"つちつかず 土付かず"
"つちづくり 土作り"
"つちとい 土樋"
"つちとりもちもく ツチトリモチ目"
"つちどめ 土留め"
"つちにんぎょう 土人形"
"つちのえ 戊"
"つちのえいぬ 戊戌"
"つちのえうま 戊午"
"つちのえさる 戊申"
"つちのえたつ 戊辰"
"つちのえとら 戊寅"
"つちのえね 戊子"
"つちのこ 槌の子"
"つちのと 己"
"つちのとい 己亥"
"つちのとう 己卯"
"つちのとうし 己丑"
"つちのととり 己酉"
"つちのとひつじ 己未"
"つちのとみ 己巳"
"つちはし 土橋"
"つちばし 土橋"
"つちふまず 土踏まず"
"つちぶえ 土笛"
"つちへん 土偏"
"つちぼこり 土埃"
"つちぼとけ 土仏"
"つちみかど 土御門"
"つちむろ 土室"
"つちもち 土持"
"つちもと 土本"
"つちや 土谷 土家 土屋"
"つちやま 土山"
"つちゆ 土湯"
"つちよせ 土寄せ"
"つちろう 土牢"
"つっかいぼう つっかい棒 突っ支い棒"
"つっかけ 突っ掛け"
"つっけんどん 突慳貪 突っ慳貪"
"つっこみ 突込み 突っ込み"
"つっぱり 突っ張り"
"つつ 砲 筒"
"つつい 筒井"
"つついづつ 筒井筒"
"つつうらうら 津津浦浦 津々浦々"
"つつおと 筒音"
"つつが 筒賀 恙"
"つつがき 筒描き"
"つつがむし 恙虫"
"つつぎり 筒切り"
"つつぐち 筒口"
"つつさき 筒先"
"つつしんで 謹んで"
"つつじ 榴 躑躅"
"つつじがおか 榴岡 榴ヶ岡 つつじヶ丘"
"つつじもく ツツジ目"
"つつじょう 筒状"
"つつそで 筒袖"
"つつぢゃわん 筒茶碗"
"つつなか 筒中"
"つつぬけ 筒抜け"
"つつみ 愼 筒見 恙 包 包み 堤"
"つつみがまえ 包構え"
"つつみちゅうなごんものがたり 堤中納言物語"
"つつみびょうし 包表紙"
"つつみまち 堤町"
"つつもたせ 美人局"
"つづ 通津"
"つづうらうら 津々浦々"
"つづき 綴喜 都築 続き"
"つづきがら 続柄"
"つづく 続く"
"つづけ 続け"
"つづみ 皷 鼓"
"つづみうた 鼓唄"
"つづら 葛籠 葛"
"つづらおり 葛折り 葛折 九十九折り 九十九折"
"つづらこ 葛籠"
"つづらふじか ツヅラフジ科"
"つづり 綴り 綴"
"つづりかた 綴方"
"つづれ 綴れ"
"つて 伝手 伝"
"つと 衝と"
"つとに 夙に"
"つとむ 勤 務 努 勉 力"
"つとめ 勤め"
"つとめて 努めて"
"つとめびと 勤め人"
"つど 津戸 都度"
"つどい 集 集い"
"つな 津名 綱"
"つなうち 綱打ち"
"つなお 綱男"
"つなかん ツナ缶"
"つながり 繋がり"
"つなぎ 繋ぎ 津奈木 繋"
"つなぐ 綱具"
"つなしま 綱嶋 綱島"
"つなそ 綱麻"
"つなとり 綱取り"
"つなひき 綱引き"
"つなみ 津波"
"つなわたり 綱渡 綱渡り"
"つなん 津南"
"つね 桓 恆 典 経 恒 常"
"つねあき 常明"
"つねお 常男 常夫 常雄 恒男 恒雄 恒夫"
"つねかわ 恒川"
"つねきち 常吉"
"つねきよ 経清"
"つねこ 恒子"
"つねじ 常次"
"つねずみ 常澄"
"つねたけ 典武 恒毅"
"つねづね 常々"
"つねとう 恒任 恒藤"
"つねとし 種敏 恒敏"
"つねとよ 常豊"
"つねなが 常長"
"つねなみ 常並"
"つねに 常に"
"つねのり 恒憲"
"つねはる 常晴"
"つねひこ 恒彦"
"つねひごろ 常日頃"
"つねひら 恒平"
"つねひろ 常廣 恒博 常広 恒宏"
"つねまさ 恒正"
"つねもり 常森"
"つねやす 経康 常安"
"つねゆき 恒行 常幸"
"つねよ 常与"
"つねよし 恒美 常吉 恒吉"
"つの 都濃 都農 津野 角"
"つのお 角尾"
"つのおか 角岡"
"つのかくし 角隠し"
"つのがい 角皆"
"つのがえる 角蛙"
"つのがき 角書き 角書"
"つのがみ 角髪"
"つのがら 角柄"
"つのぎ 角木"
"つのごけるい 角苔類"
"つのごろう 角五郎"
"つのざめ 角鮫"
"つのだ 角田"
"つのはず 角筈"
"つのぶえ 角笛"
"つのへん 角偏"
"つのまた 角叉"
"つのもじ 角文字"
"つはもの 兵"
"つはら 津原"
"つはん ツ反"
"つば 鐔 鍔 唾"
"つばい 椿井"
"つばき 唾 椿"
"つばきあぶら 椿油"
"つばきい 椿井"
"つばきか ツバキ科"
"つばきさんじゅうろう 椿三十郎"
"つばきしゅぞう 椿酒造"
"つばきはら 椿原"
"つばきひめ 椿姫"
"つばきもとちえいん 椿本チエイン"
"つばきやま 椿山"
"つばくらめ 燕"
"つばくろ 燕"
"つばくろうお 燕魚"
"つばさ 翅 翼"
"つばぜりあい 鍔迫り合い"
"つばた 津幡"
"つばな 茅花"
"つばめ 燕"
"つばめうお 燕魚"
"つばめがえし 燕返し"
"つばめざわ 燕沢"
"つばもと 鍔元"
"つひに 終に 遂に"
"つぶ 螺 粒"
"つぶあん 粒あん 粒餡"
"つぶえ 粒餌"
"つぶぎん 粒銀"
"つぶこしょう 粒コショウ 粒胡椒"
"つぶさき 粒崎"
"つぶさに 悉に 備に 具に"
"つぶし 潰し"
"つぶじょう 粒状"
"つぶす 潰"
"つぶぞろい 粒揃い"
"つぶつぶ 粒粒 粒々"
"つぶて 礫"
"つぶますたーど 粒マスタード"
"つぶやき 呟き"
"つぶより 粒選り"
"つぶら 円 円ら"
"つぶらや 円谷"
"つぶれ 潰れ"
"つべつ 津別"
"つべるくりんはんのう ツベルクリン反応"
"つぼ 壷 壺 坪"
"つぼあたり 坪当り 坪当たり"
"つぼい 壺居 壺井 壷井 坪井"
"つぼいさかえ 壺井栄"
"つぼうち 坪内"
"つぼかわ 坪川"
"つぼくら 坪倉"
"つぼさき 坪崎"
"つぼすう 坪数"
"つぼせんざい 壺前栽"
"つぼた 坪田"
"つぼたんか 坪単価"
"つぼだけ 坪岳"
"つぼづけ つぼ漬"
"つぼにわ 坪庭"
"つぼね 局"
"つぼはち つぼ八"
"つぼほり 壺掘り"
"つぼみ 莟 蕾"
"つぼや 壷屋 壺屋"
"つぼやき 壺焼 壺焼き"
"つぼやきいも 壺焼芋 壺焼き芋"
"つぼややき 壺屋焼"
"つま 都万 嬬 褄 妻"
"つまい 妻井"
"つまお 妻夫"
"つまおと 爪音"
"つまかべ 妻壁"
"つまぎ 爪木"
"つまご 妻籠"
"つまごい 妻恋 つま恋 嬬恋"
"つまさき つま先 爪先"
"つまずき 躓き"
"つまづき 躓き"
"つまど 妻戸"
"つまどいこん 妻問婚"
"つまどり 褄取り"
"つまはじき 爪弾き"
"つまびき 爪弾き"
"つまびらか 審らか 詳らか"
"つまべに 爪紅"
"つまみぐい 撮み食い 摘まみ食い 摘み食い つまみ食い"
"つまみな 摘まみ菜"
"つまようじ 爪楊枝"
"つまるところ 詰まる所"
"つみ 辟 詰み 罪"
"つみあげ 積み上げ"
"つみいし 積み石 積石"
"つみいしき 罪意識"
"つみいれ 摘入れ"
"つみおろし 積み卸し"
"つみかえ 積替 積替え 積み替え"
"つみかさね 積み重ね"
"つみき 積木 積み木"
"つみきん 積み金 積金"
"つみくさ 摘み草"
"つみこみ 積み込み"
"つみごえ 積肥"
"つみたて 積立て 積み立て 積立"
"つみち 積地"
"つみつくり 罪作り"
"つみとが 罪科"
"つみとばつ 罪と罰"
"つみに 積み荷 積荷"
"つみのこし 積み残し"
"つみびと 罪人"
"つみほろぼし 罪滅ぼし"
"つみまし 積み増し"
"つみれ 摘入"
"つむ 頭 舶 紡錘 錘"
"つむがり 都牟刈"
"つむぎ 紡木 紡 紬"
"つむぎいと 紬糸"
"つむぎうた 紡ぎ唄"
"つむぎおり 紬織り 紬織"
"つむじ 旋風 辻 旋毛"
"つむじかぜ つむじ風 旋風"
"つむじまがり 旋毛曲がり 旋毛曲り"
"つむら 津邑 津村"
"つむり 頭"
"つめ 詰 詰め 爪"
"つめあと 爪痕"
"つめあわせ 詰合わせ 詰め合せ 詰合せ"
"つめいん 爪印"
"つめえり 詰め襟 詰襟"
"つめかえよう 詰替用"
"つめきり 爪切り"
"つめくさ 詰草"
"つめご 詰め碁 詰碁"
"つめさき 爪先"
"つめしょ 詰所"
"つめしょうぎ 詰将棋"
"つめすじ 詰筋"
"つめた 冷た"
"つめて 詰手"
"つめどころ 詰所"
"つめのあか 爪の垢"
"つめばら 詰腹 詰め腹"
"つめもの 詰物"
"つめろ 詰めろ"
"つも 模 自摸"
"つもほう 自模和"
"つもり 心算 積り 積もり 津守"
"つや 艷 通夜 艶"
"つやけ 艶気"
"つやけし 艶消 つや消し 艶消し"
"つやごと 艶事"
"つやざき 津屋崎"
"つやだし 艶出 ツヤ出し つや出し 艶出し"
"つやつや 艶艶 艶々"
"つやぶみ 艶文"
"つやま 津山"
"つやもの 艶物"
"つやものがたり 艶物語"
"つゆ 黴雨 液 汁 露 梅雨"
"つゆあけ 梅雨明"
"つゆいり 入梅 梅雨入"
"つゆき 露木"
"つゆくさ 露草"
"つゆくさもく ツユクサ目"
"つゆこ 露子"
"つゆざむ 梅雨寒"
"つゆしぐれ 露時雨"
"つゆじも 露霜"
"つゆぞら 梅雨空"
"つゆはし 露橋"
"つゆはらい 露払い"
"つゆほど 露程"
"つよき 強気"
"つよごし 強腰"
"つよさ 強さ"
"つよし 毅師 津義 剛士 幹 毅 強 剛"
"つよび 強火"
"つよみ 強味 強み"
"つら 面"
"つらあて 面当て"
"つらがまえ 面構え"
"つらだし 面出し"
"つらだましい 面魂"
"つらつら 倩々 熟々"
"つらなり 連なり"
"つらのかわ 面の皮"
"つらゆき 貫之"
"つらよごし 面汚し"
"つらら 氷柱"
"つり 系 吊 吊り 釣 釣り"
"つりーがた ツリー型"
"つりーこうぞう ツリー構造"
"つりあい 釣合い 釣合 釣り合い"
"つりあげ 釣上げ"
"つりいと 釣糸 釣り糸"
"つりかわ 釣り革 吊り皮 吊り革 吊革"
"つりがき 釣書"
"つりがね 釣り鐘 釣鐘"
"つりがねそう 釣鐘草"
"つりがねむし 釣鐘虫"
"つりぐ 釣具"
"つりこみごし 釣り込み腰"
"つりごし 釣り輿"
"つりざお 釣り竿 釣竿"
"つりし 釣師"
"つりしょ 釣書"
"つりせん 釣銭"
"つりたに 釣谷"
"つりだいこ 釣太鼓"
"つりて 釣手"
"つりてんじょう 釣天井"
"つりどうぐ 釣道具"
"つりどの 釣殿"
"つりばし 吊橋"
"つりばり 釣針 釣り針"
"つりひも 吊り紐"
"つりびと 釣人 釣り人"
"つりぶね 釣舟 釣り舟 釣船 釣り船"
"つりほう 釣法"
"つりぼり 釣堀 釣り堀"
"つりまと 釣的"
"つりもと 釣元"
"つりやど 釣り宿 釣宿"
"つりわ 吊り輪"
"つる 敦 寉 都留 鉉 絃 弦 蔓 鶴"
"つるあまちゃ 蔓甘茶"
"つるい 釣井 鶴居"
"つるいち 鶴一"
"つるえ 鶴江 鶴枝"
"つるおか 鶴岡"
"つるおと 弦音"
"つるかめ 鶴亀"
"つるかめざん 鶴亀算"
"つるかわ 鶴川"
"つるが 鶴我 鶴賀 敦賀"
"つるがおか 鶴岡"
"つるがしま 鶴ヶ島"
"つるがみね 鶴ヶ峰"
"つるがや 鶴ヶ谷"
"つるきえき 鶴来駅"
"つるぎ 釼 劒 劍 劔 剱 鶴来 剣"
"つるぎざき 剣崎"
"つるぎのまい 剣の舞"
"つるくさ 蔓草"
"つるくび 鶴首"
"つるこう 鶴光"
"つるさき 鶴崎"
"つるざ 鶴座"
"つるし 吊るし"
"つるしあげ 吊し上げ"
"つるしま 鶴島"
"つるしょくぶつ 蔓植物"
"つるじろう 鶴次郎"
"つるせい 蔓性"
"つるぞう 鶴蔵"
"つるた 鶴田"
"つるたろう 鶴太郎"
"つるだ 鶴田"
"つるっぱげ つるっ禿"
"つるな 蔓菜"
"つるにちにちそう 蔓日日草 蔓日々草"
"つるにょうぼう 鶴女房"
"つるのこ 鶴の子"
"つるのまる 鶴の丸"
"つるはぎ 鶴脛"
"つるはし 鶴橋 鶴嘴"
"つるばみ 橡"
"つるばら 蔓薔薇"
"つるふじ 鶴藤"
"つるべ 鶴瓶 釣瓶"
"つるま 鶴間"
"つるまい 鶴舞"
"つるまき 鶴巻 弦巻"
"つるみ 鶴見"
"つるみず 鶴水"
"つるむらさき 蔓紫"
"つるや 鶴谷 鶴屋"
"つるやま 鶴山"
"つるれいし 蔓茘枝"
"つれ 連れ"
"つれあい 連合い 連れ合い"
"つれこ 連れ子"
"つれこみ 連込み"
"つれこみやど 連れ込み宿"
"つれご 連れ子"
"つれづれ 徒然"
"つれづれぐさ 徒然草"
"つれまい 連舞"
"つわの 津和野"
"つわぶき 石蕗"
"つわもの 強者 兵"
"つわり 悪阻"
"つんどく 積讀 積ん読 積読"
"つんぼ 聾"
"つんぼさじき 聾桟敷"
"づ 津 図"
"づか 冢 塚"
"づかい 使い"
"づかれ 疲れ"
"づき 月 付"
"づくえ 机"
"づくし 尽し 尽くし"
"づくり 造り 作り"
"づけ 漬け 漬 付け 付"
"づつ 筒"
"づつう 頭痛"
"づな 綱"
"づのう 頭腦"
"づま 妻"
"づみ 詰み"
"づめ 詰 詰め"
"づり 吊り 釣り"
"づる 鶴"
"づれ 連れ"
"て 〒 弖 手"
"てーぶるさんざ テーブル山座"
"てーぶるせき テーブル席"
"てーぷおこし テープ起こし"
"てあい 手合 手合い"
"てあか 手垢"
"てあし 手足"
"てあしくちびょう 手足口病"
"てあそび 手遊び"
"てあたり 手当り 手当たり"
"てあて 手当て 手当"
"てあな 手穴"
"てあぶり 手焙り"
"てあみ 手編 手編み"
"てあら 手荒"
"てあらい 手洗 手洗い"
"てあらいばち 手洗鉢"
"てあわせ 手合せ 手合わせ"
"てぃーさいぼう Ｔ細胞"
"てぃーしゃつ Ｔシャツ"
"てぃーじ Ｔ字"
"てぃーばっく Ｔバック"
"てぃじろ Ｔ字路"
"てい 袋 體 軆 躰 騁 眤 棣 薙 鼎 鄭 遞 逓 綴 滞 詆 羝 觝 牴 柢 抵 第 睇 涕 梯 悌 弟 剃 鵜 楴 啼 蹄 諦 締 遉 碵 幀 禎 貞 偵 酲 逞 程 呈 嚏 嚔 掟 碇 堤 提 酊 叮 釘 汀 訂 丁 渟 停 艇 挺 廷 庭 定 態 体 亭 帝 邸 底 低"
"ていあつ 定圧 低圧"
"ていあん 提案"
"ていい 帝位 低位 定位"
"ていいき 低域"
"ていいち 禎一 貞一 定位置"
"ていいん 定員"
"ていいんわれ 定員割 定員割れ"
"ていうん 低運"
"ていえき 定役"
"ていえん 定演 庭園"
"ていおう 帝王"
"ていおん 定温 低音 低温"
"ていか 定價 低価 定家 低下 定価"
"ていかい 低徊 停会"
"ていかく 底角 定格"
"ていかっしゃ 定滑車"
"ていかろりー 低カロリー"
"ていかん 停刊 定感 帝冠 諦観 定款"
"ていかんかく 定間隔"
"ていかんし 定冠詞"
"ていが 定芽"
"ていがく 停学 低額 定額"
"ていき 定気 帝紀 提起 定期"
"ていきいれ 定期入"
"ていききんさいけん 定期金債権"
"ていきゅう 啼泣 涕泣 低級 庭球 定休"
"ていきょう 帝京 提供"
"ていきん 提琴"
"ていぎ 提議 定義"
"ていぎょう 帝業"
"ていぎん 帝銀"
"ていくう 低空"
"ていけい 梯形 定形 定型 提携"
"ていけいし 定型詩"
"ていけつ 挺傑 貞潔 締結"
"ていけのうお 手池の魚"
"ていけん 定検 定見"
"ていげき 帝劇"
"ていげん 低限 定限 定言 低弦 逓減 低減 提言"
"ていげんめいほう 定言命法"
"ていこ 挺庫 貞子 艇庫"
"ていこう 定項 低高 抵抗"
"ていこく 帝國 定刻 帝国"
"ていこくほてる 帝国ホテル"
"ていこすと 低コスト"
"ていご 低語"
"ていさい 体裁"
"ていさく 定朔"
"ていさつ 偵察"
"ていさん 帝産"
"ていざ 帝座"
"ていざいは 定在波"
"ていざん 定残 低山"
"ていざんけい 定山溪"
"ていし 諦視 底止 定詞 手石 停止"
"ていしき 程式 定式"
"ていしつ 廷叱 帝室 低湿 低質 底質"
"ていしつごしょうてん 帝室御賞典"
"ていしぼうにゅう 低脂肪乳"
"ていしゃ 停車"
"ていしゅ 艇首 亭主"
"ていしゅう 挺秀 定収 鄭州"
"ていしゅうにゅう 定収入"
"ていしゅく 貞淑"
"ていしゅつ 挺出 提出"
"ていしゅつよう 低出葉"
"ていしょ 低所"
"ていしょう 低唱 定昇 提唱"
"ていしょく 牴触 呈色 定職 停職 定植 抵触 定食"
"ていしろう 偵四郎"
"ていしん 遞信 定進 挺進 艇身 廷臣 挺身 逓信"
"ていしんこう 貞信公"
"ていじ 綴字 禎治 禎二 貞次 悌二 貞二 貞治 低次 丁字 呈示 定時 提示"
"ていじつ 定日"
"ていじゅう 定住"
"ていじょ 貞女"
"ていじょう 堤上 呈上 定常"
"ていじょうこう 定常光"
"ていじん 帝人"
"ていすう 艇数 定数"
"ていずいえきあつしょうこうぐん 低髄液圧症候群"
"ていせい 提撕 貞静 帝制 低声 帝政 定性 訂正"
"ていせいせいぶつ 底生生物"
"ていせき 定石 艇積 定積"
"ていせつ 挺節 貞節 定説"
"ていせん 停船 停戦"
"ていぜん 挺然 庭前"
"ていそ 定礎 提訴"
"ていそう 逓送 底層 貞操 低層"
"ていそく 定則 低速"
"ていそくかいてん 定速回転"
"ていそくじ 定速時"
"ていそくすう 定足数"
"ていそくそうこう 定速走行"
"ていそくど 定速度"
"ていぞう 貞蔵 逓増"
"ていぞく 低俗"
"ていたい 手痛い 定退 堤体 停滞"
"ていたく 邸宅"
"ていたらく 低鱈苦 為体 体たらく"
"ていだい 提題 帝大"
"ていだん 低段 梯団 鼎談"
"ていち 定値 定置 低地"
"ていちあみ 定置網"
"ていちそうこうねんぴ 定地走行燃費"
"ていちゃく 定着"
"ていちょう 低潮 鄭重 艇長 低張 丁重 低調"
"ていちょく 挺直"
"ていっぱい 手一杯"
"ていてい 亭々 廷丁"
"ていてつ 蹄鉄"
"ていてん 定点"
"ていでん 遞傳 停電"
"ていでんあつ 定電圧"
"ていでんりゅう 定電流"
"ていと 帝都"
"ていとう 提灯 低頭 低糖 抵当"
"ていとうがし 抵当貸"
"ていとく 帝徳 提督"
"ていとん 停頓"
"ていど 程度"
"ていない 廷内 邸内 庭内"
"ていね 手稲"
"ていねい 丁寧"
"ていねん 丁年 停年 諦念 定年"
"ていのう 低能"
"ていは 停波"
"ていはい 停廃"
"ていはく 碇泊 停泊"
"ていはつ 剃髪"
"ていばい 逓倍"
"ていばつ 挺抜"
"ていばん 定版 定盤 定番"
"ていひょう 定評"
"ていびょう 帝廟"
"ていふ 貞婦"
"ていふく 定幅"
"ていぶ 底部"
"ていへん 底辺"
"ていほん 定本 底本"
"ていぼう 堤防"
"ていぼく 低木"
"ていまい 弟妹"
"ていめい 締盟 低迷"
"ていめん 底面"
"ていめんせき 底面積"
"ていもう 剃毛"
"ていや 悌也"
"ていやく 定訳 締約"
"ていゆ 提喩"
"ていゆうせん 艇優先"
"ていよう 定窯 定容 提要"
"ていようりょうぴる 低用量ピル"
"ていよく 体良く 低翼"
"ていらく 低落"
"ていり 廷吏 低利 定理"
"ていりき 禎力"
"ていりつ 挺立 定律 鼎立 定立 低率 定率"
"ていりゅう 停留 底流"
"ていりょう 定量"
"ているい 涕涙"
"ていれ 手入れ"
"ていれい 定例"
"ていれつ 貞烈 低劣"
"ていれべる 低レベル"
"ていれん 低廉"
"ていろん 定論"
"てうえ 手植え"
"てうす 手薄"
"てうち 手打ち 手打"
"てうちめん 手打麺 手打ち麺"
"ておい 手負い"
"ておくれ 手後れ 手遅れ"
"ておけ 手桶"
"ておし 手押し"
"ておち 手落ち"
"ておの 手斧"
"ており 手織り 手織"
"てかがみ 手鑑 手鏡"
"てかげん 手加減"
"てかず 手数"
"てかせ 手枷"
"てが 手賀"
"てがい 手飼"
"てがかり 手懸かり 手懸り 手掛り 手がかり 手掛かり"
"てがき 手書 手書き"
"てがた 手形"
"てがたな 手刀"
"てがぬま 手賀沼"
"てがみ 手紙"
"てがら 手柄"
"てがる 手軽"
"てがわ 手側"
"てき 彳 俶 覿 剔 糴 擢 躑 擲 逖 狄 荻 廸 迪 笛 嫡 鏑 摘 滴 適 敵 的"
"てきい 適意 敵意"
"てきえい 敵影"
"てきおう 適応"
"てきおん 適温"
"てきか 迪化 摘花 適価 摘果 滴下"
"てきかく 適確 適格 的確"
"てきかた 敵方"
"てきかん 敵艦"
"てきが 摘芽"
"てきがいしん 敵愾心"
"てきがた 敵方"
"てきがわ 敵側"
"てきき 摘記 手利き 敵機 適期"
"てきぎ 適宜"
"てきぎょう 適業"
"てきぐん 敵軍"
"てきげん 適言"
"てきこく 敵国"
"てきごう 適合"
"てきさい 適才"
"てきさく 適作"
"てきざい 滴剤 適材"
"てきし 摘示 敵視"
"てきしつ 敵失"
"てきしゃ 敵車 適者"
"てきしゅ 敵手"
"てきしゅう 敵襲"
"てきしゅつ 剔出 摘出"
"てきしょ 適所"
"てきしょう 敵将"
"てきしょく 適職"
"てきしん 摘芯 摘心"
"てきじ 適時"
"てきじょ 滌除 摘除"
"てきじょう 敵情"
"てきじょうしさつ 敵状視察"
"てきじん 敵人 敵陣"
"てきず 手創 手疵 手傷"
"てきせい 敵性 適性 適正"
"てきせつ 適切"
"てきぜん 敵前"
"てきそん 劇村"
"てきたい 敵対"
"てきだん 擲彈 擲弾 敵弾"
"てきだんとう 擲弾筒"
"てきち 敵地 適地"
"てきちゅう 適中 敵中 的中"
"てきちょく 躑躅"
"てきてい 滴定"
"てきとう 適当"
"てきど 適度"
"てきにん 敵人 適任"
"てきはい 敵背"
"てきはつ 摘発"
"てきひ 適否"
"てきひょう 適評"
"てきふてき 適不適"
"てきへい 敵兵"
"てきほう 適法"
"てきほんしゅぎ 敵本主義"
"てきめん 覿面"
"てきや テキ屋 的屋"
"てきやく 適薬 適訳 敵役 適役"
"てきよう 摘要 適用"
"てきらい 摘蕾"
"てきりょう 適量"
"てきるい 敵塁"
"てきれい 適例 適齢"
"てきろく 摘録"
"てぎね 手杵"
"てぎれ 手切れ"
"てぎわ 手際"
"てくせ 手くせ 手癖"
"てくだ 手管"
"てくばり 手配り"
"てくび 手首"
"てくらがり 手暗がり"
"てぐ 手具"
"てぐさり 手鎖"
"てぐす 天蚕糸"
"てぐすね 手具脛 手薬煉 手ぐすね"
"てぐち 手口"
"てぐるま 手車 輦"
"てけいさん 手計算"
"てこ 挺子 手子 梃 梃子"
"てこいれ てこ入れ テコ入れ 梃入れ"
"てこう 手甲"
"てこぎ 手漕ぎ"
"てご 手児"
"てごころ 手心"
"てごたえ 手答え 手応え"
"てごと 手事"
"てごま 手駒"
"てごめ 手篭め 手籠め 手籠"
"てごろ 手ごろ 手頃"
"てさき 手先"
"てさぎょう 手作業"
"てさぐり 手探り"
"てさげ 手提 手提げ"
"てさげかばん 手提げ鞄"
"てさげぶくろ 手提げ袋"
"てさし 手差し"
"てさばき 手捌き"
"てざいく 手細工"
"てざき 手崎"
"てざし 手差し"
"てざわり 手触り"
"てしお 天塩 手塩"
"てしかが 弟子屈"
"てしがわら 勅使河原"
"てしくつちょう 弟子屈町"
"てしごと 手仕事"
"てした 手下"
"てしば 手柴"
"てしま 手嶋 手島"
"てしゅうせい 手修正"
"てしょく 手職 手燭"
"てしろぎ 手代木"
"てしんごう 手信号"
"てじか 手近"
"てじな 手品"
"てじま 手嶋 手島"
"てじまい 手仕舞い"
"てじめ 手締め"
"てじゃく 手酌"
"てじゅん 手順"
"てじょう 手錠"
"てすう 手数"
"てすき 手透き 手隙 手漉き"
"てすさび 手遊び"
"てすじ 手筋"
"てすとかんきょう テスト環境"
"てすときかん テスト期間"
"てすとしようしょ テスト仕様書"
"てすとばん テスト版"
"てすとまえ テスト前"
"てすり 手すり 手摺り"
"てずか 手塚"
"てずから 手ずから"
"てずり 手刷"
"てずれ 手擦れ"
"てせい 手製"
"てぜい 手勢"
"てぜま 手狭"
"てぜんたい 手全体"
"てそう 手相"
"てそうみ 手相見"
"てぞん 手損"
"てたれ 手タレ"
"てだい 手代"
"てだし 手出し"
"てだすかり 手助かり"
"てだすけ 手助け"
"てだて 手だて 手立て"
"てだま 手玉"
"てだれ 手足れ 手練れ 手練"
"てちがい 手違い"
"てちょう 手帖 手帳"
"てぢか 手近"
"てっ 徹"
"てっか 鉄火"
"てっかい 鉄枴 鉄拐 撤回"
"てっかく 的確 適格"
"てっかどんぶり 鉄火丼"
"てっかまき 鉄火巻"
"てっかめん 鉄仮面"
"てっかん 鉄環 鉄幹 鉄管"
"てっき 摘記 鉄騎 適期 鉄器 敵機"
"てっきゅう 鉄球"
"てっきょ 剔去 撤去"
"てっきょう 鉄橋"
"てっきん 鉄琴 鉄筋"
"てっきんこんくりーと 鉄筋コンクリート"
"てっけつ 剔抉 鉄血"
"てっけん 鉄研 鉄建 鉄剣 鉄拳"
"てっこう 剔紅 鐵鉱 鐵鋼 鐵工 鉄甲 鉄鉱 手甲 鉄工 鉄鋼"
"てっこうしょ 鐵綱所"
"てっこうだん 徹甲弾"
"てっこつ 鉄骨"
"てっこつぞう 鉄骨造"
"てっさ 鉄鎖"
"てっさい 鉄斎"
"てっさく 鉄索 鉄柵"
"てっしゃ 鉄砂"
"てっしゅう 撤收 撤収"
"てっしょう 哲章 徹宵 鉄漿"
"てっしょきものがたり 徹書記物語"
"てっしん 鉄心"
"てっしんせきちょう 鉄心石腸"
"てっせい 哲西 鉄製"
"てっせき 鉄石"
"てっせん 鉄扇 鉄泉 鉄線"
"てっそく 鉄則"
"てったい 撤退"
"てっちゅう 鉄柱"
"てっつい 鉄鎚 鉄槌"
"てってい 徹底"
"てっとう 鉄塔"
"てっとうてつび 徹頭徹尾"
"てっぱい 撤廃"
"てっぱつ 鉄鉢"
"てっぱん 鉄鈑 鉄板"
"てっぱんやき 鉄板焼"
"てっぴ 鉄扉"
"てっぴつ 鉄筆"
"てっぷ 轍鮒"
"てっぷん 鉄粉"
"てっぺい 鉄平 撤兵"
"てっぺき 鉄壁"
"てっぺん 鉄片 天辺"
"てっぽう 鉄砲"
"てっぽううお 鉄砲魚"
"てっぽうだま 鉄砲玉"
"てっぽうづか 鉄炮塚"
"てっぽうみず 鉄砲水"
"てつ 銕 鐵 鐡 輟 綴 屮 餮 耋 哲 跌 迭 垤 咥 姪 撤 徹 轍 鉄"
"てつあき 哲明"
"てつあれい 鉄亜鈴 鉄アレイ"
"てついち 鉄一"
"てついろ 鉄色"
"てつえ 鉄絵"
"てつお 哲臣 徹男 鉄雄 鉄男 鉄夫 哲生 哲郎 哲雄 哲男 哲夫"
"てつか 手塚"
"てつかいしょく 鉄灰色"
"てつかず 手着かず 手付かず"
"てつかぶと 鉄兜"
"てつがく 哲学"
"てつがくばたけ 哲学畑"
"てつき 手突き 哲樹 手付 手付き"
"てつきどう 鉄軌道"
"てつぎょ 轍魚 鉄魚"
"てつくず 鉄屑"
"てつぐし 鉄串"
"てつけ 手付け 手付"
"てつけいたい 鉄警隊"
"てつけん 鉄研"
"てつげんばん 鉄眼版"
"てつこ 哲子 徹子"
"てつごうし 鉄格子"
"てつさび 鉄錆"
"てつざい 鉄材 鉄剤"
"てつざん 鉄山"
"てつし 哲資 哲士 哲史"
"てつしゃりん 鉄車輪"
"てつしん 鉄芯"
"てつじ 綴字 哲至 哲嗣 轍次 哲史 哲士 哲志 哲二 哲司"
"てつじょう 鉄条"
"てつじょうぎ 鉄定規"
"てつじろう 哲治郎"
"てつじん 哲人 鉄人"
"てつせい 鉄製"
"てつた 哲多"
"てつたろう 哲太郎 鉄太郎"
"てつだい 手伝い"
"てつづき 手続き 手続"
"てつどう 鐵道 鉄道"
"てつどうしがっかい 鉄道史学会"
"てつなべ 鉄鍋"
"てつのり 哲憲"
"てつぱいぷ 鉄パイプ"
"てつひと 鉄一 鉄人"
"てつひろ 哲宏 哲弘"
"てつびょう 鉄鋲"
"てつびん 鉄瓶"
"てつぶろ 鉄風炉"
"てつぶん 鉄分"
"てつぶんか 鉄文化"
"てつぼう 鉄帽 鉄棒"
"てつまど 鉄窓"
"てつまん 徹マン"
"てつみ 哲美"
"てつめん 鉄面"
"てつめんぴ 鉄面皮"
"てつもん 鉄門"
"てつや 鉄弥 哲弥 鉄也 徹也 徹夜 哲哉 哲也"
"てつゆき 徹行 徹之"
"てつようそう 綴葉装"
"てつり 哲理"
"てつりつ 迭立"
"てつりん 鉄輪"
"てつろ 鉄路"
"てつろう 鉄郎 徹郎 哲朗 哲郎"
"てつわん 鉄椀 鉄腕"
"てつわんあとむ 鉄腕アトム"
"てづか 手塚"
"てづかさとみ 手塚理美"
"てづかみ 手掴み"
"てづくり 手作り"
"てづつ 手筒"
"てづまり 手詰り 手詰まり"
"てづめ 手詰 手詰め"
"てづり 手釣"
"てづる 手蔓"
"てて 父"
"ててき 父君"
"ててぎみ 父君"
"ててご 父御"
"ててなしご 父無し子"
"てとり 手取り"
"てどうさ 手動作"
"てどり 手取 手取り"
"てないしょく 手内職"
"てなえ 攣"
"てなおし 手直し"
"てなが 手長"
"てなぐさみ 手慰み"
"てなげ 手投げ"
"てなげだん 手投げ弾"
"てなべ 手鍋"
"てなみ 手並 手並み"
"てならい 手習 手習い"
"てなれ 手馴れ"
"てなわ 手縄"
"てにすぶ テニス部"
"てにもつ 手荷物"
"てにゅうりょく 手入力"
"てにをは 弖爾乎波 天爾遠波"
"てぬい 手縫い"
"てぬかり 手抜かり"
"てぬき 手抜き"
"てぬぐい 手ぬぐい 手拭 手拭い"
"てのうち 手の内"
"てのうら 手の裏"
"てのこう 手の甲"
"てのなか 手の中"
"てのひら 手のひら 手の平 掌"
"てのび 手延び"
"てのべ 手延べ"
"てのべめん 手延べ麺"
"てのもの 手の物"
"てはい 手牌 手配"
"てはじめ 手始め"
"てはず 手はず 手筈"
"てはっちょう 手八丁"
"てはら 手原"
"てば 手羽"
"てばこ 手箱"
"てばた 手機 手旗"
"てばなし 手放し"
"てばなれ 手離れ"
"てばにく 手羽肉"
"てばや 手早"
"てばん 手番"
"てびかえ 手控え"
"てびき 手引 手引き"
"てびきだい 手引第"
"てびねり 手捻り"
"てびょうし 手拍子"
"てびろ 手広"
"てふうきん 手風琴"
"てふき 手拭き"
"てふだ 手札"
"てふろんかこう テフロン加工"
"てぶくろ 手袋"
"てぶそく 手不足"
"てぶら 手ぶら"
"てぶり 手振 手振り"
"てぶれ 手ぶれ"
"てへん 頂辺 手偏 天辺"
"てべんとう 手弁当"
"てほどき 手ほどき 手解き"
"てほん 手本"
"てぼり 手彫り 手掘り"
"てま 手間"
"てまえ 点前 手前"
"てまえだたみ 点前畳"
"てまき 手巻 手巻き"
"てまくら 手枕"
"てまね 手真似"
"てまねき 手招き"
"てまひま 手間暇"
"てまり 手鞠 手毬"
"てまりうた 手鞠歌 手鞠唄 手毬唄"
"てまわし 手回し"
"てまわり 手回り"
"てみじか 手短"
"てみず 手水"
"てみやげ 手土産"
"てむかい 手向かい"
"てめえ 手前"
"てめえら 手前ら"
"てもち 手持 手持ち"
"てもと 手許 手元"
"てもり 手盛り"
"てやき 手焼 手焼き"
"てやく 手役"
"てゆび 手指"
"てら 地球 寺"
"てらい 衒い 寺井"
"てらうち 寺内"
"てらお 寺尾"
"てらおか 寺岡"
"てらおとこ 寺男"
"てらかた 寺方"
"てらかど 寺門"
"てらかわ 寺川"
"てらがいと 寺垣内"
"てらがわ 寺側"
"てらくら 寺倉"
"てらこ 寺子"
"てらこしょう 寺小姓"
"てらごや 寺小屋"
"てらさか 寺坂"
"てらさき 寺崎"
"てらさわ 寺澤 寺沢"
"てらした 寺下"
"てらしま 寺嶋 寺島"
"てらしょう 寺庄"
"てらじま 寺島"
"てらせん 寺銭"
"てらそま 寺杣"
"てらだ 寺田"
"てらち 寺地"
"てらどまり 寺泊"
"てらにし 寺西"
"てらの 寺野"
"てらまえ 寺前"
"てらまち 寺町"
"てらまちどおり 寺町通"
"てらむら 寺村"
"てらもと 寺元 寺本"
"てらやま 寺山"
"てり 輝"
"てりかえし 照り返し"
"てりは 照葉 照り葉"
"てりやき 照焼き 照焼 照り焼き"
"てりやす 輝泰"
"てりゅうだん 手榴弾"
"てりょうり 手料理"
"てる 瑛 晃 照 輝"
"てるあき 輝明"
"てるい 照井"
"てるお 晃央 晃夫 光男 照男 照雄 照夫 輝男 輝雄 輝夫"
"てるき 輝樹"
"てるこ 輝子 照子 てる子"
"てるたか 照貴"
"てるてるぼうず 照る照る坊主 てるてる坊主"
"てると 照人"
"てるのぶ 晧史 輝暢 照信"
"てるのり 照則"
"てるは 照葉"
"てるひこ 照比古 照彦 輝彦"
"てるひさ 照久"
"てるひろ 照洋"
"てるみ 輝美 照美"
"てるもと 輝元"
"てるやす 輝泰"
"てるゆき 輝之 輝幸"
"てれ 照れ"
"てれあさ テレ朝"
"てれとう テレ東"
"てれび 電視"
"てれびあさひ テレビ朝日"
"てれびがめん テレビ画面"
"てれびきょく テレビ局"
"てれびしーえむ テレビＣＭ"
"てれびしゅつえん テレビ出演"
"てれびだい テレビ台"
"てれびちゅうけい テレビ中継"
"てれびでんわ テレビ電話"
"てれびとう テレビ塔"
"てれびとうきょう テレビ東京"
"てれびばんぐみ テレビ番組"
"てれびほうそう テレビ放送"
"てれびよう テレビ用"
"てれびらん テレビ欄"
"てれびんゆ テレビン油"
"てれん 手練"
"てろこうげき テロ攻撃"
"てろじけん テロ事件"
"てろそしき テロ組織"
"てろたいさく テロ対策"
"てわけ 手分け"
"てわざ 手業 手技"
"てわたし 手渡し"
"てん 梃 ・・・ … ， 、 ． ・ 殿 辿 諂 篆 奠 丶 殄 腆 恬 甜 囀 轉 輾 碾 靦 覘 貼 點 霑 沾 癲 巓 顛 鷏 鷆 槙 填 躔 纒 纏 壥 廛 添 忝 典 貂 展 転 天 店 点"
"てんあつ 転圧"
"てんあん 天安"
"てんい 典韋 典医 天意 天衣 転位 転移"
"てんいがい 点以外"
"てんいそう 転移巣"
"てんいち 天一"
"てんいむほう 天衣無縫"
"てんいり 点入"
"てんいん 転院 店員"
"てんうん 天運"
"てんえ 天衣"
"てんえい 天永 天栄"
"てんえん 天延 展延"
"てんおう 天応 天王"
"てんおうせい 天王星"
"てんおん 天恩 転音"
"てんおんげん 点音源"
"てんか 天華 転訛 天火 転科 天花 転化 転嫁 点火 添加 天下"
"てんかい 転回 天海 天界 展開"
"てんかいち 天下一"
"てんかく 点画"
"てんかこ 点過去"
"てんかしん 点加振"
"てんかす 天かす 天滓"
"てんかつきゅう 天蝎宮"
"てんかてい 点過程"
"てんかとう 転化糖"
"てんかびと 天下人"
"てんかふん 天瓜粉 天花粉"
"てんかぷらぐ 点火プラグ"
"てんかれいじ 添加励磁"
"てんかわ 添川"
"てんかん 転官 天官 天漢 点間 癲癇 展観 転換"
"てんが 殿下 天下 天河 典雅"
"てんがい 天涯 天蓋 天外"
"てんがく 転学"
"てんがぢゃや 天下茶屋"
"てんがん 天眼 点眼"
"てんき 天氣 天機 転帰 転記 転機 天気"
"てんきあめ 天気雨"
"てんきぼ 点鬼簿"
"てんきゅう 天宮 天球"
"てんきょ 典拠 転居"
"てんきょう 癲狂"
"てんきょういん 癲狂院"
"てんきん 転勤"
"てんぎ 典儀 転義 天喜"
"てんぎく 天菊"
"てんぎょう 天慶 転業"
"てんく 転句"
"てんくう 天空"
"てんくうかいかつ 天空海闊"
"てんくぎ 天釘"
"てんぐ 天狗"
"てんぐう 天宮"
"てんぐさ 天草"
"てんぐざる 天狗猿"
"てんぐだいら 天狗平"
"てんぐまい 天狗舞"
"てんけい 天刑 添景 点景 天恵 天啓 典型"
"てんけつ 点穴 転結"
"てんけつごう 点結合"
"てんけん 天譴 天険 点検"
"てんげ 天華 天花 天下"
"てんげん 点源 天元"
"てんこ 典故 点呼"
"てんこう 天皇 典孝 天光 天功 転校 転向 天候"
"てんこうげん 点光源"
"てんこうこくしょく 天香国色"
"てんこうりつ 点効率"
"てんこおん 転呼音"
"てんこく 転告 篆刻"
"てんこもり テンコ盛り 天こ盛り てんこ盛り"
"てんご 転語 点５"
"てんごく 典獄 天国"
"てんさ 点差"
"てんさい 天際 甜菜 天災 天才 転載"
"てんさいとう 甜菜糖"
"てんさく 転作 添削"
"てんさん 天蚕"
"てんさんぶつ 天産物"
"てんざ 典座"
"てんざい 点在"
"てんざん 天山"
"てんし 覘視 天資 展翅 天子 天使"
"てんしき 点式"
"てんしげ 天繁"
"てんしじ 点支持"
"てんしち 転質"
"てんしつ 天質"
"てんしゃ 転社 転写"
"てんしゃく 転借"
"てんしゃだい 転車台"
"てんしゅ 天主 天守 店主"
"てんしゅうごう 点集合"
"てんしゅかく 天守閣"
"てんしゅく 転宿"
"てんしゅつ 点出 転出"
"てんしゅん 転瞬"
"てんしょ 典書 転所 添書 篆書"
"てんしょう 天承 天象 天昇 転生 天正"
"てんしょうどう 天賞堂"
"てんしょく 天色 天職 転職"
"てんしん 天心 天真 点心 転進 転身 天津"
"てんしんはん 天津飯"
"てんじ 篆字 天治 典侍 添字 点字 展示"
"てんじく 天竺"
"てんじくあおい 天竺葵"
"てんじくがく 天竺楽"
"てんじくねずみ 天竺鼠"
"てんじつ 天日"
"てんじてんのう 天智天皇"
"てんじぶろっく 点字ブロック"
"てんじゃ 点者"
"てんじゅ 天授 天寿"
"てんじゅう 転住"
"てんじょ 天助"
"てんじょう 天壤 纏繞 天壌 殿上 点状 添乗 天上 天井"
"てんじょういた 天井板"
"てんじょうけい 纏繞茎"
"てんじょうつり 天井吊"
"てんじょうびと 殿上人"
"てんじん 天人 天神"
"てんじんだいら 天神平"
"てんじんまつり 天神祭"
"てんすい 天水"
"てんすう 点数"
"てんずみ 点炭"
"てんせい 点睛 天生 転成 展性 天成 天性 転生"
"てんせいじんご 天声人語"
"てんせいろ 天せいろ"
"てんせき 転石 典籍 転籍"
"てんせっしょく 点接触"
"てんせつ 点綴"
"てんせん 転線 転戦 点線"
"てんぜん 恬然 典膳"
"てんそう 転送"
"てんそく 纒足 店則 典則 天足 天測 纏足"
"てんそば 天蕎麦"
"てんそん 天孫"
"てんぞ 典座"
"てんぞう 点像"
"てんぞく 転属"
"てんたい 転貸 天体"
"てんたいしゃく 転貸借"
"てんたいしょう 点対称"
"てんたかく 天高く"
"てんたく 転宅"
"てんたん 恬淡"
"てんだい 椽大 天台"
"てんち 転置 転地 天地"
"てんちゃ 点茶 甜茶"
"てんちゃく 展着"
"てんちゅう 転注 天柱 天誅"
"てんちゅうぐみ 天忠組"
"てんちゅうさつ 天中殺"
"てんちゅうし 典鋳司"
"てんちゅうせつ 天中節"
"てんちょう 天寵 天聴 天長 天頂 転調 店長"
"てんちょうちきゅう 天長地久"
"てんつい 点対"
"てんつゆ 天つゆ 天汁"
"てんてい 点綴 天帝"
"てんていとう 転抵当"
"てんてき 天敵 点滴"
"てんてきちゅう 点的中"
"てんてこまい てんてこ舞い"
"てんてつ 点綴 転轍"
"てんてん …… ： ．．． ‥ ・・・ … 展転 輾転 点々 転々"
"てんてんてん ・・・"
"てんでんか 点電荷"
"てんと 奠都"
"てんとう 纏頭 点頭 顛倒 点燈 天道 点灯 転倒 店頭"
"てんとうむし 瓢虫 紅娘 天道虫 てんとう虫"
"てんとく 転得 天徳"
"てんとせん 点と線"
"てんとり 点取り"
"てんどう 顛動 天動 天堂 天道 天童"
"てんどく 顛読 点読 転読"
"てんどん 天丼"
"てんな 天和"
"てんない 店内"
"てんなんしょう 天南星"
"てんに 点２"
"てんにゅう 転入"
"てんにょ 天女"
"てんにん 天仁 天人 転任"
"てんにんか 天人花"
"てんにんぎく 天人菊"
"てんにんそう 天人草"
"てんにんちょう 天人鳥"
"てんね 天衣"
"てんねん 天然"
"てんねんうらん 天然ウラン"
"てんねんがき 天然牡蠣"
"てんねんがす 天然ガス"
"てんねんごむ 天然ゴム"
"てんねんしば 天然芝"
"てんねんとう 天然痘"
"てんねんぱーま 天然パーマ"
"てんねんぼけ 天然ボケ"
"てんねんゆき 天然雪"
"てんねんりん 天然林"
"てんのう 天王 天皇"
"てんのうざん 天王山"
"てんのうしょうあき 天皇賞秋"
"てんのうしょうはる 天皇賞春"
"てんのうしょうば 天皇賞馬"
"てんのうず 天王洲"
"てんのうせい 天王星"
"てんはいれつ 点配列"
"てんはく 天白"
"てんば 天端 天馬"
"てんばい 店売 転売"
"てんばつ 天罰"
"てんばん 天板"
"てんばんごう 店番号"
"てんぱい 顛沛 天盃 聴牌"
"てんぱく 天伯 天白"
"てんぱん 典範 天板"
"てんびき 天引き"
"てんびざい 点鼻剤"
"てんびやく 点鼻薬"
"てんびょう 点描"
"てんびん 天秤"
"てんびんぼう 天秤棒"
"てんぴ 天火 天日"
"てんぴじお 天日塩"
"てんぴょう 天平"
"てんぴょうかんぽう 天平感宝"
"てんぴょうしょうほう 天平勝宝"
"てんぴょうじんご 天平神護"
"てんぴょうほうじ 天平宝字"
"てんぴん 天稟"
"てんぶ 転部"
"てんぶくろ 天袋"
"てんぶつ 典物 天物"
"てんぶん 篆文 天文 天分"
"てんぷ 貼付 天賦 添付"
"てんぷく 顛覆 天吹 天福 転覆"
"てんぷふぁいる 添付ファイル"
"てんぷら 天ぷら 天麩羅"
"てんぷらあぶら 天ぷら油"
"てんぷらこ 天ぷら粉"
"てんぷらなべ 天ぷら鍋"
"てんべつ 点別"
"てんぺい 天兵"
"てんぺん 転変 天辺 天変"
"てんほー 天和"
"てんほう 天和"
"てんほくせん 天北線"
"てんぼう 点棒 展望"
"てんぼうとう 展望塔"
"てんぼうりん 転法輪"
"てんぽ 転補 填補 店舗"
"てんぽう 天方 天保"
"てんぽうざん 天保山"
"てんぽうのかいかく 天保の改革"
"てんぽん 点本"
"てんま 天満 天魔 伝馬 天馬"
"てんまく 天幕"
"てんまつ 天松 顛末"
"てんまど 天窓"
"てんまばやし 天間林"
"てんまん 天満"
"てんまんてん 点満点"
"てんむす 天むす"
"てんむてんのう 天武天皇"
"てんめ 点目"
"てんめい 天明 天命 店名"
"てんめいのたいか 天明の大火"
"てんめつ 点滅"
"てんめん 纏綿"
"てんめんじゃん 甜麺醤"
"てんもう 天網"
"てんもく 天目"
"てんもん 天文"
"てんや 店屋"
"てんやく 典鑰 点薬 天役 転役 点役 典薬 点訳"
"てんやくりょう 典薬寮"
"てんゆう 天祐 天佑"
"てんよ 天与"
"てんよう 天養 転用"
"てんようせつ 点溶接"
"てんらい 天雷 天来"
"てんらく 顛落 転落"
"てんらん 天覧 展覧"
"てんり 天理"
"てんりひがし 天理東"
"てんりゃく 天暦"
"てんりゅう 点流 天龍 天竜"
"てんりゅうきょう 天龍峡"
"てんりょう 転寮 填料 天領"
"てんりん 転輪"
"てんりんおう 轉輪王"
"てんれい 典麗 典例 篆隷 典礼"
"てんれつ 点列"
"てんれんけつ 点連結"
"てんろ 転炉"
"てんろうせい 天狼星"
"てんろく 天禄 天六"
"てんわ 天和"
"で 弟 出"
"でーたあっしゅく データ圧縮"
"でーたかいせき データ解析"
"でーたかんり データ管理"
"でーたがた データ型"
"でーたぐん データ群"
"でーたこうぞう データ構造"
"でーたしゅうしゅう データ収集"
"でーたしょり データ処理"
"でーたすう データ数"
"でーたつうしん データ通信"
"でーたてんそう データ転送"
"でーたにゅうりょく データ入力"
"でーたべーすか データベース化"
"でーたりょう データ量"
"でーとしょうほう デート商法"
"であい 出合い 出逢い 出会い"
"であし 出足"
"でぃーぜるしゃ ディーゼル車"
"でぃおにゅそすてき ディオニュソス的"
"でい 禰 泥"
"でいがん 泥岩"
"でいじょう 泥状"
"でいすい 泥水 泥酔"
"でいたん 泥炭"
"でいちゅう 泥中"
"でいど 泥土"
"でいねい 泥濘"
"でいばだった 提婆達多"
"でいばんがん 泥板岩"
"でいり 泥裡 泥裏 出入り"
"でいりぐち 出入口"
"でいりゅう 泥流"
"でいろ 泥路"
"でおきしりぼかくさん デオキシリボ核酸"
"でおくれ 出遅れ"
"でおんな 出女"
"でか 刑事"
"でかぐらむ 瓧"
"でかせぎ 出稼ぎ"
"でかた 出かた 出方"
"でかめーとる 籵"
"でかりっとる 竍"
"でがたり 出語り"
"でがら 出殻"
"でがらし 出涸らし"
"でがわ 出川"
"でき 溺 出来"
"できあい 出来合 出来合い 溺愛"
"できうお 出来魚"
"できごころ 出来心"
"できし 溺死"
"できすぎ 出木杉"
"できそこない 出来損ない"
"できちゃったけっこん できちゃった結婚"
"できちゃったこん できちゃった婚"
"できね 出来値"
"できばえ 出来映え 出来栄え"
"できぼし 出来星"
"できぼつ 溺没"
"できれーす 出来レース"
"できわく 溺惑"
"できん 出禁"
"でぎわ 出際"
"でく 木偶"
"でくのぼう 木偶の坊"
"でぐあい 出具合"
"でぐち 出口"
"でぐちおにさぶろう 出口王仁三郎"
"でげいこ 出稽古"
"でげねりあか デゲネリア科"
"でこ 凸"
"でこすけ デコ助"
"でこでん デコ電"
"でこぼこ 凸凹"
"でこぼこみち 凸凹道"
"でさかり 出盛り"
"でさき 出先"
"でさく 出作"
"でざいんか デザイン科"
"でざいんせい デザイン性"
"でざいんてき デザイン的"
"でざき 出崎"
"でざわ 出沢"
"でし 弟子"
"でしお 出潮 出汐"
"でしぐらむ 瓰"
"でしごと 出仕事"
"でしな 出しな"
"でしょく 出職"
"でしりっとる 竕"
"でじたるか デジタル化"
"でじたるかいせん デジタル回線"
"でじたるかでん デジタル家電"
"でじたるしょめい デジタル署名"
"でじたるしょり デジタル処理"
"でじたるしんごう デジタル信号"
"でじたるどけい デジタル時計"
"でじたるほうそう デジタル放送"
"でじたるろくおん デジタル録音"
"でじま 出島"
"でじる 出汁"
"でじろ 出城"
"ですぎ 出過ぎ"
"ですくとっぷがた デスクトップ型"
"ですたい です体"
"ですみ 出角 出隅"
"でずいらず 出ず入らず"
"でずっぱり 出突っ張り"
"でせん 出銭"
"でぞめ 出初め"
"でぞめしき 出初式"
"でたて 出立て"
"でたとこしょうぶ 出た所勝負"
"でたに 出谷"
"でたらめ 出鱈目"
"でだし 出出し 出だし"
"でだま 出玉"
"でっち 丁稚"
"でっちぼうこう 丁稚奉公"
"でっちょうそう 粘葉装"
"でっちり 出っ尻"
"でっぱ 出っ歯"
"でっぱり 出っ張り"
"でつ 捏"
"でつぞう 捏造"
"でづくり 出作り"
"でづっぱり 出突っ張り"
"でづら 出面"
"でどころ 出どころ 出処 出所"
"でなおし 出直し"
"ではい デ杯"
"ではいり 出入り"
"ではじめ 出始め"
"ではずれ 出外れ"
"ではな 出端"
"でば 出場 出歯 出刃"
"でばかめ 出歯亀"
"でばがめ 出歯亀"
"でばな 出花 出端 出鼻"
"でばぼうちょう 出刃庖丁"
"でばやし 出囃子"
"でばん 出番"
"でぱちか デパ地下"
"でびゅーさく デビュー作"
"でびゅーせん デビュー戦"
"でふぉるとち デフォルト値"
"でふね 出船"
"でぶしょう 出不精"
"でぶせん デブ専"
"でぶち 出淵"
"でべそ 出臍"
"でほ 出穂"
"でほうだい 出放題"
"でぼんき デボン紀"
"でま 手間"
"でまえ 出前"
"でまえもち 出前持"
"でまかせ 出任せ"
"でまち 出町 出待ち"
"でまちやなぎ 出町柳"
"でまど 出窓"
"でまる 出丸"
"でみず 出水"
"でみせ 出店"
"でむかえ 出迎え"
"でむら 出村"
"でめ 出目"
"でめとく 出目徳"
"でもがめん デモ画面"
"でもこうしん デモ行進"
"でもたい デモ隊"
"でもと 出本"
"でもどり 出戻り"
"でもの 出物"
"でもばん デモ版"
"でもん 出門"
"でやしき 出屋敷"
"でゆ 出湯"
"でよう 出様"
"でら 寺"
"でるた Δ δ"
"でるふぁいほう デルファイ法"
"でるまく 出る幕"
"でわ 出葉 出羽"
"でわざくら 出羽桜"
"でわにしき 出羽錦"
"でわのうみ 出羽海"
"でん 黏 臀 傳 淀 澱 棯 鈿 沺 畋 甸 佃 田 伝 殿 電"
"でんあつ 電圧"
"でんい 電位"
"でんえん 田園"
"でんえんし 田園詩"
"でんおん 伝音"
"でんか 伝家 田家 電荷 殿下 電化"
"でんかい 電界 電解"
"でんかのほうとう 伝家の宝刀"
"でんかん 電環 田漢 電管"
"でんがく 電楽 田楽"
"でんき 傳綺 伝奇 伝記 電器 電機 電気"
"でんきうお 電気魚"
"でんきうなぎ 電気鰻"
"でんきすたんど 電気スタンド"
"でんきすとーぶ 電気ストーブ"
"でんきそりょう 電気素量"
"でんきどりる 電気ドリル"
"でんきなべ 電気鍋"
"でんきひつじ 電気羊"
"でんきぶらん 電気ブラン"
"でんきぽっと 電気ポット"
"でんきゅう 電球"
"でんきょうしゃ 電響社"
"でんきょく 電極"
"でんぎ 電技"
"でんぎょう 伝教 電業"
"でんぐねつ デング熱"
"でんぐりがえし でんぐり返し"
"でんけい 電計"
"でんけん 電検 電鍵 電顕"
"でんけんさんしゅ 電験三種"
"でんげき 電撃"
"でんげん 電源"
"でんげんいり 電源入"
"でんげんこーど 電源コード"
"でんげんばん 電源板"
"でんこう 電興 電光 電工"
"でんこうばん 電光板"
"でんごん 伝言"
"でんごんばん 伝言板"
"でんさん 電産 電算"
"でんざい 電材"
"でんし 殿試 電子"
"でんしおるがん 電子オルガン"
"でんしかく 電子殻"
"でんしかるて 電子カルテ"
"でんしきょう 電子工業振興協会 電子協"
"でんしじゅう 電子銃"
"でんしすぴんきょうめい 電子スピン共鳴"
"でんしだい 電視台"
"でんしてきすと 電子テキスト"
"でんしびーむ 電子ビーム"
"でんしぴあの 電子ピアノ"
"でんしぶっく 電子ブック"
"でんしまねー 電子マネー"
"でんしめーる 電子メール"
"でんしめいる 電子メイル"
"でんしゃ 伝者 伝写 田舎 殿舎 電車"
"でんしゃかん 田舎漢"
"でんしゃみち 電車道"
"でんしゅう 伝習"
"でんしょ 伝書"
"でんしょう 伝唱 伝誦 電照 伝承"
"でんしょうぎく 電照菊"
"でんしょく 電飾"
"でんしょくこう 電色光"
"でんしょばと 伝書鳩"
"でんしれんじ 電子レンジ"
"でんしん 田紳 伝信 電信"
"でんしんはちごう 電信八号"
"でんしんばしら 電信柱"
"でんじ 電磁"
"でんじき 電磁気"
"でんじしゃく 電磁石"
"でんじゅ 伝授"
"でんじょう 電情"
"でんじん 電人"
"でんすけ 電助 伝助"
"でんせい 電請"
"でんせいかん 伝声管"
"でんせつ 電設 伝説"
"でんせん 電専 電閃 伝宣 伝線 伝染 電線"
"でんせんひき 電線引"
"でんそう 電送 電装 伝送"
"でんそうけん 電子技術総合研究所 電総研"
"でんそうだい 電総大"
"でんそく 電束"
"でんそん 伝存"
"でんたいばん 電胎版"
"でんたく 電卓"
"でんたつ 伝達"
"でんたん 電探"
"でんだ 伝田"
"でんだい 電大 田代"
"でんち 電池"
"でんちぎれ 電池切れ"
"でんちく 電蓄"
"でんちゅう 殿中 電柱"
"でんちゅうけん 電中研"
"でんちゅうばん 電鋳版"
"でんつう 電通"
"でんつうだい 電気通信大学"
"でんてい 電停"
"でんてつ 電鉄"
"でんでん 電々 電電"
"でんでんだいこ でんでん太鼓"
"でんでんむし 蝸牛"
"でんとう 電燈 電灯 伝統"
"でんどう 電導 伝動 伝道 伝導 殿堂 電動"
"でんどうのしょ 伝道の書"
"でんどうば 殿堂馬"
"でんねつ 伝熱 電熱"
"でんのう 電脳"
"でんのうづくえ 電脳机"
"でんば 電場"
"でんばた 田畑"
"でんばほうれいしゅう 電波法令集"
"でんぱ 伝播 電波"
"でんぱた 田畑"
"でんぱち 伝八"
"でんぱつ 電髪"
"でんぱとう 電波塔"
"でんぱん 伝播 殿版 伝搬"
"でんぴょう 伝票"
"でんぶ 田麩 臀部"
"でんぶん 伝文 電文 伝聞"
"でんぷ 田夫"
"でんぷん でん粉 澱粉"
"でんぼう 伝法"
"でんぽ 田圃"
"でんぽう 伝法 電報"
"でんぽん 伝本"
"でんまーく 丁抹"
"でんまーくご デンマーク語"
"でんまちょう 伝馬町"
"でんめい 電命"
"でんや 田野"
"でんらい 伝来"
"でんらん 電纜"
"でんり 電離"
"でんりく 電リク"
"でんりばこ 電離箱"
"でんりゃく 電略"
"でんりゅう 電流"
"でんりゅうせん 電留線"
"でんりょく 電力"
"でんれい 電鈴 伝令"
"でんれいし 伝令使"
"でんろ 電路"
"でんわ 電話"
"でんわぼっくす 電話ボックス"
"と 砿 闘 冨 富 圖 図 頭 外 人 十 登 跿 蚪 砺 礪 砥 妬 蠧 蠹 荼 塗 肚 汢 土 杜 吐 莵 菟 兔 兎 度 鍍 渡 覩 睹 賭 屠 堵 斗 途 徒 都 戸"
"とーなめんとせん トーナメント戦"
"とーみょう 豆苗"
"とーれ 東レ"
"とあさ 遠浅"
"とあみ 投網"
"とい 戸井 土肥 問い 問 樋"
"といあわせ 問合 問合わせ 問合せ 問い合せ"
"というつせんきょ 統一選挙"
"といかけ 問掛け 問い掛け"
"といき 吐息"
"といし 礪 砥石"
"といた 戸板"
"といだけ 樋竹"
"といち 十一"
"といつ 対子"
"といとい 対々"
"といといほー 対対和"
"といみさき 都井岬"
"といめん 対面"
"といや 問屋"
"といれきゅうけい トイレ休憩"
"といれそうじ トイレ掃除"
"といれよう トイレ用"
"といろ 十色"
"とう 篤 諮 十 父 訊 訪 通 任 納 道 讀 読 鼕 饕 閙 鬧 纛 竇 淌 棠 朸 抖 帑 夲 亠 溏 塘 搨 榻 黨 儻 稻 稲 偸 宕 櫂 兜 吋 透 討 董 統 套 凍 釖 叨 酘 骰 投 樋 桶 綯 掏 萄 淘 倒 到 縢 籘 滕 騰 謄 藤 撞 潼 橦 幢 剳 鞳 荅 搭 罩 棹 掉 悼 桐 筒 撓 橈 疼 冬 鬪 鬥 闘 搗 嶌 嶋 迯 逃 桃 韜 鞜 蹈 滔 踏 沓 螳 蟷 礑 當 档 盪 蘯 蕩 湯 盜 盗 陦 祷 梼 檮 擣 涛 濤 磴 橙 嶝 鐙 登 痘 逗 豆 頭 燈 灯 刀 陶 籐 島 棟 東 当 答 唐 等 糖 塔 党"
"とうあ 東亞 東亜"
"とうあつ 等圧"
"とうあぺいんと 東亜ペイント"
"とうあん 偸安 答案"
"とうい 陶猗 登位 東夷 等位 当為 当意 糖衣"
"とういく 陶育"
"とういす 籐椅子"
"とういち 東一"
"とういつ 統一"
"とういも 唐芋"
"とういん 頭韻 登院 東員 桐蔭 当院 党員"
"とううつ 陶鬱"
"とううん 東雲"
"とうえい 冬営 倒影 東永 灯影 東栄 東映 投影"
"とうえん 遠縁 登園 桃園"
"とうえんめい 陶淵明"
"とうおう 陶泓 藤黄 湯王 東欧"
"とうおく 塔屋"
"とうおん 唐音 等温"
"とうか １０日 十日 橙果 刀下 登科 灯花 陶化 陶家 豆果 燈下 灯下 等化 頭花 燈火 糖化 当課 桃花 灯火 等価 投下 透過"
"とうかい 倒潰 韜晦 倒壊 当会 東海"
"とうかいかーぼん 東海カーボン"
"とうかいだいよん 東海大四"
"とうかいどういち 東海道一"
"とうかいぱるぷ 東海パルプ"
"とうかいりん 東海林"
"とうかく 等覚 等角 倒閣 頭角 当確"
"とうかこう 透過光"
"とうかせる 等価セル"
"とうかつ 統轄 統括"
"とうかつじごく 等活地獄"
"とうかむり 唐冠"
"とうかむりがい 唐冠貝"
"とうかん 灯竿 凍寒 冬官 唐冠 陶棺 盗汗 東漢 等閑 統監 東関 当館 投函"
"とうかんぶ 党幹部"
"とうかんむり 唐冠"
"とうが 陶瓦 灯蛾 唐画 陶画 冬芽 冬瓜"
"とうがい 頭外 等外 凍害 頭蓋 当該"
"とうがく 陶額 唐楽"
"とうがし 唐菓子"
"とうがった 遠刈田"
"とうがね 東金"
"とうがまえ 闘構え"
"とうがらし 唐辛子"
"とうがん 冬瓜 東岸"
"とうき 頭記 闘鬼 党旗 党規 党紀 当季 当機 当帰 騰貴 投機 投棄 冬期 当期 陶器 登記 冬季"
"とうきがわら 陶器瓦"
"とうきち 藤吉"
"とうきび 唐黍"
"とうきゃく 等脚"
"とうきゃくるい 橈脚類"
"とうきゅう 冬宮 討究 投球 等級 東急"
"とうきゅうはんず 東急ハンズ"
"とうきゅうほてる 東急ホテル"
"とうきょう 東教 東京"
"とうきょういち 東京一"
"とうきょうがす 東京ガス"
"とうきょうしば 東京芝"
"とうきょうすたいる 東京スタイル"
"とうきょうたわー 東京タワー"
"とうきょうてあとる 東京テアトル"
"とうきょうにちにちしんぶん 東京日日新聞"
"とうきょうべいえぬけーほーる 東京ベイＮＫホール"
"とうきょうほか 東京他"
"とうきょく 登極 当局"
"とうきん 陶鈞"
"とうきんせん 東金線"
"とうぎ 東魏 党議 闘技 東儀 討議"
"とうぎゅう 闘牛"
"とうぎょ 闘魚 統御"
"とうぎょう 陶業"
"とうぎり 当限"
"とうぎん 当今"
"とうくつ 盗掘"
"とうくろう 藤九郎"
"とうぐう 東宮"
"とうぐうぼう 春宮坊"
"とうぐん 東軍"
"とうけ 当家"
"とうけい 倒景 闘鶏 東経 統計"
"とうけいじ 東慶寺"
"とうけいぶ 頭頸部"
"とうけつ 盗血 凍結"
"とうけん 陶甄 当権 東建 闘犬 倒懸 刀剣"
"とうけんがけい 陶犬瓦鶏"
"とうげ 峠"
"とうげい 陶芸"
"とうげえき 峠駅"
"とうげこう 登下校"
"とうげごえ 峠越 峠越え"
"とうげぞく 峠族"
"とうげつ 冬月 当月"
"とうげみち 峠道"
"とうげん 套言 桃源"
"とうこ 桃壺 唐鼓 董狐 投壺 党錮 東胡 島弧 東子"
"とうこう 党綱 凍港 冬耕 東耕 頭光 灯光 東郊 登降 刀工 登高 投光 等高 東行 陶工 投降 東光 当行 東工 登校 投稿"
"とうこうぎゃくし 倒行逆施"
"とうこうしょく 橙黄色"
"とうこうせいていがた 東高西低型"
"とうこうだい 東京工業大学"
"とうこうにん 党公認"
"とうこく 透谷"
"とうこつ 橈骨 頭骨"
"とうこん 刀痕 当今 闘魂"
"とうご 套語 東児 倒語 頭語 統語"
"とうごう ＝ 等号 投合 東郷 統合"
"とうごく 当国 東国 投獄"
"とうごま 唐胡麻"
"とうさ 等差 踏査"
"とうさい 統裁 当歳 登載 搭載"
"とうさいうお 当歳魚"
"とうさいぎょ 当歳魚"
"とうさいと 当サイト"
"とうさいば 当歳馬"
"とうさく 東作 倒錯 盗作"
"とうさつ 透察 盗撮"
"とうさま 父様"
"とうさん 逃散 東讃 父さん 倒産"
"とうさんさい 唐三彩"
"とうさんどう 東山道"
"とうさんやく 党三役"
"とうざ 当座"
"とうざい 東西"
"とうざいりょうよこづな 東西両横綱"
"とうざのがれ 当座逃れ"
"とうざん 唐桟 唐山 頭山 当山"
"とうし 祷祠 祷祀 唐紙 骰子 唐詩 凍死 透視 闘志 闘士 投資"
"とうしき 等式"
"とうしっこうぶ 党執行部"
"とうしつ 等質 糖質"
"とうしつせい 透湿性"
"とうしば 東芝"
"とうしゃ 謄寫 透写 投写 謄写 投射 当社"
"とうしゅ 陶朱 頭首 当主 党首 投手"
"とうしゅう 等終 東周 東州 踏襲"
"とうしゅうさいしゃらく 東洲斎写楽"
"とうしゅく 投宿"
"とうしょ 答書 頭書 当処 島嶼 当所 投書 当初"
"とうしょう 闘翔 刀傷 刀匠 凍傷 闘将 東証"
"とうしょういちぶ 東証１部"
"とうしょうぐう 東照宮"
"とうしょうだいごんげん 東照大権現"
"とうしょうだいじ 唐招提寺"
"とうしょうにぶ 東証２部"
"とうしょうめん 刀削麺"
"とうしょく 東食 当職 等色 橙色"
"とうしょばこ 投書箱"
"とうしろう 藤四郎"
"とうしん 等親 灯心 東伸 東晋 投身 等身 闘神 刀身 頭身 東進 答申 投信"
"とうしんぐさ 灯心草"
"とうしんせん 等深線"
"とうしんそう 灯心草"
"とうしんてつどう 東清鉄道"
"とうじ 藤治 田牛 田路 刀自 統治 悼辞 蕩児 等時 統辞 答辞 当寺 当事 東寺 冬至 湯治 杜氏 当時"
"とうじいん 等持院"
"とうじき 陶磁器"
"とうじくしょうけい 等軸晶系"
"とうじご 頭字語"
"とうじつ 冬日 当日"
"とうじつあさ 当日朝"
"とうじゅ 東樹 藤樹"
"とうじゅうろう 藤十郎"
"とうじゅく 登熟"
"とうじょ 東序 唐書 倒叙"
"とうじょう 刀杖 闘諍 頭状 凍上 棟上 登城 東條 筒状 東城 東条 東上 搭乗 登場"
"とうじょううん 塔状雲"
"とうじょうか 頭状花"
"とうじょうひでき 東条英機"
"とうじょたいだい 東女体大"
"とうじりつ 透磁率"
"とうじん 刀刃 陶人 党人 蕩尽 唐人"
"とうじんぼう 東尋坊"
"とうす 東司 刀子"
"とうすい 統帥 透水 陶酔"
"とうすいだい 東水大"
"とうすう 頭数"
"とうすうけん 統計数理研究所 統数研"
"とうすけ 藤輔 東介"
"とうすぽ 東スポ"
"とうせい 倒生 濤声 踏青 搗精 冬青 騰勢 籐製 党勢 東征 陶製 当世 統制"
"とうせいがくえん 東星学園"
"とうせき 凍石 党籍 等積 陶石 投石 透析"
"とうせつ 当節"
"とうせん 陶染 陶潜 盗泉 当籤 頭線 東遷 唐船 東線 当選"
"とうせんかろ 冬扇夏炉"
"とうぜ 党是"
"とうぜん 當然 東漸 当前 陶然 当然"
"とうそう 鬪爭 党争 刀槍 痘瘡 逃走 闘争"
"とうそうおん 唐宋音"
"とうそうせん 東早戦"
"とうそく 党則 頭側 等速"
"とうそくるい 頭足類"
"とうそつ 統率"
"とうそん 藤村"
"とうぞく 盗賊"
"とうた 淘汰"
"とうたいかい 党大会"
"とうたく 董卓"
"とうたつ 到達"
"とうたん 東端"
"とうたんぱくしつ 糖蛋白質"
"とうだ 頭打 任田 投打"
"とうだい 東京大学 東台 登第 燈台 等大 当代 東大 灯台"
"とうだいいん 東大院"
"とうだいぐさもく トウダイグサ目"
"とうだいだいけい 東大大型"
"とうだいのう 東大農"
"とうだいもとくらし 灯台下暗し"
"とうだいもり 灯台守"
"とうだん 投弾 当団 登壇"
"とうち 投地 島地 倒置 等値 統治 当地"
"とうちく 唐竹 東筑"
"とうちゃ 闘茶"
"とうちゃく 到着"
"とうちゃん 父ちゃん"
"とうちゅう 陶鋳 頭註 頭注"
"とうちゅうかそう 冬虫夏草"
"とうちょう 唐朝 頭長 等張 等長 登庁 頭頂 登頂 盗聴"
"とうちょく 当直"
"とうちん 陶枕 東浄"
"とうつう 東通 疼痛 頭痛"
"とうつき 当月"
"とうてい 到底"
"とうてき 投擲"
"とうてつ 饕餮 透徹"
"とうてつこうぎょう 東鉄工業"
"とうてん 東天 読点 当店"
"とうてんこう 東天紅"
"とうで 遠出"
"とうでん 盗電 東電"
"とうでんてん 等電点"
"とうと 東都"
"とうとう 幢々 疾う疾う 鼕鼕 蕩蕩 丁丁 滔滔 到頭 登登 陶陶 偸盗 東塔 滔々 東陶 等等 等々"
"とうとうみ 遠江"
"とうとく 統督"
"とうとつ 頭突 唐突"
"とうど 凍土 陶土 糖度"
"とうどう 当道 東堂 東道 藤堂"
"とうどうばつい 党同伐異"
"とうどく 東独"
"とうどり 頭取"
"とうな 唐菜"
"とうない 頭内 東内 島内 党内"
"とうなす 唐茄子"
"とうなん 盗難 東南"
"とうなんあじあ 東南アジア"
"とうなんかいじしん 東南海地震"
"とうなんとう 東南東"
"とうにち 東日"
"とうにゅう 刀入 豆乳 投入"
"とうにょう 糖尿"
"とうにん 当人"
"とうねん 当年"
"とうの 遠野 当の 統乃 冬野 東野"
"とうのうだい 東農大"
"とうのしょう 東庄"
"とうのちゅうじょう 頭の中将"
"とうのみね 多武峰"
"とうのむかし 疾うの昔"
"とうは 踏破 党派"
"とうはいごう 統廃合"
"とうはく 等伯 東伯"
"とうはつ 頭髪"
"とうはと 東鳩 東ハト"
"とうはば 等幅"
"とうはん 東販 東版 東阪 盗犯 登攀 登坂"
"とうば 塔婆"
"とうばい 当倍 等倍"
"とうばく 討幕 倒幕"
"とうばつ 党閥 倒伐 盗伐 討伐"
"とうばん 登板 当番"
"とうばんじゃん 豆瓣醤 豆板醤"
"とうひ 討匪 唐檜 等比 当否 頭皮 逃避"
"とうひこう 討匪行 逃避行"
"とうひょう 投票"
"とうひょうばこ 投票箱"
"とうひん 盗品"
"とうび 掉尾"
"とうびょう 投錨 闘病"
"とうふ ■ 豆富 豆腐"
"とうふう 党風 唐風 東風"
"とうふく 東福 倒伏 等幅"
"とうふなべ 豆腐鍋"
"とうふよう 豆腐よう"
"とうぶ 当部 頭部 東武 東部"
"とうぶつ 唐物"
"とうぶん 等分 糖分 当分"
"とうへい 東平"
"とうへき 東壁 盗癖"
"とうへん 陶片 等辺"
"とうへんぼく 唐変木"
"とうべつ 当別"
"とうべん 答弁"
"とうほう 答砲 答訪 等方 桐朋 投法 東邦 東宝 東方 当方"
"とうほうれーよん 東邦レーヨン"
"とうほく 東北"
"とうほくさわ 東北沢"
"とうほくだい 東北大学"
"とうほくとう 東北東"
"とうほん 唐本 謄本"
"とうほんせいそう 東奔西走"
"とうほんぶ 党本部"
"とうぼ 掏摸"
"とうぼう 陶房 逃亡"
"とうぼく 透木 唐木 冬木 倒木"
"とうま 東馬 討魔 当間 冬馬 當麻 藤間 当麻"
"とうまちくい 稲麻竹葦"
"とうみ 唐箕"
"とうみつ 東密 糖蜜"
"とうみょう 燈明 豆苗 灯明"
"とうみん 島民 冬眠"
"とうむ 党務"
"とうむら 東村"
"とうめい 党名 東名 透明"
"とうめいはん 東名阪"
"とうめいばす 東名バス"
"とうめん 等面 東面 当面"
"とうもう 投網"
"とうもく 頭目"
"とうもつ 唐物"
"とうもろこし 玉蜀黍"
"とうや 塔矢 洞爺 陶冶 当夜 塔屋"
"とうやく 湯薬 当薬 投薬"
"とうやこ 洞爺湖"
"とうやま 遠山 当山 當山"
"とうやまはい 遠山灰"
"とうゆ 灯油"
"とうゆうし 投融資"
"とうよ 東予 投与"
"とうよう 陶遥 蕩揺 投用 陶俑 頭葉 陶窯 東陽 当用 盗用 登用 東洋"
"とうようこうそく 東葉高速"
"とうようだいひめじ 東洋大姫路"
"とうよく 東翼"
"とうよこ 東横"
"とうらい 当来 到来"
"とうらうどねす 等ラウドネス"
"とうらく 当落 騰落"
"とうらんけい 倒卵形"
"とうり 通 統理 党利 桃李"
"とうりだい 東理大"
"とうりつ 頭立 倒立"
"とうりつりょく 統率力"
"とうりゃく 党略"
"とうりゅう 闘竜 当流 刀流 逗留"
"とうりゅうもん 登竜門"
"とうりょう 統領 投了 頭領 等量 当量 棟梁"
"とうりん 登臨"
"とうる 徹 透"
"とうるい 糖類 盗塁"
"とうれ 東レ"
"とうれい 答礼"
"とうろ 当路"
"とうろう 灯篭 登楼 螳螂 燈篭 燈籠 蟷螂 灯籠"
"とうろうのおの 蟷螂の斧"
"とうろく 東麓 登録"
"とうろくしち 登録質"
"とうろくば 登録馬"
"とうろん 闘論 討論"
"とうわ 藤和 東倭 十和 東和"
"とうわく 当惑"
"とえ 十重"
"とえい 渡英 都営"
"とえいばす 都営バス"
"とお 通 遠 十"
"とおあさ 遠浅"
"とおあるき 遠歩き"
"とおい 遠井"
"とおう 渡欧"
"とおえん 遠縁"
"とおか 十日"
"とおかえびす 十日戎"
"とおかった 遠刈田"
"とおからず 遠からず"
"とおがった 遠刈田"
"とおく 遠く"
"とおさぶらい 遠侍"
"とおし 通し"
"とおしばしら 通し柱"
"とおしや 通し矢"
"とおせんぼ 通せんぼ"
"とおせんぼう 通せん坊"
"とおぜめ 遠攻め"
"とおだ 遠田"
"とおちか 遠近"
"とおで 遠出"
"とおとうみ 遠江"
"とおなり 遠鳴り"
"とおね 遠音"
"とおの 遠野"
"とおのり 遠乗り"
"とおひと 遠人"
"とおび 遠火"
"とおぼえ 遠吠 遠吠え"
"とおま 遠間"
"とおまき 遠巻き"
"とおまわし 遠回し"
"とおまわり 遠回り"
"とおみ 遠見"
"とおみづか 遠見塚"
"とおめ 遠目"
"とおめがね 遠眼鏡"
"とおや 遠矢"
"とおやま 遠山"
"とおやまざくら 遠山桜"
"とおり 通 通り"
"とおりあめ 通り雨"
"とおりがかり 通り掛かり"
"とおりすがり 通りすがり"
"とおりちょう 通町"
"とおりな 通り名"
"とおりね 通り値"
"とおりみち 通り道"
"とおる 逹 享 融 亨 透 理 徹 達"
"とおわ 十和"
"とおんきごう ト音記号"
"とか 徒過 渡河 都下"
"とかい 渡海 都会"
"とかげ 石竜子 蜥蜴"
"とかしき 渡嘉敷"
"とかち 十勝"
"とが 栂 都雅 利賀 図画 科 咎"
"とがい 都外"
"とがうち 戸河内"
"とがき ト書き ト書"
"とがくし 戸隠"
"とがし 冨樫 富樫"
"とがにん 咎人"
"とがのお 栂尾"
"とがま 利鎌"
"とがみ 戸上"
"とがめ 咎め"
"とがり 戸苅 戸狩"
"とがりごえ 尖り声"
"とがわ 外川 戸川"
"とき 常 穐 秋 時間 辰 晨 刻 斎 鬨 土岐 鴾 鴇 朱鷺 時"
"ときいらい 時以来"
"ときいろ 鴇色"
"ときえだ 時枝"
"ときお 時郎 登紀夫 時生 時夫 時雄 時男"
"ときおか 時岡"
"ときおり 時おり 時折"
"ときかた 解き方"
"ときがし 時貸し"
"ときがらし 溶き芥子"
"ときがり 時借り"
"ときがわ 都幾川"
"ときぐし 解き櫛"
"ときこ 時空子 登紀子 時子"
"ときさだ 時貞"
"ときざわ 鴇沢"
"ときじろう 時次郎"
"ときそば 時蕎麦"
"ときた 時田"
"ときたま 時偶"
"ときたまご 溶卵 溶き卵"
"ときだ 時田"
"ときだいこ 時太鼓"
"ときち 十吉"
"ときつ 時津"
"ときとう 時任"
"ときどき 時時 時々"
"ときなし 時無し"
"ときならぬ 時ならぬ"
"ときに 時に"
"ときね 十樹根"
"ときのうじがみ 時の氏神"
"ときのうん 時の運"
"ときのこえ 鬨の声"
"ときのひと 時の人"
"ときひろ 時弘 時広"
"ときび 斎日"
"ときぶんかつ 時分割"
"ときまさ 常正"
"ときもの 解き物"
"ときょう 都響"
"ときょうそう 徒競走"
"ときよ 時世"
"ときりょう 斎料"
"ときわ 常葉 常磐 常盤"
"ときわかえで 常磐楓"
"ときわぎ 常磐木"
"ときわじゅ 常盤樹"
"ときわず 常磐津"
"ときわずぶし 常磐津節"
"ときわまつ トキワ松"
"ときん 頭襟 兜巾 頭巾 と金 鍍金"
"ときんそう 吐金草"
"とぎ 砥 研ぎ 富来 伽 都議"
"とぎし 砥師"
"とぎじる 磨ぎ汁"
"とぎつ 時津"
"とぎばなし 伽噺 伽話"
"とぎゃく 吐逆"
"とぎょ 蠹魚 渡御"
"とぎれ 跡切れ 途切れ"
"とぎん 都銀"
"とく 疾く 讀 読 牘 黷 犢 涜 悳 篤 禿 督 慝 匿 特 徳 得"
"とくい 特異 得意"
"とくいく 徳育"
"とくいち 徳一"
"とくいんがい 特飲街"
"とくえ 徳衛"
"とくえい 徳衛"
"とくお 十九夫 徳男 徳雄"
"とくおか 徳岡"
"とくか 特化"
"とくがき 徳垣"
"とくがく 督学 篤学"
"とくがわ 徳川"
"とくがわいえさだ 徳川家定"
"とくがわいえしげ 徳川家重"
"とくがわいえつぐ 徳川家継"
"とくがわいえつな 徳川家綱"
"とくがわいえなり 徳川家斉"
"とくがわいえのぶ 徳川家宣"
"とくがわいえはる 徳川家治"
"とくがわいえよし 徳川家慶"
"とくがわつなよし 徳川綱吉"
"とくがわみつくに 徳川光圀"
"とくがわむせい 徳川夢声"
"とくき 特記"
"とくぎ 徳義 特技"
"とくぎょう 徳業 得業"
"とくぐん 督軍"
"とくこ 徳子"
"とくこう 特高 徳行"
"とくごうとうげ 徳本峠"
"とくさ 木賊"
"とくさく 得策"
"とくさつ 特撮"
"とくさぶろう 徳三郎"
"とくさわ 徳沢"
"とくさん 特産"
"とくし 特旨 得之 特使 篤志"
"とくしってん 得失点"
"とくしつ 得失 特質"
"とくしま 徳島"
"とくしゃ 特写 特車 特赦"
"とくしゅ 特種 特殊"
"とくしゅう 特集"
"とくしゅこう 特殊鋼"
"とくしゅつ 特出"
"とくしょ 特書"
"とくしょう ∃ 特称 特賞"
"とくしょく 涜職 特色"
"とくしん 得真 涜神 篤信 得心 特進"
"とくじ 徳地 徳次 徳治"
"とくじつ 篤実"
"とくじゅ 特需"
"とくじょう 特上"
"とくじん 徳人"
"とくずき 特漉き"
"とくせい 涜聖 徳星 徳政 徳性 特製 特性"
"とくせつ 特設"
"とくせん 特専 督戦 特薦 特撰 特選"
"とくせんたい 特戦隊"
"とくそう 禿瘡 徳操 得宗 徳宗 特装 得喪 特捜"
"とくそく 督促"
"とくそほう 特措法"
"とくそん 特損"
"とくぞう 徳蔵"
"とくたい 特待"
"とくたろう 徳太郎"
"とくだ 得田 徳田"
"とくだい 特大"
"とくだいじ 徳大寺"
"とくだつ 得脱"
"とくだね 特種 特ダネ"
"とくだわら 徳俵"
"とくだん 特段"
"とくち 渡久地"
"とくちしゅぎ 徳治主義"
"とくちゅう 特注"
"とくちょう 特長 特徴"
"とくてい 特定"
"とくていほけんようしょくひん 特定保健用食品"
"とくてん 特点 得点 特典"
"とくでん 特電"
"とくとう 禿頭 特等"
"とくとく 得得 得々"
"とくとみ 徳冨 徳富"
"とくど 得度"
"とくどう 得道"
"とくなが 徳永"
"とくに 特に"
"とくにん 特認 特任"
"とくのう 篤農 特濃"
"とくのしま 徳之島"
"とくは 特派"
"とくはい 特配"
"とくはし 徳橋"
"とくはつ 禿髪 特発"
"とくはら 徳原"
"とくばい 特売"
"とくばん 特番"
"とくひさ 徳久"
"とくひつ 特筆"
"とくひょう 得票"
"とくひら 徳平"
"とくひろ 徳弘"
"とくぶん 得分"
"とくへい 徳平"
"とくべつ 特別"
"とくほう 特報"
"とくほん 読本"
"とくぼう 徳望"
"とくま 徳間"
"とくまる 得丸 徳丸"
"とくみ 徳見 徳美"
"とくみち 篤道"
"とくみつ 徳光"
"とくむ 特務"
"とくめい 特命 匿名"
"とくもく 徳目"
"とくもと 徳元 徳本"
"とくもり 特盛"
"とくやく 特約"
"とくやす 徳康"
"とくやま 徳山"
"とくゆう 特融 特有"
"とくゆき 得之 徳行"
"とくよう 特用 特養 徳用"
"とくようぶくろ 徳用袋"
"とくら 都倉 十倉 戸倉"
"とくり 徳利"
"とくりつ 特立"
"とくれい 督励 特例"
"とくろん 特論"
"とくわり 特割"
"とぐち 戸口"
"とぐら 戸倉"
"とぐろ 塒 蜷局"
"とけ 土気"
"とけい 都計 土圭 徒刑 時計"
"とけいそう 時計草"
"とけいとう 時計塔"
"とけつ 吐血"
"とけん 覩見 都県"
"とげ 朿 刺 棘"
"とげうお 棘魚"
"とげっぽう 吐月峰"
"とげつきょう 渡月橋"
"とげぬき 刺抜き"
"とこ 常 床"
"とこあげ 床上げ"
"とこい 常井"
"とこいた 床板"
"とこいり 床入り"
"とこう 都甲 渡航"
"とこうし 塗工紙"
"とこがまち 床框"
"とこし 戸越"
"とこしえ 常しえ 永久"
"とこしき 床敷"
"とこじょうず 床上手"
"とこずれ 床擦れ"
"とこだたみ 床畳"
"とこつち 床土"
"とこなつ 常夏"
"とこなめ 常滑"
"とこなめやき 常滑焼"
"とこのま 床ノ間 床の間"
"とこは 常葉"
"とこはる 常春"
"とこばしら 床柱"
"とこばなれ 床離れ"
"とこばらい 床払い"
"とこぶし 常節"
"とこみせ 床店 床見世"
"とこや 床屋"
"とこやま 床山"
"とこやみ 常闇"
"とこよ 常夜 常世"
"ところ 野老 處 処 所"
"ところが 処が"
"ところがき 所書"
"ところがら 所柄"
"ところことば 所言葉"
"ところざわ 所沢"
"ところてん 瓊脂 心太"
"ところてんぐさ 心太草"
"ところどころ 所々"
"ところばらい 所払い"
"ところばんち 所番地"
"とこわか 常若"
"とこん 吐根"
"とごう 戸郷 渡豪"
"とさ 土佐"
"とさいぬ 土佐犬"
"とさか 戸坂 鶏冠"
"とさけん 土佐犬"
"とさつ 塗擦 屠殺"
"とさにっき 土左日記"
"とさぶし 土佐節"
"とさんせん 土讃線"
"とざい 吐剤 塗材"
"とざき 戸崎"
"とざと 外里"
"とざま 外様"
"とざわ 戸沢"
"とざん 登山"
"とし 敏 肇 駿 夙 祀 壽 繁 世 暁 稔 捷 寿 俊 利 徒死 都市 歳 年"
"としあき 繁明 年昭 敏彰 敏朗 俊朗 聡明 俊章 俊彰 寿明 敏昭 利昭 俊昭 敏明 利明 俊明"
"としあけ 年明け"
"としうえ 年上"
"としうら 年占"
"としえ 利絵 敏枝 俊恵 とし恵 季衣 敏江"
"としお 稔雄 利朗 俊朗 淑夫 利生 寿男 寿雄 寿夫 登志夫 敏郎 利男 俊男 利雄 敏男 利夫 敏雄 俊雄 俊夫 敏夫"
"としおとこ 年男"
"としおんな 年女"
"としかさ 年嵩"
"としかず 寿和 利和 敏一 寿一 敏和 俊和 利一 俊一"
"としかっこう 年恰好 年格好"
"としかつ 敏克 利勝"
"としがい 年甲斐"
"としがす 都市ガス"
"としき 戸敷 歳樹 年紀 稔貴 年樹 敏生 敏樹 俊樹"
"としくに 年邦"
"としくれ 年暮れ"
"としこ 年子 トシ子 登志子 とし子 寿子 利子 淑子 俊子 敏子"
"としこし 年越し"
"としご 年子"
"としごいのまつり 祈年祭"
"としごと 年毎"
"としごもり 年籠り"
"としごろ 年頃"
"とししげ 利重"
"としした 年下"
"としじ 俊治"
"としそうおう 年相応"
"としぞう 俊三"
"としたか 利孝 俊孝 敏隆"
"としただ 俊匡 利忠"
"としたに 利谷"
"としだか 年高"
"としだま 年玉"
"としつき 年月"
"としつぐ 壽二 俊嗣 敏嗣"
"としづよ 年強"
"としてる 敏輝"
"としとりざかな 年取り魚"
"としなお 利直 俊直"
"としなか 年半 年中"
"としなみ 年波"
"としなり 利成"
"としのうち 年の内"
"としのこう 年の功"
"としのころ 年の頃"
"としのせ 歳の瀬 年の瀬"
"としのは 年の端"
"としのぶ 敏伸 利伸 利信"
"としのよ 年の夜"
"としのり 敏規 年紀 寿則 聡徳 利典 俊範 敏憲 利則 敏則 俊則"
"としは 年端"
"としはる 季栄 寿晴 敏治 俊治 利治"
"としひこ 捷彦 年彦 壽彦 稔彦 寿彦 利彦 敏彦 俊彦"
"としひさ 敏寿 利久 俊久"
"としひで 俊秀 俊英"
"としひと 敏仁"
"としひろ 歳弘 敏啓 利浩 俊浩 敏裕 利宏 利広 俊裕 利弘 利博 敏宏 俊宏 俊弘 俊博 敏弘"
"としふさ 俊房"
"としふみ 年史 俊史 俊文 敏文"
"としほど 年程"
"としま 戸嶋 戸島 十島 利島 年増 豊島"
"としまおか 豊島岡"
"としまさ 敏正"
"としまわり 年回り"
"としみ 都志見 敏巳 年美 寿実 利美"
"としみち 季道 利道 俊道 利通"
"としみつ 敏光 俊光 利光"
"としゃ 吐瀉"
"としや 利也 俊弥 敏哉 敏也 俊也 俊哉"
"としやす 敏靖 敏康 利泰"
"としゅ 斗酒 徒手"
"としゅつ 吐出"
"としゆき 歳之 利行 利之 俊行 敏幸 俊幸 利幸 敏行 敏之 俊之"
"としょ 屠所 図書"
"としょう 杜松 渡渉"
"としょうじつ 杜松実"
"としょかーど 図書カード"
"としょかかり 図書掛"
"としょく 徒食 塗色"
"としょりょう 図書寮"
"としよ 敏代"
"としより 年寄り 年寄"
"としよわ 年弱"
"としろう 利郎 俊朗 俊郎 敏郎"
"としわか 年若"
"としわすれ 年忘れ"
"としわり 年割り 年割"
"としん 兎唇 妬心 都心"
"とじ 徒爾 徒事 刀自 途次 杜氏 賭事 綴じ 綴"
"とじいと 綴じ糸"
"とじかっこ 閉括弧"
"とじき 戸敷"
"とじしろ 綴じ代"
"とじぶた 綴じ蓋"
"とじほん 綴本"
"とじま 戸島"
"とじまり 戸締り"
"とじょう 図情 屠場 外城 登城 都城 途上"
"とじん 都塵 都人"
"とす 鳥栖"
"とせ 歳"
"とせい 都政 渡世"
"とせん 渡船"
"とぜい 都税"
"とぜつ 杜絶 途絶"
"とぜん 徒然"
"とそ 屠蘇"
"とそう 塗装"
"とそさん 屠蘇散"
"とそつ 兜率"
"とそつてん 兜率天"
"とそぶくろ 屠蘇袋"
"とたん 塗炭 途端"
"とたんちょう ト短調"
"とたんのくるしみ 塗炭の苦しみ"
"とたんぶき トタン葺き"
"とたんやね トタン屋根"
"とだ 戸田"
"とだい 東京都立大学 都大"
"とだか 戸高"
"とだな 戸棚"
"とち 柮 杤 栃 橡 土地"
"とちお 栃尾"
"とちかがみもく トチカガミ目"
"とちかわ 橡川"
"とちかん 土地鑑 土地勘"
"とちぎ 朽木 栃木"
"とちく 屠畜"
"とちざわ 栃沢"
"とちない 栃内"
"とちのき 栃 橡"
"とちのわか 栃乃和歌"
"とちめん 栃麺"
"とちめんぼう 栃麺棒"
"とちもと 栃本"
"とちゅう 杜仲 途中"
"とちゅうこうき 途中降機"
"とちょう 徒長 登頂 都庁"
"とちょうし 徒長枝"
"とちょうちょう ト長調"
"とちわかじだい 栃若時代"
"とっか 徳化 特科 特化 特価"
"とっかい 特解 特会 特快"
"とっかえひっかえ 取っ替え引っ替え"
"とっかかり 取っ掛り 取っ掛かり"
"とっかく 凸角 突角"
"とっかん 吶喊 突貫"
"とっき 特器 特機 突起 特記"
"とっきゅう 特級 特急"
"とっきょ 特許"
"とっきょう 徳教"
"とっきん 特金"
"とっく 疾く 疾っく 特区"
"とっくみあい 取っ組み合い"
"とっくり 徳利"
"とっくん 特訓"
"とっけい 特恵"
"とっけつ 突厥"
"とっけん 特研 特権"
"とっこ 独鈷"
"とっこう 篤行 特高 徳行 特講 特効 特攻"
"とっこつ 突兀"
"とっさ 咄嗟"
"とっしゅつ 突出"
"とっしん 突進"
"とったん 突端"
"とって 把っ手 取手 把手 取っ手"
"とってい 突堤"
"とっておき 取って置き"
"とっとり 鳥取"
"とっぱ 鳥羽 突破"
"とっぱつ 突発"
"とっぱつしん 突発疹"
"とっぱん 凸版"
"とっぴ 突飛"
"とっぴょうし 突拍子"
"とっぷう 突風"
"とっぷかいだん トップ会談"
"とっぷきじ トップ記事"
"とっぷきゅう トップ級"
"とっぷした トップ下"
"とっぷしょう トップ賞"
"とっぷつ 突沸"
"とっぷてん トップ10"
"とつ 訥 吶 柮 咄 凸 突"
"とつおう 凸凹"
"とつか 戸塚"
"とつかく 凸角"
"とつかわ 十津川"
"とつかんすう 凸関数"
"とつがた 凸型"
"とつがわ 十津川"
"とつきとうか 十月十日"
"とつきとおか 十月十日"
"とつぎさき 嫁ぎ先"
"とつくに 外つ国"
"とつけつごう 凸結合"
"とつげき 突激 突撃"
"とつごう 突合"
"とつじょ 突如"
"とつぜん 突然"
"とつでん 凸電"
"とつとつ 訥訥 吶々 咄々 訥々"
"とつとつかいじ 咄咄怪事"
"とつにゅう 突入"
"とつへいほう 凸閉包"
"とつべん 訥弁"
"とつほう 凸包"
"とつめん 凸面"
"とつめんきょう 凸面鏡"
"とつれんず 凸レンズ"
"とづか 戸塚"
"とてい 徒弟"
"とてつ 途轍"
"とても 迚 迚も"
"とでん 都電"
"ととう 渡頭 渡唐 徒党 渡島"
"ととき 十時"
"ととく 都督"
"ととさま 父様"
"ととや 魚屋"
"ととりべ 鳥取部"
"とど 椴"
"とどう 都道"
"とどうふけんざかい 都道府県境"
"とどく 渡独"
"とどけ 屆 届け 届"
"とどけがき 届書"
"とどけさき 届先"
"とどけしょ 届書"
"とどけで 届出"
"とどけでずみしょう 届出済証"
"とどこおり 滞り"
"とどほっけむら 椴法華村"
"とどまつ 椴 椴松"
"とどむ 閼"
"とどめ 止め"
"とどめる 閼"
"とどろ 轟"
"とどろき 軣 轟 等々力 轟き"
"とどろきおん 轟音"
"とどん 吐呑"
"とない 都内"
"となかい 馴鹿"
"となき 渡名喜"
"となみ 渡並 外波 礪波 砺波"
"となり 鄰 隣り 隣"
"となりあわせ 隣合わせ"
"となりきんじょ 隣近所"
"となりぐみ 隣組"
"となりどうし 隣同士"
"となりまち 隣町"
"となりむら 隣村"
"となん 都南"
"とにかく 兎に角"
"とにく 屠肉"
"とにち 渡日"
"とにもかくにも 兎にも角にも"
"とにゅう 吐乳"
"とね 刀禰 刀根 利根"
"とねり 舎人"
"との 殿"
"とのい 宿直"
"とのいびと 宿直人"
"とのうち 登内"
"とのおか 外岡"
"とのがた 殿方"
"とのこ 砥粉 砥の粉"
"とのご 殿御"
"とのさき 外崎"
"とのさま 殿様"
"とのさまがえる 殿様蛙"
"とのしょう 土庄"
"とのづくり 殿作り"
"とのと 殿戸"
"とのま 殿馬"
"とのみ 富海"
"とのも 主殿"
"とのもり 主殿"
"とのもりりょう 主殿寮"
"とのやまちょう 殿山町"
"とはい 徒輩"
"とはいえ とは言え"
"とはん 登坂 登攀"
"とば 賭場 鳥羽"
"とばく 賭博"
"とばくち とば口"
"とばす 都バス"
"とばた 戸畑"
"とばふしみのたたかい 鳥羽伏見の戦い"
"とばり 戸張り 幃 幄 戸張 帷 帳"
"とひ 徒費 都費 都鄙"
"とび 飛び 鵄 鴟 鳶"
"とびいし 飛石 飛び石"
"とびいり 飛入り"
"とびいろ 鳶色"
"とびうお 飛魚"
"とびおか 飛岡"
"とびおり 飛下り 飛降り 飛び下り 飛び降り"
"とびきり 飛切り"
"とびぐち 鳶口"
"とびげり 飛び蹴り"
"とびこ 飛子"
"とびこみじさつ 飛込み自殺"
"とびさき 飛先"
"とびしま 飛島"
"とびしょく 鳶職"
"とびた 飛田"
"とびだし 飛出し"
"とびち 飛地"
"とびどうぐ 飛道具"
"とびのうお 飛びの魚"
"とびばこ 飛び箱"
"とびひ 飛火 飛び火"
"とびら 扉"
"とびらいち 扉位置"
"とびらえ 扉絵"
"とびらせん 扉線"
"とびわし 飛鷲"
"とふ 妬婦 都府 塗布"
"とふぎょ 杜父魚"
"とふご 塗付後"
"とふつ 渡仏"
"とぶくろ 戸袋"
"とぶくろまど 戸袋窓"
"とぶすま 戸襖"
"とぶつ 吐物"
"とぶとり 飛ぶ鳥"
"とぶらい 弔い"
"とべ 砥部 戸部"
"とべい 渡米"
"とべやき 砥部焼"
"とほ 杜甫 徒歩"
"とほう 途方"
"とほそくはつ 吐哺捉髪"
"とぼく 杜牧"
"とぼそ 枢"
"とま 笘 篷 苫"
"とまく 塗膜"
"とまこまい 苫小牧"
"とましの 苫篠"
"とます 斗"
"とまた 攴 苫田"
"とまつ 塗沫 戸松 塗抹"
"とまとかん トマト缶"
"とまとに トマト煮"
"とまどい 戸惑い"
"とまぶね 苫舟"
"とまべち 苫米地"
"とままえ 苫前"
"とまや 苫屋"
"とまり 渡真利 泊 泊り 泊まり"
"とまりぎ 止り木 止まり木"
"とみ 當 登美 冨 頓 富"
"とみあい 富合"
"とみい 富井"
"とみうら 冨浦 富浦"
"とみえ 富江"
"とみお 富美男 富男 富夫 富雄"
"とみおか 冨岡 富岡"
"とみおかにし 富岡西"
"とみか 富加"
"とみかわ 富川"
"とみくじ 富籤"
"とみぐすく 豊見城"
"とみこ 富美子 登美子 富子"
"とみこうみ 左見右見"
"とみさと 富里"
"とみさわ 冨沢 富沢"
"とみざわ 富澤 富沢"
"とみしま 富島"
"とみしろ 都城"
"とみしろこうこう 豊見城高校"
"とみじ 富治"
"とみじゅうろう 富十郎"
"とみた 冨田 富田"
"とみたろう 富太郎"
"とみつかちょう 富塚町"
"とみて 冨手"
"とみとく 富徳"
"とみなが 冨永 富永"
"とみなり 冨成"
"とみに 頓に"
"とみの 富野"
"とみはま 富浜"
"とみはり 富張"
"とみひこ 富彦"
"とみひさ 富久"
"とみまつ 富松"
"とみもと 富本"
"とみもとぶし 富本節"
"とみや 富谷"
"とみやす 富安"
"とみやま 鳥見山 富山"
"とみよ 富魚"
"とみよし 富吉"
"とみん 都民"
"とむ 吐夢"
"とむら 外村 戸村"
"とむらい 弔い"
"とめ 止め 留め 登米 留"
"とめおき 留置"
"とめがね 留金 止め金"
"とめきち 留吉"
"とめこ 留子"
"とめしょ 留所"
"とめじ 留治"
"とめそで 留袖"
"とめど 留処 止処 止め処"
"とめば 留場"
"とめやま 留山"
"とめん 塗面"
"とも 舮 靹 恭 具 智 知 朝 侶 伴 艫 鞆 朋 供 共 友"
"ともあき 恭章 公暁 公明 智彰 倫明 智朗 智明"
"ともい 友井"
"ともいし 友石"
"ともいち 友一"
"ともいろ 共色"
"ともうら 共裏"
"ともえ 友衛 知重 巴"
"ともえがたどうき 巴形銅器"
"ともえがわ 巴川"
"ともえがわら 巴瓦"
"ともえぐみ 巴組"
"ともえだ 友枝"
"ともえなげ 巴投げ"
"ともえふじ 巴富士"
"ともえり 共襟"
"ともお 友朗 朋夫 智央 知夫 友雄 智夫 智雄"
"ともおか 友岡"
"ともか 友香"
"ともかがみ 共鏡"
"ともかく 兎も角"
"ともかくも 兎も角も"
"ともかず 共和 友和 智一 智和"
"ともがおか 友ヶ丘"
"ともがき 友垣"
"ともがら 讎 讐 輩"
"ともき 朋喜 友喜 友紀 知樹 智樹"
"ともきち 友吉"
"ともきよ 友清"
"ともくに 友國"
"ともぐい 共食い"
"ともこ 朝子 とも子 倫子 友子 朋子 知子 智子"
"ともざ 船尾座 艫座"
"ともざる 友猿"
"ともし 知士"
"ともしび 灯し火 燭 燈 灯火 灯"
"ともじ 十文字 知司 友治"
"ともぞう 友蔵"
"ともたか 友隆 智孝"
"ともたけ 智武"
"ともたろう 智太郎"
"ともだ 友田"
"ともだち 友だち 友達"
"ともち 砥用"
"ともちか 朋哉 知親 友近"
"ともづな 纜"
"ともづり 友釣"
"ともづる 友鶴"
"ともとし 智年"
"ともども 共々"
"ともなか 邑中"
"ともなが 朝永 朝長 友永"
"ともながしんいちろう 朝永振一郎"
"ともなり 友成"
"ともに 倶に 共に"
"ともぬの 共布"
"ともね 共寝 鞆音"
"ともの 伴野 友野"
"とものうら 鞆の浦"
"とものかい 友の会"
"とものり 知紀 知徳 知典 智規 智紀 智則 友紀 智徳 友則"
"ともはな 友花"
"ともはる 知治 智春"
"ともばたらき 共働き"
"ともひこ 朋彦 知彦 友彦 智彦"
"ともひさ 朋久 友久 知久 智久"
"ともひで 知英 友秀 智秀"
"ともひと 智斉 智仁"
"ともひろ 共洋 恭祐 朋博 友洋 知浩 友広 朋宏 智洋 智浩 知宏 智博 智広 智弘"
"ともびき 友引"
"ともふさ 智英"
"ともへ 艫舳"
"ともべ 友部"
"ともべや 供部屋"
"ともまさ 智真"
"ともまつ 友松"
"ともみ 知視 朋三 具美 具実 友海 知実 智己 智巳 友視 具視 とも美 智美 知美 朋美"
"ともみち 伴通 智道 友道"
"ともみつ 伴光"
"ともみはら 倶美原"
"とももり 知盛"
"ともや 知也 智也"
"ともやす 朋康 友康"
"ともゆき 共之 朋幸 友幸 朋之 智幸 智行 知行 知之 智之"
"ともよ 智世 知代 知世"
"ともよし 知節 智由 友良 智義 知義"
"ともらい 弔い"
"とや 外谷 戸谷 鳥屋"
"とやかく 兎や角"
"とやま 戸山 外山 富山"
"とやましんこう 富山新港"
"とゆ 樋"
"とゆう 都邑 都有"
"とよ 豐 樋 豊"
"とよあき 豊明"
"とよあきつしま 豊秋津洲"
"とよあけ 豊明"
"とよあしはら 豊葦原"
"とよう 渡洋"
"とようち 豊内"
"とようら 豊浦"
"とよおか 豊丘 豊岡"
"とよかず 豊和"
"とよかわ 豊川"
"とよがおか 豊ヶ丘"
"とよき 豊樹"
"とよきち 豊吉"
"とよぎだい 豊技大"
"とよくに 豊国"
"とよくら 豊倉"
"とよこ 豊子"
"とよこう 豊高"
"とよころ 豊頃"
"とよさか 豊栄"
"とよさき 豊崎"
"とよさく 豊作"
"とよさと 豊郷 豊里"
"とよさわ 豊沢"
"とよしき 豊四季"
"とよしな 豊科"
"とよしま 豊嶋 豊島"
"とよじ 豊治"
"とよす 豊洲"
"とよた 豊田"
"とよたけ 豊竹"
"とよたしゃたい トヨタ車体"
"とよたじどうしゃ トヨタ自動車"
"とよたま 豊玉"
"とよたろう 豊太郎"
"とよだ 豊田"
"とよつ 豊津"
"とよてつ 豊鉄"
"とよとし 豊年"
"とよとみ 豊富 豊臣"
"とよなか 豊中"
"とよね 豊根"
"とよの 豊野 豊能"
"とよのぶ 豊伸 豊信"
"とよのぼり 豊登"
"とよはし 豊橋"
"とよはしきた 豊橋北"
"とよはま 豊浜"
"とよはら 豊原"
"とよひこ 豊彦"
"とよひさ 豊久"
"とよひせん 豊肥線"
"とよひと 十余一"
"とよひほんせん 豊肥本線"
"とよひら 豊平"
"とよひろ 豊広 豊弘"
"とよふく 豊福"
"とよふみ 東洋史 豊文"
"とよま 登米"
"とよまえかわさき 豊前川崎"
"とよまつ 豊松"
"とよまる 豊丸"
"とよやま 豊山"
"とら 乕 寅 虎"
"とらい 戸来 渡来"
"とらいち 寅市"
"とらえかた 捉え方"
"とらえどころ 捉え所"
"とらお 寅男 寅雄 虎男 虎雄"
"とらかんむり 虎冠"
"とらがしら 虎頭"
"とらがり 虎狩り 虎刈り"
"とらきち 虎吉 寅吉"
"とらぎ トラ技"
"とらくす 寅楠"
"とらさん 寅さん"
"とらぞう 虎三 虎造"
"とらとう 虎党"
"とらどし 寅年"
"とらねこ 虎猫"
"とらのこ 虎の子"
"とらのまき 虎の巻"
"とらのもん 虎の門 虎ノ門"
"とらひこ 寅彦"
"とらひめ 虎姫"
"とらふぐ 虎河豚"
"とらわれ 囚われ"
"とり 取り 取 鷄 図利 禽 酉 鶏 鳥"
"とりあい 取合い 取り合い"
"とりあえず 取りあえず 取り敢えず"
"とりあたま 鳥頭"
"とりあつかい 取扱い 取扱"
"とりあわせ 取り合せ 取合せ"
"とりい 鳥井 鳥居"
"とりいそぎ 取り急ぎ"
"とりいれ 取入れ"
"とりいんふるえんざ 鳥インフルエンザ"
"とりう 鳥生"
"とりうち 鳥打ち"
"とりうちぼう 鳥撃帽"
"とりうみ 鳥海"
"とりうむけいれつ トリウム系列"
"とりうら 鳥占"
"とりえ 取得 取柄 取り得 取り柄"
"とりお 鳥尾"
"とりおい 鳥追い 鳥追"
"とりおどし 鳥威し"
"とりかい 鳥飼"
"とりかえ 取替 取替え"
"とりかげ 鳥影"
"とりかご 鳥籠"
"とりかじ 取舵 取り舵"
"とりかぶと 鳥兜"
"とりがい 鳥貝 鳥飼"
"とりがしら 鳥頭"
"とりがた 鳥潟"
"とりがら 鳥ガラ 鶏ガラ"
"とりき 取木 取り木"
"とりきめ 取り極め 取極 取決め"
"とりくち 取口"
"とりくみ 取組み 取組 取り組み"
"とりくんだ 取り組んだ"
"とりけし 取消し 取消"
"とりげ 鳥毛"
"とりこ 虜擒 取り子 取り粉 俘 擒 虜"
"とりこし 取り越し"
"とりこしぐろう 取越し苦労 取り越し苦労"
"とりこぼし 取り零し"
"とりこみ 取込"
"とりこみさぎ 取込み詐欺"
"とりこわし 取壊し 取り壊し"
"とりごえ 鳥越"
"とりごや 鳥小屋"
"とりさか 鳥坂"
"とりさげ 取下 取下げ"
"とりさわ 鳥澤 鳥沢"
"とりざた 取沙汰 取りざた"
"とりざら 取皿"
"とりしま 鳥島"
"とりしまり 取締り 取締"
"とりしらべ 取調 取調べ"
"とりす 鳥巣"
"とりせつ 取説"
"とりたち 鳥達"
"とりたて 取立 取立て"
"とりたに 鳥谷"
"とりだい 鳥大"
"とりだか 取高"
"とりだし 取出"
"とりだんご 鶏団子"
"とりつ 都立"
"とりつぎ 取り次ぎ 取次ぎ 取次"
"とりつけ 取付け 取付"
"とりつだい 東京都立大学"
"とりづか 取り束"
"とりてき 取的"
"とりてん 鳥天"
"とりで 塞 取手 砦"
"とりとりべ 鳥取部"
"とりどし 酉年"
"とりなおし 取直し"
"とりにく 鳥肉 鶏肉"
"とりにんげん 鳥人間"
"とりのいち 酉の市"
"とりのこ 鳥の子"
"とりのす 鳥の巣"
"とりはからい 取計らい"
"とりはずし 取外し 取り外し"
"とりはだ 鳥肌"
"とりばし 取り箸"
"とりひき 取引き 取引"
"とりひきだかぜい 取引高税"
"とりぶえ 鳥笛"
"とりぶん 取分"
"とりぷるやす トリプル安"
"とりべの 鳥辺野"
"とりまき 取巻 取巻き"
"とりまわし 取回し"
"とりみ 鳥見"
"とりめ 鳥目"
"とりめにあか トリメニア科"
"とりもち 鳥黐"
"とりもどしけん 取戻権"
"とりもなおさず 取りも直さず"
"とりもの 捕り物 捕物"
"とりものちょう 捕物帖"
"とりや 鳥谷 鳥屋"
"とりやま 鳥山"
"とりょう 斗量 塗料"
"とりよせ 鳥寄せ 取寄せ"
"とりりょうり 鳥料理"
"とりろう 鶏郎"
"とりわき 鳥脇"
"とりわけ 取分け"
"とるこ 土耳其 土耳古"
"とるこいし トルコ石"
"とるこじん トルコ人"
"とるこだま トルコ玉"
"とるこぶろ トルコ風呂"
"とるこぼう トルコ帽"
"とるこりょうり トルコ料理"
"とれたて 取れ立て 穫れたて 獲れたて"
"とれだか 取れ高"
"とれつ 堵列"
"とれん 都連"
"とろ 瀞 吐露"
"とろーるぎょぎょう トロール漁業"
"とろーるせん トロール船"
"とろいあせんそう トロイア戦争"
"とろいせき 登呂遺跡"
"とろう 徒労"
"とろばこ トロ箱"
"とろび とろ火"
"とろろ 黄蜀葵 薯蕷"
"とろろあおい 黄蜀葵"
"とろろいも とろろ芋 薯蕷芋"
"とろろこんぶ とろろ昆布"
"とろろじる とろろ汁"
"とろん 徒論"
"とわ 登和 常 永久 永遠"
"とわずがたり 問わず語り"
"とわたり 門渡り"
"とわだ 十和田"
"とわだこ 十和田湖"
"とん 丼 東 團 団 問 遯 遁 燉 暾 敦 惇 飩 沌 屯 頓 瓲 噸 豚"
"とんあい 貪愛"
"とんいっきょく 東一局"
"とんえい 屯営"
"とんかつ 豚カツ"
"とんかつや とんかつ屋"
"とんがらし 唐辛子"
"とんがりぼうし 尖り帽子"
"とんきょう 頓興 頓狂"
"とんきんわん トンキン湾"
"とんぐう 頓宮"
"とんこう 燉煌 遁甲 敦煌"
"とんこつ 豚骨"
"とんご 頓悟"
"とんさんきょく 東三局"
"とんざ 頓挫"
"とんざい 屯在"
"とんし 豚脂 頓死"
"とんしゃ 頓写 豚舎"
"とんしゅ 頓首"
"とんしょ 屯所"
"とんしょうぼだい 頓証菩提"
"とんじ 豚児 遁辞"
"とんじゃく 貪着 頓着"
"とんじょ 東女"
"とんじる 豚汁"
"とんじんち 貪瞋痴"
"とんすう トン数"
"とんず 筒子"
"とんせい 遯世 遁世"
"とんそう 遁走"
"とんそく 豚足"
"とんぞく 遁俗"
"とんだばやし 富田林"
"とんち 頓智 頓知"
"とんちき 頓痴気"
"とんちゃく 頓着"
"とんちんかん 頓珍漢"
"とんでん 屯田"
"とんとろ 豚トロ"
"とんとんびょうし とんとん拍子"
"とんどん 豚丼"
"とんない 貪愛"
"とんなんしゃぺい 東南西北"
"とんにきょく 東二局"
"とんにく 豚肉"
"とんねるこうか トンネル効果"
"とんば 東場"
"とんばら 頓原"
"とんび 鳶"
"とんぷうそう 東風荘"
"とんぷく 頓服"
"とんぼ 蜻蛉"
"とんぼがえり とんぼ返り 蜻蛉返り"
"とんま 頓馬"
"とんや 問屋"
"とんやせいかないこうぎょう 問屋制家内工業"
"とんよく 貪欲"
"ど 堵 孥 呶 駑 戸 ℃ ° 弩 努 怒 奴 土 度"
"どーなつばん ドーナツ盤"
"どーばーかいきょう ドーバー海峡"
"どーむきゅうじょう ドーム球場"
"どあい 度合 度合い"
"どあごし ドア越し"
"どあつ 土圧"
"どあほ ど阿呆"
"どい 土居 土肥 土井"
"どいがき 土井垣"
"どいっき 土一揆"
"どいつ 独 獨乙 獨逸 独乙 何奴 独逸"
"どいつかんねんろん ドイツ観念論"
"どいつぐん ドイツ軍"
"どいつご ドイツ語"
"どいつさん ドイツ産"
"どいつじん ドイツ人"
"どいつせい ドイツ製"
"どいつぶんか ドイツ文化"
"どいつぶんがく ドイツ文学"
"どいなか ど田舎 ド田舎"
"どう 々 ゞ 〃 鐃 橈 撓 藤 陶 儂 萄 嫐 閙 鬧 耨 瞠 獰 艟 僮 瞳 撞 憧 童 慟 働 桐 恫 導 如何 洞 動 堂 道 胴 銅 同"
"どうあい 同愛"
"どうあく 獰悪 道悪"
"どうあげ 胴上げ"
"どうあん 同案"
"どうあんたすう 同案他数"
"どうい 胴衣 同位 同意"
"どういつ 同一"
"どういん 導引 動因 動員"
"どうう 堂宇"
"どううら 胴裏"
"どうえい 道営"
"どうえき 同駅"
"どうえん 導演"
"どうおう 道央"
"どうおん 同音"
"どうか 導火 銅戈 道歌 同課 道家 銅貨 同価 同化"
"どうかく 動確 同角 同格"
"どうかごうぶつ 銅化合物"
"どうかつ 恫喝"
"どうかひか 同花被花"
"どうかん 道観 道灌 道管 導管 同感"
"どうかんすう 導関数"
"どうが 童画 動画"
"どうがい 道外"
"どうがく 道学 動学 同学 同額"
"どうがしま 堂ヶ島"
"どうがた 同型"
"どうがん 動眼 童顔"
"どうき 動気 同気 銅器 同機 動悸 動機 同期"
"どうきゅう 慟泣 撞球 同級"
"どうきょ 同居"
"どうきょう 同香 道鏡 銅鏡 道教 同郷"
"どうきょく 同曲 同局"
"どうきん 同斤 同金 同衾"
"どうぎ 道議 胴着 道着 動議 道義 同義"
"どうぎょう 童形 同行 同業"
"どうぎょく 同玉"
"どうぎん 同銀"
"どうく 同区"
"どうくつ 洞窟"
"どうくん 同君 同訓"
"どうぐ 道具"
"どうぐだたみ 道具畳"
"どうぐち 洞口"
"どうぐばこ 道具箱"
"どうけ 道家 同家 道化"
"どうけい 同桂 道警 動径 同慶 同形 同型 同系 憧憬"
"どうけつ 同穴 洞穴"
"どうけん 洞見 銅剣 同権 同県"
"どうげつ 同月"
"どうげん 道玄 道元 同源"
"どうげんざか 道玄坂"
"どうげんたい 動原体"
"どうこ 堂鼓 銅壺"
"どうこう 同庚 銅坑 同功 同甲 同興 道幸 道光 銅鉱 同工 同校 同項 同好 瞳孔 同行 動向"
"どうこうのし 同好の士"
"どうこうほう 道交法"
"どうこく 同刻 慟哭 同国"
"どうこん 同根 同梱"
"どうこんしき 銅婚式"
"どうご 同語 道後"
"どうごう 道号 同号"
"どうごうきん 銅合金"
"どうさ 同左 動作"
"どうさい 道斎"
"どうさぎれ 動作切"
"どうさつ 洞察"
"どうさん 道三 道産 動産"
"どうざ 動座 同座 銅座"
"どうざい 同罪"
"どうざん 銅山"
"どうし 同旨 道志 同視 道士 導師 同紙 同誌 同氏 同市 動詞 同志 同士"
"どうしうち 同士撃ち"
"どうした 堂下"
"どうしつ 同質 同室"
"どうして 如何して"
"どうしても 如何しても"
"どうしゃ 同車 動車 同社"
"どうしゅ 同株 同趣 同種"
"どうしゅう 同臭 銅臭 同衆 堂衆 同舟 同州"
"どうしゅうせい 道州制"
"どうしゅく 同宿"
"どうしゅつ 導出"
"どうしゅつぎ 導出木"
"どうしゅんてん 道春点"
"どうしょ 道書 同所 同書"
"どうしょう 道床 同床 同省 銅賞"
"どうしょく 銅色 同職 同色"
"どうしん 道新 道心 童神 童心 同心"
"どうじ 同字 動時 同次 童子 同時"
"どうじく 同軸"
"どうじくけーぶる 同軸ケーブル"
"どうじつ 同日"
"どうじま 堂島"
"どうじめ 胴締め"
"どうじゃく 瞠若"
"どうじゅつ 道術"
"どうじゅん 同順"
"どうじゅんかい 同潤会"
"どうじょ 童女"
"どうじょう 〃 仝 堂上 道上 同条 同乗 同上 同情 道場"
"どうじょうじ 道成寺"
"どうじょうやぶり 道場破り"
"どうじん 道仁 同仁 同人"
"どうすい 導水"
"どうすう 同数"
"どうず 同図"
"どうせい 道政 同声 動静 銅製 同姓 同性 同棲"
"どうせき 道関 同席"
"どうせん 同船 銅銭 導線 銅線 動線"
"どうぜい 同勢 道税"
"どうぜん 同前 同然"
"どうそ 同素 同祖"
"どうそう 同相 同窓"
"どうそく 同側"
"どうそじん 道祖神"
"どうそん 道村 同村"
"どうぞう 銅像"
"どうぞく 道俗 同属 同族"
"どうたい 道諦 動体 同体 導体 胴体 動態"
"どうたいけい 胴体径"
"どうたく 銅鐸"
"どうだい 同題 同大"
"どうだいら 堂平"
"どうだん 道斷 同段 満天星 同断 道断"
"どうだんつつじ 満天星"
"どうち ⇔ ≡ 同治 同値 同地"
"どうちゃく 撞着 同着"
"どうちゅう 道中"
"どうちょう 同庁 道庁 同調"
"どうちょうとせつ 道聴塗説"
"どうつう 導通"
"どうてい 同底 童貞 道程 同定"
"どうていこ 洞庭湖"
"どうてき 動的"
"どうてん 鬧天 動顛 動点 同店 動転 同点"
"どうてんだん 同点弾"
"どうでん 道伝 道傳 導電"
"どうと 道都"
"どうとう 道統 堂塔 同党 道東 同等"
"どうとく 道徳"
"どうとんぼり 道頓堀"
"どうどう 道道 道々 同道 堂々"
"どうどうめぐり 堂々巡り"
"どうない 道内"
"どうなが 胴長"
"どうなべ 銅鍋"
"どうなん 道南"
"どうにゅう 導入"
"どうにょう 導尿"
"どうにん 同人"
"どうねん 道念 動燃 同年"
"どうのじ 々"
"どうのじてん 々 同の字点"
"どうは 道破 導波"
"どうはい 同輩"
"どうはく 銅箔"
"どうはち 銅鉢"
"どうはん 同伴"
"どうば 同馬"
"どうばち 銅鉢"
"どうばり 胴張り 胴張"
"どうばん 銅盤 銅版 銅板"
"どうひ 胴皮 同妃 同飛"
"どうひつ 同筆"
"どうひょう 同表 道標"
"どうびょう 同病"
"どうびょうし 銅拍子"
"どうふ 同歩 豆腐"
"どうふう 同風 同封"
"どうふく 道服 同腹"
"どうふけんみんぜい 道府県民税"
"どうぶ 童舞 胴部"
"どうぶく 胴服 道服"
"どうぶち 胴縁"
"どうぶつ 動物"
"どうぶるい 胴震い"
"どうぶん 同文"
"どうべんきこう 動弁機構"
"どうほう 同袍 同朋 同報 同法 同胞"
"どうほく 道北"
"どうほこ 銅鉾 銅矛"
"どうぼ 同母"
"どうぼう 同房 同朋"
"どうま 胴間"
"どうまき 胴巻"
"どうまる 胴丸"
"どうまわり 胴回り"
"どうまん 道満"
"どうみゃく 動脈"
"どうみゃくけつ 動脈血"
"どうみょう 同苗"
"どうみょうじ 道明寺"
"どうみょうじこ 道明寺粉"
"どうみょうじほしい 道明寺糒"
"どうみん 道民"
"どうめい 同名 同盟"
"どうめいひこう 同盟罷工"
"どうめだりすと 銅メダリスト"
"どうめだる 銅メダル"
"どうめん 道免 道面"
"どうもう 艟艨 童蒙 獰猛"
"どうもく 瞠目"
"どうもと 堂本 胴元"
"どうもり 堂守"
"どうもん 洞門 同門"
"どうや 銅谷 同夜"
"どうやく 同役"
"どうゆう 同憂 道有 同友"
"どうよう 童幼 童謡 動揺 同様"
"どうよく 胴欲"
"どうら 銅鑼"
"どうらく 道楽"
"どうらくむすめ 道楽娘"
"どうらん 銅藍 胴乱 動乱"
"どうり 道理"
"どうりつ 道立 同率"
"どうりゅう 同流"
"どうりょう 同量 同僚"
"どうりょく 動力"
"どうりん 動輪"
"どうりんけい 動輪径"
"どうるい 同類"
"どうれつ 同列"
"どうれべる 同レベル"
"どうれん 道連"
"どうろ 道路"
"どうろくじん 道陸神"
"どうわ 道話 同和 童話"
"どうわく 同枠"
"どうわくば 同枠馬"
"どおし 同士"
"どおり 通 通り"
"どかい 土塊"
"どかた 土方"
"どかべん どか弁"
"どかゆき どか雪 ドカ雪"
"どかん 土管"
"どがい 度外"
"どがま 土釜"
"どき 度器 時 怒気 土器"
"どきゅう 弩弓 弩級 土休"
"どきょう 読経 度胸"
"どきょうだめし 度胸試し"
"どきん 土禁"
"どぎも 度肝"
"どく 讀 髑 獨 徳 得 読 独 毒"
"どくあたり 毒中り"
"どくいり 毒入"
"どくえい 独泳 独英"
"どくえき 毒液"
"どくえさ 毒餌"
"どくえん 独演"
"どくおう 独往"
"どくかい 読解"
"どくが 毒蛾 毒牙"
"どくがい 毒害"
"どくがく 独学"
"どくがす 毒ガス"
"どくがろん 独我論"
"どくがん 独眼"
"どくがんりゅう 独眼竜"
"どくきのこ 毒キノコ 毒茸"
"どくきんほう 独禁法"
"どくぎょ 毒魚"
"どくぎん 独吟"
"どくぐも 毒蜘蛛"
"どくぐん 独軍"
"どくけ 毒気"
"どくげん 独言"
"どくご 独語 読後"
"どくさい 独裁"
"どくさつ 毒殺"
"どくざ 独座"
"どくざいろん 独在論"
"どくし 毒死"
"どくしゃ 読者"
"どくしゅ 毒酒 毒手"
"どくしゅう 独修 独習"
"どくしょ 読書"
"どくしょう 読誦 独唱"
"どくしょさんとう 読書三到"
"どくしょしょうゆう 読書尚友"
"どくしん 読唇 独身"
"どくしんおとこ 独身男"
"どくしんじゅつ 読心術"
"どくしんりょう 独身寮"
"どくじ 独自"
"どくじゃ 毒蛇"
"どくじゅ 読誦"
"どくじん 毒刃"
"どくすい 毒水"
"どくず 読図"
"どくせい 毒性"
"どくせき 毒螫"
"どくせん 独擅 毒腺 独占"
"どくぜつ 毒舌"
"どくぜん 独善"
"どくそ 毒素"
"どくそう 毒草 独創 独奏 独走"
"どくそん 獨尊 独存 独尊"
"どくたけ 毒茸"
"どくだけ 毒茸"
"どくだみか ドクダミ科"
"どくだん 独断"
"どくだんじょう 独壇場"
"どくち 毒血"
"どくとく 独得 独特"
"どくは 読破"
"どくはい 毒杯"
"どくはく 独白"
"どくばり 毒針"
"どくひつ 毒筆"
"どくふ 毒婦 読譜"
"どくふつ 独仏"
"どくぶつ 毒物"
"どくぶん 独文"
"どくへび 毒蛇"
"どくほん 読本"
"どくぼう 独房"
"どくみ 毒見"
"どくみょう 独明"
"どくむぎ 毒麦"
"どくむし 毒虫"
"どくや 毒矢"
"どくやく 独訳 毒薬"
"どくらく 独楽"
"どくりつ 独立"
"どくりつじゅ 独立樹"
"どくりょう 読了"
"どくりょく 独力"
"どくろ 髑髏"
"どくわ 独話 読話 独和"
"どぐう 土偶"
"どけい 時計"
"どけん 土建"
"どげざ 土下座"
"どこ 何所 床 何処"
"どこう 土侯 土光 土工"
"どこか 何処か"
"どこでも 何処でも"
"どことなく 何処と無く"
"どこふくかぜ どこ吹く風 何処吹く風"
"どこまでも 何処迄も"
"どこら 何処ら"
"どこらへん どこら辺"
"どころ 処 所"
"どこんじょう ど根性"
"どご 土語"
"どごう 土豪 怒号"
"どごうれっしん 土豪劣紳"
"どさくさまぎれ どさくさ紛れ"
"どさけん ドサ健"
"どさまわり どさ回り ドサ回り"
"どさん 土讃"
"どさんこ 道産子"
"どざえもん 土左衛門"
"どし 年"
"どしー ℃"
"どしつ 怒叱 土質"
"どしゃ 土砂"
"どしゃぶり どしゃ降り 土砂降り"
"どしゅう 土州"
"どしょう 土性"
"どしょうぼね 土性骨"
"どしょうまち 道修町"
"どしろうと ど素人 ド素人"
"どじょう 土壤 鯲 鰍 鰌 泥鰌 土壌"
"どじょうすくい 泥鰌掬い"
"どじょうなべ 泥鰌鍋"
"どじん 土人"
"どすう 度数"
"どすごえ どす声"
"どすてば 土捨場"
"どせい 土製 怒声 土星"
"どせき 土石"
"どそう 土倉 土葬"
"どそく 土足"
"どぞう 土蔵"
"どぞく 土俗"
"どたぐつ どた靴"
"どたばたきげき どたばた喜劇"
"どたばたげき ドタバタ劇"
"どたんば 土壇場"
"どだい 土代 土台"
"どだん 土壇"
"どち 何方"
"どちゃく 土着"
"どちゅう 土中"
"どちょう 度牒 怒張"
"どちら 何方"
"どっか 読過"
"どっかい 読会 読解"
"どっかく 独覚"
"どっき 毒気"
"どっきょ 独居"
"どっきょう 読経"
"どっきょうだいがく 独協大学"
"どっきんほう 独禁法"
"どっけ 毒気"
"どっけつしょう 毒血症"
"どっこ 独鈷"
"どっこう 独行"
"どっこうせん 独航船"
"どっち 何方"
"どっちみち 何方道"
"どっと ドッと"
"どっとたんい ドット単位"
"どっぷらーこうか ドップラー効果"
"どっぽ 独歩"
"どつ 肭"
"どて 土堤 塢 土手"
"どてっぱら 土手っ腹"
"どてなべ 土手鍋"
"どてみち 土手道"
"どてら 褞袍"
"どとう 怒濤 怒涛"
"どどいつ 都々逸"
"どどめ 土留め"
"どどめいろ どどめ色"
"どなた 何方"
"どなべ 土鍋"
"どなり 鄰 隣"
"どなりごえ 怒鳴り声"
"どにち 土日"
"どにちげつ 土日月"
"どの 何の 殿"
"どのう 土嚢"
"どのかた どの方"
"どのへん どの辺"
"どのみち 何の道"
"どはつ 怒髪"
"どはで ド派手"
"どば 駑馬 土場"
"どばし 土橋"
"どばと 土鳩"
"どひ 奴婢 土樋 土肥"
"どひょう 土俵"
"どひょういり 土俵入"
"どひょうぎわ 土俵際"
"どびゃくしょう 土百姓"
"どびょうし 銅拍子"
"どびん 土瓶"
"どびんむし 土瓶蒸"
"どふん 土墳"
"どぶ 溝"
"どぶいた ドブ板 溝板"
"どぶがい 蚌"
"どぶがわ ドブ川 溝川"
"どぶさらい 溝浚い"
"どぶねずみ 溝鼠"
"どぶろ 土風炉"
"どぶろく 濁醪 濁酒"
"どへき 土壁"
"どへた ど下手 ド下手"
"どべい 土塀"
"どほうがかい 土崩瓦解"
"どぼく 奴僕 土木"
"どま 土間"
"どまり 止まり"
"どまんじゅう 土饅頭"
"どまんなか ド真中 ど真ん中"
"どみのたおし ドミノ倒し"
"どみのりろん ドミノ理論"
"どみん 土民"
"どめ 度目"
"どめいんめい ドメイン名"
"ども 吃 共"
"どもえ 巴"
"どもり 吃り 土盛り"
"どもん 土門"
"どやがい どや街"
"どよう 土用 土曜"
"どら 錚 鑼 鐃 銅鑼"
"どらいぶかん ドライブ感"
"どらえもん ドラえもん"
"どらごえ どら声"
"どらねこ ドラ猫 どら猫"
"どらびだごぞく ドラビダ語族"
"どらふとかいぎ ドラフト会議"
"どらまか ドラマ化"
"どらむかん ドラム缶"
"どらむしき ドラム式"
"どらむすこ どら息子 ドラ息子"
"どらやき 銅鑼焼"
"どらわん 銅羅湾"
"どり 鶏 鳥 取り"
"どりすしき ドリス式"
"どりすじん ドリス人"
"どりょう 度量"
"どりょうこう 度量衡"
"どりょく 努力"
"どりんくざい ドリンク剤"
"どる ＄"
"どるい 土類 土塁"
"どるいどきょう ドルイド教"
"どるうり ドル売り"
"どるえん ドル円"
"どるがい ドル買い"
"どるさつ ドル札"
"どるそうば ドル相場"
"どるだか ドル高"
"どるだて ドル建て"
"どるばこ ドル箱"
"どるやす ドル安"
"どれ 何れ"
"どれい 土鈴 奴隷"
"どれか 何れか"
"どれすすがた ドレス姿"
"どろ 土呂 泥"
"どろあし 泥足"
"どろうみ 泥海"
"どろえ 泥絵"
"どろえのぐ 泥絵の具"
"どろぐつ 泥靴"
"どろじあい 泥試合 泥仕合"
"どろじょう 泥状"
"どろた 泥田"
"どろつち 泥土"
"どろてき 泥的"
"どろどろ 泥々"
"どろなわ 泥縄"
"どろぬま 泥沼"
"どろはね 泥跳ね"
"どろぱっく 泥パック"
"どろぶね 泥船 泥舟"
"どろぼう 泥棒"
"どろぼうねこ 泥棒猫"
"どろまみれ 泥塗れ"
"どろみず 泥水"
"どろみち 泥路 泥道"
"どろよけ 泥除け"
"どろんこ 泥んこ"
"どわすれ ど忘れ"
"どん 緞 嫩 貪 呑 曇 鈍 丼"
"どんか 鈍化"
"どんかく 鈍角"
"どんかん 鈍感"
"どんき 鈍器"
"どんぐり 團栗 団栗"
"どんぐりまなこ 団栗眼"
"どんこう 鈍行"
"どんこん 鈍根"
"どんさい 鈍才"
"どんしゅう 呑舟"
"どんしょく 曇色 貪食"
"どんじゅう 鈍重"
"どんじり どん尻"
"どんす 緞子"
"どんそく 鈍足"
"どんぞこ どん底"
"どんちゃんさわぎ どんちゃん騒ぎ"
"どんちょう 緞帳"
"どんつう 鈍痛"
"どんづまり どん詰り どん詰まり"
"どんてん 曇天"
"どんでんがえし どんでん返し"
"どんと 呑吐"
"どんとう 鈍刀"
"どんとほうしき ドント方式"
"どんびゃくしょう どん百姓"
"どんぶつ 鈍物"
"どんぶり 丼"
"どんぶりかんじょう 丼勘定"
"どんぶりばち 丼鉢"
"どんぶりめし 丼飯"
"どんぶりもの 丼物"
"どんま 鈍磨 鈍麻"
"どんもの 丼物"
"どんよく 貪欲"
"どんよくさ 貪欲さ"
"どんらん 曇鸞 貪婪"
"どんりょく 嫩緑"
"どんるい 丼類"
"な 魚 納 南 無 拿 茄 儺 娜 那 奈 菜 名"
"なーすふく ナース服"
"なあて 名宛"
"ない 地震 乃 無 内"
"ないあつ 内圧"
"ないい 内意"
"ないいん 内印 内院 内因"
"ないえ 奈井江"
"ないえつ 内謁 内閲"
"ないえん 内宴 内苑 内炎 内縁"
"ないおう 内応 内奥"
"ないか 内火 内化 内科"
"ないかい 内海 内回 内界"
"ないかく 内格 内郭 内角 内閣"
"ないかん 内官 内患 内観"
"ないがい 内外"
"ないがしろ 蔑ろ"
"ないがん 内含"
"ないき 内記 内規"
"ないきじゅんかん 内気循環"
"ないきょう 内教"
"ないきょく 内局"
"ないきん 内勤"
"ないぎ 内儀"
"ないくう 内宮 内腔"
"ないくん 内訓"
"ないぐう 内宮"
"ないけい 内径"
"ないけん 内見"
"ないこう 内項 内訌 内攻 内向"
"ないこく 内国"
"ないこくさんば 内国産馬"
"ないこん 内婚"
"ないご 内語"
"ないごう 内合"
"ないごうがいじゅう 内剛外柔"
"ないさい 内済 内妻"
"ないざい 内在"
"ないし 〜 内侍 乃至"
"ないしき 内式"
"ないしきょう 内視鏡"
"ないしつ 内室"
"ないしのかみ 尚侍"
"ないしのつかさ 内侍司"
"ないしゃく 内戚 内借"
"ないしゅう 内周"
"ないしょ 内書 内緒"
"ないしょう 内省 内鞘 内障 内証 内相"
"ないしょうしき 内照式"
"ないしょく 内職"
"ないしん 内申 内診 内心"
"ないしんおう 内親王"
"ないじ 内事 内耳 内示"
"ないじつ 内実"
"ないじゅ 内需"
"ないじゅうがいごう 内柔外剛"
"ないじゅどころ 内豎所"
"ないじょ 内助"
"ないじょう 内情"
"ないじょのこう 内助の功"
"ないじん 内陣"
"ないすん 内寸"
"ないせい 内声 内生 内製 内省 内政"
"ないせき 内戚 内積"
"ないせつ 内接"
"ないせん 内戦 内線"
"ないぜん 内膳"
"ないそう 内争 内奏 内層 内挿 内装"
"ないそく 内則 内足 内側"
"ないぞう 内臓 内蔵"
"ないぞく 内属"
"ないたい 内体 内帯"
"ないたつ 内達"
"ないだい 内題"
"ないだく 内諾"
"ないだん 内談"
"ないち 内治 内地"
"ないつう 内通"
"ないてい 内庭 内偵 内定"
"ないていひ 内廷費"
"ないてき 内的"
"ないてん 内典 内点 内転"
"ないとう 内藤"
"ないど 内帑"
"ないどう 内道"
"ないない 無い無い 内々"
"ないないてい 内々定"
"ないにゅう 内乳"
"ないねん 内捻 内燃"
"ないはおん 内破音"
"ないはつ 内発"
"ないひ 内秘 内皮"
"ないふ 内府"
"ないふく 内福 内服"
"ないふん 内紛"
"ないぶ 内部"
"ないぶこーど 内部コード"
"ないぶひずみ 内部歪"
"ないぶもーど 内部モード"
"ないぶもでる 内部モデル"
"ないぶん 内聞 内文 内分"
"ないへいせい 内閉性"
"ないへき 内壁"
"ないへん 内篇 内編"
"ないほう 内報 内方 内法 内包"
"ないまく 内膜 内幕"
"ないまぜ 綯い交ぜ"
"ないみつ 内密"
"ないむ 内務"
"ないめい 内命"
"ないめん 内面"
"ないもう 内毛"
"ないもの 無い物"
"ないものねだり 無い物ねだり"
"ないや 内野"
"ないやく 内約"
"ないゆう 内憂"
"ないよう 内洋 内用 内容"
"ないらん 内乱 内覧"
"ないりく 内陸"
"ないりょく 内力"
"ないりん 内輪"
"ないりんざん 内輪山"
"ないれ 名入れ"
"ないろんげん ナイロン弦"
"ないわん 内湾"
"なうて 名うて"
"なうまんぞう ナウマン象"
"なえ 地震 奈江 苗"
"なえいろ 苗色"
"なえうり 苗売り"
"なえぎ 苗木"
"なえこ 苗子"
"なえしろ 苗代"
"なえどこ 苗床"
"なえなえ 萎え萎え"
"なえば 苗場"
"なえばたけ 苗畑"
"なえぼ 苗穂"
"なえま 苗間"
"なえむら 苗村"
"なお 菜穂 奈緒 奈央 直 尚 猶"
"なおあき 尚明 直明"
"なおい 直井"
"なおいち 直一"
"なおいり 直入"
"なおえ 尚江 直江"
"なおえつ 直江津"
"なおかず 直和 直一"
"なおかつ 直勝 猶且"
"なおかわ 直川"
"なおき 直喜 尚紀 直毅 直木 直紀 直樹"
"なおきち 直吉"
"なおこ 菜生子 菜桜子 奈央子 奈保子 奈緒子 尚子 直子"
"なおさら 尚更"
"なおざり 等閑"
"なおし 尚士 直史 尚史 直志 直 直し"
"なおしま 直島"
"なおじ 直治"
"なおずみ 尚純 直純"
"なおた 直田"
"なおたか 直孝"
"なおたけ 尚武"
"なおと 尚人 直人"
"なおとし 尚稔 直利 直敏"
"なおなおがき 尚尚書 尚々書"
"なおのぶ 直宣"
"なおのり 尚紀 尚憲 直徳"
"なおはら 猶原"
"なおはる 直治"
"なおひこ 尚彦 直彦"
"なおひさ 尚久 直久"
"なおひで 直秀"
"なおひと 直仁 直人"
"なおひろ 直廣 直広 直大 尚弘 尚宏 直弘 直宏"
"なおふみ 尚文 直史"
"なおまさ 直昌"
"なおみ 名保美 奈保美 奈穂美 直実 尚美 なお美 奈緒美 直美"
"なおみち 直道"
"なおや 名親 直弥 尚哉 尚也 直也"
"なおゆき 尚幸 直幸 尚之 直行 直之"
"なおよし 尚良し 直良 直義"
"なおれ 名折れ"
"なか 仲 那珂 中"
"なかあし 中足"
"なかあだち 中阿達"
"なかい 中井 仲居 仲井 中居"
"なかいけ 仲池"
"なかいた 中板"
"なかいち 中市"
"なかいま 仲井真"
"なかいり 中入"
"なかいわ 中岩"
"なかう なか卯"
"なかうち 中内"
"なかうま 中馬"
"なかうみ 中海"
"なかえ 中江"
"なかお 中尾"
"なかおか 中岡"
"なかおかちまち 仲御徒町"
"なかおく 中奥"
"なかおもて 中表"
"なかおれぼうし 中折帽子"
"なかかんすけ 中勘助"
"なかがい 仲買"
"なかがいうち 中谷内"
"なかがき 中垣"
"なかがた 中潟"
"なかがみ 中上"
"なかがわ 仲川 那賀川 中川"
"なかき 中木"
"なかきた 中来田 中北"
"なかぎし 中岸"
"なかぎょう 中京"
"なかぎり 中限 中桐"
"なかく 中区"
"なかくぎ 中釘"
"なかくら 仲倉 中倉"
"なかくろ ・"
"なかぐすく 中城"
"なかぐち 中口"
"なかぐろ ・ 中黒"
"なかけちょう 名掛丁"
"なかこ 仲子"
"なかこうじ 仲小路"
"なかこま 中巨摩"
"なかご 中心 中子"
"なかごう 中郷"
"なかごし 中越"
"なかごみ 中込"
"なかごめ 中込"
"なかごろ 中ごろ 中頃"
"なかさき 中崎"
"なかさく 中作"
"なかさつない 中札内"
"なかさと 中里"
"なかざ 中座"
"なかざき 仲崎 中崎"
"なかざと 仲里 中里"
"なかざわ 仲沢 中沢 中澤"
"なかし 仲仕"
"なかした 中下"
"なかしま 中嶋 中島"
"なかしょう 中庄"
"なかしょく 中食"
"なかじき 中敷き 中敷"
"なかじきり 中仕切り"
"なかじた 中舌"
"なかじま 中陦 仲島 中嶋 中島"
"なかじまあつし 中島敦"
"なかじめ 中締め"
"なかじゅく 中宿"
"なかじょう 中條 中条"
"なかす 中須 中洲 中州"
"なかすぎ 中杉"
"なかすじ 中筋"
"なかすみ 中済"
"なかず 中洲 中頭"
"なかずとばず 鳴かず飛ばず"
"なかずみ 中澄"
"なかせ 中瀬"
"なかせん 中仙"
"なかせんどう 中山道"
"なかそ 中曽"
"なかそね 仲宗根"
"なかぞこ 中底"
"なかぞの 中薗 中園"
"なかぞら 中空"
"なかた 仲田 中田"
"なかたがい 仲たがい 仲違い"
"なかたど 仲多度"
"なかたに 仲谷 中谷"
"なかだ 仲田 中田"
"なかだいら 中平"
"なかだか 中高"
"なかだち 中立 仲立ち 仲立 媒"
"なかだて 中舘"
"なかだな 中棚"
"なかだるみ 中だるみ 中弛み"
"なかち 仲地 中地"
"なかちょう 中長 仲町"
"なかぢ 中地"
"なかつ 中津"
"なかつえ 中枝 中津江"
"なかつか 中塚"
"なかつかさ 中務"
"なかつぎ 中継ぎ"
"なかつくに 中つ国"
"なかて 中稲 中手"
"なかてん ・ 中点"
"なかで 中手 中出"
"なかでも 中でも"
"なかとう 中藤"
"なかとき 中時"
"なかとびら 中扉"
"なかとみ 中富"
"なかとんべつ 中頓別"
"なかど 中戸"
"なかなお 仲直"
"なかなおり 仲直り"
"なかなか 難々 仲々 中中 中々"
"なかにし 中西"
"なかにも 中にも"
"なかにわ 中庭"
"なかぬき 中貫き"
"なかね 中値 仲値 中根"
"なかの 仲野 中野"
"なかのきみ 中の君"
"なかのくち 中之口"
"なかのさんぷらざ 中野サンプラザ"
"なかのしま 中野島 中之島"
"なかのしょう 中之庄 中ノ庄"
"なかのじょう 中之条"
"なかのちょう 仲之町"
"なかのぶがくえん 中延学園"
"なかのべ 中延"
"なかのまつりごとのつかさ 中務省"
"なかはし 中橋"
"なかはた 中畑"
"なかはま 中浜"
"なかはら 中原"
"なかば 半ば"
"なかばこ 中箱"
"なかばやし 中林"
"なかばる 中原"
"なかばん 中番"
"なかひがし 中東"
"なかひら 中平"
"なかび 中日"
"なかぶくろ 中袋"
"なかぶた 中蓋"
"なかぶと 中太"
"なかへじ 中辺路"
"なかほど 中ほど 中程"
"なかほり 中堀"
"なかぼね 中骨"
"なかま 仲魔 中間 仲間"
"なかまいり 仲間入"
"なかまうち 仲間内"
"なかまき 中牧"
"なかまく 中幕"
"なかまち 仲町 中町"
"なかまつ 中松"
"なかまる 中束 ・"
"なかまわれ 仲間割れ"
"なかみ 中味 中身"
"なかみせ 仲見世"
"なかみぞ 中溝"
"なかみち 仲道 中道"
"なかみなと 那珂湊"
"なかむら 仲村 中村"
"なかもと 中元 仲本 中本"
"なかもり 中森"
"なかもん 中門"
"なかや 仲谷 中矢 中屋 中谷"
"なかやま 仲山 中山"
"なかやましば 中山芝"
"なかゆび 中指"
"なかよし 仲好し 仲良し"
"なから 半ら"
"なかりゃく 中略"
"なかれ 毋 勿 毋れ 莫れ 勿れ"
"なかわきべつえき 中湧別駅"
"なかわく 中枠"
"なかわた 中綿"
"なかんずく 就中"
"なが 永 長"
"ながあみ 長編み"
"ながあめ 長雨"
"ながい 永射 長居 長井 永井"
"ながいあいだ 長い間"
"ながいき 長生"
"ながいけ 長池"
"ながいし 長石"
"ながいずみ 長泉"
"ながいた 長板"
"ながいも 長薯 長芋"
"ながうた 長歌 長唄"
"ながえ 名替 永江 轅 長柄"
"ながえさんきょう 長江三峡"
"ながお 長緒 長夫 永尾 長尾"
"ながおい 長追い"
"ながおか 永岡 長岡"
"ながおかきょう 長岡京"
"ながき 長岐"
"ながぎし 永岸"
"ながぎぬ 長衣"
"ながくて 長久手"
"ながくら 長倉"
"ながぐつ 長靴"
"ながけちょう 名掛丁"
"ながごと 長言"
"ながさ 長さ"
"ながさか 長坂"
"ながさき 永崎 長崎"
"ながさきでんき 長崎電軌"
"ながさく 永作"
"ながさわ 永沢 長澤 長沢"
"ながざら 長皿"
"ながし 流し"
"ながしずき 流し漉き"
"ながしの 長篠"
"ながしま 永嶋 永島 長嶋 長島"
"ながじゃく 長尺"
"ながす 長洲"
"ながすくじら 長須鯨"
"ながずぼん 長ズボン"
"ながせ 永瀬 長瀬"
"ながそで 長袖"
"ながた 長多 長田 永田"
"ながたな 菜刀"
"ながたに 永谷 長谷"
"ながたび 長旅"
"ながちょうば 長丁場"
"ながっちり 長っ尻"
"ながつ 永津 長津"
"ながつか 長束 長塚"
"ながつかたかし 長塚節"
"ながつき 長月"
"ながつづき 永続き"
"ながつま 長妻"
"ながづくえ 長机"
"ながて 長手"
"ながと 長戸 長門"
"ながとし 長年"
"ながとの 長殿"
"ながとみ 長冨 長富"
"ながとも 永友 長友"
"ながとろ 長瀞"
"ながなが 長々"
"ながぬま 長沼"
"ながねぎ 長ネギ 長葱"
"ながねん 永年 長年"
"ながの 永埜 長能 永野 長野"
"ながはし 長橋"
"ながはた 永幡"
"ながはま 長濱 長浜"
"ながはら 長原 永原"
"ながはる 長治"
"ながばかま 長袴"
"ながばなし 長話"
"ながばり 長針"
"ながひと 長人"
"ながびつ 長櫃"
"ながふさ 長房"
"ながぶせ 長伏"
"ながぶち 長淵 長渕"
"ながぶちつよし 長渕剛"
"ながほ 長保"
"ながまさ 長政"
"ながまち 長町"
"ながまつ 長松 永松"
"ながみ 永見"
"ながみち 長道"
"ながみつ 永光 長光"
"ながみね 長峯 長嶺"
"ながむし 長虫"
"ながむね 長宗"
"ながめ 長雨 霖 長目 長め 眺め"
"ながもち 長もち 長持"
"ながもちうた 長持唄"
"ながもり 永森 長森"
"ながや 長家 長谷 長屋"
"ながやす 永安"
"ながやま 長山 永山"
"ながやみ 長病み"
"ながやり 長槍"
"ながゆ 長湯"
"ながゆき 長幸"
"ながよ 長夜 長与"
"ながよし 長吉 永吉"
"ながら 乍 長柄 長良 乍ら"
"ながらく 長らく"
"ながれ 流れ"
"ながれさぎょう 流作業"
"ながれだま 流れ弾"
"ながれぼし 流れ星"
"ながれや 流れ矢"
"ながれやま 流山"
"ながわ 奈河 奈川 名川"
"ながわずらい 痼"
"なき 鳴 亡き 泣き"
"なきおとし 泣落し"
"なきおんな 泣女 泣き女"
"なきがら 亡き骸 亡骸"
"なきごえ 鳴声 鳴き声"
"なきごと 泣き言"
"なきたま 亡き魂"
"なきっつら 泣きっ面"
"なきつら 泣き面"
"なきどり 鳴き鳥"
"なきね 泣き寝"
"なきべそ 泣きべそ"
"なきぼくろ 泣き黒子"
"なきまね 鳴き真似"
"なきむし 泣き虫"
"なきり 奈切 菜切り"
"なきりすげ 菜切菅"
"なきりぼうちょう 菜切包丁"
"なきりゅう 鳴竜 鳴き竜"
"なぎ 椥 南木 奈義 梛 薙 凪"
"なぎさ 渚"
"なぎそ 南木曾"
"なぎなた 薙刀 長刀"
"なぎなたほこ 長刀鉾"
"なぎなたぼこ 長刀鉾"
"なぎょう な行 ナ行"
"なくなく 泣く泣く"
"なくら 名倉"
"なぐ 薙"
"なぐさ 慰"
"なぐさみもの 慰み者 慰み物"
"なぐさめ 慰め"
"なぐも 南雲"
"なぐら 殴羅 名倉"
"なぐり 殴り 名栗"
"なぐりあい 殴り合い"
"なぐるける 殴る蹴る"
"なげ 無げ 投げ"
"なげあみ 投げ網 投網"
"なげいればな 抛入花"
"なげうり 投売り"
"なげき 歎き 嘆き"
"なげきす 投げキス"
"なげきっす 投げキッス"
"なげきのかべ 嘆きの壁"
"なげくび 投げ首"
"なげこみ 投込み"
"なげこみでら 投げ込み寺"
"なげざお 投げ竿"
"なげし 長押"
"なげづり 投げ釣"
"なげなわ 投げ縄"
"なげぶみ 投文 投げ文"
"なげや 投矢 投げ矢"
"なげやり 投げやり 投槍 投げ槍"
"なこ 名古"
"なこうじ 若王寺"
"なこうど 仲人"
"なこそ 勿来"
"なご 名子 名古 名護"
"なごや 那古屋 名越"
"なごやか 和やか"
"なごやきんこぐん 名古屋金鯱軍"
"なごやこーちん 名古屋コーチン"
"なごやだいいん 名古屋大院"
"なごやにし 名古屋西"
"なごやまつり 名古屋祭"
"なごり 名残り 名残"
"なごん 納言"
"なさけ 情 情け"
"なさぬなか 生さぬ仲"
"なざし 名指し"
"なし 無 無し 梨"
"なしがり なし狩り"
"なしくずし 済し崩し なし崩し"
"なしじ 梨子地"
"なしだ 梨田"
"なしだい 梨大"
"なしのつぶて 梨の礫"
"なしもとのみや 梨本宮"
"なじみ 馴染み 馴染"
"なす 那州 茄 茄子 那須"
"なすか ナス科"
"なすこん 茄子紺"
"なすすべ 為す術"
"なすの 那須野"
"なすのよいち 那須与一"
"なすび 茄 茄子"
"なすもく ナス目"
"なずな 薺"
"なずらえうた 準え歌"
"なせ 奈瀬"
"なぜ 名瀬 何故"
"なぜか 何故か"
"なぜなら ∵ 何故なら"
"なぞ 謎"
"なぞかけ 謎掛け"
"なぞがく 謎学"
"なぞことば 謎言葉"
"なぞとき 謎解き"
"なぞなぞ 謎々"
"なぞなぞものがたり 謎謎物語"
"なぞわざ 謎技"
"なた 釶 屶 鉈"
"なたしょう 名田庄"
"なたに 名谷"
"なたね 菜種"
"なたねあぶら 菜種油"
"なたまめ 鉈豆"
"なだ 涙 洋 灘"
"なだい 灘井 名題 名代"
"なだきたどおり 灘北通"
"なだく 灘区"
"なだこう 灘校 灘高"
"なだこうとうがっこう 灘高等学校"
"なださき 灘崎"
"なだたる 名だたる 名立たる"
"なだち 名立"
"なだちゅう 灘中"
"なだれ 雪崩"
"なち 那智"
"なっ 納"
"なっきり 菜っ切り"
"なっしゅきんこう ナッシュ均衡"
"なっしょ 納所"
"なっせん 捺染"
"なっちん 納音"
"なっとう 納豆"
"なっとうまき 納豆巻"
"なっとく 納得"
"なっぱ 菜葉 菜っ葉"
"なつ 奈津 捺 夏"
"なつあき 夏秋"
"なついがい 夏以外"
"なついろ 夏色"
"なついん 捺印"
"なつえ 夏江"
"なつお 夏生"
"なつおんな 夏女"
"なつか 長束"
"なつかし 懐かし"
"なつかぜ 夏風邪"
"なつかわ 夏川"
"なつがき 夏牡蛎"
"なつがすみ 夏霞"
"なつがた 夏型"
"なつがっこう 夏学校"
"なつがっしゅく 夏合宿"
"なつがれ 夏枯れ"
"なつき 夏季 無月 奈月 夏木 夏生 夏樹"
"なつぎ 夏着"
"なつぎぬ 夏衣"
"なつぎり 夏霧"
"なつくいな 夏水鶏"
"なつくさ 夏草"
"なつぐも 夏雲"
"なつげ 夏毛"
"なつげしき 夏景色"
"なつこ 那津子 なつ子 夏子 奈津子"
"なつこみ 夏コミ"
"なつごう 夏号"
"なつごろ 夏頃"
"なつごろも 夏衣"
"なつさく 夏作"
"なつじかん 夏時間"
"なつじゅう 夏中"
"なつずいせん 夏水仙"
"なつぜみ 夏蝉"
"なつぜんご 夏前後"
"なつぞら 夏空"
"なつだいこん 夏大根"
"なつどり 夏鳥"
"なつの 夏野"
"なつのじん 夏の陣"
"なつば 夏場"
"なつばおり 夏羽織"
"なつばて 夏バテ 夏ばて"
"なつばん 夏版"
"なつひこ 夏彦"
"なつび 夏日"
"なつふく 夏服"
"なつほんばん 夏本番"
"なつぼうし 夏帽子"
"なつまけ 夏負 夏負け"
"なつまつり 夏祭り 夏祭"
"なつみ 夏巳 夏実 夏美 奈津美 菜摘"
"なつみかん 夏ミカン 夏みかん 夏蜜柑"
"なつむき 夏向き"
"なつむし 夏虫"
"なつめ 棘 夏芽 棗 夏目"
"なつめやし 棗椰子"
"なつめろ 懐メロ"
"なつもの 夏物"
"なつもよう 夏模様"
"なつやさい 夏野菜"
"なつやすみ 夏休 夏休み"
"なつやせ 夏痩せ"
"なつやま 夏山"
"なつよ 夏代"
"なつよう 夏用"
"なづけ 菜漬 名付け"
"なづけおや 名付親 名付け親"
"なでがた なで肩 撫で肩"
"なでぎり 撫で斬り"
"なでしこ 撫子"
"なでしこもく ナデシコ目"
"なでなで 撫で撫で"
"なではら 撫原"
"なでら 斜平"
"なでん 南殿"
"なとり 名取"
"なとりうむえん ナトリウム塩"
"など 抔 等"
"などころ 名所"
"などなど 等々"
"なな ７ 奈奈 奈々 七"
"なない 七位"
"なないろ 七色"
"ななえ 七栄 奈々江 七重"
"ななお 七尾"
"ななか 七華"
"ななかい 七会"
"ななかく 七角"
"ななきた 七北田"
"ななくさ 七草"
"ななくせ 七癖"
"ななくま 七隈"
"ななこ 七子 斜子 魚子 奈々子 七個"
"ななころびやおき 七転び八起き"
"ななさわ 奈々沢"
"ななさん 七三"
"ななし 名無 名無し"
"ななしゅきょうぎ 七種競技"
"ななしょく 七色"
"ななじゅうにんやくせいしょ 七十人訳聖書"
"ななじょう 七条"
"ななせ 七瀬"
"ななそ 七十"
"ななそじ 七十"
"ななたび 七度"
"ななたま 七玉"
"ななだいせん 七大戦"
"ななだる 七滝"
"ななつ 七ツ 七つ"
"ななつか 七塚"
"ななつたき 七ッ滝"
"ななつぼし 七つ星"
"ななつもり 七ッ森"
"ななにん 七人"
"ななねん 七年"
"ななひかり 七光り 七光"
"ななひき 七匹"
"ななふし 竹節虫"
"ななぶ 七部"
"ななほしてんとう 七星瓢虫"
"ななまがり 七曲り"
"ななみ 七生 七海"
"ななめ 斜め"
"ななめこうほう 斜後方"
"ななめぜんぽう 斜前方"
"ななやしろ 七社"
"ななやま 七山"
"ななよ 七夜"
"ななわり 七割"
"なに 何"
"なにいろ 何色"
"なにうりば 何売場"
"なにえき 何駅"
"なにか 何科 何か"
"なにかと 何彼と"
"なにがし 何某 某"
"なにがた 何型"
"なにがなんでも 何が何でも"
"なにけい 何系"
"なにけん 何県"
"なにげ 何気"
"なにご 何語"
"なにごころ 何心"
"なにごと 何言 何事"
"なにさま 何様"
"なにしろ 何しろ"
"なにじん 何人"
"なにせ 何せ"
"なにせん 何線"
"なにせんせい 何先生"
"なにとぞ 何卒"
"なにとも 何とも"
"なになに 何何 何々"
"なにはさておき 何は扨置き 何は扨措き"
"なにばしょ 何場所"
"なにひとつ 何一つ"
"なにびと 何人"
"なにぶん 何分"
"なにほど 何程"
"なにも 何も"
"なにもの 何物 何者"
"なにもよう 何模様"
"なにや 何屋"
"なにやつ 何奴"
"なにやら 何やら"
"なにゆえ 何故"
"なによう 何用"
"なにより 何より"
"なにわ 浪花 浪速 難波 灘"
"なにわぶし 浪花節"
"なぬか 七日"
"なぬし 名主"
"なの 七"
"なのか ７日 七日"
"なのこ 菜子"
"なのはな 菜の花"
"なのはなばたけ 菜の花畑"
"なのり 名告り 名乗り"
"なのりゅうし ナノ粒子"
"なは 那覇"
"なはさば 鯆"
"なはり 名張 奈半利"
"なばかり 名ばかり"
"なばな 菜花"
"なばり 名張"
"なぱーむだん ナパーム弾"
"なふだ 名札"
"なぶら ∇"
"なぶりごろし 嬲り殺し"
"なぶりもの 嬲り者"
"なへん ナ変 那辺 奈辺"
"なべ 邊 邉 辺 鍋"
"なべかい 鍋会"
"なべかま 鍋釜"
"なべき 鍋気"
"なべしき 鍋敷き"
"なべしま 鍋島"
"なべぞこ 鍋底"
"なべた 鍋田"
"なべたに 鍋谷"
"なべつかみ 鍋掴み"
"なべづる 鍋鉉 鍋鶴"
"なべて 並べて"
"なべの 鍋野"
"なべはだ 鍋肌"
"なべはり 鍋貼"
"なべぶぎょう 鍋奉行"
"なべぶた 鍋蓋"
"なべもの 鍋もの 鍋物"
"なべやき 鍋焼き 鍋焼"
"なべりょうり 鍋料理"
"なほ 菜穂 猶 尚"
"なほこ 奈穂子 菜穂子"
"なほざり 等閑"
"なほし 直衣"
"なほみ 奈保美"
"なほもって 尚以て"
"なぽれおんほうてん ナポレオン法典"
"なま 生"
"なまあし 生脚 生足"
"なまあん 生あん 生餡"
"なまうお 生魚"
"なまえ 名前"
"なまえいり 名前入"
"なまえつきぱいぷ 名前付きパイプ"
"なまおと 生音"
"なまおん 生音"
"なまかじり 生齧り"
"なまかべ 生壁"
"なまかわ 生皮"
"なまがき 生蛎 生牡蛎 生牡蠣"
"なまがわ 生皮"
"なまがわき 生乾き"
"なまき 生木"
"なまきず 生疵 生傷"
"なまくび 生首"
"なまくら 鈍ら 鈍"
"なまくりーむ 生クリーム"
"なまぐさ 腥 生臭"
"なまけぐせ 怠け癖"
"なまけごころ 怠け心"
"なまけもの 怠け者"
"なまこ 海鼠"
"なまこかべ 海鼠壁"
"なまこん 生コン"
"なまこんくりーと 生コンクリート"
"なまごみ 生ゴミ 生塵"
"なまごみしょりき 生ごみ処理機"
"なまごめ 生米"
"なまごろし 生殺し"
"なまざかな 生肴 生魚"
"なましょく 生食"
"なまじ 憖"
"なまじっか 憖っか"
"なまじゃけ 生鮭"
"なまじゃしん 生写真"
"なます 韲 鱠 膾"
"なまず 鮠 癜 鯰"
"なまたまご 生卵"
"なまため 生田目 生天目"
"なまだら 生ダラ 生鱈"
"なまち 生血"
"なまちち 生乳"
"なまちゃ 生茶"
"なまつば 生唾"
"なまづめ 生詰 生爪"
"なまでーた 生データ"
"なまなま 生々 生生"
"なまにく 生肉"
"なまはげ 生剥"
"なまはだ 生肌"
"なまはんか 生半可"
"なまはんじゃく 生半尺"
"なまばな 生花"
"なまびーる 生ビール"
"なまぴ 生ピ"
"なまふ 生麩"
"なまぶし 生節"
"なままめ 生豆"
"なまみ 生身"
"なまみず 生水"
"なまむぎ 生麦"
"なまめん 生麺"
"なまもの 生物"
"なまり 訛り 訛 鉛"
"なまりいた 鉛板"
"なまりいり 鉛入"
"なまりいろ 鉛色"
"なまりかごうぶつ 鉛化合物"
"なまりだん 鉛弾"
"なまりちくでんち 鉛蓄電池"
"なまりばん 鉛版"
"なまりぶくろ 鉛袋"
"なまりぶし 生節 生り節"
"なまろく 生録"
"なみ 〜 竝 奈巳 名美 奈未 奈美 浪 並 波"
"なみあい 浪合"
"なみあし 並足"
"なみいか 並以下"
"なみいた 波板"
"なみうち 波打"
"なみうちぎわ 波打際 波打ち際"
"なみえ 浪江"
"なみお 波雄"
"なみおか 浪岡"
"なみおと 波音"
"なみかぜ 波風"
"なみかた 波方"
"なみかっこ 波括弧"
"なみかわ 浪川 並河"
"なみがい 浪貝"
"なみがけ 並罫"
"なみがしら 波頭"
"なみがた 波形"
"なみき 行木 並木"
"なみきみち 並木道"
"なみけい 波罫"
"なみこし 浪越"
"なみしょう 浪商"
"なみじ 波路"
"なみじょう 波状"
"なみせい 並製"
"なみせん 〜 波線"
"なみたいてい 並大抵"
"なみだ 涕 泪 涙"
"なみだあめ 涙雨"
"なみだがお 涙顔"
"なみだがた 涙型"
"なみだがわ 涙川"
"なみだきん 涙金"
"なみだごえ 涙声"
"なみだながら 涙ながら"
"なみだばし 涙箸"
"なみだめ 涙目"
"なみだもの 涙モノ 涙もの"
"なみとう 並等"
"なみなみ 並々"
"なみの 波野"
"なみのはな 波の花"
"なみのり 波乗 波乗り"
"なみはずれ 並外れ"
"なみはば 並幅"
"なみひととおり 並一通り"
"なみへい 波平"
"なみま 波間"
"なみまく 波幕"
"なみまくら 波枕"
"なみまつ 並松"
"なみもり 並盛"
"なみよけ 波除け"
"なむ 南無"
"なむさん 南無三"
"なむみょうほうれんげきょう 南無妙法蓮華経"
"なむら 魚群"
"なめ 嘗 滑"
"なめいし 大理石"
"なめかた 行方"
"なめかわ 滑川"
"なめがた 行方"
"なめくじ 蛞蝓"
"なめくじうお 蛞蝓魚"
"なめこ 滑子"
"なめし 菜飯"
"なめしがわ 鞣革"
"なめたけ 滑茸"
"なめらか 滑らか"
"なめりかわ 滑川"
"なや 魚屋 納谷 納屋"
"なやみ 悩み"
"なやみおおき 悩み多き"
"なやらい 追儺"
"なゆ 那由"
"なゆた 奈由太 那由他 那由多"
"なよせ 名寄せ"
"なよせちょう 名寄帳"
"なよたけ 弱竹"
"なよろ 名寄"
"なら 平城 枹 柞 楢 奈良"
"ならい 奈良井"
"ならいごと 習い事"
"ならいしょう 習い性"
"ならお 奈良尾"
"ならおか 奈良岡"
"ならかわ 楢川"
"ならき 奈良木"
"ならく 奈落"
"ならさき 楢崎"
"ならざき 楢崎"
"ならし 慣らし 馴らし"
"ならしの 習志野"
"ならず 不成"
"ならずもの ならず者"
"ならづけ 奈良漬"
"ならでん 奈良電"
"ならは 楢葉"
"ならはら 奈良原"
"ならば ⇒ ⊃ →"
"ならび 並び"
"ならびかえ 並び換え"
"ならびに 並びに"
"ならへいあんじだい 奈良・平安時代"
"ならべ 並べ"
"ならやまぶしこう 楢山節考"
"ならわし 慣わし 習わし"
"なり 哉 斉 就 成 形 也 鳴り"
"なりあい 成合"
"なりあいじ 成相寺"
"なりあがり 成り上がり"
"なりあき 成昭"
"なりあきら 斉彬"
"なりお 成雄"
"なりかたち 形姿"
"なりかつよう ナリ活用"
"なりかわ 成川"
"なりきん 成金"
"なりぎん 成銀"
"なりこ 成子"
"なりこま 成駒"
"なりさと 成里"
"なりさわ 成澤 成沢"
"なりしげ 成茂"
"なりしま 成嶋"
"なりた 成田"
"なりたち 成立ち 成り立ち"
"なりたにし 成田西"
"なりち 成知"
"なりて 為り手 成り手"
"なりと 成人"
"なりとみ 成富"
"なりとも 成伴 成知"
"なりはら 成原"
"なりひさご 生り瓢"
"なりひと 成人"
"なりひら 業平"
"なりひろ 成洋"
"なりふり 形振り"
"なります 成増"
"なりまつ 成松"
"なりみ 也美 也実"
"なりみつ 成允"
"なりもと 成本"
"なりもの 済り物 生り物 鳴物"
"なりやす 成康"
"なりゆき 成り行き 成行き 成行"
"なりよし 成良"
"なりわ 成羽"
"なりわい 業 生業"
"なる 奈留 鳴 徳 成"
"なるあき 成章"
"なるお 成雄 鳴尾"
"なるかみ 鳴神"
"なるき 成紀"
"なるきよ 成清"
"なるけ 成毛"
"なるげ 成毛"
"なるこ 鳴子"
"なるご 鳴子"
"なるさわ 鳴澤 成澤 成沢 鳴沢"
"なるしま 成嶋 成島"
"なるせ 鳴瀬 成瀬"
"なるたき 鳴滝"
"なるち 成知"
"なると 鳴戸 鳴門"
"なるとう 成東"
"なるとだい 鳴門鯛"
"なるとまき 鳴門巻"
"なるひこ 徳彦"
"なるひさ 徳寿"
"なるひろ 成広"
"なるべく 可成 成る可く"
"なるほど 成る程 成程"
"なるみ 成己 成美 鳴海"
"なるみつ 成光"
"なるよし 成良"
"なれ 馴 熟れ 慣れ"
"なれあい 馴合 馴れ合い"
"なれずし 馴鮨 熟鮨"
"なれそめ 馴れ初め 馴初め"
"なれっこ 馴れっこ 慣れっこ"
"なれのはて 成れの果 成れの果て"
"なわ 繩 苗 名和 縄"
"なわあみ 縄編み"
"なわおか 縄岡"
"なわおび 縄帯"
"なわしろ 苗代"
"なわしろだ 苗代田"
"なわじり 縄尻"
"なわた 縄田"
"なわて 縄手 畷"
"なわとび 縄飛び 縄跳び"
"なわない 縄綯い"
"なわのり 縄海苔"
"なわのれん 縄暖簾"
"なわばしご 縄梯子"
"なわばり 縄張 縄張り"
"なわめ 縄目"
"なわもじ 縄文字"
"なをれ 名折れ"
"なん 納 娚 喃 楠 男 軟 南 難 何"
"なんあ 南ア"
"なんい 何位 難易 南緯"
"なんえつ 南越"
"なんえん 何円"
"なんおう 南欧"
"なんおく 何億"
"なんおん 軟音"
"なんか 何か 南柯 南瓜 軟化 南下"
"なんかい 何階 難解 南海 何回"
"なんかいりゅう 南海龍"
"なんかしょ 何ヵ所"
"なんかん 南漢 何巻 南関 難関"
"なんが 軟臥"
"なんがい 南外"
"なんがく 南学"
"なんがつ 何月"
"なんがん 南岸"
"なんき 何機 南紀"
"なんきつ 難詰"
"なんきゅう 軟球"
"なんきょう 難境"
"なんきょく 何局 何曲 難曲 難局 南極"
"なんきょくせい 南極星"
"なんきん 軟禁 南京"
"なんきんねずみ 南京鼠"
"なんきんぶくろ 南京袋"
"なんきんまめ 南京豆"
"なんきんむし 南京虫"
"なんぎ 難義 難儀"
"なんぎょう 何行 難業 難行"
"なんく 何区"
"なんくせ 何癖 難癖"
"なんくち 何口"
"なんくみ 何組"
"なんくん 難訓"
"なんぐあず 南瓜子"
"なんぐう 南宮"
"なんぐん 南軍"
"なんけ 南家"
"なんけた 何桁"
"なんけん 難件 軟件 何軒 何件"
"なんげん 南限 何軒"
"なんこ 何個"
"なんこう 軟攻 南郊 楠公 軟鋼 南光 南港 南高 軟膏 難航"
"なんこうがい 軟口蓋"
"なんこうどう 南江堂"
"なんこうふらく 難攻不落"
"なんこく 南国"
"なんこつ 軟骨"
"なんこつぎょ 軟骨魚"
"なんご 南後 難語 喃語"
"なんごう 何号 南郷"
"なんごく 南国"
"なんさい 何才 何歳"
"なんさく 何作"
"なんさつ 何冊"
"なんざ 軟座"
"なんざん 難産 南山"
"なんし 難思 南史 南支 男子"
"なんしき 軟式"
"なんしつ 軟質"
"なんしつまい 軟質米"
"なんしゅ 何種"
"なんしゅう 南宗 南州 何週 何周"
"なんしょ 難所"
"なんしょう 難症 何勝 南昌"
"なんしょうなんぱい 何勝何敗"
"なんしょく 男色 何色 難色"
"なんしん 南進"
"なんじ 尓 難字 何次 難事 難治 爾 何時 汝"
"なんじきょく 南磁極"
"なんじっかい 何十回"
"なんじっけん 何十件"
"なんじってん 何十点"
"なんじゃく 軟弱"
"なんじゅう 何十 何重 難渋"
"なんじゅっかい 何十回"
"なんじゅっけん 何十軒 何十件"
"なんじゅっしゅるい 何十種類"
"なんじゅってん 何十点"
"なんじゅっぽん 何十本"
"なんじょう 何乗 南常 何条 南城 南條 南条"
"なんじら 汝等"
"なんすい 軟水"
"なんせ 何せ"
"なんせい 南征 何世 軟性 南勢 南西"
"なんせいしょ 南斉書"
"なんせいたん 南西端"
"なんせき 何隻"
"なんせん 難船 南線"
"なんせんほくば 南船北馬"
"なんせんめ 何戦目"
"なんぜん 何千"
"なんぜんじ 南禅寺"
"なんそう 何走 何層 南窓 南倉 南宋 南総"
"なんそく 何足"
"なんそしき 軟組織"
"なんぞ 何ぞ"
"なんたい 何体 男体 軟体"
"なんたる 何たる"
"なんたん 南端"
"なんだい 何代 何台 難題"
"なんだいもん 南大門"
"なんだか 何だか"
"なんだかんだ 何だかんだ"
"なんだばつ 何打罰"
"なんだん 何段 南淡"
"なんち 難治"
"なんちゃく 何着"
"なんちゃくりく 軟着陸"
"なんちゅう 南中"
"なんちょう 何丁 南朝 軟調 難聴"
"なんつう 何通"
"なんて 何て"
"なんてい 軟庭 南庭"
"なんてき 何滴 難敵"
"なんてつ 軟鉄"
"なんてん 何店 何点 南天 難点"
"なんてんか ナンテン科"
"なんでい 軟泥"
"なんでも 何でも"
"なんでもかんでも 何でも彼んでも 何でもかんでも"
"なんでん 南伝 南殿"
"なんと 何と 南斗 南都"
"なんとう 南唐 軟投 何頭 何等 南島 南東"
"なんとか 何とか"
"なんとなく 何となく"
"なんとなれば ∵ 何となれば"
"なんとも 何とも"
"なんど 納戸 難度 何度"
"なんどう 南洞"
"なんどうせん 軟銅線"
"なんどき 何時"
"なんどく 難読"
"なんなく 難なく 難無く"
"なんなんせい 南南西"
"なんなんとう 南南東"
"なんにち 何日"
"なんにょ 男女"
"なんにん 何人"
"なんねい 南寧"
"なんねん 難燃 何年"
"なんねんくらいまえ 何年位前"
"なんの 何の 南野"
"なんのう 南濃"
"なんのその 何のその"
"なんはく 何拍"
"なんはこ 何箱"
"なんば 難場 難波"
"なんばい 何杯 何倍"
"なんばら 南原"
"なんばん 軟盤 何番 南蛮"
"なんばんづけ 南蛮漬"
"なんばんやき 南蛮焼"
"なんぱ 難破 軟派"
"なんぱく 何拍 軟白 何泊"
"なんぱこ 何箱"
"なんぱつ 何発"
"なんひき 何匹"
"なんひょう 何票"
"なんびき 何匹"
"なんびと 何人"
"なんびゃく 何百"
"なんびゃっこ 何百個"
"なんびょう 何秒 難病"
"なんぴと 何人"
"なんぴょう 何票"
"なんぴょうよう 南氷洋"
"なんぴん 難平 何品"
"なんふつ 南仏"
"なんふん 何分"
"なんぶ 何部 軟部 南武 南部"
"なんぶつ 難物"
"なんぶん 難文 何分"
"なんぷう 軟風 南風"
"なんぷくじ 南福寺"
"なんぷん 何分"
"なんべい 南米"
"なんべん 何遍 軟便"
"なんぺい 南平"
"なんぺん 何編"
"なんぼいん 軟母音"
"なんぼく 南北"
"なんぼくちょう 南北朝"
"なんぼん 何本"
"なんぼんばしら 何本柱"
"なんぽ 何歩 南畝"
"なんぽう 南方"
"なんぽうぐんしゅうだん 南方軍集団"
"なんぽく 南北"
"なんぽろ 南幌"
"なんぽん 何本"
"なんまい 何枚"
"なんまん 何万"
"なんみょうほうれんげきょう 南無妙法蓮華経"
"なんみん 難民"
"なんみんきゃんぷ 難民キャンプ"
"なんめい 何名"
"なんめん 何面 南面"
"なんもう 軟毛"
"なんもく 南牧"
"なんもん 何問 難問"
"なんや 南谷"
"なんやく 難役"
"なんよう 何曜 南陽 難溶 南洋"
"なんら 何ら 何等"
"なんらか 何らか"
"なんり 南里"
"なんりゅうせき 南流石"
"なんりょ 南呂"
"なんりょう 何両"
"なんりん 何輪"
"なんれつ 何列"
"なんろ 難路"
"なんろく 南麓"
"なんわ 何話"
"なんわり 何割"
"に 2 ２ 貮 貳 爾 岻 迩 邇 尼 児 仁 丹 弍 弐 煮 似 荷 二"
"にあげ 荷揚げ"
"にあし 荷足"
"にあつかい 荷扱い"
"にあぴんしょう ニアピン賞"
"にありーいこーる ≒"
"にい 新居 兄 二位 新"
"にいい 新居"
"にいかっぷ 新冠"
"にいかわ 新川"
"にいがき 新垣"
"にいがた 新潟"
"にいくら 新倉"
"にいさと 新里"
"にいさま 兄様"
"にいさん 兄さん"
"にいざ 新座"
"にいざか 新坂"
"にいざき 新居崎"
"にいざと 新里"
"にいじま 新島"
"にいだ 新田"
"にいちゃん 兄ちゃん"
"にいつ 新津"
"にいつま 新妻"
"にいつる 新鶴"
"にいづま 新妻"
"にいで 新出"
"にいな 二名"
"にいなめさい 新嘗祭"
"にいぬま 新沼"
"にいはま 新居浜"
"にいはら 新原"
"にいはり 新治"
"にいはる 新治"
"にいばる 新治"
"にいべ 新部"
"にいほ 新穂 仁保"
"にいぼとけ 新仏"
"にいぼん 新盆"
"にいまくら 新枕"
"にいみ 新實 新実 新美 新見"
"にいむら 新村"
"にいるぴと 二色人"
"にいろ 丹色"
"にいんくらぶ 二院クラブ"
"にいんせい 二院制"
"にうけ 荷受け 荷受"
"にうごき 荷動き"
"にうま 荷馬"
"にえ 沸 煮え 錵 贄"
"にえびと 贄人"
"にえゆ 煮湯"
"にお 仁尾 匂 鳰"
"におい 荷負 臭い 匂い 匂"
"においぶくろ 匂袋"
"におう 二王 仁王"
"におうみや 匂宮"
"におくりにん 荷送人"
"におし 二推し"
"におやか 匂やか"
"におろし 荷下ろし 荷卸し"
"にか 二価 二課"
"にかい ２階 ２回 二回 二階"
"にかいだな 二階棚"
"にかく 仁鶴"
"にかこく 二ヵ国"
"にかた 煮方"
"にかどでんち ニカド電池"
"にかほ 仁賀保"
"にかめいが 二化螟蛾"
"にかわ 仁川 膠"
"にかわしつ 膠質"
"にかわせ 荷為替"
"にかん 二冠"
"にが 苦"
"にがうり 苦瓜"
"にがお 似顔"
"にがき 苦木"
"にがさ 苦さ"
"にがたけ 苦竹"
"にがつ 如月 ２月 二月"
"にがつち 苦土"
"にがて 苦手"
"にがびゃくどう 二河白道"
"にがみ 苦み 苦味"
"にがむし 苦虫"
"にがゆ 煮粥"
"にがよもぎ 苦艾"
"にがり 苦汁"
"にがわ 仁川"
"にがわせ 荷為替"
"にがわらい 苦笑い"
"にがん 二眼"
"にがんれふ 二眼レフ"
"にき 二期 日記 二気 二季 二基 二木 仁木"
"にきたつ 熟田津"
"にきび 靤 面皰"
"にきめ 和布"
"にきゅう 二級"
"にきょく 二曲 二極"
"にぎす 似鱚"
"にぎてき 二義的"
"にぎにぎ 賑賑 賑々 握握 握々"
"にぎやか 賑やか"
"にぎょう 二行"
"にぎり 握り"
"にぎりずし 握り鮨"
"にぎりばし 握り箸"
"にぎりめし 握り飯"
"にぎわい 賑わい 賑"
"にく 二区 肉"
"にくあつ 肉厚"
"にくいれ 肉入れ"
"にくいろ 肉色"
"にくか 肉果"
"にくかい 肉塊"
"にくかん 肉感"
"にくが 肉芽"
"にくがかり 肉係"
"にくがん 肉眼"
"にくきゅう 肉球"
"にくきり 肉切り"
"にくぎゅう 肉牛"
"にくけい 肉刑 肉髻 肉桂"
"にくげ 肉芽"
"にくこう 肉交"
"にくこっぷん 肉骨粉"
"にくざんほりん 肉山脯林"
"にくしつ 肉質"
"にくしみ 憎しみ"
"にくしゅ 肉腫"
"にくしょく 肉色 肉食"
"にくしょくぎょ 肉食魚"
"にくしょくじゅう 肉食獣"
"にくしん 肉身 肉親"
"にくじき 肉食"
"にくじゃが 肉じゃが"
"にくじゅう 肉汁"
"にくじょう 肉情"
"にくじる 肉汁"
"にくすい 肉垂 肉穂"
"にくずくか ニクズク科"
"にくずれ 荷崩れ"
"にくせい 肉声"
"にくせいひん 肉製品"
"にくたい 肉体"
"にくだい 肉代"
"にくだま 肉玉"
"にくだん 肉彈 肉弾"
"にくだんご 肉団子"
"にくだんせん 肉彈戰"
"にくっけ 肉っ気"
"にくづき 肉月 肉付き"
"にくづけ 肉付け"
"にくづめ 肉詰め"
"にくてい 憎体"
"にくてき 肉的"
"にくどうふ 肉豆腐"
"にくはく 肉迫 肉薄"
"にくばなれ 肉離れ"
"にくひつ 肉筆"
"にくふん 肉粉"
"にくぶと 肉太"
"にくぶとん 肉蒲団"
"にくへん 肉片"
"にくぼう 肉棒"
"にくぼそ 肉細"
"にくまれぐち 憎まれ口"
"にくまれっこ 憎まれっ子"
"にくまれもの 憎まれ者"
"にくまれやく 憎まれ役"
"にくまん 肉まん 肉饅"
"にくまんじゅう 肉饅頭"
"にくみそ 肉味噌"
"にくや 肉屋"
"にくやさい 肉野菜"
"にくよう 肉用"
"にくようぎゅう 肉用牛"
"にくよく 肉欲"
"にくりょうり 肉料理"
"にくるい 肉類"
"にくろむせん ニクロム線"
"にくん 二君"
"にぐら 荷鞍"
"にぐるま 荷車"
"にぐん 二群 二軍"
"にけん 二研 ２研 二間 二件 二軒"
"にげ 逃げ"
"にげあし 逃げ足"
"にげうま 逃げ馬"
"にげことば 逃言葉"
"にげごし 逃げ腰"
"にげみず 逃げ水"
"にげみち 逃げ道"
"にげん 二元"
"にげんきん 二弦琴"
"にげんしゃ 二玄社"
"にこ 二個 二胡"
"にこう 二高 二項"
"にこく 二国"
"にこげ 和毛"
"にこごり 煮凝 煮凍り"
"にこちんさん ニコチン酸"
"にこにこがお にこにこ顔 ニコニコ顔"
"にこみ 煮込"
"にころがし 煮転がし"
"にこん 耳根"
"にご 二語"
"にごう 二合 二号"
"にごしらえ 荷拵え"
"にごり 濁り"
"にごりえ 濁江"
"にごりみず 濁り水"
"にごん 二言"
"にさ 二叉"
"にさつ 二冊"
"にさん 二、三 二三"
"にさんにち ２、３日"
"にざえもん 仁左衛門"
"にざかな 煮魚"
"にし 爾志 螺 二死 二子 西"
"にしあじあ 西アジア"
"にしあち 西阿知"
"にしあまね 西周"
"にしあわくら 西粟倉"
"にしい 西井"
"にしいえ 西家"
"にしいけ 西池"
"にしいちさんるい 二死一三塁"
"にしいる 西入ル"
"にしうみ 西海"
"にしうら 西裏 西浦"
"にしお 西尾"
"にしおか 西岡"
"にしおぎ 西荻"
"にしかぜ 西風"
"にしかた 西形 西片 西方"
"にしかつら 西桂"
"にしかど 西門 西角"
"にしかわ 西川"
"にしかわきよし 西川きよし"
"にしかん 西館"
"にしがいち 西垣内"
"にしがき 西垣"
"にしがや 西ヶ谷"
"にしがわ 西側"
"にしき 二式 西木 西紀 錦"
"にしきえ 錦絵"
"にしきがおか 錦ヶ丘"
"にしきがわてつどう 錦川鉄道"
"にしきぎ 錦木"
"にしきぎか ニシキギ科"
"にしきぎもく ニシキギ目"
"にしきごい 錦鯉"
"にしきた 西北"
"にしきちょう 錦町"
"にしきで 錦手"
"にしきど 錦戸"
"にしきどう 錦堂"
"にしきね 和稲"
"にしきのみはた 錦の御旗"
"にしきみ 錦見"
"にしきょうく 西京区"
"にしく 西区"
"にしぐち 西口"
"にしこう 西高"
"にしこく 西国"
"にしご 西語"
"にしごう 西郷"
"にしさんそう 西三荘"
"にしざき 西崎"
"にしざわ 西沢 西澤"
"にしした 西下"
"にししば 西柴"
"にししん 西新"
"にしじま 西嶋 西島"
"にしじん 西新 西陣"
"にしすぎ 西杉"
"にしぜき 西関"
"にしぞの 西園"
"にしたてやま 西舘山"
"にしたに 西谷"
"にしだ 西田"
"にしだいら 西平"
"にしだきたろう 西田幾多郎"
"にしだけ 西岳"
"にしだて 西館"
"にしてつ 西鉄"
"にしとう 西棟"
"にしどいつ 西独 西ドイツ"
"にしどみ 西富"
"にしな 西名 仁科"
"にしないるねつ 西ナイル熱"
"にしなが 西永"
"にしなだ 西灘"
"にしなり 西成"
"にしにほんたんだいふ 西日本短大付"
"にしね 西根"
"にしの 西野"
"にしのうち 西の内"
"にしのおもて 西之表"
"にしのきょう 西の京"
"にしのしま 西ノ島"
"にしのその 西之園"
"にしのだいら 西の平"
"にしのはら 西之原"
"にしのみや 西宮"
"にしはし 西橋"
"にしはた 西畑"
"にしはま 西浜"
"にしはら 西原"
"にしはる 西春"
"にしばん 西版"
"にしひら 西平"
"にしび 西陽 西日"
"にしふな 西船"
"にしべ 西部"
"にしほ 西穂"
"にしまき 西牧"
"にしまち 西町"
"にしまつ 西松"
"にしまど 西窓"
"にしみなみ 西南"
"にしみや 西宮"
"にしむら 西村"
"にしめ 煮しめ 煮染め 西目"
"にしめら 西米良"
"にしもと 西本"
"にしもり 西森"
"にしもろかた 西諸県"
"にしゃ 二社 二者"
"にしゃせんいつ 二者選一"
"にしや 西屋"
"にしやま 西山"
"にしゅ 二種"
"にしゅうれんぞく 二週連続"
"にしゅつ 二出"
"にしょう 二章"
"にしょうがくしゃ 二松学舎"
"にしょうめ 二勝目"
"にしょく 二食 二色"
"にしよーろっぱ 西ヨーロッパ"
"にしわき 西脇"
"にしわきじゅんざぶろう 西脇順三郎"
"にしん 二伸 二心 二進 二審 鯡 鰊"
"にしんき 二進木"
"にしんほう ２進法"
"にじ ２次 霓 二字 尼寺 二児 二時 二次 虹"
"にじいろ 虹色"
"にじく 二軸"
"にじこ 虹子"
"にじすいしょう 虹水晶"
"にじせい 二字姓"
"にじっさい 二十歳"
"にじっせいき 二十世紀"
"にじでんせつ 虹伝説"
"にじの 虹野"
"にじます 虹鱒"
"にじゅう 二十 廿 二重"
"にじゅうあご 二重顎"
"にじゅういっし 二十一史"
"にじゅううつし 二重映し"
"にじゅうかぎかっこ 』 『"
"にじゅうかべ 二重壁"
"にじゅうさっし 二重サッシ"
"にじゅうしし 二十四史"
"にじゅうしせっき 二十四節気"
"にじゅうせきぶん ∬"
"にじゅうぞこ 二重底"
"にじゅうはっしゅく 二十八宿"
"にじゅうまど 二重窓"
"にじゅうまる ◎"
"にじゅうもうけんほう 二重盲検法"
"にじゅうやまかっこ 》 《"
"にじゅうやまがっこ 》 《"
"にじゅうよじかんせい 二十四時間制"
"にじゅっさい 二十歳"
"にじゅっせいき 二十世紀"
"にじょ 二女"
"にじょう 二丈 二乗 二条"
"にじょういんのさぬき 二条院讃岐"
"にじょうき 二畳紀"
"にじょうわ ２乗和 二乗和"
"にじりぐち 躙り口"
"にじりん 二次林"
"にじる 煮汁"
"にじるし 荷印"
"にすい 二水"
"にすがた 似姿 荷姿"
"にせ 二世 僞 偐 贋 偽"
"にせい ２声 二星 二世"
"にせえ 似絵"
"にせがね 贋金"
"にせき 二関"
"にせさつ 贋札 偽札"
"にせもの 贋者 贋物 偽者 偽物"
"にせものがたり 仁勢物語"
"にせん 二錢 二線 二千"
"にせんめ 二煎目"
"にそう 二曹 二相 二層 尼僧"
"にそうしき 二槽式"
"にそく 二足"
"にそくさんもん 二束三文"
"にぞめ 煮染め"
"にた 仁多"
"にたい 二体"
"にたき 煮炊き"
"にたく 二択"
"にただ 仁多田"
"にたどり 似鳥"
"にたに 二谷"
"にたまご 煮卵"
"にたみ 仁多見"
"にたもの 似た者"
"にたやま 仁田山"
"にたりよったり 似たり寄ったり"
"にたんちょう ニ短調"
"にだ 荷駄"
"にだい 二大 二台 荷台"
"にだいかいちょう 二代会長"
"にだし 荷出し"
"にだな 荷棚"
"にだん 二段"
"にだんがさね 二段重ね"
"にだんがまえ 二段構え"
"にち 二値 日"
"にちい 日伊"
"にちいき 日域"
"にちいん 日陰"
"にちうん 日暈"
"にちえい 日栄 日影 日英"
"にちおう 日欧"
"にちおん 日音"
"にちか 二千翔"
"にちかん 日間"
"にちが 日我"
"にちがく 日額"
"にちぎん 日銀"
"にちげつ 日月"
"にちげん 日限"
"にちご 日語 日後"
"にちじ 日次 日時"
"にちじゅう 日中"
"にちじょう 日乗 日常"
"にちじん 日神"
"にちずい 日瑞"
"にちだい 日本大学 日大"
"にちだいつるがおか 日大鶴ヶ丘"
"にちだいぶざん 日大豊山"
"にちづけ 日付"
"にちでん 日電"
"にちでんきょう 日電協"
"にちどう 日動"
"にちどく 日独"
"にちどくい 日独伊"
"にちなん 日南"
"にちにち 日々"
"にちにちこれこうじつ 日々是好日"
"にちにちそう 日日草"
"にちのうけん 日能研"
"にちはむ 日本ハム 日ハム"
"にちはら 日原"
"にちはん 日販 日半"
"にちふつ 日仏"
"にちぶ 日舞"
"にちぶん 日文 日分"
"にちべい 日米"
"にちべんれん 日弁連"
"にちぼうしん 日貿信"
"にちぼつ 日没"
"にちまえ 日前"
"にちまんぎていしょ 日満議定書"
"にちめ 日目"
"にちめんじつぎょう 日綿実業"
"にちもつ 日没"
"にちや 日夜"
"にちゅう 二中"
"にちょう 二鳥"
"にちょうけんじゅう 二挺拳銃"
"にちょうちょう ニ長調"
"にちょうなげ 二丁投げ"
"にちょく 二直"
"にちよう 日用 日曜"
"にちようあさ 日曜朝"
"にちようびあさ 日曜日朝"
"にちようよる 日曜夜"
"にちりょう 日糧"
"にちりん 日林 日輪"
"にちれき 日瀝"
"にちれん 日蓮"
"にちろ 日露"
"にちろぎょぎょう 日魯漁業"
"にちろく 日録"
"にちわ 日和"
"にっか 日貨 日華 日課"
"にっかぎれん 日科技連"
"にっかつ 日活"
"にっかどでんち ニッカド電池"
"にっかわ 新川"
"にっかん 肉感 日韓 日刊"
"にっき 肉桂 日揮 日記"
"にっきそう 日機装"
"にっきゅう 日給"
"にっきょう 日共"
"にっきょうさい 日教済"
"にっきょうそ 日教組"
"にっきん 日勤"
"にっくう 日空"
"にっくに 新国"
"にっけい 肉桂 日計 日系 日経"
"にっけんかがく 日研化学"
"にっこう 日工 日航 日興 日光"
"にっこうきょうせき 日鉱共石"
"にっこり 莞爾"
"にっころがし 煮っ転がし"
"にっさん 日参 日産"
"にっし 日誌"
"にっしゃ 日射"
"にっしゅう 日州 入集 日収 日周"
"にっしゅつ 日出"
"にっしょう 入声 日章 日商 日照"
"にっしょく 日蝕 日食"
"にっしん 日心 日神 日進 日新 日清"
"にっすう 日数"
"にっせい 日精 日生"
"にっせいさんぎょう 日製産業"
"にっせき 日石 日夕 日赤"
"にっそ 日ソ"
"にっそう 入宋"
"にっそうかん 日想観"
"にった 仁田 新田"
"にったいだい 日体大"
"にったく 日拓"
"にったん 日鍛"
"にっちしじょう ニッチ市場"
"にっちせんりゃく ニッチ戦略"
"にっちつ 日窒"
"にっちも 二進も"
"にっちゅう 日中"
"にっちゅうかん 日中韓"
"にっちょう 日朝"
"にっちょく 日直"
"にっつう 日通"
"にってい 日帝 日程"
"にってつ 日鉄"
"にってれ 日テレ"
"にってん 日展"
"にってんし 日天子"
"にっとう 日塔 入唐 日東 日当"
"にっとうぼう 日東紡"
"にっぱい 日配"
"にっぱち 二八"
"にっぴょう 日評"
"にっぽう 日豊 日報"
"にっぽじしょ 日葡辞書"
"にっぽり 日暮里"
"にっぽん 日本"
"にっぽんいち 日本一"
"にっぽんえいたいぐら 日本永代蔵"
"にっぽんかーぼん 日本カーボン"
"にっぽんがいし 日本ガイシ"
"にっぽんぐんへいし 日本軍兵士"
"にっぽんけみこん 日本ケミコン"
"にっぽんけみふぁ 日本ケミファ"
"にっぽんころむびあ 日本コロムビア"
"にっぽんしん 日本新"
"にっぽんぜおん 日本ゼオン"
"にっぽんとむそん 日本トムソン"
"にっぽんはむ 日本ハム"
"にっぽんびくたー 日本ビクター"
"にっぽんぺいんと 日本ペイント"
"にっぽんほうそう ニッポン放送"
"にっぽんゆにばっく 日本ユニバック"
"にっぽんれーす 日本レース"
"につう 二通"
"につけ 煮つけ"
"にづくり 荷作り 荷造り"
"にづくりひ 荷造費"
"にづみ 荷積み"
"にて 二手"
"にていぜんしょ 二程全書"
"にてん 二点"
"にてんさんてん 二転三転"
"にと 二途 二兎"
"にとう 二党 二盗 仁藤 二頭 二等"
"にとべ 二藤部 新渡戸"
"にとべいなぞう 新渡戸稲造"
"にとものがたり 二都物語"
"にど 二度"
"にどいも 二度芋"
"にどと 二度と"
"にどぬり 二度塗"
"にどね 二度寝"
"にな 蜷 螺"
"にないて 担い手"
"にながわ 蜷川"
"ににぎのみこと 邇邇芸命"
"ににん 二人"
"にぬき 荷抜き"
"にぬけ ２抜け"
"にぬし 荷主"
"にねん ２年 二年"
"にねんそう 二年草"
"にのあし 二の足"
"にのうで 二の腕"
"にのおり 二の折"
"にのかまえ 二構"
"にのく 二の句"
"にのじてん 二の字点"
"にのつぎ 二の次"
"にのへ 二戸"
"にのまい 二の舞い 二の舞"
"にのまる 二の丸"
"にのみや 二の宮 二宮"
"にのみやそんとく 二宮尊徳"
"にのや 二の矢"
"には 二派 二波"
"にはい 二敗 二杯"
"にはか 俄"
"にはく 二拍 二泊"
"にはつ 二発"
"にはん 二犯 二版"
"にばい 二倍"
"にばいす 二杯酢"
"にばこ 荷箱"
"にばしゃ 荷馬車"
"にばん 二番"
"にひ 二飛"
"にひき 二匹"
"にひゃく 二百"
"にびいろ 鈍色"
"にびたし 煮びたし 煮浸し"
"にふ ２符 二歩 二夫"
"にふくつい 二幅対"
"にふだ 荷札"
"にふん 二分"
"にぶ 二分 二部"
"にぶおんぷ ２分音符"
"にぶつ 二物"
"にぶね 荷船"
"にぶん 二分"
"にぶんき 二分木"
"にへい 仁平 二瓶"
"にへん 二辺"
"にべ 鰾膠 仁部"
"にほ 二歩"
"にほう 二方"
"にほうせい 二峰性"
"にほん 二本 日本"
"にほんあし 二本足"
"にほんいち 日本一"
"にほんえいたいぐら 日本永代蔵"
"にほんおおかみ 日本狼"
"にほんかいがたきこう 日本海型気候"
"にほんかがっかい 日本化学会"
"にほんがいし 日本ガイシ"
"にほんがみ 日本髪"
"にほんがわら 日本瓦"
"にほんきりゃく 日本紀略"
"にほんぎ 日本紀"
"にほんけん 日本犬"
"にほんこうき 日本後紀"
"にほんこく 日本國"
"にほんさ 二本鎖"
"にほんさいじょうりく 日本再上陸"
"にほんさん 日本サン"
"にほんさんば 日本産馬"
"にほんざる 日本猿"
"にほんしりーず 日本シリーズ"
"にほんしん 日本新"
"にほんせめんと 日本セメント"
"にほんせん ‖"
"にほんたばこさんぎょうかぶしきがいしゃ 日本たばこ産業株式会社"
"にほんだーびー 日本ダービー"
"にほんだいら 日本平"
"にほんだて 二本建"
"にほんづつみ 日本堤"
"にほんてれび 日本テレビ"
"にほんとう 日本刀"
"にほんねこ 日本猫"
"にほんはむ 日本ハム"
"にほんば 日本馬"
"にほんばれ 日本晴れ"
"にほんばんだい 日本版第"
"にほんひかりがっかい 日本光学会"
"にほんまい 日本米"
"にほんまつ 二本松"
"にほんむかし 日本昔"
"にほんむけ 日本向"
"にほんゆび 二本指"
"にほんろぼっとがっかい 日本ロボット学会"
"にぼし 煮干"
"にまい ２枚 二枚"
"にまいがい 二枚貝"
"にまいがさね 二枚重ね"
"にまいげり 二枚蹴り"
"にまいごし 二枚腰"
"にまいじた 二枚舌"
"にまいど 二枚戸"
"にまいば 二枚刃"
"にまめ 煮豆"
"にみや 二宮"
"にみょう 二名"
"にむら 二村"
"にめい 二名"
"にめん 二面"
"にもうさく 二毛作"
"にもつ 荷物"
"にもつとびら 荷物扉"
"にもの 煮物"
"にゃく 蒻 若"
"にゃくどう 若道"
"にやく 二役 荷役"
"にやっかい 荷厄介"
"にゅー Ν ν"
"にゅーかっするびょう ニューカッスル病"
"にゅーじーらんど 新西蘭"
"にゅーすそくほう ニュース速報"
"にゅーすばんぐみ ニュース番組"
"にゅーとんほう ニュートン法"
"にゅーとんりきがく ニュートン力学"
"にゅーよーく 紐育"
"にゅーよーくしじょう ニューヨーク市場"
"にゅう ν 廿 柔 乳 入"
"にゅういき 入域"
"にゅういん 入院"
"にゅういんりょう 乳飲料"
"にゅううん 乳暈"
"にゅうえい 入営"
"にゅうえき 乳液"
"にゅうえん 入園"
"にゅうか 入科 乳化 入荷"
"にゅうかい 入会"
"にゅうかく 入閣"
"にゅうかわ 丹生川"
"にゅうかん 入棺 乳管 入感 入管 入館"
"にゅうがく 入学"
"にゅうがくいわい 入学祝"
"にゅうがん 乳ガン 乳がん 乳癌"
"にゅうきゅう 入厩"
"にゅうきょ 入渠 入居"
"にゅうきょう 入鋏 入京"
"にゅうきん 入金"
"にゅうぎゅう 乳牛"
"にゅうぎょ 入御 入漁"
"にゅうぎょう 乳業"
"にゅうぎょく 入玉"
"にゅうこ 入呼 入庫"
"にゅうこう 入貢 入坑 入構 乳香 入校 入港 入稿"
"にゅうこく 入国"
"にゅうこん 入魂"
"にゅうごく 入獄"
"にゅうさつ 入札"
"にゅうさん 乳酸"
"にゅうざい 乳剤"
"にゅうざん 入山"
"にゅうし 入市 乳脂 乳歯 入試"
"にゅうしち 入質"
"にゅうしつ 入室"
"にゅうしぼう 乳脂肪"
"にゅうしゃ 入舎 入射 入社"
"にゅうしゃこう 入射光"
"にゅうしゅ 乳首 入朱 乳酒 入手"
"にゅうしゅう 乳臭"
"にゅうしゅっこ 入出庫"
"にゅうしゅっこくじ 入出国時"
"にゅうしゅつ 入出"
"にゅうしゅなん 入手難"
"にゅうしょ 入所"
"にゅうしょう 入省 入賞"
"にゅうしょうじ 乳小児"
"にゅうしょく 入職 入植"
"にゅうしん 入心 入神 入信"
"にゅうしんがく 入進学"
"にゅうじ 入寺 乳児"
"にゅうじゃく 柔弱 入寂"
"にゅうじゅう 乳汁"
"にゅうじゅく 入塾"
"にゅうじょう 乳状 入定 入城 入場"
"にゅうすい 入水"
"にゅうせい 入声 乳清"
"にゅうせいひん 乳製品"
"にゅうせき 入籍"
"にゅうせん 入船 入線 乳腺 入選"
"にゅうぜん 入善"
"にゅうそう 入槽"
"にゅうそん 入村"
"にゅうたい 入体 入退 入隊"
"にゅうたいいん 入退院"
"にゅうたいしゅつ 入退出"
"にゅうだく 乳濁"
"にゅうだん 入団"
"にゅうだんてすと 入団テスト"
"にゅうちゃく 入着"
"にゅうちょう 入朝 入超 入庁"
"にゅうてい 入廷"
"にゅうてん 入店"
"にゅうでん 入電"
"にゅうとう 入唐 入刀 入党 入湯 乳糖 乳頭"
"にゅうどう 入道"
"にゅうどうぐも 入道雲"
"にゅうどうざき 入道崎"
"にゅうない 入内"
"にゅうねん 入念"
"にゅうの 入野"
"にゅうはくしょく 乳白色"
"にゅうばい 入梅"
"にゅうばち 乳鉢"
"にゅうひ 入費"
"にゅうび 乳糜"
"にゅうふ 入夫"
"にゅうぶ 入部"
"にゅうほうほう 入方法"
"にゅうぼう 乳棒 乳房"
"にゅうまく 入幕"
"にゅうみん 入眠"
"にゅうめつ 入滅"
"にゅうめん 入麺 煮麺"
"にゅうもん 入門"
"にゅうよう 乳用 入用"
"にゅうようぎゅう 乳用牛"
"にゅうようじ 乳幼児"
"にゅうよく 入欲 入浴"
"にゅうらい 入来"
"にゅうらく 乳酪 入洛"
"にゅうりょう 入寮"
"にゅうりょく 入力"
"にゅうりょくでーた 入力データ"
"にゅうりょくぱらめーた 入力パラメータ"
"にゅうりょくふぁいる 入力ファイル"
"にゅうりょくみす 入力ミス"
"にゅうりょくもーど 入力モード"
"にゅうりん 乳輪"
"にゅうろう 入牢"
"にゅうわ 柔和"
"にょ 汝 如 女"
"にょい 女医 如意"
"にょいち 如一"
"にょいぼう 如意棒"
"にょいん 女院"
"にょう 獰 女 繞 尿"
"にょうい 尿意"
"にょういん 女院"
"にょうかん 尿管"
"にょうき 尿器"
"にょうけっせき 尿結石"
"にょうけんさ 尿検査"
"にょうご 女御"
"にょうさいかん 尿細管"
"にょうさん 尿酸"
"にょうしっきん 尿失禁"
"にょうじゅ 女孺 女嬬"
"にょうせき 尿石"
"にょうそ 尿素"
"にょうどう 尿道"
"にょうどくしょう 尿毒症"
"にょうはち 鐃鉢"
"にょうへい 尿閉"
"にょうほうしょう 尿崩症"
"にょうぼ 女房"
"にょうぼう 女房"
"にょうぼうことば 女房詞"
"にょうまく 尿膜"
"にょうもれ 尿漏れ"
"にょうろ 尿路"
"にょおう 女王"
"にょかん 女官"
"にょご 女御"
"にょし 女子"
"にょしき 女色"
"にょしょう 女将 女性"
"にょしょく 女色"
"にょじつ 如実"
"にょじゅ 女孺 女嬬"
"にょぜ 如是"
"にょぜがもん 如是我聞"
"にょたい 女体"
"にょにん 女人"
"にょほう 如法"
"にょぼさつ 如菩薩"
"にょぼん 女犯"
"にょやしゃ 如夜叉"
"にょらい 如来"
"にょろ 〜"
"によう 二様 二葉"
"によど 仁淀"
"にら 韭 薤 韮"
"にらさき 韮崎"
"にらさわ 韮沢"
"にらたま ニラ玉"
"にらづか 韮塚"
"にらみ 睨み"
"にらみあい 睨み合い"
"にらめっこ 睨めっこ"
"にらやま 韮山"
"にらやまがさ 韮山笠"
"にらればいため ニラレバ炒め"
"にらんせい 二卵性"
"にり 二理"
"にりつ 二律"
"にりゅう 二流"
"にりん ２輪 二輪"
"にるい 二類 二塁"
"にれ 楡"
"にれい 楡井"
"にれつ 二列"
"にろう 二浪"
"にわ 二話 二羽 丹羽 庭"
"にわいし 庭石"
"にわいじり 庭弄り 庭いじり"
"にわか 仁輪加 俄か 俄"
"にわかあめ 瀑 にわか雨 俄雨"
"にわかじこみ 俄仕込み"
"にわかじたて 俄仕立て"
"にわかゆき 俄雪"
"にわき 庭木"
"にわきょういく 庭教育"
"にわさか 庭坂"
"にわさき 庭先"
"にわし 庭師"
"にわしごと 庭仕事"
"にわせ 庭瀬"
"にわた 庭田"
"にわたし 荷渡"
"にわたずみ 潦"
"にわづくり 庭作り"
"にわとり 鷄 鶏"
"にわとりごや 鶏小屋"
"にわの 庭野"
"にわばん 庭番"
"にわも 庭面"
"にわり 二割"
"にん 姙 刄 儿 仁 刃 妊 忍 認 人 任"
"にんあい 人愛"
"にんあん 仁安"
"にんい ∀ 任意"
"にんか 認可"
"にんかん 任官"
"にんがい 人界 人外"
"にんき 任期 人気"
"にんきうま 人気馬"
"にんきぎれ 任期切れ"
"にんきょ 認許"
"にんきょう 仁侠 任侠"
"にんぎょ 人魚"
"にんぎょう 人形"
"にんぎょひめ 人魚姫"
"にんく 忍苦 人工"
"にんぐみ 人組"
"にんけんてんのう 仁賢天皇"
"にんげつ 人月"
"にんげん 人間"
"にんげんぎらい 人間嫌い"
"にんげんどっく 人間ドック"
"にんげんどらま 人間ドラマ"
"にんげんわざ 人間業"
"にんこうてんのう 仁孝天皇"
"にんさんばけしち 人三化七"
"にんさんぷ 妊産婦"
"にんしき 認識"
"にんしゅう 人衆"
"にんしょう 認照 人証 人称 認証"
"にんしん 妊娠"
"にんじ 仁治"
"にんじゃ 忍者"
"にんじゃでら 忍者寺"
"にんじゅ 仁寿"
"にんじゅう 忍従"
"にんじゅつ 忍術"
"にんじょう 人定 刃傷 人情"
"にんじょうばなし 人情噺"
"にんじん 忍人 人蔘 人身 人参"
"にんずう 人数"
"にんせん 人選"
"にんそう 人相"
"にんそうがき 人相書"
"にんそうみ 人相見"
"にんそく 人足"
"にんたい 忍耐"
"にんだく 認諾"
"にんち 任地 認知"
"にんちもでる 認知モデル"
"にんちゅう 人中"
"にんちゅうはく 人中白"
"にんてい 人体 認定"
"にんてん 人天"
"にんてんどう 任天堂"
"にんでん 人天"
"にんとうぜい 人頭税"
"にんとく 仁徳"
"にんどう 人道 忍道 忍冬"
"にんな 仁和"
"にんにく 葫 蒜 忍辱 大蒜"
"にんにち 人日"
"にんにょう 人繞"
"にんねん 人年"
"にんのう 人皇"
"にんぴ 認否"
"にんぴにん 人非人"
"にんぴょう 任憑"
"にんぴん 人品"
"にんぶん 人分"
"にんぷ 人夫 妊婦"
"にんべつ 人別"
"にんべん 人偏"
"にんぼう 人法"
"にんぽう 忍法"
"にんぽうちょう 忍法帖"
"にんまえ 人前"
"にんみょうてんのう 仁明天皇"
"にんむ 任務"
"にんめ 人目"
"にんめい 任名 任命"
"にんめん 任免"
"にんよう 認容 任用"
"ぬ 濡 奴 怒"
"ぬーどしゃしん ヌード写真"
"ぬいいと 縫い糸 縫糸"
"ぬいぐるみ 縫い包み"
"ぬいしろ 縫代 縫い代"
"ぬいだ 縫田"
"ぬいとり 縫取り 縫い取り"
"ぬいはく 縫箔"
"ぬいばり 縫針 縫い針"
"ぬいめ 縫目 縫い目"
"ぬいもの 縫物 縫い物"
"ぬいもん 縫紋"
"ぬえ 鵺"
"ぬか 額 糠"
"ぬかあめ 糠雨"
"ぬかか 糠蚊"
"ぬかご 零余子 糠子"
"ぬかずき 酸漿"
"ぬかた 額田"
"ぬかたのおおきみ 額田王"
"ぬかづけ 糠漬"
"ぬかどこ 糠床"
"ぬかばえ 糠蠅"
"ぬかばたらき 糠働き"
"ぬかびら 糠平"
"ぬかびらこ 糠平湖"
"ぬかぶくろ 糠袋"
"ぬかみそ 糠味噌"
"ぬかみそづけ 糠味噌漬"
"ぬかよろこび ぬか喜び 糠喜び"
"ぬかり 泥濘 抜かり"
"ぬかるみ 泥濘"
"ぬき 緯 抜き 貫"
"ぬきあしさしあし 抜き足差し足"
"ぬきい 貫井"
"ぬきいた 貫板"
"ぬきいと 緯糸"
"ぬきうち 抜打ち"
"ぬきうつし 抜写し"
"ぬきがき 抜書 抜書き"
"ぬきさし 抜き差し"
"ぬきずり 抜刷"
"ぬきて 抜手 貫手"
"ぬきとりけんさ 抜取り検査"
"ぬきに 抜き荷 抜荷"
"ぬきほん 抜本"
"ぬきみ 抜身 抜き身"
"ぬきやま 抜山"
"ぬきよみ 抜読み"
"ぬぎき 脱着 脱ぎ着"
"ぬぎすて 脱ぎ捨て"
"ぬく 温"
"ぬくい 貫井"
"ぬくしな 温品"
"ぬくぬく 温々"
"ぬくみ 温み"
"ぬくもり 温もり"
"ぬけ 抜 脱 抜け"
"ぬけあな 抜穴 抜け穴"
"ぬけがけ 抜駆 抜け駆け"
"ぬけがら 脱殻 抜殻 脱け殻 蛻 抜け殻"
"ぬけげ 脱け毛 抜け毛"
"ぬけに 抜荷 抜け荷"
"ぬけにん 抜忍 抜け忍"
"ぬけみち 抜道 抜け道"
"ぬけめ 抜目"
"ぬさ 帛 幣"
"ぬし 塗師 主"
"ぬすっと 盗人"
"ぬすびと 盗人"
"ぬすみ 窃 盗み"
"ぬすみぎき 盗み聞き"
"ぬすみぐい 盗み食い"
"ぬすみどり 盗み撮り"
"ぬすみみ 盗み見"
"ぬすむ 窃"
"ぬた 饅 垈"
"ぬなわ 沼縄"
"ぬの 布"
"ぬのいち 布市"
"ぬのかわ 布川"
"ぬのきそ 布基礎"
"ぬのきれ 布切れ"
"ぬのぎれ 布切れ"
"ぬのぐつ 布靴"
"ぬのじ 布地"
"ぬのせい 布製"
"ぬのてーぷ 布テープ"
"ぬのはし 布橋"
"ぬのはらえき 布原駅"
"ぬのびき 布引"
"ぬのぶくろ 布袋"
"ぬのぼり 布掘り"
"ぬのまき 布巻"
"ぬのむら 布村"
"ぬのめ 布目"
"ぬのめがわら 布目瓦"
"ぬのや 布屋"
"ぬひ 奴婢"
"ぬぼく 奴僕"
"ぬま 沼"
"ぬまうえ 沼上"
"ぬまお 沼尾"
"ぬまおか 沼岡"
"ぬまかぜ 沼風"
"ぬまかみ 沼上"
"ぬまかわ 沼川"
"ぬまがみ 沼上"
"ぬまくない 沼宮内"
"ぬまくま 沼隈"
"ぬまくら 沼倉"
"ぬまぐち 沼口"
"ぬまざき 沼崎"
"ぬまじり 沼尻"
"ぬまず 沼津"
"ぬまずひがし 沼津東"
"ぬまた 沼田"
"ぬまち 沼地"
"ぬまづ 沼津"
"ぬまべ 沼部"
"ぬまやま 沼山"
"ぬめ 絖"
"ぬめぬめ 滑滑 滑々"
"ぬめり 滑り"
"ぬもじ 盗文字"
"ぬり 塗り 塗"
"ぬりかえ 塗替え 塗替"
"ぬりかべ 塗壁 塗り壁"
"ぬりぐすり 塗薬 塗り薬"
"ぬりし 塗師"
"ぬりつけ 塗付"
"ぬりばし 塗箸 塗り箸"
"ぬりもの 塗物"
"ぬるま 微温"
"ぬるまゆ ぬるま湯"
"ぬるみ 温み"
"ぬるゆ 微温湯"
"ぬれ 濡れ"
"ぬれえん 濡縁 濡れ縁"
"ぬれがみ 濡れ髪"
"ぬれぎぬ 濡衣 濡れ衣"
"ぬれごと 濡事"
"ぬれたおる 濡れタオル"
"ぬれねずみ 濡れ鼠"
"ぬれば 濡場"
"ぬればいろ 濡羽色 濡れ羽色"
"ぬれぶきん 濡れ布巾"
"ね 寢 涅 袮 祢 禰 子 嶺 音 寝 根 値"
"ねーちゃん ネーちゃん"
"ねあか 根明"
"ねあがり 根上り 根上 値上がり"
"ねあがりまつ 根上り松"
"ねあげ 値上 値上げ"
"ねあせ 盗汗 寝汗"
"ねあらい 値洗い"
"ねい 祢 禰 侫 佞 聹 濘 檸 嚀 寧"
"ねいか 寧夏"
"ねいかん 佞奸"
"ねいき 寝息"
"ねいし 根石"
"ねいしん 佞臣"
"ねいじつ 寧日"
"ねいじん 佞人"
"ねいは 寧波"
"ねいひつ 寧謐"
"ねいも 根芋"
"ねいりばな 寝入り端"
"ねいれ 値入れ"
"ねいろ 音色"
"ねうお 根魚"
"ねうごき 値動き"
"ねうち 値打 値打ち"
"ねえ 姉"
"ねえさま 姉様"
"ねえさん 姐さん 姉さん"
"ねえちゃん 姉ちゃん"
"ねえや 姉や"
"ねえよ 寧代"
"ねお 根緒 根尾"
"ねおき 寝起"
"ねおんかん ネオン管"
"ねおんがい ネオン街"
"ねかた 根方 寝方"
"ねかぶ 根株"
"ねが 願"
"ねがい 願い 願"
"ねがいぶみ 願い文"
"ねがえり 寝返り"
"ねがお 寝顔"
"ねがさ 値がさ 値嵩"
"ねがため 根固め"
"ねがったりかなったり 願ったり叶ったり"
"ねがみ 根上"
"ねがわくは 願わくは"
"ねがわくば 願わくば"
"ねきり 根切り"
"ねきりむし 根切虫"
"ねぎ 禰宜 葱"
"ねぎあか ネギ亜科"
"ねぎか 葱科"
"ねぎし 根岸"
"ねぎとろどん ねぎとろ丼"
"ねぎぼうず 葱坊主"
"ねぎま 葱鮪"
"ねぎやき ねぎ焼き ねぎ焼 ネギ焼き ネギ焼"
"ねぎり 根切り 値切り 値切"
"ねぎわ 寝際 根際"
"ねくずれ 値崩れ"
"ねくび 寝首"
"ねくら 根暗"
"ねぐされ 根腐れ"
"ねぐせ 寝癖"
"ねぐら 塒"
"ねこ 猫"
"ねこあし 猫脚 猫足"
"ねこいた 猫板"
"ねこいらず 猫いらず"
"ねこか 猫科"
"ねこかぶり 猫かぶり 猫被り"
"ねこかわいがり 猫かわいがり 猫可愛がり"
"ねこかん 猫缶"
"ねこかんけい 猫関係"
"ねこがた 猫型"
"ねこぐるま 猫車"
"ねこざめ 猫鮫"
"ねこじた 猫舌"
"ねこじまん 猫自慢"
"ねこぜ 猫背"
"ねこそぎ 根こそぎ 根刮ぎ"
"ねこた 猫田"
"ねこだまし 猫騙し"
"ねこっけ 猫っ毛"
"ねこて 猫手"
"ねこなでごえ 猫なで声 猫撫で声"
"ねこのこ 猫の子"
"ねこのて 猫の手"
"ねこのひたい 猫の額"
"ねこのめ 猫の目"
"ねこは 猫派"
"ねこばば 猫糞"
"ねこびたい 猫額"
"ねこべ 猫部"
"ねこま 猫間 猫魔"
"ねこまた 猫又"
"ねこまたぎ 猫跨ぎ"
"ねこみみ 猫耳"
"ねこむすめ 猫娘"
"ねこめ 猫目"
"ねこめいし 猫目石"
"ねこやなぎ 猫柳"
"ねこよう 猫用"
"ねごと 寝言"
"ねごや 根小屋"
"ねごろ 根来 値頃"
"ねさがり 値下がり"
"ねさげ 値下 値下げ"
"ねざかな 根魚"
"ねざき 根崎"
"ねざけ 寝酒"
"ねざさ 根笹"
"ねざし 根挿し 根差し"
"ねざま 寝様"
"ねざめ 寝醒め 寝覚め"
"ねざや 値鞘"
"ねしち 根質"
"ねしな 寝しな"
"ねしょうが 根生姜"
"ねじ 捻 螺 捩子 捻子 螺子"
"ねじあな 螺子穴 ネジ穴"
"ねじきり ねじ切り ネジ切り"
"ねじくぎ ねじ釘 螺子釘 ネジ釘"
"ねじけ 拗け"
"ねじこみ 捩じ込み"
"ねじしき ねじ式"
"ねじどめ ネジ止め"
"ねじまわし ねじ回し ネジ回し"
"ねじめ 音締め 根締め 根占"
"ねじやま ねじ山 ネジ山"
"ねじりはちまき 捩り鉢巻き"
"ねじろ 根白 根城"
"ねすがた 寝姿"
"ねすこ ネス湖"
"ねず 禰津 根津 杜松 鼠"
"ねずみ 子 鼡 鼠"
"ねずみいろ 鼠色"
"ねずみおとこ ネズミ男 鼠男"
"ねずみがえし 鼠返し"
"ねずみこう ネズミ講 ねずみ講 鼠講"
"ねずみこぞう 鼠小僧"
"ねずみざん 鼠算"
"ねずみざんしき ネズミ算式 ねずみ算式"
"ねずみしの 鼠志野"
"ねずみたち 鼠達"
"ねずみとり ネズミ取り ネズミ捕り 鼠捕り"
"ねずみどし 子年"
"ねずみはなび ネズミ花火 鼠花火"
"ねぞう 寝相"
"ねた 妬"
"ねたきり 寝た切り"
"ねたきりろうじん 寝たきり老人"
"ねたぎれ ネタ切れ"
"ねただし ネタ出し"
"ねたばこ 寝タバコ 寝たばこ"
"ねたふり ネタ振り"
"ねたみ 嫉み 妬み"
"ねたんぽ 根担保"
"ねだ 根太"
"ねだい 寝台"
"ねだやし 根絶やし"
"ねだん 値段"
"ねっか 熱火 熱河"
"ねっから 根っから"
"ねっかんあつえん 熱間圧延"
"ねっき 熱気"
"ねっきゅう 熱球"
"ねっきょう 熱狂"
"ねっけい 熱型"
"ねっけつ 熱血"
"ねっけつかん 熱血漢"
"ねっけん 熱圏"
"ねっこ 根っ子 根っこ"
"ねっさ 熱砂"
"ねっさん 熱讃"
"ねっしせん 熱視線"
"ねっしゃ 熱砂 熱写"
"ねっしゃびょう 熱射病"
"ねっしゅ 熱酒"
"ねっしょ 熱暑"
"ねっしょう 熱傷 熱唱"
"ねっしん 熱心"
"ねっすい 熱水"
"ねっせい 熱誠 熱性"
"ねっせん 熱泉 熱線 熱戦"
"ねったい 熱帯"
"ねったいぎょ 熱帯魚"
"ねったいりん 熱帯林"
"ねっちゅう 熱中"
"ねってい 熱低"
"ねっとう 熱鬧 熱闘 熱湯"
"ねっとうら ネット裏"
"ねっとかでん ネット家電"
"ねっときょく ネット局"
"ねっとじょう ネット上"
"ねっとせつぞく ネット接続"
"ねっとはんばい ネット販売"
"ねっとわーくか ネットワーク化"
"ねっぱ 熱波"
"ねっぱつ 熱発"
"ねっぷう 熱風"
"ねつ 捏 熱"
"ねつあい 熱愛"
"ねつい 熱意"
"ねつえねるぎー 熱エネルギー"
"ねつえん 熱演"
"ねつえんじゅんかん 熱塩循環"
"ねつか 熱価"
"ねつかく 熱核"
"ねつかん 熱感"
"ねつがん 熱願"
"ねつき 値付き"
"ねつきうお 根付魚 根付き魚"
"ねつぎ 根継ぎ"
"ねつぐん 熱群"
"ねつけ 熱気 根付け 根付"
"ねつけん 熱研 熱圏"
"ねつげん 熱源"
"ねつさまし 熱冷まし"
"ねつじょう 熱情"
"ねつぞう 捏造"
"ねつてき 熱的"
"ねつでんこうか 熱電効果"
"ねつでんそし 熱電素子"
"ねつでんつい 熱電対"
"ねつど 熱度"
"ねつびょう 熱病"
"ねつべん 熱弁"
"ねつぼう 熱望"
"ねつよく 熱浴"
"ねつらい 熱雷"
"ねつりき 熱力"
"ねつりゅう 熱流"
"ねつりょう 熱量"
"ねつるい 熱涙"
"ねつれつ 熱烈"
"ねつろん 熱論"
"ねづ 禰津 根津"
"ねづか 根塚"
"ねづけ 値付け"
"ねづまり 根詰まり"
"ねていとう 根抵当"
"ねとり 音取"
"ねどこ 寝所 寝床"
"ねどし 子年"
"ねなし 根無し"
"ねなしぐさ 根無草 根無し草"
"ねなりがき 根成柿"
"ねのひ 子の日"
"ねはば 値幅"
"ねはん 涅槃"
"ねはんぎょう 涅槃経"
"ねば 根羽 粘"
"ねばち 根鉢"
"ねばつち 粘土"
"ねばねば 粘粘 粘々"
"ねばり 粘り"
"ねばりけ 粘り気"
"ねばりごし 粘り腰"
"ねびえ 寝冷え"
"ねびき 値引 値引き"
"ねびらき 値開き"
"ねふだ 値札"
"ねぶ 合歓"
"ねぶか 根深"
"ねぶかねぎ 根深葱"
"ねぶかわ 根府川"
"ねぶくろ 寝袋"
"ねぶと 根太"
"ねぶみ 値踏み"
"ねぷつにうむけいれつ ネプツニウム系列"
"ねほしょう 根保証"
"ねほりはほり 根掘り葉掘り"
"ねほん 根本"
"ねぼう 寝坊"
"ねぼけまなこ 寝惚け眼"
"ねぼすけ 寝坊助"
"ねま 寝間"
"ねまき 根巻 根巻き 寝衣 寝巻 寝間着"
"ねまちづき 寝待月"
"ねまわし 根回し"
"ねまわり 根回り"
"ねみつば 根三つ葉"
"ねみみ 寝耳"
"ねみみにみず 寝耳に水"
"ねむ 合歓"
"ねむけ 眠気"
"ねむけざまし 眠気覚まし"
"ねむのき 棔 合歓木"
"ねむり 眠り"
"ねむりきょうしろう 眠狂四郎"
"ねむりぐすり 眠り薬"
"ねむりひめ 眠り姫"
"ねむろ 根室"
"ねもと 根元 根本"
"ねや 寝屋 閨"
"ねゆき 根雪"
"ねらい 狙い"
"ねらいうち 狙い撃ち"
"ねり 練 練り"
"ねりいと 練糸"
"ねりいろ 練色"
"ねりえ 煉り餌 煉餌 練り餌"
"ねりがし 練菓子"
"ねりきり 煉り切り 煉切"
"ねりこ 煉り粉 練粉 練り粉"
"ねりこう 煉り香 煉香 練香 練り香"
"ねりこうじ 煉り麹 練り麹"
"ねりせいひん 煉り製品 練製品"
"ねりぬき 練貫"
"ねりべい 練塀"
"ねりま 練馬"
"ねりもの 煉り物 練物"
"ねりようかん 煉り羊羹 練羊羹"
"ねるちんすく 尼布楚"
"ねわけ 根分け"
"ねわざ 寝技"
"ねわら 寝藁"
"ねん 棯 拈 稔 捻 撚 然 燃 粘 念 年"
"ねんあき 年明き"
"ねんあけ 年明"
"ねんあし 年足"
"ねんいり 念入 念入り"
"ねんえき 粘液"
"ねんおし 念押し"
"ねんかい 年回 年会"
"ねんかん 年刊 年鑑 年間"
"ねんが 年画 年賀"
"ねんがく 年額"
"ねんがらねんじゅう 年がら年中"
"ねんがん 念願"
"ねんき 年記 年紀 年忌 年期 年季"
"ねんきぼうこう 年期奉公 年季奉公"
"ねんきゅう 年給 年休"
"ねんきん 粘菌 年金"
"ねんぎょ 年魚"
"ねんくれ 年暮"
"ねんぐ 年貢"
"ねんぐまい 年貢米"
"ねんげつ 年月"
"ねんげみしょう 拈華微笑"
"ねんげん 年限"
"ねんこう 年功"
"ねんこん 念根"
"ねんご 年後"
"ねんごう 年号"
"ねんごと 年毎"
"ねんごろ 懇ろ 年頃"
"ねんさ 年差"
"ねんさい 年歳 年祭"
"ねんさん 年産"
"ねんざ 捻挫"
"ねんし 念死 撚糸 年始"
"ねんしき 年式"
"ねんした 年下"
"ねんしゃ 念者 念写"
"ねんしゅう 年周 年収"
"ねんしゅつ 捻出"
"ねんしょ 念書 年初"
"ねんしょう 年商 年少 燃焼"
"ねんしょうとう 燃焼筒"
"ねんじ 念持 年時 年次"
"ねんじぶつ 念持仏"
"ねんじゃ 念者"
"ねんじゅ 念誦 念珠"
"ねんじゅう 年中"
"ねんすう 年数"
"ねんず 念珠"
"ねんせい 年制 年生 粘性"
"ねんそつ 年卒"
"ねんだい 年代"
"ねんだんせい 粘弾性"
"ねんちゃく 粘着"
"ねんちゃくてーぷ 粘着テープ"
"ねんちゅう 粘稠 年中"
"ねんちょう 粘稠 年長"
"ねんてん 捻転"
"ねんとう 年頭 念頭"
"ねんとうぶつ 燃灯仏"
"ねんど 粘度 粘土 年度"
"ねんどう 念動"
"ねんどがわら 粘土瓦"
"ねんどがん 粘土岩"
"ねんない 年内"
"ねんにん 念人"
"ねんねん 年年 年々"
"ねんのため 為念 念のため 念の為"
"ねんはん 年半"
"ねんばつ 年伐"
"ねんばん 年版"
"ねんばんがん 粘板岩"
"ねんぱ 念波"
"ねんぱい 年輩 年配"
"ねんびゃくねんじゅう 年百年中"
"ねんぴ 燃費"
"ねんぴょう 年表"
"ねんぶつ 念仏"
"ねんぶつおどり 念仏踊"
"ねんぶん 年分"
"ねんぷ 年賦 年譜"
"ねんべつ 年別"
"ねんぽう 念法 年俸 年報"
"ねんまえ 年前"
"ねんまく 粘膜"
"ねんまつ 年末"
"ねんめ 年目"
"ねんゆ 燃油"
"ねんゆう 念友"
"ねんよ 年余"
"ねんらい 年来"
"ねんり 年利"
"ねんりき 念力"
"ねんりつ 年率"
"ねんりょ 念慮"
"ねんりょう 燃量 燃料"
"ねんりょうぎれ 燃料切れ"
"ねんりょうさいくる 燃料サイクル"
"ねんりょうたんく 燃料タンク"
"ねんりょうぼう 燃料棒"
"ねんりん 年輪"
"ねんれい 年令 年齢"
"ねんわり 年割"
"の − 濃 廼 乃 之 埜 野"
"のーちらすごう ノーチラス号"
"のーと 帳面"
"のーとがた ノート型"
"のーどかん ノード間"
"のーべるしょう ノーベル賞"
"のいけ 野池"
"のいち 野市"
"のいちご 野苺"
"のう 獰 皇 王 腦 碯 瑙 惱 悩 曩 嚢 衲 納 能生 膿 濃 農 能 脳"
"のうあい 能間"
"のうあつ 脳圧"
"のういがい 脳以外"
"のういっけつ 脳溢血"
"のういん 能因"
"のうえん 濃艶 脳炎 農園"
"のうおん 濃音"
"のうか 濃化 農科 農家"
"のうかい 脳回 納会"
"のうかいだい 能開大"
"のうかがく 脳科学"
"のうかく 能格"
"のうかしん 膿痂疹"
"のうかすいたい 脳下垂体"
"のうかん 農閑 農間 能管 納棺 脳幹 納竿"
"のうかんけい 脳関係"
"のうがき 能書 能書き"
"のうがく 能楽 農学"
"のうがっこう 農学校"
"のうがや 能ヶ谷"
"のうき 納城 農期 能記 農機 納期"
"のうきのう 脳機能"
"のうきょう 脳橋 膿胸 納経 農協"
"のうきょうげん 能狂言"
"のうきょけつ 脳虚血"
"のうきん 納金"
"のうぎょう 農業"
"のうぎょうしゃだいがっこう 農業者大学校"
"のうぐ 農具"
"のうけ 能化"
"のうけっせん 脳血栓"
"のうけつ 膿血"
"のうけつりゅう 脳血流"
"のうけん 脳研"
"のうげ 能化"
"のうげい 能芸 農芸"
"のうげか 脳外科"
"のうこう 農高 農工 農耕 濃厚"
"のうこうそく 脳梗塞"
"のうこつ 納骨"
"のうこん 濃紺"
"のうさい 能才 濃彩 納采"
"のうさいぼう 脳細胞"
"のうさぎ 野兎"
"のうさぎょう 農作業"
"のうさく 農作"
"のうさくしょ 能作書"
"のうさくもつ 農作物"
"のうさつ 納札 悩殺"
"のうさん 農産"
"のうさんそん 農山村"
"のうざい 能材"
"のうざしょう 脳挫傷"
"のうし 野牛 直衣 濃紫 脳死"
"のうしつ 脳室"
"のうしゃ 納車"
"のうしゃかい 納射会"
"のうしゅ 嚢腫"
"のうしゅう 濃州 能州"
"のうしゅく 濃縮"
"のうしゅくうらん 濃縮ウラン"
"のうしゅっけつ 脳出血"
"のうしゅよう 脳腫瘍"
"のうしょ 農書 能書"
"のうしょう 脳漿 農商 農相 脳症"
"のうしょうがい 脳障害"
"のうしょく 濃色"
"のうしんけい 脳神経"
"のうしんとう 脳震盪"
"のうじ 能事 能地 農事"
"のうじず 脳磁図"
"のうじゅ 納受"
"のうじゅう 膿汁"
"のうじゅん 濃醇"
"のうじょう 嚢状 農場"
"のうすい 農水"
"のうすいしゅ 脳水腫"
"のうずい 脳髄"
"のうせい 脳性 能性 農政"
"のうせきずいしんけい 脳脊髄神経"
"のうせん 能詮 農専"
"のうせんかた 納銭方"
"のうぜい 納税"
"のうぜんかずら 凌霄花"
"のうそう 能相 農宗"
"のうそくせん 脳塞栓"
"のうそっちゅう 脳卒中"
"のうそん 農村"
"のうそんしょう 脳損傷"
"のうたりん 脳足りん"
"のうたん 濃淡"
"のうだ 納田"
"のうだい 農大"
"のうち 納地 野内 農地"
"のうちゅう 嚢虫 嚢中 脳中"
"のうてい 脳底"
"のうてん 脳天"
"のうてんき 腦天氣 脳天気 能天気"
"のうてんし 能天使"
"のうど 農奴 濃度"
"のうどう 能動 農道"
"のうない 脳内"
"のうなし 能無し"
"のうなんかしょう 脳軟化症"
"のうにゅう 納入"
"のうにん 納人"
"のうは 脳波"
"のうはん 農繁"
"のうひつ 能筆"
"のうひょう 脳表"
"のうひん 納品"
"のうひんけつ 脳貧血"
"のうび 濃尾"
"のうびょう 脳病"
"のうびょういん 脳病院"
"のうふ 農婦 農夫 納付"
"のうぶたい 能舞台"
"のうぶん 能文"
"のうへい 農兵"
"のうへいぶし 農兵節"
"のうべん 能弁"
"のうほ 農圃"
"のうほう 膿疱 嚢胞 農法"
"のうほん 能本 納本"
"のうほんしゅぎ 農本主義"
"のうまく 脳膜"
"のうみ 能見 能美"
"のうみそ 脳みそ 脳ミソ 脳味噌"
"のうみつ 濃密"
"のうみん 農民"
"のうむ 濃霧"
"のうむしょう 農務省"
"のうめん 能面"
"のうやく 農薬"
"のうやくしゃ 能役者"
"のうやま 納山"
"のうよう 嚢瘍 膿瘍"
"のうらん 悩乱"
"のうり 能吏 脳裡 脳裏"
"のうりき 能力"
"のうりつ 能率"
"のうりつきゅう 能率給"
"のうりょう 脳梁 納涼"
"のうりょく 濃緑 能力"
"のうりょくきゅう 能力給"
"のうりん 農林"
"のえ 野家"
"のえる Ｎｏёｌ"
"のおがた 直方"
"のかぜ 野風"
"のかた 野方"
"のかみ 野上"
"のがき 野垣"
"のがた 野方"
"のがみ 埜上 野上"
"のがわ 野河 野川"
"のき 檐 簷 軒"
"のきうら 軒裏"
"のきがわら 軒瓦"
"のきげた 軒桁"
"のきさき 軒先"
"のきした 軒下"
"のきじゃばら 軒蛇腹"
"のきたけ 軒丈"
"のきだか 軒高"
"のきどい 軒樋"
"のきなみ 軒並"
"のきならび 軒並び"
"のきば 軒端"
"のきひらがわら 軒平瓦"
"のきまるがわら 軒丸瓦"
"のきわり 軒割"
"のぎ 野義 野木 乃木 禾 芒"
"のぎく 野菊"
"のぎさか 乃木坂"
"のぎざか 乃木坂"
"のぎし 野岸"
"のぎつね 野狐"
"のぎめ 禾目"
"のぎわ 野際"
"のくび 野首"
"のぐそ 野糞"
"のぐち 野口"
"のぐら 野倉"
"のけもの 除け者"
"のげ 野毛"
"のこ 鋸"
"のこぎり 鋸"
"のこぎりがま 鋸鎌"
"のこぎりば 鋸歯"
"のこくず 鋸屑"
"のこのしま 能古島"
"のこば 鋸歯"
"のこらず 残らず"
"のこり 残り"
"のこりかす 残り滓"
"のこりが 残り香"
"のこりび 残り火"
"のさか 野栄 野坂"
"のさっぷ 納沙布"
"のさっぷみさき 納沙布岬"
"のざき 野咲 野崎"
"のざききた 野崎北"
"のざと 野里"
"のざらし 野晒し"
"のざる 野猿"
"のざわ 野澤 野沢"
"のざわな 野沢菜"
"のし 熨 熨斗"
"のしがわら 熨斗瓦"
"のした 野下"
"のしぶくろ 熨斗袋"
"のしろ 能城 野城 能代"
"のじ 野路 野地"
"のじし 野猪"
"のじま 野嶋 野島"
"のじゅく 野宿"
"のじり 野尻"
"のじりこ 野尻湖"
"のじりほうえい 野尻抱影"
"のじん 野人"
"のずえ 野末"
"のせ 能瀬 野瀬 能勢"
"のせがわ 野迫川"
"のぞえ 野副 野添"
"のぞき 覗 覗き"
"のぞきあな 覗き穴"
"のぞきまど 覗き窓"
"のぞきみ 覗き見"
"のぞみ 望み 稀 希 望"
"のぞむ 望"
"のぞりこ 野反湖"
"のたれ 湾"
"のたれじに 野垂れ死に"
"のだ 野田"
"のだけ 野竹"
"のだて 野点"
"のだはま 野田浜"
"のち 後"
"のちかわ 後川"
"のちざん 後産"
"のちぞい 後添い"
"のちぞえ 後添え"
"のちのち 後後 後々"
"のちほど 後ほど 後程"
"のちょう 野帳"
"のっと ¬ 祝詞"
"のっとり 乗っ取り"
"のっぴき 退っ引き"
"のっぽろ 野幌"
"のつ 野津"
"のつはる 野津原"
"のつぼ 野壺"
"のづき 野月"
"のづち 野槌"
"のづみ 野積み"
"のづら 野面"
"のてう 盧泰愚"
"のてん 野天"
"ので 野出"
"のでら 野寺"
"のと 能都 能登"
"のとかわ 能登川"
"のとろ 能取"
"のど 吭 咽 喉"
"のどあめ 喉飴 のど飴"
"のどか 長閑"
"のどくび 喉頸"
"のどごし 喉ごし 喉越し"
"のどじまん のど自慢 喉自慢"
"のどちんこ 喉ちんこ"
"のどびこ 喉彦"
"のどぶえ 喉笛"
"のどぼとけ 喉仏"
"のどもと 喉元"
"のどわ 喉輪"
"のなか 野仲 野中"
"のなみ 野並"
"のねこ 野猫"
"のねずみ 野ネズミ 野鼠"
"のの 野々"
"ののか 野々香"
"ののはら 野々原"
"のはら 野原"
"のば 野場"
"のばし 伸ばし"
"のばと 野鳩"
"のばな 野花"
"のばなし 野放し"
"のひら 野平"
"のび 伸び 伸 野火"
"のびた のび太"
"のびたき 野鶲"
"のびと 野人"
"のびりつ 伸率"
"のびる 野蒜"
"のふせ 野伏"
"のぶ 惟 暢 允 亘 宣 伸 延 修 展 信 順"
"のぶあき 悦旦 延晃 伸晃 宣明 信昭 伸明 信明"
"のぶえ 延枝 信恵 伸枝"
"のぶお 陳雄 信朗 暢夫 信生 伸生 宣夫 信男 伸夫 信雄 信夫"
"のぶおか 信岡"
"のぶおき 暢興"
"のぶかず 信和"
"のぶかつ 信克 信勝 信雄"
"のぶき 信木 信樹 伸樹"
"のぶくに 信邦"
"のぶこ 展子 延子 暢子 敦子 伸子 信子"
"のぶし 野臥 野伏"
"のぶじ 伸自 伸治"
"のぶすけ 宣介"
"のぶせり 野臥せり 野伏せり"
"のぶた 信太"
"のぶたか 伸啓 信高 信隆 信孝"
"のぶただ 信忠"
"のぶち 野縁"
"のぶなが 信長"
"のぶはら 信原"
"のぶはる 伸治"
"のぶひこ 延彦 暢彦 宣彦 伸彦 信彦"
"のぶひさ 順久 延久 暢久 信久"
"のぶひで 宣秀"
"のぶひと 宣仁"
"のぶひろ 伸廣 伸啓 伸裕 信寛 宣博 伸広 展弘 宣弘 伸弘 信洋 伸浩 信宏 信弘 信博"
"のぶふさ 信房"
"のぶまさ 伸昌 宣政"
"のぶみつ 信光"
"のぶや 誠也 暢也 信也"
"のぶやす 宣保 延康 信康"
"のぶゆき 伸介 展之 暢之 宣之 伸幸 伸行 伸之 信幸 信之 信行"
"のぶよし 伸好 信義"
"のぶろう 宣郎 信郎 伸郎"
"のぶん 攵"
"のへじ 野辺地"
"のへん 野辺"
"のべ 野邊 延べ 延 野辺"
"のべいた 延板"
"のべおか 延岡"
"のべがね 延金"
"のべがみ 延紙"
"のべすう 延数"
"のべだか 延高"
"のべつぼ 延坪"
"のべつまくなし のべつ幕無し"
"のべな 野辺名"
"のべぼう 延べ棒"
"のほう 野放 野方"
"のほり 野堀"
"のぼとけ 野仏"
"のぼり 登 昇り 登り 上り 幟"
"のぼりおり 登り降り 昇り降り 上り下り"
"のぼりざか 登り坂 上り坂"
"のぼりと 登戸"
"のぼりばた 幟旗"
"のぼりべつ 登別"
"のぼりぼう 登り棒"
"のぼりりゅう 登り竜 昇り竜"
"のぼる 昇 登"
"のま 々 野間"
"のまおい 野馬追"
"のまずくわず 飲まず食わず"
"のまち 野町"
"のまひろし 野間宏"
"のみ 乃美 能美 鑿 蚤"
"のみかい 呑み会 飲み会"
"のみかた 飲み方"
"のみくい 呑み喰い 飲み喰い 飲み食い"
"のみくち 飲口 飲み口"
"のみぐすり 飲薬 飲み薬"
"のみぐち 呑口"
"のみこうい 呑行為 呑み行為"
"のみこみ 飲み込み"
"のみごこち 飲み心地"
"のみごたえ 飲み応え"
"のみごろ 飲み頃"
"のみしろ 呑み代 飲み代"
"のみすぎ 飲み過ぎ"
"のみすけ 飲助 呑助 飲み助 呑み助"
"のみず 野水"
"のみだい 飲み代"
"のみち 野道"
"のみっぷり 飲みっ振り"
"のみて 飲み手"
"のみで 飲み出"
"のみともだち 飲み友達"
"のみなかま 飲み仲間"
"のみにげ 飲み逃げ"
"のみのいち 蚤の市"
"のみほうだい 飲み放題"
"のみみず 飲み水"
"のみもの 飲物 飲み物"
"のみや 飮み屋 呑屋 野宮 呑み屋 飲み屋"
"のみやま 野見山"
"のみりょう 飲み料"
"のむぎ 野麦"
"のむら 乃村 野村"
"のも 野茂"
"のもざき 野母崎"
"のもと 野本"
"のもり 野守"
"のやき 野焼"
"のやま 野山"
"のら 野良"
"のらいぬ 野良犬"
"のらくらもの のらくら者"
"のらねこ のら猫 ノラ猫 野良猫"
"のり 孔 朔 悳 弼 規範 宜 伯 昇 就 哲 雅 憲 徳 紀 規 教 矩 範 則 典 乗り 法 糊 海苔"
"のりあい 乗り合い 乗合"
"のりあき 徳晶 規昭 功晶 倫明 法明 憲章 範明 紀昭 則明 典昭 典明 紀明 憲明"
"のりいれ 乗入 乗入れ"
"のりいれがみ 糊入紙"
"のりえ 礼江 法枝"
"のりお 昇男 則郎 展男 徳雄 典男 典生 憲雄 憲生 範夫 紀男 憲夫 典夫 則夫 紀夫"
"のりおり 乗り降り"
"のりかえ 乗替え 乗換 乗換え 乗り換え"
"のりかず 則和 紀和"
"のりき 乗り気"
"のりくみいん 乗組員"
"のりくら 乗鞍"
"のりこ 祈子 能理子 訓子 賀子 教子 徳子 規子 乃梨子 則子 倫子 範子 のり子 法子 紀子 典子"
"のりこし 乗り越し 乗越"
"のりごこち 乗心地"
"のりざね 徳実"
"のりしげ 則茂"
"のりしろ 糊代"
"のりたか 則貴 範高 典孝"
"のりたけ 則竹 憲武"
"のりちか 乃親"
"のりつぎ 乗継 乗り継ぎ"
"のりづき 法月"
"のりづけ 糊付 糊付け"
"のりづら 法面"
"のりと 祝詞"
"のりにげ 乗逃げ"
"のりのつかさ 式部省"
"のりのみや 紀宮"
"のりば 乗場"
"のりひこ 規彦 憲彦 紀彦"
"のりひさ 典尚 哲久 則久 範久 典久"
"のりひと 徳仁"
"のりひろ 則浩 紀大 典大 憲広"
"のりふみ 憲文"
"のりほ 範穂"
"のりまき 則巻 海苔巻"
"のりまさ 紀政 典正"
"のりまつ 乗松"
"のりむね 倫宗"
"のりめん 法面"
"のりもと 紀元"
"のりもの 乗物"
"のりや 紀哉 法也"
"のりやす 典康"
"のりゆき 則征 宜之 矩之 範幸 典行 規行 憲行 哲之 規之 徳幸 紀幸 範行 則行 徳行 敬之 則之 憲之 紀之"
"のりゆみ 賭弓"
"のりゆみのかえりあるじ 賭弓の還り饗"
"のりゆみのかえりだち 賭弓の還り立ち"
"のりゆみのせち 賭弓の節"
"のりよ 記代"
"のりよし 法良 紀吉 徳吉 徳芳"
"のりろう 憲郎"
"のりわく 法枠"
"のるうぇー 諾威"
"のるうぇーご ノルウェー語"
"のるかそるか 伸るか反るか"
"のるまんじん ノルマン人"
"のれん 暖簾"
"のろ 祝女 麕 野呂"
"のろい 詛い 呪い"
"のろけ 惚気"
"のろし 狼烟 烽 燧 烽火 狼煙"
"のろのろ 鈍々"
"のろま 野呂松 鈍間"
"のわき 野分"
"のんき 暢気 のん気 暖気 呑気"
"のんだくれ 飲んだくれ"
"のんべえ 呑兵衛 飲兵衛"
"のんれむすいみん ノンレム睡眠"
"は 張 霸 齒 刄 播 怕 垪 叭 跛 菠 碆 玻 陂 坡 簸 頗 葩 笆 爬 芭 琶 杷 把 巴 羽 端 破 波 派 覇 刃 歯 葉"
"はーぐ 海牙"
"はーとがた ハート形"
"はーどめん ハード面"
"はーばーどだいがく ハーバード大学"
"はあく 把握"
"はあん 破闇"
"はい 埴 這 吠 碚 擺 憊 坏 稗 睥 悖 孛 霈 沛 珮 旆 佩 裴 琲 徘 排 俳 湃 拜 拝 背 配 廢 癈 廃 敗 輩 胚 盃 杯 牌 灰 肺"
"はいあん 廃案"
"はいい 廃位 配意 配位"
"はいいしょく 胚移植"
"はいいろ 灰色"
"はいいろぐま 灰色熊"
"はいいん 排印 配員 敗因"
"はいえい 背泳"
"はいえき 廃駅 排液 廃液"
"はいえつ 拝謁"
"はいえん 廃園 排煙 肺炎"
"はいおく 廃屋"
"はいか 輩下 廃貨 拝火 排架 廃家 配下 配架"
"はいかい 誹諧 俳諧 徘徊"
"はいかつりょう 肺活量"
"はいかでん 廃家電"
"はいかん 廃官 肺患 肺肝 廃艦 廃館 拝観 廃刊 配管"
"はいが 拝賀 俳画 胚芽"
"はいがい 拝外 排外"
"はいがく 廃学"
"はいがす 排ガス"
"はいがた 灰型"
"はいがまい 胚芽米"
"はいがん 肺がん 肺ガン 拝顔 肺癌"
"はいき 拝跪 廃棄 排気"
"はいきがす 排気ガス"
"はいきしゅ 肺気腫"
"はいきのう 肺機能"
"はいきゃく 廃却"
"はいきゅう 廃休 排球 配球 配給"
"はいきゅうちゅう 肺吸虫"
"はいきゅうまい 配給米"
"はいきょ 廃虚 廃墟"
"はいきょう 俳協 背教"
"はいきょく 廃曲 廃局"
"はいきん 拝金 配筋 背筋"
"はいぎょ 肺魚"
"はいぎょう 廃業"
"はいく 俳句"
"はいくつ 背屈"
"はいぐ 拝具"
"はいぐう 配偶"
"はいぐすり 灰釉"
"はいぐん 敗軍"
"はいけい 拝敬 拝啓 背景"
"はいけいこう 背景光"
"はいけいせい 胚形成"
"はいけっかく 肺結核"
"はいけつしょう 敗血症"
"はいけん 佩剣 拝見"
"はいげき 排撃"
"はいこう 背向 廃鉱 廃坑 配光 配向 廃校"
"はいこうじょう 廃工場"
"はいこきゅう 肺呼吸"
"はいご 廃語 背後"
"はいごう 俳号 廃合 配合"
"はいごれい 背後霊"
"はいさ 排砂"
"はいさつ 廃札 拝察"
"はいざい 配剤 廃材"
"はいざら 灰皿"
"はいざん 廃残 廃山 敗残"
"はいし 廃址 稗史 胚子 廃市 敗死 廃止"
"はいしつ 癈疾 廃疾 肺疾"
"はいしゃ 拝謝 背斜 配車 廃車 敗者 歯医者"
"はいしゃく 拝借"
"はいしゅ 胚珠"
"はいしゅつ 輩出 排出"
"はいしょ 肺書 俳書 配所"
"はいしょう 敗将 拝承 廃娼"
"はいしょうき 排障器"
"はいしょく 憊色 敗色 配食 配色"
"はいしん 背進 背信 配信"
"はいしんじゅん 肺浸潤"
"はいじ 拝辞 廃寺"
"はいじく 胚軸"
"はいじつせい 背日性"
"はいじま 拝島"
"はいじゅ 拝受"
"はいじゅくれい 廃塾令"
"はいじゅんかん 肺循環"
"はいじょ 廃除 排除"
"はいじょう 廃城"
"はいじょうみゃく 肺静脈"
"はいじん 拝塵 癈人 配陣 俳人 廃人"
"はいすい 背水 配水 廃水 排水"
"はいすいこう 排水溝"
"はいすいしゅ 肺水腫"
"はいすいのじん 背水乃陣 背水の陣"
"はいせい 廃星 敗勢 俳聖"
"はいせいかんさいぼう 胚性幹細胞"
"はいせいしん 肺性心"
"はいせき 俳席 廃石 排斥"
"はいせつ 排雪 排泄"
"はいせん 敗線 肺尖 配船 廃船 廃線 敗戦 配線"
"はいせんいしょう 肺線維症"
"はいせんしき 廃線敷"
"はいぜつ 廃絶"
"はいぜん 沛然 配膳"
"はいそ 敗訴"
"はいそう 背走 敗走 配送"
"はいそうほう 廃掃法"
"はいそく 背足 背側"
"はいそくせん 肺塞栓"
"はいそん 廃村"
"はいぞう 肺臓"
"はいぞく 配属"
"はいた 歯痛 排他"
"はいたい 佩帯 廃頽 廃退 胚胎 敗退"
"はいたいし 廃太子"
"はいたか 鷂"
"はいたつ 配達"
"はいだ 灰田"
"はいだん 俳壇"
"はいち 背馳 廃置 配置"
"はいちがえ 配置換 配置替え"
"はいちせい 背地性"
"はいちゃく 敗着 廃嫡"
"はいちゅうりつ 排中律"
"はいちょう 拝聴"
"はいちょうきん 腓腸筋"
"はいつう 背痛"
"はいてい 拝呈 廃帝"
"はいていらおゆえ 海底撈月"
"はいてくかぶ ハイテク株"
"はいてん 配転 配点"
"はいでん 拝殿 配電"
"はいでんばこ 配電箱"
"はいと 廃都"
"はいとう 佩刀 配当"
"はいとうたい 配糖体"
"はいとうみつ 廃糖蜜"
"はいとうれい 廃刀令"
"はいとく 悖徳 背徳"
"はいどう 廃道"
"はいどうみゃく 肺動脈"
"はいどく 拝読"
"はいにち 排日"
"はいにゅう 胚乳"
"はいにょう 排尿"
"はいにん 背任"
"はいねこ 灰猫"
"はいねつ 廃熱 排熱"
"はいのう 胚嚢 背嚢 排膿"
"はいのうよう 肺膿瘍"
"はいはい 這い這い"
"はいはん 悖反 背叛 排反 廃藩 背反"
"はいはんちけん 廃藩置県"
"はいばら 生原 榛原"
"はいばん 杯盤 胚盤 廃版 廃番 廃盤"
"はいばんほう 胚盤胞"
"はいぱい 配牌"
"はいひん 廢品 廃品"
"はいび 拝眉 配備"
"はいびょう 肺病"
"はいびん 配便"
"はいふ 肺腑 配賦 配付 配布"
"はいふう 誹風 俳風"
"はいふき 灰吹き 灰吹"
"はいふく 拝伏 拝復"
"はいふん — ‐"
"はいぶ 拝舞 廃部 背部"
"はいぶつ 廃仏 廃物"
"はいぶつきしゃく 排仏毀釈 廃仏棄釈 排仏棄釈 廃仏毀釈"
"はいぶつきょう 拝物教"
"はいぶりっどしゃ ハイブリッド車"
"はいぶん 拝聞 俳文 配分"
"はいへい 敗兵"
"はいべん 排便"
"はいぺすと 肺ペスト"
"はいほう 敗報 肺胞"
"はいほん 配本"
"はいぼう 敗亡"
"はいぼく 敗北"
"はいまつ 這松"
"はいみ 俳味"
"はいみょう 俳名"
"はいめ 敗目"
"はいめい 俳名 拝命"
"はいめつ 廃滅"
"はいめん 背面"
"はいもん 肺門"
"はいや 灰屋 肺野"
"はいやく 背約 配役"
"はいやぶし はいや節"
"はいゆ 廃油"
"はいゆう 俳友 俳優"
"はいよう 佩用 胚葉 肺葉 廃用"
"はいようぎゅう 廃用牛"
"はいらる 海拉爾"
"はいらん 排卵"
"はいり 背離 背理"
"はいりつ 廃立"
"はいりゅう 配流"
"はいりょ 配慮"
"はいりょう 拝領"
"はいる 配流"
"はいれい 拝礼"
"はいれつ 排列 配列"
"はいろ 羽色 廃炉 葉色"
"はいろう 肺労 肺癆"
"はいろん 俳論"
"はいわ 俳話"
"はうすさいばい ハウス栽培"
"はうた 端歌 端唄"
"はうちわ 羽団扇"
"はうら 葉裏"
"はえ 生え 南風 蝿 蠅"
"はえぎわ 生え際"
"はえざ 蠅座 蝿座"
"はえたたき ハエ叩き 蠅叩き"
"はえとり 蝿取り"
"はえなわ 延縄"
"はえばる 南風原"
"はおう 覇王"
"はおうじゅ 覇王樹"
"はおく 破屋"
"はおと 羽音"
"はおり 羽織"
"はおんきごう ハ音記号"
"はか 果 捗 計 量 破瓜 墓"
"はかあな 墓穴"
"はかい 破潰 破戒 破壊"
"はかいし 墓石"
"はかいしん 破壊神"
"はかく 破格"
"はかくね 破格値"
"はかげ 葉影 葉陰"
"はかしょ 墓所"
"はかじるし 墓標"
"はかず 葉数"
"はかせ 博士"
"はかぜ 羽風 葉風"
"はかた 伯方 博多"
"はかたのつ 博多津"
"はかたぶし 博多節"
"はかたみなみ 博多南"
"はかば 墓場"
"はかぶ 端株"
"はかほり 墓掘り"
"はかま 袴"
"はかまいり 墓参り"
"はかますがた 袴姿"
"はかまだ 袴田"
"はかむら 墓村"
"はかもり 墓守"
"はからい 計らい"
"はからずも 図らずも"
"はかり 計り 量り 秤"
"はかりごと 謀"
"はかりざら 秤皿"
"はかりめ 秤目"
"はが 波賀 羽賀 芳賀"
"はがい 羽交い"
"はがいじめ 羽交締め 羽交い絞め 羽交い締め"
"はがえ 羽替え"
"はがき 端書 葉書き 葉書"
"はがくれ 葉隠れ 葉隠"
"はがた 歯形 歯型"
"はがため 歯固め"
"はがね 刃金 鋼"
"はがねいもの 鋼鋳物"
"はがま 歯釜 羽釜"
"はがみ 歯噛み"
"はがわ 羽川"
"はがん 破顔"
"はき 杷木 破毀 覇気 破棄"
"はきくだし 吐き下し"
"はきけ 吐気 嘔気 吐き気"
"はきじはん 破棄自判"
"はきそうじ 掃き掃除"
"はきだし 掃出し 掃き出し"
"はきだしまど 掃き出し窓 掃出し窓"
"はきだめ 掃き溜め"
"はきもの 履物"
"はきゃく 破却"
"はきゅう 波及"
"はきょう 破鏡"
"はきょく 破局"
"はぎ 矧 脛 萩"
"はぎお 萩尾"
"はぎしり 歯軋り"
"はぎた 萩田"
"はぎたに 萩谷"
"はぎの 萩野"
"はぎのつき 萩の月"
"はぎはら 萩原"
"はぎひら 萩平"
"はぎまつり 萩まつり"
"はぎもと 萩本"
"はぎもり 萩森"
"はぎや 萩谷"
"はぎやき 萩焼"
"はぎょう 覇業 は行 ハ行"
"はぎり 歯切り"
"はぎれ 歯切 端切れ 歯切れ"
"はぎわら 萩原"
"はく 栢 膊 璞 蘗 擘 搏 愽 亳 帛 魄 陌 岶 佰 狛 珀 柏 粕 舶 迫 剥 博 薄 伯 泊 白 拍 箔"
"はくあ 白堊 白亜"
"はくあい 博愛"
"はくい 伯井 伯夷 羽咋 白衣"
"はくいすがた 白衣姿"
"はくいのてんし 白衣の天使"
"はくいん 博引"
"はくいんぼうしょう 博引旁証"
"はくう 白雨"
"はくうん 白雲"
"はくうんも 白雲母"
"はくえい 搏景"
"はくえいぐん 白衛軍"
"はくえん 白煙"
"はくえんこう 白鉛鉱"
"はくおう 白鴬 白鴎"
"はくおし 箔押し"
"はくかい 擘開"
"はくが 博雅"
"はくがい 迫害"
"はくがく 博学"
"はくがん 白眼"
"はくきょい 白居易"
"はくぎ 博儀"
"はくぎょ 白魚"
"はくぎん 白銀"
"はくぐう 薄遇"
"はくぐん 白軍"
"はくげい 白鯨"
"はくげき 搏撃 迫撃"
"はくげんがく 博言学"
"はくごうしゅぎ 白豪主義"
"はくさ 白砂"
"はくさい 舶載 白菜"
"はくさん 白山"
"はくし 搏摯 薄志 白紙 博士"
"はくしき 博識"
"はくしつ 白質"
"はくしま 白島"
"はくしゃ 白砂 薄謝 拍車"
"はくしゃく 伯爵"
"はくしゃせいしょう 白砂青松"
"はくしゅ 拍手"
"はくしゅう 伯州 白秋"
"はくしょ 薄暑 帛書 白書"
"はくしょく 白色"
"はくしょくこう 白色光"
"はくしょくてろ 白色テロ"
"はくしん 白新 迫真"
"はくじ 白字 白磁"
"はくじつ 白日"
"はくじつむ 白日夢"
"はくじゃ 白蛇"
"はくじゃく 薄弱"
"はくじゅ 白寿"
"はくじょう 白杖 薄情 白状"
"はくじん 白刃 白人"
"はくすい 白水"
"はくすう 搏数 拍数 泊数"
"はくすきのえ 白村江"
"はくず 白図"
"はくせい 剥製"
"はくせき 白皙 白石"
"はくせつ 拍節 白雪"
"はくせん 搏戦 白銑 白戦 白扇 白癬 白線"
"はくせんしゃ 薄銭社 白泉社"
"はくぜん 白髯"
"はくそ 歯屎"
"はくそう 薄葬 博捜"
"はくそんこう 白村江"
"はくた 伯太"
"はくたん 白炭"
"はくだい 博大"
"はくだく 白濁"
"はくだつ 剥脱 はく奪 剥奪"
"はくだん 白檀"
"はくち 白雉 泊地 白痴 白地"
"はくちゅう 伯仲 白昼"
"はくちゅうこう 白昼光"
"はくちゅうむ 白昼夢"
"はくちょう 白丁 白鳥"
"はくちょうこ 白鳥湖"
"はくちょうのうた 白鳥の歌"
"はくちょうのみずうみ 白鳥の湖"
"はくつる 白鶴"
"はくてい 白丁"
"はくてん 白点"
"はくでい 白泥"
"はくとう 搏闘 白糖 白頭 白湯 白桃"
"はくとうゆ 白灯油"
"はくど 白土"
"はくどう 搏動 白道 白銅 拍動"
"はくどうか 白銅貨"
"はくないしょう 白内障"
"はくねつ 白熱"
"はくねつこう 白熱光"
"はくはく 白々"
"はくはつ 白髪"
"はくはつちゅん 白發中"
"はくはん 白斑 白飯"
"はくば 白馬"
"はくばい 白梅"
"はくばん 白板 薄板"
"はくひょう 白票 薄氷"
"はくひんかんげきじょう 博品館劇場"
"はくび 白眉"
"はくびしん 白鼻心"
"はくびせん 伯備線"
"はくびょう 白描"
"はくふ 帛布 伯父 白布"
"はくふん 白粉"
"はくぶつ 博物"
"はくぶついん 博物院"
"はくぶん 博聞 白文 博文"
"はくぶんやくれい 博文約礼"
"はくへい 白兵"
"はくへき 薄壁 白壁"
"はくへん 剥片 薄片"
"はくほう 白鳳"
"はくほうどう 博報堂"
"はくぼ 薄暮"
"はくぼく 白墨"
"はくま 白魔"
"はくまい 白米"
"はくまく 白膜 薄膜"
"はくめ 拍目"
"はくめい 薄明 薄命"
"はくめん 白面"
"はくめんか 薄面化"
"はくや 箔屋 白夜"
"はくゆん 学胤"
"はくよう 伯洋 白楊"
"はくようきゅう 白羊宮"
"はくようけん 伯養軒"
"はくようしゃ 白洋舎 白揚社"
"はくらい 舶来"
"はくらく 白楽 伯楽 剥落"
"はくらくてん 白楽天"
"はくらん 白藍 博覧"
"はくり 白痢 薄利 剥離"
"はくりき 薄力"
"はくりきこ 薄力粉"
"はくりゅう 白竜 白龍"
"はくりょく 迫力"
"はくれんが 白煉瓦"
"はくろ 白鷺 白露"
"はくろう 伯労 白蝋"
"はくろく 白鹿"
"はくろしあ 白ロシア"
"はくろん 博論"
"はくわ 白話"
"はぐ 爬具"
"はぐき 齦 歯ぐき 歯茎"
"はぐち 刃口"
"はぐま 白熊"
"はぐるま 歯車"
"はぐれぐも 浮浪雲"
"はぐろ 歯黒 羽黒"
"はぐんせい 破軍星"
"はけ 捌け 刷毛"
"はけい 波形"
"はけぐち はけ口"
"はけん 覇権 派遣"
"はげ 破夏 剥げ 禿"
"はげあたま ハゲ頭 禿頭"
"はげいとう 葉鶏頭"
"はげたか 禿鷹"
"はげまし 励まし"
"はげみ 励み"
"はげやま 禿山"
"はげわし 禿鷲"
"はげん 波源"
"はこ 運 □ 葉子 凾 箪 筥 筐 匣 函 箱"
"はこいり 箱入 箱入り"
"はこいりむすめ 箱入り娘"
"はこう 爬行 破口 跛行 波高"
"はこえ 箱絵"
"はこかなもの 箱金物"
"はこがい 箱買い"
"はこがき 箱書 箱書き"
"はこがた 箱型"
"はこがまえ 匚構え"
"はこさきぐう 筥崎宮"
"はこざき 筥崎 箱崎"
"はこした 箱下"
"はこじゃく 箱尺"
"はこだい 箱代"
"はこだて 函館"
"はこだてせんそう 箱館戦争"
"はこだてどっく 函館ドック"
"はこづけ 箱付"
"はこづめ 箱詰 箱詰め"
"はこにわ 箱庭"
"はこね 箱根"
"はこねはちり 箱根八里"
"はこはんぶん 箱半分"
"はこばしゃ 箱馬車"
"はこひだ 箱襞"
"はこび 運び"
"はこぶね 方船 箱船 方舟 箱舟"
"はこべ 繁縷"
"はこぼれ 刃こぼれ 刃毀れ"
"はこまつ 筥松"
"はこめがね 箱眼鏡"
"はこもの 箱物"
"はこもり 箱守"
"はこや 箱屋"
"はこん 破婚"
"はご 羽子"
"はごいた 羽子板"
"はごく 破獄"
"はごし 葉越し"
"はごたえ 歯応え"
"はごろも 羽衣"
"はさい 破摧 破砕"
"はさき 刃先 波崎"
"はさこ 羽迫"
"はさつおん 破擦音"
"はさま 挟間 迫"
"はさみ 波佐見 螯 鋏"
"はさみあげ はさみ揚げ 挟み揚げ"
"はさみうち 挾み打ち 挾み撃ち 挟み打ち 挟み撃ち"
"はさみしょうぎ 挟み将棋"
"はさみつけ 挾み付け"
"はさん 破算 破産"
"はざい 端材"
"はざかい 端境"
"はざくら 葉桜"
"はざし 葉挿し"
"はざま 陌間 羽間 羽佐間 硲 狭間 間"
"はざまぐみ 間組"
"はざわ 羽沢"
"はざわり 歯触り"
"はし 走 枦 觜 梯 箸 端 橋"
"はしい 端居"
"はしいた 橋板"
"はしうら 橋浦"
"はしお 走尾"
"はしおか 橋岡"
"はしおき 箸置き"
"はしか 麻疹"
"はしかみ 階上"
"はしかわ 橋川"
"はしがかり 橋懸かり 橋懸り 橋掛り 橋掛かり"
"はしがき 端書き 端書"
"はしがみ 橋上"
"はしくら 橋倉"
"はしくれ 端くれ"
"はしぐち 橋口"
"はしけ 艀"
"はしげた 橋げた 橋桁"
"はしご 梯 階子 梯子"
"はしござけ はしご酒"
"はしごしゃ はしご車"
"はしずめ 橋爪"
"はしぞめ 箸初め"
"はした 端た 端"
"はしたいろ 端色"
"はしたか 鷂"
"はしたがね 端た金 端金"
"はしたて 箸立て"
"はしたに 橋谷"
"はしため 端た女 端女 婢女 婢"
"はしだ 橋田"
"はしだて 橋立"
"はしっこ 端っこ"
"はしづめ 橋詰め 橋詰 橋爪"
"はしの 橋野"
"はしのすけ 橋之助"
"はしば 羽柴"
"はしばこ 箸箱"
"はしばし 端端 端々"
"はしばみ 榛"
"はしばん 橋番"
"はしひめ 橋姫"
"はしぶとがらす 嘴太鴉"
"はしぶね 端舟"
"はしべんけい 橋弁慶"
"はしぼそがらす 嘴細鴉"
"はしま 羽島"
"はしもと 橋本"
"はしもり 橋守"
"はしゃ 覇者"
"はしやすめ 箸休め"
"はしゅ 把手 播種"
"はしゅつ 派出"
"はしゅつふ 派出婦"
"はしょうが 葉生薑 葉生姜"
"はしょうふう 破傷風"
"はしょく 波食"
"はしら 柱"
"はしらごよみ 柱暦"
"はしらざい 柱材"
"はしらたに 柱谷"
"はしらどけい 柱時計"
"はしらま 柱間"
"はしらわり 柱割り 柱割"
"はしり 走り"
"はしりい 走井"
"はしりどころ 走野老"
"はしわたし 橋渡し"
"はじ 初 始 黄櫨 耻 土師 把持 端 恥"
"はじかみ 薑 椒"
"はじかみいお 椒魚"
"はじさらし 恥曝し"
"はじしらず 恥知らず"
"はじとみ 半蔀"
"はじま 羽島"
"はじまり 始まり"
"はじめ 壹 弌 甫 馨 哉 壱 肇 創 始 初 元 一 初め 始め"
"はじめて 初めて"
"はじめね 始め値 始値"
"はじめまして 始めまして 初めまして"
"はじゃ 破邪 覇者"
"はじょ 葉序"
"はじょう 波状"
"はじょううん 波状雲"
"はじらい 羞じらい"
"はじろ 羽白"
"はす 斜 蓮"
"はすい 破水"
"はすいけ 蓮池"
"はすいも 蓮芋 白芋"
"はすう 歯数 羽数 波数 端数"
"はすか ハス科"
"はすかい 斜交い"
"はすきーけん ハスキー犬"
"はすこ 蓮子"
"はすだ 蓮田"
"はすっぱ 蓮っ葉 蓮葉"
"はすぬま 蓮沼"
"はすね 蓮根"
"はすのはぎりか ハスノハギリ科"
"はすのみ 蓮の実"
"はすみ 羽純 羽角 羽須美 蓮實 蓮見"
"はすむかい 斜向い はす向かい 斜向かい"
"はず 巴豆 弭 筈"
"はずい 筈井"
"はずえ 葉末"
"はずかしめ 辱め"
"はずまき 弭巻 筈巻"
"はずみぐるま 弾み車"
"はずれ 外 葉擦れ 外れ"
"はせ 馳 長谷"
"はせい 長谷井 派生"
"はせくら 支倉"
"はせみ 長谷見"
"はせん 破船 波線 破線"
"はぜ 沙魚 蝦虎魚 枦 黄櫨 鯊 櫨"
"はぜのき 黄櫨 櫨 櫨の木"
"はそく 把捉 波束"
"はそん 破損"
"はた 旌 幟 旙 旛 籏 波田 波多 幡多 羽田 秦 将 幡 圃 畠 畑 機 側 端 傍 旗"
"はたあげ 旗揚 旗揚げ"
"はたい 波帯"
"はたいけ 幡池"
"はたいも 畑芋"
"はたいろ 旗色"
"はたうえ 畑上"
"はたうち 畑打ち"
"はたえ 二十重 波多江"
"はたおか 畑岡"
"はたおり 旗折 機織 機織り"
"はたがしら 旗頭"
"はたがや 幡ヶ谷"
"はたきこみ 叩き込み"
"はたぎょうれつ 旗行列"
"はたぐも 旗雲"
"はたけ 疥 畠 畑"
"はたけいも 畑芋"
"はたけしごと 畑仕事"
"はたけちがい 畑違い"
"はたけなか 畠中"
"はたけやま 畑山 畠山"
"はたご 旅籠"
"はたさ 畑佐"
"はたさく 畑作"
"はたさしもの 旗指物"
"はたざお 旗竿"
"はたざき 畑崎"
"はたしあい 果し合い 果たし合い"
"はたしじょう 果し状 果たし状"
"はたした 旗下"
"はたして 果して 果たして"
"はたしょう 秦荘"
"はたじるし 旗標 旗印"
"はたたて 旗立"
"はただ 畠田 畑田"
"はたち 廿 ２０歳 二十歳 畑地 二十"
"はたて 旗手"
"はたとせ 二十歳"
"はたなか 畑仲 畠中 畑中"
"はたの 籏野 羽田野 幡野 秦野 畑野 波多野"
"はたのう 畑農"
"はたのだい 旗の台"
"はたはた 鰰"
"はたば 機場"
"はたばこ 葉たばこ 葉煙草 葉タバコ"
"はたび 旗日"
"はたふり 旗振り"
"はたぶ 幡生"
"はたむら 畑村"
"はため はた目 傍目"
"はためいわく 傍迷惑"
"はたもち 旗持"
"はたもと 播本 畑本 旗本"
"はたもとやっこ 旗本奴"
"はたや 畑谷 機屋"
"はたやま 畠山 畑山"
"はたら 働"
"はたらき 働き"
"はたらきあり 働き蟻"
"はたらきかけ 働き掛け"
"はたらきばち 働き蜂"
"はたん 破綻"
"はたんきょう 巴旦杏"
"はたんちょう ハ短調"
"はだ 羽田 膚 肌"
"はだあい 肌合 肌合い"
"はだあれ 膚荒れ 肌荒 肌あれ 肌荒れ"
"はだいろ 肌色"
"はだか 裸"
"はだかいっかん 裸一貫"
"はだかうま 裸馬"
"はだかおどり 裸踊り"
"はだかぎ 裸木"
"はだかけ 肌掛け"
"はだかそうば 裸相場"
"はだかてがた 裸手形"
"はだかでんきゅう 裸電球"
"はだかび 裸火"
"はだかまつり 裸祭 裸祭り"
"はだかみ 裸身"
"はだかむぎ 裸麦"
"はだかやま 裸山"
"はだかんぼう 裸ん坊"
"はだぎ 肌着"
"はださむ 肌寒"
"はだざわり 膚触り 肌触り"
"はだし 跣 裸足"
"はだしつ 肌質"
"はだじゅばん 肌襦袢"
"はだつけ 肌付け"
"はだの 秦野"
"はだぶとん 肌布団"
"はだみ 肌身"
"はだん 破談 破断"
"はち 椀 捌 ８ 蜂 八 鉢"
"はちあげ 鉢上げ"
"はちあわせ 鉢合せ 鉢合わせ"
"はちうえ 鉢植 鉢植え"
"はちかい 八開"
"はちがつ 葉月 ８月 八月"
"はちく 淡竹 破竹"
"はちけん 八軒"
"はちこう ハチ公"
"はちざかな 鉢肴"
"はちしょうじん 八将神"
"はちじ 八時"
"はちじゅう 八十"
"はちじゅうはっかしょ 八十八箇所"
"はちじょう 鉢状 八丈 八条"
"はちす 蓮 蜂巣"
"はちすか 蜂須賀"
"はちぞこ 鉢底"
"はちだいしゅう 八代集"
"はちだいじごく 八大地獄"
"はちど 八度"
"はちにん 八人"
"はちねん 八年"
"はちのこ 蜂の子"
"はちのじ 八の字"
"はちのす 蜂の巣"
"はちのへ 八戸"
"はちのへこうだいいち 八戸工大一"
"はちはちかんたい 八八艦隊"
"はちばん 八番"
"はちぶ ８分 八部 八分"
"はちぶおんぷ ♪"
"はちぶせやま 鉢伏山"
"はちほん 八本"
"はちほんまつ 八本松"
"はちぼく 八木"
"はちまい 八枚"
"はちまき 鉢巻き 鉢巻"
"はちまん 八万 八幡"
"はちまんたい 八幡平"
"はちまんづくり 八幡造"
"はちみつ 蜂蜜"
"はちみり 八ミリ"
"はちめん 八面"
"はちめんろっぴ 八面六臂"
"はちもの 鉢物"
"はちもり 八森"
"はちゃ 葉茶"
"はちや 鉢谷 八谷 蜂屋"
"はちゅう 爬虫"
"はちゅうるい 爬蟲類"
"はちょう 破調 ハ調 刃長 波長"
"はちょうちょう ハ長調"
"はちりゅう 八竜"
"はちろ 八路"
"はちろう 八郎"
"はちろうがた 八郎潟"
"はちわり 八割"
"はぢゃ 葉茶"
"はっ 發 法 発"
"はっか 客家 白化 薄荷 発火"
"はっかい 白海 八戒 発会"
"はっかいさん 八海山"
"はっかく 八角 発覚"
"はっかけ 歯っ欠け 八掛"
"はっかん 発艦 発汗 発刊"
"はっき 発輝 白旗 発起 発揮"
"はっきゅう 薄給 白球 発給"
"はっきょう 発狂"
"はっきん 白筋 白金 発禁"
"はっく 八九 発句 八苦"
"はっくつ 発掘"
"はっけ 八卦"
"はっけい 発勁 八景"
"はっけっきゅう 白血球"
"はっけつびょう 白血病"
"はっけみ 八卦見"
"はっけん 発遣 白鍵 発券 発見"
"はっけんでん 八犬伝"
"はっこ 発呼"
"はっこう 薄倖 発向 八講 発航 八紘 白光 薄幸 醗酵 発効 発光 発酵 発行"
"はっこうせん 八高線"
"はっこうだ 八甲田"
"はっこうだいおーど 発光ダイオード"
"はっこつ 白骨"
"はっこん 発根"
"はっさい 八歳 髪際"
"はっさく 八朔"
"はっさむ 発寒"
"はっさん 発散"
"はっしゃ 発車 発射"
"はっしゅう 八宗"
"はっしゅち ハッシュ値"
"はっしゅつ 発出"
"はっしゅひょう ハッシュ表"
"はっしょう 発消 八省 八章 発症 発祥"
"はっしょういも 八升芋"
"はっしょういん 八省院"
"はっしょうじん 八将神"
"はっしょうどう 八正道"
"はっしょく 発色"
"はっしん 発震 八神 発振 発疹 発進 発信"
"はっすい 撥水"
"はっすん 八寸"
"はっすんくぎ 八寸釘"
"はっせい 八世 発声 発生"
"はっせき 発赤"
"はっせん 八千 八仙"
"はっそう 八双 八相 発走 発想 発送"
"はっそく 八足 発足"
"はった 八田"
"はったい 八体"
"はったつ 八達 発達"
"はったん 八丹 八反 発端"
"はったんだ 八反田"
"はったんにしき 八反錦"
"はっちゃく 発着"
"はっちゃくしん 発着信"
"はっちゅう 八中 発注"
"はっちょう 八丁"
"はっちょうぼり 八丁堀"
"はってん 発展"
"はってんば ハッテン場"
"はっと 法度"
"はっとう 八東 法堂"
"はっとうしん 八等身 八頭身"
"はっとがき 法度書"
"はっとく 八徳"
"はっとり 服部"
"はっとりせいこー 服部セイコー"
"はっぱ 発破 葉っぱ"
"はっぱく 八白"
"はっぴ 半被 法被"
"はっぴき 八匹"
"はっぴゃく 八百"
"はっぴゃくやちょう 八百八町"
"はっぴょう 発表"
"はっぷ 髪膚 発布"
"はっぷん 発憤 発奮"
"はっぺい 八平"
"はっぽう 発疱 発砲 八方 発泡"
"はっぽうえん 八芳園"
"はっぽうさい 八宝菜"
"はっぽうすちろーる 発泡スチロール"
"はっぽうふさがり 八方塞がり"
"はっぽうやぶれ 八方破れ"
"はつ 髮 捌 釟 秡 癶 撥 溌 醗 鉢 髪 發 発 初"
"はつあわせ 初袷"
"はつあん 発案"
"はつい 発意"
"はついく 発育"
"はついし 初石"
"はついち 初市"
"はつうま 初午"
"はつうり 初売"
"はつえ 初絵 初江"
"はつえき 発駅"
"はつえん 発煙"
"はつえんとう 発炎筒 発煙筒"
"はつお 初男 初穂"
"はつおもて 初表"
"はつおり 初折"
"はつおん 撥音 発音"
"はつか ２０日 廿日 二十日"
"はつかがみ 初鏡"
"はつかぜ 初風"
"はつかねずみ 二十日鼠"
"はつかり 初雁"
"はつかん 発艦"
"はつが 発芽"
"はつがお 初顔"
"はつがしら 発頭"
"はつがすみ 初霞"
"はつがつお 初松魚 初鰹"
"はつがま 初釜"
"はつがまい 発芽米"
"はつがり 初狩"
"はつがん 発がん 発ガン 発癌"
"はつがんらん 発眼卵"
"はつぎ 発議"
"はつくに 初国 肇国"
"はつげん 撥弦 発源 発現 発言"
"はつこい 初恋"
"はつご 初子 発語"
"はつごおり 初氷"
"はつさわ 初沢"
"はつざくら 初桜"
"はつざん 初産"
"はつしば 初芝"
"はつしま 初島"
"はつしも 初霜"
"はつしん 発進"
"はつじこく 発時刻"
"はつじも 初霜"
"はつじょう 発条 発情"
"はつすべり 初滑り"
"はつずり 初刷"
"はつせき 初席"
"はつぜっく 初節句"
"はつぜみ 初蝉"
"はつた 初田"
"はつたけ 初茸"
"はつだ 発兌"
"はつだい 発題 初台"
"はつつき 初月"
"はつづき 初月"
"はつづり 初釣"
"はつで 初出"
"はつでーと 初デート"
"はつでん 発電"
"はつでんぎょ 発電魚"
"はつとみ 初富"
"はつどう 発動"
"はつなつ 初夏"
"はつに 初荷"
"はつね 初値 初音"
"はつねつ 發熱 発熱"
"はつはな 初花"
"はつはる 初春"
"はつばい 発売"
"はつばいづき 発売月"
"はつひ 初日"
"はつびょう 発病"
"はつふゆ 初冬"
"はつほ 初穂"
"はつほん 発本"
"はつぼく 発墨"
"はつぼし 初星"
"はつぼん 初盆"
"はつまいり 初参り"
"はつまご 初孫"
"はつみ 初実 初見"
"はつみせ 初店"
"はつみみ 初耳"
"はつめい 発明"
"はつもう 発毛"
"はつもうで 初詣"
"はつもの 初物"
"はつものぐい 初物食い"
"はつもん 発問"
"はつやま 初山"
"はつゆ 初湯"
"はつゆき 初雪"
"はつゆめ 初夢"
"はつよう 発揚"
"はつらつ 溌溂 溌剌"
"はつらん 撥乱"
"はつらんはんせい 撥乱反正"
"はつれい 発令"
"はつれん 発輦"
"はつろ 発露"
"はつわ 発話"
"はつわらい 初笑"
"はづき 葉月"
"はづくろい 羽繕い"
"はづな 端綱"
"はて 果て"
"はてい 破堤"
"はてし 果てし"
"はてな ？"
"はてんこう 破天荒"
"はで 破手 端手 派手"
"はと 鴿 鳩"
"はとう 坡塘 陂塘 坡頭 波涛 波濤 波頭"
"はとがや 鳩谷 鳩ヶ谷"
"はとこ 再従姉妹 再従兄弟"
"はとごや 鳩小屋"
"はとざ 鳩座"
"はとどけい 鳩時計"
"はとの 鳩野"
"はとは ハト派 鳩派"
"はとば 波止場"
"はとばいろ 鳩羽色"
"はとばねずみ 鳩羽鼠"
"はとぶえ 鳩笛"
"はとまぶし 鳩間節"
"はとむぎ 鳩麦"
"はとむね 鳩胸"
"はとめ 鳩目"
"はともと 波戸元"
"はとやま 鳩山"
"はとり 羽鳥"
"はとりべ 服部"
"はとろんし ハトロン紙"
"はどう 波導 覇道 波動"
"はどめ 歯止 歯止め"
"はどり 羽鳥"
"はな 離 塙 纏頭 洟 端 華 鼻 花"
"はなあさぎ 花浅葱"
"はなあらし 鼻嵐"
"はない 花井"
"はないき 鼻息"
"はないくさ 花軍"
"はないけ 花活け 花生け"
"はないずみ 花泉"
"はないた 花板"
"はないち 花市"
"はないちもんめ 花一匁"
"はないれ 花入れ"
"はないろ 花色"
"はなうた 鼻唄 鼻歌"
"はなうらない 花占い"
"はなうり 花売り"
"はなうりむすめ 花売娘"
"はなえ 花江 英恵"
"はなお 鼻緒"
"はなおか 華岡 花岡"
"はなおかせいしゅう 華岡青洲"
"はなかい 花会"
"はなかくし 鼻隠し"
"はなかげ 花陰"
"はなかご 花籠"
"はなかざり 花飾り"
"はなかぜ 鼻カゼ 鼻風邪"
"はなかつら 花鬘"
"はなから 端から"
"はなが 花香"
"はながき 花垣"
"はながさ 花笠"
"はながしら 鼻頭"
"はながすみ 花霞"
"はながた 鼻型 花型 花形"
"はながつお 花鰹"
"はながみ 花紙 鼻紙"
"はながめ 花瓶"
"はながら 花殻 花柄"
"はなき 花紀 花木"
"はなきゃべつ 花キャベツ"
"はなきん 花金"
"はなぎ 鼻木"
"はなぎれ 花布"
"はなくそ 鼻屎 鼻クソ 鼻くそ 鼻糞"
"はなくま 花隈"
"はなぐすり 鼻薬"
"はなぐみ 花組"
"はなぐもり 花曇 花曇り"
"はなげ 鼻毛"
"はなこ 華子 花子"
"はなこうぼう 花工房"
"はなことば 花言葉"
"はなごえ 鼻声"
"はなごおり 花氷"
"はなごころ 花心"
"はなごよみ 花暦"
"はなさ 鼻差"
"はなさか 花阪"
"はなさかじじい 花咲爺"
"はなさき 花咲 鼻先"
"はなさきがに 花咲蟹"
"はなざかり 花盛り"
"はなざくら 花桜"
"はなざけ 花酒"
"はなざわ 花沢"
"はなし 話し 譚 咄 噺 話"
"はなしあい 話合 話合い 話し合い"
"はなしあいて 話相手"
"はなしいぜん 話以前"
"はなしか 噺家"
"はなしがい 放し飼い"
"はなしことば 話言葉"
"はなしじたい 話自体"
"はなしじょうず 話上手"
"はなしずき 話好き"
"はなしちゅう 話中"
"はなしてき 話的"
"はなしのたね 話の種"
"はなしはんぶん 話半分"
"はなしべ 花蕊"
"はなしべた 話下手"
"はなしぼん 噺本 咄本"
"はなしま 花島"
"はなしゅくしゃ 花縮砂"
"はなしょうぶ 花菖蒲"
"はなしんじゅ 花真珠"
"はなじ 衂 衄 鼻血"
"はなじる 洟 鼻汁"
"はなじるし 花印"
"はなじろ 鼻白"
"はなすじ 鼻梁 鼻筋"
"はなすすき 花薄"
"はなずもう 花相撲"
"はなずら 鼻面"
"はなせ 花背"
"はなせん 鼻栓"
"はなせんじょう 鼻洗浄"
"はなぞの 華園 花園"
"はなぞめ 花染"
"はなた 花田"
"はなたか 花高"
"はなたかだか 鼻高々"
"はなたけ 鼻茸"
"はなたちばな 花橘"
"はなたて 花立て"
"はなたに 花谷"
"はなたば 花束"
"はなたれ 洟垂れ"
"はなだ 花田 縹"
"はなだい 花代"
"はなだいろ 縹色"
"はなだきよてる 花田清輝"
"はなだより 花便り"
"はなちゃ 花茶"
"はなちょうちん 鼻提灯"
"はなちるさと 花散里"
"はなぢ 鼻血"
"はなっつら 鼻っ面"
"はなっぱし 鼻っぱし"
"はなっぱしら 鼻っ柱"
"はなつまみ 鼻摘 鼻つまみ 鼻摘まみ"
"はなつみ 花摘み"
"はなづつ 花筒"
"はなづな 鼻綱 花綵"
"はなづまり 鼻詰り 鼻詰まり"
"はなづら 鼻面"
"はなてん 放出"
"はなでんしゃ 花電車"
"はなどき 花時"
"はなどけい 花時計"
"はなにら 花韮"
"はなぬすびと 花盗人"
"はなの 花野"
"はなのいろ 花の色"
"はなのえん 花宴"
"はなのき 花の木"
"はなのさ 鼻の差"
"はなのさき 鼻の先"
"はなのした 鼻の下"
"はなのまき 花巻"
"はなのみやこ 花の都"
"はなのもと 花の本 花の下"
"はなはく 花博"
"はなはた 花畑"
"はなはだ 甚 甚だ"
"はなばさみ 花鋏"
"はなばしら 鼻柱"
"はなばたけ 花畑"
"はなばち 花蜂"
"はなばな 花花 華華 花々"
"はなばんか 花挽歌"
"はなひゃっけい 花百景"
"はなび 煙火 花火"
"はなびえ 花冷 花冷え"
"はなびし 花菱"
"はなびだま 花火玉"
"はなびら 花びら 花弁"
"はなふさ 花房"
"はなふだ 花札"
"はなふぶき 花吹雪"
"はなぶえ 鼻笛"
"はなぶさ 蕚 萼 英 花房"
"はなぺちゃ 鼻ペチャ 鼻ぺちゃ"
"はなまがり 鼻曲り"
"はなまき 花巻"
"はなまち 花街"
"はなまつり 花祭 花祭り"
"はなまめ 花豆"
"はなまる 花丸"
"はなみ 歯並み 羽並 歯並 花実 花見"
"はなみず 洟 花水 鼻水"
"はなみずき 花水木"
"はなみぞ 鼻溝"
"はなみち 花道"
"はなみづき 花見月"
"はなみどう 花御堂"
"はなみね 鼻梁"
"はなみょうが 花茗荷"
"はなむけ 贐 餞"
"はなむこ 花婿"
"はなむすび 花結び"
"はなむら 花村"
"はなめ 花芽"
"はなめがね 鼻眼鏡"
"はなもじ 花文字"
"はなもち 花餅 鼻持ち 花持ち"
"はなもと 花本"
"はなもの 花物"
"はなもよう 花模様"
"はなもり 花守 花森"
"はなや 花屋"
"はなやか 花やか 華やか"
"はなやぎ 花柳"
"はなやしき 花屋敷"
"はなやなぎ 花柳"
"はなやま 花山"
"はなよめ 花嫁"
"はなよめすがた 花嫁姿"
"はならび 歯並び"
"はなれ 放れ 離れ"
"はなれや 離れ家"
"はなれわざ 離れ業"
"はなわ 鼻輪 花環 塙 花輪"
"はなわほきいち 塙保己一"
"はに 羽仁 埴"
"はにうだ 羽生田"
"はにおか 埴岡"
"はにかみや はにかみ屋"
"はにかむこうぞう ハニカム構造"
"はにしな 埴科"
"はにゅう 埴生 羽生"
"はにゅうだ 羽生田"
"はにゅうのやど 埴生の宿"
"はにわ 埴輪"
"はにわり 半月"
"はぬけ 歯抜け"
"はね 撥ね 跳ね 翅 羽根 羽"
"はねいし 羽石"
"はねおか 羽丘"
"はねぎ 葉ネギ 葉葱 羽根木"
"はねぐるま 羽根車"
"はねごし 跳ね腰"
"はねじ 羽地"
"はねだ 羽田"
"はねっかえり 跳ねっ返り"
"はねぶとん 羽布団"
"はねまくら 羽根枕"
"はねまん ハネ満 跳満"
"はねむし 羽虫"
"はねもの 羽物"
"はの 羽野"
"はのうら 羽ノ浦"
"はのね 歯の根"
"はは 義母 母"
"ははいぬ 母犬"
"ははうえ 母上"
"ははおや 母親"
"ははかた 母方"
"ははきぎ 帚木"
"ははきぐさ 帚草"
"ははきぼし 帚星"
"ははぎみ 母君"
"ははこ 母娘 母子"
"ははこぐさ 母子草"
"ははご 母御"
"ははじま 母島"
"ははじゃ 母者"
"ははそ 柞"
"ははねこ 母猫"
"ははのひ 母の日"
"ははびと 母人"
"はば 掵 巾 幅"
"はばうえ 巾上"
"はばき 幅木"
"はばきき 幅利き"
"はばたき 羽搏き 羽撃き"
"はばつ 派閥"
"はばとび 幅跳 幅跳び"
"はばのり 幅海苔"
"はばひろ 巾広 幅広"
"はばびろ 幅広"
"はばゆうせん 幅優先"
"はばよせ 幅寄せ"
"はびきの 羽曳野"
"はふ 破風"
"はふり 祝"
"はふりべ 祝部"
"はぶ 飯匙倩 波布 埴生 羽生 土生"
"はぶくうこう ハブ空港"
"はぶそう 波布草"
"はぶたえ 羽二重"
"はぶたえもち 羽二重餅"
"はぶらし 歯ブラシ"
"はぶり 葉振り 羽振り"
"はぷすぶるくけ ハプスブルク家"
"はへい 派兵"
"はへん 歯偏 破片"
"はほろ 羽幌"
"はほん 端本"
"はぼう 破帽"
"はぼうほう 破防法"
"はぼたん 葉牡丹"
"はぼまい 歯舞"
"はぼろ 羽幌"
"はま 濱 破魔 浜"
"はまいで 浜出"
"はまお 浜尾"
"はまおおつ 浜大津"
"はまおか 浜岡"
"はまおぎ 浜荻"
"はまおもと 浜万年青"
"はまかいどう 浜街道"
"はまかぜ 浜風"
"はまかた 浜方"
"はまかつ 浜勝"
"はまかど 濱角"
"はまかわ 濱川 浜川"
"はまかわさき 浜川崎"
"はまがくえん 浜学園"
"はまがみ 濱上 浜上"
"はまがわ 浜側"
"はまき 葉巻"
"はまきた 浜北"
"はまきょう 浜響"
"はまぐち 浜口"
"はまぐちおさち 浜口雄幸"
"はまぐり 蛤"
"はまこ 浜子"
"はまさか 浜坂"
"はまさき 濱崎 浜崎"
"はまざき 浜崎"
"はましぎ 浜鷸"
"はましま 濱島"
"はまじ 浜路"
"はまじま 浜島"
"はまたけ 浜竹"
"はまだ 濱田 浜田"
"はまち 刃区"
"はまちどり 浜千鳥"
"はまちょう 浜町"
"はまっこ 浜っ子"
"はまつか 濱塚"
"はまで 濱出"
"はまとんべつ 浜頓別"
"はまどおり 浜通り"
"はまな 浜名"
"はまなか 濱中 浜中"
"はまなこ 浜名湖"
"はまなし 浜梨"
"はまなす 浜梨 浜茄子"
"はまの 濱野 浜野"
"はまびと 浜人"
"はまべ 浜部 浜辺"
"はまぼうふう 浜防風"
"はまます 浜益"
"はままつ 浜松"
"はままつだこ 浜松凧"
"はままつにし 浜松西"
"はままで 浜迄"
"はまみち 浜道"
"はまみやせん 浜宮線"
"はまむら 浜村"
"はまめし 浜飯"
"はまもと 濱本 浜元"
"はまや 浜屋 破魔矢"
"はまやき 浜焼"
"はまやす 浜靖"
"はまゆう 浜木綿"
"はまゆみ 破魔弓"
"はまりきゅう 浜離宮"
"はまりやく 嵌役 填役 嵌まり役"
"はみ 葉美 馬銜"
"はみがき 歯磨 歯磨き"
"はみがきこ 歯磨き粉"
"はみず 葉水"
"はむし 羽虫"
"はむら 葉叢 羽村"
"はむらびほうてん ハムラビ法典"
"はむろ 葉室"
"はめ 破目 羽目"
"はめいた 羽目板"
"はめこみ 嵌め込み"
"はめころし 嵌め殺し"
"はめごろし 嵌め殺し"
"はめつ 破滅"
"はめて 填め手"
"はめん 破面 波面"
"はも 羽茂 鱧"
"はもの 釖 端物 葉物 刃物"
"はもん 刃文 破門 波紋"
"はや 頓 速 鮠 早"
"はやあし 速足 早足"
"はやあるき 速歩き"
"はやい 速い"
"はやいとこ 早い所"
"はやいものがち 早い者勝ち"
"はやうた 早歌"
"はやうち 速打ち 早撃ち"
"はやうま 早馬"
"はやお 早生 駿"
"はやかわ 早川"
"はやかわぶんこ ハヤカワ文庫"
"はやがけ 早駆け"
"はやがね 早鐘"
"はやがわり 早変わり"
"はやき 隼輝 勇樹"
"はやきた 早来"
"はやく 早く 破約 端役"
"はやくさ 早草"
"はやくち 早口"
"はやくも 早くも"
"はやぐい 早喰い 早食い"
"はやけ 葉焼け"
"はやさ 速さ"
"はやさか 早坂"
"はやざし 早指し"
"はやし 囃 囃子 林"
"はやしお 早潮"
"はやしことば 囃子詞"
"はやししへい 林子平"
"はやした 早下"
"はやしたつお 林達夫"
"はやしだ 林田"
"はやしば 林葉"
"はやしばら 林原"
"はやしま 早島"
"はやしや 林屋 林家"
"はやしゆうてき 早矢仕有的"
"はやしらざん 林羅山"
"はやじに 早死 早死に"
"はやせ 早勢 早瀬"
"はやた 早田"
"はやちね 早池峰"
"はやて 疾風"
"はやで 早出"
"はやと 早戸 勇人 隼人"
"はやとき 早解き"
"はやとちり 早とちり"
"はやね 早寝"
"はやの 早野"
"はやのみこみ 早呑み込み"
"はやば 早場"
"はやばまい 早場米"
"はやばや 早早 早々"
"はやばん 早版 早番"
"はやひと 隼人"
"はやひとのつかさ 隼人司"
"はやびき 早退き 速弾き"
"はやびきゃく 早飛脚"
"はやびけ 早退け 早引け"
"はやびん 早便"
"はやふえ 早笛"
"はやふじ 早藤"
"はやぶさ 鶻 隼"
"はやべん 早弁"
"はやま 早馬 端山 羽山 葉山"
"はやまき 早蒔き"
"はやみ 速見 速水 早見"
"はやみぎょしゅう 速水御舟"
"はやみず 早水 速水"
"はやみち 早道"
"はやみばん 早見板"
"はやみみ 早耳"
"はやみや 早宮"
"はやめ 速目 早目 早め"
"はやめし 早飯"
"はやり 流行り 流行"
"はやりやまい 流行り病 流行病"
"はやわかり 早分り 早分かり"
"はやわざ 早技 早業"
"はやわり 早割"
"はら 波羅 肚 原 腹"
"はらあて 腹当"
"はらい 赦い 拂 祓 祓い 払 払い"
"はらいかわ 秡川 祓川"
"はらいこみ 払込み 払込"
"はらいごし 払い腰"
"はらいさげ 払下げ"
"はらいせ 腹いせ 腹癒せ"
"はらいた 腹痛"
"はらいっぱい 腹一杯"
"はらいどの 払殿"
"はらいもどし 払戻し 払戻 払い戻し"
"はらいわたし 払渡し"
"はらお 原尾"
"はらおか 原岡"
"はらおび 腹帯"
"はらか 腹赤"
"はらから 同胞"
"はらかわ 原川"
"はらがまえ 腹構え"
"はらき 原木"
"はらきり 腹切り"
"はらくだし 腹下し"
"はらくだり 腹下り"
"はらぐあい 腹具合"
"はらぐち 原口"
"はらぐろ 腹黒"
"はらげい 腹芸"
"はらこ 原子 腹子"
"はらこし 原越"
"はらごころ 腹心"
"はらごしらえ 腹拵え"
"はらごなし 腹ごなし"
"はらさき 原崎"
"はらさわ 原沢 原澤"
"はらしま 原嶋 原島"
"はらしょぼう 原書房"
"はらじま 原島"
"はらじゅく 原宿"
"はらせつこ 原節子"
"はらたけ 原茸"
"はらたつのり 原辰徳"
"はらだ 原田"
"はらだち 腹立ち"
"はらちがい 腹違い"
"はらっぱ 原っぱ"
"はらつづみ 腹鼓"
"はらづもり 腹積り 腹積もり"
"はらてっけつ 爬羅剔抉"
"はらどけい 腹時計"
"はらなか 原中"
"はらにく 腹肉"
"はらの 原野"
"はらのうち 腹の中"
"はらのかわ 腹の皮"
"はらのなか 腹の中"
"はらのまち 原ノ町 原町"
"はらのむし 腹の虫"
"はらのや 原野谷"
"はらはちぶ 腹八分"
"はらばい 腹這い"
"はらひでこ 原日出子"
"はらびれ 腹鰭"
"はらぺこ 腹ぺこ 腹ペコ"
"はらまき 腹巻"
"はらまち 原町"
"はらまちだ 原町田"
"はらみおんな 孕み女"
"はらみず 原水"
"はらみった 波羅蜜多"
"はらみつ 波羅蜜"
"はらもち 腹持ち"
"はらやま 原山"
"はらよし 原良"
"はらわた 腑 腸"
"はらん 波蘭 葉蘭 波瀾 波乱"
"はらんぶくみ 波乱含み"
"はり 播 貼 張り 張 鉤 玻璃 榛 鍼 梁 針"
"はりあい 張合い 張り合い"
"はりあな 針穴"
"はりあみ 張網 張り網"
"はりい 鍼医"
"はりいた 張板"
"はりいち 針位置"
"はりうお 針魚"
"はりうっどえいが ハリウッド映画"
"はりおうぎ 張り扇"
"はりかえ 張替 張替え"
"はりかた 張り形 張型 張形"
"はりかべ 貼り壁 張り壁"
"はりがた 張型 張形"
"はりがね 針金"
"はりがみ 張紙 貼紙 はり紙 貼り紙"
"はりがや 針ヶ谷 針谷"
"はりき 針木"
"はりくよう 針供養"
"はりぐすり 貼り薬"
"はりぐち 播口"
"はりけん 破裏拳"
"はりこ 針子 張子"
"はりこうかん 針交換"
"はりこみ 貼り込み"
"はりさき 針先"
"はりさし 針刺し"
"はりし 鍼師"
"はりしごと 針仕事"
"はりしょうが 針生姜"
"はりじょう 針状"
"はりす 鉤素"
"はりせん 張り扇"
"はりせんぼん 針千本"
"はりだし 張出し 張出"
"はりだしせきわけ 張出横綱"
"はりちりょう 針治療 鍼治療"
"はりつ 破笠"
"はりつけ 貼付 貼り付け 磔"
"はりつけばしら 磔柱"
"はりて 張手"
"はりぬい 針縫"
"はりねずみ 蝟 針鼠"
"はりのあな 針の穴"
"はりのむしろ 針の筵"
"はりのやま 針の山"
"はりはりづけ はりはり漬け"
"はりばこ 針箱"
"はりふだ 張札 貼り札 張り札 はり札"
"はりぼて 張りぼて"
"はりま 播摩 針間 梁間 播磨"
"はりまど 玻璃窓"
"はりまなだ 播磨灘"
"はりまのくに 播磨国"
"はりまびと 播磨人"
"はりまや 針間矢"
"はりみち 針道"
"はりめ 針目"
"はりもと 播本 張本"
"はりや 針谷"
"はりやま 張山 針山"
"はりゆき 梁行"
"はりよ 針魚"
"はりん 破倫"
"はる 青春 榛 請 玄 温 晴 治 春"
"はるあき 春秋"
"はるいがい 春以外"
"はるいちばん 春一番"
"はるうらら 春麗"
"はるえ 治恵 春江"
"はるお 東生 晴朗 治男 治雄 治夫 晴雄 春雄 春男 晴夫 春夫"
"はるおか 春岡"
"はるおみ 晴臣"
"はるか 春歌 晴香 美佳 遥か 悠 遙 遥"
"はるかぜ 春風"
"はるかわ 春川"
"はるがすみ 春霞"
"はるがっしゅく 春合宿"
"はるき 治己 春木 春樹"
"はるきち 春吉"
"はるきゃべつ 春キャベツ"
"はるぎ 春着"
"はるぐち 春口"
"はるけいば 春競馬"
"はるげしき 春景色"
"はるこ 治子 春子 晴子"
"はるごう 春号"
"はるごえ 春肥"
"はるごころ 春心"
"はるごたつ 春炬燵"
"はるごろ 春頃"
"はるさき 春先"
"はるさく 春作"
"はるさめ 春雨"
"はるし 治志"
"はるしぐれ 春時雨"
"はるじ 春治"
"はるぞら 春空"
"はるた 春田"
"はるだ 春田"
"はるだんじ 春団次"
"はるつげうお 春告魚"
"はるな 榛名 春菜"
"はるなつ 春夏"
"はるの 榛野 春野"
"はるのうみ 春の海"
"はるのこころ 春の心"
"はるのひ 春の日"
"はるのよ 春の夜"
"はるばしょ 春場所"
"はるばる 遥遥 遥々"
"はるひ 晴日 春日"
"はるひこ 晴比古 治彦 春彦 晴彦"
"はるひさ 春久 陽久 治久 晴久"
"はるひで 治秀"
"はるひと 治人"
"はるひろ 晴弘"
"はるび 腹帯"
"はるびん 哈爾浜"
"はるふじ 春藤"
"はるまき 春蒔き 春巻"
"はるまつり 春祭 春祭り"
"はるまんかい 春満開"
"はるみ 晴見 はる美 晴海 春美 晴美"
"はるみちのつらき 春道列樹"
"はるみつ 晴光"
"はるもの 春物"
"はるもよう 春模様"
"はるやさい 春野菜"
"はるやす 陽保 晴康"
"はるやすみ 春休み"
"はるやま 春山"
"はるゆき 陽之 春幸 治幸 晴幸 治之"
"はるよ 春代"
"はるよし 晴芳"
"はるらんまん 春爛漫"
"はれ 霽れ 腫れ 晴れ 晴"
"はれーすいせい ハレー彗星"
"はれお 晴夫"
"はれぎ 晴着"
"はれすがた 晴れ姿"
"はれつ 破裂"
"はれて 晴れて"
"はればれ 晴々"
"はれぶたい 晴舞台"
"はれま 晴間"
"はれもの 腫物"
"はれやま 晴山"
"はれんち 破廉恥"
"はろ 波呂"
"はろう 波浪"
"はわい 布哇 羽合"
"はわいとう ハワイ島"
"はわたり 刃渡り"
"はん 泛 釆 繁 范 笵 氾 樊 攀 煩 頒 蟠 膰 繙 燔 潘 翻 蕃 旛 幡 袢 胖 絆 拌 畔 伴 判 槃 磐 瘢 般 搬 鈑 販 板 叛 阪 坂 帆 凡 汎 飯 版 反 犯 藩 半 範 斑 班"
"はんあい 汎愛"
"はんあらぶしゅぎ 汎アラブ主義"
"はんい 叛意 犯意 藩医 範囲"
"はんいご 反意語"
"はんいん 班員"
"はんえい 半影 繁栄 反映"
"はんえり 半襟"
"はんえん 攀援 半円"
"はんえんけい 攀縁茎"
"はんおう 藩王 反応"
"はんおし 半押"
"はんおん 半音"
"はんか 半価 反歌 半跏 般化 汎化 繁華 頒価"
"はんかい 半潰 半解 半開 半壊"
"はんかいしんけい 反回神経"
"はんかく 反核 半角"
"はんかくかたかな 半角カタカナ"
"はんかくかな 半角カナ"
"はんかた 汎型"
"はんかちおとし ハンカチ落とし"
"はんかちょう 犯科帳"
"はんかつう 半可通"
"はんかん 半環 繁簡 反間 繁閑 反感"
"はんかんはんみん 半官半民"
"はんかんひ 販管費"
"はんが 版画"
"はんがい 半舁 斑蓋"
"はんがく 藩学 半額"
"はんがた 判形 版型 判型"
"はんがりー 洪牙利"
"はんがわき 半乾き"
"はんがん 半眼 判官"
"はんき 半季 搬器 半旗 叛旗 反旗 半期"
"はんきかん 半規管"
"はんきゅう 班給 半弓 阪九 半球 半休 阪急"
"はんきゅうふぇりー 阪九フェリー"
"はんきょう 般教 反共 反響"
"はんきりすと 反キリスト"
"はんきん 半金"
"はんぎ 半技 板木 版木"
"はんぎご 反義語"
"はんぎゃく 叛逆 反逆"
"はんぎょ 板魚 半漁"
"はんぎょく 半玉"
"はんぎょじん 半魚人"
"はんぎれ 半切れ"
"はんく 半句"
"はんくら 半クラ"
"はんくらっち 半クラッチ"
"はんぐん 叛軍 半群 反軍"
"はんけい 判型 半径"
"はんけつ 判決"
"はんけん 半研 半券 版権"
"はんけんじ 判検事"
"はんげ 半夏"
"はんげき 繁劇 反撃"
"はんげしょう 半夏生"
"はんげつ 半月"
"はんげつばん 半月板"
"はんげん 半源 半舷 半減"
"はんこ 判子"
"はんこう 藩侯 板行 版行 藩校 反攻 反抗 犯行"
"はんこく 汗国 翻刻"
"はんこつ 反骨"
"はんこや はんこ屋"
"はんこん 斑痕 瘢痕"
"はんご 反語"
"はんごう 半合 飯盒"
"はんごろし 半殺し"
"はんごん 反魂"
"はんごんこう 反魂香"
"はんごんたん 反魂丹"
"はんさ 煩瑣"
"はんさい 半截 半歳 半済 燔祭 半裁"
"はんさき 飯崎"
"はんさく 半作"
"はんさつ 藩札"
"はんざ 反坐 半座"
"はんざい 犯罪"
"はんざつ 繁雑 煩雑"
"はんざわ 半沢 半澤"
"はんざん 飯山"
"はんし 半死 範士 半紙 藩士"
"はんしき 範式 版式"
"はんした 版下"
"はんしちとりものちょう 半七捕物帳"
"はんしつ 半室"
"はんしゃ 販社 反射"
"はんしゃきゅう 反射弓"
"はんしゃきょう 反射鏡"
"はんしゃこう 反射光"
"はんしゃばん 反射板"
"はんしゅ 藩主"
"はんしゅう 半周"
"はんしゅつ 搬出"
"はんしょ 繙書"
"はんしょう 半生 汎称 反照 半鐘 半焼 反証"
"はんしょく 飯食 蕃殖 繁殖"
"はんしょくば 繁殖馬"
"はんしん 叛臣 版心 半神 半身 阪神"
"はんしんあわじだいしんさい 阪神・淡路大震災"
"はんしんはんぎ 半信半疑"
"はんしんろん 汎心論 汎神論"
"はんじ 判じ 半時 判示 判事"
"はんじつ 反実 半日"
"はんじゃ 判者"
"はんじゅ 判授"
"はんじゅう 半獣"
"はんじゅく 半熟"
"はんじゅくたまご 半熟卵"
"はんじょう 犯情 半畳 繁昌 繁盛"
"はんじょく 繁縟"
"はんじん 半人"
"はんすい 半睡"
"はんすう 版数 反芻 半数"
"はんすけ 半助"
"はんずぼん 半ズボン"
"はんせい 繁生 藩政 半生 反省"
"はんせいいでん 伴性遺伝"
"はんせき 犯跡 版籍"
"はんせつ 半截 反切 半切"
"はんせん 半銭 帆船 反戦"
"はんせんでも 反戦デモ"
"はんせんびょう ハンセン病"
"はんぜいてんのう 反正天皇"
"はんぜん 判然"
"はんそ 反ソ 反訴"
"はんそう 帆走 搬送"
"はんそく 反側 半束 犯則 反則 販促"
"はんそで 半袖"
"はんぞう 半挿 楾 半蔵"
"はんぞく 反俗"
"はんた 煩多 繁多"
"はんたい 繁体 反対"
"はんたいぎし 反対岸"
"はんたま 半玉"
"はんたんい 班単位"
"はんだ 盤陀 半田"
"はんだーす 半ダース"
"はんだい 大阪大学 阪大 版代 飯台"
"はんだくおんぷ ゜"
"はんだくてん ゜"
"はんだごて 半田ごて 半田鏝"
"はんだずけ 半田付け"
"はんだん 判断"
"はんち 半値"
"はんちく 斑竹"
"はんちはんかい 半知半解"
"はんちゃん 半荘"
"はんちゅう 範衷 範中 藩中 範疇"
"はんちょう 反跳 半丁 班長"
"はんつき 半月"
"はんつきまい 半搗き米"
"はんづら 版面"
"はんて 半手"
"はんてい 藩邸 判定"
"はんてつ 半徹"
"はんてん 反轉 袢纏 半天 半纏 斑点 飯店 反転"
"はんでんせい 班田制"
"はんと 半途 叛徒 版図"
"はんとう 反騰 半島"
"はんとうまく 半透膜"
"はんとき 半刻 半時"
"はんとし 半年"
"はんとらすとほう 反トラスト法"
"はんとりちょう 判取帳"
"はんどあ 半ドア"
"はんどう 般道 半道 半藤 反動"
"はんどく 繙読 槃特 範読 判読"
"はんどぶ ハンド部"
"はんどぼーるぶ ハンドボール部"
"はんどん 半ドン"
"はんな 阪奈"
"はんなが 半長"
"はんなま 半生"
"はんなん 阪南"
"はんにち 反日 半日"
"はんにっし 班日誌"
"はんにゃ 般若"
"はんにゃきょう 般若経"
"はんにゃしんきょう 般若心経"
"はんにゃとう 般若湯"
"はんにゅう 搬入"
"はんにん 半人 犯人"
"はんにんかん 判任官"
"はんね 半値"
"はんねん 半年"
"はんのう 半納 半能 半農 飯能 反応"
"はんのき 榛の木"
"はんはん 半々"
"はんば 半場 飯場"
"はんばい 半杯 販売"
"はんばく 反ばく 反駁"
"はんばつ 藩閥"
"はんぱ 半波 半端"
"はんぱく 頒白 斑白 半白 半拍 半泊"
"はんぱつ 反撥 反発"
"はんひん 販品"
"はんぴ 反比"
"はんぴゃく 凡百"
"はんふだい 阪府大"
"はんぶるぐ 漢堡"
"はんぶん 繁文 半分"
"はんぶんこ 半分こ"
"はんぶんすう 繁分数"
"はんぷ 帆布 頒布"
"はんぷく 反覆 反復"
"はんべい 反米"
"はんべそ 半ベソ 半べそ"
"はんべつ 判別"
"はんぺい 汎平 藩屏"
"はんぺいた 半平太"
"はんぺん 反変 半片 半平"
"はんぼう 繁忙"
"はんぽ 反哺 半歩"
"はんぽん 翻本 版本"
"はんま 半間"
"はんまーなげ ハンマー投げ"
"はんまい 飯米"
"はんみ 半身"
"はんみち 半道"
"はんみょう 斑猫"
"はんむ 煩務 繁務"
"はんむら 半村"
"はんめい 藩命 判明"
"はんめん 版面 半面 反面"
"はんも 繁茂"
"はんもう 半盲 反毛"
"はんもく 半目 反目"
"はんもと 版元"
"はんもん 半文 斑文 反問 煩悶 斑紋"
"はんもんてん 板門店"
"はんや 半夜"
"はんやく 反訳"
"はんよう 藩窯 繁用 汎用"
"はんら 半裸"
"はんらく 反落"
"はんらん 汎濫 叛乱 反乱 氾濫"
"はんらんげん 氾濫原"
"はんり 半里"
"はんりつ 反立"
"はんりゅう 韓流 伴流"
"はんりょ 伴侶"
"はんりょう 半両 半量"
"はんりょく 反力"
"はんりん 半輪"
"はんるい 煩累"
"はんれい 煩禮 汎例 范蠡 範例 反例 判例 凡例"
"はんれつ 半列 範列"
"はんろ 坂路 販路"
"はんろう 煩労 藩老"
"はんろん 汎論 反論"
"はんわ 阪和"
"ば 刄 塲 芭 庭 婆 罵 歯 刃 葉 羽 馬 場"
"ばーじゃーびょう バージャー病"
"ばーじょんばんごう バージョン番号"
"ばーすとう バース党"
"ばあ 婆"
"ばあい 場合"
"ばあさま 婆様"
"ばあさん 祖母さん 婆さん"
"ばあたり 場当り 場当たり"
"ばあや 婆や"
"ばい 杯 Ｂｙ 憊 吠 霾 黴 苺 梅 煤 楳 媒 焙 陪 賠 培 狽 唄 貝 賣 買 売 倍"
"ばいいじょう 倍以上"
"ばいいない 倍以内"
"ばいいん 売淫"
"ばいう 黴雨 梅雨"
"ばいうころ 梅雨頃"
"ばいえん 煤煙 梅園"
"ばいおん 倍音"
"ばいか 買価 倍化 倍加 梅花 売価"
"ばいかい 媒介"
"ばいかく 倍角"
"ばいかん 売勘 陪観 売官"
"ばいがえし 倍返し"
"ばいがく 倍額"
"ばいきゃく 売却"
"ばいきゅう 倍旧"
"ばいきん 黴菌"
"ばいくとう バイク盗"
"ばいくびん バイク便"
"ばいくらい 倍位"
"ばいけつ 売血"
"ばいけん 買券"
"ばいこく 売国"
"ばいこくど 売国奴"
"ばいごう 媒合"
"ばいごま 貝独楽"
"ばいざい 媒材"
"ばいし 貝子"
"ばいしつ 媒質"
"ばいしゃく 倍尺 媒妁 媒酌"
"ばいしゅう 買収"
"ばいしゅん 買春 売春"
"ばいしゅんふ 売春婦"
"ばいしゅんやど 買春宿 売春宿"
"ばいしょ 貝書"
"ばいしょう 売笑 焙焼 賠償"
"ばいしょうふ 売笑婦"
"ばいしょく 陪食 売色"
"ばいしん 陪臣 陪審"
"ばいじゅう 陪従"
"ばいじょう 陪乗"
"ばいじん 煤塵"
"ばいすう 倍数"
"ばいせい 媒精"
"ばいせいど 倍精度"
"ばいせき 陪席"
"ばいせん 煤煎 媒染 焙煎"
"ばいそう 黴瘡"
"ばいそく 倍速"
"ばいぞう 倍増"
"ばいた 売女"
"ばいたい 倍体 媒体"
"ばいだい 倍大"
"ばいち 培地"
"ばいちょう 倍調 陪聴 倍長"
"ばいていど 倍程度"
"ばいてん 売店"
"ばいでん 買電 売電"
"ばいとく 売得 買得"
"ばいとさき バイト先"
"ばいとすう バイト数"
"ばいとだい バイト代"
"ばいとりょう バイト料"
"ばいどく 梅毒"
"ばいにく 梅肉"
"ばいにん 売人"
"ばいはば 倍幅"
"ばいばい 倍々 売買"
"ばいばいしゅん 売買春"
"ばいばら 莪原"
"ばいひん 売品"
"ばいふうかん 培風館"
"ばいぶん 売文"
"ばいべんてき 買弁的"
"ばいぼく 売卜"
"ばいまん 倍満"
"ばいめい 売名"
"ばいやく 売薬 売約"
"ばいやくまん 倍役満"
"ばいゆう 培雄"
"ばいよう 培養"
"ばいようりょう 倍容量"
"ばいりつ 倍率"
"ばいりょう 倍量"
"ばいりん 梅林"
"ばう 芒"
"ばえ 蠅"
"ばおり 羽織"
"ばか 莫迦 馬鹿"
"ばかうれ バカ売れ"
"ばかおや バカ親"
"ばかおんな 馬鹿女"
"ばかがい 馬鹿貝"
"ばかく 馬格"
"ばかさわぎ バカ騒ぎ"
"ばかじから 馬鹿力"
"ばかず 場数"
"ばかたか バカ高 馬鹿高"
"ばかたれ 馬鹿たれ"
"ばかぢから バカ力 馬鹿力"
"ばかとの 馬鹿殿"
"ばかね 馬鹿値"
"ばかやす バカ安"
"ばかやろう バカ野郎"
"ばかり 秤 許 許り"
"ばかん 馬韓 馬関"
"ばきゃく 馬脚"
"ばきん 馬琴"
"ばぎょう ば行 バ行"
"ばく 藐 駁 麥 麦 博 縛 暴 曝 瀑 驀 寞 幕 莫 漠 獏 貘 爆"
"ばくえい 幕営"
"ばくえき 博奕"
"ばくえん 爆煙 爆炎"
"ばくおん 爆音"
"ばくか 幕下"
"ばくが 麦芽"
"ばくがとう 麦芽糖"
"ばくぎ 博戯"
"ばくげき 駁撃 爆撃"
"ばくさい 博才 爆砕"
"ばくさつ 爆殺"
"ばくし 爆死"
"ばくしゃ 幕舎"
"ばくしゅう 麦秋"
"ばくしゅく 爆縮"
"ばくしょ 曝書"
"ばくしょう 爆笑"
"ばくしん 爆進 爆心 幕臣 驀進"
"ばくすい 麦穂 爆睡"
"ばくせい 幕政"
"ばくせつ 駁説"
"ばくせん 瀑泉"
"ばくぜん 驀然 漠然"
"ばくそう 爆装 麦草 爆走"
"ばくそく 爆速"
"ばくだい 莫大"
"ばくだん 爆彈 爆弾"
"ばくだんおとこ 爆弾男"
"ばくち 驀地 博奕 博打"
"ばくちく 爆竹"
"ばくちゃく 縛着"
"ばくちん 爆沈"
"ばくてん バク転"
"ばくと 博徒"
"ばくにゅう 爆乳"
"ばくにょう 麥繞"
"ばくねん 爆燃"
"ばくは 爆破"
"ばくはつ 爆発"
"ばくはん 麦飯 幕藩"
"ばくふ 瀑布 幕府"
"ばくふう 爆風"
"ばくまつ 幕末"
"ばくやく 爆薬"
"ばくらい 爆雷"
"ばくりゅう 瀑流"
"ばくりゅうしゅ 麦粒腫"
"ばくりょう 曝涼 幕僚"
"ばくりょうかんぶ 幕僚監部"
"ばくれつ 爆裂"
"ばくれつだん 爆裂弾"
"ばくれん 莫連"
"ばくろ 曝露 暴露"
"ばくろう 伯労 博労 伯楽 馬喰"
"ばくろちょう 馬喰町"
"ばくろれべる 暴露レベル"
"ばくろん 駁論"
"ばぐ 馬具"
"ばぐとり バグ取り"
"ばぐん 馬群"
"ばけ 化 化け"
"ばけがく 化学"
"ばけねこ 化猫 化け猫"
"ばけのかわ 化けの皮"
"ばけもの 化物"
"ばけん 馬券"
"ばげん 罵言"
"ばこ 箱"
"ばさし 馬刺 馬刺し"
"ばさら 伐折羅 婆娑羅"
"ばさん 馬産"
"ばし 箸 橋"
"ばしご 梯子"
"ばしゃ 馬車"
"ばしゃうま 馬車馬"
"ばしゃく 馬借"
"ばしゃみち 馬車道"
"ばしゅ 馬首 馬主"
"ばしょ 場所"
"ばしょう 芭蕉"
"ばしょうふ 芭蕉布"
"ばしょく 馬食 馬謖"
"ばしら 柱"
"ばしん 馬身"
"ばじとうふう 馬耳東風"
"ばじゅつ 馬術"
"ばじょう 馬乗 馬上"
"ばすいぼく 馬酔木"
"ばすえ 場末"
"ばすがた バス型"
"ばすくご バスク語"
"ばすけっとぶ バスケット部"
"ばすけっとぼーるぶ バスケットボール部"
"ばすけぶ バスケ部"
"ばすてい バス停"
"ばすはば バス幅"
"ばずーかほう バズーカ砲"
"ばせい 罵声"
"ばせき 場席"
"ばせん 場銭"
"ばそり 馬橇"
"ばぞく 馬族 馬賊"
"ばた 端 畑"
"ばたーいため バター炒め"
"ばたーやき バター焼き"
"ばたあし バタ足"
"ばたい 馬体"
"ばたく 馬鐸"
"ばたけ 畠 畑"
"ばたち 場立ち"
"ばたや ばた屋"
"ばだい 場代"
"ばち 罸 蜂 鉢 枹 桴 撥 罰"
"ばちあたり 罰当り 罰当たり"
"ばちおと 撥音"
"ばちがい 場違い"
"ばちすもく バチス目"
"ばちゅう 馬柱"
"ばちる 撥鏤"
"ばっか 麦価 幕下"
"ばっかく 麦角 幕閣"
"ばっかん 麦稈"
"ばっき 曝気"
"ばっきょ 抜去"
"ばっきん 罰金"
"ばっきんがむきゅうでん バッキンガム宮殿"
"ばっきんとうりんじそちほう 罰金等臨時措置法"
"ばっくてん バック転"
"ばっくねっとうら バックネット裏"
"ばっくよらく 抜苦与楽"
"ばっけん 抜剣"
"ばっこ 跋扈"
"ばっさい 伐採"
"ばっさつ 抜刷"
"ばっし 末子 抜糸 抜歯"
"ばっしゅ 罰酒"
"ばっしゅつ 伐出"
"ばっしょう 跋渉"
"ばっすい 抜萃 抜粋"
"ばっせき 末席"
"ばっせん 抜染"
"ばっそく 罰則"
"ばっそん 末孫"
"ばった 蝗虫 飛蝗"
"ばったい 罰退"
"ばったく 抜擢"
"ばったもの バッタ物"
"ばっちしょり バッチ処理"
"ばってい 末弟"
"ばってき 抜てき 抜擢"
"ばってん × 罰点"
"ばっとう 伐倒 抜刀"
"ばっぱい 罰杯"
"ばっぷ 罰符"
"ばっぽん 抜本"
"ばっぽんそくげん 抜本塞源"
"ばつ × 罸 末 魃 筏 伐 拔 抜 跋 閥 罰"
"ばついっぱん 罰一般"
"ばつえい 末裔"
"ばつぐん 抜群"
"ばつげーむ 罰ゲーム"
"ばつご 跋語"
"ばつざんがいせい 抜山蓋世"
"ばつぞく 閥族"
"ばつたい 罰退"
"ばつだ 罰打"
"ばつとうばん 罰当番"
"ばつばつ ××"
"ばつびょう 抜錨"
"ばつぶん 跋文"
"ばつぼく 伐木"
"ばつよう 末葉"
"ばつりゅう 末流"
"ばてい 馬丁 馬蹄"
"ばてれん 伴天連"
"ばとう 馬頭 罵倒"
"ばとうきん 馬頭琴"
"ばどみんとんぶ バドミントン部"
"ばな 端 花 鼻"
"ばなか 場中"
"ばなし 話"
"ばなじうむこう バナジウム鋼"
"ばななあじ バナナ味"
"ばなれ 離れ 場馴れ 場慣れ"
"ばにく 馬肉"
"ばにゅうしゅ 馬乳酒"
"ばにらあじ バニラ味"
"ばぬし 馬主"
"ばね 羽根 羽 発条"
"ばば 糞 屎 婆 馬場"
"ばばあ 婆"
"ばばさま 婆様"
"ばばじる 婆汁"
"ばばぬき ババ抜き"
"ばひつ 馬匹"
"ばび 馬尾"
"ばふく 馬腹"
"ばふだ 場札"
"ばふん 馬糞"
"ばぶるけいざい バブル経済"
"ばぶるほうかい バブル崩壊"
"ばぼう 馬房"
"ばぼうさく 馬防柵"
"ばめい 馬名"
"ばめん 場面"
"ばや 速 早"
"ばやし 囃子 林"
"ばら 腹 原 薔薇"
"ばらい 祓い 払い"
"ばらいろ バラ色"
"ばらうり 散売り ばら売り バラ売り"
"ばらえん バラ園"
"ばらか バラ科"
"ばらき 原木"
"ばらにく バラ肉"
"ばらのぷすもく バラノプス目"
"ばらばらしたい バラバラ死体"
"ばらまき ばら撒き"
"ばらみず バラ水 薔薇水"
"ばらもく バラ目"
"ばらもん 婆羅門"
"ばらもんきょう バラモン教"
"ばらんすかんかく バランス感覚"
"ばらんすがた バランス型"
"ばり 尿 針 張り 罵詈"
"ばりうむかごうぶつ バリウム化合物"
"ばりき 馬力"
"ばりとう バリ島"
"ばる 原"
"ばるかん 巴爾幹"
"ばるかんはんとう バルカン半島"
"ばるかんほう バルカン砲"
"ばるくひん バルク品"
"ばるさみこす バルサミコ酢"
"ばるちっくかんたい バルチック艦隊"
"ばれーぶ バレー部"
"ばれーぼーるぶ バレーボール部"
"ばれい 馬鈴 馬齢"
"ばれいしょ 馬鈴薯"
"ばれん 馬連"
"ばろっくおんがく バロック音楽"
"ばろっくちょう バロック調"
"ばろっくようしき バロック様式"
"ばん 阪 坂 塙 鑁 蠻 蛮 礬 磐 輓 悗 挽 伴 絆 播 旙 旛 幡 蕃 鷭 萬 万 板 版 盤 判 晩 番"
"ばんあれんたい バンアレン帯"
"ばんえつ 磐越"
"ばんか 晩歌 晩霞 蕃茄 晩夏 挽歌"
"ばんかい 挽回"
"ばんかず 番数"
"ばんから 蛮カラ"
"ばんかん 万巻 万感"
"ばんがい 番街 番外"
"ばんがく 晩学"
"ばんがさ 番傘"
"ばんがた 晩方"
"ばんき 万機 晩期"
"ばんきょ 蟠踞"
"ばんきん 輓近 鈑金 板金"
"ばんぎ 盤木 板木"
"ばんぎく 晩菊"
"ばんくーばー 晩香坡"
"ばんくみ 版組"
"ばんくるわせ 番狂わせ"
"ばんぐせつ 万愚節"
"ばんぐみ 番組"
"ばんぐみだい 番組第"
"ばんけい 晩景"
"ばんけん 番犬"
"ばんけんもと 版権元"
"ばんこ 盤古 萬古 万古 万戸"
"ばんこう 磐高 万考 蛮行"
"ばんこく 万斛 盤谷 万国"
"ばんこっき 万国旗"
"ばんこつ 万骨 蛮骨"
"ばんこやき 万古焼"
"ばんこん 盤根 晩婚"
"ばんご 蛮語 番後"
"ばんごう 番号"
"ばんごはん 晩ご飯 晩御飯"
"ばんごや 番小屋"
"ばんさい 磐西"
"ばんさく 盤錯 万策"
"ばんさん 晩産 晩餐"
"ばんざい 万歳"
"ばんし 万死"
"ばんしき 盤渉"
"ばんしつ 盤質"
"ばんしゃ 万謝"
"ばんしゃく 晩酌"
"ばんしゅう 磐州 播州 晩秋"
"ばんしゅん 晩春"
"ばんしょ 蕃書 番所 板書"
"ばんしょう 晩鐘 番匠 万障 万象"
"ばんしょく 伴食"
"ばんしん 蕃神"
"ばんしんどう 板振動"
"ばんじ 万事"
"ばんじきゅうす 万事休す"
"ばんじゃく 盤石 磐石"
"ばんじゅく 晩熟"
"ばんじょ 磐女"
"ばんじょう 万乗 番匠 万丈 盤上"
"ばんじん 蛮人 万人"
"ばんすい 晩翠"
"ばんすう 番数"
"ばんせい 蛮声 伴星 晩生 晩成 万世"
"ばんせいいでん 伴性遺伝"
"ばんせいせつ 万聖節"
"ばんせき 磐石"
"ばんせつ 晩節"
"ばんせん 番宣 番線"
"ばんぜん 万全"
"ばんそう 晩霜 伴走 伴奏"
"ばんそうこう ばん創膏 絆創膏"
"ばんそつ 番卒"
"ばんぞく 蕃族 蛮族"
"ばんたい 万態"
"ばんたむきゅう バンタム級"
"ばんたん 盤端 播但 万端"
"ばんだ 万朶"
"ばんだい 番代 万代 磐梯 番台"
"ばんち 番値 蕃地 番地"
"ばんちゃ 番茶"
"ばんちょう 番丁 番町 番長"
"ばんづけ 番付"
"ばんて 番手"
"ばんてき 蛮的"
"ばんとう 蛮刀 晩唐 晩稲 晩冬 番頭"
"ばんど 礬土"
"ばんどう 阪東 坂東"
"ばんどころ 番所"
"ばんない 判内 坂内"
"ばんなぐろ 花畔"
"ばんなん 万難"
"ばんにん 万人 番人"
"ばんねん 晩年"
"ばんの 番野 伴野 坂野"
"ばんのう 万能"
"ばんのうかぎ 万能鍵"
"ばんのうざお 万能竿"
"ばんのうねぎ 万能ネギ 万能葱"
"ばんば 番場 馬場 輓馬"
"ばんばやし 番囃子"
"ばんばんいつ 万々一"
"ばんばんざい 万万歳 万々歳"
"ばんばんじー 棒棒鶏 棒々鶏"
"ばんぱく 万博"
"ばんぱん 万般"
"ばんぶつ 万物"
"ばんぷう 蛮風"
"ばんぷく 万福"
"ばんぷふとう 万夫不当"
"ばんべつ 万別"
"ばんぺい 番兵"
"ばんぽう 万邦"
"ばんみん 万民"
"ばんめ 番目"
"ばんめし 晩飯"
"ばんめん 盤面"
"ばんもく 万目"
"ばんや 番屋"
"ばんゆう 蛮勇 万有"
"ばんらい 万籟 万雷 万来"
"ばんり 萬里 万里"
"ばんりのちょうじょう 万里の長城"
"ばんりゅう 伴流"
"ばんりょく 蛮力 万緑"
"ばんれいしか バンレイシ科"
"ばんれいせつ 万霊節"
"ばんれき 万暦"
"ぱ 播 破 羽 波"
"ぱーきんそんびょう パーキンソン病"
"ぱーせんと ％"
"ぱーてぃーけん パーティー券"
"ぱーとふ パート譜"
"ぱーみる ‰"
"ぱーむゆ パーム油"
"ぱーりご パーリ語"
"ぱーれんちゃん 八連荘"
"ぱあそう 八索"
"ぱい Π π 盃 配 杯 敗 牌"
"ぱいきじ パイ生地"
"ぱいこー 排骨"
"ぱいちゅー 白酒"
"ぱいなげ パイ投げ"
"ぱいなっぷるもく パイナップル目"
"ぱいぱん 白板"
"ぱいぷいす パイプ椅子"
"ぱいぷやく パイプ役"
"ぱうだーじょう パウダー状"
"ぱお 包"
"ぱおず 包子"
"ぱきすたんじん パキスタン人"
"ぱぎょう ぱ行 パ行"
"ぱく 朴 駮 愽 博 泊 拍"
"ぱけっとすう パケット数"
"ぱけっとつうしん パケット通信"
"ぱこ 箱"
"ぱじゃますがた パジャマ姿"
"ぱすたざら パスタ皿"
"ぱすたや パスタ屋"
"ぱすてるが パステル画"
"ぱすてるちょう パステル調"
"ぱすまわし パス回し"
"ぱすめい パス名"
"ぱそこんつうしん パソコン通信"
"ぱそつう パソ通"
"ぱたーんか パターン化"
"ぱたーんにんしき パターン認識"
"ぱち 八"
"ぱちんこだい パチンコ台"
"ぱちんこだま パチンコ玉"
"ぱちんこてん パチンコ店"
"ぱちんこや パチンコ屋"
"ぱっくりょうきん パック料金"
"ぱっくりょこう パック旅行"
"ぱっちあて パッチ当て"
"ぱっと パッと"
"ぱつ 發 発"
"ぱなま 巴奈馬"
"ぱなまうんが パナマ運河"
"ぱなまそうもく パナマソウ目"
"ぱなまぼう パナマ帽"
"ぱねるちょうさ パネル調査"
"ぱのらましゃしん パノラマ写真"
"ぱぱさん パパさん"
"ぱぶりしてぃけん パブリシティ権"
"ぱら 腹"
"ぱらふぃんし パラフィン紙"
"ぱられるせつぞく パラレル接続"
"ぱり 巴里"
"ぱりさい パリ祭"
"ぱりじょうやく パリ条約"
"ぱりだいがく パリ大学"
"ぱりっこ パリっ子"
"ぱるすはば パルス幅"
"ぱれーとさいてき パレート最適"
"ぱれすちなじん パレスチナ人"
"ぱん 犯 播 板 搬 幇 版 麺麭"
"ぱんきじ パン生地"
"ぱんこ パン粉"
"ぱんしょく パン食"
"ぱんだね パン種"
"ぱんづくり パン作り"
"ぱんとてんさん パントテン酸"
"ぱんや パン屋"
"ひ 昜 祕 泌 桧 檜 鞴 鄙 贔 痞 狒 朏 匕 丕 氷 簸 樋 肥 罷 轡 蓖 毘 庇 豼 貔 紕 秕 砒 妣 批 霏 蜚 菲 腓 暃 誹 斐 扉 匪 鞁 疲 披 彼 譬 臂 避 髀 裨 脾 痺 婢 俾 碑 卑 乾 干 梭 杼 皮 緋 悲 飛 灯 陽 否 妃 被 秘 費 非 比 火 日"
"ひあい 非愛 悲哀"
"ひあそび 火遊び"
"ひあたり 陽当り 陽当たり 日当り 日当たり"
"ひあぶり 火焙り 火炙り"
"ひあみ 火網"
"ひあるろんさん ヒアルロン酸"
"ひい 贔 曾 緋衣 非違"
"ひいき 贔屓"
"ひいく 肥育"
"ひいじじ 曽祖父"
"ひいちにち 日一日"
"ひいて 延いて"
"ひいては 延いては"
"ひいな 雛"
"ひいなぼん 雛本"
"ひいまご 曾孫"
"ひいらぎ 柊"
"ひいれ 火入れ"
"ひいれしき 火入式"
"ひいろ 緋色"
"ひう 非有 日宇"
"ひうお 乾魚 干魚 氷魚"
"ひうち 燧 火打ち"
"ひうちいし 燧石 火打ち石"
"ひうちやま 火打山"
"ひうら 日裏 樋浦 火浦 日浦"
"ひうん 非運 飛雲 悲運"
"ひえ 冷え 稗"
"ひえい 飛栄 飛影 比叡"
"ひえいざん 比叡山"
"ひえき 桧枝岐 裨益"
"ひえこみ 冷えこみ"
"ひえしょう 冷え性"
"ひえじんじゃ 日枝神社"
"ひえたいしゃ 日吉大社"
"ひえだ 檜枝 稗田"
"ひえだのあれ 稗田阿礼"
"ひえつ 飛越"
"ひえづ 日吉津"
"ひえぬき 稗貫"
"ひえまき 稗蒔き"
"ひえめし 稗飯"
"ひえん 飛燕"
"ひお 氷魚"
"ひおう 秘奥"
"ひおうぎ 檜扇"
"ひおおい 日覆い"
"ひおき 日置"
"ひおけ 火桶"
"ひおとこ 火男"
"ひか 砒化 悲歌 皮下"
"ひかえ 控 控え"
"ひかえしつ 控室"
"ひかえばしら 控え柱 控柱"
"ひかがみ 膕"
"ひかき 火掻き"
"ひかく 皮角 飛角 非核 皮革 比較"
"ひかくさんげんそく 非核三原則"
"ひかげ 日蔭 火影 日影 日陰"
"ひかげん 火加減"
"ひかず 日数"
"ひかた 日方 干潟"
"ひかみ 氷上"
"ひかり 芒 光"
"ひかりかいせん 光回線"
"ひかりかんれん 光関連"
"ひかりがおか 光が丘"
"ひかりきゅうしゅう 光吸収"
"ひかりぎじゅつ 光技術"
"ひかりぎょうこ 光凝固"
"ひかりこうかん 光交換"
"ひかりこうがく 光工学"
"ひかりごけ 光蘚"
"ひかりしげき 光刺激"
"ひかりしゅうよう 光収容"
"ひかりしゅつりょく 光出力"
"ひかりしょくばい 光触媒"
"ひかりしんごう 光信号"
"ひかりじき 光磁気"
"ひかりじきでぃすく 光磁気ディスク"
"ひかりじゅうごう 光重合"
"ひかりじゅようき 光受容器"
"ひかりじょうほう 光情報"
"ひかりそうさ 光走査"
"ひかりたんし 光端子"
"ひかりだい 光台"
"ひかりちゅうせいし 光中性子"
"ひかりつうしん 光通信"
"ひかりてんじょう 光天井"
"ひかりでぃすく 光ディスク"
"ひかりでんち 光電池"
"ひかりどけい 光時計"
"ひかりはつでん 光発電"
"ひかりはんのう 光反応"
"ひかりふぁいば 光ファイバ"
"ひかりふぁいばー 光ファイバー"
"ひかりもの 光物 光り物"
"ひかる 熈 光"
"ひかるげんじ 光源氏"
"ひかわ 簸川 斐川 氷川"
"ひかわじんじゃ 火川神社"
"ひかん 卑官 被管 被官 避寒 悲観"
"ひかんさん 比換算"
"ひが 比嘉 僻 非我 彼我"
"ひがい 鰉 被害"
"ひがえり 日帰り"
"ひがき 桧垣 檜垣"
"ひがく 非学"
"ひがけ 日掛け"
"ひがごと 僻事"
"ひがさ 日暈 日傘"
"ひがし 東"
"ひがしあわくら 東粟倉"
"ひがしいけ 東池"
"ひがしいんどがいしゃ 東インド会社"
"ひがしうら 東浦"
"ひがしえき 東駅"
"ひがしお 東尾"
"ひがしおおぎじま 東扇島"
"ひがしかぜ 東風"
"ひがしかた 東方"
"ひがしかわ 東川"
"ひがしかん 東館"
"ひがしがわ 東側"
"ひがしく 東区"
"ひがしくち 東口"
"ひがしぐち 東口"
"ひがしこう 東高"
"ひがししりいけ 東尻池"
"ひがしじま 東島"
"ひがしだ 東田"
"ひがしちもーる 東チモール"
"ひがしちょう 東町"
"ひがしてぃもーる 東ティモール"
"ひがしとう 東棟"
"ひがしどいつ 東ドイツ"
"ひがしどうり 東通"
"ひがしなか 東中"
"ひがしなだ 東灘"
"ひがしね 東根"
"ひがしの 東野"
"ひがしはま 東浜"
"ひがしはら 東原"
"ひがしばる 東原"
"ひがしふしみのみや 東伏見宮"
"ひがしまち 東町"
"ひがしむら 東村"
"ひがしもろかた 東諸県"
"ひがしもん 東門"
"ひがしやま 東山"
"ひがしやまこ 東山湖"
"ひがしよーろっぱ 東ヨーロッパ"
"ひがしよか 東与賀"
"ひがた 干潟"
"ひがないちにち 日がな一日"
"ひがね 日金"
"ひがみ 僻み"
"ひがめ 僻目"
"ひがら 日雀 日柄"
"ひがわり 日変わり 日替り 日替わり"
"ひがん 飛雁 悲願 彼岸"
"ひがんざくら 彼岸桜"
"ひがんばな 彼岸花"
"ひき 蟆 挽 曳 引 日置 比企 引き 蟇 疋 誹毀 悲喜 匹"
"ひきあい 引合い 引合 引き合い"
"ひきあけ 引明け"
"ひきあげ 引上げ"
"ひきあげしゃ 引揚げ者 引揚者"
"ひきあげせん 引上線"
"ひきあて 引当て 引当"
"ひきあみ 曳き網 引網 引き網"
"ひきあわせ 引合せ"
"ひきうけ 引受け 引受"
"ひきうた 引歌"
"ひきお 引尾"
"ひきかえ 引替え 引替 引換 引き換え"
"ひきかた 挽き方 弾き方"
"ひきかたり 弾き語り"
"ひきがえる 蟇蛙 蟾蜍"
"ひきがし 引菓子"
"ひきがたり 弾き語り"
"ひきがね 引き鉦 引金 引き金"
"ひきぎわ 退き際 引き際"
"ひきこみ 引込み 引込"
"ひきこみど 引き込み戸 引込み戸"
"ひきこもり 引きこもり"
"ひきごと 引言"
"ひきさげ 引下げ"
"ひきざん 引算 引き算"
"ひきしお 引き汐 引き潮"
"ひきしめ 引締め"
"ひきすう 引数"
"ひきぞめ 弾き初め"
"ひきた 引田 疋田"
"ひきたて 引立て"
"ひきだ 引田 疋田"
"ひきだし 引出 抽出し 抽出 抽き出し 抽斗 引出し"
"ひきち 引地"
"ひきちがい 引違 引違い"
"ひきちがいど 引違い戸 引き違い戸"
"ひきつぎ 引きつぎ 引継ぎ 引き継ぎ"
"ひきつけ 痙 引付け"
"ひきつづき 引続き"
"ひきつる 痙"
"ひきづな 引き綱"
"ひきて 弾き手 引手"
"ひきてぢゃや 引手茶屋"
"ひきでもの 引出物"
"ひきとり 引取 引取り"
"ひきど 引戸 引き戸"
"ひきにく ひき肉 挽き肉 挽肉"
"ひきにげ ひき逃げ 轢き逃げ"
"ひきのばし 引伸ばし 引き延ばし"
"ひきのばしき 引伸機"
"ひきふだ 引札"
"ひきふね 曳き舟 引舟 引き舟 曳き船 引き船 引船 曳船 曳舟"
"ひきまく 引幕"
"ひきみ 匹見"
"ひきめ 蟇目"
"ひきめかぎはな 引目鉤鼻"
"ひきもきらず 引きも切らず"
"ひきもの 引物"
"ひきゃく 飛脚"
"ひきや 引家 曳家"
"ひきやま 引山"
"ひきゅう 秘笈 悲泣 飛球"
"ひきょう 悲況 比況 悲境 秘教 卑怯 秘境"
"ひきょく 悲曲 秘曲"
"ひきょり 飛距離"
"ひきりょう 引両"
"ひきわけ 引分け 引分"
"ひきわたし 引渡 引渡し"
"ひきわり 碾き割り 引割り 引割 挽き割り"
"ひきん 卑近"
"ひきんぞく 卑金属"
"ひぎ 比擬 誹議 氷木 非義 非議 秘戯 秘義 秘儀 秘技"
"ひぎしゃ 被疑者"
"ひぎゃく 被虐"
"ひぎょう 非形 非業 飛行 罷業"
"ひく 佗 牽 攣 − 引く 低"
"ひくいどり 火喰鳥"
"ひくいな 緋秧鶏 緋水鶏"
"ひくう 非空"
"ひくうてい 飛空艇"
"ひくつ 卑屈"
"ひくま 曳馬"
"ひくみ 低み"
"ひくめ 低目 低め"
"ひぐち 火口 樋口"
"ひぐちうち 火口内"
"ひぐま 日熊 羆"
"ひぐらし 茅蜩 日暮し 日暮 日暮らし 蜩"
"ひぐれ 日暮れ 日暮"
"ひけ 引け"
"ひけい 秘計"
"ひけぎわ 引け際"
"ひけし 火消し"
"ひけた 引田"
"ひけつ 碑碣 秘結 否決 秘訣"
"ひけどき 退け時"
"ひけね 引け値"
"ひけん 卑見 披見 被験 比肩"
"ひけんしゃ 被検者"
"ひけんじゃ 被検者 被験者"
"ひげ 髯 鬚 卑下 髭"
"ひげい 秘芸"
"ひげき 悲劇"
"ひげくじら 鬚鯨"
"ひげくろ 髭黒"
"ひげけっしょう 髭結晶"
"ひげそり ひげ剃り 髭剃り"
"ひげづら 髭面"
"ひげね ひげ根 鬚根"
"ひげもじゃ 髭もじゃ"
"ひこ 秘湖 曾孫 比古 彦"
"ひこう 飛講 飛光 飛蝗 披講 比高 秘孔 肥厚 非行 飛行"
"ひこうきぐも 飛行機雲"
"ひこうしん 粃糠疹"
"ひこえ 彦衛"
"ひこがみ 比古神 彦神"
"ひこく 被告"
"ひこさぶろう 彦三郎"
"ひこしま 彦島"
"ひこじま 彦島"
"ひこたろう 彦太郎"
"ひこつ 腓骨"
"ひこなり 彦生"
"ひこね 彦根"
"ひこねひがし 彦根東"
"ひこの 彦野"
"ひこのじょう 彦之丞"
"ひこばえ 蘖"
"ひこぼし 彦星"
"ひこん 非婚"
"ひご 秘語 籖 蜚語 籤 卑語 飛語 肥後 庇護"
"ひごい 緋鯉"
"ひごう 非合 非業"
"ひごうし 火格子"
"ひごと 日毎"
"ひごのかみ 肥後の守"
"ひごよみ 日暦"
"ひごろ 日頃"
"ひさ 壽 央 寿 尚 久 飛砂"
"ひさあき 久昭"
"ひさい 菲才 非才 久居 被災"
"ひさいし 久石"
"ひさいべんさい 非債弁済"
"ひさえ 久栄 寿江 寿恵 久恵"
"ひさお 尚勇 尚生 尚夫 寿男 寿雄 寿夫 久男 久夫 久雄"
"ひさおじゅうらん 久生十蘭"
"ひさか 桶坂 日阪 樋坂"
"ひさかず 永和 久一 久和"
"ひさかた 久方"
"ひさかたぶり 久方振"
"ひさかど 久門"
"ひさかわ 久川"
"ひさき 寿樹 久木 火先"
"ひさきち 久吉"
"ひさく 秘策"
"ひさくに 久国"
"ひさこ 妃沙子 比佐子 寿子 久子"
"ひさご 蠡 匏 瓠 瓢"
"ひさし 寿史 久司 尚志 壽 久志 恒 央 寿 尚 久 廂 庇"
"ひさしがみ 廂髪 庇髪"
"ひさした 久下"
"ひさしぶり 久しぶり 久し振り"
"ひさしま 久島"
"ひさずみ 久住"
"ひさたか 尚敬"
"ひさだ 久田"
"ひさつせん 肥薩線"
"ひさと 久登 尚人 尚登 久人"
"ひさとし 尚敏 久敏"
"ひさとみ 久富"
"ひさとめ 久留"
"ひさどめ 久留"
"ひさなお 久尚"
"ひさなが 久長 久永"
"ひさの 久野"
"ひさのぶ 久信"
"ひさのり 寿憲 久寛 寿則 尚典 久典"
"ひさはら 久原"
"ひさはる 寿春 尚玄"
"ひさば 久馬"
"ひさひこ 寿彦"
"ひさひろ 久浩 久寛"
"ひさびさ 久々"
"ひさま 久馬"
"ひさまつ 久松"
"ひさみち 久道"
"ひさみつ 久光"
"ひさみどう 久美堂"
"ひさむら 久村"
"ひさめ 大雨 氷雨"
"ひさもと 久本"
"ひさや 久屋 久弥"
"ひさやま 久山"
"ひさゆき 尚幸"
"ひさよ 久代"
"ひさよし 久佳 久吉"
"ひさん 砒酸 飛散 悲惨"
"ひざ 膝"
"ひざあて 膝当て"
"ひざうえ 膝上"
"ひざかけ 膝掛け"
"ひざかな 乾魚 干魚"
"ひざかり 日盛り"
"ひざかんせつ 膝関節"
"ひざがしら 膝頭"
"ひざくら 緋桜"
"ひざくりげ 膝栗毛"
"ひざぐるま 膝車"
"ひざげり 膝蹴り"
"ひざこぞう 膝小僧"
"ひざし 日射 日差 陽射 日ざし 日射し 陽射し 日差し"
"ひざした 膝下"
"ひざまくら 膝枕"
"ひざもと ひざ元 膝下 膝元"
"ひざら 火皿"
"ひし ◇ 蔆 斐紙 彼此 秘史 皮脂 菱"
"ひしお 醢 醤"
"ひしおいろ 醤色"
"ひしおす 醤酢"
"ひしかり 菱刈"
"ひしかわ 菱川"
"ひしがた ◆ ◇ 菱形"
"ひしごと 日仕事"
"ひししょくぶつ 被子植物"
"ひしずめのまつり 鎮火の祭"
"ひした 菱田"
"ひしだ 菱田"
"ひしつ 皮質"
"ひしと 緊と 犇と"
"ひしぬま 菱沼"
"ひしね 菱根"
"ひしひし 緊々 犇々"
"ひしまく 皮脂膜"
"ひしもち 菱餅"
"ひしゃ 扉車 飛車"
"ひしゃかいしんど 被写界深度"
"ひしゃく 杓 柄杓"
"ひしゃたい 被写体"
"ひしゅ 秘酒 匕首 脾腫"
"ひしゅう 肥州 飛州 悲愁"
"ひしょ 秘所 避暑 秘書"
"ひしょう 婢妾 悲傷 費消 卑小 飛翔"
"ひしょうぐん 飛将軍"
"ひしょうざめ 飛翔鮫"
"ひしょうしつ 非晶質"
"ひしょうじけん 非訟事件"
"ひしょく 非職 比色"
"ひしょくしゃ 被食者"
"ひしん 秘唇 皮疹"
"ひしんけい 披針形"
"ひじ 臂 日出 樋地 肱 秘事 肘"
"ひじあて 肘当て 肘当"
"ひじうち 肘撃"
"ひじかけ 肘掛 肘掛け"
"ひじかた 土方"
"ひじかたとしぞう 土方歳三"
"ひじかわ 肱川"
"ひじき 羊栖菜 非色 非食 鹿尾菜 肘木"
"ひじきも 鹿尾菜藻"
"ひじこうげき 肘攻撃"
"ひじちょうもく 飛耳長目"
"ひじてっぽう 肘鉄砲"
"ひじてつ 肘鉄"
"ひじでっぽう 肘鉄砲"
"ひじゅう 比重"
"ひじゅつ 秘術"
"ひじゅられき ヒジュラ暦"
"ひじゅん 批准"
"ひじょ 秘女"
"ひじょう 非情 非常"
"ひじょうに 非常に"
"ひじょうべる 非常ベル"
"ひじょうほう 秘情報"
"ひじり 聖"
"ひじりがおか 聖ヶ丘"
"ひじりばし 聖橋"
"ひじんしょ 肥人書"
"ひすい 翡翠"
"ひすがら 終日"
"ひず 秘図 氷頭"
"ひずけ 日付け 日付"
"ひずみ 歪 歪み"
"ひずみりつ 歪率"
"ひずみりょう 歪量"
"ひせい 悲悽 批正"
"ひせき 砒石 碑石 飛跡 秘蹟 秘跡"
"ひせつ 秘説 飛雪"
"ひせん 卑賎 飛箭 卑賤 非戦"
"ひぜき 火堰"
"ひぜに 日銭"
"ひぜめ 火責め 火攻め"
"ひぜろ 非零 非ゼロ"
"ひぜん 肥前"
"ひそ 砒素"
"ひそう 悲想 肥痩 皮層 皮相 悲愴 悲壮"
"ひそか 密 密か"
"ひそかに 窃"
"ひそく 秘色"
"ひそひそばなし ひそひそ話"
"ひそみ 顰み"
"ひそやか 密やか"
"ひぞう 脾臓 秘蔵"
"ひぞく 匪賊 卑属 卑俗"
"ひぞっこ 秘蔵っ子"
"ひた 日田"
"ひたい 額"
"ひたいがみ 額髪"
"ひたいぎわ 額際"
"ひたいしょうまく 非対称膜"
"ひたかくし ひた隠し 直隠し"
"ひたき 鶲 火焼"
"ひたすら 頓 只管 一向"
"ひたたれ 直垂"
"ひたち 肥立 常陸 日立"
"ひたちくれじっと 日立クレジット"
"ひたちのみや 常陸宮"
"ひたちぼうかいそん 常陸坊海尊"
"ひたちまくせる 日立マクセル"
"ひたぶる 頓 一向"
"ひたむき 直向 直向き"
"ひたん 悲歎 悲嘆"
"ひだ 樋田 飛田 肥田 襞 飛騨"
"ひだい 比田井 肥大"
"ひだか 肥高 日高"
"ひだすき 火襷"
"ひだち 肥立ち"
"ひだね 火種"
"ひだひこやません 日田彦山線"
"ひだま 火玉"
"ひだまり 陽溜り 日溜り 日溜まり"
"ひだら 干鱈"
"ひだり 【 （ ＜ 『 「 ← 左"
"ひだりあごした 左顎下"
"ひだりあし 左足"
"ひだりうえ 左上"
"ひだりうえすみ 左上隅"
"ひだりうしろ 左後"
"ひだりうち 左打"
"ひだりうで 左腕"
"ひだりえだ 左枝"
"ひだりおく 左奥"
"ひだりかた 左肩"
"ひだりかっこ 『"
"ひだりがわ 左側"
"ひだりがわはし 左側端"
"ひだりきき 左利き"
"ひだりくりっく 左クリック"
"ひだりこし 左腰"
"ひだりさいど 左サイド"
"ひだりざま 左様"
"ひだりした 左下"
"ひだりしたすみ 左下隅"
"ひだりず 左図"
"ひだりぜん 左膳"
"ひだりそで 左袖"
"ひだりづかい 左遣い"
"ひだりて 左手"
"ひだりどなり 左隣"
"ひだりどもえ 左巴"
"ひだりのり 左乗"
"ひだりはし 左端"
"ひだりはじ 左端"
"ひだりはんどる 左ハンドル"
"ひだりひざ 左膝"
"ひだりひじ 左肘"
"ひだりほお 左頬"
"ひだりほほ 左頬"
"ひだりぼたん 左ボタン"
"ひだりまえ 左前"
"ひだりまき 左巻"
"ひだりみぎ 左右"
"ひだりみみ 左耳"
"ひだりむね 左胸"
"ひだりめ 左目"
"ひだりや 左矢 ←"
"ひだりやじるし ←"
"ひだりよう 左用"
"ひだりよこ 左横"
"ひだりよせ 左寄"
"ひだりより 左寄"
"ひだりわき 左脇"
"ひだるま 火ダルマ 火だるま 火達磨"
"ひだん 被弾"
"ひちくじょう 肥畜場"
"ひちそう 七宗"
"ひちゅう 秘中"
"ひちゅうのひ 秘中の秘"
"ひちょう 悲調 飛鳥"
"ひちょうきん 腓腸筋"
"ひちりき 篳篥"
"ひっ 必"
"ひっか 筆架 筆禍"
"ひっかかり 引っ掛り 引っ掛かり"
"ひっかききず 引っ掻き傷"
"ひっかく 筆画"
"ひっかけ 引っ掛け"
"ひっかん 筆管"
"ひっき 筆記"
"ひっきょう 畢竟"
"ひっきりなし 引っ切り無し"
"ひっけい 必携"
"ひっけん 筆硯 必見"
"ひっこう 筆工 筆耕"
"ひっこし 引越 引っ越し 引越し"
"ひっこみ 引込み 引っ込み"
"ひっこみじあん 引っ込み思案"
"ひっさいぼん 筆彩本"
"ひっさつ 必殺"
"ひっさん 筆算"
"ひっし 筆紙 必至 必死"
"ひっしゃ 筆写 筆者"
"ひっしゅ 必須"
"ひっしゅう 必習 必修"
"ひっしゅつ 必出"
"ひっしょう 必勝"
"ひっしょく 筆触"
"ひっす 必須"
"ひっすい 必衰"
"ひっすう 必須"
"ひっせい 筆生 筆勢 畢生"
"ひっせき 筆迹 筆蹟 筆跡"
"ひっせん 筆戦 筆洗"
"ひっそく 逼塞"
"ひったいとご ヒッタイト語"
"ひったくり 引っ手繰り"
"ひったん 筆端"
"ひっち 必置 筆致"
"ひっちゃく 必着"
"ひっちゅう 筆誅 必中"
"ひっちょう 必聴"
"ひっつめ 引っ詰め"
"ひってき 匹敵"
"ひっとう 筆答 筆頭"
"ひっときょく ヒット曲"
"ひっとさく ヒット作"
"ひっとしょうひん ヒット商品"
"ひっとすう ヒット数"
"ひっぱい 必敗"
"ひっぱく 逼迫"
"ひっぱつ 必発"
"ひっぱり 引張 引っ張り"
"ひっぱりだこ 引っ張りだこ 引っ張り蛸 引っ張り凧"
"ひっぷ 匹婦 匹夫"
"ひっぷのゆう 匹夫の勇"
"ひっぽう 筆鋒 筆法"
"ひつ 疋 匹 蹕 篳 畢 謐 逼 弼 泌 櫃 筆 必"
"ひつあつ 筆圧"
"ひつい 筆意"
"ひつう 悲痛"
"ひつき 火付き"
"ひつぎ 柩 棺"
"ひつけ 火付け"
"ひつじ 日辻 未 羊"
"ひつじかい 羊飼い"
"ひつじぐも 羊雲"
"ひつじさる 未申 坤"
"ひつじどし 未年"
"ひつじゅ 必需"
"ひつじゅつ 筆述"
"ひつじゅてきしょうひ 必需的消費"
"ひつじゅん 筆順"
"ひつじょう 必定"
"ひつじん 筆陣"
"ひつぜつ 筆舌"
"ひつぜん □ 謐然 必然"
"ひつだん 筆談"
"ひつどく 必読"
"ひつにょう 泌尿"
"ひつねい 謐寧"
"ひつば 弼馬"
"ひつばつ 必罰"
"ひつひつ 謐謐"
"ひつび 必備"
"ひつぼく 筆墨"
"ひつまぶし 櫃まぶし"
"ひつめい 筆名"
"ひつめつ 必滅"
"ひつもんひっとう 筆問筆答"
"ひつよう 必用 必要"
"ひつようあく 必要悪"
"ひつようなし 必要無"
"ひつりょく 筆力"
"ひつろく 筆録"
"ひづくり 火造り"
"ひづけ 日附 日付け 日付"
"ひづつ 火筒"
"ひづめ 蹄"
"ひてい ¬ 飛程 比定 否定"
"ひてつ 非鉄"
"ひてん 批点 飛天"
"ひてんしゅうさ 非点収差"
"ひで 映 秀 英"
"ひであき 英亮 秀章 英朗 英昭 秀昭 秀明 英明"
"ひでいち 秀市"
"ひでお 映夫 周男 秀生 秀郎 英朗 英生 日出夫 日出男 秀男 英男 秀雄 英夫 秀夫 英雄"
"ひでおき 秀起"
"ひでか 秀加 秀香"
"ひでかず 英一 英和 秀一 秀和"
"ひでかつ 英勝 秀勝"
"ひでき 偉紀 秀己 秀起 秀貴 秀規 秀記 秀紀 英紀 英樹 秀樹"
"ひできち 秀吉"
"ひできよ 英清"
"ひでこ 英子 秀子"
"ひでさく 秀作"
"ひでさち 秀幸"
"ひでさと 秀郷"
"ひでし 日出志"
"ひでじ 秀司 英司"
"ひでずみ 秀純"
"ひでぞう 秀三"
"ひでたか 英卓 栄孝 秀貴 秀孝 英孝 秀隆"
"ひでただ 秀忠"
"ひでたつ 英辰"
"ひでつぐ 秀嗣 秀次"
"ひでと 日出登 秀仁 英人 秀人"
"ひでとし 秀年 秀利 英敏 秀敏 英俊"
"ひでとも 秀智 英智"
"ひでなお 秀尚"
"ひでのぶ 英信 秀信"
"ひでのり 英紀 英憲 秀紀 英則 英典 秀則 秀典"
"ひではる 英晴 英治"
"ひでひこ 秀彦 英彦"
"ひでひさ 秀寿"
"ひでひと 英仁 秀仁"
"ひでひろ 秀宏 英宏 秀浩 英裕 秀博"
"ひでふみ 秀文"
"ひでまさ 豪将"
"ひでまる 秀丸"
"ひでみ 英巳 英実 英美 秀実 秀美"
"ひでみつ 英光 秀光"
"ひでもと 秀基"
"ひでや 秀哉 日出谷 英哉 秀也 英也"
"ひでやす 秀育 英育 秀康"
"ひでゆき 英行 英幸 秀之 英之 秀幸 秀行"
"ひでよ 秀世 英世"
"ひでよし 秀善 秀吉"
"ひでより 秀頼"
"ひでり 魃 旱 日照り"
"ひでろう 秀郎"
"ひでん 悲田 飛電 秘伝"
"ひでんいん 悲田院"
"ひでんか 比電荷 妃殿下"
"ひと 史 仁 壹 弌 壱 他人 女 費途 一 人"
"ひとあいて 人相手"
"ひとあき 仁明"
"ひとあし 人足 一足"
"ひとあしらい 人あしらい"
"ひとあじ 一味"
"ひとあせ 一汗"
"ひとあたり 人当り 人当たり"
"ひとあつめ 人集め"
"ひとあな 一穴 人穴"
"ひとあめ 一雨"
"ひとあらため 人改め"
"ひとあわ 一泡"
"ひといがい 人以外"
"ひといき 一息"
"ひといきれ 人いきれ"
"ひといくさ 一軍"
"ひといじょう 人以上"
"ひといちばい 人一倍"
"ひといろ 人色 一色"
"ひとう 比島 秘湯"
"ひとうり 人売り"
"ひとえ 單 単 一重"
"ひとえき 一駅"
"ひとえぐさ 一重草"
"ひとえに 偏に"
"ひとえばおり 単羽織"
"ひとえまぶた 一重瞼"
"ひとえもの 単物"
"ひとおじ 人怖じ"
"ひとおと 人音"
"ひとおに 人鬼"
"ひとかい 人買い"
"ひとかげ 人影"
"ひとかすみ 一霞"
"ひとかず 人数"
"ひとかた 一方"
"ひとかたならず 一方ならず"
"ひとかたまり 一塊"
"ひとかど 一廉 一角"
"ひとかぶ 一株"
"ひとからげ 一絡げ 一絡"
"ひとかわ 一皮"
"ひとかん 一缶"
"ひとがき 人垣"
"ひとがた 人像 人型 人形"
"ひとがら 人柄"
"ひときり 人斬り"
"ひときわ 一際"
"ひとぎき 人聞き"
"ひとぎらい 人嫌い"
"ひとく 秘匿"
"ひとくい 人食 人喰い 人食い"
"ひとくくり 一括り"
"ひとくせ 一癖"
"ひとくだり 一行"
"ひとくち 一口"
"ひとくに 人国 他国"
"ひとくみ 一組"
"ひとくら 一庫"
"ひとけ 人気"
"ひとけた 一桁"
"ひとこえ 一声"
"ひとこじん 人個人"
"ひとこと 一言"
"ひとことぬしのかみ 一言主神"
"ひとこま ひとコマ 一こま 一齣"
"ひところ ひと頃 一頃"
"ひとごえ 人声"
"ひとごこち 人心地"
"ひとごころ 人心"
"ひとごと 他人言 人言 人事"
"ひとごみ 人ごみ 人混み 人込み"
"ひとごろし 人殺し"
"ひとさがし 人探し"
"ひとさしゆび 人差指 人指し指 人差し指"
"ひとさま 人様"
"ひとさら 一皿"
"ひとさらい 人攫い"
"ひとさわがせ 人騒がせ"
"ひとざと 人里"
"ひとし 等し 倫史 仁史 仁司 人志 倫 仁志 斎 斉 準 均 仁 等"
"ひとしお 一塩 一入"
"ひとしくない ≠"
"ひとしだい 人次第"
"ひとしな 一品"
"ひとしれず 人知れず"
"ひとじしん 人自身"
"ひとじたい 人自体"
"ひとじち 人質"
"ひとじに 人死に 人死"
"ひとすじ 一筋"
"ひとすじなわ 一筋縄"
"ひとずき 人好き"
"ひとぜんいん 人全員"
"ひとぜんたい 人全体"
"ひとたち 人達"
"ひとたば 一束"
"ひとたび 一度"
"ひとたま 一玉"
"ひとたまり 一溜り"
"ひとだかり 人集り"
"ひとだすけ 人助け"
"ひとだね 人種"
"ひとだのみ 人頼み"
"ひとだま 人魂"
"ひとだまり 人溜り"
"ひとちがい 人違い"
"ひとっこ 人っ子"
"ひとっとび ひとっ飛び"
"ひとっぱしり ひとっ走り 一っ走り"
"ひとつ １つ 非凸 一つ"
"ひとつかま 一つ釜"
"ひとつき ひと月 一月"
"ひとつぎ 一木"
"ひとつところ 一つ所"
"ひとつばし 一ツ橋 一ッ橋 一橋"
"ひとつひとつ １つひとつ"
"ひとつぶ 一粒"
"ひとつぶえり 一粒選り"
"ひとつぶだね 一粒種"
"ひとつぼし 一つ星"
"ひとつまつ 一松"
"ひとつまみ 一撮み 一摘み"
"ひとつみ 一つ身"
"ひとつめ 一つめ"
"ひとつや 一つ家"
"ひとつら 一行 一列 一連"
"ひとづかい 人使い"
"ひとづかれ 人疲れ"
"ひとづき 人付き"
"ひとづきあい 人付合い 人付き合い"
"ひとづくり 人作り"
"ひとづて 人伝"
"ひとづま 人妻"
"ひとて 一手"
"ひとていど 人程度"
"ひとで 海星 人出 人手"
"ひとでなし 人でなし 人で無し"
"ひととき 一時"
"ひとところ 一処 一所"
"ひととせ 稘 一年"
"ひととなり 人となり 為人"
"ひとどうし 人同志 人同士"
"ひとどおり 人通り"
"ひとなか 人中"
"ひとなかせ 人泣かせ"
"ひとなつ 一夏"
"ひとなど 人等"
"ひとなみ 人並み 人並 人波"
"ひとなり 仁成"
"ひとのき 一軒"
"ひとのこ 人の子"
"ひとのみ 一飲み"
"ひとのみち 人の道"
"ひとのよ 人の代 人の世"
"ひとは 一葉"
"ひとはこ 一箱"
"ひとはし 一端"
"ひとはた 一旗"
"ひとはだ 一肌 人肌"
"ひとはな 一花"
"ひとはぶね 一葉舟"
"ひとはら 一腹"
"ひとはり 一針"
"ひとばし 人橋"
"ひとばしら 人柱"
"ひとばらい 人払い"
"ひとばん 一晩"
"ひとひ 一日"
"ひとひとり 人一人"
"ひとひねり 一ひねり"
"ひとひら 一枚 一片"
"ひとびと 人人 人びと 人々"
"ひとふくろ 一袋"
"ひとふし 一節"
"ひとふで 一筆"
"ひとふでがき 一筆書"
"ひとふゆ 一冬"
"ひとぶそく 人不足"
"ひとべらし 人減らし"
"ひとほね 一骨"
"ひとま 一間"
"ひとまえ 人前"
"ひとまかせ 人任せ"
"ひとまき 一巻"
"ひとまく 一幕"
"ひとまくみ 一幕見"
"ひとまたぎ 一跨ぎ"
"ひとまち 人待ち"
"ひとまね 人真似"
"ひとまろ 一麿 人麿 人麻呂"
"ひとみ 一美 仁美 人見 瞳"
"ひとみごくう 人身御供"
"ひとみしり 人見知り"
"ひとみすいしょう 瞳水晶"
"ひとむかし 一昔"
"ひとむね 一棟"
"ひとむら 一群 一叢"
"ひとむれ 一群"
"ひとめ ひと眼 一目 人目"
"ひとめいわく 人迷惑"
"ひとめぐり 一周り 一巡り"
"ひとめぼれ 一目惚れ"
"ひともじ 人文字"
"ひともと 一本"
"ひともなげ 人も無げ"
"ひともの 一物"
"ひとや 人屋"
"ひとやく 一役"
"ひとやま 人山 一山"
"ひとよ 一世 一夜"
"ひとよぎり 一節切"
"ひとよし 人吉"
"ひとよせ 人寄せ"
"ひとり ひとり 獨り 独 １人 独り 一人"
"ひとりあたま 一人頭"
"ひとりあたり 一人当"
"ひとりい 独り居"
"ひとりいっさつ 一人一殺"
"ひとりきり 一人きり"
"ひとりぎめ 独り決め"
"ひとりぐらし 独り暮し 独り暮らし 一人暮し 一人暮らし"
"ひとりごと 一人言 ひとり言 独り言"
"ひとりしずか 一人静"
"ひとりじめ 一人占め 独り占め"
"ひとりずまい 一人住まい"
"ひとりたび 一人旅"
"ひとりだち 一人立"
"ひとりっきり 一人っきり"
"ひとりね 独り寝"
"ひとりぼっち 一人法師 独りぼっち 一人ぼっち"
"ひとりみ 独り身"
"ひとりむすめ 一人娘"
"ひとりよがり 独り善がり"
"ひど 肥土"
"ひどいめ 酷い目"
"ひどう 非道"
"ひどけい 日時計"
"ひどこ 火床"
"ひどのらか ヒドノラ科"
"ひどらすちすあか ヒドラスチス亜科"
"ひどり 日取り"
"ひどろきしるき ヒドロキシル基"
"ひどろすたきすもく ヒドロスタキス目"
"ひな 鄙 雛"
"ひなあそび 雛遊び"
"ひなあられ 雛あられ 雛霰"
"ひない 皮内 比内"
"ひないどり 比内鶏"
"ひなか 日中"
"ひなかざり 雛飾り"
"ひながし 雛菓子"
"ひながた ひな型 雛型 ひな形 雛形"
"ひなぎく 雛菊"
"ひなげし 雛罌粟"
"ひなこ 日名子 比奈子 日向子 雛子"
"ひなずし 雛鮨"
"ひなせ 日生"
"ひなた 日向"
"ひなたぼっこ 日向ぼっこ"
"ひなだん 雛壇"
"ひなつ 日夏"
"ひなどり 雛鳥"
"ひなにんぎょう ひな人形 雛人形"
"ひなまつり 雛祭 ひな祭り 雛祭り"
"ひなまめほん 雛豆本"
"ひなもと 雛元"
"ひならず 日ならず"
"ひならずして 日ならずして"
"ひなわ 火縄"
"ひなわじゅう 火縄銃"
"ひなん 批難 非難 避難"
"ひにく 髀肉 皮肉"
"ひにち 日にち 日日 日々"
"ひにひに 日に日に"
"ひにゅう 泌乳"
"ひにょう 泌尿"
"ひにん 非人 否認 避妊"
"ひね 老成 陳"
"ひねくれもの ひねくれ者 捻くれ者"
"ひねしょうが 陳生姜"
"ひねずみ 火鼠"
"ひねつ 比熱"
"ひねの 日根野"
"ひねもす 終日"
"ひねり 捻り"
"ひねん 比年"
"ひの 樋野 火野 日野"
"ひのいり 日入 日の入り"
"ひのうち 日の中"
"ひのうみ 火の海"
"ひのえ 丙"
"ひのえいぬ 丙戌"
"ひのえうま 丙午"
"ひのえさる 丙申"
"ひのえたつ 丙辰"
"ひのえとら 丙寅"
"ひのえね 丙子"
"ひのえまた 桧枝岐 檜枝岐"
"ひのおか 日ノ岡"
"ひのかげ 日之影"
"ひのかみ 日の神 火の神"
"ひのき 桧 檜"
"ひのきぶたい 檜舞台 桧舞台"
"ひのきぶろ 檜風呂"
"ひのくち 樋の口 樋ノ口"
"ひのくま 日隈"
"ひのくるま 火の車"
"ひのけ 火の気"
"ひのこ 火の粉"
"ひのたま 火の玉"
"ひのて 火の手"
"ひので 日之出 日出 日の出"
"ひのと 丁"
"ひのとい 丁亥"
"ひのとう 丁卯"
"ひのとうし 丁丑"
"ひのととり 丁酉"
"ひのとひつじ 丁未"
"ひのとみ 丁巳"
"ひのとり 火の鳥"
"ひのはら 桧原"
"ひのはる 日之春"
"ひのべ 日延べ"
"ひのまる 日の丸"
"ひのまわり 火の回り"
"ひのみ 火の見"
"ひのみこ 日の御子"
"ひのみさき 日御崎 日御碕"
"ひのみやぐら 火の見櫓"
"ひのめ 日の目"
"ひのもと 火の元 日の本"
"ひのもり 日野森"
"ひのようじん 火の用心"
"ひはい 疲憊"
"ひはく 皮帛 菲薄"
"ひはつ 被髪"
"ひはなち 樋放"
"ひはら 日原"
"ひはん 批判"
"ひば 比婆"
"ひばい 非売 肥培"
"ひばかま 緋袴"
"ひばかり 日計"
"ひばく 被縛 飛瀑 被曝 被爆"
"ひばこ 火箱"
"ひばご 卑罵語"
"ひばし 火箸"
"ひばしら 火柱"
"ひばち 火鉢"
"ひばな 火花"
"ひばら 脾腹 檜原 桧原"
"ひばり 告天子 雲雀"
"ひばん 非番"
"ひひ 狒々 比々 霏々 霏霏 比比 狒狒"
"ひひょう 批評"
"ひび 日比 皸 罅 皹 日日 日々"
"ひびき 響 響き"
"ひびこれこうじつ 日々是好日"
"ひびつ 火櫃"
"ひびの 日比野"
"ひびや 日比谷"
"ひびょういん 避病院"
"ひびわれ ひび割れ 罅割れ"
"ひふ 非負 被布 皮膚"
"ひふがん 皮膚ガン 皮膚がん 皮膚癌"
"ひふきだけ 火吹き竹"
"ひふく 被服 被覆"
"ひふくき 被覆木"
"ひふくきん 腓腹筋"
"ひふくぎ 被覆木"
"ひふみ 一二三 日文"
"ひふん 悲憤"
"ひぶ 秘部 日歩"
"ひぶせ 火伏せ"
"ひぶた 火蓋"
"ひぶつ 秘仏"
"ひぶん 非文 非分 碑文"
"ひぶんしょう 飛蚊症"
"ひへい 疲弊"
"ひへん 日偏 火偏"
"ひほう 飛報 秘方 非法 悲報 秘法 秘宝"
"ひほん 秘本"
"ひぼう 非望 誹謗"
"ひぼし 日干"
"ひぼたん 緋牡丹"
"ひぼん 非凡"
"ひま 蓖麻 隙 閑 暇"
"ひまく 被膜 皮膜"
"ひまご 曾孫"
"ひまし 日増し"
"ひましに 日増しに"
"ひましゆ ひまし油 ヒマシ油"
"ひまじん 閑人 暇人"
"ひまち 日待ち"
"ひまつ 飛沫"
"ひまつぶし 暇つぶし 暇潰し"
"ひまつり 火祭り 火祭"
"ひまひま 暇暇 暇々"
"ひまらやすぎ ヒマラヤ杉"
"ひまわり 火回り 向日葵"
"ひまわりゆ ひまわり油"
"ひまん 肥満"
"ひまんたんどらか ヒマンタンドラ科"
"ひみ 氷見"
"ひみこ 日美子 卑弥呼"
"ひみつ 秘密"
"ひみつかぎ 秘密鍵"
"ひみょう 秘妙"
"ひみん 卑民"
"ひむか 日向"
"ひむかい 日向"
"ひむら 日村"
"ひむろ 氷室"
"ひめ 媛 姫"
"ひめい 非命 碑銘 悲鳴"
"ひめかいどう 姫街道"
"ひめかわ 姫川"
"ひめがみ 比売神 姫神"
"ひめがわ 姫川"
"ひめき 姫木"
"ひめぎみ 姫君"
"ひめくり 日めくり 日捲り"
"ひめこ 姫子"
"ひめごぜ 姫御前"
"ひめごと 秘め事"
"ひめさま 姫様"
"ひめしま 姫島"
"ひめしんせん 姫新線"
"ひめじ 姫路"
"ひめじどっきょうだいがく 姫路獨協大学"
"ひめじひがし 姫路東"
"ひめじま 姫嶋"
"ひめたけ 姫竹"
"ひめど 姫戸"
"ひめの 姫野"
"ひめのき 姫乃樹"
"ひめのぎ 姫乃樹 姫ノ樹"
"ひめはじめ 姫始め"
"ひめまつ 姫松"
"ひめみこ 姫御子"
"ひめみや 姫宮"
"ひめゆり 姫百合"
"ひめゆりぶたい ひめゆり部隊"
"ひめん 罷免"
"ひも 綬 紐"
"ひもう 被毛"
"ひもく 皮目 費目"
"ひもくぎょ 比目魚"
"ひもじ 緋文字 火文字"
"ひもじょう 紐状"
"ひもすがら 終日"
"ひもち 火持ち 日保ち 日持ち"
"ひもつき 紐付き"
"ひもつけ 紐付け"
"ひもと 火元"
"ひもとおし 紐通し"
"ひもの 檜物 干物"
"ひもぱん 紐パン"
"ひもよう 紐用"
"ひもろぎ 神籬 胙"
"ひもん 秘文"
"ひもんじ 緋文字"
"ひもんや 碑文谷"
"ひゃく 珀 辟 襞 岶 百"
"ひゃくい 百位"
"ひゃくいち 百一"
"ひゃくえん 百円"
"ひゃくえんだま 百円玉"
"ひゃくえんらいたー 百円ライター"
"ひゃくおく 百億"
"ひゃくがい 百害"
"ひゃくぎょう 百行"
"ひゃくげん 百元"
"ひゃくごぎんこう 百五銀行"
"ひゃくしきしてい 百式司偵"
"ひゃくしぜんしょ 百子全書"
"ひゃくしゃくかんとう 百尺竿頭"
"ひゃくしゅうねん 百周年"
"ひゃくしゅつ 百出"
"ひゃくしょう 百勝 百姓"
"ひゃくしょうや 百姓家"
"ひゃくじ 百事"
"ひゃくじゅう 百獣"
"ひゃくすうじゅう 百数十"
"ひゃくせい 百世"
"ひゃくせつ 百折"
"ひゃくせん 百千 百戦 百選"
"ひゃくそく 百足"
"ひゃくたい 百態"
"ひゃくたけ 百武"
"ひゃくたたき 百叩き"
"ひゃくたろう 百太郎"
"ひゃくだい 百代"
"ひゃくだいいじょう 百台以上"
"ひゃくちょう 百兆"
"ひゃくてんまんてん 百点満点"
"ひゃくど 百度"
"ひゃくどまいり 百度参り"
"ひゃくにじゅうにち 百二十日"
"ひゃくにち 百日"
"ひゃくにちいも 百日芋"
"ひゃくにちぜき 百日咳"
"ひゃくにちそう 百日草"
"ひゃくにん 百人"
"ひゃくにんひゃくよう 百人百様"
"ひゃくにんりき 百人力"
"ひゃくねん 百年"
"ひゃくねんのけい 百年の計"
"ひゃくはちじゅうど 百八十度"
"ひゃくはちぼんのう 百八煩悩"
"ひゃくばい 百倍"
"ひゃくひろ 百尋"
"ひゃくぶん 百分 百聞"
"ひゃくまい 百枚"
"ひゃくまた 百又"
"ひゃくまん 百万"
"ひゃくまんだら 百万陀羅"
"ひゃくまんりょう 百萬両"
"ひゃくみ 百味"
"ひゃくみだんす 百味箪笥"
"ひゃくめ 百目"
"ひゃくめいざん 百名山"
"ひゃくめんそう 百面相"
"ひゃくもじ 百文字"
"ひゃくものがたり 百物語"
"ひゃくやく 百薬"
"ひゃくやくのちょう 百薬の長"
"ひゃくようばこ 百葉箱"
"ひゃくらい 百雷"
"ひゃくり 百里"
"ひゃくりょう 百僚"
"ひゃくれつ 百裂"
"ひゃくれん 百錬"
"ひゃくれんぱつ 百連発"
"ひゃくろん 百論"
"ひゃっか 百家 百貨 百花 百科"
"ひゃっかい 百回"
"ひゃっかせいほう 百花斉放"
"ひゃっかそうめい 百家争鳴"
"ひゃっかん 百官 百貫"
"ひゃっき 百鬼"
"ひゃっきん 百均"
"ひゃっけい 百計 百景"
"ひゃっけん 百見 百間"
"ひゃっこう 百行"
"ひゃっぱつ 百発"
"ひゃっぱつひゃくちゅう 百発百中"
"ひゃっぱん 百般"
"ひゃっぴき 百匹"
"ひゃっぴょう 百票"
"ひゃっぺん 百遍"
"ひゃっぽ 百歩"
"ひゃっぽう 百方"
"ひゃっぽだ 百歩蛇"
"ひや 冷や 火屋"
"ひやあせ 冷汗 冷や汗"
"ひやかし 冷やかし 素見"
"ひやく 秘鑰 非役 秘薬 飛躍"
"ひやけ 日焼 日焼け"
"ひやけどめ 日焼け止め 日焼止め"
"ひやざけ 冷酒"
"ひやし 冷やし"
"ひやしちゅうか 冷し中華"
"ひやとい 日雇い"
"ひやま 樋山 日山 桧山 檜山"
"ひやみず 冷水 冷や水"
"ひやみづ 冷水"
"ひやむぎ 冷麦"
"ひやめし 冷飯 冷や飯"
"ひややか 冷やか"
"ひややっこ 冷や奴 冷奴"
"ひゅーむかん ヒューム管"
"ひゅうが 日向"
"ひゅうがなだ 日向灘"
"ひゅうま 飛雄馬"
"ひゆ 譬喩 比喩"
"ひょう 凭 平 兵 俵 拍 髟 驫 飆 殍 彪 憑 馮 冫 冰 氷 驃 飃 飄 縹 慓 嫖 剽 瓢 漂 標 評 雹 票 豹 表"
"ひょうあつめ 票集め"
"ひょうい 表意 憑依"
"ひょういつ 飄逸"
"ひょういれ 票入"
"ひょういん 平韻"
"ひょうえ 兵衛"
"ひょうおん 氷温 表音"
"ひょうか 瓢果 評家 氷花 氷菓 評価"
"ひょうかい 氷海 氷塊 氷解"
"ひょうかおち 評価落"
"ひょうかく 嫖客"
"ひょうかん 慓悍 剽悍 氷冠"
"ひょうが 氷河"
"ひょうがい 表外"
"ひょうがわ 豹皮"
"ひょうき 兵機 標旗 氷期 標記 表記"
"ひょうきへい 驃騎兵"
"ひょうきゅう 氷球"
"ひょうきょ 憑拠"
"ひょうきん 標金 剽軽"
"ひょうきんもの ひょうきん者"
"ひょうぎ 評議"
"ひょうぎん 兵銀"
"ひょうぐ 表具"
"ひょうぐみ 表組み"
"ひょうぐやぶし 表具屋節"
"ひょうけい 表敬"
"ひょうけいさん 表計算"
"ひょうけいしき 表形式"
"ひょうけつ 票決 評決 表決 氷結"
"ひょうけん 憑険 憑肩"
"ひょうけんさく 表検索"
"ひょうけんだいり 表見代理"
"ひょうげん 評言 氷原 表現"
"ひょうげんのじゆう 表現の自由"
"ひょうこう 標高"
"ひょうご 評語 標語 兵庫"
"ひょうごもじ 表語文字"
"ひょうごりょう 兵庫寮"
"ひょうさ 票差"
"ひょうさくさん 氷酢酸"
"ひょうさつ 標札 表札"
"ひょうざい 表在"
"ひょうざん 氷山"
"ひょうし 拍子 表紙"
"ひょうしき 表式 標識"
"ひょうしぎ 拍子木"
"ひょうしつ 氷室"
"ひょうしゃ 評者"
"ひょうしゃく 評釈"
"ひょうしゅつ 表出"
"ひょうしょ 表書"
"ひょうしょう 平声 氷晶 氷床 標章 表象 表彰"
"ひょうしょく 氷食"
"ひょうじ 憑恃 票時 標示 表示"
"ひょうじざか 表示坂"
"ひょうじばん 表示板"
"ひょうじまど 表示窓"
"ひょうじゃ 評者"
"ひょうじゅん 標準"
"ひょうじゅんかかくまい 標準価格米"
"ひょうじゅんき 標準軌"
"ひょうじゅんのう 標準脳"
"ひょうじょう 平調 評定 氷上 表情"
"ひょうじん 氷人"
"ひょうすう 票数"
"ひょうせき 漂石"
"ひょうせつ 評説 剽窃 氷雪"
"ひょうぜん 飄然"
"ひょうそう 氷層 表装 表層"
"ひょうそうぎょ 表層魚"
"ひょうそく 平仄 表側"
"ひょうぞう 氷像"
"ひょうたん 氷炭 瓢箪"
"ひょうたんなまず 瓢箪鯰"
"ひょうだい 標題 表題"
"ひょうだん 評壇"
"ひょうちゃく 漂着"
"ひょうちゅう 評注 標註 評註 標注 氷中 標柱 氷柱 表中"
"ひょうちょう 憑弔 標徴 漂鳥 表徴"
"ひょうちょうせき 氷長石"
"ひょうちん 氷枕"
"ひょうてい 標定 評定"
"ひょうていそくど 表定速度"
"ひょうてき 標的"
"ひょうてん 瓢天 氷点 評点"
"ひょうでん 票田 評伝"
"ひょうとう 表頭"
"ひょうど 表土"
"ひょうどう 兵頭 兵藤"
"ひょうのう 氷嚢"
"ひょうはく 表白 漂泊 漂白"
"ひょうばく 氷瀑"
"ひょうばん 評判"
"ひょうばんごう 表番号"
"ひょうひ 表皮"
"ひょうひょう 瓢々 飄飄 飄々"
"ひょうび 豹尾"
"ひょうびょう 縹眇 縹緲 縹渺"
"ひょうふう 飄風"
"ひょうぶ 兵部"
"ひょうへき 表壁 氷壁"
"ひょうへん 豹変"
"ひょうほう 兵法"
"ひょうほん 標本"
"ひょうほんびん 標本瓶"
"ひょうぼう 標榜"
"ひょうま 豹馬"
"ひょうむ 氷霧"
"ひょうめい 表明"
"ひょうめん 表面"
"ひょうめんせき 表面積"
"ひょうもく 標目"
"ひょうもん 豹紋 平文"
"ひょうよみ 票読み"
"ひょうり 表裏"
"ひょうりゅう 漂流"
"ひょうりょう 兵糧 秤量"
"ひょうりん 評林"
"ひょうれい 憑霊"
"ひょうろう 兵粮 兵糧"
"ひょうろん 評論"
"ひよ 鵯"
"ひよう 日傭 比容 飛揚 費用"
"ひようしゃ 被用者"
"ひようたいこうか 費用対効果"
"ひよく 比翼 肥沃"
"ひよくのとり 比翼の鳥"
"ひよけ 日避け 火除け 日除け"
"ひよこ 雛"
"ひよこまめ 雛豆"
"ひよし 日義 日吉"
"ひよどり 鵯"
"ひよどりごえ 鵯越"
"ひより 日和"
"ひよりざき 日和崎"
"ひよりみ 日和見"
"ひよわ ひ弱"
"ひら 曹白魚 比良 衡 片 平"
"ひらあやまり 平謝り"
"ひらい 平井 避雷 飛来"
"ひらいし 平石"
"ひらいしん 避雷針"
"ひらいずみ 平泉"
"ひらいで 平出"
"ひらいと 平糸"
"ひらいわ 平岩"
"ひらうち 平打 平打ち"
"ひらお 平生 平尾"
"ひらおか 平岡"
"ひらおし 平押し"
"ひらおよぎ 平泳 平泳ぎ"
"ひらおり 平織り 平織"
"ひらか 平鹿 平賀"
"ひらかた 平形 枚方"
"ひらかな 平仮名"
"ひらかわ 平河 平川"
"ひらが 平賀"
"ひらがた 平型"
"ひらがな 平假名 平仮名"
"ひらがなひょうき ひらがな表記"
"ひらがま 平釜"
"ひらがわら 平瓦"
"ひらき 開 平木"
"ひらきかげん 開き加減"
"ひらきど 開き戸"
"ひらきなおり 開き直り"
"ひらきふう 開き封"
"ひらぎぬ 平絹"
"ひらく 啓"
"ひらこ 平子"
"ひらこう 平光"
"ひらさわ 平澤 平沢"
"ひらざら 平皿"
"ひらざわ 平澤"
"ひらしま 平嶋 平島"
"ひらしゃいん 平社員"
"ひらじ 平地"
"ひらじょう 平城"
"ひらじろ 平城"
"ひらせ 平瀬"
"ひらぞこ 平底"
"ひらた 枚田 平田"
"ひらたあつたね 平田篤胤"
"ひらたけ 平茸"
"ひらたに 平谷"
"ひらだい 平台"
"ひらち 平地"
"ひらつか 平塚"
"ひらつぼ 平坪"
"ひらづみ 平積み"
"ひらて 平手"
"ひらで 平出"
"ひらと 平戸"
"ひらとじ 平綴じ"
"ひらとり 平取"
"ひらど 平戸"
"ひらどま 平土間"
"ひらない 平内"
"ひらなか 平中"
"ひらなが 平長"
"ひらなべ 平鍋"
"ひらにわ 平庭"
"ひらぬま 平沼"
"ひらね 平根"
"ひらの 平野"
"ひらはし 平橋"
"ひらはら 平原"
"ひらば 平場"
"ひらばやし 平林"
"ひらばり 平針"
"ひらばる 平原"
"ひらひも 平紐"
"ひらび 平日"
"ひらふく 平福"
"ひらぶたい 平舞台"
"ひらぶち 平縁"
"ひらぶん 平文"
"ひらま 平間"
"ひらまく 平幕"
"ひらまつ 平松"
"ひらみち 平道"
"ひらみつ 平光"
"ひらめ 比目魚 鮃 平目"
"ひらめき 閃き"
"ひらもと 平本"
"ひらや 平谷 平屋"
"ひらやだて 平屋建"
"ひらやね 平屋根"
"ひらやま 平山"
"ひらゆ 平湯"
"ひらら 平良"
"ひり 非理"
"ひりき 非力"
"ひりつ 比率"
"ひりゅう 飛竜 飛龍"
"ひりゅうづ 飛竜頭"
"ひりょう 肥料"
"ひりょうず 飛竜頭"
"ひりょうてき 比量的"
"ひりょく 臂力 非力"
"ひりん 比倫 比隣"
"ひる 簸 葫 晝 蒜 蛭 昼"
"ひるあんどん 昼行灯"
"ひるい 比類"
"ひるいし 蛭石"
"ひるいち 昼一"
"ひるかわ 比留川 蛭川"
"ひるがお 昼顔"
"ひるがた 昼型"
"ひるげ 昼餉"
"ひるこ 蛭子"
"ひるころ 昼頃"
"ひるごはん 昼ご飯 昼御飯"
"ひるごろ 昼頃"
"ひるさがり 昼下 昼下り 昼下がり"
"ひるざけ 昼酒"
"ひるすぎ 昼過 昼過ぎ"
"ひるせん 蒜山"
"ひるぜん 蒜山"
"ひるぜんご 昼前後"
"ひるた 蛭田"
"ひるてい 昼定"
"ひるどき 昼時"
"ひるなか 昼中"
"ひるね 昼寝"
"ひるひなか 昼日中"
"ひるべるとくうかん ヒルベルト空間"
"ひるま 晝間 昼間"
"ひるまえ 昼前"
"ひるむしろもく ヒルムシロ目"
"ひるめし 昼メシ 昼飯"
"ひるめろ 昼メロ"
"ひるやすみ 昼休み"
"ひれ 領巾 肩巾 鰭"
"ひれあしるい 鰭脚類"
"ひれい ∝ 非礼 比例"
"ひれき 飛礫 披瀝"
"ひれつ 卑劣"
"ひれつかん 卑劣漢"
"ひれにく ヒレ肉"
"ひれん 悲恋"
"ひれんじゃく 緋連雀"
"ひろ 愽 仭 仞 絋 恕 宥 紘 伯 洪 比呂 廣 拡 拓 泰 啓 祐 寛 弘 浩 央 裕 宏 博 史 洋 太 広 大 尋"
"ひろあき 宏顕 祐昭 祐彰 洋晶 弘朗 浩秋 広章 広朗 宏朗 洋昭 宏晃 浩晃 弘昭 啓明 広昭 洋明 寛明 裕昭 浩昭 宏昭 博章 裕章 裕明 浩明 広明 博昭 博明 弘明 宏明"
"ひろあきら 寛晰"
"ひろい 広井"
"ひろいぐい 拾い喰い 拾い食い"
"ひろいけ 廣池 広池"
"ひろいご 拾い子"
"ひろいし 広石"
"ひろいぬし 拾い主"
"ひろいもの 拾い物"
"ひろいよみ 拾い読み"
"ひろう 疲勞 疲労 披露"
"ひろうす 飛竜頭"
"ひろうち 浩内"
"ひろえ 広絵 浩恵 宏江 裕江 弘枝 宏枝 廣江 広恵 浩江 広江"
"ひろえん 広縁"
"ひろお 博生 洋男 宏雄 洋夫 博雄 浩生 広尾"
"ひろおか 弘岡 広岡"
"ひろか 祥加 裕香"
"ひろかず 博万 大一 泰一 浩和 裕和 博和 弘一 宏和 浩一 博一"
"ひろかみ 広神"
"ひろかわ 紘川 廣川 広川"
"ひろがり 広がり"
"ひろがわ 広川"
"ひろき 裕毅 寛己 啓樹 寛紀 央樹 浩喜 宏喜 博己 浩基 弘城 博基 浩貴 洋樹 弘毅 博紀 裕紀 裕貴 博樹 裕樹 広樹 宏樹 弘樹"
"ひろきち 広吉"
"ひろく 秘録"
"ひろくち 広口"
"ひろくに 裕邦"
"ひろぐ 弘具"
"ひろこ 欧子 宙子 紘子 宏子 倫子 広子 弘子 博子 ひろ子 浩子 寛子 裕子"
"ひろこうじ 広小路"
"ひろさ 広さ"
"ひろさか 広坂"
"ひろさき 広崎 弘前"
"ひろさと 宏郷 浩郷"
"ひろさわ 廣沢 廣澤 広沢"
"ひろし 廣 愽 熈 広史 啓志 大史 浩士 廣志 宏史 大士 宏志 宏司 熙 煕 弘司 弘史 裕志 啓之 比呂志 洋史 博志 洋司 裕史 博嗣 弘志 大志 広司 博司 広志 ひろ志 浩志 裕司 浩史 博史 浩司 央 泰 広 博士 寛 裕 弘 浩 宏 洋 博 大"
"ひろしき 広敷"
"ひろしげ 浩重 博茂 広重"
"ひろしま 広島"
"ひろしまがす 広島ガス"
"ひろしまきた 広島北"
"ひろしまぎんこう 廣島銀行"
"ひろしまくれどうろ 広島呉道路"
"ひろしまだい 広島大学"
"ひろしまひがし 広島東"
"ひろしまやき 広島焼"
"ひろしょう 広商"
"ひろじ 広治 宏治"
"ひろすえ 広末"
"ひろせ 廣瀬 広瀬"
"ひろせどおり 広瀬通"
"ひろぜがわ 広瀬川"
"ひろそで 広袖"
"ひろぞう 弘蔵"
"ひろた 弘田 廣田 広田"
"ひろたか 宏孝 宏貴 弘崇 浩貴 浩孝 宏高 博孝 宏隆 弘隆"
"ひろたき 広瀧"
"ひろたけ 博丈"
"ひろただ 裕忠 博唯"
"ひろたつ 広達"
"ひろたに 広谷"
"ひろたまみ 広田まみ"
"ひろだい 広島大学 弘大 広大"
"ひろつ 広津"
"ひろつぐ 裕次 博次 博嗣"
"ひろづ 広津"
"ひろでん 広電"
"ひろと 浩登 寛人 博人 裕人"
"ひろとし 宏寿 浩俊"
"ひろとも 寛知 弘具"
"ひろなお 弘直 弘尚"
"ひろなか 弘仲 弘中 広中"
"ひろなが 広長"
"ひろにわ 広庭"
"ひろの 広野"
"ひろのぶ 弘宜 弘宣 博宣 宏伸 広宣 裕信 博信"
"ひろのみや 浩宮"
"ひろのり 弘法 博典 裕徳 広徳 浩則 博徳 博則 博紀"
"ひろはし 広橋"
"ひろはば 広幅"
"ひろはばとびら 広幅扉"
"ひろはら 広原"
"ひろば 広場"
"ひろひこ 恕彦 洋彦 浩彦 飛呂彦 博彦 裕彦"
"ひろひさ 浩寿 浩久 博久 裕久"
"ひろひと 宏仁 裕人 博人 裕仁"
"ひろびろ 広々"
"ひろふみ 洋典 廣文 大史 弘史 洋史 寛文 裕文 洋文 宏文 啓文 博史 弘文 博文"
"ひろぶみ 弘史 浩史 博文"
"ひろべ 広部"
"ひろま 広間"
"ひろまえ 広前"
"ひろまさ 弘真 弘征 裕昌 洋正 広正 弘昌 裕真 浩正 宏昌"
"ひろまつ 広松 廣松"
"ひろまど 広窓"
"ひろみ 拡稔 引美 弘海 浩巳 弘巳 博己 比呂美 広見 ひろ美 寛美 裕実 洋美 浩美 宏美 弘美 博美 裕美 広美"
"ひろみち 晃道 拓路 寛道 広道 博道 弘道"
"ひろみつ 博允 博三 廣光 広光 博満 宏光 弘光 博光"
"ひろめ 広め 披露目"
"ひろもち 裕望"
"ひろや 浩也 博也"
"ひろやす 容靖 弘安 博泰 浩靖 博保 浩康 弘康 大和 裕康 博康"
"ひろゆき 幸展 裕由 陽之 弘恭 周行 洋征 弘征 祐之 広行 宏行 広幸 浩幸 広之 裕行 洋之 弘行 裕幸 啓之 宏幸 博行 弘幸 博幸 寛之 宏之 弘之 裕之 浩之 博之"
"ひろよし 敬昌 寛善 浩喜 弘恭 博芳 浩由 博喜 博義"
"ひろん 比論"
"ひわ 比和 鶸 悲話 秘話"
"ひわい 卑わい 鄙猥 卑猥"
"ひわいろ 鶸色"
"ひわき 樋脇"
"ひわさ 日和佐"
"ひわさき 日和崎"
"ひわたり 日渡 樋渡 火渡り"
"ひわだ 檜皮"
"ひわだぶき 檜皮葺き"
"ひわちゃ 鶸茶"
"ひわり 日割り 日割"
"ひわれ 干割れ"
"ひん 顰 彬 斌 浜 濱 殯 繽 擯 嬪 賓 禀 稟 蘋 瀕 頻 貧 牝 品"
"ひんい 品位"
"ひんか 貧家"
"ひんかい 頻回"
"ひんかく 賓格 賓客 品格"
"ひんかくほう 品確法"
"ひんかん 貧寒"
"ひんきゃく 賓客"
"ひんきゅう 殯宮 貧窮"
"ひんぎ 稟議"
"ひんく 貧苦"
"ひんけい 牝鶏 牝系"
"ひんけつ 貧血"
"ひんこう 貧鉱 品行"
"ひんこん 貧困"
"ひんし 品詞 瀕死"
"ひんしつ 稟質 品質"
"ひんしもく 貧歯目"
"ひんしゅ 品種"
"ひんしゅく 顰蹙"
"ひんしゅつ 瀕出 頻出"
"ひんしょう 貧小"
"ひんしるい 貧歯類"
"ひんじ 賓辞"
"ひんじゃ 貧者"
"ひんじゃく 貧弱"
"ひんじょ 貧女"
"ひんすう 頻数"
"ひんずーきょう ヒンズー教"
"ひんせい 稟性 品性"
"ひんせき 擯斥"
"ひんせん 貧賤"
"ひんそ 貧素"
"ひんそう 貧僧 貧相"
"ひんそん 貧村"
"ひんだ 貧打"
"ひんてき 貧的"
"ひんでぃーご ヒンディー語"
"ひんでぃご ヒンディ語"
"ひんとう 品等"
"ひんど 貧土 頻度"
"ひんどう 貧道"
"ひんにゅう 貧乳"
"ひんにょ 貧女"
"ひんにょう 頻尿"
"ひんのう 貧農"
"ひんば 牝馬"
"ひんばん 品番"
"ひんぱく 頻拍"
"ひんぱつ 頻発"
"ひんぱん 頻繁"
"ひんぴょう 品評"
"ひんぴん 頻々"
"ひんぷ 稟賦 貧富"
"ひんぷん 繽紛"
"ひんみゃく 頻脈"
"ひんみん 貧民"
"ひんみんくつ 貧民窟"
"ひんめい 品名"
"ひんもく 品目"
"ひんよう 頻用"
"ひんよく 品良く"
"び 比 贔 弭 寐 未 靡 麋 縻 糜 糒 備 瀰 濔 毘 琵 枇 嵋 媚 眉 火 日 鼻 微 尾 美"
"びーがた Ｂ型"
"びーきゅう Ｂ級"
"びーさいぼう Ｂ細胞"
"びーだま ビー玉"
"びーばん Ｂ判"
"びーふん 米粉"
"びーぷおん ビープ音"
"びーめん Ｂ面"
"びーる 麦酒"
"びーるけん ビール券"
"びーるばら ビール腹"
"びーるびん ビール瓶"
"びあだる ビア樽"
"びい 微意"
"びいん 鼻音"
"びいんとう 鼻咽頭"
"びう 眉宇 微雨"
"びえい 美瑛"
"びえん 鼻炎"
"びおとーぷ ビオトープ"
"びおん 微音 微温 鼻音 美音"
"びか 微瑕 美果 美化"
"びかん 美感 美観"
"びがく 美学"
"びがん 美顔"
"びき 美肌 引 引き 匹 美姫"
"びきにすがた ビキニ姿"
"びきゃく 美脚"
"びきゅう 備給"
"びきょ 美挙"
"びきょう 鼻鏡"
"びぎ 美妓 美技"
"びぎん 微吟"
"びく 魚篭 魚籠 比丘"
"びくう 鼻腔"
"びくに 比丘尼"
"びくん 微醺"
"びけい 美景 美形"
"びげいこう 美藝公"
"びげん 美言 微減"
"びこう 微行 備荒 鼻口 微光 微香 鼻孔 鼻腔 尾行 備考"
"びこうせい 微光星"
"びこつ 尾骨 鼻骨"
"びこん 鼻根"
"びご 寐語"
"びさ 微差"
"びさい 尾西 微細"
"びさん 靡散"
"びざい 微罪"
"びし 微視"
"びしつ 美質"
"びしゃ 飛車"
"びしゃもん 毘沙門"
"びしゃもんてん 毘沙門天"
"びしゅ 美酒"
"びしゅう 備州 尾州 美醜"
"びしゅく 糜粥"
"びしゅっけつ 鼻出血"
"びしょう 媚笑 微傷 美粧 美称 微少 微小 微笑"
"びしょく 美食"
"びしょぬれ びしょ濡れ"
"びしり 美尻"
"びしん 美身 微震 美神"
"びじ 鼻茸 美辞"
"びじく 糜竺"
"びじねすし ビジネス誌"
"びじゃく 微弱"
"びじゅあるけい ビジュアル系"
"びじゅう 鼻汁"
"びじゅつ 美術"
"びじゅついん 美術院"
"びじょ 美女"
"びじょう 鼻茸 尾錠"
"びじょぎ 美女木"
"びじょざくら 美女桜"
"びじん 美人"
"びすい 微酔 微睡"
"びせい 美星 美声"
"びせき 微積"
"びせつ 微雪"
"びせん 微賤 美泉"
"びぜん 靡然 美髯 備前"
"びぜんやき 備前焼"
"びそ 鼻祖"
"びそう 美装"
"びそうじゅつ 美爪術"
"びそく 尾側 微速"
"びぞう 微増"
"びぞく 美俗"
"びた 鐚"
"びたい 額 媚態"
"びたいちもん 鐚一文"
"びたせん 鐚銭"
"びたみんいー ビタミンE ビタミンＥ"
"びたみんえー ビタミンA ビタミンＡ"
"びたみんけー ビタミンK ビタミンＫ"
"びたみんざい ビタミン剤"
"びたみんしー ビタミンC ビタミンＣ"
"びたみんでぃー ビタミンD ビタミンＤ"
"びたみんびー ビタミンB ビタミンＢ"
"びたみんるい ビタミン類"
"びたん 尾端"
"びだい 尾大"
"びだくおん 鼻濁音"
"びだん 美談"
"びちく 備蓄"
"びちくまい 備蓄米"
"びちゅう 微衷"
"びちゅうかく 鼻中隔"
"びちょう 微調"
"びっくり ！ 吃驚"
"びっくりぎょうてん びっくり仰天"
"びっくりばこ びっくり箱"
"びっくりみず びっくり水"
"びっこ 跛"
"びっちゅう 備中"
"びっちゅうぐわ 備中鍬"
"びっとすう ビット数"
"びっとれつ ビット列"
"びつ 謐"
"びていこつ 尾てい骨"
"びてき 美的"
"びてん 美点"
"びでおがぞう ビデオ画像"
"びでおてん ビデオ店"
"びでん 美田"
"びと 人"
"びとう 尾藤 尾筒 微糖 尾灯"
"びとく 美徳"
"びどう 美道 美童 微動"
"びなん 美男"
"びにーるがさ ビニール傘"
"びにーるせい ビニール製"
"びにーるぶくろ ビニール袋"
"びにぼん ビニ本"
"びにゅう 微乳 美乳"
"びにるじゅし ビニル樹脂"
"びねつ 微熱"
"びねんまく 鼻粘膜"
"びはく 靡薄 美白"
"びはだ 美肌"
"びはつ 美髪"
"びばい 美唄"
"びひん 美品 備品"
"びび 靡靡 微々"
"びびたる 微々たる"
"びふぃずすきん ビフィズス菌"
"びふう 美風 微風"
"びふえ 美笛"
"びふか 美深"
"びふく 微服 美服"
"びふん 微粉"
"びぶ 尾部"
"びぶん 美文 微分"
"びへい 靡敝 尾柄 鼻閉"
"びへいそく 鼻閉塞"
"びほう 彌縫 備砲 弥縫"
"びほろ 美幌"
"びほん 美本"
"びぼいん 鼻母音"
"びぼう 微茫 備忘 美貌"
"びぼうじん 未亡人"
"びまん 弥漫 靡曼 瀰漫"
"びみ 美味"
"びみょう 美妙 微妙"
"びめい 美名"
"びもく 眉目"
"びもん 鼻紋"
"びゃく 辟 帛 白 闢 百"
"びゃくい 白衣"
"びゃくえ 白衣"
"びゃくごう 白毫"
"びゃくしん 柏槙"
"びゃくじゅつ 白朮"
"びゃくだん 白檀"
"びゃくだんもく ビャクダン目"
"びゃくや 白夜"
"びゃくり 白痢"
"びゃくれん 白蓮"
"びゃくろく 白緑"
"びゃっこ 白狐 白虎"
"びやく 媚薬"
"びやだる ビヤ樽"
"びゅう 繆 謬"
"びゅうけん 謬見"
"びゅうせつ 謬説"
"びゅうまち 別府町"
"びゅうろん 謬論"
"びょう ″ 藐 憑 屏 平 緲 渺 眇 杪 錨 苗 描 猫 票 廟 病 鋲 秒"
"びょういん 病因 病院"
"びょうえい 苗裔"
"びょうか 病家"
"びょうかん 病間 病患 秒間"
"びょうが 描畫 病臥 描画"
"びょうがい 病害"
"びょうがいちゅう 病害虫"
"びょうき 病期 病気"
"びょうきざみ 秒刻み"
"びょうきん 病菌"
"びょうぎ 廟議"
"びょうく 病躯 病苦"
"びょうけい 病型"
"びょうけつ 病欠"
"びょうげん 病源 病原"
"びょうこん 病根"
"びょうご 秒後 病後"
"びょうごう 廟号"
"びょうごと 秒毎"
"びょうさ 錨鎖 秒差"
"びょうさい 病妻"
"びょうさつ 秒殺"
"びょうし 病誌 拍子 表紙 病死"
"びょうしき 病識"
"びょうしつ 病質 病室"
"びょうしゃ 病舎 病者 描写"
"びょうしゅつ 描出"
"びょうしょ 廟所"
"びょうしょう 病牀 病症 病床"
"びょうしん 病身 秒針"
"びょうじ 病児"
"びょうじつ 病日"
"びょうじゃく 病弱"
"びょうじょう 苗条 病状"
"びょうすう 秒数"
"びょうせい 病勢"
"びょうせきがく 病跡学"
"びょうせん 描線"
"びょうぜん 病前"
"びょうそう 病巣"
"びょうそく 秒速"
"びょうぞう 病像 描像"
"びょうたい 病体 病態"
"びょうたんい 秒単位"
"びょうち 錨地"
"びょうちゅう 病中"
"びょうちゅうがい 病虫害"
"びょうてき 病的"
"びょうとう 病棟"
"びょうどう 廟堂 平等"
"びょうどういん 平等院"
"びょうどく 病毒"
"びょうなん 病難"
"びょうにん 病人"
"びょうのう 病悩"
"びょうは 描破"
"びょうはく 錨泊"
"びょうびょう 眇々 渺々 眇眇 渺渺"
"びょうふ 病父 病夫"
"びょうぶ 廟風 病部 屏風"
"びょうへい 病弊"
"びょうへき 病癖"
"びょうへん 病変"
"びょうほ 苗圃"
"びょうほう 兵法 描法"
"びょうぼ 病母"
"びょうぼつ 病歿 病没"
"びょうま 病魔"
"びょうまえ 秒前"
"びょうめい 病名"
"びょうゆう 病友"
"びょうよみ 秒読 秒読み"
"びょうり 病理"
"びょうるい 病羸"
"びょうれき 病歴"
"びよう 美容"
"びよういん 美容院"
"びよく 鼻翼 尾翼"
"びより 日和"
"びらき 開き"
"びらくばり ビラ配り"
"びらん 糜爛"
"びりやーどじょう ビリヤード場"
"びりゅう 微粒"
"びりょう 鼻梁 微量"
"びりょく 微力"
"びるいかん 鼻涙管"
"びるかぜ ビル風"
"びるがい ビル街"
"びるぐん ビル群"
"びるしゃな 毘盧遮那"
"びるしゃなぶつ 毘盧遮那仏"
"びるま 緬甸"
"びるまご ビルマ語"
"びれい 靡麗 美麗"
"びろーど 天鵞絨"
"びろう 尾篭 尾籠"
"びろうど 天鵞絨"
"びろく 微禄 美禄"
"びわ 枇杷 琵琶"
"びわこ 琵琶湖"
"びん 秤 頻 岷 泯 愍 閔 紊 梹 檳 旻 緡 憫 貧 罎 壜 鬢 敏 便 瓶"
"びんいれ 瓶入"
"びんかつ 敏活"
"びんかん 敏感"
"びんが 頻伽"
"びんぎ 便宜"
"びんぐし 鬢櫛"
"びんご 備後"
"びんさつ 憫察"
"びんざさら 編木 拍板"
"びんし 鬢糸"
"びんしけん 閔子騫"
"びんしょう 憫笑 敏捷"
"びんじょう 便乗"
"びんすう 便数"
"びんずる 賓頭盧"
"びんせん 便船 便箋"
"びんぜん 愍然"
"びんそく 敏速"
"びんぞこ 瓶底"
"びんだい 瓶代"
"びんちょう 備長"
"びんちょうずみ 備長炭"
"びんちょうたん 備長炭"
"びんづめ 壜詰め 壜詰 瓶詰 瓶詰め"
"びんびーる 瓶ビール"
"びんほう 便法"
"びんぼう 貧乏"
"びんぼうがみ 貧乏神"
"びんぼうくじ 貧乏籤"
"びんぼうしょう 貧乏性"
"びんぼうゆすり 貧乏揺すり"
"びんめい 便名"
"びんらん 紊乱 便覧"
"びんろう 檳榔"
"びんろうじ 檳榔子"
"びんろうじゅ 檳榔樹"
"びんわん 敏腕"
"ぴ 日"
"ぴーえるほう ＰＬ法"
"ぴーくじ ピーク時"
"ぴーたん 皮蛋"
"ぴーは Ｐ波"
"ぴあのきょうしつ ピアノ教室"
"ぴあのきょく ピアノ曲"
"ぴあのせん ピアノ線"
"ぴあのそうしゃ ピアノ奏者"
"ぴあのふ ピアノ譜"
"ぴかいち 光一"
"ぴき 匹"
"ぴくせるすう ピクセル数"
"ぴさのしゃとう ピサの斜塔"
"ぴざや ピザ屋"
"ぴすとんうんどう ピストン運動"
"ぴすとんゆそう ピストン輸送"
"ぴっぷ 比布"
"ぴつ 泌"
"ぴゅーりたんかくめい ピューリタン革命"
"ぴょう 俵 憑 票"
"ぴょんやん 平壌"
"ぴらみっどがた ピラミッド形"
"ぴりから ピリ辛"
"ぴりんけい ピリン系"
"ぴるびんさん ピルビン酸"
"ぴろりきん ピロリ菌"
"ぴん 筒 品"
"ぴんあん 平安"
"ぴんくいろ ピンク色"
"ぴんず 筒子"
"ぴんはね ピン撥ね"
"ぴんふ 平和"
"ぴんぽんだま ピンポン玉"
"ふ 冨 生 膚 風 敷 怖 斧 罘 俛 埠 阜 誣 巫 仆 訃 赴 鋪 舗 鯆 溥 榑 賻 傅 麸 芙 趺 畉 扶 郛 蜉 孵 俘 桴 孚 鮒 苻 柎 拊 坿 咐 俯 斑 夫 婦 父 富 布 浮 腐 譜 賦 普 附 付 歩 麩 符 腑 府 不 負"
"ふーよーはい 芙蓉蟹"
"ふーりえかいせき フーリエ解析"
"ふーりえきゅうすう フーリエ級数"
"ふーりえへんかん フーリエ変換"
"ふーるー 腐乳"
"ふぁい Φ φ"
"ふぁいるかんり ファイル管理"
"ふぁいるきょうゆう ファイル共有"
"ふぁいるぐん ファイル群"
"ふぁいるこうかん ファイル交換"
"ふぁいるちゅう ファイル中"
"ふぁいるてんそう ファイル転送"
"ふぁいるめい ファイル名"
"ふぁっしょんし ファッション誌"
"ふぁっしょんせい ファッション性"
"ふぁん 飜 翻"
"ふぁんそう ファン層"
"ふぁんでるわーるすりょく ファンデルワールス力"
"ふぁんとうひょう ファン投票"
"ふあつ 負圧"
"ふあん 不安"
"ふぃーと 呎"
"ふぃーるずしょう フィールズ賞"
"ふぃりぴん 比律賓"
"ふぃりぴんかい フィリピン海"
"ふぃりぴんじん フィリピン人"
"ふぃんらんど 芬蘭"
"ふぃんらんどご フィンランド語"
"ふい 巫医 怖畏 不意"
"ふいうち 不意打"
"ふいく 傅育 扶育"
"ふいご 吹子 鞴"
"ふいちょう 吹聴"
"ふいつ 不一"
"ふいふいきょう 回回教"
"ふいり 斑入り"
"ふいん 訃音"
"ふう 富 夫 殕 瘋 諷 楓 封 風"
"ふうあい 風合 風合い"
"ふうあつ 風圧"
"ふうい 風位"
"ふういき 風域"
"ふういん 風韻 封印"
"ふうう 風雨"
"ふううん 風雲"
"ふううんきゅう 風雲急"
"ふうえい 風営 諷詠"
"ふうか 風化"
"ふうかい 諷戒 風懐 風解"
"ふうかく 風格"
"ふうかん 風乾 封緘"
"ふうが 風雅"
"ふうがい 風害"
"ふうがら 風柄"
"ふうがわり 風変り 風変わり"
"ふうがん 風眼"
"ふうき 富貴 風紀"
"ふうきょう 風教 風狂"
"ふうきり 封切り 封切"
"ふうきん 風琴"
"ふうぎ 風儀"
"ふうぎり 封切り"
"ふうけい 風景"
"ふうけつ 風穴"
"ふうげつ 風月"
"ふうこう 風光 風向"
"ふうさ 封鎖"
"ふうさい 風災 風采"
"ふうさつ 封殺"
"ふうさぼう 封鎖棒"
"ふうさんろしゅく 風餐露宿"
"ふうし 夫子 諷刺 風姿 封止 風刺"
"ふうしかでん 風姿花伝"
"ふうしつ 風湿"
"ふうしゃ 風車"
"ふうしゅ 風趣"
"ふうしゅう 風習"
"ふうしょ 封書"
"ふうしょう 諷誦"
"ふうしょく 風食"
"ふうしん 風疹"
"ふうしんき 風信器"
"ふうしんし 風信子"
"ふうしんしこう 風信子鉱"
"ふうじ 封じ"
"ふうじこめ 封じ込め"
"ふうじゅ 諷誦 風樹"
"ふうじん 風塵 風神"
"ふうすい 風水"
"ふうすいがい 風水害"
"ふうせい 風勢 風声 風成"
"ふうせつ 風説 風雪"
"ふうせつがき 風説書"
"ふうせん 風選 風船"
"ふうせんかずら 風船葛"
"ふうせんがむ 風船ガム"
"ふうせんだま 風船玉"
"ふうぜん 風前"
"ふうぜんのともしび 風前の灯"
"ふうそう 風騒 風霜 風葬"
"ふうそく 風速"
"ふうぞく 風俗"
"ふうたい 風帯 風袋 風体"
"ふうたく 風鐸"
"ふうたろう 風太郎"
"ふうち 風致"
"ふうちょう 風聴 風調 風鳥 風潮"
"ふうちりん 風致林"
"ふうちん 風鎮"
"ふうつう 風通"
"ふうてい 風体"
"ふうてん 瘋癲"
"ふうとう 風濤 封筒"
"ふうとうぼく 風倒木"
"ふうど 風土"
"ふうどう 風洞"
"ふうにゅう 封入"
"ふうは 風波"
"ふうはく 風伯"
"ふうはつ 風発"
"ふうばいか 風媒花"
"ふうばぎゅう 風馬牛"
"ふうひ 封皮"
"ふうひょう 風評"
"ふうび 風靡"
"ふうびょう 風病"
"ふうふ 夫婦"
"ふうふうてい 風風亭"
"ふうぶつ 風物"
"ふうぶつし 風物詩"
"ふうぶん 風聞"
"ふうぼう 風防 風貌"
"ふうま 風魔"
"ふうみ 風味"
"ふうみんしゃ 風眠舎"
"ふうむ 風夢"
"ふうもん 風紋"
"ふうゆ 諷諭"
"ふうゆほう 諷喩法"
"ふうらい 風来"
"ふうりゅう 風流"
"ふうりゅういんじ 風流韻事"
"ふうりょう 風量"
"ふうりょく 風力"
"ふうりん 風鈴"
"ふうりんかざん 風林火山"
"ふうれん 風連"
"ふうろう 封蝋 風浪"
"ふうろそうか フウロソウ科"
"ふうろそうぞく フウロソウ属"
"ふうろそうもく フウロソウ目"
"ふうん 浮雲 不運"
"ふぇーんげんしょう フェーン現象"
"ふぇざーきゅう フェザー級"
"ふぇにきあじん フェニキア人"
"ふぇのーるじゅし フェノール樹脂"
"ふぇるみりゅうし フェルミ粒子"
"ふえ 鰾 吭 不壊 笛"
"ふえい 府営"
"ふえいようか 富栄養化"
"ふえかた 笛方 増え方"
"ふえき 賦役 不易"
"ふえたいこ 笛太鼓"
"ふえたけ 笛竹"
"ふえふき 笛吹き"
"ふえふきどうじ 笛吹童子"
"ふえん 布衍 不縁 敷延 敷衍"
"ふおう 不応"
"ふおうせんそう 普墺戦争"
"ふおん 不穏"
"ふか 鯊 孚化 負化 浮華 富家 鱶 附加 府下 孵化 賦課 付加 負荷 深 不可"
"ふかい 深い 渓井 附会 不会 府会 付会 腐海 深井 不快"
"ふかいし 深石"
"ふかいり 深炒り 深煎り 深入り"
"ふかうら 深浦"
"ふかえ 深江"
"ふかえはま 深江浜"
"ふかお 深尾"
"ふかおい 深追い"
"ふかがわ 深川"
"ふかく 俯角 不覚"
"ふかくさ 深草"
"ふかぐつ 深靴"
"ふかこう 不可抗"
"ふかさ 深さ"
"ふかさく 深作"
"ふかさわ 深澤 深沢"
"ふかざけ 深酒"
"ふかざら 深皿"
"ふかざわ 深澤 深沢"
"ふかしょう 不可称"
"ふかしょくみん 不可触民"
"ふかしん 不可侵"
"ふかすぎ 深過ぎ"
"ふかせ 深瀬"
"ふかぞり 深剃り"
"ふかた 深田"
"ふかたに 深谷"
"ふかだ 深田"
"ふかっせいがす 不活性ガス"
"ふかつ 賦活 深津"
"ふかつか 不活化"
"ふかづめ 深爪"
"ふかで 深傷 深手"
"ふかなさけ 深情け"
"ふかなせん 深名線"
"ふかなべ 深鍋"
"ふかの 深野"
"ふかはた 深畑"
"ふかひ 深緋 不可避"
"ふかひれ 鱶鰭"
"ふかぶか 深深 深々"
"ふかぶかと 深々と"
"ふかまち 深町"
"ふかみ 深海 深見 深み"
"ふかみず 深水"
"ふかみどり 深緑"
"ふかむし 深蒸し"
"ふかむらさき 深紫"
"ふかや 深谷"
"ふかやま 深山"
"ふかよい 深酔い"
"ふかよみ 深読み"
"ふかわ 府川 布川"
"ふかん 不乾 不完 不感 俯瞰"
"ふかんしへい 不換紙幣"
"ふがい 腑甲斐 府外"
"ふがいない 腑甲斐無い"
"ふがく 不学 富嶽"
"ふがくさんじゅうろっけい 富嶽三十六景"
"ふがね 府金"
"ふき 菜蕗 款冬 苳 吹 葺 不期 不軌 不羈 不帰 附記 蕗 付記"
"ふきあげ 吹上げ 吹上"
"ふきいど 噴井戸"
"ふきかえ 葺き替え 吹替え 吹き替え 吹替"
"ふきこし 吹越"
"ふきごし 吹越"
"ふきさらし 吹き曝し"
"ふきそうじ 拭き掃除"
"ふきだけ 吹き竹"
"ふきだし 吹出 吹き出し"
"ふきだまり 吹き溜り 吹き溜まり"
"ふきつ 不吉"
"ふきつけ 吹付け 吹き付け 吹付"
"ふきでもの 吹出物 吹き出物"
"ふきとおし 吹通し 吹き通し"
"ふきながし 吹流し 吹き流し"
"ふきぬけ 吹抜 吹抜け 吹き抜け"
"ふきの 吹野"
"ふきのとう 蕗の薹"
"ふきぶり 吹き降り"
"ふきまわし 吹き回し"
"ふきもの 吹物 吹き物"
"ふきや 蕗谷 吹屋 吹矢 吹き矢"
"ふきゅう 不急 不休 腐朽 不朽 普及"
"ふきょ 不許"
"ふきょう 不協 富強 不興 布教 不況"
"ふきょうほう 不競法"
"ふきょく 負極"
"ふきん 賦金 布巾 附近 付近"
"ふぎ 附議 府議 不義 付議"
"ふぎょう 俯仰"
"ふぎょうせき 不行跡"
"ふく 含 吹 富久 箙 茯 袱 伏 馥 輹 蝠 蔔 愎 覆 複 腹 復 匐 輻 幅 副 福 服"
"ふくあつ 腹圧"
"ふくあん 腹案"
"ふくい 復位 福居 福井"
"ふくいく 馥郁"
"ふくいずみ 福泉"
"ふくいん 副因 復員 幅員 福音"
"ふくう 不空"
"ふくうりば 服売場"
"ふくうん 福運"
"ふくえ 福栄 福江"
"ふくえき 服役"
"ふくえきしゅう 服役囚"
"ふくえん 復円 復縁"
"ふくえんせん 福塩線"
"ふくおう 福王"
"ふくおか 福岡"
"ふくおん 複音"
"ふくか 複果"
"ふくかわ 福川"
"ふくかん 副官"
"ふくが 伏臥 腹臥"
"ふくがく 復学"
"ふくがじょう 覆瓦状"
"ふくがみ 福紙"
"ふくがん 複眼"
"ふくきょうだい 福教大"
"ふくぎ 副木 福木"
"ふくぎょう 副業"
"ふくくう 腹腔"
"ふくくうきょう 腹腔鏡"
"ふくけい 復啓"
"ふくけん 復権"
"ふくげん 復原 復元"
"ふくこう 腹腔"
"ふくこうまえ 福高前"
"ふくこん 複婚"
"ふくごう 複号 復号 複合"
"ふくごうまく 複合膜"
"ふくさ 服紗 帛紗 副査 袱紗"
"ふくさい 副菜"
"ふくさや 福砂屋"
"ふくさわ 福澤"
"ふくざ 複座"
"ふくざい 服罪 伏在"
"ふくざき 福崎"
"ふくざさ 福笹"
"ふくざつ 複雑"
"ふくざつさ 複雑さ"
"ふくざわ 福澤 福沢"
"ふくし 復氏 福司 副使 複視 福士 副詞 福祉"
"ふくしき 腹式 複式"
"ふくしげ 福重"
"ふくしつしき 副室式"
"ふくしま 副島 福嶋 福島"
"ふくしまみんぽうはい 福島民報杯"
"ふくしゃ 伏射 福者 輻射 複写"
"ふくしゅ 副手"
"ふくしゅう 福州 復讐 復習"
"ふくしょ 副署 副書"
"ふくしょう 復勝 副章 復誦 複勝 復唱 副将 副賞"
"ふくしょく 副食 復職 服飾"
"ふくしん 復申 腹診 副審 腹心"
"ふくじ 福治 副次 服地 福地"
"ふくじゃく 副尺"
"ふくじゅ 福寿"
"ふくじゅう 複重 服従"
"ふくじゅそう 福寿草"
"ふくじょうし 腹上死"
"ふくじん 副神 副腎"
"ふくじんづけ 福神漬け 福神漬"
"ふくじんひしつほるもん 副腎皮質ホルモン"
"ふくすい 覆水 復水 腹水"
"ふくすう 複数"
"ふくすうじ 複数持"
"ふくすけ 福助"
"ふくずみ 福住"
"ふくせい 復姓 服制 複製"
"ふくせき 復席 復籍"
"ふくせつ 副節"
"ふくせん 複占 複線 伏線"
"ふくそ 復祚 福祚 複素"
"ふくそう 副層 福相 複相 輻湊 副葬 複層 輻輳 服装"
"ふくそうりん 複層林"
"ふくそく 腹側"
"ふくそくるい 腹足類"
"ふくぞう 伏蔵 福蔵 腹蔵"
"ふくぞく 服属"
"ふくたい 複体 腹帯"
"ふくたけ 福武"
"ふくたに 福谷"
"ふくたろう 福太郎"
"ふくだ 福田"
"ふくだい 福大 副題"
"ふくだいり 復代理"
"ふくだつねあり 福田恆存"
"ふくち 福地"
"ふくちやま 福知山"
"ふくちゅう 腹中"
"ふくちょう 副長 復調"
"ふくつ 不屈"
"ふくつう 腹痛"
"ふくで 福田"
"ふくでん 福田 復電"
"ふくと 河豚魚"
"ふくとう 復党"
"ふくとく 福徳"
"ふくとみ 福富"
"ふくとめ 福留"
"ふくど 覆土"
"ふくどう 複道"
"ふくどく 副読 服毒"
"ふくどみ 福富"
"ふくなが 福永"
"ふくにし 福西"
"ふくの 福野"
"ふくのかみ 福の神"
"ふくはい 伏拝 腹背 復配"
"ふくはら 福原"
"ふくはんぎゃくどうめい 服反逆同盟"
"ふくばち 覆鉢"
"ふくひ 複比"
"ふくびき 福引き 福引"
"ふくふく 福福 福々"
"ふくふくせん 複々線"
"ふくぶ 腹部"
"ふくぶく 福々"
"ふくぶくろ 福袋"
"ふくぶん 復文 福分 副文 複文"
"ふくぷろぐらむ 副プログラム"
"ふくへい 伏兵"
"ふくへき 腹壁"
"ふくべ 福部"
"ふくべっぷ 福別府"
"ふくほう 複方 副砲"
"ふくほん 複本 副本"
"ふくぼく 副木"
"ふくぼつ 覆没"
"ふくま 福間"
"ふくまく 腹膜"
"ふくまさ 福政"
"ふくまさむね 福正宗"
"ふくます 福桝"
"ふくまつ 福松"
"ふくまでん 伏魔殿"
"ふくまめ 福豆"
"ふくまれる ⊆ ⊂"
"ふくみ 含み"
"ふくみつ 福光"
"ふくみみ 福耳"
"ふくみわた 含み綿"
"ふくむ ⊇ ⊃ 服務"
"ふくむら 福村"
"ふくめい 復命"
"ふくめつ 覆滅"
"ふくめに 含め煮"
"ふくめん 覆面"
"ふくめんぱとかー 覆面パトカー"
"ふくも 服喪"
"ふくもと 福元 福本"
"ふくもり 福盛"
"ふくや 福家 福屋 服屋"
"ふくやく 服薬"
"ふくやす 福安"
"ふくやま 福山"
"ふくよう 複葉 服用"
"ふくよか 脹よか 膨よか"
"ふくよし 福吉"
"ふくらい 福来"
"ふくらくえん 復楽園"
"ふくらしこ 膨らし粉"
"ふくらはぎ 腓 脹脛"
"ふくらみ 脹らみ 膨らみ"
"ふくり 複利 福利"
"ふくりき 福力"
"ふくりゅう 伏流"
"ふくりゅうえん 副流煙"
"ふくりょう 伏竜"
"ふくりん 覆輪"
"ふくれ 脹れ 膨れ"
"ふくれっつら 脹れっ面 ふくれっ面 膨れっ面"
"ふくろ 複路 副露 嚢 復路 袋"
"ふくろあみ 袋網"
"ふくろい 袋井"
"ふくろいり 袋入"
"ふくろう 梟"
"ふくろおび 袋帯"
"ふくろおり 袋織"
"ふくろくじゅ 福禄寿"
"ふくろこうじ 袋小路"
"ふくろじょう 袋状"
"ふくろぞうし 袋草紙"
"ふくろたけ 袋茸"
"ふくろたに 袋谷"
"ふくろだ 袋田"
"ふくろだたき 袋叩 袋だたき 袋叩き"
"ふくろだな 袋棚"
"ふくろづの 袋角"
"ふくろづめ 袋詰め 袋詰"
"ふくろとじ 袋閉じ 袋綴じ 袋とじ"
"ふくろとだな 袋戸棚"
"ふくろど 袋戸"
"ふくろぬい 袋縫い"
"ふくろのねずみ 袋の鼠"
"ふくろのり 袋海苔"
"ふくろはり 袋貼り"
"ふくろばら 袋原"
"ふくろばり 袋貼り"
"ふくろまち 袋町"
"ふくろみみ 袋耳"
"ふくろもの 袋物"
"ふくわじゅつ 腹話術"
"ふくわらい 福笑い"
"ふくん 父君 夫君"
"ふぐ 鰒 不具 河豚"
"ふぐう 不遇"
"ふぐたいてん 不倶戴天"
"ふぐどく 河豚毒"
"ふぐり 陰嚢 睾丸"
"ふけ 普家 冨宅 冨家 頭垢 雲脂 普化"
"ふけい 腐刑 譜系 噴井 不敬 父系 婦警 府警 父兄"
"ふけいざい 賦形剤"
"ふけがお 老け顔"
"ふけだ 深田"
"ふけつ 不潔"
"ふけまちづき 更待月"
"ふけやく 老役 老け役"
"ふけん 夫権 父権 府県"
"ふげき 巫覡"
"ふげん 誣言 富源 不言 附言 付言 普賢"
"ふげんぞう 普賢象"
"ふこ 浮誇 巫蠱 封戸"
"ふこう 附高 不孝 不幸"
"ふこく 腐刻 富国 布告"
"ふこくきょうへい 富國強兵"
"ふこつ 腐骨"
"ふご 付語 附語 不語"
"ふごう 不合 負号 附合 付合 符合 富豪 符号"
"ふさ 絃 惣 總 総 房"
"ふさい 負載 不才 付載 不採 負債 夫妻"
"ふさがる 閼"
"ふさきち 房吉"
"ふさぎ 塞ぎ"
"ふさぎのむし 塞ぎの虫"
"ふさく 不作"
"ふさぐ 閼"
"ふさこ 夫査子 扶佐子 房子"
"ふさざくらか フサザクラ科"
"ふさじょう ふさ状"
"ふさふさ 房々"
"ふさん 不讃 不参"
"ふざ 趺坐"
"ふざい 不在"
"ふざけ 巫山戯"
"ふざん 巫山 釜山"
"ふし 臥 伏 浮子 不死 父子 節"
"ふしあな 節穴"
"ふしいと 節糸"
"ふしき 伏木"
"ふしくれ 節榑"
"ふしたに 伏谷"
"ふしちょう 不死鳥"
"ふしつ 不悉"
"ふしづくり 節旁"
"ふしづけ 罧 節付け"
"ふしてん 節点"
"ふしど 臥床 臥所"
"ふしぶし 節節 節々"
"ふしまちづき 臥待月"
"ふしまわし 節回し"
"ふしみ 伏見"
"ふしめ 伏目 伏し目 節目"
"ふしゃ 府社 巫者 富者"
"ふしゃくしんみょう 不惜身命"
"ふしゅ 浮腫"
"ふしゅう 浮舟 俘囚 腐臭"
"ふしゅうこう 不銹鋼"
"ふしゅく 巫祝"
"ふしゅつ 不出"
"ふしょう 鳧鐘 不精 父称 府省 不承 富商 不祥 不肖 不詳 負傷"
"ふしょうじ 不祥事"
"ふしょうふずい 夫唱婦随"
"ふしょうふめつ 不生不滅"
"ふしょうわたくし 不肖私"
"ふしょく 扶植 不食 腐植 腐蝕 腐食"
"ふしん 腐心 普請 不審 不信 不振"
"ふしんばん 不寝番"
"ふしんび 不審火"
"ふじ 不時 冨士 不二 不治 富士 藤"
"ふじい 藤井"
"ふじいでら 藤井寺"
"ふじいろ 藤色"
"ふじう 藤生"
"ふじうつぎか フジウツギ科"
"ふじうら 藤浦"
"ふじえ 藤江"
"ふじえだ 藤枝"
"ふじえだひがし 藤枝東"
"ふじお 冨士雄 藤雄 富士雄 藤尾 不二夫 富士夫 不二雄"
"ふじおか 富士岡 藤岡"
"ふじか 藤花"
"ふじかけ 藤懸 藤掛"
"ふじかわ 富士川 藤川"
"ふじがおか 藤ヶ丘 藤が丘"
"ふじき 藤城 藤木"
"ふじきゅう 富士急"
"ふじくら 藤倉"
"ふじけい フジ系"
"ふじこ 冨士子 不二子 富士子 藤子"
"ふじこし 藤越 不二越"
"ふじごこ 富士五湖"
"ふじさき 藤崎"
"ふじさく 藤咲"
"ふじさと 藤里"
"ふじさわ 藤澤 藤沢"
"ふじしま 藤嶋 藤島"
"ふじしろ 藤城 藤代"
"ふじせ 藤瀬"
"ふじぜろっくす 富士ゼロックス"
"ふじた 冨士田 藤田"
"ふじたか 藤孝"
"ふじたに 富士谷 藤谷"
"ふじだな 藤棚"
"ふじつ 藤津 不日 不実"
"ふじつうぜねらる 富士通ゼネラル"
"ふじつか 藤塚"
"ふじつぼ 富士壺 藤壷 藤壺"
"ふじづか 富士塚"
"ふじと 藤戸"
"ふじなが 藤永"
"ふじなみ 藤波"
"ふじなやき 布志名焼"
"ふじなわ 藤縄"
"ふじの 藤野"
"ふじのうらば 藤裏葉"
"ふじのみや 藤ノ宮 富士宮"
"ふじのもり 藤森"
"ふじはし 藤橋"
"ふじはら 冨士原"
"ふじばかま 藤袴"
"ふじばやし 藤林"
"ふじひこ 不二彦"
"ふじひろ 不二洋"
"ふじびたい 富士額"
"ふじふいるむ 富士フイルム"
"ふじま 藤間"
"ふじまき 藤巻"
"ふじまつ 藤松"
"ふじまめ 藤豆"
"ふじみ 富士美 富士見 不死身"
"ふじみがおか 富士見丘"
"ふじむすめ 藤娘"
"ふじむら 藤村"
"ふじむらさき 藤紫"
"ふじもと 藤元 藤本"
"ふじもり 藤森"
"ふじや 藤屋 不二家"
"ふじやま 藤山"
"ふじやまかんび 藤山寛美"
"ふじゅう 藤生"
"ふじゅく 不熟"
"ふじゅつ 巫術"
"ふじゅん 不純 不順"
"ふじょ 巫女 婦女 扶助"
"ふじょう 不浄 浮上 不定"
"ふじよし 藤吉"
"ふじわか 藤若"
"ふじわら 冨士原 藤原"
"ふじわらきょう 藤原京"
"ふじわらのおきかぜ 藤原興風"
"ふじわらのすみとも 藤原純友"
"ふじわらのみちなが 藤原道長"
"ふじわらのもととし 藤原基俊"
"ふじん 不尽 布陣 婦人 夫人"
"ふすう 負数"
"ふすべ 燻 贅"
"ふすべうめ 燻べ梅"
"ふすべがお 燻顔"
"ふすべがき 燻柿"
"ふすべがわ 燻革"
"ふすべぎん 燻銀"
"ふすま 麩 衾 襖"
"ふすまえ 襖絵"
"ふず 付図"
"ふずい 附随 不随 付随"
"ふずいか 付随果"
"ふせ 防 伏せ 布施"
"ふせい 不省 夫姓 負性 腐生 不斉 府政 父性 不整 不正"
"ふせいあくせす 不正アクセス"
"ふせいこぴー 不正コピー"
"ふせいしゅつ 不世出"
"ふせいみゃく 不整脈"
"ふせき 布石"
"ふせぎ 伏木"
"ふせじ △△△ □□□ ○○○ ××× ふせ字 伏字"
"ふせつ 負節 浮説 符節 付設 布設 敷設"
"ふせや 伏屋"
"ふせん 富贍 不宣 附箋 普選 不戦 付箋"
"ふぜい 府税 風情"
"ふぜん 不善 不全"
"ふそ 父祖"
"ふそう 扶桑"
"ふそく 付則 不測 附則 不足"
"ふそくふり 不即不離"
"ふそびょう 腐蛆病"
"ふそん 不遜"
"ふぞく 附属 付属"
"ふぞくし 付属肢"
"ふた 葢 盖 弍 双 二 蓋"
"ふたあい 二藍"
"ふたあけ 蓋明け"
"ふたあし 二足"
"ふたあじ 二味"
"ふたい 附帯 付帯"
"ふたいか 不胎化"
"ふたいとこ 二従姉妹 二従兄弟"
"ふたえ 二重"
"ふたえき 二駅"
"ふたえまぶた 二重瞼"
"ふたおもて 双面"
"ふたおや 二親"
"ふたかた 二方"
"ふたかみ 二上"
"ふたかわ 二川"
"ふたかわめ 二皮目"
"ふたがみ 二上 二神"
"ふたがわ 二川"
"ふたく 負託 付託"
"ふたくせ 二癖"
"ふたくみ 二組"
"ふたけた 二桁"
"ふたこ 二子"
"ふたこと 二言"
"ふたご 双子"
"ふたごころ 二心"
"ふたごたまがわ 二子玉川"
"ふたごやま 二子山"
"ふたすじ 二筋"
"ふたせ 二瀬"
"ふたたび 再び"
"ふたたま 二玉"
"ふたつ 弍 双 二 ２つ 布達 不達 二つ"
"ふたつい 二ツ井"
"ふたつき ふた月 蓋付き 蓋付 二月"
"ふたつぎ 二木"
"ふたつざわ 二ツ沢"
"ふたつぼし 二つ星"
"ふたつめ 二つめ"
"ふたつや 二ッ谷"
"ふたて 二手"
"ふたとおり 二通り"
"ふたなり 二形"
"ふたのき 二軒"
"ふたはこ 二箱"
"ふたば 雙葉 二葉 双葉"
"ふたばていしめい 二葉亭四迷"
"ふたばん 二晩"
"ふたへや 二部屋"
"ふたま 二間"
"ふたませ 二間瀬"
"ふたまた 二叉 二又 二股"
"ふたまたがわ 二俣川"
"ふたまたごうやく 二股膏薬"
"ふたまたせん 二俣線"
"ふたまたぶね 二股舟"
"ふたまたみち 二股道"
"ふたまわり 二回り"
"ふたみ 二美 双三 双海 二見"
"ふたみち 二道"
"ふたむかしまえ 二昔前"
"ふたむら 二村"
"ふため 不為 二目"
"ふたもじ 二文字"
"ふたもの 蓋物"
"ふたやく 二役"
"ふたよ 二夜"
"ふたり ２人 二人"
"ふたりきり 二人きり"
"ふたりぐらし 二人暮し 二人暮らし"
"ふたりしずか 二人静"
"ふたりたび 二人旅"
"ふたりっきり 二人っきり"
"ふたりのり 二人乗"
"ふたわ 二和"
"ふたん 負担"
"ふだ 布田 簡 札"
"ふだい 普代 府大 譜代"
"ふだしょ 札所"
"ふだつき 札付 札付き"
"ふだどめ 札止 札止め"
"ふだのつじ 札の辻"
"ふだば 札場"
"ふだまもり 札守り"
"ふだらく 普陀落 補陀洛 補陀落"
"ふだん 不断 普段"
"ふだんざくら 不断桜"
"ふち 渊 渕 潭 付値 負値 扶持 布置 付置 附置 不知 不治 淵 縁"
"ふちかざり 縁飾り"
"ふちがみ 渕上"
"ふちざき 渕崎"
"ふちどり 縁取り"
"ふちなし 縁無し"
"ふちの 渕野"
"ふちのべ 淵野辺"
"ふちまい 扶持米"
"ふちゃ 普茶"
"ふちゃく 不着 付着"
"ふちゅう 釜中 不忠 婦中 府中"
"ふちょう 符帳 符牒 符丁 府庁 婦長 不調"
"ふちん 不沈 浮沈"
"ふっか 弗化 フッ化"
"ふっかい 復改"
"ふっかく 伏角"
"ふっかつ 復活"
"ふっかん 副官 復刊"
"ふっき 伏羲 復帰"
"ふっきゅう 復仇 復旧"
"ふっきん 腹筋"
"ふっけん 復建 福建 復権"
"ふっこ 復古"
"ふっこう 復校 復航 復交 腹腔 復興"
"ふっこうきょう 腹腔鏡"
"ふっこうだい 福工大"
"ふっこく 覆刻 復刻"
"ふっさ 福生"
"ふっしょ 仏書"
"ふっしょく 払拭"
"ふっせき 沸石"
"ふっそ F 弗素 フッ素"
"ふっつ 富津"
"ふってい 払底"
"ふってん 沸点"
"ふっとう 沸湯 沸騰"
"ふっとうすいがたげんしろ 沸騰水型原子炉"
"ふつ 黻 祓 怫 髴 彿 佛 沸 弗 拂 払 布津 仏"
"ふついでんし 不対電子"
"ふついん 仏印"
"ふつう 不通 普通"
"ふつうば 普通馬"
"ふつえい 仏英"
"ふつか ２日 二日"
"ふつかすいそさん 弗化水素酸"
"ふつかよい 宿酔い 宿酔 二日酔"
"ふつぎょう 払暁"
"ふつぐん 仏軍"
"ふつけん 仏検"
"ふつこく 仏国"
"ふつご 仏語"
"ふつしゃ 仏車"
"ふつじん 仏人"
"ふつつか 不束"
"ふつつかもの ふつつか者"
"ふつどく 仏独"
"ふつのみたま 布都御魂"
"ふつふつ 仏仏 沸沸 沸々"
"ふつぶん 仏文"
"ふつやく 仏訳"
"ふつりょう 仏領"
"ふつれき 仏暦"
"ふつわ 仏和"
"ふづき 文月"
"ふづくえ 文机"
"ふてい 不悌 婦弟 不弟 不逞 不貞 不定"
"ふていこん 不定根"
"ふていしょう 不定称"
"ふていのやから 不逞の輩"
"ふてき 不敵 不適"
"ふてね 不貞寝 ふて寝"
"ふてん 符点 普天 付点"
"ふてんそっと 普天率土"
"ふで 筆"
"ふであらい 筆洗い"
"ふでいれ 筆入れ"
"ふでおろし 筆下ろし"
"ふでが 筆画"
"ふでがしら 筆頭"
"ふでくせ 筆癖"
"ふでさき 筆先"
"ふでし 筆師"
"ふでじまん 筆自慢"
"ふでたて 筆立て"
"ふでづかい 筆使い 筆遣い"
"ふでづつ 筆筒"
"ふではこび 筆運び"
"ふでばこ 筆箱"
"ふでぶしょう 筆無精 筆不精"
"ふでぶと 筆太"
"ふでぺん 筆ペン"
"ふでまき 筆巻"
"ふでまめ 筆まめ 筆忠実"
"ふでもじ 筆文字"
"ふと 富戸 不図 太"
"ふといと 太糸"
"ふとう 符頭 不党 不倒 不凍 不撓 不等 埠頭 不当"
"ふとうおう 不倒翁"
"ふとうごう ≠ ＞ ＜ ≫ ≪ ≧ ≦"
"ふとおり 太織"
"ふとく 婦徳 不徳"
"ふとくようりょう 不得要領"
"ふとぐち 太口"
"ふところ 懷 懐"
"ふところがたな 懐刀"
"ふところがみ 懐紙"
"ふところぐあい 懐具合"
"ふところで 懐手"
"ふとざお 太棹"
"ふとし 太司 太"
"ふとじ 太字"
"ふとせん 太線"
"ふとっちょ 太っちょ"
"ふとっぱら 太腹 太っ腹"
"ふとどき 不届 不届き"
"ふとばし 太箸"
"ふとぶと 太太 太々"
"ふとまき 太巻"
"ふとまに 太占"
"ふとみ 太身"
"ふとめ 太目 太め"
"ふとめん 太麺"
"ふともの 太物"
"ふともも 太もも 太腿 太股"
"ふともももく フトモモ目"
"ふとり 太織"
"ふとりじし 太り肉"
"ふとわく 太枠"
"ふとん 蒲団 布団"
"ふとんかばー 布団カバー"
"ふとんぶくろ 布団袋"
"ふどう 府道 不同 浮動 不動"
"ふどうにょざん 不動如山"
"ふどき 風土記"
"ふな 舩 舟 船 鮒"
"ふなあか 船淦"
"ふなあし 船脚 船足"
"ふなあそび 船遊び"
"ふない 府内 船井"
"ふないくさ 船軍"
"ふないた 船板"
"ふないり 舟入"
"ふなうた 舟歌"
"ふなおか 船岡"
"ふなか 不仲"
"ふなかた 船方"
"ふながいしゃ 船会社"
"ふながた 舟型 船型 船形 舟形"
"ふなき 舟木 船木"
"ふなくいむし 船食虫"
"ふなくぎ 舟釘"
"ふなくぼ 舟久保"
"ふなぐ 船具"
"ふなぐら 艙 船蔵 船倉"
"ふなけん 舟券"
"ふなこ 舟子"
"ふなこう 船高"
"ふなこし 船越"
"ふなごや 船小屋"
"ふなさか 舟阪"
"ふなじ 船路"
"ふなずし 鮒鮨"
"ふなせ 船瀬"
"ふなぞこ 舟底 船底"
"ふなたび 船旅"
"ふなだ 船田"
"ふなだいく 船大工"
"ふなちん 船賃"
"ふなつ 舟津 船津"
"ふなつきば 船着き場 船着場"
"ふなづみ 船積み"
"ふなづみこう 船積港"
"ふなづり 舟釣 船釣 船釣り"
"ふなで 船出"
"ふなと 船渡 舟渡"
"ふなど 船戸"
"ふなどめ 船留め"
"ふなに 船荷"
"ふなぬし 船主"
"ふなのり 舟乗 船乗 船乗り"
"ふなはし 舟橋 船橋"
"ふなば 船場"
"ふなばし 舟橋 船橋"
"ふなばた 舷 船端"
"ふなばり 船梁"
"ふなびき 船曳"
"ふなびと 船人 舟人"
"ふなびん 船便"
"ふなべり 舷 船縁"
"ふなべんけい 船弁慶"
"ふなほ 船穂"
"ふなま 船間"
"ふなまち 船待ち"
"ふなまど 船窓"
"ふなみず 船水"
"ふなむし 舟虫 船虫"
"ふなむら 舟村"
"ふなもり 舟盛り"
"ふなや 舟屋"
"ふなやど 船宿"
"ふなやま 舩山 舟山 船山"
"ふなゆ 船湯 淦"
"ふなよい 船酔 船酔い"
"ふなり 不成"
"ふなれ 不馴れ"
"ふなわ 舟和"
"ふなわたし 船渡し"
"ふに 不二"
"ふにあい 不似合い"
"ふにく 腐肉"
"ふにゅう 船生 腐乳 不入"
"ふにん 補任 不妊 赴任"
"ふぬけ 腑抜け"
"ふね 舩 艦 舟 船"
"ふねかんけい 船関係"
"ふねひき 船引"
"ふねへん 舟偏"
"ふねや 船屋"
"ふねよう 船用"
"ふねん 不稔 不燃"
"ふねんごみ 不燃ゴミ"
"ふの 布野"
"ふのあたい 負の値"
"ふのう 富農 不納 不能"
"ふのり 海蘿 布海苔"
"ふは 不破"
"ふはい 不敗 腐敗"
"ふはく 浮薄 布帛"
"ふはつ 不発"
"ふはつだん 不発弾"
"ふばい 不買"
"ふばこ 文箱"
"ふばつ 不抜"
"ふばん 符番 付番"
"ふひょう 歩兵 浮氷 譜表 付票 附表 浮標 附票 付表 不評"
"ふび 符尾 不備"
"ふびん 不敏 不便 不憫"
"ふふく 俛伏 俯伏 不服"
"ふふつせんそう 普仏戦争"
"ふぶ 布武"
"ふぶき 風吹 吹雪"
"ふぶん 腑分 不文"
"ふへい 浮萍 不平"
"ふへき 扶壁"
"ふへん 不遍 布片 不偏 普遍 不変"
"ふべん 不便"
"ふほ 付保"
"ふほう 訃報 不法"
"ふぼ 父母"
"ふぼく 浮木"
"ふぼん 不犯"
"ふまい 不昧"
"ふまえ 踏まえ"
"ふまじめ 不まじめ"
"ふまるさん フマル酸"
"ふまん 不満"
"ふみ 芙美 二三 郁 章 史 踏み 不味 文"
"ふみあき 史光 文昭 文明"
"ふみあけ 文朱"
"ふみいし 踏石"
"ふみいた 踏み板 踏板"
"ふみえ 文絵 踏絵"
"ふみお 郁雄 史緒 史男 二三男 史夫 文郎 文男 文夫 文雄"
"ふみか 史佳"
"ふみかず 文一"
"ふみがら 文殻"
"ふみきり 踏切"
"ふみこ 冨美子 ふみ子 富美子 史子 文子"
"ふみことば 文言葉"
"ふみこみ 踏みこみ 踏込み"
"ふみこみだたみ 踏込畳"
"ふみし 二三四"
"ふみたか 文孝 文隆"
"ふみたけ 文武"
"ふみただ 文忠"
"ふみだい 踏台"
"ふみだん 踏段"
"ふみつけ 踏付け"
"ふみづき 文月"
"ふみづくえ 文机"
"ふみづら 踏面"
"ふみと 史人 文人"
"ふみとし 文敏 文俊"
"ふみとよ 文豊"
"ふみどの 文殿"
"ふみのつかさ 図書寮 書司"
"ふみのぶ 文信"
"ふみのり 文典"
"ふみばこ 文箱"
"ふみひこ 郁彦 史彦 文彦"
"ふみひで 文秀"
"ふみひと 史人 文仁"
"ふみひろ 文礼 文浩 史裕 文博"
"ふみまさ 章雅"
"ふみや 郁也 文也 文屋"
"ふみやす 文保 文康"
"ふみゆき 文行 文之"
"ふみよ 扶三代 文代"
"ふみよし 文嘉 文良 文義"
"ふみん 富民 府民 不眠"
"ふめい 不明"
"ふめつ 不滅"
"ふめん 符面 普免 譜面"
"ふもう 不毛"
"ふもと 梺 麓"
"ふもん 不問"
"ふもんぼん 普門品"
"ふやじょう 不夜城"
"ふゆ 冬"
"ふゆいがい 冬以外"
"ふゆいらい 冬以来"
"ふゆう 浮有 富有 富裕 浮遊"
"ふゆうれい 浮遊霊"
"ふゆがこい 冬囲い"
"ふゆがしら 冬頭"
"ふゆがすみ 冬霞"
"ふゆがた 冬型"
"ふゆがっしゅく 冬合宿"
"ふゆがれ 冬枯れ"
"ふゆき 冬季 冬樹 冬木"
"ふゆきとどき 不行届き 不行き届き"
"ふゆぎ 冬着"
"ふゆぎぬ 冬衣"
"ふゆくいな 冬水鶏"
"ふゆくさ 冬草"
"ふゆげ 冬毛"
"ふゆげしき 冬景色"
"ふゆげしょう 冬化粧"
"ふゆこ 冬子"
"ふゆこだち 冬木立"
"ふゆこみ 冬コミ"
"ふゆごう 冬号"
"ふゆごし 冬越し"
"ふゆごもり 冬籠り"
"ふゆごろ 冬頃"
"ふゆさくもつ 冬作物"
"ふゆざれ 冬ざれ"
"ふゆしょうぐん 冬将軍"
"ふゆじかん 冬時間"
"ふゆじたく 冬支度"
"ふゆぞら 冬空"
"ふゆつばき 冬椿"
"ふゆとうらい 冬到来"
"ふゆどり 冬鳥"
"ふゆな 冬菜"
"ふゆねこ 冬猫"
"ふゆの 冬野"
"ふゆのじん 冬の陣"
"ふゆのたび 冬の旅"
"ふゆのひ 冬の日"
"ふゆはる 冬春"
"ふゆば 冬場"
"ふゆばれ 冬晴れ"
"ふゆひこ 冬彦"
"ふゆび 冬日"
"ふゆびより 冬日和"
"ふゆふく 冬服"
"ふゆぶとり 冬太り"
"ふゆまつり 冬祭 冬祭り"
"ふゆみ 冬美"
"ふゆみち 冬道"
"ふゆめ 冬芽"
"ふゆもの 冬物"
"ふゆものがたり 冬物語"
"ふゆもよう 冬模様"
"ふゆやさい 冬野菜"
"ふゆやすみ 冬休み"
"ふゆやま 冬山"
"ふゆよう 冬用"
"ふよ 賦与 付与"
"ふよう 芙容 浮葉 不溶 浮揚 芙蓉 不用 扶養 不要"
"ふようど 腐葉土"
"ふよく 扶翼"
"ふらいがえし フライ返し"
"ふらいきゅう フライ級"
"ふらいすばん フライス盤"
"ふらく 不落"
"ふらここ 鞦韆"
"ふらご フラ語"
"ふらち 不埓 不埒"
"ふらっと ♭"
"ふらの 富良野"
"ふらん 腐爛 孵卵 不乱 腐乱"
"ふらんす 仏 佛蘭西 仏蘭西"
"ふらんすえいが フランス映画"
"ふらんすかくめい フランス革命"
"ふらんすぐん フランス軍"
"ふらんすご フランス語"
"ふらんすさん フランス産"
"ふらんすじん フランス人"
"ふらんすせい フランス製"
"ふらんすにんぎょう フランス人形"
"ふらんすぶんか フランス文化"
"ふらんすぶんがく フランス文学"
"ふらんすりょうり フランス料理"
"ふらんどるがくは フランドル楽派"
"ふらんどるは フランドル派"
"ふり 不離 降り 振り 振 不利"
"ふりーきしゃ フリー記者"
"ふりかえ 振替"
"ふりかけ 振掛け 振り掛け"
"ふりがな 振仮名"
"ふりこ 振子 振り子"
"ふりこぐるま 振子車"
"ふりこみ 振込み 振込"
"ふりこみしゃめい 振込者名"
"ふりこめさぎ 振り込め詐欺"
"ふりごま 振り駒"
"ふりそで 振り袖 振袖"
"ふりそですがた 振袖姿"
"ふりだし 振出し 振出"
"ふりつ 振津 府立"
"ふりつけ 振付け 振付"
"ふりつもんじ 不立文字"
"ふりてん 振聴"
"ふりはた 降籏"
"ふりびしゃ 振飛車"
"ふりゅう 浮流 風流"
"ふりゅうもんじ 不立文字"
"ふりょ 俘慮 俘虜 不慮"
"ふりょう 不猟 不漁 不良"
"ふりょうせくた 不良セクタ"
"ふりょく 富力 浮力"
"ふりわけ 振分け 振分"
"ふりん 不倫"
"ふる 古"
"ふるい 古い 古井 篩"
"ふるいえ 古家"
"ふるいけ 古池"
"ふるいち 古市"
"ふるう 古宇"
"ふるうち 古内"
"ふるえ 古恵 古江 震え"
"ふるおや 古尾谷"
"ふるかいてん フル回転"
"ふるかつよう フル活用"
"ふるかどう フル稼働"
"ふるかぶ 古株"
"ふるかわ 古河 古川"
"ふるかわえきにしぐち 古河駅西口"
"ふるがお 古顔"
"ふるがね 古鉄"
"ふるき 古木"
"ふるきず 古傷"
"ふるぎ 古着"
"ふるぎって 古切手"
"ふるぎつね 古狐"
"ふるくさい 古臭い"
"ふるこおり 古郡"
"ふること 古言"
"ふることぶみ 古事記"
"ふるごう 古国府"
"ふるごおり 古郡"
"ふるごよみ 古暦"
"ふるさか 古坂"
"ふるさと 故里 古里 故郷"
"ふるさわ 古沢 古澤"
"ふるざけ 古酒"
"ふるしま 古島"
"ふるしゅつじょう フル出場"
"ふるしょう 古庄"
"ふるじゅうでん フル充電"
"ふるす 古巣"
"ふるせ 古瀬"
"ふるそう 古荘"
"ふるそうび フル装備"
"ふるた 古田"
"ふるたか 古鷹"
"ふるたち 古舘 古館"
"ふるたて 古舘"
"ふるたに 古谷"
"ふるだたみ 古畳"
"ふるだち 古舘"
"ふるだて 古舘"
"ふるだぬき 古狸"
"ふるつわもの 古兵"
"ふるづけ 古漬"
"ふるて 古手"
"ふるでら 古寺"
"ふると 古戸"
"ふるとり 隹"
"ふるどの 古殿"
"ふるどり 隹"
"ふるぬの 古布"
"ふるの 古野"
"ふるはし 古橋"
"ふるはた 古籏 古畑"
"ふるび 古び"
"ふるびら 古平"
"ふるほん 古本"
"ふるまい 振る舞い 振舞い 振舞"
"ふるまち 古町"
"ふるみち 古道"
"ふるみや 古宮"
"ふるむら 古村"
"ふるめ 古め 古妻"
"ふるもと 古本"
"ふるもの 古物"
"ふるや 古矢 古家 古谷 古屋"
"ふるやま 古山"
"ふれ 振れ 触れ"
"ふれあい ふれ合い"
"ふれい 負例 不例 布令 譜例"
"ふれこみ 触込み"
"ふれぶみ 触文"
"ふれんど 普連土"
"ふろ 風炉 風呂"
"ふろあがり 風呂あがり"
"ふろう 浮浪 不労 不老"
"ふろうりん 不老林"
"ふろおけ 風呂桶"
"ふろく 不直 不陸 附録 付録"
"ふろしき 風呂敷"
"ふろたき 風呂焚き"
"ふろふき 風呂吹き"
"ふろみず 風呂水"
"ふわ 不破 付和 不和"
"ふわく 不惑"
"ふわけ 腑分け"
"ふわたり 不渡"
"ふわり 譜割り 譜割"
"ふん ′ 焚 奮 刎 吻 賁 濆 憤 墳 噴 芬 汾 枌 忿 吩 氛 雰 紛 扮 粉 糞 分"
"ふんあつ 分圧"
"ふんい 雰囲"
"ふんいき 氛圍氣 雰囲気"
"ふんうん 紛紜"
"ふんえん 噴煙"
"ふんか 噴火"
"ふんかん 分間"
"ふんかんかく 分間隔"
"ふんがい 憤慨"
"ふんき 噴気 奮起"
"ふんきこう 噴気孔"
"ふんきざみ 分刻み"
"ふんきゅう 紛糾"
"ふんきゅうぼ 墳丘墓"
"ふんぎ 紛議"
"ふんぎり 踏ん切り"
"ふんけい 刎頸 焚刑 刎頚"
"ふんげき 憤激"
"ふんこつ 粉骨"
"ふんころ 分頃"
"ふんご 分後"
"ふんごう 吻合"
"ふんごと 分毎"
"ふんさい 粉彩 粉砕"
"ふんさつ 焚殺"
"ふんざい 粉剤"
"ふんし 憤死"
"ふんしつ 紛失"
"ふんしゃ 噴射"
"ふんしゅうは 分周波"
"ふんしゅつ 噴出"
"ふんしょ 焚書"
"ふんしょく 扮飾 粉食 粉飾"
"ふんしん 分針"
"ふんじょう 紛擾"
"ふんじん 奮迅 粉塵"
"ふんすい 噴水"
"ふんせき 糞石 噴石"
"ふんせつ 粉雪"
"ふんせん 噴泉 奮戦"
"ふんぜん 紛然 奮然 憤然"
"ふんそう 扮装 紛争"
"ふんそく 吻側 分速"
"ふんぞうえ 糞掃衣"
"ふんぞく フン族"
"ふんたい 粉黛 粉体"
"ふんたん 粉炭"
"ふんたんい 分単位"
"ふんづまり 糞詰り 糞詰まり"
"ふんとう 粉糖 奮闘"
"ふんど 糞土 忿怒 憤怒"
"ふんどう 分銅"
"ふんどし 褌"
"ふんどしすがた 褌姿"
"ふんにゅう 粉乳"
"ふんにょう 糞尿"
"ふんぬ 忿怒 憤怒"
"ふんはん 分半"
"ふんばり 踏ん張り"
"ふんぱつ 奮発"
"ふんぱん 噴飯"
"ふんびょう 分秒"
"ふんぷん 芬々 紛々"
"ふんべつ 分別"
"ふんべん 糞便"
"ふんぼ 墳墓"
"ふんぽん 粉本"
"ふんまえ 分前"
"ふんまつ 粉末"
"ふんまん 忿懣 憤懣"
"ふんみまん 分未満"
"ふんみょう 分明"
"ふんむ 噴霧"
"ふんめつ 焚滅"
"ふんもん 憤悶 噴門"
"ふんや 文屋"
"ふんやのあさやす 文屋朝康"
"ふんやのやすひで 文屋康秀"
"ふんらん 紛乱"
"ふんりゅう 粉瘤 噴流"
"ふんれい 奮励"
"ぶ 悔 奉 歩 葡 蒲 錻 誣 毋 侮 憮 廡 嘸 蕪 舞 撫 無 不 武 部 分"
"ぶーどぅーきょう ブードゥー教"
"ぶーるだいすう ブール代数"
"ぶあい 無愛 部合 歩合"
"ぶあいきゅう 歩合給"
"ぶあいきょう 無愛敬"
"ぶあいそ 不愛想 無愛想"
"ぶあいそう 無愛想"
"ぶあく 武悪"
"ぶあんない 不案内"
"ぶい 武威 部位"
"ぶいく 撫育"
"ぶいしねま Ｖシネマ"
"ぶいじ Ｖ字"
"ぶいち 武一"
"ぶいねっく Ｖネック"
"ぶいん 無音 部員"
"ぶうん 武運"
"ぶえ 笛"
"ぶえき 無射"
"ぶえん 無塩"
"ぶえんりょ 不遠慮 無遠慮"
"ぶおとこ 醜男"
"ぶおんな 醜女"
"ぶおんぷ 分音符"
"ぶか 深 部科 部課 部下"
"ぶかい 部会"
"ぶかっこう 不格好 不恰好"
"ぶかつ 部活"
"ぶかつどう 部活動"
"ぶかん 武鑑 武漢 武官"
"ぶが 舞歌"
"ぶがい 部外"
"ぶがいひ 部外秘"
"ぶがく 舞楽"
"ぶき 武器"
"ぶきみ 不気味"
"ぶきょう 無興 不興 武侠"
"ぶきょく 部曲 舞曲 部局"
"ぶきよう 無器用 不器用"
"ぶきりょう 不器量"
"ぶぎ 部議 武技"
"ぶぎょう 奉行"
"ぶく 伏"
"ぶくうじゅつ 舞空術"
"ぶくりょう 茯苓"
"ぶくりょうさい 茯苓菜"
"ぶくろ 袋"
"ぶくん 武勲"
"ぶぐ 武具"
"ぶけ 武家"
"ぶけしょはっと 武家諸法度"
"ぶけづくり 武家造"
"ぶけん 武見"
"ぶげい 武芸"
"ぶげん 無限 侮言 分限"
"ぶこう 武后 武功"
"ぶこく 誣告"
"ぶこつ 武骨 無骨"
"ぶさ 房"
"ぶさいく 不細工"
"ぶさく 部作"
"ぶさた 不沙汰 無沙汰"
"ぶさつ 撫擦"
"ぶさほう 不作法 無作法"
"ぶざーおん ブザー音"
"ぶざい 部材"
"ぶざつ 蕪雑"
"ぶざま 不様 無様"
"ぶし 付子 附子 部誌 節 武士"
"ぶしお 無潮"
"ぶしつ 部室"
"ぶしつけ 不しつけ 不躾"
"ぶしや 付子矢"
"ぶしゅ 部首"
"ぶしゅう 武州"
"ぶしゅうぎ 不祝儀"
"ぶしゅうぎぶくろ 不祝儀袋"
"ぶしょ 部所 部署"
"ぶしょう 部将 不精 無精 武将"
"ぶしょうひげ 不精髭 無精髭"
"ぶしん 武神"
"ぶじ 武事 無事"
"ぶじこれめいば 無事是名馬"
"ぶじに 無事に"
"ぶじゅつ 撫恤 武術"
"ぶじゅん 撫順"
"ぶじょく 侮辱"
"ぶじん 武人"
"ぶす 付子 附子"
"ぶすい 不粋 無粋"
"ぶすう 部数"
"ぶすじま 毒島"
"ぶすや 附子矢"
"ぶせい 部制"
"ぶぜい 無勢"
"ぶぜん 豊前 憮然"
"ぶそう 武装"
"ぶそうへり 武装ヘリ"
"ぶそく 不足"
"ぶそん 蕪村 武尊"
"ぶぞく 部属 部族"
"ぶた 葢 盖 蓋 豚"
"ぶたい 部隊 舞台"
"ぶたいそで 舞台袖"
"ぶたいゆか 舞台床"
"ぶたがわ 豚皮 豚革"
"ぶたこま 豚小間"
"ぶたごや 豚小屋"
"ぶたしゃぶ 豚しゃぶ"
"ぶたじる 豚汁"
"ぶたたま 豚玉"
"ぶたたまてん 豚玉天"
"ぶたどん 豚丼"
"ぶたにく 豚肉"
"ぶたばこ ブタ箱 豚箱"
"ぶたひれ 豚ヒレ"
"ぶたまん 豚まん 豚饅"
"ぶたもも 豚モモ"
"ぶたろーす 豚ロース"
"ぶだいか 舞台化"
"ぶだん 武断"
"ぶち 駁 鞭 渊 渕 淵 縁 斑"
"ぶちぎれ ブチ切れ"
"ぶちこわし 打ち壊し"
"ぶちょう 部長"
"ぶちょうづき 部長付"
"ぶちょうほう 不調法"
"ぶっか 仏家 仏果 物化 物価"
"ぶっかい 仏界 物界"
"ぶっかき 打っ欠き"
"ぶっかく 物覚 仏閣"
"ぶっかけ 打っ掛け"
"ぶっかつろん 物活論"
"ぶっきょう 仏経 物狂 佛教 仏教"
"ぶっけ 仏家"
"ぶっけん 物研 物権 物件"
"ぶっけんてきせいきゅうけん 物権的請求権"
"ぶっこ 物故"
"ぶっこう 物工"
"ぶっこく 仏国"
"ぶっさつ 仏刹"
"ぶっさん 仏参 物産"
"ぶっし 仏子 仏師 物資"
"ぶっしき 仏式"
"ぶっしつ 物質"
"ぶっしゃり 仏舎利"
"ぶっしょ 仏書"
"ぶっしょう 物象 仏性 物証"
"ぶっしょうい 仏正意"
"ぶっしょうえ 仏生会"
"ぶっしょく 物色"
"ぶっしん 仏身 物神 物心 仏心"
"ぶっせい 仏性 物性"
"ぶっせき 仏跡"
"ぶっせつ 仏説"
"ぶっそ 仏祖"
"ぶっそう 仏葬 物騒"
"ぶっそうげ 仏桑花"
"ぶっそくせき 仏足石"
"ぶっそん 物損"
"ぶったい 仏体 物体"
"ぶっだ 仏陀"
"ぶっち 仏智"
"ぶっちょうずら 仏頂面"
"ぶっちょうづら 仏頂面"
"ぶっつけほんばん 打っ付け本番"
"ぶってき 物的"
"ぶってん 仏典"
"ぶっと 仏徒"
"ぶっとう 仏頭 仏塔"
"ぶっとおし ぶっ通し 打っ通し"
"ぶっぱん 物販"
"ぶっぴん 物品"
"ぶっぽう 仏法"
"ぶつ 佛 勿 仏 物"
"ぶつえん 仏縁"
"ぶつえんほう 仏炎苞"
"ぶつおん 仏恩"
"ぶつが 仏画"
"ぶつがく 仏学"
"ぶつがん 仏願 仏龕"
"ぶつきつ 勿吉"
"ぶつぎ 物議"
"ぶつぎり ぶつ切り"
"ぶつぐ 物具 仏具"
"ぶつげん 仏眼"
"ぶつご 仏語"
"ぶつざ 仏座"
"ぶつざん 仏山"
"ぶつじ 仏地 仏寺 仏事"
"ぶつじょう 物情"
"ぶつじょうだいい 物上代位"
"ぶつじょうほしょうにん 物上保証人"
"ぶつじん 仏神"
"ぶつぜん 仏前"
"ぶつぞう 仏像"
"ぶつだ 仏陀"
"ぶつだい 仏大"
"ぶつだん 仏壇"
"ぶつでし 仏弟子"
"ぶつでん 仏伝 仏殿"
"ぶつど 仏土"
"ぶつどう 仏堂 仏道"
"ぶつのう 物納"
"ぶつばつ 仏罰"
"ぶつぶつ 勿勿 物々"
"ぶつほけん 物保険"
"ぶつま 仏間"
"ぶつみょう 仏名"
"ぶつめつ 仏滅"
"ぶつもう 勿罔"
"ぶつもつ 仏物"
"ぶつもん 仏門"
"ぶつよく 物欲"
"ぶつり 物理"
"ぶつりがく 物理學"
"ぶつりき 仏力"
"ぶつりゅう 物流"
"ぶつりょう 物療 物量"
"ぶつるいしょうこ 物類称呼"
"ぶてい 武帝"
"ぶでん 舞殿"
"ぶと 太"
"ぶとう 武闘 舞踏"
"ぶとん 蒲団 布団"
"ぶどう 葡萄 武道"
"ぶどうか ブドウ科"
"ぶどうかん 武道舘"
"ぶどうがり ぶどう狩り"
"ぶどうしゅ ブドウ酒 ぶどう酒"
"ぶどうだな 葡萄棚"
"ぶどうとう ブドウ糖 葡萄糖"
"ぶどうねずみ 葡萄鼠"
"ぶどうばたけ 葡萄畑"
"ぶどまり 歩留り 歩留まり"
"ぶな 樗 山毛欅 椈"
"ぶない 部内"
"ぶなもく ブナ目"
"ぶなん 武南 無難"
"ぶにん 補任 無人"
"ぶね 船"
"ぶはぶっきょう 部派仏教"
"ぶばいがわら 分倍河原"
"ぶひ 部費"
"ぶひん 部品"
"ぶひんきょうはん 部品共販"
"ぶび 武備"
"ぶびき 歩引き"
"ぶふうりゅう 無風流"
"ぶぶづけ ぶぶ漬け"
"ぶぶん 舞文 部分"
"ぶぶんぎ 部分木"
"ぶぶんし 部分枝"
"ぶぶんにく 部分肉"
"ぶぶんわ 部分和"
"ぶへん 武辺"
"ぶべつ 部別 侮蔑"
"ぶま 不間"
"ぶみ 文"
"ぶめい 武名 部名"
"ぶめん 部面"
"ぶもどし 歩戻し"
"ぶもん 武門 部門"
"ぶゆ 蚋"
"ぶゆう 武勇"
"ぶよ 蚋"
"ぶよう 舞踊"
"ぶようじん 無用心 不用心"
"ぶようどう 武揚堂"
"ぶらい 不頼 無頼"
"ぶらいかん 無頼漢"
"ぶらうんうんどう ブラウン運動"
"ぶらうんかん ブラウン管"
"ぶらく 部落"
"ぶらじる 伯剌西爾"
"ぶらじるじん ブラジル人"
"ぶらすばんどぶ ブラスバンド部"
"ぶらんこ 鞦韆"
"ぶらんどひん ブランド品"
"ぶらんどまい ブランド米"
"ぶらんどもの ブランド物"
"ぶらんどりょく ブランド力"
"ぶり 振り 風 鰤"
"ぶりきかん ブリキ缶"
"ぶりだいこん ブリ大根 鰤大根"
"ぶりっこ ぶりっ子"
"ぶりゃく 武略"
"ぶりょう 無聊"
"ぶりょうとうげん 武陵桃源"
"ぶりょく 武力"
"ぶるい 部類"
"ぶるがりあ 勃牙利"
"ぶるまい 振舞い"
"ぶれい 無礼"
"ぶれいこう 無礼講"
"ぶれつ 武烈"
"ぶれんどまい ブレンド米"
"ぶろ 風呂"
"ぶろっくか ブロック化"
"ぶろっくくずし ブロック崩し"
"ぶろっくけいざい ブロック経済"
"ぶろっくし ブロック紙"
"ぶろっくべい ブロック塀"
"ぶろんずいろ ブロンズ色"
"ぶろんずぞう ブロンズ像"
"ぶわけ 部分け"
"ぶわり 歩割"
"ぶん 蚊 馼 紊 聞 文 分"
"ぶんあつ 分圧"
"ぶんあん 文安 文案"
"ぶんい 文意"
"ぶんいき 分域"
"ぶんいち 文一"
"ぶんいん 分院"
"ぶんうん 文運"
"ぶんえい 文永"
"ぶんえん 文園 文苑 分園 分煙"
"ぶんおう 文応"
"ぶんか 分果 分課 文華 分科 文科 分化 文化"
"ぶんかい 文界 分界 分会 分解"
"ぶんかいせき 文解析"
"ぶんかく 文格 文革 分画"
"ぶんかしゃったー 文化シャッター"
"ぶんかせんたー 文化センター"
"ぶんかつ 分轄 分割"
"ぶんかのひ 文化の日"
"ぶんかん 文官 分館"
"ぶんかんすう 文関数"
"ぶんが 文雅"
"ぶんがい 分外"
"ぶんがく 文學 文学"
"ぶんがっか 文学科"
"ぶんき 文亀 分岐"
"ぶんきゅう 分球 文久"
"ぶんきょう 文京 文教"
"ぶんきょく 分局 分極"
"ぶんきん 分近"
"ぶんきんたかしまだ 文金高島田"
"ぶんぎ 文義 分木"
"ぶんぎょう 文業 分業"
"ぶんく 分区"
"ぶんぐ 文具"
"ぶんけ 分家"
"ぶんけい 文型 文系"
"ぶんけん 文検 分遣 分県 分権 文献"
"ぶんげい 文藝 文芸"
"ぶんげいざ 文芸坐"
"ぶんげん 分限 文言"
"ぶんこ 文庫"
"ぶんこう 分校 分光"
"ぶんこうぞう 文構造"
"ぶんこく 分国"
"ぶんこつ 分骨"
"ぶんご 文語 豊後"
"ぶんごう 分合 文豪"
"ぶんごし 文語詩"
"ぶんごぶし 豊後節"
"ぶんさい 文彩 文才"
"ぶんさく 文作"
"ぶんさつ 分冊"
"ぶんさん 分散"
"ぶんさんきょうゆうめもり 分散共有メモリ"
"ぶんさんしすてむ 分散システム"
"ぶんさんめもり 分散メモリ"
"ぶんざい 分際"
"ぶんし 分祀 分枝 文士 分詞 分子"
"ぶんしつ 分室"
"ぶんしつひんぴん 文質彬彬"
"ぶんしないしんどう 分子内振動"
"ぶんしゃ 分社"
"ぶんしゅう 分周 文集"
"ぶんしゅく 分宿"
"ぶんしゅつ 分出"
"ぶんしゅん 文春"
"ぶんしょ 分所 分署 文書"
"ぶんしょう 文正 文相 分掌 文章"
"ぶんしょうがたていぎ 文章型定義"
"ぶんしょがたていぎ 文書型定義"
"ぶんしょく 文飾"
"ぶんしん 聞診 文身 分身"
"ぶんじ 文辞 文事 文二 文治"
"ぶんじたい 文自体"
"ぶんじゃく 文弱"
"ぶんじょう 分乗 分譲"
"ぶんじょうまんしょん 分譲マンション"
"ぶんじん 文人"
"ぶんすい 分水"
"ぶんすいれい 分水嶺"
"ぶんすう 分数"
"ぶんせい 文勢 文政"
"ぶんせいせい 文生成"
"ぶんせいどう 文盛堂"
"ぶんせき 文責 分析"
"ぶんせつ 分節 文節"
"ぶんせつぎり 文節切"
"ぶんせん 文選"
"ぶんせんどう 文泉堂"
"ぶんせんめい 文鮮明"
"ぶんぜんたい 文全体"
"ぶんそう 文藻 分奏"
"ぶんそん 分損 分村"
"ぶんた 文太"
"ぶんたい 分隊 文体"
"ぶんたいおう 文対応"
"ぶんたん 文旦 分担"
"ぶんだい 文題 文台 分大"
"ぶんだん 文壇 分団 分断"
"ぶんだんしょうじ 分段生死"
"ぶんち 聞知 分置 分地 文治"
"ぶんちゅう 分注 文中"
"ぶんちゅうじょ 分駐所"
"ぶんちょう 文調 文鳥"
"ぶんちん 文珍 文鎮"
"ぶんつう 文通"
"ぶんてい 文帝"
"ぶんてん 文典 文展 分点 分店"
"ぶんでん 分電"
"ぶんとう 文頭"
"ぶんとん 分屯"
"ぶんにょう 文繞"
"ぶんにん 分任"
"ぶんのいち 分の１ 分の一"
"ぶんのう 分納"
"ぶんは 分派"
"ぶんばい 分売"
"ぶんばんごう 文番号"
"ぶんぱ 分波 分派"
"ぶんぱい 分配"
"ぶんぱん 文範"
"ぶんび 文尾"
"ぶんぴ 分泌"
"ぶんぴつ 分筆 文筆 分泌"
"ぶんぶ 文武"
"ぶんぶくちゃがま 分福茶釜 文福茶釜"
"ぶんぶつ 文物"
"ぶんぷ 分賦 分布"
"ぶんべつ 分別"
"ぶんべん 分娩"
"ぶんぺい 文平"
"ぶんぼ 分母"
"ぶんぼうぐ 文房具"
"ぶんぽう 分封 文保 文法"
"ぶんまつ 文末"
"ぶんみつとう 分蜜糖"
"ぶんみゃく 文脈"
"ぶんみん 文民"
"ぶんめい 文名 分明 文明"
"ぶんめん 文面"
"ぶんや 文屋 分野"
"ぶんやぶし 文弥節"
"ぶんゆう 分有"
"ぶんよ 分与"
"ぶんよう 文葉"
"ぶんらく 文楽"
"ぶんらん 紊乱"
"ぶんり 分利 文理 分離"
"ぶんりか 分離果"
"ぶんりつ 分率 分立"
"ぶんりのう 分離脳"
"ぶんりゃく 文暦"
"ぶんりゅう 分溜 分留 分流"
"ぶんりょう 分領 分量"
"ぶんりょく 分力"
"ぶんるい 分類"
"ぶんるいぎ 分類木"
"ぶんれい 分霊 文例"
"ぶんれつ 分列 分裂"
"ぶんれつか 分裂果"
"ぶんろく 文禄"
"ぶんろくのえき 文禄の役"
"ぶんわ 文話 文和"
"ぷ 符 布 腐"
"ぷーるせい プール制"
"ぷーるねつ プール熱"
"ぷーるびらき プール開き"
"ぷう 風"
"ぷく 服 幅"
"ぷさい Ψ ψ"
"ぷさん 釜山"
"ぷしー Ψ ψ"
"ぷっしゅがた プッシュ型"
"ぷっしゅしき プッシュ式"
"ぷらいばしーけん プライバシー権"
"ぷらいばしーしんがい プライバシー侵害"
"ぷらざごうい プラザ合意"
"ぷらす ＋"
"ぷらすあるふぁ プラスα"
"ぷらすしこう プラス思考"
"ぷらすちっくせい プラスチック製"
"ぷらすちっくばくだん プラスチック爆弾"
"ぷらすまいなす ±"
"ぷらすめん プラス面"
"ぷらすよういん プラス要因"
"ぷらすようそ プラス要素"
"ぷらとんしゅぎ プラトン主義"
"ぷらまい ±"
"ぷらんくていすう プランク定数"
"ぷらんとゆしゅつ プラント輸出"
"ぷりぺいどしき プリペイド式"
"ぷりんえんき プリン塩基"
"ぷりんたい プリン体"
"ぷりんとがら プリント柄"
"ぷりんときばん プリント基板"
"ぷるがた プル型"
"ぷれいちゅう プレイ中"
"ぷれすき プレス機"
"ぷれはぶごや プレハブ小屋"
"ぷろいしき プロ意識"
"ぷろぐらみんぐげんご プログラミング言語"
"ぷろぐらむごうせい プログラム合成"
"ぷろこんじょう プロ根性"
"ぷろしあ 普魯西"
"ぷろせすかん プロセス間"
"ぷろせんしゅ プロ選手"
"ぷろそう プロ相"
"ぷろばいだーせきにんほう プロバイダー責任法"
"ぷろぺらき プロペラ機"
"ぷろもばん プロモ盤"
"ぷろやきゅう プロ野球"
"ぷろよう プロ用"
"ぷろれすわざ プロレス技"
"ぷろれたりあぶんがく プロレタリア文学"
"ぷん 分"
"ぷんかん 分間"
"ぷんはん 分半"
"ぷんまえ 分前"
"へ 邉 邊 辺 戸 舳 経 屁"
"へーべー 平米"
"へい 竝 閇 陛 箆 坪 睥 嬖 娉 聘 瓶 餅 并 併 炳 病 柄 斃 敝 蔽 弊 幤 幣 並 平 閉 丙 屏 塀 兵"
"へいあん 平安"
"へいあんきょう 平安京"
"へいあんちょう 平安朝"
"へいい 弊衣 平易"
"へいいき 閉域"
"へいいち 平一"
"へいいん 閉院 兵員"
"へいえい 併映 兵営"
"へいえき 兵役"
"へいえん 閉宴 閉園"
"へいおく 弊屋"
"へいおん 閉音 併音 平音 平温 平穏"
"へいか 併課 閉果 併科 兵科 兵火 平価 閉架 陛下"
"へいかい 閉会"
"へいかつ 平滑"
"へいかん 閉管 閉館"
"へいが 平臥"
"へいがい 弊害"
"へいがく 兵学"
"へいがっこう 兵学校"
"へいがん 併願"
"へいき 兵機 並記 併記 平気 兵器"
"へいきしょう 兵器廠"
"へいきち 平吉"
"へいきゃく 閉脚"
"へいきゅう 閉球"
"へいきょ 閉居"
"へいきょく 平曲"
"へいきん 平均"
"へいぎょう 閉業"
"へいけ 平家"
"へいけい 閉経"
"へいけがに 平家蟹"
"へいけだに 平家谷"
"へいけつ 併結"
"へいげい 睥睨"
"へいげん 平原"
"へいこう 敝垢 閉項 平向 併行 閉校 閉口 平衡 並行 平行"
"へいこうぎ 平衡木"
"へいこうこう 平行光"
"へいこうぼう 平行棒"
"へいこうみゃく 平行脈"
"へいご 兵語 平語"
"へいごう 并合 併合"
"へいさ 閉鎖"
"へいさい 併載 併催"
"へいさか 閉鎖花"
"へいさく 平朔 平作"
"へいさつ 併殺"
"へいざん 閉山"
"へいし 弊紙 瓶子 斃死 閉止 平氏 弊誌 兵士"
"へいしき 閉式"
"へいしゃ 平射 兵舎 弊社"
"へいしゅ 兵種 丙種"
"へいしゅう 弊習"
"へいしゅつ 迸出 併出 平出"
"へいしょ 兵書 弊所 閉所"
"へいしん 平信 並進 平身"
"へいじ 平次 兵事 平治 平時"
"へいじつ 平日"
"へいじつあさ 平日朝"
"へいじゅつ 兵術"
"へいじゅん 平準"
"へいじょ 平叙"
"へいじょう 平常 閉場 平壌 平城"
"へいじょうきょう 平城京"
"へいじん 敝人"
"へいすう 兵数"
"へいすけ 平祐 平助"
"へいせい 弊政 幣制 兵制 平静 平成"
"へいせき 兵籍 平積"
"へいせつ 併設"
"へいせん 兵船"
"へいぜい 平生"
"へいぜいごうじょう 平生業成"
"へいぜいてんのう 平城天皇"
"へいぜん 炳然 平然"
"へいそ 平素"
"へいそう 兵曹 兵装 並走 併走"
"へいそく 屏息 閉塞"
"へいそつ 兵卒"
"へいそん 並存 併存"
"へいぞく 平俗"
"へいぞん 並存 併存"
"へいたい 平体 兵隊"
"へいたいあり 兵隊蟻"
"へいたく 弊宅"
"へいたん 平淡 兵站 平坦"
"へいだん 兵団"
"へいち 並置 併置 平地"
"へいちゅうものがたり 平中物語 平仲物語"
"へいちょう 敝腸 平調 兵長 閉庁"
"へいてい 閉廷 平定"
"へいてん 弊店 閉店"
"へいてんせーる 閉店セール"
"へいとう 弊竇 平等"
"へいとうしょうしゅつ 平頭抄出"
"へいどく 併読"
"へいどん 併呑"
"へいない 平内"
"へいにん 併任"
"へいねつ 平熱"
"へいねん 平年"
"へいのうぶんり 兵農分離"
"へいはく 幣帛"
"へいはち 平八"
"へいはつ 併発"
"へいはん 平版"
"へいば 兵馬"
"へいばい 併売"
"へいばよう 兵馬俑"
"へいばん 平板"
"へいび 兵備"
"へいふ 敝賦"
"へいふう 弊風"
"へいふく 平復 平服 平伏"
"へいぶ 弊部"
"へいぶん 平分 平文"
"へいへい 平々 平平"
"へいへいぼんぼん 平平凡凡 平々凡々"
"へいべい 平米"
"へいほう 閉包 兵法 平方"
"へいほうこん 平方根"
"へいほうめーとる 平方米"
"へいぼん 平凡"
"へいまく 閉幕"
"へいみゃく 平脈"
"へいみん 平民"
"へいめい 平明"
"へいめん 平面"
"へいめんきょう 平面鏡"
"へいめんばん 平面板"
"へいもつ 幣物"
"へいもん 閉門"
"へいや 平野"
"へいゆ 平癒"
"へいゆう 併有"
"へいよう 並用 併用"
"へいようきょう 併用橋"
"へいよん 海永"
"へいらん 兵乱"
"へいり 敝履 弊履"
"へいりつ 並立"
"へいりゃく 兵略"
"へいりょく 兵力"
"へいれつ 並列"
"へいれつましん 並列マシン"
"へいれつもでる 並列モデル"
"へいろ 平炉 閉路"
"へいろく 併録"
"へいわ 平和"
"へいわぼけ 平和ボケ"
"へえ 兵衛"
"へおんきごう ヘ音記号"
"へき 日置 闢 辟 躄 甓 劈 璧 僻 碧 癖 壁"
"へきあつ 壁厚"
"へきうん 碧雲"
"へきえき へき易 辟易"
"へきえん 僻遠"
"へきかい 劈開 碧海"
"へきかん 壁間"
"へきが 壁画"
"へきがん 壁龕 碧眼"
"へきぎょく 碧玉"
"へきくう 碧空"
"へきけん 僻見"
"へきこういき 壁孔域"
"へきざい 壁材"
"へきしょ 壁書"
"へきしょく 碧色"
"へきじゃ 辟邪"
"へきすい 碧水"
"へきすう 僻陬"
"へきせつ 僻説"
"へきせん 壁泉"
"へきそん 僻村"
"へきたい 壁体"
"へきたん 碧潭"
"へきち 僻地"
"へきちゅう 壁中"
"へきとう 劈頭"
"へきない 壁内"
"へきなん 碧南"
"へきはく 璧帛"
"へきめん 壁面"
"へきらく 碧落"
"へきるり 碧瑠璃"
"へきれき 霹靂"
"へきろん 僻論"
"へくとぐらむ 瓸"
"へくとめーとる 粨"
"へくとりっとる 竡"
"へぐらじま 舳倉島"
"へぐり 平群"
"へこおび 兵児帯"
"へこみ 凹み"
"へご 竹畚"
"へさき 舳 舳先"
"へしきや 平敷屋"
"へそ 綜麻 巻子 臍"
"へそくり 臍繰り"
"へそのお 臍の緒"
"へそまがり 臍曲り 臍曲がり ヘソ曲がり へそ曲がり"
"へた 蒂 戸田 蔕 下手"
"へたくそ 下手糞"
"へたっぴ 下手っぴ"
"へたんちょう ヘ短調"
"へだ 戸田"
"へだたり 隔たり 隔"
"へだて 隔て"
"へちま 糸瓜"
"へちょうちょう ヘ長調"
"へっぴりごし へっぴり腰 屁っ放り腰"
"へつ 暼 丿"
"へつらい 諂い"
"へど 反吐 嘔吐"
"へな 埴"
"へなちょこ 埴猪口"
"へのかっぱ 屁の河童"
"へのこ 陰核"
"へのじ への字"
"へび 巳 蛇"
"へびーきゅう ヘビー級"
"へびいちご 蛇苺"
"へびくち 蛇口"
"へびざ 蛇座"
"へびつかいざ 蛇遣い座"
"へびどく 蛇毒"
"へびどし 巳年"
"へぶらいご ヘブライ語"
"へぶらいもじ ヘブライ文字"
"へぼんしき ヘボン式"
"へみ 逸見"
"へや 廰 廳 部屋"
"へやかず 部屋数"
"へやさがし 部屋探し"
"へやずみ 部屋住み"
"へやばき 部屋履き"
"へら 箆 篦"
"へらい 戸来"
"へらくれすざ ヘラクレス座"
"へらさぎ 篦鷺"
"へらずぐち 減らず口"
"へり 邉 邊 辺 縁"
"へりくつ 屁理屈"
"へるくれすざ ヘルクレス座"
"へるすじょう ヘルス嬢"
"へん 邉 邊 變 貶 駢 胼 騙 諞 褊 蝙 翩 扁 偏 遍 返 片 篇 編 辺 変"
"へんあい 偏愛"
"へんあつ 変圧"
"へんい 偏倚 変イ 偏移 偏位 変移 変位 変異"
"へんいき 変域"
"へんうん 片雲"
"へんえい 片影"
"へんえき 変易"
"へんえん 辺縁"
"へんおん 変音 変温"
"へんか 返歌 変化"
"へんかい 変改"
"へんかく 変格 偏角 変革"
"へんかん 返還 変換"
"へんかんけーぶる 変換ケーブル"
"へんかんこねくた 変換コネクタ"
"へんかんすう 偏関数"
"へんかんそふと 変換ソフト"
"へんかんてーぶる 変換テーブル"
"へんがく 扁額 変額"
"へんがん 片岩"
"へんき 偏奇 偏倚"
"へんきゃく 返却"
"へんきゅう 扁球 返球"
"へんきょう 偏狭 辺境"
"へんきょく 変局 偏極 編曲"
"へんきょくてん 変曲点"
"へんきん 返金"
"へんくつ 偏屈"
"へんぐう 辺隅 片隅"
"へんけい 辺形 扁形 変型 変形"
"へんけん 偏見"
"へんげ 変化"
"へんげん 変幻 片言"
"へんこ 偏固"
"へんこう 変項 変光 偏向 偏光 変更"
"へんこうこう 偏向光"
"へんこうせい 変光星"
"へんこうばん 偏光板"
"へんこうまく 偏光膜"
"へんご 片語"
"へんごう 辺合"
"へんさ 騙詐 偏差"
"へんさい 辺際 変災 返済"
"へんさん 偏衫 編纂"
"へんざい 辺材 遍在 偏在"
"へんし 返詩 変死"
"へんしつ 偏執 変質"
"へんしゃ 編者"
"へんしゃぞう 偏写像"
"へんしゅ 騙取 変種"
"へんしゅう 扁舟 偏執 編修 編輯 編集"
"へんしょ 返書"
"へんしょう 返照"
"へんしょく 偏食 変色"
"へんしん 遍身 変心 偏心 変身 返信"
"へんじ 返辞 変事 片時 返事"
"へんじこ 偏自己"
"へんじまち 返事待"
"へんじゃ 編者"
"へんじゅつ 編述"
"へんじょう 変成 辺上 遍照 変状 返上"
"へんじょうか 編上靴"
"へんじん 變人 変人"
"へんすう 変数"
"へんずつう 偏頭痛"
"へんせい 遍性 変声 変成 編制 変性 編成"
"へんせいがん 変成岩"
"へんせいたん 編成端"
"へんせいふ 変成譜"
"へんせいふう 偏西風"
"へんせきうん 片積雲"
"へんせつ 変説 変節"
"へんせつかん 変節漢"
"へんせん 変遷"
"へんそ 辺素 編組"
"へんそう 変相 変奏 変装 返送"
"へんそううん 片層雲"
"へんそく 変則 変速"
"へんぞう 変造"
"へんたい 変体 編隊 変態"
"へんち 辺地"
"へんちゅう 編注"
"へんちょ 編著"
"へんちょう 変長 偏重 変調"
"へんつう 変通"
"へんてこ 変テコ 変てこ 変梃"
"へんてつ 変哲"
"へんてん 変転"
"へんでん 返電 変電"
"へんと 変ト"
"へんとう 扁桃 返答"
"へんど 辺土"
"へんどう 変動"
"へんどうかんすう 偏導関数"
"へんに 変ニ"
"へんにゅう 編入"
"へんねん 編年"
"へんのう 返納"
"へんのうゆ 片脳油"
"へんは 変ハ"
"へんばい 反閇 変倍"
"へんぱ 偏頗 偏波"
"へんぱい 返盃 返杯 変敗"
"へんびぶん ∂ 偏微分"
"へんぴ 辺鄙"
"へんぴん 返品"
"へんぶん 変分"
"へんぷ 返付"
"へんぷく 辺幅 蝙蝠"
"へんへ 変ヘ"
"へんぺい 扁平"
"へんぺいそく 偏平足"
"へんぺいりつ 偏平率"
"へんぺん 翩々 辺々 片々"
"へんほ 変ホ"
"へんぼう 偏旁 変貌"
"へんぽう 偏法 返報"
"へんぽん 翩翻 返本"
"へんまひ 片麻痺"
"へんまもう 偏摩耗"
"へんまん 遍満"
"へんみ 辺見 逸見"
"へんみん 辺民"
"へんむ 片務"
"へんめい 変名"
"へんやく 変約 編訳"
"へんよう 遍用 変様 変容"
"へんらん 変乱"
"へんりょう 変量"
"へんりん 片鱗"
"へんれい 返戻 返礼"
"へんれき 遍歴"
"へんろ 変ロ 遍路"
"べ 邉 邊 倍 辺 部"
"べーじゅいろ ベージュ色"
"べーじゅじ ベージュ地"
"べーた Β β"
"べーたかろちん βカロチン"
"べーたせん ベータ線 β線"
"べーたは β波"
"べーたばん β版"
"べーたほうかい β崩壊"
"べーちぇっとびょう ベーチェット病"
"べい 塀 米"
"べいえい 米英"
"べいおう 米欧"
"べいか 米貨 米価 米菓"
"べいがわ 米側"
"べいぐん 米軍"
"べいけい 米系"
"べいこく 米穀 米国"
"べいご 米語"
"べいごま 貝独楽"
"べいさく 米作"
"べいさん 米産"
"べいし 米紙"
"べいしきしゅうきゅう 米式蹴球"
"べいしゃ 米車"
"べいしゅう 米収"
"べいしゅうきこう 米州機構"
"べいしゅん 米春"
"べいしょく 米食"
"べいじゅ 米寿"
"べいじん 米人"
"べいせいせんそう 米西戦争"
"べいそ 米ソ"
"べいちゅう 米駐 米中"
"べいちょう 米朝"
"べいてい 米帝"
"べいどる 米ドル"
"べいはん 米飯"
"べいばく 米麦"
"べいふん 米粉"
"べいへい 米兵"
"べいべつ 袂別"
"べいろ 米露 米ロ"
"べえ 兵衛"
"べえた β"
"べき 覓 汨 幎 冖 巾 冪 羃"
"べきしゅうごう 冪集合"
"べきじょう 羃乗 巾乗 冪乗 べき乗"
"べきすう 冪数"
"べく 可"
"べくさかずき 可杯"
"べくとるか ベクトル化"
"べくとるかいせき ベクトル解析"
"べくとるくうかん ベクトル空間"
"べくとるせき ベクトル積"
"べくとるち ベクトル値"
"べくとるば ベクトル場"
"べくとるりょう ベクトル量"
"べじぇきょくせん ベジェ曲線"
"べじえきょくせん ベジエ曲線"
"べすとてん ベスト10"
"べすとでんき ベスト電器"
"べすとばん ベスト盤"
"べた 下手"
"べたきそ ベタ基礎"
"べたぐみ べた組み"
"べたなぎ べた凪"
"べたぬり べた塗り ベタ塗り"
"べたぼめ べた賞め べた褒め"
"べたぼれ ベタ惚れ べた惚れ"
"べたゆき べた雪"
"べっか 別家 別科"
"べっかい 別解"
"べっかく 別格"
"べっかん 別巻 別館"
"べっき 別記"
"べっきょ 別居"
"べっけ 別家"
"べっけい 別掲"
"べっけん 瞥見 別件"
"べっけんこん 別乾坤"
"べっこ 別箇 別個"
"べっこう 別稿 鼈甲 別項"
"べっこうあめ 鼈甲飴"
"べっこん 別懇"
"べっさつ 別冊"
"べっし 別使 蔑視 別紙"
"べっしつ 別室"
"べっしやま 別子山"
"べっしゅ 別趣 別種"
"べっしゅう 別集"
"べっしょ 別書 別所"
"べっしょう 別証 蔑称 別称"
"べっせい 別製 別姓"
"べっせかい 別世界"
"べっせき 別席"
"べっせつ 別節"
"べっせん 別線"
"べっそ 別訴"
"べっそう 別送 別荘"
"べったい 別体"
"べったく 別宅"
"べったらづけ べったら漬け"
"べっちゃく 別役"
"べっちゅう 別注"
"べっちん 別珍"
"べってい 別邸 別定"
"べってん 別添"
"べってんち 別天地"
"べっと 別途"
"べっとう 別当"
"べっとうや 別当家"
"べっぱ 別派"
"べっぴつ 別筆"
"べっぴょう 別表"
"べっぴん 別品 別嬪"
"べっぷ 別府"
"べっぷう 別封"
"べっぽう 別報 別法"
"べっぽん 別本"
"べつ 鼈 瞥 韈 蔑 別"
"べつあん 別案"
"べつい 別異"
"べついん 別院"
"べつうり 別売"
"べつえん 別宴"
"べつかい 別海"
"べつがく 別学"
"べつぎ 別義 別儀"
"べつぎょう 別業 別行"
"べつくち 別口"
"べつげん 別言"
"べつこう 別稿 別項"
"べつご 別語"
"べつごう 別号"
"べつじ 別辞 別字 別事"
"べつじたて 別仕立て"
"べつじょ 蔑如"
"べつじょう 別条 別状"
"べつじょけん 別除権"
"べつじん 別人"
"べつすじ 別筋"
"べつず 別図"
"べつずり 別刷り 別刷"
"べつたいしき 別体式"
"べつだい 別大"
"べつだん 別段"
"べつでん 別伝"
"べつどうたい 別動隊 別働隊"
"べつどり 別録り"
"べつに 別に"
"べつのう 別納"
"べつばい 別売"
"べつばら 別腹"
"べつびん 別便"
"べつふ 別布"
"べつべつ 別々"
"べつま 別間"
"べつみや 別宮"
"べつみょう 別名"
"べつむね 別棟"
"べつめい 別命 別名"
"べつめん 別面"
"べつもの 別物"
"べつやく 別役"
"べつよう 別様"
"べつり 別離"
"べつるい 別涙"
"べつろく 別録"
"べつわく 別枠"
"べとなむご ベトナム語"
"べとなむせんそう ベトナム戦争"
"べに 紅"
"べにいろ 紅色"
"べにうこん 紅鬱金"
"べにえ 紅絵"
"べにお 紅緒"
"べにがら 紅殻"
"べにくじらだん 紅鯨団"
"べにこ 紅粉"
"べにざけ 紅鮭"
"べにざら 紅皿"
"べにしゃけ 紅鮭"
"べにしょうが 紅生薑 紅生姜"
"べにじゃけ 紅鮭"
"べにぞめ 紅染"
"べにたけ 紅茸"
"べにづる 紅鶴"
"べにてんぐたけ 紅天狗茸"
"べにはぎ 紅萩"
"べにばな 紅花"
"べにばなつみうた 紅花摘み唄"
"べにばやし 紅林"
"べにふで 紅筆"
"べにまる 紅丸"
"べにむらさき 紅紫"
"べにやいた ベニヤ板"
"べねちあは ベネチア派"
"べびーよう ベビー用"
"べふ 別府"
"べみん 部民"
"べや 部屋"
"べら 遍羅 倍良"
"べらぼう 箆棒 篦棒"
"べらんめえくちょう べらんめえ口調"
"べり 縁"
"べるぎー 白耳義"
"べるけん ベル研"
"べるさいゆきゅうでん ベルサイユ宮殿"
"べるさいゆじょうやく ベルサイユ条約"
"べるぬじょうやく ベルヌ条約"
"べるりん 伯林"
"べれーぼう ベレー帽"
"べん 采 鞭 娩 眄 湎 宀 汳 抃 卞 冕 辯 瓣 辧 辨 辮 遍 勉 便 弁"
"べんい 便衣 便意"
"べんえき 便益"
"べんかい 弁解"
"べんかん 冕冠 弁韓 弁官"
"べんがく 勉学"
"べんき 便器"
"べんきょう 勉強"
"べんきょうづくえ 勉強机"
"べんぎ 便宜"
"べんぎちせきせん 便宜置籍船"
"べんけい 弁慶"
"べんげい 眄睨"
"べんこ 便壺"
"べんこう 弁巧 弁口"
"べんご 弁護"
"べんさい 弁才 弁済"
"べんざ 便座"
"べんざいてん 弁財天"
"べんざかばー 便座カバー"
"べんし 弁士"
"べんしき 弁識"
"べんしつ 弁室"
"べんしゅつ 娩出"
"べんしょう 弁償"
"べんしょうがく 弁証学"
"べんしょうほう 弁証法"
"べんしょうほうてきろんりがく 弁証法的論理学"
"べんしんろん 弁神論"
"べんじょ 便所"
"べんず ベン図"
"べんぜつ 弁舌"
"べんぜんかん ベンゼン環"
"べんそう 便槽"
"べんぞう 勉三"
"べんたつ 鞭撻"
"べんち 弁知 胼胝"
"べんちいり ベンチ入り"
"べんちうら ベンチ裏"
"べんちゅう 鞭虫"
"べんつう 便通"
"べんつぼ 便壺"
"べんてん 弁天"
"べんとう 弁当"
"べんとうばこ 弁当箱"
"べんとうぶくろ 弁当袋"
"べんなん 弁難"
"べんばく 弁駁"
"べんぱつ 辮髪 弁髪"
"べんぴ 便秘"
"べんべつ 弁別"
"べんべついき 弁別閾"
"べんべん 便々"
"べんぽう 便法"
"べんまく 弁膜"
"べんむ 弁務"
"べんめい 弁明"
"べんもう 鞭毛"
"べんらん 便覧"
"べんり 弁理 便利"
"べんりちょう 便利帖"
"べんりゅう 冕旒"
"べんれい 勉励"
"べんろん 弁論"
"ぺ 屁"
"ぺーじ 頁"
"ぺーじじょう ページ上"
"ぺーじすう 頁数 ページ数"
"ぺーじない ページ内"
"ぺーじばんごう ページ番号"
"ぺーすとじょう ペースト状"
"ぺい 北 閇 蔽 併 閉 平"
"ぺいじ 頁"
"ぺえ 北"
"ぺえじ 頁"
"ぺがさすざ ペガサス座"
"ぺがすすざ ペガスス座"
"ぺき 北"
"ぺきん 北京"
"ぺきんだっく 北京ダック"
"ぺけ ×"
"ぺけぺけ ××"
"ぺすときん ペスト菌"
"ぺっとや ペット屋"
"ぺっとよう ペット用"
"ぺてんし ペテン師"
"ぺとりさら ペトリ皿"
"ぺとりざら ペトリ皿"
"ぺぷちどけつごう ペプチド結合"
"ぺるー 祕露 祕魯"
"ぺるしあ 波斯"
"ぺるしあご ペルシア語"
"ぺるしあせんそう ペルシア戦争"
"ぺるしゃご ペルシャ語"
"ぺるしゃじゅうたん ペルシャ絨毯"
"ぺるしゃねこ ペルシャ猫"
"ぺるしゃわん ペルシャ湾"
"ぺるせうすざ ペルセウス座"
"ぺるむき ペルム紀"
"ぺろぽねそすせんそう ペロポネソス戦争"
"ぺん 邉 邊 篇 編 遍 辺 片"
"ぺんが ペン画"
"ぺんがた ペン型"
"ぺんさき ペン先"
"ぺんしゅうじ ペン習字"
"ぺんじ ペン字"
"ぺんじく ペン軸"
"ぺんたて ペン立て"
"ぺんぺんぐさ ぺんぺん草 ペンペン草"
"ほ 穗 逋 蒲 黼 鯆 餔 脯 埔 葡 匍 哺 甫 浦 畝 葆 堡 圃 捕 輔 舖 鋪 舗 火 保 歩 補 穂 帆"
"ほーこー 火鍋"
"ほーていらおゆい 河底撈魚"
"ほーむらんおう ホームラン王"
"ほーら 和了"
"ほーるこうか ホール効果"
"ほーろーなべ ホーロー鍋"
"ほあし 帆足"
"ほあん 保安"
"ほあんりん 保安林"
"ほい 本意 補遺"
"ほいく 哺育 保育"
"ほいこーろー 回鍋肉"
"ほいこうろう 回鍋肉"
"ほいだ 穂井田"
"ほいっぽ 歩一歩"
"ほいつ 捕逸"
"ほいるやき ホイル焼き"
"ほいろ 焙炉"
"ほう 朴 瀑 匚 勹 寶 寳 宝 豐 豊 迸 琺 抔 幇 烹 封 鴇 蔀 泙 怦 澎 彭 褓 襃 褒 保 呆 篷 烽 鋒 蜂 蓬 縫 峯 峰 逢 棒 捧 奉 俸 鳳 鵬 萠 繃 硼 弸 堋 萌 朋 崩 棚 膀 磅 髣 魴 舫 枋 彷 訪 芳 鞄 麭 袍 苞 皰 疱 焙 炮 垉 咆 匏 飽 胞 泡 抱 庖 包 抛 倣 放 邦 報 砲 法 方"
"ほうあん 奉安 法案 保安"
"ほうい 胞衣 法衣 包囲 方位"
"ほういかいぼう 法医解剖"
"ほういがく 法医学"
"ほういき 法域"
"ほういけん 放医研"
"ほういち 芳一"
"ほういつ 放逸"
"ほういん 宝印 法印"
"ほうえ 胞衣 法衣 法会"
"ほうえい 訪英 泡影 宝永 放映"
"ほうえき 法益"
"ほうえきのほう 縫腋の袍"
"ほうえつ 法悦"
"ほうえん 豊艶 砲煙 方円 保延"
"ほうおう 鳳王 訪欧 法皇 法王 鳳凰"
"ほうおく 蓬屋"
"ほうおん 報恩"
"ほうか 法貨 砲架 邦家 蜂窩 放下 法家 烽火 邦貨 放課 砲火 法科 放火"
"ほうかい 崩解 崩潰 抱懐 法界 崩壊"
"ほうかいいん 法界院"
"ほうかいしゃく 法解釈"
"ほうかいせい 法改正"
"ほうかいせき 方解石"
"ほうかく 方格"
"ほうかこうぎん 放歌高吟"
"ほうかしきえん 蜂窩織炎"
"ほうかだて 邦貨建"
"ほうかつ 包括"
"ほうかん 宝鑑 法官 幇間 宝冠 砲艦 訪韓 奉還"
"ほうかんげきたく 抱関撃柝"
"ほうかんじょう 法感情"
"ほうが 萠芽 奉加 奉賀 芳賀 萌芽 邦画"
"ほうがい 方外 法外"
"ほうがいねん 法概念"
"ほうがく 放学 法学 邦楽 方角"
"ほうがっか 法学科"
"ほうがてき 胞芽的"
"ほうがん 砲眼 砲丸 方眼 判官 包含"
"ほうがんびいき 判官贔屓"
"ほうき 彗 菷 帚 法器 宝器 抛棄 宝亀 芳紀 伯耆 蜂起 箒 放棄 法規"
"ほうきがみ 箒神"
"ほうきぎ 箒木"
"ほうきぐさ 箒草"
"ほうきぼし ほうき星 彗星 箒星"
"ほうきゃく 訪客"
"ほうきゅう 俸給"
"ほうきょう 奉教 豊頬 法橋 豊凶 豊胸"
"ほうきょういんとう 宝篋印塔"
"ほうきん 宝金 砲金"
"ほうぎょ 鮑魚 崩御"
"ほうぎょく 宝玉"
"ほうぎん 放吟 邦銀"
"ほうぐ 反故 法具"
"ほうけい 法系 法経 方形 包茎"
"ほうけん 奉献 宝剣 封建"
"ほうげ 放下"
"ほうげい 奉迎"
"ほうげき 崩撃 砲撃"
"ほうげん 法諺 法眼 法源 保元 放言 方言"
"ほうげんのらん 保元の乱"
"ほうこ 宝庫"
"ほうこう 奉行 砲熕 放校 砲口 咆哮 奉公 彷徨 芳香 方向"
"ほうこうきん 縫工筋"
"ほうこうじ 方広寺"
"ほうこうだ 方向舵"
"ほうこく 封国 奉告 邦国 豊国 報国 報告"
"ほうことう 澎湖島"
"ほうこん 方今"
"ほうご 放語 邦語 法語"
"ほうごう 法号 抱合 縫合"
"ほうさい 朋斎 奉斎 放哉"
"ほうさか 逢坂"
"ほうさく 豊作 方策"
"ほうさん 硼酸 ホウ酸 放散"
"ほうさんちゅう 放散虫"
"ほうざ 砲座"
"ほうざい 包材"
"ほうざわ 寶澤"
"ほうし 褒詞 奉伺 方士 包子 放恣 芳志 奉祀 胞子 法師 奉仕"
"ほうしき 法式 方式"
"ほうしちゅう 胞子虫"
"ほうしちょうだ 封豕長蛇"
"ほうしのう 胞子嚢"
"ほうしゃ 砲車 硼砂 報謝 放射"
"ほうしゃかいがく 法社会学"
"ほうしゃぎり 放射霧"
"ほうしゃくじ 宝積寺"
"ほうしゃこう 放射光"
"ほうしゃせんしょうい 放射線照射"
"ほうしゅ 砲手 法主 宝珠"
"ほうしゅう 豊州 報酬"
"ほうしゅく 奉祝"
"ほうしゅつ 法出 放出"
"ほうしゅん 芳春"
"ほうしょ 倣書 方処 芳書 方所 邦書 報書 奉書 法書"
"ほうしょう 宝商 法性 奉唱 報賞 放縦 宝生 法相 褒賞 報償 褒章 報奨"
"ほうしょく 奉職 飽食 宝飾"
"ほうしょくだんい 飽食暖衣"
"ほうしん 庖疹 芳心 芳信 砲身 疱疹 放心 方針"
"ほうしんのう 法親王"
"ほうじ 捧持 宝治 報時 邦字 法事"
"ほうじちゃ 焙じ茶"
"ほうじゅ 宝珠"
"ほうじゅう 放縱 放銃 放縦"
"ほうじゅく 豊熟"
"ほうじゅつ 方術 法術 砲術"
"ほうじゅん 芳潤 豊潤 芳醇"
"ほうじょ ほう助 幇助"
"ほうじょう 蓬生 豊穰 方乗 宝条 芳情 褒状 北條 方城 法条 方丈 法帖 北条 豊饒 豊穣"
"ほうじょうえ 放生会"
"ほうじょうきたい 胞状奇胎"
"ほうじょうじ 法成寺"
"ほうじょうそううん 北条早雲"
"ほうじん 報身 方陣 邦人 法人"
"ほうじんぶつ 報身仏"
"ほうすい 烹炊 豊水 放水"
"ほうすう 砲数 鳳雛"
"ほうすけ 保介"
"ほうすん 方寸"
"ほうず 方図"
"ほうせ 法施"
"ほうせい 砲声 方正 縫製 法政 法制"
"ほうせいび 法整備"
"ほうせき 宝石"
"ほうせきばこ 宝石箱"
"ほうせつ 包接 抱接 包摂"
"ほうせん 烹鮮 奉先 砲戦 豊泉 芳泉 法線"
"ほうせんいん 宝泉院"
"ほうせんか 鳳仙花"
"ほうせんがくえん 宝仙学園"
"ほうせんきん 放線菌"
"ほうせんべくとる 法線ベクトル"
"ほうぜん 封禅 宝前"
"ほうぜんじ 法善寺"
"ほうそ B 柞 彭祖 ホウ素 硼素"
"ほうそう 蜂巣 法曽 奉送 疱瘡 法相 法曹 包装 放送"
"ほうそうきょう 放送響"
"ほうそうしきえん 蜂巣織炎"
"ほうそく 方則 法則"
"ほうぞう 法蔵 包蔵 宝蔵"
"ほうたい 方体 奉体 繃帯 奉戴 法体 胞体 砲隊 包帯"
"ほうたく 飽託"
"ほうたん 放胆"
"ほうだ 法田"
"ほうだい 法大 砲台 邦題 放題"
"ほうだん 砲彈 法談 放談 砲弾"
"ほうち 封地 法治 報知 放置"
"ほうちく 方竹 放逐"
"ほうちしき 法知識"
"ほうちつじょ 法秩序"
"ほうちぷれい 放置プレイ"
"ほうちゃく 縫着 逢着"
"ほうちゅう 庖厨 包虫 訪中"
"ほうちょう 放鳥 庖丁 訪朝 包丁"
"ほうづえ 方杖"
"ほうてい 捧呈 奉呈 法廷 法定"
"ほうていがいもくてきぜい 法定外目的税"
"ほうていしき 方程式"
"ほうてき 法敵 抛擲 放擲 法的"
"ほうてきばつ 法的罰"
"ほうてつがく 法哲学"
"ほうてん 方転 宝典 奉天 法典"
"ほうでん 宝殿 放電"
"ほうと 方途"
"ほうとう 蓬頭 奉答 法統 法灯 宝刀 宝塔 包頭 砲塔 放蕩"
"ほうとく 宝徳 報徳"
"ほうとり 放取"
"ほうど 邦土 報土 封土"
"ほうどう 報導 法堂 報道"
"ほうどく 奉読"
"ほうなん 法難 豊南 方南"
"ほうに 法爾"
"ほうにち 訪日"
"ほうにょう 放尿"
"ほうにん 放任"
"ほうねつ 放熱"
"ほうねつばん 放熱板"
"ほうねん 芳念 放念 芳年 法然 豊年"
"ほうのう 奉納"
"ほうのせいしん 法の精神"
"ほうはい 奉拝 澎湃"
"ほうはく 鵬搏 方伯"
"ほうはつ 蓬髪"
"ほうはん 訪販"
"ほうば 放馬"
"ほうばい 傍輩 朋輩"
"ほうばつ 放伐"
"ほうひ 包被 豊肥 包皮 放屁"
"ほうび 褒美"
"ほうびちく 鳳尾竹"
"ほうびょう 宝瓶"
"ほうふ 豊冨 豊府 防府 抱負 豊富"
"ほうふく 法服 抱腹 報復"
"ほうふくじ 豊福寺"
"ほうふつ 髣髴 彷彿"
"ほうふん 方墳"
"ほうぶ 邦舞"
"ほうぶつ 放物"
"ほうぶつせん 抛物線"
"ほうぶん 報文 邦文 法文"
"ほうぶんしゃ 芳文社"
"ほうへい 奉幣 砲兵"
"ほうへいきゅう 宝瓶宮"
"ほうへきざん 豊碧山"
"ほうへん 方偏 褒貶"
"ほうべい 訪米"
"ほうべん 方便"
"ほうほう 這う這う 方法"
"ほうほうのてい 這う這うの体"
"ほうほく 豊北"
"ほうほんはんし 報本反始"
"ほうぼう 魴ボウ 宝坊 竹麦魚 蜂房 鋒鋩 謗法 方方 方々"
"ほうぼく 芳墨 放牧"
"ほうまつ 泡沫"
"ほうまん 飽満 放漫 豊満"
"ほうみ 法味 芳味"
"ほうみょう 法名"
"ほうむ 放夢 法務"
"ほうめい 邦名 法明 芳名"
"ほうめん 放免 方面"
"ほうもう 法網"
"ほうもつ 宝物"
"ほうもん 法問 法文 砲門 法門 訪問"
"ほうや 保谷"
"ほうやく 邦訳"
"ほうゆう 包有 邦友 朋友"
"ほうよう 泡影 放鷹 包葉 苞葉 包容 抱擁 法要"
"ほうよく 豊沃"
"ほうら 法螺 和了"
"ほうらい 寳来 鳳来 宝来 蓬莱"
"ほうらく 炮烙 焙烙 包絡 法楽 崩落"
"ほうらくのうたげ 炮烙の宴 炮烙之宴"
"ほうらくのけい 炮烙之刑"
"ほうらくまんじゅう 蜂楽饅頭"
"ほうらつ 放埒"
"ほうらん 抱卵"
"ほうり 宝利 法理"
"ほうりき 法力"
"ほうりつ 法律"
"ほうりゃく 宝暦 方略"
"ほうりゅう 放流"
"ほうりゅうぎょ 放流魚"
"ほうりゅうじ 法隆寺"
"ほうりょう 方領 法量 豊漁"
"ほうりん 法輪 法林"
"ほうりんこう 法輪功"
"ほうりんどうしょてん 芳林堂書店"
"ほうるい 砲塁 堡塁"
"ほうれい 法例 豊麗 法令"
"ほうれき 宝暦"
"ほうれつ 芳烈 砲列 放列"
"ほうれん 法蓮"
"ほうれんそう 鳳蓮草 ほうれん草 法蓮草 菠薐草"
"ほうろう 鳳楼 報労 法臘 法臈 琺瑯 放浪"
"ほうろく 炮烙 焙烙 俸禄"
"ほうろん 放論 法論"
"ほうわ 豊和 法話 飽和"
"ほえき 補益"
"ほえづら 吠面 吠え面"
"ほお 朴 頬"
"ほおかぶり 頬被り"
"ほおげた 頬桁"
"ほおじろ 頬白"
"ほおずき 鬼灯 酸漿"
"ほおずきいち ほおずき市"
"ほおずきぢょうちん 酸漿提灯"
"ほおずり ほお擦り 頬ずり 頬擦り"
"ほおづえ 頬杖"
"ほおのき 朴の木"
"ほおば 朴歯"
"ほおひげ 頬髯 髯"
"ほおぶくろ 頬袋"
"ほおべに 頬紅"
"ほおぼね 頬骨"
"ほおん 保温"
"ほおんなべ 保温鍋"
"ほか 外 他"
"ほかいちめい 他一名"
"ほかおおぜい 他大勢"
"ほかく 補格 補角 保革 捕獲"
"ほかけぶね 帆掛け船"
"ほかげ 灯かげ 帆影 火影"
"ほかすうめい 他数名"
"ほかぜ 帆風"
"ほかたすう 他多数"
"ほかならない 他ならない"
"ほかならぬ 他ならぬ"
"ほかなんにん 他何人"
"ほかに 他に"
"ほかの 他の"
"ほかふたり 他二人"
"ほかん 補間 補完 保管"
"ほがい 補外"
"ほがた 保型"
"ほがらか 朗らか"
"ほき 補器 補記 補機"
"ほきもと 保木本"
"ほきゃく 歩脚"
"ほきゅう 捕球 補給"
"ほきょう 補強"
"ほきん 保菌"
"ほぎ 穂木"
"ほぎうた 寿歌"
"ほく 瀑 蹼 殕 攵 攴 北"
"ほくい 北緯"
"ほくうかん 補空間"
"ほくえい 北瑛"
"ほくえつ 北越"
"ほくおう 北欧"
"ほくが 北画"
"ほくがん 北岸"
"ほくぎ 北魏"
"ほくぐん 北軍"
"ほくげん 北限"
"ほくこう 北興"
"ほくさい 北斎"
"ほくし 北史"
"ほくしゅう 北宗 北州"
"ほくしん 北進 北辰"
"ほくしんきゅうこう 北神急行"
"ほくじょう 北上"
"ほくせい 北征 北勢 北星 北西"
"ほくせいしょ 北斉書"
"ほくせいそう 北誠荘"
"ほくせつ 北摂"
"ほくせん 北線"
"ほくそ 樮"
"ほくそう 北叟 北倉 北宋"
"ほくそうかいはつてつどう 北総開発鉄道"
"ほくそうせん 北総線"
"ほくそうちいき 北総地域"
"ほくたん 北端"
"ほくたんてつどう 北丹鉄道"
"ほくだい 北海道大学 北大"
"ほくだん 北淡"
"ほくち 火口"
"ほくちょう 北朝"
"ほくてき 北狄"
"ほくてつ 北鉄"
"ほくてん 北天"
"ほくでん 北伝 北電"
"ほくと 北都 北斗"
"ほくとう 北東"
"ほくとうみ 北勝海"
"ほくとせい 北斗星"
"ほくとのけん 北斗の拳"
"ほくどう 北堂"
"ほくばく 北爆"
"ほくばつ 北伐"
"ほくふう 北風"
"ほくぶ 北部"
"ほくへき 北壁"
"ほくへん 北辺"
"ほくべい 北米"
"ほくほくとう 北々東"
"ほくぼう 北房"
"ほくめい 北溟"
"ほくめん 北面"
"ほくもん 北門"
"ほくよう 北洋"
"ほくようだい 北陽台"
"ほくら 神庫"
"ほくりく 北陸"
"ほくりくさんけん 北陸三県"
"ほくりゅう 北龍 北竜"
"ほくりょう 北陵"
"ほくりょなんわ 北虜南倭"
"ほくれい 北嶺"
"ほくろ 黒子"
"ほくろく 北麓"
"ほぐし 火串"
"ほぐみ 穂組み"
"ほけきょう 法華経"
"ほけつ 補闕 補欠"
"ほけつば 補欠馬"
"ほけん 保健 保険"
"ほけんふ 保健婦"
"ほげい 捕鯨"
"ほげた 帆桁"
"ほげん 補元 保元"
"ほこ 桙 戟 戈 矛 鉾"
"ほこう 補講 歩行"
"ほこうえい 蒲公英"
"ほこうそ 補酵素"
"ほこさき 鋒先 鋒 鉾先 矛先"
"ほこすぎ 矛杉 鉾杉"
"ほこた 鉾田"
"ほこてん 歩行者天国"
"ほこら 叢祠 祠"
"ほこらか 誇らか"
"ほこり 誇り 埃"
"ほこりたいさく 埃対策"
"ほころび 綻び"
"ほご 反古 補語 反故 保護"
"ほごえ 穂肥"
"ほごちょう 保護鳥"
"ほごまく 保護膜"
"ほごりん 保護林"
"ほさ 輔佐 保佐 補佐"
"ほさか 保坂"
"ほさき 芒 穂先"
"ほさく 補作"
"ほさつ 補殺 捕殺"
"ほざ 帆座"
"ほざわ 保沢"
"ほし 欲し ＊ ※ ★ ☆ 干し 星"
"ほしあい 星合"
"ほしあかり 星明り 星明かり"
"ほしい 星井 糒"
"ほしいい 乾し飯 干し飯 糒"
"ほしいお 干し魚 乾し魚"
"ほしいってつ 星一徹"
"ほしいまま 縦 擅 恣"
"ほしいも 干し芋"
"ほしうお 干魚 干し魚 乾し魚"
"ほしうらない 星占い"
"ほしえび 乾し海老"
"ほしおき 星置"
"ほしかげ 星影"
"ほしかわ 星川"
"ほしがおか 星ヶ丘"
"ほしがき 干柿 干し柿"
"ほしがた 星形 星型"
"ほしがれい 乾鰈 干し鰈 星鰈 干鰈"
"ほしくさ 乾し草 干草 干し草"
"ほしくさもく ホシクサ目"
"ほしくず 星屑"
"ほしくら 星倉"
"ほしぐみ 星組"
"ほしさと 星里"
"ほしざかな 干魚 干し魚"
"ほしざわ 星沢"
"ほししいたけ 干椎茸"
"ほししば 星芝"
"ほししんいち 星新一"
"ほしじし 干肉"
"ほしじるし 星印"
"ほしずめのまつり 鎮火祭"
"ほしぞら 星空"
"ほしたに 星谷"
"ほしだいこん 干大根"
"ほしつ 保湿"
"ほしづき 星月"
"ほしづきよ 星月夜"
"ほしづくよ 星月夜"
"ほしで 星出"
"ほしとり 星取り 星取"
"ほしな 星名 保科"
"ほしにく 乾し肉 干し肉"
"ほしの 星野"
"ほしのかず 星の数"
"ほしば 保志場 干場"
"ほしひょうめん 星表面"
"ほしぶどう 乾し葡萄"
"ほしぼし 星々"
"ほしまつり 星祭 星祭り"
"ほしみ 星見"
"ほしみや 星宮"
"ほしもと 星本"
"ほしもの 乾し物"
"ほしゃく 保釈"
"ほしや 星谷 星矢"
"ほしやま 星山"
"ほしゅ 補手 捕手 保守"
"ほしゅう 捕囚 補習 補修"
"ほしゅうごう 補集合"
"ほしょう 堡礁 歩哨 補償 保障 保証"
"ほしょうぎれ 保証切れ"
"ほしょうれい 蒲松齢"
"ほしょく 補職 補食 補色 捕食"
"ほしよう 補仕様"
"ほしん 保身"
"ほじ 保持"
"ほじきんびょう ホジキン病"
"ほじそ 穂紫蘇"
"ほじゅう 補充"
"ほじょ 輔助 補助"
"ほじょう 捕縄 圃場"
"ほじょけん 補助犬"
"ほじょこう 補助光"
"ほじりょく 保磁力"
"ほすい 保水"
"ほすう 補数 歩数"
"ほすとがわ ホスト側"
"ほすとこく ホスト国"
"ほすとめい ホスト名"
"ほずみ 穂積"
"ほせい 補整 補正"
"ほせいいた 補正板"
"ほせいかじょう 補性過剰"
"ほせき 舗石"
"ほせつ 補説"
"ほせん 保線 補選"
"ほぜい 保税"
"ほぜん 保全"
"ほそ 細"
"ほそい 細井"
"ほそいと 細糸"
"ほそいり 細入"
"ほそう 鋪装 舗装"
"ほそうで 細腕"
"ほそえ 細江"
"ほそおか 細岡"
"ほそおび 細帯"
"ほそおもて 細面"
"ほそかわ 細川"
"ほそがい 細貝"
"ほそき 細木"
"ほそぎ 細木"
"ほそく 歩速 歩測 補則 捕捉 補足"
"ほそくら 細倉"
"ほそぐち 細口"
"ほそごし 細腰"
"ほそざお 細棹"
"ほそざわ 細澤"
"ほそじ 細字"
"ほそせん 細線"
"ほそだ 細田"
"ほそだけ 細竹"
"ほそつ 歩卒"
"ほそなが 細長"
"ほその 細野"
"ほそはら 細原"
"ほそぶち 細渕"
"ほそべ 細部"
"ほそぼそ 細々"
"ほそまき 細巻"
"ほそまゆ 細眉"
"ほそまる 細丸"
"ほそみ 細み 細見 細身"
"ほそみち 細道"
"ほそめ 細め 細目"
"ほそめん 細麺"
"ほそもの 細物"
"ほそや 細矢 細谷"
"ほぞ 蔕 臍"
"ほぞう 保蔵"
"ほぞく 保続"
"ほぞん 保存"
"ほた 榾"
"ほたい 補体 保体"
"ほたおり 保多織"
"ほたか 穂高"
"ほたて 帆立"
"ほたてがい ホタテ貝 帆立貝"
"ほたに 保谷"
"ほたる 火垂る 螢 蛍"
"ほたるいか 蛍烏賊"
"ほたるいし 蛍石"
"ほたるかご 蛍籠"
"ほたるがいけ 蛍ケ池 蛍池"
"ほたるがり 蛍狩 蛍狩り"
"ほたるがわ 蛍川"
"ほたるじゃこ 蛍雑魚"
"ほたるじゃや 蛍茶屋"
"ほたるぞく 蛍族"
"ほたるのひかり 蛍の光"
"ほたるび 蛍火"
"ほたるぶくろ 蛍袋"
"ほたるまつり 蛍祭"
"ほたんちょう ホ短調"
"ほだ 絆"
"ほだい 補題"
"ほだか 穂高"
"ほだぎ 榾木"
"ほちゅう 補註 捕虫 補注"
"ほちゅうあみ 捕虫網"
"ほちょう 補聴 歩調"
"ほちょうちょう ホ長調"
"ほっ 發 発 法"
"ほっかい 法界 北海"
"ほっかいどうみなみ 北海道南"
"ほっかむり 頬っ被り"
"ほっかん 北漢"
"ほっき 発企 発起"
"ほっきがい 北寄貝"
"ほっきょく 北極"
"ほっきょくぐま 北極熊"
"ほっきょくせい 北極星"
"ほっく 発句"
"ほっけ 北家 法華"
"ほっけきょう 法華経"
"ほっけど 法花堂"
"ほっこう 北郊"
"ほっこく 北国"
"ほっこくぎんこう 北國銀行"
"ほっさ 発作"
"ほっしょう 法性"
"ほっしん 法身 発心 発疹"
"ほっしんのう 法親王"
"ほっしんぶつ 法身仏"
"ほっす 法子 法主 払子"
"ほっせき 発赤"
"ほっそうしゅう 法相宗"
"ほっそく 発足"
"ほった 掘田 堀田"
"ほったい 法体"
"ほったて 掘っ建て 掘っ立て 掘建"
"ほったん 発端"
"ほっとう 発頭"
"ほっぴょうよう 北氷洋"
"ほっぺ 頬っぺ"
"ほっぺた 頬っぺた"
"ほっぽう 北方"
"ほつ 発"
"ほつい 発意"
"ほつうきょう 保通協"
"ほつえ 上枝"
"ほつがん 発願"
"ほつぎ 発議"
"ほつご 発語"
"ほつま 秀真"
"ほつれ 解れ"
"ほづ 保津"
"ほづきょう 保津峡"
"ほづつ 火筒"
"ほづな 帆綱"
"ほづみ 穂積"
"ほてい 保定 補訂 補綴 布袋"
"ほていあおい 布袋葵"
"ほていちく 布袋竹"
"ほてつ 補綴"
"ほてん 保典 補填"
"ほと 陰"
"ほとぎ 缶"
"ほとぎへん 缶偏"
"ほとけ 佛 仏"
"ほとけごころ 仏心"
"ほとけさま 仏さま 仏様"
"ほとけのざ 仏の座"
"ほととぎす 蜀魂 杜宇 杜鵑 時鳥 子規 不如帰"
"ほとほと 殆 幾"
"ほとぼり 熱"
"ほとり 邉 邊 滸 畔 辺"
"ほとんど 殆 幾ど 殆んど 殆ど"
"ほど 塊 塊芋 火床 歩度 程"
"ほどあい 程合 程合い"
"ほどいも 塊芋"
"ほどう 舖道 舗道 補導 歩道"
"ほどうきょう 補導協 歩道橋"
"ほどがや 保土が谷 保土ヶ谷"
"ほどこし 施し"
"ほどなく 程なく"
"ほどの 程野"
"ほどほど 程程 程々"
"ほない 保内"
"ほなか 火中"
"ほなが 保永 穂長"
"ほなみ 保奈美 穂波"
"ほにゅう 哺乳"
"ほにゅうびん 哺乳瓶"
"ほにん 補任"
"ほぬの 帆布"
"ほね 骨"
"ほねおしみ 骨惜しみ"
"ほねおり 骨折り"
"ほねかわ 骨川 骨皮"
"ほねかわすじえもん 骨皮筋右衛門"
"ほねぐみ 骨組み 骨組"
"ほねざかな 骨魚"
"ほねしごと 骨仕事"
"ほねっぷし 骨っ節"
"ほねつき 骨付き"
"ほねつきかるび 骨付きカルビ"
"ほねつぎ 骨接ぎ"
"ほねつりょく 保熱力"
"ほねなし 骨無し"
"ほねなしさかな 骨なし魚"
"ほねぬき 骨抜 骨抜き"
"ほねぬきさかな 骨抜き魚"
"ほねばなれ 骨離れ"
"ほねぶと 骨太"
"ほねぼそ 骨細"
"ほねみ 骨身"
"ほねやすみ 骨休み"
"ほねやすめ 骨休め"
"ほの 仄"
"ほのお 焔 炎"
"ほのか 側か 仄か"
"ほのじ ホの字 ほの字"
"ほのぼの 仄仄 仄々"
"ほはば 歩幅"
"ほばく 捕縛"
"ほばしら 艢 檣 帆柱"
"ほばら 保原"
"ほひ 補肥"
"ほひつ 補弼 輔弼 補筆"
"ほふ 保父"
"ほふく 匍匐"
"ほふる 屠る"
"ほぶ 歩武"
"ほぶね 帆船"
"ほへい 歩兵"
"ほべつ 穂別"
"ほほ 頬"
"ほほえみ 頬笑み 微笑 微笑み"
"ほほずゑ 頬杖"
"ほほづえ 頬杖"
"ほほぼね 頬骨"
"ほぼ 保姆 略 保母"
"ほまえ 帆前"
"ほまれ 誉 誉れ"
"ほむぎ 穂麦"
"ほむら 炎 焔"
"ほめことば 褒め言葉 誉め言葉"
"ほめごろし 誉め殺し 褒め殺し"
"ほや 寄生 老海鼠 火舎 穂屋 海鞘 火屋"
"ほやがらす 保谷硝子"
"ほやなぎ 保柳"
"ほやの 保屋野"
"ほゆう 保有"
"ほよう 歩容 保養"
"ほら 法螺 洞"
"ほらーえいが ホラー映画"
"ほらあな 洞穴"
"ほらがい ほら貝 法螺貝"
"ほらがとうげ 洞ヶ峠"
"ほらぐち 洞口"
"ほらど 洞戸"
"ほらふき ほら吹き ホラ吹き 法螺吹き"
"ほり 彫り 濠 壕 捕吏 堀"
"ほりい 堀居 堀井"
"ほりいけ 堀池"
"ほりうち 堀内"
"ほりえ 堀江"
"ほりお 堀尾"
"ほりかわ 堀河 堀川"
"ほりがね 堀金"
"ほりきり 堀切"
"ほりぐち 堀口"
"ほりげん 堀玄"
"ほりこし 堀越"
"ほりこみ 彫込み"
"ほりごたつ 堀ごたつ 掘り炬燵"
"ほりごめ 堀米 堀込"
"ほりさき 堀崎"
"ほりし 彫師"
"ほりた 堀田"
"ほりたつお 堀辰雄"
"ほりだし 掘り出し"
"ほりどめ 堀留"
"ほりの 堀野"
"ほりのうち 堀の内 堀之内"
"ほりのくち 堀之口"
"ほりば 堀場"
"ほりばた 堀端"
"ほりべ 堀辺 堀部"
"ほりまつ 堀松"
"ほりもと 堀本"
"ほりもの 彫物"
"ほりものし 彫り物師"
"ほりゅう 補流 蒲柳 保留"
"ほりゅうのしつ 蒲柳の質"
"ほりょ 捕虜"
"ほりょく 補力"
"ほりわり 掘割"
"ほるい 堡塁"
"ほるもんざい ホルモン剤"
"ほるもんやき ホルモン焼 ホルモン焼き"
"ほるもんりょうほう ホルモン療法"
"ほれい 保冷"
"ほれぐすり 惚れ薬"
"ほれぼれ 惚れ惚れ"
"ほろ 母衣 袰 保呂 幌"
"ほろいずみ 幌泉"
"ほろう 歩廊"
"ほろかない 幌加内"
"ほろくさ 保呂草"
"ほろつき 幌付き"
"ほろにが ほろ苦"
"ほろのべ 幌延"
"ほろばしゃ 幌馬車"
"ほろべつ 幌別"
"ほろほろちょう 珠鶏 ほろほろ鳥"
"ほろよい 微酔い ほろ酔い"
"ほわんちゅー 黄酒"
"ほん 叛 反 笨 畚 犇 奔 飜 翻 本"
"ほんあざ 本字"
"ほんあん 本案 翻案"
"ほんい 翻意 本意 品位 本位"
"ほんいーそー 混一色"
"ほんいだ 本位田"
"ほんいつ 奔逸"
"ほんいん 本員 本因 本院"
"ほんう 本有"
"ほんえ 本絵"
"ほんえい 本影 本営"
"ほんおく 本屋"
"ほんか 本歌 本科"
"ほんかい 本懐 本会"
"ほんかく 本格"
"ほんかわ 本革"
"ほんかん 本艦 本官 本管 本館"
"ほんがかり 本係"
"ほんがく 本学"
"ほんがつお 本鰹"
"ほんがま 本窯"
"ほんがわ 本川"
"ほんがん 本願"
"ほんき 本期 本機 本気"
"ほんきゅう 本給"
"ほんきょ 本挙 本拠"
"ほんきょく 本局"
"ほんきん 本金"
"ほんぎ 本義 本紀"
"ほんぎまり 本決まり"
"ほんぎょう 本行 本業"
"ほんぐう 本宮"
"ほんぐみ 本組"
"ほんぐもり 本曇り"
"ほんけ 本家"
"ほんけい 本慧 本刑"
"ほんけつ 本決"
"ほんけん 本権 本券 本件"
"ほんげい 本芸"
"ほんげつ 本月"
"ほんげん 本源"
"ほんげんてきちくせき 本源的蓄積"
"ほんこう 本甲 本工 本項 本稿 本校"
"ほんこく 翻刻"
"ほんこん 香港"
"ほんこんとう 香港島"
"ほんこんどる 香港ドル"
"ほんご 本語"
"ほんごう 本号 本郷"
"ほんごうしん 本郷新"
"ほんごうそうもく ホンゴウソウ目"
"ほんごく 本石 本国"
"ほんごし 本腰"
"ほんさい 本妻"
"ほんさく 本作"
"ほんさん 本三"
"ほんざん 本山"
"ほんし 本志 本四 本旨 本紙 本誌"
"ほんしき 本式"
"ほんしつ 本質"
"ほんしびさんせん 本四備讃線"
"ほんしゃ 本社"
"ほんしゃびる 本社ビル"
"ほんしゅう 本州"
"ほんしゅつ 奔出 本出"
"ほんしょ 本署 本所 本初 本書"
"ほんしょう 本荘 本証 本賞 本症 本生 本省 本章 本性"
"ほんしょうきょう 本生経"
"ほんしょく 本色 本職"
"ほんしん 本審 本震 本心"
"ほんじ 本辞 翻字 本字 本寺 本地"
"ほんじつ 本日"
"ほんじつよる 本日夜"
"ほんじょ 本所"
"ほんじょう 本匠 本状 本城 本条 本荘 本庄"
"ほんじん 本陣"
"ほんすう 本数"
"ほんすじ 本筋"
"ほんずき 本好き"
"ほんせい 本制 本姓 本性"
"ほんせき 本籍"
"ほんせつ 本説 本節"
"ほんせん 本船 本選 本戦 本線"
"ほんぜん 翻然 本然 本膳"
"ほんそ 本訴"
"ほんそう 本送 本葬 奔走"
"ほんそく 本則"
"ほんぞう 本草"
"ほんぞく 本属"
"ほんぞん 本尊"
"ほんたい 本態 本隊 本体"
"ほんたく 本宅"
"ほんたて 本立"
"ほんだ 誉田 本多 本田"
"ほんだい 本代 本題"
"ほんだち 本裁ち"
"ほんだて 本立"
"ほんだな 本棚"
"ほんち 奔馳 本地"
"ほんちゅー 紅中"
"ほんちゅう 奔注 本注 本中"
"ほんちょう 本朝 本庁 本町"
"ほんづけ 本付"
"ほんて 本手"
"ほんてい 本邸"
"ほんてき 本的"
"ほんてん 本展 本店"
"ほんでん 本伝 本田 本殿"
"ほんと 本当"
"ほんとう 奔騰 本棟 本島 本当"
"ほんど 本渡 本土"
"ほんどう 本道 本堂"
"ほんどく 本読"
"ほんどこ 本床"
"ほんにん 本人"
"ほんぬ 本有"
"ほんぬい 本縫い"
"ほんね 本音"
"ほんねん 本然 本年"
"ほんのう 本能"
"ほんのまち 本の街"
"ほんば 奔馬 本葉 本場"
"ほんばこ 本箱"
"ほんばん 本番"
"ほんぱん 紅幇"
"ほんびき 本引"
"ほんぴょう 本表"
"ほんぴん 本品"
"ほんぶ 本部"
"ほんぶし 本節"
"ほんぶしん 本普請"
"ほんぶり 本降り"
"ほんぶん 本分 本文"
"ほんぷ 本譜"
"ほんぷく 本復"
"ほんべつ 本別"
"ほんぺん 本篇 本編"
"ほんぽ 本圃 本舗"
"ほんぽう 本俸 本報 奔放 本法 本邦"
"ほんま 本馬 本間"
"ほんまち 本町"
"ほんまつ 本末"
"ほんまつり 本祭"
"ほんまる 本丸"
"ほんみょう 本名"
"ほんみょうしょう 本命星"
"ほんむ 本務"
"ほんむねづくり 本棟造り"
"ほんめ 本目"
"ほんめい 本名 奔命 本命"
"ほんめいば 本命馬"
"ほんもう 本望"
"ほんもく 本牧"
"ほんもと 本元"
"ほんもの 本物"
"ほんもん 本問 本文"
"ほんもんじ 本門寺"
"ほんや 本屋"
"ほんやく 飜訳 翻訳"
"ほんゆう 本有"
"ほんらい 本来"
"ほんらん 本欄"
"ほんりゅう 奔流 本流"
"ほんりょう 本領"
"ほんるい 本塁"
"ほんれい 本鈴"
"ほんれき 本暦"
"ほんろう 翻弄"
"ほんろん 本論"
"ぼ 保 牡 姥 菩 謨 模 拇 姆 坊 暮 慕 墓 募 戊 簿 母"
"ぼーあはんけい ボーア半径"
"ぼーすりゅうし ボース粒子"
"ぼーとぶ ボート部"
"ぼーりんぐじょう ボーリング場"
"ぼーるあそび ボール遊び"
"ぼーるがみ ボール紙"
"ぼーるじょう ボール状"
"ぼーるだま ボール球"
"ぼーるどたい ボールド体"
"ぼーるなげ ボール投げ"
"ぼーるばこ ボール箱"
"ぼーるばん ボール盤"
"ぼいき 墓域"
"ぼいどりつ ボイド率"
"ぼいん 拇印 母音"
"ぼう 黽 髦 甍 旄 懋 儚 貿 貌 剖 乏 鵬 呆 罔 网 惘 瑁 冐 冒 袤 茅 謗 蒡 膀 滂 榜 旁 防 肪 紡 妨 傍 鋩 茫 芒 氓 妄 望 忙 忘 亡 虻 眸 牟 鉾 蠎 蟒 昴 茆 卯 胞 抱 尨 厖 膨 瀑 暴 謀 暮雨 帽 坊 房 棒 某"
"ぼうあく 暴悪"
"ぼうあつ 暴圧"
"ぼうあんき 棒暗記"
"ぼうい 暴威"
"ぼういん 暴飲"
"ぼうう 暴雨"
"ぼうえい 防衛"
"ぼうえき 某駅 防疫 貿易"
"ぼうえん 防煙 防炎 望遠"
"ぼうえんきょう 望遠鏡"
"ぼうえんしゃ 暴煙者"
"ぼうえんぞく 暴煙族"
"ぼうえんれんず 望遠レンズ"
"ぼうお 防汚"
"ぼうおく 茅屋"
"ぼうおん 忘恩 防音"
"ぼうか 膨化 防火"
"ぼうかとびら 防火扉"
"ぼうかび 防カビ"
"ぼうかりん 防火林"
"ぼうかん 望観 坊間 暴漢 傍観 防寒"
"ぼうが 忘我"
"ぼうがい 望外 妨害"
"ぼうがしら 棒頭"
"ぼうきゃく 忘却"
"ぼうきょ 暴挙"
"ぼうきょう 防共 望郷"
"ぼうきょく 某局"
"ぼうきれ 棒切れ"
"ぼうきん 防菌"
"ぼうぎ 謀議"
"ぼうぎゃく 暴虐"
"ぼうぎょ 防禦 防御"
"ぼうぎん 棒銀"
"ぼうくう 防空"
"ぼうくうごう 防空壕"
"ぼうくん 亡君 傍訓 某君 暴君"
"ぼうぐ 防具"
"ぼうぐみ 棒組"
"ぼうぐらふ 棒グラフ"
"ぼうけい 亡兄 謀計 傍系"
"ぼうけん 傍見 望見 剖検 冒険"
"ぼうげつ 某月"
"ぼうげん 防眩 妄言 暴言"
"ぼうこ 茫乎"
"ぼうこう 棒鋼 膀胱 暴行"
"ぼうこうがん 膀胱ガン 膀胱がん 膀胱癌"
"ぼうこく 坊刻 亡國 某国 亡国"
"ぼうこひょうが 暴虎馮河"
"ぼうこん 亡魂"
"ぼうご 妄語 防護"
"ぼうさ 防砂"
"ぼうさい 亡妻 防災"
"ぼうさき 棒先"
"ぼうさつ 忙殺 謀殺"
"ぼうさてい 防砂堤"
"ぼうさま 坊様"
"ぼうさりん 防砂林"
"ぼうさん 坊さん"
"ぼうし 望祀 亡子 暴死 亡姉 某紙 紡糸 某誌 某氏 帽子 防止"
"ぼうしつ 忘失 房室 亡失 防湿"
"ぼうしゃ 紡車 房舎 某社"
"ぼうしゅ 芒種"
"ぼうしゅう 防州 房州 防臭"
"ぼうしゅく 昴宿 防縮"
"ぼうしょ 謀書 防暑 某所"
"ぼうしょう 帽章 傍証"
"ぼうしょく 望蜀 紡織 暴食"
"ぼうしょくざい 防食剤"
"ぼうしん 亡心 冒進 傍心 望診 防振"
"ぼうしんねんかい 忘新年会"
"ぼうじ 亡児 房事 防磁"
"ぼうじしゃく 棒磁石"
"ぼうじつ 望日 某日"
"ぼうじま 棒縞"
"ぼうじゃくぶじん 傍若無人"
"ぼうじゅ 傍受"
"ぼうじゅつ 棒術"
"ぼうじゅん 膨潤"
"ぼうじょ 防除"
"ぼうじょう 暴状 坊城 棒状"
"ぼうじん 防刃 防塵"
"ぼうすい 紡錘 防水"
"ぼうすいちゅう 紡錘虫"
"ぼうすいふ 防水布"
"ぼうすじ 某筋"
"ぼうず 坊子 坊主"
"ぼうずあたま 坊主頭"
"ぼうずし 棒寿司"
"ぼうずめくり 坊主めくり"
"ぼうせい 昴星 暴政 防錆"
"ぼうせいまる 望星丸"
"ぼうせき 紡績"
"ぼうせつ 防雪"
"ぼうせつえん 傍接円"
"ぼうせつりん 防雪林"
"ぼうせん 防染 棒線 傍線 防戦"
"ぼうせんもう 防潜網"
"ぼうぜん 惘然 茫然 呆然"
"ぼうそう 房総 暴走"
"ぼうたいほう 暴対法"
"ぼうたおし 棒倒し"
"ぼうたかとび 棒高飛び 棒高跳び"
"ぼうたて 棒立て"
"ぼうだ 滂沱"
"ぼうだい 某大 尨大 防大 傍題 厖大 膨大"
"ぼうだち 棒立ち"
"ぼうだに 防ダニ"
"ぼうだま 棒球"
"ぼうだら 棒鱈"
"ぼうだん 妄談 防弾"
"ぼうだんがらす 防弾ガラス"
"ぼうだんちょっき 防弾チョッキ"
"ぼうちゅう 傍注 房中 忙中 防虫"
"ぼうちょう 防諜 防潮 防長 膨脹 膨張 傍聴 包丁"
"ぼうつい 暴追"
"ぼうてい 亡弟"
"ぼうてき 防滴"
"ぼうてつ 耄耋"
"ぼうてん 某店 傍点"
"ぼうと 暴徒"
"ぼうとう 暴騰 暴投 冒頭"
"ぼうとく 冒涜"
"ぼうどう 暴動"
"ぼうどく 防毒"
"ぼうどくますく 防毒マスク"
"ぼうない 房内"
"ぼうにょう 乏尿"
"ぼうねん 忘年"
"ぼうの 坊野 房野"
"ぼうのつ 坊津"
"ぼうはい 暴牌"
"ぼうはく 傍白"
"ぼうはつ 暴発"
"ぼうはてい 防波堤"
"ぼうはん 謀判 謀叛 防犯"
"ぼうはんかめら 防犯カメラ"
"ぼうはんびでお 防犯ビデオ"
"ぼうはんぶざー 防犯ブザー"
"ぼうばい 防黴"
"ぼうばく 茫漠"
"ぼうばり 棒針"
"ぼうばりあみ 棒針編み"
"ぼうひと 某人"
"ぼうひょう 暴評"
"ぼうひん 防貧"
"ぼうび 防備"
"ぼうびき 棒引き"
"ぼうびや 棒火箭 棒火矢"
"ぼうびろく 忘備録"
"ぼうふ 亡夫 亡父 防腐"
"ぼうふう 防風 暴風"
"ぼうふうう 暴風雨"
"ぼうふうりん 防風林"
"ぼうふら 孑孑"
"ぼうふり 棒振り"
"ぼうぶら 南瓜"
"ぼうへき 防壁"
"ぼうぼ 亡母"
"ぼうぼう 茫茫 茫々 某々"
"ぼうまい 茫昧 亡妹"
"ぼうまん 暴慢 膨満"
"ぼうみん 暴民"
"ぼうめい 亡命"
"ぼうめつ 亡滅"
"ぼうもう 紡毛"
"ぼうや 坊屋 坊や"
"ぼうゆう 暴勇 亡友"
"ぼうよう 滂洋 亡羊 茫洋 望洋"
"ぼうようりょう 望洋寮"
"ぼうよみ 棒読 棒読み"
"ぼうらく 暴落"
"ぼうり 暴利"
"ぼうりゃく 謀略"
"ぼうりゅう 傍流"
"ぼうりょう 坊領"
"ぼうりょく 暴力"
"ぼうれい 暴戻 亡霊"
"ぼうろう 望楼"
"ぼうろん 傍論 暴論"
"ぼうん 暮雲"
"ぼえき 母液"
"ぼおん 母音"
"ぼか 簿価"
"ぼかい 暮改"
"ぼかし 暈し"
"ぼかん 母管 母艦"
"ぼかんすう 母関数"
"ぼがい 簿外"
"ぼがん 母岩"
"ぼき 簿記"
"ぼきょくせん 母曲線"
"ぼきょくめん 母曲面"
"ぼきん 募金"
"ぼきんばこ 募金箱"
"ぼく 瀑 目 攵 攴 穆 睦 墨 濮 樸 撲 卜 朴 牧 木 僕"
"ぼくあて 僕宛"
"ぼくいがい 僕以外"
"ぼくか 墨家"
"ぼくが 墨画"
"ぼくぎゅう 牧牛"
"ぼくぎょ 墨魚"
"ぼくこう 墨攻"
"ぼくこじん 僕個人"
"ぼくさつ 撲殺"
"ぼくし 墨子 牧師"
"ぼくしゃ 卜者 牧舎"
"ぼくしゅ 墨守"
"ぼくしょ 墨書"
"ぼくしょう 木匠"
"ぼくしょく 墨色"
"ぼくしん 牧神"
"ぼくしんぐぶ ボクシング部"
"ぼくじ 卜辞 墨字"
"ぼくじしん 僕自身"
"ぼくじゅう 墨汁"
"ぼくじょう 卜定 牧場"
"ぼくじん 牧人"
"ぼくすい 墨水 牧水"
"ぼくせき 墨蹟 木石 墨跡"
"ぼくせん 卜占"
"ぼくぜい 卜筮"
"ぼくそう 牧草"
"ぼくたく 木鐸"
"ぼくたち 僕達"
"ぼくちく 木竹 牧畜"
"ぼくてき 牧笛"
"ぼくとう 墨東 木刀"
"ぼくとつ 木訥 朴訥"
"ぼくどう 牧童"
"ぼくにょう 攵繞 攴繞"
"ぼくねんじん 朴念仁"
"ぼくは 僕は"
"ぼくひとり 僕一人"
"ぼくふ 牧夫"
"ぼくみん 牧民"
"ぼくめつ 撲滅"
"ぼくよう 牧羊"
"ぼくようしん 牧羊神"
"ぼくら 僕ら 僕等"
"ぼけ 惚け 木瓜"
"ぼけあじ ボケ味"
"ぼけい 母型 母系"
"ぼけつ 墓碣 墓穴"
"ぼけろうじん ボケ老人"
"ぼけん 母権"
"ぼこ 凹"
"ぼこう 母后 母港 母校"
"ぼこく 母国"
"ぼご 母語"
"ぼさい 募債"
"ぼさつ 菩薩"
"ぼさつかい 菩薩戒"
"ぼさん 墓参"
"ぼざい 母材"
"ぼし 乾し 干し 星 拇趾 母趾 拇指 母指 墓誌 母子"
"ぼしき 母式"
"ぼしつ 墓室"
"ぼしゅう 暮秋 募集"
"ぼしゅうだん 母集団"
"ぼしゅん 暮春"
"ぼしょ 簿書 墓所"
"ぼしょう 暮鐘"
"ぼしょく 暮色"
"ぼしりょう 母子寮"
"ぼしん 戊辰"
"ぼしんしょうしょ 戊申詔書"
"ぼじゅつゆめものがたり 戊戌夢物語"
"ぼじょう 慕情"
"ぼすう 母数"
"ぼすざる ボス猿"
"ぼせい 母星 母性"
"ぼせき 墓石"
"ぼせつ 暮雪"
"ぼせん 母線 母船"
"ぼぜん 墓前"
"ぼたい 母胎 母体"
"ぼたにかきょう 菩多尼訶経"
"ぼたもち 牡丹餅"
"ぼたやま ぼた山 ボタ山"
"ぼたゆき ぼた雪"
"ぼたん 鈕 釦 牡丹"
"ぼたんあな ボタン穴"
"ぼたんか ボタン科"
"ぼたんこう 牡丹江"
"ぼたんざくら 牡丹桜"
"ぼたんでんち ボタン電池"
"ぼたんどうろう 牡丹灯籠"
"ぼたんなべ 牡丹鍋"
"ぼたんもく ボタン目"
"ぼたんゆき 牡丹雪"
"ぼだい 菩提"
"ぼだいじゅ 菩提樹"
"ぼち 墓地"
"ぼっ 沒 坊 没"
"ぼっか 牧歌"
"ぼっかい 渤海"
"ぼっかく 墨客"
"ぼっき 勃起"
"ぼっきゃく 没却"
"ぼっきょう 木強"
"ぼっきょうかん 木強漢"
"ぼっくすせき ボックス席"
"ぼっこう 墨香 勃興"
"ぼっこうしょう 没交渉"
"ぼっこせい 没個性"
"ぼっこん 墨痕"
"ぼっしゅ 没取"
"ぼっしゅう 没収"
"ぼっしゅみ 没趣味"
"ぼっしょ 没書"
"ぼっちゃん 坊っちゃん 坊ちゃん"
"ぼっとう 没頭"
"ぼっぱつ 勃発"
"ぼつ 渤 勃 沒 歿 没"
"ぼつが 没我"
"ぼつご 歿後 没後"
"ぼつぜん 歿前 勃然 没前"
"ぼつにゅう 没入"
"ぼつねん 歿年 没年"
"ぼつめつ 没滅"
"ぼつらく 没落"
"ぼつりぬすきん ボツリヌス菌"
"ぼてん 母点"
"ぼてんたい 母天体"
"ぼどう 母堂"
"ぼにゅう 母乳"
"ぼね 骨"
"ぼはん 墓畔 母斑"
"ぼば 牡馬"
"ぼひ 墓碑"
"ぼひめい 墓碑銘"
"ぼひょう 墓表 墓標"
"ぼふ 母父"
"ぼぶんさん 母分散"
"ぼへい 募兵"
"ぼへいきん 母平均"
"ぼほう 模倣 母法"
"ぼめい 墓銘"
"ぼや 暮夜 小火"
"ぼよう 慕容"
"ぼら 鰡 鯔"
"ぼり 堀"
"ぼりゅーむかん ボリューム感"
"ぼりょう 墓陵"
"ぼるつまんていすう ボルツマン定数"
"ぼれい 牡蛎"
"ぼろ 襤褸"
"ぼろくず ボロ屑"
"ぼろくそ 襤褸糞"
"ぼろぞうきん ボロ雑巾"
"ぼろまけ ぼろ負け ボロ負け"
"ぼろもうけ ぼろ儲け ボロ儲け"
"ぼん 煩 本 梵 凡 盆"
"ぼんおどり 盆踊 盆踊り"
"ぼんがいちにょ 梵我一如"
"ぼんくら 盆暗"
"ぼんくれ 盆暮 盆暮れ"
"ぼんぐ 凡愚"
"ぼんけい 盆景"
"ぼんこつ 凡骨"
"ぼんご 梵語"
"ぼんさい 凡才 盆栽"
"ぼんさく 凡策 凡作"
"ぼんしつ 凡失"
"ぼんしゅ 凡手"
"ぼんしょ 凡書 梵書"
"ぼんしょう 凡小 梵鐘"
"ぼんじ 梵字"
"ぼんじん 凡人"
"ぼんせき 盆石"
"ぼんせん 凡戦"
"ぼんそう 凡走"
"ぼんぞく 凡俗"
"ぼんたい 凡退"
"ぼんたん 文旦"
"ぼんだ 凡打"
"ぼんだて 盆点"
"ぼんだな 盆棚"
"ぼんち 盆地"
"ぼんちぎり 盆地霧"
"ぼんぢょうちん 盆提灯"
"ぼんてん 梵天"
"ぼんのう 煩悩"
"ぼんのうそくぼだい 煩悩即菩提"
"ぼんぴゃく 凡百"
"ぼんぶん 梵文"
"ぼんぷ 凡夫"
"ぼんべい 孟買"
"ぼんぺい 凡平"
"ぼんみす 凡ミス"
"ぼんやすみ 盆休み"
"ぼんよう 凡庸"
"ぼんりゃくだて 盆略点"
"ぼんりょ 凡慮"
"ぽ 舖 舗 歩"
"ぽーつますじょうやく ポーツマス条約"
"ぽーとかん ポート間"
"ぽーとばんごう ポート番号"
"ぽーらんど 波蘭"
"ぽーらんどきほう ポーランド記法"
"ぽーらんどご ポーランド語"
"ぽーらんどじん ポーランド人"
"ぽあそんひ ポアソン比"
"ぽあそんぶんぷ ポアソン分布"
"ぽいすて ポイ捨て"
"ぽいんたがた ポインタ型"
"ぽいんとせい ポイント制"
"ぽう 砲 烹 法 方 報 包"
"ぽえにせんそう ポエニ戦争"
"ぽけっとばん ポケット版"
"ぽすとこうぞうしゅぎ ポスト構造主義"
"ぽち ・"
"ぽちぶくろ ぽち袋 ポチ袋"
"ぽっくりびょう ぽっくり病"
"ぽっとで ぽっと出"
"ぽっとなえ ポット苗"
"ぽつ ・"
"ぽつだむせんげん ポツダム宣言"
"ぽぷらなみき ポプラ並木"
"ぽりえんかびにる ポリ塩化ビニル"
"ぽりこう ポリ公"
"ぽりぶくろ ポリ袋"
"ぽりぺぷちどさ ポリペプチド鎖"
"ぽるとがる 葡萄牙"
"ぽるとがるご ポルトガル語"
"ぽるとがるじん ポルトガル人"
"ぽん 椪 本"
"ぽんかん 椪柑"
"ぽんず ポン酢"
"ぽんちえ ポンチ絵"
"ぽんとちょう 先斗町"
"ぽんど 磅 £"
"ぽんびき ポン引き ぽん引き"
"ぽんぷざ ポンプ座"
"ぽんぷしき ポンプ式"
"ぽんぷしゃ ポンプ車"
"ま 満 万 眞 茉 麼 嘛 痲 媽 墹 目 馬 摩 磨 麻 真 魔 間"
"まーじゃん 麻雀"
"まーすとりひとじょうやく マーストリヒト条約"
"まーぼ 麻婆"
"まーぼー 麻婆"
"まーぼどーふ 麻婆豆腐"
"まあい 間合い 間合"
"まあじ 真鰺"
"まあじゃん 麻雀"
"まあぼうどうふ 麻婆豆腐"
"まい 参 瑁 眛 昧 妹 邁 埋 真依 舞衣 真衣 麻衣 舞 米 毎 枚"
"まいあさ 毎朝"
"まいいがい 枚以外"
"まいおうぎ 舞扇"
"まいおか 舞岡"
"まいおさめ 舞い納め"
"まいかい 毎回"
"まいかぜ 舞風"
"まいき 毎期"
"まいきょ 枚挙"
"まいぎぬ 舞衣"
"まいくろ μ"
"まいくろは マイクロ波"
"まいくろめーとる μm"
"まいぐみ 枚組"
"まいげつ 毎月"
"まいげつだい 毎月第"
"まいこ 磨衣子 麻衣子 毎戸 舞妓 舞子"
"まいこつ 埋骨"
"まいご 迷子"
"まいごう 毎号"
"まいさか 舞阪"
"まいし 昧死"
"まいしゅう 毎週"
"まいしょく 毎食"
"まいしん 邁進"
"まいじ 毎次 毎時"
"まいす 売僧"
"まいすう 枚数"
"まいせき 毎夕"
"まいせつ 埋設"
"まいそう 昧爽 埋葬"
"まいぞう 埋蔵"
"まいた 毎田"
"まいたけ 舞茸"
"まいだ 枚田"
"まいつき 毎月"
"まいづる 舞鶴"
"まいとし 毎年"
"まいど 毎度"
"まいない 賄 賂"
"まいなす −"
"まいなすあるふぁ マイナスα"
"まいなすしこう マイナス思考"
"まいなすせいちょう マイナス成長"
"まいなすめん マイナス面"
"まいなすよういん マイナス要因"
"まいなすようそ マイナス要素"
"まいなつ 毎夏"
"まいにち 毎日"
"まいねん 毎年"
"まいねんびと 毎年人"
"まいのうみ 舞の海"
"まいはま 舞浜"
"まいはら 米原"
"まいばら 米原"
"まいばん 毎晩"
"まいひめ 舞姫"
"まいびと 舞人"
"まいびょう 毎秒"
"まいふん 毎分"
"まいぼつ 埋没"
"まいまい 舞舞 毎々"
"まいまいむし 舞舞虫"
"まいめ 枚目"
"まいや 米谷 毎夜"
"まいゆう 毎夕"
"まいよ 毎夜"
"まいよう 枚葉"
"まいる 哩"
"まいわし 真鰯"
"まうえ 真上"
"まうしろ 真後"
"まうち 間内"
"まうら 真裏"
"まえ 前"
"まえあし 前脚 前足"
"まえいた 前板"
"まえいわい 前祝い 前祝"
"まえうけ 前受"
"まえうしろ 前後ろ"
"まえうた 前唄 前歌"
"まえうり 前売 前売り"
"まえお 前尾"
"まえおか 前岡"
"まえおき 前置 前置き"
"まえかがみ 前屈み"
"まえかけ 前掛け"
"まえかた 前方"
"まえかれ 前彼"
"まえかわ 前川"
"まえかんじょう 前勘定"
"まえがき 前垣 前書 前書き"
"まえがし 前貸し"
"まえがしきん 前貸金"
"まえがしら 前頭"
"まえがみ 前髪"
"まえがり 前借り"
"まえがりきん 前借金"
"まえがわ 前川 前側"
"まえきん 前金"
"まえく 前句"
"まえくづけ 前句付"
"まえげいき 前景気"
"まえげり 前蹴り"
"まえこうか 前効果"
"まえこうじょう 前口上"
"まえこうてい 前工程"
"まえこぐち 前小口"
"まえこごみ 前屈み"
"まえさがり 前下がり"
"まえさと 前里"
"まえさばき 前捌き"
"まえさわ 前沢"
"まえさんしょう 前参照"
"まえざわ 前澤 前沢"
"まえしま 前島"
"まえしょうとう 前照灯"
"まえしょり 前処理"
"まえじ 前地"
"まえじた 前舌"
"まえじま 前嶋 前島"
"まえじゅんび 前準備"
"まえじらせ 前知らせ"
"まえすうれつ 前数列"
"まえずもう 前相撲"
"まえずり 前刷り 前刷"
"まえせつ 前説"
"まえせんでん 前宣伝"
"まえぜつ 前説"
"まえだ 前多 前田"
"まえだおし 前倒し"
"まえだせいそん 前田青邨"
"まえだて 前立"
"まえだとしいえ 前田利家"
"まえだれ 前垂れ"
"まえち 前地"
"まえつえ 前津江"
"まえつぼ 前壺"
"まえづけ 前付"
"まえどうさ 前動作"
"まえどなり 前隣"
"まえどまり 前泊"
"まえどり 前録り"
"まえにわ 前庭"
"まえの 前野"
"まえのひ 前の日"
"まえのぶ 前信"
"まえのめり 前のめり"
"まえのり 前ノリ"
"まえのりょうたく 前野良沢"
"まえはし 前橋"
"まえはた 前畑"
"まえはら 前原"
"まえば 前場 前歯"
"まえばし 前橋"
"まえばら 前原"
"まえばらい 前払 前払い"
"まえばり 前貼り"
"まえばりおおくち 前張大口"
"まえばる 前原"
"まえばんぐみ 前番組"
"まえひょうばん 前評判"
"まえび 前日"
"まえびき 前弾き"
"まえびろ 前広"
"まえふり 前振"
"まえぶれ 前触れ"
"まえほ 前穂"
"まえほうこう 前方向"
"まえほり 前堀"
"まえまえ 前前 前々"
"まえみ 前身"
"まえみつ 前褌"
"まえむき 前向き"
"まえもって 豫て 前以て 前もって"
"まえやく 前厄"
"まえやち 前谷地"
"まえやま 前山"
"まえやまだ 前山田"
"まえわ 前輪"
"まえわたし 前渡し"
"まえわたしきん 前渡金"
"まお 苧麻 真麻 麻央 真緒 真央"
"まおう 麻黄 魔王"
"まおたいちゅー 茅台酒"
"まおとこ 間男"
"まおもて 真表 真面"
"まおりご マオリ語"
"まか 摩可 摩訶"
"まかい 魔界"
"まかいの 馬飼野"
"まかお 澳門"
"まかげ 目蔭 目陰"
"まかず 間数"
"まかせ 任せ"
"まかぜ 魔風"
"まかつきゅう 磨羯宮"
"まかない 賄い"
"まかべ 真壁"
"まかり 真狩"
"まがい 紛 擬 紛い"
"まがいもの 紛物 擬物"
"まがお 真顔"
"まがき 曲垣 籬"
"まがごと 禍言 禍事"
"まがし 間貸し"
"まがた 澗潟"
"まがたま 曲玉 勾玉"
"まがどり 凶鳥"
"まがも 真鴨"
"まがら 真柄"
"まがり 間借り"
"まがりかど 曲り角 曲がり角"
"まがりなり 曲り形 曲がり形"
"まき 卷 真城 麻貴 真貴 真季 麻希 麻紀 真樹 真木 真紀 真希 蒔 槇 槙 牧 巻き 薪 巻"
"まきあげ 捲揚 巻揚 巻上"
"まきあげき 巻揚げ機"
"まきあみ 巻網 巻き網"
"まきえ 撒き餌 蒔絵"
"まきお 牧朗 牧尾 真紀夫 真樹夫"
"まきおか 牧岡 牧丘"
"まきかわ 巻川"
"まきがい 巻き貝 巻貝"
"まきがみ 巻紙 巻上"
"まきがり 巻狩"
"まきぐち 牧口"
"まきぐも 巻雲"
"まきげ 巻毛 巻き毛"
"まきこ 満紀子 真生子 麻起子 正希子 マキ子 満喜子 万紀子 真樹子 真木子 真貴子 真喜子 麻紀子 真希子 眞紀子 牧子"
"まきしま 槙島 牧島"
"まきしょてん 槇書店"
"まきじく 巻軸"
"まきじた 巻舌 巻き舌"
"まきじゃく 巻尺"
"まきすう 巻数"
"まきずし 巻き鮨 巻寿司"
"まきせ 牧瀬"
"まきせん 巻線"
"まきそのちょう 牧園町"
"まきぞえ 巻添 巻き添え"
"まきぞの 牧園"
"まきた 真北 蒔田 牧田"
"まきたばこ 巻きタバコ"
"まきつき 巻きつき"
"まきつけ 蒔付け 巻きつけ"
"まきとり 巻取"
"まきなおし 蒔き直し"
"まきの 槙野 牧野"
"まきのうち 牧之内"
"まきのお 槇尾"
"まきのこう 牧の郷 牧之郷"
"まきのせ 牧之瀬"
"まきのはら 牧の原"
"まきはら 槇原 槙原 牧原"
"まきば 牧葉 牧場"
"まきばい 蒔き灰"
"まきひげ 巻ひげ 巻きひげ 巻鬚"
"まきひこ 眞木彦"
"まきびと 牧人"
"まきぶえ 牧笛"
"まきほん 巻本"
"まきむら 槙村 牧村"
"まきもと 牧本"
"まきもどし 巻戻し 巻き戻し"
"まきもの 巻物"
"まきゅう 魔球"
"まきょう 魔鏡 魔境"
"まきわり 薪割り"
"まぎ 間木"
"まぎゃく 真逆"
"まぎょう ま行 マ行"
"まぎら 紛ら"
"まぎらわし 紛らわし"
"まぎり 間切り"
"まぎれ 紛れ"
"まぎわ 真際 間際"
"まく 幕 膜"
"まくあい 幕間"
"まくあいげき 幕合劇"
"まくあき 幕開き"
"まくあけ 幕開け"
"まくあつ 膜厚"
"まくいた 幕板"
"まくうち 幕内"
"まくぎれ 幕切 幕切れ"
"まくぎわ 幕際"
"まくこうぞう 膜構造"
"まくしき 幕式"
"まくした 幕下"
"まくしつ 膜質"
"まくしもく 膜翅目"
"まくしょり 膜処理"
"まくそと 幕外"
"まくつ 魔窟"
"まくでんい 膜電位"
"まくない 膜内"
"まくなし 幕無し"
"まくのうち 幕の内"
"まくはり 幕張"
"まくひき 幕引き"
"まくべつ 幕別"
"まくま 幕間"
"まくめいがっき 膜鳴楽器"
"まくもの 幕物"
"まくや 幕屋"
"まくら 枕"
"まくらえ 枕絵"
"まくらかばー 枕カバー"
"まくらがみ 枕紙 枕上"
"まくらぎ 鍖 枕木"
"まくらぎょう 枕経"
"まくらげいしゃ 枕芸者"
"まくらことば 枕言葉 枕詞"
"まくらざき 枕崎"
"まくらぜに 枕銭"
"まくらぞうし 枕草紙"
"まくらどけい 枕時計"
"まくらのそうし 枕草子"
"まくらべ 枕辺"
"まくらぼん 枕本"
"まくらめし 枕飯"
"まくらもじ 枕文字"
"まくらもと 枕許 枕元"
"まくらものがたり 枕物語"
"まくろけいざい マクロ経済"
"まくろぶんせき マクロ分析"
"まくわうり 真桑瓜"
"まぐさ 蒭 芻 秣"
"まぐさおけ 秣桶"
"まぐし 馬櫛"
"まぐそ 馬糞"
"まぐち 間口"
"まぐまだまり マグマ溜り"
"まぐれ 紛れ"
"まぐれあたり まぐれ当たり"
"まぐろ 鮪"
"まぐろぎょせん マグロ漁船"
"まぐわ 耙"
"まぐん 魔軍"
"まけ 目気 任 敗け 負け"
"まけいくさ 負け戦"
"まけいしゅら 摩醯首羅"
"まけいぬ 負犬 負け犬"
"まけぎらい 負け嫌い"
"まけぐせ 負け癖"
"まけこし 負け越し"
"まけじごころ 負けじ心"
"まけじだましい 負けじ魂"
"まけずおとらず 負けず劣らず"
"まけずぎらい 負けず嫌い"
"まけっぷり 負けっ振り"
"まけばら 負け腹"
"まけぼし 負星"
"まけわざ 負け態"
"まけん 魔剣"
"まけんき 負けん気"
"まけんし 磨研紙"
"まげ 曲 曲げ 髷"
"まげもの 髷物"
"まこ 麻姑 魔子 眞子 真子 麻子"
"まこう 磨香"
"まこと 真湖人 誠人 真人 真琴 亮 信 純 眞 真 実 誠"
"まことしやか 真しやか"
"まことに 誠に 実に 真に"
"まご 馬子 孫"
"まごい 真鯉"
"まごうけ 孫請 孫請け"
"まごうた 馬子唄"
"まごおり 馬郡"
"まごこ 孫子"
"まごころ 真心"
"まごたち 孫達"
"まごでし 孫弟子"
"まごのて 孫の手"
"まごびき 孫引き"
"まごむすめ 孫娘"
"まごめ 馬込 馬籠"
"まさ 麻早 成 将 眞 真 昌 匡 雅 征 政 柾 正"
"まさあき 真昭 匡章 政秋 正彰 昌晃 昌昭 昌之 正晃 政昭 昌明 正章 雅昭 雅明 政明 雅章 正昭 正明"
"まさい 摩砕 磨砕"
"まさいち 政一 正一"
"まさいちろう 雅一郎"
"まさえ 優江 雅江 正恵 昌枝 正江 雅恵"
"まさお 希男 眞生 誠夫 将生 真夫 方夫 征男 昌生 雅勇 雅男 昌夫 雅雄 昌男 政男 政夫 政雄 雅夫 正男 正雄 正夫"
"まさおか 政岡 正岡"
"まさおき 正興"
"まさおみ 正臣"
"まさか 雅香"
"まさかず 賢和 雅和 政和 昌一 正一 正和"
"まさかつ 誠勝 政勝 正勝"
"まさかど 将門"
"まさかね 斉加年"
"まさかり 鉞"
"まさがね 正金"
"まさき 正揮 眞希 誠樹 仁樹 昌毅 正宣 政輝 眞幸 公輝 政木 雅基 昌己 正記 正基 正毅 真先 正喜 正輝 真咲 真幸 正紀 政樹 昌樹 真崎 正規 松前 雅樹 正木 真樹 正樹"
"まさきち 政吉"
"まさきよ 政清"
"まさこ 正沙子 真紗子 誠子 眞砂子 真沙子 真佐子 真砂子 まさ子 政子 晶子 正子 昌子 雅子"
"まさこひ 雅子妃"
"まさご 真砂"
"まさし 昌嗣 政資 昌士 將 祐史 真志 匡史 真史 将史 昌志 政司 雅士 昌史 政志 将司 雅司 正司 雅志 匡 正志 正史 雅史 将 昌 仁 正"
"まさしく 正しく"
"まさしげ 雅重 正茂 政重 正成"
"まさしち 政七"
"まさじ 雅二 正次 政次 政司 正治 政治"
"まさすけ 正祐"
"まさずみ 正純"
"まさたか 真考 誠孝 政貴 政敬 真隆 雅隆 正高 政孝 政隆 昌孝 正孝 正隆"
"まさたけ 正武"
"まさちゅーせっつこうかだいがく マサチューセッツ工科大学"
"まさつ 摩擦"
"まさつぐ 仁継 雅紹 正継"
"まさつてきしつぎょう 摩擦的失業"
"まさつね 正恒"
"まさてつ 正哲"
"まさてる 雅照 政輝 正輝"
"まさと 雅斗 雅刀 昌人 政人 真人 雅人 正人"
"まさとし 盛敏 眞利 真俊 政利 雅敏 昌利 正利 雅俊 正俊 正敏"
"まさとみ 政富 正美 正富"
"まさな 雅名"
"まさなお 雅尚 正尚 政直 正直"
"まさなり 正業 政成 正成"
"まさに 正に"
"まさの 雅野"
"まさのぶ 正亘 雅修 匡伸 昌延 雅宣 昌信 正伸 雅信 政信 正信"
"まさのり 成憲 政宣 真典 公則 正範 政典 昌則 雅典 昌典 雅則 正紀 正規 正徳 正憲 正典 正則"
"まさはる 政春 雅春 昌治 正晴 正春 正治"
"まさひこ 眞彦 允彦 真彦 政彦 昌彦 正彦 雅彦"
"まさひさ 真久 昌久"
"まさひで 昌英 正英 正秀"
"まさひと 賢人 昌人 正仁 雅仁 正人"
"まさひろ 将容 正央 征洋 昌寛 政浩 匡弘 雅洋 誠広 正大 雅宏 政広 雅浩 真弘 正寛 政宏 昌広 政弘 雅裕 正宏 正洋 正裕 雅博 正広 正浩 昌宏 雅弘 正弘 昌弘 正博"
"まさふさ 政房"
"まさふみ 真詞 将文 昌文 将史 雅文 雅史 正文"
"まさぶみ 正文"
"まさみ 昌未 雅三 眞美 雅実 公美 真己 昌己 雅己 昌巳 雅巳 政美 正実 正己 正巳 昌美 正美 雅美"
"まさみち 雅道 真理 正道"
"まさみつ 真光 昌光 正光"
"まさむね 政宗 正宗"
"まさめ 正眼 正目 柾目"
"まさもと 理元 政本"
"まさや 匡哉 正弥 昌哉 正哉 雅哉 正也 昌也 雅也"
"まさやす 誠康 昌泰 雅保 政康 雅康 正泰 正康"
"まさゆき 雅祐 政征 理之 将行 誠之 真幸 政之 政幸 真之 雅幸 政行 雅行 昌幸 昌之 正行 正之 正幸 雅之"
"まさゆめ 正夢"
"まさよ 真砂代 正代 昌代 雅代"
"まさよう 将容"
"まさよし 正元 正善 正良 正好 雅義 政義 昌義 正芳 昌吉 正義"
"まさより 政頼"
"まさりおとり 優り劣り"
"まさる 秀 賢 太 優 勝 大"
"まざりもの 混ざり物"
"まし 増 麻紙"
"ましお 真潮"
"ましき 益城"
"ましけ 増毛"
"ましこ 猿子 増子 益子"
"ましこやき 益子焼"
"ました 間下 真下 増田"
"まして 増して 況して"
"ましてや 況してや"
"ましど 益戸"
"ましば 間柴 真柴"
"ましも 真下"
"ましゃく 間尺"
"ましゅ 魔手"
"ましゅう 摩周"
"ましゅうこ 摩周湖"
"ましょ 魔所"
"ましょう 魔障 魔性"
"ましら 猿"
"ましん 真芯 麻疹"
"ましんご マシン語"
"まじ 蠱 真風"
"まじか 真近 間近"
"まじきり 間仕切 間仕切り"
"まじっくてんとう マジック点灯"
"まじない 呪い"
"まじのせん マジノ線"
"まじま 間嶋 真島 間島"
"まじめ 真面目"
"まじもの 蠱物"
"まじゅう 魔獣"
"まじゅつ 魔術"
"まじょ 魔女"
"まじょがり 魔女狩り"
"まじり 交じり"
"まじりっけ 混じりっ気"
"まじりもの 混じり物"
"まじわり ∩ 交わり"
"まじん 魔神 魔人"
"ます 斗 益 増 舛 枡 桝 升 鱒"
"ますい 魔酔 魔睡 痲酔 桝井 増井 麻酔"
"ますいじゅう 麻酔銃"
"ますいち 増市"
"ますお 満洲雄 満寿夫 益夫 増尾"
"ますおか 舛岡 益岡 増岡"
"ますかがみ 増鏡"
"ますかわ 増川"
"ますがた 斗形 真姿 升形 枡形"
"ますき 増木"
"ますこ 万寿子 増子 益子"
"ますざわ 増澤 増沢"
"ますじ 鱒二"
"ますじろう 益治郎"
"ますずし 鱒寿司"
"ますせき 枡席 桝席 升席"
"ますぞう 益造"
"ますぞえ 桝添 舛添"
"ますたつ 倍達"
"ますたに 益谷 升谷 増谷"
"ますだ 舛田 升田 桝田 益田 増田"
"ますづり 鱒釣"
"ますとみおんせん 増富温泉"
"ますど 益戸"
"ますなが 増永"
"ますの 増野"
"ますはら 増原"
"ますひこ 益彦"
"ますぶち 増淵"
"ますほ 増穂"
"ますます 益々"
"ますみ 増実 真寿 益美 萬純 満寿美 眞澄 真純 真澄"
"ますみだじんじゃ 真清田神社"
"ますめ 枡目 桝目 升目"
"ますもと 升本 桝本 増本"
"ますや 升谷"
"ますやま 益山 増山"
"ますらお 丈夫 益荒男"
"まず 先ず"
"まずい 不味い"
"ませ 間瀬 真瀬 笆 籬"
"ませい 磨製"
"ませき 魔石"
"まぜ 馬瀬"
"まぜがき 混ぜ書き 交ぜ書き"
"まぜごはん 混ぜ御飯"
"まぜっかえし 混ぜっ返し"
"まぜもの 混ぜ物"
"まそお 真赭"
"まそほ 真赭"
"まそん 摩損"
"また 俣 複 亦 叉 胯 股 又"
"またいじゅなんきょく マタイ受難曲"
"またいとこ 又従姉妹 又従兄弟"
"またうど 全人 真人"
"またがし 又貸し"
"またがみ 股上"
"またがり 又借り"
"またぎ 叉木 股木"
"またぎき 又聞き"
"またぐら 胯座 股ぐら 股座"
"またぐらごうやく 股座膏薬"
"またけ 真竹"
"またさぶろう 又三朗 又三郎"
"またした 股下"
"またずれ 股擦れ"
"またぞろ 又候"
"またたき 瞬き"
"またたくま 瞬く間"
"またたび 木天蓼 股旅"
"まただのみ 又頼み"
"またどなり 又隣"
"またの 俣野"
"または ∨ ∪ 又は"
"またひばち 股火鉢"
"またま 真玉"
"またまた 又又 又々"
"まためがね 股眼鏡"
"またもの 又者 陪臣"
"またわり 股割"
"まだ 未だ"
"まだい 真鯛"
"まだけ 真竹"
"まだこ 真章魚 真蛸"
"まだし 未だし"
"まだら 真鱈 斑"
"まだらお 斑尾"
"まだらだけ 斑竹"
"まだらねこ 斑猫"
"まだらゆき 斑雪"
"まだんのしゃしゅ 魔弾の射手"
"まち 待 万智 真知 甼 区 待ち 襠 街 町"
"まちあい 待合い 待ち合い 待合"
"まちあかり 街明り 街明かり"
"まちあるき 街歩き"
"まちあわせ 待合せ 待合"
"まちい 町医 町井"
"まちうけ 待受け 待受"
"まちかた 町方"
"まちかど 町角 街角"
"まちかね 待兼"
"まちが 待画"
"まちがい 間違い"
"まちがいさがし 間違い探し"
"まちがえ 間違え"
"まちぎ 町着 街着"
"まちぎょうれつ 待行列"
"まちく 麻竹"
"まちこ 磨智子 街子 眞智子 麻知子 満智子 町子 真知子"
"まちこうじょう 町工場"
"まちこうば 町工場"
"まちごま 待ち駒"
"まちざわ 町澤 町沢"
"まちしゅう 町衆"
"まちしゅうへん 町周辺"
"まちじかん 待時間"
"まちじゅう 町中 街中"
"まちすじ 町筋"
"まちぜんたい 町全体"
"まちそだち 町育ち"
"まちだ 町田"
"まちぢゅう 町中"
"まちっこ 町っ子"
"まちでら 待寺"
"まちどお 待ち遠"
"まちなか 町中 街中"
"まちなみ 町並 街並 街並み 町並み"
"まちの 町野"
"まちのり 街乗り"
"まちはずれ 町外れ"
"まちば 町場"
"まちばり 待針 まち針 待ち針"
"まちびけし 町火消し"
"まちびと 待人 待ち人"
"まちぶぎょう 町奉行"
"まちぶせ 待伏せ 待ち伏せ"
"まちぼうけ 待ちぼうけ 待ち惚け"
"まちまち 街々 町々 区区 区々"
"まちむすめ 街娘 町娘"
"まちや 町谷 町家 町屋"
"まちやくにん 町役人"
"まちやくば 町役場"
"まちやっこ 町奴"
"まちゆく 街行く"
"まちれい 町礼"
"まちわり 町割り 町割"
"まちんか マチン科"
"まぢか 真近 間近"
"まっ 真っ"
"まっか 真赤 真っ赤"
"まっかつ 靺鞨"
"まっかり 真狩"
"まっかん 末巻"
"まっき 末岐 末期"
"まっきがん 末期ガン 末期癌"
"まっきゃく 末脚"
"まっくら 真暗 真っ暗"
"まっくろ 真黒 真っ黒"
"まっくろけ 真っ黒け"
"まっこう 抹香 真向 真っ向"
"まっこうくじら 抹香鯨"
"まっさーじき マッサージ機 マッサージ器"
"まっさーじし マッサージ師"
"まっさお 真青 真っ青"
"まっさかさま 真っ逆さま"
"まっさき 真先"
"まっさつ 抹殺"
"まっさら 真っ新"
"まっし 末子"
"まっしぐら 驀地"
"まっしゃ 末社"
"まっしゅう 末秋"
"まっしょ 末書"
"まっしょう 末梢 抹消"
"まっしょうけつ 末梢血"
"まっしろ 真白 真っ白"
"まっすぐ 真っ直"
"まっせ 末世"
"まっせき 末席"
"まっせつ 末節"
"まっそん 末孫"
"まった 待った"
"まったき 全き"
"まったく 全 全く"
"まったりかん まったり感"
"まったん 末端"
"まっち 燐寸"
"まっちうり マッチ売り"
"まっちばこ マッチ箱"
"まっちぼう マッチ棒"
"まっちゃ 抹茶"
"まっちゃあいす 抹茶アイス"
"まっちゃまち 松屋町"
"まっちょう 末長"
"まってい 末弟"
"まっとう 松任 真っ当 全う"
"まっとうや 松任谷"
"まっとうんどう マット運動"
"まっとし マット紙"
"まっはすう マッハ数"
"まっぱ 末派"
"まっぱい 末輩"
"まっぱだか 真っ裸"
"まっぴつ 末筆"
"まっぴら 真平 真っ平"
"まっぴるま 真昼間 真っ昼間"
"まっぷたつ 真っ二つ"
"まっぽう 末法"
"まつ 枩 靺 茉 秣 沫 抹 末 松"
"まつい 松為 末位 松居 松井"
"まついし 松石"
"まついだ 松井田"
"まついち 松一"
"まつうら 松浦"
"まつえ 松江"
"まつえい 末裔"
"まつえだ 松枝"
"まつお 松夫 松男 松雄 松尾"
"まつおか 松岡"
"まつおかようすけ 松岡洋右"
"まつかさ 松毬"
"まつかさうお 松毬魚"
"まつかざり 松飾り"
"まつかぜ 松風"
"まつかた 松方"
"まつかわ 松河 松皮 松川"
"まつかわびし 松皮菱"
"まつがおか 松が丘"
"まつがさき 松ヶ崎"
"まつがや 松ヶ谷"
"まつき 松木"
"まつくいむし 松喰虫"
"まつくら 松倉"
"まつげ 睫 睫毛"
"まつご 末期"
"まつごのみず 末期の水"
"まつごろう 松吾郎 松五郎"
"まつさか 松阪 松坂"
"まつさかぎゅう 松坂牛"
"まつさき 松崎"
"まつさわ 松沢"
"まつざ 末座"
"まつざか 松阪 松坂"
"まつざかぎゅう 松坂牛"
"まつざかにく 松坂肉"
"まつざき 松嵜 松崎"
"まつざわ 松澤 松沢"
"まつしげ 松重 松茂"
"まつした 松下"
"まつしま 松嶋 松島"
"まつしろ 松代"
"まつじ 末寺"
"まつじつ 末日"
"まつじめ 末締め"
"まつじょ 末女"
"まつずみ 松炭"
"まつた 松田"
"まつたか 松高"
"まつたけ 松茸"
"まつたに 松谷"
"まつたろう 松太郎"
"まつだ 松田"
"まつだい 松代 末代"
"まつだいら 松平"
"まつだいらさだのぶ 松平定信"
"まつだいらただてる 松平忠輝"
"まつだん 末段"
"まつち 真土"
"まつつか 松塚"
"まつづき 松月"
"まつとうや 松任谷"
"まつとも 松友"
"まつど 松戸"
"まつなえ 松苗"
"まつなか 松中"
"まつなが 松長 末永 松永"
"まつなみ 松波"
"まつなみき 松並木"
"まつなん 末男"
"まつぬま 松沼"
"まつね 松根"
"まつねん 末年"
"まつの 松乃 松野"
"まつのうち 松の内"
"まつのぶ 松延"
"まつのべ 松延"
"まつのやま 松之山"
"まつのり 松海苔"
"まつはた 松畑"
"まつば 松葉"
"まつばがに 松葉蟹"
"まつばせ 松橋"
"まつばづえ 松葉杖"
"まつばめ 松羽目"
"まつばやし 松林"
"まつばら 松原"
"まつばらこ 松原湖"
"まつひろ 松弘"
"まつび 末尾"
"まつびし 松菱"
"まつふじ 松藤"
"まつふる 松古"
"まつぶさか マツブサ科"
"まつぶし 松伏"
"まつぶん 末文"
"まつぼっくり 松ぼっくり 松陰嚢"
"まつまい 末妹"
"まつまえ 松前"
"まつまえづけ 松前漬"
"まつまる 松丸"
"まつみ 松見"
"まつむし 松虫"
"まつむしそう 松虫草"
"まつむら 松村"
"まつむろ 松室"
"まつも 松藻"
"まつもか マツモ科"
"まつもと 松元 松本"
"まつもむし 松藻虫"
"まつもり 松森"
"まつや 松屋"
"まつやに 松脂"
"まつやま 松山"
"まつゆき 松雪"
"まつよいぐさ 待宵草"
"まつよう 末葉"
"まつよし 松吉"
"まつら 松浦"
"まつらのみやものがたり 松浦宮物語"
"まつり 祀り 祀 祭り 祭"
"まつりか 茉莉花"
"まつりごと 祭事 政"
"まつりぬい まつり縫い 纏り縫い"
"まつりゅう 末流"
"まつろ 末路"
"まつわこう 松輪港"
"まづ 先づ"
"まて 待て 蟶 馬蛤 馬刀"
"まてがい 蟶貝 馬蛤貝 馬刀貝"
"まてき 魔笛"
"まてちゃ マテ茶"
"まてんろう 摩天楼"
"まで 迄"
"まと 魔都 的"
"まとい 纒い 纒 纏"
"まとうだい 的鯛"
"まとうど 全人 真人"
"まとはずれ 的外れ"
"まとば 的場"
"まとまり 纒まり"
"まとむ 統"
"まとめ 纏め"
"まとめうり まとめ買い まとめ売り"
"まとめがい まとめ買い"
"まとめやく まとめ役"
"まとも 真艫 真面"
"まとや 的矢"
"まとり 真鳥"
"まど 窗 窓"
"まどい 円居"
"まどいた 窓板"
"まどう 魔導 魔道"
"まどお 間遠"
"まどか 円 円か"
"まどかんすう 窓関数"
"まどがらす 窓ガラス"
"まどがわ 窓側"
"まどぎわ 窓際"
"まどぐち 窓口"
"まどぐちおく 窓口奥"
"まどころ 政所"
"まどぜんかい 窓全開"
"まどぜんたい 窓全体"
"まどだい 窓台"
"まどだか 窓高"
"まどちょう 窓長"
"まどない 窓内"
"まどのうち 窓の中"
"まどはいち 窓配置"
"まどはん 窓販"
"まどふき 窓拭き"
"まどべ 窓辺"
"まどよう 窓用"
"まどり 間取 間取り"
"まどりーど 馬徳里"
"まどろみ 微睡"
"まどわく 窓枠"
"まどわり 窓割"
"まな 真字 真魚 茉奈 麻奈 真名 真奈 愛"
"まなーいはん マナー違反"
"まないた 真魚板 俎板 俎 まな板"
"まなか 愛香 真中"
"まながつお 真魚鰹"
"まなこ 眼"
"まなご 真砂"
"まなざし 眼差し"
"まなしき 末那識"
"まなじょ 真名序"
"まなじり 眥 眦"
"まなつ 真夏"
"まなつのよのゆめ 真夏の夜の夢"
"まなつる 真鶴"
"まなづる 真名鶴 真鶴"
"まなでし 愛弟子"
"まなび 愛日 学び"
"まなびや 学び舎 学舎"
"まなぶ 斈 學 学"
"まなべ 真部 間部 真鍋"
"まなみ 愛美"
"まなむすこ 愛息子"
"まなむすめ 愛娘"
"まに 摩尼"
"まにあわせ 間に合せ 間に合わせ"
"まにきょう マニ教"
"まにし 真西"
"まにまに 随に"
"まにゅあるか マニュアル化"
"まにゅあるしゃ マニュアル車"
"まにゅあるぼん マニュアル本"
"まにら 馬尼剌"
"まにらあさ マニラ麻"
"まにわ 真庭"
"まぬえど 真鵺道"
"まぬけ 間抜け"
"まぬけづら 間抜面"
"まぬほうてん マヌ法典"
"まね 真似"
"まねきねこ 招き猫"
"まねび 学び"
"まの 間野 真野"
"まのあたり 目の当たり"
"まのて 魔の手"
"まのび 間延 間延び"
"まは 万葉"
"まはだか 真裸"
"まばし 馬橋"
"まばしら 間柱"
"まばたき 瞬き"
"まばら 疎 疎ら"
"まひ 痲痺 麻痺"
"まひかり 真光"
"まひがし 真東"
"まひと 真人"
"まひる 真昼"
"まひわ 真鶸"
"まび 魔美"
"まびき 間引 間引き"
"まびきな 間引き菜"
"まびさし 目庇"
"まふう 魔風"
"まふじえき 間藤駅"
"まふね 真船"
"まふゆ 真冬"
"まぶ 間夫"
"まぶか 目深"
"まぶし 蔟"
"まぶしさ 眩しさ"
"まぶた 目蓋 瞼"
"まぶち 馬淵 馬渕"
"まぶに 摩文仁"
"まぶね 馬槽"
"まほ 真秀 真帆"
"まほう 魔法"
"まほうけん 魔法剣"
"まほうびん 魔法瓶"
"まほか 真帆香"
"まほりかん 馬堀間"
"まほろ 真帆呂"
"まぼろし 幻"
"まま 媽媽 壗 墹 圸 飯 継 随 侭 儘"
"ままおや 継親"
"ままかり 飯借り"
"ままこ 継子"
"ままごと 飯事"
"ままさん ママさん"
"ままちち 継父"
"ままならぬ 儘ならぬ"
"ままはは 継母"
"ままむすめ 継娘"
"まみ 昌未 磨美 魔魅 眞美 舞美 魔美 茉美 麻実 麻弥 真実 麻美 真美 猯"
"まみこ 麻巳子 麻美子"
"まみず 真水"
"まみづか 馬見塚"
"まみなみ 真南"
"まみや 魔実也 間宮"
"まみやりんぞう 間宮林蔵"
"まみれ 塗れ"
"まむかい 真向い"
"まむし 蝮"
"まむしぐさ 蝮草"
"まむろがわ 真室川"
"まめ 菽 忠実 肉刺 荳 豆"
"まめあぶら 豆油"
"まめおか 豆岡"
"まめか マメ科 豆科"
"まめがし 豆菓子"
"まめきゅう 豆球"
"まめしぼり 豆絞り"
"まめじてん 豆事典"
"まめせいひん 豆製品"
"まめぞう 豆蔵"
"まめたん 豆単 豆炭"
"まめだ 豆田"
"まめだいこ 豆太鼓"
"まめちしき 豆知識"
"まめつ 磨滅 摩滅"
"まめつぶ 豆粒"
"まめでっぽう 豆鉄砲"
"まめでんきゅう 豆電球"
"まめばたけ 豆畑"
"まめほん 豆本"
"まめまき 豆蒔き 豆撒き 豆まき"
"まめみそ 豆味噌"
"まめもち 豆餅"
"まめもよう 豆模様"
"まめや 豆屋"
"まめるい 豆類"
"まもう 磨耗 摩耗"
"まもなく 間も無く"
"まもの 魔物"
"まもり 護 護り 守り"
"まもりがみ 守り神"
"まもりふだ 守り札"
"まもる 衞 衛 守"
"まや 麻那 魔夜 馬屋 摩耶 麻弥 麻矢"
"まやく 痲薬 麻薬"
"まやくけん 麻薬犬"
"まやくたんちけん 麻薬探知犬"
"まやこ 麻也子"
"まやぞく マヤ族"
"まやぶにん 摩耶夫人"
"まやぶんめい マヤ文明"
"まやま 間山 真山"
"まゆ 麻愉 真由 麻由 繭 眉"
"まゆげ 眉毛"
"まゆこ 眉子 万由子 繭子 真由子"
"まゆじり 眉尻"
"まゆずみ 眉墨 黛"
"まゆだま 繭玉"
"まゆつば 眉唾"
"まゆね 眉根"
"まゆみ 誠由美 万友美 雅弓 檀 魔弓 麻由美 真弓"
"まゆむら 眉村"
"まゆやま 眉山"
"まよ 眞夜 真代 麻世 真世"
"まよい 迷い"
"まよいいぬ 迷い犬"
"まよいご 迷い子"
"まよいねこ 迷い猫"
"まよいばし 迷い箸"
"まよいぼし 迷い星"
"まよいみち 迷い道"
"まよけ 魔除け"
"まよこ 真横"
"まよね 眉根"
"まら 魔羅 摩羅"
"まらっかかいきょう マラッカ海峡"
"まらや 馬來"
"まり 満利 茉利 麻理 万里 茉莉 真里 麻里 真理 鞠 毬"
"まりあ 万梨阿 真利亜"
"まりい 麻利衣"
"まりえ 鞠絵"
"まりお 麻利夫 眞理雄 真理雄"
"まりこ 茉里子 満利子 真璃子 鞠子 丸子 真里子 真梨子 麻里子 万里子 真利子 麻理子 マリ子 まり子 真理子"
"まりこうじ 鞠小路"
"まりしてん 摩利支天"
"まりな 満里奈"
"まりのす 横浜マリノス"
"まりはな 茉莉花"
"まりも 毬藻"
"まりょく 魔力"
"まる ． ・ 。 ° ゜ 〇 ◯ ◎ ● ○ 圓 円 丸"
"まるあき 丸明き"
"まるあな 丸穴"
"まるあらい 丸洗い"
"まるい 丸井"
"まるいけ 丸池"
"まるいち 丸一"
"まるいん 丸印"
"まるえい 丸栄"
"まるえり 丸襟"
"まるお 丸生 円尾 丸尾"
"まるおか 丸岡"
"まるおび 丸帯"
"まるか 満留賀"
"まるかがみ 円鏡"
"まるかじり 丸かじり 丸齧り"
"まるかっこ ） （"
"まるかめかん 丸亀間"
"まるかめがわ 丸亀側"
"まるかわ 丸川"
"まるかん 丸漢"
"まるがお 円顔 丸顔"
"まるがかえ 丸抱え"
"まるがた 円型 円形 丸形 丸型"
"まるがめ 丸亀"
"まるがり 丸刈り"
"まるがわら 丸瓦"
"まるき 丸木"
"まるきぶね 丸木舟"
"まるきゅう 丸久"
"まるきん 丸金"
"まるくすけいざいがく マルクス経済学"
"まるくすしゅぎ マルクス主義"
"まるくに 丸国"
"まるくび 丸首"
"まるぐち 丸口"
"まるこ 丸子"
"まるこう 丸興"
"まるこし 丸腰"
"まるごし 丸腰"
"まるごしっく 丸ゴシック"
"まるごと 丸ごと"
"まるさん 丸三"
"まるざい 丸材"
"まるざら 丸皿"
"まるしょう 丸正"
"まるじるし 丸印"
"まるせいゆ 馬耳塞"
"まるせっぷ 丸瀬布"
"まるぜん 丸全 丸善"
"まるぞこ 丸底"
"まるぞん 丸損"
"まるた 丸田 丸太"
"まるたに 丸谷"
"まるたんぼう 丸太ん棒"
"まるだいしょくひん 丸大食品"
"まるちしょうほう マルチ商法"
"まるっきり 丸っ切り"
"まるつきすうじ 丸付数字"
"まるづか 丸塚"
"まるづけ 丸漬"
"まるてーぶる 丸テーブル"
"まるてん 丸天"
"まるてんじょう 円天井"
"まるとう 丸東"
"まるに 丸煮"
"まるにし 丸西"
"まるぬま 丸沼"
"まるの 丸野"
"まるのうち 丸ノ内 丸の内"
"まるのこ 丸鋸"
"まるのみ 円鑿 丸呑み"
"まるはい 丸灰"
"まるはし 丸橋"
"まるはだか 丸裸"
"まるはち 丸八"
"まるばし 丸橋"
"まるばしら 丸柱"
"まるばつ ○×"
"まるばやし 丸林"
"まるひ マル秘 丸秘"
"まるびたい 丸額"
"まるふく 丸福"
"まるぶつ 丸物"
"まるぶん 丸文"
"まるべに 丸紅"
"まるほん 丸本"
"まるぼし 丸干"
"まるぼり 丸彫 丸彫り"
"まるぽちゃ 丸ぽちゃ"
"まるまげ 丸髷"
"まるまど 円窓 丸窓"
"まるまる ○○ 丸丸 丸々"
"まるみ 円美 丸見 丸味 丸み"
"まるみつ 丸光"
"まるめ 丸め"
"まるもち 丸餅"
"まるもと 丸元 丸本"
"まるもり 丸森"
"まるや 丸屋 丸谷"
"まるやき 丸焼"
"まるやね 円屋根"
"まるやま 円山 丸山"
"まるやまおうきょ 円山応挙"
"まるやまかおる 丸山薫"
"まるゆう マル優"
"まるわ 丸和"
"まれ 希 稀"
"まれーご マレー語"
"まれーしあご マレーシア語"
"まれいんさん マレイン酸"
"まれき 希樹"
"まれすけ 希典"
"まれびと 客 賓 客人"
"まろ 麻呂 麿"
"まろうど 客 賓 客人"
"まろうどがみ 客人神 客神"
"まろみ 円み 丸み"
"まろやか 円やか"
"まわし 廻し 廻 回し"
"まわしげり 廻し蹴り"
"まわた 真綿"
"まわたり 馬渡"
"まわり 廻り 回り 周り"
"まわりえん 回り縁"
"まわりずみ 回り炭"
"まわりどうろう 回り灯籠"
"まわりばな 回り花"
"まわりぶち 回り縁 廻り縁"
"まわりまわって 回り回って"
"まわりみち 回り道"
"まわれみぎ 回れ右"
"まん 悗 幡 鬘 饅 謾 縵 幔 曼 蔓 漫 慢 鰻 滿 蹣 瞞 懣 満 萬 万"
"まんいち 万一"
"まんいつ 万一"
"まんいん 満員"
"まんえつ 満悦"
"まんえん 萬延 満塩 万延 万円 蔓延"
"まんかい 万回 満開"
"まんかぶ 満株"
"まんかん 満韓 満干"
"まんかんしょく 満艦飾"
"まんかんぜんせき 満漢全席"
"まんが 萬画 漫画"
"まんがいち 万が一"
"まんがか マンガ家"
"まんがきっさ マンガ喫茶"
"まんがく 満額"
"まんがのもり まんがの森"
"まんがぼん マンガ本"
"まんがん 万巻 満貫 満願"
"まんがんかんでんち マンガン乾電池"
"まんがんぜんせき 満漢全席"
"まんがんでんち マンガン電池"
"まんき 満期"
"まんきつ 満喫"
"まんきん 万金"
"まんぎょう 万行"
"まんけん 万軒 万件 漫研 万券"
"まんげきょう 万華鏡"
"まんげつ 満月"
"まんげん 漫言 万言"
"まんこ 万戸 万個"
"まんこう 満腔"
"まんご 漫語 慢語"
"まんごう 万劫"
"まんごく 万石"
"まんごじしょ 万語辞書"
"まんさい 満載"
"まんさく 満作 万作"
"まんさくもく マンサク目"
"まんさつ 万札 万冊"
"まんさん 蹣跚"
"まんざ 満座 万座"
"まんざい 漫才 万歳"
"まんざいらく 萬歳楽"
"まんざら 満更"
"まんざん 満山"
"まんしつ 満室"
"まんしゃ 満車"
"まんしゅいん 曼殊院"
"まんしゅう 滿洲 満洲 満州"
"まんしゅうこく 滿洲國"
"まんしょう 満床"
"まんしょく 万色"
"まんしん 万進 満身 慢心"
"まんじ 万治 卍"
"まんじがため 卍固"
"まんじどもえ 卍巴"
"まんじゅ 万寿"
"まんじゅう 饅頭"
"まんじゅうがに 饅頭蟹"
"まんじゅうやぼん 饅頭屋本"
"まんじゅしゃげ 曼珠沙華"
"まんじょう 満場"
"まんすい 満水"
"まんず 萬子"
"まんせい 慢性"
"まんせいばし 万世橋"
"まんせき 満席"
"まんせん 満船"
"まんぜん 万善 漫然"
"まんぞく 満足"
"まんた 万太"
"まんたく 満卓"
"まんたに 萬谷"
"まんたん 満タン"
"まんたんい 万単位"
"まんだい 万代 万台"
"まんだら 曼陀羅 曼荼羅"
"まんだらげ 曼陀羅華"
"まんだん 漫談"
"まんち 満地"
"まんちゃく 瞞着"
"まんちょう 満潮"
"まんちんろう 萬珍楼"
"まんてつ 滿鐵 満鉄"
"まんてん 万点 満天 満点"
"まんてんせい 満天星"
"まんと 満都"
"まんとうえ 万灯会"
"まんとみ 万富"
"まんどう 万灯"
"まんどころ 政所"
"まんなか まん中 真中 真ん中"
"まんにょうしゅう 万葉集"
"まんにん 万人"
"まんねりか マンネリ化"
"まんねん 萬年 万年"
"まんねんぐさ 万年草"
"まんねんせい 万年青"
"まんねんどこ 万年床"
"まんねんゆき 万年雪"
"まんねんろう 迷迭香"
"まんのう 満濃"
"まんはったんけいかく マンハッタン計画"
"まんば 漫罵 万馬 万場"
"まんばい 万倍"
"まんぱ 万波"
"まんぱい 満配 満杯"
"まんぱち 万八"
"まんぱん 満帆"
"まんびき 万引き 万引"
"まんびょう 万病"
"まんぴつ 漫筆"
"まんぴょう 漫評 満票"
"まんぶ 万部"
"まんぶん 漫文"
"まんぷ 漫符"
"まんぷく 満幅 万福 満腹"
"まんべん 万便 万遍 満遍"
"まんぼう 翻車魚"
"まんぽ 漫歩"
"まんぽけい 万歩計"
"まんま 飯 儘"
"まんまい 万枚"
"まんまえ 真ん前"
"まんまく 幔幕"
"まんまる 真円 真ん丸"
"まんまん 満々"
"まんまんなか 真ん真ん中"
"まんめん 満面"
"まんもう 滿蒙 満蒙"
"まんもく 満目 万目"
"まんゆう 漫遊"
"まんよう 万葉"
"まんりき 万力"
"まんりょう 万両 満了"
"まんるい 満塁"
"まんるいだん 満塁弾"
"まんれき 万暦"
"み 稔 壬 己 深 靡 實 彌 弥 魅 三 美 御 見 巳 箕 味 未 身 実"
"みあ 未亜"
"みあい 美合 見合 見合い"
"みあけ 三宅"
"みあげ 見上"
"みあさ 美麻"
"みあま 三甘"
"みい 魅衣 御井 三井"
"みいけ 三池"
"みいし 御石"
"みいでら 三井寺"
"みいら 木乃伊"
"みいらか ミイラ化"
"みいらく 三井楽"
"みいり 実入り"
"みうけ 身請 身請け"
"みうごき 身動き"
"みうた 御歌"
"みうち 御内 身内"
"みうら 三浦"
"みうらきた 美浦北"
"みうり 身売 身売り"
"みえ 見え 美瑛 水絵 美江 美枝 美恵 見得 見栄 三重"
"みえい 御影"
"みえかくれ 見えかくれ"
"みえがくれ 見え隠れ"
"みえこ 実枝子 三重子 三恵子 三枝子 美枝子 美恵子"
"みえざるて 見えざる手"
"みえせん 三江線"
"みえだ 三枝"
"みえっぱり 見栄張り 見栄っ張り"
"みお 美尾 実音 未緒 水尾 美央 三尾 未央 美織 美緒 水脈 澪"
"みおこ 美央子"
"みおつくし 澪標"
"みおも 身重"
"みおや 御祖"
"みおり 美織"
"みか 三日 実可 三香 美歌 美華 美伽 美夏 実花 美加 美佳 美香 甕"
"みかい 味解 未開"
"みかく 味覚"
"みかけ 見かけ 見掛け"
"みかけだおし 見掛け倒し"
"みかげ 御蔭 御影"
"みかげいし 御影石"
"みかげつ 三ケ月"
"みかこ 美加子 美香子 美佳子"
"みかさ 三笠"
"みかさのみや 三笠宮"
"みかじめ 見ヶ〆"
"みかじめりょう みかじめ料"
"みかた 美方 三方 味方 見方"
"みかたはら 三方原"
"みかだ 三ヶ田"
"みかづき 三日月"
"みかづきこ 三日月湖"
"みかど 三門 御門 帝"
"みかほ 美華保"
"みかみ 見上 御神 三神 三上"
"みかみね 三神峯"
"みかめ 三瓶"
"みかも 美甘 三加茂"
"みかわ 実川 見川 三加和 三川 美川 三河"
"みかわしま 三河島"
"みかわちやき 三川内焼"
"みかん 味感 未刊 蜜柑 未完"
"みかんか ミカン科"
"みかんがり みかん狩り"
"みかんばこ みかん箱"
"みかんもく ミカン目"
"みがき 磨き"
"みがきこ 磨き粉"
"みがきずな 磨き砂"
"みがきにしん 身欠き鰊"
"みがく 研"
"みがため 身固め"
"みがって 身勝手"
"みがまえ 身構え"
"みがら 身柄"
"みがる 身軽"
"みがわり 身代り 身代わり"
"みき 未木 三基 三喜 三城 三紀 実紀 御木 三樹 美来 光希 美季 美喜 未希 三木 未稀 美希 美樹 美紀 美貴 未来 御酒 神酒 幹"
"みきお 三起男 幹男 幹雄 幹夫"
"みきき 見聞き"
"みきこ 実希子 美希子 美貴子 美樹子 幹子 美紀子"
"みきさーしゃ ミキサー車"
"みきのり 幹典"
"みきはら 美樹原"
"みきひこ 未来彦 三紀彦 幹彦"
"みきほ 美喜帆"
"みきもと 美樹本"
"みきや 御喜家 幹哉"
"みきょうらん 美狂乱"
"みきよ 幹代"
"みきろふう 三木露風"
"みぎ 」 』 】 ） ＞ → 右"
"みぎあし 右脚 右足"
"みぎうえ 右上"
"みぎうえすみ 右上隅"
"みぎうしろ 右後"
"みぎうち 右打"
"みぎうで 右腕"
"みぎえだ 右枝"
"みぎおく 右奥"
"みぎかた 右肩"
"みぎかっこ 】 』"
"みぎがわ 右側"
"みぎきき 右利 右利き"
"みぎぎし 右岸"
"みぎくりっく 右クリック"
"みぎこ 右子"
"みぎこし 右腰"
"みぎさいど 右サイド"
"みぎした 右下"
"みぎしたすみ 右下隅"
"みぎすみ 右隅"
"みぎず 右図"
"みぎそで 右袖"
"みぎて 右手"
"みぎどなり 右隣り 右隣"
"みぎどもえ 右巴"
"みぎのり 右乗"
"みぎはし 右端"
"みぎはんどる 右ハンドル"
"みぎひざ 右膝"
"みぎひじ 右肘"
"みぎひだり 右左"
"みぎほお 右頬"
"みぎぼたん 右ボタン"
"みぎまえ 右前"
"みぎまがり 右曲り"
"みぎまき 右巻"
"みぎまつ 右末 右松"
"みぎみみ 右耳"
"みぎむね 右胸"
"みぎめ 右目"
"みぎや 右矢 ⇒ →"
"みぎやじるし ⇒ →"
"みぎょうしょ 御教書"
"みぎよう 右様"
"みぎよこ 右横"
"みぎよせ 右寄"
"みぎより 右寄"
"みぎり 砌"
"みぎれい 身綺麗"
"みぎわ 頻 水際 汀"
"みぎわき 右脇"
"みく 美来 美久 未来"
"みくだりはん 三下半 三下り半 三行半"
"みくち 三口"
"みくに 御國 皇國 三國 御国 三国"
"みくにれんたろう 三國連太郎"
"みくま 三隈"
"みくも 三雲"
"みくらしま 御蔵島"
"みくりや 御厨"
"みくるま 御車"
"みくろけいざい ミクロ経済"
"みくろぶんせき ミクロ分析"
"みくろん μ"
"みぐし 御頭 御首 御髪"
"みぐるみ 身ぐるみ 身包み"
"みけ 三毛"
"みけた 三桁"
"みけつ 未決"
"みけつしゅう 未決囚"
"みけねこ 三毛猫"
"みけん 未見 眉間"
"みこ 神子 皇女 親王 巫 美子 御子 皇子 巫女"
"みこう 未稿"
"みこころ 御心"
"みこし 御輿 神輿"
"みこしぐさ 御輿草"
"みこしば 御子柴"
"みこと 美琴 御言 三言 尊 命"
"みことのり 敕 勅 詔"
"みこばら 皇女腹"
"みこみ 見込"
"みこん 未墾 未婚"
"みごうしゃ 見巧者"
"みごえ 実肥"
"みごしらえ 身拵え"
"みごたえ 見ごたえ"
"みごと 見事"
"みごろ 身頃 見頃"
"みごろし 見殺し"
"みさ 魅紗 美紗 未沙 美佐 美砂 美沙 弥撒"
"みさい 未済"
"みさいるこうげき ミサイル攻撃"
"みさいるぼうえい ミサイル防衛"
"みさお 美沙緒 操"
"みさか 三阪 御坂"
"みさかい 見境"
"みさき 三咲 三崎 美咲 御先 御前 崎 岬"
"みさきょく ミサ曲"
"みさくぼ 水窪"
"みさこ 美咲子 美砂子 美沙子 美佐子"
"みさご 雎鳩 鶚"
"みさごずし 鶚鮨"
"みささ 三笹 三篠 三朝"
"みささぎ 山陵 御陵 陵"
"みさと 箕郷 美郷 三郷 美里"
"みさわ 三澤 三沢"
"みさわやま 実沢山"
"みさんしょう 実山椒"
"みしお 美潮"
"みしな 三品"
"みしま 三嶋 三島"
"みしまで 三島手"
"みしゅう 未収"
"みしゅく 三宿"
"みしょう 御荘 未生 実生 未詳"
"みしょうりば 未勝利馬"
"みしらず 身知らず"
"みしるし 御璽"
"みしん 未進"
"みしんばり ミシン針"
"みしんめ ミシン目"
"みじか 短 身近"
"みじかうた 短歌"
"みじかめ 短め"
"みじかよ 短夜"
"みじたく 身仕度 身支度"
"みじまい 身仕舞い 身仕舞"
"みじめ 惨め"
"みじゅく 未熟"
"みじろぎ 身動ぎ 身じろぎ"
"みじん 微塵"
"みじんぎり みじん切り"
"みじんこ 微塵粉 微塵子"
"みす 三栖 御簾"
"みすい 未遂"
"みすえ 御末 三末"
"みすか 美須賀"
"みすがた 御姿"
"みすぎ 身過ぎ 美杉"
"みすぎいそ 三杉磯"
"みすぎさと 三杉里"
"みすじ 三筋"
"みすず 三鈴 美鈴"
"みすまる 御統"
"みすみ 三隅 三角"
"みすみす 見す見す"
"みず 瑞 水"
"みずあか 水垢"
"みずあげ 水揚げ"
"みずあさぎ 水浅葱"
"みずあし 水足"
"みずあそび 水遊び"
"みずあび 水浴び"
"みずあめ 水飴"
"みずあらい 水洗い"
"みずい 水井"
"みずいけ 水池"
"みずいで 水出"
"みずいと 水糸"
"みずいも 水芋"
"みずいらず 水入らず"
"みずいり 水入り"
"みずいれ 水入れ"
"みずいろ 水色"
"みずうみ 湖"
"みずえ 瑞枝 瑞江 水絵"
"みずお 瑞男 瑞生"
"みずおけ 水桶"
"みずおち 鳩尾"
"みずおと 水音"
"みずおよぎ 水泳ぎ"
"みずかえ 水替え"
"みずかがみ 水鏡"
"みずかき 蹼 水掻き"
"みずかけろん 水掛論 水掛け論"
"みずかげ 水影"
"みずかげん 水加減"
"みずかさ 水かさ 水嵩"
"みずかね 水銀"
"みずかみ 水上"
"みずかめざ 水瓶座"
"みずから 自ら"
"みずかわ 水川"
"みずがかり 水掛"
"みずがき 水柿 水垣 瑞籬 瑞垣"
"みずがし 水菓子"
"みずがね 水銀"
"みずがめ 水甕 水瓶"
"みずがれ 水涸れ"
"みずき 未図紀 美寿紀 瑞木 瑞季 瑞希 水城 水木 水樹"
"みずききん 水飢饉"
"みずきり 水切 水切り"
"みずきん 水金"
"みずぎ 水着"
"みずぎすがた 水着姿"
"みずぎょう 水行"
"みずぎれ 水切れ"
"みずぎわ 水際"
"みずくき 水茎"
"みずくさ 水草"
"みずくさい 水臭い"
"みずくぼ 水窪"
"みずくぼこ 水窪湖"
"みずぐすり 水薬"
"みずぐち 水口"
"みずぐも 水蜘蛛"
"みずぐるま 水車"
"みずけ 水気"
"みずけむり 水煙"
"みずげい 水芸"
"みずこ 水子"
"みずこうばい 水勾配"
"みずこし 水越"
"みずこぼし 水翻"
"みずこれい 水子霊"
"みずごえ 水肥"
"みずごけ 水蘚 水苔"
"みずごころ 水心"
"みずごり 水垢離"
"みずごろも 水衣"
"みずさいばい 水栽培"
"みずさかずき 水盃 水杯"
"みずさき 水先 水崎"
"みずさし 水差 水指 水差し"
"みずさわ 水澤 水沢"
"みずさわほたる 水沢蛍"
"みずし 瑞史"
"みずしげん 水資源"
"みずしごと 水仕事"
"みずしぶき 水しぶき 水飛沫"
"みずしま 水嶌 水縞 水嶋 水島"
"みずしょうばい 水商売"
"みずしょり 水処理"
"みずしらず 見ず知らず"
"みずしろ 水城"
"みずすまし 水澄"
"みずせ 水瀬"
"みずせっけん 水石鹸"
"みずせつやく 水節約"
"みずせん 水栓"
"みずぜき 水関"
"みずぜめ 水責め 水攻め"
"みずた 水田"
"みずたき 水炊き"
"みずたに 水谷"
"みずたま 水玉"
"みずたまり 水溜まり 水溜 水溜り"
"みずだこ 水章魚 水蛸"
"みずだし 水出し"
"みずち 蛟"
"みずちゃや 水茶屋"
"みずちゅうどく 水中毒"
"みずっぱな 水っ洟"
"みずつき 水付 七寸"
"みずづけ 水漬 水漬け"
"みずてきりょう 水適量"
"みずてっぽう 水鉄砲"
"みずてん 不見点 不見転"
"みずでっぽう 水鉄砲"
"みずとき 水溶き"
"みずとり 水鳥"
"みずどけい 水時計"
"みずどり 水鳥"
"みずな 水菜"
"みずなし 水無 水梨"
"みずなしがわ 水無し川"
"みずなみ 瑞浪"
"みずに 水煮"
"みずぬき 水抜 水抜き"
"みずぬま 水沼"
"みずぬれ 水濡れ"
"みずの 水野"
"みずのあわ 水の泡"
"みずのえ 壬"
"みずのえいぬ 壬戌"
"みずのえうま 壬午"
"みずのえさる 壬申"
"みずのえたつ 壬辰"
"みずのえとら 壬寅"
"みずのえね 壬子"
"みずのきえき 水軒駅"
"みずのただくに 水野忠邦"
"みずのて 水の手"
"みずのと 癸"
"みずのとい 癸亥"
"みずのとう 癸卯"
"みずのとうし 癸丑"
"みずのととり 癸酉"
"みずのとひつじ 癸未"
"みずのとみ 癸巳"
"みずのみ 水呑み 水飲み"
"みずのみば 水呑場"
"みずのみびゃくしょう 水呑み百姓"
"みずのもり 水の森"
"みずはけ 水捌け"
"みずはし 水橋"
"みずはら 水原"
"みずば 水場"
"みずばしょう 水芭蕉"
"みずばしら 水柱"
"みずばち 水鉢"
"みずばら 水腹"
"みずばり 水張り"
"みずばん 水番"
"みずぱいぷ 水パイプ"
"みずひき 水引"
"みずひと 瑞史"
"みずひろ 瑞洋"
"みずびたし 水浸し"
"みずぶき 水拭き"
"みずぶくれ 水脹れ 水膨れ"
"みずぶそく 水不足"
"みずぶとり 水太り"
"みずぶろ 水風呂"
"みずぶんし 水分子"
"みずへびざ 水蛇座"
"みずべ 水辺"
"みずほ 瑞穂"
"みずぼうそう 水疱瘡"
"みずぼり 水堀"
"みずま 水間 三潴"
"みずまき 水巻 水撒き"
"みずまくら 水枕"
"みずまし 水増 水増し"
"みずまち 水町"
"みずまわり 水周り 水回り 水廻り"
"みずむけ 水向け"
"みずむし 水虫"
"みずもと 水本"
"みずもの 水物"
"みずもり 水杜"
"みずもれ 水漏れ"
"みずや 水屋"
"みずやま 水山"
"みずやり 水遣り 水やり"
"みずよ 瑞代"
"みずようかん 水羊羹"
"みずら 角髪 角子 鬟 髻"
"みずろう 水牢"
"みずわり 水割り"
"みせ 見世 三瀬 廛 壥 店"
"みせうり 店売 店売り"
"みせかけ 見せ掛け"
"みせかた 見せ方"
"みせがね 見せ金"
"みせがまえ 店構え"
"みせがわ 店側"
"みせさき 店先"
"みせしめ 見せしめ"
"みせじたい 店自体"
"みせじまい 店じまい 店仕舞 店仕舞い"
"みせだな 見世棚 店棚"
"みせつ 未設"
"みせつけ 見せ付け 見せつけ"
"みせづくり 店作り"
"みせどころ 見せ所"
"みせば 見せ場"
"みせばん 店番"
"みせびらき 店開き"
"みせもの 見せ物"
"みせや 店屋"
"みぜに 身銭"
"みぜん 未然"
"みそ 三十 味噌"
"みそあん 味噌あん 味噌餡"
"みそう 未送"
"みそか 密か 晦日 晦"
"みそかつ 味噌カツ"
"みそぎ 禊"
"みそくそ 味噌糞"
"みそぐら 味噌蔵"
"みそこし 味噌漉し"
"みそさざい 鷦鷯"
"みそしる 味噌汁"
"みそだま 味噌玉"
"みそっかす 味噌っ滓"
"みそっぱ 味噌っ歯"
"みそづけ 味噌漬"
"みその 美薗 三園 御園"
"みそまめ 味噌豆"
"みそやき 味噌焼"
"みそら 身空 美空"
"みそらーめん 味噌ラーメン"
"みそらひばり 美空ひばり"
"みそんじ 見損じ"
"みぞ 渠 溝"
"みぞい 溝井"
"みぞう 未曽有 未曾有"
"みぞうえ 溝上"
"みぞうち 溝内"
"みぞおち 鳩尾"
"みぞきり 溝切り"
"みぞぐち 溝口"
"みぞた 溝田"
"みぞて 溝手"
"みぞのくち 溝の口"
"みぞはし 溝端"
"みぞぶち 溝淵 溝渕"
"みぞべ 溝辺"
"みぞれ 霙"
"みた 美田 見田 三田"
"みたか 三鷹"
"みたけ 三嶽 三岳 御嵩 身丈 御岳"
"みたつ 未達"
"みたて 御館"
"みたに 見谷 三谷"
"みたび 三度"
"みたま 御魂 三珠 御霊"
"みたむらえんぎょ 三田村鳶魚"
"みため 見た目"
"みたらい 御手洗"
"みたらし 御執 御弓 御手洗"
"みたり 三人"
"みだ 弥陀"
"みだい 見台 御台"
"みだし ※ ■ ◇ ＊"
"みだしなみ 身だしなみ 身嗜み"
"みだら 婬 猥ら 淫ら"
"みだりに 猥りに 濫りに 妄りに"
"みだれ 乱れ"
"みだれがみ みだれ髪 乱れ髪"
"みだれば 乱れ刃"
"みち 径 満ち 美知 謐 倫 通 蹊 路 途 未知 道"
"みちあき 道朗 通晃 通明 道明"
"みちあんない 道案内"
"みちいと 道糸"
"みちうえ 道上"
"みちえ 道恵 美智恵"
"みちお 道央 三千夫 三千雄 道生 道男 通夫 道雄 道夫"
"みちか 美智香"
"みちかけ 盈ち虧け"
"みちがみ 道上"
"みちがわ 道側"
"みちくさ 道草"
"みちこ 光知子 三智子 満子 美千子 通子 美知子 路子 倫子 道子 美智子"
"みちさと 満里"
"みちしお 満ち汐 満ち潮"
"みちしるべ 道導 道標"
"みちじゅん 道順"
"みちすがら 道すがら"
"みちすじ 道筋"
"みちぞい 道沿"
"みちた 道田"
"みちたか 命孝 充隆 通隆 道隆"
"みちたろう 道太郎"
"みちつた 道蔦"
"みちづら 道列 道面"
"みちづれ 道連れ"
"みちとし 通敏"
"みちなか 道中"
"みちなかば 道半ば"
"みちならぬ 道ならぬ"
"みちなり 途也 道也 道成 道形"
"みちにし 道西"
"みちのえき 道の駅"
"みちのく 陸奥"
"みちのし 道師"
"みちのなか 道の中"
"みちのべ 道の辺"
"みちのり 道のり 道程"
"みちはば 道幅"
"みちはら 道原"
"みちはる 亨治 道春"
"みちば 道場"
"みちばた 道傍 路端 路傍 道端"
"みちひ 満ち干"
"みちひこ 導彦"
"みちひで 通秀"
"みちひろ 倫広 倫洋 通博 道宏 道洋 通洋 道広 道弘"
"みちびき 導き"
"みちぶしん 道普請"
"みちべ 道辺"
"みちみち 道道 道々"
"みちむこ 道向"
"みちむら 道村"
"みちゃく 未着"
"みちゆき 道行き 道行"
"みちょう 未聴"
"みちよ 美千世 道世 通代 満代 路代 美千代 三千代 道代 美智代"
"みちよし 道由"
"みちる 未知瑠 未散"
"みちろう 道郎"
"みちわる 道悪"
"みぢか 身近"
"みっか ３日 三日"
"みっかい 密会"
"みっかび 三ケ日 三ヶ日"
"みっきょう 密教"
"みっくすけん ミックス犬"
"みっけい 密計"
"みっこう 密行 密航"
"みっこく 密告"
"みっさつ 密殺"
"みっし 密使"
"みっしつ 密室"
"みっしゅう 密集"
"みっしょ 密書"
"みっしょく 密植"
"みっしょんけい ミッション系"
"みっせい 密生"
"みっせつ 密接"
"みっせん 密栓"
"みっそ 密訴"
"みっそう 密奏 密送 密葬"
"みっちゃく 密着"
"みっつ ３つ 三つ"
"みっつう 密通"
"みっつめ 三つめ"
"みってい 密偵"
"みっぷう 密封"
"みっぺい 密蔽 密閉"
"みつ 滿 謐 櫁 円 充 満 光 三 三つ 密 蜜"
"みつあき 充璋 光璋 充章 光明 光昭"
"みつあみ 三つ編み"
"みつい 三井"
"みついし 三ッ石 三石"
"みついとうあつかがく 三井東圧化学"
"みついわ 三岩"
"みつうん 密雲"
"みつえ 光枝 光江 光恵 御杖"
"みつお 光穂 充雄 満夫 満雄 光生 三夫 三雄 三男 光夫 満男 光雄 光男"
"みつかいどう 水海道"
"みつかげ 光影"
"みつかん 蜜柑"
"みつが 密画"
"みつがさね 三つ重ね"
"みつき 観月 美月 三月"
"みつぎ 三ッ木 三ツ木 調 密儀 密議"
"みつぎもの 貢ぎ物"
"みつぎょうれつ 密行列"
"みつぎりぼん 三つ切本"
"みつくち 兎唇"
"みつくり 箕作"
"みつぐ 貢"
"みつぐみ 三組"
"みつけ 見付 見附"
"みつけつごう 密結合"
"みつげつ 蜜月"
"みつげん 蜜源"
"みつこ 三津子 充子 美都子 満子 美津子 光子"
"みつこし 三越"
"みつご 密語 蜜語 三子 三つ子"
"みつごん 密言"
"みつさと 満里"
"みつざわ 光澤"
"みつしま 満島 美津島"
"みつじ 密事 光地"
"みつせ 光瀬 三瀬"
"みつせりゅう 光瀬龍"
"みつせん 蜜腺"
"みつぞう 密造"
"みつぞろえ 三つ揃え"
"みつた 光田"
"みつたか 光毅 充隆"
"みつたけ 満武 光威"
"みつだ 満田 光田"
"みつだん 密談"
"みつつじ 光辻"
"みつつぼ 蜜壺"
"みつづか 三塚"
"みつてる 充照 光輝"
"みつてん 密天"
"みつとし 充敏 光年 光俊"
"みつとも 三友"
"みつど 密度"
"みつどもえ 三つ巴"
"みつなが 満永 光永"
"みつながしわ 御綱柏"
"みつなり 実成 光成 三成"
"みつにゅうこく 密入国"
"みつのがしわ 三角柏"
"みつのぶ 光延 光伸 光信"
"みつのり 充則 光紀 光範 光徳"
"みつはし 三ツ橋 三橋"
"みつはる 充治 光晴"
"みつば 三つ葉 三葉"
"みつばい 密売"
"みつばち 蜜蜂"
"みつひこ 美比古 光彦"
"みつひさ 充久 三久"
"みつひで 光秀"
"みつひろ 円博 満浩 満弘 充博 充浩 充洋 光裕 充宏 充弘 光浩 光宏 光博 光弘"
"みつびし 三菱"
"みつびしじこうきょうと 三菱自工京都"
"みつびしれいよん 三菱レイヨン"
"みつぶつ 密勿"
"みつぼう 密謀"
"みつぼうえき 密貿易"
"みつぼし 三ッ星 三星 三つ星"
"みつぼしべると 三ツ星ベルト"
"みつまさ 光雅 光政 光正"
"みつまた 三つ叉 三つ股 三椏 三叉"
"みつまたやり 三又槍"
"みつまめ 蜜豆"
"みつみつ 密密 密々"
"みつめい 密命"
"みつもう 密毛"
"みつもと 光本"
"みつもり 三森 見積"
"みつや 三ッ矢 三矢"
"みつやく 密約"
"みつゆ 密輸"
"みつゆき 三幸 充之 光之"
"みつゆしゅつ 密輸出"
"みつゆにゅう 密輸入"
"みつゆび 三ッ指 三つ指"
"みつよ 光世 光代"
"みつよし 光義"
"みつりょう 密漁 密猟"
"みつりん 密林"
"みつる 美弦 滿 満 充"
"みつろう 光郎 蜜蝋"
"みつわ 三輪"
"みづ 美津"
"みづき 観月"
"みづきしょぼう 三月書房"
"みづくろい 身繕い"
"みづち 蛟"
"みづの 美津濃"
"みづら 見面"
"みて 見手 御手"
"みてい 未定"
"みてくれ 見て呉れ"
"みてぐら 幣"
"みと 弥刀 御津 美都 三戸 水戸"
"みといずみ 水戸泉"
"みとう 味到 美東 未到 未踏"
"みとく 味得"
"みところ 三所"
"みとせ 三歳 三年"
"みとみ 三富"
"みとめ 三留 認め"
"みとめいん 認印"
"みとや 三刀屋"
"みとよ 三豊"
"みとらきょう ミトラ教"
"みとり 見取"
"みどう 御堂"
"みどく 味読 未読"
"みどころ 見処 見どころ 見所"
"みどし 巳年"
"みども 身共"
"みどり 美土里 美登里 碧 翠 緑"
"みどりいし 緑石"
"みどりいろ 緑色"
"みどりかい 緑会"
"みどりかわ 緑川"
"みどりがおか 緑が岡 緑ケ丘 緑が丘 緑ヶ丘"
"みどりがめ 緑亀"
"みどりく 緑区"
"みどりご 嬰児"
"みどりじゅうじ ミドリ十字"
"みどりちょう 緑町"
"みどりでんし 緑電子"
"みどりのかくめい 緑の革命"
"みどりのとう 緑の党"
"みどりのまどぐち 緑の窓口"
"みどりまい 緑米"
"みどりまち 緑町"
"みどりまめ 緑豆"
"みどりみ 緑味"
"みどりや 緑屋"
"みどりやま 緑山"
"みどるきゅう ミドル級"
"みどろいけ 深泥池"
"みどろがいけ 深泥池"
"みな 美那 美菜 美奈 皆"
"みない 美内 南井"
"みないっしょ 皆一緒"
"みなえ 美奈江"
"みなかた 皆方 南方"
"みなかみ 水上"
"みなかわ 皆川"
"みながわ 皆川"
"みなきょうだい 皆兄弟"
"みなくち 水口"
"みなぐち 源口 皆口"
"みなげ 身投げ"
"みなこ 実奈子 皆子 美名子 三奈子 美菜子 みな子 美奈子"
"みなごろし 鏖 皆殺し"
"みなさま 皆様"
"みなさん 皆さん"
"みなし 看做し 見做し"
"みなしご 孤児"
"みなせ 水無瀬"
"みなそこ 水底"
"みなつ 美夏"
"みなつき 水無月"
"みなづき 水月 水無月"
"みなと 湊 港"
"みなとおおはし 港大橋"
"みなとがわ 湊川"
"みなときたく 港北区"
"みなとく 港区"
"みなとせいき 港製機"
"みなとふじ 湊富士"
"みなとまち 港街 湊町 港町"
"みなとみなみぐち 港南口"
"みなの 皆野"
"みなのしゅう 皆の衆"
"みなのもの 皆の者"
"みなびょうどう 皆平等"
"みなべ 南部"
"みなまた 水俣"
"みなみ 南美 皆実 美並 三波 美波 南"
"みなみあじあ 南アジア"
"みなみあふりか 南アフリカ"
"みなみあめりか 南アメリカ"
"みなみあるぷすし 南アルプス市"
"みなみかぜ 南風"
"みなみかた 南方"
"みなみかわ 南河"
"みなみかん 南舘 南館"
"みなみかんのんざん 南観音山"
"みなみがわ 南側"
"みなみく 南区"
"みなみぐち 南口"
"みなみこま 南巨摩"
"みなみじゅうじせい 南十字星"
"みなみせん 南線"
"みなみたか 南高"
"みなみだ 南田"
"みなみだい 南台"
"みなみだか 南高"
"みなみだて 南館"
"みなみちょう 南町"
"みなみで 南出"
"みなみどの 南殿"
"みなみな 皆皆 皆々"
"みなみの 南野"
"みなみのさんかくざ 南の三角座"
"みなみほんしゅく 南本宿"
"みなみまき 南牧"
"みなみまち 南町"
"みなみむら 南村"
"みなみもと 南本"
"みなみもりまち 南森町"
"みなみもん 南門"
"みなみゆき 南行"
"みなみゆふ 南由布"
"みなも 水面"
"みなもと 源"
"みなもとけ 源家"
"みなもとのかねまさ 源兼昌"
"みなもとのさねとも 源実朝"
"みなもとのしげゆき 源重之"
"みなもとのひろまさ 源博雅"
"みなもとのよしつね 源義経"
"みなもとのよりいえ 源頼家"
"みなもとのよりとも 源頼朝"
"みなもとよしつね 源義経"
"みなもとよりよし 源頼義"
"みなよ 美奈代"
"みならい 見習 見習い"
"みなり 身なり 身形"
"みなわ 水沫 水泡"
"みにかぶ ミニ株"
"みにこみし ミニコミ誌"
"みね 美根 美禰 三子 岑 三根 美祢 峯 嶺 峰"
"みねい 嶺井"
"みねうち 峰打ち"
"みねお 実音夫 岑夫 峯夫 岑生 峰央 峰雄 峰夫"
"みねぎし 嶺岸 峯岸 峰岸"
"みねこ 峰子"
"みねごし 峰越"
"みねざき 峯崎 峰崎"
"みねの 峯野"
"みねのはら 峰の原"
"みねはま 峰浜"
"みねひさ 峰久"
"みねまつ 峰松"
"みねむら 峰村 峯村"
"みねやま 峰山"
"みねゆき 峰幸"
"みねらるぶん ミネラル分"
"みねらるるい ミネラル類"
"みの 箕 簔 簑 三野 美濃 蓑"
"みのいも 蓑芋"
"みのう 箕面 美濃 未納"
"みのうえ 身の上"
"みのうら 箕浦"
"みのお 箕面"
"みのかわ 身の皮"
"みのがこい 美濃囲い"
"みのがし 見逃し"
"みのき 三軒"
"みのけ 身の毛"
"みのげ 蓑毛"
"みのしま 箕島"
"みのしょう 美濃庄"
"みのしろ 身の代"
"みのしろきん 身代金"
"みのたけ 身の丈"
"みのため 身のため 身の為"
"みのだ 箕田 簑田 蓑田"
"みのと 美濃戸"
"みのはた 蓑畑"
"みのはら 箕原 蓑原"
"みのぶ 美乃夫 身延"
"みのべたつきち 美濃部達吉"
"みのほど 身の程"
"みのまわり 身の回り"
"みのむし 蓑虫"
"みのやき 美濃焼"
"みのり 美野里 稔 御法 稔り 実り"
"みのる 穣 實 稔 実"
"みのわ 蓑輪 箕輪"
"みのわた 三の焦"
"みはい 未配"
"みはかし 御刀"
"みはし 三橋"
"みはた 御旗"
"みはつ 未発"
"みはなだ 水縹"
"みはば 身幅"
"みはま 御浜 美浜"
"みはら 美原 三原"
"みはらいかんじょう 未払勘定"
"みはらいきん 未払金"
"みはらし 見晴らし"
"みはる 美春 美晴 三春"
"みば 見端"
"みばえ 見映え 見栄え"
"みばらい 未払"
"みばん 三晩"
"みひつ 未必"
"みひつのこい 未必の故意"
"みひとつ 身一つ"
"みひら 三平"
"みひらき 見開き"
"みびいき 身贔屓"
"みびょう 未病"
"みふしとうげ 三伏峠"
"みふじ 美富士"
"みふたつ 身二つ"
"みふね 御船 三船"
"みぶ 壬生"
"みぶな 壬生菜"
"みぶのただみ 壬生忠見"
"みぶのただみね 壬生忠岑"
"みぶり 身振 身ぶり 身振り"
"みぶるい 身震い"
"みぶん 未分 身分"
"みへん 身偏"
"みほ 海蜂 美峰 実穂 美浦 三保 美豊 美歩 美保 美帆 美穂"
"みほこ 三穂子 美帆子 美保子 美穂子"
"みほぜき 美保関"
"みほた 三保田"
"みほとけ 御仏"
"みほのせき 美保関"
"みほろ 美浦"
"みほん 見本"
"みほんずり 見本刷"
"みぼうじん 未亡人"
"みま 三間 美馬"
"みまい 見舞い 見舞"
"みまえ 御前"
"みまき 御牧"
"みまさか 美作"
"みまた 三股"
"みまつ 三松"
"みまな 任那"
"みまね 見まね"
"みまわりひん 見回品"
"みまん 未満"
"みみ 耳"
"みみあか 耳垢"
"みみあて 耳当て"
"みみあな 耳穴"
"みみいがい 耳以外"
"みみうち 耳打 耳打ち"
"みみかき 耳掻き"
"みみかくし 耳隠し"
"みみかざり 耳飾 耳飾り"
"みみがくもん 耳学問"
"みみがた 耳型"
"みみくそ 耳クソ 耳くそ 耳糞"
"みみこぴー 耳コピー"
"みみざわり 耳触り 耳障り"
"みみしい 耳癈"
"みみしっかん 耳疾患"
"みみず 蚯蚓"
"みみずく 角鴟 木菟"
"みみずばれ 蚯蚓脹れ"
"みみせん 耳栓"
"みみそうじ 耳掃除"
"みみたこ 耳タコ"
"みみたぶ 耳たぶ 耳朶"
"みみだれ 耳垂れ"
"みみづか 耳塚"
"みみどしま 耳年増"
"みみないぶ 耳内部"
"みみなしやま 耳成山"
"みみなり 耳鳴 耳鳴り"
"みみぬき 耳抜 耳抜き"
"みみぶくろ 耳袋"
"みみへん 耳偏"
"みみもと 耳許 耳元"
"みみょう 微妙"
"みみより 耳寄り"
"みみわ 耳輪"
"みむ 美夢"
"みむら 三村"
"みむらさき 実紫"
"みむろ 三室 御室"
"みめ 美芽 眉目 見目"
"みめい 未明"
"みめかたち 見目形"
"みもう 味盲"
"みもだえ 身悶え"
"みもち 身持 身持ち"
"みもと 身許 御許 身元"
"みもの 実物 見物"
"みもり 深森 未森"
"みもりまる 美森丸"
"みもん 未聞"
"みゃく 脉 脈"
"みゃくあつ 脈圧"
"みゃくかん 脈管"
"みゃくけい 脈系"
"みゃくしん 脈診"
"みゃくどう 脈動"
"みゃくはく 脈搏 脈拍"
"みゃくみゃく 脈脈 脈々"
"みゃくらく 脈絡"
"みゃくらくまく 脈絡膜"
"みゃくりゃく 脈略"
"みゃくりゅう 脈流"
"みや 美弥 宮"
"みやい 宮居 宮井"
"みやいだい 宮医大"
"みやいり 宮入"
"みやうち 宮内"
"みやえき 宮駅"
"みやお 宮尾"
"みやおか 宮岡"
"みやおそうか ミヤオソウ科"
"みやかわ 宮川"
"みやがく 宮学"
"みやがた 宮方"
"みやがわ 宮川"
"みやき 宮木"
"みやきょう 宮教"
"みやきょうだい 宮城教育大学"
"みやぎ 宮木 宮城"
"みやぎしま 宮城島"
"みやぎの 宮城野"
"みやく 未訳"
"みやくに 宮国"
"みやくぼ 宮窪"
"みやくら 宮倉"
"みやぐち 宮口"
"みやけ 宮家 三宅"
"みやけざか 三宅坂"
"みやげ 土産"
"みやこ 京都 宮戸 宮子 美弥子 美也子 宮古 都"
"みやこいり 都入り"
"みやこう 宮交"
"みやこおおじ 都大路"
"みやこおち 都落ち"
"みやこじ 都路"
"みやこじま 都島"
"みやこどり 都鳥"
"みやこのじょう 都城"
"みやこびと 都人"
"みやこぶしおんかい 都節音階"
"みやご 三八五"
"みやごし 宮越"
"みやさか 宮坂"
"みやさと 宮里"
"みやさま 宮様"
"みやざき 宮崎"
"みやざきはやお 宮崎駿"
"みやざと 宮里"
"みやざわ 宮澤 宮沢"
"みやした 宮下"
"みやしの 宮篠"
"みやしろ 宮代"
"みやじ 宮路 宮地"
"みやじま 宮嶋 宮島"
"みやじょう 宮絛"
"みやすんどころ 御息所"
"みやずみ 宮住"
"みやずもう 宮相撲"
"みやせ 宮瀬"
"みやぞえ 宮副"
"みやぞの 宮苑"
"みやぞのぶし 宮薗節"
"みやた 宮田"
"みやたけ 宮竹 宮武"
"みやたに 宮谷"
"みやだい 宮大"
"みやだいく 宮大工"
"みやち 宮地"
"みやちよ 宮千代"
"みやぢ 宮地"
"みやづ 宮津"
"みやづかえ 宮仕え"
"みやでら 宮寺"
"みやと 宮戸"
"みやなが 宮永"
"みやなぎ 三柳"
"みやにし 宮西"
"みやの 宮野"
"みやのうえ 宮之上"
"みやのぎ 宮野木"
"みやのさわ 宮の沢"
"みやのじょう 宮之城"
"みやのぼり 宮登"
"みやはら 宮原"
"みやばしら 宮柱"
"みやばら 宮腹"
"みやび 雅び 雅"
"みやびと 宮人"
"みやびやか 雅びやか"
"みやふくせん 宮福線"
"みやべ 宮部"
"みやま 御山 海山 三山 深山 美山"
"みやまいり 宮参り"
"みやまえ 宮前"
"みやまち 宮町"
"みやまる 宮丸"
"みやみ 未也美"
"みやむら 宮村"
"みやもと 宮本"
"みやもり 宮森 宮守"
"みやもんぜき 宮門跡"
"みやら 宮良"
"みやわき 宮脇"
"みゅー Μ μ"
"みゅーりゅうし μ粒子"
"みゅう μ"
"みゆう 美憂"
"みゆき 美有紀 美由希 美由起 幸 美雪 美由紀 美幸 み雪 行幸 御幸 深雪"
"みょう 螟 榠 冥 命 明 名 妙"
"みょうあさ 明朝"
"みょうあん 妙案"
"みょうえ 明恵"
"みょうおう 明王"
"みょうおん 妙音"
"みょうおんどおり 妙音通"
"みょうかい 冥界"
"みょうかん 冥官"
"みょうが 茗加 冥加 茗荷"
"みょうがだに 茗荷谷"
"みょうきょく 妙曲"
"みょうぎ 妙技 妙義"
"みょうぎしょう 名義抄"
"みょうぎょう 明経"
"みょうく 妙句"
"みょうけい 妙計"
"みょうけん 妙見"
"みょうこう 妙高"
"みょうこうじ 妙興寺"
"みょうごう 冥合 名号"
"みょうごにち 明後日"
"みょうごねん 明後年"
"みょうさく 妙策"
"みょうしゅ 妙趣 妙手"
"みょうしゅん 明春"
"みょうしょ 妙所"
"みょうしんじ 妙心寺"
"みょうじ 苗字 名字"
"みょうじゅう 命終"
"みょうじゅつ 妙術"
"みょうじょ 冥助"
"みょうじょう 明星"
"みょうじん 明神"
"みょうせき 名跡"
"みょうせんじしょう 名詮自性"
"みょうぜつ 妙絶"
"みょうぜんじ 妙善寺"
"みょうそう 妙想"
"みょうだい 名代"
"みょうだに 名谷"
"みょうちょう 明朝"
"みょうちん 明珍"
"みょうにち 明日"
"みょうねん 明年"
"みょうは 妙葩"
"みょうばん 明晩 明礬"
"みょうぶ 命婦"
"みょうほう 妙法"
"みょうみ 妙味"
"みょうもく 名目"
"みょうもん 名聞"
"みょうもんりよう 名聞利養"
"みょうや 明夜"
"みょうやく 妙薬"
"みょうよう 妙用"
"みょうり 冥利 名利"
"みょうれい 妙齢"
"みょうれん 明連"
"みょうれんじ 妙蓮寺"
"みょんどん 明洞"
"みよ 美代 御世 御代"
"みよう 見様"
"みようみまね 見よう見真似 見よう見まね"
"みよこ 美代子"
"みよし 三膳 三善 三吉 三芳 三次 三好"
"みよた 御代田"
"みよはら みよ原"
"みより 身寄り"
"みら 韮 韭"
"みらい 味蕾 未来"
"みらさか 三良坂"
"みらの 未蘭"
"みり 粍"
"みりおんしゅっぱん ミリオン出版"
"みりぐらむ 瓱"
"みりは ミリ波"
"みりびょう ミリ秒"
"みりめーとる 粍"
"みりょう 未了 魅了"
"みりょく 魅力"
"みりりっとる 竓"
"みりん 未林 味醂"
"みりんぼし 味醂干"
"みる 海松 覩"
"みるからに 見るからに"
"みるがい 海松貝"
"みるくあじ ミルク味"
"みるくがゆ ミルク粥"
"みるくに ミルク煮"
"みるみる 見る見る"
"みるめ 見る目"
"みれい 美麗"
"みれん 未練"
"みろく 彌勒 弥勒"
"みわ 巳波 神酒 三和 三輪 美和"
"みわく 魅惑"
"みわけ 見分"
"みわこ 美和子"
"みわざ 御業"
"みわた 三輪田"
"みわだ 三輪田"
"みん 罠 閔 明 眠 民"
"みんい 民意"
"みんえい 民営"
"みんおく 民屋"
"みんおん 民音"
"みんか 民家"
"みんかつ 民活"
"みんかへい 民家塀"
"みんかん 明槓 民間"
"みんぎょう 民業"
"みんぐ 民具"
"みんけん 民権"
"みんげい 民芸"
"みんこー 明刻"
"みんこう 民航"
"みんこく 民國 民国"
"みんざい 眠剤"
"みんし 明史"
"みんしゃ 民社"
"みんしゅ 民主"
"みんしゅう 民衆"
"みんしゅく 民宿"
"みんしゅせい 民主政"
"みんしん 民心"
"みんじ 民事"
"みんじゅ 民需"
"みんじょう 民情"
"みんせい 民声 民青 民政 民生"
"みんせん 民選"
"みんせんぎいんせつりつけんぱくしょ 民撰議院設立建白書"
"みんそ 民訴"
"みんぞく 民俗 民族"
"みんぞくがみ 民族神"
"みんたろう 民太郎"
"みんたんしゅう 民譚集"
"みんだ 民田"
"みんちょう 明朝"
"みんていけんぽう 民定憲法"
"みんてつ 民鉄"
"みんとう 民党"
"みんど 民度"
"みんな 皆な 皆"
"みんはく 民博"
"みんぱく 民博 民泊"
"みんぶ 民部"
"みんぶんか 明文化"
"みんぷう 民風"
"みんぺい 民平 民兵"
"みんぼう 民望"
"みんぽう 民放 民法"
"みんぽうだい 民法第"
"みんぽうてん 民法典"
"みんぽんしゅぎ 民本主義"
"みんまや 三厩"
"みんみんぜみ みんみん蝉"
"みんめいしょぼう 民明書房"
"みんゆう 民有"
"みんゆうりん 民有林"
"みんよう 民謡"
"みんりょく 民力"
"みんわ 民話"
"む 梦 毋 无 牟 謀 鵡 武 霧 務 矛 六 夢 無"
"むーあじん ムーア人"
"むーたいりく ムー大陸"
"むーみん 夢民"
"むーるがい ムール貝"
"むあい 無愛"
"むあつしき 無圧式"
"むい 六 無位 無意 無為"
"むいか ６日 六日"
"むいせ 無畏施"
"むいそん 無医村"
"むいん 無韻"
"むいんし 無韻詩"
"むうげ 無憂華"
"むえき 無益"
"むえん 無煙 無援 無塩 無鉛 無縁"
"むえんたん 無煙炭"
"むえんばたー 無塩バター"
"むえんぼとけ 無縁仏"
"むおう 夢奥"
"むおん 無音"
"むか 無化"
"むかい 向 迎 向かい 向井"
"むかいかぜ 向い風"
"むかいがおか 向ケ丘"
"むかいがわ 向川 向い側"
"むかいがわら 向河原"
"むかいしま 向島"
"むかいたに 向谷"
"むかいなだ 向洋"
"むかいの 向野"
"むかいはら 向原"
"むかいや 向谷"
"むかいやま 向山"
"むかえ 迎 迎え"
"むかえこう 迎え講"
"むかえび 迎え火"
"むかか 無花果"
"むかご 零余子"
"むかし 昔"
"むかしかたぎ 昔気質"
"むかしがたり 昔語り"
"むかしごころ 昔心"
"むかしざま 昔様"
"むかしづくり 昔作り"
"むかしとんぼ 昔蜻蛉"
"むかしながら 昔ながら"
"むかしにほん 昔日本"
"むかしばなし 昔話"
"むかしふう 昔風"
"むかしむかし 昔昔 昔々"
"むかしものがたり 昔物語"
"むかっぱら むかっ腹 向かっ腹"
"むかで 蜈蚣 百足"
"むかばら 向か腹"
"むかゆうきょう 無何有郷"
"むかわ 武川 鵡川"
"むかん 無官 無感 無冠"
"むが 無我"
"むがい 無蓋 無害"
"むがく 無学"
"むがるていこく ムガル帝国"
"むき 無季 無気 無記 向き 無期 無機"
"むきえ 向江"
"むきかた 剥き方"
"むきず 無疵 無傷"
"むきだし 剥き出し"
"むきはい 無気肺"
"むきみ 剥き身"
"むきゅう 無級 無窮 無給 無休"
"むきゅうどう 無窮動"
"むきょう 無興 夢境 無響"
"むきょく 無極"
"むきん 無菌"
"むきんせいずいまくえん 無菌性髄膜炎"
"むぎ 麥 牟岐 麦"
"むぎあき 麦秋"
"むぎいい 麦飯"
"むぎくさとうげ 麦草峠"
"むぎこ 麦粉"
"むぎこがし 麦焦がし"
"むぎさく 麦作"
"むぎじょうちゅう 麦焼酎"
"むぎたに 麥谷 麦谷"
"むぎちゃ 麦茶"
"むぎとろ 麦薯蕷"
"むぎのあき 麦の秋"
"むぎばたけ 麦畑"
"むぎひと 麦人"
"むぎぶえ 麦笛"
"むぎめし 麦飯"
"むぎや 麦谷"
"むぎやぶし 麦や節"
"むぎゆ 麦湯"
"むぎらくがん 麦落雁"
"むぎわら 麦ワラ 麦わら 麦藁"
"むぎわらぼうし 麦稈帽子"
"むく 向 尨 椋 無垢"
"むくい 酬い 報い 報"
"むくいた 無垢板"
"むくいぬ 尨犬"
"むくげ 尨毛 葮 木槿 毳 槿"
"むくだ 椋田"
"むくだい 椋代"
"むくち 無口"
"むくどり 椋鳥"
"むくな 椋名"
"むくのき 椋木"
"むくみ 浮腫"
"むくろ 躯 骸"
"むくろじもく ムクロジ目"
"むぐら 葎"
"むけ 無卦 向"
"むけい 無茎 無形"
"むけつ 無血 無欠"
"むけん 無券 無間"
"むけんだいり 無権代理"
"むげ 無礙 無下 無碍"
"むげい 無芸"
"むげがわ 武芸川"
"むげん ∞ 無幻 無言 無間 夢幻 無限"
"むげんあつ 無限厚"
"むげんえん 無限遠"
"むげんぎ 無限木"
"むげんだい ∞"
"むげんるーぷ 無限ループ"
"むげんれんさこう 無限連鎖講"
"むこ 壻 聟 無辜 婿"
"むこいり 婿入り"
"むこう 向う 向こう 無功 無向 無孔 向日 無香 無効"
"むこういた 向板"
"むこうがおか 向ケ丘 向ヶ丘"
"むこうきず 向こう疵 向こう傷"
"むこうぎし 向こう岸"
"むこうぎり 向切"
"むこうぐらふ 無向グラフ"
"むこうさんげん 向こう三軒"
"むこうじま 向島"
"むこうじょうめん 向正面"
"むこうずね 向う脛 向こう脛"
"むこうみず 向こう見ず"
"むこがわ 婿側 武庫川"
"むこく 無告"
"むこさん 婿さん"
"むこたとうるい ムコ多糖類"
"むことり 婿取り"
"むこのそう 武庫之荘"
"むこようし 婿養子"
"むこん 無根"
"むご 惨"
"むごん 無言"
"むごんのぎょう 無言の行"
"むさい 無菜 無妻 無才"
"むさく 無策"
"むさし 武蔵"
"むさしこうだい 武蔵工業大学"
"むさしさかい 武蔵境"
"むさしせき 武蔵関"
"むさしの 武蔵野"
"むさしぼうべんけい 武蔵坊弁慶"
"むさつ 無札"
"むさん 無算 無産 霧散"
"むざい 無罪"
"むざつ 無雑"
"むざん 無慚 無慙 無残 無惨"
"むし 毟 無始 夢死 無私 無死 蟲 蒸し 無視 虫"
"むしあき 虫明"
"むしおくり 虫送り"
"むしかご 虫かご 虫籠"
"むしがし 蒸菓子"
"むしがた 虫型"
"むしき 無支奇 無識"
"むしくい 虫喰い 虫食い"
"むしくいざん 虫食い算"
"むしくだし 虫下し"
"むしぐすり 虫薬"
"むしけ 虫気"
"むしけら 虫けら 虫螻"
"むしごめ 蒸し米"
"むしさされ 虫刺され"
"むししぐれ 虫時雨"
"むしず 虫唾 虫酸"
"むしたおる 蒸しタオル"
"むしつかい 蟲使い"
"むしとり 虫取り"
"むしに 蒸煮"
"むしのいき 虫の息"
"むしば 虫歯"
"むしばら 虫腹"
"むしぱん 蒸しパン"
"むしぴん 虫ピン"
"むしふうじ 虫封じ"
"むしぶんれつ 無糸分裂"
"むしへん 虫偏"
"むしぼし 虫干し"
"むしむしゅう 無始無終"
"むしむへん 無私無偏"
"むしめがね 虫メガネ 虫眼鏡 虫めがね"
"むしゃ 武者"
"むしゃく 無錫"
"むしゃぶるい 武者震い"
"むしゅ 無主"
"むしゅう 無臭"
"むしゅく 無宿"
"むしょう 霧消 無性 無償"
"むしょく 夢色 無色 無職"
"むしよけ 虫除け"
"むしりざかな 毟り魚"
"むしろ 席 蓆 莚 筵 寧ろ"
"むしん 無心"
"むしんろん 無神論"
"むじ 無事 無地"
"むじつ 無実"
"むじな 豸 貉 狢"
"むじなへん 豸偏"
"むじゅう 無住"
"むじゅん ⊥ 矛盾"
"むじょう 無上 無常 無情"
"むじるし 無印"
"むじん 無塵 無尽 無人"
"むじんとう 無人島"
"むすい 無水"
"むすいなべ 無水鍋"
"むすう 無数"
"むすこ 息子"
"むすひ 産霊"
"むすび 結び"
"むすびさより 結び針魚"
"むすぼれ 結ぼれ"
"むすめ 娘"
"むすめご 娘御 娘子"
"むすめざかり 娘盛り"
"むすめじだい 娘時代"
"むすめたち 娘達"
"むすめっこ 娘っ子"
"むすめどうじょうじ 娘道成寺"
"むすめばら 娘腹"
"むすめむこ 娘婿"
"むすめやく 娘役"
"むずかしさ 難しさ"
"むせい 無性 夢精 無声"
"むせいらん 無精卵"
"むせき 無籍"
"むせきてき 無責的"
"むせきにんおとこ 無責任男"
"むせつ 無節"
"むせびなき 噎び泣き 咽び泣き"
"むせん 無銭 無線"
"むせんたぐ 無線タグ"
"むせんらん 無線LAN"
"むせんるーた 無線ルータ"
"むぜい 無勢 無税"
"むそう 無想 夢想 無双"
"むそうむねん 無相無念"
"むそうやま 武双山"
"むそじ 六十"
"むた 無佗 牟田"
"むたい 無体"
"むたまがわ 武玉川"
"むだ 徒 無駄"
"むだあし 無駄足"
"むだい 無代 無題"
"むだがね 無駄金"
"むだげ 徒毛 無駄毛 ムダ毛"
"むだじに 無駄死に"
"むだづかい 徒遣い 無駄遣い"
"むだなく 無駄無く"
"むだにく 無駄肉"
"むだばな 徒花"
"むだぼね 無駄骨"
"むだめし 徒飯 無駄飯"
"むだめしぐい 無駄飯食い"
"むだん 無断"
"むだんへんそく 無段変速"
"むち 無智 笞 無恥 鞭 無知"
"むちうち 鞭打 鞭打ち"
"むちく 無畜"
"むちゃ 無茶"
"むちゅう 霧中 夢中"
"むちょう 無徴 無調"
"むちん 無賃"
"むっつ 六つ"
"むつ 六 六つ 陸奥 睦"
"むつあい 六会"
"むつあき 睦明"
"むつう 無痛"
"むつうら 六浦"
"むつお 睦夫"
"むつき 睦紀 襁褓 睦月"
"むつこ 睦子"
"むつごと 睦言"
"むつざわ 睦沢"
"むつしげ 睦茂"
"むつのり 睦典"
"むつひろ 睦裕"
"むつび 睦び"
"むつみ 睦つ美 睦都美 六実 睦美 睦"
"むつものがたり 睦物語"
"むつゆき 睦之"
"むつよ 睦予"
"むつらぼし 六連星"
"むつれじま 六連島"
"むて 無手"
"むてかつりゅう 無手勝流"
"むてき 霧笛 無敵"
"むてんぼん 無点本"
"むでん 無電"
"むとう 無答 無頭 無糖 武藤"
"むとうせき 無答責"
"むとく 無徳"
"むとどけ 無届"
"むどう 武堂 無動 無道"
"むどく 無毒"
"むな 宗 棟 胸"
"むなあて 胸当て"
"むないた 胸板"
"むなかた 宗形 宗方 棟方 宗像"
"むなかたしこう 棟方志功"
"むながい 鞅 胸懸"
"むながわら 棟瓦"
"むなぎ 棟木"
"むなくそ 胸糞"
"むなぐら 胸座 胸倉"
"むなげ 胸毛"
"むなごと 空言 虚言"
"むなさき 胸先 胸前"
"むなさわぎ 胸騒ぎ"
"むなざんよう 胸算用"
"むなせ 皆瀬"
"むなそこ 胸底"
"むなだか 胸高"
"むなち 胸乳"
"むなつき 胸突き"
"むなひも 胸紐"
"むなびれ 胸鰭"
"むなぼね 胸骨"
"むなもと 胸許 胸元"
"むに 無二"
"むにねん 無二念"
"むにむさん 無二無三"
"むにょう 無尿"
"むにんしょ 無任所"
"むね 刀背 宗 旨 棟 胸"
"むねあき 宗昭 宗明"
"むねあげ 棟上げ"
"むねあげしき 棟上式"
"むねあて 胸当て"
"むねいっぱい 胸一杯"
"むねお 宗夫 宗雄 宗男"
"むねかざり 棟飾り"
"むねかた 宗片"
"むねがわら 棟瓦"
"むねくそ 胸糞"
"むねくに 宗国"
"むねさんずん 胸三寸"
"むねざわ 宗澤"
"むねざんよう 胸算用"
"むねしげ 宗重"
"むねた 崇田"
"むねたか 宗高"
"むねたけ 宗武"
"むねだ 宗田"
"むねとし 宗敏 宗俊"
"むねとも 宗朋"
"むねにく ムネ肉 胸肉"
"むねのり 宗典"
"むねはる 宗治"
"むねひさ 宗久"
"むねひも 胸紐"
"むねひろ 宗裕"
"むねふじ 宗藤"
"むねべつせん 棟別銭"
"むねぼね 胸骨"
"むねぽけっと 胸ポケット"
"むねまち 棟区"
"むねまわり 胸囲り 胸回り"
"むねもと 胸元"
"むねやけ 胸やけ 胸焼け"
"むねゆき 宗幸"
"むねよし 宗吉 宗良"
"むねわり 棟割り 棟割"
"むねん 無念"
"むのう 無能"
"むは 無派"
"むはい 無配 無敗"
"むはんしゃたん 無反射端"
"むばつ 無罰"
"むひ 無比"
"むひつ 無筆"
"むひょう 無標 霧氷"
"むび 夢寐"
"むびゅう 無謬"
"むびょう 無病"
"むふう 無風"
"むへん 無辺"
"むへんざい 無辺際"
"むべ 宜"
"むほう 無法"
"むほん 謀叛 謀反"
"むぼう 無帽 無謀"
"むま 夢魔"
"むみ 無味"
"むみょう 無明"
"むみょうしょう 無名抄"
"むみょうぢょうや 無明長夜"
"むめ 梅 無目"
"むめい 無銘 無名"
"むもう 無毛"
"むもん 無紋 無文"
"むやく 無役 無益"
"むやま 無山"
"むやみ 無闇"
"むゆう 無釉 夢遊"
"むゆうげ 無憂華"
"むゆか 六日"
"むよう 無用"
"むようのちょうぶつ 無用の長物"
"むようのよう 無用の用"
"むよく 無慾 無欲"
"むら 邨 屯 邑 叢 群 斑 村"
"むらい 無頼 村井"
"むらいし 村石"
"むらうち 村内"
"むらお 村生 村尾"
"むらおか 村岡"
"むらおこし 村起こし"
"むらかた 村方"
"むらかみ 村上"
"むらかみりゅう 村上龍"
"むらき 村木"
"むらくし 村櫛"
"むらくも 叢雲"
"むらくものつるぎ 叢雲剣"
"むらこし 村越"
"むらさき 村さ来 紫"
"むらさきいがい 紫貽貝"
"むらさきいも 紫芋"
"むらさきいろ 紫色"
"むらさきうに 紫海胆"
"むらさきうまごやし 紫馬肥"
"むらさききゃべつ 紫キャベツ"
"むらさきしきぶ 紫式部"
"むらさきすいしょう 紫水晶"
"むらさきつゆくさ 紫露草"
"むらさきの 紫野"
"むらさきのうえ 紫の上"
"むらさきのり 紫海苔"
"むらさめ 叢雨 村雨"
"むらさわ 村沢 村澤"
"むらざと 村里"
"むらし 蒸らし"
"むらしぐれ 叢時雨 村時雨"
"むらした 村下"
"むらしゃかい ムラ社会 村社会"
"むらじ 村地 連"
"むらじゅう 村中"
"むらすずめ 群雀"
"むらせ 村瀬"
"むらた 邑田 村田"
"むらたけ 群竹"
"むらたに 村谷"
"むらち 村地"
"むらなか 村中"
"むらなく ムラ無く"
"むらにし 村西"
"むらの 村野"
"むらはずれ 村外れ"
"むらはちぶ 村八分"
"むらびと 村人"
"むらまさ 村正"
"むらまつ 村松"
"むらまつり 村祭 村祭り"
"むらむすめ 村娘"
"むらむら 村々"
"むらもと 村本"
"むらやくにん 村役人"
"むらやくば 村役場"
"むらやま 群山 村山"
"むらゆご ムラユ語"
"むらわき 村脇"
"むり 無理"
"むりおうじょう 無理圧状"
"むりからぬ 無理からぬ"
"むりじい 無理強い"
"むりやり 無理やり"
"むりょ 無慮"
"むりょう 無聊 無量 無料"
"むりょうさーびす 無料サービス"
"むりょうじゅ 無量寿"
"むりょく 無力"
"むるい 無類"
"むれ 羣 蒸れ 牟礼 群れ 群"
"むれい 牟礼"
"むれすずめ 群雀"
"むろ 無漏 榁 牟婁 室"
"むろあじ 室鰺"
"むろい 室井"
"むろう 室生"
"むろうさいせい 室生犀星"
"むろおか 室岡"
"むろかわ 室川"
"むろが 室賀"
"むろた 室田"
"むろたに 室谷"
"むろつ 室津"
"むろと 室戸"
"むろとみさき 室戸岬"
"むろどう 室堂"
"むろどこ 室床"
"むろね 室根"
"むろはし 室橋"
"むろふし 室伏"
"むろまち 室町"
"むろみ 室見"
"むろや 室哉 室谷 室屋"
"むろやま 室山"
"むろらん 室蘭"
"むろん 無論"
"め 睨 海布 海藻 碼 瑪 奴 雌 女 眼 芽 目"
"めーとるげんき メートル原器"
"めーとるは メートル波"
"めーとるほう メートル法"
"めーるつうち メール通知"
"めーるびん メール便"
"めあかし 目明かし"
"めあかん 雌阿寒"
"めあき 目明き"
"めあて 貭 目当て"
"めい 謎 茗 酩 榠 溟 瞑 暝 冥 盟 鳴 明 銘 姪 迷 命 名"
"めいあらし 明嵐"
"めいあん 冥暗 名案 明暗"
"めいい 名彙 名医"
"めいうせん 名羽線"
"めいうん 命運"
"めいえん 名演"
"めいおう 明応 冥王 明王"
"めいおうせい 冥王星"
"めいおん 鳴音"
"めいか 名菓 名花 名歌 名家 銘菓"
"めいかい 冥界 明解 明快"
"めいかく 明確"
"めいかん 銘肝 名鑑"
"めいが 螟蛾 名画"
"めいがく 明学"
"めいがら 銘柄"
"めいがらどり 銘柄鶏"
"めいがらまい 銘柄米"
"めいき 銘器 銘機 名器 名機 銘記 明記"
"めいきゅう 迷宮"
"めいきゅうかい 名球会"
"めいきょう 明鏡"
"めいきょく 名局 名曲"
"めいきん 鳴禽"
"めいぎ 名技 名妓 名義"
"めいぎがし 名義貸し"
"めいぎがり 名義借り"
"めいぎょく 名玉"
"めいぎん 名吟"
"めいく 名句"
"めいくおとし メイク落とし"
"めいくん 明訓 明君 名君"
"めいけ 女池 名家"
"めいけい 明経"
"めいけいどう 茗渓堂"
"めいけつ 名血"
"めいけん 迷犬 名剣 名犬"
"めいげき 名劇"
"めいげつ 明月 名月"
"めいげついん 明月院"
"めいげん 瞑眩 鳴弦 迷言 明言 名言"
"めいこ 茗子"
"めいこう 名香 名港 名工"
"めいご 迷語 明午 姪御"
"めいごう 冥合"
"めいさい 迷彩 明細"
"めいさく 迷作 名作"
"めいさつ 明察 名刹"
"めいさま 名様"
"めいさん 名産"
"めいざん 名山"
"めいし 名氏 明視 名士 名詞 名刺"
"めいしき 明識"
"めいしゃ 鳴謝 眼医者 目医者 名車"
"めいしゅ 明主 名主 明珠 盟主 名酒 銘酒 名手"
"めいしゅう 迷執"
"めいしょ 名処 名所"
"めいしょう 鳴鐘 名相 明証 名将 名匠 名勝 名称"
"めいしょうせん 名松線"
"めいしょうてんのう 明正天皇"
"めいしょく 明色"
"めいしん 名神 迷信"
"めいじ 名辞 明示 明治"
"めいじつ 名實 名実"
"めいじゃく 名弱"
"めいじょう 名状 名城"
"めいじん 明神 名人"
"めいすい 名水"
"めいすう 命数 名数"
"めいせい 名聲 明星 名声"
"めいせき 名跡 明晰"
"めいせつ 名節"
"めいせりふ 名セリフ"
"めいせん 名泉 銘仙 名川"
"めいぜんりょう 明善寮"
"めいそう 冥想 明窓 名僧 迷走 瞑想"
"めいそうじょうき 明窓浄几 明窓浄机"
"めいぞく 名族"
"めいた 目板"
"めいたつ 明達"
"めいたん 名短"
"めいだ 銘打"
"めいだい 名古屋大学 明大 名大 命題"
"めいだん 明断"
"めいち 命知 名地 明知 明智"
"めいちゃ 名茶 銘茶"
"めいちゅう 命中"
"めいちょ 名著"
"めいちょう 名帳 鳴鳥 明徴 迷鳥 明澄"
"めいっこ 姪っ子"
"めいっぱい 目一杯"
"めいてい 名艇 酩酊"
"めいてき 名笛"
"めいてつ 名鉄 明哲"
"めいてん 名店"
"めいでんこう 名電高"
"めいでんしゃ 明電舎"
"めいとう 名糖 名東 明答 名答 銘刀 名刀 名湯"
"めいとうさんぎょう 明糖産業"
"めいとく 明徳"
"めいど 冥途 冥土 明度"
"めいどう 明堂 鳴動"
"めいどのみやげ 冥土の土産"
"めいどふく メイド服"
"めいにち 命日"
"めいはく 明白"
"めいはん 名阪"
"めいば 名馬"
"めいばめん 迷場面"
"めいばん 名盤"
"めいひつ 名筆"
"めいひょう 名票"
"めいひん 銘品 名牝 名品"
"めいび 明媚"
"めいびゅう 迷謬"
"めいびん 明敏"
"めいふ 冥府"
"めいふく 冥福"
"めいぶつ 名物"
"めいぶつおとこ 名物男"
"めいぶつぎれ 名物裂"
"めいぶん 名聞 銘文 名文 明文 名分"
"めいほう 盟邦 明芳 名豊 名宝 名峰"
"めいぼ 名簿"
"めいぼう 名望 明眸"
"めいぼく 名木 銘木"
"めいみ 芽美"
"めいみゃく 命脈"
"めいむ 迷霧 迷夢"
"めいめい 冥々 銘銘 命名 銘々 明々"
"めいめいはくはく 明明白白"
"めいめつ 明滅"
"めいもう 迷妄"
"めいもく 瞑目 名目"
"めいもん 名門"
"めいやく 名薬 名訳 盟約"
"めいゆ 明喩"
"めいゆう 盟友 名優"
"めいよ 名誉"
"めいよう 没有"
"めいよきそん 名誉棄損"
"めいり 名利"
"めいりゅう 名流"
"めいりょう 明瞭"
"めいりん 明林"
"めいりんかん 明倫館"
"めいりんどう 明倫堂"
"めいれい 命令"
"めいれき 明暦"
"めいれきのたいか 明暦の大火"
"めいろ 目色 迷路"
"めいろう 明朗"
"めいろん 名論"
"めいわ 明和"
"めいわく 迷惑"
"めいわくめーる 迷惑メール"
"めうえ 目上"
"めうし 牝牛 雌牛"
"めうち 目打 目打ち"
"めうつり 目移り"
"めお 女男"
"めおし 目押し"
"めおと 娚 夫婦"
"めおとぼし 夫婦星"
"めかき 芽掻き"
"めかくし 目隠 目隠し"
"めかけ 妾"
"めかけばら 妾腹"
"めかじき 眼旗魚"
"めかた 目方"
"めかど 目角"
"めかぶ 和布蕪 雌株"
"めかぶら 和布蕪"
"めかま 目蒲"
"めかり 和布刈 和布刈り"
"めかりぶね 和布刈舟 和布刈り舟"
"めが 女鹿"
"めがお 目顔"
"めがしら 目頭"
"めがね 眼鏡"
"めがねっこ メガネっ娘 眼鏡っ娘"
"めがねや メガネ屋"
"めがみ 女神"
"めがわ 女川"
"めきき 目利き"
"めきしこ 墨西哥"
"めきしこじん メキシコ人"
"めきゃべつ 芽キャベツ"
"めぎか メギ科"
"めぎつね 牝狐 女狐"
"めぎみ 妻君 女君"
"めぎれ 目切れ"
"めくぎ 目釘"
"めくされ 目腐れ"
"めくされがね 目腐れ金"
"めくじら 目鯨 目くじら"
"めくそ 目屎 目クソ 目くそ 目糞"
"めくち 目口"
"めくばせ 眼配せ 目配せ"
"めくばり 目配り"
"めくら 瞽 盲"
"めくらうち 盲打ち"
"めくらかべ 盲壁"
"めくらじま 盲縞"
"めくらばん 盲判"
"めくらまし 目眩し"
"めくらまど 盲窓"
"めくらめっぽう 盲滅法"
"めくり 捲り"
"めくるめく 目眩く"
"めぐすり 目薬"
"めぐみ めぐ美 惠 慈 愛美 恵美 め組 恵み 恵"
"めぐみのあめ 恵みの雨"
"めぐむ 萠 恵"
"めぐりあい 巡り合い"
"めぐりあわせ 巡り合わせ"
"めぐろ 目黒"
"めぐろのさんま 目黒の秋刀魚"
"めこぼし 目溢し"
"めごち 雌鯒"
"めさき 目崎 目先"
"めざし 目刺 目刺し"
"めざと 目敏"
"めざまし 目覚し 目覚まし"
"めざめ 目覚め"
"めざわり 目障り"
"めし 飯"
"めしあい 飯合"
"めしい 盲"
"めしがま 飯釜"
"めした 目下"
"めしたき 飯焚き 飯炊き"
"めしたきおんな 飯炊き女"
"めしだい 飯代"
"めしぢゃわん 飯茶碗"
"めしつかい 召し使い 召使い 召使"
"めしつぶ 飯粒"
"めしどき 飯時"
"めしのたね 飯の種"
"めしびつ 飯櫃"
"めしべ 雌蘂 雌蕊"
"めしもの 召し物"
"めしもり 飯盛り"
"めしもりおんな 飯盛り女"
"めしや 飯屋"
"めしりょう 召料"
"めしろ 眼代 目代"
"めしわん 飯椀 飯碗"
"めじ 目路 目時 目地"
"めじか 牝鹿 女鹿"
"めじり 目尻"
"めじるし 目印"
"めじろ 繍眼児 目白"
"めじろおし 目白押"
"めす ♀ 牝 雌"
"めすいぬ 牝犬 メス犬 雌犬"
"めすうま 雌馬 牝馬"
"めすかぶ 雌株"
"めすねこ メス猫 牝猫 雌猫"
"めず 馬頭"
"めずらか 珍か"
"めせん 目線"
"めそぽたみあぶんめい メソポタミア文明"
"めたげんご メタ言語"
"めたりろん メタ理論"
"めたんはっこう メタン発酵"
"めだか 目高"
"めだけ 女竹"
"めだしぼう 目出し帽"
"めだち 目立"
"めだちたがりや 目立ちたがり屋"
"めだつ 目立つ"
"めだま 眼球 目玉"
"めだまやき 目玉焼"
"めちがい 目違い"
"めちゃ 目茶"
"めちゃくちゃ 滅茶苦茶"
"めちゃめちゃ 滅茶滅茶"
"めっき 滅金 鍍金"
"めっきゃく 滅却"
"めっきん 滅菌"
"めっさう 滅相"
"めっさつ 滅殺"
"めっし 滅紫 滅私"
"めっしつ 滅失"
"めっしゅがた メッシュ型"
"めっしゅきじ メッシュ生地"
"めっしゅじ メッシュ地"
"めっせーじせい メッセージ性"
"めっそう 滅相"
"めった 滅多"
"めったい 滅諦"
"めったぎり メッタ斬り"
"めったづき 滅多突き"
"めったに 滅多に"
"めっぽう 滅法"
"めつ 滅"
"めつき 眼付 眼つき 目つき 目付き"
"めつけ 目付け 目付"
"めつご 滅期 滅後"
"めつざい 滅罪"
"めつじん 滅尽"
"めつち 目土"
"めつぶし 目潰し"
"めつぼう 滅亡"
"めつれつ 滅裂"
"めづかい 目遣い"
"めづまり 目詰り 目詰まり"
"めて 右手 馬手"
"めで 愛で"
"めでぃあおう メディア王"
"めでぃちけ メディチ家"
"めでとう 目出当"
"めでゅさんどらもく メデュサンドラ目"
"めとき 目時"
"めど 蓍 針孔 目途 目処"
"めどおし 目通し"
"めどおり 目通り"
"めどき 女時"
"めどぎ 蓍"
"めなだ 眼奈太 赤目魚"
"めなみ 女波"
"めにえーるびょう メニエール病"
"めぬき 目抜き 目貫"
"めぬま 妻沼"
"めねじ 雌螺子"
"めのう 碼碯 瑪瑙"
"めのかたき 目の敵"
"めのこ 海布の子 布の子 目の子 女の子"
"めのこざん 目の子算"
"めのたま 眼の玉 目の玉"
"めのと 乳母"
"めのどく 目の毒"
"めのほよう 目の保養"
"めのまえ 目の前"
"めはし 目端"
"めはちぶ 目八分"
"めはな 目鼻"
"めばえ 芽生え"
"めばな 雌花"
"めばり 目貼り 目張り"
"めばる 眼張"
"めひょう 女豹"
"めびき 目引"
"めぶし 雌節 女節"
"めぶんりょう 目分量"
"めへん 目偏"
"めべり 目減り"
"めぼし 目星"
"めまい 目眩い 目まい 暈 眩暈"
"めまとい 目纏い"
"めまひ 目眩い 眩暈 目眩ひ"
"めまんべつ 女満別"
"めみえ 目見え"
"めむろ 芽室"
"めめざこ 目々雑魚 目目雑魚"
"めめじゃこ 目々雑魚 目目雑魚"
"めもじ 目文字"
"めもちょう メモ帳"
"めもと 目許 目元"
"めもま メモ魔"
"めもり 目盛り 目盛"
"めやす 目安"
"めやすばこ 目安箱"
"めやに 目ヤニ 目やに 目脂"
"めら 目良"
"めらにんしきそ メラニン色素"
"めりか 芽里香"
"めりけんこ メリケン粉"
"めりはり 乙張 減張 減り張り"
"めりょう 馬寮"
"めるかとるずほう メルカトル図法"
"めるとも メル友"
"めろう 女郎"
"めん 眄 麪 緜 棉 緬 免 綿 麺 面"
"めんあつ 面圧"
"めんいつ 面一"
"めんえき 免役 免疫"
"めんおり 綿織"
"めんか 綿価 棉花 綿花"
"めんかい 面会"
"めんかく 面角"
"めんかやく 綿火薬"
"めんかん 免官"
"めんが 面画"
"めんきつ 面詰"
"めんきょ 免許"
"めんぎょ 面魚"
"めんくい 面食 面食い"
"めんけつごう 面結合"
"めんけん 瞑眩"
"めんこ 面子"
"めんこうげん 面光源"
"めんこうふはい 面向不背"
"めんご 面語"
"めんざい 免罪"
"めんし 綿糸"
"めんしき 面識"
"めんしゃ 綿紗 面紗"
"めんしゅう 免囚"
"めんしゅうごう 面集合"
"めんしょく 面色 免職"
"めんしん 免震"
"めんしんりっぽうこうし 面心立方格子"
"めんじゅう 面従"
"めんじゅうこうげん 面従後言"
"めんじょ 免除"
"めんじょう 面状 免状 面上"
"めんすう 面数"
"めんせい 面性"
"めんせいひん 綿製品"
"めんせき 面積 免責"
"めんせつ 面接"
"めんぜい 免税"
"めんぜん 面前"
"めんぜんちん 門前清"
"めんそ 面素 免租 免訴"
"めんそう 面相"
"めんたい 面対 面体 明太"
"めんたいこ 明太子"
"めんたいしょう 面対称"
"めんたま 目ん玉"
"めんだ 免田"
"めんだん 面談"
"めんちょう 面疔"
"めんちん 面陳"
"めんつ 面子"
"めんつゆ 麺つゆ"
"めんてい 面体 免停"
"めんてなんすせい メンテナンス性"
"めんでん 緬甸 免田"
"めんとう 面頭"
"めんとおし 面通し"
"めんとり 面取 面取り"
"めんどう 面堂 面倒"
"めんどうみ 面倒見"
"めんどり 雌鶏 雌鳥"
"めんない 面内"
"めんば 面罵"
"めんばーかん メンバー間"
"めんばーしょうかい メンバー紹介"
"めんばかんすう メンバ関数"
"めんばへんすう メンバ変数"
"めんぴ 面皮"
"めんぶ 面部"
"めんぷ 綿布"
"めんぺき 面壁"
"めんぼう 綿紡 面貌 麺棒 綿棒"
"めんぼく 面目"
"めんぽう 面皰"
"めんぽお 面頬"
"めんま 麺麻"
"めんみつ 綿密"
"めんみつど 面密度"
"めんめん 綿綿 面面 綿々 面々"
"めんもう 綿毛"
"めんもく 面目"
"めんよう 面容 綿羊 緬羊 面妖"
"めんようそ 面要素"
"めんるい 麺類"
"めんれんけつ 面連結"
"めんわり 面割り"
"も 貰 邑 望 楙 母 姆 面 茂 糢 摸 模 裳 藻 喪"
"もーせごしょ モーセ五書"
"もーせのじっかい モーセの十戒"
"もーどぎょう モード行"
"もーどめい モード名"
"もーるすしんごう モールス信号"
"もーるすふごう モールス符号"
"もいち 茂一"
"もう 申 莽 网 耄 耗 望 魍 罔 芒 妄 亡 艨 濛 檬 朦 矇 曚 蒙 孟 猛 盲 毛 網"
"もうあ 盲唖"
"もうあい 妄愛 盲愛"
"もうあく 猛悪"
"もうい 猛威"
"もういちど もう一度"
"もうう 猛雨"
"もううん 妄雲"
"もうか 真岡 猛火"
"もうかん 毛幹 毛管"
"もうかんしょうこうぐん 盲管症候群"
"もうかんじゅうそう 盲管銃創"
"もうがっこう 盲学校"
"もうき 濛気 盲亀"
"もうきのふぼく 盲亀の浮木"
"もうきん 猛禽"
"もうぎゅう 猛牛"
"もうけ 儲 儲け"
"もうけやく 儲役"
"もうけん 猛犬"
"もうげん 妄言"
"もうこ 猛虎 蒙古"
"もうこう 猛攻"
"もうこうねん 孟浩然"
"もうこはん 蒙古斑"
"もうこん 毛根"
"もうご 妄語"
"もうごかい 妄語戒"
"もうさい 毛細"
"もうし 孟子"
"もうしあわせ 申し合せ 申合せ 申し合わせ"
"もうしいれ 申入れ 申し入れ"
"もうしおくり 申送り 申し送り"
"もうしこし 申し越し"
"もうしこみ 申込み 申込 申し込み"
"もうしご 申し子"
"もうしじょう 申し条 申条 申し状 申状"
"もうしたて 申し立て 申立て 申立"
"もうしで 申出 申し出"
"もうしひらき 申し開き"
"もうしぶみ 申文"
"もうしぶん 申し分"
"もうしもく 網翅目"
"もうしゃ 猛射 盲者"
"もうしゅう 猛襲 妄執"
"もうしゅん 孟春"
"もうしょ 猛暑"
"もうしょう 猛将"
"もうしわけ 申し分け 申訳 申し訳"
"もうしわけない 申し訳ない"
"もうしん 盲進 妄信 盲信 猛進"
"もうじゃ 盲者 亡者"
"もうじゅう 盲従 猛獣"
"もうじょう 毛状 網状"
"もうじょうみゃく 網状脈"
"もうじん 蒙塵 盲人"
"もうすこし もう少し"
"もうすぴーど 猛スピード"
"もうせい 猛省"
"もうせつ 妄説"
"もうせん 毛氈"
"もうせんごけ 毛氈苔"
"もうぜん 惘然 猛然"
"もうそう 網総 盲僧 妄想"
"もうそうだけ 孟宗竹"
"もうそうちく 孟宗竹"
"もうたい 毛帯"
"もうたくとう 毛沢東"
"もうだ 猛打"
"もうだっしゅ 猛ダッシュ"
"もうだん 妄断 妄談"
"もうちょう 猛鳥 盲腸"
"もうつい 猛追"
"もうてん 盲点"
"もうで 詣で 詣"
"もうとう 毛頭"
"もうとく 孟徳"
"もうどう 艨艟 盲動 妄動 盲導"
"もうどうけん 盲導犬"
"もうどく 猛毒"
"もうない 網内"
"もうねん 妄念"
"もうのう 毛嚢"
"もうはつ 毛髪"
"もうはん 盲斑"
"もうばく 盲爆 猛爆"
"もうぱい 盲牌"
"もうひつ 毛筆"
"もうひとつ もう一つ"
"もうひょう 猛豹 妄評"
"もうふ 毛布"
"もうふう 猛風"
"もうほう 毛包"
"もうぼ 孟母"
"もうまい 濛昧 矇昧 曚昧 蒙昧"
"もうまく 網膜"
"もうもう 朦朦 濛濛 朦々 濛々"
"もうもく 盲目"
"もうもん 網紋"
"もうゆう 猛勇"
"もうよう 網様"
"もうようたい 毛様体"
"もうら 網羅"
"もうり 毛利"
"もうりょう 魍魎"
"もうれつ 猛烈"
"もうろう 朦朧"
"もうろく 耄碌"
"もえ 萠 萌 燃 萌絵 萌え 燃え"
"もえかす 燃え滓"
"もえがら 燃え殻"
"もえぎ 萌え木 萌葱 萌木 萌黄"
"もえこ 萌子"
"もおか 真岡"
"もがさ 痘瘡"
"もがみ 最上"
"もがり 強請 虎落 殯"
"もがりたけ 虎落竹"
"もがりぶえ 虎落笛"
"もぎ 摸擬 茂木 模擬"
"もぎてすと 模擬テスト"
"もぎどう 没義道"
"もく 默 沐 杢 黙 木 目"
"もくあみ 木阿弥 黙阿弥"
"もくか 木化"
"もくかい 黙会"
"もくがす 木ガス"
"もくきん 木金"
"もくぎょ 木魚"
"もくぐう 木偶"
"もくぐん 目群"
"もくげき 黙劇 目撃"
"もくこうぞう 木構造"
"もくさく 木柵 木酢"
"もくさつ 木札 黙殺"
"もくさん 目算"
"もくざい 木材"
"もくし 目指 黙思 黙止 黙視 黙示 目視"
"もくしつ 木質"
"もくしょう 目睫 木匠"
"もくしょうぜん 黙照禅"
"もくじ 黙示 目次"
"もくじき 木食"
"もくじゅう 黙従"
"もくず 藻屑"
"もくせい 木精 木犀 木星 木製"
"もくせいか モクセイ科"
"もくせいもく モクセイ目"
"もくぜん 黙然 目前"
"もくそう 目送 黙想"
"もくそく 目測"
"もくぞう 木像 木造"
"もくたーる 木タール"
"もくたん 木炭"
"もくだい 目代"
"もくだく 黙諾"
"もくちょう 木彫"
"もくづ 藻屑"
"もくてき 目的"
"もくてきじょうせいとう 目的上正当"
"もくてきじょうひつよう 目的上必要"
"もくと 目睹 目途"
"もくとう 黙祷"
"もくどく 黙読"
"もくにん 黙認"
"もくねん 黙念 黙然"
"もくの 杢野"
"もくはい 木盃 木杯"
"もくはん 木版"
"もくば 木馬"
"もくひ 木樋 木皮 黙秘"
"もくひょう 目標"
"もくぶ 木部"
"もくへん 木片"
"もくほん 木本"
"もくぼ 木母"
"もくまおうもく モクマオウ目"
"もくめ 木目"
"もくもう 木毛"
"もくもく 黙黙 黙々"
"もくやく 黙約"
"もくよう 木曜"
"もくよく 沐浴"
"もくらん 木蘭"
"もくらんじき 木蘭色"
"もくれい 黙礼 目礼"
"もくれん 木蓮"
"もくれんか モクレン科"
"もくれんが 木煉瓦"
"もくれんもく モクレン目"
"もくろう 木蝋"
"もくろく 黙録 目録"
"もくろみ 目論見"
"もくろん 目論"
"もぐさ 藻草 艾"
"もぐさえん 百草園"
"もぐら 土龍 土竜"
"もぐらたたき モグラ叩き"
"もぐり 潜り"
"もけい 模型"
"もこ 糢糊 模糊"
"もこく 摸刻 模刻"
"もこし 裳階"
"もこと 藻琴"
"もさ 猛者"
"もさく 模作 摸索 模索"
"もざいくじょう モザイク状"
"もざいくびょう モザイク病"
"もし 若し 模試"
"もしか 若しか"
"もしき 摸式 模式"
"もしくは 若しくは"
"もしも 若しも"
"もしゃ 摸冩 摸写 模写"
"もしゅ 喪主"
"もしょう 喪章"
"もじ 綟 門司 文字"
"もじおち 文字落"
"もじきなか 文字寸半"
"もじきょう 文字鏡"
"もじこーど 文字コード"
"もじことば 文字詞"
"もじさいず 文字サイズ"
"もじずり 捩摺"
"もじゃこ 藻雑魚"
"もじやき 文字焼"
"もじゅーるか モジュール化"
"もじゅーるしき モジュール式"
"もじり 捩"
"もすきーときゅう モスキート級"
"もすくわ 莫斯科"
"もすそ 裳裾"
"もず 鴃 鵙 百舌 百舌鳥"
"もずく 海蘊 水雲 海雲"
"もずくす もずく酢"
"もずみ 茂住"
"もずめ 物集 物集女"
"もせい 茂生"
"もせうし 妹背牛"
"もそう 模奏"
"もぞう 模像 摸造 模造"
"もたれ 靠れ 凭れ"
"もだえ 悶え"
"もだえじに 悶え死に"
"もち 勿 餠 持 持ち 望 黐 糯 餅"
"もちあい 持合い 持合 持ち合い"
"もちあみ 餅網"
"もちあわせ 持合せ 持ち合せ"
"もちい 用い"
"もちいえ 持ち家"
"もちいね 糯稲"
"もちうた 持ち歌"
"もちお 持尾"
"もちおくり 持送り"
"もちかぶ 持株"
"もちがし 餅菓子"
"もちがせ 用瀬"
"もちがね 持ち金"
"もちぐされ 持腐れ 持ち腐れ"
"もちこし 持越し 持越 持ち越し"
"もちこみ 持込み 持込"
"もちこみうま 持込馬"
"もちごま 持駒"
"もちごめ 糯米 糯 もち米 餅米"
"もちずき 望月"
"もちだ 持田"
"もちだい 餅代"
"もちだし 持出し 持出"
"もちつき 餅つき 餅搗き"
"もちつもたれつ 持ちつ持たれつ"
"もちづき 餅月 望月"
"もちて 持手"
"もちにげ 持逃げ"
"もちぬし 持主"
"もちねた 持ちネタ"
"もちのひ 望の日"
"もちはだ 餅膚 餅肌"
"もちば 持場"
"もちばん 持番"
"もちひろ 望洋"
"もちふだ 持ち札"
"もちぶん 持分"
"もちまえ 貭"
"もちまる 持丸"
"もちまわり 持回り"
"もちむね 用宗"
"もちもの 持物"
"もちや 餅屋"
"もちゅう 喪中"
"もちより 持寄り"
"もちろん 勿論"
"もっか 木化 黙過 目下"
"もっかい 黙会 木灰"
"もっかく 木槨"
"もっかつじばん 木活字版"
"もっかどこんすい 木火土金水"
"もっかん 木簡 木管"
"もっき 木器"
"もっきつ 勿吉"
"もっきゃく 没却"
"もっきょ 黙許"
"もっきん 木琴"
"もっけ 勿怪 物怪"
"もっけい 牧谿 黙契 木鶏"
"もっこ 畚"
"もっこう 黙考 木瓜 木工"
"もっこつ 木骨"
"もっこん 目今"
"もっしょくし 没食子"
"もったい 勿体"
"もったいない 勿体無い"
"もって 以て"
"もってこい 持って来い"
"もってのほか 以ての外"
"もっとも 尤も 最も"
"もっともやく 尤役"
"もっぱら 専ら"
"もつ 勿 物"
"もつご 没後"
"もつなべ モツ鍋 もつ鍋"
"もつにゅう 没入"
"もつやき もつ焼き"
"もつやく 没薬"
"もつれ 縺れ"
"もてぎ 茂木"
"もでるか モデル化"
"もでるじぎょう モデル事業"
"もと 旧 故 礎 幹 望都 本 素 下 許 基 元"
"もとあき 元明 元昭"
"もとあり 本有"
"もとい 元い 元結 基"
"もといけ 本池"
"もといし 本石 元石"
"もとうた 元歌"
"もとえ 元絵"
"もとえい 基栄"
"もとお 誠生 元朗 元夫 基夫 元男"
"もとおか 元岡"
"もとおり 本居"
"もとおりのりなが 本居宣長"
"もとかず 元一"
"もとかど 本門"
"もとかの 元カノ"
"もとかぶ 元株"
"もとかれ 元カレ 元彼"
"もとかわ 本川"
"もとがしわ 本柏"
"もとき 基紀 元基 元紀 基樹 本木 元木"
"もときゅう 本久"
"もときん 元金"
"もとこ 茂登子 基子 元子 素子"
"もとごえ 基肥 元肥"
"もとさと 理元"
"もとざわ 本澤"
"もとし 基志 元志 基史 元司"
"もとしげ 元重"
"もとじ 元司"
"もとじま 本島"
"もとじめ 元締 元締め"
"もとじゅく 本宿"
"もとじろう 基次郎"
"もとす 本栖 本巣"
"もとすえ 本末"
"もとすこ 本栖湖"
"もとせん 元栓"
"もとたか 元孝 基隆"
"もとただ 元正"
"もとだ 元田"
"もとだか 元高"
"もとだね 元種"
"もとちょう 元帳"
"もとで 元手"
"もとでら 元寺"
"もとどり 髻"
"もとなが 源久"
"もとなり 本生り 本成り 元成 元就"
"もとに 基に 元に"
"もとね 元値"
"もとねた 元ネタ"
"もとの 基乃 元野 本埜"
"もとのぶ 元信"
"もとのり 一徳 素典 元紀"
"もとはし 本橋"
"もとはず 本筈 本弭"
"もとはま 元浜"
"もとはら 本原"
"もとはる 元春"
"もとばこ 元箱"
"もとばこづき 元箱付"
"もとばやし 本林"
"もとばらい 元払"
"もとひこ 元彦"
"もとひさ 幹久 基久 元久"
"もとひで 元英 元秀"
"もとひろ 礎弘 基史 元洋 基博"
"もとび 元火"
"もとふみ 元文"
"もとぶ 本部"
"もとまち 元町"
"もとみち 素道"
"もとみや 本宮"
"もとむら 本村"
"もとめ 求め"
"もともと 元元 基々 元々"
"もとや 元也"
"もとやま 元山 本山"
"もとやわた 本八幡"
"もとやん 元ヤン"
"もとゆい 元結"
"もとゆき 幹之 基之"
"もとよし 基良 元慶 基吉 元吉 本吉"
"もとよししんのう 元良親王"
"もとより 素より 固より 元より"
"もとる 乖"
"もどき 擬き"
"もどしこうはい 戻し交配"
"もどしじる 戻し汁"
"もどしぜい 戻し税"
"もどり 戻り"
"もどりがつお 戻り鰹"
"もどりち 戻値"
"もどりてがた 戻手形"
"もどりみち 戻り道"
"もなか 最中"
"もにたーちょうさ モニター調査"
"もにみあか モニミア科"
"もにわ 茂庭"
"もぬけ 蛻"
"もぬけのから 蛻の殻 蛻けの殻"
"もぬし 喪主"
"もの 者 物"
"ものいい 物言い"
"ものいみ 物忌み"
"ものいれ 物入"
"ものう 物憂"
"ものうい 懶い 物憂い"
"ものうげ 物憂げ"
"ものうち 物打"
"ものうらやみ 物羨み"
"ものお 桃生"
"ものおき 物置"
"ものおじ 物怖 物怖じ"
"ものおぢ 物怖"
"ものおと 物音"
"ものかげ 物影 物陰"
"ものかず 物数"
"ものがたり 物語"
"ものぎわ 物際"
"ものぐさ 物臭 物種 懶"
"ものごい 物乞 物乞い"
"ものごころ 物心"
"ものごし 物腰"
"ものごと 物事"
"ものさし 物指し 物指 物差し"
"ものしり 物識り 物知り"
"ものずき 物好き"
"ものたち 者達"
"ものたりない 物足りない"
"ものだね 物種"
"ものども 者共"
"もののあわれ 物の哀れ"
"もののかず 物の数"
"もののけ 物怪 物の怪"
"もののじょうず 物の上手"
"もののな 物の名 物名"
"もののはずみ 物の弾み"
"もののふ 武士"
"もののべ 物部"
"もののほん 物の本"
"もののみごと 物の見事"
"ものび 物日"
"ものべ 物部"
"ものほし 物干"
"ものほしざお 物干し竿"
"ものまえ 物前"
"ものまね 物まね"
"ものみ 物見"
"ものみやぐら 物見櫓"
"ものもち 物持"
"ものもらい 物貰い"
"ものわかり 物分かり 物分り"
"もはや 最早"
"もはら 茂原"
"もはん 模範"
"もはんしゅう 模範囚"
"もばら 茂原"
"もひかんあたま モヒカン頭"
"もひかんがり モヒカン刈り"
"もふく 喪服"
"もほう 模倣"
"もほん 模本"
"もみ 紅絹 樅 籾"
"もみあい 揉み合い"
"もみあげ 揉み上げ"
"もみあらい 揉み洗い"
"もみい 籾井"
"もみかわ 揉み革"
"もみがら 籾殻"
"もみくちゃ 揉みくちゃ"
"もみけし もみ消し 揉み消し"
"もみごめ 籾米"
"もみじ 椛 楓 紅葉"
"もみじがり 紅葉狩 紅葉狩り"
"もみじのが 紅葉賀"
"もみじみ 紅葉見"
"もみすり 籾摺り"
"もみぞく モミ属"
"もみぞめ 紅染"
"もみだね 籾種"
"もみて 揉み手"
"もみで 揉み手"
"もみぬか 籾糠"
"もみよね 籾米"
"もめ 揉め"
"もめごと 揉事"
"もめん 木綿"
"もめんいと 木綿糸"
"もめんばり 木綿針"
"もも 百 腿 股 桃"
"ももい 桃井"
"ももいし 百石"
"ももいろ 桃色"
"ももうち 桃内"
"ももえ 百枝 百恵"
"ももか 百夏 百日"
"ももかがり 百篝"
"ももかわ 桃川 百川 桃皮 楊梅皮"
"ももかん 桃缶"
"ももき 百木"
"ももくりさんねん 桃栗三年"
"ももこ 桃子"
"ももさき 桃崎"
"ももざき 百崎"
"ももじり 桃尻"
"ももじりむすめ 桃尻娘"
"ももせ 百瀬"
"ももぞの 桃園"
"ももた 百田"
"ももたび 百度"
"ももたろう 桃太郎"
"ももたろうざむらい 桃太郎侍"
"ももだち 股立"
"ももだに 桃谷"
"ももち 百千"
"ももちどり 百千鳥"
"ももとせ 百歳"
"ももとり 百鳥"
"ももにく 腿肉 モモ肉 もも肉"
"もものき 桃の木"
"もものせっく 桃の節句"
"ももひき 股引"
"ももひめ 桃姫"
"ももみみ 桃耳"
"ももむら 百村"
"ももや 桃屋"
"ももやま 桃山"
"ももよ 百夜 百代"
"ももわれ 桃割れ"
"もや 靄 母屋"
"もやいづな 舫い綱"
"もやし 萌やし"
"もやもやびょう もやもや病"
"もよい 催い"
"もよう 模様"
"もようあみ 模様編み"
"もようがえ 模様替 模様替え"
"もよおし 催し"
"もよおしじょう 催場"
"もよおしもの 催物"
"もより 最寄 最寄り"
"もらいご 貰い子"
"もらいじこ 貰い事故"
"もらいて もらい手 貰い手"
"もらいなき 貰い泣き"
"もらいなみだ 貰い涙"
"もらいび 貰い火"
"もらいもの 貰い物"
"もらいゆ 貰い湯"
"もり 盛り 漏り 守り 護 盛 萌梨 守 銛 杜 森"
"もりあい 盛合"
"もりあき 守章"
"もりあわせ 盛り合せ 盛合せ"
"もりい 森井"
"もりいで 森出"
"もりうち 森内"
"もりえだ 森枝"
"もりお 森男 森生 守夫 盛雄 杜夫 盛夫 守男 森尾"
"もりおうがい 森鴎外"
"もりおか 森丘 守岡 森岡 盛岡"
"もりかげ 森景 森陰"
"もりかず 盛和"
"もりかわ 守川 森河 森川"
"もりがき 森垣"
"もりがし 盛菓子"
"もりき 守木"
"もりきた 森北"
"もりきよ 森清"
"もりきり 盛切り"
"もりくち 森口"
"もりくら 森蔵"
"もりぐち 守口 森口"
"もりけい 森景"
"もりさき 森崎"
"もりさだ 森定"
"もりさと 森里"
"もりさわ 森沢"
"もりざら 盛皿"
"もりしげ 護重 森重"
"もりした 森下"
"もりしま 森嶋 森島"
"もりしんいち 森進一"
"もりじお 盛塩 盛り塩"
"もりじり 森尻"
"もりすえ 森末"
"もりすみ 森住"
"もりずな 盛砂"
"もりせ 森瀬"
"もりそば 盛蕎麦"
"もりぞう 森蔵"
"もりぞの 森園"
"もりた 守田 盛田 森田"
"もりたか 森高"
"もりたに 守谷 森谷"
"もりだくさん 盛沢山 盛り沢山"
"もりちょう 森町"
"もりつ 森津"
"もりつか 杜塚"
"もりつぐ 森嗣"
"もりつち 盛り土 盛土"
"もりてん 森店"
"もりと 森戸"
"もりとう 森藤"
"もりとお 盛遠"
"もりとし 守利"
"もりとも 守友"
"もりなが 森永"
"もりの 森野"
"もりのさと 森の里"
"もりのせいかつ 森の生活"
"もりのぶ 森信"
"もりのみや 森の宮"
"もりばち 盛り鉢 盛鉢"
"もりばな 盛り花 盛花"
"もりばん 森番"
"もりひこ 守彦"
"もりひろ 護煕 守弘"
"もりびと 守人"
"もりぶでんこう モリブデン鋼"
"もりべ 森部 守部"
"もりまつ 森松"
"もりまり 森茉莉"
"もりみち 守倫 守通"
"もりみつ 森光"
"もりむら 森村"
"もりもと 盛本 守本 森本"
"もりもの 盛物"
"もりや 森屋 森谷 守谷 守屋"
"もりやく 守役"
"もりやす 森保 森安 守安"
"もりやま 守山 森山"
"もりゆき 森雪"
"もりよし 守克 森吉"
"もりらんまる 森蘭丸"
"もりわか 森若"
"もりわき 森脇"
"もりわけ 守分"
"もりん 茂林"
"もるもんきょう モルモン教"
"もれ 洩れ 漏れ"
"もれなく 漏れなく 漏れ無く"
"もろ 師 諸"
"もろい 諸井"
"もろえ 諸江"
"もろお 師尾"
"もろおか 師丘 師岡 諸岡"
"もろおや 双親 両親 諸親"
"もろくち 諸口"
"もろこ 諸子"
"もろこし 蜀黍"
"もろこしぶみ 唐土書"
"もろこしもじ 唐土文字"
"もろごい 諸恋"
"もろごえ 諸声"
"もろさと 諸里"
"もろざし 双差し 両差し"
"もろずみ 双墨 諸角 両角"
"もろた 茂呂田 諸田"
"もろつか 諸塚"
"もろて 双手 諸手"
"もろとも 諸共"
"もろどみ 諸富"
"もろは 両刃 諸刃"
"もろはし 師橋 諸橋"
"もろはだ 諸肌"
"もろはのつるぎ 諸刃の剣"
"もろば 両刃"
"もろひざ 諸膝"
"もろびと 諸人"
"もろびん 諸鬢"
"もろほし 諸星"
"もろぼし 諸星"
"もろみ 諸味 醪"
"もろむき 双向き 諸向き"
"もろもろ 諸諸 諸 諸々"
"もろや 諸矢"
"もろやま 毛呂山"
"もん 者 物 捫 聞 悶 文 紋 問 門"
"もんえい 門衛"
"もんおり 紋織"
"もんか 門下"
"もんかく 門客"
"もんかしょう 文科相 文科省"
"もんかじちゅう 門下侍中"
"もんかじろう 門下侍郎"
"もんかん 門鑑 文観"
"もんかんばん 紋看板"
"もんがい 門外"
"もんがいかん 門外漢"
"もんがく 文覚"
"もんがた 門型"
"もんがまえ 門構え"
"もんきり 紋切 紋切り"
"もんく 文句"
"もんくなし 文句無"
"もんげん 門限"
"もんこ 門戸"
"もんこく 旺角"
"もんごるご モンゴル語"
"もんごるじん モンゴル人"
"もんごるすもう モンゴル相撲"
"もんごるずもう モンゴル相撲"
"もんごん 文言"
"もんさつ 門札"
"もんざい 問罪"
"もんし 門歯 悶死"
"もんしゅ 門主"
"もんしょう 紋章"
"もんしろちょう 紋白蝶"
"もんしん 問診"
"もんじ 文字"
"もんじゃやき もんじゃ焼 もんじゃ焼き"
"もんじゅ 文珠 文殊"
"もんじょ 文書"
"もんじょう 文章"
"もんじょぶくろ 文書袋"
"もんじん 問訊 門人"
"もんせい 門生"
"もんせき 問責"
"もんせん 門扇"
"もんぜき 門跡"
"もんぜつ 悶絶"
"もんぜん 問禅 文選 門前"
"もんだい 問題"
"もんだいあり 問題有"
"もんだいなし 問題無"
"もんち 門地"
"もんちゃく 悶着"
"もんちゅう 問注 問中 門柱"
"もんちょう 紋帳"
"もんつき 紋付"
"もんつきはかま 紋付袴"
"もんてい 門弟"
"もんてかるろほう モンテカルロ法"
"もんでん 門田"
"もんと 門徒"
"もんとう 門灯"
"もんとくじつろく 文徳実録"
"もんとくてんのう 文徳天皇"
"もんど 門戸 主水"
"もんどう 問答"
"もんどころ 紋所"
"もんどり 翻筋斗"
"もんな 門奈"
"もんない 門内"
"もんなし 文無し"
"もんの 門野"
"もんはぶたえ 紋羽二重"
"もんばつ 門閥"
"もんばやし 門林"
"もんばん 門番"
"もんぱ 門派"
"もんび 紋日"
"もんぴ 門扉"
"もんぴょう 門標"
"もんぶ 文部"
"もんぷく 紋服"
"もんべつ 紋別 門別"
"もんぼうしょ 紋奉書"
"もんま 門馬 門真"
"もんみゃく 門脈"
"もんむてんのう 文武天皇"
"もんめ 問目 匁"
"もんもう 文盲"
"もんもん 悶悶 悶々"
"もんよう 紋様 文様"
"もんりゅう 門柳"
"もんろーしゅぎ モンロー主義"
"や ⇔ ⇒ ← → ↓ ↑ 爺 椰 揶 耶 埜 笶 谷 八 冶 彌 弥 輻 哉 也 野 夜 家 屋 矢"
"やー Я"
"やーど 碼"
"やーどぽんどほう ヤードポンド法"
"やいごめ 焼米"
"やいた 矢板"
"やいだ 矢井田"
"やいづ 焼津"
"やいと 灸"
"やいば 刃"
"やいん 夜陰"
"やうち 矢内 家内"
"やえ 八重"
"やえい 夜営 野営"
"やえいずみ 八重泉"
"やえがき 八重垣"
"やえがし 八重樫"
"やえがすみ 八重霞"
"やえこ 彌生子 八重子"
"やえざくら 八重桜"
"やえす 八重洲"
"やえば 八重歯"
"やえむぐら 八重葎"
"やえん 夜宴 野猿"
"やお 矢尾 八百 八尾"
"やおい 矢追"
"やおいた 矢尾板"
"やおき 八起"
"やおぎ 八尾木"
"やおくめ 八百粂"
"やおつ 八百津"
"やおとめ 八乙女"
"やおはら 八百原"
"やおもて 矢面"
"やおよろず 八百万"
"やおよろずのかみ 八百万の神"
"やおら 徐ら"
"やおん 野音"
"やか 八日 夜火 野花 野火 宅"
"やかい 夜会"
"やかく 夜鶴 野鶴"
"やかけちょう 矢掛町"
"やかげ 矢掛"
"やかず 矢数 家数"
"やかぜ 矢風"
"やかた 舘 屋形 館"
"やかたぶね 屋形舟 屋形船"
"やかべ 家部 宅部"
"やかもち 家持"
"やから 族 輩"
"やかん 薬鑵 薬罐 野干 薬缶 夜間"
"やが 屋我"
"やがい 屋外 野外"
"やがく 夜学"
"やがけ 矢掛"
"やがすり 矢絣"
"やがっこう 夜学校"
"やがて 軅 軈 軈て"
"やがみ 矢上 八神"
"やがも 矢鴨"
"やがわ 矢川"
"やがわら 谷川原"
"やき 燒 八寸 焼 焼き 夜気"
"やきあみ 焼網 焼き網"
"やきいも 焼芋 焼き芋"
"やきいれ 焼入れ"
"やきいん 焼印"
"やきうち 焼討ち 焼き討ち"
"やきうどん 焼うどん"
"やきえ 焼絵"
"やきがし 焼菓子"
"やきぎょうざ 焼餃子"
"やきぐし 焼串 焼き串"
"やきぐり 燒栗 焼き栗"
"やきこ 焼粉"
"やきごて 焼鏝 焼き鏝"
"やきざかな 焼魚 焼き魚"
"やきしお 焼塩 焼き塩"
"やきしめ 焼締め"
"やきじゃけ 焼き鮭"
"やきすぎ 焼き杉 焼杉"
"やきず 矢傷"
"やきそば 焼そば 焼きそば"
"やきつけ 焼付け 焼付"
"やきつち 焼土 焼き土"
"やきとり 焼鳥 焼き鳥"
"やきどうふ 焼豆腐"
"やきなおし 焼直し"
"やきなまし 焼鈍し 焼き鈍し"
"やきにく 焼肉 焼き肉"
"やきはた 焼き畑 焼畑"
"やきはまぐり 焼蛤 焼き蛤"
"やきば 焼刃 焼場 焼き刃"
"やきびーふん 焼ビーフン"
"やきびたい 焼額"
"やきふ 焼麩"
"やきぶた 焼き豚 焼豚"
"やきまし 焼増 焼増し 焼き増し"
"やきみそ 焼味噌"
"やきみょうばん 焼明礬"
"やきめ 焼目"
"やきめし 焼飯 焼き飯"
"やきもち 焼餅 焼き餅"
"やきもどし 焼き戻し 焼戻し"
"やきもの 焼物"
"やきやぶり 焼き破り"
"やきゅう 野球"
"やきゅうずき 野球好き"
"やきょうしょう 夜驚症"
"やきょく 夜曲"
"やきりんご 焼林檎 焼きリンゴ"
"やきん 野禽 冶金 夜勤"
"やぎ 柳 八木 山羊"
"やぎさわ 八木沢"
"やぎた 八木田"
"やぎぬま 八木沼"
"やぎはし 八木橋"
"やぎぶし 八木節"
"やぎゅう 野牛 柳生"
"やぎょう や行 ヤ行 夜業 夜行"
"やぎり 矢切"
"やく ≒ 檪 焼 藥 譯 繹 蜴 扼 益 躍 疫 鑰 籥 龠 夜久 屋久 葯 厄 薬 訳 役 約"
"やくあり 訳有"
"やくい 薬医"
"やくいん 約因 役印 薬院 役員"
"やくえき 薬液"
"やくえん 薬園"
"やくおとし 厄落し 厄落とし"
"やくおん 約音"
"やくかい 訳解"
"やくがい 薬害"
"やくがえ 役替え"
"やくがく 薬学"
"やくがら 役柄"
"やくぎ 訳義 役儀"
"やくぎょう 訳業"
"やくぎょうじほうしゃ 薬業時報社"
"やくげん 約言"
"やくこう 訳稿"
"やくご 訳語"
"やくごめん 役御免"
"やくさい 薬菜 訳載 厄災"
"やくさつ 扼殺 薬殺"
"やくざい 薬剤"
"やくざもの ヤクザ者 やくざ者"
"やくし 薬司 訳詩 訳詞 薬師"
"やくしつ 薬室"
"やくしま 屋久島"
"やくしゃ 訳者 役者"
"やくしゅ 薬種 薬酒"
"やくしゅつ 訳出"
"やくしょ 訳書 役所"
"やくしょく 役職"
"やくしん 薬疹 躍進"
"やくじ 薬餌 薬事"
"やくじゅつ 訳述"
"やくじょ 躍如"
"やくじょう 約定"
"やくじん 疫神 厄神"
"やくすう 約数"
"やくすぎ 屋久杉"
"やくずもう 役相撲"
"やくせき 薬石"
"やくぜん 薬膳"
"やくそう 役僧 躍層 薬草"
"やくそく 約束"
"やくたい 益体 薬袋"
"やくたく 役宅"
"やくたたず 役立たず"
"やくだい 薬代"
"やくだく 約諾"
"やくちゅう 薬中 訳註 訳注"
"やくづき 役付き 役付"
"やくづくり 役作り"
"やくて 約手"
"やくてい 約定"
"やくてん 約転 薬店"
"やくとう 薬湯"
"やくとく 役得"
"やくどう 躍動"
"やくどく 役得 薬毒 訳読"
"やくどころ 役所"
"やくどし 厄年"
"やくなし 訳無"
"やくなん 厄難"
"やくにん 役人"
"やくの 夜久野"
"やくはらい 厄払い"
"やくば 役場"
"やくばらい 厄払い"
"やくひつ 訳筆"
"やくひん 薬品"
"やくび 厄日"
"やくびょう 疫病"
"やくびょうがみ 厄病神 疫病神"
"やくぶそく 役不足"
"やくぶつ 薬物"
"やくぶん 約分 訳文"
"やくへん 訳編"
"やくほう 薬包 薬方"
"やくほん 訳本"
"やくぼ 矢久保"
"やくまる 薬丸"
"やくまわり 役回り"
"やくまん 役満"
"やくみ 薬味"
"やくむき 役向き"
"やくめ 役目"
"やくめい 役名"
"やくも 八雲"
"やくもの 約物 役物"
"やくゆ 薬湯"
"やくよう 薬用"
"やくよけ 厄除 厄除け"
"やくり 薬理"
"やくりきし 役力士"
"やくりょう 薬料"
"やくれい 訳例"
"やくれき 薬歴"
"やくろう 薬籠"
"やくろん 約論"
"やくわり 役割"
"やくわん 扼腕"
"やぐ 夜具"
"やぐち 谷口 矢口"
"やぐちのわたし 矢口渡"
"やぐら 矢倉 櫓"
"やぐらだいこ 櫓太鼓"
"やぐらなげ 櫓投げ"
"やぐらもん 櫓門"
"やぐるま 矢車"
"やぐるまぎく 矢車菊"
"やぐるまそう 矢車草"
"やけ 焼け 自棄"
"やけあと 焼跡"
"やけい 野鶏 夜警 夜景"
"やけいし 焼け石"
"やけくそ 自棄糞"
"やけざけ ヤケ酒 やけ酒"
"やけだけ 焼岳"
"やけだされ 焼け出され"
"やけっぱち 自棄っぱち"
"やけど 火傷"
"やけの 焼野"
"やけのはら 焼野原"
"やけびたい 焼額"
"やけぶとり 焼け太り"
"やけぼっくい 焼けぼっくい 焼け棒杭"
"やけやま 焼山"
"やけん 野犬"
"やげん 薬研"
"やげんぼり 薬研堀"
"やこ 野狐"
"やこう 八高 夜香 矢向 夜光 夜行"
"やこうちゅう 夜行虫 夜光虫"
"やこうのはい 夜光の杯"
"やこうばす 夜行バス"
"やこぜん 野狐禅"
"やこびぎょうれつ ヤコビ行列"
"やこぶびょう ヤコブ病"
"やご 野語"
"やごう 野合 屋号"
"やごえ 矢声"
"やごし 矢越"
"やごと 八事"
"やさい 野菜"
"やさいくず 野菜屑"
"やさいさらだ 野菜サラダ"
"やさいじゅーす 野菜ジュース"
"やさいすーぷ 野菜スープ"
"やさいぞえ 野菜添え"
"やさいばたけ 野菜畑"
"やさおとこ 優男"
"やさか 八尺 弥栄 八坂"
"やさかに 八尺瓊"
"やさかりゅう 屋坂流"
"やさがし 家捜し"
"やさがた 優形"
"やさき 矢先"
"やさく 矢作"
"やさすがた 優姿"
"やさと 八郷"
"やざ 矢座"
"やざき 矢崎"
"やざわ 谷沢 矢澤 矢沢"
"やし 野師 弥四 野史 椰 香具師 椰子"
"やしお 八入 八潮"
"やしか ヤシ科"
"やしがに 椰子蟹"
"やしき 矢輔 壥 屋輔 廛 邸 屋敷"
"やしきうち 屋敷内"
"やしち 弥七"
"やしないおや 養い親"
"やしのみ 椰子の実"
"やしま 矢島 八洲 屋島 八島"
"やしまくに 八洲国"
"やしまでら 屋島寺"
"やしもく ヤシ目"
"やしゃ 夜叉"
"やしゃご 玄孫"
"やしゅ 野趣 野手"
"やしゅう 野州 夜襲"
"やしょく 夜色 夜食"
"やしろ 安城 矢代 屋代 八代 社"
"やしわご 玄孫"
"やしん 野心"
"やじ 弥次 野次"
"やじうま 弥次馬 野次馬"
"やじうまてききょうみ 野次馬的興味"
"やじま 谷島 八島 矢嶋 矢島"
"やじゅう 野獣"
"やじゅうは 野獸派"
"やじり 矢尻 鏃"
"やじるし ⇔ ⇒ ← → ↓ ↑ 矢印"
"やじるしきー 矢印キー"
"やじろべい 弥次郎兵衛"
"やじろべえ 弥次郎兵衛"
"やじん 野人"
"やす 恭 靖 裕 泰 康 保 夜須 野洲 安"
"やすあき 恭章 泰昭 保昭 康明"
"やすい 靖 保井 安井"
"やすいけ 安池"
"やすいちろう 靖一郎"
"やすうら 安浦"
"やすうり 安売"
"やすえ 安恵 保江 康恵 安江"
"やすお 弥寿夫 恭朗 保生 裕雄 八洲男 寿男 安男 泰生 保男 泰男 靖雄 康生 安雄 泰夫 保雄 泰雄 保夫 靖夫 康男 康雄 康夫"
"やすおか 泰阜 安岡"
"やすかず 保和 保一 康一"
"やすかた 安方"
"やすかわ 安可愛 安川"
"やすき 易き 康己 靖己 安樹 泰樹"
"やすきよ 安挙"
"やすぎ 八杉 安来"
"やすぎぶし 安来節"
"やすくに 安国 靖国"
"やすけ 弥助"
"やすげ 安げ"
"やすこ 妥子 安子 泰子 恭子 康子 靖子"
"やすさ 安さ"
"やすさだ 保貞"
"やすさと 安里"
"やすざか 安坂"
"やすざけ 安酒"
"やすし 廉史 保司 靖志 泰士 靖史 尉 也寸志 泰司 康史 寧 泰 保 康 靖 安"
"やすしば 安柴"
"やすじ 康嗣 康次 康司 康二"
"やすたか 泰臣 泰宇 泰孝 泰隆 康隆"
"やすたけ 康剛 安武"
"やすたに 保谷"
"やすたみ 康民"
"やすだ 保田 安田"
"やすだきねんば 安田記念馬"
"やすづか 安塚"
"やすて 野ステ"
"やすてつ 康哲"
"やすで 安手"
"やすと 保人 靖人"
"やすとし 康敏 泰稔 康俊"
"やすとみ 安富"
"やすとめ 安留"
"やすとも 康友"
"やすな 保名"
"やすなお 康尚"
"やすなが 保永 康永 安永"
"やすなり 康也 康成"
"やすね 安値"
"やすねびけ 安値引け"
"やすの 安野"
"やすのう 安納"
"やすのぶ 恭伸 保信 泰信"
"やすのり 靖教 保法 安紀 靖則 泰憲 保徳 保憲 保則 康徳 康則 泰則 保典 泰典 安則"
"やすは 泰葉"
"やすはら 保原 安原"
"やすはる 泰晴 泰治 康治 康晴"
"やすひこ 安彦 靖彦 泰彦 康彦"
"やすひさ 靖久 恭久"
"やすひで 保秀"
"やすひと 保人 康仁"
"やすひろ 靖太 保広 保浩 安浩 恭裕 泰寛 靖宏 保博 靖浩 泰広 靖弘 康広 康浩 恭弘 安弘 泰宏 康宏 康裕 康博 泰弘 康弘"
"やすぴか 安ぴか"
"やすふみ 康史 泰史 康文"
"やすぶしん 安普請"
"やすぶみ 康文"
"やすまさ 康雅 康正 泰正"
"やすまつ 安松"
"やすみ 保美 休 休み"
"やすみち 易道"
"やすみぢゃや 休み茶屋"
"やすみつ 康満 康光"
"やすむら 安村"
"やすめ 安め 安目"
"やすもと 安本"
"やすもの 安物"
"やすや 恭也"
"やすやす 易々"
"やすやど 安宿"
"やすゆき 育志 恭之 保之 靖幸 泰幸 康行 康幸 靖之 泰之 康之"
"やすよ 康世 靖代 安代 康代"
"やすよし 靖佳 康善 康良 安吉 康義"
"やすら 安ら 安良"
"やすらい 休らい 安らい"
"やすらか 安らか"
"やすらぎ 安らぎ"
"やすり 鑢"
"やすろう 恭郎 康朗"
"やず 谷津"
"やずぎ 八杉"
"やせ 八瀬"
"やせい 野性 野生"
"やせうで 痩せ腕"
"やせうま 痩せ馬"
"やせおとこ 痩せ男"
"やせおんな 痩せ女"
"やせがた 痩せ形 やせ型"
"やせがまん 痩せ我慢"
"やせぎす 痩せぎす"
"やせぐすり 痩せ薬"
"やせち 痩せ地"
"やせっぽち 痩せっぽち"
"やせつ 夜雪"
"やせん 野選 夜戦 野戦"
"やぜん 夜前"
"やそ 八十 耶蘇"
"やそう 夜走 野草"
"やそうきょく 夜想曲"
"やそかわ 八十川"
"やそしま 八十島"
"やそじ 八十"
"やそすけ 八十助"
"やそよろず 八十万"
"やぞう 弥蔵"
"やた 箭田 矢田 八咫"
"やたい 屋台"
"やたいぼね 屋台骨"
"やたがい 矢田貝"
"やたがらす 八咫鴉 八咫烏"
"やたけび 矢叫び"
"やたて 矢立"
"やたでら 矢田寺"
"やたのかがみ 八咫鏡"
"やたべ 谷田部"
"やたま 矢玉"
"やたら 矢鱈"
"やたろう 弥太郎"
"やだ 矢田"
"やだいく 家大工"
"やだけ 矢竹"
"やだね 矢種"
"やだま 矢弾 矢玉"
"やち 萢 屋地 谷地"
"やちた 谷地田"
"やちだ 谷地田 谷内田"
"やちほ 八千穂"
"やちまた 八衢 八街"
"やちゅう 夜中"
"やちょ 野猪"
"やちょう 夜鳥 野帳 野鳥"
"やちよ 八千代"
"やちん 屋賃 家賃"
"やっか 薬禍 薬価 薬科"
"やっかい 訳解 厄介"
"やっかん 約款"
"やっき 躍起"
"やっきょう 薬莢"
"やっきょく 薬局"
"やっきょくほう 薬局方"
"やっこ 奴"
"やっこう 薬効"
"やっこそうか ヤッコソウ科"
"やっこそうもく ヤッコソウ目"
"やっこどうふ 奴豆腐"
"やっつ 八つ"
"やっつけしごと 遣っ付け仕事"
"やっと 漸と"
"やっとこ 鋏"
"やっぱり 矢つ張り"
"やつ 谷津 八 八つ 谷 奴"
"やつお 八尾"
"やつか 八束"
"やつかほ 八束穂"
"やつがしら 八頭"
"やつがたけ 八ヶ岳"
"やつがだけ 八岳 八ヶ岳"
"やつがれ 僕"
"やつぎ 矢継"
"やつぎばや 矢継ぎ早"
"やつくち 八口"
"やつざき 八つ裂き"
"やつしろ 八代"
"やつだ 谷津田"
"やつだま 八玉"
"やつで 八手"
"やつはし 八ツ橋 八つ橋 八橋"
"やつばら 奴原"
"やつめうなぎ 八目鰻"
"やつもり 八ッ森"
"やつら 奴ら 奴等"
"やづくり 家作り"
"やづつ 矢筒"
"やてん 夜天"
"やと 野兎"
"やとい 雇"
"やといにん 雇い人 雇人"
"やといぬし 雇主 雇い主"
"やとう 夜盗 野盗 野党"
"やとうむし 夜盗虫"
"やとみ 弥富"
"やとわれ 雇われ"
"やど 宿"
"やどいり 宿入り"
"やどかり 寄居蟲 寄居虫 宿借り"
"やどがえ 宿替え"
"やどさがり 宿下がり"
"やどじょうほう 宿情報"
"やどせん 宿銭"
"やどだい 宿代"
"やどちょう 宿帳"
"やどちん 宿賃"
"やどなし 宿無し"
"やどぬし 宿主"
"やどひき 宿引き"
"やどや 宿屋"
"やどりき 宿木"
"やどりぎ 寄生木 宿木 宿り木"
"やどろく 宿六"
"やどわり 宿割り"
"やな 梁 簗"
"やない 箭内 矢内 屋内 柳井"
"やないづ 柳津"
"やないはら 矢内原"
"やないば 柳葉"
"やなお 柳尾"
"やなか 谷中"
"やながわ 梁川 柳川"
"やながわなべ 柳川鍋"
"やなぎ 柳"
"やなぎいろ 柳色"
"やなぎごし 柳腰"
"やなぎさわ 柳澤 柳沢"
"やなぎしま 柳島"
"やなぎた 柳田"
"やなぎたに 柳谷"
"やなぎだ 柳田"
"やなぎだる 柳樽 柳多留"
"やなぎちょう 柳町"
"やなぎはら 柳原"
"やなぎば 柳刃 柳葉"
"やなぎばし 柳橋"
"やなぎぼり 柳堀"
"やなぎまち 柳町"
"やなぎもく ヤナギ目"
"やなぎもと 柳本"
"やなぎや 柳谷 柳家"
"やなざき 柳崎"
"やなせ 梁瀬 柳瀬"
"やなだ 梁田"
"やなだに 柳谷"
"やなつ 柳津"
"やなとり 梁取"
"やなはら 柵原"
"やなば 簗塲"
"やなみ 八並 家並 家並み"
"やなり 家鳴り"
"やなる 矢鳴"
"やに 脂"
"やにょうしょう 夜尿症"
"やにわ 矢庭 矢場"
"やにわに 矢庭に"
"やぬし 家主"
"やね 屋根"
"やねいた 屋根板"
"やねうま 屋根馬"
"やねづけ 屋根付"
"やねゆき 屋根雪"
"やの 矢野"
"やのくら 矢野倉"
"やのはら 矢箆原"
"やはぎ 八萩 矢矧 矢作"
"やはく 夜泊"
"やはず 矢筈"
"やはた 八幡"
"やはたにし 八幡西"
"やはたの 八幡野"
"やはたひがし 八幡東"
"やはば 矢巾"
"やはり 矢張り"
"やはん 夜半"
"やはんらく 夜半楽"
"やば 野馬 矢場"
"やばい 野梅"
"やばけい 耶馬渓"
"やばせ 矢橋"
"やばとん 矢場とん"
"やばね 矢羽根 矢羽"
"やばん 野蛮"
"やひ 野鄙 野卑"
"やひこ 弥彦"
"やひこざわ 矢彦沢"
"やひろ 八尋"
"やぶ 薮 藪"
"やぶいり 藪入り"
"やぶうち 薮内"
"やぶか 薮蚊"
"やぶからぼう 薮から棒"
"やぶがみ 薮上"
"やぶき 矢吹"
"やぶきた 藪北"
"やぶさか 吝か"
"やぶさめ 薮鮫 薮雨 流鏑馬"
"やぶさわ 薮沢"
"やぶすま 矢衾"
"やぶそば 薮蕎麦"
"やぶた 藪田"
"やぶだたみ 藪畳"
"やぶにらみ 藪睨み"
"やぶのなか 藪の中"
"やぶはら 薮原"
"やぶへび 薮蛇"
"やぶみ 矢文"
"やぶもと 藪本 薮本"
"やぶれかぶれ 破れかぶれ"
"やぶれしょうじ 破れ障子"
"やぶれめ 破れ目"
"やぶん 夜分"
"やべ 矢部"
"やほ 屋舗 谷保"
"やほう 野砲"
"やほうず 野放図"
"やほこ 八穂子"
"やほち 夜発"
"やほり 矢堀"
"やぼ 野暮"
"やぼう 野望"
"やぼてん 野暮天"
"やぼよう ヤボ用"
"やま 岾 夜摩 夜魔 耶麻 山"
"やまあい 山合 山間"
"やまあし 山足"
"やまあそび 山遊び"
"やまあらし 山嵐"
"やまあるき 山歩き"
"やまい 山井 病"
"やまいこうこう 病膏肓"
"やまいし 山石"
"やまいち 山一證券"
"やまいちしょうけん 山一證券"
"やまいぬ 病犬 犲 豺 山犬"
"やまいも 薯蕷 山芋"
"やまいもあめ 山芋飴"
"やまうち 山内"
"やまうば 山姥"
"やまうら 山浦"
"やまえ 山江"
"やまお 山尾"
"やまおか 山岡"
"やまおかてっしゅう 山岡鉄舟"
"やまおき 山沖"
"やまおく 山奥"
"やまおとこ 山男"
"やまおり 山折り"
"やまおんな 山女"
"やまかい 山峡"
"やまかけ 山掛け"
"やまかげ 山影 山陰"
"やまかさ 山笠"
"やまかじ 山火事"
"やまかぜ 山風"
"やまかっこ 》 《 〉 〈 山括弧"
"やまかみ 山上"
"やまかわ 山川"
"やまかん 山勘"
"やまかんむり 山冠"
"やまが 山賀 山香 山家 山鹿"
"やまがさ 山笠"
"やまがた 山型 山縣 山方 山県 山形"
"やまがたきた 山形北"
"やまがたな 山刀"
"やまがたひがし 山形東"
"やまがち 山勝ち"
"やまがっこ 》 《 〉 〈 山括弧"
"やまがつ 山賤"
"やまがみ 山神 山上"
"やまがら 山雀"
"やまがり 山狩 山狩り"
"やまがわ 山側 山川"
"やまき 八槙 八槇 山気 八巻 山木"
"やまきた 山北"
"やまぎし 山岸"
"やまぎり 山霧"
"やまぎわ 山極 山際"
"やまぎん 山吟"
"やまくさ 山草"
"やまくずれ 山崩れ"
"やまくに 山国"
"やまくら 山倉"
"やまぐち 山口"
"やまぐに 山国"
"やまぐま 山隈"
"やまぐも 山雲"
"やまぐるまか ヤマグルマ科"
"やまけ 山気"
"やまけい 山渓"
"やまこう 山交"
"やまこし 山腰 山古志 山越"
"やまことば 山言葉"
"やまごえ 山越え"
"やまごし 山越し"
"やまごぼう 山牛蒡"
"やまごもり 山籠り"
"やまごや 山小屋"
"やまさ 山佐"
"やまさか 山坂"
"やまさき 山崎"
"やまさち 山幸"
"やまさわ 山沢"
"やまざき 山咲 山崎"
"やまざくら 山桜"
"やまざと 山里"
"やまざる 山猿"
"やまし 山師"
"やましぎ 山鷸"
"やましごと 山仕事"
"やました 山下"
"やましな 山科"
"やましなのみや 山階宮"
"やましろ 山城"
"やましろおんせん 山代温泉"
"やましろや 山代屋"
"やまじ 山路 山地"
"やまじろ 山城"
"やますげ 山菅"
"やますそ 山裾"
"やまずい 山瑞"
"やまずみ 山積"
"やませ 山瀬 山背"
"やまぜん 山善"
"やまそだち 山育ち"
"やまそと 山外"
"やまそわ 山岨"
"やまぞい 山沿い"
"やまぞえ 山添"
"やまたい 耶馬台"
"やまたいこく 邪馬臺國 邪馬臺国 邪馬台国"
"やまたか 山高"
"やまたけ 山武"
"やまたけはねうぇる 山武ハネウェル"
"やまたに 山谷"
"やまたねさんぎょう 山種産業"
"やまたねしょうけん 山種証券"
"やまたのおろち 八俣の大蛇 八岐の大蛇 八岐大蛇"
"やまだ 山田"
"やまだい 山台 山大"
"やまだいすず 山田五十鈴"
"やまだし 山出し"
"やまだにしき 山田錦"
"やまちく 山蓄"
"やまっけ 山っ気"
"やまつか 山塚"
"やまつり 矢祭"
"やまづみ 山積み"
"やまづら 山面"
"やまて 山手"
"やまてら 山寺"
"やまてん 夜摩天"
"やまでら 山寺"
"やまでん 山電"
"やまと 山門 大和"
"やまといも 大和芋"
"やまとうんゆ ヤマト運輸"
"やまとえ 倭絵"
"やまとがく 大和楽"
"やまとぐさもく ヤマトグサ目"
"やまとぐら 大和鞍"
"やまとたける 日本武尊"
"やまとだましい 大和魂"
"やまとみ 山富"
"やまどめ 山止め"
"やまどり 山鳥"
"やまな 山名"
"やまなか 山中"
"やまなかこ 山中湖"
"やまなかごえ 山中越"
"やまなかぶし 山中節"
"やまなし 山梨"
"やまなみ 山並 山並み"
"やまなり 山鳴り 山形"
"やまにし 山西"
"やまね 山根"
"やまねこ 山猫"
"やまの 山野"
"やまのいも 山芋 薯蕷 山の芋"
"やまのうえ 山上"
"やまのうち 山之内 山ノ内 山内"
"やまのかみ 山之上 山の神"
"やまのくち 山之口"
"やまのさち 山の幸"
"やまのて 山の手 山手"
"やまのは 山の端"
"やまのぼり 山登り"
"やまは 山葉"
"やまはい 山廃"
"やまはた 山畑"
"やまはだ 山肌"
"やまははつどうき ヤマハ発動機"
"やまはら 山原"
"やまば ヤマ場 山場"
"やまばと 山鳩"
"やまひだ 山襞"
"やまび 山火 山日"
"やまびこ 谺 山彦"
"やまびと 山人"
"やまびらき 山開き"
"やまふじ 山藤"
"やまふだ 山札"
"やまふところ 山懐"
"やまぶき 山蕗 山吹"
"やまぶし 山伏"
"やまぶち 山淵"
"やまぶどう 山葡萄"
"やまへん 山偏"
"やまべ 山辺 山部"
"やまほうし 山法師"
"やまほこじゅんこう 山鉾巡行"
"やまほど 山程"
"やまぼこ 山鉾"
"やままつ 山松"
"やままつり 山祭り 山祭"
"やままゆ 山繭 天蚕"
"やままん 山万"
"やまみ 山見"
"やまみち 山道"
"やまむら 山村"
"やまむろ 山室"
"やまめ 山女魚 山女"
"やまもがしもく ヤマモガシ目"
"やまもと 山元 山本"
"やまもといそろく 山本五十六"
"やまもとひろし 山本弘"
"やまもとゆうぞう 山本有三"
"やまもも 楊梅 山桃"
"やまもももく ヤマモモ目"
"やまもり 山森 山守 山盛り"
"やまや 山矢 山屋 山家"
"やまやき 山焼き"
"やまやしき 山屋敷"
"やまやま 山々"
"やまゆき 山雪 山行"
"やまゆり 山百合"
"やまよう 山用"
"やまわき 山脇"
"やまわけ 山分け"
"やまんば 山姥"
"やみ 闇"
"やみあがり 病み上がり"
"やみいち 闇市"
"やみうち 闇討 闇討ち"
"やみきん 闇金"
"やみくも 闇雲"
"やみごめ 闇米"
"やみじ 闇路"
"やみじる 闇汁"
"やみつき 病み付き"
"やみなべ 闇鍋"
"やみね 闇値"
"やみもり 闇森"
"やみや 闇屋"
"やみよ 闇夜"
"やみるーと 闇ルート"
"やむいも ヤム芋"
"やむちゃ 飲茶"
"やむをえず 止むを得ず"
"やめ 已め 矢目 八女 止め"
"やもうしょう 夜盲症"
"やもお 寡男 鰥"
"やもと 矢本"
"やもめ 鰥夫 鰥 孀 寡"
"やもり 夜森 守宮"
"やや 稚 漸 稍"
"ややおも 稍重"
"ややこ 稚児"
"やゆ 揶揄"
"やよい 弥生"
"やよいしきどき 弥生式土器"
"やら 屋良"
"やらい 夜来 矢来"
"やらずのあめ 遣らずの雨"
"やり 矢理 遣り 鑓 鎗 槍"
"やりいか 槍烏賊"
"やりかた やり方"
"やりがい やり甲斐"
"やりがたけ 鑓ヶ岳 槍ヶ岳"
"やりがだけ 槍岳"
"やりきへい 槍騎兵"
"やりくち 遣口 やり口"
"やりごたえ やり応え"
"やりさき 槍先"
"やりしき やり式"
"やりた 鎗田"
"やりだま やり玉 槍玉"
"やりて やり手"
"やりてばば 遣り手婆"
"やりとり やり取り"
"やりなげ 槍投げ"
"やりば やり場"
"やりぶすま 槍衾"
"やりみず 遣り水 鑓水"
"やりもち 槍持"
"やりよう やり様"
"やるかた 遣る方"
"やるき 遣る気 ヤル気 やる気"
"やること やる事"
"やるせ 遣る瀬"
"やるせない 遣る瀬ない"
"やるたかいだん ヤルタ会談"
"やれ 破れ"
"やれあな 破れ穴"
"やろう 野郎"
"やろうじだい 夜郎自大"
"やわ 柔 夜話"
"やわた 八幡"
"やわたはま 八幡浜"
"やわはだ 柔肌"
"やわら 谷和原 柔"
"やん 梁 楊"
"やんぐりつ ヤング率"
"やんぬるかな 已んぬる哉"
"やんばる 山原"
"やんばん 両班"
"やんぱん 両班"
"やんべ 山家"
"やんろんちゃ 燕龍茶"
"ゆ 揃 揺 弓 柚 斎 遊 諛 臾 腴 逾 踰 覦 蝓 瑜 渝 楡 揄 喩 兪 輸 諭 瘉 癒 愈 愉 由 油 湯"
"ゆーくりっどきかがく ユークリッド幾何学"
"ゆーくりっどくうかん ユークリッド空間"
"ゆーざーかい ユーザー会"
"ゆーざーしゃけん ユーザー車検"
"ゆーざーとうろく ユーザー登録"
"ゆーざかい ユーザ会"
"ゆーざじしょ ユーザ辞書"
"ゆーざとうろく ユーザ登録"
"ゆーざにんしょう ユーザ認証"
"ゆーざめい ユーザ名"
"ゆーじ Ｕ字"
"ゆーたーん Ｕターン"
"ゆーらしあたいりく ユーラシア大陸"
"ゆーろけん ユーロ圏"
"ゆーろさい ユーロ債"
"ゆーろだか ユーロ高"
"ゆーろやす ユーロ安"
"ゆあか 湯垢"
"ゆあがり 湯上がり 湯上り"
"ゆあさ 湯淺 湯浅"
"ゆあたり 湯中り"
"ゆあつ 油圧"
"ゆあつしょべる 油圧ショベル"
"ゆあつぽんぷ 油圧ポンプ"
"ゆあみ 湯浴み"
"ゆい 由以 湯井 悠衣 油井 由井 由比 由衣 結い 結 遺 由 唯"
"ゆいいち 唯一"
"ゆいいつ 惟一 唯一"
"ゆいいつしん 唯一神"
"ゆいか 結花"
"ゆいが 唯我"
"ゆいがはま 由比ヶ浜"
"ゆいごん 遺言"
"ゆいしき 唯識"
"ゆいしょ 由緒"
"ゆいしょがき 由緒書"
"ゆいしん 唯心"
"ゆいしんろん 唯神論"
"ゆいつ 唯一"
"ゆいな 維那"
"ゆいのう 結納"
"ゆいのうろん 唯脳論"
"ゆいび 唯美"
"ゆいぶつ 唯物"
"ゆいま 維摩"
"ゆいまぎょう 維摩経"
"ゆいめいていぎ 唯名定義"
"ゆいめいろん 唯名論"
"ゆう 右 融 郵 誘 裕 幽 黝 莠 揖 熊 俑 涌 湧 游 蝣 遊 肬 疣 犹 尢 尤 蕕 猷 猶 酉 悒 邑 宥 囿 侑 祐 佑 攸 悠 蚰 釉 柚 由 木綿 由宇 友 有 雄 憂 勇 夕 優"
"ゆうあい 友愛"
"ゆうあかり 夕明り"
"ゆうあく 優渥"
"ゆうあん 幽暗"
"ゆうい 雄偉 有位 有為 有意 優位"
"ゆういち 友一 優一 有一 勇一 祐一 雄一 裕一 夕市"
"ゆういろ 夕色"
"ゆういん 有印 誘因 誘引"
"ゆううつ 幽鬱 憂鬱"
"ゆうえい 游泳 遊泳"
"ゆうえき 有益"
"ゆうえつ 勇悦 優越"
"ゆうえん 結縁 優婉 幽艶 有煙 幽遠 優艶 悠遠 遊宴 有鉛 遊園"
"ゆうおう 勇徃 雄黄"
"ゆうおうまいしん 勇往邁進"
"ゆうか 有価"
"ゆうかい 幽界 有界 融解 誘拐"
"ゆうかく 遊客 遊廓"
"ゆうかげ 夕陰 夕影"
"ゆうかぜ 夕風"
"ゆうかだん 憂歌団"
"ゆうかん 幽間 勇悍 幽閑 遊観 憂患 有感 有閑 勇敢 夕刊"
"ゆうかんまだむ 有閑マダム"
"ゆうが 勇牙 優雅"
"ゆうがい 有蓋 有害"
"ゆうがお 夕顔"
"ゆうがく 遊楽 遊学"
"ゆうがすみ 夕霞"
"ゆうがた 夕方"
"ゆうがとう 誘蛾灯"
"ゆうき 憂喜 優起 有規 有基 有気 雄希 又木 夕希 雄規 祐己 勇喜 雄基 幽鬼 優樹 悠紀 友樹 裕木 夕貴 優希 祐希 裕樹 憂木 夕樹 有希 有紀 結城 有期 誘起 勇気 有機"
"ゆうきち 有吉 勇吉 祐吉"
"ゆうきつむぎ 結城紬"
"ゆうきゃく 遊脚 誘客"
"ゆうきゅう 遊休 有休 悠久 有給"
"ゆうきょ 幽居"
"ゆうきょう 遊侠 遊興"
"ゆうきょく 有棘"
"ゆうきん 游禽 遊金"
"ゆうぎ 友誼 遊技 遊戯"
"ゆうぎょ 遊魚 游魚 勇魚"
"ゆうぎょせん 遊漁船"
"ゆうぎり 夕霧"
"ゆうく 憂苦"
"ゆうぐ 遊具"
"ゆうぐう 優遇"
"ゆうぐも 夕雲"
"ゆうぐれ 夕暮 夕暮れ"
"ゆうぐん 遊軍 友軍"
"ゆうけい 雄勁 夕景 有形"
"ゆうけむり 夕煙"
"ゆうけん 勇健 郵券 有権"
"ゆうげ 夕餉"
"ゆうげい 遊芸"
"ゆうげき 遊撃"
"ゆうげしき 夕景色"
"ゆうげしょう 夕化粧"
"ゆうげん 祐源 幽幻 有言 幽玄 有限"
"ゆうこ 裕有子 木綿子 侑子 由布子 有子 悠子 由子 友子 ゆう子 祐子 夕子 裕子 優子"
"ゆうこう 幽光 裕弘 有向 有孔 有功 遊行 遊興 友好 有効"
"ゆうこうがっき 有簧楽器"
"ゆうこうぎ 有向木"
"ゆうこうちゅう 有孔虫"
"ゆうこく 幽谷 憂国 夕刻"
"ゆうこん 幽魂 雄渾"
"ゆうごう 融合"
"ゆうごはん 夕ご飯 夕御飯"
"ゆうさい 有妻 雄才 幽斎"
"ゆうさく 祐策 裕作 雄作 雄策 勇作 優作"
"ゆうさん 有産"
"ゆうざい 有罪"
"ゆうざん 雄山"
"ゆうざんかく 雄山閣"
"ゆうし 右史 遊資 遊糸 憂思 勇史 猶子 雄視 遊子 有司 有刺 雄志 有史 勇士 雄姿 勇姿 有志 融資"
"ゆうしお 夕潮"
"ゆうしき 有識"
"ゆうしぐれ 夕時雨"
"ゆうしつ 幽室"
"ゆうしつどうぶつ 有櫛動物"
"ゆうしぶんれつ 有糸分裂"
"ゆうしゃ 優者 勇者"
"ゆうしゃく 有爵"
"ゆうしゅ 遊手 郵趣"
"ゆうしゅう 幽愁 幽囚 有終 憂愁 優秀"
"ゆうしゅうきょくしょう 優秀曲賞"
"ゆうしゅうのび 有終の美"
"ゆうしゅつ 誘出 涌出 湧出"
"ゆうしゅん 優駿"
"ゆうしょ 郵書"
"ゆうしょう 湧昇 勇将 優賞 有償 優勝"
"ゆうしょうせーる 優勝セール"
"ゆうしょうば 優勝馬"
"ゆうしょく 憂色 有色 有職 夕食"
"ゆうしん 憂心 雄心 有心 有信"
"ゆうしんぼつぼつ 雄心勃々"
"ゆうしんろん 有神論"
"ゆうじ 祐地 裕慈 雄爾 右二 祐之 祐史 雄士 友二 佑二 雄志 裕志 裕史 祐次 勇次 雄次 勇治 裕治 雄司 勇二 祐治 祐二 祐司 裕司 裕二 雄二 有事"
"ゆうじゃ 雄者"
"ゆうじゃく 幽寂"
"ゆうじゅう 優柔"
"ゆうじょ 佑助 優女 宥恕 遊女"
"ゆうじょう 友情"
"ゆうじろう 悠二郎 裕次郎"
"ゆうじん 遊人 有人 友人"
"ゆうじんとう 有人島"
"ゆうすい 幽邃 有水 湧水"
"ゆうすいち 遊水池"
"ゆうすう 有数"
"ゆうすけ 幽助 有祐 佳祐 勇輔 雄輔 勇介 祐輔 裕介 雄介 祐介"
"ゆうすずみ 夕涼み"
"ゆうずい 雄蕊"
"ゆうずう 融通"
"ゆうずつ 長庚 夕星"
"ゆうせい 有生 幽静 有声 有性 雄性 優生 優性 遊星 優勢 郵政"
"ゆうせいらん 有精卵"
"ゆうせき 有責"
"ゆうせつ 融雪"
"ゆうせん 涌泉 勇戦 湧泉 郵船 有線 優先"
"ゆうぜい 游説 郵税 有税 遊説"
"ゆうぜん 悠然 友禅"
"ゆうぜんぞめ 友禅染"
"ゆうそう 遊僧 雄壮 遊走 勇壮 郵送"
"ゆうそく 有職"
"ゆうぞう 勇蔵 勇三 裕三 祐三 雄三"
"ゆうぞら 夕空"
"ゆうた 由宇太 祐太"
"ゆうたい 郵袋 融体 幽体 勇退 優待"
"ゆうたいどうさん 有体動産"
"ゆうたいぶつ 有体物"
"ゆうたいるい 有袋類"
"ゆうたろう 裕太郎"
"ゆうだ 遊惰"
"ゆうだい 雄大"
"ゆうだち 夕立ち 夕立"
"ゆうだちぐも 夕立雲"
"ゆうだん 勇断"
"ゆうだんしゃ 有段者"
"ゆうち 誘致"
"ゆうちゃく 融着"
"ゆうちょ 郵貯"
"ゆうちょう 有徴 悠長"
"ゆうつうせい 有痛性"
"ゆうつづ 長庚 夕星"
"ゆうづう 融通"
"ゆうづき 有月 夕月"
"ゆうづきよ 夕月夜"
"ゆうづくよ 夕月夜"
"ゆうづる 夕鶴"
"ゆうてい 夕定"
"ゆうているい 有蹄類"
"ゆうてん 融点"
"ゆうてんじ 祐天寺"
"ゆうでん 誘電"
"ゆうと 雄途 雄図 勇人"
"ゆうとう 雄踏 友党 遊蕩 優等"
"ゆうとく 有徳 祐徳"
"ゆうど 裕度 尤度"
"ゆうどう 有働 遊動 誘導"
"ゆうどうえんぼく 遊動円木"
"ゆうどうだん 誘導弾"
"ゆうどく 有毒"
"ゆうな 夕菜"
"ゆうなぎ 夕凪"
"ゆうなみ 夕波"
"ゆうに 優に"
"ゆうねつき 有熱期"
"ゆうのう 有能"
"ゆうはい 有配"
"ゆうはつ 誘発"
"ゆうはもん 幽波紋"
"ゆうはん 有半 雄藩 夕飯"
"ゆうばえ 夕暎え 夕映え"
"ゆうばく 誘爆"
"ゆうばり 夕張"
"ゆうばれ 夕晴れ"
"ゆうぱっく ゆうパック"
"ゆうひ 雄飛 夕陽 夕日"
"ゆうひかく 有斐閣"
"ゆうひつ 祐筆 右筆"
"ゆうひょう 遊標 融氷 有標"
"ゆうひん 優品"
"ゆうび 優美"
"ゆうびょうりつ 有病率"
"ゆうびん 〒 郵便"
"ゆうびんばこ 郵便箱"
"ゆうびんばんごう 〒"
"ゆうふ 有夫"
"ゆうふく 裕福"
"ゆうふつ 勇払"
"ゆうふん 憂憤"
"ゆうぶ 勇武"
"ゆうへい 裕平 雄平 幽閉"
"ゆうへん 雄篇 雄編"
"ゆうべ 夕 昨夜 夕べ"
"ゆうべつ 湧別"
"ゆうべん 雄弁"
"ゆうほ 遊歩"
"ゆうほう 友邦 友朋 雄峰"
"ゆうほうどうしょてん 友朋堂書店"
"ゆうぼう 有望"
"ゆうぼく 遊牧"
"ゆうま 遊馬"
"ゆうまぐれ 夕間暮れ"
"ゆうみ 裕美"
"ゆうみや 夕宮"
"ゆうみん 遊民"
"ゆうみんしゃ 遊眠社"
"ゆうむ 有無"
"ゆうめい 幽冥 幽明 勇名 有名"
"ゆうめし 夕飯"
"ゆうめん 宥免"
"ゆうもう 有毛 勇猛"
"ゆうもうせん 湧網線"
"ゆうもや 夕靄"
"ゆうもん 憂悶 幽門"
"ゆうや 裕弥 裕哉 雄也 裕也"
"ゆうやく 勇躍 釉薬"
"ゆうやけ 夕焼 夕焼け"
"ゆうやけぐも 夕焼け雲"
"ゆうやけこやけ 夕焼小焼"
"ゆうやみ 夕闇"
"ゆうゆう 融融 悠悠 融々 悠々"
"ゆうよ 有余 猶予"
"ゆうよう 融溶 悠揚 有用"
"ゆうよく 游弋 遊弋 有翼"
"ゆうらく 有楽 遊楽"
"ゆうらん 遊覧"
"ゆうり 悠理 悠里 友里 遊里 有理 遊離 有利"
"ゆうりこう 釉裏紅"
"ゆうりゃく 雄略"
"ゆうりょ 憂慮"
"ゆうりょう 遊猟 優良 有料"
"ゆうりょうさーびす 有料サービス"
"ゆうりょうぜい 遊漁税"
"ゆうりょく 有力"
"ゆうりょくば 有力馬"
"ゆうりん 友隣 有鱗"
"ゆうりんどう 有隣堂"
"ゆうれい 雄麗 優麗 幽霊"
"ゆうれき 遊歴"
"ゆうれつ 優劣"
"ゆうわ 友輪 優和 雄和 宥和 融和"
"ゆうわく 誘惑"
"ゆえ 優恵 湯江 故"
"ゆえい 輸贏"
"ゆえき 輸液"
"ゆえつ 諛悦 踰越 愉悦"
"ゆえに ∴ 故に"
"ゆえよし 故由"
"ゆえん 油煙 由縁 所以"
"ゆおう 硫黄"
"ゆおも 湯母"
"ゆおん 油温 湯温"
"ゆか 弓佳 友賀 友華 夕佳 夕夏 由架 由加 有香 裕香 由香 結花 由佳 友香 夕香 油化 牀 床"
"ゆかい 愉快"
"ゆかいた 床板"
"ゆかいちめん 床一面"
"ゆかうえ 床上"
"ゆかうんどう 床運動"
"ゆかおき 床置き 床置"
"ゆかぐみ 床組"
"ゆかげん 湯加減"
"ゆかこ 友華子 有香子 優香子 裕香子 由香子"
"ゆかざい 床材"
"ゆかした 床下"
"ゆかた 浴衣"
"ゆかたすがた 浴衣姿"
"ゆかたびら 湯帷子"
"ゆかだか 床高"
"ゆかだんぼう 床暖房"
"ゆかの 由佳乃"
"ゆかばり 床張り"
"ゆかほん 床本"
"ゆかみがき 床磨き"
"ゆかめん 床面"
"ゆかめんせき 床面積"
"ゆかよう 床用"
"ゆかり 由架梨 友佳梨 由加利 由佳利 所縁 由香利 紫 縁"
"ゆかわ 湯河 湯川"
"ゆかん 湯灌"
"ゆが 憂花 瑜伽"
"ゆがしま 湯が島 湯ヶ島 湯ケ島"
"ゆがま 湯釜"
"ゆがみ 歪み"
"ゆがわ 湯川"
"ゆがわら 湯河原"
"ゆき 倖 恭 征 志 之 幸 油機 由喜 油木 由妃 湯来 由綺 斎木 由岐 裕紀 由姫 由記 由起 夕紀 由季 由希 夕貴 友紀 由樹 有希 由貴 有紀 由紀 裄 行き 行 雪"
"ゆきあい 行合"
"ゆきあか 雪垢"
"ゆきあかり 雪明かり 雪明り"
"ゆきあそび 雪遊び"
"ゆきあらし 雪嵐"
"ゆきいり 雪入"
"ゆきうさぎ 雪兎"
"ゆきえ 由喜枝 幸栄 好恵 由紀江 雪絵 幸枝 幸江 幸恵"
"ゆきお 由希夫 由記雄 行生 由起夫 悠紀夫 雪夫 幸應 悠紀雄 行夫 幸生 行雄 由紀夫 幸夫 幸男 幸雄"
"ゆきおこし 雪起し 雪起こし"
"ゆきおと 雪音"
"ゆきおとこ 雪男"
"ゆきおれ 雪折れ"
"ゆきおろし 雪下ろし"
"ゆきおんな 雪女"
"ゆきか 幸香"
"ゆきかえり 往き還り"
"ゆきかき 雪掻き"
"ゆきかぜ 雪風"
"ゆきかべ 雪壁"
"ゆきがかり 行き掛り 行き掛かり"
"ゆきがこい 雪囲い"
"ゆきがっせん 雪合戦"
"ゆきき 行き来"
"ゆきくら 雪倉"
"ゆきぐに 雪国"
"ゆきぐみ 雪組"
"ゆきぐも 雪雲"
"ゆきけむり 雪煙"
"ゆきげしき 雪景色"
"ゆきげしょう 雪化粧"
"ゆきこ 有己子 夕紀子 由季子 友紀子 由貴子 雪子 由起子 有紀子 由希子 有希子 由紀子 幸子"
"ゆきころがし 雪転がし"
"ゆきさき 行先"
"ゆきざさ 雪笹"
"ゆきしつ 雪質"
"ゆきしろ 雪代"
"ゆきじ 雪路"
"ゆきじるし 雪印"
"ゆきじろ 雪白"
"ゆきすぎ 行過ぎ"
"ゆきすずめ 雪雀"
"ゆきずり 行き摺り 行き摩り"
"ゆきぞう 行三"
"ゆきぞら 雪空"
"ゆきた 幸田"
"ゆきたか 幸貴"
"ゆきたけ 雪竹 裄丈"
"ゆきたに 雪谷"
"ゆきだま 雪玉"
"ゆきだまり 雪溜まり"
"ゆきだるま 雪ダルマ 雪だるま 雪達磨"
"ゆきち 諭吉"
"ゆきづきよ 雪月夜"
"ゆきづまり 行き詰まり"
"ゆきとし 礼暁 幸敏 幸俊"
"ゆきとみ 幸富"
"ゆきとり 雪取"
"ゆきどけ 雪融け 雪解け"
"ゆきどけみず 雪解け水"
"ゆきなげ 雪投げ"
"ゆきなり 志勢 幸成 行成"
"ゆきの 雪乃 雪野"
"ゆきのじょう 雪之丞"
"ゆきのすけ 雪ノ助"
"ゆきのぶ 之宣 行信"
"ゆきのり 幸記 行徳 行則 幸範 幸紀 幸典 幸徳 幸則"
"ゆきはだ 雪肌"
"ゆきはる 幸春"
"ゆきば 行場"
"ゆきばな 雪花"
"ゆきばれ 雪晴れ"
"ゆきひこ 由記彦 恭彦 由紀彦 行彦 幸彦"
"ゆきひで 幸秀"
"ゆきひと 幸仁"
"ゆきひら 雪平 行平"
"ゆきひらなべ 雪平鍋"
"ゆきひろ 幸拾 幸展 行宏 行弘 幸博 幸広 幸宏 幸弘"
"ゆきびさし 雪庇"
"ゆきふみ 幸史"
"ゆきぶそく 雪不足"
"ゆきほ 行穂"
"ゆきぼうし 雪帽子"
"ゆきまさ 幸真 幸政 幸正"
"ゆきまじり 雪雑じり 雪交じり 雪混じり"
"ゆきまちづき 雪待ち月 雪待月"
"ゆきまつ 行松"
"ゆきまつり 雪祭 雪祭り"
"ゆきみ 雪見"
"ゆきみぐさ 雪見草"
"ゆきみち 幸道 雪路 雪道"
"ゆきみつ 幸光"
"ゆきむし 雪虫"
"ゆきむら 幸村"
"ゆきめ 雪眼"
"ゆきもと 雪本"
"ゆきもよう 雪模様"
"ゆきや 幸也"
"ゆきやなぎ 雪柳"
"ゆきやま 雪山"
"ゆきよ 雪代 幸代 雪夜"
"ゆきよし 幸喜 幸義"
"ゆきれっしゃ 雪列車"
"ゆきわかれ 行別れ"
"ゆきわりそう 雪割草"
"ゆきんこ 雪ん子"
"ゆぎ 由木 柚木"
"ゆぎえ 靫負"
"ゆぎおい 靫負"
"ゆぎしょう 湯起請"
"ゆぎょう 遊行"
"ゆぎん 輸銀"
"ゆくあき 行く秋"
"ゆくえ 行く方 行方"
"ゆくかた 行く方"
"ゆくさき 行先 行く先"
"ゆくさきざき 行く先々"
"ゆくすえ 行く末"
"ゆくて 行く手"
"ゆくとし 行く年"
"ゆくは 的"
"ゆくはし 行橋"
"ゆくはる 行く春"
"ゆくへ 行方"
"ゆくゆく 行く行く"
"ゆぐち 湯口"
"ゆけつ 輸血"
"ゆけむり 湯煙"
"ゆけん 油研"
"ゆげ 遊戯 弓削 湯気"
"ゆげい 靫負"
"ゆげた 弓削田"
"ゆこく 諭告"
"ゆごう 癒合"
"ゆさ 遊佐"
"ゆさい 油彩"
"ゆさぶり 揺さ振り 揺さぶり"
"ゆさわり 鞦韆"
"ゆさん 遊山"
"ゆざい 油剤"
"ゆざまし 湯冷まし"
"ゆざめ 湯ざめ 湯冷め"
"ゆざわ 湯澤 湯沢"
"ゆし 諭旨 油紙 油脂"
"ゆしま 油島 湯島"
"ゆしゅつ 輸出"
"ゆしゅつにゅう 輸出入"
"ゆしょう 油症"
"ゆしょく 愉色"
"ゆじょう 油状"
"ゆすはら 梼原"
"ゆすら 山桜桃 梅桃 桜桃"
"ゆすらうめ 英桃 山桜桃 梅桃 桜桃"
"ゆすり 強請"
"ゆず 梼 柚 柚子"
"ゆずがま 柚釜"
"ゆずき 柚月 柚木"
"ゆずこ 柚子"
"ゆずみそ 柚味噌"
"ゆずゆ 柚湯"
"ゆずりうけ 譲り受け"
"ゆずりうけにん 譲受人"
"ゆずりは 譲葉"
"ゆずりわたしにん 譲渡人"
"ゆずる 讓 譲"
"ゆせ 湯瀬"
"ゆせい 油井 油性"
"ゆせいかん 輸精管"
"ゆせいぺん 油性ペン"
"ゆせいまじっく 油性マジック"
"ゆせん 湯せん 湯銭 湯煎"
"ゆそう 油層 油送 湯槽 油槽 輸送"
"ゆそうへり 輸送ヘリ"
"ゆそつ 輸卒"
"ゆたか 豊か 豐 穰 泰 優 裕 豊"
"ゆたかさ 豊さ 豊かさ"
"ゆたかしょうゆ 豊醤油"
"ゆたに 由谷 湯谷"
"ゆたゆた 揺た揺た"
"ゆたん 油単"
"ゆたんぽ 湯たんぽ 湯湯婆"
"ゆだ 湯田"
"ゆだく 油濁"
"ゆだち 弓立"
"ゆだて 湯立"
"ゆだなか 湯田中"
"ゆだま 湯玉"
"ゆだめ 檠"
"ゆだや 猶太"
"ゆだやきょう ユダヤ教"
"ゆだやけい ユダヤ系"
"ゆだやじん ユダヤ人"
"ゆだん 油断"
"ゆちゃ 湯茶"
"ゆちゃく 癒着"
"ゆつか 弓束"
"ゆつぼ 湯壺"
"ゆづかみ 湯津上"
"ゆづかれ 湯疲れ"
"ゆづき 由月 弓月"
"ゆづけ 湯漬 湯漬け"
"ゆづる 弓弦"
"ゆてき 油滴"
"ゆてん 油点"
"ゆで 茹で"
"ゆでぐり 茹で栗"
"ゆでたまご ゆで卵 茹で卵"
"ゆでだこ 茹で蛸"
"ゆでめん 茹で麺"
"ゆでん 油田"
"ゆとう 湯桶"
"ゆど 油土"
"ゆどうふ 湯豆腐"
"ゆどおし 湯通し"
"ゆどの 湯殿"
"ゆな 湯女"
"ゆに 由仁"
"ゆにばーさるきばん ユニバーサル基板"
"ゆにゅう 輸入"
"ゆにゅうぎゅう 輸入牛"
"ゆにゅうにく 輸入肉"
"ゆにゅうば 輸入馬"
"ゆにゅうまい 輸入米"
"ゆにょうかん 輸尿管"
"ゆにわ 弓庭 斎庭 斎場"
"ゆのかわ 湯野川 湯ノ川"
"ゆのき 柚木"
"ゆのたに 湯之谷"
"ゆのつ 温泉津"
"ゆのはな 湯の花"
"ゆのはま 湯野浜"
"ゆのまえ 湯前"
"ゆのみ 湯飲み 湯呑み"
"ゆはず 弓弭"
"ゆはた 纈"
"ゆはら 湯原"
"ゆば 湯場 湯波 弓場 湯葉"
"ゆばら 湯原"
"ゆばり 尿"
"ゆび 趾 指"
"ゆびあな 指孔"
"ゆびいっぽん 指一本"
"ゆびいん 指印"
"ゆびおり 指折り"
"ゆびき 湯引き"
"ゆびきり 指切り"
"ゆびさき 指先"
"ゆびさし 指差し"
"ゆびさしかくにん 指差確認"
"ゆびさっく 指サック"
"ゆびずもう 指相撲"
"ゆびづかい 指遣い 指使い"
"ゆびにんぎょう 指人形"
"ゆびぬき 指貫き 指貫"
"ゆびばん 指板"
"ゆびひき 指弾き"
"ゆびぶえ 指笛"
"ゆびもじ 指文字"
"ゆびわ 指環 指輪"
"ゆふ 由府"
"ゆふいん 由布院 湯布院"
"ゆふね 湯舟"
"ゆふばえ 夕暎え"
"ゆぶね 湯ぶね 湯舟 湯船"
"ゆぶん 油分"
"ゆぷしろん Υ υ"
"ゆべし 柚餅子"
"ゆま 由真"
"ゆまく 油膜"
"ゆまり 尿"
"ゆみ 宙美 有望 祐美 祐未 由実 友美 有美 優美 裕美 由美 弓"
"ゆみえ 弓技 由美恵"
"ゆみおか 弓岡"
"ゆみか 由美香"
"ゆみがた 弓形"
"ゆみがはま 弓ヶ浜"
"ゆみこ 佑三子 友美子 祐三子 有美子 祐美子 優美子 裕美子 弓子 由美子"
"ゆみし 弓師"
"ゆみず 湯水"
"ゆみそ 柚味噌"
"ゆみた 弓田"
"ゆみつくり 弓造り"
"ゆみづかい 弓使い"
"ゆみづる 弓弦"
"ゆみとり 弓取 弓取り"
"ゆみなか 弓仲"
"ゆみなが 弓長"
"ゆみなり 弓形"
"ゆみの 弓野"
"ゆみはじめ 弓始"
"ゆみはず 弓筈"
"ゆみはり 弓張"
"ゆみはりづき 弓張り月"
"ゆみば 弓場"
"ゆみへい 弓兵"
"ゆみへん 弓偏"
"ゆみや 弓矢"
"ゆむき 湯剥き"
"ゆむら 湯村"
"ゆめ 努 結女 梦 夢"
"ゆめあわせ 夢合せ"
"ゆめいっぱい 夢一杯"
"ゆめいろ 夢色"
"ゆめうつつ 夢現"
"ゆめうらない 夢占い"
"ゆめおち 夢オチ"
"ゆめかかく 夢価格"
"ゆめがたり 夢語り"
"ゆめきこう 夢紀行"
"ゆめきぶん 夢気分"
"ゆめこ 夢子"
"ゆめこうぼう 夢工房"
"ゆめごこち 夢心地"
"ゆめさき 夢前"
"ゆめさら 夢更"
"ゆめじ 夢二 夢路"
"ゆめぞの 夢園"
"ゆめでんせつ 夢伝説"
"ゆめと 夢人"
"ゆめどの 夢殿"
"ゆめの 夢野"
"ゆめのうきはし 夢浮橋"
"ゆめのしま 夢の島"
"ゆめはんだん 夢判断"
"ゆめぼうけん 夢冒険"
"ゆめまくら 夢枕"
"ゆめまぼろし 夢幻"
"ゆめみ 夢見"
"ゆめものがたり 夢物語"
"ゆめゆめ 夢夢 努努 夢々 努々"
"ゆめよ 夢代"
"ゆもじ 湯文字"
"ゆもと 湯元 湯本"
"ゆや 油谷 湯屋"
"ゆやま 湯山"
"ゆゆ 結由"
"ゆゆしき 由々しき"
"ゆようせい 油溶性"
"ゆよく 湯浴"
"ゆら 由良"
"ゆらい 由来"
"ゆらいがき 由来書"
"ゆらぎ 揺らぎ"
"ゆらく 愉楽"
"ゆらのすけ 由良之助"
"ゆらめき 揺らめき"
"ゆらんかん 輸卵管"
"ゆり 閖 岼 友利 憂里 由理 友梨 由里 友理 祐理 由利 由梨 有里 祐里 百合"
"ゆりあげ 閖上"
"ゆりあにあもく ユリアニア目"
"ゆりいす 揺り椅子"
"ゆりうすれき ユリウス暦"
"ゆりえ 百合枝 友里恵"
"ゆりか 優里香 ユリ科"
"ゆりかえし 揺り返し"
"ゆりかご 揺り籠"
"ゆりかもめ 百合鴎"
"ゆりこ 祐理子 祐里子 由利子 由里子 ゆり子 百合子"
"ゆりこう ユリ綱"
"ゆりね 百合根"
"ゆりのちょう 百合野町"
"ゆりみ 有里巳"
"ゆりもく ユリ目"
"ゆりもどし 揺り戻し"
"ゆりょう 油料 油量 油糧 湯量"
"ゆる 閖 百合 緩"
"ゆるがせ 忽 忽せ"
"ゆるぎ 揺るぎ"
"ゆるしいろ 聴し色"
"ゆるすまじ 許すまじ"
"ゆるみ 弛み 緩み"
"ゆるやか 緩やか"
"ゆるゆる 揺る揺る 緩緩 緩々"
"ゆるり 緩り"
"ゆれ 揺れ"
"ゆれも 揺藻"
"ゆわかし 湯沸し"
"ゆわかしき 湯沸かし機 湯沸かし器 湯沸器"
"ゆわり 湯割り"
"ゆゑ 故"
"ゆゑん 所以"
"ゆん 潤"
"ゆんぜい 弓勢"
"ゆんで 左手 弓手"
"ゆんべ 昨夜"
"ゆんも 潤模"
"よ 弥 譽 與 餘 豫 丗 飫 蕷 舁 畭 四 誉 歟 輿 預 予 与 夜 余 世 代"
"よーどらん ヨード卵"
"よーろっぱ 歐羅巴 欧羅巴"
"よーろっぱじん ヨーロッパ人"
"よあかし 夜明し"
"よあつ 予圧 与圧"
"よあらし 夜嵐"
"よい 良い 余威 酔い 酔 宵"
"よいき 余域"
"よいこ よい子 良い子"
"よいごこち 酔心地"
"よいごし 宵越し"
"よいざまし 酔い覚まし"
"よいた 与板"
"よいち 四一 世一 夜市 余市"
"よいっぱり 宵っ張り"
"よいづき 宵月"
"よいづきよ 宵月夜"
"よいづみ 宵積み"
"よいど 余緯度"
"よいどめ 酔い止め"
"よいどれ 酔いどれ"
"よいね 宵寝"
"よいのくち 宵の口"
"よいのみょうじょう 宵の明星"
"よいまち 宵待ち 宵待"
"よいまちぐさ 宵待草"
"よいまつり 宵祭"
"よいみや 宵宮"
"よいやま 宵山"
"よいやみ 宵闇"
"よいん 餘音 餘韻 余音 余韻"
"よいんし 余因子"
"よいんじょうじょう 余韻嫋々"
"よう 八 怏 泱 邀 曄 孕 姚 陶 腰 厭 膺 鷹 珱 瓔 樣 漾 瀁 癢 瑤 瑶 徭 遙 遥 謠 謡 搖 揺 慂 蛹 俑 踴 踊 甬 慵 庸 傭 蓉 穃 榕 鎔 熔 溶 容 窈 拗 擁 壅 雍 幺 瘍 煬 暘 昜 楊 揚 殀 夭 妖 燿 耀 曜 廱 癰 痒 恙 佯 羊 窰 窯 葉 養 陽 杳 幼 洋 要 様 用"
"ようあん 溶暗"
"ようい 洋医 妖異 容易 用意"
"よういおん 陽イオン"
"よういく 養育"
"よういち 暢一 要一 陽一 洋一"
"よういちろう 曜一郎"
"よういん 要員 要因"
"ようえい 揺曳"
"ようえき 徭役 用益 用役 葉腋 溶液"
"ようえきさいばい 養液栽培"
"ようえきち 要役地"
"ようえん 揺炎 葉縁 陽炎 妖艶"
"ようおん 拗音"
"ようか ８日 沃化 養家 妖花 ヨウ化 蛹化 八鹿 八日"
"ようかい 鎔解 熔解 容喙 溶解 妖怪"
"ようかいどせき 溶解度積"
"ようかた 養方"
"ようかん 羊羮 腰間 陽関 羊羹 洋館"
"ようが 陽画 葉芽 幼芽 用賀 洋画"
"ようがい 要害"
"ようがく 幼学 洋学 洋楽"
"ようがさ 洋傘"
"ようがらし 洋芥子 洋辛子"
"ようがわら 洋瓦"
"ようがん 容顔 熔岩 溶岩"
"ようき 妖鬼 妖気 用器 陽気 容器"
"ようきひ 楊貴妃"
"ようきゅう 楊弓 洋弓 要求"
"ようきゅうばらいよきん 要求払預金"
"ようきょう 佯狂 容共"
"ようきょく 陽極 謡曲"
"ようきん 洋禽 洋斤 要緊 洋琴 溶菌 用金"
"ようぎ 容儀 要義 容疑"
"ようぎょ 養魚 幼魚"
"ようぎょう 窯業"
"ようぎん 洋銀"
"ようくぎ 洋釘"
"ようくん 幼君"
"ようぐ 庸愚 要具 用具"
"ようぐんがん 羊群岩"
"ようけい 幼形 葉形 葉茎 養鶏"
"ようけいさいるい 葉茎菜類"
"ようけつ 要訣 溶血"
"ようけん 楊堅 洋犬 用件 要件"
"ようけんどう 養賢堂"
"ようげき 要劇 邀撃 要撃"
"ようげん 妖言 揚言 用言"
"ようげんか 溶原化"
"ようこ 揚子 楊子 羊子 妖狐 妖子 庸子 暢子 瑤子 よう子 耀子 容子 葉子 洋子 陽子"
"ようこう 妖光 要港 洋行 用高 陽光 要綱 要項"
"ようこうだい 洋光台"
"ようこうろ 鎔鉱爐 鎔鉱炉 溶鉱炉"
"ようこく 陽刻"
"ようこん 幼根"
"ようご 洋語 用後 擁護 養護 用語"
"ようごう 影向"
"ようさい 洋才 洋裁 要塞"
"ようさいるい 葉菜類"
"ようさん 洋算 養蚕 葉酸"
"ようざい 用材 溶剤"
"ようざら 洋皿"
"ようざん 要斬 腰斬"
"ようし 羊脂 夭死 羊歯 洋紙 陽子 養子 容姿 要旨 用紙"
"ようしき 要式 洋式 様式"
"ようしつ 溶質 洋室"
"ようしば 洋芝"
"ようしゃ 幼者 用捨 容赦"
"ようしゅ 楊朱 洋種 洋酒"
"ようしゅう 揚州"
"ようしゅつ 溶出"
"ようしゅん 陽春"
"ようしょ 要所 洋書"
"ようしょう 葉鞘 要衝 幼少"
"ようしょく 容色 要職 養殖 洋食"
"ようしょくいけ 養殖池"
"ようしょくうお 養殖魚"
"ようしょくぎょ 養殖魚"
"ようしん 養親 葉身"
"ようじ 曜示 庸次 陽次 庸治 耀司 陽司 陽治 陽二 洋次 洋司 洋治 洋二 幼時 要事 楊子 楊枝 用字 幼児 用事"
"ようじうお 楊子魚"
"ようじゃく 幼弱 幼若"
"ようじゃくほるもん 幼若ホルモン"
"ようじゅう 妖獣"
"ようじゅつ 妖術"
"ようじょ 葉序 妖女 養女 幼女"
"ようじょう 横笛 葉状 洋上 養生"
"ようじん 要心 洋人 要人 用心"
"ようじんぼう 用心棒"
"ようす 容子 様子"
"ようすい 陽水 羊水 揚水 用水"
"ようすけ 洋助 葉介 洋祐 庸介 洋輔 陽介 洋介"
"ようすこう 揚子江"
"ようすみ 様子見"
"ようするに 要するに"
"ようず 要図"
"ようずみ 用済み"
"ようせい 葉性 夭逝 妖星 幼生 陽性 妖精 要請 養成"
"ようせき 陽石 容積"
"ようせつ 殀折 熔接 要説 夭折 溶接"
"ようせん 用箋 傭船 用船"
"ようぜいてんのう 陽成天皇"
"ようそ I ヨウ素 沃素 要素"
"ようそう 洋装 様相"
"ようそく 壅塞"
"ようそわ 要素和"
"ようそん 養鱒"
"ようぞう 容三 陽三 洋三"
"ようぞん 溶存"
"ようた 洋太"
"ようたい 溶体 容体 容態 様態"
"ようたし 用足し 用達"
"ようたつ 用達"
"ようだ 様だ"
"ようだい 煬帝 容体 容態"
"ようだこ 洋凧"
"ようだん 要談 用談"
"ようだんす 洋ダンス 洋箪笥 用箪笥"
"ようち 夜討ち 夜討 要地 幼稚 用地"
"ようちあさがけ 夜討ち朝駆け"
"ようちしゃ 幼稚舎"
"ようちゅう 鎔鑄 幼沖 幼虫"
"ようちょう 窈窕 膺懲 羊腸"
"ようちん 永沈 葉枕"
"ようつい 腰椎"
"ようつう 腰痛"
"ようてい 幼帝 羊蹄 揚程 要諦"
"ようていざん 羊蹄山"
"ようてん 陽転 要点"
"ようと 用途"
"ようとう 妖刀 洋島 洋灯 洋燈 羊頭"
"ようとして 杳として"
"ようとん 養豚"
"ようど 沃度 用度 用土"
"ようどう 幼童 陽動 揺動"
"ようどがかり 用度掛"
"ようなし 洋なし 洋ナシ 用無し 洋梨"
"ように 陽に 用に 様に"
"ようにく 葉肉 羊肉"
"ようにん 遥任 傭人 用人 容認"
"ようねん 幼年"
"ようのすけ 洋之介 陽之助"
"ようは 要は"
"ようはい 腰佩 遥拝"
"ようはいがん 羊背岩"
"ようはく 洋白"
"ようはつ 洋髪"
"ようはん 羊斑 鎔笵 洋販"
"ようば 妖婆"
"ようばい 楊梅 溶媒"
"ようばいひ 楊梅皮"
"ようばん 用番 洋盤"
"ようひ 要否"
"ようひし 羊皮紙"
"ようひつ 用筆"
"ようひん 洋品 用品"
"ようび 妖美 曜日"
"ようふ 妖婦 用布 養父"
"ようふう 洋風"
"ようふく 洋服"
"ようふくだんす 洋服箪笥"
"ようぶ 洋舞 腰部"
"ようぶつ 陽物"
"ようぶつけいやく 要物契約"
"ようぶん 幼文 陽文 洋文 養分"
"ようへい 傭聘 洋平 用兵 葉柄 傭兵"
"ようへき 擁壁"
"ようへん 耀変 曜変 葉片 窯変"
"ようべん 用便"
"ようほ 幼保"
"ようほう 妖法 陽報 養蜂 用法"
"ようほうじばん 要法寺版"
"ようほん 洋本"
"ようぼ 養母"
"ようぼう 杳茫 容貌 要望"
"ようぼく 幼木 用木"
"ようま 洋間 妖魔"
"ようまく 羊膜"
"ようまつ 洋松"
"ようまん 養鰻"
"ようみゃく 葉脈"
"ようみょう 幼名"
"ようむ 洋鵡 遥夢 妖霧 要務 用務"
"ようむき 用向き"
"ようめい 溶明 養命 幼名 用命"
"ようめいてんのう 用明天皇"
"ようめいもん 陽明門"
"ようめん 容面 葉面"
"ようもう 養毛 羊毛"
"ようもく 要目"
"ようもの 洋モノ 洋物"
"ようもん 要文"
"ようやく 漸く 要約"
"ようゆう 熔融 溶融"
"ようよう 妖々 揺揺 溶溶 漸う 揚揚 幼葉 要用 洋洋 鷹揚 様様 様々 揚々 洋々"
"ようらく 揺落 瓔珞"
"ようらん 洋ラン 揺籃 洋蘭 要覧"
"ようり 葉理 要理 養鯉"
"ようりく 揚陸"
"ようりつ 擁立"
"ようりゃく 要略"
"ようりゅう 楊柳"
"ようりょう 養料 用量 要領 容量"
"ようりょく 妖力 揚力"
"ようりょくそ 葉緑素"
"ようりょくたい 葉緑体"
"ようれい 妖麗 妖霊 用例"
"ようれき 陽暦"
"ようれつ 庸劣"
"ようれんきん 溶連菌"
"ようろ 要路"
"ようろう 養老"
"ようろういん 養老院"
"ようろうのたき 養老の滝"
"ようろく 要録"
"ようろん 要論"
"ようわ 溶和 養和"
"ようん 余蘊"
"よえい 余栄 余映"
"よえつ 与悦"
"よえん 余煙 余炎"
"よおぎ 八尾木"
"よか 餘暇 四日 予科 予価 余暇"
"よかく 余核 余角 予覚 与格"
"よかぜ 夜風"
"よかつ 余割"
"よかれ 善かれ"
"よかれあしかれ 良かれ悪しかれ 善かれ悪しかれ"
"よかれん 予科練"
"よかわ 吉川"
"よかわほうご 横川法語"
"よかん 豫感 余寒 予感"
"よがりごえ 善がり声"
"よき 豫期 良き 予期"
"よきょう 餘興 余響 余興"
"よきょくいり 余曲入"
"よきん 預金"
"よぎ 余儀 余技 夜着"
"よぎしゃ 夜汽車"
"よぎた 与北"
"よぎょう 余業"
"よぎり 夜霧"
"よく 緘 良く 慾 峪 翊 杙 弋 沃 抑 浴 翌 翼 欲"
"よくあさ 翌朝"
"よくあつ 抑圧"
"よくい 浴衣"
"よくうかん 余空間"
"よくうつ 抑鬱"
"よくか 翼果"
"よくかい 欲界"
"よくがた 翼型"
"よくき 翌期"
"よくけ 欲気"
"よくけい 翼形"
"よくげつ 翌月"
"よくこうるい 翼甲類"
"よくご 浴後"
"よくさん 翼賛"
"よくし 抑止"
"よくしつ 浴室"
"よくしゅう 翌秋 翌週"
"よくしゅりゅう 翼手竜"
"よくしゅるい 翼手類"
"よくしゅん 翌春"
"よくしん 慾心 欲心"
"よくじつ 翌日"
"よくじょう 抑情 慾情 翼状 欲情 浴場"
"よくせい 抑制"
"よくせき 翌夕"
"よくそう 浴槽"
"よくそくじ 抑速時"
"よくたん 翼端"
"よくち 沃地"
"よくちょう 翼長 翌朝"
"よくとく 欲得"
"よくとし 翌年"
"よくど 沃土"
"よくどう 欲動"
"よくねん 欲念 翌年"
"よくのかわ 欲の皮"
"よくばり 欲張 欲張り"
"よくばん 翌晩"
"よくふか 欲深"
"よくぼう 慾望 欲望"
"よくぼけ 欲ボケ"
"よくめ 欲目"
"よくめん 翼面"
"よくめんせき 翼面積"
"よくや 翌夜 沃野"
"よくよう 浴用 抑揚"
"よくよく 能く能く 善く善く 翼々 翌々"
"よくよくげつ 翌々月"
"よくよくじつ 翌々日"
"よくりゅう 翼龍 翼竜 抑留"
"よくれつ 翼列"
"よくん 余薫"
"よぐち 与口"
"よけい 餘計 余慶 余計"
"よけつ 預血"
"よけん 豫見 与件 予見"
"よげつ 余月"
"よげん 豫言 余弦 預言 予言"
"よこ ━ ─ 横"
"よこあい 横合 横合い"
"よこあな 横穴"
"よこあめ 横雨"
"よこい 横井"
"よこいた 横板"
"よこいと 緯糸 横糸"
"よこう 余光 余香 予稿 予行"
"よこうち 横内"
"よこえ 横絵"
"よこお 横尾"
"よこおき 横置"
"よこかぜ 横風"
"よこかべ 横壁"
"よこかわ 横河 横川"
"よこがお 横顔"
"よこがき 横書"
"よこがく 横額"
"よこがた 横型"
"よこがみ 横紙 横髪"
"よこがみやぶり 横紙破り"
"よこがわ 横河 横川"
"よこぎ 横木"
"よこく 豫告 与国 予告"
"よこくら 横倉"
"よこぐみ 横組"
"よこぐも 横雲"
"よこぐるま 横車"
"よこけい 横罫"
"よこげり 横蹴り"
"よこごし 横越"
"よこさと 横里"
"よこざ 横座"
"よこざま 横樣 横様 横方"
"よこざわ 横沢"
"よこざん 横桟"
"よこしば 横芝"
"よこしほうがため 横四方固め"
"よこしま 横しま 邪ま 奸 辟 横島 邪"
"よこじく 横軸"
"よこじま 横縞"
"よこすか 横須賀"
"よこすくろーる 横スクロール"
"よこすじ 横筋"
"よこすべり 横滑り"
"よこずき 横好き"
"よこずれ 横ずれ"
"よこせ 横瀬"
"よこせん ━ ─ 横線"
"よこた 横田"
"よこたに 横谷"
"よこだおし 横倒し"
"よこだき 横抱き"
"よこちょう 横町 横丁"
"よこっつら 横っ面"
"よこっとび 横っ跳び 横っ飛び"
"よこっぱら 横っ腹"
"よこつか 横塚"
"よこつら 横面"
"よこづな 横綱"
"よこづみ 横積"
"よこて 横手"
"よこで 横手"
"よことび 横跳び"
"よこどい 横樋"
"よこなが 横長"
"よこなみ 横並 横波"
"よこね 横寝 横根"
"よこの 横野"
"よこはね 横羽"
"よこはば 横巾 横幅"
"よこはま 横濱 横浜"
"よこはまありーな 横浜アリーナ"
"よこはまごむ 横浜ゴム"
"よこはら 横腹"
"よこばい 横ばい 横這い"
"よこばしり 横走り"
"よこばら 横腹"
"よこひら 横平"
"よこふとり 横歩取り"
"よこふどり 横歩取り"
"よこぶえ 横笛"
"よこぶとり 横太り"
"よこぶり 横降り"
"よこほり 横堀"
"よこほん 横本"
"よこぼう 横棒"
"よこぼり 横堀"
"よこまち 横町"
"よこまつ 横松"
"よこまる 横丸"
"よこみ 横見"
"よこみぞ 横溝"
"よこみち 横道"
"よこみつ 横光"
"よこみねでら 横峰寺"
"よこむき 横向"
"よこめ 横目"
"よこもの 横物"
"よこもり 横森"
"よこや 横屋 横矢 横谷"
"よこやま 横山"
"よこやり 横やり 横槍"
"よこよこ 横横"
"よこわけ 横分"
"よご 豫後 余呉 予後"
"よごころ 世心"
"よごと 寿詞 夜毎"
"よごれ 汚れ"
"よごれやく 汚役"
"よさ 善さ 良さ 与謝"
"よさく 与作"
"よさこいぶし よさこい節"
"よさつ 予察"
"よさの 与謝野"
"よさぶろう 与三郎"
"よさむ 夜寒"
"よさめ 夜雨"
"よさん 豫算 予讃 予算"
"よざい 餘罪 余財 余罪"
"よざかり 世盛り"
"よざくら 夜桜"
"よし 縦 譱 禧 禎 淑 宜 克 嘉 芳 祥 慶 圭 佳 善 喜 義 純 吉 美 良 好 余矢 余資 因 葭 葦 由"
"よしあき 良晃 純明 芳明 宜明 義亮 良秋 吉晃 嘉晃 善章 由明 義晃 克明 美明 善昭 吉明 喜明 義朗 嘉章 義章 吉昭 嘉昭 良昭 嘉明 良明 義昭 義明"
"よしあし 善悪 良し悪し 善し悪し"
"よしい 芳井 吉井"
"よしいけ 吉池"
"よしいち 義一"
"よしうみ 吉海"
"よしうら 吉浦"
"よしえ 好江 佳恵 好恵 吉江 良枝 芳恵"
"よしお 温雄 誉志雄 禧雄 好央 芳男 佳雄 宗生 好生 佳郎 吉生 淑生 美夫 嘉雄 嘉夫 好雄 由夫 昌男 吉夫 佳男 善男 吉男 良男 好男 好夫 善夫 新生 善雄 嘉男 吉雄 芳夫 芳雄 良雄 良夫 義男 義夫 義雄"
"よしおか 吉岡"
"よしおみ 佳臣 善臣"
"よしか 佳香"
"よしかず 英一 佳和 能収 由和 佳一 慶一 好一 善一 善和 美一 芳一 喜一 良和 義一 義和"
"よしかつ 隆克 好克 良勝 義勝"
"よしかわ 好川 吉川"
"よしがき 芳垣"
"よしがみ 吉上"
"よしき 喜紀 芳希 芳季 吉輝 好輝 吉喜 吉起 慶樹 善紀 由樹 嘉樹 善樹 義樹 吉城 佳樹 吉敷 良樹 美樹 芳樹 与式"
"よしきゅう 与死球"
"よしきよ 義清"
"よしきり 葦雀 葦切"
"よしきりざめ 葦切鮫"
"よしくに 美邦 喜国 吉国"
"よしこ ヨシ子 賀子 嘉子 由子 好子 よし子 芳子 淑子 美子 良子 佳子"
"よしこし 吉越"
"よしさだ 悦貞 義貞"
"よしさと 義聡"
"よしざき 吉崎"
"よしざわ 義澤 芳沢 吉沢 吉澤"
"よししきゅう 与四死球"
"よしじ 良司 良至 良治"
"よしじま 吉島"
"よしすけ 義介"
"よしず 葭簀 葦簀"
"よしずみ 吉住"
"よしぞう 芳三"
"よしたか 禎孝 善孝 芳孝 吉高 善隆 嘉隆 孝高 佳孝 義高 良隆 義隆 義孝"
"よしたけ 義竹 義丈 美武 尚武 吉竹 吉武"
"よしたに 吉谷"
"よしたろう 由太郎 芳太郎"
"よしだ 慶田 吉田"
"よしだけんこう 吉田兼好"
"よしだしげる 吉田茂"
"よしだしょういん 吉田松陰"
"よしつ 好津"
"よしつぐ 佳次 善嗣 善次"
"よしつね 義経"
"よしづか 吉塚"
"よしてる 喜照 芳輝"
"よしと 圭人 芳人 義人"
"よしとお 義遠"
"よしとし 吉年 義敏"
"よしとせん 吉都線"
"よしとみ 善富 吉富"
"よしとも 義恭 義朋 義智 佳友 良知"
"よしどめ 吉留"
"よしなお 喜直 義直"
"よしなか 吉仲 義仲"
"よしなが 良永 吉永"
"よしなしごと 由無し事"
"よしなり 能成 悌也 祐生 芳成 義也 善成 義成 良成 吉成"
"よしの 淑乃 吉乃 美乃 芳野 吉野"
"よしのがりいせき 吉野ヶ里遺跡"
"よしのさくぞう 吉野作造"
"よしのだに 吉野谷"
"よしのぶ 栄伸 良伸 嘉伸 芳信 義信 慶喜"
"よしのや 吉野家"
"よしのり 嘉哲 賀悟 彬伯 良紀 美徳 義昇 由規 良法 良規 芳範 良教 善典 芳規 良憲 嘉典 佳則 善範 好則 美則 芳則 吉典 由典 吉徳 嘉則 善徳 佳紀 芳徳 吉則 佳典 良則 善則 義徳 良典 義典 義範 義則"
"よしは 吉葉"
"よしはま 吉浜"
"よしはら 吉原"
"よしはる 佳春 喜晴 喜治 芳晴 吉春 義春 善治 義晴 義治"
"よしば 吉場 吉羽"
"よしひこ 義比古 慶彦 喜彦 嘉彦 芳彦 吉彦 良彦 善彦 義彦"
"よしひさ 純央 由久 嘉久 良久 慶久 芳久 善久 義久"
"よしひで 善英 慶英 良英"
"よしひと 圭仁 善一 由人 芳人 芳仁"
"よしひろ 嘉伯 至寛 由泰 喜弘 佳泰 吉広 良祐 佳寛 好広 佳浩 美博 良広 慶大 吉廣 良浩 嘉浩 良宏 喜博 嘉弘 義宏 義裕 嘉宏 良博 義広 吉宏 善弘 義浩 善博 吉弘 義弘 義博"
"よしふみ 善文 仁史 佳文 祥史 好文 良文 義文"
"よしぶえ 葦笛"
"よしほ 美穂"
"よしま 吉間"
"よしまさ 喜昌 義雅 良昌 好正 義正"
"よしまつ 由松 吉松"
"よしみ 義巳 由光 嘉美 善美 義美 誼 好美 芳美 吉見 良美 昌美 由美"
"よしみず 吉水"
"よしみち 由道"
"よしみつ 芳充 嘉光 喜光 善光 吉光 義光"
"よしむね 義統 吉宗"
"よしむら 義村 芳村 吉村"
"よしもと 芳本 吉本"
"よしもとしんきげき 吉本新喜劇"
"よしもり 吉森"
"よしや 義哉 善哉 嘉也 吉屋"
"よしやす 好康 嘉康"
"よしやま 吉山"
"よしゅ 余種"
"よしゅう 豫習 余臭 予州 予習"
"よしゅく 予祝"
"よしゆき 佳行 嘉之 良幸 嘉雪 嘉志 由行 誉志幸 好幸 芳行 善幸 佳之 吉行 良之 義幸 義行 善之 義之"
"よしょく 余色"
"よしろう 与四郎 嘉朗 善郎 喜朗 義郎 芳郎"
"よしわ 吉和"
"よしわら 葦原 吉原"
"よしん 餘震 予審 予診 余震 与信"
"よしんば 縦んば"
"よじ 四次 四時 予示 余事"
"よじしょう 余事象"
"よじじゅくご 四字熟語"
"よじつ 余日"
"よじみゃく 四次脈"
"よじょう 餘剩 餘情 余情 余剰"
"よじょうはん 四畳半"
"よじろう 与次郎"
"よじん 余塵 餘人 余燼 余人"
"よすい 余水"
"よすが 因 便 縁"
"よすがら 終夜"
"よすぎ 世過ぎ"
"よすて 世捨"
"よすてびと 世捨て人"
"よすみ 四隅"
"よずめ 余詰"
"よせ 寄せ 寄席"
"よせあつめ 寄せ集め"
"よせい 餘勢 餘生 余情 余勢 余生"
"よせうえ 寄植え 寄せ植え"
"よせえ 寄せ餌"
"よせがき 寄書き"
"よせき 余積"
"よせぎ 寄木"
"よせぎざいく 寄せ木細工"
"よせざん 寄せ算"
"よせつ 余接"
"よせなべ 寄せ鍋"
"よせば 寄場"
"よせばし 寄せ箸"
"よせむね 寄棟"
"よせむねづくり 寄棟造"
"よせもと 寄元"
"よせん 豫選 予餞 予戦 予選"
"よせんおち 予選落"
"よせんりーぐ 予選リーグ"
"よぜみ 代ゼミ"
"よぜん 余喘"
"よそ 餘所 余所 他所"
"よそう 豫想 予想"
"よそおい 装 装い"
"よそく 豫測 予測"
"よそじ 四十"
"よそみ よそ見 余所見"
"よそもの よそ者"
"よぞら 夜空"
"よた 世太 与太"
"よたい 預貸"
"よたか 夜鷹"
"よたく 余沢 預託"
"よたり 四人"
"よたろう 四太郎"
"よだ 誉田 余田 与田 依田"
"よだいすう 余代数"
"よだつ 予奪 与奪"
"よだれ 涎"
"よだれかけ 涎掛け"
"よだん 豫斷 餘談 四段 予断 余談"
"よち 余値 豫知 予地 輿地 予知 余地"
"よちむ 予知夢"
"よちょう 余丁 予兆"
"よちょきん 預貯金"
"よっか ４日 翼下 四日"
"よっかい 欲界"
"よっかく 浴客"
"よっきゃく 浴客"
"よっきゅう 欲求"
"よったり 四人"
"よっつ 四つ"
"よって ∴ 依って"
"よっぱらい 酔っぱらい 酔っ払い"
"よっぽど 余っ程"
"よつ 四 四つ"
"よつあし 四つ脚 四つ足 四足"
"よついけ 四ツ池"
"よつかいどう 四街道"
"よつかど 四つ角"
"よつき 四月"
"よつぎ 世継ぎ 世嗣ぎ 世嗣 世継"
"よつぎり 四切 四つ切"
"よつくら 四倉"
"よつだけ 四つ竹"
"よつつじ 四辻"
"よつば 四つ葉 四葉"
"よつぼし 四つ星"
"よつまた 四つ叉 四叉"
"よつみ 四つ身"
"よつめがき 四つ目垣"
"よつや 四ツ谷 四谷"
"よつやなぎ 四柳"
"よつゆ 夜露"
"よつんばい 四つん這い"
"よづめ 余詰"
"よづり 夜釣"
"よてい 豫定 予定"
"よてき 余滴"
"よとう 夜盗 与党"
"よとうむし 夜盗虫"
"よとぎ 夜伽"
"よとく 余徳 余得"
"よど 淀"
"よどえ 淀江"
"よどおし 夜通し"
"よどがわ 淀川"
"よどぎみ 淀君"
"よどしゃこ 淀車庫"
"よどせん 予土線"
"よどばし 淀橋"
"よどみ 澱 澱み 淀み"
"よどみばし 澱橋"
"よどや 淀屋"
"よない 米内"
"よなおし 世直し"
"よなか 夜中"
"よなが 夜長"
"よなき 夜鳴き"
"よなくに 与那国"
"よなぐすく 与那城"
"よなぐに 与那国"
"よなご 米子"
"よなぬき ヨナ抜き"
"よなばる 与那原"
"よなべ 夜なべ"
"よなよな 夜な夜な"
"よにも 世にも"
"よにゅう 預入"
"よにん 四人 余人"
"よね 米"
"よねい 米井"
"よねいちまる 米一丸"
"よねお 米雄"
"よねかわ 米川"
"よねきち 米吉"
"よねくら 米倉"
"よねぐち 米口"
"よねこ 米子"
"よねさかせん 米坂線"
"よねざき 米崎"
"よねざわ 米澤 米沢"
"よねざわぎゅう 米沢牛"
"よねしま 米嶋"
"よねしろがわ 米代川"
"よねじま 米嶋"
"よねず 米酢"
"よねだ 米田"
"よねつ 予熱 余熱"
"よねづ 米津"
"よねなが 米長"
"よねはら 米原"
"よねはる 米春"
"よねばやし 米林"
"よねみつ 米光"
"よねむら 米村"
"よねもと 米本"
"よねもり 米森"
"よねやま 米山"
"よねん 餘念 ４年 四年 余念 余年"
"よの 与野"
"よのう 予納"
"よのうづ 米水津"
"よのじ よノ字"
"よのすけ 世之介"
"よのつね 世の常"
"よのなか 世の中"
"よのならい 世の習い"
"よは 餘波 余波"
"よはい 予輩 余輩"
"よはく 餘白 余白"
"よはねもくしろく ヨハネ黙示録"
"よはらい 預払い"
"よばい 婚 夜這い"
"よばたらき 夜働き"
"よばなし 夜話 夜咄"
"よばわり 呼ばわり"
"よばん 夜番 四番"
"よび 豫備 呼び 予備"
"よびえき 予備役"
"よびかけ 呼掛 呼掛け 呼び掛け"
"よびけい 呼び径"
"よびけん 予備検"
"よびこ 呼子"
"よびすて 呼びすて 呼捨て 呼び捨て"
"よびだし 呼出し 呼出"
"よびつけ 呼付け"
"よびな 呼名 呼び名"
"よびね 呼び値 呼値"
"よびみず 呼び水"
"よびもどし 呼び戻し"
"よびょう 余病"
"よびりん 呼び鈴"
"よふう 余風"
"よふかし 夜更し 夜更かし"
"よふけ 夜更 夜更け"
"よふん 余憤"
"よぶき ヨブ記"
"よぶこ 呼子"
"よぶん 餘分 余聞 余分"
"よへい 余弊 与平"
"よべ 昨夜"
"よほう 豫報 余方 予報"
"よほど 余程"
"よぼう 豫防 輿望 予防"
"よまいごと 世迷い言"
"よまつ 余沫"
"よまつり 夜祭"
"よみ 読み 黄泉"
"よみあげ 読上げ"
"よみあわせ 読合せ"
"よみうり 讀賣 読売"
"よみうりらんど 読売ランド"
"よみがな 読みがな"
"よみきり 読切り 読切"
"よみくだし 訓み下し 読み下し"
"よみこみ 読込み 読込"
"よみせ 夜店"
"よみたに 読谷"
"よみち 夜道"
"よみて 詠み手"
"よみで 読みで"
"よみとり 読取り 読取"
"よみのくに 黄泉国 黄泉の国"
"よみびとしらず 詠人不知"
"よみふだ 読み札"
"よみほん 読本"
"よみもの 読物"
"よみや 夜宮 宵宮"
"よみょう 余命"
"よめ 娵 夜目 嫁"
"よめい 餘命 余命"
"よめいびり 嫁いびり"
"よめいり 嫁入 嫁入り"
"よめえらび 嫁選び"
"よめご 嫁御"
"よめごりょう 嫁御寮"
"よめさん 嫁さん"
"よめしゅうとめ 嫁姑"
"よめじょ 嫁女"
"よめとり 嫁取り"
"よめな 嫁菜"
"よも 四方"
"よもぎ 蒿 艾 蓬"
"よもぎう 蓬生"
"よもぎた 蓬田"
"よもぎだ 蓬田"
"よもぎもち 蓬餅"
"よもすえ 世も末"
"よもすがら 終夜"
"よもつ 黄泉つ"
"よもつくに 黄泉国"
"よもつひらさか 泉津平坂 黄泉比良坂 黄泉平坂"
"よやく 豫約 予約"
"よやくよう 予約要"
"よやす 世安"
"よやとう 与野党"
"よやみ 夜闇"
"よゆう 餘裕 余裕"
"よよ 夜夜 世世 世々 夜々"
"よよぎ 代々木"
"より 依里 和 依 頼 縒 寄"
"よりあい 寄り合い 寄合"
"よりあいがき 寄合書"
"よりあき 頼晶 頼芸 頼明"
"よりい 寄居"
"よりいっそう より一層"
"よりいと 縒り糸"
"よりうど 寄人"
"よりお 頼男"
"よりき 寄木 与力"
"よりきり 寄り切り"
"よりこ 夜梨子 頼子 依子"
"よりしま 寄島"
"よりしろ 憑代 依代"
"よりすぐり 選りすぐり"
"よりせん 縒り線 より線"
"よりたおし 寄り倒し"
"よりちか 頼近"
"よりついせん より対線"
"よりつき 寄付き"
"よりとも 頼朝"
"よりどころ 據 拠所 より所 拠 拠り所"
"よりどり 選り取り"
"よりによって 選りに選って"
"よりぬき 選り抜き"
"よりのぶ 頼信"
"よりびと 寄人"
"よりまし 尸童 憑坐"
"よりみ 寄り身"
"よりみち 寄り道"
"よりめ 寄り目"
"よりゅうど 寄人"
"よりょく 餘力 余力"
"よる 倚 依 夜"
"よるい 余類"
"よるおそく 夜遅く"
"よるがた 夜型"
"よるちゃく 夜着"
"よるひる 夜昼"
"よるべ 寄る辺"
"よるよう 夜用"
"よるよる 夜夜 夜々"
"よれい 余齢 予鈴 予冷"
"よろい 鎧"
"よろいいたちうお 鎧鼬魚"
"よろいざわ 鎧沢"
"よろいせんし 鎧戦士"
"よろいど 鎧戸"
"よろいどおし 鎧通し"
"よろいまど 鎧窓"
"よろいむしゃ 鎧武者"
"よろく 余禄 余録"
"よろけ 蹣跚 蹌踉"
"よろこび 憙 悦び 歓び 慶び 喜び"
"よろしく 宜しく"
"よろず 萬 万"
"よろずちょうほう 万朝報"
"よろずや 万屋"
"よろずやきんのすけ 萬屋錦之介"
"よろぼし 弱法師"
"よろん 餘論 與論 与論 余論 輿論 世論"
"よわ 夜半 余話"
"よわい 弱い 齡 齢"
"よわき 弱気"
"よわごし 弱腰"
"よわたり 世渡り"
"よわね 弱音"
"よわび 弱火"
"よわふくみ 弱含み"
"よわみ 弱み 弱味"
"よわみそ 弱味噌"
"よわむし 弱虫"
"よわめ 弱目"
"よわよわ 弱々"
"よわりめ 弱り目"
"よん ４ 四"
"よんい 四位"
"よんかい 四階"
"よんかんおう 四冠王"
"よんき 四紀"
"よんきゅう 四級 四球"
"よんぎょう 四行"
"よんく 四区 四駆"
"よんけたほう 四桁法"
"よんけん ４研 四研"
"よんこま ４コマ"
"よんこままんが 四コマ漫画"
"よんごう 四合"
"よんさいば 四歳馬"
"よんし 四子"
"よんしゃ 四者"
"よんしょう 四商 四章"
"よんしょうめ 四勝目"
"よんしょく 四色"
"よんじゅう 四十 四重"
"よんじょ 四女"
"よんせい 四声"
"よんたく 四択"
"よんだい 四台 四大"
"よんちゃく 四着"
"よんとう 四島"
"よんとうこく 四等国"
"よんとうごらく 四当五落"
"よんど 四度"
"よんなん 四男"
"よんねん 四年"
"よんのじがため ４の字固め"
"よんぱく 四白"
"よんひき 四匹"
"よんぶ 四部"
"よんぶん 四分"
"よんべ 昨夜"
"よんほん 四本"
"よんほんゆび 四本指"
"よんまい 四枚"
"よんめい ４名 四名"
"よんめん 四面"
"よんもく 四目"
"よんりん 四輪"
"よんわり 四割"
"ら 良 們 拉 騾 螺 邏 蘿 鑼 羅 裸 等"
"らーぱーつぁい 辣白菜"
"らーめん 老麺 拉麺"
"らーめんこうぞう ラーメン構造"
"らーめんてん ラーメン店"
"らーめんや ラーメン屋"
"らーゆ ラー油 辣油"
"らい 徠 來 礼 醴 賚 磊 莱 耒 擂 櫑 儡 罍 蕾 雷 籟 頼 来 癩"
"らいい 来意"
"らいいん 来院"
"らいう 雷雨"
"らいうん 雷雲"
"らいえん 来演 来援"
"らいおう 来往"
"らいか 雷火 来夏"
"らいかい 来会"
"らいかん 来観 雷管 来館"
"らいが 雷牙 来駕"
"らいがく 来学"
"らいき 礼記 来期 来季"
"らいきゃく 来客"
"らいぎょ 雷魚"
"らいけん 来県"
"らいげき 雷撃"
"らいげつ 来月"
"らいげん 来源"
"らいこう 雷汞 来貢 来寇 雷公 雷光 来光 来航 来校"
"らいごう 来降 来迎"
"らいさん 礼讃 礼賛"
"らいさんよう 頼山陽"
"らいしーずん 来シーズン"
"らいしつ 来室"
"らいしゃ 来車 来社"
"らいしゅう 来集 来秋 来襲 来週"
"らいしゅうあたま 来週頭"
"らいしゅん 来春"
"らいしょ 来書 来所"
"らいしょう 来生"
"らいしん 来信 来診"
"らいしんし 頼信紙"
"らいじ 来示"
"らいじゅ 頼樹"
"らいじゅう 雷獣"
"らいじょう 来状 来場"
"らいじん 雷神"
"らいせ 来世"
"らいせい 雷声"
"らいせん 来仙"
"らいせんすけいやく ライセンス契約"
"らいせんすりょう ライセンス料"
"らいそん 来孫"
"らいぞう 頼三"
"らいた 雷太"
"らいたく 来宅"
"らいだん 来談"
"らいちゃく 来着"
"らいちょう 来朝 来聴 雷鳥"
"らいちょうさわ 雷鳥沢"
"らいてい 雷霆 雷帝"
"らいてん 来店"
"らいでん 来電 雷電"
"らいとう 来冬"
"らいときゅう ライト級"
"らいどう 来道 雷同"
"らいなつ 来夏"
"らいにち 来日"
"らいにん 来任"
"らいねん 来年"
"らいねんあき 来年秋"
"らいねんなつ 来年夏"
"らいねんはる 来年春"
"らいはい 礼拝"
"らいはる 来春"
"らいはん 来阪"
"らいばしょ 來場所"
"らいばるいしき ライバル意識"
"らいひん 来賓"
"らいびょう 癩病"
"らいふく 来復"
"らいふるじゅう ライフル銃"
"らいぶかん ライブ感"
"らいぶちゅう ライブ中"
"らいぶちゅうけい ライブ中継"
"らいぶばん ライブ盤"
"らいぶらりかんすう ライブラリ関数"
"らいぶろくおん ライブ録音"
"らいほう 来報 来訪"
"らいむ 来夢"
"らいむぎ ライ麦"
"らいむぎばたけ ライ麦畑"
"らいめい 雷名 雷鳴"
"らいもん 雷文"
"らいゆう 来由 来遊"
"らいらい 磊々 来々"
"らいらいらくらく 磊磊落落 磊々落々"
"らいらく 磊落"
"らいりゅう 雷竜"
"らいりん 来臨"
"らいれき 来歴"
"らいん 莱因"
"らいんすう ライン数"
"らう 羅宇"
"らうす 羅臼"
"らお 羅宇"
"らおご ラオ語"
"らおちゅー 老酒"
"らおちゅう 老酒"
"らおん ラ音"
"らかん 羅漢"
"らかんか 羅漢果"
"らかんちゅう 羅貫中"
"らがん 裸眼"
"らぎょう ら行 ラ行 裸形"
"らく 樂 犖 駱 珞 烙 洛 絡 酪 落 楽"
"らくいちらくざ 楽市楽座"
"らくいん 落胤 烙印"
"らくいんきょ 楽隠居"
"らくえん 楽園"
"らくかん 楽観"
"らくがい 洛外"
"らくがき 楽書き 楽書 落書 落書き"
"らくがきちょう らく書き帳"
"らくがん 落雁"
"らくご 落後 落伍 落語"
"らくさ 落差"
"らくさつ 落札"
"らくさん 酪酸"
"らくざ 楽座"
"らくしゃ 落車"
"らくしゅ 落手 落首"
"らくしょ 洛書 落書"
"らくしょう 酪漿 落照 落掌 楽勝"
"らくしょく 落飾"
"らくじつ 落日"
"らくじょう 落城"
"らくすいそう 落水荘"
"らくせい 落成"
"らくせき 落籍 落石"
"らくせつ 落屑 落雪"
"らくせん 落選"
"らくたい 落体"
"らくたろう 楽太郎"
"らくたん 落胆"
"らくだ 駱駝"
"らくだい 落第"
"らくち 楽地"
"らくちゃく 落着"
"らくちゃわん 楽茶碗"
"らくちゅう 洛中"
"らくちょう 落潮 落丁"
"らくちん 楽珍 楽ちん 楽チン"
"らくぢゃわん 楽茶碗"
"らくてつ 落鉄"
"らくてん 楽天"
"らくてんし 楽天使"
"らくとう 洛東"
"らくど 楽土"
"らくのう 酪農"
"らくはく 落剥 落魄"
"らくはつ 落髪"
"らくば 落馬"
"らくばい 落梅"
"らくばく 落莫"
"らくばん 落磐 落盤"
"らくひつ 落筆"
"らくび 楽日"
"らくほく 洛北"
"らくめい 落命"
"らくやき 楽焼き 楽焼"
"らくよう 落陽 洛陽 落葉"
"らくようじゅ 落葉樹"
"らくらい 落雷"
"らくらく 落落 楽楽 楽々"
"らくるい 落涙"
"らくろうぐん 楽浪郡"
"らぐびーぶ ラグビー部"
"らこく 羅国"
"らし 裸子 螺子"
"らしゃ 羅紗"
"らしゅつ 裸出"
"らしょうもん 羅生門"
"らしん 羅針 裸身"
"らじ 裸耳"
"らじおきょく ラジオ局"
"らじおこうざ ラジオ講座"
"らじおしーえむ ラジオＣＭ"
"らじおしゅつえん ラジオ出演"
"らじおたいそう ラジオ体操"
"らじおちゅうけい ラジオ中継"
"らじおばんぐみ ラジオ番組"
"らじおほうそう ラジオ放送"
"らじかるはんのう ラジカル反応"
"らじょうもん 羅城門"
"らせつ 羅切 羅刹"
"らせん ら旋 螺線 螺旋"
"らそく 裸足"
"らぞう 裸像"
"らたい 裸体"
"らち 埓 拉致 埒"
"らちがい 埒外"
"らっか 落果 落花 落下"
"らっかさん 落下傘"
"らっかん 落款 楽観"
"らっき 落暉"
"らっきゅう 落球"
"らっきょう 楽境 辣韭 辣韮 薤"
"らっこ 猟虎 海獺"
"らっしゅじ ラッシュ時"
"らっせるしゃ ラッセル車"
"らっぱ 喇叭"
"らっぱずいせん 喇叭水仙"
"らっぱのみ 喇叭飲み ラッパ飲み"
"らつ 溂 拉 喇 剌 辣"
"らつわん 辣腕"
"らてんけい ラテン系"
"らてんご ラテン語"
"らてんもじ ラテン文字"
"らでん 螺鈿"
"らぬきことば ら抜き言葉"
"らば 騾馬"
"らふ 裸婦"
"らぶは ラブ波"
"らぶらどるかいりゅう ラブラドル海流"
"らへん ラ変"
"らまーずほう ラマーズ法"
"らまきょう ラマ教"
"らむしゅ ラム酒"
"らむだ Λ λ"
"らむにく ラム肉"
"らめいと ラメ糸"
"らめいり ラメ入り"
"らもん 羅門"
"らりこっぱい 乱離骨灰"
"らりょう 羅綾"
"られつ 羅列"
"らん 亂 婪 嵐 鸞 臠 欒 巒 闌 襴 爛 瀾 纜 繿 襤 籃 欖 檻 攬 懶 嬾 儖 覽 覧 藍 濫 乱 卵 蘭 欄"
"らんい 蘭医"
"らんうん 乱雲"
"らんえ 爛壊"
"らんえき 卵液"
"らんおう 卵黄"
"らんおうのう 卵黄嚢"
"らんおうまく 卵黄膜"
"らんか 爛柯 蘭科"
"らんかい 卵塊"
"らんかく 卵核 濫獲 卵殻 乱獲"
"らんかくまく 卵殻膜"
"らんかつ 卵割"
"らんかつこう 卵割腔"
"らんかん 藍関 卵管 欄干"
"らんかんさい 卵管采"
"らんがい 欄外"
"らんがく 乱学 蘭学"
"らんき 嵐気"
"らんきゅう 卵丘"
"らんぎく 乱菊"
"らんぎょう 乱行"
"らんぎょく 藍玉"
"らんくがい ランク外"
"らんくづけ ランク付け"
"らんぐい 乱杙 乱杭"
"らんぐいば 乱杙歯 乱杭歯"
"らんぐん 乱軍"
"らんけい 鸞鏡 卵形"
"らんげき 乱撃"
"らんげるはんすとう ランゲルハンス島"
"らんこ 蘭子"
"らんこう 乱行 乱交"
"らんこし 蘭越"
"らんこん 乱婚"
"らんご 蘭語"
"らんごく 乱国"
"らんさいぼう 卵細胞"
"らんざつ 乱雑"
"らんざん 乱山 嵐山"
"らんし 卵子 乱視"
"らんしま 蘭島"
"らんしゃ 乱射"
"らんしゅ 乱酒"
"らんしゅう 蘭州"
"らんしょ 蘭書"
"らんしょう 濫觴 卵生"
"らんしょく 卵色 藍色"
"らんしん 乱臣 乱心"
"らんじゃたい 蘭奢待"
"らんじゅ 藍綬"
"らんじゅく 爛熟"
"らんじょ 乱序"
"らんじょう 乱声"
"らんすい 乱酔 嵐翠"
"らんすう 乱数"
"らんせい 卵生 乱世"
"らんせいしょく 藍青色"
"らんせん 乱戦"
"らんぜん 爛然"
"らんそ 濫訴"
"らんそう 乱奏 藍藻 卵巣"
"らんそうがん 卵巣ガン 卵巣がん 卵巣癌"
"らんぞう 乱声 乱造 濫造"
"らんたいせい 卵胎生"
"らんだ 懶惰 乱打"
"らんちき 乱痴気"
"らんちく 蘭竹"
"らんちょう 鸞鳥 蘭蝶 乱丁 乱調"
"らんづみ 乱積み"
"らんていじょ 蘭亭序"
"らんてっこう 藍鉄鉱"
"らんでぃ 蘭泥"
"らんでい 蘭泥"
"らんでん 藍田"
"らんとう 卵塔 乱闘"
"らんどうこう 藍銅鉱"
"らんどく 濫讀 濫読 乱読"
"らんない 欄内"
"らんにゅう 闌入 乱入"
"らんばい 乱売"
"らんばつ 濫伐 乱伐"
"らんぱく 卵白"
"らんぱつ 乱髪 濫発 乱発"
"らんぴ 濫費 乱費"
"らんぴつ 乱筆"
"らんぶ 乱舞"
"らんぶん 乱文"
"らんぶんかつ 卵分割"
"らんぺき 蘭癖 藍碧"
"らんほう 卵胞"
"らんぼう 濫妨 乱妨 乱暴"
"らんぽ 乱歩"
"らんぽう 乱峰 乱邦 鸞鳳 蘭方 卵胞"
"らんぽうほるもん 卵胞ホルモン"
"らんぽん 藍本"
"らんま 乱馬 乱麻 欄間"
"らんまく 卵膜"
"らんまる 蘭丸"
"らんまん 爛漫"
"らんみゃく 乱脈"
"らんもく ラン目"
"らんもん 乱文"
"らんよう 卵用 濫用 乱用"
"らんらん 爛爛 爛々"
"らんり 乱離"
"らんりつ 乱立"
"らんりゅう 乱流"
"らんりょう 蘭領"
"らんりん 乱倫"
"らんる 藍縷 襤褸"
"らんるい 卵類"
"り 驪 詈 莅 籬 漓 悧 俐 莉 痢 梨 璃 罹 履 俚 釐 浬 哩 李 吏 離 里 裡 裏 利 理"
"りー 李"
"りーぐせん リーグ戦"
"りーぐゆうしょう リーグ優勝"
"りーすがいしゃ リース会社"
"りーすけいやく リース契約"
"りーすりょう リース料"
"りーだーかく リーダー格"
"りーち 立直"
"りーどがっき リード楽器"
"りーどせん リード線"
"りあ 里亜"
"りあい 理合い 理合"
"りあおう リア王"
"りあげ 利上げ"
"りあすしきかいがん リアス式海岸"
"りあるたいむしょり リアルタイム処理"
"りいち 理１ 理一 利一"
"りいん 吏員"
"りうまちか リウマチ科"
"りえ リエ 莉英 利栄 利枝 里枝 里恵 理央 里絵 利恵 理絵 理恵"
"りえき 利益"
"りえこ 利江子 理恵子"
"りえん 梨園 離縁"
"りお 理音"
"りおち 利落ち"
"りおな 里緒菜"
"りか 梨果 里花 梨加 理加 利香 利佳 理化 里佳 理香 梨香 里香 里歌 李下 梨花 理科"
"りかい 理会 理解"
"りかく 離角 離隔"
"りかこ 里加子 りか子 理香子 里佳子"
"りかん 離間 罹患"
"りがい 理外 利害"
"りがく 理学"
"りがっか 理学科"
"りがん 離岸"
"りき 理器 篥 理気 利器 力"
"りきいし 力石"
"りきえい 力泳"
"りきえき 力役"
"りきえん 力演"
"りきお 理紀夫 力雄 力男"
"りきかく 力覚"
"りきかん 力感"
"りきがく 力学"
"りきこう 力行"
"りきさく 力作"
"りきし 力士"
"りきしゃ 力車 力者"
"りきせき 力積"
"りきせつ 力説"
"りきせん 力線 力戦"
"りきそう 力漕 力走"
"りきぞう 力蔵"
"りきたけ 力武"
"りきち 利吉"
"りきてん 力点"
"りきてんし 力天使"
"りきとう 力闘 力投"
"りきどう 力動"
"りきどうざん 力道山"
"りきば 力馬 力場"
"りきや 力哉 力也"
"りきゅう 離宮 利休"
"りきゅうねずみ 利休鼠"
"りきゅうばし 利休箸"
"りきょう 離京 離郷"
"りきりつ 力率"
"りきりょう 力量"
"りきん 利金"
"りぎょ 李漁 鯉魚"
"りく 淕 勠 戮 陸"
"りくあげ 陸揚 陸揚げ"
"りくい 陸尉"
"りくいぐあな 陸イグアナ"
"りくう 陸羽"
"りくうん 陸運"
"りくえい 陸影"
"りくえふ 六衛府"
"りくお 陸男"
"りくか 六花"
"りくかい 陸海"
"りくかいくう 陸海空"
"りくかぜ 陸風"
"りくかわ 陸川"
"りくかん 六官"
"りくがわ 陸側"
"りくがん 陸岸"
"りくきょう 陸橋"
"りくぎ 六義"
"りくぐん 陸軍"
"りくけいとう 陸繋島"
"りくけん 陸圏"
"りくこう 陸攻"
"りくこく 六国"
"りくさ 陸佐"
"りくし 陸士"
"りくしき 陸式"
"りくしゅつ 六出"
"りくしゅつか 六出花"
"りくしょ 六書"
"りくしょう 戮笑 陸将 陸相"
"りくじ 陸自"
"りくじょう 陸上"
"りくじょく 戮辱"
"りくすいがく 陸水学"
"りくせい 陸棲 陸生"
"りくせいそう 陸成層"
"りくせん 陸戦"
"りくぜん 陸前"
"りくそう 陸曹 陸送"
"りくぞく 陸続"
"りくたい 六体"
"りくたん 陸単"
"りくだな 陸棚"
"りくち 陸地"
"りくちゅう 陸中"
"りくちょう 六朝"
"りくつ 理屈"
"りくつぜめ 理屈責め"
"りくつづき 陸続き"
"りくでん 陸田"
"りくとう 陸稲"
"りくとうさんりゃく 六韜三略"
"りくとく 六徳"
"りくどう 六道"
"りくな 陸名"
"りくの 陸野"
"りくのことう 陸の孤島"
"りくはんきゅう 陸半球"
"りくふう 陸風"
"りくふうがた 陸封型"
"りくへい 陸兵"
"りくべつ 陸別"
"りくぼつ 戮没"
"りくやね 陸屋根"
"りくよう 陸用"
"りくりょく 戮力"
"りくれん 陸連"
"りくろ 陸路"
"りぐい 利食い"
"りけい 理経 理系"
"りけん 利剣 利権 理研"
"りけんがらみ 利権絡み"
"りげん 理元 俚言 俚諺"
"りげんしゅうらん 俚言集覧"
"りこ 利己"
"りこう 利光 悧口 悧巧 利巧 利口 履行 理工"
"りこん 利根 離婚"
"りこんびょう 離魂病"
"りご 俚語"
"りごう 離合"
"りさ 理佐 里紗 里沙 理沙 梨沙"
"りさい り災 罹災"
"りさげ 利下げ"
"りさこ りさ子"
"りさつ 利札"
"りさぶろう 利三郎"
"りさん 理III 離散"
"りざい 理財"
"りざや 利鞘"
"りし 李四 李斯 利子"
"りしゅ 理趣"
"りしゅう 離愁 履修"
"りしゅきょう 理趣経"
"りしゅたい 利主体"
"りしょう 離昇 離礁 利生 離床"
"りしょうばん 李承晩"
"りしょく 利殖 離職"
"りしり 利尻"
"りしりとう 利尻島"
"りしん 離心"
"りしんろん 理神論"
"りじ 理事"
"りじつ 離日"
"りじゅん 利潤"
"りじょ 犂鋤"
"りじょう 鯉城"
"りじょく 詈辱"
"りじん 利刃 離人"
"りす 栗鼠"
"りすい 離水 理水 利水"
"りすう 理数"
"りすくかんり リスク管理"
"りすけ 理介"
"りすざる 栗鼠猿"
"りすとか リスト化"
"りずむかん リズム感"
"りずむたい リズム隊"
"りせい 離生 理性"
"りせき 離籍 離席"
"りせつ 離接 理説 利雪"
"りせん 離仙 利銭 離船"
"りそう 離層 理想"
"りそく 利足 利息"
"りそなぎんこう りそな銀行"
"りそん 離村"
"りぞーとち リゾート地"
"りぞく 離俗"
"りた 利他"
"りたい 履帯"
"りたつ 利達"
"りだつ 離脱"
"りだん 離断"
"りち 篥 律 理致 理智 理知"
"りちうむでんち リチウム電池"
"りちぎ 律義 律儀"
"りちゅうてんのう 履中天皇"
"りちょう 李朝"
"りっか 立夏"
"りっかん 六官 律管"
"りっきゃく 立客 立脚"
"りっきょう 立教 陸橋"
"りっけん 陸圏 立憲 立件"
"りっこう 六行 立后 立項 力行"
"りっこうほ 立候補"
"りっこく 六国 立国"
"りっし 律詩 律師 立志"
"りっしゃくじ 立石寺"
"りっしゅう 律宗 立秋"
"りっしゅん 立春"
"りっしょう 立哨 立正 立証"
"りっしょく 立食"
"りっしん 立身"
"りっすい 立推 立錐"
"りっすいせん 立水栓"
"りっすいのち 立錐之地 立錐の地"
"りっせき 立席"
"りっせんぽう 律旋法"
"りっそう 律僧"
"りっそく 律速"
"りったい 立体"
"りったいきょう 立体鏡"
"りったいし 立太子"
"りっち 立地"
"りっとう 立東 栗東 立刀 立党 立冬"
"りっとく 六徳"
"りっぱ 立派"
"りっぷく 立腹"
"りっぽう 律法 立方 立法"
"りっぽういん 立法院"
"りっぽうこん 立方根"
"りつ 栗 慄 葎 律 立 率"
"りつあん 立案"
"りつい 立位"
"りつおんかい 律音階"
"りつがん 立願"
"りつき 利付き"
"りつきょう 立教"
"りつぎ 律儀"
"りつけいさん 率計算"
"りつげん 立言"
"りつこ 里葎子 理津子 利津子 りつ子 律子"
"りつご 律語"
"りつじゅん 率順"
"りつぜん 慄然"
"りつぞう 立像"
"りつだい 立大"
"りつどう 律動"
"りつぶん 律文"
"りつめい 立命"
"りつめんず 立面図"
"りつもうきん 立毛筋"
"りつりつ 慄慄 栗栗"
"りつりょう 律令"
"りつりん 栗林"
"りつれい 律令 立礼"
"りつれつ 慄冽"
"りつろん 立論"
"りづめ 理詰 理詰め"
"りてい 里程"
"りていひょう 里程標"
"りてき 理的 利敵"
"りてん 利点"
"りとう 吏党 利刀 離党 離島"
"りとく 利得"
"りとますし リトマス紙"
"りとますしけんし リトマス試験紙"
"りどう 里道"
"りどん 利鈍"
"りな ＲＩＮＡ 梨名 莉菜 梨菜 理奈 里菜 利奈 梨奈 里奈"
"りに 理２"
"りにち 離日"
"りにゅう 離乳"
"りにょう 利尿"
"りにん 離任"
"りねん 理念"
"りねんしつ リネン室"
"りの 梨乃"
"りのーるさん リノール酸"
"りのう 離農"
"りはい 離背"
"りはく 理博 李白"
"りはつ 利発 理髪"
"りはつりく 離発陸"
"りはば 利幅"
"りはびりか リハビリ科"
"りはびりてーしょんか リハビリテーション科"
"りはん 離叛 離反"
"りばけ 理化"
"りばらい 利払い"
"りひ 理非"
"りびょう 痢病 罹病"
"りふ 利府"
"りふく 利福"
"りふじん 理不尽"
"りふだ 利札"
"りふとけん リフト券"
"りぶつ 理物"
"りぶん 利分"
"りへい 利平"
"りべい 離米"
"りべつ 離別"
"りべん 離弁 利便"
"りべんか 離弁花"
"りほ 理保 理穂 里穂"
"りほう 李鵬 理法"
"りほこ 理保子"
"りぼかくさん リボ核酸"
"りぼばらい リボ払い"
"りまわり 利回り"
"りまんかいりゅう リマン海流"
"りみ 梨美"
"りむ 吏務"
"りめん 裡面 裏面"
"りゃく 畧 擽 掠 略"
"りゃくおう 暦応"
"りゃくかい 略解"
"りゃくが 略画"
"りゃくき 略記"
"りゃくぎ 略儀"
"りゃくげ 略解"
"りゃくげん 略言"
"りゃくこう 略光"
"りゃくご 略語"
"りゃくごう 略号"
"りゃくさん 略算"
"りゃくしき 略式"
"りゃくしゅ 略取"
"りゃくしょ 略書"
"りゃくしょう 略章 略称"
"りゃくじ 略字"
"りゃくじゅ 略綬"
"りゃくじゅつ 略述"
"りゃくじょ 略叙"
"りゃくず 略図"
"りゃくせつ 略説"
"りゃくそう 略装"
"りゃくたい 略体"
"りゃくだつ 掠奪 略奪"
"りゃくでん 略伝"
"りゃくにん 暦仁"
"りゃくひつ 略筆"
"りゃくひょう 略表"
"りゃくふ 略譜"
"りゃくふく 略服"
"りゃくほん 略本"
"りゃくぼう 略帽"
"りゃくめい 略名"
"りゃくれき 略歴"
"りゃっかい 略解"
"りゃっき 略記"
"りゃんそう 二索"
"りゃんはんしばり 二翻縛"
"りゃんめん 両面"
"りやく 理薬 利益"
"りゅーいーそー 緑一色"
"りゅーふぁー 緑発"
"りゅう 鏐 瀏 嚠 劉 鉚 柳 旒 硫 琉 苙 粒 立 笠 窿 嶐 隆 餾 霤 瘤 榴 瑠 畄 留 澑 溜 流 龍 竜"
"りゅうあん 劉安 硫安"
"りゅうあんかめい 柳暗花明"
"りゅうあんじ 竜安寺"
"りゅうい 留意"
"りゅういいそう 緑一色"
"りゅういき 流域"
"りゅういち 竜一 龍一 隆一"
"りゅういん 溜飲"
"りゅううん 隆運"
"りゅうおう 龍王 竜王"
"りゅうおん 流音"
"りゅうか 琉歌 流下 硫化"
"りゅうかい 流会"
"りゅうかくさん 龍角散"
"りゅうかてつ 硫化鉄"
"りゅうかどう 硫化銅"
"りゅうかん 流汗 流感"
"りゅうがく 留学"
"りゅうがくびざ 留学ビザ"
"りゅうがさき 龍崎 竜ケ崎 竜崎 竜ヶ崎"
"りゅうがだけ 竜ヶ岳"
"りゅうがん 竜顔 竜眼 龍眼"
"りゅうき 劉貴 竜旗 隆起"
"りゅうきこう 硫気孔"
"りゅうきし 竜騎士"
"りゅうきへい 竜騎兵"
"りゅうきゅう 琉球"
"りゅうきゅういも 琉球芋"
"りゅうきゅうこ 琉球弧"
"りゅうきょう 劉向"
"りゅうきょく 流局"
"りゅうきん 琉金"
"りゅうぎ 流儀"
"りゅうぐう 流寓 竜宮 龍宮"
"りゅうけい 流刑 粒径"
"りゅうけつ 流血"
"りゅうけん 竜権"
"りゅうげ 竜華"
"りゅうげん 流言"
"りゅうこ 竜子 隆子 竜虎 龍虎"
"りゅうこう 流光 劉向 龍宏 隆興 流行"
"りゅうこく 龍谷 竜谷"
"りゅうこつ 竜骨"
"りゅうご 輪鼓 立鼓 龍五 隆吾"
"りゅうさ 流沙 流砂"
"りゅうさん 硫酸"
"りゅうさんだん 榴散弾"
"りゅうさんどう 硫酸銅"
"りゅうざ 竜座"
"りゅうざい 粒剤"
"りゅうざき 竜崎"
"りゅうざん 流竄 竜山 流産"
"りゅうし 粒子"
"りゅうしち 流質"
"りゅうしつ 流失"
"りゅうしゃ 竜車 流沙"
"りゅうしゅつ 流出"
"りゅうしょう 隆昌"
"りゅうしょく 柳色 粒食"
"りゅうじ 隆史 隆司 隆治 竜二 隆二 龍二"
"りゅうじゅ 竜樹 龍樹"
"りゅうじょ 柳絮"
"りゅうじょう 粒状"
"りゅうじょうこ 柳条湖"
"りゅうじょうこし 竜驤虎視"
"りゅうじょうこはく 竜攘虎搏"
"りゅうじん 竜神 龍神"
"りゅうすい 流水"
"りゅうすう 留数"
"りゅうすけ 龍輔 竜助 龍介 竜介 隆介"
"りゅうず 竜頭"
"りゅうせい 隆盛 流星"
"りゅうせいう 流星雨"
"りゅうせいじん 流星塵"
"りゅうせつ 流説"
"りゅうせん 隆線 流涎 流線"
"りゅうせんかく 竜泉閣"
"りゅうぜつらん 龍舌蘭 竜舌蘭"
"りゅうぜん 流涎"
"りゅうぜんこう 竜涎香"
"りゅうそうげん 柳宗元"
"りゅうそうざん 流早産"
"りゅうそく 流束 流速"
"りゅうぞう 龍蔵 竜三 隆三 立像"
"りゅうぞうじ 龍造寺"
"りゅうぞく 流俗"
"りゅうた 竜太 隆太"
"りゅうたい 隆替 流体"
"りゅうたいけん 流体科学研究所"
"りゅうたく 流謫"
"りゅうたつぶし 隆達節"
"りゅうたろう 龍太郎"
"りゅうたん 竜胆"
"りゅうだい 龍大 琉大"
"りゅうだん 榴彈 流弾 榴弾"
"りゅうち 留置"
"りゅうちしゅう 笠智衆"
"りゅうちばり 留置針"
"りゅうちょう 留鳥 流暢"
"りゅうつう 流通"
"りゅうつうまい 流通米"
"りゅうつぼ 立坪"
"りゅうてい 流涕"
"りゅうてき 竜笛 龍笛"
"りゅうでん 流伝 流電"
"りゅうとう 竜党 竜頭"
"りゅうとうだび 龍頭蛇尾 竜頭蛇尾"
"りゅうど 粒度"
"りゅうどう 竜堂 竜童 流動"
"りゅうにち 留日"
"りゅうにゅう 流入"
"りゅうにん 留任"
"りゅうねん 留年"
"りゅうのすけ 竜之介 龍之介"
"りゅうのひげ 竜の鬚"
"りゅうは 流派"
"りゅうばんこきょ 竜蟠虎踞"
"りゅうひょう 流氷"
"りゅうび 柳眉 劉備"
"りゅうびじゅつ 隆鼻術"
"りゅうふう 流風"
"りゅうへい 龍平 流弊"
"りゅうべい 立米"
"りゅうべつ 留別"
"りゅうべん 流眄"
"りゅうほ 留保"
"りゅうほう 隆法 龍鳳 劉邦"
"りゅうほく 竜北"
"りゅうぼう 流氓 流亡"
"りゅうぼく 立木 流木"
"りゅうま 竜馬"
"りゅうみん 流民"
"りゅうめ 竜馬"
"りゅうもん 竜紋 竜文 竜門"
"りゅうよう 柳腰 竜洋 流用"
"りゅうり 流離"
"りゅうりゅう 嚠嚠 嚠々 粒粒 隆隆 粒々 隆々"
"りゅうりょう 流量"
"りゅうりょくかこう 柳緑花紅"
"りゅうるい 流涙"
"りゅうれい 立礼 流麗"
"りゅうれん 流連"
"りゅうれんこうぼう 流連荒亡"
"りゅうろ 流露 流路"
"りゆう 理由"
"りゆうづけ 理由付"
"りょ 踉 膂 閭 絽 梠 呂 侶 虜 慮 旅"
"りょう 楞 聊 靈 霊 喨 亮 嶺 怜 令 鬣 獵 魎 輌 輛 裲 兩 倆 崚 稜 凌 菱 綾 蓼 繆 廖 寥 凉 諒 椋 鷯 鐐 燎 繚 撩 遼 暸 瞭 療 僚 粮 糧 粱 梁 陵 涼 猟 漁 領 良 了 料 寮 両 量"
"りょうあし 両脚 両足"
"りょうあて 寮宛"
"りょうあん 良案 両案"
"りょうあんじ 竜安寺"
"りょうい 良為 稜威 良医 霊異"
"りょういき 領域"
"りょういち 凌一 領一 竜一 龍一 遼一 亮一 良一"
"りょういん 両院"
"りょうう 涼雨"
"りょううで 両腕"
"りょううん 凌雲"
"りょううんしゃ 両運車"
"りょうえき 両駅"
"りょうえん 遼遠 良縁"
"りょうか 良過 良家 涼香 良貨 寮歌 良化 量化"
"りょうかい 領会 領解 両界 諒解 領海 了解"
"りょうかく 稜角"
"りょうかた 両肩 両方"
"りょうかみ 両神"
"りょうかん 寮管 猟官 両艦 僚艦 寮監 良寛 量感 涼感"
"りょうが 凌駕"
"りょうがえ 両替"
"りょうがわ 両側"
"りょうがん 両眼 両岸"
"りょうき 量器 涼気 猟期 僚機 両機 漁期 猟奇"
"りょうきき 両利き"
"りょうきごう 量記号"
"りょうきち 亮吉 良吉"
"りょうきゃく 両脚"
"りょうきょく 両極"
"りょうきん 料金"
"りょうきんばこ 料金箱"
"りょうきんぷらん 料金プラン"
"りょうぎ 両義"
"りょうぎし 両岸"
"りょうくう 領空"
"りょうくちびる 両唇"
"りょうくん 両君"
"りょうぐ 猟具"
"りょうぐん 両群 両軍"
"りょうけ 良家 領家 両家"
"りょうけい 菱形 良計 良形 両系 量刑"
"りょうけつ 良血"
"りょうけつば 良血馬"
"りょうけん 良兼 了簡 料簡 両県 了見 猟犬"
"りょうげ 令外 領解"
"りょうげん 燎原 両舷"
"りょうこ 寮子 領子 凌子 了子 僚子 遼子 量子 亮子 良子 涼子"
"りょうこう 良工 良港 両校 良好"
"りょうこく 両国"
"りょうご 良吾"
"りょうごく 領国 両国"
"りょうごくはなにしきとうし 両国花錦闘士"
"りょうさい 寮祭 良妻"
"りょうさいしい 聊斎志異"
"りょうさいど 両サイド"
"りょうさく 良策 良作"
"りょうさつ 了察"
"りょうさん 量産"
"りょうざい 良剤 梁材 良材"
"りょうざぶろう 量三朗"
"りょうざんぱく 梁山泊"
"りょうし 良之 遼史 良師 両誌 料紙 両市 両氏 猟師 漁師 量子"
"りょうしいろりきがく 量子色力学"
"りょうしき 両式 良識"
"りょうしきのふ 良識の府"
"りょうしつ 良質"
"りょうしゃ 寮舎 両社 両者"
"りょうしゅ 料酒 領取 良種 領主"
"りょうしゅう 涼秋 涼州 領袖 領収"
"りょうしょ 猟書 領所 料所 梁書 良書 両書 両所"
"りょうしょう 諒承 了承"
"りょうしょく 猟色 寮食 糧食"
"りょうしん 両身 両唇 良心 両親"
"りょうしんのじゆう 良心の自由"
"りょうじ 良至 良司 良知 亮治 亮二 良二 良治 両次 療治 令旨 両耳 領事"
"りょうじく 両軸"
"りょうじちかい 寮自治会"
"りょうじちょう 両耳聴"
"りょうじつ 両日"
"りょうじゅう 猟銃"
"りょうじょ 諒恕 梁書"
"りょうじょう 繚繞 梁上"
"りょうじょく 凌辱 陵辱"
"りょうじん 猟人 梁塵 良人"
"りょうじんひしょう 梁塵秘抄"
"りょうすい 領水 量水"
"りょうすう 輛数 両数"
"りょうすけ 遼右 領介 了介 良助 良祐 良介 亮介"
"りょうず 両図"
"りょうせい 両棲 令制 両生 寮生 両性 良性"
"りょうせいか 両性花"
"りょうせいかつ 寮生活"
"りょうせつ 両説"
"りょうせん 両川 両線 僚船 両船 稜線"
"りょうぜつ 両舌"
"りょうぜん 霊山 両全 瞭然"
"りょうそく 両側 寮則"
"りょうそで 両袖"
"りょうぞう 良三"
"りょうぞく 良俗"
"りょうた 良太 亮太"
"りょうたろう 遼太郎"
"りょうたん 両端"
"りょうだめ 両為"
"りょうだん 両断"
"りょうち 料地 領置 良知 了知 領地"
"りょうちょ 良著"
"りょうちょう 猟鳥 寮長"
"りょうちりょうのう 良知良能"
"りょうつ 両津"
"りょうて 両手"
"りょうてい 涼亭 量定 料亭"
"りょうてき 量的"
"りょうでん 菱電"
"りょうと 良図"
"りょうとう 両統 竜頭 両頭 遼東 両刀 両党"
"りょうとうづかい 両刀遣い"
"りょうとく 領得 両得"
"りょうど 両度 領土"
"りょうどう 糧道 領導 両道"
"りょうどなり 両隣"
"りょうない 寮内 領内"
"りょうなん 綾南"
"りょうにん 良人 両人"
"りょうねい 遼寧"
"りょうねん 両年"
"りょうの 稜野"
"りょうのう 菱脳 両脳"
"りょうは 両派"
"りょうはい 両肺"
"りょうはし 両端"
"りょうはじ 両端"
"りょうはん 両班 量販"
"りょうば 猟場 良馬 両馬 両刃 漁場"
"りょうばつきてい 両罰規定"
"りょうばんこきょ 竜蟠虎踞"
"りょうひ 寮費 良否"
"りょうひざ 両膝"
"りょうひつ 良筆"
"りょうひん 良品"
"りょうび 綾美 両備"
"りょうびょう 療病"
"りょうびん 両鬢"
"りょうふ 猟夫 両夫 寮父"
"りょうふう 良風 涼風"
"りょうぶ 両部"
"りょうぶん 領文 両分 領分"
"りょうへい 良平"
"りょうへき 両壁"
"りょうへん 両辺"
"りょうほ 稜堡"
"りょうほう 良法 療法 両方"
"りょうほぞん 量保存"
"りょうぼ 陵墓 寮母"
"りょうま 遼麻 龍馬 竜馬"
"りょうまい 糧米"
"りょうまえ 両前"
"りょうまつ 糧秣"
"りょうみ 涼味"
"りょうみみ 両耳"
"りょうみん 良民 領民"
"りょうむ 寮務"
"りょうめ 竜馬 量目 両目"
"りょうめい 両名"
"りょうめん 両面"
"りょうめんたい 菱面体"
"りょうめんてーぷ 両面テープ"
"りょうめんやき 両面焼"
"りょうもう 両毛"
"りょうもん 良問"
"りょうや ⇔ 涼夜 良夜 領野"
"りょうやく 良薬"
"りょうゆう 領邑 良友 僚友 両雄 領有"
"りょうゆうともにはたたず 両雄倶には立たず 両雄不倶立"
"りょうゆうならびたたず 両雄並び立たず"
"りょうよう 両様 両用 療養"
"りょうよういん 療養院"
"りょうよく 両翼"
"りょうよこ 両横"
"りょうらきんしゅう 綾羅錦繍"
"りょうらん 撩乱 繚乱"
"りょうり 良吏 料理"
"りょうりーぐ 両リーグ"
"りょうりいんしょくとうしょうひぜい 料理飲食等消費税"
"りょうりぢゃや 料理茶屋"
"りょうりつ 両立 料率"
"りょうりゃく 領略"
"りょうりょう 稜稜 喨喨 両両 了了 寥寥 喨々 了々 稜々 両々 寥々"
"りょうりん 両輪"
"りょうれん 寮連"
"りょうろん 両論"
"りょうわき 両脇"
"りょうわん 両腕"
"りょかく 旅客"
"りょかっき 旅客機"
"りょかん 旅館"
"りょがい 慮外"
"りょきゃく 旅客"
"りょきゃっき 旅客機"
"りょぎん 旅銀"
"りょく 仂 緑 力"
"りょくい 緑衣"
"りょくいん 緑陰"
"りょくう 緑雨"
"りょくえき 力役"
"りょくえんとし 緑園都市"
"りょくおうしょく 緑黄色"
"りょくおうやさい 緑黄野菜"
"りょくか 緑化"
"りょくがん 緑眼"
"りょくぎょく 緑玉"
"りょくしきもう 緑色盲"
"りょくしょく 緑色"
"りょくじゅ 緑樹"
"りょくじゅほうしょう 緑綬褒章"
"りょくすい 緑水"
"りょくそう 緑草 緑藻"
"りょくち 緑地"
"りょくちく 緑竹"
"りょくちゃ 緑茶"
"りょくちゅうせき 緑柱石"
"りょくでんか 緑電化"
"りょくとう 緑豆"
"りょくど 緑土"
"りょくないしょう 緑内障"
"りょくのうきん 緑膿菌"
"りょくはつ 緑髪"
"りょくばん 緑礬"
"りょくひ 緑肥"
"りょくふう 緑風"
"りょくべん 緑便"
"りょくもん 緑門"
"りょくや 緑野"
"りょくゆう 緑釉"
"りょくよう 緑葉"
"りょくりん 緑林"
"りょけん 旅券"
"りょこう 閭巷 旅行"
"りょこううかがい 旅行伺"
"りょこうかばん 旅行鞄"
"りょこうずき 旅行好き"
"りょしゅう 虜囚 旅愁"
"りょしゅく 旅宿"
"りょじ 旅次"
"りょじゅん 旅順"
"りょじょう 旅情"
"りょじんぼく 旅人木"
"りょせんぽう 呂旋法"
"りょそう 旅僧 旅装 旅荘"
"りょだん 旅団"
"りょちゅう 旅中"
"りょちょう 旅鳥"
"りょっか 緑化"
"りょっこう 緑光"
"りょてい 旅亭 旅程"
"りょてつ 旅鉄"
"りょてん 旅店"
"りょのう 旅嚢"
"りょひ 旅費"
"りょふ 呂布"
"りょふい 呂不韋"
"りょりつ 呂律"
"りょりょく 膂力"
"りよう 里謡 俚謡 理容 利用"
"りようがかり 利用掛"
"りよく 利欲"
"りよこ 理代子"
"りよん 里昴"
"りらびえ リラ冷え"
"りりーふじん リリーフ陣"
"りりく 離陸"
"りりこ 梨々子"
"りりつ 利率"
"りりょう 吏僚 李陵"
"りりょく 理力"
"りるい 離塁"
"りれーしき リレー式"
"りれき 履歴"
"りろ 理路"
"りろん 理論"
"りん P 鄰 躪 躙 藺 菻 霖 醂 痳 琳 淋 悋 吝 廩 凜 懍 禀 稟 綸 淪 棆 倫 麟 鱗 隣 鈴 臨 輪 林 凛 厘 燐"
"りんあん 燐安"
"りんいち 倫一"
"りんう 霖雨"
"りんうん 鱗雲"
"りんえん 林苑"
"りんか 燐火 輪禍 隣家"
"りんかい 臨界 臨海"
"りんかいせき 燐灰石"
"りんかく 輪廓 輪郭"
"りんかん 輪奐 輪姦 林間"
"りんが 鱗芽 臨画"
"りんがく 林学"
"りんがっか 林学科"
"りんがっかい 林学会"
"りんき 悋気 臨機"
"りんきょうしん 臨教審"
"りんきん 淋菌"
"りんぎ 禀議 稟議"
"りんぎょ 臨御"
"りんぎょう 林業"
"りんくう 臨空"
"りんくさき リンク先"
"りんくしゅう リンク集"
"りんくもと リンク元"
"りんぐがた リング型"
"りんぐじょう リング状 リング上"
"りんけい 鱗形 輪形 鱗茎"
"りんけいきょう 林経協"
"りんけん 臨検 隣県"
"りんげつ 臨月"
"りんげん 綸言"
"りんこ 凛乎"
"りんこう 隣好 臨幸 輪光 燐鉱 燐光 林光 輪行 輪講 臨港"
"りんご 林檎"
"りんごあじ リンゴ味"
"りんごがり りんご狩り"
"りんごく 隣国"
"りんごしゅ りんご酒 リンゴ酒"
"りんごばたけ 林檎畑"
"りんさいぼう 林災防"
"りんさく 輪作"
"りんさん 燐酸 林産 リン酸"
"りんざい 林材 臨在 臨済"
"りんし 臨死"
"りんししつ 燐脂質"
"りんしつ 淋疾 隣室"
"りんしもく 鱗翅目"
"りんしゃ 臨写 倫社"
"りんしゃん 嶺上"
"りんしゃんかいほー 嶺上開花"
"りんしゃんかいほう 嶺上開花"
"りんしゅう 凛秋"
"りんしゅつ 臨出"
"りんしょ 臨書"
"りんしょう 臨牀 林鐘 輪唱 林床 臨床"
"りんしょく 吝嗇"
"りんしん 禀申 凛森 稟申"
"りんじ 綸旨 臨時"
"りんじく 輪軸"
"りんじにゅーす 臨時ニュース"
"りんじやとい 臨時雇い"
"りんじゅう 臨終"
"りんじょう 鱗状 臨場 輪状"
"りんじん 隣人"
"りんず 綾子 綸子"
"りんせい 稟請 輪生 林政"
"りんせき 隣席 臨席"
"りんせつ 鱗屑 隣接"
"りんせん 林泉 臨川 臨戦"
"りんせんじばん 臨川寺版"
"りんぜん 凛然"
"りんそん 隣村"
"りんたい 輪帯"
"りんたいさく 倫対策"
"りんたく 輪タク"
"りんち 隣地 林地"
"りんちょう 臨調"
"りんてん 輪転"
"りんと 凛と"
"りんどう 竜胆 林道"
"りんどうか リンドウ科"
"りんどうもく リンドウ目"
"りんどく 輪読"
"りんない 林内"
"りんね 輪廻"
"りんばつ 輪伐"
"りんばん 輪番"
"りんぱ 淋巴 琳派"
"りんぱえき リンパ液"
"りんぱかん リンパ管"
"りんぱきゅう リンパ球"
"りんぱけい リンパ系"
"りんぱしゅ リンパ腫"
"りんぱせつ リンパ節"
"りんぱせん リンパ腺"
"りんびょう 淋病"
"りんぴ 燐肥"
"りんぴょうとうしゃかいちんれつざいぜん 臨兵鬪者皆陳列在前"
"りんぶ 輪舞"
"りんぶん 林分"
"りんぷん 鱗粉"
"りんぺん 鱗片"
"りんぼ 臨模"
"りんぼく 鱗木"
"りんぽ 隣保"
"りんぽう 隣邦"
"りんぽん 臨本"
"りんむ 林務"
"りんも 臨模"
"りんもう 厘毛 鱗毛"
"りんや 林野"
"りんゆうがく 林邑楽"
"りんらく 淪落"
"りんり 淋漓 倫理"
"りんりつ 林立"
"りんりん 凜凜 凛凛 凜々 凛々"
"りんれつ 凜冽 凛烈 凛冽"
"りんわしつ 輪話室"
"る 畄 陋 琉 流 留 屡 璢 瑠 褸 婁 鏤 縷"
"るーと √"
"るーぶるびじゅつかん ルーブル美術館"
"るーまにあ 羅馬尼"
"るーるいはん ルール違反"
"るーんもじ ルーン文字"
"るい 泪 壘 瑠維 留衣 瑠偉 羸 縲 瘰 誄 涙 累 塁 類"
"るいえき 涙液"
"るいえん 類苑 類縁"
"るいおんご 類音語"
"るいか ルイ華 類火 誄歌 類歌 累加"
"るいがいねん 類概念"
"るいぎ 類義"
"るいく 類句"
"るいけい 類形 類型 累計"
"るいげつ 累月"
"るいげん 累減"
"るいこ ルイ子"
"るいご 類語"
"るいさん 累算 類纂"
"るいざん 累算"
"るいしゅう 類集"
"るいしょ 類書"
"るいしょう 類症 類焼"
"るいしん 塁審 累進"
"るいじ 類字 累次 類似"
"るいじつ 累日"
"るいじゃく 羸弱"
"るいじゅ 類従 類聚"
"るいじゅう 類従 類聚"
"るいじょう 累乗 塁上"
"るいじょうこん 累乗根"
"るいじんえん 類人猿"
"るいすい 類推"
"るいせい 累世"
"るいせき 累積"
"るいせん 涙腺"
"るいそん 累損"
"るいぞう 累増"
"るいぞく 類族"
"るいたいろん 類体論"
"るいだ 塁打"
"るいだい 類題 累代"
"るいてき 類的"
"るいとも 類友"
"るいどう 類同"
"るいねん 累年"
"るいのう 涙嚢"
"るいはん 類板 累犯"
"るいひ 類比"
"るいへき 塁壁"
"るいべつ 類別"
"るいらん 累卵"
"るいるい 累類 累累 累々"
"るいれい 類例"
"るいれき 瘰癧"
"るいわ 累和"
"るか 流花"
"るかでん ルカ伝"
"るけい 流刑"
"るこく 鏤刻"
"るこつ 鏤骨"
"るざい 流罪"
"るざん 流竄"
"るしゃなぶつ 盧遮那仏 盧舎那仏"
"るす 留守"
"るすい 留守居"
"るすつ 留寿都"
"るすでん 留守電"
"るせつ 縷説 流説"
"るそん 呂宋"
"るそんすけざえもん 呂宋助左衛門"
"るたく 流謫"
"るつこ 路津子"
"るつぼ 坩堝"
"るてん 流転"
"るでん 流伝"
"るにん 流人"
"るねさんすようしき ルネサンス様式"
"るびーいろ ルビー色"
"るびつき ルビ付 ルビ付き"
"るふ 流布"
"るべーぐせきぶん ルベーグ積分"
"るべしべ 留辺蕊"
"るべつ 留別"
"るみ 留実 流美 瑠美 留美"
"るみこ るみ子 留美子"
"るみん 流民"
"るもい 留萌"
"るり 瑠璃"
"るりがわら 瑠璃瓦"
"るりこ 留理子 ルリ子 るり子 瑠璃子"
"るりびたき 瑠璃鶲"
"るる 縷縷 縷々"
"るろう 流浪"
"るろうのたみ 流浪の民"
"るん ♪"
"るんびにえん ルンビニ園"
"れーざーこう レーザー光"
"れーざこう レーザ光"
"れーすあみ レース編み"
"れーすちゅう レース中"
"れーべるめん レーベル面"
"れい 祈 靈 蠡 茘 櫺 隸 隷 禮 醴 糲 癘 勵 励 砺 蛎 黎 犁 犂 綟 唳 戻 驪 儷 麗 鴒 蛉 聆 羚 澪 囹 齡 齢 鈴 苓 玲 怜 嶺 伶 冷 令 〇 零 霊 礼 例"
"れいあんしつ 霊安室"
"れいあんじょ 冷暗所"
"れいい 霊威"
"れいいき 霊域"
"れいいち 鈴一"
"れいう 冷雨"
"れいうん 嶺雲"
"れいえき 霊液"
"れいえん 霊園"
"れいか 玲花 霊化 隷下 麗香 麗華 冷菓 零下 冷夏"
"れいかい 冷灰 例解 霊界 例会"
"れいかく 冷覚"
"れいかん 伶官 冷寒 冷感 冷汗 霊感"
"れいかんあつえん 冷間圧延"
"れいかんたんぞう 冷間鍛造"
"れいがい 冷害 例外"
"れいがく 礼楽"
"れいがん 冷眼"
"れいき 癘気 霊鬼 霊亀 冷機 霊気 励起 冷気 例規"
"れいきゃく 冷却"
"れいきゅう 霊柩"
"れいきょりしゃげき 零距離射撃"
"れいきん 礼金"
"れいぎ 礼儀"
"れいく 麗句"
"れいぐう 礼遇 冷遇"
"れいけい 令兄 令閨"
"れいけつ 冷血"
"れいけつかん 冷血漢"
"れいけん 霊剣 霊験"
"れいげつ 例月"
"れいげん 冷源 例言 霊言 冷厳 霊験"
"れいげんてんのう 霊元天皇"
"れいげんどうし 霊幻道士"
"れいこ 祈子 玲香 怜子 令子 麗子 礼子 玲子 例挙"
"れいこう 冷光 霊光 励行"
"れいこく 例刻 冷酷"
"れいこん 霊魂"
"れいさい 零歳 例祭 零細"
"れいざん 霊山"
"れいし 令姉 令史 令嗣 麗姿 令旨 茘枝 霊視 霊芝"
"れいしき 零式 礼式"
"れいしつ 麗質 令室"
"れいしゃ 礼者"
"れいしゅ 冷酒"
"れいしょ 冷処 令書 冷所 隷書"
"れいしょう 醴漿 冷床 霊障 例証 冷笑"
"れいしょく 冷色 令色 冷食"
"れいしん 励振"
"れいじ 怜二 零次 禮二 礼仁 玲二 玲司 零士 例示 零時"
"れいじつ 例日"
"れいじゅう 霊獣 隷従"
"れいじょう 礼譲 令状 礼状 令嬢 霊場"
"れいじろう 霊次郎 令二朗 礼二郎"
"れいじん 伶人 霊神 麗人"
"れいじんそう 伶人草"
"れいすい 霊水 冷水"
"れいず 例図"
"れいせい 令婿 励声 霊性 冷製 冷静"
"れいせき 霊跡"
"れいせつ 例説 礼節"
"れいせん 零戰 霊泉 冷泉 零戦 冷戦"
"れいぜい 冷泉"
"れいぜいいん 冷泉院"
"れいぜん 冷然 霊前"
"れいそう 霊草 礼装"
"れいそく 令息"
"れいそん 令孫"
"れいぞう 冷蔵"
"れいぞうこ 冷藏庫"
"れいぞく 隸屬 隷属"
"れいたい 冷帯 霊体"
"れいたいさい 例大祭"
"れいたつ 令達"
"れいたん 冷鍛 冷淡"
"れいだい 霊代 例題"
"れいだん 冷暖"
"れいだんじち 冷暖自知"
"れいち 霊智 霊地"
"れいちゃ 冷茶"
"れいちょう 霊長"
"れいてい 令弟"
"れいてき 霊的"
"れいてつ 冷徹"
"れいてとう レイテ島"
"れいてん 冷点 礼典 零点"
"れいとう 冷凍"
"れいとねりあもく レイトネリア目"
"れいど 零度"
"れいな 伶奈 玲奈 麗奈"
"れいにく 冷肉 霊肉"
"れいにゅう 戻入"
"れいねつ 冷熱"
"れいねん 例年"
"れいの 例の"
"れいのう 霊能"
"れいのるずすう レイノルズ数"
"れいはい 霊牌 零敗 礼拝"
"れいはん 冷飯"
"れいば 冷罵"
"れいばい 霊媒 冷媒"
"れいひつ 麗筆"
"れいひょう 冷評"
"れいびょう 霊猫 霊廟"
"れいふう 零封 冷風"
"れいふうせん 冷風扇"
"れいふく 礼服"
"れいふじん 令夫人"
"れいぶん 令聞 麗文 礼文 例文"
"れいぷま レイプ魔"
"れいへい 例幣"
"れいほう 礼砲 霊宝 礼法 霊峰"
"れいほん 零本"
"れいぼう 麗貌 礼帽 冷房"
"れいぼうこう 礼奉公"
"れいぼく 零墨 霊木"
"れいまい 令妹"
"れいまいり 礼参り"
"れいみ 麗美"
"れいむ 霊夢"
"れいめい 令名 黎明"
"れいめん 冷麺"
"れいもつ 礼物"
"れいや 麗也"
"れいやく 霊薬"
"れいゆうかい 霊友会"
"れいよう 麗容 羚羊"
"れいようしゅ 冷用酒"
"れいよし 零余子"
"れいらく 零落"
"れいり 伶俐 怜悧"
"れいりょう 冷涼"
"れいりょく 霊力"
"れいろう 玲瓏"
"れいわ 例話 令和"
"れおな 玲央名 玲於奈"
"れき 鬲 靂 轣 癧 櫪 瀝 檪 轢 礫 暦 歴"
"れきがん 礫岩"
"れきげつ 暦月"
"れきさつ 轢殺"
"れきさん 暦算"
"れきし 轢死 歴史"
"れきしょ 暦書"
"れきじ 歴事"
"れきじつ 暦日"
"れきすう 暦数"
"れきせい 歴世 瀝青"
"れきせん 歴戦"
"れきぜん 歴然"
"れきだい 歴代"
"れきだいほうあん 歴代宝案"
"れきだん 轢断"
"れきちゅう 暦注"
"れきちょう 歴朝"
"れきてい 歴程"
"れきど 礫土"
"れきにん 歴任"
"れきねん 歴年 暦年"
"れきねんれい 暦年齢"
"れきはく 歴博"
"れきひょう 暦表"
"れきぶ 暦部"
"れきほう 暦法 歴訪"
"れきほん 暦本"
"れきもと 暦本"
"れきゆう 歴遊"
"れきれき 歴歴 歴々"
"れぎゅらーばんぐみ レギュラー番組"
"れこーどがいしゃ レコード会社"
"れこーどてん レコード店"
"れこーどや レコード屋"
"れしぴぼん レシピ本"
"れじおねらきん レジオネラ菌"
"れじよこ レジ横"
"れすきゅーたい レスキュー隊"
"れすちおもく レスチオ目"
"れすりんぐぶ レスリング部"
"れち 裂"
"れちくるざ レチクル座"
"れっか 列火 裂果 烈火 劣化"
"れっかーしゃ レッカー車"
"れっかい 裂開"
"れっかいか 裂開果"
"れっかうらん 劣化ウラン"
"れっかうらんだん 劣化ウラン弾"
"れっき 劣機 礫器 列記"
"れっきと 歴と"
"れっきょ 列挙"
"れっきょう 列強"
"れっこう 列侯 裂肛"
"れっこく 列国"
"れっし 列子 烈士"
"れっしゃ 列車"
"れっしょう 裂傷"
"れっしん 烈震"
"れっすんしつ レッスン室"
"れっせい 冽清 列星 列聖 劣性 劣勢"
"れっせき 列席"
"れっそう 裂創"
"れっちゅう 列柱"
"れっとう 劣等 列島"
"れっぱ 裂破"
"れっぱい 劣敗"
"れっぱく 裂帛"
"れっぱん 列藩"
"れっぴん 列品"
"れっぷ 烈夫 烈婦"
"れっぷう 烈風"
"れっぷく 列福"
"れっぺん 裂片"
"れつ 洌 冽 裂 烈 劣 列"
"れつあく 劣悪"
"れつい 列位 劣位"
"れつくうかん 列空間"
"れつご 劣後"
"れつごさい 劣後債"
"れつざ 列座"
"れつじつ 烈日"
"れつじゃく 劣弱"
"れつじょ 烈女"
"れつじょう 劣情"
"れつじょでん 列女伝"
"れつたんい 列単位"
"れつだい 列代"
"れつでん 列伝"
"れつなみ 列並"
"れつばんごう 列番号"
"れつべくとる 列ベクトル"
"れつめ 列目"
"れつりつ 列立"
"れつりろん 列理論"
"れつれつ 冽冽 烈烈 冽々 烈々"
"れてん レ点"
"れとるとしょくひん レトルト食品"
"れな 玲奈"
"ればさし レバ刺し"
"ればにらいため レバニラ炒め"
"れぶん 礼文"
"れぶんとう 礼文島"
"れべるさ レベル差"
"れみ 礼美"
"れむすいみん レム睡眠"
"れもん 檸檬"
"れもんあじ レモン味"
"れもんいろ レモン色"
"れもんじる レモン汁"
"れもんすい レモン水"
"れもんに レモン煮"
"れん 輦 憐 瀲 斂 奩 匳 臠 攣 戀 鏈 縺 嗹 蓮 漣 錬 練 煉 濂 簾 廉 鎌 聨 聯 恋 連"
"れんあい 憐愛 恋愛"
"れんあいうん 恋愛運"
"れんあいし 恋愛詩"
"れんおん 連音"
"れんか 連枷 連歌 恋歌 廉価"
"れんかん 聯関 連環 連関"
"れんが 連火 連歌 煉瓦"
"れんがづくり レンガ造り"
"れんがべい 煉瓦塀"
"れんき 練気 連記"
"れんきゅう 連休"
"れんきゅうあけ 連休明"
"れんきょ 蓮炬"
"れんきん 錬金"
"れんぎ 連木"
"れんぎょう 連翹"
"れんぎん 連吟 連銀"
"れんく 連句"
"れんぐん 連軍"
"れんけい 聯係 連繋 連系 連係 連携"
"れんけいぷれー 連携プレー"
"れんけつ 廉潔 連結"
"れんげ 蓮花 蓮華"
"れんげざ 蓮華坐"
"れんげそう 蓮華草"
"れんげん ∧ 連言"
"れんげんし 連言肢"
"れんこ 連呼"
"れんこう 簾鉤 攣拘 連衡 連行"
"れんこうあし 練行足"
"れんこん 蓮根"
"れんご 連碁 連語"
"れんごう 聯合 連合"
"れんごく 煉獄"
"れんさ 連鎖"
"れんさい 連載"
"れんさく 連作"
"れんさつ 憐察"
"れんざ 蓮座 連坐 連座"
"れんざぶろう 錬三郎"
"れんざん 連産 連山"
"れんし 連枝 連詩"
"れんしゃ 連写 連射"
"れんしゅ 連取"
"れんしゅう 練習"
"れんしゅく 攣縮"
"れんしょ 連署"
"れんしょう 連勝"
"れんじ 蓮司 櫺 連子 櫺子 連辞"
"れんじく 連軸"
"れんじだい レ