webpackJsonp([12],{

/***/ 150:
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*
 This file is part of TALER
 (C) 2017 Inria

 TALER is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 TALER is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const wxApi_1 = __webpack_require__(2);
const React = __webpack_require__(1);
const ReactDOM = __webpack_require__(3);
class CurrencyList extends React.Component {
    constructor(props) {
        super(props);
        const port = chrome.runtime.connect();
        port.onMessage.addListener((msg) => {
            if (msg.notify) {
                console.log("got notified");
                this.update();
            }
        });
        this.update();
        this.state = {};
    }
    update() {
        return __awaiter(this, void 0, void 0, function* () {
            const currencies = yield wxApi_1.getCurrencies();
            console.log("currencies: ", currencies);
            this.setState({ currencies });
        });
    }
    confirmRemoveAuditor(c, a) {
        return __awaiter(this, void 0, void 0, function* () {
            if (window.confirm(`Do you really want to remove auditor ${a.baseUrl} for currency ${c.name}?`)) {
                c.auditors = c.auditors.filter((x) => x.auditorPub !== a.auditorPub);
                yield wxApi_1.updateCurrency(c);
            }
        });
    }
    confirmRemoveExchange(c, e) {
        return __awaiter(this, void 0, void 0, function* () {
            if (window.confirm(`Do you really want to remove exchange ${e.baseUrl} for currency ${c.name}?`)) {
                c.exchanges = c.exchanges.filter((x) => x.baseUrl !== e.baseUrl);
                yield wxApi_1.updateCurrency(c);
            }
        });
    }
    renderAuditors(c) {
        if (c.auditors.length === 0) {
            return React.createElement("p", null, "No trusted auditors for this currency.");
        }
        return (React.createElement("div", null,
            React.createElement("p", null, "Trusted Auditors:"),
            React.createElement("ul", null, c.auditors.map((a) => (React.createElement("li", null,
                a.baseUrl,
                " ",
                React.createElement("button", { className: "pure-button button-destructive", onClick: () => this.confirmRemoveAuditor(c, a) }, "Remove"),
                React.createElement("ul", null,
                    React.createElement("li", null,
                        "valid until ",
                        new Date(a.expirationStamp).toString()),
                    React.createElement("li", null,
                        "public key ",
                        a.auditorPub))))))));
    }
    renderExchanges(c) {
        if (c.exchanges.length === 0) {
            return React.createElement("p", null, "No trusted exchanges for this currency.");
        }
        return (React.createElement("div", null,
            React.createElement("p", null, "Trusted Exchanges:"),
            React.createElement("ul", null, c.exchanges.map((e) => (React.createElement("li", null,
                e.baseUrl,
                " ",
                React.createElement("button", { className: "pure-button button-destructive", onClick: () => this.confirmRemoveExchange(c, e) }, "Remove")))))));
    }
    render() {
        const currencies = this.state.currencies;
        if (!currencies) {
            return React.createElement("span", null, "...");
        }
        return (React.createElement("div", { id: "main" }, currencies.map((c) => (React.createElement("div", null,
            React.createElement("h1", null,
                "Currency ",
                c.name),
            React.createElement("p", null,
                "Displayed with ",
                c.fractionalDigits,
                " fractional digits."),
            React.createElement("h2", null, "Auditors"),
            React.createElement("div", null, this.renderAuditors(c)),
            React.createElement("h2", null, "Exchanges"),
            React.createElement("div", null, this.renderExchanges(c)))))));
    }
}
function main() {
    ReactDOM.render(React.createElement(CurrencyList, null), document.getElementById("container"));
}
document.addEventListener("DOMContentLoaded", main);


/***/ })

},[150]);
//# sourceMappingURL=auditors-bundle.js.map