# GNU Taler Wallet WebExtension

1) Checkout the version on the GIT workspace
2) On the root of the project folder run `make webextension` it MUST complete successfully
3) Open both stores before starting any submission
4) You should have a new tag and a clean workspace and a TAG
  a) Latest tag can be queried by: 'git tag --list --sort=-version:refname | head -n1'
  b) Update version names: './contrib/bump-taler-version.mjs 1.0.31'
  c) Commit changes and then tag with the version (check the v before the number): 'git tag v1.0.31'
  d) Push with tags: 'git push --tags'

## Firefox Add-On Store

https://addons.mozilla.org/en-US/developers/addons

Add-on URL: https://addons.mozilla.org/en-US/firefox/addon/taler-wallet/
Addon name: taler-wallet

The manifest V2 wallet needs to be uploaded.

4) Upload the v2 zipfile. ($ROOT/packages/taler-wallet-webextension/extension/v2/taler-wallet-webextension-<version>.zip)
5) You will be asked if the source is minified, you should answer "yes".
6) You will be asked to upload the source code. Run `make dist`
7) Upload the tar.gz file in the root folder. ($ROOT/taler-wallet-<version>.tar.gz)
8) Complete the changelog. You can review that using `git log <current-version>..<next-version> --pretty=oneline --abbrev-commit --stat  -- packages/taler-wallet-webextension/`

## Google Chrome Web Store

https://chrome.google.com/webstore/devconsole

Add-on URL: https://chromewebstore.google.com/detail/gnu-taler-wallet/millncjiddlpgdmkklmhfadpacifaonc
ItemID: millncjiddlpgdmkklmhfadpacifaonc
Publisher: taler-developers@googlegroups.com

The manifest V3 wallet needs to be uploaded.

4) Go to Build -> Package. Click on "upload new package"
5) Upload the v3 zipfile. ($ROOT/packages/taler-wallet-webextension/extension/v3/taler-wallet-webextension-<version>.zip)
6) Go to Store listing -> Submit for review.


# iOS App

https://apps.apple.com/app/taler-wallet/id6463440117

By convention, the version in parentheses is the wallet-core version.

# Android App

https://play.google.com/store/apps/details?id=net.taler.wallet
