--
-- This file is part of TALER
-- Copyright (C) 2025 Taler Systems SA
--
-- TALER is free software; you can redistribute it and/or modify it under the
-- terms of the GNU General Public License as published by the Free Software
-- Foundation; either version 3, or (at your option) any later version.
--
-- TALER is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
-- A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License along with
-- TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
--

-- @file merchant-0024.sql
-- @brief Create table to store MFA related information
-- @author Christian Grothoff


BEGIN;

-- Check patch versioning is in place.
SELECT _v.register_patch('merchant-0024', NULL, NULL);

SET search_path TO merchant;

ALTER TABLE merchant_instances
  ADD COLUMN default_refund_delay INT8 NOT NULL DEFAULT 1296000000; -- 15 days

COMMENT ON COLUMN merchant_instances.default_refund_delay
  IS 'How long are refunds possible for orders by default for this instance';

COMMIT;
