/*
 * Copyright (C) 1999, 2000, 2001, 2002  Lorenzo Bettini <bettini@gnu.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

// htmlgeneratorfactory.cc

#include "htmlgeneratorfactory.h"

#include "html_chartranslator.h"
#include "htmldecorator.h"
#include "htmltags.h"

HtmlGeneratorFactory::HtmlGeneratorFactory(bool line_number) :
  GeneratorFactory (line_number)
{
}

TextDecorator *
HtmlGeneratorFactory::createBoldDecorator(TextGenerator *gen)
{
  return new TagDecorator( gen, char_translator, BOLD_TAG ) ;
}

TextDecorator *
HtmlGeneratorFactory::createItalicDecorator(TextGenerator *gen)
{
  return new TagDecorator( gen, char_translator, ITALIC_TAG ) ;
}

TextDecorator *
HtmlGeneratorFactory::createUnderlineDecorator(TextGenerator *gen)
{
  return new TagDecorator( gen, char_translator, UNDERLINE_TAG ) ;
}

TextDecorator *
HtmlGeneratorFactory::createColorDecorator(TextGenerator *gen, char *color)
{
  return new ColorDecorator( gen, char_translator, color ) ;
}

CharTranslator *
HtmlGeneratorFactory::createCharTranslator()
{
  return new HtmlCharTranslator ();
}
