#ifndef lint
static char conf_yysccsid[] = "@(#)yaccpar	1.8 (Berkeley) 01/20/90";
#endif
#define YYBYACC 1
#line 20 "./config.y"
	#ifndef lint
	static char rcsid[] = 
	"@(#) $Id: config.y,v 1.8 2001/03/12 11:49:37 gray Exp $";
	#endif

	#ifdef HAVE_CONFIG_H
	# include <config.h>
	#endif

        #include <sys/types.h>
        #include <sys/socket.h>
        #include <sys/time.h>
        #include <sys/stat.h>
        #include <netinet/in.h>

        #include <stdio.h>
        #include <stdlib.h>
        #include <netdb.h>
        #include <ctype.h>
        #include <fcntl.h>
        #include <errno.h>
        #include <unistd.h>
	#include <syslog.h> 
        #include <radiusd.h>

        #define YYMAXDEPTH 16

#ifdef USE_SNMP
	typedef struct netlist Netlist;
	struct netlist {
		Netlist *next;
		char *name;
		ACL *acl;
	};
	static Netlist *netlist;
#endif

	struct facility {
		int number;
		char string[256];
	};

	#define CT_CHANNEL 1
	#define CT_OPTIONS 2
	#define CT_LEVEL   3
	
        #define AT_ANY    0
        #define AT_INT    1
	#define AT_STRING 2
	#define AT_IPADDR 3
	#define AT_BOOL   4

	typedef struct {
		char *name;
		int type;
		void *base;
		int once;
	} Variable;
		
	typedef struct {
		char name[256];
		int type;
		union {
			char string[256];
			UINT4 ipaddr;
			int number;
			int bool;
		} v;
	} Asgn;

	static char *typestr[] = {
		"any",
		"numeric",
		"string",
		"IP address",
		"boolean"
	};

	static struct keyword *xlat_tab;
	
	static struct keyword syslog_facility[] = {
		"user", 	LOG_USER,
		"daemon", 	LOG_DAEMON,
		"auth", 	LOG_AUTH,
		"local0", 	LOG_LOCAL0,
		"local1", 	LOG_LOCAL1,
		"local2", 	LOG_LOCAL2,
		"local3", 	LOG_LOCAL3,
		"local4", 	LOG_LOCAL4,
		"local5", 	LOG_LOCAL5,
		"local6", 	LOG_LOCAL6,
		"local7", 	LOG_LOCAL7,
		0
	};

	struct keyword syslog_severity[] = {
		"emerg", 	LOG_EMERG,
		"alert", 	LOG_ALERT,
		"crit", 	LOG_CRIT,
		"err", 		LOG_ERR,
		"warning", 	LOG_WARNING,
		"notice", 	LOG_NOTICE,
		"info", 	LOG_INFO,
		"debug", 	LOG_DEBUG,
		0
	};
	
	struct keyword log_tab[] = {
		"auth",        		RLOG_AUTH,
		"pass",        		RLOG_AUTH_PASS,
		"failed_pass", 		RLOG_FAILED_PASS,
		"pid",         		RLOG_PID,
		0
	};

	static struct keyword loglevels[] = {
		"debug",  		L_DBG, 
		"info",   		L_INFO,
		"notice", 		L_NOTICE,
		"warning", 		L_WARN,
		"error", 		L_ERR,
		"crit",  		L_CRIT,
		"auth",  		L_AUTH,
		"crit",  		L_CRIT,
		0
	};

	static struct keyword log_options[] = {
		"cons", 		LO_CONS,
		"pid", 			LO_PID,
		"level", 		LO_LEVEL,
		0
	};
		
	Variable top_vars[] = {
		"source-ip", AT_IPADDR, &myip, 1,
		"usr2delay", AT_INT,    &config.delayed_hup_wait, 0,
		"max-requests", AT_INT, &config.max_requests, 0,
		"log-dir", AT_STRING, &radlog_dir, 1,
		"acct-dir", AT_STRING, &radacct_dir, 1,
		"exec-program-user", AT_STRING, &config.exec_user, 0,
		"exec-program-group", AT_STRING, &config.exec_group, 0,
		NULL
	};

#ifdef USE_NOTIFY
	Variable notify_vars[] = {
		"host",      AT_IPADDR, &notify_cfg.ipaddr,           0,
		"port",      AT_INT,    &notify_cfg.port,             0,
		"retry",     AT_INT,    &notify_cfg.retry,            0,
		"delay",     AT_INT,    &notify_cfg.timeout,          0,
                NULL,
	};
#endif

	Variable auth_vars[] = {
		"port", AT_INT, &auth_port, 1,

		"spawn", AT_BOOL,
		&request_class[R_AUTH].spawn, 0,
		
		"time-to-live", AT_INT,
		&request_class[R_AUTH].ttl, 0,

		"max-requests", AT_INT,
		&request_class[R_AUTH].max_requests, 0,

		"request-cleanup-delay", AT_INT,
		&request_class[R_AUTH].cleanup_delay, 0,

		"detail", AT_BOOL, &auth_detail, 0,
		"strip-names", AT_BOOL, &strip_names, 0,

		"checkrad-assume-logged", AT_BOOL, 
		&config.checkrad_assume_logged, 0,

		NULL
	};

	Variable acct_vars[] = {
		"port", AT_INT, &acct_port, 1,

		"spawn", AT_BOOL,
		&request_class[R_ACCT].spawn, 0,

		"time-to-live", AT_INT,
		&request_class[R_ACCT].ttl, 0,

		"max-requests", AT_INT,
		&request_class[R_ACCT].max_requests, 0,

		"request-cleanup-delay", AT_INT,
		&request_class[R_ACCT].cleanup_delay, 0,

		NULL
	};

	Variable cntl_vars[] = {
		"port", AT_INT,	&cntl_port, 1,
		NULL
	};

	Variable proxy_vars[] = {
		"max-requests", AT_INT,
		&request_class[R_PROXY].max_requests, 0,

                "request-cleanup-delay", AT_INT,
                &request_class[R_PROXY].cleanup_delay, 0,
	};
		
#ifdef USE_SNMP	
	Variable snmp_vars[] = {
		"spawn", AT_BOOL,
		&request_class[R_SNMP].spawn, 0,

		"time-to-live", AT_INT,
		&request_class[R_SNMP].ttl, 0,

		"max-requests", AT_INT,
		&request_class[R_SNMP].max_requests, 0,

                "request-cleanup-delay", AT_INT,
                &request_class[R_SNMP].cleanup_delay, 0,

		"port", AT_INT, &snmp_port, 1,
		NULL
	};
#endif
	
	extern time_t delayed_hup_wait;
	
	static char *filename;
	static char line_num;
	static char *buffer;
	static char *curp;
	static int tie_in;
	static int in_debug;
	
	static Channel channel;
	
	static void skipws();
	static void skipline();
	static int isword(int c);
	static void copy_alpha();
	static void copy_string();
	static int copy_digit();
	static int keyword();
	static int decode_syslog(struct keyword *tab, char *what, struct facility *value);

	Variable * find_var(Variable *var, char *name);
	void do_asgn(Variable *varlist, Asgn *asgn);

        static void print_log_mode();

#ifdef USE_SNMP
        static char * ident_string(char *);
	static void add_netlist(char *name, ACL *list);
	static void free_netlist();
     	static ACL *find_netlist(char*);
	static int str2access(char*); 
#endif

	static int conf_yylex();
	static void putback(char *tok, int length);

	static int first_time = 1;
	static int debug_config;
#line 289 "./config.y"
typedef union {
	char string[256];
	char *sptr;
	int number;
	int bool;
	UINT4 ipaddr;
	Asgn asgn;
	struct {
		int severity;
	} category;
	struct facility facility;
	struct {
		int type;
		Chanlist *chanlist;
		int options;
		int level;
	} category_def;
#ifdef USE_SNMP
	struct {
		ACL *head, *tail;
	} netlist;
	ACL *acl;
#else
	int netlist, acl;
#endif
} YYSTYPE;
#line 301 "config.c"
#define EOL 257
#define T_NOTIFY 258
#define T_USEDBM 259
#define T_LOGGING 260
#define T_IDENT 261
#define T_CATEGORY 262
#define T_OPTION 263
#define T_CHANNEL 264
#define T_LEVEL 265
#define T_SYSLOG 266
#define T_FILE 267
#define T_DEBUG_LEVEL 268
#define T_HOST 269
#define T_PORT 270
#define T_AUTH 271
#define T_ACCT 272
#define T_CNTL 273
#define T_PROXY 274
#define T_SNMP 275
#define T_NETWORK 276
#define T_ACL 277
#define T_ALLOW 278
#define T_DENY 279
#define T_COMMUNITY 280
#define T_NUMBER 281
#define T_IPADDR 282
#define T_STRING 283
#define T_BOOL 284
#define YYERRCODE 256
short conf_yylhs[] = {                                        -1,
    0,    0,   22,   22,   24,   24,   24,   23,   23,   23,
   23,   23,   23,   23,   23,   23,   26,   34,   34,   34,
   35,   36,   36,   29,   37,   37,   30,   38,   38,   32,
   39,   39,   31,   40,   40,   25,   41,   41,   42,   42,
   42,   42,   43,    4,    4,   45,   45,   46,   46,   46,
   46,   19,   19,   44,   14,   13,   13,   13,   20,   20,
   20,   21,   47,   21,   49,   21,   48,   48,   50,   50,
   15,   15,   16,   17,   17,   18,   28,   27,   27,   51,
   51,   51,   52,   52,   33,    5,    5,    8,    8,    6,
    6,    7,   53,   53,   53,   54,   55,   55,   55,   55,
   55,   55,   56,   57,   57,   57,   58,   59,   59,   11,
   11,   11,   12,   12,   12,   12,    2,    1,    1,    3,
    3,   10,    9,    9,
};
short conf_yylen[] = {                                         2,
    1,    2,    1,    2,    1,    2,    2,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    4,    1,    2,    3,
    2,    1,    1,    4,    2,    3,    4,    2,    3,    4,
    2,    3,    4,    2,    3,    4,    1,    2,    1,    2,
    2,    2,    5,    1,    1,    1,    2,    1,    3,    5,
    3,    1,    1,    5,    1,    1,    1,    1,    1,    2,
    3,    3,    0,    4,    0,    4,    1,    3,    1,    3,
    1,    3,    1,    1,    3,    1,    2,    4,    2,    1,
    2,    3,    2,    1,    4,    1,    1,    3,    1,    1,
    2,    1,    1,    2,    3,    2,    0,    2,    1,    3,
    3,    1,    4,    1,    2,    3,    2,    3,    2,    2,
    1,    1,    1,    1,    1,    1,    2,    1,    1,    1,
    3,    2,    1,    1,
};
short conf_yydefred[] = {                                      0,
    0,    5,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    3,    8,    9,   10,   11,   12,
   13,   14,   15,   16,    7,   79,    0,   77,    0,    0,
    0,    0,    0,    0,    0,    0,    4,    6,   84,    0,
    0,    0,  111,  112,    0,    0,   80,    0,   39,    0,
    0,    0,   37,    0,    0,    0,    0,   18,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   99,    0,   93,    0,  102,  118,  120,  117,    0,  123,
  124,  122,  116,  114,  113,  115,  110,   83,    0,   78,
   81,   42,   57,   58,   56,   55,    0,   45,   44,    0,
   36,   38,   40,   41,   21,    0,   17,   19,   25,   24,
    0,   28,   27,    0,   31,   30,    0,   34,   33,    0,
   98,    0,    0,    0,    0,   85,   94,   96,    0,   22,
   23,   82,    0,    0,   20,   26,   29,   32,   35,    0,
    0,   90,    0,    0,    0,  104,    0,  100,   95,  121,
    0,   63,   65,    0,   59,   48,    0,    0,    0,    0,
   46,    0,   91,   92,    0,  109,    0,  103,  105,  107,
    0,    0,    0,    0,   54,   60,   73,    0,   71,   52,
   53,    0,    0,   43,   47,   87,   86,   88,  108,  106,
   62,   76,    0,   74,    0,    0,   67,   61,   51,    0,
    0,   49,   64,    0,    0,   66,    0,   72,    0,   75,
   70,   68,   50,
};
short conf_yydgoto[] = {                                      12,
   78,   43,   79,  100,  188,  141,  165,  142,   82,   44,
   45,   87,   96,   97,  178,  179,  193,  194,  182,  154,
  155,   13,   14,   15,   16,   17,   18,   19,   20,   21,
   22,   23,   24,   57,   58,  132,   60,   62,   64,   66,
   52,   53,   54,   55,  160,  161,  172,  196,  173,  197,
   46,   47,   72,   73,   74,   75,  145,  146,  147,
};
short conf_yysindex[] = {                                   -194,
 -235,    0, -121, -255,  -90,  -79,  -68,  -36,  -35,  -33,
  -27,    0, -194, -206,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, -229,    0, -173, -213,
 -213, -213, -213, -213, -238, -206,    0,    0,    0, -269,
 -246, -189,    0,    0, -160, -117,    0, -159,    0,  -42,
 -259,  -58,    0, -158, -157, -156, -115,    0, -155, -110,
 -154, -100, -153,  -98, -152,  -95, -177, -176,  -15, -174,
    0, -119,    0, -147,    0,    0,    0,    0,   65,    0,
    0,    0,    0,    0,    0,    0,    0,    0, -114,    0,
    0,    0,    0,    0,    0,    0,  -11,    0,    0,  -10,
    0,    0,    0,    0,    0, -114,    0,    0,    0,    0,
 -143,    0,    0, -142,    0,    0, -141,    0,    0, -140,
    0, -164, -218, -163, -114,    0,    0,    0, -162,    0,
    0,    0, -193, -181,    0,    0,    0,    0,    0,   72,
 -164,    0, -161, -161,  -89,    0, -134,    0,    0,    0,
 -151,    0,    0,  -72,    0,    0, -150, -234, -149,  -66,
    0, -208,    0,    0, -148,    0, -114,    0,    0,    0,
 -133, -145, -139,    1,    0,    0,    0,  -43,    0,    0,
    0,   79, -130,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  -41,    0,   67,  -40,    0,    0,    0, -150,
 -234,    0,    0, -145, -136,    0, -139,    0, -128,    0,
    0,    0,    0,
};
short conf_yyrindex[] = {                                      0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  130,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, -126,  136,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0, -126,    0,    0,    0,    0,    0,    0, -111,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0, -248,
 -109,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  -39,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,
};
short conf_yygindex[] = {                                      0,
    0,    0,    0,    0,    0,    0,    3,    8,    0,    0,
  -14,    0,    0,    0,    0,  -44,    0,  -28,  -24,    0,
   11,    0,  149,  165,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  122,  -99,    0,    0,    0,    0,
    0,  128,    0,    0,    0,   21,    0,    0,    0,  -25,
    0,  140,    0,  115,    0,    0,    0,   49,    0,
};
#define YYTABLESIZE 241
short conf_yytable[] = {                                      95,
  200,   27,  204,  207,   69,  126,  135,   90,   89,  107,
  131,   98,   76,   77,  110,   56,   59,   61,   63,   65,
   71,   25,   67,   99,  113,  149,  116,   39,   28,  119,
   40,   41,   29,   89,   80,  168,   81,   68,   69,   40,
   41,   70,   56,   30,   42,  111,  180,  114,  181,  117,
   38,  120,  175,   42,   31,   40,   41,   71,  184,  143,
  144,    1,    2,    3,    4,    5,  101,  190,    6,   42,
  151,  152,  186,  187,  153,  156,    7,    8,    9,   10,
   11,  157,   48,   49,  158,  159,   32,   33,   50,   34,
   51,   83,   84,   85,   86,   35,   88,   92,  103,  104,
  105,  109,  112,  115,  118,  121,  122,  123,  124,  128,
  129,  133,  134,  136,  137,  138,  139,  140,  162,  148,
  150,  164,  170,  191,  201,  198,  202,  205,  213,    1,
   97,  171,  177,  183,  189,    2,  125,  192,   89,   39,
  106,   67,  130,  195,  211,  119,  166,  101,  163,   40,
   41,   40,   41,   40,   41,  208,   68,   69,   40,   41,
   70,   36,   26,   42,  176,   42,  167,   42,   40,   41,
   40,   41,   42,   40,   41,  210,  209,   37,  108,  102,
  185,  212,   42,  174,   42,   91,  127,   42,  143,  144,
  156,  151,  152,  169,    0,  153,  157,   48,   49,  158,
  159,    0,    0,   50,    0,   51,    0,    0,    0,    0,
    0,    0,    0,  199,    0,  203,  206,   69,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   93,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   94,
};
short conf_yycheck[] = {                                      42,
   44,  123,   44,   44,   44,  125,  106,  125,  257,  125,
  125,  271,  282,  283,  125,   30,   31,   32,   33,   34,
   35,  257,  261,  283,  125,  125,  125,  257,  284,  125,
  269,  270,  123,  282,  281,  125,  283,  276,  277,  269,
  270,  280,   57,  123,  283,   60,  281,   62,  283,   64,
  257,   66,  125,  283,  123,  269,  270,   72,  125,  278,
  279,  256,  257,  258,  259,  260,  125,  167,  263,  283,
  264,  265,  281,  282,  268,  257,  271,  272,  273,  274,
  275,  263,  256,  257,  266,  267,  123,  123,  262,  123,
  264,  281,  282,  283,  284,  123,  257,  257,  257,  257,
  257,  257,  257,  257,  257,  283,  283,  123,  283,  257,
   46,  123,  123,  257,  257,  257,  257,  282,   47,  283,
  283,  283,  257,  257,   46,  125,  257,   61,  257,    0,
  257,  283,  283,  283,  283,    0,  256,  283,  256,  257,
  256,  261,  257,  283,  281,  257,  144,  257,  141,  269,
  270,  269,  270,  269,  270,  200,  276,  277,  269,  270,
  280,   13,  284,  283,  154,  283,  256,  283,  269,  270,
  269,  270,  283,  269,  270,  204,  201,   13,   57,   52,
  160,  207,  283,  256,  283,   46,   72,  283,  278,  279,
  257,  264,  265,  145,   -1,  268,  263,  256,  257,  266,
  267,   -1,   -1,  262,   -1,  264,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  257,   -1,  257,  257,  257,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  271,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
  283,
};
#define YYFINAL 12
#ifndef YYDEBUG
#define YYDEBUG 1
#endif
#define YYMAXTOKEN 284
#if YYDEBUG
char *conf_yyname[] = {
"end-of-file",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,"'*'",0,"','",0,"'.'","'/'",0,0,0,0,0,0,0,0,0,0,0,0,0,"'='",0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"'{'",0,"'}'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"EOL",
"T_NOTIFY","T_USEDBM","T_LOGGING","T_IDENT","T_CATEGORY","T_OPTION","T_CHANNEL",
"T_LEVEL","T_SYSLOG","T_FILE","T_DEBUG_LEVEL","T_HOST","T_PORT","T_AUTH",
"T_ACCT","T_CNTL","T_PROXY","T_SNMP","T_NETWORK","T_ACL","T_ALLOW","T_DENY",
"T_COMMUNITY","T_NUMBER","T_IPADDR","T_STRING","T_BOOL",
};
char *conf_yyrule[] = {
"$accept : input",
"input : list",
"input : list stmt",
"list : line",
"list : list line",
"line : EOL",
"line : stmt EOL",
"line : error EOL",
"stmt : logging_stmt",
"stmt : options_stmt",
"stmt : notify_stmt",
"stmt : usedbm_stmt",
"stmt : auth_stmt",
"stmt : acct_stmt",
"stmt : proxy_stmt",
"stmt : cntl_stmt",
"stmt : snmp_stmt",
"options_stmt : T_OPTION '{' option_list '}'",
"option_list : option",
"option_list : option_list option",
"option_list : option_list error errmark",
"option : asgn_stmt EOL",
"errmark : EOL",
"errmark : '}'",
"auth_stmt : T_AUTH '{' auth_list '}'",
"auth_list : asgn_stmt EOL",
"auth_list : auth_list asgn_stmt EOL",
"acct_stmt : T_ACCT '{' acct_list '}'",
"acct_list : asgn_stmt EOL",
"acct_list : acct_list asgn_stmt EOL",
"cntl_stmt : T_CNTL '{' cntl_list '}'",
"cntl_list : asgn_stmt EOL",
"cntl_list : cntl_list asgn_stmt EOL",
"proxy_stmt : T_PROXY '{' proxy_list '}'",
"proxy_list : asgn_stmt EOL",
"proxy_list : proxy_list asgn_stmt EOL",
"logging_stmt : T_LOGGING '{' logging_list '}'",
"logging_list : logging",
"logging_list : logging_list logging",
"logging : EOL",
"logging : channel_stmt EOL",
"logging : category_stmt EOL",
"logging : error EOL",
"channel_stmt : T_CHANNEL channel_name '{' channel_list '}'",
"channel_name : T_STRING",
"channel_name : T_AUTH",
"channel_list : channel_def",
"channel_list : channel_list channel_def",
"channel_def : EOL",
"channel_def : T_FILE T_STRING EOL",
"channel_def : T_SYSLOG facility '.' facility EOL",
"channel_def : T_OPTION chan_option_list EOL",
"facility : T_NUMBER",
"facility : T_STRING",
"category_stmt : T_CATEGORY category_name '{' category_list '}'",
"category_name : severity",
"severity : '*'",
"severity : T_AUTH",
"severity : T_STRING",
"category_list : category_def",
"category_list : category_list category_def",
"category_list : category_list error '}'",
"category_def : T_CHANNEL T_STRING EOL",
"$$1 :",
"category_def : T_LEVEL $$1 level_list EOL",
"$$2 :",
"category_def : T_DEBUG_LEVEL $$2 debug_level_list EOL",
"debug_level_list : debug_level",
"debug_level_list : debug_level_list ',' debug_level",
"debug_level : T_STRING",
"debug_level : T_STRING '=' T_NUMBER",
"chan_option_list : chan_option",
"chan_option_list : chan_option_list ',' chan_option",
"chan_option : T_STRING",
"level_list : level",
"level_list : level_list ',' level",
"level : T_STRING",
"usedbm_stmt : T_USEDBM T_BOOL",
"notify_stmt : T_NOTIFY '{' notify_list '}'",
"notify_stmt : T_NOTIFY T_BOOL",
"notify_list : notify_def",
"notify_list : notify_list notify_def",
"notify_list : notify_list error errmark",
"notify_def : asgn_stmt EOL",
"notify_def : EOL",
"snmp_stmt : T_SNMP '{' snmp_list '}'",
"netmask : T_IPADDR",
"netmask : T_NUMBER",
"network : T_IPADDR '/' netmask",
"network : T_IPADDR",
"netlist : network",
"netlist : netlist network",
"acl : T_STRING",
"snmp_list : snmp_line",
"snmp_list : snmp_list snmp_line",
"snmp_list : snmp_list error errmark",
"snmp_line : snmp_def EOL",
"snmp_def :",
"snmp_def : T_IDENT T_STRING",
"snmp_def : asgn_stmt",
"snmp_def : T_COMMUNITY T_STRING T_STRING",
"snmp_def : T_NETWORK T_STRING netlist",
"snmp_def : acl_stmt",
"acl_stmt : T_ACL '{' acl_list '}'",
"acl_list : acl_line",
"acl_list : acl_list acl_line",
"acl_list : acl_list error errmark",
"acl_line : acl_def EOL",
"acl_def : T_ALLOW acl T_STRING",
"acl_def : T_DENY acl",
"asgn_stmt : T_STRING value",
"asgn_stmt : host_asgn",
"asgn_stmt : port_asgn",
"value : T_STRING",
"value : T_IPADDR",
"value : T_BOOL",
"value : T_NUMBER",
"host_asgn : T_HOST ipaddr",
"ipaddr : T_IPADDR",
"ipaddr : hostname",
"hostname : T_STRING",
"hostname : hostname '.' T_STRING",
"port_asgn : T_PORT port",
"port : T_NUMBER",
"port : T_STRING",
};
#endif
#define conf_yyclearin (conf_yychar=(-1))
#define conf_yyerrok (conf_yyerrflag=0)
#ifdef YYSTACKSIZE
#ifndef YYMAXDEPTH
#define YYMAXDEPTH YYSTACKSIZE
#endif
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 500
#define YYMAXDEPTH 500
#endif
#endif
int conf_yydebug;
int conf_yynerrs;
int conf_yyerrflag;
int conf_yychar;
short *conf_yyssp;
YYSTYPE *conf_yyvsp;
YYSTYPE conf_yyval;
YYSTYPE conf_yylval;
short conf_yyss[YYSTACKSIZE];
YYSTYPE conf_yyvs[YYSTACKSIZE];
#define conf_yystacksize YYSTACKSIZE
#line 1032 "./config.y"
	   
int
conf_yylex()
{
again:
	skipws();

	if (*curp == '#') { 
		skipline();
		goto again;
	} 
	if (*curp == '/' && curp[1] == '*') {
		int keep_line = line_num;

		curp += 2;
		do {
			while (*curp != '*') {
				if (*curp == 0) {
					radlog(L_ERR, 
                                               _("%s:%d: unexpected EOF in comment started at line %d"),
						filename, line_num, keep_line);
					return 0;
				} else if (*curp == '\n')
					line_num++;
				++curp;
			}
		} while (*++curp != '/');
		++curp;
		goto again;
	}

	if (*curp == 0)
		return 0;
	
	if (isalpha(*curp)) {
		copy_alpha();
		return keyword();
	}

	if (*curp == '\"') {
		copy_string();
		return T_STRING;
	}
	
	if (isdigit(*curp)) {
		if (copy_digit()) {
			/* IP address */
			conf_yylval.ipaddr = ipstr2long(conf_yylval.string);
			return T_IPADDR;
		}
		conf_yylval.number = strtol(conf_yylval.string, NULL, 0);
		return T_NUMBER;
	} 

	if (*curp == ';') {
		curp++;
		return EOL;
	}
	
	return *curp++;
}

void
putback(tok, length)
	char *tok;
	int length;
{
	if (length > curp - buffer) {
		radlog(L_CRIT, 
                       _("INTERNAL ERROR parsing %s near %d: out of putback space"),
			filename, line_num);
		return;
	}	
	while (length--)	
		*--curp = tok[length];		
}

void
skipws()
{
	while (*curp && isspace(*curp)) {
		if (*curp == '\n')
			line_num++;
		curp++;
	}
}

void
skipline()
{
	while (*curp && *curp != '\n')
		curp++;
}

int
isword(c)
	int c;
{
	return isalnum(c) || c == '_' || c == '-';
}

void
copy_alpha()
{
	char * p = conf_yylval.string;
	
	do {
		if (p >= conf_yylval.string + sizeof(conf_yylval.string)) {
			radlog(L_ERR, _("%s:%d: token too long"),
			    filename, line_num);
			break;
		}
		*p++ = *curp++;
	} while (*curp && isword(*curp));
	*p = 0;
}

void
copy_string()
{
	char * p = conf_yylval.string;
	int quote = *curp++;

	while (*curp) {
		if (*curp == quote) {
			curp++;
			break;
		}
		if (p >= conf_yylval.string + sizeof(conf_yylval.string)) {
			radlog(L_ERR, _("%s:%d: token too long"),
			    filename, line_num);
			break;
		}
		*p++ = *curp++;
	} 
	*p = 0;
}

int
copy_digit()
{
	int dot = 0;
	char *p = conf_yylval.string;

	if (*curp == '0') {
		if (curp[1] == 'x' || curp[1] == 'X') {
			*p++ = *curp++;
			*p++ = *curp++;
		}
	}
	
	do {
		if (p >= conf_yylval.string + sizeof(conf_yylval.string)) {
			radlog(L_ERR, _("%s:%d: token too long"),
			    filename, line_num);
			break;
		}
		if ((*p++ = *curp++) == '.')
			dot++;
	} while (*curp && (isdigit(*curp) || *curp == '.'));
	*p = 0;
	return dot;
}

#ifdef USE_SNMP
static struct keyword accs[] = {
	"ro",         SNMP_RO,
	"read_only",  SNMP_RO,
	"rw",         SNMP_RW,
	"read_write", SNMP_RW,
	0
};

int
str2access(str)
	char *str;
{
	struct keyword *kw;

	for (kw = accs; kw->name; kw++)
		if (strcmp(kw->name, str) == 0)
			return kw->tok;
	return -1;
}
#endif

struct keyword keywords[] = {
	"notify", T_NOTIFY,
	"host", T_HOST,
	"port", T_PORT,
	"file", T_FILE,
	"syslog", T_SYSLOG,
	"category", T_CATEGORY,
	"channel", T_CHANNEL,
	"option", T_OPTION,
/*	"level", T_LEVEL,         Handled separately */
	"usedbm", T_USEDBM,
	"log", T_LOGGING,
	"logging", T_LOGGING,
	"snmp", T_SNMP,
        "ident", T_IDENT,
	"acl", T_ACL,
	"network", T_NETWORK,
	"allow", T_ALLOW,
	"deny", T_DENY,
	"community", T_COMMUNITY,
	"auth", T_AUTH,
	"acct", T_ACCT,
	"cntl", T_CNTL,
	"proxy", T_PROXY,
	0
};

struct keyword booleans[] = {
	"on", 1,
	"off", 0,
	"yes", 1,
	"no", 0,
	0
};


int
keyword()
{
        int tok;

	if (tie_in)
		return T_STRING;

	if (strcmp(conf_yylval.string, "level") == 0) 
		return in_debug ? T_DEBUG_LEVEL : T_LEVEL; 
	/* First, see if this is a keyword */
        if (tok = xlat_keyword(keywords, conf_yylval.string, 0))
	        return tok;
	if ((tok = xlat_keyword(booleans, conf_yylval.string, -1)) != -1) {
                conf_yylval.bool = tok;
	        return T_BOOL;
        }
	return T_STRING;
}


void
print_log_mode()
{
	struct keyword *kw;
	char buf[128];

	if (debug_config) {
		buf[0] = 0;
		for (kw = log_tab; kw->name; kw++) {
			if (log_mode & kw->tok) {
				strcat(buf, " ");
				strcat(buf, kw->name);
			}
		}
		radlog(L_DBG, "log:%s", buf);
	}
}

int
get_config()
{
	struct stat st;
	int fd;
	extern int conf_yydebug;

	filename = mkfilename(radius_dir, RADIUS_CONFIG);
	if (stat(filename, &st)) {
		radlog(L_ERR|L_PERROR, _("can't stat `%s'"), filename);
		efree(filename);
		return -1;
	}
	fd = open(filename, O_RDONLY);
	if (fd == -1) {
		if (errno != ENOENT)
			radlog(L_ERR|L_PERROR, 
				_("can't open config file `%s'"), filename);
		efree(filename);
		return -1;
	}
	buffer = emalloc(st.st_size+1);
	
	read(fd, buffer, st.st_size);
	buffer[st.st_size] = 0;
	close(fd);
	curp = buffer;

	
#ifdef USE_SNMP
        snmp_free_communities();
	snmp_free_acl();
#endif

	radlog(L_INFO, _("reading %s"), filename);
	line_num = 1;

	if (strncmp(curp, "#debug", 6) == 0) {
/* Note: can't check YYDEBUG here, because some yaccs (namely, sun's)
 *       define YYDEBUG after including code block
 */	
#if defined(YACC_DEBUG)
		conf_yydebug = 1;
#else
		radlog(L_WARN,
		    _("%s:%d: #debug ignored: radiusd compiled without parser debugging support"),
		    filename, line_num);
#endif
		debug_config = 1;
	} else {
#if defined(YACC_DEBUG)
		conf_yydebug = 0;
#endif
		debug_config = 0;
	}

	/*
	 * Initialize logging module. Add logging to stdout if we
	 * have not yet detached from console.
	 */
	log_init();
	if (first_time)
		log_stdout();
	
	/* Parse configuration */
	conf_yyparse();

	/* Clean up the things */
	efree(filename);
	efree(buffer);
	log_done();
	
#ifdef USE_SNMP
	free_netlist();
#endif

	first_time = 0;
        radlog(L_INFO, _("ready"));
	return 0;
}	

Variable *
find_var(var, name)
	Variable *var;
	char *name;
{
	for (; var->name; var++)
		if (strcmp(var->name, name) == 0)
			return var;
	return NULL;
}

void
do_asgn(varlist, asgn)
	Variable *varlist;
	Asgn *asgn;
{
	Variable *var;
	
	var = find_var(varlist, asgn->name);
	if (!var) {
		radlog(L_ERR, _("%s:%d: variable `%s' undefined"),
		       filename, line_num, asgn->name);
		return;
	}
	if (var->type != asgn->type) {
		radlog(L_ERR, 
                       _("%s:%d: wrong datatype for `%s' (should be %s)"),
		       filename, line_num, asgn->name, typestr[var->type]);
		return;
	}

#define check_once(v, c) \
	if ((v)->once && !first_time && (c))\
		schedule_restart();
	
	switch (var->type) {
	case AT_INT:
		check_once(var, *(int*) var->base != asgn->v.number);
		*(int*) var->base = asgn->v.number;
		break;
	case AT_STRING:
		check_once(var,
			   *(char**)var->base == NULL ||
			   strcmp(*(char**)var->base, asgn->v.string));
		replace_string((char**)var->base, asgn->v.string);
		break;
	case AT_IPADDR:
		check_once(var, *(UINT4*) var->base != asgn->v.ipaddr);
		*(UINT4*) var->base = asgn->v.ipaddr;
		break;
	case AT_BOOL:
		check_once(var, *(int*) var->base != asgn->v.bool);
		*(int*) var->base = asgn->v.bool;
		break;
	default:
		radlog(L_CRIT,
		       _("INTERNAL ERROR at %s:%d: unknown datatype %d, var %p"),
		       __FILE__, __LINE__, var->type, var);
	}
}

#ifdef USE_SNMP

char *
ident_string(str)
	char *str;
{
        return estrdup(str);
}

void
add_netlist(name, list)
	char *name;
	ACL *list;
{
	Netlist *p = emalloc(sizeof(*p));
	p->next = netlist;
	p->name = estrdup(name);
	p->acl = list;
	netlist = p;
}

void
free_netlist()
{
	Netlist *p, *next;

	for (p = netlist; p; ) {
		next = p->next;
		free_acl(p->acl);
		efree(p->name);
		efree(p);
		p = next;
	}
	netlist = NULL;
}

ACL *
find_netlist(name)
	char *name;
{
	Netlist *p;

	for (p = netlist; p; p = p->next)
		if (strcmp(p->name, name) == 0) 
			return p->acl;

	return NULL;
}

#endif

int
decode_syslog(tab, what, value)
	struct keyword *tab;
	char *what;
	struct facility *value;
{
	int val;
	
	if (value->number)
		val = value->number;
	else {
		val = xlat_keyword(tab, value->string, -1);
		if (val == -1) 
			radlog(L_ERR,
			    _("%s:%d: unknown syslog %s: %s"),
			    filename, line_num, what, value->string);
	}
	return val;
}

int
conf_yyerror(s)
	char *s;
{
	radlog(L_ERR, "%s:%d: %s", filename, line_num, s);
}
		


#line 1160 "config.c"
#define YYABORT goto conf_yyabort
#define YYACCEPT goto conf_yyaccept
#define YYERROR goto conf_yyerrlab
int
conf_yyparse()
{
    register int conf_yym, conf_yyn, conf_yystate;
#if YYDEBUG
    register char *conf_yys;
    extern char *getenv();

    if (conf_yys = getenv("YYDEBUG"))
    {
        conf_yyn = *conf_yys;
        if (conf_yyn >= '0' && conf_yyn <= '9')
            conf_yydebug = conf_yyn - '0';
    }
#endif

    conf_yynerrs = 0;
    conf_yyerrflag = 0;
    conf_yychar = (-1);

    conf_yyssp = conf_yyss;
    conf_yyvsp = conf_yyvs;
    *conf_yyssp = conf_yystate = 0;

conf_yyloop:
    if (conf_yyn = conf_yydefred[conf_yystate]) goto conf_yyreduce;
    if (conf_yychar < 0)
    {
        if ((conf_yychar = conf_yylex()) < 0) conf_yychar = 0;
#if YYDEBUG
        if (conf_yydebug)
        {
            conf_yys = 0;
            if (conf_yychar <= YYMAXTOKEN) conf_yys = conf_yyname[conf_yychar];
            if (!conf_yys) conf_yys = "illegal-symbol";
            printf("conf_yydebug: state %d, reading %d (%s)\n", conf_yystate,
                    conf_yychar, conf_yys);
        }
#endif
    }
    if ((conf_yyn = conf_yysindex[conf_yystate]) && (conf_yyn += conf_yychar) >= 0 &&
            conf_yyn <= YYTABLESIZE && conf_yycheck[conf_yyn] == conf_yychar)
    {
#if YYDEBUG
        if (conf_yydebug)
            printf("conf_yydebug: state %d, shifting to state %d\n",
                    conf_yystate, conf_yytable[conf_yyn]);
#endif
        if (conf_yyssp >= conf_yyss + conf_yystacksize - 1)
        {
            goto conf_yyoverflow;
        }
        *++conf_yyssp = conf_yystate = conf_yytable[conf_yyn];
        *++conf_yyvsp = conf_yylval;
        conf_yychar = (-1);
        if (conf_yyerrflag > 0)  --conf_yyerrflag;
        goto conf_yyloop;
    }
    if ((conf_yyn = conf_yyrindex[conf_yystate]) && (conf_yyn += conf_yychar) >= 0 &&
            conf_yyn <= YYTABLESIZE && conf_yycheck[conf_yyn] == conf_yychar)
    {
        conf_yyn = conf_yytable[conf_yyn];
        goto conf_yyreduce;
    }
    if (conf_yyerrflag) goto conf_yyinrecovery;
#ifdef lint
    goto conf_yynewerror;
#endif
conf_yynewerror:
    conf_yyerror("syntax error");
#ifdef lint
    goto conf_yyerrlab;
#endif
conf_yyerrlab:
    ++conf_yynerrs;
conf_yyinrecovery:
    if (conf_yyerrflag < 3)
    {
        conf_yyerrflag = 3;
        for (;;)
        {
            if ((conf_yyn = conf_yysindex[*conf_yyssp]) && (conf_yyn += YYERRCODE) >= 0 &&
                    conf_yyn <= YYTABLESIZE && conf_yycheck[conf_yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (conf_yydebug)
                    printf("conf_yydebug: state %d, error recovery shifting\
 to state %d\n", *conf_yyssp, conf_yytable[conf_yyn]);
#endif
                if (conf_yyssp >= conf_yyss + conf_yystacksize - 1)
                {
                    goto conf_yyoverflow;
                }
                *++conf_yyssp = conf_yystate = conf_yytable[conf_yyn];
                *++conf_yyvsp = conf_yylval;
                goto conf_yyloop;
            }
            else
            {
#if YYDEBUG
                if (conf_yydebug)
                    printf("conf_yydebug: error recovery discarding state %d\n",
                            *conf_yyssp);
#endif
                if (conf_yyssp <= conf_yyss) goto conf_yyabort;
                --conf_yyssp;
                --conf_yyvsp;
            }
        }
    }
    else
    {
        if (conf_yychar == 0) goto conf_yyabort;
#if YYDEBUG
        if (conf_yydebug)
        {
            conf_yys = 0;
            if (conf_yychar <= YYMAXTOKEN) conf_yys = conf_yyname[conf_yychar];
            if (!conf_yys) conf_yys = "illegal-symbol";
            printf("conf_yydebug: state %d, error recovery discards token %d (%s)\n",
                    conf_yystate, conf_yychar, conf_yys);
        }
#endif
        conf_yychar = (-1);
        goto conf_yyloop;
    }
conf_yyreduce:
#if YYDEBUG
    if (conf_yydebug)
        printf("conf_yydebug: state %d, reducing by rule %d (%s)\n",
                conf_yystate, conf_yyn, conf_yyrule[conf_yyn]);
#endif
    conf_yym = conf_yylen[conf_yyn];
    conf_yyval = conf_yyvsp[1-conf_yym];
    switch (conf_yyn)
    {
case 7:
#line 355 "./config.y"
{
			  tie_in = 0;
			  conf_yyclearin; conf_yyerrok;
		  }
break;
case 20:
#line 379 "./config.y"
{
			  conf_yyclearin; conf_yyerrok;
		  }
break;
case 21:
#line 385 "./config.y"
{
			  do_asgn(top_vars, &conf_yyvsp[-1].asgn);
		  }
break;
case 23:
#line 392 "./config.y"
{
			  putback("}", 1);
		  }
break;
case 25:
#line 402 "./config.y"
{
			  do_asgn(auth_vars, &conf_yyvsp[-1].asgn);
		  }
break;
case 26:
#line 406 "./config.y"
{
			  do_asgn(auth_vars, &conf_yyvsp[-1].asgn);
		  }
break;
case 28:
#line 416 "./config.y"
{
			  do_asgn(acct_vars, &conf_yyvsp[-1].asgn);
		  }
break;
case 29:
#line 420 "./config.y"
{
			  do_asgn(acct_vars, &conf_yyvsp[-1].asgn);
		  }
break;
case 31:
#line 430 "./config.y"
{
			  do_asgn(cntl_vars, &conf_yyvsp[-1].asgn);
		  }
break;
case 32:
#line 434 "./config.y"
{
			  do_asgn(cntl_vars, &conf_yyvsp[-1].asgn);
		  }
break;
case 34:
#line 444 "./config.y"
{
			  do_asgn(proxy_vars, &conf_yyvsp[-1].asgn);
		  }
break;
case 35:
#line 448 "./config.y"
{
			  do_asgn(proxy_vars, &conf_yyvsp[-1].asgn);
		  }
break;
case 42:
#line 466 "./config.y"
{
			  tie_in = 0;
			  in_debug = 0;
			  conf_yyclearin;
			  conf_yyerrok;
		  }
break;
case 43:
#line 477 "./config.y"
{
			  if (channel.mode == LM_UNKNOWN) {
				  radlog(L_ERR,
				      _("%s:%d: no channel mode for `%s'"), 
				      	filename, line_num, conf_yyvsp[-3].string);
			  } else {
				  channel.name = conf_yyvsp[-3].string;
				  register_channel(&channel);
				  if (channel.mode == LM_FILE)
					  efree(channel.id.file);
			  }
                  }
break;
case 44:
#line 492 "./config.y"
{
			  channel.mode = LM_UNKNOWN;
		  }
break;
case 45:
#line 496 "./config.y"
{
		  	channel.mode = LM_UNKNOWN;
		  	strcpy(conf_yyval.string, "auth");
		  }
break;
case 49:
#line 508 "./config.y"
{
			  channel.mode = LM_FILE;
			  channel.id.file = estrdup(conf_yyvsp[-1].string);
		  }
break;
case 50:
#line 513 "./config.y"
{
			  int prio, lev;
			  prio = decode_syslog(syslog_facility,
					       "facility", &conf_yyvsp[-3].facility);
			  lev  = decode_syslog(syslog_severity,
					       "severity", &conf_yyvsp[-1].facility);
			  if (prio != -1 && lev != -1) {
				  channel.mode = LM_SYSLOG;
				  channel.id.prio = prio | lev;
			  }
                  }
break;
case 51:
#line 525 "./config.y"
{
			  channel.options = conf_yyvsp[-1].number;
		  }
break;
case 52:
#line 531 "./config.y"
{
			  conf_yyval.facility.number = conf_yyvsp[0].number;
			  conf_yyval.facility.string[0] = 0;
		  }
break;
case 53:
#line 536 "./config.y"
{
			  conf_yyval.facility.number = 0;
			  strcpy(conf_yyval.facility.string, conf_yyvsp[0].string);
		  }
break;
case 54:
#line 545 "./config.y"
{
			  switch (conf_yyvsp[-3].category.severity) {
			  case L_AUTH:
				  log_mode = conf_yyvsp[-1].category_def.level;
				  print_log_mode();
				  break;
			  }
			  in_debug = 0;
			  register_category(conf_yyvsp[-3].category.severity, conf_yyvsp[-1].category_def.chanlist);
		  }
break;
case 55:
#line 558 "./config.y"
{
			  conf_yyval.category.severity = conf_yyvsp[0].number;
			  /* select xlat_tab */
			  switch (conf_yyvsp[0].number) {
			  case L_AUTH:
				  xlat_tab = log_tab;
				  break;
			  case L_DBG:
				  xlat_tab = NULL;
				  in_debug = 1;
				  break;
			  default:
				  xlat_tab = NULL;
			  }
                  }
break;
case 56:
#line 576 "./config.y"
{
			  conf_yyval.number = -1;
		  }
break;
case 57:
#line 580 "./config.y"
{
			  conf_yyval.number = L_AUTH;
		  }
break;
case 58:
#line 584 "./config.y"
{
			  if ((conf_yyval.number = xlat_keyword(loglevels, conf_yyvsp[0].string, -1)) == -1) {
				radlog(L_ERR,
				      _("%s:%d: unknown severity level"),
				      filename, line_num);
				YYERROR;
			  }
		  }
break;
case 60:
#line 596 "./config.y"
{
			  switch (conf_yyvsp[0].category_def.type) {
			  case CT_CHANNEL:
				  conf_yyvsp[0].category_def.chanlist->next = conf_yyvsp[-1].category_def.chanlist;
				  conf_yyvsp[-1].category_def.chanlist = conf_yyvsp[0].category_def.chanlist;
				  break;
			  case CT_LEVEL:
				  conf_yyvsp[-1].category_def.level |= conf_yyvsp[0].category_def.level;
			  }
			  conf_yyval.category_def = conf_yyvsp[-1].category_def;
		  }
break;
case 61:
#line 608 "./config.y"
{
			  /*free_chanlist?*/
			  tie_in = 0;
			  putback("}", 1);
			  conf_yyclearin;
                          conf_yyerrok;  
                  }
break;
case 62:
#line 618 "./config.y"
{
			  Channel *channel;
			  channel = channel_lookup(conf_yyvsp[-1].string);
			  conf_yyval.category_def.level = 0;
			  if (!channel) {
				  radlog(L_ERR,
					 _("%s:%d: channel `%s' not defined"),
					 filename, line_num, conf_yyvsp[-1].string);
				  conf_yyval.category_def.type = 0;
				  conf_yyval.category_def.chanlist = NULL;
			  } else {
				  conf_yyval.category_def.type = CT_CHANNEL;
				  conf_yyval.category_def.chanlist = make_chanlist(channel);
			  }
		  }
break;
case 63:
#line 633 "./config.y"
{ tie_in++; }
break;
case 64:
#line 634 "./config.y"
{
			  tie_in = 0;
			  conf_yyval.category_def.chanlist = NULL;
			  if (xlat_tab) {
				  conf_yyval.category_def.type = CT_LEVEL;
				  conf_yyval.category_def.level = conf_yyvsp[-1].number;
			  } else {
				  conf_yyval.category_def.type = -1;
				  radlog(L_WARN,
					 _("%s:%d: no levels applicable for this category"),
					 filename, line_num);
			  }
		  }
break;
case 65:
#line 647 "./config.y"
{ tie_in++;
		                  clear_debug(); }
break;
case 66:
#line 649 "./config.y"
{
			  tie_in = 0;
		  }
break;
case 69:
#line 659 "./config.y"
{
			  if (set_module_debug_level(conf_yyvsp[0].string, -1))
				  radlog(L_WARN,
					 _("%s:%d: no such module name: %s"),
					 filename, line_num, conf_yyvsp[0].string);
		  }
break;
case 70:
#line 666 "./config.y"
{
			  if (set_module_debug_level(conf_yyvsp[-2].string, conf_yyvsp[0].number))
				  radlog(L_WARN,
					 _("%s:%d: no such module name: %s"),
					 filename, line_num, conf_yyvsp[-2].string);
		  }
break;
case 72:
#line 676 "./config.y"
{
			conf_yyval.number = conf_yyvsp[-2].number | conf_yyvsp[0].number;
		  }
break;
case 73:
#line 682 "./config.y"
{
			 if ((conf_yyval.number = xlat_keyword(log_options, conf_yyvsp[0].string, 0)) == 0)
				radlog(L_ERR, _("%s:%d: unknown option: %s"),
				       filename, line_num, conf_yyvsp[0].string);
                  }
break;
case 75:
#line 693 "./config.y"
{
			  conf_yyval.number = conf_yyvsp[-2].number | conf_yyvsp[0].number;
		  }
break;
case 76:
#line 699 "./config.y"
{
			  if (xlat_tab &&
			      (conf_yyval.number = xlat_keyword(xlat_tab, conf_yyvsp[0].string, 0)) == 0)
				  radlog(L_ERR, _("%s:%d: unknown level: %s"),
				      filename, line_num, conf_yyvsp[0].string);
		  }
break;
case 77:
#line 708 "./config.y"
{
                   #ifdef USE_DBM
			  use_dbm = conf_yyvsp[0].bool;
			  if (debug_config)
				  radlog(L_DBG, _("use dbm: %d"), use_dbm);
		   #else
			  radlog(L_WARN,
				 _("%s:%d: usedbm statement ignored: radiusd compiled without DBM support"),
				 filename, line_num);
                   #endif
		  }
break;
case 78:
#line 722 "./config.y"
{
                   #ifdef USE_NOTIFY
			  if (debug_config)
				  radlog(L_DBG, 
					_("TTL server %I:%d %d, %d sec"),
					 notify_cfg.ipaddr,
					 notify_cfg.port,
					 notify_cfg.retry,
					 notify_cfg.timeout);
		   #else
			  radlog(L_WARN,
				 _("%s:%d: notify statement ignored: radiusd compiled without notification support"),
				 filename, line_num);
                   #endif
		  }
break;
case 79:
#line 738 "./config.y"
{
                   #ifdef USE_NOTIFY
			  if (conf_yyvsp[0].bool == 0) {
				  notify_cfg.ipaddr = notify_cfg.port = 0;
				  if (debug_config)
					  radlog(L_DBG, _("TTL service OFF"));
			  } else {
				  conf_yyerror("syntax error: `off' expected");
			  }
                   #endif
		  }
break;
case 82:
#line 754 "./config.y"
{
			  conf_yyclearin;
                          conf_yyerrok;
		  }
break;
case 83:
#line 761 "./config.y"
{
		   #ifdef USE_NOTIFY 
			  do_asgn(notify_vars, &conf_yyvsp[-1].asgn);
                   #endif
		  }
break;
case 85:
#line 772 "./config.y"
{
		   #ifndef USE_SNMP
			  radlog(L_WARN,
				 _("%s:%d: snmp statement ignored: radiusd compiled without snmp support"),
				 filename, line_num);
		   #endif
		  }
break;
case 87:
#line 783 "./config.y"
{
			  if (conf_yyvsp[0].number > 32) {
				  radlog(L_ERR, _("invalid netmask: %d"), conf_yyvsp[0].number);
				  YYERROR;
			  }
			  conf_yyval.ipaddr = (0xfffffffful >> (32-conf_yyvsp[0].number)) << (32-conf_yyvsp[0].number);
		  }
break;
case 88:
#line 793 "./config.y"
{
                   #ifdef USE_SNMP
			  ACL *p = alloc_entry(sizeof(*p));

			  p->ipaddr = htonl(conf_yyvsp[-2].ipaddr);
			  p->netmask = htonl(conf_yyvsp[0].ipaddr);
			  conf_yyval.acl = p;
                   #endif
		  }
break;
case 89:
#line 803 "./config.y"
{
                   #ifdef USE_SNMP
			  ACL *p = alloc_entry(sizeof(*p));

			  p->ipaddr = htonl(conf_yyvsp[0].ipaddr);
			  p->netmask = 0xfffffffful;
			  conf_yyval.acl = p;
                   #endif
		  }
break;
case 90:
#line 815 "./config.y"
{
                   #ifdef USE_SNMP
			  conf_yyval.netlist.head = conf_yyval.netlist.tail = conf_yyvsp[0].acl;
                   #endif
		  }
break;
case 91:
#line 821 "./config.y"
{
                   #ifdef USE_SNMP
			  conf_yyvsp[-1].netlist.tail->next = conf_yyvsp[0].acl;
			  conf_yyvsp[-1].netlist.tail = conf_yyvsp[0].acl;
			  conf_yyval.netlist = conf_yyvsp[-1].netlist;
                   #endif
		  }
break;
case 92:
#line 831 "./config.y"
{
                   #ifdef USE_SNMP
			  if ((conf_yyval.acl = find_netlist(conf_yyvsp[0].string)) == NULL) {
				  radlog(L_ERR, _("%s:%d: no such acl: %s"),
				      filename, line_num, conf_yyvsp[0].string);
				  YYERROR;
			  }
                   #else
			  conf_yyval.acl = 0;
                   #endif
		  }
break;
case 95:
#line 847 "./config.y"
{
			 conf_yyclearin;
			 conf_yyerrok;
		  }
break;
case 98:
#line 858 "./config.y"
{
                   #ifdef USE_SNMP
                          if (server_id)
			         efree(server_id);
                          server_id = ident_string(conf_yyvsp[0].string);
                   #endif
                  }
break;
case 99:
#line 866 "./config.y"
{
		   #ifdef USE_SNMP
			  do_asgn(snmp_vars, &conf_yyvsp[0].asgn);
		   #endif
		  }
break;
case 100:
#line 872 "./config.y"
{
                   #ifdef USE_SNMP
			  int access;
		     
			  if (snmp_find_community(conf_yyvsp[-1].string)) {
				  radlog(L_ERR,
				      _("%s:%d: community %s already declared"),
				      filename, line_num, conf_yyvsp[-1].string);
			  } else if ((access = str2access(conf_yyvsp[0].string)) == -1) {
				  radlog(L_ERR,
				      _("%s:%d: invalid access mode %s"),
				      filename, line_num, conf_yyvsp[0].string);
			  } else {
				  snmp_add_community(conf_yyvsp[-1].string, access);
			  }
                   #endif
		  }
break;
case 101:
#line 890 "./config.y"
{
                   #ifdef USE_SNMP
			  add_netlist(conf_yyvsp[-1].string, conf_yyvsp[0].netlist.head);
                   #endif
		  }
break;
case 106:
#line 904 "./config.y"
{
			 conf_yyclearin;
			 conf_yyerrok;
		  }
break;
case 108:
#line 914 "./config.y"
{
                   #ifdef USE_SNMP
			  Community *comm = snmp_find_community(conf_yyvsp[0].string);
			  if (!comm) {
				  radlog(L_ERR, 
                                      _("%s:%d: undefined community %s"),
				      filename, line_num, conf_yyvsp[-1].acl);
			  } else
				  snmp_add_acl(conf_yyvsp[-1].acl, comm);
                   #endif
		  }
break;
case 109:
#line 926 "./config.y"
{
                   #ifdef USE_SNMP
			  snmp_add_acl(conf_yyvsp[0].acl, NULL);
                   #endif
		  }
break;
case 110:
#line 935 "./config.y"
{
			  conf_yyval.asgn = conf_yyvsp[0].asgn;
			  strncpy(conf_yyval.asgn.name, conf_yyvsp[-1].string, sizeof(conf_yyval.asgn.name));
			  conf_yyval.asgn.name[sizeof(conf_yyval.asgn.name)-1] = 0;
		  }
break;
case 111:
#line 941 "./config.y"
{
			  strcpy(conf_yyval.asgn.name, "host");
			  conf_yyval.asgn.type = AT_IPADDR;
			  conf_yyval.asgn.v.ipaddr = conf_yyvsp[0].ipaddr;
		  }
break;
case 112:
#line 947 "./config.y"
{
			  strcpy(conf_yyval.asgn.name, "port");
			  conf_yyval.asgn.type = AT_INT;
			  conf_yyval.asgn.v.number = conf_yyvsp[0].number;
		  }
break;
case 113:
#line 955 "./config.y"
{
			  conf_yyval.asgn.type = AT_STRING;
			  strncpy(conf_yyval.asgn.v.string, conf_yyvsp[0].string, sizeof(conf_yyval.asgn.v.string));
			  conf_yyval.asgn.v.string[sizeof(conf_yyval.asgn.v.string)-1] = 0;
		  }
break;
case 114:
#line 961 "./config.y"
{
			  conf_yyval.asgn.type = AT_IPADDR;
			  conf_yyval.asgn.v.ipaddr = conf_yyvsp[0].ipaddr;
		  }
break;
case 115:
#line 966 "./config.y"
{
			  conf_yyval.asgn.type = AT_BOOL;
			  conf_yyval.asgn.v.bool = conf_yyvsp[0].bool;
		  }
break;
case 116:
#line 971 "./config.y"
{
			  conf_yyval.asgn.type = AT_INT;
			  conf_yyval.asgn.v.number = conf_yyvsp[0].number;
		  }
break;
case 117:
#line 980 "./config.y"
{
			  conf_yyval.ipaddr = conf_yyvsp[0].ipaddr;
		  }
break;
case 119:
#line 987 "./config.y"
{
			  if ((conf_yyval.ipaddr = get_ipaddr(conf_yyvsp[0].string)) == (UINT4) 0) {
				  radlog(L_ERR, 
					 _("%s:%d: unknown host: %s"),
					 filename, line_num, conf_yyvsp[0].string);
			  }
		  }
break;
case 121:
#line 998 "./config.y"
{
                          if (strlen(conf_yyvsp[-2].string) + strlen(conf_yyvsp[0].string) + 2 >= sizeof(conf_yyvsp[-2].string)) {
				  radlog(L_ERR, 
					 _("%s:%d: hostname too long"),
					 filename, line_num);
				  YYERROR;
			  }
			  radsprintf(conf_yyval.string, sizeof(conf_yyval.string), "%s.%s", conf_yyvsp[-2].string, conf_yyvsp[0].string);
                  }
break;
case 122:
#line 1010 "./config.y"
{
			  conf_yyval.number = conf_yyvsp[0].number;
		  }
break;
case 124:
#line 1017 "./config.y"
{
			  struct servent *s;
			  s = getservbyname(conf_yyvsp[0].string, "udp");
			  if (s) 
				  conf_yyval.number = ntohs(s->s_port);
			  else {
				  radlog(L_ERR, 
                                         _("%s:%d: no such service: %s"),
					 filename, line_num, conf_yyvsp[0].string);
				  conf_yyval.number = 0;
			  }
		  }
break;
#line 1946 "config.c"
    }
    conf_yyssp -= conf_yym;
    conf_yystate = *conf_yyssp;
    conf_yyvsp -= conf_yym;
    conf_yym = conf_yylhs[conf_yyn];
    if (conf_yystate == 0 && conf_yym == 0)
    {
#if YYDEBUG
        if (conf_yydebug)
            printf("conf_yydebug: after reduction, shifting from state 0 to\
 state %d\n", YYFINAL);
#endif
        conf_yystate = YYFINAL;
        *++conf_yyssp = YYFINAL;
        *++conf_yyvsp = conf_yyval;
        if (conf_yychar < 0)
        {
            if ((conf_yychar = conf_yylex()) < 0) conf_yychar = 0;
#if YYDEBUG
            if (conf_yydebug)
            {
                conf_yys = 0;
                if (conf_yychar <= YYMAXTOKEN) conf_yys = conf_yyname[conf_yychar];
                if (!conf_yys) conf_yys = "illegal-symbol";
                printf("conf_yydebug: state %d, reading %d (%s)\n",
                        YYFINAL, conf_yychar, conf_yys);
            }
#endif
        }
        if (conf_yychar == 0) goto conf_yyaccept;
        goto conf_yyloop;
    }
    if ((conf_yyn = conf_yygindex[conf_yym]) && (conf_yyn += conf_yystate) >= 0 &&
            conf_yyn <= YYTABLESIZE && conf_yycheck[conf_yyn] == conf_yystate)
        conf_yystate = conf_yytable[conf_yyn];
    else
        conf_yystate = conf_yydgoto[conf_yym];
#if YYDEBUG
    if (conf_yydebug)
        printf("conf_yydebug: after reduction, shifting from state %d \
to state %d\n", *conf_yyssp, conf_yystate);
#endif
    if (conf_yyssp >= conf_yyss + conf_yystacksize - 1)
    {
        goto conf_yyoverflow;
    }
    *++conf_yyssp = conf_yystate;
    *++conf_yyvsp = conf_yyval;
    goto conf_yyloop;
conf_yyoverflow:
    conf_yyerror("yacc stack overflow");
conf_yyabort:
    return (1);
conf_yyaccept:
    return (0);
}
