/* definition of the /MAP and /RMAP commands
   Copyright (C) 1992-2000 Michigan State University

   The CAPA system is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CAPA system is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public
   License along with the CAPA system; see the file COPYING.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   As a special exception, you have permission to link this program
   with the TtH/TtM library and distribute executables, as long as you
   follow the requirements of the GNU GPL in regard to all of the
   software in the executable aside from TtH/TtM.
*/

/* ========================================================================== */
/*            capaMapExpr.c    created by Isaac Tsai                       */
/*                                                                         */
/*  this is the main code to handle /MAP() function call in capa */
#include <stdio.h>
#include <string.h>
#include <math.h>

#include "capaParser.h"
#include "capaToken.h"
#include "ranlib.h"


            
/* |>|===============================================================|<| */
int
do_map(seed, varp, argp, argc, dir) 
char *seed; ArgNode_t *varp; ArgNode_t *argp; int argc; int dir;
{
  long        orig_gen, current_gen, seed1, seed2;
  long       *idx_array, *ridx_array;
  int         idx, val;
  Symbol      val_array[ONE_K];
  ArgNode_t  *tmpArgp;
  

  for(idx=0,tmpArgp=argp;idx<argc;idx++) {
    switch( FIRST_ARGTYPE(tmpArgp) ) {
    case I_VAR:
    case I_CONSTANT:
         (val_array[idx]).s_type = I_VAR;
         (val_array[idx]).s_int = FIRST_ARGINT(tmpArgp); break;
    case R_VAR:
    case R_CONSTANT:
         (val_array[idx]).s_type = R_VAR;
         (val_array[idx]).s_real = FIRST_ARGREAL(tmpArgp); break;
    case S_VAR:
    case S_CONSTANT:
         (val_array[idx]).s_type = S_VAR;
         (val_array[idx]).s_str = strsave(FIRST_ARGSTR(tmpArgp)); break;
    default:
         return -1;
	 break;
    }
    tmpArgp =  (tmpArgp->a_next);
  }
  idx_array = (long *)capa_malloc(sizeof(long), argc);
  for(idx=0;idx<argc;idx++) idx_array[idx] = idx;
  gscgn(GET_GENERATOR, &orig_gen);
  current_gen = PERMUTATION_G;
  gscgn(SET_GENERATOR, &current_gen);
  phrtsd(seed, &seed1, &seed2);
  setsd(seed1, seed2);
  genprm(idx_array, (long)argc);
  if(dir == REVERSE_MAP) {
    ridx_array = (long *)capa_malloc(sizeof(long), argc);
    for(idx=0;idx<argc;idx++) {
      ridx_array[ idx_array[idx] ] = idx;
    }
    for(idx=0;idx<argc;idx++) {
      idx_array[idx] = ridx_array[idx];
    }
    capa_mfree((char *)ridx_array);
  }
  for(idx=0,tmpArgp=varp;idx<argc;idx++) {
    val = idx_array[idx];
    switch( FIRST_ARGTYPE(tmpArgp) ) {
      case IDENTIFIER:
      case I_VAR: case I_CONSTANT:
      case R_VAR: case R_CONSTANT: break;
      case S_VAR: case S_CONSTANT: capa_mfree((char *)FIRST_ARGSTR(tmpArgp)); break;
    }
    FIRST_ARGTYPE(tmpArgp) = (val_array[val]).s_type;
    
    switch( val_array[val].s_type ) {
     case I_VAR: FIRST_ARGINT(tmpArgp) =  (val_array[val]).s_int;   break;
     case R_VAR: FIRST_ARGREAL(tmpArgp) = (val_array[val]).s_real;  break;
     case S_VAR: FIRST_ARGSTR(tmpArgp) =  (val_array[val]).s_str;   break;
    }
    tmpArgp = tmpArgp->a_next;
  }
  gscgn(SET_GENERATOR, &orig_gen);
  capa_mfree((char *)idx_array);
  return (0);
}


