/*  Motti -- a strategy game
    Copyright (C) 1999-2010 Free Software Foundation

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#pragma once
#include "Player.h"
#include "Serializer.h"
#include <string>
class Case
{

public:
	enum CASETYPE{
		FREE,
		SELECTED,
		LOCKED,
		NOTUSED

	};
	
	Case(void);
	Case(bool isCityCenter,Player *player,CASETYPE casetype);
	virtual ~Case(void);

	

	CASETYPE getType();
	bool isCityCenter();

	void setCityCenter(bool isCityCenter);

	void setCaseType(CASETYPE casetype);
	void setPlayer( Player *player);
	Player * getPlayer();
	void setPreviousPlayer( Player *player);
	Player * getPreviousPlayer();
	std::string toString();
	bool isColored();
	void setColored(bool );
	friend std::istream& operator>> (std::istream& out, Case& per);
	friend std::ostream& operator<< (std::ostream& out, Case& per);

	friend Serializer& operator>> (Serializer& out, Case& per);
	friend Serializer& operator<< (Serializer& out, Case& per);

	std::string playerName_,previousplayername_;
private:
	bool isCityCenter_;
	CASETYPE casetype_;
	Player *player_;
	Player *previousplayer_;
	bool colored_;
	

};

