#
# This file is part of KoreanCodecs.
#
# Copyright(C) Hye-Shik Chang <perky@FreeBSD.org>, 2002.
#
# KoreanCodecs is free software; you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published
# by the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# KoreanCodecs is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with KoreanCodecs; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# $Id: ksc5601_ideograph.py,v 1.3 2002/07/19 00:01:53 perky Exp $
#

decoding_map = {
'\xca\xa1': u'\u4f3d',
'\xca\xa2': u'\u4f73',
'\xca\xa3': u'\u5047',
'\xca\xa4': u'\u50f9',
'\xca\xa5': u'\u52a0',
'\xca\xa6': u'\u53ef',
'\xca\xa7': u'\u5475',
'\xca\xa8': u'\u54e5',
'\xca\xa9': u'\u5609',
'\xca\xaa': u'\u5ac1',
'\xca\xab': u'\u5bb6',
'\xca\xac': u'\u6687',
'\xca\xad': u'\u67b6',
'\xca\xae': u'\u67b7',
'\xca\xaf': u'\u67ef',
'\xca\xb0': u'\u6b4c',
'\xca\xb1': u'\u73c2',
'\xca\xb2': u'\u75c2',
'\xca\xb3': u'\u7a3c',
'\xca\xb4': u'\u82db',
'\xca\xb5': u'\u8304',
'\xca\xb6': u'\u8857',
'\xca\xb7': u'\u8888',
'\xca\xb8': u'\u8a36',
'\xca\xb9': u'\u8cc8',
'\xca\xba': u'\u8dcf',
'\xca\xbb': u'\u8efb',
'\xca\xbc': u'\u8fe6',
'\xca\xbd': u'\u99d5',
'\xca\xbe': u'\u523b',
'\xca\xbf': u'\u5374',
'\xca\xc0': u'\u5404',
'\xca\xc1': u'\u606a',
'\xca\xc2': u'\u6164',
'\xca\xc3': u'\u6bbc',
'\xca\xc4': u'\u73cf',
'\xca\xc5': u'\u811a',
'\xca\xc6': u'\u89ba',
'\xca\xc7': u'\u89d2',
'\xca\xc8': u'\u95a3',
'\xca\xc9': u'\u4f83',
'\xca\xca': u'\u520a',
'\xca\xcb': u'\u58be',
'\xca\xcc': u'\u5978',
'\xca\xcd': u'\u59e6',
'\xca\xce': u'\u5e72',
'\xca\xcf': u'\u5e79',
'\xca\xd0': u'\u61c7',
'\xca\xd1': u'\u63c0',
'\xca\xd2': u'\u6746',
'\xca\xd3': u'\u67ec',
'\xca\xd4': u'\u687f',
'\xca\xd5': u'\u6f97',
'\xca\xd6': u'\u764e',
'\xca\xd7': u'\u770b',
'\xca\xd8': u'\u78f5',
'\xca\xd9': u'\u7a08',
'\xca\xda': u'\u7aff',
'\xca\xdb': u'\u7c21',
'\xca\xdc': u'\u809d',
'\xca\xdd': u'\u826e',
'\xca\xde': u'\u8271',
'\xca\xdf': u'\u8aeb',
'\xca\xe0': u'\u9593',
'\xca\xe1': u'\u4e6b',
'\xca\xe2': u'\u559d',
'\xca\xe3': u'\u66f7',
'\xca\xe4': u'\u6e34',
'\xca\xe5': u'\u78a3',
'\xca\xe6': u'\u7aed',
'\xca\xe7': u'\u845b',
'\xca\xe8': u'\u8910',
'\xca\xe9': u'\u874e',
'\xca\xea': u'\u97a8',
'\xca\xeb': u'\u52d8',
'\xca\xec': u'\u574e',
'\xca\xed': u'\u582a',
'\xca\xee': u'\u5d4c',
'\xca\xef': u'\u611f',
'\xca\xf0': u'\u61be',
'\xca\xf1': u'\u6221',
'\xca\xf2': u'\u6562',
'\xca\xf3': u'\u67d1',
'\xca\xf4': u'\u6a44',
'\xca\xf5': u'\u6e1b',
'\xca\xf6': u'\u7518',
'\xca\xf7': u'\u75b3',
'\xca\xf8': u'\u76e3',
'\xca\xf9': u'\u77b0',
'\xca\xfa': u'\u7d3a',
'\xca\xfb': u'\u90af',
'\xca\xfc': u'\u9451',
'\xca\xfd': u'\u9452',
'\xca\xfe': u'\u9f95',
'\xcb\xa1': u'\u5323',
'\xcb\xa2': u'\u5cac',
'\xcb\xa3': u'\u7532',
'\xcb\xa4': u'\u80db',
'\xcb\xa5': u'\u9240',
'\xcb\xa6': u'\u9598',
'\xcb\xa7': u'\u525b',
'\xcb\xa8': u'\u5808',
'\xcb\xa9': u'\u59dc',
'\xcb\xaa': u'\u5ca1',
'\xcb\xab': u'\u5d17',
'\xcb\xac': u'\u5eb7',
'\xcb\xad': u'\u5f3a',
'\xcb\xae': u'\u5f4a',
'\xcb\xaf': u'\u6177',
'\xcb\xb0': u'\u6c5f',
'\xcb\xb1': u'\u757a',
'\xcb\xb2': u'\u7586',
'\xcb\xb3': u'\u7ce0',
'\xcb\xb4': u'\u7d73',
'\xcb\xb5': u'\u7db1',
'\xcb\xb6': u'\u7f8c',
'\xcb\xb7': u'\u8154',
'\xcb\xb8': u'\u8221',
'\xcb\xb9': u'\u8591',
'\xcb\xba': u'\u8941',
'\xcb\xbb': u'\u8b1b',
'\xcb\xbc': u'\u92fc',
'\xcb\xbd': u'\u964d',
'\xcb\xbe': u'\u9c47',
'\xcb\xbf': u'\u4ecb',
'\xcb\xc0': u'\u4ef7',
'\xcb\xc1': u'\u500b',
'\xcb\xc2': u'\u51f1',
'\xcb\xc3': u'\u584f',
'\xcb\xc4': u'\u6137',
'\xcb\xc5': u'\u613e',
'\xcb\xc6': u'\u6168',
'\xcb\xc7': u'\u6539',
'\xcb\xc8': u'\u69ea',
'\xcb\xc9': u'\u6f11',
'\xcb\xca': u'\u75a5',
'\xcb\xcb': u'\u7686',
'\xcb\xcc': u'\u76d6',
'\xcb\xcd': u'\u7b87',
'\xcb\xce': u'\u82a5',
'\xcb\xcf': u'\u84cb',
'\xcb\xd0': u'\uf900',
'\xcb\xd1': u'\u93a7',
'\xcb\xd2': u'\u958b',
'\xcb\xd3': u'\u5580',
'\xcb\xd4': u'\u5ba2',
'\xcb\xd5': u'\u5751',
'\xcb\xd6': u'\uf901',
'\xcb\xd7': u'\u7cb3',
'\xcb\xd8': u'\u7fb9',
'\xcb\xd9': u'\u91b5',
'\xcb\xda': u'\u5028',
'\xcb\xdb': u'\u53bb',
'\xcb\xdc': u'\u5c45',
'\xcb\xdd': u'\u5de8',
'\xcb\xde': u'\u62d2',
'\xcb\xdf': u'\u636e',
'\xcb\xe0': u'\u64da',
'\xcb\xe1': u'\u64e7',
'\xcb\xe2': u'\u6e20',
'\xcb\xe3': u'\u70ac',
'\xcb\xe4': u'\u795b',
'\xcb\xe5': u'\u8ddd',
'\xcb\xe6': u'\u8e1e',
'\xcb\xe7': u'\uf902',
'\xcb\xe8': u'\u907d',
'\xcb\xe9': u'\u9245',
'\xcb\xea': u'\u92f8',
'\xcb\xeb': u'\u4e7e',
'\xcb\xec': u'\u4ef6',
'\xcb\xed': u'\u5065',
'\xcb\xee': u'\u5dfe',
'\xcb\xef': u'\u5efa',
'\xcb\xf0': u'\u6106',
'\xcb\xf1': u'\u6957',
'\xcb\xf2': u'\u8171',
'\xcb\xf3': u'\u8654',
'\xcb\xf4': u'\u8e47',
'\xcb\xf5': u'\u9375',
'\xcb\xf6': u'\u9a2b',
'\xcb\xf7': u'\u4e5e',
'\xcb\xf8': u'\u5091',
'\xcb\xf9': u'\u6770',
'\xcb\xfa': u'\u6840',
'\xcb\xfb': u'\u5109',
'\xcb\xfc': u'\u528d',
'\xcb\xfd': u'\u5292',
'\xcb\xfe': u'\u6aa2',
'\xcc\xa1': u'\u77bc',
'\xcc\xa2': u'\u9210',
'\xcc\xa3': u'\u9ed4',
'\xcc\xa4': u'\u52ab',
'\xcc\xa5': u'\u602f',
'\xcc\xa6': u'\u8ff2',
'\xcc\xa7': u'\u5048',
'\xcc\xa8': u'\u61a9',
'\xcc\xa9': u'\u63ed',
'\xcc\xaa': u'\u64ca',
'\xcc\xab': u'\u683c',
'\xcc\xac': u'\u6a84',
'\xcc\xad': u'\u6fc0',
'\xcc\xae': u'\u8188',
'\xcc\xaf': u'\u89a1',
'\xcc\xb0': u'\u9694',
'\xcc\xb1': u'\u5805',
'\xcc\xb2': u'\u727d',
'\xcc\xb3': u'\u72ac',
'\xcc\xb4': u'\u7504',
'\xcc\xb5': u'\u7d79',
'\xcc\xb6': u'\u7e6d',
'\xcc\xb7': u'\u80a9',
'\xcc\xb8': u'\u898b',
'\xcc\xb9': u'\u8b74',
'\xcc\xba': u'\u9063',
'\xcc\xbb': u'\u9d51',
'\xcc\xbc': u'\u6289',
'\xcc\xbd': u'\u6c7a',
'\xcc\xbe': u'\u6f54',
'\xcc\xbf': u'\u7d50',
'\xcc\xc0': u'\u7f3a',
'\xcc\xc1': u'\u8a23',
'\xcc\xc2': u'\u517c',
'\xcc\xc3': u'\u614a',
'\xcc\xc4': u'\u7b9d',
'\xcc\xc5': u'\u8b19',
'\xcc\xc6': u'\u9257',
'\xcc\xc7': u'\u938c',
'\xcc\xc8': u'\u4eac',
'\xcc\xc9': u'\u4fd3',
'\xcc\xca': u'\u501e',
'\xcc\xcb': u'\u50be',
'\xcc\xcc': u'\u5106',
'\xcc\xcd': u'\u52c1',
'\xcc\xce': u'\u52cd',
'\xcc\xcf': u'\u537f',
'\xcc\xd0': u'\u5770',
'\xcc\xd1': u'\u5883',
'\xcc\xd2': u'\u5e9a',
'\xcc\xd3': u'\u5f91',
'\xcc\xd4': u'\u6176',
'\xcc\xd5': u'\u61ac',
'\xcc\xd6': u'\u64ce',
'\xcc\xd7': u'\u656c',
'\xcc\xd8': u'\u666f',
'\xcc\xd9': u'\u66bb',
'\xcc\xda': u'\u66f4',
'\xcc\xdb': u'\u6897',
'\xcc\xdc': u'\u6d87',
'\xcc\xdd': u'\u7085',
'\xcc\xde': u'\u70f1',
'\xcc\xdf': u'\u749f',
'\xcc\xe0': u'\u74a5',
'\xcc\xe1': u'\u74ca',
'\xcc\xe2': u'\u75d9',
'\xcc\xe3': u'\u786c',
'\xcc\xe4': u'\u78ec',
'\xcc\xe5': u'\u7adf',
'\xcc\xe6': u'\u7af6',
'\xcc\xe7': u'\u7d45',
'\xcc\xe8': u'\u7d93',
'\xcc\xe9': u'\u8015',
'\xcc\xea': u'\u803f',
'\xcc\xeb': u'\u811b',
'\xcc\xec': u'\u8396',
'\xcc\xed': u'\u8b66',
'\xcc\xee': u'\u8f15',
'\xcc\xef': u'\u9015',
'\xcc\xf0': u'\u93e1',
'\xcc\xf1': u'\u9803',
'\xcc\xf2': u'\u9838',
'\xcc\xf3': u'\u9a5a',
'\xcc\xf4': u'\u9be8',
'\xcc\xf5': u'\u4fc2',
'\xcc\xf6': u'\u5553',
'\xcc\xf7': u'\u583a',
'\xcc\xf8': u'\u5951',
'\xcc\xf9': u'\u5b63',
'\xcc\xfa': u'\u5c46',
'\xcc\xfb': u'\u60b8',
'\xcc\xfc': u'\u6212',
'\xcc\xfd': u'\u6842',
'\xcc\xfe': u'\u68b0',
'\xcd\xa1': u'\u68e8',
'\xcd\xa2': u'\u6eaa',
'\xcd\xa3': u'\u754c',
'\xcd\xa4': u'\u7678',
'\xcd\xa5': u'\u78ce',
'\xcd\xa6': u'\u7a3d',
'\xcd\xa7': u'\u7cfb',
'\xcd\xa8': u'\u7e6b',
'\xcd\xa9': u'\u7e7c',
'\xcd\xaa': u'\u8a08',
'\xcd\xab': u'\u8aa1',
'\xcd\xac': u'\u8c3f',
'\xcd\xad': u'\u968e',
'\xcd\xae': u'\u9dc4',
'\xcd\xaf': u'\u53e4',
'\xcd\xb0': u'\u53e9',
'\xcd\xb1': u'\u544a',
'\xcd\xb2': u'\u5471',
'\xcd\xb3': u'\u56fa',
'\xcd\xb4': u'\u59d1',
'\xcd\xb5': u'\u5b64',
'\xcd\xb6': u'\u5c3b',
'\xcd\xb7': u'\u5eab',
'\xcd\xb8': u'\u62f7',
'\xcd\xb9': u'\u6537',
'\xcd\xba': u'\u6545',
'\xcd\xbb': u'\u6572',
'\xcd\xbc': u'\u66a0',
'\xcd\xbd': u'\u67af',
'\xcd\xbe': u'\u69c1',
'\xcd\xbf': u'\u6cbd',
'\xcd\xc0': u'\u75fc',
'\xcd\xc1': u'\u7690',
'\xcd\xc2': u'\u777e',
'\xcd\xc3': u'\u7a3f',
'\xcd\xc4': u'\u7f94',
'\xcd\xc5': u'\u8003',
'\xcd\xc6': u'\u80a1',
'\xcd\xc7': u'\u818f',
'\xcd\xc8': u'\u82e6',
'\xcd\xc9': u'\u82fd',
'\xcd\xca': u'\u83f0',
'\xcd\xcb': u'\u85c1',
'\xcd\xcc': u'\u8831',
'\xcd\xcd': u'\u88b4',
'\xcd\xce': u'\u8aa5',
'\xcd\xcf': u'\uf903',
'\xcd\xd0': u'\u8f9c',
'\xcd\xd1': u'\u932e',
'\xcd\xd2': u'\u96c7',
'\xcd\xd3': u'\u9867',
'\xcd\xd4': u'\u9ad8',
'\xcd\xd5': u'\u9f13',
'\xcd\xd6': u'\u54ed',
'\xcd\xd7': u'\u659b',
'\xcd\xd8': u'\u66f2',
'\xcd\xd9': u'\u688f',
'\xcd\xda': u'\u7a40',
'\xcd\xdb': u'\u8c37',
'\xcd\xdc': u'\u9d60',
'\xcd\xdd': u'\u56f0',
'\xcd\xde': u'\u5764',
'\xcd\xdf': u'\u5d11',
'\xcd\xe0': u'\u6606',
'\xcd\xe1': u'\u68b1',
'\xcd\xe2': u'\u68cd',
'\xcd\xe3': u'\u6efe',
'\xcd\xe4': u'\u7428',
'\xcd\xe5': u'\u889e',
'\xcd\xe6': u'\u9be4',
'\xcd\xe7': u'\u6c68',
'\xcd\xe8': u'\uf904',
'\xcd\xe9': u'\u9aa8',
'\xcd\xea': u'\u4f9b',
'\xcd\xeb': u'\u516c',
'\xcd\xec': u'\u5171',
'\xcd\xed': u'\u529f',
'\xcd\xee': u'\u5b54',
'\xcd\xef': u'\u5de5',
'\xcd\xf0': u'\u6050',
'\xcd\xf1': u'\u606d',
'\xcd\xf2': u'\u62f1',
'\xcd\xf3': u'\u63a7',
'\xcd\xf4': u'\u653b',
'\xcd\xf5': u'\u73d9',
'\xcd\xf6': u'\u7a7a',
'\xcd\xf7': u'\u86a3',
'\xcd\xf8': u'\u8ca2',
'\xcd\xf9': u'\u978f',
'\xcd\xfa': u'\u4e32',
'\xcd\xfb': u'\u5be1',
'\xcd\xfc': u'\u6208',
'\xcd\xfd': u'\u679c',
'\xcd\xfe': u'\u74dc',
'\xce\xa1': u'\u79d1',
'\xce\xa2': u'\u83d3',
'\xce\xa3': u'\u8a87',
'\xce\xa4': u'\u8ab2',
'\xce\xa5': u'\u8de8',
'\xce\xa6': u'\u904e',
'\xce\xa7': u'\u934b',
'\xce\xa8': u'\u9846',
'\xce\xa9': u'\u5ed3',
'\xce\xaa': u'\u69e8',
'\xce\xab': u'\u85ff',
'\xce\xac': u'\u90ed',
'\xce\xad': u'\uf905',
'\xce\xae': u'\u51a0',
'\xce\xaf': u'\u5b98',
'\xce\xb0': u'\u5bec',
'\xce\xb1': u'\u6163',
'\xce\xb2': u'\u68fa',
'\xce\xb3': u'\u6b3e',
'\xce\xb4': u'\u704c',
'\xce\xb5': u'\u742f',
'\xce\xb6': u'\u74d8',
'\xce\xb7': u'\u7ba1',
'\xce\xb8': u'\u7f50',
'\xce\xb9': u'\u83c5',
'\xce\xba': u'\u89c0',
'\xce\xbb': u'\u8cab',
'\xce\xbc': u'\u95dc',
'\xce\xbd': u'\u9928',
'\xce\xbe': u'\u522e',
'\xce\xbf': u'\u605d',
'\xce\xc0': u'\u62ec',
'\xce\xc1': u'\u9002',
'\xce\xc2': u'\u4f8a',
'\xce\xc3': u'\u5149',
'\xce\xc4': u'\u5321',
'\xce\xc5': u'\u58d9',
'\xce\xc6': u'\u5ee3',
'\xce\xc7': u'\u66e0',
'\xce\xc8': u'\u6d38',
'\xce\xc9': u'\u709a',
'\xce\xca': u'\u72c2',
'\xce\xcb': u'\u73d6',
'\xce\xcc': u'\u7b50',
'\xce\xcd': u'\u80f1',
'\xce\xce': u'\u945b',
'\xce\xcf': u'\u5366',
'\xce\xd0': u'\u639b',
'\xce\xd1': u'\u7f6b',
'\xce\xd2': u'\u4e56',
'\xce\xd3': u'\u5080',
'\xce\xd4': u'\u584a',
'\xce\xd5': u'\u58de',
'\xce\xd6': u'\u602a',
'\xce\xd7': u'\u6127',
'\xce\xd8': u'\u62d0',
'\xce\xd9': u'\u69d0',
'\xce\xda': u'\u9b41',
'\xce\xdb': u'\u5b8f',
'\xce\xdc': u'\u7d18',
'\xce\xdd': u'\u80b1',
'\xce\xde': u'\u8f5f',
'\xce\xdf': u'\u4ea4',
'\xce\xe0': u'\u50d1',
'\xce\xe1': u'\u54ac',
'\xce\xe2': u'\u55ac',
'\xce\xe3': u'\u5b0c',
'\xce\xe4': u'\u5da0',
'\xce\xe5': u'\u5de7',
'\xce\xe6': u'\u652a',
'\xce\xe7': u'\u654e',
'\xce\xe8': u'\u6821',
'\xce\xe9': u'\u6a4b',
'\xce\xea': u'\u72e1',
'\xce\xeb': u'\u768e',
'\xce\xec': u'\u77ef',
'\xce\xed': u'\u7d5e',
'\xce\xee': u'\u7ff9',
'\xce\xef': u'\u81a0',
'\xce\xf0': u'\u854e',
'\xce\xf1': u'\u86df',
'\xce\xf2': u'\u8f03',
'\xce\xf3': u'\u8f4e',
'\xce\xf4': u'\u90ca',
'\xce\xf5': u'\u9903',
'\xce\xf6': u'\u9a55',
'\xce\xf7': u'\u9bab',
'\xce\xf8': u'\u4e18',
'\xce\xf9': u'\u4e45',
'\xce\xfa': u'\u4e5d',
'\xce\xfb': u'\u4ec7',
'\xce\xfc': u'\u4ff1',
'\xce\xfd': u'\u5177',
'\xce\xfe': u'\u52fe',
'\xcf\xa1': u'\u5340',
'\xcf\xa2': u'\u53e3',
'\xcf\xa3': u'\u53e5',
'\xcf\xa4': u'\u548e',
'\xcf\xa5': u'\u5614',
'\xcf\xa6': u'\u5775',
'\xcf\xa7': u'\u57a2',
'\xcf\xa8': u'\u5bc7',
'\xcf\xa9': u'\u5d87',
'\xcf\xaa': u'\u5ed0',
'\xcf\xab': u'\u61fc',
'\xcf\xac': u'\u62d8',
'\xcf\xad': u'\u6551',
'\xcf\xae': u'\u67b8',
'\xcf\xaf': u'\u67e9',
'\xcf\xb0': u'\u69cb',
'\xcf\xb1': u'\u6b50',
'\xcf\xb2': u'\u6bc6',
'\xcf\xb3': u'\u6bec',
'\xcf\xb4': u'\u6c42',
'\xcf\xb5': u'\u6e9d',
'\xcf\xb6': u'\u7078',
'\xcf\xb7': u'\u72d7',
'\xcf\xb8': u'\u7396',
'\xcf\xb9': u'\u7403',
'\xcf\xba': u'\u77bf',
'\xcf\xbb': u'\u77e9',
'\xcf\xbc': u'\u7a76',
'\xcf\xbd': u'\u7d7f',
'\xcf\xbe': u'\u8009',
'\xcf\xbf': u'\u81fc',
'\xcf\xc0': u'\u8205',
'\xcf\xc1': u'\u820a',
'\xcf\xc2': u'\u82df',
'\xcf\xc3': u'\u8862',
'\xcf\xc4': u'\u8b33',
'\xcf\xc5': u'\u8cfc',
'\xcf\xc6': u'\u8ec0',
'\xcf\xc7': u'\u9011',
'\xcf\xc8': u'\u90b1',
'\xcf\xc9': u'\u9264',
'\xcf\xca': u'\u92b6',
'\xcf\xcb': u'\u99d2',
'\xcf\xcc': u'\u9a45',
'\xcf\xcd': u'\u9ce9',
'\xcf\xce': u'\u9dd7',
'\xcf\xcf': u'\u9f9c',
'\xcf\xd0': u'\u570b',
'\xcf\xd1': u'\u5c40',
'\xcf\xd2': u'\u83ca',
'\xcf\xd3': u'\u97a0',
'\xcf\xd4': u'\u97ab',
'\xcf\xd5': u'\u9eb4',
'\xcf\xd6': u'\u541b',
'\xcf\xd7': u'\u7a98',
'\xcf\xd8': u'\u7fa4',
'\xcf\xd9': u'\u88d9',
'\xcf\xda': u'\u8ecd',
'\xcf\xdb': u'\u90e1',
'\xcf\xdc': u'\u5800',
'\xcf\xdd': u'\u5c48',
'\xcf\xde': u'\u6398',
'\xcf\xdf': u'\u7a9f',
'\xcf\xe0': u'\u5bae',
'\xcf\xe1': u'\u5f13',
'\xcf\xe2': u'\u7a79',
'\xcf\xe3': u'\u7aae',
'\xcf\xe4': u'\u828e',
'\xcf\xe5': u'\u8eac',
'\xcf\xe6': u'\u5026',
'\xcf\xe7': u'\u5238',
'\xcf\xe8': u'\u52f8',
'\xcf\xe9': u'\u5377',
'\xcf\xea': u'\u5708',
'\xcf\xeb': u'\u62f3',
'\xcf\xec': u'\u6372',
'\xcf\xed': u'\u6b0a',
'\xcf\xee': u'\u6dc3',
'\xcf\xef': u'\u7737',
'\xcf\xf0': u'\u53a5',
'\xcf\xf1': u'\u7357',
'\xcf\xf2': u'\u8568',
'\xcf\xf3': u'\u8e76',
'\xcf\xf4': u'\u95d5',
'\xcf\xf5': u'\u673a',
'\xcf\xf6': u'\u6ac3',
'\xcf\xf7': u'\u6f70',
'\xcf\xf8': u'\u8a6d',
'\xcf\xf9': u'\u8ecc',
'\xcf\xfa': u'\u994b',
'\xcf\xfb': u'\uf906',
'\xcf\xfc': u'\u6677',
'\xcf\xfd': u'\u6b78',
'\xcf\xfe': u'\u8cb4',
'\xd0\xa1': u'\u9b3c',
'\xd0\xa2': u'\uf907',
'\xd0\xa3': u'\u53eb',
'\xd0\xa4': u'\u572d',
'\xd0\xa5': u'\u594e',
'\xd0\xa6': u'\u63c6',
'\xd0\xa7': u'\u69fb',
'\xd0\xa8': u'\u73ea',
'\xd0\xa9': u'\u7845',
'\xd0\xaa': u'\u7aba',
'\xd0\xab': u'\u7ac5',
'\xd0\xac': u'\u7cfe',
'\xd0\xad': u'\u8475',
'\xd0\xae': u'\u898f',
'\xd0\xaf': u'\u8d73',
'\xd0\xb0': u'\u9035',
'\xd0\xb1': u'\u95a8',
'\xd0\xb2': u'\u52fb',
'\xd0\xb3': u'\u5747',
'\xd0\xb4': u'\u7547',
'\xd0\xb5': u'\u7b60',
'\xd0\xb6': u'\u83cc',
'\xd0\xb7': u'\u921e',
'\xd0\xb8': u'\uf908',
'\xd0\xb9': u'\u6a58',
'\xd0\xba': u'\u514b',
'\xd0\xbb': u'\u524b',
'\xd0\xbc': u'\u5287',
'\xd0\xbd': u'\u621f',
'\xd0\xbe': u'\u68d8',
'\xd0\xbf': u'\u6975',
'\xd0\xc0': u'\u9699',
'\xd0\xc1': u'\u50c5',
'\xd0\xc2': u'\u52a4',
'\xd0\xc3': u'\u52e4',
'\xd0\xc4': u'\u61c3',
'\xd0\xc5': u'\u65a4',
'\xd0\xc6': u'\u6839',
'\xd0\xc7': u'\u69ff',
'\xd0\xc8': u'\u747e',
'\xd0\xc9': u'\u7b4b',
'\xd0\xca': u'\u82b9',
'\xd0\xcb': u'\u83eb',
'\xd0\xcc': u'\u89b2',
'\xd0\xcd': u'\u8b39',
'\xd0\xce': u'\u8fd1',
'\xd0\xcf': u'\u9949',
'\xd0\xd0': u'\uf909',
'\xd0\xd1': u'\u4eca',
'\xd0\xd2': u'\u5997',
'\xd0\xd3': u'\u64d2',
'\xd0\xd4': u'\u6611',
'\xd0\xd5': u'\u6a8e',
'\xd0\xd6': u'\u7434',
'\xd0\xd7': u'\u7981',
'\xd0\xd8': u'\u79bd',
'\xd0\xd9': u'\u82a9',
'\xd0\xda': u'\u887e',
'\xd0\xdb': u'\u887f',
'\xd0\xdc': u'\u895f',
'\xd0\xdd': u'\uf90a',
'\xd0\xde': u'\u9326',
'\xd0\xdf': u'\u4f0b',
'\xd0\xe0': u'\u53ca',
'\xd0\xe1': u'\u6025',
'\xd0\xe2': u'\u6271',
'\xd0\xe3': u'\u6c72',
'\xd0\xe4': u'\u7d1a',
'\xd0\xe5': u'\u7d66',
'\xd0\xe6': u'\u4e98',
'\xd0\xe7': u'\u5162',
'\xd0\xe8': u'\u77dc',
'\xd0\xe9': u'\u80af',
'\xd0\xea': u'\u4f01',
'\xd0\xeb': u'\u4f0e',
'\xd0\xec': u'\u5176',
'\xd0\xed': u'\u5180',
'\xd0\xee': u'\u55dc',
'\xd0\xef': u'\u5668',
'\xd0\xf0': u'\u573b',
'\xd0\xf1': u'\u57fa',
'\xd0\xf2': u'\u57fc',
'\xd0\xf3': u'\u5914',
'\xd0\xf4': u'\u5947',
'\xd0\xf5': u'\u5993',
'\xd0\xf6': u'\u5bc4',
'\xd0\xf7': u'\u5c90',
'\xd0\xf8': u'\u5d0e',
'\xd0\xf9': u'\u5df1',
'\xd0\xfa': u'\u5e7e',
'\xd0\xfb': u'\u5fcc',
'\xd0\xfc': u'\u6280',
'\xd0\xfd': u'\u65d7',
'\xd0\xfe': u'\u65e3',
'\xd1\xa1': u'\u671e',
'\xd1\xa2': u'\u671f',
'\xd1\xa3': u'\u675e',
'\xd1\xa4': u'\u68cb',
'\xd1\xa5': u'\u68c4',
'\xd1\xa6': u'\u6a5f',
'\xd1\xa7': u'\u6b3a',
'\xd1\xa8': u'\u6c23',
'\xd1\xa9': u'\u6c7d',
'\xd1\xaa': u'\u6c82',
'\xd1\xab': u'\u6dc7',
'\xd1\xac': u'\u7398',
'\xd1\xad': u'\u7426',
'\xd1\xae': u'\u742a',
'\xd1\xaf': u'\u7482',
'\xd1\xb0': u'\u74a3',
'\xd1\xb1': u'\u7578',
'\xd1\xb2': u'\u757f',
'\xd1\xb3': u'\u7881',
'\xd1\xb4': u'\u78ef',
'\xd1\xb5': u'\u7941',
'\xd1\xb6': u'\u7947',
'\xd1\xb7': u'\u7948',
'\xd1\xb8': u'\u797a',
'\xd1\xb9': u'\u7b95',
'\xd1\xba': u'\u7d00',
'\xd1\xbb': u'\u7dba',
'\xd1\xbc': u'\u7f88',
'\xd1\xbd': u'\u8006',
'\xd1\xbe': u'\u802d',
'\xd1\xbf': u'\u808c',
'\xd1\xc0': u'\u8a18',
'\xd1\xc1': u'\u8b4f',
'\xd1\xc2': u'\u8c48',
'\xd1\xc3': u'\u8d77',
'\xd1\xc4': u'\u9321',
'\xd1\xc5': u'\u9324',
'\xd1\xc6': u'\u98e2',
'\xd1\xc7': u'\u9951',
'\xd1\xc8': u'\u9a0e',
'\xd1\xc9': u'\u9a0f',
'\xd1\xca': u'\u9a65',
'\xd1\xcb': u'\u9e92',
'\xd1\xcc': u'\u7dca',
'\xd1\xcd': u'\u4f76',
'\xd1\xce': u'\u5409',
'\xd1\xcf': u'\u62ee',
'\xd1\xd0': u'\u6854',
'\xd1\xd1': u'\u91d1',
'\xd1\xd2': u'\u55ab',
'\xd1\xd3': u'\u513a',
'\xd1\xd4': u'\uf90b',
'\xd1\xd5': u'\uf90c',
'\xd1\xd6': u'\u5a1c',
'\xd1\xd7': u'\u61e6',
'\xd1\xd8': u'\uf90d',
'\xd1\xd9': u'\u62cf',
'\xd1\xda': u'\u62ff',
'\xd1\xdb': u'\uf90e',
'\xd1\xdc': u'\uf90f',
'\xd1\xdd': u'\uf910',
'\xd1\xde': u'\uf911',
'\xd1\xdf': u'\uf912',
'\xd1\xe0': u'\uf913',
'\xd1\xe1': u'\u90a3',
'\xd1\xe2': u'\uf914',
'\xd1\xe3': u'\uf915',
'\xd1\xe4': u'\uf916',
'\xd1\xe5': u'\uf917',
'\xd1\xe6': u'\uf918',
'\xd1\xe7': u'\u8afe',
'\xd1\xe8': u'\uf919',
'\xd1\xe9': u'\uf91a',
'\xd1\xea': u'\uf91b',
'\xd1\xeb': u'\uf91c',
'\xd1\xec': u'\u6696',
'\xd1\xed': u'\uf91d',
'\xd1\xee': u'\u7156',
'\xd1\xef': u'\uf91e',
'\xd1\xf0': u'\uf91f',
'\xd1\xf1': u'\u96e3',
'\xd1\xf2': u'\uf920',
'\xd1\xf3': u'\u634f',
'\xd1\xf4': u'\u637a',
'\xd1\xf5': u'\u5357',
'\xd1\xf6': u'\uf921',
'\xd1\xf7': u'\u678f',
'\xd1\xf8': u'\u6960',
'\xd1\xf9': u'\u6e73',
'\xd1\xfa': u'\uf922',
'\xd1\xfb': u'\u7537',
'\xd1\xfc': u'\uf923',
'\xd1\xfd': u'\uf924',
'\xd1\xfe': u'\uf925',
'\xd2\xa1': u'\u7d0d',
'\xd2\xa2': u'\uf926',
'\xd2\xa3': u'\uf927',
'\xd2\xa4': u'\u8872',
'\xd2\xa5': u'\u56ca',
'\xd2\xa6': u'\u5a18',
'\xd2\xa7': u'\uf928',
'\xd2\xa8': u'\uf929',
'\xd2\xa9': u'\uf92a',
'\xd2\xaa': u'\uf92b',
'\xd2\xab': u'\uf92c',
'\xd2\xac': u'\u4e43',
'\xd2\xad': u'\uf92d',
'\xd2\xae': u'\u5167',
'\xd2\xaf': u'\u5948',
'\xd2\xb0': u'\u67f0',
'\xd2\xb1': u'\u8010',
'\xd2\xb2': u'\uf92e',
'\xd2\xb3': u'\u5973',
'\xd2\xb4': u'\u5e74',
'\xd2\xb5': u'\u649a',
'\xd2\xb6': u'\u79ca',
'\xd2\xb7': u'\u5ff5',
'\xd2\xb8': u'\u606c',
'\xd2\xb9': u'\u62c8',
'\xd2\xba': u'\u637b',
'\xd2\xbb': u'\u5be7',
'\xd2\xbc': u'\u5bd7',
'\xd2\xbd': u'\u52aa',
'\xd2\xbe': u'\uf92f',
'\xd2\xbf': u'\u5974',
'\xd2\xc0': u'\u5f29',
'\xd2\xc1': u'\u6012',
'\xd2\xc2': u'\uf930',
'\xd2\xc3': u'\uf931',
'\xd2\xc4': u'\uf932',
'\xd2\xc5': u'\u7459',
'\xd2\xc6': u'\uf933',
'\xd2\xc7': u'\uf934',
'\xd2\xc8': u'\uf935',
'\xd2\xc9': u'\uf936',
'\xd2\xca': u'\uf937',
'\xd2\xcb': u'\uf938',
'\xd2\xcc': u'\u99d1',
'\xd2\xcd': u'\uf939',
'\xd2\xce': u'\uf93a',
'\xd2\xcf': u'\uf93b',
'\xd2\xd0': u'\uf93c',
'\xd2\xd1': u'\uf93d',
'\xd2\xd2': u'\uf93e',
'\xd2\xd3': u'\uf93f',
'\xd2\xd4': u'\uf940',
'\xd2\xd5': u'\uf941',
'\xd2\xd6': u'\uf942',
'\xd2\xd7': u'\uf943',
'\xd2\xd8': u'\u6fc3',
'\xd2\xd9': u'\uf944',
'\xd2\xda': u'\uf945',
'\xd2\xdb': u'\u81bf',
'\xd2\xdc': u'\u8fb2',
'\xd2\xdd': u'\u60f1',
'\xd2\xde': u'\uf946',
'\xd2\xdf': u'\uf947',
'\xd2\xe0': u'\u8166',
'\xd2\xe1': u'\uf948',
'\xd2\xe2': u'\uf949',
'\xd2\xe3': u'\u5c3f',
'\xd2\xe4': u'\uf94a',
'\xd2\xe5': u'\uf94b',
'\xd2\xe6': u'\uf94c',
'\xd2\xe7': u'\uf94d',
'\xd2\xe8': u'\uf94e',
'\xd2\xe9': u'\uf94f',
'\xd2\xea': u'\uf950',
'\xd2\xeb': u'\uf951',
'\xd2\xec': u'\u5ae9',
'\xd2\xed': u'\u8a25',
'\xd2\xee': u'\u677b',
'\xd2\xef': u'\u7d10',
'\xd2\xf0': u'\uf952',
'\xd2\xf1': u'\uf953',
'\xd2\xf2': u'\uf954',
'\xd2\xf3': u'\uf955',
'\xd2\xf4': u'\uf956',
'\xd2\xf5': u'\uf957',
'\xd2\xf6': u'\u80fd',
'\xd2\xf7': u'\uf958',
'\xd2\xf8': u'\uf959',
'\xd2\xf9': u'\u5c3c',
'\xd2\xfa': u'\u6ce5',
'\xd2\xfb': u'\u533f',
'\xd2\xfc': u'\u6eba',
'\xd2\xfd': u'\u591a',
'\xd2\xfe': u'\u8336',
'\xd3\xa1': u'\u4e39',
'\xd3\xa2': u'\u4eb6',
'\xd3\xa3': u'\u4f46',
'\xd3\xa4': u'\u55ae',
'\xd3\xa5': u'\u5718',
'\xd3\xa6': u'\u58c7',
'\xd3\xa7': u'\u5f56',
'\xd3\xa8': u'\u65b7',
'\xd3\xa9': u'\u65e6',
'\xd3\xaa': u'\u6a80',
'\xd3\xab': u'\u6bb5',
'\xd3\xac': u'\u6e4d',
'\xd3\xad': u'\u77ed',
'\xd3\xae': u'\u7aef',
'\xd3\xaf': u'\u7c1e',
'\xd3\xb0': u'\u7dde',
'\xd3\xb1': u'\u86cb',
'\xd3\xb2': u'\u8892',
'\xd3\xb3': u'\u9132',
'\xd3\xb4': u'\u935b',
'\xd3\xb5': u'\u64bb',
'\xd3\xb6': u'\u6fbe',
'\xd3\xb7': u'\u737a',
'\xd3\xb8': u'\u75b8',
'\xd3\xb9': u'\u9054',
'\xd3\xba': u'\u5556',
'\xd3\xbb': u'\u574d',
'\xd3\xbc': u'\u61ba',
'\xd3\xbd': u'\u64d4',
'\xd3\xbe': u'\u66c7',
'\xd3\xbf': u'\u6de1',
'\xd3\xc0': u'\u6e5b',
'\xd3\xc1': u'\u6f6d',
'\xd3\xc2': u'\u6fb9',
'\xd3\xc3': u'\u75f0',
'\xd3\xc4': u'\u8043',
'\xd3\xc5': u'\u81bd',
'\xd3\xc6': u'\u8541',
'\xd3\xc7': u'\u8983',
'\xd3\xc8': u'\u8ac7',
'\xd3\xc9': u'\u8b5a',
'\xd3\xca': u'\u931f',
'\xd3\xcb': u'\u6c93',
'\xd3\xcc': u'\u7553',
'\xd3\xcd': u'\u7b54',
'\xd3\xce': u'\u8e0f',
'\xd3\xcf': u'\u905d',
'\xd3\xd0': u'\u5510',
'\xd3\xd1': u'\u5802',
'\xd3\xd2': u'\u5858',
'\xd3\xd3': u'\u5e62',
'\xd3\xd4': u'\u6207',
'\xd3\xd5': u'\u649e',
'\xd3\xd6': u'\u68e0',
'\xd3\xd7': u'\u7576',
'\xd3\xd8': u'\u7cd6',
'\xd3\xd9': u'\u87b3',
'\xd3\xda': u'\u9ee8',
'\xd3\xdb': u'\u4ee3',
'\xd3\xdc': u'\u5788',
'\xd3\xdd': u'\u576e',
'\xd3\xde': u'\u5927',
'\xd3\xdf': u'\u5c0d',
'\xd3\xe0': u'\u5cb1',
'\xd3\xe1': u'\u5e36',
'\xd3\xe2': u'\u5f85',
'\xd3\xe3': u'\u6234',
'\xd3\xe4': u'\u64e1',
'\xd3\xe5': u'\u73b3',
'\xd3\xe6': u'\u81fa',
'\xd3\xe7': u'\u888b',
'\xd3\xe8': u'\u8cb8',
'\xd3\xe9': u'\u968a',
'\xd3\xea': u'\u9edb',
'\xd3\xeb': u'\u5b85',
'\xd3\xec': u'\u5fb7',
'\xd3\xed': u'\u60b3',
'\xd3\xee': u'\u5012',
'\xd3\xef': u'\u5200',
'\xd3\xf0': u'\u5230',
'\xd3\xf1': u'\u5716',
'\xd3\xf2': u'\u5835',
'\xd3\xf3': u'\u5857',
'\xd3\xf4': u'\u5c0e',
'\xd3\xf5': u'\u5c60',
'\xd3\xf6': u'\u5cf6',
'\xd3\xf7': u'\u5d8b',
'\xd3\xf8': u'\u5ea6',
'\xd3\xf9': u'\u5f92',
'\xd3\xfa': u'\u60bc',
'\xd3\xfb': u'\u6311',
'\xd3\xfc': u'\u6389',
'\xd3\xfd': u'\u6417',
'\xd3\xfe': u'\u6843',
'\xd4\xa1': u'\u68f9',
'\xd4\xa2': u'\u6ac2',
'\xd4\xa3': u'\u6dd8',
'\xd4\xa4': u'\u6e21',
'\xd4\xa5': u'\u6ed4',
'\xd4\xa6': u'\u6fe4',
'\xd4\xa7': u'\u71fe',
'\xd4\xa8': u'\u76dc',
'\xd4\xa9': u'\u7779',
'\xd4\xaa': u'\u79b1',
'\xd4\xab': u'\u7a3b',
'\xd4\xac': u'\u8404',
'\xd4\xad': u'\u89a9',
'\xd4\xae': u'\u8ced',
'\xd4\xaf': u'\u8df3',
'\xd4\xb0': u'\u8e48',
'\xd4\xb1': u'\u9003',
'\xd4\xb2': u'\u9014',
'\xd4\xb3': u'\u9053',
'\xd4\xb4': u'\u90fd',
'\xd4\xb5': u'\u934d',
'\xd4\xb6': u'\u9676',
'\xd4\xb7': u'\u97dc',
'\xd4\xb8': u'\u6bd2',
'\xd4\xb9': u'\u7006',
'\xd4\xba': u'\u7258',
'\xd4\xbb': u'\u72a2',
'\xd4\xbc': u'\u7368',
'\xd4\xbd': u'\u7763',
'\xd4\xbe': u'\u79bf',
'\xd4\xbf': u'\u7be4',
'\xd4\xc0': u'\u7e9b',
'\xd4\xc1': u'\u8b80',
'\xd4\xc2': u'\u58a9',
'\xd4\xc3': u'\u60c7',
'\xd4\xc4': u'\u6566',
'\xd4\xc5': u'\u65fd',
'\xd4\xc6': u'\u66be',
'\xd4\xc7': u'\u6c8c',
'\xd4\xc8': u'\u711e',
'\xd4\xc9': u'\u71c9',
'\xd4\xca': u'\u8c5a',
'\xd4\xcb': u'\u9813',
'\xd4\xcc': u'\u4e6d',
'\xd4\xcd': u'\u7a81',
'\xd4\xce': u'\u4edd',
'\xd4\xcf': u'\u51ac',
'\xd4\xd0': u'\u51cd',
'\xd4\xd1': u'\u52d5',
'\xd4\xd2': u'\u540c',
'\xd4\xd3': u'\u61a7',
'\xd4\xd4': u'\u6771',
'\xd4\xd5': u'\u6850',
'\xd4\xd6': u'\u68df',
'\xd4\xd7': u'\u6d1e',
'\xd4\xd8': u'\u6f7c',
'\xd4\xd9': u'\u75bc',
'\xd4\xda': u'\u77b3',
'\xd4\xdb': u'\u7ae5',
'\xd4\xdc': u'\u80f4',
'\xd4\xdd': u'\u8463',
'\xd4\xde': u'\u9285',
'\xd4\xdf': u'\u515c',
'\xd4\xe0': u'\u6597',
'\xd4\xe1': u'\u675c',
'\xd4\xe2': u'\u6793',
'\xd4\xe3': u'\u75d8',
'\xd4\xe4': u'\u7ac7',
'\xd4\xe5': u'\u8373',
'\xd4\xe6': u'\uf95a',
'\xd4\xe7': u'\u8c46',
'\xd4\xe8': u'\u9017',
'\xd4\xe9': u'\u982d',
'\xd4\xea': u'\u5c6f',
'\xd4\xeb': u'\u81c0',
'\xd4\xec': u'\u829a',
'\xd4\xed': u'\u9041',
'\xd4\xee': u'\u906f',
'\xd4\xef': u'\u920d',
'\xd4\xf0': u'\u5f97',
'\xd4\xf1': u'\u5d9d',
'\xd4\xf2': u'\u6a59',
'\xd4\xf3': u'\u71c8',
'\xd4\xf4': u'\u767b',
'\xd4\xf5': u'\u7b49',
'\xd4\xf6': u'\u85e4',
'\xd4\xf7': u'\u8b04',
'\xd4\xf8': u'\u9127',
'\xd4\xf9': u'\u9a30',
'\xd4\xfa': u'\u5587',
'\xd4\xfb': u'\u61f6',
'\xd4\xfc': u'\uf95b',
'\xd4\xfd': u'\u7669',
'\xd4\xfe': u'\u7f85',
'\xd5\xa1': u'\u863f',
'\xd5\xa2': u'\u87ba',
'\xd5\xa3': u'\u88f8',
'\xd5\xa4': u'\u908f',
'\xd5\xa5': u'\uf95c',
'\xd5\xa6': u'\u6d1b',
'\xd5\xa7': u'\u70d9',
'\xd5\xa8': u'\u73de',
'\xd5\xa9': u'\u7d61',
'\xd5\xaa': u'\u843d',
'\xd5\xab': u'\uf95d',
'\xd5\xac': u'\u916a',
'\xd5\xad': u'\u99f1',
'\xd5\xae': u'\uf95e',
'\xd5\xaf': u'\u4e82',
'\xd5\xb0': u'\u5375',
'\xd5\xb1': u'\u6b04',
'\xd5\xb2': u'\u6b12',
'\xd5\xb3': u'\u703e',
'\xd5\xb4': u'\u721b',
'\xd5\xb5': u'\u862d',
'\xd5\xb6': u'\u9e1e',
'\xd5\xb7': u'\u524c',
'\xd5\xb8': u'\u8fa3',
'\xd5\xb9': u'\u5d50',
'\xd5\xba': u'\u64e5',
'\xd5\xbb': u'\u652c',
'\xd5\xbc': u'\u6b16',
'\xd5\xbd': u'\u6feb',
'\xd5\xbe': u'\u7c43',
'\xd5\xbf': u'\u7e9c',
'\xd5\xc0': u'\u85cd',
'\xd5\xc1': u'\u8964',
'\xd5\xc2': u'\u89bd',
'\xd5\xc3': u'\u62c9',
'\xd5\xc4': u'\u81d8',
'\xd5\xc5': u'\u881f',
'\xd5\xc6': u'\u5eca',
'\xd5\xc7': u'\u6717',
'\xd5\xc8': u'\u6d6a',
'\xd5\xc9': u'\u72fc',
'\xd5\xca': u'\u7405',
'\xd5\xcb': u'\u746f',
'\xd5\xcc': u'\u8782',
'\xd5\xcd': u'\u90de',
'\xd5\xce': u'\u4f86',
'\xd5\xcf': u'\u5d0d',
'\xd5\xd0': u'\u5fa0',
'\xd5\xd1': u'\u840a',
'\xd5\xd2': u'\u51b7',
'\xd5\xd3': u'\u63a0',
'\xd5\xd4': u'\u7565',
'\xd5\xd5': u'\u4eae',
'\xd5\xd6': u'\u5006',
'\xd5\xd7': u'\u5169',
'\xd5\xd8': u'\u51c9',
'\xd5\xd9': u'\u6881',
'\xd5\xda': u'\u6a11',
'\xd5\xdb': u'\u7cae',
'\xd5\xdc': u'\u7cb1',
'\xd5\xdd': u'\u7ce7',
'\xd5\xde': u'\u826f',
'\xd5\xdf': u'\u8ad2',
'\xd5\xe0': u'\u8f1b',
'\xd5\xe1': u'\u91cf',
'\xd5\xe2': u'\u4fb6',
'\xd5\xe3': u'\u5137',
'\xd5\xe4': u'\u52f5',
'\xd5\xe5': u'\u5442',
'\xd5\xe6': u'\u5eec',
'\xd5\xe7': u'\u616e',
'\xd5\xe8': u'\u623e',
'\xd5\xe9': u'\u65c5',
'\xd5\xea': u'\u6ada',
'\xd5\xeb': u'\u6ffe',
'\xd5\xec': u'\u792a',
'\xd5\xed': u'\u85dc',
'\xd5\xee': u'\u8823',
'\xd5\xef': u'\u95ad',
'\xd5\xf0': u'\u9a62',
'\xd5\xf1': u'\u9a6a',
'\xd5\xf2': u'\u9e97',
'\xd5\xf3': u'\u9ece',
'\xd5\xf4': u'\u529b',
'\xd5\xf5': u'\u66c6',
'\xd5\xf6': u'\u6b77',
'\xd5\xf7': u'\u701d',
'\xd5\xf8': u'\u792b',
'\xd5\xf9': u'\u8f62',
'\xd5\xfa': u'\u9742',
'\xd5\xfb': u'\u6190',
'\xd5\xfc': u'\u6200',
'\xd5\xfd': u'\u6523',
'\xd5\xfe': u'\u6f23',
'\xd6\xa1': u'\u7149',
'\xd6\xa2': u'\u7489',
'\xd6\xa3': u'\u7df4',
'\xd6\xa4': u'\u806f',
'\xd6\xa5': u'\u84ee',
'\xd6\xa6': u'\u8f26',
'\xd6\xa7': u'\u9023',
'\xd6\xa8': u'\u934a',
'\xd6\xa9': u'\u51bd',
'\xd6\xaa': u'\u5217',
'\xd6\xab': u'\u52a3',
'\xd6\xac': u'\u6d0c',
'\xd6\xad': u'\u70c8',
'\xd6\xae': u'\u88c2',
'\xd6\xaf': u'\u5ec9',
'\xd6\xb0': u'\u6582',
'\xd6\xb1': u'\u6bae',
'\xd6\xb2': u'\u6fc2',
'\xd6\xb3': u'\u7c3e',
'\xd6\xb4': u'\u7375',
'\xd6\xb5': u'\u4ee4',
'\xd6\xb6': u'\u4f36',
'\xd6\xb7': u'\u56f9',
'\xd6\xb8': u'\uf95f',
'\xd6\xb9': u'\u5cba',
'\xd6\xba': u'\u5dba',
'\xd6\xbb': u'\u601c',
'\xd6\xbc': u'\u73b2',
'\xd6\xbd': u'\u7b2d',
'\xd6\xbe': u'\u7f9a',
'\xd6\xbf': u'\u7fce',
'\xd6\xc0': u'\u8046',
'\xd6\xc1': u'\u901e',
'\xd6\xc2': u'\u9234',
'\xd6\xc3': u'\u96f6',
'\xd6\xc4': u'\u9748',
'\xd6\xc5': u'\u9818',
'\xd6\xc6': u'\u9f61',
'\xd6\xc7': u'\u4f8b',
'\xd6\xc8': u'\u6fa7',
'\xd6\xc9': u'\u79ae',
'\xd6\xca': u'\u91b4',
'\xd6\xcb': u'\u96b7',
'\xd6\xcc': u'\u52de',
'\xd6\xcd': u'\uf960',
'\xd6\xce': u'\u6488',
'\xd6\xcf': u'\u64c4',
'\xd6\xd0': u'\u6ad3',
'\xd6\xd1': u'\u6f5e',
'\xd6\xd2': u'\u7018',
'\xd6\xd3': u'\u7210',
'\xd6\xd4': u'\u76e7',
'\xd6\xd5': u'\u8001',
'\xd6\xd6': u'\u8606',
'\xd6\xd7': u'\u865c',
'\xd6\xd8': u'\u8def',
'\xd6\xd9': u'\u8f05',
'\xd6\xda': u'\u9732',
'\xd6\xdb': u'\u9b6f',
'\xd6\xdc': u'\u9dfa',
'\xd6\xdd': u'\u9e75',
'\xd6\xde': u'\u788c',
'\xd6\xdf': u'\u797f',
'\xd6\xe0': u'\u7da0',
'\xd6\xe1': u'\u83c9',
'\xd6\xe2': u'\u9304',
'\xd6\xe3': u'\u9e7f',
'\xd6\xe4': u'\u9e93',
'\xd6\xe5': u'\u8ad6',
'\xd6\xe6': u'\u58df',
'\xd6\xe7': u'\u5f04',
'\xd6\xe8': u'\u6727',
'\xd6\xe9': u'\u7027',
'\xd6\xea': u'\u74cf',
'\xd6\xeb': u'\u7c60',
'\xd6\xec': u'\u807e',
'\xd6\xed': u'\u5121',
'\xd6\xee': u'\u7028',
'\xd6\xef': u'\u7262',
'\xd6\xf0': u'\u78ca',
'\xd6\xf1': u'\u8cc2',
'\xd6\xf2': u'\u8cda',
'\xd6\xf3': u'\u8cf4',
'\xd6\xf4': u'\u96f7',
'\xd6\xf5': u'\u4e86',
'\xd6\xf6': u'\u50da',
'\xd6\xf7': u'\u5bee',
'\xd6\xf8': u'\u5ed6',
'\xd6\xf9': u'\u6599',
'\xd6\xfa': u'\u71ce',
'\xd6\xfb': u'\u7642',
'\xd6\xfc': u'\u77ad',
'\xd6\xfd': u'\u804a',
'\xd6\xfe': u'\u84fc',
'\xd7\xa1': u'\u907c',
'\xd7\xa2': u'\u9b27',
'\xd7\xa3': u'\u9f8d',
'\xd7\xa4': u'\u58d8',
'\xd7\xa5': u'\u5a41',
'\xd7\xa6': u'\u5c62',
'\xd7\xa7': u'\u6a13',
'\xd7\xa8': u'\u6dda',
'\xd7\xa9': u'\u6f0f',
'\xd7\xaa': u'\u763b',
'\xd7\xab': u'\u7d2f',
'\xd7\xac': u'\u7e37',
'\xd7\xad': u'\u851e',
'\xd7\xae': u'\u8938',
'\xd7\xaf': u'\u93e4',
'\xd7\xb0': u'\u964b',
'\xd7\xb1': u'\u5289',
'\xd7\xb2': u'\u65d2',
'\xd7\xb3': u'\u67f3',
'\xd7\xb4': u'\u69b4',
'\xd7\xb5': u'\u6d41',
'\xd7\xb6': u'\u6e9c',
'\xd7\xb7': u'\u700f',
'\xd7\xb8': u'\u7409',
'\xd7\xb9': u'\u7460',
'\xd7\xba': u'\u7559',
'\xd7\xbb': u'\u7624',
'\xd7\xbc': u'\u786b',
'\xd7\xbd': u'\u8b2c',
'\xd7\xbe': u'\u985e',
'\xd7\xbf': u'\u516d',
'\xd7\xc0': u'\u622e',
'\xd7\xc1': u'\u9678',
'\xd7\xc2': u'\u4f96',
'\xd7\xc3': u'\u502b',
'\xd7\xc4': u'\u5d19',
'\xd7\xc5': u'\u6dea',
'\xd7\xc6': u'\u7db8',
'\xd7\xc7': u'\u8f2a',
'\xd7\xc8': u'\u5f8b',
'\xd7\xc9': u'\u6144',
'\xd7\xca': u'\u6817',
'\xd7\xcb': u'\uf961',
'\xd7\xcc': u'\u9686',
'\xd7\xcd': u'\u52d2',
'\xd7\xce': u'\u808b',
'\xd7\xcf': u'\u51dc',
'\xd7\xd0': u'\u51cc',
'\xd7\xd1': u'\u695e',
'\xd7\xd2': u'\u7a1c',
'\xd7\xd3': u'\u7dbe',
'\xd7\xd4': u'\u83f1',
'\xd7\xd5': u'\u9675',
'\xd7\xd6': u'\u4fda',
'\xd7\xd7': u'\u5229',
'\xd7\xd8': u'\u5398',
'\xd7\xd9': u'\u540f',
'\xd7\xda': u'\u550e',
'\xd7\xdb': u'\u5c65',
'\xd7\xdc': u'\u60a7',
'\xd7\xdd': u'\u674e',
'\xd7\xde': u'\u68a8',
'\xd7\xdf': u'\u6d6c',
'\xd7\xe0': u'\u7281',
'\xd7\xe1': u'\u72f8',
'\xd7\xe2': u'\u7406',
'\xd7\xe3': u'\u7483',
'\xd7\xe4': u'\uf962',
'\xd7\xe5': u'\u75e2',
'\xd7\xe6': u'\u7c6c',
'\xd7\xe7': u'\u7f79',
'\xd7\xe8': u'\u7fb8',
'\xd7\xe9': u'\u8389',
'\xd7\xea': u'\u88cf',
'\xd7\xeb': u'\u88e1',
'\xd7\xec': u'\u91cc',
'\xd7\xed': u'\u91d0',
'\xd7\xee': u'\u96e2',
'\xd7\xef': u'\u9bc9',
'\xd7\xf0': u'\u541d',
'\xd7\xf1': u'\u6f7e',
'\xd7\xf2': u'\u71d0',
'\xd7\xf3': u'\u7498',
'\xd7\xf4': u'\u85fa',
'\xd7\xf5': u'\u8eaa',
'\xd7\xf6': u'\u96a3',
'\xd7\xf7': u'\u9c57',
'\xd7\xf8': u'\u9e9f',
'\xd7\xf9': u'\u6797',
'\xd7\xfa': u'\u6dcb',
'\xd7\xfb': u'\u7433',
'\xd7\xfc': u'\u81e8',
'\xd7\xfd': u'\u9716',
'\xd7\xfe': u'\u782c',
'\xd8\xa1': u'\u7acb',
'\xd8\xa2': u'\u7b20',
'\xd8\xa3': u'\u7c92',
'\xd8\xa4': u'\u6469',
'\xd8\xa5': u'\u746a',
'\xd8\xa6': u'\u75f2',
'\xd8\xa7': u'\u78bc',
'\xd8\xa8': u'\u78e8',
'\xd8\xa9': u'\u99ac',
'\xd8\xaa': u'\u9b54',
'\xd8\xab': u'\u9ebb',
'\xd8\xac': u'\u5bde',
'\xd8\xad': u'\u5e55',
'\xd8\xae': u'\u6f20',
'\xd8\xaf': u'\u819c',
'\xd8\xb0': u'\u83ab',
'\xd8\xb1': u'\u9088',
'\xd8\xb2': u'\u4e07',
'\xd8\xb3': u'\u534d',
'\xd8\xb4': u'\u5a29',
'\xd8\xb5': u'\u5dd2',
'\xd8\xb6': u'\u5f4e',
'\xd8\xb7': u'\u6162',
'\xd8\xb8': u'\u633d',
'\xd8\xb9': u'\u6669',
'\xd8\xba': u'\u66fc',
'\xd8\xbb': u'\u6eff',
'\xd8\xbc': u'\u6f2b',
'\xd8\xbd': u'\u7063',
'\xd8\xbe': u'\u779e',
'\xd8\xbf': u'\u842c',
'\xd8\xc0': u'\u8513',
'\xd8\xc1': u'\u883b',
'\xd8\xc2': u'\u8f13',
'\xd8\xc3': u'\u9945',
'\xd8\xc4': u'\u9c3b',
'\xd8\xc5': u'\u551c',
'\xd8\xc6': u'\u62b9',
'\xd8\xc7': u'\u672b',
'\xd8\xc8': u'\u6cab',
'\xd8\xc9': u'\u8309',
'\xd8\xca': u'\u896a',
'\xd8\xcb': u'\u977a',
'\xd8\xcc': u'\u4ea1',
'\xd8\xcd': u'\u5984',
'\xd8\xce': u'\u5fd8',
'\xd8\xcf': u'\u5fd9',
'\xd8\xd0': u'\u671b',
'\xd8\xd1': u'\u7db2',
'\xd8\xd2': u'\u7f54',
'\xd8\xd3': u'\u8292',
'\xd8\xd4': u'\u832b',
'\xd8\xd5': u'\u83bd',
'\xd8\xd6': u'\u8f1e',
'\xd8\xd7': u'\u9099',
'\xd8\xd8': u'\u57cb',
'\xd8\xd9': u'\u59b9',
'\xd8\xda': u'\u5a92',
'\xd8\xdb': u'\u5bd0',
'\xd8\xdc': u'\u6627',
'\xd8\xdd': u'\u679a',
'\xd8\xde': u'\u6885',
'\xd8\xdf': u'\u6bcf',
'\xd8\xe0': u'\u7164',
'\xd8\xe1': u'\u7f75',
'\xd8\xe2': u'\u8cb7',
'\xd8\xe3': u'\u8ce3',
'\xd8\xe4': u'\u9081',
'\xd8\xe5': u'\u9b45',
'\xd8\xe6': u'\u8108',
'\xd8\xe7': u'\u8c8a',
'\xd8\xe8': u'\u964c',
'\xd8\xe9': u'\u9a40',
'\xd8\xea': u'\u9ea5',
'\xd8\xeb': u'\u5b5f',
'\xd8\xec': u'\u6c13',
'\xd8\xed': u'\u731b',
'\xd8\xee': u'\u76f2',
'\xd8\xef': u'\u76df',
'\xd8\xf0': u'\u840c',
'\xd8\xf1': u'\u51aa',
'\xd8\xf2': u'\u8993',
'\xd8\xf3': u'\u514d',
'\xd8\xf4': u'\u5195',
'\xd8\xf5': u'\u52c9',
'\xd8\xf6': u'\u68c9',
'\xd8\xf7': u'\u6c94',
'\xd8\xf8': u'\u7704',
'\xd8\xf9': u'\u7720',
'\xd8\xfa': u'\u7dbf',
'\xd8\xfb': u'\u7dec',
'\xd8\xfc': u'\u9762',
'\xd8\xfd': u'\u9eb5',
'\xd8\xfe': u'\u6ec5',
'\xd9\xa1': u'\u8511',
'\xd9\xa2': u'\u51a5',
'\xd9\xa3': u'\u540d',
'\xd9\xa4': u'\u547d',
'\xd9\xa5': u'\u660e',
'\xd9\xa6': u'\u669d',
'\xd9\xa7': u'\u6927',
'\xd9\xa8': u'\u6e9f',
'\xd9\xa9': u'\u76bf',
'\xd9\xaa': u'\u7791',
'\xd9\xab': u'\u8317',
'\xd9\xac': u'\u84c2',
'\xd9\xad': u'\u879f',
'\xd9\xae': u'\u9169',
'\xd9\xaf': u'\u9298',
'\xd9\xb0': u'\u9cf4',
'\xd9\xb1': u'\u8882',
'\xd9\xb2': u'\u4fae',
'\xd9\xb3': u'\u5192',
'\xd9\xb4': u'\u52df',
'\xd9\xb5': u'\u59c6',
'\xd9\xb6': u'\u5e3d',
'\xd9\xb7': u'\u6155',
'\xd9\xb8': u'\u6478',
'\xd9\xb9': u'\u6479',
'\xd9\xba': u'\u66ae',
'\xd9\xbb': u'\u67d0',
'\xd9\xbc': u'\u6a21',
'\xd9\xbd': u'\u6bcd',
'\xd9\xbe': u'\u6bdb',
'\xd9\xbf': u'\u725f',
'\xd9\xc0': u'\u7261',
'\xd9\xc1': u'\u7441',
'\xd9\xc2': u'\u7738',
'\xd9\xc3': u'\u77db',
'\xd9\xc4': u'\u8017',
'\xd9\xc5': u'\u82bc',
'\xd9\xc6': u'\u8305',
'\xd9\xc7': u'\u8b00',
'\xd9\xc8': u'\u8b28',
'\xd9\xc9': u'\u8c8c',
'\xd9\xca': u'\u6728',
'\xd9\xcb': u'\u6c90',
'\xd9\xcc': u'\u7267',
'\xd9\xcd': u'\u76ee',
'\xd9\xce': u'\u7766',
'\xd9\xcf': u'\u7a46',
'\xd9\xd0': u'\u9da9',
'\xd9\xd1': u'\u6b7f',
'\xd9\xd2': u'\u6c92',
'\xd9\xd3': u'\u5922',
'\xd9\xd4': u'\u6726',
'\xd9\xd5': u'\u8499',
'\xd9\xd6': u'\u536f',
'\xd9\xd7': u'\u5893',
'\xd9\xd8': u'\u5999',
'\xd9\xd9': u'\u5edf',
'\xd9\xda': u'\u63cf',
'\xd9\xdb': u'\u6634',
'\xd9\xdc': u'\u6773',
'\xd9\xdd': u'\u6e3a',
'\xd9\xde': u'\u732b',
'\xd9\xdf': u'\u7ad7',
'\xd9\xe0': u'\u82d7',
'\xd9\xe1': u'\u9328',
'\xd9\xe2': u'\u52d9',
'\xd9\xe3': u'\u5deb',
'\xd9\xe4': u'\u61ae',
'\xd9\xe5': u'\u61cb',
'\xd9\xe6': u'\u620a',
'\xd9\xe7': u'\u62c7',
'\xd9\xe8': u'\u64ab',
'\xd9\xe9': u'\u65e0',
'\xd9\xea': u'\u6959',
'\xd9\xeb': u'\u6b66',
'\xd9\xec': u'\u6bcb',
'\xd9\xed': u'\u7121',
'\xd9\xee': u'\u73f7',
'\xd9\xef': u'\u755d',
'\xd9\xf0': u'\u7e46',
'\xd9\xf1': u'\u821e',
'\xd9\xf2': u'\u8302',
'\xd9\xf3': u'\u856a',
'\xd9\xf4': u'\u8aa3',
'\xd9\xf5': u'\u8cbf',
'\xd9\xf6': u'\u9727',
'\xd9\xf7': u'\u9d61',
'\xd9\xf8': u'\u58a8',
'\xd9\xf9': u'\u9ed8',
'\xd9\xfa': u'\u5011',
'\xd9\xfb': u'\u520e',
'\xd9\xfc': u'\u543b',
'\xd9\xfd': u'\u554f',
'\xd9\xfe': u'\u6587',
'\xda\xa1': u'\u6c76',
'\xda\xa2': u'\u7d0a',
'\xda\xa3': u'\u7d0b',
'\xda\xa4': u'\u805e',
'\xda\xa5': u'\u868a',
'\xda\xa6': u'\u9580',
'\xda\xa7': u'\u96ef',
'\xda\xa8': u'\u52ff',
'\xda\xa9': u'\u6c95',
'\xda\xaa': u'\u7269',
'\xda\xab': u'\u5473',
'\xda\xac': u'\u5a9a',
'\xda\xad': u'\u5c3e',
'\xda\xae': u'\u5d4b',
'\xda\xaf': u'\u5f4c',
'\xda\xb0': u'\u5fae',
'\xda\xb1': u'\u672a',
'\xda\xb2': u'\u68b6',
'\xda\xb3': u'\u6963',
'\xda\xb4': u'\u6e3c',
'\xda\xb5': u'\u6e44',
'\xda\xb6': u'\u7709',
'\xda\xb7': u'\u7c73',
'\xda\xb8': u'\u7f8e',
'\xda\xb9': u'\u8587',
'\xda\xba': u'\u8b0e',
'\xda\xbb': u'\u8ff7',
'\xda\xbc': u'\u9761',
'\xda\xbd': u'\u9ef4',
'\xda\xbe': u'\u5cb7',
'\xda\xbf': u'\u60b6',
'\xda\xc0': u'\u610d',
'\xda\xc1': u'\u61ab',
'\xda\xc2': u'\u654f',
'\xda\xc3': u'\u65fb',
'\xda\xc4': u'\u65fc',
'\xda\xc5': u'\u6c11',
'\xda\xc6': u'\u6cef',
'\xda\xc7': u'\u739f',
'\xda\xc8': u'\u73c9',
'\xda\xc9': u'\u7de1',
'\xda\xca': u'\u9594',
'\xda\xcb': u'\u5bc6',
'\xda\xcc': u'\u871c',
'\xda\xcd': u'\u8b10',
'\xda\xce': u'\u525d',
'\xda\xcf': u'\u535a',
'\xda\xd0': u'\u62cd',
'\xda\xd1': u'\u640f',
'\xda\xd2': u'\u64b2',
'\xda\xd3': u'\u6734',
'\xda\xd4': u'\u6a38',
'\xda\xd5': u'\u6cca',
'\xda\xd6': u'\u73c0',
'\xda\xd7': u'\u749e',
'\xda\xd8': u'\u7b94',
'\xda\xd9': u'\u7c95',
'\xda\xda': u'\u7e1b',
'\xda\xdb': u'\u818a',
'\xda\xdc': u'\u8236',
'\xda\xdd': u'\u8584',
'\xda\xde': u'\u8feb',
'\xda\xdf': u'\u96f9',
'\xda\xe0': u'\u99c1',
'\xda\xe1': u'\u4f34',
'\xda\xe2': u'\u534a',
'\xda\xe3': u'\u53cd',
'\xda\xe4': u'\u53db',
'\xda\xe5': u'\u62cc',
'\xda\xe6': u'\u642c',
'\xda\xe7': u'\u6500',
'\xda\xe8': u'\u6591',
'\xda\xe9': u'\u69c3',
'\xda\xea': u'\u6cee',
'\xda\xeb': u'\u6f58',
'\xda\xec': u'\u73ed',
'\xda\xed': u'\u7554',
'\xda\xee': u'\u7622',
'\xda\xef': u'\u76e4',
'\xda\xf0': u'\u76fc',
'\xda\xf1': u'\u78d0',
'\xda\xf2': u'\u78fb',
'\xda\xf3': u'\u792c',
'\xda\xf4': u'\u7d46',
'\xda\xf5': u'\u822c',
'\xda\xf6': u'\u87e0',
'\xda\xf7': u'\u8fd4',
'\xda\xf8': u'\u9812',
'\xda\xf9': u'\u98ef',
'\xda\xfa': u'\u52c3',
'\xda\xfb': u'\u62d4',
'\xda\xfc': u'\u64a5',
'\xda\xfd': u'\u6e24',
'\xda\xfe': u'\u6f51',
'\xdb\xa1': u'\u767c',
'\xdb\xa2': u'\u8dcb',
'\xdb\xa3': u'\u91b1',
'\xdb\xa4': u'\u9262',
'\xdb\xa5': u'\u9aee',
'\xdb\xa6': u'\u9b43',
'\xdb\xa7': u'\u5023',
'\xdb\xa8': u'\u508d',
'\xdb\xa9': u'\u574a',
'\xdb\xaa': u'\u59a8',
'\xdb\xab': u'\u5c28',
'\xdb\xac': u'\u5e47',
'\xdb\xad': u'\u5f77',
'\xdb\xae': u'\u623f',
'\xdb\xaf': u'\u653e',
'\xdb\xb0': u'\u65b9',
'\xdb\xb1': u'\u65c1',
'\xdb\xb2': u'\u6609',
'\xdb\xb3': u'\u678b',
'\xdb\xb4': u'\u699c',
'\xdb\xb5': u'\u6ec2',
'\xdb\xb6': u'\u78c5',
'\xdb\xb7': u'\u7d21',
'\xdb\xb8': u'\u80aa',
'\xdb\xb9': u'\u8180',
'\xdb\xba': u'\u822b',
'\xdb\xbb': u'\u82b3',
'\xdb\xbc': u'\u84a1',
'\xdb\xbd': u'\u868c',
'\xdb\xbe': u'\u8a2a',
'\xdb\xbf': u'\u8b17',
'\xdb\xc0': u'\u90a6',
'\xdb\xc1': u'\u9632',
'\xdb\xc2': u'\u9f90',
'\xdb\xc3': u'\u500d',
'\xdb\xc4': u'\u4ff3',
'\xdb\xc5': u'\uf963',
'\xdb\xc6': u'\u57f9',
'\xdb\xc7': u'\u5f98',
'\xdb\xc8': u'\u62dc',
'\xdb\xc9': u'\u6392',
'\xdb\xca': u'\u676f',
'\xdb\xcb': u'\u6e43',
'\xdb\xcc': u'\u7119',
'\xdb\xcd': u'\u76c3',
'\xdb\xce': u'\u80cc',
'\xdb\xcf': u'\u80da',
'\xdb\xd0': u'\u88f4',
'\xdb\xd1': u'\u88f5',
'\xdb\xd2': u'\u8919',
'\xdb\xd3': u'\u8ce0',
'\xdb\xd4': u'\u8f29',
'\xdb\xd5': u'\u914d',
'\xdb\xd6': u'\u966a',
'\xdb\xd7': u'\u4f2f',
'\xdb\xd8': u'\u4f70',
'\xdb\xd9': u'\u5e1b',
'\xdb\xda': u'\u67cf',
'\xdb\xdb': u'\u6822',
'\xdb\xdc': u'\u767d',
'\xdb\xdd': u'\u767e',
'\xdb\xde': u'\u9b44',
'\xdb\xdf': u'\u5e61',
'\xdb\xe0': u'\u6a0a',
'\xdb\xe1': u'\u7169',
'\xdb\xe2': u'\u71d4',
'\xdb\xe3': u'\u756a',
'\xdb\xe4': u'\uf964',
'\xdb\xe5': u'\u7e41',
'\xdb\xe6': u'\u8543',
'\xdb\xe7': u'\u85e9',
'\xdb\xe8': u'\u98dc',
'\xdb\xe9': u'\u4f10',
'\xdb\xea': u'\u7b4f',
'\xdb\xeb': u'\u7f70',
'\xdb\xec': u'\u95a5',
'\xdb\xed': u'\u51e1',
'\xdb\xee': u'\u5e06',
'\xdb\xef': u'\u68b5',
'\xdb\xf0': u'\u6c3e',
'\xdb\xf1': u'\u6c4e',
'\xdb\xf2': u'\u6cdb',
'\xdb\xf3': u'\u72af',
'\xdb\xf4': u'\u7bc4',
'\xdb\xf5': u'\u8303',
'\xdb\xf6': u'\u6cd5',
'\xdb\xf7': u'\u743a',
'\xdb\xf8': u'\u50fb',
'\xdb\xf9': u'\u5288',
'\xdb\xfa': u'\u58c1',
'\xdb\xfb': u'\u64d8',
'\xdb\xfc': u'\u6a97',
'\xdb\xfd': u'\u74a7',
'\xdb\xfe': u'\u7656',
'\xdc\xa1': u'\u78a7',
'\xdc\xa2': u'\u8617',
'\xdc\xa3': u'\u95e2',
'\xdc\xa4': u'\u9739',
'\xdc\xa5': u'\uf965',
'\xdc\xa6': u'\u535e',
'\xdc\xa7': u'\u5f01',
'\xdc\xa8': u'\u8b8a',
'\xdc\xa9': u'\u8fa8',
'\xdc\xaa': u'\u8faf',
'\xdc\xab': u'\u908a',
'\xdc\xac': u'\u5225',
'\xdc\xad': u'\u77a5',
'\xdc\xae': u'\u9c49',
'\xdc\xaf': u'\u9f08',
'\xdc\xb0': u'\u4e19',
'\xdc\xb1': u'\u5002',
'\xdc\xb2': u'\u5175',
'\xdc\xb3': u'\u5c5b',
'\xdc\xb4': u'\u5e77',
'\xdc\xb5': u'\u661e',
'\xdc\xb6': u'\u663a',
'\xdc\xb7': u'\u67c4',
'\xdc\xb8': u'\u68c5',
'\xdc\xb9': u'\u70b3',
'\xdc\xba': u'\u7501',
'\xdc\xbb': u'\u75c5',
'\xdc\xbc': u'\u79c9',
'\xdc\xbd': u'\u7add',
'\xdc\xbe': u'\u8f27',
'\xdc\xbf': u'\u9920',
'\xdc\xc0': u'\u9a08',
'\xdc\xc1': u'\u4fdd',
'\xdc\xc2': u'\u5821',
'\xdc\xc3': u'\u5831',
'\xdc\xc4': u'\u5bf6',
'\xdc\xc5': u'\u666e',
'\xdc\xc6': u'\u6b65',
'\xdc\xc7': u'\u6d11',
'\xdc\xc8': u'\u6e7a',
'\xdc\xc9': u'\u6f7d',
'\xdc\xca': u'\u73e4',
'\xdc\xcb': u'\u752b',
'\xdc\xcc': u'\u83e9',
'\xdc\xcd': u'\u88dc',
'\xdc\xce': u'\u8913',
'\xdc\xcf': u'\u8b5c',
'\xdc\xd0': u'\u8f14',
'\xdc\xd1': u'\u4f0f',
'\xdc\xd2': u'\u50d5',
'\xdc\xd3': u'\u5310',
'\xdc\xd4': u'\u535c',
'\xdc\xd5': u'\u5b93',
'\xdc\xd6': u'\u5fa9',
'\xdc\xd7': u'\u670d',
'\xdc\xd8': u'\u798f',
'\xdc\xd9': u'\u8179',
'\xdc\xda': u'\u832f',
'\xdc\xdb': u'\u8514',
'\xdc\xdc': u'\u8907',
'\xdc\xdd': u'\u8986',
'\xdc\xde': u'\u8f39',
'\xdc\xdf': u'\u8f3b',
'\xdc\xe0': u'\u99a5',
'\xdc\xe1': u'\u9c12',
'\xdc\xe2': u'\u672c',
'\xdc\xe3': u'\u4e76',
'\xdc\xe4': u'\u4ff8',
'\xdc\xe5': u'\u5949',
'\xdc\xe6': u'\u5c01',
'\xdc\xe7': u'\u5cef',
'\xdc\xe8': u'\u5cf0',
'\xdc\xe9': u'\u6367',
'\xdc\xea': u'\u68d2',
'\xdc\xeb': u'\u70fd',
'\xdc\xec': u'\u71a2',
'\xdc\xed': u'\u742b',
'\xdc\xee': u'\u7e2b',
'\xdc\xef': u'\u84ec',
'\xdc\xf0': u'\u8702',
'\xdc\xf1': u'\u9022',
'\xdc\xf2': u'\u92d2',
'\xdc\xf3': u'\u9cf3',
'\xdc\xf4': u'\u4e0d',
'\xdc\xf5': u'\u4ed8',
'\xdc\xf6': u'\u4fef',
'\xdc\xf7': u'\u5085',
'\xdc\xf8': u'\u5256',
'\xdc\xf9': u'\u526f',
'\xdc\xfa': u'\u5426',
'\xdc\xfb': u'\u5490',
'\xdc\xfc': u'\u57e0',
'\xdc\xfd': u'\u592b',
'\xdc\xfe': u'\u5a66',
'\xdd\xa1': u'\u5b5a',
'\xdd\xa2': u'\u5b75',
'\xdd\xa3': u'\u5bcc',
'\xdd\xa4': u'\u5e9c',
'\xdd\xa5': u'\uf966',
'\xdd\xa6': u'\u6276',
'\xdd\xa7': u'\u6577',
'\xdd\xa8': u'\u65a7',
'\xdd\xa9': u'\u6d6e',
'\xdd\xaa': u'\u6ea5',
'\xdd\xab': u'\u7236',
'\xdd\xac': u'\u7b26',
'\xdd\xad': u'\u7c3f',
'\xdd\xae': u'\u7f36',
'\xdd\xaf': u'\u8150',
'\xdd\xb0': u'\u8151',
'\xdd\xb1': u'\u819a',
'\xdd\xb2': u'\u8240',
'\xdd\xb3': u'\u8299',
'\xdd\xb4': u'\u83a9',
'\xdd\xb5': u'\u8a03',
'\xdd\xb6': u'\u8ca0',
'\xdd\xb7': u'\u8ce6',
'\xdd\xb8': u'\u8cfb',
'\xdd\xb9': u'\u8d74',
'\xdd\xba': u'\u8dba',
'\xdd\xbb': u'\u90e8',
'\xdd\xbc': u'\u91dc',
'\xdd\xbd': u'\u961c',
'\xdd\xbe': u'\u9644',
'\xdd\xbf': u'\u99d9',
'\xdd\xc0': u'\u9ce7',
'\xdd\xc1': u'\u5317',
'\xdd\xc2': u'\u5206',
'\xdd\xc3': u'\u5429',
'\xdd\xc4': u'\u5674',
'\xdd\xc5': u'\u58b3',
'\xdd\xc6': u'\u5954',
'\xdd\xc7': u'\u596e',
'\xdd\xc8': u'\u5fff',
'\xdd\xc9': u'\u61a4',
'\xdd\xca': u'\u626e',
'\xdd\xcb': u'\u6610',
'\xdd\xcc': u'\u6c7e',
'\xdd\xcd': u'\u711a',
'\xdd\xce': u'\u76c6',
'\xdd\xcf': u'\u7c89',
'\xdd\xd0': u'\u7cde',
'\xdd\xd1': u'\u7d1b',
'\xdd\xd2': u'\u82ac',
'\xdd\xd3': u'\u8cc1',
'\xdd\xd4': u'\u96f0',
'\xdd\xd5': u'\uf967',
'\xdd\xd6': u'\u4f5b',
'\xdd\xd7': u'\u5f17',
'\xdd\xd8': u'\u5f7f',
'\xdd\xd9': u'\u62c2',
'\xdd\xda': u'\u5d29',
'\xdd\xdb': u'\u670b',
'\xdd\xdc': u'\u68da',
'\xdd\xdd': u'\u787c',
'\xdd\xde': u'\u7e43',
'\xdd\xdf': u'\u9d6c',
'\xdd\xe0': u'\u4e15',
'\xdd\xe1': u'\u5099',
'\xdd\xe2': u'\u5315',
'\xdd\xe3': u'\u532a',
'\xdd\xe4': u'\u5351',
'\xdd\xe5': u'\u5983',
'\xdd\xe6': u'\u5a62',
'\xdd\xe7': u'\u5e87',
'\xdd\xe8': u'\u60b2',
'\xdd\xe9': u'\u618a',
'\xdd\xea': u'\u6249',
'\xdd\xeb': u'\u6279',
'\xdd\xec': u'\u6590',
'\xdd\xed': u'\u6787',
'\xdd\xee': u'\u69a7',
'\xdd\xef': u'\u6bd4',
'\xdd\xf0': u'\u6bd6',
'\xdd\xf1': u'\u6bd7',
'\xdd\xf2': u'\u6bd8',
'\xdd\xf3': u'\u6cb8',
'\xdd\xf4': u'\uf968',
'\xdd\xf5': u'\u7435',
'\xdd\xf6': u'\u75fa',
'\xdd\xf7': u'\u7812',
'\xdd\xf8': u'\u7891',
'\xdd\xf9': u'\u79d5',
'\xdd\xfa': u'\u79d8',
'\xdd\xfb': u'\u7c83',
'\xdd\xfc': u'\u7dcb',
'\xdd\xfd': u'\u7fe1',
'\xdd\xfe': u'\u80a5',
'\xde\xa1': u'\u813e',
'\xde\xa2': u'\u81c2',
'\xde\xa3': u'\u83f2',
'\xde\xa4': u'\u871a',
'\xde\xa5': u'\u88e8',
'\xde\xa6': u'\u8ab9',
'\xde\xa7': u'\u8b6c',
'\xde\xa8': u'\u8cbb',
'\xde\xa9': u'\u9119',
'\xde\xaa': u'\u975e',
'\xde\xab': u'\u98db',
'\xde\xac': u'\u9f3b',
'\xde\xad': u'\u56ac',
'\xde\xae': u'\u5b2a',
'\xde\xaf': u'\u5f6c',
'\xde\xb0': u'\u658c',
'\xde\xb1': u'\u6ab3',
'\xde\xb2': u'\u6baf',
'\xde\xb3': u'\u6d5c',
'\xde\xb4': u'\u6ff1',
'\xde\xb5': u'\u7015',
'\xde\xb6': u'\u725d',
'\xde\xb7': u'\u73ad',
'\xde\xb8': u'\u8ca7',
'\xde\xb9': u'\u8cd3',
'\xde\xba': u'\u983b',
'\xde\xbb': u'\u6191',
'\xde\xbc': u'\u6c37',
'\xde\xbd': u'\u8058',
'\xde\xbe': u'\u9a01',
'\xde\xbf': u'\u4e4d',
'\xde\xc0': u'\u4e8b',
'\xde\xc1': u'\u4e9b',
'\xde\xc2': u'\u4ed5',
'\xde\xc3': u'\u4f3a',
'\xde\xc4': u'\u4f3c',
'\xde\xc5': u'\u4f7f',
'\xde\xc6': u'\u4fdf',
'\xde\xc7': u'\u50ff',
'\xde\xc8': u'\u53f2',
'\xde\xc9': u'\u53f8',
'\xde\xca': u'\u5506',
'\xde\xcb': u'\u55e3',
'\xde\xcc': u'\u56db',
'\xde\xcd': u'\u58eb',
'\xde\xce': u'\u5962',
'\xde\xcf': u'\u5a11',
'\xde\xd0': u'\u5beb',
'\xde\xd1': u'\u5bfa',
'\xde\xd2': u'\u5c04',
'\xde\xd3': u'\u5df3',
'\xde\xd4': u'\u5e2b',
'\xde\xd5': u'\u5f99',
'\xde\xd6': u'\u601d',
'\xde\xd7': u'\u6368',
'\xde\xd8': u'\u659c',
'\xde\xd9': u'\u65af',
'\xde\xda': u'\u67f6',
'\xde\xdb': u'\u67fb',
'\xde\xdc': u'\u68ad',
'\xde\xdd': u'\u6b7b',
'\xde\xde': u'\u6c99',
'\xde\xdf': u'\u6cd7',
'\xde\xe0': u'\u6e23',
'\xde\xe1': u'\u7009',
'\xde\xe2': u'\u7345',
'\xde\xe3': u'\u7802',
'\xde\xe4': u'\u793e',
'\xde\xe5': u'\u7940',
'\xde\xe6': u'\u7960',
'\xde\xe7': u'\u79c1',
'\xde\xe8': u'\u7be9',
'\xde\xe9': u'\u7d17',
'\xde\xea': u'\u7d72',
'\xde\xeb': u'\u8086',
'\xde\xec': u'\u820d',
'\xde\xed': u'\u838e',
'\xde\xee': u'\u84d1',
'\xde\xef': u'\u86c7',
'\xde\xf0': u'\u88df',
'\xde\xf1': u'\u8a50',
'\xde\xf2': u'\u8a5e',
'\xde\xf3': u'\u8b1d',
'\xde\xf4': u'\u8cdc',
'\xde\xf5': u'\u8d66',
'\xde\xf6': u'\u8fad',
'\xde\xf7': u'\u90aa',
'\xde\xf8': u'\u98fc',
'\xde\xf9': u'\u99df',
'\xde\xfa': u'\u9e9d',
'\xde\xfb': u'\u524a',
'\xde\xfc': u'\uf969',
'\xde\xfd': u'\u6714',
'\xde\xfe': u'\uf96a',
'\xdf\xa1': u'\u5098',
'\xdf\xa2': u'\u522a',
'\xdf\xa3': u'\u5c71',
'\xdf\xa4': u'\u6563',
'\xdf\xa5': u'\u6c55',
'\xdf\xa6': u'\u73ca',
'\xdf\xa7': u'\u7523',
'\xdf\xa8': u'\u759d',
'\xdf\xa9': u'\u7b97',
'\xdf\xaa': u'\u849c',
'\xdf\xab': u'\u9178',
'\xdf\xac': u'\u9730',
'\xdf\xad': u'\u4e77',
'\xdf\xae': u'\u6492',
'\xdf\xaf': u'\u6bba',
'\xdf\xb0': u'\u715e',
'\xdf\xb1': u'\u85a9',
'\xdf\xb2': u'\u4e09',
'\xdf\xb3': u'\uf96b',
'\xdf\xb4': u'\u6749',
'\xdf\xb5': u'\u68ee',
'\xdf\xb6': u'\u6e17',
'\xdf\xb7': u'\u829f',
'\xdf\xb8': u'\u8518',
'\xdf\xb9': u'\u886b',
'\xdf\xba': u'\u63f7',
'\xdf\xbb': u'\u6f81',
'\xdf\xbc': u'\u9212',
'\xdf\xbd': u'\u98af',
'\xdf\xbe': u'\u4e0a',
'\xdf\xbf': u'\u50b7',
'\xdf\xc0': u'\u50cf',
'\xdf\xc1': u'\u511f',
'\xdf\xc2': u'\u5546',
'\xdf\xc3': u'\u55aa',
'\xdf\xc4': u'\u5617',
'\xdf\xc5': u'\u5b40',
'\xdf\xc6': u'\u5c19',
'\xdf\xc7': u'\u5ce0',
'\xdf\xc8': u'\u5e38',
'\xdf\xc9': u'\u5e8a',
'\xdf\xca': u'\u5ea0',
'\xdf\xcb': u'\u5ec2',
'\xdf\xcc': u'\u60f3',
'\xdf\xcd': u'\u6851',
'\xdf\xce': u'\u6a61',
'\xdf\xcf': u'\u6e58',
'\xdf\xd0': u'\u723d',
'\xdf\xd1': u'\u7240',
'\xdf\xd2': u'\u72c0',
'\xdf\xd3': u'\u76f8',
'\xdf\xd4': u'\u7965',
'\xdf\xd5': u'\u7bb1',
'\xdf\xd6': u'\u7fd4',
'\xdf\xd7': u'\u88f3',
'\xdf\xd8': u'\u89f4',
'\xdf\xd9': u'\u8a73',
'\xdf\xda': u'\u8c61',
'\xdf\xdb': u'\u8cde',
'\xdf\xdc': u'\u971c',
'\xdf\xdd': u'\u585e',
'\xdf\xde': u'\u74bd',
'\xdf\xdf': u'\u8cfd',
'\xdf\xe0': u'\u55c7',
'\xdf\xe1': u'\uf96c',
'\xdf\xe2': u'\u7a61',
'\xdf\xe3': u'\u7d22',
'\xdf\xe4': u'\u8272',
'\xdf\xe5': u'\u7272',
'\xdf\xe6': u'\u751f',
'\xdf\xe7': u'\u7525',
'\xdf\xe8': u'\uf96d',
'\xdf\xe9': u'\u7b19',
'\xdf\xea': u'\u5885',
'\xdf\xeb': u'\u58fb',
'\xdf\xec': u'\u5dbc',
'\xdf\xed': u'\u5e8f',
'\xdf\xee': u'\u5eb6',
'\xdf\xef': u'\u5f90',
'\xdf\xf0': u'\u6055',
'\xdf\xf1': u'\u6292',
'\xdf\xf2': u'\u637f',
'\xdf\xf3': u'\u654d',
'\xdf\xf4': u'\u6691',
'\xdf\xf5': u'\u66d9',
'\xdf\xf6': u'\u66f8',
'\xdf\xf7': u'\u6816',
'\xdf\xf8': u'\u68f2',
'\xdf\xf9': u'\u7280',
'\xdf\xfa': u'\u745e',
'\xdf\xfb': u'\u7b6e',
'\xdf\xfc': u'\u7d6e',
'\xdf\xfd': u'\u7dd6',
'\xdf\xfe': u'\u7f72',
'\xe0\xa1': u'\u80e5',
'\xe0\xa2': u'\u8212',
'\xe0\xa3': u'\u85af',
'\xe0\xa4': u'\u897f',
'\xe0\xa5': u'\u8a93',
'\xe0\xa6': u'\u901d',
'\xe0\xa7': u'\u92e4',
'\xe0\xa8': u'\u9ecd',
'\xe0\xa9': u'\u9f20',
'\xe0\xaa': u'\u5915',
'\xe0\xab': u'\u596d',
'\xe0\xac': u'\u5e2d',
'\xe0\xad': u'\u60dc',
'\xe0\xae': u'\u6614',
'\xe0\xaf': u'\u6673',
'\xe0\xb0': u'\u6790',
'\xe0\xb1': u'\u6c50',
'\xe0\xb2': u'\u6dc5',
'\xe0\xb3': u'\u6f5f',
'\xe0\xb4': u'\u77f3',
'\xe0\xb5': u'\u78a9',
'\xe0\xb6': u'\u84c6',
'\xe0\xb7': u'\u91cb',
'\xe0\xb8': u'\u932b',
'\xe0\xb9': u'\u4ed9',
'\xe0\xba': u'\u50ca',
'\xe0\xbb': u'\u5148',
'\xe0\xbc': u'\u5584',
'\xe0\xbd': u'\u5b0b',
'\xe0\xbe': u'\u5ba3',
'\xe0\xbf': u'\u6247',
'\xe0\xc0': u'\u657e',
'\xe0\xc1': u'\u65cb',
'\xe0\xc2': u'\u6e32',
'\xe0\xc3': u'\u717d',
'\xe0\xc4': u'\u7401',
'\xe0\xc5': u'\u7444',
'\xe0\xc6': u'\u7487',
'\xe0\xc7': u'\u74bf',
'\xe0\xc8': u'\u766c',
'\xe0\xc9': u'\u79aa',
'\xe0\xca': u'\u7dda',
'\xe0\xcb': u'\u7e55',
'\xe0\xcc': u'\u7fa8',
'\xe0\xcd': u'\u817a',
'\xe0\xce': u'\u81b3',
'\xe0\xcf': u'\u8239',
'\xe0\xd0': u'\u861a',
'\xe0\xd1': u'\u87ec',
'\xe0\xd2': u'\u8a75',
'\xe0\xd3': u'\u8de3',
'\xe0\xd4': u'\u9078',
'\xe0\xd5': u'\u9291',
'\xe0\xd6': u'\u9425',
'\xe0\xd7': u'\u994d',
'\xe0\xd8': u'\u9bae',
'\xe0\xd9': u'\u5368',
'\xe0\xda': u'\u5c51',
'\xe0\xdb': u'\u6954',
'\xe0\xdc': u'\u6cc4',
'\xe0\xdd': u'\u6d29',
'\xe0\xde': u'\u6e2b',
'\xe0\xdf': u'\u820c',
'\xe0\xe0': u'\u859b',
'\xe0\xe1': u'\u893b',
'\xe0\xe2': u'\u8a2d',
'\xe0\xe3': u'\u8aaa',
'\xe0\xe4': u'\u96ea',
'\xe0\xe5': u'\u9f67',
'\xe0\xe6': u'\u5261',
'\xe0\xe7': u'\u66b9',
'\xe0\xe8': u'\u6bb2',
'\xe0\xe9': u'\u7e96',
'\xe0\xea': u'\u87fe',
'\xe0\xeb': u'\u8d0d',
'\xe0\xec': u'\u9583',
'\xe0\xed': u'\u965d',
'\xe0\xee': u'\u651d',
'\xe0\xef': u'\u6d89',
'\xe0\xf0': u'\u71ee',
'\xe0\xf1': u'\uf96e',
'\xe0\xf2': u'\u57ce',
'\xe0\xf3': u'\u59d3',
'\xe0\xf4': u'\u5bac',
'\xe0\xf5': u'\u6027',
'\xe0\xf6': u'\u60fa',
'\xe0\xf7': u'\u6210',
'\xe0\xf8': u'\u661f',
'\xe0\xf9': u'\u665f',
'\xe0\xfa': u'\u7329',
'\xe0\xfb': u'\u73f9',
'\xe0\xfc': u'\u76db',
'\xe0\xfd': u'\u7701',
'\xe0\xfe': u'\u7b6c',
'\xe1\xa1': u'\u8056',
'\xe1\xa2': u'\u8072',
'\xe1\xa3': u'\u8165',
'\xe1\xa4': u'\u8aa0',
'\xe1\xa5': u'\u9192',
'\xe1\xa6': u'\u4e16',
'\xe1\xa7': u'\u52e2',
'\xe1\xa8': u'\u6b72',
'\xe1\xa9': u'\u6d17',
'\xe1\xaa': u'\u7a05',
'\xe1\xab': u'\u7b39',
'\xe1\xac': u'\u7d30',
'\xe1\xad': u'\uf96f',
'\xe1\xae': u'\u8cb0',
'\xe1\xaf': u'\u53ec',
'\xe1\xb0': u'\u562f',
'\xe1\xb1': u'\u5851',
'\xe1\xb2': u'\u5bb5',
'\xe1\xb3': u'\u5c0f',
'\xe1\xb4': u'\u5c11',
'\xe1\xb5': u'\u5de2',
'\xe1\xb6': u'\u6240',
'\xe1\xb7': u'\u6383',
'\xe1\xb8': u'\u6414',
'\xe1\xb9': u'\u662d',
'\xe1\xba': u'\u68b3',
'\xe1\xbb': u'\u6cbc',
'\xe1\xbc': u'\u6d88',
'\xe1\xbd': u'\u6eaf',
'\xe1\xbe': u'\u701f',
'\xe1\xbf': u'\u70a4',
'\xe1\xc0': u'\u71d2',
'\xe1\xc1': u'\u7526',
'\xe1\xc2': u'\u758f',
'\xe1\xc3': u'\u758e',
'\xe1\xc4': u'\u7619',
'\xe1\xc5': u'\u7b11',
'\xe1\xc6': u'\u7be0',
'\xe1\xc7': u'\u7c2b',
'\xe1\xc8': u'\u7d20',
'\xe1\xc9': u'\u7d39',
'\xe1\xca': u'\u852c',
'\xe1\xcb': u'\u856d',
'\xe1\xcc': u'\u8607',
'\xe1\xcd': u'\u8a34',
'\xe1\xce': u'\u900d',
'\xe1\xcf': u'\u9061',
'\xe1\xd0': u'\u90b5',
'\xe1\xd1': u'\u92b7',
'\xe1\xd2': u'\u97f6',
'\xe1\xd3': u'\u9a37',
'\xe1\xd4': u'\u4fd7',
'\xe1\xd5': u'\u5c6c',
'\xe1\xd6': u'\u675f',
'\xe1\xd7': u'\u6d91',
'\xe1\xd8': u'\u7c9f',
'\xe1\xd9': u'\u7e8c',
'\xe1\xda': u'\u8b16',
'\xe1\xdb': u'\u8d16',
'\xe1\xdc': u'\u901f',
'\xe1\xdd': u'\u5b6b',
'\xe1\xde': u'\u5dfd',
'\xe1\xdf': u'\u640d',
'\xe1\xe0': u'\u84c0',
'\xe1\xe1': u'\u905c',
'\xe1\xe2': u'\u98e1',
'\xe1\xe3': u'\u7387',
'\xe1\xe4': u'\u5b8b',
'\xe1\xe5': u'\u609a',
'\xe1\xe6': u'\u677e',
'\xe1\xe7': u'\u6dde',
'\xe1\xe8': u'\u8a1f',
'\xe1\xe9': u'\u8aa6',
'\xe1\xea': u'\u9001',
'\xe1\xeb': u'\u980c',
'\xe1\xec': u'\u5237',
'\xe1\xed': u'\uf970',
'\xe1\xee': u'\u7051',
'\xe1\xef': u'\u788e',
'\xe1\xf0': u'\u9396',
'\xe1\xf1': u'\u8870',
'\xe1\xf2': u'\u91d7',
'\xe1\xf3': u'\u4fee',
'\xe1\xf4': u'\u53d7',
'\xe1\xf5': u'\u55fd',
'\xe1\xf6': u'\u56da',
'\xe1\xf7': u'\u5782',
'\xe1\xf8': u'\u58fd',
'\xe1\xf9': u'\u5ac2',
'\xe1\xfa': u'\u5b88',
'\xe1\xfb': u'\u5cab',
'\xe1\xfc': u'\u5cc0',
'\xe1\xfd': u'\u5e25',
'\xe1\xfe': u'\u6101',
'\xe2\xa1': u'\u620d',
'\xe2\xa2': u'\u624b',
'\xe2\xa3': u'\u6388',
'\xe2\xa4': u'\u641c',
'\xe2\xa5': u'\u6536',
'\xe2\xa6': u'\u6578',
'\xe2\xa7': u'\u6a39',
'\xe2\xa8': u'\u6b8a',
'\xe2\xa9': u'\u6c34',
'\xe2\xaa': u'\u6d19',
'\xe2\xab': u'\u6f31',
'\xe2\xac': u'\u71e7',
'\xe2\xad': u'\u72e9',
'\xe2\xae': u'\u7378',
'\xe2\xaf': u'\u7407',
'\xe2\xb0': u'\u74b2',
'\xe2\xb1': u'\u7626',
'\xe2\xb2': u'\u7761',
'\xe2\xb3': u'\u79c0',
'\xe2\xb4': u'\u7a57',
'\xe2\xb5': u'\u7aea',
'\xe2\xb6': u'\u7cb9',
'\xe2\xb7': u'\u7d8f',
'\xe2\xb8': u'\u7dac',
'\xe2\xb9': u'\u7e61',
'\xe2\xba': u'\u7f9e',
'\xe2\xbb': u'\u8129',
'\xe2\xbc': u'\u8331',
'\xe2\xbd': u'\u8490',
'\xe2\xbe': u'\u84da',
'\xe2\xbf': u'\u85ea',
'\xe2\xc0': u'\u8896',
'\xe2\xc1': u'\u8ab0',
'\xe2\xc2': u'\u8b90',
'\xe2\xc3': u'\u8f38',
'\xe2\xc4': u'\u9042',
'\xe2\xc5': u'\u9083',
'\xe2\xc6': u'\u916c',
'\xe2\xc7': u'\u9296',
'\xe2\xc8': u'\u92b9',
'\xe2\xc9': u'\u968b',
'\xe2\xca': u'\u96a7',
'\xe2\xcb': u'\u96a8',
'\xe2\xcc': u'\u96d6',
'\xe2\xcd': u'\u9700',
'\xe2\xce': u'\u9808',
'\xe2\xcf': u'\u9996',
'\xe2\xd0': u'\u9ad3',
'\xe2\xd1': u'\u9b1a',
'\xe2\xd2': u'\u53d4',
'\xe2\xd3': u'\u587e',
'\xe2\xd4': u'\u5919',
'\xe2\xd5': u'\u5b70',
'\xe2\xd6': u'\u5bbf',
'\xe2\xd7': u'\u6dd1',
'\xe2\xd8': u'\u6f5a',
'\xe2\xd9': u'\u719f',
'\xe2\xda': u'\u7421',
'\xe2\xdb': u'\u74b9',
'\xe2\xdc': u'\u8085',
'\xe2\xdd': u'\u83fd',
'\xe2\xde': u'\u5de1',
'\xe2\xdf': u'\u5f87',
'\xe2\xe0': u'\u5faa',
'\xe2\xe1': u'\u6042',
'\xe2\xe2': u'\u65ec',
'\xe2\xe3': u'\u6812',
'\xe2\xe4': u'\u696f',
'\xe2\xe5': u'\u6a53',
'\xe2\xe6': u'\u6b89',
'\xe2\xe7': u'\u6d35',
'\xe2\xe8': u'\u6df3',
'\xe2\xe9': u'\u73e3',
'\xe2\xea': u'\u76fe',
'\xe2\xeb': u'\u77ac',
'\xe2\xec': u'\u7b4d',
'\xe2\xed': u'\u7d14',
'\xe2\xee': u'\u8123',
'\xe2\xef': u'\u821c',
'\xe2\xf0': u'\u8340',
'\xe2\xf1': u'\u84f4',
'\xe2\xf2': u'\u8563',
'\xe2\xf3': u'\u8a62',
'\xe2\xf4': u'\u8ac4',
'\xe2\xf5': u'\u9187',
'\xe2\xf6': u'\u931e',
'\xe2\xf7': u'\u9806',
'\xe2\xf8': u'\u99b4',
'\xe2\xf9': u'\u620c',
'\xe2\xfa': u'\u8853',
'\xe2\xfb': u'\u8ff0',
'\xe2\xfc': u'\u9265',
'\xe2\xfd': u'\u5d07',
'\xe2\xfe': u'\u5d27',
'\xe3\xa1': u'\u5d69',
'\xe3\xa2': u'\u745f',
'\xe3\xa3': u'\u819d',
'\xe3\xa4': u'\u8768',
'\xe3\xa5': u'\u6fd5',
'\xe3\xa6': u'\u62fe',
'\xe3\xa7': u'\u7fd2',
'\xe3\xa8': u'\u8936',
'\xe3\xa9': u'\u8972',
'\xe3\xaa': u'\u4e1e',
'\xe3\xab': u'\u4e58',
'\xe3\xac': u'\u50e7',
'\xe3\xad': u'\u52dd',
'\xe3\xae': u'\u5347',
'\xe3\xaf': u'\u627f',
'\xe3\xb0': u'\u6607',
'\xe3\xb1': u'\u7e69',
'\xe3\xb2': u'\u8805',
'\xe3\xb3': u'\u965e',
'\xe3\xb4': u'\u4f8d',
'\xe3\xb5': u'\u5319',
'\xe3\xb6': u'\u5636',
'\xe3\xb7': u'\u59cb',
'\xe3\xb8': u'\u5aa4',
'\xe3\xb9': u'\u5c38',
'\xe3\xba': u'\u5c4e',
'\xe3\xbb': u'\u5c4d',
'\xe3\xbc': u'\u5e02',
'\xe3\xbd': u'\u5f11',
'\xe3\xbe': u'\u6043',
'\xe3\xbf': u'\u65bd',
'\xe3\xc0': u'\u662f',
'\xe3\xc1': u'\u6642',
'\xe3\xc2': u'\u67be',
'\xe3\xc3': u'\u67f4',
'\xe3\xc4': u'\u731c',
'\xe3\xc5': u'\u77e2',
'\xe3\xc6': u'\u793a',
'\xe3\xc7': u'\u7fc5',
'\xe3\xc8': u'\u8494',
'\xe3\xc9': u'\u84cd',
'\xe3\xca': u'\u8996',
'\xe3\xcb': u'\u8a66',
'\xe3\xcc': u'\u8a69',
'\xe3\xcd': u'\u8ae1',
'\xe3\xce': u'\u8c55',
'\xe3\xcf': u'\u8c7a',
'\xe3\xd0': u'\u57f4',
'\xe3\xd1': u'\u5bd4',
'\xe3\xd2': u'\u5f0f',
'\xe3\xd3': u'\u606f',
'\xe3\xd4': u'\u62ed',
'\xe3\xd5': u'\u690d',
'\xe3\xd6': u'\u6b96',
'\xe3\xd7': u'\u6e5c',
'\xe3\xd8': u'\u7184',
'\xe3\xd9': u'\u7bd2',
'\xe3\xda': u'\u8755',
'\xe3\xdb': u'\u8b58',
'\xe3\xdc': u'\u8efe',
'\xe3\xdd': u'\u98df',
'\xe3\xde': u'\u98fe',
'\xe3\xdf': u'\u4f38',
'\xe3\xe0': u'\u4f81',
'\xe3\xe1': u'\u4fe1',
'\xe3\xe2': u'\u547b',
'\xe3\xe3': u'\u5a20',
'\xe3\xe4': u'\u5bb8',
'\xe3\xe5': u'\u613c',
'\xe3\xe6': u'\u65b0',
'\xe3\xe7': u'\u6668',
'\xe3\xe8': u'\u71fc',
'\xe3\xe9': u'\u7533',
'\xe3\xea': u'\u795e',
'\xe3\xeb': u'\u7d33',
'\xe3\xec': u'\u814e',
'\xe3\xed': u'\u81e3',
'\xe3\xee': u'\u8398',
'\xe3\xef': u'\u85aa',
'\xe3\xf0': u'\u85ce',
'\xe3\xf1': u'\u8703',
'\xe3\xf2': u'\u8a0a',
'\xe3\xf3': u'\u8eab',
'\xe3\xf4': u'\u8f9b',
'\xe3\xf5': u'\uf971',
'\xe3\xf6': u'\u8fc5',
'\xe3\xf7': u'\u5931',
'\xe3\xf8': u'\u5ba4',
'\xe3\xf9': u'\u5be6',
'\xe3\xfa': u'\u6089',
'\xe3\xfb': u'\u5be9',
'\xe3\xfc': u'\u5c0b',
'\xe3\xfd': u'\u5fc3',
'\xe3\xfe': u'\u6c81',
'\xe4\xa1': u'\uf972',
'\xe4\xa2': u'\u6df1',
'\xe4\xa3': u'\u700b',
'\xe4\xa4': u'\u751a',
'\xe4\xa5': u'\u82af',
'\xe4\xa6': u'\u8af6',
'\xe4\xa7': u'\u4ec0',
'\xe4\xa8': u'\u5341',
'\xe4\xa9': u'\uf973',
'\xe4\xaa': u'\u96d9',
'\xe4\xab': u'\u6c0f',
'\xe4\xac': u'\u4e9e',
'\xe4\xad': u'\u4fc4',
'\xe4\xae': u'\u5152',
'\xe4\xaf': u'\u555e',
'\xe4\xb0': u'\u5a25',
'\xe4\xb1': u'\u5ce8',
'\xe4\xb2': u'\u6211',
'\xe4\xb3': u'\u7259',
'\xe4\xb4': u'\u82bd',
'\xe4\xb5': u'\u83aa',
'\xe4\xb6': u'\u86fe',
'\xe4\xb7': u'\u8859',
'\xe4\xb8': u'\u8a1d',
'\xe4\xb9': u'\u963f',
'\xe4\xba': u'\u96c5',
'\xe4\xbb': u'\u9913',
'\xe4\xbc': u'\u9d09',
'\xe4\xbd': u'\u9d5d',
'\xe4\xbe': u'\u580a',
'\xe4\xbf': u'\u5cb3',
'\xe4\xc0': u'\u5dbd',
'\xe4\xc1': u'\u5e44',
'\xe4\xc2': u'\u60e1',
'\xe4\xc3': u'\u6115',
'\xe4\xc4': u'\u63e1',
'\xe4\xc5': u'\u6a02',
'\xe4\xc6': u'\u6e25',
'\xe4\xc7': u'\u9102',
'\xe4\xc8': u'\u9354',
'\xe4\xc9': u'\u984e',
'\xe4\xca': u'\u9c10',
'\xe4\xcb': u'\u9f77',
'\xe4\xcc': u'\u5b89',
'\xe4\xcd': u'\u5cb8',
'\xe4\xce': u'\u6309',
'\xe4\xcf': u'\u664f',
'\xe4\xd0': u'\u6848',
'\xe4\xd1': u'\u773c',
'\xe4\xd2': u'\u96c1',
'\xe4\xd3': u'\u978d',
'\xe4\xd4': u'\u9854',
'\xe4\xd5': u'\u9b9f',
'\xe4\xd6': u'\u65a1',
'\xe4\xd7': u'\u8b01',
'\xe4\xd8': u'\u8ecb',
'\xe4\xd9': u'\u95bc',
'\xe4\xda': u'\u5535',
'\xe4\xdb': u'\u5ca9',
'\xe4\xdc': u'\u5dd6',
'\xe4\xdd': u'\u5eb5',
'\xe4\xde': u'\u6697',
'\xe4\xdf': u'\u764c',
'\xe4\xe0': u'\u83f4',
'\xe4\xe1': u'\u95c7',
'\xe4\xe2': u'\u58d3',
'\xe4\xe3': u'\u62bc',
'\xe4\xe4': u'\u72ce',
'\xe4\xe5': u'\u9d28',
'\xe4\xe6': u'\u4ef0',
'\xe4\xe7': u'\u592e',
'\xe4\xe8': u'\u600f',
'\xe4\xe9': u'\u663b',
'\xe4\xea': u'\u6b83',
'\xe4\xeb': u'\u79e7',
'\xe4\xec': u'\u9d26',
'\xe4\xed': u'\u5393',
'\xe4\xee': u'\u54c0',
'\xe4\xef': u'\u57c3',
'\xe4\xf0': u'\u5d16',
'\xe4\xf1': u'\u611b',
'\xe4\xf2': u'\u66d6',
'\xe4\xf3': u'\u6daf',
'\xe4\xf4': u'\u788d',
'\xe4\xf5': u'\u827e',
'\xe4\xf6': u'\u9698',
'\xe4\xf7': u'\u9744',
'\xe4\xf8': u'\u5384',
'\xe4\xf9': u'\u627c',
'\xe4\xfa': u'\u6396',
'\xe4\xfb': u'\u6db2',
'\xe4\xfc': u'\u7e0a',
'\xe4\xfd': u'\u814b',
'\xe4\xfe': u'\u984d',
'\xe5\xa1': u'\u6afb',
'\xe5\xa2': u'\u7f4c',
'\xe5\xa3': u'\u9daf',
'\xe5\xa4': u'\u9e1a',
'\xe5\xa5': u'\u4e5f',
'\xe5\xa6': u'\u503b',
'\xe5\xa7': u'\u51b6',
'\xe5\xa8': u'\u591c',
'\xe5\xa9': u'\u60f9',
'\xe5\xaa': u'\u63f6',
'\xe5\xab': u'\u6930',
'\xe5\xac': u'\u723a',
'\xe5\xad': u'\u8036',
'\xe5\xae': u'\uf974',
'\xe5\xaf': u'\u91ce',
'\xe5\xb0': u'\u5f31',
'\xe5\xb1': u'\uf975',
'\xe5\xb2': u'\uf976',
'\xe5\xb3': u'\u7d04',
'\xe5\xb4': u'\u82e5',
'\xe5\xb5': u'\u846f',
'\xe5\xb6': u'\u84bb',
'\xe5\xb7': u'\u85e5',
'\xe5\xb8': u'\u8e8d',
'\xe5\xb9': u'\uf977',
'\xe5\xba': u'\u4f6f',
'\xe5\xbb': u'\uf978',
'\xe5\xbc': u'\uf979',
'\xe5\xbd': u'\u58e4',
'\xe5\xbe': u'\u5b43',
'\xe5\xbf': u'\u6059',
'\xe5\xc0': u'\u63da',
'\xe5\xc1': u'\u6518',
'\xe5\xc2': u'\u656d',
'\xe5\xc3': u'\u6698',
'\xe5\xc4': u'\uf97a',
'\xe5\xc5': u'\u694a',
'\xe5\xc6': u'\u6a23',
'\xe5\xc7': u'\u6d0b',
'\xe5\xc8': u'\u7001',
'\xe5\xc9': u'\u716c',
'\xe5\xca': u'\u75d2',
'\xe5\xcb': u'\u760d',
'\xe5\xcc': u'\u79b3',
'\xe5\xcd': u'\u7a70',
'\xe5\xce': u'\uf97b',
'\xe5\xcf': u'\u7f8a',
'\xe5\xd0': u'\uf97c',
'\xe5\xd1': u'\u8944',
'\xe5\xd2': u'\uf97d',
'\xe5\xd3': u'\u8b93',
'\xe5\xd4': u'\u91c0',
'\xe5\xd5': u'\u967d',
'\xe5\xd6': u'\uf97e',
'\xe5\xd7': u'\u990a',
'\xe5\xd8': u'\u5704',
'\xe5\xd9': u'\u5fa1',
'\xe5\xda': u'\u65bc',
'\xe5\xdb': u'\u6f01',
'\xe5\xdc': u'\u7600',
'\xe5\xdd': u'\u79a6',
'\xe5\xde': u'\u8a9e',
'\xe5\xdf': u'\u99ad',
'\xe5\xe0': u'\u9b5a',
'\xe5\xe1': u'\u9f6c',
'\xe5\xe2': u'\u5104',
'\xe5\xe3': u'\u61b6',
'\xe5\xe4': u'\u6291',
'\xe5\xe5': u'\u6a8d',
'\xe5\xe6': u'\u81c6',
'\xe5\xe7': u'\u5043',
'\xe5\xe8': u'\u5830',
'\xe5\xe9': u'\u5f66',
'\xe5\xea': u'\u7109',
'\xe5\xeb': u'\u8a00',
'\xe5\xec': u'\u8afa',
'\xe5\xed': u'\u5b7c',
'\xe5\xee': u'\u8616',
'\xe5\xef': u'\u4ffa',
'\xe5\xf0': u'\u513c',
'\xe5\xf1': u'\u56b4',
'\xe5\xf2': u'\u5944',
'\xe5\xf3': u'\u63a9',
'\xe5\xf4': u'\u6df9',
'\xe5\xf5': u'\u5daa',
'\xe5\xf6': u'\u696d',
'\xe5\xf7': u'\u5186',
'\xe5\xf8': u'\u4e88',
'\xe5\xf9': u'\u4f59',
'\xe5\xfa': u'\uf97f',
'\xe5\xfb': u'\uf980',
'\xe5\xfc': u'\uf981',
'\xe5\xfd': u'\u5982',
'\xe5\xfe': u'\uf982',
'\xe6\xa1': u'\uf983',
'\xe6\xa2': u'\u6b5f',
'\xe6\xa3': u'\u6c5d',
'\xe6\xa4': u'\uf984',
'\xe6\xa5': u'\u74b5',
'\xe6\xa6': u'\u7916',
'\xe6\xa7': u'\uf985',
'\xe6\xa8': u'\u8207',
'\xe6\xa9': u'\u8245',
'\xe6\xaa': u'\u8339',
'\xe6\xab': u'\u8f3f',
'\xe6\xac': u'\u8f5d',
'\xe6\xad': u'\uf986',
'\xe6\xae': u'\u9918',
'\xe6\xaf': u'\uf987',
'\xe6\xb0': u'\uf988',
'\xe6\xb1': u'\uf989',
'\xe6\xb2': u'\u4ea6',
'\xe6\xb3': u'\uf98a',
'\xe6\xb4': u'\u57df',
'\xe6\xb5': u'\u5f79',
'\xe6\xb6': u'\u6613',
'\xe6\xb7': u'\uf98b',
'\xe6\xb8': u'\uf98c',
'\xe6\xb9': u'\u75ab',
'\xe6\xba': u'\u7e79',
'\xe6\xbb': u'\u8b6f',
'\xe6\xbc': u'\uf98d',
'\xe6\xbd': u'\u9006',
'\xe6\xbe': u'\u9a5b',
'\xe6\xbf': u'\u56a5',
'\xe6\xc0': u'\u5827',
'\xe6\xc1': u'\u59f8',
'\xe6\xc2': u'\u5a1f',
'\xe6\xc3': u'\u5bb4',
'\xe6\xc4': u'\uf98e',
'\xe6\xc5': u'\u5ef6',
'\xe6\xc6': u'\uf98f',
'\xe6\xc7': u'\uf990',
'\xe6\xc8': u'\u6350',
'\xe6\xc9': u'\u633b',
'\xe6\xca': u'\uf991',
'\xe6\xcb': u'\u693d',
'\xe6\xcc': u'\u6c87',
'\xe6\xcd': u'\u6cbf',
'\xe6\xce': u'\u6d8e',
'\xe6\xcf': u'\u6d93',
'\xe6\xd0': u'\u6df5',
'\xe6\xd1': u'\u6f14',
'\xe6\xd2': u'\uf992',
'\xe6\xd3': u'\u70df',
'\xe6\xd4': u'\u7136',
'\xe6\xd5': u'\u7159',
'\xe6\xd6': u'\uf993',
'\xe6\xd7': u'\u71c3',
'\xe6\xd8': u'\u71d5',
'\xe6\xd9': u'\uf994',
'\xe6\xda': u'\u784f',
'\xe6\xdb': u'\u786f',
'\xe6\xdc': u'\uf995',
'\xe6\xdd': u'\u7b75',
'\xe6\xde': u'\u7de3',
'\xe6\xdf': u'\uf996',
'\xe6\xe0': u'\u7e2f',
'\xe6\xe1': u'\uf997',
'\xe6\xe2': u'\u884d',
'\xe6\xe3': u'\u8edf',
'\xe6\xe4': u'\uf998',
'\xe6\xe5': u'\uf999',
'\xe6\xe6': u'\uf99a',
'\xe6\xe7': u'\u925b',
'\xe6\xe8': u'\uf99b',
'\xe6\xe9': u'\u9cf6',
'\xe6\xea': u'\uf99c',
'\xe6\xeb': u'\uf99d',
'\xe6\xec': u'\uf99e',
'\xe6\xed': u'\u6085',
'\xe6\xee': u'\u6d85',
'\xe6\xef': u'\uf99f',
'\xe6\xf0': u'\u71b1',
'\xe6\xf1': u'\uf9a0',
'\xe6\xf2': u'\uf9a1',
'\xe6\xf3': u'\u95b1',
'\xe6\xf4': u'\u53ad',
'\xe6\xf5': u'\uf9a2',
'\xe6\xf6': u'\uf9a3',
'\xe6\xf7': u'\uf9a4',
'\xe6\xf8': u'\u67d3',
'\xe6\xf9': u'\uf9a5',
'\xe6\xfa': u'\u708e',
'\xe6\xfb': u'\u7130',
'\xe6\xfc': u'\u7430',
'\xe6\xfd': u'\u8276',
'\xe6\xfe': u'\u82d2',
'\xe7\xa1': u'\uf9a6',
'\xe7\xa2': u'\u95bb',
'\xe7\xa3': u'\u9ae5',
'\xe7\xa4': u'\u9e7d',
'\xe7\xa5': u'\u66c4',
'\xe7\xa6': u'\uf9a7',
'\xe7\xa7': u'\u71c1',
'\xe7\xa8': u'\u8449',
'\xe7\xa9': u'\uf9a8',
'\xe7\xaa': u'\uf9a9',
'\xe7\xab': u'\u584b',
'\xe7\xac': u'\uf9aa',
'\xe7\xad': u'\uf9ab',
'\xe7\xae': u'\u5db8',
'\xe7\xaf': u'\u5f71',
'\xe7\xb0': u'\uf9ac',
'\xe7\xb1': u'\u6620',
'\xe7\xb2': u'\u668e',
'\xe7\xb3': u'\u6979',
'\xe7\xb4': u'\u69ae',
'\xe7\xb5': u'\u6c38',
'\xe7\xb6': u'\u6cf3',
'\xe7\xb7': u'\u6e36',
'\xe7\xb8': u'\u6f41',
'\xe7\xb9': u'\u6fda',
'\xe7\xba': u'\u701b',
'\xe7\xbb': u'\u702f',
'\xe7\xbc': u'\u7150',
'\xe7\xbd': u'\u71df',
'\xe7\xbe': u'\u7370',
'\xe7\xbf': u'\uf9ad',
'\xe7\xc0': u'\u745b',
'\xe7\xc1': u'\uf9ae',
'\xe7\xc2': u'\u74d4',
'\xe7\xc3': u'\u76c8',
'\xe7\xc4': u'\u7a4e',
'\xe7\xc5': u'\u7e93',
'\xe7\xc6': u'\uf9af',
'\xe7\xc7': u'\uf9b0',
'\xe7\xc8': u'\u82f1',
'\xe7\xc9': u'\u8a60',
'\xe7\xca': u'\u8fce',
'\xe7\xcb': u'\uf9b1',
'\xe7\xcc': u'\u9348',
'\xe7\xcd': u'\uf9b2',
'\xe7\xce': u'\u9719',
'\xe7\xcf': u'\uf9b3',
'\xe7\xd0': u'\uf9b4',
'\xe7\xd1': u'\u4e42',
'\xe7\xd2': u'\u502a',
'\xe7\xd3': u'\uf9b5',
'\xe7\xd4': u'\u5208',
'\xe7\xd5': u'\u53e1',
'\xe7\xd6': u'\u66f3',
'\xe7\xd7': u'\u6c6d',
'\xe7\xd8': u'\u6fca',
'\xe7\xd9': u'\u730a',
'\xe7\xda': u'\u777f',
'\xe7\xdb': u'\u7a62',
'\xe7\xdc': u'\u82ae',
'\xe7\xdd': u'\u85dd',
'\xe7\xde': u'\u8602',
'\xe7\xdf': u'\uf9b6',
'\xe7\xe0': u'\u88d4',
'\xe7\xe1': u'\u8a63',
'\xe7\xe2': u'\u8b7d',
'\xe7\xe3': u'\u8c6b',
'\xe7\xe4': u'\uf9b7',
'\xe7\xe5': u'\u92b3',
'\xe7\xe6': u'\uf9b8',
'\xe7\xe7': u'\u9713',
'\xe7\xe8': u'\u9810',
'\xe7\xe9': u'\u4e94',
'\xe7\xea': u'\u4f0d',
'\xe7\xeb': u'\u4fc9',
'\xe7\xec': u'\u50b2',
'\xe7\xed': u'\u5348',
'\xe7\xee': u'\u543e',
'\xe7\xef': u'\u5433',
'\xe7\xf0': u'\u55da',
'\xe7\xf1': u'\u5862',
'\xe7\xf2': u'\u58ba',
'\xe7\xf3': u'\u5967',
'\xe7\xf4': u'\u5a1b',
'\xe7\xf5': u'\u5be4',
'\xe7\xf6': u'\u609f',
'\xe7\xf7': u'\uf9b9',
'\xe7\xf8': u'\u61ca',
'\xe7\xf9': u'\u6556',
'\xe7\xfa': u'\u65ff',
'\xe7\xfb': u'\u6664',
'\xe7\xfc': u'\u68a7',
'\xe7\xfd': u'\u6c5a',
'\xe7\xfe': u'\u6fb3',
'\xe8\xa1': u'\u70cf',
'\xe8\xa2': u'\u71ac',
'\xe8\xa3': u'\u7352',
'\xe8\xa4': u'\u7b7d',
'\xe8\xa5': u'\u8708',
'\xe8\xa6': u'\u8aa4',
'\xe8\xa7': u'\u9c32',
'\xe8\xa8': u'\u9f07',
'\xe8\xa9': u'\u5c4b',
'\xe8\xaa': u'\u6c83',
'\xe8\xab': u'\u7344',
'\xe8\xac': u'\u7389',
'\xe8\xad': u'\u923a',
'\xe8\xae': u'\u6eab',
'\xe8\xaf': u'\u7465',
'\xe8\xb0': u'\u761f',
'\xe8\xb1': u'\u7a69',
'\xe8\xb2': u'\u7e15',
'\xe8\xb3': u'\u860a',
'\xe8\xb4': u'\u5140',
'\xe8\xb5': u'\u58c5',
'\xe8\xb6': u'\u64c1',
'\xe8\xb7': u'\u74ee',
'\xe8\xb8': u'\u7515',
'\xe8\xb9': u'\u7670',
'\xe8\xba': u'\u7fc1',
'\xe8\xbb': u'\u9095',
'\xe8\xbc': u'\u96cd',
'\xe8\xbd': u'\u9954',
'\xe8\xbe': u'\u6e26',
'\xe8\xbf': u'\u74e6',
'\xe8\xc0': u'\u7aa9',
'\xe8\xc1': u'\u7aaa',
'\xe8\xc2': u'\u81e5',
'\xe8\xc3': u'\u86d9',
'\xe8\xc4': u'\u8778',
'\xe8\xc5': u'\u8a1b',
'\xe8\xc6': u'\u5a49',
'\xe8\xc7': u'\u5b8c',
'\xe8\xc8': u'\u5b9b',
'\xe8\xc9': u'\u68a1',
'\xe8\xca': u'\u6900',
'\xe8\xcb': u'\u6d63',
'\xe8\xcc': u'\u73a9',
'\xe8\xcd': u'\u7413',
'\xe8\xce': u'\u742c',
'\xe8\xcf': u'\u7897',
'\xe8\xd0': u'\u7de9',
'\xe8\xd1': u'\u7feb',
'\xe8\xd2': u'\u8118',
'\xe8\xd3': u'\u8155',
'\xe8\xd4': u'\u839e',
'\xe8\xd5': u'\u8c4c',
'\xe8\xd6': u'\u962e',
'\xe8\xd7': u'\u9811',
'\xe8\xd8': u'\u66f0',
'\xe8\xd9': u'\u5f80',
'\xe8\xda': u'\u65fa',
'\xe8\xdb': u'\u6789',
'\xe8\xdc': u'\u6c6a',
'\xe8\xdd': u'\u738b',
'\xe8\xde': u'\u502d',
'\xe8\xdf': u'\u5a03',
'\xe8\xe0': u'\u6b6a',
'\xe8\xe1': u'\u77ee',
'\xe8\xe2': u'\u5916',
'\xe8\xe3': u'\u5d6c',
'\xe8\xe4': u'\u5dcd',
'\xe8\xe5': u'\u7325',
'\xe8\xe6': u'\u754f',
'\xe8\xe7': u'\uf9ba',
'\xe8\xe8': u'\uf9bb',
'\xe8\xe9': u'\u50e5',
'\xe8\xea': u'\u51f9',
'\xe8\xeb': u'\u582f',
'\xe8\xec': u'\u592d',
'\xe8\xed': u'\u5996',
'\xe8\xee': u'\u59da',
'\xe8\xef': u'\u5be5',
'\xe8\xf0': u'\uf9bc',
'\xe8\xf1': u'\uf9bd',
'\xe8\xf2': u'\u5da2',
'\xe8\xf3': u'\u62d7',
'\xe8\xf4': u'\u6416',
'\xe8\xf5': u'\u6493',
'\xe8\xf6': u'\u64fe',
'\xe8\xf7': u'\uf9be',
'\xe8\xf8': u'\u66dc',
'\xe8\xf9': u'\uf9bf',
'\xe8\xfa': u'\u6a48',
'\xe8\xfb': u'\uf9c0',
'\xe8\xfc': u'\u71ff',
'\xe8\xfd': u'\u7464',
'\xe8\xfe': u'\uf9c1',
'\xe9\xa1': u'\u7a88',
'\xe9\xa2': u'\u7aaf',
'\xe9\xa3': u'\u7e47',
'\xe9\xa4': u'\u7e5e',
'\xe9\xa5': u'\u8000',
'\xe9\xa6': u'\u8170',
'\xe9\xa7': u'\uf9c2',
'\xe9\xa8': u'\u87ef',
'\xe9\xa9': u'\u8981',
'\xe9\xaa': u'\u8b20',
'\xe9\xab': u'\u9059',
'\xe9\xac': u'\uf9c3',
'\xe9\xad': u'\u9080',
'\xe9\xae': u'\u9952',
'\xe9\xaf': u'\u617e',
'\xe9\xb0': u'\u6b32',
'\xe9\xb1': u'\u6d74',
'\xe9\xb2': u'\u7e1f',
'\xe9\xb3': u'\u8925',
'\xe9\xb4': u'\u8fb1',
'\xe9\xb5': u'\u4fd1',
'\xe9\xb6': u'\u50ad',
'\xe9\xb7': u'\u5197',
'\xe9\xb8': u'\u52c7',
'\xe9\xb9': u'\u57c7',
'\xe9\xba': u'\u5889',
'\xe9\xbb': u'\u5bb9',
'\xe9\xbc': u'\u5eb8',
'\xe9\xbd': u'\u6142',
'\xe9\xbe': u'\u6995',
'\xe9\xbf': u'\u6d8c',
'\xe9\xc0': u'\u6e67',
'\xe9\xc1': u'\u6eb6',
'\xe9\xc2': u'\u7194',
'\xe9\xc3': u'\u7462',
'\xe9\xc4': u'\u7528',
'\xe9\xc5': u'\u752c',
'\xe9\xc6': u'\u8073',
'\xe9\xc7': u'\u8338',
'\xe9\xc8': u'\u84c9',
'\xe9\xc9': u'\u8e0a',
'\xe9\xca': u'\u9394',
'\xe9\xcb': u'\u93de',
'\xe9\xcc': u'\uf9c4',
'\xe9\xcd': u'\u4e8e',
'\xe9\xce': u'\u4f51',
'\xe9\xcf': u'\u5076',
'\xe9\xd0': u'\u512a',
'\xe9\xd1': u'\u53c8',
'\xe9\xd2': u'\u53cb',
'\xe9\xd3': u'\u53f3',
'\xe9\xd4': u'\u5b87',
'\xe9\xd5': u'\u5bd3',
'\xe9\xd6': u'\u5c24',
'\xe9\xd7': u'\u611a',
'\xe9\xd8': u'\u6182',
'\xe9\xd9': u'\u65f4',
'\xe9\xda': u'\u725b',
'\xe9\xdb': u'\u7397',
'\xe9\xdc': u'\u7440',
'\xe9\xdd': u'\u76c2',
'\xe9\xde': u'\u7950',
'\xe9\xdf': u'\u7991',
'\xe9\xe0': u'\u79b9',
'\xe9\xe1': u'\u7d06',
'\xe9\xe2': u'\u7fbd',
'\xe9\xe3': u'\u828b',
'\xe9\xe4': u'\u85d5',
'\xe9\xe5': u'\u865e',
'\xe9\xe6': u'\u8fc2',
'\xe9\xe7': u'\u9047',
'\xe9\xe8': u'\u90f5',
'\xe9\xe9': u'\u91ea',
'\xe9\xea': u'\u9685',
'\xe9\xeb': u'\u96e8',
'\xe9\xec': u'\u96e9',
'\xe9\xed': u'\u52d6',
'\xe9\xee': u'\u5f67',
'\xe9\xef': u'\u65ed',
'\xe9\xf0': u'\u6631',
'\xe9\xf1': u'\u682f',
'\xe9\xf2': u'\u715c',
'\xe9\xf3': u'\u7a36',
'\xe9\xf4': u'\u90c1',
'\xe9\xf5': u'\u980a',
'\xe9\xf6': u'\u4e91',
'\xe9\xf7': u'\uf9c5',
'\xe9\xf8': u'\u6a52',
'\xe9\xf9': u'\u6b9e',
'\xe9\xfa': u'\u6f90',
'\xe9\xfb': u'\u7189',
'\xe9\xfc': u'\u8018',
'\xe9\xfd': u'\u82b8',
'\xe9\xfe': u'\u8553',
'\xea\xa1': u'\u904b',
'\xea\xa2': u'\u9695',
'\xea\xa3': u'\u96f2',
'\xea\xa4': u'\u97fb',
'\xea\xa5': u'\u851a',
'\xea\xa6': u'\u9b31',
'\xea\xa7': u'\u4e90',
'\xea\xa8': u'\u718a',
'\xea\xa9': u'\u96c4',
'\xea\xaa': u'\u5143',
'\xea\xab': u'\u539f',
'\xea\xac': u'\u54e1',
'\xea\xad': u'\u5713',
'\xea\xae': u'\u5712',
'\xea\xaf': u'\u57a3',
'\xea\xb0': u'\u5a9b',
'\xea\xb1': u'\u5ac4',
'\xea\xb2': u'\u5bc3',
'\xea\xb3': u'\u6028',
'\xea\xb4': u'\u613f',
'\xea\xb5': u'\u63f4',
'\xea\xb6': u'\u6c85',
'\xea\xb7': u'\u6d39',
'\xea\xb8': u'\u6e72',
'\xea\xb9': u'\u6e90',
'\xea\xba': u'\u7230',
'\xea\xbb': u'\u733f',
'\xea\xbc': u'\u7457',
'\xea\xbd': u'\u82d1',
'\xea\xbe': u'\u8881',
'\xea\xbf': u'\u8f45',
'\xea\xc0': u'\u9060',
'\xea\xc1': u'\uf9c6',
'\xea\xc2': u'\u9662',
'\xea\xc3': u'\u9858',
'\xea\xc4': u'\u9d1b',
'\xea\xc5': u'\u6708',
'\xea\xc6': u'\u8d8a',
'\xea\xc7': u'\u925e',
'\xea\xc8': u'\u4f4d',
'\xea\xc9': u'\u5049',
'\xea\xca': u'\u50de',
'\xea\xcb': u'\u5371',
'\xea\xcc': u'\u570d',
'\xea\xcd': u'\u59d4',
'\xea\xce': u'\u5a01',
'\xea\xcf': u'\u5c09',
'\xea\xd0': u'\u6170',
'\xea\xd1': u'\u6690',
'\xea\xd2': u'\u6e2d',
'\xea\xd3': u'\u7232',
'\xea\xd4': u'\u744b',
'\xea\xd5': u'\u7def',
'\xea\xd6': u'\u80c3',
'\xea\xd7': u'\u840e',
'\xea\xd8': u'\u8466',
'\xea\xd9': u'\u853f',
'\xea\xda': u'\u875f',
'\xea\xdb': u'\u885b',
'\xea\xdc': u'\u8918',
'\xea\xdd': u'\u8b02',
'\xea\xde': u'\u9055',
'\xea\xdf': u'\u97cb',
'\xea\xe0': u'\u9b4f',
'\xea\xe1': u'\u4e73',
'\xea\xe2': u'\u4f91',
'\xea\xe3': u'\u5112',
'\xea\xe4': u'\u516a',
'\xea\xe5': u'\uf9c7',
'\xea\xe6': u'\u552f',
'\xea\xe7': u'\u55a9',
'\xea\xe8': u'\u5b7a',
'\xea\xe9': u'\u5ba5',
'\xea\xea': u'\u5e7c',
'\xea\xeb': u'\u5e7d',
'\xea\xec': u'\u5ebe',
'\xea\xed': u'\u60a0',
'\xea\xee': u'\u60df',
'\xea\xef': u'\u6108',
'\xea\xf0': u'\u6109',
'\xea\xf1': u'\u63c4',
'\xea\xf2': u'\u6538',
'\xea\xf3': u'\u6709',
'\xea\xf4': u'\uf9c8',
'\xea\xf5': u'\u67d4',
'\xea\xf6': u'\u67da',
'\xea\xf7': u'\uf9c9',
'\xea\xf8': u'\u6961',
'\xea\xf9': u'\u6962',
'\xea\xfa': u'\u6cb9',
'\xea\xfb': u'\u6d27',
'\xea\xfc': u'\uf9ca',
'\xea\xfd': u'\u6e38',
'\xea\xfe': u'\uf9cb',
'\xeb\xa1': u'\u6fe1',
'\xeb\xa2': u'\u7336',
'\xeb\xa3': u'\u7337',
'\xeb\xa4': u'\uf9cc',
'\xeb\xa5': u'\u745c',
'\xeb\xa6': u'\u7531',
'\xeb\xa7': u'\uf9cd',
'\xeb\xa8': u'\u7652',
'\xeb\xa9': u'\uf9ce',
'\xeb\xaa': u'\uf9cf',
'\xeb\xab': u'\u7dad',
'\xeb\xac': u'\u81fe',
'\xeb\xad': u'\u8438',
'\xeb\xae': u'\u88d5',
'\xeb\xaf': u'\u8a98',
'\xeb\xb0': u'\u8adb',
'\xeb\xb1': u'\u8aed',
'\xeb\xb2': u'\u8e30',
'\xeb\xb3': u'\u8e42',
'\xeb\xb4': u'\u904a',
'\xeb\xb5': u'\u903e',
'\xeb\xb6': u'\u907a',
'\xeb\xb7': u'\u9149',
'\xeb\xb8': u'\u91c9',
'\xeb\xb9': u'\u936e',
'\xeb\xba': u'\uf9d0',
'\xeb\xbb': u'\uf9d1',
'\xeb\xbc': u'\u5809',
'\xeb\xbd': u'\uf9d2',
'\xeb\xbe': u'\u6bd3',
'\xeb\xbf': u'\u8089',
'\xeb\xc0': u'\u80b2',
'\xeb\xc1': u'\uf9d3',
'\xeb\xc2': u'\uf9d4',
'\xeb\xc3': u'\u5141',
'\xeb\xc4': u'\u596b',
'\xeb\xc5': u'\u5c39',
'\xeb\xc6': u'\uf9d5',
'\xeb\xc7': u'\uf9d6',
'\xeb\xc8': u'\u6f64',
'\xeb\xc9': u'\u73a7',
'\xeb\xca': u'\u80e4',
'\xeb\xcb': u'\u8d07',
'\xeb\xcc': u'\uf9d7',
'\xeb\xcd': u'\u9217',
'\xeb\xce': u'\u958f',
'\xeb\xcf': u'\uf9d8',
'\xeb\xd0': u'\uf9d9',
'\xeb\xd1': u'\uf9da',
'\xeb\xd2': u'\uf9db',
'\xeb\xd3': u'\u807f',
'\xeb\xd4': u'\u620e',
'\xeb\xd5': u'\u701c',
'\xeb\xd6': u'\u7d68',
'\xeb\xd7': u'\u878d',
'\xeb\xd8': u'\uf9dc',
'\xeb\xd9': u'\u57a0',
'\xeb\xda': u'\u6069',
'\xeb\xdb': u'\u6147',
'\xeb\xdc': u'\u6bb7',
'\xeb\xdd': u'\u8abe',
'\xeb\xde': u'\u9280',
'\xeb\xdf': u'\u96b1',
'\xeb\xe0': u'\u4e59',
'\xeb\xe1': u'\u541f',
'\xeb\xe2': u'\u6deb',
'\xeb\xe3': u'\u852d',
'\xeb\xe4': u'\u9670',
'\xeb\xe5': u'\u97f3',
'\xeb\xe6': u'\u98ee',
'\xeb\xe7': u'\u63d6',
'\xeb\xe8': u'\u6ce3',
'\xeb\xe9': u'\u9091',
'\xeb\xea': u'\u51dd',
'\xeb\xeb': u'\u61c9',
'\xeb\xec': u'\u81ba',
'\xeb\xed': u'\u9df9',
'\xeb\xee': u'\u4f9d',
'\xeb\xef': u'\u501a',
'\xeb\xf0': u'\u5100',
'\xeb\xf1': u'\u5b9c',
'\xeb\xf2': u'\u610f',
'\xeb\xf3': u'\u61ff',
'\xeb\xf4': u'\u64ec',
'\xeb\xf5': u'\u6905',
'\xeb\xf6': u'\u6bc5',
'\xeb\xf7': u'\u7591',
'\xeb\xf8': u'\u77e3',
'\xeb\xf9': u'\u7fa9',
'\xeb\xfa': u'\u8264',
'\xeb\xfb': u'\u858f',
'\xeb\xfc': u'\u87fb',
'\xeb\xfd': u'\u8863',
'\xeb\xfe': u'\u8abc',
'\xec\xa1': u'\u8b70',
'\xec\xa2': u'\u91ab',
'\xec\xa3': u'\u4e8c',
'\xec\xa4': u'\u4ee5',
'\xec\xa5': u'\u4f0a',
'\xec\xa6': u'\uf9dd',
'\xec\xa7': u'\uf9de',
'\xec\xa8': u'\u5937',
'\xec\xa9': u'\u59e8',
'\xec\xaa': u'\uf9df',
'\xec\xab': u'\u5df2',
'\xec\xac': u'\u5f1b',
'\xec\xad': u'\u5f5b',
'\xec\xae': u'\u6021',
'\xec\xaf': u'\uf9e0',
'\xec\xb0': u'\uf9e1',
'\xec\xb1': u'\uf9e2',
'\xec\xb2': u'\uf9e3',
'\xec\xb3': u'\u723e',
'\xec\xb4': u'\u73e5',
'\xec\xb5': u'\uf9e4',
'\xec\xb6': u'\u7570',
'\xec\xb7': u'\u75cd',
'\xec\xb8': u'\uf9e5',
'\xec\xb9': u'\u79fb',
'\xec\xba': u'\uf9e6',
'\xec\xbb': u'\u800c',
'\xec\xbc': u'\u8033',
'\xec\xbd': u'\u8084',
'\xec\xbe': u'\u82e1',
'\xec\xbf': u'\u8351',
'\xec\xc0': u'\uf9e7',
'\xec\xc1': u'\uf9e8',
'\xec\xc2': u'\u8cbd',
'\xec\xc3': u'\u8cb3',
'\xec\xc4': u'\u9087',
'\xec\xc5': u'\uf9e9',
'\xec\xc6': u'\uf9ea',
'\xec\xc7': u'\u98f4',
'\xec\xc8': u'\u990c',
'\xec\xc9': u'\uf9eb',
'\xec\xca': u'\uf9ec',
'\xec\xcb': u'\u7037',
'\xec\xcc': u'\u76ca',
'\xec\xcd': u'\u7fca',
'\xec\xce': u'\u7fcc',
'\xec\xcf': u'\u7ffc',
'\xec\xd0': u'\u8b1a',
'\xec\xd1': u'\u4eba',
'\xec\xd2': u'\u4ec1',
'\xec\xd3': u'\u5203',
'\xec\xd4': u'\u5370',
'\xec\xd5': u'\uf9ed',
'\xec\xd6': u'\u54bd',
'\xec\xd7': u'\u56e0',
'\xec\xd8': u'\u59fb',
'\xec\xd9': u'\u5bc5',
'\xec\xda': u'\u5f15',
'\xec\xdb': u'\u5fcd',
'\xec\xdc': u'\u6e6e',
'\xec\xdd': u'\uf9ee',
'\xec\xde': u'\uf9ef',
'\xec\xdf': u'\u7d6a',
'\xec\xe0': u'\u8335',
'\xec\xe1': u'\uf9f0',
'\xec\xe2': u'\u8693',
'\xec\xe3': u'\u8a8d',
'\xec\xe4': u'\uf9f1',
'\xec\xe5': u'\u976d',
'\xec\xe6': u'\u9777',
'\xec\xe7': u'\uf9f2',
'\xec\xe8': u'\uf9f3',
'\xec\xe9': u'\u4e00',
'\xec\xea': u'\u4f5a',
'\xec\xeb': u'\u4f7e',
'\xec\xec': u'\u58f9',
'\xec\xed': u'\u65e5',
'\xec\xee': u'\u6ea2',
'\xec\xef': u'\u9038',
'\xec\xf0': u'\u93b0',
'\xec\xf1': u'\u99b9',
'\xec\xf2': u'\u4efb',
'\xec\xf3': u'\u58ec',
'\xec\xf4': u'\u598a',
'\xec\xf5': u'\u59d9',
'\xec\xf6': u'\u6041',
'\xec\xf7': u'\uf9f4',
'\xec\xf8': u'\uf9f5',
'\xec\xf9': u'\u7a14',
'\xec\xfa': u'\uf9f6',
'\xec\xfb': u'\u834f',
'\xec\xfc': u'\u8cc3',
'\xec\xfd': u'\u5165',
'\xec\xfe': u'\u5344',
'\xed\xa1': u'\uf9f7',
'\xed\xa2': u'\uf9f8',
'\xed\xa3': u'\uf9f9',
'\xed\xa4': u'\u4ecd',
'\xed\xa5': u'\u5269',
'\xed\xa6': u'\u5b55',
'\xed\xa7': u'\u82bf',
'\xed\xa8': u'\u4ed4',
'\xed\xa9': u'\u523a',
'\xed\xaa': u'\u54a8',
'\xed\xab': u'\u59c9',
'\xed\xac': u'\u59ff',
'\xed\xad': u'\u5b50',
'\xed\xae': u'\u5b57',
'\xed\xaf': u'\u5b5c',
'\xed\xb0': u'\u6063',
'\xed\xb1': u'\u6148',
'\xed\xb2': u'\u6ecb',
'\xed\xb3': u'\u7099',
'\xed\xb4': u'\u716e',
'\xed\xb5': u'\u7386',
'\xed\xb6': u'\u74f7',
'\xed\xb7': u'\u75b5',
'\xed\xb8': u'\u78c1',
'\xed\xb9': u'\u7d2b',
'\xed\xba': u'\u8005',
'\xed\xbb': u'\u81ea',
'\xed\xbc': u'\u8328',
'\xed\xbd': u'\u8517',
'\xed\xbe': u'\u85c9',
'\xed\xbf': u'\u8aee',
'\xed\xc0': u'\u8cc7',
'\xed\xc1': u'\u96cc',
'\xed\xc2': u'\u4f5c',
'\xed\xc3': u'\u52fa',
'\xed\xc4': u'\u56bc',
'\xed\xc5': u'\u65ab',
'\xed\xc6': u'\u6628',
'\xed\xc7': u'\u707c',
'\xed\xc8': u'\u70b8',
'\xed\xc9': u'\u7235',
'\xed\xca': u'\u7dbd',
'\xed\xcb': u'\u828d',
'\xed\xcc': u'\u914c',
'\xed\xcd': u'\u96c0',
'\xed\xce': u'\u9d72',
'\xed\xcf': u'\u5b71',
'\xed\xd0': u'\u68e7',
'\xed\xd1': u'\u6b98',
'\xed\xd2': u'\u6f7a',
'\xed\xd3': u'\u76de',
'\xed\xd4': u'\u5c91',
'\xed\xd5': u'\u66ab',
'\xed\xd6': u'\u6f5b',
'\xed\xd7': u'\u7bb4',
'\xed\xd8': u'\u7c2a',
'\xed\xd9': u'\u8836',
'\xed\xda': u'\u96dc',
'\xed\xdb': u'\u4e08',
'\xed\xdc': u'\u4ed7',
'\xed\xdd': u'\u5320',
'\xed\xde': u'\u5834',
'\xed\xdf': u'\u58bb',
'\xed\xe0': u'\u58ef',
'\xed\xe1': u'\u596c',
'\xed\xe2': u'\u5c07',
'\xed\xe3': u'\u5e33',
'\xed\xe4': u'\u5e84',
'\xed\xe5': u'\u5f35',
'\xed\xe6': u'\u638c',
'\xed\xe7': u'\u66b2',
'\xed\xe8': u'\u6756',
'\xed\xe9': u'\u6a1f',
'\xed\xea': u'\u6aa3',
'\xed\xeb': u'\u6b0c',
'\xed\xec': u'\u6f3f',
'\xed\xed': u'\u7246',
'\xed\xee': u'\uf9fa',
'\xed\xef': u'\u7350',
'\xed\xf0': u'\u748b',
'\xed\xf1': u'\u7ae0',
'\xed\xf2': u'\u7ca7',
'\xed\xf3': u'\u8178',
'\xed\xf4': u'\u81df',
'\xed\xf5': u'\u81e7',
'\xed\xf6': u'\u838a',
'\xed\xf7': u'\u846c',
'\xed\xf8': u'\u8523',
'\xed\xf9': u'\u8594',
'\xed\xfa': u'\u85cf',
'\xed\xfb': u'\u88dd',
'\xed\xfc': u'\u8d13',
'\xed\xfd': u'\u91ac',
'\xed\xfe': u'\u9577',
'\xee\xa1': u'\u969c',
'\xee\xa2': u'\u518d',
'\xee\xa3': u'\u54c9',
'\xee\xa4': u'\u5728',
'\xee\xa5': u'\u5bb0',
'\xee\xa6': u'\u624d',
'\xee\xa7': u'\u6750',
'\xee\xa8': u'\u683d',
'\xee\xa9': u'\u6893',
'\xee\xaa': u'\u6e3d',
'\xee\xab': u'\u6ed3',
'\xee\xac': u'\u707d',
'\xee\xad': u'\u7e21',
'\xee\xae': u'\u88c1',
'\xee\xaf': u'\u8ca1',
'\xee\xb0': u'\u8f09',
'\xee\xb1': u'\u9f4b',
'\xee\xb2': u'\u9f4e',
'\xee\xb3': u'\u722d',
'\xee\xb4': u'\u7b8f',
'\xee\xb5': u'\u8acd',
'\xee\xb6': u'\u931a',
'\xee\xb7': u'\u4f47',
'\xee\xb8': u'\u4f4e',
'\xee\xb9': u'\u5132',
'\xee\xba': u'\u5480',
'\xee\xbb': u'\u59d0',
'\xee\xbc': u'\u5e95',
'\xee\xbd': u'\u62b5',
'\xee\xbe': u'\u6775',
'\xee\xbf': u'\u696e',
'\xee\xc0': u'\u6a17',
'\xee\xc1': u'\u6cae',
'\xee\xc2': u'\u6e1a',
'\xee\xc3': u'\u72d9',
'\xee\xc4': u'\u732a',
'\xee\xc5': u'\u75bd',
'\xee\xc6': u'\u7bb8',
'\xee\xc7': u'\u7d35',
'\xee\xc8': u'\u82e7',
'\xee\xc9': u'\u83f9',
'\xee\xca': u'\u8457',
'\xee\xcb': u'\u85f7',
'\xee\xcc': u'\u8a5b',
'\xee\xcd': u'\u8caf',
'\xee\xce': u'\u8e87',
'\xee\xcf': u'\u9019',
'\xee\xd0': u'\u90b8',
'\xee\xd1': u'\u96ce',
'\xee\xd2': u'\u9f5f',
'\xee\xd3': u'\u52e3',
'\xee\xd4': u'\u540a',
'\xee\xd5': u'\u5ae1',
'\xee\xd6': u'\u5bc2',
'\xee\xd7': u'\u6458',
'\xee\xd8': u'\u6575',
'\xee\xd9': u'\u6ef4',
'\xee\xda': u'\u72c4',
'\xee\xdb': u'\uf9fb',
'\xee\xdc': u'\u7684',
'\xee\xdd': u'\u7a4d',
'\xee\xde': u'\u7b1b',
'\xee\xdf': u'\u7c4d',
'\xee\xe0': u'\u7e3e',
'\xee\xe1': u'\u7fdf',
'\xee\xe2': u'\u837b',
'\xee\xe3': u'\u8b2b',
'\xee\xe4': u'\u8cca',
'\xee\xe5': u'\u8d64',
'\xee\xe6': u'\u8de1',
'\xee\xe7': u'\u8e5f',
'\xee\xe8': u'\u8fea',
'\xee\xe9': u'\u8ff9',
'\xee\xea': u'\u9069',
'\xee\xeb': u'\u93d1',
'\xee\xec': u'\u4f43',
'\xee\xed': u'\u4f7a',
'\xee\xee': u'\u50b3',
'\xee\xef': u'\u5168',
'\xee\xf0': u'\u5178',
'\xee\xf1': u'\u524d',
'\xee\xf2': u'\u526a',
'\xee\xf3': u'\u5861',
'\xee\xf4': u'\u587c',
'\xee\xf5': u'\u5960',
'\xee\xf6': u'\u5c08',
'\xee\xf7': u'\u5c55',
'\xee\xf8': u'\u5edb',
'\xee\xf9': u'\u609b',
'\xee\xfa': u'\u6230',
'\xee\xfb': u'\u6813',
'\xee\xfc': u'\u6bbf',
'\xee\xfd': u'\u6c08',
'\xee\xfe': u'\u6fb1',
'\xef\xa1': u'\u714e',
'\xef\xa2': u'\u7420',
'\xef\xa3': u'\u7530',
'\xef\xa4': u'\u7538',
'\xef\xa5': u'\u7551',
'\xef\xa6': u'\u7672',
'\xef\xa7': u'\u7b4c',
'\xef\xa8': u'\u7b8b',
'\xef\xa9': u'\u7bad',
'\xef\xaa': u'\u7bc6',
'\xef\xab': u'\u7e8f',
'\xef\xac': u'\u8a6e',
'\xef\xad': u'\u8f3e',
'\xef\xae': u'\u8f49',
'\xef\xaf': u'\u923f',
'\xef\xb0': u'\u9293',
'\xef\xb1': u'\u9322',
'\xef\xb2': u'\u942b',
'\xef\xb3': u'\u96fb',
'\xef\xb4': u'\u985a',
'\xef\xb5': u'\u986b',
'\xef\xb6': u'\u991e',
'\xef\xb7': u'\u5207',
'\xef\xb8': u'\u622a',
'\xef\xb9': u'\u6298',
'\xef\xba': u'\u6d59',
'\xef\xbb': u'\u7664',
'\xef\xbc': u'\u7aca',
'\xef\xbd': u'\u7bc0',
'\xef\xbe': u'\u7d76',
'\xef\xbf': u'\u5360',
'\xef\xc0': u'\u5cbe',
'\xef\xc1': u'\u5e97',
'\xef\xc2': u'\u6f38',
'\xef\xc3': u'\u70b9',
'\xef\xc4': u'\u7c98',
'\xef\xc5': u'\u9711',
'\xef\xc6': u'\u9b8e',
'\xef\xc7': u'\u9ede',
'\xef\xc8': u'\u63a5',
'\xef\xc9': u'\u647a',
'\xef\xca': u'\u8776',
'\xef\xcb': u'\u4e01',
'\xef\xcc': u'\u4e95',
'\xef\xcd': u'\u4ead',
'\xef\xce': u'\u505c',
'\xef\xcf': u'\u5075',
'\xef\xd0': u'\u5448',
'\xef\xd1': u'\u59c3',
'\xef\xd2': u'\u5b9a',
'\xef\xd3': u'\u5e40',
'\xef\xd4': u'\u5ead',
'\xef\xd5': u'\u5ef7',
'\xef\xd6': u'\u5f81',
'\xef\xd7': u'\u60c5',
'\xef\xd8': u'\u633a',
'\xef\xd9': u'\u653f',
'\xef\xda': u'\u6574',
'\xef\xdb': u'\u65cc',
'\xef\xdc': u'\u6676',
'\xef\xdd': u'\u6678',
'\xef\xde': u'\u67fe',
'\xef\xdf': u'\u6968',
'\xef\xe0': u'\u6a89',
'\xef\xe1': u'\u6b63',
'\xef\xe2': u'\u6c40',
'\xef\xe3': u'\u6dc0',
'\xef\xe4': u'\u6de8',
'\xef\xe5': u'\u6e1f',
'\xef\xe6': u'\u6e5e',
'\xef\xe7': u'\u701e',
'\xef\xe8': u'\u70a1',
'\xef\xe9': u'\u738e',
'\xef\xea': u'\u73fd',
'\xef\xeb': u'\u753a',
'\xef\xec': u'\u775b',
'\xef\xed': u'\u7887',
'\xef\xee': u'\u798e',
'\xef\xef': u'\u7a0b',
'\xef\xf0': u'\u7a7d',
'\xef\xf1': u'\u7cbe',
'\xef\xf2': u'\u7d8e',
'\xef\xf3': u'\u8247',
'\xef\xf4': u'\u8a02',
'\xef\xf5': u'\u8aea',
'\xef\xf6': u'\u8c9e',
'\xef\xf7': u'\u912d',
'\xef\xf8': u'\u914a',
'\xef\xf9': u'\u91d8',
'\xef\xfa': u'\u9266',
'\xef\xfb': u'\u92cc',
'\xef\xfc': u'\u9320',
'\xef\xfd': u'\u9706',
'\xef\xfe': u'\u9756',
'\xf0\xa1': u'\u975c',
'\xf0\xa2': u'\u9802',
'\xf0\xa3': u'\u9f0e',
'\xf0\xa4': u'\u5236',
'\xf0\xa5': u'\u5291',
'\xf0\xa6': u'\u557c',
'\xf0\xa7': u'\u5824',
'\xf0\xa8': u'\u5e1d',
'\xf0\xa9': u'\u5f1f',
'\xf0\xaa': u'\u608c',
'\xf0\xab': u'\u63d0',
'\xf0\xac': u'\u68af',
'\xf0\xad': u'\u6fdf',
'\xf0\xae': u'\u796d',
'\xf0\xaf': u'\u7b2c',
'\xf0\xb0': u'\u81cd',
'\xf0\xb1': u'\u85ba',
'\xf0\xb2': u'\u88fd',
'\xf0\xb3': u'\u8af8',
'\xf0\xb4': u'\u8e44',
'\xf0\xb5': u'\u918d',
'\xf0\xb6': u'\u9664',
'\xf0\xb7': u'\u969b',
'\xf0\xb8': u'\u973d',
'\xf0\xb9': u'\u984c',
'\xf0\xba': u'\u9f4a',
'\xf0\xbb': u'\u4fce',
'\xf0\xbc': u'\u5146',
'\xf0\xbd': u'\u51cb',
'\xf0\xbe': u'\u52a9',
'\xf0\xbf': u'\u5632',
'\xf0\xc0': u'\u5f14',
'\xf0\xc1': u'\u5f6b',
'\xf0\xc2': u'\u63aa',
'\xf0\xc3': u'\u64cd',
'\xf0\xc4': u'\u65e9',
'\xf0\xc5': u'\u6641',
'\xf0\xc6': u'\u66fa',
'\xf0\xc7': u'\u66f9',
'\xf0\xc8': u'\u671d',
'\xf0\xc9': u'\u689d',
'\xf0\xca': u'\u68d7',
'\xf0\xcb': u'\u69fd',
'\xf0\xcc': u'\u6f15',
'\xf0\xcd': u'\u6f6e',
'\xf0\xce': u'\u7167',
'\xf0\xcf': u'\u71e5',
'\xf0\xd0': u'\u722a',
'\xf0\xd1': u'\u74aa',
'\xf0\xd2': u'\u773a',
'\xf0\xd3': u'\u7956',
'\xf0\xd4': u'\u795a',
'\xf0\xd5': u'\u79df',
'\xf0\xd6': u'\u7a20',
'\xf0\xd7': u'\u7a95',
'\xf0\xd8': u'\u7c97',
'\xf0\xd9': u'\u7cdf',
'\xf0\xda': u'\u7d44',
'\xf0\xdb': u'\u7e70',
'\xf0\xdc': u'\u8087',
'\xf0\xdd': u'\u85fb',
'\xf0\xde': u'\u86a4',
'\xf0\xdf': u'\u8a54',
'\xf0\xe0': u'\u8abf',
'\xf0\xe1': u'\u8d99',
'\xf0\xe2': u'\u8e81',
'\xf0\xe3': u'\u9020',
'\xf0\xe4': u'\u906d',
'\xf0\xe5': u'\u91e3',
'\xf0\xe6': u'\u963b',
'\xf0\xe7': u'\u96d5',
'\xf0\xe8': u'\u9ce5',
'\xf0\xe9': u'\u65cf',
'\xf0\xea': u'\u7c07',
'\xf0\xeb': u'\u8db3',
'\xf0\xec': u'\u93c3',
'\xf0\xed': u'\u5b58',
'\xf0\xee': u'\u5c0a',
'\xf0\xef': u'\u5352',
'\xf0\xf0': u'\u62d9',
'\xf0\xf1': u'\u731d',
'\xf0\xf2': u'\u5027',
'\xf0\xf3': u'\u5b97',
'\xf0\xf4': u'\u5f9e',
'\xf0\xf5': u'\u60b0',
'\xf0\xf6': u'\u616b',
'\xf0\xf7': u'\u68d5',
'\xf0\xf8': u'\u6dd9',
'\xf0\xf9': u'\u742e',
'\xf0\xfa': u'\u7a2e',
'\xf0\xfb': u'\u7d42',
'\xf0\xfc': u'\u7d9c',
'\xf0\xfd': u'\u7e31',
'\xf0\xfe': u'\u816b',
'\xf1\xa1': u'\u8e2a',
'\xf1\xa2': u'\u8e35',
'\xf1\xa3': u'\u937e',
'\xf1\xa4': u'\u9418',
'\xf1\xa5': u'\u4f50',
'\xf1\xa6': u'\u5750',
'\xf1\xa7': u'\u5de6',
'\xf1\xa8': u'\u5ea7',
'\xf1\xa9': u'\u632b',
'\xf1\xaa': u'\u7f6a',
'\xf1\xab': u'\u4e3b',
'\xf1\xac': u'\u4f4f',
'\xf1\xad': u'\u4f8f',
'\xf1\xae': u'\u505a',
'\xf1\xaf': u'\u59dd',
'\xf1\xb0': u'\u80c4',
'\xf1\xb1': u'\u546a',
'\xf1\xb2': u'\u5468',
'\xf1\xb3': u'\u55fe',
'\xf1\xb4': u'\u594f',
'\xf1\xb5': u'\u5b99',
'\xf1\xb6': u'\u5dde',
'\xf1\xb7': u'\u5eda',
'\xf1\xb8': u'\u665d',
'\xf1\xb9': u'\u6731',
'\xf1\xba': u'\u67f1',
'\xf1\xbb': u'\u682a',
'\xf1\xbc': u'\u6ce8',
'\xf1\xbd': u'\u6d32',
'\xf1\xbe': u'\u6e4a',
'\xf1\xbf': u'\u6f8d',
'\xf1\xc0': u'\u70b7',
'\xf1\xc1': u'\u73e0',
'\xf1\xc2': u'\u7587',
'\xf1\xc3': u'\u7c4c',
'\xf1\xc4': u'\u7d02',
'\xf1\xc5': u'\u7d2c',
'\xf1\xc6': u'\u7da2',
'\xf1\xc7': u'\u821f',
'\xf1\xc8': u'\u86db',
'\xf1\xc9': u'\u8a3b',
'\xf1\xca': u'\u8a85',
'\xf1\xcb': u'\u8d70',
'\xf1\xcc': u'\u8e8a',
'\xf1\xcd': u'\u8f33',
'\xf1\xce': u'\u9031',
'\xf1\xcf': u'\u914e',
'\xf1\xd0': u'\u9152',
'\xf1\xd1': u'\u9444',
'\xf1\xd2': u'\u99d0',
'\xf1\xd3': u'\u7af9',
'\xf1\xd4': u'\u7ca5',
'\xf1\xd5': u'\u4fca',
'\xf1\xd6': u'\u5101',
'\xf1\xd7': u'\u51c6',
'\xf1\xd8': u'\u57c8',
'\xf1\xd9': u'\u5bef',
'\xf1\xda': u'\u5cfb',
'\xf1\xdb': u'\u6659',
'\xf1\xdc': u'\u6a3d',
'\xf1\xdd': u'\u6d5a',
'\xf1\xde': u'\u6e96',
'\xf1\xdf': u'\u6fec',
'\xf1\xe0': u'\u710c',
'\xf1\xe1': u'\u756f',
'\xf1\xe2': u'\u7ae3',
'\xf1\xe3': u'\u8822',
'\xf1\xe4': u'\u9021',
'\xf1\xe5': u'\u9075',
'\xf1\xe6': u'\u96cb',
'\xf1\xe7': u'\u99ff',
'\xf1\xe8': u'\u8301',
'\xf1\xe9': u'\u4e2d',
'\xf1\xea': u'\u4ef2',
'\xf1\xeb': u'\u8846',
'\xf1\xec': u'\u91cd',
'\xf1\xed': u'\u537d',
'\xf1\xee': u'\u6adb',
'\xf1\xef': u'\u696b',
'\xf1\xf0': u'\u6c41',
'\xf1\xf1': u'\u847a',
'\xf1\xf2': u'\u589e',
'\xf1\xf3': u'\u618e',
'\xf1\xf4': u'\u66fe',
'\xf1\xf5': u'\u62ef',
'\xf1\xf6': u'\u70dd',
'\xf1\xf7': u'\u7511',
'\xf1\xf8': u'\u75c7',
'\xf1\xf9': u'\u7e52',
'\xf1\xfa': u'\u84b8',
'\xf1\xfb': u'\u8b49',
'\xf1\xfc': u'\u8d08',
'\xf1\xfd': u'\u4e4b',
'\xf1\xfe': u'\u53ea',
'\xf2\xa1': u'\u54ab',
'\xf2\xa2': u'\u5730',
'\xf2\xa3': u'\u5740',
'\xf2\xa4': u'\u5fd7',
'\xf2\xa5': u'\u6301',
'\xf2\xa6': u'\u6307',
'\xf2\xa7': u'\u646f',
'\xf2\xa8': u'\u652f',
'\xf2\xa9': u'\u65e8',
'\xf2\xaa': u'\u667a',
'\xf2\xab': u'\u679d',
'\xf2\xac': u'\u67b3',
'\xf2\xad': u'\u6b62',
'\xf2\xae': u'\u6c60',
'\xf2\xaf': u'\u6c9a',
'\xf2\xb0': u'\u6f2c',
'\xf2\xb1': u'\u77e5',
'\xf2\xb2': u'\u7825',
'\xf2\xb3': u'\u7949',
'\xf2\xb4': u'\u7957',
'\xf2\xb5': u'\u7d19',
'\xf2\xb6': u'\u80a2',
'\xf2\xb7': u'\u8102',
'\xf2\xb8': u'\u81f3',
'\xf2\xb9': u'\u829d',
'\xf2\xba': u'\u82b7',
'\xf2\xbb': u'\u8718',
'\xf2\xbc': u'\u8a8c',
'\xf2\xbd': u'\uf9fc',
'\xf2\xbe': u'\u8d04',
'\xf2\xbf': u'\u8dbe',
'\xf2\xc0': u'\u9072',
'\xf2\xc1': u'\u76f4',
'\xf2\xc2': u'\u7a19',
'\xf2\xc3': u'\u7a37',
'\xf2\xc4': u'\u7e54',
'\xf2\xc5': u'\u8077',
'\xf2\xc6': u'\u5507',
'\xf2\xc7': u'\u55d4',
'\xf2\xc8': u'\u5875',
'\xf2\xc9': u'\u632f',
'\xf2\xca': u'\u6422',
'\xf2\xcb': u'\u6649',
'\xf2\xcc': u'\u664b',
'\xf2\xcd': u'\u686d',
'\xf2\xce': u'\u699b',
'\xf2\xcf': u'\u6b84',
'\xf2\xd0': u'\u6d25',
'\xf2\xd1': u'\u6eb1',
'\xf2\xd2': u'\u73cd',
'\xf2\xd3': u'\u7468',
'\xf2\xd4': u'\u74a1',
'\xf2\xd5': u'\u755b',
'\xf2\xd6': u'\u75b9',
'\xf2\xd7': u'\u76e1',
'\xf2\xd8': u'\u771e',
'\xf2\xd9': u'\u778b',
'\xf2\xda': u'\u79e6',
'\xf2\xdb': u'\u7e09',
'\xf2\xdc': u'\u7e1d',
'\xf2\xdd': u'\u81fb',
'\xf2\xde': u'\u852f',
'\xf2\xdf': u'\u8897',
'\xf2\xe0': u'\u8a3a',
'\xf2\xe1': u'\u8cd1',
'\xf2\xe2': u'\u8eeb',
'\xf2\xe3': u'\u8fb0',
'\xf2\xe4': u'\u9032',
'\xf2\xe5': u'\u93ad',
'\xf2\xe6': u'\u9663',
'\xf2\xe7': u'\u9673',
'\xf2\xe8': u'\u9707',
'\xf2\xe9': u'\u4f84',
'\xf2\xea': u'\u53f1',
'\xf2\xeb': u'\u59ea',
'\xf2\xec': u'\u5ac9',
'\xf2\xed': u'\u5e19',
'\xf2\xee': u'\u684e',
'\xf2\xef': u'\u74c6',
'\xf2\xf0': u'\u75be',
'\xf2\xf1': u'\u79e9',
'\xf2\xf2': u'\u7a92',
'\xf2\xf3': u'\u81a3',
'\xf2\xf4': u'\u86ed',
'\xf2\xf5': u'\u8cea',
'\xf2\xf6': u'\u8dcc',
'\xf2\xf7': u'\u8fed',
'\xf2\xf8': u'\u659f',
'\xf2\xf9': u'\u6715',
'\xf2\xfa': u'\uf9fd',
'\xf2\xfb': u'\u57f7',
'\xf2\xfc': u'\u6f57',
'\xf2\xfd': u'\u7ddd',
'\xf2\xfe': u'\u8f2f',
'\xf3\xa1': u'\u93f6',
'\xf3\xa2': u'\u96c6',
'\xf3\xa3': u'\u5fb5',
'\xf3\xa4': u'\u61f2',
'\xf3\xa5': u'\u6f84',
'\xf3\xa6': u'\u4e14',
'\xf3\xa7': u'\u4f98',
'\xf3\xa8': u'\u501f',
'\xf3\xa9': u'\u53c9',
'\xf3\xaa': u'\u55df',
'\xf3\xab': u'\u5d6f',
'\xf3\xac': u'\u5dee',
'\xf3\xad': u'\u6b21',
'\xf3\xae': u'\u6b64',
'\xf3\xaf': u'\u78cb',
'\xf3\xb0': u'\u7b9a',
'\xf3\xb1': u'\uf9fe',
'\xf3\xb2': u'\u8e49',
'\xf3\xb3': u'\u8eca',
'\xf3\xb4': u'\u906e',
'\xf3\xb5': u'\u6349',
'\xf3\xb6': u'\u643e',
'\xf3\xb7': u'\u7740',
'\xf3\xb8': u'\u7a84',
'\xf3\xb9': u'\u932f',
'\xf3\xba': u'\u947f',
'\xf3\xbb': u'\u9f6a',
'\xf3\xbc': u'\u64b0',
'\xf3\xbd': u'\u6faf',
'\xf3\xbe': u'\u71e6',
'\xf3\xbf': u'\u74a8',
'\xf3\xc0': u'\u74da',
'\xf3\xc1': u'\u7ac4',
'\xf3\xc2': u'\u7c12',
'\xf3\xc3': u'\u7e82',
'\xf3\xc4': u'\u7cb2',
'\xf3\xc5': u'\u7e98',
'\xf3\xc6': u'\u8b9a',
'\xf3\xc7': u'\u8d0a',
'\xf3\xc8': u'\u947d',
'\xf3\xc9': u'\u9910',
'\xf3\xca': u'\u994c',
'\xf3\xcb': u'\u5239',
'\xf3\xcc': u'\u5bdf',
'\xf3\xcd': u'\u64e6',
'\xf3\xce': u'\u672d',
'\xf3\xcf': u'\u7d2e',
'\xf3\xd0': u'\u50ed',
'\xf3\xd1': u'\u53c3',
'\xf3\xd2': u'\u5879',
'\xf3\xd3': u'\u6158',
'\xf3\xd4': u'\u6159',
'\xf3\xd5': u'\u61fa',
'\xf3\xd6': u'\u65ac',
'\xf3\xd7': u'\u7ad9',
'\xf3\xd8': u'\u8b92',
'\xf3\xd9': u'\u8b96',
'\xf3\xda': u'\u5009',
'\xf3\xdb': u'\u5021',
'\xf3\xdc': u'\u5275',
'\xf3\xdd': u'\u5531',
'\xf3\xde': u'\u5a3c',
'\xf3\xdf': u'\u5ee0',
'\xf3\xe0': u'\u5f70',
'\xf3\xe1': u'\u6134',
'\xf3\xe2': u'\u655e',
'\xf3\xe3': u'\u660c',
'\xf3\xe4': u'\u6636',
'\xf3\xe5': u'\u66a2',
'\xf3\xe6': u'\u69cd',
'\xf3\xe7': u'\u6ec4',
'\xf3\xe8': u'\u6f32',
'\xf3\xe9': u'\u7316',
'\xf3\xea': u'\u7621',
'\xf3\xeb': u'\u7a93',
'\xf3\xec': u'\u8139',
'\xf3\xed': u'\u8259',
'\xf3\xee': u'\u83d6',
'\xf3\xef': u'\u84bc',
'\xf3\xf0': u'\u50b5',
'\xf3\xf1': u'\u57f0',
'\xf3\xf2': u'\u5bc0',
'\xf3\xf3': u'\u5be8',
'\xf3\xf4': u'\u5f69',
'\xf3\xf5': u'\u63a1',
'\xf3\xf6': u'\u7826',
'\xf3\xf7': u'\u7db5',
'\xf3\xf8': u'\u83dc',
'\xf3\xf9': u'\u8521',
'\xf3\xfa': u'\u91c7',
'\xf3\xfb': u'\u91f5',
'\xf3\xfc': u'\u518a',
'\xf3\xfd': u'\u67f5',
'\xf3\xfe': u'\u7b56',
'\xf4\xa1': u'\u8cac',
'\xf4\xa2': u'\u51c4',
'\xf4\xa3': u'\u59bb',
'\xf4\xa4': u'\u60bd',
'\xf4\xa5': u'\u8655',
'\xf4\xa6': u'\u501c',
'\xf4\xa7': u'\uf9ff',
'\xf4\xa8': u'\u5254',
'\xf4\xa9': u'\u5c3a',
'\xf4\xaa': u'\u617d',
'\xf4\xab': u'\u621a',
'\xf4\xac': u'\u62d3',
'\xf4\xad': u'\u64f2',
'\xf4\xae': u'\u65a5',
'\xf4\xaf': u'\u6ecc',
'\xf4\xb0': u'\u7620',
'\xf4\xb1': u'\u810a',
'\xf4\xb2': u'\u8e60',
'\xf4\xb3': u'\u965f',
'\xf4\xb4': u'\u96bb',
'\xf4\xb5': u'\u4edf',
'\xf4\xb6': u'\u5343',
'\xf4\xb7': u'\u5598',
'\xf4\xb8': u'\u5929',
'\xf4\xb9': u'\u5ddd',
'\xf4\xba': u'\u64c5',
'\xf4\xbb': u'\u6cc9',
'\xf4\xbc': u'\u6dfa',
'\xf4\xbd': u'\u7394',
'\xf4\xbe': u'\u7a7f',
'\xf4\xbf': u'\u821b',
'\xf4\xc0': u'\u85a6',
'\xf4\xc1': u'\u8ce4',
'\xf4\xc2': u'\u8e10',
'\xf4\xc3': u'\u9077',
'\xf4\xc4': u'\u91e7',
'\xf4\xc5': u'\u95e1',
'\xf4\xc6': u'\u9621',
'\xf4\xc7': u'\u97c6',
'\xf4\xc8': u'\u51f8',
'\xf4\xc9': u'\u54f2',
'\xf4\xca': u'\u5586',
'\xf4\xcb': u'\u5fb9',
'\xf4\xcc': u'\u64a4',
'\xf4\xcd': u'\u6f88',
'\xf4\xce': u'\u7db4',
'\xf4\xcf': u'\u8f1f',
'\xf4\xd0': u'\u8f4d',
'\xf4\xd1': u'\u9435',
'\xf4\xd2': u'\u50c9',
'\xf4\xd3': u'\u5c16',
'\xf4\xd4': u'\u6cbe',
'\xf4\xd5': u'\u6dfb',
'\xf4\xd6': u'\u751b',
'\xf4\xd7': u'\u77bb',
'\xf4\xd8': u'\u7c3d',
'\xf4\xd9': u'\u7c64',
'\xf4\xda': u'\u8a79',
'\xf4\xdb': u'\u8ac2',
'\xf4\xdc': u'\u581e',
'\xf4\xdd': u'\u59be',
'\xf4\xde': u'\u5e16',
'\xf4\xdf': u'\u6377',
'\xf4\xe0': u'\u7252',
'\xf4\xe1': u'\u758a',
'\xf4\xe2': u'\u776b',
'\xf4\xe3': u'\u8adc',
'\xf4\xe4': u'\u8cbc',
'\xf4\xe5': u'\u8f12',
'\xf4\xe6': u'\u5ef3',
'\xf4\xe7': u'\u6674',
'\xf4\xe8': u'\u6df8',
'\xf4\xe9': u'\u807d',
'\xf4\xea': u'\u83c1',
'\xf4\xeb': u'\u8acb',
'\xf4\xec': u'\u9751',
'\xf4\xed': u'\u9bd6',
'\xf4\xee': u'\ufa00',
'\xf4\xef': u'\u5243',
'\xf4\xf0': u'\u66ff',
'\xf4\xf1': u'\u6d95',
'\xf4\xf2': u'\u6eef',
'\xf4\xf3': u'\u7de0',
'\xf4\xf4': u'\u8ae6',
'\xf4\xf5': u'\u902e',
'\xf4\xf6': u'\u905e',
'\xf4\xf7': u'\u9ad4',
'\xf4\xf8': u'\u521d',
'\xf4\xf9': u'\u527f',
'\xf4\xfa': u'\u54e8',
'\xf4\xfb': u'\u6194',
'\xf4\xfc': u'\u6284',
'\xf4\xfd': u'\u62db',
'\xf4\xfe': u'\u68a2',
'\xf5\xa1': u'\u6912',
'\xf5\xa2': u'\u695a',
'\xf5\xa3': u'\u6a35',
'\xf5\xa4': u'\u7092',
'\xf5\xa5': u'\u7126',
'\xf5\xa6': u'\u785d',
'\xf5\xa7': u'\u7901',
'\xf5\xa8': u'\u790e',
'\xf5\xa9': u'\u79d2',
'\xf5\xaa': u'\u7a0d',
'\xf5\xab': u'\u8096',
'\xf5\xac': u'\u8278',
'\xf5\xad': u'\u82d5',
'\xf5\xae': u'\u8349',
'\xf5\xaf': u'\u8549',
'\xf5\xb0': u'\u8c82',
'\xf5\xb1': u'\u8d85',
'\xf5\xb2': u'\u9162',
'\xf5\xb3': u'\u918b',
'\xf5\xb4': u'\u91ae',
'\xf5\xb5': u'\u4fc3',
'\xf5\xb6': u'\u56d1',
'\xf5\xb7': u'\u71ed',
'\xf5\xb8': u'\u77d7',
'\xf5\xb9': u'\u8700',
'\xf5\xba': u'\u89f8',
'\xf5\xbb': u'\u5bf8',
'\xf5\xbc': u'\u5fd6',
'\xf5\xbd': u'\u6751',
'\xf5\xbe': u'\u90a8',
'\xf5\xbf': u'\u53e2',
'\xf5\xc0': u'\u585a',
'\xf5\xc1': u'\u5bf5',
'\xf5\xc2': u'\u60a4',
'\xf5\xc3': u'\u6181',
'\xf5\xc4': u'\u6460',
'\xf5\xc5': u'\u7e3d',
'\xf5\xc6': u'\u8070',
'\xf5\xc7': u'\u8525',
'\xf5\xc8': u'\u9283',
'\xf5\xc9': u'\u64ae',
'\xf5\xca': u'\u50ac',
'\xf5\xcb': u'\u5d14',
'\xf5\xcc': u'\u6700',
'\xf5\xcd': u'\u589c',
'\xf5\xce': u'\u62bd',
'\xf5\xcf': u'\u63a8',
'\xf5\xd0': u'\u690e',
'\xf5\xd1': u'\u6978',
'\xf5\xd2': u'\u6a1e',
'\xf5\xd3': u'\u6e6b',
'\xf5\xd4': u'\u76ba',
'\xf5\xd5': u'\u79cb',
'\xf5\xd6': u'\u82bb',
'\xf5\xd7': u'\u8429',
'\xf5\xd8': u'\u8acf',
'\xf5\xd9': u'\u8da8',
'\xf5\xda': u'\u8ffd',
'\xf5\xdb': u'\u9112',
'\xf5\xdc': u'\u914b',
'\xf5\xdd': u'\u919c',
'\xf5\xde': u'\u9310',
'\xf5\xdf': u'\u9318',
'\xf5\xe0': u'\u939a',
'\xf5\xe1': u'\u96db',
'\xf5\xe2': u'\u9a36',
'\xf5\xe3': u'\u9c0d',
'\xf5\xe4': u'\u4e11',
'\xf5\xe5': u'\u755c',
'\xf5\xe6': u'\u795d',
'\xf5\xe7': u'\u7afa',
'\xf5\xe8': u'\u7b51',
'\xf5\xe9': u'\u7bc9',
'\xf5\xea': u'\u7e2e',
'\xf5\xeb': u'\u84c4',
'\xf5\xec': u'\u8e59',
'\xf5\xed': u'\u8e74',
'\xf5\xee': u'\u8ef8',
'\xf5\xef': u'\u9010',
'\xf5\xf0': u'\u6625',
'\xf5\xf1': u'\u693f',
'\xf5\xf2': u'\u7443',
'\xf5\xf3': u'\u51fa',
'\xf5\xf4': u'\u672e',
'\xf5\xf5': u'\u9edc',
'\xf5\xf6': u'\u5145',
'\xf5\xf7': u'\u5fe0',
'\xf5\xf8': u'\u6c96',
'\xf5\xf9': u'\u87f2',
'\xf5\xfa': u'\u885d',
'\xf5\xfb': u'\u8877',
'\xf5\xfc': u'\u60b4',
'\xf5\xfd': u'\u81b5',
'\xf5\xfe': u'\u8403',
'\xf6\xa1': u'\u8d05',
'\xf6\xa2': u'\u53d6',
'\xf6\xa3': u'\u5439',
'\xf6\xa4': u'\u5634',
'\xf6\xa5': u'\u5a36',
'\xf6\xa6': u'\u5c31',
'\xf6\xa7': u'\u708a',
'\xf6\xa8': u'\u7fe0',
'\xf6\xa9': u'\u805a',
'\xf6\xaa': u'\u8106',
'\xf6\xab': u'\u81ed',
'\xf6\xac': u'\u8da3',
'\xf6\xad': u'\u9189',
'\xf6\xae': u'\u9a5f',
'\xf6\xaf': u'\u9df2',
'\xf6\xb0': u'\u5074',
'\xf6\xb1': u'\u4ec4',
'\xf6\xb2': u'\u53a0',
'\xf6\xb3': u'\u60fb',
'\xf6\xb4': u'\u6e2c',
'\xf6\xb5': u'\u5c64',
'\xf6\xb6': u'\u4f88',
'\xf6\xb7': u'\u5024',
'\xf6\xb8': u'\u55e4',
'\xf6\xb9': u'\u5cd9',
'\xf6\xba': u'\u5e5f',
'\xf6\xbb': u'\u6065',
'\xf6\xbc': u'\u6894',
'\xf6\xbd': u'\u6cbb',
'\xf6\xbe': u'\u6dc4',
'\xf6\xbf': u'\u71be',
'\xf6\xc0': u'\u75d4',
'\xf6\xc1': u'\u75f4',
'\xf6\xc2': u'\u7661',
'\xf6\xc3': u'\u7a1a',
'\xf6\xc4': u'\u7a49',
'\xf6\xc5': u'\u7dc7',
'\xf6\xc6': u'\u7dfb',
'\xf6\xc7': u'\u7f6e',
'\xf6\xc8': u'\u81f4',
'\xf6\xc9': u'\u86a9',
'\xf6\xca': u'\u8f1c',
'\xf6\xcb': u'\u96c9',
'\xf6\xcc': u'\u99b3',
'\xf6\xcd': u'\u9f52',
'\xf6\xce': u'\u5247',
'\xf6\xcf': u'\u52c5',
'\xf6\xd0': u'\u98ed',
'\xf6\xd1': u'\u89aa',
'\xf6\xd2': u'\u4e03',
'\xf6\xd3': u'\u67d2',
'\xf6\xd4': u'\u6f06',
'\xf6\xd5': u'\u4fb5',
'\xf6\xd6': u'\u5be2',
'\xf6\xd7': u'\u6795',
'\xf6\xd8': u'\u6c88',
'\xf6\xd9': u'\u6d78',
'\xf6\xda': u'\u741b',
'\xf6\xdb': u'\u7827',
'\xf6\xdc': u'\u91dd',
'\xf6\xdd': u'\u937c',
'\xf6\xde': u'\u87c4',
'\xf6\xdf': u'\u79e4',
'\xf6\xe0': u'\u7a31',
'\xf6\xe1': u'\u5feb',
'\xf6\xe2': u'\u4ed6',
'\xf6\xe3': u'\u54a4',
'\xf6\xe4': u'\u553e',
'\xf6\xe5': u'\u58ae',
'\xf6\xe6': u'\u59a5',
'\xf6\xe7': u'\u60f0',
'\xf6\xe8': u'\u6253',
'\xf6\xe9': u'\u62d6',
'\xf6\xea': u'\u6736',
'\xf6\xeb': u'\u6955',
'\xf6\xec': u'\u8235',
'\xf6\xed': u'\u9640',
'\xf6\xee': u'\u99b1',
'\xf6\xef': u'\u99dd',
'\xf6\xf0': u'\u502c',
'\xf6\xf1': u'\u5353',
'\xf6\xf2': u'\u5544',
'\xf6\xf3': u'\u577c',
'\xf6\xf4': u'\ufa01',
'\xf6\xf5': u'\u6258',
'\xf6\xf6': u'\ufa02',
'\xf6\xf7': u'\u64e2',
'\xf6\xf8': u'\u666b',
'\xf6\xf9': u'\u67dd',
'\xf6\xfa': u'\u6fc1',
'\xf6\xfb': u'\u6fef',
'\xf6\xfc': u'\u7422',
'\xf6\xfd': u'\u7438',
'\xf6\xfe': u'\u8a17',
'\xf7\xa1': u'\u9438',
'\xf7\xa2': u'\u5451',
'\xf7\xa3': u'\u5606',
'\xf7\xa4': u'\u5766',
'\xf7\xa5': u'\u5f48',
'\xf7\xa6': u'\u619a',
'\xf7\xa7': u'\u6b4e',
'\xf7\xa8': u'\u7058',
'\xf7\xa9': u'\u70ad',
'\xf7\xaa': u'\u7dbb',
'\xf7\xab': u'\u8a95',
'\xf7\xac': u'\u596a',
'\xf7\xad': u'\u812b',
'\xf7\xae': u'\u63a2',
'\xf7\xaf': u'\u7708',
'\xf7\xb0': u'\u803d',
'\xf7\xb1': u'\u8caa',
'\xf7\xb2': u'\u5854',
'\xf7\xb3': u'\u642d',
'\xf7\xb4': u'\u69bb',
'\xf7\xb5': u'\u5b95',
'\xf7\xb6': u'\u5e11',
'\xf7\xb7': u'\u6e6f',
'\xf7\xb8': u'\ufa03',
'\xf7\xb9': u'\u8569',
'\xf7\xba': u'\u514c',
'\xf7\xbb': u'\u53f0',
'\xf7\xbc': u'\u592a',
'\xf7\xbd': u'\u6020',
'\xf7\xbe': u'\u614b',
'\xf7\xbf': u'\u6b86',
'\xf7\xc0': u'\u6c70',
'\xf7\xc1': u'\u6cf0',
'\xf7\xc2': u'\u7b1e',
'\xf7\xc3': u'\u80ce',
'\xf7\xc4': u'\u82d4',
'\xf7\xc5': u'\u8dc6',
'\xf7\xc6': u'\u90b0',
'\xf7\xc7': u'\u98b1',
'\xf7\xc8': u'\ufa04',
'\xf7\xc9': u'\u64c7',
'\xf7\xca': u'\u6fa4',
'\xf7\xcb': u'\u6491',
'\xf7\xcc': u'\u6504',
'\xf7\xcd': u'\u514e',
'\xf7\xce': u'\u5410',
'\xf7\xcf': u'\u571f',
'\xf7\xd0': u'\u8a0e',
'\xf7\xd1': u'\u615f',
'\xf7\xd2': u'\u6876',
'\xf7\xd3': u'\ufa05',
'\xf7\xd4': u'\u75db',
'\xf7\xd5': u'\u7b52',
'\xf7\xd6': u'\u7d71',
'\xf7\xd7': u'\u901a',
'\xf7\xd8': u'\u5806',
'\xf7\xd9': u'\u69cc',
'\xf7\xda': u'\u817f',
'\xf7\xdb': u'\u892a',
'\xf7\xdc': u'\u9000',
'\xf7\xdd': u'\u9839',
'\xf7\xde': u'\u5078',
'\xf7\xdf': u'\u5957',
'\xf7\xe0': u'\u59ac',
'\xf7\xe1': u'\u6295',
'\xf7\xe2': u'\u900f',
'\xf7\xe3': u'\u9b2a',
'\xf7\xe4': u'\u615d',
'\xf7\xe5': u'\u7279',
'\xf7\xe6': u'\u95d6',
'\xf7\xe7': u'\u5761',
'\xf7\xe8': u'\u5a46',
'\xf7\xe9': u'\u5df4',
'\xf7\xea': u'\u628a',
'\xf7\xeb': u'\u64ad',
'\xf7\xec': u'\u64fa',
'\xf7\xed': u'\u6777',
'\xf7\xee': u'\u6ce2',
'\xf7\xef': u'\u6d3e',
'\xf7\xf0': u'\u722c',
'\xf7\xf1': u'\u7436',
'\xf7\xf2': u'\u7834',
'\xf7\xf3': u'\u7f77',
'\xf7\xf4': u'\u82ad',
'\xf7\xf5': u'\u8ddb',
'\xf7\xf6': u'\u9817',
'\xf7\xf7': u'\u5224',
'\xf7\xf8': u'\u5742',
'\xf7\xf9': u'\u677f',
'\xf7\xfa': u'\u7248',
'\xf7\xfb': u'\u74e3',
'\xf7\xfc': u'\u8ca9',
'\xf7\xfd': u'\u8fa6',
'\xf7\xfe': u'\u9211',
'\xf8\xa1': u'\u962a',
'\xf8\xa2': u'\u516b',
'\xf8\xa3': u'\u53ed',
'\xf8\xa4': u'\u634c',
'\xf8\xa5': u'\u4f69',
'\xf8\xa6': u'\u5504',
'\xf8\xa7': u'\u6096',
'\xf8\xa8': u'\u6557',
'\xf8\xa9': u'\u6c9b',
'\xf8\xaa': u'\u6d7f',
'\xf8\xab': u'\u724c',
'\xf8\xac': u'\u72fd',
'\xf8\xad': u'\u7a17',
'\xf8\xae': u'\u8987',
'\xf8\xaf': u'\u8c9d',
'\xf8\xb0': u'\u5f6d',
'\xf8\xb1': u'\u6f8e',
'\xf8\xb2': u'\u70f9',
'\xf8\xb3': u'\u81a8',
'\xf8\xb4': u'\u610e',
'\xf8\xb5': u'\u4fbf',
'\xf8\xb6': u'\u504f',
'\xf8\xb7': u'\u6241',
'\xf8\xb8': u'\u7247',
'\xf8\xb9': u'\u7bc7',
'\xf8\xba': u'\u7de8',
'\xf8\xbb': u'\u7fe9',
'\xf8\xbc': u'\u904d',
'\xf8\xbd': u'\u97ad',
'\xf8\xbe': u'\u9a19',
'\xf8\xbf': u'\u8cb6',
'\xf8\xc0': u'\u576a',
'\xf8\xc1': u'\u5e73',
'\xf8\xc2': u'\u67b0',
'\xf8\xc3': u'\u840d',
'\xf8\xc4': u'\u8a55',
'\xf8\xc5': u'\u5420',
'\xf8\xc6': u'\u5b16',
'\xf8\xc7': u'\u5e63',
'\xf8\xc8': u'\u5ee2',
'\xf8\xc9': u'\u5f0a',
'\xf8\xca': u'\u6583',
'\xf8\xcb': u'\u80ba',
'\xf8\xcc': u'\u853d',
'\xf8\xcd': u'\u9589',
'\xf8\xce': u'\u965b',
'\xf8\xcf': u'\u4f48',
'\xf8\xd0': u'\u5305',
'\xf8\xd1': u'\u530d',
'\xf8\xd2': u'\u530f',
'\xf8\xd3': u'\u5486',
'\xf8\xd4': u'\u54fa',
'\xf8\xd5': u'\u5703',
'\xf8\xd6': u'\u5e03',
'\xf8\xd7': u'\u6016',
'\xf8\xd8': u'\u629b',
'\xf8\xd9': u'\u62b1',
'\xf8\xda': u'\u6355',
'\xf8\xdb': u'\ufa06',
'\xf8\xdc': u'\u6ce1',
'\xf8\xdd': u'\u6d66',
'\xf8\xde': u'\u75b1',
'\xf8\xdf': u'\u7832',
'\xf8\xe0': u'\u80de',
'\xf8\xe1': u'\u812f',
'\xf8\xe2': u'\u82de',
'\xf8\xe3': u'\u8461',
'\xf8\xe4': u'\u84b2',
'\xf8\xe5': u'\u888d',
'\xf8\xe6': u'\u8912',
'\xf8\xe7': u'\u900b',
'\xf8\xe8': u'\u92ea',
'\xf8\xe9': u'\u98fd',
'\xf8\xea': u'\u9b91',
'\xf8\xeb': u'\u5e45',
'\xf8\xec': u'\u66b4',
'\xf8\xed': u'\u66dd',
'\xf8\xee': u'\u7011',
'\xf8\xef': u'\u7206',
'\xf8\xf0': u'\ufa07',
'\xf8\xf1': u'\u4ff5',
'\xf8\xf2': u'\u527d',
'\xf8\xf3': u'\u5f6a',
'\xf8\xf4': u'\u6153',
'\xf8\xf5': u'\u6753',
'\xf8\xf6': u'\u6a19',
'\xf8\xf7': u'\u6f02',
'\xf8\xf8': u'\u74e2',
'\xf8\xf9': u'\u7968',
'\xf8\xfa': u'\u8868',
'\xf8\xfb': u'\u8c79',
'\xf8\xfc': u'\u98c7',
'\xf8\xfd': u'\u98c4',
'\xf8\xfe': u'\u9a43',
'\xf9\xa1': u'\u54c1',
'\xf9\xa2': u'\u7a1f',
'\xf9\xa3': u'\u6953',
'\xf9\xa4': u'\u8af7',
'\xf9\xa5': u'\u8c4a',
'\xf9\xa6': u'\u98a8',
'\xf9\xa7': u'\u99ae',
'\xf9\xa8': u'\u5f7c',
'\xf9\xa9': u'\u62ab',
'\xf9\xaa': u'\u75b2',
'\xf9\xab': u'\u76ae',
'\xf9\xac': u'\u88ab',
'\xf9\xad': u'\u907f',
'\xf9\xae': u'\u9642',
'\xf9\xaf': u'\u5339',
'\xf9\xb0': u'\u5f3c',
'\xf9\xb1': u'\u5fc5',
'\xf9\xb2': u'\u6ccc',
'\xf9\xb3': u'\u73cc',
'\xf9\xb4': u'\u7562',
'\xf9\xb5': u'\u758b',
'\xf9\xb6': u'\u7b46',
'\xf9\xb7': u'\u82fe',
'\xf9\xb8': u'\u999d',
'\xf9\xb9': u'\u4e4f',
'\xf9\xba': u'\u903c',
'\xf9\xbb': u'\u4e0b',
'\xf9\xbc': u'\u4f55',
'\xf9\xbd': u'\u53a6',
'\xf9\xbe': u'\u590f',
'\xf9\xbf': u'\u5ec8',
'\xf9\xc0': u'\u6630',
'\xf9\xc1': u'\u6cb3',
'\xf9\xc2': u'\u7455',
'\xf9\xc3': u'\u8377',
'\xf9\xc4': u'\u8766',
'\xf9\xc5': u'\u8cc0',
'\xf9\xc6': u'\u9050',
'\xf9\xc7': u'\u971e',
'\xf9\xc8': u'\u9c15',
'\xf9\xc9': u'\u58d1',
'\xf9\xca': u'\u5b78',
'\xf9\xcb': u'\u8650',
'\xf9\xcc': u'\u8b14',
'\xf9\xcd': u'\u9db4',
'\xf9\xce': u'\u5bd2',
'\xf9\xcf': u'\u6068',
'\xf9\xd0': u'\u608d',
'\xf9\xd1': u'\u65f1',
'\xf9\xd2': u'\u6c57',
'\xf9\xd3': u'\u6f22',
'\xf9\xd4': u'\u6fa3',
'\xf9\xd5': u'\u701a',
'\xf9\xd6': u'\u7f55',
'\xf9\xd7': u'\u7ff0',
'\xf9\xd8': u'\u9591',
'\xf9\xd9': u'\u9592',
'\xf9\xda': u'\u9650',
'\xf9\xdb': u'\u97d3',
'\xf9\xdc': u'\u5272',
'\xf9\xdd': u'\u8f44',
'\xf9\xde': u'\u51fd',
'\xf9\xdf': u'\u542b',
'\xf9\xe0': u'\u54b8',
'\xf9\xe1': u'\u5563',
'\xf9\xe2': u'\u558a',
'\xf9\xe3': u'\u6abb',
'\xf9\xe4': u'\u6db5',
'\xf9\xe5': u'\u7dd8',
'\xf9\xe6': u'\u8266',
'\xf9\xe7': u'\u929c',
'\xf9\xe8': u'\u9677',
'\xf9\xe9': u'\u9e79',
'\xf9\xea': u'\u5408',
'\xf9\xeb': u'\u54c8',
'\xf9\xec': u'\u76d2',
'\xf9\xed': u'\u86e4',
'\xf9\xee': u'\u95a4',
'\xf9\xef': u'\u95d4',
'\xf9\xf0': u'\u965c',
'\xf9\xf1': u'\u4ea2',
'\xf9\xf2': u'\u4f09',
'\xf9\xf3': u'\u59ee',
'\xf9\xf4': u'\u5ae6',
'\xf9\xf5': u'\u5df7',
'\xf9\xf6': u'\u6052',
'\xf9\xf7': u'\u6297',
'\xf9\xf8': u'\u676d',
'\xf9\xf9': u'\u6841',
'\xf9\xfa': u'\u6c86',
'\xf9\xfb': u'\u6e2f',
'\xf9\xfc': u'\u7f38',
'\xf9\xfd': u'\u809b',
'\xf9\xfe': u'\u822a',
'\xfa\xa1': u'\ufa08',
'\xfa\xa2': u'\ufa09',
'\xfa\xa3': u'\u9805',
'\xfa\xa4': u'\u4ea5',
'\xfa\xa5': u'\u5055',
'\xfa\xa6': u'\u54b3',
'\xfa\xa7': u'\u5793',
'\xfa\xa8': u'\u595a',
'\xfa\xa9': u'\u5b69',
'\xfa\xaa': u'\u5bb3',
'\xfa\xab': u'\u61c8',
'\xfa\xac': u'\u6977',
'\xfa\xad': u'\u6d77',
'\xfa\xae': u'\u7023',
'\xfa\xaf': u'\u87f9',
'\xfa\xb0': u'\u89e3',
'\xfa\xb1': u'\u8a72',
'\xfa\xb2': u'\u8ae7',
'\xfa\xb3': u'\u9082',
'\xfa\xb4': u'\u99ed',
'\xfa\xb5': u'\u9ab8',
'\xfa\xb6': u'\u52be',
'\xfa\xb7': u'\u6838',
'\xfa\xb8': u'\u5016',
'\xfa\xb9': u'\u5e78',
'\xfa\xba': u'\u674f',
'\xfa\xbb': u'\u8347',
'\xfa\xbc': u'\u884c',
'\xfa\xbd': u'\u4eab',
'\xfa\xbe': u'\u5411',
'\xfa\xbf': u'\u56ae',
'\xfa\xc0': u'\u73e6',
'\xfa\xc1': u'\u9115',
'\xfa\xc2': u'\u97ff',
'\xfa\xc3': u'\u9909',
'\xfa\xc4': u'\u9957',
'\xfa\xc5': u'\u9999',
'\xfa\xc6': u'\u5653',
'\xfa\xc7': u'\u589f',
'\xfa\xc8': u'\u865b',
'\xfa\xc9': u'\u8a31',
'\xfa\xca': u'\u61b2',
'\xfa\xcb': u'\u6af6',
'\xfa\xcc': u'\u737b',
'\xfa\xcd': u'\u8ed2',
'\xfa\xce': u'\u6b47',
'\xfa\xcf': u'\u96aa',
'\xfa\xd0': u'\u9a57',
'\xfa\xd1': u'\u5955',
'\xfa\xd2': u'\u7200',
'\xfa\xd3': u'\u8d6b',
'\xfa\xd4': u'\u9769',
'\xfa\xd5': u'\u4fd4',
'\xfa\xd6': u'\u5cf4',
'\xfa\xd7': u'\u5f26',
'\xfa\xd8': u'\u61f8',
'\xfa\xd9': u'\u665b',
'\xfa\xda': u'\u6ceb',
'\xfa\xdb': u'\u70ab',
'\xfa\xdc': u'\u7384',
'\xfa\xdd': u'\u73b9',
'\xfa\xde': u'\u73fe',
'\xfa\xdf': u'\u7729',
'\xfa\xe0': u'\u774d',
'\xfa\xe1': u'\u7d43',
'\xfa\xe2': u'\u7d62',
'\xfa\xe3': u'\u7e23',
'\xfa\xe4': u'\u8237',
'\xfa\xe5': u'\u8852',
'\xfa\xe6': u'\ufa0a',
'\xfa\xe7': u'\u8ce2',
'\xfa\xe8': u'\u9249',
'\xfa\xe9': u'\u986f',
'\xfa\xea': u'\u5b51',
'\xfa\xeb': u'\u7a74',
'\xfa\xec': u'\u8840',
'\xfa\xed': u'\u9801',
'\xfa\xee': u'\u5acc',
'\xfa\xef': u'\u4fe0',
'\xfa\xf0': u'\u5354',
'\xfa\xf1': u'\u593e',
'\xfa\xf2': u'\u5cfd',
'\xfa\xf3': u'\u633e',
'\xfa\xf4': u'\u6d79',
'\xfa\xf5': u'\u72f9',
'\xfa\xf6': u'\u8105',
'\xfa\xf7': u'\u8107',
'\xfa\xf8': u'\u83a2',
'\xfa\xf9': u'\u92cf',
'\xfa\xfa': u'\u9830',
'\xfa\xfb': u'\u4ea8',
'\xfa\xfc': u'\u5144',
'\xfa\xfd': u'\u5211',
'\xfa\xfe': u'\u578b',
'\xfb\xa1': u'\u5f62',
'\xfb\xa2': u'\u6cc2',
'\xfb\xa3': u'\u6ece',
'\xfb\xa4': u'\u7005',
'\xfb\xa5': u'\u7050',
'\xfb\xa6': u'\u70af',
'\xfb\xa7': u'\u7192',
'\xfb\xa8': u'\u73e9',
'\xfb\xa9': u'\u7469',
'\xfb\xaa': u'\u834a',
'\xfb\xab': u'\u87a2',
'\xfb\xac': u'\u8861',
'\xfb\xad': u'\u9008',
'\xfb\xae': u'\u90a2',
'\xfb\xaf': u'\u93a3',
'\xfb\xb0': u'\u99a8',
'\xfb\xb1': u'\u516e',
'\xfb\xb2': u'\u5f57',
'\xfb\xb3': u'\u60e0',
'\xfb\xb4': u'\u6167',
'\xfb\xb5': u'\u66b3',
'\xfb\xb6': u'\u8559',
'\xfb\xb7': u'\u8e4a',
'\xfb\xb8': u'\u91af',
'\xfb\xb9': u'\u978b',
'\xfb\xba': u'\u4e4e',
'\xfb\xbb': u'\u4e92',
'\xfb\xbc': u'\u547c',
'\xfb\xbd': u'\u58d5',
'\xfb\xbe': u'\u58fa',
'\xfb\xbf': u'\u597d',
'\xfb\xc0': u'\u5cb5',
'\xfb\xc1': u'\u5f27',
'\xfb\xc2': u'\u6236',
'\xfb\xc3': u'\u6248',
'\xfb\xc4': u'\u660a',
'\xfb\xc5': u'\u6667',
'\xfb\xc6': u'\u6beb',
'\xfb\xc7': u'\u6d69',
'\xfb\xc8': u'\u6dcf',
'\xfb\xc9': u'\u6e56',
'\xfb\xca': u'\u6ef8',
'\xfb\xcb': u'\u6f94',
'\xfb\xcc': u'\u6fe0',
'\xfb\xcd': u'\u6fe9',
'\xfb\xce': u'\u705d',
'\xfb\xcf': u'\u72d0',
'\xfb\xd0': u'\u7425',
'\xfb\xd1': u'\u745a',
'\xfb\xd2': u'\u74e0',
'\xfb\xd3': u'\u7693',
'\xfb\xd4': u'\u795c',
'\xfb\xd5': u'\u7cca',
'\xfb\xd6': u'\u7e1e',
'\xfb\xd7': u'\u80e1',
'\xfb\xd8': u'\u82a6',
'\xfb\xd9': u'\u846b',
'\xfb\xda': u'\u84bf',
'\xfb\xdb': u'\u864e',
'\xfb\xdc': u'\u865f',
'\xfb\xdd': u'\u8774',
'\xfb\xde': u'\u8b77',
'\xfb\xdf': u'\u8c6a',
'\xfb\xe0': u'\u93ac',
'\xfb\xe1': u'\u9800',
'\xfb\xe2': u'\u9865',
'\xfb\xe3': u'\u60d1',
'\xfb\xe4': u'\u6216',
'\xfb\xe5': u'\u9177',
'\xfb\xe6': u'\u5a5a',
'\xfb\xe7': u'\u660f',
'\xfb\xe8': u'\u6df7',
'\xfb\xe9': u'\u6e3e',
'\xfb\xea': u'\u743f',
'\xfb\xeb': u'\u9b42',
'\xfb\xec': u'\u5ffd',
'\xfb\xed': u'\u60da',
'\xfb\xee': u'\u7b0f',
'\xfb\xef': u'\u54c4',
'\xfb\xf0': u'\u5f18',
'\xfb\xf1': u'\u6c5e',
'\xfb\xf2': u'\u6cd3',
'\xfb\xf3': u'\u6d2a',
'\xfb\xf4': u'\u70d8',
'\xfb\xf5': u'\u7d05',
'\xfb\xf6': u'\u8679',
'\xfb\xf7': u'\u8a0c',
'\xfb\xf8': u'\u9d3b',
'\xfb\xf9': u'\u5316',
'\xfb\xfa': u'\u548c',
'\xfb\xfb': u'\u5b05',
'\xfb\xfc': u'\u6a3a',
'\xfb\xfd': u'\u706b',
'\xfb\xfe': u'\u7575',
'\xfc\xa1': u'\u798d',
'\xfc\xa2': u'\u79be',
'\xfc\xa3': u'\u82b1',
'\xfc\xa4': u'\u83ef',
'\xfc\xa5': u'\u8a71',
'\xfc\xa6': u'\u8b41',
'\xfc\xa7': u'\u8ca8',
'\xfc\xa8': u'\u9774',
'\xfc\xa9': u'\ufa0b',
'\xfc\xaa': u'\u64f4',
'\xfc\xab': u'\u652b',
'\xfc\xac': u'\u78ba',
'\xfc\xad': u'\u78bb',
'\xfc\xae': u'\u7a6b',
'\xfc\xaf': u'\u4e38',
'\xfc\xb0': u'\u559a',
'\xfc\xb1': u'\u5950',
'\xfc\xb2': u'\u5ba6',
'\xfc\xb3': u'\u5e7b',
'\xfc\xb4': u'\u60a3',
'\xfc\xb5': u'\u63db',
'\xfc\xb6': u'\u6b61',
'\xfc\xb7': u'\u6665',
'\xfc\xb8': u'\u6853',
'\xfc\xb9': u'\u6e19',
'\xfc\xba': u'\u7165',
'\xfc\xbb': u'\u74b0',
'\xfc\xbc': u'\u7d08',
'\xfc\xbd': u'\u9084',
'\xfc\xbe': u'\u9a69',
'\xfc\xbf': u'\u9c25',
'\xfc\xc0': u'\u6d3b',
'\xfc\xc1': u'\u6ed1',
'\xfc\xc2': u'\u733e',
'\xfc\xc3': u'\u8c41',
'\xfc\xc4': u'\u95ca',
'\xfc\xc5': u'\u51f0',
'\xfc\xc6': u'\u5e4c',
'\xfc\xc7': u'\u5fa8',
'\xfc\xc8': u'\u604d',
'\xfc\xc9': u'\u60f6',
'\xfc\xca': u'\u6130',
'\xfc\xcb': u'\u614c',
'\xfc\xcc': u'\u6643',
'\xfc\xcd': u'\u6644',
'\xfc\xce': u'\u69a5',
'\xfc\xcf': u'\u6cc1',
'\xfc\xd0': u'\u6e5f',
'\xfc\xd1': u'\u6ec9',
'\xfc\xd2': u'\u6f62',
'\xfc\xd3': u'\u714c',
'\xfc\xd4': u'\u749c',
'\xfc\xd5': u'\u7687',
'\xfc\xd6': u'\u7bc1',
'\xfc\xd7': u'\u7c27',
'\xfc\xd8': u'\u8352',
'\xfc\xd9': u'\u8757',
'\xfc\xda': u'\u9051',
'\xfc\xdb': u'\u968d',
'\xfc\xdc': u'\u9ec3',
'\xfc\xdd': u'\u532f',
'\xfc\xde': u'\u56de',
'\xfc\xdf': u'\u5efb',
'\xfc\xe0': u'\u5f8a',
'\xfc\xe1': u'\u6062',
'\xfc\xe2': u'\u6094',
'\xfc\xe3': u'\u61f7',
'\xfc\xe4': u'\u6666',
'\xfc\xe5': u'\u6703',
'\xfc\xe6': u'\u6a9c',
'\xfc\xe7': u'\u6dee',
'\xfc\xe8': u'\u6fae',
'\xfc\xe9': u'\u7070',
'\xfc\xea': u'\u736a',
'\xfc\xeb': u'\u7e6a',
'\xfc\xec': u'\u81be',
'\xfc\xed': u'\u8334',
'\xfc\xee': u'\u86d4',
'\xfc\xef': u'\u8aa8',
'\xfc\xf0': u'\u8cc4',
'\xfc\xf1': u'\u5283',
'\xfc\xf2': u'\u7372',
'\xfc\xf3': u'\u5b96',
'\xfc\xf4': u'\u6a6b',
'\xfc\xf5': u'\u9404',
'\xfc\xf6': u'\u54ee',
'\xfc\xf7': u'\u5686',
'\xfc\xf8': u'\u5b5d',
'\xfc\xf9': u'\u6548',
'\xfc\xfa': u'\u6585',
'\xfc\xfb': u'\u66c9',
'\xfc\xfc': u'\u689f',
'\xfc\xfd': u'\u6d8d',
'\xfc\xfe': u'\u6dc6',
'\xfd\xa1': u'\u723b',
'\xfd\xa2': u'\u80b4',
'\xfd\xa3': u'\u9175',
'\xfd\xa4': u'\u9a4d',
'\xfd\xa5': u'\u4faf',
'\xfd\xa6': u'\u5019',
'\xfd\xa7': u'\u539a',
'\xfd\xa8': u'\u540e',
'\xfd\xa9': u'\u543c',
'\xfd\xaa': u'\u5589',
'\xfd\xab': u'\u55c5',
'\xfd\xac': u'\u5e3f',
'\xfd\xad': u'\u5f8c',
'\xfd\xae': u'\u673d',
'\xfd\xaf': u'\u7166',
'\xfd\xb0': u'\u73dd',
'\xfd\xb1': u'\u9005',
'\xfd\xb2': u'\u52db',
'\xfd\xb3': u'\u52f3',
'\xfd\xb4': u'\u5864',
'\xfd\xb5': u'\u58ce',
'\xfd\xb6': u'\u7104',
'\xfd\xb7': u'\u718f',
'\xfd\xb8': u'\u71fb',
'\xfd\xb9': u'\u85b0',
'\xfd\xba': u'\u8a13',
'\xfd\xbb': u'\u6688',
'\xfd\xbc': u'\u85a8',
'\xfd\xbd': u'\u55a7',
'\xfd\xbe': u'\u6684',
'\xfd\xbf': u'\u714a',
'\xfd\xc0': u'\u8431',
'\xfd\xc1': u'\u5349',
'\xfd\xc2': u'\u5599',
'\xfd\xc3': u'\u6bc1',
'\xfd\xc4': u'\u5f59',
'\xfd\xc5': u'\u5fbd',
'\xfd\xc6': u'\u63ee',
'\xfd\xc7': u'\u6689',
'\xfd\xc8': u'\u7147',
'\xfd\xc9': u'\u8af1',
'\xfd\xca': u'\u8f1d',
'\xfd\xcb': u'\u9ebe',
'\xfd\xcc': u'\u4f11',
'\xfd\xcd': u'\u643a',
'\xfd\xce': u'\u70cb',
'\xfd\xcf': u'\u7566',
'\xfd\xd0': u'\u8667',
'\xfd\xd1': u'\u6064',
'\xfd\xd2': u'\u8b4e',
'\xfd\xd3': u'\u9df8',
'\xfd\xd4': u'\u5147',
'\xfd\xd5': u'\u51f6',
'\xfd\xd6': u'\u5308',
'\xfd\xd7': u'\u6d36',
'\xfd\xd8': u'\u80f8',
'\xfd\xd9': u'\u9ed1',
'\xfd\xda': u'\u6615',
'\xfd\xdb': u'\u6b23',
'\xfd\xdc': u'\u7098',
'\xfd\xdd': u'\u75d5',
'\xfd\xde': u'\u5403',
'\xfd\xdf': u'\u5c79',
'\xfd\xe0': u'\u7d07',
'\xfd\xe1': u'\u8a16',
'\xfd\xe2': u'\u6b20',
'\xfd\xe3': u'\u6b3d',
'\xfd\xe4': u'\u6b46',
'\xfd\xe5': u'\u5438',
'\xfd\xe6': u'\u6070',
'\xfd\xe7': u'\u6d3d',
'\xfd\xe8': u'\u7fd5',
'\xfd\xe9': u'\u8208',
'\xfd\xea': u'\u50d6',
'\xfd\xeb': u'\u51de',
'\xfd\xec': u'\u559c',
'\xfd\xed': u'\u566b',
'\xfd\xee': u'\u56cd',
'\xfd\xef': u'\u59ec',
'\xfd\xf0': u'\u5b09',
'\xfd\xf1': u'\u5e0c',
'\xfd\xf2': u'\u6199',
'\xfd\xf3': u'\u6198',
'\xfd\xf4': u'\u6231',
'\xfd\xf5': u'\u665e',
'\xfd\xf6': u'\u66e6',
'\xfd\xf7': u'\u7199',
'\xfd\xf8': u'\u71b9',
'\xfd\xf9': u'\u71ba',
'\xfd\xfa': u'\u72a7',
'\xfd\xfb': u'\u79a7',
'\xfd\xfc': u'\u7a00',
'\xfd\xfd': u'\u7fb2',
'\xfd\xfe': u'\u8a70',
}

encoding_map = {}
for k, v in decoding_map.items():
    encoding_map[v] = k
